from sqlalchemy import (
    Column, Date, DateTime, Float, Integer, String, distinct, func
)
from sqlalchemy.ext.declarative import declarative_base

from recipe import *

oven = get_oven('sqlite://')
Base = declarative_base(bind=oven.engine)

TABLEDEF = '''
        CREATE TABLE IF NOT EXISTS foo
        (first text,
         last text,
         age int,
         birth_date date,
         dt datetime);
'''

oven.engine.execute(TABLEDEF)
oven.engine.execute(
    "insert into foo values ('hi', 'there', 5, '2000-01-01', '2000-01-01 12:15:00'), ('hi', 'fred', 10, '2015-05-15', '2013-10-15 05:20:10')"  # noqa: E501
)

# Create a table for testing summarization
TABLEDEF = '''
        CREATE TABLE IF NOT EXISTS scores
        (username text,
         department text,
         testid text,
         score float);
'''

oven.engine.execute(TABLEDEF)
oven.engine.execute(
    """insert into scores values
('chris', 'sales', '1', 80),
('chip', 'ops', '2', 80),
('chip', 'ops', '3', 90),
('chip', 'ops', '4', 100),
('annika', 'ops', '5', 80),
('annika', 'ops', '6', 90)
"""
)

# Create a table for denormalized tables with tags
TABLEDEF = '''
        CREATE TABLE IF NOT EXISTS tagscores
        (username text,
         tag text,
         department text,
         testid text,
         score float);
'''

oven.engine.execute(TABLEDEF)
oven.engine.execute(
    """insert into tagscores values
('chris', 'individual', 'sales', '1', 80),
('chris', 'manager', 'sales', '1', 80),
('chip', 'individual', 'ops', '2', 80),
('chip', 'individual', 'ops', '3', 90),
('chip', 'individual', 'ops', '4', 100),
('chip', 'musician', 'ops', '2', 80),
('chip', 'musician', 'ops', '3', 90),
('chip', 'musician', 'ops', '4', 100),
('annika', 'individual', 'ops', '5', 80),
('annika', 'individual', 'ops', '6', 90)
"""
)

oven.engine.execute(
    """CREATE TABLE IF NOT EXISTS census
(state text, gender text, age integer, pop2000 integer, pop2008 integer);"""
)
oven.engine.execute(
    """INSERT INTO CENSUS values
('Alabama', 'M', 0, 30479, 32055),
('Alabama', 'M', 1, 29904, 32321),
('Alabama', 'M', 2, 30065, 31789),
('Alabama', 'M', 3, 29932, 31371),
('Alabama', 'M', 4, 30319, 31164),
('Alabama', 'M', 5, 31127, 31049),
('Alabama', 'M', 6, 31466, 30960),
('Alabama', 'M', 7, 32287, 32459),
('Alabama', 'M', 8, 32497, 31586),
('Alabama', 'M', 9, 33361, 30975),
('Alabama', 'M', 10, 34488, 31126),
('Alabama', 'M', 11, 32884, 31006),
('Alabama', 'M', 12, 32417, 31283),
('Alabama', 'M', 13, 32621, 32076),
('Alabama', 'M', 14, 32644, 32309),
('Alabama', 'M', 15, 33070, 33061),
('Alabama', 'M', 16, 32544, 33132),
('Alabama', 'M', 17, 32822, 33595),
('Alabama', 'M', 18, 32881, 34384),
('Alabama', 'M', 19, 33201, 32177),
('Alabama', 'M', 20, 33175, 31200),
('Alabama', 'M', 21, 31231, 31046),
('Alabama', 'M', 22, 29859, 32074),
('Alabama', 'M', 23, 29439, 32230),
('Alabama', 'M', 24, 27663, 31290),
('Alabama', 'M', 25, 28665, 31284),
('Alabama', 'M', 26, 27853, 30891),
('Alabama', 'M', 27, 28485, 32350),
('Alabama', 'M', 28, 29964, 33495),
('Alabama', 'M', 29, 31203, 31501),
('Alabama', 'M', 30, 30971, 28948),
('Alabama', 'M', 31, 29422, 28659),
('Alabama', 'M', 32, 27952, 26813),
('Alabama', 'M', 33, 28423, 28315),
('Alabama', 'M', 34, 29791, 27749),
('Alabama', 'M', 35, 32084, 28308),
('Alabama', 'M', 36, 32652, 29766),
('Alabama', 'M', 37, 32419, 31536),
('Alabama', 'M', 38, 32784, 31054),
('Alabama', 'M', 39, 33340, 29667),
('Alabama', 'M', 40, 34262, 28419),
('Alabama', 'M', 41, 32941, 28704),
('Alabama', 'M', 42, 33566, 30098),
('Alabama', 'M', 43, 33778, 32459),
('Alabama', 'M', 44, 32627, 33018),
('Alabama', 'M', 45, 32728, 32473),
('Alabama', 'M', 46, 31404, 32937),
('Alabama', 'M', 47, 30339, 33314),
('Alabama', 'M', 48, 29491, 33747),
('Alabama', 'M', 49, 29186, 32654),
('Alabama', 'M', 50, 29429, 32863),
('Alabama', 'M', 51, 29015, 32924),
('Alabama', 'M', 52, 28811, 31640),
('Alabama', 'M', 53, 29978, 31831),
('Alabama', 'M', 54, 22420, 30310),
('Alabama', 'M', 55, 22560, 29266),
('Alabama', 'M', 56, 22803, 28349),
('Alabama', 'M', 57, 23112, 27794),
('Alabama', 'M', 58, 20387, 27765),
('Alabama', 'M', 59, 19376, 27166),
('Alabama', 'M', 60, 19321, 27051),
('Alabama', 'M', 61, 18044, 27867),
('Alabama', 'M', 62, 18131, 20557),
('Alabama', 'M', 63, 16876, 20600),
('Alabama', 'M', 64, 16850, 20718),
('Alabama', 'M', 65, 16815, 20750),
('Alabama', 'M', 66, 15424, 18006),
('Alabama', 'M', 67, 15259, 17225),
('Alabama', 'M', 68, 14753, 16744),
('Alabama', 'M', 69, 14054, 15269),
('Alabama', 'M', 70, 14042, 15133),
('Alabama', 'M', 71, 12972, 13731),
('Alabama', 'M', 72, 12931, 13453),
('Alabama', 'M', 73, 12366, 13244),
('Alabama', 'M', 74, 11317, 11790),
('Alabama', 'M', 75, 10724, 11315),
('Alabama', 'M', 76, 9941, 10637),
('Alabama', 'M', 77, 9263, 9848),
('Alabama', 'M', 78, 8651, 9545),
('Alabama', 'M', 79, 7891, 8550),
('Alabama', 'M', 80, 7515, 8151),
('Alabama', 'M', 81, 5965, 7537),
('Alabama', 'M', 82, 5188, 6494),
('Alabama', 'M', 83, 4732, 6012),
('Alabama', 'M', 84, 4066, 5295),
('Alabama', 'M', 85, 18259, 26100),
('Alabama', 'F', 0, 29131, 30600),
('Alabama', 'F', 1, 28725, 30809),
('Alabama', 'F', 2, 28883, 30328),
('Alabama', 'F', 3, 28846, 29979),
('Alabama', 'F', 4, 29052, 30088),
('Alabama', 'F', 5, 29440, 29308),
('Alabama', 'F', 6, 29869, 30124),
('Alabama', 'F', 7, 30651, 30986),
('Alabama', 'F', 8, 30905, 30005),
('Alabama', 'F', 9, 31673, 29528),
('Alabama', 'F', 10, 32403, 29685),
('Alabama', 'F', 11, 31199, 29734),
('Alabama', 'F', 12, 30636, 30031),
('Alabama', 'F', 13, 30688, 30418),
('Alabama', 'F', 14, 31173, 30809),
('Alabama', 'F', 15, 31485, 31678),
('Alabama', 'F', 16, 31117, 31882),
('Alabama', 'F', 17, 31293, 32563),
('Alabama', 'F', 18, 32194, 33184),
('Alabama', 'F', 19, 34032, 32265),
('Alabama', 'F', 20, 33875, 32032),
('Alabama', 'F', 21, 32373, 31687),
('Alabama', 'F', 22, 31089, 31942),
('Alabama', 'F', 23, 29888, 31982),
('Alabama', 'F', 24, 28464, 30979),
('Alabama', 'F', 25, 29163, 31011),
('Alabama', 'F', 26, 28733, 30453),
('Alabama', 'F', 27, 29475, 33629),
('Alabama', 'F', 28, 30669, 32848),
('Alabama', 'F', 29, 32303, 31421),
('Alabama', 'F', 30, 31894, 30296),
('Alabama', 'F', 31, 29914, 28955),
('Alabama', 'F', 32, 29441, 27975),
('Alabama', 'F', 33, 29924, 28593),
('Alabama', 'F', 34, 31383, 28755),
('Alabama', 'F', 35, 33839, 29873),
('Alabama', 'F', 36, 34156, 30597),
('Alabama', 'F', 37, 34342, 32951),
('Alabama', 'F', 38, 34792, 32252),
('Alabama', 'F', 39, 35391, 30055),
('Alabama', 'F', 40, 35758, 29999),
('Alabama', 'F', 41, 35500, 30240),
('Alabama', 'F', 42, 35663, 31693),
('Alabama', 'F', 43, 35821, 34069),
('Alabama', 'F', 44, 34222, 34214),
('Alabama', 'F', 45, 34545, 34576),
('Alabama', 'F', 46, 33798, 35078),
('Alabama', 'F', 47, 32171, 35448),
('Alabama', 'F', 48, 31609, 35354),
('Alabama', 'F', 49, 30645, 35201),
('Alabama', 'F', 50, 31146, 35478),
('Alabama', 'F', 51, 30590, 35627),
('Alabama', 'F', 52, 30340, 34049),
('Alabama', 'F', 53, 31446, 33962),
('Alabama', 'F', 54, 24228, 33347),
('Alabama', 'F', 55, 24341, 31946),
('Alabama', 'F', 56, 24369, 31255),
('Alabama', 'F', 57, 25431, 30346),
('Alabama', 'F', 58, 22554, 30487),
('Alabama', 'F', 59, 21550, 30066),
('Alabama', 'F', 60, 21353, 29669),
('Alabama', 'F', 61, 20543, 30571),
('Alabama', 'F', 62, 20652, 23373),
('Alabama', 'F', 63, 19454, 23338),
('Alabama', 'F', 64, 19452, 23446),
('Alabama', 'F', 65, 19613, 24082),
('Alabama', 'F', 66, 17959, 21319),
('Alabama', 'F', 67, 18025, 20032),
('Alabama', 'F', 68, 18023, 19847),
('Alabama', 'F', 69, 17773, 18751),
('Alabama', 'F', 70, 17865, 18784),
('Alabama', 'F', 71, 16956, 17392),
('Alabama', 'F', 72, 17348, 16921),
('Alabama', 'F', 73, 16840, 17116),
('Alabama', 'F', 74, 15992, 15290),
('Alabama', 'F', 75, 15736, 15104),
('Alabama', 'F', 76, 15057, 14613),
('Alabama', 'F', 77, 14375, 14329),
('Alabama', 'F', 78, 13748, 14129),
('Alabama', 'F', 79, 13066, 12975),
('Alabama', 'F', 80, 12789, 13157),
('Alabama', 'F', 81, 10680, 12211),
('Alabama', 'F', 82, 9453, 11112),
('Alabama', 'F', 83, 9448, 10825),
('Alabama', 'F', 84, 8418, 9870),
('Alabama', 'F', 85, 49764, 58979),
('Alaska', 'M', 0, 4934, 5674),
('Alaska', 'M', 1, 4785, 5498),
('Alaska', 'M', 2, 4774, 5287),
('Alaska', 'M', 3, 4899, 5110),
('Alaska', 'M', 4, 4966, 4992),
('Alaska', 'M', 5, 5122, 4989),
('Alaska', 'M', 6, 5158, 4871),
('Alaska', 'M', 7, 5471, 5133),
('Alaska', 'M', 8, 5707, 4917),
('Alaska', 'M', 9, 5866, 4815),
('Alaska', 'M', 10, 5986, 4716),
('Alaska', 'M', 11, 5778, 4871),
('Alaska', 'M', 12, 5706, 4860),
('Alaska', 'M', 13, 5736, 5045),
('Alaska', 'M', 14, 5887, 4997),
('Alaska', 'M', 15, 5790, 5285),
('Alaska', 'M', 16, 5579, 5539),
('Alaska', 'M', 17, 5642, 5799),
('Alaska', 'M', 18, 4806, 5372),
('Alaska', 'M', 19, 3817, 4418),
('Alaska', 'M', 20, 3592, 4419),
('Alaska', 'M', 21, 3349, 4768),
('Alaska', 'M', 22, 3344, 5230),
('Alaska', 'M', 23, 3353, 5402),
('Alaska', 'M', 24, 3325, 5626),
('Alaska', 'M', 25, 3611, 5823),
('Alaska', 'M', 26, 3361, 5581),
('Alaska', 'M', 27, 3683, 5387),
('Alaska', 'M', 28, 3714, 5331),
('Alaska', 'M', 29, 4016, 4652),
('Alaska', 'M', 30, 4475, 4651),
('Alaska', 'M', 31, 4094, 4264),
('Alaska', 'M', 32, 4044, 4358),
('Alaska', 'M', 33, 4192, 4254),
('Alaska', 'M', 34, 4449, 4154),
('Alaska', 'M', 35, 4807, 4296),
('Alaska', 'M', 36, 5111, 4568),
('Alaska', 'M', 37, 5076, 4298),
('Alaska', 'M', 38, 5247, 4775),
('Alaska', 'M', 39, 5521, 4405),
('Alaska', 'M', 40, 5725, 4349),
('Alaska', 'M', 41, 5475, 4235),
('Alaska', 'M', 42, 5835, 4609),
('Alaska', 'M', 43, 5912, 4710),
('Alaska', 'M', 44, 5770, 5173),
('Alaska', 'M', 45, 5865, 4982),
('Alaska', 'M', 46, 5792, 5283),
('Alaska', 'M', 47, 5656, 5261),
('Alaska', 'M', 48, 5286, 5690),
('Alaska', 'M', 49, 5154, 5270),
('Alaska', 'M', 50, 5253, 5612),
('Alaska', 'M', 51, 4750, 5606),
('Alaska', 'M', 52, 4452, 5362),
('Alaska', 'M', 53, 4643, 5464),
('Alaska', 'M', 54, 3299, 5309),
('Alaska', 'M', 55, 3347, 5220),
('Alaska', 'M', 56, 3151, 4852),
('Alaska', 'M', 57, 3105, 4565),
('Alaska', 'M', 58, 2673, 4586),
('Alaska', 'M', 59, 2473, 4165),
('Alaska', 'M', 60, 2223, 3828),
('Alaska', 'M', 61, 1945, 4110),
('Alaska', 'M', 62, 1880, 2713),
('Alaska', 'M', 63, 1671, 2834),
('Alaska', 'M', 64, 1520, 2466),
('Alaska', 'M', 65, 1535, 2526),
('Alaska', 'M', 66, 1349, 2098),
('Alaska', 'M', 67, 1223, 1965),
('Alaska', 'M', 68, 1166, 1750),
('Alaska', 'M', 69, 1150, 1487),
('Alaska', 'M', 70, 1183, 1457),
('Alaska', 'M', 71, 1053, 1284),
('Alaska', 'M', 72, 995, 1134),
('Alaska', 'M', 73, 883, 1162),
('Alaska', 'M', 74, 799, 1011),
('Alaska', 'M', 75, 745, 869),
('Alaska', 'M', 76, 686, 814),
('Alaska', 'M', 77, 644, 785),
('Alaska', 'M', 78, 559, 838),
('Alaska', 'M', 79, 470, 681),
('Alaska', 'M', 80, 441, 648),
('Alaska', 'M', 81, 350, 568),
('Alaska', 'M', 82, 310, 469),
('Alaska', 'M', 83, 236, 424),
('Alaska', 'M', 84, 217, 391),
('Alaska', 'M', 85, 923, 1748),
('Alaska', 'F', 0, 4509, 5453),
('Alaska', 'F', 1, 4602, 5387),
('Alaska', 'F', 2, 4647, 4916),
('Alaska', 'F', 3, 4547, 4874),
('Alaska', 'F', 4, 4838, 4892),
('Alaska', 'F', 5, 4877, 4665),
('Alaska', 'F', 6, 5031, 4745),
('Alaska', 'F', 7, 5095, 4687),
('Alaska', 'F', 8, 5390, 4397),
('Alaska', 'F', 9, 5671, 4432),
('Alaska', 'F', 10, 5721, 4624),
('Alaska', 'F', 11, 5486, 4426),
('Alaska', 'F', 12, 5565, 4696),
('Alaska', 'F', 13, 5398, 4751),
('Alaska', 'F', 14, 5447, 4930),
('Alaska', 'F', 15, 5465, 4953),
('Alaska', 'F', 16, 5090, 5121),
('Alaska', 'F', 17, 5155, 5522),
('Alaska', 'F', 18, 4155, 4797),
('Alaska', 'F', 19, 3688, 3730),
('Alaska', 'F', 20, 3700, 3940),
('Alaska', 'F', 21, 3476, 4004),
('Alaska', 'F', 22, 3516, 4501),
('Alaska', 'F', 23, 3577, 5002),
('Alaska', 'F', 24, 3555, 4628),
('Alaska', 'F', 25, 3852, 5305),
('Alaska', 'F', 26, 3811, 4729),
('Alaska', 'F', 27, 3913, 5308),
('Alaska', 'F', 28, 3986, 5238),
('Alaska', 'F', 29, 4423, 4934),
('Alaska', 'F', 30, 4447, 4749),
('Alaska', 'F', 31, 4317, 4177),
('Alaska', 'F', 32, 4264, 4404),
('Alaska', 'F', 33, 4344, 4141),
('Alaska', 'F', 34, 4514, 4111),
('Alaska', 'F', 35, 4970, 4359),
('Alaska', 'F', 36, 5095, 4193),
('Alaska', 'F', 37, 5425, 4753),
('Alaska', 'F', 38, 5522, 4552),
('Alaska', 'F', 39, 5630, 4418),
('Alaska', 'F', 40, 5709, 4165),
('Alaska', 'F', 41, 5541, 4545),
('Alaska', 'F', 42, 5749, 4372),
('Alaska', 'F', 43, 5833, 4868),
('Alaska', 'F', 44, 5542, 5017),
('Alaska', 'F', 45, 5682, 5269),
('Alaska', 'F', 46, 5310, 5434),
('Alaska', 'F', 47, 5204, 5494),
('Alaska', 'F', 48, 4906, 5636),
('Alaska', 'F', 49, 4499, 5291),
('Alaska', 'F', 50, 4429, 5659),
('Alaska', 'F', 51, 4124, 5598),
('Alaska', 'F', 52, 3776, 5136),
('Alaska', 'F', 53, 3970, 5334),
('Alaska', 'F', 54, 2955, 4856),
('Alaska', 'F', 55, 2950, 4840),
('Alaska', 'F', 56, 2718, 4582),
('Alaska', 'F', 57, 2675, 4051),
('Alaska', 'F', 58, 2348, 3930),
('Alaska', 'F', 59, 2081, 3687),
('Alaska', 'F', 60, 1898, 3343),
('Alaska', 'F', 61, 1689, 3603),
('Alaska', 'F', 62, 1634, 2556),
('Alaska', 'F', 63, 1517, 2562),
('Alaska', 'F', 64, 1407, 2313),
('Alaska', 'F', 65, 1428, 2311),
('Alaska', 'F', 66, 1289, 2003),
('Alaska', 'F', 67, 1266, 1799),
('Alaska', 'F', 68, 1124, 1574),
('Alaska', 'F', 69, 1202, 1393),
('Alaska', 'F', 70, 1185, 1378),
('Alaska', 'F', 71, 1063, 1251),
('Alaska', 'F', 72, 961, 1191),
('Alaska', 'F', 73, 948, 1202),
('Alaska', 'F', 74, 906, 1082),
('Alaska', 'F', 75, 895, 1033),
('Alaska', 'F', 76, 813, 933),
('Alaska', 'F', 77, 768, 959),
('Alaska', 'F', 78, 693, 956),
('Alaska', 'F', 79, 668, 835),
('Alaska', 'F', 80, 562, 680),
('Alaska', 'F', 81, 443, 701),
('Alaska', 'F', 82, 451, 648),
('Alaska', 'F', 83, 394, 624),
('Alaska', 'F', 84, 362, 519),
('Alaska', 'F', 85, 1762, 3096),
('Arizona', 'M', 0, 40415, 54792),
('Arizona', 'M', 1, 39228, 54029),
('Arizona', 'M', 2, 39212, 52591),
('Arizona', 'M', 3, 38916, 51355),
('Arizona', 'M', 4, 39110, 50827),
('Arizona', 'M', 5, 39650, 50082),
('Arizona', 'M', 6, 38953, 48977),
('Arizona', 'M', 7, 40152, 49406),
('Arizona', 'M', 8, 40408, 46495),
('Arizona', 'M', 9, 40753, 45374),
('Arizona', 'M', 10, 41617, 45579),
('Arizona', 'M', 11, 39516, 45538),
('Arizona', 'M', 12, 38700, 45687),
('Arizona', 'M', 13, 38065, 46333),
('Arizona', 'M', 14, 38005, 45276),
('Arizona', 'M', 15, 37883, 46672),
('Arizona', 'M', 16, 36966, 46755),
('Arizona', 'M', 17, 37784, 47176),
('Arizona', 'M', 18, 38465, 46328),
('Arizona', 'M', 19, 39094, 42349),
('Arizona', 'M', 20, 39150, 42088),
('Arizona', 'M', 21, 37301, 42750),
('Arizona', 'M', 22, 36865, 44831),
('Arizona', 'M', 23, 37183, 46231),
('Arizona', 'M', 24, 36895, 47512),
('Arizona', 'M', 25, 38562, 49851),
('Arizona', 'M', 26, 36932, 50193),
('Arizona', 'M', 27, 37282, 51645),
('Arizona', 'M', 28, 38762, 51906),
('Arizona', 'M', 29, 40690, 49644),
('Arizona', 'M', 30, 41499, 47549),
('Arizona', 'M', 31, 38215, 46967),
('Arizona', 'M', 32, 37145, 45784),
('Arizona', 'M', 33, 36225, 45697),
('Arizona', 'M', 34, 36814, 43775),
('Arizona', 'M', 35, 39733, 44041),
('Arizona', 'M', 36, 39417, 45405),
('Arizona', 'M', 37, 39077, 47012),
('Arizona', 'M', 38, 39778, 47546),
('Arizona', 'M', 39, 39073, 43569),
('Arizona', 'M', 40, 40754, 42707),
('Arizona', 'M', 41, 37888, 41609),
('Arizona', 'M', 42, 38036, 41813),
('Arizona', 'M', 43, 36931, 45594),
('Arizona', 'M', 44, 35402, 44771),
('Arizona', 'M', 45, 35975, 43751),
('Arizona', 'M', 46, 33790, 44700),
('Arizona', 'M', 47, 32485, 43154),
('Arizona', 'M', 48, 31574, 45062),
('Arizona', 'M', 49, 31024, 41739),
('Arizona', 'M', 50, 31477, 42078),
('Arizona', 'M', 51, 29981, 40628),
('Arizona', 'M', 52, 30041, 38975),
('Arizona', 'M', 53, 31054, 39359),
('Arizona', 'M', 54, 23718, 37151),
('Arizona', 'M', 55, 24311, 36186),
('Arizona', 'M', 56, 23674, 34972),
('Arizona', 'M', 57, 24398, 34442),
('Arizona', 'M', 58, 21933, 35007),
('Arizona', 'M', 59, 20409, 33847),
('Arizona', 'M', 60, 20572, 34418),
('Arizona', 'M', 61, 19693, 34125),
('Arizona', 'M', 62, 19766, 26916),
('Arizona', 'M', 63, 18922, 27189),
('Arizona', 'M', 64, 18868, 26970),
('Arizona', 'M', 65, 19329, 27211),
('Arizona', 'M', 66, 17666, 24406),
('Arizona', 'M', 67, 17983, 22388),
('Arizona', 'M', 68, 17748, 22189),
('Arizona', 'M', 69, 17723, 20642),
('Arizona', 'M', 70, 18239, 20151),
('Arizona', 'M', 71, 16551, 18764),
('Arizona', 'M', 72, 16324, 18112),
('Arizona', 'M', 73, 15470, 18236),
('Arizona', 'M', 74, 15205, 16102),
('Arizona', 'M', 75, 14614, 16201),
('Arizona', 'M', 76, 13498, 15597),
('Arizona', 'M', 77, 12563, 15112),
('Arizona', 'M', 78, 11941, 15492),
('Arizona', 'M', 79, 11251, 13457),
('Arizona', 'M', 80, 9981, 13149),
('Arizona', 'M', 81, 8383, 11785),
('Arizona', 'M', 82, 7880, 11461),
('Arizona', 'M', 83, 6674, 10432),
('Arizona', 'M', 84, 5781, 9276),
('Arizona', 'M', 85, 23493, 47368),
('Arizona', 'F', 0, 38644, 52059),
('Arizona', 'F', 1, 37943, 51917),
('Arizona', 'F', 2, 36667, 49739),
('Arizona', 'F', 3, 37219, 50073),
('Arizona', 'F', 4, 37488, 48528),
('Arizona', 'F', 5, 37645, 48140),
('Arizona', 'F', 6, 37725, 47392),
('Arizona', 'F', 7, 38201, 47442),
('Arizona', 'F', 8, 38415, 44441),
('Arizona', 'F', 9, 38809, 44108),
('Arizona', 'F', 10, 39378, 42689),
('Arizona', 'F', 11, 37389, 43450),
('Arizona', 'F', 12, 36855, 43754),
('Arizona', 'F', 13, 36255, 43782),
('Arizona', 'F', 14, 36092, 43703),
('Arizona', 'F', 15, 35698, 44241),
('Arizona', 'F', 16, 34343, 44175),
('Arizona', 'F', 17, 35034, 44632),
('Arizona', 'F', 18, 36085, 42076),
('Arizona', 'F', 19, 36501, 39006),
('Arizona', 'F', 20, 36678, 38213),
('Arizona', 'F', 21, 34121, 38006),
('Arizona', 'F', 22, 33581, 40498),
('Arizona', 'F', 23, 34358, 42771),
('Arizona', 'F', 24, 33580, 42902),
('Arizona', 'F', 25, 35373, 43238),
('Arizona', 'F', 26, 34271, 46416),
('Arizona', 'F', 27, 34479, 46744),
('Arizona', 'F', 28, 36066, 47740),
('Arizona', 'F', 29, 37889, 46236),
('Arizona', 'F', 30, 38453, 43535),
('Arizona', 'F', 31, 35389, 43121),
('Arizona', 'F', 32, 34602, 41398),
('Arizona', 'F', 33, 34102, 42630),
('Arizona', 'F', 34, 34928, 41333),
('Arizona', 'F', 35, 38157, 41200),
('Arizona', 'F', 36, 38590, 42821),
('Arizona', 'F', 37, 38359, 44610),
('Arizona', 'F', 38, 39059, 44535),
('Arizona', 'F', 39, 38826, 41006),
('Arizona', 'F', 40, 39733, 40482),
('Arizona', 'F', 41, 37758, 39656),
('Arizona', 'F', 42, 37885, 40538),
('Arizona', 'F', 43, 37210, 43880),
('Arizona', 'F', 44, 35827, 44436),
('Arizona', 'F', 45, 35948, 43643),
('Arizona', 'F', 46, 35270, 44797),
('Arizona', 'F', 47, 33799, 44326),
('Arizona', 'F', 48, 32925, 45008),
('Arizona', 'F', 49, 32205, 43058),
('Arizona', 'F', 50, 32638, 43345),
('Arizona', 'F', 51, 31556, 42288),
('Arizona', 'F', 52, 31568, 40643),
('Arizona', 'F', 53, 32841, 41016),
('Arizona', 'F', 54, 25268, 40317),
('Arizona', 'F', 55, 25982, 38803),
('Arizona', 'F', 56, 25914, 38152),
('Arizona', 'F', 57, 27099, 37417),
('Arizona', 'F', 58, 24760, 38006),
('Arizona', 'F', 59, 22769, 36999),
('Arizona', 'F', 60, 22799, 37440),
('Arizona', 'F', 61, 21758, 37525),
('Arizona', 'F', 62, 21393, 29368),
('Arizona', 'F', 63, 21048, 30009),
('Arizona', 'F', 64, 20679, 29962),
('Arizona', 'F', 65, 20972, 30696),
('Arizona', 'F', 66, 19488, 27837),
('Arizona', 'F', 67, 19500, 25328),
('Arizona', 'F', 68, 19451, 25077),
('Arizona', 'F', 69, 19479, 23309),
('Arizona', 'F', 70, 20008, 22260),
('Arizona', 'F', 71, 18471, 21643),
('Arizona', 'F', 72, 18775, 20572),
('Arizona', 'F', 73, 18387, 20579),
('Arizona', 'F', 74, 17980, 19009),
('Arizona', 'F', 75, 17984, 18628),
('Arizona', 'F', 76, 17207, 18346),
('Arizona', 'F', 77, 16017, 17848),
('Arizona', 'F', 78, 15484, 18210),
('Arizona', 'F', 79, 14543, 16360),
('Arizona', 'F', 80, 12953, 16290),
('Arizona', 'F', 81, 11709, 15520),
('Arizona', 'F', 82, 11162, 14670),
('Arizona', 'F', 83, 9318, 14179),
('Arizona', 'F', 84, 8593, 13064),
('Arizona', 'F', 85, 46108, 75617),
('Arkansas', 'M', 0, 18616, 21165),
('Arkansas', 'M', 1, 18353, 21400),
('Arkansas', 'M', 2, 18626, 20379),
('Arkansas', 'M', 3, 18534, 20227),
('Arkansas', 'M', 4, 18437, 19831),
('Arkansas', 'M', 5, 18309, 19883),
('Arkansas', 'M', 6, 18428, 19740),
('Arkansas', 'M', 7, 19009, 19896),
('Arkansas', 'M', 8, 19585, 19477),
('Arkansas', 'M', 9, 20120, 19142),
('Arkansas', 'M', 10, 20339, 19355),
('Arkansas', 'M', 11, 19869, 19371),
('Arkansas', 'M', 12, 19904, 19362),
('Arkansas', 'M', 13, 19529, 19240),
('Arkansas', 'M', 14, 19982, 19286),
('Arkansas', 'M', 15, 20357, 19839),
('Arkansas', 'M', 16, 20528, 20515),
('Arkansas', 'M', 17, 20715, 20962),
('Arkansas', 'M', 18, 20177, 20090),
('Arkansas', 'M', 19, 20530, 19566),
('Arkansas', 'M', 20, 20111, 18905),
('Arkansas', 'M', 21, 18692, 18445),
('Arkansas', 'M', 22, 17989, 18846),
('Arkansas', 'M', 23, 17577, 18763),
('Arkansas', 'M', 24, 17153, 19005),
('Arkansas', 'M', 25, 17413, 19481),
('Arkansas', 'M', 26, 17089, 19033),
('Arkansas', 'M', 27, 17165, 20975),
('Arkansas', 'M', 28, 17457, 21487),
('Arkansas', 'M', 29, 18580, 19707),
('Arkansas', 'M', 30, 18406, 18607),
('Arkansas', 'M', 31, 17500, 18286),
('Arkansas', 'M', 32, 16933, 17622),
('Arkansas', 'M', 33, 16729, 17374),
('Arkansas', 'M', 34, 17652, 17510),
('Arkansas', 'M', 35, 19334, 17825),
('Arkansas', 'M', 36, 19655, 17840),
('Arkansas', 'M', 37, 19551, 19066),
('Arkansas', 'M', 38, 19445, 18814),
('Arkansas', 'M', 39, 19847, 17884),
('Arkansas', 'M', 40, 20029, 17329),
('Arkansas', 'M', 41, 19519, 17089),
('Arkansas', 'M', 42, 19588, 18160),
('Arkansas', 'M', 43, 19535, 19600),
('Arkansas', 'M', 44, 18873, 19956),
('Arkansas', 'M', 45, 18742, 20159),
('Arkansas', 'M', 46, 18415, 19718),
('Arkansas', 'M', 47, 17829, 19994),
('Arkansas', 'M', 48, 17417, 20036),
('Arkansas', 'M', 49, 17005, 19447),
('Arkansas', 'M', 50, 17183, 19303),
('Arkansas', 'M', 51, 17082, 19366),
('Arkansas', 'M', 52, 16944, 18660),
('Arkansas', 'M', 53, 18009, 18565),
('Arkansas', 'M', 54, 13658, 18084),
('Arkansas', 'M', 55, 13934, 17587),
('Arkansas', 'M', 56, 13967, 17298),
('Arkansas', 'M', 57, 14186, 16764),
('Arkansas', 'M', 58, 13016, 16848),
('Arkansas', 'M', 59, 12272, 16750),
('Arkansas', 'M', 60, 12187, 16798),
('Arkansas', 'M', 61, 11153, 17289),
('Arkansas', 'M', 62, 11432, 13234),
('Arkansas', 'M', 63, 10621, 13427),
('Arkansas', 'M', 64, 10743, 13290),
('Arkansas', 'M', 65, 10654, 13314),
('Arkansas', 'M', 66, 10025, 11939),
('Arkansas', 'M', 67, 9613, 10991),
('Arkansas', 'M', 68, 9359, 10691),
('Arkansas', 'M', 69, 8961, 9633),
('Arkansas', 'M', 70, 8916, 9597),
('Arkansas', 'M', 71, 8352, 8677),
('Arkansas', 'M', 72, 8054, 8570),
('Arkansas', 'M', 73, 8235, 8227),
('Arkansas', 'M', 74, 7570, 7661),
('Arkansas', 'M', 75, 7462, 7159),
('Arkansas', 'M', 76, 6627, 6865),
('Arkansas', 'M', 77, 6286, 6340),
('Arkansas', 'M', 78, 5699, 6258),
('Arkansas', 'M', 79, 5460, 5680),
('Arkansas', 'M', 80, 5097, 5223),
('Arkansas', 'M', 81, 4278, 5213),
('Arkansas', 'M', 82, 3985, 4382),
('Arkansas', 'M', 83, 3331, 4286),
('Arkansas', 'M', 84, 2993, 3670),
('Arkansas', 'M', 85, 13758, 19337),
('Arkansas', 'F', 0, 17814, 20344),
('Arkansas', 'F', 1, 17664, 20526),
('Arkansas', 'F', 2, 17703, 19586),
('Arkansas', 'F', 3, 17762, 19520),
('Arkansas', 'F', 4, 17941, 19092),
('Arkansas', 'F', 5, 17651, 18542),
('Arkansas', 'F', 6, 17700, 19218),
('Arkansas', 'F', 7, 18164, 18676),
('Arkansas', 'F', 8, 18428, 18575),
('Arkansas', 'F', 9, 18866, 18408),
('Arkansas', 'F', 10, 19304, 18478),
('Arkansas', 'F', 11, 18669, 18490),
('Arkansas', 'F', 12, 18540, 18809),
('Arkansas', 'F', 13, 18722, 18545),
('Arkansas', 'F', 14, 18754, 18510),
('Arkansas', 'F', 15, 19088, 19080),
('Arkansas', 'F', 16, 19133, 19313),
('Arkansas', 'F', 17, 19227, 19698),
('Arkansas', 'F', 18, 19352, 19401),
('Arkansas', 'F', 19, 19975, 18525),
('Arkansas', 'F', 20, 19619, 17565),
('Arkansas', 'F', 21, 18554, 17767),
('Arkansas', 'F', 22, 18159, 18246),
('Arkansas', 'F', 23, 17226, 18647),
('Arkansas', 'F', 24, 16739, 18397),
('Arkansas', 'F', 25, 17132, 18198),
('Arkansas', 'F', 26, 16655, 18750),
('Arkansas', 'F', 27, 17044, 21393),
('Arkansas', 'F', 28, 17544, 21554),
('Arkansas', 'F', 29, 18535, 20025),
('Arkansas', 'F', 30, 18417, 19047),
('Arkansas', 'F', 31, 17458, 17473),
('Arkansas', 'F', 32, 17088, 17196),
('Arkansas', 'F', 33, 17028, 18082),
('Arkansas', 'F', 34, 17816, 17149),
('Arkansas', 'F', 35, 19522, 17660),
('Arkansas', 'F', 36, 20351, 18255),
('Arkansas', 'F', 37, 20412, 19298),
('Arkansas', 'F', 38, 19904, 19280),
('Arkansas', 'F', 39, 20350, 17985),
('Arkansas', 'F', 40, 20391, 17696),
('Arkansas', 'F', 41, 19943, 17663),
('Arkansas', 'F', 42, 19676, 18472),
('Arkansas', 'F', 43, 20405, 20254),
('Arkansas', 'F', 44, 19724, 20946),
('Arkansas', 'F', 45, 19661, 20849),
('Arkansas', 'F', 46, 19492, 20182),
('Arkansas', 'F', 47, 18373, 20569),
('Arkansas', 'F', 48, 18027, 20678),
('Arkansas', 'F', 49, 17804, 20009),
('Arkansas', 'F', 50, 17811, 19881),
('Arkansas', 'F', 51, 17758, 20534),
('Arkansas', 'F', 52, 17466, 19780),
('Arkansas', 'F', 53, 18951, 19902),
('Arkansas', 'F', 54, 14347, 19796),
('Arkansas', 'F', 55, 14885, 18652),
('Arkansas', 'F', 56, 14926, 18347),
('Arkansas', 'F', 57, 15190, 18162),
('Arkansas', 'F', 58, 14206, 18024),
('Arkansas', 'F', 59, 13627, 17972),
('Arkansas', 'F', 60, 13068, 17838),
('Arkansas', 'F', 61, 12640, 18919),
('Arkansas', 'F', 62, 12479, 14361),
('Arkansas', 'F', 63, 11665, 14757),
('Arkansas', 'F', 64, 11901, 14729),
('Arkansas', 'F', 65, 12051, 14771),
('Arkansas', 'F', 66, 11098, 13539),
('Arkansas', 'F', 67, 11295, 12768),
('Arkansas', 'F', 68, 10962, 11955),
('Arkansas', 'F', 69, 10838, 11429),
('Arkansas', 'F', 70, 10792, 11060),
('Arkansas', 'F', 71, 10348, 10122),
('Arkansas', 'F', 72, 10322, 10159),
('Arkansas', 'F', 73, 10243, 10221),
('Arkansas', 'F', 74, 10125, 9277),
('Arkansas', 'F', 75, 9786, 9271),
('Arkansas', 'F', 76, 9345, 8879),
('Arkansas', 'F', 77, 8794, 8589),
('Arkansas', 'F', 78, 8743, 8495),
('Arkansas', 'F', 79, 8425, 8056),
('Arkansas', 'F', 80, 8054, 7824),
('Arkansas', 'F', 81, 7121, 7521),
('Arkansas', 'F', 82, 6558, 7164),
('Arkansas', 'F', 83, 5980, 6723),
('Arkansas', 'F', 84, 5651, 6331),
('Arkansas', 'F', 85, 33198, 39338),
('California', 'M', 0, 252494, 287900),
('California', 'M', 1, 247978, 282445),
('California', 'M', 2, 250644, 274754),
('California', 'M', 3, 257443, 271675),
('California', 'M', 4, 266855, 267228),
('California', 'M', 5, 272801, 266225),
('California', 'M', 6, 274899, 258627),
('California', 'M', 7, 277580, 262541),
('California', 'M', 8, 283553, 245725),
('California', 'M', 9, 285478, 242608),
('California', 'M', 10, 284518, 245500),
('California', 'M', 11, 269009, 252214),
('California', 'M', 12, 262671, 261608),
('California', 'M', 13, 254889, 267712),
('California', 'M', 14, 253023, 270126),
('California', 'M', 15, 251962, 273041),
('California', 'M', 16, 249220, 279604),
('California', 'M', 17, 255482, 284538),
('California', 'M', 18, 252607, 294734),
('California', 'M', 19, 248356, 277848),
('California', 'M', 20, 250156, 273622),
('California', 'M', 21, 238235, 267866),
('California', 'M', 22, 235718, 271345),
('California', 'M', 23, 239698, 277993),
('California', 'M', 24, 240655, 278703),
('California', 'M', 25, 250964, 290319),
('California', 'M', 26, 245324, 284859),
('California', 'M', 27, 251413, 278270),
('California', 'M', 28, 260869, 275989),
('California', 'M', 29, 276142, 267622),
('California', 'M', 30, 293816, 264250),
('California', 'M', 31, 273159, 260297),
('California', 'M', 32, 268484, 258622),
('California', 'M', 33, 263472, 264805),
('California', 'M', 34, 269607, 257167),
('California', 'M', 35, 286895, 258728),
('California', 'M', 36, 284414, 266394),
('California', 'M', 37, 280861, 276500),
('California', 'M', 38, 281214, 292730),
('California', 'M', 39, 278802, 271720),
('California', 'M', 40, 290332, 265786),
('California', 'M', 41, 267684, 260739),
('California', 'M', 42, 268045, 263120),
('California', 'M', 43, 261885, 280827),
('California', 'M', 44, 252175, 278186),
('California', 'M', 45, 255340, 272385),
('California', 'M', 46, 239126, 273260),
('California', 'M', 47, 229057, 268194),
('California', 'M', 48, 219293, 279872),
('California', 'M', 49, 214700, 257097),
('California', 'M', 50, 219017, 257627),
('California', 'M', 51, 203068, 250421),
('California', 'M', 52, 200466, 238539),
('California', 'M', 53, 207237, 242364),
('California', 'M', 54, 160674, 225520),
('California', 'M', 55, 158483, 214785),
('California', 'M', 56, 150235, 204127),
('California', 'M', 57, 150046, 197302),
('California', 'M', 58, 133017, 200865),
('California', 'M', 59, 124106, 183657),
('California', 'M', 60, 121984, 179020),
('California', 'M', 61, 114331, 187556),
('California', 'M', 62, 110491, 141107),
('California', 'M', 63, 102859, 138822),
('California', 'M', 64, 99345, 129805),
('California', 'M', 65, 100052, 130427),
('California', 'M', 66, 91053, 114959),
('California', 'M', 67, 89634, 107496),
('California', 'M', 68, 88258, 105982),
('California', 'M', 69, 87840, 98304),
('California', 'M', 70, 88575, 95103),
('California', 'M', 71, 80843, 87180),
('California', 'M', 72, 79376, 83532),
('California', 'M', 73, 76365, 83449),
('California', 'M', 74, 73697, 73806),
('California', 'M', 75, 72885, 71553),
('California', 'M', 76, 69738, 68625),
('California', 'M', 77, 65865, 66463),
('California', 'M', 78, 62867, 66378),
('California', 'M', 79, 58012, 57916),
('California', 'M', 80, 51806, 55332),
('California', 'M', 81, 43254, 51309),
('California', 'M', 82, 40083, 47297),
('California', 'M', 83, 34144, 44749),
('California', 'M', 84, 30384, 40997),
('California', 'M', 85, 136442, 212175),
('California', 'F', 0, 239605, 274356),
('California', 'F', 1, 236543, 269140),
('California', 'F', 2, 240010, 262556),
('California', 'F', 3, 245739, 259061),
('California', 'F', 4, 254522, 255544),
('California', 'F', 5, 260264, 253899),
('California', 'F', 6, 261296, 247677),
('California', 'F', 7, 264083, 250117),
('California', 'F', 8, 270447, 233293),
('California', 'F', 9, 271482, 231261),
('California', 'F', 10, 270567, 235225),
('California', 'F', 11, 256656, 240906),
('California', 'F', 12, 249887, 249456),
('California', 'F', 13, 242724, 255296),
('California', 'F', 14, 240752, 256673),
('California', 'F', 15, 240170, 259496),
('California', 'F', 16, 233186, 266794),
('California', 'F', 17, 235767, 269445),
('California', 'F', 18, 234949, 285759),
('California', 'F', 19, 233477, 264961),
('California', 'F', 20, 233532, 257736),
('California', 'F', 21, 223990, 254077),
('California', 'F', 22, 222035, 258806),
('California', 'F', 23, 227742, 264302),
('California', 'F', 24, 228401, 260631),
('California', 'F', 25, 238602, 270307),
('California', 'F', 26, 233133, 256956),
('California', 'F', 27, 240008, 254407),
('California', 'F', 28, 249185, 255369),
('California', 'F', 29, 266010, 246907),
('California', 'F', 30, 278894, 242518),
('California', 'F', 31, 260916, 243900),
('California', 'F', 32, 256168, 238842),
('California', 'F', 33, 252784, 248358),
('California', 'F', 34, 256283, 242423),
('California', 'F', 35, 276234, 247199),
('California', 'F', 36, 277592, 253087),
('California', 'F', 37, 276277, 266187),
('California', 'F', 38, 275129, 278712),
('California', 'F', 39, 276094, 260644),
('California', 'F', 40, 283554, 256169),
('California', 'F', 41, 265614, 251496),
('California', 'F', 42, 265895, 253487),
('California', 'F', 43, 263355, 270406),
('California', 'F', 44, 255016, 273711),
('California', 'F', 45, 256779, 270948),
('California', 'F', 46, 244172, 268760),
('California', 'F', 47, 236211, 268222),
('California', 'F', 48, 226391, 277301),
('California', 'F', 49, 221928, 258824),
('California', 'F', 50, 225414, 256885),
('California', 'F', 51, 212545, 255334),
('California', 'F', 52, 208500, 245397),
('California', 'F', 53, 215228, 246432),
('California', 'F', 54, 168388, 233568),
('California', 'F', 55, 166675, 224738),
('California', 'F', 56, 158368, 213252),
('California', 'F', 57, 160423, 207277),
('California', 'F', 58, 142287, 210606),
('California', 'F', 59, 133235, 196810),
('California', 'F', 60, 132033, 190184),
('California', 'F', 61, 123328, 199411),
('California', 'F', 62, 120982, 152835),
('California', 'F', 63, 114959, 151873),
('California', 'F', 64, 111942, 142860),
('California', 'F', 65, 113547, 146439),
('California', 'F', 66, 104910, 130401),
('California', 'F', 67, 103883, 122043),
('California', 'F', 68, 102061, 121648),
('California', 'F', 69, 103181, 113405),
('California', 'F', 70, 106514, 111154),
('California', 'F', 71, 99453, 104695),
('California', 'F', 72, 100574, 101407),
('California', 'F', 73, 99772, 102268),
('California', 'F', 74, 99390, 92902),
('California', 'F', 75, 99277, 91037),
('California', 'F', 76, 95046, 88027),
('California', 'F', 77, 90193, 87038),
('California', 'F', 78, 86911, 89363),
('California', 'F', 79, 81990, 80715),
('California', 'F', 80, 75849, 79785),
('California', 'F', 81, 65410, 76815),
('California', 'F', 82, 61518, 74131),
('California', 'F', 83, 54748, 71991),
('California', 'F', 84, 50746, 65912),
('California', 'F', 85, 294583, 400288),
('Colorado', 'M', 0, 31697, 38122),
('Colorado', 'M', 1, 30729, 37382),
('Colorado', 'M', 2, 30026, 36322),
('Colorado', 'M', 3, 30125, 36100),
('Colorado', 'M', 4, 30544, 35428),
('Colorado', 'M', 5, 30978, 35547),
('Colorado', 'M', 6, 30875, 35150),
('Colorado', 'M', 7, 31682, 34947),
('Colorado', 'M', 8, 32195, 33217),
('Colorado', 'M', 9, 32521, 32427),
('Colorado', 'M', 10, 33240, 31804),
('Colorado', 'M', 11, 31940, 32018),
('Colorado', 'M', 12, 32108, 32294),
('Colorado', 'M', 13, 32224, 32684),
('Colorado', 'M', 14, 31898, 32577),
('Colorado', 'M', 15, 32096, 33283),
('Colorado', 'M', 16, 31446, 33938),
('Colorado', 'M', 17, 32109, 34241),
('Colorado', 'M', 18, 31962, 33422),
('Colorado', 'M', 19, 32346, 31607),
('Colorado', 'M', 20, 32424, 32686),
('Colorado', 'M', 21, 31628, 33688),
('Colorado', 'M', 22, 30920, 34916),
('Colorado', 'M', 23, 31804, 36439),
('Colorado', 'M', 24, 31536, 36707),
('Colorado', 'M', 25, 33544, 38467),
('Colorado', 'M', 26, 32494, 38740),
('Colorado', 'M', 27, 32846, 41359),
('Colorado', 'M', 28, 34769, 40250),
('Colorado', 'M', 29, 37015, 39797),
('Colorado', 'M', 30, 37715, 37118),
('Colorado', 'M', 31, 34632, 36966),
('Colorado', 'M', 32, 32886, 36460),
('Colorado', 'M', 33, 31964, 37073),
('Colorado', 'M', 34, 32578, 35939),
('Colorado', 'M', 35, 35457, 35080),
('Colorado', 'M', 36, 36108, 37338),
('Colorado', 'M', 37, 36019, 38948),
('Colorado', 'M', 38, 37017, 40155),
('Colorado', 'M', 39, 37361, 36913),
('Colorado', 'M', 40, 38889, 34891),
('Colorado', 'M', 41, 37084, 33903),
('Colorado', 'M', 42, 37520, 34522),
('Colorado', 'M', 43, 37243, 37596),
('Colorado', 'M', 44, 35337, 37104),
('Colorado', 'M', 45, 36034, 37352),
('Colorado', 'M', 46, 34711, 37643),
('Colorado', 'M', 47, 33767, 38197),
('Colorado', 'M', 48, 32797, 39332),
('Colorado', 'M', 49, 31656, 37241),
('Colorado', 'M', 50, 31088, 37411),
('Colorado', 'M', 51, 29581, 36948),
('Colorado', 'M', 52, 29383, 35347),
('Colorado', 'M', 53, 30201, 35427),
('Colorado', 'M', 54, 21917, 34117),
('Colorado', 'M', 55, 21593, 32880),
('Colorado', 'M', 56, 20674, 31923),
('Colorado', 'M', 57, 20518, 30665),
('Colorado', 'M', 58, 17945, 29934),
('Colorado', 'M', 59, 16594, 28392),
('Colorado', 'M', 60, 15959, 28060),
('Colorado', 'M', 61, 14696, 28801),
('Colorado', 'M', 62, 14319, 20507),
('Colorado', 'M', 63, 13454, 20238),
('Colorado', 'M', 64, 12943, 19254),
('Colorado', 'M', 65, 12660, 18893),
('Colorado', 'M', 66, 11490, 16182),
('Colorado', 'M', 67, 11394, 14736),
('Colorado', 'M', 68, 11274, 14200),
('Colorado', 'M', 69, 10947, 13012),
('Colorado', 'M', 70, 10703, 12559),
('Colorado', 'M', 71, 10109, 11502),
('Colorado', 'M', 72, 9386, 10952),
('Colorado', 'M', 73, 8732, 10539),
('Colorado', 'M', 74, 8517, 9332),
('Colorado', 'M', 75, 8082, 9097),
('Colorado', 'M', 76, 7839, 8797),
('Colorado', 'M', 77, 7112, 8302),
('Colorado', 'M', 78, 6915, 7947),
('Colorado', 'M', 79, 6334, 7376),
('Colorado', 'M', 80, 5622, 6694),
('Colorado', 'M', 81, 4914, 5961),
('Colorado', 'M', 82, 4278, 5549),
('Colorado', 'M', 83, 3710, 4990),
('Colorado', 'M', 84, 3195, 4709),
('Colorado', 'M', 85, 14416, 22097),
('Colorado', 'F', 0, 30228, 36194),
('Colorado', 'F', 1, 29265, 35508),
('Colorado', 'F', 2, 28690, 34748),
('Colorado', 'F', 3, 28771, 34423),
('Colorado', 'F', 4, 28965, 34053),
('Colorado', 'F', 5, 29105, 33899),
('Colorado', 'F', 6, 29408, 33176),
('Colorado', 'F', 7, 30310, 34107),
('Colorado', 'F', 8, 30630, 31911),
('Colorado', 'F', 9, 30996, 31040),
('Colorado', 'F', 10, 31558, 30493),
('Colorado', 'F', 11, 30327, 30653),
('Colorado', 'F', 12, 30370, 30843),
('Colorado', 'F', 13, 30181, 30944),
('Colorado', 'F', 14, 30224, 31099),
('Colorado', 'F', 15, 30092, 31950),
('Colorado', 'F', 16, 29295, 32188),
('Colorado', 'F', 17, 29477, 32416),
('Colorado', 'F', 18, 29678, 30658),
('Colorado', 'F', 19, 29216, 28736),
('Colorado', 'F', 20, 29287, 29481),
('Colorado', 'F', 21, 28005, 29261),
('Colorado', 'F', 22, 28899, 32191),
('Colorado', 'F', 23, 28929, 33554),
('Colorado', 'F', 24, 28724, 34536),
('Colorado', 'F', 25, 30348, 34487),
('Colorado', 'F', 26, 29207, 37323),
('Colorado', 'F', 27, 30367, 38497),
('Colorado', 'F', 28, 31723, 37100),
('Colorado', 'F', 29, 33388, 36380),
('Colorado', 'F', 30, 34596, 35220),
('Colorado', 'F', 31, 32178, 34186),
('Colorado', 'F', 32, 30927, 32610),
('Colorado', 'F', 33, 30555, 34333),
('Colorado', 'F', 34, 31238, 32401),
('Colorado', 'F', 35, 34073, 33354),
('Colorado', 'F', 36, 35078, 34316),
('Colorado', 'F', 37, 36292, 35783),
('Colorado', 'F', 38, 36907, 37153),
('Colorado', 'F', 39, 37598, 34571),
('Colorado', 'F', 40, 38096, 33171),
('Colorado', 'F', 41, 36785, 32794),
('Colorado', 'F', 42, 37201, 32999),
('Colorado', 'F', 43, 37072, 35916),
('Colorado', 'F', 44, 35922, 36951),
('Colorado', 'F', 45, 35550, 38004),
('Colorado', 'F', 46, 34827, 38395),
('Colorado', 'F', 47, 34201, 38887),
('Colorado', 'F', 48, 32534, 38990),
('Colorado', 'F', 49, 31381, 37324),
('Colorado', 'F', 50, 30939, 37807),
('Colorado', 'F', 51, 29400, 37301),
('Colorado', 'F', 52, 28541, 35921),
('Colorado', 'F', 53, 30065, 35292),
('Colorado', 'F', 54, 21734, 34505),
('Colorado', 'F', 55, 21538, 33584),
('Colorado', 'F', 56, 20926, 32214),
('Colorado', 'F', 57, 20968, 30971),
('Colorado', 'F', 58, 18864, 30494),
('Colorado', 'F', 59, 17054, 28868),
('Colorado', 'F', 60, 16306, 28095),
('Colorado', 'F', 61, 15560, 29642),
('Colorado', 'F', 62, 14682, 21136),
('Colorado', 'F', 63, 14205, 21165),
('Colorado', 'F', 64, 13700, 20417),
('Colorado', 'F', 65, 13635, 20137),
('Colorado', 'F', 66, 12554, 17959),
('Colorado', 'F', 67, 12565, 16105),
('Colorado', 'F', 68, 12568, 15326),
('Colorado', 'F', 69, 12317, 14592),
('Colorado', 'F', 70, 12265, 13724),
('Colorado', 'F', 71, 11649, 13118),
('Colorado', 'F', 72, 11481, 12534),
('Colorado', 'F', 73, 11528, 12450),
('Colorado', 'F', 74, 11018, 11198),
('Colorado', 'F', 75, 10870, 11127),
('Colorado', 'F', 76, 10672, 10990),
('Colorado', 'F', 77, 9828, 10693),
('Colorado', 'F', 78, 9721, 10427),
('Colorado', 'F', 79, 9050, 9723),
('Colorado', 'F', 80, 8251, 9327),
('Colorado', 'F', 81, 7258, 8987),
('Colorado', 'F', 82, 7071, 8409),
('Colorado', 'F', 83, 6222, 8083),
('Colorado', 'F', 84, 5751, 7570),
('Colorado', 'F', 85, 34457, 45189),
('Connecticut', 'M', 0, 22080, 21688),
('Connecticut', 'M', 1, 22666, 21680),
('Connecticut', 'M', 2, 22335, 21456),
('Connecticut', 'M', 3, 23345, 21250),
('Connecticut', 'M', 4, 23654, 22008),
('Connecticut', 'M', 5, 23968, 22168),
('Connecticut', 'M', 6, 24516, 22191),
('Connecticut', 'M', 7, 24964, 22438),
('Connecticut', 'M', 8, 25092, 22419),
('Connecticut', 'M', 9, 25917, 23088),
('Connecticut', 'M', 10, 26443, 22640),
('Connecticut', 'M', 11, 25284, 23636),
('Connecticut', 'M', 12, 24683, 23987),
('Connecticut', 'M', 13, 23937, 24202),
('Connecticut', 'M', 14, 23804, 24750),
('Connecticut', 'M', 15, 23399, 25218),
('Connecticut', 'M', 16, 22742, 25185),
('Connecticut', 'M', 17, 22271, 25728),
('Connecticut', 'M', 18, 21808, 26763),
('Connecticut', 'M', 19, 20733, 24558),
('Connecticut', 'M', 20, 20425, 23936),
('Connecticut', 'M', 21, 19439, 23353),
('Connecticut', 'M', 22, 18245, 22537),
('Connecticut', 'M', 23, 18021, 21798),
('Connecticut', 'M', 24, 17607, 21197),
('Connecticut', 'M', 25, 18410, 21679),
('Connecticut', 'M', 26, 17725, 21071),
('Connecticut', 'M', 27, 18580, 20004),
('Connecticut', 'M', 28, 20566, 20575),
('Connecticut', 'M', 29, 22475, 19457),
('Connecticut', 'M', 30, 24084, 19083),
('Connecticut', 'M', 31, 23317, 19813),
('Connecticut', 'M', 32, 23601, 19757),
('Connecticut', 'M', 33, 24450, 20350),
('Connecticut', 'M', 34, 26077, 20069),
('Connecticut', 'M', 35, 27750, 20443),
('Connecticut', 'M', 36, 28248, 22457),
('Connecticut', 'M', 37, 27441, 24014),
('Connecticut', 'M', 38, 28482, 25458),
('Connecticut', 'M', 39, 28931, 24426),
('Connecticut', 'M', 40, 29536, 24412),
('Connecticut', 'M', 41, 28792, 25467),
('Connecticut', 'M', 42, 29022, 26661),
('Connecticut', 'M', 43, 28167, 28267),
('Connecticut', 'M', 44, 27073, 28616),
('Connecticut', 'M', 45, 27004, 27544),
('Connecticut', 'M', 46, 25882, 28462),
('Connecticut', 'M', 47, 24689, 28723),
('Connecticut', 'M', 48, 23893, 29079),
('Connecticut', 'M', 49, 22969, 27827),
('Connecticut', 'M', 50, 22837, 28441),
('Connecticut', 'M', 51, 22519, 27516),
('Connecticut', 'M', 52, 22800, 26151),
('Connecticut', 'M', 53, 24440, 26020),
('Connecticut', 'M', 54, 18706, 24894),
('Connecticut', 'M', 55, 18077, 23345),
('Connecticut', 'M', 56, 18286, 22437),
('Connecticut', 'M', 57, 19333, 21356),
('Connecticut', 'M', 58, 15938, 20804),
('Connecticut', 'M', 59, 14505, 20014),
('Connecticut', 'M', 60, 13722, 19853),
('Connecticut', 'M', 61, 13211, 21844),
('Connecticut', 'M', 62, 12563, 15964),
('Connecticut', 'M', 63, 11647, 15248),
('Connecticut', 'M', 64, 11542, 15227),
('Connecticut', 'M', 65, 11465, 16237),
('Connecticut', 'M', 66, 10535, 13093),
('Connecticut', 'M', 67, 10492, 11821),
('Connecticut', 'M', 68, 10546, 11118),
('Connecticut', 'M', 69, 10850, 10610),
('Connecticut', 'M', 70, 10656, 10099),
('Connecticut', 'M', 71, 10175, 9320),
('Connecticut', 'M', 72, 10189, 9040),
('Connecticut', 'M', 73, 9782, 8983),
('Connecticut', 'M', 74, 9102, 7966),
('Connecticut', 'M', 75, 9248, 7746),
('Connecticut', 'M', 76, 8696, 7529),
('Connecticut', 'M', 77, 8179, 7719),
('Connecticut', 'M', 78, 7873, 7432),
('Connecticut', 'M', 79, 7288, 6779),
('Connecticut', 'M', 80, 6738, 6593),
('Connecticut', 'M', 81, 5759, 6044),
('Connecticut', 'M', 82, 5607, 5334),
('Connecticut', 'M', 83, 4887, 5322),
('Connecticut', 'M', 84, 4105, 4675),
('Connecticut', 'M', 85, 18192, 24287),
('Connecticut', 'F', 0, 21130, 20758),
('Connecticut', 'F', 1, 21506, 20761),
('Connecticut', 'F', 2, 21451, 20333),
('Connecticut', 'F', 3, 22399, 20844),
('Connecticut', 'F', 4, 22718, 20859),
('Connecticut', 'F', 5, 22917, 21201),
('Connecticut', 'F', 6, 23363, 21062),
('Connecticut', 'F', 7, 23858, 21119),
('Connecticut', 'F', 8, 24050, 21380),
('Connecticut', 'F', 9, 24440, 21793),
('Connecticut', 'F', 10, 25260, 21642),
('Connecticut', 'F', 11, 24011, 22585),
('Connecticut', 'F', 12, 23542, 22974),
('Connecticut', 'F', 13, 22795, 23133),
('Connecticut', 'F', 14, 22738, 23531),
('Connecticut', 'F', 15, 22068, 23987),
('Connecticut', 'F', 16, 21182, 24182),
('Connecticut', 'F', 17, 21317, 24334),
('Connecticut', 'F', 18, 20839, 25882),
('Connecticut', 'F', 19, 20019, 23628),
('Connecticut', 'F', 20, 19937, 23209),
('Connecticut', 'F', 21, 19313, 22880),
('Connecticut', 'F', 22, 18280, 21399),
('Connecticut', 'F', 23, 17989, 21180),
('Connecticut', 'F', 24, 17396, 19929),
('Connecticut', 'F', 25, 18257, 21348),
('Connecticut', 'F', 26, 18168, 21022),
('Connecticut', 'F', 27, 19595, 19358),
('Connecticut', 'F', 28, 21333, 19986),
('Connecticut', 'F', 29, 23437, 18795),
('Connecticut', 'F', 30, 25366, 20303),
('Connecticut', 'F', 31, 24540, 19951),
('Connecticut', 'F', 32, 24772, 19639),
('Connecticut', 'F', 33, 25424, 20469),
('Connecticut', 'F', 34, 27281, 19770),
('Connecticut', 'F', 35, 28861, 21548),
('Connecticut', 'F', 36, 29614, 22983),
('Connecticut', 'F', 37, 29211, 24801),
('Connecticut', 'F', 38, 29780, 26295),
('Connecticut', 'F', 39, 30307, 25639),
('Connecticut', 'F', 40, 30781, 25734),
('Connecticut', 'F', 41, 29772, 25886),
('Connecticut', 'F', 42, 29793, 27847),
('Connecticut', 'F', 43, 29023, 29164),
('Connecticut', 'F', 44, 28413, 30122),
('Connecticut', 'F', 45, 27777, 29388),
('Connecticut', 'F', 46, 26822, 29654),
('Connecticut', 'F', 47, 26099, 29915),
('Connecticut', 'F', 48, 24801, 30444),
('Connecticut', 'F', 49, 24097, 29291),
('Connecticut', 'F', 50, 24518, 29235),
('Connecticut', 'F', 51, 23883, 28309),
('Connecticut', 'F', 52, 24490, 27305),
('Connecticut', 'F', 53, 26457, 26719),
('Connecticut', 'F', 54, 19655, 25423),
('Connecticut', 'F', 55, 19168, 24831),
('Connecticut', 'F', 56, 19428, 23269),
('Connecticut', 'F', 57, 20685, 22464),
('Connecticut', 'F', 58, 17339, 22593),
('Connecticut', 'F', 59, 15242, 21528),
('Connecticut', 'F', 60, 15255, 21934),
('Connecticut', 'F', 61, 14201, 24183),
('Connecticut', 'F', 62, 14162, 17632),
('Connecticut', 'F', 63, 13036, 16906),
('Connecticut', 'F', 64, 12858, 16806),
('Connecticut', 'F', 65, 13174, 17994),
('Connecticut', 'F', 66, 12255, 15077),
('Connecticut', 'F', 67, 12526, 13142),
('Connecticut', 'F', 68, 12486, 13265),
('Connecticut', 'F', 69, 12826, 12313),
('Connecticut', 'F', 70, 13094, 12319),
('Connecticut', 'F', 71, 12685, 11325),
('Connecticut', 'F', 72, 12828, 11233),
('Connecticut', 'F', 73, 12729, 11465),
('Connecticut', 'F', 74, 12510, 10360),
('Connecticut', 'F', 75, 12792, 10476),
('Connecticut', 'F', 76, 12437, 10187),
('Connecticut', 'F', 77, 11875, 10308),
('Connecticut', 'F', 78, 11640, 10364),
('Connecticut', 'F', 79, 11163, 9839),
('Connecticut', 'F', 80, 10922, 9795),
('Connecticut', 'F', 81, 9786, 9406),
('Connecticut', 'F', 82, 9656, 9194),
('Connecticut', 'F', 83, 8555, 9035),
('Connecticut', 'F', 84, 7733, 8339),
('Connecticut', 'F', 85, 46697, 54824),
('Delaware', 'M', 0, 5373, 6231),
('Delaware', 'M', 1, 5197, 6118),
('Delaware', 'M', 2, 5266, 5983),
('Delaware', 'M', 3, 5096, 5914),
('Delaware', 'M', 4, 5375, 5817),
('Delaware', 'M', 5, 5495, 5995),
('Delaware', 'M', 6, 5578, 5751),
('Delaware', 'M', 7, 5680, 5779),
('Delaware', 'M', 8, 5771, 5683),
('Delaware', 'M', 9, 6094, 5439),
('Delaware', 'M', 10, 5990, 5615),
('Delaware', 'M', 11, 5781, 5342),
('Delaware', 'M', 12, 5608, 5641),
('Delaware', 'M', 13, 5464, 5765),
('Delaware', 'M', 14, 5609, 5889),
('Delaware', 'M', 15, 5649, 5979),
('Delaware', 'M', 16, 5521, 6034),
('Delaware', 'M', 17, 5516, 6354),
('Delaware', 'M', 18, 5556, 6777),
('Delaware', 'M', 19, 5701, 5976),
('Delaware', 'M', 20, 5681, 5926),
('Delaware', 'M', 21, 5128, 5958),
('Delaware', 'M', 22, 4971, 5499),
('Delaware', 'M', 23, 4587, 5608),
('Delaware', 'M', 24, 4531, 5632),
('Delaware', 'M', 25, 4664, 5943),
('Delaware', 'M', 26, 4612, 4978),
('Delaware', 'M', 27, 4656, 5586),
('Delaware', 'M', 28, 5075, 5867),
('Delaware', 'M', 29, 5635, 4575),
('Delaware', 'M', 30, 5686, 5539),
('Delaware', 'M', 31, 5425, 5051),
('Delaware', 'M', 32, 5354, 4763),
('Delaware', 'M', 33, 5585, 5050),
('Delaware', 'M', 34, 5829, 5144),
('Delaware', 'M', 35, 6049, 5135),
('Delaware', 'M', 36, 6357, 5519),
('Delaware', 'M', 37, 6300, 6036),
('Delaware', 'M', 38, 6329, 6136),
('Delaware', 'M', 39, 6075, 5699),
('Delaware', 'M', 40, 6245, 5599),
('Delaware', 'M', 41, 6196, 5766),
('Delaware', 'M', 42, 6332, 6088),
('Delaware', 'M', 43, 6141, 6048),
('Delaware', 'M', 44, 5852, 6477),
('Delaware', 'M', 45, 5765, 6339),
('Delaware', 'M', 46, 5446, 6484),
('Delaware', 'M', 47, 5322, 6256),
('Delaware', 'M', 48, 4956, 6375),
('Delaware', 'M', 49, 5138, 6395),
('Delaware', 'M', 50, 4877, 6373),
('Delaware', 'M', 51, 4888, 6274),
('Delaware', 'M', 52, 4952, 5916),
('Delaware', 'M', 53, 5421, 5937),
('Delaware', 'M', 54, 3903, 5403),
('Delaware', 'M', 55, 3886, 5458),
('Delaware', 'M', 56, 4003, 4989),
('Delaware', 'M', 57, 4003, 5202),
('Delaware', 'M', 58, 3622, 4913),
('Delaware', 'M', 59, 3384, 4928),
('Delaware', 'M', 60, 3242, 5067),
('Delaware', 'M', 61, 3211, 5374),
('Delaware', 'M', 62, 3150, 4034),
('Delaware', 'M', 63, 2869, 3966),
('Delaware', 'M', 64, 2840, 4144),
('Delaware', 'M', 65, 2994, 4038),
('Delaware', 'M', 66, 2717, 3623),
('Delaware', 'M', 67, 2823, 3314),
('Delaware', 'M', 68, 2816, 3089),
('Delaware', 'M', 69, 2748, 2987),
('Delaware', 'M', 70, 2633, 2864),
('Delaware', 'M', 71, 2515, 2493),
('Delaware', 'M', 72, 2409, 2441),
('Delaware', 'M', 73, 2283, 2580),
('Delaware', 'M', 74, 2135, 2226),
('Delaware', 'M', 75, 2135, 2285),
('Delaware', 'M', 76, 1898, 2213),
('Delaware', 'M', 77, 1681, 2136),
('Delaware', 'M', 78, 1630, 2009),
('Delaware', 'M', 79, 1473, 1845),
('Delaware', 'M', 80, 1432, 1719),
('Delaware', 'M', 81, 1131, 1488),
('Delaware', 'M', 82, 1063, 1376),
('Delaware', 'M', 83, 898, 1378),
('Delaware', 'M', 84, 677, 1136),
('Delaware', 'M', 85, 3004, 5363),
('Delaware', 'F', 0, 5043, 5965),
('Delaware', 'F', 1, 5100, 6017),
('Delaware', 'F', 2, 5014, 5813),
('Delaware', 'F', 3, 4972, 5806),
('Delaware', 'F', 4, 5160, 5655),
('Delaware', 'F', 5, 5114, 5653),
('Delaware', 'F', 6, 5311, 5463),
('Delaware', 'F', 7, 5495, 5512),
('Delaware', 'F', 8, 5480, 5231),
('Delaware', 'F', 9, 5612, 5310),
('Delaware', 'F', 10, 5662, 5253),
('Delaware', 'F', 11, 5447, 5191),
('Delaware', 'F', 12, 5450, 5468),
('Delaware', 'F', 13, 5228, 5405),
('Delaware', 'F', 14, 5336, 5607),
('Delaware', 'F', 15, 5194, 5812),
('Delaware', 'F', 16, 5099, 5800),
('Delaware', 'F', 17, 5148, 5939),
('Delaware', 'F', 18, 5842, 6751),
('Delaware', 'F', 19, 6433, 6271),
('Delaware', 'F', 20, 5942, 6026),
('Delaware', 'F', 21, 5688, 6088),
('Delaware', 'F', 22, 5125, 5730),
('Delaware', 'F', 23, 4726, 5498),
('Delaware', 'F', 24, 4571, 5313),
('Delaware', 'F', 25, 4829, 5934),
('Delaware', 'F', 26, 4685, 4954),
('Delaware', 'F', 27, 4900, 6160),
('Delaware', 'F', 28, 5299, 5982),
('Delaware', 'F', 29, 5808, 5451),
('Delaware', 'F', 30, 5887, 5574),
('Delaware', 'F', 31, 5603, 5286),
('Delaware', 'F', 32, 5782, 5294),
('Delaware', 'F', 33, 5851, 5429),
('Delaware', 'F', 34, 6030, 5089),
('Delaware', 'F', 35, 6425, 5483),
('Delaware', 'F', 36, 6447, 5692),
('Delaware', 'F', 37, 6636, 6195),
('Delaware', 'F', 38, 6501, 6333),
('Delaware', 'F', 39, 6743, 5900),
('Delaware', 'F', 40, 6614, 6092),
('Delaware', 'F', 41, 6418, 6155),
('Delaware', 'F', 42, 6551, 6540),
('Delaware', 'F', 43, 6338, 6675),
('Delaware', 'F', 44, 6172, 6722),
('Delaware', 'F', 45, 6046, 6877),
('Delaware', 'F', 46, 5733, 6613),
('Delaware', 'F', 47, 5744, 7051),
('Delaware', 'F', 48, 5546, 6891),
('Delaware', 'F', 49, 5398, 6538),
('Delaware', 'F', 50, 5219, 6772),
('Delaware', 'F', 51, 5297, 6628),
('Delaware', 'F', 52, 5416, 6457),
('Delaware', 'F', 53, 5634, 6334),
('Delaware', 'F', 54, 4184, 5954),
('Delaware', 'F', 55, 4183, 6040),
('Delaware', 'F', 56, 4324, 5844),
('Delaware', 'F', 57, 4420, 5801),
('Delaware', 'F', 58, 4011, 5552),
('Delaware', 'F', 59, 3760, 5644),
('Delaware', 'F', 60, 3601, 5802),
('Delaware', 'F', 61, 3511, 5924),
('Delaware', 'F', 62, 3476, 4548),
('Delaware', 'F', 63, 3225, 4507),
('Delaware', 'F', 64, 3260, 4708),
('Delaware', 'F', 65, 3326, 4661),
('Delaware', 'F', 66, 3098, 4164),
('Delaware', 'F', 67, 3170, 3823),
('Delaware', 'F', 68, 3170, 3551),
('Delaware', 'F', 69, 3118, 3433),
('Delaware', 'F', 70, 3105, 3321),
('Delaware', 'F', 71, 2938, 3008),
('Delaware', 'F', 72, 2936, 2996),
('Delaware', 'F', 73, 2885, 3007),
('Delaware', 'F', 74, 2671, 2719),
('Delaware', 'F', 75, 2704, 2818),
('Delaware', 'F', 76, 2720, 2782),
('Delaware', 'F', 77, 2493, 2643),
('Delaware', 'F', 78, 2397, 2607),
('Delaware', 'F', 79, 2224, 2426),
('Delaware', 'F', 80, 2157, 2341),
('Delaware', 'F', 81, 1847, 2282),
('Delaware', 'F', 82, 1656, 1977),
('Delaware', 'F', 83, 1494, 1939),
('Delaware', 'F', 84, 1308, 1832),
('Delaware', 'F', 85, 7682, 10755),
('District of Columbia', 'M', 0, 3358, 4017),
('District of Columbia', 'M', 1, 3084, 3977),
('District of Columbia', 'M', 2, 3357, 3625),
('District of Columbia', 'M', 3, 3245, 3525),
('District of Columbia', 'M', 4, 3361, 3456),
('District of Columbia', 'M', 5, 3360, 3341),
('District of Columbia', 'M', 6, 3504, 2831),
('District of Columbia', 'M', 7, 3600, 3156),
('District of Columbia', 'M', 8, 3600, 2997),
('District of Columbia', 'M', 9, 3542, 2335),
('District of Columbia', 'M', 10, 3566, 2878),
('District of Columbia', 'M', 11, 3119, 2610),
('District of Columbia', 'M', 12, 2857, 2902),
('District of Columbia', 'M', 13, 2848, 2793),
('District of Columbia', 'M', 14, 2746, 3034),
('District of Columbia', 'M', 15, 2851, 3102),
('District of Columbia', 'M', 16, 2835, 3300),
('District of Columbia', 'M', 17, 2887, 3199),
('District of Columbia', 'M', 18, 4020, 4457),
('District of Columbia', 'M', 19, 5264, 5406),
('District of Columbia', 'M', 20, 5016, 4710),
('District of Columbia', 'M', 21, 4709, 4718),
('District of Columbia', 'M', 22, 4348, 4622),
('District of Columbia', 'M', 23, 4399, 4592),
('District of Columbia', 'M', 24, 4554, 5569),
('District of Columbia', 'M', 25, 4721, 4931),
('District of Columbia', 'M', 26, 4609, 6682),
('District of Columbia', 'M', 27, 4879, 5187),
('District of Columbia', 'M', 28, 4957, 5772),
('District of Columbia', 'M', 29, 5377, 5997),
('District of Columbia', 'M', 30, 5562, 4864),
('District of Columbia', 'M', 31, 4801, 4871),
('District of Columbia', 'M', 32, 4652, 4615),
('District of Columbia', 'M', 33, 4328, 4948),
('District of Columbia', 'M', 34, 4639, 3829),
('District of Columbia', 'M', 35, 4915, 4668),
('District of Columbia', 'M', 36, 4700, 4112),
('District of Columbia', 'M', 37, 4497, 4267),
('District of Columbia', 'M', 38, 4247, 4857),
('District of Columbia', 'M', 39, 4367, 4034),
('District of Columbia', 'M', 40, 4515, 4176),
('District of Columbia', 'M', 41, 4081, 3595),
('District of Columbia', 'M', 42, 4066, 3753),
('District of Columbia', 'M', 43, 3926, 4175),
('District of Columbia', 'M', 44, 3759, 4293),
('District of Columbia', 'M', 45, 3920, 3957),
('District of Columbia', 'M', 46, 3858, 3935),
('District of Columbia', 'M', 47, 3750, 3712),
('District of Columbia', 'M', 48, 3447, 3976),
('District of Columbia', 'M', 49, 3699, 3679),
('District of Columbia', 'M', 50, 3677, 3697),
('District of Columbia', 'M', 51, 3508, 3591),
('District of Columbia', 'M', 52, 3405, 3350),
('District of Columbia', 'M', 53, 3449, 3626),
('District of Columbia', 'M', 54, 2686, 3338),
('District of Columbia', 'M', 55, 2762, 3383),
('District of Columbia', 'M', 56, 2626, 2869),
('District of Columbia', 'M', 57, 2558, 3246),
('District of Columbia', 'M', 58, 2460, 3144),
('District of Columbia', 'M', 59, 2283, 3078),
('District of Columbia', 'M', 60, 2251, 2818),
('District of Columbia', 'M', 61, 2154, 2944),
('District of Columbia', 'M', 62, 2055, 2187),
('District of Columbia', 'M', 63, 1791, 2318),
('District of Columbia', 'M', 64, 1805, 2257),
('District of Columbia', 'M', 65, 1807, 2046),
('District of Columbia', 'M', 66, 1645, 1967),
('District of Columbia', 'M', 67, 1647, 1743),
('District of Columbia', 'M', 68, 1516, 1699),
('District of Columbia', 'M', 69, 1511, 1644),
('District of Columbia', 'M', 70, 1498, 1611),
('District of Columbia', 'M', 71, 1399, 1320),
('District of Columbia', 'M', 72, 1417, 1304),
('District of Columbia', 'M', 73, 1356, 1359),
('District of Columbia', 'M', 74, 1235, 1162),
('District of Columbia', 'M', 75, 1275, 1122),
('District of Columbia', 'M', 76, 1182, 1022),
('District of Columbia', 'M', 77, 1110, 982),
('District of Columbia', 'M', 78, 1060, 933),
('District of Columbia', 'M', 79, 972, 899),
('District of Columbia', 'M', 80, 939, 827),
('District of Columbia', 'M', 81, 783, 832),
('District of Columbia', 'M', 82, 639, 704),
('District of Columbia', 'M', 83, 587, 645),
('District of Columbia', 'M', 84, 481, 624),
('District of Columbia', 'M', 85, 2441, 3195),
('District of Columbia', 'F', 0, 3219, 3869),
('District of Columbia', 'F', 1, 3120, 3640),
('District of Columbia', 'F', 2, 3106, 3484),
('District of Columbia', 'F', 3, 3204, 3326),
('District of Columbia', 'F', 4, 3334, 3433),
('District of Columbia', 'F', 5, 3387, 2849),
('District of Columbia', 'F', 6, 3496, 2797),
('District of Columbia', 'F', 7, 3493, 3117),
('District of Columbia', 'F', 8, 3528, 2580),
('District of Columbia', 'F', 9, 3561, 2608),
('District of Columbia', 'F', 10, 3456, 2529),
('District of Columbia', 'F', 11, 3054, 2563),
('District of Columbia', 'F', 12, 2896, 2748),
('District of Columbia', 'F', 13, 2859, 2805),
('District of Columbia', 'F', 14, 2700, 3017),
('District of Columbia', 'F', 15, 2738, 3083),
('District of Columbia', 'F', 16, 2792, 3175),
('District of Columbia', 'F', 17, 2943, 3315),
('District of Columbia', 'F', 18, 4869, 5377),
('District of Columbia', 'F', 19, 6429, 6317),
('District of Columbia', 'F', 20, 5907, 5687),
('District of Columbia', 'F', 21, 5520, 5842),
('District of Columbia', 'F', 22, 5435, 5384),
('District of Columbia', 'F', 23, 5594, 5672),
('District of Columbia', 'F', 24, 5688, 6365),
('District of Columbia', 'F', 25, 5669, 6145),
('District of Columbia', 'F', 26, 5256, 7164),
('District of Columbia', 'F', 27, 5328, 4927),
('District of Columbia', 'F', 28, 5363, 8131),
('District of Columbia', 'F', 29, 5686, 4980),
('District of Columbia', 'F', 30, 5676, 5204),
('District of Columbia', 'F', 31, 4867, 5339),
('District of Columbia', 'F', 32, 4753, 4893),
('District of Columbia', 'F', 33, 4479, 4811),
('District of Columbia', 'F', 34, 4462, 4458),
('District of Columbia', 'F', 35, 4722, 4749),
('District of Columbia', 'F', 36, 4648, 4063),
('District of Columbia', 'F', 37, 4370, 4314),
('District of Columbia', 'F', 38, 4266, 4936),
('District of Columbia', 'F', 39, 4356, 3883),
('District of Columbia', 'F', 40, 4507, 4195),
('District of Columbia', 'F', 41, 4193, 3843),
('District of Columbia', 'F', 42, 4063, 3789),
('District of Columbia', 'F', 43, 4240, 4064),
('District of Columbia', 'F', 44, 4080, 4201),
('District of Columbia', 'F', 45, 4349, 4107),
('District of Columbia', 'F', 46, 4144, 3852),
('District of Columbia', 'F', 47, 4072, 4011),
('District of Columbia', 'F', 48, 4041, 4202),
('District of Columbia', 'F', 49, 4086, 3873),
('District of Columbia', 'F', 50, 4237, 3872),
('District of Columbia', 'F', 51, 4079, 4124),
('District of Columbia', 'F', 52, 4004, 3719),
('District of Columbia', 'F', 53, 3987, 4090),
('District of Columbia', 'F', 54, 3163, 4045),
('District of Columbia', 'F', 55, 3224, 3727),
('District of Columbia', 'F', 56, 3251, 3809),
('District of Columbia', 'F', 57, 3136, 3936),
('District of Columbia', 'F', 58, 2851, 3870),
('District of Columbia', 'F', 59, 2700, 3668),
('District of Columbia', 'F', 60, 2793, 3647),
('District of Columbia', 'F', 61, 2360, 3726),
('District of Columbia', 'F', 62, 2433, 2752),
('District of Columbia', 'F', 63, 2206, 2851),
('District of Columbia', 'F', 64, 2137, 2827),
('District of Columbia', 'F', 65, 2195, 2751),
('District of Columbia', 'F', 66, 2061, 2500),
('District of Columbia', 'F', 67, 2100, 2280),
('District of Columbia', 'F', 68, 1980, 2391),
('District of Columbia', 'F', 69, 1977, 1962),
('District of Columbia', 'F', 70, 2193, 2007),
('District of Columbia', 'F', 71, 2118, 1821),
('District of Columbia', 'F', 72, 1978, 1734),
('District of Columbia', 'F', 73, 2071, 1780),
('District of Columbia', 'F', 74, 2020, 1649),
('District of Columbia', 'F', 75, 2049, 1643),
('District of Columbia', 'F', 76, 1946, 1477),
('District of Columbia', 'F', 77, 1949, 1448),
('District of Columbia', 'F', 78, 1751, 1579),
('District of Columbia', 'F', 79, 1681, 1528),
('District of Columbia', 'F', 80, 1627, 1365),
('District of Columbia', 'F', 81, 1380, 1408),
('District of Columbia', 'F', 82, 1327, 1327),
('District of Columbia', 'F', 83, 1195, 1274),
('District of Columbia', 'F', 84, 1090, 1135),
('District of Columbia', 'F', 85, 6578, 7949),
('Florida', 'M', 0, 96891, 118845),
('Florida', 'M', 1, 96241, 118562),
('Florida', 'M', 2, 95962, 117764),
('Florida', 'M', 3, 97571, 115442),
('Florida', 'M', 4, 98921, 113414),
('Florida', 'M', 5, 100872, 112225),
('Florida', 'M', 6, 103385, 112369),
('Florida', 'M', 7, 105891, 114473),
('Florida', 'M', 8, 107297, 107170),
('Florida', 'M', 9, 110452, 107341),
('Florida', 'M', 10, 114085, 107091),
('Florida', 'M', 11, 110550, 109206),
('Florida', 'M', 12, 107550, 110886),
('Florida', 'M', 13, 106247, 112469),
('Florida', 'M', 14, 106676, 114964),
('Florida', 'M', 15, 107102, 117668),
('Florida', 'M', 16, 104404, 119080),
('Florida', 'M', 17, 105018, 122527),
('Florida', 'M', 18, 103106, 121759),
('Florida', 'M', 19, 98862, 112307),
('Florida', 'M', 20, 99630, 111945),
('Florida', 'M', 21, 93540, 112038),
('Florida', 'M', 22, 91366, 114441),
('Florida', 'M', 23, 91643, 118647),
('Florida', 'M', 24, 89265, 119523),
('Florida', 'M', 25, 93660, 122639),
('Florida', 'M', 26, 91698, 122213),
('Florida', 'M', 27, 95710, 124393),
('Florida', 'M', 28, 102051, 123591),
('Florida', 'M', 29, 108005, 115059),
('Florida', 'M', 30, 112357, 113122),
('Florida', 'M', 31, 104673, 110591),
('Florida', 'M', 32, 104384, 107816),
('Florida', 'M', 33, 106612, 110485),
('Florida', 'M', 34, 112132, 109574),
('Florida', 'M', 35, 122356, 112328),
('Florida', 'M', 36, 124018, 118251),
('Florida', 'M', 37, 123763, 124092),
('Florida', 'M', 38, 124249, 127268),
('Florida', 'M', 39, 125258, 120058),
('Florida', 'M', 40, 128828, 118783),
('Florida', 'M', 41, 121569, 120354),
('Florida', 'M', 42, 121360, 125046),
('Florida', 'M', 43, 119076, 134622),
('Florida', 'M', 44, 113743, 135429),
('Florida', 'M', 45, 115824, 134862),
('Florida', 'M', 46, 109190, 133928),
('Florida', 'M', 47, 105743, 134217),
('Florida', 'M', 48, 101985, 136098),
('Florida', 'M', 49, 100030, 128070),
('Florida', 'M', 50, 101104, 127322),
('Florida', 'M', 51, 97524, 124907),
('Florida', 'M', 52, 98104, 119249),
('Florida', 'M', 53, 103654, 120391),
('Florida', 'M', 54, 80299, 114310),
('Florida', 'M', 55, 81463, 110304),
('Florida', 'M', 56, 80100, 107370),
('Florida', 'M', 57, 84227, 105637),
('Florida', 'M', 58, 74283, 107162),
('Florida', 'M', 59, 71420, 104161),
('Florida', 'M', 60, 71779, 106569),
('Florida', 'M', 61, 69239, 108575),
('Florida', 'M', 62, 69912, 86517),
('Florida', 'M', 63, 68303, 88225),
('Florida', 'M', 64, 67654, 87519),
('Florida', 'M', 65, 69396, 90923),
('Florida', 'M', 66, 65285, 80373),
('Florida', 'M', 67, 67224, 76475),
('Florida', 'M', 68, 68008, 75087),
('Florida', 'M', 69, 68744, 70421),
('Florida', 'M', 70, 69890, 68682),
('Florida', 'M', 71, 67055, 65238),
('Florida', 'M', 72, 66345, 62768),
('Florida', 'M', 73, 64748, 62531),
('Florida', 'M', 74, 61089, 57165),
('Florida', 'M', 75, 60053, 57284),
('Florida', 'M', 76, 56904, 56721),
('Florida', 'M', 77, 53383, 56186),
('Florida', 'M', 78, 51014, 55313),
('Florida', 'M', 79, 47526, 51480),
('Florida', 'M', 80, 42814, 49612),
('Florida', 'M', 81, 36996, 46701),
('Florida', 'M', 82, 34263, 42593),
('Florida', 'M', 83, 29757, 40759),
('Florida', 'M', 84, 25681, 36309),
('Florida', 'M', 85, 113951, 199180),
('Florida', 'F', 0, 92803, 113205),
('Florida', 'F', 1, 90743, 113133),
('Florida', 'F', 2, 91961, 112272),
('Florida', 'F', 3, 92395, 109917),
('Florida', 'F', 4, 94072, 107962),
('Florida', 'F', 5, 96113, 106341),
('Florida', 'F', 6, 98135, 107067),
('Florida', 'F', 7, 99759, 109771),
('Florida', 'F', 8, 101879, 103109),
('Florida', 'F', 9, 105664, 101034),
('Florida', 'F', 10, 108858, 102544),
('Florida', 'F', 11, 104588, 103409),
('Florida', 'F', 12, 102981, 105172),
('Florida', 'F', 13, 101314, 107018),
('Florida', 'F', 14, 100981, 109340),
('Florida', 'F', 15, 101253, 111069),
('Florida', 'F', 16, 98627, 113005),
('Florida', 'F', 17, 97885, 117383),
('Florida', 'F', 18, 97981, 113733),
('Florida', 'F', 19, 97213, 106850),
('Florida', 'F', 20, 96827, 108456),
('Florida', 'F', 21, 90585, 105653),
('Florida', 'F', 22, 89417, 109238),
('Florida', 'F', 23, 89858, 113527),
('Florida', 'F', 24, 87412, 114759),
('Florida', 'F', 25, 91740, 113190),
('Florida', 'F', 26, 90374, 116802),
('Florida', 'F', 27, 95229, 121723),
('Florida', 'F', 28, 102176, 113799),
('Florida', 'F', 29, 108211, 111734),
('Florida', 'F', 30, 110640, 107973),
('Florida', 'F', 31, 104048, 106631),
('Florida', 'F', 32, 104856, 103243),
('Florida', 'F', 33, 107537, 107256),
('Florida', 'F', 34, 112617, 106743),
('Florida', 'F', 35, 122702, 110527),
('Florida', 'F', 36, 126477, 118067),
('Florida', 'F', 37, 125632, 123676),
('Florida', 'F', 38, 125797, 126120),
('Florida', 'F', 39, 127771, 118436),
('Florida', 'F', 40, 129871, 118364),
('Florida', 'F', 41, 124022, 120533),
('Florida', 'F', 42, 124375, 125231),
('Florida', 'F', 43, 123613, 135509),
('Florida', 'F', 44, 118578, 138328),
('Florida', 'F', 45, 119679, 136657),
('Florida', 'F', 46, 114659, 136722),
('Florida', 'F', 47, 111078, 138381),
('Florida', 'F', 48, 107713, 139760),
('Florida', 'F', 49, 106500, 133818),
('Florida', 'F', 50, 107077, 133607),
('Florida', 'F', 51, 104708, 132320),
('Florida', 'F', 52, 105209, 127850),
('Florida', 'F', 53, 111282, 129149),
('Florida', 'F', 54, 87062, 124079),
('Florida', 'F', 55, 88525, 120377),
('Florida', 'F', 56, 88897, 117778),
('Florida', 'F', 57, 94181, 117201),
('Florida', 'F', 58, 84424, 118163),
('Florida', 'F', 59, 80948, 116460),
('Florida', 'F', 60, 81804, 118791),
('Florida', 'F', 61, 78651, 120818),
('Florida', 'F', 62, 79473, 97150),
('Florida', 'F', 63, 77436, 99112),
('Florida', 'F', 64, 77929, 99557),
('Florida', 'F', 65, 79455, 103739),
('Florida', 'F', 66, 74290, 92972),
('Florida', 'F', 67, 77147, 88221),
('Florida', 'F', 68, 77115, 86622),
('Florida', 'F', 69, 78932, 81565),
('Florida', 'F', 70, 80857, 80187),
('Florida', 'F', 71, 79541, 75722),
('Florida', 'F', 72, 79608, 74602),
('Florida', 'F', 73, 78667, 74443),
('Florida', 'F', 74, 76018, 68411),
('Florida', 'F', 75, 76193, 69805),
('Florida', 'F', 76, 73371, 68461),
('Florida', 'F', 77, 69115, 68956),
('Florida', 'F', 78, 66656, 68699),
('Florida', 'F', 79, 63795, 66050),
('Florida', 'F', 80, 58715, 64696),
('Florida', 'F', 81, 51299, 62457),
('Florida', 'F', 82, 48680, 58314),
('Florida', 'F', 83, 43118, 57062),
('Florida', 'F', 84, 39522, 52826),
('Florida', 'F', 85, 221202, 322186),
('Georgia', 'M', 0, 62989, 76346),
('Georgia', 'M', 1, 60719, 77058),
('Georgia', 'M', 2, 60355, 75886),
('Georgia', 'M', 3, 60273, 75035),
('Georgia', 'M', 4, 60705, 74942),
('Georgia', 'M', 5, 61032, 73680),
('Georgia', 'M', 6, 61764, 73777),
('Georgia', 'M', 7, 63176, 75620),
('Georgia', 'M', 8, 62900, 71390),
('Georgia', 'M', 9, 64711, 69130),
('Georgia', 'M', 10, 66866, 68585),
('Georgia', 'M', 11, 63483, 68595),
('Georgia', 'M', 12, 62128, 69274),
('Georgia', 'M', 13, 60570, 69395),
('Georgia', 'M', 14, 61044, 70105),
('Georgia', 'M', 15, 61549, 71586),
('Georgia', 'M', 16, 60161, 70764),
('Georgia', 'M', 17, 61155, 71803),
('Georgia', 'M', 18, 61190, 70544),
('Georgia', 'M', 19, 60880, 65318),
('Georgia', 'M', 20, 61391, 63195),
('Georgia', 'M', 21, 58299, 62554),
('Georgia', 'M', 22, 57178, 65108),
('Georgia', 'M', 23, 57304, 65603),
('Georgia', 'M', 24, 57328, 65945),
('Georgia', 'M', 25, 60020, 67163),
('Georgia', 'M', 26, 59027, 68248),
('Georgia', 'M', 27, 61421, 71563),
('Georgia', 'M', 28, 64530, 72796),
('Georgia', 'M', 29, 68305, 69652),
('Georgia', 'M', 30, 68995, 65846),
('Georgia', 'M', 31, 63887, 65790),
('Georgia', 'M', 32, 62656, 65119),
('Georgia', 'M', 33, 62793, 65793),
('Georgia', 'M', 34, 64822, 65755),
('Georgia', 'M', 35, 69219, 68087),
('Georgia', 'M', 36, 69518, 71457),
('Georgia', 'M', 37, 67225, 74979),
('Georgia', 'M', 38, 67120, 76146),
('Georgia', 'M', 39, 67084, 70027),
('Georgia', 'M', 40, 68090, 68157),
('Georgia', 'M', 41, 64989, 68928),
('Georgia', 'M', 42, 64159, 70494),
('Georgia', 'M', 43, 63371, 74512),
('Georgia', 'M', 44, 60640, 74481),
('Georgia', 'M', 45, 60634, 72516),
('Georgia', 'M', 46, 58117, 71112),
('Georgia', 'M', 47, 55517, 71210),
('Georgia', 'M', 48, 53423, 71178),
('Georgia', 'M', 49, 52225, 67982),
('Georgia', 'M', 50, 53303, 66565),
('Georgia', 'M', 51, 51694, 65712),
('Georgia', 'M', 52, 51624, 62729),
('Georgia', 'M', 53, 53168, 61720),
('Georgia', 'M', 54, 39700, 59099),
('Georgia', 'M', 55, 39443, 55770),
('Georgia', 'M', 56, 38643, 53813),
('Georgia', 'M', 57, 39488, 51842),
('Georgia', 'M', 58, 34435, 52753),
('Georgia', 'M', 59, 32007, 50553),
('Georgia', 'M', 60, 30907, 50258),
('Georgia', 'M', 61, 28160, 51940),
('Georgia', 'M', 62, 27216, 37890),
('Georgia', 'M', 63, 25651, 37476),
('Georgia', 'M', 64, 24777, 36235),
('Georgia', 'M', 65, 24241, 36802),
('Georgia', 'M', 66, 21866, 31328),
('Georgia', 'M', 67, 21585, 28932),
('Georgia', 'M', 68, 20784, 27519),
('Georgia', 'M', 69, 19500, 24650),
('Georgia', 'M', 70, 19164, 23370),
('Georgia', 'M', 71, 17749, 21503),
('Georgia', 'M', 72, 17039, 20368),
('Georgia', 'M', 73, 15934, 19529),
('Georgia', 'M', 74, 15209, 17223),
('Georgia', 'M', 75, 14165, 16571),
('Georgia', 'M', 76, 13040, 15643),
('Georgia', 'M', 77, 12196, 14146),
('Georgia', 'M', 78, 11248, 13754),
('Georgia', 'M', 79, 10477, 12166),
('Georgia', 'M', 80, 9638, 11418),
('Georgia', 'M', 81, 7933, 10331),
('Georgia', 'M', 82, 6997, 9238),
('Georgia', 'M', 83, 6053, 8423),
('Georgia', 'M', 84, 5213, 7285),
('Georgia', 'M', 85, 22775, 36029),
('Georgia', 'F', 0, 59835, 72821),
('Georgia', 'F', 1, 58897, 73490),
('Georgia', 'F', 2, 57636, 72132),
('Georgia', 'F', 3, 57710, 71143),
('Georgia', 'F', 4, 57954, 71668),
('Georgia', 'F', 5, 58286, 70431),
('Georgia', 'F', 6, 58912, 70433),
('Georgia', 'F', 7, 60746, 72870),
('Georgia', 'F', 8, 61182, 67241),
('Georgia', 'F', 9, 62108, 66781),
('Georgia', 'F', 10, 63190, 65338),
('Georgia', 'F', 11, 60542, 65583),
('Georgia', 'F', 12, 59193, 65997),
('Georgia', 'F', 13, 58281, 66340),
('Georgia', 'F', 14, 57365, 66729),
('Georgia', 'F', 15, 57394, 68574),
('Georgia', 'F', 16, 56097, 68750),
('Georgia', 'F', 17, 56588, 69235),
('Georgia', 'F', 18, 57467, 64494),
('Georgia', 'F', 19, 59542, 62002),
('Georgia', 'F', 20, 60432, 60683),
('Georgia', 'F', 21, 56626, 60575),
('Georgia', 'F', 22, 56271, 62931),
('Georgia', 'F', 23, 56458, 64011),
('Georgia', 'F', 24, 55943, 64320),
('Georgia', 'F', 25, 59282, 64397),
('Georgia', 'F', 26, 58826, 69405),
('Georgia', 'F', 27, 61646, 72979),
('Georgia', 'F', 28, 64963, 74971),
('Georgia', 'F', 29, 68529, 69671),
('Georgia', 'F', 30, 68320, 67259),
('Georgia', 'F', 31, 65112, 65916),
('Georgia', 'F', 32, 63230, 64665),
('Georgia', 'F', 33, 63924, 67448),
('Georgia', 'F', 34, 65897, 66732),
('Georgia', 'F', 35, 70390, 69918),
('Georgia', 'F', 36, 70809, 73496),
('Georgia', 'F', 37, 69549, 77435),
('Georgia', 'F', 38, 69729, 75071),
('Georgia', 'F', 39, 69422, 71819),
('Georgia', 'F', 40, 69925, 69187),
('Georgia', 'F', 41, 67422, 70479),
('Georgia', 'F', 42, 66408, 71987),
('Georgia', 'F', 43, 66378, 75955),
('Georgia', 'F', 44, 63571, 76120),
('Georgia', 'F', 45, 63191, 74246),
('Georgia', 'F', 46, 61121, 74691),
('Georgia', 'F', 47, 58808, 74186),
('Georgia', 'F', 48, 57371, 74452),
('Georgia', 'F', 49, 56579, 71125),
('Georgia', 'F', 50, 56701, 70462),
('Georgia', 'F', 51, 54998, 69778),
('Georgia', 'F', 52, 54236, 66980),
('Georgia', 'F', 53, 56098, 66291),
('Georgia', 'F', 54, 42226, 63620),
('Georgia', 'F', 55, 41685, 61021),
('Georgia', 'F', 56, 40802, 59459),
('Georgia', 'F', 57, 41778, 58241),
('Georgia', 'F', 58, 36661, 58013),
('Georgia', 'F', 59, 34234, 56400),
('Georgia', 'F', 60, 33147, 55501),
('Georgia', 'F', 61, 31104, 56848),
('Georgia', 'F', 62, 30229, 42949),
('Georgia', 'F', 63, 28621, 42094),
('Georgia', 'F', 64, 28260, 41061),
('Georgia', 'F', 65, 28362, 41673),
('Georgia', 'F', 66, 25762, 35989),
('Georgia', 'F', 67, 25821, 33558),
('Georgia', 'F', 68, 25088, 31984),
('Georgia', 'F', 69, 23890, 29774),
('Georgia', 'F', 70, 24306, 28407),
('Georgia', 'F', 71, 23238, 26523),
('Georgia', 'F', 72, 22806, 25730),
('Georgia', 'F', 73, 22202, 25623),
('Georgia', 'F', 74, 21703, 22911),
('Georgia', 'F', 75, 21321, 22687),
('Georgia', 'F', 76, 20232, 21788),
('Georgia', 'F', 77, 19272, 20327),
('Georgia', 'F', 78, 18703, 20254),
('Georgia', 'F', 79, 17747, 19140),
('Georgia', 'F', 80, 17243, 18321),
('Georgia', 'F', 81, 14786, 17365),
('Georgia', 'F', 82, 13573, 16435),
('Georgia', 'F', 83, 12603, 15635),
('Georgia', 'F', 84, 11163, 14282),
('Georgia', 'F', 85, 66159, 86390),
('Hawaii', 'M', 0, 8020, 9474),
('Hawaii', 'M', 1, 7968, 9478),
('Hawaii', 'M', 2, 7904, 8928),
('Hawaii', 'M', 3, 7859, 8693),
('Hawaii', 'M', 4, 8228, 8739),
('Hawaii', 'M', 5, 8343, 8686),
('Hawaii', 'M', 6, 8647, 7899),
('Hawaii', 'M', 7, 8653, 8040),
('Hawaii', 'M', 8, 8875, 7368),
('Hawaii', 'M', 9, 8884, 7370),
('Hawaii', 'M', 10, 8969, 7356),
('Hawaii', 'M', 11, 8522, 7279),
('Hawaii', 'M', 12, 8486, 7677),
('Hawaii', 'M', 13, 8361, 7845),
('Hawaii', 'M', 14, 8308, 8094),
('Hawaii', 'M', 15, 8354, 8263),
('Hawaii', 'M', 16, 8580, 8414),
('Hawaii', 'M', 17, 8563, 8533),
('Hawaii', 'M', 18, 7467, 8527),
('Hawaii', 'M', 19, 6926, 7937),
('Hawaii', 'M', 20, 6891, 7781),
('Hawaii', 'M', 21, 6929, 7819),
('Hawaii', 'M', 22, 6666, 8604),
('Hawaii', 'M', 23, 6855, 8385),
('Hawaii', 'M', 24, 6661, 8942),
('Hawaii', 'M', 25, 6912, 9842),
('Hawaii', 'M', 26, 6575, 8259),
('Hawaii', 'M', 27, 6891, 9663),
('Hawaii', 'M', 28, 7306, 8455),
('Hawaii', 'M', 29, 7748, 8994),
('Hawaii', 'M', 30, 8333, 8386),
('Hawaii', 'M', 31, 7396, 8340),
('Hawaii', 'M', 32, 7604, 7499),
('Hawaii', 'M', 33, 7540, 8001),
('Hawaii', 'M', 34, 7613, 7842),
('Hawaii', 'M', 35, 8489, 7677),
('Hawaii', 'M', 36, 8362, 8610),
('Hawaii', 'M', 37, 8589, 8317),
('Hawaii', 'M', 38, 8789, 8792),
('Hawaii', 'M', 39, 8692, 7886),
('Hawaii', 'M', 40, 9286, 7879),
('Hawaii', 'M', 41, 8987, 8214),
('Hawaii', 'M', 42, 8983, 7892),
('Hawaii', 'M', 43, 8975, 8531),
('Hawaii', 'M', 44, 8945, 8326),
('Hawaii', 'M', 45, 9281, 8443),
('Hawaii', 'M', 46, 8875, 8771),
('Hawaii', 'M', 47, 8783, 8401),
('Hawaii', 'M', 48, 8878, 8887),
('Hawaii', 'M', 49, 8340, 8815),
('Hawaii', 'M', 50, 8975, 8703),
('Hawaii', 'M', 51, 8402, 8868),
('Hawaii', 'M', 52, 8202, 8486),
('Hawaii', 'M', 53, 8026, 8945),
('Hawaii', 'M', 54, 6852, 8577),
('Hawaii', 'M', 55, 6952, 8435),
('Hawaii', 'M', 56, 6613, 8529),
('Hawaii', 'M', 57, 5926, 7908),
('Hawaii', 'M', 58, 5456, 8465),
('Hawaii', 'M', 59, 4961, 7839),
('Hawaii', 'M', 60, 4967, 7855),
('Hawaii', 'M', 61, 4646, 7534),
('Hawaii', 'M', 62, 4551, 6290),
('Hawaii', 'M', 63, 4182, 6311),
('Hawaii', 'M', 64, 4023, 6110),
('Hawaii', 'M', 65, 4033, 5353),
('Hawaii', 'M', 66, 3931, 4947),
('Hawaii', 'M', 67, 3823, 4524),
('Hawaii', 'M', 68, 3884, 4527),
('Hawaii', 'M', 69, 3799, 4198),
('Hawaii', 'M', 70, 3937, 4027),
('Hawaii', 'M', 71, 3798, 3792),
('Hawaii', 'M', 72, 3858, 3570),
('Hawaii', 'M', 73, 3754, 3498),
('Hawaii', 'M', 74, 3594, 3409),
('Hawaii', 'M', 75, 3816, 3188),
('Hawaii', 'M', 76, 3342, 3201),
('Hawaii', 'M', 77, 3256, 3040),
('Hawaii', 'M', 78, 3003, 3130),
('Hawaii', 'M', 79, 2684, 2844),
('Hawaii', 'M', 80, 2514, 2901),
('Hawaii', 'M', 81, 2147, 2731),
('Hawaii', 'M', 82, 1893, 2506),
('Hawaii', 'M', 83, 1729, 2632),
('Hawaii', 'M', 84, 1463, 2227),
('Hawaii', 'M', 85, 7383, 11996),
('Hawaii', 'F', 0, 7619, 8998),
('Hawaii', 'F', 1, 7449, 8679),
('Hawaii', 'F', 2, 7420, 8163),
('Hawaii', 'F', 3, 7522, 7848),
('Hawaii', 'F', 4, 7885, 8207),
('Hawaii', 'F', 5, 7863, 7496),
('Hawaii', 'F', 6, 8223, 7594),
('Hawaii', 'F', 7, 8109, 7369),
('Hawaii', 'F', 8, 8144, 6977),
('Hawaii', 'F', 9, 8603, 6684),
('Hawaii', 'F', 10, 8547, 6860),
('Hawaii', 'F', 11, 7971, 6915),
('Hawaii', 'F', 12, 8039, 7309),
('Hawaii', 'F', 13, 7890, 7301),
('Hawaii', 'F', 14, 7821, 7606),
('Hawaii', 'F', 15, 7699, 7574),
('Hawaii', 'F', 16, 8022, 7428),
('Hawaii', 'F', 17, 8022, 8094),
('Hawaii', 'F', 18, 7318, 8294),
('Hawaii', 'F', 19, 7108, 7051),
('Hawaii', 'F', 20, 7420, 7183),
('Hawaii', 'F', 21, 6980, 7312),
('Hawaii', 'F', 22, 7062, 8131),
('Hawaii', 'F', 23, 7204, 8062),
('Hawaii', 'F', 24, 7149, 8628),
('Hawaii', 'F', 25, 7313, 8459),
('Hawaii', 'F', 26, 7287, 8457),
('Hawaii', 'F', 27, 7442, 7838),
('Hawaii', 'F', 28, 7925, 9338),
('Hawaii', 'F', 29, 8410, 8329),
('Hawaii', 'F', 30, 8723, 7938),
('Hawaii', 'F', 31, 8187, 7645),
('Hawaii', 'F', 32, 8269, 7696),
('Hawaii', 'F', 33, 8150, 8146),
('Hawaii', 'F', 34, 8607, 7643),
('Hawaii', 'F', 35, 9164, 8089),
('Hawaii', 'F', 36, 9220, 8251),
('Hawaii', 'F', 37, 9414, 8504),
('Hawaii', 'F', 38, 9195, 8877),
('Hawaii', 'F', 39, 9208, 8284),
('Hawaii', 'F', 40, 9764, 8358),
('Hawaii', 'F', 41, 9167, 7744),
('Hawaii', 'F', 42, 9361, 8117),
('Hawaii', 'F', 43, 9457, 8956),
('Hawaii', 'F', 44, 9253, 8734),
('Hawaii', 'F', 45, 9274, 9130),
('Hawaii', 'F', 46, 9298, 9193),
('Hawaii', 'F', 47, 9112, 8989),
('Hawaii', 'F', 48, 8770, 9347),
('Hawaii', 'F', 49, 8627, 9120),
('Hawaii', 'F', 50, 8816, 9216),
('Hawaii', 'F', 51, 8273, 9205),
('Hawaii', 'F', 52, 8322, 9076),
('Hawaii', 'F', 53, 7911, 9019),
('Hawaii', 'F', 54, 6956, 8823),
('Hawaii', 'F', 55, 6994, 8811),
('Hawaii', 'F', 56, 6806, 8604),
('Hawaii', 'F', 57, 6197, 8205),
('Hawaii', 'F', 58, 5571, 8463),
('Hawaii', 'F', 59, 5205, 7784),
('Hawaii', 'F', 60, 5161, 8020),
('Hawaii', 'F', 61, 4892, 7425),
('Hawaii', 'F', 62, 4921, 6471),
('Hawaii', 'F', 63, 4582, 6501),
('Hawaii', 'F', 64, 4555, 6333),
('Hawaii', 'F', 65, 4724, 5777),
('Hawaii', 'F', 66, 4453, 5309),
('Hawaii', 'F', 67, 4752, 5010),
('Hawaii', 'F', 68, 4631, 4967),
('Hawaii', 'F', 69, 4731, 4700),
('Hawaii', 'F', 70, 4937, 4683),
('Hawaii', 'F', 71, 4780, 4399),
('Hawaii', 'F', 72, 4743, 4326),
('Hawaii', 'F', 73, 4679, 4565),
('Hawaii', 'F', 74, 4419, 4104),
('Hawaii', 'F', 75, 4594, 4402),
('Hawaii', 'F', 76, 4094, 4269),
('Hawaii', 'F', 77, 3901, 4291),
('Hawaii', 'F', 78, 3605, 4457),
('Hawaii', 'F', 79, 3276, 4243),
('Hawaii', 'F', 80, 3185, 4105),
('Hawaii', 'F', 81, 2694, 3930),
('Hawaii', 'F', 82, 2543, 3628),
('Hawaii', 'F', 83, 2370, 3758),
('Hawaii', 'F', 84, 2146, 3218),
('Hawaii', 'F', 85, 10456, 19685),
('Idaho', 'M', 0, 10208, 12708),
('Idaho', 'M', 1, 10112, 12719),
('Idaho', 'M', 2, 9974, 12463),
('Idaho', 'M', 3, 9928, 12209),
('Idaho', 'M', 4, 9948, 12261),
('Idaho', 'M', 5, 9992, 11855),
('Idaho', 'M', 6, 10032, 11670),
('Idaho', 'M', 7, 10368, 11764),
('Idaho', 'M', 8, 10600, 11505),
('Idaho', 'M', 9, 10780, 11367),
('Idaho', 'M', 10, 11034, 11214),
('Idaho', 'M', 11, 10624, 11218),
('Idaho', 'M', 12, 10729, 11251),
('Idaho', 'M', 13, 10592, 11263),
('Idaho', 'M', 14, 11012, 11241),
('Idaho', 'M', 15, 11323, 11460),
('Idaho', 'M', 16, 11421, 11729),
('Idaho', 'M', 17, 11563, 11858),
('Idaho', 'M', 18, 11761, 11818),
('Idaho', 'M', 19, 10224, 9483),
('Idaho', 'M', 20, 9434, 9026),
('Idaho', 'M', 21, 10161, 10409),
('Idaho', 'M', 22, 10067, 11712),
('Idaho', 'M', 23, 9774, 11692),
('Idaho', 'M', 24, 8838, 11556),
('Idaho', 'M', 25, 8812, 11528),
('Idaho', 'M', 26, 8423, 11243),
('Idaho', 'M', 27, 8378, 12454),
('Idaho', 'M', 28, 8517, 11917),
('Idaho', 'M', 29, 9060, 11717),
('Idaho', 'M', 30, 8976, 10144),
('Idaho', 'M', 31, 8598, 10617),
('Idaho', 'M', 32, 8251, 9594),
('Idaho', 'M', 33, 8303, 9821),
('Idaho', 'M', 34, 8432, 9232),
('Idaho', 'M', 35, 8844, 9611),
('Idaho', 'M', 36, 9111, 9572),
('Idaho', 'M', 37, 9479, 10434),
('Idaho', 'M', 38, 9789, 10187),
('Idaho', 'M', 39, 9839, 9444),
('Idaho', 'M', 40, 10287, 9284),
('Idaho', 'M', 41, 9519, 9184),
('Idaho', 'M', 42, 9776, 9613),
('Idaho', 'M', 43, 9914, 9823),
('Idaho', 'M', 44, 9526, 9940),
('Idaho', 'M', 45, 9772, 10255),
('Idaho', 'M', 46, 9586, 10628),
('Idaho', 'M', 47, 9398, 10642),
('Idaho', 'M', 48, 9120, 10893),
('Idaho', 'M', 49, 8672, 10298),
('Idaho', 'M', 50, 8521, 10165),
('Idaho', 'M', 51, 8270, 10479),
('Idaho', 'M', 52, 8217, 10055),
('Idaho', 'M', 53, 8481, 10189),
('Idaho', 'M', 54, 6402, 9903),
('Idaho', 'M', 55, 6424, 9760),
('Idaho', 'M', 56, 6293, 9465),
('Idaho', 'M', 57, 6376, 9029),
('Idaho', 'M', 58, 5720, 8864),
('Idaho', 'M', 59, 5392, 8571),
('Idaho', 'M', 60, 5256, 8667),
('Idaho', 'M', 61, 5070, 8742),
('Idaho', 'M', 62, 4693, 6670),
('Idaho', 'M', 63, 4685, 6631),
('Idaho', 'M', 64, 4245, 6643),
('Idaho', 'M', 65, 4402, 6500),
('Idaho', 'M', 66, 3938, 5766),
('Idaho', 'M', 67, 3860, 5428),
('Idaho', 'M', 68, 3774, 5120),
('Idaho', 'M', 69, 3493, 4907),
('Idaho', 'M', 70, 3726, 4374),
('Idaho', 'M', 71, 3458, 4408),
('Idaho', 'M', 72, 3348, 3896),
('Idaho', 'M', 73, 3224, 3926),
('Idaho', 'M', 74, 3052, 3493),
('Idaho', 'M', 75, 2980, 3342),
('Idaho', 'M', 76, 2868, 3240),
('Idaho', 'M', 77, 2561, 2848),
('Idaho', 'M', 78, 2545, 3001),
('Idaho', 'M', 79, 2390, 2672),
('Idaho', 'M', 80, 2137, 2517),
('Idaho', 'M', 81, 1880, 2400),
('Idaho', 'M', 82, 1814, 2159),
('Idaho', 'M', 83, 1568, 1985),
('Idaho', 'M', 84, 1379, 1855),
('Idaho', 'M', 85, 6090, 9243),
('Idaho', 'F', 0, 9755, 12063),
('Idaho', 'F', 1, 9579, 12063),
('Idaho', 'F', 2, 9244, 11925),
('Idaho', 'F', 3, 9537, 11796),
('Idaho', 'F', 4, 9614, 11539),
('Idaho', 'F', 5, 9387, 11181),
('Idaho', 'F', 6, 9626, 11337),
('Idaho', 'F', 7, 9766, 11365),
('Idaho', 'F', 8, 9880, 10965),
('Idaho', 'F', 9, 10152, 10850),
('Idaho', 'F', 10, 10362, 10389),
('Idaho', 'F', 11, 10316, 10683),
('Idaho', 'F', 12, 10033, 10819),
('Idaho', 'F', 13, 10181, 10496),
('Idaho', 'F', 14, 10323, 10642),
('Idaho', 'F', 15, 10729, 10774),
('Idaho', 'F', 16, 10575, 10859),
('Idaho', 'F', 17, 10788, 11139),
('Idaho', 'F', 18, 11254, 11279),
('Idaho', 'F', 19, 11515, 10804),
('Idaho', 'F', 20, 10428, 9489),
('Idaho', 'F', 21, 9229, 9011),
('Idaho', 'F', 22, 8733, 9548),
('Idaho', 'F', 23, 8784, 10010),
('Idaho', 'F', 24, 8070, 10159),
('Idaho', 'F', 25, 8078, 10061),
('Idaho', 'F', 26, 7911, 10443),
('Idaho', 'F', 27, 7837, 11216),
('Idaho', 'F', 28, 8181, 11349),
('Idaho', 'F', 29, 8662, 11684),
('Idaho', 'F', 30, 8646, 9996),
('Idaho', 'F', 31, 8428, 10347),
('Idaho', 'F', 32, 7875, 9167),
('Idaho', 'F', 33, 8039, 9414),
('Idaho', 'F', 34, 8218, 9162),
('Idaho', 'F', 35, 8720, 9121),
('Idaho', 'F', 36, 9132, 9568),
('Idaho', 'F', 37, 9556, 9926),
('Idaho', 'F', 38, 9532, 9735),
('Idaho', 'F', 39, 9867, 9458),
('Idaho', 'F', 40, 9879, 9080),
('Idaho', 'F', 41, 9801, 9138),
('Idaho', 'F', 42, 9876, 9286),
('Idaho', 'F', 43, 9928, 9743),
('Idaho', 'F', 44, 9619, 9967),
('Idaho', 'F', 45, 9817, 10458),
('Idaho', 'F', 46, 9580, 10454),
('Idaho', 'F', 47, 9325, 10848),
('Idaho', 'F', 48, 8941, 10523),
('Idaho', 'F', 49, 8574, 10493),
('Idaho', 'F', 50, 8514, 10535),
('Idaho', 'F', 51, 8077, 10495),
('Idaho', 'F', 52, 8052, 10318),
('Idaho', 'F', 53, 8083, 10331),
('Idaho', 'F', 54, 6290, 9993),
('Idaho', 'F', 55, 6379, 9773),
('Idaho', 'F', 56, 6430, 9638),
('Idaho', 'F', 57, 6448, 9137),
('Idaho', 'F', 58, 5677, 9024),
('Idaho', 'F', 59, 5390, 8673),
('Idaho', 'F', 60, 5221, 8700),
('Idaho', 'F', 61, 4920, 8570),
('Idaho', 'F', 62, 4806, 6788),
('Idaho', 'F', 63, 4509, 6797),
('Idaho', 'F', 64, 4431, 6811),
('Idaho', 'F', 65, 4476, 6681),
('Idaho', 'F', 66, 4106, 5924),
('Idaho', 'F', 67, 3991, 5502),
('Idaho', 'F', 68, 4138, 5296),
('Idaho', 'F', 69, 3983, 4916),
('Idaho', 'F', 70, 4043, 4718),
('Idaho', 'F', 71, 3782, 4374),
('Idaho', 'F', 72, 3827, 4269),
('Idaho', 'F', 73, 3791, 4311),
('Idaho', 'F', 74, 3589, 3922),
('Idaho', 'F', 75, 3699, 3756),
('Idaho', 'F', 76, 3552, 3808),
('Idaho', 'F', 77, 3416, 3597),
('Idaho', 'F', 78, 3361, 3593),
('Idaho', 'F', 79, 3192, 3306),
('Idaho', 'F', 80, 3052, 3310),
('Idaho', 'F', 81, 2777, 3153),
('Idaho', 'F', 82, 2572, 2847),
('Idaho', 'F', 83, 2348, 2890),
('Idaho', 'F', 84, 2135, 2639),
('Idaho', 'F', 85, 12208, 16258),
('Illinois', 'M', 0, 89600, 95012),
('Illinois', 'M', 1, 88445, 91829),
('Illinois', 'M', 2, 88729, 89547),
('Illinois', 'M', 3, 88868, 90037),
('Illinois', 'M', 4, 91947, 91111),
('Illinois', 'M', 5, 93894, 89802),
('Illinois', 'M', 6, 93676, 88931),
('Illinois', 'M', 7, 94818, 90940),
('Illinois', 'M', 8, 95035, 86943),
('Illinois', 'M', 9, 96436, 86055),
('Illinois', 'M', 10, 97280, 86565),
('Illinois', 'M', 11, 94029, 86606),
('Illinois', 'M', 12, 92402, 89596),
('Illinois', 'M', 13, 89926, 91661),
('Illinois', 'M', 14, 90717, 91256),
('Illinois', 'M', 15, 92178, 92729),
('Illinois', 'M', 16, 90587, 93083),
('Illinois', 'M', 17, 92782, 94541),
('Illinois', 'M', 18, 90997, 100253),
('Illinois', 'M', 19, 89629, 96588),
('Illinois', 'M', 20, 91040, 95460),
('Illinois', 'M', 21, 85176, 91373),
('Illinois', 'M', 22, 84372, 90723),
('Illinois', 'M', 23, 85529, 91982),
('Illinois', 'M', 24, 84549, 90237),
('Illinois', 'M', 25, 87630, 95217),
('Illinois', 'M', 26, 84205, 93351),
('Illinois', 'M', 27, 87481, 92949),
('Illinois', 'M', 28, 91586, 93929),
('Illinois', 'M', 29, 95226, 89559),
('Illinois', 'M', 30, 98572, 89598),
('Illinois', 'M', 31, 91469, 90093),
('Illinois', 'M', 32, 89813, 87703),
('Illinois', 'M', 33, 89694, 90090),
('Illinois', 'M', 34, 91474, 84679),
('Illinois', 'M', 35, 97796, 86172),
('Illinois', 'M', 36, 97688, 90250),
('Illinois', 'M', 37, 97664, 92422),
('Illinois', 'M', 38, 98705, 95862),
('Illinois', 'M', 39, 100103, 88235),
('Illinois', 'M', 40, 103045, 87299),
('Illinois', 'M', 41, 98235, 87285),
('Illinois', 'M', 42, 97946, 88474),
('Illinois', 'M', 43, 96490, 94799),
('Illinois', 'M', 44, 92713, 94893),
('Illinois', 'M', 45, 93817, 94278),
('Illinois', 'M', 46, 87706, 95633),
('Illinois', 'M', 47, 85685, 96731),
('Illinois', 'M', 48, 83445, 99113),
('Illinois', 'M', 49, 81182, 94273),
('Illinois', 'M', 50, 81005, 93425),
('Illinois', 'M', 51, 75942, 92133),
('Illinois', 'M', 52, 75896, 87504),
('Illinois', 'M', 53, 78933, 88458),
('Illinois', 'M', 54, 58953, 82456),
('Illinois', 'M', 55, 57885, 79601),
('Illinois', 'M', 56, 58143, 77447),
('Illinois', 'M', 57, 60590, 74349),
('Illinois', 'M', 58, 54120, 73646),
('Illinois', 'M', 59, 49046, 68179),
('Illinois', 'M', 60, 47509, 67186),
('Illinois', 'M', 61, 45588, 70789),
('Illinois', 'M', 62, 44604, 50790),
('Illinois', 'M', 63, 41700, 49725),
('Illinois', 'M', 64, 40316, 48773),
('Illinois', 'M', 65, 39696, 51139),
('Illinois', 'M', 66, 35784, 45248),
('Illinois', 'M', 67, 35251, 40085),
('Illinois', 'M', 68, 34729, 38613),
('Illinois', 'M', 69, 34914, 36909),
('Illinois', 'M', 70, 35307, 35929),
('Illinois', 'M', 71, 33112, 32944),
('Illinois', 'M', 72, 32673, 31610),
('Illinois', 'M', 73, 31381, 30767),
('Illinois', 'M', 74, 30103, 26962),
('Illinois', 'M', 75, 29050, 26065),
('Illinois', 'M', 76, 27274, 24866),
('Illinois', 'M', 77, 25325, 24059),
('Illinois', 'M', 78, 23794, 23908),
('Illinois', 'M', 79, 21932, 21598),
('Illinois', 'M', 80, 19729, 20725),
('Illinois', 'M', 81, 17222, 19151),
('Illinois', 'M', 82, 15811, 17433),
('Illinois', 'M', 83, 13553, 16064),
('Illinois', 'M', 84, 12073, 14569),
('Illinois', 'M', 85, 53719, 72621),
('Illinois', 'F', 0, 85910, 90286),
('Illinois', 'F', 1, 84396, 88126),
('Illinois', 'F', 2, 84764, 86291),
('Illinois', 'F', 3, 85598, 85170),
('Illinois', 'F', 4, 87729, 86959),
('Illinois', 'F', 5, 89085, 85336),
('Illinois', 'F', 6, 89608, 85210),
('Illinois', 'F', 7, 89876, 87083),
('Illinois', 'F', 8, 90982, 83463),
('Illinois', 'F', 9, 91913, 82137),
('Illinois', 'F', 10, 93569, 82662),
('Illinois', 'F', 11, 89694, 83484),
('Illinois', 'F', 12, 87574, 85594),
('Illinois', 'F', 13, 85843, 86851),
('Illinois', 'F', 14, 87057, 87519),
('Illinois', 'F', 15, 86835, 87794),
('Illinois', 'F', 16, 85249, 88919),
('Illinois', 'F', 17, 86930, 89900),
('Illinois', 'F', 18, 84902, 96446),
('Illinois', 'F', 19, 85953, 92743),
('Illinois', 'F', 20, 87124, 91653),
('Illinois', 'F', 21, 82416, 88640),
('Illinois', 'F', 22, 81888, 88671),
('Illinois', 'F', 23, 83219, 88442),
('Illinois', 'F', 24, 82301, 88009),
('Illinois', 'F', 25, 84817, 92928),
('Illinois', 'F', 26, 82888, 90322),
('Illinois', 'F', 27, 85594, 89980),
('Illinois', 'F', 28, 89682, 90458),
('Illinois', 'F', 29, 94496, 86087),
('Illinois', 'F', 30, 96361, 85098),
('Illinois', 'F', 31, 90025, 86881),
('Illinois', 'F', 32, 89414, 83797),
('Illinois', 'F', 33, 89087, 85142),
('Illinois', 'F', 34, 91233, 81825),
('Illinois', 'F', 35, 98151, 84362),
('Illinois', 'F', 36, 98588, 87900),
('Illinois', 'F', 37, 99155, 91106),
('Illinois', 'F', 38, 100045, 93812),
('Illinois', 'F', 39, 102074, 87686),
('Illinois', 'F', 40, 104762, 87678),
('Illinois', 'F', 41, 99919, 86734),
('Illinois', 'F', 42, 100474, 88419),
('Illinois', 'F', 43, 98601, 95458),
('Illinois', 'F', 44, 95485, 95101),
('Illinois', 'F', 45, 95859, 96963),
('Illinois', 'F', 46, 90902, 97582),
('Illinois', 'F', 47, 88623, 98107),
('Illinois', 'F', 48, 85539, 100824),
('Illinois', 'F', 49, 84865, 96202),
('Illinois', 'F', 50, 83791, 96290),
('Illinois', 'F', 51, 80154, 94537),
('Illinois', 'F', 52, 79736, 90986),
('Illinois', 'F', 53, 83261, 90778),
('Illinois', 'F', 54, 62200, 85252),
('Illinois', 'F', 55, 61540, 83956),
('Illinois', 'F', 56, 62191, 79770),
('Illinois', 'F', 57, 65588, 78547),
('Illinois', 'F', 58, 58373, 76929),
('Illinois', 'F', 59, 53406, 73154),
('Illinois', 'F', 60, 52517, 72032),
('Illinois', 'F', 61, 50588, 76361),
('Illinois', 'F', 62, 49457, 55862),
('Illinois', 'F', 63, 46140, 54569),
('Illinois', 'F', 64, 46040, 54698),
('Illinois', 'F', 65, 45501, 58118),
('Illinois', 'F', 66, 41990, 51610),
('Illinois', 'F', 67, 42327, 46695),
('Illinois', 'F', 68, 42526, 45791),
('Illinois', 'F', 69, 43328, 43938),
('Illinois', 'F', 70, 44539, 43143),
('Illinois', 'F', 71, 41731, 39827),
('Illinois', 'F', 72, 42175, 39581),
('Illinois', 'F', 73, 42123, 38613),
('Illinois', 'F', 74, 40681, 34897),
('Illinois', 'F', 75, 40986, 34884),
('Illinois', 'F', 76, 39676, 34261),
('Illinois', 'F', 77, 37514, 34377),
('Illinois', 'F', 78, 36875, 35020),
('Illinois', 'F', 79, 34777, 31819),
('Illinois', 'F', 80, 33171, 31257),
('Illinois', 'F', 81, 29900, 30560),
('Illinois', 'F', 82, 28488, 28584),
('Illinois', 'F', 83, 26257, 28316),
('Illinois', 'F', 84, 23947, 26452),
('Illinois', 'F', 85, 140079, 166300),
('Indiana', 'M', 0, 43674, 46010),
('Indiana', 'M', 1, 43063, 45399),
('Indiana', 'M', 2, 42898, 45684),
('Indiana', 'M', 3, 42652, 44306),
('Indiana', 'M', 4, 44157, 45602),
('Indiana', 'M', 5, 43971, 44169),
('Indiana', 'M', 6, 44602, 43961),
('Indiana', 'M', 7, 45377, 45312),
('Indiana', 'M', 8, 46239, 44347),
('Indiana', 'M', 9, 46334, 43757),
('Indiana', 'M', 10, 47702, 43708),
('Indiana', 'M', 11, 45625, 43375),
('Indiana', 'M', 12, 45125, 45099),
('Indiana', 'M', 13, 44596, 44840),
('Indiana', 'M', 14, 44848, 45535),
('Indiana', 'M', 15, 45985, 46132),
('Indiana', 'M', 16, 44731, 47072),
('Indiana', 'M', 17, 46146, 46849),
('Indiana', 'M', 18, 47433, 45788),
('Indiana', 'M', 19, 49270, 46174),
('Indiana', 'M', 20, 48931, 45740),
('Indiana', 'M', 21, 45602, 44221),
('Indiana', 'M', 22, 43496, 44142),
('Indiana', 'M', 23, 41079, 42799),
('Indiana', 'M', 24, 38822, 40903),
('Indiana', 'M', 25, 39908, 41442),
('Indiana', 'M', 26, 39037, 44762),
('Indiana', 'M', 27, 40098, 46524),
('Indiana', 'M', 28, 41753, 47180),
('Indiana', 'M', 29, 44510, 45294),
('Indiana', 'M', 30, 44316, 42868),
('Indiana', 'M', 31, 42365, 42552),
('Indiana', 'M', 32, 41270, 40377),
('Indiana', 'M', 33, 41787, 41522),
('Indiana', 'M', 34, 42664, 39722),
('Indiana', 'M', 35, 46392, 41332),
('Indiana', 'M', 36, 47570, 42462),
('Indiana', 'M', 37, 46933, 45431),
('Indiana', 'M', 38, 47327, 44647),
('Indiana', 'M', 39, 48531, 42619),
('Indiana', 'M', 40, 49663, 41509),
('Indiana', 'M', 41, 47759, 42007),
('Indiana', 'M', 42, 48743, 43218),
('Indiana', 'M', 43, 47906, 46556),
('Indiana', 'M', 44, 46430, 47803),
('Indiana', 'M', 45, 46814, 46716),
('Indiana', 'M', 46, 45519, 47194),
('Indiana', 'M', 47, 43500, 48448),
('Indiana', 'M', 48, 42215, 48903),
('Indiana', 'M', 49, 40702, 46827),
('Indiana', 'M', 50, 40386, 48029),
('Indiana', 'M', 51, 39317, 46278),
('Indiana', 'M', 52, 38334, 44816),
('Indiana', 'M', 53, 40511, 45161),
('Indiana', 'M', 54, 29806, 43427),
('Indiana', 'M', 55, 30204, 41295),
('Indiana', 'M', 56, 29369, 39903),
('Indiana', 'M', 57, 31360, 38145),
('Indiana', 'M', 58, 27605, 37352),
('Indiana', 'M', 59, 25647, 36428),
('Indiana', 'M', 60, 24544, 35020),
('Indiana', 'M', 61, 23878, 36969),
('Indiana', 'M', 62, 23017, 26697),
('Indiana', 'M', 63, 21236, 26707),
('Indiana', 'M', 64, 20789, 25601),
('Indiana', 'M', 65, 20357, 27378),
('Indiana', 'M', 66, 18415, 23561),
('Indiana', 'M', 67, 18415, 21537),
('Indiana', 'M', 68, 18069, 20502),
('Indiana', 'M', 69, 17937, 19671),
('Indiana', 'M', 70, 17906, 18834),
('Indiana', 'M', 71, 17135, 17033),
('Indiana', 'M', 72, 16932, 16513),
('Indiana', 'M', 73, 16293, 15900),
('Indiana', 'M', 74, 15094, 14024),
('Indiana', 'M', 75, 14883, 13667),
('Indiana', 'M', 76, 13751, 13013),
('Indiana', 'M', 77, 12571, 12488),
('Indiana', 'M', 78, 12094, 12323),
('Indiana', 'M', 79, 10881, 11249),
('Indiana', 'M', 80, 9508, 10693),
('Indiana', 'M', 81, 8369, 9979),
('Indiana', 'M', 82, 7720, 8795),
('Indiana', 'M', 83, 6507, 8345),
('Indiana', 'M', 84, 5871, 7318),
('Indiana', 'M', 85, 25660, 35991),
('Indiana', 'F', 0, 41680, 43813),
('Indiana', 'F', 1, 41262, 43691),
('Indiana', 'F', 2, 41155, 43193),
('Indiana', 'F', 3, 40865, 42592),
('Indiana', 'F', 4, 41634, 42799),
('Indiana', 'F', 5, 41731, 42136),
('Indiana', 'F', 6, 42156, 42075),
('Indiana', 'F', 7, 42958, 43431),
('Indiana', 'F', 8, 43344, 42626),
('Indiana', 'F', 9, 44429, 42193),
('Indiana', 'F', 10, 44874, 42125),
('Indiana', 'F', 11, 43697, 41810),
('Indiana', 'F', 12, 42720, 42595),
('Indiana', 'F', 13, 42439, 42640),
('Indiana', 'F', 14, 43270, 43089),
('Indiana', 'F', 15, 43127, 43853),
('Indiana', 'F', 16, 42293, 44057),
('Indiana', 'F', 17, 43209, 44805),
('Indiana', 'F', 18, 44635, 42992),
('Indiana', 'F', 19, 47857, 43979),
('Indiana', 'F', 20, 47806, 43513),
('Indiana', 'F', 21, 44720, 43301),
('Indiana', 'F', 22, 41511, 42085),
('Indiana', 'F', 23, 39363, 40572),
('Indiana', 'F', 24, 37575, 39217),
('Indiana', 'F', 25, 38771, 39519),
('Indiana', 'F', 26, 38101, 42505),
('Indiana', 'F', 27, 39071, 46195),
('Indiana', 'F', 28, 41019, 46529),
('Indiana', 'F', 29, 43792, 43953),
('Indiana', 'F', 30, 43331, 41695),
('Indiana', 'F', 31, 41075, 40561),
('Indiana', 'F', 32, 40491, 39283),
('Indiana', 'F', 33, 41507, 40556),
('Indiana', 'F', 34, 42830, 39486),
('Indiana', 'F', 35, 46056, 39698),
('Indiana', 'F', 36, 47700, 42114),
('Indiana', 'F', 37, 47488, 44422),
('Indiana', 'F', 38, 48318, 44219),
('Indiana', 'F', 39, 49459, 41899),
('Indiana', 'F', 40, 49638, 41072),
('Indiana', 'F', 41, 48675, 41902),
('Indiana', 'F', 42, 49095, 42998),
('Indiana', 'F', 43, 48744, 45899),
('Indiana', 'F', 44, 46754, 47670),
('Indiana', 'F', 45, 46715, 47245),
('Indiana', 'F', 46, 45622, 47603),
('Indiana', 'F', 47, 44103, 48815),
('Indiana', 'F', 48, 43063, 49025),
('Indiana', 'F', 49, 41396, 47741),
('Indiana', 'F', 50, 41533, 48119),
('Indiana', 'F', 51, 40584, 48167),
('Indiana', 'F', 52, 39812, 45697),
('Indiana', 'F', 53, 42482, 45556),
('Indiana', 'F', 54, 30690, 44272),
('Indiana', 'F', 55, 31156, 42828),
('Indiana', 'F', 56, 31137, 41397),
('Indiana', 'F', 57, 32859, 39606),
('Indiana', 'F', 58, 29221, 39527),
('Indiana', 'F', 59, 27477, 38490),
('Indiana', 'F', 60, 26303, 37339),
('Indiana', 'F', 61, 25572, 40252),
('Indiana', 'F', 62, 24980, 28556),
('Indiana', 'F', 63, 23323, 28728),
('Indiana', 'F', 64, 23107, 28473),
('Indiana', 'F', 65, 23069, 30134),
('Indiana', 'F', 66, 21374, 26542),
('Indiana', 'F', 67, 21965, 24629),
('Indiana', 'F', 68, 21601, 23497),
('Indiana', 'F', 69, 21908, 22681),
('Indiana', 'F', 70, 22485, 22119),
('Indiana', 'F', 71, 21620, 20542),
('Indiana', 'F', 72, 21728, 20162),
('Indiana', 'F', 73, 21324, 19968),
('Indiana', 'F', 74, 20780, 18196),
('Indiana', 'F', 75, 20700, 18432),
('Indiana', 'F', 76, 20194, 17863),
('Indiana', 'F', 77, 18920, 17675),
('Indiana', 'F', 78, 18383, 17915),
('Indiana', 'F', 79, 17679, 16791),
('Indiana', 'F', 80, 16235, 16506),
('Indiana', 'F', 81, 14386, 15626),
('Indiana', 'F', 82, 13834, 14915),
('Indiana', 'F', 83, 12486, 14491),
('Indiana', 'F', 84, 11890, 13682),
('Indiana', 'F', 85, 66799, 82659),
('Iowa', 'M', 0, 19282, 21197),
('Iowa', 'M', 1, 19221, 21439),
('Iowa', 'M', 2, 19211, 20786),
('Iowa', 'M', 3, 19310, 20007),
('Iowa', 'M', 4, 19531, 19690),
('Iowa', 'M', 5, 19760, 19638),
('Iowa', 'M', 6, 20126, 19635),
('Iowa', 'M', 7, 20739, 19555),
('Iowa', 'M', 8, 20962, 19523),
('Iowa', 'M', 9, 21615, 19431),
('Iowa', 'M', 10, 21992, 19439),
('Iowa', 'M', 11, 21614, 19565),
('Iowa', 'M', 12, 21255, 19839),
('Iowa', 'M', 13, 21378, 20118),
('Iowa', 'M', 14, 22024, 20535),
('Iowa', 'M', 15, 22698, 21261),
('Iowa', 'M', 16, 22490, 21395),
('Iowa', 'M', 17, 23053, 22016),
('Iowa', 'M', 18, 23817, 21661),
('Iowa', 'M', 19, 24032, 24365),
('Iowa', 'M', 20, 24082, 24255),
('Iowa', 'M', 21, 22211, 22268),
('Iowa', 'M', 22, 20866, 22461),
('Iowa', 'M', 23, 19305, 20805),
('Iowa', 'M', 24, 18046, 20374),
('Iowa', 'M', 25, 18301, 19049),
('Iowa', 'M', 26, 16860, 22323),
('Iowa', 'M', 27, 16889, 19752),
('Iowa', 'M', 28, 18202, 18907),
('Iowa', 'M', 29, 19194, 19762),
('Iowa', 'M', 30, 19677, 17794),
('Iowa', 'M', 31, 18809, 18478),
('Iowa', 'M', 32, 18116, 17008),
('Iowa', 'M', 33, 18522, 18509),
('Iowa', 'M', 34, 19139, 16995),
('Iowa', 'M', 35, 20553, 16826),
('Iowa', 'M', 36, 21175, 18287),
('Iowa', 'M', 37, 21472, 19324),
('Iowa', 'M', 38, 21931, 19872),
('Iowa', 'M', 39, 22890, 19354),
('Iowa', 'M', 40, 23276, 18491),
('Iowa', 'M', 41, 22644, 18734),
('Iowa', 'M', 42, 22755, 19325),
('Iowa', 'M', 43, 22909, 20849),
('Iowa', 'M', 44, 22193, 21543),
('Iowa', 'M', 45, 22781, 21707),
('Iowa', 'M', 46, 21800, 22010),
('Iowa', 'M', 47, 21345, 22772),
('Iowa', 'M', 48, 21521, 23230),
('Iowa', 'M', 49, 20349, 22500),
('Iowa', 'M', 50, 19850, 22412),
('Iowa', 'M', 51, 18789, 22598),
('Iowa', 'M', 52, 18505, 21629),
('Iowa', 'M', 53, 19528, 22002),
('Iowa', 'M', 54, 14262, 21067),
('Iowa', 'M', 55, 14168, 20473),
('Iowa', 'M', 56, 14068, 20500),
('Iowa', 'M', 57, 14594, 19246),
('Iowa', 'M', 58, 13331, 18875),
('Iowa', 'M', 59, 12506, 17579),
('Iowa', 'M', 60, 12057, 17224),
('Iowa', 'M', 61, 11681, 18273),
('Iowa', 'M', 62, 11247, 13025),
('Iowa', 'M', 63, 11240, 12777),
('Iowa', 'M', 64, 10809, 12730),
('Iowa', 'M', 65, 10523, 13035),
('Iowa', 'M', 66, 9654, 11737),
('Iowa', 'M', 67, 9864, 10760),
('Iowa', 'M', 68, 9678, 10376),
('Iowa', 'M', 69, 9684, 9982),
('Iowa', 'M', 70, 9396, 9452),
('Iowa', 'M', 71, 9513, 9316),
('Iowa', 'M', 72, 9560, 8854),
('Iowa', 'M', 73, 9326, 8576),
('Iowa', 'M', 74, 8837, 7516),
('Iowa', 'M', 75, 8457, 7631),
('Iowa', 'M', 76, 8008, 7218),
('Iowa', 'M', 77, 7499, 7091),
('Iowa', 'M', 78, 7208, 6554),
('Iowa', 'M', 79, 6705, 6526),
('Iowa', 'M', 80, 6114, 6320),
('Iowa', 'M', 81, 5408, 5987),
('Iowa', 'M', 82, 5050, 5348),
('Iowa', 'M', 83, 4399, 5053),
('Iowa', 'M', 84, 3981, 4497),
('Iowa', 'M', 85, 18200, 24111),
('Iowa', 'F', 0, 18366, 20284),
('Iowa', 'F', 1, 18306, 20126),
('Iowa', 'F', 2, 18233, 19755),
('Iowa', 'F', 3, 18264, 19074),
('Iowa', 'F', 4, 18391, 18963),
('Iowa', 'F', 5, 18889, 19082),
('Iowa', 'F', 6, 19118, 18563),
('Iowa', 'F', 7, 19647, 18989),
('Iowa', 'F', 8, 20185, 18617),
('Iowa', 'F', 9, 20354, 18569),
('Iowa', 'F', 10, 20893, 18455),
('Iowa', 'F', 11, 20383, 18586),
('Iowa', 'F', 12, 20153, 18643),
('Iowa', 'F', 13, 20250, 19162),
('Iowa', 'F', 14, 20958, 19484),
('Iowa', 'F', 15, 21455, 19951),
('Iowa', 'F', 16, 21122, 20547),
('Iowa', 'F', 17, 21599, 20694),
('Iowa', 'F', 18, 22709, 21242),
('Iowa', 'F', 19, 23853, 23645),
('Iowa', 'F', 20, 23534, 22991),
('Iowa', 'F', 21, 21458, 21978),
('Iowa', 'F', 22, 19984, 21499),
('Iowa', 'F', 23, 18199, 19797),
('Iowa', 'F', 24, 17235, 18756),
('Iowa', 'F', 25, 17296, 17831),
('Iowa', 'F', 26, 16166, 20723),
('Iowa', 'F', 27, 16482, 18493),
('Iowa', 'F', 28, 17507, 19152),
('Iowa', 'F', 29, 18831, 18197),
('Iowa', 'F', 30, 18457, 17050),
('Iowa', 'F', 31, 18258, 17382),
('Iowa', 'F', 32, 17577, 17105),
('Iowa', 'F', 33, 18177, 17528),
('Iowa', 'F', 34, 18620, 16475),
('Iowa', 'F', 35, 19825, 16665),
('Iowa', 'F', 36, 21236, 17740),
('Iowa', 'F', 37, 21806, 19341),
('Iowa', 'F', 38, 22553, 18844),
('Iowa', 'F', 39, 23064, 18540),
('Iowa', 'F', 40, 23274, 17889),
('Iowa', 'F', 41, 22380, 18665),
('Iowa', 'F', 42, 22811, 18740),
('Iowa', 'F', 43, 22802, 20178),
('Iowa', 'F', 44, 22356, 21317),
('Iowa', 'F', 45, 22055, 21493),
('Iowa', 'F', 46, 21714, 22512),
('Iowa', 'F', 47, 21149, 23067),
('Iowa', 'F', 48, 20809, 23009),
('Iowa', 'F', 49, 20066, 21961),
('Iowa', 'F', 50, 19176, 22741),
('Iowa', 'F', 51, 18789, 22271),
('Iowa', 'F', 52, 18655, 21944),
('Iowa', 'F', 53, 19531, 21674),
('Iowa', 'F', 54, 14481, 21139),
('Iowa', 'F', 55, 14459, 20401),
('Iowa', 'F', 56, 14657, 20112),
('Iowa', 'F', 57, 15050, 19408),
('Iowa', 'F', 58, 13618, 18357),
('Iowa', 'F', 59, 13305, 17944),
('Iowa', 'F', 60, 12790, 17781),
('Iowa', 'F', 61, 12512, 18615),
('Iowa', 'F', 62, 12342, 13743),
('Iowa', 'F', 63, 12091, 13607),
('Iowa', 'F', 64, 11982, 13781),
('Iowa', 'F', 65, 11928, 14141),
('Iowa', 'F', 66, 11022, 12540),
('Iowa', 'F', 67, 11356, 12190),
('Iowa', 'F', 68, 11513, 11603),
('Iowa', 'F', 69, 11589, 11309),
('Iowa', 'F', 70, 11922, 10948),
('Iowa', 'F', 71, 11306, 10698),
('Iowa', 'F', 72, 11608, 10554),
('Iowa', 'F', 73, 11372, 10444),
('Iowa', 'F', 74, 11326, 9503),
('Iowa', 'F', 75, 11361, 9541),
('Iowa', 'F', 76, 10785, 9702),
('Iowa', 'F', 77, 10515, 9563),
('Iowa', 'F', 78, 10619, 9719),
('Iowa', 'F', 79, 10291, 9077),
('Iowa', 'F', 80, 9766, 9245),
('Iowa', 'F', 81, 9003, 8618),
('Iowa', 'F', 82, 8700, 8485),
('Iowa', 'F', 83, 8060, 8542),
('Iowa', 'F', 84, 7532, 7604),
('Iowa', 'F', 85, 47435, 54588),
('Kansas', 'M', 0, 19968, 21740),
('Kansas', 'M', 1, 19597, 21470),
('Kansas', 'M', 2, 19054, 20378),
('Kansas', 'M', 3, 18987, 19798),
('Kansas', 'M', 4, 19409, 19940),
('Kansas', 'M', 5, 19624, 19921),
('Kansas', 'M', 6, 19716, 19882),
('Kansas', 'M', 7, 19944, 19532),
('Kansas', 'M', 8, 20292, 19669),
('Kansas', 'M', 9, 20431, 19475),
('Kansas', 'M', 10, 21480, 18971),
('Kansas', 'M', 11, 20858, 18878),
('Kansas', 'M', 12, 20582, 19295),
('Kansas', 'M', 13, 21095, 19536),
('Kansas', 'M', 14, 21292, 19676),
('Kansas', 'M', 15, 21600, 19926),
('Kansas', 'M', 16, 21043, 20281),
('Kansas', 'M', 17, 21401, 20377),
('Kansas', 'M', 18, 21634, 20478),
('Kansas', 'M', 19, 21791, 21759),
('Kansas', 'M', 20, 21244, 21703),
('Kansas', 'M', 21, 19440, 20728),
('Kansas', 'M', 22, 18516, 20880),
('Kansas', 'M', 23, 18255, 21712),
('Kansas', 'M', 24, 17318, 20465),
('Kansas', 'M', 25, 17502, 19348),
('Kansas', 'M', 26, 16252, 21183),
('Kansas', 'M', 27, 16572, 20229),
('Kansas', 'M', 28, 17178, 18533),
('Kansas', 'M', 29, 18143, 18587),
('Kansas', 'M', 30, 18755, 17919),
('Kansas', 'M', 31, 17513, 17003),
('Kansas', 'M', 32, 16658, 16730),
('Kansas', 'M', 33, 16748, 17575),
('Kansas', 'M', 34, 17693, 16403),
('Kansas', 'M', 35, 18989, 16650),
('Kansas', 'M', 36, 20052, 17352),
('Kansas', 'M', 37, 20230, 17954),
('Kansas', 'M', 38, 20737, 18699),
('Kansas', 'M', 39, 21007, 17332),
('Kansas', 'M', 40, 21284, 16866),
('Kansas', 'M', 41, 20847, 16566),
('Kansas', 'M', 42, 21137, 17557),
('Kansas', 'M', 43, 21579, 18840),
('Kansas', 'M', 44, 20745, 19537),
('Kansas', 'M', 45, 20818, 19932),
('Kansas', 'M', 46, 19882, 20213),
('Kansas', 'M', 47, 19290, 20808),
('Kansas', 'M', 48, 18682, 20812),
('Kansas', 'M', 49, 18057, 20266),
('Kansas', 'M', 50, 17637, 20310),
('Kansas', 'M', 51, 17082, 20755),
('Kansas', 'M', 52, 16754, 19861),
('Kansas', 'M', 53, 17467, 19797),
('Kansas', 'M', 54, 12803, 19065),
('Kansas', 'M', 55, 12597, 18273),
('Kansas', 'M', 56, 12554, 17551),
('Kansas', 'M', 57, 12925, 16962),
('Kansas', 'M', 58, 11349, 16529),
('Kansas', 'M', 59, 10463, 15821),
('Kansas', 'M', 60, 10210, 15469),
('Kansas', 'M', 61, 9911, 16235),
('Kansas', 'M', 62, 9536, 11635),
('Kansas', 'M', 63, 9097, 11330),
('Kansas', 'M', 64, 9030, 11162),
('Kansas', 'M', 65, 8929, 11570),
('Kansas', 'M', 66, 8165, 9869),
('Kansas', 'M', 67, 8230, 9010),
('Kansas', 'M', 68, 8129, 8604),
('Kansas', 'M', 69, 8016, 8384),
('Kansas', 'M', 70, 7973, 7937),
('Kansas', 'M', 71, 7728, 7438),
('Kansas', 'M', 72, 7804, 7269),
('Kansas', 'M', 73, 7511, 7143),
('Kansas', 'M', 74, 7214, 6352),
('Kansas', 'M', 75, 7093, 6286),
('Kansas', 'M', 76, 6718, 6039),
('Kansas', 'M', 77, 6207, 5844),
('Kansas', 'M', 78, 5823, 5672),
('Kansas', 'M', 79, 5541, 5283),
('Kansas', 'M', 80, 4951, 5123),
('Kansas', 'M', 81, 4283, 4716),
('Kansas', 'M', 82, 4041, 4445),
('Kansas', 'M', 83, 3435, 4070),
('Kansas', 'M', 84, 3044, 3823),
('Kansas', 'M', 85, 14801, 19387),
('Kansas', 'F', 0, 18443, 20685),
('Kansas', 'F', 1, 18431, 20621),
('Kansas', 'F', 2, 18313, 19534),
('Kansas', 'F', 3, 17952, 19339),
('Kansas', 'F', 4, 18585, 19024),
('Kansas', 'F', 5, 18577, 19192),
('Kansas', 'F', 6, 18405, 19018),
('Kansas', 'F', 7, 18926, 19012),
('Kansas', 'F', 8, 19415, 18353),
('Kansas', 'F', 9, 19406, 18311),
('Kansas', 'F', 10, 20262, 18358),
('Kansas', 'F', 11, 19728, 17798),
('Kansas', 'F', 12, 19545, 18443),
('Kansas', 'F', 13, 19860, 18490),
('Kansas', 'F', 14, 19992, 18233),
('Kansas', 'F', 15, 20441, 18731),
('Kansas', 'F', 16, 20278, 19347),
('Kansas', 'F', 17, 20324, 19242),
('Kansas', 'F', 18, 20354, 18903),
('Kansas', 'F', 19, 20697, 20201),
('Kansas', 'F', 20, 20509, 20143),
('Kansas', 'F', 21, 18837, 19558),
('Kansas', 'F', 22, 17984, 20534),
('Kansas', 'F', 23, 17620, 19868),
('Kansas', 'F', 24, 16512, 19476),
('Kansas', 'F', 25, 16517, 18189),
('Kansas', 'F', 26, 15759, 20897),
('Kansas', 'F', 27, 16222, 19211),
('Kansas', 'F', 28, 16614, 17837),
('Kansas', 'F', 29, 17934, 18956),
('Kansas', 'F', 30, 17939, 16070),
('Kansas', 'F', 31, 17052, 17015),
('Kansas', 'F', 32, 16367, 16589),
('Kansas', 'F', 33, 16963, 16554),
('Kansas', 'F', 34, 17666, 15857),
('Kansas', 'F', 35, 19082, 16404),
('Kansas', 'F', 36, 20197, 17287),
('Kansas', 'F', 37, 20882, 18485),
('Kansas', 'F', 38, 21019, 18406),
('Kansas', 'F', 39, 21744, 17556),
('Kansas', 'F', 40, 21832, 16391),
('Kansas', 'F', 41, 21218, 17038),
('Kansas', 'F', 42, 21448, 17493),
('Kansas', 'F', 43, 21345, 19144),
('Kansas', 'F', 44, 20662, 19781),
('Kansas', 'F', 45, 20668, 20506),
('Kansas', 'F', 46, 20170, 20548),
('Kansas', 'F', 47, 19304, 21430),
('Kansas', 'F', 48, 18669, 21195),
('Kansas', 'F', 49, 17822, 20710),
('Kansas', 'F', 50, 17266, 20978),
('Kansas', 'F', 51, 16770, 20426),
('Kansas', 'F', 52, 16697, 19863),
('Kansas', 'F', 53, 17602, 20009),
('Kansas', 'F', 54, 12772, 19454),
('Kansas', 'F', 55, 13011, 18341),
('Kansas', 'F', 56, 13121, 18140),
('Kansas', 'F', 57, 13149, 17059),
('Kansas', 'F', 58, 11871, 16459),
('Kansas', 'F', 59, 11328, 15950),
('Kansas', 'F', 60, 10836, 15863),
('Kansas', 'F', 61, 10485, 16666),
('Kansas', 'F', 62, 10395, 12001),
('Kansas', 'F', 63, 9806, 12060),
('Kansas', 'F', 64, 9726, 12188),
('Kansas', 'F', 65, 9881, 12230),
('Kansas', 'F', 66, 9493, 10888),
('Kansas', 'F', 67, 9543, 10346),
('Kansas', 'F', 68, 9623, 9876),
('Kansas', 'F', 69, 9665, 9533),
('Kansas', 'F', 70, 9821, 9326),
('Kansas', 'F', 71, 9439, 8770),
('Kansas', 'F', 72, 9454, 8485),
('Kansas', 'F', 73, 9384, 8496),
('Kansas', 'F', 74, 9218, 8144),
('Kansas', 'F', 75, 9054, 8072),
('Kansas', 'F', 76, 9030, 7944),
('Kansas', 'F', 77, 8590, 7877),
('Kansas', 'F', 78, 8677, 7948),
('Kansas', 'F', 79, 8389, 7456),
('Kansas', 'F', 80, 7845, 7390),
('Kansas', 'F', 81, 7191, 7098),
('Kansas', 'F', 82, 6756, 6840),
('Kansas', 'F', 83, 6252, 6494),
('Kansas', 'F', 84, 5921, 6297),
('Kansas', 'F', 85, 37405, 42932),
('Kentucky', 'M', 0, 27442, 29463),
('Kentucky', 'M', 1, 27276, 29348),
('Kentucky', 'M', 2, 26926, 29135),
('Kentucky', 'M', 3, 27005, 28703),
('Kentucky', 'M', 4, 27513, 28530),
('Kentucky', 'M', 5, 28042, 28099),
('Kentucky', 'M', 6, 27973, 27979),
('Kentucky', 'M', 7, 28371, 28871),
('Kentucky', 'M', 8, 29058, 28062),
('Kentucky', 'M', 9, 29261, 27931),
('Kentucky', 'M', 10, 30049, 27550),
('Kentucky', 'M', 11, 28838, 27597),
('Kentucky', 'M', 12, 28204, 28002),
('Kentucky', 'M', 13, 28525, 28581),
('Kentucky', 'M', 14, 28737, 28606),
('Kentucky', 'M', 15, 29154, 28948),
('Kentucky', 'M', 16, 29007, 29923),
('Kentucky', 'M', 17, 29871, 30173),
('Kentucky', 'M', 18, 29250, 28957),
('Kentucky', 'M', 19, 29999, 26428),
('Kentucky', 'M', 20, 29982, 26733),
('Kentucky', 'M', 21, 28426, 26312),
('Kentucky', 'M', 22, 27564, 27269),
('Kentucky', 'M', 23, 27261, 28053),
('Kentucky', 'M', 24, 25882, 27591),
('Kentucky', 'M', 25, 26627, 28318),
('Kentucky', 'M', 26, 25956, 27302),
('Kentucky', 'M', 27, 26422, 33022),
('Kentucky', 'M', 28, 28273, 32127),
('Kentucky', 'M', 29, 29510, 31389),
('Kentucky', 'M', 30, 29114, 29277),
('Kentucky', 'M', 31, 28031, 28020),
('Kentucky', 'M', 32, 27148, 26606),
('Kentucky', 'M', 33, 27524, 26962),
('Kentucky', 'M', 34, 28655, 26681),
('Kentucky', 'M', 35, 31004, 26674),
('Kentucky', 'M', 36, 31339, 28872),
('Kentucky', 'M', 37, 31275, 30543),
('Kentucky', 'M', 38, 30804, 29371),
('Kentucky', 'M', 39, 31760, 28466),
('Kentucky', 'M', 40, 32486, 27694),
('Kentucky', 'M', 41, 31306, 28044),
('Kentucky', 'M', 42, 31733, 29163),
('Kentucky', 'M', 43, 31548, 31268),
('Kentucky', 'M', 44, 30454, 31411),
('Kentucky', 'M', 45, 31081, 31599),
('Kentucky', 'M', 46, 29661, 30888),
('Kentucky', 'M', 47, 28597, 31560),
('Kentucky', 'M', 48, 28417, 32258),
('Kentucky', 'M', 49, 27697, 30978),
('Kentucky', 'M', 50, 27337, 31197),
('Kentucky', 'M', 51, 27136, 30993),
('Kentucky', 'M', 52, 26642, 29759),
('Kentucky', 'M', 53, 28263, 30145),
('Kentucky', 'M', 54, 20709, 28774),
('Kentucky', 'M', 55, 20904, 27922),
('Kentucky', 'M', 56, 20214, 27314),
('Kentucky', 'M', 57, 21389, 26617),
('Kentucky', 'M', 58, 19247, 26076),
('Kentucky', 'M', 59, 18064, 25967),
('Kentucky', 'M', 60, 17323, 25196),
('Kentucky', 'M', 61, 16888, 26793),
('Kentucky', 'M', 62, 16324, 19089),
('Kentucky', 'M', 63, 14816, 19133),
('Kentucky', 'M', 64, 15030, 18350),
('Kentucky', 'M', 65, 14695, 19328),
('Kentucky', 'M', 66, 13481, 17166),
('Kentucky', 'M', 67, 13213, 15827),
('Kentucky', 'M', 68, 12655, 15040),
('Kentucky', 'M', 69, 12407, 14208),
('Kentucky', 'M', 70, 12467, 13661),
('Kentucky', 'M', 71, 11406, 12092),
('Kentucky', 'M', 72, 11462, 11852),
('Kentucky', 'M', 73, 10675, 11564),
('Kentucky', 'M', 74, 10185, 10264),
('Kentucky', 'M', 75, 9669, 9726),
('Kentucky', 'M', 76, 9078, 9063),
('Kentucky', 'M', 77, 8389, 8612),
('Kentucky', 'M', 78, 7743, 8532),
('Kentucky', 'M', 79, 6966, 7379),
('Kentucky', 'M', 80, 6126, 7274),
('Kentucky', 'M', 81, 5392, 6431),
('Kentucky', 'M', 82, 4705, 5787),
('Kentucky', 'M', 83, 4112, 5330),
('Kentucky', 'M', 84, 3642, 4847),
('Kentucky', 'M', 85, 15951, 22917),
('Kentucky', 'F', 0, 26194, 28157),
('Kentucky', 'F', 1, 26079, 28159),
('Kentucky', 'F', 2, 25917, 27916),
('Kentucky', 'F', 3, 25511, 27684),
('Kentucky', 'F', 4, 25870, 27506),
('Kentucky', 'F', 5, 26480, 26914),
('Kentucky', 'F', 6, 26312, 26651),
('Kentucky', 'F', 7, 27036, 27189),
('Kentucky', 'F', 8, 27529, 26768),
('Kentucky', 'F', 9, 27797, 26652),
('Kentucky', 'F', 10, 27981, 26569),
('Kentucky', 'F', 11, 27319, 26232),
('Kentucky', 'F', 12, 26794, 26555),
('Kentucky', 'F', 13, 26805, 27334),
('Kentucky', 'F', 14, 27100, 27147),
('Kentucky', 'F', 15, 27293, 27839),
('Kentucky', 'F', 16, 27374, 28521),
('Kentucky', 'F', 17, 28113, 28712),
('Kentucky', 'F', 18, 28315, 26824),
('Kentucky', 'F', 19, 30044, 25472),
('Kentucky', 'F', 20, 30073, 25572),
('Kentucky', 'F', 21, 28438, 26070),
('Kentucky', 'F', 22, 27844, 27407),
('Kentucky', 'F', 23, 27117, 27590),
('Kentucky', 'F', 24, 26082, 27143),
('Kentucky', 'F', 25, 26789, 27811),
('Kentucky', 'F', 26, 26090, 27838),
('Kentucky', 'F', 27, 26594, 33483),
('Kentucky', 'F', 28, 28414, 34030),
('Kentucky', 'F', 29, 29946, 31247),
('Kentucky', 'F', 30, 29241, 28776),
('Kentucky', 'F', 31, 28360, 27453),
('Kentucky', 'F', 32, 27975, 26895),
('Kentucky', 'F', 33, 28218, 27375),
('Kentucky', 'F', 34, 29302, 26828),
('Kentucky', 'F', 35, 31539, 27185),
('Kentucky', 'F', 36, 32278, 28906),
('Kentucky', 'F', 37, 32163, 30706),
('Kentucky', 'F', 38, 32698, 30103),
('Kentucky', 'F', 39, 33027, 29219),
('Kentucky', 'F', 40, 33025, 28428),
('Kentucky', 'F', 41, 32572, 28831),
('Kentucky', 'F', 42, 33172, 29846),
('Kentucky', 'F', 43, 32659, 31999),
('Kentucky', 'F', 44, 31377, 32270),
('Kentucky', 'F', 45, 31787, 32165),
('Kentucky', 'F', 46, 30700, 32687),
('Kentucky', 'F', 47, 29741, 33067),
('Kentucky', 'F', 48, 29149, 32901),
('Kentucky', 'F', 49, 28508, 32381),
('Kentucky', 'F', 50, 28534, 33258),
('Kentucky', 'F', 51, 27960, 32618),
('Kentucky', 'F', 52, 27590, 31419),
('Kentucky', 'F', 53, 29493, 31805),
('Kentucky', 'F', 54, 21735, 30558),
('Kentucky', 'F', 55, 21573, 29478),
('Kentucky', 'F', 56, 21560, 29202),
('Kentucky', 'F', 57, 22590, 28180),
('Kentucky', 'F', 58, 20588, 27941),
('Kentucky', 'F', 59, 19646, 27439),
('Kentucky', 'F', 60, 18873, 26867),
('Kentucky', 'F', 61, 18393, 28580),
('Kentucky', 'F', 62, 17938, 20964),
('Kentucky', 'F', 63, 16606, 20685),
('Kentucky', 'F', 64, 16690, 20428),
('Kentucky', 'F', 65, 16507, 21357),
('Kentucky', 'F', 66, 15643, 19331),
('Kentucky', 'F', 67, 15435, 18182),
('Kentucky', 'F', 68, 15246, 17507),
('Kentucky', 'F', 69, 15026, 16744),
('Kentucky', 'F', 70, 15534, 16179),
('Kentucky', 'F', 71, 14646, 14829),
('Kentucky', 'F', 72, 14679, 14762),
('Kentucky', 'F', 73, 14423, 14302),
('Kentucky', 'F', 74, 13601, 13322),
('Kentucky', 'F', 75, 13802, 13088),
('Kentucky', 'F', 76, 13036, 12539),
('Kentucky', 'F', 77, 12465, 12004),
('Kentucky', 'F', 78, 12376, 12433),
('Kentucky', 'F', 79, 11429, 11255),
('Kentucky', 'F', 80, 10436, 10957),
('Kentucky', 'F', 81, 9510, 10731),
('Kentucky', 'F', 82, 8718, 9635),
('Kentucky', 'F', 83, 7807, 9324),
('Kentucky', 'F', 84, 7889, 8644),
('Kentucky', 'F', 85, 42928, 51842),
('Louisiana', 'M', 0, 33003, 32703),
('Louisiana', 'M', 1, 32447, 34412),
('Louisiana', 'M', 2, 32133, 28392),
('Louisiana', 'M', 3, 31628, 31802),
('Louisiana', 'M', 4, 31984, 31771),
('Louisiana', 'M', 5, 32857, 31311),
('Louisiana', 'M', 6, 33481, 31590),
('Louisiana', 'M', 7, 34713, 31689),
('Louisiana', 'M', 8, 34938, 30990),
('Louisiana', 'M', 9, 35423, 30534),
('Louisiana', 'M', 10, 35805, 30314),
('Louisiana', 'M', 11, 35475, 29814),
('Louisiana', 'M', 12, 34633, 30098),
('Louisiana', 'M', 13, 35541, 30886),
('Louisiana', 'M', 14, 36516, 31416),
('Louisiana', 'M', 15, 36834, 32623),
('Louisiana', 'M', 16, 36864, 32783),
('Louisiana', 'M', 17, 37271, 33490),
('Louisiana', 'M', 18, 36776, 34201),
('Louisiana', 'M', 19, 36045, 32281),
('Louisiana', 'M', 20, 34906, 31438),
('Louisiana', 'M', 21, 32703, 32867),
('Louisiana', 'M', 22, 31137, 33326),
('Louisiana', 'M', 23, 30333, 33799),
('Louisiana', 'M', 24, 28449, 33159),
('Louisiana', 'M', 25, 28025, 32699),
('Louisiana', 'M', 26, 27114, 31449),
('Louisiana', 'M', 27, 27241, 33827),
('Louisiana', 'M', 28, 28962, 33623),
('Louisiana', 'M', 29, 29708, 30391),
('Louisiana', 'M', 30, 30024, 28190),
('Louisiana', 'M', 31, 29277, 26882),
('Louisiana', 'M', 32, 28466, 24798),
('Louisiana', 'M', 33, 28689, 25165),
('Louisiana', 'M', 34, 29710, 24219),
('Louisiana', 'M', 35, 31775, 24324),
('Louisiana', 'M', 36, 32435, 26372),
('Louisiana', 'M', 37, 32507, 27141),
('Louisiana', 'M', 38, 32820, 27491),
('Louisiana', 'M', 39, 33423, 27161),
('Louisiana', 'M', 40, 34826, 26190),
('Louisiana', 'M', 41, 33952, 26818),
('Louisiana', 'M', 42, 33969, 27566),
('Louisiana', 'M', 43, 34016, 29724),
('Louisiana', 'M', 44, 32926, 30275),
('Louisiana', 'M', 45, 33111, 30507),
('Louisiana', 'M', 46, 31931, 30546),
('Louisiana', 'M', 47, 30675, 31015),
('Louisiana', 'M', 48, 29431, 32380),
('Louisiana', 'M', 49, 28622, 31334),
('Louisiana', 'M', 50, 28653, 31212),
('Louisiana', 'M', 51, 27403, 31401),
('Louisiana', 'M', 52, 27403, 30385),
('Louisiana', 'M', 53, 28410, 30395),
('Louisiana', 'M', 54, 20701, 29227),
('Louisiana', 'M', 55, 21267, 28153),
('Louisiana', 'M', 56, 20802, 26570),
('Louisiana', 'M', 57, 21026, 25879),
('Louisiana', 'M', 58, 19138, 25824),
('Louisiana', 'M', 59, 17741, 24461),
('Louisiana', 'M', 60, 17280, 23966),
('Louisiana', 'M', 61, 16655, 25335),
('Louisiana', 'M', 62, 16252, 17763),
('Louisiana', 'M', 63, 15125, 17981),
('Louisiana', 'M', 64, 14672, 17540),
('Louisiana', 'M', 65, 14545, 17561),
('Louisiana', 'M', 66, 13224, 15544),
('Louisiana', 'M', 67, 13379, 14425),
('Louisiana', 'M', 68, 12915, 13845),
('Louisiana', 'M', 69, 12449, 13273),
('Louisiana', 'M', 70, 12436, 12678),
('Louisiana', 'M', 71, 12169, 11628),
('Louisiana', 'M', 72, 11788, 10979),
('Louisiana', 'M', 73, 11107, 10845),
('Louisiana', 'M', 74, 10603, 9527),
('Louisiana', 'M', 75, 9883, 9370),
('Louisiana', 'M', 76, 9297, 8838),
('Louisiana', 'M', 77, 8708, 8152),
('Louisiana', 'M', 78, 8007, 7932),
('Louisiana', 'M', 79, 7121, 7529),
('Louisiana', 'M', 80, 6515, 7163),
('Louisiana', 'M', 81, 5511, 6374),
('Louisiana', 'M', 82, 4798, 5935),
('Louisiana', 'M', 83, 4114, 5194),
('Louisiana', 'M', 84, 3553, 4708),
('Louisiana', 'M', 85, 16542, 22800),
('Louisiana', 'F', 0, 31578, 31172),
('Louisiana', 'F', 1, 30904, 32750),
('Louisiana', 'F', 2, 31050, 27028),
('Louisiana', 'F', 3, 30672, 30204),
('Louisiana', 'F', 4, 30866, 30482),
('Louisiana', 'F', 5, 31333, 29587),
('Louisiana', 'F', 6, 32051, 29964),
('Louisiana', 'F', 7, 32581, 30279),
('Louisiana', 'F', 8, 33126, 29720),
('Louisiana', 'F', 9, 33604, 28965),
('Louisiana', 'F', 10, 34367, 29207),
('Louisiana', 'F', 11, 34151, 28845),
('Louisiana', 'F', 12, 33299, 29075),
('Louisiana', 'F', 13, 33989, 29473),
('Louisiana', 'F', 14, 34759, 30251),
('Louisiana', 'F', 15, 35821, 30833),
('Louisiana', 'F', 16, 35427, 31416),
('Louisiana', 'F', 17, 35776, 32104),
('Louisiana', 'F', 18, 37303, 35496),
('Louisiana', 'F', 19, 36901, 32997),
('Louisiana', 'F', 20, 36636, 32637),
('Louisiana', 'F', 21, 33983, 33250),
('Louisiana', 'F', 22, 32292, 33867),
('Louisiana', 'F', 23, 31711, 34538),
('Louisiana', 'F', 24, 29831, 33060),
('Louisiana', 'F', 25, 29755, 33321),
('Louisiana', 'F', 26, 28375, 31192),
('Louisiana', 'F', 27, 28897, 33866),
('Louisiana', 'F', 28, 30364, 34155),
('Louisiana', 'F', 29, 31611, 30995),
('Louisiana', 'F', 30, 31748, 28212),
('Louisiana', 'F', 31, 30410, 27556),
('Louisiana', 'F', 32, 30348, 26007),
('Louisiana', 'F', 33, 30660, 26539),
('Louisiana', 'F', 34, 31511, 25567),
('Louisiana', 'F', 35, 33706, 25889),
('Louisiana', 'F', 36, 34876, 27720),
('Louisiana', 'F', 37, 35203, 29470),
('Louisiana', 'F', 38, 35516, 29475),
('Louisiana', 'F', 39, 35962, 28388),
('Louisiana', 'F', 40, 36997, 28212),
('Louisiana', 'F', 41, 35652, 28553),
('Louisiana', 'F', 42, 35339, 29138),
('Louisiana', 'F', 43, 35516, 31597),
('Louisiana', 'F', 44, 34523, 32553),
('Louisiana', 'F', 45, 35112, 32634),
('Louisiana', 'F', 46, 33301, 33304),
('Louisiana', 'F', 47, 31915, 33279),
('Louisiana', 'F', 48, 31377, 34869),
('Louisiana', 'F', 49, 30967, 33526),
('Louisiana', 'F', 50, 30112, 33060),
('Louisiana', 'F', 51, 28951, 33293),
('Louisiana', 'F', 52, 28641, 31948),
('Louisiana', 'F', 53, 29695, 32925),
('Louisiana', 'F', 54, 22682, 31299),
('Louisiana', 'F', 55, 23085, 29730),
('Louisiana', 'F', 56, 22430, 29024),
('Louisiana', 'F', 57, 23122, 28560),
('Louisiana', 'F', 58, 21077, 27637),
('Louisiana', 'F', 59, 19804, 26339),
('Louisiana', 'F', 60, 19482, 26257),
('Louisiana', 'F', 61, 18592, 27413),
('Louisiana', 'F', 62, 18518, 20355),
('Louisiana', 'F', 63, 17233, 20671),
('Louisiana', 'F', 64, 16801, 19887),
('Louisiana', 'F', 65, 17173, 20490),
('Louisiana', 'F', 66, 15820, 18139),
('Louisiana', 'F', 67, 16148, 17144),
('Louisiana', 'F', 68, 16244, 16756),
('Louisiana', 'F', 69, 15749, 15882),
('Louisiana', 'F', 70, 16101, 15627),
('Louisiana', 'F', 71, 15376, 14241),
('Louisiana', 'F', 72, 15506, 13758),
('Louisiana', 'F', 73, 15167, 14033),
('Louisiana', 'F', 74, 14395, 12580),
('Louisiana', 'F', 75, 14159, 12695),
('Louisiana', 'F', 76, 13130, 12467),
('Louisiana', 'F', 77, 12812, 11797),
('Louisiana', 'F', 78, 12336, 12004),
('Louisiana', 'F', 79, 11582, 11065),
('Louisiana', 'F', 80, 11177, 10959),
('Louisiana', 'F', 81, 9429, 10347),
('Louisiana', 'F', 82, 8965, 9599),
('Louisiana', 'F', 83, 7821, 9107),
('Louisiana', 'F', 84, 7103, 7874),
('Louisiana', 'F', 85, 42697, 49450),
('Maine', 'M', 0, 6991, 7349),
('Maine', 'M', 1, 7144, 7405),
('Maine', 'M', 2, 7148, 7291),
('Maine', 'M', 3, 7362, 7285),
('Maine', 'M', 4, 7501, 7385),
('Maine', 'M', 5, 7682, 7312),
('Maine', 'M', 6, 8183, 7215),
('Maine', 'M', 7, 8494, 7436),
('Maine', 'M', 8, 8909, 7371),
('Maine', 'M', 9, 9044, 7535),
('Maine', 'M', 10, 9621, 7518),
('Maine', 'M', 11, 9353, 7765),
('Maine', 'M', 12, 9518, 7906),
('Maine', 'M', 13, 9546, 8017),
('Maine', 'M', 14, 9499, 8530),
('Maine', 'M', 15, 9758, 8781),
('Maine', 'M', 16, 9426, 9278),
('Maine', 'M', 17, 9358, 9293),
('Maine', 'M', 18, 8966, 9165),
('Maine', 'M', 19, 8357, 8351),
('Maine', 'M', 20, 7688, 8607),
('Maine', 'M', 21, 7272, 8147),
('Maine', 'M', 22, 6650, 7768),
('Maine', 'M', 23, 6363, 7647),
('Maine', 'M', 24, 5929, 7281),
('Maine', 'M', 25, 6223, 7294),
('Maine', 'M', 26, 6260, 7303),
('Maine', 'M', 27, 6530, 8764),
('Maine', 'M', 28, 7151, 6831),
('Maine', 'M', 29, 7889, 7245),
('Maine', 'M', 30, 8111, 6851),
('Maine', 'M', 31, 7838, 7268),
('Maine', 'M', 32, 8004, 6768),
('Maine', 'M', 33, 8307, 6962),
('Maine', 'M', 34, 8749, 7179),
('Maine', 'M', 35, 9280, 7294),
('Maine', 'M', 36, 9698, 8066),
('Maine', 'M', 37, 9918, 8832),
('Maine', 'M', 38, 10301, 8967),
('Maine', 'M', 39, 10476, 8287),
('Maine', 'M', 40, 10641, 8614),
('Maine', 'M', 41, 10634, 8881),
('Maine', 'M', 42, 10704, 9324),
('Maine', 'M', 43, 10792, 9856),
('Maine', 'M', 44, 10225, 10305),
('Maine', 'M', 45, 10463, 10474),
('Maine', 'M', 46, 10396, 10806),
('Maine', 'M', 47, 10058, 10862),
('Maine', 'M', 48, 9833, 10921),
('Maine', 'M', 49, 9688, 10872),
('Maine', 'M', 50, 9802, 10974),
('Maine', 'M', 51, 9323, 10904),
('Maine', 'M', 52, 9554, 10363),
('Maine', 'M', 53, 10120, 10534),
('Maine', 'M', 54, 7130, 10338),
('Maine', 'M', 55, 7216, 10103),
('Maine', 'M', 56, 7183, 9752),
('Maine', 'M', 57, 7363, 9537),
('Maine', 'M', 58, 6480, 9606),
('Maine', 'M', 59, 5787, 9164),
('Maine', 'M', 60, 5415, 9429),
('Maine', 'M', 61, 5370, 9760),
('Maine', 'M', 62, 5431, 6854),
('Maine', 'M', 63, 5245, 6899),
('Maine', 'M', 64, 5122, 6859),
('Maine', 'M', 65, 5052, 6951),
('Maine', 'M', 66, 4670, 5968),
('Maine', 'M', 67, 4714, 5268),
('Maine', 'M', 68, 4726, 4818),
('Maine', 'M', 69, 4369, 4710),
('Maine', 'M', 70, 4417, 4627),
('Maine', 'M', 71, 4253, 4426),
('Maine', 'M', 72, 4202, 4211),
('Maine', 'M', 73, 3976, 4083),
('Maine', 'M', 74, 3725, 3598),
('Maine', 'M', 75, 3638, 3590),
('Maine', 'M', 76, 3365, 3601),
('Maine', 'M', 77, 3287, 3207),
('Maine', 'M', 78, 2933, 3069),
('Maine', 'M', 79, 2661, 2909),
('Maine', 'M', 80, 2443, 2804),
('Maine', 'M', 81, 2140, 2557),
('Maine', 'M', 82, 1951, 2223),
('Maine', 'M', 83, 1666, 2136),
('Maine', 'M', 84, 1498, 1820),
('Maine', 'M', 85, 6541, 9126),
('Maine', 'F', 0, 6576, 6961),
('Maine', 'F', 1, 6785, 7037),
('Maine', 'F', 2, 6881, 6876),
('Maine', 'F', 3, 7002, 6860),
('Maine', 'F', 4, 7273, 7010),
('Maine', 'F', 5, 7521, 6998),
('Maine', 'F', 6, 7522, 6878),
('Maine', 'F', 7, 8090, 7133),
('Maine', 'F', 8, 8437, 7036),
('Maine', 'F', 9, 8708, 7256),
('Maine', 'F', 10, 9054, 7311),
('Maine', 'F', 11, 8867, 7414),
('Maine', 'F', 12, 9016, 7648),
('Maine', 'F', 13, 8927, 7907),
('Maine', 'F', 14, 9093, 7866),
('Maine', 'F', 15, 9087, 8387),
('Maine', 'F', 16, 8918, 8727),
('Maine', 'F', 17, 8918, 8889),
('Maine', 'F', 18, 8679, 8565),
('Maine', 'F', 19, 8102, 8163),
('Maine', 'F', 20, 7544, 7718),
('Maine', 'F', 21, 7384, 7912),
('Maine', 'F', 22, 6898, 7702),
('Maine', 'F', 23, 6492, 7539),
('Maine', 'F', 24, 6414, 7277),
('Maine', 'F', 25, 6582, 7088),
('Maine', 'F', 26, 6700, 7718),
('Maine', 'F', 27, 7041, 7957),
('Maine', 'F', 28, 7646, 7997),
('Maine', 'F', 29, 8165, 7438),
('Maine', 'F', 30, 8559, 7469),
('Maine', 'F', 31, 8278, 7216),
('Maine', 'F', 32, 8780, 7454),
('Maine', 'F', 33, 8944, 7484),
('Maine', 'F', 34, 9042, 7688),
('Maine', 'F', 35, 9957, 7796),
('Maine', 'F', 36, 10397, 8554),
('Maine', 'F', 37, 10749, 9030),
('Maine', 'F', 38, 10755, 9246),
('Maine', 'F', 39, 11163, 8815),
('Maine', 'F', 40, 11175, 9342),
('Maine', 'F', 41, 11080, 9350),
('Maine', 'F', 42, 11345, 9729),
('Maine', 'F', 43, 11136, 10416),
('Maine', 'F', 44, 10947, 10738),
('Maine', 'F', 45, 10717, 11208),
('Maine', 'F', 46, 10878, 11183),
('Maine', 'F', 47, 10402, 11509),
('Maine', 'F', 48, 10128, 11445),
('Maine', 'F', 49, 9864, 11325),
('Maine', 'F', 50, 9645, 11573),
('Maine', 'F', 51, 9548, 11315),
('Maine', 'F', 52, 9494, 11063),
('Maine', 'F', 53, 9868, 10672),
('Maine', 'F', 54, 7003, 11006),
('Maine', 'F', 55, 7198, 10494),
('Maine', 'F', 56, 7395, 10085),
('Maine', 'F', 57, 7576, 9928),
('Maine', 'F', 58, 6687, 9572),
('Maine', 'F', 59, 6017, 9556),
('Maine', 'F', 60, 5926, 9594),
('Maine', 'F', 61, 5758, 9788),
('Maine', 'F', 62, 5788, 6886),
('Maine', 'F', 63, 5482, 7101),
('Maine', 'F', 64, 5410, 7347),
('Maine', 'F', 65, 5439, 7385),
('Maine', 'F', 66, 5152, 6369),
('Maine', 'F', 67, 5167, 5664),
('Maine', 'F', 68, 5422, 5522),
('Maine', 'F', 69, 5285, 5322),
('Maine', 'F', 70, 5249, 5261),
('Maine', 'F', 71, 5177, 5005),
('Maine', 'F', 72, 5207, 4792),
('Maine', 'F', 73, 5003, 4792),
('Maine', 'F', 74, 4845, 4485),
('Maine', 'F', 75, 4965, 4308),
('Maine', 'F', 76, 4567, 4549),
('Maine', 'F', 77, 4398, 4380),
('Maine', 'F', 78, 4236, 4268),
('Maine', 'F', 79, 4131, 4028),
('Maine', 'F', 80, 3828, 4027),
('Maine', 'F', 81, 3472, 3741),
('Maine', 'F', 82, 3246, 3414),
('Maine', 'F', 83, 2934, 3526),
('Maine', 'F', 84, 2825, 3054),
('Maine', 'F', 85, 17034, 19593),
('Maryland', 'M', 0, 35923, 38474),
('Maryland', 'M', 1, 35456, 38494),
('Maryland', 'M', 2, 35575, 38042),
('Maryland', 'M', 3, 36124, 37396),
('Maryland', 'M', 4, 37130, 37767),
('Maryland', 'M', 5, 38179, 37230),
('Maryland', 'M', 6, 38365, 37345),
('Maryland', 'M', 7, 39879, 37546),
('Maryland', 'M', 8, 41023, 36258),
('Maryland', 'M', 9, 41744, 35861),
('Maryland', 'M', 10, 43013, 35837),
('Maryland', 'M', 11, 41074, 36416),
('Maryland', 'M', 12, 39958, 37451),
('Maryland', 'M', 13, 39172, 38609),
('Maryland', 'M', 14, 38446, 38676),
('Maryland', 'M', 15, 38417, 40011),
('Maryland', 'M', 16, 37373, 41047),
('Maryland', 'M', 17, 36980, 41657),
('Maryland', 'M', 18, 35004, 45175),
('Maryland', 'M', 19, 33029, 38869),
('Maryland', 'M', 20, 32505, 37411),
('Maryland', 'M', 21, 30244, 36602),
('Maryland', 'M', 22, 29463, 36399),
('Maryland', 'M', 23, 29156, 37326),
('Maryland', 'M', 24, 28962, 36809),
('Maryland', 'M', 25, 29936, 39310),
('Maryland', 'M', 26, 28873, 35190),
('Maryland', 'M', 27, 31191, 37003),
('Maryland', 'M', 28, 33560, 37557),
('Maryland', 'M', 29, 36745, 35750),
('Maryland', 'M', 30, 38834, 34753),
('Maryland', 'M', 31, 37038, 33509),
('Maryland', 'M', 32, 37652, 33731),
('Maryland', 'M', 33, 38209, 34332),
('Maryland', 'M', 34, 39891, 32184),
('Maryland', 'M', 35, 43531, 34396),
('Maryland', 'M', 36, 44369, 36143),
('Maryland', 'M', 37, 43213, 38023),
('Maryland', 'M', 38, 43616, 40400),
('Maryland', 'M', 39, 44396, 38484),
('Maryland', 'M', 40, 45453, 38148),
('Maryland', 'M', 41, 44077, 38831),
('Maryland', 'M', 42, 43383, 40664),
('Maryland', 'M', 43, 42670, 43526),
('Maryland', 'M', 44, 40687, 44487),
('Maryland', 'M', 45, 41132, 43178),
('Maryland', 'M', 46, 38832, 43373),
('Maryland', 'M', 47, 37984, 43995),
('Maryland', 'M', 48, 36792, 44756),
('Maryland', 'M', 49, 36223, 43352),
('Maryland', 'M', 50, 35905, 42270),
('Maryland', 'M', 51, 35633, 41427),
('Maryland', 'M', 52, 35744, 39453),
('Maryland', 'M', 53, 37467, 39669),
('Maryland', 'M', 54, 27722, 37019),
('Maryland', 'M', 55, 27658, 35690),
('Maryland', 'M', 56, 26986, 34211),
('Maryland', 'M', 57, 28259, 33407),
('Maryland', 'M', 58, 24532, 32363),
('Maryland', 'M', 59, 22188, 31693),
('Maryland', 'M', 60, 21550, 31318),
('Maryland', 'M', 61, 20283, 33425),
('Maryland', 'M', 62, 19626, 23658),
('Maryland', 'M', 63, 17937, 23545),
('Maryland', 'M', 64, 17477, 22220),
('Maryland', 'M', 65, 16875, 24012),
('Maryland', 'M', 66, 15409, 20503),
('Maryland', 'M', 67, 15444, 18249),
('Maryland', 'M', 68, 15041, 17746),
('Maryland', 'M', 69, 14721, 16620),
('Maryland', 'M', 70, 14562, 16019),
('Maryland', 'M', 71, 13796, 14438),
('Maryland', 'M', 72, 13291, 14094),
('Maryland', 'M', 73, 12890, 13329),
('Maryland', 'M', 74, 12126, 11733),
('Maryland', 'M', 75, 11830, 11662),
('Maryland', 'M', 76, 10834, 10908),
('Maryland', 'M', 77, 10253, 10528),
('Maryland', 'M', 78, 9745, 10131),
('Maryland', 'M', 79, 9029, 9286),
('Maryland', 'M', 80, 8076, 8546),
('Maryland', 'M', 81, 6832, 8012),
('Maryland', 'M', 82, 6097, 7197),
('Maryland', 'M', 83, 5119, 6863),
('Maryland', 'M', 84, 4484, 5766),
('Maryland', 'M', 85, 19025, 28844),
('Maryland', 'F', 0, 34511, 36888),
('Maryland', 'F', 1, 34339, 36469),
('Maryland', 'F', 2, 33903, 36307),
('Maryland', 'F', 3, 34891, 35896),
('Maryland', 'F', 4, 35381, 36054),
('Maryland', 'F', 5, 36346, 35723),
('Maryland', 'F', 6, 36744, 35496),
('Maryland', 'F', 7, 38138, 36125),
('Maryland', 'F', 8, 39036, 34706),
('Maryland', 'F', 9, 39990, 34865),
('Maryland', 'F', 10, 40826, 34257),
('Maryland', 'F', 11, 38968, 35339),
('Maryland', 'F', 12, 38292, 35885),
('Maryland', 'F', 13, 37126, 36974),
('Maryland', 'F', 14, 36978, 37266),
('Maryland', 'F', 15, 36671, 38637),
('Maryland', 'F', 16, 35290, 39268),
('Maryland', 'F', 17, 35376, 40299),
('Maryland', 'F', 18, 33583, 43249),
('Maryland', 'F', 19, 33215, 38032),
('Maryland', 'F', 20, 33020, 37682),
('Maryland', 'F', 21, 31210, 36794),
('Maryland', 'F', 22, 30913, 36216),
('Maryland', 'F', 23, 31030, 37941),
('Maryland', 'F', 24, 30891, 36453),
('Maryland', 'F', 25, 32151, 40209),
('Maryland', 'F', 26, 31546, 35696),
('Maryland', 'F', 27, 33942, 38331),
('Maryland', 'F', 28, 36864, 38967),
('Maryland', 'F', 29, 39727, 35190),
('Maryland', 'F', 30, 41568, 37123),
('Maryland', 'F', 31, 40524, 35411),
('Maryland', 'F', 32, 40899, 35281),
('Maryland', 'F', 33, 41939, 36259),
('Maryland', 'F', 34, 43528, 34497),
('Maryland', 'F', 35, 46664, 36521),
('Maryland', 'F', 36, 48318, 38859),
('Maryland', 'F', 37, 47586, 41648),
('Maryland', 'F', 38, 47644, 42904),
('Maryland', 'F', 39, 47835, 41319),
('Maryland', 'F', 40, 48661, 41814),
('Maryland', 'F', 41, 47101, 42135),
('Maryland', 'F', 42, 46922, 43638),
('Maryland', 'F', 43, 46127, 46957),
('Maryland', 'F', 44, 44275, 48511),
('Maryland', 'F', 45, 44430, 47479),
('Maryland', 'F', 46, 42872, 47274),
('Maryland', 'F', 47, 41958, 47113),
('Maryland', 'F', 48, 40275, 47711),
('Maryland', 'F', 49, 39833, 46279),
('Maryland', 'F', 50, 39490, 46167),
('Maryland', 'F', 51, 38837, 45242),
('Maryland', 'F', 52, 38546, 42888),
('Maryland', 'F', 53, 40232, 42847),
('Maryland', 'F', 54, 29606, 41382),
('Maryland', 'F', 55, 30246, 40011),
('Maryland', 'F', 56, 29238, 37858),
('Maryland', 'F', 57, 30081, 37267),
('Maryland', 'F', 58, 26833, 36488),
('Maryland', 'F', 59, 24272, 34998),
('Maryland', 'F', 60, 23264, 34717),
('Maryland', 'F', 61, 22049, 36906),
('Maryland', 'F', 62, 21365, 26126),
('Maryland', 'F', 63, 19704, 26921),
('Maryland', 'F', 64, 19400, 25693),
('Maryland', 'F', 65, 19414, 26681),
('Maryland', 'F', 66, 17875, 23715),
('Maryland', 'F', 67, 18193, 21676),
('Maryland', 'F', 68, 17726, 20844),
('Maryland', 'F', 69, 17577, 19623),
('Maryland', 'F', 70, 18017, 19023),
('Maryland', 'F', 71, 17277, 17569),
('Maryland', 'F', 72, 17543, 17230),
('Maryland', 'F', 73, 17104, 17189),
('Maryland', 'F', 74, 16527, 15508),
('Maryland', 'F', 75, 16965, 15594),
('Maryland', 'F', 76, 16269, 14638),
('Maryland', 'F', 77, 15450, 14412),
('Maryland', 'F', 78, 14642, 14571),
('Maryland', 'F', 79, 14024, 13427),
('Maryland', 'F', 80, 13226, 13461),
('Maryland', 'F', 81, 11047, 12732),
('Maryland', 'F', 82, 10524, 11683),
('Maryland', 'F', 83, 9474, 11771),
('Maryland', 'F', 84, 8538, 10692),
('Maryland', 'F', 85, 48680, 63040),
('Massachusetts', 'M', 0, 40436, 40194),
('Massachusetts', 'M', 1, 40124, 39518),
('Massachusetts', 'M', 2, 40332, 38736),
('Massachusetts', 'M', 3, 40618, 38298),
('Massachusetts', 'M', 4, 41584, 38987),
('Massachusetts', 'M', 5, 42643, 39180),
('Massachusetts', 'M', 6, 42952, 38893),
('Massachusetts', 'M', 7, 44354, 39833),
('Massachusetts', 'M', 8, 44301, 39112),
('Massachusetts', 'M', 9, 46045, 39015),
('Massachusetts', 'M', 10, 47023, 39467),
('Massachusetts', 'M', 11, 44534, 39847),
('Massachusetts', 'M', 12, 44373, 40818),
('Massachusetts', 'M', 13, 43043, 41969),
('Massachusetts', 'M', 14, 43046, 42278),
('Massachusetts', 'M', 15, 42547, 43736),
('Massachusetts', 'M', 16, 40692, 43740),
('Massachusetts', 'M', 17, 40962, 45484),
('Massachusetts', 'M', 18, 43208, 50019),
('Massachusetts', 'M', 19, 43651, 49064),
('Massachusetts', 'M', 20, 42826, 49188),
('Massachusetts', 'M', 21, 40675, 47674),
('Massachusetts', 'M', 22, 39007, 45168),
('Massachusetts', 'M', 23, 38369, 44526),
('Massachusetts', 'M', 24, 38558, 43217),
('Massachusetts', 'M', 25, 40115, 44594),
('Massachusetts', 'M', 26, 39513, 44707),
('Massachusetts', 'M', 27, 41140, 43944),
('Massachusetts', 'M', 28, 43838, 42562),
('Massachusetts', 'M', 29, 46807, 38943),
('Massachusetts', 'M', 30, 49380, 40825),
('Massachusetts', 'M', 31, 46816, 40258),
('Massachusetts', 'M', 32, 47608, 40178),
('Massachusetts', 'M', 33, 48163, 40738),
('Massachusetts', 'M', 34, 49860, 39750),
('Massachusetts', 'M', 35, 53005, 40470),
('Massachusetts', 'M', 36, 53083, 43132),
('Massachusetts', 'M', 37, 52977, 45460),
('Massachusetts', 'M', 38, 52604, 47858),
('Massachusetts', 'M', 39, 53210, 45502),
('Massachusetts', 'M', 40, 53716, 46021),
('Massachusetts', 'M', 41, 51866, 46939),
('Massachusetts', 'M', 42, 51741, 48328),
('Massachusetts', 'M', 43, 50228, 51618),
('Massachusetts', 'M', 44, 48495, 51819),
('Massachusetts', 'M', 45, 48681, 51814),
('Massachusetts', 'M', 46, 46439, 51504),
('Massachusetts', 'M', 47, 45100, 51752),
('Massachusetts', 'M', 48, 43441, 51990),
('Massachusetts', 'M', 49, 42597, 49693),
('Massachusetts', 'M', 50, 42468, 49813),
('Massachusetts', 'M', 51, 41603, 48040),
('Massachusetts', 'M', 52, 41143, 46228),
('Massachusetts', 'M', 53, 44101, 46285),
('Massachusetts', 'M', 54, 31871, 43806),
('Massachusetts', 'M', 55, 31770, 42406),
('Massachusetts', 'M', 56, 31789, 40689),
('Massachusetts', 'M', 57, 33023, 39615),
('Massachusetts', 'M', 58, 28021, 38903),
('Massachusetts', 'M', 59, 25214, 37804),
('Massachusetts', 'M', 60, 24321, 36852),
('Massachusetts', 'M', 61, 23106, 40407),
('Massachusetts', 'M', 62, 22676, 28048),
('Massachusetts', 'M', 63, 21348, 27690),
('Massachusetts', 'M', 64, 20631, 27188),
('Massachusetts', 'M', 65, 21080, 28067),
('Massachusetts', 'M', 66, 19426, 23552),
('Massachusetts', 'M', 67, 19708, 20951),
('Massachusetts', 'M', 68, 19482, 20023),
('Massachusetts', 'M', 69, 18889, 18794),
('Massachusetts', 'M', 70, 19139, 18529),
('Massachusetts', 'M', 71, 18623, 17219),
('Massachusetts', 'M', 72, 18347, 16365),
('Massachusetts', 'M', 73, 18198, 16475),
('Massachusetts', 'M', 74, 17022, 14887),
('Massachusetts', 'M', 75, 16726, 14594),
('Massachusetts', 'M', 76, 15835, 14296),
('Massachusetts', 'M', 77, 14570, 13343),
('Massachusetts', 'M', 78, 13830, 13185),
('Massachusetts', 'M', 79, 13002, 12422),
('Massachusetts', 'M', 80, 11830, 11655),
('Massachusetts', 'M', 81, 10178, 11261),
('Massachusetts', 'M', 82, 9605, 10025),
('Massachusetts', 'M', 83, 8100, 9505),
('Massachusetts', 'M', 84, 7178, 8378),
('Massachusetts', 'M', 85, 31408, 42445),
('Massachusetts', 'F', 0, 38447, 38342),
('Massachusetts', 'F', 1, 38410, 37988),
('Massachusetts', 'F', 2, 38947, 37333),
('Massachusetts', 'F', 3, 38870, 36883),
('Massachusetts', 'F', 4, 39616, 37289),
('Massachusetts', 'F', 5, 40650, 37353),
('Massachusetts', 'F', 6, 40624, 37914),
('Massachusetts', 'F', 7, 41865, 38399),
('Massachusetts', 'F', 8, 42260, 37323),
('Massachusetts', 'F', 9, 43536, 37422),
('Massachusetts', 'F', 10, 44474, 38178),
('Massachusetts', 'F', 11, 42897, 38180),
('Massachusetts', 'F', 12, 42123, 38851),
('Massachusetts', 'F', 13, 40894, 39998),
('Massachusetts', 'F', 14, 40567, 39932),
('Massachusetts', 'F', 15, 39996, 41346),
('Massachusetts', 'F', 16, 38606, 41807),
('Massachusetts', 'F', 17, 38769, 43390),
('Massachusetts', 'F', 18, 42599, 50122),
('Massachusetts', 'F', 19, 45627, 51596),
('Massachusetts', 'F', 20, 43929, 49950),
('Massachusetts', 'F', 21, 42081, 49327),
('Massachusetts', 'F', 22, 40774, 46457),
('Massachusetts', 'F', 23, 39992, 44710),
('Massachusetts', 'F', 24, 39915, 43677),
('Massachusetts', 'F', 25, 41728, 44604),
('Massachusetts', 'F', 26, 40799, 44497),
('Massachusetts', 'F', 27, 42746, 42978),
('Massachusetts', 'F', 28, 45053, 41915),
('Massachusetts', 'F', 29, 48869, 37897),
('Massachusetts', 'F', 30, 50905, 40076),
('Massachusetts', 'F', 31, 48653, 40495),
('Massachusetts', 'F', 32, 49235, 39830),
('Massachusetts', 'F', 33, 50007, 41369),
('Massachusetts', 'F', 34, 51655, 39264),
('Massachusetts', 'F', 35, 54211, 41124),
('Massachusetts', 'F', 36, 55102, 43584),
('Massachusetts', 'F', 37, 54144, 46679),
('Massachusetts', 'F', 38, 54496, 49607),
('Massachusetts', 'F', 39, 55096, 47501),
('Massachusetts', 'F', 40, 55558, 47819),
('Massachusetts', 'F', 41, 54125, 48335),
('Massachusetts', 'F', 42, 53273, 50223),
('Massachusetts', 'F', 43, 53274, 52995),
('Massachusetts', 'F', 44, 51084, 53903),
('Massachusetts', 'F', 45, 50696, 52704),
('Massachusetts', 'F', 46, 48732, 53215),
('Massachusetts', 'F', 47, 47545, 53196),
('Massachusetts', 'F', 48, 45957, 53604),
('Massachusetts', 'F', 49, 45459, 52552),
('Massachusetts', 'F', 50, 44611, 51355),
('Massachusetts', 'F', 51, 44043, 50901),
('Massachusetts', 'F', 52, 44150, 49184),
('Massachusetts', 'F', 53, 46940, 48596),
('Massachusetts', 'F', 54, 34667, 46203),
('Massachusetts', 'F', 55, 34166, 44830),
('Massachusetts', 'F', 56, 33946, 43076),
('Massachusetts', 'F', 57, 35687, 42405),
('Massachusetts', 'F', 58, 30552, 41755),
('Massachusetts', 'F', 59, 27845, 40813),
('Massachusetts', 'F', 60, 26748, 40059),
('Massachusetts', 'F', 61, 25632, 43440),
('Massachusetts', 'F', 62, 25111, 31266),
('Massachusetts', 'F', 63, 24153, 30826),
('Massachusetts', 'F', 64, 23828, 30350),
('Massachusetts', 'F', 65, 24176, 32085),
('Massachusetts', 'F', 66, 22523, 26851),
('Massachusetts', 'F', 67, 23350, 24572),
('Massachusetts', 'F', 68, 23375, 23674),
('Massachusetts', 'F', 69, 23732, 22597),
('Massachusetts', 'F', 70, 24303, 22203),
('Massachusetts', 'F', 71, 23719, 21240),
('Massachusetts', 'F', 72, 24147, 20814),
('Massachusetts', 'F', 73, 23862, 20857),
('Massachusetts', 'F', 74, 23494, 19170),
('Massachusetts', 'F', 75, 23508, 19522),
('Massachusetts', 'F', 76, 23244, 19207),
('Massachusetts', 'F', 77, 22096, 19231),
('Massachusetts', 'F', 78, 21407, 19237),
('Massachusetts', 'F', 79, 20905, 18310),
('Massachusetts', 'F', 80, 19713, 18266),
('Massachusetts', 'F', 81, 17802, 17715),
('Massachusetts', 'F', 82, 17495, 17030),
('Massachusetts', 'F', 83, 15139, 16052),
('Massachusetts', 'F', 84, 14565, 15842),
('Massachusetts', 'F', 85, 86424, 100652),
('Michigan', 'M', 0, 67968, 65376),
('Michigan', 'M', 1, 67853, 63985),
('Michigan', 'M', 2, 68746, 62718),
('Michigan', 'M', 3, 68717, 63304),
('Michigan', 'M', 4, 70210, 64459),
('Michigan', 'M', 5, 73212, 64271),
('Michigan', 'M', 6, 73593, 64725),
('Michigan', 'M', 7, 75628, 66649),
('Michigan', 'M', 8, 77886, 66221),
('Michigan', 'M', 9, 79867, 66208),
('Michigan', 'M', 10, 82053, 67487),
('Michigan', 'M', 11, 76451, 67456),
('Michigan', 'M', 12, 75928, 68765),
('Michigan', 'M', 13, 74698, 71835),
('Michigan', 'M', 14, 75370, 72247),
('Michigan', 'M', 15, 76079, 74181),
('Michigan', 'M', 16, 73191, 76156),
('Michigan', 'M', 17, 73954, 77315),
('Michigan', 'M', 18, 73949, 77321),
('Michigan', 'M', 19, 72729, 73102),
('Michigan', 'M', 20, 71301, 71330),
('Michigan', 'M', 21, 68304, 70400),
('Michigan', 'M', 22, 64306, 68691),
('Michigan', 'M', 23, 62710, 69228),
('Michigan', 'M', 24, 60052, 64799),
('Michigan', 'M', 25, 61880, 64735),
('Michigan', 'M', 26, 60935, 66734),
('Michigan', 'M', 27, 62621, 65383),
('Michigan', 'M', 28, 67356, 66527),
('Michigan', 'M', 29, 72427, 64341),
('Michigan', 'M', 30, 73475, 62946),
('Michigan', 'M', 31, 70288, 60038),
('Michigan', 'M', 32, 68996, 57893),
('Michigan', 'M', 33, 69649, 60246),
('Michigan', 'M', 34, 71550, 59965),
('Michigan', 'M', 35, 75712, 60633),
('Michigan', 'M', 36, 78367, 65474),
('Michigan', 'M', 37, 77394, 70239),
('Michigan', 'M', 38, 78560, 70633),
('Michigan', 'M', 39, 79619, 68104),
('Michigan', 'M', 40, 81627, 67117),
('Michigan', 'M', 41, 80344, 67742),
('Michigan', 'M', 42, 81452, 69207),
('Michigan', 'M', 43, 80827, 74188),
('Michigan', 'M', 44, 77794, 76516),
('Michigan', 'M', 45, 78031, 75783),
('Michigan', 'M', 46, 75018, 76663),
('Michigan', 'M', 47, 72063, 77344),
('Michigan', 'M', 48, 71398, 79261),
('Michigan', 'M', 49, 68922, 77229),
('Michigan', 'M', 50, 67694, 78271),
('Michigan', 'M', 51, 65416, 77228),
('Michigan', 'M', 52, 64252, 73713),
('Michigan', 'M', 53, 67623, 73806),
('Michigan', 'M', 54, 49878, 70470),
('Michigan', 'M', 55, 49539, 67444),
('Michigan', 'M', 56, 49771, 66177),
('Michigan', 'M', 57, 52565, 63670),
('Michigan', 'M', 58, 46015, 62389),
('Michigan', 'M', 59, 41323, 59329),
('Michigan', 'M', 60, 39647, 58082),
('Michigan', 'M', 61, 38190, 61456),
('Michigan', 'M', 62, 36544, 44250),
('Michigan', 'M', 63, 33785, 43466),
('Michigan', 'M', 64, 33620, 43142),
('Michigan', 'M', 65, 32942, 45517),
('Michigan', 'M', 66, 29369, 38996),
('Michigan', 'M', 67, 29531, 34801),
('Michigan', 'M', 68, 29369, 32862),
('Michigan', 'M', 69, 29630, 31512),
('Michigan', 'M', 70, 29531, 29804),
('Michigan', 'M', 71, 28472, 27089),
('Michigan', 'M', 72, 28380, 26813),
('Michigan', 'M', 73, 27397, 25950),
('Michigan', 'M', 74, 25684, 22275),
('Michigan', 'M', 75, 24656, 22030),
('Michigan', 'M', 76, 22730, 21297),
('Michigan', 'M', 77, 21284, 20707),
('Michigan', 'M', 78, 19925, 20216),
('Michigan', 'M', 79, 18105, 18723),
('Michigan', 'M', 80, 15946, 18219),
('Michigan', 'M', 81, 14058, 16756),
('Michigan', 'M', 82, 12934, 15078),
('Michigan', 'M', 83, 11161, 13873),
('Michigan', 'M', 84, 9743, 12328),
('Michigan', 'M', 85, 41389, 59005),
('Michigan', 'F', 0, 64524, 62304),
('Michigan', 'F', 1, 64962, 60998),
('Michigan', 'F', 2, 65337, 60414),
('Michigan', 'F', 3, 65801, 59968),
('Michigan', 'F', 4, 67357, 62000),
('Michigan', 'F', 5, 69293, 61147),
('Michigan', 'F', 6, 69876, 61706),
('Michigan', 'F', 7, 71658, 63690),
('Michigan', 'F', 8, 74280, 62931),
('Michigan', 'F', 9, 76066, 63576),
('Michigan', 'F', 10, 77585, 64118),
('Michigan', 'F', 11, 72343, 64611),
('Michigan', 'F', 12, 72542, 66050),
('Michigan', 'F', 13, 71106, 68057),
('Michigan', 'F', 14, 71418, 68651),
('Michigan', 'F', 15, 71484, 70214),
('Michigan', 'F', 16, 68875, 72599),
('Michigan', 'F', 17, 69476, 73806),
('Michigan', 'F', 18, 70335, 74467),
('Michigan', 'F', 19, 71402, 70344),
('Michigan', 'F', 20, 70513, 69545),
('Michigan', 'F', 21, 67502, 68300),
('Michigan', 'F', 22, 63452, 67213),
('Michigan', 'F', 23, 60841, 66785),
('Michigan', 'F', 24, 59391, 62153),
('Michigan', 'F', 25, 61301, 62429),
('Michigan', 'F', 26, 60737, 64196),
('Michigan', 'F', 27, 62878, 65124),
('Michigan', 'F', 28, 67453, 65108),
('Michigan', 'F', 29, 72195, 64031),
('Michigan', 'F', 30, 72900, 60472),
('Michigan', 'F', 31, 69664, 57155),
('Michigan', 'F', 32, 68856, 57453),
('Michigan', 'F', 33, 70233, 59523),
('Michigan', 'F', 34, 71156, 58922),
('Michigan', 'F', 35, 75746, 60907),
('Michigan', 'F', 36, 78839, 65264),
('Michigan', 'F', 37, 78611, 70249),
('Michigan', 'F', 38, 79556, 71258),
('Michigan', 'F', 39, 81174, 67836),
('Michigan', 'F', 40, 82785, 66838),
('Michigan', 'F', 41, 81875, 68773),
('Michigan', 'F', 42, 83009, 69352),
('Michigan', 'F', 43, 83342, 74477),
('Michigan', 'F', 44, 79481, 77001),
('Michigan', 'F', 45, 79502, 77077),
('Michigan', 'F', 46, 76567, 77667),
('Michigan', 'F', 47, 74356, 79295),
('Michigan', 'F', 48, 72416, 80360),
('Michigan', 'F', 49, 70693, 78984),
('Michigan', 'F', 50, 69060, 79875),
('Michigan', 'F', 51, 67730, 79423),
('Michigan', 'F', 52, 66706, 76224),
('Michigan', 'F', 53, 69580, 75453),
('Michigan', 'F', 54, 51291, 72393),
('Michigan', 'F', 55, 50923, 70106),
('Michigan', 'F', 56, 51831, 68288),
('Michigan', 'F', 57, 54854, 66447),
('Michigan', 'F', 58, 48250, 64625),
('Michigan', 'F', 59, 43764, 62933),
('Michigan', 'F', 60, 41851, 61653),
('Michigan', 'F', 61, 40483, 65181),
('Michigan', 'F', 62, 39464, 47015),
('Michigan', 'F', 63, 37748, 46424),
('Michigan', 'F', 64, 37391, 47031),
('Michigan', 'F', 65, 37137, 49658),
('Michigan', 'F', 66, 34142, 43208),
('Michigan', 'F', 67, 34749, 38925),
('Michigan', 'F', 68, 35351, 36906),
('Michigan', 'F', 69, 35845, 35698),
('Michigan', 'F', 70, 36178, 34571),
('Michigan', 'F', 71, 34419, 32785),
('Michigan', 'F', 72, 35277, 32309),
('Michigan', 'F', 73, 34576, 31746),
('Michigan', 'F', 74, 33709, 28674),
('Michigan', 'F', 75, 33667, 28587),
('Michigan', 'F', 76, 32025, 28657),
('Michigan', 'F', 77, 30431, 28414),
('Michigan', 'F', 78, 29572, 28234),
('Michigan', 'F', 79, 28318, 26024),
('Michigan', 'F', 80, 26113, 26003),
('Michigan', 'F', 81, 23376, 25049),
('Michigan', 'F', 82, 22906, 23476),
('Michigan', 'F', 83, 20069, 22887),
('Michigan', 'F', 84, 18572, 20921),
('Michigan', 'F', 85, 102613, 127739),
('Minnesota', 'M', 0, 33839, 37602),
('Minnesota', 'M', 1, 33358, 37079),
('Minnesota', 'M', 2, 33620, 36792),
('Minnesota', 'M', 3, 33711, 35713),
('Minnesota', 'M', 4, 34498, 36024),
('Minnesota', 'M', 5, 34962, 35120),
('Minnesota', 'M', 6, 35782, 34017),
('Minnesota', 'M', 7, 36367, 34646),
('Minnesota', 'M', 8, 37157, 34119),
('Minnesota', 'M', 9, 38065, 33754),
('Minnesota', 'M', 10, 39208, 34079),
('Minnesota', 'M', 11, 38174, 34222),
('Minnesota', 'M', 12, 38631, 35051),
('Minnesota', 'M', 13, 38077, 35426),
('Minnesota', 'M', 14, 38854, 36257),
('Minnesota', 'M', 15, 39423, 36847),
('Minnesota', 'M', 16, 38337, 37555),
('Minnesota', 'M', 17, 39200, 38089),
('Minnesota', 'M', 18, 38432, 36677),
('Minnesota', 'M', 19, 37083, 37987),
('Minnesota', 'M', 20, 36411, 36536),
('Minnesota', 'M', 21, 34225, 35815),
('Minnesota', 'M', 22, 31909, 36275),
('Minnesota', 'M', 23, 31484, 36771),
('Minnesota', 'M', 24, 31291, 36200),
('Minnesota', 'M', 25, 31700, 37184),
('Minnesota', 'M', 26, 30104, 40677),
('Minnesota', 'M', 27, 30739, 37185),
('Minnesota', 'M', 28, 32600, 38550),
('Minnesota', 'M', 29, 35954, 37218),
('Minnesota', 'M', 30, 36859, 34266),
('Minnesota', 'M', 31, 35750, 33920),
('Minnesota', 'M', 32, 34510, 33871),
('Minnesota', 'M', 33, 34998, 33300),
('Minnesota', 'M', 34, 36353, 31763),
('Minnesota', 'M', 35, 39102, 31863),
('Minnesota', 'M', 36, 41013, 33670),
('Minnesota', 'M', 37, 41601, 36897),
('Minnesota', 'M', 38, 41884, 37345),
('Minnesota', 'M', 39, 43485, 36315),
('Minnesota', 'M', 40, 43494, 34855),
('Minnesota', 'M', 41, 41907, 35225),
('Minnesota', 'M', 42, 41684, 36754),
('Minnesota', 'M', 43, 41062, 39286),
('Minnesota', 'M', 44, 39675, 41512),
('Minnesota', 'M', 45, 39483, 42004),
('Minnesota', 'M', 46, 38174, 41955),
('Minnesota', 'M', 47, 36790, 43791),
('Minnesota', 'M', 48, 35845, 43428),
('Minnesota', 'M', 49, 34731, 41832),
('Minnesota', 'M', 50, 33376, 41264),
('Minnesota', 'M', 51, 31666, 40474),
('Minnesota', 'M', 52, 30852, 38946),
('Minnesota', 'M', 53, 32479, 38364),
('Minnesota', 'M', 54, 23927, 37324),
('Minnesota', 'M', 55, 23701, 35387),
('Minnesota', 'M', 56, 23499, 34339),
('Minnesota', 'M', 57, 24545, 33155),
('Minnesota', 'M', 58, 21281, 31618),
('Minnesota', 'M', 59, 20033, 29654),
('Minnesota', 'M', 60, 18967, 28538),
('Minnesota', 'M', 61, 18382, 30496),
('Minnesota', 'M', 62, 17545, 21828),
('Minnesota', 'M', 63, 16500, 21546),
('Minnesota', 'M', 64, 15794, 21118),
('Minnesota', 'M', 65, 15468, 21942),
('Minnesota', 'M', 66, 14591, 18810),
('Minnesota', 'M', 67, 14256, 17483),
('Minnesota', 'M', 68, 14253, 16322),
('Minnesota', 'M', 69, 13968, 15679),
('Minnesota', 'M', 70, 13840, 14912),
('Minnesota', 'M', 71, 13090, 13784),
('Minnesota', 'M', 72, 13091, 12981),
('Minnesota', 'M', 73, 12650, 12492),
('Minnesota', 'M', 74, 11960, 11554),
('Minnesota', 'M', 75, 11698, 11253),
('Minnesota', 'M', 76, 10783, 10783),
('Minnesota', 'M', 77, 10631, 10347),
('Minnesota', 'M', 78, 9542, 9882),
('Minnesota', 'M', 79, 9192, 9157),
('Minnesota', 'M', 80, 8095, 8847),
('Minnesota', 'M', 81, 7352, 8323),
('Minnesota', 'M', 82, 6820, 7501),
('Minnesota', 'M', 83, 6151, 7070),
('Minnesota', 'M', 84, 5382, 6096),
('Minnesota', 'M', 85, 24663, 33329),
('Minnesota', 'F', 0, 31998, 35926),
('Minnesota', 'F', 1, 32115, 35675),
('Minnesota', 'F', 2, 31848, 34694),
('Minnesota', 'F', 3, 32285, 34377),
('Minnesota', 'F', 4, 32743, 34589),
('Minnesota', 'F', 5, 33193, 33531),
('Minnesota', 'F', 6, 33568, 32489),
('Minnesota', 'F', 7, 34431, 33363),
('Minnesota', 'F', 8, 35263, 32373),
('Minnesota', 'F', 9, 35995, 32492),
('Minnesota', 'F', 10, 37305, 32354),
('Minnesota', 'F', 11, 36750, 32778),
('Minnesota', 'F', 12, 36220, 33272),
('Minnesota', 'F', 13, 36354, 33716),
('Minnesota', 'F', 14, 37101, 34032),
('Minnesota', 'F', 15, 37626, 34852),
('Minnesota', 'F', 16, 36143, 35565),
('Minnesota', 'F', 17, 36827, 36174),
('Minnesota', 'F', 18, 36758, 35450),
('Minnesota', 'F', 19, 36003, 37600),
('Minnesota', 'F', 20, 34753, 35727),
('Minnesota', 'F', 21, 32581, 35717),
('Minnesota', 'F', 22, 31420, 35687),
('Minnesota', 'F', 23, 30900, 35225),
('Minnesota', 'F', 24, 30115, 34756),
('Minnesota', 'F', 25, 30525, 34314),
('Minnesota', 'F', 26, 29429, 39416),
('Minnesota', 'F', 27, 29785, 34538),
('Minnesota', 'F', 28, 32063, 35076),
('Minnesota', 'F', 29, 34990, 32742),
('Minnesota', 'F', 30, 35588, 32068),
('Minnesota', 'F', 31, 34694, 33396),
('Minnesota', 'F', 32, 33860, 31757),
('Minnesota', 'F', 33, 34704, 32154),
('Minnesota', 'F', 34, 36131, 31087),
('Minnesota', 'F', 35, 38355, 30550),
('Minnesota', 'F', 36, 39791, 32698),
('Minnesota', 'F', 37, 41415, 35811),
('Minnesota', 'F', 38, 41677, 35972),
('Minnesota', 'F', 39, 42638, 34898),
('Minnesota', 'F', 40, 42775, 34627),
('Minnesota', 'F', 41, 41589, 34936),
('Minnesota', 'F', 42, 41418, 36459),
('Minnesota', 'F', 43, 40424, 38620),
('Minnesota', 'F', 44, 38814, 40078),
('Minnesota', 'F', 45, 38396, 41178),
('Minnesota', 'F', 46, 37354, 41870),
('Minnesota', 'F', 47, 36077, 42538),
('Minnesota', 'F', 48, 36013, 42494),
('Minnesota', 'F', 49, 33880, 41371),
('Minnesota', 'F', 50, 32848, 41028),
('Minnesota', 'F', 51, 31583, 39946),
('Minnesota', 'F', 52, 31187, 37955),
('Minnesota', 'F', 53, 32596, 37783),
('Minnesota', 'F', 54, 24122, 36383),
('Minnesota', 'F', 55, 23923, 35095),
('Minnesota', 'F', 56, 23795, 34650),
('Minnesota', 'F', 57, 24959, 32425),
('Minnesota', 'F', 58, 22100, 31457),
('Minnesota', 'F', 59, 20732, 29908),
('Minnesota', 'F', 60, 19643, 29663),
('Minnesota', 'F', 61, 18969, 31057),
('Minnesota', 'F', 62, 18345, 22722),
('Minnesota', 'F', 63, 17851, 22375),
('Minnesota', 'F', 64, 17076, 22417),
('Minnesota', 'F', 65, 16678, 23374),
('Minnesota', 'F', 66, 15731, 20423),
('Minnesota', 'F', 67, 15912, 19064),
('Minnesota', 'F', 68, 16121, 17940),
('Minnesota', 'F', 69, 15766, 17231),
('Minnesota', 'F', 70, 15974, 16524),
('Minnesota', 'F', 71, 15626, 16083),
('Minnesota', 'F', 72, 15644, 15227),
('Minnesota', 'F', 73, 15619, 14743),
('Minnesota', 'F', 74, 14948, 13646),
('Minnesota', 'F', 75, 15003, 13698),
('Minnesota', 'F', 76, 14528, 13724),
('Minnesota', 'F', 77, 14092, 13233),
('Minnesota', 'F', 78, 14007, 13151),
('Minnesota', 'F', 79, 13406, 12631),
('Minnesota', 'F', 80, 12788, 12573),
('Minnesota', 'F', 81, 11867, 12149),
('Minnesota', 'F', 82, 11569, 11365),
('Minnesota', 'F', 83, 10602, 11137),
('Minnesota', 'F', 84, 10207, 10531),
('Minnesota', 'F', 85, 61782, 73525),
('Mississippi', 'M', 0, 21335, 23199),
('Mississippi', 'M', 1, 20860, 24111),
('Mississippi', 'M', 2, 20799, 21988),
('Mississippi', 'M', 3, 20540, 21961),
('Mississippi', 'M', 4, 20746, 21731),
('Mississippi', 'M', 5, 21109, 21454),
('Mississippi', 'M', 6, 21305, 21057),
('Mississippi', 'M', 7, 22442, 21858),
('Mississippi', 'M', 8, 22222, 21258),
('Mississippi', 'M', 9, 22726, 20778),
('Mississippi', 'M', 10, 23359, 20800),
('Mississippi', 'M', 11, 22420, 20640),
('Mississippi', 'M', 12, 21785, 20945),
('Mississippi', 'M', 13, 21883, 21390),
('Mississippi', 'M', 14, 22521, 21432),
('Mississippi', 'M', 15, 23022, 22643),
('Mississippi', 'M', 16, 22616, 22330),
('Mississippi', 'M', 17, 23541, 22586),
('Mississippi', 'M', 18, 23749, 22858),
('Mississippi', 'M', 19, 24421, 22983),
('Mississippi', 'M', 20, 23571, 21769),
('Mississippi', 'M', 21, 21578, 21410),
('Mississippi', 'M', 22, 20531, 21594),
('Mississippi', 'M', 23, 19542, 21411),
('Mississippi', 'M', 24, 18171, 20073),
('Mississippi', 'M', 25, 18252, 20098),
('Mississippi', 'M', 26, 17545, 20292),
('Mississippi', 'M', 27, 17892, 20317),
('Mississippi', 'M', 28, 18454, 20776),
('Mississippi', 'M', 29, 18839, 18756),
('Mississippi', 'M', 30, 18938, 18260),
('Mississippi', 'M', 31, 17968, 17597),
('Mississippi', 'M', 32, 17628, 16697),
('Mississippi', 'M', 33, 17441, 16924),
('Mississippi', 'M', 34, 18022, 16473),
('Mississippi', 'M', 35, 19623, 17216),
('Mississippi', 'M', 36, 20060, 17915),
('Mississippi', 'M', 37, 20021, 18533),
('Mississippi', 'M', 38, 20248, 18351),
('Mississippi', 'M', 39, 20250, 17271),
('Mississippi', 'M', 40, 21011, 17012),
('Mississippi', 'M', 41, 20293, 17201),
('Mississippi', 'M', 42, 20902, 17804),
('Mississippi', 'M', 43, 20707, 19114),
('Mississippi', 'M', 44, 19775, 19699),
('Mississippi', 'M', 45, 20193, 19483),
('Mississippi', 'M', 46, 19281, 19876),
('Mississippi', 'M', 47, 18244, 19808),
('Mississippi', 'M', 48, 17821, 20635),
('Mississippi', 'M', 49, 17617, 19502),
('Mississippi', 'M', 50, 17830, 20212),
('Mississippi', 'M', 51, 17304, 19943),
('Mississippi', 'M', 52, 17131, 19038),
('Mississippi', 'M', 53, 18001, 19337),
('Mississippi', 'M', 54, 13359, 18439),
('Mississippi', 'M', 55, 13315, 17429),
('Mississippi', 'M', 56, 13246, 16828),
('Mississippi', 'M', 57, 13665, 16760),
('Mississippi', 'M', 58, 12064, 16673),
('Mississippi', 'M', 59, 11279, 16181),
('Mississippi', 'M', 60, 11363, 15781),
('Mississippi', 'M', 61, 11191, 16634),
('Mississippi', 'M', 62, 10859, 12127),
('Mississippi', 'M', 63, 10179, 11948),
('Mississippi', 'M', 64, 9896, 11820),
('Mississippi', 'M', 65, 9775, 11935),
('Mississippi', 'M', 66, 8699, 10309),
('Mississippi', 'M', 67, 8834, 9661),
('Mississippi', 'M', 68, 8421, 9534),
('Mississippi', 'M', 69, 8356, 9326),
('Mississippi', 'M', 70, 8054, 8766),
('Mississippi', 'M', 71, 7690, 7959),
('Mississippi', 'M', 72, 7487, 7540),
('Mississippi', 'M', 73, 7425, 7373),
('Mississippi', 'M', 74, 6680, 6331),
('Mississippi', 'M', 75, 6262, 6277),
('Mississippi', 'M', 76, 5733, 5794),
('Mississippi', 'M', 77, 5293, 5633),
('Mississippi', 'M', 78, 4977, 5220),
('Mississippi', 'M', 79, 4421, 4846),
('Mississippi', 'M', 80, 4381, 4572),
('Mississippi', 'M', 81, 3634, 4378),
('Mississippi', 'M', 82, 3012, 3781),
('Mississippi', 'M', 83, 2681, 3429),
('Mississippi', 'M', 84, 2408, 2948),
('Mississippi', 'M', 85, 11939, 15693),
('Mississippi', 'F', 0, 20261, 22106),
('Mississippi', 'F', 1, 19973, 23111),
('Mississippi', 'F', 2, 19916, 20991),
('Mississippi', 'F', 3, 19412, 20602),
('Mississippi', 'F', 4, 20086, 21013),
('Mississippi', 'F', 5, 20545, 20355),
('Mississippi', 'F', 6, 20754, 20292),
('Mississippi', 'F', 7, 21335, 20775),
('Mississippi', 'F', 8, 21491, 20102),
('Mississippi', 'F', 9, 21578, 19807),
('Mississippi', 'F', 10, 22388, 19967),
('Mississippi', 'F', 11, 21672, 19363),
('Mississippi', 'F', 12, 20973, 20073),
('Mississippi', 'F', 13, 21100, 20588),
('Mississippi', 'F', 14, 21421, 20801),
('Mississippi', 'F', 15, 21907, 21441),
('Mississippi', 'F', 16, 21968, 21687),
('Mississippi', 'F', 17, 22471, 21482),
('Mississippi', 'F', 18, 23095, 21727),
('Mississippi', 'F', 19, 24469, 22843),
('Mississippi', 'F', 20, 23692, 21513),
('Mississippi', 'F', 21, 22075, 21244),
('Mississippi', 'F', 22, 20979, 20655),
('Mississippi', 'F', 23, 20030, 20069),
('Mississippi', 'F', 24, 19018, 19982),
('Mississippi', 'F', 25, 19190, 19377),
('Mississippi', 'F', 26, 18472, 20862),
('Mississippi', 'F', 27, 19280, 20973),
('Mississippi', 'F', 28, 19770, 21183),
('Mississippi', 'F', 29, 20547, 19185),
('Mississippi', 'F', 30, 20208, 19090),
('Mississippi', 'F', 31, 19191, 18895),
('Mississippi', 'F', 32, 18771, 17664),
('Mississippi', 'F', 33, 18803, 18551),
('Mississippi', 'F', 34, 19478, 17733),
('Mississippi', 'F', 35, 21193, 18625),
('Mississippi', 'F', 36, 21623, 19308),
('Mississippi', 'F', 37, 21824, 20357),
('Mississippi', 'F', 38, 21744, 19958),
('Mississippi', 'F', 39, 22129, 18960),
('Mississippi', 'F', 40, 22616, 18605),
('Mississippi', 'F', 41, 22057, 18322),
('Mississippi', 'F', 42, 21752, 19128),
('Mississippi', 'F', 43, 21907, 20646),
('Mississippi', 'F', 44, 21393, 21413),
('Mississippi', 'F', 45, 21416, 21431),
('Mississippi', 'F', 46, 20488, 21224),
('Mississippi', 'F', 47, 19618, 21558),
('Mississippi', 'F', 48, 19138, 21973),
('Mississippi', 'F', 49, 18857, 21719),
('Mississippi', 'F', 50, 18742, 21223),
('Mississippi', 'F', 51, 17809, 21385),
('Mississippi', 'F', 52, 18088, 20881),
('Mississippi', 'F', 53, 18816, 20878),
('Mississippi', 'F', 54, 14315, 20077),
('Mississippi', 'F', 55, 14259, 19282),
('Mississippi', 'F', 56, 14333, 18744),
('Mississippi', 'F', 57, 14557, 18315),
('Mississippi', 'F', 58, 13382, 18240),
('Mississippi', 'F', 59, 12724, 17175),
('Mississippi', 'F', 60, 12839, 17369),
('Mississippi', 'F', 61, 12219, 18135),
('Mississippi', 'F', 62, 12388, 13728),
('Mississippi', 'F', 63, 11374, 13482),
('Mississippi', 'F', 64, 11682, 13495),
('Mississippi', 'F', 65, 11510, 13625),
('Mississippi', 'F', 66, 10427, 12311),
('Mississippi', 'F', 67, 10809, 11674),
('Mississippi', 'F', 68, 10520, 11610),
('Mississippi', 'F', 69, 10605, 10825),
('Mississippi', 'F', 70, 10388, 10874),
('Mississippi', 'F', 71, 10131, 9739),
('Mississippi', 'F', 72, 10054, 9884),
('Mississippi', 'F', 73, 10179, 9757),
('Mississippi', 'F', 74, 9284, 8632),
('Mississippi', 'F', 75, 9075, 8861),
('Mississippi', 'F', 76, 8820, 8393),
('Mississippi', 'F', 77, 8391, 8377),
('Mississippi', 'F', 78, 8075, 8036),
('Mississippi', 'F', 79, 7672, 7657),
('Mississippi', 'F', 80, 7777, 7568),
('Mississippi', 'F', 81, 6399, 7378),
('Mississippi', 'F', 82, 5775, 6520),
('Mississippi', 'F', 83, 5463, 6127),
('Mississippi', 'F', 84, 5154, 5903),
('Mississippi', 'F', 85, 31361, 36542),
('Missouri', 'M', 0, 37718, 42265),
('Missouri', 'M', 1, 37899, 42096),
('Missouri', 'M', 2, 38005, 40604),
('Missouri', 'M', 3, 37232, 39598),
('Missouri', 'M', 4, 38252, 39946),
('Missouri', 'M', 5, 38937, 38943),
('Missouri', 'M', 6, 39737, 39018),
('Missouri', 'M', 7, 40618, 39208),
('Missouri', 'M', 8, 41512, 38707),
('Missouri', 'M', 9, 42225, 38820),
('Missouri', 'M', 10, 43326, 39255),
('Missouri', 'M', 11, 42479, 38481),
('Missouri', 'M', 12, 41785, 39624),
('Missouri', 'M', 13, 41618, 40190),
('Missouri', 'M', 14, 42849, 41097),
('Missouri', 'M', 15, 42726, 41900),
('Missouri', 'M', 16, 42196, 42964),
('Missouri', 'M', 17, 42465, 43185),
('Missouri', 'M', 18, 41374, 41004),
('Missouri', 'M', 19, 40609, 40011),
('Missouri', 'M', 20, 39768, 39123),
('Missouri', 'M', 21, 37881, 38993),
('Missouri', 'M', 22, 35921, 40163),
('Missouri', 'M', 23, 35257, 40614),
('Missouri', 'M', 24, 33675, 39682),
('Missouri', 'M', 25, 34539, 39895),
('Missouri', 'M', 26, 33265, 42495),
('Missouri', 'M', 27, 34174, 41701),
('Missouri', 'M', 28, 36243, 42284),
('Missouri', 'M', 29, 38778, 40411),
('Missouri', 'M', 30, 39028, 37648),
('Missouri', 'M', 31, 36751, 36483),
('Missouri', 'M', 32, 35560, 35073),
('Missouri', 'M', 33, 36369, 35947),
('Missouri', 'M', 34, 37685, 34138),
('Missouri', 'M', 35, 41509, 35490),
('Missouri', 'M', 36, 42854, 36892),
('Missouri', 'M', 37, 43694, 39766),
('Missouri', 'M', 38, 44223, 40131),
('Missouri', 'M', 39, 44918, 37672),
('Missouri', 'M', 40, 45777, 36563),
('Missouri', 'M', 41, 44062, 37278),
('Missouri', 'M', 42, 43900, 38176),
('Missouri', 'M', 43, 43442, 42094),
('Missouri', 'M', 44, 42088, 43453),
('Missouri', 'M', 45, 41937, 44263),
('Missouri', 'M', 46, 40301, 44597),
('Missouri', 'M', 47, 38320, 45067),
('Missouri', 'M', 48, 37831, 45767),
('Missouri', 'M', 49, 36239, 43783),
('Missouri', 'M', 50, 35879, 43537),
('Missouri', 'M', 51, 35290, 42933),
('Missouri', 'M', 52, 34943, 41426),
('Missouri', 'M', 53, 37070, 41052),
('Missouri', 'M', 54, 27189, 39301),
('Missouri', 'M', 55, 27752, 37137),
('Missouri', 'M', 56, 28111, 36767),
('Missouri', 'M', 57, 28859, 35023),
('Missouri', 'M', 58, 26265, 34674),
('Missouri', 'M', 59, 24355, 33732),
('Missouri', 'M', 60, 23336, 33345),
('Missouri', 'M', 61, 22753, 35148),
('Missouri', 'M', 62, 21782, 25372),
('Missouri', 'M', 63, 20800, 25807),
('Missouri', 'M', 64, 20711, 25874),
('Missouri', 'M', 65, 20450, 26209),
('Missouri', 'M', 66, 19027, 23371),
('Missouri', 'M', 67, 18939, 21221),
('Missouri', 'M', 68, 18333, 19912),
('Missouri', 'M', 69, 17835, 19246),
('Missouri', 'M', 70, 17698, 17962),
('Missouri', 'M', 71, 16917, 16790),
('Missouri', 'M', 72, 16872, 16538),
('Missouri', 'M', 73, 16331, 15976),
('Missouri', 'M', 74, 15285, 14428),
('Missouri', 'M', 75, 14700, 14109),
('Missouri', 'M', 76, 13802, 13256),
('Missouri', 'M', 77, 12726, 12492),
('Missouri', 'M', 78, 12166, 12159),
('Missouri', 'M', 79, 10864, 11211),
('Missouri', 'M', 80, 9832, 10733),
('Missouri', 'M', 81, 8271, 10095),
('Missouri', 'M', 82, 7717, 9034),
('Missouri', 'M', 83, 6558, 8296),
('Missouri', 'M', 84, 5999, 7551),
('Missouri', 'M', 85, 27319, 37266),
('Missouri', 'F', 0, 35817, 40094),
('Missouri', 'F', 1, 35918, 40064),
('Missouri', 'F', 2, 36169, 38724),
('Missouri', 'F', 3, 35913, 38141),
('Missouri', 'F', 4, 36751, 37918),
('Missouri', 'F', 5, 36766, 37346),
('Missouri', 'F', 6, 37660, 37451),
('Missouri', 'F', 7, 38884, 38149),
('Missouri', 'F', 8, 39880, 37066),
('Missouri', 'F', 9, 40695, 37096),
('Missouri', 'F', 10, 41325, 37515),
('Missouri', 'F', 11, 40213, 37214),
('Missouri', 'F', 12, 39772, 38210),
('Missouri', 'F', 13, 39768, 38183),
('Missouri', 'F', 14, 40347, 39013),
('Missouri', 'F', 15, 40546, 40239),
('Missouri', 'F', 16, 39809, 41254),
('Missouri', 'F', 17, 39950, 41730),
('Missouri', 'F', 18, 40550, 39030),
('Missouri', 'F', 19, 41252, 38672),
('Missouri', 'F', 20, 40894, 38342),
('Missouri', 'F', 21, 38061, 37555),
('Missouri', 'F', 22, 36421, 39936),
('Missouri', 'F', 23, 35902, 39913),
('Missouri', 'F', 24, 34007, 39662),
('Missouri', 'F', 25, 35195, 39237),
('Missouri', 'F', 26, 33839, 42646),
('Missouri', 'F', 27, 35063, 43257),
('Missouri', 'F', 28, 36912, 42988),
('Missouri', 'F', 29, 39241, 42002),
('Missouri', 'F', 30, 39423, 37347),
('Missouri', 'F', 31, 36966, 37328),
('Missouri', 'F', 32, 36440, 35027),
('Missouri', 'F', 33, 37390, 35971),
('Missouri', 'F', 34, 38385, 34324),
('Missouri', 'F', 35, 42177, 35995),
('Missouri', 'F', 36, 43893, 37910),
('Missouri', 'F', 37, 44446, 40311),
('Missouri', 'F', 38, 45248, 40368),
('Missouri', 'F', 39, 46391, 37655),
('Missouri', 'F', 40, 46642, 37579),
('Missouri', 'F', 41, 44828, 38297),
('Missouri', 'F', 42, 45198, 39572),
('Missouri', 'F', 43, 45461, 42933),
('Missouri', 'F', 44, 43196, 44766),
('Missouri', 'F', 45, 43160, 44736),
('Missouri', 'F', 46, 41863, 45854),
('Missouri', 'F', 47, 39930, 47120),
('Missouri', 'F', 48, 39573, 47093),
('Missouri', 'F', 49, 38617, 45036),
('Missouri', 'F', 50, 37778, 45288),
('Missouri', 'F', 51, 37059, 45703),
('Missouri', 'F', 52, 36576, 43016),
('Missouri', 'F', 53, 39245, 43227),
('Missouri', 'F', 54, 29336, 41705),
('Missouri', 'F', 55, 29530, 39482),
('Missouri', 'F', 56, 30020, 39335),
('Missouri', 'F', 57, 31206, 38263),
('Missouri', 'F', 58, 28204, 37218),
('Missouri', 'F', 59, 26564, 36402),
('Missouri', 'F', 60, 25543, 35728),
('Missouri', 'F', 61, 24695, 38190),
('Missouri', 'F', 62, 24076, 28464),
('Missouri', 'F', 63, 22959, 28469),
('Missouri', 'F', 64, 22747, 28694),
('Missouri', 'F', 65, 23029, 29485),
('Missouri', 'F', 66, 21902, 26260),
('Missouri', 'F', 67, 21879, 24352),
('Missouri', 'F', 68, 21670, 23078),
('Missouri', 'F', 69, 21556, 22053),
('Missouri', 'F', 70, 21702, 21382),
('Missouri', 'F', 71, 20780, 20157),
('Missouri', 'F', 72, 21140, 19638),
('Missouri', 'F', 73, 20659, 19680),
('Missouri', 'F', 74, 19979, 18414),
('Missouri', 'F', 75, 20168, 18021),
('Missouri', 'F', 76, 19229, 17702),
('Missouri', 'F', 77, 18452, 17263),
('Missouri', 'F', 78, 18213, 17201),
('Missouri', 'F', 79, 17001, 15968),
('Missouri', 'F', 80, 16142, 15990),
('Missouri', 'F', 81, 14523, 15189),
('Missouri', 'F', 82, 13704, 14145),
('Missouri', 'F', 83, 12550, 14077),
('Missouri', 'F', 84, 11756, 12913),
('Missouri', 'F', 85, 72153, 84412),
('Montana', 'M', 0, 5616, 6576),
('Montana', 'M', 1, 5618, 6530),
('Montana', 'M', 2, 5624, 6250),
('Montana', 'M', 3, 5552, 5991),
('Montana', 'M', 4, 5758, 5976),
('Montana', 'M', 5, 5909, 5962),
('Montana', 'M', 6, 6192, 6060),
('Montana', 'M', 7, 6227, 5913),
('Montana', 'M', 8, 6597, 5961),
('Montana', 'M', 9, 6703, 6007),
('Montana', 'M', 10, 7043, 6044),
('Montana', 'M', 11, 6868, 6004),
('Montana', 'M', 12, 7140, 6198),
('Montana', 'M', 13, 7166, 6291),
('Montana', 'M', 14, 7495, 6617),
('Montana', 'M', 15, 7568, 6589),
('Montana', 'M', 16, 7523, 7035),
('Montana', 'M', 17, 7526, 7108),
('Montana', 'M', 18, 7298, 6753),
('Montana', 'M', 19, 6786, 6772),
('Montana', 'M', 20, 6466, 6620),
('Montana', 'M', 21, 6165, 6861),
('Montana', 'M', 22, 5934, 7338),
('Montana', 'M', 23, 5761, 7614),
('Montana', 'M', 24, 5271, 7363),
('Montana', 'M', 25, 5220, 6525),
('Montana', 'M', 26, 5014, 7579),
('Montana', 'M', 27, 4924, 6592),
('Montana', 'M', 28, 5025, 6774),
('Montana', 'M', 29, 5365, 6331),
('Montana', 'M', 30, 5287, 5938),
('Montana', 'M', 31, 5069, 5391),
('Montana', 'M', 32, 4908, 5053),
('Montana', 'M', 33, 5062, 5399),
('Montana', 'M', 34, 5155, 5082),
('Montana', 'M', 35, 5774, 5288),
('Montana', 'M', 36, 6171, 5423),
('Montana', 'M', 37, 6423, 5968),
('Montana', 'M', 38, 6836, 5669),
('Montana', 'M', 39, 6944, 5520),
('Montana', 'M', 40, 7347, 5349),
('Montana', 'M', 41, 7165, 5545),
('Montana', 'M', 42, 7511, 5611),
('Montana', 'M', 43, 7406, 6339),
('Montana', 'M', 44, 7443, 6580),
('Montana', 'M', 45, 7489, 6730),
('Montana', 'M', 46, 7493, 7192),
('Montana', 'M', 47, 7663, 7373),
('Montana', 'M', 48, 7333, 7730),
('Montana', 'M', 49, 7052, 7452),
('Montana', 'M', 50, 6897, 7913),
('Montana', 'M', 51, 6654, 7548),
('Montana', 'M', 52, 6513, 7651),
('Montana', 'M', 53, 6731, 7658),
('Montana', 'M', 54, 5062, 7662),
('Montana', 'M', 55, 5041, 7703),
('Montana', 'M', 56, 4857, 7388),
('Montana', 'M', 57, 5225, 7175),
('Montana', 'M', 58, 4524, 6851),
('Montana', 'M', 59, 4348, 6679),
('Montana', 'M', 60, 4151, 6678),
('Montana', 'M', 61, 3902, 6664),
('Montana', 'M', 62, 3731, 5023),
('Montana', 'M', 63, 3706, 5053),
('Montana', 'M', 64, 3523, 4857),
('Montana', 'M', 65, 3437, 5021),
('Montana', 'M', 66, 3122, 4275),
('Montana', 'M', 67, 3046, 3991),
('Montana', 'M', 68, 3058, 3736),
('Montana', 'M', 69, 3113, 3465),
('Montana', 'M', 70, 3051, 3182),
('Montana', 'M', 71, 2950, 3160),
('Montana', 'M', 72, 2816, 2950),
('Montana', 'M', 73, 2667, 2844),
('Montana', 'M', 74, 2563, 2533),
('Montana', 'M', 75, 2445, 2447),
('Montana', 'M', 76, 2339, 2356),
('Montana', 'M', 77, 2154, 2341),
('Montana', 'M', 78, 2129, 2307),
('Montana', 'M', 79, 1903, 2076),
('Montana', 'M', 80, 1833, 1952),
('Montana', 'M', 81, 1609, 1791),
('Montana', 'M', 82, 1461, 1704),
('Montana', 'M', 83, 1325, 1519),
('Montana', 'M', 84, 1107, 1348),
('Montana', 'M', 85, 4955, 7068),
('Montana', 'F', 0, 5206, 6197),
('Montana', 'F', 1, 5305, 6138),
('Montana', 'F', 2, 5204, 5892),
('Montana', 'F', 3, 5413, 5813),
('Montana', 'F', 4, 5496, 5751),
('Montana', 'F', 5, 5665, 5713),
('Montana', 'F', 6, 5657, 5667),
('Montana', 'F', 7, 5975, 5765),
('Montana', 'F', 8, 6227, 5537),
('Montana', 'F', 9, 6428, 5709),
('Montana', 'F', 10, 6792, 5548),
('Montana', 'F', 11, 6523, 5796),
('Montana', 'F', 12, 6740, 5856),
('Montana', 'F', 13, 6686, 6057),
('Montana', 'F', 14, 6970, 6025),
('Montana', 'F', 15, 7206, 6343),
('Montana', 'F', 16, 7049, 6653),
('Montana', 'F', 17, 7182, 6786),
('Montana', 'F', 18, 6856, 6375),
('Montana', 'F', 19, 6209, 6016),
('Montana', 'F', 20, 6302, 6161),
('Montana', 'F', 21, 5862, 6159),
('Montana', 'F', 22, 5570, 6510),
('Montana', 'F', 23, 5311, 6760),
('Montana', 'F', 24, 4964, 6450),
('Montana', 'F', 25, 4949, 5956),
('Montana', 'F', 26, 4526, 6915),
('Montana', 'F', 27, 4616, 6097),
('Montana', 'F', 28, 5003, 6480),
('Montana', 'F', 29, 5294, 6082),
('Montana', 'F', 30, 5276, 5645),
('Montana', 'F', 31, 5140, 5205),
('Montana', 'F', 32, 4992, 5244),
('Montana', 'F', 33, 5188, 5334),
('Montana', 'F', 34, 5416, 4909),
('Montana', 'F', 35, 5927, 5203),
('Montana', 'F', 36, 6451, 5358),
('Montana', 'F', 37, 6755, 5878),
('Montana', 'F', 38, 6929, 5807),
('Montana', 'F', 39, 7419, 5695),
('Montana', 'F', 40, 7741, 5432),
('Montana', 'F', 41, 7503, 5652),
('Montana', 'F', 42, 7717, 6069),
('Montana', 'F', 43, 7801, 6320),
('Montana', 'F', 44, 7569, 7057),
('Montana', 'F', 45, 7780, 7195),
('Montana', 'F', 46, 7590, 7104),
('Montana', 'F', 47, 7362, 7727),
('Montana', 'F', 48, 7106, 7992),
('Montana', 'F', 49, 6828, 7740),
('Montana', 'F', 50, 6701, 8020),
('Montana', 'F', 51, 6425, 8062),
('Montana', 'F', 52, 5943, 7646),
('Montana', 'F', 53, 6389, 7910),
('Montana', 'F', 54, 4875, 7842),
('Montana', 'F', 55, 4826, 7466),
('Montana', 'F', 56, 4761, 7259),
('Montana', 'F', 57, 5059, 6918),
('Montana', 'F', 58, 4501, 6738),
('Montana', 'F', 59, 4291, 6550),
('Montana', 'F', 60, 4002, 6127),
('Montana', 'F', 61, 3915, 6367),
('Montana', 'F', 62, 3818, 4875),
('Montana', 'F', 63, 3739, 4819),
('Montana', 'F', 64, 3605, 4749),
('Montana', 'F', 65, 3534, 4956),
('Montana', 'F', 66, 3254, 4310),
('Montana', 'F', 67, 3267, 4089),
('Montana', 'F', 68, 3384, 3715),
('Montana', 'F', 69, 3248, 3604),
('Montana', 'F', 70, 3413, 3475),
('Montana', 'F', 71, 3256, 3362),
('Montana', 'F', 72, 3175, 3214),
('Montana', 'F', 73, 3083, 3106),
('Montana', 'F', 74, 2969, 2899),
('Montana', 'F', 75, 2826, 2780),
('Montana', 'F', 76, 2908, 2846),
('Montana', 'F', 77, 2735, 2752),
('Montana', 'F', 78, 2749, 2803),
('Montana', 'F', 79, 2558, 2674),
('Montana', 'F', 80, 2609, 2564),
('Montana', 'F', 81, 2375, 2416),
('Montana', 'F', 82, 2246, 2288),
('Montana', 'F', 83, 2046, 2108),
('Montana', 'F', 84, 1920, 2107),
('Montana', 'F', 85, 10545, 13178),
('Nebraska', 'M', 0, 12186, 14110),
('Nebraska', 'M', 1, 12022, 13648),
('Nebraska', 'M', 2, 11665, 13340),
('Nebraska', 'M', 3, 11780, 13212),
('Nebraska', 'M', 4, 11974, 13344),
('Nebraska', 'M', 5, 12362, 12938),
('Nebraska', 'M', 6, 12127, 12561),
('Nebraska', 'M', 7, 12493, 12467),
('Nebraska', 'M', 8, 12770, 12059),
('Nebraska', 'M', 9, 12924, 12014),
('Nebraska', 'M', 10, 13615, 11642),
('Nebraska', 'M', 11, 13076, 11809),
('Nebraska', 'M', 12, 12995, 12015),
('Nebraska', 'M', 13, 13212, 12455),
('Nebraska', 'M', 14, 13433, 12229),
('Nebraska', 'M', 15, 13934, 12669),
('Nebraska', 'M', 16, 13756, 13000),
('Nebraska', 'M', 17, 13944, 12986),
('Nebraska', 'M', 18, 13755, 13125),
('Nebraska', 'M', 19, 13874, 14395),
('Nebraska', 'M', 20, 13029, 13057),
('Nebraska', 'M', 21, 12630, 13810),
('Nebraska', 'M', 22, 11971, 13187),
('Nebraska', 'M', 23, 11502, 13715),
('Nebraska', 'M', 24, 11305, 13033),
('Nebraska', 'M', 25, 11426, 12819),
('Nebraska', 'M', 26, 10785, 14129),
('Nebraska', 'M', 27, 10845, 11937),
('Nebraska', 'M', 28, 11224, 13031),
('Nebraska', 'M', 29, 11505, 10950),
('Nebraska', 'M', 30, 11618, 11790),
('Nebraska', 'M', 31, 11126, 10443),
('Nebraska', 'M', 32, 10710, 10978),
('Nebraska', 'M', 33, 10832, 11063),
('Nebraska', 'M', 34, 11173, 10764),
('Nebraska', 'M', 35, 11871, 10689),
('Nebraska', 'M', 36, 12482, 11122),
('Nebraska', 'M', 37, 12966, 11692),
('Nebraska', 'M', 38, 12878, 11482),
('Nebraska', 'M', 39, 13283, 11019),
('Nebraska', 'M', 40, 13665, 10650),
('Nebraska', 'M', 41, 13363, 10750),
('Nebraska', 'M', 42, 13260, 11080),
('Nebraska', 'M', 43, 13188, 11761),
('Nebraska', 'M', 44, 13142, 12270),
('Nebraska', 'M', 45, 12783, 12791),
('Nebraska', 'M', 46, 12713, 12706),
('Nebraska', 'M', 47, 12160, 12964),
('Nebraska', 'M', 48, 12006, 13431),
('Nebraska', 'M', 49, 11483, 13020),
('Nebraska', 'M', 50, 11294, 13022),
('Nebraska', 'M', 51, 11031, 12783),
('Nebraska', 'M', 52, 10594, 12666),
('Nebraska', 'M', 53, 10917, 12239),
('Nebraska', 'M', 54, 8111, 12115),
('Nebraska', 'M', 55, 8096, 11606),
('Nebraska', 'M', 56, 8301, 11327),
('Nebraska', 'M', 57, 8160, 10883),
('Nebraska', 'M', 58, 7366, 10506),
('Nebraska', 'M', 59, 6562, 10211),
('Nebraska', 'M', 60, 6570, 9772),
('Nebraska', 'M', 61, 6295, 10024),
('Nebraska', 'M', 62, 6255, 7288),
('Nebraska', 'M', 63, 6044, 7208),
('Nebraska', 'M', 64, 5729, 7440),
('Nebraska', 'M', 65, 5911, 7298),
('Nebraska', 'M', 66, 5424, 6488),
('Nebraska', 'M', 67, 5340, 5769),
('Nebraska', 'M', 68, 5543, 5712),
('Nebraska', 'M', 69, 5404, 5406),
('Nebraska', 'M', 70, 5262, 5284),
('Nebraska', 'M', 71, 5205, 5049),
('Nebraska', 'M', 72, 5212, 4668),
('Nebraska', 'M', 73, 4929, 4750),
('Nebraska', 'M', 74, 4684, 4274),
('Nebraska', 'M', 75, 4585, 4127),
('Nebraska', 'M', 76, 4445, 4099),
('Nebraska', 'M', 77, 4007, 4013),
('Nebraska', 'M', 78, 3804, 3741),
('Nebraska', 'M', 79, 3499, 3551),
('Nebraska', 'M', 80, 3117, 3481),
('Nebraska', 'M', 81, 2743, 3101),
('Nebraska', 'M', 82, 2646, 2829),
('Nebraska', 'M', 83, 2266, 2678),
('Nebraska', 'M', 84, 2019, 2580),
('Nebraska', 'M', 85, 9692, 12606),
('Nebraska', 'F', 0, 11509, 13444),
('Nebraska', 'F', 1, 11512, 13153),
('Nebraska', 'F', 2, 11358, 12720),
('Nebraska', 'F', 3, 11428, 12600),
('Nebraska', 'F', 4, 11529, 12521),
('Nebraska', 'F', 5, 11683, 12398),
('Nebraska', 'F', 6, 11754, 12048),
('Nebraska', 'F', 7, 11850, 11996),
('Nebraska', 'F', 8, 12394, 11378),
('Nebraska', 'F', 9, 12454, 11493),
('Nebraska', 'F', 10, 12761, 11327),
('Nebraska', 'F', 11, 12213, 11449),
('Nebraska', 'F', 12, 12424, 11503),
('Nebraska', 'F', 13, 12575, 11713),
('Nebraska', 'F', 14, 12947, 11876),
('Nebraska', 'F', 15, 13177, 11892),
('Nebraska', 'F', 16, 13084, 12511),
('Nebraska', 'F', 17, 13142, 12475),
('Nebraska', 'F', 18, 13050, 12505),
('Nebraska', 'F', 19, 13206, 13183),
('Nebraska', 'F', 20, 12946, 13308),
('Nebraska', 'F', 21, 12077, 12847),
('Nebraska', 'F', 22, 11770, 13463),
('Nebraska', 'F', 23, 11314, 12936),
('Nebraska', 'F', 24, 10802, 12369),
('Nebraska', 'F', 25, 10964, 12011),
('Nebraska', 'F', 26, 10398, 12973),
('Nebraska', 'F', 27, 10385, 12282),
('Nebraska', 'F', 28, 11035, 11092),
('Nebraska', 'F', 29, 11183, 11307),
('Nebraska', 'F', 30, 11155, 10244),
('Nebraska', 'F', 31, 11016, 10409),
('Nebraska', 'F', 32, 10476, 10496),
('Nebraska', 'F', 33, 10754, 10660),
('Nebraska', 'F', 34, 10895, 10479),
('Nebraska', 'F', 35, 11823, 10061),
('Nebraska', 'F', 36, 12555, 11041),
('Nebraska', 'F', 37, 12868, 11235),
('Nebraska', 'F', 38, 13363, 11084),
('Nebraska', 'F', 39, 13547, 11093),
('Nebraska', 'F', 40, 13788, 10233),
('Nebraska', 'F', 41, 13189, 10575),
('Nebraska', 'F', 42, 13414, 10888),
('Nebraska', 'F', 43, 13203, 11646),
('Nebraska', 'F', 44, 12943, 12453),
('Nebraska', 'F', 45, 12954, 12660),
('Nebraska', 'F', 46, 12756, 13089),
('Nebraska', 'F', 47, 12365, 13251),
('Nebraska', 'F', 48, 12176, 13564),
('Nebraska', 'F', 49, 11700, 13053),
('Nebraska', 'F', 50, 11283, 12930),
('Nebraska', 'F', 51, 10973, 12888),
('Nebraska', 'F', 52, 10601, 12523),
('Nebraska', 'F', 53, 10993, 12469),
('Nebraska', 'F', 54, 8074, 12317),
('Nebraska', 'F', 55, 8179, 11813),
('Nebraska', 'F', 56, 8147, 11700),
('Nebraska', 'F', 57, 8355, 11179),
('Nebraska', 'F', 58, 7637, 10706),
('Nebraska', 'F', 59, 7189, 10330),
('Nebraska', 'F', 60, 6828, 9885),
('Nebraska', 'F', 61, 6667, 10283),
('Nebraska', 'F', 62, 6740, 7516),
('Nebraska', 'F', 63, 6646, 7632),
('Nebraska', 'F', 64, 6422, 7511),
('Nebraska', 'F', 65, 6504, 7714),
('Nebraska', 'F', 66, 6126, 6985),
('Nebraska', 'F', 67, 6267, 6678),
('Nebraska', 'F', 68, 6359, 6275),
('Nebraska', 'F', 69, 6258, 6084),
('Nebraska', 'F', 70, 6315, 6057),
('Nebraska', 'F', 71, 6410, 5908),
('Nebraska', 'F', 72, 6116, 5674),
('Nebraska', 'F', 73, 6040, 5764),
('Nebraska', 'F', 74, 5966, 5260),
('Nebraska', 'F', 75, 5831, 5414),
('Nebraska', 'F', 76, 5654, 5385),
('Nebraska', 'F', 77, 5446, 5202),
('Nebraska', 'F', 78, 5509, 5117),
('Nebraska', 'F', 79, 5218, 5072),
('Nebraska', 'F', 80, 5053, 4838),
('Nebraska', 'F', 81, 4590, 4716),
('Nebraska', 'F', 82, 4481, 4505),
('Nebraska', 'F', 83, 3976, 4240),
('Nebraska', 'F', 84, 3876, 4053),
('Nebraska', 'F', 85, 24564, 28402),
('Nevada', 'M', 0, 15314, 20681),
('Nevada', 'M', 1, 15014, 20778),
('Nevada', 'M', 2, 14800, 20816),
('Nevada', 'M', 3, 15059, 20045),
('Nevada', 'M', 4, 15282, 19925),
('Nevada', 'M', 5, 15294, 19537),
('Nevada', 'M', 6, 15358, 19463),
('Nevada', 'M', 7, 15227, 19109),
('Nevada', 'M', 8, 15575, 18345),
('Nevada', 'M', 9, 15469, 18119),
('Nevada', 'M', 10, 15705, 17787),
('Nevada', 'M', 11, 14509, 18094),
('Nevada', 'M', 12, 14344, 18406),
('Nevada', 'M', 13, 14028, 18333),
('Nevada', 'M', 14, 13904, 18511),
('Nevada', 'M', 15, 13580, 18195),
('Nevada', 'M', 16, 13357, 18542),
('Nevada', 'M', 17, 13617, 18328),
('Nevada', 'M', 18, 13042, 16781),
('Nevada', 'M', 19, 12565, 13147),
('Nevada', 'M', 20, 13216, 13655),
('Nevada', 'M', 21, 12980, 14323),
('Nevada', 'M', 22, 13279, 15615),
('Nevada', 'M', 23, 13813, 17033),
('Nevada', 'M', 24, 13989, 18160),
('Nevada', 'M', 25, 14586, 19620),
('Nevada', 'M', 26, 14357, 19413),
('Nevada', 'M', 27, 14756, 21400),
('Nevada', 'M', 28, 15658, 21823),
('Nevada', 'M', 29, 16861, 20639),
('Nevada', 'M', 30, 17529, 20315),
('Nevada', 'M', 31, 16425, 19330),
('Nevada', 'M', 32, 16171, 19474),
('Nevada', 'M', 33, 16032, 19094),
('Nevada', 'M', 34, 16388, 18856),
('Nevada', 'M', 35, 17472, 18741),
('Nevada', 'M', 36, 17322, 19874),
('Nevada', 'M', 37, 17138, 20972),
('Nevada', 'M', 38, 17312, 21027),
('Nevada', 'M', 39, 16961, 19877),
('Nevada', 'M', 40, 17380, 19096),
('Nevada', 'M', 41, 16130, 18769),
('Nevada', 'M', 42, 16279, 19166),
('Nevada', 'M', 43, 15921, 20499),
('Nevada', 'M', 44, 15255, 19846),
('Nevada', 'M', 45, 15792, 19607),
('Nevada', 'M', 46, 14761, 19869),
('Nevada', 'M', 47, 14185, 19192),
('Nevada', 'M', 48, 13489, 19444),
('Nevada', 'M', 49, 13693, 18250),
('Nevada', 'M', 50, 13845, 18470),
('Nevada', 'M', 51, 13216, 17755),
('Nevada', 'M', 52, 13382, 17132),
('Nevada', 'M', 53, 14389, 17508),
('Nevada', 'M', 54, 10785, 16435),
('Nevada', 'M', 55, 11166, 15951),
('Nevada', 'M', 56, 10840, 15236),
('Nevada', 'M', 57, 11417, 15593),
('Nevada', 'M', 58, 10158, 15626),
('Nevada', 'M', 59, 9635, 14926),
('Nevada', 'M', 60, 9434, 15318),
('Nevada', 'M', 61, 8976, 15585),
('Nevada', 'M', 62, 8876, 11895),
('Nevada', 'M', 63, 8156, 12134),
('Nevada', 'M', 64, 8158, 11748),
('Nevada', 'M', 65, 8026, 11792),
('Nevada', 'M', 66, 7256, 10315),
('Nevada', 'M', 67, 7208, 9580),
('Nevada', 'M', 68, 7005, 9069),
('Nevada', 'M', 69, 6700, 8341),
('Nevada', 'M', 70, 6739, 7998),
('Nevada', 'M', 71, 6218, 7050),
('Nevada', 'M', 72, 5841, 6911),
('Nevada', 'M', 73, 5556, 6707),
('Nevada', 'M', 74, 5226, 5777),
('Nevada', 'M', 75, 5007, 5713),
('Nevada', 'M', 76, 4500, 5450),
('Nevada', 'M', 77, 4120, 5013),
('Nevada', 'M', 78, 3832, 4964),
('Nevada', 'M', 79, 3382, 4491),
('Nevada', 'M', 80, 3017, 4165),
('Nevada', 'M', 81, 2372, 3816),
('Nevada', 'M', 82, 2109, 3287),
('Nevada', 'M', 83, 1786, 3177),
('Nevada', 'M', 84, 1516, 2629),
('Nevada', 'M', 85, 5789, 12644),
('Nevada', 'F', 0, 14403, 19665),
('Nevada', 'F', 1, 14235, 19786),
('Nevada', 'F', 2, 14076, 19605),
('Nevada', 'F', 3, 14443, 18988),
('Nevada', 'F', 4, 14502, 18886),
('Nevada', 'F', 5, 14592, 18345),
('Nevada', 'F', 6, 14473, 18501),
('Nevada', 'F', 7, 14566, 17959),
('Nevada', 'F', 8, 14811, 17255),
('Nevada', 'F', 9, 14685, 17188),
('Nevada', 'F', 10, 14952, 16943),
('Nevada', 'F', 11, 13928, 17404),
('Nevada', 'F', 12, 13353, 17395),
('Nevada', 'F', 13, 13127, 17467),
('Nevada', 'F', 14, 13053, 17279),
('Nevada', 'F', 15, 12870, 17330),
('Nevada', 'F', 16, 12439, 17566),
('Nevada', 'F', 17, 12310, 17225),
('Nevada', 'F', 18, 12128, 15235),
('Nevada', 'F', 19, 11911, 12268),
('Nevada', 'F', 20, 12213, 11886),
('Nevada', 'F', 21, 12031, 13037),
('Nevada', 'F', 22, 12444, 14683),
('Nevada', 'F', 23, 12774, 16433),
('Nevada', 'F', 24, 12830, 17134),
('Nevada', 'F', 25, 13419, 17406),
('Nevada', 'F', 26, 13374, 17789),
('Nevada', 'F', 27, 13865, 19412),
('Nevada', 'F', 28, 14802, 20564),
('Nevada', 'F', 29, 15936, 19458),
('Nevada', 'F', 30, 15972, 18966),
('Nevada', 'F', 31, 15127, 17581),
('Nevada', 'F', 32, 14859, 17499),
('Nevada', 'F', 33, 14550, 17544),
('Nevada', 'F', 34, 14789, 17490),
('Nevada', 'F', 35, 15721, 17444),
('Nevada', 'F', 36, 16119, 18484),
('Nevada', 'F', 37, 15601, 19252),
('Nevada', 'F', 38, 15736, 18972),
('Nevada', 'F', 39, 15890, 18093),
('Nevada', 'F', 40, 15804, 17417),
('Nevada', 'F', 41, 15052, 17206),
('Nevada', 'F', 42, 15292, 17531),
('Nevada', 'F', 43, 15215, 18351),
('Nevada', 'F', 44, 14726, 18805),
('Nevada', 'F', 45, 15001, 18180),
('Nevada', 'F', 46, 14553, 18275),
('Nevada', 'F', 47, 13840, 18580),
('Nevada', 'F', 48, 13332, 18275),
('Nevada', 'F', 49, 13225, 17435),
('Nevada', 'F', 50, 13564, 17759),
('Nevada', 'F', 51, 13238, 17664),
('Nevada', 'F', 52, 13498, 17161),
('Nevada', 'F', 53, 14238, 17314),
('Nevada', 'F', 54, 10915, 16874),
('Nevada', 'F', 55, 11092, 16183),
('Nevada', 'F', 56, 11064, 15797),
('Nevada', 'F', 57, 11522, 15603),
('Nevada', 'F', 58, 9989, 15921),
('Nevada', 'F', 59, 9593, 15522),
('Nevada', 'F', 60, 9357, 15894),
('Nevada', 'F', 61, 8648, 15801),
('Nevada', 'F', 62, 8567, 12475),
('Nevada', 'F', 63, 8094, 12462),
('Nevada', 'F', 64, 7872, 12082),
('Nevada', 'F', 65, 7927, 12490),
('Nevada', 'F', 66, 7188, 10409),
('Nevada', 'F', 67, 7058, 9830),
('Nevada', 'F', 68, 6735, 9380),
('Nevada', 'F', 69, 6877, 8609),
('Nevada', 'F', 70, 6913, 8248),
('Nevada', 'F', 71, 6181, 7590),
('Nevada', 'F', 72, 6379, 7285),
('Nevada', 'F', 73, 6002, 7137),
('Nevada', 'F', 74, 5900, 6526),
('Nevada', 'F', 75, 5671, 6383),
('Nevada', 'F', 76, 5295, 5782),
('Nevada', 'F', 77, 4881, 5908),
('Nevada', 'F', 78, 4584, 5844),
('Nevada', 'F', 79, 4124, 5125),
('Nevada', 'F', 80, 3810, 5122),
('Nevada', 'F', 81, 3218, 4673),
('Nevada', 'F', 82, 3034, 4337),
('Nevada', 'F', 83, 2586, 4114),
('Nevada', 'F', 84, 2341, 3750),
('Nevada', 'F', 85, 11557, 19286),
('New Hampshire', 'M', 0, 7302, 7491),
('New Hampshire', 'M', 1, 7665, 7450),
('New Hampshire', 'M', 2, 7703, 7905),
('New Hampshire', 'M', 3, 8112, 8021),
('New Hampshire', 'M', 4, 8278, 7542),
('New Hampshire', 'M', 5, 8668, 7627),
('New Hampshire', 'M', 6, 8680, 7917),
('New Hampshire', 'M', 7, 9049, 7992),
('New Hampshire', 'M', 8, 9174, 7776),
('New Hampshire', 'M', 9, 9653, 8154),
('New Hampshire', 'M', 10, 9912, 8096),
('New Hampshire', 'M', 11, 9533, 8579),
('New Hampshire', 'M', 12, 9544, 8680),
('New Hampshire', 'M', 13, 9352, 9068),
('New Hampshire', 'M', 14, 9399, 9079),
('New Hampshire', 'M', 15, 9273, 9446),
('New Hampshire', 'M', 16, 8813, 9480),
('New Hampshire', 'M', 17, 8881, 9803),
('New Hampshire', 'M', 18, 8812, 9518),
('New Hampshire', 'M', 19, 8539, 8778),
('New Hampshire', 'M', 20, 7752, 8802),
('New Hampshire', 'M', 21, 7459, 8873),
('New Hampshire', 'M', 22, 6923, 8654),
('New Hampshire', 'M', 23, 6256, 8029),
('New Hampshire', 'M', 24, 5938, 7455),
('New Hampshire', 'M', 25, 6365, 7482),
('New Hampshire', 'M', 26, 6428, 7895),
('New Hampshire', 'M', 27, 6675, 8636),
('New Hampshire', 'M', 28, 7423, 7807),
('New Hampshire', 'M', 29, 8150, 7228),
('New Hampshire', 'M', 30, 8529, 6971),
('New Hampshire', 'M', 31, 8499, 7296),
('New Hampshire', 'M', 32, 8592, 6974),
('New Hampshire', 'M', 33, 8971, 7922),
('New Hampshire', 'M', 34, 9305, 7350),
('New Hampshire', 'M', 35, 10164, 7890),
('New Hampshire', 'M', 36, 10464, 8461),
('New Hampshire', 'M', 37, 10783, 9338),
('New Hampshire', 'M', 38, 10819, 9593),
('New Hampshire', 'M', 39, 11414, 9383),
('New Hampshire', 'M', 40, 11448, 9392),
('New Hampshire', 'M', 41, 11412, 9639),
('New Hampshire', 'M', 42, 11283, 9996),
('New Hampshire', 'M', 43, 11075, 10901),
('New Hampshire', 'M', 44, 10639, 11110),
('New Hampshire', 'M', 45, 10502, 11332),
('New Hampshire', 'M', 46, 10120, 11306),
('New Hampshire', 'M', 47, 9972, 11777),
('New Hampshire', 'M', 48, 9542, 11791),
('New Hampshire', 'M', 49, 9133, 11563),
('New Hampshire', 'M', 50, 9113, 11379),
('New Hampshire', 'M', 51, 9019, 11173),
('New Hampshire', 'M', 52, 9018, 10636),
('New Hampshire', 'M', 53, 9661, 10501),
('New Hampshire', 'M', 54, 6578, 9861),
('New Hampshire', 'M', 55, 6633, 9789),
('New Hampshire', 'M', 56, 6839, 9280),
('New Hampshire', 'M', 57, 6861, 8825),
('New Hampshire', 'M', 58, 5955, 8848),
('New Hampshire', 'M', 59, 5350, 8619),
('New Hampshire', 'M', 60, 5116, 8577),
('New Hampshire', 'M', 61, 4755, 9242),
('New Hampshire', 'M', 62, 4660, 6153),
('New Hampshire', 'M', 63, 4384, 6162),
('New Hampshire', 'M', 64, 4273, 6303),
('New Hampshire', 'M', 65, 4294, 6256),
('New Hampshire', 'M', 66, 4062, 5237),
('New Hampshire', 'M', 67, 3863, 4614),
('New Hampshire', 'M', 68, 3919, 4376),
('New Hampshire', 'M', 69, 3713, 4116),
('New Hampshire', 'M', 70, 3752, 3945),
('New Hampshire', 'M', 71, 3503, 3639),
('New Hampshire', 'M', 72, 3305, 3460),
('New Hampshire', 'M', 73, 3194, 3403),
('New Hampshire', 'M', 74, 3010, 3252),
('New Hampshire', 'M', 75, 2954, 3015),
('New Hampshire', 'M', 76, 2671, 2970),
('New Hampshire', 'M', 77, 2557, 2714),
('New Hampshire', 'M', 78, 2394, 2751),
('New Hampshire', 'M', 79, 2245, 2504),
('New Hampshire', 'M', 80, 1980, 2263),
('New Hampshire', 'M', 81, 1795, 2088),
('New Hampshire', 'M', 82, 1527, 1819),
('New Hampshire', 'M', 83, 1334, 1801),
('New Hampshire', 'M', 84, 1219, 1514),
('New Hampshire', 'M', 85, 5137, 7617),
('New Hampshire', 'F', 0, 6860, 7119),
('New Hampshire', 'F', 1, 7124, 7090),
('New Hampshire', 'F', 2, 7431, 7568),
('New Hampshire', 'F', 3, 7507, 7658),
('New Hampshire', 'F', 4, 7821, 7453),
('New Hampshire', 'F', 5, 8084, 7358),
('New Hampshire', 'F', 6, 8228, 7480),
('New Hampshire', 'F', 7, 8543, 7696),
('New Hampshire', 'F', 8, 8928, 7415),
('New Hampshire', 'F', 9, 9294, 7613),
('New Hampshire', 'F', 10, 9369, 7973),
('New Hampshire', 'F', 11, 9312, 8014),
('New Hampshire', 'F', 12, 9263, 8306),
('New Hampshire', 'F', 13, 8973, 8491),
('New Hampshire', 'F', 14, 9067, 8613),
('New Hampshire', 'F', 15, 8668, 8852),
('New Hampshire', 'F', 16, 8356, 9160),
('New Hampshire', 'F', 17, 8423, 9393),
('New Hampshire', 'F', 18, 8503, 9071),
('New Hampshire', 'F', 19, 8834, 9063),
('New Hampshire', 'F', 20, 8217, 9063),
('New Hampshire', 'F', 21, 7722, 8628),
('New Hampshire', 'F', 22, 6769, 8384),
('New Hampshire', 'F', 23, 6021, 7396),
('New Hampshire', 'F', 24, 5971, 7082),
('New Hampshire', 'F', 25, 6450, 7596),
('New Hampshire', 'F', 26, 6365, 7241),
('New Hampshire', 'F', 27, 6985, 8581),
('New Hampshire', 'F', 28, 7575, 7372),
('New Hampshire', 'F', 29, 8323, 7710),
('New Hampshire', 'F', 30, 8682, 6905),
('New Hampshire', 'F', 31, 8677, 7169),
('New Hampshire', 'F', 32, 8618, 7237),
('New Hampshire', 'F', 33, 9157, 7549),
('New Hampshire', 'F', 34, 9632, 7356),
('New Hampshire', 'F', 35, 10474, 8438),
('New Hampshire', 'F', 36, 11036, 8822),
('New Hampshire', 'F', 37, 11190, 9628),
('New Hampshire', 'F', 38, 11171, 9844),
('New Hampshire', 'F', 39, 11698, 9531),
('New Hampshire', 'F', 40, 11597, 9431),
('New Hampshire', 'F', 41, 11419, 9796),
('New Hampshire', 'F', 42, 11312, 10407),
('New Hampshire', 'F', 43, 11231, 11046),
('New Hampshire', 'F', 44, 10496, 11391),
('New Hampshire', 'F', 45, 10592, 11521),
('New Hampshire', 'F', 46, 10303, 11323),
('New Hampshire', 'F', 47, 10000, 12011),
('New Hampshire', 'F', 48, 9608, 11728),
('New Hampshire', 'F', 49, 9112, 11491),
('New Hampshire', 'F', 50, 9068, 11356),
('New Hampshire', 'F', 51, 9058, 11071),
('New Hampshire', 'F', 52, 9151, 10400),
('New Hampshire', 'F', 53, 9553, 10342),
('New Hampshire', 'F', 54, 6655, 10214),
('New Hampshire', 'F', 55, 6640, 9823),
('New Hampshire', 'F', 56, 6584, 9439),
('New Hampshire', 'F', 57, 6981, 9068),
('New Hampshire', 'F', 58, 6021, 8842),
('New Hampshire', 'F', 59, 5319, 8820),
('New Hampshire', 'F', 60, 5252, 8933),
('New Hampshire', 'F', 61, 4876, 9281),
('New Hampshire', 'F', 62, 4777, 6522),
('New Hampshire', 'F', 63, 4576, 6404),
('New Hampshire', 'F', 64, 4652, 6381),
('New Hampshire', 'F', 65, 4556, 6530),
('New Hampshire', 'F', 66, 4134, 5684),
('New Hampshire', 'F', 67, 4240, 4971),
('New Hampshire', 'F', 68, 4232, 4794),
('New Hampshire', 'F', 69, 4131, 4517),
('New Hampshire', 'F', 70, 4338, 4387),
('New Hampshire', 'F', 71, 4005, 4144),
('New Hampshire', 'F', 72, 4097, 4166),
('New Hampshire', 'F', 73, 4145, 4106),
('New Hampshire', 'F', 74, 3878, 3593),
('New Hampshire', 'F', 75, 3957, 3722),
('New Hampshire', 'F', 76, 3558, 3652),
('New Hampshire', 'F', 77, 3549, 3482),
('New Hampshire', 'F', 78, 3433, 3664),
('New Hampshire', 'F', 79, 3400, 3269),
('New Hampshire', 'F', 80, 3088, 3292),
('New Hampshire', 'F', 81, 2801, 3277),
('New Hampshire', 'F', 82, 2663, 2973),
('New Hampshire', 'F', 83, 2379, 2990),
('New Hampshire', 'F', 84, 2237, 2548),
('New Hampshire', 'F', 85, 13312, 16863),
('New Jersey', 'M', 0, 56983, 58756),
('New Jersey', 'M', 1, 56686, 57325),
('New Jersey', 'M', 2, 57011, 55475),
('New Jersey', 'M', 3, 57912, 56059),
('New Jersey', 'M', 4, 59359, 58048),
('New Jersey', 'M', 5, 60392, 58472),
('New Jersey', 'M', 6, 60739, 57080),
('New Jersey', 'M', 7, 61579, 56754),
('New Jersey', 'M', 8, 62089, 56616),
('New Jersey', 'M', 9, 63384, 56322),
('New Jersey', 'M', 10, 64593, 56617),
('New Jersey', 'M', 11, 62494, 57482),
('New Jersey', 'M', 12, 60570, 58834),
('New Jersey', 'M', 13, 58189, 59925),
('New Jersey', 'M', 14, 57931, 60294),
('New Jersey', 'M', 15, 56752, 61056),
('New Jersey', 'M', 16, 55887, 61478),
('New Jersey', 'M', 17, 56712, 62450),
('New Jersey', 'M', 18, 53265, 62809),
('New Jersey', 'M', 19, 48344, 55700),
('New Jersey', 'M', 20, 49564, 55794),
('New Jersey', 'M', 21, 48141, 54769),
('New Jersey', 'M', 22, 48353, 55026),
('New Jersey', 'M', 23, 49130, 54730),
('New Jersey', 'M', 24, 48723, 53471),
('New Jersey', 'M', 25, 51092, 56073),
('New Jersey', 'M', 26, 50357, 55169),
('New Jersey', 'M', 27, 52179, 51964),
('New Jersey', 'M', 28, 55938, 52358),
('New Jersey', 'M', 29, 60638, 51467),
('New Jersey', 'M', 30, 64220, 52596),
('New Jersey', 'M', 31, 61484, 54346),
('New Jersey', 'M', 32, 61927, 54414),
('New Jersey', 'M', 33, 63487, 56786),
('New Jersey', 'M', 34, 66737, 56190),
('New Jersey', 'M', 35, 71274, 56869),
('New Jersey', 'M', 36, 71449, 60652),
('New Jersey', 'M', 37, 71026, 64156),
('New Jersey', 'M', 38, 71811, 67107),
('New Jersey', 'M', 39, 72043, 63562),
('New Jersey', 'M', 40, 73665, 63306),
('New Jersey', 'M', 41, 70514, 64273),
('New Jersey', 'M', 42, 69835, 67210),
('New Jersey', 'M', 43, 68650, 71249),
('New Jersey', 'M', 44, 65564, 71097),
('New Jersey', 'M', 45, 65529, 69934),
('New Jersey', 'M', 46, 61817, 70961),
('New Jersey', 'M', 47, 59206, 70886),
('New Jersey', 'M', 48, 56977, 71595),
('New Jersey', 'M', 49, 55780, 68022),
('New Jersey', 'M', 50, 56235, 67401),
('New Jersey', 'M', 51, 53235, 65757),
('New Jersey', 'M', 52, 54900, 62616),
('New Jersey', 'M', 53, 58013, 62490),
('New Jersey', 'M', 54, 43584, 58355),
('New Jersey', 'M', 55, 42959, 55466),
('New Jersey', 'M', 56, 42179, 53088),
('New Jersey', 'M', 57, 45575, 51211),
('New Jersey', 'M', 58, 38376, 51039),
('New Jersey', 'M', 59, 34722, 47299),
('New Jersey', 'M', 60, 34278, 48085),
('New Jersey', 'M', 61, 32730, 51579),
('New Jersey', 'M', 62, 31589, 37378),
('New Jersey', 'M', 63, 29440, 36620),
('New Jersey', 'M', 64, 28747, 34605),
('New Jersey', 'M', 65, 27751, 38210),
('New Jersey', 'M', 66, 26129, 32006),
('New Jersey', 'M', 67, 26479, 28279),
('New Jersey', 'M', 68, 26076, 27635),
('New Jersey', 'M', 69, 25811, 26304),
('New Jersey', 'M', 70, 26370, 25459),
('New Jersey', 'M', 71, 24801, 23197),
('New Jersey', 'M', 72, 24358, 22627),
('New Jersey', 'M', 73, 23724, 21789),
('New Jersey', 'M', 74, 22304, 19294),
('New Jersey', 'M', 75, 21663, 19267),
('New Jersey', 'M', 76, 20280, 18629),
('New Jersey', 'M', 77, 18958, 17897),
('New Jersey', 'M', 78, 17839, 17860),
('New Jersey', 'M', 79, 17030, 16034),
('New Jersey', 'M', 80, 15262, 15261),
('New Jersey', 'M', 81, 12609, 14193),
('New Jersey', 'M', 82, 12104, 12912),
('New Jersey', 'M', 83, 10004, 12085),
('New Jersey', 'M', 84, 8864, 10759),
('New Jersey', 'M', 85, 39309, 54920),
('New Jersey', 'F', 0, 54679, 55841),
('New Jersey', 'F', 1, 53913, 54437),
('New Jersey', 'F', 2, 54744, 52450),
('New Jersey', 'F', 3, 55427, 53490),
('New Jersey', 'F', 4, 56860, 55540),
('New Jersey', 'F', 5, 57486, 55247),
('New Jersey', 'F', 6, 57751, 54660),
('New Jersey', 'F', 7, 58696, 53617),
('New Jersey', 'F', 8, 59465, 54257),
('New Jersey', 'F', 9, 60277, 53421),
('New Jersey', 'F', 10, 61606, 54270),
('New Jersey', 'F', 11, 59279, 54850),
('New Jersey', 'F', 12, 57384, 56348),
('New Jersey', 'F', 13, 55913, 56884),
('New Jersey', 'F', 14, 54804, 57080),
('New Jersey', 'F', 15, 54208, 58022),
('New Jersey', 'F', 16, 52815, 58825),
('New Jersey', 'F', 17, 52918, 59284),
('New Jersey', 'F', 18, 48383, 58217),
('New Jersey', 'F', 19, 45910, 51872),
('New Jersey', 'F', 20, 47658, 52726),
('New Jersey', 'F', 21, 46601, 54512),
('New Jersey', 'F', 22, 46518, 52223),
('New Jersey', 'F', 23, 47909, 52601),
('New Jersey', 'F', 24, 47751, 51185),
('New Jersey', 'F', 25, 49805, 53116),
('New Jersey', 'F', 26, 50344, 51334),
('New Jersey', 'F', 27, 52524, 48697),
('New Jersey', 'F', 28, 56102, 52359),
('New Jersey', 'F', 29, 61685, 47013),
('New Jersey', 'F', 30, 64873, 51329),
('New Jersey', 'F', 31, 62665, 53082),
('New Jersey', 'F', 32, 63572, 53301),
('New Jersey', 'F', 33, 65517, 54789),
('New Jersey', 'F', 34, 68457, 56177),
('New Jersey', 'F', 35, 72558, 57404),
('New Jersey', 'F', 36, 73865, 59897),
('New Jersey', 'F', 37, 73266, 64997),
('New Jersey', 'F', 38, 72927, 67366),
('New Jersey', 'F', 39, 73816, 64546),
('New Jersey', 'F', 40, 75226, 64632),
('New Jersey', 'F', 41, 73159, 66421),
('New Jersey', 'F', 42, 72371, 68732),
('New Jersey', 'F', 43, 71100, 72619),
('New Jersey', 'F', 44, 68286, 73252),
('New Jersey', 'F', 45, 67763, 72477),
('New Jersey', 'F', 46, 64313, 71522),
('New Jersey', 'F', 47, 62759, 72520),
('New Jersey', 'F', 48, 60526, 73425),
('New Jersey', 'F', 49, 59877, 71188),
('New Jersey', 'F', 50, 60058, 69825),
('New Jersey', 'F', 51, 57978, 68238),
('New Jersey', 'F', 52, 58637, 65557),
('New Jersey', 'F', 53, 62757, 64292),
('New Jersey', 'F', 54, 47727, 60739),
('New Jersey', 'F', 55, 45851, 58823),
('New Jersey', 'F', 56, 45758, 56115),
('New Jersey', 'F', 57, 49139, 55014),
('New Jersey', 'F', 58, 42678, 55051),
('New Jersey', 'F', 59, 38667, 52644),
('New Jersey', 'F', 60, 38032, 52050),
('New Jersey', 'F', 61, 35600, 57253),
('New Jersey', 'F', 62, 35577, 42643),
('New Jersey', 'F', 63, 33562, 40568),
('New Jersey', 'F', 64, 32452, 39824),
('New Jersey', 'F', 65, 32848, 43182),
('New Jersey', 'F', 66, 31080, 37439),
('New Jersey', 'F', 67, 31588, 33677),
('New Jersey', 'F', 68, 32232, 33216),
('New Jersey', 'F', 69, 32391, 31084),
('New Jersey', 'F', 70, 33124, 30891),
('New Jersey', 'F', 71, 31678, 28959),
('New Jersey', 'F', 72, 32246, 28018),
('New Jersey', 'F', 73, 31706, 27975),
('New Jersey', 'F', 74, 30619, 25920),
('New Jersey', 'F', 75, 31196, 25888),
('New Jersey', 'F', 76, 30070, 25957),
('New Jersey', 'F', 77, 28748, 25597),
('New Jersey', 'F', 78, 27658, 25598),
('New Jersey', 'F', 79, 27035, 23913),
('New Jersey', 'F', 80, 25439, 23803),
('New Jersey', 'F', 81, 21730, 22789),
('New Jersey', 'F', 82, 21220, 21318),
('New Jersey', 'F', 83, 19121, 21073),
('New Jersey', 'F', 84, 17164, 19637),
('New Jersey', 'F', 85, 98078, 120390),
('New Mexico', 'M', 0, 13560, 15655),
('New Mexico', 'M', 1, 13293, 15614),
('New Mexico', 'M', 2, 13001, 15032),
('New Mexico', 'M', 3, 12904, 14989),
('New Mexico', 'M', 4, 13332, 14495),
('New Mexico', 'M', 5, 13642, 14361),
('New Mexico', 'M', 6, 13910, 14156),
('New Mexico', 'M', 7, 14408, 13904),
('New Mexico', 'M', 8, 14551, 13560),
('New Mexico', 'M', 9, 14866, 13331),
('New Mexico', 'M', 10, 15259, 13078),
('New Mexico', 'M', 11, 14874, 13002),
('New Mexico', 'M', 12, 14927, 13356),
('New Mexico', 'M', 13, 15239, 13682),
('New Mexico', 'M', 14, 15089, 13811),
('New Mexico', 'M', 15, 15310, 14338),
('New Mexico', 'M', 16, 15222, 14451),
('New Mexico', 'M', 17, 15232, 14747),
('New Mexico', 'M', 18, 14493, 15210),
('New Mexico', 'M', 19, 13774, 14673),
('New Mexico', 'M', 20, 13160, 14398),
('New Mexico', 'M', 21, 12122, 14415),
('New Mexico', 'M', 22, 11588, 14066),
('New Mexico', 'M', 23, 11512, 14640),
('New Mexico', 'M', 24, 10832, 14597),
('New Mexico', 'M', 25, 10935, 15096),
('New Mexico', 'M', 26, 10919, 14363),
('New Mexico', 'M', 27, 10875, 15127),
('New Mexico', 'M', 28, 11239, 14480),
('New Mexico', 'M', 29, 11713, 13321),
('New Mexico', 'M', 30, 12146, 13185),
('New Mexico', 'M', 31, 11498, 12827),
('New Mexico', 'M', 32, 11102, 12076),
('New Mexico', 'M', 33, 11194, 11483),
('New Mexico', 'M', 34, 11586, 12186),
('New Mexico', 'M', 35, 12861, 11443),
('New Mexico', 'M', 36, 13156, 11874),
('New Mexico', 'M', 37, 13594, 12182),
('New Mexico', 'M', 38, 13760, 12472),
('New Mexico', 'M', 39, 13842, 11955),
('New Mexico', 'M', 40, 14187, 11387),
('New Mexico', 'M', 41, 13760, 11780),
('New Mexico', 'M', 42, 13725, 11905),
('New Mexico', 'M', 43, 13844, 13147),
('New Mexico', 'M', 44, 13183, 13172),
('New Mexico', 'M', 45, 13446, 13739),
('New Mexico', 'M', 46, 12976, 13626),
('New Mexico', 'M', 47, 12673, 13534),
('New Mexico', 'M', 48, 12224, 14076),
('New Mexico', 'M', 49, 12342, 13555),
('New Mexico', 'M', 50, 12443, 13402),
('New Mexico', 'M', 51, 11814, 13623),
('New Mexico', 'M', 52, 11420, 12904),
('New Mexico', 'M', 53, 11886, 12925),
('New Mexico', 'M', 54, 8960, 12455),
('New Mexico', 'M', 55, 9087, 12563),
('New Mexico', 'M', 56, 8689, 11736),
('New Mexico', 'M', 57, 8960, 11884),
('New Mexico', 'M', 58, 7859, 12140),
('New Mexico', 'M', 59, 7497, 11430),
('New Mexico', 'M', 60, 7384, 11104),
('New Mexico', 'M', 61, 7020, 11657),
('New Mexico', 'M', 62, 6897, 8675),
('New Mexico', 'M', 63, 6594, 8710),
('New Mexico', 'M', 64, 6424, 8179),
('New Mexico', 'M', 65, 6533, 8606),
('New Mexico', 'M', 66, 6072, 7295),
('New Mexico', 'M', 67, 5962, 6988),
('New Mexico', 'M', 68, 5935, 6844),
('New Mexico', 'M', 69, 5648, 6329),
('New Mexico', 'M', 70, 5788, 6244),
('New Mexico', 'M', 71, 5199, 5788),
('New Mexico', 'M', 72, 4988, 5589),
('New Mexico', 'M', 73, 4745, 5530),
('New Mexico', 'M', 74, 4477, 5121),
('New Mexico', 'M', 75, 4299, 4934),
('New Mexico', 'M', 76, 4142, 4855),
('New Mexico', 'M', 77, 3787, 4391),
('New Mexico', 'M', 78, 3622, 4453),
('New Mexico', 'M', 79, 3310, 3929),
('New Mexico', 'M', 80, 2985, 3692),
('New Mexico', 'M', 81, 2460, 3438),
('New Mexico', 'M', 82, 2271, 3025),
('New Mexico', 'M', 83, 1990, 2842),
('New Mexico', 'M', 84, 1788, 2625),
('New Mexico', 'M', 85, 7749, 13095),
('New Mexico', 'F', 0, 13171, 14776),
('New Mexico', 'F', 1, 12869, 14605),
('New Mexico', 'F', 2, 12623, 14357),
('New Mexico', 'F', 3, 12671, 14575),
('New Mexico', 'F', 4, 13016, 14225),
('New Mexico', 'F', 5, 13130, 14095),
('New Mexico', 'F', 6, 13466, 13939),
('New Mexico', 'F', 7, 13759, 13480),
('New Mexico', 'F', 8, 14102, 13148),
('New Mexico', 'F', 9, 14538, 12875),
('New Mexico', 'F', 10, 14699, 12614),
('New Mexico', 'F', 11, 14425, 12630),
('New Mexico', 'F', 12, 14233, 13006),
('New Mexico', 'F', 13, 14410, 13109),
('New Mexico', 'F', 14, 14445, 13390),
('New Mexico', 'F', 15, 14602, 13669),
('New Mexico', 'F', 16, 14325, 13974),
('New Mexico', 'F', 17, 14426, 14421),
('New Mexico', 'F', 18, 14001, 14533),
('New Mexico', 'F', 19, 13382, 14195),
('New Mexico', 'F', 20, 13136, 14052),
('New Mexico', 'F', 21, 12074, 13484),
('New Mexico', 'F', 22, 11672, 14067),
('New Mexico', 'F', 23, 11355, 14292),
('New Mexico', 'F', 24, 11186, 13715),
('New Mexico', 'F', 25, 11179, 13888),
('New Mexico', 'F', 26, 10982, 14224),
('New Mexico', 'F', 27, 11166, 14682),
('New Mexico', 'F', 28, 11677, 13200),
('New Mexico', 'F', 29, 12066, 13738),
('New Mexico', 'F', 30, 12322, 12732),
('New Mexico', 'F', 31, 11723, 11946),
('New Mexico', 'F', 32, 11448, 11989),
('New Mexico', 'F', 33, 11619, 11898),
('New Mexico', 'F', 34, 12163, 11425),
('New Mexico', 'F', 35, 13475, 11912),
('New Mexico', 'F', 36, 13636, 12522),
('New Mexico', 'F', 37, 14283, 12691),
('New Mexico', 'F', 38, 14312, 12719),
('New Mexico', 'F', 39, 14744, 12003),
('New Mexico', 'F', 40, 14956, 11865),
('New Mexico', 'F', 41, 14320, 11980),
('New Mexico', 'F', 42, 14450, 12600),
('New Mexico', 'F', 43, 14488, 13852),
('New Mexico', 'F', 44, 13943, 13790),
('New Mexico', 'F', 45, 14157, 14080),
('New Mexico', 'F', 46, 13692, 14464),
('New Mexico', 'F', 47, 13575, 14637),
('New Mexico', 'F', 48, 13297, 15405),
('New Mexico', 'F', 49, 12740, 14380),
('New Mexico', 'F', 50, 12677, 14251),
('New Mexico', 'F', 51, 12302, 14377),
('New Mexico', 'F', 52, 12032, 13993),
('New Mexico', 'F', 53, 12565, 14199),
('New Mexico', 'F', 54, 9425, 13702),
('New Mexico', 'F', 55, 9651, 13459),
('New Mexico', 'F', 56, 9450, 13011),
('New Mexico', 'F', 57, 9428, 12507),
('New Mexico', 'F', 58, 8747, 12614),
('New Mexico', 'F', 59, 8054, 12279),
('New Mexico', 'F', 60, 8007, 11807),
('New Mexico', 'F', 61, 7732, 12196),
('New Mexico', 'F', 62, 7532, 9223),
('New Mexico', 'F', 63, 7263, 9360),
('New Mexico', 'F', 64, 6875, 9177),
('New Mexico', 'F', 65, 7143, 9145),
('New Mexico', 'F', 66, 6471, 8494),
('New Mexico', 'F', 67, 6489, 7778),
('New Mexico', 'F', 68, 6686, 7694),
('New Mexico', 'F', 69, 6332, 7352),
('New Mexico', 'F', 70, 6330, 7066),
('New Mexico', 'F', 71, 5877, 6789),
('New Mexico', 'F', 72, 5974, 6351),
('New Mexico', 'F', 73, 5739, 6521),
('New Mexico', 'F', 74, 5549, 5817),
('New Mexico', 'F', 75, 5568, 5640),
('New Mexico', 'F', 76, 5243, 5874),
('New Mexico', 'F', 77, 4758, 5419),
('New Mexico', 'F', 78, 4849, 5361),
('New Mexico', 'F', 79, 4407, 4892),
('New Mexico', 'F', 80, 3942, 4843),
('New Mexico', 'F', 81, 3421, 4502),
('New Mexico', 'F', 82, 3247, 4204),
('New Mexico', 'F', 83, 2946, 4225),
('New Mexico', 'F', 84, 2732, 3717),
('New Mexico', 'F', 85, 15879, 22754),
('New York', 'M', 0, 126237, 128088),
('New York', 'M', 1, 124008, 125649),
('New York', 'M', 2, 124725, 121615),
('New York', 'M', 3, 126697, 120580),
('New York', 'M', 4, 131357, 122482),
('New York', 'M', 5, 133095, 121205),
('New York', 'M', 6, 134203, 120089),
('New York', 'M', 7, 137986, 122355),
('New York', 'M', 8, 139455, 118653),
('New York', 'M', 9, 142454, 117369),
('New York', 'M', 10, 145621, 118810),
('New York', 'M', 11, 138746, 121121),
('New York', 'M', 12, 135565, 126338),
('New York', 'M', 13, 132288, 128713),
('New York', 'M', 14, 132388, 129812),
('New York', 'M', 15, 131959, 134463),
('New York', 'M', 16, 130189, 136569),
('New York', 'M', 17, 132566, 140114),
('New York', 'M', 18, 132672, 156892),
('New York', 'M', 19, 133654, 147556),
('New York', 'M', 20, 132121, 146611),
('New York', 'M', 21, 126166, 141932),
('New York', 'M', 22, 123215, 138557),
('New York', 'M', 23, 121282, 136150),
('New York', 'M', 24, 118953, 132383),
('New York', 'M', 25, 123151, 141850),
('New York', 'M', 26, 118727, 129603),
('New York', 'M', 27, 122359, 131419),
('New York', 'M', 28, 128651, 127224),
('New York', 'M', 29, 140687, 122449),
('New York', 'M', 30, 149558, 126404),
('New York', 'M', 31, 139477, 126124),
('New York', 'M', 32, 138911, 123362),
('New York', 'M', 33, 139031, 126486),
('New York', 'M', 34, 145440, 120030),
('New York', 'M', 35, 156168, 123017),
('New York', 'M', 36, 153840, 127076),
('New York', 'M', 37, 152078, 136270),
('New York', 'M', 38, 150765, 144715),
('New York', 'M', 39, 152606, 135027),
('New York', 'M', 40, 159345, 135355),
('New York', 'M', 41, 148628, 132905),
('New York', 'M', 42, 147892, 140025),
('New York', 'M', 43, 144195, 151555),
('New York', 'M', 44, 139354, 149030),
('New York', 'M', 45, 141953, 148147),
('New York', 'M', 46, 131875, 146692),
('New York', 'M', 47, 128767, 147648),
('New York', 'M', 48, 125406, 155155),
('New York', 'M', 49, 124155, 144287),
('New York', 'M', 50, 125955, 143466),
('New York', 'M', 51, 118542, 139630),
('New York', 'M', 52, 118532, 133939),
('New York', 'M', 53, 124418, 136723),
('New York', 'M', 54, 95025, 125953),
('New York', 'M', 55, 92652, 122478),
('New York', 'M', 56, 90096, 118070),
('New York', 'M', 57, 95340, 115823),
('New York', 'M', 58, 83273, 117177),
('New York', 'M', 59, 77213, 108293),
('New York', 'M', 60, 77054, 106825),
('New York', 'M', 61, 72212, 113681),
('New York', 'M', 62, 70967, 83763),
('New York', 'M', 63, 66461, 81226),
('New York', 'M', 64, 64361, 76961),
('New York', 'M', 65, 64385, 82242),
('New York', 'M', 66, 58819, 70423),
('New York', 'M', 67, 58176, 64117),
('New York', 'M', 68, 57310, 63657),
('New York', 'M', 69, 57057, 58801),
('New York', 'M', 70, 57761, 57609),
('New York', 'M', 71, 53775, 53231),
('New York', 'M', 72, 53568, 51132),
('New York', 'M', 73, 51263, 50696),
('New York', 'M', 74, 48440, 44822),
('New York', 'M', 75, 46702, 43592),
('New York', 'M', 76, 43508, 41900),
('New York', 'M', 77, 40730, 40417),
('New York', 'M', 78, 37950, 40241),
('New York', 'M', 79, 35774, 35941),
('New York', 'M', 80, 32453, 34659),
('New York', 'M', 81, 26803, 32022),
('New York', 'M', 82, 25041, 28890),
('New York', 'M', 83, 21687, 27217),
('New York', 'M', 84, 18873, 23879),
('New York', 'M', 85, 88366, 124478),
('New York', 'F', 0, 120355, 122194),
('New York', 'F', 1, 118219, 119661),
('New York', 'F', 2, 119577, 116413),
('New York', 'F', 3, 121029, 114877),
('New York', 'F', 4, 125247, 116936),
('New York', 'F', 5, 128227, 116051),
('New York', 'F', 6, 128428, 115186),
('New York', 'F', 7, 131161, 116951),
('New York', 'F', 8, 133646, 113279),
('New York', 'F', 9, 135746, 111919),
('New York', 'F', 10, 138287, 113891),
('New York', 'F', 11, 131904, 115607),
('New York', 'F', 12, 129028, 120156),
('New York', 'F', 13, 126571, 123797),
('New York', 'F', 14, 125682, 124343),
('New York', 'F', 15, 125409, 127635),
('New York', 'F', 16, 122770, 130769),
('New York', 'F', 17, 123978, 134311),
('New York', 'F', 18, 125307, 150772),
('New York', 'F', 19, 127956, 142871),
('New York', 'F', 20, 129184, 141831),
('New York', 'F', 21, 124575, 142302),
('New York', 'F', 22, 123701, 138703),
('New York', 'F', 23, 124108, 138084),
('New York', 'F', 24, 122624, 135339),
('New York', 'F', 25, 127474, 141601),
('New York', 'F', 26, 123033, 130002),
('New York', 'F', 27, 128125, 129600),
('New York', 'F', 28, 134795, 129868),
('New York', 'F', 29, 146832, 119821),
('New York', 'F', 30, 152973, 125047),
('New York', 'F', 31, 144001, 127486),
('New York', 'F', 32, 143930, 123742),
('New York', 'F', 33, 144653, 126908),
('New York', 'F', 34, 151147, 121824),
('New York', 'F', 35, 159228, 124485),
('New York', 'F', 36, 159999, 130377),
('New York', 'F', 37, 157911, 140890),
('New York', 'F', 38, 156103, 148408),
('New York', 'F', 39, 159284, 137936),
('New York', 'F', 40, 163331, 138561),
('New York', 'F', 41, 155353, 139720),
('New York', 'F', 42, 153688, 145307),
('New York', 'F', 43, 151615, 154437),
('New York', 'F', 44, 146774, 154805),
('New York', 'F', 45, 148318, 153651),
('New York', 'F', 46, 139802, 151107),
('New York', 'F', 47, 138062, 154997),
('New York', 'F', 48, 134107, 158855),
('New York', 'F', 49, 134399, 151022),
('New York', 'F', 50, 136630, 149883),
('New York', 'F', 51, 130843, 146988),
('New York', 'F', 52, 130196, 142566),
('New York', 'F', 53, 136064, 144121),
('New York', 'F', 54, 106579, 135180),
('New York', 'F', 55, 104847, 132338),
('New York', 'F', 56, 101857, 127500),
('New York', 'F', 57, 108406, 126450),
('New York', 'F', 58, 94346, 128713),
('New York', 'F', 59, 88584, 121743),
('New York', 'F', 60, 88932, 119540),
('New York', 'F', 61, 82899, 126847),
('New York', 'F', 62, 82172, 96462),
('New York', 'F', 63, 77171, 94667),
('New York', 'F', 64, 76032, 90185),
('New York', 'F', 65, 76498, 97321),
('New York', 'F', 66, 70465, 83336),
('New York', 'F', 67, 71088, 77404),
('New York', 'F', 68, 70847, 77802),
('New York', 'F', 69, 71377, 71850),
('New York', 'F', 70, 74378, 71451),
('New York', 'F', 71, 70611, 66625),
('New York', 'F', 72, 70513, 65037),
('New York', 'F', 73, 69156, 65719),
('New York', 'F', 74, 68042, 58818),
('New York', 'F', 75, 68410, 58722),
('New York', 'F', 76, 64971, 57584),
('New York', 'F', 77, 61287, 56907),
('New York', 'F', 78, 58911, 58456),
('New York', 'F', 79, 56865, 54136),
('New York', 'F', 80, 54553, 52932),
('New York', 'F', 81, 46381, 50693),
('New York', 'F', 82, 45599, 48206),
('New York', 'F', 83, 40525, 47777),
('New York', 'F', 84, 37436, 43454),
('New York', 'F', 85, 226378, 273476),
('North Carolina', 'M', 0, 57058, 68632),
('North Carolina', 'M', 1, 55868, 69182),
('North Carolina', 'M', 2, 54967, 66195),
('North Carolina', 'M', 3, 53963, 65476),
('North Carolina', 'M', 4, 54652, 64198),
('North Carolina', 'M', 5, 55808, 64246),
('North Carolina', 'M', 6, 56048, 64453),
('North Carolina', 'M', 7, 57330, 66096),
('North Carolina', 'M', 8, 58531, 62662),
('North Carolina', 'M', 9, 59683, 61728),
('North Carolina', 'M', 10, 60087, 60929),
('North Carolina', 'M', 11, 57433, 60051),
('North Carolina', 'M', 12, 56057, 60632),
('North Carolina', 'M', 13, 54839, 61680),
('North Carolina', 'M', 14, 54175, 61644),
('North Carolina', 'M', 15, 54640, 62380),
('North Carolina', 'M', 16, 52467, 63186),
('North Carolina', 'M', 17, 53700, 64735),
('North Carolina', 'M', 18, 54928, 65129),
('North Carolina', 'M', 19, 55535, 60358),
('North Carolina', 'M', 20, 57099, 60045),
('North Carolina', 'M', 21, 54484, 59271),
('North Carolina', 'M', 22, 54154, 58611),
('North Carolina', 'M', 23, 53183, 58381),
('North Carolina', 'M', 24, 52431, 58793),
('North Carolina', 'M', 25, 55683, 59022),
('North Carolina', 'M', 26, 54777, 57489),
('North Carolina', 'M', 27, 56915, 57699),
('North Carolina', 'M', 28, 59678, 60502),
('North Carolina', 'M', 29, 63016, 57042),
('North Carolina', 'M', 30, 63768, 59001),
('North Carolina', 'M', 31, 59781, 58754),
('North Carolina', 'M', 32, 58489, 57683),
('North Carolina', 'M', 33, 57714, 60215),
('North Carolina', 'M', 34, 59018, 59691),
('North Carolina', 'M', 35, 62789, 62394),
('North Carolina', 'M', 36, 63820, 65222),
('North Carolina', 'M', 37, 63005, 68014),
('North Carolina', 'M', 38, 63348, 69066),
('North Carolina', 'M', 39, 63280, 64307),
('North Carolina', 'M', 40, 64351, 63117),
('North Carolina', 'M', 41, 61495, 62618),
('North Carolina', 'M', 42, 61873, 63887),
('North Carolina', 'M', 43, 61547, 67086),
('North Carolina', 'M', 44, 58850, 67602),
('North Carolina', 'M', 45, 59127, 67372),
('North Carolina', 'M', 46, 57555, 67338),
('North Carolina', 'M', 47, 55128, 66905),
('North Carolina', 'M', 48, 54231, 67298),
('North Carolina', 'M', 49, 52438, 64023),
('North Carolina', 'M', 50, 52916, 64717),
('North Carolina', 'M', 51, 51816, 64095),
('North Carolina', 'M', 52, 52155, 61380),
('North Carolina', 'M', 53, 54702, 60351),
('North Carolina', 'M', 54, 41289, 59072),
('North Carolina', 'M', 55, 40943, 56460),
('North Carolina', 'M', 56, 40548, 55733),
('North Carolina', 'M', 57, 41515, 53519),
('North Carolina', 'M', 58, 36465, 53628),
('North Carolina', 'M', 59, 34196, 52697),
('North Carolina', 'M', 60, 33214, 53053),
('North Carolina', 'M', 61, 31148, 54641),
('North Carolina', 'M', 62, 30594, 41203),
('North Carolina', 'M', 63, 29044, 40390),
('North Carolina', 'M', 64, 28976, 39965),
('North Carolina', 'M', 65, 28924, 40251),
('North Carolina', 'M', 66, 26095, 34251),
('North Carolina', 'M', 67, 25705, 31407),
('North Carolina', 'M', 68, 24586, 29845),
('North Carolina', 'M', 69, 23675, 27347),
('North Carolina', 'M', 70, 23750, 26431),
('North Carolina', 'M', 71, 22857, 24300),
('North Carolina', 'M', 72, 22025, 23557),
('North Carolina', 'M', 73, 20831, 23095),
('North Carolina', 'M', 74, 19331, 20242),
('North Carolina', 'M', 75, 18976, 19741),
('North Carolina', 'M', 76, 17326, 18328),
('North Carolina', 'M', 77, 15468, 17189),
('North Carolina', 'M', 78, 14830, 16857),
('North Carolina', 'M', 79, 13561, 15485),
('North Carolina', 'M', 80, 11830, 14546),
('North Carolina', 'M', 81, 9969, 13222),
('North Carolina', 'M', 82, 8901, 11735),
('North Carolina', 'M', 83, 7636, 11083),
('North Carolina', 'M', 84, 6614, 9746),
('North Carolina', 'M', 85, 27820, 45074),
('North Carolina', 'F', 0, 54957, 65616),
('North Carolina', 'F', 1, 52831, 65830),
('North Carolina', 'F', 2, 52043, 63424),
('North Carolina', 'F', 3, 51668, 62507),
('North Carolina', 'F', 4, 51947, 61763),
('North Carolina', 'F', 5, 52660, 60663),
('North Carolina', 'F', 6, 53368, 61529),
('North Carolina', 'F', 7, 54876, 63075),
('North Carolina', 'F', 8, 55428, 60433),
('North Carolina', 'F', 9, 56660, 58563),
('North Carolina', 'F', 10, 57831, 57776),
('North Carolina', 'F', 11, 55158, 57467),
('North Carolina', 'F', 12, 54108, 57649),
('North Carolina', 'F', 13, 52533, 58258),
('North Carolina', 'F', 14, 52009, 58652),
('North Carolina', 'F', 15, 51296, 60165),
('North Carolina', 'F', 16, 49397, 60459),
('North Carolina', 'F', 17, 50519, 61700),
('North Carolina', 'F', 18, 53287, 63462),
('North Carolina', 'F', 19, 56332, 59628),
('North Carolina', 'F', 20, 57113, 59337),
('North Carolina', 'F', 21, 55141, 58627),
('North Carolina', 'F', 22, 53973, 58312),
('North Carolina', 'F', 23, 53188, 57823),
('North Carolina', 'F', 24, 52287, 56712),
('North Carolina', 'F', 25, 55514, 59091),
('North Carolina', 'F', 26, 54548, 58117),
('North Carolina', 'F', 27, 56413, 63638),
('North Carolina', 'F', 28, 60061, 63388),
('North Carolina', 'F', 29, 63972, 62540),
('North Carolina', 'F', 30, 63782, 62040),
('North Carolina', 'F', 31, 59775, 61138),
('North Carolina', 'F', 32, 59039, 60399),
('North Carolina', 'F', 33, 59269, 62576),
('North Carolina', 'F', 34, 59811, 61255),
('North Carolina', 'F', 35, 64406, 63200),
('North Carolina', 'F', 36, 65817, 67146),
('North Carolina', 'F', 37, 65920, 70404),
('North Carolina', 'F', 38, 65281, 70141),
('North Carolina', 'F', 39, 65960, 65775),
('North Carolina', 'F', 40, 66558, 64198),
('North Carolina', 'F', 41, 64392, 65214),
('North Carolina', 'F', 42, 64513, 65442),
('North Carolina', 'F', 43, 64095, 69710),
('North Carolina', 'F', 44, 62106, 70689),
('North Carolina', 'F', 45, 61907, 70829),
('North Carolina', 'F', 46, 60702, 69570),
('North Carolina', 'F', 47, 58708, 70596),
('North Carolina', 'F', 48, 57602, 70745),
('North Carolina', 'F', 49, 55716, 67850),
('North Carolina', 'F', 50, 55772, 68321),
('North Carolina', 'F', 51, 54686, 67247),
('North Carolina', 'F', 52, 55187, 65778),
('North Carolina', 'F', 53, 58031, 65269),
('North Carolina', 'F', 54, 43844, 64155),
('North Carolina', 'F', 55, 43716, 61740),
('North Carolina', 'F', 56, 43340, 60875),
('North Carolina', 'F', 57, 44844, 59157),
('North Carolina', 'F', 58, 40133, 58824),
('North Carolina', 'F', 59, 37290, 58067),
('North Carolina', 'F', 60, 36281, 58555),
('North Carolina', 'F', 61, 34851, 60193),
('North Carolina', 'F', 62, 34769, 45868),
('North Carolina', 'F', 63, 32951, 45471),
('North Carolina', 'F', 64, 33398, 44969),
('North Carolina', 'F', 65, 33528, 45463),
('North Carolina', 'F', 66, 30407, 39823),
('North Carolina', 'F', 67, 30955, 36295),
('North Carolina', 'F', 68, 30006, 34813),
('North Carolina', 'F', 69, 29030, 32906),
('North Carolina', 'F', 70, 29886, 32300),
('North Carolina', 'F', 71, 29275, 30015),
('North Carolina', 'F', 72, 28897, 29907),
('North Carolina', 'F', 73, 27852, 29591),
('North Carolina', 'F', 74, 26442, 26361),
('North Carolina', 'F', 75, 26798, 26732),
('North Carolina', 'F', 76, 25909, 25595),
('North Carolina', 'F', 77, 23893, 24285),
('North Carolina', 'F', 78, 23591, 24526),
('North Carolina', 'F', 79, 21988, 23303),
('North Carolina', 'F', 80, 20656, 22712),
('North Carolina', 'F', 81, 17945, 21341),
('North Carolina', 'F', 82, 16773, 19467),
('North Carolina', 'F', 83, 15190, 19011),
('North Carolina', 'F', 84, 14091, 17894),
('North Carolina', 'F', 85, 78872, 102980),
('North Dakota', 'M', 0, 3999, 4584),
('North Dakota', 'M', 1, 3943, 4419),
('North Dakota', 'M', 2, 4088, 4365),
('North Dakota', 'M', 3, 3971, 4113),
('North Dakota', 'M', 4, 4093, 3892),
('North Dakota', 'M', 5, 4171, 3870),
('North Dakota', 'M', 6, 4322, 3787),
('North Dakota', 'M', 7, 4348, 3586),
('North Dakota', 'M', 8, 4497, 3790),
('North Dakota', 'M', 9, 4462, 3687),
('North Dakota', 'M', 10, 4821, 3869),
('North Dakota', 'M', 11, 4716, 3773),
('North Dakota', 'M', 12, 4944, 3909),
('North Dakota', 'M', 13, 4823, 4026),
('North Dakota', 'M', 14, 5159, 4217),
('North Dakota', 'M', 15, 5220, 4260),
('North Dakota', 'M', 16, 5232, 4468),
('North Dakota', 'M', 17, 5438, 4430),
('North Dakota', 'M', 18, 5604, 5047),
('North Dakota', 'M', 19, 5886, 6434),
('North Dakota', 'M', 20, 5795, 6182),
('North Dakota', 'M', 21, 5231, 5748),
('North Dakota', 'M', 22, 5249, 6440),
('North Dakota', 'M', 23, 4698, 6109),
('North Dakota', 'M', 24, 4096, 5648),
('North Dakota', 'M', 25, 3994, 4936),
('North Dakota', 'M', 26, 3727, 5810),
('North Dakota', 'M', 27, 3671, 4168),
('North Dakota', 'M', 28, 3610, 4274),
('North Dakota', 'M', 29, 3812, 4208),
('North Dakota', 'M', 30, 3818, 3901),
('North Dakota', 'M', 31, 3668, 3381),
('North Dakota', 'M', 32, 3588, 3243),
('North Dakota', 'M', 33, 3584, 3448),
('North Dakota', 'M', 34, 3726, 3374),
('North Dakota', 'M', 35, 4095, 3547),
('North Dakota', 'M', 36, 4314, 3420),
('North Dakota', 'M', 37, 4484, 3688),
('North Dakota', 'M', 38, 4616, 3600),
('North Dakota', 'M', 39, 4866, 3643),
('North Dakota', 'M', 40, 4969, 3508),
('North Dakota', 'M', 41, 4962, 3569),
('North Dakota', 'M', 42, 4934, 3585),
('North Dakota', 'M', 43, 5064, 3932),
('North Dakota', 'M', 44, 5132, 4123),
('North Dakota', 'M', 45, 5081, 4365),
('North Dakota', 'M', 46, 4954, 4400),
('North Dakota', 'M', 47, 4943, 4637),
('North Dakota', 'M', 48, 4933, 4813),
('North Dakota', 'M', 49, 4354, 4707),
('North Dakota', 'M', 50, 4379, 4765),
('North Dakota', 'M', 51, 4095, 4806),
('North Dakota', 'M', 52, 4010, 4821),
('North Dakota', 'M', 53, 4026, 4819),
('North Dakota', 'M', 54, 3045, 4675),
('North Dakota', 'M', 55, 3123, 4650),
('North Dakota', 'M', 56, 3093, 4668),
('North Dakota', 'M', 57, 3065, 4075),
('North Dakota', 'M', 58, 2777, 4068),
('North Dakota', 'M', 59, 2557, 3753),
('North Dakota', 'M', 60, 2411, 3716),
('North Dakota', 'M', 61, 2403, 3641),
('North Dakota', 'M', 62, 2397, 2755),
('North Dakota', 'M', 63, 2372, 2806),
('North Dakota', 'M', 64, 2279, 2785),
('North Dakota', 'M', 65, 2324, 2693),
('North Dakota', 'M', 66, 2074, 2360),
('North Dakota', 'M', 67, 2230, 2201),
('North Dakota', 'M', 68, 2115, 2036),
('North Dakota', 'M', 69, 2066, 2026),
('North Dakota', 'M', 70, 2178, 1984),
('North Dakota', 'M', 71, 2132, 1900),
('North Dakota', 'M', 72, 2080, 1848),
('North Dakota', 'M', 73, 2069, 1860),
('North Dakota', 'M', 74, 1988, 1592),
('North Dakota', 'M', 75, 1909, 1738),
('North Dakota', 'M', 76, 1721, 1575),
('North Dakota', 'M', 77, 1554, 1506),
('North Dakota', 'M', 78, 1625, 1551),
('North Dakota', 'M', 79, 1456, 1436),
('North Dakota', 'M', 80, 1355, 1378),
('North Dakota', 'M', 81, 1192, 1317),
('North Dakota', 'M', 82, 1188, 1234),
('North Dakota', 'M', 83, 1071, 1133),
('North Dakota', 'M', 84, 951, 1027),
('North Dakota', 'M', 85, 4623, 5774),
('North Dakota', 'F', 0, 3700, 4414),
('North Dakota', 'F', 1, 3733, 4236),
('North Dakota', 'F', 2, 3853, 4099),
('North Dakota', 'F', 3, 3879, 3852),
('North Dakota', 'F', 4, 3968, 3922),
('North Dakota', 'F', 5, 4012, 3673),
('North Dakota', 'F', 6, 4070, 3652),
('North Dakota', 'F', 7, 4094, 3580),
('North Dakota', 'F', 8, 4217, 3527),
('North Dakota', 'F', 9, 4402, 3554),
('North Dakota', 'F', 10, 4488, 3661),
('North Dakota', 'F', 11, 4600, 3725),
('North Dakota', 'F', 12, 4408, 3831),
('North Dakota', 'F', 13, 4630, 3858),
('North Dakota', 'F', 14, 4818, 3957),
('North Dakota', 'F', 15, 5021, 3999),
('North Dakota', 'F', 16, 4983, 4117),
('North Dakota', 'F', 17, 5107, 4346),
('North Dakota', 'F', 18, 5224, 4798),
('North Dakota', 'F', 19, 5359, 5936),
('North Dakota', 'F', 20, 5395, 5831),
('North Dakota', 'F', 21, 5159, 5717),
('North Dakota', 'F', 22, 4717, 5763),
('North Dakota', 'F', 23, 4283, 5139),
('North Dakota', 'F', 24, 3791, 4923),
('North Dakota', 'F', 25, 3821, 4184),
('North Dakota', 'F', 26, 3599, 5024),
('North Dakota', 'F', 27, 3475, 4093),
('North Dakota', 'F', 28, 3585, 3602),
('North Dakota', 'F', 29, 3598, 3717),
('North Dakota', 'F', 30, 3794, 3176),
('North Dakota', 'F', 31, 3555, 3473),
('North Dakota', 'F', 32, 3518, 3067),
('North Dakota', 'F', 33, 3666, 3469),
('North Dakota', 'F', 34, 3808, 3377),
('North Dakota', 'F', 35, 4232, 3348),
('North Dakota', 'F', 36, 4406, 3465),
('North Dakota', 'F', 37, 4740, 3590),
('North Dakota', 'F', 38, 4740, 3625),
('North Dakota', 'F', 39, 4907, 3514),
('North Dakota', 'F', 40, 5081, 3432),
('North Dakota', 'F', 41, 5105, 3599),
('North Dakota', 'F', 42, 5072, 3666),
('North Dakota', 'F', 43, 5079, 4068),
('North Dakota', 'F', 44, 5019, 4105),
('North Dakota', 'F', 45, 4959, 4499),
('North Dakota', 'F', 46, 4823, 4549),
('North Dakota', 'F', 47, 4651, 4701),
('North Dakota', 'F', 48, 4404, 4799),
('North Dakota', 'F', 49, 4275, 4871),
('North Dakota', 'F', 50, 3993, 4841),
('North Dakota', 'F', 51, 3838, 4832),
('North Dakota', 'F', 52, 3698, 4765),
('North Dakota', 'F', 53, 3854, 4767),
('North Dakota', 'F', 54, 3193, 4544),
('North Dakota', 'F', 55, 3009, 4395),
('North Dakota', 'F', 56, 3017, 4148),
('North Dakota', 'F', 57, 2985, 4047),
('North Dakota', 'F', 58, 2725, 3654),
('North Dakota', 'F', 59, 2623, 3615),
('North Dakota', 'F', 60, 2532, 3467),
('North Dakota', 'F', 61, 2549, 3541),
('North Dakota', 'F', 62, 2515, 2981),
('North Dakota', 'F', 63, 2554, 2753),
('North Dakota', 'F', 64, 2513, 2797),
('North Dakota', 'F', 65, 2516, 2739),
('North Dakota', 'F', 66, 2490, 2479),
('North Dakota', 'F', 67, 2341, 2379),
('North Dakota', 'F', 68, 2488, 2290),
('North Dakota', 'F', 69, 2381, 2272),
('North Dakota', 'F', 70, 2589, 2231),
('North Dakota', 'F', 71, 2523, 2226),
('North Dakota', 'F', 72, 2444, 2188),
('North Dakota', 'F', 73, 2342, 2170),
('North Dakota', 'F', 74, 2330, 2109),
('North Dakota', 'F', 75, 2291, 1982),
('North Dakota', 'F', 76, 2205, 2093),
('North Dakota', 'F', 77, 2156, 1939),
('North Dakota', 'F', 78, 2121, 2075),
('North Dakota', 'F', 79, 2032, 2020),
('North Dakota', 'F', 80, 2007, 1946),
('North Dakota', 'F', 81, 1811, 1790),
('North Dakota', 'F', 82, 1873, 1838),
('North Dakota', 'F', 83, 1741, 1723),
('North Dakota', 'F', 84, 1658, 1620),
('North Dakota', 'F', 85, 10223, 11998),
('Ohio', 'M', 0, 76427, 78012),
('Ohio', 'M', 1, 75867, 77502),
('Ohio', 'M', 2, 76503, 75206),
('Ohio', 'M', 3, 76428, 74289),
('Ohio', 'M', 4, 79291, 75660),
('Ohio', 'M', 5, 79656, 74783),
('Ohio', 'M', 6, 80695, 74267),
('Ohio', 'M', 7, 82950, 77120),
('Ohio', 'M', 8, 84848, 75469),
('Ohio', 'M', 9, 86384, 74851),
('Ohio', 'M', 10, 87802, 75610),
('Ohio', 'M', 11, 85409, 75418),
('Ohio', 'M', 12, 84577, 78390),
('Ohio', 'M', 13, 83317, 78680),
('Ohio', 'M', 14, 84733, 79676),
('Ohio', 'M', 15, 85132, 81881),
('Ohio', 'M', 16, 82323, 83622),
('Ohio', 'M', 17, 84021, 84995),
('Ohio', 'M', 18, 83418, 81941),
('Ohio', 'M', 19, 82344, 81527),
('Ohio', 'M', 20, 80387, 79183),
('Ohio', 'M', 21, 76104, 78418),
('Ohio', 'M', 22, 71597, 77321),
('Ohio', 'M', 23, 69919, 77231),
('Ohio', 'M', 24, 67401, 73044),
('Ohio', 'M', 25, 70078, 74221),
('Ohio', 'M', 26, 67630, 78837),
('Ohio', 'M', 27, 69804, 79268),
('Ohio', 'M', 28, 74882, 80016),
('Ohio', 'M', 29, 79950, 74817),
('Ohio', 'M', 30, 81229, 71576),
('Ohio', 'M', 31, 77543, 68585),
('Ohio', 'M', 32, 75614, 66717),
('Ohio', 'M', 33, 76327, 69775),
('Ohio', 'M', 34, 78135, 66427),
('Ohio', 'M', 35, 83619, 68519),
('Ohio', 'M', 36, 85710, 73082),
('Ohio', 'M', 37, 85573, 78101),
('Ohio', 'M', 38, 87564, 79362),
('Ohio', 'M', 39, 89617, 76331),
('Ohio', 'M', 40, 91880, 74493),
('Ohio', 'M', 41, 91045, 75178),
('Ohio', 'M', 42, 92169, 77153),
('Ohio', 'M', 43, 91416, 82544),
('Ohio', 'M', 44, 87501, 85153),
('Ohio', 'M', 45, 88795, 84517),
('Ohio', 'M', 46, 84083, 86113),
('Ohio', 'M', 47, 81983, 87441),
('Ohio', 'M', 48, 80493, 89290),
('Ohio', 'M', 49, 77424, 87871),
('Ohio', 'M', 50, 77115, 88754),
('Ohio', 'M', 51, 75193, 87555),
('Ohio', 'M', 52, 74263, 83033),
('Ohio', 'M', 53, 79151, 84072),
('Ohio', 'M', 54, 55349, 79566),
('Ohio', 'M', 55, 54219, 76972),
('Ohio', 'M', 56, 54312, 75149),
('Ohio', 'M', 57, 58822, 71828),
('Ohio', 'M', 58, 52425, 70550),
('Ohio', 'M', 59, 47668, 68333),
('Ohio', 'M', 60, 45659, 66644),
('Ohio', 'M', 61, 44606, 72051),
('Ohio', 'M', 62, 43978, 48586),
('Ohio', 'M', 63, 41186, 47479),
('Ohio', 'M', 64, 40040, 46442),
('Ohio', 'M', 65, 39734, 50448),
('Ohio', 'M', 66, 35636, 44485),
('Ohio', 'M', 67, 35842, 39709),
('Ohio', 'M', 68, 35950, 37595),
('Ohio', 'M', 69, 36049, 36316),
('Ohio', 'M', 70, 36027, 35760),
('Ohio', 'M', 71, 34284, 32859),
('Ohio', 'M', 72, 34223, 31648),
('Ohio', 'M', 73, 33397, 30988),
('Ohio', 'M', 74, 31020, 27024),
('Ohio', 'M', 75, 29923, 26257),
('Ohio', 'M', 76, 28155, 25750),
('Ohio', 'M', 77, 25913, 24917),
('Ohio', 'M', 78, 24394, 24292),
('Ohio', 'M', 79, 22241, 22052),
('Ohio', 'M', 80, 19804, 21315),
('Ohio', 'M', 81, 17168, 20144),
('Ohio', 'M', 82, 15905, 17679),
('Ohio', 'M', 83, 13360, 16343),
('Ohio', 'M', 84, 11708, 14690),
('Ohio', 'M', 85, 48878, 69614),
('Ohio', 'F', 0, 73291, 74569),
('Ohio', 'F', 1, 73311, 73721),
('Ohio', 'F', 2, 73750, 72238),
('Ohio', 'F', 3, 73372, 70799),
('Ohio', 'F', 4, 75429, 71754),
('Ohio', 'F', 5, 76402, 70950),
('Ohio', 'F', 6, 77460, 71012),
('Ohio', 'F', 7, 79489, 73812),
('Ohio', 'F', 8, 80971, 72320),
('Ohio', 'F', 9, 82597, 72384),
('Ohio', 'F', 10, 83298, 72987),
('Ohio', 'F', 11, 81262, 72406),
('Ohio', 'F', 12, 79795, 74570),
('Ohio', 'F', 13, 79617, 75463),
('Ohio', 'F', 14, 79980, 76470),
('Ohio', 'F', 15, 80977, 78484),
('Ohio', 'F', 16, 78206, 79823),
('Ohio', 'F', 17, 80039, 81184),
('Ohio', 'F', 18, 80222, 78028),
('Ohio', 'F', 19, 81602, 77623),
('Ohio', 'F', 20, 81288, 77792),
('Ohio', 'F', 21, 76504, 76535),
('Ohio', 'F', 22, 72244, 75826),
('Ohio', 'F', 23, 69811, 75050),
('Ohio', 'F', 24, 67746, 70881),
('Ohio', 'F', 25, 70357, 71850),
('Ohio', 'F', 26, 68012, 76383),
('Ohio', 'F', 27, 70397, 81963),
('Ohio', 'F', 28, 75588, 78979),
('Ohio', 'F', 29, 81446, 76118),
('Ohio', 'F', 30, 81469, 70449),
('Ohio', 'F', 31, 78037, 68591),
('Ohio', 'F', 32, 76005, 67485),
('Ohio', 'F', 33, 77364, 69963),
('Ohio', 'F', 34, 79998, 67768),
('Ohio', 'F', 35, 85861, 69550),
('Ohio', 'F', 36, 87665, 75061),
('Ohio', 'F', 37, 88454, 80216),
('Ohio', 'F', 38, 90129, 80258),
('Ohio', 'F', 39, 93317, 76892),
('Ohio', 'F', 40, 94474, 75062),
('Ohio', 'F', 41, 93832, 76113),
('Ohio', 'F', 42, 95306, 78384),
('Ohio', 'F', 43, 93933, 84721),
('Ohio', 'F', 44, 90427, 86285),
('Ohio', 'F', 45, 90627, 87363),
('Ohio', 'F', 46, 87057, 88136),
('Ohio', 'F', 47, 84625, 91408),
('Ohio', 'F', 48, 82594, 92120),
('Ohio', 'F', 49, 80969, 91530),
('Ohio', 'F', 50, 80293, 93016),
('Ohio', 'F', 51, 78369, 91020),
('Ohio', 'F', 52, 78372, 87236),
('Ohio', 'F', 53, 82439, 86973),
('Ohio', 'F', 54, 57556, 83323),
('Ohio', 'F', 55, 57733, 80443),
('Ohio', 'F', 56, 58227, 77950),
('Ohio', 'F', 57, 63460, 76058),
('Ohio', 'F', 58, 56839, 74992),
('Ohio', 'F', 59, 52540, 72539),
('Ohio', 'F', 60, 50863, 72002),
('Ohio', 'F', 61, 49884, 77114),
('Ohio', 'F', 62, 49500, 52285),
('Ohio', 'F', 63, 46133, 52611),
('Ohio', 'F', 64, 45506, 52557),
('Ohio', 'F', 65, 46398, 57333),
('Ohio', 'F', 66, 41887, 50834),
('Ohio', 'F', 67, 42693, 46649),
('Ohio', 'F', 68, 43463, 44906),
('Ohio', 'F', 69, 43742, 43577),
('Ohio', 'F', 70, 44807, 43398),
('Ohio', 'F', 71, 43230, 39984),
('Ohio', 'F', 72, 44371, 39061),
('Ohio', 'F', 73, 43215, 39540),
('Ohio', 'F', 74, 42186, 35080),
('Ohio', 'F', 75, 42525, 35343),
('Ohio', 'F', 76, 41163, 35203),
('Ohio', 'F', 77, 38424, 34509),
('Ohio', 'F', 78, 37809, 35097),
('Ohio', 'F', 79, 35344, 32750),
('Ohio', 'F', 80, 32812, 32824),
('Ohio', 'F', 81, 29383, 31080),
('Ohio', 'F', 82, 28105, 29410),
('Ohio', 'F', 83, 25229, 28704),
('Ohio', 'F', 84, 23267, 26635),
('Ohio', 'F', 85, 129643, 159035),
('Oklahoma', 'M', 0, 24721, 28398),
('Oklahoma', 'M', 1, 24459, 28322),
('Oklahoma', 'M', 2, 24551, 26926),
('Oklahoma', 'M', 3, 23852, 26648),
('Oklahoma', 'M', 4, 23897, 26008),
('Oklahoma', 'M', 5, 24029, 25949),
('Oklahoma', 'M', 6, 24350, 26103),
('Oklahoma', 'M', 7, 24765, 25547),
('Oklahoma', 'M', 8, 25645, 25176),
('Oklahoma', 'M', 9, 25624, 24866),
('Oklahoma', 'M', 10, 26259, 25034),
('Oklahoma', 'M', 11, 25517, 24299),
('Oklahoma', 'M', 12, 25266, 24386),
('Oklahoma', 'M', 13, 25660, 24482),
('Oklahoma', 'M', 14, 26436, 24885),
('Oklahoma', 'M', 15, 26819, 25175),
('Oklahoma', 'M', 16, 27205, 26244),
('Oklahoma', 'M', 17, 28094, 26298),
('Oklahoma', 'M', 18, 27789, 25011),
('Oklahoma', 'M', 19, 27590, 26025),
('Oklahoma', 'M', 20, 27099, 26731),
('Oklahoma', 'M', 21, 24767, 25959),
('Oklahoma', 'M', 22, 24094, 27477),
('Oklahoma', 'M', 23, 23664, 28082),
('Oklahoma', 'M', 24, 22788, 28014),
('Oklahoma', 'M', 25, 22857, 27255),
('Oklahoma', 'M', 26, 21589, 28374),
('Oklahoma', 'M', 27, 21635, 28859),
('Oklahoma', 'M', 28, 22367, 26700),
('Oklahoma', 'M', 29, 23497, 25138),
('Oklahoma', 'M', 30, 23244, 23970),
('Oklahoma', 'M', 31, 22121, 22206),
('Oklahoma', 'M', 32, 21113, 21609),
('Oklahoma', 'M', 33, 20992, 22102),
('Oklahoma', 'M', 34, 21569, 21122),
('Oklahoma', 'M', 35, 23759, 21812),
('Oklahoma', 'M', 36, 24678, 22284),
('Oklahoma', 'M', 37, 25429, 23792),
('Oklahoma', 'M', 38, 25672, 22848),
('Oklahoma', 'M', 39, 26212, 22352),
('Oklahoma', 'M', 40, 27021, 21521),
('Oklahoma', 'M', 41, 25844, 21521),
('Oklahoma', 'M', 42, 25917, 21723),
('Oklahoma', 'M', 43, 26214, 23754),
('Oklahoma', 'M', 44, 25143, 24777),
('Oklahoma', 'M', 45, 25746, 25082),
('Oklahoma', 'M', 46, 24699, 25389),
('Oklahoma', 'M', 47, 23673, 25956),
('Oklahoma', 'M', 48, 22775, 26469),
('Oklahoma', 'M', 49, 22313, 25034),
('Oklahoma', 'M', 50, 21924, 25202),
('Oklahoma', 'M', 51, 21618, 25280),
('Oklahoma', 'M', 52, 21224, 23806),
('Oklahoma', 'M', 53, 22855, 24700),
('Oklahoma', 'M', 54, 17129, 23569),
('Oklahoma', 'M', 55, 17683, 22407),
('Oklahoma', 'M', 56, 17701, 21624),
('Oklahoma', 'M', 57, 17589, 21131),
('Oklahoma', 'M', 58, 16054, 20710),
('Oklahoma', 'M', 59, 15236, 20339),
('Oklahoma', 'M', 60, 14709, 19962),
('Oklahoma', 'M', 61, 13934, 21065),
('Oklahoma', 'M', 62, 13706, 15732),
('Oklahoma', 'M', 63, 13075, 16205),
('Oklahoma', 'M', 64, 13035, 16108),
('Oklahoma', 'M', 65, 13097, 15787),
('Oklahoma', 'M', 66, 11990, 14218),
('Oklahoma', 'M', 67, 11683, 13209),
('Oklahoma', 'M', 68, 11467, 12611),
('Oklahoma', 'M', 69, 11109, 11897),
('Oklahoma', 'M', 70, 11075, 11408),
('Oklahoma', 'M', 71, 10270, 10571),
('Oklahoma', 'M', 72, 10169, 10273),
('Oklahoma', 'M', 73, 9743, 10242),
('Oklahoma', 'M', 74, 9341, 9101),
('Oklahoma', 'M', 75, 8884, 8681),
('Oklahoma', 'M', 76, 8591, 8210),
('Oklahoma', 'M', 77, 7838, 7701),
('Oklahoma', 'M', 78, 7321, 7645),
('Oklahoma', 'M', 79, 6745, 6901),
('Oklahoma', 'M', 80, 5935, 6502),
('Oklahoma', 'M', 81, 5107, 5934),
('Oklahoma', 'M', 82, 4721, 5467),
('Oklahoma', 'M', 83, 3942, 4913),
('Oklahoma', 'M', 84, 3353, 4657),
('Oklahoma', 'M', 85, 16136, 22159),
('Oklahoma', 'F', 0, 23292, 27192),
('Oklahoma', 'F', 1, 23320, 27096),
('Oklahoma', 'F', 2, 23099, 25796),
('Oklahoma', 'F', 3, 22589, 25389),
('Oklahoma', 'F', 4, 22368, 24772),
('Oklahoma', 'F', 5, 22766, 24430),
('Oklahoma', 'F', 6, 23112, 24804),
('Oklahoma', 'F', 7, 23731, 24305),
('Oklahoma', 'F', 8, 24479, 23478),
('Oklahoma', 'F', 9, 24600, 23544),
('Oklahoma', 'F', 10, 25171, 23477),
('Oklahoma', 'F', 11, 24411, 23108),
('Oklahoma', 'F', 12, 24427, 22794),
('Oklahoma', 'F', 13, 24439, 23144),
('Oklahoma', 'F', 14, 25071, 23512),
('Oklahoma', 'F', 15, 25412, 24160),
('Oklahoma', 'F', 16, 25545, 25029),
('Oklahoma', 'F', 17, 26622, 25156),
('Oklahoma', 'F', 18, 26189, 23565),
('Oklahoma', 'F', 19, 26263, 23618),
('Oklahoma', 'F', 20, 26486, 24963),
('Oklahoma', 'F', 21, 24790, 24707),
('Oklahoma', 'F', 22, 23277, 26106),
('Oklahoma', 'F', 23, 22756, 25979),
('Oklahoma', 'F', 24, 21795, 25710),
('Oklahoma', 'F', 25, 22173, 25075),
('Oklahoma', 'F', 26, 21095, 26605),
('Oklahoma', 'F', 27, 21563, 28699),
('Oklahoma', 'F', 28, 22553, 26221),
('Oklahoma', 'F', 29, 23181, 26201),
('Oklahoma', 'F', 30, 23123, 22331),
('Oklahoma', 'F', 31, 21974, 22387),
('Oklahoma', 'F', 32, 21305, 21444),
('Oklahoma', 'F', 33, 21223, 22172),
('Oklahoma', 'F', 34, 21930, 21416),
('Oklahoma', 'F', 35, 23912, 21552),
('Oklahoma', 'F', 36, 25587, 23055),
('Oklahoma', 'F', 37, 26140, 23269),
('Oklahoma', 'F', 38, 26256, 23512),
('Oklahoma', 'F', 39, 26865, 22056),
('Oklahoma', 'F', 40, 27233, 21608),
('Oklahoma', 'F', 41, 26582, 21403),
('Oklahoma', 'F', 42, 26875, 22112),
('Oklahoma', 'F', 43, 26562, 23960),
('Oklahoma', 'F', 44, 25928, 25527),
('Oklahoma', 'F', 45, 25777, 25981),
('Oklahoma', 'F', 46, 25392, 26079),
('Oklahoma', 'F', 47, 24441, 26654),
('Oklahoma', 'F', 48, 23544, 26834),
('Oklahoma', 'F', 49, 23132, 26240),
('Oklahoma', 'F', 50, 22807, 26539),
('Oklahoma', 'F', 51, 22410, 26206),
('Oklahoma', 'F', 52, 22452, 25533),
('Oklahoma', 'F', 53, 24152, 25286),
('Oklahoma', 'F', 54, 18164, 24957),
('Oklahoma', 'F', 55, 18655, 24003),
('Oklahoma', 'F', 56, 18733, 22983),
('Oklahoma', 'F', 57, 18596, 22778),
('Oklahoma', 'F', 58, 17372, 22270),
('Oklahoma', 'F', 59, 16421, 21852),
('Oklahoma', 'F', 60, 16158, 21678),
('Oklahoma', 'F', 61, 15332, 23292),
('Oklahoma', 'F', 62, 15039, 17379),
('Oklahoma', 'F', 63, 14241, 17647),
('Oklahoma', 'F', 64, 14418, 17819),
('Oklahoma', 'F', 65, 14860, 17491),
('Oklahoma', 'F', 66, 13828, 16167),
('Oklahoma', 'F', 67, 13729, 14972),
('Oklahoma', 'F', 68, 13270, 14698),
('Oklahoma', 'F', 69, 13376, 13743),
('Oklahoma', 'F', 70, 13231, 13332),
('Oklahoma', 'F', 71, 12559, 12475),
('Oklahoma', 'F', 72, 12609, 12348),
('Oklahoma', 'F', 73, 12306, 12591),
('Oklahoma', 'F', 74, 12252, 11573),
('Oklahoma', 'F', 75, 11857, 11383),
('Oklahoma', 'F', 76, 11602, 10857),
('Oklahoma', 'F', 77, 10799, 10714),
('Oklahoma', 'F', 78, 10537, 10435),
('Oklahoma', 'F', 79, 10045, 9618),
('Oklahoma', 'F', 80, 9615, 9502),
('Oklahoma', 'F', 81, 8475, 8959),
('Oklahoma', 'F', 82, 7974, 8558),
('Oklahoma', 'F', 83, 6948, 7880),
('Oklahoma', 'F', 84, 6616, 7589),
('Oklahoma', 'F', 85, 41618, 47665),
('Oregon', 'M', 0, 22972, 25789),
('Oregon', 'M', 1, 22585, 25852),
('Oregon', 'M', 2, 22641, 24931),
('Oregon', 'M', 3, 22750, 24257),
('Oregon', 'M', 4, 23183, 23890),
('Oregon', 'M', 5, 23264, 23900),
('Oregon', 'M', 6, 23060, 23919),
('Oregon', 'M', 7, 23781, 24250),
('Oregon', 'M', 8, 24486, 24026),
('Oregon', 'M', 9, 25130, 23710),
('Oregon', 'M', 10, 26049, 23769),
('Oregon', 'M', 11, 25007, 23976),
('Oregon', 'M', 12, 24172, 24514),
('Oregon', 'M', 13, 24708, 24726),
('Oregon', 'M', 14, 24779, 24496),
('Oregon', 'M', 15, 25232, 25215),
('Oregon', 'M', 16, 25049, 25959),
('Oregon', 'M', 17, 25768, 26773),
('Oregon', 'M', 18, 25489, 25826),
('Oregon', 'M', 19, 24279, 23400),
('Oregon', 'M', 20, 24709, 23526),
('Oregon', 'M', 21, 23741, 23425),
('Oregon', 'M', 22, 23390, 24719),
('Oregon', 'M', 23, 23533, 25895),
('Oregon', 'M', 24, 23381, 25909),
('Oregon', 'M', 25, 23838, 26608),
('Oregon', 'M', 26, 22880, 27993),
('Oregon', 'M', 27, 22995, 29025),
('Oregon', 'M', 28, 24631, 28861),
('Oregon', 'M', 29, 25778, 29041),
('Oregon', 'M', 30, 26959, 27854),
('Oregon', 'M', 31, 24830, 26379),
('Oregon', 'M', 32, 23426, 26247),
('Oregon', 'M', 33, 23456, 25981),
('Oregon', 'M', 34, 23360, 24872),
('Oregon', 'M', 35, 24718, 24516),
('Oregon', 'M', 36, 25148, 26211),
('Oregon', 'M', 37, 25516, 27238),
('Oregon', 'M', 38, 26030, 27850),
('Oregon', 'M', 39, 26888, 26369),
('Oregon', 'M', 40, 26939, 24747),
('Oregon', 'M', 41, 26211, 24621),
('Oregon', 'M', 42, 26857, 25038),
('Oregon', 'M', 43, 27477, 26328),
('Oregon', 'M', 44, 26780, 26452),
('Oregon', 'M', 45, 27881, 26670),
('Oregon', 'M', 46, 27770, 27393),
('Oregon', 'M', 47, 27426, 28044),
('Oregon', 'M', 48, 26441, 27966),
('Oregon', 'M', 49, 26031, 27287),
('Oregon', 'M', 50, 25771, 27307),
('Oregon', 'M', 51, 24499, 28005),
('Oregon', 'M', 52, 24220, 27164),
('Oregon', 'M', 53, 25409, 28239),
('Oregon', 'M', 54, 18645, 27623),
('Oregon', 'M', 55, 18501, 27262),
('Oregon', 'M', 56, 18117, 26392),
('Oregon', 'M', 57, 18237, 25957),
('Oregon', 'M', 58, 16071, 25616),
('Oregon', 'M', 59, 15016, 24310),
('Oregon', 'M', 60, 14454, 24128),
('Oregon', 'M', 61, 13201, 24997),
('Oregon', 'M', 62, 12937, 18450),
('Oregon', 'M', 63, 12249, 18167),
('Oregon', 'M', 64, 11725, 17784),
('Oregon', 'M', 65, 11559, 17592),
('Oregon', 'M', 66, 10464, 15249),
('Oregon', 'M', 67, 10416, 14136),
('Oregon', 'M', 68, 10369, 13372),
('Oregon', 'M', 69, 10257, 12127),
('Oregon', 'M', 70, 10177, 11611),
('Oregon', 'M', 71, 9583, 10982),
('Oregon', 'M', 72, 9800, 10502),
('Oregon', 'M', 73, 9677, 9988),
('Oregon', 'M', 74, 9257, 8897),
('Oregon', 'M', 75, 8962, 8700),
('Oregon', 'M', 76, 8339, 8403),
('Oregon', 'M', 77, 7998, 8190),
('Oregon', 'M', 78, 7821, 7985),
('Oregon', 'M', 79, 7323, 6939),
('Oregon', 'M', 80, 6563, 7010),
('Oregon', 'M', 81, 5759, 6774),
('Oregon', 'M', 82, 5434, 6240),
('Oregon', 'M', 83, 4554, 5776),
('Oregon', 'M', 84, 4134, 5050),
('Oregon', 'M', 85, 18534, 26691),
('Oregon', 'F', 0, 21789, 24695),
('Oregon', 'F', 1, 21581, 24614),
('Oregon', 'F', 2, 21732, 23391),
('Oregon', 'F', 3, 22144, 23280),
('Oregon', 'F', 4, 21904, 22784),
('Oregon', 'F', 5, 21923, 23184),
('Oregon', 'F', 6, 22062, 22917),
('Oregon', 'F', 7, 22680, 23252),
('Oregon', 'F', 8, 23545, 22845),
('Oregon', 'F', 9, 23782, 22632),
('Oregon', 'F', 10, 24319, 22727),
('Oregon', 'F', 11, 23774, 23395),
('Oregon', 'F', 12, 23461, 23221),
('Oregon', 'F', 13, 23356, 23204),
('Oregon', 'F', 14, 23449, 23368),
('Oregon', 'F', 15, 23803, 23857),
('Oregon', 'F', 16, 23757, 24977),
('Oregon', 'F', 17, 23877, 25280),
('Oregon', 'F', 18, 24090, 24180),
('Oregon', 'F', 19, 23695, 22051),
('Oregon', 'F', 20, 23892, 22296),
('Oregon', 'F', 21, 22382, 22592),
('Oregon', 'F', 22, 22481, 23562),
('Oregon', 'F', 23, 22335, 24919),
('Oregon', 'F', 24, 22104, 25290),
('Oregon', 'F', 25, 22238, 25157),
('Oregon', 'F', 26, 21353, 25971),
('Oregon', 'F', 27, 21958, 28536),
('Oregon', 'F', 28, 22456, 29231),
('Oregon', 'F', 29, 24161, 26747),
('Oregon', 'F', 30, 24801, 26630),
('Oregon', 'F', 31, 23341, 24992),
('Oregon', 'F', 32, 22148, 24564),
('Oregon', 'F', 33, 21893, 24446),
('Oregon', 'F', 34, 22520, 23479),
('Oregon', 'F', 35, 23580, 24139),
('Oregon', 'F', 36, 24680, 24279),
('Oregon', 'F', 37, 25390, 26204),
('Oregon', 'F', 38, 25958, 26576),
('Oregon', 'F', 39, 26626, 24939),
('Oregon', 'F', 40, 27181, 23960),
('Oregon', 'F', 41, 26870, 23433),
('Oregon', 'F', 42, 27583, 24554),
('Oregon', 'F', 43, 27983, 25289),
('Oregon', 'F', 44, 27515, 26332),
('Oregon', 'F', 45, 27999, 26809),
('Oregon', 'F', 46, 28339, 27548),
('Oregon', 'F', 47, 27903, 28439),
('Oregon', 'F', 48, 26851, 28754),
('Oregon', 'F', 49, 26313, 28042),
('Oregon', 'F', 50, 26035, 28854),
('Oregon', 'F', 51, 24593, 29100),
('Oregon', 'F', 52, 24266, 28646),
('Oregon', 'F', 53, 25880, 28890),
('Oregon', 'F', 54, 18847, 29122),
('Oregon', 'F', 55, 18707, 28577),
('Oregon', 'F', 56, 18585, 27548),
('Oregon', 'F', 57, 18762, 26963),
('Oregon', 'F', 58, 16725, 26652),
('Oregon', 'F', 59, 15420, 24947),
('Oregon', 'F', 60, 14476, 25099),
('Oregon', 'F', 61, 14058, 26177),
('Oregon', 'F', 62, 13790, 19327),
('Oregon', 'F', 63, 12925, 18849),
('Oregon', 'F', 64, 12238, 18868),
('Oregon', 'F', 65, 12430, 18809),
('Oregon', 'F', 66, 11722, 16479),
('Oregon', 'F', 67, 11719, 15260),
('Oregon', 'F', 68, 11669, 14019),
('Oregon', 'F', 69, 11684, 13547),
('Oregon', 'F', 70, 11878, 13226),
('Oregon', 'F', 71, 11609, 12338),
('Oregon', 'F', 72, 11576, 11587),
('Oregon', 'F', 73, 11511, 11517),
('Oregon', 'F', 74, 11491, 10786),
('Oregon', 'F', 75, 11462, 10635),
('Oregon', 'F', 76, 11419, 10286),
('Oregon', 'F', 77, 11041, 10287),
('Oregon', 'F', 78, 10653, 10063),
('Oregon', 'F', 79, 10189, 9713),
('Oregon', 'F', 80, 9437, 9455),
('Oregon', 'F', 81, 8577, 9143),
('Oregon', 'F', 82, 8111, 8652),
('Oregon', 'F', 83, 7387, 8424),
('Oregon', 'F', 84, 6903, 8020),
('Oregon', 'F', 85, 39551, 49538),
('Pennsylvania', 'M', 0, 72831, 76215),
('Pennsylvania', 'M', 1, 72897, 75896),
('Pennsylvania', 'M', 2, 73739, 75638),
('Pennsylvania', 'M', 3, 74402, 74232),
('Pennsylvania', 'M', 4, 77670, 75156),
('Pennsylvania', 'M', 5, 79929, 74677),
('Pennsylvania', 'M', 6, 81973, 74050),
('Pennsylvania', 'M', 7, 84394, 75702),
('Pennsylvania', 'M', 8, 86251, 74570),
('Pennsylvania', 'M', 9, 88931, 74677),
('Pennsylvania', 'M', 10, 91561, 75595),
('Pennsylvania', 'M', 11, 89389, 76270),
('Pennsylvania', 'M', 12, 87933, 79479),
('Pennsylvania', 'M', 13, 87783, 81717),
('Pennsylvania', 'M', 14, 87624, 83907),
('Pennsylvania', 'M', 15, 86941, 86223),
('Pennsylvania', 'M', 16, 85818, 88128),
('Pennsylvania', 'M', 17, 87024, 90522),
('Pennsylvania', 'M', 18, 87912, 95467),
('Pennsylvania', 'M', 19, 86626, 93663),
('Pennsylvania', 'M', 20, 83929, 90805),
('Pennsylvania', 'M', 21, 79417, 89145),
('Pennsylvania', 'M', 22, 73729, 84934),
('Pennsylvania', 'M', 23, 69811, 79497),
('Pennsylvania', 'M', 24, 66467, 76928),
('Pennsylvania', 'M', 25, 68679, 78029),
('Pennsylvania', 'M', 26, 66828, 78273),
('Pennsylvania', 'M', 27, 69802, 77137),
('Pennsylvania', 'M', 28, 75848, 76944),
('Pennsylvania', 'M', 29, 81031, 72905),
('Pennsylvania', 'M', 30, 83142, 71129),
('Pennsylvania', 'M', 31, 80285, 72635),
('Pennsylvania', 'M', 32, 79790, 69716),
('Pennsylvania', 'M', 33, 81363, 72501),
('Pennsylvania', 'M', 34, 83939, 69957),
('Pennsylvania', 'M', 35, 90362, 73090),
('Pennsylvania', 'M', 36, 92163, 78778),
('Pennsylvania', 'M', 37, 91780, 84021),
('Pennsylvania', 'M', 38, 93230, 85184),
('Pennsylvania', 'M', 39, 97280, 82081),
('Pennsylvania', 'M', 40, 99356, 81642),
('Pennsylvania', 'M', 41, 98500, 83668),
('Pennsylvania', 'M', 42, 99742, 86041),
('Pennsylvania', 'M', 43, 98878, 92648),
('Pennsylvania', 'M', 44, 95264, 93266),
('Pennsylvania', 'M', 45, 95702, 93024),
('Pennsylvania', 'M', 46, 92471, 93939),
('Pennsylvania', 'M', 47, 90207, 97713),
('Pennsylvania', 'M', 48, 87861, 98333),
('Pennsylvania', 'M', 49, 84075, 96752),
('Pennsylvania', 'M', 50, 82804, 98072),
('Pennsylvania', 'M', 51, 80562, 96300),
('Pennsylvania', 'M', 52, 81451, 92884),
('Pennsylvania', 'M', 53, 86722, 92564),
('Pennsylvania', 'M', 54, 61289, 88937),
('Pennsylvania', 'M', 55, 60907, 86106),
('Pennsylvania', 'M', 56, 61761, 83242),
('Pennsylvania', 'M', 57, 66446, 79405),
('Pennsylvania', 'M', 58, 56857, 77369),
('Pennsylvania', 'M', 59, 53060, 74735),
('Pennsylvania', 'M', 60, 50949, 74637),
('Pennsylvania', 'M', 61, 49807, 79921),
('Pennsylvania', 'M', 62, 48993, 55050),
('Pennsylvania', 'M', 63, 46588, 54217),
('Pennsylvania', 'M', 64, 45607, 54503),
('Pennsylvania', 'M', 65, 45122, 58347),
('Pennsylvania', 'M', 66, 42204, 49058),
('Pennsylvania', 'M', 67, 43015, 45368),
('Pennsylvania', 'M', 68, 43636, 43118),
('Pennsylvania', 'M', 69, 43245, 41341),
('Pennsylvania', 'M', 70, 43965, 40373),
('Pennsylvania', 'M', 71, 42160, 37633),
('Pennsylvania', 'M', 72, 43122, 36410),
('Pennsylvania', 'M', 73, 41941, 35380),
('Pennsylvania', 'M', 74, 39755, 32088),
('Pennsylvania', 'M', 75, 38619, 32106),
('Pennsylvania', 'M', 76, 35939, 31561),
('Pennsylvania', 'M', 77, 33022, 30366),
('Pennsylvania', 'M', 78, 31943, 30157),
('Pennsylvania', 'M', 79, 29691, 27689),
('Pennsylvania', 'M', 80, 26591, 27247),
('Pennsylvania', 'M', 81, 22561, 25507),
('Pennsylvania', 'M', 82, 21211, 23255),
('Pennsylvania', 'M', 83, 18125, 21714),
('Pennsylvania', 'M', 84, 15660, 19220),
('Pennsylvania', 'M', 85, 66531, 94760),
('Pennsylvania', 'F', 0, 69756, 72697),
('Pennsylvania', 'F', 1, 69356, 72476),
('Pennsylvania', 'F', 2, 69914, 72044),
('Pennsylvania', 'F', 3, 71424, 71016),
('Pennsylvania', 'F', 4, 74165, 72092),
('Pennsylvania', 'F', 5, 76128, 71680),
('Pennsylvania', 'F', 6, 78085, 71166),
('Pennsylvania', 'F', 7, 80250, 73000),
('Pennsylvania', 'F', 8, 82299, 72004),
('Pennsylvania', 'F', 9, 84307, 71596),
('Pennsylvania', 'F', 10, 87071, 71975),
('Pennsylvania', 'F', 11, 84581, 73344),
('Pennsylvania', 'F', 12, 83635, 76049),
('Pennsylvania', 'F', 13, 82968, 77790),
('Pennsylvania', 'F', 14, 82818, 79724),
('Pennsylvania', 'F', 15, 81971, 81822),
('Pennsylvania', 'F', 16, 80204, 83713),
('Pennsylvania', 'F', 17, 81679, 85162),
('Pennsylvania', 'F', 18, 85619, 92516),
('Pennsylvania', 'F', 19, 87903, 92903),
('Pennsylvania', 'F', 20, 85520, 89621),
('Pennsylvania', 'F', 21, 81149, 88027),
('Pennsylvania', 'F', 22, 74163, 80891),
('Pennsylvania', 'F', 23, 68590, 75769),
('Pennsylvania', 'F', 24, 66130, 72529),
('Pennsylvania', 'F', 25, 68273, 73875),
('Pennsylvania', 'F', 26, 67807, 75086),
('Pennsylvania', 'F', 27, 70003, 74616),
('Pennsylvania', 'F', 28, 75270, 75082),
('Pennsylvania', 'F', 29, 81817, 70362),
('Pennsylvania', 'F', 30, 83542, 71771),
('Pennsylvania', 'F', 31, 81659, 70476),
('Pennsylvania', 'F', 32, 81170, 69242),
('Pennsylvania', 'F', 33, 83730, 71259),
('Pennsylvania', 'F', 34, 86307, 71434),
('Pennsylvania', 'F', 35, 92209, 73164),
('Pennsylvania', 'F', 36, 94870, 77635),
('Pennsylvania', 'F', 37, 95022, 84801),
('Pennsylvania', 'F', 38, 97593, 85724),
('Pennsylvania', 'F', 39, 100104, 83796),
('Pennsylvania', 'F', 40, 101559, 82667),
('Pennsylvania', 'F', 41, 101917, 85319),
('Pennsylvania', 'F', 42, 102503, 87569),
('Pennsylvania', 'F', 43, 101576, 92989),
('Pennsylvania', 'F', 44, 97232, 95526),
('Pennsylvania', 'F', 45, 97538, 95222),
('Pennsylvania', 'F', 46, 95205, 97726),
('Pennsylvania', 'F', 47, 92570, 99263),
('Pennsylvania', 'F', 48, 89812, 100717),
('Pennsylvania', 'F', 49, 86677, 100558),
('Pennsylvania', 'F', 50, 85620, 100652),
('Pennsylvania', 'F', 51, 83953, 99680),
('Pennsylvania', 'F', 52, 85427, 95187),
('Pennsylvania', 'F', 53, 90593, 95269),
('Pennsylvania', 'F', 54, 64478, 92203),
('Pennsylvania', 'F', 55, 64574, 89634),
('Pennsylvania', 'F', 56, 66923, 86648),
('Pennsylvania', 'F', 57, 71615, 83249),
('Pennsylvania', 'F', 58, 62626, 81887),
('Pennsylvania', 'F', 59, 58143, 79438),
('Pennsylvania', 'F', 60, 55842, 80439),
('Pennsylvania', 'F', 61, 54958, 85691),
('Pennsylvania', 'F', 62, 54797, 60192),
('Pennsylvania', 'F', 63, 52990, 59973),
('Pennsylvania', 'F', 64, 52560, 61490),
('Pennsylvania', 'F', 65, 53492, 65797),
('Pennsylvania', 'F', 66, 49358, 56972),
('Pennsylvania', 'F', 67, 51163, 52658),
('Pennsylvania', 'F', 68, 52895, 50070),
('Pennsylvania', 'F', 69, 54319, 48749),
('Pennsylvania', 'F', 70, 55810, 48490),
('Pennsylvania', 'F', 71, 54353, 46292),
('Pennsylvania', 'F', 72, 56373, 45687),
('Pennsylvania', 'F', 73, 54842, 46076),
('Pennsylvania', 'F', 74, 54623, 41698),
('Pennsylvania', 'F', 75, 54663, 42571),
('Pennsylvania', 'F', 76, 52508, 43178),
('Pennsylvania', 'F', 77, 49734, 43536),
('Pennsylvania', 'F', 78, 49276, 44207),
('Pennsylvania', 'F', 79, 46914, 41644),
('Pennsylvania', 'F', 80, 44407, 42571),
('Pennsylvania', 'F', 81, 39486, 40168),
('Pennsylvania', 'F', 82, 37997, 39015),
('Pennsylvania', 'F', 83, 34028, 37870),
('Pennsylvania', 'F', 84, 31652, 35142),
('Pennsylvania', 'F', 85, 173095, 215482),
('Rhode Island', 'M', 0, 6267, 6464),
('Rhode Island', 'M', 1, 6420, 6290),
('Rhode Island', 'M', 2, 6614, 6077),
('Rhode Island', 'M', 3, 6581, 5885),
('Rhode Island', 'M', 4, 6740, 6410),
('Rhode Island', 'M', 5, 7030, 6173),
('Rhode Island', 'M', 6, 7163, 6159),
('Rhode Island', 'M', 7, 7356, 6283),
('Rhode Island', 'M', 8, 7537, 6103),
('Rhode Island', 'M', 9, 7702, 6163),
('Rhode Island', 'M', 10, 7854, 6421),
('Rhode Island', 'M', 11, 7523, 6411),
('Rhode Island', 'M', 12, 7256, 6557),
('Rhode Island', 'M', 13, 7234, 6791),
('Rhode Island', 'M', 14, 7060, 6912),
('Rhode Island', 'M', 15, 7108, 7094),
('Rhode Island', 'M', 16, 6947, 7290),
('Rhode Island', 'M', 17, 6940, 7486),
('Rhode Island', 'M', 18, 8195, 9187),
('Rhode Island', 'M', 19, 9023, 9044),
('Rhode Island', 'M', 20, 8540, 8913),
('Rhode Island', 'M', 21, 7883, 8505),
('Rhode Island', 'M', 22, 6987, 7324),
('Rhode Island', 'M', 23, 6157, 7177),
('Rhode Island', 'M', 24, 5778, 6614),
('Rhode Island', 'M', 25, 5990, 7221),
('Rhode Island', 'M', 26, 5794, 6311),
('Rhode Island', 'M', 27, 6049, 7167),
('Rhode Island', 'M', 28, 6429, 6645),
('Rhode Island', 'M', 29, 6798, 5741),
('Rhode Island', 'M', 30, 7323, 6831),
('Rhode Island', 'M', 31, 6983, 5953),
('Rhode Island', 'M', 32, 7243, 5937),
('Rhode Island', 'M', 33, 7107, 6042),
('Rhode Island', 'M', 34, 7664, 5866),
('Rhode Island', 'M', 35, 8052, 6134),
('Rhode Island', 'M', 36, 8213, 6669),
('Rhode Island', 'M', 37, 8061, 6853),
('Rhode Island', 'M', 38, 8362, 7354),
('Rhode Island', 'M', 39, 8375, 6734),
('Rhode Island', 'M', 40, 8416, 7248),
('Rhode Island', 'M', 41, 8285, 6955),
('Rhode Island', 'M', 42, 8393, 7569),
('Rhode Island', 'M', 43, 8083, 7888),
('Rhode Island', 'M', 44, 7997, 7890),
('Rhode Island', 'M', 45, 8073, 7952),
('Rhode Island', 'M', 46, 7549, 8020),
('Rhode Island', 'M', 47, 7252, 8126),
('Rhode Island', 'M', 48, 7057, 8157),
('Rhode Island', 'M', 49, 6851, 7827),
('Rhode Island', 'M', 50, 7024, 8109),
('Rhode Island', 'M', 51, 6739, 7591),
('Rhode Island', 'M', 52, 6594, 7552),
('Rhode Island', 'M', 53, 7262, 7580),
('Rhode Island', 'M', 54, 5312, 7260),
('Rhode Island', 'M', 55, 5224, 6870),
('Rhode Island', 'M', 56, 5038, 6496),
('Rhode Island', 'M', 57, 5398, 6375),
('Rhode Island', 'M', 58, 4511, 6416),
('Rhode Island', 'M', 59, 4010, 6133),
('Rhode Island', 'M', 60, 4007, 5978),
('Rhode Island', 'M', 61, 3824, 6543),
('Rhode Island', 'M', 62, 3734, 4721),
('Rhode Island', 'M', 63, 3446, 4581),
('Rhode Island', 'M', 64, 3386, 4322),
('Rhode Island', 'M', 65, 3433, 4639),
('Rhode Island', 'M', 66, 3241, 3789),
('Rhode Island', 'M', 67, 3232, 3338),
('Rhode Island', 'M', 68, 3082, 3275),
('Rhode Island', 'M', 69, 3361, 3089),
('Rhode Island', 'M', 70, 3193, 3029),
('Rhode Island', 'M', 71, 3231, 2715),
('Rhode Island', 'M', 72, 3314, 2699),
('Rhode Island', 'M', 73, 3229, 2690),
('Rhode Island', 'M', 74, 3150, 2442),
('Rhode Island', 'M', 75, 3053, 2382),
('Rhode Island', 'M', 76, 2847, 2215),
('Rhode Island', 'M', 77, 2721, 2385),
('Rhode Island', 'M', 78, 2587, 2165),
('Rhode Island', 'M', 79, 2443, 2113),
('Rhode Island', 'M', 80, 2156, 2037),
('Rhode Island', 'M', 81, 1854, 1984),
('Rhode Island', 'M', 82, 1772, 1776),
('Rhode Island', 'M', 83, 1437, 1670),
('Rhode Island', 'M', 84, 1248, 1467),
('Rhode Island', 'M', 85, 5500, 7775),
('Rhode Island', 'F', 0, 6090, 6149),
('Rhode Island', 'F', 1, 6297, 5974),
('Rhode Island', 'F', 2, 6229, 5856),
('Rhode Island', 'F', 3, 6282, 5738),
('Rhode Island', 'F', 4, 6430, 6091),
('Rhode Island', 'F', 5, 6752, 5896),
('Rhode Island', 'F', 6, 6835, 5741),
('Rhode Island', 'F', 7, 6978, 5787),
('Rhode Island', 'F', 8, 7047, 5884),
('Rhode Island', 'F', 9, 7273, 6115),
('Rhode Island', 'F', 10, 7506, 6039),
('Rhode Island', 'F', 11, 6937, 6126),
('Rhode Island', 'F', 12, 6990, 6204),
('Rhode Island', 'F', 13, 6794, 6555),
('Rhode Island', 'F', 14, 6537, 6662),
('Rhode Island', 'F', 15, 6708, 6827),
('Rhode Island', 'F', 16, 6499, 6862),
('Rhode Island', 'F', 17, 6603, 7065),
('Rhode Island', 'F', 18, 8114, 9162),
('Rhode Island', 'F', 19, 9361, 9453),
('Rhode Island', 'F', 20, 8797, 8735),
('Rhode Island', 'F', 21, 8339, 8631),
('Rhode Island', 'F', 22, 7013, 7324),
('Rhode Island', 'F', 23, 6275, 7045),
('Rhode Island', 'F', 24, 5932, 6568),
('Rhode Island', 'F', 25, 6051, 6938),
('Rhode Island', 'F', 26, 6139, 6494),
('Rhode Island', 'F', 27, 6179, 6216),
('Rhode Island', 'F', 28, 6889, 7010),
('Rhode Island', 'F', 29, 7398, 6481),
('Rhode Island', 'F', 30, 7848, 6688),
('Rhode Island', 'F', 31, 7575, 6132),
('Rhode Island', 'F', 32, 7561, 6210),
('Rhode Island', 'F', 33, 7749, 6034),
('Rhode Island', 'F', 34, 7988, 6326),
('Rhode Island', 'F', 35, 8540, 6181),
('Rhode Island', 'F', 36, 8612, 6849),
('Rhode Island', 'F', 37, 8600, 7413),
('Rhode Island', 'F', 38, 8734, 7680),
('Rhode Island', 'F', 39, 8862, 7704),
('Rhode Island', 'F', 40, 8873, 7322),
('Rhode Island', 'F', 41, 8902, 7601),
('Rhode Island', 'F', 42, 8769, 7679),
('Rhode Island', 'F', 43, 8695, 8398),
('Rhode Island', 'F', 44, 8331, 8363),
('Rhode Island', 'F', 45, 8535, 8266),
('Rhode Island', 'F', 46, 7985, 8408),
('Rhode Island', 'F', 47, 7734, 8582),
('Rhode Island', 'F', 48, 7544, 8474),
('Rhode Island', 'F', 49, 7144, 8670),
('Rhode Island', 'F', 50, 7106, 8533),
('Rhode Island', 'F', 51, 6922, 8187),
('Rhode Island', 'F', 52, 6996, 7975),
('Rhode Island', 'F', 53, 7586, 8123),
('Rhode Island', 'F', 54, 5513, 7692),
('Rhode Island', 'F', 55, 5471, 7366),
('Rhode Island', 'F', 56, 5406, 7242),
('Rhode Island', 'F', 57, 5818, 6639),
('Rhode Island', 'F', 58, 4887, 6517),
('Rhode Island', 'F', 59, 4546, 6422),
('Rhode Island', 'F', 60, 4414, 6429),
('Rhode Island', 'F', 61, 4139, 7040),
('Rhode Island', 'F', 62, 4227, 5075),
('Rhode Island', 'F', 63, 4027, 4900),
('Rhode Island', 'F', 64, 3999, 4791),
('Rhode Island', 'F', 65, 3941, 5285),
('Rhode Island', 'F', 66, 3690, 4332),
('Rhode Island', 'F', 67, 3975, 4018),
('Rhode Island', 'F', 68, 3833, 3892),
('Rhode Island', 'F', 69, 4085, 3623),
('Rhode Island', 'F', 70, 4259, 3657),
('Rhode Island', 'F', 71, 4169, 3473),
('Rhode Island', 'F', 72, 4353, 3484),
('Rhode Island', 'F', 73, 4353, 3403),
('Rhode Island', 'F', 74, 4297, 3107),
('Rhode Island', 'F', 75, 4356, 3322),
('Rhode Island', 'F', 76, 4164, 3127),
('Rhode Island', 'F', 77, 4124, 3276),
('Rhode Island', 'F', 78, 4026, 3371),
('Rhode Island', 'F', 79, 3757, 3170),
('Rhode Island', 'F', 80, 3539, 3285),
('Rhode Island', 'F', 81, 3245, 3151),
('Rhode Island', 'F', 82, 3202, 3040),
('Rhode Island', 'F', 83, 2832, 2990),
('Rhode Island', 'F', 84, 2611, 2740),
('Rhode Island', 'F', 85, 15590, 18226),
('South Carolina', 'M', 0, 27869, 31229),
('South Carolina', 'M', 1, 26890, 32115),
('South Carolina', 'M', 2, 27298, 31260),
('South Carolina', 'M', 3, 26782, 30390),
('South Carolina', 'M', 4, 26942, 30133),
('South Carolina', 'M', 5, 27728, 29450),
('South Carolina', 'M', 6, 27895, 29840),
('South Carolina', 'M', 7, 29079, 30199),
('South Carolina', 'M', 8, 29535, 29898),
('South Carolina', 'M', 9, 30942, 28788),
('South Carolina', 'M', 10, 31664, 29321),
('South Carolina', 'M', 11, 30364, 28947),
('South Carolina', 'M', 12, 28978, 29061),
('South Carolina', 'M', 13, 28956, 29898),
('South Carolina', 'M', 14, 28810, 29976),
('South Carolina', 'M', 15, 29317, 31115),
('South Carolina', 'M', 16, 28679, 31252),
('South Carolina', 'M', 17, 28790, 32480),
('South Carolina', 'M', 18, 29176, 32824),
('South Carolina', 'M', 19, 29729, 31139),
('South Carolina', 'M', 20, 29449, 29422),
('South Carolina', 'M', 21, 27988, 29884),
('South Carolina', 'M', 22, 26552, 29395),
('South Carolina', 'M', 23, 26096, 29299),
('South Carolina', 'M', 24, 24190, 29018),
('South Carolina', 'M', 25, 25675, 28903),
('South Carolina', 'M', 26, 25378, 28321),
('South Carolina', 'M', 27, 25900, 29390),
('South Carolina', 'M', 28, 26954, 29948),
('South Carolina', 'M', 29, 28309, 28278),
('South Carolina', 'M', 30, 28935, 27300),
('South Carolina', 'M', 31, 27247, 27910),
('South Carolina', 'M', 32, 26656, 25654),
('South Carolina', 'M', 33, 26373, 27236),
('South Carolina', 'M', 34, 27527, 26937),
('South Carolina', 'M', 35, 29854, 27791),
('South Carolina', 'M', 36, 30720, 29183),
('South Carolina', 'M', 37, 29823, 30541),
('South Carolina', 'M', 38, 29866, 30378),
('South Carolina', 'M', 39, 30180, 28770),
('South Carolina', 'M', 40, 31046, 28316),
('South Carolina', 'M', 41, 29857, 27809),
('South Carolina', 'M', 42, 30272, 29171),
('South Carolina', 'M', 43, 30125, 31280),
('South Carolina', 'M', 44, 28787, 32195),
('South Carolina', 'M', 45, 29690, 31328),
('South Carolina', 'M', 46, 28446, 31242),
('South Carolina', 'M', 47, 27593, 31485),
('South Carolina', 'M', 48, 26970, 32262),
('South Carolina', 'M', 49, 26507, 30841),
('South Carolina', 'M', 50, 26936, 30958),
('South Carolina', 'M', 51, 26324, 30947),
('South Carolina', 'M', 52, 26330, 29533),
('South Carolina', 'M', 53, 27660, 29967),
('South Carolina', 'M', 54, 20965, 28952),
('South Carolina', 'M', 55, 21366, 27992),
('South Carolina', 'M', 56, 20706, 27572),
('South Carolina', 'M', 57, 21053, 27348),
('South Carolina', 'M', 58, 18908, 27561),
('South Carolina', 'M', 59, 17955, 26947),
('South Carolina', 'M', 60, 17484, 27196),
('South Carolina', 'M', 61, 16156, 27866),
('South Carolina', 'M', 62, 15580, 21434),
('South Carolina', 'M', 63, 14679, 21879),
('South Carolina', 'M', 64, 14803, 21114),
('South Carolina', 'M', 65, 15195, 20832),
('South Carolina', 'M', 66, 13641, 18352),
('South Carolina', 'M', 67, 13369, 16854),
('South Carolina', 'M', 68, 12553, 16315),
('South Carolina', 'M', 69, 12226, 14681),
('South Carolina', 'M', 70, 12104, 13938),
('South Carolina', 'M', 71, 11186, 12595),
('South Carolina', 'M', 72, 10956, 12392),
('South Carolina', 'M', 73, 10145, 12492),
('South Carolina', 'M', 74, 9678, 10987),
('South Carolina', 'M', 75, 9457, 10600),
('South Carolina', 'M', 76, 8829, 9705),
('South Carolina', 'M', 77, 8065, 9294),
('South Carolina', 'M', 78, 7525, 8853),
('South Carolina', 'M', 79, 6751, 8010),
('South Carolina', 'M', 80, 6183, 7647),
('South Carolina', 'M', 81, 5043, 6671),
('South Carolina', 'M', 82, 4434, 6189),
('South Carolina', 'M', 83, 3805, 5636),
('South Carolina', 'M', 84, 3212, 5156),
('South Carolina', 'M', 85, 13358, 24244),
('South Carolina', 'F', 0, 26650, 29854),
('South Carolina', 'F', 1, 25719, 30618),
('South Carolina', 'F', 2, 25320, 29975),
('South Carolina', 'F', 3, 25168, 28819),
('South Carolina', 'F', 4, 25910, 28631),
('South Carolina', 'F', 5, 26111, 28265),
('South Carolina', 'F', 6, 26657, 28644),
('South Carolina', 'F', 7, 27854, 29096),
('South Carolina', 'F', 8, 28798, 28621),
('South Carolina', 'F', 9, 29225, 27657),
('South Carolina', 'F', 10, 30192, 27283),
('South Carolina', 'F', 11, 29130, 26969),
('South Carolina', 'F', 12, 28295, 27841),
('South Carolina', 'F', 13, 27606, 28025),
('South Carolina', 'F', 14, 27841, 28557),
('South Carolina', 'F', 15, 27808, 29722),
('South Carolina', 'F', 16, 27380, 30711),
('South Carolina', 'F', 17, 27647, 31086),
('South Carolina', 'F', 18, 29371, 32368),
('South Carolina', 'F', 19, 30774, 31360),
('South Carolina', 'F', 20, 29734, 29010),
('South Carolina', 'F', 21, 28404, 28846),
('South Carolina', 'F', 22, 27272, 28814),
('South Carolina', 'F', 23, 26493, 28918),
('South Carolina', 'F', 24, 24977, 28343),
('South Carolina', 'F', 25, 26072, 28952),
('South Carolina', 'F', 26, 25968, 29297),
('South Carolina', 'F', 27, 26932, 30346),
('South Carolina', 'F', 28, 28126, 31337),
('South Carolina', 'F', 29, 29551, 29578),
('South Carolina', 'F', 30, 29490, 29034),
('South Carolina', 'F', 31, 28279, 28015),
('South Carolina', 'F', 32, 27696, 26924),
('South Carolina', 'F', 33, 27832, 27734),
('South Carolina', 'F', 34, 29307, 27706),
('South Carolina', 'F', 35, 31047, 28486),
('South Carolina', 'F', 36, 32496, 30244),
('South Carolina', 'F', 37, 31479, 31651),
('South Carolina', 'F', 38, 31831, 31249),
('South Carolina', 'F', 39, 31923, 30255),
('South Carolina', 'F', 40, 32765, 29651),
('South Carolina', 'F', 41, 31489, 29410),
('South Carolina', 'F', 42, 32025, 31322),
('South Carolina', 'F', 43, 32264, 32788),
('South Carolina', 'F', 44, 31105, 34387),
('South Carolina', 'F', 45, 31470, 33250),
('South Carolina', 'F', 46, 30553, 33508),
('South Carolina', 'F', 47, 30130, 33408),
('South Carolina', 'F', 48, 29062, 34403),
('South Carolina', 'F', 49, 28571, 32974),
('South Carolina', 'F', 50, 28869, 33470),
('South Carolina', 'F', 51, 27639, 33838),
('South Carolina', 'F', 52, 28190, 32544),
('South Carolina', 'F', 53, 29802, 32988),
('South Carolina', 'F', 54, 22564, 32250),
('South Carolina', 'F', 55, 22558, 32140),
('South Carolina', 'F', 56, 22084, 30747),
('South Carolina', 'F', 57, 22982, 30732),
('South Carolina', 'F', 58, 20724, 30767),
('South Carolina', 'F', 59, 19717, 29635),
('South Carolina', 'F', 60, 18896, 30658),
('South Carolina', 'F', 61, 17745, 31289),
('South Carolina', 'F', 62, 17567, 24134),
('South Carolina', 'F', 63, 16963, 23894),
('South Carolina', 'F', 64, 17045, 23479),
('South Carolina', 'F', 65, 17168, 23672),
('South Carolina', 'F', 66, 15967, 20913),
('South Carolina', 'F', 67, 15793, 19468),
('South Carolina', 'F', 68, 15359, 18498),
('South Carolina', 'F', 69, 14502, 17133),
('South Carolina', 'F', 70, 14708, 16652),
('South Carolina', 'F', 71, 14189, 15742),
('South Carolina', 'F', 72, 14335, 15562),
('South Carolina', 'F', 73, 13788, 15399),
('South Carolina', 'F', 74, 13539, 14129),
('South Carolina', 'F', 75, 13555, 13845),
('South Carolina', 'F', 76, 12935, 13508),
('South Carolina', 'F', 77, 12191, 12551),
('South Carolina', 'F', 78, 11689, 12328),
('South Carolina', 'F', 79, 10984, 11664),
('South Carolina', 'F', 80, 10610, 11545),
('South Carolina', 'F', 81, 8738, 10784),
('South Carolina', 'F', 82, 8086, 10163),
('South Carolina', 'F', 83, 7365, 9861),
('South Carolina', 'F', 84, 6741, 9075),
('South Carolina', 'F', 85, 37523, 52360),
('South Dakota', 'M', 0, 5312, 6302),
('South Dakota', 'M', 1, 5306, 6136),
('South Dakota', 'M', 2, 5063, 5806),
('South Dakota', 'M', 3, 5199, 5811),
('South Dakota', 'M', 4, 5228, 5692),
('South Dakota', 'M', 5, 5261, 5452),
('South Dakota', 'M', 6, 5487, 5291),
('South Dakota', 'M', 7, 5501, 5261),
('South Dakota', 'M', 8, 5751, 5368),
('South Dakota', 'M', 9, 5854, 5495),
('South Dakota', 'M', 10, 5986, 5186),
('South Dakota', 'M', 11, 6044, 5361),
('South Dakota', 'M', 12, 5906, 5445),
('South Dakota', 'M', 13, 6136, 5398),
('South Dakota', 'M', 14, 6478, 5707),
('South Dakota', 'M', 15, 6518, 5718),
('South Dakota', 'M', 16, 6393, 5948),
('South Dakota', 'M', 17, 6456, 6041),
('South Dakota', 'M', 18, 6621, 5617),
('South Dakota', 'M', 19, 6192, 6114),
('South Dakota', 'M', 20, 6088, 6198),
('South Dakota', 'M', 21, 5528, 5962),
('South Dakota', 'M', 22, 5083, 6046),
('South Dakota', 'M', 23, 5112, 6133),
('South Dakota', 'M', 24, 4705, 6005),
('South Dakota', 'M', 25, 4592, 5180),
('South Dakota', 'M', 26, 4275, 6331),
('South Dakota', 'M', 27, 4230, 5849),
('South Dakota', 'M', 28, 4537, 5292),
('South Dakota', 'M', 29, 4674, 5223),
('South Dakota', 'M', 30, 4749, 4764),
('South Dakota', 'M', 31, 4566, 4848),
('South Dakota', 'M', 32, 4419, 4431),
('South Dakota', 'M', 33, 4502, 4761),
('South Dakota', 'M', 34, 4739, 4342),
('South Dakota', 'M', 35, 5030, 4289),
('South Dakota', 'M', 36, 5441, 4647),
('South Dakota', 'M', 37, 5732, 4844),
('South Dakota', 'M', 38, 5778, 4837),
('South Dakota', 'M', 39, 5760, 4690),
('South Dakota', 'M', 40, 5922, 4649),
('South Dakota', 'M', 41, 5758, 4543),
('South Dakota', 'M', 42, 5961, 4920),
('South Dakota', 'M', 43, 5892, 5150),
('South Dakota', 'M', 44, 5900, 5534),
('South Dakota', 'M', 45, 5699, 5843),
('South Dakota', 'M', 46, 5770, 5890),
('South Dakota', 'M', 47, 5505, 5942),
('South Dakota', 'M', 48, 5391, 5956),
('South Dakota', 'M', 49, 5114, 5917),
('South Dakota', 'M', 50, 5032, 5970),
('South Dakota', 'M', 51, 4759, 5902),
('South Dakota', 'M', 52, 4591, 5897),
('South Dakota', 'M', 53, 4646, 5674),
('South Dakota', 'M', 54, 3564, 5791),
('South Dakota', 'M', 55, 3501, 5473),
('South Dakota', 'M', 56, 3432, 5428),
('South Dakota', 'M', 57, 3590, 5149),
('South Dakota', 'M', 58, 3205, 5082),
('South Dakota', 'M', 59, 3033, 4890),
('South Dakota', 'M', 60, 2944, 4761),
('South Dakota', 'M', 61, 2777, 4770),
('South Dakota', 'M', 62, 2694, 3696),
('South Dakota', 'M', 63, 2768, 3619),
('South Dakota', 'M', 64, 2814, 3638),
('South Dakota', 'M', 65, 2620, 3604),
('South Dakota', 'M', 66, 2495, 3182),
('South Dakota', 'M', 67, 2446, 2952),
('South Dakota', 'M', 68, 2543, 2815),
('South Dakota', 'M', 69, 2470, 2612),
('South Dakota', 'M', 70, 2531, 2432),
('South Dakota', 'M', 71, 2485, 2450),
('South Dakota', 'M', 72, 2435, 2396),
('South Dakota', 'M', 73, 2321, 2253),
('South Dakota', 'M', 74, 2213, 2069),
('South Dakota', 'M', 75, 2212, 1967),
('South Dakota', 'M', 76, 2253, 1921),
('South Dakota', 'M', 77, 1934, 1912),
('South Dakota', 'M', 78, 1817, 1897),
('South Dakota', 'M', 79, 1706, 1782),
('South Dakota', 'M', 80, 1613, 1693),
('South Dakota', 'M', 81, 1401, 1553),
('South Dakota', 'M', 82, 1264, 1416),
('South Dakota', 'M', 83, 1115, 1353),
('South Dakota', 'M', 84, 996, 1344),
('South Dakota', 'M', 85, 4796, 6732),
('South Dakota', 'F', 0, 5016, 6066),
('South Dakota', 'F', 1, 4977, 5990),
('South Dakota', 'F', 2, 4888, 5618),
('South Dakota', 'F', 3, 4964, 5621),
('South Dakota', 'F', 4, 5061, 5524),
('South Dakota', 'F', 5, 5013, 5285),
('South Dakota', 'F', 6, 5124, 5115),
('South Dakota', 'F', 7, 5315, 5141),
('South Dakota', 'F', 8, 5441, 5032),
('South Dakota', 'F', 9, 5416, 5071),
('South Dakota', 'F', 10, 5732, 5019),
('South Dakota', 'F', 11, 5719, 5090),
('South Dakota', 'F', 12, 5824, 5246),
('South Dakota', 'F', 13, 5871, 5182),
('South Dakota', 'F', 14, 5891, 5300),
('South Dakota', 'F', 15, 6032, 5455),
('South Dakota', 'F', 16, 6194, 5637),
('South Dakota', 'F', 17, 6155, 5499),
('South Dakota', 'F', 18, 5994, 5390),
('South Dakota', 'F', 19, 5922, 5898),
('South Dakota', 'F', 20, 6019, 6020),
('South Dakota', 'F', 21, 5446, 5923),
('South Dakota', 'F', 22, 5112, 5699),
('South Dakota', 'F', 23, 4737, 5398),
('South Dakota', 'F', 24, 4352, 5399),
('South Dakota', 'F', 25, 4377, 4972),
('South Dakota', 'F', 26, 4236, 5823),
('South Dakota', 'F', 27, 4105, 5173),
('South Dakota', 'F', 28, 4366, 5371),
('South Dakota', 'F', 29, 4712, 4640),
('South Dakota', 'F', 30, 4501, 4713),
('South Dakota', 'F', 31, 4496, 4542),
('South Dakota', 'F', 32, 4271, 4455),
('South Dakota', 'F', 33, 4397, 4343),
('South Dakota', 'F', 34, 4738, 4395),
('South Dakota', 'F', 35, 5161, 4122),
('South Dakota', 'F', 36, 5470, 4462),
('South Dakota', 'F', 37, 5620, 4906),
('South Dakota', 'F', 38, 5727, 4497),
('South Dakota', 'F', 39, 5963, 4641),
('South Dakota', 'F', 40, 6013, 4362),
('South Dakota', 'F', 41, 5842, 4583),
('South Dakota', 'F', 42, 5757, 4891),
('South Dakota', 'F', 43, 5807, 5216),
('South Dakota', 'F', 44, 5748, 5535),
('South Dakota', 'F', 45, 5607, 5676),
('South Dakota', 'F', 46, 5542, 5806),
('South Dakota', 'F', 47, 5256, 6048),
('South Dakota', 'F', 48, 5244, 6058),
('South Dakota', 'F', 49, 4943, 5850),
('South Dakota', 'F', 50, 4731, 5712),
('South Dakota', 'F', 51, 4537, 6007),
('South Dakota', 'F', 52, 4363, 5882),
('South Dakota', 'F', 53, 4448, 5728),
('South Dakota', 'F', 54, 3487, 5772),
('South Dakota', 'F', 55, 3459, 5458),
('South Dakota', 'F', 56, 3654, 5443),
('South Dakota', 'F', 57, 3605, 5184),
('South Dakota', 'F', 58, 3249, 4944),
('South Dakota', 'F', 59, 3064, 4699),
('South Dakota', 'F', 60, 3033, 4640),
('South Dakota', 'F', 61, 3077, 4600),
('South Dakota', 'F', 62, 2964, 3717),
('South Dakota', 'F', 63, 2916, 3610),
('South Dakota', 'F', 64, 2868, 3898),
('South Dakota', 'F', 65, 2876, 3745),
('South Dakota', 'F', 66, 2795, 3273),
('South Dakota', 'F', 67, 2833, 3059),
('South Dakota', 'F', 68, 2940, 2946),
('South Dakota', 'F', 69, 2986, 2924),
('South Dakota', 'F', 70, 2860, 2756),
('South Dakota', 'F', 71, 2841, 2663),
('South Dakota', 'F', 72, 2713, 2543),
('South Dakota', 'F', 73, 2811, 2538),
('South Dakota', 'F', 74, 2716, 2469),
('South Dakota', 'F', 75, 2579, 2453),
('South Dakota', 'F', 76, 2594, 2557),
('South Dakota', 'F', 77, 2494, 2572),
('South Dakota', 'F', 78, 2514, 2401),
('South Dakota', 'F', 79, 2417, 2355),
('South Dakota', 'F', 80, 2261, 2240),
('South Dakota', 'F', 81, 2118, 2272),
('South Dakota', 'F', 82, 2017, 2146),
('South Dakota', 'F', 83, 1969, 1977),
('South Dakota', 'F', 84, 1741, 1963),
('South Dakota', 'F', 85, 11427, 13913),
('Tennessee', 'M', 0, 38916, 43537),
('Tennessee', 'M', 1, 38569, 43343),
('Tennessee', 'M', 2, 38157, 42592),
('Tennessee', 'M', 3, 37780, 41530),
('Tennessee', 'M', 4, 38789, 41627),
('Tennessee', 'M', 5, 39442, 40758),
('Tennessee', 'M', 6, 39262, 40963),
('Tennessee', 'M', 7, 40356, 42287),
('Tennessee', 'M', 8, 41016, 41043),
('Tennessee', 'M', 9, 42320, 40944),
('Tennessee', 'M', 10, 42550, 40654),
('Tennessee', 'M', 11, 41206, 40248),
('Tennessee', 'M', 12, 40226, 41261),
('Tennessee', 'M', 13, 39531, 41969),
('Tennessee', 'M', 14, 40064, 41759),
('Tennessee', 'M', 15, 40192, 42830),
('Tennessee', 'M', 16, 39892, 43238),
('Tennessee', 'M', 17, 40539, 44452),
('Tennessee', 'M', 18, 40468, 41883),
('Tennessee', 'M', 19, 41056, 38818),
('Tennessee', 'M', 20, 40512, 37573),
('Tennessee', 'M', 21, 38980, 37588),
('Tennessee', 'M', 22, 37950, 39120),
('Tennessee', 'M', 23, 37456, 40392),
('Tennessee', 'M', 24, 36332, 40083),
('Tennessee', 'M', 25, 38133, 40499),
('Tennessee', 'M', 26, 37968, 41475),
('Tennessee', 'M', 27, 38758, 45410),
('Tennessee', 'M', 28, 40577, 46376),
('Tennessee', 'M', 29, 43017, 44094),
('Tennessee', 'M', 30, 43615, 42211),
('Tennessee', 'M', 31, 40420, 39868),
('Tennessee', 'M', 32, 39261, 38181),
('Tennessee', 'M', 33, 39356, 40291),
('Tennessee', 'M', 34, 40748, 39200),
('Tennessee', 'M', 35, 43882, 40644),
('Tennessee', 'M', 36, 44798, 42462),
('Tennessee', 'M', 37, 43835, 44641),
('Tennessee', 'M', 38, 43731, 45331),
('Tennessee', 'M', 39, 43970, 41921),
('Tennessee', 'M', 40, 45343, 41233),
('Tennessee', 'M', 41, 43906, 40829),
('Tennessee', 'M', 42, 43924, 42818),
('Tennessee', 'M', 43, 43962, 45398),
('Tennessee', 'M', 44, 42415, 46350),
('Tennessee', 'M', 45, 43100, 45330),
('Tennessee', 'M', 46, 42058, 45200),
('Tennessee', 'M', 47, 39777, 45227),
('Tennessee', 'M', 48, 39077, 45922),
('Tennessee', 'M', 49, 38435, 44568),
('Tennessee', 'M', 50, 38895, 44284),
('Tennessee', 'M', 51, 38068, 44243),
('Tennessee', 'M', 52, 38330, 42537),
('Tennessee', 'M', 53, 40500, 42786),
('Tennessee', 'M', 54, 29582, 41972),
('Tennessee', 'M', 55, 30139, 39294),
('Tennessee', 'M', 56, 29736, 38531),
('Tennessee', 'M', 57, 30384, 38026),
('Tennessee', 'M', 58, 27592, 38204),
('Tennessee', 'M', 59, 25472, 37067),
('Tennessee', 'M', 60, 24629, 37255),
('Tennessee', 'M', 61, 23589, 39018),
('Tennessee', 'M', 62, 23127, 28319),
('Tennessee', 'M', 63, 21154, 28739),
('Tennessee', 'M', 64, 21528, 28386),
('Tennessee', 'M', 65, 20582, 28521),
('Tennessee', 'M', 66, 18864, 25328),
('Tennessee', 'M', 67, 18481, 23030),
('Tennessee', 'M', 68, 18190, 21827),
('Tennessee', 'M', 69, 17103, 20597),
('Tennessee', 'M', 70, 17497, 19838),
('Tennessee', 'M', 71, 15902, 17716),
('Tennessee', 'M', 72, 15499, 17521),
('Tennessee', 'M', 73, 14706, 16467),
('Tennessee', 'M', 74, 13717, 14753),
('Tennessee', 'M', 75, 13470, 14055),
('Tennessee', 'M', 76, 12317, 13680),
('Tennessee', 'M', 77, 11168, 12304),
('Tennessee', 'M', 78, 10672, 12340),
('Tennessee', 'M', 79, 9583, 10930),
('Tennessee', 'M', 80, 8598, 10116),
('Tennessee', 'M', 81, 7322, 9449),
('Tennessee', 'M', 82, 6452, 8089),
('Tennessee', 'M', 83, 5562, 7854),
('Tennessee', 'M', 84, 5033, 6731),
('Tennessee', 'M', 85, 22207, 32331),
('Tennessee', 'F', 0, 36986, 41654),
('Tennessee', 'F', 1, 36418, 41207),
('Tennessee', 'F', 2, 36341, 41096),
('Tennessee', 'F', 3, 36124, 39945),
('Tennessee', 'F', 4, 36724, 39803),
('Tennessee', 'F', 5, 37237, 39650),
('Tennessee', 'F', 6, 37301, 39830),
('Tennessee', 'F', 7, 37972, 40617),
('Tennessee', 'F', 8, 39291, 39550),
('Tennessee', 'F', 9, 39779, 38981),
('Tennessee', 'F', 10, 40172, 38970),
('Tennessee', 'F', 11, 39320, 38800),
('Tennessee', 'F', 12, 37841, 39457),
('Tennessee', 'F', 13, 37751, 39966),
('Tennessee', 'F', 14, 38140, 39992),
('Tennessee', 'F', 15, 38127, 40397),
('Tennessee', 'F', 16, 37180, 41672),
('Tennessee', 'F', 17, 37712, 41922),
('Tennessee', 'F', 18, 38794, 39486),
('Tennessee', 'F', 19, 41069, 37269),
('Tennessee', 'F', 20, 40966, 37313),
('Tennessee', 'F', 21, 39776, 38036),
('Tennessee', 'F', 22, 38057, 39511),
('Tennessee', 'F', 23, 37569, 40316),
('Tennessee', 'F', 24, 36220, 39746),
('Tennessee', 'F', 25, 38426, 40139),
('Tennessee', 'F', 26, 37640, 40682),
('Tennessee', 'F', 27, 38679, 48581),
('Tennessee', 'F', 28, 40982, 46327),
('Tennessee', 'F', 29, 43251, 45846),
('Tennessee', 'F', 30, 43104, 41500),
('Tennessee', 'F', 31, 40739, 40367),
('Tennessee', 'F', 32, 39868, 38349),
('Tennessee', 'F', 33, 40149, 40812),
('Tennessee', 'F', 34, 41999, 39743),
('Tennessee', 'F', 35, 45170, 40560),
('Tennessee', 'F', 36, 46575, 43390),
('Tennessee', 'F', 37, 45720, 45311),
('Tennessee', 'F', 38, 45539, 45048),
('Tennessee', 'F', 39, 46228, 42362),
('Tennessee', 'F', 40, 47199, 41920),
('Tennessee', 'F', 41, 45660, 41697),
('Tennessee', 'F', 42, 45959, 43766),
('Tennessee', 'F', 43, 46308, 46960),
('Tennessee', 'F', 44, 44914, 48801),
('Tennessee', 'F', 45, 45282, 47552),
('Tennessee', 'F', 46, 43943, 47340),
('Tennessee', 'F', 47, 42004, 48266),
('Tennessee', 'F', 48, 41435, 48205),
('Tennessee', 'F', 49, 39967, 46881),
('Tennessee', 'F', 50, 40364, 47040),
('Tennessee', 'F', 51, 40180, 47277),
('Tennessee', 'F', 52, 39317, 45529),
('Tennessee', 'F', 53, 41528, 46180),
('Tennessee', 'F', 54, 31381, 44780),
('Tennessee', 'F', 55, 31647, 42574),
('Tennessee', 'F', 56, 31434, 42183),
('Tennessee', 'F', 57, 32390, 40796),
('Tennessee', 'F', 58, 29319, 40796),
('Tennessee', 'F', 59, 27788, 40763),
('Tennessee', 'F', 60, 27227, 39895),
('Tennessee', 'F', 61, 25572, 41149),
('Tennessee', 'F', 62, 25492, 31308),
('Tennessee', 'F', 63, 23652, 31296),
('Tennessee', 'F', 64, 24523, 30992),
('Tennessee', 'F', 65, 23950, 31582),
('Tennessee', 'F', 66, 22335, 28314),
('Tennessee', 'F', 67, 21949, 26397),
('Tennessee', 'F', 68, 21769, 25723),
('Tennessee', 'F', 69, 21193, 23869),
('Tennessee', 'F', 70, 21519, 23428),
('Tennessee', 'F', 71, 19993, 21436),
('Tennessee', 'F', 72, 20348, 21942),
('Tennessee', 'F', 73, 19593, 21182),
('Tennessee', 'F', 74, 19521, 19373),
('Tennessee', 'F', 75, 19333, 18833),
('Tennessee', 'F', 76, 18527, 18385),
('Tennessee', 'F', 77, 17214, 17593),
('Tennessee', 'F', 78, 17079, 17676),
('Tennessee', 'F', 79, 15985, 15877),
('Tennessee', 'F', 80, 14932, 15899),
('Tennessee', 'F', 81, 13372, 14740),
('Tennessee', 'F', 82, 12072, 14145),
('Tennessee', 'F', 83, 11141, 13431),
('Tennessee', 'F', 84, 10501, 12493),
('Tennessee', 'F', 85, 60206, 73831),
('Texas', 'M', 0, 172223, 212360),
('Texas', 'M', 1, 165635, 208828),
('Texas', 'M', 2, 165337, 206795),
('Texas', 'M', 3, 164292, 205343),
('Texas', 'M', 4, 165785, 204173),
('Texas', 'M', 5, 166278, 200533),
('Texas', 'M', 6, 167170, 198372),
('Texas', 'M', 7, 169210, 197368),
('Texas', 'M', 8, 171199, 185436),
('Texas', 'M', 9, 170521, 178927),
('Texas', 'M', 10, 173734, 178789),
('Texas', 'M', 11, 167859, 177846),
('Texas', 'M', 12, 166474, 179606),
('Texas', 'M', 13, 166014, 179420),
('Texas', 'M', 14, 166081, 179991),
('Texas', 'M', 15, 167257, 180973),
('Texas', 'M', 16, 165881, 182812),
('Texas', 'M', 17, 171567, 182703),
('Texas', 'M', 18, 170011, 179710),
('Texas', 'M', 19, 164671, 175486),
('Texas', 'M', 20, 163295, 172892),
('Texas', 'M', 21, 153946, 172989),
('Texas', 'M', 22, 150839, 176098),
('Texas', 'M', 23, 152673, 181611),
('Texas', 'M', 24, 153769, 186181),
('Texas', 'M', 25, 156739, 188651),
('Texas', 'M', 26, 153181, 199455),
('Texas', 'M', 27, 155480, 191280),
('Texas', 'M', 28, 161048, 191723),
('Texas', 'M', 29, 165852, 181112),
('Texas', 'M', 30, 167982, 175598),
('Texas', 'M', 31, 158505, 175282),
('Texas', 'M', 32, 153855, 171141),
('Texas', 'M', 33, 151149, 174943),
('Texas', 'M', 34, 155095, 168343),
('Texas', 'M', 35, 164514, 172567),
('Texas', 'M', 36, 167136, 175922),
('Texas', 'M', 37, 168668, 180902),
('Texas', 'M', 38, 167261, 180130),
('Texas', 'M', 39, 169195, 169419),
('Texas', 'M', 40, 173212, 164824),
('Texas', 'M', 41, 164647, 161303),
('Texas', 'M', 42, 163690, 165884),
('Texas', 'M', 43, 161774, 173192),
('Texas', 'M', 44, 154542, 174205),
('Texas', 'M', 45, 154603, 173582),
('Texas', 'M', 46, 145891, 172346),
('Texas', 'M', 47, 141254, 172889),
('Texas', 'M', 48, 133710, 174736),
('Texas', 'M', 49, 129998, 165937),
('Texas', 'M', 50, 128278, 163585),
('Texas', 'M', 51, 123298, 160850),
('Texas', 'M', 52, 120815, 153283),
('Texas', 'M', 53, 126031, 153748),
('Texas', 'M', 54, 95701, 143253),
('Texas', 'M', 55, 95537, 138583),
('Texas', 'M', 56, 93337, 130699),
('Texas', 'M', 57, 91482, 126454),
('Texas', 'M', 58, 82603, 124352),
('Texas', 'M', 59, 76614, 118395),
('Texas', 'M', 60, 73441, 115631),
('Texas', 'M', 61, 69422, 119570),
('Texas', 'M', 62, 67820, 90079),
('Texas', 'M', 63, 63502, 89113),
('Texas', 'M', 64, 62593, 86902),
('Texas', 'M', 65, 62994, 84399),
('Texas', 'M', 66, 57324, 75150),
('Texas', 'M', 67, 55581, 68894),
('Texas', 'M', 68, 54657, 65189),
('Texas', 'M', 69, 53235, 60736),
('Texas', 'M', 70, 52902, 58483),
('Texas', 'M', 71, 49046, 54221),
('Texas', 'M', 72, 46608, 51547),
('Texas', 'M', 73, 44784, 51162),
('Texas', 'M', 74, 42390, 45654),
('Texas', 'M', 75, 40487, 43322),
('Texas', 'M', 76, 37785, 41295),
('Texas', 'M', 77, 35332, 39489),
('Texas', 'M', 78, 33199, 38518),
('Texas', 'M', 79, 29635, 34155),
('Texas', 'M', 80, 27357, 31898),
('Texas', 'M', 81, 21864, 29467),
('Texas', 'M', 82, 20249, 26841),
('Texas', 'M', 83, 16946, 24591),
('Texas', 'M', 84, 15033, 21858),
('Texas', 'M', 85, 69392, 109433),
('Texas', 'F', 0, 164724, 202708),
('Texas', 'F', 1, 158669, 199810),
('Texas', 'F', 2, 157386, 197805),
('Texas', 'F', 3, 157374, 195246),
('Texas', 'F', 4, 158236, 194239),
('Texas', 'F', 5, 158722, 193335),
('Texas', 'F', 6, 160506, 188872),
('Texas', 'F', 7, 162126, 188901),
('Texas', 'F', 8, 163788, 176807),
('Texas', 'F', 9, 163500, 171257),
('Texas', 'F', 10, 165717, 170182),
('Texas', 'F', 11, 160176, 170273),
('Texas', 'F', 12, 159167, 171119),
('Texas', 'F', 13, 158693, 170903),
('Texas', 'F', 14, 158580, 172160),
('Texas', 'F', 15, 159654, 173125),
('Texas', 'F', 16, 155841, 174312),
('Texas', 'F', 17, 158372, 174122),
('Texas', 'F', 18, 156767, 167089),
('Texas', 'F', 19, 156778, 165500),
('Texas', 'F', 20, 156625, 163358),
('Texas', 'F', 21, 147729, 162487),
('Texas', 'F', 22, 144433, 167148),
('Texas', 'F', 23, 147865, 171506),
('Texas', 'F', 24, 146961, 170280),
('Texas', 'F', 25, 151098, 171463),
('Texas', 'F', 26, 148823, 184113),
('Texas', 'F', 27, 151810, 181047),
('Texas', 'F', 28, 158452, 180954),
('Texas', 'F', 29, 165252, 173725),
('Texas', 'F', 30, 164600, 164621),
('Texas', 'F', 31, 155658, 166391),
('Texas', 'F', 32, 150518, 165038),
('Texas', 'F', 33, 148996, 168463),
('Texas', 'F', 34, 152593, 163898),
('Texas', 'F', 35, 163350, 168912),
('Texas', 'F', 36, 167597, 174075),
('Texas', 'F', 37, 168463, 179467),
('Texas', 'F', 38, 168421, 178232),
('Texas', 'F', 39, 169355, 168167),
('Texas', 'F', 40, 171412, 160986),
('Texas', 'F', 41, 164244, 159286),
('Texas', 'F', 42, 163809, 162595),
('Texas', 'F', 43, 162822, 171490),
('Texas', 'F', 44, 155226, 174336),
('Texas', 'F', 45, 155427, 174769),
('Texas', 'F', 46, 149105, 173570),
('Texas', 'F', 47, 144081, 173569),
('Texas', 'F', 48, 136873, 175589),
('Texas', 'F', 49, 133610, 167009),
('Texas', 'F', 50, 133121, 166679),
('Texas', 'F', 51, 127211, 165361),
('Texas', 'F', 52, 125058, 157127),
('Texas', 'F', 53, 129694, 156170),
('Texas', 'F', 54, 99379, 150187),
('Texas', 'F', 55, 100403, 145009),
('Texas', 'F', 56, 97778, 137342),
('Texas', 'F', 57, 95755, 133928),
('Texas', 'F', 58, 87189, 132764),
('Texas', 'F', 59, 82764, 125965),
('Texas', 'F', 60, 79048, 123963),
('Texas', 'F', 61, 75160, 127832),
('Texas', 'F', 62, 74358, 97210),
('Texas', 'F', 63, 70332, 98081),
('Texas', 'F', 64, 70089, 94872),
('Texas', 'F', 65, 71266, 92604),
('Texas', 'F', 66, 65074, 83347),
('Texas', 'F', 67, 64383, 78672),
('Texas', 'F', 68, 63639, 74319),
('Texas', 'F', 69, 62713, 70485),
('Texas', 'F', 70, 64996, 68972),
('Texas', 'F', 71, 59894, 64274),
('Texas', 'F', 72, 58527, 63227),
('Texas', 'F', 73, 57708, 63683),
('Texas', 'F', 74, 56446, 57435),
('Texas', 'F', 75, 55989, 56080),
('Texas', 'F', 76, 52656, 54423),
('Texas', 'F', 77, 48993, 52482),
('Texas', 'F', 78, 47681, 53907),
('Texas', 'F', 79, 44609, 48607),
('Texas', 'F', 80, 42132, 46399),
('Texas', 'F', 81, 35378, 44418),
('Texas', 'F', 82, 33852, 41838),
('Texas', 'F', 83, 30076, 40489),
('Texas', 'F', 84, 27961, 36821),
('Texas', 'F', 85, 171538, 223439),
('Utah', 'M', 0, 23301, 29235),
('Utah', 'M', 1, 22158, 28516),
('Utah', 'M', 2, 21405, 27702),
('Utah', 'M', 3, 20881, 26481),
('Utah', 'M', 4, 20278, 26297),
('Utah', 'M', 5, 20350, 25857),
('Utah', 'M', 6, 19491, 25340),
('Utah', 'M', 7, 19762, 24789),
('Utah', 'M', 8, 19789, 24131),
('Utah', 'M', 9, 20113, 23366),
('Utah', 'M', 10, 20147, 22746),
('Utah', 'M', 11, 19891, 22474),
('Utah', 'M', 12, 19465, 21763),
('Utah', 'M', 13, 19737, 22002),
('Utah', 'M', 14, 19925, 21076),
('Utah', 'M', 15, 20927, 21390),
('Utah', 'M', 16, 21260, 21564),
('Utah', 'M', 17, 22192, 22144),
('Utah', 'M', 18, 23253, 22208),
('Utah', 'M', 19, 20774, 19149),
('Utah', 'M', 20, 18204, 16040),
('Utah', 'M', 21, 22742, 22625),
('Utah', 'M', 22, 24472, 28016),
('Utah', 'M', 23, 24549, 30845),
('Utah', 'M', 24, 22611, 30213),
('Utah', 'M', 25, 20624, 27876),
('Utah', 'M', 26, 18768, 26869),
('Utah', 'M', 27, 17617, 27308),
('Utah', 'M', 28, 17337, 26183),
('Utah', 'M', 29, 17334, 25675),
('Utah', 'M', 30, 17000, 21673),
('Utah', 'M', 31, 15464, 19517),
('Utah', 'M', 32, 15024, 17830),
('Utah', 'M', 33, 14616, 17844),
('Utah', 'M', 34, 14135, 17300),
('Utah', 'M', 35, 14606, 17002),
('Utah', 'M', 36, 14853, 17783),
('Utah', 'M', 37, 15156, 17763),
('Utah', 'M', 38, 15398, 17701),
('Utah', 'M', 39, 15449, 16198),
('Utah', 'M', 40, 15657, 15823),
('Utah', 'M', 41, 15011, 15565),
('Utah', 'M', 42, 14933, 15016),
('Utah', 'M', 43, 15056, 15632),
('Utah', 'M', 44, 14399, 15824),
('Utah', 'M', 45, 14536, 16042),
('Utah', 'M', 46, 13868, 16177),
('Utah', 'M', 47, 13366, 16402),
('Utah', 'M', 48, 12628, 16549),
('Utah', 'M', 49, 12075, 15795),
('Utah', 'M', 50, 11802, 15564),
('Utah', 'M', 51, 11189, 15671),
('Utah', 'M', 52, 10900, 14971),
('Utah', 'M', 53, 11152, 15105),
('Utah', 'M', 54, 8406, 14403),
('Utah', 'M', 55, 8393, 13687),
('Utah', 'M', 56, 8546, 12956),
('Utah', 'M', 57, 8513, 12379),
('Utah', 'M', 58, 7482, 12167),
('Utah', 'M', 59, 6799, 11487),
('Utah', 'M', 60, 6578, 11250),
('Utah', 'M', 61, 6375, 11287),
('Utah', 'M', 62, 6087, 8530),
('Utah', 'M', 63, 5808, 8426),
('Utah', 'M', 64, 5543, 8686),
('Utah', 'M', 65, 5686, 8649),
('Utah', 'M', 66, 5080, 7529),
('Utah', 'M', 67, 5005, 6764),
('Utah', 'M', 68, 4939, 6494),
('Utah', 'M', 69, 4901, 6287),
('Utah', 'M', 70, 4782, 5862),
('Utah', 'M', 71, 4699, 5638),
('Utah', 'M', 72, 4334, 5246),
('Utah', 'M', 73, 4257, 5251),
('Utah', 'M', 74, 4168, 4685),
('Utah', 'M', 75, 3960, 4571),
('Utah', 'M', 76, 3771, 4372),
('Utah', 'M', 77, 3376, 4281),
('Utah', 'M', 78, 3317, 4020),
('Utah', 'M', 79, 3051, 3885),
('Utah', 'M', 80, 2772, 3418),
('Utah', 'M', 81, 2451, 3252),
('Utah', 'M', 82, 2348, 3051),
('Utah', 'M', 83, 1892, 2722),
('Utah', 'M', 84, 1674, 2464),
('Utah', 'M', 85, 7320, 12193),
('Utah', 'F', 0, 21933, 27834),
('Utah', 'F', 1, 21112, 26799),
('Utah', 'F', 2, 20096, 25899),
('Utah', 'F', 3, 19701, 24842),
('Utah', 'F', 4, 19236, 25311),
('Utah', 'F', 5, 18886, 24615),
('Utah', 'F', 6, 18341, 23948),
('Utah', 'F', 7, 18563, 23665),
('Utah', 'F', 8, 18682, 22685),
('Utah', 'F', 9, 18869, 22232),
('Utah', 'F', 10, 19151, 21313),
('Utah', 'F', 11, 18875, 21040),
('Utah', 'F', 12, 18583, 20654),
('Utah', 'F', 13, 18660, 20414),
('Utah', 'F', 14, 19100, 19786),
('Utah', 'F', 15, 19526, 20099),
('Utah', 'F', 16, 19940, 20492),
('Utah', 'F', 17, 20930, 21133),
('Utah', 'F', 18, 23281, 22406),
('Utah', 'F', 19, 25048, 22812),
('Utah', 'F', 20, 25367, 22985),
('Utah', 'F', 21, 24027, 22637),
('Utah', 'F', 22, 22742, 22164),
('Utah', 'F', 23, 21761, 23551),
('Utah', 'F', 24, 19760, 22733),
('Utah', 'F', 25, 18928, 21791),
('Utah', 'F', 26, 17229, 21735),
('Utah', 'F', 27, 16507, 24867),
('Utah', 'F', 28, 16187, 23985),
('Utah', 'F', 29, 16494, 23162),
('Utah', 'F', 30, 15884, 23154),
('Utah', 'F', 31, 14833, 20397),
('Utah', 'F', 32, 13982, 19178),
('Utah', 'F', 33, 13697, 18847),
('Utah', 'F', 34, 13509, 18051),
('Utah', 'F', 35, 13963, 17500),
('Utah', 'F', 36, 14680, 17293),
('Utah', 'F', 37, 15045, 17758),
('Utah', 'F', 38, 15050, 16958),
('Utah', 'F', 39, 15305, 15968),
('Utah', 'F', 40, 15333, 15093),
('Utah', 'F', 41, 14854, 14724),
('Utah', 'F', 42, 14874, 14905),
('Utah', 'F', 43, 14867, 14953),
('Utah', 'F', 44, 14197, 15458),
('Utah', 'F', 45, 14302, 15999),
('Utah', 'F', 46, 13897, 16029),
('Utah', 'F', 47, 13174, 16514),
('Utah', 'F', 48, 12628, 16210),
('Utah', 'F', 49, 12181, 15788),
('Utah', 'F', 50, 11854, 15472),
('Utah', 'F', 51, 11202, 15702),
('Utah', 'F', 52, 11007, 15087),
('Utah', 'F', 53, 11307, 15034),
('Utah', 'F', 54, 8440, 14581),
('Utah', 'F', 55, 8591, 13860),
('Utah', 'F', 56, 8949, 13337),
('Utah', 'F', 57, 8611, 12668),
('Utah', 'F', 58, 7648, 12591),
('Utah', 'F', 59, 7244, 11759),
('Utah', 'F', 60, 7110, 11560),
('Utah', 'F', 61, 6599, 11787),
('Utah', 'F', 62, 6561, 8823),
('Utah', 'F', 63, 6202, 8796),
('Utah', 'F', 64, 6083, 9409),
('Utah', 'F', 65, 6113, 9029),
('Utah', 'F', 66, 5617, 7859),
('Utah', 'F', 67, 5459, 7529),
('Utah', 'F', 68, 5560, 7327),
('Utah', 'F', 69, 5455, 6769),
('Utah', 'F', 70, 5574, 6691),
('Utah', 'F', 71, 5253, 6325),
('Utah', 'F', 72, 4977, 6065),
('Utah', 'F', 73, 5051, 6062),
('Utah', 'F', 74, 4859, 5527),
('Utah', 'F', 75, 4909, 5285),
('Utah', 'F', 76, 4745, 5353),
('Utah', 'F', 77, 4491, 5142),
('Utah', 'F', 78, 4209, 5045),
('Utah', 'F', 79, 4152, 4741),
('Utah', 'F', 80, 3834, 4400),
('Utah', 'F', 81, 3560, 4315),
('Utah', 'F', 82, 3279, 3959),
('Utah', 'F', 83, 2911, 3868),
('Utah', 'F', 84, 2784, 3572),
('Utah', 'F', 85, 14762, 20705),
('Vermont', 'M', 0, 3358, 3365),
('Vermont', 'M', 1, 3435, 3464),
('Vermont', 'M', 2, 3378, 3125),
('Vermont', 'M', 3, 3538, 3359),
('Vermont', 'M', 4, 3710, 3468),
('Vermont', 'M', 5, 3924, 3457),
('Vermont', 'M', 6, 4038, 3312),
('Vermont', 'M', 7, 4143, 3459),
('Vermont', 'M', 8, 4212, 3491),
('Vermont', 'M', 9, 4567, 3564),
('Vermont', 'M', 10, 4705, 3475),
('Vermont', 'M', 11, 4678, 3608),
('Vermont', 'M', 12, 4734, 3757),
('Vermont', 'M', 13, 4714, 3972),
('Vermont', 'M', 14, 4645, 4104),
('Vermont', 'M', 15, 4775, 4219),
('Vermont', 'M', 16, 4622, 4283),
('Vermont', 'M', 17, 4518, 4682),
('Vermont', 'M', 18, 4687, 4882),
('Vermont', 'M', 19, 5028, 5003),
('Vermont', 'M', 20, 4890, 4989),
('Vermont', 'M', 21, 4282, 4717),
('Vermont', 'M', 22, 3753, 4207),
('Vermont', 'M', 23, 3438, 4054),
('Vermont', 'M', 24, 3128, 3678),
('Vermont', 'M', 25, 3176, 3639),
('Vermont', 'M', 26, 3122, 3453),
('Vermont', 'M', 27, 3222, 3827),
('Vermont', 'M', 28, 3508, 3991),
('Vermont', 'M', 29, 3830, 3497),
('Vermont', 'M', 30, 4051, 3515),
('Vermont', 'M', 31, 3827, 3406),
('Vermont', 'M', 32, 3681, 3297),
('Vermont', 'M', 33, 3907, 3389),
('Vermont', 'M', 34, 4188, 3373),
('Vermont', 'M', 35, 4466, 3451),
('Vermont', 'M', 36, 4720, 3755),
('Vermont', 'M', 37, 4774, 4107),
('Vermont', 'M', 38, 4808, 4238),
('Vermont', 'M', 39, 5126, 3973),
('Vermont', 'M', 40, 5145, 3970),
('Vermont', 'M', 41, 5175, 3979),
('Vermont', 'M', 42, 5174, 4359),
('Vermont', 'M', 43, 5133, 4596),
('Vermont', 'M', 44, 5134, 4952),
('Vermont', 'M', 45, 5177, 4944),
('Vermont', 'M', 46, 5056, 4923),
('Vermont', 'M', 47, 4906, 5284),
('Vermont', 'M', 48, 4777, 5086),
('Vermont', 'M', 49, 4740, 5223),
('Vermont', 'M', 50, 4687, 5252),
('Vermont', 'M', 51, 4701, 5120),
('Vermont', 'M', 52, 4631, 5085),
('Vermont', 'M', 53, 4681, 5111),
('Vermont', 'M', 54, 3421, 5041),
('Vermont', 'M', 55, 3493, 4893),
('Vermont', 'M', 56, 3455, 4753),
('Vermont', 'M', 57, 3644, 4661),
('Vermont', 'M', 58, 2940, 4522),
('Vermont', 'M', 59, 2814, 4511),
('Vermont', 'M', 60, 2626, 4455),
('Vermont', 'M', 61, 2455, 4498),
('Vermont', 'M', 62, 2472, 3208),
('Vermont', 'M', 63, 2225, 3253),
('Vermont', 'M', 64, 2202, 3201),
('Vermont', 'M', 65, 2172, 3379),
('Vermont', 'M', 66, 2013, 2670),
('Vermont', 'M', 67, 1946, 2478),
('Vermont', 'M', 68, 1954, 2306),
('Vermont', 'M', 69, 1941, 2085),
('Vermont', 'M', 70, 1915, 2096),
('Vermont', 'M', 71, 1751, 1845),
('Vermont', 'M', 72, 1870, 1790),
('Vermont', 'M', 73, 1723, 1725),
('Vermont', 'M', 74, 1550, 1567),
('Vermont', 'M', 75, 1557, 1495),
('Vermont', 'M', 76, 1402, 1434),
('Vermont', 'M', 77, 1332, 1380),
('Vermont', 'M', 78, 1180, 1334),
('Vermont', 'M', 79, 1182, 1169),
('Vermont', 'M', 80, 1014, 1227),
('Vermont', 'M', 81, 887, 1112),
('Vermont', 'M', 82, 841, 935),
('Vermont', 'M', 83, 724, 946),
('Vermont', 'M', 84, 594, 810),
('Vermont', 'M', 85, 2814, 3870),
('Vermont', 'F', 0, 3071, 3223),
('Vermont', 'F', 1, 3290, 3259),
('Vermont', 'F', 2, 3299, 3066),
('Vermont', 'F', 3, 3408, 3107),
('Vermont', 'F', 4, 3457, 3199),
('Vermont', 'F', 5, 3803, 3165),
('Vermont', 'F', 6, 3854, 3189),
('Vermont', 'F', 7, 3907, 3331),
('Vermont', 'F', 8, 4183, 3168),
('Vermont', 'F', 9, 4248, 3381),
('Vermont', 'F', 10, 4435, 3378),
('Vermont', 'F', 11, 4438, 3493),
('Vermont', 'F', 12, 4375, 3486),
('Vermont', 'F', 13, 4385, 3852),
('Vermont', 'F', 14, 4394, 3933),
('Vermont', 'F', 15, 4391, 3959),
('Vermont', 'F', 16, 4396, 4260),
('Vermont', 'F', 17, 4436, 4317),
('Vermont', 'F', 18, 4387, 4701),
('Vermont', 'F', 19, 4655, 4923),
('Vermont', 'F', 20, 4406, 4741),
('Vermont', 'F', 21, 4135, 4497),
('Vermont', 'F', 22, 3660, 4112),
('Vermont', 'F', 23, 3271, 3640),
('Vermont', 'F', 24, 3123, 3477),
('Vermont', 'F', 25, 3247, 3681),
('Vermont', 'F', 26, 3129, 3515),
('Vermont', 'F', 27, 3220, 3829),
('Vermont', 'F', 28, 3564, 3482),
('Vermont', 'F', 29, 3861, 3579),
('Vermont', 'F', 30, 4100, 3356),
('Vermont', 'F', 31, 4021, 3487),
('Vermont', 'F', 32, 3978, 3345),
('Vermont', 'F', 33, 4198, 3583),
('Vermont', 'F', 34, 4333, 3392),
('Vermont', 'F', 35, 4663, 3464),
('Vermont', 'F', 36, 4947, 3703),
('Vermont', 'F', 37, 4999, 4130),
('Vermont', 'F', 38, 5205, 4292),
('Vermont', 'F', 39, 5361, 4305),
('Vermont', 'F', 40, 5327, 4185),
('Vermont', 'F', 41, 5301, 4304),
('Vermont', 'F', 42, 5421, 4590),
('Vermont', 'F', 43, 5559, 4846),
('Vermont', 'F', 44, 5181, 5122),
('Vermont', 'F', 45, 5365, 5073),
('Vermont', 'F', 46, 5157, 5231),
('Vermont', 'F', 47, 5134, 5410),
('Vermont', 'F', 48, 5085, 5295),
('Vermont', 'F', 49, 4951, 5339),
('Vermont', 'F', 50, 4668, 5413),
('Vermont', 'F', 51, 4620, 5525),
('Vermont', 'F', 52, 4415, 5079),
('Vermont', 'F', 53, 4738, 5386),
('Vermont', 'F', 54, 3529, 5104),
('Vermont', 'F', 55, 3553, 4991),
('Vermont', 'F', 56, 3373, 4951),
('Vermont', 'F', 57, 3551, 4870),
('Vermont', 'F', 58, 3051, 4462),
('Vermont', 'F', 59, 2911, 4456),
('Vermont', 'F', 60, 2679, 4306),
('Vermont', 'F', 61, 2496, 4484),
('Vermont', 'F', 62, 2543, 3413),
('Vermont', 'F', 63, 2392, 3438),
('Vermont', 'F', 64, 2332, 3195),
('Vermont', 'F', 65, 2326, 3341),
('Vermont', 'F', 66, 2061, 2801),
('Vermont', 'F', 67, 2208, 2723),
('Vermont', 'F', 68, 2228, 2466),
('Vermont', 'F', 69, 2246, 2266),
('Vermont', 'F', 70, 2268, 2256),
('Vermont', 'F', 71, 2167, 2126),
('Vermont', 'F', 72, 2161, 2072),
('Vermont', 'F', 73, 2023, 2029),
('Vermont', 'F', 74, 2127, 1780),
('Vermont', 'F', 75, 2004, 1832),
('Vermont', 'F', 76, 2007, 1877),
('Vermont', 'F', 77, 1904, 1849),
('Vermont', 'F', 78, 1727, 1819),
('Vermont', 'F', 79, 1683, 1700),
('Vermont', 'F', 80, 1622, 1658),
('Vermont', 'F', 81, 1414, 1509),
('Vermont', 'F', 82, 1490, 1569),
('Vermont', 'F', 83, 1245, 1432),
('Vermont', 'F', 84, 1172, 1397),
('Vermont', 'F', 85, 7300, 8494),
('Virginia', 'M', 0, 48025, 54664),
('Virginia', 'M', 1, 47221, 54059),
('Virginia', 'M', 2, 46744, 53151),
('Virginia', 'M', 3, 46811, 52517),
('Virginia', 'M', 4, 47461, 53129),
('Virginia', 'M', 5, 48972, 51089),
('Virginia', 'M', 6, 49108, 51587),
('Virginia', 'M', 7, 50595, 51671),
('Virginia', 'M', 8, 51033, 49791),
('Virginia', 'M', 9, 52135, 49241),
('Virginia', 'M', 10, 53127, 48886),
('Virginia', 'M', 11, 51456, 49169),
('Virginia', 'M', 12, 50334, 49701),
('Virginia', 'M', 13, 49744, 51236),
('Virginia', 'M', 14, 50006, 51197),
('Virginia', 'M', 15, 49856, 52652),
('Virginia', 'M', 16, 48457, 52919),
('Virginia', 'M', 17, 49152, 53835),
('Virginia', 'M', 18, 48478, 56608),
('Virginia', 'M', 19, 47064, 53503),
('Virginia', 'M', 20, 47106, 53176),
('Virginia', 'M', 21, 45528, 52894),
('Virginia', 'M', 22, 43860, 52322),
('Virginia', 'M', 23, 42776, 51760),
('Virginia', 'M', 24, 41860, 52363),
('Virginia', 'M', 25, 43683, 54618),
('Virginia', 'M', 26, 42550, 53199),
('Virginia', 'M', 27, 44308, 53108),
('Virginia', 'M', 28, 47426, 53261),
('Virginia', 'M', 29, 50458, 49905),
('Virginia', 'M', 30, 51997, 49559),
('Virginia', 'M', 31, 49709, 49020),
('Virginia', 'M', 32, 48775, 48537),
('Virginia', 'M', 33, 49465, 48867),
('Virginia', 'M', 34, 50961, 47658),
('Virginia', 'M', 35, 54943, 50625),
('Virginia', 'M', 36, 56722, 52313),
('Virginia', 'M', 37, 55869, 54504),
('Virginia', 'M', 38, 56244, 55516),
('Virginia', 'M', 39, 56606, 53572),
('Virginia', 'M', 40, 57334, 51109),
('Virginia', 'M', 41, 56142, 52991),
('Virginia', 'M', 42, 56075, 54482),
('Virginia', 'M', 43, 55811, 56545),
('Virginia', 'M', 44, 53952, 58427),
('Virginia', 'M', 45, 53953, 57439),
('Virginia', 'M', 46, 52005, 57182),
('Virginia', 'M', 47, 50744, 57244),
('Virginia', 'M', 48, 48749, 57880),
('Virginia', 'M', 49, 47540, 56232),
('Virginia', 'M', 50, 48179, 55490),
('Virginia', 'M', 51, 47662, 55142),
('Virginia', 'M', 52, 47869, 52949),
('Virginia', 'M', 53, 50608, 52840),
('Virginia', 'M', 54, 37505, 50289),
('Virginia', 'M', 55, 37595, 49150),
('Virginia', 'M', 56, 36466, 46604),
('Virginia', 'M', 57, 38213, 44908),
('Virginia', 'M', 58, 32861, 45070),
('Virginia', 'M', 59, 30354, 44031),
('Virginia', 'M', 60, 29146, 44090),
('Virginia', 'M', 61, 27660, 46400),
('Virginia', 'M', 62, 26449, 33772),
('Virginia', 'M', 63, 25006, 33240),
('Virginia', 'M', 64, 23793, 32054),
('Virginia', 'M', 65, 23392, 34051),
('Virginia', 'M', 66, 21372, 28946),
('Virginia', 'M', 67, 21285, 26617),
('Virginia', 'M', 68, 20461, 25319),
('Virginia', 'M', 69, 19934, 23840),
('Virginia', 'M', 70, 19947, 22337),
('Virginia', 'M', 71, 18434, 20928),
('Virginia', 'M', 72, 17970, 19541),
('Virginia', 'M', 73, 16682, 18831),
('Virginia', 'M', 74, 15609, 16815),
('Virginia', 'M', 75, 15380, 16407),
('Virginia', 'M', 76, 14361, 15328),
('Virginia', 'M', 77, 13205, 14586),
('Virginia', 'M', 78, 12548, 14250),
('Virginia', 'M', 79, 11439, 12699),
('Virginia', 'M', 80, 10103, 11923),
('Virginia', 'M', 81, 8662, 10814),
('Virginia', 'M', 82, 7777, 9488),
('Virginia', 'M', 83, 6488, 9002),
('Virginia', 'M', 84, 5663, 8100),
('Virginia', 'M', 85, 23612, 37580),
('Virginia', 'F', 0, 45818, 52340),
('Virginia', 'F', 1, 45049, 51658),
('Virginia', 'F', 2, 44775, 51098),
('Virginia', 'F', 3, 45238, 50001),
('Virginia', 'F', 4, 45257, 50055),
('Virginia', 'F', 5, 46906, 49901),
('Virginia', 'F', 6, 47058, 49501),
('Virginia', 'F', 7, 48025, 49998),
('Virginia', 'F', 8, 49008, 47702),
('Virginia', 'F', 9, 50477, 47105),
('Virginia', 'F', 10, 50820, 46729),
('Virginia', 'F', 11, 49132, 47651),
('Virginia', 'F', 12, 48523, 47430),
('Virginia', 'F', 13, 47811, 49137),
('Virginia', 'F', 14, 47514, 49213),
('Virginia', 'F', 15, 47306, 50053),
('Virginia', 'F', 16, 45409, 50770),
('Virginia', 'F', 17, 46307, 52318),
('Virginia', 'F', 18, 47231, 56583),
('Virginia', 'F', 19, 48120, 52384),
('Virginia', 'F', 20, 47875, 51230),
('Virginia', 'F', 21, 45650, 50787),
('Virginia', 'F', 22, 44868, 49881),
('Virginia', 'F', 23, 44165, 50656),
('Virginia', 'F', 24, 43309, 49631),
('Virginia', 'F', 25, 45020, 53790),
('Virginia', 'F', 26, 44543, 50660),
('Virginia', 'F', 27, 46739, 53796),
('Virginia', 'F', 28, 49893, 53872),
('Virginia', 'F', 29, 53446, 48912),
('Virginia', 'F', 30, 54386, 52220),
('Virginia', 'F', 31, 52630, 50099),
('Virginia', 'F', 32, 51928, 49777),
('Virginia', 'F', 33, 52860, 50457),
('Virginia', 'F', 34, 54616, 48823),
('Virginia', 'F', 35, 59760, 51868),
('Virginia', 'F', 36, 60956, 54041),
('Virginia', 'F', 37, 61030, 58145),
('Virginia', 'F', 38, 60233, 57168),
('Virginia', 'F', 39, 61016, 56056),
('Virginia', 'F', 40, 61692, 54297),
('Virginia', 'F', 41, 60241, 55469),
('Virginia', 'F', 42, 59837, 56678),
('Virginia', 'F', 43, 59148, 61581),
('Virginia', 'F', 44, 57449, 62105),
('Virginia', 'F', 45, 57750, 62690),
('Virginia', 'F', 46, 55586, 61655),
('Virginia', 'F', 47, 54041, 62034),
('Virginia', 'F', 48, 51911, 62023),
('Virginia', 'F', 49, 51302, 60418),
('Virginia', 'F', 50, 51441, 60178),
('Virginia', 'F', 51, 50331, 58983),
('Virginia', 'F', 52, 50508, 56618),
('Virginia', 'F', 53, 53003, 56890),
('Virginia', 'F', 54, 39194, 54192),
('Virginia', 'F', 55, 39341, 52557),
('Virginia', 'F', 56, 38885, 50204),
('Virginia', 'F', 57, 39856, 49656),
('Virginia', 'F', 58, 34711, 49060),
('Virginia', 'F', 59, 32386, 47795),
('Virginia', 'F', 60, 31249, 47713),
('Virginia', 'F', 61, 29359, 50232),
('Virginia', 'F', 62, 28533, 36408),
('Virginia', 'F', 63, 26995, 36397),
('Virginia', 'F', 64, 26446, 36054),
('Virginia', 'F', 65, 26454, 37019),
('Virginia', 'F', 66, 24425, 32467),
('Virginia', 'F', 67, 24627, 30163),
('Virginia', 'F', 68, 24012, 29261),
('Virginia', 'F', 69, 23702, 27287),
('Virginia', 'F', 70, 24200, 26402),
('Virginia', 'F', 71, 23010, 24580),
('Virginia', 'F', 72, 22962, 23993),
('Virginia', 'F', 73, 22474, 23798),
('Virginia', 'F', 74, 21841, 21422),
('Virginia', 'F', 75, 21954, 21419),
('Virginia', 'F', 76, 21255, 20527),
('Virginia', 'F', 77, 19532, 19892),
('Virginia', 'F', 78, 19294, 19949),
('Virginia', 'F', 79, 18000, 18729),
('Virginia', 'F', 80, 16810, 18122),
('Virginia', 'F', 81, 14685, 17307),
('Virginia', 'F', 82, 13735, 16270),
('Virginia', 'F', 83, 12394, 15664),
('Virginia', 'F', 84, 11176, 14791),
('Virginia', 'F', 85, 64726, 84113),
('Washington', 'M', 0, 40420, 45086),
('Washington', 'M', 1, 40234, 44959),
('Washington', 'M', 2, 40595, 44767),
('Washington', 'M', 3, 40268, 43262),
('Washington', 'M', 4, 40807, 43428),
('Washington', 'M', 5, 41637, 42499),
('Washington', 'M', 6, 42192, 42176),
('Washington', 'M', 7, 44008, 43088),
('Washington', 'M', 8, 44802, 42455),
('Washington', 'M', 9, 45186, 42192),
('Washington', 'M', 10, 46432, 42659),
('Washington', 'M', 11, 44773, 42433),
('Washington', 'M', 12, 44315, 42820),
('Washington', 'M', 13, 43847, 43468),
('Washington', 'M', 14, 44488, 43906),
('Washington', 'M', 15, 44896, 45701),
('Washington', 'M', 16, 44424, 46734),
('Washington', 'M', 17, 44704, 47181),
('Washington', 'M', 18, 43838, 45672),
('Washington', 'M', 19, 41042, 41462),
('Washington', 'M', 20, 40763, 42112),
('Washington', 'M', 21, 38388, 41217),
('Washington', 'M', 22, 36816, 43151),
('Washington', 'M', 23, 37374, 45452),
('Washington', 'M', 24, 36504, 46704),
('Washington', 'M', 25, 38154, 46306),
('Washington', 'M', 26, 36831, 48332),
('Washington', 'M', 27, 37186, 50153),
('Washington', 'M', 28, 40641, 48434),
('Washington', 'M', 29, 44062, 47671),
('Washington', 'M', 30, 46760, 44997),
('Washington', 'M', 31, 44263, 44215),
('Washington', 'M', 32, 42287, 42546),
('Washington', 'M', 33, 41225, 44154),
('Washington', 'M', 34, 42309, 42089),
('Washington', 'M', 35, 45801, 41762),
('Washington', 'M', 36, 46901, 45118),
('Washington', 'M', 37, 47501, 47438),
('Washington', 'M', 38, 47776, 49742),
('Washington', 'M', 39, 48616, 46849),
('Washington', 'M', 40, 50233, 44723),
('Washington', 'M', 41, 47940, 43561),
('Washington', 'M', 42, 49384, 44802),
('Washington', 'M', 43, 49079, 48234),
('Washington', 'M', 44, 47454, 48414),
('Washington', 'M', 45, 48144, 49335),
('Washington', 'M', 46, 46390, 49147),
('Washington', 'M', 47, 45630, 49883),
('Washington', 'M', 48, 43584, 51702),
('Washington', 'M', 49, 42261, 48744),
('Washington', 'M', 50, 42591, 49976),
('Washington', 'M', 51, 40738, 49155),
('Washington', 'M', 52, 39862, 47905),
('Washington', 'M', 53, 42513, 48195),
('Washington', 'M', 54, 31167, 46036),
('Washington', 'M', 55, 31096, 45123),
('Washington', 'M', 56, 30516, 42942),
('Washington', 'M', 57, 30737, 41408),
('Washington', 'M', 58, 26660, 41485),
('Washington', 'M', 59, 24444, 39809),
('Washington', 'M', 60, 23267, 38546),
('Washington', 'M', 61, 21835, 40944),
('Washington', 'M', 62, 21211, 29745),
('Washington', 'M', 63, 19636, 29761),
('Washington', 'M', 64, 18664, 28835),
('Washington', 'M', 65, 18427, 28955),
('Washington', 'M', 66, 16883, 24746),
('Washington', 'M', 67, 16482, 22576),
('Washington', 'M', 68, 16166, 21136),
('Washington', 'M', 69, 16244, 19668),
('Washington', 'M', 70, 15965, 18928),
('Washington', 'M', 71, 14981, 17272),
('Washington', 'M', 72, 14457, 16305),
('Washington', 'M', 73, 13859, 15703),
('Washington', 'M', 74, 13438, 14213),
('Washington', 'M', 75, 13300, 13453),
('Washington', 'M', 76, 12702, 13063),
('Washington', 'M', 77, 11809, 12770),
('Washington', 'M', 78, 11769, 12145),
('Washington', 'M', 79, 10791, 11085),
('Washington', 'M', 80, 9911, 10358),
('Washington', 'M', 81, 8492, 9506),
('Washington', 'M', 82, 7891, 8815),
('Washington', 'M', 83, 6729, 8388),
('Washington', 'M', 84, 6096, 7508),
('Washington', 'M', 85, 26653, 39486),
('Washington', 'F', 0, 38342, 43120),
('Washington', 'F', 1, 38345, 43219),
('Washington', 'F', 2, 38549, 42733),
('Washington', 'F', 3, 38464, 41021),
('Washington', 'F', 4, 38822, 41524),
('Washington', 'F', 5, 39707, 40617),
('Washington', 'F', 6, 40086, 40390),
('Washington', 'F', 7, 41406, 41247),
('Washington', 'F', 8, 42565, 40236),
('Washington', 'F', 9, 43026, 40326),
('Washington', 'F', 10, 43691, 40607),
('Washington', 'F', 11, 42395, 40614),
('Washington', 'F', 12, 42182, 40790),
('Washington', 'F', 13, 41939, 41657),
('Washington', 'F', 14, 42628, 41844),
('Washington', 'F', 15, 42414, 43039),
('Washington', 'F', 16, 41540, 44265),
('Washington', 'F', 17, 41773, 45097),
('Washington', 'F', 18, 41041, 41547),
('Washington', 'F', 19, 40718, 39158),
('Washington', 'F', 20, 40354, 39065),
('Washington', 'F', 21, 37859, 38919),
('Washington', 'F', 22, 37318, 42310),
('Washington', 'F', 23, 37095, 43312),
('Washington', 'F', 24, 36120, 43556),
('Washington', 'F', 25, 37594, 43307),
('Washington', 'F', 26, 36520, 46318),
('Washington', 'F', 27, 37257, 48774),
('Washington', 'F', 28, 40045, 49009),
('Washington', 'F', 29, 43222, 47552),
('Washington', 'F', 30, 45513, 44033),
('Washington', 'F', 31, 42761, 42746),
('Washington', 'F', 32, 41759, 41612),
('Washington', 'F', 33, 41364, 42767),
('Washington', 'F', 34, 42193, 41529),
('Washington', 'F', 35, 45651, 41892),
('Washington', 'F', 36, 46959, 44009),
('Washington', 'F', 37, 48065, 47110),
('Washington', 'F', 38, 48413, 48448),
('Washington', 'F', 39, 49412, 45683),
('Washington', 'F', 40, 49993, 44505),
('Washington', 'F', 41, 48535, 43421),
('Washington', 'F', 42, 49360, 44192),
('Washington', 'F', 43, 49365, 47684),
('Washington', 'F', 44, 48104, 48412),
('Washington', 'F', 45, 48610, 49404),
('Washington', 'F', 46, 47451, 49996),
('Washington', 'F', 47, 46581, 50723),
('Washington', 'F', 48, 43965, 51260),
('Washington', 'F', 49, 43459, 49831),
('Washington', 'F', 50, 43021, 50049),
('Washington', 'F', 51, 40819, 50466),
('Washington', 'F', 52, 40561, 49179),
('Washington', 'F', 53, 42712, 49473),
('Washington', 'F', 54, 31619, 47994),
('Washington', 'F', 55, 31527, 47023),
('Washington', 'F', 56, 30779, 43967),
('Washington', 'F', 57, 30539, 43416),
('Washington', 'F', 58, 26576, 43190),
('Washington', 'F', 59, 24526, 40649),
('Washington', 'F', 60, 23702, 40391),
('Washington', 'F', 61, 22048, 42227),
('Washington', 'F', 62, 21731, 31370),
('Washington', 'F', 63, 20467, 31097),
('Washington', 'F', 64, 19658, 30421),
('Washington', 'F', 65, 19526, 29794),
('Washington', 'F', 66, 18258, 25651),
('Washington', 'F', 67, 17958, 23619),
('Washington', 'F', 68, 18082, 22881),
('Washington', 'F', 69, 17956, 21198),
('Washington', 'F', 70, 18314, 20703),
('Washington', 'F', 71, 17585, 19434),
('Washington', 'F', 72, 17426, 18483),
('Washington', 'F', 73, 17640, 18227),
('Washington', 'F', 74, 17261, 16787),
('Washington', 'F', 75, 17602, 16477),
('Washington', 'F', 76, 17070, 16091),
('Washington', 'F', 77, 16367, 15703),
('Washington', 'F', 78, 16114, 15834),
('Washington', 'F', 79, 15589, 14948),
('Washington', 'F', 80, 14489, 14174),
('Washington', 'F', 81, 12841, 14120),
('Washington', 'F', 82, 12116, 13275),
('Washington', 'F', 83, 10777, 12937),
('Washington', 'F', 84, 9725, 12088),
('Washington', 'F', 85, 58444, 75374),
('West Virginia', 'M', 0, 10278, 10815),
('West Virginia', 'M', 1, 10018, 10734),
('West Virginia', 'M', 2, 10346, 10830),
('West Virginia', 'M', 3, 10388, 10654),
('West Virginia', 'M', 4, 10617, 10976),
('West Virginia', 'M', 5, 10993, 10712),
('West Virginia', 'M', 6, 10994, 10893),
('West Virginia', 'M', 7, 11274, 10797),
('West Virginia', 'M', 8, 11665, 10647),
('West Virginia', 'M', 9, 11805, 10323),
('West Virginia', 'M', 10, 12104, 10633),
('West Virginia', 'M', 11, 11741, 10683),
('West Virginia', 'M', 12, 11749, 10861),
('West Virginia', 'M', 13, 11960, 11306),
('West Virginia', 'M', 14, 12286, 11298),
('West Virginia', 'M', 15, 12463, 11524),
('West Virginia', 'M', 16, 12389, 11953),
('West Virginia', 'M', 17, 13032, 12055),
('West Virginia', 'M', 18, 13053, 12242),
('West Virginia', 'M', 19, 13675, 12208),
('West Virginia', 'M', 20, 13702, 11868),
('West Virginia', 'M', 21, 12750, 11430),
('West Virginia', 'M', 22, 12234, 11700),
('West Virginia', 'M', 23, 11634, 11130),
('West Virginia', 'M', 24, 10624, 10416),
('West Virginia', 'M', 25, 11021, 10838),
('West Virginia', 'M', 26, 10612, 10857),
('West Virginia', 'M', 27, 11108, 12283),
('West Virginia', 'M', 28, 11469, 12900),
('West Virginia', 'M', 29, 11983, 12566),
('West Virginia', 'M', 30, 11740, 11721),
('West Virginia', 'M', 31, 11466, 11799),
('West Virginia', 'M', 32, 11185, 10763),
('West Virginia', 'M', 33, 11192, 11360),
('West Virginia', 'M', 34, 11567, 10708),
('West Virginia', 'M', 35, 12257, 11329),
('West Virginia', 'M', 36, 12465, 11648),
('West Virginia', 'M', 37, 12448, 12353),
('West Virginia', 'M', 38, 12603, 11838),
('West Virginia', 'M', 39, 12955, 11645),
('West Virginia', 'M', 40, 13719, 11486),
('West Virginia', 'M', 41, 13622, 11462),
('West Virginia', 'M', 42, 14480, 11857),
('West Virginia', 'M', 43, 14211, 12652),
('West Virginia', 'M', 44, 13834, 12688),
('West Virginia', 'M', 45, 14328, 12773),
('West Virginia', 'M', 46, 14078, 12757),
('West Virginia', 'M', 47, 13991, 12923),
('West Virginia', 'M', 48, 14010, 13703),
('West Virginia', 'M', 49, 13845, 13367),
('West Virginia', 'M', 50, 13844, 14207),
('West Virginia', 'M', 51, 13655, 13944),
('West Virginia', 'M', 52, 13397, 13476),
('West Virginia', 'M', 53, 13952, 13748),
('West Virginia', 'M', 54, 10146, 13468),
('West Virginia', 'M', 55, 10104, 13446),
('West Virginia', 'M', 56, 9901, 13172),
('West Virginia', 'M', 57, 10442, 13040),
('West Virginia', 'M', 58, 9401, 12976),
('West Virginia', 'M', 59, 8961, 12706),
('West Virginia', 'M', 60, 8554, 12469),
('West Virginia', 'M', 61, 8713, 13007),
('West Virginia', 'M', 62, 8459, 9291),
('West Virginia', 'M', 63, 7761, 9127),
('West Virginia', 'M', 64, 7732, 9011),
('West Virginia', 'M', 65, 7773, 9372),
('West Virginia', 'M', 66, 6825, 8290),
('West Virginia', 'M', 67, 6632, 7702),
('West Virginia', 'M', 68, 6635, 7183),
('West Virginia', 'M', 69, 6562, 7183),
('West Virginia', 'M', 70, 6733, 6893),
('West Virginia', 'M', 71, 6332, 6182),
('West Virginia', 'M', 72, 6724, 5973),
('West Virginia', 'M', 73, 6235, 6009),
('West Virginia', 'M', 74, 5783, 5073),
('West Virginia', 'M', 75, 5637, 4835),
('West Virginia', 'M', 76, 5320, 4733),
('West Virginia', 'M', 77, 4678, 4507),
('West Virginia', 'M', 78, 4378, 4513),
('West Virginia', 'M', 79, 3948, 3985),
('West Virginia', 'M', 80, 3423, 4133),
('West Virginia', 'M', 81, 3002, 3715),
('West Virginia', 'M', 82, 2705, 3195),
('West Virginia', 'M', 83, 2256, 2997),
('West Virginia', 'M', 84, 2057, 2694),
('West Virginia', 'M', 85, 9011, 12061),
('West Virginia', 'F', 0, 10001, 10278),
('West Virginia', 'F', 1, 9944, 10300),
('West Virginia', 'F', 2, 9734, 10308),
('West Virginia', 'F', 3, 9896, 10087),
('West Virginia', 'F', 4, 10177, 10453),
('West Virginia', 'F', 5, 10074, 10346),
('West Virginia', 'F', 6, 10338, 10386),
('West Virginia', 'F', 7, 10573, 10317),
('West Virginia', 'F', 8, 11201, 10323),
('West Virginia', 'F', 9, 11317, 10306),
('West Virginia', 'F', 10, 11461, 10048),
('West Virginia', 'F', 11, 11081, 10190),
('West Virginia', 'F', 12, 11017, 10543),
('West Virginia', 'F', 13, 11300, 10335),
('West Virginia', 'F', 14, 11436, 10604),
('West Virginia', 'F', 15, 11550, 10740),
('West Virginia', 'F', 16, 11561, 11428),
('West Virginia', 'F', 17, 12326, 11472),
('West Virginia', 'F', 18, 12508, 11599),
('West Virginia', 'F', 19, 13042, 11503),
('West Virginia', 'F', 20, 13297, 10860),
('West Virginia', 'F', 21, 12565, 10935),
('West Virginia', 'F', 22, 11923, 10807),
('West Virginia', 'F', 23, 11395, 10814),
('West Virginia', 'F', 24, 10572, 10268),
('West Virginia', 'F', 25, 10916, 10376),
('West Virginia', 'F', 26, 10422, 10963),
('West Virginia', 'F', 27, 11117, 12037),
('West Virginia', 'F', 28, 11568, 13026),
('West Virginia', 'F', 29, 11981, 12450),
('West Virginia', 'F', 30, 11724, 12065),
('West Virginia', 'F', 31, 11491, 11312),
('West Virginia', 'F', 32, 11305, 10465),
('West Virginia', 'F', 33, 11514, 11326),
('West Virginia', 'F', 34, 11725, 10714),
('West Virginia', 'F', 35, 12631, 11121),
('West Virginia', 'F', 36, 12990, 12092),
('West Virginia', 'F', 37, 13107, 12622),
('West Virginia', 'F', 38, 13274, 11965),
('West Virginia', 'F', 39, 13878, 11649),
('West Virginia', 'F', 40, 14093, 11419),
('West Virginia', 'F', 41, 14403, 11673),
('West Virginia', 'F', 42, 14541, 11810),
('West Virginia', 'F', 43, 14878, 12680),
('West Virginia', 'F', 44, 14411, 13083),
('West Virginia', 'F', 45, 14603, 13062),
('West Virginia', 'F', 46, 14268, 13219),
('West Virginia', 'F', 47, 14443, 13796),
('West Virginia', 'F', 48, 14064, 14041),
('West Virginia', 'F', 49, 13950, 14186),
('West Virginia', 'F', 50, 13724, 14310),
('West Virginia', 'F', 51, 13703, 14631),
('West Virginia', 'F', 52, 13369, 14044),
('West Virginia', 'F', 53, 14040, 14225),
('West Virginia', 'F', 54, 10213, 13798),
('West Virginia', 'F', 55, 10209, 13962),
('West Virginia', 'F', 56, 10148, 13415),
('West Virginia', 'F', 57, 10931, 13493),
('West Virginia', 'F', 58, 9877, 13198),
('West Virginia', 'F', 59, 9272, 13197),
('West Virginia', 'F', 60, 9164, 12853),
('West Virginia', 'F', 61, 9149, 13452),
('West Virginia', 'F', 62, 9143, 9704),
('West Virginia', 'F', 63, 8743, 9631),
('West Virginia', 'F', 64, 8613, 9445),
('West Virginia', 'F', 65, 8827, 10170),
('West Virginia', 'F', 66, 7867, 9027),
('West Virginia', 'F', 67, 8139, 8288),
('West Virginia', 'F', 68, 8158, 8171),
('West Virginia', 'F', 69, 8135, 7990),
('West Virginia', 'F', 70, 8465, 7926),
('West Virginia', 'F', 71, 8239, 7439),
('West Virginia', 'F', 72, 8229, 7250),
('West Virginia', 'F', 73, 7938, 7299),
('West Virginia', 'F', 74, 7717, 6362),
('West Virginia', 'F', 75, 7560, 6481),
('West Virginia', 'F', 76, 7478, 6427),
('West Virginia', 'F', 77, 6801, 6246),
('West Virginia', 'F', 78, 6847, 6379),
('West Virginia', 'F', 79, 6179, 5971),
('West Virginia', 'F', 80, 5800, 5883),
('West Virginia', 'F', 81, 5278, 5476),
('West Virginia', 'F', 82, 4935, 5158),
('West Virginia', 'F', 83, 4492, 4892),
('West Virginia', 'F', 84, 4150, 4563),
('West Virginia', 'F', 85, 23095, 26441),
('Wisconsin', 'M', 0, 35034, 37979),
('Wisconsin', 'M', 1, 34576, 38037),
('Wisconsin', 'M', 2, 34554, 36435),
('Wisconsin', 'M', 3, 35085, 36364),
('Wisconsin', 'M', 4, 35755, 36498),
('Wisconsin', 'M', 5, 36988, 36049),
('Wisconsin', 'M', 6, 37399, 35759),
('Wisconsin', 'M', 7, 38833, 36151),
('Wisconsin', 'M', 8, 39617, 36257),
('Wisconsin', 'M', 9, 40800, 35832),
('Wisconsin', 'M', 10, 41856, 35671),
('Wisconsin', 'M', 11, 41096, 36221),
('Wisconsin', 'M', 12, 40983, 36762),
('Wisconsin', 'M', 13, 41501, 37957),
('Wisconsin', 'M', 14, 41910, 38330),
('Wisconsin', 'M', 15, 42659, 39806),
('Wisconsin', 'M', 16, 41190, 40529),
('Wisconsin', 'M', 17, 42124, 41622),
('Wisconsin', 'M', 18, 41642, 40877),
('Wisconsin', 'M', 19, 41941, 41838),
('Wisconsin', 'M', 20, 41244, 40650),
('Wisconsin', 'M', 21, 38569, 40230),
('Wisconsin', 'M', 22, 36216, 40317),
('Wisconsin', 'M', 23, 34666, 40406),
('Wisconsin', 'M', 24, 32953, 37998),
('Wisconsin', 'M', 25, 33717, 38227),
('Wisconsin', 'M', 26, 31811, 40014),
('Wisconsin', 'M', 27, 32087, 39651),
('Wisconsin', 'M', 28, 34215, 40822),
('Wisconsin', 'M', 29, 36972, 38494),
('Wisconsin', 'M', 30, 38175, 36015),
('Wisconsin', 'M', 31, 36796, 34782),
('Wisconsin', 'M', 32, 36510, 33944),
('Wisconsin', 'M', 33, 37799, 35329),
('Wisconsin', 'M', 34, 38883, 33447),
('Wisconsin', 'M', 35, 41268, 33485),
('Wisconsin', 'M', 36, 42741, 35472),
('Wisconsin', 'M', 37, 43241, 38829),
('Wisconsin', 'M', 38, 44040, 39240),
('Wisconsin', 'M', 39, 45180, 38031),
('Wisconsin', 'M', 40, 45742, 37449),
('Wisconsin', 'M', 41, 44817, 38787),
('Wisconsin', 'M', 42, 44423, 40404),
('Wisconsin', 'M', 43, 44120, 42526),
('Wisconsin', 'M', 44, 42599, 43914),
('Wisconsin', 'M', 45, 42765, 44324),
('Wisconsin', 'M', 46, 41289, 44737),
('Wisconsin', 'M', 47, 40122, 45782),
('Wisconsin', 'M', 48, 39680, 46027),
('Wisconsin', 'M', 49, 37876, 44978),
('Wisconsin', 'M', 50, 36685, 44120),
('Wisconsin', 'M', 51, 35740, 43692),
('Wisconsin', 'M', 52, 34342, 42417),
('Wisconsin', 'M', 53, 36076, 41894),
('Wisconsin', 'M', 54, 26823, 40448),
('Wisconsin', 'M', 55, 26214, 39379),
('Wisconsin', 'M', 56, 26047, 38311),
('Wisconsin', 'M', 57, 27022, 36622),
('Wisconsin', 'M', 58, 23968, 35237),
('Wisconsin', 'M', 59, 21924, 34109),
('Wisconsin', 'M', 60, 21145, 32324),
('Wisconsin', 'M', 61, 20942, 33973),
('Wisconsin', 'M', 62, 20239, 24754),
('Wisconsin', 'M', 63, 19252, 24077),
('Wisconsin', 'M', 64, 18498, 23748),
('Wisconsin', 'M', 65, 18241, 24533),
('Wisconsin', 'M', 66, 16768, 21328),
('Wisconsin', 'M', 67, 16896, 19249),
('Wisconsin', 'M', 68, 16777, 18489),
('Wisconsin', 'M', 69, 16832, 17984),
('Wisconsin', 'M', 70, 16957, 17201),
('Wisconsin', 'M', 71, 16115, 16089),
('Wisconsin', 'M', 72, 15811, 15280),
('Wisconsin', 'M', 73, 15408, 14761),
('Wisconsin', 'M', 74, 14260, 13176),
('Wisconsin', 'M', 75, 13975, 13212),
('Wisconsin', 'M', 76, 12969, 12553),
('Wisconsin', 'M', 77, 12374, 12356),
('Wisconsin', 'M', 78, 11329, 12154),
('Wisconsin', 'M', 79, 10602, 11056),
('Wisconsin', 'M', 80, 9344, 10496),
('Wisconsin', 'M', 81, 8469, 9998),
('Wisconsin', 'M', 82, 7984, 8657),
('Wisconsin', 'M', 83, 7128, 8247),
('Wisconsin', 'M', 84, 6190, 7270),
('Wisconsin', 'M', 85, 27643, 36611),
('Wisconsin', 'F', 0, 33149, 36176),
('Wisconsin', 'F', 1, 33327, 36201),
('Wisconsin', 'F', 2, 33253, 35162),
('Wisconsin', 'F', 3, 33383, 34404),
('Wisconsin', 'F', 4, 34208, 35021),
('Wisconsin', 'F', 5, 35090, 34431),
('Wisconsin', 'F', 6, 35786, 34657),
('Wisconsin', 'F', 7, 36766, 34859),
('Wisconsin', 'F', 8, 37689, 34491),
('Wisconsin', 'F', 9, 38831, 34617),
('Wisconsin', 'F', 10, 39935, 34540),
('Wisconsin', 'F', 11, 38901, 34617),
('Wisconsin', 'F', 12, 38894, 35314),
('Wisconsin', 'F', 13, 39284, 36101),
('Wisconsin', 'F', 14, 40116, 36742),
('Wisconsin', 'F', 15, 40364, 37609),
('Wisconsin', 'F', 16, 39228, 38278),
('Wisconsin', 'F', 17, 39238, 38933),
('Wisconsin', 'F', 18, 39681, 38244),
('Wisconsin', 'F', 19, 40276, 40063),
('Wisconsin', 'F', 20, 40184, 40033),
('Wisconsin', 'F', 21, 37175, 39715),
('Wisconsin', 'F', 22, 34965, 39443),
('Wisconsin', 'F', 23, 32946, 37823),
('Wisconsin', 'F', 24, 31034, 35909),
('Wisconsin', 'F', 25, 31809, 34731),
('Wisconsin', 'F', 26, 30345, 39206),
('Wisconsin', 'F', 27, 31114, 36732),
('Wisconsin', 'F', 28, 33220, 37052),
('Wisconsin', 'F', 29, 36276, 34445),
('Wisconsin', 'F', 30, 36558, 33224),
('Wisconsin', 'F', 31, 35515, 33506),
('Wisconsin', 'F', 32, 35673, 32465),
('Wisconsin', 'F', 33, 37315, 34132),
('Wisconsin', 'F', 34, 38705, 32053),
('Wisconsin', 'F', 35, 40977, 32885),
('Wisconsin', 'F', 36, 42432, 34626),
('Wisconsin', 'F', 37, 43264, 37794),
('Wisconsin', 'F', 38, 44167, 37566),
('Wisconsin', 'F', 39, 45833, 36666),
('Wisconsin', 'F', 40, 45625, 36642),
('Wisconsin', 'F', 41, 44289, 38293),
('Wisconsin', 'F', 42, 44218, 39574),
('Wisconsin', 'F', 43, 43278, 41693),
('Wisconsin', 'F', 44, 41965, 43112),
('Wisconsin', 'F', 45, 42259, 43934),
('Wisconsin', 'F', 46, 40866, 44709),
('Wisconsin', 'F', 47, 39543, 46280),
('Wisconsin', 'F', 48, 38883, 45766),
('Wisconsin', 'F', 49, 36705, 44125),
('Wisconsin', 'F', 50, 36307, 44155),
('Wisconsin', 'F', 51, 34815, 43044),
('Wisconsin', 'F', 52, 34328, 41925),
('Wisconsin', 'F', 53, 35887, 41858),
('Wisconsin', 'F', 54, 26814, 40298),
('Wisconsin', 'F', 55, 26590, 38895),
('Wisconsin', 'F', 56, 26358, 38245),
('Wisconsin', 'F', 57, 28210, 35824),
('Wisconsin', 'F', 58, 25033, 35122),
('Wisconsin', 'F', 59, 23004, 33636),
('Wisconsin', 'F', 60, 21981, 32923),
('Wisconsin', 'F', 61, 21660, 34456),
('Wisconsin', 'F', 62, 21426, 25475),
('Wisconsin', 'F', 63, 20520, 25037),
('Wisconsin', 'F', 64, 20299, 24990),
('Wisconsin', 'F', 65, 19727, 26434),
('Wisconsin', 'F', 66, 18563, 23369),
('Wisconsin', 'F', 67, 18951, 21402),
('Wisconsin', 'F', 68, 19072, 20117),
('Wisconsin', 'F', 69, 19666, 19795),
('Wisconsin', 'F', 70, 19624, 19488),
('Wisconsin', 'F', 71, 18841, 18452),
('Wisconsin', 'F', 72, 19168, 18080),
('Wisconsin', 'F', 73, 18780, 17310),
('Wisconsin', 'F', 74, 17882, 16131),
('Wisconsin', 'F', 75, 18122, 16221),
('Wisconsin', 'F', 76, 17723, 16158),
('Wisconsin', 'F', 77, 17064, 16297),
('Wisconsin', 'F', 78, 16651, 16066),
('Wisconsin', 'F', 79, 16040, 15035),
('Wisconsin', 'F', 80, 14955, 15004),
('Wisconsin', 'F', 81, 13913, 14390),
('Wisconsin', 'F', 82, 13717, 13570),
('Wisconsin', 'F', 83, 12291, 13177),
('Wisconsin', 'F', 84, 11688, 12407),
('Wisconsin', 'F', 85, 68904, 80543),
('Wyoming', 'M', 0, 3236, 4066),
('Wyoming', 'M', 1, 3245, 4159),
('Wyoming', 'M', 2, 3102, 4058),
('Wyoming', 'M', 3, 3103, 3745),
('Wyoming', 'M', 4, 3166, 3633),
('Wyoming', 'M', 5, 3157, 3647),
('Wyoming', 'M', 6, 3421, 3667),
('Wyoming', 'M', 7, 3503, 3498),
('Wyoming', 'M', 8, 3577, 3479),
('Wyoming', 'M', 9, 3744, 3512),
('Wyoming', 'M', 10, 3835, 3381),
('Wyoming', 'M', 11, 3852, 3358),
('Wyoming', 'M', 12, 3881, 3484),
('Wyoming', 'M', 13, 4011, 3353),
('Wyoming', 'M', 14, 4161, 3648),
('Wyoming', 'M', 15, 4377, 3745),
('Wyoming', 'M', 16, 4356, 3815),
('Wyoming', 'M', 17, 4367, 4023),
('Wyoming', 'M', 18, 4309, 3819),
('Wyoming', 'M', 19, 4191, 4011),
('Wyoming', 'M', 20, 3824, 3769),
('Wyoming', 'M', 21, 3430, 3753),
('Wyoming', 'M', 22, 3314, 4090),
('Wyoming', 'M', 23, 3150, 4073),
('Wyoming', 'M', 24, 3011, 4255),
('Wyoming', 'M', 25, 3050, 3959),
('Wyoming', 'M', 26, 2862, 4329),
('Wyoming', 'M', 27, 2880, 4157),
('Wyoming', 'M', 28, 2939, 4060),
('Wyoming', 'M', 29, 3163, 3840),
('Wyoming', 'M', 30, 3128, 3417),
('Wyoming', 'M', 31, 2944, 3283),
('Wyoming', 'M', 32, 2851, 3193),
('Wyoming', 'M', 33, 2763, 3226),
('Wyoming', 'M', 34, 2936, 2999),
('Wyoming', 'M', 35, 3153, 3196),
('Wyoming', 'M', 36, 3366, 3216),
('Wyoming', 'M', 37, 3461, 3473),
('Wyoming', 'M', 38, 3624, 3464),
('Wyoming', 'M', 39, 3797, 3168),
('Wyoming', 'M', 40, 4114, 3143),
('Wyoming', 'M', 41, 4077, 2966),
('Wyoming', 'M', 42, 4194, 3130),
('Wyoming', 'M', 43, 4329, 3362),
('Wyoming', 'M', 44, 4311, 3525),
('Wyoming', 'M', 45, 4303, 3677),
('Wyoming', 'M', 46, 4286, 3733),
('Wyoming', 'M', 47, 4240, 3935),
('Wyoming', 'M', 48, 4045, 4216),
('Wyoming', 'M', 49, 3792, 4175),
('Wyoming', 'M', 50, 3767, 4248),
('Wyoming', 'M', 51, 3655, 4369),
('Wyoming', 'M', 52, 3597, 4347),
('Wyoming', 'M', 53, 3696, 4240),
('Wyoming', 'M', 54, 2668, 4208),
('Wyoming', 'M', 55, 2691, 4156),
('Wyoming', 'M', 56, 2680, 3958),
('Wyoming', 'M', 57, 2663, 3659),
('Wyoming', 'M', 58, 2485, 3685),
('Wyoming', 'M', 59, 2233, 3444),
('Wyoming', 'M', 60, 2133, 3459),
('Wyoming', 'M', 61, 2111, 3488),
('Wyoming', 'M', 62, 2026, 2498),
('Wyoming', 'M', 63, 1864, 2459),
('Wyoming', 'M', 64, 1761, 2477),
('Wyoming', 'M', 65, 1797, 2391),
('Wyoming', 'M', 66, 1538, 2207),
('Wyoming', 'M', 67, 1575, 1943),
('Wyoming', 'M', 68, 1606, 1826),
('Wyoming', 'M', 69, 1487, 1758),
('Wyoming', 'M', 70, 1513, 1659),
('Wyoming', 'M', 71, 1471, 1526),
('Wyoming', 'M', 72, 1445, 1427),
('Wyoming', 'M', 73, 1319, 1469),
('Wyoming', 'M', 74, 1272, 1166),
('Wyoming', 'M', 75, 1209, 1196),
('Wyoming', 'M', 76, 1142, 1188),
('Wyoming', 'M', 77, 1110, 1056),
('Wyoming', 'M', 78, 942, 1051),
('Wyoming', 'M', 79, 844, 961),
('Wyoming', 'M', 80, 826, 976),
('Wyoming', 'M', 81, 687, 845),
('Wyoming', 'M', 82, 634, 792),
('Wyoming', 'M', 83, 515, 726),
('Wyoming', 'M', 84, 490, 643),
('Wyoming', 'M', 85, 2050, 3096),
('Wyoming', 'F', 0, 2943, 3918),
('Wyoming', 'F', 1, 3010, 3942),
('Wyoming', 'F', 2, 3031, 3616),
('Wyoming', 'F', 3, 3058, 3667),
('Wyoming', 'F', 4, 2971, 3449),
('Wyoming', 'F', 5, 3121, 3484),
('Wyoming', 'F', 6, 3194, 3297),
('Wyoming', 'F', 7, 3256, 3268),
('Wyoming', 'F', 8, 3433, 3161),
('Wyoming', 'F', 9, 3482, 3218),
('Wyoming', 'F', 10, 3585, 3236),
('Wyoming', 'F', 11, 3547, 3328),
('Wyoming', 'F', 12, 3685, 3204),
('Wyoming', 'F', 13, 3912, 3315),
('Wyoming', 'F', 14, 3930, 3404),
('Wyoming', 'F', 15, 4142, 3466),
('Wyoming', 'F', 16, 4072, 3625),
('Wyoming', 'F', 17, 4143, 3588),
('Wyoming', 'F', 18, 3904, 3476),
('Wyoming', 'F', 19, 3820, 3697),
('Wyoming', 'F', 20, 3654, 3309),
('Wyoming', 'F', 21, 3370, 3424),
('Wyoming', 'F', 22, 3111, 3571),
('Wyoming', 'F', 23, 2929, 3742),
('Wyoming', 'F', 24, 2800, 3779),
('Wyoming', 'F', 25, 2839, 3447),
('Wyoming', 'F', 26, 2714, 4111),
('Wyoming', 'F', 27, 2782, 3487),
('Wyoming', 'F', 28, 2902, 3813),
('Wyoming', 'F', 29, 2982, 3895),
('Wyoming', 'F', 30, 3028, 3399),
('Wyoming', 'F', 31, 2857, 3202),
('Wyoming', 'F', 32, 2852, 2978),
('Wyoming', 'F', 33, 2764, 3068),
('Wyoming', 'F', 34, 2975, 2991),
('Wyoming', 'F', 35, 3253, 3057),
('Wyoming', 'F', 36, 3493, 3351),
('Wyoming', 'F', 37, 3634, 3115),
('Wyoming', 'F', 38, 3868, 3270),
('Wyoming', 'F', 39, 4032, 3043),
('Wyoming', 'F', 40, 4135, 3017),
('Wyoming', 'F', 41, 4195, 3050),
('Wyoming', 'F', 42, 4175, 3199),
('Wyoming', 'F', 43, 4335, 3366),
('Wyoming', 'F', 44, 4214, 3574),
('Wyoming', 'F', 45, 4332, 3800),
('Wyoming', 'F', 46, 4199, 3966),
('Wyoming', 'F', 47, 4011, 4211),
('Wyoming', 'F', 48, 3779, 4238),
('Wyoming', 'F', 49, 3790, 4145),
('Wyoming', 'F', 50, 3616, 4138),
('Wyoming', 'F', 51, 3316, 4270),
('Wyoming', 'F', 52, 3292, 4133),
('Wyoming', 'F', 53, 3490, 4278),
('Wyoming', 'F', 54, 2481, 4026),
('Wyoming', 'F', 55, 2599, 3916),
('Wyoming', 'F', 56, 2585, 3654),
('Wyoming', 'F', 57, 2600, 3609),
('Wyoming', 'F', 58, 2315, 3432),
('Wyoming', 'F', 59, 2170, 3193),
('Wyoming', 'F', 60, 2085, 3179),
('Wyoming', 'F', 61, 1995, 3345),
('Wyoming', 'F', 62, 1957, 2389),
('Wyoming', 'F', 63, 1881, 2442),
('Wyoming', 'F', 64, 1886, 2317),
('Wyoming', 'F', 65, 1815, 2415),
('Wyoming', 'F', 66, 1756, 2171),
('Wyoming', 'F', 67, 1680, 1967),
('Wyoming', 'F', 68, 1653, 1873),
('Wyoming', 'F', 69, 1671, 1682),
('Wyoming', 'F', 70, 1685, 1680),
('Wyoming', 'F', 71, 1639, 1594),
('Wyoming', 'F', 72, 1564, 1628),
('Wyoming', 'F', 73, 1426, 1534),
('Wyoming', 'F', 74, 1414, 1464),
('Wyoming', 'F', 75, 1462, 1366),
('Wyoming', 'F', 76, 1342, 1342),
('Wyoming', 'F', 77, 1312, 1318),
('Wyoming', 'F', 78, 1241, 1287),
('Wyoming', 'F', 79, 1242, 1279),
('Wyoming', 'F', 80, 1097, 1194),
('Wyoming', 'F', 81, 1000, 1089),
('Wyoming', 'F', 82, 963, 1006),
('Wyoming', 'F', 83, 866, 1056),
('Wyoming', 'F', 84, 801, 878),
('Wyoming', 'F', 85, 4763, 5889);
"""
)

oven.engine.execute(
    """CREATE TABLE IF NOT EXISTS state_fact
(id text, name text, abbreviation text, country
text, type text, sort text, status text, occupied text, notes text,
fips_state text, assoc_press text, standard_federal_region text,
census_region text, census_region_name text, census_division text,
census_division_name text, circuit_court text);"""
)

oven.engine.execute(
    """insert into state_fact VALUES
('42','Tennessee','TN','USA','state','10','current','occupied','','47',
 'Tenn.','IV','3','South','6','East South Central','6'),
('45','Vermont','VT','USA','state','10','current','occupied','','50','Vt.',
 'I','1','Northeast','1','New England','2');"""
)

import yaml

class MyTable(Base):
    first = Column('first', String(), primary_key=True)
    last = Column('last', String())
    age = Column('age', Integer())
    birth_date = Column('birth_date', Date())
    dt = Column('dt', DateTime())

    __tablename__ = 'foo'
    __table_args__ = {'extend_existing': True}


class Scores(Base):
    username = Column('username', String(), primary_key=True)
    department = Column('department', String())
    testid = Column('testid', String())
    score = Column('score', Float())

    __tablename__ = 'scores'
    __table_args__ = {'extend_existing': True}


class TagScores(Base):
    username = Column('username', String(), primary_key=True)
    department = Column('department', String())
    tag = Column('tag', String())
    testid = Column('testid', String())
    score = Column('score', Float())

    __tablename__ = 'tagscores'
    __table_args__ = {'extend_existing': True}


class Census(Base):
    state = Column('state', String(), primary_key=True)
    gender = Column('gender', String())
    age = Column('age', Integer())
    pop2000 = Column('pop2000', Integer())
    pop2008 = Column('pop2008', Integer())

    __tablename__ = 'census'
    __table_args__ = {'extend_existing': True}


class StateFact(Base):
    id = Column('id', String(), primary_key=True)
    name = Column('name', String())
    abbreviation = Column('abbreviation', String())
    country = Column('country', String())
    type = Column('type', String())
    sort = Column('sort', String())
    status = Column('status', String())
    occupied = Column('occupied', String())
    notes = Column('notes', String())
    fips_state = Column('fips_state', String())
    assoc_press = Column('assoc_press', String())
    standard_federal_region = Column('standard_federal_region', String())
    census_region = Column('census_region', String())
    census_region_name = Column('census_region_name', String())
    census_division = Column('census_division', String())
    census_division_name = Column('census_division_name', String())
    circuit_court = Column('circuit_court', String())

    __tablename__ = 'state_fact'
    __table_args__ = {'extend_existing': True}


mytable_shelf = Shelf({
    'first': Dimension(MyTable.first),
    'last': Dimension(MyTable.last),
    'firstlast': Dimension(MyTable.last, id_expression=MyTable.first),
    'age': Metric(func.sum(MyTable.age)),
})

mytable_extrarole_shelf = Shelf({
    'first':
        Dimension(MyTable.first),
    'last':
        Dimension(MyTable.last),
    'firstlastage':
        Dimension(
            MyTable.last,
            id_expression=MyTable.first,
            age_expression=MyTable.age
        ),
    'age':
        Metric(func.sum(MyTable.age)),
})

scores_shelf = Shelf({
    'username':
        Dimension(Scores.username),
    'department':
        Dimension(Scores.department, anonymizer=lambda value: value[::-1]),
    'testid':
        Dimension(Scores.testid),
    'test_cnt':
        Metric(func.count(distinct(TagScores.testid))),
    'score':
        Metric(func.avg(Scores.score))
})

tagscores_shelf = Shelf({
    'username': Dimension(TagScores.username),
    'department': Dimension(TagScores.department),
    'testid': Dimension(TagScores.testid),
    'tag': Dimension(TagScores.tag),
    'test_cnt': Metric(func.count(distinct(TagScores.testid))),
    'score': Metric(func.avg(TagScores.score), summary_aggregation=func.sum)
})

census_shelf = Shelf({
    'state':
        Dimension(Census.state),
    'gender':
        Dimension(Census.gender),
    'age':
        Dimension(Census.age),
    'pop2000':
        Metric(func.sum(Census.pop2000)),
    'pop2000_sum':
        Metric(func.sum(Census.pop2000), summary_aggregation=func.sum),
    'pop2008':
        Metric(func.sum(Census.pop2008)),
})

statefact_shelf = Shelf({
    'state': Dimension(StateFact.name),
    'abbreviation': Dimension(StateFact.abbreviation),
})

class Census(Base):
    state = Column('state', String(), primary_key=True)
    sex = Column('sex', String())
    age = Column('age', Integer())
    pop2000 = Column('pop2000', Integer())
    pop2008 = Column('pop2008', Integer())

    __tablename__ = 'census'
    __table_args__ = {'extend_existing': True}

shelf = Shelf({
    'state': Dimension(Census.state),
    'age': WtdAvgMetric(Census.age, Census.pop2000),
    'population': Metric(func.sum(Census.pop2000))
})

r = Recipe(shelf=shelf, session=oven.Session())\
    .dimensions('state')\
    .metrics('age')\
    .order_by('-age')

print(r.dataset.csv)

print(r.to_sql())
print(r.total_count())

s = """
state:
    kind: Dimension
    field: state
age:
    kind: WtdAvgMetric
    field: age
    weight: pop2000
population:
    kind: Metric
    field: pop2000
"""

shelf_yaml = yaml.load(s)

print(shelf)

s = Shelf.from_config(shelf_yaml, Census)

print(s)

r = """
metrics:
- age
- population
dimensions:
- state
order_by:
- '-age'
"""

recipe_yaml = yaml.load(r)
recipe = Recipe.from_config(s, recipe_yaml, session=oven.Session())
print(recipe)
print(recipe.dataset.csv)


recipe_yaml = yaml.load(r)
recipe = Recipe.from_config(s, recipe_yaml, session=oven.Session(), 
    extension_classes=(AutomaticFilters, CompareRecipe))\
    .automatic_filters({'state__like': 'C%'})\
    .compare(Recipe(shelf=s, session=oven.Session()).metrics('age'))
print(recipe.to_sql())
print(recipe.dataset.csv)



shelf = Shelf({
    'state': Dimension(Census.state),
    'gender_desc': Dimension(Census.gender, lookup={'M': 'Male',
        'F': 'Female'}, lookup_default='Unknown'),
    'age': WtdAvgMetric(Census.age, Census.pop2000),
    'population': Metric(func.sum(Census.pop2000))
})

recipe = Recipe(shelf=shelf, session=oven.Session())\
    .dimensions('gender_desc').metrics('population')
print(recipe.to_sql())
print(recipe.dataset.csv)



shelf = Shelf({
    'state': Dimension(Census.state),
    'age': WtdAvgMetric(Census.age, Census.pop2000),
    'gender': Dimension(Census.gender),
    'population': Metric(func.sum(Census.pop2000), formatters=[
        lambda value: int(round(value, -6) / 1000000)
    ])
})

recipe = Recipe(shelf=shelf, session=oven.Session())\
    .dimensions('gender').metrics('population')

for row in recipe.all():
    print('{} has {} million people'.format(row.gender, row.population))
    print('\tThe original value is: {}'.format(row.population_raw))

shelf = Shelf({
    'state': Dimension(Census.state),
    'age': WtdAvgMetric(Census.age, Census.pop2000),
    'gender': Dimension(Census.gender),
    'population': Metric(func.sum(Census.pop2000))
})


shelf = Shelf({
    'age': Dimension(Census.age),
    'state': Dimension(Census.state),
    'population': Metric(func.sum(Census.pop2000)),
    'teens': Filter(Census.age.between(13,19)),
})
recipe = Recipe(shelf=shelf, session=oven.Session())\
    .dimensions('state')\
    .metrics('population')\
    .filters('teens')

print(recipe.to_sql())
print(recipe.dataset.csv)

shelf = Shelf({
    'age': Dimension(Census.age),
    'avgage': WtdAvgMetric(Census.age, Census.pop2000),
    'state': Dimension(Census.state),
    'population': Metric(func.sum(Census.pop2000)),
})
bigger = shelf['population'].build_filter(10000000, operator='gt')

recipe = Recipe(shelf=shelf, session=oven.Session())\
    .dimensions('state')\
    .metrics('population')\
    .order_by('-population')\
    .filters(bigger)

print(recipe.to_sql())
print(recipe.dataset.csv)

shelf = Shelf({
    'state': Dimension(Census.state),
    'avgage': WtdAvgMetric(Census.age, Census.pop2000),
})
recipe = Recipe(shelf=shelf, session=oven.Session())\
    .dimensions('state').metrics('avgage')

print(recipe.to_sql())
print(recipe.dataset.csv)


shelf = Shelf({
    'state': Dimension(Census.state),
    'popgrowth': DivideMetric(func.sum(Census.pop2008-Census.pop2000), func.sum(Census.pop2000)),
})
recipe = Recipe(shelf=shelf, session=oven.Session())\
    .dimensions('state').metrics('popgrowth')

print(recipe.to_sql())
print(recipe.dataset.csv)


shelf = Shelf({
    'total_population': Metric(func.sum(Census.pop2000)),
    'min_population': Metric(func.min(Census.pop2000)),
    'max_population': Metric(func.max(Census.pop2000))
})
recipe = Recipe(shelf=shelf, session=oven.Session())\
    .metrics('total_population', 'min_population', 'max_population')
print(recipe.to_sql())
print(recipe.dataset.csv)


s = '''
teens:
    kind: Metric
    field: 
        value: pop2000
        condition:
            field: age
            between: [13,19]
state:
    kind: Dimension
    field: state
'''
shelf_yaml = yaml.load(s)

shelf = Shelf.from_config(shelf_yaml, Census)
recipe = Recipe(shelf=shelf, session=oven.Session())\
    .dimensions('state')\
    .metrics('teens')
print(recipe.to_sql())
print(recipe.dataset.csv)


s = '''
teens:
    kind: Metric
    field: 
        value: pop2000
        condition:
            field: age
            between: [13,19]
total_pop:
    kind: Metric
    field: pop2000
pct_teens:
    field: '@teens'
    divide_by: '@total_pop'
state:
    kind: Dimension
    field: state
'''
shelf_yaml = yaml.load(s)

shelf = Shelf.from_config(shelf_yaml, Census)
recipe = Recipe(shelf=shelf, session=oven.Session())\
    .dimensions('state')\
    .metrics('pct_teens')
print(recipe.to_sql())
print(recipe.dataset.csv)

s = '''
total_pop:
    kind: Metric
    field: pop2000
age_buckets:
    kind: Dimension
    field: age
    buckets:
    - label: 'babies'
      lt: 2
    - label: 'children'
      lt: 13
    - label: 'teens'
      lt: 20
    buckets_default_label: 'oldsters'
mixed_buckets:
    kind: Dimension
    field: age
    buckets:
    - label: 'northeasterners'
      field: state
      in: ['Vermont', 'New Hampshire']
    - label: 'babies'
      lt: 2
    - label: 'children'
      lt: 13
    - label: 'teens'
      lt: 20
    buckets_default_label: 'oldsters'
'''
shelf_yaml = yaml.load(s)

shelf = Shelf.from_config(shelf_yaml, Census)
recipe = Recipe(shelf=shelf, session=oven.Session())\
    .dimensions('mixed_buckets')\
    .metrics('total_pop')\
    .order_by('mixed_buckets')
print(recipe.to_sql())
print(recipe.dataset.csv)
