import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface StorageBucketConfig extends cdktf.TerraformMetaArguments {
    /**
     * Enables Bucket Policy Only access to a bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#bucket_policy_only StorageBucket#bucket_policy_only}
     *
     * @stability stable
     */
    readonly bucketPolicyOnly?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#default_event_based_hold StorageBucket#default_event_based_hold}.
     *
     * @stability stable
     */
    readonly defaultEventBasedHold?: boolean | cdktf.IResolvable;
    /**
     * When deleting a bucket, this boolean option will delete all contained objects.
     *
     * If you try to delete a bucket that contains objects, Terraform will fail that run.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#force_destroy StorageBucket#force_destroy}
     *
     * @stability stable
     */
    readonly forceDestroy?: boolean | cdktf.IResolvable;
    /**
     * A set of key/value label pairs to assign to the bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#labels StorageBucket#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The Google Cloud Storage location.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#location StorageBucket#location}
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * The name of the bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#name StorageBucket#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#project StorageBucket#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Enables Requester Pays on a storage bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#requester_pays StorageBucket#requester_pays}
     *
     * @stability stable
     */
    readonly requesterPays?: boolean | cdktf.IResolvable;
    /**
     * The Storage Class of the new bucket. Supported values include: STANDARD, MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#storage_class StorageBucket#storage_class}
     *
     * @stability stable
     */
    readonly storageClass?: string;
    /**
     * Enables uniform bucket-level access on a bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#uniform_bucket_level_access StorageBucket#uniform_bucket_level_access}
     *
     * @stability stable
     */
    readonly uniformBucketLevelAccess?: boolean | cdktf.IResolvable;
    /**
     * cors block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#cors StorageBucket#cors}
     *
     * @stability stable
     */
    readonly cors?: StorageBucketCors[];
    /**
     * encryption block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#encryption StorageBucket#encryption}
     *
     * @stability stable
     */
    readonly encryption?: StorageBucketEncryption;
    /**
     * lifecycle_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#lifecycle_rule StorageBucket#lifecycle_rule}
     *
     * @stability stable
     */
    readonly lifecycleRule?: StorageBucketLifecycleRule[];
    /**
     * logging block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#logging StorageBucket#logging}
     *
     * @stability stable
     */
    readonly logging?: StorageBucketLogging;
    /**
     * retention_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#retention_policy StorageBucket#retention_policy}
     *
     * @stability stable
     */
    readonly retentionPolicy?: StorageBucketRetentionPolicy;
    /**
     * versioning block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#versioning StorageBucket#versioning}
     *
     * @stability stable
     */
    readonly versioning?: StorageBucketVersioning;
    /**
     * website block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#website StorageBucket#website}
     *
     * @stability stable
     */
    readonly website?: StorageBucketWebsite;
}
/**
 * @stability stable
 */
export interface StorageBucketCors {
    /**
     * The value, in seconds, to return in the Access-Control-Max-Age header used in preflight responses.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#max_age_seconds StorageBucket#max_age_seconds}
     *
     * @stability stable
     */
    readonly maxAgeSeconds?: number;
    /**
     * The list of HTTP methods on which to include CORS response headers, (GET, OPTIONS, POST, etc) Note: "*" is permitted in the list of methods, and means "any method".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#method StorageBucket#method}
     *
     * @stability stable
     */
    readonly method?: string[];
    /**
     * The list of Origins eligible to receive CORS response headers.
     *
     * Note: "*" is permitted in the list of origins, and means "any Origin".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#origin StorageBucket#origin}
     *
     * @stability stable
     */
    readonly origin?: string[];
    /**
     * The list of HTTP headers other than the simple response headers to give permission for the user-agent to share across domains.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#response_header StorageBucket#response_header}
     *
     * @stability stable
     */
    readonly responseHeader?: string[];
}
export declare function storageBucketCorsToTerraform(struct?: StorageBucketCors): any;
/**
 * @stability stable
 */
export interface StorageBucketEncryption {
    /**
     * A Cloud KMS key that will be used to encrypt objects inserted into this bucket, if no encryption method is specified.
     *
     * You must pay attention to whether the crypto key is available in the location that this bucket is created in. See the docs for more details.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#default_kms_key_name StorageBucket#default_kms_key_name}
     *
     * @stability stable
     */
    readonly defaultKmsKeyName: string;
}
export declare function storageBucketEncryptionToTerraform(struct?: StorageBucketEncryptionOutputReference | StorageBucketEncryption): any;
/**
 * @stability stable
 */
export declare class StorageBucketEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageBucketEncryption | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageBucketEncryption | undefined);
    private _defaultKmsKeyName?;
    /**
     * @stability stable
     */
    get defaultKmsKeyName(): string;
    /**
     * @stability stable
     */
    set defaultKmsKeyName(value: string);
    /**
     * @stability stable
     */
    get defaultKmsKeyNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface StorageBucketLifecycleRuleAction {
    /**
     * The target Storage Class of objects affected by this Lifecycle Rule. Supported values include: MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#storage_class StorageBucket#storage_class}
     *
     * @stability stable
     */
    readonly storageClass?: string;
    /**
     * The type of the action of this Lifecycle Rule. Supported values include: Delete and SetStorageClass.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#type StorageBucket#type}
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function storageBucketLifecycleRuleActionToTerraform(struct?: StorageBucketLifecycleRuleActionOutputReference | StorageBucketLifecycleRuleAction): any;
/**
 * @stability stable
 */
export declare class StorageBucketLifecycleRuleActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageBucketLifecycleRuleAction | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageBucketLifecycleRuleAction | undefined);
    private _storageClass?;
    /**
     * @stability stable
     */
    get storageClass(): string;
    /**
     * @stability stable
     */
    set storageClass(value: string);
    /**
     * @stability stable
     */
    resetStorageClass(): void;
    /**
     * @stability stable
     */
    get storageClassInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface StorageBucketLifecycleRuleCondition {
    /**
     * Minimum age of an object in days to satisfy this condition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#age StorageBucket#age}
     *
     * @stability stable
     */
    readonly age?: number;
    /**
     * Creation date of an object in RFC 3339 (e.g. 2017-06-13) to satisfy this condition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#created_before StorageBucket#created_before}
     *
     * @stability stable
     */
    readonly createdBefore?: string;
    /**
     * Creation date of an object in RFC 3339 (e.g. 2017-06-13) to satisfy this condition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#custom_time_before StorageBucket#custom_time_before}
     *
     * @stability stable
     */
    readonly customTimeBefore?: string;
    /**
     * Number of days elapsed since the user-specified timestamp set on an object.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#days_since_custom_time StorageBucket#days_since_custom_time}
     *
     * @stability stable
     */
    readonly daysSinceCustomTime?: number;
    /**
     * Number of days elapsed since the noncurrent timestamp of an object. This 							condition is relevant only for versioned objects.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#days_since_noncurrent_time StorageBucket#days_since_noncurrent_time}
     *
     * @stability stable
     */
    readonly daysSinceNoncurrentTime?: number;
    /**
     * Storage Class of objects to satisfy this condition. Supported values include: MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE, STANDARD, DURABLE_REDUCED_AVAILABILITY.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#matches_storage_class StorageBucket#matches_storage_class}
     *
     * @stability stable
     */
    readonly matchesStorageClass?: string[];
    /**
     * Creation date of an object in RFC 3339 (e.g. 2017-06-13) to satisfy this condition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#noncurrent_time_before StorageBucket#noncurrent_time_before}
     *
     * @stability stable
     */
    readonly noncurrentTimeBefore?: string;
    /**
     * Relevant only for versioned objects. The number of newer versions of an object to satisfy this condition.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#num_newer_versions StorageBucket#num_newer_versions}
     *
     * @stability stable
     */
    readonly numNewerVersions?: number;
    /**
     * Match to live and/or archived objects. Unversioned buckets have only live objects. Supported values include: "LIVE", "ARCHIVED", "ANY".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#with_state StorageBucket#with_state}
     *
     * @stability stable
     */
    readonly withState?: string;
}
export declare function storageBucketLifecycleRuleConditionToTerraform(struct?: StorageBucketLifecycleRuleConditionOutputReference | StorageBucketLifecycleRuleCondition): any;
/**
 * @stability stable
 */
export declare class StorageBucketLifecycleRuleConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageBucketLifecycleRuleCondition | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageBucketLifecycleRuleCondition | undefined);
    private _age?;
    /**
     * @stability stable
     */
    get age(): number;
    /**
     * @stability stable
     */
    set age(value: number);
    /**
     * @stability stable
     */
    resetAge(): void;
    /**
     * @stability stable
     */
    get ageInput(): number | undefined;
    private _createdBefore?;
    /**
     * @stability stable
     */
    get createdBefore(): string;
    /**
     * @stability stable
     */
    set createdBefore(value: string);
    /**
     * @stability stable
     */
    resetCreatedBefore(): void;
    /**
     * @stability stable
     */
    get createdBeforeInput(): string | undefined;
    private _customTimeBefore?;
    /**
     * @stability stable
     */
    get customTimeBefore(): string;
    /**
     * @stability stable
     */
    set customTimeBefore(value: string);
    /**
     * @stability stable
     */
    resetCustomTimeBefore(): void;
    /**
     * @stability stable
     */
    get customTimeBeforeInput(): string | undefined;
    private _daysSinceCustomTime?;
    /**
     * @stability stable
     */
    get daysSinceCustomTime(): number;
    /**
     * @stability stable
     */
    set daysSinceCustomTime(value: number);
    /**
     * @stability stable
     */
    resetDaysSinceCustomTime(): void;
    /**
     * @stability stable
     */
    get daysSinceCustomTimeInput(): number | undefined;
    private _daysSinceNoncurrentTime?;
    /**
     * @stability stable
     */
    get daysSinceNoncurrentTime(): number;
    /**
     * @stability stable
     */
    set daysSinceNoncurrentTime(value: number);
    /**
     * @stability stable
     */
    resetDaysSinceNoncurrentTime(): void;
    /**
     * @stability stable
     */
    get daysSinceNoncurrentTimeInput(): number | undefined;
    private _matchesStorageClass?;
    /**
     * @stability stable
     */
    get matchesStorageClass(): string[];
    /**
     * @stability stable
     */
    set matchesStorageClass(value: string[]);
    /**
     * @stability stable
     */
    resetMatchesStorageClass(): void;
    /**
     * @stability stable
     */
    get matchesStorageClassInput(): string[] | undefined;
    private _noncurrentTimeBefore?;
    /**
     * @stability stable
     */
    get noncurrentTimeBefore(): string;
    /**
     * @stability stable
     */
    set noncurrentTimeBefore(value: string);
    /**
     * @stability stable
     */
    resetNoncurrentTimeBefore(): void;
    /**
     * @stability stable
     */
    get noncurrentTimeBeforeInput(): string | undefined;
    private _numNewerVersions?;
    /**
     * @stability stable
     */
    get numNewerVersions(): number;
    /**
     * @stability stable
     */
    set numNewerVersions(value: number);
    /**
     * @stability stable
     */
    resetNumNewerVersions(): void;
    /**
     * @stability stable
     */
    get numNewerVersionsInput(): number | undefined;
    private _withState?;
    /**
     * @stability stable
     */
    get withState(): string;
    /**
     * @stability stable
     */
    set withState(value: string);
    /**
     * @stability stable
     */
    resetWithState(): void;
    /**
     * @stability stable
     */
    get withStateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface StorageBucketLifecycleRule {
    /**
     * action block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#action StorageBucket#action}
     *
     * @stability stable
     */
    readonly action: StorageBucketLifecycleRuleAction;
    /**
     * condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#condition StorageBucket#condition}
     *
     * @stability stable
     */
    readonly condition: StorageBucketLifecycleRuleCondition;
}
export declare function storageBucketLifecycleRuleToTerraform(struct?: StorageBucketLifecycleRule): any;
/**
 * @stability stable
 */
export interface StorageBucketLogging {
    /**
     * The bucket that will receive log objects.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#log_bucket StorageBucket#log_bucket}
     *
     * @stability stable
     */
    readonly logBucket: string;
    /**
     * The object prefix for log objects.
     *
     * If it's not provided, by default Google Cloud Storage sets this to this bucket's name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#log_object_prefix StorageBucket#log_object_prefix}
     *
     * @stability stable
     */
    readonly logObjectPrefix?: string;
}
export declare function storageBucketLoggingToTerraform(struct?: StorageBucketLoggingOutputReference | StorageBucketLogging): any;
/**
 * @stability stable
 */
export declare class StorageBucketLoggingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageBucketLogging | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageBucketLogging | undefined);
    private _logBucket?;
    /**
     * @stability stable
     */
    get logBucket(): string;
    /**
     * @stability stable
     */
    set logBucket(value: string);
    /**
     * @stability stable
     */
    get logBucketInput(): string | undefined;
    private _logObjectPrefix?;
    /**
     * @stability stable
     */
    get logObjectPrefix(): string;
    /**
     * @stability stable
     */
    set logObjectPrefix(value: string);
    /**
     * @stability stable
     */
    resetLogObjectPrefix(): void;
    /**
     * @stability stable
     */
    get logObjectPrefixInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface StorageBucketRetentionPolicy {
    /**
     * If set to true, the bucket will be locked and permanently restrict edits to the bucket's retention policy.
     *
     * Caution: Locking a bucket is an irreversible action.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#is_locked StorageBucket#is_locked}
     *
     * @stability stable
     */
    readonly isLocked?: boolean | cdktf.IResolvable;
    /**
     * The period of time, in seconds, that objects in the bucket must be retained and cannot be deleted, overwritten, or archived.
     *
     * The value must be less than 3,155,760,000 seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#retention_period StorageBucket#retention_period}
     *
     * @stability stable
     */
    readonly retentionPeriod: number;
}
export declare function storageBucketRetentionPolicyToTerraform(struct?: StorageBucketRetentionPolicyOutputReference | StorageBucketRetentionPolicy): any;
/**
 * @stability stable
 */
export declare class StorageBucketRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageBucketRetentionPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageBucketRetentionPolicy | undefined);
    private _isLocked?;
    /**
     * @stability stable
     */
    get isLocked(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isLocked(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetIsLocked(): void;
    /**
     * @stability stable
     */
    get isLockedInput(): boolean | cdktf.IResolvable | undefined;
    private _retentionPeriod?;
    /**
     * @stability stable
     */
    get retentionPeriod(): number;
    /**
     * @stability stable
     */
    set retentionPeriod(value: number);
    /**
     * @stability stable
     */
    get retentionPeriodInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface StorageBucketVersioning {
    /**
     * While set to true, versioning is fully enabled for this bucket.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#enabled StorageBucket#enabled}
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function storageBucketVersioningToTerraform(struct?: StorageBucketVersioningOutputReference | StorageBucketVersioning): any;
/**
 * @stability stable
 */
export declare class StorageBucketVersioningOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageBucketVersioning | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageBucketVersioning | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface StorageBucketWebsite {
    /**
     * Behaves as the bucket's directory index where missing objects are treated as potential directories.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#main_page_suffix StorageBucket#main_page_suffix}
     *
     * @stability stable
     */
    readonly mainPageSuffix?: string;
    /**
     * The custom object to return when a requested resource is not found.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html#not_found_page StorageBucket#not_found_page}
     *
     * @stability stable
     */
    readonly notFoundPage?: string;
}
export declare function storageBucketWebsiteToTerraform(struct?: StorageBucketWebsiteOutputReference | StorageBucketWebsite): any;
/**
 * @stability stable
 */
export declare class StorageBucketWebsiteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): StorageBucketWebsite | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: StorageBucketWebsite | undefined);
    private _mainPageSuffix?;
    /**
     * @stability stable
     */
    get mainPageSuffix(): string;
    /**
     * @stability stable
     */
    set mainPageSuffix(value: string);
    /**
     * @stability stable
     */
    resetMainPageSuffix(): void;
    /**
     * @stability stable
     */
    get mainPageSuffixInput(): string | undefined;
    private _notFoundPage?;
    /**
     * @stability stable
     */
    get notFoundPage(): string;
    /**
     * @stability stable
     */
    set notFoundPage(value: string);
    /**
     * @stability stable
     */
    resetNotFoundPage(): void;
    /**
     * @stability stable
     */
    get notFoundPageInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html google_storage_bucket}.
 *
 * @stability stable
 */
export declare class StorageBucket extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_bucket.html google_storage_bucket} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: StorageBucketConfig);
    private _bucketPolicyOnly?;
    /**
     * @stability stable
     */
    get bucketPolicyOnly(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set bucketPolicyOnly(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetBucketPolicyOnly(): void;
    /**
     * @stability stable
     */
    get bucketPolicyOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _defaultEventBasedHold?;
    /**
     * @stability stable
     */
    get defaultEventBasedHold(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set defaultEventBasedHold(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDefaultEventBasedHold(): void;
    /**
     * @stability stable
     */
    get defaultEventBasedHoldInput(): boolean | cdktf.IResolvable | undefined;
    private _forceDestroy?;
    /**
     * @stability stable
     */
    get forceDestroy(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set forceDestroy(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetForceDestroy(): void;
    /**
     * @stability stable
     */
    get forceDestroyInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _requesterPays?;
    /**
     * @stability stable
     */
    get requesterPays(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set requesterPays(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequesterPays(): void;
    /**
     * @stability stable
     */
    get requesterPaysInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _storageClass?;
    /**
     * @stability stable
     */
    get storageClass(): string;
    /**
     * @stability stable
     */
    set storageClass(value: string);
    /**
     * @stability stable
     */
    resetStorageClass(): void;
    /**
     * @stability stable
     */
    get storageClassInput(): string | undefined;
    private _uniformBucketLevelAccess?;
    /**
     * @stability stable
     */
    get uniformBucketLevelAccess(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set uniformBucketLevelAccess(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetUniformBucketLevelAccess(): void;
    /**
     * @stability stable
     */
    get uniformBucketLevelAccessInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get url(): string;
    private _cors?;
    /**
     * @stability stable
     */
    get cors(): StorageBucketCors[];
    /**
     * @stability stable
     */
    set cors(value: StorageBucketCors[]);
    /**
     * @stability stable
     */
    resetCors(): void;
    /**
     * @stability stable
     */
    get corsInput(): StorageBucketCors[] | undefined;
    private _encryption;
    /**
     * @stability stable
     */
    get encryption(): StorageBucketEncryptionOutputReference;
    /**
     * @stability stable
     */
    putEncryption(value: StorageBucketEncryption): void;
    /**
     * @stability stable
     */
    resetEncryption(): void;
    /**
     * @stability stable
     */
    get encryptionInput(): StorageBucketEncryption | undefined;
    private _lifecycleRule?;
    /**
     * @stability stable
     */
    get lifecycleRule(): StorageBucketLifecycleRule[];
    /**
     * @stability stable
     */
    set lifecycleRule(value: StorageBucketLifecycleRule[]);
    /**
     * @stability stable
     */
    resetLifecycleRule(): void;
    /**
     * @stability stable
     */
    get lifecycleRuleInput(): StorageBucketLifecycleRule[] | undefined;
    private _logging;
    /**
     * @stability stable
     */
    get logging(): StorageBucketLoggingOutputReference;
    /**
     * @stability stable
     */
    putLogging(value: StorageBucketLogging): void;
    /**
     * @stability stable
     */
    resetLogging(): void;
    /**
     * @stability stable
     */
    get loggingInput(): StorageBucketLogging | undefined;
    private _retentionPolicy;
    /**
     * @stability stable
     */
    get retentionPolicy(): StorageBucketRetentionPolicyOutputReference;
    /**
     * @stability stable
     */
    putRetentionPolicy(value: StorageBucketRetentionPolicy): void;
    /**
     * @stability stable
     */
    resetRetentionPolicy(): void;
    /**
     * @stability stable
     */
    get retentionPolicyInput(): StorageBucketRetentionPolicy | undefined;
    private _versioning;
    /**
     * @stability stable
     */
    get versioning(): StorageBucketVersioningOutputReference;
    /**
     * @stability stable
     */
    putVersioning(value: StorageBucketVersioning): void;
    /**
     * @stability stable
     */
    resetVersioning(): void;
    /**
     * @stability stable
     */
    get versioningInput(): StorageBucketVersioning | undefined;
    private _website;
    /**
     * @stability stable
     */
    get website(): StorageBucketWebsiteOutputReference;
    /**
     * @stability stable
     */
    putWebsite(value: StorageBucketWebsite): void;
    /**
     * @stability stable
     */
    resetWebsite(): void;
    /**
     * @stability stable
     */
    get websiteInput(): StorageBucketWebsite | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
