"""Broadworks OCI-P Interface Response Classes"""
# Autogenerated from the Broadworks XML Schemas.
# Do not edit as changes will be overwritten.
# Generated on 2020-10-01T14:03:08.891866
from classforge import Field

import broadworks_ocip.types as OCI
from .base import ElementInfo as E
from .base import OCIResponse


class AuthenticationResponse(OCIResponse):
    """
    ``AuthenticationRequest()``/Response is 1st stage of the 2 stage OCI login process.
    """

    _ELEMENTS = (
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "nonce",
            "nonce",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "password_algorithm",
            "passwordAlgorithm",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* nonce
    nonce = Field(
        type=str,
        required=True,
    )
    #: str: *Required* passwordAlgorithm
    password_algorithm = Field(
        type=str,
        required=True,
    )


class AuthenticationVerifyResponse(OCIResponse):
    """
    Response to ``AuthenticationVerifyRequest()``
    Replaced By ``AuthenticationVerifyResponse14sp8()``
    """

    _ELEMENTS = (
        E(
            "login_type",
            "loginType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "locale",
            "locale",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "encoding",
            "encoding",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "is_enterprise",
            "isEnterprise",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "password_expires_days",
            "passwordExpiresDays",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_domain",
            "userDomain",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "last_name",
            "lastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "first_name",
            "firstName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* loginType
    login_type = Field(
        type=str,
        required=True,
    )
    #: str: *Required* locale
    locale = Field(
        type=str,
        required=True,
    )
    #: str: *Required* encoding
    encoding = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* groupId
    group_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* isEnterprise
    is_enterprise = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* passwordExpiresDays
    password_expires_days = Field(
        type=int,
        required=False,
    )
    #: str: *Required* userDomain
    user_domain = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* lastName
    last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* firstName
    first_name = Field(
        type=str,
        required=False,
    )


class AuthenticationVerifyResponse14sp8(OCIResponse):
    """
    Response to ``AuthenticationVerifyRequest14sp8()``
    If a phoneNumber is returned, it will be the primay DN of the user
    """

    _ELEMENTS = (
        E(
            "login_type",
            "loginType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "locale",
            "locale",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "encoding",
            "encoding",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "is_enterprise",
            "isEnterprise",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "password_expires_days",
            "passwordExpiresDays",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "last_name",
            "lastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "first_name",
            "firstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_id",
            "userId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* loginType
    login_type = Field(
        type=str,
        required=True,
    )
    #: str: *Required* locale
    locale = Field(
        type=str,
        required=True,
    )
    #: str: *Required* encoding
    encoding = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* groupId
    group_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* isEnterprise
    is_enterprise = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* passwordExpiresDays
    password_expires_days = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* lastName
    last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* firstName
    first_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* userId
    user_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* phoneNumber
    phone_number = Field(
        type=str,
        required=False,
    )


class DeviceManagementFileAuthLocationGetResponse(OCIResponse):
    """
    Return the address and credentials of the File Repository hosting the requested
    access device file. Also return the file name and path on the File Repository.
    This is a response to ``DeviceManagementFileAuthLocationGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "file_repository_user_name",
            "fileRepositoryUserName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "file_repository_password",
            "fileRepositoryPassword",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "net_address",
            "netAddress",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "remote_file_format",
            "remoteFileFormat",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "port_number",
            "portNumber",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "root_directory",
            "rootDirectory",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "cpe_file_directory",
            "cpeFileDirectory",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "secure",
            "secure",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "mac_in_non_request_uri",
            "macInNonRequestURI",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "mac_format_in_non_request_uri",
            "macFormatInNonRequestURI",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_http_digest_authentication",
            "useHttpDigestAuthentication",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "mac_based_file_authentication",
            "macBasedFileAuthentication",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "completion_notification",
            "completionNotification",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "file_category",
            "fileCategory",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* fileRepositoryUserName
    file_repository_user_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* fileRepositoryPassword
    file_repository_password = Field(
        type=str,
        required=True,
    )
    #: str: *Required* netAddress
    net_address = Field(
        type=str,
        required=True,
    )
    #: str: *Required* remoteFileFormat
    remote_file_format = Field(
        type=str,
        required=True,
    )
    #: int: *Optional* portNumber
    port_number = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* rootDirectory
    root_directory = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* cpeFileDirectory
    cpe_file_directory = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* secure
    secure = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* macInNonRequestURI
    mac_in_non_request_uri = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* macFormatInNonRequestURI
    mac_format_in_non_request_uri = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* useHttpDigestAuthentication
    use_http_digest_authentication = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* macBasedFileAuthentication
    mac_based_file_authentication = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* userNamePasswordFileAuthentication
    user_name_password_file_authentication = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* completionNotification
    completion_notification = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* fileCategory
    file_category = Field(
        type=str,
        required=False,
    )


class DeviceManagementFileAuthLocationGetResponse17(OCIResponse):
    """
    Return the address and credentials of the File Repository hosting the requested
    access device file.
    Also return the file name and path on the File Repository.
    This is a response to ``DeviceManagementFileAuthLocationGetRequest17()``.

    Replaced By ``DeviceManagementFileAuthLocationGetRequest18()``
    """

    _ELEMENTS = (
        E(
            "file_repository_user_name",
            "fileRepositoryUserName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "file_repository_password",
            "fileRepositoryPassword",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "net_address",
            "netAddress",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "remote_file_format",
            "remoteFileFormat",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "port_number",
            "portNumber",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "root_directory",
            "rootDirectory",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "cpe_file_directory",
            "cpeFileDirectory",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "secure",
            "secure",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "mac_in_non_request_uri",
            "macInNonRequestURI",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "mac_format_in_non_request_uri",
            "macFormatInNonRequestURI",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_http_digest_authentication",
            "useHttpDigestAuthentication",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "mac_based_file_authentication",
            "macBasedFileAuthentication",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "completion_notification",
            "completionNotification",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "file_category",
            "fileCategory",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* fileRepositoryUserName
    file_repository_user_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* fileRepositoryPassword
    file_repository_password = Field(
        type=str,
        required=True,
    )
    #: str: *Required* netAddress
    net_address = Field(
        type=str,
        required=True,
    )
    #: str: *Required* remoteFileFormat
    remote_file_format = Field(
        type=str,
        required=True,
    )
    #: int: *Optional* portNumber
    port_number = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* rootDirectory
    root_directory = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* cpeFileDirectory
    cpe_file_directory = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* secure
    secure = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* macInNonRequestURI
    mac_in_non_request_uri = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* macFormatInNonRequestURI
    mac_format_in_non_request_uri = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* useHttpDigestAuthentication
    use_http_digest_authentication = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* macBasedFileAuthentication
    mac_based_file_authentication = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* userNamePasswordFileAuthentication
    user_name_password_file_authentication = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* completionNotification
    completion_notification = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* fileCategory
    file_category = Field(
        type=str,
        required=False,
    )


class DeviceManagementFileAuthLocationGetResponse18(OCIResponse):
    """
    Return the address and credentials of the File Repository hosting the requested
    access device file.
    Also return the file name and path on the File Repository.
    This is a response to ``DeviceManagementFileAuthLocationGetRequest18()``.

    Replaced By ``DeviceManagementFileAuthLocationGetResponse21()``.
    """

    _ELEMENTS = (
        E(
            "file_repository_user_name",
            "fileRepositoryUserName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "file_repository_password",
            "fileRepositoryPassword",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "net_address",
            "netAddress",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "remote_file_format",
            "remoteFileFormat",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "port_number",
            "portNumber",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "root_directory",
            "rootDirectory",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "cpe_file_directory",
            "cpeFileDirectory",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "secure",
            "secure",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "mac_in_non_request_uri",
            "macInNonRequestURI",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "mac_format_in_non_request_uri",
            "macFormatInNonRequestURI",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_http_digest_authentication",
            "useHttpDigestAuthentication",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "mac_based_file_authentication",
            "macBasedFileAuthentication",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "completion_notification",
            "completionNotification",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "file_category",
            "fileCategory",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_caching",
            "enableCaching",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* fileRepositoryUserName
    file_repository_user_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* fileRepositoryPassword
    file_repository_password = Field(
        type=str,
        required=True,
    )
    #: str: *Required* netAddress
    net_address = Field(
        type=str,
        required=True,
    )
    #: str: *Required* remoteFileFormat
    remote_file_format = Field(
        type=str,
        required=True,
    )
    #: int: *Optional* portNumber
    port_number = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* rootDirectory
    root_directory = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* cpeFileDirectory
    cpe_file_directory = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* secure
    secure = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* macInNonRequestURI
    mac_in_non_request_uri = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* macFormatInNonRequestURI
    mac_format_in_non_request_uri = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* useHttpDigestAuthentication
    use_http_digest_authentication = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* macBasedFileAuthentication
    mac_based_file_authentication = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* userNamePasswordFileAuthentication
    user_name_password_file_authentication = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* completionNotification
    completion_notification = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* fileCategory
    file_category = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* enableCaching
    enable_caching = Field(
        type=bool,
        required=False,
    )


class DeviceManagementFileAuthLocationGetResponse21(OCIResponse):
    """
    This is a response to ``DeviceManagementFileAuthLocationGetRequest21()``.
    Return the address and credentials of the File Repository hosting the requested
    access device file.
    Also return the file name and path on the File Repository.
    Also returns the status of the file authentication.
    """

    _ELEMENTS = (
        E(
            "status",
            "status",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "file_repository_user_name",
            "fileRepositoryUserName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "file_repository_password",
            "fileRepositoryPassword",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "net_address",
            "netAddress",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "remote_file_format",
            "remoteFileFormat",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "port_number",
            "portNumber",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "root_directory",
            "rootDirectory",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "cpe_file_directory",
            "cpeFileDirectory",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "secure",
            "secure",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "mac_in_non_request_uri",
            "macInNonRequestURI",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "mac_format_in_non_request_uri",
            "macFormatInNonRequestURI",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_http_digest_authentication",
            "useHttpDigestAuthentication",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "mac_based_file_authentication",
            "macBasedFileAuthentication",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_name_password_file_authentication",
            "userNamePasswordFileAuthentication",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "completion_notification",
            "completionNotification",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "file_category",
            "fileCategory",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_caching",
            "enableCaching",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "notify_file_upload",
            "notifyFileUpload",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* status
    status = Field(
        type=str,
        required=False,
    )
    #: str: *Required* fileRepositoryUserName
    file_repository_user_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* fileRepositoryPassword
    file_repository_password = Field(
        type=str,
        required=True,
    )
    #: str: *Required* netAddress
    net_address = Field(
        type=str,
        required=True,
    )
    #: str: *Required* remoteFileFormat
    remote_file_format = Field(
        type=str,
        required=True,
    )
    #: int: *Optional* portNumber
    port_number = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* rootDirectory
    root_directory = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* cpeFileDirectory
    cpe_file_directory = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* secure
    secure = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* macInNonRequestURI
    mac_in_non_request_uri = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* macFormatInNonRequestURI
    mac_format_in_non_request_uri = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* useHttpDigestAuthentication
    use_http_digest_authentication = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* macBasedFileAuthentication
    mac_based_file_authentication = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* userNamePasswordFileAuthentication
    user_name_password_file_authentication = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* completionNotification
    completion_notification = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* fileCategory
    file_category = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* enableCaching
    enable_caching = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* notifyFileUpload
    notify_file_upload = Field(
        type=bool,
        required=False,
    )


class EnterpriseBroadWorksMobileManagerGetDomainListResponse(OCIResponse):
    """
    Response to the ``EnterpriseBroadWorksMobileManagerGetDomainListRequest()``.
    Contains the list of domains.
    """

    _ELEMENTS = (
        E(
            "domain_name",
            "domainName",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* domainName  *Array*
    domain_name = Field(
        type=list,
        required=False,
    )


class EnterpriseBroadWorksMobileManagerGetHomeZoneListResponse(OCIResponse):
    """
    Response to the
    ``EnterpriseBroadWorksMobileManagerGetHomeZoneListRequest()``.
    Contains a table with column headings:
    "Home Zone Id", "Domain Name", "Mobile Country Code",
    "Mobile Network Code", "Local Area Code" and "Cell Identity".
    """

    _ELEMENTS = (
        E(
            "home_zones_table",
            "homeZonesTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* homeZonesTable  *Tabular*
    home_zones_table = Field(
        type=list,
        required=True,
    )


class EnterpriseBroadWorksMobileManagerGetHomeZoneResponse(OCIResponse):
    """
    Response to the ``EnterpriseBroadWorksMobileManagerGetHomeZoneRequest()``
    """

    _ELEMENTS = (
        E(
            "home_zone_domain_name",
            "homeZoneDomainName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "mobile_country_code",
            "mobileCountryCode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "mobile_network_code",
            "mobileNetworkCode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "location_area_code",
            "locationAreaCode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "cell_identity",
            "cellIdentity",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* homeZoneDomainName
    home_zone_domain_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* mobileCountryCode
    mobile_country_code = Field(
        type=str,
        required=True,
    )
    #: str: *Required* mobileNetworkCode
    mobile_network_code = Field(
        type=str,
        required=True,
    )
    #: str: *Required* locationAreaCode
    location_area_code = Field(
        type=str,
        required=True,
    )
    #: str: *Required* cellIdentity
    cell_identity = Field(
        type=str,
        required=True,
    )


class EnterpriseBroadWorksMobileManagerGetResponse(OCIResponse):
    """
    Response to the ``EnterpriseBroadWorksMobileManagerGetRequest()``
    """

    _ELEMENTS = (
        E(
            "mobile_manager_id",
            "mobileManagerId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "local_to_carrier",
            "localToCarrier",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "deactivation_reason",
            "deactivationReason",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_tx_per_second_enabled",
            "maxTxPerSecondEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_tx_per_second",
            "maxTxPerSecond",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "tldn_enabled",
            "tldnEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "generic_number_enabled",
            "genericNumberEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "mobile_state_check_enabled",
            "mobileStateCheckEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "location_based_services_enabled",
            "locationBasedServicesEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mobileManagerId
    mobile_manager_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* localToCarrier
    local_to_carrier = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* deactivationReason
    deactivation_reason = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* maxTxPerSecondEnabled
    max_tx_per_second_enabled = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* maxTxPerSecond
    max_tx_per_second = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* tldnEnabled
    tldn_enabled = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* genericNumberEnabled
    generic_number_enabled = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* mobileStateCheckEnabled
    mobile_state_check_enabled = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* locationBasedServicesEnabled
    location_based_services_enabled = Field(
        type=bool,
        required=True,
    )


class EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAssignmentListResponse(
    OCIResponse,
):
    """
    Response to ``EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAssignmentListRequest()``.
    The response contains a table with columns: "Mobile Number", "User Id",
    "Last Name", "First Name","Phone Number","Extension", "Group Id", "Department"
    and "Mobile Network".
    The "Mobile Number" column contains a single DN.
    The "User Id", "Last Name" and "First Name" columns contains the corresponding
    attributes of the user possessing the DN(s).
    The "Phone Number" column contains a single DN.
    The "Group Id"   column contains the Group Id of the user.
    The "Department" column contains the department of the user if it is part of a department.
    The "Mobile Network" column contains the Mobile Network the number belongs to.
    """

    _ELEMENTS = (
        E(
            "mobile_subscriber_directory_numbers_assignment_table",
            "mobileSubscriberDirectoryNumbersAssignmentTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* mobileSubscriberDirectoryNumbersAssignmentTable  *Tabular*
    mobile_subscriber_directory_numbers_assignment_table = Field(
        type=list,
        required=True,
    )


class EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListResponse(
    OCIResponse,
):
    """
    Response to ``EnterpriseBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest()``.
    Contains a list of available Mobile Subscriber Directory Numbers not yet assigned
    to any user.
    """

    _ELEMENTS = (
        E(
            "available_mobile_subscriber_directory_number",
            "availableMobileSubscriberDirectoryNumber",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* availableMobileSubscriberDirectoryNumber  *Array*
    available_mobile_subscriber_directory_number = Field(
        type=list,
        required=False,
    )


class EnterpriseCallCenterAgentThresholdDefaultProfileGetResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterAgentThresholdDefaultProfileGetRequest()``.
    The agent table contains the agents assigned to the profile and
    has column headings: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address";
    """

    _ELEMENTS = (
        E(
            "profile_name",
            "profileName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "profile_description",
            "profileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_call_state_idle_time_yellow",
            "thresholdCurrentCallStateIdleTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_call_state_idle_time_red",
            "thresholdCurrentCallStateIdleTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_call_state_on_call_time_yellow",
            "thresholdCurrentCallStateOnCallTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_call_state_on_call_time_red",
            "thresholdCurrentCallStateOnCallTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_yellow",
            "thresholdCurrentAgentStateUnavailableTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_red",
            "thresholdCurrentAgentStateUnavailableTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_busy_in_time_yellow",
            "thresholdAverageBusyInTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_busy_in_time_red",
            "thresholdAverageBusyInTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_busy_out_time_yellow",
            "thresholdAverageBusyOutTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_busy_out_time_red",
            "thresholdAverageBusyOutTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_wrap_up_time_yellow",
            "thresholdAverageWrapUpTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_wrap_up_time_red",
            "thresholdAverageWrapUpTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_notification_email",
            "enableNotificationEmail",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "notification_email_address",
            "notificationEmailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "agent_table",
            "agentTable",
            list,
            True,
            False,
            False,
            True,
        ),
    )
    #: str: *Required* profileName
    profile_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* profileDescription
    profile_description = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* thresholdCurrentCallStateIdleTimeYellow
    threshold_current_call_state_idle_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentCallStateIdleTimeRed
    threshold_current_call_state_idle_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentCallStateOnCallTimeYellow
    threshold_current_call_state_on_call_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentCallStateOnCallTimeRed
    threshold_current_call_state_on_call_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentAgentStateUnavailableTimeYellow
    threshold_current_agent_state_unavailable_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentAgentStateUnavailableTimeRed
    threshold_current_agent_state_unavailable_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageBusyInTimeYellow
    threshold_average_busy_in_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageBusyInTimeRed
    threshold_average_busy_in_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageBusyOutTimeYellow
    threshold_average_busy_out_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageBusyOutTimeRed
    threshold_average_busy_out_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageWrapUpTimeYellow
    threshold_average_wrap_up_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageWrapUpTimeRed
    threshold_average_wrap_up_time_red = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* enableNotificationEmail
    enable_notification_email = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* notificationEmailAddress
    notification_email_address = Field(
        type=str,
        required=False,
    )
    #: list: *Optional* agentTable  *Tabular*
    agent_table = Field(
        type=list,
        required=False,
    )


class EnterpriseCallCenterAgentThresholdProfileGetAvailableAgentListResponse(
    OCIResponse,
):
    """
    Response to the ``EnterpriseCallCenterAgentThresholdProfileGetAvailableAgentListRequest()``.
    Contains a table with column headings: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address", "Agent Threshold Profile";
    """

    _ELEMENTS = (
        E(
            "agent_table",
            "agentTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* agentTable  *Tabular*
    agent_table = Field(
        type=list,
        required=True,
    )


class EnterpriseCallCenterAgentThresholdProfileGetListResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterAgentThresholdProfileGetListRequest()``.
    Contains a table with all the  Call Center Agent Threshold Profiles in the Enterprise.
    The column headings are: "Default", "Name", "Description".
    """

    _ELEMENTS = (
        E(
            "profiles_table",
            "profilesTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* profilesTable  *Tabular*
    profiles_table = Field(
        type=list,
        required=True,
    )


class EnterpriseCallCenterAgentThresholdProfileGetResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterAgentThresholdProfileGetRequest()``.
    The agentTable contains the agents assigned to the profile and has the column headings:
    "User Id", "Group Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana
    First Name",
    "Phone Number", "Extension", "Department", "Email Address";
    """

    _ELEMENTS = (
        E(
            "profile_description",
            "profileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_call_state_idle_time_yellow",
            "thresholdCurrentCallStateIdleTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_call_state_idle_time_red",
            "thresholdCurrentCallStateIdleTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_call_state_on_call_time_yellow",
            "thresholdCurrentCallStateOnCallTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_call_state_on_call_time_red",
            "thresholdCurrentCallStateOnCallTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_yellow",
            "thresholdCurrentAgentStateUnavailableTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_red",
            "thresholdCurrentAgentStateUnavailableTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_busy_in_time_yellow",
            "thresholdAverageBusyInTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_busy_in_time_red",
            "thresholdAverageBusyInTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_busy_out_time_yellow",
            "thresholdAverageBusyOutTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_busy_out_time_red",
            "thresholdAverageBusyOutTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_wrap_up_time_yellow",
            "thresholdAverageWrapUpTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_wrap_up_time_red",
            "thresholdAverageWrapUpTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_notification_email",
            "enableNotificationEmail",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "notification_email_address",
            "notificationEmailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "agent_table",
            "agentTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: str: *Optional* profileDescription
    profile_description = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* thresholdCurrentCallStateIdleTimeYellow
    threshold_current_call_state_idle_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentCallStateIdleTimeRed
    threshold_current_call_state_idle_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentCallStateOnCallTimeYellow
    threshold_current_call_state_on_call_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentCallStateOnCallTimeRed
    threshold_current_call_state_on_call_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentAgentStateUnavailableTimeYellow
    threshold_current_agent_state_unavailable_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentAgentStateUnavailableTimeRed
    threshold_current_agent_state_unavailable_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageBusyInTimeYellow
    threshold_average_busy_in_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageBusyInTimeRed
    threshold_average_busy_in_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageBusyOutTimeYellow
    threshold_average_busy_out_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageBusyOutTimeRed
    threshold_average_busy_out_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageWrapUpTimeYellow
    threshold_average_wrap_up_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageWrapUpTimeRed
    threshold_average_wrap_up_time_red = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* enableNotificationEmail
    enable_notification_email = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* notificationEmailAddress
    notification_email_address = Field(
        type=str,
        required=False,
    )
    #: list: *Required* agentTable  *Tabular*
    agent_table = Field(
        type=list,
        required=True,
    )


class EnterpriseCallCenterAgentUnavailableCodeGetListResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterAgentUnavailableCodeGetListRequest()``.
    Contains a table with column headings: "Is Active", "Code", "Description".
    """

    _ELEMENTS = (
        E(
            "unavailable_codes_table",
            "unavailableCodesTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* unavailableCodesTable  *Tabular*
    unavailable_codes_table = Field(
        type=list,
        required=True,
    )


class EnterpriseCallCenterAgentUnavailableCodeGetResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterAgentUnavailableCodeGetRequest()``
    """

    _ELEMENTS = (
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class EnterpriseCallCenterAgentUnavailableCodeSettingsGetResponse(OCIResponse):
    """
    Response to ``EnterpriseCallCenterAgentUnavailableCodeSettingsGetRequest()``.

    Replaced by ``EnterpriseCallCenterAgentUnavailableCodeSettingsGetResponse17sp4()``.
    """

    _ELEMENTS = (
        E(
            "enable_agent_unavailable_codes",
            "enableAgentUnavailableCodes",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "default_agent_unavailable_code_on_dnd",
            "defaultAgentUnavailableCodeOnDND",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "default_agent_unavailable_code_on_personal_calls",
            "defaultAgentUnavailableCodeOnPersonalCalls",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "default_agent_unavailable_code_on_consecutive_bounces",
            "defaultAgentUnavailableCodeOnConsecutiveBounces",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "force_use_of_agent_unavailable_codes",
            "forceUseOfAgentUnavailableCodes",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "default_agent_unavailable_code",
            "defaultAgentUnavailableCode",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* enableAgentUnavailableCodes
    enable_agent_unavailable_codes = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* defaultAgentUnavailableCodeOnDND
    default_agent_unavailable_code_on_dnd = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* defaultAgentUnavailableCodeOnPersonalCalls
    default_agent_unavailable_code_on_personal_calls = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* defaultAgentUnavailableCodeOnConsecutiveBounces
    default_agent_unavailable_code_on_consecutive_bounces = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* forceUseOfAgentUnavailableCodes
    force_use_of_agent_unavailable_codes = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* defaultAgentUnavailableCode
    default_agent_unavailable_code = Field(
        type=str,
        required=False,
    )


class EnterpriseCallCenterAgentUnavailableCodeSettingsGetResponse17sp4(OCIResponse):
    """
    Response to ``EnterpriseCallCenterAgentUnavailableCodeSettingsGetRequest17sp4()``.
    """

    _ELEMENTS = (
        E(
            "enable_agent_unavailable_codes",
            "enableAgentUnavailableCodes",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "default_agent_unavailable_code_on_dnd",
            "defaultAgentUnavailableCodeOnDND",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "default_agent_unavailable_code_on_personal_calls",
            "defaultAgentUnavailableCodeOnPersonalCalls",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "default_agent_unavailable_code_on_consecutive_bounces",
            "defaultAgentUnavailableCodeOnConsecutiveBounces",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "default_agent_unavailable_code_on_not_reachable",
            "defaultAgentUnavailableCodeOnNotReachable",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "force_use_of_agent_unavailable_codes",
            "forceUseOfAgentUnavailableCodes",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "default_agent_unavailable_code",
            "defaultAgentUnavailableCode",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* enableAgentUnavailableCodes
    enable_agent_unavailable_codes = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* defaultAgentUnavailableCodeOnDND
    default_agent_unavailable_code_on_dnd = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* defaultAgentUnavailableCodeOnPersonalCalls
    default_agent_unavailable_code_on_personal_calls = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* defaultAgentUnavailableCodeOnConsecutiveBounces
    default_agent_unavailable_code_on_consecutive_bounces = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* defaultAgentUnavailableCodeOnNotReachable
    default_agent_unavailable_code_on_not_reachable = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* forceUseOfAgentUnavailableCodes
    force_use_of_agent_unavailable_codes = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* defaultAgentUnavailableCode
    default_agent_unavailable_code = Field(
        type=str,
        required=False,
    )


class EnterpriseCallCenterCallDispositionCodeGetListResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterCallDispositionCodeGetListRequest()``.
    Contains a table with column headings: "Is Active", "Code", "Description".
    """

    _ELEMENTS = (
        E(
            "disposition_codes_table",
            "dispositionCodesTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* dispositionCodesTable  *Tabular*
    disposition_codes_table = Field(
        type=list,
        required=True,
    )


class EnterpriseCallCenterCallDispositionCodeGetResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterCallDispositionCodeGetRequest()``
    """

    _ELEMENTS = (
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class EnterpriseCallCenterCallDispositionCodeGetUsageListResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterCallDispositionCodeGetUsageListRequest()``.
    The Type column contains either "Call Center" or "Route Point".
    Contains a table with column headings: "Group Id", "Id", "Name" and "Type".
    """

    _ELEMENTS = (
        E(
            "call_center_table",
            "callCenterTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* callCenterTable  *Tabular*
    call_center_table = Field(
        type=list,
        required=True,
    )


class EnterpriseCallCenterCurrentAndPastAgentGetListResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterCurrentAndPastAgentGetListRequest()``.
    Contains a table with column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "agent_user_table",
            "agentUserTable",
            list,
            True,
            True,
            False,
            True,
        ),
        E(
            "deleted_agent_user_table",
            "deletedAgentUserTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* agentUserTable  *Tabular*
    agent_user_table = Field(
        type=list,
        required=True,
    )
    #: list: *Required* deletedAgentUserTable  *Tabular*
    deleted_agent_user_table = Field(
        type=list,
        required=True,
    )


class EnterpriseCallCenterCurrentAndPastCallCenterGetListResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterCurrentAndPastCallCenterGetListRequest()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "deleted_service_user_id",
            "deletedServiceUserId",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* serviceUserId  *Array*
    service_user_id = Field(
        type=list,
        required=False,
    )
    #: list(str): *Optional* deletedServiceUserId  *Array*
    deleted_service_user_id = Field(
        type=list,
        required=False,
    )


class EnterpriseCallCenterCurrentAndPastDNISGetListResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterCurrentAndPastDNISGetListRequest()``.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "deleted_name",
            "deletedName",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* name  *Array*
    name = Field(
        type=list,
        required=False,
    )
    #: list(str): *Optional* deletedName  *Array*
    deleted_name = Field(
        type=list,
        required=False,
    )


class EnterpriseCallCenterEnhancedReportingBrandingGetResponse(OCIResponse):
    """
    Response to the ``EnterpriseCallCenterEnhancedReportingBrandingGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "branding_choice",
            "brandingChoice",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "branding_file_description",
            "brandingFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* brandingChoice
    branding_choice = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* brandingFileDescription
    branding_file_description = Field(
        type=str,
        required=False,
    )


class EnterpriseCallCenterEnhancedReportingGetAvailableReportTemplateListResponse(
    OCIResponse,
):
    """
    Response to ``EnterpriseCallCenterEnhancedReportingGetAvailableReportTemplateListRequest()``.
    Contains a table with column headings: "Name", "Description" and "Level", "Is
    Agent Required",
    "Is Call Center Required", "Is Call Center Dnis Required", "Is Real Time Report",
    "Is Sampling Period Required",
    "Call Completion Threshold Parameter", "Short Duration Threshold Parameter",
    "Service Level Threshold Parameter", "Service Level Inclusions Parameter",
    "Service Level Objective Threshold Parameter",
    "Abandoned Call Threshold Parameter", "Service Level Threshold Parameter Number",
    "Abandoned Call Threshold Parameter Number" and "Scope".
    The possible values for "Level" are "System" and "Enterprise".
    The possible values for "Is Agent Required", "Is Call Center Required", "Is Call
    Center Dnis Required", "Is Real Time Report" and
    "Is Sampling Period Required" are "true" and "false".
    The possible values for "Call Completion Threshold Parameter", "Short Duration
    Threshold Parameter",
    "Service Level Threshold Parameter", "Service Level Inclusions Parameter",
    "Service Level Objective Threshold Parameter"
    and "Abandoned Call Threshold Parameter" are "Required", "Hidden" and "Does Not Apply".
    The possible values for "Scope" are "Supervisor Only" and "Supervisor and Agent".
    """

    _ELEMENTS = (
        E(
            "report_template_table",
            "reportTemplateTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* reportTemplateTable  *Tabular*
    report_template_table = Field(
        type=list,
        required=True,
    )


class EnterpriseCallCenterEnhancedReportingGetResponse(OCIResponse):
    """
    Response to ``EnterpriseCallCenterEnhancedReportingGetRequest()``.

    Replaced by ``EnterpriseCallCenterEnhancedReportingGetResponse19()``
    """

    _ELEMENTS = (
        E(
            "reporting_server",
            "reportingServer",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "web_statistic_source",
            "webStatisticSource",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* reportingServer
    reporting_server = Field(
        type=str,
        required=True,
    )
    #: str: *Required* webStatisticSource
    web_statistic_source = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterEnhancedReportingGetResponse19(OCIResponse):
    """
    Response to ``EnterpriseCallCenterEnhancedReportingGetRequest19()``.
    """

    _ELEMENTS = (
        E(
            "reporting_server",
            "reportingServer",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* reportingServer
    reporting_server = Field(
        type=str,
        required=True,
    )


class EnterpriseCallCenterEnhancedReportingReportTemplateGetListResponse(OCIResponse):
    """
    Response to ``EnterpriseCallCenterEnhancedReportingReportTemplateGetListRequest()``.
    Contains a table with column headings: "Name", "Description", "Type" and "Enabled".
    """

    _ELEMENTS = (
        E(
            "report_template_table",
            "reportTemplateTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* reportTemplateTable  *Tabular*
    report_template_table = Field(
        type=list,
        required=True,
    )


class EnterpriseCallCenterEnhancedReportingReportTemplateGetResponse(OCIResponse):
    """
    Response to ``EnterpriseCallCenterEnhancedReportingReportTemplateGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "data_template",
            "dataTemplate",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "filter_number",
            "filterNumber",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "xslt_template_description",
            "xsltTemplateDescription",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "scope",
            "scope",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_enabled",
            "isEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_realtime_report",
            "isRealtimeReport",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "call_completion_threshold_param",
            "callCompletionThresholdParam",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "short_duration_threshold_param",
            "shortDurationThresholdParam",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_level_threshold_param",
            "serviceLevelThresholdParam",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_level_inclusions_param",
            "serviceLevelInclusionsParam",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_level_objective_threshold_param",
            "serviceLevelObjectiveThresholdParam",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "abandoned_call_threshold_param",
            "abandonedCallThresholdParam",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_level_threshold_param_number",
            "serviceLevelThresholdParamNumber",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "abandoned_call_threshold_param_number",
            "abandonedCallThresholdParamNumber",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "filter_value",
            "filterValue",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )
    #: str: *Required* dataTemplate
    data_template = Field(
        type=str,
        required=True,
    )
    #: int: *Optional* filterNumber
    filter_number = Field(
        type=int,
        required=False,
    )
    #: str: *Required* xsltTemplateDescription
    xslt_template_description = Field(
        type=str,
        required=True,
    )
    #: str: *Required* scope
    scope = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isEnabled
    is_enabled = Field(
        type=bool,
        required=True,
    )
    #: bool: *Optional* isRealtimeReport
    is_realtime_report = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* callCompletionThresholdParam
    call_completion_threshold_param = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* shortDurationThresholdParam
    short_duration_threshold_param = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceLevelThresholdParam
    service_level_threshold_param = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceLevelInclusionsParam
    service_level_inclusions_param = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceLevelObjectiveThresholdParam
    service_level_objective_threshold_param = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* abandonedCallThresholdParam
    abandoned_call_threshold_param = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* serviceLevelThresholdParamNumber
    service_level_threshold_param_number = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* abandonedCallThresholdParamNumber
    abandoned_call_threshold_param_number = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* filterValue
    filter_value = Field(
        type=str,
        required=False,
    )


class EnterpriseCallCenterEnhancedReportingScheduledReportGetActiveListResponse(
    OCIResponse,
):
    """
    Response to ``EnterpriseCallCenterEnhancedReportingScheduledReportGetActiveListRequest()``.
    Contains a table with column headings : "Schedule Name", "Description", "Created By",
    "Is Supervisor Report", "Report Template Name", "Report Template Level" and "Recurring".
    The "Created By" can be either "Administrator" or user id if created by supervisor.
    The possible values for "Recurring" are "None", "Daily", "Weekly", "Monthly" and "Yearly".
    The possible values for "Report Level" are "System" and "Enterprise".
    """

    _ELEMENTS = (
        E(
            "scheduled_report_table",
            "scheduledReportTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* scheduledReportTable  *Tabular*
    scheduled_report_table = Field(
        type=list,
        required=True,
    )


class EnterpriseCallCenterEnhancedReportingScheduledReportGetCompletedListResponse(
    OCIResponse,
):
    """
    Response to ``EnterpriseCallCenterEnhancedReportingScheduledReportGetCompletedListRequest()``
    Contains a table with column headings : "Schedule Name", "Description", "Created By",
    "Is Supervisor Report", "Report Template Name", "Report Template Level" and "Recurring".
    The "Created By" can be either "Administrator" or user id if created by supervisor.
    The possible values for "Recurring" are "None", "Daily", "Weekly", "Monthly" and "Yearly".
    The possible values for "Report Level" are "System" and "Enterprise".
    """

    _ELEMENTS = (
        E(
            "scheduled_report_table",
            "scheduledReportTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* scheduledReportTable  *Tabular*
    scheduled_report_table = Field(
        type=list,
        required=True,
    )


class EnterpriseCallCenterEnhancedReportingScheduledReportGetListResponse(OCIResponse):
    """
    Response to ``EnterpriseCallCenterEnhancedReportingScheduledReportGetListRequest()``.
    Contains a table with column headings : "Schedule Name", "Description", "Created By",
    "Is Supervisor Report", "Status", "Report Template Name", "Report Template Level"
    and "Recurring".
    The "Created By" can be either "Administrator" or user id if created by supervisor.
    The possible values for "Status" are "Active", and "Completed".
    The possible values for "Recurring" are "None", "Daily", "Weekly", "Monthly" and "Yearly".
    The possible values for "Report Level" are "System" and "Enterprise".
    """

    _ELEMENTS = (
        E(
            "scheduled_report_table",
            "scheduledReportTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* scheduledReportTable  *Tabular*
    scheduled_report_table = Field(
        type=list,
        required=True,
    )


class EnterpriseCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListResponse(
    OCIResponse,
):
    """
    Response to ``EnterpriseCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListRequest()``.
    Contains a table with column headings: "Schedule Name", "Created By", "Created By
    Supervisor", and
    "Is Active".
    The "Created By" can be either "Administrator" or user id if created by supervisor.
    """

    _ELEMENTS = (
        E(
            "schedule_report_table",
            "scheduleReportTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* scheduleReportTable  *Tabular*
    schedule_report_table = Field(
        type=list,
        required=True,
    )


class EnterpriseCallCenterGetResponse(OCIResponse):
    """
    Response to ``EnterpriseCallCenterGetRequest()``.

    Replaced by ``EnterpriseCallCenterGetResponse17sp4()``.
    """

    _ELEMENTS = (
        E(
            "use_system_default_guard_timer",
            "useSystemDefaultGuardTimer",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_guard_timer",
            "enableGuardTimer",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "guard_timer_seconds",
            "guardTimerSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_system_default_unavailable_settings",
            "useSystemDefaultUnavailableSettings",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* useSystemDefaultGuardTimer
    use_system_default_guard_timer = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableGuardTimer
    enable_guard_timer = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* guardTimerSeconds
    guard_timer_seconds = Field(
        type=int,
        required=True,
    )
    #: bool: *Optional* useSystemDefaultUnavailableSettings
    use_system_default_unavailable_settings = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnDNDActivation
    force_agent_unavailable_on_dnd_activation = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnPersonalCalls
    force_agent_unavailable_on_personal_calls = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnBouncedCallLimit
    force_agent_unavailable_on_bounced_call_limit = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* numberConsecutiveBouncedCallsToForceAgentUnavailable
    number_consecutive_bounced_calls_to_force_agent_unavailable = Field(
        type=int,
        required=False,
    )


class EnterpriseCallCenterGetResponse17sp4(OCIResponse):
    """
    Response to ``EnterpriseCallCenterGetRequest17sp4()``.
    """

    _ELEMENTS = (
        E(
            "use_system_default_guard_timer",
            "useSystemDefaultGuardTimer",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_guard_timer",
            "enableGuardTimer",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "guard_timer_seconds",
            "guardTimerSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_system_default_unavailable_settings",
            "useSystemDefaultUnavailableSettings",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "force_agent_unavailable_on_not_reachable",
            "forceAgentUnavailableOnNotReachable",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* useSystemDefaultGuardTimer
    use_system_default_guard_timer = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableGuardTimer
    enable_guard_timer = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* guardTimerSeconds
    guard_timer_seconds = Field(
        type=int,
        required=True,
    )
    #: bool: *Optional* useSystemDefaultUnavailableSettings
    use_system_default_unavailable_settings = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnDNDActivation
    force_agent_unavailable_on_dnd_activation = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnPersonalCalls
    force_agent_unavailable_on_personal_calls = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnBouncedCallLimit
    force_agent_unavailable_on_bounced_call_limit = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* numberConsecutiveBouncedCallsToForceAgentUnavailable
    number_consecutive_bounced_calls_to_force_agent_unavailable = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnNotReachable
    force_agent_unavailable_on_not_reachable = Field(
        type=bool,
        required=False,
    )


class EnterpriseCallCenterGetRoutingPolicyResponse(OCIResponse):
    """
    Response to ``EnterpriseCallCenterGetRoutingPolicyRequest()``.
    Contains a table with column headings: "Service User Id", "Name" and
    "Priority".
    """

    _ELEMENTS = (
        E(
            "routing_policy",
            "routingPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "call_center_table",
            "callCenterTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: str: *Required* routingPolicy
    routing_policy = Field(
        type=str,
        required=True,
    )
    #: list: *Required* callCenterTable  *Tabular*
    call_center_table = Field(
        type=list,
        required=True,
    )


class EnterpriseEnterpriseTrunkGetAvailableUserListResponse(OCIResponse):
    """
    Response to ``EnterpriseEnterpriseTrunkGetAvailableUserListRequest()``.
    The column headings for the enterpriseTrunkUserTable are: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class EnterpriseEnterpriseTrunkGetListResponse(OCIResponse):
    """
    Response to ``EnterpriseEnterpriseTrunkGetListRequest()``.
    Contains a table of enterprise trunks defined in the enterprise
    The column headings are: "Enterprise Trunk Name", "Routing Type"
    """

    _ELEMENTS = (
        E(
            "enterprise_trunk_table",
            "enterpriseTrunkTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* enterpriseTrunkTable  *Tabular*
    enterprise_trunk_table = Field(
        type=list,
        required=True,
    )


class EnterpriseEnterpriseTrunkGetResponse(OCIResponse):
    """
    Response to ``EnterpriseEnterpriseTrunkGetRequest()``.

    Replaced By ``EnterpriseEnterpriseTrunkGetResponse21()``.
    """

    _ELEMENTS = (
        E(
            "maximum_reroute_attempts",
            "maximumRerouteAttempts",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "route_exhaustion_action",
            "routeExhaustionAction",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "route_exhaustion_forward_address",
            "routeExhaustionForwardAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "ordered_routing",
            "orderedRouting",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "priority_weighted_routing",
            "priorityWeightedRouting",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
    )
    #: int: *Required* maximumRerouteAttempts
    maximum_reroute_attempts = Field(
        type=int,
        required=True,
    )
    #: str: *Required* routeExhaustionAction
    route_exhaustion_action = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* routeExhaustionForwardAddress
    route_exhaustion_forward_address = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* orderedRouting
    ordered_routing = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* priorityWeightedRouting
    priority_weighted_routing = Field(
        type=str,
        required=False,
    )


class EnterpriseEnterpriseTrunkGetResponse21(OCIResponse):
    """
    Response to ``EnterpriseEnterpriseTrunkGetRequest21()``.
    """

    _ELEMENTS = (
        E(
            "maximum_reroute_attempts",
            "maximumRerouteAttempts",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "route_exhaustion_action",
            "routeExhaustionAction",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "route_exhaustion_forward_address",
            "routeExhaustionForwardAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "ordered_routing",
            "orderedRouting",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "priority_weighted_routing",
            "priorityWeightedRouting",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "enable_capacity_management",
            "enableCapacityManagement",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_active_calls",
            "maxActiveCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_trap_initial_calls",
            "capacityExceededTrapInitialCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_trap_offset_calls",
            "capacityExceededTrapOffsetCalls",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: int: *Required* maximumRerouteAttempts
    maximum_reroute_attempts = Field(
        type=int,
        required=True,
    )
    #: str: *Required* routeExhaustionAction
    route_exhaustion_action = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* routeExhaustionForwardAddress
    route_exhaustion_forward_address = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* orderedRouting
    ordered_routing = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* priorityWeightedRouting
    priority_weighted_routing = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* enableCapacityManagement
    enable_capacity_management = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* maxActiveCalls
    max_active_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* capacityExceededTrapInitialCalls
    capacity_exceeded_trap_initial_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* capacityExceededTrapOffsetCalls
    capacity_exceeded_trap_offset_calls = Field(
        type=int,
        required=False,
    )


class EnterpriseEnterpriseTrunkGetUserListResponse(OCIResponse):
    """
    Response to ``EnterpriseEnterpriseTrunkGetUserListRequest()``.
    The column headings for the enterpriseTrunkUserTable are: "Group Id", "User Id",
    "Last Name", "First Name", "Phone Number", "Alternate Trunk Identity", "Hiragana
    Last Name", "Hiragana First Name",
    "Extension", "Department", "Email Address" and "Route List Assigned".
    """

    _ELEMENTS = (
        E(
            "enterprise_trunk_user_table",
            "enterpriseTrunkUserTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* enterpriseTrunkUserTable  *Tabular*
    enterprise_trunk_user_table = Field(
        type=list,
        required=True,
    )


class EnterprisePhoneDirectoryGetListResponse(OCIResponse):
    """
    Response to ``EnterprisePhoneDirectoryGetListRequest()``.
    Contains a table with  a row for each phone number and column headings :
    "Name", "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana
    Name", "Group Id", "Yahoo Id".
    If extended directory information is requested, the following columns are also included:
    "First Name", "Last Name", "User Id", "Pager", "Title", "Time Zone", "Location",
    "Address Line 1", "Address Line 2",
    "City", "State", "Zip", "Country".

    Replace by: ``EnterprisePhoneDirectoryGetListResponse17()``
    """

    _ELEMENTS = (
        E(
            "directory_table",
            "directoryTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* directoryTable  *Tabular*
    directory_table = Field(
        type=list,
        required=True,
    )


class EnterprisePhoneDirectoryGetListResponse17(OCIResponse):
    """
    Response to ``EnterprisePhoneDirectoryGetListRequest17()``.
    Contains a table with  a row for each phone number and column headings :
    "Name", "Number", "Extension", "Mobile", "Email Address",
    "Department", "Hiragana Name", "Group Id", "Yahoo Id", "Is Virtual On-Net User".
    If extended directory information is requested, the following columns are also included:
    "First Name", "Last Name", "User Id", "Pager", "Title", "Time Zone",
    "Location", "Address Line 1", "Address Line 2",
    "City", "State", "Zip", "Country".

    Replaced By ``EnterprisePhoneDirectoryGetListResponse18()``
    """

    _ELEMENTS = (
        E(
            "directory_table",
            "directoryTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* directoryTable  *Tabular*
    directory_table = Field(
        type=list,
        required=True,
    )


class EnterprisePhoneDirectoryGetListResponse17sp3(OCIResponse):
    """
    Response to ``EnterprisePhoneDirectoryGetListRequest17sp3()``.
    Contains a table with  a row for each phone number and column headings :
    "Name", "Number", "Extension", "Mobile", "Email Address",
    "Department", "Hiragana Name", "Group Id", "Yahoo Id", "IMP Id", "Is Virtual On-Net User".
    If extended directory information is requested, the following columns are also included:
    "First Name", "Last Name", "User Id", "Pager", "Title", "Time Zone",
    "Location", "Address Line 1", "Address Line 2",
    "City", "State", "Zip", "Country".

    Replaced By ``EnterprisePhoneDirectoryGetListResponse18()``
    """

    _ELEMENTS = (
        E(
            "directory_table",
            "directoryTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* directoryTable  *Tabular*
    directory_table = Field(
        type=list,
        required=True,
    )


class EnterprisePhoneDirectoryGetListResponse18(OCIResponse):
    """
    Response to ``EnterprisePhoneDirectoryGetListRequest18()``.
    Contains a table with  a row for each phone number and column headings :
    "Name", "Number", "Extension", "Mobile", "Email Address",
    "Department", "Hiragana Name", "Group Id", "Yahoo Id", "User Id", "IMP Id", "Is
    Virtual On-Net User".
    If extended directory information is requested, the following columns are also included:
    "First Name", "Last Name", "Pager", "Title", "Time Zone",
    "Location", "Address Line 1", "Address Line 2",
    "City", "State", "Zip", "Country".
    """

    _ELEMENTS = (
        E(
            "directory_table",
            "directoryTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* directoryTable  *Tabular*
    directory_table = Field(
        type=list,
        required=True,
    )


class EnterprisePreAlertingAnnouncementGetResponse(OCIResponse):
    """
    Get the Enterprise level pre-alerting service settings.
    The response is either a ``EnterprisePreAlertingAnnouncementGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "announcement_interruption",
            "announcementInterruption",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "interruption_digit_sequence",
            "interruptionDigitSequence",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_selection",
            "audioSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_file_description",
            "audioFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_media_type",
            "audioMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_file_url",
            "audioFileUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_selection",
            "videoSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "video_file_description",
            "videoFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_media_type",
            "videoMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_file_url",
            "videoFileUrl",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* announcementInterruption
    announcement_interruption = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* interruptionDigitSequence
    interruption_digit_sequence = Field(
        type=str,
        required=False,
    )
    #: str: *Required* audioSelection
    audio_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioMediaType
    audio_media_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioFileUrl
    audio_file_url = Field(
        type=str,
        required=False,
    )
    #: str: *Required* videoSelection
    video_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* videoFileDescription
    video_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoMediaType
    video_media_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoFileUrl
    video_file_url = Field(
        type=str,
        required=False,
    )


class EnterpriseRouteListEnterpriseTrunkNumberRangeGetAvailableListResponse(
    OCIResponse,
):
    """
    Response to ``EnterpriseRouteListEnterpriseTrunkNumberRangeGetAvailableListRequest()``.
    Contains a list of number ranges that are assigned to an enterprise and still
    available for assignment to users within the enterprise.
    The column headings are "Number Range Start", "Number Range End" and "Is Active".
    """

    _ELEMENTS = (
        E(
            "available_number_range_table",
            "availableNumberRangeTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* availableNumberRangeTable  *Tabular*
    available_number_range_table = Field(
        type=list,
        required=True,
    )


class EnterpriseRouteListEnterpriseTrunkNumberRangeGetSummaryListResponse(OCIResponse):
    """
    Response to ``EnterpriseRouteListEnterpriseTrunkNumberRangeGetSummaryListRequest()``.
    The response contains a table with columns: "Number Range Start", "Number Range
    End", "Group Id", "User Id",
    "Last Name", "First Name", "Hiragana Last Name", "Hiragana First Name", "Phone
    Number", "Extension", "Department",
    "Email Address", "Enterprise Trunk" and "Is Active".
    The "User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana First
    Name", "Phone Number",
    "Extension", "Department" and "Email Address" columns contains the corresponding
    attributes of the user possessing the number range.
    The "Enterprise Trunk" column contains the enterprise trunk the user possessing
    the number range belongs to.
    The "Is Active" column indicates if the number range has been activated.
    """

    _ELEMENTS = (
        E(
            "number_range_summary_table",
            "numberRangeSummaryTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* numberRangeSummaryTable  *Tabular*
    number_range_summary_table = Field(
        type=list,
        required=True,
    )


class EnterpriseSessionAdmissionControlGroupGetListResponse(OCIResponse):
    """
    Response to ``EnterpriseSessionAdmissionControlGroupGetListRequest()``.
    Contains a table of session admission control group configured in the enterprise.
    The column headings are: "Name", "Is Default", "Maximum Sessions", "Maximum
    Originating Sessions", "Maximum Terminating Sessions"..
    """

    _ELEMENTS = (
        E(
            "session_admission_control_group_table",
            "sessionAdmissionControlGroupTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* sessionAdmissionControlGroupTable  *Tabular*
    session_admission_control_group_table = Field(
        type=list,
        required=True,
    )


class EnterpriseVirtualOnNetEnterpriseExtensionsGetUserListResponse(OCIResponse):
    """
    Response to   ``EnterpriseVirtualOnNetEnterpriseExtensionsGetUserListRequest()``.
    Contains a table with column headings : "Group Id", "Last Name", "First Name",
    "Phone Number", "Extension",
    "Virtual On-Net Call Type" in a row for each user.
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class EnterpriseVoiceVPNGetPolicyListResponse(OCIResponse):
    """
    Response to ``EnterpriseVoiceVPNGetListResponse()``.
    Returns a 4 column table with column headings:
    "Location Code", "Min Extension Length", "Max Extension Length", "Location Selection".
    """

    _ELEMENTS = (
        E(
            "location_list",
            "locationList",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* locationList  *Tabular*
    location_list = Field(
        type=list,
        required=True,
    )


class EnterpriseVoiceVPNGetResponse(OCIResponse):
    """
    Response to ``EnterpriseVoiceVPNGetRequest()``.
    Replaced By ``EnterpriseVoiceVPNGetResponse14sp3()``
    """

    _ELEMENTS = (
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "default_selection",
            "defaultSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "e164_selection",
            "e164Selection",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* defaultSelection
    default_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Required* e164Selection
    e164_selection = Field(
        type=str,
        required=True,
    )


class EnterpriseVoiceVPNGetResponse14sp3(OCIResponse):
    """
    Response to ``EnterpriseVoiceVPNGetRequest14sp3()``.
    """

    _ELEMENTS = (
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "default_selection",
            "defaultSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "e164_selection",
            "e164Selection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_phone_context",
            "usePhoneContext",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* defaultSelection
    default_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Required* e164Selection
    e164_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* usePhoneContext
    use_phone_context = Field(
        type=bool,
        required=True,
    )


class ExternalAuthenticationCreateLoginTokenResponse(OCIResponse):
    """
    Response to ``ExternalAuthenticationCreateLoginTokenRequest()``.
    """

    _ELEMENTS = (
        E(
            "login_token",
            "loginToken",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* loginToken
    login_token = Field(
        type=str,
        required=True,
    )


class GroupAccessDeviceAvailablePortGetListResponse(OCIResponse):
    """
    Response to ``GroupAccessDeviceAvailablePortGetListRequest()``.
    Contains a list of available ports in a device using static mode. The list is
    empty in case the device is using dynamic mode.
    """

    _ELEMENTS = (
        E(
            "port_number",
            "portNumber",
            int,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(int): *Optional* portNumber  *Array*
    port_number = Field(
        type=list,
        required=False,
    )


class GroupAccessDeviceCustomTagGetListResponse(OCIResponse):
    """
    Response to ``GroupAccessDeviceCustomTagGetListRequest()``.
    Contains a table of custom configuration tags managed by the Device Management
    System on a per-device profile basis.
    The column headings are: "Tag Name", "Tag Value"
    """

    _ELEMENTS = (
        E(
            "device_custom_tags_table",
            "deviceCustomTagsTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* deviceCustomTagsTable  *Tabular*
    device_custom_tags_table = Field(
        type=list,
        required=True,
    )


class GroupAccessDeviceFileGetListResponse(OCIResponse):
    """
    Response to ``GroupAccessDeviceFileGetListRequest()``.
    Contains a table of device files managed by the Device Management System on a
    per-device profile basis.
    The column headings are: "File Type", "File Format", "Is Authenticated".
    Replaced By ``GroupAccessDeviceFileGetListResponse14sp8()``
    """

    _ELEMENTS = (
        E(
            "device_files_table",
            "deviceFilesTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* deviceFilesTable  *Tabular*
    device_files_table = Field(
        type=list,
        required=True,
    )


class GroupAccessDeviceFileGetListResponse14sp8(OCIResponse):
    """
    Response to ``GroupAccessDeviceFileGetListRequest14sp8()``.
    Contains a table of device files managed by the Device Management System on a
    per-device profile basis.
    The column headings are: "File Format", "Is Authenticated", "Access URL",
    "Repository URL", "Template URL", "Extended Capture".

    The following columns are only used in AS data mode:
    "Extended Capture"
    """

    _ELEMENTS = (
        E(
            "device_files_table",
            "deviceFilesTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* deviceFilesTable  *Tabular*
    device_files_table = Field(
        type=list,
        required=True,
    )


class GroupAccessDeviceFileGetResponse(OCIResponse):
    """
    Response to ``GroupAccessDeviceFileGetRequest()``.
    Replaced By ``GroupAccessDeviceFileGetResponse14sp8()``
    """

    _ELEMENTS = (
        E(
            "file_source",
            "fileSource",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "configuration_file_name",
            "configurationFileName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* fileSource
    file_source = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* configurationFileName
    configuration_file_name = Field(
        type=str,
        required=False,
    )


class GroupAccessDeviceFileGetResponse14sp8(OCIResponse):
    """
    Response to ``GroupAccessDeviceFileGetRequest14sp8()``.
    Replaced By ``GroupAccessDeviceFileGetResponse16sp1()``
    """

    _ELEMENTS = (
        E(
            "file_source",
            "fileSource",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "configuration_file_name",
            "configurationFileName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* fileSource
    file_source = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* configurationFileName
    configuration_file_name = Field(
        type=str,
        required=False,
    )


class GroupAccessDeviceFileGetResponse16sp1(OCIResponse):
    """
    Response to ``GroupAccessDeviceFileGetRequest16sp1()``.
    """

    _ELEMENTS = (
        E(
            "file_source",
            "fileSource",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "configuration_file_name",
            "configurationFileName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "access_url",
            "accessUrl",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "repository_url",
            "repositoryUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "template_url",
            "templateUrl",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* fileSource
    file_source = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* configurationFileName
    configuration_file_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* accessUrl
    access_url = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* repositoryUrl
    repository_url = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* templateUrl
    template_url = Field(
        type=str,
        required=False,
    )


class GroupAccessDeviceFileGetResponse20(OCIResponse):
    """
    Response to ``GroupAccessDeviceFileGetRequest20()``.
    """

    _ELEMENTS = (
        E(
            "file_source",
            "fileSource",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "configuration_file_name",
            "configurationFileName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "access_url",
            "accessUrl",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "repository_url",
            "repositoryUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "template_url",
            "templateUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "extended_capture_enabled",
            "extendedCaptureEnabled",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "extended_capture_url",
            "extendedCaptureURL",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* fileSource
    file_source = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* configurationFileName
    configuration_file_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* accessUrl
    access_url = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* repositoryUrl
    repository_url = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* templateUrl
    template_url = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* extendedCaptureEnabled
    extended_capture_enabled = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* extendedCaptureURL
    extended_capture_url = Field(
        type=str,
        required=False,
    )


class GroupAccessDeviceGetAvailableDetailListResponse14(OCIResponse):
    """
    Response to ``GroupAccessDeviceGetAvailableDetailListRequest14()``.
    """

    _ELEMENTS = (
        E(
            "available_access_device",
            "availableAccessDevice",
            str,
            True,
            False,
            True,
            False,
        ),  # unknown
    )
    #: list(str): *Optional* availableAccessDevice  *Array*
    available_access_device = Field(
        type=list,
        required=False,
    )


class GroupAccessDeviceGetAvailableDetailListResponse19(OCIResponse):
    """
    Response to ``GroupAccessDeviceGetAvailableDetailListRequest19()``.
    """

    _ELEMENTS = (
        E(
            "available_access_device",
            "availableAccessDevice",
            str,
            True,
            False,
            True,
            False,
        ),  # unknown
    )
    #: list(str): *Optional* availableAccessDevice  *Array*
    available_access_device = Field(
        type=list,
        required=False,
    )


class GroupAccessDeviceGetEnhancedConfigurationTypeListResponse(OCIResponse):
    """
    Response to ``GroupAccessDeviceGetEnhancedConfigurationTypeListRequest()``.
    """

    _ELEMENTS = (
        E(
            "device_type",
            "deviceType",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* deviceType  *Array*
    device_type = Field(
        type=list,
        required=False,
    )


class GroupAccessDeviceGetEnhancedConfigurationTypeResponse14(OCIResponse):
    """
    Response to ``GroupAccessDeviceGetEnhancedConfigurationTypeRequest14()``.
    """

    _ELEMENTS = (
        E(
            "supports_enhanced_configuration",
            "supportsEnhancedConfiguration",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "supports_reset",
            "supportsReset",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "configuration_type",
            "configurationType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "configuration_file_name",
            "configurationFileName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* supportsEnhancedConfiguration
    supports_enhanced_configuration = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* supportsReset
    supports_reset = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* configurationType
    configuration_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* configurationFileName
    configuration_file_name = Field(
        type=str,
        required=False,
    )


class GroupAccessDeviceGetListResponse(OCIResponse):
    """
    Response to ``GroupAccessDeviceGetListRequest()``.
    Contains a table of devices configured in the group.
    The column headings are: "Device Name", "Device Type", "Available Ports", "Net
    Address", "MAC Address", "Status" and "Version".
    """

    _ELEMENTS = (
        E(
            "access_device_table",
            "accessDeviceTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* accessDeviceTable  *Tabular*
    access_device_table = Field(
        type=list,
        required=True,
    )


class GroupAccessDeviceGetUserListResponse(OCIResponse):
    """
    Response to ``GroupAccessDeviceGetUserListRequest()``.
    The column headings for the deviceUserTable are: "Line/Port", "Last Name",
    "First Name", "Phone Number", "User Id", "User Type", "Endpoint Type", "Order",
    "Primary Line/Port", "Extension", "Department", "Email Address", "Private Identity".
    In IMS mode, the table will contain a row for each TEL-URI in the Phone Number column.
    In Standalone mode, rows for the alternate numbers are not included.
    The User Type column contains one of the enumerated UserType values.
    The Endpoint Type column contains one of the enumerated EndpointType values.
    The Private Identity column is empty is AS mode.
    """

    _ELEMENTS = (
        E(
            "device_user_table",
            "deviceUserTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* deviceUserTable  *Tabular*
    device_user_table = Field(
        type=list,
        required=True,
    )


class GroupAccountAuthorizationCodesGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupAccountAuthorizationCodesGetAvailableUserListRequest()``.
    The column headings are: "User Id", "Last Name", "First Name", "Hiragana Last Name" and
    "Hiragana First Name", "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupAccountAuthorizationCodesGetResponse(OCIResponse):
    """
    Response to ``GroupAccountAuthorizationCodesGetRequest()``.
    The tables has the following column headings:
    "User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "type",
            "type",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_of_digits",
            "numberOfDigits",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_local_and_toll_free_calls",
            "allowLocalAndTollFreeCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "mandatory_usage_user_table",
            "mandatoryUsageUserTable",
            list,
            True,
            True,
            False,
            True,
        ),
        E(
            "optional_usage_user_table",
            "optionalUsageUserTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: str: *Required* type
    type = Field(
        type=str,
        required=True,
    )
    #: int: *Required* numberOfDigits
    number_of_digits = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* allowLocalAndTollFreeCalls
    allow_local_and_toll_free_calls = Field(
        type=bool,
        required=True,
    )
    #: list: *Required* mandatoryUsageUserTable  *Tabular*
    mandatory_usage_user_table = Field(
        type=list,
        required=True,
    )
    #: list: *Required* optionalUsageUserTable  *Tabular*
    optional_usage_user_table = Field(
        type=list,
        required=True,
    )


class GroupAdminGetListResponse(OCIResponse):
    """
    Response to ``GroupAdminGetListRequest()``.
    Contains a 5 column table with column headings "Administrator ID",
    "Last Name", "First Name", "Department", "Language".
    """

    _ELEMENTS = (
        E(
            "group_admin_table",
            "groupAdminTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* groupAdminTable  *Tabular*
    group_admin_table = Field(
        type=list,
        required=True,
    )


class GroupAdminGetPolicyResponse(OCIResponse):
    """
    Response to ``GroupAdminGetPolicyRequest()``.
    Contains the policy settings for the group administrator.
    """

    _ELEMENTS = (
        E(
            "profile_access",
            "profileAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_access",
            "userAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "admin_access",
            "adminAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_access",
            "departmentAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_device_access",
            "accessDeviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enhanced_service_instance_access",
            "enhancedServiceInstanceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "feature_access_code_access",
            "featureAccessCodeAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number_extension_access",
            "phoneNumberExtensionAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_access",
            "serviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* profileAccess
    profile_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userAccess
    user_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* adminAccess
    admin_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAccess
    department_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* enhancedServiceInstanceAccess
    enhanced_service_instance_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* featureAccessCodeAccess
    feature_access_code_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* serviceAccess
    service_access = Field(
        type=str,
        required=True,
    )


class GroupAdminGetPolicyResponse14sp1(OCIResponse):
    """
    Response to ``GroupAdminGetPolicyRequest14sp1()``.
    Contains the policy settings for the group administrator.
    """

    _ELEMENTS = (
        E(
            "profile_access",
            "profileAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_access",
            "userAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "admin_access",
            "adminAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_access",
            "departmentAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_device_access",
            "accessDeviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enhanced_service_instance_access",
            "enhancedServiceInstanceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "feature_access_code_access",
            "featureAccessCodeAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number_extension_access",
            "phoneNumberExtensionAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_access",
            "serviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "trunk_group_access",
            "trunkGroupAccess",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* profileAccess
    profile_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userAccess
    user_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* adminAccess
    admin_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAccess
    department_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* enhancedServiceInstanceAccess
    enhanced_service_instance_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* featureAccessCodeAccess
    feature_access_code_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* serviceAccess
    service_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* trunkGroupAccess
    trunk_group_access = Field(
        type=str,
        required=True,
    )


class GroupAdminGetPolicyResponse16sp1(OCIResponse):
    """
    Response to ``GroupAdminGetPolicyRequest16sp1()``.
    Contains the policy settings for the group administrator.
    Replaced By ``GroupAdminGetPolicyRequest17()``
    """

    _ELEMENTS = (
        E(
            "profile_access",
            "profileAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_access",
            "userAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "admin_access",
            "adminAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_access",
            "departmentAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_device_access",
            "accessDeviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enhanced_service_instance_access",
            "enhancedServiceInstanceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "feature_access_code_access",
            "featureAccessCodeAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number_extension_access",
            "phoneNumberExtensionAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_access",
            "serviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "trunk_group_access",
            "trunkGroupAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "session_admission_control_access",
            "sessionAdmissionControlAccess",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* profileAccess
    profile_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userAccess
    user_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* adminAccess
    admin_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAccess
    department_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* enhancedServiceInstanceAccess
    enhanced_service_instance_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* featureAccessCodeAccess
    feature_access_code_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* serviceAccess
    service_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* trunkGroupAccess
    trunk_group_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* sessionAdmissionControlAccess
    session_admission_control_access = Field(
        type=str,
        required=True,
    )


class GroupAdminGetPolicyResponse16sp2(OCIResponse):
    """
    Response to ``GroupAdminGetPolicyRequest16sp2()``.
    Contains the policy settings for the group administrator.
    """

    _ELEMENTS = (
        E(
            "profile_access",
            "profileAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_access",
            "userAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "admin_access",
            "adminAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_access",
            "departmentAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_device_access",
            "accessDeviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enhanced_service_instance_access",
            "enhancedServiceInstanceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "feature_access_code_access",
            "featureAccessCodeAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number_extension_access",
            "phoneNumberExtensionAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_number_access",
            "callingLineIdNumberAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_access",
            "serviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "trunk_group_access",
            "trunkGroupAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "session_admission_control_access",
            "sessionAdmissionControlAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "dialable_caller_id_access",
            "dialableCallerIDAccess",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* profileAccess
    profile_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userAccess
    user_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* adminAccess
    admin_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAccess
    department_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* enhancedServiceInstanceAccess
    enhanced_service_instance_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* featureAccessCodeAccess
    feature_access_code_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdNumberAccess
    calling_line_id_number_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* serviceAccess
    service_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* trunkGroupAccess
    trunk_group_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* sessionAdmissionControlAccess
    session_admission_control_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* dialableCallerIDAccess
    dialable_caller_id_access = Field(
        type=str,
        required=True,
    )


class GroupAdminGetPolicyResponse17(OCIResponse):
    """
    Response to ``GroupAdminGetPolicyRequest17()``.
    Contains the policy settings for the group administrator.
    """

    _ELEMENTS = (
        E(
            "profile_access",
            "profileAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_access",
            "userAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "admin_access",
            "adminAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_access",
            "departmentAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_device_access",
            "accessDeviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enhanced_service_instance_access",
            "enhancedServiceInstanceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "feature_access_code_access",
            "featureAccessCodeAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number_extension_access",
            "phoneNumberExtensionAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_number_access",
            "callingLineIdNumberAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_access",
            "serviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "trunk_group_access",
            "trunkGroupAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "session_admission_control_access",
            "sessionAdmissionControlAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "office_zone_access",
            "officeZoneAccess",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* profileAccess
    profile_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userAccess
    user_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* adminAccess
    admin_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAccess
    department_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* enhancedServiceInstanceAccess
    enhanced_service_instance_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* featureAccessCodeAccess
    feature_access_code_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdNumberAccess
    calling_line_id_number_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* serviceAccess
    service_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* trunkGroupAccess
    trunk_group_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* sessionAdmissionControlAccess
    session_admission_control_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* officeZoneAccess
    office_zone_access = Field(
        type=str,
        required=True,
    )


class GroupAdminGetPolicyResponse17sp3(OCIResponse):
    """
    Response to ``GroupAdminGetPolicyRequest17sp3()``.
    Contains the policy settings for the group administrator.
    The following elements are only used in AS data mode:
    dialableCallerIDAccess
    """

    _ELEMENTS = (
        E(
            "profile_access",
            "profileAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_access",
            "userAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "admin_access",
            "adminAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_access",
            "departmentAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_device_access",
            "accessDeviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enhanced_service_instance_access",
            "enhancedServiceInstanceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "feature_access_code_access",
            "featureAccessCodeAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number_extension_access",
            "phoneNumberExtensionAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_number_access",
            "callingLineIdNumberAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_access",
            "serviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "trunk_group_access",
            "trunkGroupAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "session_admission_control_access",
            "sessionAdmissionControlAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "office_zone_access",
            "officeZoneAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "dialable_caller_id_access",
            "dialableCallerIDAccess",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* profileAccess
    profile_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userAccess
    user_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* adminAccess
    admin_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAccess
    department_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* enhancedServiceInstanceAccess
    enhanced_service_instance_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* featureAccessCodeAccess
    feature_access_code_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdNumberAccess
    calling_line_id_number_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* serviceAccess
    service_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* trunkGroupAccess
    trunk_group_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* sessionAdmissionControlAccess
    session_admission_control_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* officeZoneAccess
    office_zone_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* dialableCallerIDAccess
    dialable_caller_id_access = Field(
        type=str,
        required=True,
    )


class GroupAdminGetPolicyResponse18(OCIResponse):
    """
    Response to ``GroupAdminGetPolicyRequest18()``.
    Contains the policy settings for the group administrator.
    The following elements are only used in AS data mode:
    dialableCallerIDAccess
    """

    _ELEMENTS = (
        E(
            "profile_access",
            "profileAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_access",
            "userAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "admin_access",
            "adminAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_access",
            "departmentAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_device_access",
            "accessDeviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enhanced_service_instance_access",
            "enhancedServiceInstanceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "feature_access_code_access",
            "featureAccessCodeAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number_extension_access",
            "phoneNumberExtensionAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_number_access",
            "callingLineIdNumberAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_access",
            "serviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "trunk_group_access",
            "trunkGroupAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "session_admission_control_access",
            "sessionAdmissionControlAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "office_zone_access",
            "officeZoneAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_activation_access",
            "numberActivationAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "dialable_caller_id_access",
            "dialableCallerIDAccess",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* profileAccess
    profile_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userAccess
    user_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* adminAccess
    admin_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAccess
    department_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* enhancedServiceInstanceAccess
    enhanced_service_instance_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* featureAccessCodeAccess
    feature_access_code_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdNumberAccess
    calling_line_id_number_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* serviceAccess
    service_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* trunkGroupAccess
    trunk_group_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* sessionAdmissionControlAccess
    session_admission_control_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* officeZoneAccess
    office_zone_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* numberActivationAccess
    number_activation_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* dialableCallerIDAccess
    dialable_caller_id_access = Field(
        type=str,
        required=True,
    )


class GroupAdminGetPolicyResponse19sp1(OCIResponse):
    """
    Response to ``GroupAdminGetPolicyRequest19sp1()``.
    Contains the policy settings for the group administrator.
    The following elements are only used in AS data mode:
    dialableCallerIDAccess
    communicationBarringUserProfileAccess (This element will not be returned in the
    response for Service Provider group administrators)
    """

    _ELEMENTS = (
        E(
            "profile_access",
            "profileAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_access",
            "userAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "admin_access",
            "adminAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_access",
            "departmentAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_device_access",
            "accessDeviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enhanced_service_instance_access",
            "enhancedServiceInstanceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "feature_access_code_access",
            "featureAccessCodeAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number_extension_access",
            "phoneNumberExtensionAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_number_access",
            "callingLineIdNumberAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_access",
            "serviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "trunk_group_access",
            "trunkGroupAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "session_admission_control_access",
            "sessionAdmissionControlAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "office_zone_access",
            "officeZoneAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_activation_access",
            "numberActivationAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "dialable_caller_id_access",
            "dialableCallerIDAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "communication_barring_user_profile_access",
            "communicationBarringUserProfileAccess",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* profileAccess
    profile_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userAccess
    user_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* adminAccess
    admin_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAccess
    department_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* enhancedServiceInstanceAccess
    enhanced_service_instance_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* featureAccessCodeAccess
    feature_access_code_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdNumberAccess
    calling_line_id_number_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* serviceAccess
    service_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* trunkGroupAccess
    trunk_group_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* sessionAdmissionControlAccess
    session_admission_control_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* officeZoneAccess
    office_zone_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* numberActivationAccess
    number_activation_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* dialableCallerIDAccess
    dialable_caller_id_access = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* communicationBarringUserProfileAccess
    communication_barring_user_profile_access = Field(
        type=str,
        required=False,
    )


class GroupAdminGetPolicyResponse20(OCIResponse):
    """
    Response to ``GroupAdminGetPolicyRequest20()``.
    Contains the policy settings for the group administrator.
    The following elements are only used in AS data mode:
    dialableCallerIDAccess
    verifyTranslationAndroutingAccess
    communicationBarringUserProfileAccess (This element is only returned for groups
    in an enterprise)
    """

    _ELEMENTS = (
        E(
            "profile_access",
            "profileAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_access",
            "userAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "admin_access",
            "adminAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_access",
            "departmentAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_device_access",
            "accessDeviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enhanced_service_instance_access",
            "enhancedServiceInstanceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "feature_access_code_access",
            "featureAccessCodeAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number_extension_access",
            "phoneNumberExtensionAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_number_access",
            "callingLineIdNumberAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_access",
            "serviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "trunk_group_access",
            "trunkGroupAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "session_admission_control_access",
            "sessionAdmissionControlAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "office_zone_access",
            "officeZoneAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_activation_access",
            "numberActivationAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "dialable_caller_id_access",
            "dialableCallerIDAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "verify_translation_and_routing_access",
            "verifyTranslationAndRoutingAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "communication_barring_user_profile_access",
            "communicationBarringUserProfileAccess",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* profileAccess
    profile_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userAccess
    user_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* adminAccess
    admin_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAccess
    department_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* enhancedServiceInstanceAccess
    enhanced_service_instance_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* featureAccessCodeAccess
    feature_access_code_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdNumberAccess
    calling_line_id_number_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* serviceAccess
    service_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* trunkGroupAccess
    trunk_group_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* sessionAdmissionControlAccess
    session_admission_control_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* officeZoneAccess
    office_zone_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* numberActivationAccess
    number_activation_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* dialableCallerIDAccess
    dialable_caller_id_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* verifyTranslationAndRoutingAccess
    verify_translation_and_routing_access = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* communicationBarringUserProfileAccess
    communication_barring_user_profile_access = Field(
        type=str,
        required=False,
    )


class GroupAdminGetResponse(OCIResponse):
    """
    Response to the ``GroupAdminGetRequest()``.
    The response contains the group administrators profile information.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "first_name",
            "firstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "last_name",
            "lastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "language",
            "language",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* firstName
    first_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* lastName
    last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* language
    language = Field(
        type=str,
        required=True,
    )


class GroupAdviceOfChargeGetResponse(OCIResponse):
    """
    Response to ``GroupAdviceOfChargeGetRequest()``.
    Contains a list of Advice of Charge group parameters.
    """

    _ELEMENTS = (
        E(
            "use_group_level_ao_c_settings",
            "useGroupLevelAoCSettings",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "delay_between_notification_seconds",
            "delayBetweenNotificationSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useGroupLevelAoCSettings
    use_group_level_ao_c_settings = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* delayBetweenNotificationSeconds
    delay_between_notification_seconds = Field(
        type=int,
        required=True,
    )


class GroupAnnouncementFileGetListResponse(OCIResponse):
    """
    Response to ``GroupAnnouncementFileGetAvailableListRequest()``.
    When requested, the response contains a table with columns: "Name", "Media Type"
    and "File Size".
    The "Name" column contains the name of the announcement file.
    The "Media Type" column contains the media type of the announcement
    File with the possible values:
    WMA - Windows Media Audio file
    WAV - A WAV file
    3GP - A 3GP file
    MOV - A MOV file using a H.263 or H.264 codec.
    The "File Size" column contains the file size (KB) of the announcement file.
    The response also contains the current total file size (KB) for the group across
    all media types and the maximum total file size (MB) allowed for the group.
    """

    _ELEMENTS = (
        E(
            "announcement_table",
            "announcementTable",
            list,
            True,
            False,
            False,
            True,
        ),
        E(
            "total_file_size",
            "totalFileSize",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_file_size",
            "maxFileSize",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: list: *Optional* announcementTable  *Tabular*
    announcement_table = Field(
        type=list,
        required=False,
    )
    #: int: *Required* totalFileSize
    total_file_size = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxFileSize
    max_file_size = Field(
        type=int,
        required=True,
    )


class GroupAnnouncementFileGetResponse(OCIResponse):
    """
    Response to ``GroupAnnouncementFileGetRequest()``.
    The response contains the file size, uploaded timestamp, description and usage for
    an announcement file in the user announcement repository.
    The usage table has columns "Service Name", and "Instance Name".
    The Service Name values correspond to string values of the GroupService and
    UserService data types.
    With the exception of the string "Voice Portal" which is returned when the
    announcement is being used by Voice Portal Personalized Name.
    """

    _ELEMENTS = (
        E(
            "description",
            "description",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "filesize",
            "filesize",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "last_uploaded",
            "lastUploaded",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "usage_table",
            "usageTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: str: *Required* description
    description = Field(
        type=str,
        required=True,
    )
    #: int: *Required* filesize
    filesize = Field(
        type=int,
        required=True,
    )
    #: str: *Required* lastUploaded
    last_uploaded = Field(
        type=str,
        required=True,
    )
    #: list: *Required* usageTable  *Tabular*
    usage_table = Field(
        type=list,
        required=True,
    )


class GroupApplicationServerSetGetResponse(OCIResponse):
    """
    Response to the ``GroupApplicationServerSetGetRequest()``.
    The response contains the group's Application Server set information.
    """

    _ELEMENTS = (
        E(
            "application_server_set_name",
            "applicationServerSetName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* applicationServerSetName
    application_server_set_name = Field(
        type=str,
        required=False,
    )


class GroupAutoAttendantGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupAutoAttendantGetInstanceListRequest()``.
    Contains a table with column headings:
    "Service User Id", "Name", "Video", "Phone Number", "Extension", "Department",
    "Is Active", "Type".
    The column values for "Video" and "Is Active" can either be true, or false.
    The column values for "Type" can either be Basic or Standard.

    In HSS Mode the value for the "Type" column will always be populated with Basic.
    """

    _ELEMENTS = (
        E(
            "auto_attendant_table",
            "autoAttendantTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* autoAttendantTable  *Tabular*
    auto_attendant_table = Field(
        type=list,
        required=True,
    )


class GroupAutoAttendantSubmenuGetListResponse(OCIResponse):
    """
    Response to the ``GroupAutoAttendantSubmenuGetListRequest()``.
    Contains a table with column headings:
    "Submenu Id" "Is Used".
    The column values for "Is Used" can either be true, or false.
    """

    _ELEMENTS = (
        E(
            "submenu_table",
            "submenuTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* submenuTable  *Tabular*
    submenu_table = Field(
        type=list,
        required=True,
    )


class GroupAutoAttendantSubmenuGetUsageListResponse(OCIResponse):
    """
    Response to the ``GroupAutoAttendantSubmenuGetUsageListRequest()``.
    Contains a table with column headings:
    "Type" and "Submenu ID".

    The "Type" Column will contain one of the following: Business Hours Menu,
    After Hours Menu, Holiday Menu or Submenu.

    The "Submenu ID" Column will be left blank when the "Type" Column contains one
    of the base menu types (Business Hours Menu, After Hours Menu or Holiday Menu),
    and will contain the Submenu ID when the "Type" Column contains type Submenu.
    """

    _ELEMENTS = (
        E(
            "submenu_table",
            "submenuTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* submenuTable  *Tabular*
    submenu_table = Field(
        type=list,
        required=True,
    )


class GroupBroadWorksAnywhereGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupBroadWorksAnywhereGetInstanceListRequest()``.
    Contains a table with column headings:
    "Service User Id", "Name", "Phone Number", "Extension", "Department", "Is Active".
    The column value for "Is Active" can either be true, or false.
    """

    _ELEMENTS = (
        E(
            "broad_works_anywhere_table",
            "broadWorksAnywhereTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* broadWorksAnywhereTable  *Tabular*
    broad_works_anywhere_table = Field(
        type=list,
        required=True,
    )


class GroupBroadWorksMobileManagerGetDomainListResponse(OCIResponse):
    """
    Response to the ``GroupBroadWorksMobileManagerGetDomainListRequest()``.
    Contains the list of domains.
    """

    _ELEMENTS = (
        E(
            "domain_name",
            "domainName",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* domainName  *Array*
    domain_name = Field(
        type=list,
        required=False,
    )


class GroupBroadWorksMobileManagerGetHomeZoneListResponse(OCIResponse):
    """
    Response to the ``GroupBroadWorksMobileManagerGetHomeZoneListRequest()``.
    Contains a table with column headings:
    "Home Zone Id", "Domain Name", "Mobile Country Code",
    "Mobile Network Code", "Local Area Code" and "Cell Identity".
    """

    _ELEMENTS = (
        E(
            "home_zones_table",
            "homeZonesTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* homeZonesTable  *Tabular*
    home_zones_table = Field(
        type=list,
        required=True,
    )


class GroupBroadWorksMobileManagerGetHomeZoneResponse(OCIResponse):
    """
    Response to the ``GroupBroadWorksMobileManagerGetHomeZoneRequest()``
    """

    _ELEMENTS = (
        E(
            "home_zone_domain_name",
            "homeZoneDomainName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "mobile_country_code",
            "mobileCountryCode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "mobile_network_code",
            "mobileNetworkCode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "location_area_code",
            "locationAreaCode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "cell_identity",
            "cellIdentity",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* homeZoneDomainName
    home_zone_domain_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* mobileCountryCode
    mobile_country_code = Field(
        type=str,
        required=True,
    )
    #: str: *Required* mobileNetworkCode
    mobile_network_code = Field(
        type=str,
        required=True,
    )
    #: str: *Required* locationAreaCode
    location_area_code = Field(
        type=str,
        required=True,
    )
    #: str: *Required* cellIdentity
    cell_identity = Field(
        type=str,
        required=True,
    )


class GroupBroadWorksMobileManagerGetResponse(OCIResponse):
    """
    Response to the ``GroupBroadWorksMobileManagerGetRequest()``
    """

    _ELEMENTS = (
        E(
            "mobile_manager_id",
            "mobileManagerId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "local_to_carrier",
            "localToCarrier",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "deactivation_reason",
            "deactivationReason",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_tx_per_second_enabled",
            "maxTxPerSecondEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_tx_per_second",
            "maxTxPerSecond",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "tldn_enabled",
            "tldnEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "generic_number_enabled",
            "genericNumberEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "mobile_state_check_enabled",
            "mobileStateCheckEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "location_based_services_enabled",
            "locationBasedServicesEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* mobileManagerId
    mobile_manager_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* localToCarrier
    local_to_carrier = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* deactivationReason
    deactivation_reason = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* maxTxPerSecondEnabled
    max_tx_per_second_enabled = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* maxTxPerSecond
    max_tx_per_second = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* tldnEnabled
    tldn_enabled = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* genericNumberEnabled
    generic_number_enabled = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* mobileStateCheckEnabled
    mobile_state_check_enabled = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* locationBasedServicesEnabled
    location_based_services_enabled = Field(
        type=bool,
        required=True,
    )


class GroupBroadWorksMobilityGetResponse(OCIResponse):
    """
    The response to a ``GroupBroadWorksMobilityGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "use_setting_level",
            "useSettingLevel",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_location_services",
            "enableLocationServices",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_msrn_lookup",
            "enableMSRNLookup",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_mobile_state_checking",
            "enableMobileStateChecking",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "deny_call_originations",
            "denyCallOriginations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "deny_call_terminations",
            "denyCallTerminations",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enableLocationServices
    enable_location_services = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableMSRNLookup
    enable_msrn_lookup = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableMobileStateChecking
    enable_mobile_state_checking = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* denyCallOriginations
    deny_call_originations = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* denyCallTerminations
    deny_call_terminations = Field(
        type=bool,
        required=True,
    )


class GroupBroadWorksMobilityGetResponse19sp1(OCIResponse):
    """
    The response to a ``GroupBroadWorksMobilityGetRequest19sp1()``.
    """

    _ELEMENTS = (
        E(
            "use_setting_level",
            "useSettingLevel",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_location_services",
            "enableLocationServices",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_msrn_lookup",
            "enableMSRNLookup",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_mobile_state_checking",
            "enableMobileStateChecking",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "deny_call_originations",
            "denyCallOriginations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "deny_call_terminations",
            "denyCallTerminations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_announcement_suppression",
            "enableAnnouncementSuppression",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enableLocationServices
    enable_location_services = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableMSRNLookup
    enable_msrn_lookup = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableMobileStateChecking
    enable_mobile_state_checking = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* denyCallOriginations
    deny_call_originations = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* denyCallTerminations
    deny_call_terminations = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableAnnouncementSuppression
    enable_announcement_suppression = Field(
        type=bool,
        required=True,
    )


class GroupBroadWorksMobilityMobileSubscriberDirectoryNumberGetAssignmentListResponse(
    OCIResponse,
):
    """
    Response to the ``GroupBroadWorksMobilityMobileSubscriberDirectoryNumberGetAssignmentListRequest()``.
    The response contains a table with columns: "Mobile Number", "User Id",
    "Last Name", "First Name","Phone Number", "Extension", "Department",.
    The "Mobile Number" column contains a single DN.
    The "User Id", "Last Name" and "First Name" columns contains the corresponding
    attributes of the user possessing the DN(s).
    The "Phone Number" column contains a single DN.
    The "Department" column contains the department of the user if it is part of a department.
    """

    _ELEMENTS = (
        E(
            "mobile_subscriber_directory_number_table",
            "mobileSubscriberDirectoryNumberTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* mobileSubscriberDirectoryNumberTable  *Tabular*
    mobile_subscriber_directory_number_table = Field(
        type=list,
        required=True,
    )


class GroupBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListResponse(
    OCIResponse,
):
    """
    Response to ``GroupBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest()``.
    Contains a list of available Mobile Subscriber Directory Numbers not yet assigned
    to any user.
    """

    _ELEMENTS = (
        E(
            "mobile_subscriber_directory_number",
            "mobileSubscriberDirectoryNumber",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* mobileSubscriberDirectoryNumber  *Array*
    mobile_subscriber_directory_number = Field(
        type=list,
        required=False,
    )


class GroupCallCapacityManagementGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupCallCapacityManagementGetAvailableUserListRequest()``.
    Contains a table with column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupCallCapacityManagementGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupCallCapacityManagementGetInstanceListRequest()``.
    Contains a table with column headings: "Name", "Is Default", "Maximum Calls",
    "Maximum Incoming Calls", "Maximum Outgoing Calls".
    """

    _ELEMENTS = (
        E(
            "call_capacity_group_table",
            "callCapacityGroupTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* callCapacityGroupTable  *Tabular*
    call_capacity_group_table = Field(
        type=list,
        required=True,
    )


class GroupCallCapacityManagementGetInstanceResponse(OCIResponse):
    """
    Response to the ``GroupCallCapacityManagementGetInstanceRequest()``.
    Contains a table with column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_active_calls_allowed",
            "maxActiveCallsAllowed",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_incoming_active_calls_allowed",
            "maxIncomingActiveCallsAllowed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_outgoing_active_calls_allowed",
            "maxOutgoingActiveCallsAllowed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "default_group_for_new_users",
            "defaultGroupForNewUsers",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: str: *Required* name
    name = Field(
        type=str,
        required=True,
    )
    #: int: *Required* maxActiveCallsAllowed
    max_active_calls_allowed = Field(
        type=int,
        required=True,
    )
    #: int: *Optional* maxIncomingActiveCallsAllowed
    max_incoming_active_calls_allowed = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* maxOutgoingActiveCallsAllowed
    max_outgoing_active_calls_allowed = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* defaultGroupForNewUsers
    default_group_for_new_users = Field(
        type=bool,
        required=True,
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupCallCenterAgentThresholdDefaultProfileGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterAgentThresholdDefaultProfileGetRequest()``.
    The agent table contains the agents assigned to the profile and
    has column headings: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address";
    """

    _ELEMENTS = (
        E(
            "profile_name",
            "profileName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "profile_description",
            "profileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_call_state_idle_time_yellow",
            "thresholdCurrentCallStateIdleTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_call_state_idle_time_red",
            "thresholdCurrentCallStateIdleTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_call_state_on_call_time_yellow",
            "thresholdCurrentCallStateOnCallTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_call_state_on_call_time_red",
            "thresholdCurrentCallStateOnCallTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_yellow",
            "thresholdCurrentAgentStateUnavailableTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_red",
            "thresholdCurrentAgentStateUnavailableTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_busy_in_time_yellow",
            "thresholdAverageBusyInTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_busy_in_time_red",
            "thresholdAverageBusyInTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_busy_out_time_yellow",
            "thresholdAverageBusyOutTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_busy_out_time_red",
            "thresholdAverageBusyOutTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_wrap_up_time_yellow",
            "thresholdAverageWrapUpTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_wrap_up_time_red",
            "thresholdAverageWrapUpTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_notification_email",
            "enableNotificationEmail",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "notification_email_address",
            "notificationEmailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "agent_table",
            "agentTable",
            list,
            True,
            False,
            False,
            True,
        ),
    )
    #: str: *Required* profileName
    profile_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* profileDescription
    profile_description = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* thresholdCurrentCallStateIdleTimeYellow
    threshold_current_call_state_idle_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentCallStateIdleTimeRed
    threshold_current_call_state_idle_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentCallStateOnCallTimeYellow
    threshold_current_call_state_on_call_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentCallStateOnCallTimeRed
    threshold_current_call_state_on_call_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentAgentStateUnavailableTimeYellow
    threshold_current_agent_state_unavailable_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentAgentStateUnavailableTimeRed
    threshold_current_agent_state_unavailable_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageBusyInTimeYellow
    threshold_average_busy_in_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageBusyInTimeRed
    threshold_average_busy_in_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageBusyOutTimeYellow
    threshold_average_busy_out_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageBusyOutTimeRed
    threshold_average_busy_out_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageWrapUpTimeYellow
    threshold_average_wrap_up_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageWrapUpTimeRed
    threshold_average_wrap_up_time_red = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* enableNotificationEmail
    enable_notification_email = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* notificationEmailAddress
    notification_email_address = Field(
        type=str,
        required=False,
    )
    #: list: *Optional* agentTable  *Tabular*
    agent_table = Field(
        type=list,
        required=False,
    )


class GroupCallCenterAgentThresholdProfileGetAvailableAgentListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterAgentThresholdProfileGetAvailableAgentListRequest()``.
    Contains a table with column headings: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address", "Agent Threshold Profile";
    """

    _ELEMENTS = (
        E(
            "agent_table",
            "agentTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* agentTable  *Tabular*
    agent_table = Field(
        type=list,
        required=True,
    )


class GroupCallCenterAgentThresholdProfileGetListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterAgentThresholdProfileGetListRequest()``.
    Contains a table with all the  Call Center Agent Threshold Profiles in the Group.
    The column headings are: "Default", "Name", "Description".
    """

    _ELEMENTS = (
        E(
            "profiles_table",
            "profilesTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* profilesTable  *Tabular*
    profiles_table = Field(
        type=list,
        required=True,
    )


class GroupCallCenterAgentThresholdProfileGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterAgentThresholdProfileGetRequest()``.
    The agentTable contains the agents assigned to the profile and has the column headings:
    "User Id", "Group Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana
    First Name",
    "Phone Number", "Extension", "Department", "Email Address";
    """

    _ELEMENTS = (
        E(
            "profile_description",
            "profileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_call_state_idle_time_yellow",
            "thresholdCurrentCallStateIdleTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_call_state_idle_time_red",
            "thresholdCurrentCallStateIdleTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_call_state_on_call_time_yellow",
            "thresholdCurrentCallStateOnCallTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_call_state_on_call_time_red",
            "thresholdCurrentCallStateOnCallTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_yellow",
            "thresholdCurrentAgentStateUnavailableTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_agent_state_unavailable_time_red",
            "thresholdCurrentAgentStateUnavailableTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_busy_in_time_yellow",
            "thresholdAverageBusyInTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_busy_in_time_red",
            "thresholdAverageBusyInTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_busy_out_time_yellow",
            "thresholdAverageBusyOutTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_busy_out_time_red",
            "thresholdAverageBusyOutTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_wrap_up_time_yellow",
            "thresholdAverageWrapUpTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_wrap_up_time_red",
            "thresholdAverageWrapUpTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_notification_email",
            "enableNotificationEmail",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "notification_email_address",
            "notificationEmailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "agent_table",
            "agentTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: str: *Optional* profileDescription
    profile_description = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* thresholdCurrentCallStateIdleTimeYellow
    threshold_current_call_state_idle_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentCallStateIdleTimeRed
    threshold_current_call_state_idle_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentCallStateOnCallTimeYellow
    threshold_current_call_state_on_call_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentCallStateOnCallTimeRed
    threshold_current_call_state_on_call_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentAgentStateUnavailableTimeYellow
    threshold_current_agent_state_unavailable_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentAgentStateUnavailableTimeRed
    threshold_current_agent_state_unavailable_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageBusyInTimeYellow
    threshold_average_busy_in_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageBusyInTimeRed
    threshold_average_busy_in_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageBusyOutTimeYellow
    threshold_average_busy_out_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageBusyOutTimeRed
    threshold_average_busy_out_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageWrapUpTimeYellow
    threshold_average_wrap_up_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageWrapUpTimeRed
    threshold_average_wrap_up_time_red = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* enableNotificationEmail
    enable_notification_email = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* notificationEmailAddress
    notification_email_address = Field(
        type=str,
        required=False,
    )
    #: list: *Required* agentTable  *Tabular*
    agent_table = Field(
        type=list,
        required=True,
    )


class GroupCallCenterAgentUnavailableCodeGetListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterAgentUnavailableCodeGetListRequest()``.
    Contains a table with column headings: "Is Active", "Code", "Description".
    """

    _ELEMENTS = (
        E(
            "unavailable_codes_table",
            "unavailableCodesTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* unavailableCodesTable  *Tabular*
    unavailable_codes_table = Field(
        type=list,
        required=True,
    )


class GroupCallCenterAgentUnavailableCodeGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterAgentUnavailableCodeGetRequest()``
    """

    _ELEMENTS = (
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class GroupCallCenterAgentUnavailableCodeSettingsGetResponse(OCIResponse):
    """
    Response to ``GroupCallCenterAgentUnavailableCodeSettingsGetRequest()``.

    Replaced by ``GroupCallCenterAgentUnavailableCodeSettingsGetResponse17sp4()``.
    """

    _ELEMENTS = (
        E(
            "enable_agent_unavailable_codes",
            "enableAgentUnavailableCodes",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "default_agent_unavailable_code_on_dnd",
            "defaultAgentUnavailableCodeOnDND",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "default_agent_unavailable_code_on_personal_calls",
            "defaultAgentUnavailableCodeOnPersonalCalls",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "default_agent_unavailable_code_on_consecutive_bounces",
            "defaultAgentUnavailableCodeOnConsecutiveBounces",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "force_use_of_agent_unavailable_codes",
            "forceUseOfAgentUnavailableCodes",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "default_agent_unavailable_code",
            "defaultAgentUnavailableCode",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* enableAgentUnavailableCodes
    enable_agent_unavailable_codes = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* defaultAgentUnavailableCodeOnDND
    default_agent_unavailable_code_on_dnd = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* defaultAgentUnavailableCodeOnPersonalCalls
    default_agent_unavailable_code_on_personal_calls = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* defaultAgentUnavailableCodeOnConsecutiveBounces
    default_agent_unavailable_code_on_consecutive_bounces = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* forceUseOfAgentUnavailableCodes
    force_use_of_agent_unavailable_codes = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* defaultAgentUnavailableCode
    default_agent_unavailable_code = Field(
        type=str,
        required=False,
    )


class GroupCallCenterAgentUnavailableCodeSettingsGetResponse17sp4(OCIResponse):
    """
    Response to ``GroupCallCenterAgentUnavailableCodeSettingsGetRequest17sp4()``.
    """

    _ELEMENTS = (
        E(
            "enable_agent_unavailable_codes",
            "enableAgentUnavailableCodes",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "default_agent_unavailable_code_on_dnd",
            "defaultAgentUnavailableCodeOnDND",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "default_agent_unavailable_code_on_personal_calls",
            "defaultAgentUnavailableCodeOnPersonalCalls",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "default_agent_unavailable_code_on_consecutive_bounces",
            "defaultAgentUnavailableCodeOnConsecutiveBounces",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "default_agent_unavailable_code_on_not_reachable",
            "defaultAgentUnavailableCodeOnNotReachable",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "force_use_of_agent_unavailable_codes",
            "forceUseOfAgentUnavailableCodes",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "default_agent_unavailable_code",
            "defaultAgentUnavailableCode",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* enableAgentUnavailableCodes
    enable_agent_unavailable_codes = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* defaultAgentUnavailableCodeOnDND
    default_agent_unavailable_code_on_dnd = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* defaultAgentUnavailableCodeOnPersonalCalls
    default_agent_unavailable_code_on_personal_calls = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* defaultAgentUnavailableCodeOnConsecutiveBounces
    default_agent_unavailable_code_on_consecutive_bounces = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* defaultAgentUnavailableCodeOnNotReachable
    default_agent_unavailable_code_on_not_reachable = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* forceUseOfAgentUnavailableCodes
    force_use_of_agent_unavailable_codes = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* defaultAgentUnavailableCode
    default_agent_unavailable_code = Field(
        type=str,
        required=False,
    )


class GroupCallCenterBouncedCallGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterBouncedCallGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_of_rings_before_bouncing_call",
            "numberOfRingsBeforeBouncingCall",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_transfer",
            "enableTransfer",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "transfer_phone_number",
            "transferPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "bounce_call_when_agent_unavailable",
            "bounceCallWhenAgentUnavailable",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* numberOfRingsBeforeBouncingCall
    number_of_rings_before_bouncing_call = Field(
        type=int,
        required=True,
    )
    #: bool: *Optional* enableTransfer
    enable_transfer = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* transferPhoneNumber
    transfer_phone_number = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* bounceCallWhenAgentUnavailable
    bounce_call_when_agent_unavailable = Field(
        type=bool,
        required=True,
    )


class GroupCallCenterBouncedCallGetResponse17(OCIResponse):
    """
    Response to the ``GroupCallCenterBouncedCallGetRequest17()``.
    """

    _ELEMENTS = (
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_of_rings_before_bouncing_call",
            "numberOfRingsBeforeBouncingCall",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_transfer",
            "enableTransfer",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "transfer_phone_number",
            "transferPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "bounce_call_when_agent_unavailable",
            "bounceCallWhenAgentUnavailable",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "alert_call_center_call_on_hold",
            "alertCallCenterCallOnHold",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "alert_call_center_call_on_hold_seconds",
            "alertCallCenterCallOnHoldSeconds",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "bounce_call_center_call_on_hold",
            "bounceCallCenterCallOnHold",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "bounce_call_center_call_on_hold_seconds",
            "bounceCallCenterCallOnHoldSeconds",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* numberOfRingsBeforeBouncingCall
    number_of_rings_before_bouncing_call = Field(
        type=int,
        required=True,
    )
    #: bool: *Optional* enableTransfer
    enable_transfer = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* transferPhoneNumber
    transfer_phone_number = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* bounceCallWhenAgentUnavailable
    bounce_call_when_agent_unavailable = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* alertCallCenterCallOnHold
    alert_call_center_call_on_hold = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* alertCallCenterCallOnHoldSeconds
    alert_call_center_call_on_hold_seconds = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* bounceCallCenterCallOnHold
    bounce_call_center_call_on_hold = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* bounceCallCenterCallOnHoldSeconds
    bounce_call_center_call_on_hold_seconds = Field(
        type=int,
        required=False,
    )


class GroupCallCenterCallDispositionCodeGetListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterCallDispositionCodeGetListRequest()``.
    Contains a table with column headings: "Is Active", "Code", "Description".
    """

    _ELEMENTS = (
        E(
            "disposition_codes_table",
            "dispositionCodesTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* dispositionCodesTable  *Tabular*
    disposition_codes_table = Field(
        type=list,
        required=True,
    )


class GroupCallCenterCallDispositionCodeGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterCallDispositionCodeGetRequest()``
    """

    _ELEMENTS = (
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class GroupCallCenterCallDispositionCodeGetUsageListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterCallDispositionCodeGetUsageListRequest()``.
    The Type column contains either "Call Center" or "Route Point".
    Contains a table with column headings: "Id", "Name" and "Type".
    """

    _ELEMENTS = (
        E(
            "call_center_table",
            "callCenterTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* callCenterTable  *Tabular*
    call_center_table = Field(
        type=list,
        required=True,
    )


class GroupCallCenterComfortMessageBypassGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterComfortMessageBypassGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "call_waiting_age_threshold_seconds",
            "callWaitingAgeThresholdSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "play_announcement_after_ringing",
            "playAnnouncementAfterRinging",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "ring_time_before_playing_announcement_seconds",
            "ringTimeBeforePlayingAnnouncementSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_message_selection",
            "audioMessageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_file_url",
            "audioFileUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_file_description",
            "audioFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_media_type",
            "audioMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_message_selection",
            "videoMessageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "video_file_url",
            "videoFileUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_file_description",
            "videoFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_media_type",
            "videoMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* callWaitingAgeThresholdSeconds
    call_waiting_age_threshold_seconds = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* playAnnouncementAfterRinging
    play_announcement_after_ringing = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* ringTimeBeforePlayingAnnouncementSeconds
    ring_time_before_playing_announcement_seconds = Field(
        type=int,
        required=True,
    )
    #: str: *Required* audioMessageSelection
    audio_message_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* audioFileUrl
    audio_file_url = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioMediaType
    audio_media_type = Field(
        type=str,
        required=False,
    )
    #: str: *Required* videoMessageSelection
    video_message_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* videoFileUrl
    video_file_url = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoFileDescription
    video_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoMediaType
    video_media_type = Field(
        type=str,
        required=False,
    )


class GroupCallCenterCurrentAndPastAgentGetListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterCurrentAndPastAgentGetListRequest()``.
    Contains a table with column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "agent_user_table",
            "agentUserTable",
            list,
            True,
            True,
            False,
            True,
        ),
        E(
            "deleted_agent_user_table",
            "deletedAgentUserTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* agentUserTable  *Tabular*
    agent_user_table = Field(
        type=list,
        required=True,
    )
    #: list: *Required* deletedAgentUserTable  *Tabular*
    deleted_agent_user_table = Field(
        type=list,
        required=True,
    )


class GroupCallCenterCurrentAndPastCallCenterGetListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterCurrentAndPastCallCenterGetListRequest()``.
    """

    _ELEMENTS = (
        E(
            "service_user_id",
            "serviceUserId",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "deleted_service_user_id",
            "deletedServiceUserId",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* serviceUserId  *Array*
    service_user_id = Field(
        type=list,
        required=False,
    )
    #: list(str): *Optional* deletedServiceUserId  *Array*
    deleted_service_user_id = Field(
        type=list,
        required=False,
    )


class GroupCallCenterCurrentAndPastDNISGetListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterCurrentAndPastDNISGetListRequest()``.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "deleted_name",
            "deletedName",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* name  *Array*
    name = Field(
        type=list,
        required=False,
    )
    #: list(str): *Optional* deletedName  *Array*
    deleted_name = Field(
        type=list,
        required=False,
    )


class GroupCallCenterDistinctiveRingingGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterDistinctiveRingingGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "distinctive_ringing_call_center_calls",
            "distinctiveRingingCallCenterCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "distinctive_ringing_ring_pattern_for_call_center",
            "distinctiveRingingRingPatternForCallCenter",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "distinctive_ringing_force_delivery_ring_pattern",
            "distinctiveRingingForceDeliveryRingPattern",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* distinctiveRingingCallCenterCalls
    distinctive_ringing_call_center_calls = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* distinctiveRingingRingPatternForCallCenter
    distinctive_ringing_ring_pattern_for_call_center = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* distinctiveRingingForceDeliveryRingPattern
    distinctive_ringing_force_delivery_ring_pattern = Field(
        type=str,
        required=False,
    )


class GroupCallCenterEnhancedGetResponse(OCIResponse):
    """
    Response to ``GroupCallCenterEnhancedGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "override_agent_wrap_up_time",
            "overrideAgentWrapUpTime",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "wrap_up_seconds",
            "wrapUpSeconds",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* overrideAgentWrapUpTime
    override_agent_wrap_up_time = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* wrapUpSeconds
    wrap_up_seconds = Field(
        type=int,
        required=False,
    )


class GroupCallCenterEnhancedReportingBrandingGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterEnhancedReportingBrandingGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "branding_choice",
            "brandingChoice",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "branding_file_description",
            "brandingFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* brandingChoice
    branding_choice = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* brandingFileDescription
    branding_file_description = Field(
        type=str,
        required=False,
    )


class GroupCallCenterEnhancedReportingGetAvailableReportTemplateListResponse(
    OCIResponse,
):
    """
    Response to ``GroupCallCenterEnhancedReportingGetAvailableReportTemplateListRequest()``.
    Contains a table with column headings: "Name", "Description" and "Level", "Is
    Agent Required",
    "Is Call Center Required", "Is Call Center Dnis Required","Is Real Time Report",
    "Is Sampling Period Required",
    "Call Completion Threshold Parameter", "Short Duration Threshold Parameter",
    "Service Level Threshold Parameter", "Service Level Inclusions Parameter",
    "Service Level Objective Threshold Parameter",
    "Abandoned Call Threshold Parameter", "Service Level Threshold Parameter Number",
    and "Abandoned Call Threshold Parameter Number".
    The possible values for "Level" are "System" and "Group".
    The possible values for "Is Agent Required", "Is Call Center Required", "Is Call
    Center Dnis Required",
    "Is Real Time Report" and "Is Sampling Period Required" are "true" and "false".
    The possible values for "Call Completion Threshold Parameter", "Short Duration
    Threshold Parameter",
    "Service Level Threshold Parameter", "Service Level Inclusions
    Parameter","Service Level Objective Threshold Parameter"
    and "Abandoned Call Threshold Parameter" are "Required", "Hidden" and "Does Not Apply".
    """

    _ELEMENTS = (
        E(
            "report_template_table",
            "reportTemplateTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* reportTemplateTable  *Tabular*
    report_template_table = Field(
        type=list,
        required=True,
    )


class GroupCallCenterEnhancedReportingGetResponse(OCIResponse):
    """
    Response to ``GroupCallCenterEnhancedReportingGetRequest()``.

    Replaced by ``GroupCallCenterEnhancedReportingGetResponse19()``
    """

    _ELEMENTS = (
        E(
            "reporting_server",
            "reportingServer",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "web_statistic_source",
            "webStatisticSource",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* reportingServer
    reporting_server = Field(
        type=str,
        required=True,
    )
    #: str: *Required* webStatisticSource
    web_statistic_source = Field(
        type=str,
        required=True,
    )


class GroupCallCenterEnhancedReportingGetResponse19(OCIResponse):
    """
    Response to ``GroupCallCenterEnhancedReportingGetRequest19()``.
    """

    _ELEMENTS = (
        E(
            "reporting_server",
            "reportingServer",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* reportingServer
    reporting_server = Field(
        type=str,
        required=True,
    )


class GroupCallCenterEnhancedReportingReportTemplateGetListResponse(OCIResponse):
    """
    Response to ``GroupCallCenterEnhancedReportingReportTemplateGetListRequest()``.
    Contains a table with column headings: "Name", "Description", "Type" and "Enabled"
    """

    _ELEMENTS = (
        E(
            "report_template_table",
            "reportTemplateTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* reportTemplateTable  *Tabular*
    report_template_table = Field(
        type=list,
        required=True,
    )


class GroupCallCenterEnhancedReportingReportTemplateGetResponse(OCIResponse):
    """
    Response to ``GroupCallCenterEnhancedReportingReportTemplateGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "data_template",
            "dataTemplate",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "filter_number",
            "filterNumber",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "xslt_template_description",
            "xsltTemplateDescription",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "scope",
            "scope",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_enabled",
            "isEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_realtime_report",
            "isRealtimeReport",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "call_completion_threshold_param",
            "callCompletionThresholdParam",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "short_duration_threshold_param",
            "shortDurationThresholdParam",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_level_threshold_param",
            "serviceLevelThresholdParam",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_level_inclusions_param",
            "serviceLevelInclusionsParam",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_level_objective_threshold_param",
            "serviceLevelObjectiveThresholdParam",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "abandoned_call_threshold_param",
            "abandonedCallThresholdParam",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_level_threshold_param_number",
            "serviceLevelThresholdParamNumber",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "abandoned_call_threshold_param_number",
            "abandonedCallThresholdParamNumber",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "filter_value",
            "filterValue",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )
    #: str: *Required* dataTemplate
    data_template = Field(
        type=str,
        required=True,
    )
    #: int: *Optional* filterNumber
    filter_number = Field(
        type=int,
        required=False,
    )
    #: str: *Required* xsltTemplateDescription
    xslt_template_description = Field(
        type=str,
        required=True,
    )
    #: str: *Required* scope
    scope = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* isEnabled
    is_enabled = Field(
        type=bool,
        required=True,
    )
    #: bool: *Optional* isRealtimeReport
    is_realtime_report = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* callCompletionThresholdParam
    call_completion_threshold_param = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* shortDurationThresholdParam
    short_duration_threshold_param = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceLevelThresholdParam
    service_level_threshold_param = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceLevelInclusionsParam
    service_level_inclusions_param = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceLevelObjectiveThresholdParam
    service_level_objective_threshold_param = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* abandonedCallThresholdParam
    abandoned_call_threshold_param = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* serviceLevelThresholdParamNumber
    service_level_threshold_param_number = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* abandonedCallThresholdParamNumber
    abandoned_call_threshold_param_number = Field(
        type=int,
        required=False,
    )
    #: str: *Optional* filterValue
    filter_value = Field(
        type=str,
        required=False,
    )


class GroupCallCenterEnhancedReportingScheduledReportGetActiveListResponse(OCIResponse):
    """
    Response to ``GroupCallCenterEnhancedReportingScheduledReportGetActiveListRequest()``
    Contains a table with column headings : "Schedule Name", "Description", "Created By",
    "Is Supervisor Report", "Report Template Name", "Report Template Level" and "Recurring".
    The "Created By" can be either "Administrator" or user id if created by supervisor.
    The possible values for "Recurring" are "None", "Daily", "Weekly", "Monthly" and "Yearly".
    The possible values for "Report Template Level" are "System" and "Group".
    """

    _ELEMENTS = (
        E(
            "scheduled_report_table",
            "scheduledReportTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* scheduledReportTable  *Tabular*
    scheduled_report_table = Field(
        type=list,
        required=True,
    )


class GroupCallCenterEnhancedReportingScheduledReportGetCompletedListResponse(
    OCIResponse,
):
    """
    Response to ``GroupCallCenterEnhancedReportingScheduledReportGetCompletedListRequest()``
    Contains a table with column headings : "Schedule Name", "Description", "Created By",
    "Is Supervisor Report", "Report Template Name", "Report Template Level" and "Recurring".
    The "Created By" can be either "Administrator" or user id if created by supervisor.
    The possible values for "Recurring" are "None", "Daily", "Weekly", "Monthly" and "Yearly".
    The possible values for "Report Template Level" are "System" and "Group".
    """

    _ELEMENTS = (
        E(
            "scheduled_report_table",
            "scheduledReportTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* scheduledReportTable  *Tabular*
    scheduled_report_table = Field(
        type=list,
        required=True,
    )


class GroupCallCenterEnhancedReportingScheduledReportGetListResponse(OCIResponse):
    """
    Response to ``GroupCallCenterEnhancedReportingScheduledReportGetListRequest()``.
    Contains a table with column headings : "Schedule Name", "Description", "Created By",
    "Is Supervisor Report", "Status", "Report Template Name", "Report Template Level"
    and "Recurring".
    The "Created By" can be either "Administrator" or user id if created by supervisor.
    The possible values for "Status" are "Active", and "Completed".
    The possible values for "Recurring" are "None", "Daily", "Weekly", "Monthly" and "Yearly".
    The possible values for "Report Template Level" are "System" and "Group".
    """

    _ELEMENTS = (
        E(
            "scheduled_report_table",
            "scheduledReportTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* scheduledReportTable  *Tabular*
    scheduled_report_table = Field(
        type=list,
        required=True,
    )


class GroupCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListResponse(
    OCIResponse,
):
    """
    Response to ``GroupCallCenterEnhancedReportingScheduledReportGetReportTemplateUsageListRequest()``.
    Contains a table with column headings: "Schedule Name", "Created By", "Created By
    Supervisor",
    and "Is Active".
    The "Created By" can be either "Administrator" or user id if created by supervisor.
    """

    _ELEMENTS = (
        E(
            "schedule_report_table",
            "scheduleReportTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* scheduleReportTable  *Tabular*
    schedule_report_table = Field(
        type=list,
        required=True,
    )


class GroupCallCenterForcedForwardingGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterForcedForwardingGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "forward_to_phone_number",
            "forwardToPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_enable_via_fac",
            "allowEnableViaFAC",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "play_announcement_before_forwarding",
            "playAnnouncementBeforeForwarding",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_message_selection",
            "audioMessageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_file_url",
            "audioFileUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_file_description",
            "audioFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_media_type",
            "audioMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_message_selection",
            "videoMessageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "video_file_url",
            "videoFileUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_file_description",
            "videoFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_media_type",
            "videoMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* forwardToPhoneNumber
    forward_to_phone_number = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* allowEnableViaFAC
    allow_enable_via_fac = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* playAnnouncementBeforeForwarding
    play_announcement_before_forwarding = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* audioMessageSelection
    audio_message_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* audioFileUrl
    audio_file_url = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioMediaType
    audio_media_type = Field(
        type=str,
        required=False,
    )
    #: str: *Required* videoMessageSelection
    video_message_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* videoFileUrl
    video_file_url = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoFileDescription
    video_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoMediaType
    video_media_type = Field(
        type=str,
        required=False,
    )


class GroupCallCenterGetAgentListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetAgentListRequest()``.
    Contains a table with column headings: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name", "Weight",
    "Phone Number", "Extension", "Department", "Email Address", "Skill Level".
    """

    _ELEMENTS = (
        E(
            "agent_table",
            "agentTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* agentTable  *Tabular*
    agent_table = Field(
        type=list,
        required=True,
    )


class GroupCallCenterGetAnnouncementResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetAnnouncementRequest()``.
    """

    _ELEMENTS = (
        E(
            "entrance_message_selection",
            "entranceMessageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "entrance_message_audio_file_description",
            "entranceMessageAudioFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "entrance_message_video_file_description",
            "entranceMessageVideoFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "periodic_comfort_message_selection",
            "periodicComfortMessageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "periodic_comfort_message_audio_file_description",
            "periodicComfortMessageAudioFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "periodic_comfort_message_video_file_description",
            "periodicComfortMessageVideoFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "on_hold_message_selection",
            "onHoldMessageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "on_hold_message_audio_file_description",
            "onHoldMessageAudioFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "on_hold_message_video_file_description",
            "onHoldMessageVideoFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* entranceMessageSelection
    entrance_message_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* entranceMessageAudioFileDescription
    entrance_message_audio_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* entranceMessageVideoFileDescription
    entrance_message_video_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Required* periodicComfortMessageSelection
    periodic_comfort_message_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* periodicComfortMessageAudioFileDescription
    periodic_comfort_message_audio_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* periodicComfortMessageVideoFileDescription
    periodic_comfort_message_video_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Required* onHoldMessageSelection
    on_hold_message_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* onHoldMessageAudioFileDescription
    on_hold_message_audio_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* onHoldMessageVideoFileDescription
    on_hold_message_video_file_description = Field(
        type=str,
        required=False,
    )


class GroupCallCenterGetAvailableAgentListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetAvailableAgentListRequest()``.
    Contains a table with column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupCallCenterGetAvailableSupervisorListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetAvailableSupervisorListRequest()``.
    Contains a table with column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupCallCenterGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetAvailableUserListRequest()``.
    Contains a table with column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name", "Hiragana First Name".
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupCallCenterGetDNISAgentListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetDNISAgentListRequest()``.
    Contains a table with column headings: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "agent_table",
            "agentTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* agentTable  *Tabular*
    agent_table = Field(
        type=list,
        required=True,
    )


class GroupCallCenterGetDNISListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetDNISListResponse()``.
    Contains a table with column headings: "Name", "Phone Number", "Extension",
    "Priority", "Is Primary DNIS".
    """

    _ELEMENTS = (
        E(
            "display_dnis_number",
            "displayDNISNumber",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "display_dnis_name",
            "displayDNISName",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "promote_calls_from_priority1to0",
            "promoteCallsFromPriority1to0",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "promote_calls_from_priority2to1",
            "promoteCallsFromPriority2to1",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "promote_calls_from_priority3to2",
            "promoteCallsFromPriority3to2",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "promote_calls_from_priority1to0_seconds",
            "promoteCallsFromPriority1to0Seconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "promote_calls_from_priority2to1_seconds",
            "promoteCallsFromPriority2to1Seconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "promote_calls_from_priority3to2_seconds",
            "promoteCallsFromPriority3to2Seconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "dnis_table",
            "dnisTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: bool: *Required* displayDNISNumber
    display_dnis_number = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* displayDNISName
    display_dnis_name = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* promoteCallsFromPriority1to0
    promote_calls_from_priority1to0 = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* promoteCallsFromPriority2to1
    promote_calls_from_priority2to1 = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* promoteCallsFromPriority3to2
    promote_calls_from_priority3to2 = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* promoteCallsFromPriority1to0Seconds
    promote_calls_from_priority1to0_seconds = Field(
        type=int,
        required=True,
    )
    #: int: *Required* promoteCallsFromPriority2to1Seconds
    promote_calls_from_priority2to1_seconds = Field(
        type=int,
        required=True,
    )
    #: int: *Required* promoteCallsFromPriority3to2Seconds
    promote_calls_from_priority3to2_seconds = Field(
        type=int,
        required=True,
    )
    #: list: *Required* dnisTable  *Tabular*
    dnis_table = Field(
        type=list,
        required=True,
    )


class GroupCallCenterGetDNISResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetDNISResponse()``.
    """

    _ELEMENTS = (
        E(
            "dnis_phone_number",
            "dnisPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "extension",
            "extension",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_custom_clid_settings",
            "useCustomCLIDSettings",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_phone_number",
            "callingLineIdPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_line_id_last_name",
            "callingLineIdLastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_line_id_first_name",
            "callingLineIdFirstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_custom_dnis_announcement_settings",
            "useCustomDnisAnnouncementSettings",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "priority",
            "priority",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_outgoing_acd_call",
            "allowOutgoingACDCall",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Optional* dnisPhoneNumber
    dnis_phone_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* extension
    extension = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* useCustomCLIDSettings
    use_custom_clid_settings = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* callingLineIdPhoneNumber
    calling_line_id_phone_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingLineIdLastName
    calling_line_id_last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingLineIdFirstName
    calling_line_id_first_name = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* useCustomDnisAnnouncementSettings
    use_custom_dnis_announcement_settings = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* priority
    priority = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* allowOutgoingACDCall
    allow_outgoing_acd_call = Field(
        type=bool,
        required=True,
    )


class GroupCallCenterGetDistinctiveRingingResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetDistinctiveRingingRequest()``.
    """

    _ELEMENTS = (
        E(
            "distinctive_ringing_call_center_calls",
            "distinctiveRingingCallCenterCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "distinctive_ringing_ring_pattern_for_call_center",
            "distinctiveRingingRingPatternForCallCenter",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "distinctive_ringing_force_delivery_ring_pattern",
            "distinctiveRingingForceDeliveryRingPattern",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* distinctiveRingingCallCenterCalls
    distinctive_ringing_call_center_calls = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* distinctiveRingingRingPatternForCallCenter
    distinctive_ringing_ring_pattern_for_call_center = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* distinctiveRingingForceDeliveryRingPattern
    distinctive_ringing_force_delivery_ring_pattern = Field(
        type=str,
        required=False,
    )


class GroupCallCenterGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetInstanceListRequest()``.
    Contains a table with column headings:
    "Service User Id", "Name", "Video", "Phone Number", "Extension", "Department",
    "Is Active", "Policy", "Type".
    The column values for "Video" and "Is Active" can either be true, or false.
    The column values for "Type" can be "Basic", "Standard" or "Premium".
    NOTE: prior to release 14, the policy column did not match the HuntPolicy enumerated type.
    """

    _ELEMENTS = (
        E(
            "call_center_table",
            "callCenterTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* callCenterTable  *Tabular*
    call_center_table = Field(
        type=list,
        required=True,
    )


class GroupCallCenterGetInstanceQueueStatusResponse(OCIResponse):
    """
    Contains Call Center queue status and a table with column headings:
    "User Id", "First Name", "Last Name", "Phone Number", "Extension", "Department",
    "Email Address".
    """

    _ELEMENTS = (
        E(
            "number_of_calls_queued_now",
            "numberOfCallsQueuedNow",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "agents_currently_staffed",
            "agentsCurrentlyStaffed",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: int: *Required* numberOfCallsQueuedNow
    number_of_calls_queued_now = Field(
        type=int,
        required=True,
    )
    #: list: *Required* agentsCurrentlyStaffed  *Tabular*
    agents_currently_staffed = Field(
        type=list,
        required=True,
    )


class GroupCallCenterGetInstanceStatisticsReportingResponse(OCIResponse):
    """
    Contains Call Center statistics reporting settings.
    """

    _ELEMENTS = (
        E(
            "generate_daily_report",
            "generateDailyReport",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "collection_period_minutes",
            "collectionPeriodMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "reporting_email_address1",
            "reportingEmailAddress1",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "reporting_email_address2",
            "reportingEmailAddress2",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* generateDailyReport
    generate_daily_report = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* collectionPeriodMinutes
    collection_period_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Optional* reportingEmailAddress1
    reporting_email_address1 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* reportingEmailAddress2
    reporting_email_address2 = Field(
        type=str,
        required=False,
    )


class GroupCallCenterGetInstanceStatisticsReportingResponse16(OCIResponse):
    """
    Contains Call Center statistics reporting settings.
    """

    _ELEMENTS = (
        E(
            "generate_daily_report",
            "generateDailyReport",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "collection_period_minutes",
            "collectionPeriodMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "reporting_email_address1",
            "reportingEmailAddress1",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "reporting_email_address2",
            "reportingEmailAddress2",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "statistics_source",
            "statisticsSource",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* generateDailyReport
    generate_daily_report = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* collectionPeriodMinutes
    collection_period_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Optional* reportingEmailAddress1
    reporting_email_address1 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* reportingEmailAddress2
    reporting_email_address2 = Field(
        type=str,
        required=False,
    )
    #: str: *Required* statisticsSource
    statistics_source = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetInstanceStatisticsReportingResponse17sp1(OCIResponse):
    """
    Response to ``GroupCallCenterGetInstanceStatisticsReportingRequest17sp1()``.
    Contains Call Center statistics reporting settings.
    """

    _ELEMENTS = (
        E(
            "generate_daily_report",
            "generateDailyReport",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "collection_period_minutes",
            "collectionPeriodMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "reporting_email_address1",
            "reportingEmailAddress1",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "reporting_email_address2",
            "reportingEmailAddress2",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "statistics_source",
            "statisticsSource",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* generateDailyReport
    generate_daily_report = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* collectionPeriodMinutes
    collection_period_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Optional* reportingEmailAddress1
    reporting_email_address1 = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* reportingEmailAddress2
    reporting_email_address2 = Field(
        type=str,
        required=False,
    )
    #: str: *Required* statisticsSource
    statistics_source = Field(
        type=str,
        required=True,
    )


class GroupCallCenterGetResponse(OCIResponse):
    """
    Response to ``GroupCallCenterGetRequest()``.

    Replaced by ``GroupCallCenterGetResponse17sp4()``.
    """

    _ELEMENTS = (
        E(
            "use_system_default_guard_timer",
            "useSystemDefaultGuardTimer",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_guard_timer",
            "enableGuardTimer",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "guard_timer_seconds",
            "guardTimerSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_system_default_unavailable_settings",
            "useSystemDefaultUnavailableSettings",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* useSystemDefaultGuardTimer
    use_system_default_guard_timer = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableGuardTimer
    enable_guard_timer = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* guardTimerSeconds
    guard_timer_seconds = Field(
        type=int,
        required=True,
    )
    #: bool: *Optional* useSystemDefaultUnavailableSettings
    use_system_default_unavailable_settings = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnDNDActivation
    force_agent_unavailable_on_dnd_activation = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnPersonalCalls
    force_agent_unavailable_on_personal_calls = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnBouncedCallLimit
    force_agent_unavailable_on_bounced_call_limit = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* numberConsecutiveBouncedCallsToForceAgentUnavailable
    number_consecutive_bounced_calls_to_force_agent_unavailable = Field(
        type=int,
        required=False,
    )


class GroupCallCenterGetResponse17sp4(OCIResponse):
    """
    Response to ``GroupCallCenterGetRequest17sp4()``.
    """

    _ELEMENTS = (
        E(
            "use_system_default_guard_timer",
            "useSystemDefaultGuardTimer",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_guard_timer",
            "enableGuardTimer",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "guard_timer_seconds",
            "guardTimerSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_system_default_unavailable_settings",
            "useSystemDefaultUnavailableSettings",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "force_agent_unavailable_on_dnd_activation",
            "forceAgentUnavailableOnDNDActivation",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "force_agent_unavailable_on_personal_calls",
            "forceAgentUnavailableOnPersonalCalls",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "force_agent_unavailable_on_bounced_call_limit",
            "forceAgentUnavailableOnBouncedCallLimit",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "number_consecutive_bounced_calls_to_force_agent_unavailable",
            "numberConsecutiveBouncedCallsToForceAgentUnavailable",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "force_agent_unavailable_on_not_reachable",
            "forceAgentUnavailableOnNotReachable",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* useSystemDefaultGuardTimer
    use_system_default_guard_timer = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableGuardTimer
    enable_guard_timer = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* guardTimerSeconds
    guard_timer_seconds = Field(
        type=int,
        required=True,
    )
    #: bool: *Optional* useSystemDefaultUnavailableSettings
    use_system_default_unavailable_settings = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnDNDActivation
    force_agent_unavailable_on_dnd_activation = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnPersonalCalls
    force_agent_unavailable_on_personal_calls = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnBouncedCallLimit
    force_agent_unavailable_on_bounced_call_limit = Field(
        type=bool,
        required=False,
    )
    #: int: *Optional* numberConsecutiveBouncedCallsToForceAgentUnavailable
    number_consecutive_bounced_calls_to_force_agent_unavailable = Field(
        type=int,
        required=False,
    )
    #: bool: *Optional* forceAgentUnavailableOnNotReachable
    force_agent_unavailable_on_not_reachable = Field(
        type=bool,
        required=False,
    )


class GroupCallCenterGetRoutingPolicyResponse(OCIResponse):
    """
    Response to ``GroupCallCenterGetRoutingPolicyRequest()``.
    Contains a table with column headings: "Service User Id", "Name" and
    "Priority".
    """

    _ELEMENTS = (
        E(
            "routing_policy",
            "routingPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "call_center_table",
            "callCenterTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: str: *Required* routingPolicy
    routing_policy = Field(
        type=str,
        required=True,
    )
    #: list: *Required* callCenterTable  *Tabular*
    call_center_table = Field(
        type=list,
        required=True,
    )


class GroupCallCenterGetSupervisorListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetSupervisorListRequest()``.
    Contains a table with column headings: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name".
    Element "reportingServerURL"" will always be blank.
    Replaced By ``GroupCallCenterSupervisorReportingGetResponse()``
    """

    _ELEMENTS = (
        E(
            "reporting_server_url",
            "reportingServerURL",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "supervisor_table",
            "supervisorTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: str: *Optional* reportingServerURL
    reporting_server_url = Field(
        type=str,
        required=False,
    )
    #: list: *Required* supervisorTable  *Tabular*
    supervisor_table = Field(
        type=list,
        required=True,
    )


class GroupCallCenterGetSupervisorListResponse16(OCIResponse):
    """
    Response to the ``GroupCallCenterGetSupervisorListRequest16()``.
    Contains a table with column headings: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "supervisor_table",
            "supervisorTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* supervisorTable  *Tabular*
    supervisor_table = Field(
        type=list,
        required=True,
    )


class GroupCallCenterGetUnlicensedAgentListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterGetUnlicensedAgentListRequest()``.
    Contains a table with column headings: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name", "Phone Number", "Group Id",
    "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupCallCenterHolidayServiceGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterHolidayServiceGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "action",
            "action",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "holiday_schedule",
            "holidaySchedule",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "transfer_phone_number",
            "transferPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "play_announcement_before_action",
            "playAnnouncementBeforeAction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_message_selection",
            "audioMessageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_file_url",
            "audioFileUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_file_description",
            "audioFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_media_type",
            "audioMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_message_selection",
            "videoMessageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "video_file_url",
            "videoFileUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_file_description",
            "videoFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_media_type",
            "videoMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* action
    action = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* holidaySchedule
    holiday_schedule = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* transferPhoneNumber
    transfer_phone_number = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* playAnnouncementBeforeAction
    play_announcement_before_action = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* audioMessageSelection
    audio_message_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* audioFileUrl
    audio_file_url = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioMediaType
    audio_media_type = Field(
        type=str,
        required=False,
    )
    #: str: *Required* videoMessageSelection
    video_message_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* videoFileUrl
    video_file_url = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoFileDescription
    video_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoMediaType
    video_media_type = Field(
        type=str,
        required=False,
    )


class GroupCallCenterNightServiceGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterNightServiceGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "action",
            "action",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "business_hours",
            "businessHours",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "force_night_service",
            "forceNightService",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_manual_override_via_fac",
            "allowManualOverrideViaFAC",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "transfer_phone_number",
            "transferPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "play_announcement_before_action",
            "playAnnouncementBeforeAction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_message_selection",
            "audioMessageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_file_url",
            "audioFileUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_file_description",
            "audioFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_media_type",
            "audioMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_message_selection",
            "videoMessageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "video_file_url",
            "videoFileUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_file_description",
            "videoFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_media_type",
            "videoMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "manual_announcement_mode",
            "manualAnnouncementMode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "manual_audio_message_selection",
            "manualAudioMessageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "manual_audio_file_url",
            "manualAudioFileUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "manual_audio_file_description",
            "manualAudioFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "manual_audio_media_type",
            "manualAudioMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "manual_video_message_selection",
            "manualVideoMessageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "manual_video_file_url",
            "manualVideoFileUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "manual_video_file_description",
            "manualVideoFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "manual_video_media_type",
            "manualVideoMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* action
    action = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* businessHours
    business_hours = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* forceNightService
    force_night_service = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowManualOverrideViaFAC
    allow_manual_override_via_fac = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* transferPhoneNumber
    transfer_phone_number = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* playAnnouncementBeforeAction
    play_announcement_before_action = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* audioMessageSelection
    audio_message_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* audioFileUrl
    audio_file_url = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioMediaType
    audio_media_type = Field(
        type=str,
        required=False,
    )
    #: str: *Required* videoMessageSelection
    video_message_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* videoFileUrl
    video_file_url = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoFileDescription
    video_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoMediaType
    video_media_type = Field(
        type=str,
        required=False,
    )
    #: str: *Required* manualAnnouncementMode
    manual_announcement_mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* manualAudioMessageSelection
    manual_audio_message_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* manualAudioFileUrl
    manual_audio_file_url = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* manualAudioFileDescription
    manual_audio_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* manualAudioMediaType
    manual_audio_media_type = Field(
        type=str,
        required=False,
    )
    #: str: *Required* manualVideoMessageSelection
    manual_video_message_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* manualVideoFileUrl
    manual_video_file_url = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* manualVideoFileDescription
    manual_video_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* manualVideoMediaType
    manual_video_media_type = Field(
        type=str,
        required=False,
    )


class GroupCallCenterOverflowGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterOverflowGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "action",
            "action",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "transfer_phone_number",
            "transferPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "overflow_after_timeout",
            "overflowAfterTimeout",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "timeout_seconds",
            "timeoutSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "play_announcement_before_overflow_processing",
            "playAnnouncementBeforeOverflowProcessing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_message_selection",
            "audioMessageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_file_url",
            "audioFileUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_file_description",
            "audioFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_media_type",
            "audioMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_message_selection",
            "videoMessageSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_file_url",
            "videoFileUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_file_description",
            "videoFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_media_type",
            "videoMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* action
    action = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* transferPhoneNumber
    transfer_phone_number = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* overflowAfterTimeout
    overflow_after_timeout = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* timeoutSeconds
    timeout_seconds = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* playAnnouncementBeforeOverflowProcessing
    play_announcement_before_overflow_processing = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* audioMessageSelection
    audio_message_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* audioFileUrl
    audio_file_url = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioMediaType
    audio_media_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoMessageSelection
    video_message_selection = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoFileUrl
    video_file_url = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoFileDescription
    video_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoMediaType
    video_media_type = Field(
        type=str,
        required=False,
    )


class GroupCallCenterQueueCallDispositionCodeGetListResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterQueueCallDispositionCodeGetListRequest()``.
    Contains a table with column headings: "Is Active", "Code", "Description" and "Level".
    Level column can be any of the values in the data type CallDispositionCodeLevel.
    """

    _ELEMENTS = (
        E(
            "disposition_codes_table",
            "dispositionCodesTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* dispositionCodesTable  *Tabular*
    disposition_codes_table = Field(
        type=list,
        required=True,
    )


class GroupCallCenterQueueCallDispositionCodeGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterQueueCallDispositionCodeGetRequest()``
    """

    _ELEMENTS = (
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class GroupCallCenterQueueStatusNotificationGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterQueueStatusNotificationGetRequest()``.
    The response contains the call center status configuration information.
    """

    _ELEMENTS = (
        E(
            "enable_queue_status_notification",
            "enableQueueStatusNotification",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_queue_depth_threshold",
            "enableQueueDepthThreshold",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_waiting_time_threshold",
            "enableWaitingTimeThreshold",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_of_calls_threshold",
            "numberOfCallsThreshold",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "waiting_time_of_calls_threshold",
            "waitingTimeOfCallsThreshold",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* enableQueueStatusNotification
    enable_queue_status_notification = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableQueueDepthThreshold
    enable_queue_depth_threshold = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableWaitingTimeThreshold
    enable_waiting_time_threshold = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* numberOfCallsThreshold
    number_of_calls_threshold = Field(
        type=int,
        required=True,
    )
    #: int: *Required* waitingTimeOfCallsThreshold
    waiting_time_of_calls_threshold = Field(
        type=int,
        required=True,
    )


class GroupCallCenterQueueThresholdsGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterQueueThresholdsGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "threshold_current_calls_in_queue_yellow",
            "thresholdCurrentCallsInQueueYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_calls_in_queue_red",
            "thresholdCurrentCallsInQueueRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_longest_waiting_call_yellow",
            "thresholdCurrentLongestWaitingCallYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_current_longest_waiting_call_red",
            "thresholdCurrentLongestWaitingCallRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_estimated_wait_time_yellow",
            "thresholdAverageEstimatedWaitTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_estimated_wait_time_red",
            "thresholdAverageEstimatedWaitTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_handling_time_yellow",
            "thresholdAverageHandlingTimeYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_handling_time_red",
            "thresholdAverageHandlingTimeRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_speed_of_answer_yellow",
            "thresholdAverageSpeedOfAnswerYellow",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "threshold_average_speed_of_answer_red",
            "thresholdAverageSpeedOfAnswerRed",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_notification_email",
            "enableNotificationEmail",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "notification_email_address",
            "notificationEmailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* thresholdCurrentCallsInQueueYellow
    threshold_current_calls_in_queue_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentCallsInQueueRed
    threshold_current_calls_in_queue_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentLongestWaitingCallYellow
    threshold_current_longest_waiting_call_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdCurrentLongestWaitingCallRed
    threshold_current_longest_waiting_call_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageEstimatedWaitTimeYellow
    threshold_average_estimated_wait_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageEstimatedWaitTimeRed
    threshold_average_estimated_wait_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageHandlingTimeYellow
    threshold_average_handling_time_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageHandlingTimeRed
    threshold_average_handling_time_red = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageSpeedOfAnswerYellow
    threshold_average_speed_of_answer_yellow = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* thresholdAverageSpeedOfAnswerRed
    threshold_average_speed_of_answer_red = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* enableNotificationEmail
    enable_notification_email = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* notificationEmailAddress
    notification_email_address = Field(
        type=str,
        required=False,
    )


class GroupCallCenterStrandedCallGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterStrandedCallGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "action",
            "action",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "transfer_phone_number",
            "transferPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_message_selection",
            "audioMessageSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_file_url",
            "audioFileUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_file_description",
            "audioFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_media_type",
            "audioMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_message_selection",
            "videoMessageSelection",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_file_url",
            "videoFileUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_file_description",
            "videoFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_media_type",
            "videoMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* action
    action = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* transferPhoneNumber
    transfer_phone_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioMessageSelection
    audio_message_selection = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioFileUrl
    audio_file_url = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioMediaType
    audio_media_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoMessageSelection
    video_message_selection = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoFileUrl
    video_file_url = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoFileDescription
    video_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoMediaType
    video_media_type = Field(
        type=str,
        required=False,
    )


class GroupCallCenterSupervisorReportingGetResponse(OCIResponse):
    """
    Response to the ``GroupCallCenterSupervisorReportingGetRequest()``.
    Contains a table with column headings: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name".
    """

    _ELEMENTS = (
        E(
            "reporting_server_name",
            "reportingServerName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "supervisor_table",
            "supervisorTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: str: *Optional* reportingServerName
    reporting_server_name = Field(
        type=str,
        required=False,
    )
    #: list: *Required* supervisorTable  *Tabular*
    supervisor_table = Field(
        type=list,
        required=True,
    )


class GroupCallParkGetAvailableAlternateRecallUserListResponse(OCIResponse):
    """
    Response to the ``GroupCallParkGetAvailableAlternateRecallUserListResponse()``.
    Contains a table with column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name", "Hiragana First Name".
    """

    _ELEMENTS = (
        E(
            "available_hunt_group_table",
            "availableHuntGroupTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* availableHuntGroupTable  *Tabular*
    available_hunt_group_table = Field(
        type=list,
        required=True,
    )


class GroupCallParkGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupCallParkGetAvailableUserListRequest()``.
    Contains a table with column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name",
    "Hiragana First Name", "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupCallParkGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupCallParkGetInstanceListRequest()``.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* name  *Array*
    name = Field(
        type=list,
        required=False,
    )


class GroupCallParkGetInstanceResponse(OCIResponse):
    """
    Response to the ``GroupCallParkGetInstanceRequest()``.
    Contains a table with column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name",
    "Hiragana First Name".  The users are in the table are in the order they will try
    to be parked on.
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupCallParkGetInstanceResponse16sp2(OCIResponse):
    """
    Response to the ``GroupCallParkGetInstanceRequest16sp2()``.
    Contains a table with column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name",
    "Hiragana First Name", "Phone Number", "Extension", "Department", "Email Address".
    The users are in the table are in the order they will try to be parked on.

    The following elements are only used in AS data mode:
    recallAlternateUserId
    recallTo
    """

    _ELEMENTS = (
        E(
            "recall_alternate_user_id",
            "recallAlternateUserId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "recall_to",
            "recallTo",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: str: *Optional* recallAlternateUserId
    recall_alternate_user_id = Field(
        type=str,
        required=False,
    )
    #: str: *Required* recallTo
    recall_to = Field(
        type=str,
        required=True,
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupCallParkGetResponse(OCIResponse):
    """
    Response to the ``GroupCallParkGetRequest()``.
    Contains the settings that apply to the whole group for Call Park.
    """

    _ELEMENTS = (
        E(
            "recall_timer_seconds",
            "recallTimerSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "display_timer_seconds",
            "displayTimerSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_destination_announcement",
            "enableDestinationAnnouncement",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: int: *Required* recallTimerSeconds
    recall_timer_seconds = Field(
        type=int,
        required=True,
    )
    #: int: *Required* displayTimerSeconds
    display_timer_seconds = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* enableDestinationAnnouncement
    enable_destination_announcement = Field(
        type=bool,
        required=True,
    )


class GroupCallParkGetResponse16sp2(OCIResponse):
    """
    Response to the ``GroupCallParkGetRequest16sp2()``.
    Contains the settings that apply to the whole group for Call Park.

    The following elements are only used in AS data mode:
    recallAlternateUserId
    recallRingPattern
    recallTo
    alternateUserRecallTimerSeconds
    """

    _ELEMENTS = (
        E(
            "recall_timer_seconds",
            "recallTimerSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "display_timer_seconds",
            "displayTimerSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_destination_announcement",
            "enableDestinationAnnouncement",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "recall_alternate_user_id",
            "recallAlternateUserId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "recall_ring_pattern",
            "recallRingPattern",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "recall_to",
            "recallTo",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "alternate_user_recall_timer_seconds",
            "alternateUserRecallTimerSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: int: *Required* recallTimerSeconds
    recall_timer_seconds = Field(
        type=int,
        required=True,
    )
    #: int: *Required* displayTimerSeconds
    display_timer_seconds = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* enableDestinationAnnouncement
    enable_destination_announcement = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* recallAlternateUserId
    recall_alternate_user_id = Field(
        type=str,
        required=False,
    )
    #: str: *Required* recallRingPattern
    recall_ring_pattern = Field(
        type=str,
        required=True,
    )
    #: str: *Required* recallTo
    recall_to = Field(
        type=str,
        required=True,
    )
    #: int: *Required* alternateUserRecallTimerSeconds
    alternate_user_recall_timer_seconds = Field(
        type=int,
        required=True,
    )


class GroupCallPickupGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupCallPickupGetAvailableUserListRequest()``.
    Contains a table with column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupCallPickupGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupCallPickupGetInstanceListRequest()``.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* name  *Array*
    name = Field(
        type=list,
        required=False,
    )


class GroupCallPickupGetInstanceResponse(OCIResponse):
    """
    Response to the ``GroupCallPickupGetInstanceRequest()``.
    Contains a table with column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupCallProcessingGetPolicyResponse14(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest14()``.
    """

    _ELEMENTS = (
        E(
            "use_group_setting",
            "useGroupSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useGroupSetting
    use_group_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )


class GroupCallProcessingGetPolicyResponse14sp1(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest14sp1()``.
    """

    _ELEMENTS = (
        E(
            "use_group_setting",
            "useGroupSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useGroupSetting
    use_group_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=True,
    )


class GroupCallProcessingGetPolicyResponse14sp4(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest14sp4()``.
    Replaced By : ``GroupCallProcessingGetPolicyResponse15()``
    """

    _ELEMENTS = (
        E(
            "use_group_setting",
            "useGroupSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_external_calls_via_private_dialing_plan",
            "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useGroupSetting
    use_group_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
    override_clid_restriction_for_external_calls_via_private_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=True,
    )


class GroupCallProcessingGetPolicyResponse14sp7(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest14sp7()``.
    """

    _ELEMENTS = (
        E(
            "use_group_clid_setting",
            "useGroupCLIDSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_media_setting",
            "useGroupMediaSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_call_limits_setting",
            "useGroupCallLimitsSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_translation_routing_setting",
            "useGroupTranslationRoutingSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_external_calls_via_private_dialing_plan",
            "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "clid_policy",
            "clidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "emergency_clid_policy",
            "emergencyClidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_name",
            "useGroupName",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useGroupCLIDSetting
    use_group_clid_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupMediaSetting
    use_group_media_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupCallLimitsSetting
    use_group_call_limits_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupTranslationRoutingSetting
    use_group_translation_routing_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
    override_clid_restriction_for_external_calls_via_private_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=True,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupName
    use_group_name = Field(
        type=bool,
        required=True,
    )


class GroupCallProcessingGetPolicyResponse15(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest15()``.
    """

    _ELEMENTS = (
        E(
            "use_group_setting",
            "useGroupSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useGroupSetting
    use_group_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=True,
    )


class GroupCallProcessingGetPolicyResponse15sp2(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest15sp2()``.
    """

    _ELEMENTS = (
        E(
            "use_group_clid_setting",
            "useGroupCLIDSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_media_setting",
            "useGroupMediaSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_call_limits_setting",
            "useGroupCallLimitsSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_translation_routing_setting",
            "useGroupTranslationRoutingSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "clid_policy",
            "clidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "emergency_clid_policy",
            "emergencyClidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_name",
            "useGroupName",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useGroupCLIDSetting
    use_group_clid_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupMediaSetting
    use_group_media_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupCallLimitsSetting
    use_group_call_limits_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupTranslationRoutingSetting
    use_group_translation_routing_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool,
        required=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=True,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupName
    use_group_name = Field(
        type=bool,
        required=True,
    )


class GroupCallProcessingGetPolicyResponse16(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest16()``.
    """

    _ELEMENTS = (
        E(
            "use_group_clid_setting",
            "useGroupCLIDSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_media_setting",
            "useGroupMediaSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_call_limits_setting",
            "useGroupCallLimitsSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_translation_routing_setting",
            "useGroupTranslationRoutingSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "clid_policy",
            "clidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "emergency_clid_policy",
            "emergencyClidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_name",
            "useGroupName",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useGroupCLIDSetting
    use_group_clid_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupMediaSetting
    use_group_media_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupCallLimitsSetting
    use_group_call_limits_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupTranslationRoutingSetting
    use_group_translation_routing_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool,
        required=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=True,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupName
    use_group_name = Field(
        type=bool,
        required=True,
    )


class GroupCallProcessingGetPolicyResponse16sp2(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest16sp2()``.
    """

    _ELEMENTS = (
        E(
            "use_group_clid_setting",
            "useGroupCLIDSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_media_setting",
            "useGroupMediaSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_call_limits_setting",
            "useGroupCallLimitsSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_translation_routing_setting",
            "useGroupTranslationRoutingSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_dclid_setting",
            "useGroupDCLIDSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "clid_policy",
            "clidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "emergency_clid_policy",
            "emergencyClidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_name",
            "useGroupName",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_dialable_caller_id",
            "enableDialableCallerID",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useGroupCLIDSetting
    use_group_clid_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupMediaSetting
    use_group_media_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupCallLimitsSetting
    use_group_call_limits_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupTranslationRoutingSetting
    use_group_translation_routing_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupDCLIDSetting
    use_group_dclid_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool,
        required=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=True,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupName
    use_group_name = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableDialableCallerID
    enable_dialable_caller_id = Field(
        type=bool,
        required=True,
    )


class GroupCallProcessingGetPolicyResponse17(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest17()``.
    """

    _ELEMENTS = (
        E(
            "use_group_clid_setting",
            "useGroupCLIDSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_media_setting",
            "useGroupMediaSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_call_limits_setting",
            "useGroupCallLimitsSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_translation_routing_setting",
            "useGroupTranslationRoutingSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "clid_policy",
            "clidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "emergency_clid_policy",
            "emergencyClidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_name",
            "useGroupName",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "block_calling_name_for_external_calls",
            "blockCallingNameForExternalCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useGroupCLIDSetting
    use_group_clid_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupMediaSetting
    use_group_media_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupCallLimitsSetting
    use_group_call_limits_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupTranslationRoutingSetting
    use_group_translation_routing_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool,
        required=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=True,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupName
    use_group_name = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(
        type=bool,
        required=True,
    )


class GroupCallProcessingGetPolicyResponse17sp3(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest17sp3()``.
    The following elements are only used in AS data mode:
    useGroupDCLIDSetting
    enableDialableCallerID

    Replaced by ``GroupCallProcessingGetPolicyResponse17sp4()``
    """

    _ELEMENTS = (
        E(
            "use_group_clid_setting",
            "useGroupCLIDSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_media_setting",
            "useGroupMediaSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_call_limits_setting",
            "useGroupCallLimitsSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_translation_routing_setting",
            "useGroupTranslationRoutingSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_dclid_setting",
            "useGroupDCLIDSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "clid_policy",
            "clidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "emergency_clid_policy",
            "emergencyClidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_name",
            "useGroupName",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "block_calling_name_for_external_calls",
            "blockCallingNameForExternalCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_dialable_caller_id",
            "enableDialableCallerID",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useGroupCLIDSetting
    use_group_clid_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupMediaSetting
    use_group_media_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupCallLimitsSetting
    use_group_call_limits_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupTranslationRoutingSetting
    use_group_translation_routing_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupDCLIDSetting
    use_group_dclid_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool,
        required=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=True,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupName
    use_group_name = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableDialableCallerID
    enable_dialable_caller_id = Field(
        type=bool,
        required=True,
    )


class GroupCallProcessingGetPolicyResponse17sp4(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest17sp4()``.
    The following elements are only used in AS data mode:
    useGroupDCLIDSetting
    enableDialableCallerID
    allowConfigurableCLIDForRedirectingIdentity

    Replaced by ``GroupCallProcessingGetPolicyResponse18()``
    """

    _ELEMENTS = (
        E(
            "use_group_clid_setting",
            "useGroupCLIDSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_media_setting",
            "useGroupMediaSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_call_limits_setting",
            "useGroupCallLimitsSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_translation_routing_setting",
            "useGroupTranslationRoutingSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_dclid_setting",
            "useGroupDCLIDSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "clid_policy",
            "clidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "emergency_clid_policy",
            "emergencyClidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_name",
            "useGroupName",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "block_calling_name_for_external_calls",
            "blockCallingNameForExternalCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_dialable_caller_id",
            "enableDialableCallerID",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useGroupCLIDSetting
    use_group_clid_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupMediaSetting
    use_group_media_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupCallLimitsSetting
    use_group_call_limits_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupTranslationRoutingSetting
    use_group_translation_routing_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupDCLIDSetting
    use_group_dclid_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool,
        required=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=True,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupName
    use_group_name = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableDialableCallerID
    enable_dialable_caller_id = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool,
        required=True,
    )


class GroupCallProcessingGetPolicyResponse18(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest18()``.
    The following elements are only used in AS data mode:
    useGroupDCLIDSetting
    enableDialableCallerID
    allowConfigurableCLIDForRedirectingIdentity
    allowDepartmentCLIDNameOverride
    """

    _ELEMENTS = (
        E(
            "use_group_clid_setting",
            "useGroupCLIDSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_media_setting",
            "useGroupMediaSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_call_limits_setting",
            "useGroupCallLimitsSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_translation_routing_setting",
            "useGroupTranslationRoutingSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_dclid_setting",
            "useGroupDCLIDSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "clid_policy",
            "clidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "emergency_clid_policy",
            "emergencyClidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_name",
            "useGroupName",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "block_calling_name_for_external_calls",
            "blockCallingNameForExternalCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_dialable_caller_id",
            "enableDialableCallerID",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_department_clid_name_override",
            "allowDepartmentCLIDNameOverride",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useGroupCLIDSetting
    use_group_clid_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupMediaSetting
    use_group_media_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupCallLimitsSetting
    use_group_call_limits_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupTranslationRoutingSetting
    use_group_translation_routing_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupDCLIDSetting
    use_group_dclid_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool,
        required=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=True,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupName
    use_group_name = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableDialableCallerID
    enable_dialable_caller_id = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowDepartmentCLIDNameOverride
    allow_department_clid_name_override = Field(
        type=bool,
        required=True,
    )


class GroupCallProcessingGetPolicyResponse18sp1(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest18()``.
    The following elements are only used in AS data mode:
    useGroupDCLIDSetting
    enableDialableCallerID
    allowConfigurableCLIDForRedirectingIdentity
    allowDepartmentCLIDNameOverride
    enterpriseCallsCLIDPolicy
    groupCallsCLIDPolicy

    Replaced By ``GroupCallProcessingGetPolicyResponse19sp1()``
    """

    _ELEMENTS = (
        E(
            "use_group_clid_setting",
            "useGroupCLIDSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_media_setting",
            "useGroupMediaSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_call_limits_setting",
            "useGroupCallLimitsSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_translation_routing_setting",
            "useGroupTranslationRoutingSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_dclid_setting",
            "useGroupDCLIDSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "clid_policy",
            "clidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "emergency_clid_policy",
            "emergencyClidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_name",
            "useGroupName",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "block_calling_name_for_external_calls",
            "blockCallingNameForExternalCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_dialable_caller_id",
            "enableDialableCallerID",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_department_clid_name_override",
            "allowDepartmentCLIDNameOverride",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enterprise_calls_clid_policy",
            "enterpriseCallsCLIDPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_calls_clid_policy",
            "groupCallsCLIDPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useGroupCLIDSetting
    use_group_clid_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupMediaSetting
    use_group_media_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupCallLimitsSetting
    use_group_call_limits_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupTranslationRoutingSetting
    use_group_translation_routing_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupDCLIDSetting
    use_group_dclid_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool,
        required=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=True,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupName
    use_group_name = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableDialableCallerID
    enable_dialable_caller_id = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowDepartmentCLIDNameOverride
    allow_department_clid_name_override = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* enterpriseCallsCLIDPolicy
    enterprise_calls_clid_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupCallsCLIDPolicy
    group_calls_clid_policy = Field(
        type=str,
        required=True,
    )


class GroupCallProcessingGetPolicyResponse19sp1(OCIResponse):
    """
    Response to ``GroupCallProcessingGetPolicyRequest()``.
    The following elements are only used in AS data mode:
    useGroupDCLIDSetting
    enableDialableCallerID
    allowConfigurableCLIDForRedirectingIdentity
    allowDepartmentCLIDNameOverride
    enterpriseCallsCLIDPolicy
    groupCallsCLIDPolicy
    """

    _ELEMENTS = (
        E(
            "use_group_clid_setting",
            "useGroupCLIDSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_media_setting",
            "useGroupMediaSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_call_limits_setting",
            "useGroupCallLimitsSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_translation_routing_setting",
            "useGroupTranslationRoutingSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_dclid_setting",
            "useGroupDCLIDSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "clid_policy",
            "clidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "emergency_clid_policy",
            "emergencyClidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_name",
            "useGroupName",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "block_calling_name_for_external_calls",
            "blockCallingNameForExternalCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_dialable_caller_id",
            "enableDialableCallerID",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_department_clid_name_override",
            "allowDepartmentCLIDNameOverride",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enterprise_calls_clid_policy",
            "enterpriseCallsCLIDPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_calls_clid_policy",
            "groupCallsCLIDPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useGroupCLIDSetting
    use_group_clid_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupMediaSetting
    use_group_media_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupCallLimitsSetting
    use_group_call_limits_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupTranslationRoutingSetting
    use_group_translation_routing_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupDCLIDSetting
    use_group_dclid_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Optional* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool,
        required=False,
    )
    #: bool: *Optional* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool,
        required=False,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=True,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupName
    use_group_name = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableDialableCallerID
    enable_dialable_caller_id = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowDepartmentCLIDNameOverride
    allow_department_clid_name_override = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* enterpriseCallsCLIDPolicy
    enterprise_calls_clid_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupCallsCLIDPolicy
    group_calls_clid_policy = Field(
        type=str,
        required=True,
    )


class GroupCallRecordingGetResponse(OCIResponse):
    """
    Response to the ``GroupCallRecordingGetRequest()``.
    The response contains the group's Call Recording platform information.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* name
    name = Field(
        type=str,
        required=False,
    )


class GroupCallingLineIdGetResponse(OCIResponse):
    """
    Response to the ``GroupCallingLineIdGetRequest()``.
    The response contains the group's calling line id settings.
    """

    _ELEMENTS = (
        E(
            "use_group_number",
            "useGroupNumber",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_group_name",
            "useGroupName",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_phone_number",
            "callingLineIdPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_line_id_name",
            "callingLineIdName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* useGroupNumber
    use_group_number = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useGroupName
    use_group_name = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* callingLineIdPhoneNumber
    calling_line_id_phone_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingLineIdName
    calling_line_id_name = Field(
        type=str,
        required=False,
    )


class GroupCallingPlanGetDigitPatternListResponse(OCIResponse):
    """
    Response to ``GroupCallingPlanGetDigitPatternListRequest()``.
    Contains a table with column headings: "Name", "Digit Pattern".
    """

    _ELEMENTS = (
        E(
            "digit_pattern_table",
            "digitPatternTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* digitPatternTable  *Tabular*
    digit_pattern_table = Field(
        type=list,
        required=True,
    )


class GroupCollaborateBridgeGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupCollaborateBridgeGetAvailableUserListRequest()``.
    Contains a table with column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name", and "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupCollaborateBridgeGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupCollaborateBridgeGetInstanceListRequest()``.
    Contains a table with column headings: "Service User Id", "Name", "Phone Number",
    "Extension", "Department", "Participants", and "Is Default".
    The column values for "Is default" can either be true, or false.
    """

    _ELEMENTS = (
        E(
            "collaborate_bridge_table",
            "collaborateBridgeTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* collaborateBridgeTable  *Tabular*
    collaborate_bridge_table = Field(
        type=list,
        required=True,
    )


class GroupCommPilotCallManagerGetResponse(OCIResponse):
    """
    Response to ``GroupCommPilotCallManagerGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "group_directory",
            "groupDirectory",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* groupDirectory
    group_directory = Field(
        type=str,
        required=True,
    )


class GroupCommunicationBarringGetResponse(OCIResponse):
    """
    Response to ``SystemCommunicationBarringGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "use_default_service_provider_profile",
            "useDefaultServiceProviderProfile",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "profile",
            "profile",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* useDefaultServiceProviderProfile
    use_default_service_provider_profile = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* profile
    profile = Field(
        type=str,
        required=False,
    )


class GroupCommunicationBarringProfileGetAssignedListResponse(OCIResponse):
    """
    Response to the ``GroupCommunicationBarringProfileGetAssignedListRequest()``.
    The response contains a simple list of all communication barring profiles
    assigned to the group.
    """

    _ELEMENTS = (
        E(
            "profile_name",
            "profileName",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* profileName  *Array*
    profile_name = Field(
        type=list,
        required=False,
    )


class GroupCustomContactDirectoryGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupCustomContactDirectoryGetAvailableUserListRequest()``.
    Contains a table with column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name", "Hiragana First Name".

    Replace by: ``GroupCustomContactDirectoryGetAvailableUserListResponse17()``
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupCustomContactDirectoryGetAvailableUserListResponse17(OCIResponse):
    """
    Response to the
    ``GroupCustomContactDirectoryGetAvailableUserListRequest17()``.
    Contains a table with column headings: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name",
    "Virtual On-Net Phone Number", "Group Id", "Is Virtual On-Net User",
    "Phone Number", "Extension", "Department", "Email Address".

    If the entry represents a Virtual On-Net user then "User Id" is blank,
    the "Virtual On-Net Phone Number" contains the phone Number of the
    Virtual On-Net user, the "Group Id" contains the Virtual On-Net user's
    group and the "Is Virtual On-Net User" contains true.

    If the entry represents a BroadWorks user then the "User Id" contains
    his BroadWorks userId, the "Virtual On-Net Phone Number" and
    "Group Id" fields are blank and the "Is Virtual On-Net User"
    contains false.
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupCustomContactDirectoryGetListResponse(OCIResponse):
    """
    Response to the ``GroupCustomContactDirectoryGetListRequest()``.
    The response contains all the group's custom contact directory names.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* name  *Array*
    name = Field(
        type=list,
        required=False,
    )


class GroupCustomContactDirectoryGetResponse(OCIResponse):
    """
    Response to the ``GroupCustomContactDirectoryGetRequest()``.
    The response contains all the group's custom contact directory names.
    Contains a table with column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name", "Hiragana First Name".

    Replace by: ``GroupCustomContactDirectoryGetResponse17()``
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupCustomContactDirectoryGetResponse17(OCIResponse):
    """
    Response to the ``GroupCustomContactDirectoryGetRequest17()``.
    The response contains all the contacts in the group's given custom
    contact directory. Contains a table with column headings: "User Id",
    "Last Name", "First Name", "Hiragana Last Name",
    "Hiragana First Name", "Virtual On-Net Phone Number", "Group Id",
    "Is Virtual On-Net User", "Department", "Phone Number", "Extension",
    "Mobile", "Email Address", "Yahoo Id", "Title", "IMP Id".
    If the entry represents a Virtual On-Net user then "User Id" is blank,
    the "Virtual On-Net Phone Number" contains the phone Number of the
    Virtual On-Net user, the "Group Id" contains the Virtual On-Net user's
    group and the "Is Virtual On-Net User" contains true.
    If the entry represents a BroadWorks user then the "User Id" contains
    his BroadWorks userId, the "Virtual On-Net Phone Number" and
    "Group Id" fields are field is blank and the "Is Virtual On-Net User"
    contains false.
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupCustomRingbackGroupGetResponse(OCIResponse):
    """
    Response to the ``GroupCustomRingbackGroupGetRequest()``.
    Replaced By ``GroupCustomRingbackGroupGetResponse16()``
    """

    _ELEMENTS = (
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_selection",
            "audioSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_file_description",
            "audioFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_file_url",
            "audioFileUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_selection",
            "videoSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "video_file_description",
            "videoFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_file_url",
            "videoFileUrl",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* audioSelection
    audio_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioFileUrl
    audio_file_url = Field(
        type=str,
        required=False,
    )
    #: str: *Required* videoSelection
    video_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* videoFileDescription
    video_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoFileUrl
    video_file_url = Field(
        type=str,
        required=False,
    )


class GroupCustomRingbackGroupGetResponse16(OCIResponse):
    """
    Response to the ``GroupCustomRingbackGroupGetRequest16()``.
    """

    _ELEMENTS = (
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_selection",
            "audioSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_file_description",
            "audioFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_media_type",
            "audioMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_file_url",
            "audioFileUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_selection",
            "videoSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "video_file_description",
            "videoFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_media_type",
            "videoMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_file_url",
            "videoFileUrl",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* audioSelection
    audio_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioMediaType
    audio_media_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioFileUrl
    audio_file_url = Field(
        type=str,
        required=False,
    )
    #: str: *Required* videoSelection
    video_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* videoFileDescription
    video_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoMediaType
    video_media_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoFileUrl
    video_file_url = Field(
        type=str,
        required=False,
    )


class GroupDepartmentAdminGetListResponse(OCIResponse):
    """
    Response to ``GroupDepartmentAdminGetListRequest()``.
    Contains a 5 column table with column headings "Administrator ID",
    "Last Name", "First Name", "Department", "Language".
    """

    _ELEMENTS = (
        E(
            "department_admin_table",
            "departmentAdminTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* departmentAdminTable  *Tabular*
    department_admin_table = Field(
        type=list,
        required=True,
    )


class GroupDepartmentGetListResponse18(OCIResponse):
    """
    Response to ``GroupDepartmentGetListRequest18()``.
    Contains a table of department attributes.
    The column headings are: "Is Enterprise Department", "Department Name", "Full
    Path Name", "Calling Line Id Name", and "Calling Line Id Phone Number"
    """

    _ELEMENTS = (
        E(
            "department_table",
            "departmentTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* departmentTable  *Tabular*
    department_table = Field(
        type=list,
        required=True,
    )


class GroupDeviceManagementEventGetListResponse(OCIResponse):
    """
    Response to ``GroupDeviceManagementEventGetListRequest()``.
    Contains a table with column headings: "Event Id", "Status", "Action",
    "Level", "Type", "Additional Info", "Is Local", "Completion %",
    "Pushed/ Same Hash/ Not Pushed", "Login Id", "Start Time",
    "Process Time".
    "Event Id" is a unique identifer for the event.
    "Status" can be: Pending, Queued, In Progress,
    Process On Other Host, Stale, Completed, Canceled.
    "Action" can be: Delete, Download, Rebuild, Reset, Upload.
    "Level" can be: Device, Device Type, Device Type Group, Group, User.
    "Type" can be: Automatic, Manual.
    "Additional Info" includes the affected device type, device or group.
    It depends on the level of the event:
    Device Profile: "Device Name" "Service Provider Id" "Group Id"
    Device Type: "Device Type Name"
    Device Type Group: "Service Provider Id" "Group Id" "Device Type Name"
    Group: "Service Provider Id" "Group Id"
    User: "User Id"
    "Is Local" is set to "yes" if the event is processed on the server
    who received the request, "no" otherwise meaning that the event is
    processed on another server.
    "Completion %" provides an estimate of the completion of the event.
    A percentage is given, the current number of completed expanded event,
    and the total number of expanded event.
    "Pushed/ Same Hash/ Not Pushed" gives the total number of files that
    were pushed, not pushed because of same hash, and not pushed when
    processing the event.
    "LoginId" is the user or admin id who triggered the event.
    "Start Time" is the date when the event was started.  The display
    shows the month, days, hours, and minutes (MM-dd hh:mm).
    "Process Time" is the time taken to process the event in hours,
    minutes, seconds, and milliseconds (hhhh:mm:ss.SSS).
    Each row represents an event sorted by priority of processing.  The
    first row in the table is an event that has an associated expanded
    event currently being processed or next in line to be processed.
    """

    _ELEMENTS = (
        E(
            "event_table",
            "eventTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* eventTable  *Tabular*
    event_table = Field(
        type=list,
        required=True,
    )


class GroupDeviceManagementGetAccessDeviceCountForDeviceTypeGroupResponse(OCIResponse):
    """
    Response to ``GroupDeviceManagementGetAccessDeviceCountForDeviceTypeGroupRequest()``.
    """

    _ELEMENTS = (
        E(
            "access_device_count",
            "accessDeviceCount",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: int: *Required* accessDeviceCount
    access_device_count = Field(
        type=int,
        required=True,
    )


class GroupDeviceTypeCustomTagGetListResponse(OCIResponse):
    """
    Response to ``GroupDeviceTypeCustomTagGetListRequest()``.
    Contains a table of custom configuration tags managed by the Device Management
    System on a per-device type basis for a group.
    The column headings are: "Tag Name", "Tag Value"
    """

    _ELEMENTS = (
        E(
            "group_device_type_custom_tags_table",
            "groupDeviceTypeCustomTagsTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* groupDeviceTypeCustomTagsTable  *Tabular*
    group_device_type_custom_tags_table = Field(
        type=list,
        required=True,
    )


class GroupDeviceTypeFileGetListResponse(OCIResponse):
    """
    Response to ``GroupDeviceTypeFileGetListRequest()``.
    Contains a table of device type files managed by the Device Management System, on
    a per-group basis.
    The column headings are: "File Type", "File Format", "Is Authenticated".
    Replaced By ``GroupDeviceTypeFileGetListResponse14sp8()``
    """

    _ELEMENTS = (
        E(
            "group_device_type_files_table",
            "groupDeviceTypeFilesTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* groupDeviceTypeFilesTable  *Tabular*
    group_device_type_files_table = Field(
        type=list,
        required=True,
    )


class GroupDeviceTypeFileGetListResponse14sp8(OCIResponse):
    """
    Response to ``GroupDeviceTypeFileGetListRequest14sp8()``.
    Contains a table of device type files managed by the Device Management System, on
    a per-group basis.
    The column headings are: "File Format", "Is Authenticated", "Access URL",
    "Repository URL", "Template URL".
    Replaced By GroupDeviceTypeFileGetListResponset21.
    """

    _ELEMENTS = (
        E(
            "group_device_type_files_table",
            "groupDeviceTypeFilesTable",
            list,
            True,
            True,
            False,
            True,
        ),
        E(
            "group_has_files_with_customizable_tags",
            "groupHasFilesWithCustomizableTags",
            bool,
            False,
            False,
            False,
            False,
        ),
    )
    #: list: *Required* groupDeviceTypeFilesTable  *Tabular*
    group_device_type_files_table = Field(
        type=list,
        required=True,
    )
    #: bool: *Optional* groupHasFilesWithCustomizableTags
    group_has_files_with_customizable_tags = Field(
        type=bool,
        required=False,
    )


class GroupDeviceTypeFileGetListResponse21(OCIResponse):
    """
    Response to ``GroupDeviceTypeFileGetListRequest21()``.
    Contains a table of device type files managed by the Device Management System, on
    a per-group basis.
    The column headings are: "File Format", "Is Authenticated", "Access URL",
    "Repository URL", "Template URL".
    """

    _ELEMENTS = (
        E(
            "group_device_type_files_table",
            "groupDeviceTypeFilesTable",
            list,
            True,
            True,
            False,
            True,
        ),
        E(
            "group_has_customizable_dynamic_files",
            "groupHasCustomizableDynamicFiles",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: list: *Required* groupDeviceTypeFilesTable  *Tabular*
    group_device_type_files_table = Field(
        type=list,
        required=True,
    )
    #: bool: *Required* groupHasCustomizableDynamicFiles
    group_has_customizable_dynamic_files = Field(
        type=bool,
        required=True,
    )


class GroupDeviceTypeFileGetResponse(OCIResponse):
    """
    Response to ``GroupDeviceTypeFileGetRequest()``.
    Replaced By ``GroupDeviceTypeFileGetResponse14sp8()``
    """

    _ELEMENTS = (
        E(
            "file_source",
            "fileSource",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "configuration_file_name",
            "configurationFileName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* fileSource
    file_source = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* configurationFileName
    configuration_file_name = Field(
        type=str,
        required=False,
    )


class GroupDeviceTypeFileGetResponse14sp8(OCIResponse):
    """
    Response to ``GroupDeviceTypeFileGetRequest14sp8()``.
    Replaced By ``GroupDeviceTypeFileGetResponse16sp1()``
    """

    _ELEMENTS = (
        E(
            "file_source",
            "fileSource",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "configuration_file_name",
            "configurationFileName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* fileSource
    file_source = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* configurationFileName
    configuration_file_name = Field(
        type=str,
        required=False,
    )


class GroupDeviceTypeFileGetResponse16sp1(OCIResponse):
    """
    Response to ``GroupDeviceTypeFileGetRequest16sp1()``.
    """

    _ELEMENTS = (
        E(
            "file_source",
            "fileSource",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "configuration_file_name",
            "configurationFileName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "access_url",
            "accessUrl",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "repository_url",
            "repositoryUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "template_url",
            "templateUrl",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* fileSource
    file_source = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* configurationFileName
    configuration_file_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* accessUrl
    access_url = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* repositoryUrl
    repository_url = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* templateUrl
    template_url = Field(
        type=str,
        required=False,
    )


class GroupDialPlanPolicyGetAccessCodeListResponse(OCIResponse):
    """
    Response to ``GroupDialPlanPolicyGetAccessCodeListRequest()``
    Contains a table with column headings: "Access Code",
    "Enable Secondary Dial Tone", "Description"
    """

    _ELEMENTS = (
        E(
            "access_code_table",
            "accessCodeTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* accessCodeTable  *Tabular*
    access_code_table = Field(
        type=list,
        required=True,
    )


class GroupDialPlanPolicyGetAccessCodeResponse(OCIResponse):
    """
    Response to ``GroupDialPlanPolicyGetAccessCodeRequest()``
    """

    _ELEMENTS = (
        E(
            "include_code_for_network_translations_and_routing",
            "includeCodeForNetworkTranslationsAndRouting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_code_for_screening_services",
            "includeCodeForScreeningServices",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_secondary_dial_tone",
            "enableSecondaryDialTone",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* includeCodeForNetworkTranslationsAndRouting
    include_code_for_network_translations_and_routing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* includeCodeForScreeningServices
    include_code_for_screening_services = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableSecondaryDialTone
    enable_secondary_dial_tone = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class GroupDialPlanPolicyGetResponse(OCIResponse):
    """
    Response to ``GroupDialPlanPolicyGetRequest()``

    Replaced By ``GroupDialPlanPolicyGetResponse17()``
    """

    _ELEMENTS = (
        E(
            "use_setting",
            "useSetting",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "requires_access_code_for_public_calls",
            "requiresAccessCodeForPublicCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_e164_public_calls",
            "allowE164PublicCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "public_digit_map",
            "publicDigitMap",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "private_digit_map",
            "privateDigitMap",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* useSetting
    use_setting = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* requiresAccessCodeForPublicCalls
    requires_access_code_for_public_calls = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowE164PublicCalls
    allow_e164_public_calls = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* publicDigitMap
    public_digit_map = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* privateDigitMap
    private_digit_map = Field(
        type=str,
        required=False,
    )


class GroupDialPlanPolicyGetResponse17(OCIResponse):
    """
    Response to ``GroupDialPlanPolicyGetRequest17()``
    """

    _ELEMENTS = (
        E(
            "use_setting",
            "useSetting",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "requires_access_code_for_public_calls",
            "requiresAccessCodeForPublicCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_e164_public_calls",
            "allowE164PublicCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "prefer_e164_number_format_for_callback_services",
            "preferE164NumberFormatForCallbackServices",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "public_digit_map",
            "publicDigitMap",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "private_digit_map",
            "privateDigitMap",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* useSetting
    use_setting = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* requiresAccessCodeForPublicCalls
    requires_access_code_for_public_calls = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowE164PublicCalls
    allow_e164_public_calls = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* preferE164NumberFormatForCallbackServices
    prefer_e164_number_format_for_callback_services = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* publicDigitMap
    public_digit_map = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* privateDigitMap
    private_digit_map = Field(
        type=str,
        required=False,
    )


class GroupDialableCallerIDCriteriaGetResponse(OCIResponse):
    """
    Response to the ``GroupDialableCallerIDCriteriaGetRequest()``.
    The response contains the Dialable Caller ID Criteria information.
    """

    _ELEMENTS = (
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "prefix_digits",
            "prefixDigits",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "match_call_type",
            "matchCallType",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "match_alternate_call_indicator",
            "matchAlternateCallIndicator",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "match_local_category",
            "matchLocalCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "match_national_category",
            "matchNationalCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "match_interlata_category",
            "matchInterlataCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "match_intralata_category",
            "matchIntralataCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "match_international_category",
            "matchInternationalCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "match_private_category",
            "matchPrivateCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "match_emergency_category",
            "matchEmergencyCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "match_other_category",
            "matchOtherCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* prefixDigits
    prefix_digits = Field(
        type=str,
        required=False,
    )
    #: list(str): *Optional* matchCallType  *Array*
    match_call_type = Field(
        type=list,
        required=False,
    )
    #: list(str): *Optional* matchAlternateCallIndicator  *Array*
    match_alternate_call_indicator = Field(
        type=list,
        required=False,
    )
    #: bool: *Required* matchLocalCategory
    match_local_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* matchNationalCategory
    match_national_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* matchInterlataCategory
    match_interlata_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* matchIntralataCategory
    match_intralata_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* matchInternationalCategory
    match_international_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* matchPrivateCategory
    match_private_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* matchEmergencyCategory
    match_emergency_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* matchOtherCategory
    match_other_category = Field(
        type=bool,
        required=True,
    )


class GroupDialableCallerIDGetResponse(OCIResponse):
    """
    Response to the ``GroupDialableCallerIDGetRequest()``.
    The criteria table�s column headings are "Active", "Name", "Description", �Prefix
    Digits�, �Priority�.
    """

    _ELEMENTS = (
        E(
            "use_group_criteria",
            "useGroupCriteria",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "ns_screening_failure_policy",
            "nsScreeningFailurePolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "criteria_table",
            "criteriaTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: bool: *Required* useGroupCriteria
    use_group_criteria = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* nsScreeningFailurePolicy
    ns_screening_failure_policy = Field(
        type=str,
        required=True,
    )
    #: list: *Required* criteriaTable  *Tabular*
    criteria_table = Field(
        type=list,
        required=True,
    )


class GroupDigitCollectionGetResponse13mp4(OCIResponse):
    """
    Response to ``GroupDigitCollectionGetRequest13mp4()``.
    """

    _ELEMENTS = (
        E(
            "use_setting",
            "useSetting",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_code",
            "accessCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "public_digit_map",
            "publicDigitMap",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "private_digit_map",
            "privateDigitMap",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* useSetting
    use_setting = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* accessCode
    access_code = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* publicDigitMap
    public_digit_map = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* privateDigitMap
    private_digit_map = Field(
        type=str,
        required=False,
    )


class GroupDirectoryNumberHuntingGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupDirectoryNumberHuntingGetAvailableUserListRequest()``.
    Contains a table with column headings: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupDirectoryNumberHuntingGetResponse(OCIResponse):
    """
    Response to the ``GroupDirectoryNumberHuntingGetRequest()``.
    Contains a table with column headings: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address".

    Replaced By ``GroupDirectoryNumberHuntingGetResponse17sp1()``
    """

    _ELEMENTS = (
        E(
            "agent_user_table",
            "agentUserTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* agentUserTable  *Tabular*
    agent_user_table = Field(
        type=list,
        required=True,
    )


class GroupDirectoryNumberHuntingGetResponse17sp1(OCIResponse):
    """
    Response to the ``GroupDirectoryNumberHuntingGetRequest()``.
    Contains a table with column headings: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "agent_user_table",
            "agentUserTable",
            list,
            True,
            True,
            False,
            True,
        ),
        E(
            "use_terminate_call_to_agent_first",
            "useTerminateCallToAgentFirst",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_original_agent_services_for_busy_and_no_answer_calls",
            "useOriginalAgentServicesForBusyAndNoAnswerCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: list: *Required* agentUserTable  *Tabular*
    agent_user_table = Field(
        type=list,
        required=True,
    )
    #: bool: *Required* useTerminateCallToAgentFirst
    use_terminate_call_to_agent_first = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useOriginalAgentServicesForBusyAndNoAnswerCalls
    use_original_agent_services_for_busy_and_no_answer_calls = Field(
        type=bool,
        required=True,
    )


class GroupDnGetActivationListResponse(OCIResponse):
    """
    Response to the ``GroupDnGetActivationListRequest()``.
    The response contains a table with columns: "Phone Numbers", and "Activated".  ".
    Phone Numbers are only returned if assigned to a user.
    The "Phone Numbers" column contains either a single DN or a range of DNs.
    The "Activated" column indicates if the phone number(s) are activated or not.
    """

    _ELEMENTS = (
        E(
            "dn_table",
            "dnTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* dnTable  *Tabular*
    dn_table = Field(
        type=list,
        required=True,
    )


class GroupDnGetAssignmentListResponse(OCIResponse):
    """
    Response to the ``GroupDnGetAssignmentListRequest()``.
    The response contains a table with columns: "Phone Numbers", "Assigned To",
    "Department", "Activated".
    The "Phone Numbers" column contains either a single DN or a range of DNs.
    The "Assigned To" column contains the user name or service instance name
    possessing the DN(s).
    The "Department" column contains the department of the DN, not the department of
    the user or service instance.
    The "Activated" column indicates if the DN or DN range has been activated.  Only
    has a value if the DN(s) is assigned to a user.

    Replaced By ``GroupDnGetAssignmentListResponse18()``
    """

    _ELEMENTS = (
        E(
            "dn_table",
            "dnTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* dnTable  *Tabular*
    dn_table = Field(
        type=list,
        required=True,
    )


class GroupDnGetAssignmentListResponse18(OCIResponse):
    """
    Response to the ``GroupDnGetAssignmentListRequest18()``.
    The response contains a table with columns: "Phone Numbers", "Department",
    "Activated", "User Id",
    "Last Name", "First Name", "Extension", "Email Address", "User Type".
    The "Phone Numbers" column contains either a single DN or a range of DNs.
    The "User Id", "Last Name" and "First Name" columns contains the corresponding
    attributes of the user possessing the DN(s).
    For a service instance, "Last Name" contains the service instance name and "First
    Name" column contains the corresponding enumerated UserType value.
    The "Department" column contains the department of the DN, not the department of
    the user or service instance.
    The "Activated" column indicates if the DN or DN range has been activated.  Only
    has a value if the DN(s) is assigned to a user.
    The "User Type" column contains the corresponding enumerated UserType value.
    NOTE: the same phone number can show up in the list twice if the phone number is
    being used as the group calling line Id.
    """

    _ELEMENTS = (
        E(
            "dn_table",
            "dnTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* dnTable  *Tabular*
    dn_table = Field(
        type=list,
        required=True,
    )


class GroupDnGetAvailableListResponse(OCIResponse):
    """
    Response to the ``GroupDnGetAvailableListRequest()``.
    The response contains the list of DNs that are assigned to a group and still available for
    assignment to users or service instances within the group.
    """

    _ELEMENTS = (
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* phoneNumber  *Array*
    phone_number = Field(
        type=list,
        required=False,
    )


class GroupDnGetAvailableRangesListResponse(OCIResponse):
    """
    Response to the ``GroupDnGetAvailableRangesListRequest()``.
    The response contains the list of group DNs that are not assigned to user,
    service instances or IMRN pool.
    The Dns are returned in a list of DNs or DN ranges and formated in E164 format
    for display.
    """

    _ELEMENTS = (
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* phoneNumber  *Array*
    phone_number = Field(
        type=list,
        required=False,
    )


class GroupDnGetDetailedAvailableListResponse(OCIResponse):
    """
    Response to the ``GroupDnGetDetailedAvailableListRequest()``.
    The response contains a table with columns: "Phone Number", "Department".
    The "Phone Numbers" column contains a single DN.
    The "Department" column contains the department of the DN if the DN is part of
    the department.
    The "Activated" column indicates if the DN has been activated.
    Only has a value if the DN(s) is assigned to a user or if "Group
    Enable Activation Mode" is enabled.
    """

    _ELEMENTS = (
        E(
            "dn_table",
            "dnTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* dnTable  *Tabular*
    dn_table = Field(
        type=list,
        required=True,
    )


class GroupDnGetListResponse(OCIResponse):
    """
    Response to the ``GroupDnGetListRequest()``.
    The response contains the list of DNs assigned to the group.
    """

    _ELEMENTS = (
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* phoneNumber  *Array*
    phone_number = Field(
        type=list,
        required=False,
    )


class GroupDnGetSummaryListResponse(OCIResponse):
    """
    Response to the ``GroupDnGetSummaryListRequest()``.
    The response contains a table with columns: "Phone Numbers", "Assigned".
    The "Phone Numbers" column contains either a single DN or a range of DNs.
    The "Assigned" column contains a boolean flag indicating if the DN(s) are
    currently assigned to a user or service instance.
    The "Activated" column indicates if the DN or DN range has been activated.
    Only has a value if the DN(s) is assigned to a user or if "Group Enable Activation
    Mode" is enabled.
    """

    _ELEMENTS = (
        E(
            "dn_table",
            "dnTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* dnTable  *Tabular*
    dn_table = Field(
        type=list,
        required=True,
    )


class GroupDomainGetAssignedListResponse(OCIResponse):
    """
    Contains a simple list of all group domain names.
    """

    _ELEMENTS = (
        E(
            "group_default_domain",
            "groupDefaultDomain",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "domain",
            "domain",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: str: *Required* groupDefaultDomain
    group_default_domain = Field(
        type=str,
        required=True,
    )
    #: list(str): *Optional* domain  *Array*
    domain = Field(
        type=list,
        required=False,
    )


class GroupDomainGetAssignedUserListResponse(OCIResponse):
    """
    Response to ``GroupDomainGetAssignedUserListRequest()``.
    The table columns are: "User Id", "Last Name", "First Name", "Department", "Phone
    Number", "Email Address",
    "Service Provider Id", "Group Id", "Hiragana Last Name" and "Hiragana First
    Name", "Extension".
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupEmergencyZonesGetResponse(OCIResponse):
    """
    Response to ``GroupEmergencyZonesGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "emergency_zones_prohibition",
            "emergencyZonesProhibition",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "send_emergency_call_notify_email",
            "sendEmergencyCallNotifyEmail",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "emergency_call_notify_email_address",
            "emergencyCallNotifyEmailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* emergencyZonesProhibition
    emergency_zones_prohibition = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* sendEmergencyCallNotifyEmail
    send_emergency_call_notify_email = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* emergencyCallNotifyEmailAddress
    emergency_call_notify_email_address = Field(
        type=str,
        required=False,
    )


class GroupEndpointGetListResponse(OCIResponse):
    """
    Response to ``GroupEndpointGetListRequest()``.
    The column headings for the endpointTable are:
    "Line/Port", "Last Name", "First Name",  "User Id", "User Type", "Phone Number",
    "Extension", "Device Type", "Device Name", "Net Address", "MAC Address",
    "Department", "Email Address".
    Possible values for User Type are �User�, �CCBasic�, �CCStandard�, �CCPremium�,
    �RP�, �MOH�, �MOHVideo�.
    """

    _ELEMENTS = (
        E(
            "endpoint_table",
            "endpointTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* endpointTable  *Tabular*
    endpoint_table = Field(
        type=list,
        required=True,
    )


class GroupEnterpriseTrunkGetAvailableTrunkGroupListResponse(OCIResponse):
    """
    Response to ``GroupEnterpriseTrunkGetAvailableTrunkGroupListRequest()``.
    """

    _ELEMENTS = (
        E(
            "trunk_group_name",
            "trunkGroupName",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* trunkGroupName  *Array*
    trunk_group_name = Field(
        type=list,
        required=False,
    )


class GroupEnterpriseTrunkGetAvailableUserListResponse(OCIResponse):
    """
    Response to ``GroupEnterpriseTrunkGetAvailableUserListRequest()``.
    The column headings for the enterpriseTrunkUserTable are: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupEnterpriseTrunkGetListResponse(OCIResponse):
    """
    Response to ``GroupEnterpriseTrunkGetListRequest()``.
    Contains a table of enterprise trunks defined in the enterprise
    The column headings are: "Enterprise Trunk Name", "Routing Type"
    """

    _ELEMENTS = (
        E(
            "enterprise_trunk_table",
            "enterpriseTrunkTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* enterpriseTrunkTable  *Tabular*
    enterprise_trunk_table = Field(
        type=list,
        required=True,
    )


class GroupEnterpriseTrunkGetResponse(OCIResponse):
    """
    Response to ``GroupEnterpriseTrunkGetRequest()``.

    Replaced By ``GroupEnterpriseTrunkGetResponse21()``.
    """

    _ELEMENTS = (
        E(
            "maximum_reroute_attempts",
            "maximumRerouteAttempts",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "route_exhaustion_action",
            "routeExhaustionAction",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "route_exhaustion_forward_address",
            "routeExhaustionForwardAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "ordered_routing",
            "orderedRouting",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "priority_weighted_routing",
            "priorityWeightedRouting",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
    )
    #: int: *Required* maximumRerouteAttempts
    maximum_reroute_attempts = Field(
        type=int,
        required=True,
    )
    #: str: *Required* routeExhaustionAction
    route_exhaustion_action = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* routeExhaustionForwardAddress
    route_exhaustion_forward_address = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* orderedRouting
    ordered_routing = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* priorityWeightedRouting
    priority_weighted_routing = Field(
        type=str,
        required=False,
    )


class GroupEnterpriseTrunkGetResponse21(OCIResponse):
    """
    Response to ``GroupEnterpriseTrunkGetRequest21()``.
    """

    _ELEMENTS = (
        E(
            "maximum_reroute_attempts",
            "maximumRerouteAttempts",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "route_exhaustion_action",
            "routeExhaustionAction",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "route_exhaustion_forward_address",
            "routeExhaustionForwardAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "ordered_routing",
            "orderedRouting",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "priority_weighted_routing",
            "priorityWeightedRouting",
            str,
            True,
            False,
            False,
            False,
        ),  # unknown
        E(
            "enable_capacity_management",
            "enableCapacityManagement",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_active_calls",
            "maxActiveCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_trap_initial_calls",
            "capacityExceededTrapInitialCalls",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "capacity_exceeded_trap_offset_calls",
            "capacityExceededTrapOffsetCalls",
            int,
            False,
            False,
            False,
            False,
        ),
    )
    #: int: *Required* maximumRerouteAttempts
    maximum_reroute_attempts = Field(
        type=int,
        required=True,
    )
    #: str: *Required* routeExhaustionAction
    route_exhaustion_action = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* routeExhaustionForwardAddress
    route_exhaustion_forward_address = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* orderedRouting
    ordered_routing = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* priorityWeightedRouting
    priority_weighted_routing = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* enableCapacityManagement
    enable_capacity_management = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* maxActiveCalls
    max_active_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* capacityExceededTrapInitialCalls
    capacity_exceeded_trap_initial_calls = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* capacityExceededTrapOffsetCalls
    capacity_exceeded_trap_offset_calls = Field(
        type=int,
        required=False,
    )


class GroupEnterpriseTrunkGetUserListResponse(OCIResponse):
    """
    Response to ``GroupEnterpriseTrunkGetUserListRequest()``.
    The column headings for the enterpriseTrunkUserTable are: "User Id", "Last Name",
    "First Name", "Phone Number", "Alternate Trunk Identity", "Hiragana Last Name",
    "Hiragana First Name",
    "Extension", "Department", "Email Address" and "Route List Assigned".
    """

    _ELEMENTS = (
        E(
            "enterprise_trunk_user_table",
            "enterpriseTrunkUserTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* enterpriseTrunkUserTable  *Tabular*
    enterprise_trunk_user_table = Field(
        type=list,
        required=True,
    )


class GroupExchangeIntegrationGetResponse(OCIResponse):
    """
    Response to ``GroupExchangeIntegrationGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "enable_exchange_integration",
            "enableExchangeIntegration",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "exchange_url",
            "exchangeURL",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "exchange_user_name",
            "exchangeUserName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* enableExchangeIntegration
    enable_exchange_integration = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* exchangeURL
    exchange_url = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* exchangeUserName
    exchange_user_name = Field(
        type=str,
        required=False,
    )


class GroupExtensionLengthGetResponse(OCIResponse):
    """
    Response to ``GroupExtensionLengthGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "extension_length",
            "extensionLength",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: int: *Required* extensionLength
    extension_length = Field(
        type=int,
        required=True,
    )


class GroupExtensionLengthGetResponse17(OCIResponse):
    """
    Response to ``GroupExtensionLengthGetRequest17()``.
    """

    _ELEMENTS = (
        E(
            "min_extension_length",
            "minExtensionLength",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_extension_length",
            "maxExtensionLength",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "default_extension_length",
            "defaultExtensionLength",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: int: *Required* minExtensionLength
    min_extension_length = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxExtensionLength
    max_extension_length = Field(
        type=int,
        required=True,
    )
    #: int: *Required* defaultExtensionLength
    default_extension_length = Field(
        type=int,
        required=True,
    )


class GroupFileRepositoryDeviceUserGetListResponse(OCIResponse):
    """
    Response to ``GroupFileRepositoryDeviceUserGetListRequest()``.
    Contains a table with column headings : "User Name","Allow Delete","Allow
    Get","Allow Put" in a row for each file repository service provider user.
    """

    _ELEMENTS = (
        E(
            "file_repository_user_table",
            "fileRepositoryUserTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* fileRepositoryUserTable  *Tabular*
    file_repository_user_table = Field(
        type=list,
        required=True,
    )


class GroupFindMeFollowMeAlertingGroupGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupFindMeFollowMeAlertingGroupGetAvailableUserListRequest()``.
    Contains a table with column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name",
    "Hiragana First Name", "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupFindMeFollowMeGetAlertingGroupListResponse(OCIResponse):
    """
    Response to the ``GroupFindMeFollowMeGetAlertingGroupListRequest()``.
    Contains a table with column headings:
    "Name", "Priority".
    """

    _ELEMENTS = (
        E(
            "alerting_group_table",
            "alertingGroupTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* alertingGroupTable  *Tabular*
    alerting_group_table = Field(
        type=list,
        required=True,
    )


class GroupFindMeFollowMeGetAlertingGroupResponse(OCIResponse):
    """
    Response to ``GroupFindMeFollowMeGetAlertingGroupRequest()``.
    Contains the alerting group information.
    The user table’s column headings are: "User Id", "Last Name", "First Name",
    "Hiragana Last Name" and "Hiragana First Name", "Phone Number", "Extension",
    "Department", "Email Address".
    The criteria table's column headings are: "Is Active", "Criteria Name", "Time
    Schedule", "Calls From", "Blacklisted", "Holiday Schedule"", "Calls To Type",
    "Calls To Number" and "Calls To Extension".
    The possible values for the "Calls To Type" column are the following or a
    combination of them separated by comma:
    - Primary
    - Alternate X (where x is a number between 1 and 10)
    The possible values for the "Calls To Number" column are the following or a
    combination of them separated by comma:
    - The value of the phone number for the corresponding Calls To Type, when the
    number is available. i.e. Alternate 1 may have extension, but no number.
    - When no number is available a blank space is provided instead.
    The possible values for the "Calls To Extension" column are the following or a
    combination of them separated by comma:
    - The value of the extension for the corresponding Calls To Type, when the
    extension is available. i.e. Primary may have number, but no extension.
    - When no extension is available a blank space is provided instead.
    """

    _ELEMENTS = (
        E(
            "alerting_group_description",
            "alertingGroupDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_diversion_inhibitor",
            "useDiversionInhibitor",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "answer_confirmation_required",
            "answerConfirmationRequired",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_of_rings",
            "numberOfRings",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number",
            "phoneNumber",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
        E(
            "criteria_table",
            "criteriaTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: str: *Optional* alertingGroupDescription
    alerting_group_description = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* useDiversionInhibitor
    use_diversion_inhibitor = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* answerConfirmationRequired
    answer_confirmation_required = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* numberOfRings
    number_of_rings = Field(
        type=int,
        required=True,
    )
    #: list(str): *Optional* phoneNumber  *Array*
    phone_number = Field(
        type=list,
        required=False,
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )
    #: list: *Required* criteriaTable  *Tabular*
    criteria_table = Field(
        type=list,
        required=True,
    )


class GroupFindMeFollowMeGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupFindMeFollowMeGetInstanceListRequest()``.
    Contains a table with column headings:
    "Service User Id", "Name", "Phone Number", "Extension", "Department", "Is Active".
    The column value for "Is Active" can either be true, or false.
    """

    _ELEMENTS = (
        E(
            "find_me_follow_me_table",
            "findMeFollowMeTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* findMeFollowMeTable  *Tabular*
    find_me_follow_me_table = Field(
        type=list,
        required=True,
    )


class GroupFlexibleSeatingAccessDeviceGetListResponse(OCIResponse):
    """
    Response to ``GroupFlexibleSeatingAccessDeviceGetListRequest()``
    """

    _ELEMENTS = (
        E(
            "available_access_device",
            "availableAccessDevice",
            str,
            True,
            False,
            True,
            False,
        ),  # unknown
    )
    #: list(str): *Optional* availableAccessDevice  *Array*
    available_access_device = Field(
        type=list,
        required=False,
    )


class GroupFlexibleSeatingHostGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupFlexibleSeatingHostGetInstanceListRequest()``.
    Contains a table with column headings:
    "Service User Id", "Name", "Phone Number", "Extension", "Department", "Is Active".
    The column value for "Is Active" can either be true, or false.
    """

    _ELEMENTS = (
        E(
            "flexible_seating_host_table",
            "flexibleSeatingHostTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* flexibleSeatingHostTable  *Tabular*
    flexible_seating_host_table = Field(
        type=list,
        required=True,
    )


class GroupFlexibleSeatingHostGuestAssociationGetResponse(OCIResponse):
    """
    Response to ``GroupFlexibleSeatingHostGuestAssociationGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "enforce_association_limit",
            "enforceAssociationLimit",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "association_limit_hours",
            "associationLimitHours",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_level",
            "accessLevel",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "guest_last_name",
            "guestLastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "guest_first_name",
            "guestFirstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "guest_phone_number",
            "guestPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "guest_extension",
            "guestExtension",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "guest_location_dialing_code",
            "guestLocationDialingCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "guest_association_date_time",
            "guestAssociationDateTime",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* enforceAssociationLimit
    enforce_association_limit = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* associationLimitHours
    association_limit_hours = Field(
        type=int,
        required=True,
    )
    #: str: *Required* accessLevel
    access_level = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* guestLastName
    guest_last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* guestFirstName
    guest_first_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* guestPhoneNumber
    guest_phone_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* guestExtension
    guest_extension = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* guestLocationDialingCode
    guest_location_dialing_code = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* guestAssociationDateTime
    guest_association_date_time = Field(
        type=str,
        required=False,
    )


class GroupFlexibleSeatingHostRoutingPoliciesGetResponse(OCIResponse):
    """
    Response to the ``GroupFlexibleSeatingHostRoutingPoliciesGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "allow_emergency_calls",
            "allowEmergencyCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_calls_to_voice_portal",
            "allowCallsToVoicePortal",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* allowEmergencyCalls
    allow_emergency_calls = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowCallsToVoicePortal
    allow_calls_to_voice_portal = Field(
        type=bool,
        required=True,
    )


class GroupGetDefaultResponse(OCIResponse):
    """
    Response to the ``GroupGetDefaultRequest()``. All values are default values for a
    group's profile.
    """

    _ELEMENTS = (
        E(
            "default_domain",
            "defaultDomain",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_limit",
            "userLimit",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "time_zone",
            "timeZone",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "time_zone_display_name",
            "timeZoneDisplayName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* defaultDomain
    default_domain = Field(
        type=str,
        required=True,
    )
    #: int: *Required* userLimit
    user_limit = Field(
        type=int,
        required=True,
    )
    #: str: *Required* timeZone
    time_zone = Field(
        type=str,
        required=True,
    )
    #: str: *Required* timeZoneDisplayName
    time_zone_display_name = Field(
        type=str,
        required=True,
    )


class GroupGetListInServiceProviderResponse(OCIResponse):
    """
    Response to ``GroupGetListInServiceProviderRequest()``.
    Contains a 3 column table with column headings: "Group Id", "Group Name", "User Limit"
    and a row for each group.
    """

    _ELEMENTS = (
        E(
            "group_table",
            "groupTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* groupTable  *Tabular*
    group_table = Field(
        type=list,
        required=True,
    )


class GroupGetListInSystemResponse(OCIResponse):
    """
    Response to ``GroupGetListInSystemRequest()``.
    Contains a table with column headings: "Group Id", "Group Name", "User Limit",
    "Organization Id", "Organization Type"
    and a row for each group.
    The "Organization Id" column is populated with either a service provider Id or an
    enterprise Id.
    The "Organization Type" column is populated with one of the enumerated strings
    defined in the
    OrganizationType OCI data type.  Please see OCISchemaDataTypes.xsd for details on
    OrganizationType.
    """

    _ELEMENTS = (
        E(
            "group_table",
            "groupTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* groupTable  *Tabular*
    group_table = Field(
        type=list,
        required=True,
    )


class GroupGetUserServiceAssignedUserListResponse(OCIResponse):
    """
    Return a table containing the list of users assigned the user service
    or service pack.  The table contains columns: "User Id", "Last Name",
    "First Name", "Department", "Phone Number", "Email Address", "Hiragana Last Name";
    "Hiragana First Name", "Extension".
    This is a response to the ``GroupGetUserServiceAssignedUserListRequest()``.
    """

    _ELEMENTS = (
        E(
            "user_list_table",
            "userListTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userListTable  *Tabular*
    user_list_table = Field(
        type=list,
        required=True,
    )


class GroupGroupPagingGetAvailableOriginatorListResponse(OCIResponse):
    """
    Response to the ``GroupGroupPagingGetAvailableOriginatorListRequest()``.
    Contains a table with column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name" and "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupGroupPagingGetAvailableTargetListResponse(OCIResponse):
    """
    Response to the ``GroupGroupPagingGetAvailableTargetListRequest()``.
    Contains a table with column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name" and "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupGroupPagingGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupGroupPagingGetInstanceListRequest()``.
    Contains a table with column headings:
    "Service User Id", "Name", "Phone Number", "Extension", "Department", "Is Active".
    The column value for "Is Active" can either be true, or false.
    """

    _ELEMENTS = (
        E(
            "paging_group_table",
            "pagingGroupTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* pagingGroupTable  *Tabular*
    paging_group_table = Field(
        type=list,
        required=True,
    )


class GroupGroupPagingGetOriginatorListResponse(OCIResponse):
    """
    Response to the ``GroupGroupPagingGetOriginatorListRequest()``.
    Contains a table with column headings: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "originator_table",
            "originatorTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* originatorTable  *Tabular*
    originator_table = Field(
        type=list,
        required=True,
    )


class GroupGroupPagingGetTargetListResponse(OCIResponse):
    """
    Response to the ``GroupGroupPagingGetTargetListRequest()``.
    Contains a table with column headings: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "target_table",
            "targetTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* targetTable  *Tabular*
    target_table = Field(
        type=list,
        required=True,
    )


class GroupGroupPagingTargetsCapacityGetResponse(OCIResponse):
    """
    Response to ``GroupGroupPagingTargetsCapacityGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "maximum_target_users_from_service_provider",
            "maximumTargetUsersFromServiceProvider",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "maximum_target_users",
            "maximumTargetUsers",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: int: *Required* maximumTargetUsersFromServiceProvider
    maximum_target_users_from_service_provider = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maximumTargetUsers
    maximum_target_users = Field(
        type=int,
        required=True,
    )


class GroupHolidayScheduleGetListResponse(OCIResponse):
    """
    Response to the ``GroupHolidayScheduleGetListRequest()``.
    The response contains all the group's holiday schedule name.
    """

    _ELEMENTS = (
        E(
            "holiday_schedule_name",
            "holidayScheduleName",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* holidayScheduleName  *Array*
    holiday_schedule_name = Field(
        type=list,
        required=False,
    )


class GroupHuntGroupGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupHuntGroupGetAvailableUserListRequest()``.
    Contains a table with column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupHuntGroupGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupHuntGroupGetInstanceListRequest()``.
    Contains a table with column headings:
    "Service User Id", "Name", "Phone Number", "Extension", "Department", "Is
    Active", "Policy".
    The column values for "Is Active" can either be true, or false.
    NOTE: prior to release 14, the policy column did not match the HuntPolicy enumerated type.
    """

    _ELEMENTS = (
        E(
            "hunt_group_table",
            "huntGroupTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* huntGroupTable  *Tabular*
    hunt_group_table = Field(
        type=list,
        required=True,
    )


class GroupIMRNGetListResponse(OCIResponse):
    """
    Response to ``GroupIMRNGetListRequest()``.
    """

    _ELEMENTS = (
        E(
            "imrn",
            "imrn",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* imrn  *Array*
    imrn = Field(
        type=list,
        required=False,
    )


class GroupInstantGroupCallGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupInstantGroupCallGetInstanceListRequest()``.
    Contains a 6 column table with column headings:
    "Service User Id", "Name", "Phone Number", "Extension", "Department", "Is Active".
    The column values for Is Active can either be true, or false.
    """

    _ELEMENTS = (
        E(
            "instant_group_call_table",
            "instantGroupCallTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* instantGroupCallTable  *Tabular*
    instant_group_call_table = Field(
        type=list,
        required=True,
    )


class GroupIntegratedIMPGetResponse(OCIResponse):
    """
    Response to the ``GroupIntegratedIMPGetRequest()``.
    The response contains the group Integrated IMP service attributes.
    """

    _ELEMENTS = (
        E(
            "use_service_provider_setting",
            "useServiceProviderSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_domain",
            "serviceDomain",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* useServiceProviderSetting
    use_service_provider_setting = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* serviceDomain
    service_domain = Field(
        type=str,
        required=False,
    )


class GroupInterceptGroupGetResponse(OCIResponse):
    """
    Response to the ``GroupInterceptGroupGetRequest()``.
    Replaced By ``GroupInterceptGroupGetResponse16()``
    """

    _ELEMENTS = (
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "announcement_selection",
            "announcementSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_file_description",
            "audioFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_file_description",
            "videoFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "play_new_phone_number",
            "playNewPhoneNumber",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "new_phone_number",
            "newPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "transfer_on_zero_to_phone_number",
            "transferOnZeroToPhoneNumber",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "transfer_phone_number",
            "transferPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* announcementSelection
    announcement_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoFileDescription
    video_file_description = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* playNewPhoneNumber
    play_new_phone_number = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* newPhoneNumber
    new_phone_number = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* transferOnZeroToPhoneNumber
    transfer_on_zero_to_phone_number = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* transferPhoneNumber
    transfer_phone_number = Field(
        type=str,
        required=False,
    )


class GroupInterceptGroupGetResponse16(OCIResponse):
    """
    Response to the ``GroupInterceptGroupGetRequest16()``.
    Replaced By ``GroupInterceptGroupGetResponse16sp1()``
    """

    _ELEMENTS = (
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "announcement_selection",
            "announcementSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_file_description",
            "audioFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_media_type",
            "audioMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_file_description",
            "videoFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_media_type",
            "videoMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "play_new_phone_number",
            "playNewPhoneNumber",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "new_phone_number",
            "newPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "transfer_on_zero_to_phone_number",
            "transferOnZeroToPhoneNumber",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "transfer_phone_number",
            "transferPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* announcementSelection
    announcement_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioMediaType
    audio_media_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoFileDescription
    video_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoMediaType
    video_media_type = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* playNewPhoneNumber
    play_new_phone_number = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* newPhoneNumber
    new_phone_number = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* transferOnZeroToPhoneNumber
    transfer_on_zero_to_phone_number = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* transferPhoneNumber
    transfer_phone_number = Field(
        type=str,
        required=False,
    )


class GroupInterceptGroupGetResponse16sp1(OCIResponse):
    """
    Response to the ``GroupInterceptGroupGetRequest16sp1()``.
    """

    _ELEMENTS = (
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "announcement_selection",
            "announcementSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_file_description",
            "audioFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_media_type",
            "audioMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_file_description",
            "videoFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_media_type",
            "videoMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "play_new_phone_number",
            "playNewPhoneNumber",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "new_phone_number",
            "newPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "transfer_on_zero_to_phone_number",
            "transferOnZeroToPhoneNumber",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "transfer_phone_number",
            "transferPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "reroute_outbound_calls",
            "rerouteOutboundCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "outbound_reroute_phone_number",
            "outboundReroutePhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "allow_outbound_local_calls",
            "allowOutboundLocalCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "inbound_call_mode",
            "inboundCallMode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "alternate_blocking_announcement",
            "alternateBlockingAnnouncement",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "route_to_voice_mail",
            "routeToVoiceMail",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* announcementSelection
    announcement_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioMediaType
    audio_media_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoFileDescription
    video_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoMediaType
    video_media_type = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* playNewPhoneNumber
    play_new_phone_number = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* newPhoneNumber
    new_phone_number = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* transferOnZeroToPhoneNumber
    transfer_on_zero_to_phone_number = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* transferPhoneNumber
    transfer_phone_number = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* rerouteOutboundCalls
    reroute_outbound_calls = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* outboundReroutePhoneNumber
    outbound_reroute_phone_number = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* allowOutboundLocalCalls
    allow_outbound_local_calls = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* inboundCallMode
    inbound_call_mode = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* alternateBlockingAnnouncement
    alternate_blocking_announcement = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* routeToVoiceMail
    route_to_voice_mail = Field(
        type=bool,
        required=True,
    )


class GroupInventoryReportGetResponse(OCIResponse):
    """
    Response to ``GroupInventoryReportGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "inventory_report_table",
            "inventoryReportTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* inventoryReportTable  *Tabular*
    inventory_report_table = Field(
        type=list,
        required=True,
    )


class GroupLDAPIntegrationGetDirectoryResponse(OCIResponse):
    """
    Response to ``GroupLDAPIntegrationGetDirectoryRequest()``.
    """

    _ELEMENTS = (
        E(
            "use_level",
            "useLevel",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "server_net_address",
            "serverNetAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "server_port",
            "serverPort",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "search_base",
            "searchBase",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_ssl",
            "useSSL",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "require_authentication",
            "requireAuthentication",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "authenticated_dn",
            "authenticatedDN",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "authenticated_password",
            "authenticatedPassword",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "is_sort_enabled",
            "isSortEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_paged_result_enabled",
            "isPagedResultEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "search_filter",
            "searchFilter",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "include_search_attribute_in_search_filter",
            "includeSearchAttributeInSearchFilter",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "column1_attribute_name",
            "column1AttributeName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "column2_attribute_name",
            "column2AttributeName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "column3_attribute_name",
            "column3AttributeName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "column4_attribute_name",
            "column4AttributeName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "column1_label",
            "column1Label",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "column2_label",
            "column2Label",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "column3_label",
            "column3Label",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "column4_label",
            "column4Label",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "search_column",
            "searchColumn",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* useLevel
    use_level = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* serverNetAddress
    server_net_address = Field(
        type=str,
        required=False,
    )
    #: int: *Required* serverPort
    server_port = Field(
        type=int,
        required=True,
    )
    #: str: *Optional* searchBase
    search_base = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* useSSL
    use_ssl = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* requireAuthentication
    require_authentication = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* authenticatedDN
    authenticated_dn = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* authenticatedPassword
    authenticated_password = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* isSortEnabled
    is_sort_enabled = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* isPagedResultEnabled
    is_paged_result_enabled = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* searchFilter
    search_filter = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* includeSearchAttributeInSearchFilter
    include_search_attribute_in_search_filter = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* column1AttributeName
    column1_attribute_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* column2AttributeName
    column2_attribute_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* column3AttributeName
    column3_attribute_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* column4AttributeName
    column4_attribute_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* column1Label
    column1_label = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* column2Label
    column2_label = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* column3Label
    column3_label = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* column4Label
    column4_label = Field(
        type=str,
        required=False,
    )
    #: int: *Required* searchColumn
    search_column = Field(
        type=int,
        required=True,
    )


class GroupLDAPIntegrationGetResponse(OCIResponse):
    """
    Response to ``GroupLDAPIntegrationGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )


class GroupMWIDeliveryToMobileEndpointGetResponse(OCIResponse):
    """
    Response to ``GroupMWIDeliveryToMobileEndpointGetRequest()``.

    The templateActivationTable contains the list of templates defined for the group.
    The column headings are "Enable", "Language", "Type".
    """

    _ELEMENTS = (
        E(
            "use_setting_level",
            "useSettingLevel",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "template_activation_table",
            "templateActivationTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(
        type=str,
        required=True,
    )
    #: list: *Required* templateActivationTable  *Tabular*
    template_activation_table = Field(
        type=list,
        required=True,
    )


class GroupMeetMeConferencingGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupMeetMeConferencingGetAvailableUserListRequest()``.
    Contains a table with column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name", and "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupMeetMeConferencingGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupMeetMeConferencingGetInstanceListRequest()``.
    Contains a table with column headings: "Service User Id", "Name", "Phone Number",
    "Extension", "Department", "Ports", and "Is Active".
    The column values for "Is Active" can either be true, or false.
    """

    _ELEMENTS = (
        E(
            "conference_bridge_table",
            "conferenceBridgeTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* conferenceBridgeTable  *Tabular*
    conference_bridge_table = Field(
        type=list,
        required=True,
    )


class GroupNetworkClassOfServiceGetAssignedListResponse(OCIResponse):
    """
    Response to ``GroupNetworkClassOfServiceGetAssignedListRequest()``.
    Contains a table of all Network Classes of Service assigned to
    the group. The column headings are: "Name", "Description" and "Default".
    """

    _ELEMENTS = (
        E(
            "network_class_of_service_table",
            "networkClassOfServiceTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* networkClassOfServiceTable  *Tabular*
    network_class_of_service_table = Field(
        type=list,
        required=True,
    )


class GroupNetworkClassOfServiceGetAssignedUserListResponse(OCIResponse):
    """
    Response to ``GroupNetworkClassOfServiceGetAssignedUserListRequest()``.
    Contains a table of users that have the Network Class of Service
    assigned. The column headings are: "User Id", "User Type", "Last Name", "First Name",
    "Department", "Phone Number", "Email Address", "Service Provider Id",
    "Group Id", "Hiragana Last Name" and "Hiragana First Name" , "Extension".

    Replaced by ``GroupNetworkClassOfServiceGetAssignedUserListResponse21()``
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupNetworkClassOfServiceGetAssignedUserListResponse21(OCIResponse):
    """
    Response to ``GroupNetworkClassOfServiceGetAssignedUserListRequest21()``.
    Contains a table of users that have the Network Class of Service
    assigned. The column headings are: "User Id", "User Type", "Last Name", "First Name",
    "Department", "Phone Number", "Email Address", "Service Provider Id",
    "Group Id", "Hiragana Last Name" and "Hiragana First Name" , "Extension".
    The User type column will display Auto Attendant and the Call Center subtype.
    Call Center - Basic, Call Center - Standard and Call Center - Premium will be
    displayed instead of Call Center and
    Auto Attendant (for the Basic Auto Attendant) and Auto Attendant - Standard
    instead of Auto Attendant.
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupOfficeZoneGetAssignedListResponse(OCIResponse):
    """
    Response to ``GroupOfficeZoneGetAssignedListRequest()``.
    Contains a table of all Office Zones assigned to the
    group. The column headings are: "Name", "Description" and "Default".
    """

    _ELEMENTS = (
        E(
            "office_zone_table",
            "officeZoneTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* officeZoneTable  *Tabular*
    office_zone_table = Field(
        type=list,
        required=True,
    )


class GroupOfficeZoneGetAssignedUserListResponse(OCIResponse):
    """
    Response to ``GroupOfiiceZoneGetAssignedUserListRequest()``.
    Contains a table of users that have the Office Zone assigned. The column headings
    are: "User Id", "User Type", "Last Name",
    "First Name", "Department", "Phone Number", "Email Address", "Hiragana Last Name"
    and "Hiragana First Name", "Extension".
    Office Zones can only be unassigned if the Location-Based Calling Restrictions
    has been authorized to the group otherwise the request will fail.
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupOutgoingCallingPlanPinholeDigitPatternGetListResponse(OCIResponse):
    """
    Response to ``GroupOutgoingCallingPlanPinholeDigitPatternGetListRequest()``.
    Contains a table with column headings: "Name", "Digit Pattern".
    """

    _ELEMENTS = (
        E(
            "digit_pattern_table",
            "digitPatternTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* digitPatternTable  *Tabular*
    digit_pattern_table = Field(
        type=list,
        required=True,
    )


class GroupPasswordRulesGetResponse(OCIResponse):
    """
    Response to ``GroupPasswordRulesGetRequest()``.
    Contains the password rules applicable to users within the group.
    Repleced by: ``GroupPasswordRulesGetResponse16()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_user_id",
            "disallowUserId",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_old_password",
            "disallowOldPassword",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_reversed_old_password",
            "disallowReversedOldPassword",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "restrict_min_digits",
            "restrictMinDigits",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_digits",
            "minDigits",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "restrict_min_upper_case_letters",
            "restrictMinUpperCaseLetters",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_upper_case_letters",
            "minUpperCaseLetters",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "restrict_min_lower_case_letters",
            "restrictMinLowerCaseLetters",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_lower_case_letters",
            "minLowerCaseLetters",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_non_alphanumeric_characters",
            "minNonAlphanumericCharacters",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_length",
            "minLength",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_failed_login_attempts",
            "maxFailedLoginAttempts",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "password_expires_days",
            "passwordExpiresDays",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "send_login_disabled_notify_email",
            "sendLoginDisabledNotifyEmail",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "login_disabled_notify_email_address",
            "loginDisabledNotifyEmailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "disallow_rules_modification",
            "disallowRulesModification",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupId
    group_id = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* disallowUserId
    disallow_user_id = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowOldPassword
    disallow_old_password = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowReversedOldPassword
    disallow_reversed_old_password = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* restrictMinDigits
    restrict_min_digits = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minDigits
    min_digits = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* restrictMinUpperCaseLetters
    restrict_min_upper_case_letters = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minUpperCaseLetters
    min_upper_case_letters = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* restrictMinLowerCaseLetters
    restrict_min_lower_case_letters = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minLowerCaseLetters
    min_lower_case_letters = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* restrictMinNonAlphanumericCharacters
    restrict_min_non_alphanumeric_characters = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minNonAlphanumericCharacters
    min_non_alphanumeric_characters = Field(
        type=int,
        required=True,
    )
    #: int: *Required* minLength
    min_length = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxFailedLoginAttempts
    max_failed_login_attempts = Field(
        type=int,
        required=True,
    )
    #: int: *Required* passwordExpiresDays
    password_expires_days = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* disallowRulesModification
    disallow_rules_modification = Field(
        type=bool,
        required=True,
    )


class GroupPasswordRulesGetResponse16(OCIResponse):
    """
    Response to ``GroupPasswordRulesGetRequest16()``.
    Contains the password rules applicable to users within the group.
    """

    _ELEMENTS = (
        E(
            "disallow_user_id",
            "disallowUserId",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_old_password",
            "disallowOldPassword",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_reversed_old_password",
            "disallowReversedOldPassword",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "restrict_min_digits",
            "restrictMinDigits",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_digits",
            "minDigits",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "restrict_min_upper_case_letters",
            "restrictMinUpperCaseLetters",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_upper_case_letters",
            "minUpperCaseLetters",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "restrict_min_lower_case_letters",
            "restrictMinLowerCaseLetters",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_lower_case_letters",
            "minLowerCaseLetters",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_non_alphanumeric_characters",
            "minNonAlphanumericCharacters",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_length",
            "minLength",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_failed_login_attempts",
            "maxFailedLoginAttempts",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "password_expires_days",
            "passwordExpiresDays",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "send_login_disabled_notify_email",
            "sendLoginDisabledNotifyEmail",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "login_disabled_notify_email_address",
            "loginDisabledNotifyEmailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "disallow_rules_modification",
            "disallowRulesModification",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_previous_passwords",
            "disallowPreviousPasswords",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_of_previous_passwords",
            "numberOfPreviousPasswords",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* disallowUserId
    disallow_user_id = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowOldPassword
    disallow_old_password = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowReversedOldPassword
    disallow_reversed_old_password = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* restrictMinDigits
    restrict_min_digits = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minDigits
    min_digits = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* restrictMinUpperCaseLetters
    restrict_min_upper_case_letters = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minUpperCaseLetters
    min_upper_case_letters = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* restrictMinLowerCaseLetters
    restrict_min_lower_case_letters = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minLowerCaseLetters
    min_lower_case_letters = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* restrictMinNonAlphanumericCharacters
    restrict_min_non_alphanumeric_characters = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minNonAlphanumericCharacters
    min_non_alphanumeric_characters = Field(
        type=int,
        required=True,
    )
    #: int: *Required* minLength
    min_length = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxFailedLoginAttempts
    max_failed_login_attempts = Field(
        type=int,
        required=True,
    )
    #: int: *Required* passwordExpiresDays
    password_expires_days = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* disallowRulesModification
    disallow_rules_modification = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowPreviousPasswords
    disallow_previous_passwords = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* numberOfPreviousPasswords
    number_of_previous_passwords = Field(
        type=int,
        required=True,
    )


class GroupPhoneDirectoryGetListResponse(OCIResponse):
    """
    Response to ``GroupPhoneDirectoryGetListRequest()``.
    Contains a table with  a row for each phone number and column headings :
    "Name", "Number", "Extension", "Mobile", "Email Address", "Department", "Hiragana
    Name", "Group Id", "Yahoo Id".
    If extended directory information is requested, the following columns are also included:
    "First Name", "Last Name", "User Id", "Pager", "Title", "Time Zone", "Location",
    "Address Line 1", "Address Line 2",
    "City", "State", "Zip", "Country".

    Replace by: ``GroupPhoneDirectoryGetListResponse17()``
    """

    _ELEMENTS = (
        E(
            "directory_table",
            "directoryTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* directoryTable  *Tabular*
    directory_table = Field(
        type=list,
        required=True,
    )


class GroupPhoneDirectoryGetListResponse17(OCIResponse):
    """
    Response to ``GroupPhoneDirectoryGetListRequest17()``.
    Contains a table with a row for each phone number and column headings :
    "Name", "Number", "Extension", "Mobile", "Email Address",
    "Department", "Hiragana Name", "Group Id", "Yahoo Id",
    "Is Virtual On-Net User"
    If extended directory information is requested, the following columns are also included:
    "First Name", "Last Name", "User Id", "Pager", "Title", "Time Zone",
    "Location", "Address Line 1", "Address Line 2", "City", "State",
    "Zip", "Country".

    Replaced By ``GroupPhoneDirectoryGetListResponse18()``
    """

    _ELEMENTS = (
        E(
            "directory_table",
            "directoryTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* directoryTable  *Tabular*
    directory_table = Field(
        type=list,
        required=True,
    )


class GroupPhoneDirectoryGetListResponse17sp3(OCIResponse):
    """
    Response to ``GroupPhoneDirectoryGetListRequest17sp3()``.
    Contains a table with a row for each phone number and column headings :
    "Name", "Number", "Extension", "Mobile", "Email Address",
    "Department", "Hiragana Name", "Group Id", "Yahoo Id", "IMP Id" and
    "Is Virtual On-Net User"
    If extended directory information is requested, the following columns are also included:
    "First Name", "Last Name", "User Id", "Pager", "Title", "Time Zone",
    "Location", "Address Line 1", "Address Line 2", "City", "State",
    "Zip", "Country".

    Replaced By ``GroupPhoneDirectoryGetListResponse18()``
    """

    _ELEMENTS = (
        E(
            "directory_table",
            "directoryTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* directoryTable  *Tabular*
    directory_table = Field(
        type=list,
        required=True,
    )


class GroupPhoneDirectoryGetListResponse18(OCIResponse):
    """
    Response to ``GroupPhoneDirectoryGetListRequest18()``.
    Contains a table with a row for each phone number and column headings :
    "Name", "Number", "Extension", "Mobile", "Email Address",
    "Department", "Hiragana Name", "Group Id", "Yahoo Id", "User Id", "IMP Id" and
    "Is Virtual On-Net User".

    If extended directory information is requested, the following columns are also included:
    "First Name", "Last Name", "Pager", "Title", "Time Zone",
    "Location", "Address Line 1", "Address Line 2", "City", "State", "Zip", "Country".
    """

    _ELEMENTS = (
        E(
            "directory_table",
            "directoryTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* directoryTable  *Tabular*
    directory_table = Field(
        type=list,
        required=True,
    )


class GroupPolicyGetResponse(OCIResponse):
    """
    Response to ``GroupPolicyGetRequest()``.
    Contains the policy settings for the group.
    """

    _ELEMENTS = (
        E(
            "calling_plan_access",
            "callingPlanAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "extension_access",
            "extensionAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "ldap_integration_access",
            "ldapIntegrationAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "voice_messaging_access",
            "voiceMessagingAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_admin_user_access",
            "departmentAdminUserAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_authentication_access",
            "userAuthenticationAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_group_directory_access",
            "userGroupDirectoryAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_profile_access",
            "userProfileAccess",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* callingPlanAccess
    calling_plan_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* extensionAccess
    extension_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* ldapIntegrationAccess
    ldap_integration_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* voiceMessagingAccess
    voice_messaging_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAdminUserAccess
    department_admin_user_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userAuthenticationAccess
    user_authentication_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userGroupDirectoryAccess
    user_group_directory_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userProfileAccess
    user_profile_access = Field(
        type=str,
        required=True,
    )


class GroupPolicyGetResponse14sp1(OCIResponse):
    """
    Response to ``GroupPolicyGetRequest14sp1()``.
    Contains the policy settings for the group.
    """

    _ELEMENTS = (
        E(
            "calling_plan_access",
            "callingPlanAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "extension_access",
            "extensionAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "ldap_integration_access",
            "ldapIntegrationAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "voice_messaging_access",
            "voiceMessagingAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_admin_user_access",
            "departmentAdminUserAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_admin_trunk_group_access",
            "departmentAdminTrunkGroupAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_authentication_access",
            "userAuthenticationAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_group_directory_access",
            "userGroupDirectoryAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_profile_access",
            "userProfileAccess",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* callingPlanAccess
    calling_plan_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* extensionAccess
    extension_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* ldapIntegrationAccess
    ldap_integration_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* voiceMessagingAccess
    voice_messaging_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAdminUserAccess
    department_admin_user_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAdminTrunkGroupAccess
    department_admin_trunk_group_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userAuthenticationAccess
    user_authentication_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userGroupDirectoryAccess
    user_group_directory_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userProfileAccess
    user_profile_access = Field(
        type=str,
        required=True,
    )


class GroupPolicyGetResponse14sp4(OCIResponse):
    """
    Response to ``GroupPolicyGetRequest14sp4()``.
    Contains the policy settings for the group.
    """

    _ELEMENTS = (
        E(
            "calling_plan_access",
            "callingPlanAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "extension_access",
            "extensionAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "ldap_integration_access",
            "ldapIntegrationAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "voice_messaging_access",
            "voiceMessagingAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_admin_user_access",
            "departmentAdminUserAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_admin_trunk_group_access",
            "departmentAdminTrunkGroupAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_authentication_access",
            "userAuthenticationAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_group_directory_access",
            "userGroupDirectoryAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_profile_access",
            "userProfileAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_enhanced_call_log_access",
            "userEnhancedCallLogAccess",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* callingPlanAccess
    calling_plan_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* extensionAccess
    extension_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* ldapIntegrationAccess
    ldap_integration_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* voiceMessagingAccess
    voice_messaging_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAdminUserAccess
    department_admin_user_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAdminTrunkGroupAccess
    department_admin_trunk_group_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userAuthenticationAccess
    user_authentication_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userGroupDirectoryAccess
    user_group_directory_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userProfileAccess
    user_profile_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userEnhancedCallLogAccess
    user_enhanced_call_log_access = Field(
        type=str,
        required=True,
    )


class GroupPolicyGetResponse17(OCIResponse):
    """
    Response to ``GroupPolicyGetRequest17()``.
    Contains the policy settings for the group.
    """

    _ELEMENTS = (
        E(
            "calling_plan_access",
            "callingPlanAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "extension_access",
            "extensionAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "ldap_integration_access",
            "ldapIntegrationAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "voice_messaging_access",
            "voiceMessagingAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_admin_user_access",
            "departmentAdminUserAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_admin_trunk_group_access",
            "departmentAdminTrunkGroupAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_admin_phone_number_extension_access",
            "departmentAdminPhoneNumberExtensionAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_admin_calling_line_id_number_access",
            "departmentAdminCallingLineIdNumberAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_authentication_access",
            "userAuthenticationAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_group_directory_access",
            "userGroupDirectoryAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_profile_access",
            "userProfileAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_enhanced_call_log_access",
            "userEnhancedCallLogAccess",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* callingPlanAccess
    calling_plan_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* extensionAccess
    extension_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* ldapIntegrationAccess
    ldap_integration_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* voiceMessagingAccess
    voice_messaging_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAdminUserAccess
    department_admin_user_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAdminTrunkGroupAccess
    department_admin_trunk_group_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAdminPhoneNumberExtensionAccess
    department_admin_phone_number_extension_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAdminCallingLineIdNumberAccess
    department_admin_calling_line_id_number_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userAuthenticationAccess
    user_authentication_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userGroupDirectoryAccess
    user_group_directory_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userProfileAccess
    user_profile_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userEnhancedCallLogAccess
    user_enhanced_call_log_access = Field(
        type=str,
        required=True,
    )


class GroupPolicyGetResponse20(OCIResponse):
    """
    Response to ``GroupPolicyGetRequest20()``.
    Contains the policy settings for the group.
    """

    _ELEMENTS = (
        E(
            "calling_plan_access",
            "callingPlanAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "extension_access",
            "extensionAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "ldap_integration_access",
            "ldapIntegrationAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "voice_messaging_access",
            "voiceMessagingAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_admin_user_access",
            "departmentAdminUserAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_admin_trunk_group_access",
            "departmentAdminTrunkGroupAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_admin_phone_number_extension_access",
            "departmentAdminPhoneNumberExtensionAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_admin_calling_line_id_number_access",
            "departmentAdminCallingLineIdNumberAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_authentication_access",
            "userAuthenticationAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_group_directory_access",
            "userGroupDirectoryAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_profile_access",
            "userProfileAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_enhanced_call_log_access",
            "userEnhancedCallLogAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_auto_attendant_name_dialing_access",
            "userAutoAttendantNameDialingAccess",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* callingPlanAccess
    calling_plan_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* extensionAccess
    extension_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* ldapIntegrationAccess
    ldap_integration_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* voiceMessagingAccess
    voice_messaging_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAdminUserAccess
    department_admin_user_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAdminTrunkGroupAccess
    department_admin_trunk_group_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAdminPhoneNumberExtensionAccess
    department_admin_phone_number_extension_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAdminCallingLineIdNumberAccess
    department_admin_calling_line_id_number_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userAuthenticationAccess
    user_authentication_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userGroupDirectoryAccess
    user_group_directory_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userProfileAccess
    user_profile_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userEnhancedCallLogAccess
    user_enhanced_call_log_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userAutoAttendantNameDialingAccess
    user_auto_attendant_name_dialing_access = Field(
        type=str,
        required=True,
    )


class GroupPolycomPhoneServicesGetResponse(OCIResponse):
    """
    Response to ``GroupPolycomPhoneServicesGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "include_group_common_phone_list_in_directory",
            "includeGroupCommonPhoneListInDirectory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_group_custom_contact_directory_in_directory",
            "includeGroupCustomContactDirectoryInDirectory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_custom_contact_directory",
            "groupCustomContactDirectory",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* includeGroupCommonPhoneListInDirectory
    include_group_common_phone_list_in_directory = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* includeGroupCustomContactDirectoryInDirectory
    include_group_custom_contact_directory_in_directory = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* groupCustomContactDirectory
    group_custom_contact_directory = Field(
        type=str,
        required=False,
    )


class GroupPortalPasscodeRulesGetResponse(OCIResponse):
    """
    Response to ``GroupPortalPasscodeRulesGetRequest()``.
    Contains the group's passcode rules setting.
    """

    _ELEMENTS = (
        E(
            "use_rule_level",
            "useRuleLevel",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_repeated_digits",
            "disallowRepeatedDigits",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_user_number",
            "disallowUserNumber",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_reversed_user_number",
            "disallowReversedUserNumber",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_old_passcode",
            "disallowOldPasscode",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_reversed_old_passcode",
            "disallowReversedOldPasscode",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_code_length",
            "minCodeLength",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_code_length",
            "maxCodeLength",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "disable_login_after_max_failed_login_attempts",
            "disableLoginAfterMaxFailedLoginAttempts",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_failed_login_attempts",
            "maxFailedLoginAttempts",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "expire_password",
            "expirePassword",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "passcode_expires_days",
            "passcodeExpiresDays",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "send_login_disabled_notify_email",
            "sendLoginDisabledNotifyEmail",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "login_disabled_notify_email_address",
            "loginDisabledNotifyEmailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* useRuleLevel
    use_rule_level = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* disallowRepeatedDigits
    disallow_repeated_digits = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowUserNumber
    disallow_user_number = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowReversedUserNumber
    disallow_reversed_user_number = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowOldPasscode
    disallow_old_passcode = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowReversedOldPasscode
    disallow_reversed_old_passcode = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minCodeLength
    min_code_length = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxCodeLength
    max_code_length = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* disableLoginAfterMaxFailedLoginAttempts
    disable_login_after_max_failed_login_attempts = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* maxFailedLoginAttempts
    max_failed_login_attempts = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* expirePassword
    expire_password = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* passcodeExpiresDays
    passcode_expires_days = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(
        type=str,
        required=False,
    )


class GroupPortalPasscodeRulesGetResponse19(OCIResponse):
    """
    Response to ``GroupPortalPasscodeRulesGetRequest19()``.
    Contains the group's passcode rules setting.

    The following elements are only used in AS data mode:
    numberOfRepeatedDigits
    disallowRepeatedPatterns
    disallowContiguousSequences
    numberOfAscendingDigits
    numberOfDescendingDigits
    numberOfPreviousPasscodes
    """

    _ELEMENTS = (
        E(
            "use_rule_level",
            "useRuleLevel",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_repeated_digits",
            "disallowRepeatedDigits",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_of_repeated_digits",
            "numberOfRepeatedDigits",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_repeated_patterns",
            "disallowRepeatedPatterns",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_contiguous_sequences",
            "disallowContiguousSequences",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_of_ascending_digits",
            "numberOfAscendingDigits",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_of_descending_digits",
            "numberOfDescendingDigits",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_user_number",
            "disallowUserNumber",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_reversed_user_number",
            "disallowReversedUserNumber",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_old_passcode",
            "disallowOldPasscode",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_of_previous_passcodes",
            "numberOfPreviousPasscodes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_reversed_old_passcode",
            "disallowReversedOldPasscode",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_code_length",
            "minCodeLength",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_code_length",
            "maxCodeLength",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "disable_login_after_max_failed_login_attempts",
            "disableLoginAfterMaxFailedLoginAttempts",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_failed_login_attempts",
            "maxFailedLoginAttempts",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "expire_password",
            "expirePassword",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "passcode_expires_days",
            "passcodeExpiresDays",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "send_login_disabled_notify_email",
            "sendLoginDisabledNotifyEmail",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "login_disabled_notify_email_address",
            "loginDisabledNotifyEmailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* useRuleLevel
    use_rule_level = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* disallowRepeatedDigits
    disallow_repeated_digits = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* numberOfRepeatedDigits
    number_of_repeated_digits = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* disallowRepeatedPatterns
    disallow_repeated_patterns = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowContiguousSequences
    disallow_contiguous_sequences = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* numberOfAscendingDigits
    number_of_ascending_digits = Field(
        type=int,
        required=True,
    )
    #: int: *Required* numberOfDescendingDigits
    number_of_descending_digits = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* disallowUserNumber
    disallow_user_number = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowReversedUserNumber
    disallow_reversed_user_number = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowOldPasscode
    disallow_old_passcode = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* numberOfPreviousPasscodes
    number_of_previous_passcodes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* disallowReversedOldPasscode
    disallow_reversed_old_passcode = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minCodeLength
    min_code_length = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxCodeLength
    max_code_length = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* disableLoginAfterMaxFailedLoginAttempts
    disable_login_after_max_failed_login_attempts = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* maxFailedLoginAttempts
    max_failed_login_attempts = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* expirePassword
    expire_password = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* passcodeExpiresDays
    passcode_expires_days = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(
        type=str,
        required=False,
    )


class GroupPreAlertingAnnouncementGetResponse(OCIResponse):
    """
    Get the group level pre-alerting service settings.
    The response is either a ``GroupPreAlertingAnnouncementGetResponse()`` or an
    ``ErrorResponse()``.
    """

    _ELEMENTS = (
        E(
            "announcement_interruption",
            "announcementInterruption",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "interruption_digit_sequence",
            "interruptionDigitSequence",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_selection",
            "audioSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "audio_file_description",
            "audioFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_media_type",
            "audioMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "audio_file_url",
            "audioFileUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_selection",
            "videoSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "video_file_description",
            "videoFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_media_type",
            "videoMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "video_file_url",
            "videoFileUrl",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* announcementInterruption
    announcement_interruption = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* interruptionDigitSequence
    interruption_digit_sequence = Field(
        type=str,
        required=False,
    )
    #: str: *Required* audioSelection
    audio_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* audioFileDescription
    audio_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioMediaType
    audio_media_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* audioFileUrl
    audio_file_url = Field(
        type=str,
        required=False,
    )
    #: str: *Required* videoSelection
    video_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* videoFileDescription
    video_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoMediaType
    video_media_type = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* videoFileUrl
    video_file_url = Field(
        type=str,
        required=False,
    )


class GroupRouteListEnterpriseTrunkNumberRangeGetAvailableListResponse(OCIResponse):
    """
    Response to ``GroupRouteListEnterpriseTrunkNumberRangeGetAvailableListRequest()``.
    Contains a list of number ranges that are assigned to a group and still available
    for assignment to users within the group.
    The column headings are "Number Range Start", "Number Range End" and "Is Active".
    """

    _ELEMENTS = (
        E(
            "available_number_range_table",
            "availableNumberRangeTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* availableNumberRangeTable  *Tabular*
    available_number_range_table = Field(
        type=list,
        required=True,
    )


class GroupRouteListEnterpriseTrunkNumberRangeGetSummaryListResponse(OCIResponse):
    """
    Response to ``GroupRouteListEnterpriseTrunkNumberRangeGetSummaryListRequest()``.
    The response contains a table with columns: "Number Range Start", "Number Range
    End", "User Id",
    "Last Name", "First Name", "Hiragana Last Name", "Hiragana First Name", "Phone
    Number", "Extension",
    "Department", "Email Address", "Enterprise Trunk" and "Is Active".
    The "User Id", "Last Name", "First Name", "Hiragana Last Name", "Hiragana First
    Name", "Phone Number",
    "Extension", "Department" and "Email Address" columns contains the corresponding
    attributes of the user possessing the number range.
    The "Enterprise Trunk" column contains the enterprise trunk the user possessing
    the number range belongs to.
    The "Is Active" column indicates if the number range has been activated.
    """

    _ELEMENTS = (
        E(
            "number_range_summary_table",
            "numberRangeSummaryTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* numberRangeSummaryTable  *Tabular*
    number_range_summary_table = Field(
        type=list,
        required=True,
    )


class GroupRoutePointBouncedCallGetResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointBouncedCallGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_of_rings_before_bouncing_call",
            "numberOfRingsBeforeBouncingCall",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_transfer",
            "enableTransfer",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "transfer_phone_number",
            "transferPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "bounce_call_when_agent_unavailable",
            "bounceCallWhenAgentUnavailable",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* numberOfRingsBeforeBouncingCall
    number_of_rings_before_bouncing_call = Field(
        type=int,
        required=True,
    )
    #: bool: *Optional* enableTransfer
    enable_transfer = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* transferPhoneNumber
    transfer_phone_number = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* bounceCallWhenAgentUnavailable
    bounce_call_when_agent_unavailable = Field(
        type=bool,
        required=True,
    )


class GroupRoutePointDistinctiveRingingGetResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointDistinctiveRingingGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "enable_distinctive_ringing",
            "enableDistinctiveRinging",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "distinctive_ringing_ring_pattern",
            "distinctiveRingingRingPattern",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "distinctive_ringing_force_delivery_ring_pattern",
            "distinctiveRingingForceDeliveryRingPattern",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* enableDistinctiveRinging
    enable_distinctive_ringing = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* distinctiveRingingRingPattern
    distinctive_ringing_ring_pattern = Field(
        type=str,
        required=True,
    )
    #: str: *Required* distinctiveRingingForceDeliveryRingPattern
    distinctive_ringing_force_delivery_ring_pattern = Field(
        type=str,
        required=True,
    )


class GroupRoutePointExternalSystemGetAssignedListResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointExternalSystemGetAssignedListRequest()``.
    Contains a table of all Route Point External Systems assigned to the
    group.  The column headings are: "Name" and "Description".
    """

    _ELEMENTS = (
        E(
            "external_system_table",
            "externalSystemTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* externalSystemTable  *Tabular*
    external_system_table = Field(
        type=list,
        required=True,
    )


class GroupRoutePointExternalSystemGetAssignedRoutePointListResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointExternalSystemGetAssignedRoutePointListRequest()``.
    Contains a table with column headings:
    "Service User Id", "Name", "Video", "Phone Number", "Extension", "Department".
    The column values for "Video" can either be "true", or "false".
    """

    _ELEMENTS = (
        E(
            "route_point_table",
            "routePointTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* routePointTable  *Tabular*
    route_point_table = Field(
        type=list,
        required=True,
    )


class GroupRoutePointGetDNISAgentListResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointGetDNISAgentListRequest()``.
    Contains a table with column headings: "User Id", "Last Name",
    "First Name", "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "agent_table",
            "agentTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* agentTable  *Tabular*
    agent_table = Field(
        type=list,
        required=True,
    )


class GroupRoutePointGetDNISListResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointGetDNISListRequest()``.
    Contains a table with column headings: "Name", "Phone Number", "Extension".
    """

    _ELEMENTS = (
        E(
            "display_dnis_number",
            "displayDNISNumber",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "display_dnis_name",
            "displayDNISName",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "dnis_table",
            "dnisTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: bool: *Required* displayDNISNumber
    display_dnis_number = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* displayDNISName
    display_dnis_name = Field(
        type=bool,
        required=True,
    )
    #: list: *Required* dnisTable  *Tabular*
    dnis_table = Field(
        type=list,
        required=True,
    )


class GroupRoutePointGetDNISResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointGetDNISRequest()``.
    """

    _ELEMENTS = (
        E(
            "dnis_phone_number",
            "dnisPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "extension",
            "extension",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_custom_clid_settings",
            "useCustomCLIDSettings",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_phone_number",
            "callingLineIdPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_line_id_last_name",
            "callingLineIdLastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "calling_line_id_first_name",
            "callingLineIdFirstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_custom_dnis_announcement_settings",
            "useCustomDnisAnnouncementSettings",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_outgoing_acd_call",
            "allowOutgoingACDCall",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Optional* dnisPhoneNumber
    dnis_phone_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* extension
    extension = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* useCustomCLIDSettings
    use_custom_clid_settings = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* callingLineIdPhoneNumber
    calling_line_id_phone_number = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingLineIdLastName
    calling_line_id_last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* callingLineIdFirstName
    calling_line_id_first_name = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* useCustomDnisAnnouncementSettings
    use_custom_dnis_announcement_settings = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowOutgoingACDCall
    allow_outgoing_acd_call = Field(
        type=bool,
        required=True,
    )


class GroupRoutePointGetFailoverPolicyResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointGetFailoverPolicyRequest()``.
    """

    _ELEMENTS = (
        E(
            "enable_failover_support",
            "enableFailoverSupport",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "external_system",
            "externalSystem",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "failover_phone_number",
            "failoverPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "failover_status",
            "failoverStatus",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "per_call_enable_failover_support",
            "perCallEnableFailoverSupport",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "per_call_call_failure_timeout_seconds",
            "perCallCallFailureTimeoutSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "per_call_outbound_call_failure_timeout_seconds",
            "perCallOutboundCallFailureTimeoutSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "per_call_failover_phone_number",
            "perCallFailoverPhoneNumber",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* enableFailoverSupport
    enable_failover_support = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* externalSystem
    external_system = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* failoverPhoneNumber
    failover_phone_number = Field(
        type=str,
        required=False,
    )
    #: str: *Required* failoverStatus
    failover_status = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* perCallEnableFailoverSupport
    per_call_enable_failover_support = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* perCallCallFailureTimeoutSeconds
    per_call_call_failure_timeout_seconds = Field(
        type=int,
        required=True,
    )
    #: int: *Required* perCallOutboundCallFailureTimeoutSeconds
    per_call_outbound_call_failure_timeout_seconds = Field(
        type=int,
        required=True,
    )
    #: str: *Optional* perCallFailoverPhoneNumber
    per_call_failover_phone_number = Field(
        type=str,
        required=False,
    )


class GroupRoutePointGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointGetInstanceListRequest()``.
    Contains a table with column headings:
    "Service User Id", "Name", "Video", "Phone Number", "Extension", "Department",
    "Is Active".
    The column values for "Video" and "Is Active" can either be true, or false.
    """

    _ELEMENTS = (
        E(
            "route_point_table",
            "routePointTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* routePointTable  *Tabular*
    route_point_table = Field(
        type=list,
        required=True,
    )


class GroupRoutePointQueueCallDispositionCodeGetListResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointQueueCallDispositionCodeGetListRequest()``.
    Contains a table with column headings: "Is Active", "Code", "Description" and "Level".
    Level column can be any of the values in the data type CallDispositionCodeLevel.
    """

    _ELEMENTS = (
        E(
            "disposition_codes_table",
            "dispositionCodesTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* dispositionCodesTable  *Tabular*
    disposition_codes_table = Field(
        type=list,
        required=True,
    )


class GroupRoutePointQueueCallDispositionCodeGetResponse(OCIResponse):
    """
    Response to the ``GroupRoutePointQueueCallDispositionCodeGetRequest()``
    """

    _ELEMENTS = (
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class GroupRoutingProfileGetResponse(OCIResponse):
    """
    Response to ``GroupRoutingProfileGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "routing_profile",
            "routingProfile",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* routingProfile
    routing_profile = Field(
        type=str,
        required=False,
    )


class GroupScheduleGetEventListResponse(OCIResponse):
    """
    Response to ``GroupScheduleGetEventListRequest()``.
    The response contains a list of events.
    """

    _ELEMENTS = (
        E(
            "event_name",
            "eventName",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* eventName  *Array*
    event_name = Field(
        type=list,
        required=False,
    )


class GroupScheduleGetListResponse(OCIResponse):
    """
    Response to ``GroupScheduleGetListRequest()``.
    The response contains a list of system schedules.
    """

    _ELEMENTS = (
        E(
            "schedule_name",
            "scheduleName",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "schedule_type",
            "scheduleType",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "schedule_level",
            "scheduleLevel",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* scheduleName  *Array*
    schedule_name = Field(
        type=list,
        required=False,
    )
    #: list(str): *Optional* scheduleType  *Array*
    schedule_type = Field(
        type=list,
        required=False,
    )
    #: list(str): *Optional* scheduleLevel  *Array*
    schedule_level = Field(
        type=list,
        required=False,
    )


class GroupSeriesCompletionGetAvailableUserListResponse(OCIResponse):
    """
    Response to the ``GroupSeriesCompletionGetAvailableUserListRequest()``.
    Contains a table with column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupSeriesCompletionGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupSeriesCompletionGetInstanceListRequest()``.
    """

    _ELEMENTS = (
        E(
            "name",
            "name",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* name  *Array*
    name = Field(
        type=list,
        required=False,
    )


class GroupSeriesCompletionGetInstanceResponse(OCIResponse):
    """
    Response to the ``GroupSeriesCompletionGetInstanceRequest()``.
    Contains a table with column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupServiceGetAuthorizationListResponse(OCIResponse):
    """
    Response to ``GroupServiceGetAuthorizationListRequest()``.
    Contains three tables, one for the service packs, one for the group services, and one for
    the user services.
    The user table has the following column headings:
    "Service Name", "Authorized", "Assigned", "Limited", "Quantity", "Usage",
    "Licensed", "Allowed", "User Assignable", "Group Service Assignable".
    The group service table has the following column headings:
    "Service Name", "Authorized", "Assigned", "Limited", "Quantity", "Usage",
    "Licensed", "Allowed".
    The service pack table's column headings are:
    "Service Pack Name", "Authorized", "Assigned", "Limited", "Allocated", "Allowed",
    "Usage", "Description".
    """

    _ELEMENTS = (
        E(
            "service_packs_authorization_table",
            "servicePacksAuthorizationTable",
            list,
            True,
            True,
            False,
            True,
        ),
        E(
            "group_services_authorization_table",
            "groupServicesAuthorizationTable",
            list,
            True,
            True,
            False,
            True,
        ),
        E(
            "user_services_authorization_table",
            "userServicesAuthorizationTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* servicePacksAuthorizationTable  *Tabular*
    service_packs_authorization_table = Field(
        type=list,
        required=True,
    )
    #: list: *Required* groupServicesAuthorizationTable  *Tabular*
    group_services_authorization_table = Field(
        type=list,
        required=True,
    )
    #: list: *Required* userServicesAuthorizationTable  *Tabular*
    user_services_authorization_table = Field(
        type=list,
        required=True,
    )


class GroupServiceGetAuthorizedListResponse(OCIResponse):
    """
    Response to ``GroupServiceGetAuthorizedListRequest()``.
    """

    _ELEMENTS = (
        E(
            "service_pack_name",
            "servicePackName",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "group_service_name",
            "groupServiceName",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "user_service_name",
            "userServiceName",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* servicePackName  *Array*
    service_pack_name = Field(
        type=list,
        required=False,
    )
    #: list(str): *Optional* groupServiceName  *Array*
    group_service_name = Field(
        type=list,
        required=False,
    )
    #: list(str): *Optional* userServiceName  *Array*
    user_service_name = Field(
        type=list,
        required=False,
    )


class GroupServiceInstancePrivacyGetResponse(OCIResponse):
    """
    Response to ``GroupServiceInstancePrivacyGetRequest()``.
    Replaced By ``GroupServiceInstancePrivacyGetResponse17sp4()``
    """

    _ELEMENTS = (
        E(
            "enable_directory_privacy",
            "enableDirectoryPrivacy",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_auto_attendant_extension_dialing_privacy",
            "enableAutoAttendantExtensionDialingPrivacy",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* enableDirectoryPrivacy
    enable_directory_privacy = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableAutoAttendantExtensionDialingPrivacy
    enable_auto_attendant_extension_dialing_privacy = Field(
        type=bool,
        required=True,
    )


class GroupServiceInstancePrivacyGetResponse17sp4(OCIResponse):
    """
    Response to ``GroupServiceInstancePrivacyGetRequest17sp4()``.
    """

    _ELEMENTS = (
        E(
            "enable_directory_privacy",
            "enableDirectoryPrivacy",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_auto_attendant_extension_dialing_privacy",
            "enableAutoAttendantExtensionDialingPrivacy",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_auto_attendant_name_dialing_privacy",
            "enableAutoAttendantNameDialingPrivacy",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* enableDirectoryPrivacy
    enable_directory_privacy = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableAutoAttendantExtensionDialingPrivacy
    enable_auto_attendant_extension_dialing_privacy = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableAutoAttendantNameDialingPrivacy
    enable_auto_attendant_name_dialing_privacy = Field(
        type=bool,
        required=True,
    )


class GroupServiceIsAssignedResponse(OCIResponse):
    """
    Returns true if the GroupService is assigned, otherwise false.
    """

    _ELEMENTS = (
        E(
            "is_assigned",
            "isAssigned",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* isAssigned
    is_assigned = Field(
        type=bool,
        required=True,
    )


class GroupServicePhoneNumberLookupResponse(OCIResponse):
    """
    Response to the ``GroupServicePhoneNumberLookupRequest()``.
    The column headings for the userTable are: "User Id", "Last Name", "First Name",
    "Hiragana Last Name",
    "Hiragana First Name", "Phone Number", "Extension" and "Department".
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupServiceScriptsGroupGetLogResponse(OCIResponse):
    """
    Response to ``GroupServiceScriptsGroupGetLogRequest()``.
    """

    _ELEMENTS = (
        E(
            "log_content",
            "logContent",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* logContent
    log_content = Field(
        type=str,
        required=False,
    )


class GroupServiceScriptsGroupGetResponse(OCIResponse):
    """
    Response to ``GroupServiceScriptsGroupGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "script_name",
            "scriptName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "script_content",
            "scriptContent",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* scriptName
    script_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* scriptContent
    script_content = Field(
        type=str,
        required=False,
    )


class GroupSessionAdmissionControlGetResponse(OCIResponse):
    """
    Response to the ``GroupSessionAdmissionControlGetRequest()``.
    The response contains the session admission control capacity allocated for the group.
    """

    _ELEMENTS = (
        E(
            "restrict_aggregate_sessions",
            "restrictAggregateSessions",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_sessions",
            "maxSessions",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_user_originating_sessions",
            "maxUserOriginatingSessions",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "max_user_terminating_sessions",
            "maxUserTerminatingSessions",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "count_intra_group_sessions",
            "countIntraGroupSessions",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* restrictAggregateSessions
    restrict_aggregate_sessions = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* maxSessions
    max_sessions = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* maxUserOriginatingSessions
    max_user_originating_sessions = Field(
        type=int,
        required=False,
    )
    #: int: *Optional* maxUserTerminatingSessions
    max_user_terminating_sessions = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* countIntraGroupSessions
    count_intra_group_sessions = Field(
        type=bool,
        required=True,
    )


class GroupSessionAdmissionControlGroupGetListResponse(OCIResponse):
    """
    Response to ``GroupSessionAdmissionControlGroupGetListRequest()``.
    Contains a table of session admission control group configured in the group.
    The column headings are: "Name", "Is Default", "Maximum Sessions", "Maximum
    Originating Sessions", "Maximum Terminating Sessions".
    """

    _ELEMENTS = (
        E(
            "session_admission_control_group_table",
            "sessionAdmissionControlGroupTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* sessionAdmissionControlGroupTable  *Tabular*
    session_admission_control_group_table = Field(
        type=list,
        required=True,
    )


class GroupSpeedDial100GetResponse(OCIResponse):
    """
    Response to the ``GroupSpeedDial100GetRequest()``.
    """

    _ELEMENTS = (
        E(
            "prefix",
            "prefix",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* prefix
    prefix = Field(
        type=str,
        required=True,
    )


class GroupSpeedDial100GetResponse17sp1(OCIResponse):
    """
    Response to the ``GroupSpeedDial100GetRequest17sp1()``.
    """

    _ELEMENTS = (
        E(
            "prefix",
            "prefix",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* prefix
    prefix = Field(
        type=str,
        required=False,
    )


class GroupThirdPartyVoiceMailSupportGetResponse(OCIResponse):
    """
    Response to ``GroupThirdPartyVoiceMailSupportGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "is_active",
            "isActive",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_server",
            "groupServer",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* isActive
    is_active = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* groupServer
    group_server = Field(
        type=str,
        required=False,
    )


class GroupTimeScheduleGetListResponse(OCIResponse):
    """
    Response to the ``GroupTimeScheduleGetListRequest()``.
    The response contains all the group's time schedule name.
    """

    _ELEMENTS = (
        E(
            "time_schedule",
            "timeSchedule",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* timeSchedule  *Array*
    time_schedule = Field(
        type=list,
        required=False,
    )


class GroupTrunkGroupGetAvailableDetailListResponse(OCIResponse):
    """
    Response to ``GroupTrunkGroupGetAvailableDetailListRequest()``.
    """

    _ELEMENTS = (
        E(
            "trunk_group",
            "trunkGroup",
            str,
            True,
            False,
            True,
            False,
        ),  # unknown
    )
    #: list(str): *Optional* trunkGroup  *Array*
    trunk_group = Field(
        type=list,
        required=False,
    )


class GroupTrunkGroupGetAvailableHostedUserListResponse(OCIResponse):
    """
    Response to the ``GroupTrunkGroupGetAvailableHostedUserListRequest()``.
    Contains a table with column headings: "User Id", "Last Name", "First Name",
    "Hiragana Last Name", "Hiragana First Name",
    "Phone Number", "Extension", "Department", "Email Address".
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupTrunkGroupGetInstanceListResponse14(OCIResponse):
    """
    Response to ``GroupTrunkGroupGetInstanceListRequest14()``.
    Contains a table with column headings "Service User Id", "Name", "Department",
    "Device Name", "Device Level",
    "Group Id".
    The "Device Level" column contains one of the AccessDeviceLevel enumerated constants.
    """

    _ELEMENTS = (
        E(
            "trunk_group_table",
            "trunkGroupTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* trunkGroupTable  *Tabular*
    trunk_group_table = Field(
        type=list,
        required=True,
    )


class GroupTrunkGroupGetInstanceListResponse14sp4(OCIResponse):
    """
    Response to ``GroupTrunkGroupGetInstanceListRequest14sp4()``.
    Contains a table with column headings "Name", "Department", "Device Name", "Device Level",
    "Group Id".
    The "Device Level" column contains one of the AccessDeviceLevel enumerated constants.
    """

    _ELEMENTS = (
        E(
            "trunk_group_table",
            "trunkGroupTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* trunkGroupTable  *Tabular*
    trunk_group_table = Field(
        type=list,
        required=True,
    )


class GroupTrunkGroupGetInstanceUserListResponse(OCIResponse):
    """
    Response to ``GroupTrunkGroupGetInstanceUserListRequest()``.
    The response contains a 7 column table with column headings "User Id", "Last Name",
    "First Name", "Department", "Phone Number", "Hiragana Last Name", "Hiragana First Name".
    """

    _ELEMENTS = (
        E(
            "trunk_group_user_table",
            "trunkGroupUserTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* trunkGroupUserTable  *Tabular*
    trunk_group_user_table = Field(
        type=list,
        required=True,
    )


class GroupTrunkGroupGetInstanceUserListResponse14sp4(OCIResponse):
    """
    Response to ``GroupTrunkGroupGetInstanceUserListRequest14sp4()``.
    The response contains a 9 column table with column headings "User Id", "Last Name",
    "First Name", "Department", "Phone Number", "Hiragana Last Name", "Hiragana First Name",
    "Extension", "Email Address".
    """

    _ELEMENTS = (
        E(
            "trunk_group_user_table",
            "trunkGroupUserTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* trunkGroupUserTable  *Tabular*
    trunk_group_user_table = Field(
        type=list,
        required=True,
    )


class GroupTrunkGroupSecurityClassificationGetResponse(OCIResponse):
    """
    Response to the ``GroupTrunkGroupSecurityClassificationGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "default_security_classification",
            "defaultSecurityClassification",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* defaultSecurityClassification
    default_security_classification = Field(
        type=str,
        required=False,
    )


class GroupTrunkGroupUserCreationTaskGetListResponse(OCIResponse):
    """
    Response to ``GroupTrunkGroupUserCreationTaskGetListRequest()``.
    Contains a table with a row for each user creation task and column headings :
    "Name", "Status", "Users Created", "Total Users To Create", "Error Count".
    """

    _ELEMENTS = (
        E(
            "task_table",
            "taskTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* taskTable  *Tabular*
    task_table = Field(
        type=list,
        required=True,
    )


class GroupTrunkGroupUserCreationTaskGetListResponse14sp4(OCIResponse):
    """
    Response to ``GroupTrunkGroupUserCreationTaskGetListRequest14sp4()``.
    Contains a table with a row for each user creation task and column headings :
    "Name", "Status", "Users Created", "Total Users To Create", "Error Count".
    """

    _ELEMENTS = (
        E(
            "task_table",
            "taskTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* taskTable  *Tabular*
    task_table = Field(
        type=list,
        required=True,
    )


class GroupTrunkGroupUserCreationTaskGetResponse(OCIResponse):
    """
    Response to a ``GroupTrunkGroupUserCreationTaskGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "user_id_format",
            "userIdFormat",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_id_domain",
            "userIdDomain",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "populate_extension",
            "populateExtension",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "line_port_format",
            "linePortFormat",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "line_port_domain",
            "linePortDomain",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "populate_contact",
            "populateContact",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "contact_format",
            "contactFormat",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "contact_domain",
            "contactDomain",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "users_created",
            "usersCreated",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "total_users_to_create",
            "totalUsersToCreate",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "error_count",
            "errorCount",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_pack_name",
            "servicePackName",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "user_service_name",
            "userServiceName",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "status",
            "status",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_creation_mode",
            "userCreationMode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "task_summary",
            "taskSummary",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userIdFormat
    user_id_format = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userIdDomain
    user_id_domain = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* populateExtension
    populate_extension = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* linePortFormat
    line_port_format = Field(
        type=str,
        required=True,
    )
    #: str: *Required* linePortDomain
    line_port_domain = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* populateContact
    populate_contact = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* contactFormat
    contact_format = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* contactDomain
    contact_domain = Field(
        type=str,
        required=False,
    )
    #: int: *Required* usersCreated
    users_created = Field(
        type=int,
        required=True,
    )
    #: int: *Required* totalUsersToCreate
    total_users_to_create = Field(
        type=int,
        required=True,
    )
    #: int: *Required* errorCount
    error_count = Field(
        type=int,
        required=True,
    )
    #: list(str): *Optional* servicePackName  *Array*
    service_pack_name = Field(
        type=list,
        required=False,
    )
    #: list(str): *Optional* userServiceName  *Array*
    user_service_name = Field(
        type=list,
        required=False,
    )
    #: str: *Required* status
    status = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userCreationMode
    user_creation_mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* taskSummary
    task_summary = Field(
        type=str,
        required=True,
    )


class GroupTrunkGroupUserCreationTaskGetResponse14sp4(OCIResponse):
    """
    Response to a ``GroupTrunkGroupUserCreationTaskGetRequest14sp4()``.
    """

    _ELEMENTS = (
        E(
            "user_id_format",
            "userIdFormat",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_id_domain",
            "userIdDomain",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "populate_extension",
            "populateExtension",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "line_port_format",
            "linePortFormat",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "line_port_domain",
            "linePortDomain",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "populate_contact",
            "populateContact",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "contact_format",
            "contactFormat",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "contact_domain",
            "contactDomain",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "users_created",
            "usersCreated",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "total_users_to_create",
            "totalUsersToCreate",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "error_count",
            "errorCount",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_pack_name",
            "servicePackName",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "user_service_name",
            "userServiceName",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "status",
            "status",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_creation_mode",
            "userCreationMode",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "task_summary",
            "taskSummary",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "report_file_key",
            "reportFileKey",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* userIdFormat
    user_id_format = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userIdDomain
    user_id_domain = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* populateExtension
    populate_extension = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* linePortFormat
    line_port_format = Field(
        type=str,
        required=True,
    )
    #: str: *Required* linePortDomain
    line_port_domain = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* populateContact
    populate_contact = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* contactFormat
    contact_format = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* contactDomain
    contact_domain = Field(
        type=str,
        required=False,
    )
    #: int: *Required* usersCreated
    users_created = Field(
        type=int,
        required=True,
    )
    #: int: *Required* totalUsersToCreate
    total_users_to_create = Field(
        type=int,
        required=True,
    )
    #: int: *Required* errorCount
    error_count = Field(
        type=int,
        required=True,
    )
    #: list(str): *Optional* servicePackName  *Array*
    service_pack_name = Field(
        type=list,
        required=False,
    )
    #: list(str): *Optional* userServiceName  *Array*
    user_service_name = Field(
        type=list,
        required=False,
    )
    #: str: *Required* status
    status = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userCreationMode
    user_creation_mode = Field(
        type=str,
        required=True,
    )
    #: str: *Required* taskSummary
    task_summary = Field(
        type=str,
        required=True,
    )
    #: str: *Required* reportFileKey
    report_file_key = Field(
        type=str,
        required=True,
    )


class GroupVirtualOnNetEnterpriseExtensionsGetUserListResponse(OCIResponse):
    """
    Response to ``GroupVirtualOnNetEnterpriseExtensionsGetUserListRequest()``.
    Contains a table with column headings: "Last Name",
    "First Name", "Phone Number", "Extension",
    "Virtual On-Net Call Type Name"
    in a row for each user.
    """

    _ELEMENTS = (
        E(
            "user_table",
            "userTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* userTable  *Tabular*
    user_table = Field(
        type=list,
        required=True,
    )


class GroupVirtualOnNetEnterpriseExtensionsGetUserResponse(OCIResponse):
    """
    Response to ``GroupVirtualOnNetEnterpriseExtensionsGetUserRequest()``.
    """

    _ELEMENTS = (
        E(
            "extension",
            "extension",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "first_name",
            "firstName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "last_name",
            "lastName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_first_name",
            "callingLineIdFirstName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_last_name",
            "callingLineIdLastName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "virtual_on_net_call_type_name",
            "virtualOnNetCallTypeName",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* extension
    extension = Field(
        type=str,
        required=True,
    )
    #: str: *Required* firstName
    first_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* lastName
    last_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdFirstName
    calling_line_id_first_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdLastName
    calling_line_id_last_name = Field(
        type=str,
        required=True,
    )
    #: str: *Required* virtualOnNetCallTypeName
    virtual_on_net_call_type_name = Field(
        type=str,
        required=True,
    )


class GroupVoiceMessagingGroupGetPasscodeRulesResponse(OCIResponse):
    """
    Response to ``GroupVoiceMessagingGroupGetPasscodeRulesRequest()``.
    Contains the group's voice portal passcode rules setting.
    Replaced By ``GroupPortalPasscodeRulesGetResponse()``
    """

    _ELEMENTS = (
        E(
            "use_rule_level",
            "useRuleLevel",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_repeated_digits",
            "disallowRepeatedDigits",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_user_number",
            "disallowUserNumber",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_reversed_user_number",
            "disallowReversedUserNumber",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_old_passcode",
            "disallowOldPasscode",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_reversed_old_passcode",
            "disallowReversedOldPasscode",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_code_length",
            "minCodeLength",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_code_length",
            "maxCodeLength",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "disable_login_after_max_failed_login_attempts",
            "disableLoginAfterMaxFailedLoginAttempts",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_failed_login_attempts",
            "maxFailedLoginAttempts",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "expire_password",
            "expirePassword",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "passcode_expires_days",
            "passcodeExpiresDays",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "send_login_disabled_notify_email",
            "sendLoginDisabledNotifyEmail",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "login_disabled_notify_email_address",
            "loginDisabledNotifyEmailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* useRuleLevel
    use_rule_level = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* disallowRepeatedDigits
    disallow_repeated_digits = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowUserNumber
    disallow_user_number = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowReversedUserNumber
    disallow_reversed_user_number = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowOldPasscode
    disallow_old_passcode = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowReversedOldPasscode
    disallow_reversed_old_passcode = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minCodeLength
    min_code_length = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxCodeLength
    max_code_length = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* disableLoginAfterMaxFailedLoginAttempts
    disable_login_after_max_failed_login_attempts = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* maxFailedLoginAttempts
    max_failed_login_attempts = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* expirePassword
    expire_password = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* passcodeExpiresDays
    passcode_expires_days = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(
        type=str,
        required=False,
    )


class GroupVoiceMessagingGroupGetResponse(OCIResponse):
    """
    Response to ``GroupVoiceMessagingGroupGetRequest()``.
    Contains the group's voice messaging settings.
    """

    _ELEMENTS = (
        E(
            "use_mail_server_setting",
            "useMailServerSetting",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "warn_caller_before_recording_voice_message",
            "warnCallerBeforeRecordingVoiceMessage",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_users_configuring_advanced_settings",
            "allowUsersConfiguringAdvancedSettings",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_compose_or_forward_message_to_entire_group",
            "allowComposeOrForwardMessageToEntireGroup",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "mail_server_net_address",
            "mailServerNetAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "mail_server_protocol",
            "mailServerProtocol",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "real_delete_for_imap",
            "realDeleteForImap",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_mailbox_length_minutes",
            "maxMailboxLengthMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "does_message_age",
            "doesMessageAge",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "hold_period_days",
            "holdPeriodDays",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* useMailServerSetting
    use_mail_server_setting = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* warnCallerBeforeRecordingVoiceMessage
    warn_caller_before_recording_voice_message = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowUsersConfiguringAdvancedSettings
    allow_users_configuring_advanced_settings = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowComposeOrForwardMessageToEntireGroup
    allow_compose_or_forward_message_to_entire_group = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* mailServerNetAddress
    mail_server_net_address = Field(
        type=str,
        required=False,
    )
    #: str: *Required* mailServerProtocol
    mail_server_protocol = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* realDeleteForImap
    real_delete_for_imap = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxMailboxLengthMinutes
    max_mailbox_length_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* doesMessageAge
    does_message_age = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* holdPeriodDays
    hold_period_days = Field(
        type=int,
        required=True,
    )


class GroupVoiceMessagingGroupGetVoicePortalBrandingResponse(OCIResponse):
    """
    Response to the ``GroupVoiceMessagingGroupGetVoicePortalBrandingRequest()``.
    Replaced By ``GroupVoiceMessagingGroupGetVoicePortalBrandingResponse16()``
    """

    _ELEMENTS = (
        E(
            "voice_portal_greeting_selection",
            "voicePortalGreetingSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "voice_portal_greeting_file_description",
            "voicePortalGreetingFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "voice_messaging_greeting_selection",
            "voiceMessagingGreetingSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "voice_messaging_greeting_file_description",
            "voiceMessagingGreetingFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* voicePortalGreetingSelection
    voice_portal_greeting_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* voicePortalGreetingFileDescription
    voice_portal_greeting_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Required* voiceMessagingGreetingSelection
    voice_messaging_greeting_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* voiceMessagingGreetingFileDescription
    voice_messaging_greeting_file_description = Field(
        type=str,
        required=False,
    )


class GroupVoiceMessagingGroupGetVoicePortalBrandingResponse16(OCIResponse):
    """
    Response to the ``GroupVoiceMessagingGroupGetVoicePortalBrandingRequest16()``.
    """

    _ELEMENTS = (
        E(
            "voice_portal_greeting_selection",
            "voicePortalGreetingSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "voice_portal_greeting_file_description",
            "voicePortalGreetingFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "voice_portal_greeting_media_type",
            "voicePortalGreetingMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "voice_messaging_greeting_selection",
            "voiceMessagingGreetingSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "voice_messaging_greeting_file_description",
            "voiceMessagingGreetingFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "voice_messaging_greeting_media_type",
            "voiceMessagingGreetingMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* voicePortalGreetingSelection
    voice_portal_greeting_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* voicePortalGreetingFileDescription
    voice_portal_greeting_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* voicePortalGreetingMediaType
    voice_portal_greeting_media_type = Field(
        type=str,
        required=False,
    )
    #: str: *Required* voiceMessagingGreetingSelection
    voice_messaging_greeting_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* voiceMessagingGreetingFileDescription
    voice_messaging_greeting_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* voiceMessagingGreetingMediaType
    voice_messaging_greeting_media_type = Field(
        type=str,
        required=False,
    )


class GroupVoiceXmlGetInstanceListResponse(OCIResponse):
    """
    Response to the ``GroupVoiceXmlGetInstanceListRequest()``.
    Contains a table with column headings:
    "Service User Id", "Name", "Phone Number", "Extension", "Department", "Is Active".
    The column values for "Is Active" can either be true, or false.
    """

    _ELEMENTS = (
        E(
            "voice_xml_table",
            "voiceXmlTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* voiceXmlTable  *Tabular*
    voice_xml_table = Field(
        type=list,
        required=True,
    )


class LoginResponse13mp10(OCIResponse):
    """
    ``LoginRequest13mp10()``/Response13mp10 is 2nd stage of the 2 stage OCI login process.
    """

    _ELEMENTS = (
        E(
            "login_type",
            "loginType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "locale",
            "locale",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "encoding",
            "encoding",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* loginType
    login_type = Field(
        type=str,
        required=True,
    )
    #: str: *Required* locale
    locale = Field(
        type=str,
        required=True,
    )
    #: str: *Required* encoding
    encoding = Field(
        type=str,
        required=True,
    )


class LoginResponse14sp4(OCIResponse):
    """
    ``LoginRequest14sp4()``/Response14sp4 is 2nd stage of the 2 stage OCI login process.
    """

    _ELEMENTS = (
        E(
            "login_type",
            "loginType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "locale",
            "locale",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "encoding",
            "encoding",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_id",
            "groupId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "is_enterprise",
            "isEnterprise",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "password_expires_days",
            "passwordExpiresDays",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "user_domain",
            "userDomain",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* loginType
    login_type = Field(
        type=str,
        required=True,
    )
    #: str: *Required* locale
    locale = Field(
        type=str,
        required=True,
    )
    #: str: *Required* encoding
    encoding = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* groupId
    group_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* isEnterprise
    is_enterprise = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* passwordExpiresDays
    password_expires_days = Field(
        type=int,
        required=False,
    )
    #: str: *Required* userDomain
    user_domain = Field(
        type=str,
        required=True,
    )


class PrimaryInfoGetResponse(OCIResponse):
    """
    Information about the primary server in the high-availablity cluster.
    For optimization, we only get the hostname and addresses for primary if they are
    explicitly requested or if the current server is not the primary.
    """

    _ELEMENTS = (
        E(
            "is_primary",
            "isPrimary",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "hostname_for_primary",
            "hostnameForPrimary",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "address_for_primary",
            "addressForPrimary",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "private_address_for_primary",
            "privateAddressForPrimary",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: bool: *Required* isPrimary
    is_primary = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* hostnameForPrimary
    hostname_for_primary = Field(
        type=str,
        required=False,
    )
    #: list(str): *Optional* addressForPrimary  *Array*
    address_for_primary = Field(
        type=list,
        required=False,
    )
    #: list(str): *Optional* privateAddressForPrimary  *Array*
    private_address_for_primary = Field(
        type=list,
        required=False,
    )


class PublicClusterGetFullyQualifiedDomainNameResponse(OCIResponse):
    """
    Response to ``PublicClusterGetFullyQualifiedDomainNameRequest()``.
    """

    _ELEMENTS = (
        E(
            "public_cluster_fqdn",
            "publicClusterFQDN",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* publicClusterFQDN
    public_cluster_fqdn = Field(
        type=str,
        required=False,
    )


class ServiceProviderAccessDeviceCustomTagGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderAccessDeviceCustomTagGetListRequest()``.
    Contains a table of custom configuration tags managed by the Device Management
    System on a per-device profile basis.
    The column headings are: "Tag Name", "Tag Value"
    """

    _ELEMENTS = (
        E(
            "device_custom_tags_table",
            "deviceCustomTagsTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* deviceCustomTagsTable  *Tabular*
    device_custom_tags_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderAccessDeviceFileGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderAccessDeviceFileGetListRequest()``.
    Contains a table of device files managed by the Device Management System on a
    per-device profile basis.
    The column headings are: "File Type", "File Format", "Is Authenticated".
    Replaced By ``ServiceProviderAccessDeviceFileGetListResponse14sp8()``
    """

    _ELEMENTS = (
        E(
            "device_files_table",
            "deviceFilesTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* deviceFilesTable  *Tabular*
    device_files_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderAccessDeviceFileGetListResponse14sp8(OCIResponse):
    """
    Response to ``ServiceProviderAccessDeviceFileGetListRequest14sp8()``.
    Contains a table of device files managed by the Device Management System on a
    per-device profile basis.
    The column headings are: "File Format", "Is Authenticated", "Access URL",
    "Repository URL", "Template URL", "Extended Capture".

    The following columns are only used in AS data mode:
    "Extended Capture"
    """

    _ELEMENTS = (
        E(
            "device_files_table",
            "deviceFilesTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* deviceFilesTable  *Tabular*
    device_files_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderAccessDeviceFileGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderAccessDeviceFileGetRequest()``.
    Replaced By ``ServiceProviderAccessDeviceFileGetResponse14sp8()``
    """

    _ELEMENTS = (
        E(
            "file_source",
            "fileSource",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "configuration_file_name",
            "configurationFileName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* fileSource
    file_source = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* configurationFileName
    configuration_file_name = Field(
        type=str,
        required=False,
    )


class ServiceProviderAccessDeviceFileGetResponse14sp8(OCIResponse):
    """
    Response to ``ServiceProviderAccessDeviceFileGetRequest14sp8()``.
    Replaced By ``ServiceProviderAccessDeviceFileGetResponse16sp1()``
    """

    _ELEMENTS = (
        E(
            "file_source",
            "fileSource",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "configuration_file_name",
            "configurationFileName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* fileSource
    file_source = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* configurationFileName
    configuration_file_name = Field(
        type=str,
        required=False,
    )


class ServiceProviderAccessDeviceFileGetResponse16sp1(OCIResponse):
    """
    Response to ``ServiceProviderAccessDeviceFileGetRequest16sp1()``.
    """

    _ELEMENTS = (
        E(
            "file_source",
            "fileSource",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "configuration_file_name",
            "configurationFileName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "access_url",
            "accessUrl",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "repository_url",
            "repositoryUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "template_url",
            "templateUrl",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* fileSource
    file_source = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* configurationFileName
    configuration_file_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* accessUrl
    access_url = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* repositoryUrl
    repository_url = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* templateUrl
    template_url = Field(
        type=str,
        required=False,
    )


class ServiceProviderAccessDeviceFileGetResponse20(OCIResponse):
    """
    Response to ``ServiceProviderAccessDeviceFileGetRequest20()``.
    """

    _ELEMENTS = (
        E(
            "file_source",
            "fileSource",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "configuration_file_name",
            "configurationFileName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "access_url",
            "accessUrl",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "repository_url",
            "repositoryUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "template_url",
            "templateUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "extended_capture_enabled",
            "extendedCaptureEnabled",
            bool,
            False,
            False,
            False,
            False,
        ),
        E(
            "extended_capture_url",
            "extendedCaptureURL",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* fileSource
    file_source = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* configurationFileName
    configuration_file_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* accessUrl
    access_url = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* repositoryUrl
    repository_url = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* templateUrl
    template_url = Field(
        type=str,
        required=False,
    )
    #: bool: *Optional* extendedCaptureEnabled
    extended_capture_enabled = Field(
        type=bool,
        required=False,
    )
    #: str: *Optional* extendedCaptureURL
    extended_capture_url = Field(
        type=str,
        required=False,
    )


class ServiceProviderAccessDeviceGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderAccessDeviceGetListRequest()``.
    Contains a table of devices configured in the service provider.
    The column headings are: "Device Name", "Device Type", "Available Ports",
    "Net Address", "MAC Address", "Status", and "Version".
    """

    _ELEMENTS = (
        E(
            "access_device_table",
            "accessDeviceTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* accessDeviceTable  *Tabular*
    access_device_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderAccessDeviceGetUserListResponse(OCIResponse):
    """
    Response to ``ServiceProviderAccessDeviceGetUserListRequest()``.
    The column headings for the deviceUserTable are: "Line/Port", "Last Name",
    "First Name", "Phone Number", "Group Id", "User Id",
    "User Type", "Endpoint Type", "Primary Line/Port", "Order", "Extension",
    "Department", "Email Address", "Private Identity".
    In IMS mode, the table will contain a row for each TEL-URI in the Phone Number column.
    In standalone mode, rows for the alternate numbers are not included.
    The User Type column contains one of the enumerated UserType values.
    The Endpoint Type column contains one of the enumerated EndpointType values.
    The Private Identity column is empty is AS mode.
    """

    _ELEMENTS = (
        E(
            "device_user_table",
            "deviceUserTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* deviceUserTable  *Tabular*
    device_user_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderAdminGetListResponse14(OCIResponse):
    """
    Response to ``ServiceProviderAdminGetListRequest14()``.
    Contains a 5 column table with column headings "Administrator ID",
    "Last Name", "First Name", "Administrator Type", "Language".
    """

    _ELEMENTS = (
        E(
            "service_provider_admin_table",
            "serviceProviderAdminTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* serviceProviderAdminTable  *Tabular*
    service_provider_admin_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderAdminGetPolicyResponse14(OCIResponse):
    """
    Response to ``ServiceProviderAdminGetPolicyRequest14()``.
    Contains the policy settings for the service provider administrator.
    The networkPolicyAccess is returned only for the enterprise administrator.
    """

    _ELEMENTS = (
        E(
            "profile_access",
            "profileAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_access",
            "groupAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_access",
            "userAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "admin_access",
            "adminAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_access",
            "departmentAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_device_access",
            "accessDeviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number_extension_access",
            "phoneNumberExtensionAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_access",
            "serviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_pack_access",
            "servicePackAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "web_branding_access",
            "webBrandingAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "network_policy_access",
            "networkPolicyAccess",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* profileAccess
    profile_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupAccess
    group_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userAccess
    user_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* adminAccess
    admin_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAccess
    department_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* serviceAccess
    service_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* servicePackAccess
    service_pack_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* webBrandingAccess
    web_branding_access = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* networkPolicyAccess
    network_policy_access = Field(
        type=str,
        required=False,
    )


class ServiceProviderAdminGetPolicyResponse16sp1(OCIResponse):
    """
    Response to ``ServiceProviderAdminGetPolicyRequest16sp1()``.
    Contains the policy settings for the service provider administrator.
    The networkPolicyAccess is returned only for the enterprise administrator.
    Replaced By ``ServiceProviderAdminGetPolicyResponse17()``
    """

    _ELEMENTS = (
        E(
            "profile_access",
            "profileAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_access",
            "groupAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_access",
            "userAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "admin_access",
            "adminAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_access",
            "departmentAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_device_access",
            "accessDeviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number_extension_access",
            "phoneNumberExtensionAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_access",
            "serviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_pack_access",
            "servicePackAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "session_admission_control_access",
            "sessionAdmissionControlAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "web_branding_access",
            "webBrandingAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "network_policy_access",
            "networkPolicyAccess",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* profileAccess
    profile_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupAccess
    group_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userAccess
    user_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* adminAccess
    admin_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAccess
    department_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* serviceAccess
    service_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* servicePackAccess
    service_pack_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* sessionAdmissionControlAccess
    session_admission_control_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* webBrandingAccess
    web_branding_access = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* networkPolicyAccess
    network_policy_access = Field(
        type=str,
        required=False,
    )


class ServiceProviderAdminGetPolicyResponse16sp2(OCIResponse):
    """
    Response to ``ServiceProviderAdminGetPolicyRequest16sp1()``.
    Response to ``ServiceProviderAdminGetPolicyRequest16sp2()``.
    Contains the policy settings for the service provider administrator.
    The networkPolicyAccess is returned only for the enterprise administrator.
    """

    _ELEMENTS = (
        E(
            "profile_access",
            "profileAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_access",
            "groupAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_access",
            "userAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "admin_access",
            "adminAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_access",
            "departmentAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_device_access",
            "accessDeviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number_extension_access",
            "phoneNumberExtensionAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_access",
            "serviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_pack_access",
            "servicePackAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "session_admission_control_access",
            "sessionAdmissionControlAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "web_branding_access",
            "webBrandingAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "network_policy_access",
            "networkPolicyAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "dialable_caller_id_access",
            "dialableCallerIDAccess",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* profileAccess
    profile_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupAccess
    group_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userAccess
    user_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* adminAccess
    admin_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAccess
    department_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* serviceAccess
    service_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* servicePackAccess
    service_pack_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* sessionAdmissionControlAccess
    session_admission_control_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* webBrandingAccess
    web_branding_access = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* networkPolicyAccess
    network_policy_access = Field(
        type=str,
        required=False,
    )
    #: str: *Required* dialableCallerIDAccess
    dialable_caller_id_access = Field(
        type=str,
        required=True,
    )


class ServiceProviderAdminGetPolicyResponse17(OCIResponse):
    """
    Response to ``ServiceProviderAdminGetPolicyRequest17()``.
    Contains the policy settings for the service provider administrator.
    The networkPolicyAccess is returned only for the enterprise administrator.
    """

    _ELEMENTS = (
        E(
            "profile_access",
            "profileAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_access",
            "groupAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_access",
            "userAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "admin_access",
            "adminAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_access",
            "departmentAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_device_access",
            "accessDeviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number_extension_access",
            "phoneNumberExtensionAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_number_access",
            "callingLineIdNumberAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_access",
            "serviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_pack_access",
            "servicePackAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "session_admission_control_access",
            "sessionAdmissionControlAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "web_branding_access",
            "webBrandingAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "office_zone_access",
            "officeZoneAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "network_policy_access",
            "networkPolicyAccess",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* profileAccess
    profile_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupAccess
    group_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userAccess
    user_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* adminAccess
    admin_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAccess
    department_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdNumberAccess
    calling_line_id_number_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* serviceAccess
    service_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* servicePackAccess
    service_pack_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* sessionAdmissionControlAccess
    session_admission_control_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* webBrandingAccess
    web_branding_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* officeZoneAccess
    office_zone_access = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* networkPolicyAccess
    network_policy_access = Field(
        type=str,
        required=False,
    )


class ServiceProviderAdminGetPolicyResponse17sp1(OCIResponse):
    """
    Response to ``ServiceProviderAdminGetPolicyRequest17sp1()``.
    Contains the policy settings for the service provider administrator.
    The networkPolicyAccess is returned only for the enterprise administrator.
    The following elements are only used in HSS data mode:
    communicationBarringAccess
    """

    _ELEMENTS = (
        E(
            "profile_access",
            "profileAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_access",
            "groupAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_access",
            "userAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "admin_access",
            "adminAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_access",
            "departmentAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_device_access",
            "accessDeviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number_extension_access",
            "phoneNumberExtensionAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_number_access",
            "callingLineIdNumberAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_access",
            "serviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_pack_access",
            "servicePackAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "session_admission_control_access",
            "sessionAdmissionControlAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "web_branding_access",
            "webBrandingAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "office_zone_access",
            "officeZoneAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "communication_barring_access",
            "communicationBarringAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "network_policy_access",
            "networkPolicyAccess",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Required* profileAccess
    profile_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupAccess
    group_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userAccess
    user_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* adminAccess
    admin_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAccess
    department_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdNumberAccess
    calling_line_id_number_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* serviceAccess
    service_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* servicePackAccess
    service_pack_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* sessionAdmissionControlAccess
    session_admission_control_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* webBrandingAccess
    web_branding_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* officeZoneAccess
    office_zone_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* communicationBarringAccess
    communication_barring_access = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* networkPolicyAccess
    network_policy_access = Field(
        type=str,
        required=False,
    )


class ServiceProviderAdminGetPolicyResponse17sp3(OCIResponse):
    """
    Response to ``ServiceProviderAdminGetPolicyRequest17sp3()``.
    Contains the policy settings for the service provider administrator.
    The networkPolicyAccess is returned only for the enterprise administrator.
    The following elements are only used in AS data mode:
    dialableCallerIDAccess
    The following elements are only used in HSS data mode:
    communicationBarringAccess
    """

    _ELEMENTS = (
        E(
            "profile_access",
            "profileAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_access",
            "groupAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_access",
            "userAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "admin_access",
            "adminAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_access",
            "departmentAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_device_access",
            "accessDeviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number_extension_access",
            "phoneNumberExtensionAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_number_access",
            "callingLineIdNumberAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_access",
            "serviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_pack_access",
            "servicePackAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "session_admission_control_access",
            "sessionAdmissionControlAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "web_branding_access",
            "webBrandingAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "office_zone_access",
            "officeZoneAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "communication_barring_access",
            "communicationBarringAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "network_policy_access",
            "networkPolicyAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "dialable_caller_id_access",
            "dialableCallerIDAccess",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* profileAccess
    profile_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupAccess
    group_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userAccess
    user_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* adminAccess
    admin_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAccess
    department_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdNumberAccess
    calling_line_id_number_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* serviceAccess
    service_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* servicePackAccess
    service_pack_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* sessionAdmissionControlAccess
    session_admission_control_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* webBrandingAccess
    web_branding_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* officeZoneAccess
    office_zone_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* communicationBarringAccess
    communication_barring_access = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* networkPolicyAccess
    network_policy_access = Field(
        type=str,
        required=False,
    )
    #: str: *Required* dialableCallerIDAccess
    dialable_caller_id_access = Field(
        type=str,
        required=True,
    )


class ServiceProviderAdminGetPolicyResponse18(OCIResponse):
    """
    Response to ``ServiceProviderAdminGetPolicyRequest18()``.
    Contains the policy settings for the service provider administrator.
    The networkPolicyAccess and numberActivationAccess are returned only for the
    enterprise administrator.
    The following elements are only used in AS data mode:
    dialableCallerIDAccess
    """

    _ELEMENTS = (
        E(
            "profile_access",
            "profileAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_access",
            "groupAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_access",
            "userAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "admin_access",
            "adminAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_access",
            "departmentAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_device_access",
            "accessDeviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number_extension_access",
            "phoneNumberExtensionAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_number_access",
            "callingLineIdNumberAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_access",
            "serviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_pack_access",
            "servicePackAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "session_admission_control_access",
            "sessionAdmissionControlAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "web_branding_access",
            "webBrandingAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "office_zone_access",
            "officeZoneAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "communication_barring_access",
            "communicationBarringAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "network_policy_access",
            "networkPolicyAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "number_activation_access",
            "numberActivationAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "dialable_caller_id_access",
            "dialableCallerIDAccess",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* profileAccess
    profile_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupAccess
    group_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userAccess
    user_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* adminAccess
    admin_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAccess
    department_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdNumberAccess
    calling_line_id_number_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* serviceAccess
    service_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* servicePackAccess
    service_pack_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* sessionAdmissionControlAccess
    session_admission_control_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* webBrandingAccess
    web_branding_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* officeZoneAccess
    office_zone_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* communicationBarringAccess
    communication_barring_access = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* networkPolicyAccess
    network_policy_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* numberActivationAccess
    number_activation_access = Field(
        type=str,
        required=False,
    )
    #: str: *Required* dialableCallerIDAccess
    dialable_caller_id_access = Field(
        type=str,
        required=True,
    )


class ServiceProviderAdminGetPolicyResponse20(OCIResponse):
    """
    Response to ``ServiceProviderAdminGetPolicyRequest20()``.
    Contains the policy settings for the service provider administrator.
    The networkPolicyAccess and numberActivationAccess are returned only for the
    enterprise administrator.
    The following elements are only used in AS data mode:
    dialableCallerIDAccess
    verifyTranslationAndRoutingAccess
    """

    _ELEMENTS = (
        E(
            "profile_access",
            "profileAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_access",
            "groupAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "user_access",
            "userAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "admin_access",
            "adminAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "department_access",
            "departmentAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "access_device_access",
            "accessDeviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "phone_number_extension_access",
            "phoneNumberExtensionAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "calling_line_id_number_access",
            "callingLineIdNumberAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_access",
            "serviceAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_pack_access",
            "servicePackAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "session_admission_control_access",
            "sessionAdmissionControlAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "web_branding_access",
            "webBrandingAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "office_zone_access",
            "officeZoneAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "communication_barring_access",
            "communicationBarringAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "network_policy_access",
            "networkPolicyAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "number_activation_access",
            "numberActivationAccess",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "dialable_caller_id_access",
            "dialableCallerIDAccess",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "verify_translation_and_routing_access",
            "verifyTranslationAndRoutingAccess",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* profileAccess
    profile_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupAccess
    group_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* userAccess
    user_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* adminAccess
    admin_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* departmentAccess
    department_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* accessDeviceAccess
    access_device_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* phoneNumberExtensionAccess
    phone_number_extension_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callingLineIdNumberAccess
    calling_line_id_number_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* serviceAccess
    service_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* servicePackAccess
    service_pack_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* sessionAdmissionControlAccess
    session_admission_control_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* webBrandingAccess
    web_branding_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* officeZoneAccess
    office_zone_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* communicationBarringAccess
    communication_barring_access = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* networkPolicyAccess
    network_policy_access = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* numberActivationAccess
    number_activation_access = Field(
        type=str,
        required=False,
    )
    #: str: *Required* dialableCallerIDAccess
    dialable_caller_id_access = Field(
        type=str,
        required=True,
    )
    #: str: *Required* verifyTranslationAndRoutingAccess
    verify_translation_and_routing_access = Field(
        type=str,
        required=True,
    )


class ServiceProviderAdminGetResponse14(OCIResponse):
    """
    Response to the ``ServiceProviderAdminGetRequest14()``.
    The response contains the service provider administrators profile information.
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "first_name",
            "firstName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "last_name",
            "lastName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "language",
            "language",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "administrator_type",
            "administratorType",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* firstName
    first_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* lastName
    last_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* language
    language = Field(
        type=str,
        required=True,
    )
    #: str: *Required* administratorType
    administrator_type = Field(
        type=str,
        required=True,
    )


class ServiceProviderAdviceOfChargeGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderAdviceOfChargeGetRequest()``.
    Contains a list of Advice of Charge service provider parameters.
    """

    _ELEMENTS = (
        E(
            "use_sp_level_ao_c_settings",
            "useSPLevelAoCSettings",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "delay_between_notification_seconds",
            "delayBetweenNotificationSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useSPLevelAoCSettings
    use_sp_level_ao_c_settings = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* delayBetweenNotificationSeconds
    delay_between_notification_seconds = Field(
        type=int,
        required=True,
    )


class ServiceProviderAnswerConfirmationGetResponse(OCIResponse):
    """
    Response to the ``ServiceProviderAnswerConfirmationGetRequest()``.
    Replaced By ``ServiceProviderAnswerConfirmationGetResponse16()``
    """

    _ELEMENTS = (
        E(
            "announcement_message_selection",
            "announcementMessageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "confirmation_message_audio_file_description",
            "confirmationMessageAudioFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "confirmation_timout_seconds",
            "confirmationTimoutSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* announcementMessageSelection
    announcement_message_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* confirmationMessageAudioFileDescription
    confirmation_message_audio_file_description = Field(
        type=str,
        required=False,
    )
    #: int: *Required* confirmationTimoutSeconds
    confirmation_timout_seconds = Field(
        type=int,
        required=True,
    )


class ServiceProviderAnswerConfirmationGetResponse16(OCIResponse):
    """
    Response to the ``ServiceProviderAnswerConfirmationGetRequest16()``.
    """

    _ELEMENTS = (
        E(
            "announcement_message_selection",
            "announcementMessageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "confirmation_message_audio_file_description",
            "confirmationMessageAudioFileDescription",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "confirmation_message_media_type",
            "confirmationMessageMediaType",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "confirmation_timout_seconds",
            "confirmationTimoutSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* announcementMessageSelection
    announcement_message_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* confirmationMessageAudioFileDescription
    confirmation_message_audio_file_description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* confirmationMessageMediaType
    confirmation_message_media_type = Field(
        type=str,
        required=False,
    )
    #: int: *Required* confirmationTimoutSeconds
    confirmation_timout_seconds = Field(
        type=int,
        required=True,
    )


class ServiceProviderApplicationServerSetGetResponse(OCIResponse):
    """
    Response to the ``ServiceProviderApplicationServerSetGetRequest()``.
    The response contains the service provider or enterprise's Application Server set
    information.
    """

    _ELEMENTS = (
        E(
            "application_server_set_name",
            "applicationServerSetName",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* applicationServerSetName
    application_server_set_name = Field(
        type=str,
        required=False,
    )


class ServiceProviderBroadWorksCommunicatorGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderBroadWorksCommunicatorGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "configuration_server_url",
            "configurationServerURL",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* configurationServerURL
    configuration_server_url = Field(
        type=str,
        required=False,
    )


class ServiceProviderBroadWorksMobilityGetResponse(OCIResponse):
    """
    The response to a ``ServiceProviderBroadWorksMobilityGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "use_setting_level",
            "useSettingLevel",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_location_services",
            "enableLocationServices",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_msrn_lookup",
            "enableMSRNLookup",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_mobile_state_checking",
            "enableMobileStateChecking",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "deny_call_originations",
            "denyCallOriginations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "deny_call_terminations",
            "denyCallTerminations",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enableLocationServices
    enable_location_services = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableMSRNLookup
    enable_msrn_lookup = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableMobileStateChecking
    enable_mobile_state_checking = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* denyCallOriginations
    deny_call_originations = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* denyCallTerminations
    deny_call_terminations = Field(
        type=bool,
        required=True,
    )


class ServiceProviderBroadWorksMobilityGetResponse19sp1(OCIResponse):
    """
    The response to a ``ServiceProviderBroadWorksMobilityGetRequest19sp1()``.
    """

    _ELEMENTS = (
        E(
            "use_setting_level",
            "useSettingLevel",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_location_services",
            "enableLocationServices",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_msrn_lookup",
            "enableMSRNLookup",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_mobile_state_checking",
            "enableMobileStateChecking",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "deny_call_originations",
            "denyCallOriginations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "deny_call_terminations",
            "denyCallTerminations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_announcement_suppression",
            "enableAnnouncementSuppression",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enableLocationServices
    enable_location_services = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableMSRNLookup
    enable_msrn_lookup = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableMobileStateChecking
    enable_mobile_state_checking = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* denyCallOriginations
    deny_call_originations = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* denyCallTerminations
    deny_call_terminations = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableAnnouncementSuppression
    enable_announcement_suppression = Field(
        type=bool,
        required=True,
    )


class ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListResponse(
    OCIResponse,
):
    """
    Response to ``ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberGetAvailableListRequest()``.
    Contains a list of available Mobile Subscriber Directory Numbers not yet assigned
    to any group.
    """

    _ELEMENTS = (
        E(
            "available_mobile_subscriber_directory_number",
            "availableMobileSubscriberDirectoryNumber",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* availableMobileSubscriberDirectoryNumber  *Array*
    available_mobile_subscriber_directory_number = Field(
        type=list,
        required=False,
    )


class ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberGetSummaryListResponse(
    OCIResponse,
):
    """
    Response to ``ServiceProviderBroadWorksMobilityMobileSubscriberDirectoryNumberGetSummaryListRequest()``.
    The column headings are "Phone Number", "Group Id" and "Mobile Network".
    """

    _ELEMENTS = (
        E(
            "mobile_subscriber_directory_numbers_summary_table",
            "mobileSubscriberDirectoryNumbersSummaryTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* mobileSubscriberDirectoryNumbersSummaryTable  *Tabular*
    mobile_subscriber_directory_numbers_summary_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderCallProcessingGetPolicyResponse14(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest14()``.
    """

    _ELEMENTS = (
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_setting_level",
            "useSettingLevel",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "conference_uri",
            "conferenceURI",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* conferenceURI
    conference_uri = Field(
        type=str,
        required=False,
    )


class ServiceProviderCallProcessingGetPolicyResponse14sp1(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest14sp1()``.
    """

    _ELEMENTS = (
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_setting_level",
            "useSettingLevel",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "conference_uri",
            "conferenceURI",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* conferenceURI
    conference_uri = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=True,
    )


class ServiceProviderCallProcessingGetPolicyResponse14sp4(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest14sp4()``.
    Replaced By : ``ServiceProviderCallProcessingGetPolicyResponse15()``
    """

    _ELEMENTS = (
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_external_calls_via_private_dialing_plan",
            "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_setting_level",
            "useSettingLevel",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "conference_uri",
            "conferenceURI",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
    override_clid_restriction_for_external_calls_via_private_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* conferenceURI
    conference_uri = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=True,
    )


class ServiceProviderCallProcessingGetPolicyResponse14sp7(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest14sp7()``.
    """

    _ELEMENTS = (
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_external_calls_via_private_dialing_plan",
            "overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_setting_level",
            "useSettingLevel",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "conference_uri",
            "conferenceURI",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "clid_policy",
            "clidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "emergency_clid_policy",
            "emergencyClidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* overrideCLIDRestrictionForExternalCallsViaPrivateDialingPlan
    override_clid_restriction_for_external_calls_via_private_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* conferenceURI
    conference_uri = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=True,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool,
        required=True,
    )


class ServiceProviderCallProcessingGetPolicyResponse15(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest15()``.
    """

    _ELEMENTS = (
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_setting_level",
            "useSettingLevel",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "conference_uri",
            "conferenceURI",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* conferenceURI
    conference_uri = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=True,
    )


class ServiceProviderCallProcessingGetPolicyResponse15sp2(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest15sp2()``.
    """

    _ELEMENTS = (
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_setting_level",
            "useSettingLevel",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "conference_uri",
            "conferenceURI",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "clid_policy",
            "clidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "emergency_clid_policy",
            "emergencyClidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* conferenceURI
    conference_uri = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=True,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool,
        required=True,
    )


class ServiceProviderCallProcessingGetPolicyResponse16(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest16()``.
    """

    _ELEMENTS = (
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_setting_level",
            "useSettingLevel",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "conference_uri",
            "conferenceURI",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "clid_policy",
            "clidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "emergency_clid_policy",
            "emergencyClidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* conferenceURI
    conference_uri = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=True,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool,
        required=True,
    )


class ServiceProviderCallProcessingGetPolicyResponse16sp2(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest16sp2()``.
    """

    _ELEMENTS = (
        E(
            "use_service_provider_dclid_setting",
            "useServiceProviderDCLIDSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_setting_level",
            "useSettingLevel",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "conference_uri",
            "conferenceURI",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "clid_policy",
            "clidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "emergency_clid_policy",
            "emergencyClidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_dialable_caller_id",
            "enableDialableCallerID",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useServiceProviderDCLIDSetting
    use_service_provider_dclid_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* conferenceURI
    conference_uri = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=True,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableDialableCallerID
    enable_dialable_caller_id = Field(
        type=bool,
        required=True,
    )


class ServiceProviderCallProcessingGetPolicyResponse17(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest17()``.
    """

    _ELEMENTS = (
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_setting_level",
            "useSettingLevel",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "conference_uri",
            "conferenceURI",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "clid_policy",
            "clidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "emergency_clid_policy",
            "emergencyClidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "block_calling_name_for_external_calls",
            "blockCallingNameForExternalCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* conferenceURI
    conference_uri = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=True,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(
        type=bool,
        required=True,
    )


class ServiceProviderCallProcessingGetPolicyResponse17sp3(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest17sp3()``.
    The following elements are only used in AS data mode:
    useServiceProviderDCLIDSetting
    enableDialableCallerID
    """

    _ELEMENTS = (
        E(
            "use_service_provider_dclid_setting",
            "useServiceProviderDCLIDSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_setting_level",
            "useSettingLevel",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "conference_uri",
            "conferenceURI",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "clid_policy",
            "clidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "emergency_clid_policy",
            "emergencyClidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "block_calling_name_for_external_calls",
            "blockCallingNameForExternalCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_dialable_caller_id",
            "enableDialableCallerID",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useServiceProviderDCLIDSetting
    use_service_provider_dclid_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* conferenceURI
    conference_uri = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=True,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableDialableCallerID
    enable_dialable_caller_id = Field(
        type=bool,
        required=True,
    )


class ServiceProviderCallProcessingGetPolicyResponse17sp4(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest17sp4()``.
    The following elements are only used in AS data mode:
    useServiceProviderDCLIDSetting
    enableDialableCallerID
    allowConfigurableCLIDForRedirectingIdentity
    """

    _ELEMENTS = (
        E(
            "use_service_provider_dclid_setting",
            "useServiceProviderDCLIDSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_setting_level",
            "useSettingLevel",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "conference_uri",
            "conferenceURI",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "clid_policy",
            "clidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "emergency_clid_policy",
            "emergencyClidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "block_calling_name_for_external_calls",
            "blockCallingNameForExternalCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_dialable_caller_id",
            "enableDialableCallerID",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useServiceProviderDCLIDSetting
    use_service_provider_dclid_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* conferenceURI
    conference_uri = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=True,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableDialableCallerID
    enable_dialable_caller_id = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool,
        required=True,
    )


class ServiceProviderCallProcessingGetPolicyResponse18sp1(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest18sp1()``.
    The following elements are only used in AS data mode:
    useServiceProviderDCLIDSetting
    enableDialableCallerID
    allowConfigurableCLIDForRedirectingIdentity
    enterpriseCallsCLIDPolicy
    groupCallsCLIDPolicy

    Replaced By ``ServiceProviderCallProcessingGetPolicyResponse19sp1()``
    """

    _ELEMENTS = (
        E(
            "use_service_provider_dclid_setting",
            "useServiceProviderDCLIDSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_setting_level",
            "useSettingLevel",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "conference_uri",
            "conferenceURI",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "clid_policy",
            "clidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "emergency_clid_policy",
            "emergencyClidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "block_calling_name_for_external_calls",
            "blockCallingNameForExternalCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_dialable_caller_id",
            "enableDialableCallerID",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enterprise_calls_clid_policy",
            "enterpriseCallsCLIDPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_calls_clid_policy",
            "groupCallsCLIDPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useServiceProviderDCLIDSetting
    use_service_provider_dclid_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* conferenceURI
    conference_uri = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=True,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableDialableCallerID
    enable_dialable_caller_id = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* enterpriseCallsCLIDPolicy
    enterprise_calls_clid_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupCallsCLIDPolicy
    group_calls_clid_policy = Field(
        type=str,
        required=True,
    )


class ServiceProviderCallProcessingGetPolicyResponse19sp1(OCIResponse):
    """
    Response to ``ServiceProviderCallProcessingGetPolicyRequest19sp1()``.
    The following elements are only used in AS data mode:
    useServiceProviderDCLIDSetting
    enableDialableCallerID
    allowConfigurableCLIDForRedirectingIdentity
    enterpriseCallsCLIDPolicy
    groupCallsCLIDPolicy
    """

    _ELEMENTS = (
        E(
            "use_service_provider_dclid_setting",
            "useServiceProviderDCLIDSetting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_calls",
            "useMaxSimultaneousCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_calls",
            "maxSimultaneousCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_simultaneous_video_calls",
            "useMaxSimultaneousVideoCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_simultaneous_video_calls",
            "maxSimultaneousVideoCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_answered_calls",
            "useMaxCallTimeForAnsweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_answered_calls_minutes",
            "maxCallTimeForAnsweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_call_time_for_unanswered_calls",
            "useMaxCallTimeForUnansweredCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_call_time_for_unanswered_calls_minutes",
            "maxCallTimeForUnansweredCallsMinutes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "media_policy_selection",
            "mediaPolicySelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "supported_media_set_name",
            "supportedMediaSetName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "network_usage_selection",
            "networkUsageSelection",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_group_calling_line_identity_restriction",
            "enforceGroupCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_private_dialing_plan",
            "allowEnterpriseGroupCallTypingForPrivateDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_enterprise_group_call_typing_for_public_dialing_plan",
            "allowEnterpriseGroupCallTypingForPublicDialingPlan",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "override_clid_restriction_for_private_call_category",
            "overrideCLIDRestrictionForPrivateCallCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_enterprise_clid_for_private_call_category",
            "useEnterpriseCLIDForPrivateCallCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_enterprise_extension_dialing",
            "enableEnterpriseExtensionDialing",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enforce_enterprise_calling_line_identity_restriction",
            "enforceEnterpriseCallingLineIdentityRestriction",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_setting_level",
            "useSettingLevel",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "conference_uri",
            "conferenceURI",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_max_concurrent_redirected_calls",
            "useMaxConcurrentRedirectedCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_redirected_calls",
            "maxConcurrentRedirectedCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_find_me_follow_me_depth",
            "useMaxFindMeFollowMeDepth",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_find_me_follow_me_depth",
            "maxFindMeFollowMeDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_redirection_depth",
            "maxRedirectionDepth",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "use_max_concurrent_find_me_follow_me_invocations",
            "useMaxConcurrentFindMeFollowMeInvocations",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_concurrent_find_me_follow_me_invocations",
            "maxConcurrentFindMeFollowMeInvocations",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "clid_policy",
            "clidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "emergency_clid_policy",
            "emergencyClidPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_alternate_numbers_for_redirecting_identity",
            "allowAlternateNumbersForRedirectingIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "block_calling_name_for_external_calls",
            "blockCallingNameForExternalCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_dialable_caller_id",
            "enableDialableCallerID",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_configurable_clid_for_redirecting_identity",
            "allowConfigurableCLIDForRedirectingIdentity",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enterprise_calls_clid_policy",
            "enterpriseCallsCLIDPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "group_calls_clid_policy",
            "groupCallsCLIDPolicy",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useServiceProviderDCLIDSetting
    use_service_provider_dclid_setting = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousCalls
    use_max_simultaneous_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousCalls
    max_simultaneous_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxSimultaneousVideoCalls
    use_max_simultaneous_video_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxSimultaneousVideoCalls
    max_simultaneous_video_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForAnsweredCalls
    use_max_call_time_for_answered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForAnsweredCallsMinutes
    max_call_time_for_answered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxCallTimeForUnansweredCalls
    use_max_call_time_for_unanswered_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxCallTimeForUnansweredCallsMinutes
    max_call_time_for_unanswered_calls_minutes = Field(
        type=int,
        required=True,
    )
    #: str: *Required* mediaPolicySelection
    media_policy_selection = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* supportedMediaSetName
    supported_media_set_name = Field(
        type=str,
        required=False,
    )
    #: str: *Required* networkUsageSelection
    network_usage_selection = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* enforceGroupCallingLineIdentityRestriction
    enforce_group_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPrivateDialingPlan
    allow_enterprise_group_call_typing_for_private_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowEnterpriseGroupCallTypingForPublicDialingPlan
    allow_enterprise_group_call_typing_for_public_dialing_plan = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* overrideCLIDRestrictionForPrivateCallCategory
    override_clid_restriction_for_private_call_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* useEnterpriseCLIDForPrivateCallCategory
    use_enterprise_clid_for_private_call_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableEnterpriseExtensionDialing
    enable_enterprise_extension_dialing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enforceEnterpriseCallingLineIdentityRestriction
    enforce_enterprise_calling_line_identity_restriction = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* useSettingLevel
    use_setting_level = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* conferenceURI
    conference_uri = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* useMaxConcurrentRedirectedCalls
    use_max_concurrent_redirected_calls = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentRedirectedCalls
    max_concurrent_redirected_calls = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxFindMeFollowMeDepth
    use_max_find_me_follow_me_depth = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxFindMeFollowMeDepth
    max_find_me_follow_me_depth = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxRedirectionDepth
    max_redirection_depth = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* useMaxConcurrentFindMeFollowMeInvocations
    use_max_concurrent_find_me_follow_me_invocations = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* maxConcurrentFindMeFollowMeInvocations
    max_concurrent_find_me_follow_me_invocations = Field(
        type=int,
        required=True,
    )
    #: str: *Required* clidPolicy
    clid_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Required* emergencyClidPolicy
    emergency_clid_policy = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* allowAlternateNumbersForRedirectingIdentity
    allow_alternate_numbers_for_redirecting_identity = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* blockCallingNameForExternalCalls
    block_calling_name_for_external_calls = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableDialableCallerID
    enable_dialable_caller_id = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowConfigurableCLIDForRedirectingIdentity
    allow_configurable_clid_for_redirecting_identity = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* enterpriseCallsCLIDPolicy
    enterprise_calls_clid_policy = Field(
        type=str,
        required=True,
    )
    #: str: *Required* groupCallsCLIDPolicy
    group_calls_clid_policy = Field(
        type=str,
        required=True,
    )


class ServiceProviderCommunicationBarringCriteriaGetAssignedListResponse(OCIResponse):
    """
    Response to ``ServiceProviderCommunicationBarringCriteriaGetAssignedListRequest()``.
    Contains a table of all Communication Barring Criteria assigned to the
    service provider. The column headings are: "Name" and "Description".
    """

    _ELEMENTS = (
        E(
            "criteria_table",
            "criteriaTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* criteriaTable  *Tabular*
    criteria_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderCommunicationBarringDigitPatternCriteriaGetListResponse(
    OCIResponse,
):
    """
    Response to the ``ServiceProviderCommunicationBarringDigitPatternCriteriaGetListRequest()``.
    The response contains a table of all Digit Pattern Criteria defined for the
    service provider. The column headings are "Name" and "Description"
    """

    _ELEMENTS = (
        E(
            "criteria_table",
            "criteriaTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* criteriaTable  *Tabular*
    criteria_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderCommunicationBarringDigitPatternCriteriaGetPatternListResponse(
    OCIResponse,
):
    """
    Response to the ``ServiceProviderCommunicationBarringDigitPatternCriteriaGetPatternListRequest()``.
    The response contains the Digit Pattern Criteria information.
    """

    _ELEMENTS = (
        E(
            "match_digit_pattern",
            "matchDigitPattern",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* matchDigitPattern  *Array*
    match_digit_pattern = Field(
        type=list,
        required=False,
    )


class ServiceProviderCommunicationBarringDigitPatternCriteriaGetResponse(OCIResponse):
    """
    Response to the ``ServiceProviderCommunicationBarringDigitPatternCriteriaGetRequest()``.
    The response contains the Digit Pattern Criteria information.
    """

    _ELEMENTS = (
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class ServiceProviderCommunicationBarringIncomingCriteriaGetAssignedListResponse(
    OCIResponse,
):
    """
    Response to ``ServiceProviderCommunicationBarringIncomingCriteriaGetAssignedListRequest()``.
    Contains a table of all Communication Barring Incoming Criteria assigned to the
    service provider. The column headings are: "Name" and "Description".
    """

    _ELEMENTS = (
        E(
            "criteria_table",
            "criteriaTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* criteriaTable  *Tabular*
    criteria_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderCommunicationBarringProfileGetAssignedGroupListResponse(
    OCIResponse,
):
    """
    Response to ``ServiceProviderCommunicationBarringProfileGetAssignedGroupListRequest()``.
    Contains a table of groups that have the Communication Barring Profile
    assigned. The column headings are: "Group Id" and "Group Name".
    """

    _ELEMENTS = (
        E(
            "group_table",
            "groupTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* groupTable  *Tabular*
    group_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderCommunicationBarringProfileGetCriteriaUsageListResponse(
    OCIResponse,
):
    """
    Response to ServiceProviderCommunicationBarring
    ``ProfileGetCriteriaUsageListRequest()``.  Contains a table of profiles that have
    the Communication Barring Criteria assigned. The column headings are: "Name" and
    "Description".
    """

    _ELEMENTS = (
        E(
            "profile_table",
            "profileTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* profileTable  *Tabular*
    profile_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderCommunicationBarringProfileGetDigitPatternCriteriaUsageListResponse(
    OCIResponse,
):
    """
    Response to the ``ServiceProviderCommunicationBarringProfileGetDigitPatternCriteriaUsageListRequest()``.
    The response contains a table of all Profiles that use the specific Digit Pattern
    Criteria. The column headings are "Name" and "Description"
    """

    _ELEMENTS = (
        E(
            "profile_table",
            "profileTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* profileTable  *Tabular*
    profile_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderCommunicationBarringProfileGetIncomingCriteriaUsageListResponse(
    OCIResponse,
):
    """
    Response to ``ServiceProviderCommunicationBarringProfileGetIncomingCriteriaUsageListRequest()``.
    Contains a table of profiles that have the Communication Barring Incoming
    Criteria assigned.
    The column headings are: "Name" and "Description".
    """

    _ELEMENTS = (
        E(
            "profile_table",
            "profileTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* profileTable  *Tabular*
    profile_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderCommunicationBarringProfileGetListResponse(OCIResponse):
    """
    Response to the ``ServiceProviderCommunicationBarringProfileGetListRequest()``.
    The response contains a table of all Communication Barring Profiles
    for the service provider. The column headings are "Default" , "Name" and "Description"
    """

    _ELEMENTS = (
        E(
            "profile_table",
            "profileTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* profileTable  *Tabular*
    profile_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderDeviceManagementEventGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderDeviceManagementEventGetListRequest()``.
    Contains a table with column headings: "Event Id", "Status", "Action",
    "Level", "Type", "Additional Info", "Is Local", "Completion %",
    "Pushed/ Same Hash/ Not Pushed", "Login Id", "Start Time",
    "Process Time".
    "Event Id" is a unique identifer for the event.
    "Status" can be: Pending, Queued, In Progress,
    Process On Other Host, Stale, Completed, Canceled.
    "Action" can be: Delete, Download, Rebuild, Reset, Upload.
    "Level" can be: Device, Device Type, Device Type Group, Group, User.
    "Type" can be: Automatic, Manual.
    "Additional Info" includes the affected device type, device or group.
    It depends on the level of the event:
    Device Profile: "Device Name" "Service Provider Id" "Group Id"
    Device Type: "Device Type Name"
    Device Type Group: "Service Provider Id" "Group Id" "Device Type Name"
    Group: "Service Provider Id" "Group Id"
    User: "User Id"
    "Is Local" is set to "yes" if the event is processed on the server
    who received the request, "no" otherwise meaning that the event is
    processed on another server.
    "Completion %" provides an estimate of the completion of the event.
    A percentage is given, the current number of completed expanded event,
    and the total number of expanded event.
    "Pushed/ Same Hash/ Not Pushed" gives the total number of files that
    were pushed, not pushed because of same hash, and not pushed when
    processing the event.
    "LoginId" is the user or admin id who triggered the event.
    "Start Time" is the date when the event was started.  The display
    shows the month, days, hours, and minutes (MM-dd hh:mm).
    "Process Time" is the time taken to process the event in hours,
    minutes, seconds, and milliseconds (hhhh:mm:ss.SSS).
    Each row represents an event sorted by priority of processing.  The
    first row in the table is an event that has an associated expanded
    event currently being processed or next in line to be processed.
    """

    _ELEMENTS = (
        E(
            "event_table",
            "eventTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* eventTable  *Tabular*
    event_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderDeviceProfileAuthenticationPasswordRulesGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderDeviceProfileAuthenticationPasswordRulesGetRequest()``.
    Contains the device profile authentication password rules for the service provider.
    """

    _ELEMENTS = (
        E(
            "use_service_provider_settings",
            "useServiceProviderSettings",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_authentication_name",
            "disallowAuthenticationName",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_old_password",
            "disallowOldPassword",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_reversed_old_password",
            "disallowReversedOldPassword",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "restrict_min_digits",
            "restrictMinDigits",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_digits",
            "minDigits",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "restrict_min_upper_case_letters",
            "restrictMinUpperCaseLetters",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_upper_case_letters",
            "minUpperCaseLetters",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "restrict_min_lower_case_letters",
            "restrictMinLowerCaseLetters",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_lower_case_letters",
            "minLowerCaseLetters",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_non_alphanumeric_characters",
            "minNonAlphanumericCharacters",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_length",
            "minLength",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "send_permanent_lockout_notification",
            "sendPermanentLockoutNotification",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "permanent_lockout_notify_email_address",
            "permanentLockoutNotifyEmailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "device_profile_authentication_lockout_type",
            "deviceProfileAuthenticationLockoutType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_profile_temporary_lockout_threshold",
            "deviceProfileTemporaryLockoutThreshold",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_profile_wait_algorithm",
            "deviceProfileWaitAlgorithm",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_profile_lockout_fixed_minutes",
            "deviceProfileLockoutFixedMinutes",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "device_profile_permanent_lockout_threshold",
            "deviceProfilePermanentLockoutThreshold",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useServiceProviderSettings
    use_service_provider_settings = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowAuthenticationName
    disallow_authentication_name = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowOldPassword
    disallow_old_password = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowReversedOldPassword
    disallow_reversed_old_password = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* restrictMinDigits
    restrict_min_digits = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minDigits
    min_digits = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* restrictMinUpperCaseLetters
    restrict_min_upper_case_letters = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minUpperCaseLetters
    min_upper_case_letters = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* restrictMinLowerCaseLetters
    restrict_min_lower_case_letters = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minLowerCaseLetters
    min_lower_case_letters = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* restrictMinNonAlphanumericCharacters
    restrict_min_non_alphanumeric_characters = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minNonAlphanumericCharacters
    min_non_alphanumeric_characters = Field(
        type=int,
        required=True,
    )
    #: int: *Required* minLength
    min_length = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* sendPermanentLockoutNotification
    send_permanent_lockout_notification = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* permanentLockoutNotifyEmailAddress
    permanent_lockout_notify_email_address = Field(
        type=str,
        required=False,
    )
    #: str: *Required* deviceProfileAuthenticationLockoutType
    device_profile_authentication_lockout_type = Field(
        type=str,
        required=True,
    )
    #: int: *Required* deviceProfileTemporaryLockoutThreshold
    device_profile_temporary_lockout_threshold = Field(
        type=int,
        required=True,
    )
    #: str: *Required* deviceProfileWaitAlgorithm
    device_profile_wait_algorithm = Field(
        type=str,
        required=True,
    )
    #: str: *Required* deviceProfileLockoutFixedMinutes
    device_profile_lockout_fixed_minutes = Field(
        type=str,
        required=True,
    )
    #: int: *Required* deviceProfilePermanentLockoutThreshold
    device_profile_permanent_lockout_threshold = Field(
        type=int,
        required=True,
    )


class ServiceProviderDialPlanPolicyGetAccessCodeListResponse(OCIResponse):
    """
    Response to ``ServiceProviderDialPlanPolicyGetAccessCodeListRequest()``.
    Contains a table with column headings: "Access Code",
    "Enable Secondary Dial Tone", "Description".
    """

    _ELEMENTS = (
        E(
            "access_code_table",
            "accessCodeTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* accessCodeTable  *Tabular*
    access_code_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderDialPlanPolicyGetAccessCodeResponse(OCIResponse):
    """
    Response to ``ServiceProviderDialPlanPolicyGetAccessCodeRequest()``
    """

    _ELEMENTS = (
        E(
            "include_code_for_network_translations_and_routing",
            "includeCodeForNetworkTranslationsAndRouting",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "include_code_for_screening_services",
            "includeCodeForScreeningServices",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_secondary_dial_tone",
            "enableSecondaryDialTone",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* includeCodeForNetworkTranslationsAndRouting
    include_code_for_network_translations_and_routing = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* includeCodeForScreeningServices
    include_code_for_screening_services = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableSecondaryDialTone
    enable_secondary_dial_tone = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )


class ServiceProviderDialPlanPolicyGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderDialPlanPolicyGetRequest()``

    Replaced By ``ServiceProviderDialPlanPolicyGetResponse17()``
    """

    _ELEMENTS = (
        E(
            "requires_access_code_for_public_calls",
            "requiresAccessCodeForPublicCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_e164_public_calls",
            "allowE164PublicCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "public_digit_map",
            "publicDigitMap",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "private_digit_map",
            "privateDigitMap",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* requiresAccessCodeForPublicCalls
    requires_access_code_for_public_calls = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowE164PublicCalls
    allow_e164_public_calls = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* publicDigitMap
    public_digit_map = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* privateDigitMap
    private_digit_map = Field(
        type=str,
        required=False,
    )


class ServiceProviderDialPlanPolicyGetResponse17(OCIResponse):
    """
    Response to ``ServiceProviderDialPlanPolicyGetRequest17()``
    """

    _ELEMENTS = (
        E(
            "requires_access_code_for_public_calls",
            "requiresAccessCodeForPublicCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_e164_public_calls",
            "allowE164PublicCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "prefer_e164_number_format_for_callback_services",
            "preferE164NumberFormatForCallbackServices",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "public_digit_map",
            "publicDigitMap",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "private_digit_map",
            "privateDigitMap",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* requiresAccessCodeForPublicCalls
    requires_access_code_for_public_calls = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* allowE164PublicCalls
    allow_e164_public_calls = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* preferE164NumberFormatForCallbackServices
    prefer_e164_number_format_for_callback_services = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* publicDigitMap
    public_digit_map = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* privateDigitMap
    private_digit_map = Field(
        type=str,
        required=False,
    )


class ServiceProviderDialableCallerIDCriteriaGetResponse(OCIResponse):
    """
    Response to the ``ServiceProviderDialableCallerIDCriteriaGetRequest()``.
    The response contains the Dialable Caller ID Criteria information.
    """

    _ELEMENTS = (
        E(
            "description",
            "description",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "prefix_digits",
            "prefixDigits",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "match_call_type",
            "matchCallType",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "match_alternate_call_indicator",
            "matchAlternateCallIndicator",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "match_local_category",
            "matchLocalCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "match_national_category",
            "matchNationalCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "match_interlata_category",
            "matchInterlataCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "match_intralata_category",
            "matchIntralataCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "match_international_category",
            "matchInternationalCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "match_private_category",
            "matchPrivateCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "match_emergency_category",
            "matchEmergencyCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "match_other_category",
            "matchOtherCategory",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Optional* description
    description = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* prefixDigits
    prefix_digits = Field(
        type=str,
        required=False,
    )
    #: list(str): *Optional* matchCallType  *Array*
    match_call_type = Field(
        type=list,
        required=False,
    )
    #: list(str): *Optional* matchAlternateCallIndicator  *Array*
    match_alternate_call_indicator = Field(
        type=list,
        required=False,
    )
    #: bool: *Required* matchLocalCategory
    match_local_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* matchNationalCategory
    match_national_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* matchInterlataCategory
    match_interlata_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* matchIntralataCategory
    match_intralata_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* matchInternationalCategory
    match_international_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* matchPrivateCategory
    match_private_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* matchEmergencyCategory
    match_emergency_category = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* matchOtherCategory
    match_other_category = Field(
        type=bool,
        required=True,
    )


class ServiceProviderDialableCallerIDGetResponse(OCIResponse):
    """
    Response to the ``ServiceProviderDialableCallerIDGetRequest()``.
    The criteria table?s column headings are ?Active?, "Name", "Description", ?Prefix
    Digits?, and ?Priority?.
    """

    _ELEMENTS = (
        E(
            "use_service_provider_criteria",
            "useServiceProviderCriteria",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "ns_screening_failure_policy",
            "nsScreeningFailurePolicy",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "criteria_table",
            "criteriaTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: bool: *Required* useServiceProviderCriteria
    use_service_provider_criteria = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* nsScreeningFailurePolicy
    ns_screening_failure_policy = Field(
        type=str,
        required=True,
    )
    #: list: *Required* criteriaTable  *Tabular*
    criteria_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderDigitCollectionGetResponse13mp4(OCIResponse):
    """
    Response to ``ServiceProviderDigitCollectionGetRequest13mp4()``.
    """

    _ELEMENTS = (
        E(
            "access_code",
            "accessCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "public_digit_map",
            "publicDigitMap",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "private_digit_map",
            "privateDigitMap",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* accessCode
    access_code = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* publicDigitMap
    public_digit_map = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* privateDigitMap
    private_digit_map = Field(
        type=str,
        required=False,
    )


class ServiceProviderDnGetAvailableListResponse(OCIResponse):
    """
    Response to ``ServiceProviderDnGetAvailableListRequest()``.
    Contains a list of available DNs not yet assigned to any group.
    """

    _ELEMENTS = (
        E(
            "available_dn",
            "availableDn",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* availableDn  *Array*
    available_dn = Field(
        type=list,
        required=False,
    )


class ServiceProviderDnGetSummaryListResponse(OCIResponse):
    """
    Response to ``ServiceProviderDnGetSummaryListRequest()``.
    The column headings are "Phone Numbers, "Group Id" and "Can Delete"
    """

    _ELEMENTS = (
        E(
            "dn_summary_table",
            "dnSummaryTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* dnSummaryTable  *Tabular*
    dn_summary_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderDomainGetAssignedGroupListResponse(OCIResponse):
    """
    Response to ``ServiceProviderDomainGetAssignedGroupListRequest()``.
    Contains a table with column headings: "Group Id", "Group Name"
    and a row for each group.
    """

    _ELEMENTS = (
        E(
            "group_table",
            "groupTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* groupTable  *Tabular*
    group_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderDomainGetAssignedListResponse(OCIResponse):
    """
    Contains a simple list of all service provider domain names.
    """

    _ELEMENTS = (
        E(
            "service_provider_default_domain",
            "serviceProviderDefaultDomain",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "domain",
            "domain",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: str: *Required* serviceProviderDefaultDomain
    service_provider_default_domain = Field(
        type=str,
        required=True,
    )
    #: list(str): *Optional* domain  *Array*
    domain = Field(
        type=list,
        required=False,
    )


class ServiceProviderEndpointGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderEndpointGetListRequest()``.
    The column headings for the endpointTable are:
    "Group Id", "Line/Port", "Last Name", "First Name",  "User Id", "User Type",
    "Phone Number", "Extension", "Device Type", "Device Name", "Net Address", "MAC
    Address", "Department", "Email Address".
    Possible values for User Type are "User", "CCBasic", "CCStandard", "CCPremium",
    "RP", "MOH", "MOHVideo".
    """

    _ELEMENTS = (
        E(
            "endpoint_table",
            "endpointTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* endpointTable  *Tabular*
    endpoint_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderEnhancedCallLogsGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderEnhancedCallLogsGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "max_logged_calls",
            "maxLoggedCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "call_expiration_days",
            "callExpirationDays",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: int: *Required* maxLoggedCalls
    max_logged_calls = Field(
        type=int,
        required=True,
    )
    #: int: *Required* callExpirationDays
    call_expiration_days = Field(
        type=int,
        required=True,
    )


class ServiceProviderEnhancedCallLogsGetResponse17sp4(OCIResponse):
    """
    Response to ``ServiceProviderEnhancedCallLogsGetRequest17sp4()``.
    """

    _ELEMENTS = (
        E(
            "max_logged_calls",
            "maxLoggedCalls",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "call_expiration_days",
            "callExpirationDays",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: int: *Required* maxLoggedCalls
    max_logged_calls = Field(
        type=int,
        required=True,
    )
    #: int: *Required* callExpirationDays
    call_expiration_days = Field(
        type=int,
        required=True,
    )


class ServiceProviderExternalCustomRingbackGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderExternalCustomRingbackGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "prefix_digits",
            "prefixDigits",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "server_net_address",
            "serverNetAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "server_port",
            "serverPort",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "timeout_seconds",
            "timeoutSeconds",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Optional* prefixDigits
    prefix_digits = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* serverNetAddress
    server_net_address = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* serverPort
    server_port = Field(
        type=int,
        required=False,
    )
    #: int: *Required* timeoutSeconds
    timeout_seconds = Field(
        type=int,
        required=True,
    )


class ServiceProviderFileRepositoryDeviceUserGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderFileRepositoryDeviceUserGetListRequest()``.
    Contains a table with column headings : "User Name","Allow Delete","Allow
    Get","Allow Put" in a row for each file repository service provider user.
    """

    _ELEMENTS = (
        E(
            "file_repository_user_table",
            "fileRepositoryUserTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* fileRepositoryUserTable  *Tabular*
    file_repository_user_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderGetDefaultResponse(OCIResponse):
    """
    Response to the ``ServiceProviderGetDefaultRequest()``. All values are default values for
    a service provider or enterprise's profile.
    """

    _ELEMENTS = (
        E(
            "is_enterprise",
            "isEnterprise",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "default_domain",
            "defaultDomain",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* isEnterprise
    is_enterprise = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* defaultDomain
    default_domain = Field(
        type=str,
        required=True,
    )


class ServiceProviderGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderGetListRequest()``.
    Contains a 3 column table with column headings 'Service Provider Id', 'Service
    Provider Name'
    and 'Is Enterprise' and a row for each service provider or enterprise.
    """

    _ELEMENTS = (
        E(
            "service_provider_table",
            "serviceProviderTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* serviceProviderTable  *Tabular*
    service_provider_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderGroupPagingTargetsCapacityGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderGroupPagingTargetsCapacityGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "maximum_target_users",
            "maximumTargetUsers",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: int: *Required* maximumTargetUsers
    maximum_target_users = Field(
        type=int,
        required=True,
    )


class ServiceProviderIMRNGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderIMRNGetListRequest()``.
    """

    _ELEMENTS = (
        E(
            "imrn",
            "imrn",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* imrn  *Array*
    imrn = Field(
        type=list,
        required=False,
    )


class ServiceProviderInCallServiceActivationGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderInCallServiceActivationGetRequest()``.

    Replaced By ``ServiceProviderInCallServiceActivationGetResponse17()``
    """

    _ELEMENTS = (
        E(
            "activation_digits",
            "activationDigits",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* activationDigits
    activation_digits = Field(
        type=str,
        required=True,
    )


class ServiceProviderInCallServiceActivationGetResponse17(OCIResponse):
    """
    Response to ``ServiceProviderInCallServiceActivationGetRequest17()``.
    """

    _ELEMENTS = (
        E(
            "flash_activation_digits",
            "flashActivationDigits",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "call_transfer_activation_digits",
            "callTransferActivationDigits",
            str,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* flashActivationDigits
    flash_activation_digits = Field(
        type=str,
        required=True,
    )
    #: str: *Required* callTransferActivationDigits
    call_transfer_activation_digits = Field(
        type=str,
        required=True,
    )


class ServiceProviderIntegratedIMPGetResponse(OCIResponse):
    """
    Response to the ``ServiceProviderIntegratedIMPGetRequest()``.
    The response contains the service provider Integrated IMP service attributes.

    Replaced By ``ServiceProviderIntegratedIMPGetResponse21()``
    """

    _ELEMENTS = (
        E(
            "use_system_service_domain",
            "useSystemServiceDomain",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_domain",
            "serviceDomain",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* useSystemServiceDomain
    use_system_service_domain = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* serviceDomain
    service_domain = Field(
        type=str,
        required=False,
    )


class ServiceProviderIntegratedIMPGetResponse21(OCIResponse):
    """
    Response to the ``ServiceProviderIntegratedIMPGetRequest21()``.
    The response contains the service provider Integrated IMP service attributes.
    """

    _ELEMENTS = (
        E(
            "use_system_service_domain",
            "useSystemServiceDomain",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "service_domain",
            "serviceDomain",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "service_port",
            "servicePort",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_system_messaging_server",
            "useSystemMessagingServer",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "provisioning_url",
            "provisioningUrl",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "provisioning_user_id",
            "provisioningUserId",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "bosh_url",
            "boshURL",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* useSystemServiceDomain
    use_system_service_domain = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* serviceDomain
    service_domain = Field(
        type=str,
        required=False,
    )
    #: int: *Optional* servicePort
    service_port = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* useSystemMessagingServer
    use_system_messaging_server = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* provisioningUrl
    provisioning_url = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* provisioningUserId
    provisioning_user_id = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* boshURL
    bosh_url = Field(
        type=str,
        required=False,
    )


class ServiceProviderLDAPIntegrationGetDirectoryResponse(OCIResponse):
    """
    Response to ``ServiceProviderLDAPIntegrationGetDirectoryRequest()``.
    """

    _ELEMENTS = (
        E(
            "server_net_address",
            "serverNetAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "server_port",
            "serverPort",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "search_base",
            "searchBase",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "use_ssl",
            "useSSL",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "require_authentication",
            "requireAuthentication",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "authenticated_dn",
            "authenticatedDN",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "authenticated_password",
            "authenticatedPassword",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "is_sort_enabled",
            "isSortEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "is_paged_result_enabled",
            "isPagedResultEnabled",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "search_filter",
            "searchFilter",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "include_search_attribute_in_search_filter",
            "includeSearchAttributeInSearchFilter",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "column1_attribute_name",
            "column1AttributeName",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "column2_attribute_name",
            "column2AttributeName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "column3_attribute_name",
            "column3AttributeName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "column4_attribute_name",
            "column4AttributeName",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "column1_label",
            "column1Label",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "column2_label",
            "column2Label",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "column3_label",
            "column3Label",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "column4_label",
            "column4Label",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "search_column",
            "searchColumn",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Optional* serverNetAddress
    server_net_address = Field(
        type=str,
        required=False,
    )
    #: int: *Required* serverPort
    server_port = Field(
        type=int,
        required=True,
    )
    #: str: *Optional* searchBase
    search_base = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* useSSL
    use_ssl = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* requireAuthentication
    require_authentication = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* authenticatedDN
    authenticated_dn = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* authenticatedPassword
    authenticated_password = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* isSortEnabled
    is_sort_enabled = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* isPagedResultEnabled
    is_paged_result_enabled = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* searchFilter
    search_filter = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* includeSearchAttributeInSearchFilter
    include_search_attribute_in_search_filter = Field(
        type=bool,
        required=True,
    )
    #: str: *Required* column1AttributeName
    column1_attribute_name = Field(
        type=str,
        required=True,
    )
    #: str: *Optional* column2AttributeName
    column2_attribute_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* column3AttributeName
    column3_attribute_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* column4AttributeName
    column4_attribute_name = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* column1Label
    column1_label = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* column2Label
    column2_label = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* column3Label
    column3_label = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* column4Label
    column4_label = Field(
        type=str,
        required=False,
    )
    #: int: *Required* searchColumn
    search_column = Field(
        type=int,
        required=True,
    )


class ServiceProviderLanguageGetAvailableListResponse(OCIResponse):
    """
    Response to ``ServiceProviderLanguageGetAvailableListRequest()``.
    The language table column headings are: "Language", "Locale" and "Encoding".
    """

    _ELEMENTS = (
        E(
            "default_language",
            "defaultLanguage",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "language_table",
            "languageTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: str: *Required* defaultLanguage
    default_language = Field(
        type=str,
        required=True,
    )
    #: list: *Required* languageTable  *Tabular*
    language_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderLanguageGetListResponse(OCIResponse):
    """
    Response to ``ServiceProviderLanguageGetListRequest()``.
    """

    _ELEMENTS = (
        E(
            "language",
            "language",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "default_language",
            "defaultLanguage",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: list(str): *Optional* language  *Array*
    language = Field(
        type=list,
        required=False,
    )
    #: str: *Optional* defaultLanguage
    default_language = Field(
        type=str,
        required=False,
    )


class ServiceProviderMWIDeliveryToMobileEndpointGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderMWIDeliveryToMobileEndpointGetRequest()``.

    The templateActivationTable contains the list of templates defined for the
    service provider.
    The column headings are "Enable", "Language", "Type".
    """

    _ELEMENTS = (
        E(
            "template_activation_table",
            "templateActivationTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* templateActivationTable  *Tabular*
    template_activation_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderMaliciousCallTraceGetResponse(OCIResponse):
    """
    Response to the ``ServiceProviderMaliciousCallTraceGetRequest()``.
    The response contains the service provider Malicious Call Trace
    settings.
    """

    _ELEMENTS = (
        E(
            "use_system_play_mct_warning_announcement",
            "useSystemPlayMCTWarningAnnouncement",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "play_mct_warning_announcement",
            "playMCTWarningAnnouncement",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useSystemPlayMCTWarningAnnouncement
    use_system_play_mct_warning_announcement = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* playMCTWarningAnnouncement
    play_mct_warning_announcement = Field(
        type=bool,
        required=True,
    )


class ServiceProviderNetworkClassOfServiceGetAssignedGroupListResponse(OCIResponse):
    """
    Response to ``ServiceProviderNetworkClassOfServiceGetAssignedGroupListRequest()``.
    Contains a table of groups that have the Network Class of Service
    assigned. The column headings are: "Group Id" and "Group Name".
    """

    _ELEMENTS = (
        E(
            "group_table",
            "groupTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* groupTable  *Tabular*
    group_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderNetworkClassOfServiceGetAssignedListResponse(OCIResponse):
    """
    Response to ``ServiceProviderNetworkClassOfServiceGetAssignedListRequest()``.
    Contains a table of all Network Classes of Service assigned to the
    service provider. The column headings are: "Name", "Description" and "Default".
    """

    _ELEMENTS = (
        E(
            "network_class_of_service_table",
            "networkClassOfServiceTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* networkClassOfServiceTable  *Tabular*
    network_class_of_service_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderNumberPortabilityQueryGetResponse(OCIResponse):
    """
    Response to the ``ServiceProviderNumberPortabilityQueryGetRequest()``.
    The response contains the service provider number portability query information.
    """

    _ELEMENTS = (
        E(
            "enable_number_portability_query_for_outgoing_calls",
            "enableNumberPortabilityQueryForOutgoingCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_number_portability_query_for_incoming_calls",
            "enableNumberPortabilityQueryForIncomingCalls",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "enable_number_portability_query_for_network_calls_only",
            "enableNumberPortabilityQueryForNetworkCallsOnly",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "digit_pattern",
            "digitPattern",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: bool: *Required* enableNumberPortabilityQueryForOutgoingCalls
    enable_number_portability_query_for_outgoing_calls = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableNumberPortabilityQueryForIncomingCalls
    enable_number_portability_query_for_incoming_calls = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* enableNumberPortabilityQueryForNetworkCallsOnly
    enable_number_portability_query_for_network_calls_only = Field(
        type=bool,
        required=True,
    )
    #: list(str): *Optional* digitPattern  *Array*
    digit_pattern = Field(
        type=list,
        required=False,
    )


class ServiceProviderOfficeZoneGetAssignedGroupListResponse(OCIResponse):
    """
    Response to ``ServiceProviderOfficeZoneGetAssignedGroupListRequest()``.  Contains
    a table of groups that have the Office Zone assigned. The column headings are:
    "Group Id" and "Group Name".
    """

    _ELEMENTS = (
        E(
            "group_table",
            "groupTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* groupTable  *Tabular*
    group_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderOfficeZoneGetAssignedListResponse(OCIResponse):
    """
    Response to ``ServiceProviderOfficeZoneGetAssignedListRequest()``.
    Contains a table of all Office Zones assigned to the
    service provider. The column headings are: "Name", "Description" and "Default".
    """

    _ELEMENTS = (
        E(
            "office_zone_table",
            "officeZoneTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* officeZoneTable  *Tabular*
    office_zone_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderPasswordRulesGetResponse13mp2(OCIResponse):
    """
    Response to ``ServiceProviderPasswordRulesGetRequest13mp2()``.
    Contains the group, department administrator and/or user password
    rules setting.
    Replaced By ``ServiceProviderPasswordRulesGetResponse16()``
    """

    _ELEMENTS = (
        E(
            "service_provider_id",
            "serviceProviderId",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "rules_apply_to",
            "rulesApplyTo",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_web_add_external_authentication_users",
            "allowWebAddExternalAuthenticationUsers",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_user_id",
            "disallowUserId",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_old_password",
            "disallowOldPassword",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_reversed_old_password",
            "disallowReversedOldPassword",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "restrict_min_digits",
            "restrictMinDigits",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_digits",
            "minDigits",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "restrict_min_upper_case_letters",
            "restrictMinUpperCaseLetters",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_upper_case_letters",
            "minUpperCaseLetters",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "restrict_min_lower_case_letters",
            "restrictMinLowerCaseLetters",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_lower_case_letters",
            "minLowerCaseLetters",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_non_alphanumeric_characters",
            "minNonAlphanumericCharacters",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_length",
            "minLength",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_failed_login_attempts",
            "maxFailedLoginAttempts",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "password_expires_days",
            "passwordExpiresDays",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "send_login_disabled_notify_email",
            "sendLoginDisabledNotifyEmail",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "login_disabled_notify_email_address",
            "loginDisabledNotifyEmailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "disallow_rules_modification",
            "disallowRulesModification",
            bool,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* serviceProviderId
    service_provider_id = Field(
        type=str,
        required=True,
    )
    #: str: *Required* rulesApplyTo
    rules_apply_to = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* allowWebAddExternalAuthenticationUsers
    allow_web_add_external_authentication_users = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowUserId
    disallow_user_id = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowOldPassword
    disallow_old_password = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowReversedOldPassword
    disallow_reversed_old_password = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* restrictMinDigits
    restrict_min_digits = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minDigits
    min_digits = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* restrictMinUpperCaseLetters
    restrict_min_upper_case_letters = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minUpperCaseLetters
    min_upper_case_letters = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* restrictMinLowerCaseLetters
    restrict_min_lower_case_letters = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minLowerCaseLetters
    min_lower_case_letters = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* restrictMinNonAlphanumericCharacters
    restrict_min_non_alphanumeric_characters = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minNonAlphanumericCharacters
    min_non_alphanumeric_characters = Field(
        type=int,
        required=True,
    )
    #: int: *Required* minLength
    min_length = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxFailedLoginAttempts
    max_failed_login_attempts = Field(
        type=int,
        required=True,
    )
    #: int: *Required* passwordExpiresDays
    password_expires_days = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* disallowRulesModification
    disallow_rules_modification = Field(
        type=bool,
        required=True,
    )


class ServiceProviderPasswordRulesGetResponse16(OCIResponse):
    """
    Response to ``ServiceProviderPasswordRulesGetRequest16()``.
    Contains the group, department administrator and/or user password
    rules setting.
    """

    _ELEMENTS = (
        E(
            "rules_apply_to",
            "rulesApplyTo",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "allow_web_add_external_authentication_users",
            "allowWebAddExternalAuthenticationUsers",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_user_id",
            "disallowUserId",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_old_password",
            "disallowOldPassword",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_reversed_old_password",
            "disallowReversedOldPassword",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "restrict_min_digits",
            "restrictMinDigits",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_digits",
            "minDigits",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "restrict_min_upper_case_letters",
            "restrictMinUpperCaseLetters",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_upper_case_letters",
            "minUpperCaseLetters",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "restrict_min_lower_case_letters",
            "restrictMinLowerCaseLetters",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_lower_case_letters",
            "minLowerCaseLetters",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_non_alphanumeric_characters",
            "minNonAlphanumericCharacters",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_length",
            "minLength",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_failed_login_attempts",
            "maxFailedLoginAttempts",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "password_expires_days",
            "passwordExpiresDays",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "send_login_disabled_notify_email",
            "sendLoginDisabledNotifyEmail",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "login_disabled_notify_email_address",
            "loginDisabledNotifyEmailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "disallow_rules_modification",
            "disallowRulesModification",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_previous_passwords",
            "disallowPreviousPasswords",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_of_previous_passwords",
            "numberOfPreviousPasswords",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: str: *Required* rulesApplyTo
    rules_apply_to = Field(
        type=str,
        required=True,
    )
    #: bool: *Required* allowWebAddExternalAuthenticationUsers
    allow_web_add_external_authentication_users = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowUserId
    disallow_user_id = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowOldPassword
    disallow_old_password = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowReversedOldPassword
    disallow_reversed_old_password = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* restrictMinDigits
    restrict_min_digits = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minDigits
    min_digits = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* restrictMinUpperCaseLetters
    restrict_min_upper_case_letters = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minUpperCaseLetters
    min_upper_case_letters = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* restrictMinLowerCaseLetters
    restrict_min_lower_case_letters = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minLowerCaseLetters
    min_lower_case_letters = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* restrictMinNonAlphanumericCharacters
    restrict_min_non_alphanumeric_characters = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minNonAlphanumericCharacters
    min_non_alphanumeric_characters = Field(
        type=int,
        required=True,
    )
    #: int: *Required* minLength
    min_length = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxFailedLoginAttempts
    max_failed_login_attempts = Field(
        type=int,
        required=True,
    )
    #: int: *Required* passwordExpiresDays
    password_expires_days = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(
        type=str,
        required=False,
    )
    #: bool: *Required* disallowRulesModification
    disallow_rules_modification = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowPreviousPasswords
    disallow_previous_passwords = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* numberOfPreviousPasswords
    number_of_previous_passwords = Field(
        type=int,
        required=True,
    )


class ServiceProviderPortalPasscodeRulesGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderPortalPasscodeRulesGetRequest()``.
    Contains the service provider's passcode rules setting.
    """

    _ELEMENTS = (
        E(
            "disallow_repeated_digits",
            "disallowRepeatedDigits",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_user_number",
            "disallowUserNumber",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_reversed_user_number",
            "disallowReversedUserNumber",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_old_passcode",
            "disallowOldPasscode",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_reversed_old_passcode",
            "disallowReversedOldPasscode",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_code_length",
            "minCodeLength",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_code_length",
            "maxCodeLength",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "disable_login_after_max_failed_login_attempts",
            "disableLoginAfterMaxFailedLoginAttempts",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_failed_login_attempts",
            "maxFailedLoginAttempts",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "expire_password",
            "expirePassword",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "passcode_expires_days",
            "passcodeExpiresDays",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "send_login_disabled_notify_email",
            "sendLoginDisabledNotifyEmail",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "login_disabled_notify_email_address",
            "loginDisabledNotifyEmailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* disallowRepeatedDigits
    disallow_repeated_digits = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowUserNumber
    disallow_user_number = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowReversedUserNumber
    disallow_reversed_user_number = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowOldPasscode
    disallow_old_passcode = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowReversedOldPasscode
    disallow_reversed_old_passcode = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minCodeLength
    min_code_length = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxCodeLength
    max_code_length = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* disableLoginAfterMaxFailedLoginAttempts
    disable_login_after_max_failed_login_attempts = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* maxFailedLoginAttempts
    max_failed_login_attempts = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* expirePassword
    expire_password = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* passcodeExpiresDays
    passcode_expires_days = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(
        type=str,
        required=False,
    )


class ServiceProviderPortalPasscodeRulesGetResponse19(OCIResponse):
    """
    Response to ``ServiceProviderPortalPasscodeRulesGetRequest19()``.
    Contains the service provider's passcode rules setting.

    The following elements are only used in AS data mode:
    numberOfRepeatedDigits
    disallowRepeatedPatterns
    disallowContiguousSequences
    numberOfAscendingDigits
    numberOfDescendingDigits
    numberOfPreviousPasscodes
    """

    _ELEMENTS = (
        E(
            "disallow_repeated_digits",
            "disallowRepeatedDigits",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_of_repeated_digits",
            "numberOfRepeatedDigits",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_repeated_patterns",
            "disallowRepeatedPatterns",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_contiguous_sequences",
            "disallowContiguousSequences",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_of_ascending_digits",
            "numberOfAscendingDigits",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_of_descending_digits",
            "numberOfDescendingDigits",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_user_number",
            "disallowUserNumber",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_reversed_user_number",
            "disallowReversedUserNumber",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_old_passcode",
            "disallowOldPasscode",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "number_of_previous_passcodes",
            "numberOfPreviousPasscodes",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_reversed_old_passcode",
            "disallowReversedOldPasscode",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_code_length",
            "minCodeLength",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_code_length",
            "maxCodeLength",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "disable_login_after_max_failed_login_attempts",
            "disableLoginAfterMaxFailedLoginAttempts",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "max_failed_login_attempts",
            "maxFailedLoginAttempts",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "expire_password",
            "expirePassword",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "passcode_expires_days",
            "passcodeExpiresDays",
            int,
            False,
            False,
            False,
            False,
        ),
        E(
            "send_login_disabled_notify_email",
            "sendLoginDisabledNotifyEmail",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "login_disabled_notify_email_address",
            "loginDisabledNotifyEmailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: bool: *Required* disallowRepeatedDigits
    disallow_repeated_digits = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* numberOfRepeatedDigits
    number_of_repeated_digits = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* disallowRepeatedPatterns
    disallow_repeated_patterns = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowContiguousSequences
    disallow_contiguous_sequences = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* numberOfAscendingDigits
    number_of_ascending_digits = Field(
        type=int,
        required=True,
    )
    #: int: *Required* numberOfDescendingDigits
    number_of_descending_digits = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* disallowUserNumber
    disallow_user_number = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowReversedUserNumber
    disallow_reversed_user_number = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowOldPasscode
    disallow_old_passcode = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* numberOfPreviousPasscodes
    number_of_previous_passcodes = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* disallowReversedOldPasscode
    disallow_reversed_old_passcode = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minCodeLength
    min_code_length = Field(
        type=int,
        required=True,
    )
    #: int: *Required* maxCodeLength
    max_code_length = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* disableLoginAfterMaxFailedLoginAttempts
    disable_login_after_max_failed_login_attempts = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* maxFailedLoginAttempts
    max_failed_login_attempts = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* expirePassword
    expire_password = Field(
        type=bool,
        required=True,
    )
    #: int: *Optional* passcodeExpiresDays
    passcode_expires_days = Field(
        type=int,
        required=False,
    )
    #: bool: *Required* sendLoginDisabledNotifyEmail
    send_login_disabled_notify_email = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* loginDisabledNotifyEmailAddress
    login_disabled_notify_email_address = Field(
        type=str,
        required=False,
    )


class ServiceProviderPreferredCarrierGetAvailableCountryCodeListResponse(OCIResponse):
    """
    Response to a ``ServiceProviderPreferredCarrierGetAvailableCountryCodeListRequest()``.
    Contains the default country code and the list of unused country codes for a
    service provider / enterprise.
    """

    _ELEMENTS = (
        E(
            "default_country_code",
            "defaultCountryCode",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "country_code",
            "countryCode",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: str: *Optional* defaultCountryCode
    default_country_code = Field(
        type=str,
        required=False,
    )
    #: list(str): *Optional* countryCode  *Array*
    country_code = Field(
        type=list,
        required=False,
    )


class ServiceProviderPreferredCarrierGetCarrierListResponse(OCIResponse):
    """
    Response to a ``ServiceProviderPreferredCarrierGetCarrierListRequest()``.
    Contains the lists of carriers for a specified country code for a service
    provider / enterprise.
    """

    _ELEMENTS = (
        E(
            "intra_lata_carrier",
            "intraLataCarrier",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "inter_lata_carrier",
            "interLataCarrier",
            str,
            False,
            False,
            True,
            False,
        ),
        E(
            "international_carrier",
            "internationalCarrier",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* intraLataCarrier  *Array*
    intra_lata_carrier = Field(
        type=list,
        required=False,
    )
    #: list(str): *Optional* interLataCarrier  *Array*
    inter_lata_carrier = Field(
        type=list,
        required=False,
    )
    #: list(str): *Optional* internationalCarrier  *Array*
    international_carrier = Field(
        type=list,
        required=False,
    )


class ServiceProviderPreferredCarrierGetListResponse(OCIResponse):
    """
    Response to a ``ServiceProviderPreferredCarrierGetListRequest()``. Contains a
    table with one row per carrier.
    The table columns are: "Country Code", "Intra-Lata PIC", "Inter-Lata PIC",
    "International PIC".
    """

    _ELEMENTS = (
        E(
            "service_provider_carrier_table",
            "serviceProviderCarrierTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* serviceProviderCarrierTable  *Tabular*
    service_provider_carrier_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderPreferredCarrierGetResponse(OCIResponse):
    """
    Response to a ``ServiceProviderPreferredCarrierGetRequest()``.
    Contains the currently configured carriers for a specified country code for a
    service provider / enterprise.
    """

    _ELEMENTS = (
        E(
            "intra_lata_carrier",
            "intraLataCarrier",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "inter_lata_carrier",
            "interLataCarrier",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "international_carrier",
            "internationalCarrier",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* intraLataCarrier
    intra_lata_carrier = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* interLataCarrier
    inter_lata_carrier = Field(
        type=str,
        required=False,
    )
    #: str: *Optional* internationalCarrier
    international_carrier = Field(
        type=str,
        required=False,
    )


class ServiceProviderRouteListEnterpriseTrunkNumberRangeGetAvailableListResponse(
    OCIResponse,
):
    """
    Response to ``ServiceProviderRouteListEnterpriseTrunkNumberRangeGetAvailableListRequest()``.
    Contains a list of available number ranges not yet assigned to any group.
    The column headings are "Number Range Start", "Number Range End" and "Is Active".
    """

    _ELEMENTS = (
        E(
            "available_number_range_table",
            "availableNumberRangeTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* availableNumberRangeTable  *Tabular*
    available_number_range_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderRouteListEnterpriseTrunkNumberRangeGetSummaryListResponse(
    OCIResponse,
):
    """
    Response to ``ServiceProviderRouteListEnterpriseTrunkNumberRangeGetSummaryListRequest()``.
    The column headings are "Number Range Start", "Number Range End", "Group Id" and
    "Is Active".
    """

    _ELEMENTS = (
        E(
            "number_range_summary_table",
            "numberRangeSummaryTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* numberRangeSummaryTable  *Tabular*
    number_range_summary_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderRoutePointExternalSystemGetAssignedGroupListResponse(OCIResponse):
    """
    Response to ``ServiceProviderRoutePointExternalSystemGetAssignedGroupListRequest()``.
    Contains a table with column headings: "Group Id", "Group Name"
    and a row for each group.
    """

    _ELEMENTS = (
        E(
            "group_table",
            "groupTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* groupTable  *Tabular*
    group_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderRoutePointExternalSystemGetAssignedListResponse(OCIResponse):
    """
    Response to the ``ServiceProviderRoutePointExternalSystemGetAssignedListRequest()``.
    Contains a table of all Route Point External Systems assigned to the
    service provider.  The column headings are: "Name" and "Description".
    """

    _ELEMENTS = (
        E(
            "external_system_table",
            "externalSystemTable",
            list,
            True,
            True,
            False,
            True,
        ),
    )
    #: list: *Required* externalSystemTable  *Tabular*
    external_system_table = Field(
        type=list,
        required=True,
    )


class ServiceProviderRoutingProfileGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderRoutingProfileGetRequest()``.
    """

    _ELEMENTS = (
        E(
            "routing_profile",
            "routingProfile",
            str,
            False,
            False,
            False,
            False,
        ),
    )
    #: str: *Optional* routingProfile
    routing_profile = Field(
        type=str,
        required=False,
    )


class ServiceProviderSIPAuthenticationPasswordRulesGetResponse(OCIResponse):
    """
    Response to ``ServiceProviderSIPAuthenticationPasswordRulesGetRequest()``.
    Contains the SIP authentication password rules for the service provider.
    """

    _ELEMENTS = (
        E(
            "use_service_provider_settings",
            "useServiceProviderSettings",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_authentication_name",
            "disallowAuthenticationName",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_old_password",
            "disallowOldPassword",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "disallow_reversed_old_password",
            "disallowReversedOldPassword",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "restrict_min_digits",
            "restrictMinDigits",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_digits",
            "minDigits",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "restrict_min_upper_case_letters",
            "restrictMinUpperCaseLetters",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_upper_case_letters",
            "minUpperCaseLetters",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "restrict_min_lower_case_letters",
            "restrictMinLowerCaseLetters",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_lower_case_letters",
            "minLowerCaseLetters",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "restrict_min_non_alphanumeric_characters",
            "restrictMinNonAlphanumericCharacters",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_non_alphanumeric_characters",
            "minNonAlphanumericCharacters",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "min_length",
            "minLength",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "send_permanent_lockout_notification",
            "sendPermanentLockoutNotification",
            bool,
            False,
            True,
            False,
            False,
        ),
        E(
            "permanent_lockout_notify_email_address",
            "permanentLockoutNotifyEmailAddress",
            str,
            False,
            False,
            False,
            False,
        ),
        E(
            "endpoint_authentication_lockout_type",
            "endpointAuthenticationLockoutType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "endpoint_temporary_lockout_threshold",
            "endpointTemporaryLockoutThreshold",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "endpoint_wait_algorithm",
            "endpointWaitAlgorithm",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "endpoint_lockout_fixed_minutes",
            "endpointLockoutFixedMinutes",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "endpoint_permanent_lockout_threshold",
            "endpointPermanentLockoutThreshold",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "trunk_group_temporary_lockout_threshold",
            "trunkGroupTemporaryLockoutThreshold",
            int,
            False,
            True,
            False,
            False,
        ),
        E(
            "trunk_group_authentication_lockout_type",
            "trunkGroupAuthenticationLockoutType",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "trunk_group_wait_algorithm",
            "trunkGroupWaitAlgorithm",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "trunk_group_lockout_fixed_minutes",
            "trunkGroupLockoutFixedMinutes",
            str,
            False,
            True,
            False,
            False,
        ),
        E(
            "trunk_group_permanent_lockout_threshold",
            "trunkGroupPermanentLockoutThreshold",
            int,
            False,
            True,
            False,
            False,
        ),
    )
    #: bool: *Required* useServiceProviderSettings
    use_service_provider_settings = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowAuthenticationName
    disallow_authentication_name = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowOldPassword
    disallow_old_password = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* disallowReversedOldPassword
    disallow_reversed_old_password = Field(
        type=bool,
        required=True,
    )
    #: bool: *Required* restrictMinDigits
    restrict_min_digits = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minDigits
    min_digits = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* restrictMinUpperCaseLetters
    restrict_min_upper_case_letters = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minUpperCaseLetters
    min_upper_case_letters = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* restrictMinLowerCaseLetters
    restrict_min_lower_case_letters = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minLowerCaseLetters
    min_lower_case_letters = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* restrictMinNonAlphanumericCharacters
    restrict_min_non_alphanumeric_characters = Field(
        type=bool,
        required=True,
    )
    #: int: *Required* minNonAlphanumericCharacters
    min_non_alphanumeric_characters = Field(
        type=int,
        required=True,
    )
    #: int: *Required* minLength
    min_length = Field(
        type=int,
        required=True,
    )
    #: bool: *Required* sendPermanentLockoutNotification
    send_permanent_lockout_notification = Field(
        type=bool,
        required=True,
    )
    #: str: *Optional* permanentLockoutNotifyEmailAddress
    permanent_lockout_notify_email_address = Field(
        type=str,
        required=False,
    )
    #: str: *Required* endpointAuthenticationLockoutType
    endpoint_authentication_lockout_type = Field(
        type=str,
        required=True,
    )
    #: int: *Required* endpointTemporaryLockoutThreshold
    endpoint_temporary_lockout_threshold = Field(
        type=int,
        required=True,
    )
    #: str: *Required* endpointWaitAlgorithm
    endpoint_wait_algorithm = Field(
        type=str,
        required=True,
    )
    #: str: *Required* endpointLockoutFixedMinutes
    endpoint_lockout_fixed_minutes = Field(
        type=str,
        required=True,
    )
    #: int: *Required* endpointPermanentLockoutThreshold
    endpoint_permanent_lockout_threshold = Field(
        type=int,
        required=True,
    )
    #: int: *Required* trunkGroupTemporaryLockoutThreshold
    trunk_group_temporary_lockout_threshold = Field(
        type=int,
        required=True,
    )
    #: str: *Required* trunkGroupAuthenticationLockoutType
    trunk_group_authentication_lockout_type = Field(
        type=str,
        required=True,
    )
    #: str: *Required* trunkGroupWaitAlgorithm
    trunk_group_wait_algorithm = Field(
        type=str,
        required=True,
    )
    #: str: *Required* trunkGroupLockoutFixedMinutes
    trunk_group_lockout_fixed_minutes = Field(
        type=str,
        required=True,
    )
    #: int: *Required* trunkGroupPermanentLockoutThreshold
    trunk_group_permanent_lockout_threshold = Field(
        type=int,
        required=True,
    )


class ServiceProviderScheduleGetEventListResponse(OCIResponse):
    """
    Response to ``ServiceProviderScheduleGetEventListRequest()``.
    The response contains a list of events.
    """

    _ELEMENTS = (
        E(
            "event_name",
            "eventName",
            str,
            False,
            False,
            True,
            False,
        ),
    )
    #: list(str): *Optional* eventName  *Array*
    event_name = Field(
        type=list,
        required=False,
    )


class ServiceProviderServiceGetAuthorizationListResponse(OCIResponse):
    """
    Response to ``ServiceProviderServiceGetAuthorizationListRequest()``.
    Contains two tables, one for the group services and one for the user services.
    The Group Service 