// Copyright (c) 2013 Pieroxy <pieroxy@pieroxy.net>
// This work is free. You can redistribute it and/or modify it
// under the terms of the WTFPL, Version 2
// For more information see LICENSE.txt or http://www.wtfpl.net/
//
// For more information, the home page:
// http://pieroxy.net/blog/pages/lz-string/testing.html
// https://github.com/pieroxy/lz-string/blob/master/libs/lz-string.js
//
// LZ-based compression algorithm, version 1.4.4

// From: https://github.com/muaz-khan/WebRTC-Experiment/blob/master/hark/hark.js
// original source code is taken from:
// https://github.com/SimpleWebRTC/hark
// copyright goes to &yet team
// edited by Muaz Khan for RTCMultiConnection.js

// From npm package: serialize-selection, MIT license

function _defineProperty(obj,key,value){return key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}function _typeof(obj){return(_typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj})(obj)}function _typeof(obj){return(_typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(obj){return typeof obj}:function(obj){return obj&&"function"==typeof Symbol&&obj.constructor===Symbol&&obj!==Symbol.prototype?"symbol":typeof obj})(obj)}function _defineProperty(obj,key,value){return key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}function _defineProperty(obj,key,value){return key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}var LZString=function(){function getBaseValue(alphabet,character){if(!baseReverseDic[alphabet]){baseReverseDic[alphabet]={};for(var i=0;i<alphabet.length;i++)baseReverseDic[alphabet][alphabet.charAt(i)]=i}return baseReverseDic[alphabet][character]}var f=String.fromCharCode,keyStrBase64="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=",keyStrUriSafe="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+-$",baseReverseDic={},LZString={compressToBase64:function(input){if(null==input)return"";var res=LZString._compress(input,6,function(a){return keyStrBase64.charAt(a)});switch(res.length%4){default:case 0:return res;case 1:return res+"===";case 2:return res+"==";case 3:return res+"="}},decompressFromBase64:function(input){return null==input?"":""==input?null:LZString._decompress(input.length,32,function(index){return getBaseValue(keyStrBase64,input.charAt(index))})},compressToUTF16:function(input){return null==input?"":LZString._compress(input,15,function(a){return f(a+32)})+" "},decompressFromUTF16:function(compressed){return null==compressed?"":""==compressed?null:LZString._decompress(compressed.length,16384,function(index){return compressed.charCodeAt(index)-32})},compressToUint8Array:function(uncompressed){for(var compressed=LZString.compress(uncompressed),buf=new Uint8Array(2*compressed.length),i=0,TotalLen=compressed.length;i<TotalLen;i++){var current_value=compressed.charCodeAt(i);buf[2*i]=current_value>>>8,buf[2*i+1]=current_value%256}return buf},decompressFromUint8Array:function(compressed){if(null===compressed||void 0===compressed)return LZString.decompress(compressed);for(var buf=new Array(compressed.length/2),i=0,TotalLen=buf.length;i<TotalLen;i++)buf[i]=256*compressed[2*i]+compressed[2*i+1];var result=[];return buf.forEach(function(c){result.push(f(c))}),LZString.decompress(result.join(""))},compressToEncodedURIComponent:function(input){return null==input?"":LZString._compress(input,6,function(a){return keyStrUriSafe.charAt(a)})},decompressFromEncodedURIComponent:function(input){return null==input?"":""==input?null:(input=input.replace(/ /g,"+"),LZString._decompress(input.length,32,function(index){return getBaseValue(keyStrUriSafe,input.charAt(index))}))},compress:function(uncompressed){return LZString._compress(uncompressed,16,function(a){return f(a)})},_compress:function(uncompressed,bitsPerChar,getCharFromInt){if(null==uncompressed)return"";var i,value,ii,context_dictionary={},context_dictionaryToCreate={},context_c="",context_wc="",context_w="",context_enlargeIn=2,context_dictSize=3,context_numBits=2,context_data=[],context_data_val=0,context_data_position=0;for(ii=0;ii<uncompressed.length;ii+=1)if(context_c=uncompressed.charAt(ii),Object.prototype.hasOwnProperty.call(context_dictionary,context_c)||(context_dictionary[context_c]=context_dictSize++,context_dictionaryToCreate[context_c]=!0),context_wc=context_w+context_c,Object.prototype.hasOwnProperty.call(context_dictionary,context_wc))context_w=context_wc;else{if(Object.prototype.hasOwnProperty.call(context_dictionaryToCreate,context_w)){if(context_w.charCodeAt(0)<256){for(i=0;i<context_numBits;i++)context_data_val<<=1,context_data_position==bitsPerChar-1?(context_data_position=0,context_data.push(getCharFromInt(context_data_val)),context_data_val=0):context_data_position++;for(value=context_w.charCodeAt(0),i=0;i<8;i++)context_data_val=context_data_val<<1|1&value,context_data_position==bitsPerChar-1?(context_data_position=0,context_data.push(getCharFromInt(context_data_val)),context_data_val=0):context_data_position++,value>>=1}else{for(value=1,i=0;i<context_numBits;i++)context_data_val=context_data_val<<1|value,context_data_position==bitsPerChar-1?(context_data_position=0,context_data.push(getCharFromInt(context_data_val)),context_data_val=0):context_data_position++,value=0;for(value=context_w.charCodeAt(0),i=0;i<16;i++)context_data_val=context_data_val<<1|1&value,context_data_position==bitsPerChar-1?(context_data_position=0,context_data.push(getCharFromInt(context_data_val)),context_data_val=0):context_data_position++,value>>=1}context_enlargeIn--,0==context_enlargeIn&&(context_enlargeIn=Math.pow(2,context_numBits),context_numBits++),delete context_dictionaryToCreate[context_w]}else for(value=context_dictionary[context_w],i=0;i<context_numBits;i++)context_data_val=context_data_val<<1|1&value,context_data_position==bitsPerChar-1?(context_data_position=0,context_data.push(getCharFromInt(context_data_val)),context_data_val=0):context_data_position++,value>>=1;context_enlargeIn--,0==context_enlargeIn&&(context_enlargeIn=Math.pow(2,context_numBits),context_numBits++),context_dictionary[context_wc]=context_dictSize++,context_w=String(context_c)}if(""!==context_w){if(Object.prototype.hasOwnProperty.call(context_dictionaryToCreate,context_w)){if(context_w.charCodeAt(0)<256){for(i=0;i<context_numBits;i++)context_data_val<<=1,context_data_position==bitsPerChar-1?(context_data_position=0,context_data.push(getCharFromInt(context_data_val)),context_data_val=0):context_data_position++;for(value=context_w.charCodeAt(0),i=0;i<8;i++)context_data_val=context_data_val<<1|1&value,context_data_position==bitsPerChar-1?(context_data_position=0,context_data.push(getCharFromInt(context_data_val)),context_data_val=0):context_data_position++,value>>=1}else{for(value=1,i=0;i<context_numBits;i++)context_data_val=context_data_val<<1|value,context_data_position==bitsPerChar-1?(context_data_position=0,context_data.push(getCharFromInt(context_data_val)),context_data_val=0):context_data_position++,value=0;for(value=context_w.charCodeAt(0),i=0;i<16;i++)context_data_val=context_data_val<<1|1&value,context_data_position==bitsPerChar-1?(context_data_position=0,context_data.push(getCharFromInt(context_data_val)),context_data_val=0):context_data_position++,value>>=1}context_enlargeIn--,0==context_enlargeIn&&(context_enlargeIn=Math.pow(2,context_numBits),context_numBits++),delete context_dictionaryToCreate[context_w]}else for(value=context_dictionary[context_w],i=0;i<context_numBits;i++)context_data_val=context_data_val<<1|1&value,context_data_position==bitsPerChar-1?(context_data_position=0,context_data.push(getCharFromInt(context_data_val)),context_data_val=0):context_data_position++,value>>=1;context_enlargeIn--,0==context_enlargeIn&&(context_enlargeIn=Math.pow(2,context_numBits),context_numBits++)}for(value=2,i=0;i<context_numBits;i++)context_data_val=context_data_val<<1|1&value,context_data_position==bitsPerChar-1?(context_data_position=0,context_data.push(getCharFromInt(context_data_val)),context_data_val=0):context_data_position++,value>>=1;for(;;){if(context_data_val<<=1,context_data_position==bitsPerChar-1){context_data.push(getCharFromInt(context_data_val));break}context_data_position++}return context_data.join("")},decompress:function(compressed){return null==compressed?"":""==compressed?null:LZString._decompress(compressed.length,32768,function(index){return compressed.charCodeAt(index)})},_decompress:function(length,resetValue,getNextValue){var i,w,bits,resb,maxpower,power,c,dictionary=[],enlargeIn=4,dictSize=4,numBits=3,entry="",result=[],data={val:getNextValue(0),position:resetValue,index:1};for(i=0;i<3;i+=1)dictionary[i]=i;for(bits=0,maxpower=Math.pow(2,2),power=1;power!=maxpower;)resb=data.val&data.position,data.position>>=1,0==data.position&&(data.position=resetValue,data.val=getNextValue(data.index++)),bits|=(resb>0?1:0)*power,power<<=1;switch(bits){case 0:for(bits=0,maxpower=Math.pow(2,8),power=1;power!=maxpower;)resb=data.val&data.position,data.position>>=1,0==data.position&&(data.position=resetValue,data.val=getNextValue(data.index++)),bits|=(resb>0?1:0)*power,power<<=1;c=f(bits);break;case 1:for(bits=0,maxpower=Math.pow(2,16),power=1;power!=maxpower;)resb=data.val&data.position,data.position>>=1,0==data.position&&(data.position=resetValue,data.val=getNextValue(data.index++)),bits|=(resb>0?1:0)*power,power<<=1;c=f(bits);break;case 2:return""}for(dictionary[3]=c,w=c,result.push(c);;){if(data.index>length)return"";for(bits=0,maxpower=Math.pow(2,numBits),power=1;power!=maxpower;)resb=data.val&data.position,data.position>>=1,0==data.position&&(data.position=resetValue,data.val=getNextValue(data.index++)),bits|=(resb>0?1:0)*power,power<<=1;switch(c=bits){case 0:for(bits=0,maxpower=Math.pow(2,8),power=1;power!=maxpower;)resb=data.val&data.position,data.position>>=1,0==data.position&&(data.position=resetValue,data.val=getNextValue(data.index++)),bits|=(resb>0?1:0)*power,power<<=1;dictionary[dictSize++]=f(bits),c=dictSize-1,enlargeIn--;break;case 1:for(bits=0,maxpower=Math.pow(2,16),power=1;power!=maxpower;)resb=data.val&data.position,data.position>>=1,0==data.position&&(data.position=resetValue,data.val=getNextValue(data.index++)),bits|=(resb>0?1:0)*power,power<<=1;dictionary[dictSize++]=f(bits),c=dictSize-1,enlargeIn--;break;case 2:return result.join("")}if(0==enlargeIn&&(enlargeIn=Math.pow(2,numBits),numBits++),dictionary[c])entry=dictionary[c];else{if(c!==dictSize)return null;entry=w+w.charAt(0)}result.push(entry),dictionary[dictSize++]=w+entry.charAt(0),enlargeIn--,w=entry,0==enlargeIn&&(enlargeIn=Math.pow(2,numBits),numBits++)}}};return LZString}();"function"==typeof define&&define.amd?define("js/LZString.js",[],function(){return LZString}):"undefined"!=typeof module&&null!=module?module.exports=LZString:"undefined"!=typeof angular&&null!=angular&&angular.module("LZString",[]).factory("LZString",function(){return LZString}),define("js/utils.js",["components/marked/lib/marked"],function(marked){var utils={cellMaps:{},saveNotebookCallbacks:[],saveDebounceTiming:1e3,cplusplusKernel11:"xeus-cling-cpp11",cplusplusKernel14:"xeus-cling-cpp14",cplusplusKernel17:"xeus-cling-cpp17",pythonKernel:"python3",rKernel:"ir",addCR:function(str){return str+"\n"},getNotebookDirectory:function(){var notebookPath,notebookPathParts,fullNotebookPath=Jupyter.notebook.notebook_path;return-1===fullNotebookPath.indexOf("/")?(notebookPath=fullNotebookPath,-1!==notebookPath.indexOf(".ipynb")&&(notebookPath=void 0)):(notebookPathParts=fullNotebookPath.split("/"),notebookPath=notebookPathParts.slice(0,notebookPathParts.length-1).join("/")),notebookPath},rerenderMarkdownCell:function(cell){setTimeout(function(){cell.unrender(),cell.render()},1)},generateUniqueId:function(){return"id_"+Math.random().toString(36).substr(2,7)},getNow:function(){return(new Date).getTime()},createPermanentStringFromFlag:function(flag){return flag?"permanent":"temporary"},getCodeCommentString:function(){var codeCommentString,currentKernelName=Jupyter.notebook.kernel.name;switch(currentKernelName){case utils.cplusplusKernel11:case utils.cplusplusKernel14:case utils.cplusplusKernel17:codeCommentString="//";break;case utils.pythonKernel:case utils.rKernel:codeCommentString="#"}return codeCommentString},getMetadataCellId:function(metadata){return metadata.graffitiCellId},setMetadataCellId:function(metadata,cellId){return metadata.graffitiCellId=cellId,cellId},parseRecordingFullId:function(recordingFullId){var parts=recordingFullId.split("_");return{recordingCellId:"id_"+parts[0],recordingKey:"id_"+parts[1]}},computeArrayAverage:function(array){for(var average=0,i=0;i<array.length;++i)average+=array[i];return average/=array.length},subtractCoords:function(c1,c2){var x1=void 0!==c1.x?c1.x:c1.left,y1=void 0!==c1.y?c1.y:c1.top;return{x:(void 0!==c2.x?c2.x:c2.left)-x1,y:(void 0!==c2.y?c2.y:c2.top)-y1}},refreshCodeMirrorSelection:function(cell){"code"===cell.cell_type&&cell.selected&&(cm=cell.code_mirror,selections=cm.listSelections(),cell.focus_cell(),cm.getInputField().focus(),cm.setSelections(selections))},refreshCodeMirrorSelections:function(){for(var cells=Jupyter.notebook.get_cells(),i=0;i<cells.length;++i)cell=cells[i],utils.refreshCodeMirrorSelection(cell)},clearSelectedCellOutput:function(){var selectedCell=Jupyter.notebook.get_selected_cell();void 0!==selectedCell&&selectedCell.clear_output()},composeGraffitiId:function(cellId,recordingKey,activeTakeId){var combinedIds=[cellId.replace("id_",""),recordingKey.replace("id_","")];return void 0!==activeTakeId&&combinedIds.push(activeTakeId.replace("id_","")),combinedIds.join("_")},assignCellIds:function(){for(var cell,cellId,cells=Jupyter.notebook.get_cells(),_i=0;_i<cells.length;++_i)cell=cells[_i],cellId=utils.generateUniqueId(),cell.metadata.hasOwnProperty("graffitiCellId")||utils.setMetadataCellId(cell.metadata,cellId)},assignCellGraffitiConfig:function(cell,graffitiConfig){cell.metadata.graffitiConfig=graffitiConfig},setCellGraffitiConfigEntry:function(cell,key,val){cell.metadata.hasOwnProperty("graffitiConfig")||(cell.metadata.graffitiConfig={}),cell.metadata.graffitiConfig[key]=val},getCellGraffitiConfig:function(cell){if(cell.metadata.hasOwnProperty("graffitiConfig"))return cell.metadata.graffitiConfig},getCellGraffitiConfigEntry:function(cell,key){if(cell.metadata.hasOwnProperty("graffitiConfig")&&cell.metadata.graffitiConfig.hasOwnProperty(key))return cell.metadata.graffitiConfig[key]},getNotebookGraffitiConfigEntry:function(key){if(Jupyter.notebook.metadata.hasOwnProperty("graffiti"))return Jupyter.notebook.metadata.graffiti[key]},setNotebookGraffitiConfigEntry:function(key,val){Jupyter.notebook.metadata.hasOwnProperty("graffiti")&&(Jupyter.notebook.metadata.graffiti[key]=val)},refreshCellMaps:function(){utils.cellMaps={cells:Jupyter.notebook.get_cells(),maps:{},location:{}};for(var cell,cellId,cellDOM,tagsRe,graffitiId,cellKeys=Object.keys(utils.cellMaps.cells),cellIndex=0;cellIndex<cellKeys.length;++cellIndex)if(cell=utils.cellMaps.cells[cellIndex],cellId=utils.getMetadataCellId(cell.metadata),utils.cellMaps.maps[cellId]=cellIndex,cell.hasOwnProperty("inner_cell")?cellDOM=$(cell.inner_cell).parents(".cell"):cell.hasOwnProperty("element")&&(cellDOM=$(cell.element)),void 0!==cellDOM&&cellDOM.attr({"graffiti-cell-id":utils.getMetadataCellId(cell.metadata)}),"markdown"===cell.cell_type){var contents=cell.get_text();tagsRe=utils.createGraffitiTagRegex();for(var match=void 0,idMatch=void 0;null!==(match=tagsRe.exec(contents));)idMatch=match[1].match(/graffiti-(id_.[^\-]+)-(id_[^\s]+)/),graffitiId=idMatch[1]+"_"+idMatch[2],utils.cellMaps.location[graffitiId]=cellId}},findCellIdByLocationMap:function(recordingCellId,recordingKey){var graffitiId=recordingCellId+"_"+recordingKey;if(void 0!==utils.cellMaps.location[graffitiId])return utils.cellMaps.location[graffitiId]},findCellIndexByCellId:function(cellId){if(void 0!==utils.cellMaps&&void 0!==utils.cellMaps.maps&&utils.cellMaps.maps.hasOwnProperty(cellId))return utils.cellMaps.maps[cellId]},findCellByCellId:function(cellId){var index=utils.findCellIndexByCellId(cellId);if(void 0!==index)return utils.cellMaps.cells[index]},findCellByCodeMirror:function(cm){var _iteratorNormalCompletion=!0,_didIteratorError=!1,_iteratorError=void 0;try{for(var _step,_iterator=utils.cellMaps.cells[Symbol.iterator]();!(_iteratorNormalCompletion=(_step=_iterator.next()).done);_iteratorNormalCompletion=!0){var _cell=_step.value;if(_cell.code_mirror===cm)return _cell}}catch(err){_didIteratorError=!0,_iteratorError=err}finally{try{_iteratorNormalCompletion||null==_iterator.return||_iterator.return()}finally{if(_didIteratorError)throw _iteratorError}}},findCellIndexByCodeMirror:function(cm){var _iteratorNormalCompletion2=!0,_didIteratorError2=!1,_iteratorError2=void 0;try{for(var _step2,_iterator2=utils.cellMaps.cells[Symbol.iterator]();!(_iteratorNormalCompletion2=(_step2=_iterator2.next()).done);_iteratorNormalCompletion2=!0){var _cell2=_step2.value;if(_cell2.code_mirror===cm){var cellId=utils.getMetadataCellId(_cell2.metadata);if(void 0!==cellId)return utils.findCellIndexByCellId(cellId)}}}catch(err){_didIteratorError2=!0,_iteratorError2=err}finally{try{_iteratorNormalCompletion2||null==_iterator2.return||_iterator2.return()}finally{if(_didIteratorError2)throw _iteratorError2}}},selectCellByCellId:function(cellId){var cellIndex=utils.findCellIndexByCellId(cellId);void 0!==cellIndex&&Jupyter.notebook.select(cellIndex)},extractRecordingCellId:function(selectedTokens){return void 0!==selectedTokens.tagCellId&&selectedTokens.tagCellId!==selectedTokens.recordingCellId?selectedTokens.tagCellId:selectedTokens.recordingCellId},getCellRects:function(cell){var cellElement=$(cell.element[0]),cellRect=cellElement[0].getBoundingClientRect(),innerCell=cellElement.find(".inner_cell")[0];return{cellRect:cellRect,innerCell:innerCell,innerCellRect:innerCell.getBoundingClientRect(),promptRect:cellElement.find(".prompt")[0].getBoundingClientRect()}},renderMarkdown:function(contents){var cleanedContents=contents.replace(/^\s*%%(.*)$/gm,"");return marked(cleanedContents).replace(/(href=".*")>/g,'$1 target="_blank">')},collectViewInfo:function(clientX,clientY,notebookPanelHeight,scrollDiff){var cellElement,cellElementJq,cellRect,outerCellRect,cellIndex,cellIndexStr,cell,innerCell,innerCellRect,innerCellRectRaw,prompt,pointerInsidePromptArea,lineNumbersVisible,cm,inputCells=Jupyter.notebook.get_cells(),selectedCell=Jupyter.notebook.get_selected_cell(),selectedCellId=utils.getMetadataCellId(selectedCell.metadata),promptBbox=void 0;for(cellIndexStr in inputCells)if(cellIndex=parseInt(cellIndexStr),cell=inputCells[cellIndex],cellElement=cell.element[0],cellElementJq=$(cellElement),cellRect=cellElement.getBoundingClientRect(),prompt=cellElementJq.find(".prompt"),pointerInsidePromptArea=!1,prompt.length>0&&prompt.is(":visible")&&(promptBbox=prompt[0].getBoundingClientRect(),pointerInsidePromptArea=clientX>=promptBbox.left&&clientX<promptBbox.right&&clientY>=promptBbox.top&&clientY<promptBbox.bottom),cellRect.top<=clientY&&clientY<=cellRect.bottom||0===cellIndex&&clientY<cellRect.top||cellIndex===inputCells.length-1&&cellRect.bottom<clientY){outerCellRect={top:cellRect.top,left:cellRect.left},innerCell=cellElementJq.find(".inner_cell")[0],innerCellRectRaw=innerCell.getBoundingClientRect(),innerCellRect={top:innerCellRectRaw.top,left:innerCellRectRaw.left,width:innerCellRectRaw.width,height:innerCellRectRaw.height},lineNumbersVisible=cell.code_mirror.options.lineNumbers,cellElementJq.position(),cm=cell.code_mirror;var innerScrollInfo=cm.getScrollInfo(),innerScroll={left:innerScrollInfo.left,top:innerScrollInfo.top};return{cellId:utils.getMetadataCellId(cell.metadata),cellIndex:cellIndex,innerCellRect:innerCellRect,innerScroll:innerScroll,lineNumbersVisible:lineNumbersVisible,outerCellRect:outerCellRect,inMarkdownCell:"markdown"===cell.cell_type,inPromptArea:pointerInsidePromptArea,promptWidth:void 0===promptBbox?0:promptBbox.width,selectedCellId:selectedCellId,notebookPanelHeight:notebookPanelHeight,scrollDiff:scrollDiff}}return{cellId:void 0,cellRectTop:void 0,cellRectBottom:void 0,relativePointerPosition:void 0}},getActiveCellId:function(){var activeCell=Jupyter.notebook.get_selected_cell();return utils.getMetadataCellId(activeCell.metadata)},getActiveCellLineNumber:function(){return Jupyter.notebook.get_selected_cell().code_mirror.listSelections()[0].anchor.line},queueSaveNotebookCallback:function(cb){utils.saveNotebookCallbacks.push(cb)},processSaveNotebookCallbacks:function(){for(;utils.saveNotebookCallbacks.length>0;)utils.saveNotebookCallbacks.shift()();console.log("Graffiti: Notebook saved successfully.")},saveNotebook:function(){Jupyter.notebook.save_notebook().then(function(){utils.processSaveNotebookCallbacks()}).catch(function(ex){console.error("Graffiti: saveNotebook caught exception:",ex)})},shrinkAllCMSelections:function(){for(var cell,cm,selections,inputCells=Jupyter.notebook.get_cells(),i=0;i<inputCells.length;++i)if(cell=inputCells[i],"code"===cell.cell_type&&(cm=cell.code_mirror,selections=cm.listSelections(),selections.length>0)){console.log("Graffiti: Clearing selections before: selections:",selections);for(var j=0;j<selections.length;++j)selections[j].head=$.extend({},selections[j].anchor);console.log("Graffiti: Clearing selections after: selections:",selections),cm.setSelections(selections)}},createGraffitiTagRegex:function(){return RegExp('<span class="graffiti-highlight (graffiti-[^"]+)">(.*?)</span>',"gm")},findSelectionTokens:function(recordingCell,tokenRanges,state){var range,startRange,endRange,recording,hasMovie,recordingKey,markdown,isIntersecting=!1,recordingCellId=utils.getMetadataCellId(recordingCell.metadata),recordingCellType=recordingCell.cell_type,cm=recordingCell.code_mirror,selections=cm.listSelections(),firstSelection=selections[0],anchorPos=cm.indexFromPos(firstSelection.anchor),headPos=cm.indexFromPos(firstSelection.head),startPos=Math.min(anchorPos,headPos),endPos=Math.max(anchorPos,headPos),minStartRange=1e9,noResults={isIntersecting:!1,noTokensPresent:!0},results=noResults;if("markdown"===recordingCellType){for(var match,tag,idMatch,contents=recordingCell.get_text(),tagsRe=utils.createGraffitiTagRegex(),tags=[];null!==(match=tagsRe.exec(contents));)idMatch=match[1].match(/graffiti-(id_.[^\-]+)-(id_[^\s]+)/),tags.push({fullMatch:match[0],recordingCellId:idMatch[1],recordingKey:idMatch[2],innerText:match[2],startRange:match.index,endRange:match.index+match[0].length});if(tags.length>0)for(var _i2=0,_tags=tags;_i2<_tags.length;_i2++)if(tag=_tags[_i2],startPos>=tag.startRange&&startPos<=tag.endRange||endPos>=tag.startRange&&endPos<=tag.endRange){isIntersecting=!0;break}if(isIntersecting)void 0!==(recording=state.getManifestSingleRecording(tag.recordingCellId,tag.recordingKey))&&(hasMovie=recording.hasMovie,results={isIntersecting:!0,noTokensPresent:!1,recordingCell:recordingCell,recordingCellId:recordingCellId,tagCellId:tag.recordingCellId,recordingKey:tag.recordingKey,hasMovie:hasMovie,allTokensString:tag.innerText,markdown:tag.innerText,range:{start:tag.startRange,end:tag.endRange}});else if(endPos>startPos+1){for(var skipped=!1,checkChar=contents[startPos],skipChars="#_*";-1!==skipChars.indexOf(checkChar)&&startPos<endPos;)skipped=!0,startPos++,checkChar=contents[startPos];for(skipped&&" "===contents[startPos]&&++startPos,startPos>0&&"`"===contents[startPos-1]&&startPos--,endPos<contents.length-1&&"`"===contents[endPos+1]&&endPos++;10===contents[endPos-1].charCodeAt(0)&&--endPos!==startPos+2;);results={isIntersecting:!1,noTokensPresent:!1,range:{start:startPos,end:endPos},allTokensString:cm.getSelection()}}}else if("code"===recordingCellType){if(void 0!==tokenRanges[recordingCellId])for(var tokenRangesThisCell=tokenRanges[recordingCellId],_i3=0,_Object$keys=Object.keys(tokenRangesThisCell);_i3<_Object$keys.length;_i3++)recordingKey=_Object$keys[_i3],range=tokenRangesThisCell[recordingKey],startRange=cm.indexFromPos(range.start),endRange=cm.indexFromPos(range.end),(startPos<=startRange&&endPos>=endRange||startPos>=startRange&&startPos<endRange||endPos>startRange&&endPos<=endRange)&&startRange<minStartRange&&(minStartRange=startRange,(recording=state.getManifestSingleRecording(recordingCellId,recordingKey))&&(markdown=recording.markdown,hasMovie=recording.hasMovie,isIntersecting=!0,results={isIntersecting:!0,noTokensPresent:!1,recordingCell:recordingCell,recordingCellId:recordingCellId,recordingKey:recordingKey,markdown:markdown,hasMovie:hasMovie,range:{start:startRange,end:endRange}}));if(!isIntersecting){var startCheck,endCheck,token,startToken,endToken,lastToken,startTokenIndex,startTokenStringTrimmed,allTokens=utils.collectCMTokens(cm),tokenCount=0,tokensString="";if(0===allTokens.length)results=noResults;else if(token=allTokens[allTokens.length-1],endCheck=cm.indexFromPos({line:token.line,ch:token.end}),startPos>endCheck)results=noResults;else{for(var i=0;i<allTokens.length;++i)if(lastToken=token,token=allTokens[i],startCheck=cm.indexFromPos({line:token.line,ch:token.start}),endCheck=cm.indexFromPos({line:token.line,ch:token.end}),void 0===startToken?(startTokenStringTrimmed=$.trim(token.string),startTokenStringTrimmed.length>0&&(startPos>=startCheck&&startPos<=endCheck||endPos>=startCheck&&endPos<=endCheck)&&(startToken=token,startTokenIndex=i,tokenCount=1,tokensString=startToken.string,startPos===endPos&&(endToken=token))):startCheck>=endPos||(endToken=token,tokenCount++,tokensString+=token.string),startCheck>endPos){void 0===startToken&&void 0!==lastToken&&(console.log("Graffiti: between tokens, so cannot create a Graffiti."),results=noResults);break}if(void 0===startToken)results=noResults,console.log("Graffiti: degenerate case 3, startToken not found despite everything. Falling to safe route.");else{startToken.offset=0;for(var _i4=0;_i4<allTokens.length;++_i4)if(token=allTokens[_i4],token.type===startToken.type&&token.string===startToken.string){if(!(_i4<startTokenIndex))break;++startToken.offset}void 0===endToken&&(console.log("Graffiti: degenerate case 4, endToken not found. Falling to safe route."),endToken=startToken),results={isIntersecting:!1,noTokensPresent:!1,tokens:{start:{type:startToken.type,string:startToken.string,offset:startToken.offset},count:tokenCount},allTokensString:tokensString,range:{start:cm.indexFromPos({line:startToken.line,ch:startToken.ch}),end:cm.indexFromPos({line:endToken.line,ch:endToken.ch}),selectionStart:startPos,selectionEnd:endPos}}}}}}return results},collectCMTokens:function(cm){for(var allTokens=[],lineCount=cm.lineCount(),i=0;i<lineCount;++i){lineTokens=cm.getLineTokens(i);for(var _i5=0,_Object$keys2=Object.keys(lineTokens);_i5<_Object$keys2.length;_i5++){var j=_Object$keys2[_i5];lineTokens[j].line=i}allTokens=allTokens.concat(lineTokens)}return allTokens},getCMTokenRange:function(cm,tokens,allTokens){var startToken=tokens.start;if(void 0!==startToken){var i,token,firstTokenPosition,allTokensLength=allTokens.length,tokenCounter=0;for(i=0;i<allTokensLength;++i)if(token=allTokens[i],token.string===startToken.string&&token.type===startToken.type){if(tokenCounter===startToken.offset){firstTokenPosition=i;break}++tokenCounter}if(void 0!==firstTokenPosition){var lastTokenPosition=Math.min(allTokensLength-1,firstTokenPosition+tokens.count-1),firstToken=allTokens[firstTokenPosition],lastToken=allTokens[lastTokenPosition];return{start:{line:firstToken.line,ch:firstToken.start},end:{line:lastToken.line,ch:lastToken.end}}}}},cleanSelectionRecord:function(rec){return{anchor:{ch:rec.anchor.ch,line:rec.anchor.line},head:{ch:rec.head.ch,line:rec.head.line}}},cleanSelectionRecords:function(recs){var cleanedRecs=[];if(0===recs.length)return cleanedRecs;for(var i=0;i<recs.length;++i)cleanedRecs.push(utils.cleanSelectionRecord(recs[i]));return cleanedRecs},timeZeroPad:function(num){var strNum=num.toString();return strNum.length<2?"0"+strNum:strNum},formatTime:function(currentTimeMilliseconds,opts){var currentTimeSeconds=currentTimeMilliseconds/1e3,computedHour=Math.floor(currentTimeSeconds/3600),computedMinutes=Math.floor((currentTimeSeconds-3600*computedHour)/60),computedSeconds=Math.floor(currentTimeSeconds-(60*computedMinutes+3600*computedHour)),computedMilliseconds=Math.min(99,(Math.floor(currentTimeMilliseconds-1e3*(computedSeconds+60*computedMinutes+3600*computedHour))/10).toFixed(0)),displayMilliseconds=utils.timeZeroPad(computedMilliseconds),displaySeconds=utils.timeZeroPad(computedSeconds),displayMinutes=utils.timeZeroPad(computedMinutes);utils.timeZeroPad(computedHour);return opts.includeMillis?"".concat(displayMinutes,":").concat(displaySeconds,":").concat(displayMilliseconds):"".concat(displayMinutes,":").concat(displaySeconds)},reworkFetchPathForVirtualHosts:function(path){var parts,loc=document.location,urlPathName=loc.pathname,hasNotebooks=urlPathName.indexOf("/notebooks/")>-1,leadingSlash="/"===path[0],pathMiddle="";return hasNotebooks&&(pathMiddle=leadingSlash?"":"/notebooks/",parts=urlPathName.split(/\/notebooks\//,2)),loc.origin+(parts[0].length>0?parts[0]+pathMiddle+path:pathMiddle+path)},loadCss:function(cssPaths){var path,reworkedPath,previousCssTag;for(var i in cssPaths)if(path=cssPaths[i],reworkedPath=utils.reworkFetchPathForVirtualHosts(path),previousCssTag=$("#recorder-css-tag-"+i),0===previousCssTag.length){var styles=document.createElement("link");styles.rel="stylesheet",styles.id="recorder-css-tag-"+i,styles.type="text/css",styles.media="screen",styles.href=reworkedPath,document.getElementsByTagName("head")[0].appendChild(styles)}},getViewportSize:function(w){if(w=w||window,null!=w.innerWidth)return{w:w.innerWidth,h:w.innerHeight};var d=w.document;return"CSS1Compat"==document.compatMode?{w:d.documentElement.clientWidth,h:d.documentElement.clientHeight}:{w:d.body.clientWidth,h:d.body.clientHeight}},copyToClipboard:function(str){var el=document.createElement("textarea");el.value=str,el.setAttribute("readonly",""),el.style.position="absolute",el.style.left="-9999px",document.body.appendChild(el);var selected=document.getSelection().rangeCount>0&&document.getSelection().getRangeAt(0);el.select(),document.execCommand("copy"),document.body.removeChild(el),selected&&(document.getSelection().removeAllRanges(),document.getSelection().addRange(selected))},isUdacityEnvironment:function(){var host=location.hostname;return!(!host.endsWith("udacity.com")&&!host.endsWith("udacity-student-workspaces.com"))},createApiSymlink:function(){if(utils.isUdacityEnvironment()){var graffitiPath="/opt/workspace-jupyter-graffiti/jupytergraffiti",createSymlinkCmd="ln -sf ".concat(graffitiPath," jupytergraffiti"),importApiScript="";importApiScript+="import sys\\n",importApiScript+='api_path="'+graffitiPath+'"\\n',importApiScript+="if api_path not in sys.path:\\n",importApiScript+="  sys.path.insert(0,api_path)\\n";var executePythonScript="!".concat(createSymlinkCmd," && echo '").concat(importApiScript,"' > /tmp/graffiti-symlink.py && python /tmp/graffiti-symlink.py"),scriptOptions={silent:!1,store_history:!1,stop_on_error:!0};Jupyter.notebook.kernel.execute(executePythonScript,void 0,scriptOptions)}},onWindowsOS:function(){var platform=navigator.platform;return(0===platform.indexOf("Win")||0===platform.indexOf("win"))&&(console.log("Graffiti: Windows OS detected."),!0)}};return utils.saveNotebookDebounced=_.debounce(utils.saveNotebook,utils.saveDebounceTiming,!1),utils}),define("js/localizer.js",["js/state.js"],function(state){var localizer={defaultLanguage:"EN",language:"EN",getLanguage:function(){return localizer.language},setLanguage:function(language){localizer.language=void 0!==language?language:localizer.defaultLanguage},getString:function(token){return localizer.translations.hasOwnProperty(localizer.language)&&localizer.translations[localizer.language].hasOwnProperty(token)?localizer.translations[localizer.language][token].length>0?localizer.translations[localizer.language][token]:localizer.translations[localizer.defaultLanguage][token]:token},loadLocale:function(locale){var _localizer$translatio,_localizer$translatio2;switch(locale){case"EN":localizer.translations.EN=(_localizer$translatio={ENABLE_GRAFFITI:"Enable Graffiti",ACTIVATE_GRAFFITI:"Activate Graffiti",GRAFFITI_PRESENT:"Graffiti is present on this line to the left.",MOVIE_UNAVAILABLE:"Movie is not available.",
MOVIE_UNAVAILABLE_EXPLANATION:"We are sorry, we could not load this movie at this time. Please contact the author of this Notebook for help.",FILE_UNAVAILABLE:"File unavailable",FILE_UNAVAILABLE_EXPLANATION:"The file you requested with <i>%%insert_data_from_file</i> was not found.",ACTIVATE_GRAFFITI_CONFIRM:"Activate Graffiti On This Notebook?",CREATE_1:"Create",CREATE_2:"Record",EDIT:"Edit",EDIT_TOOLTIP:"Edit Tooltip / Graffiti Settings",START_RECORDING:"Start Recording",END_RECORDING:"End Recording",RECORD:"Record",RECORD_MOVIE:"Record movie",RERECORD:"Rerecord",RERECORD_MOVIE:"Rerecord movie",START_PLAYBACK:"Start playback",PAUSE_PLAYBACK:"Pause playback (spacebar)",EXIT_PLAYBACK:"Exit movie (restore notebook contents)",MUTE:"Mute audio",UNMUTE:"Unmute audio",HIGH_SPEED_PLAYBACK:"Switch to high speed playback",REGULAR_SPEED_PLAYBACK:"Switch to regular speed playback",HIGH_SPEED_SILENCES:"High Speed during silences",REGULAR_SPEED_SILENCES:"Regular Speed during silences",SKIP_BACK:"Skip back",SKIP_FORWARD:"Skip forward",TO_PREVIOUS_SENTENCE:"to previous sentence",TO_NEXT_SENTENCE:"to next sentence",SECONDS:"second",SAVE_GRAFFITI:"Save Graffiti",REMOVE_GRAFFITI:"Remove Graffiti",BELOW_TYPE_MARKDOWN:"%% Below, type any markdown to display in the Graffiti tip.\n%% Then run this cell to save it.\n",SAMPLE_API:"Create Sample API Calls",SKIPS_API:"Fast Forwards / Skips",SKIPS_DIALOG_TITLE:"Remove Fast Forwards & Skips on This Recording?",SKIPS_DIALOG_BODY:"This will remove all fast forwards and skips you have set. Are you positive?",SKIPS_DIALOG_CONFIRM_1:"Proceed",SKIPS_DIALOG_CANCEL:"Cancel",SKIPS_HEADER:"Fast Forwards & Skips",SKIPS_COMPRESS_BTN:"Compress time to fixed length",SKIPS_2X_BTN:"Set to fast forward at 2x speed",SKIPS_3X_BTN:"Set to fast forward at 3x speed",SKIPS_4X_BTN:"Set to fast forward at 4x speed"},_defineProperty(_localizer$translatio,"SKIPS_COMPRESS_BTN","Compress time to fixed length"),_defineProperty(_localizer$translatio,"SKIPS_ABSOLUTE_BTN","Skip a section entirely"),_defineProperty(_localizer$translatio,"SKIPS_CLEAR_BTN","Remove all skips"),_defineProperty(_localizer$translatio,"TAKES","Takes"),_defineProperty(_localizer$translatio,"SELECT_SOME_TEXT_MARKDOWN","Select some text in this Markdown cell to add or modify Graffiti, or click inside any existing Graffiti text to modify it."),_defineProperty(_localizer$translatio,"EDIT_IN_MARKDOWN_CELL","Edit the Markdown cell to add or modify Graffiti in the cell, or use Graffiti Extras (below)"),_defineProperty(_localizer$translatio,"SELECT_SOME_TEXT_PLAIN","Select some text in a cell to create or modify Graffiti, click inside any existing Graffiti text to modify that Graffiti, or use Graffiti Extras (below)"),_defineProperty(_localizer$translatio,"YOU_CAN_PLAY_VIA_TOOLTIP","You can play this movie any time via its tooltip."),_defineProperty(_localizer$translatio,"NO_MOVIE_RECORDED_YET","No movie has been recorded for this Graffiti yet."),_defineProperty(_localizer$translatio,"PLEASE_WAIT_STORING_MOVIE","Please wait, storing this movie..."),_defineProperty(_localizer$translatio,"YOU_CAN_FILTER","You can filter this Notebook's Graffiti by clicking on creators in the list below."),_defineProperty(_localizer$translatio,"PAUSE_TO_INTERACT",'<span class="graffiti-notifier-link" id="graffiti-pause-link">Pause</span> (or scroll the page) to interact with this Notebook'),_defineProperty(_localizer$translatio,"CANCEL_MOVIE_PLAYBACK_1",'<span class="graffiti-notifier-link" id="graffiti-cancel-playback-link">Cancel</span> movie playback (Esc)'),_defineProperty(_localizer$translatio,"CANCEL_MOVIE_PLAYBACK_2",'<span class="graffiti-notifier-link" id="graffiti-cancel-playback-postreset-link">Cancel</span> movie playback (Esc)'),_defineProperty(_localizer$translatio,"CANCEL_MOVIE_PLAYBACK_3",'<span class="graffiti-notifier-link" id="graffiti-cancel-playback-prereset-link">Cancel</span> movie playback (Esc)'),_defineProperty(_localizer$translatio,"PLAY_MOVIE_AGAIN",'<span class="graffiti-notifier-link" id="graffiti-restart-play-link">Play movie again</span>'),_defineProperty(_localizer$translatio,"CONTINUE_MOVIE_PLAYBACK",'<span class="graffiti-notifier-link" id="graffiti-continue-play-link">Continue</span> movie playback'),_defineProperty(_localizer$translatio,"ENTER_AND_SAVE",'Enter the markdown you want to be displayed in the Graffiti and then click "Save Graffiti"  (or just run the label cell).'),_defineProperty(_localizer$translatio,"CANCEL_CHANGES_1",'Or, <span class="graffiti-notifier-link" id="graffiti-cancel-graffiting-link">Cancel changes</span>'),_defineProperty(_localizer$translatio,"CANCEL_CHANGES_2",'Or, <span class="graffiti-notifier-link" id="graffiti-cancel-recording-labelling-link">Cancel changes</span>'),_defineProperty(_localizer$translatio,"ENTER_MARKDOWN_MOVIE_DESCRIPTION",'Enter markdown to describe your movie, then click "Start Recording" (or just run the label cell).'),_defineProperty(_localizer$translatio,"CLICK_BEGIN_MOVIE_RECORDING","Click anywhere in the notebook to begin recording your movie."),_defineProperty(_localizer$translatio,"CANCEL_RECORDING_1",'Or, <span class="graffiti-notifier-link" id="graffiti-cancel-recording-pending-link">Cancel recording</span>'),_defineProperty(_localizer$translatio,"CANCEL_RECORDING_2",'Or, <span class="graffiti-notifier-link" id="graffiti-cancel-recording-link">Cancel recording</span>'),_defineProperty(_localizer$translatio,"RECORDING_HINT_1",'<div class="graffiti-keyboard-sim"><div>option/alt</div><div>key</div></div>'),_defineProperty(_localizer$translatio,"RECORDING_HINT_2","<span>Tap</span>: Pause Rec."),_defineProperty(_localizer$translatio,"RECORDING_HINT_3","<span>Hold</span>: End Rec."),_defineProperty(_localizer$translatio,"RECORDING_HINT_4",'<div class="graffiti-keyboard-sim" style="color:red;"><div>Skipping</div><div>(option/alt to resume)</div></div>'),_defineProperty(_localizer$translatio,"IS_SKIPPING","--:--"),_defineProperty(_localizer$translatio,"ACTIVITIES_BEING_RECORDED","Your activities are being recorded. Hold the option key down to end recording."),_defineProperty(_localizer$translatio,"LOADING","Loading... (ESC to cancel)"),_defineProperty(_localizer$translatio,"LOADING_PLEASE_WAIT","Loading Graffiti movie, please wait..."),_defineProperty(_localizer$translatio,"RECORDED_ON","Recorded"),_defineProperty(_localizer$translatio,"PRESS_ESC_TO_END_MOVIE_PLAYBACK","Press ESC to end movie playback"),_defineProperty(_localizer$translatio,"SHOW_GRAFFITI_EDITOR","Show Graffiti Editor"),_defineProperty(_localizer$translatio,"HIDE_GRAFFITI_EDITOR","Hide Graffiti Editor"),_defineProperty(_localizer$translatio,"ENTER_LABEL","Enter a label..."),_defineProperty(_localizer$translatio,"FREEFORM_PEN_TOOL","Freeform pen tool"),_defineProperty(_localizer$translatio,"HIGHLIGHTER_TOOL","Highlighter tool"),_defineProperty(_localizer$translatio,"ERASER_TOOL","Eraser tool"),_defineProperty(_localizer$translatio,"USE_DISAPPEARING_INK","Use disappearing ink"),_defineProperty(_localizer$translatio,"USE_DASHED_LINES","Use dashed lines"),_defineProperty(_localizer$translatio,"DASHED_LINES","Dashed lines"),_defineProperty(_localizer$translatio,"TEMPORARY_INK","Temporary Ink"),_defineProperty(_localizer$translatio,"SOLID_FILL","Solid Fill"),_defineProperty(_localizer$translatio,"SHIFT_KEY_ALIGN","Shift-key: align items to grid / keep items square"),_defineProperty(_localizer$translatio,"PLAY_CONFIRM","Are you sure you want to play this Graffiti?"),_defineProperty(_localizer$translatio,"REPLACE_CONFIRM_BODY_1","This Graffiti movie may replace the contents of code cells. After this movie plays, do you want to..."),_defineProperty(_localizer$translatio,"REPLACE_CONFIRM_BODY_2","Restore Cell Contents After Playback Ends"),_defineProperty(_localizer$translatio,"REPLACE_CONFIRM_BODY_3","Let this Movie Permanently Set Cell Contents"),_defineProperty(_localizer$translatio,"ACCESS_MICROPHONE_PROMPT","Please grant access to your browser's microphone."),_defineProperty(_localizer$translatio,"ACCESS_MICROPHONE_ADVISORY",'You cannot record Graffiti movies unless you grant access to the microphone. Please <a href="https://help.aircall.io/hc/en-gb/articles/115001425325-How-to-allow-Google-Chrome-to-access-your-microphone" target="_">grant access</a> and then reload this page.'),_defineProperty(_localizer$translatio,"ACTIVATE_GRAFFITI_ADVISORY","Enable Graffiti on this Notebook, so you can begin using Graffiti for the first time?<br>If you click Cancel, we will not change the notebook in any way.<br><br><i>(This process merely adds some metadata to the cells, but does not otherwise change the Notebook's contents.)</i>"),_defineProperty(_localizer$translatio,"SCRUB","scrub"),_defineProperty(_localizer$translatio,"TOOLTIP_HINT","Without moving your mouse, click now to watch a movie about this."),_defineProperty(_localizer$translatio,"MOVIE_DURATION","Movie duration"),_defineProperty(_localizer$translatio,"INSERT_GRAFFITI_BUTTON_CELL","+ Insert Graffiti Button"),_defineProperty(_localizer$translatio,"INSERT_GRAFFITI_BUTTON_CELL_ALT_TAG","Insert a Graffiti-enabled button"),_defineProperty(_localizer$translatio,"INSERT_GRAFFITI_TERMINAL","+ Insert Graffiti Terminal"),_defineProperty(_localizer$translatio,"INSERT_GRAFFITI_TERMINAL_ALT_TAG","Insert a Graffiti-enabled terminal"),_defineProperty(_localizer$translatio,"INSERT_GRAFFITI_TERMINAL_SUITE","+ Insert Terminal Suite"),_defineProperty(_localizer$translatio,"INSERT_GRAFFITI_TERMINAL_SUITE_ALT_TAG","Insert a code cell + terminal + button"),_defineProperty(_localizer$translatio,"INSERT_TERMINAL_SUITE_STATUS","Inserting a terminal suite, please wait..."),_defineProperty(_localizer$translatio,"JUMP_TO_NOTEBOOK_DIR","Jump to Notebook's Dir"),_defineProperty(_localizer$translatio,"RESET_TERMINAL","Reset"),_defineProperty(_localizer$translatio,"CELL_EXECUTES_GRAFFITI","Code Cell, Executes Graffiti"),_defineProperty(_localizer$translatio,"CELL_EXECUTE_CHOICE","Now click on the element that contains the Graffiti you want this cell to run..."),_defineProperty(_localizer$translatio,"CELL_EXECUTE_CHOICE_SET","Your choice has been saved."),_defineProperty(_localizer$translatio,"ACTIVATE_LOCK_ALT_TAG","Lock/unlock all markdown cells"),_defineProperty(_localizer$translatio,"CHANGE_DATADIR_TAG","Change home directory for Graffiti data"),_defineProperty(_localizer$translatio,"CREATE_SHOWHIDE_BUTTON","Create show/hide button"),_defineProperty(_localizer$translatio,"LOCK_VERB","Lock"),_defineProperty(_localizer$translatio,"UNLOCK_VERB","Unlock"),_defineProperty(_localizer$translatio,"UNLOCK_BODY","This will unlock all markdown cells so you can edit them (note: terminal cells are always locked)."),_defineProperty(_localizer$translatio,"LOCK_BODY","This will lock all markdown cells so they can no longer be edited."),_defineProperty(_localizer$translatio,"LOCK_CONFIRM","markdown cells in notebook?"),_defineProperty(_localizer$translatio,"DATA_PATH_INSTRUCTIONS","### Change Data Path?\nYou can tell Graffiti to store its data in another folder/path. In the code cell below, put the _relative_ path to the folder where you want to store Graffiti data, including the folder name and a trailing slash. For example, suppose you want Graffiti to store its data one folder up in a directory called `graffitibits`. Then you should enter `../graffitibits/` here. (The default value is `jupytergraffiti_data/`, a folder in the same directory as this Notebook.)\n\n_Please Note:_ \n\n* If you are unsure what to do, don't change the path and just hit the _Confirm_ button.\n* If the data folder does not exist, Graffiti will create it when you create your first Graffiti for the notebook.\n* Any Graffiti recorded previously in a different path will become unavailable. \n* This cell, the path cell and Confirm button cell below will be automatically removed from the Notebook after you click _Confirm_."),_defineProperty(_localizer$translatio,"ACCEPTED_DATADIR_HEADER","Your new path for Graffiti has been accepted"),_defineProperty(_localizer$translatio,"ACCEPTED_DATADIR_BODY","Your Graffiti path has been changed. Now you must reload your notebook. \n\nYou can change this setting any time with the Data Directory button on the Graffiti Editor panel."),_localizer$translatio);break;case"CN":localizer.translations.CN=(_localizer$translatio2={ENABLE_GRAFFITI:"启用 Graffiti",ACTIVATE_GRAFFITI:"开始使用 Graffiti ",GRAFFITI_PRESENT:"本行有 Graffiti ，请查阅",MOVIE_UNAVAILABLE:"视频不存在",MOVIE_UNAVAILABLE_EXPLANATION:"抱歉，我们目前无法加载该视频。请联系创建该 Notebook 的作者寻求帮助。",FILE_UNAVAILABLE:"File unavailable",FILE_UNAVAILABLE_EXPLANATION:"The file you requested with `%%insert_data_from_file` was not available",ACTIVATE_GRAFFITI_CONFIRM:"是否在该 Notebook 上启用 Graffiti？",CREATE_1:"创建",CREATE_2:"创建",EDIT:"编辑",EDIT_TOOLTIP:"编辑 Graffiti 提示框",START_RECORDING:"开始录屏",END_RECORDING:"结束录屏",RECORD:"录屏",RECORD_MOVIE:"录制视频",RERECORD:"重录",RERECORD_MOVIE:"重新录制",START_PLAYBACK:"开始回放",PAUSE_PLAYBACK:"终止回放 (spacebar)",EXIT_PLAYBACK:"Exit movie (restore notebook contents)",MUTE:"静音",UNMUTE:"取消静音",HIGH_SPEED_PLAYBACK:"快速回放",REGULAR_SPEED_PLAYBACK:"正常回放",HIGH_SPEED_SILENCES:"无人说话的片段快速播放",REGULAR_SPEED_SILENCES:"无人说话的片段正常播放",SKIP_BACK:"快退",SKIP_FORWARD:"快进",TO_PREVIOUS_SENTENCE:"到前一句",TO_NEXT_SENTENCE:"到下一句",SECONDS:"秒",SAVE_GRAFFITI:"保留 Graffiti ",REMOVE_GRAFFITI:"移除 Graffiti ",BELOW_TYPE_MARKDOWN:"在以下输入 markdown 文本，将展示在 Graffiti 中。然后运行文本以保存。",SAMPLE_API:"创建示例 API Calls",SKIPS_API:"Fast Forwards / Skips",SKIPS_DIALOG_TITLE:"Remove Fast Forwards & Skips on This Recording?",SKIPS_DIALOG_BODY:"This will remove all fast forwards and skips you have set. Are you positive?",SKIPS_DIALOG_CONFIRM_1:"Proceed",SKIPS_DIALOG_CANCEL:"Cancel",SKIPS_HEADER:"Fast Forwards & Skips",SKIPS_COMPRESS_BTN:"Compress time to fixed length",SKIPS_2X_BTN:"Set to fast forward at 2x speed",SKIPS_3X_BTN:"Set to fast forward at 3x speed",SKIPS_4X_BTN:"Set to fast forward at 4x speed"},_defineProperty(_localizer$translatio2,"SKIPS_COMPRESS_BTN","Compress time to fixed length"),_defineProperty(_localizer$translatio2,"SKIPS_ABSOLUTE_BTN","Skip a section entirely"),_defineProperty(_localizer$translatio2,"SKIPS_CLEAR_BTN","Remove all skips"),_defineProperty(_localizer$translatio2,"TAKES","版本"),_defineProperty(_localizer$translatio2,"SELECT_SOME_TEXT_MARKDOWN","选择文本以创建或者修改 Graffiti，或者点击已有的 Graffiti 进行修改"),_defineProperty(_localizer$translatio2,"EDIT_IN_MARKDOWN_CELL","Edit the Markdown cell to add or modify Graffiti in the cell, or use Graffiti Extras (below)"),_defineProperty(_localizer$translatio2,"SELECT_SOME_TEXT_PLAIN","Select some text in a cell to create or modify Graffiti, click inside any existing Graffiti text to modify that Graffiti, or use Graffiti Extras (below)"),_defineProperty(_localizer$translatio2,"YOU_CAN_PLAY_VIA_TOOLTIP","你可以通过提示框随时播放此视频"),_defineProperty(_localizer$translatio2,"NO_MOVIE_RECORDED_YET","No movie has been recorded for this Graffiti yet."),_defineProperty(_localizer$translatio2,"PLEASE_WAIT_STORING_MOVIE","稍等，视频存储中..."),_defineProperty(_localizer$translatio2,"YOU_CAN_FILTER","点击列表里的创建者，筛选 Notebook 里的 Graffiti"),_defineProperty(_localizer$translatio2,"PAUSE_TO_INTERACT",'<span class="graffiti-notifier-link" id="graffiti-pause-link">暂停</span>（或者下拉页面），可以继续在 Notebook 上的操作'),_defineProperty(_localizer$translatio2,"CANCEL_MOVIE_PLAYBACK_1",'<span class="graffiti-notifier-link" id="graffiti-cancel-playback-link">取消</span>视频回放（或者使用 Esc 按键）'),_defineProperty(_localizer$translatio2,"CANCEL_MOVIE_PLAYBACK_2",'<span class="graffiti-notifier-link" id="graffiti-cancel-playback-postreset-link">取消</span>视频回放（或者使用 Esc 按键）'),_defineProperty(_localizer$translatio2,"CANCEL_MOVIE_PLAYBACK_3",'<span class="graffiti-notifier-link" id="graffiti-cancel-playback-prereset-link">取消</span>视频回放（或者使用 Esc 按键）'),_defineProperty(_localizer$translatio2,"PLAY_MOVIE_AGAIN",'<span class="graffiti-notifier-link" id="graffiti-restart-play-link">重新播放视频</span>'),_defineProperty(_localizer$translatio2,"CONTINUE_MOVIE_PLAYBACK",'<span class="graffiti-notifier-link" id="graffiti-continue-play-link">继续</span>回放视频'),_defineProperty(_localizer$translatio2,"ENTER_AND_SAVE","输入你想在 Graffiti 里展示的文本内容，完成后点击“保存 Graffiti”（或者运行单元格以保存）"),_defineProperty(_localizer$translatio2,"CANCEL_CHANGES_1",'或者<span class="graffiti-notifier-link" id="graffiti-cancel-graffiting-link">取消更改</span>'),_defineProperty(_localizer$translatio2,"CANCEL_CHANGES_2",'或者<span class="graffiti-notifier-link" id="graffiti-cancel-recording-labelling-link">取消更改</span>'),_defineProperty(_localizer$translatio2,"ENTER_MARKDOWN_MOVIE_DESCRIPTION","输入视频描述文字，点击“开始录屏”（或者运行单元格以开始）"),_defineProperty(_localizer$translatio2,"CLICK_BEGIN_MOVIE_RECORDING","点击 Notebook 的任何一处，开始录屏"),_defineProperty(_localizer$translatio2,"CANCEL_RECORDING_1",'或者<span class="graffiti-notifier-link" id="graffiti-cancel-recording-pending-link">取消录制</span>'),_defineProperty(_localizer$translatio2,"CANCEL_RECORDING_2",'或者<span class="graffiti-notifier-link" id="graffiti-cancel-recording-link">取消录制</span>'),_defineProperty(_localizer$translatio2,"RECORDING_HINT_1",'<div class="graffiti-keyboard-sim"><div>option/alt</div><div>key</div></div>'),_defineProperty(_localizer$translatio2,"RECORDING_HINT_2","<span>Tap</span>: Pause Rec."),_defineProperty(_localizer$translatio2,"RECORDING_HINT_3","<span>Hold</span>: End Rec."),_defineProperty(_localizer$translatio2,"RECORDING_HINT_4",'<div class="graffiti-keyboard-sim" style="color:red;"><div>Skipping</div><div>(option/alt to resume)</div></div>'),_defineProperty(_localizer$translatio2,"IS_SKIPPING","--:--"),_defineProperty(_localizer$translatio2,"ACTIVITIES_BEING_RECORDED",'录屏进行中按键 ⌘-M 或者点击<span class="graffiti-notifier-link" id="graffiti-end-recording-link">结束录屏</span> 以终止录制'),_defineProperty(_localizer$translatio2,"LOADING","加载中 (ESC to cancel)"),_defineProperty(_localizer$translatio2,"LOADING_PLEASE_WAIT","正在加载 Graffiti 视频，请稍等..."),_defineProperty(_localizer$translatio2,"RECORDED_ON","已录制"),_defineProperty(_localizer$translatio2,"PRESS_ESC_TO_END_MOVIE_PLAYBACK","按键 ESC 结束视频回放"),_defineProperty(_localizer$translatio2,"SHOW_GRAFFITI_EDITOR","显示 Graffiti 编辑器"),_defineProperty(_localizer$translatio2,"HIDE_GRAFFITI_EDITOR","隐藏 Graffiti 编辑器"),_defineProperty(_localizer$translatio2,"ENTER_LABEL","创建标签"),_defineProperty(_localizer$translatio2,"FREEFORM_PEN_TOOL","自由图形画笔"),_defineProperty(_localizer$translatio2,"HIGHLIGHTER_TOOL","高亮工具"),_defineProperty(_localizer$translatio2,"ERASER_TOOL","橡皮擦"),_defineProperty(_localizer$translatio2,"USE_DISAPPEARING_INK","使用渐消墨水"),_defineProperty(_localizer$translatio2,"USE_DASHED_LINES","使用虚线"),_defineProperty(_localizer$translatio2,"DASHED_LINES","虚线"),_defineProperty(_localizer$translatio2,"TEMPORARY_INK","渐消墨水"),_defineProperty(_localizer$translatio2,"SOLID_FILL","填充图形"),_defineProperty(_localizer$translatio2,"SHIFT_KEY_ALIGN","按住 Shift 键，图形自动对齐"),_defineProperty(_localizer$translatio2,"PLAY_CONFIRM","是否确认播放该 Graffiti 视频？"),_defineProperty(_localizer$translatio2,"REPLACE_CONFIRM_BODY_1","播放 Graffiti 视频可能会更改代码单元格内容，你可以选择在播放后"),_defineProperty(_localizer$translatio2,"REPLACE_CONFIRM_BODY_2","还原之前的单元格内容"),_defineProperty(_localizer$translatio2,"REPLACE_CONFIRM_BODY_3","允许视频更新单元格内容"),_defineProperty(_localizer$translatio2,"ACCESS_MICROPHONE_PROMPT","请允许使用目前浏览器的麦克风"),_defineProperty(_localizer$translatio2,"ACCESS_MICROPHONE_ADVISORY",'请允许使用麦克风，否则无法录屏请 <a href="https://help.aircall.io/hc/en-gb/articles/115001425325-How-to-allow-Google-Chrome-to-access-your-microphone" target="_">允许使用</a>并重新加载该页面'),_defineProperty(_localizer$translatio2,"ACTIVATE_GRAFFITI_ADVISORY","在该 Notebook 上启用 Graffiti，就能进行录屏操作啦如果点击取消，不会更改 notebook<br><br><i>(该操作只会增加单元格的元数据，不会更改 Notebook 的内容)</i>"),_defineProperty(_localizer$translatio2,"SCRUB","scrub"),_defineProperty(_localizer$translatio2,"TOOLTIP_HINT","Click the underlined text (below) to watch a movie about this."),_defineProperty(_localizer$translatio2,"MOVIE_DURATION","Movie duration"),_defineProperty(_localizer$translatio2,"INSERT_GRAFFITI_BUTTON_CELL","+ Graffiti Button"),_defineProperty(_localizer$translatio2,"INSERT_GRAFFITI_BUTTON_CELL_ALT_TAG","Insert a Graffiti-enabled button"),_defineProperty(_localizer$translatio2,"INSERT_GRAFFITI_TERMINAL","+ Terminal"),_defineProperty(_localizer$translatio2,"INSERT_GRAFFITI_TERMINAL_ALT_TAG","Insert a Graffiti-enabled terminal"),_defineProperty(_localizer$translatio2,"INSERT_GRAFFITI_TERMINAL_SUITE","+ Terminal Suite"),_defineProperty(_localizer$translatio2,"INSERT_GRAFFITI_TERMINAL_SUITE_ALT_TAG","Insert a code cell + terminal + button"),_defineProperty(_localizer$translatio2,"INSERT_TERMINAL_SUITE_STATUS","Inserting a terminal suite, please wait..."),_defineProperty(_localizer$translatio2,"JUMP_TO_NOTEBOOK_DIR","Jump to Notebook's Dir"),_defineProperty(_localizer$translatio2,"RESET_TERMINAL","Reset"),_defineProperty(_localizer$translatio2,"CELL_EXECUTES_GRAFFITI","Code Cell, Executes Graffiti"),_defineProperty(_localizer$translatio2,"CELL_EXECUTE_CHOICE","Now click on the element that contains the Graffiti you want this cell to run..."),_defineProperty(_localizer$translatio2,"CELL_EXECUTE_CHOICE_SET","Your choice has been saved."),_defineProperty(_localizer$translatio2,"ACTIVATE_LOCK_ALT_TAG","Lock/unlock all markdown cells"),_defineProperty(_localizer$translatio2,"CHANGE_DATADIR_TAG","Change home directory for Graffiti data"),_defineProperty(_localizer$translatio2,"CREATE_SHOWHIDE_BUTTON","Create show/hide button"),_defineProperty(_localizer$translatio2,"LOCK_VERB","Lock"),_defineProperty(_localizer$translatio2,"UNLOCK_VERB","Unlock"),_defineProperty(_localizer$translatio2,"UNLOCK_BODY","This will unlock all markdown cells so you can edit them (note: terminal cells are always locked)."),_defineProperty(_localizer$translatio2,"LOCK_BODY","This will lock all markdown cells so they can no longer be edited."),_defineProperty(_localizer$translatio2,"LOCK_CONFIRM","markdown cells in notebook?"),_defineProperty(_localizer$translatio2,"DATA_PATH_INSTRUCTIONS","### Change Data Path?\nYou can tell Graffiti to store its data in another folder/path. In the code cell below, put the _relative_ path to the folder where you want to store Graffiti data, including the folder name and a trailing slash. For example, suppose you want Graffiti to store its data one folder up in a directory called `graffitibits`. Then you should enter `../graffitibits/` here. (The default value is `jupytergraffiti_data/`, a folder in the same directory as this Notebook.)\n\n_Please Note:_ \n\n* If you are unsure what to do, don't change the path and just hit the _Confirm_ button.\n* If the data folder does not exist, Graffiti will create it when you create your first Graffiti for the notebook.\n* Any Graffiti recorded previously in a different path will become unavailable. \n* This cell, the path cell and Confirm button cell below will be automatically removed from the Notebook after you click _Confirm_."),_defineProperty(_localizer$translatio2,"ACCEPTED_DATADIR_HEADER","Your new path for Graffiti has been accepted"),_defineProperty(_localizer$translatio2,"ACCEPTED_DATADIR_BODY","Your Graffiti path has been changed. Now you must reload your notebook. \n\nYou can change this setting any time with the Data Directory button on the Graffiti Editor panel."),_localizer$translatio2)}},init:function(){localizer.translations={},localizer.loadLocale("EN"),localizer.loadLocale("CN");var notebook=Jupyter.notebook;return localizer.setLanguage("EN"),notebook.metadata.hasOwnProperty("graffiti")&&notebook.metadata.graffiti.hasOwnProperty("language")&&localizer.setLanguage(notebook.metadata.graffiti.language),Promise.resolve()}};return localizer}),function(f){if("object"===("undefined"==typeof exports?"undefined":_typeof(exports))&&"undefined"!=typeof module)module.exports=f();else if("function"==typeof define&&define.amd)define("js/xterm/xterm.js",[],f);else{var g;g="undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:this,g.Terminal=f()}}(function(){return function(){function r(e,n,t){function o(i,f){if(!n[i]){if(!e[i]){var c="function"==typeof require&&require;if(!f&&c)return c(i,!0);if(u)return u(i,!0);var a=new Error("Cannot find module '"+i+"'");throw a.code="MODULE_NOT_FOUND",a}var p=n[i]={exports:{}};e[i][0].call(p.exports,function(r){return o(e[i][1][r]||r)},p,p.exports,r,e,n,t)}return n[i].exports}for(var u="function"==typeof require&&require,i=0;i<t.length;i++)o(t[i]);return o}return r}()({1:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var _extendStatics=function(d,b){return(_extendStatics=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])})(d,b)};return function(d,b){function __(){this.constructor=d}_extendStatics(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:!0});var Strings=require("./Strings"),Platform_1=require("./core/Platform"),RenderDebouncer_1=require("./ui/RenderDebouncer"),Lifecycle_1=require("./ui/Lifecycle"),Lifecycle_2=require("./common/Lifecycle"),AccessibilityManager=function(_super){function AccessibilityManager(_terminal){var _this=_super.call(this)||this;_this._terminal=_terminal,_this._liveRegionLineCount=0,_this._charsToConsume=[],_this._accessibilityTreeRoot=document.createElement("div"),_this._accessibilityTreeRoot.classList.add("xterm-accessibility"),_this._rowContainer=document.createElement("div"),_this._rowContainer.classList.add("xterm-accessibility-tree"),_this._rowElements=[];for(var i=0;i<_this._terminal.rows;i++)_this._rowElements[i]=_this._createAccessibilityTreeNode(),_this._rowContainer.appendChild(_this._rowElements[i]);return _this._topBoundaryFocusListener=function(e){return _this._onBoundaryFocus(e,0)},_this._bottomBoundaryFocusListener=function(e){return _this._onBoundaryFocus(e,1)},_this._rowElements[0].addEventListener("focus",_this._topBoundaryFocusListener),_this._rowElements[_this._rowElements.length-1].addEventListener("focus",_this._bottomBoundaryFocusListener),_this._refreshRowsDimensions(),_this._accessibilityTreeRoot.appendChild(_this._rowContainer),_this._renderRowsDebouncer=new RenderDebouncer_1.RenderDebouncer(_this._terminal,_this._renderRows.bind(_this)),_this._refreshRows(),_this._liveRegion=document.createElement("div"),_this._liveRegion.classList.add("live-region"),_this._liveRegion.setAttribute("aria-live","assertive"),_this._accessibilityTreeRoot.appendChild(_this._liveRegion),_this._terminal.element.insertAdjacentElement("afterbegin",_this._accessibilityTreeRoot),_this.register(_this._renderRowsDebouncer),_this.register(_this._terminal.addDisposableListener("resize",function(data){return _this._onResize(data.rows)})),_this.register(_this._terminal.addDisposableListener("refresh",function(data){return _this._refreshRows(data.start,data.end)})),_this.register(_this._terminal.addDisposableListener("scroll",function(data){return _this._refreshRows()})),_this.register(_this._terminal.addDisposableListener("a11y.char",function(_char){return _this._onChar(_char)})),_this.register(_this._terminal.addDisposableListener("linefeed",function(){return _this._onChar("\n")})),_this.register(_this._terminal.addDisposableListener("a11y.tab",function(spaceCount){return _this._onTab(spaceCount)})),_this.register(_this._terminal.addDisposableListener("key",function(keyChar){return _this._onKey(keyChar)})),_this.register(_this._terminal.addDisposableListener("blur",function(){return _this._clearLiveRegion()})),_this.register(_this._terminal.addDisposableListener("dprchange",function(){return _this._refreshRowsDimensions()})),_this.register(_this._terminal.renderer.addDisposableListener("resize",function(){return _this._refreshRowsDimensions()})),_this.register(Lifecycle_1.addDisposableDomListener(window,"resize",function(){return _this._refreshRowsDimensions()})),_this}return __extends(AccessibilityManager,_super),AccessibilityManager.prototype.dispose=function(){_super.prototype.dispose.call(this),this._terminal.element.removeChild(this._accessibilityTreeRoot),this._rowElements.length=0},AccessibilityManager.prototype._onBoundaryFocus=function(e,position){var boundaryElement=e.target,beforeBoundaryElement=this._rowElements[0===position?1:this._rowElements.length-2];if(boundaryElement.getAttribute("aria-posinset")!==(0===position?"1":""+this._terminal.buffer.lines.length)&&e.relatedTarget===beforeBoundaryElement){var topBoundaryElement,bottomBoundaryElement;if(0===position?(topBoundaryElement=boundaryElement,bottomBoundaryElement=this._rowElements.pop(),this._rowContainer.removeChild(bottomBoundaryElement)):(topBoundaryElement=this._rowElements.shift(),bottomBoundaryElement=boundaryElement,this._rowContainer.removeChild(topBoundaryElement)),topBoundaryElement.removeEventListener("focus",this._topBoundaryFocusListener),bottomBoundaryElement.removeEventListener("focus",this._bottomBoundaryFocusListener),0===position){var newElement=this._createAccessibilityTreeNode();this._rowElements.unshift(newElement),this._rowContainer.insertAdjacentElement("afterbegin",newElement)}else{var newElement=this._createAccessibilityTreeNode();this._rowElements.push(newElement),this._rowContainer.appendChild(newElement)}this._rowElements[0].addEventListener("focus",this._topBoundaryFocusListener),this._rowElements[this._rowElements.length-1].addEventListener("focus",this._bottomBoundaryFocusListener),this._terminal.scrollLines(0===position?-1:1),this._rowElements[0===position?1:this._rowElements.length-2].focus(),e.preventDefault(),e.stopImmediatePropagation()}},AccessibilityManager.prototype._onResize=function(rows){this._rowElements[this._rowElements.length-1].removeEventListener("focus",this._bottomBoundaryFocusListener);for(var i=this._rowContainer.children.length;i<this._terminal.rows;i++)this._rowElements[i]=this._createAccessibilityTreeNode(),this._rowContainer.appendChild(this._rowElements[i]);for(;this._rowElements.length>rows;)this._rowContainer.removeChild(this._rowElements.pop());this._rowElements[this._rowElements.length-1].addEventListener("focus",this._bottomBoundaryFocusListener),this._refreshRowsDimensions()},AccessibilityManager.prototype._createAccessibilityTreeNode=function(){var element=document.createElement("div");return element.setAttribute("role","listitem"),element.tabIndex=-1,this._refreshRowDimensions(element),element},AccessibilityManager.prototype._onTab=function(spaceCount){for(var i=0;i<spaceCount;i++)this._onChar(" ")},AccessibilityManager.prototype._onChar=function(_char2){var _this=this;if(this._liveRegionLineCount<21){if(this._charsToConsume.length>0){this._charsToConsume.shift()!==_char2&&this._announceCharacter(_char2)}else this._announceCharacter(_char2);"\n"===_char2&&21===++this._liveRegionLineCount&&(this._liveRegion.textContent+=Strings.tooMuchOutput),Platform_1.isMac&&this._liveRegion.textContent&&this._liveRegion.textContent.length>0&&!this._liveRegion.parentNode&&setTimeout(function(){_this._accessibilityTreeRoot.appendChild(_this._liveRegion)},0)}},AccessibilityManager.prototype._clearLiveRegion=function(){this._liveRegion.textContent="",this._liveRegionLineCount=0,Platform_1.isMac&&this._liveRegion.parentNode&&this._accessibilityTreeRoot.removeChild(this._liveRegion)},AccessibilityManager.prototype._onKey=function(keyChar){this._clearLiveRegion(),this._charsToConsume.push(keyChar)},AccessibilityManager.prototype._refreshRows=function(start,end){this._renderRowsDebouncer.refresh(start,end)},AccessibilityManager.prototype._renderRows=function(start,end){for(var buffer=this._terminal.buffer,setSize=buffer.lines.length.toString(),i=start;i<=end;i++){var lineData=buffer.translateBufferLineToString(buffer.ydisp+i,!0),posInSet=(buffer.ydisp+i+1).toString(),element=this._rowElements[i];element.textContent=0===lineData.length?Strings.blankLine:lineData,
element.setAttribute("aria-posinset",posInSet),element.setAttribute("aria-setsize",setSize)}},AccessibilityManager.prototype._refreshRowsDimensions=function(){if(this._terminal.renderer.dimensions.actualCellHeight){this._rowElements.length!==this._terminal.rows&&this._onResize(this._terminal.rows);for(var i=0;i<this._terminal.rows;i++)this._refreshRowDimensions(this._rowElements[i])}},AccessibilityManager.prototype._refreshRowDimensions=function(element){element.style.height=this._terminal.renderer.dimensions.actualCellHeight+"px"},AccessibilityManager.prototype._announceCharacter=function(_char3){" "===_char3?this._liveRegion.innerHTML+="&nbsp;":this._liveRegion.textContent+=_char3},AccessibilityManager}(Lifecycle_2.Disposable);exports.AccessibilityManager=AccessibilityManager},{"./Strings":14,"./common/Lifecycle":20,"./core/Platform":23,"./ui/Lifecycle":51,"./ui/RenderDebouncer":54}],2:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var _extendStatics2=function(d,b){return(_extendStatics2=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])})(d,b)};return function(d,b){function __(){this.constructor=d}_extendStatics2(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:!0});var BufferLine_1=require("./BufferLine"),BufferReflow_1=require("./BufferReflow"),CircularList_1=require("./common/CircularList"),EventEmitter_1=require("./common/EventEmitter"),Types_1=require("./renderer/atlas/Types");exports.DEFAULT_ATTR=256|Types_1.DEFAULT_COLOR<<9,exports.CHAR_DATA_ATTR_INDEX=0,exports.CHAR_DATA_CHAR_INDEX=1,exports.CHAR_DATA_WIDTH_INDEX=2,exports.CHAR_DATA_CODE_INDEX=3,exports.MAX_BUFFER_SIZE=4294967295,exports.NULL_CELL_CHAR="",exports.NULL_CELL_WIDTH=1,exports.NULL_CELL_CODE=0,exports.WHITESPACE_CELL_CHAR=" ",exports.WHITESPACE_CELL_WIDTH=1,exports.WHITESPACE_CELL_CODE=32,exports.FILL_CHAR_DATA=[exports.DEFAULT_ATTR,exports.NULL_CELL_CHAR,exports.NULL_CELL_WIDTH,exports.NULL_CELL_CODE];var Buffer=function(){function Buffer(_terminal,_hasScrollback){this._terminal=_terminal,this._hasScrollback=_hasScrollback,this.markers=[],this._cols=this._terminal.cols,this._rows=this._terminal.rows,this.clear()}return Buffer.prototype.getBlankLine=function(attr,isWrapped){var fillCharData=[attr,exports.NULL_CELL_CHAR,exports.NULL_CELL_WIDTH,exports.NULL_CELL_CODE];return new BufferLine_1.BufferLine(this._cols,fillCharData,isWrapped)},Object.defineProperty(Buffer.prototype,"hasScrollback",{get:function(){return this._hasScrollback&&this.lines.maxLength>this._rows},enumerable:!0,configurable:!0}),Object.defineProperty(Buffer.prototype,"isCursorInViewport",{get:function(){var absoluteY=this.ybase+this.y,relativeY=absoluteY-this.ydisp;return relativeY>=0&&relativeY<this._rows},enumerable:!0,configurable:!0}),Buffer.prototype._getCorrectBufferLength=function(rows){if(!this._hasScrollback)return rows;var correctBufferLength=rows+this._terminal.options.scrollback;return correctBufferLength>exports.MAX_BUFFER_SIZE?exports.MAX_BUFFER_SIZE:correctBufferLength},Buffer.prototype.fillViewportRows=function(fillAttr){if(0===this.lines.length){void 0===fillAttr&&(fillAttr=exports.DEFAULT_ATTR);for(var i=this._rows;i--;)this.lines.push(this.getBlankLine(fillAttr))}},Buffer.prototype.clear=function(){this.ydisp=0,this.ybase=0,this.y=0,this.x=0,this.lines=new CircularList_1.CircularList(this._getCorrectBufferLength(this._rows)),this.scrollTop=0,this.scrollBottom=this._rows-1,this.setupTabStops()},Buffer.prototype.resize=function(newCols,newRows){var newMaxLength=this._getCorrectBufferLength(newRows);if(newMaxLength>this.lines.maxLength&&(this.lines.maxLength=newMaxLength),this.lines.length>0){if(this._cols<newCols)for(var i=0;i<this.lines.length;i++)this.lines.get(i).resize(newCols,exports.FILL_CHAR_DATA);var addToY=0;if(this._rows<newRows)for(var y=this._rows;y<newRows;y++)this.lines.length<newRows+this.ybase&&(this.ybase>0&&this.lines.length<=this.ybase+this.y+addToY+1?(this.ybase--,addToY++,this.ydisp>0&&this.ydisp--):this.lines.push(new BufferLine_1.BufferLine(newCols,exports.FILL_CHAR_DATA)));else for(var y=this._rows;y>newRows;y--)this.lines.length>newRows+this.ybase&&(this.lines.length>this.ybase+this.y+1?this.lines.pop():(this.ybase++,this.ydisp++));if(newMaxLength<this.lines.maxLength){var amountToTrim=this.lines.length-newMaxLength;amountToTrim>0&&(this.lines.trimStart(amountToTrim),this.ybase=Math.max(this.ybase-amountToTrim,0),this.ydisp=Math.max(this.ydisp-amountToTrim,0)),this.lines.maxLength=newMaxLength}this.x=Math.min(this.x,newCols-1),this.y=Math.min(this.y,newRows-1),addToY&&(this.y+=addToY),this.savedY=Math.min(this.savedY,newRows-1),this.savedX=Math.min(this.savedX,newCols-1),this.scrollTop=0}if(this.scrollBottom=newRows-1,this._hasScrollback&&(this._reflow(newCols,newRows),this._cols>newCols))for(var i=0;i<this.lines.length;i++)this.lines.get(i).resize(newCols,exports.FILL_CHAR_DATA);this._cols=newCols,this._rows=newRows},Buffer.prototype._reflow=function(newCols,newRows){this._cols!==newCols&&(newCols>this._cols?this._reflowLarger(newCols):this._reflowSmaller(newCols,newRows))},Buffer.prototype._reflowLarger=function(newCols){var toRemove=BufferReflow_1.reflowLargerGetLinesToRemove(this.lines,newCols,this.ybase+this.y);if(toRemove.length>0){var newLayoutResult=BufferReflow_1.reflowLargerCreateNewLayout(this.lines,toRemove);BufferReflow_1.reflowLargerApplyNewLayout(this.lines,newLayoutResult.layout),this._reflowLargerAdjustViewport(newCols,newLayoutResult.countRemoved)}},Buffer.prototype._reflowLargerAdjustViewport=function(newCols,countRemoved){for(var viewportAdjustments=countRemoved;viewportAdjustments-- >0;)0===this.ybase?(this.y>0&&this.y--,this.lines.length<this._rows&&this.lines.push(new BufferLine_1.BufferLine(newCols,exports.FILL_CHAR_DATA))):(this.ydisp===this.ybase&&this.ydisp--,this.ybase--)},Buffer.prototype._reflowSmaller=function(newCols,newRows){for(var toInsert=[],countToInsert=0,y=this.lines.length-1;y>=0;y--){var nextLine=this.lines.get(y);if(nextLine.isWrapped||!(nextLine.getTrimmedLength()<=newCols)){for(var wrappedLines=[nextLine];nextLine.isWrapped&&y>0;)nextLine=this.lines.get(--y),wrappedLines.unshift(nextLine);var absoluteY=this.ybase+this.y;if(!(absoluteY>=y&&absoluteY<y+wrappedLines.length)){var lastLineLength=wrappedLines[wrappedLines.length-1].getTrimmedLength(),destLineLengths=BufferReflow_1.reflowSmallerGetNewLineLengths(wrappedLines,this._cols,newCols),linesToAdd=destLineLengths.length-wrappedLines.length,trimmedLines=void 0;trimmedLines=0===this.ybase&&this.y!==this.lines.length-1?Math.max(0,this.y-this.lines.maxLength+linesToAdd):Math.max(0,this.lines.length-this.lines.maxLength+linesToAdd);for(var newLines=[],i=0;i<linesToAdd;i++){var newLine=this.getBlankLine(exports.DEFAULT_ATTR,!0);newLines.push(newLine)}newLines.length>0&&(toInsert.push({start:y+wrappedLines.length+countToInsert,newLines:newLines}),countToInsert+=newLines.length),wrappedLines.push.apply(wrappedLines,newLines);var destLineIndex=destLineLengths.length-1,destCol=destLineLengths[destLineIndex];0===destCol&&(destLineIndex--,destCol=destLineLengths[destLineIndex]);for(var srcLineIndex=wrappedLines.length-linesToAdd-1,srcCol=lastLineLength;srcLineIndex>=0;){var cellsToCopy=Math.min(srcCol,destCol);wrappedLines[destLineIndex].copyCellsFrom(wrappedLines[srcLineIndex],srcCol-cellsToCopy,destCol-cellsToCopy,cellsToCopy,!0),destCol-=cellsToCopy,0===destCol&&(destLineIndex--,destCol=destLineLengths[destLineIndex]),srcCol-=cellsToCopy,0===srcCol&&(srcLineIndex--,srcCol=wrappedLines[Math.max(srcLineIndex,0)].getTrimmedLength())}for(var i=0;i<wrappedLines.length;i++)destLineLengths[i]<newCols&&wrappedLines[i].set(destLineLengths[i],exports.FILL_CHAR_DATA);for(var viewportAdjustments=linesToAdd-trimmedLines;viewportAdjustments-- >0;)0===this.ybase?this.y<this._rows-1?(this.y++,this.lines.pop()):(this.ybase++,this.ydisp++):this.ybase<Math.min(this.lines.maxLength,this.lines.length+countToInsert)-newRows&&(this.ybase===this.ydisp&&this.ydisp++,this.ybase++)}}}if(toInsert.length>0){for(var insertEvents=[],originalLines=[],i=0;i<this.lines.length;i++)originalLines.push(this.lines.get(i));var originalLinesLength=this.lines.length,originalLineIndex=originalLinesLength-1,nextToInsertIndex=0,nextToInsert=toInsert[nextToInsertIndex];this.lines.length=Math.min(this.lines.maxLength,this.lines.length+countToInsert);for(var countInsertedSoFar=0,i=Math.min(this.lines.maxLength-1,originalLinesLength+countToInsert-1);i>=0;i--)if(nextToInsert&&nextToInsert.start>originalLineIndex+countInsertedSoFar){for(var nextI=nextToInsert.newLines.length-1;nextI>=0;nextI--)this.lines.set(i--,nextToInsert.newLines[nextI]);i++,insertEvents.push({index:originalLineIndex+1,amount:nextToInsert.newLines.length}),countInsertedSoFar+=nextToInsert.newLines.length,nextToInsert=toInsert[++nextToInsertIndex]}else this.lines.set(i,originalLines[originalLineIndex--]);for(var insertCountEmitted=0,i=insertEvents.length-1;i>=0;i--)insertEvents[i].index+=insertCountEmitted,this.lines.emit("insert",insertEvents[i]),insertCountEmitted+=insertEvents[i].amount;var amountToTrim=Math.max(0,originalLinesLength+countToInsert-this.lines.maxLength);amountToTrim>0&&this.lines.emitMayRemoveListeners("trim",amountToTrim)}},Buffer.prototype.stringIndexToBufferIndex=function(lineIndex,stringIndex,trimRight){for(void 0===trimRight&&(trimRight=!1);stringIndex;){var line=this.lines.get(lineIndex);if(!line)return[-1,-1];for(var length_1=trimRight?line.getTrimmedLength():line.length,i=0;i<length_1;++i)if(line.get(i)[exports.CHAR_DATA_WIDTH_INDEX]&&(stringIndex-=line.get(i)[exports.CHAR_DATA_CHAR_INDEX].length||1),stringIndex<0)return[lineIndex,i];lineIndex++}return[lineIndex,0]},Buffer.prototype.translateBufferLineToString=function(lineIndex,trimRight,startCol,endCol){void 0===startCol&&(startCol=0);var line=this.lines.get(lineIndex);return line?line.translateToString(trimRight,startCol,endCol):""},Buffer.prototype.getWrappedRangeForLine=function(y){for(var first=y,last=y;first>0&&this.lines.get(first).isWrapped;)first--;for(;last+1<this.lines.length&&this.lines.get(last+1).isWrapped;)last++;return{first:first,last:last}},Buffer.prototype.setupTabStops=function(i){for(null!==i&&void 0!==i?this.tabs[i]||(i=this.prevStop(i)):(this.tabs={},i=0);i<this._cols;i+=this._terminal.options.tabStopWidth)this.tabs[i]=!0},Buffer.prototype.prevStop=function(x){for(null!==x&&void 0!==x||(x=this.x);!this.tabs[--x]&&x>0;);return x>=this._cols?this._cols-1:x<0?0:x},Buffer.prototype.nextStop=function(x){for(null!==x&&void 0!==x||(x=this.x);!this.tabs[++x]&&x<this._cols;);return x>=this._cols?this._cols-1:x<0?0:x},Buffer.prototype.addMarker=function(y){var _this=this,marker=new Marker(y);return this.markers.push(marker),marker.register(this.lines.addDisposableListener("trim",function(amount){marker.line-=amount,marker.line<0&&marker.dispose()})),marker.register(this.lines.addDisposableListener("insert",function(event){marker.line>=event.index&&(marker.line+=event.amount)})),marker.register(this.lines.addDisposableListener("delete",function(event){marker.line>=event.index&&marker.line<event.index+event.amount&&marker.dispose(),marker.line>event.index&&(marker.line-=event.amount)})),marker.register(marker.addDisposableListener("dispose",function(){return _this._removeMarker(marker)})),marker},Buffer.prototype._removeMarker=function(marker){this.markers.splice(this.markers.indexOf(marker),1)},Buffer.prototype.iterator=function(trimRight,startIndex,endIndex,startOverscan,endOverscan){return new BufferStringIterator(this,trimRight,startIndex,endIndex,startOverscan,endOverscan)},Buffer}();exports.Buffer=Buffer;var Marker=function(_super){function Marker(line){var _this=_super.call(this)||this;return _this.line=line,_this._id=Marker._nextId++,_this.isDisposed=!1,_this}return __extends(Marker,_super),Object.defineProperty(Marker.prototype,"id",{get:function(){return this._id},enumerable:!0,configurable:!0}),Marker.prototype.dispose=function(){this.isDisposed||(this.isDisposed=!0,this.emit("dispose"),_super.prototype.dispose.call(this))},Marker._nextId=1,Marker}(EventEmitter_1.EventEmitter);exports.Marker=Marker;var BufferStringIterator=function(){function BufferStringIterator(_buffer,_trimRight,_startIndex,_endIndex,_startOverscan,_endOverscan){void 0===_startIndex&&(_startIndex=0),void 0===_endIndex&&(_endIndex=_buffer.lines.length),void 0===_startOverscan&&(_startOverscan=0),void 0===_endOverscan&&(_endOverscan=0),this._buffer=_buffer,this._trimRight=_trimRight,this._startIndex=_startIndex,this._endIndex=_endIndex,this._startOverscan=_startOverscan,this._endOverscan=_endOverscan,this._startIndex<0&&(this._startIndex=0),this._endIndex>this._buffer.lines.length&&(this._endIndex=this._buffer.lines.length),this._current=this._startIndex}return BufferStringIterator.prototype.hasNext=function(){return this._current<this._endIndex},BufferStringIterator.prototype.next=function(){var range=this._buffer.getWrappedRangeForLine(this._current);range.first<this._startIndex-this._startOverscan&&(range.first=this._startIndex-this._startOverscan),range.last>this._endIndex+this._endOverscan&&(range.last=this._endIndex+this._endOverscan),range.first=Math.max(range.first,0),range.last=Math.min(range.last,this._buffer.lines.length);for(var result="",i=range.first;i<=range.last;++i)result+=this._buffer.translateBufferLineToString(i,this._trimRight);return this._current=range.last+1,{range:range,content:result}},BufferStringIterator}();exports.BufferStringIterator=BufferStringIterator},{"./BufferLine":3,"./BufferReflow":4,"./common/CircularList":17,"./common/EventEmitter":19,"./renderer/atlas/Types":46}],3:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var Buffer_1=require("./Buffer"),CELL_SIZE=3,BufferLine=function(){function BufferLine(cols,fillCharData,isWrapped){if(void 0===isWrapped&&(isWrapped=!1),this.isWrapped=isWrapped,this._data=null,this._combined={},fillCharData||(fillCharData=[0,Buffer_1.NULL_CELL_CHAR,Buffer_1.NULL_CELL_WIDTH,Buffer_1.NULL_CELL_CODE]),cols){this._data=new Uint32Array(cols*CELL_SIZE);for(var i=0;i<cols;++i)this.set(i,fillCharData)}this.length=cols}return BufferLine.prototype.get=function(index){var stringData=this._data[index*CELL_SIZE+1];return[this._data[index*CELL_SIZE+0],2147483648&stringData?this._combined[index]:stringData?String.fromCharCode(stringData):"",this._data[index*CELL_SIZE+2],2147483648&stringData?this._combined[index].charCodeAt(this._combined[index].length-1):stringData]},BufferLine.prototype.getWidth=function(index){return this._data[index*CELL_SIZE+2]},BufferLine.prototype.set=function(index,value){this._data[index*CELL_SIZE+0]=value[0],value[1].length>1?(this._combined[index]=value[1],this._data[index*CELL_SIZE+1]=2147483648|index):this._data[index*CELL_SIZE+1]=value[1].charCodeAt(0),this._data[index*CELL_SIZE+2]=value[2]},BufferLine.prototype.insertCells=function(pos,n,fillCharData){if(pos%=this.length,n<this.length-pos){for(var i=this.length-pos-n-1;i>=0;--i)this.set(pos+n+i,this.get(pos+i));for(var i=0;i<n;++i)this.set(pos+i,fillCharData)}else for(var i=pos;i<this.length;++i)this.set(i,fillCharData)},BufferLine.prototype.deleteCells=function(pos,n,fillCharData){if(pos%=this.length,n<this.length-pos){for(var i=0;i<this.length-pos-n;++i)this.set(pos+i,this.get(pos+n+i));for(var i=this.length-n;i<this.length;++i)this.set(i,fillCharData)}else for(var i=pos;i<this.length;++i)this.set(i,fillCharData)},BufferLine.prototype.replaceCells=function(start,end,fillCharData){for(;start<end&&start<this.length;)this.set(start++,fillCharData)},BufferLine.prototype.resize=function(cols,fillCharData){if(cols!==this.length){if(cols>this.length){var data=new Uint32Array(cols*CELL_SIZE);this.length&&(cols*CELL_SIZE<this._data.length?data.set(this._data.subarray(0,cols*CELL_SIZE)):data.set(this._data)),this._data=data;for(var i=this.length;i<cols;++i)this.set(i,fillCharData)}else if(cols){var data=new Uint32Array(cols*CELL_SIZE);data.set(this._data.subarray(0,cols*CELL_SIZE)),this._data=data;for(var keys=Object.keys(this._combined),i=0;i<keys.length;i++){var key=parseInt(keys[i],10);key>=cols&&delete this._combined[key]}}else this._data=null,this._combined={};this.length=cols}},BufferLine.prototype.fill=function(fillCharData){this._combined={};for(var i=0;i<this.length;++i)this.set(i,fillCharData)},BufferLine.prototype.copyFrom=function(line){this.length!==line.length?this._data=new Uint32Array(line._data):this._data.set(line._data),this.length=line.length,this._combined={};for(var el in line._combined)this._combined[el]=line._combined[el];this.isWrapped=line.isWrapped},BufferLine.prototype.clone=function(){var newLine=new BufferLine(0);newLine._data=new Uint32Array(this._data),newLine.length=this.length;for(var el in this._combined)newLine._combined[el]=this._combined[el];return newLine.isWrapped=this.isWrapped,newLine},BufferLine.prototype.getTrimmedLength=function(){for(var i=this.length-1;i>=0;--i)if(0!==this._data[i*CELL_SIZE+1])return i+this._data[i*CELL_SIZE+2];return 0},BufferLine.prototype.copyCellsFrom=function(src,srcCol,destCol,length,applyInReverse){var srcData=src._data;if(applyInReverse)for(var cell=length-1;cell>=0;cell--)for(var i=0;i<CELL_SIZE;i++)this._data[(destCol+cell)*CELL_SIZE+i]=srcData[(srcCol+cell)*CELL_SIZE+i];else for(var cell=0;cell<length;cell++)for(var i=0;i<CELL_SIZE;i++)this._data[(destCol+cell)*CELL_SIZE+i]=srcData[(srcCol+cell)*CELL_SIZE+i];for(var srcCombinedKeys=Object.keys(src._combined),i=0;i<srcCombinedKeys.length;i++){var key=parseInt(srcCombinedKeys[i],10);key>=srcCol&&(this._combined[key-srcCol+destCol]=src._combined[key])}},BufferLine.prototype.translateToString=function(trimRight,startCol,endCol){void 0===trimRight&&(trimRight=!1),void 0===startCol&&(startCol=0),void 0===endCol&&(endCol=this.length),trimRight&&(endCol=Math.min(endCol,this.getTrimmedLength()));for(var result="";startCol<endCol;){var stringData=this._data[startCol*CELL_SIZE+1];result+=2147483648&stringData?this._combined[startCol]:stringData?String.fromCharCode(stringData):Buffer_1.WHITESPACE_CELL_CHAR,startCol+=this._data[startCol*CELL_SIZE+2]||1}return result},BufferLine}();exports.BufferLine=BufferLine},{"./Buffer":2}],4:[function(require,module,exports){"use strict";function reflowLargerGetLinesToRemove(lines,newCols,bufferAbsoluteY){for(var toRemove=[],y=0;y<lines.length-1;y++){var i=y,nextLine=lines.get(++i);if(nextLine.isWrapped){for(var wrappedLines=[lines.get(y)];i<lines.length&&nextLine.isWrapped;)wrappedLines.push(nextLine),nextLine=lines.get(++i);if(bufferAbsoluteY>=y&&bufferAbsoluteY<i)y+=wrappedLines.length-1;else{for(var destLineIndex=0,destCol=wrappedLines[destLineIndex].getTrimmedLength(),srcLineIndex=1,srcCol=0;srcLineIndex<wrappedLines.length;){var srcTrimmedTineLength=wrappedLines[srcLineIndex].getTrimmedLength(),srcRemainingCells=srcTrimmedTineLength-srcCol,destRemainingCells=newCols-destCol,cellsToCopy=Math.min(srcRemainingCells,destRemainingCells);wrappedLines[destLineIndex].copyCellsFrom(wrappedLines[srcLineIndex],srcCol,destCol,cellsToCopy,!1),destCol+=cellsToCopy,destCol===newCols&&(destLineIndex++,destCol=0),srcCol+=cellsToCopy,srcCol===srcTrimmedTineLength&&(srcLineIndex++,srcCol=0),0===destCol&&0!==destLineIndex&&2===wrappedLines[destLineIndex-1].getWidth(newCols-1)&&(wrappedLines[destLineIndex].copyCellsFrom(wrappedLines[destLineIndex-1],newCols-1,destCol++,1,!1),wrappedLines[destLineIndex-1].set(newCols-1,Buffer_1.FILL_CHAR_DATA))}wrappedLines[destLineIndex].replaceCells(destCol,newCols,Buffer_1.FILL_CHAR_DATA);for(var countToRemove=0,i_1=wrappedLines.length-1;i_1>0&&(i_1>destLineIndex||0===wrappedLines[i_1].getTrimmedLength());i_1--)countToRemove++;countToRemove>0&&(toRemove.push(y+wrappedLines.length-countToRemove),toRemove.push(countToRemove)),y+=wrappedLines.length-1}}}return toRemove}function reflowLargerCreateNewLayout(lines,toRemove){for(var layout=[],nextToRemoveIndex=0,nextToRemoveStart=toRemove[nextToRemoveIndex],countRemovedSoFar=0,i=0;i<lines.length;i++)if(nextToRemoveStart===i){var countToRemove=toRemove[++nextToRemoveIndex];lines.emit("delete",{index:i-countRemovedSoFar,amount:countToRemove}),i+=countToRemove-1,countRemovedSoFar+=countToRemove,nextToRemoveStart=toRemove[++nextToRemoveIndex]}else layout.push(i);return{layout:layout,countRemoved:countRemovedSoFar}}function reflowLargerApplyNewLayout(lines,newLayout){for(var newLayoutLines=[],i=0;i<newLayout.length;i++)newLayoutLines.push(lines.get(newLayout[i]));for(var i=0;i<newLayoutLines.length;i++)lines.set(i,newLayoutLines[i]);lines.length=newLayout.length}function reflowSmallerGetNewLineLengths(wrappedLines,oldCols,newCols){for(var newLineLengths=[],cellsNeeded=wrappedLines.map(function(l){return l.getTrimmedLength()}).reduce(function(p,c){return p+c}),srcCol=0,srcLine=0,cellsAvailable=0;cellsAvailable<cellsNeeded;){if(cellsNeeded-cellsAvailable<newCols){newLineLengths.push(cellsNeeded-cellsAvailable);break}srcCol+=newCols;var oldTrimmedLength=wrappedLines[srcLine].getTrimmedLength();srcCol>oldTrimmedLength&&(srcCol-=oldTrimmedLength,srcLine++);var endsWithWide=2===wrappedLines[srcLine].getWidth(srcCol-1);endsWithWide&&srcCol--;var lineLength=endsWithWide?newCols-1:newCols;newLineLengths.push(lineLength),cellsAvailable+=lineLength}return newLineLengths}Object.defineProperty(exports,"__esModule",{value:!0});var Buffer_1=require("./Buffer");exports.reflowLargerGetLinesToRemove=reflowLargerGetLinesToRemove,exports.reflowLargerCreateNewLayout=reflowLargerCreateNewLayout,exports.reflowLargerApplyNewLayout=reflowLargerApplyNewLayout,exports.reflowSmallerGetNewLineLengths=reflowSmallerGetNewLineLengths},{"./Buffer":2}],5:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var _extendStatics3=function(d,b){return(_extendStatics3=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])})(d,b)};return function(d,b){function __(){this.constructor=d}_extendStatics3(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:!0});var Buffer_1=require("./Buffer"),EventEmitter_1=require("./common/EventEmitter"),BufferSet=function(_super){function BufferSet(_terminal){var _this=_super.call(this)||this;return _this._terminal=_terminal,_this._normal=new Buffer_1.Buffer(_this._terminal,!0),_this._normal.fillViewportRows(),_this._alt=new Buffer_1.Buffer(_this._terminal,!1),_this._activeBuffer=_this._normal,_this.setupTabStops(),_this}return __extends(BufferSet,_super),Object.defineProperty(BufferSet.prototype,"alt",{get:function(){return this._alt},enumerable:!0,configurable:!0}),Object.defineProperty(BufferSet.prototype,"active",{get:function(){return this._activeBuffer},enumerable:!0,configurable:!0}),Object.defineProperty(BufferSet.prototype,"normal",{get:function(){return this._normal},enumerable:!0,configurable:!0}),BufferSet.prototype.activateNormalBuffer=function(){this._activeBuffer!==this._normal&&(this._normal.x=this._alt.x,this._normal.y=this._alt.y,this._alt.clear(),this._activeBuffer=this._normal,this.emit("activate",{activeBuffer:this._normal,inactiveBuffer:this._alt}))},BufferSet.prototype.activateAltBuffer=function(fillAttr){this._activeBuffer!==this._alt&&(this._alt.fillViewportRows(fillAttr),this._alt.x=this._normal.x,this._alt.y=this._normal.y,this._activeBuffer=this._alt,this.emit("activate",{activeBuffer:this._alt,inactiveBuffer:this._normal}))},BufferSet.prototype.resize=function(newCols,newRows){this._normal.resize(newCols,newRows),this._alt.resize(newCols,newRows)},BufferSet.prototype.setupTabStops=function(i){this._normal.setupTabStops(i),this._alt.setupTabStops(i)},BufferSet}(EventEmitter_1.EventEmitter);exports.BufferSet=BufferSet},{"./Buffer":2,"./common/EventEmitter":19}],6:[function(require,module,exports){"use strict";function getStringCellWidth(s){for(var result=0,length=s.length,i=0;i<length;++i){var code=s.charCodeAt(i);if(55296<=code&&code<=56319){if(++i>=length)return result+exports.wcwidth(code);var second=s.charCodeAt(i);56320<=second&&second<=57343?code=1024*(code-55296)+second-56320+65536:result+=exports.wcwidth(second)}result+=exports.wcwidth(code)}return result}Object.defineProperty(exports,"__esModule",{value:!0});var TypedArrayUtils_1=require("./common/TypedArrayUtils");exports.wcwidth=function(opts){function bisearch(ucs,data){var mid,min=0,max=data.length-1;if(ucs<data[0][0]||ucs>data[max][1])return!1;for(;max>=min;)if(mid=min+max>>1,ucs>data[mid][1])min=mid+1;else{if(!(ucs<data[mid][0]))return!0;max=mid-1}return!1}function wcwidthHigh(ucs){return bisearch(ucs,COMBINING_HIGH)?0:ucs>=131072&&ucs<=196605||ucs>=196608&&ucs<=262141?2:1}var COMBINING_BMP=[[768,879],[1155,1158],[1160,1161],[1425,1469],[1471,1471],[1473,1474],[1476,1477],[1479,1479],[1536,1539],[1552,1557],[1611,1630],[1648,1648],[1750,1764],[1767,1768],[1770,1773],[1807,1807],[1809,1809],[1840,1866],[1958,1968],[2027,2035],[2305,2306],[2364,2364],[2369,2376],[2381,2381],[2385,2388],[2402,2403],[2433,2433],[2492,2492],[2497,2500],[2509,2509],[2530,2531],[2561,2562],[2620,2620],[2625,2626],[2631,2632],[2635,2637],[2672,2673],[2689,2690],[2748,2748],[2753,2757],[2759,2760],[2765,2765],[2786,2787],[2817,2817],[2876,2876],[2879,2879],[2881,2883],[2893,2893],[2902,2902],[2946,2946],[3008,3008],[3021,3021],[3134,3136],[3142,3144],[3146,3149],[3157,3158],[3260,3260],[3263,3263],[3270,3270],[3276,3277],[3298,3299],[3393,3395],[3405,3405],[3530,3530],[3538,3540],[3542,3542],[3633,3633],[3636,3642],[3655,3662],[3761,3761],[3764,3769],[3771,3772],[3784,3789],[3864,3865],[3893,3893],[3895,3895],[3897,3897],[3953,3966],[3968,3972],[3974,3975],[3984,3991],[3993,4028],[4038,4038],[4141,4144],[4146,4146],[4150,4151],[4153,4153],[4184,4185],[4448,4607],[4959,4959],[5906,5908],[5938,5940],[5970,5971],[6002,6003],[6068,6069],[6071,6077],[6086,6086],[6089,6099],[6109,6109],[6155,6157],[6313,6313],[6432,6434],[6439,6440],[6450,6450],[6457,6459],[6679,6680],[6912,6915],[6964,6964],[6966,6970],[6972,6972],[6978,6978],[7019,7027],[7616,7626],[7678,7679],[8203,8207],[8234,8238],[8288,8291],[8298,8303],[8400,8431],[12330,12335],[12441,12442],[43014,43014],[43019,43019],[43045,43046],[64286,64286],[65024,65039],[65056,65059],[65279,65279],[65529,65531]],COMBINING_HIGH=[[68097,68099],[68101,68102],[68108,68111],[68152,68154],[68159,68159],[119143,119145],[119155,119170],[119173,119179],[119210,119213],[119362,119364],[917505,917505],[917536,917631],[917760,917999]],control=0|opts.control,table=new Uint8Array(65536);TypedArrayUtils_1.fill(table,1),table[0]=opts.nul,TypedArrayUtils_1.fill(table,opts.control,1,32),TypedArrayUtils_1.fill(table,opts.control,127,160),TypedArrayUtils_1.fill(table,2,4352,4448),table[9001]=2,table[9002]=2,TypedArrayUtils_1.fill(table,2,11904,42192),table[12351]=1,TypedArrayUtils_1.fill(table,2,44032,55204),TypedArrayUtils_1.fill(table,2,63744,64256),TypedArrayUtils_1.fill(table,2,65040,65050),TypedArrayUtils_1.fill(table,2,65072,65136),TypedArrayUtils_1.fill(table,2,65280,65377),TypedArrayUtils_1.fill(table,2,65504,65511);for(var r=0;r<COMBINING_BMP.length;++r)TypedArrayUtils_1.fill(table,0,COMBINING_BMP[r][0],COMBINING_BMP[r][1]+1);return function(num){return num<32?0|control:num<127?1:num<65536?table[num]:wcwidthHigh(num)}}({nul:0,control:0}),exports.getStringCellWidth=getStringCellWidth},{"./common/TypedArrayUtils":21}],7:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var CompositionHelper=function(){function CompositionHelper(_textarea,_compositionView,_terminal){this._textarea=_textarea,this._compositionView=_compositionView,this._terminal=_terminal,this._isComposing=!1,this._isSendingComposition=!1,this._compositionPosition={start:null,end:null}}return CompositionHelper.prototype.compositionstart=function(){this._isComposing=!0,this._compositionPosition.start=this._textarea.value.length,this._compositionView.textContent="",this._compositionView.classList.add("active")},CompositionHelper.prototype.compositionupdate=function(ev){var _this=this;this._compositionView.textContent=ev.data,this.updateCompositionElements(),setTimeout(function(){_this._compositionPosition.end=_this._textarea.value.length},0)},CompositionHelper.prototype.compositionend=function(){this._finalizeComposition(!0)},CompositionHelper.prototype.keydown=function(ev){if(this._isComposing||this._isSendingComposition){if(229===ev.keyCode)return!1;if(16===ev.keyCode||17===ev.keyCode||18===ev.keyCode)return!1;this._finalizeComposition(!1)}return 229!==ev.keyCode||(this._handleAnyTextareaChanges(),!1)},CompositionHelper.prototype._finalizeComposition=function(waitForPropagation){var _this=this;if(this._compositionView.classList.remove("active"),this._isComposing=!1,this._clearTextareaPosition(),waitForPropagation){var currentCompositionPosition_1={start:this._compositionPosition.start,end:this._compositionPosition.end};this._isSendingComposition=!0,setTimeout(function(){if(_this._isSendingComposition){_this._isSendingComposition=!1;var input=void 0;input=_this._isComposing?_this._textarea.value.substring(currentCompositionPosition_1.start,currentCompositionPosition_1.end):_this._textarea.value.substring(currentCompositionPosition_1.start),_this._terminal.handler(input)}},0)}else{this._isSendingComposition=!1;var input=this._textarea.value.substring(this._compositionPosition.start,this._compositionPosition.end);this._terminal.handler(input)}},CompositionHelper.prototype._handleAnyTextareaChanges=function(){var _this=this,oldValue=this._textarea.value;setTimeout(function(){if(!_this._isComposing){var newValue=_this._textarea.value,diff=newValue.replace(oldValue,"");diff.length>0&&_this._terminal.handler(diff)}},0)},CompositionHelper.prototype.updateCompositionElements=function(dontRecurse){var _this=this;if(this._isComposing){if(this._terminal.buffer.isCursorInViewport){var cellHeight=Math.ceil(this._terminal.charMeasure.height*this._terminal.options.lineHeight),cursorTop=this._terminal.buffer.y*cellHeight,cursorLeft=this._terminal.buffer.x*this._terminal.charMeasure.width;this._compositionView.style.left=cursorLeft+"px",this._compositionView.style.top=cursorTop+"px",this._compositionView.style.height=cellHeight+"px",this._compositionView.style.lineHeight=cellHeight+"px";var compositionViewBounds=this._compositionView.getBoundingClientRect();this._textarea.style.left=cursorLeft+"px",this._textarea.style.top=cursorTop+"px",this._textarea.style.width=compositionViewBounds.width+"px",this._textarea.style.height=compositionViewBounds.height+"px",this._textarea.style.lineHeight=compositionViewBounds.height+"px"}dontRecurse||setTimeout(function(){return _this.updateCompositionElements(!0)},0)}},CompositionHelper.prototype._clearTextareaPosition=function(){this._textarea.style.left="",this._textarea.style.top=""},CompositionHelper}();exports.CompositionHelper=CompositionHelper},{}],8:[function(require,module,exports){"use strict";function r(low,high){for(var c=high-low,arr=new Array(c);c--;)arr[c]=--high;return arr}var __extends=this&&this.__extends||function(){var _extendStatics4=function(d,b){return(_extendStatics4=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])})(d,b)};return function(d,b){function __(){this.constructor=d}_extendStatics4(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:!0});var Lifecycle_1=require("./common/Lifecycle"),TextDecoder_1=require("./core/input/TextDecoder"),TransitionTable=function(){
function TransitionTable(length){this.table="undefined"==typeof Uint8Array?new Array(length):new Uint8Array(length)}return TransitionTable.prototype.add=function(code,state,action,next){this.table[state<<8|code]=(0|action)<<4|(void 0===next?state:next)},TransitionTable.prototype.addMany=function(codes,state,action,next){for(var i=0;i<codes.length;i++)this.add(codes[i],state,action,next)},TransitionTable}();exports.TransitionTable=TransitionTable;var PRINTABLES=r(32,127),EXECUTABLES=r(0,24);EXECUTABLES.push(25),EXECUTABLES.push.apply(EXECUTABLES,r(28,32));exports.VT500_TRANSITION_TABLE=function(){var state,table=new TransitionTable(4095),states=r(0,14);for(state in states)for(var code=0;code<=160;++code)table.add(code,state,1,0);table.addMany(PRINTABLES,0,2,0);for(state in states)table.addMany([24,26,153,154],state,3,0),table.addMany(r(128,144),state,3,0),table.addMany(r(144,152),state,3,0),table.add(156,state,0,0),table.add(27,state,11,1),table.add(157,state,4,8),table.addMany([152,158,159],state,0,7),table.add(155,state,11,3),table.add(144,state,11,9);return table.addMany(EXECUTABLES,0,3,0),table.addMany(EXECUTABLES,1,3,1),table.add(127,1,0,1),table.addMany(EXECUTABLES,8,0,8),table.addMany(EXECUTABLES,3,3,3),table.add(127,3,0,3),table.addMany(EXECUTABLES,4,3,4),table.add(127,4,0,4),table.addMany(EXECUTABLES,6,3,6),table.addMany(EXECUTABLES,5,3,5),table.add(127,5,0,5),table.addMany(EXECUTABLES,2,3,2),table.add(127,2,0,2),table.add(93,1,4,8),table.addMany(PRINTABLES,8,5,8),table.add(127,8,5,8),table.addMany([156,27,24,26,7],8,6,0),table.addMany(r(28,32),8,0,8),table.addMany([88,94,95],1,0,7),table.addMany(PRINTABLES,7,0,7),table.addMany(EXECUTABLES,7,0,7),table.add(156,7,0,0),table.add(127,7,0,7),table.add(91,1,11,3),table.addMany(r(64,127),3,7,0),table.addMany(r(48,58),3,8,4),table.add(59,3,8,4),table.addMany([60,61,62,63],3,9,4),table.addMany(r(48,58),4,8,4),table.add(59,4,8,4),table.addMany(r(64,127),4,7,0),table.addMany([58,60,61,62,63],4,0,6),table.addMany(r(32,64),6,0,6),table.add(127,6,0,6),table.addMany(r(64,127),6,0,0),table.add(58,3,0,6),table.addMany(r(32,48),3,9,5),table.addMany(r(32,48),5,9,5),table.addMany(r(48,64),5,0,6),table.addMany(r(64,127),5,7,0),table.addMany(r(32,48),4,9,5),table.addMany(r(32,48),1,9,2),table.addMany(r(32,48),2,9,2),table.addMany(r(48,127),2,10,0),table.addMany(r(48,80),1,10,0),table.addMany(r(81,88),1,10,0),table.addMany([89,90,92],1,10,0),table.addMany(r(96,127),1,10,0),table.add(80,1,11,9),table.addMany(EXECUTABLES,9,0,9),table.add(127,9,0,9),table.addMany(r(28,32),9,0,9),table.addMany(r(32,48),9,9,12),table.add(58,9,0,11),table.addMany(r(48,58),9,8,10),table.add(59,9,8,10),table.addMany([60,61,62,63],9,9,10),table.addMany(EXECUTABLES,11,0,11),table.addMany(r(32,128),11,0,11),table.addMany(r(28,32),11,0,11),table.addMany(EXECUTABLES,10,0,10),table.add(127,10,0,10),table.addMany(r(28,32),10,0,10),table.addMany(r(48,58),10,8,10),table.add(59,10,8,10),table.addMany([58,60,61,62,63],10,0,11),table.addMany(r(32,48),10,9,12),table.addMany(EXECUTABLES,12,0,12),table.add(127,12,0,12),table.addMany(r(28,32),12,0,12),table.addMany(r(32,48),12,9,12),table.addMany(r(48,64),12,0,11),table.addMany(r(64,127),12,12,13),table.addMany(r(64,127),10,12,13),table.addMany(r(64,127),9,12,13),table.addMany(EXECUTABLES,13,13,13),table.addMany(PRINTABLES,13,13,13),table.add(127,13,0,13),table.addMany([27,156],13,14,0),table.add(160,8,5,8),table}();var DcsDummy=function(){function DcsDummy(){}return DcsDummy.prototype.hook=function(collect,params,flag){},DcsDummy.prototype.put=function(data,start,end){},DcsDummy.prototype.unhook=function(){},DcsDummy}(),EscapeSequenceParser=function(_super){function EscapeSequenceParser(TRANSITIONS){void 0===TRANSITIONS&&(TRANSITIONS=exports.VT500_TRANSITION_TABLE);var _this=_super.call(this)||this;return _this.TRANSITIONS=TRANSITIONS,_this.initialState=0,_this.currentState=_this.initialState,_this._osc="",_this._params=[0],_this._collect="",_this._printHandlerFb=function(data,start,end){},_this._executeHandlerFb=function(code){},_this._csiHandlerFb=function(collect,params,flag){},_this._escHandlerFb=function(collect,flag){},_this._oscHandlerFb=function(identifier,data){},_this._dcsHandlerFb=new DcsDummy,_this._errorHandlerFb=function(state){return state},_this._printHandler=_this._printHandlerFb,_this._executeHandlers=Object.create(null),_this._csiHandlers=Object.create(null),_this._escHandlers=Object.create(null),_this._oscHandlers=Object.create(null),_this._dcsHandlers=Object.create(null),_this._activeDcsHandler=null,_this._errorHandler=_this._errorHandlerFb,_this.setEscHandler("\\",function(){}),_this}return __extends(EscapeSequenceParser,_super),EscapeSequenceParser.prototype.dispose=function(){this._printHandlerFb=null,this._executeHandlerFb=null,this._csiHandlerFb=null,this._escHandlerFb=null,this._oscHandlerFb=null,this._dcsHandlerFb=null,this._errorHandlerFb=null,this._printHandler=null,this._executeHandlers=null,this._escHandlers=null,this._csiHandlers=null,this._oscHandlers=null,this._dcsHandlers=null,this._activeDcsHandler=null,this._errorHandler=null},EscapeSequenceParser.prototype.setPrintHandler=function(callback){this._printHandler=callback},EscapeSequenceParser.prototype.clearPrintHandler=function(){this._printHandler=this._printHandlerFb},EscapeSequenceParser.prototype.setExecuteHandler=function(flag,callback){this._executeHandlers[flag.charCodeAt(0)]=callback},EscapeSequenceParser.prototype.clearExecuteHandler=function(flag){this._executeHandlers[flag.charCodeAt(0)]&&delete this._executeHandlers[flag.charCodeAt(0)]},EscapeSequenceParser.prototype.setExecuteHandlerFallback=function(callback){this._executeHandlerFb=callback},EscapeSequenceParser.prototype.addCsiHandler=function(flag,callback){var index=flag.charCodeAt(0);void 0===this._csiHandlers[index]&&(this._csiHandlers[index]=[]);var handlerList=this._csiHandlers[index];return handlerList.push(callback),{dispose:function(){var handlerIndex=handlerList.indexOf(callback);-1!==handlerIndex&&handlerList.splice(handlerIndex,1)}}},EscapeSequenceParser.prototype.setCsiHandler=function(flag,callback){this._csiHandlers[flag.charCodeAt(0)]=[callback]},EscapeSequenceParser.prototype.clearCsiHandler=function(flag){this._csiHandlers[flag.charCodeAt(0)]&&delete this._csiHandlers[flag.charCodeAt(0)]},EscapeSequenceParser.prototype.setCsiHandlerFallback=function(callback){this._csiHandlerFb=callback},EscapeSequenceParser.prototype.setEscHandler=function(collectAndFlag,callback){this._escHandlers[collectAndFlag]=callback},EscapeSequenceParser.prototype.clearEscHandler=function(collectAndFlag){this._escHandlers[collectAndFlag]&&delete this._escHandlers[collectAndFlag]},EscapeSequenceParser.prototype.setEscHandlerFallback=function(callback){this._escHandlerFb=callback},EscapeSequenceParser.prototype.addOscHandler=function(ident,callback){void 0===this._oscHandlers[ident]&&(this._oscHandlers[ident]=[]);var handlerList=this._oscHandlers[ident];return handlerList.push(callback),{dispose:function(){var handlerIndex=handlerList.indexOf(callback);-1!==handlerIndex&&handlerList.splice(handlerIndex,1)}}},EscapeSequenceParser.prototype.setOscHandler=function(ident,callback){this._oscHandlers[ident]=[callback]},EscapeSequenceParser.prototype.clearOscHandler=function(ident){this._oscHandlers[ident]&&delete this._oscHandlers[ident]},EscapeSequenceParser.prototype.setOscHandlerFallback=function(callback){this._oscHandlerFb=callback},EscapeSequenceParser.prototype.setDcsHandler=function(collectAndFlag,handler){this._dcsHandlers[collectAndFlag]=handler},EscapeSequenceParser.prototype.clearDcsHandler=function(collectAndFlag){this._dcsHandlers[collectAndFlag]&&delete this._dcsHandlers[collectAndFlag]},EscapeSequenceParser.prototype.setDcsHandlerFallback=function(handler){this._dcsHandlerFb=handler},EscapeSequenceParser.prototype.setErrorHandler=function(callback){this._errorHandler=callback},EscapeSequenceParser.prototype.clearErrorHandler=function(){this._errorHandler=this._errorHandlerFb},EscapeSequenceParser.prototype.reset=function(){this.currentState=this.initialState,this._osc="",this._params=[0],this._collect="",this._activeDcsHandler=null},EscapeSequenceParser.prototype.parse=function(data,length){for(var code=0,transition=0,error=!1,currentState=this.currentState,print=-1,dcs=-1,osc=this._osc,collect=this._collect,params=this._params,table=this.TRANSITIONS.table,dcsHandler=this._activeDcsHandler,callback=null,i=0;i<length;++i)if(code=data[i],0===currentState&&code>31&&code<128){print=~print?print:i;do{i++}while(i<length&&data[i]>31&&data[i]<128);i--}else if(4===currentState&&code>47&&code<57)params[params.length-1]=10*params[params.length-1]+code-48;else{switch((transition=table[currentState<<8|(code<160?code:160)])>>4){case 2:print=~print?print:i;break;case 3:~print&&(this._printHandler(data,print,i),print=-1),callback=this._executeHandlers[code],callback?callback():this._executeHandlerFb(code);break;case 0:~print?(this._printHandler(data,print,i),print=-1):~dcs&&(dcsHandler.put(data,dcs,i),dcs=-1);break;case 1:if(code>159)switch(currentState){case 0:print=~print?print:i;break;case 6:transition|=6;break;case 11:transition|=11;break;case 13:dcs=~dcs?dcs:i,transition|=13;break;default:error=!0}else error=!0;if(error){var inject=this._errorHandler({position:i,code:code,currentState:currentState,print:print,dcs:dcs,osc:osc,collect:collect,params:params,abort:!1});if(inject.abort)return;error=!1}break;case 7:for(var handlers=this._csiHandlers[code],j=handlers?handlers.length-1:-1;j>=0&&!handlers[j](params,collect);j--);j<0&&this._csiHandlerFb(collect,params,code);break;case 8:59===code?params.push(0):params[params.length-1]=10*params[params.length-1]+code-48;break;case 9:collect+=String.fromCharCode(code);break;case 10:callback=this._escHandlers[collect+String.fromCharCode(code)],callback?callback(collect,code):this._escHandlerFb(collect,code);break;case 11:~print&&(this._printHandler(data,print,i),print=-1),osc="",params=[0],collect="",dcs=-1;break;case 12:dcsHandler=this._dcsHandlers[collect+String.fromCharCode(code)],dcsHandler||(dcsHandler=this._dcsHandlerFb),dcsHandler.hook(collect,params,code);break;case 13:dcs=~dcs?dcs:i;break;case 14:dcsHandler&&(~dcs&&dcsHandler.put(data,dcs,i),dcsHandler.unhook(),dcsHandler=null),27===code&&(transition|=1),osc="",params=[0],collect="",dcs=-1;break;case 4:~print&&(this._printHandler(data,print,i),print=-1),osc="";break;case 5:for(var j_1=i+1;;j_1++)if(j_1>=length||(code=data[j_1])<32||code>127&&code<=159){osc+=TextDecoder_1.utf32ToString(data,i,j_1),i=j_1-1;break}break;case 6:if(osc&&24!==code&&26!==code){var idx=osc.indexOf(";");if(-1===idx)this._oscHandlerFb(-1,osc);else{for(var identifier=parseInt(osc.substring(0,idx)),content=osc.substring(idx+1),handlers_1=this._oscHandlers[identifier],j_2=handlers_1?handlers_1.length-1:-1;j_2>=0&&!handlers_1[j_2](content);j_2--);j_2<0&&this._oscHandlerFb(identifier,content)}}27===code&&(transition|=1),osc="",params=[0],collect="",dcs=-1}currentState=15&transition}0===currentState&&~print?this._printHandler(data,print,length):13===currentState&&~dcs&&dcsHandler&&dcsHandler.put(data,dcs,length),this._osc=osc,this._collect=collect,this._params=params,this._activeDcsHandler=dcsHandler,this.currentState=currentState},EscapeSequenceParser}(Lifecycle_1.Disposable);exports.EscapeSequenceParser=EscapeSequenceParser},{"./common/Lifecycle":20,"./core/input/TextDecoder":26}],9:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var _extendStatics5=function(d,b){return(_extendStatics5=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])})(d,b)};return function(d,b){function __(){this.constructor=d}_extendStatics5(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:!0});var EscapeSequences_1=require("./common/data/EscapeSequences"),Charsets_1=require("./core/data/Charsets"),Buffer_1=require("./Buffer"),CharWidth_1=require("./CharWidth"),EscapeSequenceParser_1=require("./EscapeSequenceParser"),Lifecycle_1=require("./common/Lifecycle"),TypedArrayUtils_1=require("./common/TypedArrayUtils"),TextDecoder_1=require("./core/input/TextDecoder"),GLEVEL={"(":0,")":1,"*":2,"+":3,"-":1,".":2},DECRQSS=function(){function DECRQSS(_terminal){this._terminal=_terminal,this._data=new Uint32Array(0)}return DECRQSS.prototype.hook=function(collect,params,flag){this._data=new Uint32Array(0)},DECRQSS.prototype.put=function(data,start,end){this._data=TypedArrayUtils_1.concat(this._data,data.subarray(start,end))},DECRQSS.prototype.unhook=function(){var data=TextDecoder_1.utf32ToString(this._data);switch(this._data=new Uint32Array(0),data){case'"q':return this._terminal.handler(EscapeSequences_1.C0.ESC+'P1$r0"q'+EscapeSequences_1.C0.ESC+"\\");case'"p':return this._terminal.handler(EscapeSequences_1.C0.ESC+'P1$r61"p'+EscapeSequences_1.C0.ESC+"\\");case"r":var pt=this._terminal.buffer.scrollTop+1+";"+(this._terminal.buffer.scrollBottom+1)+"r";return this._terminal.handler(EscapeSequences_1.C0.ESC+"P1$r"+pt+EscapeSequences_1.C0.ESC+"\\");case"m":return this._terminal.handler(EscapeSequences_1.C0.ESC+"P1$r0m"+EscapeSequences_1.C0.ESC+"\\");case" q":var STYLES={block:2,underline:4,bar:6},style=STYLES[this._terminal.getOption("cursorStyle")];return style-=this._terminal.getOption("cursorBlink"),this._terminal.handler(EscapeSequences_1.C0.ESC+"P1$r"+style+" q"+EscapeSequences_1.C0.ESC+"\\");default:this._terminal.error("Unknown DCS $q %s",data),this._terminal.handler(EscapeSequences_1.C0.ESC+"P0$r"+EscapeSequences_1.C0.ESC+"\\")}},DECRQSS}(),InputHandler=function(_super){function InputHandler(_terminal,_parser){void 0===_parser&&(_parser=new EscapeSequenceParser_1.EscapeSequenceParser);var _this=_super.call(this)||this;_this._terminal=_terminal,_this._parser=_parser,_this._parseBuffer=new Uint32Array(4096),_this._stringDecoder=new TextDecoder_1.StringToUtf32,_this.register(_this._parser),_this._parser.setCsiHandlerFallback(function(collect,params,flag){_this._terminal.error("Unknown CSI code: ",{collect:collect,params:params,flag:String.fromCharCode(flag)})}),_this._parser.setEscHandlerFallback(function(collect,flag){_this._terminal.error("Unknown ESC code: ",{collect:collect,flag:String.fromCharCode(flag)})}),_this._parser.setExecuteHandlerFallback(function(code){_this._terminal.error("Unknown EXECUTE code: ",{code:code})}),_this._parser.setOscHandlerFallback(function(identifier,data){_this._terminal.error("Unknown OSC code: ",{identifier:identifier,data:data})}),_this._parser.setPrintHandler(function(data,start,end){return _this.print(data,start,end)}),_this._parser.setCsiHandler("@",function(params,collect){return _this.insertChars(params)}),_this._parser.setCsiHandler("A",function(params,collect){return _this.cursorUp(params)}),_this._parser.setCsiHandler("B",function(params,collect){return _this.cursorDown(params)}),_this._parser.setCsiHandler("C",function(params,collect){return _this.cursorForward(params)}),_this._parser.setCsiHandler("D",function(params,collect){return _this.cursorBackward(params)}),_this._parser.setCsiHandler("E",function(params,collect){return _this.cursorNextLine(params)}),_this._parser.setCsiHandler("F",function(params,collect){return _this.cursorPrecedingLine(params)}),_this._parser.setCsiHandler("G",function(params,collect){return _this.cursorCharAbsolute(params)}),_this._parser.setCsiHandler("H",function(params,collect){return _this.cursorPosition(params)}),_this._parser.setCsiHandler("I",function(params,collect){return _this.cursorForwardTab(params)}),_this._parser.setCsiHandler("J",function(params,collect){return _this.eraseInDisplay(params)}),_this._parser.setCsiHandler("K",function(params,collect){return _this.eraseInLine(params)}),_this._parser.setCsiHandler("L",function(params,collect){return _this.insertLines(params)}),_this._parser.setCsiHandler("M",function(params,collect){return _this.deleteLines(params)}),_this._parser.setCsiHandler("P",function(params,collect){return _this.deleteChars(params)}),_this._parser.setCsiHandler("S",function(params,collect){return _this.scrollUp(params)}),_this._parser.setCsiHandler("T",function(params,collect){return _this.scrollDown(params,collect)}),_this._parser.setCsiHandler("X",function(params,collect){return _this.eraseChars(params)}),_this._parser.setCsiHandler("Z",function(params,collect){return _this.cursorBackwardTab(params)}),_this._parser.setCsiHandler("`",function(params,collect){return _this.charPosAbsolute(params)}),_this._parser.setCsiHandler("a",function(params,collect){return _this.hPositionRelative(params)}),_this._parser.setCsiHandler("b",function(params,collect){return _this.repeatPrecedingCharacter(params)}),_this._parser.setCsiHandler("c",function(params,collect){return _this.sendDeviceAttributes(params,collect)}),_this._parser.setCsiHandler("d",function(params,collect){return _this.linePosAbsolute(params)}),_this._parser.setCsiHandler("e",function(params,collect){return _this.vPositionRelative(params)}),_this._parser.setCsiHandler("f",function(params,collect){return _this.hVPosition(params)}),_this._parser.setCsiHandler("g",function(params,collect){return _this.tabClear(params)}),_this._parser.setCsiHandler("h",function(params,collect){return _this.setMode(params,collect)}),_this._parser.setCsiHandler("l",function(params,collect){return _this.resetMode(params,collect)}),_this._parser.setCsiHandler("m",function(params,collect){return _this.charAttributes(params)}),_this._parser.setCsiHandler("n",function(params,collect){return _this.deviceStatus(params,collect)}),_this._parser.setCsiHandler("p",function(params,collect){return _this.softReset(params,collect)}),_this._parser.setCsiHandler("q",function(params,collect){return _this.setCursorStyle(params,collect)}),_this._parser.setCsiHandler("r",function(params,collect){return _this.setScrollRegion(params,collect)}),_this._parser.setCsiHandler("s",function(params,collect){return _this.saveCursor(params)}),_this._parser.setCsiHandler("u",function(params,collect){return _this.restoreCursor(params)}),_this._parser.setExecuteHandler(EscapeSequences_1.C0.BEL,function(){return _this.bell()}),_this._parser.setExecuteHandler(EscapeSequences_1.C0.LF,function(){return _this.lineFeed()}),_this._parser.setExecuteHandler(EscapeSequences_1.C0.VT,function(){return _this.lineFeed()}),_this._parser.setExecuteHandler(EscapeSequences_1.C0.FF,function(){return _this.lineFeed()}),_this._parser.setExecuteHandler(EscapeSequences_1.C0.CR,function(){return _this.carriageReturn()}),_this._parser.setExecuteHandler(EscapeSequences_1.C0.BS,function(){return _this.backspace()}),_this._parser.setExecuteHandler(EscapeSequences_1.C0.HT,function(){return _this.tab()}),_this._parser.setExecuteHandler(EscapeSequences_1.C0.SO,function(){return _this.shiftOut()}),_this._parser.setExecuteHandler(EscapeSequences_1.C0.SI,function(){return _this.shiftIn()}),_this._parser.setExecuteHandler(EscapeSequences_1.C1.IND,function(){return _this.index()}),_this._parser.setExecuteHandler(EscapeSequences_1.C1.NEL,function(){return _this.nextLine()}),_this._parser.setExecuteHandler(EscapeSequences_1.C1.HTS,function(){return _this.tabSet()}),_this._parser.setOscHandler(0,function(data){return _this.setTitle(data)}),_this._parser.setOscHandler(2,function(data){return _this.setTitle(data)}),_this._parser.setEscHandler("7",function(){return _this.saveCursor([])}),_this._parser.setEscHandler("8",function(){return _this.restoreCursor([])}),_this._parser.setEscHandler("D",function(){return _this.index()}),_this._parser.setEscHandler("E",function(){return _this.nextLine()}),_this._parser.setEscHandler("H",function(){return _this.tabSet()}),_this._parser.setEscHandler("M",function(){return _this.reverseIndex()}),_this._parser.setEscHandler("=",function(){return _this.keypadApplicationMode()}),_this._parser.setEscHandler(">",function(){return _this.keypadNumericMode()}),_this._parser.setEscHandler("c",function(){return _this.reset()}),_this._parser.setEscHandler("n",function(){return _this.setgLevel(2)}),_this._parser.setEscHandler("o",function(){return _this.setgLevel(3)}),_this._parser.setEscHandler("|",function(){return _this.setgLevel(3)}),_this._parser.setEscHandler("}",function(){return _this.setgLevel(2)}),_this._parser.setEscHandler("~",function(){return _this.setgLevel(1)}),_this._parser.setEscHandler("%@",function(){return _this.selectDefaultCharset()}),_this._parser.setEscHandler("%G",function(){return _this.selectDefaultCharset()});var this_1=this;for(var flag in Charsets_1.CHARSETS)!function(flag){this_1._parser.setEscHandler("("+flag,function(){return _this.selectCharset("("+flag)}),this_1._parser.setEscHandler(")"+flag,function(){return _this.selectCharset(")"+flag)}),this_1._parser.setEscHandler("*"+flag,function(){return _this.selectCharset("*"+flag)}),this_1._parser.setEscHandler("+"+flag,function(){return _this.selectCharset("+"+flag)}),this_1._parser.setEscHandler("-"+flag,function(){return _this.selectCharset("-"+flag)}),this_1._parser.setEscHandler("."+flag,function(){return _this.selectCharset("."+flag)}),this_1._parser.setEscHandler("/"+flag,function(){return _this.selectCharset("/"+flag)})}(flag);return _this._parser.setErrorHandler(function(state){return _this._terminal.error("Parsing error: ",state),state}),_this._parser.setDcsHandler("$q",new DECRQSS(_this._terminal)),_this}return __extends(InputHandler,_super),InputHandler.prototype.dispose=function(){_super.prototype.dispose.call(this),this._terminal=null},InputHandler.prototype.parse=function(data){if(this._terminal){var buffer=this._terminal.buffer,cursorStartX=buffer.x,cursorStartY=buffer.y;this._terminal.debug&&this._terminal.log("data: "+data),this._parseBuffer.length<data.length&&(this._parseBuffer=new Uint32Array(data.length));for(var i=0;i<data.length;++i)this._parseBuffer[i]=data.charCodeAt(i);this._parser.parse(this._parseBuffer,this._stringDecoder.decode(data,this._parseBuffer)),buffer=this._terminal.buffer,buffer.x===cursorStartX&&buffer.y===cursorStartY||this._terminal.emit("cursormove")}},InputHandler.prototype.print=function(data,start,end){var code,_char4,chWidth,buffer=this._terminal.buffer,charset=this._terminal.charset,screenReaderMode=this._terminal.options.screenReaderMode,cols=this._terminal.cols,wraparoundMode=this._terminal.wraparoundMode,insertMode=this._terminal.insertMode,curAttr=this._terminal.curAttr,bufferRow=buffer.lines.get(buffer.y+buffer.ybase);this._terminal.updateRange(buffer.y);for(var pos=start;pos<end;++pos){if(code=data[pos],_char4=TextDecoder_1.stringFromCodePoint(code),chWidth=CharWidth_1.wcwidth(code),code<127&&charset){var ch=charset[_char4];ch&&(code=ch.charCodeAt(0),_char4=ch)}if(screenReaderMode&&this._terminal.emit("a11y.char",_char4),chWidth||!buffer.x){if(buffer.x+chWidth-1>=cols)if(wraparoundMode)buffer.x=0,buffer.y++,buffer.y>buffer.scrollBottom?(buffer.y--,this._terminal.scroll(!0)):buffer.lines.get(buffer.y).isWrapped=!0,bufferRow=buffer.lines.get(buffer.y+buffer.ybase);else if(2===chWidth)continue;if(insertMode){bufferRow.insertCells(buffer.x,chWidth,[curAttr,Buffer_1.NULL_CELL_CHAR,Buffer_1.NULL_CELL_WIDTH,Buffer_1.NULL_CELL_CODE]);2===bufferRow.get(cols-1)[Buffer_1.CHAR_DATA_WIDTH_INDEX]&&bufferRow.set(cols-1,[curAttr,Buffer_1.NULL_CELL_CHAR,Buffer_1.NULL_CELL_WIDTH,Buffer_1.NULL_CELL_CODE])}if(bufferRow.set(buffer.x++,[curAttr,_char4,chWidth,code]),chWidth>0)for(;--chWidth;)bufferRow.set(buffer.x++,[curAttr,"",0,void 0])}else{var chMinusOne=bufferRow.get(buffer.x-1);if(chMinusOne)if(chMinusOne[Buffer_1.CHAR_DATA_WIDTH_INDEX])chMinusOne[Buffer_1.CHAR_DATA_CHAR_INDEX]+=_char4,chMinusOne[Buffer_1.CHAR_DATA_CODE_INDEX]=code,bufferRow.set(buffer.x-1,chMinusOne);else{var chMinusTwo=bufferRow.get(buffer.x-2);chMinusTwo&&(chMinusTwo[Buffer_1.CHAR_DATA_CHAR_INDEX]+=_char4,chMinusTwo[Buffer_1.CHAR_DATA_CODE_INDEX]=code,bufferRow.set(buffer.x-2,chMinusTwo))}}}this._terminal.updateRange(buffer.y)},InputHandler.prototype.addCsiHandler=function(flag,callback){return this._parser.addCsiHandler(flag,callback)},InputHandler.prototype.addOscHandler=function(ident,callback){return this._parser.addOscHandler(ident,callback)},InputHandler.prototype.bell=function(){this._terminal.bell()},InputHandler.prototype.lineFeed=function(){var buffer=this._terminal.buffer;this._terminal.options.convertEol&&(buffer.x=0),buffer.y++,buffer.y>buffer.scrollBottom&&(buffer.y--,this._terminal.scroll()),buffer.x>=this._terminal.cols&&buffer.x--,this._terminal.emit("linefeed")},InputHandler.prototype.carriageReturn=function(){this._terminal.buffer.x=0},InputHandler.prototype.backspace=function(){this._terminal.buffer.x>0&&this._terminal.buffer.x--},InputHandler.prototype.tab=function(){var originalX=this._terminal.buffer.x;this._terminal.buffer.x=this._terminal.buffer.nextStop(),this._terminal.options.screenReaderMode&&this._terminal.emit("a11y.tab",this._terminal.buffer.x-originalX)},InputHandler.prototype.shiftOut=function(){this._terminal.setgLevel(1)},InputHandler.prototype.shiftIn=function(){this._terminal.setgLevel(0)},InputHandler.prototype.insertChars=function(params){this._terminal.buffer.lines.get(this._terminal.buffer.y+this._terminal.buffer.ybase).insertCells(this._terminal.buffer.x,params[0]||1,[this._terminal.eraseAttr(),Buffer_1.NULL_CELL_CHAR,Buffer_1.NULL_CELL_WIDTH,Buffer_1.NULL_CELL_CODE]),this._terminal.updateRange(this._terminal.buffer.y)},InputHandler.prototype.cursorUp=function(params){var param=params[0];param<1&&(param=1),this._terminal.buffer.y-=param,this._terminal.buffer.y<0&&(this._terminal.buffer.y=0)},InputHandler.prototype.cursorDown=function(params){var param=params[0];param<1&&(param=1),this._terminal.buffer.y+=param,this._terminal.buffer.y>=this._terminal.rows&&(this._terminal.buffer.y=this._terminal.rows-1),this._terminal.buffer.x>=this._terminal.cols&&this._terminal.buffer.x--},InputHandler.prototype.cursorForward=function(params){var param=params[0];param<1&&(param=1),this._terminal.buffer.x+=param,this._terminal.buffer.x>=this._terminal.cols&&(this._terminal.buffer.x=this._terminal.cols-1)},InputHandler.prototype.cursorBackward=function(params){var param=params[0];param<1&&(param=1),this._terminal.buffer.x>=this._terminal.cols&&this._terminal.buffer.x--,this._terminal.buffer.x-=param,this._terminal.buffer.x<0&&(this._terminal.buffer.x=0)},InputHandler.prototype.cursorNextLine=function(params){var param=params[0];param<1&&(param=1),this._terminal.buffer.y+=param,this._terminal.buffer.y>=this._terminal.rows&&(this._terminal.buffer.y=this._terminal.rows-1),this._terminal.buffer.x=0},InputHandler.prototype.cursorPrecedingLine=function(params){var param=params[0];param<1&&(param=1),this._terminal.buffer.y-=param,this._terminal.buffer.y<0&&(this._terminal.buffer.y=0),this._terminal.buffer.x=0},InputHandler.prototype.cursorCharAbsolute=function(params){var param=params[0];param<1&&(param=1),this._terminal.buffer.x=param-1},InputHandler.prototype.cursorPosition=function(params){var col,row=params[0]-1;col=params.length>=2?params[1]-1:0,row<0?row=0:row>=this._terminal.rows&&(row=this._terminal.rows-1),col<0?col=0:col>=this._terminal.cols&&(col=this._terminal.cols-1),this._terminal.buffer.x=col,this._terminal.buffer.y=row},InputHandler.prototype.cursorForwardTab=function(params){for(var param=params[0]||1;param--;)this._terminal.buffer.x=this._terminal.buffer.nextStop()},InputHandler.prototype._eraseInBufferLine=function(y,start,end,clearWrap){void 0===clearWrap&&(clearWrap=!1);var line=this._terminal.buffer.lines.get(this._terminal.buffer.ybase+y);line.replaceCells(start,end,[this._terminal.eraseAttr(),Buffer_1.NULL_CELL_CHAR,Buffer_1.NULL_CELL_WIDTH,Buffer_1.NULL_CELL_CODE]),clearWrap&&(line.isWrapped=!1)},InputHandler.prototype._resetBufferLine=function(y){this._eraseInBufferLine(y,0,this._terminal.cols,!0)},InputHandler.prototype.eraseInDisplay=function(params){var j;switch(params[0]){case 0:for(j=this._terminal.buffer.y,this._terminal.updateRange(j),this._eraseInBufferLine(j++,this._terminal.buffer.x,this._terminal.cols,0===this._terminal.buffer.x);j<this._terminal.rows;j++)this._resetBufferLine(j);this._terminal.updateRange(j);break;case 1:for(j=this._terminal.buffer.y,this._terminal.updateRange(j),this._eraseInBufferLine(j,0,this._terminal.buffer.x+1,!0),this._terminal.buffer.x+1>=this._terminal.cols&&(this._terminal.buffer.lines.get(j+1).isWrapped=!1);j--;)this._resetBufferLine(j);this._terminal.updateRange(0);break;case 2:for(j=this._terminal.rows,this._terminal.updateRange(j-1);j--;)this._resetBufferLine(j);this._terminal.updateRange(0);break;case 3:var scrollBackSize=this._terminal.buffer.lines.length-this._terminal.rows;scrollBackSize>0&&(this._terminal.buffer.lines.trimStart(scrollBackSize),this._terminal.buffer.ybase=Math.max(this._terminal.buffer.ybase-scrollBackSize,0),this._terminal.buffer.ydisp=Math.max(this._terminal.buffer.ydisp-scrollBackSize,0),this._terminal.emit("scroll",0))}},InputHandler.prototype.eraseInLine=function(params){switch(params[0]){case 0:this._eraseInBufferLine(this._terminal.buffer.y,this._terminal.buffer.x,this._terminal.cols);break;case 1:this._eraseInBufferLine(this._terminal.buffer.y,0,this._terminal.buffer.x+1);break;case 2:this._eraseInBufferLine(this._terminal.buffer.y,0,this._terminal.cols)}this._terminal.updateRange(this._terminal.buffer.y)},InputHandler.prototype.insertLines=function(params){var param=params[0];param<1&&(param=1);for(var buffer=this._terminal.buffer,row=buffer.y+buffer.ybase,scrollBottomRowsOffset=this._terminal.rows-1-buffer.scrollBottom,scrollBottomAbsolute=this._terminal.rows-1+buffer.ybase-scrollBottomRowsOffset+1;param--;)buffer.lines.splice(scrollBottomAbsolute-1,1),buffer.lines.splice(row,0,buffer.getBlankLine(this._terminal.eraseAttr()));this._terminal.updateRange(buffer.y),this._terminal.updateRange(buffer.scrollBottom)},InputHandler.prototype.deleteLines=function(params){var param=params[0];param<1&&(param=1);var j,buffer=this._terminal.buffer,row=buffer.y+buffer.ybase;for(j=this._terminal.rows-1-buffer.scrollBottom,j=this._terminal.rows-1+buffer.ybase-j;param--;)buffer.lines.splice(row,1),buffer.lines.splice(j,0,buffer.getBlankLine(this._terminal.eraseAttr()));this._terminal.updateRange(buffer.y),this._terminal.updateRange(buffer.scrollBottom)},InputHandler.prototype.deleteChars=function(params){this._terminal.buffer.lines.get(this._terminal.buffer.y+this._terminal.buffer.ybase).deleteCells(this._terminal.buffer.x,params[0]||1,[this._terminal.eraseAttr(),Buffer_1.NULL_CELL_CHAR,Buffer_1.NULL_CELL_WIDTH,Buffer_1.NULL_CELL_CODE]),this._terminal.updateRange(this._terminal.buffer.y)},InputHandler.prototype.scrollUp=function(params){for(var param=params[0]||1,buffer=this._terminal.buffer;param--;)buffer.lines.splice(buffer.ybase+buffer.scrollTop,1),buffer.lines.splice(buffer.ybase+buffer.scrollBottom,0,buffer.getBlankLine(Buffer_1.DEFAULT_ATTR));this._terminal.updateRange(buffer.scrollTop),this._terminal.updateRange(buffer.scrollBottom)},InputHandler.prototype.scrollDown=function(params,collect){if(params.length<2&&!collect){for(var param=params[0]||1,buffer=this._terminal.buffer;param--;)buffer.lines.splice(buffer.ybase+buffer.scrollBottom,1),buffer.lines.splice(buffer.ybase+buffer.scrollBottom,0,buffer.getBlankLine(Buffer_1.DEFAULT_ATTR));this._terminal.updateRange(buffer.scrollTop),this._terminal.updateRange(buffer.scrollBottom)}},InputHandler.prototype.eraseChars=function(params){this._terminal.buffer.lines.get(this._terminal.buffer.y+this._terminal.buffer.ybase).replaceCells(this._terminal.buffer.x,this._terminal.buffer.x+(params[0]||1),[this._terminal.eraseAttr(),Buffer_1.NULL_CELL_CHAR,Buffer_1.NULL_CELL_WIDTH,Buffer_1.NULL_CELL_CODE])},InputHandler.prototype.cursorBackwardTab=function(params){
for(var param=params[0]||1,buffer=this._terminal.buffer;param--;)buffer.x=buffer.prevStop()},InputHandler.prototype.charPosAbsolute=function(params){var param=params[0];param<1&&(param=1),this._terminal.buffer.x=param-1,this._terminal.buffer.x>=this._terminal.cols&&(this._terminal.buffer.x=this._terminal.cols-1)},InputHandler.prototype.hPositionRelative=function(params){var param=params[0];param<1&&(param=1),this._terminal.buffer.x+=param,this._terminal.buffer.x>=this._terminal.cols&&(this._terminal.buffer.x=this._terminal.cols-1)},InputHandler.prototype.repeatPrecedingCharacter=function(params){var buffer=this._terminal.buffer,line=buffer.lines.get(buffer.ybase+buffer.y);line.replaceCells(buffer.x,buffer.x+(params[0]||1),line.get(buffer.x-1)||[Buffer_1.DEFAULT_ATTR,Buffer_1.NULL_CELL_CHAR,Buffer_1.NULL_CELL_WIDTH,Buffer_1.NULL_CELL_CODE])},InputHandler.prototype.sendDeviceAttributes=function(params,collect){params[0]>0||(collect?">"===collect&&(this._terminal.is("xterm")?this._terminal.handler(EscapeSequences_1.C0.ESC+"[>0;276;0c"):this._terminal.is("rxvt-unicode")?this._terminal.handler(EscapeSequences_1.C0.ESC+"[>85;95;0c"):this._terminal.is("linux")?this._terminal.handler(params[0]+"c"):this._terminal.is("screen")&&this._terminal.handler(EscapeSequences_1.C0.ESC+"[>83;40003;0c")):this._terminal.is("xterm")||this._terminal.is("rxvt-unicode")||this._terminal.is("screen")?this._terminal.handler(EscapeSequences_1.C0.ESC+"[?1;2c"):this._terminal.is("linux")&&this._terminal.handler(EscapeSequences_1.C0.ESC+"[?6c"))},InputHandler.prototype.linePosAbsolute=function(params){var param=params[0];param<1&&(param=1),this._terminal.buffer.y=param-1,this._terminal.buffer.y>=this._terminal.rows&&(this._terminal.buffer.y=this._terminal.rows-1)},InputHandler.prototype.vPositionRelative=function(params){var param=params[0];param<1&&(param=1),this._terminal.buffer.y+=param,this._terminal.buffer.y>=this._terminal.rows&&(this._terminal.buffer.y=this._terminal.rows-1),this._terminal.buffer.x>=this._terminal.cols&&this._terminal.buffer.x--},InputHandler.prototype.hVPosition=function(params){params[0]<1&&(params[0]=1),params[1]<1&&(params[1]=1),this._terminal.buffer.y=params[0]-1,this._terminal.buffer.y>=this._terminal.rows&&(this._terminal.buffer.y=this._terminal.rows-1),this._terminal.buffer.x=params[1]-1,this._terminal.buffer.x>=this._terminal.cols&&(this._terminal.buffer.x=this._terminal.cols-1)},InputHandler.prototype.tabClear=function(params){var param=params[0];param<=0?delete this._terminal.buffer.tabs[this._terminal.buffer.x]:3===param&&(this._terminal.buffer.tabs={})},InputHandler.prototype.setMode=function(params,collect){if(params.length>1)for(var i=0;i<params.length;i++)this.setMode([params[i]]);else if(collect){if("?"===collect)switch(params[0]){case 1:this._terminal.applicationCursor=!0;break;case 2:this._terminal.setgCharset(0,Charsets_1.DEFAULT_CHARSET),this._terminal.setgCharset(1,Charsets_1.DEFAULT_CHARSET),this._terminal.setgCharset(2,Charsets_1.DEFAULT_CHARSET),this._terminal.setgCharset(3,Charsets_1.DEFAULT_CHARSET);break;case 3:this._terminal.savedCols=this._terminal.cols,this._terminal.resize(132,this._terminal.rows);break;case 6:this._terminal.originMode=!0;break;case 7:this._terminal.wraparoundMode=!0;break;case 12:break;case 66:this._terminal.log("Serial port requested application keypad."),this._terminal.applicationKeypad=!0,this._terminal.viewport&&this._terminal.viewport.syncScrollArea();break;case 9:case 1e3:case 1002:case 1003:this._terminal.x10Mouse=9===params[0],this._terminal.vt200Mouse=1e3===params[0],this._terminal.normalMouse=params[0]>1e3,this._terminal.mouseEvents=!0,this._terminal.element&&this._terminal.element.classList.add("enable-mouse-events"),this._terminal.selectionManager.disable(),this._terminal.log("Binding to mouse events.");break;case 1004:this._terminal.sendFocus=!0;break;case 1005:this._terminal.utfMouse=!0;break;case 1006:this._terminal.sgrMouse=!0;break;case 1015:this._terminal.urxvtMouse=!0;break;case 25:this._terminal.cursorHidden=!1;break;case 1048:this.saveCursor(params);break;case 1049:this.saveCursor(params);case 47:case 1047:this._terminal.buffers.activateAltBuffer(this._terminal.eraseAttr()),this._terminal.refresh(0,this._terminal.rows-1),this._terminal.viewport&&this._terminal.viewport.syncScrollArea(),this._terminal.showCursor();break;case 2004:this._terminal.bracketedPasteMode=!0}}else switch(params[0]){case 4:this._terminal.insertMode=!0}},InputHandler.prototype.resetMode=function(params,collect){if(params.length>1)for(var i=0;i<params.length;i++)this.resetMode([params[i]]);else if(collect){if("?"===collect)switch(params[0]){case 1:this._terminal.applicationCursor=!1;break;case 3:132===this._terminal.cols&&this._terminal.savedCols&&this._terminal.resize(this._terminal.savedCols,this._terminal.rows),delete this._terminal.savedCols;break;case 6:this._terminal.originMode=!1;break;case 7:this._terminal.wraparoundMode=!1;break;case 12:break;case 66:this._terminal.log("Switching back to normal keypad."),this._terminal.applicationKeypad=!1,this._terminal.viewport&&this._terminal.viewport.syncScrollArea();break;case 9:case 1e3:case 1002:case 1003:this._terminal.x10Mouse=!1,this._terminal.vt200Mouse=!1,this._terminal.normalMouse=!1,this._terminal.mouseEvents=!1,this._terminal.element&&this._terminal.element.classList.remove("enable-mouse-events"),this._terminal.selectionManager.enable();break;case 1004:this._terminal.sendFocus=!1;break;case 1005:this._terminal.utfMouse=!1;break;case 1006:this._terminal.sgrMouse=!1;break;case 1015:this._terminal.urxvtMouse=!1;break;case 25:this._terminal.cursorHidden=!0;break;case 1048:this.restoreCursor(params);break;case 1049:case 47:case 1047:this._terminal.buffers.activateNormalBuffer(),1049===params[0]&&this.restoreCursor(params),this._terminal.refresh(0,this._terminal.rows-1),this._terminal.viewport&&this._terminal.viewport.syncScrollArea(),this._terminal.showCursor();break;case 2004:this._terminal.bracketedPasteMode=!1}}else switch(params[0]){case 4:this._terminal.insertMode=!1}},InputHandler.prototype.charAttributes=function(params){if(1===params.length&&0===params[0])return void(this._terminal.curAttr=Buffer_1.DEFAULT_ATTR);for(var p,l=params.length,flags=this._terminal.curAttr>>18,fg=this._terminal.curAttr>>9&511,bg=511&this._terminal.curAttr,i=0;i<l;i++)p=params[i],p>=30&&p<=37?fg=p-30:p>=40&&p<=47?bg=p-40:p>=90&&p<=97?(p+=8,fg=p-90):p>=100&&p<=107?(p+=8,bg=p-100):0===p?(flags=Buffer_1.DEFAULT_ATTR>>18,fg=Buffer_1.DEFAULT_ATTR>>9&511,bg=511&Buffer_1.DEFAULT_ATTR):1===p?flags|=1:3===p?flags|=64:4===p?flags|=2:5===p?flags|=4:7===p?flags|=8:8===p?flags|=16:2===p?flags|=32:22===p?(flags&=-2,flags&=-33):23===p?flags&=-65:24===p?flags&=-3:25===p?flags&=-5:27===p?flags&=-9:28===p?flags&=-17:39===p?fg=Buffer_1.DEFAULT_ATTR>>9&511:49===p?bg=511&Buffer_1.DEFAULT_ATTR:38===p?2===params[i+1]?(i+=2,fg=this._terminal.matchColor(255&params[i],255&params[i+1],255&params[i+2]),-1===fg&&(fg=511),i+=2):5===params[i+1]&&(i+=2,p=255&params[i],fg=p):48===p?2===params[i+1]?(i+=2,bg=this._terminal.matchColor(255&params[i],255&params[i+1],255&params[i+2]),-1===bg&&(bg=511),i+=2):5===params[i+1]&&(i+=2,p=255&params[i],bg=p):100===p?(fg=Buffer_1.DEFAULT_ATTR>>9&511,bg=511&Buffer_1.DEFAULT_ATTR):this._terminal.error("Unknown SGR attribute: %d.",p);this._terminal.curAttr=flags<<18|fg<<9|bg},InputHandler.prototype.deviceStatus=function(params,collect){if(collect){if("?"===collect)switch(params[0]){case 6:var y=this._terminal.buffer.y+1,x=this._terminal.buffer.x+1;this._terminal.emit("data",EscapeSequences_1.C0.ESC+"[?"+y+";"+x+"R")}}else switch(params[0]){case 5:this._terminal.emit("data",EscapeSequences_1.C0.ESC+"[0n");break;case 6:var y=this._terminal.buffer.y+1,x=this._terminal.buffer.x+1;this._terminal.emit("data",EscapeSequences_1.C0.ESC+"["+y+";"+x+"R")}},InputHandler.prototype.softReset=function(params,collect){"!"===collect&&(this._terminal.cursorHidden=!1,this._terminal.insertMode=!1,this._terminal.originMode=!1,this._terminal.wraparoundMode=!0,this._terminal.applicationKeypad=!1,this._terminal.viewport&&this._terminal.viewport.syncScrollArea(),this._terminal.applicationCursor=!1,this._terminal.buffer.scrollTop=0,this._terminal.buffer.scrollBottom=this._terminal.rows-1,this._terminal.curAttr=Buffer_1.DEFAULT_ATTR,this._terminal.buffer.x=this._terminal.buffer.y=0,this._terminal.charset=null,this._terminal.glevel=0,this._terminal.charsets=[null])},InputHandler.prototype.setCursorStyle=function(params,collect){if(" "===collect){var param=params[0]<1?1:params[0];switch(param){case 1:case 2:this._terminal.setOption("cursorStyle","block");break;case 3:case 4:this._terminal.setOption("cursorStyle","underline");break;case 5:case 6:this._terminal.setOption("cursorStyle","bar")}var isBlinking=param%2==1;this._terminal.setOption("cursorBlink",isBlinking)}},InputHandler.prototype.setScrollRegion=function(params,collect){collect||(this._terminal.buffer.scrollTop=(params[0]||1)-1,this._terminal.buffer.scrollBottom=(params[1]&&params[1]<=this._terminal.rows?params[1]:this._terminal.rows)-1,this._terminal.buffer.x=0,this._terminal.buffer.y=0)},InputHandler.prototype.saveCursor=function(params){this._terminal.buffer.savedX=this._terminal.buffer.x,this._terminal.buffer.savedY=this._terminal.buffer.y,this._terminal.buffer.savedCurAttr=this._terminal.curAttr},InputHandler.prototype.restoreCursor=function(params){this._terminal.buffer.x=this._terminal.buffer.savedX||0,this._terminal.buffer.y=this._terminal.buffer.savedY||0,this._terminal.curAttr=this._terminal.buffer.savedCurAttr||Buffer_1.DEFAULT_ATTR},InputHandler.prototype.setTitle=function(data){this._terminal.handleTitle(data)},InputHandler.prototype.nextLine=function(){this._terminal.buffer.x=0,this.index()},InputHandler.prototype.keypadApplicationMode=function(){this._terminal.log("Serial port requested application keypad."),this._terminal.applicationKeypad=!0,this._terminal.viewport&&this._terminal.viewport.syncScrollArea()},InputHandler.prototype.keypadNumericMode=function(){this._terminal.log("Switching back to normal keypad."),this._terminal.applicationKeypad=!1,this._terminal.viewport&&this._terminal.viewport.syncScrollArea()},InputHandler.prototype.selectDefaultCharset=function(){this._terminal.setgLevel(0),this._terminal.setgCharset(0,Charsets_1.DEFAULT_CHARSET)},InputHandler.prototype.selectCharset=function(collectAndFlag){if(2!==collectAndFlag.length)return this.selectDefaultCharset();"/"!==collectAndFlag[0]&&this._terminal.setgCharset(GLEVEL[collectAndFlag[0]],Charsets_1.CHARSETS[collectAndFlag[1]]||Charsets_1.DEFAULT_CHARSET)},InputHandler.prototype.index=function(){this._terminal.index()},InputHandler.prototype.tabSet=function(){this._terminal.tabSet()},InputHandler.prototype.reverseIndex=function(){this._terminal.reverseIndex()},InputHandler.prototype.reset=function(){this._parser.reset(),this._terminal.reset()},InputHandler.prototype.setgLevel=function(level){this._terminal.setgLevel(level)},InputHandler}(Lifecycle_1.Disposable);exports.InputHandler=InputHandler},{"./Buffer":2,"./CharWidth":6,"./EscapeSequenceParser":8,"./common/Lifecycle":20,"./common/TypedArrayUtils":21,"./common/data/EscapeSequences":22,"./core/data/Charsets":24,"./core/input/TextDecoder":26}],10:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var _extendStatics6=function(d,b){return(_extendStatics6=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])})(d,b)};return function(d,b){function __(){this.constructor=d}_extendStatics6(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:!0});var MouseZoneManager_1=require("./ui/MouseZoneManager"),EventEmitter_1=require("./common/EventEmitter"),Buffer_1=require("./Buffer"),CharWidth_1=require("./CharWidth"),Linkifier=function(_super){function Linkifier(_terminal){var _this=_super.call(this)||this;return _this._terminal=_terminal,_this._linkMatchers=[],_this._nextLinkMatcherId=0,_this._rowsToLinkify={start:null,end:null},_this}return __extends(Linkifier,_super),Linkifier.prototype.attachToDom=function(mouseZoneManager){this._mouseZoneManager=mouseZoneManager},Linkifier.prototype.linkifyRows=function(start,end){var _this=this;this._mouseZoneManager&&(null===this._rowsToLinkify.start?(this._rowsToLinkify.start=start,this._rowsToLinkify.end=end):(this._rowsToLinkify.start=Math.min(this._rowsToLinkify.start,start),this._rowsToLinkify.end=Math.max(this._rowsToLinkify.end,end)),this._mouseZoneManager.clearAll(start,end),this._rowsTimeoutId&&clearTimeout(this._rowsTimeoutId),this._rowsTimeoutId=setTimeout(function(){return _this._linkifyRows()},Linkifier.TIME_BEFORE_LINKIFY))},Linkifier.prototype._linkifyRows=function(){this._rowsTimeoutId=null;var buffer=this._terminal.buffer,absoluteRowIndexStart=buffer.ydisp+this._rowsToLinkify.start;if(!(absoluteRowIndexStart>=buffer.lines.length)){for(var absoluteRowIndexEnd=buffer.ydisp+Math.min(this._rowsToLinkify.end,this._terminal.rows)+1,overscanLineLimit=Math.ceil(Linkifier.OVERSCAN_CHAR_LIMIT/this._terminal.cols),iterator=this._terminal.buffer.iterator(!1,absoluteRowIndexStart,absoluteRowIndexEnd,overscanLineLimit,overscanLineLimit);iterator.hasNext();)for(var lineData=iterator.next(),i=0;i<this._linkMatchers.length;i++)this._doLinkifyRow(lineData.range.first,lineData.content,this._linkMatchers[i]);this._rowsToLinkify.start=null,this._rowsToLinkify.end=null}},Linkifier.prototype.registerLinkMatcher=function(regex,handler,options){if(void 0===options&&(options={}),!handler)throw new Error("handler must be defined");var matcher={id:this._nextLinkMatcherId++,regex:regex,handler:handler,matchIndex:options.matchIndex,validationCallback:options.validationCallback,hoverTooltipCallback:options.tooltipCallback,hoverLeaveCallback:options.leaveCallback,willLinkActivate:options.willLinkActivate,priority:options.priority||0};return this._addLinkMatcherToList(matcher),matcher.id},Linkifier.prototype._addLinkMatcherToList=function(matcher){if(0===this._linkMatchers.length)return void this._linkMatchers.push(matcher);for(var i=this._linkMatchers.length-1;i>=0;i--)if(matcher.priority<=this._linkMatchers[i].priority)return void this._linkMatchers.splice(i+1,0,matcher);this._linkMatchers.splice(0,0,matcher)},Linkifier.prototype.deregisterLinkMatcher=function(matcherId){for(var i=0;i<this._linkMatchers.length;i++)if(this._linkMatchers[i].id===matcherId)return this._linkMatchers.splice(i,1),!0;return!1},Linkifier.prototype._doLinkifyRow=function(rowIndex,text,matcher){for(var match,_this=this,rex=new RegExp(matcher.regex.source,matcher.regex.flags+"g"),stringIndex=-1,this_1=this;null!==(match=rex.exec(text));){if("break"===function(){var uri=match["number"!=typeof matcher.matchIndex?0:matcher.matchIndex];if(!uri){if(this_1._terminal.debug)throw console.log({match:match,matcher:matcher}),new Error("match found without corresponding matchIndex");return"break"}if(stringIndex=text.indexOf(uri,stringIndex+1),rex.lastIndex=stringIndex+uri.length,stringIndex<0)return"break";var bufferIndex=this_1._terminal.buffer.stringIndexToBufferIndex(rowIndex,stringIndex);if(bufferIndex[0]<0)return"break";var fg,line=this_1._terminal.buffer.lines.get(bufferIndex[0]),_char5=line.get(bufferIndex[1]);if(_char5){var attr=_char5[Buffer_1.CHAR_DATA_ATTR_INDEX];fg=attr>>9&511}matcher.validationCallback?matcher.validationCallback(uri,function(isValid){_this._rowsTimeoutId||isValid&&_this._addLink(bufferIndex[1],bufferIndex[0]-_this._terminal.buffer.ydisp,uri,matcher,fg)}):this_1._addLink(bufferIndex[1],bufferIndex[0]-this_1._terminal.buffer.ydisp,uri,matcher,fg)}())break}},Linkifier.prototype._addLink=function(x,y,uri,matcher,fg){var _this=this,width=CharWidth_1.getStringCellWidth(uri),x1=x%this._terminal.cols,y1=y+Math.floor(x/this._terminal.cols),x2=(x1+width)%this._terminal.cols,y2=y1+Math.floor((x1+width)/this._terminal.cols);0===x2&&(x2=this._terminal.cols,y2--),this._mouseZoneManager.add(new MouseZoneManager_1.MouseZone(x1+1,y1+1,x2+1,y2+1,function(e){if(matcher.handler)return matcher.handler(e,uri);window.open(uri,"_blank")},function(e){_this.emit("linkhover",_this._createLinkHoverEvent(x1,y1,x2,y2,fg)),_this._terminal.element.classList.add("xterm-cursor-pointer")},function(e){_this.emit("linktooltip",_this._createLinkHoverEvent(x1,y1,x2,y2,fg)),matcher.hoverTooltipCallback&&matcher.hoverTooltipCallback(e,uri)},function(){_this.emit("linkleave",_this._createLinkHoverEvent(x1,y1,x2,y2,fg)),_this._terminal.element.classList.remove("xterm-cursor-pointer"),matcher.hoverLeaveCallback&&matcher.hoverLeaveCallback()},function(e){return!matcher.willLinkActivate||matcher.willLinkActivate(e,uri)}))},Linkifier.prototype._createLinkHoverEvent=function(x1,y1,x2,y2,fg){return{x1:x1,y1:y1,x2:x2,y2:y2,cols:this._terminal.cols,fg:fg}},Linkifier.TIME_BEFORE_LINKIFY=200,Linkifier.OVERSCAN_CHAR_LIMIT=2e3,Linkifier}(EventEmitter_1.EventEmitter);exports.Linkifier=Linkifier},{"./Buffer":2,"./CharWidth":6,"./common/EventEmitter":19,"./ui/MouseZoneManager":53}],11:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var _extendStatics7=function(d,b){return(_extendStatics7=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])})(d,b)};return function(d,b){function __(){this.constructor=d}_extendStatics7(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:!0});var MouseHelper_1=require("./ui/MouseHelper"),Browser=require("./core/Platform"),EventEmitter_1=require("./common/EventEmitter"),SelectionModel_1=require("./SelectionModel"),Buffer_1=require("./Buffer"),AltClickHandler_1=require("./handlers/AltClickHandler"),WORD_SEPARATORS=" ()[]{}'\"",NON_BREAKING_SPACE_CHAR=String.fromCharCode(160),ALL_NON_BREAKING_SPACE_REGEX=new RegExp(NON_BREAKING_SPACE_CHAR,"g"),SelectionManager=function(_super){function SelectionManager(_terminal,_charMeasure){var _this=_super.call(this)||this;return _this._terminal=_terminal,_this._charMeasure=_charMeasure,_this._enabled=!0,_this._initListeners(),_this.enable(),_this._model=new SelectionModel_1.SelectionModel(_terminal),_this._activeSelectionMode=0,_this}return __extends(SelectionManager,_super),SelectionManager.prototype.dispose=function(){_super.prototype.dispose.call(this),this._removeMouseDownListeners()},Object.defineProperty(SelectionManager.prototype,"_buffer",{get:function(){return this._terminal.buffers.active},enumerable:!0,configurable:!0}),SelectionManager.prototype._initListeners=function(){var _this=this;this._mouseMoveListener=function(event){return _this._onMouseMove(event)},this._mouseUpListener=function(event){return _this._onMouseUp(event)},this._trimListener=function(amount){return _this._onTrim(amount)},this.initBuffersListeners()},SelectionManager.prototype.initBuffersListeners=function(){var _this=this;this._terminal.buffer.lines.on("trim",this._trimListener),this._terminal.buffers.on("activate",function(e){return _this._onBufferActivate(e)})},SelectionManager.prototype.disable=function(){this.clearSelection(),this._enabled=!1},SelectionManager.prototype.enable=function(){this._enabled=!0},Object.defineProperty(SelectionManager.prototype,"selectionStart",{get:function(){return this._model.finalSelectionStart},enumerable:!0,configurable:!0}),Object.defineProperty(SelectionManager.prototype,"selectionEnd",{get:function(){return this._model.finalSelectionEnd},enumerable:!0,configurable:!0}),Object.defineProperty(SelectionManager.prototype,"hasSelection",{get:function(){var start=this._model.finalSelectionStart,end=this._model.finalSelectionEnd;return!(!start||!end)&&(start[0]!==end[0]||start[1]!==end[1])},enumerable:!0,configurable:!0}),Object.defineProperty(SelectionManager.prototype,"selectionText",{get:function(){var start=this._model.finalSelectionStart,end=this._model.finalSelectionEnd;if(!start||!end)return"";var result=[];if(3===this._activeSelectionMode){if(start[0]===end[0])return"";for(var i=start[1];i<=end[1];i++){var lineText=this._buffer.translateBufferLineToString(i,!0,start[0],end[0]);result.push(lineText)}}else{var startRowEndCol=start[1]===end[1]?end[0]:void 0;result.push(this._buffer.translateBufferLineToString(start[1],!0,start[0],startRowEndCol));for(var i=start[1]+1;i<=end[1]-1;i++){var bufferLine=this._buffer.lines.get(i),lineText=this._buffer.translateBufferLineToString(i,!0);bufferLine.isWrapped?result[result.length-1]+=lineText:result.push(lineText)}if(start[1]!==end[1]){var bufferLine=this._buffer.lines.get(end[1]),lineText=this._buffer.translateBufferLineToString(end[1],!0,0,end[0]);bufferLine.isWrapped?result[result.length-1]+=lineText:result.push(lineText)}}return result.map(function(line){return line.replace(ALL_NON_BREAKING_SPACE_REGEX," ")}).join(Browser.isMSWindows?"\r\n":"\n")},enumerable:!0,configurable:!0}),SelectionManager.prototype.clearSelection=function(){this._model.clearSelection(),this._removeMouseDownListeners(),this.refresh()},SelectionManager.prototype.refresh=function(isNewSelection){var _this=this;if(this._refreshAnimationFrame||(this._refreshAnimationFrame=window.requestAnimationFrame(function(){return _this._refresh()})),Browser.isLinux&&isNewSelection){this.selectionText.length&&this.emit("newselection",this.selectionText)}},SelectionManager.prototype._refresh=function(){this._refreshAnimationFrame=null,this.emit("refresh",{start:this._model.finalSelectionStart,end:this._model.finalSelectionEnd,columnSelectMode:3===this._activeSelectionMode})},SelectionManager.prototype.isClickInSelection=function(event){var coords=this._getMouseBufferCoords(event),start=this._model.finalSelectionStart,end=this._model.finalSelectionEnd;return!(!start||!end)&&this._areCoordsInSelection(coords,start,end)},SelectionManager.prototype._areCoordsInSelection=function(coords,start,end){return coords[1]>start[1]&&coords[1]<end[1]||start[1]===end[1]&&coords[1]===start[1]&&coords[0]>=start[0]&&coords[0]<end[0]||start[1]<end[1]&&coords[1]===end[1]&&coords[0]<end[0]||start[1]<end[1]&&coords[1]===start[1]&&coords[0]>=start[0]},SelectionManager.prototype.selectWordAtCursor=function(event){var coords=this._getMouseBufferCoords(event);coords&&(this._selectWordAt(coords,!1),this._model.selectionEnd=null,this.refresh(!0))},SelectionManager.prototype.selectAll=function(){this._model.isSelectAllActive=!0,this.refresh(),this._terminal.emit("selection")},SelectionManager.prototype.selectLines=function(start,end){this._model.clearSelection(),start=Math.max(start,0),end=Math.min(end,this._terminal.buffer.lines.length-1),this._model.selectionStart=[0,start],this._model.selectionEnd=[this._terminal.cols,end],this.refresh(),this._terminal.emit("selection")},SelectionManager.prototype._onTrim=function(amount){this._model.onTrim(amount)&&this.refresh()},SelectionManager.prototype._getMouseBufferCoords=function(event){var coords=this._terminal.mouseHelper.getCoords(event,this._terminal.screenElement,this._charMeasure,this._terminal.cols,this._terminal.rows,!0);return coords?(coords[0]--,coords[1]--,coords[1]+=this._terminal.buffer.ydisp,coords):null},SelectionManager.prototype._getMouseEventScrollAmount=function(event){var offset=MouseHelper_1.MouseHelper.getCoordsRelativeToElement(event,this._terminal.screenElement)[1],terminalHeight=this._terminal.rows*Math.ceil(this._charMeasure.height*this._terminal.options.lineHeight);return offset>=0&&offset<=terminalHeight?0:(offset>terminalHeight&&(offset-=terminalHeight),offset=Math.min(Math.max(offset,-50),50),(offset/=50)/Math.abs(offset)+Math.round(14*offset))},SelectionManager.prototype.shouldForceSelection=function(event){return Browser.isMac?event.altKey&&this._terminal.options.macOptionClickForcesSelection:event.shiftKey},SelectionManager.prototype.onMouseDown=function(event){if(this._mouseDownTimeStamp=event.timeStamp,(2!==event.button||!this.hasSelection)&&0===event.button){if(!this._enabled){if(!this.shouldForceSelection(event))return;event.stopPropagation()}event.preventDefault(),this._dragScrollAmount=0,this._enabled&&event.shiftKey?this._onIncrementalClick(event):1===event.detail?this._onSingleClick(event):2===event.detail?this._onDoubleClick(event):3===event.detail&&this._onTripleClick(event),this._addMouseDownListeners(),this.refresh(!0)}},SelectionManager.prototype._addMouseDownListeners=function(){var _this=this;this._terminal.element.ownerDocument.addEventListener("mousemove",this._mouseMoveListener),this._terminal.element.ownerDocument.addEventListener("mouseup",this._mouseUpListener),this._dragScrollIntervalTimer=setInterval(function(){return _this._dragScroll()},50)},SelectionManager.prototype._removeMouseDownListeners=function(){this._terminal.element.ownerDocument&&(this._terminal.element.ownerDocument.removeEventListener("mousemove",this._mouseMoveListener),this._terminal.element.ownerDocument.removeEventListener("mouseup",this._mouseUpListener)),clearInterval(this._dragScrollIntervalTimer),this._dragScrollIntervalTimer=null},SelectionManager.prototype._onIncrementalClick=function(event){this._model.selectionStart&&(this._model.selectionEnd=this._getMouseBufferCoords(event))},SelectionManager.prototype._onSingleClick=function(event){if(this._model.selectionStartLength=0,this._model.isSelectAllActive=!1,this._activeSelectionMode=this.shouldColumnSelect(event)?3:0,this._model.selectionStart=this._getMouseBufferCoords(event),this._model.selectionStart){this._model.selectionEnd=null;var line=this._buffer.lines.get(this._model.selectionStart[1]);if(line&&!(line.length>=this._model.selectionStart[0])){0===line.get(this._model.selectionStart[0])[Buffer_1.CHAR_DATA_WIDTH_INDEX]&&this._model.selectionStart[0]++}}},SelectionManager.prototype._onDoubleClick=function(event){var coords=this._getMouseBufferCoords(event);coords&&(this._activeSelectionMode=1,this._selectWordAt(coords,!0))},SelectionManager.prototype._onTripleClick=function(event){var coords=this._getMouseBufferCoords(event);coords&&(this._activeSelectionMode=2,this._selectLineAt(coords[1]))},SelectionManager.prototype.shouldColumnSelect=function(event){return event.altKey&&!(Browser.isMac&&this._terminal.options.macOptionClickForcesSelection)},SelectionManager.prototype._onMouseMove=function(event){event.stopImmediatePropagation();var previousSelectionEnd=this._model.selectionEnd?[this._model.selectionEnd[0],this._model.selectionEnd[1]]:null;if(this._model.selectionEnd=this._getMouseBufferCoords(event),!this._model.selectionEnd)return void this.refresh(!0);if(2===this._activeSelectionMode?this._model.selectionEnd[1]<this._model.selectionStart[1]?this._model.selectionEnd[0]=0:this._model.selectionEnd[0]=this._terminal.cols:1===this._activeSelectionMode&&this._selectToWordAt(this._model.selectionEnd),this._dragScrollAmount=this._getMouseEventScrollAmount(event),3!==this._activeSelectionMode&&(this._dragScrollAmount>0?this._model.selectionEnd[0]=this._terminal.cols:this._dragScrollAmount<0&&(this._model.selectionEnd[0]=0)),this._model.selectionEnd[1]<this._buffer.lines.length){var _char7=this._buffer.lines.get(this._model.selectionEnd[1]).get(this._model.selectionEnd[0]);_char7&&0===_char7[Buffer_1.CHAR_DATA_WIDTH_INDEX]&&this._model.selectionEnd[0]++}previousSelectionEnd&&previousSelectionEnd[0]===this._model.selectionEnd[0]&&previousSelectionEnd[1]===this._model.selectionEnd[1]||this.refresh(!0)},SelectionManager.prototype._dragScroll=function(){this._dragScrollAmount&&(this._terminal.scrollLines(this._dragScrollAmount,!1),this._dragScrollAmount>0?(3!==this._activeSelectionMode&&(this._model.selectionEnd[0]=this._terminal.cols),this._model.selectionEnd[1]=Math.min(this._terminal.buffer.ydisp+this._terminal.rows,this._terminal.buffer.lines.length-1)):(3!==this._activeSelectionMode&&(this._model.selectionEnd[0]=0),this._model.selectionEnd[1]=this._terminal.buffer.ydisp),this.refresh())},SelectionManager.prototype._onMouseUp=function(event){var timeElapsed=event.timeStamp-this._mouseDownTimeStamp;this._removeMouseDownListeners(),this.selectionText.length<=1&&timeElapsed<500?new AltClickHandler_1.AltClickHandler(event,this._terminal).move():this.hasSelection&&this._terminal.emit("selection")},SelectionManager.prototype._onBufferActivate=function(e){this.clearSelection(),e.inactiveBuffer.lines.off("trim",this._trimListener),e.activeBuffer.lines.on("trim",this._trimListener)},SelectionManager.prototype._convertViewportColToCharacterIndex=function(bufferLine,coords){for(var charIndex=coords[0],i=0;coords[0]>=i;i++){var _char8=bufferLine.get(i);0===_char8[Buffer_1.CHAR_DATA_WIDTH_INDEX]?charIndex--:_char8[Buffer_1.CHAR_DATA_CHAR_INDEX].length>1&&coords[0]!==i&&(charIndex+=_char8[Buffer_1.CHAR_DATA_CHAR_INDEX].length-1)}return charIndex},SelectionManager.prototype.setSelection=function(col,row,length){this._model.clearSelection(),this._removeMouseDownListeners(),this._model.selectionStart=[col,row],this._model.selectionStartLength=length,this.refresh()},SelectionManager.prototype._getWordAt=function(coords,allowWhitespaceOnlySelection,followWrappedLinesAbove,followWrappedLinesBelow){if(void 0===followWrappedLinesAbove&&(followWrappedLinesAbove=!0),void 0===followWrappedLinesBelow&&(followWrappedLinesBelow=!0),coords[0]>=this._terminal.cols)return null;var bufferLine=this._buffer.lines.get(coords[1]);if(!bufferLine)return null;var line=this._buffer.translateBufferLineToString(coords[1],!1),startIndex=this._convertViewportColToCharacterIndex(bufferLine,coords),endIndex=startIndex,charOffset=coords[0]-startIndex,leftWideCharCount=0,rightWideCharCount=0,leftLongCharOffset=0,rightLongCharOffset=0;if(" "===line.charAt(startIndex)){for(;startIndex>0&&" "===line.charAt(startIndex-1);)startIndex--;for(;endIndex<line.length&&" "===line.charAt(endIndex+1);)endIndex++}else{var startCol=coords[0],endCol=coords[0];for(0===bufferLine.get(startCol)[Buffer_1.CHAR_DATA_WIDTH_INDEX]&&(leftWideCharCount++,startCol--),2===bufferLine.get(endCol)[Buffer_1.CHAR_DATA_WIDTH_INDEX]&&(rightWideCharCount++,endCol++),bufferLine.get(endCol)[Buffer_1.CHAR_DATA_CHAR_INDEX].length>1&&(rightLongCharOffset+=bufferLine.get(endCol)[Buffer_1.CHAR_DATA_CHAR_INDEX].length-1,endIndex+=bufferLine.get(endCol)[Buffer_1.CHAR_DATA_CHAR_INDEX].length-1);startCol>0&&startIndex>0&&!this._isCharWordSeparator(bufferLine.get(startCol-1));){var _char9=bufferLine.get(startCol-1);0===_char9[Buffer_1.CHAR_DATA_WIDTH_INDEX]?(leftWideCharCount++,startCol--):_char9[Buffer_1.CHAR_DATA_CHAR_INDEX].length>1&&(leftLongCharOffset+=_char9[Buffer_1.CHAR_DATA_CHAR_INDEX].length-1,startIndex-=_char9[Buffer_1.CHAR_DATA_CHAR_INDEX].length-1),startIndex--,startCol--}for(;endCol<bufferLine.length&&endIndex+1<line.length&&!this._isCharWordSeparator(bufferLine.get(endCol+1));){var _char9=bufferLine.get(endCol+1);2===_char9[Buffer_1.CHAR_DATA_WIDTH_INDEX]?(rightWideCharCount++,endCol++):_char9[Buffer_1.CHAR_DATA_CHAR_INDEX].length>1&&(rightLongCharOffset+=_char9[Buffer_1.CHAR_DATA_CHAR_INDEX].length-1,endIndex+=_char9[Buffer_1.CHAR_DATA_CHAR_INDEX].length-1),endIndex++,endCol++}}endIndex++;var start=startIndex+charOffset-leftWideCharCount+leftLongCharOffset,length=Math.min(this._terminal.cols,endIndex-startIndex+leftWideCharCount+rightWideCharCount-leftLongCharOffset-rightLongCharOffset);if(!allowWhitespaceOnlySelection&&""===line.slice(startIndex,endIndex).trim())return null;if(followWrappedLinesAbove&&0===start&&32!==bufferLine.get(0)[Buffer_1.CHAR_DATA_CODE_INDEX]){var previousBufferLine=this._buffer.lines.get(coords[1]-1);if(previousBufferLine&&bufferLine.isWrapped&&32!==previousBufferLine.get(this._terminal.cols-1)[Buffer_1.CHAR_DATA_CODE_INDEX]){var previousLineWordPosition=this._getWordAt([this._terminal.cols-1,coords[1]-1],!1,!0,!1);if(previousLineWordPosition){
var offset=this._terminal.cols-previousLineWordPosition.start;start-=offset,length+=offset}}}if(followWrappedLinesBelow&&start+length===this._terminal.cols&&32!==bufferLine.get(this._terminal.cols-1)[Buffer_1.CHAR_DATA_CODE_INDEX]){var nextBufferLine=this._buffer.lines.get(coords[1]+1);if(nextBufferLine&&nextBufferLine.isWrapped&&32!==nextBufferLine.get(0)[Buffer_1.CHAR_DATA_CODE_INDEX]){var nextLineWordPosition=this._getWordAt([0,coords[1]+1],!1,!1,!0);nextLineWordPosition&&(length+=nextLineWordPosition.length)}}return{start:start,length:length}},SelectionManager.prototype._selectWordAt=function(coords,allowWhitespaceOnlySelection){var wordPosition=this._getWordAt(coords,allowWhitespaceOnlySelection);if(wordPosition){for(;wordPosition.start<0;)wordPosition.start+=this._terminal.cols,coords[1]--;this._model.selectionStart=[wordPosition.start,coords[1]],this._model.selectionStartLength=wordPosition.length}},SelectionManager.prototype._selectToWordAt=function(coords){var wordPosition=this._getWordAt(coords,!0);if(wordPosition){for(var endRow=coords[1];wordPosition.start<0;)wordPosition.start+=this._terminal.cols,endRow--;if(!this._model.areSelectionValuesReversed())for(;wordPosition.start+wordPosition.length>this._terminal.cols;)wordPosition.length-=this._terminal.cols,endRow++;this._model.selectionEnd=[this._model.areSelectionValuesReversed()?wordPosition.start:wordPosition.start+wordPosition.length,endRow]}},SelectionManager.prototype._isCharWordSeparator=function(charData){return 0!==charData[Buffer_1.CHAR_DATA_WIDTH_INDEX]&&WORD_SEPARATORS.indexOf(charData[Buffer_1.CHAR_DATA_CHAR_INDEX])>=0},SelectionManager.prototype._selectLineAt=function(line){var wrappedRange=this._buffer.getWrappedRangeForLine(line);this._model.selectionStart=[0,wrappedRange.first],this._model.selectionEnd=[this._terminal.cols,wrappedRange.last],this._model.selectionStartLength=0},SelectionManager}(EventEmitter_1.EventEmitter);exports.SelectionManager=SelectionManager},{"./Buffer":2,"./SelectionModel":12,"./common/EventEmitter":19,"./core/Platform":23,"./handlers/AltClickHandler":27,"./ui/MouseHelper":52}],12:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var SelectionModel=function(){function SelectionModel(_terminal){this._terminal=_terminal,this.clearSelection()}return SelectionModel.prototype.clearSelection=function(){this.selectionStart=null,this.selectionEnd=null,this.isSelectAllActive=!1,this.selectionStartLength=0},Object.defineProperty(SelectionModel.prototype,"finalSelectionStart",{get:function(){return this.isSelectAllActive?[0,0]:this.selectionEnd&&this.selectionStart&&this.areSelectionValuesReversed()?this.selectionEnd:this.selectionStart},enumerable:!0,configurable:!0}),Object.defineProperty(SelectionModel.prototype,"finalSelectionEnd",{get:function(){if(this.isSelectAllActive)return[this._terminal.cols,this._terminal.buffer.ybase+this._terminal.rows-1];if(!this.selectionStart)return null;if(!this.selectionEnd||this.areSelectionValuesReversed()){var startPlusLength=this.selectionStart[0]+this.selectionStartLength;return startPlusLength>this._terminal.cols?[startPlusLength%this._terminal.cols,this.selectionStart[1]+Math.floor(startPlusLength/this._terminal.cols)]:[startPlusLength,this.selectionStart[1]]}return this.selectionStartLength&&this.selectionEnd[1]===this.selectionStart[1]?[Math.max(this.selectionStart[0]+this.selectionStartLength,this.selectionEnd[0]),this.selectionEnd[1]]:this.selectionEnd},enumerable:!0,configurable:!0}),SelectionModel.prototype.areSelectionValuesReversed=function(){var start=this.selectionStart,end=this.selectionEnd;return!(!start||!end)&&(start[1]>end[1]||start[1]===end[1]&&start[0]>end[0])},SelectionModel.prototype.onTrim=function(amount){return this.selectionStart&&(this.selectionStart[1]-=amount),this.selectionEnd&&(this.selectionEnd[1]-=amount),this.selectionEnd&&this.selectionEnd[1]<0?(this.clearSelection(),!0):(this.selectionStart&&this.selectionStart[1]<0&&(this.selectionStart[1]=0),!1)},SelectionModel}();exports.SelectionModel=SelectionModel},{}],13:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.DEFAULT_BELL_SOUND="data:audio/wav;base64,UklGRigBAABXQVZFZm10IBAAAAABAAEARKwAAIhYAQACABAAZGF0YQQBAADpAFgCwAMlBZoG/wdmCcoKRAypDQ8PbRDBEQQTOxRtFYcWlBePGIUZXhoiG88bcBz7HHIdzh0WHlMeZx51HmkeUx4WHs8dah0AHXwc3hs9G4saxRnyGBIYGBcQFv8U4RPAEoYRQBACD70NWwwHC6gJOwjWBloF7gOBAhABkf8b/qv8R/ve+Xf4Ife79W/0JfPZ8Z/wde9N7ijtE+wU6xvqM+lb6H7nw+YX5mrlxuQz5Mzje+Ma49fioeKD4nXiYeJy4pHitOL04j/jn+MN5IPkFOWs5U3mDefM55/ogOl36m7rdOyE7abuyu8D8Unyj/Pg9D/2qfcb+Yn6/vuK/Qj/lAAlAg==";var SoundManager=function(){function SoundManager(_terminal){this._terminal=_terminal}return Object.defineProperty(SoundManager,"audioContext",{get:function(){if(!SoundManager._audioContext){var audioContextCtor=window.AudioContext||window.webkitAudioContext;if(!audioContextCtor)return console.warn("Web Audio API is not supported by this browser. Consider upgrading to the latest version"),null;SoundManager._audioContext=new audioContextCtor}return SoundManager._audioContext},enumerable:!0,configurable:!0}),SoundManager.prototype.playBellSound=function(){var ctx=SoundManager.audioContext;if(ctx){var bellAudioSource=ctx.createBufferSource();ctx.decodeAudioData(this._base64ToArrayBuffer(this._removeMimeType(this._terminal.options.bellSound)),function(buffer){bellAudioSource.buffer=buffer,bellAudioSource.connect(ctx.destination),bellAudioSource.start(0)})}},SoundManager.prototype._base64ToArrayBuffer=function(base64){for(var binaryString=window.atob(base64),len=binaryString.length,bytes=new Uint8Array(len),i=0;i<len;i++)bytes[i]=binaryString.charCodeAt(i);return bytes.buffer},SoundManager.prototype._removeMimeType=function(dataURI){return dataURI.split(",")[1]},SoundManager}();exports.SoundManager=SoundManager},{}],14:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.blankLine="Blank line",exports.promptLabel="Terminal input",exports.tooMuchOutput="Too much output to announce, navigate to rows manually to read"},{}],15:[function(require,module,exports){"use strict";function wasModifierKeyOnlyEvent(ev){return 16===ev.keyCode||17===ev.keyCode||18===ev.keyCode}function matchColorDistance(r1,g1,b1,r2,g2,b2){return Math.pow(30*(r1-r2),2)+Math.pow(59*(g1-g2),2)+Math.pow(11*(b1-b2),2)}var __extends=this&&this.__extends||function(){var _extendStatics8=function(d,b){return(_extendStatics8=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])})(d,b)};return function(d,b){function __(){this.constructor=d}_extendStatics8(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:!0});var BufferSet_1=require("./BufferSet"),Buffer_1=require("./Buffer"),CompositionHelper_1=require("./CompositionHelper"),EventEmitter_1=require("./common/EventEmitter"),Viewport_1=require("./Viewport"),Clipboard_1=require("./ui/Clipboard"),EscapeSequences_1=require("./common/data/EscapeSequences"),InputHandler_1=require("./InputHandler"),Renderer_1=require("./renderer/Renderer"),Linkifier_1=require("./Linkifier"),SelectionManager_1=require("./SelectionManager"),CharMeasure_1=require("./ui/CharMeasure"),Browser=require("./core/Platform"),Lifecycle_1=require("./ui/Lifecycle"),Strings=require("./Strings"),MouseHelper_1=require("./ui/MouseHelper"),SoundManager_1=require("./SoundManager"),ColorManager_1=require("./renderer/ColorManager"),MouseZoneManager_1=require("./ui/MouseZoneManager"),AccessibilityManager_1=require("./AccessibilityManager"),ScreenDprMonitor_1=require("./ui/ScreenDprMonitor"),CharAtlasCache_1=require("./renderer/atlas/CharAtlasCache"),DomRenderer_1=require("./renderer/dom/DomRenderer"),Keyboard_1=require("./core/input/Keyboard"),Clone_1=require("./common/Clone"),document="undefined"!=typeof window?window.document:null,CONSTRUCTOR_ONLY_OPTIONS=["cols","rows"],DEFAULT_OPTIONS={cols:80,rows:24,convertEol:!1,termName:"xterm",cursorBlink:!1,cursorStyle:"block",bellSound:SoundManager_1.DEFAULT_BELL_SOUND,bellStyle:"none",drawBoldTextInBrightColors:!0,enableBold:!0,experimentalCharAtlas:"static",fontFamily:"courier-new, courier, monospace",fontSize:15,fontWeight:"normal",fontWeightBold:"bold",lineHeight:1,letterSpacing:0,scrollback:1e3,screenKeys:!1,screenReaderMode:!1,debug:!1,macOptionIsMeta:!1,macOptionClickForcesSelection:!1,cancelEvents:!1,disableStdin:!1,useFlowControl:!1,allowTransparency:!1,tabStopWidth:8,theme:null,rightClickSelectsWord:Browser.isMac,rendererType:"canvas"},Terminal=function(_super){function Terminal(options){void 0===options&&(options={});var _this=_super.call(this)||this;return _this.browser=Browser,_this._blankLine=null,_this.options=Clone_1.clone(options),_this._setup(),_this}return __extends(Terminal,_super),Terminal.prototype.dispose=function(){_super.prototype.dispose.call(this),this._customKeyEventHandler=null,CharAtlasCache_1.removeTerminalFromCache(this),this.handler=function(){},this.write=function(){},this.element&&this.element.parentNode&&this.element.parentNode.removeChild(this.element)},Terminal.prototype.destroy=function(){this.dispose()},Terminal.prototype._setup=function(){var _this=this;Object.keys(DEFAULT_OPTIONS).forEach(function(key){null!==_this.options[key]&&void 0!==_this.options[key]||(_this.options[key]=DEFAULT_OPTIONS[key])}),this._parent=document?document.body:null,this.cols=Math.max(this.options.cols,2),this.rows=Math.max(this.options.rows,1),this.options.handler&&this.on("data",this.options.handler),this.cursorState=0,this.cursorHidden=!1,this._customKeyEventHandler=null,this.applicationKeypad=!1,this.applicationCursor=!1,this.originMode=!1,this.insertMode=!1,this.wraparoundMode=!0,this.bracketedPasteMode=!1,this.charset=null,this.gcharset=null,this.glevel=0,this.charsets=[null],this.curAttr=Buffer_1.DEFAULT_ATTR,this.params=[],this.currentParam=0,this.writeBuffer=[],this._writeInProgress=!1,this._xoffSentToCatchUp=!1,this._userScrolling=!1,this._inputHandler=new InputHandler_1.InputHandler(this),this.register(this._inputHandler),this.renderer=this.renderer||null,this.selectionManager=this.selectionManager||null,this.linkifier=this.linkifier||new Linkifier_1.Linkifier(this),this._mouseZoneManager=this._mouseZoneManager||null,this.soundManager=this.soundManager||new SoundManager_1.SoundManager(this),this.buffers=new BufferSet_1.BufferSet(this),this.selectionManager&&(this.selectionManager.clearSelection(),this.selectionManager.initBuffersListeners())},Object.defineProperty(Terminal.prototype,"buffer",{get:function(){return this.buffers.active},enumerable:!0,configurable:!0}),Terminal.prototype.eraseAttr=function(){return-512&Buffer_1.DEFAULT_ATTR|511&this.curAttr},Terminal.prototype.focus=function(){this.textarea&&this.textarea.focus()},Object.defineProperty(Terminal.prototype,"isFocused",{get:function(){return document.activeElement===this.textarea&&document.hasFocus()},enumerable:!0,configurable:!0}),Terminal.prototype.getOption=function(key){if(!(key in DEFAULT_OPTIONS))throw new Error('No option with key "'+key+'"');return this.options[key]},Terminal.prototype.setOption=function(key,value){if(!(key in DEFAULT_OPTIONS))throw new Error('No option with key "'+key+'"');if(-1!==CONSTRUCTOR_ONLY_OPTIONS.indexOf(key)&&console.error('Option "'+key+'" can only be set in the constructor'),this.options[key]!==value){switch(key){case"bellStyle":value||(value="none");break;case"cursorStyle":value||(value="block");break;case"fontWeight":value||(value="normal");break;case"fontWeightBold":value||(value="bold");break;case"lineHeight":if(value<1)return void console.warn(key+" cannot be less than 1, value: "+value);case"rendererType":value||(value="canvas");break;case"tabStopWidth":if(value<1)return void console.warn(key+" cannot be less than 1, value: "+value);break;case"theme":if(this.renderer)return void this._setTheme(value);break;case"scrollback":if((value=Math.min(value,Buffer_1.MAX_BUFFER_SIZE))<0)return void console.warn(key+" cannot be less than 0, value: "+value);if(this.options[key]!==value){var newBufferLength=this.rows+value;if(this.buffer.lines.length>newBufferLength){var amountToTrim=this.buffer.lines.length-newBufferLength,needsRefresh=this.buffer.ydisp-amountToTrim<0;this.buffer.lines.trimStart(amountToTrim),this.buffer.ybase=Math.max(this.buffer.ybase-amountToTrim,0),this.buffer.ydisp=Math.max(this.buffer.ydisp-amountToTrim,0),needsRefresh&&this.refresh(0,this.rows-1)}}}switch(this.options[key]=value,key){case"fontFamily":case"fontSize":this.renderer&&(this.renderer.clear(),this.charMeasure.measure(this.options));break;case"drawBoldTextInBrightColors":case"experimentalCharAtlas":case"enableBold":case"letterSpacing":case"lineHeight":case"fontWeight":case"fontWeightBold":this.renderer&&(this.renderer.clear(),this.renderer.onResize(this.cols,this.rows),this.refresh(0,this.rows-1));break;case"rendererType":this.renderer&&(this.unregister(this.renderer),this.renderer.dispose(),this.renderer=null),this._setupRenderer(),this.renderer.onCharSizeChanged(),this._theme&&this.renderer.setTheme(this._theme),this.mouseHelper.setRenderer(this.renderer);break;case"scrollback":this.buffers.resize(this.cols,this.rows),this.viewport&&this.viewport.syncScrollArea();break;case"screenReaderMode":value?this._accessibilityManager||(this._accessibilityManager=new AccessibilityManager_1.AccessibilityManager(this)):this._accessibilityManager&&(this._accessibilityManager.dispose(),this._accessibilityManager=null);break;case"tabStopWidth":this.buffers.setupTabStops()}this.renderer&&this.renderer.onOptionsChanged()}},Terminal.prototype._onTextAreaFocus=function(ev){this.sendFocus&&this.handler(EscapeSequences_1.C0.ESC+"[I"),this.updateCursorStyle(ev),this.element.classList.add("focus"),this.showCursor(),this.emit("focus")},Terminal.prototype.blur=function(){return this.textarea.blur()},Terminal.prototype._onTextAreaBlur=function(){this.textarea.value="",this.refresh(this.buffer.y,this.buffer.y),this.sendFocus&&this.handler(EscapeSequences_1.C0.ESC+"[O"),this.element.classList.remove("focus"),this.emit("blur")},Terminal.prototype._initGlobal=function(){var _this=this;this._bindKeys(),this.register(Lifecycle_1.addDisposableDomListener(this.element,"copy",function(event){_this.hasSelection()&&Clipboard_1.copyHandler(event,_this,_this.selectionManager)}));var pasteHandlerWrapper=function(event){return Clipboard_1.pasteHandler(event,_this)};this.register(Lifecycle_1.addDisposableDomListener(this.textarea,"paste",pasteHandlerWrapper)),this.register(Lifecycle_1.addDisposableDomListener(this.element,"paste",pasteHandlerWrapper)),Browser.isFirefox?this.register(Lifecycle_1.addDisposableDomListener(this.element,"mousedown",function(event){2===event.button&&Clipboard_1.rightClickHandler(event,_this,_this.selectionManager,_this.options.rightClickSelectsWord)})):this.register(Lifecycle_1.addDisposableDomListener(this.element,"contextmenu",function(event){Clipboard_1.rightClickHandler(event,_this,_this.selectionManager,_this.options.rightClickSelectsWord)})),Browser.isLinux&&this.register(Lifecycle_1.addDisposableDomListener(this.element,"auxclick",function(event){1===event.button&&Clipboard_1.moveTextAreaUnderMouseCursor(event,_this)}))},Terminal.prototype._bindKeys=function(){var _this=this,self=this;this.register(Lifecycle_1.addDisposableDomListener(this.element,"keydown",function(ev){document.activeElement===this&&self._keyDown(ev)},!0)),this.register(Lifecycle_1.addDisposableDomListener(this.element,"keypress",function(ev){document.activeElement===this&&self._keyPress(ev)},!0)),this.register(Lifecycle_1.addDisposableDomListener(this.element,"keyup",function(ev){wasModifierKeyOnlyEvent(ev)||_this.focus(),self._keyUp(ev)},!0)),this.register(Lifecycle_1.addDisposableDomListener(this.textarea,"keydown",function(ev){return _this._keyDown(ev)},!0)),this.register(Lifecycle_1.addDisposableDomListener(this.textarea,"keypress",function(ev){return _this._keyPress(ev)},!0)),this.register(Lifecycle_1.addDisposableDomListener(this.textarea,"compositionstart",function(){return _this._compositionHelper.compositionstart()})),this.register(Lifecycle_1.addDisposableDomListener(this.textarea,"compositionupdate",function(e){return _this._compositionHelper.compositionupdate(e)})),this.register(Lifecycle_1.addDisposableDomListener(this.textarea,"compositionend",function(){return _this._compositionHelper.compositionend()})),this.register(this.addDisposableListener("refresh",function(){return _this._compositionHelper.updateCompositionElements()})),this.register(this.addDisposableListener("refresh",function(data){return _this._queueLinkification(data.start,data.end)}))},Terminal.prototype.open=function(parent){var _this=this;if(this._parent=parent||this._parent,!this._parent)throw new Error("Terminal requires a parent element.");this._context=this._parent.ownerDocument.defaultView,this._document=this._parent.ownerDocument,this._screenDprMonitor=new ScreenDprMonitor_1.ScreenDprMonitor,this._screenDprMonitor.setListener(function(){return _this.emit("dprchange",window.devicePixelRatio)}),this.register(this._screenDprMonitor),this.element=this._document.createElement("div"),this.element.dir="ltr",this.element.classList.add("terminal"),this.element.classList.add("xterm"),this.element.setAttribute("tabindex","0"),this._parent.appendChild(this.element);var fragment=document.createDocumentFragment();this._viewportElement=document.createElement("div"),this._viewportElement.classList.add("xterm-viewport"),fragment.appendChild(this._viewportElement),this._viewportScrollArea=document.createElement("div"),this._viewportScrollArea.classList.add("xterm-scroll-area"),this._viewportElement.appendChild(this._viewportScrollArea),this.screenElement=document.createElement("div"),this.screenElement.classList.add("xterm-screen"),this._helperContainer=document.createElement("div"),this._helperContainer.classList.add("xterm-helpers"),this.screenElement.appendChild(this._helperContainer),fragment.appendChild(this.screenElement),this._mouseZoneManager=new MouseZoneManager_1.MouseZoneManager(this),this.register(this._mouseZoneManager),this.register(this.addDisposableListener("scroll",function(){return _this._mouseZoneManager.clearAll()})),this.linkifier.attachToDom(this._mouseZoneManager),this.textarea=document.createElement("textarea"),this.textarea.classList.add("xterm-helper-textarea"),this.textarea.setAttribute("aria-label",Strings.promptLabel),this.textarea.setAttribute("aria-multiline","false"),this.textarea.setAttribute("autocorrect","off"),this.textarea.setAttribute("autocapitalize","off"),this.textarea.setAttribute("spellcheck","false"),this.textarea.tabIndex=0,this.register(Lifecycle_1.addDisposableDomListener(this.textarea,"focus",function(ev){return _this._onTextAreaFocus(ev)})),this.register(Lifecycle_1.addDisposableDomListener(this.textarea,"blur",function(){return _this._onTextAreaBlur()})),this._helperContainer.appendChild(this.textarea),this._compositionView=document.createElement("div"),this._compositionView.classList.add("composition-view"),this._compositionHelper=new CompositionHelper_1.CompositionHelper(this.textarea,this._compositionView,this),this._helperContainer.appendChild(this._compositionView),this.charMeasure=new CharMeasure_1.CharMeasure(document,this._helperContainer),this.element.appendChild(fragment),this._setupRenderer(),this._theme=this.options.theme,this.options.theme=null,this.viewport=new Viewport_1.Viewport(this,this._viewportElement,this._viewportScrollArea,this.charMeasure),this.viewport.onThemeChanged(this.renderer.colorManager.colors),this.register(this.viewport),this.register(this.addDisposableListener("cursormove",function(){return _this.renderer.onCursorMove()})),this.register(this.addDisposableListener("resize",function(){return _this.renderer.onResize(_this.cols,_this.rows)})),this.register(this.addDisposableListener("blur",function(){return _this.renderer.onBlur()})),this.register(this.addDisposableListener("focus",function(){return _this.renderer.onFocus()})),this.register(this.addDisposableListener("dprchange",function(){return _this.renderer.onWindowResize(window.devicePixelRatio)})),this.register(Lifecycle_1.addDisposableDomListener(window,"resize",function(){return _this.renderer.onWindowResize(window.devicePixelRatio)})),this.register(this.charMeasure.addDisposableListener("charsizechanged",function(){return _this.renderer.onCharSizeChanged()})),this.register(this.renderer.addDisposableListener("resize",function(dimensions){return _this.viewport.syncScrollArea()})),this.selectionManager=new SelectionManager_1.SelectionManager(this,this.charMeasure),this.register(Lifecycle_1.addDisposableDomListener(this.element,"mousedown",function(e){return _this.selectionManager.onMouseDown(e)})),this.register(this.selectionManager.addDisposableListener("refresh",function(data){return _this.renderer.onSelectionChanged(data.start,data.end,data.columnSelectMode)})),this.register(this.selectionManager.addDisposableListener("newselection",function(text){_this.textarea.value=text,_this.textarea.focus(),_this.textarea.select()})),this.register(this.addDisposableListener("scroll",function(){_this.viewport.syncScrollArea(),_this.selectionManager.refresh()})),this.register(Lifecycle_1.addDisposableDomListener(this._viewportElement,"scroll",function(){return _this.selectionManager.refresh()})),this.mouseHelper=new MouseHelper_1.MouseHelper(this.renderer),this.element.classList.toggle("enable-mouse-events",this.mouseEvents),this.options.screenReaderMode&&(this._accessibilityManager=new AccessibilityManager_1.AccessibilityManager(this)),this.charMeasure.measure(this.options),this.refresh(0,this.rows-1),this._initGlobal(),this.bindMouse()},Terminal.prototype._setupRenderer=function(){switch(this.options.rendererType){case"canvas":this.renderer=new Renderer_1.Renderer(this,this.options.theme);break;case"dom":this.renderer=new DomRenderer_1.DomRenderer(this,this.options.theme);break;default:throw new Error('Unrecognized rendererType "'+this.options.rendererType+'"')}this.register(this.renderer)},Terminal.prototype._setTheme=function(theme){this._theme=theme;var colors=this.renderer.setTheme(theme);this.viewport&&this.viewport.onThemeChanged(colors)},Terminal.prototype.bindMouse=function(){function sendButton(ev){var button,pos;if(button=getButton(ev),pos=self.mouseHelper.getRawByteCoords(ev,self.screenElement,self.charMeasure,self.cols,self.rows))switch(sendEvent(button,pos),ev.overrideType||ev.type){case"mousedown":pressed=button;break;case"mouseup":pressed=32}}function sendMove(ev){var button=pressed,pos=self.mouseHelper.getRawByteCoords(ev,self.screenElement,self.charMeasure,self.cols,self.rows);pos&&(button+=32,sendEvent(button,pos))}function encode(data,ch){if(self.utfMouse){if(2047===ch)return void data.push(0);ch<127?data.push(ch):(ch>2047&&(ch=2047),data.push(192|ch>>6),data.push(128|63&ch))}else{if(255===ch)return void data.push(0);ch>127&&(ch=127),data.push(ch)}}function sendEvent(button,pos){if(self._vt300Mouse){button&=3,pos.x-=32,pos.y-=32;var data_1=EscapeSequences_1.C0.ESC+"[24";if(0===button)data_1+="1";else if(1===button)data_1+="3";else if(2===button)data_1+="5";else{if(3===button)return;data_1+="0"}return data_1+="~["+pos.x+","+pos.y+"]\r",void self.handler(data_1)}if(self._decLocator)return button&=3,pos.x-=32,pos.y-=32,0===button?button=2:1===button?button=4:2===button?button=6:3===button&&(button=3),void self.handler(EscapeSequences_1.C0.ESC+"["+button+";"+(3===button?4:0)+";"+pos.y+";"+pos.x+";"+pos.page||"0&w");if(self.urxvtMouse)return pos.x-=32,pos.y-=32,pos.x++,pos.y++,void self.handler(EscapeSequences_1.C0.ESC+"["+button+";"+pos.x+";"+pos.y+"M");if(self.sgrMouse)return pos.x-=32,pos.y-=32,void self.handler(EscapeSequences_1.C0.ESC+"[<"+((3==(3&button)?-4&button:button)-32)+";"+pos.x+";"+pos.y+(3==(3&button)?"m":"M"));var data=[];encode(data,button),encode(data,pos.x),encode(data,pos.y),self.handler(EscapeSequences_1.C0.ESC+"[M"+String.fromCharCode.apply(String,data))}function getButton(ev){var button,shift,meta,ctrl,mod;switch(ev.overrideType||ev.type){case"mousedown":button=null!==ev.button&&void 0!==ev.button?+ev.button:null!==ev.which&&void 0!==ev.which?ev.which-1:null,Browser.isMSIE&&(button=1===button?0:4===button?1:button);break;case"mouseup":button=3;break;case"DOMMouseScroll":button=ev.detail<0?64:65;break;case"wheel":button=ev.deltaY<0?64:65}return shift=ev.shiftKey?4:0,meta=ev.metaKey?8:0,ctrl=ev.ctrlKey?16:0,mod=shift|meta|ctrl,self.vt200Mouse?mod&=ctrl:self.normalMouse||(mod=0),button=32+(mod<<2)+button}var _this=this,el=this.element,self=this,pressed=32;this.register(Lifecycle_1.addDisposableDomListener(el,"mousedown",function(ev){if(ev.preventDefault(),_this.focus(),_this.mouseEvents&&!_this.selectionManager.shouldForceSelection(ev)){if(sendButton(ev),_this.vt200Mouse)return ev.overrideType="mouseup",sendButton(ev),_this.cancel(ev);var moveHandler;_this.normalMouse&&(moveHandler=function(event){_this.normalMouse&&sendMove(event)},_this._document.addEventListener("mousemove",moveHandler));var handler=function handler(ev){return _this.normalMouse&&!_this.x10Mouse&&sendButton(ev),moveHandler&&(_this._document.removeEventListener("mousemove",moveHandler),moveHandler=null),_this._document.removeEventListener("mouseup",handler),_this.cancel(ev)};return _this._document.addEventListener("mouseup",handler),_this.cancel(ev)}})),this.register(Lifecycle_1.addDisposableDomListener(el,"wheel",function(ev){if(_this.mouseEvents)_this.x10Mouse||_this._vt300Mouse||_this._decLocator||(sendButton(ev),ev.preventDefault());else if(!_this.buffer.hasScrollback){var amount=_this.viewport.getLinesScrolled(ev);if(0===amount)return;for(var sequence=EscapeSequences_1.C0.ESC+(_this.applicationCursor?"O":"[")+(ev.deltaY<0?"A":"B"),data="",i=0;i<Math.abs(amount);i++)data+=sequence;_this.handler(data)}})),this.register(Lifecycle_1.addDisposableDomListener(el,"wheel",function(ev){if(!_this.mouseEvents)return _this.viewport.onWheel(ev),_this.cancel(ev)})),this.register(Lifecycle_1.addDisposableDomListener(el,"touchstart",function(ev){if(!_this.mouseEvents)return _this.viewport.onTouchStart(ev),_this.cancel(ev)})),this.register(Lifecycle_1.addDisposableDomListener(el,"touchmove",function(ev){if(!_this.mouseEvents)return _this.viewport.onTouchMove(ev),_this.cancel(ev)}))},Terminal.prototype.refresh=function(start,end){this.renderer&&this.renderer.refreshRows(start,end)},Terminal.prototype._queueLinkification=function(start,end){this.linkifier&&this.linkifier.linkifyRows(start,end)},Terminal.prototype.updateCursorStyle=function(ev){this.selectionManager&&this.selectionManager.shouldColumnSelect(ev)?this.element.classList.add("column-select"):this.element.classList.remove("column-select")},Terminal.prototype.showCursor=function(){this.cursorState||(this.cursorState=1,this.refresh(this.buffer.y,this.buffer.y))},Terminal.prototype.scroll=function(isWrapped){void 0===isWrapped&&(isWrapped=!1);var newLine;newLine=this._blankLine,newLine&&newLine.length===this.cols&&newLine.get(0)[Buffer_1.CHAR_DATA_ATTR_INDEX]===this.eraseAttr()||(newLine=this.buffer.getBlankLine(this.eraseAttr(),isWrapped),this._blankLine=newLine),newLine.isWrapped=isWrapped;var topRow=this.buffer.ybase+this.buffer.scrollTop,bottomRow=this.buffer.ybase+this.buffer.scrollBottom;if(0===this.buffer.scrollTop){var willBufferBeTrimmed=this.buffer.lines.isFull;bottomRow===this.buffer.lines.length-1?willBufferBeTrimmed?this.buffer.lines.recycle().copyFrom(newLine):this.buffer.lines.push(newLine.clone()):this.buffer.lines.splice(bottomRow+1,0,newLine.clone()),willBufferBeTrimmed?this._userScrolling&&(this.buffer.ydisp=Math.max(this.buffer.ydisp-1,0)):(this.buffer.ybase++,this._userScrolling||this.buffer.ydisp++)}else{var scrollRegionHeight=bottomRow-topRow+1;this.buffer.lines.shiftElements(topRow+1,scrollRegionHeight-1,-1),this.buffer.lines.set(bottomRow,newLine.clone())}this._userScrolling||(this.buffer.ydisp=this.buffer.ybase),this.updateRange(this.buffer.scrollTop),this.updateRange(this.buffer.scrollBottom),this.emit("scroll",this.buffer.ydisp)},Terminal.prototype.scrollLines=function(disp,suppressScrollEvent){if(disp<0){if(0===this.buffer.ydisp)return;this._userScrolling=!0}else disp+this.buffer.ydisp>=this.buffer.ybase&&(this._userScrolling=!1);var oldYdisp=this.buffer.ydisp;this.buffer.ydisp=Math.max(Math.min(this.buffer.ydisp+disp,this.buffer.ybase),0),oldYdisp!==this.buffer.ydisp&&(suppressScrollEvent||this.emit("scroll",this.buffer.ydisp),this.refresh(0,this.rows-1))},Terminal.prototype.scrollPages=function(pageCount){this.scrollLines(pageCount*(this.rows-1))},Terminal.prototype.scrollToTop=function(){this.scrollLines(-this.buffer.ydisp)},Terminal.prototype.scrollToBottom=function(){this.scrollLines(this.buffer.ybase-this.buffer.ydisp)},Terminal.prototype.scrollToLine=function(line){var scrollAmount=line-this.buffer.ydisp;0!==scrollAmount&&this.scrollLines(scrollAmount)},Terminal.prototype.write=function(data){var _this=this;this._isDisposed||data&&(this.writeBuffer.push(data),this.options.useFlowControl&&!this._xoffSentToCatchUp&&this.writeBuffer.length>=5&&(this.handler(EscapeSequences_1.C0.DC3),this._xoffSentToCatchUp=!0),!this._writeInProgress&&this.writeBuffer.length>0&&(this._writeInProgress=!0,setTimeout(function(){_this._innerWrite()})))},Terminal.prototype._innerWrite=function(){var _this=this;this._isDisposed&&(this.writeBuffer=[]);for(var writeBatch=this.writeBuffer.splice(0,300);writeBatch.length>0;){var data=writeBatch.shift();this._xoffSentToCatchUp&&0===writeBatch.length&&0===this.writeBuffer.length&&(this.handler(EscapeSequences_1.C0.DC1),this._xoffSentToCatchUp=!1),this._refreshStart=this.buffer.y,this._refreshEnd=this.buffer.y,this._inputHandler.parse(data),this.updateRange(this.buffer.y),this.refresh(this._refreshStart,this._refreshEnd)}this.writeBuffer.length>0?setTimeout(function(){return _this._innerWrite()},0):this._writeInProgress=!1},Terminal.prototype.writeln=function(data){this.write(data+"\r\n")},Terminal.prototype.attachCustomKeyEventHandler=function(customKeyEventHandler){this._customKeyEventHandler=customKeyEventHandler},Terminal.prototype.addCsiHandler=function(flag,callback){return this._inputHandler.addCsiHandler(flag,callback)},Terminal.prototype.addOscHandler=function(ident,callback){return this._inputHandler.addOscHandler(ident,callback)},Terminal.prototype.registerLinkMatcher=function(regex,handler,options){var matcherId=this.linkifier.registerLinkMatcher(regex,handler,options);return this.refresh(0,this.rows-1),matcherId},Terminal.prototype.deregisterLinkMatcher=function(matcherId){this.linkifier.deregisterLinkMatcher(matcherId)&&this.refresh(0,this.rows-1)},Terminal.prototype.registerCharacterJoiner=function(handler){var joinerId=this.renderer.registerCharacterJoiner(handler);return this.refresh(0,this.rows-1),joinerId},Terminal.prototype.deregisterCharacterJoiner=function(joinerId){this.renderer.deregisterCharacterJoiner(joinerId)&&this.refresh(0,this.rows-1)},Object.defineProperty(Terminal.prototype,"markers",{get:function(){return this.buffer.markers},enumerable:!0,configurable:!0}),Terminal.prototype.addMarker=function(cursorYOffset){if(this.buffer===this.buffers.normal)return this.buffer.addMarker(this.buffer.ybase+this.buffer.y+cursorYOffset)},Terminal.prototype.hasSelection=function(){return!!this.selectionManager&&this.selectionManager.hasSelection},Terminal.prototype.getSelection=function(){return this.selectionManager?this.selectionManager.selectionText:""},Terminal.prototype.clearSelection=function(){this.selectionManager&&this.selectionManager.clearSelection()},Terminal.prototype.selectAll=function(){this.selectionManager&&this.selectionManager.selectAll()},
Terminal.prototype.selectLines=function(start,end){this.selectionManager&&this.selectionManager.selectLines(start,end)},Terminal.prototype._keyDown=function(event){if(this._customKeyEventHandler&&!1===this._customKeyEventHandler(event))return!1;if(!this._compositionHelper.keydown(event))return this.buffer.ybase!==this.buffer.ydisp&&this.scrollToBottom(),!1;var result=Keyboard_1.evaluateKeyboardEvent(event,this.applicationCursor,this.browser.isMac,this.options.macOptionIsMeta);if(this.updateCursorStyle(event),3===result.type||2===result.type){var scrollCount=this.rows-1;return this.scrollLines(2===result.type?-scrollCount:scrollCount),this.cancel(event,!0)}return 1===result.type&&this.selectAll(),!!this._isThirdLevelShift(this.browser,event)||(result.cancel&&this.cancel(event,!0),!result.key||(this.emit("keydown",event),this.emit("key",result.key,event),this.showCursor(),this.handler(result.key),this.cancel(event,!0)))},Terminal.prototype._isThirdLevelShift=function(browser,ev){var thirdLevelKey=browser.isMac&&!this.options.macOptionIsMeta&&ev.altKey&&!ev.ctrlKey&&!ev.metaKey||browser.isMSWindows&&ev.altKey&&ev.ctrlKey&&!ev.metaKey;return"keypress"===ev.type?thirdLevelKey:thirdLevelKey&&(!ev.keyCode||ev.keyCode>47)},Terminal.prototype.setgLevel=function(g){this.glevel=g,this.charset=this.charsets[g]},Terminal.prototype.setgCharset=function(g,charset){this.charsets[g]=charset,this.glevel===g&&(this.charset=charset)},Terminal.prototype._keyUp=function(ev){this.updateCursorStyle(ev)},Terminal.prototype._keyPress=function(ev){var key;if(this._customKeyEventHandler&&!1===this._customKeyEventHandler(ev))return!1;if(this.cancel(ev),ev.charCode)key=ev.charCode;else if(null===ev.which||void 0===ev.which)key=ev.keyCode;else{if(0===ev.which||0===ev.charCode)return!1;key=ev.which}return!(!key||(ev.altKey||ev.ctrlKey||ev.metaKey)&&!this._isThirdLevelShift(this.browser,ev))&&(key=String.fromCharCode(key),this.emit("keypress",key,ev),this.emit("key",key,ev),this.showCursor(),this.handler(key),!0)},Terminal.prototype.bell=function(){var _this=this;this.emit("bell"),this._soundBell()&&this.soundManager.playBellSound(),this._visualBell()&&(this.element.classList.add("visual-bell-active"),clearTimeout(this._visualBellTimer),this._visualBellTimer=window.setTimeout(function(){_this.element.classList.remove("visual-bell-active")},200))},Terminal.prototype.log=function(text,data){this.options.debug&&this._context.console&&this._context.console.log&&this._context.console.log(text,data)},Terminal.prototype.error=function(text,data){this.options.debug&&this._context.console&&this._context.console.error&&this._context.console.error(text,data)},Terminal.prototype.resize=function(x,y){if(!isNaN(x)&&!isNaN(y)){if(x===this.cols&&y===this.rows)return void(!this.charMeasure||this.charMeasure.width&&this.charMeasure.height||this.charMeasure.measure(this.options));x<2&&(x=2),y<1&&(y=1),this.buffers.resize(x,y),this.cols=x,this.rows=y,this.buffers.setupTabStops(this.cols),this.charMeasure&&this.charMeasure.measure(this.options),this.refresh(0,this.rows-1),this.emit("resize",{cols:x,rows:y})}},Terminal.prototype.updateRange=function(y){y<this._refreshStart&&(this._refreshStart=y),y>this._refreshEnd&&(this._refreshEnd=y)},Terminal.prototype.maxRange=function(){this._refreshStart=0,this._refreshEnd=this.rows-1},Terminal.prototype.clear=function(){if(0!==this.buffer.ybase||0!==this.buffer.y){this.buffer.lines.set(0,this.buffer.lines.get(this.buffer.ybase+this.buffer.y)),this.buffer.lines.length=1,this.buffer.ydisp=0,this.buffer.ybase=0,this.buffer.y=0;for(var i=1;i<this.rows;i++)this.buffer.lines.push(this.buffer.getBlankLine(Buffer_1.DEFAULT_ATTR));this.refresh(0,this.rows-1),this.emit("scroll",this.buffer.ydisp)}},Terminal.prototype.ch=function(cur){return cur?[this.eraseAttr(),Buffer_1.NULL_CELL_CHAR,Buffer_1.NULL_CELL_WIDTH,Buffer_1.NULL_CELL_CODE]:[Buffer_1.DEFAULT_ATTR,Buffer_1.NULL_CELL_CHAR,Buffer_1.NULL_CELL_WIDTH,Buffer_1.NULL_CELL_CODE]},Terminal.prototype.is=function(term){return 0===(this.options.termName+"").indexOf(term)},Terminal.prototype.handler=function(data){this.options.disableStdin||(this.selectionManager&&this.selectionManager.hasSelection&&this.selectionManager.clearSelection(),this.buffer.ybase!==this.buffer.ydisp&&this.scrollToBottom(),this.emit("data",data))},Terminal.prototype.handleTitle=function(title){this.emit("title",title)},Terminal.prototype.index=function(){this.buffer.y++,this.buffer.y>this.buffer.scrollBottom&&(this.buffer.y--,this.scroll()),this.buffer.x>=this.cols&&this.buffer.x--},Terminal.prototype.reverseIndex=function(){if(this.buffer.y===this.buffer.scrollTop){var scrollRegionHeight=this.buffer.scrollBottom-this.buffer.scrollTop;this.buffer.lines.shiftElements(this.buffer.y+this.buffer.ybase,scrollRegionHeight,1),this.buffer.lines.set(this.buffer.y+this.buffer.ybase,this.buffer.getBlankLine(this.eraseAttr())),this.updateRange(this.buffer.scrollTop),this.updateRange(this.buffer.scrollBottom)}else this.buffer.y--},Terminal.prototype.reset=function(){this.options.rows=this.rows,this.options.cols=this.cols;var customKeyEventHandler=this._customKeyEventHandler,inputHandler=this._inputHandler,cursorState=this.cursorState;this._setup(),this._customKeyEventHandler=customKeyEventHandler,this._inputHandler=inputHandler,this.cursorState=cursorState,this.refresh(0,this.rows-1),this.viewport&&this.viewport.syncScrollArea()},Terminal.prototype.tabSet=function(){this.buffer.tabs[this.buffer.x]=!0},Terminal.prototype.cancel=function(ev,force){if(this.options.cancelEvents||force)return ev.preventDefault(),ev.stopPropagation(),!1},Terminal.prototype.matchColor=function(r1,g1,b1){var hash=r1<<16|g1<<8|b1;if(null!==matchColorCache[hash]&&void 0!==matchColorCache[hash])return matchColorCache[hash];for(var c,r2,g2,b2,diff,ldiff=1/0,li=-1,i=0;i<ColorManager_1.DEFAULT_ANSI_COLORS.length;i++){if(c=ColorManager_1.DEFAULT_ANSI_COLORS[i].rgba,r2=c>>>24,g2=c>>>16&255,b2=c>>>8&255,0===(diff=matchColorDistance(r1,g1,b1,r2,g2,b2))){li=i;break}diff<ldiff&&(ldiff=diff,li=i)}return matchColorCache[hash]=li},Terminal.prototype._visualBell=function(){return!1},Terminal.prototype._soundBell=function(){return"sound"===this.options.bellStyle},Terminal}(EventEmitter_1.EventEmitter);exports.Terminal=Terminal;var matchColorCache={}},{"./AccessibilityManager":1,"./Buffer":2,"./BufferSet":5,"./CompositionHelper":7,"./InputHandler":9,"./Linkifier":10,"./SelectionManager":11,"./SoundManager":13,"./Strings":14,"./Viewport":16,"./common/Clone":18,"./common/EventEmitter":19,"./common/data/EscapeSequences":22,"./core/Platform":23,"./core/input/Keyboard":25,"./renderer/ColorManager":31,"./renderer/Renderer":35,"./renderer/atlas/CharAtlasCache":39,"./renderer/dom/DomRenderer":47,"./ui/CharMeasure":49,"./ui/Clipboard":50,"./ui/Lifecycle":51,"./ui/MouseHelper":52,"./ui/MouseZoneManager":53,"./ui/ScreenDprMonitor":55}],16:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var _extendStatics9=function(d,b){return(_extendStatics9=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])})(d,b)};return function(d,b){function __(){this.constructor=d}_extendStatics9(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:!0});var Lifecycle_1=require("./common/Lifecycle"),Lifecycle_2=require("./ui/Lifecycle"),FALLBACK_SCROLL_BAR_WIDTH=15,Viewport=function(_super){function Viewport(_terminal,_viewportElement,_scrollArea,_charMeasure){var _this=_super.call(this)||this;return _this._terminal=_terminal,_this._viewportElement=_viewportElement,_this._scrollArea=_scrollArea,_this._charMeasure=_charMeasure,_this.scrollBarWidth=0,_this._currentRowHeight=0,_this._lastRecordedBufferLength=0,_this._lastRecordedViewportHeight=0,_this._lastRecordedBufferHeight=0,_this._lastScrollTop=0,_this._wheelPartialScroll=0,_this._refreshAnimationFrame=null,_this._ignoreNextScrollEvent=!1,_this.scrollBarWidth=_this._viewportElement.offsetWidth-_this._scrollArea.offsetWidth||FALLBACK_SCROLL_BAR_WIDTH,_this.register(Lifecycle_2.addDisposableDomListener(_this._viewportElement,"scroll",_this._onScroll.bind(_this))),setTimeout(function(){return _this.syncScrollArea()},0),_this}return __extends(Viewport,_super),Viewport.prototype.onThemeChanged=function(colors){this._viewportElement.style.backgroundColor=colors.background.css},Viewport.prototype._refresh=function(){var _this=this;null===this._refreshAnimationFrame&&(this._refreshAnimationFrame=requestAnimationFrame(function(){return _this._innerRefresh()}))},Viewport.prototype._innerRefresh=function(){if(this._charMeasure.height>0){this._currentRowHeight=this._terminal.renderer.dimensions.scaledCellHeight/window.devicePixelRatio,this._lastRecordedViewportHeight=this._viewportElement.offsetHeight;var newBufferHeight=Math.round(this._currentRowHeight*this._lastRecordedBufferLength)+(this._lastRecordedViewportHeight-this._terminal.renderer.dimensions.canvasHeight);this._lastRecordedBufferHeight!==newBufferHeight&&(this._lastRecordedBufferHeight=newBufferHeight,this._scrollArea.style.height=this._lastRecordedBufferHeight+"px")}var scrollTop=this._terminal.buffer.ydisp*this._currentRowHeight;this._viewportElement.scrollTop!==scrollTop&&(this._ignoreNextScrollEvent=!0,this._viewportElement.scrollTop=scrollTop),this._refreshAnimationFrame=null},Viewport.prototype.syncScrollArea=function(){if(this._lastRecordedBufferLength!==this._terminal.buffer.lines.length)return this._lastRecordedBufferLength=this._terminal.buffer.lines.length,void this._refresh();if(this._lastRecordedViewportHeight!==this._terminal.renderer.dimensions.canvasHeight)return void this._refresh();var newScrollTop=this._terminal.buffer.ydisp*this._currentRowHeight;return this._lastScrollTop!==newScrollTop?void this._refresh():this._lastScrollTop!==this._viewportElement.scrollTop?void this._refresh():this._terminal.renderer.dimensions.scaledCellHeight/window.devicePixelRatio!==this._currentRowHeight?void this._refresh():void 0},Viewport.prototype._onScroll=function(ev){if(this._lastScrollTop=this._viewportElement.scrollTop,this._viewportElement.offsetParent){if(this._ignoreNextScrollEvent)return void(this._ignoreNextScrollEvent=!1);var newRow=Math.round(this._lastScrollTop/this._currentRowHeight),diff=newRow-this._terminal.buffer.ydisp;this._terminal.scrollLines(diff,!0)}},Viewport.prototype.onWheel=function(ev){var amount=this._getPixelsScrolled(ev);0!==amount&&(this._viewportElement.scrollTop+=amount,ev.preventDefault())},Viewport.prototype._getPixelsScrolled=function(ev){if(0===ev.deltaY)return 0;var amount=ev.deltaY;return ev.deltaMode===WheelEvent.DOM_DELTA_LINE?amount*=this._currentRowHeight:ev.deltaMode===WheelEvent.DOM_DELTA_PAGE&&(amount*=this._currentRowHeight*this._terminal.rows),amount},Viewport.prototype.getLinesScrolled=function(ev){if(0===ev.deltaY)return 0;var amount=ev.deltaY;return ev.deltaMode===WheelEvent.DOM_DELTA_PIXEL?(amount/=this._currentRowHeight+0,this._wheelPartialScroll+=amount,amount=Math.floor(Math.abs(this._wheelPartialScroll))*(this._wheelPartialScroll>0?1:-1),this._wheelPartialScroll%=1):ev.deltaMode===WheelEvent.DOM_DELTA_PAGE&&(amount*=this._terminal.rows),amount},Viewport.prototype.onTouchStart=function(ev){this._lastTouchY=ev.touches[0].pageY},Viewport.prototype.onTouchMove=function(ev){var deltaY=this._lastTouchY-ev.touches[0].pageY;this._lastTouchY=ev.touches[0].pageY,0!==deltaY&&(this._viewportElement.scrollTop+=deltaY,ev.preventDefault())},Viewport}(Lifecycle_1.Disposable);exports.Viewport=Viewport},{"./common/Lifecycle":20,"./ui/Lifecycle":51}],17:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var _extendStatics10=function(d,b){return(_extendStatics10=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])})(d,b)};return function(d,b){function __(){this.constructor=d}_extendStatics10(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:!0});var EventEmitter_1=require("./EventEmitter"),CircularList=function(_super){function CircularList(_maxLength){var _this=_super.call(this)||this;return _this._maxLength=_maxLength,_this._array=new Array(_this._maxLength),_this._startIndex=0,_this._length=0,_this}return __extends(CircularList,_super),Object.defineProperty(CircularList.prototype,"maxLength",{get:function(){return this._maxLength},set:function(newMaxLength){if(this._maxLength!==newMaxLength){for(var newArray=new Array(newMaxLength),i=0;i<Math.min(newMaxLength,this.length);i++)newArray[i]=this._array[this._getCyclicIndex(i)];this._array=newArray,this._maxLength=newMaxLength,this._startIndex=0}},enumerable:!0,configurable:!0}),Object.defineProperty(CircularList.prototype,"length",{get:function(){return this._length},set:function(newLength){if(newLength>this._length)for(var i=this._length;i<newLength;i++)this._array[i]=void 0;this._length=newLength},enumerable:!0,configurable:!0}),CircularList.prototype.get=function(index){return this._array[this._getCyclicIndex(index)]},CircularList.prototype.set=function(index,value){this._array[this._getCyclicIndex(index)]=value},CircularList.prototype.push=function(value){this._array[this._getCyclicIndex(this._length)]=value,this._length===this._maxLength?(this._startIndex=++this._startIndex%this._maxLength,this.emitMayRemoveListeners("trim",1)):this._length++},CircularList.prototype.recycle=function(){if(this._length!==this._maxLength)throw new Error("Can only recycle when the buffer is full");return this._startIndex=++this._startIndex%this._maxLength,this.emitMayRemoveListeners("trim",1),this._array[this._getCyclicIndex(this._length-1)]},Object.defineProperty(CircularList.prototype,"isFull",{get:function(){return this._length===this._maxLength},enumerable:!0,configurable:!0}),CircularList.prototype.pop=function(){return this._array[this._getCyclicIndex(this._length---1)]},CircularList.prototype.splice=function(start,deleteCount){for(var items=[],_i=2;_i<arguments.length;_i++)items[_i-2]=arguments[_i];if(deleteCount){for(var i=start;i<this._length-deleteCount;i++)this._array[this._getCyclicIndex(i)]=this._array[this._getCyclicIndex(i+deleteCount)];this._length-=deleteCount}for(var i=this._length-1;i>=start;i--)this._array[this._getCyclicIndex(i+items.length)]=this._array[this._getCyclicIndex(i)];for(var i=0;i<items.length;i++)this._array[this._getCyclicIndex(start+i)]=items[i];if(this._length+items.length>this._maxLength){var countToTrim=this._length+items.length-this._maxLength;this._startIndex+=countToTrim,this._length=this._maxLength,this.emitMayRemoveListeners("trim",countToTrim)}else this._length+=items.length},CircularList.prototype.trimStart=function(count){count>this._length&&(count=this._length),this._startIndex+=count,this._length-=count,this.emitMayRemoveListeners("trim",count)},CircularList.prototype.shiftElements=function(start,count,offset){if(!(count<=0)){if(start<0||start>=this._length)throw new Error("start argument out of range");if(start+offset<0)throw new Error("Cannot shift elements in list beyond index 0");if(offset>0){for(var i=count-1;i>=0;i--)this.set(start+i+offset,this.get(start+i));var expandListBy=start+count+offset-this._length;if(expandListBy>0)for(this._length+=expandListBy;this._length>this._maxLength;)this._length--,this._startIndex++,this.emitMayRemoveListeners("trim",1)}else for(var i=0;i<count;i++)this.set(start+i+offset,this.get(start+i))}},CircularList.prototype._getCyclicIndex=function(index){return(this._startIndex+index)%this._maxLength},CircularList}(EventEmitter_1.EventEmitter);exports.CircularList=CircularList},{"./EventEmitter":19}],18:[function(require,module,exports){"use strict";function clone(val,depth){if(void 0===depth&&(depth=5),"object"!==_typeof(val))return val;if(null===val)return null;var clonedObject=Array.isArray(val)?[]:{};for(var key in val)clonedObject[key]=depth<=1?val[key]:clone(val[key],depth-1);return clonedObject}Object.defineProperty(exports,"__esModule",{value:!0}),exports.clone=clone},{}],19:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var _extendStatics11=function(d,b){return(_extendStatics11=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])})(d,b)};return function(d,b){function __(){this.constructor=d}_extendStatics11(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:!0});var Lifecycle_1=require("./Lifecycle"),EventEmitter=function(_super){function EventEmitter(){var _this=_super.call(this)||this;return _this._events=_this._events||{},_this}return __extends(EventEmitter,_super),EventEmitter.prototype.on=function(type,listener){this._events[type]=this._events[type]||[],this._events[type].push(listener)},EventEmitter.prototype.addDisposableListener=function(type,handler){var _this=this;this.on(type,handler);var disposed=!1;return{dispose:function(){disposed||(_this.off(type,handler),disposed=!0)}}},EventEmitter.prototype.off=function(type,listener){if(this._events[type])for(var obj=this._events[type],i=obj.length;i--;)if(obj[i]===listener)return void obj.splice(i,1)},EventEmitter.prototype.removeAllListeners=function(type){this._events[type]&&delete this._events[type]},EventEmitter.prototype.emit=function(type){for(var args=[],_i=1;_i<arguments.length;_i++)args[_i-1]=arguments[_i];if(this._events[type])for(var obj=this._events[type],i=0;i<obj.length;i++)obj[i].apply(this,args)},EventEmitter.prototype.emitMayRemoveListeners=function(type){for(var args=[],_i=1;_i<arguments.length;_i++)args[_i-1]=arguments[_i];if(this._events[type])for(var obj=this._events[type],length=obj.length,i=0;i<obj.length;i++)obj[i].apply(this,args),i-=length-obj.length,length=obj.length},EventEmitter.prototype.listeners=function(type){return this._events[type]||[]},EventEmitter.prototype.dispose=function(){_super.prototype.dispose.call(this),this._events={}},EventEmitter}(Lifecycle_1.Disposable);exports.EventEmitter=EventEmitter},{"./Lifecycle":20}],20:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var Disposable=function(){function Disposable(){this._disposables=[],this._isDisposed=!1}return Disposable.prototype.dispose=function(){this._isDisposed=!0,this._disposables.forEach(function(d){return d.dispose()}),this._disposables.length=0},Disposable.prototype.register=function(d){this._disposables.push(d)},Disposable.prototype.unregister=function(d){var index=this._disposables.indexOf(d);-1!==index&&this._disposables.splice(index,1)},Disposable}();exports.Disposable=Disposable},{}],21:[function(require,module,exports){"use strict";function fill(array,value,start,end){return array.fill?array.fill(value,start,end):fillFallback(array,value,start,end)}function fillFallback(array,value,start,end){if(void 0===start&&(start=0),void 0===end&&(end=array.length),start>=array.length)return array;start=(array.length+start)%array.length,end=end>=array.length?array.length:(array.length+end)%array.length;for(var i=start;i<end;++i)array[i]=value;return array}function concat(a,b){var result=new a.constructor(a.length+b.length);return result.set(a),result.set(b,a.length),result}Object.defineProperty(exports,"__esModule",{value:!0}),exports.fill=fill,exports.fillFallback=fillFallback,exports.concat=concat},{}],22:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:!0});!function(C0){C0.NUL="\0",C0.SOH="",C0.STX="",C0.ETX="",C0.EOT="",C0.ENQ="",C0.ACK="",C0.BEL="",C0.BS="\b",C0.HT="\t",C0.LF="\n",C0.VT="\v",C0.FF="\f",C0.CR="\r",C0.SO="",C0.SI="",C0.DLE="",C0.DC1="",C0.DC2="",C0.DC3="",C0.DC4="",C0.NAK="",C0.SYN="",C0.ETB="",C0.CAN="",C0.EM="",C0.SUB="",C0.ESC="",C0.FS="",C0.GS="",C0.RS="",C0.US="",C0.SP=" ",C0.DEL=""}(exports.C0||(exports.C0={}));!function(C1){C1.PAD="",C1.HOP="",C1.BPH="",C1.NBH="",C1.IND="",C1.NEL="",C1.SSA="",C1.ESA="",C1.HTS="",C1.HTJ="",C1.VTS="",C1.PLD="",C1.PLU="",C1.RI="",C1.SS2="",C1.SS3="",C1.DCS="",C1.PU1="",C1.PU2="",C1.STS="",C1.CCH="",C1.MW="",C1.SPA="",C1.EPA="",C1.SOS="",C1.SGCI="",C1.SCI="",C1.CSI="",C1.ST="",C1.OSC="",C1.PM="",C1.APC=""}(exports.C1||(exports.C1={}))},{}],23:[function(require,module,exports){"use strict";function contains(arr,el){return arr.indexOf(el)>=0}Object.defineProperty(exports,"__esModule",{value:!0});var isNode="undefined"==typeof navigator,userAgent=isNode?"node":navigator.userAgent,platform=isNode?"node":navigator.platform;exports.isFirefox=!!~userAgent.indexOf("Firefox"),exports.isSafari=/^((?!chrome|android).)*safari/i.test(userAgent),exports.isMSIE=!!~userAgent.indexOf("MSIE")||!!~userAgent.indexOf("Trident"),exports.isMac=contains(["Macintosh","MacIntel","MacPPC","Mac68K"],platform),exports.isIpad="iPad"===platform,exports.isIphone="iPhone"===platform,exports.isMSWindows=contains(["Windows","Win16","Win32","WinCE"],platform),exports.isLinux=platform.indexOf("Linux")>=0},{}],24:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.CHARSETS={},exports.DEFAULT_CHARSET=exports.CHARSETS.B,exports.CHARSETS[0]={"`":"◆",a:"▒",b:"\t",c:"\f",d:"\r",e:"\n",f:"°",g:"±",h:"␤",i:"\v",j:"┘",k:"┐",l:"┌",m:"└",n:"┼",o:"⎺",p:"⎻",q:"─",r:"⎼",s:"⎽",t:"├",u:"┤",v:"┴",w:"┬",x:"│",y:"≤",z:"≥","{":"π","|":"≠","}":"£","~":"·"},exports.CHARSETS.A={"#":"£"},exports.CHARSETS.B=null,exports.CHARSETS[4]={"#":"£","@":"¾","[":"ij","\\":"½","]":"|","{":"¨","|":"f","}":"¼","~":"´"},exports.CHARSETS.C=exports.CHARSETS[5]={"[":"Ä","\\":"Ö","]":"Å","^":"Ü","`":"é","{":"ä","|":"ö","}":"å","~":"ü"},exports.CHARSETS.R={"#":"£","@":"à","[":"°","\\":"ç","]":"§","{":"é","|":"ù","}":"è","~":"¨"},exports.CHARSETS.Q={"@":"à","[":"â","\\":"ç","]":"ê","^":"î","`":"ô","{":"é","|":"ù","}":"è","~":"û"},exports.CHARSETS.K={"@":"§","[":"Ä","\\":"Ö","]":"Ü","{":"ä","|":"ö","}":"ü","~":"ß"},exports.CHARSETS.Y={"#":"£","@":"§","[":"°","\\":"ç","]":"é","`":"ù","{":"à","|":"ò","}":"è","~":"ì"},exports.CHARSETS.E=exports.CHARSETS[6]={"@":"Ä","[":"Æ","\\":"Ø","]":"Å","^":"Ü","`":"ä","{":"æ","|":"ø","}":"å","~":"ü"},exports.CHARSETS.Z={"#":"£","@":"§","[":"¡","\\":"Ñ","]":"¿","{":"°","|":"ñ","}":"ç"},exports.CHARSETS.H=exports.CHARSETS[7]={"@":"É","[":"Ä","\\":"Ö","]":"Å","^":"Ü","`":"é","{":"ä","|":"ö","}":"å","~":"ü"},exports.CHARSETS["="]={"#":"ù","@":"à","[":"é","\\":"ç","]":"ê","^":"î",_:"è","`":"ô","{":"ä","|":"ö","}":"ü","~":"û"}},{}],25:[function(require,module,exports){"use strict";function evaluateKeyboardEvent(ev,applicationCursorMode,isMac,macOptionIsMeta){var result={type:0,cancel:!1,key:void 0},modifiers=(ev.shiftKey?1:0)|(ev.altKey?2:0)|(ev.ctrlKey?4:0)|(ev.metaKey?8:0);switch(ev.keyCode){case 0:"UIKeyInputUpArrow"===ev.key?result.key=applicationCursorMode?EscapeSequences_1.C0.ESC+"OA":EscapeSequences_1.C0.ESC+"[A":"UIKeyInputLeftArrow"===ev.key?result.key=applicationCursorMode?EscapeSequences_1.C0.ESC+"OD":EscapeSequences_1.C0.ESC+"[D":"UIKeyInputRightArrow"===ev.key?result.key=applicationCursorMode?EscapeSequences_1.C0.ESC+"OC":EscapeSequences_1.C0.ESC+"[C":"UIKeyInputDownArrow"===ev.key&&(result.key=applicationCursorMode?EscapeSequences_1.C0.ESC+"OB":EscapeSequences_1.C0.ESC+"[B");break;case 8:if(ev.shiftKey){result.key=EscapeSequences_1.C0.BS;break}if(ev.altKey){result.key=EscapeSequences_1.C0.ESC+EscapeSequences_1.C0.DEL;break}result.key=EscapeSequences_1.C0.DEL;break;case 9:if(ev.shiftKey){result.key=EscapeSequences_1.C0.ESC+"[Z";break}result.key=EscapeSequences_1.C0.HT,result.cancel=!0;break;case 13:result.key=EscapeSequences_1.C0.CR,result.cancel=!0;break;case 27:result.key=EscapeSequences_1.C0.ESC,result.cancel=!0;break;case 37:modifiers?(result.key=EscapeSequences_1.C0.ESC+"[1;"+(modifiers+1)+"D",result.key===EscapeSequences_1.C0.ESC+"[1;3D"&&(result.key=isMac?EscapeSequences_1.C0.ESC+"b":EscapeSequences_1.C0.ESC+"[1;5D")):result.key=applicationCursorMode?EscapeSequences_1.C0.ESC+"OD":EscapeSequences_1.C0.ESC+"[D";break;case 39:modifiers?(result.key=EscapeSequences_1.C0.ESC+"[1;"+(modifiers+1)+"C",result.key===EscapeSequences_1.C0.ESC+"[1;3C"&&(result.key=isMac?EscapeSequences_1.C0.ESC+"f":EscapeSequences_1.C0.ESC+"[1;5C")):result.key=applicationCursorMode?EscapeSequences_1.C0.ESC+"OC":EscapeSequences_1.C0.ESC+"[C";break;case 38:modifiers?(result.key=EscapeSequences_1.C0.ESC+"[1;"+(modifiers+1)+"A",result.key===EscapeSequences_1.C0.ESC+"[1;3A"&&(result.key=EscapeSequences_1.C0.ESC+"[1;5A")):result.key=applicationCursorMode?EscapeSequences_1.C0.ESC+"OA":EscapeSequences_1.C0.ESC+"[A";break;case 40:modifiers?(result.key=EscapeSequences_1.C0.ESC+"[1;"+(modifiers+1)+"B",result.key===EscapeSequences_1.C0.ESC+"[1;3B"&&(result.key=EscapeSequences_1.C0.ESC+"[1;5B")):result.key=applicationCursorMode?EscapeSequences_1.C0.ESC+"OB":EscapeSequences_1.C0.ESC+"[B";break;case 45:ev.shiftKey||ev.ctrlKey||(result.key=EscapeSequences_1.C0.ESC+"[2~");break;case 46:result.key=modifiers?EscapeSequences_1.C0.ESC+"[3;"+(modifiers+1)+"~":EscapeSequences_1.C0.ESC+"[3~";break;case 36:result.key=modifiers?EscapeSequences_1.C0.ESC+"[1;"+(modifiers+1)+"H":applicationCursorMode?EscapeSequences_1.C0.ESC+"OH":EscapeSequences_1.C0.ESC+"[H";break;case 35:result.key=modifiers?EscapeSequences_1.C0.ESC+"[1;"+(modifiers+1)+"F":applicationCursorMode?EscapeSequences_1.C0.ESC+"OF":EscapeSequences_1.C0.ESC+"[F";break;case 33:ev.shiftKey?result.type=2:result.key=EscapeSequences_1.C0.ESC+"[5~";break;case 34:ev.shiftKey?result.type=3:result.key=EscapeSequences_1.C0.ESC+"[6~";break;case 112:result.key=modifiers?EscapeSequences_1.C0.ESC+"[1;"+(modifiers+1)+"P":EscapeSequences_1.C0.ESC+"OP";break;case 113:result.key=modifiers?EscapeSequences_1.C0.ESC+"[1;"+(modifiers+1)+"Q":EscapeSequences_1.C0.ESC+"OQ";break;case 114:result.key=modifiers?EscapeSequences_1.C0.ESC+"[1;"+(modifiers+1)+"R":EscapeSequences_1.C0.ESC+"OR";break;case 115:result.key=modifiers?EscapeSequences_1.C0.ESC+"[1;"+(modifiers+1)+"S":EscapeSequences_1.C0.ESC+"OS";break;case 116:result.key=modifiers?EscapeSequences_1.C0.ESC+"[15;"+(modifiers+1)+"~":EscapeSequences_1.C0.ESC+"[15~";break;case 117:result.key=modifiers?EscapeSequences_1.C0.ESC+"[17;"+(modifiers+1)+"~":EscapeSequences_1.C0.ESC+"[17~";break;case 118:result.key=modifiers?EscapeSequences_1.C0.ESC+"[18;"+(modifiers+1)+"~":EscapeSequences_1.C0.ESC+"[18~";break;case 119:result.key=modifiers?EscapeSequences_1.C0.ESC+"[19;"+(modifiers+1)+"~":EscapeSequences_1.C0.ESC+"[19~";break;case 120:result.key=modifiers?EscapeSequences_1.C0.ESC+"[20;"+(modifiers+1)+"~":EscapeSequences_1.C0.ESC+"[20~";break;case 121:result.key=modifiers?EscapeSequences_1.C0.ESC+"[21;"+(modifiers+1)+"~":EscapeSequences_1.C0.ESC+"[21~";break;case 122:result.key=modifiers?EscapeSequences_1.C0.ESC+"[23;"+(modifiers+1)+"~":EscapeSequences_1.C0.ESC+"[23~";break;case 123:result.key=modifiers?EscapeSequences_1.C0.ESC+"[24;"+(modifiers+1)+"~":EscapeSequences_1.C0.ESC+"[24~";break;default:if(!ev.ctrlKey||ev.shiftKey||ev.altKey||ev.metaKey)if(isMac&&!macOptionIsMeta||!ev.altKey||ev.metaKey)isMac&&!ev.altKey&&!ev.ctrlKey&&ev.metaKey?65===ev.keyCode&&(result.type=1):ev.key&&!ev.ctrlKey&&!ev.altKey&&!ev.metaKey&&ev.keyCode>=48&&1===ev.key.length&&(result.key=ev.key);else{var keyMapping=KEYCODE_KEY_MAPPINGS[ev.keyCode],key=keyMapping&&keyMapping[ev.shiftKey?1:0];if(key)result.key=EscapeSequences_1.C0.ESC+key;else if(ev.keyCode>=65&&ev.keyCode<=90){var keyCode=ev.ctrlKey?ev.keyCode-64:ev.keyCode+32;result.key=EscapeSequences_1.C0.ESC+String.fromCharCode(keyCode)}}else ev.keyCode>=65&&ev.keyCode<=90?result.key=String.fromCharCode(ev.keyCode-64):32===ev.keyCode?result.key=String.fromCharCode(0):ev.keyCode>=51&&ev.keyCode<=55?result.key=String.fromCharCode(ev.keyCode-51+27):56===ev.keyCode?result.key=String.fromCharCode(127):219===ev.keyCode?result.key=String.fromCharCode(27):220===ev.keyCode?result.key=String.fromCharCode(28):221===ev.keyCode&&(result.key=String.fromCharCode(29))}return result}Object.defineProperty(exports,"__esModule",{value:!0});var EscapeSequences_1=require("../../common/data/EscapeSequences"),KEYCODE_KEY_MAPPINGS={48:["0",")"],49:["1","!"],50:["2","@"],51:["3","#"],52:["4","$"],53:["5","%"],54:["6","^"],55:["7","&"],56:["8","*"],57:["9","("],186:[";",":"],187:["=","+"],188:[",","<"],189:["-","_"],190:[".",">"],191:["/","?"],192:["`","~"],219:["[","{"],220:["\\","|"],221:["]","}"],222:["'",'"']};exports.evaluateKeyboardEvent=evaluateKeyboardEvent},{"../../common/data/EscapeSequences":22}],26:[function(require,module,exports){"use strict";function stringFromCodePoint(codePoint){return codePoint>65535?(codePoint-=65536,String.fromCharCode(55296+(codePoint>>10))+String.fromCharCode(codePoint%1024+56320)):String.fromCharCode(codePoint)}function utf32ToString(data,start,end){void 0===start&&(start=0),void 0===end&&(end=data.length);for(var result="",i=start;i<end;++i){var codepoint=data[i];codepoint>65535?(codepoint-=65536,result+=String.fromCharCode(55296+(codepoint>>10))+String.fromCharCode(codepoint%1024+56320)):result+=String.fromCharCode(codepoint)}return result}Object.defineProperty(exports,"__esModule",{value:!0});var StringToUtf32=function(){function StringToUtf32(){this._interim=0}return StringToUtf32.prototype.clear=function(){this._interim=0},StringToUtf32.prototype.decode=function(input,target){var length=input.length;if(!length)return 0;var size=0,startPos=0;if(this._interim){var second=input.charCodeAt(startPos++);56320<=second&&second<=57343?target[size++]=1024*(this._interim-55296)+second-56320+65536:(target[size++]=this._interim,target[size++]=second),this._interim=0}for(var i=startPos;i<length;++i){var code=input.charCodeAt(i);if(55296<=code&&code<=56319){if(++i>=length)return this._interim=code,size;var second=input.charCodeAt(i);56320<=second&&second<=57343?target[size++]=1024*(code-55296)+second-56320+65536:(target[size++]=code,target[size++]=second)}else target[size++]=code}return size},StringToUtf32}();exports.StringToUtf32=StringToUtf32,exports.stringFromCodePoint=stringFromCodePoint,exports.utf32ToString=utf32ToString},{}],27:[function(require,module,exports){"use strict";function repeat(count,str){count=Math.floor(count);for(var rpt="",i=0;i<count;i++)rpt+=str;return rpt}Object.defineProperty(exports,"__esModule",{value:!0});var EscapeSequences_1=require("../common/data/EscapeSequences"),AltClickHandler=function(){function AltClickHandler(_mouseEvent,_terminal){var _a;this._mouseEvent=_mouseEvent,this._terminal=_terminal,this._lines=this._terminal.buffer.lines,this._startCol=this._terminal.buffer.x,this._startRow=this._terminal.buffer.y;var coordinates=this._terminal.mouseHelper.getCoords(this._mouseEvent,this._terminal.element,this._terminal.charMeasure,this._terminal.cols,this._terminal.rows,!1);coordinates&&(_a=coordinates.map(function(coordinate){return coordinate-1}),this._endCol=_a[0],this._endRow=_a[1])}return AltClickHandler.prototype.move=function(){this._mouseEvent.altKey&&void 0!==this._endCol&&void 0!==this._endRow&&this._terminal.handler(this._arrowSequences())},AltClickHandler.prototype._arrowSequences=function(){return this._terminal.buffer.hasScrollback?this._moveHorizontallyOnly():this._resetStartingRow()+this._moveToRequestedRow()+this._moveToRequestedCol()},AltClickHandler.prototype._resetStartingRow=function(){return 0===this._moveToRequestedRow().length?"":repeat(this._bufferLine(this._startCol,this._startRow,this._startCol,this._startRow-this._wrappedRowsForRow(this._startRow),!1).length,this._sequence("D"))},AltClickHandler.prototype._moveToRequestedRow=function(){
var startRow=this._startRow-this._wrappedRowsForRow(this._startRow),endRow=this._endRow-this._wrappedRowsForRow(this._endRow);return repeat(Math.abs(startRow-endRow)-this._wrappedRowsCount(),this._sequence(this._verticalDirection()))},AltClickHandler.prototype._moveToRequestedCol=function(){var startRow;startRow=this._moveToRequestedRow().length>0?this._endRow-this._wrappedRowsForRow(this._endRow):this._startRow;var endRow=this._endRow,direction=this._horizontalDirection();return repeat(this._bufferLine(this._startCol,startRow,this._endCol,endRow,"C"===direction).length,this._sequence(direction))},AltClickHandler.prototype._moveHorizontallyOnly=function(){var direction=this._horizontalDirection();return repeat(Math.abs(this._startCol-this._endCol),this._sequence(direction))},AltClickHandler.prototype._wrappedRowsCount=function(){for(var wrappedRows=0,startRow=this._startRow-this._wrappedRowsForRow(this._startRow),endRow=this._endRow-this._wrappedRowsForRow(this._endRow),i=0;i<Math.abs(startRow-endRow);i++){var direction="A"===this._verticalDirection()?-1:1;this._lines.get(startRow+direction*i).isWrapped&&wrappedRows++}return wrappedRows},AltClickHandler.prototype._wrappedRowsForRow=function(currentRow){for(var rowCount=0,lineWraps=this._lines.get(currentRow).isWrapped;lineWraps&&currentRow>=0&&currentRow<this._terminal.rows;)rowCount++,currentRow--,lineWraps=this._lines.get(currentRow).isWrapped;return rowCount},AltClickHandler.prototype._horizontalDirection=function(){var startRow;return startRow=this._moveToRequestedRow().length>0?this._endRow-this._wrappedRowsForRow(this._endRow):this._startRow,this._startCol<this._endCol&&startRow<=this._endRow||this._startCol>=this._endCol&&startRow<this._endRow?"C":"D"},AltClickHandler.prototype._verticalDirection=function(){return this._startRow>this._endRow?"A":"B"},AltClickHandler.prototype._bufferLine=function(startCol,startRow,endCol,endRow,forward){for(var currentCol=startCol,currentRow=startRow,bufferStr="";currentCol!==endCol||currentRow!==endRow;)currentCol+=forward?1:-1,forward&&currentCol>this._terminal.cols-1?(bufferStr+=this._terminal.buffer.translateBufferLineToString(currentRow,!1,startCol,currentCol),currentCol=0,startCol=0,currentRow++):!forward&&currentCol<0&&(bufferStr+=this._terminal.buffer.translateBufferLineToString(currentRow,!1,0,startCol+1),currentCol=this._terminal.cols-1,startCol=currentCol,currentRow--);return bufferStr+this._terminal.buffer.translateBufferLineToString(currentRow,!1,startCol,currentCol)},AltClickHandler.prototype._sequence=function(direction){var mod=this._terminal.applicationCursor?"O":"[";return EscapeSequences_1.C0.ESC+mod+direction},AltClickHandler}();exports.AltClickHandler=AltClickHandler},{"../common/data/EscapeSequences":22}],28:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var Terminal_1=require("../Terminal"),Strings=require("../Strings"),Terminal=function(){function Terminal(options){this._core=new Terminal_1.Terminal(options)}return Object.defineProperty(Terminal.prototype,"element",{get:function(){return this._core.element},enumerable:!0,configurable:!0}),Object.defineProperty(Terminal.prototype,"textarea",{get:function(){return this._core.textarea},enumerable:!0,configurable:!0}),Object.defineProperty(Terminal.prototype,"rows",{get:function(){return this._core.rows},enumerable:!0,configurable:!0}),Object.defineProperty(Terminal.prototype,"cols",{get:function(){return this._core.cols},enumerable:!0,configurable:!0}),Object.defineProperty(Terminal.prototype,"markers",{get:function(){return this._core.markers},enumerable:!0,configurable:!0}),Terminal.prototype.blur=function(){this._core.blur()},Terminal.prototype.focus=function(){this._core.focus()},Terminal.prototype.on=function(type,listener){this._core.on(type,listener)},Terminal.prototype.off=function(type,listener){this._core.off(type,listener)},Terminal.prototype.emit=function(type,data){this._core.emit(type,data)},Terminal.prototype.addDisposableListener=function(type,handler){return this._core.addDisposableListener(type,handler)},Terminal.prototype.resize=function(columns,rows){this._core.resize(columns,rows)},Terminal.prototype.writeln=function(data){this._core.writeln(data)},Terminal.prototype.open=function(parent){this._core.open(parent)},Terminal.prototype.attachCustomKeyEventHandler=function(customKeyEventHandler){this._core.attachCustomKeyEventHandler(customKeyEventHandler)},Terminal.prototype.addCsiHandler=function(flag,callback){return this._core.addCsiHandler(flag,callback)},Terminal.prototype.addOscHandler=function(ident,callback){return this._core.addOscHandler(ident,callback)},Terminal.prototype.registerLinkMatcher=function(regex,handler,options){return this._core.registerLinkMatcher(regex,handler,options)},Terminal.prototype.deregisterLinkMatcher=function(matcherId){this._core.deregisterLinkMatcher(matcherId)},Terminal.prototype.registerCharacterJoiner=function(handler){return this._core.registerCharacterJoiner(handler)},Terminal.prototype.deregisterCharacterJoiner=function(joinerId){this._core.deregisterCharacterJoiner(joinerId)},Terminal.prototype.addMarker=function(cursorYOffset){return this._core.addMarker(cursorYOffset)},Terminal.prototype.hasSelection=function(){return this._core.hasSelection()},Terminal.prototype.getSelection=function(){return this._core.getSelection()},Terminal.prototype.clearSelection=function(){this._core.clearSelection()},Terminal.prototype.selectAll=function(){this._core.selectAll()},Terminal.prototype.selectLines=function(start,end){this._core.selectLines(start,end)},Terminal.prototype.dispose=function(){this._core.dispose()},Terminal.prototype.destroy=function(){this._core.destroy()},Terminal.prototype.scrollLines=function(amount){this._core.scrollLines(amount)},Terminal.prototype.scrollPages=function(pageCount){this._core.scrollPages(pageCount)},Terminal.prototype.scrollToTop=function(){this._core.scrollToTop()},Terminal.prototype.scrollToBottom=function(){this._core.scrollToBottom()},Terminal.prototype.scrollToLine=function(line){this._core.scrollToLine(line)},Terminal.prototype.clear=function(){this._core.clear()},Terminal.prototype.write=function(data){this._core.write(data)},Terminal.prototype.getOption=function(key){return this._core.getOption(key)},Terminal.prototype.setOption=function(key,value){this._core.setOption(key,value)},Terminal.prototype.refresh=function(start,end){this._core.refresh(start,end)},Terminal.prototype.reset=function(){this._core.reset()},Terminal.applyAddon=function(addon){addon.apply(Terminal)},Object.defineProperty(Terminal,"strings",{get:function(){return Strings},enumerable:!0,configurable:!0}),Terminal}();exports.Terminal=Terminal},{"../Strings":14,"../Terminal":15}],29:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var Types_1=require("./atlas/Types"),CharAtlasCache_1=require("./atlas/CharAtlasCache"),Buffer_1=require("../Buffer"),CharAtlasUtils_1=require("./atlas/CharAtlasUtils"),BaseRenderLayer=function(){function BaseRenderLayer(_container,id,zIndex,_alpha,_colors){this._container=_container,this._alpha=_alpha,this._colors=_colors,this._scaledCharWidth=0,this._scaledCharHeight=0,this._scaledCellWidth=0,this._scaledCellHeight=0,this._scaledCharLeft=0,this._scaledCharTop=0,this._currentGlyphIdentifier={chars:"",code:0,bg:0,fg:0,bold:!1,dim:!1,italic:!1},this._canvas=document.createElement("canvas"),this._canvas.classList.add("xterm-"+id+"-layer"),this._canvas.style.zIndex=zIndex.toString(),this._initCanvas(),this._container.appendChild(this._canvas)}return BaseRenderLayer.prototype.dispose=function(){this._container.removeChild(this._canvas),this._charAtlas&&this._charAtlas.dispose()},BaseRenderLayer.prototype._initCanvas=function(){this._ctx=this._canvas.getContext("2d",{alpha:this._alpha}),this._alpha||this.clearAll()},BaseRenderLayer.prototype.onOptionsChanged=function(terminal){},BaseRenderLayer.prototype.onBlur=function(terminal){},BaseRenderLayer.prototype.onFocus=function(terminal){},BaseRenderLayer.prototype.onCursorMove=function(terminal){},BaseRenderLayer.prototype.onGridChanged=function(terminal,startRow,endRow){},BaseRenderLayer.prototype.onSelectionChanged=function(terminal,start,end,columnSelectMode){void 0===columnSelectMode&&(columnSelectMode=!1)},BaseRenderLayer.prototype.onThemeChanged=function(terminal,colorSet){this._refreshCharAtlas(terminal,colorSet)},BaseRenderLayer.prototype.setTransparency=function(terminal,alpha){if(alpha!==this._alpha){var oldCanvas=this._canvas;this._alpha=alpha,this._canvas=this._canvas.cloneNode(),this._initCanvas(),this._container.replaceChild(this._canvas,oldCanvas),this._refreshCharAtlas(terminal,this._colors),this.onGridChanged(terminal,0,terminal.rows-1)}},BaseRenderLayer.prototype._refreshCharAtlas=function(terminal,colorSet){this._scaledCharWidth<=0&&this._scaledCharHeight<=0||(this._charAtlas=CharAtlasCache_1.acquireCharAtlas(terminal,colorSet,this._scaledCharWidth,this._scaledCharHeight),this._charAtlas.warmUp())},BaseRenderLayer.prototype.resize=function(terminal,dim){this._scaledCellWidth=dim.scaledCellWidth,this._scaledCellHeight=dim.scaledCellHeight,this._scaledCharWidth=dim.scaledCharWidth,this._scaledCharHeight=dim.scaledCharHeight,this._scaledCharLeft=dim.scaledCharLeft,this._scaledCharTop=dim.scaledCharTop,this._canvas.width=dim.scaledCanvasWidth,this._canvas.height=dim.scaledCanvasHeight,this._canvas.style.width=dim.canvasWidth+"px",this._canvas.style.height=dim.canvasHeight+"px",this._alpha||this.clearAll(),this._refreshCharAtlas(terminal,this._colors)},BaseRenderLayer.prototype.fillCells=function(x,y,width,height){this._ctx.fillRect(x*this._scaledCellWidth,y*this._scaledCellHeight,width*this._scaledCellWidth,height*this._scaledCellHeight)},BaseRenderLayer.prototype.fillBottomLineAtCells=function(x,y,width){void 0===width&&(width=1),this._ctx.fillRect(x*this._scaledCellWidth,(y+1)*this._scaledCellHeight-window.devicePixelRatio-1,width*this._scaledCellWidth,window.devicePixelRatio)},BaseRenderLayer.prototype.fillLeftLineAtCell=function(x,y){this._ctx.fillRect(x*this._scaledCellWidth,y*this._scaledCellHeight,window.devicePixelRatio,this._scaledCellHeight)},BaseRenderLayer.prototype.strokeRectAtCell=function(x,y,width,height){this._ctx.lineWidth=window.devicePixelRatio,this._ctx.strokeRect(x*this._scaledCellWidth+window.devicePixelRatio/2,y*this._scaledCellHeight+window.devicePixelRatio/2,width*this._scaledCellWidth-window.devicePixelRatio,height*this._scaledCellHeight-window.devicePixelRatio)},BaseRenderLayer.prototype.clearAll=function(){this._alpha?this._ctx.clearRect(0,0,this._canvas.width,this._canvas.height):(this._ctx.fillStyle=this._colors.background.css,this._ctx.fillRect(0,0,this._canvas.width,this._canvas.height))},BaseRenderLayer.prototype.clearCells=function(x,y,width,height){this._alpha?this._ctx.clearRect(x*this._scaledCellWidth,y*this._scaledCellHeight,width*this._scaledCellWidth,height*this._scaledCellHeight):(this._ctx.fillStyle=this._colors.background.css,this._ctx.fillRect(x*this._scaledCellWidth,y*this._scaledCellHeight,width*this._scaledCellWidth,height*this._scaledCellHeight))},BaseRenderLayer.prototype.fillCharTrueColor=function(terminal,charData,x,y){this._ctx.font=this._getFont(terminal,!1,!1),this._ctx.textBaseline="middle",this._clipRow(terminal,y),this._ctx.fillText(charData[Buffer_1.CHAR_DATA_CHAR_INDEX],x*this._scaledCellWidth+this._scaledCharLeft,(y+.5)*this._scaledCellHeight+this._scaledCharTop)},BaseRenderLayer.prototype.drawChars=function(terminal,chars,code,width,x,y,fg,bg,bold,dim,italic){fg+=terminal.options.drawBoldTextInBrightColors&&bold&&fg<8&&fg!==Types_1.INVERTED_DEFAULT_COLOR?8:0,this._currentGlyphIdentifier.chars=chars,this._currentGlyphIdentifier.code=code,this._currentGlyphIdentifier.bg=bg,this._currentGlyphIdentifier.fg=fg,this._currentGlyphIdentifier.bold=bold&&terminal.options.enableBold,this._currentGlyphIdentifier.dim=dim,this._currentGlyphIdentifier.italic=italic,this._charAtlas&&this._charAtlas.draw(this._ctx,this._currentGlyphIdentifier,x*this._scaledCellWidth+this._scaledCharLeft,y*this._scaledCellHeight+this._scaledCharTop)||this._drawUncachedChars(terminal,chars,width,fg,x,y,bold&&terminal.options.enableBold,dim,italic)},BaseRenderLayer.prototype._drawUncachedChars=function(terminal,chars,width,fg,x,y,bold,dim,italic){this._ctx.save(),this._ctx.font=this._getFont(terminal,bold,italic),this._ctx.textBaseline="middle",fg===Types_1.INVERTED_DEFAULT_COLOR?this._ctx.fillStyle=this._colors.background.css:CharAtlasUtils_1.is256Color(fg)?this._ctx.fillStyle=this._colors.ansi[fg].css:this._ctx.fillStyle=this._colors.foreground.css,this._clipRow(terminal,y),dim&&(this._ctx.globalAlpha=Types_1.DIM_OPACITY),this._ctx.fillText(chars,x*this._scaledCellWidth+this._scaledCharLeft,(y+.5)*this._scaledCellHeight+this._scaledCharTop),this._ctx.restore()},BaseRenderLayer.prototype._clipRow=function(terminal,y){this._ctx.beginPath(),this._ctx.rect(0,y*this._scaledCellHeight,terminal.cols*this._scaledCellWidth,this._scaledCellHeight),this._ctx.clip()},BaseRenderLayer.prototype._getFont=function(terminal,isBold,isItalic){var fontWeight=isBold?terminal.options.fontWeightBold:terminal.options.fontWeight;return(isItalic?"italic":"")+" "+fontWeight+" "+terminal.options.fontSize*window.devicePixelRatio+"px "+terminal.options.fontFamily},BaseRenderLayer}();exports.BaseRenderLayer=BaseRenderLayer},{"../Buffer":2,"./atlas/CharAtlasCache":39,"./atlas/CharAtlasUtils":41,"./atlas/Types":46}],30:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var Buffer_1=require("../Buffer"),CharacterJoinerRegistry=function(){function CharacterJoinerRegistry(_terminal){this._terminal=_terminal,this._characterJoiners=[],this._nextCharacterJoinerId=0}return CharacterJoinerRegistry.prototype.registerCharacterJoiner=function(handler){var joiner={id:this._nextCharacterJoinerId++,handler:handler};return this._characterJoiners.push(joiner),joiner.id},CharacterJoinerRegistry.prototype.deregisterCharacterJoiner=function(joinerId){for(var i=0;i<this._characterJoiners.length;i++)if(this._characterJoiners[i].id===joinerId)return this._characterJoiners.splice(i,1),!0;return!1},CharacterJoinerRegistry.prototype.getJoinedCharacters=function(row){if(0===this._characterJoiners.length)return[];var line=this._terminal.buffer.lines.get(row);if(0===line.length)return[];for(var ranges=[],lineStr=this._terminal.buffer.translateBufferLineToString(row,!0),rangeStartColumn=0,currentStringIndex=0,rangeStartStringIndex=0,rangeAttr=line.get(0)[Buffer_1.CHAR_DATA_ATTR_INDEX]>>9,x=0;x<this._terminal.cols;x++){var charData=line.get(x),chars=charData[Buffer_1.CHAR_DATA_CHAR_INDEX],width=charData[Buffer_1.CHAR_DATA_WIDTH_INDEX],attr=charData[Buffer_1.CHAR_DATA_ATTR_INDEX]>>9;if(0!==width){if(attr!==rangeAttr){if(x-rangeStartColumn>1)for(var joinedRanges=this._getJoinedRanges(lineStr,rangeStartStringIndex,currentStringIndex,line,rangeStartColumn),i=0;i<joinedRanges.length;i++)ranges.push(joinedRanges[i]);rangeStartColumn=x,rangeStartStringIndex=currentStringIndex,rangeAttr=attr}currentStringIndex+=chars.length}}if(this._terminal.cols-rangeStartColumn>1)for(var joinedRanges=this._getJoinedRanges(lineStr,rangeStartStringIndex,currentStringIndex,line,rangeStartColumn),i=0;i<joinedRanges.length;i++)ranges.push(joinedRanges[i]);return ranges},CharacterJoinerRegistry.prototype._getJoinedRanges=function(line,startIndex,endIndex,lineData,startCol){for(var text=line.substring(startIndex,endIndex),joinedRanges=this._characterJoiners[0].handler(text),i=1;i<this._characterJoiners.length;i++)for(var joinerRanges=this._characterJoiners[i].handler(text),j=0;j<joinerRanges.length;j++)CharacterJoinerRegistry._mergeRanges(joinedRanges,joinerRanges[j]);return this._stringRangesToCellRanges(joinedRanges,lineData,startCol),joinedRanges},CharacterJoinerRegistry.prototype._stringRangesToCellRanges=function(ranges,line,startCol){var currentRangeIndex=0,currentRangeStarted=!1,currentStringIndex=0,currentRange=ranges[currentRangeIndex];if(currentRange){for(var x=startCol;x<this._terminal.cols;x++){var charData=line.get(x),width=charData[Buffer_1.CHAR_DATA_WIDTH_INDEX],length_1=charData[Buffer_1.CHAR_DATA_CHAR_INDEX].length;if(0!==width){if(!currentRangeStarted&&currentRange[0]<=currentStringIndex&&(currentRange[0]=x,currentRangeStarted=!0),currentRange[1]<=currentStringIndex){if(currentRange[1]=x,!(currentRange=ranges[++currentRangeIndex]))break;currentRange[0]<=currentStringIndex?(currentRange[0]=x,currentRangeStarted=!0):currentRangeStarted=!1}currentStringIndex+=length_1}}currentRange&&(currentRange[1]=this._terminal.cols)}},CharacterJoinerRegistry._mergeRanges=function(ranges,newRange){for(var inRange=!1,i=0;i<ranges.length;i++){var range=ranges[i];if(inRange){if(newRange[1]<=range[0])return ranges[i-1][1]=newRange[1],ranges;if(newRange[1]<=range[1])return ranges[i-1][1]=Math.max(newRange[1],range[1]),ranges.splice(i,1),inRange=!1,ranges;ranges.splice(i,1),i--}else{if(newRange[1]<=range[0])return ranges.splice(i,0,newRange),ranges;if(newRange[1]<=range[1])return range[0]=Math.min(newRange[0],range[0]),ranges;newRange[0]<range[1]&&(range[0]=Math.min(newRange[0],range[0]),inRange=!0)}}return inRange?ranges[ranges.length-1][1]=newRange[1]:ranges.push(newRange),ranges},CharacterJoinerRegistry}();exports.CharacterJoinerRegistry=CharacterJoinerRegistry},{"../Buffer":2}],31:[function(require,module,exports){"use strict";function fromHex(css){return{css:css,rgba:parseInt(css.slice(1),16)<<8|255}}function toPaddedHex(c){var s=c.toString(16);return s.length<2?"0"+s:s}Object.defineProperty(exports,"__esModule",{value:!0});var DEFAULT_FOREGROUND=fromHex("#ffffff"),DEFAULT_BACKGROUND=fromHex("#000000"),DEFAULT_CURSOR=fromHex("#ffffff"),DEFAULT_CURSOR_ACCENT=fromHex("#000000"),DEFAULT_SELECTION={css:"rgba(255, 255, 255, 0.3)",rgba:4294967159};exports.DEFAULT_ANSI_COLORS=function(){for(var colors=[fromHex("#2e3436"),fromHex("#cc0000"),fromHex("#4e9a06"),fromHex("#c4a000"),fromHex("#3465a4"),fromHex("#75507b"),fromHex("#06989a"),fromHex("#d3d7cf"),fromHex("#555753"),fromHex("#ef2929"),fromHex("#8ae234"),fromHex("#fce94f"),fromHex("#729fcf"),fromHex("#ad7fa8"),fromHex("#34e2e2"),fromHex("#eeeeec")],v=[0,95,135,175,215,255],i=0;i<216;i++){var r=v[i/36%6|0],g=v[i/6%6|0],b=v[i%6];colors.push({css:"#"+toPaddedHex(r)+toPaddedHex(g)+toPaddedHex(b),rgba:(r<<24|g<<16|b<<8|255)>>>0})}for(var i=0;i<24;i++){var c=8+10*i,ch=toPaddedHex(c);colors.push({css:"#"+ch+ch+ch,rgba:(c<<24|c<<16|c<<8|255)>>>0})}return colors}();var ColorManager=function(){function ColorManager(document,allowTransparency){this.allowTransparency=allowTransparency;var canvas=document.createElement("canvas");canvas.width=1,canvas.height=1,this._ctx=canvas.getContext("2d"),this._ctx.globalCompositeOperation="copy",this._litmusColor=this._ctx.createLinearGradient(0,0,1,1),this.colors={foreground:DEFAULT_FOREGROUND,background:DEFAULT_BACKGROUND,cursor:DEFAULT_CURSOR,cursorAccent:DEFAULT_CURSOR_ACCENT,selection:DEFAULT_SELECTION,ansi:exports.DEFAULT_ANSI_COLORS.slice()}}return ColorManager.prototype.setTheme=function(theme){this.colors.foreground=this._parseColor(theme.foreground,DEFAULT_FOREGROUND),this.colors.background=this._parseColor(theme.background,DEFAULT_BACKGROUND),this.colors.cursor=this._parseColor(theme.cursor,DEFAULT_CURSOR,!0),this.colors.cursorAccent=this._parseColor(theme.cursorAccent,DEFAULT_CURSOR_ACCENT,!0),this.colors.selection=this._parseColor(theme.selection,DEFAULT_SELECTION,!0),this.colors.ansi[0]=this._parseColor(theme.black,exports.DEFAULT_ANSI_COLORS[0]),this.colors.ansi[1]=this._parseColor(theme.red,exports.DEFAULT_ANSI_COLORS[1]),this.colors.ansi[2]=this._parseColor(theme.green,exports.DEFAULT_ANSI_COLORS[2]),this.colors.ansi[3]=this._parseColor(theme.yellow,exports.DEFAULT_ANSI_COLORS[3]),this.colors.ansi[4]=this._parseColor(theme.blue,exports.DEFAULT_ANSI_COLORS[4]),this.colors.ansi[5]=this._parseColor(theme.magenta,exports.DEFAULT_ANSI_COLORS[5]),this.colors.ansi[6]=this._parseColor(theme.cyan,exports.DEFAULT_ANSI_COLORS[6]),this.colors.ansi[7]=this._parseColor(theme.white,exports.DEFAULT_ANSI_COLORS[7]),this.colors.ansi[8]=this._parseColor(theme.brightBlack,exports.DEFAULT_ANSI_COLORS[8]),this.colors.ansi[9]=this._parseColor(theme.brightRed,exports.DEFAULT_ANSI_COLORS[9]),this.colors.ansi[10]=this._parseColor(theme.brightGreen,exports.DEFAULT_ANSI_COLORS[10]),this.colors.ansi[11]=this._parseColor(theme.brightYellow,exports.DEFAULT_ANSI_COLORS[11]),this.colors.ansi[12]=this._parseColor(theme.brightBlue,exports.DEFAULT_ANSI_COLORS[12]),this.colors.ansi[13]=this._parseColor(theme.brightMagenta,exports.DEFAULT_ANSI_COLORS[13]),this.colors.ansi[14]=this._parseColor(theme.brightCyan,exports.DEFAULT_ANSI_COLORS[14]),this.colors.ansi[15]=this._parseColor(theme.brightWhite,exports.DEFAULT_ANSI_COLORS[15])},ColorManager.prototype._parseColor=function(css,fallback,allowTransparency){if(void 0===allowTransparency&&(allowTransparency=this.allowTransparency),!css)return fallback;if(this._ctx.fillStyle=this._litmusColor,this._ctx.fillStyle=css,"string"!=typeof this._ctx.fillStyle)return console.warn("Color: "+css+" is invalid using fallback "+fallback.css),fallback;this._ctx.fillRect(0,0,1,1);var data=this._ctx.getImageData(0,0,1,1).data;return allowTransparency||255===data[3]?{css:css,rgba:(data[0]<<24|data[1]<<16|data[2]<<8|data[3])>>>0}:(console.warn("Color: "+css+" is using transparency, but allowTransparency is false. Using fallback "+fallback.css+"."),fallback)},ColorManager}();exports.ColorManager=ColorManager},{}],32:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var _extendStatics12=function(d,b){return(_extendStatics12=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])})(d,b)};return function(d,b){function __(){this.constructor=d}_extendStatics12(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:!0});var Buffer_1=require("../Buffer"),BaseRenderLayer_1=require("./BaseRenderLayer"),CursorRenderLayer=function(_super){function CursorRenderLayer(container,zIndex,colors){var _this=_super.call(this,container,"cursor",zIndex,!0,colors)||this;return _this._state={x:null,y:null,isFocused:null,style:null,width:null},_this._cursorRenderers={bar:_this._renderBarCursor.bind(_this),block:_this._renderBlockCursor.bind(_this),underline:_this._renderUnderlineCursor.bind(_this)},_this}return __extends(CursorRenderLayer,_super),CursorRenderLayer.prototype.resize=function(terminal,dim){_super.prototype.resize.call(this,terminal,dim),this._state={x:null,y:null,isFocused:null,style:null,width:null}},CursorRenderLayer.prototype.reset=function(terminal){this._clearCursor(),this._cursorBlinkStateManager&&(this._cursorBlinkStateManager.dispose(),this._cursorBlinkStateManager=null,this.onOptionsChanged(terminal))},CursorRenderLayer.prototype.onBlur=function(terminal){this._cursorBlinkStateManager&&this._cursorBlinkStateManager.pause(),terminal.refresh(terminal.buffer.y,terminal.buffer.y)},CursorRenderLayer.prototype.onFocus=function(terminal){this._cursorBlinkStateManager?this._cursorBlinkStateManager.resume(terminal):terminal.refresh(terminal.buffer.y,terminal.buffer.y)},CursorRenderLayer.prototype.onOptionsChanged=function(terminal){var _this=this;terminal.options.cursorBlink?this._cursorBlinkStateManager||(this._cursorBlinkStateManager=new CursorBlinkStateManager(terminal,function(){_this._render(terminal,!0)})):(this._cursorBlinkStateManager&&(this._cursorBlinkStateManager.dispose(),this._cursorBlinkStateManager=null),terminal.refresh(terminal.buffer.y,terminal.buffer.y))},CursorRenderLayer.prototype.onCursorMove=function(terminal){this._cursorBlinkStateManager&&this._cursorBlinkStateManager.restartBlinkAnimation(terminal)},CursorRenderLayer.prototype.onGridChanged=function(terminal,startRow,endRow){!this._cursorBlinkStateManager||this._cursorBlinkStateManager.isPaused?this._render(terminal,!1):this._cursorBlinkStateManager.restartBlinkAnimation(terminal)},CursorRenderLayer.prototype._render=function(terminal,triggeredByAnimationFrame){if(!terminal.cursorState||terminal.cursorHidden)return void this._clearCursor();var cursorY=terminal.buffer.ybase+terminal.buffer.y,viewportRelativeCursorY=cursorY-terminal.buffer.ydisp;if(viewportRelativeCursorY<0||viewportRelativeCursorY>=terminal.rows)return void this._clearCursor();var charData=terminal.buffer.lines.get(cursorY).get(terminal.buffer.x);if(charData){if(!terminal.isFocused)return this._clearCursor(),this._ctx.save(),this._ctx.fillStyle=this._colors.cursor.css,this._renderBlurCursor(terminal,terminal.buffer.x,viewportRelativeCursorY,charData),this._ctx.restore(),this._state.x=terminal.buffer.x,this._state.y=viewportRelativeCursorY,this._state.isFocused=!1,this._state.style=terminal.options.cursorStyle,void(this._state.width=charData[Buffer_1.CHAR_DATA_WIDTH_INDEX]);if(this._cursorBlinkStateManager&&!this._cursorBlinkStateManager.isCursorVisible)return void this._clearCursor();if(this._state){if(this._state.x===terminal.buffer.x&&this._state.y===viewportRelativeCursorY&&this._state.isFocused===terminal.isFocused&&this._state.style===terminal.options.cursorStyle&&this._state.width===charData[Buffer_1.CHAR_DATA_WIDTH_INDEX])return;this._clearCursor()}this._ctx.save(),this._cursorRenderers[terminal.options.cursorStyle||"block"](terminal,terminal.buffer.x,viewportRelativeCursorY,charData),this._ctx.restore(),this._state.x=terminal.buffer.x,this._state.y=viewportRelativeCursorY,this._state.isFocused=!1,this._state.style=terminal.options.cursorStyle,this._state.width=charData[Buffer_1.CHAR_DATA_WIDTH_INDEX]}},CursorRenderLayer.prototype._clearCursor=function(){this._state&&(this.clearCells(this._state.x,this._state.y,this._state.width,1),this._state={x:null,y:null,isFocused:null,style:null,width:null})},CursorRenderLayer.prototype._renderBarCursor=function(terminal,x,y,charData){this._ctx.save(),this._ctx.fillStyle=this._colors.cursor.css,this.fillLeftLineAtCell(x,y),this._ctx.restore()},CursorRenderLayer.prototype._renderBlockCursor=function(terminal,x,y,charData){this._ctx.save(),this._ctx.fillStyle=this._colors.cursor.css,this.fillCells(x,y,charData[Buffer_1.CHAR_DATA_WIDTH_INDEX],1),this._ctx.fillStyle=this._colors.cursorAccent.css,this.fillCharTrueColor(terminal,charData,x,y),this._ctx.restore()},CursorRenderLayer.prototype._renderUnderlineCursor=function(terminal,x,y,charData){this._ctx.save(),this._ctx.fillStyle=this._colors.cursor.css,this.fillBottomLineAtCells(x,y),this._ctx.restore()},CursorRenderLayer.prototype._renderBlurCursor=function(terminal,x,y,charData){this._ctx.save(),this._ctx.strokeStyle=this._colors.cursor.css,this.strokeRectAtCell(x,y,charData[Buffer_1.CHAR_DATA_WIDTH_INDEX],1),this._ctx.restore()},CursorRenderLayer}(BaseRenderLayer_1.BaseRenderLayer);exports.CursorRenderLayer=CursorRenderLayer;var CursorBlinkStateManager=function(){function CursorBlinkStateManager(terminal,_renderCallback){this._renderCallback=_renderCallback,this.isCursorVisible=!0,terminal.isFocused&&this._restartInterval()}return Object.defineProperty(CursorBlinkStateManager.prototype,"isPaused",{get:function(){return!(this._blinkStartTimeout||this._blinkInterval)},enumerable:!0,configurable:!0}),CursorBlinkStateManager.prototype.dispose=function(){this._blinkInterval&&(window.clearInterval(this._blinkInterval),this._blinkInterval=null),this._blinkStartTimeout&&(window.clearTimeout(this._blinkStartTimeout),this._blinkStartTimeout=null),this._animationFrame&&(window.cancelAnimationFrame(this._animationFrame),this._animationFrame=null)},CursorBlinkStateManager.prototype.restartBlinkAnimation=function(terminal){var _this=this;this.isPaused||(this._animationTimeRestarted=Date.now(),this.isCursorVisible=!0,this._animationFrame||(this._animationFrame=window.requestAnimationFrame(function(){_this._renderCallback(),_this._animationFrame=null})))},CursorBlinkStateManager.prototype._restartInterval=function(timeToStart){var _this=this;void 0===timeToStart&&(timeToStart=600),this._blinkInterval&&window.clearInterval(this._blinkInterval),this._blinkStartTimeout=setTimeout(function(){if(_this._animationTimeRestarted){var time=600-(Date.now()-_this._animationTimeRestarted);if(_this._animationTimeRestarted=null,time>0)return void _this._restartInterval(time)}_this.isCursorVisible=!1,_this._animationFrame=window.requestAnimationFrame(function(){_this._renderCallback(),_this._animationFrame=null}),_this._blinkInterval=setInterval(function(){if(_this._animationTimeRestarted){var time=600-(Date.now()-_this._animationTimeRestarted);return _this._animationTimeRestarted=null,void _this._restartInterval(time)}_this.isCursorVisible=!_this.isCursorVisible,_this._animationFrame=window.requestAnimationFrame(function(){_this._renderCallback(),_this._animationFrame=null})},600)},timeToStart)},CursorBlinkStateManager.prototype.pause=function(){this.isCursorVisible=!0,this._blinkInterval&&(window.clearInterval(this._blinkInterval),this._blinkInterval=null),this._blinkStartTimeout&&(window.clearTimeout(this._blinkStartTimeout),this._blinkStartTimeout=null),this._animationFrame&&(window.cancelAnimationFrame(this._animationFrame),this._animationFrame=null)},CursorBlinkStateManager.prototype.resume=function(terminal){this._animationTimeRestarted=null,this._restartInterval(),this.restartBlinkAnimation(terminal)},CursorBlinkStateManager}()},{"../Buffer":2,"./BaseRenderLayer":29}],33:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var GridCache=function(){function GridCache(){this.cache=[]}return GridCache.prototype.resize=function(width,height){for(var x=0;x<width;x++){this.cache.length<=x&&this.cache.push([]);for(var y=this.cache[x].length;y<height;y++)this.cache[x].push(null);this.cache[x].length=height}this.cache.length=width},GridCache.prototype.clear=function(){for(var x=0;x<this.cache.length;x++)for(var y=0;y<this.cache[x].length;y++)this.cache[x][y]=null},GridCache}();exports.GridCache=GridCache},{}],34:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var _extendStatics13=function(d,b){return(_extendStatics13=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])})(d,b)};return function(d,b){function __(){this.constructor=d}_extendStatics13(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:!0});var BaseRenderLayer_1=require("./BaseRenderLayer"),Types_1=require("./atlas/Types"),CharAtlasUtils_1=require("./atlas/CharAtlasUtils"),LinkRenderLayer=function(_super){function LinkRenderLayer(container,zIndex,colors,terminal){var _this=_super.call(this,container,"link",zIndex,!0,colors)||this;return _this._state=null,terminal.linkifier.on("linkhover",function(e){return _this._onLinkHover(e)}),terminal.linkifier.on("linkleave",function(e){return _this._onLinkLeave(e)}),_this}return __extends(LinkRenderLayer,_super),LinkRenderLayer.prototype.resize=function(terminal,dim){_super.prototype.resize.call(this,terminal,dim),this._state=null},LinkRenderLayer.prototype.reset=function(terminal){this._clearCurrentLink()},LinkRenderLayer.prototype._clearCurrentLink=function(){if(this._state){this.clearCells(this._state.x1,this._state.y1,this._state.cols-this._state.x1,1);var middleRowCount=this._state.y2-this._state.y1-1;middleRowCount>0&&this.clearCells(0,this._state.y1+1,this._state.cols,middleRowCount),this.clearCells(0,this._state.y2,this._state.x2,1),this._state=null}},LinkRenderLayer.prototype._onLinkHover=function(e){
if(e.fg===Types_1.INVERTED_DEFAULT_COLOR?this._ctx.fillStyle=this._colors.background.css:CharAtlasUtils_1.is256Color(e.fg)?this._ctx.fillStyle=this._colors.ansi[e.fg].css:this._ctx.fillStyle=this._colors.foreground.css,e.y1===e.y2)this.fillBottomLineAtCells(e.x1,e.y1,e.x2-e.x1);else{this.fillBottomLineAtCells(e.x1,e.y1,e.cols-e.x1);for(var y=e.y1+1;y<e.y2;y++)this.fillBottomLineAtCells(0,y,e.cols);this.fillBottomLineAtCells(0,e.y2,e.x2)}this._state=e},LinkRenderLayer.prototype._onLinkLeave=function(e){this._clearCurrentLink()},LinkRenderLayer}(BaseRenderLayer_1.BaseRenderLayer);exports.LinkRenderLayer=LinkRenderLayer},{"./BaseRenderLayer":29,"./atlas/CharAtlasUtils":41,"./atlas/Types":46}],35:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var _extendStatics14=function(d,b){return(_extendStatics14=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])})(d,b)};return function(d,b){function __(){this.constructor=d}_extendStatics14(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:!0});var TextRenderLayer_1=require("./TextRenderLayer"),SelectionRenderLayer_1=require("./SelectionRenderLayer"),CursorRenderLayer_1=require("./CursorRenderLayer"),ColorManager_1=require("./ColorManager"),LinkRenderLayer_1=require("./LinkRenderLayer"),EventEmitter_1=require("../common/EventEmitter"),RenderDebouncer_1=require("../ui/RenderDebouncer"),ScreenDprMonitor_1=require("../ui/ScreenDprMonitor"),CharacterJoinerRegistry_1=require("../renderer/CharacterJoinerRegistry"),Renderer=function(_super){function Renderer(_terminal,theme){var _this=_super.call(this)||this;_this._terminal=_terminal,_this._isPaused=!1,_this._needsFullRefresh=!1;var allowTransparency=_this._terminal.options.allowTransparency;if(_this.colorManager=new ColorManager_1.ColorManager(document,allowTransparency),_this._characterJoinerRegistry=new CharacterJoinerRegistry_1.CharacterJoinerRegistry(_terminal),theme&&_this.colorManager.setTheme(theme),_this._renderLayers=[new TextRenderLayer_1.TextRenderLayer(_this._terminal.screenElement,0,_this.colorManager.colors,_this._characterJoinerRegistry,allowTransparency),new SelectionRenderLayer_1.SelectionRenderLayer(_this._terminal.screenElement,1,_this.colorManager.colors),new LinkRenderLayer_1.LinkRenderLayer(_this._terminal.screenElement,2,_this.colorManager.colors,_this._terminal),new CursorRenderLayer_1.CursorRenderLayer(_this._terminal.screenElement,3,_this.colorManager.colors)],_this.dimensions={scaledCharWidth:null,scaledCharHeight:null,scaledCellWidth:null,scaledCellHeight:null,scaledCharLeft:null,scaledCharTop:null,scaledCanvasWidth:null,scaledCanvasHeight:null,canvasWidth:null,canvasHeight:null,actualCellWidth:null,actualCellHeight:null},_this._devicePixelRatio=window.devicePixelRatio,_this._updateDimensions(),_this.onOptionsChanged(),_this._renderDebouncer=new RenderDebouncer_1.RenderDebouncer(_this._terminal,_this._renderRows.bind(_this)),_this._screenDprMonitor=new ScreenDprMonitor_1.ScreenDprMonitor,_this._screenDprMonitor.setListener(function(){return _this.onWindowResize(window.devicePixelRatio)}),_this.register(_this._screenDprMonitor),"IntersectionObserver"in window){var observer_1=new IntersectionObserver(function(e){return _this.onIntersectionChange(e[0])},{threshold:0});observer_1.observe(_this._terminal.element),_this.register({dispose:function(){return observer_1.disconnect()}})}return _this}return __extends(Renderer,_super),Renderer.prototype.dispose=function(){_super.prototype.dispose.call(this),this._renderLayers.forEach(function(l){return l.dispose()})},Renderer.prototype.onIntersectionChange=function(entry){this._isPaused=0===entry.intersectionRatio,!this._isPaused&&this._needsFullRefresh&&this._terminal.refresh(0,this._terminal.rows-1)},Renderer.prototype.onWindowResize=function(devicePixelRatio){this._devicePixelRatio!==devicePixelRatio&&(this._devicePixelRatio=devicePixelRatio,this.onResize(this._terminal.cols,this._terminal.rows))},Renderer.prototype.setTheme=function(theme){var _this=this;return this.colorManager.setTheme(theme),this._renderLayers.forEach(function(l){l.onThemeChanged(_this._terminal,_this.colorManager.colors),l.reset(_this._terminal)}),this._isPaused?this._needsFullRefresh=!0:this._terminal.refresh(0,this._terminal.rows-1),this.colorManager.colors},Renderer.prototype.onResize=function(cols,rows){var _this=this;this._updateDimensions(),this._renderLayers.forEach(function(l){return l.resize(_this._terminal,_this.dimensions)}),this._isPaused?this._needsFullRefresh=!0:this._terminal.refresh(0,this._terminal.rows-1),this._terminal.screenElement.style.width=this.dimensions.canvasWidth+"px",this._terminal.screenElement.style.height=this.dimensions.canvasHeight+"px",this.emit("resize",{width:this.dimensions.canvasWidth,height:this.dimensions.canvasHeight})},Renderer.prototype.onCharSizeChanged=function(){this.onResize(this._terminal.cols,this._terminal.rows)},Renderer.prototype.onBlur=function(){var _this=this;this._runOperation(function(l){return l.onBlur(_this._terminal)})},Renderer.prototype.onFocus=function(){var _this=this;this._runOperation(function(l){return l.onFocus(_this._terminal)})},Renderer.prototype.onSelectionChanged=function(start,end,columnSelectMode){var _this=this;void 0===columnSelectMode&&(columnSelectMode=!1),this._runOperation(function(l){return l.onSelectionChanged(_this._terminal,start,end,columnSelectMode)})},Renderer.prototype.onCursorMove=function(){var _this=this;this._runOperation(function(l){return l.onCursorMove(_this._terminal)})},Renderer.prototype.onOptionsChanged=function(){var _this=this;this.colorManager.allowTransparency=this._terminal.options.allowTransparency,this._runOperation(function(l){return l.onOptionsChanged(_this._terminal)})},Renderer.prototype.clear=function(){var _this=this;this._runOperation(function(l){return l.reset(_this._terminal)})},Renderer.prototype._runOperation=function(operation){this._isPaused?this._needsFullRefresh=!0:this._renderLayers.forEach(function(l){return operation(l)})},Renderer.prototype.refreshRows=function(start,end){if(this._isPaused)return void(this._needsFullRefresh=!0);this._renderDebouncer.refresh(start,end)},Renderer.prototype._renderRows=function(start,end){var _this=this;this._renderLayers.forEach(function(l){return l.onGridChanged(_this._terminal,start,end)}),this._terminal.emit("refresh",{start:start,end:end})},Renderer.prototype._updateDimensions=function(){this._terminal.charMeasure.width&&this._terminal.charMeasure.height&&(this.dimensions.scaledCharWidth=Math.floor(this._terminal.charMeasure.width*window.devicePixelRatio),this.dimensions.scaledCharHeight=Math.ceil(this._terminal.charMeasure.height*window.devicePixelRatio),this.dimensions.scaledCellHeight=Math.floor(this.dimensions.scaledCharHeight*this._terminal.options.lineHeight),this.dimensions.scaledCharTop=1===this._terminal.options.lineHeight?0:Math.round((this.dimensions.scaledCellHeight-this.dimensions.scaledCharHeight)/2),this.dimensions.scaledCellWidth=this.dimensions.scaledCharWidth+Math.round(this._terminal.options.letterSpacing),this.dimensions.scaledCharLeft=Math.floor(this._terminal.options.letterSpacing/2),this.dimensions.scaledCanvasHeight=this._terminal.rows*this.dimensions.scaledCellHeight,this.dimensions.scaledCanvasWidth=this._terminal.cols*this.dimensions.scaledCellWidth,this.dimensions.canvasHeight=Math.round(this.dimensions.scaledCanvasHeight/window.devicePixelRatio),this.dimensions.canvasWidth=Math.round(this.dimensions.scaledCanvasWidth/window.devicePixelRatio),this.dimensions.actualCellHeight=this.dimensions.canvasHeight/this._terminal.rows,this.dimensions.actualCellWidth=this.dimensions.canvasWidth/this._terminal.cols)},Renderer.prototype.registerCharacterJoiner=function(handler){return this._characterJoinerRegistry.registerCharacterJoiner(handler)},Renderer.prototype.deregisterCharacterJoiner=function(joinerId){return this._characterJoinerRegistry.deregisterCharacterJoiner(joinerId)},Renderer}(EventEmitter_1.EventEmitter);exports.Renderer=Renderer},{"../common/EventEmitter":19,"../renderer/CharacterJoinerRegistry":30,"../ui/RenderDebouncer":54,"../ui/ScreenDprMonitor":55,"./ColorManager":31,"./CursorRenderLayer":32,"./LinkRenderLayer":34,"./SelectionRenderLayer":36,"./TextRenderLayer":37}],36:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var _extendStatics15=function(d,b){return(_extendStatics15=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])})(d,b)};return function(d,b){function __(){this.constructor=d}_extendStatics15(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:!0});var BaseRenderLayer_1=require("./BaseRenderLayer"),SelectionRenderLayer=function(_super){function SelectionRenderLayer(container,zIndex,colors){var _this=_super.call(this,container,"selection",zIndex,!0,colors)||this;return _this._clearState(),_this}return __extends(SelectionRenderLayer,_super),SelectionRenderLayer.prototype._clearState=function(){this._state={start:null,end:null,columnSelectMode:null,ydisp:null}},SelectionRenderLayer.prototype.resize=function(terminal,dim){_super.prototype.resize.call(this,terminal,dim),this._clearState()},SelectionRenderLayer.prototype.reset=function(terminal){this._state.start&&this._state.end&&(this._clearState(),this.clearAll())},SelectionRenderLayer.prototype.onSelectionChanged=function(terminal,start,end,columnSelectMode){if(this._didStateChange(start,end,columnSelectMode,terminal.buffer.ydisp)&&(this.clearAll(),start&&end)){var viewportStartRow=start[1]-terminal.buffer.ydisp,viewportEndRow=end[1]-terminal.buffer.ydisp,viewportCappedStartRow=Math.max(viewportStartRow,0),viewportCappedEndRow=Math.min(viewportEndRow,terminal.rows-1);if(!(viewportCappedStartRow>=terminal.rows||viewportCappedEndRow<0)){if(this._ctx.fillStyle=this._colors.selection.css,columnSelectMode){var startCol=start[0],width=end[0]-startCol,height=viewportCappedEndRow-viewportCappedStartRow+1;this.fillCells(startCol,viewportCappedStartRow,width,height)}else{var startCol=viewportStartRow===viewportCappedStartRow?start[0]:0,startRowEndCol=viewportCappedStartRow===viewportCappedEndRow?end[0]:terminal.cols;this.fillCells(startCol,viewportCappedStartRow,startRowEndCol-startCol,1);var middleRowsCount=Math.max(viewportCappedEndRow-viewportCappedStartRow-1,0);if(this.fillCells(0,viewportCappedStartRow+1,terminal.cols,middleRowsCount),viewportCappedStartRow!==viewportCappedEndRow){var endCol=viewportEndRow===viewportCappedEndRow?end[0]:terminal.cols;this.fillCells(0,viewportCappedEndRow,endCol,1)}}this._state.start=[start[0],start[1]],this._state.end=[end[0],end[1]],this._state.columnSelectMode=columnSelectMode,this._state.ydisp=terminal.buffer.ydisp}}},SelectionRenderLayer.prototype._didStateChange=function(start,end,columnSelectMode,ydisp){return!this._areCoordinatesEqual(start,this._state.start)||!this._areCoordinatesEqual(end,this._state.end)||columnSelectMode!==this._state.columnSelectMode||ydisp!==this._state.ydisp},SelectionRenderLayer.prototype._areCoordinatesEqual=function(coord1,coord2){return!(!coord1||!coord2)&&(coord1[0]===coord2[0]&&coord1[1]===coord2[1])},SelectionRenderLayer}(BaseRenderLayer_1.BaseRenderLayer);exports.SelectionRenderLayer=SelectionRenderLayer},{"./BaseRenderLayer":29}],37:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var _extendStatics16=function(d,b){return(_extendStatics16=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])})(d,b)};return function(d,b){function __(){this.constructor=d}_extendStatics16(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:!0});var Buffer_1=require("../Buffer"),Types_1=require("./atlas/Types"),GridCache_1=require("./GridCache"),BaseRenderLayer_1=require("./BaseRenderLayer"),CharAtlasUtils_1=require("./atlas/CharAtlasUtils"),TextRenderLayer=function(_super){function TextRenderLayer(container,zIndex,colors,characterJoinerRegistry,alpha){var _this=_super.call(this,container,"text",zIndex,alpha,colors)||this;return _this._characterOverlapCache={},_this._state=new GridCache_1.GridCache,_this._characterJoinerRegistry=characterJoinerRegistry,_this}return __extends(TextRenderLayer,_super),TextRenderLayer.prototype.resize=function(terminal,dim){_super.prototype.resize.call(this,terminal,dim);var terminalFont=this._getFont(terminal,!1,!1);this._characterWidth===dim.scaledCharWidth&&this._characterFont===terminalFont||(this._characterWidth=dim.scaledCharWidth,this._characterFont=terminalFont,this._characterOverlapCache={}),this._state.clear(),this._state.resize(terminal.cols,terminal.rows)},TextRenderLayer.prototype.reset=function(terminal){this._state.clear(),this.clearAll()},TextRenderLayer.prototype._forEachCell=function(terminal,firstRow,lastRow,joinerRegistry,callback){for(var y=firstRow;y<=lastRow;y++)for(var row=y+terminal.buffer.ydisp,line=terminal.buffer.lines.get(row),joinedRanges=joinerRegistry?joinerRegistry.getJoinedCharacters(row):[],x=0;x<terminal.cols;x++){var charData=line.get(x),code=charData[Buffer_1.CHAR_DATA_CODE_INDEX]||Buffer_1.WHITESPACE_CELL_CODE,chars=charData[Buffer_1.CHAR_DATA_CHAR_INDEX]||Buffer_1.WHITESPACE_CELL_CHAR,attr=charData[Buffer_1.CHAR_DATA_ATTR_INDEX],width=charData[Buffer_1.CHAR_DATA_WIDTH_INDEX],isJoined=!1,lastCharX=x;if(0!==width){if(joinedRanges.length>0&&x===joinedRanges[0][0]){isJoined=!0;var range=joinedRanges.shift();chars=terminal.buffer.translateBufferLineToString(row,!0,range[0],range[1]),width=range[1]-range[0],code=1/0,lastCharX=range[1]-1}!isJoined&&this._isOverlapping(charData)&&lastCharX<line.length-1&&line.get(lastCharX+1)[Buffer_1.CHAR_DATA_CODE_INDEX]===Buffer_1.NULL_CELL_CODE&&(width=2);var flags=attr>>18,bg=511&attr,fg=attr>>9&511;if(8&flags){var temp=bg;bg=fg,fg=temp,fg===Types_1.DEFAULT_COLOR&&(fg=Types_1.INVERTED_DEFAULT_COLOR),bg===Types_1.DEFAULT_COLOR&&(bg=Types_1.INVERTED_DEFAULT_COLOR)}callback(code,chars,width,x,y,fg,bg,flags),x=lastCharX}}},TextRenderLayer.prototype._drawBackground=function(terminal,firstRow,lastRow){var _this=this,ctx=this._ctx,cols=terminal.cols,startX=0,startY=0,prevFillStyle=null;ctx.save(),this._forEachCell(terminal,firstRow,lastRow,null,function(code,chars,width,x,y,fg,bg,flags){var nextFillStyle=null;bg===Types_1.INVERTED_DEFAULT_COLOR?nextFillStyle=_this._colors.foreground.css:CharAtlasUtils_1.is256Color(bg)&&(nextFillStyle=_this._colors.ansi[bg].css),null===prevFillStyle&&(startX=x,startY=y),y!==startY?(ctx.fillStyle=prevFillStyle,_this.fillCells(startX,startY,cols-startX,1),startX=x,startY=y):prevFillStyle!==nextFillStyle&&(ctx.fillStyle=prevFillStyle,_this.fillCells(startX,startY,x-startX,1),startX=x,startY=y),prevFillStyle=nextFillStyle}),null!==prevFillStyle&&(ctx.fillStyle=prevFillStyle,this.fillCells(startX,startY,cols-startX,1)),ctx.restore()},TextRenderLayer.prototype._drawForeground=function(terminal,firstRow,lastRow){var _this=this;this._forEachCell(terminal,firstRow,lastRow,this._characterJoinerRegistry,function(code,chars,width,x,y,fg,bg,flags){16&flags||(2&flags&&(_this._ctx.save(),fg===Types_1.INVERTED_DEFAULT_COLOR?_this._ctx.fillStyle=_this._colors.background.css:CharAtlasUtils_1.is256Color(fg)?_this._ctx.fillStyle=_this._colors.ansi[fg].css:_this._ctx.fillStyle=_this._colors.foreground.css,_this.fillBottomLineAtCells(x,y,width),_this._ctx.restore()),_this.drawChars(terminal,chars,code,width,x,y,fg,bg,!!(1&flags),!!(32&flags),!!(64&flags)))})},TextRenderLayer.prototype.onGridChanged=function(terminal,firstRow,lastRow){0!==this._state.cache.length&&(this._charAtlas&&this._charAtlas.beginFrame(),this.clearCells(0,firstRow,terminal.cols,lastRow-firstRow+1),this._drawBackground(terminal,firstRow,lastRow),this._drawForeground(terminal,firstRow,lastRow))},TextRenderLayer.prototype.onOptionsChanged=function(terminal){this.setTransparency(terminal,terminal.options.allowTransparency)},TextRenderLayer.prototype._isOverlapping=function(charData){if(1!==charData[Buffer_1.CHAR_DATA_WIDTH_INDEX])return!1;if(charData[Buffer_1.CHAR_DATA_CODE_INDEX]<256)return!1;var _char10=charData[Buffer_1.CHAR_DATA_CHAR_INDEX];if(this._characterOverlapCache.hasOwnProperty(_char10))return this._characterOverlapCache[_char10];this._ctx.save(),this._ctx.font=this._characterFont;var overlaps=Math.floor(this._ctx.measureText(_char10).width)>this._characterWidth;return this._ctx.restore(),this._characterOverlapCache[_char10]=overlaps,overlaps},TextRenderLayer}(BaseRenderLayer_1.BaseRenderLayer);exports.TextRenderLayer=TextRenderLayer},{"../Buffer":2,"./BaseRenderLayer":29,"./GridCache":33,"./atlas/CharAtlasUtils":41,"./atlas/Types":46}],38:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var BaseCharAtlas=function(){function BaseCharAtlas(){this._didWarmUp=!1}return BaseCharAtlas.prototype.dispose=function(){},BaseCharAtlas.prototype.warmUp=function(){this._didWarmUp||(this._doWarmUp(),this._didWarmUp=!0)},BaseCharAtlas.prototype._doWarmUp=function(){},BaseCharAtlas.prototype.beginFrame=function(){},BaseCharAtlas}();exports.default=BaseCharAtlas},{}],39:[function(require,module,exports){"use strict";function acquireCharAtlas(terminal,colors,scaledCharWidth,scaledCharHeight){for(var newConfig=CharAtlasUtils_1.generateConfig(scaledCharWidth,scaledCharHeight,terminal,colors),i=0;i<charAtlasCache.length;i++){var entry=charAtlasCache[i],ownedByIndex=entry.ownedBy.indexOf(terminal);if(ownedByIndex>=0){if(CharAtlasUtils_1.configEquals(entry.config,newConfig))return entry.atlas;1===entry.ownedBy.length?(entry.atlas.dispose(),charAtlasCache.splice(i,1)):entry.ownedBy.splice(ownedByIndex,1);break}}for(var i=0;i<charAtlasCache.length;i++){var entry=charAtlasCache[i];if(CharAtlasUtils_1.configEquals(entry.config,newConfig))return entry.ownedBy.push(terminal),entry.atlas}var newEntry={atlas:new charAtlasImplementations[terminal.options.experimentalCharAtlas](document,newConfig),config:newConfig,ownedBy:[terminal]};return charAtlasCache.push(newEntry),newEntry.atlas}function removeTerminalFromCache(terminal){for(var i=0;i<charAtlasCache.length;i++){var index=charAtlasCache[i].ownedBy.indexOf(terminal);if(-1!==index){1===charAtlasCache[i].ownedBy.length?(charAtlasCache[i].atlas.dispose(),charAtlasCache.splice(i,1)):charAtlasCache[i].ownedBy.splice(index,1);break}}}Object.defineProperty(exports,"__esModule",{value:!0});var CharAtlasUtils_1=require("./CharAtlasUtils"),DynamicCharAtlas_1=require("./DynamicCharAtlas"),NoneCharAtlas_1=require("./NoneCharAtlas"),StaticCharAtlas_1=require("./StaticCharAtlas"),charAtlasImplementations={none:NoneCharAtlas_1.default,static:StaticCharAtlas_1.default,dynamic:DynamicCharAtlas_1.default},charAtlasCache=[];exports.acquireCharAtlas=acquireCharAtlas,exports.removeTerminalFromCache=removeTerminalFromCache},{"./CharAtlasUtils":41,"./DynamicCharAtlas":42,"./NoneCharAtlas":44,"./StaticCharAtlas":45}],40:[function(require,module,exports){"use strict";function generateStaticCharAtlasTexture(context,canvasFactory,config){var cellWidth=config.scaledCharWidth+Types_1.CHAR_ATLAS_CELL_SPACING,cellHeight=config.scaledCharHeight+Types_1.CHAR_ATLAS_CELL_SPACING,canvas=canvasFactory(255*cellWidth,34*cellHeight),ctx=canvas.getContext("2d",{alpha:config.allowTransparency});ctx.fillStyle=config.colors.background.css,ctx.fillRect(0,0,canvas.width,canvas.height),ctx.save(),ctx.fillStyle=config.colors.foreground.css,ctx.font=getFont(config.fontWeight,config),ctx.textBaseline="middle";for(var i=0;i<256;i++)ctx.save(),ctx.beginPath(),ctx.rect(i*cellWidth,0,cellWidth,cellHeight),ctx.clip(),ctx.fillText(String.fromCharCode(i),i*cellWidth,cellHeight/2),ctx.restore();ctx.save(),ctx.font=getFont(config.fontWeightBold,config);for(var i=0;i<256;i++)ctx.save(),ctx.beginPath(),ctx.rect(i*cellWidth,cellHeight,cellWidth,cellHeight),ctx.clip(),ctx.fillText(String.fromCharCode(i),i*cellWidth,1.5*cellHeight),ctx.restore();ctx.restore(),ctx.font=getFont(config.fontWeight,config);for(var colorIndex=0;colorIndex<16;colorIndex++)for(var y=(colorIndex+2)*cellHeight,i=0;i<256;i++)ctx.save(),ctx.beginPath(),ctx.rect(i*cellWidth,y,cellWidth,cellHeight),ctx.clip(),ctx.fillStyle=config.colors.ansi[colorIndex].css,ctx.fillText(String.fromCharCode(i),i*cellWidth,y+cellHeight/2),ctx.restore();ctx.font=getFont(config.fontWeightBold,config);for(var colorIndex=0;colorIndex<16;colorIndex++)for(var y=(colorIndex+2+16)*cellHeight,i=0;i<256;i++)ctx.save(),ctx.beginPath(),ctx.rect(i*cellWidth,y,cellWidth,cellHeight),ctx.clip(),ctx.fillStyle=config.colors.ansi[colorIndex].css,ctx.fillText(String.fromCharCode(i),i*cellWidth,y+cellHeight/2),ctx.restore();if(ctx.restore(),!("createImageBitmap"in context)||Platform_1.isFirefox||Platform_1.isSafari)return canvas;var charAtlasImageData=ctx.getImageData(0,0,canvas.width,canvas.height);return clearColor(charAtlasImageData,config.colors.background),context.createImageBitmap(charAtlasImageData)}function clearColor(imageData,color){for(var isEmpty=!0,r=color.rgba>>>24,g=color.rgba>>>16&255,b=color.rgba>>>8&255,offset=0;offset<imageData.data.length;offset+=4)imageData.data[offset]===r&&imageData.data[offset+1]===g&&imageData.data[offset+2]===b?imageData.data[offset+3]=0:isEmpty=!1;return isEmpty}function getFont(fontWeight,config){return fontWeight+" "+config.fontSize*config.devicePixelRatio+"px "+config.fontFamily}Object.defineProperty(exports,"__esModule",{value:!0});var Platform_1=require("../../core/Platform"),Types_1=require("./Types");exports.generateStaticCharAtlasTexture=generateStaticCharAtlasTexture,exports.clearColor=clearColor},{"../../core/Platform":23,"./Types":46}],41:[function(require,module,exports){"use strict";function generateConfig(scaledCharWidth,scaledCharHeight,terminal,colors){var clonedColors={foreground:colors.foreground,background:colors.background,cursor:null,cursorAccent:null,selection:null,ansi:colors.ansi.slice(0,16)};return{type:terminal.options.experimentalCharAtlas,devicePixelRatio:window.devicePixelRatio,scaledCharWidth:scaledCharWidth,scaledCharHeight:scaledCharHeight,fontFamily:terminal.options.fontFamily,fontSize:terminal.options.fontSize,fontWeight:terminal.options.fontWeight,fontWeightBold:terminal.options.fontWeightBold,allowTransparency:terminal.options.allowTransparency,colors:clonedColors}}function configEquals(a,b){for(var i=0;i<a.colors.ansi.length;i++)if(a.colors.ansi[i].rgba!==b.colors.ansi[i].rgba)return!1;return a.type===b.type&&a.devicePixelRatio===b.devicePixelRatio&&a.fontFamily===b.fontFamily&&a.fontSize===b.fontSize&&a.fontWeight===b.fontWeight&&a.fontWeightBold===b.fontWeightBold&&a.allowTransparency===b.allowTransparency&&a.scaledCharWidth===b.scaledCharWidth&&a.scaledCharHeight===b.scaledCharHeight&&a.colors.foreground===b.colors.foreground&&a.colors.background===b.colors.background}function is256Color(colorCode){return colorCode<Types_1.DEFAULT_COLOR}Object.defineProperty(exports,"__esModule",{value:!0});var Types_1=require("./Types");exports.generateConfig=generateConfig,exports.configEquals=configEquals,exports.is256Color=is256Color},{"./Types":46}],42:[function(require,module,exports){"use strict";function getGlyphCacheKey(glyph){return glyph.code<<21|glyph.bg<<12|glyph.fg<<3|(glyph.bold?0:4)+(glyph.dim?0:2)+(glyph.italic?0:1)}var __extends=this&&this.__extends||function(){var _extendStatics17=function(d,b){return(_extendStatics17=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])})(d,b)};return function(d,b){function __(){this.constructor=d}_extendStatics17(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:!0});var Types_1=require("./Types"),BaseCharAtlas_1=require("./BaseCharAtlas"),ColorManager_1=require("../ColorManager"),CharAtlasGenerator_1=require("./CharAtlasGenerator"),LRUMap_1=require("./LRUMap"),Platform_1=require("../../core/Platform"),TEXTURE_WIDTH=1024,TEXTURE_HEIGHT=1024,TRANSPARENT_COLOR={css:"rgba(0, 0, 0, 0)",rgba:0};exports.getGlyphCacheKey=getGlyphCacheKey;var DynamicCharAtlas=function(_super){function DynamicCharAtlas(document,_config){var _this=_super.call(this)||this;_this._config=_config,_this._drawToCacheCount=0,_this._glyphsWaitingOnBitmap=[],_this._bitmapCommitTimeout=null,_this._bitmap=null,_this._cacheCanvas=document.createElement("canvas"),_this._cacheCanvas.width=TEXTURE_WIDTH,_this._cacheCanvas.height=TEXTURE_HEIGHT,_this._cacheCtx=_this._cacheCanvas.getContext("2d",{alpha:!0});var tmpCanvas=document.createElement("canvas");tmpCanvas.width=_this._config.scaledCharWidth,tmpCanvas.height=_this._config.scaledCharHeight,_this._tmpCtx=tmpCanvas.getContext("2d",{alpha:_this._config.allowTransparency}),_this._width=Math.floor(TEXTURE_WIDTH/_this._config.scaledCharWidth),_this._height=Math.floor(TEXTURE_HEIGHT/_this._config.scaledCharHeight);var capacity=_this._width*_this._height;return _this._cacheMap=new LRUMap_1.default(capacity),_this._cacheMap.prealloc(capacity),_this}return __extends(DynamicCharAtlas,_super),DynamicCharAtlas.prototype.dispose=function(){null!==this._bitmapCommitTimeout&&(window.clearTimeout(this._bitmapCommitTimeout),this._bitmapCommitTimeout=null)},DynamicCharAtlas.prototype.beginFrame=function(){this._drawToCacheCount=0},DynamicCharAtlas.prototype.draw=function(ctx,glyph,x,y){if(32===glyph.code)return!0;if(!this._canCache(glyph))return!1;var glyphKey=getGlyphCacheKey(glyph),cacheValue=this._cacheMap.get(glyphKey);if(null!==cacheValue&&void 0!==cacheValue)return this._drawFromCache(ctx,cacheValue,x,y),!0;if(this._drawToCacheCount<100){var index=void 0;index=this._cacheMap.size<this._cacheMap.capacity?this._cacheMap.size:this._cacheMap.peek().index;var cacheValue_1=this._drawToCache(glyph,index);return this._cacheMap.set(glyphKey,cacheValue_1),this._drawFromCache(ctx,cacheValue_1,x,y),!0}return!1},DynamicCharAtlas.prototype._canCache=function(glyph){return glyph.code<256},DynamicCharAtlas.prototype._toCoordinateX=function(index){return index%this._width*this._config.scaledCharWidth},DynamicCharAtlas.prototype._toCoordinateY=function(index){return Math.floor(index/this._width)*this._config.scaledCharHeight},DynamicCharAtlas.prototype._drawFromCache=function(ctx,cacheValue,x,y){if(!cacheValue.isEmpty){var cacheX=this._toCoordinateX(cacheValue.index),cacheY=this._toCoordinateY(cacheValue.index);ctx.drawImage(cacheValue.inBitmap?this._bitmap:this._cacheCanvas,cacheX,cacheY,this._config.scaledCharWidth,this._config.scaledCharHeight,x,y,this._config.scaledCharWidth,this._config.scaledCharHeight)}},DynamicCharAtlas.prototype._getColorFromAnsiIndex=function(idx){return idx<this._config.colors.ansi.length?this._config.colors.ansi[idx]:ColorManager_1.DEFAULT_ANSI_COLORS[idx]},DynamicCharAtlas.prototype._getBackgroundColor=function(glyph){return this._config.allowTransparency?TRANSPARENT_COLOR:glyph.bg===Types_1.INVERTED_DEFAULT_COLOR?this._config.colors.foreground:glyph.bg<256?this._getColorFromAnsiIndex(glyph.bg):this._config.colors.background},DynamicCharAtlas.prototype._getForegroundColor=function(glyph){return glyph.fg===Types_1.INVERTED_DEFAULT_COLOR?this._config.colors.background:glyph.fg<256?this._getColorFromAnsiIndex(glyph.fg):this._config.colors.foreground},DynamicCharAtlas.prototype._drawToCache=function(glyph,index){this._drawToCacheCount++,this._tmpCtx.save();var backgroundColor=this._getBackgroundColor(glyph);this._tmpCtx.globalCompositeOperation="copy",this._tmpCtx.fillStyle=backgroundColor.css,this._tmpCtx.fillRect(0,0,this._config.scaledCharWidth,this._config.scaledCharHeight),this._tmpCtx.globalCompositeOperation="source-over";var fontWeight=glyph.bold?this._config.fontWeightBold:this._config.fontWeight,fontStyle=glyph.italic?"italic":"";this._tmpCtx.font=fontStyle+" "+fontWeight+" "+this._config.fontSize*this._config.devicePixelRatio+"px "+this._config.fontFamily,this._tmpCtx.textBaseline="middle",this._tmpCtx.fillStyle=this._getForegroundColor(glyph).css,glyph.dim&&(this._tmpCtx.globalAlpha=Types_1.DIM_OPACITY),this._tmpCtx.fillText(glyph.chars,0,this._config.scaledCharHeight/2),this._tmpCtx.restore();var imageData=this._tmpCtx.getImageData(0,0,this._config.scaledCharWidth,this._config.scaledCharHeight),isEmpty=!1;this._config.allowTransparency||(isEmpty=CharAtlasGenerator_1.clearColor(imageData,backgroundColor));var x=this._toCoordinateX(index),y=this._toCoordinateY(index);this._cacheCtx.putImageData(imageData,x,y);var cacheValue={index:index,isEmpty:isEmpty,inBitmap:!1};return this._addGlyphToBitmap(cacheValue),cacheValue},DynamicCharAtlas.prototype._addGlyphToBitmap=function(cacheValue){var _this=this;"createImageBitmap"in window&&!Platform_1.isFirefox&&!Platform_1.isSafari&&(this._glyphsWaitingOnBitmap.push(cacheValue),null===this._bitmapCommitTimeout&&(this._bitmapCommitTimeout=window.setTimeout(function(){return _this._generateBitmap()},100)))},DynamicCharAtlas.prototype._generateBitmap=function(){var _this=this,glyphsMovingToBitmap=this._glyphsWaitingOnBitmap;this._glyphsWaitingOnBitmap=[],window.createImageBitmap(this._cacheCanvas).then(function(bitmap){_this._bitmap=bitmap;for(var i=0;i<glyphsMovingToBitmap.length;i++){glyphsMovingToBitmap[i].inBitmap=!0}}),this._bitmapCommitTimeout=null},DynamicCharAtlas}(BaseCharAtlas_1.default);exports.default=DynamicCharAtlas},{"../../core/Platform":23,"../ColorManager":31,"./BaseCharAtlas":38,"./CharAtlasGenerator":40,"./LRUMap":43,"./Types":46}],43:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var LRUMap=function(){function LRUMap(capacity){this.capacity=capacity,this._map={},this._head=null,this._tail=null,this._nodePool=[],this.size=0}return LRUMap.prototype._unlinkNode=function(node){var prev=node.prev,next=node.next;node===this._head&&(this._head=next),node===this._tail&&(this._tail=prev),null!==prev&&(prev.next=next),null!==next&&(next.prev=prev)},LRUMap.prototype._appendNode=function(node){var tail=this._tail;null!==tail&&(tail.next=node),node.prev=tail,node.next=null,this._tail=node,null===this._head&&(this._head=node)},LRUMap.prototype.prealloc=function(count){for(var nodePool=this._nodePool,i=0;i<count;i++)nodePool.push({prev:null,next:null,key:null,value:null})},LRUMap.prototype.get=function(key){var node=this._map[key];return void 0!==node?(this._unlinkNode(node),this._appendNode(node),node.value):null},LRUMap.prototype.peekValue=function(key){var node=this._map[key];return void 0!==node?node.value:null},LRUMap.prototype.peek=function(){var head=this._head;return null===head?null:head.value},LRUMap.prototype.set=function(key,value){var node=this._map[key];if(void 0!==node)node=this._map[key],this._unlinkNode(node),node.value=value;else if(this.size>=this.capacity)node=this._head,this._unlinkNode(node),delete this._map[node.key],node.key=key,node.value=value,this._map[key]=node;else{var nodePool=this._nodePool;nodePool.length>0?(node=nodePool.pop(),node.key=key,node.value=value):node={prev:null,next:null,key:key,value:value},this._map[key]=node,this.size++}this._appendNode(node)},LRUMap}();exports.default=LRUMap},{}],44:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var _extendStatics18=function(d,b){return(_extendStatics18=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])})(d,b)};return function(d,b){function __(){this.constructor=d}
_extendStatics18(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:!0});var BaseCharAtlas_1=require("./BaseCharAtlas"),NoneCharAtlas=function(_super){function NoneCharAtlas(document,config){return _super.call(this)||this}return __extends(NoneCharAtlas,_super),NoneCharAtlas.prototype.draw=function(ctx,glyph,x,y){return!1},NoneCharAtlas}(BaseCharAtlas_1.default);exports.default=NoneCharAtlas},{"./BaseCharAtlas":38}],45:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var _extendStatics19=function(d,b){return(_extendStatics19=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])})(d,b)};return function(d,b){function __(){this.constructor=d}_extendStatics19(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:!0});var Types_1=require("./Types"),CharAtlasGenerator_1=require("./CharAtlasGenerator"),BaseCharAtlas_1=require("./BaseCharAtlas"),CharAtlasUtils_1=require("./CharAtlasUtils"),StaticCharAtlas=function(_super){function StaticCharAtlas(_document,_config){var _this=_super.call(this)||this;return _this._document=_document,_this._config=_config,_this._canvasFactory=function(width,height){var canvas=_this._document.createElement("canvas");return canvas.width=width,canvas.height=height,canvas},_this}return __extends(StaticCharAtlas,_super),StaticCharAtlas.prototype._doWarmUp=function(){var _this=this,result=CharAtlasGenerator_1.generateStaticCharAtlasTexture(window,this._canvasFactory,this._config);result instanceof HTMLCanvasElement?this._texture=result:result.then(function(texture){_this._texture=texture})},StaticCharAtlas.prototype._isCached=function(glyph,colorIndex){var isAscii=glyph.code<256,isBasicColor=glyph.fg<16,isDefaultColor=glyph.fg===Types_1.DEFAULT_COLOR,isDefaultBackground=glyph.bg===Types_1.DEFAULT_COLOR;return isAscii&&(isBasicColor||isDefaultColor)&&isDefaultBackground&&!glyph.italic},StaticCharAtlas.prototype.draw=function(ctx,glyph,x,y){if(null===this._texture||void 0===this._texture)return!1;var colorIndex=0;if(CharAtlasUtils_1.is256Color(glyph.fg)?colorIndex=2+glyph.fg+(glyph.bold?16:0):glyph.fg===Types_1.DEFAULT_COLOR&&glyph.bold&&(colorIndex=1),!this._isCached(glyph,colorIndex))return!1;ctx.save();var charAtlasCellWidth=this._config.scaledCharWidth+Types_1.CHAR_ATLAS_CELL_SPACING,charAtlasCellHeight=this._config.scaledCharHeight+Types_1.CHAR_ATLAS_CELL_SPACING;return glyph.dim&&(ctx.globalAlpha=Types_1.DIM_OPACITY),ctx.drawImage(this._texture,glyph.code*charAtlasCellWidth,colorIndex*charAtlasCellHeight,charAtlasCellWidth,this._config.scaledCharHeight,x,y,charAtlasCellWidth,this._config.scaledCharHeight),ctx.restore(),!0},StaticCharAtlas}(BaseCharAtlas_1.default);exports.default=StaticCharAtlas},{"./BaseCharAtlas":38,"./CharAtlasGenerator":40,"./CharAtlasUtils":41,"./Types":46}],46:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:!0}),exports.DEFAULT_COLOR=256,exports.INVERTED_DEFAULT_COLOR=257,exports.DIM_OPACITY=.5,exports.CHAR_ATLAS_CELL_SPACING=1},{}],47:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var _extendStatics20=function(d,b){return(_extendStatics20=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])})(d,b)};return function(d,b){function __(){this.constructor=d}_extendStatics20(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:!0});var EventEmitter_1=require("../../common/EventEmitter"),ColorManager_1=require("../ColorManager"),RenderDebouncer_1=require("../../ui/RenderDebouncer"),DomRendererRowFactory_1=require("./DomRendererRowFactory"),Types_1=require("../atlas/Types"),TERMINAL_CLASS_PREFIX="xterm-dom-renderer-owner-",ROW_CONTAINER_CLASS="xterm-rows",SELECTION_CLASS="xterm-selection",nextTerminalId=1,DomRenderer=function(_super){function DomRenderer(_terminal,theme){var _this=_super.call(this)||this;_this._terminal=_terminal,_this._terminalClass=nextTerminalId++,_this._rowElements=[];var allowTransparency=_this._terminal.options.allowTransparency;return _this.colorManager=new ColorManager_1.ColorManager(document,allowTransparency),_this.setTheme(theme),_this._rowContainer=document.createElement("div"),_this._rowContainer.classList.add(ROW_CONTAINER_CLASS),_this._rowContainer.style.lineHeight="normal",_this._rowContainer.setAttribute("aria-hidden","true"),_this._refreshRowElements(_this._terminal.cols,_this._terminal.rows),_this._selectionContainer=document.createElement("div"),_this._selectionContainer.classList.add(SELECTION_CLASS),_this._selectionContainer.setAttribute("aria-hidden","true"),_this.dimensions={scaledCharWidth:null,scaledCharHeight:null,scaledCellWidth:null,scaledCellHeight:null,scaledCharLeft:null,scaledCharTop:null,scaledCanvasWidth:null,scaledCanvasHeight:null,canvasWidth:null,canvasHeight:null,actualCellWidth:null,actualCellHeight:null},_this._updateDimensions(),_this._renderDebouncer=new RenderDebouncer_1.RenderDebouncer(_this._terminal,_this._renderRows.bind(_this)),_this._rowFactory=new DomRendererRowFactory_1.DomRendererRowFactory(document),_this._terminal.element.classList.add(TERMINAL_CLASS_PREFIX+_this._terminalClass),_this._terminal.screenElement.appendChild(_this._rowContainer),_this._terminal.screenElement.appendChild(_this._selectionContainer),_this._terminal.linkifier.on("linkhover",function(e){return _this._onLinkHover(e)}),_this._terminal.linkifier.on("linkleave",function(e){return _this._onLinkLeave(e)}),_this}return __extends(DomRenderer,_super),DomRenderer.prototype.dispose=function(){this._terminal.element.classList.remove(TERMINAL_CLASS_PREFIX+this._terminalClass),this._terminal.screenElement.removeChild(this._rowContainer),this._terminal.screenElement.removeChild(this._selectionContainer),this._terminal.screenElement.removeChild(this._themeStyleElement),this._terminal.screenElement.removeChild(this._dimensionsStyleElement),_super.prototype.dispose.call(this)},DomRenderer.prototype._updateDimensions=function(){var _this=this;this.dimensions.scaledCharWidth=Math.floor(this._terminal.charMeasure.width*window.devicePixelRatio),this.dimensions.scaledCharHeight=Math.ceil(this._terminal.charMeasure.height*window.devicePixelRatio),this.dimensions.scaledCellWidth=this.dimensions.scaledCharWidth+Math.round(this._terminal.options.letterSpacing),this.dimensions.scaledCellHeight=Math.floor(this.dimensions.scaledCharHeight*this._terminal.options.lineHeight),this.dimensions.scaledCharLeft=0,this.dimensions.scaledCharTop=0,this.dimensions.scaledCanvasWidth=this.dimensions.scaledCellWidth*this._terminal.cols,this.dimensions.scaledCanvasHeight=this.dimensions.scaledCellHeight*this._terminal.rows,this.dimensions.canvasWidth=Math.round(this.dimensions.scaledCanvasWidth/window.devicePixelRatio),this.dimensions.canvasHeight=Math.round(this.dimensions.scaledCanvasHeight/window.devicePixelRatio),this.dimensions.actualCellWidth=this.dimensions.canvasWidth/this._terminal.cols,this.dimensions.actualCellHeight=this.dimensions.canvasHeight/this._terminal.rows,this._rowElements.forEach(function(element){element.style.width=_this.dimensions.canvasWidth+"px",element.style.height=_this.dimensions.actualCellHeight+"px",element.style.lineHeight=_this.dimensions.actualCellHeight+"px",element.style.overflow="hidden"}),this._dimensionsStyleElement||(this._dimensionsStyleElement=document.createElement("style"),this._terminal.screenElement.appendChild(this._dimensionsStyleElement));var styles=this._terminalSelector+" ."+ROW_CONTAINER_CLASS+" span { display: inline-block; height: 100%; vertical-align: top; width: "+this.dimensions.actualCellWidth+"px}";this._dimensionsStyleElement.innerHTML=styles,this._selectionContainer.style.height=this._terminal._viewportElement.style.height,this._terminal.screenElement.style.width=this.dimensions.canvasWidth+"px",this._terminal.screenElement.style.height=this.dimensions.canvasHeight+"px"},DomRenderer.prototype.setTheme=function(theme){var _this=this;theme&&this.colorManager.setTheme(theme),this._themeStyleElement||(this._themeStyleElement=document.createElement("style"),this._terminal.screenElement.appendChild(this._themeStyleElement));var styles=this._terminalSelector+" ."+ROW_CONTAINER_CLASS+" { color: "+this.colorManager.colors.foreground.css+"; background-color: "+this.colorManager.colors.background.css+"; font-family: "+this._terminal.getOption("fontFamily")+"; font-size: "+this._terminal.getOption("fontSize")+"px;}";return styles+=this._terminalSelector+" span:not(."+DomRendererRowFactory_1.BOLD_CLASS+") { font-weight: "+this._terminal.options.fontWeight+";}"+this._terminalSelector+" span."+DomRendererRowFactory_1.BOLD_CLASS+" { font-weight: "+this._terminal.options.fontWeightBold+";}"+this._terminalSelector+" span."+DomRendererRowFactory_1.ITALIC_CLASS+" { font-style: italic;}",styles+=this._terminalSelector+" ."+ROW_CONTAINER_CLASS+":not(.xterm-focus) ."+DomRendererRowFactory_1.CURSOR_CLASS+" { outline: 1px solid "+this.colorManager.colors.cursor.css+"; outline-offset: -1px;}"+this._terminalSelector+" ."+ROW_CONTAINER_CLASS+".xterm-focus ."+DomRendererRowFactory_1.CURSOR_CLASS+"."+DomRendererRowFactory_1.CURSOR_STYLE_BLOCK_CLASS+" { background-color: "+this.colorManager.colors.cursor.css+"; color: "+this.colorManager.colors.cursorAccent.css+";}"+this._terminalSelector+" ."+ROW_CONTAINER_CLASS+".xterm-focus ."+DomRendererRowFactory_1.CURSOR_CLASS+"."+DomRendererRowFactory_1.CURSOR_STYLE_BAR_CLASS+" { box-shadow: 1px 0 0 "+this.colorManager.colors.cursor.css+" inset;}"+this._terminalSelector+" ."+ROW_CONTAINER_CLASS+".xterm-focus ."+DomRendererRowFactory_1.CURSOR_CLASS+"."+DomRendererRowFactory_1.CURSOR_STYLE_UNDERLINE_CLASS+" { box-shadow: 0 -1px 0 "+this.colorManager.colors.cursor.css+" inset;}",styles+=this._terminalSelector+" ."+SELECTION_CLASS+" { position: absolute; top: 0; left: 0; z-index: 1; pointer-events: none;}"+this._terminalSelector+" ."+SELECTION_CLASS+" div { position: absolute; background-color: "+this.colorManager.colors.selection.css+";}",this.colorManager.colors.ansi.forEach(function(c,i){styles+=_this._terminalSelector+" .xterm-fg-"+i+" { color: "+c.css+"; }"+_this._terminalSelector+" .xterm-bg-"+i+" { background-color: "+c.css+"; }"}),styles+=this._terminalSelector+" .xterm-fg-"+Types_1.INVERTED_DEFAULT_COLOR+" { color: "+this.colorManager.colors.background.css+"; }"+this._terminalSelector+" .xterm-bg-"+Types_1.INVERTED_DEFAULT_COLOR+" { background-color: "+this.colorManager.colors.foreground.css+"; }",this._themeStyleElement.innerHTML=styles,this.colorManager.colors},DomRenderer.prototype.onWindowResize=function(devicePixelRatio){this._updateDimensions()},DomRenderer.prototype._refreshRowElements=function(cols,rows){for(var i=this._rowElements.length;i<=rows;i++){var row=document.createElement("div");this._rowContainer.appendChild(row),this._rowElements.push(row)}for(;this._rowElements.length>rows;)this._rowContainer.removeChild(this._rowElements.pop())},DomRenderer.prototype.onResize=function(cols,rows){this._refreshRowElements(cols,rows),this._updateDimensions()},DomRenderer.prototype.onCharSizeChanged=function(){this._updateDimensions()},DomRenderer.prototype.onBlur=function(){this._rowContainer.classList.remove("xterm-focus")},DomRenderer.prototype.onFocus=function(){this._rowContainer.classList.add("xterm-focus")},DomRenderer.prototype.onSelectionChanged=function(start,end,columnSelectMode){for(;this._selectionContainer.children.length;)this._selectionContainer.removeChild(this._selectionContainer.children[0]);if(start&&end){var viewportStartRow=start[1]-this._terminal.buffer.ydisp,viewportEndRow=end[1]-this._terminal.buffer.ydisp,viewportCappedStartRow=Math.max(viewportStartRow,0),viewportCappedEndRow=Math.min(viewportEndRow,this._terminal.rows-1);if(!(viewportCappedStartRow>=this._terminal.rows||viewportCappedEndRow<0)){var documentFragment=document.createDocumentFragment();if(columnSelectMode)documentFragment.appendChild(this._createSelectionElement(viewportCappedStartRow,start[0],end[0],viewportCappedEndRow-viewportCappedStartRow+1));else{var startCol=viewportStartRow===viewportCappedStartRow?start[0]:0,endCol=viewportCappedStartRow===viewportCappedEndRow?end[0]:this._terminal.cols;documentFragment.appendChild(this._createSelectionElement(viewportCappedStartRow,startCol,endCol));var middleRowsCount=viewportCappedEndRow-viewportCappedStartRow-1;if(documentFragment.appendChild(this._createSelectionElement(viewportCappedStartRow+1,0,this._terminal.cols,middleRowsCount)),viewportCappedStartRow!==viewportCappedEndRow){var endCol_1=viewportEndRow===viewportCappedEndRow?end[0]:this._terminal.cols;documentFragment.appendChild(this._createSelectionElement(viewportCappedEndRow,0,endCol_1))}}this._selectionContainer.appendChild(documentFragment)}}},DomRenderer.prototype._createSelectionElement=function(row,colStart,colEnd,rowCount){void 0===rowCount&&(rowCount=1);var element=document.createElement("div");return element.style.height=rowCount*this.dimensions.actualCellHeight+"px",element.style.top=row*this.dimensions.actualCellHeight+"px",element.style.left=colStart*this.dimensions.actualCellWidth+"px",element.style.width=this.dimensions.actualCellWidth*(colEnd-colStart)+"px",element},DomRenderer.prototype.onCursorMove=function(){},DomRenderer.prototype.onOptionsChanged=function(){this._updateDimensions(),this.setTheme(void 0),this._terminal.refresh(0,this._terminal.rows-1)},DomRenderer.prototype.clear=function(){this._rowElements.forEach(function(e){return e.innerHTML=""})},DomRenderer.prototype.refreshRows=function(start,end){this._renderDebouncer.refresh(start,end)},DomRenderer.prototype._renderRows=function(start,end){for(var terminal=this._terminal,cursorAbsoluteY=terminal.buffer.ybase+terminal.buffer.y,cursorX=this._terminal.buffer.x,y=start;y<=end;y++){var rowElement=this._rowElements[y];rowElement.innerHTML="";var row=y+terminal.buffer.ydisp,lineData=terminal.buffer.lines.get(row),cursorStyle=terminal.options.cursorStyle;rowElement.appendChild(this._rowFactory.createRow(lineData,row===cursorAbsoluteY,cursorStyle,cursorX,this.dimensions.actualCellWidth,terminal.cols))}this._terminal.emit("refresh",{start:start,end:end})},Object.defineProperty(DomRenderer.prototype,"_terminalSelector",{get:function(){return"."+TERMINAL_CLASS_PREFIX+this._terminalClass},enumerable:!0,configurable:!0}),DomRenderer.prototype.registerCharacterJoiner=function(handler){return-1},DomRenderer.prototype.deregisterCharacterJoiner=function(joinerId){return!1},DomRenderer.prototype._onLinkHover=function(e){this._setCellUnderline(e.x1,e.x2,e.y1,e.y2,e.cols,!0)},DomRenderer.prototype._onLinkLeave=function(e){this._setCellUnderline(e.x1,e.x2,e.y1,e.y2,e.cols,!1)},DomRenderer.prototype._setCellUnderline=function(x,x2,y,y2,cols,enabled){for(;x!==x2||y!==y2;){var row=this._rowElements[y];if(!row)return;var span=row.children[x];span&&(span.style.textDecoration=enabled?"underline":"none"),++x>=cols&&(x=0,y++)}},DomRenderer}(EventEmitter_1.EventEmitter);exports.DomRenderer=DomRenderer},{"../../common/EventEmitter":19,"../../ui/RenderDebouncer":54,"../ColorManager":31,"../atlas/Types":46,"./DomRendererRowFactory":48}],48:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var Buffer_1=require("../../Buffer"),Types_1=require("../atlas/Types");exports.BOLD_CLASS="xterm-bold",exports.ITALIC_CLASS="xterm-italic",exports.CURSOR_CLASS="xterm-cursor",exports.CURSOR_STYLE_BLOCK_CLASS="xterm-cursor-block",exports.CURSOR_STYLE_BAR_CLASS="xterm-cursor-bar",exports.CURSOR_STYLE_UNDERLINE_CLASS="xterm-cursor-underline";var DomRendererRowFactory=function(){function DomRendererRowFactory(_document){this._document=_document}return DomRendererRowFactory.prototype.createRow=function(lineData,isCursorRow,cursorStyle,cursorX,cellWidth,cols){for(var fragment=this._document.createDocumentFragment(),lineLength=0,x=Math.min(lineData.length,cols)-1;x>=0;x--){var charData=lineData.get(x);if(charData[Buffer_1.CHAR_DATA_CODE_INDEX]!==Buffer_1.NULL_CELL_CODE||isCursorRow&&x===cursorX){lineLength=x+1;break}}for(var x=0;x<lineLength;x++){var charData=lineData.get(x),_char11=charData[Buffer_1.CHAR_DATA_CHAR_INDEX]||Buffer_1.WHITESPACE_CELL_CHAR,attr=charData[Buffer_1.CHAR_DATA_ATTR_INDEX],width=charData[Buffer_1.CHAR_DATA_WIDTH_INDEX];if(0!==width){var charElement=this._document.createElement("span");width>1&&(charElement.style.width=cellWidth*width+"px");var flags=attr>>18,bg=511&attr,fg=attr>>9&511;if(isCursorRow&&x===cursorX)switch(charElement.classList.add(exports.CURSOR_CLASS),cursorStyle){case"bar":charElement.classList.add(exports.CURSOR_STYLE_BAR_CLASS);break;case"underline":charElement.classList.add(exports.CURSOR_STYLE_UNDERLINE_CLASS);break;default:charElement.classList.add(exports.CURSOR_STYLE_BLOCK_CLASS)}if(8&flags){var temp=bg;bg=fg,fg=temp,fg===Types_1.DEFAULT_COLOR&&(fg=Types_1.INVERTED_DEFAULT_COLOR),bg===Types_1.DEFAULT_COLOR&&(bg=Types_1.INVERTED_DEFAULT_COLOR)}1&flags&&(fg<8&&(fg+=8),charElement.classList.add(exports.BOLD_CLASS)),64&flags&&charElement.classList.add(exports.ITALIC_CLASS),charElement.textContent=_char11,fg!==Types_1.DEFAULT_COLOR&&charElement.classList.add("xterm-fg-"+fg),bg!==Types_1.DEFAULT_COLOR&&charElement.classList.add("xterm-bg-"+bg),fragment.appendChild(charElement)}}return fragment},DomRendererRowFactory}();exports.DomRendererRowFactory=DomRendererRowFactory},{"../../Buffer":2,"../atlas/Types":46}],49:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var _extendStatics21=function(d,b){return(_extendStatics21=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])})(d,b)};return function(d,b){function __(){this.constructor=d}_extendStatics21(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:!0});var EventEmitter_1=require("../common/EventEmitter"),CharMeasure=function(_super){function CharMeasure(document,parentElement){var _this=_super.call(this)||this;return _this._document=document,_this._parentElement=parentElement,_this._measureElement=_this._document.createElement("span"),_this._measureElement.classList.add("xterm-char-measure-element"),_this._measureElement.textContent="W",_this._measureElement.setAttribute("aria-hidden","true"),_this._parentElement.appendChild(_this._measureElement),_this}return __extends(CharMeasure,_super),Object.defineProperty(CharMeasure.prototype,"width",{get:function(){return this._width},enumerable:!0,configurable:!0}),Object.defineProperty(CharMeasure.prototype,"height",{get:function(){return this._height},enumerable:!0,configurable:!0}),CharMeasure.prototype.measure=function(options){this._measureElement.style.fontFamily=options.fontFamily,this._measureElement.style.fontSize=options.fontSize+"px";var geometry=this._measureElement.getBoundingClientRect();if(0!==geometry.width&&0!==geometry.height){var adjustedHeight=Math.ceil(geometry.height);this._width===geometry.width&&this._height===adjustedHeight||(this._width=geometry.width,this._height=adjustedHeight,this.emit("charsizechanged"))}},CharMeasure}(EventEmitter_1.EventEmitter);exports.CharMeasure=CharMeasure},{"../common/EventEmitter":19}],50:[function(require,module,exports){"use strict";function prepareTextForTerminal(text){return text.replace(/\r?\n/g,"\r")}function bracketTextForPaste(text,bracketedPasteMode){return bracketedPasteMode?"[200~"+text+"[201~":text}function copyHandler(ev,term,selectionManager){term.browser.isMSIE?window.clipboardData.setData("Text",selectionManager.selectionText):ev.clipboardData.setData("text/plain",selectionManager.selectionText),ev.preventDefault()}function pasteHandler(ev,term){ev.stopPropagation();var text,dispatchPaste=function(text){text=prepareTextForTerminal(text),text=bracketTextForPaste(text,term.bracketedPasteMode),term.handler(text),term.textarea.value="",term.emit("paste",text),term.cancel(ev)};term.browser.isMSIE?window.clipboardData&&(text=window.clipboardData.getData("Text"),dispatchPaste(text)):ev.clipboardData&&(text=ev.clipboardData.getData("text/plain"),dispatchPaste(text))}function moveTextAreaUnderMouseCursor(ev,term){var pos=term.screenElement.getBoundingClientRect(),left=ev.clientX-pos.left-10,top=ev.clientY-pos.top-10;term.textarea.style.position="absolute",term.textarea.style.width="20px",term.textarea.style.height="20px",term.textarea.style.left=left+"px",term.textarea.style.top=top+"px",term.textarea.style.zIndex="1000",term.textarea.focus(),setTimeout(function(){term.textarea.style.position=null,term.textarea.style.width=null,term.textarea.style.height=null,term.textarea.style.left=null,term.textarea.style.top=null,term.textarea.style.zIndex=null},200)}function rightClickHandler(ev,term,selectionManager,shouldSelectWord){moveTextAreaUnderMouseCursor(ev,term),shouldSelectWord&&!selectionManager.isClickInSelection(ev)&&selectionManager.selectWordAtCursor(ev),term.textarea.value=selectionManager.selectionText,term.textarea.select()}Object.defineProperty(exports,"__esModule",{value:!0}),exports.prepareTextForTerminal=prepareTextForTerminal,exports.bracketTextForPaste=bracketTextForPaste,exports.copyHandler=copyHandler,exports.pasteHandler=pasteHandler,exports.moveTextAreaUnderMouseCursor=moveTextAreaUnderMouseCursor,exports.rightClickHandler=rightClickHandler},{}],51:[function(require,module,exports){"use strict";function addDisposableDomListener(node,type,handler,useCapture){return node.addEventListener(type,handler,useCapture),{dispose:function(){handler&&(node.removeEventListener(type,handler,useCapture),node=null,handler=null)}}}Object.defineProperty(exports,"__esModule",{value:!0}),exports.addDisposableDomListener=addDisposableDomListener},{}],52:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var MouseHelper=function(){function MouseHelper(_renderer){this._renderer=_renderer}return MouseHelper.prototype.setRenderer=function(renderer){this._renderer=renderer},MouseHelper.getCoordsRelativeToElement=function(event,element){var rect=element.getBoundingClientRect();return[event.clientX-rect.left,event.clientY-rect.top]},MouseHelper.prototype.getCoords=function(event,element,charMeasure,colCount,rowCount,isSelection){if(!charMeasure.width||!charMeasure.height)return null;var coords=MouseHelper.getCoordsRelativeToElement(event,element);return coords?(coords[0]=Math.ceil((coords[0]+(isSelection?this._renderer.dimensions.actualCellWidth/2:0))/this._renderer.dimensions.actualCellWidth),coords[1]=Math.ceil(coords[1]/this._renderer.dimensions.actualCellHeight),coords[0]=Math.min(Math.max(coords[0],1),colCount+(isSelection?1:0)),coords[1]=Math.min(Math.max(coords[1],1),rowCount),coords):null},MouseHelper.prototype.getRawByteCoords=function(event,element,charMeasure,colCount,rowCount){var coords=this.getCoords(event,element,charMeasure,colCount,rowCount),x=coords[0],y=coords[1];return x+=32,y+=32,{x:x,y:y}},MouseHelper}();exports.MouseHelper=MouseHelper},{}],53:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var _extendStatics22=function(d,b){return(_extendStatics22=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])})(d,b)};return function(d,b){function __(){this.constructor=d}_extendStatics22(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:!0});var Lifecycle_1=require("../common/Lifecycle"),Lifecycle_2=require("./Lifecycle"),MouseZoneManager=function(_super){function MouseZoneManager(_terminal){var _this=_super.call(this)||this;return _this._terminal=_terminal,_this._zones=[],_this._areZonesActive=!1,_this._tooltipTimeout=null,_this._currentZone=null,_this._lastHoverCoords=[null,null],_this.register(Lifecycle_2.addDisposableDomListener(_this._terminal.element,"mousedown",function(e){return _this._onMouseDown(e)})),_this._mouseMoveListener=function(e){return _this._onMouseMove(e)},_this._clickListener=function(e){return _this._onClick(e)},_this}return __extends(MouseZoneManager,_super),MouseZoneManager.prototype.dispose=function(){_super.prototype.dispose.call(this),this._deactivate()},MouseZoneManager.prototype.add=function(zone){this._zones.push(zone),1===this._zones.length&&this._activate()},MouseZoneManager.prototype.clearAll=function(start,end){if(0!==this._zones.length){end||(start=0,end=this._terminal.rows-1);for(var i=0;i<this._zones.length;i++){var zone=this._zones[i];(zone.y1>start&&zone.y1<=end+1||zone.y2>start&&zone.y2<=end+1||zone.y1<start&&zone.y2>end+1)&&(this._currentZone&&this._currentZone===zone&&(this._currentZone.leaveCallback(),this._currentZone=null),this._zones.splice(i--,1))}0===this._zones.length&&this._deactivate()}},MouseZoneManager.prototype._activate=function(){this._areZonesActive||(this._areZonesActive=!0,this._terminal.element.addEventListener("mousemove",this._mouseMoveListener),this._terminal.element.addEventListener("click",this._clickListener))},MouseZoneManager.prototype._deactivate=function(){this._areZonesActive&&(this._areZonesActive=!1,this._terminal.element.removeEventListener("mousemove",this._mouseMoveListener),this._terminal.element.removeEventListener("click",this._clickListener))},MouseZoneManager.prototype._onMouseMove=function(e){this._lastHoverCoords[0]===e.pageX&&this._lastHoverCoords[1]===e.pageY||(this._onHover(e),this._lastHoverCoords=[e.pageX,e.pageY])},MouseZoneManager.prototype._onHover=function(e){var _this=this,zone=this._findZoneEventAt(e);zone!==this._currentZone&&(this._currentZone&&(this._currentZone.leaveCallback(),this._currentZone=null,this._tooltipTimeout&&clearTimeout(this._tooltipTimeout)),zone&&(this._currentZone=zone,zone.hoverCallback&&zone.hoverCallback(e),this._tooltipTimeout=setTimeout(function(){return _this._onTooltip(e)},500)))},MouseZoneManager.prototype._onTooltip=function(e){this._tooltipTimeout=null;var zone=this._findZoneEventAt(e);zone&&zone.tooltipCallback&&zone.tooltipCallback(e)},MouseZoneManager.prototype._onMouseDown=function(e){if(this._areZonesActive){var zone=this._findZoneEventAt(e);zone&&zone.willLinkActivate(e)&&(e.preventDefault(),e.stopImmediatePropagation())}},MouseZoneManager.prototype._onClick=function(e){var zone=this._findZoneEventAt(e);zone&&(zone.clickCallback(e),e.preventDefault(),e.stopImmediatePropagation())},MouseZoneManager.prototype._findZoneEventAt=function(e){var coords=this._terminal.mouseHelper.getCoords(e,this._terminal.screenElement,this._terminal.charMeasure,this._terminal.cols,this._terminal.rows);if(!coords)return null;for(var x=coords[0],y=coords[1],i=0;i<this._zones.length;i++){var zone=this._zones[i];if(zone.y1===zone.y2){if(y===zone.y1&&x>=zone.x1&&x<zone.x2)return zone}else if(y===zone.y1&&x>=zone.x1||y===zone.y2&&x<zone.x2||y>zone.y1&&y<zone.y2)return zone}return null},MouseZoneManager}(Lifecycle_1.Disposable);exports.MouseZoneManager=MouseZoneManager;var MouseZone=function(){function MouseZone(x1,y1,x2,y2,clickCallback,hoverCallback,tooltipCallback,leaveCallback,willLinkActivate){this.x1=x1,this.y1=y1,this.x2=x2,this.y2=y2,this.clickCallback=clickCallback,this.hoverCallback=hoverCallback,this.tooltipCallback=tooltipCallback,this.leaveCallback=leaveCallback,this.willLinkActivate=willLinkActivate}return MouseZone}();exports.MouseZone=MouseZone},{"../common/Lifecycle":20,"./Lifecycle":51}],54:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var RenderDebouncer=function(){function RenderDebouncer(_terminal,_callback){this._terminal=_terminal,this._callback=_callback,this._animationFrame=null}return RenderDebouncer.prototype.dispose=function(){this._animationFrame&&(window.cancelAnimationFrame(this._animationFrame),this._animationFrame=null)},RenderDebouncer.prototype.refresh=function(rowStart,rowEnd){var _this=this;rowStart=null!==rowStart&&void 0!==rowStart?rowStart:0,rowEnd=null!==rowEnd&&void 0!==rowEnd?rowEnd:this._terminal.rows-1;var isRowStartSet=void 0!==this._rowStart&&null!==this._rowStart,isRowEndSet=void 0!==this._rowEnd&&null!==this._rowEnd;this._rowStart=isRowStartSet?Math.min(this._rowStart,rowStart):rowStart,this._rowEnd=isRowEndSet?Math.max(this._rowEnd,rowEnd):rowEnd,this._animationFrame||(this._animationFrame=window.requestAnimationFrame(function(){return _this._innerRefresh()}))},RenderDebouncer.prototype._innerRefresh=function(){this._rowStart=Math.max(this._rowStart,0),this._rowEnd=Math.min(this._rowEnd,this._terminal.rows-1),this._callback(this._rowStart,this._rowEnd),this._rowStart=null,this._rowEnd=null,this._animationFrame=null},RenderDebouncer}();exports.RenderDebouncer=RenderDebouncer},{}],55:[function(require,module,exports){"use strict";var __extends=this&&this.__extends||function(){var _extendStatics23=function(d,b){return(_extendStatics23=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(d,b){d.__proto__=b}||function(d,b){for(var p in b)b.hasOwnProperty(p)&&(d[p]=b[p])})(d,b)};return function(d,b){function __(){this.constructor=d}_extendStatics23(d,b),d.prototype=null===b?Object.create(b):(__.prototype=b.prototype,new __)}}();Object.defineProperty(exports,"__esModule",{value:!0});var Lifecycle_1=require("../common/Lifecycle"),ScreenDprMonitor=function(_super){function ScreenDprMonitor(){return null!==_super&&_super.apply(this,arguments)||this}return __extends(ScreenDprMonitor,_super),ScreenDprMonitor.prototype.setListener=function(listener){var _this=this;this._listener&&this.clearListener(),this._listener=listener,this._outerListener=function(){_this._listener(window.devicePixelRatio,_this._currentDevicePixelRatio),_this._updateDpr()},this._updateDpr()},ScreenDprMonitor.prototype.dispose=function(){_super.prototype.dispose.call(this),this.clearListener()},ScreenDprMonitor.prototype._updateDpr=function(){this._resolutionMediaMatchList&&this._resolutionMediaMatchList.removeListener(this._outerListener),this._currentDevicePixelRatio=window.devicePixelRatio,this._resolutionMediaMatchList=window.matchMedia("screen and (resolution: "+window.devicePixelRatio+"dppx)"),this._resolutionMediaMatchList.addListener(this._outerListener)},ScreenDprMonitor.prototype.clearListener=function(){this._listener&&(this._resolutionMediaMatchList.removeListener(this._outerListener),this._listener=null,this._outerListener=null)},ScreenDprMonitor}(Lifecycle_1.Disposable);exports.ScreenDprMonitor=ScreenDprMonitor},{"../common/Lifecycle":20}],56:[function(require,module,exports){"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var Terminal_1=require("./public/Terminal");module.exports=Terminal_1.Terminal},{"./public/Terminal":28}]},{},[56])(56)}),function(f){if("object"===("undefined"==typeof exports?"undefined":_typeof(exports))&&"undefined"!=typeof module)module.exports=f();else if("function"==typeof define&&define.amd)define("js/xterm/addons/fit/fit.js",[],f);else{var g;g="undefined"!=typeof window?window:"undefined"!=typeof global?global:"undefined"!=typeof self?self:this,g.fit=f()}}(function(){return function(){function r(e,n,t){function o(i,f){if(!n[i]){if(!e[i]){var c="function"==typeof require&&require;if(!f&&c)return c(i,!0);if(u)return u(i,!0);var a=new Error("Cannot find module '"+i+"'");throw a.code="MODULE_NOT_FOUND",a}var p=n[i]={exports:{}};e[i][0].call(p.exports,function(r){return o(e[i][1][r]||r)},p,p.exports,r,e,n,t)}return n[i].exports}
for(var u="function"==typeof require&&require,i=0;i<t.length;i++)o(t[i]);return o}return r}()({1:[function(require,module,exports){"use strict";function proposeGeometry(term){if(!term.element.parentElement)return null;var parentElementStyle=window.getComputedStyle(term.element.parentElement),parentElementHeight=parseInt(parentElementStyle.getPropertyValue("height")),parentElementWidth=Math.max(0,parseInt(parentElementStyle.getPropertyValue("width"))),elementStyle=window.getComputedStyle(term.element),elementPadding={top:parseInt(elementStyle.getPropertyValue("padding-top")),bottom:parseInt(elementStyle.getPropertyValue("padding-bottom")),right:parseInt(elementStyle.getPropertyValue("padding-right")),left:parseInt(elementStyle.getPropertyValue("padding-left"))},elementPaddingVer=elementPadding.top+elementPadding.bottom,elementPaddingHor=elementPadding.right+elementPadding.left,availableHeight=parentElementHeight-elementPaddingVer,availableWidth=parentElementWidth-elementPaddingHor-term._core.viewport.scrollBarWidth;return{cols:Math.floor(availableWidth/term._core.renderer.dimensions.actualCellWidth),rows:Math.floor(availableHeight/term._core.renderer.dimensions.actualCellHeight)}}function fit(term){var geometry=proposeGeometry(term);geometry&&(term.rows===geometry.rows&&term.cols===geometry.cols||(term._core.renderer.clear(),term.resize(geometry.cols,geometry.rows)))}function apply(terminalConstructor){terminalConstructor.prototype.proposeGeometry=function(){return proposeGeometry(this)},terminalConstructor.prototype.fit=function(){fit(this)}}Object.defineProperty(exports,"__esModule",{value:!0}),exports.proposeGeometry=proposeGeometry,exports.fit=fit,exports.apply=apply},{}]},{},[1])(1)}),define("js/terminals.js",["base/js/utils","js/utils.js","js/localizer.js","js/xterm/xterm.js","js/xterm/addons/fit/fit.js"],function(jupyterUtils,utils,localizer,terminalLib,fit){var terminals={focusedTerminal:void 0,discoveredPwd:void 0,singleCDCommand:!1,fitRetryTime:1e3,maxRefitAttempts:10,CDCommandCount:0,terminalsList:{},discoverPwd:function(){Jupyter.notebook.kernel.execute("pwd",{iopub:{output:function(shellOutput){if(shellOutput&&shellOutput.content&&shellOutput.content.data){var pathWithTicks=shellOutput.content.data["text/plain"];terminals.discoveredPwd=pathWithTicks.substr(1,pathWithTicks.length-2),terminals.renderAllTerminals()}}}},{silent:!1})},_makeTerminal:function(element,terminalId,wsUrl,sizeObj){var ws=new WebSocket(wsUrl);terminalLib.applyAddon(fit);var term=new terminalLib({scrollback:1e4,theme:{foreground:"white",background:"#222",selection:"#fff",cursor:"#f73",cursorAccent:"#f22"}});term.id=terminalId;var termObject={socket:ws,term:term,contents:"",socketOpen:!1,sendQueue:[],send:function(data){termObject.socketOpen?ws.send(JSON.stringify(["stdin",data])):termObject.sendQueue.push(data)}};return ws.onopen=function(event){termObject.socketOpen=!0;var _iteratorNormalCompletion=!0,_didIteratorError=!1,_iteratorError=void 0;try{for(var _step,_iterator=termObject.sendQueue[Symbol.iterator]();!(_iteratorNormalCompletion=(_step=_iterator.next()).done);_iteratorNormalCompletion=!0){var data=_step.value;ws.send(JSON.stringify(["stdin",data]))}}catch(err){_didIteratorError=!0,_iteratorError=err}finally{try{_iteratorNormalCompletion||null==_iterator.return||_iterator.return()}finally{if(_didIteratorError)throw _iteratorError}}term.on("data",function(data){ws.send(JSON.stringify(["stdin",data]))}),term.on("focus",function(){terminals.focusedTerminal=term.id}),term.on("blur",function(){terminals.focusedTerminal=void 0}),term.on("refresh",function(data){var checkYdisp=term._core.buffer.ydisp;void 0!==term.storedYdisp&&term.storedYdisp!=checkYdisp&&terminals.eventsCallback({id:term.id,type:"refresh",scrollLine:checkYdisp}),term.storedYdisp=term._core.buffer.ydisp}),term.open(element),term.fit(),ws.send(JSON.stringify(["set_size",term.rows,term.cols,window.innerHeight,window.innerWidth])),ws.onmessage=function(event){var json_msg=JSON.parse(event.data);switch(json_msg[0]){case"stdout":var newChars=json_msg[1];term.write(newChars),term.storedYdisp=term._core.buffer.ydisp,termObject.contents+=newChars,terminals.eventsCallback({id:term.id,scrollLine:term.storedYdisp,position:termObject.contents.length,focusedTerminal:terminals.focusedTerminal,firstRecord:!1});break;case"disconnect":term.write("\r\n\r\n[CLOSED]\r\n")}}},termObject},getFocusedTerminal:function(){return terminals.focusedTerminal},getContentToFillTerminal:function(terminal,contents,contentsPointer){var term=terminal.term,portionLength=term.rows*term.cols*8;return contents.substr(Math.max(0,contentsPointer-portionLength),contentsPointer)},createTerminalCell:function(cellId,config){if(terminals.terminalsList.hasOwnProperty(cellId))return terminals.terminalsList[cellId];var cell=utils.findCellByCellId(cellId);if(void 0!==cell){var cellJq=$(cell.element),renderArea=cellJq.find(".rendered_html");renderArea.html('<div>  <span id="dummy-screen-rows" style="font-family:courier; font-weight:bold; font-size:15px;">bash-3.2$ </span></div>');var lineHeight=renderArea.find("#dummy-screen-rows").height();renderArea.html("Loading...");var terminalHeight=lineHeight*config.rows,terminalContainerId="graffiti-terminal-container-"+cellId;renderArea.html('<div class="graffiti-terminal-container" id="'+terminalContainerId+'" class="container" style="width:100%;height:'+terminalHeight+'px;"></div><div class="graffiti-terminal-links"> <div class="graffiti-terminal-go-notebook-dir">'+localizer.getString("JUMP_TO_NOTEBOOK_DIR")+'</div> <div class="graffiti-terminal-reset">'+localizer.getString("RESET_TERMINAL")+"</div></div>").show();var urlPathName=location.pathname,path=(location.host,"/terminals/websocket/");if(urlPathName.indexOf("/notebooks/")>0){var parts=urlPathName.split(/\/notebooks\//,2);path=parts[0].length>0?parts[0]+path:path}var wsUrl=location.protocol.replace("http","ws")+"//"+location.host+path+config.terminalId,elem=$("#"+terminalContainerId),sizeObj={cols:40,rows:10};renderArea.find(".graffiti-terminal-reset").click(function(e){var target=$(e.target),cellDOM=target.parents(".cell"),cellId=cellDOM.attr("graffiti-cell-id");terminals.resetTerminalCell(cellId)}),renderArea.find(".graffiti-terminal-container").bind("mousewheel",function(e){});var newTerminal=terminals._makeTerminal(elem[0],cellId,wsUrl,sizeObj);if(terminals.terminalsList[cellId]=newTerminal,elem.bind("click",function(){newTerminal.term.focus()}),void 0!==terminals.discoveredPwd){var cdCommand="if test -d "+terminals.discoveredPwd+"; then cd "+terminals.discoveredPwd+"; fi&& clear\n";(!terminals.singleCDCommand||terminals.singleCDCommand&&terminals.CDCommandCount<1)&&(newTerminal.send(cdCommand),terminals.CDCommandCount++);var resetCdCommand=cdCommand;renderArea.find(".graffiti-terminal-go-notebook-dir").click(function(e){void 0!==terminals.discoveredPwd&&(resetCdCommand="cd "+terminals.discoveredPwd+"&& clear\n"),newTerminal.send(resetCdCommand)})}else renderArea.find(".graffiti-terminal-go-notebook-dir").hide();return newTerminal}},createTerminalInCell:function(cell,terminalId,desiredRows){var cellId=utils.getMetadataCellId(cell.metadata);if(void 0===terminalId&&(terminalId=cellId),void 0!==cellId){var notebookDirectory=utils.getNotebookDirectory(),rows=void 0===desiredRows?6:desiredRows,graffitiConfig={type:"terminal",startingDirectory:notebookDirectory,terminalId:terminalId,rows:rows};return utils.assignCellGraffitiConfig(cell,graffitiConfig),utils.selectCellByCellId(cellId),cell.set_text("<i>Loading terminal ("+cellId+"), please wait...</i>"),cell.render(),terminals.createTerminalCell(cellId,graffitiConfig)}},refreshTerminalCell:function(cellId){if(void 0!==terminals.terminalsList[cellId]){var term=terminals.terminalsList[cellId].term;term.refresh(0,1e5),term.focus()}},resetTerminalCell:function(cellId){if(void 0!==terminals.terminalsList[cellId]){var cell=utils.findCellByCellId(cellId),graffitiConfig=utils.getCellGraffitiConfig(cell);if(void 0!==graffitiConfig){var deleteAPIEndpoint=location.origin+"/api/terminals/"+graffitiConfig.terminalId,settings={processData:!1,type:"DELETE",dataType:"json",success:function(){console.log("Graffiti: successful terminal delete.")},error:utils.log_ajax_error};jupyterUtils.ajax(deleteAPIEndpoint,settings)}var currentRows=terminals.terminalsList[cellId].term.rows;delete terminals.terminalsList[cellId],terminals.createTerminalInCell(cell,utils.generateUniqueId(),currentRows),utils.saveNotebookDebounced()}},removeTerminal:function(cellId){delete terminals.terminalsList[cellId]},createTerminalCellAboveSelectedCell:function(){var newTerminalCell=Jupyter.notebook.insert_cell_above("markdown");if(void 0!==newTerminalCell)return terminals.createTerminalInCell(newTerminalCell)},processRenderQueue:function(){if(terminals.renderQueue.length>0){var rq=terminals.renderQueue.shift(),cellId=utils.getMetadataCellId(rq.cell.metadata);terminals.createTerminalCell(cellId,rq.config),$(rq.cell.element[0]).unbind("dblclick").bind("dblclick",function(e){return e.stopPropagation(),!1}),setTimeout(terminals.processRenderQueue,250)}},renderAllTerminals:function(){var cell,cells=Jupyter.notebook.get_cells();terminals.renderQueue=[];for(var i=0;i<cells.length;++i)if(cell=cells[i],"markdown"===cell.cell_type&&cell.metadata.hasOwnProperty("graffitiConfig")&&"terminal"===cell.metadata.graffitiConfig.type){var config=$.extend({},cell.metadata.graffitiConfig);void 0!==utils.getNotebookGraffitiConfigEntry("singleTerminal")&&"true"==utils.getNotebookGraffitiConfigEntry("singleTerminal")&&(config.terminalId=utils.getNotebookGraffitiConfigEntry("id"),terminals.singleCDCommand=!0),terminals.renderQueue.push({cell:cell,config:config})}terminals.processRenderQueue()},backupTerminalOutput:function(cellId){var terminal=terminals.terminalsList[cellId];void 0!==terminal&&(terminal.contentsBackup=terminal.contents)},setTerminalContents:function(opts){var cellId=opts.id,newContents=opts.terminalsContents[cellId],terminal=terminals.terminalsList[cellId];if(void 0===terminal){if(console.log("Graffiti: cannot find terminal",cellId,"for sending output, trying to find next terminal from:",opts.nearestCellPosition),void 0===opts.nearestCellPosition||!opts.useNearestCellPosition)return;var i,nearestCell,checkCellId,cells=Jupyter.notebook.get_cells();for(cellId=void 0,i=opts.nearestCellPosition+1;i<cells.length;++i)if(nearestCell=cells[i],checkCellId=utils.getMetadataCellId(nearestCell.metadata),terminals.terminalsList.hasOwnProperty(checkCellId)){cellId=checkCellId,console.log("Graffiti: We found a subsequent terminal and will write output to cell:",cellId);break}if(void 0===cellId)return;terminal=terminals.terminalsList[cellId]}terminal.contents=newContents;var madeUpdateToTerminal=!1;if(void 0!==terminal){var didScroll=!1;if(!opts.incremental||opts.firstRecord||void 0===terminal.lastPosition){terminal.term.reset();var portion=terminals.getContentToFillTerminal(terminal,terminal.contents,opts.position);terminal.term.write(portion),terminal.lastPosition=opts.position,madeUpdateToTerminal=!0}else if(terminal.lastPosition!==opts.position){var newPortion=terminal.contents.substr(terminal.lastPosition,opts.position-terminal.lastPosition),newPortionCleaned=newPortion.replace(/([\x0d])([^\x0a])/g,"$2");terminal.term.write(newPortionCleaned),terminal.lastPosition=opts.position,terminal.term.scrollToBottom(),didScroll=!0,madeUpdateToTerminal=!0}didScroll||(madeUpdateToTerminal=madeUpdateToTerminal||terminals.scrollTerminal(opts))}return madeUpdateToTerminal},clearTerminalsContentsPositions:function(){for(var _i=0,_Object$keys=Object.keys(terminals.terminalsList);_i<_Object$keys.length;_i++){var cellId=_Object$keys[_i];terminals.terminalsList[cellId].lastPosition=void 0}},focusTerminal:function(cellId){var termRecord=terminals.terminalsList[cellId];if(void 0!==termRecord){utils.findCellByCellId(cellId).focus_cell(),terminals.focusedTerminal=cellId,termRecord.term.focus()}},scrollTerminal:function(opts){var termRecord=terminals.terminalsList[opts.id];if(void 0!==termRecord){var term=termRecord.term,scrollAmount=opts.scrollLine-term._core.buffer.ydisp;if(0!==scrollAmount)return term.scrollLines(scrollAmount),!0}return!1},restoreTerminalOutput:function(cellId){var terminal=terminals.terminalsList[cellId];void 0!==terminal&&void 0!==terminal.contentsBackup&&terminal.contents!=terminal.contentsBackup&&(terminal.contents=terminal.contentsBackup,terminal.term.reset(),terminal.term.write(terminal.contents))},saveOrRestoreTerminalOutputs:function(action){for(var _i2=0,_Object$keys2=Object.keys(terminals.terminalsList);_i2<_Object$keys2.length;_i2++){var cellId=_Object$keys2[_i2];"save"===action?terminals.backupTerminalOutput(cellId):terminals.restoreTerminalOutput(cellId)}},getTerminalsStates:function(markAsFirstRecord){for(var states=[],_i3=0,_Object$keys3=Object.keys(terminals.terminalsList);_i3<_Object$keys3.length;_i3++){var cellId=_Object$keys3[_i3];terminal=terminals.terminalsList[cellId],states.push({id:cellId,scrollLine:terminal.term._core.buffer.ydisp,position:terminal.contents.length,isFocused:terminals.focusedTerminal===cellId,focusedTerminal:terminals.focusedTerminal,firstRecord:markAsFirstRecord})}return states},getTerminalContents:function(terminalId){return terminals.terminalsList[terminalId].contents},getTerminalsContents:function(){for(var terminal,contents={},_i4=0,_Object$keys4=Object.keys(terminals.terminalsList);_i4<_Object$keys4.length;_i4++){var cellId=_Object$keys4[_i4];terminal=terminals.terminalsList[cellId],contents[cellId]=terminal.contents}return contents},refitOneTerminal:function(terminal,cellId){var refitTerminal=function(tryNumber){console.log("Graffiti: Attempting to fit terminal:",cellId,", attempt number",tryNumber),terminal.term.fit(),terminal.socket.send(JSON.stringify(["set_size",terminal.term.rows,terminal.term.cols,window.innerHeight,window.innerWidth])),console.log("Graffiti: fit terminal succeeded for:",cellId)};console.log("Graffiti: Running fit on term",terminal.term.rows,terminal.term.cols);var refitAttempts=0,refitInterval=setInterval(function(){try{++refitAttempts,refitTerminal(refitAttempts),clearInterval(refitInterval)}catch(ex){refitAttempts>terminals.maxRefitAttempts?(console.log("Graffiti: unable to call fit() after",refitAttempts,"tries, giving up."),clearInterval(refitInterval)):console.log("Graffiti: unable to call fit(), trying again in",terminals.fitRetryTime,"seconds.")}},terminals.fitRetryTime)},refitAllTerminals:function(){for(var terminal,_i5=0,_Object$keys5=Object.keys(terminals.terminalsList);_i5<_Object$keys5.length;_i5++){var cellId=_Object$keys5[_i5];terminal=terminals.terminalsList[cellId],terminal.term,terminals.refitOneTerminal(terminal,cellId)}},isTerminalCell:function(cellId){return void 0!==terminals.terminalsList[cellId]},runTerminalCommand:function(terminalId,command,addCR){if(void 0!==terminals.terminalsList[terminalId]){var term=terminals.terminalsList[terminalId];term.send(command),addCR&&term.send("\n")}},init:function(eventsCallback){terminals.discoverPwd(),terminals.eventsCallback=eventsCallback}};return terminals}),define("js/state.js",["js/utils.js","js/terminals.js"],function(utils,terminalLib){var _state,state=(_state={init:function(){console.log("Graffiti: state constructor running."),state.history=void 0,state.manifest={},state.movieCache={history:{},audio:{}},state.accessLevel="view",state.authorId=void 0,state.authorType="creator",state.audioInitialized=!1,state.recordingBlocked=!1,state.activity="idle",state.previousActivity=void 0,state.shouldUpdateCellContentsDuringPlayback=!1,state.pointer={x:0,y:0},state.windowSize=state.getWindowSize(),state.resetOnNextPlay=!1,state.recordedAudioString="",state.audioStorageCallback=void 0,state.frameArrays=["view","selections","contents","drawings","terminals","speaking","skip"],state.scrollTop=void 0,state.selectedCellId=void 0,state.mute=!1,state.compressedPlayTimeDuration=250,state.playSpeeds={regular:1,rapid:2,compressed:1,scanInactive:1,scanActive:3},state.currentPlaySpeed="regular",state.userChoicePlaySpeed="regular",state.rapidScanActive=!1,state.recordedCursorPosition={x:-1e3,y:-1e3},state.viewInfo=void 0,state.recordingCellInfo={},state.tipTimeout=void 0,state.displayedTipInfo=void 0,state.movieRecordingStarted=!1,state.cellsAffectedByActivity={},state.terminalsAffectedByActivity=void 0,state.drawingFadeClockAllowed=!0,state.drawingFadeStart,state.drawingFadeDuration=1e3,state.drawingFadePreFadeDelay=2e3,state.maxDrawingOpacity=.5,state.drawingOpacity=state.maxDrawingOpacity,state.totalDrawingFadeDuration=state.drawingFadePreFadeDelay+state.drawingFadeDuration,state.lastEditActivityTime=void 0,state.controlPanelDragging=!1,state.controlPanelDragOffset={x:0,y:0},state.playableMovies={},state.currentlyPlayingMovie=void 0,state.selectionSerialized=void 0,state.hidePlayerAfterPlayback=!1,state.dontRestoreCellContentsAfterPlayback=!1,state.cellOutputsSent={},state.stickerImageUrl=void 0,state.stickerImageCandidateUrl=void 0,state.cellIdsAddedDuringRecording={},state.userId=void 0,state.workspace={},state.speakingStatus=!1,state.currentSkipRecord=0,state.appliedSkipRecord=void 0,state.totalSkipTimeForRecording=0,state.cellStates={contents:{},changedCells:{},selections:{}},state.skippedTimeSoFar=0,state.animationIntervalIds={},state.playbackCellAdditions={},state.highlightsRefreshCellId=void 0,state.graffitiEditCellId=void 0,state.narratorInfo={},state.narratorInfoIsRendered=!1,state.shiftKeyIsDown=!1,state.shiftKeyWentDown=!1,state.scaleCursorWithWindow=!1,state.terminalState=void 0,state.applyingRawCalculatedScrollTop=!0,state.cellIdToGraffitiMap={},state.usageStats={notebookLoadedAt:utils.getNow(),created:{},played:{},terminalCommands:{},insertDataFromFile:{},userSkips:{},totalTipsShown:0,totalUniqueTipsShown:0,totalUniquePlays:0,totalPlaysAllGraffiti:0,totalPlayTimeAllGraffiti:0,totalTerminalCommandsRun:0,totalInsertDataFromFile:0,totalUserSkips:0,uniqueTips:{}},state.statsKey=void 0,state.drawingState={drawingModeActivated:!1,drawingActivity:"draw",cellId:void 0,positions:{start:{x:0,y:0},end:{x:0,y:0}},promptWidth:0,pen:{isDown:!1,mouseDownPosition:{x:0,y:0},downInMarkdown:!1,downInPromptArea:!1,inPromptArea:!1,permanence:"temporary",type:"line",color:"black",dash:"solid",fill:"none",fillOpacity:0},stickersRecords:{},stickerOnGrid:!1,opacity:state.maxDrawingOpacity},state.skipping=!1,state.skipTypes={rapid:1,absolute:2,compressed:3},state.skipInfo={type:state.skipTypes.absolute,factor:0},state.END_RECORDING_KEYDOWN_TIMEOUT=1200,utils.refreshCellMaps()},getManifest:function(){return state.manifest},setManifest:function(manifest){state.manifest=$.extend({},manifest)},removeManifestEntry:function(recordingCellId,recordingKey){var recordings=state.getManifestRecordingsForCell(recordingCellId);return!(void 0==recordings||!recordings.hasOwnProperty(recordingKey))&&(delete recordings[recordingKey],!0)},getManifestSingleRecording:function(recordingCellId,recordingKey){var recordings=state.getManifestRecordingsForCell(recordingCellId);if(void 0!==recordings)return recordings.hasOwnProperty(recordingKey)?recordings[recordingKey]:void 0},getManifestRecordingsForCell:function(recordingCellId){return state.manifest.hasOwnProperty(recordingCellId)?state.manifest[recordingCellId]:void 0},setSingleManifestRecording:function(recordingCellId,recordingKey,recordingData){state.manifest.hasOwnProperty(recordingCellId)||(state.manifest[recordingCellId]={}),state.manifest[recordingCellId][recordingKey]=recordingData},refreshCellIdToGraffitiMap:function(){state.cellIdToGraffitiMap={};for(var recording,recordingCellId,recordingKeys,i,saveToFileEntry,cellId,manifest=state.getManifest(),_i=0,_Object$keys=Object.keys(manifest);_i<_Object$keys.length;_i++){recordingCellId=_Object$keys[_i],recordingKeys=Object.keys(manifest[recordingCellId]);var _iteratorNormalCompletion=!0,_didIteratorError=!1,_iteratorError=void 0;try{for(var _step,_iterator=recordingKeys[Symbol.iterator]();!(_iteratorNormalCompletion=(_step=_iterator.next()).done);_iteratorNormalCompletion=!0)if(recordingKey=_step.value,recording=manifest[recordingCellId][recordingKey],void 0!==recording.saveToFile&&recording.saveToFile.length>0)for(i=0;i<recording.saveToFile.length;++i)saveToFileEntry=recording.saveToFile[i],cellId=saveToFileEntry.cellId,void 0===state.cellIdToGraffitiMap[cellId]&&(state.cellIdToGraffitiMap[cellId]=[]),state.cellIdToGraffitiMap[cellId].push(saveToFileEntry.path)}catch(err){_didIteratorError=!0,_iteratorError=err}finally{try{_iteratorNormalCompletion||null==_iterator.return||_iterator.return()}finally{if(_didIteratorError)throw _iteratorError}}}console.log("Graffiti: cellIdToGraffitiMap:",state.cellIdToGraffitiMap)},getCellIdToGraffitiMap:function(cellId){return state.cellIdToGraffitiMap[cellId]},computeManifestStats:function(){var recording,recordingCells,recordingCellId,recordingKeys,lenCheck,activeTakeId,takes,manifest=state.manifest,cells=Jupyter.notebook.get_cells(),totals={totalGraffitis:0,totalCells:cells.length,totalCellsWithGraffitis:0,maxGraffitiPerCell:0,maxTakesPerGraffiti:0,totalRecordedTime:0};if(recordingCells=Object.keys(manifest),recordingCells.length>0)for(var _i2=0,_Object$keys2=Object.keys(manifest);_i2<_Object$keys2.length;_i2++)if("stats"!==(recordingCellId=_Object$keys2[_i2])&&(recordingKeys=Object.keys(manifest[recordingCellId]),totals.totalCellsWithGraffitis++,(lenCheck=recordingKeys.length)>0)){lenCheck>totals.maxGraffitiPerCell&&(totals.maxGraffitiPerCell=lenCheck);var _iteratorNormalCompletion2=!0,_didIteratorError2=!1,_iteratorError2=void 0;try{for(var _step2,_iterator2=recordingKeys[Symbol.iterator]();!(_iteratorNormalCompletion2=(_step2=_iterator2.next()).done);_iteratorNormalCompletion2=!0)recordingKey=_step2.value,recording=manifest[recordingCellId][recordingKey],totals.totalGraffitis++,void 0!==(takes=recording.takes)&&(activeTakeId=recording.activeTakeId,void 0!==takes[activeTakeId]&&(totals.totalRecordedTime+=takes[activeTakeId].duration),(lenCheck=Object.keys(takes).length)>totals.maxTakesPerGraffiti&&(totals.maxTakesPerGraffiti=lenCheck))}catch(err){_didIteratorError2=!0,_iteratorError2=err}finally{try{_iteratorNormalCompletion2||null==_iterator2.return||_iterator2.return()}finally{if(_didIteratorError2)throw _iteratorError2}}}return totals},getAccessLevel:function(){return state.accessLevel},setAccessLevel:function(level){state.accessLevel=level},getAuthorId:function(){return state.authorId},setAuthorId:function(authorId){state.authorId=authorId},getAuthorType:function(){return state.authorType},setAuthorType:function(authorType){state.authorType=authorType},getUserId:function(){return state.userId},setUserId:function(userId){state.userId=userId},getWorkspace:function(){return state.workspace},setWorkspace:function(workspace){state.workspace=workspace},getSpeakingStatus:function(){return state.speakingStatus},setSpeakingStatus:function(speakingStatus){state.speakingStatus=speakingStatus,state.storeHistoryRecord("speaking")},clearHighlightsRefreshableCell:function(){state.highlightsRefreshCellId=void 0},isSkipping:function(){return state.skipping},isLastSkipRecord:function(){return void 0!==state.currentSkipRecord&&void 0!==state.history.skip&&state.currentSkipRecord===state.history.skip.length-1},startSkipping:function(){state.skipping=!0},stopSkipping:function(){state.skipping=!1},toggleSkipping:function(){state.skipping=!state.skipping,state.storeSkipRecord()},getCurrentSkipRecord:function(){return state.currentSkipRecord},timeInSkipRecordRange:function(t){if(void 0!==state.currentSkipRecord){var _record=state.history.skip[state.currentSkipRecord];if(_record.startTime<=t&&t<_record.endTime&&state.appliedSkipRecord!==state.currentSkipRecord)return _record}},setAppliedSkipRecord:function(){state.appliedSkipRecord=state.currentSkipRecord,state.skippedTimeSoFar+=state.currentSkipRecord.endTime-state.currentSkipRecord.startTime},clearAppliedSkipRecord:function(){state.appliedSkipRecord=void 0},getSkipInfo:function(){return state.skipInfo},setSkipInfo:function(info){state.skipInfo=void 0===info?{type:state.skipTypes.absolute,factor:0}:{type:info.type,factor:info.factor}},getTotalSkipTimeForRecording:function(){return state.totalSkipTimeForRecording},setTotalSkipTimeForRecording:function(){var record;if(state.totalSkipTimeForRecording=0,void 0!==state.history.skip)for(var i=0;i<state.history.skip.length;++i)record=state.history.skip[i],(void 0===record.status||void 0!==record.status&&-1===record.status)&&(state.totalSkipTimeForRecording+=record.endTime-record.startTime)},updateCurrentSkipRecord:function(){var record,t=state.getTimePlayedSoFar();if(state.currentSkipRecord=void 0,state.skippedTimeSoFar=0,void 0!==state.history.skip)for(var i=0;i<state.history.skip.length;++i)if(record=state.history.skip[i],record.endTime<t&&(state.skippedTimeSoFar+=record.endTime-record.startTime),record.startTime<=t&&t<record.endTime||record.startTime>t){state.currentSkipRecord=i;break}},createSkipRecord:function(){return{}},addCancelTimeSkipRecord:function(){state.skipping=!0;var record=state.createSkipRecord();record.startTime=state.history.duration-state.END_RECORDING_KEYDOWN_TIMEOUT,record.endTime=state.history.duration-1,state.history.skip.push(record),console.log("Graffiti: after addCancelTimeSkipRecord, skip history:",state.history.skip)},getSkipsRecords:function(){return state.history.skip},clearSkipsRecords:function(){state.history.skip=[]},storeSkipRecord:function(){var numRecords=state.history.skip.length;if(state.skipping)state.storeHistoryRecord("skip");else if(numRecords>0){var lastRecord=state.history.skip[numRecords-1];lastRecord.hasOwnProperty("endTime")||(lastRecord.endTime=utils.getNow(),console.log("Graffiti: closed off previous record:",lastRecord),lastRecord.endTime-lastRecord.startTime<10&&state.history.skip.pop())}console.log("after storeSkipRecord, skip history:",state.history.skip)},getSkippedTimeSoFar:function(){return state.skippedTimeSoFar},getShiftKeyIsDown:function(){return state.shiftKeyIsDown},setShiftKeyIsDown:function(val){state.shiftKeyIsDown=val},getShiftKeyWentDown:function(){return state.shiftKeyWentDown},setShiftKeyWentDown:function(){state.shiftKeyWentDown=!0},clearShiftKeyWentDown:function(){state.shiftKeyWentDown=!1},getScaleCursorWithWindow:function(){return state.scaleCursorWithWindow},clearScaleCursorWithWindow:function(){state.scaleCursorWithWindow=!1},setScaleCursorWithWindow:function(){state.scaleCursorWithWindow=!0},getApplyingRawCalculatedScrollTop:function(){return state.applyingRawCalculatedScrollTop},activateApplyingRawCalculatedScrollTop:function(){state.applyingRawCalculatedScrollTop=!0},deactivateApplyingRawCalculatedScrollTop:function(){state.applyingRawCalculatedScrollTop=!1},getGraffitiEditCellId:function(){return state.graffitiEditCellId},setGraffitiEditCellId:function(cellId){state.graffitiEditCellId=cellId},getNarratorInfo:function(which){return state.narratorInfo[which]},clearNarratorInfo:function(){state.narratorInfo={}},setNarratorInfo:function(which,val){state.narratorInfo[which]=val},getNarratorInfoIsRendered:function(){return state.narratorInfoIsRendered},setNarratorInfoIsRendered:function(val){state.narratorInfoIsRendered=val},scanForSpeakingStatus:function(){targetTime=state.getTimePlayedSoFar();var lastSpeakingIndex=state.getIndexUpToTime("speaking",targetTime),currentSpeakingStatus=!0;if(void 0!==lastSpeakingIndex)for(var index=0;index<lastSpeakingIndex;++index)record=state.getHistoryItem("speaking",index),currentSpeakingStatus=record.speaking;return currentSpeakingStatus},setHighlightsRefreshCellId:function(cellId){state.highlightsRefreshCellId=cellId},getHighlightsRefreshCellId:function(){return state.highlightsRefreshCellId},getAudioInitialized:function(){return state.audioInitialized},setAudioInitialized:function(){state.audioInitialized=!0},getLastEditActivityTime:function(){return state.lastEditActivityTime},setLastEditActivityTime:function(){state.lastEditActivityTime=utils.getNow()},clearLastEditActivityTime:function(){state.lastEditActivityTime=void 0},getControlPanelDragging:function(){return state.controlPanelDragging},getControlPanelDragOffset:function(){return state.controlPanelDragOffset},setControlPanelDragOffset:function(offset){state.controlPanelDragOffset=offset},setControlPanelDragging:function(dragging){state.controlPanelDragging=dragging},getWindowSize:function(){return{width:$(window).width(),height:$(window).height()}},getStoredWindowSize:function(){return state.windowSize},windowSizeChanged:function(){var currentWindowSize=state.getWindowSize(),previousWindowSize=state.getStoredWindowSize();return(previousWindowSize.width!==currentWindowSize.width||previousWindowSize.height!==currentWindowSize.height)&&(state.windowSize=state.getWindowSize(),!0)},setTipTimeout:function(tipFunc,t){state.clearTipTimeout(),state.tipTimeout=setTimeout(tipFunc,t)},clearTipTimeout:function(){void 0!==state.tipTimeout&&(clearTimeout(state.tipTimeout),state.tipTimeout=void 0)},clearDisplayedTipInfo:function(){state.displayedTipInfo=void 0},setDisplayedTipInfo:function(cellId,recordingKey){state.displayedTipInfo={cellId:cellId,recordingKey:recordingKey}},getDisplayedTipInfo:function(){return state.displayedTipInfo},getStickerImageUrl:function(stickerImageUrl){return state.stickerImageUrl},setStickerImageUrl:function(stickerImageUrl){state.stickerImageUrl=stickerImageUrl},getStickerImageCandidateUrl:function(stickerImageCandidateUrl){return state.stickerImageCandidateUrl},setStickerImageCandidateUrl:function(stickerImageCandidateUrl){state.stickerImageCandidateUrl=stickerImageCandidateUrl},saveSelectedCellId:function(cellId){state.selectedCellId=cellId},getSelectedCellId:function(){return state.selectedCellId},getMute:function(){return state.mute},setMute:function(muteState){state.mute=muteState},rapidIsOn:function(){return"rapid"===state.currentPlaySpeed},scanningIsOn:function(){return"scanActive"===state.currentPlaySpeed||"scanInactive"===state.currentPlaySpeed},getCurrentPlaySpeed:function(){return state.currentPlaySpeed},resetPlayTimes:function(preset){state.playTimes={};for(var _i3=0,_Object$keys3=Object.keys(state.playSpeeds);_i3<_Object$keys3.length;_i3++){var type=_Object$keys3[_i3];state.playTimes[type]={start:void 0,total:0}}void 0!==preset&&(state.playTimes.regular={start:utils.getNow(),total:preset})},setPlayTimeBegin:function(kind){state.playTimes[kind].start=utils.getNow()},setPlayTimeEnd:function(kind){var playSpeed=state.currentPlaySpeed;void 0!==kind&&(playSpeed=kind),state.playTimes[playSpeed].total+=utils.getNow()-state.playTimes[playSpeed].start},setCurrentPlaySpeed:function(kind){"playing"===state.activity&&state.currentPlaySpeed!==kind&&(state.setPlayTimeEnd(),state.setPlayTimeBegin(kind)),state.currentPlaySpeed=kind},getUserChoicePlaySpeed:function(){return state.userChoicePlaySpeed},storeUserChoicePlaySpeed:function(userChoicePlaySpeed){state.userChoicePlaySpeed=userChoicePlaySpeed},getPlayRateScalar:function(){return state.playSpeeds[state.currentPlaySpeed]},setPlayRate:function(kind,newPlayRate){state.playSpeeds[kind]=newPlayRate},setCompressedTimePlayRate:function(duration,timeTarget){var accelerationFactor=duration/timeTarget;state.setPlayRate("compressed",accelerationFactor)},setPlayStartTimeToNow:function(){state.playTimes[state.currentPlaySpeed].start=utils.getNow()},shouldUpdateDisplay:function(kind,frameIndex){return void 0!==frameIndex&&(!_.contains(state.history.processed[kind],frameIndex.index)&&(state.history.processed[kind].push(frameIndex.index),!0))},resetProcessedArrays:function(){if(void 0!==state.history){state.history.processed=[];var _iteratorNormalCompletion3=!0,_didIteratorError3=!1,_iteratorError3=void 0;try{for(var _step3,_iterator3=state.frameArrays[Symbol.iterator]();!(_iteratorNormalCompletion3=(_step3=_iterator3.next()).done);_iteratorNormalCompletion3=!0){
var arrName=_step3.value;state.history.processed[arrName]=[]}}catch(err){_didIteratorError3=!0,_iteratorError3=err}finally{try{_iteratorNormalCompletion3||null==_iterator3.return||_iterator3.return()}finally{if(_didIteratorError3)throw _iteratorError3}}}},blockRecording:function(){state.recordingBlocked=!0},unblockRecording:function(){state.recordingBlocked=!1},getUsageStats:function(){var usageStats=$.extend(!0,{},state.usageStats,state.computeManifestStats());return usageStats.totalUniqueTipsShown=Object.keys(state.usageStats.uniqueTips).length,usageStats.statsGatheredAt=utils.getNow(),delete usageStats.uniqueTips,usageStats},updateUsageStats:function(opts){var cellId,recordingKey,activeTakeId,statsKey,data=opts.data,type=opts.type,playStats=state.usageStats.played,createStats=state.usageStats.created;switch("create"!==type&&"setup"!==type&&"terminalCommand"!==type&&"tip"!==type&&"insertDataFromFile"!==type||(cellId=data.cellId,recordingKey=data.recordingKey),type){case"create":statsKey=utils.composeGraffitiId(cellId,recordingKey),createStats.hasOwnProperty(statsKey)||(createStats[statsKey]={createDate:data.createDate,numEditsThisSession:0}),createStats[statsKey].numEditsThisSession++,createStats[statsKey].numTakes=data.numTakes;break;case"setup":if(activeTakeId=data.activeTakeId,statsKey=utils.composeGraffitiId(cellId,recordingKey,activeTakeId),!playStats.hasOwnProperty(statsKey)){var epochTime=utils.getNow();playStats[statsKey]={totalTime:0,totalTimeThisPlay:0,epochTime:epochTime,maxViewingTime:0,totalPlays:0,totalPlaysRightAfterLoad:0,recordingDuration:state.history.duration,userHitEscape:!1}}state.currentStatsKey=statsKey;break;case"tip":state.usageStats.totalTipsShown++;var tipKey=utils.composeGraffitiId(cellId,recordingKey);state.usageStats.uniqueTips.hasOwnProperty(tipKey)||(state.usageStats.uniqueTips[tipKey]=0),state.usageStats.uniqueTips[tipKey]++;break;case"insertDataFromFile":statsKey=utils.composeGraffitiId(cellId,recordingKey),state.usageStats.totalInsertDataFromFile++,state.usageStats.insertDataFromFile.hasOwnProperty(statsKey)||(state.usageStats.insertDataFromFile[statsKey]=0),state.usageStats.insertDataFromFile[statsKey]++;break;case"terminalCommand":var terminalCommandsStats=state.usageStats.terminalCommands;statsKey=utils.composeGraffitiId(cellId,recordingKey),state.usageStats.totalTerminalCommandsRun++,terminalCommandsStats.hasOwnProperty(statsKey)||(terminalCommandsStats[statsKey]={commands:[],numRunsThisSession:0}),terminalCommandsStats[statsKey].numRunsThisSession++,terminalCommandsStats[statsKey].commands.push(data.command);break;case"userSkips":state.usageStats.totalUserSkips++,state.usageStats.userSkips.hasOwnProperty(state.currentStatsKey)||(state.usageStats.userSkips[state.currentStatsKey]=0),state.usageStats.userSkips[state.currentStatsKey]++;break;case"play":var usageRecord=playStats[state.currentStatsKey],_iteratorNormalCompletion4=!0,_didIteratorError4=!1,_iteratorError4=void 0;try{for(var _step4,_iterator4=data.actions[Symbol.iterator]();!(_iteratorNormalCompletion4=(_step4=_iterator4.next()).done);_iteratorNormalCompletion4=!0){switch(_step4.value){case"resetCurrentPlayTime":delete usageRecord.currentPlayTime,usageRecord.totalTimeThisPlay=0,usageRecord.totalPlaysRightAfterLoad++;break;case"updateCurrentPlayTime":usageRecord.currentPlayTime=Math.round(state.getTimePlayedSoFar());break;case"updateTotalPlayTime":void 0!==state.currentStatsKey&&(usageRecord.totalTime+=usageRecord.currentPlayTime,usageRecord.totalTimeThisPlay=Math.min(usageRecord.recordingDuration,usageRecord.currentPlayTime+usageRecord.totalTimeThisPlay),usageRecord.maxViewingTime=Math.min(usageRecord.recordingDuration,Math.max(usageRecord.maxViewingTime,usageRecord.totalTimeThisPlay)),state.usageStats.totalPlayTimeAllGraffiti+=usageRecord.currentPlayTime,delete usageRecord.currentPlayTime);break;case"incrementPlayCount":usageRecord.totalPlays++,state.usageStats.totalPlaysAllGraffiti++,state.usageStats.totalUniquePlays=Object.keys(playStats).length;break;case"userHitEscape":usageRecord.userHitEscape=!0}}}catch(err){_didIteratorError4=!0,_iteratorError4=err}finally{try{_iteratorNormalCompletion4||null==_iterator4.return||_iterator4.return()}finally{if(_didIteratorError4)throw _iteratorError4}}}},getDrawingPenAttribute:function(attr){return state.drawingState.pen[attr]},getDrawingState:function(){return state.drawingState},getDrawingStateField:function(field){return state.drawingState[field]},storeStickersStateForCell:function(stickers,cellId){var stickersRecords={};if(void 0!==stickers&&stickers.length>0){stickersRecords=[];var _iteratorNormalCompletion5=!0,_didIteratorError5=!1,_iteratorError5=void 0;try{for(var _step5,_iterator5=stickers[Symbol.iterator]();!(_iteratorNormalCompletion5=(_step5=_iterator5.next()).done);_iteratorNormalCompletion5=!0){var sticker=_step5.value;stickersRecords.push({positions:{start:{x:sticker.positions.start.x,y:sticker.positions.start.y},end:{x:sticker.positions.end.x,y:sticker.positions.end.y}},innerCellRect:{left:sticker.innerCellRect.left,top:sticker.innerCellRect.top,width:sticker.innerCellRect.width,height:sticker.innerCellRect.height},pen:{stickerType:sticker.pen.stickerType,color:sticker.pen.color,dash:sticker.pen.dash,fill:sticker.pen.fill,fillOpacity:sticker.pen.fillOpacity,permanence:sticker.pen.permanence,label:sticker.pen.label,downInMarkdown:sticker.pen.downInMarkdown,downInPromptArea:sticker.pen.downInPromptArea,inPromptArea:sticker.pen.inPromptArea},stickerOnGrid:sticker.stickerOnGrid,promptWidth:sticker.promptWidth})}}catch(err){_didIteratorError5=!0,_iteratorError5=err}finally{try{_iteratorNormalCompletion5||null==_iterator5.return||_iterator5.return()}finally{if(_didIteratorError5)throw _iteratorError5}}}state.drawingState.stickersRecords=stickersRecords},updateDrawingState:function(changeSets){var _iteratorNormalCompletion6=!0,_didIteratorError6=!1,_iteratorError6=void 0;try{for(var _step6,_iterator6=changeSets[Symbol.iterator]();!(_iteratorNormalCompletion6=(_step6=_iterator6.next()).done);_iteratorNormalCompletion6=!0){var changeSet=_step6.value,change=changeSet.change,data=changeSet.data,drawingState=state.drawingState;switch(drawingState.wipe=!1,change){case"drawingModeActivated":drawingState.drawingModeActivated=data;break;case"drawingActivity":drawingState.drawingActivity=data;break;case"cellId":drawingState.cellId=data;break;case"isDown":drawingState.pen.isDown=data;break;case"mouseDownPosition":drawingState.pen.mouseDownPosition={x:data.x,y:data.y};break;case"downInMarkdown":drawingState.pen.downInMarkdown=data;break;case"downInPromptArea":drawingState.pen.downInPromptArea=data;break;case"inPromptArea":drawingState.pen.inPromptArea=data;break;case"promptWidth":drawingState.promptWidth=data;break;case"stickerOnGrid":drawingState.stickerOnGrid=data;break;case"fillOpacity":drawingState.pen.fillOpacity=data;break;case"penType":drawingState.pen.type=data;break;case"stickerType":drawingState.pen.stickerType=data;var fill="none";switch(data){case"isocelesTriangle":case"rightTriangle":case"ellipse":case"rectangle":case"leftCurlyBrace":case"rightCurlyBrace":case"symmetricCurlyBraces":case"topBracket":case"bottomBracket":case"leftBracket":case"rightBracket":case"horizontalBrackets":case"verticalBrackets":case"smiley":case"frowney":case"thumbsUp":case"thumbsDown":case"star":case"line":case"lineWithArrow":case"label":case"custom":break;case"checkMark":fill="00aa00";break;case"x":fill="aa0000";break;case"theta":case"sigma":fill="000000"}drawingState.pen.fill=fill;break;case"label":drawingState.pen.label=data;break;case"permanence":drawingState.pen.permanence=data;break;case"positions":var bbox={start:{x:data.positions.start.x,y:data.positions.start.y},end:{x:data.positions.end.x,y:data.positions.end.y}};"sticker"===drawingState.pen.penType&&"line"!==drawingState.pen.stickerType&&(bbox={start:{x:Math.min(data.positions.start.x,data.positions.end.x),y:Math.min(data.positions.start.y,data.positions.end.y)},end:{x:Math.max(data.positions.start.x,data.positions.end.x),y:Math.max(data.positions.start.y,data.positions.end.y)}}),drawingState.positions=bbox;break;case"color":drawingState.pen.color=data;break;case"dash":drawingState.pen.dash=data;break;case"opacity":drawingState.opacity=data;break;case"wipe":drawingState.wipe=!0}}}catch(err){_didIteratorError6=!0,_iteratorError6=err}finally{try{_iteratorNormalCompletion6||null==_iterator6.return||_iterator6.return()}finally{if(_didIteratorError6)throw _iteratorError6}}},resetDrawingOpacity:function(){state.drawingState.opacity=state.maxDrawingOpacity},getActivePenType:function(){return state.drawingState.pen.type},getDrawingOpacity:function(){return state.drawingOpacity},setDrawingOpacity:function(opacity){state.drawingState.drawingOpacity=opacity},getMaxDrawingOpacity:function(){return state.maxDrawingOpacity}},_defineProperty(_state,"resetDrawingOpacity",function(){state.drawingState.drawingOpacity=state.maxDrawingOpacity}),_defineProperty(_state,"getDrawingFadeTimeSoFar",function(){return utils.getNow()-state.drawingFadeStart}),_defineProperty(_state,"calculateDrawingOpacity",function(){var timeSoFar=state.getDrawingFadeTimeSoFar(),opacity=state.maxDrawingOpacity;return!state.drawingFadeClockAllowed||timeSoFar<state.drawingFadePreFadeDelay?{status:"max",opacity:state.maxDrawingOpacity}:timeSoFar<state.totalDrawingFadeDuration?(opacity=(state.totalDrawingFadeDuration-timeSoFar)/state.drawingFadeDuration*state.maxDrawingOpacity,{status:"fade",opacity:opacity}):{status:"fadeDone",opacity:0}}),_defineProperty(_state,"disableDrawingFadeClock",function(){state.drawingFadeClockAllowed=!1}),_defineProperty(_state,"startDrawingFadeClock",function(){state.drawingFadeStart=utils.getNow(),state.drawingFadeClockAllowed=!0}),_defineProperty(_state,"getLastRecordedCursorPosition",function(){return{x:state.recordedCursorPosition.x,y:state.recordedCursorPosition.y}}),_defineProperty(_state,"setLastRecordedCursorPosition",function(pos){state.recordedCursorPosition={x:pos.x,y:pos.y}}),_defineProperty(_state,"getPlaybackStartTime",function(){return state.playbackStartTime}),_defineProperty(_state,"setPlaybackStartTime",function(startTime){state.playbackStartTime=startTime}),_defineProperty(_state,"startAnimationInterval",function(name,cb,timing){void 0!==state.animationIntervalIds[name]&&clearInterval(state.animationIntervalIds[name]),state.animationIntervalIds[name]=setInterval(cb,timing)}),_defineProperty(_state,"clearAnimationIntervals",function(){for(var ids=Object.keys(state.animationIntervalIds),_i4=0,_ids=ids;_i4<_ids.length;_i4++){var id=_ids[_i4];void 0!==state.animationIntervalIds[id]&&(clearInterval(state.animationIntervalIds[id]),delete state.animationIntervalIds[id])}}),_defineProperty(_state,"getSetupForReset",function(){return state.resetOnNextPlay}),_defineProperty(_state,"clearSetupForReset",function(){state.resetOnNextPlay=!1}),_defineProperty(_state,"setupForReset",function(){state.resetOnNextPlay=!0}),_defineProperty(_state,"getResetOnNextPlay",function(){return state.resetOnNextPlay}),_defineProperty(_state,"resetPlayState",function(){state.resetOnNextPlay=!1,state.resetPlayTimes(),state.resetProcessedArrays()}),_defineProperty(_state,"getActivity",function(){return state.activity}),_defineProperty(_state,"setActivity",function(newState){console.log("Graffiti: setting activity to:",newState),state.activity=newState}),_defineProperty(_state,"getPreviousActivity",function(){return state.previousActivity}),_defineProperty(_state,"storePreviousActivity",function(){state.previousActivity=state.activity}),_defineProperty(_state,"restorePreviousActivity",function(){state.activity=state.previousActivity}),_defineProperty(_state,"getPointerPosition",function(){return state.pointer}),_defineProperty(_state,"storePointerPosition",function(x,y){state.pointer={x:x,y:y}}),_defineProperty(_state,"getViewInfo",function(){return state.viewInfo}),_defineProperty(_state,"storeViewInfo",function(viewInfo){void 0!==viewInfo.cellId&&(state.viewInfo=$.extend({},viewInfo))}),_defineProperty(_state,"setSelectionSerialized",function(selectionSerialized){state.selectionSerialized=selectionSerialized}),_defineProperty(_state,"clearSelectionSerialized",function(){state.selectionSerialized=void 0}),_defineProperty(_state,"getSelectionSerialized",function(){return state.selectionSerialized}),_defineProperty(_state,"getRecordingCellInfo",function(){return void 0!==state.history&&void 0!==state.history.duration&&void 0!==state.recordingCellInfo.takes&&void 0!==state.recordingCellInfo.activeTakeId&&(state.recordingCellInfo.takes[state.recordingCellInfo.activeTakeId].duration=state.history.duration),state.recordingCellInfo}),_defineProperty(_state,"storeRecordingCellInfo",function(cellInfo){state.recordingCellInfo=cellInfo}),_defineProperty(_state,"getPlayableMovie",function(kind){return state.playableMovies[kind]}),_defineProperty(_state,"setPlayableMovie",function(kind,cellId,recordingKey,hoverCellId){var cellIndex=void 0;void 0!==hoverCellId&&(cellIndex=utils.findCellIndexByCellId(hoverCellId));var cell=utils.findCellByCellId(cellId),cellType=void 0===cell?void 0:cell.cell_type,recording=state.getManifestSingleRecording(cellId,recordingKey),activeTakeId=recording.activeTakeId;return state.playableMovies[kind]={recordingCellId:cellId,recordingKey:recordingKey,activeTakeId:activeTakeId,cell:cell,cellIndex:cellIndex,cellType:cellType},state.setStickerImageCandidateUrl(recording.stickerImageUrl),recording}),_defineProperty(_state,"clearPlayableMovie",function(kind){state.playableMovies[kind]=void 0}),_defineProperty(_state,"getMovieRecordingStarted",function(){return state.movieRecordingStarted}),_defineProperty(_state,"setMovieRecordingStarted",function(status){state.movieRecordingStarted=status}),_defineProperty(_state,"getCurrentlyPlayingMovie",function(){return state.currentlyPlayingMovie}),_defineProperty(_state,"setCurrentlyPlayingMovie",function(movie){state.currentlyPlayingMovie=movie}),_defineProperty(_state,"getHidePlayerAfterPlayback",function(){return state.hidePlayerAfterPlayback}),_defineProperty(_state,"setHidePlayerAfterPlayback",function(status){state.hidePlayerAfterPlayback=status}),_defineProperty(_state,"getDontRestoreCellContentsAfterPlayback",function(){return state.dontRestoreCellContentsAfterPlayback}),_defineProperty(_state,"setDontRestoreCellContentsAfterPlayback",function(status){state.dontRestoreCellContentsAfterPlayback=status}),_defineProperty(_state,"clearCellOutputsSent",function(){state.cellOutputsSent={}}),_defineProperty(_state,"getCellAdditions",function(){if(void 0!==state.history){return _.union(Object.keys(state.history.cellAdditions),Object.keys(state.playbackCellAdditions))}}),_defineProperty(_state,"storeCellAddition",function(cellId,position){"recording"===state.activity&&(state.history.cellAdditions[cellId]=position)}),_defineProperty(_state,"storePlaybackCellAddition",function(cellId,position){state.playbackCellAdditions[cellId]=position}),_defineProperty(_state,"clearCellAdditions",function(){state.history.cellAdditions={},state.playbackCellAdditions={}}),_defineProperty(_state,"storeTerminalsState",function(newState){state.terminalsState=newState}),_defineProperty(_state,"getShouldUpdateCellContentsDuringPlayback",function(){return state.shouldUpdateCellContentsDuringPlayback}),_defineProperty(_state,"setShouldUpdateCellContentsDuringPlayback",function(val){state.shouldUpdateCellContentsDuringPlayback=val}),_defineProperty(_state,"dumpHistory",function(){console.log("Graffiti: Dumping JSON history"),console.log("Graffiti: =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-"),console.log("Graffiti:",state.history),console.log("Graffiti: =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-")}),_defineProperty(_state,"createViewRecord",function(subType){var drawingState=state.drawingState,pen=drawingState.pen,downInMarkdown=pen.isDown&&pen.downInMarkdown,downInPromptArea=pen.isDown&&pen.downInPromptArea,drawingActivity=pen.isDown?drawingState.drawingActivity:void 0,stickerCellId=pen.isDown&&"sticker"==drawingState.drawingActivity?drawingState.cellId:void 0,stickerInfo=void 0,stickerCellWidth=0,stickerCellHeight=0;if(void 0!==stickerCellId){var stickerCell=utils.findCellByCellId(stickerCellId),stickerCellElement=$(stickerCell.element[0]).find(".inner_cell"),bbox=stickerCellElement[0].getBoundingClientRect();stickerCellWidth=bbox.width,stickerCellHeight=bbox.height,stickerInfo={cellId:stickerCellId,width:stickerCellWidth,height:stickerCellHeight}}var topBarHeight=$("#header").height(),inTopBarArea=state.pointer.y<topBarHeight;return $.extend({},state.viewInfo,{x:state.pointer.x-parseInt(state.viewInfo.outerCellRect.left),y:state.pointer.y-parseInt(state.viewInfo.outerCellRect.top),downInMarkdown:downInMarkdown,downInPromptArea:downInPromptArea,drawingActivity:drawingActivity,inTopBarArea:inTopBarArea,subType:subType,speakingStatus:state.speakingStatus,scrollDiff:state.viewInfo.scrollDiff,selectedCellId:state.selectedCellId,stickerInfo:stickerInfo})}),_defineProperty(_state,"createDrawingRecord",function(opts){var cell=utils.findCellByCellId(state.drawingState.cellId),cellRects=utils.getCellRects(cell),record=$.extend(!0,{},{innerCellRect:{left:cellRects.innerCellRect.left,top:cellRects.innerCellRect.top,width:cellRects.innerCellRect.width,height:cellRects.innerCellRect.height}},state.drawingState);return delete record.drawingModeActivated,delete record.pen.isDown,delete record.pen.mouseDownPosition,delete record.wipe,delete record.stickerActive,delete record.stickerOnGrid,opts.stickering&&(delete record.positions,delete record.pen,delete record.promptWidth,delete record.innerCellRect),record}),_defineProperty(_state,"createStickerRecord",function(){var cell=utils.findCellByCellId(state.drawingState.cellId),cellRects=utils.getCellRects(cell),record=$.extend(!0,{},{innerCellRect:{left:cellRects.innerCellRect.left,top:cellRects.innerCellRect.top,width:cellRects.innerCellRect.width,height:cellRects.innerCellRect.height}},state.drawingState);return delete record.drawingModeActivated,delete record.pen.isDown,delete record.pen.mouseDownPosition,delete record.wipe,record}),_defineProperty(_state,"createSelectionsRecord",function(){for(var cellId,cm,cell,selections,cellSelections,output,outputs0,ourJs,activeCell=Jupyter.notebook.get_selected_cell(),cells=Jupyter.notebook.get_cells(),cellsSelections={},i=0;i<cells.length;++i)cell=cells[i],"code"===cell.cell_type&&(cellId=utils.getMetadataCellId(cell.metadata),cm=cell.code_mirror,selections=utils.cleanSelectionRecords(cm.listSelections()),output=null,ourJs=!1,cell.output_area.outputs.length>0?(outputs0=cell.output_area.outputs[0],output_type=outputs0.output_type,"display_data"===output_type&&outputs0.data.hasOwnProperty("application/javascript")&&null!==outputs0.data["application/javascript"].match(/Graffiti\sjavascript/g)&&(ourJs=!0),ourJs||(output={header:{msg_type:output_type},content:outputs0})):output={empty:!0},cellSelections={index:i,active:cellId===utils.getMetadataCellId(activeCell.metadata),selections:selections,output:output},cellsSelections[cellId]=cellSelections);return{cellsSelections:cellsSelections,textSelection:state.selectionSerialized}}),_defineProperty(_state,"extractDataFromContentRecord",function(record,cellId){return void 0!==record.backRef?"contents"===record.backRefKind?state.history.contents[record.backRef].cellsContent[cellId].contentsRecord.data:state.history.contents[record.backRef].cellsContent[cellId].outputsRecord.data:record.data}),_defineProperty(_state,"createBackRefRecord",function(data,backRefKind,backRefArray,cellId){var backRef,record=backRefArray[cellId];return void 0!==record&&("contents"===backRefKind&&data===record.data||"outputs"===backRefKind&&_.isEqual(data,record.data))&&(backRef=record.index,data=void 0),void 0!==data&&(backRefKind=void 0,backRefArray[cellId]={index:state.history.contents.length,data:data}),{data:data,backRefKind:backRefKind,backRef:backRef}}),_defineProperty(_state,"createContentsRecord",function(doBackRefStore){for(var cellId,cell,outputs,contentsBackRefRecord,outputsBackRefRecord,cells=Jupyter.notebook.get_cells(),cellsContent={},cellsPresentThisFrame={},i=0;i<cells.length;++i){cell=cells[i];var graffitiConfig=utils.getCellGraffitiConfig(cell);if(void 0!==graffitiConfig){var graffitiType=graffitiConfig.type;if(void 0!==graffitiType&&"terminal"===graffitiType)continue}cellId=utils.getMetadataCellId(cell.metadata),cellsPresentThisFrame[cellId]=utils.findCellIndexByCellId(cellId);var _contents=cell.get_text();outputs=void 0;var cellDom=$(cell.element),outputArea=cellDom.find(".output");outputArea.length>0&&(outputs=outputArea.html()),doBackRefStore?(contentsBackRefRecord=state.createBackRefRecord(_contents,"contents",state.history.cellContentsTracking,cellId),outputsBackRefRecord=state.createBackRefRecord(outputs,"outputs",state.history.cellOutputsTracking,cellId)):(contentsBackRefRecord={data:_contents,backRefKind:"contents",backRef:void 0},outputsBackRefRecord={data:outputs,backRefKind:"outputs",backRef:void 0});var cellContent={index:i,contentsRecord:contentsBackRefRecord,outputsRecord:outputsBackRefRecord};cellsContent[cellId]=cellContent}return{cellsContent:cellsContent,cellsPresentThisFrame:cellsPresentThisFrame}}),_defineProperty(_state,"createTerminalsRecord",function(){var markAsFirstRecord=0===state.history.terminals.length;return{terminals:terminalLib.getTerminalsStates(markAsFirstRecord)}}),_defineProperty(_state,"getHistoryTerminalsContents",function(){return state.history.terminalsContents}),_defineProperty(_state,"storeTerminalsContentsInHistory",function(){state.history.terminalsContents=terminalLib.getTerminalsContents()}),_defineProperty(_state,"createSpeakingRecord",function(){return{speaking:state.speakingStatus}}),_defineProperty(_state,"storeHistoryRecord",function(type,time){if("recording"===state.activity&&!state.recordingBlocked){var record;switch(type){case"pointer":record=state.createViewRecord("pointer"),type="view";break;case"scroll":record=state.createViewRecord("scroll"),type="view";break;case"innerScroll":record=state.createViewRecord("innerScroll"),type="view";break;case"focus":record=state.createViewRecord("focus"),type="view";break;case"selectCell":record=state.createViewRecord("selectCell"),type="view";break;case"drawings":record=state.createDrawingRecord({stickering:!1});break;case"stickers":record=state.createDrawingRecord({stickering:!0}),type="drawings";break;case"selections":record=state.createSelectionsRecord();break;case"contents":record=state.createContentsRecord(!0);break;case"terminals":record=state.createTerminalsRecord();break;case"speaking":record=state.createSpeakingRecord();break;case"skip":record=state.createSkipRecord()}record.startTime=void 0!==time?time:utils.getNow(),state.history[type].push(record)}}),_defineProperty(_state,"initHistory",function(initialValues){var now=utils.getNow();state.history={storageCellId:initialValues.storageCellId,recordingStartTime:now,view:[],selections:[],contents:[],drawings:[],terminals:[],speaking:[],skip:[],lastVisited:{view:0,selections:0,contents:0,drawings:0,terminals:0,speaking:0,skip:0},cellContentsTracking:{},cellOutputsTracking:{},cellAdditions:{}},state.resetProcessedArrays(),state.storeHistoryRecord("pointer",now),state.storeHistoryRecord("scroll",now),state.storeHistoryRecord("focus",now),state.storeHistoryRecord("selections",now),state.storeHistoryRecord("contents",now),state.storeHistoryRecord("terminals",now)}),_defineProperty(_state,"finalizeHistory",function(){state.setHistoryDuration(),state.normalizeTimeframes(),state.adjustTimeRecords("speaking"),state.setupForReset()}),_defineProperty(_state,"deleteTrackingArrays",function(){delete state.history.cellContentsTracking,delete state.history.cellOutputsTracking}),_defineProperty(_state,"getJSONHistory",function(){try{return JSON.stringify(state.history)}catch(ex){return}}),_defineProperty(_state,"getHistoryDuration",function(){return state.history.duration}),_defineProperty(_state,"setHistoryDuration",function(){state.history.duration=utils.getNow()-state.history.recordingStartTime}),_defineProperty(_state,"adjustTimeRecords",function(type){var historyArray=state.history[type];if(historyArray.length>0)for(var i=0;i<historyArray.length;++i)historyArray[i].startTime=Math.max(0,historyArray[i].startTime-100),historyArray[i].endTime=Math.max(0,historyArray[i].endTime-100)}),_defineProperty(_state,"findSpeakingStartNearestTime",function(t,direction,rewindAmt){var historyItem,numHistoryItems=0,chosenTime=-1===direction?0:state.history.duration;if(void 0!==state.history.speaking&&(numHistoryItems=state.history.speaking.length),0===numHistoryItems)chosenTime=-1===direction?Math.max(0,t-1e3*rewindAmt):Math.min(t+1e3*rewindAmt,state.history.duration-1);else for(var check=0;check<numHistoryItems;++check)historyItem=state.history.speaking[check],historyItem.speaking&&(-1===direction?historyItem.startTime>chosenTime&&historyItem.endTime<t&&(chosenTime=historyItem.startTime):historyItem.startTime<chosenTime&&historyItem.startTime>t&&(chosenTime=historyItem.startTime));return chosenTime}),_defineProperty(_state,"normalizeTimeframes",function(){var recordingStartTime=state.history.recordingStartTime,now=utils.getNow(),_iteratorNormalCompletion7=!0,_didIteratorError7=!1,_iteratorError7=void 0;try{for(var _step7,_iterator7=state.frameArrays[Symbol.iterator]();!(_iteratorNormalCompletion7=(_step7=_iterator7.next()).done);_iteratorNormalCompletion7=!0)for(var arrName=_step7.value,historyArray=state.history[arrName],max=historyArray.length-1,i=0;i<historyArray.length;++i)void 0===historyArray[i].endTime&&(1===historyArray.length||i===max?historyArray[i].endTime=now:historyArray[i].endTime=historyArray[i+1].startTime),historyArray[i].startTime=historyArray[i].startTime-recordingStartTime,historyArray[i].endTime=historyArray[i].endTime-recordingStartTime}catch(err){_didIteratorError7=!0,_iteratorError7=err}finally{try{_iteratorNormalCompletion7||null==_iterator7.return||_iterator7.return()}finally{if(_didIteratorError7)throw _iteratorError7}}}),_defineProperty(_state,"getHistoryRecordsAtTime",function(t){var frame,historyArray,arrName,scanPtr,scanDir,currentFrameIndex,previousFrameIndex,numRecords,indexes={},skipped={},historyDuration=state.getHistoryDuration(),halfHistory=historyDuration/2,_iteratorNormalCompletion8=!0,_didIteratorError8=!1,_iteratorError8=void 0;try{for(var _step8,_iterator8=state.frameArrays[Symbol.iterator]();!(_iteratorNormalCompletion8=(_step8=_iterator8.next()).done);_iteratorNormalCompletion8=!0)if(arrName=_step8.value,skipped[arrName]=-1,void 0!==(historyArray=state.history[arrName])&&(numRecords=historyArray.length,currentFrameIndex=state.history.lastVisited[arrName],indexes[arrName]=void 0,historyArray.length>0&&(t>=historyArray[0].startTime||t<=historyArray[historyArray.length-1].endTime)))if(previousFrameIndex=currentFrameIndex,frame=historyArray[currentFrameIndex],t>=frame.startTime&&t<frame.endTime)indexes[arrName]={index:currentFrameIndex,rangeStart:void 0};else{var tDist=t-frame.startTime,tDistAbs=Math.abs(tDist);for(tDistAbs/historyDuration<.1?(scanDir=Math.sign(tDist),scanPtr=currentFrameIndex+scanDir):t<halfHistory?(scanPtr=0,scanDir=1):(scanPtr=numRecords-1,scanDir=-1);scanPtr>=0&&scanPtr<numRecords;){if(frame=historyArray[scanPtr],t>=frame.startTime&&t<frame.endTime){indexes[arrName]={index:scanPtr,rangeStart:void 0},state.history.lastVisited[arrName]=scanPtr;break}scanPtr+=scanDir,skipped[arrName]++}void 0!==indexes[arrName]&&indexes[arrName].index!==previousFrameIndex&&indexes[arrName].index>previousFrameIndex&&(indexes[arrName].rangeStart=previousFrameIndex+1)}}catch(err){_didIteratorError8=!0,_iteratorError8=err}finally{try{_iteratorNormalCompletion8||null==_iterator8.return||_iterator8.return()}finally{if(_didIteratorError8)throw _iteratorError8}}return indexes}),_defineProperty(_state,"getIndexUpToTime",function(kind,t){var i,historyArray=state.history[kind];if(void 0!==historyArray){var historyArrayLength=historyArray.length;if(historyArrayLength>0){for(i=0;i<historyArrayLength;++i)if(historyArray[i].startTime>=t)return i;if(i=historyArray.length-1,historyArray[i].startTime<t&&historyArray[i].endTime>=t||historyArray[i].endTime<t)return i}}}),_defineProperty(_state,"getLastFrameIndex",function(kind){return state.history[kind].length}),_defineProperty(_state,"getHistoryItem",function(kind,index){if(index<state.history[kind].length&&index>=0)return state.history[kind][index]}),_defineProperty(_state,"setHistory",function(history){state.history=$.extend({},history),state.resetPlayState(),state.resetProcessedArrays()}),_defineProperty(_state,"getFromMovieCache",function(kind,keys){var combinedKey=[keys.recordingCellId,keys.recordingKey,keys.activeTakeId].join("_");return state.movieCache[kind][combinedKey]}),_defineProperty(_state,"storeToMovieCache",function(kind,keys,data){var combinedKey=[keys.recordingCellId,keys.recordingKey,keys.activeTakeId].join("_");state.movieCache[kind][combinedKey]=data}),_defineProperty(_state,"getTimeRecordedSoFar",function(){return utils.getNow()-state.history.recordingStartTime}),_defineProperty(_state,"getTimePlayedSoFar",function(){var now=utils.getNow(),timePlayedSoFar=0;if(void 0!==state.playTimes[state.currentPlaySpeed].start&&"playing"===state.activity){var playRateScalar=state.getPlayRateScalar();timePlayedSoFar+=(now-state.playTimes[state.currentPlaySpeed].start)*playRateScalar}for(var _i5=0,_Object$keys4=Object.keys(state.playSpeeds);_i5<_Object$keys4.length;_i5++){var type=_Object$keys4[_i5];timePlayedSoFar+=state.playTimes[type].total*state.playSpeeds[type]}return timePlayedSoFar}),_defineProperty(_state,"graffitiShouldUpdateCellContents",function(cellId){return state.shouldUpdateCellContentsDuringPlayback||state.history.affectedCellIds.hasOwnProperty(cellId)}),_defineProperty(_state,"storeCellStates",function(){state.cellsAffectedByActivity={},state.terminalsAffectedByActivity=[];var cells=Jupyter.notebook.get_cells();state.cellStates={contents:state.createContentsRecord(!1),selections:state.createSelectionsRecord(),changedCells:{},lineNumberStates:{}};for(var cell,i=0;i<cells.length;++i)cell=cells[i],state.cellStates.lineNumberStates[utils.getMetadataCellId(cell.metadata)]=cell.code_mirror.options.lineNumbers}),_defineProperty(_state,"storeCellIdAffectedByActivity",function(cellId){"playing"!==state.activity&&"recording"!==state.activity||(state.cellStates.changedCells[cellId]=!0)}),_defineProperty(_state,"restoreCellOutputs",function(cell,frameOutputs){var cellId=utils.getMetadataCellId(cell.metadata);return void 0!==frameOutputs&&((void 0===state.cellOutputsSent[cellId]||state.cellOutputsSent[cellId]!==frameOutputs)&&($(cell.element).find(".output").html(frameOutputs).show(),state.cellOutputsSent[cellId]=frameOutputs,!0))}),_defineProperty(_state,"restoreCellStates",function(which){var selections,cellContents,cellOutputs,affectedIds=Object.keys(state.cellStates.changedCells);if(affectedIds.length>0)for(var cell,cellsContent,contentsRecord,_i6=0,_affectedIds=affectedIds;_i6<_affectedIds.length;_i6++){var cellId=_affectedIds[_i6];cell=utils.findCellByCellId(cellId),void 0!==cell&&(selections=state.cellStates.selections.cellsSelections[cellId],"contents"===which?void 0!==(cellsContent=state.cellStates.contents.cellsContent[cellId])&&(contentsRecord=cellsContent.contentsRecord,cellContents=state.extractDataFromContentRecord(contentsRecord,cellId),void 0!==cellContents&&cell.set_text(contentsRecord.data),"function"==typeof cell.clear_output&&(cell.clear_output(),cellOutputs=state.extractDataFromContentRecord(cellsContent.outputsRecord,cellId),state.restoreCellOutputs(cell,cellOutputs))):void 0!==selections&&("code"===cell.cell_type&&selections.active&&cell.code_mirror.focus(),
cell.code_mirror.setSelections(selections.selections)))}}),_defineProperty(_state,"restoreLineNumbersStates",function(){if(state.hasOwnProperty("cellStates")&&state.cellStates.hasOwnProperty("lineNumberStates")&&Object.keys(state.cellStates.lineNumberStates).length>0)for(var cell,_i7=0,_Object$keys5=Object.keys(state.cellStates.lineNumberStates);_i7<_Object$keys5.length;_i7++){var cellId=_Object$keys5[_i7];cell=utils.findCellByCellId(cellId),void 0!==cell&&cell.code_mirror.options.lineNumbers!=state.cellStates.lineNumberStates[cellId]&&cell.toggle_line_numbers()}}),_defineProperty(_state,"getScrollTop",function(){return state.scrollTop}),_defineProperty(_state,"setScrollTop",function(scrollTop){state.scrollTop=scrollTop}),_state);return state}),define("js/hark.js",[],function(){var hark={running:!1,getMaxVolume:function(analyser,fftBins){var maxVolume=-1/0;analyser.getFloatFrequencyData(fftBins);for(var i=4,ii=fftBins.length;i<ii;i++)fftBins[i]>maxVolume&&fftBins[i]<0&&(maxVolume=fftBins[i]);return maxVolume},on:function(event,callback){hark.events[event]=callback},emit:function(arg1,arg2,arg3,arg4){hark.events[arg1]&&hark.events[arg1](arg2,arg3,arg4)},looper:function(){var interval=hark.speaking?hark.talkingInterval:hark.silenceInterval;setTimeout(function(){if(hark.running){var currentVolume=hark.getMaxVolume(hark.analyser,hark.fftBins);hark.emit("volume_change",currentVolume,hark.threshold);var history=0;if(currentVolume>hark.threshold&&!hark.speaking){for(var i=hark.speakingHistory.length-3;i<hark.speakingHistory.length;i++)history+=hark.speakingHistory[i];history>=2&&(hark.speaking=!0,hark.emit("speaking"))}else if(currentVolume<hark.threshold&&hark.speaking){for(var j=0;j<hark.speakingHistory.length;j++)history+=hark.speakingHistory[j];0===history&&(hark.speaking=!1,hark.emit("stopped_speaking"))}hark.speakingHistory.shift(),hark.speakingHistory.push(0+(currentVolume>hark.threshold)),hark.looper()}},interval)},setThreshold:function(t){hark.threshold=t},setIntervals:function(silenceInterval,talkingInterval){hark.silenceInterval=silenceInterval,hark.talkingInterval=talkingInterval},start:function(){hark.running=!0,hark.looper()},stop:function(){hark.running=!1,hark.emit("volume_change",-100,hark.threshold),hark.speaking&&(hark.speaking=!1,hark.emit("stopped_speaking"))},init:function(stream,options){var audioContextType=window.webkitAudioContext||window.AudioContext;if(hark.events={},!audioContextType)return hark;options=options||{};var smoothing=options.smoothing||.1;hark.play=options.play,hark.historySize=options.historySize||10,hark.silenceInterval=options.silenceInterval||10,hark.talkingInterval=options.talkingInterval||100,hark.threshold=options.threshold||-50,window.audioContext00||(window.audioContext00=new audioContextType);var gainNode=audioContext00.createGain();gainNode.connect(audioContext00.destination),gainNode.gain.value=0,hark.analyser=audioContext00.createAnalyser(),hark.analyser.fftSize=512,hark.analyser.smoothingTimeConstant=smoothing,hark.fftBins=new Float32Array(hark.analyser.fftSize),audioContext00.createMediaStreamSource(stream).connect(hark.analyser),hark.play&&hark.analyser.connect(audioContext00.destination),hark.speaking=!1,hark.speakingHistory=[];for(var i=0;i<hark.historySize;i++)hark.speakingHistory.push(0)}};return hark}),define("js/audio.js",["js/state.js","js/hark.js"],function(state,hark){var audio={init:function(cbs){console.log("Graffiti audio constructor."),audio.executeCallback=!0,navigator.getUserMedia=navigator.getUserMedia||navigator.webkitGetUserMedia||navigator.mozGetUserMedia||navigator.msGetUserMedia,navigator.getUserMedia?navigator.getUserMedia({audio:!0,mimeType:"audio/wav"},function(stream){var mediaRecorder=new MediaRecorder(stream);mediaRecorder.ondataavailable=audio.saveRecordedAudio,audio.storeMediaRecorder(mediaRecorder),cbs.succeed(),hark.init(stream,{threshold:-65}),hark.on("speaking",function(){state.setSpeakingStatus(!0)}),hark.on("stopped_speaking",function(){state.setSpeakingStatus(!1)})},function(err){console.log("Graffiti: The following getUserMedia error occured: "+err),cbs.fail()}):console.log("Graffiti: getUserMedia not supported on your browser!")},storeMediaRecorder:function(mediaRecorder){return audio.mediaRecorder=mediaRecorder,console.log("Graffiti: Media recorder ready and stored."),!0},isAvailable:function(){return void 0!==audio.mediaRecorder},storeAudio:function(audioObj){audio.audioObj=audioObj},updateAudioPlaybackRate:function(){var scalar=state.getPlayRateScalar();void 0!==audio.audioObj&&(audio.audioObj.playbackRate=scalar)},playAudio:function(elapsedTime){try{audio.setAudioPosition(elapsedTime)}catch(ex){console.warn("Graffiti: unable to set audio position with elapsedTime:",elapsedTime,"ex:",ex)}audio.updateAudioPlaybackRate();var playPromise=audio.audioObj.play();void 0!==playPromise&&playPromise.then(function(_){audio.playBeganOK=!0}).catch(function(error){audio.playBeganOK=!1,console.log("Graffiti: audio error:",error)})},pauseAudio:function(){audio.playBeganOK?audio.audioObj.pause():(console.log("Graffiti: cannot pause audio because audio playback did not begin successfully."),setTimeout(function(){audio.playBeganOK&&audio.audioObj.pause()},1e3))},setAudioPosition:function(elapsedTime){audio.audioObj.currentTime=elapsedTime/1e3},storeRecordedAudio:function(base64String){audio.recordedAudioString=base64String},getRecordedAudio:function(){return audio.recordedAudioString||""},setRecordedAudio:function(b64String){var labeledAudio="data:video/webm;base64,"+b64String,audioObj=new Audio(labeledAudio);audioObj.load(),audio.storeAudio(audioObj)},setAudioStorageCallback:function(cb){audio.audioStorageCallback=cb},startRecording:function(){void 0!==audio.mediaRecorder?(audio.mediaRecorder.start(),hark.start(),console.log("Graffiti:",audio.mediaRecorder.state),console.log("Graffiti: Audio recording started")):console.log("Graffiti: Audio recording cannot start, access not granted.")},stopRecording:function(){void 0!==audio.mediaRecorder?(audio.mediaRecorder.stop(),hark.stop(),console.log("Graffiti: Audio recording stopped")):console.log("Graffiti: Audio recording cannot stop, access not granted.")},startPlayback:function(elapsedTime){audio.playAudio(elapsedTime)},pausePlayback:function(){audio.pauseAudio()},setExecuteCallback:function(value){audio.executeCallback=value},saveRecordedAudio:function(e){var reader=new FileReader;reader.addEventListener("loadend",function(){var bufferArray=reader.result,base64String=btoa([].reduce.call(new Uint8Array(bufferArray),function(p,c){return p+String.fromCharCode(c)},""));audio.storeRecordedAudio(base64String),audio.executeCallback&&audio.audioStorageCallback()}),reader.readAsArrayBuffer(e.data);var audioUrl=window.URL.createObjectURL(e.data),audioObj=new Audio(audioUrl);audioObj.load(),audio.storeAudio(audioObj)},b64toBlob:function(b64Data,contentType,sliceSize){contentType=contentType||"",sliceSize=sliceSize||512;for(var byteCharacters=atob(b64Data),byteArrays=[],offset=0;offset<byteCharacters.length;offset+=sliceSize){for(var slice=byteCharacters.slice(offset,offset+sliceSize),byteNumbers=new Array(slice.length),i=0;i<slice.length;i++)byteNumbers[i]=slice.charCodeAt(i);var byteArray=new Uint8Array(byteNumbers);byteArrays.push(byteArray)}return new Blob(byteArrays,{type:contentType})}};return audio}),define("js/batchRunner.js",["js/state.js"],function(state){var batchRunner={output:function(ostr){},batch:function(pstart,atonce,pos){if(pos>=batchRunner.data.length)return pstart;var p=pstart.then(function(){var batchNum=pos/atonce+1;return batchRunner.output("Graffiti: batchRunner running batch "+batchNum),Promise.all(batchRunner.data.slice(pos,pos+atonce).map(function(data){return batchRunner.runner(data)}))});return batchRunner.batch(p,atonce,pos+atonce)},runner:function(data){return batchRunner.callback(data)},start:function(batchSize,callback,data){return batchRunner.data=data,batchRunner.callback=callback,batchRunner.batch(Promise.resolve(),batchSize,0)}};return batchRunner}),define("js/storage.js",["js/state.js","js/audio.js","js/utils.js","js/batchRunner.js","js/LZString.js"],function(state,audio,utils,batchRunner,LZString){var storage={defaultKernel:"python3",executorCell:void 0,movieCompleteCallback:void 0,preloadBatchSize:4,getOSMkdirCommand:function(path){var returnVal;if(utils.onWindowsOS()){var winPath='"'+path.replace(/\//g,"\\")+'"';returnVal="if not exist "+winPath+" ( md "+winPath+")"}else returnVal='mkdir -p "'+path+'"';return console.log("Graffiti: getOSMkdirCommand, returnVal:",returnVal),returnVal},getOSRmCommand:function(path,isFile){var returnVal;if(utils.onWindowsOS()){var winPath='"'+path.replace(/\//g,"\\")+'"';returnVal="rmdir /s/q "+winPath,isFile&&(returnVal="del "+winPath)}else returnVal='rm -r "'+path+'"';return console.log("Graffiti: getOSRmCommand, returnVal:",returnVal),returnVal},createExecutorCell:function(){return void 0===storage.executorCell&&(storage.executorCell=Jupyter.notebook.insert_cell_at_bottom("code"),state.storePreviousActivity(),state.setActivity("executing")),storage.executorCell},runShellCommand:function(cmd){var fullCommand,executorCell=storage.createExecutorCell(),currentKernelName=Jupyter.notebook.kernel.name;fullCommand=currentKernelName===utils.rKernel?"system('"+cmd+"', intern=TRUE)":"!"+cmd,executorCell.set_text(fullCommand),executorCell.execute()},writeTextToFile:function(opts){var writeMagic,chunkSize,path=opts.path,contents=opts.contents,executorCell=storage.createExecutorCell(),currentKernelName=Jupyter.notebook.kernel.name;switch(currentKernelName){case utils.cplusplusKernel11:case utils.cplusplusKernel14:case utils.cplusplusKernel17:writeMagic="%%file",chunkSize=7e3;break;case utils.pythonKernel:writeMagic="%%writefile",chunkSize=1e5;break;case utils.rKernel:}for(var chunk,appendFlag,cmd,contentLength=contents.length,chunkPtr=0,rLines=[],pathWithCrs=path+".cr";chunkPtr<contentLength;)chunk=contents.substr(chunkPtr,chunkSize),appendFlag=0===chunkPtr?" ":" -a ",currentKernelName===utils.rKernel?rLines.push('"'+chunk+'"'):(cmd=writeMagic+appendFlag+pathWithCrs+"\n"+chunk,executorCell.set_text(cmd),executorCell.execute()),chunkPtr+=chunkSize;currentKernelName===utils.rKernel&&(cmd="writeLines(c("+rLines.join(",")+'), "'+pathWithCrs+'")',executorCell.set_text(cmd),executorCell.execute());var secondaryCmd;if(opts.stripCRs)if(utils.onWindowsOS()){var winPath=path.replace(/\//g,"\\"),winPathWithCrs=pathWithCrs.replace(/\//g,"\\");cmd="python -c \"import os;s=open('"+pathWithCrs+"','r').read();open('"+pathWithCrs+"', 'w').write(s.replace('\\n',''))\"",secondaryCmd='copy "'+winPathWithCrs+'" "'+winPath+'"'}else cmd='/usr/bin/tr -d "\\n" < "'+pathWithCrs+'" > "'+path+'"';else cmd='mv "'+pathWithCrs+'" "'+path+'"';storage.runShellCommand(cmd),void 0!==secondaryCmd&&storage.runShellCommand(secondaryCmd),storage.runShellCommand(storage.getOSRmCommand(pathWithCrs,!0))},cleanUpExecutorCell:function(){var executorCell=storage.createExecutorCell();if(void 0!==executorCell){var executorCellId=utils.getMetadataCellId(executorCell.metadata),deleteCellIndex=utils.findCellIndexByCellId(executorCellId);void 0!==deleteCellIndex&&Jupyter.notebook.delete_cell(deleteCellIndex),storage.executorCell=void 0,state.restorePreviousActivity(),utils.saveNotebookDebounced()}},setMovieCompleteCallback:function(cb){storage.movieCompleteCallback=cb},executeMovieCompleteCallback:function(){void 0!==storage.movieCompleteCallback&&(storage.movieCompleteCallback(),storage.movieCompleteCallback=void 0)},ensureNotebookGetsGraffitiId:function(){var notebook=Jupyter.notebook;notebook.metadata.hasOwnProperty("graffiti")||(notebook.metadata.graffiti={id:utils.generateUniqueId(),language:"EN"}),utils.assignCellIds(),utils.refreshCellMaps(),console.log("Graffiti: Notebook is now ready to use Graffiti.")},ensureNotebookGetsFirstAuthorId:function(){var firstAuthorId,notebook=Jupyter.notebook,metadata=notebook.metadata;return metadata.hasOwnProperty("graffiti")||storage.ensureNotebookGetsGraffitiId(),metadata.graffiti.hasOwnProperty("firstAuthorId")?firstAuthorId=metadata.graffiti.firstAuthorId:(firstAuthorId=state.getUserId(),metadata.graffiti.firstAuthorId=firstAuthorId,state.setAuthorId(firstAuthorId)),firstAuthorId},constructBasePath:function(){var notebook=Jupyter.notebook;notebook.metadata.hasOwnProperty("graffiti")||storage.ensureNotebookGetsGraffitiId();var dataDir=utils.getNotebookGraffitiConfigEntry("dataDir");return void 0===dataDir?dataDir="jupytergraffiti_data/":"/"!==dataDir[dataDir.length-1]&&(dataDir+="/"),dataDir+"notebooks/"+notebook.metadata.graffiti.id+"/authors/"+state.getAuthorId()+"/"},constructManifestPath:function(){return{path:storage.constructBasePath(),file:"manifest.json"}},constructGraffitiMoviePath:function(pathParts){return storage.constructBasePath()+"cells/"+pathParts.recordingCellId+"/graffitis/"+pathParts.recordingKey+"/"},constructGraffitiTakePath:function(pathParts){return storage.constructGraffitiMoviePath(pathParts)+"takes/"+pathParts.takeId+"/"},completeMovieStorage:function(){var recordingCellInfo=state.getRecordingCellInfo(),recording=state.getManifestSingleRecording(recordingCellInfo.recordingCellId,recordingCellInfo.recordingKey),hasMovie=state.getMovieRecordingStarted();void 0!==recording&&(recording.inProgress=!1,recording.hasMovie=hasMovie),hasMovie&&(recording.activeTakeId=recordingCellInfo.recordingRecord.activeTakeId,recording.hasOwnProperty("takes")||(recording.takes={}),recording.takes[recording.activeTakeId]={duration:state.getHistoryDuration(),createDate:utils.getNow()}),state.setMovieRecordingStarted(!1),console.log("Graffiti: completeMovieStorage is saving manifest for recording:",recording,", current kernel",Jupyter.notebook.kernel.name),storage.storeManifest(),utils.queueSaveNotebookCallback(function(){storage.executeMovieCompleteCallback()}),utils.saveNotebookDebounced()},writeOutMovieData:function(movieInfo,jsonHistory,encodedAudio){var graffitiPath=storage.constructGraffitiTakePath({recordingCellId:movieInfo.recordingCellId,recordingKey:movieInfo.recordingKey,takeId:movieInfo.activeTakeId});if(storage.runShellCommand(storage.getOSMkdirCommand(graffitiPath)),void 0!==encodedAudio&&storage.writeTextToFile({path:graffitiPath+"audio.txt",contents:encodedAudio,stripCRs:!0}),void 0!==jsonHistory){var base64CompressedHistory=LZString.compressToBase64(jsonHistory);storage.writeTextToFile({path:graffitiPath+"history.txt",contents:base64CompressedHistory,stripCRs:!0})}return storage.cleanUpExecutorCell(graffitiPath),Promise.resolve()},storeMovie:function(){var recordingCellInfo=state.getRecordingCellInfo(),jsonHistory=(Jupyter.notebook,state.getJSONHistory());if(void 0!==jsonHistory){var encodedAudio=audio.getRecordedAudio(),keys={recordingCellId:recordingCellInfo.recordingCellId,recordingKey:recordingCellInfo.recordingKey,activeTakeId:recordingCellInfo.recordingRecord.activeTakeId};storage.writeOutMovieData(keys,jsonHistory,encodedAudio).then(function(){storage.completeMovieStorage()})}else console.log("Graffiti: could not fetch JSON history.")},loadManifest:function(currentAccessLevel){if(!Jupyter.notebook.metadata.hasOwnProperty("graffiti")){if("create"!==currentAccessLevel)return console.log('Graffiti: loadManifest is bailing early because we are not in "create" mode and this notebook has no graffiti id.'),Promise.reject();storage.ensureNotebookGetsGraffitiId()}var authorId=storage.ensureNotebookGetsFirstAuthorId();state.setAuthorId(authorId);var credentials={credentials:"include"},manifestInfo=storage.constructManifestPath();console.log("Graffiti: Loading manifest from:",manifestInfo);var manifestFullFilePath=manifestInfo.path+manifestInfo.file;return fetch(manifestFullFilePath,credentials).then(function(response){if(response.ok)return response.text()}).then(function(base64Str){if(void 0===base64Str)state.setManifest({});else{var uncompressedManifestString=LZString.decompressFromBase64(base64Str),manifestDataParsed=JSON.parse(uncompressedManifestString);state.setManifest(manifestDataParsed)}})},updateSingleManifestRecordingField:function(recordingCellId,recordingKey,field,data){state.getManifestSingleRecording(recordingCellId,recordingKey)[field]=data,storage.storeManifest()},storeManifest:function(){var manifest=state.getManifest(),manifestInfo=storage.constructManifestPath(),base64CompressedManifest=LZString.compressToBase64(JSON.stringify(manifest)),manifestFullFilePath=manifestInfo.path+manifestInfo.file;console.log("Graffiti: Saving manifest to:",manifestFullFilePath,manifest),storage.runShellCommand(storage.getOSMkdirCommand(manifestInfo.path)),storage.writeTextToFile({path:manifestFullFilePath,contents:base64CompressedManifest,stripCRs:!0}),storage.cleanUpExecutorCell()},computeAffectedCells:function(history){history.affectedCellIds={};var i;for(i=1;i<history.contents.length;++i)Object.keys(history.contents[i]).map(function(key){void 0!==history.contents[i][key].data&&(history.affectedCellIds[key]=!0)});history.view.map(function(viewRec){"focus"===viewRec.subType||"innerScroll"===viewRec.subType?history.affectedCellIds[viewRec.cellId]=!0:"selectCell"===viewRec.subType&&(history.affectedCellIds[viewRec.selectedCellId]=!0)}),history.drawings.map(function(drawRec){history.affectedCellIds[drawRec.cellId]=!0}),Object.keys(history.cellAdditions).map(function(key){history.affectedCellIds[key]=!0})},fetchMovie:function(data){var graffitiPath=(Jupyter.notebook.metadata.graffiti.id,storage.constructGraffitiTakePath({recordingCellId:data.recordingCellId,recordingKey:data.recordingKey,takeId:data.activeTakeId})),credentials={credentials:"include"};storage.successfulLoad=!1;var historyUrl=graffitiPath+"history.txt";return fetch(historyUrl,credentials).then(function(response){if(!response.ok)throw Error(response.statusText);return response.text()}).then(function(base64CompressedHistory){try{var uncompressedHistory=LZString.decompressFromBase64(base64CompressedHistory),parsedHistory=JSON.parse(uncompressedHistory);storage.computeAffectedCells(parsedHistory);var audioUrl=graffitiPath+"audio.txt";return fetch(audioUrl,{credentials:"include"}).then(function(response){if(!response.ok)throw Error(response.statusText);return response.text()}).then(function(base64CompressedAudio){try{return state.storeToMovieCache("history",data,parsedHistory),state.storeToMovieCache("audio",data,base64CompressedAudio),storage.successfulLoad=!0,{history:parsedHistory,audio:base64CompressedAudio}}catch(ex){return console.log("Graffiti: Could not parse saved audio, ex:",ex),Promise.reject("Could not parse saved audio, ex :"+ex)}})}catch(ex){return console.log("Graffiti: Could not parse previous history, ex :",ex),Promise.reject("Could not parse previous history, ex :"+ex)}}).catch(function(ex){return console.log("Graffiti: Could not fetch history file for history at",historyUrl),Promise.reject("Could not fetch history file")})},preloadAllMovies:function(){for(var dataRecord,recordingCellId,recordingKeys,recording,allRecords=[],manifest=state.getManifest(),_i=0,_Object$keys=Object.keys(manifest);_i<_Object$keys.length;_i++)if(recordingCellId=_Object$keys[_i],recordingKeys=Object.keys(manifest[recordingCellId]),recordingKeys.length>0){var _iteratorNormalCompletion=!0,_didIteratorError=!1,_iteratorError=void 0;try{for(var _step,_iterator=recordingKeys[Symbol.iterator]();!(_iteratorNormalCompletion=(_step=_iterator.next()).done);_iteratorNormalCompletion=!0)recordingKey=_step.value,recording=state.getManifestSingleRecording(recordingCellId,recordingKey),void 0!==recording.activeTakeId&&(dataRecord={recordingCellId:recordingCellId,recordingKey:recordingKey,activeTakeId:recording.activeTakeId},allRecords.push(dataRecord))}catch(err){_didIteratorError=!0,_iteratorError=err}finally{try{_iteratorNormalCompletion||null==_iterator.return||_iterator.return()}finally{if(_didIteratorError)throw _iteratorError}}}var callback=function(data){return storage.fetchMovie(data).catch(function(err){console.log("Graffiti: Could not fetch movie:",data)})};return batchRunner.start(storage.preloadBatchSize,callback,allRecords).then(function(){console.log("Graffiti: preloading completed."),state.refreshCellIdToGraffitiMap()})},deleteMovie:function(recordingCellId,recordingKey){var graffitiPath=storage.constructGraffitiMoviePath({recordingCellId:recordingCellId,recordingKey:recordingKey});storage.runShellCommand(storage.getOSRmCommand(graffitiPath,!1)),storage.cleanUpExecutorCell()},transferGraffiti:function(){var originalGraffitiId,notebook=Jupyter.notebook;return notebook.metadata.hasOwnProperty("graffiti")&&(originalGraffitiId=$.extend(!0,{},notebook.metadata.graffiti),delete notebook.metadata.graffiti),storage.ensureNotebookGetsGraffitiId(),storage.ensureNotebookGetsFirstAuthorId(),utils.queueSaveNotebookCallback(function(){var newGraffitiId=notebook.metadata.graffiti.id,sourceTree="jupytergraffiti_data/notebooks/"+originalGraffitiId,destTree="jupytergraffiti_data/notebooks/"+newGraffitiId;storage.runShellCommand("cp -pr "+sourceTree+" "+destTree),storage.cleanUpExecutorCell()}),utils.saveNotebookDebounced(),Promise.resolve()},packageGraffiti:function(){var notebook=Jupyter.notebook,notebookName=notebook.get_notebook_name(),archiveName="graffiti_archive_"+utils.generateUniqueId().replace("id_","")+".tgz",tarCmd="tar zcf "+archiveName+' "'+notebookName+'.ipynb" jupytergraffiti_data';return storage.runShellCommand(tarCmd),storage.cleanUpExecutorCell(),Promise.resolve(archiveName)},removeGraffitiIds:function(){var cells=Jupyter.notebook.get_cells(),_iteratorNormalCompletion2=!0,_didIteratorError2=!1,_iteratorError2=void 0;try{for(var _step2,_iterator2=cells[Symbol.iterator]();!(_iteratorNormalCompletion2=(_step2=_iterator2.next()).done);_iteratorNormalCompletion2=!0){var cell=_step2.value;cell.metadata.hasOwnProperty("graffitiCellId")&&delete cell.metadata.graffitiCellId}}catch(err){_didIteratorError2=!0,_iteratorError2=err}finally{try{_iteratorNormalCompletion2||null==_iterator2.return||_iterator2.return()}finally{if(_didIteratorError2)throw _iteratorError2}}delete Jupyter.notebook.metadata.graffiti,utils.saveNotebookDebounced()},deleteDataDirectory:function(graffitiId){var notebookStoragePath="jupytergraffiti_data/notebooks/"+graffitiId;storage.runShellCommand(storage.getOSRmCommand(notebookStoragePath,!1)),storage.cleanUpExecutorCell()},removeUnusedTakesCore:function(recordingCellId,recordingKey){var recording=state.getManifestSingleRecording(recordingCellId,recordingKey),activeTakeId=recording.activeTakeId,deletedTakes=0;if(void 0!==recording.takes)for(var _i2=0,_Object$keys2=Object.keys(recording.takes);_i2<_Object$keys2.length;_i2++){var takeId=_Object$keys2[_i2];if(takeId!==activeTakeId){var graffitiTakePath=storage.constructGraffitiTakePath({recordingCellId:recordingCellId,recordingKey:recordingKey,takeId:takeId});storage.runShellCommand(storage.getOSRmCommand(graffitiTakePath,!1)),delete recording.takes[takeId],deletedTakes++}}return deletedTakes},removeUnusedTakes:function(recordingCellId,recordingKey){storage.removeUnusedTakesCore(recordingCellId,recordingKey)>0&&(storage.storeManifest(),storage.cleanUpExecutorCell(),utils.saveNotebookDebounced())},fetchDataFile:function(filePath){var nbDir=utils.getNotebookDirectory(),fullPath="/tree";void 0!==nbDir&&(fullPath+="/"+nbDir),fullPath+="/"+filePath;var reworkedFullPath=utils.reworkFetchPathForVirtualHosts(fullPath);return fetch(reworkedFullPath,{credentials:"include"}).then(function(response){if(!response.ok)throw Error(response.statusText);return response.text()}).catch(function(ex){return console.log("Graffiti: could not fetch data file at :",filePath),Promise.reject("Could not fetch data file at :"+filePath)})}};return storage}),define("js/sticker.js",["js/utils.js"],function(utils){var sticker={interpretDashing:function(opts,obj){void 0!==opts.dashed&&"dashed"===opts.dashed&&(opts.dashWidth?obj["stroke-dasharray"]=opts.dashWidth:obj["stroke-dasharray"]=4)},generateArrowHeadElem:function(arrowHeadColor,arrowHeadSize){var arrowHeadId="arrowHead-"+utils.generateUniqueId(),defs=document.createElementNS("http://www.w3.org/2000/svg","defs"),marker=sticker.makeSvgElement("marker",{id:arrowHeadId,viewBox:"0 0 10 10",refX:8.7,refY:3,markerUnits:"strokeWidth",markerWidth:arrowHeadSize,markerHeight:arrowHeadSize,orient:"auto",stroke:arrowHeadColor,fill:arrowHeadColor}),path=sticker.makeSvgElement("path",{d:"M 0,0 L0,6 L9,3 z"});return marker.appendChild(path),defs.appendChild(marker),{arrowHeadId:arrowHeadId,defs:defs}},makeElementHtml:function(tag,attr,innerHtml){var elementHtml="<"+tag+" ";"svg"===tag&&(elementHtml+='xmlns="http://www.w3.org/2000/svg" version="1.1" class="graffitiSvg" ');var attrHtml="";return void 0!==attr&&(attrHtml=$.map(attr,function(val,key){return key+'="'+val+'"'}).join(" ")),elementHtml+=void 0!==innerHtml?attrHtml+">"+innerHtml+"</"+tag+">":attrHtml+"></"+tag+">"},makeSvgElement:function(tag,attrs){var el=document.createElementNS("http://www.w3.org/2000/svg",tag);"svg"===tag&&(el.setAttribute("xmlns","http://www.w3.org/2000/svg"),el.setAttribute("version","1.1"),el.setAttribute("preserveAspectRatio","none"));for(var k in attrs)el.setAttribute(k,attrs[k]);return void 0!==attrs.text&&(el.textContent=attrs.text),el},makeDomElement:function(tag,attrs){var el=document.createElement(tag);for(var k in attrs)el.setAttribute(k,attrs[k]);return el},renderSvg:function(svgChildren,x,y,width,height,viewBox,arrowHeadRecord){var containerDiv,containerSticker,containerDivParams,metaParts,svgGenerator=$("#graffitiSvgGenerator");0===svgGenerator.length&&($("body").append($('<div id="graffitiSvgGenerator"></div>')),svgGenerator=$("#graffitiSvgGenerator"));var _iteratorNormalCompletion=!0,_didIteratorError=!1,_iteratorError=void 0;try{for(var _step,_iterator=svgChildren[Symbol.iterator]();!(_iteratorNormalCompletion=(_step=_iterator.next()).done);_iteratorNormalCompletion=!0){var svgChild=_step.value,transform="";svgChild.hasOwnProperty("cssTransform")&&(transform="transform:"+svgChild.cssTransform);var backgroundColor="";svgChild.hasOwnProperty("backgroundColor")&&(backgroundColor="background:"+svgChild.backgroundColor+";");var border="";svgChild.hasOwnProperty("border")&&(border="border:"+svgChild.border+";"),containerDivParams={class:svgChild.outerClass,style:"position:absolute;left:"+parseInt(svgChild.x)+"px;top:"+parseInt(svgChild.y)+"px;width:"+parseInt(svgChild.width)+"px;height:"+parseInt(svgChild.height)+"px;"+transform+backgroundColor+border},svgChild.hasOwnProperty("title")&&(containerDivParams.title=svgChild.title),svgChild.hasOwnProperty("metaTag")&&(metaParts=svgChild.metaTag.split("|"),containerDivParams[metaParts[0]]=metaParts[1]),containerDiv=sticker.makeDomElement("div",containerDivParams),containerSticker=sticker.makeSvgElement("svg",{width:svgChild.width,height:svgChild.height,viewBox:svgChild.viewBox}),svgChild.usesArrow&&containerSticker.appendChild(svgChild.arrowHeadRecord.defs),containerSticker.appendChild(svgChild.el),containerDiv.appendChild(containerSticker),svgGenerator[0].appendChild(containerDiv)}}catch(err){_didIteratorError=!0,_iteratorError=err}finally{try{_iteratorNormalCompletion||null==_iterator.return||_iterator.return()}finally{if(_didIteratorError)throw _iteratorError}}var containerHtml=svgGenerator[0].innerHTML;return svgGenerator.empty(),containerHtml},makeLine:function(opts){var coordSpaceEndpoints,endpoints=opts.endpoints,p1=endpoints.p1,p2=endpoints.p2,bbox={p1:{x:Math.min(p1.x,p2.x),y:Math.min(p1.y,p2.y)},p2:{x:Math.max(p1.x,p2.x),y:Math.max(p1.y,p2.y)}},color=void 0===opts.color?"#000":opts.color,strokeWidth=void 0===opts.strokeWidth?3:opts.strokeWidth;coordSpaceEndpoints=p2.x<p1.x&&p2.y<p1.y?{p1:{x:bbox.p2.x,y:bbox.p2.y},p2:{x:bbox.p1.x,y:bbox.p1.y}}:p2.x<p1.x?{p1:{x:bbox.p2.x,y:bbox.p1.y},p2:{x:bbox.p1.x,y:bbox.p2.y}}:p2.y<p1.y?{p1:{x:bbox.p1.x,y:bbox.p2.y},p2:{x:bbox.p2.x,y:bbox.p1.y}}:{p1:{x:bbox.p1.x,y:bbox.p1.y},p2:{x:bbox.p2.x,y:bbox.p2.y}};var finalCoordSpaceEndpoints={p1:{x:coordSpaceEndpoints.p1.x-bbox.p1.x,y:coordSpaceEndpoints.p1.y-bbox.p1.y},p2:{x:coordSpaceEndpoints.p2.x-bbox.p1.x,y:coordSpaceEndpoints.p2.y-bbox.p1.y}},pathPart="M "+finalCoordSpaceEndpoints.p1.x+" "+finalCoordSpaceEndpoints.p1.y+" L "+finalCoordSpaceEndpoints.p2.x+" "+finalCoordSpaceEndpoints.p2.y,pathObj={"vector-effect":"non-scaling-stroke","stroke-width":strokeWidth,stroke:color,fill:color,d:pathPart},arrowHeadRecord=void 0;void 0!==opts.usesArrow&&(arrowHeadRecord=sticker.generateArrowHeadElem(opts.color,opts.arrowHeadSize),pathObj["marker-end"]="url(#"+arrowHeadRecord.arrowHeadId+")"),sticker.interpretDashing(opts,pathObj);var line=sticker.makeSvgElement("path",pathObj),viewBox=[-10,-10,Math.max(20,Math.abs(bbox.p2.x-bbox.p1.x)+20),Math.max(20,Math.abs(bbox.p2.y-bbox.p1.y)+20)];return sticker.renderSvg([{el:line,x:bbox.p1.x+opts.lineStartOffset.x-10,y:bbox.p1.y+opts.lineStartOffset.y-10,width:viewBox[2],height:viewBox[3],color:color,viewBox:viewBox.join(" "),usesArrow:opts.usesArrow,arrowHeadRecord:arrowHeadRecord,arrowHeadSize:opts.arrowHeadSize}])},makeEllipse:function(opts){var dimensions=opts.dimensions,buffer=opts.buffer||4,viewBoxRaw="0 0 "+dimensions.width+" "+dimensions.height,viewBox=sticker.makeBufferedViewBox({buffer:buffer,bufferAllSides:!0,viewBox:viewBoxRaw}),shapeObj={cx:dimensions.width/2,cy:dimensions.height/2,rx:Math.max(0,dimensions.width/2-opts.buffer),ry:Math.max(0,dimensions.height/2-opts.buffer),stroke:opts.color,"stroke-width":opts.strokeWidth,"fill-opacity":opts.fillOpacity,fill:opts.color};sticker.interpretDashing(opts,shapeObj);var theEllipse=sticker.makeSvgElement("ellipse",shapeObj),parmBlock={el:theEllipse,x:dimensions.x,y:dimensions.y,width:dimensions.width,height:dimensions.height,viewBox:viewBox};return sticker.renderSvg([parmBlock])},makeBullsEye:function(opts){for(var shapeHash,shapeObj,dimensions=opts.dimensions,buffer=opts.buffer||4,viewBoxRaw="0 0 "+dimensions.width+" "+dimensions.height,viewBox=sticker.makeBufferedViewBox({buffer:buffer,bufferAllSides:!0,viewBox:viewBoxRaw}),parmBlocks=[],ringRadii=[1,5,9,13,17,3,7,11,15],innerRingsColor=void 0!==opts.innerRingsColor?opts.innerRingsColor:opts.color,strokes=[opts.color,opts.color,opts.color,opts.color,opts.color,innerRingsColor,innerRingsColor,innerRingsColor,innerRingsColor],fills=[opts.color,opts.color,opts.color,opts.color,opts.color,innerRingsColor,innerRingsColor,innerRingsColor,innerRingsColor],ringCtr=0;ringCtr<ringRadii.length;++ringCtr)shapeHash={cx:dimensions.width/2,cy:dimensions.height/2,rx:ringRadii[ringCtr],ry:ringRadii[ringCtr],stroke:strokes[ringCtr],"stroke-width":opts.strokeWidth,"fill-opacity":opts.fillOpacity,fill:fills[ringCtr]},shapeObj=sticker.makeSvgElement("ellipse",shapeHash),parmBlocks.push({el:shapeObj,x:dimensions.x,y:dimensions.y,width:dimensions.width,height:dimensions.height,viewBox:viewBox});return sticker.renderSvg(parmBlocks)},makeBufferedViewBox:function(opts){var bufferedViewBox,viewBox,doubleBuffer=2*opts.buffer;return viewBox="string"==typeof opts.viewBox?opts.viewBox.split(" "):opts.viewBox,bufferedViewBox=opts.bufferAllSides?[parseInt(viewBox[0])-opts.buffer,parseInt(viewBox[1])-opts.buffer,parseInt(viewBox[2])+doubleBuffer,parseInt(viewBox[3])+doubleBuffer]:[parseInt(viewBox[0]),parseInt(viewBox[1]),parseInt(viewBox[2])+doubleBuffer,parseInt(viewBox[3])+doubleBuffer],bufferedViewBox.join(" ")},makeSimplePath:function(opts){var pathObj,thePath,parmBlock,buffer=void 0===opts.buffer?4:opts.buffer,doubleBuffer=2*buffer,viewBox=sticker.makeBufferedViewBox({buffer:buffer,bufferAllSides:!0,viewBox:opts.viewBox}),color=void 0===opts.color?"#000":opts.color,strokeWidth=void 0===opts.strokeWidth?3:opts.strokeWidth,outerClass=void 0===opts.outerClass?"graffiti-sticker-inner":opts.outerClass,renderParms=[],_iteratorNormalCompletion2=!0,_didIteratorError2=!1,_iteratorError2=void 0;try{
for(var _step2,_iterator2=opts.d[Symbol.iterator]();!(_iteratorNormalCompletion2=(_step2=_iterator2.next()).done);_iteratorNormalCompletion2=!0){pathObj={"vector-effect":"non-scaling-stroke","stroke-width":strokeWidth,stroke:color,d:_step2.value},void 0!==opts.fill?pathObj.fill=opts.fill:pathObj["fill-opacity"]=0,void 0!==opts.transform&&(pathObj.transform=opts.transform),void 0!==opts.fillOpacity&&(pathObj["fill-opacity"]=opts.fillOpacity,pathObj.fill=opts.color),sticker.interpretDashing(opts,pathObj),thePath=sticker.makeSvgElement("path",pathObj),parmBlock={el:thePath,x:opts.dimensions.x-buffer,y:opts.dimensions.y-buffer,width:opts.dimensions.width+doubleBuffer,height:opts.dimensions.height+doubleBuffer,outerClass:outerClass,title:opts.title,viewBox:viewBox},void 0!==opts.cssTransform&&(parmBlock.cssTransform=opts.cssTransform),void 0!==opts.metaTag&&(parmBlock.metaTag=opts.metaTag),renderParms.push(parmBlock)}}catch(err){_didIteratorError2=!0,_iteratorError2=err}finally{try{_iteratorNormalCompletion2||null==_iterator2.return||_iterator2.return()}finally{if(_didIteratorError2)throw _iteratorError2}}return sticker.renderSvg(renderParms)},makeRightCurlyBracePath:function(opts){var _pathObj,pathObj=(_pathObj={stroke:opts.color,"stroke-width":opts.strokeWidth,"vector-effect":"non-scaling-stroke"},_defineProperty(_pathObj,"stroke-width","3"),_defineProperty(_pathObj,"fill-opacity",0),_defineProperty(_pathObj,"d","M0,0 A100, 173.20508075688772 0 0 1  100, 173.20508075688772 A100, 173.20508075688772 0 0 0 200 346.41016151377545 A100, 173.20508075688772 0 0 0 100, 519.6152422706632 A100, 173.20508075688772 0 0 1 0, 692.8203230275509"),_pathObj);return sticker.interpretDashing(opts,pathObj),sticker.makeSvgElement("path",pathObj)},makeLeftCurlyBrace:function(opts){var curlyBracePath=sticker.makeRightCurlyBracePath({dashed:opts.dashed,color:opts.color,strokeWidth:opts.strokeWidth});return sticker.renderSvg([{el:curlyBracePath,width:8,height:opts.dimensions.height,viewBox:"0 0 200 692",x:opts.dimensions.x,y:opts.dimensions.y,cssTransform:"scaleX(-1)"}])},makeRightCurlyBrace:function(opts){var curlyBracePath=sticker.makeRightCurlyBracePath({dashed:opts.dashed,color:opts.color,strokeWidth:opts.strokeWidth});return sticker.renderSvg([{el:curlyBracePath,width:8,height:opts.dimensions.height,viewBox:"0 0 200 692",x:opts.dimensions.x,y:opts.dimensions.y}])},makeSymmetricCurlyBraces:function(opts){var curlyBracePath1=sticker.makeRightCurlyBracePath({dashed:opts.dashed,color:opts.color,strokeWidth:opts.strokeWidth}),curlyBracePath2=sticker.makeRightCurlyBracePath({dashed:opts.dashed,color:opts.color,strokeWidth:opts.strokeWidth});return sticker.renderSvg([{el:curlyBracePath1,width:8,height:opts.dimensions.height,viewBox:"0 0 200 692",x:opts.dimensions.x-1,y:opts.dimensions.y,cssTransform:"scaleX(-1)"},{el:curlyBracePath2,width:8,height:opts.dimensions.height,viewBox:"0 0 200 692",x:opts.dimensions.x+opts.dimensions.width-8+1,y:opts.dimensions.y,dashed:opts.dashed,color:opts.color,strokeWidth:opts.strokeWidth}])},makeTopBracket:function(opts){var width=opts.dimensions.width,height=opts.dimensions.height;return sticker.makeSimplePath($.extend({},!0,opts,{buffer:0,viewBox:[0,0,width,height],d:["M 0 "+height+" L 0 0 L "+width+" 0 L "+width+" "+height]}))},makeBottomBracket:function(opts){var width=opts.dimensions.width,height=opts.dimensions.height;return sticker.makeSimplePath($.extend({},!0,opts,{viewBox:[0,0,width,height],d:["M 0 0 L 0 "+height+" L "+width+" "+height+" L "+width+"0"]}))},makeLeftBracket:function(opts){var width=opts.dimensions.width,height=opts.dimensions.height;return sticker.makeSimplePath($.extend({},!0,opts,{buffer:0,viewBox:[0,0,width,height],d:["M "+width+" "+height+" L 0 "+height+" L 0 0 L "+width+" 0"]}))},makeRightBracket:function(opts){var width=opts.dimensions.width,height=opts.dimensions.height;return sticker.makeSimplePath($.extend({},!0,opts,{buffer:0,viewBox:[0,0,width,height],d:["M 0 0 L "+width+" 0 L "+width+" "+height+" L 0 "+height]}))},makeHorizontalBrackets:function(opts){var width=opts.dimensions.width,height=opts.dimensions.height,bracketHeight1=Math.min(sticker.minBracketWidth,parseInt(height/10)),bracketHeight2=Math.max(height-sticker.minBracketWidth,height-parseInt(height/10));return sticker.makeSimplePath($.extend({},!0,opts,{buffer:0,viewBox:[0,0,width,height],d:["M 0 "+bracketHeight1+" L 0 0 L "+width+" 0 L "+width+" "+bracketHeight1,"M 0 "+bracketHeight2+" L 0 "+height+" L "+width+" "+height+" L "+width+" "+bracketHeight2]}))},makeVerticalBrackets:function(opts){var width=opts.dimensions.width,height=opts.dimensions.height,bracketWidth1=Math.min(sticker.minBracketWidth,parseInt(width/10)),bracketWidth2=Math.max(width-sticker.minBracketWidth,width-parseInt(width/10));return sticker.makeSimplePath($.extend({},!0,opts,{viewBox:[0,0,width,height],d:["M "+bracketWidth1+" 0 L 0 0 L 0 "+height+" L "+bracketWidth1+" "+height,"M "+bracketWidth2+" 0 L "+width+" 0 L "+width+" "+height+" L "+bracketWidth2+" "+height]}))},makeRectangle:function(opts){var dimensions=opts.dimensions,buffer=opts.buffer||4,viewBoxRaw="0 0 "+dimensions.width+" "+dimensions.height,viewBox=sticker.makeBufferedViewBox({buffer:buffer,bufferAllSides:!0,viewBox:viewBoxRaw}),shapeObj={x:0,y:0,width:dimensions.width,height:dimensions.height,stroke:opts.color,fill:opts.color,"stroke-width":opts.strokeWidth,"fill-opacity":opts.fillOpacity};sticker.interpretDashing(opts,shapeObj),void 0!==opts.rx&&(shapeObj.rx=opts.rx,shapeObj.ry=opts.ry);var theRect=sticker.makeSvgElement("rect",shapeObj),parmBlock={el:theRect,x:dimensions.x,y:dimensions.y,width:dimensions.width,height:dimensions.height,viewBox:viewBox};return sticker.renderSvg([parmBlock])},makeRightTriangle:function(opts){return sticker.makeSimplePath($.extend({},!0,opts,{viewBox:[0,0,100,125],d:["M 0 125 L 100 125 L 0 0 Z"]}))},makeIsocelesTriangle:function(opts){return sticker.makeSimplePath($.extend({},!0,opts,{viewBox:[0,0,100,125],d:["M 0 125 L 100 125 L 50 0 Z"]}))},makeTheta:function(opts){return sticker.makeSimplePath($.extend({},!0,opts,{viewBox:[0,0,469,700],d:["M469 334c-2,440 -453,468 -469,2 -13,-435 472,-460 469,-2zm-383 -20l298 0c-9,-366 -288,-376 -298,-6l0 6zm297 46l-297 0c16,345 279,397 297,11 0,-4 0,-7 0,-11z"],fill:opts.color}))},makeSigma:function(opts){return sticker.makeSimplePath($.extend({},!0,opts,{strokeWidth:2,viewBox:[0,0,16,16],d:["M2,1l5.46,7.27L2,15h12v-4h-1v1c0,0.552-0.448,1-1,1H4.97l4.39-5.52L5.25,2H12c0.552,0,1,0.448,1,1v1h1V1H2z"],fill:opts.color}))},makeSmiley:function(opts){return sticker.makeSimplePath($.extend({},!0,opts,{strokeWidth:2,viewBox:[0,0,49,49],d:["M25,1A24,24,0,1,0,49,25,24,24,0,0,0,25,1Zm0,46A22,22,0,1,1,47,25,22,22,0,0,1,25,47ZM35.77,33.32a1,1,0,0,1-.13,1.41C31.73,38,28.06,39.1,24.9,39.1a16,16,0,0,1-10.63-4.45,1,1,0,0,1,1.45-1.38c0.34,0.35,8.35,8.52,18.63-.08A1,1,0,0,1,35.77,33.32ZM15,19a3,3,0,1,1,3,3A3,3,0,0,1,15,19Zm14,0a3,3,0,1,1,3,3A3,3,0,0,1,29,19Z"],fill:opts.color}))},makeFrowney:function(opts){return sticker.makeSimplePath($.extend({},!0,opts,{strokeWidth:2,viewBox:[0,0,100,125],d:["M50,2.5C23.809,2.5,2.5,23.809,2.5,50S23.809,97.5,50,97.5S97.5,76.191,97.5,50S76.191,2.5,50,2.5z M50,91.684    C27.016,91.684,8.316,72.984,8.316,50S27.016,8.316,50,8.316S91.684,27.016,91.684,50S72.984,91.684,50,91.684z M37.489,41.386    c2.964,0,5.369-2.403,5.369-5.369c0-2.966-2.405-5.368-5.369-5.368c-2.966,0-5.369,2.402-5.369,5.368    C32.12,38.982,34.523,41.386,37.489,41.386z M62.511,41.386c2.965,0,5.369-2.403,5.369-5.369c0-2.966-2.404-5.368-5.369-5.368    c-2.966,0-5.368,2.402-5.368,5.368C57.143,38.982,59.545,41.386,62.511,41.386z M50.001,51.186    c-13.939,0-20.525,9.548-22.06,14.597c-0.467,1.537,0.399,3.161,1.936,3.628c1.539,0.471,3.161-0.399,3.628-1.936    c0.032-0.105,3.336-10.473,16.496-10.473c13.015,0,16.363,10.061,16.494,10.472c0.381,1.255,1.534,2.063,2.781,2.063    c0.28,0,0.564-0.04,0.846-0.127c1.538-0.467,2.405-2.091,1.938-3.627C70.524,60.733,63.939,51.186,50.001,51.186z"]}))},makeThumbsUp:function(opts){return sticker.makeSimplePath($.extend({},!0,opts,{strokeWidth:2,viewBox:[0,0,218,346.25],d:["M28 263l31 -9c64,42 77,13 92,10 4,0 1,4 17,0 22,-7 31,-19 23,-35 19,-6 21,-18 15,-33 15,-9 15,-26 3,-38 19,-37 -11,-67 -80,-48 -5,-36 11,-59 5,-80 -7,-27 -25,-31 -50,-30 3,68 8,35 -25,101 -27,55 -3,48 -57,63 -6,36 4,70 26,99zm4 -12c-16,-24 -23,-49 -21,-77 48,-14 33,-15 57,-65 33,-71 31,-34 27,-97 31,1 32,26 26,50 -7,27 -6,40 -1,62 26,-7 74,-21 82,6 7,27 -22,40 -35,41l-42 -7c9,-28 36,-19 44,-19l10 -3 7 -13c-29,8 -10,3 -31,4 -24,1 -40,15 -43,40l8 1c-8,7 -13,16 -14,28l9 1c-5,6 -10,15 -12,26l14 3c-5,7 -9,15 -11,26l29 4c-29,10 -50,-1 -74,-20l-29 9zm87 -58c12,-30 27,-10 49,-12 5,0 27,-7 33,-14 24,20 -36,32 -39,33l-43 -7zm-2 27l10 -15c44,7 28,8 70,-4 10,19 -35,26 -35,26l-45 -7zm3 30l9 -17c36,5 26,7 53,0 4,16 -17,22 -23,22l-39 -5z"],fill:opts.color}))},makeThumbsDown:function(opts){return sticker.makeSimplePath($.extend({},!0,opts,{strokeWidth:2,viewBox:[0,0,226,357.5],d:["M18 27l33 4c59,-51 77,-23 92,-23 5,0 0,-4 18,-2 23,3 33,15 28,32 20,4 24,15 20,32 17,7 19,23 8,37 25,36 -1,70 -74,60 0,38 19,59 16,82 -3,27 -21,34 -46,37 -6,-70 3,-37 -40,-99 -35,-52 -10,-48 -67,-56 -11,-36 -6,-71 12,-104zm6 12c-13,26 -16,53 -10,81 51,7 35,11 67,58 44,66 36,29 41,95 32,-7 29,-32 19,-55 -11,-27 -11,-40 -9,-63 27,4 78,10 82,-18 4,-28 -28,-37 -41,-36l-42 13c13,27 39,14 48,13l10 1 9 12c-30,-4 -10,-1 -33,1 -23,2 -41,-9 -49,-34l8 -3c-8,-6 -15,-14 -18,-26l9 -3c-6,-5 -11,-13 -16,-24l15 -5c-7,-6 -12,-15 -15,-25l28 -8c-30,-7 -50,8 -72,30l-31 -4zm96 46c17,28 30,7 52,5 6,-1 29,4 36,9 21,-23 -42,-27 -44,-27l-44 13zm-5 -27l12 14c44,-13 27,-12 72,-6 7,-21 -39,-22 -40,-22l-44 14zm-1 -31l11 16c36,-11 26,-11 54,-7 2,-18 -20,-20 -27,-20l-38 11z"],fill:opts.color}))},makeStar:function(opts){return sticker.makeSimplePath($.extend({},!0,opts,{strokeWidth:2,viewBox:[0,0,1024,1280],d:["M521.19122173 257.59668148l48.67463902 112.36592198c10.61521383 24.46677333 33.65799506 41.42522469 60.32548344 44.14375505l123.62840495 12.55702124-92.30057877 79.48464988c-20.71261235 17.86462815-29.90383408 45.43829333-23.8195042 72.10578173l27.44421136 121.68659752-105.37541531-64.20909827c-11.52139061-6.99050667-24.85513482-10.74466765-38.31833283-10.74466765-13.59265185 0-26.79694222 3.75416098-38.31833286 10.74466765l-105.37541529 64.20909827 27.44421135-121.68659752c5.95487605-26.66748839-3.10689185-54.24115358-23.8195042-72.10578173l-92.30057876-79.48464988 123.62840494-12.55702124c26.53803457-2.71853037 49.71026963-19.5475279 60.32548346-44.14375505l48.1568237-112.36592198m0-117.80298272c-6.2137837 0-12.55702124 3.3657995-15.40500543 10.09739852l-85.43952593 197.28763258c-2.45962272 5.56651457-7.63777581 9.45012939-13.72210568 10.09739853l-216.446799 22.00715063c-14.7577363 1.55344592-20.45370469 19.80643555-9.32067556 29.51547258l163.11182222 140.45740248c4.66033778 4.01306864 6.86105283 10.35630617 5.43706074 16.44063605l-48.1568237 213.98717629c-2.58907653 11.26248297 6.34323753 20.58315852 16.44063604 20.58315852 2.84798419 0 5.95487605-0.77672297 8.67340642-2.45962272l186.15460346-113.40155259c2.71853037-1.68289975 5.69596839-2.45962272 8.80286024-2.45962272s6.08432987 0.77672297 8.80286026 2.45962272l186.15460344 113.40155259c2.84798419 1.68289975 5.82542222 2.45962272 8.67340644 2.45962272 10.09739852 0 19.02971259-9.32067555 16.44063604-20.58315852L693.23535803 565.69679013c-1.4239921-6.08432987 0.77672297-12.42756741 5.43706073-16.44063605l163.11182222-140.45740248c11.26248297-9.70903703 5.43706075-27.96202667-9.32067555-29.51547258l-216.44679901-22.00715063c-6.08432987-0.64726914-11.26248297-4.40143013-13.72210567-10.09739853l-85.43952593-197.28763258c-3.23634569-6.73159902-9.45012939-10.09739852-15.66391309-10.09739852z"],fill:opts.color}))},makeRibbon:function(opts){return sticker.makeSimplePath($.extend({},!0,opts,{strokeWidth:2,viewBox:"0 0 100 100",d:["M76.979,12.22c-0.366-0.579-1.004-0.93-1.689-0.93H59.165c-0.768,0-1.468,0.439-1.802,1.132l-6.634,13.76l-7.117-13.808  c-0.343-0.666-1.028-1.084-1.777-1.084H24.71c-0.686,0-1.323,0.351-1.689,0.93c-0.367,0.579-0.411,1.306-0.118,1.926l15.213,32.151  c-6.585,4.021-10.99,11.274-10.99,19.538C27.125,78.448,37.387,88.71,50,88.71s22.875-10.262,22.875-22.875  c0-8.264-4.405-15.518-10.99-19.538l15.213-32.151C77.391,13.525,77.347,12.799,76.979,12.22z M27.869,15.29h12.747l14.572,28.271  C53.521,43.172,51.785,42.96,50,42.96c-2.927,0-5.724,0.559-8.299,1.564L27.869,15.29z M68.875,65.835  c0,10.407-8.468,18.875-18.875,18.875s-18.875-8.468-18.875-18.875S39.593,46.96,50,46.96S68.875,55.428,68.875,65.835z   M59.201,42.617l-6.178-11.984l7.397-15.343h11.71L59.201,42.617z M48.207,53.277l-2.999,6.074l-6.703,0.973  c-0.754,0.109-1.38,0.638-1.615,1.361s-0.039,1.519,0.506,2.051l4.852,4.728l-1.146,6.677c-0.128,0.75,0.181,1.509,0.796,1.956  c0.349,0.253,0.762,0.382,1.176,0.382c0.318,0,0.638-0.076,0.931-0.229L50,74.098l5.994,3.151c0.675,0.353,1.491,0.295,2.106-0.152  s0.924-1.206,0.796-1.956l-1.145-6.677l4.852-4.728c0.545-0.532,0.741-1.327,0.506-2.051s-0.861-1.252-1.615-1.361l-6.703-0.973  l-2.997-6.074c-0.337-0.683-1.032-1.115-1.794-1.115C49.239,52.162,48.544,52.595,48.207,53.277z M51.669,62.064  c0.292,0.591,0.855,1,1.507,1.095l3.732,0.542l-2.7,2.632c-0.472,0.46-0.687,1.122-0.576,1.771l0.638,3.72l-3.339-1.756  c-0.582-0.307-1.279-0.307-1.861,0l-3.34,1.756l0.638-3.72c0.11-0.648-0.104-1.311-0.575-1.771l-2.701-2.632l3.732-0.542  c0.651-0.095,1.215-0.504,1.506-1.095L50,58.682L51.669,62.064z"],fill:opts.color}))},makeAxis:function(opts){return sticker.makeSimplePath($.extend({},!0,opts,{strokeWidth:opts.strokeWidth,viewBox:"0 0 90 90",d:["M89.7,85.7c0,0.2-0.1,0.3-0.2,0.4l-3.2,2.2c-0.1,0.1-0.2,0.1-0.3,0.1c-0.1,0-0.2,0-0.2-0.1c-0.2-0.1-0.3-0.3-0.3-0.4v-1.2  H13c-0.6,0-1-0.4-1-1V15.8h-1.2c-0.2,0-0.4-0.1-0.4-0.3c-0.1-0.2-0.1-0.4,0-0.5l2.2-3.2c0.2-0.3,0.6-0.3,0.8,0l2.2,3.2  c0.1,0.2,0.1,0.4,0,0.5c-0.1,0.2-0.3,0.3-0.4,0.3H14v68.9h71.4v-1.2c0-0.2,0.1-0.4,0.3-0.4c0.2-0.1,0.4-0.1,0.5,0l3.2,2.2  C89.6,85.4,89.7,85.6,89.7,85.7z"],fill:"solid"}))},makeBomb:function(opts){return sticker.makeSimplePath($.extend({},!0,opts,{strokeWidth:opts.strokeWidth,viewBox:"0 0 100 100",d:["M44.5,44.4v-3.9c0-1.1-0.9-2-2-2h-5.6c0-2.2,0.3-5.1,1.8-6.9c1.1-1.3,2.6-1.9,4.7-1.9c3.1,0,6.1,1.2,8.9,2.3  c5.4,2.2,11.1,4.4,16.9-1.6c0.6-0.6,0.6-1.5,0-2.1c-0.6-0.6-1.5-0.6-2.1,0c-4.4,4.6-8.5,3-13.6,0.9c-3.1-1.3-6.4-2.6-10-2.6  c-3,0-5.3,1-7,3c-2.2,2.6-2.5,6.3-2.5,8.8h-5.1c-1.1,0-2,0.9-2,2v3.9C18.3,47.9,12.3,56.3,12.3,66c0,12.9,10.4,23.3,23.3,23.3  S59,78.9,59,66C59,56.3,53,47.9,44.5,44.4z M32.9,80.3c-0.2,0.6-0.8,1.1-1.4,1.1c-0.1,0-0.3,0-0.4-0.1c-6.8-2-11.3-8.2-11.3-15.3  c0-3.5,1.1-6.9,3.3-9.7c0.5-0.7,1.4-0.8,2.1-0.3c0.7,0.5,0.8,1.4,0.3,2.1c-1.7,2.3-2.7,5-2.7,7.9c0,5.7,3.8,10.8,9.2,12.4  C32.7,78.6,33.2,79.5,32.9,80.3z","M82.3,14.5c0.5-0.6,0.5-1.6-0.2-2.1c-0.6-0.5-1.6-0.5-2.1,0.2l-8.6,10.1c-0.5,0.6-0.5,1.6,0.2,2.1c0.3,0.2,0.6,0.4,1,0.4  c0.4,0,0.8-0.2,1.1-0.5L82.3,14.5z","M60.7,13.9C60.7,13.9,60.7,13.9,60.7,13.9l3.9,8.7c0,0,0,0,0,0l0.5,1.1c0.3,0.6,0.8,0.9,1.4,0.9c0.2,0,0.4,0,0.6-0.1  c0.8-0.3,1.1-1.2,0.7-2l-0.5-1.1c0,0,0,0,0,0l-3.9-8.7c0,0,0,0,0,0l-0.5-1.1c-0.3-0.8-1.2-1.1-2-0.7c-0.8,0.3-1.1,1.2-0.7,2  L60.7,13.9z","M75.5,32.4c-0.6-0.6-1.6-0.5-2.1,0.1c-0.6,0.6-0.5,1.6,0.1,2.1l9.7,9.2c0.3,0.3,0.7,0.4,1,0.4c0.4,0,0.8-0.2,1.1-0.5  c0.6-0.6,0.5-1.6-0.1-2.1L75.5,32.4z","M86.2,26.6l-10.5,0c-0.8,0-1.5,0.7-1.5,1.5c0,0.8,0.7,1.5,1.5,1.5l10.5,0c0.8,0,1.5-0.7,1.5-1.5  C87.7,27.3,87,26.6,86.2,26.6z","M50.9,21.7l11.6,5.4c0.2,0.1,0.4,0.1,0.6,0.1c0.6,0,1.1-0.3,1.4-0.9c0.4-0.8,0-1.6-0.7-2L52.2,19c-0.7-0.4-1.6,0-2,0.7  C49.9,20.5,50.2,21.3,50.9,21.7z","M69.5,34.8c-0.8,0-1.5,0.7-1.5,1.5l0,11.3c0,0.8,0.7,1.5,1.5,1.5c0.8,0,1.5-0.7,1.5-1.5l0-11.3C71,35.4,70.4,34.8,69.5,34.8  z"],fill:opts.color}))},makeCheckmark:function(opts){var dimensions;return dimensions=opts.iconUsage?$.extend({},opts.dimensions):{x:opts.dimensions.x,y:opts.dimensions.y,width:Math.max(opts.dimensions.width,25),height:Math.max(opts.dimensions.height,25)},sticker.makeSimplePath($.extend({},!0,opts,{strokeWidth:opts.strokeWidth,viewBox:"0 0 587 783.75",d:["M0 303c61,65 122,129 184,194 134,-166 227,-376 403,-497 -181,160 -285,402 -400,627 -62,-108 -125,-216 -187,-324z"],color:"#090",fill:"#4f4",dimensions:dimensions,dashed:void 0}))},makeXmark:function(opts){var dimensions,strokeWidth;return opts.iconUsage?(dimensions=$.extend({},opts.dimensions),strokeWidth=opts.strokeWidth):(strokeWidth=5,dimensions={x:opts.dimensions.x,y:opts.dimensions.y,width:Math.max(opts.dimensions.width,25),height:Math.max(opts.dimensions.height,25)}),sticker.makeSimplePath($.extend({},!0,opts,{strokeWidth:strokeWidth,viewBox:"0 0 100 100",d:["M10 10 L 80 80 M 80 10 L 10 80"],color:"red",dimensions:dimensions,dashed:void 0}))},makePi:function(opts){var dimensions,strokeWidth;return opts.iconUsage?(dimensions=$.extend({},opts.dimensions),strokeWidth=opts.strokeWidth):(strokeWidth=1,dimensions={x:opts.dimensions.x,y:opts.dimensions.y,width:Math.max(opts.dimensions.width,25)},dimensions.height=dimensions.width),sticker.makeSimplePath($.extend({},!0,opts,{strokeWidth:strokeWidth,viewBox:"0 0 110 137.5",d:["M21.33,40.487h-3.057c0,0,2.938-21.636,19.974-21.636s53.479,0,53.479,0v11.337H74.157c0,0-3.265,22.259-3.265,34.25  c0,11.989,7.242,14.363,10.091,14.363s7.479-5.46,7.479-6.528c0-1.069,0-2.612,0-2.612h3.265c0,0-1.009,21.487-15.848,21.487  c-14.84,0-13.415-24.93-13.296-25.761c0.118-0.831,3.087-35.021,3.087-35.021H47.15c0,0-0.514,26.395-2.256,34.151  c-1.741,7.756-3.481,26.631-13.139,26.631c-9.654,0-6.171-8.586-6.013-9.379c0.157-0.791,7.122-10.289,8.705-14.72  c1.582-4.432,3.799-36.723,3.799-36.723s-9.676-1.613-13.296,4.273C21.33,40.487,21.33,40.487,21.33,40.487z"],color:opts.color,fill:opts.color,dimensions:dimensions,dashed:void 0}))},makeAlpha:function(opts){var dimensions,strokeWidth;return opts.iconUsage?(dimensions=$.extend({},opts.dimensions),strokeWidth=opts.strokeWidth):(strokeWidth=1,dimensions={x:opts.dimensions.x,y:opts.dimensions.y,width:Math.max(opts.dimensions.width,25)},dimensions.height=dimensions.width),sticker.makeSimplePath($.extend({},!0,opts,{strokeWidth:strokeWidth,viewBox:"0 0 1000 1250",d:["M893 755c14,-17 39,-19 56,-5 17,15 19,40 4,57 -181,211 -273,23 -329,-153 -254,411 -603,196 -586,-174 16,-346 418,-629 607,-33 47,-101 88,-205 131,-308 9,-20 32,-30 52,-22 21,9 30,32 22,53 -54,130 -106,263 -172,388 37,123 74,361 215,197zm-300 -204c-166,-554 -461,-392 -476,-68 -15,337 264,458 476,68z"],color:opts.color,fill:opts.color,dimensions:dimensions,dashed:void 0}))},makeBeta:function(opts){var dimensions,strokeWidth;return opts.iconUsage?(dimensions=$.extend({},opts.dimensions),strokeWidth=opts.strokeWidth):(strokeWidth=1,dimensions={x:opts.dimensions.x,y:opts.dimensions.y,width:Math.max(opts.dimensions.width,25)},dimensions.height=dimensions.width),sticker.makeSimplePath($.extend({},!0,opts,{strokeWidth:strokeWidth,viewBox:"0 0 1000 1250",d:["M291 982c-15,8 -33,2 -40,-13 -8,-14 -3,-32 12,-40 64,-34 46,-199 28,-374 -13,-118 -26,-241 -14,-338 16,-131 74,-218 227,-200 10,2 21,4 32,8 32,11 64,34 86,66 23,33 35,75 29,126 -2,16 -6,33 -12,51 -6,15 -12,30 -20,44 23,10 44,26 63,46 28,31 50,73 61,118 12,45 14,93 2,137 -28,111 -133,196 -358,138 -10,-2 -17,-9 -21,-18 5,118 -8,213 -75,249zm61 -448c6,56 12,112 15,164 5,-15 21,-24 36,-20 182,46 265,-14 286,-95 9,-34 8,-72 -2,-108 -9,-35 -25,-68 -47,-92 -17,-17 -36,-30 -58,-34 -12,13 -24,23 -36,32 -15,11 -29,18 -42,22 -19,5 -36,4 -50,-6 -8,-6 -15,-15 -18,-27 -3,-11 1,-23 9,-30l0 0c38,-35 76,-52 112,-55 11,-15 21,-33 27,-52 5,-14 8,-27 10,-39 4,-34 -4,-63 -19,-84 -15,-21 -36,-36 -57,-44 -7,-2 -13,-4 -20,-4 -107,-14 -148,50 -160,147 -11,91 2,210 14,325z"],color:opts.color,fill:opts.color,dimensions:dimensions,dashed:void 0}))},makeGrid:function(opts){var dimensions,strokeWidth;opts.iconUsage?(dimensions=$.extend({},opts.dimensions),strokeWidth=opts.strokeWidth):(strokeWidth=1,dimensions={x:opts.dimensions.x,y:opts.dimensions.y,width:Math.max(opts.dimensions.width,25)},dimensions.height=dimensions.width);var gridCtr,gridVal,viewBox=sticker.makeBufferedViewBox({buffer:5,viewBox:[0,0,100,100]}),d="";for(gridCtr=0;gridCtr<=10;++gridCtr)gridVal=10*gridCtr,d+="M 0 "+gridVal+" L 100 "+gridVal+" ",d+="M "+gridVal+" 0 L "+gridVal+" 100 ";return sticker.makeSimplePath($.extend({},!0,opts,{strokeWidth:strokeWidth,viewBox:viewBox,d:[d],dimensions:dimensions,dashed:void 0}))},makeRightSideMarker:function(opts){return sticker.makeSimplePath($.extend({},!0,opts,{strokeWidth:2,viewBox:[0,0,100,50],d:["M 0 25 L 25 0 L 100 0 L 100 50 L 25 50 Z"],fill:opts.color,outerClass:"graffiti-right-side-marker",buffer:0}))},makeAngle:function(opts){return sticker.makeSimplePath($.extend({},!0,opts,{strokeWidth:2,viewBox:[0,0,30,35],transform:"translate(-390 -560)",d:["M401.883,578.324l12.971-12.971l-0.707-0.707L390.793,588H419v-1h-13.524    C405.357,583.749,404.098,580.706,401.883,578.324z M393.207,587l7.969-7.969c2.026,2.192,3.183,4.984,3.3,7.969H393.207z"],fill:opts.color}))},makeTrophy:function(opts){return sticker.makeSimplePath($.extend({},!0,opts,{strokeWidth:2,viewBox:[0,0,100,125],d:["M69.402,82.288H30.598c-0.855,0-1.548,0.692-1.548,1.548v8.462c0,0.857,0.693,1.55,1.548,1.55h38.804  c0.854,0,1.549-0.693,1.549-1.55v-8.462C70.951,82.98,70.258,82.288,69.402,82.288z","M93.357,15.879c-1.635-2.293-5.112-4.738-12.479-4.309c0.062-1.208,0.104-2.446,0.123-3.716  c0.017-0.94-0.681-1.703-1.537-1.703H20.536c-0.856,0-1.551,0.762-1.537,1.703c0.019,1.271,0.061,2.508,0.123,3.717  c-7.363-0.43-10.845,2.013-12.479,4.307c-2.331,3.271-2.174,8,0.428,12.978c3.722,7.119,12.165,14.247,22.486,16.61  C36.188,54.68,43.49,57.225,43.49,57.225h13.021c0,0,7.301-2.545,13.934-11.759c10.32-2.365,18.764-9.492,22.486-16.61  C95.532,23.88,95.688,19.15,93.357,15.879z M11.381,26.603c-1.723-3.295-2.007-6.175-0.778-7.9c1.311-1.838,4.444-2.606,8.914-2.228  c1.002,9.551,3.36,16.971,6.236,22.688C19.17,36.406,13.945,31.507,11.381,26.603z M63.782,24.541l-6.49,6.326l1.532,8.933  c0.105,0.611-0.256,0.872-0.803,0.584L50,36.166l-8.023,4.218c-0.547,0.288-0.907,0.026-0.803-0.584l1.533-8.933l-6.49-6.326  c-0.444-0.433-0.306-0.856,0.307-0.945l8.968-1.303l4.011-8.129c0.274-0.556,0.719-0.556,0.993,0l4.011,8.129l8.968,1.303  C64.088,23.685,64.227,24.109,63.782,24.541z M88.619,26.603c-2.564,4.904-7.789,9.804-14.372,12.561  c2.876-5.717,5.233-13.137,6.235-22.688c4.472-0.379,7.604,0.39,8.914,2.228C90.626,20.428,90.342,23.308,88.619,26.603z","M61.506,78.811c-6.724-9.961-5.283-18.379-5.283-18.379H43.777c0,0,1.44,8.418-5.284,18.379H61.506z"],fill:opts.color}))},makeButtonWithCursor:function(fill){return'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 128 120" enable-background="new 0 0 128 128" xml:space="preserve"><path d="M120,28H8c-4.4,0-8,3.6-8,8v32c0,4.4,3.6,8,8,8h81.264l-0.955-4H8c-2.206,0-4-1.794-4-4V36c0-2.206,1.794-4,4-4h112  c2.206,0,4,1.794,4,4v32c0,1.907-1.343,3.5-3.132,3.898l0.358,0.109c1.417,0.431,2.569,1.364,3.32,2.56  C126.629,73.119,128,70.714,128,68V36C128,31.6,124.4,28,120,28z"/><path d="M114.174,81.744l5.973-2.11c0.815-0.288,1.353-1.066,1.333-1.931c-0.019-0.863-0.591-1.617-1.417-1.868l-25.48-7.748  c-0.686-0.21-1.431-0.034-1.952,0.456c-0.522,0.491-0.741,1.225-0.575,1.922l5.773,24.184c0.192,0.805,0.86,1.408,1.681,1.518  c0.82,0.106,1.623-0.297,2.02-1.023l3.009-5.509l9.558,9.766c0.391,0.398,0.909,0.601,1.431,0.601c0.452,0,0.907-0.153,1.28-0.464  l6.476-5.4c0.429-0.357,0.688-0.878,0.716-1.436c0.028-0.557-0.178-1.101-0.567-1.5L114.174,81.744z M115.662,95.281l-10.156-10.377  c-0.379-0.387-0.896-0.601-1.43-0.601c-0.091,0-0.183,0.006-0.274,0.019c-0.628,0.087-1.177,0.467-1.48,1.022l-1.811,3.315  l-3.756-15.732l16.32,4.963l-3.189,1.127c-0.645,0.228-1.128,0.768-1.282,1.434c-0.154,0.665,0.041,1.363,0.519,1.852l9.934,10.148  L115.662,95.281z"/></svg>'},makeButton:function(opts){return'<div class="button-icon" style="width:'+opts.width+"px;height:"+opts.height+'px;">'+opts.contents+"</div>"},makeTerminal:function(opts){var height=parseInt(.9*opts.width);return'<div class="terminal-icon" style="width:'+opts.width+"px;height:"+height+'px;">&gt;_</div>'},makeLock:function(opts){return sticker.makeSimplePath($.extend({},!0,opts,{strokeWidth:1,viewBox:[0,0,100,100],d:["M77.9,41.2h-0.3v-8.9c0-15-11.7-27.6-26.7-28.1c-15.5-0.5-28.3,12-28.3,27.5c0,1.2,1,2.1,2.1,2.1H33c0.9,0,1.7-0.7,1.7-1.7  c0-8.3,6.4-15.5,14.7-15.9c8.9-0.4,16.2,6.7,16.2,15.4v9.4H34.7h-12h-0.6c-4,0-7.3,3.2-7.3,7.3v40c0,4,3.2,7.2,7.2,7.2h55.8  c4,0,7.3-3.2,7.3-7.3v-40C85.1,44.5,81.9,41.2,77.9,41.2z M22.9,87.7v-7l5.5,7H22.9z M34.7,87.7L22.9,72.6v-2.9h4l14.1,18H34.7z   M47.3,87.7l-14.1-18h6.3l14.1,18H47.3z M60,87.7l-14.1-18h6.3l14.1,18H60z M77.1,87.7h-4.5l-14.1-18h6.3l12.3,15.7V87.7z   M77.1,77.3l-5.9-7.6h5.9V77.3z"],fill:opts.color}))},makeSimpleX:function(opts){return sticker.makeSimplePath($.extend({},!0,opts,{strokeWidth:1,viewBox:[0,0,100,100],d:["M75.1,7.3L50,32.3L24.9,7.3c-1.2-1.2-3.1-1.2-4.2,0L5.8,22.1L33,49.3L5.8,76.5l14.8,14.8c1.2,1.2,3.1,1.2,4.2,0L50,66.3  l25.1,25.1c1.2,1.2,3.1,1.2,4.2,0l14.8-14.8L67,49.3l27.2-27.2L79.3,7.3C78.1,6.1,76.2,6.1,75.1,7.3z"],fill:opts.color}))},makeHidden:function(opts){return sticker.makeSimplePath($.extend({},!0,opts,{strokeWidth:1,viewBox:[0,0,100,100],d:["M 8.9 46.05 Q 7.3 46.05 6.15 47.2 5 48.35 5 50 5 51.6 6.15 52.75 7.3 53.9 8.9 53.9 L 25.65 53.9 Q 27.3 53.9 28.45 52.75 29.6 51.6 29.6 50 29.6 48.35 28.45 47.2 27.3 46.05 25.65 46.05 L 8.9 46.05 M 37.05 68.5 Q 38.2 67.35 38.2 65.75 38.2 64.1 37.05 62.95 35.9 61.85 34.25 61.85 32.65 61.85 31.5 62.95 L 18.2 76.25 Q 17.05 77.4 17.05 79.05 17.05 80.65 18.2 81.8 19.35 82.95 20.95 82.95 22.6 82.95 23.75 81.8 L 37.05 68.5 M 52.75 71.55 Q 51.6 70.4 50 70.4 48.4 70.4 47.25 71.55 46.1 72.7 46.1 74.35 L 46.1 91.05 Q 46.1 92.7 47.25 93.85 48.4 95 50 95 51.6 95 52.75 93.85 53.9 92.7 53.9 91.05 L 53.9 74.35 Q 53.9 72.7 52.75 71.55 M 93.85 47.2 Q 92.7 46.05 91.1 46.05 L 74.35 46.05 Q 72.75 46.05 71.55 47.2 70.4 48.35 70.4 50 70.4 51.6 71.55 52.75 72.75 53.9 74.35 53.9 L 91.1 53.9 Q 92.7 53.9 93.85 52.75 95 51.6 95 50 95 48.35 93.85 47.2 M 81.8 81.8 Q 82.95 80.65 82.95 79.05 82.95 77.4 81.8 76.25 L 68.5 62.95 Q 67.4 61.85 65.75 61.85 64.1 61.85 62.95 62.95 61.85 64.1 61.85 65.75 61.85 67.35 62.95 68.5 L 76.3 81.8 Q 77.4 82.95 79.05 82.95 80.65 82.95 81.8 81.8 M 82.95 20.95 Q 82.95 19.3 81.8 18.15 80.65 17 79.05 17 77.4 17 76.3 18.15 L 62.95 31.45 Q 61.85 32.6 61.85 34.25 61.85 35.85 62.95 37 64.1 38.15 65.75 38.15 67.4 38.15 68.5 37 L 81.8 23.7 Q 82.95 22.55 82.95 20.95 M 53.9 8.9 Q 53.9 7.3 52.75 6.15 51.6 5 50 5 48.4 5 47.25 6.15 46.1 7.3 46.1 8.9 L 46.1 25.65 Q 46.1 27.25 47.25 28.4 48.4 29.55 50 29.55 51.6 29.55 52.75 28.4 53.9 27.25 53.9 25.65 L 53.9 8.9 M 23.75 18.15 Q 22.6 17 20.95 17 19.35 17 18.2 18.15 17.05 19.3 17.05 20.95 17.05 22.55 18.2 23.7 L 31.5 37 Q 32.65 38.15 34.25 38.15 35.9 38.15 37.05 37 38.2 35.85 38.2 34.25 38.2 32.6 37.05 31.45 L 23.75 18.15 Z"],fill:opts.color}))},makeRunningMan:function(fill){return'<svg xmlns:x="http://ns.adobe.com/Extensibility/1.0/" xmlns:i="http://ns.adobe.com/AdobeIllustrator/10.0/" xmlns:graph="http://ns.adobe.com/Graphs/1.0/" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 100 85" style="enable-background:new 10 10 100 70;" xml:space="preserve"><switch><foreignObject requiredExtensions="http://ns.adobe.com/AdobeIllustrator/10.0/" x="0" y="0" width="1" height="1"/><g i:extraneous="self"><g fill-rule="evenodd" fill="'+fill+'"><path d="M48.8,57.3c-0.8-0.5-1.4-1.2-1.8-2c-1.5,4.3-3.6,9.6-4.7,12.2c-2.9,0.1-9.5-0.6-14.9-1.5c-2.3-0.4-4.5,1.2-4.8,3.5     c-0.4,2.3,1.2,4.5,3.5,4.8c0.2,0,4.6,0.7,9.2,1.2c2.5,0.3,4.6,0.4,6.4,0.4c3.9,0,6.2-0.8,7.4-3c0.9-1.6,3-7.1,4.9-12.2     c-1.2-0.8-2.5-1.7-4-2.7C49.4,57.7,49,57.4,48.8,57.3z"/><path d="M97.4,43.5c-0.5-1.7-2.2-2.8-4-2.3c-0.8,0.2-6.7,1.8-10.3,2.8c-0.1-0.4-0.3-0.8-0.4-1.1c-1.4-4.1-3.5-10.3-8.9-12.4     c-1.2-0.5-4-1.7-5.8-2.5c-7.6-3.3-20.8,0.3-22.5,0.9c-0.9,0.4-2.9,1.1-8.7,12.5C36,43,36.7,45,38.3,45.8c0.5,0.2,1,0.4,1.5,0.4     c1.2,0,2.3-0.7,2.9-1.8c1.9-3.7,4.5-8.2,5.5-9.4c1.3-0.4,4.4-1.1,7.8-1.5c-3.7,5.1-7,13.2-7.6,16.1c-0.8,4.2,1,5.6,1.6,6     c1.4,1,14.2,9.5,16.1,11.5c-0.5,2.9-3.1,11.4-5.4,18.4c-0.7,2.2,0.5,4.6,2.7,5.3c0.4,0.1,0.9,0.2,1.3,0.2c1.8,0,3.4-1.1,4-2.9     c2.2-6.8,6-18.6,5.9-22c-0.1-3.3-3.1-6.2-9.7-10.7c2.1-5.2,5.6-12.7,8.9-16.6c1.2,1.8,2.1,4.3,2.7,6.2c1,2.8,1.6,4.8,3.5,5.7     c0.5,0.3,1.1,0.4,1.6,0.4c0.4,0,0.9-0.1,1.3-0.2c1.4-0.5,8-2.3,12.1-3.4C96.8,47,97.8,45.3,97.4,43.5z"/><ellipse transform="matrix(0.3937 -0.9192 0.9192 0.3937 28.3646 78.9709)" cx="74" cy="18" rx="9" ry="9"/><path d="M10.8,34.5h20.7c1.4,0,2.5-1.1,2.5-2.5s-1.1-2.5-2.5-2.5H10.8c-1.4,0-2.5,1.1-2.5,2.5S9.5,34.5,10.8,34.5z"/><path d="M7.9,45h20.7c1.4,0,2.5-1.1,2.5-2.5s-1.1-2.5-2.5-2.5H7.9c-1.4,0-2.5,1.1-2.5,2.5S6.5,45,7.9,45z"/><path d="M28.1,53c0-1.4-1.1-2.5-2.5-2.5H5c-1.4,0-2.5,1.1-2.5,2.5c0,1.4,1.1,2.5,2.5,2.5h20.7C27,55.5,28.1,54.4,28.1,53z"/></g></g></switch></svg>'},makeScan:function(fill){return'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 100 100" style="enable-background:new 0 0 100 100;" xml:space="preserve"><g><g fill-rule="evenodd" fill="'+fill+'"><path d="M23.3,62.8H9.2C6.9,62.8,5,64.7,5,67v14.2c0,2.3,1.9,4.2,4.2,4.2h14.2c2.3,0,4.2-1.9,4.2-4.2V67    C27.5,64.7,25.6,62.8,23.3,62.8z"/><path d="M90.8,62.8H76.7c-2.3,0-4.2,1.9-4.2,4.2v14.2c0,2.3,1.9,4.2,4.2,4.2h14.2c2.3,0,4.2-1.9,4.2-4.2V67    C95,64.7,93.1,62.8,90.8,62.8z"/><path d="M57.1,62.8H42.9c-2.3,0-4.2,1.9-4.2,4.2v14.2c0,2.3,1.9,4.2,4.2,4.2h14.2c2.3,0,4.2-1.9,4.2-4.2V67    C61.2,64.7,59.4,62.8,57.1,62.8z M57.1,81.1C57.1,81.1,57.1,81.1,57.1,81.1l-14.2,0c0,0,0,0,0,0l0-14.2c0,0,0,0,0,0h14.2    c0,0,0,0,0,0L57.1,81.1z"/><path d="M87.5,52.5l5-24.4l-9,3c-3.4-4.6-7.8-8.4-12.9-11.2c-6.2-3.4-13.3-5.2-20.6-5.2c-22.4,0-40.6,17-40.6,37.8    c0,1.7,1.4,3.1,3.1,3.1s3.1-1.4,3.1-3.1C15.6,35.1,31,20.9,50,20.9c10.7,0,20.7,4.6,27.2,12.2L68.8,36L87.5,52.5z"/></g></g></svg>'},makeRabbit:function(fill){
return'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:sketch="http://www.bohemiancoding.com/sketch/ns" viewBox="0 0 100 75" version="1.1" x="0px" y="10px"><g stroke="none" stroke-width="1" fill-rule="evenodd" sketch:type="MSPage"><g sketch:type="MSArtboardGroup" transform="translate(0.000000, -7.000000)" fill="'+fill+'"><path d="M60.1164483,76.5101184 C60.1164483,77.7869765 61.1184016,79.097951 62.3543737,79.4324469 L72.798828,82.2590697 C74.9502082,82.841306 76.9428079,85.1218308 77.229578,87.3473934 L77.4381368,88.9659749 L61.2268002,86.7611761 C59.0007748,86.4584288 55.762595,85.1122528 53.9830021,83.7528954 L30.0193357,65.4480423 C18.6673757,64.6909954 9.4627489,56.133214 7.77382209,45.1160791 L4.34635739,45.1647777 C1.94608449,45.1988816 -1.83318034e-16,43.2833095 -1.07537429e-17,40.8862227 L12.0835739,27.3645101 C17.4743573,21.3386402 23.6068695,17.4194231 31.6593886,17.4194231 C32.7498041,17.4194231 33.8233498,17.4912885 34.8755022,17.6305187 C36.0956627,17.7349159 37.3050822,17.9433886 38.4888396,18.2605754 C54.0954993,22.4423673 65.570761,42.6024939 65.570761,42.6024939 C66.516058,44.0861571 68.636741,45.6806441 70.3388841,46.136732 L71.0643059,46.3311082 C72.7686884,46.7877961 75.036606,46.0402598 76.1348435,44.6627794 L79.3667959,40.6090557 L69.0683577,35.5886404 C54.9830017,29.5 58.824985,11.8109045 58.824985,11.8109045 C58.9924242,10.7260817 59.7843012,10.4649372 60.587326,11.2216236 L82.7393229,32.0953411 L64.7779732,12.0675015 C65.0289152,8.20500861 68.1652109,7 68.1652109,7 L85.5324488,34.7272898 L86.921334,36.0360295 L96.0521825,42.4677019 C98.138955,43.9376022 99.8625925,47.2144004 99.8888571,49.7773535 L100.007257,61.3310185 L99.3236978,61.8899026 C97.5857982,63.3108255 94.5445704,63.6651439 92.5224884,62.6881932 L89.3807164,61.1702742 C86.2103299,59.6385304 81.4523901,60.2321429 78.7512966,62.4950512 L69.6842316,70.0912108 C68.6969982,70.9182902 67.3970043,71.7079683 65.972973,72.3860195 C65.450814,57.828347 59.4984737,45.9574271 46.7248907,37.1161254 C45.6127483,36.4326524 43.9592431,38.4195836 44.7777067,39.1109172 C56.0407574,49.2817354 60.1164483,60.3235994 60.1164483,74.5177084 L60.1164483,76.5101184 Z M95.0509461,53.9162538 C96.1764172,53.9162538 97.0887918,53.0084656 97.0887918,51.8886521 C97.0887918,50.7688386 96.1764172,49.8610504 95.0509461,49.8610504 C93.925475,49.8610504 93.0131004,50.7688386 93.0131004,51.8886521 C93.0131004,53.0084656 93.925475,53.9162538 95.0509461,53.9162538 L95.0509461,53.9162538 Z M19.9417759,92 L19.9417759,89.8393536 C19.9417758,87.5932185 21.6918837,85.2820263 23.828826,84.6248277 C23.828826,84.6248277 35.0800582,81.8619915 38.1368268,76.9378159 C38.1368268,76.9378159 46.7248911,83.7447645 46.7248911,83.7447645 C34.7889374,89.6827409 19.9417759,92 19.9417759,92 L19.9417759,92 Z" sketch:type="MSShapeGroup"/></g></g></svg>'},makeTurtle:function(){return'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="0 0 75 70" enable-background="new 0 0 95 95" xml:space="preserve"><path d="M87.242,46.239c-5.27,0-9.811,1.512-10.09,1.061c-0.281-0.445,1.796-1.456,3.025-2.802  C69.529,35.867,66.388,23.76,47.223,23.76c-19.398,0-24.78,18.723-35.316,28.476l1.905,1.904c0,0-3.586,1.238-6.277,1.57  c-2.691,0.336-6.951,0.741-6.951,1.348c0,0.531,5.606,0.896,8.407,0.896c2.804,0,7.513-0.338,7.513-0.338s0.337,0.445-2.47,1.342  c-2.804,0.9-3.471,1.686-5.49,4.266c-2.014,2.578-4.215,4.748-4.215,5.713c0,1.09,0.445,1.812,2.014,1.812S9.034,71,10.551,71  c2.909,0,2.909-1.807,3.694-3.152c0.789-1.348,1.362-2.158,2.258-2.943c0.901-0.787,2.02-1.008,3.474-1.568  c1.456-0.564,3.702-1.686,3.702-1.686s3.813,1.461,10.424,1.461c6.617,0,18.836-0.34,24.327-0.34c5.493,0,6.562-2.295,7.906-2.295  c0.672,0,3.981,1.965,3.981,2.748c0,1.117-5.161,4.93-5.161,6.051c0,1.125,1.795,1.965,5.05,1.965c4.653,0,5.205-2.605,6.501-4.207  c1.401-1.734,2.572-3.363,2.572-5.383c0-2.521-5.042-4.818-5.042-4.818s1.011-1.571,3.025-1.571c2.017,0,6.056,0.45,10.428,0.45  c4.373,0,6.727,0.56,6.727-3.589C94.417,47.976,92.514,46.239,87.242,46.239z M89.167,50.5c-0.553,0-1-0.447-1-1s0.447-1,1-1  s1,0.447,1,1S89.72,50.5,89.167,50.5z"/></svg>'},makeSnail:function(){return'<svg style="transform:scaleX(-1.0)" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:cc="http://creativecommons.org/ns#" xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns:svg="http://www.w3.org/2000/svg" xmlns="http://www.w3.org/2000/svg" xmlns:sodipodi="http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd" xmlns:inkscape="http://www.inkscape.org/namespaces/inkscape" version="1.1" x="0px" y="5px" viewBox="0 0 75 75"><g transform="translate(0,-952.36218)"><path style="text-indent:0;text-transform:none;direction:ltr;block-progression:tb;baseline-shift:baseline;color:#000000;enable-background:accumulate;" d="m 63.748703,971.36229 c -5.43917,0.046 -12.9678,1.9026 -17.33056,4.9688 -5.33006,3.7325 -9.84923,9.9737 -12.23149,20.2812 -1.91437,7.74631 -1.56839,15.38211 1.72054,19.75001 5.65023,-0.3712 12.79569,-0.6555 19.30136,-0.4375 -5.52288,-4.5469 -7.39127,-10.3988 -7.25756,-17.56251 -0.0291,-9.4042 7.41348,-15 14.82795,-15 6.96147,0.06 12.98292,5.6893 12.88842,13 -0.0443,5.72511 -4.66524,9.92801 -9.91658,10.00001 -3.86287,-0.055 -8.81178,-2.1402 -8.91553,-7.00003 0.012,-3.41788 2.27613,-6.76628 5.94369,-6.99998 0.52311,-0.01 1.00104,0.4716 1.00104,1 0,0.5284 -0.47793,1.01 -1.00104,1 -2.58389,0.4032 -3.81164,2.1726 -3.94161,4.99998 0.0869,3.54803 4.10317,4.92403 6.91345,5.00003 4.15393,-0.085 7.88782,-3.7511 7.94578,-8.00001 -0.0251,-5.3606 -4.55816,-11 -10.91762,-11 -6.44788,0 -12.88287,4.6227 -12.85715,12.9688 -0.0323,6.38281 1.10231,13.05131 8.54015,17.68741 10.33074,0.4959 17.71944,1.8254 22.77372,2.625 3.622699,-1.5245 6.11839,-4.1742 7.789365,-8 1.71466,-3.9255 2.5026,-9.064 2.5026,-15.25001 0,-13.3656 -12.517635,-24.0313 -27.778925,-24.0312 z m -45.73514,1 c -1.65858,0 -3.00313,1.3431 -3.00313,3 0,1.6569 1.34455,3 3.00313,3 0.59787,0 1.15869,-0.1992 1.62669,-0.5 1.92801,1.5462 3.44429,3.6637 3.409799,5.9375 -0.0532,2.3056 -1.432899,5.3535 -2.09593,10.1875 -0.37363,-0.053 -0.78261,-0.094 -1.18874,-0.094 -0.58486,0.01 -1.18456,0.1249 -1.81439,0.2813 0.087,-2.7692 -0.50124,-4.9363 -1.34515,-7.0625 -0.88646,-2.2334 -2.73222,-4.4208 -5.91241,-7.5 0.18193,-0.3868 0.31283,-0.7944 0.31283,-1.25 0,-1.6569 -1.3445495,-3 -3.0031295,-3 -1.65858,0 -3.00313,1.3431 -3.00313,3 0,1.6569 1.34455,3 3.00313,3 0.46283,0 0.89106,-0.1257 1.28258,-0.3125 3.0970895,3.0036 4.7355995,4.9984 5.4431695,6.7813 0.74291,1.8716 1.40489,3.8601 1.15746,7 -0.16002,0.067 -0.31086,0.1478 -0.46924,0.2187 -0.89952,8.26371 -0.58523,17.83861 2.47133,25.28131 3.12374,7.606 8.840111,13.0022 19.30135,13.0312 l 57.810216,0 c -0.672391,-1.924 -2.13834,-4.398 -4.410841,-6.7188 -2.40769,-2.4191 -5.888875,-4.6967 -9.635035,-6 -8.34215,-1.2926 -22.74908,-3.8874 -46.07925,-2.2187 -2.51776,-0.2143 -4.76029,-1.7063 -6.06882,-3.6563 -3.74447,-5.5541 -3.29333,-13.0509 -5.25548,-19.75001 -0.18057,-0.1675 -0.39608,-0.3318 -0.65693,-0.4687 0.62315,-4.7755 2.09036,-7.7341 2.1585,-10.6875 -0.1,-3.42 -1.90212,-5.6714 -4.19187,-7.5938 0.0934,-0.2898 0.15641,-0.5852 0.15641,-0.9062 0.0525,-1.7066 -1.59672,-2.9573 -3.00312,-2.9998 z" fill="#000000" fill-opacity="1" stroke="none" marker="none" visibility="visible" display="inline" overflow="visible"/></g></svg>'},makeSprayCanIcon:function(){return'<span><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" style="width:20px;height:12px;" viewBox="0 0 88 88" enable-background="new 0 0 100 100" xml:space="preserve"><path d="M30.292,91.893c-0.277,0-0.552-0.114-0.75-0.338l-2.614-2.956  c-0.366-0.413-0.327-1.046,0.086-1.411c0.414-0.365,1.047-0.327,1.412,0.087l2.614,2.956c0.366,0.413,0.327,1.046-0.086,1.411  C30.764,91.81,30.528,91.893,30.292,91.893z M26.219,85.882c-0.332,0-0.656-0.165-0.847-0.466l-1.656-2.622  c-0.295-0.467-0.155-1.085,0.312-1.38c0.465-0.295,1.084-0.156,1.379,0.312l1.656,2.622c0.295,0.467,0.155,1.085-0.312,1.38  C26.586,85.832,26.402,85.882,26.219,85.882z M10.305,85.543c-0.413,0-0.799-0.257-0.943-0.668L8.17,81.488  c-0.183-0.521,0.091-1.092,0.612-1.275c0.519-0.188,1.092,0.091,1.275,0.611l1.191,3.387c0.183,0.521-0.091,1.092-0.612,1.275  C10.527,85.525,10.415,85.543,10.305,85.543z M84.585,81.594c-0.552,0-1-0.447-1-1v-2.37c0-0.553,0.448-1,1-1s1,0.447,1,1v2.37  C85.585,81.146,85.137,81.594,84.585,81.594z M23.399,79.747c-0.364,0-0.715-0.199-0.892-0.546  c-5.812-11.412-2.957-18.242-0.737-21.298c0.626-0.862,1.326-1.614,2.066-2.26c-0.73-1.527-1.142-3.388-0.999-5.575  c0.398-6.072,3.779-9.768,7.464-11.549c-0.075-0.425-0.104-0.851-0.079-1.273c0.373-6.19,3.492-11.47,9.269-15.692  c0.446-0.325,1.071-0.229,1.397,0.218c0.326,0.445,0.229,1.071-0.217,1.397c-5.273,3.854-8.117,8.631-8.453,14.198  c-0.008,0.129-0.006,0.263,0.004,0.398c0.222-0.067,0.444-0.129,0.665-0.185c3.565-0.885,6.866-0.192,8.028,1.689  c0.469,0.759,0.976,2.358-0.893,4.539c-1.135,1.327-2.825,1.668-4.636,0.935c-1.701-0.688-3.474-2.361-4.438-4.311  c-2.501,1.267-5.737,4.008-6.114,9.766c-0.107,1.637,0.158,3.044,0.651,4.221c2.304-1.447,4.773-1.989,6.625-1.696  c1.512,0.238,2.556,1.021,2.941,2.201c0.958,2.938-0.12,4.43-0.848,5.059c-1.396,1.204-3.763,1.251-6.033,0.122  c-1.153-0.574-2.318-1.482-3.266-2.72c-0.546,0.499-1.059,1.064-1.516,1.693c-3.367,4.637-3.047,11.46,0.901,19.214  c0.25,0.492,0.055,1.095-0.438,1.346C23.707,79.712,23.552,79.747,23.399,79.747z M26.495,56.169  c0.748,0.979,1.662,1.695,2.567,2.146c1.498,0.745,3.075,0.81,3.834,0.153c0.819-0.707,0.51-2.136,0.253-2.925  c-0.18-0.551-0.834-0.764-1.352-0.845C30.364,54.474,28.363,54.982,26.495,56.169z M32.819,39.677  c0.718,1.374,1.986,2.676,3.316,3.213c1.519,0.616,2.158-0.135,2.368-0.381c0.447-0.522,1.134-1.501,0.71-2.188  c-0.581-0.94-2.979-1.512-5.843-0.799C33.215,39.562,33.029,39.611,32.819,39.677z M8.299,77.702c-0.497,0-0.927-0.369-0.991-0.875  L6.76,72.481c-0.069-0.548,0.319-1.048,0.867-1.117c0.546-0.063,1.048,0.318,1.117,0.867l0.548,4.346  c0.069,0.548-0.319,1.048-0.867,1.117C8.383,77.699,8.341,77.702,8.299,77.702z M84.585,75.176c-0.552,0-1-0.447-1-1v-7.112  c0-0.553,0.448-1,1-1s1,0.447,1,1v7.112C85.585,74.729,85.137,75.176,84.585,75.176z M7.632,68.187c-0.552,0-1-0.447-1-1v-4.063  c0-0.553,0.448-1,1-1s1,0.447,1,1v4.063C8.632,67.739,8.185,68.187,7.632,68.187z M84.585,63.322c-0.552,0-1-0.447-1-1V37.405  c0-0.553,0.448-1,1-1s1,0.447,1,1v24.917C85.585,62.875,85.137,63.322,84.585,63.322z M7.658,59.402c-0.009,0-0.018,0-0.027,0  c-0.552-0.016-0.988-0.475-0.973-1.026c0.345-12.844,4.494-18.087,7.337-20.179c0.154-0.413,0.33-0.842,0.53-1.288  c3.832-8.567,13.136-16.174,25.527-20.871c0.517-0.194,1.094,0.064,1.29,0.581s-0.064,1.094-0.581,1.29  c-11.451,4.34-20.123,11.193-23.981,18.909c1.926-0.503,3.74-0.106,4.861,1.103c1.118,1.207,1.284,3.004,0.442,4.807  c-1.462,3.134-4.531,4.828-6.84,3.769c-1.321-0.604-2.312-2.105-2.115-4.675c-2.346,3.048-4.25,8.389-4.471,16.607  C8.643,58.972,8.198,59.402,7.658,59.402z M15.668,39.46c-1.003,3-0.587,4.764,0.406,5.218c1.131,0.513,3.128-0.506,4.196-2.796  c0.5-1.071,0.465-1.995-0.097-2.603c-0.686-0.739-2.026-0.88-3.414-0.357C16.398,39.058,16.033,39.236,15.668,39.46z M44.426,20.661  c-0.358,0-0.705-0.192-0.884-0.531c-0.259-0.487-0.074-1.093,0.414-1.352c1.179-0.627,2.449-1.23,3.774-1.794  c0.51-0.218,1.096,0.021,1.312,0.528c0.216,0.508-0.02,1.096-0.528,1.312c-1.272,0.542-2.49,1.12-3.619,1.72  C44.745,20.624,44.584,20.661,44.426,20.661z M43.329,16.909c-0.403,0-0.784-0.246-0.935-0.646c-0.196-0.517,0.064-1.094,0.581-1.29  c0.439-0.166,0.782-0.279,1.084-0.294c0.085-0.022,0.199-0.055,0.351-0.1c0.527-0.157,1.085,0.147,1.241,0.679  c0.156,0.53-0.148,1.085-0.678,1.241c-0.34,0.1-0.648,0.189-0.925,0.207c-0.085,0.031-0.203,0.076-0.364,0.138  C43.566,16.889,43.447,16.909,43.329,16.909z M55.574,16.296c-0.435,0-0.834-0.285-0.96-0.724c-0.153-0.531,0.154-1.085,0.685-1.237  c0.778-0.224,1.567-0.438,2.365-0.641c0.539-0.138,1.08,0.188,1.216,0.722c0.137,0.535-0.187,1.079-0.722,1.216  c-0.779,0.199-1.548,0.407-2.308,0.625C55.758,16.283,55.665,16.296,55.574,16.296z M48.571,15.53c-0.456,0-0.868-0.313-0.974-0.777  c-0.124-0.538,0.213-1.074,0.751-1.197c1.599-0.366,3.268-0.689,4.961-0.96c0.542-0.093,1.058,0.284,1.146,0.829  c0.087,0.546-0.284,1.059-0.829,1.146c-1.65,0.265-3.276,0.579-4.832,0.935C48.72,15.522,48.645,15.53,48.571,15.53z M61.835,13.657  c-0.522,0-0.962-0.406-0.997-0.935c-0.036-0.552,0.382-1.027,0.933-1.063c0.938-0.061,1.89-0.11,2.857-0.146  c0.543-0.049,1.017,0.409,1.037,0.961c0.021,0.553-0.41,1.017-0.962,1.037c-0.949,0.036-1.883,0.084-2.803,0.145  C61.879,13.656,61.857,13.657,61.835,13.657z M90.627,90.353H60.354c-2.063,0-3.74-1.578-3.74-3.519v-55.19  c0-0.67,0.2-1.297,0.547-1.831c-0.36-0.715-0.547-1.488-0.547-2.153v-1.615c0-1.949,1.587-4.036,3.95-4.036h0.668  c0.846-2.483,2.916-6.444,6.424-6.444h0.961V9.107c0-1.104,0.896-2,2-2h9.747c1.104,0,2,0.896,2,2v6.456h1.303  c3.528,0,5.423,3.941,6.154,6.444h0.243c2.424,0,4.304,2.17,4.304,4.036v1.668c0,0.616-0.217,1.336-0.606,2.014  c0.383,0.552,0.606,1.211,0.606,1.918v55.19C94.368,88.774,92.69,90.353,90.627,90.353z M60.614,86.353h29.753V32.125H60.614V86.353  z M60.795,28.125h29.177c0.135-0.088,0.331-0.344,0.395-0.516v-1.386c-0.081-0.105-0.237-0.216-0.304-0.216h-29.42  c-0.015,0.026-0.027,0.057-0.031,0.077l0.002,1.574C60.624,27.772,60.71,27.991,60.795,28.125z M65.55,22.008h20.043  c-0.534-1.222-1.322-2.444-1.926-2.444h-16.01C67.005,19.563,66.162,20.775,65.55,22.008z M72.618,15.563h5.747v-4.456h-5.747  V15.563z"/>'},makeSettingsIcon:function(opts){return sticker.makeSimplePath($.extend({},!0,opts,{viewBox:[0,0,100,100],d:["M49.71,95c-2.757,0-3.253-2.49-3.871-5.594c-0.733-3.752-2.109-5.723-4.478-6.466    c-0.056-0.018-0.139-0.054-0.214-0.094c-0.562-0.147-1.115-0.307-1.663-0.486c-2.331-0.595-4.53,0.338-7.074,3.036    c-2.354,2.489-4.2,4.437-6.758,2.393l-1.186-0.943c-0.333-0.264-0.585-0.462-2.394-1.91c-0.025-0.018-0.049-0.037-0.073-0.057    c-0.01-0.008-0.02-0.015-0.03-0.023l-2.008-1.615c-0.456-0.368-0.456-0.368-1.456-1.162l-0.12-0.096    c-2.544-2.051-1.06-4.266,0.817-7.071c2.121-3.157,2.54-5.525,1.394-7.735l0.001,0c-0.024-0.048-0.047-0.101-0.066-0.154    c-0.294-0.508-0.566-1.032-0.834-1.552c-1.227-2.076-3.449-2.978-7.166-2.882c-3.442,0.089-6.108,0.155-6.471-3.086l-0.16-1.458    c-0.049-0.451-0.075-0.697-0.345-3.105l0.961-0.217l-0.972,0.109l-0.508-4.569c-0.361-3.253,2.258-3.767,5.575-4.418    c3.736-0.741,5.708-2.121,6.453-4.485c0.015-0.05,0.045-0.118,0.077-0.182c0.133-0.503,0.305-1.122,0.513-1.732    c0.568-2.3-0.366-4.495-3.051-7.035c-2.499-2.37-4.433-4.204-2.394-6.764l2.871-3.585c0.018-0.027,0.046-0.064,0.066-0.089    l2.877-3.583c2.039-2.558,4.261-1.065,7.075,0.827c3.153,2.112,5.524,2.529,7.722,1.38c0.038-0.02,0.087-0.04,0.138-0.058    c0.542-0.31,1.052-0.571,1.571-0.833c2.074-1.219,2.98-3.443,2.882-7.181c-0.09-3.432-0.16-6.087,3.084-6.464l9.241-1.029    c3.239-0.354,3.773,2.269,4.426,5.593c0.725,3.714,2.104,5.686,4.478,6.437c0.056,0.018,0.141,0.056,0.218,0.096    c0.544,0.141,1.092,0.304,1.628,0.473c2.345,0.607,4.551-0.321,7.092-3.028c2.38-2.499,4.214-4.425,6.761-2.394l1.256,1.001    c0.307,0.243,0.642,0.509,2.327,1.858c0.018,0.013,0.035,0.027,0.052,0.042c0.02,0.015,0.038,0.031,0.053,0.043l3.58,2.864    c2.535,2.039,1.069,4.237-0.785,7.021l-0.064,0.096c-2.087,3.111-2.507,5.481-1.361,7.686c0.022,0.042,0.045,0.1,0.065,0.16    c0.26,0.453,0.498,0.918,0.741,1.393l0.021,0.04c0.008,0.012,0.016,0.025,0.023,0.038c1.246,2.152,3.475,3.058,7.215,2.955    c3.451-0.087,6.11-0.156,6.469,3.088l0.506,4.527c0.008,0.041,0.013,0.082,0.016,0.122c0.001,0.011,0.003,0.021,0.004,0.031    l0.134,1.238c0.17,1.562,0.17,1.562,0.235,2.134l0.136,1.196c0,0.002,0,0.004,0,0.006c0.348,3.233-2.248,3.751-5.535,4.407    l-0.1,0.02c-3.676,0.719-5.647,2.096-6.396,4.465c-0.018,0.057-0.06,0.151-0.1,0.229c-0.126,0.489-0.289,1.049-0.469,1.616    c-0.61,2.336,0.321,4.543,3.033,7.107c2.489,2.365,4.424,4.205,2.39,6.755c-0.684,0.853-0.836,1.045-1.038,1.301    c-0.236,0.299-0.541,0.684-1.831,2.297c-0.018,0.023-0.04,0.047-0.062,0.071l-2.883,3.598c-2.032,2.537-4.235,1.07-7.025-0.786    l-0.089-0.059c-3.109-2.091-5.479-2.513-7.687-1.368c-0.039,0.02-0.094,0.043-0.15,0.063c-0.478,0.275-1.001,0.555-1.536,0.818    c-2.089,1.218-3,3.445-2.896,7.188c0.095,3.422,0.169,6.102-3.088,6.466l-1.591,0.182c-0.389,0.046-0.814,0.096-2.977,0.339    c-0.034,0.004-0.069,0.006-0.103,0.006v0c-0.001,0-0.008,0.003-0.041,0.005c-1.837,0.205-2.403,0.266-2.773,0.306    c-0.386,0.042-0.558,0.06-1.752,0.197C50.07,94.99,49.885,95,49.71,95z M42.039,81.104c4,1.332,5.169,5.109,5.704,7.848    c0.741,3.722,1.019,4.213,2.307,4.072c1.195-0.137,1.367-0.155,1.757-0.197c0.372-0.04,0.942-0.102,2.807-0.31    c0.014-0.002,0.028-0.003,0.043-0.004c0.043-0.005,0.093-0.009,0.128-0.009c2.086-0.236,2.511-0.286,2.898-0.331l1.601-0.183    c1.291-0.145,1.455-0.684,1.351-4.438c-0.08-2.851,0.242-6.851,3.927-8.995c0.573-0.285,1.075-0.553,1.569-0.838    c0.056-0.032,0.136-0.066,0.212-0.091c3.785-1.889,7.288-0.046,9.604,1.513l0.085,0.056c3.078,2.049,3.614,2.192,4.415,1.192    l2.875-3.589c0.013-0.016,0.074-0.088,0.088-0.104c0.008-0.009,0.016-0.017,0.024-0.025l0.003-0.003    c1.239-1.552,1.543-1.936,1.778-2.234c0.204-0.258,0.357-0.451,1.045-1.309c0.803-1.006,0.539-1.502-2.173-4.079    c-2.079-1.965-4.673-5.008-3.601-9.104c0.188-0.596,0.345-1.137,0.492-1.692c0.019-0.074,0.066-0.181,0.112-0.267    c1.32-4.013,5.112-5.19,7.86-5.728l0.097-0.019c3.625-0.724,4.11-1.001,3.973-2.277l-0.136-1.191    c-0.066-0.575-0.066-0.575-0.236-2.145l-0.134-1.233c-0.002-0.013-0.003-0.026-0.005-0.039c-0.004-0.024-0.008-0.048-0.011-0.072    l-0.511-4.57c-0.141-1.279-0.675-1.445-4.392-1.349c-2.88,0.083-6.843-0.229-8.992-3.846c-0.029-0.04-0.055-0.082-0.078-0.127    l-0.063-0.123c-0.243-0.475-0.48-0.94-0.744-1.393c-0.036-0.062-0.073-0.151-0.099-0.235c-1.907-3.722-0.053-7.256,1.514-9.59    l0.063-0.094c2.045-3.068,2.19-3.604,1.189-4.409L76.8,16.676c-0.096-0.053-0.175-0.118-0.238-0.192    c-1.56-1.248-1.884-1.505-2.181-1.741l-1.261-1.006c-1.004-0.8-1.499-0.541-4.068,2.157c-3.053,3.252-6.017,4.42-9.104,3.617    c-0.592-0.185-1.151-0.35-1.701-0.49c-0.07-0.018-0.138-0.043-0.203-0.076c-0.019-0.01-0.05-0.028-0.081-0.047    c-4.002-1.32-5.176-5.11-5.712-7.857c-0.73-3.718-1.007-4.21-2.298-4.066l-9.238,1.029c-1.295,0.15-1.447,0.644-1.349,4.399    c0.076,2.885-0.248,6.876-3.9,9.019c-0.584,0.297-1.105,0.564-1.616,0.858c-0.057,0.033-0.136,0.067-0.212,0.093    c-3.699,1.921-7.246,0.064-9.588-1.507c-3.15-2.118-3.691-2.267-4.497-1.257l-2.879,3.586c0.016-0.014-0.011,0.02-0.065,0.088    l-2.87,3.584c-0.806,1.012-0.544,1.507,2.163,4.074c2.071,1.959,4.643,4.975,3.63,9.053c-0.213,0.634-0.373,1.211-0.525,1.786    c-0.019,0.071-0.058,0.165-0.101,0.246c-1.297,3.988-5.099,5.177-7.854,5.724c-3.725,0.731-4.212,1.008-4.07,2.293l0.508,4.568    l0.011,0.108c0.27,2.414,0.297,2.66,0.346,3.111l0.159,1.453c0.143,1.278,0.675,1.441,4.406,1.348    c2.867-0.079,6.849,0.247,8.999,3.893c0.296,0.574,0.57,1.101,0.868,1.609c0.042,0.071,0.074,0.146,0.097,0.225    c1.893,3.754,0.046,7.266-1.514,9.587c-2.112,3.155-2.26,3.697-1.255,4.507l0.114,0.091c1.008,0.8,1.008,0.8,1.468,1.171    l1.993,1.603c0.051,0.033,0.1,0.071,0.144,0.114c1.773,1.419,2.022,1.616,2.352,1.877l1.193,0.949    c1.012,0.809,1.511,0.545,4.099-2.19c1.935-2.052,4.959-4.639,9.06-3.588c0.61,0.198,1.165,0.356,1.729,0.502    c0.057,0.015,0.112,0.034,0.165,0.059C41.954,81.056,41.998,81.08,42.039,81.104z M21.972,84.854c0,0.001,0.002,0.002,0.006,0.005    C21.976,84.858,21.974,84.856,21.972,84.854z M41.9,81.059c0.027,0.008,0.054,0.017,0.08,0.025    C41.956,81.075,41.929,81.066,41.9,81.059z M66.309,77.644c-0.026,0.011-0.054,0.025-0.083,0.043    C66.254,77.673,66.282,77.658,66.309,77.644z M22.277,66.181c0,0,0.001,0.001,0.001,0.002    C22.278,66.182,22.277,66.181,22.277,66.181z M81.071,58.039c-0.004,0.011-0.008,0.024-0.011,0.036    C81.064,58.064,81.068,58.051,81.071,58.039z M92.594,45.606c0,0.001,0,0.001,0.001,0.002    C92.595,45.608,92.595,45.607,92.594,45.606z M92.593,45.605L92.593,45.605L92.593,45.605z M92.502,45.268    c0,0.011,0,0.028,0.003,0.051C92.504,45.301,92.503,45.283,92.502,45.268z M58.046,18.927c0.004,0.001,0.009,0.003,0.013,0.004    C58.055,18.929,58.051,18.928,58.046,18.927z M76.969,16.756C76.969,16.756,76.969,16.756,76.969,16.756    C76.969,16.756,76.969,16.756,76.969,16.756z M76.967,16.755L76.967,16.755L76.967,16.755z M76.965,16.754    C76.965,16.754,76.965,16.755,76.965,16.754C76.965,16.755,76.965,16.754,76.965,16.754z M76.963,16.754    C76.963,16.754,76.963,16.754,76.963,16.754C76.963,16.754,76.963,16.754,76.963,16.754z M76.961,16.753L76.961,16.753    L76.961,16.753z M49.964,65.65c-3.537,0-6.945-1.189-9.747-3.43c-3.266-2.611-5.318-6.337-5.777-10.491    c-0.951-8.579,5.252-16.333,13.827-17.286c4.16-0.464,8.243,0.721,11.506,3.332c3.264,2.612,5.315,6.34,5.777,10.499    c0.462,4.154-0.722,8.24-3.335,11.504s-6.339,5.315-10.492,5.774C51.134,65.617,50.547,65.65,49.964,65.65z M50.025,36.301    c-0.512,0-1.026,0.029-1.543,0.086c-7.503,0.834-12.93,7.62-12.098,15.126c0.402,3.634,2.197,6.893,5.054,9.178    c2.857,2.284,6.433,3.32,10.069,2.916c0,0,0,0,0,0c3.633-0.401,6.893-2.195,9.179-5.051c2.287-2.857,3.323-6.432,2.919-10.066    c-0.405-3.639-2.2-6.902-5.055-9.188C56.099,37.342,53.119,36.301,50.025,36.301z"],fill:opts.color}))},makeNoEntryIcon:function(fill){return'<svg xmlns="http://www.w3.org/2000/svg" data-name="Layer 1" viewBox="0 0 100 100" x="0px" y="0px"><g fill-rule="evenodd" fill="'+fill+'"><path data-name="Compound Path" d="M50,89.11A39.11,39.11,0,1,0,22.33,77.66,39,39,0,0,0,50,89.11ZM72,72a31.17,31.17,0,0,1-41.28,2.42l43.71-43.7A31.17,31.17,0,0,1,72,72ZM28,28a31.16,31.16,0,0,1,40.72-2.86L25.14,68.71A31.17,31.17,0,0,1,28,28Z"/></g></svg>'},makeTrashIcon:function(fill){return'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 24 26" version="1.1" x="0px" y="0px"><g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"><g transform="scale(1.2 1.2) translate(-2 0)"><rect x="0" y="0" width="24" height="24"/><path d="M5,6 L5.73274082,20.8571429 C5.73274082,20.8571429 5.99625939,22 6.98958614,22 L11.598019,22 L12.4359159,22 L17.0443487,22 C18.0380944,22 18.301613,20.8571429 18.301613,20.8571429 L19,6 L5,6 Z M15.5,8 L15.5,8 L15.5,8 C15.2205531,8 14.9908183,8.22036187 14.9791847,8.49956654 L14.5208153,19.5004335 L14.5208153,19.5004335 C14.5097883,19.7650799 14.7153876,19.9885573 14.980034,19.9995842 C14.9866857,19.9998614 14.9933425,20 15,20 L15,20 L15,20 C15.2794469,20 15.5091817,19.7796381 15.5208153,19.5004335 L15.9791847,8.49956654 L15.9791847,8.49956654 C15.9902117,8.23492012 15.7846124,8.01144271 15.519966,8.00041578 C15.5133143,8.00013862 15.5066575,8 15.5,8 Z M9.47918818,19.5003499 L9.02097843,8.49965006 L9.02097843,8.49965006 C9.00934688,8.22039979 8.77957571,8 8.50008331,8 L8.50008331,8 L8.50008331,8 C8.23515945,8 8.02039624,8.21476322 8.02039624,8.47968707 C8.02039624,8.48634356 8.02053479,8.49299933 8.02081182,8.49965006 L8.47902157,19.5003499 L8.47902157,19.5003499 C8.49065312,19.7796002 8.72042429,20 8.99991669,20 L8.99991669,20 L8.99991669,20 C9.26484055,20 9.47960376,19.7852368 9.47960376,19.5203129 C9.47960376,19.5136564 9.47946521,19.5070007 9.47918818,19.5003499 Z M8.00719509,3 L5.11111111,3 L5.11111111,3 C4.49746139,3 4,3.49746139 4,4.11111111 L4,4.11111111 L4,5 L20,5 L20,4.11111111 C20,3.49746139 19.5025386,3 18.8888889,3 L15.9926121,3 C15.9368649,2.4385197 15.4631369,2 14.8869871,2 L9.11301289,2 C8.99358834,2 8.87494478,2.0192532 8.76164871,2.05701856 C8.33332638,2.19979267 8.04982846,2.57814658 8.00719509,3 Z M12,8 C12.2761424,8 12.5,8.22385763 12.5,8.5 L12.5,19.5 C12.5,19.7761424 12.2761424,20 12,20 C11.7238576,20 11.5,19.7761424 11.5,19.5 L11.5,8.5 C11.5,8.22385763 11.7238576,8 12,8 Z" fill="#000000"/></g></g></svg>'},makeCompressTimeIcon:function(fill){return'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" x="0px" y="0px" viewBox="-434 236 90 80" style="enable-background:new -434 236 90 90;" xml:space="preserve"><g fill-rule="evenodd" fill="'+fill+'"><path d="M-354.9,251.1h-5.3h-2.6v2.6v27.8c-0.1-0.3-0.3-0.5-0.5-0.8l-29.1-29.1c-0.5-0.5-1-0.7-1.3-0.5c-0.4,0.2-0.5,0.6-0.5,1.3   v29.1c-0.1-0.3-0.3-0.5-0.5-0.8l-29.1-29.1c-0.5-0.5-1-0.7-1.3-0.5c-0.4,0.2-0.5,0.6-0.5,1.3v60.4c0,0.7,0.2,1.1,0.5,1.3   c0.4,0.2,0.8,0,1.3-0.5l29.1-29.1c0.2-0.2,0.4-0.5,0.5-0.8v29.1c0,0.7,0.2,1.1,0.5,1.3c0.4,0.2,0.8,0,1.3-0.5l29.1-29.1   c0.2-0.2,0.4-0.5,0.5-0.8v27.8v2.6h2.6h5.3h2.6v-2.6v-57.8v-2.6H-354.9z"/></g></svg>'},makeSmallUdacityIcon:function(opts){return'<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" id="Layer_1" x="0px" y="0px" width="'+opts.width+'px" height="'+opts.height+'px" viewBox="0 0 32 32" enable-background="new 0 0 32 32"><image x="0" y="0" href="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAMAAABEpIrGAAAABGdBTUEAALGPC/xhBQAAACBjSFJN AAB6JgAAgIQAAPoAAACA6AAAdTAAAOpgAAA6mAAAF3CculE8AAABOFBMVEUAs+YAsuYKvOkSveo1 xezR8vv6/v6I3PQowuu+7Pn///+V4PUCu+my6Pgdv+u66/ln0/Hv+v31/P531/P9/v8At+j3/f7a 9PxLy+/+//8twuzM8Pv8/v9t1fLt+v3u+v1v1fIAtOeY4fXg9vxKy+6S3/UAuOgAtecAs+f2/P4g v+ut5/d21/NXzvCg4/ZWzvDi9/zT8vs9yO3l+PwAuenc9fuX4fWG3PPC7frD7fpHyu4zxez7/v84 xu3s+f0MvOp42POo5fdUzu/U8vxZz/CR3/Wr5vfS8vvn+P0rw+wPvOokwOv5/f606fgAuunX8/xr 1PLQ8ftSze8AtugnwuuU4PUEu+nW8/yJ3PQYv+qQ3/TP8fuq5vfh9vzB7fq/7Pn0/P5w1fI3xu2s 5/fm+PyN3vQ5x+0xxOwxFuTVAAAAAWJLR0QKaND0VgAAAAlwSFlzAAAWJQAAFiUBSVIk8AAAAAd0 SU1FB+IKHAUqGL3rdjoAAAFBSURBVDjL5dPZUsIwFAbgBMTqj6BiF0FcsGLdEaniUtwVVMR93/f3 fwPbkpS0Os5wbW7Sk/NN0ov/EEL/XIQ0AUgo0Az7QUukVRLbbe2ICqAjBns12vHOes0A6epGokf2 gCKp0HqTHkj1AbEQTXPQP4DBoQz1wLAMfcQ+9wCQHbU3DwCSQf3ArQUwRv8RUINgPAB0TIhAgRYA k5gSwTRmGEgj457nMOt+EBeQPOYYKMCsR2oeC85uwn6cFrHIE7WE5frVKxaydl1CnpJicnWNg3Vs sN/ftLC1bexgN1dGZc8L7b4lHzBR0oGq5aTtsCakOoojhQnj+MRpF059sT8rIxLmeTyvQL7gnof2 8grq9Y07C7dV3KV+Do5yb9/78PikAc8v4rA1Buf1LeE8/v5h+qZLHD0j/vlVo4HV1PD+Dr4BCLwn yyZy1tMAAAAldEVYdGRhdGU6Y3JlYXRlADIwMTgtMTAtMjhUMTI6NDI6MjQtMDc6MDC16UJJAAAA JXRFWHRkYXRlOm1vZGlmeQAyMDE4LTEwLTI4VDEyOjQyOjI0LTA3OjAwxLT69QAAAABJRU5ErkJg gg==" width="32" height="32"></image></svg>'},makeLabelHtml:function(opts){var dimensions=opts.dimensions,labelAttr={style:"width:"+dimensions.width+"px;height:"+dimensions.height+"px;left:"+dimensions.x+"px;top:"+dimensions.y+"px;opacity:"+opts.opacity+";color:"+opts.color+";padding-top:10px;"};return'<div class="graffiti-sticker-inner">'+sticker.makeElementHtml("div",labelAttr,"<div>"+opts.label+"</div>")+"</div>"},makeHomeFolderIcon:function(opts){return'<svg xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns="http://www.w3.org/2000/svg" xmlns:cc="http://creativecommons.org/ns#" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:dc="http://purl.org/dc/elements/1.1/" version="1.1" x="0px" y="0px" viewBox="10 10 75 75"><g transform="translate(0,-952.36218)"><path style="baseline-shift:baseline;block-progression:tb;color:#000000;direction:ltr;text-indent:0;enable-background:accumulate;text-transform:none;" fill="#000" d="m13.812,968.89c-0.51636,0.005-0.86248,0.14455-1.0312,0.28125-0.16877,0.1367-0.25,0.26805-0.25,0.65625v3.8125,1h-1-1.5312c-0.41876,0.003-0.66765,0.1155-0.8125,0.25-0.13976,0.1297-0.2422,0.34985-0.25,0.78125,0.000058,0.017-0.000057,0.0143,0,0.0312,0.0088,2.6282,0.0011,3.3996,0,4.8438h82.125v-4.875c0-0.4119-0.12605-0.606-0.28125-0.75s-0.3925-0.29125-0.875-0.28125h-0.03125-44.562-1v-1-3.7188c0-0.4015-0.08843-0.6006-0.25-0.75s-0.44128-0.28125-0.875-0.28125h-29.375zm-5.4688,13.656c-0.050524,0.004-0.098821,0.0172-0.15625,0.0312-0.064504,0.012-0.13338,0.0425-0.1875,0.0625-0.34403,0.1268-0.49236,0.38875-0.5,0.78125-0.000232,0.012,0,0.0193,0,0.0312l1.7812,51.437a1.0001,1.0001,0,0,1,0,0.062c0,0.1465,0.079205,0.3075,0.34375,0.5,0.26454,0.1926,0.71304,0.3438,1.0938,0.3438l79.031,0.031a1.0001,1.0001,0,0,1,0.03125,0c0.56827,0.011,0.65633-0.094,0.65625-0.094-0.00008,0.0001,0.10538-0.1587,0.09375-0.7188a1.0001,1.0001,0,0,1,0,-0.062l1.97-51.44c0-0.012,0.000232-0.0192,0-0.0312-0.0077-0.3976-0.14181-0.6885-0.5-0.8125h-0.03125c-0.11803-0.036-0.27448-0.0625-0.4375-0.0625h-0.03125-83.031a1.0001,1.0001,0,0,1,-0.0625,0c-0.023769,0.0009-0.039804,0-0.0625,0zm41.656,8.375,20.219,20.219-3.9062,3.9375-3.2812-3.2812,0,15.656-10.438,0,0-7.8125c0-1.4454-1.1484-2.625-2.5938-2.625s-2.625,1.1796-2.625,2.625v7.8125h-10.438v-15.656l-3.25,3.2812-3.9062-3.9375,20.22-20.18zm7.8125,2.625,5.2188,0,0,7.1562-5.2188-5.2187,0-1.9375z"/></g></svg>'},makeLabelSvg:function(opts){var dimensions=opts.dimensions,buffer=opts.buffer||4,viewBoxRaw="0 0 "+dimensions.width+" "+dimensions.height,viewBox=sticker.makeBufferedViewBox({buffer:buffer,bufferAllSides:!0,viewBox:viewBoxRaw}),shapeObj={x:0,y:16,text:opts.label,"font-size":18,width:dimensions.width,height:dimensions.height,stroke:opts.color,fill:opts.color,dashed:opts.dashed,"stroke-width":opts.strokeWidth,"fill-opacity":opts.fillOpacity};sticker.interpretDashing(opts,shapeObj);var theLabel=sticker.makeSvgElement("text",shapeObj),parmBlock={el:theLabel,x:dimensions.x,y:dimensions.y,width:dimensions.width,height:dimensions.height,viewBox:viewBox};return sticker.renderSvg([parmBlock])},makeCustom:function(opts){var dimensions=opts.dimensions,customHtml='<img src="'+opts.imageUrl+'" style="width:'+dimensions.width+"px;height:"+dimensions.height+"px;top:"+dimensions.y+"px;left:"+dimensions.x+"px;opacity:1.0;";return void 0!==opts.cssTransform&&(customHtml+="transform:"+opts.cssTransform),customHtml+='">'}};return sticker.minBracketWidth=6,sticker}),define("js/selectionSerializer.js",[],function(){return{clearWindowSelection:function(){window.getSelection?window.getSelection().empty?window.getSelection().empty():window.getSelection().removeAllRanges&&window.getSelection().removeAllRanges():document.selection&&document.selection.empty()},get:function(referenceNode){referenceNode=referenceNode||document.body;var sel=window.getSelection(),range=sel.rangeCount?sel.getRangeAt(0).cloneRange():document.createRange(),startContainer=range.startContainer,startOffset=(startContainer.parentNode,range.startOffset),state={content:range.toString()};return range.selectNodeContents(referenceNode),range.setEnd(startContainer,startOffset),state.start=range.toString().length,state.end=state.start+state.content.length,{state:state,empty:state.start===state.end}},restore:function(selectionSerialized){var referenceNode=selectionSerialized.referenceNode||document.body,state=selectionSerialized.state,currentNodeCharIndex=0,nodes=[referenceNode],sel=window.getSelection();sel.rangeCount>0&&sel.removeAllRanges();var node,nextNodeCharIndex,range=document.createRange();for(range.setStart(referenceNode,0),range.collapse(!0);node=nodes.pop();)if(3===node.nodeType){if(nextNodeCharIndex=currentNodeCharIndex+node.length,state.start>=currentNodeCharIndex&&state.start<=nextNodeCharIndex&&range.setStart(node,state.start-currentNodeCharIndex),state.end>=currentNodeCharIndex&&state.end<=nextNodeCharIndex){range.setEnd(node,state.end-currentNodeCharIndex);break}currentNodeCharIndex=nextNodeCharIndex}else for(var i=node.childNodes.length;i--;)nodes.push(node.childNodes[i]);return sel.addRange(range),sel}}}),define("js/workspace.js",["js/state.js"],function(state){function getToken(){var kernelName=Jupyter.notebook.kernel.name,executeCallbackObject=function(callback){return{iopub:{output:function(data){var tokenText="";"ir"===kernelName?(tokenText=data.content.data&&data.content.data["text/html"],tokenText=tokenText.replace(/'/g,"")):tokenText=data.content.text,tokenText&&callback(tokenText)}}}};return new Promise(function(resolve,reject){var gcloudMetadaUrl="http://metadata.google.internal/computeMetadata/v1/instance/attributes/keep_alive_token",bashCommand="",execOptions={};"ir"===kernelName?(bashCommand="system('curl \"".concat(gcloudMetadaUrl,'" -H "Metadata-Flavor: Google" -s --fail\', intern=TRUE)'),execOptions={silent:!1
}):bashCommand='!curl "'.concat(gcloudMetadaUrl,'" -H "Metadata-Flavor: Google" -s --fail'),Jupyter.notebook.kernel.execute(bashCommand,executeCallbackObject(function(output){return resolve(output)}),execOptions)})}function _getWorkspace(token){return new Promise(function(resolve,reject){var xhr=new XMLHttpRequest;xhr.open("POST","".concat(NEBULA_URL,"/api/v1/remote/me")),xhr.setRequestHeader("Authorization","Star "+token),xhr.onload=function(){this.status>=200&&this.status<300?resolve(JSON.parse(xhr.response)):reject({status:this.status,statusText:xhr.statusText})},xhr.onerror=function(){reject({status:this.status,statusText:xhr.statusText})},xhr.send()})}var NEBULA_URL="https://nebula.udacity.com",workspace={token:null,usageReportSent:!1,getWorkspace:function(){return workspace.isUdacityEnv()?getToken().then(function(token){return workspace.token=token,_getWorkspace(token)}):Promise.resolve({userId:"dev",coco:!0})},isUdacityEnv:function(){var hostname=location.hostname;return hostname.endsWith("udacity.com")||hostname.endsWith("udacity-student-workspaces.com")},setWorkspace:function(){return workspace.getWorkspace().then(function(data){state.setUserId(data.userId),state.setWorkspace(data)}).catch(function(err){return console.error(err)})},trackUsageStats:function(){if(!workspace.usageReportSent&&workspace.isUdacityEnv()&&navigator.sendBeacon){var stats=state.getUsageStats();stats.workspace=state.getWorkspace(),navigator.sendBeacon("".concat("https://bellatrix.udacity.com","/api/v1/graffiti/stats"),JSON.stringify(stats)),workspace.usageReportSent=!0}}};return workspace}),define("js/graffiti.js",["base/js/dialog","base/js/events","notebook/js/textcell","js/LZString.js","js/state.js","js/utils.js","js/audio.js","js/storage.js","js/sticker.js","js/localizer.js","js/selectionSerializer.js","js/workspace.js","js/terminals.js","js/batchRunner.js","components/marked/lib/marked"],function(dialog,events,textCell,LZString,state,utils,audio,storage,stickerLib,localizer,selectionSerializer,workspace,terminalLib,batchRunner,marked){return function(){var _arguments=arguments,graffiti={init:function(){console.log("Graffiti: Main constructor running."),utils.loadCss(["/nbextensions/jupytergraffiti/graffiti.css","/nbextensions/jupytergraffiti/xterm.css"]);var currentAccessLevel=(document.location,state.getAccessLevel());graffiti.LZString=LZString,graffiti.rewindAmt=1,graffiti.rewindSkipEditAmt=.05,graffiti.CMEvents={},graffiti.halfBullseye=12,graffiti.sitePanel=$("#site"),graffiti.notebookPanel=$("#notebook"),graffiti.notebookContainer=$("#notebook-container"),graffiti.notebookContainerPadding=parseInt(graffiti.notebookContainer.css("padding").replace("px","")),graffiti.penColor="black",graffiti.recordingIntervalMs=10,graffiti.playbackIntervalMs=graffiti.recordingIntervalMs,graffiti.highlightMarkText=void 0,graffiti.cmLineHeight=17.0001,graffiti.cmLineFudge=8,graffiti.cmLineTipFudge=6,graffiti.tipAboveFudge=14,graffiti.tokenRanges={},graffiti.canvases={permanent:{},temporary:{}},graffiti.stickers={permanent:{},temporary:{}},graffiti.lastUpdateControlsTime=utils.getNow(),graffiti.notificationMsgs={},graffiti.panelFadeTime=350,graffiti.windowSizeCheckInterval=250,graffiti.windowSizeChangeTime=void 0,graffiti.skipKeyDownTimer=void 0,graffiti.skipKeyCode=18,graffiti.scrollNudgeSmoothIncrements=6,graffiti.scrollNudgeQuickIncrements=4,graffiti.scrollNudge=void 0,graffiti.penColors={black:"000000",white:"ffffff",red:"ff0000",green:"00ff00",blue:"0000ff",yellow:"ffff00",orange:"ff9900",purple:"8a2be2",brown:"996600"},graffiti.minimumStickerSize=20,graffiti.minimumStickerSizeWithBuffer=graffiti.minimumStickerSize+10,graffiti.previousActiveTakeId=void 0,graffiti.forcedGraffitiTooltipRefresh=!1,graffiti.MarkdownCell=textCell.MarkdownCell,"create"===currentAccessLevel&&(storage.ensureNotebookGetsGraffitiId(),storage.ensureNotebookGetsFirstAuthorId()),localizer.init().then(function(){graffiti.initSetupButton(),Jupyter.notebook.metadata.hasOwnProperty("graffiti")&&storage.loadManifest(currentAccessLevel).then(function(){utils.createApiSymlink(),graffiti.initInteractivity()}).catch(function(ex){console.log("Graffiti: Not setting up Graffiti because this notebook has never had any authoring done yet (no recordingId)."),console.log(ex)})})},provideAPIKeyExamples:function(){var recorderApiKeyCell=Jupyter.notebook.insert_cell_below("code"),invocationLine="# Graffiti Id: "+graffiti.recordingAPIKey+"\n\n# --------------------------------------\nimport jupytergraffiti\n# jupytergraffiti.api.play_recording('"+graffiti.recordingAPIKey+"')\n# jupytergraffiti.api.play_recording_with_prompt('"+graffiti.recordingAPIKey+"', '![idea](../images/lightbulb_small.jpg) Click **here** to learn more.')\n# jupytergraffiti.api.stop_playback()\n# jupytergraffiti.api.remove_unused_takes('"+graffiti.recordingAPIKey+"')\n# jupytergraffiti.api.remove_all_unused_takes()\n";recorderApiKeyCell.set_text(invocationLine),Jupyter.notebook.select_next(),recorderApiKeyCell.code_mirror.focus()},changeDataDir:function(){var confirmationCell=Jupyter.notebook.insert_cell_at_index("markdown",0);Jupyter.notebook.select(0),confirmationCell.set_text('<button id="graffiti-confirm-datapath">Confirm</button>');var pathCell=Jupyter.notebook.insert_cell_at_index("code",0),oldDataDir=utils.getNotebookGraffitiConfigEntry("dataDir");void 0===oldDataDir&&(oldDataDir="jupytergraffiti_data/"),pathCell.set_text(oldDataDir);var instructionsCell=Jupyter.notebook.insert_cell_at_index("markdown",0);instructionsCell.select();var instructions=localizer.getString("DATA_PATH_INSTRUCTIONS");Jupyter.notebook.select(0),instructionsCell.set_text(instructions),setTimeout(function(){instructionsCell.render(),confirmationCell.render(),pathCell.focus_cell(),graffiti.confirmDataPathButton=$("#graffiti-confirm-datapath"),graffiti.confirmDataPathButton.bind("click",function(){var newPathAccepted=!1,newDataDir=$.trim(pathCell.get_text());newDataDir.length>0&&("/"!==newDataDir[newDataDir.length-1]&&(newDataDir+="/"),newDataDir!==oldDataDir&&(utils.setNotebookGraffitiConfigEntry("dataDir",newDataDir),newPathAccepted=!0)),graffiti.confirmDataPathButton.unbind("click"),Jupyter.notebook.delete_cell(0),Jupyter.notebook.delete_cell(0),Jupyter.notebook.delete_cell(0),utils.queueSaveNotebookCallback(function(){if(newPathAccepted){dialog.modal({title:localizer.getString("ACCEPTED_DATADIR_HEADER"),body:localizer.getString("ACCEPTED_DATADIR_BODY"),sanitize:!1,buttons:{OK:{click:function(e){console.log("Graffiti: Path change acknowledged.")}}}})}}),utils.saveNotebookDebounced()})},10)},bindControlPanelCallbacks:function(parent,callbacks){if(void 0!==callbacks){var cb,id,_iteratorNormalCompletion=!0,_didIteratorError=!1,_iteratorError=void 0;try{for(var _step,_iterator=callbacks[Symbol.iterator]();!(_iteratorNormalCompletion=(_step=_iterator.next()).done);_iteratorNormalCompletion=!0){cb=_step.value;var _iteratorNormalCompletion2=!0,_didIteratorError2=!1,_iteratorError2=void 0;try{for(var _step2,_iterator2=cb.ids[Symbol.iterator]();!(_iteratorNormalCompletion2=(_step2=_iterator2.next()).done);_iteratorNormalCompletion2=!0)id=_step2.value,parent.find("#"+id).on(cb.event,cb.fn)}catch(err){_didIteratorError2=!0,_iteratorError2=err}finally{try{_iteratorNormalCompletion2||null==_iterator2.return||_iterator2.return()}finally{if(_didIteratorError2)throw _iteratorError2}}}}catch(err){_didIteratorError=!0,_iteratorError=err}finally{try{_iteratorNormalCompletion||null==_iterator.return||_iterator.return()}finally{if(_didIteratorError)throw _iteratorError}}}},setNotifier:function(notificationMsg,callbacks){var notifierPanel=graffiti.controlPanelIds["graffiti-notifier"];if(notifierPanel.show().children().hide(),!graffiti.notificationMsgs.hasOwnProperty(notificationMsg)){var notificationId="graffiti-notification-"+utils.generateUniqueId();$('<div id="'+notificationId+'">'+notificationMsg+"</div>").appendTo(notifierPanel);var newNotificationDiv=notifierPanel.find("#"+notificationId);graffiti.notificationMsgs[notificationMsg]=newNotificationDiv,graffiti.bindControlPanelCallbacks(newNotificationDiv,callbacks)}graffiti.notificationMsgs[notificationMsg].show()},setJupyterMenuHint:function(hint,classOverride){if(void 0===graffiti.jupyterMenuHint){var jupyterMainToolbar=$("#maintoolbar-container"),menuHintDiv=$('<span class="graffiti-jupyter-menu-hint-shell"></span>');graffiti.jupyterMenuHint=menuHintDiv.appendTo(jupyterMainToolbar)}var override=void 0!==classOverride?classOverride:"",hintHtml='<span class="graffiti-jupyter-menu-hint '+override+'">'+hint+"</span>";graffiti.jupyterMenuHint.html(hintHtml).show()},clearJupyterMenuHint:function(){void 0!==graffiti.jupyterMenuHint&&graffiti.jupyterMenuHint.hide()},cleanUpButtonBorders:function(){$(".graffiti-highlight:has(button)").css({border:"none"})},startPanelDragging:function(e){var controlPanelPosition=graffiti.outerControlPanel.position(),pointerPosition=state.getPointerPosition();state.setControlPanelDragging(!0),state.setControlPanelDragOffset({left:pointerPosition.x-controlPanelPosition.left,top:pointerPosition.y-controlPanelPosition.top}),e.preventDefault(),e.stopPropagation()},toggleRecordingSkip:function(){if("recording"!==state.getActivity())return void state.stopSkipping();state.toggleSkipping(),state.isSkipping()?$("#graffiti-btn-end-recording").html(localizer.getString("RECORDING_HINT_4")):$("#graffiti-btn-end-recording").html(localizer.getString("RECORDING_HINT_1"))},createGraffitizedMarkdown:function(cell,markdown,tooltipCommands,tooltipDirectives){var recordingKey=utils.generateUniqueId(),cellId=utils.getMetadataCellId(cell.metadata),recordingRecord=$.extend(!0,{cellId:cellId,cellType:"markdown",createDate:utils.getNow(),inProgress:!1,tokens:$.extend({},graffiti.selectedTokens.tokens),range:$.extend({},graffiti.selectedTokens.range),allTokensString:graffiti.selectedTokens.allTokensString,markdown:tooltipDirectives.join("\n")+"\n",authorId:state.getAuthorId(),authorType:state.getAuthorType(),activeTakeId:void 0,takes:{},hasMovie:!0},tooltipCommands);return state.setSingleManifestRecording(cellId,recordingKey,recordingRecord),storage.storeManifest(),{recordingKey:recordingKey,markdown:'<span class="graffiti-highlight graffiti-'+cellId+"-"+recordingKey+'"><i></i>'+markdown+"</span>"}},createGraffitiButtonAboveSelectedCell:function(opts){var selectedCellIndex=Jupyter.notebook.get_selected_index(),selectedCell=Jupyter.notebook.get_selected_cell(),buttonCell=Jupyter.notebook.insert_cell_above("markdown",selectedCellIndex),buttonCellId=utils.getMetadataCellId(buttonCell.metadata),buttonCellIndex=utils.findCellIndexByCellId(buttonCellId);Jupyter.notebook.select(buttonCellIndex),buttonCell.code_mirror.execCommand("selectAll");var params={cell:buttonCell,clear:!0};graffiti.refreshGraffitiHighlights(params),graffiti.selectedTokens=utils.findSelectionTokens(buttonCell,graffiti.tokenRanges,state);var buttonLabel="Graffiti Sample Button (edit me)",tooltipCommands={autoPlay:"never",playOnClick:!0,hideTooltip:!0,narratorName:void 0,narratorPicture:void 0,stickerImageUrl:void 0,silenceWarnings:!0},tooltipDirectives=["%%play_on_click","%%hide_tooltip","%%button_name No Movie Here Yet","Edit this markdown cell to customize the Graffiti for this button, and to record a new movie.<br><br>_(NB: The default movie that was created with this button is a *placeholder* and it will *not* play.)_"];void 0!==opts&&(void 0!==opts.tooltipCommands&&($.extend(tooltipCommands,opts.tooltipCommands),opts.tooltipCommands.hasOwnProperty("labelSwaps")&&(buttonLabel=opts.tooltipCommands.labelSwaps[0])),void 0!==opts.tooltipDirectives&&_.uniq($.merge(tooltipDirectives,opts.tooltipDirectives)));var rawButtonMarkdown="<button>"+buttonLabel+"</button>",graffitizedData=graffiti.createGraffitizedMarkdown(buttonCell,rawButtonMarkdown,tooltipCommands,tooltipDirectives);buttonCell.set_text(graffitizedData.markdown),buttonCell.render();var finalCell=buttonCell;if("markdown"===selectedCell.cell_type){var selectedCellContents=selectedCell.get_text(),tagsRe=utils.createGraffitiTagRegex();if(match=tagsRe.exec(selectedCellContents),null!==match){var newContents=selectedCellContents+"\n"+graffitizedData.markdown;selectedCell.set_text(newContents),Jupyter.notebook.delete_cell(buttonCellIndex),utils.rerenderMarkdownCell(selectedCell),finalCell=selectedCell}}return graffiti.refreshAllGraffitiHighlights(),graffiti.refreshGraffitiTooltips(),finalCell},createTerminalSuiteAboveSelectedCell:function(){graffiti.setJupyterMenuHint(localizer.getString("INSERT_TERMINAL_SUITE_STATUS"));var terminalSuite={},selectedCellIndex=Jupyter.notebook.get_selected_index(),codeCell=Jupyter.notebook.insert_cell_above("code",selectedCellIndex),codeCommentString=utils.getCodeCommentString();codeCell.set_text(codeCommentString+"\n"+codeCommentString+" Paste code here. It will execute the graffiti associated with the button when shift-enter is pressed.\n"+codeCommentString+"\n"),terminalSuite.codeCellId=utils.getMetadataCellId(codeCell.metadata);var terminalCell=terminalLib.createTerminalCellAboveSelectedCell(selectedCellIndex+1);terminalSuite.terminalCellId=terminalCell.term.id;var buttonCell=Jupyter.notebook.insert_cell_below("markdown",selectedCellIndex+1),buttonCellId=utils.getMetadataCellId(buttonCell.metadata),buttonCellIndex=utils.findCellIndexByCellId(buttonCellId);Jupyter.notebook.select(buttonCellIndex),buttonCell.code_mirror.execCommand("selectAll");var params={cell:buttonCell,clear:!0};graffiti.refreshGraffitiHighlights(params),graffiti.selectedTokens=utils.findSelectionTokens(buttonCell,graffiti.tokenRanges,state);var tooltipCommands={autoPlay:"never",playOnClick:!0,hideTooltip:!0,narratorName:void 0,narratorPicture:void 0,stickerImageUrl:void 0,saveToFile:[{cellId:terminalSuite.codeCellId,path:"./graffiti_sample.txt"}],terminalCommand:{terminalId:terminalSuite.terminalCellId,command:"cat ./graffiti_sample.txt"}},tooltipDirectives=["%%play_on_click","%%hide_tooltip","%%save_to_file "+terminalSuite.codeCellId+' "'+tooltipCommands.saveToFile[0].path+'"',"%%terminal_command "+terminalSuite.terminalCellId+' "'+tooltipCommands.terminalCommand.command+'"'],graffitizedData=graffiti.createGraffitizedMarkdown(buttonCell,"<button>Run Code</button>",tooltipCommands,tooltipDirectives);buttonCell.set_text(graffitizedData.markdown),buttonCell.render(),terminalSuite.buttonCellId=utils.getMetadataCellId(buttonCell.metadata);var targetGraffitiId=utils.composeGraffitiId(terminalSuite.buttonCellId,graffitizedData.recordingKey);return utils.setCellGraffitiConfigEntry(codeCell,"executeCellViaGraffiti",targetGraffitiId),graffiti.refreshAllGraffitiHighlights(),graffiti.refreshGraffitiTooltips(),graffiti.clearJupyterMenuHint(),state.refreshCellIdToGraffitiMap(),graffiti.executeSaveToFileDirectives(terminalSuite.codeCellId),terminalSuite},setupOneControlPanel:function(elemId,elemHtml,callbacks){void 0===graffiti.controlPanelIds&&(graffiti.controlPanelIds={});var fullHtml='<div class="graffiti-control-panel" id="'+elemId+'">'+elemHtml+"</div>";$(fullHtml).appendTo(graffiti.controlPanelsShell),graffiti.controlPanelIds[elemId]=graffiti.controlPanelsShell.find("#"+elemId),graffiti.bindControlPanelCallbacks(graffiti.controlPanelIds[elemId],callbacks)},setupPlaybackCursor:function(){var iconConfiguration={dimensions:{x:0,y:0,width:36,height:36},color:"black",innerRingsColor:"#eee",strokeWidth:2,strokeOpacity:1,fillOpacity:0},bullsEye=stickerLib.makeBullsEye(iconConfiguration);$('<div id="graffiti-cursor" name="cursor" class="graffiti-cursor">  <div id="graffiti-cursor-normal-cells">'+bullsEye+'</div>  <div id="graffiti-cursor-terminal-cells"></div></div>').appendTo(header)},setupControlPanels:function(){var previousPlayState;if(0==$("#graffiti-outer-control-panel").length){$('<div id="graffiti-outer-control-panel">  <div id="graffiti-inner-control-panel">    <div class="graffiti-small-dot-pattern" id="graffiti-drag-handle">&nbsp;&nbsp;</div>    <div id="graffiti-control-panels-shell"></div>  </div></div>').appendTo($("body")),graffiti.setupPlaybackCursor()}graffiti.graffitiCursorShell=$("#graffiti-cursor"),graffiti.graffitiNormalCursor=$("#graffiti-cursor-normal-cells"),graffiti.graffitiTerminalCursor=$("#graffiti-cursor-terminal-cells"),graffiti.outerControlPanel=$("#graffiti-outer-control-panel"),graffiti.outerControlPanel.hide(),graffiti.controlPanelsShell=$("#graffiti-control-panels-shell"),$("body").on("mouseup",function(e){state.getControlPanelDragging()&&(console.log("Graffiti: no longer dragging control panel"),state.setControlPanelDragging(!1),e.preventDefault(),e.stopPropagation())});graffiti.setupOneControlPanel("graffiti-control-panel-title","<div>"+stickerLib.makeSmallUdacityIcon({width:20,height:20})+'</div><div id="graffiti-logo-text">graffiti</div>'),$("#graffiti-inner-control-panel").on("mousedown",function(e){"graffiti-recorder-range"!==$(e.target).attr("id")&&graffiti.startPanelDragging(e)}),graffiti.windowResizeHandler=function(opts){if(void 0===opts||void 0!==opts&&opts.force){if(graffiti.resizeCanvases(),terminalLib.refitAllTerminals(),graffiti.outerControlPanel.is(":visible")){graffiti.placeControlPanel({keepInView:!0}),state.setControlPanelDragging(!1);var activity=state.getActivity();"playing"!==activity&&"playbackPaused"!==activity||(graffiti.wipeAllStickerDomCanvases(),graffiti.redrawAllDrawings())}graffiti.refreshAllGraffitiSideMarkers()}},graffiti.notebookContainerWidth=graffiti.notebookContainer.width(),graffiti.performWindowResizeCheck=function(){var newWidth=graffiti.notebookContainer.width(),newHeight=$(window).height();if(newWidth!==graffiti.notebookContainerWidth||newHeight!==graffiti.notebookContainerHeight){graffiti.notebookContainerWidth=newWidth,graffiti.notebookContainerHeight=newHeight;var now=utils.getNow();void 0===graffiti.windowSizeChangeTime?(graffiti.windowResizeHandler(),graffiti.windowSizeChangeTime=now):now-graffiti.windowSizeChangeTime>100&&(graffiti.windowResizeHandler(),graffiti.windowSizeChangeTime=now)}setTimeout(graffiti.performWindowResizeCheck,graffiti.windowSizeCheckInterval)},setTimeout(graffiti.performWindowResizeCheck,graffiti.windowSizeCheckInterval);var iconConfiguration={dimensions:{x:0,y:0,width:8,height:8},color:"black",strokeWidth:1,fillOpacity:0},settingsIcon=stickerLib.makeSettingsIcon(iconConfiguration),iconDimensions={x:6,y:6,width:16,height:16},largeIconDimensions={x:2,y:2,width:24,height:24},defaultIconConfiguration={dimensions:iconDimensions,color:"#666",iconUsage:!0,strokeWidth:1,fillOpacity:0},solidIconConfiguration=$.extend({},defaultIconConfiguration,{fillOpacity:1}),solidFatIconConfiguration=$.extend({},!0,solidIconConfiguration,{strokeWidth:2}),largeIconConfiguration=$.extend({},!0,defaultIconConfiguration,{buffer:1,dimensions:largeIconDimensions}),roundRectConfiguration=$.extend({},!0,largeIconConfiguration,{rx:6,ry:6}),bullsEyeConfiguration=$.extend({},!0,largeIconConfiguration,{innnerRingsColor:"#000"});graffiti.setupOneControlPanel("graffiti-record-controls",'  <button class="btn btn-default" id="graffiti-create-btn" title="'+localizer.getString("CREATE_1")+'"><i class="fa fa-edit"></i>&nbsp; <span>'+localizer.getString("CREATE_1")+'</span></button>  <button class="btn btn-default" id="graffiti-edit-btn" title="'+localizer.getString("EDIT_TOOLTIP")+'">  <span style="position:absolute;margin-top:4px;margin-left:2px;">'+settingsIcon+'</span>   <span style="padding-left:16px;">'+localizer.getString("EDIT")+'</span></button>  <button class="btn btn-default" id="graffiti-begin-recording-btn" title="'+localizer.getString("RECORD_MOVIE")+'"><i class="fa fa-film graffiti-recorder-button"></i>&nbsp;<span>'+localizer.getString("RECORD")+'</span></button>  <button class="btn btn-default" id="graffiti-begin-rerecording-btn" title="'+localizer.getString("RERECORD_MOVIE")+'"><i class="fa fa-film graffiti-recorder-button"></i>&nbsp;<span>'+localizer.getString("RERECORD")+'</span></button>  <button class="btn btn-default" id="graffiti-remove-btn" title="'+localizer.getString("REMOVE_GRAFFITI")+'"><i class="fa fa-trash"></i></button>',[{ids:["graffiti-create-btn","graffiti-edit-btn"],event:"click",fn:function(e){graffiti.editGraffiti()}},{ids:["graffiti-begin-recording-btn","graffiti-begin-rerecording-btn"],event:"click",fn:function(e){graffiti.beginMovieRecordingProcess()}},{ids:["graffiti-remove-btn"],event:"click",fn:function(e){graffiti.removeGraffitiWithPrompt()}}]),graffiti.setupOneControlPanel("graffiti-finish-edit-controls",'<button class="btn btn-default" id="finish-graffiti-btn" title="'+localizer.getString("SAVE_GRAFFITI")+'">'+localizer.getString("SAVE_GRAFFITI")+"</button>",[{ids:["finish-graffiti-btn"],event:"click",fn:function(e){graffiti.finishGraffiti(!0)}}]),graffiti.setupOneControlPanel("graffiti-start-recording-controls",'<button class="btn btn-default" id="btn-start-recording" title="'+localizer.getString("START_RECORDING")+'"><i class="fa fa-pause recorder-start-button"></i>&nbsp;'+localizer.getString("START_RECORDING")+"</button>",[{ids:["btn-start-recording","btn-restart-recording"],event:"click",fn:function(e){graffiti.finishGraffiti(!0)}}]),graffiti.setupOneControlPanel("graffiti-recording-controls",'<div id="graffiti-recording-button-help-shell">  <div id="graffiti-btn-end-recording" class="graffiti-recording-button-help">'+localizer.getString("RECORDING_HINT_1")+'  </div>  <div class="graffiti-recording-button-help">    <div>'+localizer.getString("RECORDING_HINT_2")+"</div>    <div>"+localizer.getString("RECORDING_HINT_3")+'</div>  </div></div><div id="graffiti-recording-status">  <div id="graffiti-recording-flash-icon"></div>  <div id="graffiti-time-display-recording"></div></div>',[{ids:["graffiti-btn-end-recording"],event:"click",fn:function(e){graffiti.toggleRecording()}}]),graffiti.setupOneControlPanel("graffiti-takes-controls",'<div id="graffiti-takes-controls-outer">  <div id="graffiti-takes-title">'+localizer.getString("TAKES")+':</div>  <div id="graffiti-takes-list"></div></div>',[{ids:["graffiti-takes-list"],event:"click",fn:function(e){var choice,target=$(e.target);if(choice="graffiti-takes-list"===target.attr("id")?target.find(".graffiti-take-item:first"):target,choice.length>0){var newTakeId=choice.attr("id"),_recordingCellId=choice.attr("recordingCellId"),_recordingKey=choice.attr("recordingKey");graffiti.updateActiveTakeId(_recordingCellId,_recordingKey,newTakeId)}}}]);var runnerOnIcon=stickerLib.makeRunningMan("black"),runnerOffIcon=stickerLib.makeRunningMan("white"),exitButtonConfiguration={dimensions:{x:4,y:4,width:12,height:12},color:"rgb(249, 92, 60)",iconUsage:!1,strokeWidth:1,fillOpacity:1},exitButton=stickerLib.makeSimpleX(exitButtonConfiguration);graffiti.setupOneControlPanel("graffiti-playback-controls",'<div id="graffiti-narrator-info">  <div id="graffiti-narrator-pic"></div>  <div id="graffiti-narrator-details">    <div>Presenter: </div><div id="graffiti-narrator-name"></div>  </div></div><div id="graffiti-playback-buttons">  <button class="btn btn-default btn-play" id="graffiti-play-btn" title="'+localizer.getString("START_PLAYBACK")+'">    <i class="fa fa-play"></i>  </button>  <button class="btn btn-default" id="graffiti-pause-btn" title="'+localizer.getString("PAUSE_PLAYBACK")+'">    <i class="fa fa-pause"></i>  </button>  <div id="graffiti-skip-buttons">    <button class="btn btn-default btn-rewind" id="graffiti-rewind-btn" title="'+localizer.getString("SKIP_BACK")+" "+(state.scanningIsOn()?localizer.getString("TO_PREVIOUS_SENTENCE"):graffiti.rewindAmt+" "+localizer.getString("SECONDS"))+'">      <i class="fa fa-backward"></i>    </button>    <button class="btn btn-default btn-forward" id="graffiti-forward-btn" title="'+localizer.getString("SKIP_FORWARD")+" "+(state.scanningIsOn()?localizer.getString("TO_NEXT_SENTENCE"):graffiti.rewindAmt+" "+localizer.getString("SECONDS"))+'">      <i class="fa fa-forward"></i>    </button>  </div>  <div id="graffiti-sound-buttons">    <button class="btn btn-default btn-sound-on" id="graffiti-sound-on-btn" title="'+localizer.getString("MUTE")+'">       <i class="fa fa-volume-up"></i>   </button>   <button class="btn btn-default btn-sound-off" id="graffiti-sound-off-btn" title="'+localizer.getString("UNMUTE")+'">     <i class="fa fa-volume-off"></i>   </button>  </div>  <div id="graffiti-rapidplay-buttons">    <button class="btn btn-default btn-rapidplay-on" id="graffiti-rapidplay-on-btn" title="'+localizer.getString("HIGH_SPEED_PLAYBACK")+'">'+runnerOnIcon+'   </button>   <button class="btn btn-default btn-rapidplay-off" id="graffiti-rapidplay-off-btn" title="'+localizer.getString("REGULAR_SPEED_PLAYBACK")+'">'+runnerOffIcon+'   </button>  </div>  <div id="graffiti-exit-button">   <button class="btn btn-default" id="graffiti-exit-playback-btn" title="'+localizer.getString("EXIT_PLAYBACK")+'">'+exitButton+'   </button>  </div></div><div id="graffiti-scrub-controls">  <div id="graffiti-playback-range">    <input type="range" min="0" max="1000" value="0" id="graffiti-recorder-range"></input>  </div>  <div id="graffiti-time-display-playback">00:00</div></div>',[{ids:["graffiti-play-btn","graffiti-pause-btn"],event:"click",fn:function(e){graffiti.togglePlayback()}},{ids:["graffiti-forward-btn","graffiti-rewind-btn"],event:"click",fn:function(e){var direction=1;("graffiti-rewind-btn"===$(e.target).attr("id")||$(e.target).hasClass("fa-backward"))&&(direction=-1),graffiti.jumpPlayback(direction,graffiti.rewindAmt),state.updateUsageStats({type:"userSkips"})}},{ids:["graffiti-sound-on-btn","graffiti-sound-off-btn"],event:"click",fn:function(e){state.getMute()?(state.setMute(!1),graffiti.updateControlPanels(),"playing"===state.getActivity()&&audio.startPlayback(state.getTimePlayedSoFar())):(state.setMute(!0),graffiti.updateControlPanels(),"playing"===state.getActivity()&&audio.pausePlayback())}},{ids:["graffiti-rapidplay-on-btn","graffiti-rapidplay-off-btn"],event:"click",fn:function(e){graffiti.toggleRapidPlay({scan:!1})}},{ids:["graffiti-rapidscan-on-btn","graffiti-rapidscan-off-btn"],event:"click",fn:function(e){graffiti.toggleRapidPlay({scan:!0})}},{ids:["graffiti-exit-button"],event:"click",fn:function(e){var activity=state.getActivity();"playing"!==activity&&"playbackPaused"!==activity&&"scrubbing"!==activity||graffiti.cancelPlayback()}},{ids:["graffiti-recorder-range"],event:"mousedown",fn:function(e){previousPlayState=state.getActivity(),graffiti.pausePlayback(),graffiti.changeActivity("scrubbing")}},{ids:["graffiti-recorder-range"],event:"mouseup",fn:function(e){graffiti.handleSliderDrag(),graffiti.changeActivity("playbackPaused"),"playing"===previousPlayState&&graffiti.startPlayback(),graffiti.updateAllGraffitiDisplays(),state.updateUsageStats({type:"userSkips"})}},{ids:["graffiti-recorder-range"],event:"input",fn:function(e){graffiti.handleSliderDragDebounced()}}]),graffiti.setupOneControlPanel("graffiti-notifier",'<div id="graffiti-notifier"></div>'),graffiti.setupOneControlPanel("graffiti-recording-pen-controls",'<div id="graffiti-recording-pens-shell"> <button class="btn btn-default" id="graffiti-line-pen" title="'+localizer.getString("FREEFORM_PEN_TOOL")+'"><svg class="svg-inline--fa fa-pen-alt fa-w-16" aria-hidden="true" data-prefix="fa" data-icon="pen-alt" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512" data-fa-i2svg=""><path fill="currentColor" d="M497.94 74.17l-60.11-60.11c-18.75-18.75-49.16-18.75-67.91 0l-56.55 56.55 128.02 128.02 56.55-56.55c18.75-18.75 18.75-49.15 0-67.91zm-246.8-20.53c-15.62-15.62-40.94-15.62-56.56 0L75.8 172.43c-6.25 6.25-6.25 16.38 0 22.62l22.63 22.63c6.25 6.25 16.38 6.25 22.63 0l101.82-101.82 22.63 22.62L93.95 290.03A327.038 327.038 0 0 0 .17 485.11l-.03.23c-1.7 15.28 11.21 28.2 26.49 26.51a327.02 327.02 0 0 0 195.34-93.8l196.79-196.79-82.77-82.77-84.85-84.85z"></path></svg></button> <button class="btn btn-default" id="graffiti-highlight-pen" title="'+localizer.getString("HIGHLIGHTER_TOOL")+'"><svg class="svg-inline--fa fa-highlighter fa-w-17" aria-hidden="true" data-prefix="fa" data-icon="highlighter" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 544 512" data-fa-i2svg=""><path fill="currentColor" d="M0 479.98L99.92 512l35.45-35.45-67.04-67.04L0 479.98zm124.61-240.01a36.592 36.592 0 0 0-10.79 38.1l13.05 42.83-50.93 50.94 96.23 96.23 50.86-50.86 42.74 13.08c13.73 4.2 28.65-.01 38.15-10.78l35.55-41.64-173.34-173.34-41.52 35.44zm403.31-160.7l-63.2-63.2c-20.49-20.49-53.38-21.52-75.12-2.35L190.55 183.68l169.77 169.78L530.27 154.4c19.18-21.74 18.15-54.63-2.35-75.13z"></path></svg></button> <button class="btn btn-default" id="graffiti-eraser-pen" title="'+localizer.getString("ERASER_TOOL")+'"><svg aria-hidden="true" data-prefix="fas" data-icon="eraser" class="svg-inline--fa fa-eraser fa-w-16" role="img" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512 512"><path fill="currentColor" d="M497.941 273.941c18.745-18.745 18.745-49.137 0-67.882l-160-160c-18.745-18.745-49.136-18.746-67.883 0l-256 256c-18.745 18.745-18.745 49.137 0 67.882l96 96A48.004 48.004 0 0 0 144 480h356c6.627 0 12-5.373 12-12v-40c0-6.627-5.373-12-12-12H355.883l142.058-142.059zm-302.627-62.627l137.373 137.373L265.373 416H150.628l-80-80 124.686-124.686z"></path></svg></button></div><div id="graffiti-recording-colors-shell">'+Object.keys(graffiti.penColors).map(function(key){return'<div id="graffiti-recording-color-'+key+'" colorVal="'+key+'"></div>'}).join("")+'</div><div id="graffiti-line-style-controls">  <div id="graffiti-temporary-ink" title="'+localizer.getString("USE_DISAPPEARING_INK")+'">   <input type="checkbox" id="graffiti-temporary-ink-control" checked />   <label id="graffiti-temporary-ink-label" for="graffiti-temporary-ink-control">'+localizer.getString("TEMPORARY_INK")+'</label>  </div>  <div id="graffiti-dashed-line" title="'+localizer.getString("USE_DASHED_LINES")+'">   <input type="checkbox" id="graffiti-dashed-line-control" />   <label id="graffiti-dashed-line-label" for="graffiti-dashed-line-control">'+localizer.getString("DASHED_LINES")+"</label>  </div></div>",[{ids:["graffiti-highlight-pen"],event:"click",fn:function(e){console.log("Graffiti: you picked highlighter tool."),graffiti.setGraffitiPenColor("yellow"),graffiti.toggleGraffitiPen("highlight")}},{ids:["graffiti-line-pen"],event:"click",fn:function(e){console.log("Graffiti: you picked line tool."),graffiti.toggleGraffitiPen("line")}},{ids:["graffiti-eraser-pen"],event:"click",fn:function(e){console.log("Graffiti: you picked eraser tool."),graffiti.toggleGraffitiPen("eraser"),$("#graffiti-temporary-ink-control").attr({checked:!1}),state.updateDrawingState([{change:"drawingModeActivated",data:!0},{change:"permanence",data:"permanent"},{change:"penType",data:"eraser"}])}},{ids:Object.keys(graffiti.penColors).map(function(key){return"graffiti-recording-color-"+key}),event:"click",fn:function(e){var target=$(e.target),colorVal=target.attr("colorVal");graffiti.setGraffitiPenColor(colorVal),"sticker"!==state.getDrawingPenAttribute("type")&&graffiti.activateGraffitiPen(state.getDrawingPenAttribute("type"))}},{ids:["graffiti-temporary-ink-control","graffiti-temporary-ink-label"],event:"click",fn:function(e){var permanence=$("#graffiti-temporary-ink-control").is(":checked")?"temporary":"permanent";console.log("Graffiti: You set temporary ink to:",permanence),state.updateDrawingState([{change:"permanence",data:permanence}]),"sticker"!==state.getDrawingPenAttribute("type")&&graffiti.activateGraffitiPen(state.getDrawingPenAttribute("type"))}},{ids:["graffiti-dashed-line-control","graffiti-dashed-line-label"],event:"click",fn:function(e){var dashedLine=$("#graffiti-dashed-line-control").is(":checked")?"dashed":"solid";console.log("Graffiti: You set dashed line to:",dashedLine),state.updateDrawingState([{change:"dash",data:dashedLine}]),"sticker"!==state.getDrawingPenAttribute("type")&&graffiti.activateGraffitiPen(state.getDrawingPenAttribute("type"))}}])
;var rightTriangle=stickerLib.makeRightTriangle(defaultIconConfiguration),isocelesTriangle=stickerLib.makeIsocelesTriangle(defaultIconConfiguration),rectangle=stickerLib.makeRectangle(largeIconConfiguration),roundRectangle=stickerLib.makeRectangle(roundRectConfiguration),checkMark=stickerLib.makeCheckmark(solidFatIconConfiguration),xMark=stickerLib.makeXmark(solidFatIconConfiguration),axis=(stickerLib.makeRibbon(solidIconConfiguration),stickerLib.makeAxis(solidIconConfiguration)),grid=stickerLib.makeGrid(solidIconConfiguration),bomb=stickerLib.makeBomb(defaultIconConfiguration),trophy=stickerLib.makeTrophy(defaultIconConfiguration),smiley=stickerLib.makeSmiley(solidIconConfiguration),horizontalBrackets=stickerLib.makeHorizontalBrackets(defaultIconConfiguration),verticalBrackets=stickerLib.makeVerticalBrackets(defaultIconConfiguration),ellipse=stickerLib.makeEllipse(largeIconConfiguration),pi=(stickerLib.makeBullsEye(bullsEyeConfiguration),stickerLib.makePi(solidIconConfiguration)),alpha=stickerLib.makeAlpha(solidIconConfiguration),beta=stickerLib.makeBeta(solidIconConfiguration),sigma=stickerLib.makeSigma(solidIconConfiguration),theta=stickerLib.makeTheta(solidIconConfiguration),angle=stickerLib.makeAngle(defaultIconConfiguration),curlyBraces=stickerLib.makeSymmetricCurlyBraces(solidIconConfiguration),lineWithArrow=stickerLib.makeLine({color:"black",dimensions:iconDimensions,endpoints:{p1:{x:-2,y:20},p2:{x:20,y:-2}},lineStartOffset:{x:4,y:4},strokeWidth:1,dashed:"solid",usesArrow:!0,arrowHeadSize:10});graffiti.setupOneControlPanel("graffiti-stickers-controls",'<div id="graffiti-stickers-shell">  <div id="graffiti-stickers-header"><div id="graffiti-stickers-expando" class="graffiti-expando graffiti-expando-closed"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 100 100" x="0px" y="0px"><title>triangolo</title><g data-name="Livello 11"><polygon points="50 87.5 6.7 87.5 28.35 50 50 12.5 71.65 50 93.3 87.5 50 87.5"/></g></svg></div><div>Stickers <span>(Select, then click & drag)</span></div></div>  <div id="graffiti-stickers-body">    <div>      <div class="graffiti-stickers-button" id="graffiti-sticker-lineWithArrow" title="Line with arrow at tip">'+lineWithArrow+'</div>      <div class="graffiti-stickers-button" id="graffiti-sticker-horizontalBrackets" title="Horizontal brackets">'+horizontalBrackets+'</div>      <div class="graffiti-stickers-button" id="graffiti-sticker-verticalBrackets" title="Vertical brackets">'+verticalBrackets+'</div>      <div class="graffiti-stickers-button" id="graffiti-sticker-curlyBraces" title="Curly braces">'+curlyBraces+'</div>    </div>    <div>      <div class="graffiti-stickers-button" id="graffiti-sticker-rectangle" title="Rectangle">'+rectangle+'</div>      <div class="graffiti-stickers-button" id="graffiti-sticker-roundRectangle" title="Rounded corners rectangle">'+roundRectangle+'</div>      <div class="graffiti-stickers-button" id="graffiti-sticker-ellipse" title="Ellipse">'+ellipse+'</div>      <div class="graffiti-stickers-button" id="graffiti-sticker-rightTriangle" title="Right triangle">'+rightTriangle+'</div>      <div class="graffiti-stickers-button" id="graffiti-sticker-isocelesTriangle" title="Isoceles triangle">'+isocelesTriangle+'</div>    </div>    <div>      <div class="graffiti-stickers-button" id="graffiti-sticker-checkmark" title="Checkmark">'+checkMark+'</div>      <div class="graffiti-stickers-button" id="graffiti-sticker-xmark" title="X mark">'+xMark+'</div>      <div class="graffiti-stickers-button" id="graffiti-sticker-smiley" title="Smiley face">'+smiley+'</div>      <div class="graffiti-stickers-button" id="graffiti-sticker-bomb" title="Bomb">'+bomb+'</div>      <div class="graffiti-stickers-button" id="graffiti-sticker-trophy" title="Trophy">'+trophy+'</div>    </div>    <div>      <div class="graffiti-stickers-button" id="graffiti-sticker-pi" title="Pi symbol">'+pi+'</div>      <div class="graffiti-stickers-button" id="graffiti-sticker-alpha"  title="Alpha symbol">'+alpha+'</div>      <div class="graffiti-stickers-button" id="graffiti-sticker-beta" title="Beta symbol">'+beta+'</div>      <div class="graffiti-stickers-button" id="graffiti-sticker-sigma" title="Sigma symbol">'+sigma+'</div>      <div class="graffiti-stickers-button" id="graffiti-sticker-theta"  title="Theta symbol">'+theta+'</div>    </div>    <div>      <div class="graffiti-stickers-button" id="graffiti-sticker-axis" title="X-y axis">'+axis+'</div>      <div class="graffiti-stickers-button" id="graffiti-sticker-grid" title="Square grid">'+grid+'</div>      <div class="graffiti-stickers-button" id="graffiti-sticker-angle" title="Angle">'+angle+'</div>      <div class="graffiti-stickers-button" id="graffiti-sticker-label" title="Text label">Tt</div>      <div class="graffiti-stickers-button" id="graffiti-sticker-custom" title="Custom sticker">Cs</div>    </div>  </div>  <div id="graffiti-sticker-style-controls">    <div id="graffiti-sticker-fill">     <input type="checkbox" id="graffiti-sticker-fill-control" />     <label id="graffiti-sticker-fill-control-label" for="graffiti-sticker-fill-control" title="Fill shapes with chosen color">'+localizer.getString("SOLID_FILL")+'</label>    </div>    <div id="graffiti-sticker-hint">'+localizer.getString("SHIFT_KEY_ALIGN")+"</div>  </div></div>",[{ids:["graffiti-sticker-rightTriangle","graffiti-sticker-isocelesTriangle","graffiti-sticker-rectangle","graffiti-sticker-roundRectangle","graffiti-sticker-lineWithArrow","graffiti-sticker-checkmark","graffiti-sticker-xmark","graffiti-sticker-grid","graffiti-sticker-angle","graffiti-sticker-ribbon","graffiti-sticker-alpha","graffiti-sticker-beta","graffiti-sticker-sigma","graffiti-sticker-theta","graffiti-sticker-axis","graffiti-sticker-bomb","graffiti-sticker-trophy","graffiti-sticker-smiley","graffiti-sticker-horizontalBrackets","graffiti-sticker-verticalBrackets","graffiti-sticker-curlyBraces","graffiti-sticker-ellipse","graffiti-sticker-pi","graffiti-sticker-label","graffiti-sticker-custom"],event:"click",fn:function(e){var stickerId=$(e.target).attr("id");void 0===stickerId&&(stickerId=$(e.target).parents(".graffiti-stickers-button").attr("id"));var cleanStickerId=stickerId.replace("graffiti-sticker-","");console.log("Graffiti: Sticker chosen:",cleanStickerId),graffiti.toggleGraffitiSticker(cleanStickerId)}},{ids:["graffiti-stickers-header"],event:"click",fn:function(e){$("#graffiti-stickers-body,#graffiti-sticker-style-controls").slideToggle(200),$("#graffiti-stickers-expando").hasClass("graffiti-expando-closed")?($("#graffiti-stickers-expando").removeClass("graffiti-expando-closed").addClass("graffiti-expando-open"),setTimeout(function(){graffiti.windowResizeHandler({force:!0})},400)):$("#graffiti-stickers-expando").removeClass("graffiti-expando-open").addClass("graffiti-expando-closed")}},{ids:["graffiti-sticker-fill-control","graffiti-sticker-fill-control-label"],event:"click",fn:function(e){state.updateDrawingState([{change:"fillOpacity",data:$("#graffiti-sticker-fill-control").is(":checked")?1:0}])}}]),graffiti.setupOneControlPanel("graffiti-access-api",'<button class="btn btn-default" id="graffiti-access-api-btn" title="'+localizer.getString("SAMPLE_API")+'"></i>&nbsp; <span>'+localizer.getString("SAMPLE_API")+"</span></button>",[{ids:["graffiti-access-api-btn"],event:"click",fn:function(e){console.log("Graffiti: API key is:",graffiti.recordingAPIKey),graffiti.provideAPIKeyExamples()}}]);var lockConfigOn=$.extend({},!0,defaultIconConfiguration,{color:"red"}),lockConfigOff=$.extend({},!0,defaultIconConfiguration,{color:"green"}),hiddenCellConfiguration=$.extend({},!0,defaultIconConfiguration,{color:"#aaa",fillOpacity:1});graffiti.setupOneControlPanel("graffiti-terminal-builder",'<div id="graffiti-terminal-builder-header"><div>Extras</div></div><div id="graffiti-terminal-builder-body">  <div>    <div id="graffiti-insert-terminal-cell" title="'+localizer.getString("INSERT_GRAFFITI_TERMINAL_ALT_TAG")+'">'+stickerLib.makeTerminal({width:25})+'    </div>    <div id="graffiti-insert-btn-cell" title="'+localizer.getString("INSERT_GRAFFITI_BUTTON_CELL_ALT_TAG")+'">'+stickerLib.makeButton({width:27,height:22,contents:"Run"})+'    </div>    <div id="graffiti-insert-terminal-suite" title="'+localizer.getString("INSERT_GRAFFITI_TERMINAL_SUITE_ALT_TAG")+'">      <div>'+stickerLib.makeTerminal({width:25})+"</div> +       <div>"+stickerLib.makeButton({width:27,height:22,contents:"Run"})+'</div>    </div>  </div>  <div>    <div class="graffiti-stickers-button" id="graffiti-create-showhide-button" title="'+localizer.getString("CREATE_SHOWHIDE_BUTTON")+'">'+stickerLib.makeHidden(hiddenCellConfiguration)+'    </div>    <div class="graffiti-stickers-button" id="graffiti-toggle-markdown-lock" title="'+localizer.getString("ACTIVATE_LOCK_ALT_TAG")+'"><span id="graffiti-locked-on">'+stickerLib.makeLock(lockConfigOn)+'</span><span id="graffiti-locked-off">'+stickerLib.makeLock(lockConfigOff)+'</span>    </div>    <div class="graffiti-stickers-button" id="graffiti-change-data-dir-button" title="'+localizer.getString("CHANGE_DATADIR_TAG")+'">'+stickerLib.makeHomeFolderIcon(defaultIconConfiguration)+"    </div>  </div></div>",[{ids:["graffiti-insert-btn-cell"],event:"click",fn:function(e){console.log("Graffiti: Inserting graffiti button cell");graffiti.createGraffitiButtonAboveSelectedCell();utils.saveNotebookDebounced()}},{ids:["graffiti-insert-terminal-cell"],event:"click",fn:function(e){console.log("Graffiti: inserting graffiti terminal cell");terminalLib.createTerminalCellAboveSelectedCell();utils.saveNotebookDebounced()}},{ids:["graffiti-insert-terminal-suite"],event:"click",fn:function(e){console.log("Graffiti: inserting graffiti terminal suite");graffiti.createTerminalSuiteAboveSelectedCell();utils.saveNotebookDebounced()}},{ids:["graffiti-toggle-markdown-lock"],event:"click",fn:function(e){console.log("Toggle markdown lock"),graffiti.toggleMarkdownLock(),utils.saveNotebookDebounced()}},{ids:["graffiti-create-showhide-button"],event:"click",fn:function(e){graffiti.createGraffitiButtonAboveSelectedCell({tooltipCommands:{insertDataFromFile:{cellType:"code",filePath:"./example.txt"},swappingLabels:!0,labelSwaps:["Show Solution","Hide Solution"],silenceWarnings:!0},tooltipDirectives:["%%insert_data_from_file code ./example.txt","%%label_swaps Show Solution|Hide Solution","%%silence_warnings"]}),utils.saveNotebookDebounced()}},{ids:["graffiti-change-data-dir-button"],event:"click",fn:function(e){graffiti.changeDataDir()}}]),graffiti.refreshMarkdownLock()},setupMarkdownLocks:function(){graffiti.oldUnrender=graffiti.MarkdownCell.prototype.unrender,graffiti.MarkdownCell.prototype.unrender=function(){var cell=Jupyter.notebook.get_selected_cell();if(void 0!==cell){var cellId=utils.getMetadataCellId(cell.metadata);!0===utils.getNotebookGraffitiConfigEntry("markdownLocked")||terminalLib.isTerminalCell(cellId)?console.log("Graffiti: Not unrendering markdown cell, since Graffiti lock in place or is terminal cell."):(console.log("Graffiti: applying old unrender call, cellId",cellId),graffiti.oldUnrender.apply(cell,_arguments),window.brokeCell=cell)}}},refreshMarkdownLock:function(isLocked){if(void 0===isLocked){var markdownLocked=utils.getNotebookGraffitiConfigEntry("markdownLocked");isLocked=void 0!==markdownLocked&&!0===markdownLocked}return isLocked?($("#graffiti-locked-off").hide(),$("#graffiti-locked-on").show()):($("#graffiti-locked-off").show(),$("#graffiti-locked-on").hide()),isLocked},toggleMarkdownLock:function(){var markdownLocked=utils.getNotebookGraffitiConfigEntry("markdownLocked"),isLocked=!0===markdownLocked,verb=isLocked?localizer.getString("UNLOCK_VERB"):localizer.getString("LOCK_VERB"),bodyText=isLocked?localizer.getString("UNLOCK_BODY"):localizer.getString("LOCK_BODY");dialog.modal({title:verb+" "+localizer.getString("LOCK_CONFIRM"),body:bodyText,sanitize:!1,buttons:{OK:{click:function(e){console.log("Graffiti: You clicked ok, you want to toggle the lock");var markdownLocked=utils.getNotebookGraffitiConfigEntry("markdownLocked"),isLocked=void 0!==markdownLocked&&!0===markdownLocked;utils.setNotebookGraffitiConfigEntry("markdownLocked",!isLocked),utils.saveNotebookDebounced(),graffiti.refreshMarkdownLock(!isLocked)}},Cancel:{click:function(e){console.log("Graffiti: you cancelled:",$(e.target).parent())}}}})},setSitePanelScrollTop:function(scrollTop){graffiti.sitePanel.scrollTop(scrollTop)},showControlPanels:function(panels){graffiti.controlPanelsShell.children().hide(),graffiti.controlPanelIds["graffiti-control-panel-title"].css({display:"flex"});var _iteratorNormalCompletion3=!0,_didIteratorError3=!1,_iteratorError3=void 0;try{for(var _step3,_iterator3=panels[Symbol.iterator]();!(_iteratorNormalCompletion3=(_step3=_iterator3.next()).done);_iteratorNormalCompletion3=!0)controlPanelId=_step3.value,graffiti.controlPanelIds[controlPanelId].show()}catch(err){_didIteratorError3=!0,_iteratorError3=err}finally{try{_iteratorNormalCompletion3||null==_iterator3.return||_iterator3.return()}finally{if(_didIteratorError3)throw _iteratorError3}}},updateActiveTakeId:function(recordingCellId,recordingKey,activeTakeId){storage.updateSingleManifestRecordingField(recordingCellId,recordingKey,"activeTakeId",activeTakeId),state.setPlayableMovie("cursorActivity",recordingCellId,recordingKey),graffiti.updateTakesPanel(recordingCellId,recordingKey)},updateTakesPanel:function(recordingCellId,recordingKey){var recording=state.getManifestSingleRecording(recordingCellId,recordingKey),activeTakeId=recording.activeTakeId;if(void 0===activeTakeId||void 0===recording.takes)return!1;var recIndex,recIndexZerobased,renderedDate,rec,takeClass,renderedTakes="",sortedRecs=_.sortBy($.map(recording.takes,function(val,key){return $.extend(!0,{},val,{key:key})}),"createDate");for(recIndex=sortedRecs.length;recIndex>0;--recIndex)recIndexZerobased=recIndex-1,rec=sortedRecs[recIndexZerobased],renderedDate=localizer.getString("RECORDED_ON")+": "+new Date(rec.createDate),takeClass=rec.key===activeTakeId?"graffiti-take-selected":"graffiti-take-unselected",renderedTakes+='<div class="'+takeClass+' graffiti-take-item" id="'+rec.key+'" recordingCellId="'+recordingCellId+'" recordingKey="'+recordingKey+'" title="'+renderedDate+'">'+recIndex+"</div>";return $("#graffiti-takes-list").html(renderedTakes),!0},updateControlPanels:function(cm){var activity=state.getActivity(),accessLevel=state.getAccessLevel(),outerControlHidden="none"===graffiti.outerControlPanel.css("display");if("view"===accessLevel){if("idle"!==activity)outerControlHidden&&graffiti.outerControlPanel.show();else if(void 0===state.getPlayableMovie("tip")&&void 0===state.getPlayableMovie("api")&&void 0===state.getPlayableMovie("cursorActivity")||"notifying"!==activity)return void(outerControlHidden||graffiti.outerControlPanel.hide())}else outerControlHidden&&graffiti.outerControlPanel.show();state.getMute()?graffiti.controlPanelIds["graffiti-playback-controls"].find("#graffiti-sound-on-btn").hide().parent().find("#graffiti-sound-off-btn").show():graffiti.controlPanelIds["graffiti-playback-controls"].find("#graffiti-sound-off-btn").hide().parent().find("#graffiti-sound-on-btn").show();var currentPlaySpeed=state.getCurrentPlaySpeed();switch(graffiti.controlPanelIds["graffiti-playback-controls"].find("#graffiti-rewind-btn").attr({title:localizer.getString("SKIP_BACK")+" "+graffiti.rewindAmt+" "+localizer.getString("SECONDS")}),graffiti.controlPanelIds["graffiti-playback-controls"].find("#graffiti-forward-btn").attr({title:localizer.getString("SKIP_FORWARD")+" "+graffiti.rewindAmt+" "+localizer.getString("SECONDS")}),currentPlaySpeed){case"scanActive":case"scanInactive":graffiti.controlPanelIds["graffiti-playback-controls"].find("#graffiti-rapidscan-on-btn").hide().parent().find("#graffiti-rapidscan-off-btn").show(),graffiti.controlPanelIds["graffiti-playback-controls"].find("#graffiti-rapidplay-off-btn").hide().parent().find("#graffiti-rapidplay-on-btn").show(),graffiti.controlPanelIds["graffiti-playback-controls"].find("#graffiti-rewind-btn").attr({title:localizer.getString("SKIP_BACK")+" "+localizer.getString("TO_PREVIOUS_SENTENCE")}),graffiti.controlPanelIds["graffiti-playback-controls"].find("#graffiti-forward-btn").attr({title:localizer.getString("SKIP_FORWARD")+" "+localizer.getString("TO_NEXT_SENTENCE")});break;case"rapid":graffiti.controlPanelIds["graffiti-playback-controls"].find("#graffiti-rapidscan-off-btn").hide().parent().find("#graffiti-rapidscan-on-btn").show(),graffiti.controlPanelIds["graffiti-playback-controls"].find("#graffiti-rapidplay-on-btn").hide().parent().find("#graffiti-rapidplay-off-btn").show();break;case"regular":graffiti.controlPanelIds["graffiti-playback-controls"].find("#graffiti-rapidplay-off-btn").hide().parent().find("#graffiti-rapidplay-on-btn").show(),graffiti.controlPanelIds["graffiti-playback-controls"].find("#graffiti-rapidscan-off-btn").hide().parent().find("#graffiti-rapidscan-on-btn").show()}if(("playing"===activity||"playbackPending"===activity||"playbackPaused"===activity)&&!state.getNarratorInfoIsRendered()){var narratorName=state.getNarratorInfo("name"),narratorPicture=state.getNarratorInfo("picture");void 0!==narratorName||void 0!==narratorPicture?(graffiti.controlPanelIds["graffiti-playback-controls"].find("#graffiti-narrator-info").show(),void 0!==narratorPicture&&graffiti.controlPanelIds["graffiti-playback-controls"].find("#graffiti-narrator-pic").html('<img src="'+narratorPicture+'" />'),void 0!==narratorName&&graffiti.controlPanelIds["graffiti-playback-controls"].find("#graffiti-narrator-name").html(narratorName),state.setNarratorInfoIsRendered(!0)):graffiti.controlPanelIds["graffiti-playback-controls"].find("#graffiti-narrator-info").hide()}var visibleControlPanels;switch(activity){case"idle":var activeCell;activeCell=void 0===cm?Jupyter.notebook.get_selected_cell():utils.findCellByCodeMirror(cm),graffiti.selectedTokens=utils.findSelectionTokens(activeCell,graffiti.tokenRanges,state);var selectedTokens=graffiti.selectedTokens;graffiti.highlightIntersectingGraffitiRange();var isMarkdownCell="markdown"===activeCell.cell_type;if(isMarkdownCell&&!selectedTokens.isIntersecting?($("#graffiti-create-btn").attr({title:localizer.getString("CREATE_2")}),$("#graffiti-create-btn span").text(localizer.getString("CREATE_2"))):($("#graffiti-create-btn").attr({title:localizer.getString("CREATE_1")}),$("#graffiti-create-btn span").text(localizer.getString("CREATE_1"))),selectedTokens.noTokensPresent||!isMarkdownCell&&selectedTokens.range.selectionStart===selectedTokens.range.selectionEnd&&!selectedTokens.isIntersecting||isMarkdownCell&&activeCell.rendered)visibleControlPanels=["graffiti-notifier","graffiti-terminal-builder"],isMarkdownCell?activeCell.rendered?graffiti.setNotifier("<div>"+localizer.getString("EDIT_IN_MARKDOWN_CELL")+"</div>"):graffiti.setNotifier("<div>"+localizer.getString("SELECT_SOME_TEXT_MARKDOWN")+"</div>"):graffiti.setNotifier("<div>"+localizer.getString("SELECT_SOME_TEXT_PLAIN")+"</div>");else if("view"===accessLevel)console.log("Graffiti: view only"),visibleControlPanels=["graffiti-playback-controls"];else if(visibleControlPanels=["graffiti-record-controls"],graffiti.controlPanelIds["graffiti-record-controls"].find("#graffiti-begin-recording-btn").hide().parent().find("#graffiti-begin-rerecording-btn").hide().parent().find("#graffiti-remove-btn").hide(),graffiti.controlPanelIds["graffiti-record-controls"].find("#graffiti-create-btn").show().parent().find("#graffiti-edit-btn").hide(),selectedTokens.isIntersecting&&(graffiti.highlightIntersectingGraffitiRange(),graffiti.controlPanelIds["graffiti-record-controls"].find("#graffiti-create-btn").hide().parent().find("#graffiti-edit-btn").show().parent().find("#graffiti-begin-recording-btn").show().parent().find("#graffiti-remove-btn").show(),state.clearPlayableMovie("cursorActivity"),selectedTokens.hasMovie)){var _recordingCellId2=utils.extractRecordingCellId(selectedTokens),_recordingKey2=selectedTokens.recordingKey;state.setPlayableMovie("cursorActivity",_recordingCellId2,_recordingKey2),graffiti.recordingAPIKey=utils.composeGraffitiId(_recordingCellId2,_recordingKey2),visibleControlPanels.push("graffiti-access-api"),visibleControlPanels.push("graffiti-notifier"),graffiti.updateTakesPanel(_recordingCellId2,_recordingKey2)?(visibleControlPanels.push("graffiti-takes-controls"),graffiti.setNotifier("<div>"+localizer.getString("YOU_CAN_PLAY_VIA_TOOLTIP")+"</div>")):graffiti.setNotifier("<div>"+localizer.getString("NO_MOVIE_RECORDED_YET")+"</div>"),graffiti.controlPanelIds["graffiti-record-controls"].find("#graffiti-begin-recording-btn").hide().parent().find("#graffiti-begin-rerecording-btn").show()}graffiti.showControlPanels(visibleControlPanels);break;case"playbackPending":graffiti.setNotifier("<div>"+localizer.getString("LOADING")+"</div>"),visibleControlPanels=["graffiti-notifier"],graffiti.showControlPanels(visibleControlPanels);break;case"playing":graffiti.controlPanelIds["graffiti-playback-controls"].find("#graffiti-play-btn").hide().parent().find("#graffiti-pause-btn").show(),visibleControlPanels=["graffiti-playback-controls"],graffiti.showControlPanels(visibleControlPanels);break;case"playbackPaused":graffiti.controlPanelIds["graffiti-playback-controls"].find("#graffiti-pause-btn").hide().parent().find("#graffiti-play-btn").show(),visibleControlPanels=["graffiti-playback-controls"],graffiti.showControlPanels(visibleControlPanels);break;case"graffiting":graffiti.showControlPanels(["graffiti-finish-edit-controls"]),graffiti.setNotifier("<div>"+localizer.getString("ENTER_AND_SAVE")+"</div><div>"+localizer.getString("CANCEL_CHANGES_1")+"</div>",[{ids:["graffiti-cancel-graffiting-link"],event:"click",fn:function(e){graffiti.finishGraffiti(!1)}}]);break;case"recordingPending":graffiti.showControlPanels([]),graffiti.setNotifier("<div>"+localizer.getString("CLICK_BEGIN_MOVIE_RECORDING")+"</div>",[{ids:["graffiti-cancel-recording-pending-link"],event:"click",fn:function(e){graffiti.finishGraffiti(!1)}}]);break;case"recording":graffiti.showControlPanels(["graffiti-recording-controls","graffiti-recording-pen-controls","graffiti-stickers-controls"]),graffiti.setNotifier("<div>"+localizer.getString("ACTIVITIES_BEING_RECORDED")+"</div><div>"+localizer.getString("CANCEL_RECORDING_2")+"</div>",[{ids:["graffiti-end-recording-link"],event:"click",fn:function(e){graffiti.toggleRecording()}},{ids:["graffiti-cancel-recording-link"],event:"click",fn:function(e){graffiti.cancelRecording()}}]);break;case"notifying":graffiti.showControlPanels(["graffiti-notifier"]);break;case"scrubbing":break;default:console.log("Graffiti: updateControlPanels hit unknown activity:",activity)}graffiti.performWindowResizeCheck()},placeControlPanel:function(opts){var position,newPosition,pointerPosition=state.getPointerPosition(),panelBbox=graffiti.sitePanel[0].getBoundingClientRect(),controlPanelWidth=graffiti.outerControlPanel.width(),controlPanelHeight=graffiti.outerControlPanel.height();if(void 0!==opts.nearAction)position={x:pointerPosition.x+panelBbox.width,y:pointerPosition.y-controlPanelHeight/2-25};else if(void 0!==opts.keepInView){var bbox=graffiti.outerControlPanel[0].getBoundingClientRect();position={x:bbox.left,y:bbox.top};var windowWidth=$(window).width(),windowHeight=$(window).height(),headerHeight=$("#header").height();bbox.left<0?position.x=25:bbox.right>windowWidth&&(position.x=windowWidth-(controlPanelWidth+25)),bbox.top<headerHeight?position.y=headerHeight+25:bbox.top>windowHeight&&(position.y=windowHeight-(controlPanelHeight+25))}else if(void 0!==opts.position)position=opts.position;else if(state.getControlPanelDragging()){var offset=state.getControlPanelDragOffset();position={x:pointerPosition.x-offset.left,y:pointerPosition.y-offset.top}}if(void 0!==position){var firstCell=Jupyter.notebook.get_cell(0),firstElem=firstCell.element[0],firstElemBbox=firstElem.getBoundingClientRect();newPosition={left:Math.min(firstElemBbox.right-controlPanelWidth-25,Math.max(0,position.x)),top:Math.min(panelBbox.bottom-controlPanelHeight-25,Math.max(25,position.y))};var newPositionPx={top:newPosition.top+"px",left:newPosition.left+"px"};graffiti.outerControlPanel.css(newPositionPx)}},initInteractivity:function(){graffiti.cleanUpButtonBorders(),graffiti.notebookContainer.click(function(e){return"recordingPending"===state.getActivity()&&(console.log("Graffiti: Now starting movie recording"),graffiti.toggleRecording()),!0}),audio.setAudioStorageCallback(storage.storeMovie),graffiti.addCMEvents(),graffiti.refreshGraffitiTooltipsDebounced=_.debounce(graffiti.refreshGraffitiTooltips,100,!1),setTimeout(function(){graffiti.setupBackgroundEvents(),graffiti.refreshAllGraffitiHighlights(),graffiti.refreshGraffitiTooltipsDebounced()},500),graffiti.setupControlPanels(),graffiti.updateControlPanels(),graffiti.setupDrawingScreen(),graffiti.setupSavingScrim(),graffiti.playAutoplayGraffiti(),graffiti.setupMarkdownLocks(),state.refreshCellIdToGraffitiMap(),graffiti.executeSaveToFileDirectivesDebounced=_.debounce(graffiti.executeSaveToFileDirectives,750,!1),terminalLib.init(graffiti.handleTerminalsEvents),graffiti.executeAllSaveToFileDirectives(),storage.preloadAllMovies()},setGraffitiPenColor:function(colorVal){if("highlight"===state.getDrawingPenAttribute("type")&&"black"===colorVal)return void console.log("Graffiti: black is not choosable when using the highlighter");$("#graffiti-recording-colors-shell div").removeClass("graffiti-recording-color-active"),console.log("Graffiti: you clicked color:",colorVal),state.updateDrawingState([{change:"color",data:colorVal}]),$("#graffiti-recording-color-"+colorVal).addClass("graffiti-recording-color-active")},activateGraffitiPen:function(penType){if("recording"==state.getActivity()){void 0===penType&&(penType="line"),graffiti.showDrawingScreen(),$(".graffiti-active-pen").removeClass("graffiti-active-pen");var penControl=$("#graffiti-"+penType+"-pen");penControl.length>0&&!penControl.hasClass("btn")&&(penControl=penControl.parents(".btn")),penControl.addClass("graffiti-active-pen"),state.updateDrawingState([{change:"drawingModeActivated",data:!0},{change:"stickerType",data:void 0},{change:"penType",data:penType}])}},deactivateAllPens:function(){graffiti.setGraffitiPenColor("black"),state.updateDrawingState([{change:"drawingModeActivated",data:!1},{change:"stickerType",data:void 0},{change:"penType",data:void 0}]),$(".graffiti-active-sticker").removeClass("graffiti-active-sticker"),$(".graffiti-active-pen").removeClass("graffiti-active-pen")},toggleGraffitiPen:function(penType){if("recording"==state.getActivity()){var activePenType=state.getDrawingPenAttribute("type");graffiti.hideLabelInputBoxes(),activePenType!==penType?(graffiti.activateGraffitiPen(penType),$(".graffiti-active-sticker").removeClass("graffiti-active-sticker")):($(".graffiti-active-pen").removeClass("graffiti-active-pen"),state.updateDrawingState([{change:"drawingModeActivated",data:!1},{change:"stickerType",data:void 0},{change:"penType",data:void 0}]),graffiti.hideDrawingScreen()),"highlight"===activePenType&&graffiti.setGraffitiPenColor("black")}},toggleGraffitiSticker:function(stickerType){if("recording"==state.getActivity()){var activePenType=state.getDrawingPenAttribute("type");if(state.getDrawingPenAttribute("stickerType")!==stickerType){graffiti.hideLabelInputBoxes(),graffiti.clearAnyActiveStickerStages(),graffiti.showDrawingScreen(),$(".graffiti-active-pen").removeClass("graffiti-active-pen");var stickerControl=$("#graffiti-sticker-"+stickerType);$(".graffiti-active-sticker").removeClass("graffiti-active-sticker"),stickerControl.addClass("graffiti-active-sticker"),state.updateDrawingState([{change:"drawingModeActivated",data:!0},{change:"stickerType",data:stickerType},{change:"penType",data:"sticker"}]),"highlight"===activePenType&&graffiti.setGraffitiPenColor("black")}else graffiti.hideLabelInputBoxes(),$(".graffiti-active-sticker").removeClass("graffiti-active-sticker"),state.updateDrawingState([{change:"drawingModeActivated",data:!1},{change:"stickerType",data:void 0},{change:"penType",data:void 0}]),graffiti.hideDrawingScreen()}},cancelRapidPlay:function(){console.log("Graffiti: cancelRapidPlay"),state.setCurrentPlaySpeed("regular"),state.storeUserChoicePlaySpeed("regular"),audio.updateAudioPlaybackRate(),graffiti.updateControlPanels()},toggleRapidPlay:function(opts){if(state.rapidIsOn()&&!opts.scan||state.scanningIsOn()&&opts.scan)graffiti.cancelRapidPlay();else{if(console.log("Graffiti: activating rapidPlay/rapidScan"),opts.scan){state.scanForSpeakingStatus()?state.setCurrentPlaySpeed("scanInactive"):state.setCurrentPlaySpeed("scanActive")}else state.setCurrentPlaySpeed("rapid"),state.storeUserChoicePlaySpeed("rapid");audio.updateAudioPlaybackRate(),graffiti.updateControlPanels()}},dimGraffitiCursor:function(){graffiti.graffitiCursorShell.css({opacity:.1})},undimGraffitiCursor:function(){graffiti.graffitiCursorShell.show().css({opacity:.55})},activateTerminalGraffitiCursor:function(){graffiti.graffitiTerminalCursor.show(),graffiti.graffitiNormalCursor.hide()},activateNormalGraffitiCursor:function(){graffiti.graffitiNormalCursor.show(),graffiti.graffitiTerminalCursor.hide()},drawingScreenHandler:function(e){var drawingActivity=state.getDrawingStateField("drawingActivity");if("recording"===state.getActivity()){if("mousedown"===e.type){console.log("Graffiti: drawingScreenHandler: mousedown");var wasFading="fade"===state.getDrawingStateField("drawingActivity");graffiti.resetTemporaryCanvases(),state.disableDrawingFadeClock();var stickerType=state.getDrawingPenAttribute("stickerType");drawingActivity="draw";var viewInfo=state.getViewInfo();if(void 0!==stickerType){drawingActivity="sticker",wasFading&&(graffiti.resetStickerCanvases("temporary"),graffiti.wipeTemporaryStickerDomCanvases());var currentPointerPosition=state.getPointerPosition(),penType=state.getDrawingPenAttribute("type"),minSize="lineWithArrow"===penType?1:graffiti.minimumStickerSize;state.updateDrawingState([{change:"mouseDownPosition",data:{x:currentPointerPosition.x,y:currentPointerPosition.y}},{change:"positions",data:{positions:{start:{x:currentPointerPosition.x,y:currentPointerPosition.y},end:{x:currentPointerPosition.x+minSize,y:currentPointerPosition.y+minSize}}}},{change:"cellId",data:viewInfo.cellId}]),"label"===stickerType&&graffiti.showLabelInputBox()}state.updateDrawingState([{change:"drawingModeActivated",data:!0},{change:"isDown",data:!0},{change:"drawingActivity",data:drawingActivity},{change:"opacity",data:state.getMaxDrawingOpacity()},{change:"downInMarkdown",data:viewInfo.inMarkdownCell},{change:"downInPromptArea",data:viewInfo.inPromptArea}])}else"mouseup"===e.type||"mouseleave"===e.type?("sticker"===drawingActivity&&"mouseup"===e.type&&graffiti.clearAnyActiveStickerStages(),state.getDrawingPenAttribute("isDown")&&(state.updateDrawingState([{change:"isDown",data:!1}]),"temporary"===state.getDrawingPenAttribute("permanence")&&state.startDrawingFadeClock())):"keyup"===e.type?(console.log("Graffiti: drawingScreen got key:",e),graffiti.handleKeyup(e)):"keydown"===e.type&&(console.log("Graffiti: drawingScreen got key:",e),graffiti.handleKeydown(e));return e.preventDefault(),e.stopPropagation(),!1}},resetDrawingColor:function(){$("#graffiti-recording-colors-shell div").removeClass("graffiti-recording-color-active"),$("#graffiti-recording-color-black").addClass("graffiti-recording-color-active"),state.updateDrawingState([{change:"color",data:"black"}])},resetDrawingPen:function(){$(".graffiti-active-pen").removeClass("graffiti-active-pen"),graffiti.toggleGraffitiPen(void 0,"deactivate")},showDrawingScreen:function(){graffiti.drawingScreen.show().focus()},hideDrawingScreen:function(){graffiti.drawingScreen.hide()},setupDrawingScreen:function(){var graffitiDrawingScreen=$('<div tabindex="0" id="graffiti-drawing-screen"></div>');graffiti.drawingScreen=graffitiDrawingScreen.prependTo(graffiti.notebookContainer)
;var notebookHeight=$("#notebook").outerHeight(!0);graffiti.drawingScreen.css({height:notebookHeight+"px"}),graffiti.drawingScreen.bind("mousedown mouseup mouseleave keydown keyup",function(e){graffiti.drawingScreenHandler(e)})},placeLabelInputBox:function(){var viewInfo=state.getViewInfo(),cell=utils.findCellByCellId(viewInfo.cellId),elem=$(cell.element[0]),labelInputBox=elem.find(".graffiti-label-input");0===labelInputBox.length&&(labelInputBoxElem=$('<div tabindex="0" class="graffiti-label-input"><input type="text" maxlength="50" placeholder="'+localizer.getString("ENTER_LABEL")+'"/></div>'),labelInputBox=labelInputBoxElem.appendTo(elem),labelInputBox.bind("keydown keyup",function(e){graffiti.handleLabelInput(e)}));var penColor=state.getDrawingPenAttribute("color");return"white"===penColor?labelInputBox.find("input").css({color:"black"}):labelInputBox.find("input").css({color:penColor}),labelInputBox},showLabelInputBox:function(){graffiti.clearAnyActiveStickerStages(),graffiti.hideLabelInputBoxes();var labelInputBox=graffiti.placeLabelInputBox(),currentPointerPosition=state.getPointerPosition(),viewInfo=state.getViewInfo(),adjustedPosition=utils.subtractCoords(viewInfo.outerCellRect,currentPointerPosition),verticalAdjust=parseInt(labelInputBox.height()/2);adjustedPosition.y=adjustedPosition.y-verticalAdjust,labelInputBox.show().css({left:adjustedPosition.x+"px",top:adjustedPosition.y+"px"}).find("input").val("").focus();var outerCellRect=viewInfo.outerCellRect,mouseDownPosition=state.getDrawingPenAttribute("mouseDownPosition");state.updateDrawingState([{change:"positions",data:{positions:{start:{x:mouseDownPosition.x-outerCellRect.left,y:mouseDownPosition.y-outerCellRect.top-verticalAdjust},end:{x:mouseDownPosition.x+1-outerCellRect.left,y:mouseDownPosition.y+1-outerCellRect.top-verticalAdjust}}}},{change:"downInPromptArea",data:viewInfo.inPromptArea},{change:"downInMarkdown",data:viewInfo.downInMarkdown},{change:"promptWidth",data:viewInfo.promptWidth}])},hideLabelInputBoxes:function(){console.log("Graffiti: Ending labelling"),$(".graffiti-label-input").val("").hide()},handleLabelInput:function(e){if(9===e.which&&e.preventDefault(),e.stopPropagation(),"keyup"===e.type&&"recording"===state.getActivity()){state.disableDrawingFadeClock();var inputBox=$(e.target),labelText=inputBox.val();state.updateDrawingState([{change:"label",data:""+labelText}]);var drawingPermanence=state.getDrawingPenAttribute("permanence");graffiti.updateStickerDisplayWhenRecording(drawingPermanence),state.storeHistoryRecord("stickers"),13!==e.which&&9!==e.which||(graffiti.hideLabelInputBoxes(),state.startDrawingFadeClock())}},setupSavingScrim:function(){var graffitiSavingScrim=$('<div id="graffiti-saving-scrim"><div>Saving Graffiti Recording. Please wait...</div></div>');graffiti.savingScrim=graffitiSavingScrim.prependTo(graffiti.notebookContainer)},showSavingScrim:function(){graffiti.savingScrim.css({display:"flex"})},hideSavingScrim:function(){graffiti.savingScrim.css({display:"none"})},resizeCanvases:function(){for(var cellElement,cellRect,canvasStyle,canvas,cellCanvas,canvasTypes=["permanent","temporary"],_i=0,_canvasTypes=canvasTypes;_i<_canvasTypes.length;_i++)for(var canvasType=_canvasTypes[_i],_i2=0,_Object$keys=Object.keys(graffiti.canvases[canvasType]);_i2<_Object$keys.length;_i2++){var cellId=_Object$keys[_i2];cell=utils.findCellByCellId(cellId),void 0!==cell&&(canvas=graffiti.canvases[canvasType][cellId],cellCanvas=canvas.canvas,cellElement=cell.element[0],cellRect=cellElement.getBoundingClientRect(),parseInt(cellRect.width)===parseInt(cellCanvas.width)&&parseInt(cellRect.height)===parseInt(cellCanvas.height)||(canvasStyle={width:cellRect.width+"px",height:cellRect.height+"px"},canvas.div.css(canvasStyle),cellCanvas.width=cellRect.width,cellCanvas.height=cellRect.height,canvas.cellRect=cellRect))}var notebookHeight=$("#notebook").outerHeight(!0);graffiti.drawingScreen.css({height:notebookHeight+"px"})},clearAnyActiveStickerStages:function(){for(var stickerStage,sticker,canvasTypes=["temporary","permanent"],_i3=0,_canvasTypes2=canvasTypes;_i3<_canvasTypes2.length;_i3++)for(var canvasType=_canvasTypes2[_i3],_i4=0,_Object$keys2=Object.keys(graffiti.stickers[canvasType]);_i4<_Object$keys2.length;_i4++){var cellId=_Object$keys2[_i4];if(stickerStage=graffiti.stickers[canvasType][cellId],void 0!==stickerStage.stickers)for(var _stickerIndex=0;_stickerIndex<stickerStage.stickers.length;++_stickerIndex)sticker=stickerStage.stickers[_stickerIndex],sticker.active&&(stickerStage.stickers[_stickerIndex].active=!1)}},resetGraffitiStickerStage:function(cellId,stickerPermanence){graffiti.stickers[stickerPermanence].hasOwnProperty(cellId)||(graffiti.stickers[stickerPermanence][cellId]={stickers:[],canvas:void 0})},placeStickerCanvas:function(cellId,stickerPermanence){if(graffiti.resetGraffitiStickerStage(cellId,stickerPermanence),void 0===graffiti.stickers[stickerPermanence][cellId].canvas){var cell=utils.findCellByCellId(cellId),cellElement=cell.element[0],cellRect=cellElement.getBoundingClientRect(),stickerDivId="graffiti-sticker-"+cellId;graffiti.stickers[stickerPermanence][cellId].canvas=$('<div class="graffiti-sticker-outer graffiti-canvas-type-'+stickerPermanence+'" id="'+stickerDivId+'" style="width:'+parseInt(cellRect.width)+"px;height:"+parseInt(cellRect.height)+'px;position:absolute;left:0;top:0;"></div>').appendTo(cellElement)}},placeCanvas:function(cellId,drawingPermanence){var cell=utils.findCellByCellId(cellId),cellElement=$(cell.element[0]),cellRect=cellElement[0].getBoundingClientRect();if(void 0!==graffiti.canvases[drawingPermanence][cellId])return cellRect;$('<div class="graffiti-canvas-outer graffiti-canvas-type-'+drawingPermanence+'"><canvas /></div>').appendTo(cellElement);var newCellCanvasDiv=cellElement.find(".graffiti-canvas-outer:last"),newCellCanvas=newCellCanvasDiv.find("canvas")[0],ctx=newCellCanvas.getContext("2d"),canvasStyle={width:cellRect.width+"px",height:cellRect.height+"px"};return newCellCanvasDiv.css(canvasStyle),newCellCanvas.width=cellRect.width,newCellCanvas.height=cellRect.height,ctx.setTransform(1,0,0,1,0,0),ctx.lineJoin="round",ctx.lineCap="round",graffiti.canvases[drawingPermanence][cellId]={div:newCellCanvasDiv,canvas:newCellCanvas,ctx:ctx,cellRect:cellRect},cellRect},setCanvasStyle:function(cellId,penType,penDashStyle,canvasColor,canvasPermanence){var canvas=graffiti.canvases[canvasPermanence][cellId],ctx=canvas.ctx;void 0===canvasColor&&(canvasColor="black"),"highlight"===penType?("black"===canvasColor&&(canvasColor="yellow"),ctx.lineWidth=15,ctx.shadowBlur=35,ctx.globalAlpha=.5):(ctx.shadowBlur=1,ctx.lineWidth=1.75,ctx.globalAlpha=1,ctx.setLineDash([]),"dashed"===penDashStyle&&(ctx.setLineDash([2,10]),ctx.lineDashOffset=2,ctx.lineWidth=3,ctx.globalAlpha=.5));var rawColorVal="#"+graffiti.penColors[canvasColor];void 0===rawColorVal&&(console.log("Graffiti: warning, rawColorVal is undefined"),rawColorVal="#000000"),ctx.strokeStyle=rawColorVal,ctx.shadowColor=rawColorVal},clearCanvas:function(canvasType,cellId){var canvas=graffiti.canvases[canvasType][cellId],ctx=canvas.ctx,cellRect=canvas.cellRect;ctx.clearRect(0,0,cellRect.width,cellRect.height)},clearCanvases:function(canvasType){if("all"===canvasType)for(var _i5=0,_Object$keys3=Object.keys(graffiti.canvases);_i5<_Object$keys3.length;_i5++)for(var _canvasType=_Object$keys3[_i5],_i6=0,_Object$keys4=Object.keys(graffiti.canvases[_canvasType]);_i6<_Object$keys4.length;_i6++){var cellId=_Object$keys4[_i6];graffiti.clearCanvas(_canvasType,cellId)}else for(var _i7=0,_Object$keys5=Object.keys(graffiti.canvases[canvasType]);_i7<_Object$keys5.length;_i7++){var _cellId=_Object$keys5[_i7];graffiti.clearCanvas(canvasType,_cellId)}$(".graffiti-canvas-type-temporary").css({opacity:state.getMaxDrawingOpacity()})},resetTemporaryCanvases:function(){console.log("Graffiti: resetTemporaryCanvases.");var opacity=state.getDrawingStateField("opacity"),maxOpacity=state.getMaxDrawingOpacity();opacity<maxOpacity&&(console.log("Graffiti: Clearing temp canvases, since fade was in progress."),graffiti.clearCanvases("temporary"),state.updateDrawingState([{change:"drawingActivity",data:"wipe"}]),state.storeHistoryRecord("drawings"),state.updateDrawingState([{change:"opacity",data:maxOpacity}]),state.disableDrawingFadeClock())},removeCanvasRecordsForCell:function(cellId){delete graffiti.canvases.permanent[cellId],delete graffiti.stickers.permanent[cellId],delete graffiti.canvases.temporary[cellId],delete graffiti.stickers.temporary[cellId]},updateDrawingOpacity:function(){var maxOpacity=state.getMaxDrawingOpacity(),currentOpacity=state.getDrawingStateField("opacity"),opacityInfo=state.calculateDrawingOpacity();switch(opacityInfo.status){case"max":if(currentOpacity!==maxOpacity){var drawingActivity=state.getDrawingStateField("drawingActivity");state.updateDrawingState([{change:"drawingActivity",data:drawingActivity},{change:"opacity",data:maxOpacity}])}break;case"fade":state.updateDrawingState([{change:"drawingActivity",data:"fade"},{change:"opacity",data:opacityInfo.opacity}]),state.storeHistoryRecord("drawings"),$(".graffiti-canvas-type-temporary").css({opacity:opacityInfo.opacity});break;case"fadeDone":graffiti.resetTemporaryCanvases(),graffiti.resetStickerCanvases("temporary")}},updateDrawingDisplay:function(cellId,ax,ay,bx,by,drawingPenType,drawingPermanence){if(graffiti.canvases[drawingPermanence].hasOwnProperty(cellId)){var ctx=graffiti.canvases[drawingPermanence][cellId].ctx;if("eraser"===drawingPenType){ctx.clearRect(ax-12.5,ay-12.5,25,25)}else ctx.beginPath(),ctx.moveTo(ax,ay),ctx.lineTo(bx,by),ctx.closePath(),ctx.stroke()}},wipeTemporaryStickerDomCanvases:function(){$(".graffiti-sticker-outer.graffiti-canvas-type-temporary").empty()},wipeAllStickerDomCanvases:function(){$(".graffiti-sticker-outer").empty()},resetStickerCanvases:function(typeOverride){for(var sticker,canvasTypes=void 0===typeOverride?["temporary","permanent"]:[typeOverride],_i8=0,_canvasTypes3=canvasTypes;_i8<_canvasTypes3.length;_i8++)for(var canvasType=_canvasTypes3[_i8],_i9=0,_Object$keys6=Object.keys(graffiti.stickers[canvasType]);_i9<_Object$keys6.length;_i9++){var cellId=_Object$keys6[_i9];sticker=graffiti.stickers[canvasType][cellId],void 0!==sticker.canvas&&sticker.canvas.empty(),sticker.stickers=[]}},processPositionsForCellTypeScaling:function(record,type){var positions,positionsRaw,cell,cellId,cellRects,denomWidth,denomHeight,scalarX=1,scalarY=1;return"cursor"===type?(void 0!==record.stickerInfo?(cellId=record.stickerInfo.cellId,denomWidth=record.stickerInfo.width,denomHeight=record.stickerInfo.height):(cellId=record.cellId,denomWidth=record.innerCellRect.width,denomHeight=record.innerCellRect.height),cell=utils.findCellByCellId(cellId),cellRects=utils.getCellRects(cell),state.getScaleCursorWithWindow()&&(scalarX=cellRects.innerCellRect.width/denomWidth,scalarY=cellRects.innerCellRect.height/denomHeight),positionsRaw={x:record.x,y:record.y},positions=!record.inMarkdownCell||record.isOverTerminal?{start:{x:positionsRaw.x,y:positionsRaw.y}}:record.inPromptArea||record.downInPromptArea?{start:{x:positionsRaw.x,y:positionsRaw.y*scalarY}}:{start:{x:(positionsRaw.x-record.promptWidth)*scalarX+cellRects.promptRect.width,y:positionsRaw.y*scalarY}}):(positionsRaw={start:{x:record.positions.start.x,y:record.positions.start.y},end:{x:record.positions.end.x,y:record.positions.end.y}},cell=utils.findCellByCellId(record.cellId),cellRects=utils.getCellRects(cell),state.getScaleCursorWithWindow()&&(scalarX=cellRects.innerCellRect.width/record.innerCellRect.width,scalarY=cellRects.innerCellRect.height/record.innerCellRect.height),record.pen.downInMarkdown?record.pen.downInPromptArea?positions={start:{x:positionsRaw.start.x,y:positionsRaw.start.y*scalarY},end:{x:positionsRaw.end.x,y:positionsRaw.end.y*scalarY}}:(record.pen.inPromptArea&&(scalarX=1),positions={start:{x:(positionsRaw.start.x-record.promptWidth)*scalarX+cellRects.promptRect.width,y:positionsRaw.start.y*scalarY},end:{x:(positionsRaw.end.x-record.promptWidth)*scalarX+cellRects.promptRect.width,y:positionsRaw.end.y*scalarY}}):positions={start:{x:positionsRaw.start.x,y:positionsRaw.start.y},end:{x:positionsRaw.end.x,y:positionsRaw.end.y}}),positions},drawStickersForCell:function(cellId,record){for(var canvasType,finalInnerHtml,activity=state.getActivity(),currentlyRecording="recording"===activity,canvasTypes=["temporary","permanent"],canvasElements={},newInnerHtml={},_i10=0,_canvasTypes4=canvasTypes;_i10<_canvasTypes4.length;_i10++)canvasType=_canvasTypes4[_i10],graffiti.placeStickerCanvas(cellId,canvasType),canvasElements[canvasType]={elem:graffiti.stickers[canvasType][cellId].canvas},canvasElements[canvasType].opacityOverride=canvasElements[canvasType].elem.css("opacity"),newInnerHtml[canvasType]=[];var stickerPermanence,stickerX,stickerY,fillOpacity,stickerWidth,stickerHeight,generatedStickerHtml,pen,type,positions,stickersRecords,dimensions;void 0!==record?stickersRecords=record.stickersRecords:(stickerPermanence=state.getDrawingPenAttribute("permanence"),stickersRecords=graffiti.stickers[stickerPermanence][cellId].stickers);var _iteratorNormalCompletion4=!0,_didIteratorError4=!1,_iteratorError4=void 0;try{for(var _step4,_iterator4=stickersRecords[Symbol.iterator]();!(_iteratorNormalCompletion4=(_step4=_iterator4.next()).done);_iteratorNormalCompletion4=!0){var stickerRecord=_step4.value;pen=stickerRecord.pen,type=pen.stickerType,stickerPermanence=pen.permanence,currentlyRecording?(positions=stickerRecord.positions,fillOpacity=state.getDrawingPenAttribute("fillOpacity")):(stickerRecord.cellId=cellId,positions=graffiti.processPositionsForCellTypeScaling(stickerRecord,"positions"),fillOpacity=stickerRecord.pen.fillOpacity),"lineWithArrow"===type?(stickerX=positions.start.x,stickerY=positions.start.y):(stickerX=Math.min(positions.start.x,positions.end.x),stickerY=Math.min(positions.start.y,positions.end.y)),stickerWidth=Math.abs(positions.end.x-positions.start.x),stickerHeight=Math.abs(positions.end.y-positions.start.y);var transformX=Math.sign(positions.end.x-positions.start.x),transformY=Math.sign(positions.end.y-positions.start.y),cssTransform="scale("+transformX+","+transformY+")";switch(stickerRecord.stickerOnGrid&&("checkmark"!==type&&"xmark"!==type&&"bomb"!==type&&"trophy"!==type&&"smiley"!==type&&"pi"!==type&&"alpha"!==type&&"beta"!==type&&"sigma"!==type&&"theta"!=type&&"angle"!==type||(stickerX=parseInt(positions.start.x/graffiti.minimumStickerSizeWithBuffer)*graffiti.minimumStickerSizeWithBuffer,stickerY=parseInt(positions.start.y/graffiti.minimumStickerSizeWithBuffer)*graffiti.minimumStickerSizeWithBuffer,stickerWidth=graffiti.minimumStickerSize,cssTransform=void 0),stickerHeight=stickerWidth),dimensions={x:stickerX,y:stickerY,width:stickerWidth,height:stickerHeight},generatedStickerHtml=void 0,type){case"rectangle":generatedStickerHtml=stickerLib.makeRectangle({color:pen.color,fill:pen.fill,dashed:pen.dash,strokeWidth:4,dimensions:dimensions,fillOpacity:fillOpacity});break;case"roundRectangle":generatedStickerHtml=stickerLib.makeRectangle({color:pen.color,fill:pen.fill,dashed:pen.dash,strokeWidth:4,rx:8,ry:8,dimensions:dimensions,fillOpacity:fillOpacity});break;case"isocelesTriangle":generatedStickerHtml=stickerLib.makeIsocelesTriangle({color:pen.color,fill:pen.fill,dashed:pen.dash,strokeWidth:4,dimensions:dimensions,cssTransform:cssTransform,fillOpacity:fillOpacity});break;case"rightTriangle":generatedStickerHtml=stickerLib.makeRightTriangle({color:pen.color,fill:pen.fill,dashed:pen.dash,dimensions:dimensions,strokeWidth:4,cssTransform:cssTransform,fillOpacity:fillOpacity});break;case"ellipse":generatedStickerHtml=stickerLib.makeEllipse({color:pen.color,fill:pen.fill,dashed:pen.dash,strokeWidth:3,dimensions:dimensions,fillOpacity:fillOpacity,buffer:4});break;case"checkmark":generatedStickerHtml=stickerLib.makeCheckmark({color:pen.color,fill:pen.fill,dashed:pen.dash,dimensions:dimensions});break;case"xmark":generatedStickerHtml=stickerLib.makeXmark({strokeWidth:2,color:"red",dashed:pen.dash,dimensions:dimensions});break;case"grid":generatedStickerHtml=stickerLib.makeGrid({color:pen.color,fill:pen.fill,dashed:pen.dash,dimensions:dimensions,cssTransform:cssTransform,strokeWidth:1});break;case"axis":generatedStickerHtml=stickerLib.makeAxis({strokeWidth:2,color:pen.color,fill:pen.fill,dashed:pen.dash,dimensions:dimensions,cssTransform:cssTransform});break;case"bomb":generatedStickerHtml=stickerLib.makeBomb({color:pen.color,fill:pen.fill,dashed:pen.dash,dimensions:dimensions,cssTransform:cssTransform});break;case"trophy":generatedStickerHtml=stickerLib.makeTrophy({color:pen.color,fill:pen.fill,dashed:pen.dash,dimensions:dimensions,cssTransform:cssTransform});break;case"smiley":generatedStickerHtml=stickerLib.makeSmiley({color:pen.color,fill:pen.fill,dashed:pen.dash,dimensions:dimensions,cssTransform:cssTransform,strokeWidth:2});break;case"ribbon":generatedStickerHtml=stickerLib.makeRibbon({color:pen.color,fill:pen.fill,dashed:pen.dash,strokeWidth:2,dimensions:dimensions});break;case"horizontalBrackets":generatedStickerHtml=stickerLib.makeHorizontalBrackets({color:pen.color,fill:pen.fill,dashed:pen.dash,strokeWidth:3,dimensions:dimensions});break;case"verticalBrackets":generatedStickerHtml=stickerLib.makeVerticalBrackets({color:pen.color,fill:pen.fill,dashed:pen.dash,strokeWidth:3,dimensions:dimensions});break;case"curlyBraces":generatedStickerHtml=stickerLib.makeSymmetricCurlyBraces({color:pen.color,dashed:pen.dash,strokeWidth:3,dimensions:dimensions});break;case"pi":generatedStickerHtml=stickerLib.makePi({color:pen.color,dashed:pen.dash,strokeWidth:2,dimensions:dimensions,cssTransform:cssTransform});break;case"alpha":generatedStickerHtml=stickerLib.makeAlpha({color:pen.color,dashed:pen.dash,strokeWidth:2,dimensions:dimensions,cssTransform:cssTransform});break;case"beta":generatedStickerHtml=stickerLib.makeBeta({color:pen.color,dashed:pen.dash,strokeWidth:2,dimensions:dimensions,cssTransform:cssTransform});break;case"sigma":generatedStickerHtml=stickerLib.makeSigma({strokeWidth:1,color:pen.color,fill:pen.fill,dashed:pen.dash,dimensions:dimensions,cssTransform:cssTransform});break;case"theta":generatedStickerHtml=stickerLib.makeTheta({strokeWidth:1,color:pen.color,fill:pen.fill,dashed:pen.dash,dimensions:dimensions,cssTransform:cssTransform});break;case"angle":generatedStickerHtml=stickerLib.makeAngle({strokeWidth:1,fill:pen.fill,color:pen.color,dashed:pen.dash,dimensions:dimensions,cssTransform:cssTransform});break;case"lineWithArrow":generatedStickerHtml=stickerLib.makeLine({color:pen.color,dashed:pen.dash,dimensions:dimensions,endpoints:{p1:{x:positions.start.x,y:positions.start.y},p2:{x:positions.end.x,y:positions.end.y}},lineStartOffset:{x:0,y:0},usesArrow:!0,arrowHeadSize:6});break;case"label":void 0!==pen.label&&(dimensions.width=15*pen.label.length,dimensions.height=18,generatedStickerHtml=stickerLib.makeLabelHtml({color:pen.color,label:pen.label,dimensions:dimensions,opacity:1}));break;case"custom":var stickerImageUrl=void 0;if(currentlyRecording){stickerImageUrl=state.getRecordingCellInfo().recordingRecord.stickerImageUrl}else stickerImageUrl=state.getStickerImageUrl();void 0!==stickerImageUrl?(generatedStickerHtml=stickerLib.makeCustom({dimensions:dimensions,imageUrl:stickerImageUrl,cssTransform:cssTransform}),canvasElements[stickerPermanence].opacityOverride=1):generatedStickerHtml=stickerLib.makeRectangle({color:"lightgrey",fill:pen.fill,dashed:"dashed",strokeWidth:3,dimensions:dimensions,fillOpacity:0})}void 0!==generatedStickerHtml&&newInnerHtml[stickerPermanence].push(generatedStickerHtml)}}catch(err){_didIteratorError4=!0,_iteratorError4=err}finally{try{_iteratorNormalCompletion4||null==_iterator4.return||_iterator4.return()}finally{if(_didIteratorError4)throw _iteratorError4}}for(var _i11=0,_canvasTypes5=canvasTypes;_i11<_canvasTypes5.length;_i11++)canvasType=_canvasTypes5[_i11],newInnerHtml[canvasType].length>0&&(canvasElements[canvasType].elem.empty(),finalInnerHtml=newInnerHtml[canvasType].join(""),canvasElements[canvasType].elem.html(finalInnerHtml),canvasElements[canvasType].elem.css({opacity:canvasElements[canvasType].opacityOverride}))},updateStickerDisplayWhenRecording:function(stickerPermanence){var cellId=state.getDrawingStateField("cellId");graffiti.resetGraffitiStickerStage(cellId,stickerPermanence);var stickers=graffiti.stickers[stickerPermanence][cellId].stickers,stickerRecord=state.createStickerRecord();stickerRecord.active=!0;var replaced=!1;if(stickers.length>0){var lastSticker=stickers.length-1;stickers[lastSticker].active&&(graffiti.stickers[stickerPermanence][cellId].stickers[lastSticker]=stickerRecord,replaced=!0)}replaced||stickers.push(stickerRecord),state.storeStickersStateForCell(graffiti.stickers[stickerPermanence][cellId].stickers,cellId),graffiti.drawStickersForCell(cellId)},updateDrawingDisplayWhenRecording:function(ax,ay,bx,by,viewInfo){if("recording"===state.getActivity()&&state.getDrawingPenAttribute("isDown")){var drawingRecordType,drawingActivity=state.getDrawingStateField("drawingActivity"),drawingPermanence=state.getDrawingPenAttribute("permanence"),cellId="sticker"===drawingActivity?state.getDrawingStateField("cellId"):viewInfo.cellId,cellRect=graffiti.placeCanvas(cellId,drawingPermanence);if("sticker"===drawingActivity){drawingRecordType="stickers";var mouseDownPosition=state.getDrawingPenAttribute("mouseDownPosition");state.updateDrawingState([{change:"positions",data:{positions:{start:{x:mouseDownPosition.x-cellRect.left,y:mouseDownPosition.y-cellRect.top},end:{x:bx-cellRect.left,y:by-cellRect.top}}}},{change:"inPromptArea",data:viewInfo.inPromptArea},{change:"promptWidth",data:viewInfo.promptWidth}]),graffiti.updateStickerDisplayWhenRecording(drawingPermanence)}else{drawingRecordType="drawings";var drawingPenType=state.getDrawingPenAttribute("type"),drawingPenDash=state.getDrawingPenAttribute("dash"),drawingPenColor=state.getDrawingPenAttribute("color");graffiti.setCanvasStyle(viewInfo.cellId,drawingPenType,drawingPenDash,drawingPenColor,drawingPermanence),graffiti.updateDrawingDisplay(viewInfo.cellId,ax-cellRect.left,ay-cellRect.top,bx-cellRect.left,by-cellRect.top,drawingPenType,drawingPermanence),state.updateDrawingState([{change:"positions",data:{positions:{start:{x:ax-cellRect.left,y:ay-cellRect.top},end:{x:bx-cellRect.left,y:by-cellRect.top}}}},{change:"cellId",data:viewInfo.cellId},{change:"inPromptArea",data:viewInfo.inPromptArea},{change:"promptWidth",data:viewInfo.promptWidth}])}state.storeHistoryRecord(drawingRecordType)}},redrawAllDrawings:function(targetTime){void 0===targetTime&&(targetTime=state.getTimePlayedSoFar()),graffiti.clearCanvases("all");var lastDrawFrameIndex=state.getIndexUpToTime("drawings",targetTime);if(void 0!==lastDrawFrameIndex)for(var record,index=0;index<lastDrawFrameIndex;++index)record=state.getHistoryItem("drawings",index),graffiti.updateDrawingCore(record)},redrawAllDrawingsWhenRecording:function(){if("recording"===state.getActivity()){var lastDrawFrameIndex=state.getLastFrameIndex("drawings");if(void 0!==lastDrawFrameIndex)for(var record,index=0;index<lastDrawFrameIndex;++index)record=state.getHistoryItem("drawings",index),graffiti.updateDrawingCore(record)}},extractTooltipCommands:function(markdown){var partsRecord,part,subParts,cleanedPart,commandParts=markdown.split(/\n/);if(null!==commandParts){if(commandParts.length>0){partsRecord={buttonName:void 0,captionPic:"",captionVideo:void 0,caption:"",playback_pic:void 0,autoplay:"never",replayAllCells:!1,hideTooltip:!1,playOnClick:!1,skipInfo:{type:state.skipTypes.absolute,factor:0},saveToFile:void 0,scaleCursorToWindow:!1,silenceWarnings:!1,swappingLabels:!1};for(var i=0;i<commandParts.length;++i)if(part=$.trim(commandParts[i]),0===part.indexOf("%%")&&0!==part.indexOf("%% ")&&(cleanedPart=part.replace("%%",""),subParts=$.trim(cleanedPart).split(/\s+/),subParts.length>0)){var subPart0=subParts[0];if(("button_name"===subPart0||"caption"===subPart0||"caption_pic"===subPart0||"caption_video_id"===subPart0||"narrator_name"===subPart0||"narrator_pic"===subPart0||"custom_sticker"===subPart0)&&1===subParts.length)continue;var subPart1=subParts[1],subPart2=subParts[2],subPart1ToEnd=subParts.slice(1).join(" ");switch(subPart0){case"comment":break;case"title_tag":state.setTooltipTitleTag(subPart1ToEnd);break;case"button_name":partsRecord.buttonName=subPart1ToEnd;break;case"caption":partsRecord.caption=subPart1ToEnd;break;case"caption_pic":partsRecord.captionPic=utils.renderMarkdown(subPart1);break;case"caption_video_id":0===subPart1.indexOf("images/")?partsRecord.captionVideo='<video width="150" height="75" autoplay><source src="'+subPart1+'" type="video/mp4"></video>':partsRecord.captionVideo='<iframe width="100" height=80 src="https://www.youtube.com/embed/'+subPart1+'?rel=0&amp;controls=0&amp;showinfo=0" frameborder="0"></iframe>';break;case"narrator_name":void 0!==subPart1&&(partsRecord.narratorName=subPart1ToEnd);break;case"narrator_pic":void 0!==subPart1&&(partsRecord.narratorPicture=subPart1);break;case"hide_player_after_playback_complete":state.setHidePlayerAfterPlayback(!0);break;case"dont_restore_cell_contents_after_playback":state.setDontRestoreCellContentsAfterPlayback(!0);break;case"autoplay":void 0!==subPart1&&(partsRecord.autoplay=subPart1.toLowerCase());break;case"play_on_click":case"click_to_play":partsRecord.playOnClick=!0;break;case"hide_tooltip":partsRecord.hideTooltip=!0;break;case"hide_play_button":partsRecord.hidePlayButton=!0;break;case"custom_sticker":partsRecord.stickerImageUrl=subPart1;break;case"skip_speed":var skipParts=subPart1.match(/(.*?)([cx]{0,1}$)/);null!==skipParts&&(partsRecord.skipInfo={factor:skipParts[1]},"0"===skipParts[1]?partsRecord.skipInfo.type=state.skipTypes.absolute:partsRecord.skipInfo.type="c"===skipParts[2]?state.skipTypes.compressed:state.skipTypes.rapid);break;case"save_to_file":void 0===partsRecord.saveToFile&&(partsRecord.saveToFile=[]);var saveFile=subParts[2].replace(/^"/,"").replace(/"$/,""),sourceCell=subPart1;partsRecord.saveToFile.push({cellId:sourceCell,path:saveFile});break;case"terminal_command":var command=subParts.slice(2).join(" ").replace(/^"/,"").replace(/"$/,"");partsRecord.terminalCommand={terminalId:subPart1,command:command};break;case"insert_data_from_file":partsRecord.insertDataFromFile={cellType:subPart1,filePath:subPart2.replace(/^"/,"").replace(/"$/,"")};break;case"label_swaps":var swaps=subParts.slice(1).join(" ").split("|");partsRecord.swappingLabels=!0,partsRecord.labelSwaps=swaps;break;case"replay_all_cells":partsRecord.replayAllCells=!0;break;case"scale_cursor_with_window":partsRecord.scaleCursorWithWindow=!0;break;case"silence_warnings":partsRecord.silenceWarnings=!0}}}return partsRecord}},refreshGraffitiSideMarkers:function(cell){var element=$(cell.element[0]),elemOffset=element.offset();element.find(".graffiti-right-side-marker").unbind("mouseenter mouseleave").remove();var i,marker,offset,yDiff,className,idMatch,metaData,markers=element.find(".graffiti-highlight");if(markers.length>0)for(i=0;i<markers.length;++i)marker=markers[i],className=marker.className,idMatch=className.match(/graffiti-(id_.[^\-]+-id_[^\s]+)/),metaData=null!==idMatch?idMatch[1]:void 0,offset=$(marker).offset(),yDiff=offset.top-elemOffset.top,markerIcon=stickerLib.makeRightSideMarker({color:"rgb(47,147,107)",dimensions:{x:element.width()+20,y:yDiff-2,width:18,height:12},metaTag:"graffiti-id|"+metaData,title:localizer.getString("GRAFFITI_PRESENT")}),$(markerIcon).appendTo(element);var markerIcons=element.find(".graffiti-right-side-marker");markerIcons.length>0&&markerIcons.bind("mouseenter mouseleave",function(e){var target=$(e.target);target.hasClass("graffiti-right-side-marker")||(target=target.parents(".graffiti-right-side-marker"));var graffitiId=target.attr("graffiti-id"),cellElement=target.parents(".cell"),graffitiElement=cellElement.find(".graffiti-"+graffitiId);"mouseenter"===e.type?graffitiElement.addClass("graffiti-highlight-extra"):graffitiElement.removeClass("graffiti-highlight-extra")})},refreshGraffitiHighlights:function(params){if(params.cellId=utils.getMetadataCellId(params.cell.metadata),"code"===params.cell.cell_type){var markClasses,recordings=state.getManifestRecordingsForCell(params.cellId),cm=params.cell.code_mirror,marks=cm.getAllMarks();if(params.clear){var _iteratorNormalCompletion5=!0,_didIteratorError5=!1,_iteratorError5=void 0;try{for(var _step5,_iterator5=marks[Symbol.iterator]();!(_iteratorNormalCompletion5=(_step5=_iterator5.next()).done);_iteratorNormalCompletion5=!0){_step5.value.clear()}}catch(err){_didIteratorError5=!0,_iteratorError5=err}finally{try{_iteratorNormalCompletion5||null==_iterator5.return||_iterator5.return()}finally{if(_didIteratorError5)throw _iteratorError5}}}else markClasses=marks.map(function(mark){return mark.className}).join(" ").replace(/graffiti-highlight /g,"");var allTokens=utils.collectCMTokens(cm);if(graffiti.tokenRanges[params.cellId]={},void 0!==recordings&&Object.keys(recordings).length>0)for(var recording,_recordingKey3,tokens,marker,range,_i12=0,_Object$keys7=Object.keys(recordings);_i12<_Object$keys7.length;_i12++)_recordingKey3=_Object$keys7[_i12],recording=recordings[_recordingKey3],tokens=recording.tokens,void 0!==(range=utils.getCMTokenRange(cm,tokens,allTokens))&&(graffiti.tokenRanges[params.cellId][_recordingKey3]=range,(params.clear||!params.clear&&void 0!==markClasses&&-1===markClasses.indexOf(_recordingKey3))&&(marker="graffiti-"+recording.cellId+"-"+_recordingKey3,cm.markText({line:range.start.line,ch:range.start.ch},{line:range.end.line,ch:range.end.ch},{className:"graffiti-highlight "+marker})))}},refreshAllGraffitiSideMarkers:function(){var activity=state.getActivity();if("playing"!==activity&&"recording"!==activity&&"scrubbing"!==activity){var cells=Jupyter.notebook.get_cells(),_iteratorNormalCompletion6=!0,_didIteratorError6=!1,_iteratorError6=void 0;try{for(var _step6,_iterator6=cells[Symbol.iterator]();!(_iteratorNormalCompletion6=(_step6=_iterator6.next()).done);_iteratorNormalCompletion6=!0){var _cell=_step6.value;graffiti.refreshGraffitiSideMarkers(_cell)}}catch(err){_didIteratorError6=!0,_iteratorError6=err}finally{try{_iteratorNormalCompletion6||null==_iterator6.return||_iterator6.return()}finally{if(_didIteratorError6)throw _iteratorError6}}}},refreshAllGraffitiHighlights:function(){var params,cells=Jupyter.notebook.get_cells(),_iteratorNormalCompletion7=!0,_didIteratorError7=!1,_iteratorError7=void 0;try{for(var _step7,_iterator7=cells[Symbol.iterator]();!(_iteratorNormalCompletion7=(_step7=_iterator7.next()).done);_iteratorNormalCompletion7=!0){var _cell2=_step7.value;params={cell:_cell2,clear:!0},graffiti.refreshGraffitiHighlights(params),graffiti.refreshGraffitiSideMarkers(_cell2)}}catch(err){_didIteratorError7=!0,_iteratorError7=err}finally{try{_iteratorNormalCompletion7||null==_iterator7.return||_iterator7.return()}finally{if(_didIteratorError7)throw _iteratorError7}}graffiti.cleanUpButtonBorders()},updateRefreshableCell:function(){var highlightRefreshCellId=state.getHighlightsRefreshCellId();if(void 0!==highlightRefreshCellId){var highlightRefreshCell=utils.findCellByCellId(highlightRefreshCellId);void 0!==highlightRefreshCell&&(graffiti.refreshGraffitiHighlights({cell:highlightRefreshCell,clear:!0}),graffiti.refreshGraffitiSideMarkers(highlightRefreshCell)),state.clearHighlightsRefreshableCell()}},hideTip:function(tip){graffiti.notebookContainer.find(".graffiti-tip .headline").remove(),graffiti.notebookContainer.find(".graffiti-tip").hide()},refreshGraffitiTooltipsCore:function(highlightElem,eventType){var activity=state.getActivity();highlightElem.hasClass("graffiti-highlight")||(highlightElem=highlightElem.parents(".graffiti-highlight"))
;var highlightElemRect=highlightElem[0].getBoundingClientRect(),highlightElemMaxDimension=Math.max(highlightElemRect.width,highlightElemRect.height),highlightElemMaxDimensionSquared=highlightElemMaxDimension*highlightElemMaxDimension,idMatch=highlightElem.attr("class").match(/graffiti-(id_.[^\-]+)-(id_[^\s]+)/);if(null!==idMatch){var cellId=idMatch[1],_recordingKey4=idMatch[2],viewInfo=state.getViewInfo();if(void 0===viewInfo)return void console.log("Graffiti: warning, viewInfo not defined in refreshGraffitiTooltipsCore!");var hoverCellId=viewInfo.cellId,hoverCell=utils.findCellByCellId(hoverCellId);if(void 0===hoverCell)return void console.log("Graffiti: warning, could not find hoverCell for hoverCellId:",hoverCellId);var outerInputElement,hoverCellElement=hoverCell.element[0],hoverCellElementPosition=$(hoverCellElement).position(),hoverCellType=hoverCell.cell_type;outerInputElement="markdown"===hoverCellType?$(hoverCellElement).find(".inner_cell"):$(hoverCellElement).find(".CodeMirror-lines");var recording=state.getManifestSingleRecording(cellId,_recordingKey4);if(void 0===recording)return;recording.hasMovie&&state.setPlayableMovie("tip",cellId,_recordingKey4,hoverCellId),state.setHidePlayerAfterPlayback(!1);var tooltipCommands=graffiti.extractTooltipCommands(recording.markdown);if(recording.playOnClick&&highlightElem.off("click dblclick").bind("click dblclick",function(e){return state.clearTipTimeout(),e.stopPropagation(),"recordingPending"===state.getActivity()?(graffiti.toggleRecording(),!0):(graffiti.playMovieViaUserClick(),!1)}),recording.hideTooltip||void 0!==recording.terminalCommand||"recording"===activity)return;var existingTip=graffiti.notebookContainer.find(".graffiti-tip");if("mouseleave"===eventType)state.setTipTimeout(function(){graffiti.hideTip()},500);else{var currentPointerPosition=state.getPointerPosition();state.setTipTimeout(function(){var newPointerPosition=state.getPointerPosition();if((newPointerPosition.x-currentPointerPosition.x)*(newPointerPosition.x-currentPointerPosition.x)+(newPointerPosition.y-currentPointerPosition.y)*(newPointerPosition.y-currentPointerPosition.y)>highlightElemMaxDimensionSquared)currentPointerPosition=state.getPointerPosition();else{var contentMarkdown="",headlineMarkdown="";void 0!==tooltipCommands&&(headlineMarkdown='<div class="headline"> <div>'+tooltipCommands.captionPic+"</div> <div>"+tooltipCommands.caption+"</div>"+(void 0!==tooltipCommands.captionVideo?' <div class="graffiti-video">'+tooltipCommands.captionVideo+"</div>":"")+"</div>"),contentMarkdown=utils.renderMarkdown(recording.markdown);var entireTipClickable=!1;0===contentMarkdown.length&&recording.hidePlayButton&&(contentMarkdown=utils.renderMarkdown("_"+localizer.getString("TOOLTIP_HINT")+"_"),entireTipClickable=!0);var tooltipContents=headlineMarkdown+'<div class="parts"><div class="info">'+contentMarkdown+"</div>";if(recording.hasMovie&&!recording.hidePlayButton&&(graffiti.tooltipButtonLabel=void 0!==tooltipCommands&&void 0!==tooltipCommands.buttonName?tooltipCommands.buttonName:"Play Movie",tooltipContents+='   <div class="movie"><button class="btn btn-default btn-small" id="graffiti-movie-play-btn">'+graffiti.tooltipButtonLabel+"</button></div>"),tooltipContents+="</div>",0===existingTip.length)existingTip=$('<div class="graffiti-tip" id="graffiti-tip">'+tooltipContents+"</div>").prependTo(graffiti.notebookContainer),existingTip.bind("mouseenter mouseleave",function(e){"mouseenter"===e.type?state.clearTipTimeout():graffiti.hideTip()});else{var currentTipInfo=state.getDisplayedTipInfo(),doUpdate=!0;0===headlineMarkdown.length&&(graffiti.forcedGraffitiTooltipRefresh||void 0!==currentTipInfo&&currentTipInfo.cellId===cellId&&currentTipInfo.recordingKey===_recordingKey4&&(doUpdate=!1)),graffiti.forcedGraffitiTooltipRefresh=!1,doUpdate?(existingTip.find("#graffiti-movie-play-btn").unbind("click"),existingTip.html(tooltipContents),state.setDisplayedTipInfo(cellId,_recordingKey4)):void 0!==graffiti.tooltipButtonLabel&&$("#graffiti-movie-play-btn").html(graffiti.tooltipButtonLabel),$("#graffiti-movie-play-btn").prop("disabled",!1)}(entireTipClickable?existingTip:existingTip.find("#graffiti-movie-play-btn")).unbind("click").click(function(e){return state.clearTipTimeout(),e.stopPropagation(),graffiti.playMovieViaUserClick(),!1});var tipLeft,outerInputOffset=outerInputElement.offset(),outerInputElementWidth=outerInputElement.width(),highlightElemOffset=highlightElem.offset(),existingTipWidth=existingTip.width(),existingTipHeight=existingTip.height(),tipTop=parseInt(highlightElemOffset.top-outerInputOffset.top)-existingTipHeight-graffiti.tipAboveFudge,anchorIsImage=!1;if("markdown"===hoverCellType){var anchorImage=highlightElem.find("img");if(anchorImage.length>0){var anchorElemOffset=anchorImage.offset();tipLeft=anchorElemOffset.left+anchorImage.width()/2-existingTipWidth/2,tipTop=anchorElemOffset.top-outerInputOffset.top+anchorImage.height()/2-existingTipHeight/2,anchorIsImage=!0}else{var anchorElem=highlightElem.find("i"),_anchorElemOffset=anchorElem.offset(),posCandidate1=outerInputElementWidth-existingTipWidth+outerInputOffset.left-graffiti.notebookContainerPadding,posCandidate2=_anchorElemOffset.left;tipLeft=parseInt(Math.min(posCandidate1,posCandidate2))}}else tipLeft=parseInt(Math.min(outerInputElementWidth-existingTipWidth,Math.max(highlightElemOffset.left,outerInputOffset.left)));var tipPosition={left:tipLeft,top:tipTop},headerRect=$("#header")[0].getBoundingClientRect();highlightElemRect.top-headerRect.bottom-20<existingTipHeight&&!anchorIsImage&&(tipPosition.top=highlightElemOffset.top-outerInputOffset.top+graffiti.cmLineHeight+graffiti.cmLineTipFudge),tipPosition.top+=hoverCellElementPosition.top;var positionPx={left:tipPosition.left+"px",top:tipPosition.top+"px"};existingTip.css(positionPx),existingTip.show(),state.updateUsageStats({type:"tip",data:{cellId:cellId,recordingKey:_recordingKey4}})}},425)}}},refreshGraffitiTooltips:function(){$(".graffiti-highlight").unbind("mouseenter mouseleave mousemove").bind("mouseenter mouseleave mousemove",function(e){graffiti.refreshGraffitiTooltipsCore($(e.target),e.type)})},handleExecuteCellViaGraffiti:function(){var selectedCell=Jupyter.notebook.get_selected_cell();if("code"===selectedCell.cell_type){var config=utils.getCellGraffitiConfig(selectedCell);if(void 0!==config&&config.hasOwnProperty("executeCellViaGraffiti")){var execKey=config.executeCellViaGraffiti,keyParts=execKey.split("_");return state.setPlayableMovie("cellExecute","id_"+keyParts[0],"id_"+keyParts[1]),graffiti.loadAndPlayMovie("cellExecute"),!0}}return!1},clearSkipKeyDownTimer:function(){clearTimeout(graffiti.skipKeyDownTimer),graffiti.skipKeyDownTimer=void 0},handleKeydown:function(e){var keyCode=e.which,activity=state.getActivity(),stopProp=!1;if("recording"===activity&&keyCode===graffiti.skipKeyCode&&(graffiti.skipKeyDownTimer=setTimeout(function(){console.log("Graffiti: ending recording by key press."),graffiti.skipKeyDownTimer=void 0,graffiti.endRecordingByKeyPress()},state.END_RECORDING_KEYDOWN_TIMEOUT)),void 0!==terminalLib.getFocusedTerminal())return e.stopPropagation(),!0;if("idle"===activity&&13===keyCode&&(e.ctrlKey||e.shiftKey)&&graffiti.handleExecuteCellViaGraffiti())return console.log("Graffiti: executedCellViaGraffiti ran, so: intercepting return-key press."),e.stopPropagation(),!0;if(!(48<=keyCode&&keyCode<=57||65<=keyCode&&keyCode<=90||37<=keyCode&&keyCode<=40||32===keyCode)||"playing"!==activity||e.metaKey||e.ctrlKey||e.altKey)switch(keyCode){case 27:stopProp=!0,"playing"!==activity&&"playbackPaused"!==activity&&"playbackPending"!==activity&&"scrubbing"!==activity||(graffiti.cancelPlayback(),state.updateUsageStats({type:"play",data:{actions:["userHitEscape"]}}));break;case 16:state.setShiftKeyIsDown(!0),state.updateDrawingState([{change:"stickerOnGrid",data:!0}])}else stopProp=!0,graffiti.togglePlayback();return!stopProp||(e.preventDefault(),e.stopPropagation(),!1)},handleKeyup:function(e){var keyCode=e.which;if(16===keyCode)state.setShiftKeyIsDown(!1),state.updateDrawingState([{change:"stickerOnGrid",data:!1}]);else if(keyCode===graffiti.skipKeyCode&&void 0!==graffiti.skipKeyDownTimer)return graffiti.clearSkipKeyDownTimer(),graffiti.toggleRecordingSkip(),!0;return!1},handleGeneralClick:function(e){return graffiti.clearSkipKeyDownTimer(),!1},setupBackgroundEvents:function(){console.log("Graffiti: setupBackgroundEvents"),graffiti.sitePanel.on("scroll",function(e){var viewInfo=(graffiti.notebookPanel.height(),utils.collectViewInfo(state.getPointerPosition().x,state.getPointerPosition().y,graffiti.notebookPanel.height(),graffiti.sitePanel.scrollTop()-state.getScrollTop()));return state.setScrollTop(graffiti.sitePanel.scrollTop()),state.storeViewInfo(viewInfo),state.storeHistoryRecord("scroll"),"playbackPaused"===state.getActivity()&&graffiti.undimGraffitiCursor(),!0}),$("body").keydown(function(e){return graffiti.handleKeydown(e)}),$("body").keyup(function(e){return graffiti.handleKeyup(e)}),$("body, .cell").click(function(e){graffiti.handleGeneralClick(e)}),window.onmousemove=function(e){var previousPointerPosition=state.getPointerPosition(),previousPointerX=previousPointerPosition.x,previousPointerY=previousPointerPosition.y;state.storePointerPosition(e.clientX,e.clientY);var viewInfo=utils.collectViewInfo(e.clientX,e.clientY,graffiti.notebookPanel.height(),graffiti.sitePanel.scrollTop()-state.getScrollTop());state.setScrollTop(graffiti.sitePanel.scrollTop()),state.storeViewInfo(viewInfo),state.storeHistoryRecord("pointer");var doDrawingDisplayUpdate=!0;"sticker"===state.getDrawingStateField("drawingActivity")&&("label"===state.getDrawingPenAttribute("stickerType")&&(doDrawingDisplayUpdate=!1));return doDrawingDisplayUpdate&&graffiti.updateDrawingDisplayWhenRecording(previousPointerX,previousPointerY,e.clientX,e.clientY,viewInfo),graffiti.placeControlPanel({}),!0};var navigateAwayHandler=function(e){console.log("Graffiti: navigate away handler, e:",e.type);var activity=state.getActivity();"playing"!==activity&&"playbackPaused"!==activity&&"playbackPending"!==activity&&"scrubbing"!=activity||graffiti.cancelPlaybackNoVisualUpdates(),void 0!==workspace.trackUsageStats&&workspace.trackUsageStats()};window.addEventListener("beforeunload",function(e){navigateAwayHandler(e)}),window.onunload=function(e){navigateAwayHandler(e)},window.addEventListener("dblclick",function(e){if("recording"===state.getActivity()){if($(e.target).parents(".text_cell").length>0)return console.log("Graffiti: intercepted doubleclick on markdown during recording, discarding it"),e.stopPropagation(),e.preventDefault(),!0}return!1},!0),window.onblur=function(e){graffiti.pausePlayback()},document.addEventListener("selectionchange",function(){if("recording"===state.getActivity()){state.clearSelectionSerialized();var viewInfo=state.getViewInfo(),cellId=viewInfo.cellId;if(void 0!==cellId){var parentNode,hoverCell=utils.findCellByCellId(cellId);if(parentNode="markdown"===hoverCell.cell_type?$(hoverCell.element).find(".rendered_html"):$(hoverCell.element).find(".output_subarea"),parentNode.length>0){var selectionSerialized=selectionSerializer.get(parentNode[0]);selectionSerialized.empty||(selectionSerialized.cellType=hoverCell.cell_type,selectionSerialized.cellId=cellId,state.setSelectionSerialized(selectionSerialized),state.storeHistoryRecord("selections"))}}}}),graffiti.handleSliderDragDebounced=_.debounce(graffiti.handleSliderDrag,20,!1),console.log("Graffiti: Background setup complete.")},setRecordingTakeId:function(recordingRecord){(void 0===recordingRecord.activeTakeId||state.getMovieRecordingStarted())&&(recordingRecord.activeTakeId=utils.generateUniqueId())},storeRecordingInfoInCell:function(isOldGraffiti){var recordingRecord,newRecording,recordingCell,recordingCellId,recordingKey,selectedTokens=graffiti.selectedTokens;return void 0===isOldGraffiti&&(isOldGraffiti=selectedTokens.isIntersecting),isOldGraffiti?(recordingCellId=utils.extractRecordingCellId(selectedTokens),recordingCell=selectedTokens.recordingCell,recordingKey=selectedTokens.recordingKey,recordingRecord=state.getManifestSingleRecording(recordingCellId,recordingKey),graffiti.previousActiveTakeId=recordingRecord.activeTakeId,graffiti.setRecordingTakeId(recordingRecord),newRecording=!1):(graffiti.previousActiveTakeId=void 0,recordingCell=Jupyter.notebook.get_selected_cell(),recordingCellId=utils.getMetadataCellId(recordingCell.metadata),recordingKey=utils.generateUniqueId(),newRecording=!0,recordingRecord={cellId:recordingCellId,cellType:recordingCell.cell_type,createDate:utils.getNow(),inProgress:!0,tokens:$.extend({},graffiti.selectedTokens.tokens),range:$.extend({},graffiti.selectedTokens.range),allTokensString:graffiti.selectedTokens.allTokensString,markdown:"",authorId:state.getAuthorId(),authorType:state.getAuthorType(),activeTakeId:void 0,hasMovie:!1},state.setSingleManifestRecording(recordingCellId,recordingKey,recordingRecord)),state.storeRecordingCellInfo({newRecording:newRecording,recordingRecord:recordingRecord,recordingCell:recordingCell,recordingCellId:recordingCellId,recordingKey:recordingKey,scrollTop:graffiti.sitePanel.scrollTop()}),recordingRecord},clearHighlightMarkText:function(){void 0!==graffiti.highlightMarkText&&(graffiti.highlightMarkText.clear(),graffiti.highlightMarkText=void 0)},highlightIntersectingGraffitiRange:function(){if(graffiti.clearHighlightMarkText(),"view"!==state.getAccessLevel()){var cell=graffiti.selectedTokens.recordingCell;if(void 0!==cell){var cm=cell.code_mirror,startLoc=cm.posFromIndex(graffiti.selectedTokens.range.start),endLoc=cm.posFromIndex(graffiti.selectedTokens.range.end);graffiti.highlightMarkText=cm.markText(startLoc,endLoc,{className:"graffiti-selected"})}}},selectIntersectingGraffitiRange:function(){if(!graffiti.selectedTokens.noTokensPresent){var recordingCellInfo=state.getRecordingCellInfo(),recordingCell=recordingCellInfo.recordingCell,cm=recordingCell.code_mirror,startLoc=cm.posFromIndex(graffiti.selectedTokens.range.start),endLoc=cm.posFromIndex(graffiti.selectedTokens.range.end);cm.setSelections([{anchor:startLoc,head:endLoc}]),graffiti.selectedTokens=utils.findSelectionTokens(recordingCell,graffiti.tokenRanges,state),graffiti.highlightIntersectingGraffitiRange()}},editGraffiti:function(){var editableText;graffiti.changeActivity("graffiting"),state.setLastEditActivityTime();var isNewGraffiti=!graffiti.selectedTokens.isIntersecting,isOldGraffiti=!isNewGraffiti,recordingRecord=graffiti.storeRecordingInfoInCell(isOldGraffiti),activeCellIndex=Jupyter.notebook.get_selected_index(),isMarkdownCell="markdown"===recordingRecord.cellType,isCodeCell="code"===recordingRecord.cellType,graffitiEditCell=Jupyter.notebook.insert_cell_above("markdown"),editCellIndex=utils.findCellIndexByCellId(utils.getMetadataCellId(graffitiEditCell.metadata));if(Jupyter.notebook.select(editCellIndex),(isNewGraffiti||isCodeCell||isMarkdownCell&&isOldGraffiti)&&(utils.setMetadataCellId(graffitiEditCell.metadata,utils.generateUniqueId()),utils.refreshCellMaps(),state.setGraffitiEditCellId(utils.getMetadataCellId(graffitiEditCell.metadata))),editableText=isNewGraffiti?isMarkdownCell?localizer.getString("BELOW_TYPE_MARKDOWN")+"%%play_on_click\n%%hide_play_button\n":localizer.getString("BELOW_TYPE_MARKDOWN")+graffiti.selectedTokens.allTokensString:recordingRecord.markdown,graffitiEditCell.set_text(editableText),isCodeCell||isOldGraffiti){Jupyter.notebook.scroll_to_cell(Math.max(0,activeCellIndex),500);Jupyter.notebook.get_selected_cell().unselect(),graffitiEditCell.select(),graffitiEditCell.code_mirror.focus(),graffitiEditCell.code_mirror.setSelection({line:2,ch:0},{line:1e4,ch:1e4})}isMarkdownCell&&isNewGraffiti&&graffiti.finishGraffiti(!0).then(function(){graffiti.setRecordingTakeId(recordingRecord),graffiti.beginMovieRecordingProcess(!0,recordingRecord)})},finishGraffiti:function(doSave){if("graffiting"===state.getActivity()){var recordingCellInfo=state.getRecordingCellInfo(),recordingCell=recordingCellInfo.recordingCell,editCellIndex=utils.findCellIndexByCellId(state.getGraffitiEditCellId()),editCellContents="";if(void 0!==editCellIndex){editCellContents=utils.findCellByCellId(state.getGraffitiEditCellId()).get_text(),Jupyter.notebook.delete_cell(editCellIndex);var recordings=state.getManifestRecordingsForCell(recordingCellInfo.recordingCellId);if(doSave){recordingCellInfo.newRecording&&(recordings[recordingCellInfo.recordingKey]=recordingCellInfo.recordingRecord),recordings[recordingCellInfo.recordingKey].markdown=editCellContents;var tooltipCommands=graffiti.extractTooltipCommands(editCellContents),recording=recordings[recordingCellInfo.recordingKey];recording.autoplay="never","always"===tooltipCommands.autoplay?recording.autoplay="always":"once"===tooltipCommands.autoplay&&(recording.autoplay="once",recording.playedOnce=!1),recording.playOnClick=tooltipCommands.playOnClick,recording.hideTooltip=tooltipCommands.hideTooltip,recording.hidePlayButton=tooltipCommands.hidePlayButton,recording.narratorName=tooltipCommands.narratorName,recording.narratorPicture=tooltipCommands.narratorPicture,recording.stickerImageUrl=tooltipCommands.stickerImageUrl,recording.skipInfo=$.extend({},tooltipCommands.skipInfo),recording.saveToFile=tooltipCommands.saveToFile,recording.terminalCommand=tooltipCommands.terminalCommand,recording.insertDataFromFile=tooltipCommands.insertDataFromFile,recording.silenceWarnings=tooltipCommands.silenceWarnings,recording.replayAllCells=tooltipCommands.replayAllCells,recording.scaleCursorWithWindow=tooltipCommands.scaleCursorWithWindow,recording.swappingLabels=tooltipCommands.swappingLabels,recording.labelSwaps=tooltipCommands.labelSwaps,state.updateUsageStats({type:"create",data:{createDate:recording.createDate,cellId:recordingCellInfo.recordingCellId,recordingKey:recordingCellInfo.recordingKey,numTakes:void 0===recording.takes?0:Object.keys(recording.takes).length}})}else recordingCellInfo.newRecording&&state.removeManifestEntry(recordingCellInfo.recordingCellId,recordingCellInfo.recordingKey)}if(storage.storeManifest(),"markdown"===recordingCell.cell_type&&recordingCellInfo.newRecording&&doSave){var contents=recordingCell.get_text(),parts=[];parts.push(contents.substring(0,recordingCellInfo.recordingRecord.range.start)),parts.push(contents.substring(recordingCellInfo.recordingRecord.range.start,recordingCellInfo.recordingRecord.range.end)),parts.push(contents.substring(recordingCellInfo.recordingRecord.range.end));var spanOpenTag='<span class="graffiti-highlight graffiti-'+recordingCellInfo.recordingCellId+"-"+recordingCellInfo.recordingKey+'"><i></i>',newContents=parts[0]+spanOpenTag+parts[1]+"</span>"+parts[2];recordingCell.set_text(newContents)}return utils.saveNotebookDebounced(),new Promise(function(resolve){graffiti.sitePanel.animate({scrollTop:recordingCellInfo.scrollTop},500),"markdown"===recordingCellInfo.recordingRecord.cellType&&recordingCell.render(),graffiti.changeActivity("idle"),recordingCell.code_mirror.focus(),doSave?(graffiti.refreshGraffitiHighlights({cell:recordingCell,clear:!1}),graffiti.forcedGraffitiTooltipRefresh=!0):graffiti.refreshGraffitiHighlights({cell:recordingCell,clear:!0}),graffiti.refreshGraffitiTooltipsDebounced(),graffiti.refreshAllGraffitiSideMarkers(),utils.refreshCellMaps(),state.refreshCellIdToGraffitiMap(),resolve()})}},removeGraffitiCore:function(recordingCellId,recordingKey){var locationCell,recordingCell=utils.findCellByCellId(recordingCellId);void 0!==recordingCell&&"code"===recordingCell.cell_type&&(locationCell=recordingCell);var locationCellId=utils.findCellIdByLocationMap(recordingCellId,recordingKey);void 0!==locationCellId&&(locationCell=utils.findCellByCellId(locationCellId));state.getActivity();if("markdown"===locationCell.cell_type){for(var results,contents=locationCell.get_text(),spanRegex=RegExp('<span class="graffiti-highlight graffiti-'+recordingCellId+"-"+recordingKey+'"><i></i>(.*?)</span>',"gm"),foundContents=[];null!==(results=spanRegex.exec(contents));)foundContents.push(results);if(foundContents.length>0){var innerContents=foundContents[0][1],sourceContents='<span class="graffiti-highlight graffiti-'+recordingCellId+"-"+recordingKey+'"><i></i>'+innerContents+"</span>",cleanedContents=contents.replace(sourceContents,innerContents);utils.selectCellByCellId(locationCellId),setTimeout(function(){locationCell.set_text(cleanedContents),locationCell.render()},0)}}storage.deleteMovie(recordingCellId,recordingKey),utils.queueSaveNotebookCallback(function(){graffiti.updateControlPanels()}),utils.saveNotebookDebounced()},removeAllGraffitis:function(graffitiDisabled){var manifest=state.getManifest();state.setManifest({});for(var recordingCellId,recordingCell,recordingKeys,destructions=0,_i13=0,_Object$keys8=Object.keys(manifest);_i13<_Object$keys8.length;_i13++)if(recordingCellId=_Object$keys8[_i13],console.log("Graffiti: Removing recordings from cell:",recordingCellId),recordingKeys=Object.keys(manifest[recordingCellId]),recordingKeys.length>0){recordingCell=utils.findCellByCellId(recordingCellId);var _iteratorNormalCompletion8=!0,_didIteratorError8=!1,_iteratorError8=void 0;try{for(var _step8,_iterator8=recordingKeys[Symbol.iterator]();!(_iteratorNormalCompletion8=(_step8=_iterator8.next()).done);_iteratorNormalCompletion8=!0)recordingKey=_step8.value,console.log("Graffiti: Removing recording id:",recordingKey),manifest[recordingCellId][recordingKey],destructions++,graffiti.removeGraffitiCore(recordingCellId,recordingKey),void 0!==recordingCell&&(graffiti.refreshGraffitiHighlights({cell:recordingCell,clear:!0}),graffiti.refreshGraffitiSideMarkers(recordingCell))}catch(err){_didIteratorError8=!0,_iteratorError8=err}finally{try{_iteratorNormalCompletion8||null==_iterator8.return||_iterator8.return()}finally{if(_didIteratorError8)throw _iteratorError8}}}storage.storeManifest(),graffiti.highlightIntersectingGraffitiRange(),graffiti.refreshGraffitiTooltips(),graffiti.updateControlPanels(),graffitiDisabled&&Jupyter.notebook.metadata.hasOwnProperty("graffiti")&&(storage.deleteDataDirectory(Jupyter.notebook.metadata.graffiti.id),storage.removeGraffitiIds(),graffiti.changeAccessLevel("view"),graffiti.initSetupButton()),utils.queueSaveNotebookCallback(function(){0===destructions&&(destructions="all");var title,body;graffitiDisabled?(title="Graffiti has been disabled on this Notebook.",body="We removed "+destructions+" graffitis, and you will need to Enable Graffiti again to use Graffiti in this notebook.You will also now want to remove the Graffiti data directory (jupytergraffiti_data) manually."):(title="Your notebook is now cleaned of all graffiti.",body="We removed "+destructions+" graffitis. Feel free to create new ones."),dialog.modal({title:title,body:body,sanitize:!1,buttons:{OK:{click:function(e){console.log("Graffiti: You clicked ok, you want to remove ALL graffitis")}}}})}),utils.saveNotebookDebounced()},refreshAfterDeletions:function(recordingCellId){graffiti.highlightIntersectingGraffitiRange();var recordingCell=utils.findCellByCellId(recordingCellId);void 0!==recordingCell&&(graffiti.refreshGraffitiHighlights({cell:recordingCell,clear:!0}),graffiti.refreshGraffitiSideMarkers(recordingCell)),graffiti.refreshGraffitiTooltips(),graffiti.updateControlPanels()},removeGraffiti:function(recordingCellId,recordingKey){graffiti.removeGraffitiCore(recordingCellId,recordingKey),state.removeManifestEntry(recordingCellId,recordingKey)&&(storage.storeManifest(),graffiti.refreshAfterDeletions(recordingCellId))},removeAllGraffitisWithConfirmation:function(){dialog.modal({title:"Are you sure you want to remove ALL graffitis from this notebook?",body:"Note: this cannot be undone.",sanitize:!1,buttons:{OK:{click:function(e){console.log("Graffiti: You clicked ok, you want to remove ALL graffitis"),graffiti.removeAllGraffitis(!1)}},Cancel:{click:function(e){console.log("Graffiti: you cancelled:",$(e.target).parent())}}}})},removeUnusedTakes:function(recordingFullId){var parts=utils.parseRecordingFullId(recordingFullId);void 0!==utils.findCellByCellId(parts.recordingCellId)&&(storage.removeUnusedTakes(parts.recordingCellId,parts.recordingKey),graffiti.refreshAfterDeletions(recordingCellId))},removeAllUnusedTakes:function(){for(var recordingCellId,recordingKeys,manifest=state.getManifest(),deletedTakes=0,_i14=0,_Object$keys9=Object.keys(manifest);_i14<_Object$keys9.length;_i14++)if(recordingCellId=_Object$keys9[_i14],console.log("Graffiti: Removing unused takes from cell:",recordingCellId),recordingKeys=Object.keys(manifest[recordingCellId]),recordingKeys.length>0){utils.findCellByCellId(recordingCellId);var _iteratorNormalCompletion9=!0,_didIteratorError9=!1,_iteratorError9=void 0;try{for(var _step9,_iterator9=recordingKeys[Symbol.iterator]();!(_iteratorNormalCompletion9=(_step9=_iterator9.next()).done);_iteratorNormalCompletion9=!0)recordingKey=_step9.value,console.log("Graffiti: Removing unused takes from recording id:",recordingKey),manifest[recordingCellId][recordingKey],deletedTakes+=storage.removeUnusedTakesCore(recordingCellId,recordingKey)}catch(err){_didIteratorError9=!0,_iteratorError9=err}finally{try{_iteratorNormalCompletion9||null==_iterator9.return||_iterator9.return()}finally{if(_didIteratorError9)throw _iteratorError9}}}storage.storeManifest(),graffiti.highlightIntersectingGraffitiRange(),graffiti.refreshGraffitiTooltips(),graffiti.updateControlPanels(),utils.queueSaveNotebookCallback(function(){0===deletedTakes?deletedTakes="all":(storage.storeManifest(),storage.cleanUpExecutorCell());var body="We removed "+deletedTakes+" unused takes.";dialog.modal({title:"Unused takes removed.",body:body,sanitize:!1,buttons:{OK:{click:function(e){console.log("Graffiti: You clicked ok")}}}})}),utils.saveNotebookDebounced()},removeAllUnusedTakesWithConfirmation:function(){dialog.modal({title:"Are you sure you want to remove ALL unused takes from this notebook?",body:"Note: this cannot be undone.",sanitize:!1,buttons:{OK:{click:function(e){console.log("Graffiti: You clicked ok, you want to remove unused takes."),graffiti.removeAllUnusedTakes()}},Cancel:{click:function(e){console.log("Graffiti: you cancelled:",$(e.target).parent())}}}})},removeUnusedTakesWithConfirmation:function(recordingFullId){dialog.modal({title:"Are you sure you want to remove unused takes from this recording?",body:"Note: this cannot be undone.",sanitize:!1,buttons:{OK:{click:function(e){console.log("Graffiti: You clicked ok, you want to remove unused takes."),graffiti.removeUnusedTakes(recordingFullId)}},Cancel:{click:function(e){console.log("Graffiti: you cancelled:",$(e.target).parent())}}}})},removeGraffitiWithPrompt:function(){var selectedTokens=graffiti.selectedTokens;if(selectedTokens.isIntersecting){var _recordingCellId3=utils.extractRecordingCellId(selectedTokens),_recordingKey5=selectedTokens.recordingKey,recording=state.getManifestSingleRecording(_recordingCellId3,_recordingKey5),graffitizedText=selectedTokens.allTokensString;void 0===graffitizedText&&(graffitizedText=void 0!==recording.allTokensString?recording.allTokensString:recording.markdown);var content='(Please Note: this cannot be undone.)<br/><b>Graffiti\'d text:&nbsp;</b><span class="graffiti-text-display">'+graffitizedText+"</span><br/><b>Graffiti contents:</b>"+utils.renderMarkdown(recording.markdown)+"<br/>";dialog.modal({title:"Are you sure you want to remove this Graffiti?",body:content,sanitize:!1,buttons:{OK:{click:function(e){console.log("Graffiti: you clicked ok, you want to remove graffiti:",$(e.target).parent()),graffiti.removeGraffiti(_recordingCellId3,_recordingKey5)}},Cancel:{click:function(e){console.log("Graffiti: you cancelled:",$(e.target).parent())}}}}).on("hidden.bs.modal",function(e){console.log("Graffiti: escaped the removeGraffitiWithPrompt modal.")})}},disableGraffiti:function(){graffiti.removeAllGraffitis(!0)},disableGraffitiWithConfirmation:function(){dialog.modal({title:"Are you sure you want to disable Graffiti?",body:"Clicking OK will <i>remove any trace of Graffiti</i> in this notebook, setting it to a state as if you had never enabled Graffiti. <br><br><b>NOTE</b>: This <b>cannot</b> be undone.",sanitize:!1,buttons:{OK:{click:function(e){console.log("Graffiti: you clicked ok, you want to disable graffiti:",$(e.target).parent()),graffiti.disableGraffiti()}},Cancel:{click:function(e){console.log("Graffiti: you cancelled:",$(e.target).parent())}}}})},updateAllGraffitiDisplays:function(){graffiti.refreshAllGraffitiHighlights(),graffiti.refreshGraffitiTooltipsDebounced()},setPendingRecording:function(){console.log("Graffiti: Setting pending recording."),graffiti.changeActivity("recordingPending"),state.restoreCellStates("selections")},beginMovieRecordingProcess:function(isOldGraffiti,recordingRecord){state.storeCellStates(),graffiti.preRecordingScrollTop=state.getScrollTop(),state.setMovieRecordingStarted(!0),void 0===recordingRecord&&(recordingRecord=graffiti.storeRecordingInfoInCell(isOldGraffiti)),"markdown"===recordingRecord.cellType&&(graffiti.selectedTokens.noTokensPresent||graffiti.selectedTokens.recordingCell.render()),graffiti.setPendingRecording()},addCMEventsToSingleCell:function(cell){graffiti.CMEvents[utils.getMetadataCellId(cell.metadata)]=!0;var cm=cell.code_mirror;cm.on("focus",function(cm,e){var activity=state.getActivity();if("recording"===activity){var cellId=utils.getMetadataCellId(cell.metadata);cellId!==state.getSelectedCellId()&&state.saveSelectedCellId(cellId),state.storeHistoryRecord("focus")}else if("recordingPending"===activity){var focusCellIndex=utils.findCellIndexByCodeMirror(cm);Jupyter.notebook.select(focusCellIndex),graffiti.toggleRecording()}graffiti.updateControlPanels(cm)}),cm.on("cursorActivity",function(cm,e){"idle"===state.getActivity()&&graffiti.updateControlPanels(cm);var affectedCell=utils.findCellByCodeMirror(cm);void 0===affectedCell&&(utils.refreshCellMaps(),affectedCell=utils.findCellByCodeMirror(cm),console.log("Graffiti: cursorActivity handler had to refreshCellMaps twice. Should never occur!")),state.storeCellIdAffectedByActivity(utils.getMetadataCellId(affectedCell.metadata)),state.storeHistoryRecord("selections"),graffiti.refreshGraffitiSideMarkers(affectedCell)}),cm.on("change",function(cm,changeObj){var affectedCell=utils.findCellByCodeMirror(cm),affectedCellId=utils.getMetadataCellId(affectedCell.metadata);void 0!==affectedCell&&(state.storeCellIdAffectedByActivity(affectedCellId),state.storeHistoryRecord("contents"),graffiti.executeSaveToFileDirectivesDebounced(affectedCellId),"idle"===state.getActivity()&&(state.setHighlightsRefreshCellId(utils.getMetadataCellId(affectedCell.metadata)),setTimeout(graffiti.updateRefreshableCell,250)))}),cm.on("mousedown",function(cm,e){}),cm.on("refresh",function(cm,e){}),cm.on("update",function(cm,e){graffiti.refreshGraffitiTooltipsDebounced()}),cm.on("scroll",function(cm,e){var pointerPosition=state.getPointerPosition(),viewInfo=utils.collectViewInfo(pointerPosition.x,pointerPosition.y,graffiti.notebookPanel.height(),graffiti.sitePanel.scrollTop()-state.getScrollTop());state.setScrollTop(graffiti.sitePanel.scrollTop()),state.storeViewInfo(viewInfo),state.storeHistoryRecord("innerScroll")})},addCMEventsToCells:function(){var inputCells=Jupyter.notebook.get_cells(),_iteratorNormalCompletion10=!0,_didIteratorError10=!1,_iteratorError10=void 0;try{for(var _step10,_iterator10=inputCells[Symbol.iterator]();!(_iteratorNormalCompletion10=(_step10=_iterator10.next()).done);_iteratorNormalCompletion10=!0){var _cell3=_step10.value;graffiti.CMEvents.hasOwnProperty(utils.getMetadataCellId(_cell3.metadata))||graffiti.addCMEventsToSingleCell(_cell3)}}catch(err){_didIteratorError10=!0,_iteratorError10=err}finally{try{_iteratorNormalCompletion10||null==_iterator10.return||_iterator10.return()}finally{if(_didIteratorError10)throw _iteratorError10}}},addCMEvents:function(){graffiti.addCMEventsToCells(),Jupyter.notebook.events.on("select.Cell",function(e,cell){
state.storeHistoryRecord("selectCell"),graffiti.refreshGraffitiTooltipsDebounced(),graffiti.updateControlPanels()}),Jupyter.notebook.events.on("create.Cell",function(e,results){var newCellId,newCell=results.cell,newCellIndex=results.index;newCellId=void 0===utils.getMetadataCellId(newCell.metadata)?utils.setMetadataCellId(newCell.metadata,utils.generateUniqueId()):utils.getMetadataCellId(newCell.metadata),utils.refreshCellMaps(),graffiti.addCMEventsToSingleCell(newCell),state.storeCellAddition(newCellId,newCellIndex),state.storeHistoryRecord("contents")}),Jupyter.notebook.events.on("delete.Cell",function(e,results){utils.refreshCellMaps();var deletedCell=results.cell;if(void 0!==deletedCell){var deletedCellId=utils.getMetadataCellId(deletedCell.metadata);void 0!==deletedCellId&&(graffiti.removeCanvasRecordsForCell(deletedCellId),terminalLib.removeTerminal(deletedCellId))}state.storeHistoryRecord("contents")}),Jupyter.notebook.events.on("finished_execute.CodeCell",function(e,results){utils.refreshCellMaps(),state.storeHistoryRecord("contents"),graffiti.resizeCanvases(),graffiti.redrawAllDrawingsWhenRecording()}),Jupyter.notebook.events.on("set_dirty.Notebook",function(e,results){utils.refreshCellMaps(),graffiti.runOnceOnNextRecordingTick=function(){state.storeHistoryRecord("contents")}}),Jupyter.notebook.events.on("rendered.MarkdownCell",function(e,results){if("graffiting"===state.getActivity()&&utils.getMetadataCellId(results.cell.metadata)===state.getGraffitiEditCellId()){var lastEditActivityTime=state.getLastEditActivityTime();void 0!==lastEditActivityTime&&utils.getNow()-lastEditActivityTime>250&&(console.log("Graffiti: rendered MarkdownCell event fired and editing with long enough delay, so finishing graffiti. e, results:",e,results),graffiti.finishGraffiti(!0),state.clearLastEditActivityTime())}graffiti.refreshAllGraffitiHighlights()}),Jupyter.notebook.events.on("shell_reply.Kernel",function(e,results){utils.refreshCellMaps(),"idle"===state.getActivity()&&(graffiti.updateAllGraffitiDisplays(),graffiti.updateControlPanels())})},stopRecordingCore:function(useCallback){audio.setExecuteCallback(useCallback),graffiti.clearCanvases("all"),graffiti.hideDrawingScreen(),graffiti.resetDrawingColor(),state.storeTerminalsContentsInHistory(),state.setSpeakingStatus(!1),state.finalizeHistory(),useCallback&&state.dumpHistory(),state.clearAnimationIntervals(),audio.stopRecording(),console.log("Graffiti: stopRecordingCore is refreshing."),state.restoreCellStates("contents"),graffiti.updateAllGraffitiDisplays(),graffiti.wipeAllStickerDomCanvases(),graffiti.resetStickerCanvases(),graffiti.deactivateAllPens(),graffiti.removeCellsAddedByPlaybackOrRecording(),graffiti.hideLabelInputBoxes(),state.restoreCellStates("selections"),state.restoreLineNumbersStates(),graffiti.sitePanel.animate({scrollTop:graffiti.preRecordingScrollTop},750),graffiti.selectIntersectingGraffitiRange(),state.deleteTrackingArrays(),state.clearDisplayedTipInfo(),terminalLib.saveOrRestoreTerminalOutputs("restore"),graffiti.changeActivity("idle")},cancelRecording:function(){var currentActivity=state.getActivity();if(console.log("Graffiti: canceling recording, current activity:",currentActivity),"recording"===currentActivity){var recordingCellInfo=state.getRecordingCellInfo();recordingCellInfo.newRecording?graffiti.removeGraffiti(recordingCellInfo.recordingCellId,recordingCellInfo.recordingKey):void 0!==graffiti.previousActiveTakeId&&storage.updateSingleManifestRecordingField(recordingCellInfo.recordingCellId,recordingCellInfo.recordingKey,"activeTakeId",graffiti.previousActiveTakeId),graffiti.stopRecordingCore(!1)}},toggleRecording:function(opts){var currentActivity=state.getActivity();if("playing"!==currentActivity)if("recording"===currentActivity)console.log("Graffiti: Now ending movie recording"),state.blockRecording(),graffiti.setNotifier(localizer.getString("PLEASE_WAIT_STORING_MOVIE")),graffiti.showControlPanels(["graffiti-notifier"]),graffiti.showSavingScrim(),storage.setMovieCompleteCallback(graffiti.hideSavingScrim),graffiti.stopRecordingCore(!0),state.unblockRecording(),graffiti.clearJupyterMenuHint(),void 0!==opts&&opts.endByKeyPress&&state.addCancelTimeSkipRecord(),state.stopSkipping(),console.log("Graffiti: Stopped recording.");else{var recordingCellInfo=state.getRecordingCellInfo();if(void 0===recordingCellInfo)return void console.log("Graffiti: Cannot begin recording, no cell chosen to store recording.");console.log("Graffiti: Begin recording for cell id:",recordingCellInfo.recordingCellId),terminalLib.saveOrRestoreTerminalOutputs("save"),state.resetPlayState(),graffiti.changeActivity("recording"),graffiti.clearSkipKeyDownTimer(),utils.assignCellIds(),state.initHistory({storageCellId:recordingCellInfo.recordingCellId}),state.clearCellAdditions(),audio.startRecording(),state.setScrollTop(graffiti.sitePanel.scrollTop()),state.updateDrawingState([{change:"drawingModeActivated",data:!1},{change:"drawingActivity",data:"idle"},{change:"penType",data:void 0},{change:"opacity",data:state.getMaxDrawingOpacity()}]),graffiti.resetDrawingPen(),state.disableDrawingFadeClock(),state.startAnimationInterval("recording",function(){void 0!==graffiti.runOnceOnNextRecordingTick&&(graffiti.runOnceOnNextRecordingTick(),graffiti.runOnceOnNextRecordingTick=void 0),graffiti.updateTimeDisplay(state.getTimeRecordedSoFar()),graffiti.updateDrawingOpacity()},graffiti.recordingIntervalMs),state.startAnimationInterval("recordingIndicator",function(){state.isSkipping()?$("#graffiti-recording-flash-icon").css({background:"rgb(255,0,0)"}):state.getTimeRecordedSoFar()%2e3>1e3?$("#graffiti-recording-flash-icon").css({background:"rgb(245,245,245)"}):$("#graffiti-recording-flash-icon").css({background:"rgb(255,0,0)"})},graffiti.recordingIntervalMs),console.log("Graffiti: Started recording")}},endRecordingByKeyPress:function(){var activity=state.getActivity();"recording"===activity?graffiti.toggleRecording({endByKeyPress:!0}):"recordingPending"===activity&&(graffiti.changeActivity("idle"),graffiti.clearJupyterMenuHint())},changeActivity:function(newActivity){if(state.getActivity()===newActivity)return void console.log("Graffiti: state is already :",newActivity,"not changing it");state.setActivity(newActivity),graffiti.updateControlPanels()},resetScrollNudge:function(){graffiti.scrollNudge=void 0},applyScrollNudge:function(position,record,useTrailingVelocity){var clientHeight=document.documentElement.clientHeight,topbarHeight=$("#header").height(),bufferY=clientHeight/6,minAllowedCursorY=topbarHeight+bufferY,maxAllowedCursorY=clientHeight-Math.max(bufferY,150),mustNudgeCheck=!useTrailingVelocity,nudgeIncrements=graffiti.scrollNudgeQuickIncrements;if(useTrailingVelocity){nudgeIncrements="scrubbing"===state.getActivity?1:graffiti.scrollNudgeSmoothIncrements;if(graffiti.scrollNudgeAverages.length>0&&(graffiti.scrollNudgeAverages[graffiti.scrollNudgeAverages.length-1].x===position.x&&graffiti.scrollNudgeAverages[graffiti.scrollNudgeAverages.length-1].y===position.y||graffiti.scrollNudgeAverages[graffiti.scrollNudgeAverages.length-1].t===record.startTime))return;if(void 0!==record.inTopBarArea&&record.inTopBarArea)return;if(graffiti.scrollNudgeAverages.push({t:record.startTime,pos:{x:position.x,y:position.y}}),graffiti.scrollNudgeAverages.length>10){graffiti.scrollNudgeAverages.shift();for(var distance,timeDiff,velocities=[],i=1;i<graffiti.scrollNudgeAverages.length;++i)distance=Math.sqrt(Math.pow(graffiti.scrollNudgeAverages[i].pos.y-graffiti.scrollNudgeAverages[i-1].pos.y,2)+Math.pow(graffiti.scrollNudgeAverages[i].pos.x-graffiti.scrollNudgeAverages[i-1].pos.x,2)),timeDiff=graffiti.scrollNudgeAverages[i].t-graffiti.scrollNudgeAverages[i-1].t,velocities.push(distance/timeDiff);var averageVelocity=Math.abs(utils.computeArrayAverage(velocities));mustNudgeCheck=mustNudgeCheck||averageVelocity<.5}}if(mustNudgeCheck){var nudgeAmount,nudging=!1;position.y<minAllowedCursorY?(nudgeAmount=(position.y-minAllowedCursorY)/nudgeIncrements,nudging=!0):position.y>maxAllowedCursorY&&(nudgeAmount=(position.y-maxAllowedCursorY)/nudgeIncrements,nudging=!0),nudging&&(graffiti.scrollNudge={counter:nudgeIncrements,amount:nudgeAmount})}},applyScrollNudgeAtCell:function(cell,record,selChange){var selectionRecord,selections,cellId=utils.getMetadataCellId(cell.metadata),cellRects=utils.getCellRects(cell);if(void 0!==record.cellsSelections&&(selectionRecord=record.cellsSelections[cellId]),void 0!==selectionRecord)selections=selectionRecord.selections;else{selections=cell.code_mirror.listSelections()}if(0!==selections.length){var cellOffsetY=selections[0].head.line*(graffiti.cmLineHeight+graffiti.cmLineFudge),offsetPosition={x:cellRects.innerCellRect.left,y:cellOffsetY+cellRects.innerCellRect.top};graffiti.applyScrollNudge(offsetPosition,record,!1)}},calculateMappedScrollDiff:function(record){var currentNotebookPanelHeight=graffiti.notebookPanel.height(),mappedScrollDiff=0;return void 0!==record&&(mappedScrollDiff=record.scrollDiff/record.notebookPanelHeight*currentNotebookPanelHeight),mappedScrollDiff},doScrollNudging:function(record,viewIndex){var currentScrollTop=graffiti.sitePanel.scrollTop(),newScrollTop=currentScrollTop;if(mappedScrollDiff=graffiti.calculateMappedScrollDiff(record),void 0!==graffiti.scrollNudge){var scrollNudgeAmount=0;graffiti.scrollNudge.counter--,graffiti.scrollNudge.counter>0?(scrollNudgeAmount=graffiti.scrollNudge.amount,newScrollTop=currentScrollTop+scrollNudgeAmount):graffiti.resetScrollNudge()}void 0!==viewIndex&&void 0!==graffiti.lastScrollViewId&&graffiti.lastScrollViewId===viewIndex||(newScrollTop+=mappedScrollDiff,graffiti.lastScrollViewId=viewIndex),graffiti.setSitePanelScrollTop(newScrollTop)},updateDrawingCore:function(record){switch(record.hoverCell=utils.findCellByCellId(record.cellId),record.drawingActivity){case"draw":graffiti.placeCanvas(record.cellId,record.pen.permanence),graffiti.setCanvasStyle(record.cellId,record.pen.type,record.pen.dash,record.pen.color,record.pen.permanence);var positions=graffiti.processPositionsForCellTypeScaling(record,"positions");graffiti.updateDrawingDisplay(record.cellId,positions.start.x,positions.start.y,positions.end.x,positions.end.y,record.pen.type,record.pen.permanence);break;case"sticker":graffiti.drawStickersForCell(record.cellId,record);break;case"fade":$(".graffiti-canvas-type-temporary").css({opacity:record.opacity});break;case"wipe":graffiti.wipeTemporaryStickerDomCanvases(),graffiti.clearCanvases("temporary")}},updateDrawings:function(drawingFrameIndex){if(void 0!==drawingFrameIndex){var index,record,startIndex=void 0===drawingFrameIndex.rangeStart?drawingFrameIndex.index:drawingFrameIndex.rangeStart,endIndex=drawingFrameIndex.index;for(index=startIndex;index<=endIndex;++index)record=state.getHistoryItem("drawings",index),graffiti.updateDrawingCore(record)}},updatePointer:function(record){if(void 0!==record.hoverCell){var hoverCellId=record.cellId;record.isOverTerminal=!1;var offsetPositionScaled=graffiti.processPositionsForCellTypeScaling(record,"cursor"),cellRects=utils.getCellRects(record.hoverCell),offsetPosition={x:cellRects.cellRect.left+offsetPositionScaled.start.x-graffiti.halfBullseye,y:cellRects.cellRect.top+offsetPositionScaled.start.y-graffiti.halfBullseye};if(terminalLib.isTerminalCell(hoverCellId)){var hoverCellElement=record.hoverCell.element[0],terminalContainer=$(hoverCellElement).find(".graffiti-terminal-container"),termWidth=terminalContainer.width(),termHeight=terminalContainer.height(),termOffset=terminalContainer.offset();record.isOverTerminal=termOffset.left<=offsetPosition.x&&offsetPosition.x<=termOffset.left+termWidth&&termOffset.top<=offsetPosition.y&&offsetPosition.y<=termOffset.top+termHeight}graffiti.applyScrollNudge(offsetPosition,record,!0);var lastPosition=state.getLastRecordedCursorPosition();if(offsetPosition.x!==lastPosition.x||offsetPosition.y!==lastPosition.y){graffiti.undimGraffitiCursor();var offsetPositionPx={left:offsetPosition.x+"px",top:offsetPosition.y+"px"};graffiti.graffitiCursorShell.css(offsetPositionPx),graffiti.activateNormalGraffitiCursor()}state.setLastRecordedCursorPosition(offsetPosition)}},updateView:function(viewIndex,currentScrollTop){var record=state.getHistoryItem("view",viewIndex);if(record.hoverCell=utils.findCellByCellId(record.cellId),void 0!==record.hoverCell&&record.hasOwnProperty("lineNumbersVisible")){var cm=record.hoverCell.code_mirror;cm.options.lineNumbers;record.lineNumbersVisible!=cm.options.lineNumbers&&record.hoverCell.toggle_line_numbers()}if(void 0!==record.selectedCellId){var selectedCellIndex=utils.findCellIndexByCellId(record.selectedCellId);Jupyter.notebook.select(selectedCellIndex)}if("pointer"===record.subType)graffiti.updatePointer(record);else if(graffiti.dimGraffitiCursor(),void 0!==record.selectedCell&&("focus"===record.subType||"selectCell"===record.subType)){var selectedCell=utils.findCellByCellId(record.selectedCellId);if(void 0!==selectedCell&&utils.getMetadataCellId(record.selectedCell.metadata)===utils.getMetadataCellId(record.hoverCell.metadata)&&(selectedCell.focus_cell(),"focus"===record.subType)){var code_mirror=selectedCell.code_mirror;code_mirror.state.focused||code_mirror.focus(),code_mirror.getInputField().focus()}}if(graffiti.setSitePanelScrollTop(currentScrollTop),void 0!==record.hoverCell){record.hoverCell.code_mirror.scrollTo(record.innerScroll.left,record.innerScroll.top),graffiti.doScrollNudging(record,viewIndex)}},updateCellSelections:function(cell,cm,selections,currentScrollTop){cm.setSelections(selections),graffiti.setSitePanelScrollTop(currentScrollTop),utils.refreshCodeMirrorSelection(cell),graffiti.setSitePanelScrollTop(currentScrollTop)},updateSelectedCellSelections:function(currentScrollTop){var selectedCell=Jupyter.notebook.get_selected_cell();utils.refreshCodeMirrorSelection(selectedCell),graffiti.setSitePanelScrollTop(currentScrollTop)},updateSelections:function(index,currentScrollTop){var cellId,cell,selectionRecord,selections,code_mirror,currentSelections,lineCheck,record=state.getHistoryItem("selections",index);if(void 0!==record.textSelection){var referenceNode,_cellId2=record.textSelection.cellId,_cell4=utils.findCellByCellId(_cellId2);if(void 0!==_cell4){var cellType=_cell4.cell_type;referenceNode="markdown"===cellType?$(_cell4.element).find(".rendered_html")[0]:$(_cell4.element).find(".output_subarea")[0];var currentSelection=selectionSerializer.get(referenceNode);_.isEqual(currentSelection.state,record.textSelection.state)||("markdown"===cellType&&(_cell4.focus_cell(),graffiti.setSitePanelScrollTop(currentScrollTop)),record.textSelection.referenceNode=referenceNode,selectionSerializer.restore(record.textSelection))}}else for(var _i15=0,_Object$keys10=Object.keys(record.cellsSelections);_i15<_Object$keys10.length;_i15++){if(cellId=_Object$keys10[_i15],selectionRecord=record.cellsSelections[cellId],selections=selectionRecord.selections,selectionRecord.active){var selectedCellIndex=utils.findCellIndexByCellId(cellId);Jupyter.notebook.get_selected_index()!==selectedCellIndex&&(Jupyter.notebook.select(selectedCellIndex),graffiti.setSitePanelScrollTop(currentScrollTop))}if(void 0!==(cell=utils.findCellByCellId(cellId))){code_mirror=cell.code_mirror,currentSelections=utils.cleanSelectionRecords(code_mirror.listSelections());var numLines=code_mirror.lineCount();selections[0].anchor.line=Math.min(numLines-1,selections[0].anchor.line),lineCheck=code_mirror.getLine(selections[0].anchor.line),selections[0].anchor.ch=Math.min(lineCheck.length,selections[0].anchor.ch),selections[0].head.line=Math.min(numLines-1,selections[0].head.line),lineCheck=code_mirror.getLine(selections[0].head.line),selections[0].head.ch=Math.min(lineCheck.length,selections[0].head.ch),_.isEqual(selections,currentSelections)||(graffiti.dimGraffitiCursor(),graffiti.updateCellSelections(cell,code_mirror,selections,currentScrollTop),setTimeout(function(){code_mirror.state.focused&&graffiti.applyScrollNudgeAtCell(cell,record,!0)},0))}}},removeCellsAddedByPlaybackOrRecording:function(){var cellAdditions=state.getCellAdditions();if(void 0!==cellAdditions){var deleteCellIndex,_iteratorNormalCompletion11=!0,_didIteratorError11=!1,_iteratorError11=void 0;try{for(var _step11,_iterator11=cellAdditions[Symbol.iterator]();!(_iteratorNormalCompletion11=(_step11=_iterator11.next()).done);_iteratorNormalCompletion11=!0){var cellId=_step11.value;deleteCellIndex=utils.findCellIndexByCellId(cellId),void 0!==deleteCellIndex&&(Jupyter.notebook.delete_cell(deleteCellIndex),utils.refreshCellMaps())}}catch(err){_didIteratorError11=!0,_iteratorError11=err}finally{try{_iteratorNormalCompletion11||null==_iterator11.return||_iterator11.return()}finally{if(_didIteratorError11)throw _iteratorError11}}}},applyCellListToNotebook:function(record){var deletableCellId,cellsPresentThisFrame=record.cellsPresentThisFrame,fullCellsPresentIds=Object.keys(cellsPresentThisFrame),cellsPresentIds=fullCellsPresentIds.filter(function(cellId){return state.graffitiShouldUpdateCellContents(cellId)}),numCellsPresent=cellsPresentIds.length,mustRefreshCellMaps=!1;if(numCellsPresent>0){var deleteCellIndex,cellAdditions=state.getCellAdditions(),cellAdditionsIds=Object.values(cellAdditions),deletableCellIds=_.difference(cellAdditionsIds,cellsPresentIds),_iteratorNormalCompletion12=!0,_didIteratorError12=!1,_iteratorError12=void 0;try{for(var _step12,_iterator12=deletableCellIds[Symbol.iterator]();!(_iteratorNormalCompletion12=(_step12=_iterator12.next()).done);_iteratorNormalCompletion12=!0)deletableCellId=_step12.value,void 0!==(deleteCellIndex=utils.findCellIndexByCellId(deletableCellId))&&Jupyter.notebook.delete_cell(deleteCellIndex)}catch(err){_didIteratorError12=!0,_iteratorError12=err}finally{try{_iteratorNormalCompletion12||null==_iterator12.return||_iterator12.return()}finally{if(_didIteratorError12)throw _iteratorError12}}var i,checkCellId,newCell,cellPosition,previousCellPosition,previousPlusOne;for(i=0;i<cellsPresentIds.length;++i)if(checkCellId=cellsPresentIds[i],void 0===utils.findCellByCellId(checkCellId)){cellPosition=cellsPresentThisFrame[checkCellId],i>0&&void 0!==(previousCellPosition=utils.findCellIndexByCellId(cellsPresentIds[i-1]))&&(previousPlusOne=previousCellPosition+1)>cellPosition&&(cellPosition=previousPlusOne);var cells=Jupyter.notebook.get_cells();cellPosition==cells.length?newCell=Jupyter.notebook.insert_cell_at_bottom("code"):(cellPosition=Math.min(cellPosition,cells.length-1),newCell=Jupyter.notebook.insert_cell_above("code",cellPosition)),utils.setMetadataCellId(newCell.metadata,checkCellId),state.storePlaybackCellAddition(checkCellId,cellPosition),mustRefreshCellMaps=!0}}mustRefreshCellMaps&&utils.refreshCellMaps()},updateContents:function(index,currentScrollTop){var cellId,frameContents,frameOutputs,contentsRecord=state.getHistoryItem("contents",index),cells=Jupyter.notebook.get_cells(),renderedFrameOutput=!1;graffiti.applyCellListToNotebook(contentsRecord);var _iteratorNormalCompletion13=!0,_didIteratorError13=!1,_iteratorError13=void 0;try{for(var _step13,_iterator13=cells[Symbol.iterator]();!(_iteratorNormalCompletion13=(_step13=_iterator13.next()).done);_iteratorNormalCompletion13=!0){var _cell5=_step13.value;if("code"===_cell5.cell_type&&(cellId=utils.getMetadataCellId(_cell5.metadata),state.graffitiShouldUpdateCellContents(cellId))){var _contents=_cell5.get_text();contentsRecord.cellsContent.hasOwnProperty(cellId)&&(frameContents=state.extractDataFromContentRecord(contentsRecord.cellsContent[cellId].contentsRecord,cellId),void 0!==frameContents&&frameContents!==_contents&&_cell5.set_text(frameContents),frameOutputs=state.extractDataFromContentRecord(contentsRecord.cellsContent[cellId].outputsRecord,cellId),renderedFrameOutput=renderedFrameOutput||state.restoreCellOutputs(_cell5,frameOutputs))}}}catch(err){_didIteratorError13=!0,_iteratorError13=err}finally{try{_iteratorNormalCompletion13||null==_iterator13.return||_iterator13.return()}finally{if(_didIteratorError13)throw _iteratorError13}}renderedFrameOutput&&(graffiti.resizeCanvases(),graffiti.redrawAllDrawings(),setTimeout(function(){graffiti.setSitePanelScrollTop(currentScrollTop)},100))},updateTerminals:function(index){var record=state.getHistoryItem("terminals",index),termRecords=record.terminals,focusedTerminal=void 0;if(void 0!==termRecords)for(var terminalsContents=state.getHistoryTerminalsContents(),currentMovie=state.getCurrentlyPlayingMovie(),nearestCellPosition=currentMovie.cellIndex,i=0;i<termRecords.length;++i)terminalLib.setTerminalContents($.extend(!0,termRecords[i],{incremental:"playing"===state.getActivity(),terminalsContents:terminalsContents,nearestCellPosition:nearestCellPosition,useNearestCellPosition:!0})),termRecords[i].isFocused&&(focusedTerminal=termRecords[i].id);terminalLib.focusTerminal(focusedTerminal)},updateSpeaking:function(index){var record=state.getHistoryItem("speaking",index);state.scanningIsOn()&&(record.speaking?(state.setCurrentPlaySpeed("scanInactive"),state.setSpeakingStatus(!0)):(state.setCurrentPlaySpeed("scanActive"),state.setSpeakingStatus(!1)),audio.updateAudioPlaybackRate())},updateDisplay:function(frameIndexes){var currentScrollTop=graffiti.sitePanel.scrollTop(),activity=state.getActivity();state.shouldUpdateDisplay("contents",frameIndexes.contents)&&graffiti.updateContents(frameIndexes.contents.index,currentScrollTop),state.shouldUpdateDisplay("selections",frameIndexes.selections)&&graffiti.updateSelections(frameIndexes.selections.index,currentScrollTop),state.shouldUpdateDisplay("drawings",frameIndexes.drawings)&&"scrubbing"!==activity&&graffiti.updateDrawings(frameIndexes.drawings),state.shouldUpdateDisplay("terminals",frameIndexes.terminals)&&graffiti.updateTerminals(frameIndexes.terminals.index),state.shouldUpdateDisplay("speaking",frameIndexes.speaking)&&graffiti.updateSpeaking(frameIndexes.speaking.index),state.shouldUpdateDisplay("view",frameIndexes.view)&&graffiti.updateView(frameIndexes.view.index,currentScrollTop)},updateTimeDisplay:function(playedSoFar){var totalTimeDisplay=localizer.getString("IS_SKIPPING"),activity=state.getActivity();if(!state.isSkipping()){var timeSkippedSoFar=state.getSkippedTimeSoFar();isNaN(timeSkippedSoFar)&&(timeSkippedSoFar=graffiti.lastTimeSkippedSoFar),graffiti.lastTimeSkippedSoFar=timeSkippedSoFar;var playTimeDisplay=utils.formatTime(playedSoFar,{includeMillis:!1}),recordingTimeDisplay=utils.formatTime(playedSoFar,{includeMillis:!0}),durationDisplay=(state.getTotalSkipTimeForRecording(),utils.formatTime(state.getHistoryDuration(),{includeMillis:!1}));totalTimeDisplay="recording"===activity?recordingTimeDisplay:playTimeDisplay+"/"+durationDisplay}("recording"===activity?$("#graffiti-time-display-recording"):$("#graffiti-time-display-playback")).text(totalTimeDisplay)},updateSlider:function(playedSoFar){var ratio=playedSoFar/state.getHistoryDuration(),sliderVal=1e3*ratio;$("#graffiti-recorder-range").val(sliderVal)},applyRawCalculatedScrollTop:function(viewIndex){if(state.getApplyingRawCalculatedScrollTop()){var record,i,calculatedScrollTop=graffiti.prePlaybackScrolltop;for(i=0;i<viewIndex;++i)record=state.getHistoryItem("view",i),calculatedScrollTop+=graffiti.calculateMappedScrollDiff(record);graffiti.sitePanel.scrollTop(calculatedScrollTop)}},jumpPlayback:function(direction,jumpAmount){var previousPlayState=state.getActivity();graffiti.pausePlayback();var t,timeElapsed=state.getTimePlayedSoFar();t=state.scanningIsOn()?state.findSpeakingStartNearestTime(timeElapsed,direction,jumpAmount):Math.max(0,Math.min(timeElapsed+1e3*jumpAmount*direction*state.getPlayRateScalar(),state.getHistoryDuration()-2)),state.resetPlayTimes(t);var frameIndexes=state.getHistoryRecordsAtTime(t);state.clearSetupForReset(),state.resetProcessedArrays(),graffiti.wipeAllStickerDomCanvases(),graffiti.updateDisplay(frameIndexes),graffiti.updateSlider(t),graffiti.updateTimeDisplay(t),graffiti.redrawAllDrawings(t),"playing"===previousPlayState&&graffiti.startPlayback(),graffiti.updateAllGraffitiDisplays()},handleSliderDrag:function(){var target=$("#graffiti-recorder-range"),timeLocation=target.val()/1e3,t=Math.min(state.getHistoryDuration()*timeLocation,state.getHistoryDuration()-1);state.resetPlayTimes(t),state.updateCurrentSkipRecord(),state.clearSetupForReset(),state.resetProcessedArrays(),graffiti.undimGraffitiCursor();var frameIndexes=state.getHistoryRecordsAtTime(t);graffiti.wipeAllStickerDomCanvases(),graffiti.updateDisplay(frameIndexes),graffiti.updateTimeDisplay(t),graffiti.redrawAllDrawings(t)},handleTerminalsEvents:function(event){"recording"===state.getActivity()&&(state.storeTerminalsState([event]),state.storeHistoryRecord("terminals"))},applyCurrentSkipRecord:function(t){var currentSkipRecord=state.timeInSkipRecordRange(t),userChoicePlaySpeed=state.getUserChoicePlaySpeed(),didSkip=!1,changedSpeed=!1;state.getActivity();if(void 0!==currentSkipRecord){if(void 0!==currentSkipRecord.status)return didSkip;var skipInfo=state.getSkipInfo();state.setAppliedSkipRecord();var duration,isLastSkipRecord=state.isLastSkipRecord();state.deactivateApplyingRawCalculatedScrollTop(),isLastSkipRecord?(console.log("Graffiti: doing last skip as absolute"),skipInfo.type=state.skipTypes.absolute,duration=state.getHistoryDuration()-state.getTimePlayedSoFar()-1):duration=currentSkipRecord.endTime-currentSkipRecord.startTime+1;var durationMillis=duration/1e3;switch(skipInfo.type){case state.skipTypes.rapid:state.setPlayRate("rapid",skipInfo.factor),state.setCurrentPlaySpeed("rapid"),changedSpeed=!0;break;case state.skipTypes.absolute:state.setCurrentPlaySpeed("regular"),graffiti.jumpPlayback(1,durationMillis),state.updateCurrentSkipRecord(),state.setCurrentPlaySpeed(userChoicePlaySpeed),didSkip=!0;break;case state.skipTypes.compressed:var compressedTimeTarget=Math.min(duration,1e3*skipInfo.factor);state.setCompressedTimePlayRate(duration,compressedTimeTarget),state.setCurrentPlaySpeed("compressed"),didSkip=!0}state.activateApplyingRawCalculatedScrollTop()}else state.clearAppliedSkipRecord(),state.setCurrentPlaySpeed(userChoicePlaySpeed);return(didSkip||changedSpeed)&&(graffiti.updateControlPanels(),audio.updateAudioPlaybackRate()),didSkip},pausePlaybackNoVisualUpdates:function(){"playing"===state.getActivity()&&(graffiti.changeActivity("playbackPaused"),audio.pausePlayback(),state.setPlayTimeEnd(),graffiti.updateSelectedCellSelections(graffiti.sitePanel.scrollTop()),state.updateUsageStats({type:"play",data:{actions:["updateCurrentPlayTime"]}}))},pausePlayback:function(){"playing"===state.getActivity()&&(graffiti.pausePlaybackNoVisualUpdates(),graffiti.refreshAllGraffitiHighlights(),graffiti.refreshGraffitiTooltips(),state.clearAnimationIntervals(),utils.queueSaveNotebookCallback(function(){console.log("Graffiti: Stopped playback.")}),utils.saveNotebookDebounced())},cancelPlaybackNoVisualUpdates:function(){state.getAccessLevel();graffiti.pausePlaybackNoVisualUpdates(),state.updateUsageStats({type:"play",data:{actions:["updateTotalPlayTime"]}}),state.resetPlayState(),graffiti.changeActivity("idle");var currentScrollTop=graffiti.sitePanel.scrollTop();state.getDontRestoreCellContentsAfterPlayback()?console.log("Graffiti: not restoring cell contents."):(graffiti.removeCellsAddedByPlaybackOrRecording(),state.restoreCellStates("contents"),state.restoreCellStates("selections"),state.restoreLineNumbersStates()),state.setDontRestoreCellContentsAfterPlayback(!1),terminalLib.saveOrRestoreTerminalOutputs("restore"),utils.saveNotebookDebounced(),graffiti.setSitePanelScrollTop(currentScrollTop)},cancelPlaybackFinish:function(){graffiti.resetStickerCanvases(),graffiti.cancelRapidPlay(),graffiti.graffitiCursorShell.hide(),graffiti.clearCanvases("all"),graffiti.refreshAllGraffitiHighlights(),graffiti.refreshGraffitiTooltips(),graffiti.updateControlPanels(),graffiti.highlightIntersectingGraffitiRange(),graffiti.clearJupyterMenuHint()},cancelPlayback:function(){console.log("Graffiti: cancelPlayback called");var activity=state.getActivity();"playing"!==activity&&"playbackPaused"!==activity&&"playbackPending"!==activity&&"scrubbing"!==activity||(console.log("Graffiti: Cancelling playback"),graffiti.cancelPlaybackNoVisualUpdates(),state.clearAnimationIntervals(),state.clearNarratorInfo(),graffiti.cancelPlaybackFinish())},startPlayback:function(){var activity=state.getActivity();if("playing"===activity)return void console.log("Graffiti: Cannot start playing because already playing.");if("playbackPending"===activity||"playbackPaused"===activity){if(console.log("Graffiti: Starting playback, current activity:",activity),"idle"===activity||"notifying"===activity||"playbackPending"===activity){state.setScrollTop(graffiti.sitePanel.scrollTop()),state.setCurrentPlaySpeed("regular"),state.storeUserChoicePlaySpeed("regular"),state.setSpeakingStatus(!1),terminalLib.clearTerminalsContentsPositions(),state.resetPlayTimes(),graffiti.resetScrollNudge(),graffiti.updateSlider(0),graffiti.placeControlPanel({nearAction:!0}),graffiti.prePlaybackScrolltop=state.getScrollTop(),graffiti.lastScrollViewId=void 0,graffiti.lastDrawIndex=void 0,graffiti.lastDrawingEraseIndex=void 0,state.storeCellStates(),state.clearCellOutputsSent(),terminalLib.saveOrRestoreTerminalOutputs("save"),graffiti.scrollNudgeAverages=[];var stickerImageCandidateUrl=state.getStickerImageCandidateUrl();void 0!==stickerImageCandidateUrl?state.setStickerImageUrl(stickerImageCandidateUrl):state.setStickerImageUrl(void 0)}else"playbackPaused"===activity&&graffiti.hideTip();"idle"!==activity&&"notifying"!==activity&&"playbackPaused"!==activity&&"playbackPending"!==activity||graffiti.clearCanvases("all"),graffiti.clearHighlightMarkText(),graffiti.undimGraffitiCursor(),graffiti.changeActivity("playing"),graffiti.lastTemporaryCanvasClearViewIndex=-1,state.getResetOnNextPlay()&&(console.log("Graffiti: Resetting for first/re play."),graffiti.clearCanvases("all"),graffiti.wipeAllStickerDomCanvases(),state.resetPlayState(),graffiti.removeCellsAddedByPlaybackOrRecording(),graffiti.applyRawCalculatedScrollTop(0)),"scan"===state.getCurrentPlaySpeed()&&state.setPlayTimeBegin("regular"),state.setPlaybackStartTime(utils.getNow()-state.getTimePlayedSoFar()),state.setPlayStartTimeToNow(),state.updateCurrentSkipRecord(),state.getMute()||audio.startPlayback(state.getTimePlayedSoFar()),state.startAnimationInterval("playback",function(){var playedSoFar=state.getTimePlayedSoFar();if(playedSoFar>=state.getHistoryDuration())state.setupForReset(),graffiti.togglePlayback();else if(!graffiti.applyCurrentSkipRecord(playedSoFar)){graffiti.updateSlider(playedSoFar),graffiti.updateTimeDisplay(playedSoFar);var frameIndexes=state.getHistoryRecordsAtTime(playedSoFar);graffiti.updateDisplay(frameIndexes)}},graffiti.playbackIntervalMs)}},togglePlayback:function(){var activity=state.getActivity();"recording"!==activity&&("playing"===activity?(state.clearAnimationIntervals(),state.getHidePlayerAfterPlayback()&&state.getSetupForReset()?graffiti.cancelPlayback():graffiti.pausePlayback()):(graffiti.startPlayback(),playStartedAt=utils.getNow()))},playAutoplayGraffiti:function(){for(var recordingCellId,recordingKeys,recording,autoplayGraffiti,manifest=state.getManifest(),autoplayedOnce=!1,_i16=0,_Object$keys11=Object.keys(manifest);_i16<_Object$keys11.length;_i16++)if(recordingCellId=_Object$keys11[_i16],recordingKeys=Object.keys(manifest[recordingCellId]),recordingKeys.length>0){var _iteratorNormalCompletion14=!0,_didIteratorError14=!1,_iteratorError14=void 0;try{for(var _step14,_iterator14=recordingKeys[Symbol.iterator]();!(_iteratorNormalCompletion14=(_step14=_iterator14.next()).done);_iteratorNormalCompletion14=!0)recordingKey=_step14.value,recording=manifest[recordingCellId][recordingKey],void 0!==recording.autoplay&&void 0===autoplayGraffiti&&("always"===recording.autoplay?autoplayGraffiti={recordingCellId:recordingCellId,recordingKey:recordingKey}:"once"===recording.autoplay&&(recording.playedOnce||(autoplayGraffiti={recordingCellId:recordingCellId,
recordingKey:recordingKey},recording.playedOnce=!0,autoplayedOnce=!0)))}catch(err){_didIteratorError14=!0,_iteratorError14=err}finally{try{_iteratorNormalCompletion14||null==_iterator14.return||_iterator14.return()}finally{if(_didIteratorError14)throw _iteratorError14}}}void 0!==autoplayGraffiti&&(graffiti.playRecordingById(autoplayGraffiti.recordingCellId,autoplayGraffiti.recordingKey),autoplayedOnce&&storage.storeManifest())},playMovieViaUserClick:function(){console.log("Graffiti: playMovieViaUserClick starts.");var activity=state.getActivity(),playableMovie=state.getPlayableMovie("tip");if(console.log("Graffiti: playableMovie",playableMovie),void 0===playableMovie)return console.log("Graffiti: no playable movie known."),void("recording"!==activity&&graffiti.changeActivity("idle"));if("recording"===activity){var recordingCellInfo=state.getRecordingCellInfo();return void 0!==recordingCellInfo&&recordingCellInfo.recordingCellId==playableMovie.recordingCellId&&recordingCellInfo.recordingKey==playableMovie.recordingKey?void console.log("Graffiti: not running this graffiti during recording because it is the same one you are recording for:",recordingCellInfo):void graffiti.loadAndPlayMovie("tip")}if("playbackPending"===activity)return void console.log("Graffiti: not playing movie via user click because another movie is pending.");if(void 0===state.getManifestSingleRecording(playableMovie.recordingCellId,playableMovie.recordingKey).terminalCommand&&(graffiti.cancelPlayback(),graffiti.changeActivity("playbackPending")),state.getDontRestoreCellContentsAfterPlayback()){var dialogContent=localizer.getString("REPLACE_CONFIRM_BODY_1"),modalButtons={};modalButtons[localizer.getString("REPLACE_CONFIRM_BODY_2")]={click:function(e){console.log("Graffiti: you want to preserve cell contents after playback."),state.setPlayableMovie("tip",playableMovie.recordingCellId,playableMovie.recordingKey),state.setDontRestoreCellContentsAfterPlayback(!1),graffiti.loadAndPlayMovie("tip")}},modalButtons[localizer.getString("REPLACE_CONFIRM_BODY_3")]={click:function(e){state.setPlayableMovie("tip",playableMovie.recordingCellId,playableMovie.recordingKey),state.setDontRestoreCellContentsAfterPlayback(!0),graffiti.loadAndPlayMovie("tip")}},dialog.modal({title:localizer.getString("PLAY_CONFIRM"),body:dialogContent,sanitize:!1,buttons:modalButtons}).on("hidden.bs.modal",function(e){console.log("Graffiti: escaped the dontRestoreCellContents modal.")})}else graffiti.loadAndPlayMovie("tip")},executeSaveToFileDirectives:function(cellId){if(void 0!==cellId){var cellIdToGraffitiMap=state.getCellIdToGraffitiMap(cellId);if(void 0!==cellIdToGraffitiMap){var saveToFilePath,i,_cell6=utils.findCellByCellId(cellId),fileContents=_cell6.get_text();for(i=0;i<cellIdToGraffitiMap.length;++i)saveToFilePath=cellIdToGraffitiMap[i],storage.writeTextToFile({path:saveToFilePath,contents:fileContents,stripCRs:!1})}storage.cleanUpExecutorCell()}},executeAllSaveToFileDirectives:function(){var cells=Jupyter.notebook.get_cells(),_iteratorNormalCompletion15=!0,_didIteratorError15=!1,_iteratorError15=void 0;try{for(var _step15,_iterator15=cells[Symbol.iterator]();!(_iteratorNormalCompletion15=(_step15=_iterator15.next()).done);_iteratorNormalCompletion15=!0){var _cell7=_step15.value;if("code"===_cell7.cell_type){var cellId=utils.getMetadataCellId(_cell7.metadata);graffiti.executeSaveToFileDirectives(cellId)}}}catch(err){_didIteratorError15=!0,_iteratorError15=err}finally{try{_iteratorNormalCompletion15||null==_iterator15.return||_iterator15.return()}finally{if(_didIteratorError15)throw _iteratorError15}}},executeInsertDataFromFile:function(recordingCellId,recordingKey,recording){var insertDataFromFile=recording.insertDataFromFile,filePath=insertDataFromFile.filePath,existingCellId=recordingKey;if(void 0===utils.findCellByCellId(existingCellId))return storage.fetchDataFile(filePath).then(function(contents){var viewInfo=state.getViewInfo(),cellType=insertDataFromFile.cellType,newCell=Jupyter.notebook.insert_cell_below(void 0===cellType?"markdown":cellType,viewInfo.cellIndex);utils.setMetadataCellId(newCell.metadata,existingCellId),utils.refreshCellMaps();var newCellIndex=viewInfo.cellIndex+1;return Jupyter.notebook.select(newCellIndex),newCell.set_text(contents),newCell.render(),Promise.resolve(!0)}).catch(function(ex){return console.log("Graffiti: executeInsertDataFromFile is unable to fetch data from path:",filePath),dialog.modal({title:localizer.getString("FILE_UNAVAILABLE")+" : "+filePath,body:localizer.getString("FILE_UNAVAILABLE_EXPLANATION"),sanitize:!1,buttons:{OK:{click:function(e){console.log("Graffiti: Missing file acknowledged.")}}}}),Promise.reject()});var existingCellIndex=utils.findCellIndexByCellId(existingCellId);return void 0!==existingCellIndex?(Jupyter.notebook.delete_cell(existingCellIndex),Promise.resolve(!1)):void 0},executeLabelSwaps:function(recording,recordingCellId,recordingKey,insertedData){if(!0===recording.swappingLabels&&void 0!==recording.labelSwaps&&2===recording.labelSwaps.length){var viewInfo=state.getViewInfo(),hoverCellId=viewInfo.cellId,hoverCellIndex=viewInfo.cellIndex,hoverCell=utils.findCellByCellId(hoverCellId);if("markdown"!==hoverCell.cell_type)return Promise.reject();Jupyter.notebook.select(hoverCellIndex);var hoverCellText=hoverCell.get_text(),tagClass="graffiti-"+recordingCellId+"-"+recordingKey,startTag='<span class="graffiti-highlight '+tagClass+'">',startPos=hoverCellText.indexOf(startTag);if(startPos>=0){endPos=hoverCellText.indexOf("</span>",startPos);var startPastTag=startPos+startTag.length,currentLabel=hoverCellText.substr(startPastTag,endPos-startPastTag),buttonMatch=currentLabel.match(/(<i><\/i><button>)(.*?)(<\/button>)/);null!==buttonMatch&&(currentLabel=buttonMatch[2]),currentLabel=recording.labelSwaps[0],insertedData&&(currentLabel=recording.labelSwaps[1]);var newContents=hoverCellText.substr(0,startPastTag)+(null!==buttonMatch?buttonMatch[1]:"")+currentLabel+(null!==buttonMatch?buttonMatch[3]:"")+hoverCellText.substr(endPos);hoverCell.set_text(newContents),hoverCell.render(),graffiti.refreshAllGraffitiHighlights();var hoverCellElement=hoverCell.element[0],swappedButtonDOM=$(hoverCellElement).find("."+tagClass);graffiti.refreshGraffitiTooltipsCore(swappedButtonDOM,"mouseenter"),insertedData&&state.updateUsageStats({type:"insertDataFromFile",data:{cellId:recordingCellId,recordingKey:recordingKey}})}}return Promise.resolve(insertedData)},cleanupAfterLoadAndPlayDidNotPlay:function(){"playbackPending"===state.getActivity()&&(graffiti.clearJupyterMenuHint(),graffiti.changeActivity("idle"),state.setDontRestoreCellContentsAfterPlayback(!1),graffiti.refreshAllGraffitiHighlights(),graffiti.refreshGraffitiTooltips(),graffiti.updateControlPanels())},startLoadedMovie:function(recording,playableMovie){console.log("Graffiti: Movie loaded for cellId, recordingKey:",playableMovie.recordingCellId,playableMovie.recordingKey),state.setCurrentlyPlayingMovie(playableMovie),state.setNarratorInfo("name",recording.narratorName),state.setNarratorInfo("picture",recording.narratorPicture),state.setSkipInfo(recording.skipInfo),state.clearScaleCursorWithWindow(),state.setNarratorInfoIsRendered(!1),recording.scaleCursorWithWindow&&state.setScaleCursorWithWindow(),state.setTotalSkipTimeForRecording(),void 0!==playableMovie.cell&&"markdown"===playableMovie.cellType&&playableMovie.cell.render(),state.updateUsageStats({type:"setup",data:{cellId:playableMovie.recordingCellId,recordingKey:playableMovie.recordingKey,activeTakeId:playableMovie.activeTakeId}}),state.updateUsageStats({type:"play",data:{actions:["resetCurrentPlayTime","incrementPlayCount"]}}),graffiti.togglePlayback(),graffiti.hideTip()},loadAndPlayMovie:function(kind){var playableMovie=state.getPlayableMovie(kind);if(void 0===playableMovie)return void console.log("Graffiti: no playable movie defined.");console.log("Graffiti: playableMovie:",playableMovie);var activity=state.getActivity(),recording=state.getManifestSingleRecording(playableMovie.recordingCellId,playableMovie.recordingKey),fireUpMovie=function(){if("recording"!==activity){!0===recording.replayAllCells?state.setShouldUpdateCellContentsDuringPlayback(!0):state.setShouldUpdateCellContentsDuringPlayback(!1),$("#graffiti-movie-play-btn").html("<i>"+localizer.getString("LOADING")+"</i>").prop("disabled",!0);var historyData=state.getFromMovieCache("history",playableMovie),audioData=state.getFromMovieCache("audio",playableMovie);void 0!==historyData&&void 0!==audioData?(state.setHistory(historyData),audio.setRecordedAudio(audioData),graffiti.startLoadedMovie(recording,playableMovie)):storage.fetchMovie(playableMovie).then(function(movieData){state.setHistory(movieData.history),audio.setRecordedAudio(movieData.audio),graffiti.startLoadedMovie(recording,playableMovie)}).catch(function(ex){graffiti.cleanupAfterLoadAndPlayDidNotPlay(),!0!==recording.silenceWarnings&&dialog.modal({title:localizer.getString("MOVIE_UNAVAILABLE"),body:localizer.getString("MOVIE_UNAVAILABLE_EXPLANATION"),sanitize:!1,buttons:{OK:{click:function(e){console.log("Graffiti: Missing movie acknowledged.")}}}}),console.log("Graffiti: could not load movie:",ex)})}};if(void 0!==recording.terminalCommand){var terminalCommand=recording.terminalCommand;return terminalLib.runTerminalCommand(terminalCommand.terminalId,terminalCommand.command,!0),"recording"!==activity&&graffiti.cleanupAfterLoadAndPlayDidNotPlay(),void state.updateUsageStats({type:"terminalCommand",data:{cellId:playableMovie.recordingCellId,recordingKey:playableMovie.recordingKey,command:terminalCommand.command}})}void 0!==recording.insertDataFromFile?graffiti.executeInsertDataFromFile(playableMovie.recordingCellId,playableMovie.recordingKey,recording).then(function(results){return graffiti.executeLabelSwaps(recording,playableMovie.recordingCellId,playableMovie.recordingKey,results)}).then(function(results){results?fireUpMovie():graffiti.cleanupAfterLoadAndPlayDidNotPlay()}).catch(function(){console.log("Graffiti: could not run executeInsertDataFromFile."),graffiti.cleanupAfterLoadAndPlayDidNotPlay()}):fireUpMovie()},playRecordingById:function(recordingCellId,recordingKey){void 0!==state.setPlayableMovie("api",recordingCellId,recordingKey)?graffiti.loadAndPlayMovie("api"):console.log("Graffiti: not playing movie "+recordingCellId+":"+recordingKey+", as it was not available.")},playRecordingByIdString:function(recordingFullId){var parts=utils.parseRecordingFullId(recordingFullId);graffiti.playRecordingById(parts.recordingCellId,parts.recordingKey)},playRecordingByIdWithPrompt:function(recordingFullId,promptMarkdown){graffiti.changeActivity("notifying");var promptHtml="<span>"+utils.renderMarkdown(promptMarkdown)+"</span>";graffiti.setNotifier('<div id="graffiti-notifier-prompt">'+promptHtml+"</div>",[{ids:["graffiti-notifier-prompt"],event:"click",fn:function(e){graffiti.playRecordingByIdString(recordingFullId)}}])},activateAudio:function(){state.getAudioInitialized()||audio.init({succeed:function(){state.setAudioInitialized()},fail:function(){dialog.modal({title:localizer.getString("ACCESS_MICROPHONE_PROMPT"),body:localizer.getString("ACCESS_MICROPHONE_ADVISORY"),sanitize:!1,buttons:{OK:{}}})}})},changeAccessLevel:function(level){"create"===level?(graffiti.cancelPlayback(),graffiti.activateAudio(),storage.ensureNotebookGetsGraffitiId(),storage.ensureNotebookGetsFirstAuthorId(),utils.assignCellIds(),utils.queueSaveNotebookCallback(function(){graffiti.refreshAllGraffitiHighlights(),graffiti.refreshGraffitiTooltipsDebounced()}),utils.saveNotebookDebounced()):graffiti.outerControlPanel.fadeOut(graffiti.panelFadeTime),state.setAccessLevel(level),graffiti.updateControlPanels()},toggleAccessLevel:function(forcedLevel){var buttonLabel,level=void 0===forcedLevel?state.getAccessLevel():forcedLevel;void 0!==forcedLevel?"create"===level?(buttonLabel=localizer.getString("HIDE_GRAFFITI_EDITOR"),graffiti.changeAccessLevel("create")):(buttonLabel=localizer.getString("SHOW_GRAFFITI_EDITOR"),graffiti.changeAccessLevel("view")):"create"===level?(buttonLabel=localizer.getString("SHOW_GRAFFITI_EDITOR"),graffiti.changeAccessLevel("view")):(buttonLabel=localizer.getString("HIDE_GRAFFITI_EDITOR"),graffiti.changeAccessLevel("create")),$("#graffiti-setup-button span:last").text(buttonLabel)},showCreatorsChooser:function(){graffiti.setNotifier(localizer.getString("YOU_CAN_FILTER")),graffiti.showControlPanels(["graffiti-notifier","graffiti-creators-chooser"])},transferGraffiti:function(){storage.transferGraffiti().then(function(){dialog.modal({title:"Transfer Complete",body:"Your Notebook's Graffitis have been copied over from the original notebook. Now you can modify them (or add and remove Graffitis to this notebook),  without affecting the original notebook's Graffitis.",sanitize:!1,buttons:{OK:{click:function(e){console.log("Graffiti: You clicked ok")}}}})})},packageGraffiti:function(){storage.packageGraffiti().then(function(fileName){dialog.modal({title:"Packaging Complete",body:"Your Notebook's Graffitis, and your notebook, have been copied into a archive file.<br><br>Now you can copy and unpack that archive file anywhere Graffiti is supported, using the terminal command: <code>tar zxf "+fileName+"</code>",sanitize:!1,buttons:{OK:{click:function(e){console.log("Graffiti: You clicked ok")}}}})})},initSetupButton:function(){var buttonLabel,notebook=Jupyter.notebook,sprayCanIcon=stickerLib.makeSprayCanIcon(),setupForSetup=!1,buttonContents='<div id="graffiti-setup-button" style=display:none; class="btn-group"><button class="btn btn-default" title="'+localizer.getString("ENABLE_GRAFFITI")+'">';if(notebook.metadata.hasOwnProperty("graffiti"))buttonLabel=localizer.getString("SHOW_GRAFFITI_EDITOR");else{var existingSetupButton=$("#graffiti-setup-button");existingSetupButton.length>0&&existingSetupButton.remove(),buttonLabel=localizer.getString("ACTIVATE_GRAFFITI"),setupForSetup=!0}var setupButtonDiv=$(buttonContents+"<span>"+buttonLabel+"</div></button></span>"),jupyterMainToolbar=$("#maintoolbar-container");setupButtonDiv.appendTo(jupyterMainToolbar),$("#graffiti-setup-button button").prepend(sprayCanIcon),setupForSetup?$("#graffiti-setup-button").click(function(){graffiti.firstTimeSetup()}):$("#graffiti-setup-button").click(function(){graffiti.toggleAccessLevel()});var showSetupButton=!1,workspace=state.getWorkspace(),displayControlPanelButton=utils.getNotebookGraffitiConfigEntry("displayControlPanelButton");void 0!==displayControlPanelButton?"true"===displayControlPanelButton&&(showSetupButton=!0):workspace&&workspace.coco&&(showSetupButton=!0),showSetupButton&&$("#graffiti-setup-button").show()},firstTimeSetup:function(){dialog.modal({title:localizer.getString("ACTIVATE_GRAFFITI_CONFIRM"),body:localizer.getString("ACTIVATE_GRAFFITI_ADVISORY"),sanitize:!1,buttons:{OK:{click:function(e){console.log("Graffiti: You clicked ok"),storage.ensureNotebookGetsGraffitiId(),storage.ensureNotebookGetsFirstAuthorId(),utils.queueSaveNotebookCallback(function(){utils.createApiSymlink(),graffiti.initInteractivity(),graffiti.toggleAccessLevel("view"),graffiti.activateAudio(),$("#graffiti-setup-button").unbind("click").click(function(){graffiti.toggleAccessLevel()})}),utils.saveNotebookDebounced()}},Cancel:{click:function(e){console.log("Graffiti: Not adding Graffiti.")}}}})}};return{init:graffiti.init,graffiti:graffiti,state:state,playRecordingById:function(recordingFullId){graffiti.playRecordingByIdString(recordingFullId)},playRecordingByIdWithPrompt:function(recordingFullId,promptMarkdown){graffiti.playRecordingByIdWithPrompt(recordingFullId,promptMarkdown)},cancelPlayback:function(){graffiti.cancelPlayback()},removeUnusedTakes:function(recordingFullId){graffiti.removeUnusedTakesWithConfirmation(recordingFullId)},removeAllUnusedTakes:function(){graffiti.removeAllUnusedTakesWithConfirmation()},removeAllGraffiti:graffiti.removeAllGraffitisWithConfirmation,disableGraffiti:graffiti.disableGraffitiWithConfirmation,setAccessLevel:function(level){graffiti.toggleAccessLevel(level)},transferGraffiti:function(){graffiti.transferGraffiti()},packageGraffiti:function(){graffiti.packageGraffiti()},getUsageStats:function(){return state.getUsageStats()},selectionSerializer:selectionSerializer,controlTerminal:function(opts){graffiti.controlTerminal(opts)}}}()}),define("js/loader.js",[],function(){if(void 0!==window.Graffiti)return void console.log("Graffiti already instantiated, not reinitializing");require(["js/initExtension.js"])}),define("js/initExtension.js",["base/js/namespace","js/graffiti.js","js/utils.js","js/state.js","js/workspace.js"],function(Jupyter,Graffiti,utils,state,workspace){console.log("Graffiti loaded:",Graffiti);var initGraffiti=function(){state.init(),workspace.setWorkspace().then(function(){return Graffiti.init()})},waitForKernelToBeReady=function(){window.Graffiti=Graffiti,Jupyter.notebook.kernel?initGraffiti():Jupyter.notebook.events.on("kernel_ready.Kernel",function(e){console.log("Graffiti: kernel ready, possible kernel restart.",e),console.log("Graffiti: Reloading loader.js"),state.getActivity()||initGraffiti(),require(["js/loader.js"]),utils.saveNotebookDebounced()})};Jupyter.notebook._fully_loaded?(console.log("Graffiti: Notebook is already fully loaded."),waitForKernelToBeReady()):Jupyter.notebook.events.on("notebook_loaded.Notebook",function(e){console.log("Graffiti: Notebook is loaded."),waitForKernelToBeReady()})}),window.Graffiti=null,define("nbextensions/jupytergraffiti/graffiti",[],function(){return{load_ipython_extension:function(){require(["js/initExtension.js"])}}});