# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

modules = \
['evtx2es']
install_requires = \
['elasticsearch>=7.7.1,<8.0.0',
 'evtx>=0.6.6,<0.7.0',
 'orjson>=3.4.6,<4.0.0',
 'tqdm>=4.46.1,<5.0.0',
 'urllib3>=1.25.9,<2.0.0']

entry_points = \
{'console_scripts': ['evtx2es = evtx2es:console_evtx2es',
                     'evtx2json = evtx2es:console_evtx2json']}

setup_kwargs = {
    'name': 'evtx2es',
    'version': '1.4.0',
    'description': 'Fast import of Windows EventLogs(.evtx) into Elasticsearch.',
    'long_description': '# Evtx2es\n\n[![MIT License](http://img.shields.io/badge/license-MIT-blue.svg?style=flat)](LICENSE)\n[![PyPI version](https://badge.fury.io/py/evtx2es.svg)](https://badge.fury.io/py/evtx2es)\n[![Python Versions](https://img.shields.io/pypi/pyversions/evtx2es.svg)](https://pypi.org/project/evtx2es/)\n\nFast import of Windows EventLogs(.evtx) into Elasticsearch.\n\nLife is too short and there is not enough time to process **huge Windows EventLogs** with **pure-Python software**.  \nevtx2es uses Rust library [pyevtx-rs](https://github.com/omerbenamram/pyevtx-rs), so it runs much faster than traditional software.\n\n\n## Usage\n\nWhen using from the commandline interface:\n\n```bash\n$ evtx2es /path/to/your/file.evtx\n```\n\nWhen using from the python-script:\n\n```python\nfrom evtx2es import evtx2es\n\nif __name__ == \'__main__\':\n  filepath = \'/path/to/your/file.evtx\'\n  evtx2es(filepath)\n```\n\n### Arguments\n\nevtx2es supports importing from multiple files.\n\n```bash\n$ evtx2es file1.evtx file2.evtx file3.evtx\n```\n\nAlso, possible to import recursively from a specific directory.\n\n```bash\n$ tree .\nevtxfiles/\n  ├── file1.evtx\n  ├── file2.evtx\n  ├── file3.evtx\n  └── subdirectory/\n    ├── file4.evtx\n    └── subsubdirectory/\n      ├── file5.evtx\n      └── file6.evtx\n\n$ evtx2es /evtxfiles/ # The Path is recursively expanded to file1~6.evtx.\n```\n\n### Options\n\n```\n--host:\n  ElasticSearch host address\n  (default: localhost)\n\n--port:\n  ElasticSearch port number\n  (default: 9200)\n\n--index:\n  Index name of Import destination\n  (default: evtx2es)\n\n--size:\n  Number of grouped documents during bulk insertion (Normally, It doesn\'t need to change this option.)\n  (default: 500)\n\n--scheme:\n  Scheme to use (http, or https)\n  (default: http)\n\n--pipeline\n  Elasticsearch Ingest Pipeline to use\n  (default: )\n\n--datasetdate\n  Date of latest record in dataset from TimeCreated record - MM/DD/YYYY.HH:MM:SS\n  (default: 0)\n\n--login:\n  The login to use if Elastic Security is enable\n  (default: )\n\n--pwd:\n  The password linked to the login provided\n  (default: )\n```\n\n### Examples\n\nWhen using from the commandline interface:\n\n```\n$ evtx2es /path/to/your/file.evtx --host=localhost --port=9200 --index=foobar --size=500\n```\n\nWhen using from the python-script:\n\n```py\nif __name__ == \'__main__\':\n    evtx2es(\'/path/to/your/file.evtx\', host=localhost, port=9200, index=\'foobar\', size=500)\n```\n\nWith the Amazon Elasticsearch Serivce (ES):\n\n```\n$ evtx2es /path/to/your/file.evtx --host=example.us-east-1.es.amazonaws.com --port=443 --scheme=https --index=foobar\n```\n\nWith credentials for Elastic Security:\n\n```\n$ evtx2es /path/to/your/file.evtx --host=localhost --port=9200 --index=foobar --login=elastic --pwd=******\n```\n\nNote: The current version does not verify the certificate.\n\n\n## Appendix\n\n### Evtx2json\n\nExtra feature. :sushi: :sushi: :sushi:\n\nConvert from Windows Eventlog to json file.\n\n```bash\n$ evtx2json /path/to/your/file.evtx /path/to/output/target.json\n```\n\nConvert from Windows Eventlog to Python List[dict] object.\n\n```python\nfrom evtx2es import evtx2json\n\nif __name__ == \'__main__\':\n  filepath = \'/path/to/your/file.evtx\'\n  result: List[dict] = evtx2json(filepath)\n```\n\n## Output Format Example\n\nUsing the sample evtx file of [JPCERT/CC:LogonTracer](https://github.com/JPCERTCC/LogonTracer) as an example.\n\n```\n[\n  {\n    "event_record_id": 227559,\n    "timestamp": "2016-10-06 01:50:49.420927 UTC",\n    "winlog": {\n      "channel": "Security",\n      "computer_name": "WIN-WFBHIBE5GXZ.example.co.jp",\n      "event_id": 4624,\n      "opcode": 0,\n      "provider_guid": "{54849625-5478-4994-a5ba-3e3b0328c30d}",\n      "provider_name": "Microsoft-Windows-Security-Auditing",\n      "record_id": 227559,\n      "task": 12544,\n      "version": 0,\n      "process": {\n        "pid": 572,\n        "thread_id": 1244\n      },\n      "event_data": {\n        "AuthenticationPackageName": "Kerberos",\n        "IpAddress": "192.168.16.102",\n        "IpPort": "49220",\n        "KeyLength": 0,\n        "LmPackageName": "-",\n        "LogonGuid": "F4DC1C19-0544-BC52-0900-DFC19752C3C6",\n        "LogonProcessName": "Kerberos",\n        "LogonType": 3,\n        "ProcessId": 0,\n        "ProcessName": "-",\n        "SubjectDomainName": "-",\n        "SubjectLogonId": "0x0",\n        "SubjectUserName": "-",\n        "SubjectUserSid": "S-1-0-0",\n        "TargetDomainName": "EXAMPLE",\n        "TargetLogonId": "0x1fa0869",\n        "TargetUserName": "WIN7_64JP_02$",\n        "TargetUserSid": "S-1-5-21-1524084746-3249201829-3114449661-1107",\n        "TransmittedServices": "-",\n        "WorkstationName": "",\n        "Status": null\n      }\n    },\n    "log": {\n      "file": {\n        "name": "sample/Security.evtx"\n      }\n    },\n    "event": {\n      "code": 4624,\n      "created": "2016-10-06T01:50:49.420927Z"\n    },\n    "@timestamp": "2016-10-06T01:50:49.420927Z"\n  },\n  ...\n]\n```\n\n## Performance Evaluations\n\nevtx2es was evaluated using the sample evtx file of [JPCERT/CC:LogonTracer](https://github.com/JPCERTCC/LogonTracer) (about 30MB binary data).\n\n```.bash\n$ time evtx2es ./Security.evtx\n> 6.25 user 0.13 system 0:14.08 elapsed 45%CPU\n```\n\nSee [Qiita](https://qiita.com/sumeshi/items/cb2fbafe59c2c83e3085) for more information.\n\n### Running Environment\n\n```\nOS: Ubuntu 18.04\nCPU: Intel Core i5-6500\nRAM: DDR4 32GB\n```\n\nElasticSearch 7.4 was running on the Docker version(Official Image).  \nhttps://hub.docker.com/_/elasticsearch\n\n## Installation\n\n### via pip\n\n```\n$ pip install evtx2es\n```\n\nThe source code for evtx2es is hosted at GitHub, and you may download, fork, and review it from this repository(https://github.com/sumeshi/evtx2es).\n\nPlease report issues and feature requests. :sushi: :sushi: :sushi:\n\n## License\n\nevtx2es is released under the [MIT](https://github.com/sumeshi/evtx2es/blob/master/LICENSE) License.\n\nPowered by [pyevtx-rs](https://github.com/omerbenamram/pyevtx-rs).  \nInspired by [EvtxtoElk](https://github.com/dgunter/evtxtoelk).\n',
    'author': 'sumeshi',
    'author_email': 'j15322sn@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/sumeshi/evtx2es',
    'package_dir': package_dir,
    'py_modules': modules,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
