"""
Works with url formatting.
"""
from orwynn.utils import validation
from orwynn.utils.url._match_routes import match_routes

from ._get_vars import get_vars
from ._Url import Url
from ._UrlVars import UrlVars


def join_routes(*routes: str) -> str:
    """Joins all given routes and normalize final result."""
    validation.validate_each(routes, str, expected_sequence_type=tuple)

    result: str = ""

    for route in routes:
        if route == "" or route == "/":
            continue
        elif route[0] != "/":
            result += "/" + route
        else:
            result += route
        result.removesuffix("/")

    if result == "":
        result = "/"

    return result


