# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['orwynn',
 'orwynn._di',
 'orwynn._di.collecting',
 'orwynn._di.init',
 'orwynn._testingtools',
 'orwynn.apiversion',
 'orwynn.app',
 'orwynn.apprc',
 'orwynn.base',
 'orwynn.base.config',
 'orwynn.base.controller',
 'orwynn.base.database',
 'orwynn.base.error',
 'orwynn.base.errorhandler',
 'orwynn.base.middleware',
 'orwynn.base.model',
 'orwynn.base.module',
 'orwynn.base.service',
 'orwynn.base.worker',
 'orwynn.boot',
 'orwynn.bootscript',
 'orwynn.context',
 'orwynn.helpers',
 'orwynn.http',
 'orwynn.http._context',
 'orwynn.http._controller',
 'orwynn.http._controller.endpoint',
 'orwynn.http._cors',
 'orwynn.http._errorhandler',
 'orwynn.http._log',
 'orwynn.http._middleware',
 'orwynn.http._schema',
 'orwynn.indication',
 'orwynn.log',
 'orwynn.mapping',
 'orwynn.mongo',
 'orwynn.proxy',
 'orwynn.router',
 'orwynn.singleton',
 'orwynn.sql',
 'orwynn.testing',
 'orwynn.utils',
 'orwynn.utils.crypto',
 'orwynn.utils.dt',
 'orwynn.utils.fmt',
 'orwynn.utils.klass',
 'orwynn.utils.mp',
 'orwynn.utils.rnd',
 'orwynn.utils.url',
 'orwynn.utils.validation',
 'orwynn.utils.yml',
 'orwynn.websocket',
 'orwynn.websocket._context',
 'orwynn.websocket._controller',
 'orwynn.websocket._errorhandler',
 'orwynn.websocket._log',
 'orwynn.websocket._middleware',
 'orwynn.websocket._routing']

package_data = \
{'': ['*']}

install_requires = \
['bcrypt>=4.0.1,<5.0.0',
 'colorama>=0.4.6,<0.5.0',
 'dictdiffer>=0.9.0,<0.10.0',
 'fastapi>=0.88.0,<0.89.0',
 'httpx>=0.23.1,<0.24.0',
 'loguru>=0.6.0,<0.7.0',
 'psycopg2>=2.9.5,<3.0.0',
 'pyjwt>=2.6.0,<3.0.0',
 'pymongo>=4.3.3,<5.0.0',
 'python-benedict>=0.28.1,<0.29.0',
 'python-dotenv>=0.21.0,<0.22.0',
 'pyyaml>=6.0,<7.0',
 'sqlalchemy>=2.0.3,<3.0.0',
 'uvicorn[standard]>=0.20.0,<0.21.0',
 'websockets>=10.4,<11.0']

setup_kwargs = {
    'name': 'orwynn',
    'version': '1.0.0b2',
    'description': 'Scalable web-framework with out-of-the-box architecture',
    'long_description': '# Orwynn',
    'author': 'ryzhovalex',
    'author_email': 'thed4rkof@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.11,<4.0',
}


setup(**setup_kwargs)
