# mypy-boto3-networkmanager

[![PyPI - mypy-boto3-networkmanager](https://img.shields.io/pypi/v/mypy-boto3-networkmanager.svg?color=blue)](https://pypi.org/project/mypy-boto3-networkmanager)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-networkmanager.svg?color=blue)](https://pypi.org/project/mypy-boto3-networkmanager)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

- [mypy-boto3-networkmanager](#mypy-boto3-networkmanager)
  - [How to use](#how-to-use)
  - [Automated type discovery](#automated-type-discovery)

Type annotations for
[boto3.NetworkManager 1.14.0](https://boto3.amazonaws.com/v1/documentation/api/1.14.0/reference/services/networkmanager.html#NetworkManager) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.0.4](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to use

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `NetworkManager` service.

```bash
python -m pip install boto3-stubs[networkmanager]
```

Use `boto3` with `mypy_boto3_networkmanager` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3_networkmanager import NetworkManagerClient

# Now mypy can check if your code is valid.
client: NetworkManagerClient = boto3.client("networkmanager")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: NetworkManagerClient = session.client("networkmanager")



# Annotated paginators are included as well

import mypy_boto3_networkmanager.paginator as networkmanager_paginators

describe_global_networks_paginator: networkmanager_paginators.DescribeGlobalNetworksPaginator = client.get_paginator("describe_global_networks")
get_customer_gateway_associations_paginator: networkmanager_paginators.GetCustomerGatewayAssociationsPaginator = client.get_paginator("get_customer_gateway_associations")
get_devices_paginator: networkmanager_paginators.GetDevicesPaginator = client.get_paginator("get_devices")
get_link_associations_paginator: networkmanager_paginators.GetLinkAssociationsPaginator = client.get_paginator("get_link_associations")
get_links_paginator: networkmanager_paginators.GetLinksPaginator = client.get_paginator("get_links")
get_sites_paginator: networkmanager_paginators.GetSitesPaginator = client.get_paginator("get_sites")
get_transit_gateway_registrations_paginator: networkmanager_paginators.GetTransitGatewayRegistrationsPaginator = client.get_paginator("get_transit_gateway_registrations")
```

## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_networkmanager` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python
import boto3

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("networkmanager")

session_client = boto3.Session().client("networkmanager")
```