import sys
from typing import Any, Optional, Union, overload

if sys.version_info >= (3, 8):
    from typing import Literal
else:
    from typing_extensions import Literal

from dateutil.tz import tzfile
from datetime import tzinfo, date

from pandas._libs.tslibs.period import Period
from pandas._typing import TimestampConvertible

OptInt = Optional[int]

Fold = Literal[0, 1]

class Timestamp:
    @overload
    def __init__(self, ts_input: TimestampConvertible, freq: Optional[str] = ..., tz: Optional[Union[str, tzinfo, tzfile]] = ..., unit: Optional[str] = ..., tzinfo: Optional[tzinfo] = ..., fold: Optional[Fold] = ...): ...
    @overload
    def __init__(self, year: OptInt = ..., month: OptInt = ..., day: OptInt = ..., hour: OptInt = ..., minute: OptInt = ..., second: OptInt = ..., microsecond: OptInt = ..., nanosecond: OptInt = ..., tz: Optional[Union[str, tzinfo, tzfile]] = ..., tzinfo: Optional[tzinfo] = ..., fold: Optional[Fold] = ..., freq: Optional[str] = ...): ...
    def to_period(self, freq: Optional[str]) -> Period: ...
    def to_julian_date(self) -> float: ...
    def tz_localize(self, tz: Any = ..., ambigious: Any = ..., nonexistent: Any = ...) -> Timestamp: ...
    def tz_convert(self, tz: Any) -> Timestamp: ...
    def astimezone(self, tz: Any) -> Timestamp: ...
    def replace(self, year: OptInt = ..., month: OptInt = ..., day: OptInt = ..., hour: OptInt = ..., minute: OptInt = ..., second: OptInt = ..., microsecond: OptInt = ..., nanosecond: OptInt = ..., tzinfo: Optional[tzinfo] = ..., fold: Fold = ...) -> Timestamp: ...
    def round(self, freq: str, ambiguous: Any = ..., nonexistent: Any = ...) -> Timestamp: ...
    def ceil(self, freq: str, ambiguous: Any = ...,nonexistent: Any = ...) -> Timestamp: ...
    def floor(self, freq: str, ambiguous: Any = ...,nonexistent: Any = ...) -> Timestamp: ...
    def isoformat(self, sep: str = ...) -> str: ...
    def day_name(self, locale: Optional[str]) -> str: ...
    def month_name(self, locale: Optional[str]) -> str: ...
    def normalize(self) -> Timestamp: ...
    def strftime(self, format: str) -> str: ...
    def date(self) -> date: ...

    @classmethod
    def utcnow(cls) -> Timestamp: ...
    @classmethod
    def utcfromtimestamp(cls, ts: Timestamp) -> Timestamp: ...
    @classmethod
    def fromtimestamp(cls, ts: Timestamp) -> Timestamp: ...
    @classmethod
    def combine(cls, date: Any, time: Any) -> Timestamp: ...
    @classmethod
    def now(cls, tz: Optional[Any] = ...) -> Timestamp: ...
    @classmethod
    def today(cls, tz: Optional[Any] = ...) -> Timestamp: ...
    @classmethod
    def fromisoformat(cls, isoformat: str) -> Timestamp: ...
    @classmethod
    def fromordinal(cls, ordinal: Any, freq: Optional[Any] = ..., tz: Optional[Any] = ...) -> Timestamp: ...
    @property
    def dayofweek(self) -> int: ...
    @property
    def dayofyear(self) -> int: ...
    @property
    def quarter(self) -> int: ...
    @property
    def days_in_month(self) -> int: ...
    @property
    def daysinmonth(self) -> int: ...
    @property
    def week(self) -> int: ...
    @property
    def weekofyear(self) -> int: ...
    @property
    def freqstr(self) -> str: ...
    @property
    def is_month_end(self) -> bool: ...
    @property
    def is_month_start(self) -> bool: ...
    @property
    def is_quarter_start(self) -> bool: ...
    @property
    def is_quarter_end(self) -> bool: ...
    @property
    def is_year_start(self) -> bool: ...
    @property
    def is_year_end(self) -> bool: ...
    @property
    def is_leap_year(self) -> bool: ...
    @property
    def tz(self) -> tzinfo: ...


def integer_op_not_supported(obj: Any) -> Any: ...
