import abc
from pandas._config import config as config

from pandas.core.frame import DataFrame as DataFrame
from pandas.errors import EmptyDataError as EmptyDataError
from pandas.io.excel._util import get_writer as get_writer
from pandas.io.formats.printing import pprint_thing as pprint_thing
from pandas.io.parsers import TextParser as TextParser
from pandas.util._decorators import Appender as Appender
from typing import Any, Optional, Sequence, Union


def read_excel(io: Any, sheet_name: Optional[Union[str, int, Sequence[Union[str, int]]]] = ..., header: Optional[Union[int, Sequence[int]]] = ..., names: Optional[Any] = ..., index_col: Optional[Any] = ..., usecols: Optional[Any] = ..., squeeze: bool = ..., dtype: Optional[Any] = ..., engine: Optional[Any] = ..., converters: Optional[Any] = ..., true_values: Optional[Any] = ..., false_values: Optional[Any] = ..., skiprows: Optional[Any] = ..., nrows: Optional[Any] = ..., na_values: Optional[Any] = ..., keep_default_na: bool = ..., verbose: bool = ..., parse_dates: bool = ..., date_parser: Optional[Any] = ..., thousands: Optional[Any] = ..., comment: Optional[Any] = ..., skipfooter: int = ..., convert_float: bool = ..., mangle_dupe_cols: bool = ..., **kwds: Any) -> Any: ...

class _BaseExcelReader(metaclass=abc.ABCMeta):
    book: Any = ...
    def __init__(self, filepath_or_buffer: Any) -> None: ...
    @abc.abstractmethod
    def load_workbook(self, filepath_or_buffer: Any) -> Any: ...
    def close(self) -> None: ...
    @property
    @abc.abstractmethod
    def sheet_names(self) -> Any: ...
    @abc.abstractmethod
    def get_sheet_by_name(self, name: Any) -> Any: ...
    @abc.abstractmethod
    def get_sheet_by_index(self, index: Any) -> Any: ...
    @abc.abstractmethod
    def get_sheet_data(self, sheet: Any, convert_float: Any) -> Any: ...
    def parse(self, sheet_name: int = ..., header: int = ..., names: Optional[Any] = ..., index_col: Optional[Any] = ..., usecols: Optional[Any] = ..., squeeze: bool = ..., dtype: Optional[Any] = ..., true_values: Optional[Any] = ..., false_values: Optional[Any] = ..., skiprows: Optional[Any] = ..., nrows: Optional[Any] = ..., na_values: Optional[Any] = ..., verbose: bool = ..., parse_dates: bool = ..., date_parser: Optional[Any] = ..., thousands: Optional[Any] = ..., comment: Optional[Any] = ..., skipfooter: int = ..., convert_float: bool = ..., mangle_dupe_cols: bool = ..., **kwds: Any) -> Any: ...

class ExcelWriter(metaclass=abc.ABCMeta):
    def __new__(cls, path: Any, engine: Optional[Any] = ..., **kwargs: Any) -> Any: ...
    book: Any = ...
    curr_sheet: Any = ...
    path: Any = ...
    @property
    @abc.abstractmethod
    def supported_extensions(self) -> Any: ...
    @property
    @abc.abstractmethod
    def engine(self) -> Any: ...
    @abc.abstractmethod
    def write_cells(self, cells: Any, sheet_name: Optional[Any] = ..., startrow: int = ..., startcol: int = ..., freeze_panes: Optional[Any] = ...) -> Any: ...
    @abc.abstractmethod
    def save(self) -> Any: ...
    sheets: Any = ...
    cur_sheet: Any = ...
    date_format: str = ...
    datetime_format: str = ...
    mode: Any = ...
    def __init__(self, path: Any, engine: Optional[Any] = ..., date_format: Optional[Any] = ..., datetime_format: Optional[Any] = ..., mode: str = ..., **engine_kwargs: Any) -> None: ...
    def __fspath__(self) -> Any: ...
    @classmethod
    def check_extension(cls, ext: Any) -> Any: ...
    def __enter__(self) -> Any: ...
    def __exit__(self, exc_type: Any, exc_value: Any, traceback: Any) -> None: ...
    def close(self) -> Any: ...

class ExcelFile:
    engine: Any = ...
    io: Any = ...
    def __init__(self, io: Any, engine: Optional[Any] = ...) -> None: ...
    def __fspath__(self) -> Any: ...
    def parse(self, sheet_name: int = ..., header: int = ..., names: Optional[Any] = ..., index_col: Optional[Any] = ..., usecols: Optional[Any] = ..., squeeze: bool = ..., converters: Optional[Any] = ..., true_values: Optional[Any] = ..., false_values: Optional[Any] = ..., skiprows: Optional[Any] = ..., nrows: Optional[Any] = ..., na_values: Optional[Any] = ..., parse_dates: bool = ..., date_parser: Optional[Any] = ..., thousands: Optional[Any] = ..., comment: Optional[Any] = ..., skipfooter: int = ..., convert_float: bool = ..., mangle_dupe_cols: bool = ..., **kwds: Any) -> Any: ...
    @property
    def book(self) -> Any: ...
    @property
    def sheet_names(self) -> Any: ...
    def close(self) -> None: ...
    def __enter__(self) -> Any: ...
    def __exit__(self, exc_type: Any, exc_value: Any, traceback: Any) -> None: ...
    def __del__(self) -> None: ...
