# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Connection']


class Connection(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 enabled_clients: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 is_domain_connection: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[pulumi.InputType['ConnectionOptionsArgs']]] = None,
                 realms: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 strategy: Optional[pulumi.Input[str]] = None,
                 strategy_version: Optional[pulumi.Input[str]] = None,
                 validation: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        With Auth0, you can define sources of users, otherwise known as connections, which may include identity providers (such as Google or LinkedIn), databases, or passwordless authentication methods. This resource allows you to configure and manage connections to be used with your clients and users.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_auth0 as auth0

        my_connection = auth0.Connection("myConnection",
            options=auth0.ConnectionOptionsArgs(
                brute_force_protection=True,
                configuration={
                    "bar": "baz",
                    "foo": "bar",
                },
                custom_scripts={
                    "getUser": \"\"\"function getByEmail (email, callback) {
          return callback(new Error("Whoops!"))
        }

        \"\"\",
                },
                enabled_database_customization=True,
                password_histories=[auth0.ConnectionOptionsPasswordHistoryArgs(
                    enable=True,
                    size=3,
                )],
                password_policy="excellent",
            ),
            strategy="auth0")
        ```

        > The Auth0 dashboard displays only one connection per social provider. Although the Auth0 Management API allowes the creation of multiple connections per strategy, the additional connections may not be visible in the Auth0 dashboard.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] display_name: Name used in login screen
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_clients: IDs of the clients for which the connection is enabled. If not specified, no clients are enabled.
        :param pulumi.Input[bool] is_domain_connection: Indicates whether or not the connection is domain level.
        :param pulumi.Input[str] name: Name of the connection.
        :param pulumi.Input[pulumi.InputType['ConnectionOptionsArgs']] options: Configuration settings for connection options. For details, see Options.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] realms: Defines the realms for which the connection will be used (i.e., email domains). If not specified, the connection name is added as the realm.
        :param pulumi.Input[str] strategy: Type of the connection, which indicates the identity provider. Options include `ad`, `adfs`, `amazon`, `aol`, `apple`, `auth0`, `auth0-adldap`, `auth0-oidc`, `baidu`, `bitbucket`, `bitly`, `box`, `custom`, `daccount`, `dropbox`, `dwolla`, `email`, `evernote`, `evernote-sandbox`, `exact`, `facebook`, `fitbit`, `flickr`, `github`, `google-apps`, `google-oauth2`, `guardian`, `instagram`, `ip`, `line`, `linkedin`, `miicard`, `oauth1`, `oauth2`, `office365`, `oidc`, `paypal`, `paypal-sandbox`, `pingfederate`, `planningcenter`, `renren`, `salesforce`, `salesforce-community`, `salesforce-sandbox` `samlp`, `sharepoint`, `shopify`, `sms`, `soundcloud`, `thecity`, `thecity-sandbox`, `thirtysevensignals`, `twitter`, `untappd`, `vkontakte`, `waad`, `weibo`, `windowslive`, `wordpress`, `yahoo`, `yammer`, `yandex`.
        :param pulumi.Input[str] strategy_version: Version 1 is deprecated, use version 2.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] validation: Validation of the minimum and maximum values allowed for a user to have as username. For details, see Validation.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['display_name'] = display_name
            __props__['enabled_clients'] = enabled_clients
            __props__['is_domain_connection'] = is_domain_connection
            __props__['name'] = name
            __props__['options'] = options
            __props__['realms'] = realms
            if strategy is None and not opts.urn:
                raise TypeError("Missing required property 'strategy'")
            __props__['strategy'] = strategy
            __props__['strategy_version'] = strategy_version
            __props__['validation'] = validation
        super(Connection, __self__).__init__(
            'auth0:index/connection:Connection',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            enabled_clients: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            is_domain_connection: Optional[pulumi.Input[bool]] = None,
            name: Optional[pulumi.Input[str]] = None,
            options: Optional[pulumi.Input[pulumi.InputType['ConnectionOptionsArgs']]] = None,
            realms: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            strategy: Optional[pulumi.Input[str]] = None,
            strategy_version: Optional[pulumi.Input[str]] = None,
            validation: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None) -> 'Connection':
        """
        Get an existing Connection resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] display_name: Name used in login screen
        :param pulumi.Input[Sequence[pulumi.Input[str]]] enabled_clients: IDs of the clients for which the connection is enabled. If not specified, no clients are enabled.
        :param pulumi.Input[bool] is_domain_connection: Indicates whether or not the connection is domain level.
        :param pulumi.Input[str] name: Name of the connection.
        :param pulumi.Input[pulumi.InputType['ConnectionOptionsArgs']] options: Configuration settings for connection options. For details, see Options.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] realms: Defines the realms for which the connection will be used (i.e., email domains). If not specified, the connection name is added as the realm.
        :param pulumi.Input[str] strategy: Type of the connection, which indicates the identity provider. Options include `ad`, `adfs`, `amazon`, `aol`, `apple`, `auth0`, `auth0-adldap`, `auth0-oidc`, `baidu`, `bitbucket`, `bitly`, `box`, `custom`, `daccount`, `dropbox`, `dwolla`, `email`, `evernote`, `evernote-sandbox`, `exact`, `facebook`, `fitbit`, `flickr`, `github`, `google-apps`, `google-oauth2`, `guardian`, `instagram`, `ip`, `line`, `linkedin`, `miicard`, `oauth1`, `oauth2`, `office365`, `oidc`, `paypal`, `paypal-sandbox`, `pingfederate`, `planningcenter`, `renren`, `salesforce`, `salesforce-community`, `salesforce-sandbox` `samlp`, `sharepoint`, `shopify`, `sms`, `soundcloud`, `thecity`, `thecity-sandbox`, `thirtysevensignals`, `twitter`, `untappd`, `vkontakte`, `waad`, `weibo`, `windowslive`, `wordpress`, `yahoo`, `yammer`, `yandex`.
        :param pulumi.Input[str] strategy_version: Version 1 is deprecated, use version 2.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] validation: Validation of the minimum and maximum values allowed for a user to have as username. For details, see Validation.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["display_name"] = display_name
        __props__["enabled_clients"] = enabled_clients
        __props__["is_domain_connection"] = is_domain_connection
        __props__["name"] = name
        __props__["options"] = options
        __props__["realms"] = realms
        __props__["strategy"] = strategy
        __props__["strategy_version"] = strategy_version
        __props__["validation"] = validation
        return Connection(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[Optional[str]]:
        """
        Name used in login screen
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="enabledClients")
    def enabled_clients(self) -> pulumi.Output[Sequence[str]]:
        """
        IDs of the clients for which the connection is enabled. If not specified, no clients are enabled.
        """
        return pulumi.get(self, "enabled_clients")

    @property
    @pulumi.getter(name="isDomainConnection")
    def is_domain_connection(self) -> pulumi.Output[bool]:
        """
        Indicates whether or not the connection is domain level.
        """
        return pulumi.get(self, "is_domain_connection")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the connection.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional['outputs.ConnectionOptions']]:
        """
        Configuration settings for connection options. For details, see Options.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def realms(self) -> pulumi.Output[Sequence[str]]:
        """
        Defines the realms for which the connection will be used (i.e., email domains). If not specified, the connection name is added as the realm.
        """
        return pulumi.get(self, "realms")

    @property
    @pulumi.getter
    def strategy(self) -> pulumi.Output[str]:
        """
        Type of the connection, which indicates the identity provider. Options include `ad`, `adfs`, `amazon`, `aol`, `apple`, `auth0`, `auth0-adldap`, `auth0-oidc`, `baidu`, `bitbucket`, `bitly`, `box`, `custom`, `daccount`, `dropbox`, `dwolla`, `email`, `evernote`, `evernote-sandbox`, `exact`, `facebook`, `fitbit`, `flickr`, `github`, `google-apps`, `google-oauth2`, `guardian`, `instagram`, `ip`, `line`, `linkedin`, `miicard`, `oauth1`, `oauth2`, `office365`, `oidc`, `paypal`, `paypal-sandbox`, `pingfederate`, `planningcenter`, `renren`, `salesforce`, `salesforce-community`, `salesforce-sandbox` `samlp`, `sharepoint`, `shopify`, `sms`, `soundcloud`, `thecity`, `thecity-sandbox`, `thirtysevensignals`, `twitter`, `untappd`, `vkontakte`, `waad`, `weibo`, `windowslive`, `wordpress`, `yahoo`, `yammer`, `yandex`.
        """
        return pulumi.get(self, "strategy")

    @property
    @pulumi.getter(name="strategyVersion")
    def strategy_version(self) -> pulumi.Output[str]:
        """
        Version 1 is deprecated, use version 2.
        """
        return pulumi.get(self, "strategy_version")

    @property
    @pulumi.getter
    def validation(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Validation of the minimum and maximum values allowed for a user to have as username. For details, see Validation.
        """
        return pulumi.get(self, "validation")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

