"use strict";
// --------------------------------------------------------------------------------
// This file declares context keys that are used by the CLI to control the
// behavior of CDK apps. Contrary to feature flags (which are defined under
// `features.ts`) these options are not bound to be removed in the next major
// version.
// --------------------------------------------------------------------------------
Object.defineProperty(exports, "__esModule", { value: true });
exports.BUNDLING_STACKS = exports.DISABLE_METADATA_STACK_TRACE = exports.DISABLE_ASSET_STAGING_CONTEXT = exports.ANALYTICS_REPORTING_ENABLED_CONTEXT = exports.PATH_METADATA_ENABLE_CONTEXT = void 0;
/**
 * Enables the embedding of the "aws:cdk:path" in CloudFormation template metadata.
 */
exports.PATH_METADATA_ENABLE_CONTEXT = 'aws:cdk:enable-path-metadata';
/**
 * Enable the collection and reporting of version information.
 */
exports.ANALYTICS_REPORTING_ENABLED_CONTEXT = 'aws:cdk:version-reporting';
/**
 * Disable asset staging (for use with SAM CLI).
 *
 * Disabling asset staging means that copyable assets will not be copied to the
 * output directory and will be referenced with absolute paths.
 *
 * Not copied to the output directory: this is so users can iterate on the
 * Lambda source and run SAM CLI without having to re-run CDK (note: we
 * cannot achieve this for bundled assets, if assets are bundled they
 * will have to re-run CDK CLI to re-bundle updated versions).
 *
 * Absolute path: SAM CLI expects `cwd`-relative paths in a resource's
 * `aws:asset:path` metadata. In order to be predictable, we will always output
 * absolute paths.
 */
exports.DISABLE_ASSET_STAGING_CONTEXT = 'aws:cdk:disable-asset-staging';
/**
 * If this context key is set, the CDK will stage assets under the specified
 * directory. Otherwise, assets will not be staged.
 * Omits stack traces from construct metadata entries.
 */
exports.DISABLE_METADATA_STACK_TRACE = 'aws:cdk:disable-stack-trace';
/**
 * Run bundling for stacks specified in this context key
 */
exports.BUNDLING_STACKS = 'aws:cdk:bundling-stacks';
//# sourceMappingURL=data:application/json;base64,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