"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FIREHOSE_CIDR_BLOCKS = exports.CLOUDWATCH_LAMBDA_INSIGHTS_ARNS = exports.APPMESH_ECR_ACCOUNTS = exports.DLC_REPOSITORY_ACCOUNTS = exports.ELBV2_ACCOUNTS = exports.PARTITION_MAP = exports.ROUTE_53_BUCKET_WEBSITE_ZONE_IDS = exports.AWS_CDK_METADATA = exports.AWS_OLDER_REGIONS = void 0;
exports.AWS_OLDER_REGIONS = new Set([
    'us-east-1',
    'us-west-1',
    'us-west-2',
    'us-gov-west-1',
    'ap-southeast-1',
    'ap-southeast-2',
    'ap-northeast-1',
    'sa-east-1',
    'eu-west-1',
]);
exports.AWS_CDK_METADATA = new Set([
    'us-east-2',
    'us-east-1',
    'us-west-1',
    'us-west-2',
    // 'us-gov-east-1',
    // 'us-gov-west-1',
    // 'us-iso-east-1',
    // 'us-isob-east-1',
    'af-south-1',
    'ap-south-1',
    'ap-east-1',
    // 'ap-northeast-3',
    'ap-northeast-2',
    'ap-southeast-1',
    'ap-southeast-2',
    'ap-northeast-1',
    'ca-central-1',
    'cn-north-1',
    'cn-northwest-1',
    'eu-central-1',
    'eu-west-1',
    'eu-west-2',
    'eu-west-3',
    'eu-north-1',
    'eu-south-1',
    'me-south-1',
    'sa-east-1',
]);
/**
 * The hosted zone Id if using an alias record in Route53.
 *
 * @see https://docs.aws.amazon.com/general/latest/gr/rande.html#s3_website_region_endpoints
 */
exports.ROUTE_53_BUCKET_WEBSITE_ZONE_IDS = {
    'af-south-1': 'Z11KHD8FBVPUYU',
    'ap-east-1': 'ZNB98KWMFR0R6',
    'ap-northeast-1': 'Z2M4EHUR26P7ZW',
    'ap-northeast-2': 'Z3W03O7B5YMIYP',
    'ap-northeast-3': 'Z2YQB5RD63NC85',
    'ap-south-1': 'Z11RGJOFQNVJUP',
    'ap-southeast-1': 'Z3O0J2DXBE1FTB',
    'ap-southeast-2': 'Z1WCIGYICN2BYD',
    'ca-central-1': 'Z1QDHH18159H29',
    'eu-central-1': 'Z21DNDUVLTQW6Q',
    'eu-north-1': 'Z3BAZG2TWCNX0D',
    'eu-south-1': 'Z3IXVV8C73GIO3',
    'eu-west-1': 'Z1BKCTXD74EZPE',
    'eu-west-2': 'Z3GKZC51ZF0DB4',
    'eu-west-3': 'Z3R1K369G5AVDG',
    'me-south-1': 'Z1MPMWCPA7YB62',
    'sa-east-1': 'Z7KQH4QJS55SO',
    'us-east-1': 'Z3AQBSTGFYJSTF',
    'us-east-2': 'Z2O1EMRO9K5GLX',
    'us-gov-east-1': 'Z2NIFVYYW2VKV1',
    'us-gov-west-1': 'Z31GFT0UA1I2HV',
    'us-west-1': 'Z2F56UZL2M1ACD',
    'us-west-2': 'Z3BJ6K6RIION7M',
};
exports.PARTITION_MAP = {
    'default': { partition: 'aws', domainSuffix: 'amazonaws.com' },
    'cn-': { partition: 'aws-cn', domainSuffix: 'amazonaws.com.cn' },
    'us-gov-': { partition: 'aws-us-gov', domainSuffix: 'amazonaws.com' },
    'us-iso-': { partition: 'aws-iso', domainSuffix: 'c2s.ic.gov' },
    'us-isob-': { partition: 'aws-iso-b', domainSuffix: 'sc2s.sgov.gov' },
};
// https://docs.aws.amazon.com/elasticloadbalancing/latest/application/load-balancer-access-logs.html#access-logging-bucket-permissions
exports.ELBV2_ACCOUNTS = {
    'af-south-1': '098369216593',
    'ap-east-1': '754344448648',
    'ap-northeast-1': '582318560864',
    'ap-northeast-2': '600734575887',
    'ap-northeast-3': '383597477331',
    'ap-south-1': '718504428378',
    'ap-southeast-1': '114774131450',
    'ap-southeast-2': '783225319266',
    'ca-central-1': '985666609251',
    'cn-north-1': '638102146993',
    'cn-northwest-1': '037604701340',
    'eu-central-1': '054676820928',
    'eu-north-1': '897822967062',
    'eu-south-1': '635631232127',
    'eu-west-1': '156460612806',
    'eu-west-2': '652711504416',
    'eu-west-3': '009996457667',
    'me-south-1': '076674570225',
    'sa-east-1': '507241528517',
    'us-east-1': '127311923021',
    'us-east-2': '033677994240',
    'us-gov-east-1': '190560391635',
    'us-gov-west-1': '048591011584',
    'us-west-1': '027434742980',
    'us-west-2': '797873946194',
};
// https://aws.amazon.com/releasenotes/available-deep-learning-containers-images
exports.DLC_REPOSITORY_ACCOUNTS = {
    'ap-east-1': '871362719292',
    'ap-northeast-1': '763104351884',
    'ap-northeast-2': '763104351884',
    'ap-south-1': '763104351884',
    'ap-southeast-1': '763104351884',
    'ap-southeast-2': '763104351884',
    'ca-central-1': '763104351884',
    'cn-north-1': '727897471807',
    'cn-northwest-1': '727897471807',
    'eu-central-1': '763104351884',
    'eu-north-1': '763104351884',
    'eu-west-1': '763104351884',
    'eu-west-2': '763104351884',
    'eu-west-3': '763104351884',
    'me-south-1': '217643126080',
    'sa-east-1': '763104351884',
    'us-east-1': '763104351884',
    'us-east-2': '763104351884',
    'us-west-1': '763104351884',
    'us-west-2': '763104351884',
};
// https://docs.aws.amazon.com/app-mesh/latest/userguide/envoy.html
exports.APPMESH_ECR_ACCOUNTS = {
    'af-south-1': '924023996002',
    'ap-east-1': '856666278305',
    'ap-northeast-1': '840364872350',
    'ap-northeast-2': '840364872350',
    'ap-northeast-3': '840364872350',
    'ap-south-1': '840364872350',
    'ap-southeast-1': '840364872350',
    'ap-southeast-2': '840364872350',
    'ca-central-1': '840364872350',
    'eu-central-1': '840364872350',
    'eu-north-1': '840364872350',
    'eu-south-1': '422531588944',
    'eu-west-1': '840364872350',
    'eu-west-2': '840364872350',
    'eu-west-3': '840364872350',
    'me-south-1': '772975370895',
    'sa-east-1': '840364872350',
    'us-east-1': '840364872350',
    'us-east-2': '840364872350',
    'us-west-1': '840364872350',
    'us-west-2': '840364872350',
};
// https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Lambda-Insights-extension-versions.html
exports.CLOUDWATCH_LAMBDA_INSIGHTS_ARNS = {
    '1.0.98.0': {
        'us-east-1': 'arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:14',
        'us-east-2': 'arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:14',
        'us-west-1': 'arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:14',
        'us-west-2': 'arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:14',
        'af-south-1': 'arn:aws:lambda:af-south-1:012438385374:layer:LambdaInsightsExtension:8',
        'ap-east-1': 'arn:aws:lambda:ap-east-1:519774774795:layer:LambdaInsightsExtension:8',
        'ap-south-1': 'arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:14',
        'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:14',
        'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:14',
        'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:14',
        'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:14',
        'ca-central-1': 'arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:14',
        'cn-north-1': 'arn:aws-cn:lambda:cn-north-1:488211338238:layer:LambdaInsightsExtension:8',
        'cn-northwest-1': 'arn:aws-cn:lambda:cn-northwest-1:488211338238:layer:LambdaInsightsExtension:8',
        'eu-central-1': 'arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:14',
        'eu-west-1': 'arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:14',
        'eu-west-2': 'arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:14',
        'eu-south-1': 'arn:aws:lambda:eu-south-1:339249233099:layer:LambdaInsightsExtension:8',
        'eu-west-3': 'arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:14',
        'eu-north-1': 'arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:14',
        'me-south-1': 'arn:aws:lambda:me-south-1:285320876703:layer:LambdaInsightsExtension:8',
        'sa-east-1': 'arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:14',
    },
    '1.0.89.0': {
        'us-east-1': 'arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:12',
        'us-east-2': 'arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:12',
        'us-west-1': 'arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:12',
        'us-west-2': 'arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:12',
        'ap-south-1': 'arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:12',
        'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:12',
        'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:12',
        'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:12',
        'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:12',
        'ca-central-1': 'arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:12',
        'eu-central-1': 'arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:12',
        'eu-west-1': 'arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:12',
        'eu-west-2': 'arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:12',
        'eu-west-3': 'arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:12',
        'eu-north-1': 'arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:12',
        'sa-east-1': 'arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:12',
    },
    '1.0.86.0': {
        'us-east-1': 'arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:11',
        'us-east-2': 'arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:11',
        'us-west-1': 'arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:11',
        'us-west-2': 'arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:11',
        'ap-south-1': 'arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:11',
        'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:11',
        'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:11',
        'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:11',
        'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:11',
        'ca-central-1': 'arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:11',
        'eu-central-1': 'arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:11',
        'eu-west-1': 'arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:11',
        'eu-west-2': 'arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:11',
        'eu-west-3': 'arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:11',
        'eu-north-1': 'arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:11',
        'sa-east-1': 'arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:11',
    },
    '1.0.54.0': {
        'us-east-1': 'arn:aws:lambda:us-east-1:580247275435:layer:LambdaInsightsExtension:2',
        'us-east-2': 'arn:aws:lambda:us-east-2:580247275435:layer:LambdaInsightsExtension:2',
        'us-west-1': 'arn:aws:lambda:us-west-1:580247275435:layer:LambdaInsightsExtension:2',
        'us-west-2': 'arn:aws:lambda:us-west-2:580247275435:layer:LambdaInsightsExtension:2',
        'ap-south-1': 'arn:aws:lambda:ap-south-1:580247275435:layer:LambdaInsightsExtension:2',
        'ap-northeast-2': 'arn:aws:lambda:ap-northeast-2:580247275435:layer:LambdaInsightsExtension:2',
        'ap-southeast-1': 'arn:aws:lambda:ap-southeast-1:580247275435:layer:LambdaInsightsExtension:2',
        'ap-southeast-2': 'arn:aws:lambda:ap-southeast-2:580247275435:layer:LambdaInsightsExtension:2',
        'ap-northeast-1': 'arn:aws:lambda:ap-northeast-1:580247275435:layer:LambdaInsightsExtension:2',
        'ca-central-1': 'arn:aws:lambda:ca-central-1:580247275435:layer:LambdaInsightsExtension:2',
        'eu-central-1': 'arn:aws:lambda:eu-central-1:580247275435:layer:LambdaInsightsExtension:2',
        'eu-west-1': 'arn:aws:lambda:eu-west-1:580247275435:layer:LambdaInsightsExtension:2',
        'eu-west-2': 'arn:aws:lambda:eu-west-2:580247275435:layer:LambdaInsightsExtension:2',
        'eu-west-3': 'arn:aws:lambda:eu-west-3:580247275435:layer:LambdaInsightsExtension:2',
        'eu-north-1': 'arn:aws:lambda:eu-north-1:580247275435:layer:LambdaInsightsExtension:2',
        'sa-east-1': 'arn:aws:lambda:sa-east-1:580247275435:layer:LambdaInsightsExtension:2',
    },
};
// https://docs.aws.amazon.com/firehose/latest/dev/controlling-access.html#using-iam-rs-vpc
exports.FIREHOSE_CIDR_BLOCKS = {
    'af-south-1': '13.244.121.224',
    'ap-east-1': '18.162.221.32',
    'ap-northeast-1': '13.113.196.224',
    'ap-northeast-2': '13.209.1.64',
    'ap-northeast-3': '13.208.177.192',
    'ap-south-1': '13.232.67.32',
    'ap-southeast-1': '13.228.64.192',
    'ap-southeast-2': '13.210.67.224',
    'ca-central-1': '35.183.92.128',
    'cn-north-1': '52.81.151.32',
    'cn-northwest-1': '161.189.23.64',
    'eu-central-1': '35.158.127.160',
    'eu-north-1': '13.53.63.224',
    'eu-south-1': '15.161.135.128',
    'eu-west-1': '52.19.239.192',
    'eu-west-2': '18.130.1.96',
    'eu-west-3': '35.180.1.96',
    'me-south-1': '15.185.91.0',
    'sa-east-1': '18.228.1.128',
    'us-east-1': '52.70.63.192',
    'us-east-2': '13.58.135.96',
    'us-gov-east-1': '18.253.138.96',
    'us-gov-west-1': '52.61.204.160',
    'us-west-1': '13.57.135.192',
    'us-west-2': '52.89.255.224',
};
//# sourceMappingURL=data:application/json;base64,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