import * as cxapi from '@aws-cdk/cx-api';
import { ISDK } from './aws-auth';
import { CloudFormationStack } from './util/cloudformation';
export declare const DEFAULT_TOOLKIT_STACK_NAME = "CDKToolkit";
/**
 * Information on the Bootstrap stack of the environment we're deploying to.
 *
 * This class serves to:
 *
 * - Inspect the bootstrap stack, and return various properties of it for successful
 *   asset deployment (in case of legacy-synthesized stacks).
 * - Validate the version of the target environment, and nothing else (in case of
 *   default-synthesized stacks).
 *
 * An object of this type might represent a bootstrap stack that could not be found.
 * This is not an issue unless any members are used that require the bootstrap stack
 * to have been found, in which case an error is thrown (default-synthesized stacks
 * should never run into this as they don't need information from the bootstrap
 * stack, all information is already encoded into the Cloud Assembly Manifest).
 *
 * Nevertheless, an instance of this class exists to serve as a cache for SSM
 * parameter lookups (otherwise, the "bootstrap stack version" parameter would
 * need to be read repeatedly).
 *
 * Called "ToolkitInfo" for historical reasons.
 *
 */
export declare abstract class ToolkitInfo {
    protected readonly sdk: ISDK;
    static determineName(overrideName?: string): string;
    static lookup(environment: cxapi.Environment, sdk: ISDK, stackName: string | undefined): Promise<ToolkitInfo>;
    static fromStack(stack: CloudFormationStack, sdk: ISDK): ToolkitInfo;
    static bootstraplessDeploymentsOnly(sdk: ISDK): ToolkitInfo;
    static bootstrapStackNotFoundInfo(sdk: ISDK): ToolkitInfo;
    abstract readonly found: boolean;
    abstract readonly bucketUrl: string;
    abstract readonly bucketName: string;
    abstract readonly version: number;
    abstract readonly bootstrapStack: CloudFormationStack;
    private readonly ssmCache;
    constructor(sdk: ISDK);
    abstract validateVersion(expectedVersion: number, ssmParameterName: string | undefined): Promise<void>;
    abstract prepareEcrRepository(repositoryName: string): Promise<EcrRepositoryInfo>;
    /**
     * Read a version from an SSM parameter, cached
     */
    protected versionFromSsmParameter(parameterName: string): Promise<number>;
}
export interface EcrRepositoryInfo {
    repositoryUri: string;
}
export interface EcrCredentials {
    username: string;
    password: string;
    endpoint: string;
}
