"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.stderr = exports.stdout = void 0;
const events_1 = require("events");
class ConsoleListener {
    constructor(stream, options) {
        this._stream = stream;
        this._options = options;
    }
    inspect() {
        let isTTY;
        if (this._options && this._options.isTTY !== undefined) {
            isTTY = this._options.isTTY;
        }
        const output = [];
        const stream = this._stream;
        const res = new events_1.EventEmitter();
        const originalWrite = stream.write;
        stream.write = (string) => {
            output.push(string);
            return res.emit('data', string);
        };
        const originalIsTTY = stream.isTTY;
        if (isTTY === true) {
            stream.isTTY = isTTY;
        }
        res.output = output;
        res.restore = () => {
            stream.write = originalWrite;
            stream.isTTY = originalIsTTY;
        };
        return res;
    }
    inspectSync(fn) {
        const inspect = this.inspect();
        try {
            fn(inspect.output);
        }
        finally {
            inspect.restore();
        }
        return inspect.output;
    }
}
exports.stdout = new ConsoleListener(process.stdout);
exports.stderr = new ConsoleListener(process.stderr);
//# sourceMappingURL=data:application/json;base64,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