"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const context_1 = require("../../lib/commands/context");
const settings_1 = require("../../lib/settings");
test('context list', async () => {
    // GIVEN
    const configuration = new settings_1.Configuration();
    configuration.context.set('foo', 'bar');
    expect(configuration.context.all).toEqual({
        foo: 'bar',
    });
    // WHEN
    await context_1.realHandler({
        configuration,
        args: {},
    });
});
test('context reset can remove a context key', async () => {
    // GIVEN
    const configuration = new settings_1.Configuration();
    configuration.context.set('foo', 'bar');
    configuration.context.set('baz', 'quux');
    expect(configuration.context.all).toEqual({
        foo: 'bar',
        baz: 'quux',
    });
    // WHEN
    await context_1.realHandler({
        configuration,
        args: { reset: 'foo' },
    });
    // THEN
    expect(configuration.context.all).toEqual({
        baz: 'quux',
    });
});
test('context reset can remove a context key using number', async () => {
    // GIVEN
    const configuration = new settings_1.Configuration();
    configuration.context.set('foo', 'bar');
    configuration.context.set('baz', 'quux');
    expect(configuration.context.all).toEqual({
        foo: 'bar',
        baz: 'quux',
    });
    // WHEN
    await context_1.realHandler({
        configuration,
        args: { reset: '1' },
    });
    // THEN
    expect(configuration.context.all).toEqual({
        foo: 'bar',
    });
});
//# sourceMappingURL=data:application/json;base64,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