"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.findYarnPackages = void 0;
const path = require("path");
const cdk_1 = require("./cdk");
/**
 * Cache monorepo discovery results, we only want to do this once per run
 */
const YARN_MONOREPO_CACHE = {};
/**
 * Return a { name -> directory } packages found in a Yarn monorepo
 *
 * Cached in YARN_MONOREPO_CACHE.
 */
async function findYarnPackages(root) {
    if (!(root in YARN_MONOREPO_CACHE)) {
        const output = JSON.parse(await cdk_1.shell(['yarn', 'workspaces', '--silent', 'info'], {
            captureStderr: false,
            cwd: root,
        }));
        const ret = {};
        for (const [k, v] of Object.entries(output)) {
            ret[k] = path.join(root, v.location);
        }
        YARN_MONOREPO_CACHE[root] = ret;
    }
    return YARN_MONOREPO_CACHE[root];
}
exports.findYarnPackages = findYarnPackages;
//# sourceMappingURL=data:application/json;base64,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