import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [applicationinsights](https://docs.aws.amazon.com/service-authorization/latest/reference/list_cloudwatchapplicationinsights.html).
 *
 * @experimental
 */
export declare class Applicationinsights extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to create an application from a resource group.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_CreateApplication.html
     *
     * @experimental
     */
    toCreateApplication(): this;
    /**
     * (experimental) Grants permission to create a component from a group of resources.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_CreateComponent.html
     *
     * @experimental
     */
    toCreateComponent(): this;
    /**
     * (experimental) Grants permission to create log a pattern.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_CreateLogPattern.html
     *
     * @experimental
     */
    toCreateLogPattern(): this;
    /**
     * (experimental) Grants permission to delete an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DeleteApplication.html
     *
     * @experimental
     */
    toDeleteApplication(): this;
    /**
     * (experimental) Grants permission to delete a component.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DeleteComponent.html
     *
     * @experimental
     */
    toDeleteComponent(): this;
    /**
     * (experimental) Grants permission to delete a log pattern.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DeleteLogPattern.html
     *
     * @experimental
     */
    toDeleteLogPattern(): this;
    /**
     * (experimental) Grants permission to describe an application.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeApplication.html
     *
     * @experimental
     */
    toDescribeApplication(): this;
    /**
     * (experimental) Grants permission to describe a component.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeComponent.html
     *
     * @experimental
     */
    toDescribeComponent(): this;
    /**
     * (experimental) Grants permission to describe a component's configuration.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeComponentConfiguration.html
     *
     * @experimental
     */
    toDescribeComponentConfiguration(): this;
    /**
     * (experimental) Grants permission to describe the recommended application component configuration.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeComponentConfigurationRecommendation.html
     *
     * @experimental
     */
    toDescribeComponentConfigurationRecommendation(): this;
    /**
     * (experimental) Grants permission to describe a log pattern.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeLogPattern.html
     *
     * @experimental
     */
    toDescribeLogPattern(): this;
    /**
     * (experimental) Grants permission to describe an observation.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeObservation.html
     *
     * @experimental
     */
    toDescribeObservation(): this;
    /**
     * (experimental) Grants permission to describe a problem.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeProblem.html
     *
     * @experimental
     */
    toDescribeProblem(): this;
    /**
     * (experimental) Grants permission to describe the observation in a problem.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeProblemObservations.html
     *
     * @experimental
     */
    toDescribeProblemObservations(): this;
    /**
     * (experimental) Grants permission to list all applications.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_ListApplications.html
     *
     * @experimental
     */
    toListApplications(): this;
    /**
     * (experimental) Grants permission to list an application's components.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_ListComponents.html
     *
     * @experimental
     */
    toListComponents(): this;
    /**
     * (experimental) Grants permission to list configuration history.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_ListConfigurationHistory.html
     *
     * @experimental
     */
    toListConfigurationHistory(): this;
    /**
     * (experimental) Grants permission to list log pattern sets for an application.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_ListLogPatternSets.html
     *
     * @experimental
     */
    toListLogPatternSets(): this;
    /**
     * (experimental) Grants permission to list log patterns.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_ListLogPatterns.html
     *
     * @experimental
     */
    toListLogPatterns(): this;
    /**
     * (experimental) Grants permission to list the problems in an application.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_ListProblems.html
     *
     * @experimental
     */
    toListProblems(): this;
    /**
     * (experimental) Grants permission to list tags for the resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to tag a resource.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to untag a resource.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update an application.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_UpdateApplication.html
     *
     * @experimental
     */
    toUpdateApplication(): this;
    /**
     * (experimental) Grants permission to update a component.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_UpdateComponent.html
     *
     * @experimental
     */
    toUpdateComponent(): this;
    /**
     * (experimental) Grants permission to update a component's configuration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_UpdateComponentConfiguration.html
     *
     * @experimental
     */
    toUpdateComponentConfiguration(): this;
    /**
     * (experimental) Grants permission to update a log pattern.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_UpdateLogPattern.html
     *
     * @experimental
     */
    toUpdateLogPattern(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Statement provider for service [applicationinsights](https://docs.aws.amazon.com/service-authorization/latest/reference/list_cloudwatchapplicationinsights.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
