import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [route53-recovery-cluster](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53recoverycluster.html).
 *
 * @experimental
 */
export declare class Route53RecoveryCluster extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to Get a Routing Control State.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/routing-control/latest/APIReference/API_GetRoutingControlState.html
     *
     * @experimental
     */
    toGetRoutingControlState(): this;
    /**
     * (experimental) Grants permission to Update a Routing Control State.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/routing-control/latest/APIReference/API_UpdateRoutingControlState.html
     *
     * @experimental
     */
    toUpdateRoutingControlState(): this;
    /**
     * (experimental) Grants permission to Update Routing Control States.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/routing-control/latest/APIReference/API_UpdateRoutingControlStates.html
     *
     * @experimental
     */
    toUpdateRoutingControlStates(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type routingcontrol to the statement.
     *
     * https://docs.aws.amazon.com/recovery-cluster/latest/api/routingcontrol.html
     *
     * @param controlPanelId - Identifier for the controlPanelId.
     * @param routingControlId - Identifier for the routingControlId.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onRoutingcontrol(controlPanelId: string, routingControlId: string, account?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [route53-recovery-cluster](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53recoverycluster.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
