import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
import { PolicyStatementProps } from "@aws-cdk/aws-iam";
/**
 * (experimental) Statement provider for service [trustedadvisor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awstrustedadvisor.html).
 *
 * @experimental
 */
export declare class Trustedadvisor extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to view the AWS Support plan and various AWS Trusted Advisor preferences.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     *
     * @experimental
     */
    toDescribeAccount(): this;
    /**
     * (experimental) Grants permission to view if the AWS account has enabled or disabled AWS Trusted Advisor.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     *
     * @experimental
     */
    toDescribeAccountAccess(): this;
    /**
     * (experimental) Grants permission to view details for the check items.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     *
     * @experimental
     */
    toDescribeCheckItems(): this;
    /**
     * (experimental) Grants permission to view the refresh statuses for AWS Trusted Advisor checks.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     *
     * @experimental
     */
    toDescribeCheckRefreshStatuses(): this;
    /**
     * (experimental) Grants permission to view AWS Trusted Advisor check summaries.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     *
     * @experimental
     */
    toDescribeCheckSummaries(): this;
    /**
     * (experimental) Grants permission to view details for AWS Trusted Advisor checks.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     *
     * @experimental
     */
    toDescribeChecks(): this;
    /**
     * (experimental) Grants permission to view the notification preferences for the AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     *
     * @experimental
     */
    toDescribeNotificationPreferences(): this;
    /**
     * (experimental) Grants permission to view if the AWS account meets the requirements to enable the organizational view feature.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     *
     * @experimental
     */
    toDescribeOrganization(): this;
    /**
     * (experimental) Grants permission to view the linked AWS accounts that are in the organization.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     *
     * @experimental
     */
    toDescribeOrganizationAccounts(): this;
    /**
     * (experimental) Grants permission to view details for organizational view reports, such as the report name, runtime, date created, status, and format.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     *
     * @experimental
     */
    toDescribeReports(): this;
    /**
     * (experimental) Grants permission to view information about organizational view reports, such as the AWS Regions, check categories, check names, and resource statuses.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     *
     * @experimental
     */
    toDescribeServiceMetadata(): this;
    /**
     * (experimental) Grants permission to exclude recommendations for AWS Trusted Advisor checks.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     *
     * @experimental
     */
    toExcludeCheckItems(): this;
    /**
     * (experimental) Grants permission to create a report for AWS Trusted Advisor checks in your organization.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     *
     * @experimental
     */
    toGenerateReport(): this;
    /**
     * (experimental) Grants permission to include recommendations for AWS Trusted Advisor checks.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     *
     * @experimental
     */
    toIncludeCheckItems(): this;
    /**
     * (experimental) Grants permission to view, in the Trusted Advisor console, all of the accounts in an AWS organization that are contained by a root or organizational unit (OU).
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     *
     * @experimental
     */
    toListAccountsForParent(): this;
    /**
     * (experimental) Grants permission to view, in the Trusted Advisor console, all of the organizational units (OUs) in a parent organizational unit or root.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     *
     * @experimental
     */
    toListOrganizationalUnitsForParent(): this;
    /**
     * (experimental) Grants permission to view, in the Trusted Advisor console, all of the roots that are defined in an AWS organization.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     *
     * @experimental
     */
    toListRoots(): this;
    /**
     * (experimental) Grants permission to refresh an AWS Trusted Advisor check.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     *
     * @experimental
     */
    toRefreshCheck(): this;
    /**
     * (experimental) Grants permission to enable or disable AWS Trusted Advisor for the account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     *
     * @experimental
     */
    toSetAccountAccess(): this;
    /**
     * (experimental) Grants permission to enable the organizational view feature for AWS Trusted Advisor.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     *
     * @experimental
     */
    toSetOrganizationAccess(): this;
    /**
     * (experimental) Grants permission to update notification preferences for AWS Trusted Advisor.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awssupport/latest/user/security-trusted-advisor.html#trusted-advisor-operations
     *
     * @experimental
     */
    toUpdateNotificationPreferences(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type checks to the statement.
     *
     * https://docs.aws.amazon.com/awssupport/latest/APIReference/API_TrustedAdvisorCheckDescription.html
     *
     * @param categoryCode - Identifier for the categoryCode.
     * @param checkId - Identifier for the checkId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onChecks(categoryCode: string, checkId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [trustedadvisor](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awstrustedadvisor.html).
     *
     * @experimental
     */
    constructor(props?: PolicyStatementProps);
}
