# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['aiocloudflare',
 'aiocloudflare.api',
 'aiocloudflare.api.accounts',
 'aiocloudflare.api.accounts.access',
 'aiocloudflare.api.accounts.access.apps',
 'aiocloudflare.api.accounts.access.apps.ca',
 'aiocloudflare.api.accounts.access.apps.policies',
 'aiocloudflare.api.accounts.access.apps.revoke_tokens',
 'aiocloudflare.api.accounts.access.certificates',
 'aiocloudflare.api.accounts.access.groups',
 'aiocloudflare.api.accounts.access.identity_providers',
 'aiocloudflare.api.accounts.access.logs',
 'aiocloudflare.api.accounts.access.logs.access_requests',
 'aiocloudflare.api.accounts.access.organizations',
 'aiocloudflare.api.accounts.access.organizations.revoke_user',
 'aiocloudflare.api.accounts.access.service_tokens',
 'aiocloudflare.api.accounts.addressing',
 'aiocloudflare.api.accounts.addressing.prefixes',
 'aiocloudflare.api.accounts.addressing.prefixes.bgp',
 'aiocloudflare.api.accounts.addressing.prefixes.bgp.status',
 'aiocloudflare.api.accounts.addressing.prefixes.delegations',
 'aiocloudflare.api.accounts.audit_logs',
 'aiocloudflare.api.accounts.billing',
 'aiocloudflare.api.accounts.billing.profile',
 'aiocloudflare.api.accounts.custom_pages',
 'aiocloudflare.api.accounts.diagnostics',
 'aiocloudflare.api.accounts.diagnostics.traceroute',
 'aiocloudflare.api.accounts.firewall',
 'aiocloudflare.api.accounts.firewall.access_rules',
 'aiocloudflare.api.accounts.firewall.access_rules.rules',
 'aiocloudflare.api.accounts.load_balancers',
 'aiocloudflare.api.accounts.load_balancers.monitors',
 'aiocloudflare.api.accounts.load_balancers.monitors.preview',
 'aiocloudflare.api.accounts.load_balancers.monitors.references',
 'aiocloudflare.api.accounts.load_balancers.pools',
 'aiocloudflare.api.accounts.load_balancers.pools.health',
 'aiocloudflare.api.accounts.load_balancers.pools.preview',
 'aiocloudflare.api.accounts.load_balancers.pools.references',
 'aiocloudflare.api.accounts.load_balancers.preview',
 'aiocloudflare.api.accounts.load_balancers.regions',
 'aiocloudflare.api.accounts.load_balancers.search',
 'aiocloudflare.api.accounts.members',
 'aiocloudflare.api.accounts.railguns',
 'aiocloudflare.api.accounts.railguns.connections',
 'aiocloudflare.api.accounts.registrar',
 'aiocloudflare.api.accounts.registrar.domains',
 'aiocloudflare.api.accounts.roles',
 'aiocloudflare.api.accounts.rules',
 'aiocloudflare.api.accounts.rules.lists',
 'aiocloudflare.api.accounts.rules.lists.bulk_operations',
 'aiocloudflare.api.accounts.rules.lists.items',
 'aiocloudflare.api.accounts.rulesets',
 'aiocloudflare.api.accounts.rulesets.import_',
 'aiocloudflare.api.accounts.rulesets.versions',
 'aiocloudflare.api.accounts.secondary_dns',
 'aiocloudflare.api.accounts.secondary_dns.masters',
 'aiocloudflare.api.accounts.secondary_dns.primaries',
 'aiocloudflare.api.accounts.secondary_dns.tsigs',
 'aiocloudflare.api.accounts.storage',
 'aiocloudflare.api.accounts.storage.analytics',
 'aiocloudflare.api.accounts.storage.analytics.stored',
 'aiocloudflare.api.accounts.storage.kv',
 'aiocloudflare.api.accounts.storage.kv.namespaces',
 'aiocloudflare.api.accounts.storage.kv.namespaces.bulk',
 'aiocloudflare.api.accounts.storage.kv.namespaces.keys',
 'aiocloudflare.api.accounts.storage.kv.namespaces.values',
 'aiocloudflare.api.accounts.stream',
 'aiocloudflare.api.accounts.stream.captions',
 'aiocloudflare.api.accounts.stream.copy',
 'aiocloudflare.api.accounts.stream.direct_upload',
 'aiocloudflare.api.accounts.stream.embed',
 'aiocloudflare.api.accounts.stream.keys',
 'aiocloudflare.api.accounts.stream.preview',
 'aiocloudflare.api.accounts.stream.watermarks',
 'aiocloudflare.api.accounts.stream.webhook',
 'aiocloudflare.api.accounts.subscriptions',
 'aiocloudflare.api.accounts.tunnels',
 'aiocloudflare.api.accounts.tunnels.connections',
 'aiocloudflare.api.accounts.virtual_dns',
 'aiocloudflare.api.accounts.virtual_dns.dns_analytics',
 'aiocloudflare.api.accounts.virtual_dns.dns_analytics.report',
 'aiocloudflare.api.accounts.virtual_dns.dns_analytics.report.bytime',
 'aiocloudflare.api.accounts.workers',
 'aiocloudflare.api.accounts.workers.scripts',
 'aiocloudflare.api.accounts.workers.scripts.schedules',
 'aiocloudflare.api.graphql',
 'aiocloudflare.api.memberships',
 'aiocloudflare.api.railguns',
 'aiocloudflare.api.railguns.zones',
 'aiocloudflare.api.user',
 'aiocloudflare.api.user.audit_logs',
 'aiocloudflare.api.user.billing',
 'aiocloudflare.api.user.billing.history',
 'aiocloudflare.api.user.billing.profile',
 'aiocloudflare.api.user.billing.subscriptions',
 'aiocloudflare.api.user.billing.subscriptions.apps',
 'aiocloudflare.api.user.billing.subscriptions.zones',
 'aiocloudflare.api.user.firewall',
 'aiocloudflare.api.user.firewall.access_rules',
 'aiocloudflare.api.user.firewall.access_rules.rules',
 'aiocloudflare.api.user.invites',
 'aiocloudflare.api.user.load_balancers',
 'aiocloudflare.api.user.load_balancers.monitors',
 'aiocloudflare.api.user.load_balancers.monitors.preview',
 'aiocloudflare.api.user.load_balancers.monitors.references',
 'aiocloudflare.api.user.load_balancers.pools',
 'aiocloudflare.api.user.load_balancers.pools.health',
 'aiocloudflare.api.user.load_balancers.pools.preview',
 'aiocloudflare.api.user.load_balancers.pools.references',
 'aiocloudflare.api.user.load_balancers.preview',
 'aiocloudflare.api.user.load_balancing_analytics',
 'aiocloudflare.api.user.load_balancing_analytics.events',
 'aiocloudflare.api.user.organizations',
 'aiocloudflare.api.user.subscriptions',
 'aiocloudflare.api.user.tokens',
 'aiocloudflare.api.user.tokens.permission_groups',
 'aiocloudflare.api.user.tokens.value',
 'aiocloudflare.api.user.tokens.verify',
 'aiocloudflare.api.user.workers',
 'aiocloudflare.api.user.workers.scripts',
 'aiocloudflare.api.zones',
 'aiocloudflare.api.zones.access',
 'aiocloudflare.api.zones.access.apps',
 'aiocloudflare.api.zones.access.apps.ca',
 'aiocloudflare.api.zones.access.apps.policies',
 'aiocloudflare.api.zones.access.apps.revoke_tokens',
 'aiocloudflare.api.zones.access.certificates',
 'aiocloudflare.api.zones.access.groups',
 'aiocloudflare.api.zones.access.identity_providers',
 'aiocloudflare.api.zones.access.organizations',
 'aiocloudflare.api.zones.access.organizations.revoke_user',
 'aiocloudflare.api.zones.access.service_tokens',
 'aiocloudflare.api.zones.activation_check',
 'aiocloudflare.api.zones.amp',
 'aiocloudflare.api.zones.amp.sxg',
 'aiocloudflare.api.zones.analytics',
 'aiocloudflare.api.zones.analytics.colos',
 'aiocloudflare.api.zones.analytics.dashboard',
 'aiocloudflare.api.zones.analytics.latency',
 'aiocloudflare.api.zones.analytics.latency.colos',
 'aiocloudflare.api.zones.argo',
 'aiocloudflare.api.zones.argo.smart_routing',
 'aiocloudflare.api.zones.argo.tiered_caching',
 'aiocloudflare.api.zones.available_plans',
 'aiocloudflare.api.zones.available_rate_plans',
 'aiocloudflare.api.zones.custom_certificates',
 'aiocloudflare.api.zones.custom_certificates.prioritize',
 'aiocloudflare.api.zones.custom_hostnames',
 'aiocloudflare.api.zones.custom_hostnames.fallback_origin',
 'aiocloudflare.api.zones.custom_pages',
 'aiocloudflare.api.zones.dns_analytics',
 'aiocloudflare.api.zones.dns_analytics.report',
 'aiocloudflare.api.zones.dns_analytics.report.bytime',
 'aiocloudflare.api.zones.dns_records',
 'aiocloudflare.api.zones.dns_records.export',
 'aiocloudflare.api.zones.dns_records.import_',
 'aiocloudflare.api.zones.dnssec',
 'aiocloudflare.api.zones.filters',
 'aiocloudflare.api.zones.firewall',
 'aiocloudflare.api.zones.firewall.access_rules',
 'aiocloudflare.api.zones.firewall.access_rules.rules',
 'aiocloudflare.api.zones.firewall.lockdowns',
 'aiocloudflare.api.zones.firewall.rules',
 'aiocloudflare.api.zones.firewall.ua_rules',
 'aiocloudflare.api.zones.firewall.waf',
 'aiocloudflare.api.zones.firewall.waf.overrides',
 'aiocloudflare.api.zones.firewall.waf.packages',
 'aiocloudflare.api.zones.firewall.waf.packages.groups',
 'aiocloudflare.api.zones.firewall.waf.packages.rules',
 'aiocloudflare.api.zones.healthchecks',
 'aiocloudflare.api.zones.healthchecks.preview',
 'aiocloudflare.api.zones.keyless_certificates',
 'aiocloudflare.api.zones.load_balancers',
 'aiocloudflare.api.zones.logpush',
 'aiocloudflare.api.zones.logpush.datasets',
 'aiocloudflare.api.zones.logpush.datasets.fields',
 'aiocloudflare.api.zones.logpush.datasets.jobs',
 'aiocloudflare.api.zones.logpush.jobs',
 'aiocloudflare.api.zones.logpush.ownership',
 'aiocloudflare.api.zones.logpush.ownership.validate',
 'aiocloudflare.api.zones.logpush.validate',
 'aiocloudflare.api.zones.logpush.validate.destination',
 'aiocloudflare.api.zones.logpush.validate.destination.exists',
 'aiocloudflare.api.zones.logpush.validate.origin',
 'aiocloudflare.api.zones.logs',
 'aiocloudflare.api.zones.logs.control',
 'aiocloudflare.api.zones.logs.control.retention',
 'aiocloudflare.api.zones.logs.control.retention.flag',
 'aiocloudflare.api.zones.logs.rayids',
 'aiocloudflare.api.zones.logs.received',
 'aiocloudflare.api.zones.logs.received.fields',
 'aiocloudflare.api.zones.media',
 'aiocloudflare.api.zones.media.embed',
 'aiocloudflare.api.zones.media.preview',
 'aiocloudflare.api.zones.origin_tls_client_auth',
 'aiocloudflare.api.zones.origin_tls_client_auth.hostnames',
 'aiocloudflare.api.zones.origin_tls_client_auth.hostnames.certificates',
 'aiocloudflare.api.zones.origin_tls_client_auth.settings',
 'aiocloudflare.api.zones.pagerules',
 'aiocloudflare.api.zones.pagerules.settings',
 'aiocloudflare.api.zones.purge_cache',
 'aiocloudflare.api.zones.railguns',
 'aiocloudflare.api.zones.railguns.diagnose',
 'aiocloudflare.api.zones.rate_limits',
 'aiocloudflare.api.zones.rulesets',
 'aiocloudflare.api.zones.rulesets.versions',
 'aiocloudflare.api.zones.secondary_dns',
 'aiocloudflare.api.zones.secondary_dns.force_axfr',
 'aiocloudflare.api.zones.security',
 'aiocloudflare.api.zones.security.events',
 'aiocloudflare.api.zones.settings',
 'aiocloudflare.api.zones.settings.advanced_ddos',
 'aiocloudflare.api.zones.settings.always_online',
 'aiocloudflare.api.zones.settings.always_use_https',
 'aiocloudflare.api.zones.settings.automatic_https_rewrites',
 'aiocloudflare.api.zones.settings.brotli',
 'aiocloudflare.api.zones.settings.browser_cache_ttl',
 'aiocloudflare.api.zones.settings.browser_check',
 'aiocloudflare.api.zones.settings.cache_level',
 'aiocloudflare.api.zones.settings.challenge_ttl',
 'aiocloudflare.api.zones.settings.ciphers',
 'aiocloudflare.api.zones.settings.development_mode',
 'aiocloudflare.api.zones.settings.email_obfuscation',
 'aiocloudflare.api.zones.settings.h2_prioritization',
 'aiocloudflare.api.zones.settings.hotlink_protection',
 'aiocloudflare.api.zones.settings.http2',
 'aiocloudflare.api.zones.settings.http3',
 'aiocloudflare.api.zones.settings.image_resizing',
 'aiocloudflare.api.zones.settings.ip_geolocation',
 'aiocloudflare.api.zones.settings.ipv6',
 'aiocloudflare.api.zones.settings.min_tls_version',
 'aiocloudflare.api.zones.settings.minify',
 'aiocloudflare.api.zones.settings.mirage',
 'aiocloudflare.api.zones.settings.mobile_redirect',
 'aiocloudflare.api.zones.settings.opportunistic_encryption',
 'aiocloudflare.api.zones.settings.opportunistic_onion',
 'aiocloudflare.api.zones.settings.origin_error_page_pass_thru',
 'aiocloudflare.api.zones.settings.ortt',
 'aiocloudflare.api.zones.settings.polish',
 'aiocloudflare.api.zones.settings.prefetch_preload',
 'aiocloudflare.api.zones.settings.privacy_pass',
 'aiocloudflare.api.zones.settings.pseudo_ipv4',
 'aiocloudflare.api.zones.settings.response_buffering',
 'aiocloudflare.api.zones.settings.rocket_loader',
 'aiocloudflare.api.zones.settings.security_header',
 'aiocloudflare.api.zones.settings.security_level',
 'aiocloudflare.api.zones.settings.server_side_exclude',
 'aiocloudflare.api.zones.settings.sort_query_string_for_cache',
 'aiocloudflare.api.zones.settings.ssl',
 'aiocloudflare.api.zones.settings.tls_1_3',
 'aiocloudflare.api.zones.settings.tls_client_auth',
 'aiocloudflare.api.zones.settings.true_client_ip_header',
 'aiocloudflare.api.zones.settings.waf',
 'aiocloudflare.api.zones.settings.webp',
 'aiocloudflare.api.zones.settings.websockets',
 'aiocloudflare.api.zones.spectrum',
 'aiocloudflare.api.zones.spectrum.analytics',
 'aiocloudflare.api.zones.spectrum.analytics.aggregate',
 'aiocloudflare.api.zones.spectrum.analytics.aggregate.current',
 'aiocloudflare.api.zones.spectrum.analytics.events',
 'aiocloudflare.api.zones.spectrum.analytics.events.bytime',
 'aiocloudflare.api.zones.spectrum.analytics.events.summary',
 'aiocloudflare.api.zones.spectrum.apps',
 'aiocloudflare.api.zones.ssl',
 'aiocloudflare.api.zones.ssl.analyze',
 'aiocloudflare.api.zones.ssl.certificate_packs',
 'aiocloudflare.api.zones.ssl.certificate_packs.order',
 'aiocloudflare.api.zones.ssl.certificate_packs.quota',
 'aiocloudflare.api.zones.ssl.universal',
 'aiocloudflare.api.zones.ssl.universal.settings',
 'aiocloudflare.api.zones.ssl.verification',
 'aiocloudflare.api.zones.subscription',
 'aiocloudflare.api.zones.waiting_rooms',
 'aiocloudflare.api.zones.waiting_rooms.preview',
 'aiocloudflare.api.zones.waiting_rooms.status',
 'aiocloudflare.api.zones.workers',
 'aiocloudflare.api.zones.workers.filters',
 'aiocloudflare.api.zones.workers.routes',
 'aiocloudflare.api.zones.workers.script',
 'aiocloudflare.api.zones.workers.script.bindings',
 'aiocloudflare.commons']

package_data = \
{'': ['*']}

install_requires = \
['httpx>=0.19.0,<0.20.0', 'python-dotenv>=0.19.0,<0.20.0']

setup_kwargs = {
    'name': 'aiocloudflare',
    'version': '0.2.0b3',
    'description': 'A Cloudflare API wrapper for Python with asyncio support',
    'long_description': 'aioCloudflare\n=============\n\n|PyPI| |Status| |Python Version| |License|\n\n|Tests| |Codecov|\n\n|pre-commit| |Black|\n\n|Downloads|\n\n.. |PyPI| image:: https://img.shields.io/pypi/v/aiocloudflare.svg\n   :target: https://pypi.org/project/aiocloudflare/\n   :alt: PyPI\n.. |Status| image:: https://img.shields.io/pypi/status/aiocloudflare.svg\n   :target: https://pypi.org/project/aiocloudflare/\n   :alt: Status\n.. |Python Version| image:: https://img.shields.io/pypi/pyversions/aiocloudflare\n   :target: https://pypi.org/project/aiocloudflare\n   :alt: Python Version\n.. |License| image:: https://img.shields.io/pypi/l/aiocloudflare\n   :target: https://opensource.org/licenses/MIT\n   :alt: License\n.. |Tests| image:: https://github.com/stewart86/aiocloudflare/workflows/Tests/badge.svg\n   :target: https://github.com/stewart86/aiocloudflare/actions?workflow=Tests\n   :alt: Tests\n.. |Codecov| image:: https://codecov.io/gh/stewart86/aiocloudflare/branch/main/graph/badge.svg\n   :target: https://codecov.io/gh/stewart86/aiocloudflare\n   :alt: Codecov\n.. |pre-commit| image:: https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white\n   :target: https://github.com/pre-commit/pre-commit\n   :alt: pre-commit\n.. |Black| image:: https://img.shields.io/badge/code%20style-black-000000.svg\n   :target: https://github.com/psf/black\n   :alt: Black\n.. |Downloads| image:: https://static.pepy.tech/badge/aiocloudflare\n   :target: https://pepy.tech/project/aiocloudflare\n   :alt: Downloads\n\nInspired by the offical ``python-cloudflare`` library developed by `Cloudflare`_. This project is created to be compatible with ``asyncio`` for non-blocking IO.\n\nFor sync code, it is recommanded to use ``python-cloudflare`` via ``pip install python-cloudflare`` as it is used by hundreds and offically maintained by Cloudflare. This ensure that APIs are always updated according to Cloudflare API release.\n\n*NOTE:* This library is in Beta, this means fixes and updates are still going on every second. Do not use it in Production unless you have tested on the API route specific to your use case and that would be at your own risk.\n\nHaving said that, do submit an issue if you encounter any bug so we can move away from the Alpha stage sooner.\n\nFeatures\n--------\n\n* async http API call using modern http library ``httpx``.\n* Autocompletion on IDE.\n* Fully type hinted.\n\nFeature Roadmap\n---------------\n\n* to support cert token\n* to support sync API client\n\nThese are some alternative use cases that are not in the top of my priority now as I have not received\nany request for. If you are interested, you may want to submit a pull request to contribute some of these features.\n\n\nRequirements\n------------\n\n* ``Python`` 3.9+\n\n\nInstallation\n------------\n\nYou can install *aiocloudflare* via pip_ from PyPI_:\n\n.. code:: console\n\n   $ pip install aiocloudflare\n\n\nUsage\n-----\n\n.. code:: Python\n\n    from aiocloudflare import Cloudflare\n\n    async def get_zone():\n        async with Cloudflare() as cf:\n            response = await cf.zones.get()\n\nUnlike the offical ``python-cloudflare`` library, ``aiocloudflare`` does not parse and handle http responses.\n\nSo the awaited response object will have to be handled just as any http request, response pattern. the ``Response`` object is the same as ``httpx``\'s ``Response``.\n\n.. code:: Python\n\n    from aiocloudflare import Cloudflare\n\n    async def get_zone():\n        async with Cloudflare() as cf:\n            response = await cf.zones.get()\n\n            # check status code\n            if response.status_code == 200:\n\n                # get json data\n                resp_json = response.json()\n\n                # Cloudflare API typically store results in a ``result`` key.\n                return resp_json["result"]\n\n            else:\n                # to get texture data from response\n                print(response.text)\n\n\nFull configuration can be done using ``Config()`` class.\n\n.. code:: Python\n\n    from aioCloudflare import Cloudflare, Config\n\n    config = Config(email="your@email.com", token="<secret>")  # for demo only, do not hardcode secrets\n    async def get_zone():\n        async with Cloudflare(config=config) as cf:\n            result = await cf.zones.get()\n\nConfiguration can also be stored in a ``.env`` file for a "global" configuration without needing to create a ``Config()`` class. Keys available are:\n\n.. code:: console\n\n    CF_API_EMAIL=""\n    CF_API_KEY=""\n    CF_API_CERTKEY=""\n    CF_API_URL=""\n    DEBUG=false\n    CF_PROFILE=""\n    USER_AGENT=""\n\nAdvance Usage\n_____________\n\nYou may wish to wrap ``Cloudflare()`` into you own class for customised settings or requirements. To do that, just provide a ``__aenter__()`` and ``__aexit__()`` method to your class like so.\n\n.. code:: Python\n\n    class MyCfClient:\n        def __init__(self):\n            self._config = Config(email="your@email.com", token="<secret>")  # for demo only, do not hardcode secrets\n\n        async def __aenter__(self):\n            self._client = Cloudflare(config=self._config)\n            return self\n\n        async def __aexit__(self, exc_type, exc_value, traceback):\n            await self._client.aclose()\n\nThen you can call your own class with async context manager.\n\n.. code:: Python\n\n    async with MyCfClient() as own_class:\n        await own_class.zones.get()\n\n\nContributing\n------------\n\nContributions are very welcome.\nTo learn more, see the `Contributor Guide`_.\n\n\nLicense\n-------\n\nDistributed under the terms of the `MIT license`_,\n*aioCloudflare* is free and open source software.\n\n\nIssues\n------\n\nIf you encounter any problems,\nplease `file an issue`_ along with a detailed description.\n\n\n.. _MIT license: https://opensource.org/licenses/MIT\n.. _PyPI: https://pypi.org/\n.. _file an issue: https://github.com/stewart86/aiocloudflare/issues\n.. _pip: https://pip.pypa.io/\n.. _Cloudflare: https://github.com/cloudflare/python-cloudflare\n.. github-only\n.. _Contributor Guide: CONTRIBUTING.rst\n',
    'author': 'Stewart Wong',
    'author_email': 'siwei.wong@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/stewart86/aiocloudflare',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
