# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['local_settings']

package_data = \
{'': ['*']}

install_requires = \
['Django>=2.2', 'arrow>=1.1.0,<2.0.0', 'python-dotenv>=0.17.1,<0.18.0']

entry_points = \
{'console_scripts': ['make-local-settings = '
                     'local_settings:make_local_settings']}

setup_kwargs = {
    'name': 'django-local-settings',
    'version': '2.0a5',
    'description': 'Define Django settings in config files and/or via environment variables',
    'long_description': '# Local settings for Django projects\n\n## New in version 2\n\n- Settings can now be defined as environment variables (env settings)\n- The values for env settings can be specified in a `.env` file and\n  they\'ll be loaded automatically, or any standard method of setting\n  environment variables can be used\n- Secret settings can now have a callable default (they weren\'t allowed\n  to have a default before)\n- List and dict settings can now have trailing commas\n- Literal date & time values can now be specified (`2021-06-23`, etc)\n- Additional number syntaxes are now supported (any valid Python `int`\n  or `float`)\n- Support for Python 3.5 and below was dropped; supporting only 3.6 and\n  up is much simpler\n- Support for old, unsupported versions of Django was dropped\n\nThis package attempts to solve the problem of handling local settings in\nDjango projects. Local settings by definition can\'t be pre-defined,\nalthough perhaps they can have a reasonable default value (mainly useful\nfor development). Another class of local settings are *secret* settings;\nthese definitely shouldn\'t be pre-defined and should never be added to\nversion control.\n\nThe problems with local settings are:\n\n- How to specify which settings are local\n- How to inform others which settings are local (or secret)\n- How to actually give the local settings a value\n- How to verify that local settings have been given a valid value\n- How to ensure new local settings get set\n- How to ensure local (and esp. secret) settings don\'t get added to\n  version control\n\nOne common approach is to create a local settings template module with\ndummy/default values. When new developers start working on a project,\nthey copy this file (e.g., `local_settings.py.template =>\nlocal_settings.py`), which is typically excluded from version control.\nThis approach at least identifies which settings are local, but it\'s not\nvery convenient with regard to setting values and ensuring those values\nare valid. Also, instead of giving you a friendly heads-up when you\nforget to set a local setting, it barfs out an exception.\n\nThis package takes the approach that there will be only one settings\nmodule* per project in the standard location: `{project}.settings`. That\nmodule defines/overrides Django\'s base settings in the usual way *plus*\nit defines which settings are local and which are secret.\n\nIn addition to the settings module, there will be one or more settings\n*files*. These are standard INI files with the added twist that the\nvalues are JSON encoded. The reasoning behind this is to use a simple,\nstandard config file format while still allowing for easy handling of\nnon-string settings.\n\nIn addition, interpolation is supported using Django-style `{{ ... }}`\nsyntax. This can be handy to avoid repetition.\n\nOnce the local settings are defined, *any missing settings will be\nprompted for in the console* (with pretty colors and readline support).\n\nIn addition to settings files, settings can defined via environment\nvariables. These can be defined in a `.env` file or using any other\nmechanism for setting environment variables. When using a `.env` file,\nthe values will be read in automatically; when *not* using a `.env`\nfile, the corresponding environment variables will need to be set prior\nto loading the local settings.\n\nEnv settings are typically strings like passwords and API tokens, but\nthey will proccessed like other settings--values will be loaded as JSON\nand interpolated, etc.\n\n## Features\n\n- Local settings can be defined in a settings file (or files) *or* as\n  environment variables (AKA env settings)\n- When using env settings, environment variables will be loaded from\n  a `.env` file automatically, if present\n- Missing local settings will be prompted for (only when running on a\n  TTY/console)\n- Local settings can be defined with validators\n- Local settings can be defined with doc strings\n- Local settings can be nested in settings lists and dicts\n- Settings files can extend from each other\n- Settings values can be injected into other settings values using a\n  special syntax (AKA interpolation, similar to the standard library\'s\n  `configparser`)\n- Includes a script to easily generate local settings files for\n  different environments\n- Supports Python 3.6 - 3.9\n- Supports Django 2.2 - 3.2\n\n## Basic usage\n\n- In your project\'s settings *module*, import the `inject_settings`\n  function along with the types of settings you need:\n\n        from local_settings import (\n            inject_settings,\n            LocalSetting,\n            SecretSetting,\n        )\n\n- Then define some base settings and local settings:\n\n        # project/settings.py\n        from django.core.management import utils\n\n        # This is used to demonstrate interpolation.\n        PACKAGE = "local_settings"\n  \n        DEBUG = LocalSetting(default=False)\n  \n        # This setting will be loaded from the environment variable\n        # API_TOKEN, which can be defined in a .env file or set directly\n        # in the environment.\n        SOME_SERVICE = {\n            "api_token": EnvSetting("API_TOKEN"),\n        }\n  \n        DATABASES = {\n            "default": {\n                "ENGINE": "django.db.backends.postgresql",\n                "NAME": LocalSetting(default="{{ PACKAGE }}"),\n                "USER": LocalSetting(""),\n                "PASSWORD": SecretSetting(),\n                "HOST": LocalSetting(""),\n                "PORT": "",\n            },\n        }\n  \n        # If a secret setting specifies a default, it must be a callable\n        # that generates the value; this discourages using the same\n        # secret in different environments.\n        SECRET_KEY = SecretSetting(\n            default=utils.get_random_secret_key,\n            doc="The secret key for doing secret stuff",\n        )\n\n    Local settings can be nested inside other settings. They can also\n    have doc strings, which are displayed when prompting, and default\n    values or value generators, which are used as suggestions when\n    prompting.\n\n    This also demonstrates interpolation. The `DATABASES.default.NAME`\n    setting will be replaced with the `PACKAGE` setting, so that its\n    default value is effectively `\'top_level_package\'`.\n\n- *After* all the local settings are defined, add the following line:\n\n        inject_settings()\n\n    This initializes the local settings loader with the base settings\n    from the settings *module* and tells it which settings are local\n    settings. It then merges in the settings from the settings *file*.\n\n    `inject_settings()` loads the project\'s local settings from a file\n    (`$CWD/local.cfg` by default), prompting for any that are missing,\n    and/or environment variables, and returns a new dictionary with\n    local settings merged over any base settings. When not running on\n    a TTY/console, missing local settings will cause an exception to be\n    raised.\n\n    After `inject_settings()` runs, you\'ll be able to access the local\n    settings in the settings module as usual, in case some dynamic\n    configuration is required. For example, you could do `if DEBUG:\n    ...`. At this point, `DEBUG` is no longer a `LocalSetting`\n    instance--it\'s a regular Python `bool`.\n\n- Now you can run any `manage.py` command, and you will be prompted to\n  enter any missing local settings. On the first run, the settings file\n  will be created. On subsequent runs when new local settings are added\n  to the settings module, the settings file will be appended to.\n\n- Alternatively, you can run the included `make-local-settings` script\n  to generate a local settings file.\n\n## Advanced usage\n\nTODO: Discuss using multiple settings files, extending a settings file\nfrom another file, how to specify a settings file other than the default\nof `local.cfg`, editing settings files directly, &c.\n',
    'author': 'Wyatt Baldwin',
    'author_email': 'self@wyattbaldwin.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/wylee/django-local-settings',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
