# data-repo-client
<details><summary>This document defines the REST API for the Terra Data Repository.</summary> <p> **Status: design in progress**
There are a few top-level endpoints (besides some used by swagger):
 * / - generated by swagger: swagger API page that provides this
documentation and a live UI for submitting REST requests
 * /status - provides the operational status of the service
 * /configuration - provides the basic configuration and information about the service
 * /api - is the authenticated and authorized Data Repository API
 * /ga4gh/drs/v1 - is a transcription of the Data Repository Service API

The API endpoints are organized by interface. Each interface is separately versioned. <p> **Notes on Naming** <p> All of the reference items are suffixed with \\\"Model\\\". Those names are used as the class names in the generated Java code. It is helpful to distinguish these model classes from other related classes, like the DAO classes and the operation classes. </details>


This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 0.1.0
- Package version: 1.303.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import data_repo_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import data_repo_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import data_repo_client
from data_repo_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost
# See configuration.py for a list of all supported configuration parameters.
configuration = data_repo_client.Configuration(
    host = "http://localhost"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure OAuth2 access token for authorization: googleoauth
configuration = data_repo_client.Configuration(
    host = "http://localhost"
)
configuration.access_token = 'YOUR_ACCESS_TOKEN'


# Enter a context with an instance of the API client
with data_repo_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = data_repo_client.DataRepositoryServiceApi(api_client)
    object_id = 'object_id_example' # str | An `id` of a Data Object
access_id = 'access_id_example' # str | An `access_id` from the `access_methods` list of a Data Object

    try:
        # Get a URL for fetching bytes.
        api_response = api_instance.get_access_url(object_id, access_id)
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling DataRepositoryServiceApi->get_access_url: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*DataRepositoryServiceApi* | [**get_access_url**](docs/DataRepositoryServiceApi.md#get_access_url) | **GET** /ga4gh/drs/v1/objects/{object_id}/access/{access_id} | Get a URL for fetching bytes.
*DataRepositoryServiceApi* | [**get_object**](docs/DataRepositoryServiceApi.md#get_object) | **GET** /ga4gh/drs/v1/objects/{object_id} | Get info about an &#x60;Object&#x60;.
*DataRepositoryServiceApi* | [**get_service_info**](docs/DataRepositoryServiceApi.md#get_service_info) | **GET** /ga4gh/drs/v1/service-info | Get information about this implementation.
*ConfigsApi* | [**get_config**](docs/ConfigsApi.md#get_config) | **GET** /api/repository/v1/configs/{name} | 
*ConfigsApi* | [**get_config_list**](docs/ConfigsApi.md#get_config_list) | **GET** /api/repository/v1/configs | 
*ConfigsApi* | [**reset_config**](docs/ConfigsApi.md#reset_config) | **PUT** /api/repository/v1/configs/reset | 
*ConfigsApi* | [**set_config_list**](docs/ConfigsApi.md#set_config_list) | **PUT** /api/repository/v1/configs | 
*ConfigsApi* | [**set_fault**](docs/ConfigsApi.md#set_fault) | **PUT** /api/repository/v1/configs/{name} | 
*DatasetsApi* | [**add_dataset_asset_specifications**](docs/DatasetsApi.md#add_dataset_asset_specifications) | **POST** /api/repository/v1/datasets/{id}/assets | 
*DatasetsApi* | [**add_dataset_policy_member**](docs/DatasetsApi.md#add_dataset_policy_member) | **POST** /api/repository/v1/datasets/{id}/policies/{policyName}/members | 
*DatasetsApi* | [**apply_dataset_data_deletion**](docs/DatasetsApi.md#apply_dataset_data_deletion) | **POST** /api/repository/v1/datasets/{id}/deletes | 
*DatasetsApi* | [**bulk_file_load**](docs/DatasetsApi.md#bulk_file_load) | **POST** /api/repository/v1/datasets/{id}/files/bulk | 
*DatasetsApi* | [**bulk_file_load_array**](docs/DatasetsApi.md#bulk_file_load_array) | **POST** /api/repository/v1/datasets/{id}/files/bulk/array | 
*DatasetsApi* | [**bulk_file_results_delete**](docs/DatasetsApi.md#bulk_file_results_delete) | **DELETE** /api/repository/v1/datasets/{id}/files/bulk/{loadTag} | 
*DatasetsApi* | [**close_transaction**](docs/DatasetsApi.md#close_transaction) | **POST** /api/repository/v1/datasets/{id}/transactions/{transactionId} | 
*DatasetsApi* | [**create_dataset**](docs/DatasetsApi.md#create_dataset) | **POST** /api/repository/v1/datasets | 
*DatasetsApi* | [**delete_dataset**](docs/DatasetsApi.md#delete_dataset) | **DELETE** /api/repository/v1/datasets/{id} | 
*DatasetsApi* | [**delete_dataset_policy_member**](docs/DatasetsApi.md#delete_dataset_policy_member) | **DELETE** /api/repository/v1/datasets/{id}/policies/{policyName}/members/{memberEmail} | 
*DatasetsApi* | [**delete_file**](docs/DatasetsApi.md#delete_file) | **DELETE** /api/repository/v1/datasets/{id}/files/{fileid} | 
*DatasetsApi* | [**enumerate_datasets**](docs/DatasetsApi.md#enumerate_datasets) | **GET** /api/repository/v1/datasets | 
*DatasetsApi* | [**enumerate_transactions**](docs/DatasetsApi.md#enumerate_transactions) | **GET** /api/repository/v1/datasets/{id}/transactions | 
*DatasetsApi* | [**get_load_history_for_load_tag**](docs/DatasetsApi.md#get_load_history_for_load_tag) | **GET** /api/repository/v1/datasets/{id}/files/bulk/{loadTag} | 
*DatasetsApi* | [**ingest_dataset**](docs/DatasetsApi.md#ingest_dataset) | **POST** /api/repository/v1/datasets/{id}/ingest | 
*DatasetsApi* | [**ingest_file**](docs/DatasetsApi.md#ingest_file) | **POST** /api/repository/v1/datasets/{id}/files | 
*DatasetsApi* | [**lookup_file_by_id**](docs/DatasetsApi.md#lookup_file_by_id) | **GET** /api/repository/v1/datasets/{id}/files/{fileid} | 
*DatasetsApi* | [**lookup_file_by_path**](docs/DatasetsApi.md#lookup_file_by_path) | **GET** /api/repository/v1/datasets/{id}/filesystem/objects | 
*DatasetsApi* | [**open_transaction**](docs/DatasetsApi.md#open_transaction) | **POST** /api/repository/v1/datasets/{id}/transactions | 
*DatasetsApi* | [**remove_dataset_asset_specifications**](docs/DatasetsApi.md#remove_dataset_asset_specifications) | **DELETE** /api/repository/v1/datasets/{id}/assets/{assetid} | 
*DatasetsApi* | [**retrieve_dataset**](docs/DatasetsApi.md#retrieve_dataset) | **GET** /api/repository/v1/datasets/{id} | 
*DatasetsApi* | [**retrieve_dataset_policies**](docs/DatasetsApi.md#retrieve_dataset_policies) | **GET** /api/repository/v1/datasets/{id}/policies | 
*DatasetsApi* | [**retrieve_transaction**](docs/DatasetsApi.md#retrieve_transaction) | **GET** /api/repository/v1/datasets/{id}/transactions/{transactionId} | 
*DatasetsApi* | [**retrieve_user_dataset_roles**](docs/DatasetsApi.md#retrieve_user_dataset_roles) | **GET** /api/repository/v1/datasets/{id}/roles | 
*JobsApi* | [**enumerate_jobs**](docs/JobsApi.md#enumerate_jobs) | **GET** /api/repository/v1/jobs | 
*JobsApi* | [**retrieve_job**](docs/JobsApi.md#retrieve_job) | **GET** /api/repository/v1/jobs/{id} | 
*JobsApi* | [**retrieve_job_result**](docs/JobsApi.md#retrieve_job_result) | **GET** /api/repository/v1/jobs/{id}/result | 
*ProfilesApi* | [**add_profile_policy_member**](docs/ProfilesApi.md#add_profile_policy_member) | **POST** /api/resources/v1/profiles/{id}/policies/{policyName}/members | 
*ProfilesApi* | [**create_profile**](docs/ProfilesApi.md#create_profile) | **POST** /api/resources/v1/profiles | 
*ProfilesApi* | [**delete_profile**](docs/ProfilesApi.md#delete_profile) | **DELETE** /api/resources/v1/profiles/{id} | 
*ProfilesApi* | [**delete_profile_policy_member**](docs/ProfilesApi.md#delete_profile_policy_member) | **DELETE** /api/resources/v1/profiles/{id}/policies/{policyName}/members/{memberEmail} | 
*ProfilesApi* | [**enumerate_profiles**](docs/ProfilesApi.md#enumerate_profiles) | **GET** /api/resources/v1/profiles | 
*ProfilesApi* | [**retrieve_profile**](docs/ProfilesApi.md#retrieve_profile) | **GET** /api/resources/v1/profiles/{id} | 
*ProfilesApi* | [**retrieve_profile_policies**](docs/ProfilesApi.md#retrieve_profile_policies) | **GET** /api/resources/v1/profiles/{id}/policies | 
*ProfilesApi* | [**update_profile**](docs/ProfilesApi.md#update_profile) | **PUT** /api/resources/v1/profiles | 
*RegisterApi* | [**user**](docs/RegisterApi.md#user) | **GET** /api/repository/v1/register/user | 
*RepositoryApi* | [**add_dataset_asset_specifications**](docs/RepositoryApi.md#add_dataset_asset_specifications) | **POST** /api/repository/v1/datasets/{id}/assets | 
*RepositoryApi* | [**add_dataset_policy_member**](docs/RepositoryApi.md#add_dataset_policy_member) | **POST** /api/repository/v1/datasets/{id}/policies/{policyName}/members | 
*RepositoryApi* | [**add_snapshot_policy_member**](docs/RepositoryApi.md#add_snapshot_policy_member) | **POST** /api/repository/v1/snapshots/{id}/policies/{policyName}/members | 
*RepositoryApi* | [**apply_dataset_data_deletion**](docs/RepositoryApi.md#apply_dataset_data_deletion) | **POST** /api/repository/v1/datasets/{id}/deletes | 
*RepositoryApi* | [**bulk_file_load**](docs/RepositoryApi.md#bulk_file_load) | **POST** /api/repository/v1/datasets/{id}/files/bulk | 
*RepositoryApi* | [**bulk_file_load_array**](docs/RepositoryApi.md#bulk_file_load_array) | **POST** /api/repository/v1/datasets/{id}/files/bulk/array | 
*RepositoryApi* | [**bulk_file_results_delete**](docs/RepositoryApi.md#bulk_file_results_delete) | **DELETE** /api/repository/v1/datasets/{id}/files/bulk/{loadTag} | 
*RepositoryApi* | [**close_transaction**](docs/RepositoryApi.md#close_transaction) | **POST** /api/repository/v1/datasets/{id}/transactions/{transactionId} | 
*RepositoryApi* | [**create_dataset**](docs/RepositoryApi.md#create_dataset) | **POST** /api/repository/v1/datasets | 
*RepositoryApi* | [**create_search_index**](docs/RepositoryApi.md#create_search_index) | **POST** /api/repository/v1/search/{id}/index | 
*RepositoryApi* | [**create_snapshot**](docs/RepositoryApi.md#create_snapshot) | **POST** /api/repository/v1/snapshots | 
*RepositoryApi* | [**delete_dataset**](docs/RepositoryApi.md#delete_dataset) | **DELETE** /api/repository/v1/datasets/{id} | 
*RepositoryApi* | [**delete_dataset_policy_member**](docs/RepositoryApi.md#delete_dataset_policy_member) | **DELETE** /api/repository/v1/datasets/{id}/policies/{policyName}/members/{memberEmail} | 
*RepositoryApi* | [**delete_file**](docs/RepositoryApi.md#delete_file) | **DELETE** /api/repository/v1/datasets/{id}/files/{fileid} | 
*RepositoryApi* | [**delete_search_metadata**](docs/RepositoryApi.md#delete_search_metadata) | **DELETE** /api/repository/v1/search/{id}/metadata | 
*RepositoryApi* | [**delete_snapshot**](docs/RepositoryApi.md#delete_snapshot) | **DELETE** /api/repository/v1/snapshots/{id} | 
*RepositoryApi* | [**delete_snapshot_policy_member**](docs/RepositoryApi.md#delete_snapshot_policy_member) | **DELETE** /api/repository/v1/snapshots/{id}/policies/{policyName}/members/{memberEmail} | 
*RepositoryApi* | [**enumerate_datasets**](docs/RepositoryApi.md#enumerate_datasets) | **GET** /api/repository/v1/datasets | 
*RepositoryApi* | [**enumerate_jobs**](docs/RepositoryApi.md#enumerate_jobs) | **GET** /api/repository/v1/jobs | 
*RepositoryApi* | [**enumerate_snapshot_search**](docs/RepositoryApi.md#enumerate_snapshot_search) | **GET** /api/repository/v1/search/metadata | 
*RepositoryApi* | [**enumerate_snapshots**](docs/RepositoryApi.md#enumerate_snapshots) | **GET** /api/repository/v1/snapshots | 
*RepositoryApi* | [**enumerate_transactions**](docs/RepositoryApi.md#enumerate_transactions) | **GET** /api/repository/v1/datasets/{id}/transactions | 
*RepositoryApi* | [**export_snapshot**](docs/RepositoryApi.md#export_snapshot) | **GET** /api/repository/v1/snapshots/{id}/export | 
*RepositoryApi* | [**get_config**](docs/RepositoryApi.md#get_config) | **GET** /api/repository/v1/configs/{name} | 
*RepositoryApi* | [**get_config_list**](docs/RepositoryApi.md#get_config_list) | **GET** /api/repository/v1/configs | 
*RepositoryApi* | [**get_load_history_for_load_tag**](docs/RepositoryApi.md#get_load_history_for_load_tag) | **GET** /api/repository/v1/datasets/{id}/files/bulk/{loadTag} | 
*RepositoryApi* | [**ingest_dataset**](docs/RepositoryApi.md#ingest_dataset) | **POST** /api/repository/v1/datasets/{id}/ingest | 
*RepositoryApi* | [**ingest_file**](docs/RepositoryApi.md#ingest_file) | **POST** /api/repository/v1/datasets/{id}/files | 
*RepositoryApi* | [**lookup_file_by_id**](docs/RepositoryApi.md#lookup_file_by_id) | **GET** /api/repository/v1/datasets/{id}/files/{fileid} | 
*RepositoryApi* | [**lookup_file_by_path**](docs/RepositoryApi.md#lookup_file_by_path) | **GET** /api/repository/v1/datasets/{id}/filesystem/objects | 
*RepositoryApi* | [**lookup_snapshot_file_by_id**](docs/RepositoryApi.md#lookup_snapshot_file_by_id) | **GET** /api/repository/v1/snapshots/{id}/files/{fileid} | 
*RepositoryApi* | [**lookup_snapshot_file_by_path**](docs/RepositoryApi.md#lookup_snapshot_file_by_path) | **GET** /api/repository/v1/snapshots/{id}/filesystem/objects | 
*RepositoryApi* | [**lookup_snapshot_preview_by_id**](docs/RepositoryApi.md#lookup_snapshot_preview_by_id) | **GET** /api/repository/v1/snapshots/{id}/data/{table} | 
*RepositoryApi* | [**open_transaction**](docs/RepositoryApi.md#open_transaction) | **POST** /api/repository/v1/datasets/{id}/transactions | 
*RepositoryApi* | [**query_search_indices**](docs/RepositoryApi.md#query_search_indices) | **POST** /api/repository/v1/search/query | 
*RepositoryApi* | [**remove_dataset_asset_specifications**](docs/RepositoryApi.md#remove_dataset_asset_specifications) | **DELETE** /api/repository/v1/datasets/{id}/assets/{assetid} | 
*RepositoryApi* | [**reset_config**](docs/RepositoryApi.md#reset_config) | **PUT** /api/repository/v1/configs/reset | 
*RepositoryApi* | [**retrieve_dataset**](docs/RepositoryApi.md#retrieve_dataset) | **GET** /api/repository/v1/datasets/{id} | 
*RepositoryApi* | [**retrieve_dataset_policies**](docs/RepositoryApi.md#retrieve_dataset_policies) | **GET** /api/repository/v1/datasets/{id}/policies | 
*RepositoryApi* | [**retrieve_job**](docs/RepositoryApi.md#retrieve_job) | **GET** /api/repository/v1/jobs/{id} | 
*RepositoryApi* | [**retrieve_job_result**](docs/RepositoryApi.md#retrieve_job_result) | **GET** /api/repository/v1/jobs/{id}/result | 
*RepositoryApi* | [**retrieve_snapshot**](docs/RepositoryApi.md#retrieve_snapshot) | **GET** /api/repository/v1/snapshots/{id} | 
*RepositoryApi* | [**retrieve_snapshot_policies**](docs/RepositoryApi.md#retrieve_snapshot_policies) | **GET** /api/repository/v1/snapshots/{id}/policies | 
*RepositoryApi* | [**retrieve_transaction**](docs/RepositoryApi.md#retrieve_transaction) | **GET** /api/repository/v1/datasets/{id}/transactions/{transactionId} | 
*RepositoryApi* | [**retrieve_user_dataset_roles**](docs/RepositoryApi.md#retrieve_user_dataset_roles) | **GET** /api/repository/v1/datasets/{id}/roles | 
*RepositoryApi* | [**retrieve_user_snapshot_roles**](docs/RepositoryApi.md#retrieve_user_snapshot_roles) | **GET** /api/repository/v1/snapshots/{id}/roles | 
*RepositoryApi* | [**set_config_list**](docs/RepositoryApi.md#set_config_list) | **PUT** /api/repository/v1/configs | 
*RepositoryApi* | [**set_fault**](docs/RepositoryApi.md#set_fault) | **PUT** /api/repository/v1/configs/{name} | 
*RepositoryApi* | [**upgrade**](docs/RepositoryApi.md#upgrade) | **POST** /api/repository/v1/upgrade | 
*RepositoryApi* | [**upsert_search_metadata**](docs/RepositoryApi.md#upsert_search_metadata) | **PUT** /api/repository/v1/search/{id}/metadata | 
*RepositoryApi* | [**user**](docs/RepositoryApi.md#user) | **GET** /api/repository/v1/register/user | 
*ResourcesApi* | [**add_profile_policy_member**](docs/ResourcesApi.md#add_profile_policy_member) | **POST** /api/resources/v1/profiles/{id}/policies/{policyName}/members | 
*ResourcesApi* | [**create_profile**](docs/ResourcesApi.md#create_profile) | **POST** /api/resources/v1/profiles | 
*ResourcesApi* | [**delete_profile**](docs/ResourcesApi.md#delete_profile) | **DELETE** /api/resources/v1/profiles/{id} | 
*ResourcesApi* | [**delete_profile_policy_member**](docs/ResourcesApi.md#delete_profile_policy_member) | **DELETE** /api/resources/v1/profiles/{id}/policies/{policyName}/members/{memberEmail} | 
*ResourcesApi* | [**enumerate_profiles**](docs/ResourcesApi.md#enumerate_profiles) | **GET** /api/resources/v1/profiles | 
*ResourcesApi* | [**retrieve_profile**](docs/ResourcesApi.md#retrieve_profile) | **GET** /api/resources/v1/profiles/{id} | 
*ResourcesApi* | [**retrieve_profile_policies**](docs/ResourcesApi.md#retrieve_profile_policies) | **GET** /api/resources/v1/profiles/{id}/policies | 
*ResourcesApi* | [**update_profile**](docs/ResourcesApi.md#update_profile) | **PUT** /api/resources/v1/profiles | 
*SearchApi* | [**create_search_index**](docs/SearchApi.md#create_search_index) | **POST** /api/repository/v1/search/{id}/index | 
*SearchApi* | [**delete_search_metadata**](docs/SearchApi.md#delete_search_metadata) | **DELETE** /api/repository/v1/search/{id}/metadata | 
*SearchApi* | [**enumerate_snapshot_search**](docs/SearchApi.md#enumerate_snapshot_search) | **GET** /api/repository/v1/search/metadata | 
*SearchApi* | [**lookup_snapshot_preview_by_id**](docs/SearchApi.md#lookup_snapshot_preview_by_id) | **GET** /api/repository/v1/snapshots/{id}/data/{table} | 
*SearchApi* | [**query_search_indices**](docs/SearchApi.md#query_search_indices) | **POST** /api/repository/v1/search/query | 
*SearchApi* | [**upsert_search_metadata**](docs/SearchApi.md#upsert_search_metadata) | **PUT** /api/repository/v1/search/{id}/metadata | 
*SnapshotsApi* | [**add_snapshot_policy_member**](docs/SnapshotsApi.md#add_snapshot_policy_member) | **POST** /api/repository/v1/snapshots/{id}/policies/{policyName}/members | 
*SnapshotsApi* | [**create_search_index**](docs/SnapshotsApi.md#create_search_index) | **POST** /api/repository/v1/search/{id}/index | 
*SnapshotsApi* | [**create_snapshot**](docs/SnapshotsApi.md#create_snapshot) | **POST** /api/repository/v1/snapshots | 
*SnapshotsApi* | [**delete_search_metadata**](docs/SnapshotsApi.md#delete_search_metadata) | **DELETE** /api/repository/v1/search/{id}/metadata | 
*SnapshotsApi* | [**delete_snapshot**](docs/SnapshotsApi.md#delete_snapshot) | **DELETE** /api/repository/v1/snapshots/{id} | 
*SnapshotsApi* | [**delete_snapshot_policy_member**](docs/SnapshotsApi.md#delete_snapshot_policy_member) | **DELETE** /api/repository/v1/snapshots/{id}/policies/{policyName}/members/{memberEmail} | 
*SnapshotsApi* | [**enumerate_snapshot_search**](docs/SnapshotsApi.md#enumerate_snapshot_search) | **GET** /api/repository/v1/search/metadata | 
*SnapshotsApi* | [**enumerate_snapshots**](docs/SnapshotsApi.md#enumerate_snapshots) | **GET** /api/repository/v1/snapshots | 
*SnapshotsApi* | [**export_snapshot**](docs/SnapshotsApi.md#export_snapshot) | **GET** /api/repository/v1/snapshots/{id}/export | 
*SnapshotsApi* | [**lookup_snapshot_file_by_id**](docs/SnapshotsApi.md#lookup_snapshot_file_by_id) | **GET** /api/repository/v1/snapshots/{id}/files/{fileid} | 
*SnapshotsApi* | [**lookup_snapshot_file_by_path**](docs/SnapshotsApi.md#lookup_snapshot_file_by_path) | **GET** /api/repository/v1/snapshots/{id}/filesystem/objects | 
*SnapshotsApi* | [**lookup_snapshot_preview_by_id**](docs/SnapshotsApi.md#lookup_snapshot_preview_by_id) | **GET** /api/repository/v1/snapshots/{id}/data/{table} | 
*SnapshotsApi* | [**query_search_indices**](docs/SnapshotsApi.md#query_search_indices) | **POST** /api/repository/v1/search/query | 
*SnapshotsApi* | [**retrieve_snapshot**](docs/SnapshotsApi.md#retrieve_snapshot) | **GET** /api/repository/v1/snapshots/{id} | 
*SnapshotsApi* | [**retrieve_snapshot_policies**](docs/SnapshotsApi.md#retrieve_snapshot_policies) | **GET** /api/repository/v1/snapshots/{id}/policies | 
*SnapshotsApi* | [**retrieve_user_snapshot_roles**](docs/SnapshotsApi.md#retrieve_user_snapshot_roles) | **GET** /api/repository/v1/snapshots/{id}/roles | 
*SnapshotsApi* | [**upsert_search_metadata**](docs/SnapshotsApi.md#upsert_search_metadata) | **PUT** /api/repository/v1/search/{id}/metadata | 
*UnauthenticatedApi* | [**retrieve_repository_config**](docs/UnauthenticatedApi.md#retrieve_repository_config) | **GET** /configuration | 
*UnauthenticatedApi* | [**service_status**](docs/UnauthenticatedApi.md#service_status) | **GET** /status | 
*UnauthenticatedApi* | [**shutdown_request**](docs/UnauthenticatedApi.md#shutdown_request) | **GET** /shutdown | 
*UpgradeApi* | [**upgrade**](docs/UpgradeApi.md#upgrade) | **POST** /api/repository/v1/upgrade | 


## Documentation For Models

 - [AccessInfoBigQueryModel](docs/AccessInfoBigQueryModel.md)
 - [AccessInfoBigQueryModelTable](docs/AccessInfoBigQueryModelTable.md)
 - [AccessInfoModel](docs/AccessInfoModel.md)
 - [AccessInfoParquetModel](docs/AccessInfoParquetModel.md)
 - [AccessInfoParquetModelTable](docs/AccessInfoParquetModelTable.md)
 - [AssetModel](docs/AssetModel.md)
 - [AssetTableModel](docs/AssetTableModel.md)
 - [BillingProfileModel](docs/BillingProfileModel.md)
 - [BillingProfileRequestModel](docs/BillingProfileRequestModel.md)
 - [BillingProfileUpdateModel](docs/BillingProfileUpdateModel.md)
 - [BulkLoadArrayRequestModel](docs/BulkLoadArrayRequestModel.md)
 - [BulkLoadArrayResultModel](docs/BulkLoadArrayResultModel.md)
 - [BulkLoadFileModel](docs/BulkLoadFileModel.md)
 - [BulkLoadFileResultModel](docs/BulkLoadFileResultModel.md)
 - [BulkLoadFileState](docs/BulkLoadFileState.md)
 - [BulkLoadHistoryModel](docs/BulkLoadHistoryModel.md)
 - [BulkLoadHistoryModelList](docs/BulkLoadHistoryModelList.md)
 - [BulkLoadRequestModel](docs/BulkLoadRequestModel.md)
 - [BulkLoadResultModel](docs/BulkLoadResultModel.md)
 - [CloudPlatform](docs/CloudPlatform.md)
 - [ColumnModel](docs/ColumnModel.md)
 - [ConfigEnableModel](docs/ConfigEnableModel.md)
 - [ConfigFaultCountedModel](docs/ConfigFaultCountedModel.md)
 - [ConfigFaultModel](docs/ConfigFaultModel.md)
 - [ConfigGroupModel](docs/ConfigGroupModel.md)
 - [ConfigListModel](docs/ConfigListModel.md)
 - [ConfigModel](docs/ConfigModel.md)
 - [ConfigParameterModel](docs/ConfigParameterModel.md)
 - [DRSAccessMethod](docs/DRSAccessMethod.md)
 - [DRSAccessURL](docs/DRSAccessURL.md)
 - [DRSChecksum](docs/DRSChecksum.md)
 - [DRSContentsObject](docs/DRSContentsObject.md)
 - [DRSError](docs/DRSError.md)
 - [DRSObject](docs/DRSObject.md)
 - [DRSServiceInfo](docs/DRSServiceInfo.md)
 - [DataDeletionGcsFileModel](docs/DataDeletionGcsFileModel.md)
 - [DataDeletionJsonArrayModel](docs/DataDeletionJsonArrayModel.md)
 - [DataDeletionRequest](docs/DataDeletionRequest.md)
 - [DataDeletionTableModel](docs/DataDeletionTableModel.md)
 - [DatasetModel](docs/DatasetModel.md)
 - [DatasetRequestAccessIncludeModel](docs/DatasetRequestAccessIncludeModel.md)
 - [DatasetRequestModel](docs/DatasetRequestModel.md)
 - [DatasetSpecificationModel](docs/DatasetSpecificationModel.md)
 - [DatasetSummaryModel](docs/DatasetSummaryModel.md)
 - [DatePartitionOptionsModel](docs/DatePartitionOptionsModel.md)
 - [DeleteResponseModel](docs/DeleteResponseModel.md)
 - [DirectoryDetailModel](docs/DirectoryDetailModel.md)
 - [EnumerateBillingProfileModel](docs/EnumerateBillingProfileModel.md)
 - [EnumerateDatasetModel](docs/EnumerateDatasetModel.md)
 - [EnumerateSnapshotModel](docs/EnumerateSnapshotModel.md)
 - [EnumerateSortByParam](docs/EnumerateSortByParam.md)
 - [ErrorModel](docs/ErrorModel.md)
 - [FileDetailModel](docs/FileDetailModel.md)
 - [FileLoadModel](docs/FileLoadModel.md)
 - [FileModel](docs/FileModel.md)
 - [FileModelType](docs/FileModelType.md)
 - [IngestRequestModel](docs/IngestRequestModel.md)
 - [IngestResponseModel](docs/IngestResponseModel.md)
 - [IntPartitionOptionsModel](docs/IntPartitionOptionsModel.md)
 - [JobModel](docs/JobModel.md)
 - [PolicyMemberRequest](docs/PolicyMemberRequest.md)
 - [PolicyModel](docs/PolicyModel.md)
 - [PolicyResponse](docs/PolicyResponse.md)
 - [RelationshipModel](docs/RelationshipModel.md)
 - [RelationshipTermModel](docs/RelationshipTermModel.md)
 - [RepositoryConfigurationModel](docs/RepositoryConfigurationModel.md)
 - [RepositoryStatusModel](docs/RepositoryStatusModel.md)
 - [RepositoryStatusModelSystems](docs/RepositoryStatusModelSystems.md)
 - [SearchIndexModel](docs/SearchIndexModel.md)
 - [SearchIndexRequest](docs/SearchIndexRequest.md)
 - [SearchMetadataModel](docs/SearchMetadataModel.md)
 - [SearchMetadataResponse](docs/SearchMetadataResponse.md)
 - [SearchQueryRequest](docs/SearchQueryRequest.md)
 - [SearchQueryResultModel](docs/SearchQueryResultModel.md)
 - [SnapshotExportResponseModel](docs/SnapshotExportResponseModel.md)
 - [SnapshotExportResponseModelFormat](docs/SnapshotExportResponseModelFormat.md)
 - [SnapshotExportResponseModelFormatParquet](docs/SnapshotExportResponseModelFormatParquet.md)
 - [SnapshotExportResponseModelFormatParquetLocation](docs/SnapshotExportResponseModelFormatParquetLocation.md)
 - [SnapshotExportResponseModelFormatParquetLocationTables](docs/SnapshotExportResponseModelFormatParquetLocationTables.md)
 - [SnapshotExportResponseModelFormatWorkspace](docs/SnapshotExportResponseModelFormatWorkspace.md)
 - [SnapshotModel](docs/SnapshotModel.md)
 - [SnapshotPreviewModel](docs/SnapshotPreviewModel.md)
 - [SnapshotRequestAssetModel](docs/SnapshotRequestAssetModel.md)
 - [SnapshotRequestContentsModel](docs/SnapshotRequestContentsModel.md)
 - [SnapshotRequestModel](docs/SnapshotRequestModel.md)
 - [SnapshotRequestQueryModel](docs/SnapshotRequestQueryModel.md)
 - [SnapshotRequestRowIdModel](docs/SnapshotRequestRowIdModel.md)
 - [SnapshotRequestRowIdTableModel](docs/SnapshotRequestRowIdTableModel.md)
 - [SnapshotRetrieveIncludeModel](docs/SnapshotRetrieveIncludeModel.md)
 - [SnapshotSourceModel](docs/SnapshotSourceModel.md)
 - [SnapshotSummaryModel](docs/SnapshotSummaryModel.md)
 - [SqlSortDirection](docs/SqlSortDirection.md)
 - [StorageResourceModel](docs/StorageResourceModel.md)
 - [TableDataType](docs/TableDataType.md)
 - [TableModel](docs/TableModel.md)
 - [TransactionCloseModel](docs/TransactionCloseModel.md)
 - [TransactionCreateModel](docs/TransactionCreateModel.md)
 - [TransactionModel](docs/TransactionModel.md)
 - [UpgradeModel](docs/UpgradeModel.md)
 - [UpgradeResponseModel](docs/UpgradeResponseModel.md)
 - [UserStatusInfo](docs/UserStatusInfo.md)


## Documentation For Authorization


## googleoauth

- **Type**: OAuth
- **Flow**: implicit
- **Authorization URL**: https://accounts.google.com/o/oauth2/auth
- **Scopes**: 
 - **openid**: open id authorization
 - **email**: email authorization
 - **profile**: profile authorization
 - **https://www.googleapis.com/auth/cloud-billing.readonly**: cloud billing authorization


## Author




