<a id="types-aioboto3-lite"></a>

# types-aioboto3-lite

[![PyPI - types-aioboto3-lite](https://img.shields.io/pypi/v/types-aioboto3-lite.svg?color=blue)](https://pypi.org/project/types-aioboto3-lite)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/types-aioboto3-lite.svg?color=blue)](https://pypi.org/project/types-aioboto3-lite)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/types-aioboto3-lite?color=blue)](https://pypistats.org/packages/types-aioboto3-lite)

![boto3.typed](https://github.com/youtype/mypy_boto3_builder/raw/main/logo.png)

Type annotations for [aioboto3 11.0.1](https://pypi.org/project/aioboto3/)
compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 7.12.5](https://github.com/youtype/mypy_boto3_builder).

More information can be found in
[types-aioboto3-lite docs](https://youtype.github.io/types_aioboto3_docs/).

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/youtype/mypy_boto3_builder/raw/main/demo.gif)

- [types-aioboto3-lite](#types-aioboto3-lite)
  - [How to install](#how-to-install)
    - [From PyPI with pip](#from-pypi-with-pip)
  - [How to uninstall](#how-to-uninstall)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Emacs](#emacs)
    - [Sublime Text](#sublime-text)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [How it works](#how-it-works)
  - [What's new](#what's-new)
    - [Implemented features](#implemented-features)
    - [Latest changes](#latest-changes)
  - [Versioning](#versioning)
  - [Thank you](#thank-you)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)
  - [Submodules](#submodules)

<a id="how-to-install"></a>

## How to install

<a id="from-pypi-with-pip"></a>

### From PyPI with pip

Install `types-aioboto3-lite` to add type annotations for `aioboto3` package.

```bash
# install type annotations only for aioboto3
python -m pip install types-aioboto3-lite

# install aioboto3 type annotations
# for ec2, s3, rds, lambda, sqs, dynamo and cloudformation
python -m pip install 'types-aioboto3-lite[essential]'

# or install annotations for services you use
python -m pip install 'types-aioboto3-lite[acm,apigateway]'

# or install annotations in sync with aioboto3 version
python -m pip install 'types-aioboto3-lite[aioboto3]'


```

<a id="how-to-uninstall"></a>

## How to uninstall

```bash
# uninstall types-aioboto3-lite
python -m pip uninstall -y types-aioboto3-lite
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `types-aioboto3-lite[essential]` in your environment:

```bash
python -m pip install 'types-aioboto3-lite[essential]'
```

Both type checking and code completion should now work. No explicit type
annotations required, write your `aioboto3` code as usual.

<a id="pycharm"></a>

### PyCharm

Install `types-aioboto3-lite[essential]` in your environment:

```bash
python -m pip install 'types-aioboto3-lite[essential]'`
```

Both type checking and code completion should now work. Explicit type
annotations **are required**.

<a id="emacs"></a>

### Emacs

- Install `types-aioboto3-lite` with services you use in your environment:

```bash
python -m pip install 'types-aioboto3-lite[essential]'
```

- Install [use-package](https://github.com/jwiegley/use-package),
  [lsp](https://github.com/emacs-lsp/lsp-mode/),
  [company](https://github.com/company-mode/company-mode) and
  [flycheck](https://github.com/flycheck/flycheck) packages
- Install [lsp-pyright](https://github.com/emacs-lsp/lsp-pyright) package

```elisp
(use-package lsp-pyright
  :ensure t
  :hook (python-mode . (lambda ()
                          (require 'lsp-pyright)
                          (lsp)))  ; or lsp-deferred
  :init (when (executable-find "python3")
          (setq lsp-pyright-python-executable-cmd "python3"))
  )
```

- Make sure emacs uses the environment where you have installed
  `types-aioboto3-lite`

Type checking should now work. No explicit type annotations required, write
your `aioboto3` code as usual.

<a id="sublime-text"></a>

### Sublime Text

- Install `types-aioboto3-lite[essential]` with services you use in your
  environment:

```bash
python -m pip install 'types-aioboto3-lite[essential]'
```

- Install [LSP-pyright](https://github.com/sublimelsp/LSP-pyright) package

Type checking should now work. No explicit type annotations required, write
your `aioboto3` code as usual.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `types-aioboto3-lite[essential]` in your environment:

```bash
python -m pip install 'types-aioboto3-lite[essential]'`
```

Type checking should now work. No explicit type annotations required, write
your `aioboto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `npm i -g pyright`
- Install `types-aioboto3-lite[essential]` in your environment:

```bash
python -m pip install 'types-aioboto3-lite[essential]'
```

Optionally, you can install `types-aioboto3-lite` to `typings` folder.

Type checking should now work. No explicit type annotations required, write
your `aioboto3` code as usual.

<a id="how-it-works"></a>

## How it works

Fully automated
[mypy-boto3-builder](https://github.com/youtype/mypy_boto3_builder) carefully
generates type annotations for each service, patiently waiting for `aioboto3`
updates. It delivers a drop-in type annotations for you and makes sure that:

- All available `aioboto3` services are covered.
- Each public class and method of every `aioboto3` service gets valid type
  annotations extracted from the documentation (blame `botocore` docs if types
  are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) and
  [isort](https://github.com/PyCQA/isort) for readability.

<a id="what's-new"></a>

## What's new

<a id="implemented-features"></a>

### Implemented features

- Fully type annotated `boto3`, `botocore` and `aiobotocore` libraries
- `mypy`, `pyright`, `VSCode`, `PyCharm`, `Sublime Text` and `Emacs`
  compatibility
- `Client`, `ServiceResource`, `Resource`, `Waiter` `Paginator` type
  annotations for each service
- Generated `TypeDefs` for each service
- Generated `Literals` for each service
- Auto discovery of types for `boto3.client` and `boto3.session` calls
- Auto discovery of types for `session.client` and `session.session` calls
- Auto discovery of types for `client.get_waiter` and `client.get_paginator`
  calls
- Auto discovery of types for `ServiceResource` and `Resource` collections
- Auto discovery of types for `aiobotocore.Session.create_client` calls

<a id="latest-changes"></a>

### Latest changes

Builder changelog can be found in
[Releases](https://github.com/youtype/mypy_boto3_builder/releases).

<a id="versioning"></a>

## Versioning

`types-aioboto3-lite` version is the same as related `aioboto3` version and
follows [PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="thank-you"></a>

## Thank you

- [Allie Fitter](https://github.com/alliefitter) for
  [boto3-type-annotations](https://pypi.org/project/boto3-type-annotations/),
  this package is based on top of his work
- [black](https://github.com/psf/black) developers for an awesome formatting
  tool
- [Timothy Edmund Crosley](https://github.com/timothycrosley) for
  [isort](https://github.com/PyCQA/isort) and how flexible it is
- [mypy](https://github.com/python/mypy) developers for doing all dirty work
  for us
- [pyright](https://github.com/microsoft/pyright) team for the new era of typed
  Python

<a id="documentation"></a>

## Documentation

All services type annotations can be found in
[aioboto3 docs](https://youtype.github.io/types_aioboto3_docs/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/youtype/mypy_boto3_builder/issues/)
repository.

<a id="submodules"></a>

## Submodules

- `types-aioboto3-lite[all]` - Type annotations for all 314 services.
- `types-aioboto3-lite[essential]` - Type annotations for
  [CloudFormation](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_cloudformation/),
  [DynamoDB](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_dynamodb/),
  [EC2](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_ec2/),
  [Lambda](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_lambda/),
  [RDS](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_rds/),
  [S3](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_s3/) and
  [SQS](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_sqs/)
  services.
- `types-aioboto3-lite[aioboto3]` - Install annotations in sync with `aioboto3`
  version.
- `types-aioboto3-lite[accessanalyzer]` - Type annotations for
  [AccessAnalyzer](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_accessanalyzer/)
  service.
- `types-aioboto3-lite[account]` - Type annotations for
  [Account](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_account/)
  service.
- `types-aioboto3-lite[acm]` - Type annotations for
  [ACM](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_acm/)
  service.
- `types-aioboto3-lite[acm-pca]` - Type annotations for
  [ACMPCA](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_acm_pca/)
  service.
- `types-aioboto3-lite[alexaforbusiness]` - Type annotations for
  [AlexaForBusiness](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_alexaforbusiness/)
  service.
- `types-aioboto3-lite[amp]` - Type annotations for
  [PrometheusService](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_amp/)
  service.
- `types-aioboto3-lite[amplify]` - Type annotations for
  [Amplify](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_amplify/)
  service.
- `types-aioboto3-lite[amplifybackend]` - Type annotations for
  [AmplifyBackend](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_amplifybackend/)
  service.
- `types-aioboto3-lite[amplifyuibuilder]` - Type annotations for
  [AmplifyUIBuilder](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_amplifyuibuilder/)
  service.
- `types-aioboto3-lite[apigateway]` - Type annotations for
  [APIGateway](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_apigateway/)
  service.
- `types-aioboto3-lite[apigatewaymanagementapi]` - Type annotations for
  [ApiGatewayManagementApi](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_apigatewaymanagementapi/)
  service.
- `types-aioboto3-lite[apigatewayv2]` - Type annotations for
  [ApiGatewayV2](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_apigatewayv2/)
  service.
- `types-aioboto3-lite[appconfig]` - Type annotations for
  [AppConfig](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_appconfig/)
  service.
- `types-aioboto3-lite[appconfigdata]` - Type annotations for
  [AppConfigData](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_appconfigdata/)
  service.
- `types-aioboto3-lite[appflow]` - Type annotations for
  [Appflow](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_appflow/)
  service.
- `types-aioboto3-lite[appintegrations]` - Type annotations for
  [AppIntegrationsService](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_appintegrations/)
  service.
- `types-aioboto3-lite[application-autoscaling]` - Type annotations for
  [ApplicationAutoScaling](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_application_autoscaling/)
  service.
- `types-aioboto3-lite[application-insights]` - Type annotations for
  [ApplicationInsights](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_application_insights/)
  service.
- `types-aioboto3-lite[applicationcostprofiler]` - Type annotations for
  [ApplicationCostProfiler](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_applicationcostprofiler/)
  service.
- `types-aioboto3-lite[appmesh]` - Type annotations for
  [AppMesh](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_appmesh/)
  service.
- `types-aioboto3-lite[apprunner]` - Type annotations for
  [AppRunner](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_apprunner/)
  service.
- `types-aioboto3-lite[appstream]` - Type annotations for
  [AppStream](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_appstream/)
  service.
- `types-aioboto3-lite[appsync]` - Type annotations for
  [AppSync](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_appsync/)
  service.
- `types-aioboto3-lite[athena]` - Type annotations for
  [Athena](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_athena/)
  service.
- `types-aioboto3-lite[auditmanager]` - Type annotations for
  [AuditManager](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_auditmanager/)
  service.
- `types-aioboto3-lite[autoscaling]` - Type annotations for
  [AutoScaling](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_autoscaling/)
  service.
- `types-aioboto3-lite[autoscaling-plans]` - Type annotations for
  [AutoScalingPlans](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_autoscaling_plans/)
  service.
- `types-aioboto3-lite[backup]` - Type annotations for
  [Backup](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_backup/)
  service.
- `types-aioboto3-lite[backup-gateway]` - Type annotations for
  [BackupGateway](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_backup_gateway/)
  service.
- `types-aioboto3-lite[backupstorage]` - Type annotations for
  [BackupStorage](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_backupstorage/)
  service.
- `types-aioboto3-lite[batch]` - Type annotations for
  [Batch](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_batch/)
  service.
- `types-aioboto3-lite[billingconductor]` - Type annotations for
  [BillingConductor](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_billingconductor/)
  service.
- `types-aioboto3-lite[braket]` - Type annotations for
  [Braket](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_braket/)
  service.
- `types-aioboto3-lite[budgets]` - Type annotations for
  [Budgets](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_budgets/)
  service.
- `types-aioboto3-lite[ce]` - Type annotations for
  [CostExplorer](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_ce/)
  service.
- `types-aioboto3-lite[chime]` - Type annotations for
  [Chime](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_chime/)
  service.
- `types-aioboto3-lite[chime-sdk-identity]` - Type annotations for
  [ChimeSDKIdentity](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_chime_sdk_identity/)
  service.
- `types-aioboto3-lite[chime-sdk-media-pipelines]` - Type annotations for
  [ChimeSDKMediaPipelines](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_chime_sdk_media_pipelines/)
  service.
- `types-aioboto3-lite[chime-sdk-meetings]` - Type annotations for
  [ChimeSDKMeetings](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_chime_sdk_meetings/)
  service.
- `types-aioboto3-lite[chime-sdk-messaging]` - Type annotations for
  [ChimeSDKMessaging](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_chime_sdk_messaging/)
  service.
- `types-aioboto3-lite[cloud9]` - Type annotations for
  [Cloud9](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_cloud9/)
  service.
- `types-aioboto3-lite[cloudcontrol]` - Type annotations for
  [CloudControlApi](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_cloudcontrol/)
  service.
- `types-aioboto3-lite[clouddirectory]` - Type annotations for
  [CloudDirectory](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_clouddirectory/)
  service.
- `types-aioboto3-lite[cloudformation]` - Type annotations for
  [CloudFormation](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_cloudformation/)
  service.
- `types-aioboto3-lite[cloudfront]` - Type annotations for
  [CloudFront](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_cloudfront/)
  service.
- `types-aioboto3-lite[cloudhsm]` - Type annotations for
  [CloudHSM](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_cloudhsm/)
  service.
- `types-aioboto3-lite[cloudhsmv2]` - Type annotations for
  [CloudHSMV2](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_cloudhsmv2/)
  service.
- `types-aioboto3-lite[cloudsearch]` - Type annotations for
  [CloudSearch](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_cloudsearch/)
  service.
- `types-aioboto3-lite[cloudsearchdomain]` - Type annotations for
  [CloudSearchDomain](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_cloudsearchdomain/)
  service.
- `types-aioboto3-lite[cloudtrail]` - Type annotations for
  [CloudTrail](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_cloudtrail/)
  service.
- `types-aioboto3-lite[cloudwatch]` - Type annotations for
  [CloudWatch](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_cloudwatch/)
  service.
- `types-aioboto3-lite[codeartifact]` - Type annotations for
  [CodeArtifact](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_codeartifact/)
  service.
- `types-aioboto3-lite[codebuild]` - Type annotations for
  [CodeBuild](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_codebuild/)
  service.
- `types-aioboto3-lite[codecommit]` - Type annotations for
  [CodeCommit](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_codecommit/)
  service.
- `types-aioboto3-lite[codedeploy]` - Type annotations for
  [CodeDeploy](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_codedeploy/)
  service.
- `types-aioboto3-lite[codeguru-reviewer]` - Type annotations for
  [CodeGuruReviewer](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_codeguru_reviewer/)
  service.
- `types-aioboto3-lite[codeguruprofiler]` - Type annotations for
  [CodeGuruProfiler](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_codeguruprofiler/)
  service.
- `types-aioboto3-lite[codepipeline]` - Type annotations for
  [CodePipeline](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_codepipeline/)
  service.
- `types-aioboto3-lite[codestar]` - Type annotations for
  [CodeStar](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_codestar/)
  service.
- `types-aioboto3-lite[codestar-connections]` - Type annotations for
  [CodeStarconnections](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_codestar_connections/)
  service.
- `types-aioboto3-lite[codestar-notifications]` - Type annotations for
  [CodeStarNotifications](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_codestar_notifications/)
  service.
- `types-aioboto3-lite[cognito-identity]` - Type annotations for
  [CognitoIdentity](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_cognito_identity/)
  service.
- `types-aioboto3-lite[cognito-idp]` - Type annotations for
  [CognitoIdentityProvider](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_cognito_idp/)
  service.
- `types-aioboto3-lite[cognito-sync]` - Type annotations for
  [CognitoSync](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_cognito_sync/)
  service.
- `types-aioboto3-lite[comprehend]` - Type annotations for
  [Comprehend](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_comprehend/)
  service.
- `types-aioboto3-lite[comprehendmedical]` - Type annotations for
  [ComprehendMedical](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_comprehendmedical/)
  service.
- `types-aioboto3-lite[compute-optimizer]` - Type annotations for
  [ComputeOptimizer](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_compute_optimizer/)
  service.
- `types-aioboto3-lite[config]` - Type annotations for
  [ConfigService](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_config/)
  service.
- `types-aioboto3-lite[connect]` - Type annotations for
  [Connect](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_connect/)
  service.
- `types-aioboto3-lite[connect-contact-lens]` - Type annotations for
  [ConnectContactLens](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_connect_contact_lens/)
  service.
- `types-aioboto3-lite[connectcampaigns]` - Type annotations for
  [ConnectCampaignService](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_connectcampaigns/)
  service.
- `types-aioboto3-lite[connectparticipant]` - Type annotations for
  [ConnectParticipant](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_connectparticipant/)
  service.
- `types-aioboto3-lite[cur]` - Type annotations for
  [CostandUsageReportService](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_cur/)
  service.
- `types-aioboto3-lite[customer-profiles]` - Type annotations for
  [CustomerProfiles](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_customer_profiles/)
  service.
- `types-aioboto3-lite[databrew]` - Type annotations for
  [GlueDataBrew](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_databrew/)
  service.
- `types-aioboto3-lite[dataexchange]` - Type annotations for
  [DataExchange](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_dataexchange/)
  service.
- `types-aioboto3-lite[datapipeline]` - Type annotations for
  [DataPipeline](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_datapipeline/)
  service.
- `types-aioboto3-lite[datasync]` - Type annotations for
  [DataSync](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_datasync/)
  service.
- `types-aioboto3-lite[dax]` - Type annotations for
  [DAX](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_dax/)
  service.
- `types-aioboto3-lite[detective]` - Type annotations for
  [Detective](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_detective/)
  service.
- `types-aioboto3-lite[devicefarm]` - Type annotations for
  [DeviceFarm](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_devicefarm/)
  service.
- `types-aioboto3-lite[devops-guru]` - Type annotations for
  [DevOpsGuru](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_devops_guru/)
  service.
- `types-aioboto3-lite[directconnect]` - Type annotations for
  [DirectConnect](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_directconnect/)
  service.
- `types-aioboto3-lite[discovery]` - Type annotations for
  [ApplicationDiscoveryService](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_discovery/)
  service.
- `types-aioboto3-lite[dlm]` - Type annotations for
  [DLM](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_dlm/)
  service.
- `types-aioboto3-lite[dms]` - Type annotations for
  [DatabaseMigrationService](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_dms/)
  service.
- `types-aioboto3-lite[docdb]` - Type annotations for
  [DocDB](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_docdb/)
  service.
- `types-aioboto3-lite[drs]` - Type annotations for
  [drs](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_drs/)
  service.
- `types-aioboto3-lite[ds]` - Type annotations for
  [DirectoryService](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_ds/)
  service.
- `types-aioboto3-lite[dynamodb]` - Type annotations for
  [DynamoDB](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_dynamodb/)
  service.
- `types-aioboto3-lite[dynamodbstreams]` - Type annotations for
  [DynamoDBStreams](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_dynamodbstreams/)
  service.
- `types-aioboto3-lite[ebs]` - Type annotations for
  [EBS](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_ebs/)
  service.
- `types-aioboto3-lite[ec2]` - Type annotations for
  [EC2](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_ec2/)
  service.
- `types-aioboto3-lite[ec2-instance-connect]` - Type annotations for
  [EC2InstanceConnect](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_ec2_instance_connect/)
  service.
- `types-aioboto3-lite[ecr]` - Type annotations for
  [ECR](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_ecr/)
  service.
- `types-aioboto3-lite[ecr-public]` - Type annotations for
  [ECRPublic](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_ecr_public/)
  service.
- `types-aioboto3-lite[ecs]` - Type annotations for
  [ECS](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_ecs/)
  service.
- `types-aioboto3-lite[efs]` - Type annotations for
  [EFS](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_efs/)
  service.
- `types-aioboto3-lite[eks]` - Type annotations for
  [EKS](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_eks/)
  service.
- `types-aioboto3-lite[elastic-inference]` - Type annotations for
  [ElasticInference](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_elastic_inference/)
  service.
- `types-aioboto3-lite[elasticache]` - Type annotations for
  [ElastiCache](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_elasticache/)
  service.
- `types-aioboto3-lite[elasticbeanstalk]` - Type annotations for
  [ElasticBeanstalk](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_elasticbeanstalk/)
  service.
- `types-aioboto3-lite[elastictranscoder]` - Type annotations for
  [ElasticTranscoder](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_elastictranscoder/)
  service.
- `types-aioboto3-lite[elb]` - Type annotations for
  [ElasticLoadBalancing](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_elb/)
  service.
- `types-aioboto3-lite[elbv2]` - Type annotations for
  [ElasticLoadBalancingv2](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_elbv2/)
  service.
- `types-aioboto3-lite[emr]` - Type annotations for
  [EMR](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_emr/)
  service.
- `types-aioboto3-lite[emr-containers]` - Type annotations for
  [EMRContainers](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_emr_containers/)
  service.
- `types-aioboto3-lite[emr-serverless]` - Type annotations for
  [EMRServerless](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_emr_serverless/)
  service.
- `types-aioboto3-lite[es]` - Type annotations for
  [ElasticsearchService](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_es/)
  service.
- `types-aioboto3-lite[events]` - Type annotations for
  [EventBridge](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_events/)
  service.
- `types-aioboto3-lite[evidently]` - Type annotations for
  [CloudWatchEvidently](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_evidently/)
  service.
- `types-aioboto3-lite[finspace]` - Type annotations for
  [finspace](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_finspace/)
  service.
- `types-aioboto3-lite[finspace-data]` - Type annotations for
  [FinSpaceData](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_finspace_data/)
  service.
- `types-aioboto3-lite[firehose]` - Type annotations for
  [Firehose](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_firehose/)
  service.
- `types-aioboto3-lite[fis]` - Type annotations for
  [FIS](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_fis/)
  service.
- `types-aioboto3-lite[fms]` - Type annotations for
  [FMS](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_fms/)
  service.
- `types-aioboto3-lite[forecast]` - Type annotations for
  [ForecastService](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_forecast/)
  service.
- `types-aioboto3-lite[forecastquery]` - Type annotations for
  [ForecastQueryService](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_forecastquery/)
  service.
- `types-aioboto3-lite[frauddetector]` - Type annotations for
  [FraudDetector](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_frauddetector/)
  service.
- `types-aioboto3-lite[fsx]` - Type annotations for
  [FSx](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_fsx/)
  service.
- `types-aioboto3-lite[gamelift]` - Type annotations for
  [GameLift](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_gamelift/)
  service.
- `types-aioboto3-lite[gamesparks]` - Type annotations for
  [GameSparks](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_gamesparks/)
  service.
- `types-aioboto3-lite[glacier]` - Type annotations for
  [Glacier](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_glacier/)
  service.
- `types-aioboto3-lite[globalaccelerator]` - Type annotations for
  [GlobalAccelerator](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_globalaccelerator/)
  service.
- `types-aioboto3-lite[glue]` - Type annotations for
  [Glue](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_glue/)
  service.
- `types-aioboto3-lite[grafana]` - Type annotations for
  [ManagedGrafana](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_grafana/)
  service.
- `types-aioboto3-lite[greengrass]` - Type annotations for
  [Greengrass](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_greengrass/)
  service.
- `types-aioboto3-lite[greengrassv2]` - Type annotations for
  [GreengrassV2](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_greengrassv2/)
  service.
- `types-aioboto3-lite[groundstation]` - Type annotations for
  [GroundStation](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_groundstation/)
  service.
- `types-aioboto3-lite[guardduty]` - Type annotations for
  [GuardDuty](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_guardduty/)
  service.
- `types-aioboto3-lite[health]` - Type annotations for
  [Health](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_health/)
  service.
- `types-aioboto3-lite[healthlake]` - Type annotations for
  [HealthLake](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_healthlake/)
  service.
- `types-aioboto3-lite[honeycode]` - Type annotations for
  [Honeycode](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_honeycode/)
  service.
- `types-aioboto3-lite[iam]` - Type annotations for
  [IAM](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_iam/)
  service.
- `types-aioboto3-lite[identitystore]` - Type annotations for
  [IdentityStore](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_identitystore/)
  service.
- `types-aioboto3-lite[imagebuilder]` - Type annotations for
  [imagebuilder](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_imagebuilder/)
  service.
- `types-aioboto3-lite[importexport]` - Type annotations for
  [ImportExport](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_importexport/)
  service.
- `types-aioboto3-lite[inspector]` - Type annotations for
  [Inspector](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_inspector/)
  service.
- `types-aioboto3-lite[inspector2]` - Type annotations for
  [Inspector2](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_inspector2/)
  service.
- `types-aioboto3-lite[iot]` - Type annotations for
  [IoT](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_iot/)
  service.
- `types-aioboto3-lite[iot-data]` - Type annotations for
  [IoTDataPlane](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_iot_data/)
  service.
- `types-aioboto3-lite[iot-jobs-data]` - Type annotations for
  [IoTJobsDataPlane](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_iot_jobs_data/)
  service.
- `types-aioboto3-lite[iot1click-devices]` - Type annotations for
  [IoT1ClickDevicesService](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_iot1click_devices/)
  service.
- `types-aioboto3-lite[iot1click-projects]` - Type annotations for
  [IoT1ClickProjects](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_iot1click_projects/)
  service.
- `types-aioboto3-lite[iotanalytics]` - Type annotations for
  [IoTAnalytics](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_iotanalytics/)
  service.
- `types-aioboto3-lite[iotdeviceadvisor]` - Type annotations for
  [IoTDeviceAdvisor](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_iotdeviceadvisor/)
  service.
- `types-aioboto3-lite[iotevents]` - Type annotations for
  [IoTEvents](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_iotevents/)
  service.
- `types-aioboto3-lite[iotevents-data]` - Type annotations for
  [IoTEventsData](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_iotevents_data/)
  service.
- `types-aioboto3-lite[iotfleethub]` - Type annotations for
  [IoTFleetHub](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_iotfleethub/)
  service.
- `types-aioboto3-lite[iotsecuretunneling]` - Type annotations for
  [IoTSecureTunneling](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_iotsecuretunneling/)
  service.
- `types-aioboto3-lite[iotsitewise]` - Type annotations for
  [IoTSiteWise](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_iotsitewise/)
  service.
- `types-aioboto3-lite[iotthingsgraph]` - Type annotations for
  [IoTThingsGraph](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_iotthingsgraph/)
  service.
- `types-aioboto3-lite[iottwinmaker]` - Type annotations for
  [IoTTwinMaker](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_iottwinmaker/)
  service.
- `types-aioboto3-lite[iotwireless]` - Type annotations for
  [IoTWireless](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_iotwireless/)
  service.
- `types-aioboto3-lite[ivs]` - Type annotations for
  [IVS](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_ivs/)
  service.
- `types-aioboto3-lite[ivschat]` - Type annotations for
  [ivschat](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_ivschat/)
  service.
- `types-aioboto3-lite[kafka]` - Type annotations for
  [Kafka](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_kafka/)
  service.
- `types-aioboto3-lite[kafkaconnect]` - Type annotations for
  [KafkaConnect](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_kafkaconnect/)
  service.
- `types-aioboto3-lite[kendra]` - Type annotations for
  [kendra](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_kendra/)
  service.
- `types-aioboto3-lite[keyspaces]` - Type annotations for
  [Keyspaces](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_keyspaces/)
  service.
- `types-aioboto3-lite[kinesis]` - Type annotations for
  [Kinesis](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_kinesis/)
  service.
- `types-aioboto3-lite[kinesis-video-archived-media]` - Type annotations for
  [KinesisVideoArchivedMedia](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_kinesis_video_archived_media/)
  service.
- `types-aioboto3-lite[kinesis-video-media]` - Type annotations for
  [KinesisVideoMedia](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_kinesis_video_media/)
  service.
- `types-aioboto3-lite[kinesis-video-signaling]` - Type annotations for
  [KinesisVideoSignalingChannels](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_kinesis_video_signaling/)
  service.
- `types-aioboto3-lite[kinesisanalytics]` - Type annotations for
  [KinesisAnalytics](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_kinesisanalytics/)
  service.
- `types-aioboto3-lite[kinesisanalyticsv2]` - Type annotations for
  [KinesisAnalyticsV2](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_kinesisanalyticsv2/)
  service.
- `types-aioboto3-lite[kinesisvideo]` - Type annotations for
  [KinesisVideo](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_kinesisvideo/)
  service.
- `types-aioboto3-lite[kms]` - Type annotations for
  [KMS](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_kms/)
  service.
- `types-aioboto3-lite[lakeformation]` - Type annotations for
  [LakeFormation](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_lakeformation/)
  service.
- `types-aioboto3-lite[lambda]` - Type annotations for
  [Lambda](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_lambda/)
  service.
- `types-aioboto3-lite[lex-models]` - Type annotations for
  [LexModelBuildingService](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_lex_models/)
  service.
- `types-aioboto3-lite[lex-runtime]` - Type annotations for
  [LexRuntimeService](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_lex_runtime/)
  service.
- `types-aioboto3-lite[lexv2-models]` - Type annotations for
  [LexModelsV2](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_lexv2_models/)
  service.
- `types-aioboto3-lite[lexv2-runtime]` - Type annotations for
  [LexRuntimeV2](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_lexv2_runtime/)
  service.
- `types-aioboto3-lite[license-manager]` - Type annotations for
  [LicenseManager](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_license_manager/)
  service.
- `types-aioboto3-lite[license-manager-user-subscriptions]` - Type annotations
  for
  [LicenseManagerUserSubscriptions](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_license_manager_user_subscriptions/)
  service.
- `types-aioboto3-lite[lightsail]` - Type annotations for
  [Lightsail](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_lightsail/)
  service.
- `types-aioboto3-lite[location]` - Type annotations for
  [LocationService](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_location/)
  service.
- `types-aioboto3-lite[logs]` - Type annotations for
  [CloudWatchLogs](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_logs/)
  service.
- `types-aioboto3-lite[lookoutequipment]` - Type annotations for
  [LookoutEquipment](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_lookoutequipment/)
  service.
- `types-aioboto3-lite[lookoutmetrics]` - Type annotations for
  [LookoutMetrics](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_lookoutmetrics/)
  service.
- `types-aioboto3-lite[lookoutvision]` - Type annotations for
  [LookoutforVision](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_lookoutvision/)
  service.
- `types-aioboto3-lite[m2]` - Type annotations for
  [MainframeModernization](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_m2/)
  service.
- `types-aioboto3-lite[machinelearning]` - Type annotations for
  [MachineLearning](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_machinelearning/)
  service.
- `types-aioboto3-lite[macie]` - Type annotations for
  [Macie](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_macie/)
  service.
- `types-aioboto3-lite[macie2]` - Type annotations for
  [Macie2](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_macie2/)
  service.
- `types-aioboto3-lite[managedblockchain]` - Type annotations for
  [ManagedBlockchain](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_managedblockchain/)
  service.
- `types-aioboto3-lite[marketplace-catalog]` - Type annotations for
  [MarketplaceCatalog](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_marketplace_catalog/)
  service.
- `types-aioboto3-lite[marketplace-entitlement]` - Type annotations for
  [MarketplaceEntitlementService](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_marketplace_entitlement/)
  service.
- `types-aioboto3-lite[marketplacecommerceanalytics]` - Type annotations for
  [MarketplaceCommerceAnalytics](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_marketplacecommerceanalytics/)
  service.
- `types-aioboto3-lite[mediaconnect]` - Type annotations for
  [MediaConnect](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_mediaconnect/)
  service.
- `types-aioboto3-lite[mediaconvert]` - Type annotations for
  [MediaConvert](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_mediaconvert/)
  service.
- `types-aioboto3-lite[medialive]` - Type annotations for
  [MediaLive](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_medialive/)
  service.
- `types-aioboto3-lite[mediapackage]` - Type annotations for
  [MediaPackage](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_mediapackage/)
  service.
- `types-aioboto3-lite[mediapackage-vod]` - Type annotations for
  [MediaPackageVod](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_mediapackage_vod/)
  service.
- `types-aioboto3-lite[mediastore]` - Type annotations for
  [MediaStore](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_mediastore/)
  service.
- `types-aioboto3-lite[mediastore-data]` - Type annotations for
  [MediaStoreData](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_mediastore_data/)
  service.
- `types-aioboto3-lite[mediatailor]` - Type annotations for
  [MediaTailor](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_mediatailor/)
  service.
- `types-aioboto3-lite[memorydb]` - Type annotations for
  [MemoryDB](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_memorydb/)
  service.
- `types-aioboto3-lite[meteringmarketplace]` - Type annotations for
  [MarketplaceMetering](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_meteringmarketplace/)
  service.
- `types-aioboto3-lite[mgh]` - Type annotations for
  [MigrationHub](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_mgh/)
  service.
- `types-aioboto3-lite[mgn]` - Type annotations for
  [mgn](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_mgn/)
  service.
- `types-aioboto3-lite[migration-hub-refactor-spaces]` - Type annotations for
  [MigrationHubRefactorSpaces](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_migration_hub_refactor_spaces/)
  service.
- `types-aioboto3-lite[migrationhub-config]` - Type annotations for
  [MigrationHubConfig](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_migrationhub_config/)
  service.
- `types-aioboto3-lite[migrationhubstrategy]` - Type annotations for
  [MigrationHubStrategyRecommendations](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_migrationhubstrategy/)
  service.
- `types-aioboto3-lite[mobile]` - Type annotations for
  [Mobile](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_mobile/)
  service.
- `types-aioboto3-lite[mq]` - Type annotations for
  [MQ](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_mq/)
  service.
- `types-aioboto3-lite[mturk]` - Type annotations for
  [MTurk](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_mturk/)
  service.
- `types-aioboto3-lite[mwaa]` - Type annotations for
  [MWAA](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_mwaa/)
  service.
- `types-aioboto3-lite[neptune]` - Type annotations for
  [Neptune](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_neptune/)
  service.
- `types-aioboto3-lite[network-firewall]` - Type annotations for
  [NetworkFirewall](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_network_firewall/)
  service.
- `types-aioboto3-lite[networkmanager]` - Type annotations for
  [NetworkManager](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_networkmanager/)
  service.
- `types-aioboto3-lite[nimble]` - Type annotations for
  [NimbleStudio](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_nimble/)
  service.
- `types-aioboto3-lite[opensearch]` - Type annotations for
  [OpenSearchService](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_opensearch/)
  service.
- `types-aioboto3-lite[opsworks]` - Type annotations for
  [OpsWorks](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_opsworks/)
  service.
- `types-aioboto3-lite[opsworkscm]` - Type annotations for
  [OpsWorksCM](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_opsworkscm/)
  service.
- `types-aioboto3-lite[organizations]` - Type annotations for
  [Organizations](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_organizations/)
  service.
- `types-aioboto3-lite[outposts]` - Type annotations for
  [Outposts](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_outposts/)
  service.
- `types-aioboto3-lite[panorama]` - Type annotations for
  [Panorama](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_panorama/)
  service.
- `types-aioboto3-lite[personalize]` - Type annotations for
  [Personalize](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_personalize/)
  service.
- `types-aioboto3-lite[personalize-events]` - Type annotations for
  [PersonalizeEvents](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_personalize_events/)
  service.
- `types-aioboto3-lite[personalize-runtime]` - Type annotations for
  [PersonalizeRuntime](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_personalize_runtime/)
  service.
- `types-aioboto3-lite[pi]` - Type annotations for
  [PI](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_pi/)
  service.
- `types-aioboto3-lite[pinpoint]` - Type annotations for
  [Pinpoint](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_pinpoint/)
  service.
- `types-aioboto3-lite[pinpoint-email]` - Type annotations for
  [PinpointEmail](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_pinpoint_email/)
  service.
- `types-aioboto3-lite[pinpoint-sms-voice]` - Type annotations for
  [PinpointSMSVoice](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_pinpoint_sms_voice/)
  service.
- `types-aioboto3-lite[pinpoint-sms-voice-v2]` - Type annotations for
  [PinpointSMSVoiceV2](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_pinpoint_sms_voice_v2/)
  service.
- `types-aioboto3-lite[polly]` - Type annotations for
  [Polly](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_polly/)
  service.
- `types-aioboto3-lite[pricing]` - Type annotations for
  [Pricing](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_pricing/)
  service.
- `types-aioboto3-lite[privatenetworks]` - Type annotations for
  [Private5G](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_privatenetworks/)
  service.
- `types-aioboto3-lite[proton]` - Type annotations for
  [Proton](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_proton/)
  service.
- `types-aioboto3-lite[qldb]` - Type annotations for
  [QLDB](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_qldb/)
  service.
- `types-aioboto3-lite[qldb-session]` - Type annotations for
  [QLDBSession](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_qldb_session/)
  service.
- `types-aioboto3-lite[quicksight]` - Type annotations for
  [QuickSight](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_quicksight/)
  service.
- `types-aioboto3-lite[ram]` - Type annotations for
  [RAM](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_ram/)
  service.
- `types-aioboto3-lite[rbin]` - Type annotations for
  [RecycleBin](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_rbin/)
  service.
- `types-aioboto3-lite[rds]` - Type annotations for
  [RDS](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_rds/)
  service.
- `types-aioboto3-lite[rds-data]` - Type annotations for
  [RDSDataService](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_rds_data/)
  service.
- `types-aioboto3-lite[redshift]` - Type annotations for
  [Redshift](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_redshift/)
  service.
- `types-aioboto3-lite[redshift-data]` - Type annotations for
  [RedshiftDataAPIService](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_redshift_data/)
  service.
- `types-aioboto3-lite[redshift-serverless]` - Type annotations for
  [RedshiftServerless](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_redshift_serverless/)
  service.
- `types-aioboto3-lite[rekognition]` - Type annotations for
  [Rekognition](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_rekognition/)
  service.
- `types-aioboto3-lite[resiliencehub]` - Type annotations for
  [ResilienceHub](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_resiliencehub/)
  service.
- `types-aioboto3-lite[resource-groups]` - Type annotations for
  [ResourceGroups](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_resource_groups/)
  service.
- `types-aioboto3-lite[resourcegroupstaggingapi]` - Type annotations for
  [ResourceGroupsTaggingAPI](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_resourcegroupstaggingapi/)
  service.
- `types-aioboto3-lite[robomaker]` - Type annotations for
  [RoboMaker](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_robomaker/)
  service.
- `types-aioboto3-lite[rolesanywhere]` - Type annotations for
  [IAMRolesAnywhere](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_rolesanywhere/)
  service.
- `types-aioboto3-lite[route53]` - Type annotations for
  [Route53](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_route53/)
  service.
- `types-aioboto3-lite[route53-recovery-cluster]` - Type annotations for
  [Route53RecoveryCluster](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_route53_recovery_cluster/)
  service.
- `types-aioboto3-lite[route53-recovery-control-config]` - Type annotations for
  [Route53RecoveryControlConfig](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_route53_recovery_control_config/)
  service.
- `types-aioboto3-lite[route53-recovery-readiness]` - Type annotations for
  [Route53RecoveryReadiness](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_route53_recovery_readiness/)
  service.
- `types-aioboto3-lite[route53domains]` - Type annotations for
  [Route53Domains](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_route53domains/)
  service.
- `types-aioboto3-lite[route53resolver]` - Type annotations for
  [Route53Resolver](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_route53resolver/)
  service.
- `types-aioboto3-lite[rum]` - Type annotations for
  [CloudWatchRUM](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_rum/)
  service.
- `types-aioboto3-lite[s3]` - Type annotations for
  [S3](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_s3/)
  service.
- `types-aioboto3-lite[s3control]` - Type annotations for
  [S3Control](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_s3control/)
  service.
- `types-aioboto3-lite[s3outposts]` - Type annotations for
  [S3Outposts](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_s3outposts/)
  service.
- `types-aioboto3-lite[sagemaker]` - Type annotations for
  [SageMaker](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_sagemaker/)
  service.
- `types-aioboto3-lite[sagemaker-a2i-runtime]` - Type annotations for
  [AugmentedAIRuntime](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_sagemaker_a2i_runtime/)
  service.
- `types-aioboto3-lite[sagemaker-edge]` - Type annotations for
  [SagemakerEdgeManager](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_sagemaker_edge/)
  service.
- `types-aioboto3-lite[sagemaker-featurestore-runtime]` - Type annotations for
  [SageMakerFeatureStoreRuntime](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_sagemaker_featurestore_runtime/)
  service.
- `types-aioboto3-lite[sagemaker-runtime]` - Type annotations for
  [SageMakerRuntime](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_sagemaker_runtime/)
  service.
- `types-aioboto3-lite[savingsplans]` - Type annotations for
  [SavingsPlans](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_savingsplans/)
  service.
- `types-aioboto3-lite[schemas]` - Type annotations for
  [Schemas](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_schemas/)
  service.
- `types-aioboto3-lite[sdb]` - Type annotations for
  [SimpleDB](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_sdb/)
  service.
- `types-aioboto3-lite[secretsmanager]` - Type annotations for
  [SecretsManager](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_secretsmanager/)
  service.
- `types-aioboto3-lite[securityhub]` - Type annotations for
  [SecurityHub](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_securityhub/)
  service.
- `types-aioboto3-lite[serverlessrepo]` - Type annotations for
  [ServerlessApplicationRepository](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_serverlessrepo/)
  service.
- `types-aioboto3-lite[service-quotas]` - Type annotations for
  [ServiceQuotas](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_service_quotas/)
  service.
- `types-aioboto3-lite[servicecatalog]` - Type annotations for
  [ServiceCatalog](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_servicecatalog/)
  service.
- `types-aioboto3-lite[servicecatalog-appregistry]` - Type annotations for
  [AppRegistry](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_servicecatalog_appregistry/)
  service.
- `types-aioboto3-lite[servicediscovery]` - Type annotations for
  [ServiceDiscovery](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_servicediscovery/)
  service.
- `types-aioboto3-lite[ses]` - Type annotations for
  [SES](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_ses/)
  service.
- `types-aioboto3-lite[sesv2]` - Type annotations for
  [SESV2](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_sesv2/)
  service.
- `types-aioboto3-lite[shield]` - Type annotations for
  [Shield](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_shield/)
  service.
- `types-aioboto3-lite[signer]` - Type annotations for
  [signer](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_signer/)
  service.
- `types-aioboto3-lite[sms]` - Type annotations for
  [SMS](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_sms/)
  service.
- `types-aioboto3-lite[sms-voice]` - Type annotations for
  [PinpointSMSVoice](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_sms_voice/)
  service.
- `types-aioboto3-lite[snow-device-management]` - Type annotations for
  [SnowDeviceManagement](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_snow_device_management/)
  service.
- `types-aioboto3-lite[snowball]` - Type annotations for
  [Snowball](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_snowball/)
  service.
- `types-aioboto3-lite[sns]` - Type annotations for
  [SNS](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_sns/)
  service.
- `types-aioboto3-lite[sqs]` - Type annotations for
  [SQS](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_sqs/)
  service.
- `types-aioboto3-lite[ssm]` - Type annotations for
  [SSM](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_ssm/)
  service.
- `types-aioboto3-lite[ssm-contacts]` - Type annotations for
  [SSMContacts](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_ssm_contacts/)
  service.
- `types-aioboto3-lite[ssm-incidents]` - Type annotations for
  [SSMIncidents](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_ssm_incidents/)
  service.
- `types-aioboto3-lite[sso]` - Type annotations for
  [SSO](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_sso/)
  service.
- `types-aioboto3-lite[sso-admin]` - Type annotations for
  [SSOAdmin](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_sso_admin/)
  service.
- `types-aioboto3-lite[sso-oidc]` - Type annotations for
  [SSOOIDC](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_sso_oidc/)
  service.
- `types-aioboto3-lite[stepfunctions]` - Type annotations for
  [SFN](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_stepfunctions/)
  service.
- `types-aioboto3-lite[storagegateway]` - Type annotations for
  [StorageGateway](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_storagegateway/)
  service.
- `types-aioboto3-lite[sts]` - Type annotations for
  [STS](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_sts/)
  service.
- `types-aioboto3-lite[support]` - Type annotations for
  [Support](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_support/)
  service.
- `types-aioboto3-lite[support-app]` - Type annotations for
  [SupportApp](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_support_app/)
  service.
- `types-aioboto3-lite[swf]` - Type annotations for
  [SWF](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_swf/)
  service.
- `types-aioboto3-lite[synthetics]` - Type annotations for
  [Synthetics](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_synthetics/)
  service.
- `types-aioboto3-lite[textract]` - Type annotations for
  [Textract](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_textract/)
  service.
- `types-aioboto3-lite[timestream-query]` - Type annotations for
  [TimestreamQuery](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_timestream_query/)
  service.
- `types-aioboto3-lite[timestream-write]` - Type annotations for
  [TimestreamWrite](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_timestream_write/)
  service.
- `types-aioboto3-lite[transcribe]` - Type annotations for
  [TranscribeService](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_transcribe/)
  service.
- `types-aioboto3-lite[transfer]` - Type annotations for
  [Transfer](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_transfer/)
  service.
- `types-aioboto3-lite[translate]` - Type annotations for
  [Translate](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_translate/)
  service.
- `types-aioboto3-lite[voice-id]` - Type annotations for
  [VoiceID](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_voice_id/)
  service.
- `types-aioboto3-lite[waf]` - Type annotations for
  [WAF](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_waf/)
  service.
- `types-aioboto3-lite[waf-regional]` - Type annotations for
  [WAFRegional](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_waf_regional/)
  service.
- `types-aioboto3-lite[wafv2]` - Type annotations for
  [WAFV2](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_wafv2/)
  service.
- `types-aioboto3-lite[wellarchitected]` - Type annotations for
  [WellArchitected](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_wellarchitected/)
  service.
- `types-aioboto3-lite[wisdom]` - Type annotations for
  [ConnectWisdomService](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_wisdom/)
  service.
- `types-aioboto3-lite[workdocs]` - Type annotations for
  [WorkDocs](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_workdocs/)
  service.
- `types-aioboto3-lite[worklink]` - Type annotations for
  [WorkLink](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_worklink/)
  service.
- `types-aioboto3-lite[workmail]` - Type annotations for
  [WorkMail](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_workmail/)
  service.
- `types-aioboto3-lite[workmailmessageflow]` - Type annotations for
  [WorkMailMessageFlow](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_workmailmessageflow/)
  service.
- `types-aioboto3-lite[workspaces]` - Type annotations for
  [WorkSpaces](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_workspaces/)
  service.
- `types-aioboto3-lite[workspaces-web]` - Type annotations for
  [WorkSpacesWeb](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_workspaces_web/)
  service.
- `types-aioboto3-lite[xray]` - Type annotations for
  [XRay](https://youtype.github.io/types_aioboto3_docs/types_aiobotocore_xray/)
  service.
