# mypy-boto3-codeguruprofiler

[![PyPI - mypy-boto3-codeguruprofiler](https://img.shields.io/pypi/v/mypy-boto3-codeguruprofiler.svg?color=blue)](https://pypi.org/project/mypy-boto3-codeguruprofiler)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-codeguruprofiler.svg?color=blue)](https://pypi.org/project/mypy-boto3-codeguruprofiler)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.CodeGuruProfiler 1.17.0](https://boto3.amazonaws.com/v1/documentation/api/1.17.0/reference/services/codeguruprofiler.html#CodeGuruProfiler) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 4.3.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-codeguruprofiler](#mypy-boto3-codeguruprofiler)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `CodeGuruProfiler` service.

```bash
python -m pip install boto3-stubs[codeguruprofiler]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[codeguruprofiler]` in your environment: `python -m pip install 'boto3-stubs[codeguruprofiler]'`

Both type checking and auto-complete should work for `CodeGuruProfiler` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[codeguruprofiler]` in your environment: `python -m pip install 'boto3-stubs[codeguruprofiler]'`

Both type checking and auto-complete should work for `CodeGuruProfiler` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[codeguruprofiler]` in your environment: `python -m pip install 'boto3-stubs[codeguruprofiler]'`
- Run `mypy` as usual

Type checking should work for `CodeGuruProfiler` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[codeguruprofiler]` in your environment: `python -m pip install 'boto3-stubs[codeguruprofiler]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `CodeGuruProfiler` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`CodeGuruProfilerClient` provides annotations for `boto3.client("codeguruprofiler")`.

```python
import boto3

from mypy_boto3_codeguruprofiler import CodeGuruProfilerClient

client: CodeGuruProfilerClient = boto3.client("codeguruprofiler")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: CodeGuruProfilerClient = session.client("codeguruprofiler")
```

### Paginators annotations

`mypy_boto3_codeguruprofiler.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_codeguruprofiler import CodeGuruProfilerClient
from mypy_boto3_codeguruprofiler.paginator import ListProfileTimesPaginator

client: CodeGuruProfilerClient = boto3.client("codeguruprofiler")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_profile_times_paginator: ListProfileTimesPaginator = client.get_paginator("list_profile_times")
```







### Typed dictionations

`mypy_boto3_codeguruprofiler.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_codeguruprofiler.type_defs import (
    AddNotificationChannelsResponseTypeDef,
    AgentConfigurationTypeDef,
    AgentOrchestrationConfigTypeDef,
    AggregatedProfileTimeTypeDef,
    AnomalyInstanceTypeDef,
    AnomalyTypeDef,
    BatchGetFrameMetricDataResponseTypeDef,
    ChannelTypeDef,
    ConfigureAgentResponseTypeDef,
    CreateProfilingGroupResponseTypeDef,
    DescribeProfilingGroupResponseTypeDef,
    FindingsReportSummaryTypeDef,
    FrameMetricDatumTypeDef,
    FrameMetricTypeDef,
    GetFindingsReportAccountSummaryResponseTypeDef,
    GetNotificationConfigurationResponseTypeDef,
    GetPolicyResponseTypeDef,
    GetProfileResponseTypeDef,
    GetRecommendationsResponseTypeDef,
    ListFindingsReportsResponseTypeDef,
    ListProfileTimesResponseTypeDef,
    ListProfilingGroupsResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    MatchTypeDef,
    MetricTypeDef,
    NotificationConfigurationTypeDef,
    PaginatorConfigTypeDef,
    PatternTypeDef,
    ProfileTimeTypeDef,
    ProfilingGroupDescriptionTypeDef,
    ProfilingStatusTypeDef,
    PutPermissionResponseTypeDef,
    RecommendationTypeDef,
    RemoveNotificationChannelResponseTypeDef,
    RemovePermissionResponseTypeDef,
    TimestampStructureTypeDef,
    UpdateProfilingGroupResponseTypeDef,
    UserFeedbackTypeDef,
)

def get_structure() -> AgentConfigurationTypeDef:
    return {
      ...
    }
```
