# Generated by Django 3.2.13 on 2022-04-28 05:55

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import giant_plugins.utils
import mixins.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=255)),
                ('order', models.PositiveIntegerField(default=0, help_text='Higher number means a higher priority in listing.')),
            ],
            options={
                'verbose_name': 'Category',
                'verbose_name_plural': 'Categories',
                'ordering': ['order', 'name'],
            },
        ),
        migrations.CreateModel(
            name='FAQ',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(default=django.utils.timezone.now)),
                ('updated_at', mixins.fields.AutoDateTimeField(default=django.utils.timezone.now)),
                ('question', models.CharField(max_length=255)),
                ('answer', giant_plugins.utils.RichTextField()),
                ('is_active', models.BooleanField(default=False, help_text='Check this to show FAQ on index page')),
                ('order', models.PositiveIntegerField(default=0, help_text='Higher number means a higher priority in listing.')),
                ('category', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='giant_faqs', to='giant_faqs.category')),
            ],
            options={
                'verbose_name': 'FAQ',
                'verbose_name_plural': 'FAQs',
                'ordering': ['order', 'question'],
            },
        ),
    ]
