# This file is part of BurnMan - a thermoelastic and thermodynamic toolkit for the Earth and Planetary Sciences
# Copyright (C) 2012 - 2021 by the BurnMan team, released under the GNU
# GPL v2 or later.


"""
HGP_2018 (ds-633) zero-point energy covariance matrix
Derived from Holland, Green and Powell (2018) and references therein.
Dataset version 6.33.
The values in this document are all in S.I. units,
unlike those in the original tc-ds633.txt.
File autogenerated using HGP633data_to_burnman.py.
"""

from numpy import array

cov = {'covariance_matrix': array([[ 2.863000e+05,  1.550000e+04,  3.550000e+04, -3.530000e+04,
         1.249000e+05,  1.245100e+06,  6.726000e+05,  2.723000e+05,
         1.550000e+04,  2.695000e+05,  1.540000e+04,  1.517000e+05,
         2.700000e+04, -5.080000e+04,  0.000000e+00,  1.517000e+05,
        -6.400000e+03,  1.509000e+05,  2.900000e+03,  6.062000e+05,
         0.000000e+00,  4.032000e+05,  2.100000e+03,  2.750000e+04,
        -7.260000e+04, -2.690000e+04,  4.820000e+04,  4.515000e+05,
        -2.470000e+04,  2.288000e+05,  4.329000e+05, -3.870000e+04,
        -1.720000e+05, -3.080000e+04, -3.080000e+04, -3.110000e+04,
        -3.070000e+04, -5.340000e+04, -3.090000e+04,  2.191000e+05,
        -3.173000e+05, -2.818000e+05,  1.013000e+05, -3.330000e+04,
        -2.390000e+04,  8.930000e+04, -9.900000e+04, -7.090000e+04,
        -7.090000e+04, -4.780000e+04, -2.480000e+04, -3.930000e+04,
        -3.830000e+04,  1.550000e+04, -1.187000e+05, -2.700000e+03,
        -8.530000e+04,  1.172000e+05, -4.280000e+04, -9.910000e+04,
         2.595000e+05,  2.594000e+05, -6.700000e+03,  9.000000e+03,
         8.745000e+05,  2.033000e+05,  3.190000e+05,  1.143800e+06,
        -1.760000e+04,  1.520000e+04,  1.730000e+04, -1.310000e+04,
         9.800000e+03,  3.037000e+05,  3.037000e+05,  3.037000e+05,
         3.037000e+05,  3.560000e+04,  3.560000e+04,  9.920000e+04,
         1.459000e+05,  1.100000e+04, -7.300000e+03,  0.000000e+00,
         1.550000e+04,  1.700000e+04, -5.800000e+04,  8.000000e+02,
         2.430000e+04,  2.430000e+04, -7.500000e+03, -7.500000e+03,
        -7.500000e+03,  7.662000e+05,  9.530000e+04,  3.566000e+05,
         5.020000e+05,  4.594000e+05,  5.780000e+04,  3.933000e+05,
         1.039000e+05,  1.081600e+06,  1.432000e+05,  1.081700e+06,
         1.445000e+05,  6.739000e+05,  3.594000e+05,  1.553000e+05,
        -1.760000e+05,  1.204000e+05, -1.380000e+04,  1.990000e+05,
        -1.227000e+05,  7.960000e+04, -5.410000e+04, -3.850000e+04,
        -8.910000e+04,  3.229000e+05, -7.860000e+04, -5.290000e+04,
         1.205000e+05,  4.155000e+05,  4.729000e+05,  6.695000e+05,
         4.649000e+05,  8.740000e+05, -1.500000e+03,  4.330000e+04,
         2.208000e+05, -4.760000e+04,  2.910000e+04,  4.740000e+05,
         7.020000e+04,  2.718000e+05,  2.920000e+04,  4.060000e+05,
         7.340000e+04,  4.549000e+05, -1.110000e+04, -4.550000e+04,
        -2.230000e+04,  4.404000e+05,  4.404000e+05,  3.310000e+04,
         4.420000e+04,  7.152000e+05,  7.045000e+06,  1.230000e+04,
         1.230000e+04, -7.160000e+04, -7.160000e+04, -3.820000e+04,
        -7.170000e+04, -1.326000e+05, -7.160000e+04,  2.010000e+04,
         2.010000e+04,  2.010000e+04,  2.010000e+04,  3.200000e+04,
        -2.410000e+04, -2.400000e+04, -2.400000e+04,  4.640000e+04,
         2.489000e+05,  0.000000e+00, -2.280000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.443000e+05, -1.089000e+05, -9.030000e+04,
        -1.425000e+05,  1.800000e+03,  1.600000e+03,  6.170000e+04,
         6.160000e+04, -7.900000e+03, -2.300000e+04, -1.030000e+04,
         9.720000e+04, -1.680000e+04, -1.800000e+03, -5.000000e+03,
        -5.080000e+04,  1.517000e+05, -4.500000e+03, -2.300000e+03,
         0.000000e+00,  0.000000e+00, -3.300000e+03,  1.116000e+05,
        -1.260000e+04, -5.200000e+03, -5.100000e+03, -5.100000e+03,
         0.000000e+00,  0.000000e+00,  8.000000e+04, -5.340000e+04,
        -7.000000e+03,  4.150000e+04,  2.087000e+05, -1.160000e+04,
         1.286000e+05,  1.000000e+05, -2.560000e+04, -2.300000e+03,
        -2.810000e+04, -2.810000e+04,  1.240000e+05, -3.200000e+03,
         0.000000e+00,  9.490000e+04, -3.150000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02, -3.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  9.720000e+04,
        -2.300000e+04, -6.700000e+03, -2.300000e+03, -4.500000e+03,
         2.010000e+04, -1.000000e+02,  2.863000e+05,  1.550000e+04,
        -7.500000e+03,  3.037000e+05,  1.459000e+05, -3.070000e+04,
        -3.820000e+04, -7.160000e+04,  1.230000e+04, -2.400000e+04,
        -9.030000e+04, -1.030000e+04, -5.100000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.010000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.550000e+04,  3.933000e+05,  3.280000e+04, -3.000000e+02,
         7.600000e+03,  4.930000e+04,  1.830000e+04,  1.730000e+04,
         3.932000e+05,  1.770000e+04,  3.922000e+05,  3.290000e+04,
         2.198000e+05, -6.960000e+04,  0.000000e+00,  3.290000e+04,
         2.440000e+04,  3.310000e+04,  2.540000e+04,  1.312000e+05,
         0.000000e+00,  2.730000e+04,  5.558000e+05,  5.710000e+04,
        -6.000000e+02,  3.622000e+05,  9.306000e+05,  9.690000e+04,
         7.300000e+04,  1.894000e+05,  2.915000e+05,  5.621000e+05,
        -3.180000e+04, -1.900000e+04, -1.900000e+04, -1.840000e+04,
        -1.910000e+04, -6.180000e+04, -1.900000e+04, -3.200000e+05,
         3.843000e+05, -2.802000e+05, -3.690000e+04,  1.386000e+05,
        -2.690000e+04,  7.500000e+03, -2.490000e+04, -1.290000e+04,
        -1.290000e+04,  1.706000e+05,  3.528000e+05,  1.860000e+04,
         1.300000e+03, -4.700000e+03,  1.711000e+05,  1.088700e+06,
        -7.140000e+04,  3.170000e+04,  2.390000e+04, -2.490000e+04,
         7.740000e+04,  7.740000e+04,  4.360000e+05,  9.730000e+04,
        -7.400000e+03,  7.740000e+04,  2.150000e+04,  9.200000e+03,
        -5.700000e+03,  7.500000e+04,  3.840000e+04, -3.910000e+04,
         2.410000e+04,  6.470000e+04,  6.470000e+04,  6.470000e+04,
         6.470000e+04,  4.440000e+05,  4.440000e+05, -3.740000e+04,
         5.580000e+04,  2.451000e+05, -4.900000e+03,  0.000000e+00,
         1.766000e+05,  2.990000e+04, -4.660000e+04,  4.650000e+04,
         3.710000e+04,  3.710000e+04,  2.420000e+04,  2.420000e+04,
         2.430000e+04,  2.588000e+05,  1.206900e+06,  5.170000e+04,
         3.300000e+03,  1.372000e+05,  7.058000e+05, -1.840000e+04,
         1.030400e+06,  2.767000e+05,  1.604200e+06,  2.767000e+05,
         1.604800e+06,  7.280000e+04, -2.489000e+05, -3.509000e+05,
         5.007000e+05,  1.310000e+04,  1.889000e+05,  3.524100e+06,
        -5.980000e+04,  4.220000e+04,  2.184000e+05, -2.440000e+04,
        -6.860000e+04, -4.480000e+04,  5.181000e+05, -1.500000e+04,
        -1.469000e+05, -5.300000e+03,  1.463000e+05, -7.400000e+03,
        -1.098000e+05,  9.490000e+04,  8.715000e+05,  4.220000e+04,
        -2.450000e+04,  3.270000e+05,  1.318000e+05,  1.471000e+05,
         6.736000e+05,  4.520000e+04,  1.335000e+05, -1.060000e+04,
         7.168000e+05,  2.015000e+05,  3.010000e+04,  2.500000e+04,
         2.086000e+05,  4.610000e+04,  4.610000e+04,  6.152000e+05,
         1.105400e+06,  2.264000e+05,  8.648000e+05,  4.520000e+04,
         4.530000e+04,  9.900000e+03,  1.000000e+04, -1.000000e+02,
         9.900000e+03, -1.180000e+04,  1.000000e+04,  5.080000e+04,
         5.080000e+04,  5.080000e+04,  5.070000e+04,  4.860000e+04,
        -5.210000e+04, -5.200000e+04, -5.200000e+04, -8.200000e+04,
         2.050000e+04,  0.000000e+00, -3.100000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.123000e+05, -8.980000e+04, -3.990000e+04,
        -2.450000e+04,  1.018000e+05,  1.023000e+05,  2.544000e+05,
         2.544000e+05, -5.500000e+03, -2.390000e+04, -2.670000e+04,
        -1.240000e+04,  1.730000e+05,  1.178000e+05, -2.800000e+03,
        -6.960000e+04,  3.280000e+04,  2.927000e+05,  3.000000e+02,
         0.000000e+00, -2.200000e+03, -3.050000e+04, -4.200000e+04,
         1.285000e+05, -1.150000e+04, -1.160000e+04, -1.160000e+04,
         0.000000e+00,  0.000000e+00, -8.720000e+04,  8.860000e+04,
         4.508000e+05,  8.460000e+04, -5.430000e+04,  1.189000e+05,
        -1.750000e+04, -1.270000e+04, -3.550000e+04,  1.460000e+05,
        -2.440000e+04, -2.440000e+04, -1.550000e+04,  1.562000e+05,
        -3.100000e+03, -3.990000e+04,  1.319000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  3.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.240000e+04,
        -2.390000e+04, -9.100000e+03,  3.000000e+02,  2.927000e+05,
         5.080000e+04,  0.000000e+00,  1.550000e+04,  3.933000e+05,
         2.420000e+04,  6.470000e+04,  5.580000e+04, -1.910000e+04,
        -1.000000e+02,  1.000000e+04,  4.530000e+04, -5.200000e+04,
        -3.990000e+04, -2.670000e+04, -1.160000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         5.080000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 3.550000e+04,  3.280000e+04,  1.022500e+06,  3.900000e+03,
         1.950000e+04,  1.262000e+05,  5.520000e+04,  3.020000e+04,
         3.280000e+04,  2.910000e+04,  3.270000e+04,  3.840000e+04,
         4.110000e+04, -5.530000e+04,  0.000000e+00,  3.840000e+04,
         2.350000e+04,  3.810000e+04,  4.700000e+03,  1.534000e+05,
         0.000000e+00,  5.980000e+04,  5.810000e+04,  1.492900e+06,
         1.270000e+04,  5.950000e+04,  1.034000e+05,  1.152000e+05,
         6.840000e+04,  1.805000e+05,  2.748000e+05,  1.791000e+05,
         7.690000e+04, -1.290000e+04, -1.280000e+04, -1.290000e+04,
        -1.290000e+04, -4.790000e+04, -1.290000e+04, -1.955000e+05,
        -1.985000e+05,  1.715300e+06, -1.670000e+04, -1.780000e+04,
         4.611000e+05,  2.330000e+04, -1.520000e+04,  4.800000e+03,
         4.800000e+03,  2.820000e+04,  5.160000e+04,  5.061000e+05,
         9.800000e+03,  3.340000e+04,  3.250000e+04,  1.494000e+05,
        -5.220000e+04,  4.230000e+04,  2.660000e+04, -1.890000e+04,
         9.300000e+04,  9.300000e+04,  9.230000e+04,  1.048500e+06,
         2.400000e+04,  9.300000e+04,  3.340000e+04, -1.300000e+03,
         1.290000e+04,  6.640000e+04,  3.300000e+04, -1.940000e+04,
         3.260000e+04,  7.710000e+04,  7.710000e+04,  7.710000e+04,
         7.710000e+04,  7.530000e+04,  7.530000e+04, -1.730000e+04,
         6.170000e+04,  6.050000e+04, -4.500000e+03,  0.000000e+00,
         1.840000e+04,  2.320000e+04, -3.260000e+04,  4.730000e+04,
         4.803000e+05,  4.804000e+05,  2.280000e+04,  2.280000e+04,
         2.280000e+04,  2.811000e+05,  2.765000e+05,  9.200000e+04,
         5.950000e+04,  1.485000e+05,  1.454000e+05,  1.780000e+04,
         1.928000e+05,  3.117000e+05,  3.057000e+05,  3.117000e+05,
         3.061000e+05,  1.233000e+05, -1.531000e+05, -2.474000e+05,
        -1.562000e+05,  2.550000e+04,  2.460000e+04,  4.259000e+05,
        -5.330000e+04,  4.050000e+04,  3.990000e+04, -1.780000e+04,
        -4.560000e+04, -9.800000e+03, -1.240000e+04,  1.423400e+06,
        -1.036000e+05,  2.850000e+04,  1.571000e+05,  5.290000e+04,
        -4.140000e+04,  1.473000e+05,  4.860000e+04,  2.441500e+06,
         8.400000e+03,  6.600000e+03,  1.134000e+05,  1.575000e+05,
         1.542000e+05,  6.380000e+04,  1.146000e+05,  2.500000e+04,
         1.555000e+05,  1.513000e+05,  2.820000e+04,  3.250000e+04,
         5.590000e+04,  7.630000e+04,  7.630000e+04,  7.040000e+04,
         2.118000e+05,  2.162000e+05,  1.268100e+06,  3.750000e+04,
         3.750000e+04,  2.200000e+03,  2.200000e+03,  9.800000e+03,
         2.100000e+03, -2.530000e+04,  2.200000e+03,  4.250000e+04,
         4.250000e+04,  4.250000e+04,  4.250000e+04,  4.690000e+04,
        -4.370000e+04, -4.360000e+04, -4.370000e+04, -7.250000e+04,
         2.130000e+04,  0.000000e+00, -2.980000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.620000e+05, -8.180000e+04, -3.980000e+04,
         6.700000e+03,  9.480000e+04,  9.470000e+04,  2.222000e+05,
         2.221000e+05, -5.000000e+03, -1.660000e+04, -9.900000e+03,
        -1.710000e+04, -1.040000e+04, -3.500000e+03,  2.078000e+05,
        -5.530000e+04,  3.840000e+04, -8.600000e+03,  1.000000e+02,
         0.000000e+00,  0.000000e+00,  3.756000e+05, -1.590000e+04,
        -1.460000e+04, -9.900000e+03, -9.900000e+03, -9.900000e+03,
         0.000000e+00,  0.000000e+00, -5.940000e+04, -6.010000e+04,
        -1.330000e+04, -3.900000e+03, -3.300000e+04, -1.350000e+04,
        -4.000000e+03, -1.590000e+04, -2.820000e+04, -4.300000e+03,
        -2.270000e+04, -2.270000e+04, -1.010000e+04, -8.700000e+03,
         2.189000e+05, -3.280000e+04, -3.140000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -4.000000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.710000e+04,
        -1.660000e+04, -7.300000e+03,  1.000000e+02, -8.600000e+03,
         4.250000e+04,  0.000000e+00,  3.550000e+04,  3.280000e+04,
         2.280000e+04,  7.710000e+04,  6.170000e+04, -1.290000e+04,
         9.800000e+03,  2.200000e+03,  3.750000e+04, -4.370000e+04,
        -3.980000e+04, -9.900000e+03, -9.900000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.250000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-3.530000e+04, -3.000000e+02,  3.900000e+03,  7.462000e+05,
         3.404000e+05, -1.563000e+05, -8.570000e+04, -3.310000e+04,
        -3.000000e+02, -3.260000e+04, -3.000000e+02, -1.440000e+04,
         1.300000e+03, -6.660000e+04,  0.000000e+00, -1.440000e+04,
         3.543000e+05, -1.430000e+04,  2.000000e+02, -5.820000e+04,
         0.000000e+00, -1.101000e+05, -6.080000e+04, -4.980000e+04,
         9.778000e+05,  1.056600e+06, -1.100000e+03, -4.330000e+04,
         1.070000e+06, -1.178000e+05, -6.590000e+04, -8.320000e+04,
         6.201300e+06, -6.010000e+04, -6.020000e+04, -6.000000e+04,
        -6.010000e+04, -8.000000e+04, -6.020000e+04, -6.348000e+05,
        -5.694000e+05, -5.543000e+05, -8.100000e+04, -6.450000e+04,
        -6.090000e+04,  1.067700e+06,  1.804600e+06,  5.966000e+05,
         5.966000e+05,  6.309000e+05,  6.686000e+05,  6.353000e+05,
         2.847000e+05,  1.210900e+06,  1.227300e+06,  1.398800e+06,
         6.229000e+05,  6.957000e+05,  1.092700e+06,  1.778300e+06,
        -1.422000e+05, -1.421000e+05, -1.092000e+05, -1.020000e+05,
        -1.164000e+05, -1.390000e+04, -3.840000e+04, -1.481000e+05,
         3.287000e+05,  3.294000e+05,  4.900000e+03, -1.630000e+04,
        -8.100000e+03, -2.910000e+04, -2.910000e+04, -2.910000e+04,
        -2.910000e+04,  6.200000e+03,  6.200000e+03, -8.090000e+04,
         3.324000e+05,  3.505000e+05, -6.600000e+03,  0.000000e+00,
         2.420000e+04,  2.680000e+04,  2.813000e+05,  1.429000e+05,
         4.600000e+03,  4.600000e+03,  3.566000e+05,  3.565000e+05,
         3.566000e+05,  6.275000e+05,  7.170000e+05,  5.216000e+05,
         5.471000e+05, -5.030000e+04,  2.900000e+03, -7.670000e+04,
         6.080000e+04, -9.540000e+04,  2.840000e+04, -9.540000e+04,
         2.840000e+04, -1.988000e+05, -3.361000e+05, -3.879000e+05,
        -2.664000e+05, -7.470000e+04, -5.830000e+04,  8.400000e+03,
        -5.530000e+04, -3.100000e+03,  1.340000e+04, -6.660000e+04,
         2.178000e+05, -5.180000e+04,  7.000000e+02,  8.500000e+03,
        -1.040000e+05, -6.210000e+04, -3.750000e+04, -1.515000e+05,
        -2.034000e+05, -9.960000e+04, -6.930000e+04, -5.100000e+04,
        -1.560000e+05, -1.231000e+05, -3.980000e+04, -3.720000e+04,
         1.210000e+04, -8.930000e+04, -4.040000e+04, -6.340000e+04,
         1.590000e+04, -3.170000e+04, -5.260000e+04,  6.337000e+05,
         6.680000e+05, -5.050000e+04, -5.040000e+04,  2.800000e+03,
        -2.160000e+04, -1.037000e+05, -7.839000e+05,  0.000000e+00,
         0.000000e+00,  1.150000e+04,  1.150000e+04,  2.829000e+05,
         1.150000e+04,  7.660000e+04,  1.150000e+04,  6.600000e+03,
         6.600000e+03,  6.600000e+03,  6.500000e+03,  4.200000e+03,
        -1.390000e+04, -1.390000e+04, -1.390000e+04, -8.130000e+04,
        -2.920000e+04,  0.000000e+00, -6.200000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -8.340000e+04, -1.200000e+03,  5.200000e+03,
         1.195600e+06,  2.966000e+05,  2.973000e+05,  3.170000e+05,
         3.170000e+05, -6.500000e+03,  3.278000e+05, -1.460000e+04,
        -1.470000e+04, -8.000000e+02, -3.500000e+03,  1.400000e+03,
        -6.660000e+04, -1.440000e+04, -8.800000e+03,  4.000000e+02,
         0.000000e+00, -6.000000e+02, -1.250000e+04, -3.440000e+04,
        -1.910000e+04, -1.500000e+03, -1.500000e+03, -1.500000e+03,
         0.000000e+00,  0.000000e+00, -8.710000e+04, -7.120000e+04,
        -1.340000e+04, -1.000000e+04, -4.910000e+04, -1.760000e+04,
        -2.030000e+04, -1.520000e+04, -3.310000e+04, -4.400000e+03,
         3.469000e+05,  3.468000e+05, -2.360000e+04, -7.700000e+03,
        -2.000000e+03,  3.189000e+05,  3.385000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.200000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.470000e+04,
         3.278000e+05, -8.700000e+03,  4.000000e+02, -8.800000e+03,
         6.600000e+03,  0.000000e+00, -3.530000e+04, -3.000000e+02,
         3.565000e+05, -2.910000e+04,  3.324000e+05, -6.010000e+04,
         2.829000e+05,  1.150000e+04,  0.000000e+00, -1.390000e+04,
         5.200000e+03, -1.460000e+04, -1.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         6.600000e+03,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.249000e+05,  7.600000e+03,  1.950000e+04,  3.404000e+05,
         2.473000e+05,  5.420000e+05,  2.922000e+05,  1.191000e+05,
         7.600000e+03,  1.180000e+05,  7.600000e+03,  6.840000e+04,
         1.410000e+04, -5.860000e+04,  0.000000e+00,  6.840000e+04,
         1.723000e+05,  6.810000e+04,  1.600000e+03,  2.731000e+05,
         0.000000e+00,  1.458000e+05, -2.910000e+04, -1.130000e+04,
         4.515000e+05,  5.136000e+05,  2.370000e+04,  2.032000e+05,
         5.213000e+05,  5.550000e+04,  1.831000e+05, -6.030000e+04,
         3.007500e+06, -4.530000e+04, -4.540000e+04, -4.540000e+04,
        -4.530000e+04, -6.660000e+04, -4.540000e+04, -2.081000e+05,
        -4.422000e+05, -4.175000e+05,  1.000000e+04, -4.880000e+04,
        -4.240000e+04,  5.944000e+05,  8.482000e+05,  2.623000e+05,
         2.623000e+05,  2.909000e+05,  3.212000e+05,  2.972000e+05,
         1.230000e+05,  6.118000e+05,  5.532000e+05,  6.964000e+05,
         2.682000e+05,  4.242000e+05,  5.149000e+05,  8.368000e+05,
         5.840000e+04,  5.830000e+04, -5.750000e+04, -4.630000e+04,
         3.778000e+05,  9.420000e+04,  1.398000e+05,  4.971000e+05,
         1.553000e+05,  1.801000e+05,  1.110000e+04, -1.470000e+04,
         9.000000e+02,  1.367000e+05,  1.367000e+05,  1.367000e+05,
         1.367000e+05,  2.100000e+04,  2.100000e+04,  9.000000e+03,
         2.386000e+05,  1.805000e+05, -6.900000e+03,  0.000000e+00,
         1.980000e+04,  2.190000e+04,  1.114000e+05,  7.190000e+04,
         1.440000e+04,  1.440000e+04,  1.741000e+05,  1.741000e+05,
         1.741000e+05,  6.950000e+05,  4.058000e+05,  4.379000e+05,
         5.229000e+05,  2.037000e+05,  3.050000e+04,  1.574000e+05,
         8.240000e+04,  4.911000e+05,  8.600000e+04,  4.911000e+05,
         8.670000e+04,  2.363000e+05,  1.080000e+04, -1.167000e+05,
        -2.207000e+05,  2.270000e+04, -3.590000e+04,  1.041000e+05,
        -8.870000e+04,  3.820000e+04, -2.010000e+04, -5.240000e+04,
         6.420000e+04,  1.347000e+05, -3.880000e+04, -2.230000e+04,
         7.800000e+03,  1.758000e+05,  2.168000e+05,  2.576000e+05,
         1.297000e+05,  3.854000e+05, -3.520000e+04, -4.200000e+03,
         3.200000e+04, -8.510000e+04, -5.100000e+03,  2.176000e+05,
         4.130000e+04,  9.080000e+04, -5.400000e+03,  1.704000e+05,
         4.480000e+04,  2.110000e+05, -3.170000e+04,  2.935000e+05,
         3.222000e+05,  1.940000e+05,  1.940000e+05,  1.800000e+04,
         1.170000e+04,  3.045000e+05,  3.116300e+06,  6.200000e+03,
         6.200000e+03, -2.990000e+04, -2.990000e+04,  1.222000e+05,
        -2.990000e+04, -2.780000e+04, -2.990000e+04,  1.340000e+04,
         1.340000e+04,  1.340000e+04,  1.340000e+04,  1.800000e+04,
        -1.900000e+04, -1.900000e+04, -1.900000e+04, -1.730000e+04,
         1.096000e+05,  0.000000e+00, -1.450000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.140000e+05, -5.490000e+04, -4.240000e+04,
         5.259000e+05,  1.491000e+05,  1.493000e+05,  1.893000e+05,
         1.892000e+05, -7.200000e+03,  1.531000e+05, -1.240000e+04,
         4.130000e+04, -8.700000e+03, -2.700000e+03, -1.800000e+03,
        -5.860000e+04,  6.840000e+04, -6.700000e+03, -1.000000e+03,
         0.000000e+00, -3.000000e+02, -8.000000e+03,  3.840000e+04,
        -1.580000e+04, -3.300000e+03, -3.300000e+03, -3.300000e+03,
         0.000000e+00,  0.000000e+00, -3.800000e+03, -6.220000e+04,
        -1.020000e+04,  1.560000e+04,  7.960000e+04, -1.460000e+04,
         5.390000e+04,  4.240000e+04, -2.930000e+04, -3.300000e+03,
         1.593000e+05,  1.592000e+05,  5.000000e+04, -5.400000e+03,
        -1.000000e+03,  2.065000e+05,  1.534000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.800000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.130000e+04,
         1.531000e+05, -7.700000e+03, -1.000000e+03, -6.700000e+03,
         1.340000e+04,  0.000000e+00,  1.249000e+05,  7.600000e+03,
         1.741000e+05,  1.367000e+05,  2.386000e+05, -4.530000e+04,
         1.222000e+05, -2.990000e+04,  6.200000e+03, -1.900000e+04,
        -4.240000e+04, -1.240000e+04, -3.300000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.340000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.245100e+06,  4.930000e+04,  1.262000e+05, -1.563000e+05,
         5.420000e+05,  5.466700e+06,  2.973800e+06,  1.191900e+06,
         4.930000e+04,  1.181300e+06,  4.910000e+04,  6.484000e+05,
         9.110000e+04, -1.916000e+05,  0.000000e+00,  6.484000e+05,
        -4.200000e+04,  6.452000e+05,  9.800000e+03,  2.590300e+06,
         0.000000e+00,  1.746600e+06, -2.500000e+04,  7.050000e+04,
        -3.271000e+05, -1.523000e+05,  1.520000e+05,  1.927100e+06,
        -1.483000e+05,  9.028000e+05,  1.748600e+06, -2.786000e+05,
        -7.954000e+05, -1.287000e+05, -1.287000e+05, -1.299000e+05,
        -1.287000e+05, -2.080000e+05, -1.287000e+05,  1.084300e+06,
        -1.284700e+06, -1.150500e+06,  4.584000e+05, -1.361000e+05,
        -1.003000e+05,  3.846000e+05, -4.259000e+05, -3.155000e+05,
        -3.155000e+05, -2.267000e+05, -1.388000e+05, -1.945000e+05,
        -1.741000e+05,  5.220000e+04, -5.405000e+05, -9.640000e+04,
        -3.445000e+05,  4.950000e+05, -2.025000e+05, -4.265000e+05,
         1.091300e+06,  1.091300e+06, -8.480000e+04, -2.610000e+04,
         3.939500e+06,  8.284000e+05,  1.411600e+06,  5.162900e+06,
        -9.200000e+04,  2.700000e+04,  5.570000e+04, -5.450000e+04,
         1.620000e+04,  1.296500e+06,  1.296500e+06,  1.296400e+06,
         1.296500e+06,  1.126000e+05,  1.126000e+05,  4.491000e+05,
         6.081000e+05,  1.240000e+04, -2.990000e+04,  0.000000e+00,
         5.740000e+04,  6.090000e+04, -2.367000e+05, -2.480000e+04,
         8.250000e+04,  8.250000e+04, -4.600000e+04, -4.600000e+04,
        -4.600000e+04,  3.219500e+06,  2.570000e+05,  1.522000e+06,
         2.185900e+06,  1.941000e+06,  1.682000e+05,  1.727100e+06,
         3.443000e+05,  4.595100e+06,  4.514000e+05,  4.595100e+06,
         4.572000e+05,  2.906000e+06,  1.682600e+06,  8.367000e+05,
        -6.819000e+05,  5.176000e+05, -7.530000e+04,  6.305000e+05,
        -5.103000e+05,  3.281000e+05, -2.626000e+05, -1.601000e+05,
        -3.660000e+05,  1.433700e+06, -3.392000e+05, -2.424000e+05,
         5.952000e+05,  1.821900e+06,  1.996100e+06,  2.931000e+06,
         2.083300e+06,  3.778600e+06, -3.270000e+04,  1.375000e+05,
         9.720000e+05, -2.134000e+05,  6.070000e+04,  2.001100e+06,
         2.176000e+05,  1.163200e+06,  6.030000e+04,  1.779400e+06,
         2.321000e+05,  1.930800e+06, -6.540000e+04, -2.191000e+05,
        -1.303000e+05,  1.895600e+06,  1.895400e+06,  1.056000e+05,
         7.180000e+04,  3.035400e+06,  3.040930e+07,  3.130000e+04,
         3.130000e+04, -3.179000e+05, -3.181000e+05, -1.743000e+05,
        -3.181000e+05, -5.708000e+05, -3.181000e+05,  6.320000e+04,
         6.330000e+04,  6.330000e+04,  6.330000e+04,  1.082000e+05,
        -7.990000e+04, -7.980000e+04, -7.980000e+04,  2.631000e+05,
         1.102800e+06,  0.000000e+00, -8.010000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -4.792000e+05, -4.317000e+05, -3.748000e+05,
        -6.346000e+05, -4.780000e+04, -4.770000e+04,  1.420000e+05,
         1.420000e+05, -3.190000e+04, -9.190000e+04, -4.700000e+04,
         4.548000e+05, -6.190000e+04, -5.800000e+03, -1.790000e+04,
        -1.916000e+05,  6.481000e+05, -1.430000e+04, -1.020000e+04,
         0.000000e+00,  1.000000e+02, -1.800000e+04,  4.993000e+05,
        -5.400000e+04, -1.680000e+04, -1.650000e+04, -1.650000e+04,
         0.000000e+00,  0.000000e+00,  3.902000e+05, -2.000000e+05,
        -2.210000e+04,  1.860000e+05,  9.538000e+05, -4.990000e+04,
         5.718000e+05,  4.806000e+05, -9.610000e+04, -7.100000e+03,
        -1.117000e+05, -1.117000e+05,  5.552000e+05, -1.110000e+04,
         8.000000e+02,  4.392000e+05, -1.235000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.548000e+05,
        -9.190000e+04, -2.510000e+04, -1.020000e+04, -1.430000e+04,
         6.330000e+04,  0.000000e+00,  1.245100e+06,  4.930000e+04,
        -4.600000e+04,  1.296500e+06,  6.081000e+05, -1.287000e+05,
        -1.743000e+05, -3.181000e+05,  3.130000e+04, -7.980000e+04,
        -3.748000e+05, -4.700000e+04, -1.650000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         6.320000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 6.726000e+05,  1.830000e+04,  5.520000e+04, -8.570000e+04,
         2.922000e+05,  2.973800e+06,  1.990800e+06,  6.473000e+05,
         1.830000e+04,  6.423000e+05,  1.820000e+04,  3.449000e+05,
         3.710000e+04, -9.010000e+04,  0.000000e+00,  3.449000e+05,
        -2.920000e+04,  3.435000e+05,  3.900000e+03,  1.378000e+06,
         0.000000e+00,  9.403000e+05, -2.930000e+04,  1.550000e+04,
        -1.819000e+05, -9.860000e+04,  5.560000e+04,  1.024200e+06,
        -9.900000e+04,  4.452000e+05,  8.828000e+05, -2.013000e+05,
        -4.514000e+05, -6.710000e+04, -6.720000e+04, -6.780000e+04,
        -6.720000e+04, -1.011000e+05, -6.700000e+04,  6.462000e+05,
        -6.500000e+05, -5.868000e+05,  2.558000e+05, -6.950000e+04,
        -5.240000e+04,  2.060000e+05, -2.278000e+05, -1.737000e+05,
        -1.737000e+05, -1.312000e+05, -8.930000e+04, -1.160000e+05,
        -9.750000e+04,  2.110000e+04, -3.033000e+05, -9.100000e+04,
        -1.740000e+05,  2.605000e+05, -1.170000e+05, -2.284000e+05,
         5.724000e+05,  5.726000e+05, -7.160000e+04, -4.420000e+04,
         2.192400e+06,  4.217000e+05,  7.740000e+05,  2.875300e+06,
        -5.690000e+04, -3.500000e+03,  2.120000e+04, -2.830000e+04,
        -3.400000e+03,  6.891000e+05,  6.891000e+05,  6.891000e+05,
         6.891000e+05,  4.140000e+04,  4.140000e+04,  2.507000e+05,
         3.164000e+05, -9.500000e+03, -1.540000e+04,  0.000000e+00,
         2.630000e+04,  2.680000e+04, -1.206000e+05, -2.640000e+04,
         3.400000e+04,  3.400000e+04, -3.110000e+04, -3.110000e+04,
        -3.110000e+04,  1.687200e+06,  6.620000e+04,  8.088000e+05,
         1.182100e+06,  1.022400e+06,  5.250000e+04,  9.406000e+05,
         1.365000e+05,  2.432000e+06,  1.649000e+05,  2.432000e+06,
         1.680000e+05,  1.558300e+06,  9.639000e+05,  5.263000e+05,
        -3.299000e+05,  2.768000e+05, -4.770000e+04,  2.323000e+05,
        -2.650000e+05,  1.688000e+05, -1.544000e+05, -8.310000e+04,
        -1.879000e+05,  7.881000e+05, -1.819000e+05, -1.367000e+05,
         3.542000e+05,  9.911000e+05,  1.050400e+06,  1.592300e+06,
         1.153600e+06,  2.030900e+06, -2.960000e+04,  5.100000e+04,
         5.305000e+05, -1.182000e+05,  2.400000e+03,  1.053200e+06,
         7.720000e+04,  6.197000e+05,  1.900000e+03,  9.676000e+05,
         8.530000e+04,  1.021000e+06, -4.320000e+04, -1.282000e+05,
        -8.580000e+04,  1.014900e+06,  1.014800e+06,  3.940000e+04,
        -1.670000e+04,  1.605300e+06,  1.632140e+07,  6.700000e+03,
         6.700000e+03, -1.747000e+05, -1.749000e+05, -9.800000e+04,
        -1.747000e+05, -3.057000e+05, -1.749000e+05,  2.310000e+04,
         2.310000e+04,  2.310000e+04,  2.310000e+04,  4.420000e+04,
        -3.170000e+04, -3.170000e+04, -3.170000e+04,  1.703000e+05,
         6.051000e+05,  0.000000e+00, -3.460000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.904000e+05, -2.138000e+05, -1.943000e+05,
        -3.496000e+05, -5.140000e+04, -5.100000e+04,  1.860000e+04,
         1.880000e+04, -1.620000e+04, -4.590000e+04, -2.640000e+04,
         2.604000e+05, -2.830000e+04, -2.100000e+03, -7.900000e+03,
        -9.010000e+04,  3.448000e+05, -5.300000e+03, -5.600000e+03,
         0.000000e+00,  0.000000e+00, -1.130000e+04,  2.761000e+05,
        -2.890000e+04, -6.400000e+03, -6.300000e+03, -6.300000e+03,
         0.000000e+00,  0.000000e+00,  2.302000e+05, -9.320000e+04,
        -8.100000e+03,  1.030000e+05,  5.363000e+05, -2.670000e+04,
         3.146000e+05,  2.808000e+05, -4.490000e+04, -2.500000e+03,
        -5.560000e+04, -5.560000e+04,  3.073000e+05, -4.600000e+03,
         8.000000e+02,  2.494000e+05, -6.060000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.000000e+02, -9.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.604000e+05,
        -4.590000e+04, -1.180000e+04, -5.600000e+03, -5.300000e+03,
         2.310000e+04,  2.000000e+02,  6.726000e+05,  1.830000e+04,
        -3.110000e+04,  6.891000e+05,  3.164000e+05, -6.720000e+04,
        -9.800000e+04, -1.749000e+05,  6.700000e+03, -3.170000e+04,
        -1.943000e+05, -2.640000e+04, -6.300000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.310000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 2.723000e+05,  1.730000e+04,  3.020000e+04, -3.310000e+04,
         1.191000e+05,  1.191900e+06,  6.473000e+05,  3.969000e+05,
         1.730000e+04,  3.847000e+05,  1.720000e+04,  2.114000e+05,
         3.750000e+04, -5.270000e+04,  0.000000e+00,  2.114000e+05,
        -2.540000e+04,  2.149000e+05,  4.000000e+03,  7.852000e+05,
         0.000000e+00,  3.860000e+05,  7.100000e+03,  2.360000e+04,
        -6.730000e+04, -2.050000e+04,  5.420000e+04,  4.363000e+05,
        -1.760000e+04,  2.316000e+05,  4.317000e+05, -2.110000e+04,
        -1.557000e+05, -3.020000e+04, -3.010000e+04, -3.040000e+04,
        -3.020000e+04, -5.460000e+04, -3.020000e+04,  1.899000e+05,
        -3.159000e+05, -2.933000e+05,  9.400000e+04, -3.290000e+04,
        -2.680000e+04,  8.580000e+04, -9.460000e+04, -6.630000e+04,
        -6.630000e+04, -4.250000e+04, -1.900000e+04, -3.700000e+04,
        -3.520000e+04,  1.780000e+04, -1.089000e+05,  9.700000e+03,
        -8.490000e+04,  1.139000e+05, -3.830000e+04, -9.450000e+04,
         2.533000e+05,  2.532000e+05,  1.700000e+03,  1.170000e+04,
         8.540000e+05,  1.960000e+05,  3.103000e+05,  1.104600e+06,
        -1.510000e+04,  8.100000e+03,  1.860000e+04, -1.420000e+04,
         1.230000e+04,  2.931000e+05,  2.931000e+05,  2.931000e+05,
         2.932000e+05,  3.990000e+04,  3.990000e+04,  9.260000e+04,
         1.425000e+05,  1.530000e+04, -6.500000e+03,  0.000000e+00,
         1.700000e+04,  1.880000e+04, -5.750000e+04,  5.100000e+03,
         2.310000e+04,  2.310000e+04, -5.200000e+03, -5.200000e+03,
        -5.200000e+03,  7.461000e+05,  1.128000e+05,  3.449000e+05,
         4.772000e+05,  4.478000e+05,  6.850000e+04,  3.747000e+05,
         1.161000e+05,  1.047000e+06,  1.608000e+05,  1.047100e+06,
         1.620000e+05,  6.470000e+05,  3.271000e+05,  1.268000e+05,
        -1.787000e+05,  1.158000e+05, -1.090000e+04,  2.232000e+05,
        -1.203000e+05,  7.870000e+04, -4.760000e+04, -3.700000e+04,
        -8.780000e+04,  3.037000e+05, -7.530000e+04, -5.870000e+04,
         1.047000e+05,  3.929000e+05,  4.603000e+05,  6.354000e+05,
         4.350000e+05,  8.359000e+05,  2.200000e+03,  3.140000e+04,
         2.091000e+05, -4.420000e+04,  3.700000e+04,  4.607000e+05,
         7.990000e+04,  2.620000e+05,  3.730000e+04,  3.862000e+05,
         8.220000e+04,  4.473000e+05, -8.200000e+03, -4.000000e+04,
        -1.620000e+04,  4.183000e+05,  4.183000e+05,  3.700000e+04,
         5.960000e+04,  6.929000e+05,  6.740900e+06,  1.570000e+04,
         1.570000e+04, -6.730000e+04, -6.740000e+04, -3.500000e+04,
        -6.750000e+04, -1.273000e+05, -6.740000e+04,  2.250000e+04,
         2.250000e+04,  2.250000e+04,  2.260000e+04,  4.560000e+04,
        -2.650000e+04, -2.650000e+04, -2.650000e+04,  4.590000e+04,
         3.010000e+05,  0.000000e+00, -3.020000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.589000e+05, -1.106000e+05, -8.900000e+04,
        -1.330000e+05,  9.900000e+03,  9.700000e+03,  7.710000e+04,
         7.700000e+04, -6.900000e+03, -2.430000e+04, -1.020000e+04,
         1.010000e+05, -4.160000e+04, -2.000000e+03, -3.900000e+03,
        -5.270000e+04,  2.048000e+05, -5.000000e+03, -2.200000e+03,
         0.000000e+00,  0.000000e+00, -5.900000e+03,  1.063000e+05,
        -1.270000e+04, -5.600000e+03, -5.500000e+03, -5.500000e+03,
         0.000000e+00,  0.000000e+00,  7.060000e+04, -5.540000e+04,
        -7.700000e+03,  3.870000e+04,  2.072000e+05, -1.180000e+04,
         1.212000e+05,  1.027000e+05, -2.660000e+04, -2.600000e+03,
        -2.810000e+04, -2.810000e+04,  1.184000e+05, -3.300000e+03,
        -6.000000e+02,  8.950000e+04, -3.150000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02, -3.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.010000e+05,
        -2.430000e+04, -6.900000e+03, -2.200000e+03, -5.000000e+03,
         2.250000e+04, -1.000000e+02,  2.723000e+05,  1.730000e+04,
        -5.200000e+03,  2.931000e+05,  1.425000e+05, -3.020000e+04,
        -3.500000e+04, -6.740000e+04,  1.570000e+04, -2.650000e+04,
        -8.900000e+04, -1.020000e+04, -5.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.250000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.550000e+04,  3.932000e+05,  3.280000e+04, -3.000000e+02,
         7.600000e+03,  4.930000e+04,  1.830000e+04,  1.730000e+04,
         8.242000e+05,  1.770000e+04,  3.980000e+05,  3.290000e+04,
         2.227000e+05, -6.960000e+04,  0.000000e+00,  3.290000e+04,
         2.440000e+04,  3.310000e+04,  2.580000e+04,  1.312000e+05,
         0.000000e+00,  2.730000e+04,  5.558000e+05,  5.710000e+04,
        -5.000000e+02,  3.622000e+05,  9.354000e+05,  9.690000e+04,
         7.300000e+04,  1.894000e+05,  2.915000e+05,  5.620000e+05,
        -3.180000e+04, -1.900000e+04, -1.900000e+04, -1.840000e+04,
        -1.910000e+04, -6.170000e+04, -1.900000e+04, -3.199000e+05,
         3.844000e+05, -2.802000e+05, -3.690000e+04,  1.386000e+05,
        -2.690000e+04,  7.500000e+03, -2.490000e+04, -1.290000e+04,
        -1.290000e+04,  1.706000e+05,  3.527000e+05,  1.860000e+04,
         1.300000e+03, -4.700000e+03,  1.711000e+05,  1.088600e+06,
        -7.140000e+04,  3.170000e+04,  2.390000e+04, -2.490000e+04,
         7.740000e+04,  7.740000e+04,  4.359000e+05,  9.730000e+04,
        -7.400000e+03,  7.740000e+04,  2.150000e+04,  9.200000e+03,
        -5.700000e+03,  7.500000e+04,  3.830000e+04, -3.910000e+04,
         2.410000e+04,  6.470000e+04,  6.470000e+04,  6.470000e+04,
         6.470000e+04,  4.440000e+05,  4.439000e+05, -3.740000e+04,
         5.580000e+04,  2.450000e+05, -4.900000e+03,  0.000000e+00,
         1.766000e+05,  2.990000e+04, -4.660000e+04,  4.650000e+04,
         3.710000e+04,  3.710000e+04,  2.420000e+04,  2.420000e+04,
         2.430000e+04,  2.587000e+05,  1.206700e+06,  5.170000e+04,
         3.300000e+03,  1.372000e+05,  7.057000e+05, -1.850000e+04,
         1.030300e+06,  2.766000e+05,  1.604000e+06,  2.766000e+05,
         1.604500e+06,  7.280000e+04, -2.489000e+05, -3.508000e+05,
         5.006000e+05,  1.310000e+04,  1.889000e+05,  3.523600e+06,
        -5.980000e+04,  4.220000e+04,  2.184000e+05, -2.440000e+04,
        -6.860000e+04, -4.480000e+04,  5.181000e+05, -1.500000e+04,
        -1.469000e+05, -5.300000e+03,  1.462000e+05, -7.400000e+03,
        -1.098000e+05,  9.490000e+04,  8.715000e+05,  4.220000e+04,
        -2.450000e+04,  3.270000e+05,  1.318000e+05,  1.471000e+05,
         6.735000e+05,  4.520000e+04,  1.335000e+05, -1.060000e+04,
         7.167000e+05,  2.014000e+05,  3.010000e+04,  2.500000e+04,
         2.085000e+05,  4.600000e+04,  4.610000e+04,  6.151000e+05,
         1.105300e+06,  2.263000e+05,  8.647000e+05,  4.520000e+04,
         4.530000e+04,  9.900000e+03,  1.000000e+04, -1.000000e+02,
         9.900000e+03, -1.180000e+04,  1.000000e+04,  5.070000e+04,
         5.070000e+04,  5.070000e+04,  5.070000e+04,  4.850000e+04,
        -5.210000e+04, -5.200000e+04, -5.200000e+04, -8.200000e+04,
         2.040000e+04,  0.000000e+00, -3.100000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.123000e+05, -8.980000e+04, -3.990000e+04,
        -2.450000e+04,  1.018000e+05,  1.023000e+05,  2.544000e+05,
         2.543000e+05, -5.500000e+03, -2.390000e+04, -2.670000e+04,
        -1.240000e+04,  1.759000e+05,  1.178000e+05, -2.800000e+03,
        -6.960000e+04,  3.280000e+04,  2.926000e+05,  3.000000e+02,
         0.000000e+00, -2.200000e+03, -3.050000e+04, -4.200000e+04,
         1.285000e+05, -1.150000e+04, -1.160000e+04, -1.160000e+04,
         0.000000e+00,  0.000000e+00, -8.720000e+04,  8.860000e+04,
         4.507000e+05,  8.460000e+04, -5.430000e+04,  1.189000e+05,
        -1.750000e+04, -1.270000e+04, -3.550000e+04,  1.460000e+05,
        -2.440000e+04, -2.440000e+04, -1.550000e+04,  1.562000e+05,
        -3.100000e+03, -3.990000e+04,  1.319000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  3.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.240000e+04,
        -2.390000e+04, -9.100000e+03,  3.000000e+02,  2.926000e+05,
         5.070000e+04,  0.000000e+00,  1.550000e+04,  3.932000e+05,
         2.420000e+04,  6.470000e+04,  5.580000e+04, -1.910000e+04,
        -1.000000e+02,  1.000000e+04,  4.530000e+04, -5.200000e+04,
        -3.990000e+04, -2.670000e+04, -1.160000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         5.070000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 2.695000e+05,  1.770000e+04,  2.910000e+04, -3.260000e+04,
         1.180000e+05,  1.181300e+06,  6.423000e+05,  3.847000e+05,
         1.770000e+04,  4.096000e+05,  1.760000e+04,  2.238000e+05,
         3.960000e+04, -5.310000e+04,  0.000000e+00,  2.238000e+05,
        -2.510000e+04,  2.283000e+05,  4.200000e+03,  8.137000e+05,
         0.000000e+00,  3.825000e+05,  8.100000e+03,  2.270000e+04,
        -6.630000e+04, -1.930000e+04,  5.540000e+04,  4.332000e+05,
        -1.630000e+04,  2.322000e+05,  4.315000e+05, -1.750000e+04,
        -1.531000e+05, -3.010000e+04, -3.000000e+04, -3.020000e+04,
        -3.010000e+04, -5.490000e+04, -3.010000e+04,  1.840000e+05,
        -3.156000e+05, -2.957000e+05,  9.260000e+04, -3.280000e+04,
        -2.730000e+04,  8.520000e+04, -9.360000e+04, -6.540000e+04,
        -6.540000e+04, -4.150000e+04, -1.790000e+04, -3.670000e+04,
        -3.460000e+04,  1.810000e+04, -1.070000e+05,  1.210000e+04,
        -8.480000e+04,  1.132000e+05, -3.740000e+04, -9.360000e+04,
         2.520000e+05,  2.519000e+05,  3.400000e+03,  1.220000e+04,
         8.499000e+05,  1.945000e+05,  3.086000e+05,  1.096400e+06,
        -1.460000e+04,  8.900000e+03,  1.880000e+04, -1.450000e+04,
         1.280000e+04,  2.909000e+05,  2.909000e+05,  2.909000e+05,
         2.911000e+05,  4.080000e+04,  4.070000e+04,  9.130000e+04,
         1.417000e+05,  1.610000e+04, -6.300000e+03,  0.000000e+00,
         1.740000e+04,  1.920000e+04, -5.750000e+04,  5.900000e+03,
         2.290000e+04,  2.290000e+04, -4.700000e+03, -4.700000e+03,
        -4.700000e+03,  7.419000e+05,  1.162000e+05,  3.424000e+05,
         4.723000e+05,  4.455000e+05,  7.080000e+04,  3.711000e+05,
         1.186000e+05,  1.040000e+06,  1.644000e+05,  1.040000e+06,
         1.655000e+05,  6.415000e+05,  3.205000e+05,  1.211000e+05,
        -1.791000e+05,  1.149000e+05, -1.030000e+04,  2.282000e+05,
        -1.198000e+05,  7.850000e+04, -4.630000e+04, -3.670000e+04,
        -8.760000e+04,  2.998000e+05, -7.470000e+04, -6.000000e+04,
         1.015000e+05,  3.885000e+05,  4.577000e+05,  6.286000e+05,
         4.289000e+05,  8.283000e+05,  3.000000e+03,  2.900000e+04,
         2.067000e+05, -4.350000e+04,  3.860000e+04,  4.580000e+05,
         8.180000e+04,  2.600000e+05,  3.890000e+04,  3.822000e+05,
         8.410000e+04,  4.459000e+05, -7.600000e+03, -3.890000e+04,
        -1.510000e+04,  4.139000e+05,  4.139000e+05,  3.790000e+04,
         6.280000e+04,  6.884000e+05,  6.680100e+06,  1.640000e+04,
         1.640000e+04, -6.650000e+04, -6.650000e+04, -3.440000e+04,
        -6.660000e+04, -1.262000e+05, -6.650000e+04,  2.310000e+04,
         2.310000e+04,  2.310000e+04,  2.320000e+04,  4.940000e+04,
        -2.690000e+04, -2.680000e+04, -2.690000e+04,  4.570000e+04,
         3.115000e+05,  0.000000e+00, -3.230000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.612000e+05, -1.109000e+05, -8.870000e+04,
        -1.312000e+05,  1.150000e+04,  1.130000e+04,  8.030000e+04,
         8.020000e+04, -6.700000e+03, -2.450000e+04, -1.020000e+04,
         1.017000e+05, -4.730000e+04, -2.100000e+03, -3.700000e+03,
        -5.310000e+04,  2.158000e+05, -5.200000e+03, -2.100000e+03,
         0.000000e+00,  0.000000e+00, -6.400000e+03,  1.052000e+05,
        -1.280000e+04, -5.700000e+03, -5.600000e+03, -5.600000e+03,
         0.000000e+00,  0.000000e+00,  6.880000e+04, -5.580000e+04,
        -7.900000e+03,  3.810000e+04,  2.069000e+05, -1.180000e+04,
         1.197000e+05,  1.032000e+05, -2.680000e+04, -2.600000e+03,
        -2.810000e+04, -2.810000e+04,  1.173000e+05, -3.300000e+03,
        -7.000000e+02,  8.840000e+04, -3.150000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02, -3.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.017000e+05,
        -2.450000e+04, -7.000000e+03, -2.100000e+03, -5.200000e+03,
         2.310000e+04, -1.000000e+02,  2.695000e+05,  1.770000e+04,
        -4.700000e+03,  2.909000e+05,  1.417000e+05, -3.010000e+04,
        -3.440000e+04, -6.650000e+04,  1.640000e+04, -2.690000e+04,
        -8.870000e+04, -1.020000e+04, -5.600000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.310000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.540000e+04,  3.922000e+05,  3.270000e+04, -3.000000e+02,
         7.600000e+03,  4.910000e+04,  1.820000e+04,  1.720000e+04,
         3.980000e+05,  1.760000e+04,  4.999000e+05,  3.260000e+04,
         2.735000e+05, -6.950000e+04,  0.000000e+00,  3.260000e+04,
         2.440000e+04,  3.280000e+04,  3.160000e+04,  1.303000e+05,
         0.000000e+00,  2.710000e+04,  5.557000e+05,  5.690000e+04,
        -5.000000e+02,  3.613000e+05,  1.019300e+06,  9.670000e+04,
         7.280000e+04,  1.889000e+05,  2.908000e+05,  5.607000e+05,
        -3.120000e+04, -1.900000e+04, -1.900000e+04, -1.840000e+04,
        -1.910000e+04, -6.160000e+04, -1.900000e+04, -3.195000e+05,
         3.849000e+05, -2.798000e+05, -3.680000e+04,  1.387000e+05,
        -2.690000e+04,  7.400000e+03, -2.490000e+04, -1.260000e+04,
        -1.270000e+04,  1.702000e+05,  3.518000e+05,  1.860000e+04,
         1.400000e+03, -4.400000e+03,  1.714000e+05,  1.085800e+06,
        -7.130000e+04,  3.160000e+04,  2.380000e+04, -2.490000e+04,
         7.720000e+04,  7.710000e+04,  4.355000e+05,  9.700000e+04,
        -7.400000e+03,  7.720000e+04,  2.150000e+04,  9.300000e+03,
        -5.700000e+03,  7.480000e+04,  3.830000e+04, -3.910000e+04,
         2.390000e+04,  6.450000e+04,  6.450000e+04,  6.450000e+04,
         6.450000e+04,  4.429000e+05,  4.428000e+05, -3.730000e+04,
         5.570000e+04,  2.444000e+05, -4.900000e+03,  0.000000e+00,
         1.760000e+05,  2.990000e+04, -4.650000e+04,  4.660000e+04,
         3.700000e+04,  3.700000e+04,  2.420000e+04,  2.420000e+04,
         2.420000e+04,  2.581000e+05,  1.203500e+06,  5.160000e+04,
         3.300000e+03,  1.368000e+05,  7.038000e+05, -1.850000e+04,
         1.028300e+06,  2.759000e+05,  1.599700e+06,  2.759000e+05,
         1.600300e+06,  7.260000e+04, -2.484000e+05, -3.502000e+05,
         4.994000e+05,  1.300000e+04,  1.888000e+05,  3.514600e+06,
        -5.970000e+04,  4.210000e+04,  2.182000e+05, -2.430000e+04,
        -6.830000e+04, -4.480000e+04,  5.168000e+05, -1.500000e+04,
        -1.465000e+05, -5.400000e+03,  1.459000e+05, -7.500000e+03,
        -1.096000e+05,  9.450000e+04,  8.714000e+05,  4.210000e+04,
        -2.460000e+04,  3.270000e+05,  1.315000e+05,  1.467000e+05,
         6.732000e+05,  4.510000e+04,  1.332000e+05, -1.070000e+04,
         7.148000e+05,  2.000000e+05,  3.000000e+04,  2.510000e+04,
         2.080000e+05,  4.590000e+04,  4.590000e+04,  6.134000e+05,
         1.103500e+06,  2.245000e+05,  8.618000e+05,  4.510000e+04,
         4.510000e+04,  9.900000e+03,  9.900000e+03,  1.000000e+02,
         9.900000e+03, -1.170000e+04,  9.900000e+03,  5.060000e+04,
         5.060000e+04,  5.060000e+04,  5.050000e+04,  4.810000e+04,
        -5.190000e+04, -5.190000e+04, -5.190000e+04, -8.180000e+04,
         2.030000e+04,  0.000000e+00, -3.080000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.116000e+05, -8.950000e+04, -3.980000e+04,
        -2.390000e+04,  1.017000e+05,  1.021000e+05,  2.539000e+05,
         2.539000e+05, -5.500000e+03, -2.390000e+04, -2.670000e+04,
        -1.230000e+04,  2.270000e+05,  1.175000e+05, -2.800000e+03,
        -6.950000e+04,  3.260000e+04,  2.917000e+05,  3.000000e+02,
         0.000000e+00, -2.200000e+03, -3.050000e+04, -4.200000e+04,
         1.286000e+05, -1.150000e+04, -1.150000e+04, -1.150000e+04,
         0.000000e+00,  0.000000e+00, -8.700000e+04,  8.850000e+04,
         4.496000e+05,  8.440000e+04, -5.420000e+04,  1.189000e+05,
        -1.740000e+04, -1.270000e+04, -3.540000e+04,  1.455000e+05,
        -2.440000e+04, -2.440000e+04, -1.550000e+04,  1.561000e+05,
        -3.100000e+03, -3.980000e+04,  1.318000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  3.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.230000e+04,
        -2.390000e+04, -9.100000e+03,  3.000000e+02,  2.917000e+05,
         5.060000e+04,  0.000000e+00,  1.540000e+04,  3.922000e+05,
         2.420000e+04,  6.450000e+04,  5.570000e+04, -1.910000e+04,
         1.000000e+02,  9.900000e+03,  4.510000e+04, -5.190000e+04,
        -3.980000e+04, -2.670000e+04, -1.150000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         5.060000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.517000e+05,  3.290000e+04,  3.840000e+04, -1.440000e+04,
         6.840000e+04,  6.484000e+05,  3.449000e+05,  2.114000e+05,
         3.290000e+04,  2.238000e+05,  3.260000e+04,  2.321000e+05,
         1.148000e+05, -6.730000e+04,  0.000000e+00,  2.321000e+05,
        -5.400000e+03,  1.692000e+05,  1.070000e+04,  6.723000e+05,
         0.000000e+00,  2.247000e+05,  4.810000e+04,  5.540000e+04,
        -2.360000e+04,  3.330000e+04,  1.044000e+05,  2.907000e+05,
         4.200000e+04,  2.480000e+05,  4.127000e+05,  1.301000e+05,
        -2.940000e+04, -2.370000e+04, -2.350000e+04, -2.370000e+04,
        -2.390000e+04, -6.240000e+04, -2.350000e+04, -6.330000e+04,
        -2.977000e+05, -2.890000e+05,  3.030000e+04, -2.910000e+04,
        -2.620000e+04,  5.380000e+04, -5.750000e+04, -2.810000e+04,
        -2.810000e+04,  6.000000e+02,  2.910000e+04,  2.700000e+03,
        -9.100000e+03,  3.100000e+04, -2.820000e+04,  1.151000e+05,
        -8.160000e+04,  8.270000e+04, -1.000000e+02, -5.710000e+04,
         1.898000e+05,  1.898000e+05,  7.280000e+04,  7.700000e+04,
         4.285000e+05,  1.654000e+05,  1.728000e+05,  4.805000e+05,
         1.020000e+04,  4.840000e+04,  3.390000e+04, -1.390000e+04,
         3.920000e+04,  1.947000e+05,  1.947000e+05,  1.947000e+05,
         1.948000e+05,  7.650000e+04,  7.640000e+04,  2.980000e+04,
         1.120000e+05,  5.270000e+04, -3.700000e+03,  0.000000e+00,
         2.480000e+04,  2.950000e+04, -5.270000e+04,  3.930000e+04,
         3.610000e+04,  3.610000e+04,  1.430000e+04,  1.430000e+04,
         1.430000e+04,  5.591000e+05,  2.634000e+05,  2.293000e+05,
         2.637000e+05,  3.273000e+05,  1.499000e+05,  1.942000e+05,
         2.079000e+05,  7.241000e+05,  3.102000e+05,  7.241000e+05,
         3.108000e+05,  3.943000e+05,  3.210000e+04, -1.327000e+05,
        -2.039000e+05,  7.350000e+04,  1.430000e+04,  4.293000e+05,
        -9.660000e+04,  6.780000e+04,  9.100000e+03, -2.770000e+04,
        -7.620000e+04,  1.318000e+05, -4.510000e+04, -3.750000e+04,
        -3.270000e+04,  2.026000e+05,  3.349000e+05,  3.323000e+05,
         1.673000e+05,  4.973000e+05,  3.680000e+04,  5.020000e+04,
         1.035000e+05, -1.480000e+04,  1.055000e+05,  3.347000e+05,
         1.567000e+05,  1.706000e+05,  1.068000e+05,  2.001000e+05,
         1.580000e+05,  3.266000e+05,  1.830000e+04,  5.400000e+03,
         3.400000e+04,  2.485000e+05,  2.484000e+05,  7.090000e+04,
         1.913000e+05,  4.869000e+05,  4.068200e+06,  3.940000e+04,
         3.950000e+04, -2.920000e+04, -2.920000e+04, -9.000000e+03,
        -2.930000e+04, -7.880000e+04, -2.920000e+04,  4.350000e+04,
         4.350000e+04,  4.350000e+04,  4.380000e+04,  1.083000e+05,
        -4.450000e+04, -4.450000e+04, -4.450000e+04, -3.320000e+04,
         2.448000e+05,  0.000000e+00, -6.500000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.670000e+05, -1.158000e+05, -7.250000e+04,
        -5.530000e+04,  7.790000e+04,  7.770000e+04,  2.081000e+05,
         2.080000e+05, -4.100000e+03, -2.590000e+04, -4.300000e+03,
         4.050000e+04, -4.160000e+04, -3.900000e+03, -4.400000e+03,
        -6.730000e+04,  2.173000e+05, -9.600000e+03, -9.000000e+02,
         0.000000e+00,  0.000000e+00, -5.500000e+03,  4.570000e+04,
        -9.300000e+03, -1.020000e+04, -1.020000e+04, -1.020000e+04,
         0.000000e+00,  0.000000e+00, -1.370000e+04, -7.230000e+04,
        -1.470000e+04,  1.440000e+04,  8.610000e+04, -8.600000e+03,
         5.270000e+04,  4.140000e+04, -3.420000e+04, -4.800000e+03,
        -2.850000e+04, -2.850000e+04,  5.100000e+04, -5.200000e+03,
        -2.200000e+03,  2.210000e+04, -3.370000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  1.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.050000e+04,
        -2.590000e+04, -8.800000e+03, -9.000000e+02, -9.600000e+03,
         4.350000e+04, -1.000000e+02,  1.517000e+05,  3.290000e+04,
         1.430000e+04,  1.947000e+05,  1.120000e+05, -2.390000e+04,
        -9.000000e+03, -2.920000e+04,  3.950000e+04, -4.450000e+04,
        -7.250000e+04, -4.300000e+03, -1.020000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.350000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 2.700000e+04,  2.198000e+05,  4.110000e+04,  1.300000e+03,
         1.410000e+04,  9.110000e+04,  3.710000e+04,  3.750000e+04,
         2.227000e+05,  3.960000e+04,  2.735000e+05,  1.148000e+05,
         5.996000e+05, -7.520000e+04,  0.000000e+00,  1.148000e+05,
         1.900000e+04,  7.440000e+04,  4.560000e+04,  3.104000e+05,
         0.000000e+00,  4.990000e+04,  3.210000e+05,  7.310000e+04,
         8.500000e+03,  2.225000e+05,  5.853000e+05,  1.250000e+05,
         8.540000e+04,  2.258000e+05,  3.425000e+05,  4.162000e+05,
         2.920000e+04, -1.820000e+04, -1.810000e+04, -1.790000e+04,
        -1.840000e+04, -6.560000e+04, -1.810000e+04, -3.101000e+05,
         5.230000e+04, -2.791000e+05, -3.320000e+04,  5.660000e+04,
        -2.550000e+04,  1.550000e+04, -2.400000e+04, -2.400000e+03,
        -2.400000e+03,  1.056000e+05,  2.130000e+05,  3.000000e+04,
         8.400000e+03,  1.940000e+04,  1.095000e+05,  6.498000e+05,
        -7.480000e+04,  4.250000e+04,  2.970000e+04, -2.350000e+04,
         1.034000e+05,  1.034000e+05,  2.874000e+05,  1.189000e+05,
         3.200000e+03,  1.069000e+05,  3.070000e+04, -4.790000e+04,
         1.420000e+04,  8.070000e+04,  4.340000e+04, -2.600000e+04,
         4.430000e+04,  8.320000e+04,  8.320000e+04,  8.320000e+04,
         8.330000e+04,  2.768000e+05,  2.766000e+05, -3.350000e+04,
         6.960000e+04,  1.662000e+05, -3.100000e+03,  0.000000e+00,
         1.038000e+05,  3.450000e+04, -4.730000e+04,  5.890000e+04,
         4.340000e+04,  4.340000e+04,  2.840000e+04,  2.840000e+04,
         2.840000e+04,  3.206000e+05,  8.041000e+05,  8.590000e+04,
         3.340000e+04,  1.749000e+05,  4.645000e+05,  2.500000e+03,
         6.606000e+05,  3.477000e+05,  1.024600e+06,  3.477000e+05,
         1.025100e+06,  1.143000e+05, -2.470000e+05, -3.636000e+05,
         1.357000e+05,  2.330000e+04,  1.134000e+05,  2.068000e+06,
        -6.690000e+04,  4.980000e+04,  1.402000e+05, -2.180000e+04,
        -6.670000e+04, -3.730000e+04,  2.500000e+05, -1.400000e+04,
        -1.540000e+05,  9.300000e+03,  1.811000e+05,  1.990000e+04,
        -9.700000e+04,  1.367000e+05,  4.703000e+05,  5.870000e+04,
        -1.020000e+04,  1.699000e+05,  1.505000e+05,  1.812000e+05,
         4.507000e+05,  6.480000e+04,  1.525000e+05,  7.000000e+03,
         4.718000e+05,  2.049000e+05,  3.660000e+04,  3.650000e+04,
         1.446000e+05,  6.810000e+04,  6.810000e+04,  3.580000e+05,
         7.089000e+05,  2.585000e+05,  1.209300e+06,  5.320000e+04,
         5.320000e+04,  8.300000e+03,  8.300000e+03,  7.800000e+03,
         8.200000e+03, -2.240000e+04,  8.300000e+03,  5.690000e+04,
         5.690000e+04,  5.690000e+04,  5.700000e+04,  1.050000e+05,
        -5.670000e+04, -5.660000e+04, -5.660000e+04, -9.590000e+04,
         8.220000e+04,  0.000000e+00, -6.270000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.400000e+05, -1.049000e+05, -4.830000e+04,
        -3.200000e+03,  1.216000e+05,  1.218000e+05,  2.923000e+05,
         2.922000e+05, -3.700000e+03, -2.540000e+04, -1.260000e+04,
        -1.720000e+04,  3.379000e+05,  5.600000e+04, -4.200000e+03,
        -7.520000e+04,  1.067000e+05,  1.389000e+05,  3.000000e+02,
         0.000000e+00, -1.100000e+03, -1.720000e+04, -2.710000e+04,
         6.140000e+04, -1.300000e+04, -1.310000e+04, -1.310000e+04,
         0.000000e+00,  0.000000e+00, -9.000000e+04,  2.000000e+02,
         2.141000e+05,  3.800000e+04, -4.420000e+04,  5.680000e+04,
        -1.460000e+04, -1.700000e+04, -3.830000e+04,  6.930000e+04,
        -2.660000e+04, -2.660000e+04, -1.450000e+04,  7.450000e+04,
        -3.300000e+03, -4.110000e+04,  4.790000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  4.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.720000e+04,
        -2.540000e+04, -9.900000e+03,  3.000000e+02,  1.389000e+05,
         5.690000e+04, -1.000000e+02,  2.700000e+04,  2.198000e+05,
         2.840000e+04,  8.320000e+04,  6.960000e+04, -1.840000e+04,
         7.800000e+03,  8.300000e+03,  5.320000e+04, -5.660000e+04,
        -4.830000e+04, -1.260000e+04, -1.310000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         5.690000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-5.080000e+04, -6.960000e+04, -5.530000e+04, -6.660000e+04,
        -5.860000e+04, -1.916000e+05, -9.010000e+04, -5.270000e+04,
        -6.960000e+04, -5.310000e+04, -6.950000e+04, -6.730000e+04,
        -7.520000e+04,  6.053000e+05,  0.000000e+00, -6.730000e+04,
        -7.480000e+04, -6.750000e+04, -8.700000e+03, -2.689000e+05,
         0.000000e+00,  3.168000e+05,  2.828000e+05,  3.084000e+05,
         2.844000e+05, -2.117000e+05, -2.164000e+05, -2.013000e+05,
        -2.247000e+05,  4.721000e+05, -1.116000e+05,  4.520000e+05,
         1.495700e+06,  4.342000e+05,  4.342000e+05,  4.337000e+05,
         4.352000e+05,  6.066000e+05,  4.342000e+05,  4.103500e+06,
         4.054400e+06,  4.092300e+06,  4.505000e+05,  4.393000e+05,
         4.477000e+05, -1.253000e+05, -1.257000e+05,  5.348000e+05,
         5.348000e+05,  2.845000e+05,  3.580000e+04,  2.924000e+05,
         3.549000e+05,  8.292000e+05,  8.179000e+05, -4.332000e+05,
         4.464000e+05, -1.332000e+05, -1.415000e+05, -1.261000e+05,
         6.483000e+05,  6.482000e+05,  6.276000e+05,  6.427000e+05,
        -6.680000e+04, -1.452000e+05, -6.410000e+04, -1.204000e+05,
        -7.680000e+04, -1.585000e+05, -6.360000e+04,  2.150000e+04,
        -8.250000e+04, -1.335000e+05, -1.335000e+05, -1.335000e+05,
        -1.335000e+05, -1.534000e+05, -1.534000e+05,  4.500000e+05,
        -1.413000e+05, -1.509000e+05,  5.300000e+03,  0.000000e+00,
        -2.457000e+05, -2.538000e+05,  4.404000e+05,  9.060000e+04,
        -6.170000e+04, -6.170000e+04, -7.480000e+04, -7.480000e+04,
        -7.480000e+04, -5.663000e+05, -6.158000e+05,  5.982000e+05,
         2.629000e+05, -2.726000e+05, -3.015000e+05, -1.840000e+04,
        -8.090000e+05, -5.505000e+05, -6.202000e+05, -5.505000e+05,
        -6.208000e+05,  6.151000e+05,  1.965600e+06,  2.549000e+06,
         1.925500e+06,  3.675000e+05,  3.563000e+05, -8.842000e+05,
         5.088000e+05, -7.600000e+04, -8.750000e+04,  4.404000e+05,
         8.730000e+05,  4.180000e+04,  1.140000e+04,  3.350000e+04,
         6.267000e+05, -2.970000e+04, -2.830000e+05,  3.486000e+05,
         9.329000e+05, -2.356000e+05,  2.925000e+05,  3.347000e+05,
         8.189000e+05,  7.965000e+05,  1.805000e+05, -2.834000e+05,
        -3.169000e+05,  3.011000e+05,  1.824000e+05, -2.560000e+04,
        -3.140000e+05, -2.864000e+05,  3.461000e+05,  2.774000e+05,
         2.710000e+04, -1.146000e+05, -1.147000e+05, -1.463000e+05,
        -1.296000e+05, -7.350000e+04, -2.047300e+06, -7.750000e+04,
        -7.760000e+04, -9.300000e+03, -9.300000e+03,  3.540000e+05,
        -9.300000e+03, -3.690000e+05, -9.300000e+03, -8.380000e+04,
        -8.380000e+04, -8.380000e+04, -8.380000e+04, -8.190000e+04,
         8.220000e+04,  8.220000e+04,  8.220000e+04,  5.300000e+05,
        -5.610000e+04,  0.000000e+00,  5.060000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  4.932000e+05,  1.571000e+05,  7.390000e+04,
         1.069800e+06,  1.866000e+05,  1.869000e+05, -6.460000e+04,
        -6.460000e+04,  6.200000e+03,  8.100000e+03,  1.300000e+03,
         1.120000e+04,  5.000000e+03,  5.000000e+03,  5.200000e+03,
         5.187000e+05, -6.730000e+04,  1.310000e+04, -3.000000e+02,
         0.000000e+00,  0.000000e+00,  1.240000e+04,  1.600000e+04,
         6.800000e+03,  1.910000e+04,  1.920000e+04,  1.920000e+04,
         0.000000e+00,  0.000000e+00,  5.325000e+05,  5.236000e+05,
         1.900000e+04,  9.200000e+03,  2.720000e+04,  6.300000e+03,
         1.430000e+04,  1.150000e+04,  2.581000e+05,  6.500000e+03,
         7.700000e+03,  7.700000e+03,  1.470000e+04,  5.500000e+03,
         5.400000e+03,  2.230000e+04,  1.320000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.120000e+04,
         8.100000e+03,  6.800000e+04, -3.000000e+02,  1.310000e+04,
        -8.380000e+04,  0.000000e+00, -5.080000e+04, -6.960000e+04,
        -7.480000e+04, -1.335000e+05, -1.413000e+05,  4.351000e+05,
         3.540000e+05, -9.300000e+03, -7.760000e+04,  8.220000e+04,
         7.390000e+04,  1.300000e+03,  1.920000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -8.380000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.098890e+08,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.517000e+05,  3.290000e+04,  3.840000e+04, -1.440000e+04,
         6.840000e+04,  6.484000e+05,  3.449000e+05,  2.114000e+05,
         3.290000e+04,  2.238000e+05,  3.260000e+04,  2.321000e+05,
         1.148000e+05, -6.730000e+04,  0.000000e+00,  5.763000e+05,
        -5.400000e+03,  1.692000e+05,  1.070000e+04,  6.723000e+05,
         0.000000e+00,  2.247000e+05,  4.810000e+04,  5.540000e+04,
        -2.360000e+04,  3.330000e+04,  1.044000e+05,  2.907000e+05,
         4.200000e+04,  2.480000e+05,  4.127000e+05,  1.301000e+05,
        -2.940000e+04, -2.370000e+04, -2.350000e+04, -2.370000e+04,
        -2.390000e+04, -6.240000e+04, -2.350000e+04, -6.330000e+04,
        -2.977000e+05, -2.890000e+05,  3.030000e+04, -2.910000e+04,
        -2.620000e+04,  5.380000e+04, -5.750000e+04, -2.810000e+04,
        -2.810000e+04,  6.000000e+02,  2.910000e+04,  2.700000e+03,
        -9.100000e+03,  3.100000e+04, -2.820000e+04,  1.151000e+05,
        -8.160000e+04,  8.270000e+04, -1.000000e+02, -5.710000e+04,
         1.898000e+05,  1.898000e+05,  7.280000e+04,  7.700000e+04,
         4.285000e+05,  1.654000e+05,  1.728000e+05,  4.805000e+05,
         1.020000e+04,  4.840000e+04,  3.390000e+04, -1.390000e+04,
         3.920000e+04,  1.947000e+05,  1.947000e+05,  1.947000e+05,
         1.948000e+05,  7.650000e+04,  7.640000e+04,  2.980000e+04,
         1.120000e+05,  5.270000e+04, -3.700000e+03,  0.000000e+00,
         2.480000e+04,  2.950000e+04, -5.270000e+04,  3.930000e+04,
         3.610000e+04,  3.610000e+04,  1.430000e+04,  1.430000e+04,
         1.430000e+04,  5.591000e+05,  2.634000e+05,  2.293000e+05,
         2.637000e+05,  3.273000e+05,  1.499000e+05,  1.942000e+05,
         2.079000e+05,  7.241000e+05,  3.102000e+05,  7.241000e+05,
         3.108000e+05,  3.943000e+05,  3.210000e+04, -1.327000e+05,
        -2.039000e+05,  7.350000e+04,  1.430000e+04,  4.293000e+05,
        -9.660000e+04,  6.780000e+04,  9.100000e+03, -2.770000e+04,
        -7.620000e+04,  1.318000e+05, -4.510000e+04, -3.750000e+04,
        -3.270000e+04,  2.026000e+05,  3.349000e+05,  3.323000e+05,
         1.673000e+05,  4.973000e+05,  3.680000e+04,  5.020000e+04,
         1.035000e+05, -1.480000e+04,  1.055000e+05,  3.347000e+05,
         1.567000e+05,  1.706000e+05,  1.068000e+05,  2.001000e+05,
         1.580000e+05,  3.266000e+05,  1.830000e+04,  5.400000e+03,
         3.400000e+04,  2.485000e+05,  2.484000e+05,  7.090000e+04,
         1.913000e+05,  4.869000e+05,  4.068200e+06,  3.940000e+04,
         3.950000e+04, -2.920000e+04, -2.920000e+04, -9.000000e+03,
        -2.930000e+04, -7.880000e+04, -2.920000e+04,  4.350000e+04,
         4.350000e+04,  4.350000e+04,  4.380000e+04,  1.083000e+05,
        -4.450000e+04, -4.450000e+04, -4.450000e+04, -3.320000e+04,
         2.448000e+05,  0.000000e+00, -6.500000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.670000e+05, -1.158000e+05, -7.250000e+04,
        -5.530000e+04,  7.790000e+04,  7.770000e+04,  2.081000e+05,
         2.080000e+05, -4.100000e+03, -2.590000e+04, -4.300000e+03,
         4.050000e+04, -4.160000e+04, -3.900000e+03, -4.400000e+03,
        -6.730000e+04,  2.173000e+05, -9.600000e+03, -9.000000e+02,
         0.000000e+00,  0.000000e+00, -5.500000e+03,  4.570000e+04,
        -9.300000e+03, -1.020000e+04, -1.020000e+04, -1.020000e+04,
         0.000000e+00,  0.000000e+00, -1.370000e+04, -7.230000e+04,
        -1.470000e+04,  1.440000e+04,  8.610000e+04, -8.600000e+03,
         5.270000e+04,  4.140000e+04, -3.420000e+04, -4.800000e+03,
        -2.850000e+04, -2.850000e+04,  5.100000e+04, -5.200000e+03,
        -2.200000e+03,  2.210000e+04, -3.370000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  1.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.050000e+04,
        -2.590000e+04, -8.800000e+03, -9.000000e+02, -9.600000e+03,
         4.350000e+04, -1.000000e+02,  1.517000e+05,  3.290000e+04,
         1.430000e+04,  1.947000e+05,  1.120000e+05, -2.390000e+04,
        -9.000000e+03, -2.920000e+04,  3.950000e+04, -4.450000e+04,
        -7.250000e+04, -4.300000e+03, -1.020000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.350000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-6.400000e+03,  2.440000e+04,  2.350000e+04,  3.543000e+05,
         1.723000e+05, -4.200000e+04, -2.920000e+04, -2.540000e+04,
         2.440000e+04, -2.510000e+04,  2.440000e+04, -5.400000e+03,
         1.900000e+04, -7.480000e+04,  0.000000e+00, -5.400000e+03,
         1.253400e+06, -5.200000e+03,  2.200000e+03, -6.720000e+04,
         0.000000e+00, -3.030000e+04,  1.540000e+04,  1.570000e+04,
         5.053000e+05,  5.768000e+05,  7.780000e+04,  4.490000e+04,
         5.910000e+05,  7.210000e+04,  1.619000e+05,  1.028000e+05,
         3.203500e+06, -3.870000e+04, -3.880000e+04, -3.870000e+04,
        -3.860000e+04, -7.540000e+04, -3.880000e+04, -4.878000e+05,
        -4.274000e+05, -4.265000e+05, -6.000000e+04, -4.490000e+04,
        -4.470000e+04,  5.242000e+05,  8.591000e+05,  3.088000e+05,
         3.088000e+05,  3.422000e+05,  3.772000e+05,  3.421000e+05,
         1.537000e+05,  6.353000e+05,  6.505000e+05,  8.171000e+05,
         2.737000e+05,  3.697000e+05,  5.505000e+05,  8.577000e+05,
        -1.150000e+04, -1.150000e+04,  1.890000e+04,  1.920000e+04,
        -6.250000e+04,  4.430000e+04, -4.300000e+03, -5.490000e+04,
         1.834000e+05,  7.942000e+05,  2.780000e+04, -1.480000e+04,
         2.970000e+04,  2.970000e+04,  2.970000e+04,  2.970000e+04,
         2.960000e+04,  6.050000e+04,  6.050000e+04, -6.000000e+04,
         2.171000e+05,  2.322000e+05, -7.300000e+03,  0.000000e+00,
         2.480000e+04,  3.030000e+04,  1.185000e+05,  1.111000e+05,
         2.640000e+04,  2.640000e+04,  1.969000e+05,  1.969000e+05,
         1.987000e+05,  5.144000e+05,  5.913000e+05,  3.285000e+05,
         3.037000e+05,  6.590000e+04,  1.123000e+05, -4.960000e+04,
         1.758000e+05,  1.399000e+05,  2.478000e+05,  1.399000e+05,
         2.480000e+05, -3.920000e+04, -3.122000e+05, -4.019000e+05,
        -2.507000e+05, -2.400000e+04, -8.900000e+03,  3.272000e+05,
        -6.350000e+04,  2.620000e+04,  4.140000e+04, -4.610000e+04,
         7.870000e+04, -5.130000e+04, -6.200000e+03, -5.300000e+03,
        -1.410000e+05, -3.490000e+04,  8.060000e+04, -7.280000e+04,
        -1.625000e+05,  1.690000e+04,  3.100000e+03,  3.900000e+03,
        -8.420000e+04, -5.380000e+04,  6.890000e+04,  8.050000e+04,
         1.258000e+05, -9.200000e+03,  6.960000e+04, -3.520000e+04,
         1.269000e+05,  7.840000e+04, -3.300000e+03,  3.473000e+05,
         3.806000e+05,  7.000000e+03,  7.100000e+03,  5.470000e+04,
         1.545000e+05,  7.860000e+04,  2.069000e+05,  2.880000e+04,
         2.880000e+04,  1.140000e+04,  1.140000e+04,  1.531000e+05,
         1.140000e+04,  2.560000e+04,  1.140000e+04,  3.610000e+04,
         3.610000e+04,  3.610000e+04,  3.600000e+04,  1.500000e+04,
        -4.360000e+04, -4.350000e+04, -4.350000e+04, -9.090000e+04,
        -2.010000e+04,  0.000000e+00, -1.290000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.613000e+05, -6.060000e+04, -2.460000e+04,
         6.135000e+05,  2.255000e+05,  2.257000e+05,  3.340000e+05,
         3.340000e+05, -7.300000e+03,  1.548000e+05, -6.400000e+03,
        -1.610000e+04,  6.200000e+03, -4.700000e+03, -1.400000e+03,
        -7.480000e+04, -3.900000e+03, -1.170000e+04,  4.000000e+02,
         0.000000e+00, -3.000000e+02, -9.900000e+03, -2.800000e+04,
        -1.230000e+04, -8.300000e+03, -8.300000e+03, -8.300000e+03,
         0.000000e+00,  0.000000e+00, -9.620000e+04, -8.080000e+04,
        -1.780000e+04, -1.070000e+04, -4.420000e+04, -1.140000e+04,
        -2.100000e+04, -1.650000e+04, -3.770000e+04, -5.900000e+03,
         1.541000e+05,  1.541000e+05, -2.350000e+04, -7.300000e+03,
        -3.000000e+03,  1.316000e+05,  1.469000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.300000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.610000e+04,
         1.548000e+05, -9.800000e+03,  4.000000e+02, -1.170000e+04,
         3.610000e+04,  0.000000e+00, -6.400000e+03,  2.440000e+04,
         1.969000e+05,  2.970000e+04,  2.171000e+05, -3.860000e+04,
         1.531000e+05,  1.140000e+04,  2.880000e+04, -4.350000e+04,
        -2.460000e+04, -6.400000e+03, -8.300000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         3.610000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.509000e+05,  3.310000e+04,  3.810000e+04, -1.430000e+04,
         6.810000e+04,  6.452000e+05,  3.435000e+05,  2.149000e+05,
         3.310000e+04,  2.283000e+05,  3.280000e+04,  1.692000e+05,
         7.440000e+04, -6.750000e+04,  0.000000e+00,  1.692000e+05,
        -5.200000e+03,  1.806000e+05,  8.600000e+03,  6.116000e+05,
         0.000000e+00,  2.227000e+05,  4.850000e+04,  5.430000e+04,
        -2.340000e+04,  3.360000e+04,  1.051000e+05,  2.890000e+05,
         4.250000e+04,  2.481000e+05,  4.126000e+05,  1.317000e+05,
        -2.960000e+04, -2.360000e+04, -2.340000e+04, -2.370000e+04,
        -2.380000e+04, -6.250000e+04, -2.340000e+04, -6.600000e+04,
        -2.973000e+05, -2.905000e+05,  2.970000e+04, -2.900000e+04,
        -2.640000e+04,  5.360000e+04, -5.710000e+04, -2.790000e+04,
        -2.790000e+04,  9.000000e+02,  2.940000e+04,  2.500000e+03,
        -8.900000e+03,  3.080000e+04, -2.760000e+04,  1.161000e+05,
        -8.170000e+04,  8.250000e+04,  2.000000e+02, -5.670000e+04,
         1.891000e+05,  1.890000e+05,  7.350000e+04,  7.680000e+04,
         4.275000e+05,  1.584000e+05,  1.722000e+05,  5.263000e+05,
         1.030000e+04,  4.870000e+04,  3.400000e+04, -1.400000e+04,
         3.940000e+04,  1.936000e+05,  1.936000e+05,  1.936000e+05,
         1.938000e+05,  7.690000e+04,  7.680000e+04,  2.890000e+04,
         1.117000e+05,  5.300000e+04, -3.400000e+03,  0.000000e+00,
         2.510000e+04,  2.990000e+04, -5.280000e+04,  3.960000e+04,
         3.610000e+04,  3.610000e+04,  1.450000e+04,  1.450000e+04,
         1.440000e+04,  5.571000e+05,  2.650000e+05,  2.277000e+05,
         2.626000e+05,  3.265000e+05,  1.513000e+05,  1.932000e+05,
         2.094000e+05,  7.206000e+05,  3.118000e+05,  7.206000e+05,
         3.126000e+05,  3.915000e+05,  2.910000e+04, -1.354000e+05,
        -2.039000e+05,  7.300000e+04,  1.460000e+04,  4.317000e+05,
        -9.640000e+04,  6.770000e+04,  9.600000e+03, -2.730000e+04,
        -7.610000e+04,  1.299000e+05, -4.480000e+04, -3.850000e+04,
        -3.410000e+04,  2.020000e+05,  3.331000e+05,  3.295000e+05,
         1.647000e+05,  4.943000e+05,  3.740000e+04,  4.880000e+04,
         1.024000e+05, -1.450000e+04,  1.062000e+05,  3.333000e+05,
         1.571000e+05,  1.696000e+05,  1.076000e+05,  1.983000e+05,
         1.589000e+05,  3.265000e+05,  1.860000e+04,  5.700000e+03,
         3.440000e+04,  2.470000e+05,  2.469000e+05,  7.140000e+04,
         1.928000e+05,  4.849000e+05,  4.046300e+06,  3.990000e+04,
         3.990000e+04, -2.880000e+04, -2.880000e+04, -8.800000e+03,
        -2.890000e+04, -7.840000e+04, -2.880000e+04,  4.370000e+04,
         4.370000e+04,  4.370000e+04,  4.410000e+04,  1.165000e+05,
        -4.400000e+04, -4.400000e+04, -4.400000e+04, -2.930000e+04,
         1.974000e+05,  0.000000e+00, -6.950000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.642000e+05, -1.155000e+05, -7.210000e+04,
        -5.480000e+04,  7.850000e+04,  7.840000e+04,  2.094000e+05,
         2.093000e+05, -3.900000e+03, -2.600000e+04, -4.300000e+03,
         4.080000e+04, -4.800000e+04, -3.900000e+03, -4.300000e+03,
        -6.750000e+04,  1.618000e+05, -9.600000e+03, -9.000000e+02,
         0.000000e+00,  0.000000e+00, -6.000000e+03,  4.540000e+04,
        -9.300000e+03, -1.020000e+04, -1.020000e+04, -1.020000e+04,
         0.000000e+00,  0.000000e+00, -1.440000e+04, -7.250000e+04,
        -1.480000e+04,  1.420000e+04,  8.610000e+04, -8.600000e+03,
         5.210000e+04,  4.170000e+04, -3.430000e+04, -4.800000e+03,
        -2.840000e+04, -2.840000e+04,  5.070000e+04, -5.200000e+03,
        -2.200000e+03,  2.180000e+04, -3.370000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  1.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.080000e+04,
        -2.600000e+04, -8.900000e+03, -9.000000e+02, -9.600000e+03,
         4.370000e+04, -1.000000e+02,  1.509000e+05,  3.310000e+04,
         1.450000e+04,  1.936000e+05,  1.117000e+05, -2.380000e+04,
        -8.800000e+03, -2.880000e+04,  3.990000e+04, -4.400000e+04,
        -7.210000e+04, -4.300000e+03, -1.020000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.370000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 2.900000e+03,  2.540000e+04,  4.700000e+03,  2.000000e+02,
         1.600000e+03,  9.800000e+03,  3.900000e+03,  4.000000e+03,
         2.580000e+04,  4.200000e+03,  3.160000e+04,  1.070000e+04,
         4.560000e+04, -8.700000e+03,  0.000000e+00,  1.070000e+04,
         2.200000e+03,  8.600000e+03,  9.720060e+07,  3.270000e+04,
         0.000000e+00,  5.500000e+03,  3.720000e+04,  8.300000e+03,
         1.000000e+03,  2.580000e+04,  6.770000e+04,  1.420000e+04,
         1.000000e+04,  2.610000e+04,  3.950000e+04,  4.830000e+04,
         3.500000e+03, -2.100000e+03, -2.100000e+03, -2.100000e+03,
        -2.100000e+03, -7.600000e+03, -2.100000e+03, -3.630000e+04,
         6.100000e+03, -3.240000e+04, -3.900000e+03,  6.500000e+03,
        -3.000000e+03,  1.700000e+03, -2.700000e+03, -2.000000e+02,
        -2.000000e+02,  1.230000e+04,  2.470000e+04,  3.500000e+03,
         1.000000e+03,  2.200000e+03,  1.280000e+04,  7.520000e+04,
        -8.600000e+03,  4.900000e+03,  3.500000e+03, -2.600000e+03,
         1.180000e+04,  1.180000e+04,  3.330000e+04,  1.380000e+04,
         1.000000e+02,  1.190000e+04,  3.400000e+03, -3.600000e+03,
         1.700000e+03,  9.400000e+03,  5.000000e+03, -3.000000e+03,
         5.200000e+03,  9.400000e+03,  9.400000e+03,  9.400000e+03,
         9.500000e+03,  3.200000e+04,  3.200000e+04, -4.000000e+03,
         8.000000e+03,  1.930000e+04, -3.000000e+02,  0.000000e+00,
         1.200000e+04,  4.000000e+03, -5.500000e+03,  6.900000e+03,
         5.000000e+03,  5.000000e+03,  3.300000e+03,  3.300000e+03,
         3.300000e+03,  3.670000e+04,  9.310000e+04,  9.700000e+03,
         3.500000e+03,  2.000000e+04,  5.390000e+04,  0.000000e+00,
         7.650000e+04,  3.960000e+04,  1.186000e+05,  3.960000e+04,
         1.187000e+05,  1.280000e+04, -2.900000e+04, -4.240000e+04,
         1.570000e+04,  2.600000e+03,  1.310000e+04,  2.393000e+05,
        -7.700000e+03,  5.700000e+03,  1.630000e+04, -2.500000e+03,
        -7.700000e+03, -4.600000e+03,  2.890000e+04, -1.700000e+03,
        -1.800000e+04,  8.000000e+02,  2.070000e+04,  1.800000e+03,
        -1.170000e+04,  1.520000e+04,  5.440000e+04,  6.600000e+03,
        -1.400000e+03,  1.970000e+04,  1.750000e+04,  2.070000e+04,
         5.220000e+04,  7.300000e+03,  1.770000e+04,  5.000000e+02,
         5.460000e+04,  2.360000e+04,  4.300000e+03,  4.300000e+03,
         1.680000e+04,  7.600000e+03,  7.600000e+03,  4.140000e+04,
         8.210000e+04,  2.950000e+04,  1.354000e+05,  6.200000e+03,
         6.200000e+03,  1.000000e+03,  1.000000e+03,  9.000000e+02,
         1.000000e+03, -2.500000e+03,  1.000000e+03,  6.600000e+03,
         6.600000e+03,  6.600000e+03,  6.600000e+03,  1.280000e+04,
        -6.500000e+03, -6.500000e+03, -6.500000e+03, -1.090000e+04,
         7.600000e+03,  0.000000e+00, -7.600000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.920000e+04, -1.210000e+04, -5.500000e+03,
        -3.000000e+02,  1.420000e+04,  1.420000e+04,  3.400000e+04,
         3.400000e+04, -4.000000e+02, -3.000000e+03, -1.400000e+03,
        -1.900000e+03,  2.470000e+04,  6.500000e+03, -5.000000e+02,
        -8.700000e+03,  1.010000e+04,  1.600000e+04,  0.000000e+00,
         0.000000e+00, -1.000000e+02, -2.000000e+03, -3.200000e+03,
         7.100000e+03, -1.500000e+03, -1.500000e+03, -1.500000e+03,
         0.000000e+00,  0.000000e+00, -1.050000e+04,  0.000000e+00,
         2.470000e+04,  4.400000e+03, -5.100000e+03,  6.600000e+03,
        -1.800000e+03, -1.900000e+03, -4.400000e+03,  8.000000e+03,
        -3.100000e+03, -3.100000e+03, -1.700000e+03,  8.600000e+03,
        -4.000000e+02, -4.800000e+03,  5.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.900000e+03,
        -3.000000e+03, -1.100000e+03,  0.000000e+00,  1.600000e+04,
         6.600000e+03,  0.000000e+00,  2.900000e+03,  2.540000e+04,
         3.300000e+03,  9.400000e+03,  8.000000e+03, -2.100000e+03,
         9.000000e+02,  1.000000e+03,  6.200000e+03, -6.500000e+03,
        -5.500000e+03, -1.400000e+03, -1.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         6.600000e+03,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 6.062000e+05,  1.312000e+05,  1.534000e+05, -5.820000e+04,
         2.731000e+05,  2.590300e+06,  1.378000e+06,  7.852000e+05,
         1.312000e+05,  8.137000e+05,  1.303000e+05,  6.723000e+05,
         3.104000e+05, -2.689000e+05,  0.000000e+00,  6.723000e+05,
        -6.720000e+04,  6.116000e+05,  3.270000e+04,  5.218200e+06,
         0.000000e+00,  9.014000e+05,  1.919000e+05,  2.249000e+05,
        -9.280000e+04,  1.340000e+05,  4.165000e+05,  1.166500e+06,
         1.689000e+05,  9.913000e+05,  1.651200e+06,  5.172000e+05,
        -1.054000e+05, -9.490000e+04, -9.410000e+04, -9.520000e+04,
        -9.500000e+04, -2.492000e+05, -9.440000e+04, -2.488000e+05,
        -1.191600e+06, -1.150800e+06,  1.211000e+05, -1.163000e+05,
        -1.044000e+05,  2.141000e+05, -2.313000e+05, -1.111000e+05,
        -1.111000e+05,  3.100000e+03,  1.168000e+05,  1.290000e+04,
        -3.610000e+04,  1.262000e+05, -1.108000e+05,  4.606000e+05,
        -3.249000e+05,  3.309000e+05, -5.000000e+02, -2.292000e+05,
         7.602000e+05,  7.599000e+05,  2.897000e+05,  3.092000e+05,
         1.711500e+06,  6.416000e+05,  6.918000e+05,  2.111000e+06,
         4.120000e+04,  1.695000e+05,  1.353000e+05, -5.550000e+04,
         1.563000e+05,  7.807000e+05,  7.807000e+05,  7.806000e+05,
         7.823000e+05,  3.051000e+05,  3.048000e+05,  1.201000e+05,
         4.492000e+05,  2.115000e+05, -1.650000e+04,  0.000000e+00,
         9.720000e+04,  1.163000e+05, -2.101000e+05,  1.571000e+05,
         1.443000e+05,  1.443000e+05,  5.760000e+04,  5.750000e+04,
         5.740000e+04,  2.241700e+06,  1.053400e+06,  9.224000e+05,
         1.051200e+06,  1.308800e+06,  5.951000e+05,  7.749000e+05,
         8.268000e+05,  2.903300e+06,  1.237900e+06,  2.903400e+06,
         1.240100e+06,  1.582100e+06,  1.301000e+05, -5.304000e+05,
        -8.193000e+05,  2.948000e+05,  5.780000e+04,  1.712700e+06,
        -3.866000e+05,  2.717000e+05,  3.530000e+04, -1.125000e+05,
        -3.039000e+05,  5.301000e+05, -1.811000e+05, -1.464000e+05,
        -1.282000e+05,  8.033000e+05,  1.345100e+06,  1.330500e+06,
         6.704000e+05,  1.990600e+06,  1.456000e+05,  2.029000e+05,
         4.160000e+05, -5.800000e+04,  4.206000e+05,  1.342000e+06,
         6.298000e+05,  6.846000e+05,  4.257000e+05,  8.035000e+05,
         6.305000e+05,  1.303300e+06,  7.280000e+04,  2.230000e+04,
         1.366000e+05,  9.934000e+05,  9.933000e+05,  2.830000e+05,
         7.628000e+05,  1.947700e+06,  1.627650e+07,  1.557000e+05,
         1.559000e+05, -1.175000e+05, -1.176000e+05, -3.530000e+04,
        -1.179000e+05, -3.156000e+05, -1.176000e+05,  1.736000e+05,
         1.736000e+05,  1.736000e+05,  1.745000e+05,  3.822000e+05,
        -1.824000e+05, -1.823000e+05, -1.823000e+05, -8.480000e+04,
         8.745000e+05,  0.000000e+00, -2.312000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.094300e+06, -4.665000e+05, -2.921000e+05,
        -2.202000e+05,  3.111000e+05,  3.105000e+05,  8.306000e+05,
         8.302000e+05, -1.800000e+04, -1.040000e+05, -1.730000e+04,
         1.615000e+05, -1.440000e+05, -1.540000e+04, -1.760000e+04,
        -2.689000e+05,  6.667000e+05, -3.830000e+04, -3.700000e+03,
         0.000000e+00,  1.000000e+02, -2.100000e+04,  1.822000e+05,
        -3.700000e+04, -4.070000e+04, -4.060000e+04, -4.060000e+04,
         0.000000e+00,  0.000000e+00, -5.480000e+04, -2.889000e+05,
        -5.880000e+04,  5.770000e+04,  3.437000e+05, -3.420000e+04,
         2.107000e+05,  1.654000e+05, -1.365000e+05, -1.930000e+04,
        -1.141000e+05, -1.141000e+05,  2.037000e+05, -2.060000e+04,
        -8.600000e+03,  8.770000e+04, -1.350000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.000000e+02,  4.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.615000e+05,
        -1.040000e+05, -3.530000e+04, -3.700000e+03, -3.830000e+04,
         1.736000e+05, -3.000000e+02,  6.062000e+05,  1.312000e+05,
         5.750000e+04,  7.807000e+05,  4.492000e+05, -9.500000e+04,
        -3.530000e+04, -1.176000e+05,  1.559000e+05, -1.823000e+05,
        -2.921000e+05, -1.730000e+04, -4.060000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.736000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.747230e+07,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 4.032000e+05,  2.730000e+04,  5.980000e+04, -1.101000e+05,
         1.458000e+05,  1.746600e+06,  9.403000e+05,  3.860000e+05,
         2.730000e+04,  3.825000e+05,  2.710000e+04,  2.247000e+05,
         4.990000e+04,  3.168000e+05,  0.000000e+00,  2.247000e+05,
        -3.030000e+04,  2.227000e+05,  5.500000e+03,  9.014000e+05,
         0.000000e+00,  1.015600e+06,  4.261000e+05,  5.000000e+05,
         2.167000e+05, -1.115000e+05,  9.200000e+04,  6.901000e+05,
        -9.880000e+04,  1.220400e+06,  1.125800e+06,  8.335000e+05,
         1.428100e+06,  3.615000e+05,  3.619000e+05,  3.624000e+05,
         3.625000e+05,  4.187000e+05,  3.616000e+05,  3.932800e+06,
         3.153800e+06,  3.245400e+06,  5.441000e+05,  3.515000e+05,
         3.722000e+05,  3.490000e+04, -2.994000e+05,  4.528000e+05,
         4.528000e+05,  2.873000e+05,  1.227000e+05,  3.110000e+05,
         3.279000e+05,  9.292000e+05,  7.349000e+05, -9.270000e+04,
         2.043000e+05,  1.141000e+05, -1.421000e+05, -2.987000e+05,
         1.228200e+06,  1.228000e+06,  8.420000e+05,  8.846000e+05,
         1.210100e+06,  3.246000e+05,  4.556000e+05,  1.616700e+06,
        -4.510000e+04,  1.790000e+04,  3.690000e+04, -2.000000e+04,
         3.310000e+04,  4.596000e+05,  4.596000e+05,  4.595000e+05,
         4.596000e+05,  7.230000e+04,  7.230000e+04,  5.512000e+05,
         1.943000e+05,  4.100000e+03, -1.200000e+04,  0.000000e+00,
        -1.771000e+05, -1.716000e+05,  2.833000e+05,  2.087000e+05,
         4.600000e+04,  4.600000e+04, -3.190000e+04, -3.190000e+04,
        -3.190000e+04,  1.124600e+06,  1.615000e+05,  1.305900e+06,
         1.037900e+06,  7.117000e+05,  1.318000e+05,  5.610000e+05,
        -2.005000e+05,  1.653900e+06,  2.986000e+05,  1.653900e+06,
         2.978000e+05,  1.827400e+06,  2.089900e+06,  2.179900e+06,
         1.315900e+06,  5.913000e+05,  3.972000e+05,  3.850000e+05,
         2.165000e+05,  1.313000e+05, -6.410000e+04,  3.505000e+05,
         6.447000e+05,  4.511000e+05, -1.271000e+05, -6.440000e+04,
         5.366000e+05,  5.544000e+05,  7.454000e+05,  1.361900e+06,
         1.452200e+06,  1.271600e+06,  3.903000e+05,  5.027000e+05,
         1.137600e+06,  7.489000e+05,  4.903000e+05,  7.356000e+05,
         1.579000e+05,  8.221000e+05,  4.970000e+05,  5.898000e+05,
         1.532000e+05,  6.831000e+05,  3.978000e+05,  2.946000e+05,
         1.291000e+05,  6.317000e+05,  6.317000e+05,  6.290000e+04,
         4.348000e+05,  1.406400e+06,  1.020920e+07,  3.430000e+04,
         3.430000e+04, -1.000000e+05, -1.001000e+05,  3.280000e+05,
        -1.003000e+05, -6.072000e+05, -1.001000e+05,  4.500000e+04,
         4.500000e+04,  4.500000e+04,  4.510000e+04,  6.260000e+04,
        -6.740000e+04, -6.740000e+04, -6.740000e+04,  4.477000e+05,
         3.567000e+05,  0.000000e+00, -4.320000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -4.046000e+05, -2.030000e+05, -1.517000e+05,
         9.058000e+05,  4.176000e+05,  4.173000e+05,  5.518000e+05,
         5.515000e+05, -1.090000e+04, -6.900000e+04, -1.190000e+04,
         1.307000e+05, -2.920000e+04, -6.400000e+03, -8.100000e+03,
         3.168000e+05,  2.255000e+05, -1.580000e+04, -3.200000e+03,
         0.000000e+00,  1.000000e+02,  3.300000e+03,  1.523000e+05,
        -2.050000e+04, -1.110000e+04, -1.100000e+04, -1.100000e+04,
         0.000000e+00,  0.000000e+00,  4.973000e+05,  3.084000e+05,
        -2.450000e+04,  5.280000e+04,  2.829000e+05, -1.900000e+04,
         1.781000e+05,  1.338000e+05,  1.557000e+05, -8.000000e+03,
        -7.810000e+04, -7.810000e+04,  1.674000e+05, -9.200000e+03,
        -1.000000e+03,  8.640000e+04, -8.780000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.307000e+05,
        -6.900000e+04,  4.160000e+04, -3.200000e+03, -1.580000e+04,
         4.500000e+04, -3.000000e+02,  4.032000e+05,  2.730000e+04,
        -3.190000e+04,  4.596000e+05,  1.943000e+05,  3.624000e+05,
         3.280000e+05, -1.001000e+05,  3.430000e+04, -6.740000e+04,
        -1.517000e+05, -1.190000e+04, -1.100000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.500000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 2.100000e+03,  5.558000e+05,  5.810000e+04, -6.080000e+04,
        -2.910000e+04, -2.500000e+04, -2.930000e+04,  7.100000e+03,
         5.558000e+05,  8.100000e+03,  5.557000e+05,  4.810000e+04,
         3.210000e+05,  2.828000e+05,  0.000000e+00,  4.810000e+04,
         1.540000e+04,  4.850000e+04,  3.720000e+04,  1.919000e+05,
         0.000000e+00,  4.261000e+05,  1.381700e+06,  5.167000e+05,
         3.290000e+05,  4.580000e+05,  1.390100e+06,  1.428000e+05,
         4.180000e+04,  1.157900e+06,  9.208000e+05,  1.734200e+06,
         1.656100e+06,  3.767000e+05,  3.775000e+05,  3.782000e+05,
         3.763000e+05,  4.003000e+05,  3.773000e+05,  3.066900e+06,
         4.344100e+06,  3.187700e+06,  3.314000e+05,  6.477000e+05,
         3.616000e+05, -9.050000e+04, -1.956000e+05,  5.637000e+05,
         5.639000e+05,  6.153000e+05,  6.752000e+05,  3.914000e+05,
         4.000000e+05,  9.273000e+05,  1.244700e+06,  1.501900e+06,
         2.140000e+05, -1.470000e+04, -4.720000e+04, -1.941000e+05,
         9.443000e+05,  9.441000e+05,  1.565500e+06,  1.004700e+06,
        -9.690000e+04,  1.278000e+05,  1.070000e+04, -8.870000e+04,
        -1.930000e+04,  1.085000e+05,  7.070000e+04, -6.740000e+04,
         4.970000e+04,  9.450000e+04,  9.450000e+04,  9.450000e+04,
         9.450000e+04,  6.497000e+05,  6.497000e+05,  3.316000e+05,
         6.120000e+04,  3.383000e+05, -1.310000e+04,  0.000000e+00,
         4.030000e+04, -1.545000e+05,  2.982000e+05,  3.080000e+05,
         6.750000e+04,  6.750000e+04,  1.360000e+04,  1.370000e+04,
         1.370000e+04,  3.577000e+05,  1.744900e+06,  8.379000e+05,
         3.168000e+05,  2.083000e+05,  1.039800e+06, -8.350000e+04,
         1.216000e+06,  4.238000e+05,  2.367000e+06,  4.238000e+05,
         2.367600e+06,  8.981000e+05,  1.140600e+06,  1.377800e+06,
         2.279600e+06,  4.242000e+05,  7.414000e+05,  5.163600e+06,
         3.087000e+05,  7.240000e+04,  3.910000e+05,  3.628000e+05,
         6.838000e+05, -1.153000e+05,  7.349000e+05, -2.470000e+04,
         1.210000e+05, -5.590000e+04,  2.339000e+05,  3.344000e+05,
         5.707000e+05,  9.810000e+04,  1.921000e+06,  4.854000e+05,
         7.545000e+05,  1.389100e+06,  6.502000e+05,  2.347000e+05,
         1.183700e+06,  4.713000e+05,  6.594000e+05, -6.130000e+04,
         1.068200e+06,  2.018000e+05,  4.597000e+05,  4.133000e+05,
         4.647000e+05,  4.520000e+04,  4.530000e+04,  8.803000e+05,
         2.090500e+06,  5.039000e+05,  9.707000e+05,  7.960000e+04,
         7.970000e+04,  2.560000e+04,  2.560000e+04,  4.041000e+05,
         2.540000e+04, -4.201000e+05,  2.560000e+04,  9.390000e+04,
         9.390000e+04,  9.390000e+04,  9.380000e+04,  8.910000e+04,
        -9.840000e+04, -9.830000e+04, -9.840000e+04,  2.504000e+05,
         1.570000e+04,  0.000000e+00, -5.930000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -5.904000e+05, -1.605000e+05, -6.750000e+04,
         1.138500e+06,  5.903000e+05,  5.887000e+05,  8.700000e+05,
         8.699000e+05, -1.440000e+04, -7.160000e+04, -4.420000e+04,
        -3.240000e+04,  2.364000e+05,  1.694000e+05, -5.000000e+03,
         2.828000e+05,  4.810000e+04,  3.947000e+05,  8.000000e+02,
         0.000000e+00, -2.500000e+03, -5.250000e+04, -8.420000e+04,
         2.235000e+05, -2.130000e+04, -2.130000e+04, -2.130000e+04,
         0.000000e+00,  0.000000e+00,  2.389000e+05,  5.548000e+05,
         6.480000e+05,  1.199000e+05, -1.166000e+05,  2.067000e+05,
        -4.370000e+04, -3.350000e+04,  1.380000e+05,  1.969000e+05,
        -7.330000e+04, -7.330000e+04, -4.030000e+04,  2.485000e+05,
        -5.800000e+03, -1.133000e+05,  1.752000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.000000e+02,  9.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -3.240000e+04,
        -7.160000e+04,  3.710000e+04,  8.000000e+02,  3.947000e+05,
         9.390000e+04, -2.000000e+02,  2.100000e+03,  5.558000e+05,
         1.370000e+04,  9.450000e+04,  6.120000e+04,  3.763000e+05,
         4.041000e+05,  2.560000e+04,  7.970000e+04, -9.840000e+04,
        -6.750000e+04, -4.420000e+04, -2.130000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         9.390000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 2.750000e+04,  5.710000e+04,  1.492900e+06, -4.980000e+04,
        -1.130000e+04,  7.050000e+04,  1.550000e+04,  2.360000e+04,
         5.710000e+04,  2.270000e+04,  5.690000e+04,  5.540000e+04,
         7.310000e+04,  3.084000e+05,  0.000000e+00,  5.540000e+04,
         1.570000e+04,  5.430000e+04,  8.300000e+03,  2.249000e+05,
         0.000000e+00,  5.000000e+05,  5.167000e+05,  9.067200e+06,
         3.470000e+05,  2.430000e+04,  1.847000e+05,  1.868000e+05,
         4.450000e+04,  1.151600e+06,  8.947000e+05,  1.168000e+06,
         1.815700e+06,  3.879000e+05,  3.883000e+05,  3.893000e+05,
         3.887000e+05,  4.256000e+05,  3.881000e+05,  3.302400e+06,
         3.332800e+06,  1.472530e+07,  3.661000e+05,  3.759000e+05,
         3.221900e+06, -6.160000e+04, -1.699000e+05,  5.680000e+05,
         5.680000e+05,  4.046000e+05,  2.426000e+05,  3.253700e+06,
         4.010000e+05,  9.593000e+05,  9.672000e+05,  1.503000e+05,
         2.538000e+05,  3.900000e+03, -3.510000e+04, -1.746000e+05,
         9.797000e+05,  9.796000e+05,  9.961000e+05,  6.691100e+06,
        -6.300000e+04,  1.594000e+05,  2.820000e+04, -9.530000e+04,
        -4.600000e+04,  9.710000e+04,  6.130000e+04, -7.840000e+04,
         1.980000e+04,  1.206000e+05,  1.206000e+05,  1.205000e+05,
         1.205000e+05,  1.369000e+05,  1.369000e+05,  3.752000e+05,
         6.990000e+04,  8.210000e+04, -8.100000e+03,  0.000000e+00,
        -1.711000e+05, -1.618000e+05,  3.211000e+05,  2.802000e+05,
         7.092000e+05,  7.092000e+05,  1.470000e+04,  1.470000e+04,
         1.470000e+04,  4.030000e+05,  4.492000e+05,  9.108000e+05,
         3.762000e+05,  2.472000e+05,  2.711000e+05, -3.700000e+03,
        -5.490000e+04,  5.035000e+05,  5.607000e+05,  5.035000e+05,
         5.587000e+05,  1.001800e+06,  1.314800e+06,  1.567500e+06,
         1.347500e+06,  4.488000e+05,  4.569000e+05,  7.626000e+05,
         3.193000e+05,  7.340000e+04,  8.000000e+04,  3.808000e+05,
         7.093000e+05, -4.930000e+04, -2.310000e+04,  8.517800e+06,
         1.970000e+05, -2.560000e+04,  2.737000e+05,  4.364000e+05,
         6.897000e+05,  1.831000e+05,  4.759000e+05,  1.471500e+07,
         8.179000e+05,  8.337000e+05,  6.195000e+05,  2.633000e+05,
         2.927000e+05,  5.106000e+05,  6.280000e+05,  1.710000e+04,
         2.849000e+05,  2.317000e+05,  4.573000e+05,  4.137000e+05,
         2.504000e+05,  8.640000e+04,  8.630000e+04,  1.252000e+05,
         6.999000e+05,  6.604000e+05,  1.560600e+06,  7.280000e+04,
         7.290000e+04,  1.090000e+04,  1.090000e+04,  4.009000e+05,
         1.080000e+04, -4.462000e+05,  1.090000e+04,  7.980000e+04,
         7.980000e+04,  7.980000e+04,  7.980000e+04,  8.570000e+04,
        -9.760000e+04, -9.750000e+04, -9.750000e+04,  2.685000e+05,
         1.660000e+04,  0.000000e+00, -5.440000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -5.854000e+05, -1.635000e+05, -7.640000e+04,
         1.133200e+06,  5.603000e+05,  5.601000e+05,  7.991000e+05,
         7.989000e+05, -7.100000e+03, -5.910000e+04, -5.990000e+04,
        -4.010000e+04, -1.780000e+04, -7.900000e+03,  3.009000e+05,
         3.084000e+05,  5.620000e+04, -1.970000e+04,  4.000000e+02,
         0.000000e+00,  1.000000e+02,  2.251400e+06, -8.720000e+04,
        -7.110000e+04, -1.840000e+04, -1.840000e+04, -1.840000e+04,
         0.000000e+00,  0.000000e+00,  2.862000e+05,  2.984000e+05,
        -3.020000e+04, -1.450000e+04, -1.273000e+05, -6.570000e+04,
        -2.120000e+04, -3.950000e+04,  1.509000e+05, -9.900000e+03,
        -6.960000e+04, -6.960000e+04, -3.350000e+04, -1.580000e+04,
         3.165000e+05, -1.045000e+05, -8.560000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.000000e+02, -5.400000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -4.010000e+04,
        -5.910000e+04,  4.050000e+04,  4.000000e+02, -1.970000e+04,
         7.980000e+04, -2.000000e+02,  2.750000e+04,  5.710000e+04,
         1.470000e+04,  1.206000e+05,  6.990000e+04,  3.887000e+05,
         4.009000e+05,  1.090000e+04,  7.290000e+04, -9.750000e+04,
        -7.640000e+04, -5.990000e+04, -1.840000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         7.980000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-7.260000e+04, -6.000000e+02,  1.270000e+04,  9.778000e+05,
         4.515000e+05, -3.271000e+05, -1.819000e+05, -6.730000e+04,
        -5.000000e+02, -6.630000e+04, -5.000000e+02, -2.360000e+04,
         8.500000e+03,  2.844000e+05,  0.000000e+00, -2.360000e+04,
         5.053000e+05, -2.340000e+04,  1.000000e+03, -9.280000e+04,
         0.000000e+00,  2.167000e+05,  3.290000e+05,  3.470000e+05,
         1.950600e+06,  1.521400e+06,  1.200000e+04, -6.630000e+04,
         1.545000e+06,  6.641000e+05,  3.554000e+05,  7.344000e+05,
         1.190740e+07,  3.076000e+05,  3.081000e+05,  3.078000e+05,
         3.073000e+05,  3.671000e+05,  3.080000e+05,  2.551000e+06,
         2.703500e+06,  2.724800e+06,  2.610000e+05,  2.984000e+05,
         3.044000e+05,  1.432100e+06,  2.422500e+06,  1.574100e+06,
         1.573900e+06,  1.398500e+06,  1.196900e+06,  1.416000e+06,
         8.703000e+05,  2.947300e+06,  2.984800e+06,  2.107700e+06,
         1.374000e+06,  9.632000e+05,  1.493800e+06,  2.419600e+06,
         5.926000e+05,  5.925000e+05,  6.666000e+05,  6.795000e+05,
        -2.559000e+05, -9.500000e+03, -7.800000e+04, -3.205000e+05,
         5.188000e+05,  5.290000e+05,  1.830000e+04, -2.590000e+04,
         1.800000e+03, -4.610000e+04, -4.610000e+04, -4.610000e+04,
        -4.610000e+04,  2.250000e+04,  2.250000e+04,  2.632000e+05,
         4.956000e+05,  5.307000e+05, -1.630000e+04,  0.000000e+00,
        -1.789000e+05, -1.582000e+05,  8.396000e+05,  4.726000e+05,
         1.580000e+04,  1.580000e+04,  5.149000e+05,  5.148000e+05,
         5.147000e+05,  9.474000e+05,  1.118000e+06,  1.596300e+06,
         1.193200e+06, -7.790000e+04,  2.270000e+04, -1.614000e+05,
        -2.933000e+05, -1.376000e+05,  1.024000e+05, -1.376000e+05,
         1.016000e+05,  4.774000e+05,  1.002700e+06,  1.311700e+06,
         1.142300e+06,  2.852000e+05,  3.226000e+05,  6.600000e+04,
         3.112000e+05,  3.100000e+03,  4.070000e+04,  2.908000e+05,
         1.155800e+06, -1.146000e+05, -8.600000e+03,  1.580000e+04,
         1.937000e+05, -1.427000e+05, -4.270000e+04,  1.197000e+05,
         4.296000e+05, -1.902000e+05,  3.069000e+05,  3.370000e+05,
         5.473000e+05,  6.222000e+05,  3.718000e+05, -4.510000e+04,
         6.720000e+04,  2.627000e+05,  3.769000e+05, -1.312000e+05,
         5.670000e+04, -6.920000e+04,  3.238000e+05,  1.423600e+06,
         1.248200e+06, -9.810000e+04, -9.810000e+04,  1.060000e+04,
         3.251000e+05,  1.379000e+05, -1.485600e+06,  6.000000e+03,
         6.000000e+03,  2.540000e+04,  2.540000e+04,  8.748000e+05,
         2.540000e+04, -2.803000e+05,  2.540000e+04,  2.300000e+04,
         2.300000e+04,  2.300000e+04,  2.300000e+04,  1.950000e+04,
        -3.470000e+04, -3.460000e+04, -3.460000e+04,  2.489000e+05,
        -5.890000e+04,  0.000000e+00, -2.080000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.079000e+05, -2.460000e+04,  4.000000e+02,
         3.086300e+06,  9.193000e+05,  9.176000e+05,  9.865000e+05,
         9.864000e+05, -1.700000e+04,  4.400000e+05, -2.120000e+04,
        -3.550000e+04, -7.100000e+03, -9.000000e+03,  1.200000e+03,
         2.844000e+05, -2.350000e+04, -2.530000e+04,  8.000000e+02,
         0.000000e+00,  0.000000e+00, -1.890000e+04, -7.110000e+04,
        -2.940000e+04, -5.500000e+03, -5.500000e+03, -5.500000e+03,
         0.000000e+00,  0.000000e+00,  2.392000e+05,  2.763000e+05,
        -3.450000e+04, -2.280000e+04, -1.066000e+05, -2.720000e+04,
        -4.460000e+04, -3.660000e+04,  1.403000e+05, -1.270000e+04,
         4.623000e+05,  4.623000e+05, -5.530000e+04, -1.340000e+04,
        -3.600000e+03,  4.086000e+05,  4.491000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02, -4.200000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -3.550000e+04,
         4.400000e+05,  3.730000e+04,  8.000000e+02, -2.530000e+04,
         2.300000e+04, -1.000000e+02, -7.260000e+04, -6.000000e+02,
         5.148000e+05, -4.610000e+04,  4.956000e+05,  3.073000e+05,
         8.748000e+05,  2.540000e+04,  6.000000e+03, -3.460000e+04,
         4.000000e+02, -2.120000e+04, -5.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.300000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-2.690000e+04,  3.622000e+05,  5.950000e+04,  1.056600e+06,
         5.136000e+05, -1.523000e+05, -9.860000e+04, -2.050000e+04,
         3.622000e+05, -1.930000e+04,  3.613000e+05,  3.330000e+04,
         2.225000e+05, -2.117000e+05,  0.000000e+00,  3.330000e+04,
         5.768000e+05,  3.360000e+04,  2.580000e+04,  1.340000e+05,
         0.000000e+00, -1.115000e+05,  4.580000e+05,  2.430000e+04,
         1.521400e+06,  2.208500e+06,  1.015600e+06,  1.013000e+05,
         1.771800e+06,  1.378000e+05,  3.823000e+05,  5.236000e+05,
         9.623000e+06, -1.195000e+05, -1.197000e+05, -1.189000e+05,
        -1.192000e+05, -2.184000e+05, -1.197000e+05, -1.450000e+06,
        -6.909000e+05, -1.269000e+06, -1.788000e+05,  1.120000e+04,
        -1.335000e+05,  1.575500e+06,  2.584400e+06,  9.188000e+05,
         9.192000e+05,  1.216100e+06,  1.543900e+06,  1.022300e+06,
         4.522000e+05,  1.894000e+06,  2.083900e+06,  3.568500e+06,
         8.433000e+05,  1.097200e+06,  1.648100e+06,  2.577600e+06,
        -7.870000e+04, -7.880000e+04,  3.024000e+05,  1.180000e+04,
        -1.889000e+05,  1.113000e+05, -2.140000e+04, -2.083000e+05,
         5.153000e+05,  6.712000e+05,  7.090000e+04, -6.650000e+04,
         4.720000e+04,  6.650000e+04,  6.650000e+04,  6.650000e+04,
         6.650000e+04,  4.545000e+05,  4.545000e+05, -1.778000e+05,
         6.187000e+05,  8.133000e+05, -1.730000e+04,  0.000000e+00,
         2.652000e+05,  8.900000e+04,  3.656000e+05,  3.070000e+05,
         6.720000e+04,  6.720000e+04,  5.902000e+05,  5.903000e+05,
         5.900000e+05,  1.428900e+06,  2.400800e+06,  9.300000e+05,
         8.789000e+05,  1.572000e+05,  7.393000e+05, -1.369000e+05,
         1.327800e+06,  3.248000e+05,  1.683000e+06,  3.248000e+05,
         1.683200e+06, -1.634000e+05, -8.971000e+05, -1.141500e+06,
        -1.240000e+05, -8.660000e+04,  1.033000e+05,  3.745100e+06,
        -1.798000e+05,  6.550000e+04,  2.554000e+05, -1.370000e+05,
         2.397000e+05, -1.434000e+05,  4.349000e+05, -7.600000e+03,
        -3.888000e+05, -1.055000e+05,  1.930000e+05, -2.310000e+05,
        -4.754000e+05,  1.330000e+04,  7.184000e+05, -4.800000e+03,
        -2.655000e+05,  1.143000e+05,  1.559000e+05,  1.919000e+05,
         7.618000e+05, -5.330000e+04,  1.577000e+05, -1.025000e+05,
         7.741000e+05,  1.710000e+05, -2.860000e+04,  1.031400e+06,
         1.328400e+06,  1.900000e+03,  1.900000e+03,  5.894000e+05,
         1.121700e+06,  1.723000e+05,  2.834000e+05,  7.480000e+04,
         7.490000e+04,  3.180000e+04,  3.180000e+04,  4.484000e+05,
         3.180000e+04,  9.110000e+04,  3.180000e+04,  9.230000e+04,
         9.230000e+04,  9.230000e+04,  9.220000e+04,  8.670000e+04,
        -1.100000e+05, -1.099000e+05, -1.100000e+05, -2.551000e+05,
        -1.020000e+04,  0.000000e+00, -6.030000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -6.600000e+05, -1.538000e+05, -6.100000e+04,
         1.809200e+06,  6.342000e+05,  6.355000e+05,  9.124000e+05,
         9.123000e+05, -1.740000e+04,  4.413000e+05, -4.510000e+04,
        -4.350000e+04,  1.410000e+05,  1.259000e+05, -2.900000e+03,
        -2.117000e+05,  3.330000e+04,  3.387000e+05,  1.000000e+03,
         0.000000e+00,  1.680000e+04, -4.920000e+04, -1.049000e+05,
         8.380000e+04, -2.130000e+04, -2.130000e+04, -2.130000e+04,
         0.000000e+00,  0.000000e+00, -2.707000e+05, -8.050000e+04,
         4.814000e+05,  9.260000e+04, -1.484000e+05,  7.750000e+04,
        -5.790000e+04, -4.470000e+04, -1.065000e+05,  1.690000e+05,
         4.635000e+05,  4.634000e+05, -6.560000e+04,  1.355000e+05,
        -8.000000e+03,  3.992000e+05,  5.990000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -4.100000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -4.350000e+04,
         4.413000e+05, -2.780000e+04,  1.000000e+03,  3.387000e+05,
         9.230000e+04,  0.000000e+00, -2.690000e+04,  3.622000e+05,
         5.903000e+05,  6.650000e+04,  6.187000e+05, -1.193000e+05,
         4.484000e+05,  3.180000e+04,  7.490000e+04, -1.100000e+05,
        -6.100000e+04, -4.510000e+04, -2.130000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         9.230000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 4.820000e+04,  9.306000e+05,  1.034000e+05, -1.100000e+03,
         2.370000e+04,  1.520000e+05,  5.560000e+04,  5.420000e+04,
         9.354000e+05,  5.540000e+04,  1.019300e+06,  1.044000e+05,
         5.853000e+05, -2.164000e+05,  0.000000e+00,  1.044000e+05,
         7.780000e+04,  1.051000e+05,  6.770000e+04,  4.165000e+05,
         0.000000e+00,  9.200000e+04,  1.390100e+06,  1.847000e+05,
         1.200000e+04,  1.015600e+06,  3.596700e+06,  3.083000e+05,
         2.315000e+05,  6.106000e+05,  9.292000e+05,  1.491900e+06,
        -2.330000e+04, -5.570000e+04, -5.580000e+04, -5.420000e+04,
        -5.630000e+04, -1.904000e+05, -5.590000e+04, -9.742000e+05,
         7.560000e+05, -8.505000e+05, -1.124000e+05,  3.182000e+05,
        -8.150000e+04,  2.270000e+04, -7.910000e+04, -1.520000e+04,
        -1.530000e+04,  4.881000e+05,  9.904000e+05,  6.950000e+04,
         1.850000e+04,  2.350000e+04,  4.550000e+05,  2.971600e+06,
        -2.214000e+05,  1.004000e+05,  7.580000e+04, -7.840000e+04,
         2.562000e+05,  2.561000e+05,  1.126900e+06,  3.181000e+05,
        -2.660000e+04,  2.461000e+05,  6.750000e+04,  2.640000e+04,
         1.250000e+04,  2.381000e+05,  1.216000e+05, -1.027000e+05,
         9.760000e+04,  2.053000e+05,  2.053000e+05,  2.053000e+05,
         2.053000e+05,  1.091700e+06,  1.091600e+06, -1.130000e+05,
         1.780000e+05,  6.201000e+05, -1.600000e+04,  0.000000e+00,
         4.848000e+05,  9.240000e+04, -1.402000e+05,  1.667000e+05,
         1.172000e+05,  1.172000e+05,  7.690000e+04,  7.680000e+04,
         7.690000e+04,  8.234000e+05,  3.038400e+06,  1.840000e+05,
         2.320000e+04,  4.350000e+05,  1.762500e+06, -5.860000e+04,
         2.782600e+06,  8.780000e+05,  3.979900e+06,  8.780000e+05,
         3.981300e+06,  2.421000e+05, -7.687000e+05, -1.086800e+06,
         9.971000e+05,  4.620000e+04,  4.777000e+05,  8.916100e+06,
        -1.850000e+05,  1.362000e+05,  5.697000e+05, -7.320000e+04,
        -1.983000e+05, -1.428000e+05,  1.181600e+06, -5.000000e+04,
        -4.638000e+05, -2.050000e+04,  4.650000e+05, -1.930000e+04,
        -3.384000e+05,  2.999000e+05,  2.138500e+06,  1.353000e+05,
        -6.860000e+04,  7.946000e+05,  4.225000e+05,  4.671000e+05,
         1.759000e+06,  1.480000e+05,  4.279000e+05, -3.370000e+04,
         1.798200e+06,  4.989000e+05,  9.990000e+04,  9.520000e+04,
         5.985000e+05,  1.448000e+05,  1.449000e+05,  1.476100e+06,
         2.797700e+06,  6.399000e+05,  2.727500e+06,  1.430000e+05,
         1.431000e+05,  3.170000e+04,  3.170000e+04,  1.760000e+04,
         3.150000e+04, -4.400000e+04,  3.170000e+04,  1.610000e+05,
         1.610000e+05,  1.610000e+05,  1.631000e+05,  1.549000e+05,
        -1.645000e+05, -1.643000e+05, -1.644000e+05, -2.560000e+05,
         6.460000e+04,  0.000000e+00, -9.910000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -9.865000e+05, -2.874000e+05, -1.278000e+05,
        -2.410000e+04,  3.397000e+05,  3.398000e+05,  8.224000e+05,
         8.223000e+05, -1.790000e+04, -7.560000e+04, -6.340000e+04,
        -3.950000e+04,  4.362000e+05,  3.076000e+05, -9.100000e+03,
        -2.164000e+05,  1.043000e+05,  7.868000e+05,  1.000000e+03,
         0.000000e+00,  3.000000e+02, -7.830000e+04, -1.124000e+05,
         3.051000e+05, -3.660000e+04, -3.660000e+04, -3.660000e+04,
         0.000000e+00,  0.000000e+00, -2.714000e+05,  1.553000e+05,
         1.176600e+06,  2.375000e+05, -1.519000e+05,  2.822000e+05,
        -5.470000e+04, -4.070000e+04, -1.103000e+05,  3.925000e+05,
        -7.710000e+04, -7.710000e+04, -4.960000e+04,  3.835000e+05,
        -1.000000e+04, -1.264000e+05,  3.065000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.000000e+02,  1.000000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -3.950000e+04,
        -7.560000e+04, -2.840000e+04,  1.000000e+03,  7.868000e+05,
         1.610000e+05, -2.000000e+02,  4.820000e+04,  9.306000e+05,
         7.680000e+04,  2.053000e+05,  1.780000e+05, -5.620000e+04,
         1.760000e+04,  3.170000e+04,  1.431000e+05, -1.644000e+05,
        -1.278000e+05, -6.340000e+04, -3.660000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.610000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 4.515000e+05,  9.690000e+04,  1.152000e+05, -4.330000e+04,
         2.032000e+05,  1.927100e+06,  1.024200e+06,  4.363000e+05,
         9.690000e+04,  4.332000e+05,  9.670000e+04,  2.907000e+05,
         1.250000e+05, -2.013000e+05,  0.000000e+00,  2.907000e+05,
         4.490000e+04,  2.890000e+05,  1.420000e+04,  1.166500e+06,
         0.000000e+00,  6.901000e+05,  1.428000e+05,  1.868000e+05,
        -6.630000e+04,  1.013000e+05,  3.083000e+05,  3.606600e+06,
         2.998000e+05,  7.444000e+05,  1.240700e+06,  3.786000e+05,
        -6.000000e+04, -7.220000e+04, -7.190000e+04, -7.190000e+04,
        -7.180000e+04, -1.869000e+05, -7.220000e+04, -1.740000e+05,
        -8.994000e+05, -8.450000e+05,  9.160000e+04, -8.760000e+04,
        -7.610000e+04,  1.592000e+05, -1.735000e+05, -8.070000e+04,
        -8.070000e+04,  3.800000e+03,  8.790000e+04,  1.800000e+04,
        -2.640000e+04,  1.009000e+05, -7.970000e+04,  3.430000e+05,
        -2.409000e+05,  2.466000e+05,  0.000000e+00, -1.723000e+05,
         5.764000e+05,  5.761000e+05,  2.134000e+05,  2.408000e+05,
         1.268100e+06,  4.709000e+05,  5.176000e+05,  1.729300e+06,
         3.210000e+04,  1.771000e+05,  1.006000e+05, -4.140000e+04,
         1.158000e+05,  5.930000e+05,  5.930000e+05,  5.930000e+05,
         5.930000e+05,  2.259000e+05,  2.259000e+05,  9.770000e+04,
         3.353000e+05,  1.556000e+05, -1.680000e+04,  0.000000e+00,
         6.910000e+04,  1.715000e+05, -1.562000e+05,  1.181000e+05,
         1.076000e+05,  1.076000e+05,  4.330000e+04,  4.330000e+04,
         4.340000e+04,  1.690800e+06,  7.786000e+05,  7.088000e+05,
         7.697000e+05,  9.859000e+05,  4.351000e+05,  5.807000e+05,
         6.091000e+05,  2.204700e+06,  9.196000e+05,  2.204700e+06,
         9.191000e+05,  1.207600e+06,  1.165000e+05, -3.798000e+05,
        -6.161000e+05,  2.241000e+05,  4.360000e+04,  1.269400e+06,
        -2.918000e+05,  2.058000e+05,  2.360000e+04, -8.870000e+04,
        -2.271000e+05,  4.085000e+05, -1.382000e+05, -9.480000e+04,
        -8.890000e+04,  5.776000e+05,  1.030800e+06,  1.006200e+06,
         5.135000e+05,  1.498800e+06,  1.028000e+05,  1.673000e+05,
         3.193000e+05, -4.200000e+04,  3.106000e+05,  1.019400e+06,
         4.817000e+05,  5.217000e+05,  3.145000e+05,  6.166000e+05,
         4.674000e+05,  9.664000e+05,  5.240000e+04,  1.840000e+04,
         1.029000e+05,  7.433000e+05,  7.433000e+05,  2.094000e+05,
         5.644000e+05,  1.467800e+06,  1.221700e+07,  1.126000e+05,
         1.127000e+05, -9.060000e+04, -9.060000e+04, -2.540000e+04,
        -9.090000e+04, -2.383000e+05, -9.060000e+04,  1.289000e+05,
         1.289000e+05,  1.289000e+05,  1.290000e+05,  1.445000e+05,
        -1.513000e+05, -1.512000e+05, -1.512000e+05, -8.280000e+04,
         4.101000e+05,  0.000000e+00, -9.350000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -9.076000e+05, -3.627000e+05, -2.268000e+05,
        -1.622000e+05,  2.317000e+05,  2.311000e+05,  6.173000e+05,
         6.170000e+05, -1.640000e+04, -7.720000e+04, -1.310000e+04,
         1.183000e+05, -3.420000e+04, -1.140000e+04, -1.340000e+04,
        -2.013000e+05,  2.913000e+05, -2.890000e+04,  1.698000e+05,
         0.000000e+00,  1.000000e+02, -1.020000e+04,  1.352000e+05,
        -2.720000e+04, -3.030000e+04, -3.020000e+04, -3.020000e+04,
         0.000000e+00,  0.000000e+00, -3.700000e+04, -2.153000e+05,
        -4.370000e+04,  4.320000e+04,  2.534000e+05, -2.510000e+04,
         3.395000e+05,  1.210000e+05, -1.022000e+05, -1.450000e+04,
        -8.600000e+04, -8.600000e+04,  1.514000e+05, -1.490000e+04,
        -6.300000e+03,  6.250000e+04, -1.014000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.000000e+02,  3.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.183000e+05,
        -7.720000e+04, -2.640000e+04,  1.698000e+05, -2.890000e+04,
         1.289000e+05, -2.000000e+02,  4.515000e+05,  9.690000e+04,
         4.330000e+04,  5.930000e+05,  3.353000e+05, -7.180000e+04,
        -2.540000e+04, -9.060000e+04,  1.127000e+05, -1.512000e+05,
        -2.268000e+05, -1.310000e+04, -3.020000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.289000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-2.470000e+04,  7.300000e+04,  6.840000e+04,  1.070000e+06,
         5.213000e+05, -1.483000e+05, -9.900000e+04, -1.760000e+04,
         7.300000e+04, -1.630000e+04,  7.280000e+04,  4.200000e+04,
         8.540000e+04, -2.247000e+05,  0.000000e+00,  4.200000e+04,
         5.910000e+05,  4.250000e+04,  1.000000e+04,  1.689000e+05,
         0.000000e+00, -9.880000e+04,  4.180000e+04,  4.450000e+04,
         1.545000e+06,  1.771800e+06,  2.315000e+05,  2.998000e+05,
         2.706500e+06,  2.082000e+05,  4.745000e+05,  3.041000e+05,
         9.759800e+06, -1.171000e+05, -1.172000e+05, -1.171000e+05,
        -1.170000e+05, -2.270000e+05, -1.173000e+05, -1.478700e+06,
        -1.291500e+06, -1.287600e+06, -1.830000e+05, -1.363000e+05,
        -1.353000e+05,  1.596700e+06,  2.610400e+06,  9.399000e+05,
         9.399000e+05,  1.043900e+06,  1.154300e+06,  1.044800e+06,
         4.672000e+05,  1.934900e+06,  1.981700e+06,  2.501800e+06,
         8.377000e+05,  1.119200e+06,  1.675700e+06,  2.603600e+06,
        -4.220000e+04, -4.230000e+04,  5.160000e+04,  5.330000e+04,
        -1.991000e+05,  1.334000e+05, -1.760000e+04, -2.162000e+05,
         5.542000e+05,  7.007000e+05,  8.240000e+04, -4.440000e+04,
         8.830000e+04,  8.370000e+04,  8.370000e+04,  8.370000e+04,
         8.370000e+04,  1.806000e+05,  1.806000e+05, -1.824000e+05,
         6.414000e+05,  6.903000e+05, -1.900000e+04,  0.000000e+00,
         7.880000e+04,  1.802000e+05,  3.648000e+05,  3.313000e+05,
         7.790000e+04,  7.790000e+04,  6.045000e+05,  6.058000e+05,
         6.043000e+05,  1.515200e+06,  1.759100e+06,  9.722000e+05,
         8.972000e+05,  1.948000e+05,  3.400000e+05, -1.462000e+05,
         5.319000e+05,  4.001000e+05,  7.393000e+05,  4.001000e+05,
         7.396000e+05, -1.317000e+05, -9.456000e+05, -1.211900e+06,
        -7.531000e+05, -7.560000e+04, -2.880000e+04,  9.749000e+05,
        -1.894000e+05,  7.740000e+04,  1.242000e+05, -1.364000e+05,
         2.420000e+05, -1.596000e+05, -1.700000e+04, -1.630000e+04,
        -4.264000e+05, -1.112000e+05,  2.338000e+05, -2.314000e+05,
        -4.975000e+05,  3.470000e+04,  2.500000e+03,  7.500000e+03,
        -2.587000e+05, -1.652000e+05,  2.034000e+05,  2.328000e+05,
         3.729000e+05, -3.380000e+04,  2.055000e+05, -1.092000e+05,
         3.784000e+05,  2.304000e+05, -1.170000e+04,  1.058500e+06,
         1.162500e+06,  1.220000e+04,  1.220000e+04,  1.632000e+05,
         4.581000e+05,  2.242000e+05,  4.869000e+05,  8.820000e+04,
         8.830000e+04,  3.540000e+04,  3.540000e+04,  4.641000e+05,
         3.540000e+04,  8.050000e+04,  3.540000e+04,  1.076000e+05,
         1.076000e+05,  1.076000e+05,  1.075000e+05,  1.013000e+05,
        -1.259000e+05, -1.258000e+05, -1.258000e+05, -2.729000e+05,
        -6.200000e+03,  0.000000e+00, -6.980000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -7.552000e+05, -1.804000e+05, -7.250000e+04,
         1.855300e+06,  6.802000e+05,  6.812000e+05,  1.003900e+06,
         1.003800e+06, -1.930000e+04,  4.402000e+05, -1.930000e+04,
        -4.820000e+04, -1.010000e+04, -1.400000e+04, -4.000000e+03,
        -2.247000e+05,  4.200000e+04, -3.490000e+04,  1.739000e+05,
         0.000000e+00, -8.000000e+02, -2.980000e+04, -8.530000e+04,
        -3.760000e+04, -2.480000e+04, -2.480000e+04, -2.480000e+04,
         0.000000e+00,  0.000000e+00, -2.904000e+05, -2.434000e+05,
        -5.350000e+04, -3.310000e+04, -1.335000e+05, -3.480000e+04,
         1.081000e+05, -4.960000e+04, -1.133000e+05, -1.740000e+04,
         4.627000e+05,  4.626000e+05, -7.150000e+04, -2.220000e+04,
        -9.100000e+03,  3.925000e+05,  4.406000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02, -4.000000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -4.820000e+04,
         4.402000e+05, -2.950000e+04,  1.739000e+05, -3.490000e+04,
         1.076000e+05, -1.000000e+02, -2.470000e+04,  7.300000e+04,
         6.058000e+05,  8.370000e+04,  6.414000e+05, -1.170000e+05,
         4.641000e+05,  3.540000e+04,  8.830000e+04, -1.258000e+05,
        -7.250000e+04, -1.930000e+04, -2.480000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.076000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 2.288000e+05,  1.894000e+05,  1.805000e+05, -1.178000e+05,
         5.550000e+04,  9.028000e+05,  4.452000e+05,  2.316000e+05,
         1.894000e+05,  2.322000e+05,  1.889000e+05,  2.480000e+05,
         2.258000e+05,  4.721000e+05,  0.000000e+00,  2.480000e+05,
         7.210000e+04,  2.481000e+05,  2.610000e+04,  9.913000e+05,
         0.000000e+00,  1.220400e+06,  1.157900e+06,  1.151600e+06,
         6.641000e+05,  1.378000e+05,  6.106000e+05,  7.444000e+05,
         2.082000e+05,  1.103080e+07,  1.051700e+07,  1.098230e+07,
         3.506800e+06,  7.395000e+05,  7.402000e+05,  7.450000e+05,
         7.455000e+05,  7.263000e+05,  7.397000e+05,  6.182200e+06,
         6.105300e+06,  6.090600e+06,  7.227000e+05,  6.975000e+05,
         6.998000e+05, -6.260000e+04, -4.215000e+05,  1.100000e+06,
         1.100100e+06,  8.331000e+05,  5.687000e+05,  8.263000e+05,
         8.015000e+05,  1.948100e+06,  1.924800e+06,  5.901000e+05,
         3.352000e+05,  1.250000e+05, -4.860000e+04, -4.195000e+05,
         2.283900e+06,  2.283300e+06,  2.213700e+06,  2.238000e+06,
         4.199000e+05,  5.071000e+05,  2.789000e+05,  6.598000e+05,
         7.130000e+04,  3.399000e+05,  2.032000e+05, -5.840000e+04,
         2.737000e+05,  4.955000e+05,  4.955000e+05,  4.955000e+05,
         4.955000e+05,  4.570000e+05,  4.570000e+05,  7.253000e+05,
         3.125000e+05,  2.932000e+05, -3.580000e+04,  0.000000e+00,
        -3.067000e+05, -2.722000e+05,  5.359000e+05,  6.655000e+05,
         1.985000e+05,  1.985000e+05,  6.930000e+04,  6.930000e+04,
         6.940000e+04,  1.634000e+06,  1.539100e+06,  2.084000e+06,
         1.034000e+06,  9.366000e+05,  8.769000e+05,  1.034000e+05,
         3.410000e+05,  1.999600e+06,  1.864900e+06,  1.999600e+06,
         1.866700e+06,  2.499600e+06,  2.370900e+06,  2.601200e+06,
         2.280200e+06,  9.865000e+05,  9.631000e+05,  2.532500e+06,
         7.669700e+06,  7.444700e+06,  7.425100e+06,  7.019000e+05,
         1.273800e+06,  7.125700e+06,  7.078300e+06,  7.056900e+06,
         7.351200e+06,  1.724000e+05,  1.009400e+06,  1.185000e+06,
         1.409200e+06,  9.608000e+05,  1.068700e+06,  1.070400e+06,
         1.705400e+06,  1.658900e+06,  1.523500e+06,  1.008500e+06,
         9.328000e+05,  1.233900e+06,  1.545400e+06,  1.676000e+05,
         9.527000e+05,  1.022100e+06,  9.823000e+05,  8.658000e+05,
         5.989000e+05,  4.661000e+05,  4.662000e+05,  4.168000e+05,
         5.493000e+06,  5.609300e+06,  8.138600e+06,  2.295000e+05,
         2.298000e+05,  7.191900e+06,  7.196600e+06,  8.009000e+05,
         7.196100e+06,  1.338560e+07,  7.196600e+06,  2.677000e+05,
         2.676000e+05,  2.676000e+05,  2.675000e+05,  2.641000e+05,
        -2.899000e+05, -2.896000e+05, -2.897000e+05,  4.607000e+05,
         2.367000e+05,  0.000000e+00, -1.740000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.738800e+06,  6.661800e+06,  6.929200e+06,
         2.217400e+06,  1.335700e+06,  1.335200e+06,  2.137100e+06,
         2.136600e+06, -3.830000e+04, -1.783000e+05,  6.000000e+03,
        -1.150000e+04, -3.590000e+04, -2.790000e+04, -1.810000e+04,
         4.721000e+05,  2.481000e+05, -6.830000e+04,  3.000000e+02,
         0.000000e+00,  3.000000e+02, -2.930000e+04, -8.200000e+03,
        -3.410000e+04, -6.110000e+04, -6.120000e+04, -6.120000e+04,
         0.000000e+00,  0.000000e+00,  4.558000e+05,  4.346000e+05,
        -1.069000e+05, -2.810000e+04, -1.970000e+04, -3.150000e+04,
        -1.680000e+04, -1.240000e+04,  2.281000e+05, -3.440000e+04,
        -1.854000e+05, -1.854000e+05, -1.230000e+04, -3.540000e+04,
        -1.630000e+04, -1.985000e+05, -2.209000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -5.000000e+02,  2.200000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.150000e+04,
        -1.783000e+05,  6.190000e+04,  3.000000e+02, -6.830000e+04,
         2.677000e+05, -5.000000e+02,  2.288000e+05,  1.894000e+05,
         6.930000e+04,  4.955000e+05,  3.125000e+05,  7.450000e+05,
         8.009000e+05,  7.196600e+06,  2.298000e+05, -2.897000e+05,
         6.929200e+06,  6.000000e+03, -6.120000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.677000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 4.329000e+05,  2.915000e+05,  2.748000e+05, -6.590000e+04,
         1.831000e+05,  1.748600e+06,  8.828000e+05,  4.317000e+05,
         2.915000e+05,  4.315000e+05,  2.908000e+05,  4.127000e+05,
         3.425000e+05, -1.116000e+05,  0.000000e+00,  4.127000e+05,
         1.619000e+05,  4.126000e+05,  3.950000e+04,  1.651200e+06,
         0.000000e+00,  1.125800e+06,  9.208000e+05,  8.947000e+05,
         3.554000e+05,  3.823000e+05,  9.292000e+05,  1.240700e+06,
         4.745000e+05,  1.051700e+07,  1.187290e+07,  1.036850e+07,
         1.981800e+06,  2.825000e+05,  2.831000e+05,  2.865000e+05,
         2.883000e+05,  6.000000e+04,  2.825000e+05,  2.027300e+06,
         1.755400e+06,  1.719200e+06,  3.025000e+05,  2.294000e+05,
         2.255000e+05,  1.166000e+05, -3.543000e+05,  5.362000e+05,
         5.362000e+05,  5.482000e+05,  5.612000e+05,  5.348000e+05,
         4.369000e+05,  1.148200e+06,  1.077300e+06,  1.137000e+06,
        -1.913000e+05,  3.415000e+05,  9.230000e+04, -3.514000e+05,
         1.817800e+06,  1.817200e+06,  1.654400e+06,  1.663700e+06,
         9.168000e+05,  8.094000e+05,  5.176000e+05,  1.360900e+06,
         1.572000e+05,  5.573000e+05,  3.004000e+05, -9.340000e+04,
         3.948000e+05,  8.274000e+05,  8.274000e+05,  8.273000e+05,
         8.274000e+05,  6.858000e+05,  6.858000e+05,  3.022000e+05,
         5.669000e+05,  4.964000e+05, -4.730000e+04,  0.000000e+00,
        -3.910000e+04,  8.400000e+03,  4.400000e+04,  6.116000e+05,
         2.962000e+05,  2.963000e+05,  1.583000e+05,  1.583000e+05,
         1.584000e+05,  2.767200e+06,  2.415200e+06,  1.717400e+06,
         1.032400e+06,  1.537000e+06,  1.321400e+06,  3.159000e+05,
         1.348700e+06,  3.286900e+06,  2.791200e+06,  3.286900e+06,
         2.794000e+06,  2.275700e+06,  4.295000e+05, -9.460000e+04,
         1.369000e+05,  6.948000e+05,  6.236000e+05,  3.839500e+06,
         7.063500e+06,  7.586700e+06,  7.518500e+06,  2.324000e+05,
         3.255000e+05,  7.226200e+06,  7.019900e+06,  6.995100e+06,
         6.703100e+06,  4.007000e+05,  1.635000e+06,  1.169200e+06,
         6.427000e+05,  1.695800e+06,  8.146000e+05,  7.841000e+05,
         9.952000e+05,  8.534000e+05,  1.447600e+06,  1.631900e+06,
         1.412700e+06,  1.108000e+06,  1.467200e+06,  3.986000e+05,
         1.422400e+06,  1.635600e+06,  6.551000e+05,  5.927000e+05,
         6.047000e+05,  8.323000e+05,  8.324000e+05,  6.332000e+05,
         5.808500e+06,  6.163200e+06,  1.430740e+07,  3.433000e+05,
         3.438000e+05,  7.169600e+06,  7.174300e+06,  4.371000e+05,
         7.173700e+06,  1.367150e+07,  7.174300e+06,  3.943000e+05,
         3.943000e+05,  3.943000e+05,  3.941000e+05,  3.938000e+05,
        -4.203000e+05, -4.200000e+05, -4.201000e+05, -9.450000e+04,
         4.298000e+05,  0.000000e+00, -2.558000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.521500e+06,  6.385200e+06,  6.779800e+06,
         1.089500e+06,  1.224700e+06,  1.223900e+06,  2.405500e+06,
         2.404900e+06, -5.100000e+04, -2.120000e+05,  5.000000e+02,
         1.710000e+04, -5.220000e+04, -3.670000e+04, -2.780000e+04,
        -1.116000e+05,  4.127000e+05, -9.070000e+04, -3.000000e+02,
         0.000000e+00,  3.000000e+02, -4.760000e+04,  2.220000e+04,
        -5.010000e+04, -9.030000e+04, -9.040000e+04, -9.040000e+04,
         0.000000e+00,  0.000000e+00, -9.280000e+04, -1.607000e+05,
        -1.406000e+05, -2.260000e+04,  3.930000e+04, -4.630000e+04,
         1.860000e+04,  1.700000e+04, -6.320000e+04, -4.560000e+04,
        -2.217000e+05, -2.217000e+05,  2.470000e+04, -4.640000e+04,
        -2.370000e+04, -1.984000e+05, -2.683000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -6.000000e+02,  2.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.710000e+04,
        -2.120000e+05, -1.460000e+04, -3.000000e+02, -9.070000e+04,
         3.943000e+05, -6.000000e+02,  4.329000e+05,  2.915000e+05,
         1.583000e+05,  8.274000e+05,  5.669000e+05,  2.877000e+05,
         4.371000e+05,  7.174300e+06,  3.438000e+05, -4.201000e+05,
         6.779800e+06,  5.000000e+02, -9.040000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         3.943000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-3.870000e+04,  5.621000e+05,  1.791000e+05, -8.320000e+04,
        -6.030000e+04, -2.786000e+05, -2.013000e+05, -2.110000e+04,
         5.620000e+05, -1.750000e+04,  5.607000e+05,  1.301000e+05,
         4.162000e+05,  4.520000e+05,  0.000000e+00,  1.301000e+05,
         1.028000e+05,  1.317000e+05,  4.830000e+04,  5.172000e+05,
         0.000000e+00,  8.335000e+05,  1.734200e+06,  1.168000e+06,
         7.344000e+05,  5.236000e+05,  1.491900e+06,  3.786000e+05,
         3.041000e+05,  1.098230e+07,  1.036850e+07,  1.221140e+07,
         3.632900e+06,  7.512000e+05,  7.522000e+05,  7.585000e+05,
         7.524000e+05,  7.151000e+05,  7.517000e+05,  5.625800e+06,
         6.832600e+06,  6.071900e+06,  5.827000e+05,  8.764000e+05,
         6.942000e+05, -1.432000e+05, -3.478000e+05,  1.160400e+06,
         1.160500e+06,  1.050700e+06,  9.439000e+05,  8.787000e+05,
         8.429000e+05,  1.928200e+06,  2.224900e+06,  1.675900e+06,
         3.452000e+05,  4.020000e+04,  1.720000e+04, -3.460000e+05,
         2.074900e+06,  2.074400e+06,  2.700100e+06,  2.297900e+06,
        -4.514000e+05,  3.751000e+05, -1.790000e+04, -4.782000e+05,
         8.420000e+04,  4.003000e+05,  2.255000e+05, -8.590000e+04,
         2.885000e+05,  2.513000e+05,  2.513000e+05,  2.513000e+05,
         2.513000e+05,  8.626000e+05,  8.626000e+05,  5.822000e+05,
         2.227000e+05,  5.255000e+05, -3.610000e+04,  0.000000e+00,
        -1.517000e+05, -2.616000e+05,  5.459000e+05,  7.164000e+05,
         2.126000e+05,  2.126000e+05,  1.004000e+05,  1.004000e+05,
         1.005000e+05,  1.118500e+06,  2.643400e+06,  1.767800e+06,
         5.470000e+05,  6.002000e+05,  1.513400e+06, -3.261000e+05,
         1.271900e+06,  1.176000e+06,  3.315700e+06,  1.176100e+06,
         3.318200e+06,  1.855000e+06,  1.742400e+06,  2.074000e+06,
         2.971100e+06,  8.762000e+05,  1.172500e+06,  5.840000e+06,
         7.733000e+06,  7.406000e+06,  7.707400e+06,  7.126000e+05,
         1.294700e+06,  6.746400e+06,  7.678300e+06,  7.081000e+06,
         7.073900e+06, -2.331000e+05,  6.664000e+05,  4.994000e+05,
         8.250000e+05,  1.737000e+05,  1.982500e+06,  1.056900e+06,
         1.452400e+06,  2.045600e+06,  1.631100e+06,  6.727000e+05,
         1.553700e+06,  1.000500e+06,  1.655100e+06, -2.667000e+05,
         1.592700e+06,  7.600000e+05,  1.025200e+06,  9.375000e+05,
         8.277000e+05,  7.470000e+04,  7.490000e+04,  9.926000e+05,
         6.575900e+06,  5.092800e+06,  1.970200e+06,  2.601000e+05,
         2.604000e+05,  7.276000e+06,  7.280800e+06,  8.416000e+05,
         7.280300e+06,  1.350970e+07,  7.280800e+06,  3.000000e+05,
         2.999000e+05,  2.999000e+05,  2.996000e+05,  2.813000e+05,
        -3.116000e+05, -3.114000e+05, -3.114000e+05,  3.317000e+05,
         9.400000e+03,  0.000000e+00, -1.841000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.869100e+06,  6.691400e+06,  6.986200e+06,
         2.343200e+06,  1.441200e+06,  1.441100e+06,  2.340000e+06,
         2.339500e+06, -3.990000e+04, -1.794000e+05, -1.150000e+04,
        -1.202000e+05,  1.512000e+05,  9.110000e+04, -1.600000e+04,
         4.520000e+05,  1.298000e+05,  2.231000e+05,  2.900000e+03,
         0.000000e+00, -1.800000e+03, -6.220000e+04, -1.618000e+05,
         1.120000e+05, -6.780000e+04, -6.800000e+04, -6.800000e+04,
         0.000000e+00,  0.000000e+00,  2.871000e+05,  5.814000e+05,
         3.484000e+05,  1.550000e+04, -2.819000e+05,  1.035000e+05,
        -1.640000e+05, -1.239000e+05,  2.175000e+05,  1.111000e+05,
        -1.816000e+05, -1.816000e+05, -1.506000e+05,  1.269000e+05,
        -1.950000e+04, -3.311000e+05, -5.440000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -5.000000e+02,  2.800000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.202000e+05,
        -1.794000e+05,  5.930000e+04,  2.900000e+03,  2.231000e+05,
         2.999000e+05, -5.000000e+02, -3.870000e+04,  5.621000e+05,
         1.004000e+05,  2.513000e+05,  2.227000e+05,  7.523000e+05,
         8.416000e+05,  7.280800e+06,  2.604000e+05, -3.114000e+05,
         6.986200e+06, -1.150000e+04, -6.800000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         3.000000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-1.720000e+05, -3.180000e+04,  7.690000e+04,  6.201300e+06,
         3.007500e+06, -7.954000e+05, -4.514000e+05, -1.557000e+05,
        -3.180000e+04, -1.531000e+05, -3.120000e+04, -2.940000e+04,
         2.920000e+04,  1.495700e+06,  0.000000e+00, -2.940000e+04,
         3.203500e+06, -2.960000e+04,  3.500000e+03, -1.054000e+05,
         0.000000e+00,  1.428100e+06,  1.656100e+06,  1.815700e+06,
         1.190740e+07,  9.623000e+06, -2.330000e+04, -6.000000e+04,
         9.759800e+06,  3.506800e+06,  1.981800e+06,  3.632900e+06,
         7.370570e+07,  1.595600e+06,  1.598500e+06,  1.596000e+06,
         1.595800e+06,  1.920300e+06,  1.600100e+06,  1.372750e+07,
         1.404780e+07,  1.424430e+07,  1.468500e+06,  1.546700e+06,
         1.597700e+06,  9.217900e+06,  1.537480e+07,  9.360300e+06,
         9.359000e+06,  8.427200e+06,  7.355200e+06,  8.544300e+06,
         5.110300e+06,  1.778240e+07,  1.785970e+07,  1.320040e+07,
         8.335000e+06,  6.250400e+06,  9.461700e+06,  1.537060e+07,
         3.240400e+06,  3.242000e+06,  3.388600e+06,  3.498800e+06,
        -6.681000e+05,  6.150000e+04, -1.770000e+05, -8.157000e+05,
         3.226700e+06,  3.312000e+06,  8.410000e+04, -1.613000e+05,
        -4.810000e+04, -4.880000e+04, -4.880000e+04, -4.880000e+04,
        -4.880000e+04,  6.700000e+04,  6.700000e+04,  1.478600e+06,
         3.297300e+06,  3.358600e+06, -9.750000e+04,  0.000000e+00,
        -9.575000e+05, -8.439000e+05,  4.964900e+06,  2.731500e+06,
         7.710000e+04,  7.710000e+04,  3.253300e+06,  3.252500e+06,
         3.252300e+06,  6.634000e+06,  6.917900e+06,  9.824200e+06,
         7.836600e+06, -1.614000e+05,  3.300000e+03, -5.517000e+05,
        -1.673700e+06, -6.550000e+04,  3.397000e+05, -6.560000e+04,
         3.347000e+05,  2.970900e+06,  5.685900e+06,  7.211000e+06,
         5.931500e+06,  1.578600e+06,  1.655900e+06,  1.750000e+04,
         1.573300e+06,  4.900000e+04,  1.256000e+05,  1.499600e+06,
         6.610100e+06, -3.052000e+05, -1.186000e+05,  8.240000e+04,
         1.219900e+06, -4.413000e+05,  5.160000e+04,  1.153900e+06,
         2.685700e+06, -3.779000e+05,  1.540000e+06,  1.799900e+06,
         3.058500e+06,  3.212900e+06,  1.868800e+06,  3.380000e+04,
         2.685000e+05,  1.555700e+06,  1.894800e+06, -3.610000e+05,
         2.007000e+05, -1.683000e+05,  1.663700e+06,  8.567600e+06,
         7.635700e+06, -2.031000e+05, -2.030000e+05,  4.900000e+03,
         1.529800e+06,  1.143700e+06, -2.891300e+06, -1.000000e+02,
         0.000000e+00,  6.770000e+04,  6.770000e+04,  5.130900e+06,
         6.930000e+04, -1.561800e+06,  6.770000e+04,  9.870000e+04,
         9.870000e+04,  9.870000e+04,  9.880000e+04,  9.400000e+04,
        -1.881000e+05, -1.880000e+05, -1.880000e+05,  1.390300e+06,
        -1.338000e+05,  0.000000e+00, -1.111000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.128600e+06, -1.574000e+05, -4.510000e+04,
         1.834310e+07,  5.323800e+06,  5.318500e+06,  5.617700e+06,
         5.619300e+06, -9.700000e+04,  2.817900e+06, -1.468000e+05,
        -1.058000e+05, -5.550000e+04, -5.120000e+04,  6.400000e+03,
         1.495700e+06, -2.870000e+04, -1.442000e+05,  2.200000e+03,
         0.000000e+00, -9.000000e+02, -1.125000e+05, -3.175000e+05,
        -1.921000e+05, -2.530000e+04, -2.500000e+04, -2.500000e+04,
         0.000000e+00,  0.000000e+00,  1.369500e+06,  1.450700e+06,
        -1.959000e+05, -8.590000e+04, -4.231000e+05, -1.776000e+05,
        -1.233000e+05, -1.073000e+05,  7.390000e+05, -7.120000e+04,
         2.952700e+06,  2.952400e+06, -2.033000e+05, -8.030000e+04,
        -1.850000e+04,  2.767900e+06,  2.874400e+06,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.600000e+03, -2.750000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.058000e+05,
         2.817900e+06,  1.962000e+05,  2.200000e+03, -1.442000e+05,
         9.870000e+04,  1.600000e+03, -1.720000e+05, -3.180000e+04,
         3.252500e+06, -4.880000e+04,  3.297300e+06,  1.595700e+06,
         5.130900e+06,  6.770000e+04,  0.000000e+00, -1.880000e+05,
        -4.510000e+04, -1.468000e+05, -2.500000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         9.870000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-3.080000e+04, -1.900000e+04, -1.290000e+04, -6.010000e+04,
        -4.530000e+04, -1.287000e+05, -6.710000e+04, -3.020000e+04,
        -1.900000e+04, -3.010000e+04, -1.900000e+04, -2.370000e+04,
        -1.820000e+04,  4.342000e+05,  0.000000e+00, -2.370000e+04,
        -3.870000e+04, -2.360000e+04, -2.100000e+03, -9.490000e+04,
         0.000000e+00,  3.615000e+05,  3.767000e+05,  3.879000e+05,
         3.076000e+05, -1.195000e+05, -5.570000e+04, -7.220000e+04,
        -1.171000e+05,  7.395000e+05,  2.825000e+05,  7.512000e+05,
         1.595600e+06,  4.196000e+05,  4.179000e+05,  4.170000e+05,
         4.178000e+05,  5.346000e+05,  4.178000e+05,  3.753900e+06,
         3.773700e+06,  3.789000e+06,  4.100000e+05,  4.143000e+05,
         4.188000e+05, -1.055000e+05, -1.414000e+05,  5.475000e+05,
         5.475000e+05,  3.319000e+05,  1.177000e+05,  3.343000e+05,
         3.740000e+05,  8.725000e+05,  8.771000e+05, -2.008000e+05,
         3.668000e+05, -8.420000e+04, -9.920000e+04, -1.413000e+05,
         7.686000e+05,  7.686000e+05,  7.797000e+05,  7.862000e+05,
        -7.840000e+04, -4.230000e+04, -3.600000e+04, -1.098000e+05,
        -3.940000e+04, -5.560000e+04, -1.290000e+04,  6.900000e+03,
        -1.360000e+04, -4.770000e+04, -4.770000e+04, -4.770000e+04,
        -4.770000e+04, -3.570000e+04, -3.570000e+04,  4.090000e+05,
        -6.310000e+04, -5.720000e+04, -1.500000e+03,  0.000000e+00,
        -2.187000e+05, -2.183000e+05,  3.918000e+05,  1.679000e+05,
        -1.310000e+04, -1.310000e+04, -3.910000e+04, -3.910000e+04,
        -3.910000e+04, -2.147000e+05, -1.846000e+05,  6.965000e+05,
         2.872000e+05, -9.120000e+04, -7.300000e+04, -4.280000e+04,
        -5.105000e+05, -1.836000e+05, -1.415000e+05, -1.836000e+05,
        -1.416000e+05,  7.298000e+05,  1.669500e+06,  2.126300e+06,
         1.693100e+06,  3.938000e+05,  3.984000e+05, -2.215000e+05,
         4.385000e+05, -2.020000e+04, -1.530000e+04,  4.168000e+05,
         8.082000e+05, -1.750000e+04, -1.000000e+02,  8.900000e+03,
         4.412000e+05, -3.890000e+04, -8.860000e+04,  3.463000e+05,
         8.034000e+05, -1.108000e+05,  3.694000e+05,  3.903000e+05,
         8.044000e+05,  8.136000e+05,  3.634000e+05, -8.820000e+04,
        -7.540000e+04,  3.701000e+05,  3.672000e+05, -3.960000e+04,
        -7.030000e+04, -8.340000e+04,  3.945000e+05,  3.320000e+05,
         1.164000e+05, -5.430000e+04, -5.430000e+04, -3.700000e+04,
         2.097000e+05,  1.865000e+05, -9.093000e+05, -1.800000e+04,
        -1.810000e+04,  3.900000e+03,  3.900000e+03,  3.732000e+05,
         3.800000e+03, -3.934000e+05,  3.900000e+03, -1.670000e+04,
        -1.670000e+04, -1.670000e+04, -1.670000e+04, -1.720000e+04,
         1.350000e+04,  1.350000e+04,  1.350000e+04,  4.288000e+05,
        -2.920000e+04,  0.000000e+00,  9.100000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  8.120000e+04,  3.750000e+04,  2.070000e+04,
         1.098500e+06,  3.399000e+05,  3.401000e+05,  2.899000e+05,
         2.899000e+05, -1.500000e+03, -2.020000e+04,  3.100000e+03,
        -5.400000e+03, -5.000000e+02, -9.000000e+02,  1.200000e+03,
         4.342000e+05, -2.380000e+04, -1.500000e+03,  1.000000e+02,
         0.000000e+00,  0.000000e+00,  3.700000e+03, -3.200000e+03,
         8.000000e+02,  3.900000e+03,  3.900000e+03,  3.900000e+03,
         0.000000e+00,  0.000000e+00,  4.253000e+05,  4.315000e+05,
        -3.600000e+03, -3.100000e+03, -8.500000e+03,  7.000000e+02,
        -8.300000e+03, -5.600000e+03,  2.155000e+05, -8.000000e+02,
        -2.100000e+04, -2.100000e+04, -6.100000e+03, -1.700000e+03,
         1.100000e+03, -2.710000e+04, -2.280000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  2.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -5.400000e+03,
        -2.020000e+04,  5.700000e+04,  1.000000e+02, -1.500000e+03,
        -1.670000e+04, -1.000000e+02, -3.080000e+04, -1.900000e+04,
        -3.910000e+04, -4.770000e+04, -6.310000e+04,  4.178000e+05,
         3.732000e+05,  3.900000e+03, -1.810000e+04,  1.350000e+04,
         2.070000e+04,  3.100000e+03,  3.900000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.670000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-3.080000e+04, -1.900000e+04, -1.280000e+04, -6.020000e+04,
        -4.540000e+04, -1.287000e+05, -6.720000e+04, -3.010000e+04,
        -1.900000e+04, -3.000000e+04, -1.900000e+04, -2.350000e+04,
        -1.810000e+04,  4.342000e+05,  0.000000e+00, -2.350000e+04,
        -3.880000e+04, -2.340000e+04, -2.100000e+03, -9.410000e+04,
         0.000000e+00,  3.619000e+05,  3.775000e+05,  3.883000e+05,
         3.081000e+05, -1.197000e+05, -5.580000e+04, -7.190000e+04,
        -1.172000e+05,  7.402000e+05,  2.831000e+05,  7.522000e+05,
         1.598500e+06,  4.179000e+05,  4.191000e+05,  4.175000e+05,
         4.177000e+05,  5.345000e+05,  4.190000e+05,  3.758800e+06,
         3.782900e+06,  3.794100e+06,  4.108000e+05,  4.146000e+05,
         4.196000e+05, -1.057000e+05, -1.417000e+05,  5.485000e+05,
         5.485000e+05,  3.326000e+05,  1.180000e+05,  3.348000e+05,
         3.749000e+05,  8.740000e+05,  8.784000e+05, -2.009000e+05,
         3.668000e+05, -8.430000e+04, -9.940000e+04, -1.416000e+05,
         7.689000e+05,  7.688000e+05,  7.808000e+05,  7.865000e+05,
        -7.840000e+04, -4.210000e+04, -3.600000e+04, -1.099000e+05,
        -3.970000e+04, -5.560000e+04, -1.290000e+04,  6.900000e+03,
        -1.360000e+04, -4.760000e+04, -4.760000e+04, -4.760000e+04,
        -4.760000e+04, -3.560000e+04, -3.560000e+04,  4.093000e+05,
        -6.310000e+04, -5.710000e+04, -1.700000e+03,  0.000000e+00,
        -2.186000e+05, -2.185000e+05,  3.920000e+05,  1.690000e+05,
        -1.300000e+04, -1.300000e+04, -3.910000e+04, -3.910000e+04,
        -3.910000e+04, -2.143000e+05, -1.845000e+05,  6.979000e+05,
         2.875000e+05, -9.140000e+04, -7.240000e+04, -4.490000e+04,
        -5.106000e+05, -1.833000e+05, -1.414000e+05, -1.833000e+05,
        -1.415000e+05,  7.296000e+05,  1.670300e+06,  2.127200e+06,
         1.694200e+06,  3.951000e+05,  3.995000e+05, -2.218000e+05,
         4.381000e+05, -2.170000e+04, -1.700000e+04,  4.169000e+05,
         8.099000e+05, -1.770000e+04, -1.000000e+02,  8.700000e+03,
         4.419000e+05, -3.870000e+04, -8.830000e+04,  3.466000e+05,
         8.038000e+05, -1.105000e+05,  3.689000e+05,  3.907000e+05,
         8.069000e+05,  8.158000e+05,  3.629000e+05, -8.810000e+04,
        -7.650000e+04,  3.715000e+05,  3.681000e+05, -3.920000e+04,
        -7.020000e+04, -8.300000e+04,  3.939000e+05,  3.326000e+05,
         1.167000e+05, -5.420000e+04, -5.420000e+04, -3.700000e+04,
         2.104000e+05,  1.881000e+05, -9.086000e+05, -1.770000e+04,
        -1.770000e+04,  3.900000e+03,  3.900000e+03,  3.740000e+05,
         3.900000e+03, -3.946000e+05,  3.900000e+03, -1.670000e+04,
        -1.670000e+04, -1.670000e+04, -1.670000e+04, -1.670000e+04,
         1.320000e+04,  1.320000e+04,  1.320000e+04,  4.288000e+05,
        -2.900000e+04,  0.000000e+00,  8.700000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  7.920000e+04,  3.740000e+04,  2.070000e+04,
         1.100900e+06,  3.408000e+05,  3.411000e+05,  2.910000e+05,
         2.909000e+05, -1.200000e+03, -2.030000e+04,  3.100000e+03,
        -5.400000e+03, -6.000000e+02, -1.000000e+03,  1.200000e+03,
         4.342000e+05, -2.350000e+04, -1.500000e+03,  1.000000e+02,
         0.000000e+00,  0.000000e+00,  3.600000e+03, -3.200000e+03,
         9.000000e+02,  3.900000e+03,  3.900000e+03,  3.900000e+03,
         0.000000e+00,  0.000000e+00,  4.256000e+05,  4.319000e+05,
        -3.700000e+03, -3.100000e+03, -8.600000e+03,  8.000000e+02,
        -8.100000e+03, -5.600000e+03,  2.152000e+05, -8.000000e+02,
        -2.110000e+04, -2.110000e+04, -6.100000e+03, -1.900000e+03,
         1.100000e+03, -2.720000e+04, -2.290000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  2.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -5.400000e+03,
        -2.030000e+04,  5.700000e+04,  1.000000e+02, -1.500000e+03,
        -1.670000e+04, -1.000000e+02, -3.080000e+04, -1.900000e+04,
        -3.910000e+04, -4.760000e+04, -6.310000e+04,  4.177000e+05,
         3.740000e+05,  3.900000e+03, -1.770000e+04,  1.320000e+04,
         2.070000e+04,  3.100000e+03,  3.900000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.670000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-3.110000e+04, -1.840000e+04, -1.290000e+04, -6.000000e+04,
        -4.540000e+04, -1.299000e+05, -6.780000e+04, -3.040000e+04,
        -1.840000e+04, -3.020000e+04, -1.840000e+04, -2.370000e+04,
        -1.790000e+04,  4.337000e+05,  0.000000e+00, -2.370000e+04,
        -3.870000e+04, -2.370000e+04, -2.100000e+03, -9.520000e+04,
         0.000000e+00,  3.624000e+05,  3.782000e+05,  3.893000e+05,
         3.078000e+05, -1.189000e+05, -5.420000e+04, -7.190000e+04,
        -1.171000e+05,  7.450000e+05,  2.865000e+05,  7.585000e+05,
         1.596000e+06,  4.170000e+05,  4.175000e+05,  4.211000e+05,
         4.175000e+05,  5.341000e+05,  4.174000e+05,  3.751000e+06,
         3.776900e+06,  3.786800e+06,  4.100000e+05,  4.147000e+05,
         4.190000e+05, -1.056000e+05, -1.413000e+05,  5.478000e+05,
         5.478000e+05,  3.324000e+05,  1.184000e+05,  3.349000e+05,
         3.741000e+05,  8.731000e+05,  8.781000e+05, -1.988000e+05,
         3.666000e+05, -8.440000e+04, -9.920000e+04, -1.413000e+05,
         7.718000e+05,  7.718000e+05,  7.866000e+05,  7.898000e+05,
        -7.900000e+04, -4.240000e+04, -3.620000e+04, -1.101000e+05,
        -3.870000e+04, -5.550000e+04, -1.280000e+04,  7.000000e+03,
        -1.340000e+04, -4.790000e+04, -4.790000e+04, -4.790000e+04,
        -4.790000e+04, -3.500000e+04, -3.500000e+04,  4.102000e+05,
        -6.330000e+04, -5.690000e+04, -1.600000e+03,  0.000000e+00,
        -2.180000e+05, -2.183000e+05,  3.915000e+05,  1.685000e+05,
        -1.300000e+04, -1.300000e+04, -3.910000e+04, -3.910000e+04,
        -3.910000e+04, -2.153000e+05, -1.830000e+05,  6.971000e+05,
         2.867000e+05, -9.160000e+04, -7.150000e+04, -4.440000e+04,
        -5.073000e+05, -1.843000e+05, -1.391000e+05, -1.843000e+05,
        -1.391000e+05,  7.334000e+05,  1.673200e+06,  2.131400e+06,
         1.699800e+06,  3.934000e+05,  3.983000e+05, -2.157000e+05,
         4.384000e+05, -1.960000e+04, -1.420000e+04,  4.158000e+05,
         8.078000e+05, -1.830000e+04,  2.000000e+02,  8.600000e+03,
         4.398000e+05, -3.930000e+04, -8.870000e+04,  3.472000e+05,
         8.046000e+05, -1.101000e+05,  3.719000e+05,  3.920000e+05,
         8.033000e+05,  8.132000e+05,  3.625000e+05, -8.850000e+04,
        -7.450000e+04,  3.695000e+05,  3.697000e+05, -3.990000e+04,
        -6.910000e+04, -8.400000e+04,  3.934000e+05,  3.322000e+05,
         1.168000e+05, -5.470000e+04, -5.470000e+04, -3.610000e+04,
         2.118000e+05,  1.871000e+05, -9.158000e+05, -1.780000e+04,
        -1.780000e+04,  4.100000e+03,  4.100000e+03,  3.734000e+05,
         4.000000e+03, -3.927000e+05,  4.100000e+03, -1.660000e+04,
        -1.660000e+04, -1.660000e+04, -1.660000e+04, -1.710000e+04,
         1.310000e+04,  1.310000e+04,  1.310000e+04,  4.284000e+05,
        -2.910000e+04,  0.000000e+00,  9.000000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  7.890000e+04,  3.750000e+04,  2.080000e+04,
         1.099200e+06,  3.404000e+05,  3.405000e+05,  2.906000e+05,
         2.906000e+05, -1.300000e+03, -2.030000e+04,  3.200000e+03,
        -5.400000e+03, -2.000000e+02, -7.000000e+02,  1.200000e+03,
         4.337000e+05, -2.370000e+04, -1.100000e+03,  1.000000e+02,
         0.000000e+00,  0.000000e+00,  3.000000e+03, -3.200000e+03,
         1.000000e+02,  3.900000e+03,  3.900000e+03,  3.900000e+03,
         0.000000e+00,  0.000000e+00,  4.261000e+05,  4.329000e+05,
        -2.700000e+03, -2.900000e+03, -8.500000e+03,  1.000000e+02,
        -7.400000e+03, -5.600000e+03,  2.148000e+05, -6.000000e+02,
        -2.100000e+04, -2.100000e+04, -6.300000e+03, -1.300000e+03,
         1.100000e+03, -2.730000e+04, -2.230000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  2.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -5.400000e+03,
        -2.030000e+04,  5.690000e+04,  1.000000e+02, -1.100000e+03,
        -1.660000e+04, -1.000000e+02, -3.110000e+04, -1.840000e+04,
        -3.910000e+04, -4.790000e+04, -6.330000e+04,  4.175000e+05,
         3.734000e+05,  4.100000e+03, -1.780000e+04,  1.310000e+04,
         2.080000e+04,  3.200000e+03,  3.900000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.660000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-3.070000e+04, -1.910000e+04, -1.290000e+04, -6.010000e+04,
        -4.530000e+04, -1.287000e+05, -6.720000e+04, -3.020000e+04,
        -1.910000e+04, -3.010000e+04, -1.910000e+04, -2.390000e+04,
        -1.840000e+04,  4.352000e+05,  0.000000e+00, -2.390000e+04,
        -3.860000e+04, -2.380000e+04, -2.100000e+03, -9.500000e+04,
         0.000000e+00,  3.625000e+05,  3.763000e+05,  3.887000e+05,
         3.073000e+05, -1.192000e+05, -5.630000e+04, -7.180000e+04,
        -1.170000e+05,  7.455000e+05,  2.883000e+05,  7.524000e+05,
         1.595800e+06,  4.178000e+05,  4.177000e+05,  4.175000e+05,
         4.379000e+05,  5.561000e+05,  4.176000e+05,  3.758900e+06,
         3.774000e+06,  3.794000e+06,  4.105000e+05,  4.145000e+05,
         4.192000e+05, -1.056000e+05, -1.416000e+05,  5.471000e+05,
         5.471000e+05,  3.315000e+05,  1.175000e+05,  3.344000e+05,
         3.736000e+05,  8.722000e+05,  8.764000e+05, -2.012000e+05,
         3.675000e+05, -8.410000e+04, -9.930000e+04, -1.415000e+05,
         7.818000e+05,  7.818000e+05,  7.805000e+05,  7.994000e+05,
        -7.890000e+04, -4.120000e+04, -3.580000e+04, -1.092000e+05,
        -3.960000e+04, -5.570000e+04, -1.310000e+04,  7.000000e+03,
        -1.390000e+04, -4.680000e+04, -4.680000e+04, -4.680000e+04,
        -4.680000e+04, -3.610000e+04, -3.610000e+04,  4.085000e+05,
        -6.280000e+04, -5.710000e+04, -1.300000e+03,  0.000000e+00,
        -2.183000e+05, -2.182000e+05,  3.924000e+05,  1.667000e+05,
        -1.320000e+04, -1.320000e+04, -3.910000e+04, -3.910000e+04,
        -3.910000e+04, -2.125000e+05, -1.855000e+05,  6.957000e+05,
         2.860000e+05, -8.950000e+04, -7.330000e+04, -4.050000e+04,
        -5.106000e+05, -1.806000e+05, -1.431000e+05, -1.806000e+05,
        -1.434000e+05,  7.478000e+05,  1.663800e+06,  2.119500e+06,
         1.680000e+06,  3.942000e+05,  3.985000e+05, -2.237000e+05,
         4.407000e+05, -1.810000e+04, -1.340000e+04,  4.167000e+05,
         8.082000e+05, -1.460000e+04, -4.000000e+02,  1.170000e+04,
         4.444000e+05, -4.010000e+04, -8.640000e+04,  3.485000e+05,
         8.038000e+05, -1.068000e+05,  3.700000e+05,  3.923000e+05,
         8.054000e+05,  8.140000e+05,  3.623000e+05, -8.690000e+04,
        -7.480000e+04,  3.711000e+05,  3.666000e+05, -3.700000e+04,
        -7.120000e+04, -8.460000e+04,  3.939000e+05,  3.315000e+05,
         1.160000e+05, -5.400000e+04, -5.400000e+04, -3.730000e+04,
         2.081000e+05,  1.867000e+05, -9.019000e+05, -1.800000e+04,
        -1.800000e+04,  3.200000e+03,  3.200000e+03,  3.727000e+05,
         3.200000e+03, -3.942000e+05,  3.200000e+03, -1.700000e+04,
        -1.700000e+04, -1.700000e+04, -1.700000e+04, -1.750000e+04,
         1.320000e+04,  1.320000e+04,  1.320000e+04,  4.296000e+05,
        -2.950000e+04,  0.000000e+00,  9.400000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  7.940000e+04,  3.630000e+04,  1.980000e+04,
         1.097100e+06,  3.389000e+05,  3.392000e+05,  2.881000e+05,
         2.880000e+05, -1.100000e+03, -2.010000e+04,  3.100000e+03,
        -5.500000e+03, -5.000000e+02, -9.000000e+02,  1.200000e+03,
         4.352000e+05, -2.390000e+04, -1.300000e+03,  2.000000e+02,
         0.000000e+00,  0.000000e+00,  3.900000e+03, -3.100000e+03,
         7.000000e+02,  3.900000e+03,  3.900000e+03,  3.900000e+03,
         0.000000e+00,  0.000000e+00,  4.231000e+05,  4.322000e+05,
        -3.300000e+03, -2.900000e+03, -8.700000e+03,  7.000000e+02,
        -1.060000e+04, -5.800000e+03,  2.155000e+05, -7.000000e+02,
        -2.110000e+04, -2.110000e+04, -6.100000e+03, -1.600000e+03,
         1.100000e+03, -2.720000e+04, -2.270000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  2.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -5.500000e+03,
        -2.010000e+04,  5.710000e+04,  2.000000e+02, -1.300000e+03,
        -1.700000e+04, -1.000000e+02, -3.070000e+04, -1.910000e+04,
        -3.910000e+04, -4.680000e+04, -6.280000e+04,  4.375000e+05,
         3.727000e+05,  3.200000e+03, -1.800000e+04,  1.320000e+04,
         1.980000e+04,  3.100000e+03,  3.900000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.700000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-5.340000e+04, -6.180000e+04, -4.790000e+04, -8.000000e+04,
        -6.660000e+04, -2.080000e+05, -1.011000e+05, -5.460000e+04,
        -6.170000e+04, -5.490000e+04, -6.160000e+04, -6.240000e+04,
        -6.560000e+04,  6.066000e+05,  0.000000e+00, -6.240000e+04,
        -7.540000e+04, -6.250000e+04, -7.600000e+03, -2.492000e+05,
         0.000000e+00,  4.187000e+05,  4.003000e+05,  4.256000e+05,
         3.671000e+05, -2.184000e+05, -1.904000e+05, -1.869000e+05,
        -2.270000e+05,  7.263000e+05,  6.000000e+04,  7.151000e+05,
         1.920300e+06,  5.346000e+05,  5.345000e+05,  5.341000e+05,
         5.561000e+05,  7.581000e+05,  5.344000e+05,  4.956900e+06,
         4.927900e+06,  4.966000e+06,  5.430000e+05,  5.367000e+05,
         5.453000e+05, -1.468000e+05, -1.651000e+05,  6.748000e+05,
         6.748000e+05,  3.793000e+05,  8.570000e+04,  3.866000e+05,
         4.531000e+05,  1.058200e+06,  1.051900e+06, -4.255000e+05,
         5.186000e+05, -1.420000e+05, -1.558000e+05, -1.654000e+05,
         8.759000e+05,  8.759000e+05,  8.610000e+05,  8.805000e+05,
        -8.950000e+04, -1.296000e+05, -6.600000e+04, -1.449000e+05,
        -7.740000e+04, -1.467000e+05, -5.430000e+04,  1.960000e+04,
        -6.880000e+04, -1.236000e+05, -1.236000e+05, -1.236000e+05,
        -1.236000e+05, -1.331000e+05, -1.331000e+05,  5.417000e+05,
        -1.374000e+05, -1.418000e+05,  3.300000e+03,  0.000000e+00,
        -2.935000e+05, -2.994000e+05,  5.265000e+05,  1.515000e+05,
        -5.280000e+04, -5.280000e+04, -7.570000e+04, -7.560000e+04,
        -7.570000e+04, -5.311000e+05, -5.546000e+05,  7.966000e+05,
         3.403000e+05, -2.493000e+05, -2.628000e+05, -3.420000e+04,
        -8.620000e+05, -5.033000e+05, -5.366000e+05, -5.033000e+05,
        -5.372000e+05,  8.337000e+05,  2.306300e+06,  2.971300e+06,
         2.284900e+06,  4.727000e+05,  4.665000e+05, -7.748000e+05,
         6.035000e+05, -6.480000e+04, -7.080000e+04,  5.387000e+05,
         1.058900e+06,  2.400000e+04,  8.300000e+03,  3.090000e+04,
         6.926000e+05, -4.220000e+04, -2.556000e+05,  4.355000e+05,
         1.101400e+06, -2.304000e+05,  4.043000e+05,  4.469000e+05,
         1.016800e+06,  1.004400e+06,  3.165000e+05, -2.560000e+05,
        -2.750000e+05,  4.114000e+05,  3.202000e+05, -3.790000e+04,
        -2.710000e+05, -2.570000e+05,  4.566000e+05,  3.739000e+05,
         7.840000e+04, -1.129000e+05, -1.130000e+05, -1.284000e+05,
         6.900000e+03,  3.810000e+04, -1.986300e+06, -6.710000e+04,
        -6.720000e+04, -5.300000e+03, -5.300000e+03,  4.520000e+05,
        -5.400000e+03, -4.738000e+05, -5.300000e+03, -7.130000e+04,
        -7.130000e+04, -7.130000e+04, -7.130000e+04, -7.020000e+04,
         6.830000e+04,  6.830000e+04,  6.830000e+04,  6.123000e+05,
        -5.680000e+04,  0.000000e+00,  4.260000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  4.098000e+05,  1.361000e+05,  6.540000e+04,
         1.351200e+06,  3.096000e+05,  3.099000e+05,  9.580000e+04,
         9.580000e+04,  4.100000e+03, -4.000000e+03,  2.500000e+03,
         5.600000e+03,  3.500000e+03,  3.300000e+03,  4.500000e+03,
         6.066000e+05, -6.240000e+04,  9.100000e+03, -1.000000e+02,
         0.000000e+00,  0.000000e+00,  1.130000e+04,  1.040000e+04,
         5.500000e+03,  1.630000e+04,  1.630000e+04,  1.630000e+04,
         0.000000e+00,  0.000000e+00,  6.110000e+05,  6.088000e+05,
         1.260000e+04,  5.400000e+03,  1.610000e+04,  5.100000e+03,
         5.500000e+03,  5.800000e+03,  3.013000e+05,  4.500000e+03,
        -4.800000e+03, -4.800000e+03,  8.000000e+03,  3.300000e+03,
         4.600000e+03,  3.100000e+03, -1.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  5.600000e+03,
        -4.000000e+03,  7.960000e+04, -1.000000e+02,  9.100000e+03,
        -7.130000e+04,  0.000000e+00, -5.340000e+04, -6.180000e+04,
        -7.560000e+04, -1.236000e+05, -1.374000e+05,  5.572000e+05,
         4.520000e+05, -5.300000e+03, -6.720000e+04,  6.830000e+04,
         6.540000e+04,  2.500000e+03,  1.630000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -7.130000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-3.090000e+04, -1.900000e+04, -1.290000e+04, -6.020000e+04,
        -4.540000e+04, -1.287000e+05, -6.700000e+04, -3.020000e+04,
        -1.900000e+04, -3.010000e+04, -1.900000e+04, -2.350000e+04,
        -1.810000e+04,  4.342000e+05,  0.000000e+00, -2.350000e+04,
        -3.880000e+04, -2.340000e+04, -2.100000e+03, -9.440000e+04,
         0.000000e+00,  3.616000e+05,  3.773000e+05,  3.881000e+05,
         3.080000e+05, -1.197000e+05, -5.590000e+04, -7.220000e+04,
        -1.173000e+05,  7.397000e+05,  2.825000e+05,  7.517000e+05,
         1.600100e+06,  4.178000e+05,  4.190000e+05,  4.174000e+05,
         4.176000e+05,  5.344000e+05,  8.524000e+05,  3.759000e+06,
         3.783300e+06,  3.794400e+06,  4.111000e+05,  4.150000e+05,
         4.200000e+05, -1.057000e+05, -1.416000e+05,  5.486000e+05,
         5.486000e+05,  3.327000e+05,  1.181000e+05,  3.349000e+05,
         3.756000e+05,  8.753000e+05,  8.797000e+05, -1.996000e+05,
         3.668000e+05, -8.430000e+04, -9.940000e+04, -1.415000e+05,
         7.685000e+05,  7.689000e+05,  7.805000e+05,  7.862000e+05,
        -7.740000e+04, -4.180000e+04, -3.560000e+04, -1.095000e+05,
        -3.970000e+04, -5.560000e+04, -1.290000e+04,  6.900000e+03,
        -1.360000e+04, -4.780000e+04, -4.780000e+04, -4.780000e+04,
        -4.780000e+04, -3.580000e+04, -3.580000e+04,  4.092000e+05,
        -6.320000e+04, -5.720000e+04, -1.700000e+03,  0.000000e+00,
        -2.186000e+05, -2.186000e+05,  3.919000e+05,  1.689000e+05,
        -1.310000e+04, -1.310000e+04, -3.920000e+04, -3.910000e+04,
        -3.910000e+04, -2.144000e+05, -1.844000e+05,  6.980000e+05,
         2.877000e+05, -9.130000e+04, -7.220000e+04, -4.470000e+04,
        -5.104000e+05, -1.835000e+05, -1.414000e+05, -1.835000e+05,
        -1.415000e+05,  7.295000e+05,  1.670000e+06,  2.127000e+06,
         1.694100e+06,  3.959000e+05,  4.003000e+05, -2.202000e+05,
         4.385000e+05, -2.140000e+04, -1.670000e+04,  4.172000e+05,
         8.102000e+05, -1.740000e+04,  3.000000e+02,  9.100000e+03,
         4.423000e+05, -3.840000e+04, -8.820000e+04,  3.481000e+05,
         8.053000e+05, -1.092000e+05,  3.705000e+05,  3.923000e+05,
         8.084000e+05,  8.174000e+05,  3.631000e+05, -8.790000e+04,
        -7.630000e+04,  3.717000e+05,  3.683000e+05, -3.890000e+04,
        -7.000000e+04, -8.290000e+04,  3.946000e+05,  3.329000e+05,
         1.171000e+05, -5.350000e+04, -5.350000e+04, -3.620000e+04,
         2.127000e+05,  1.903000e+05, -8.981000e+05, -1.780000e+04,
        -1.780000e+04,  3.900000e+03,  3.900000e+03,  3.739000e+05,
         4.200000e+03, -3.946000e+05,  3.900000e+03, -1.670000e+04,
        -1.670000e+04, -1.670000e+04, -1.670000e+04, -1.680000e+04,
         1.320000e+04,  1.320000e+04,  1.320000e+04,  4.287000e+05,
        -2.910000e+04,  0.000000e+00,  8.700000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  7.930000e+04,  3.750000e+04,  2.070000e+04,
         1.100600e+06,  3.415000e+05,  3.426000e+05,  2.932000e+05,
         2.936000e+05, -8.000000e+02, -2.020000e+04,  3.100000e+03,
        -5.400000e+03, -6.000000e+02, -1.000000e+03,  1.200000e+03,
         4.342000e+05, -2.360000e+04, -1.500000e+03,  1.000000e+02,
         0.000000e+00,  0.000000e+00,  3.600000e+03, -3.200000e+03,
         9.000000e+02,  3.900000e+03,  3.900000e+03,  3.900000e+03,
         0.000000e+00,  0.000000e+00,  4.255000e+05,  4.319000e+05,
        -3.700000e+03, -3.100000e+03, -8.600000e+03,  8.000000e+02,
        -8.200000e+03, -5.200000e+03,  2.154000e+05, -6.000000e+02,
        -2.110000e+04, -2.100000e+04, -6.200000e+03, -1.900000e+03,
         1.100000e+03, -2.720000e+04, -2.290000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  4.000000e+02,  2.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -5.400000e+03,
        -2.020000e+04,  5.700000e+04,  1.000000e+02, -1.500000e+03,
        -1.670000e+04,  4.000000e+02, -3.090000e+04, -1.900000e+04,
        -3.910000e+04, -4.780000e+04, -6.320000e+04,  4.176000e+05,
         3.739000e+05,  3.900000e+03, -1.780000e+04,  1.320000e+04,
         2.070000e+04,  3.100000e+03,  3.900000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.670000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 2.191000e+05, -3.200000e+05, -1.955000e+05, -6.348000e+05,
        -2.081000e+05,  1.084300e+06,  6.462000e+05,  1.899000e+05,
        -3.199000e+05,  1.840000e+05, -3.195000e+05, -6.330000e+04,
        -3.101000e+05,  4.103500e+06,  0.000000e+00, -6.330000e+04,
        -4.878000e+05, -6.600000e+04, -3.630000e+04, -2.488000e+05,
         0.000000e+00,  3.932800e+06,  3.066900e+06,  3.302400e+06,
         2.551000e+06, -1.450000e+06, -9.742000e+05, -1.740000e+05,
        -1.478700e+06,  6.182200e+06,  2.027300e+06,  5.625800e+06,
         1.372750e+07,  3.753900e+06,  3.758800e+06,  3.751000e+06,
         3.758900e+06,  4.956900e+06,  3.759000e+06,  3.622360e+07,
         3.434140e+07,  3.538320e+07,  4.045900e+06,  3.751700e+06,
         3.835800e+06, -8.450000e+05, -1.418600e+06,  4.750800e+06,
         4.750800e+06,  2.732300e+06,  7.257000e+05,  2.801600e+06,
         3.229200e+06,  7.755400e+06,  7.463700e+06, -2.628900e+06,
         3.415500e+06, -6.978000e+05, -1.126900e+06, -1.419200e+06,
         7.027700e+06,  7.027900e+06,  6.469800e+06,  6.607500e+06,
         1.065800e+06, -3.205000e+05,  2.154000e+05,  1.269700e+06,
        -5.199000e+05, -8.313000e+05, -2.610000e+05,  8.700000e+04,
        -3.470000e+05, -1.117000e+05, -1.117000e+05, -1.117000e+05,
        -1.118000e+05, -6.674000e+05, -6.674000e+05,  4.038600e+06,
        -5.503000e+05, -8.232000e+05, -4.000000e+02,  0.000000e+00,
        -2.025700e+06, -2.051800e+06,  3.584100e+06,  1.246500e+06,
        -2.411000e+05, -2.411000e+05, -4.914000e+05, -4.913000e+05,
        -4.914000e+05, -1.612000e+06, -2.994800e+06,  6.672300e+06,
         3.488100e+06, -5.097000e+05, -1.334300e+06,  5.114000e+05,
        -5.426400e+06, -7.344000e+05, -2.679200e+06, -7.344000e+05,
        -2.683200e+06,  7.549500e+06,  1.681560e+07,  2.096450e+07,
         1.570330e+07,  3.704400e+06,  3.412400e+06, -3.941900e+06,
         3.943200e+06, -2.188000e+05, -5.089000e+05,  3.761900e+06,
         7.332200e+06,  7.130000e+05, -1.211000e+05,  8.270000e+04,
         4.874600e+06,  4.847000e+05, -4.983000e+05,  4.494300e+06,
         8.644800e+06,  3.438000e+05,  3.035800e+06,  3.443700e+06,
         7.756200e+06,  7.172800e+06,  2.677900e+06, -5.097000e+05,
        -1.392200e+06,  3.650700e+06,  2.712100e+06,  5.399000e+05,
        -1.348400e+06, -5.703000e+05,  3.354000e+06,  2.712400e+06,
         6.939000e+05,  1.773000e+05,  1.771000e+05, -6.532000e+05,
         7.812000e+05,  2.239700e+06,  1.930900e+06, -3.401000e+05,
        -3.404000e+05, -1.581000e+05, -1.582000e+05,  3.220500e+06,
        -1.580000e+05, -3.728000e+06, -1.582000e+05, -3.475000e+05,
        -3.475000e+05, -3.475000e+05, -3.472000e+05, -3.166000e+05,
         3.006000e+05,  3.004000e+05,  3.004000e+05,  4.306000e+06,
         1.401000e+05,  0.000000e+00,  1.834000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.803400e+06,  5.178000e+05,  1.796000e+05,
         9.516400e+06,  2.528600e+06,  2.532000e+06,  1.489900e+06,
         1.490100e+06,  7.100000e+03, -1.290000e+05,  5.000000e+02,
         2.023000e+05, -2.030000e+04,  8.700000e+03,  1.510000e+04,
         4.103500e+06, -6.260000e+04,  2.840000e+04, -4.700000e+03,
         0.000000e+00,  2.000000e+02,  6.700000e+04,  2.588000e+05,
         4.200000e+03,  7.850000e+04,  7.870000e+04,  7.870000e+04,
         0.000000e+00,  0.000000e+00,  4.369800e+06,  4.103800e+06,
         3.330000e+04,  9.780000e+04,  4.609000e+05,  3.800000e+03,
         2.670000e+05,  2.079000e+05,  2.037100e+06,  1.430000e+04,
        -1.457000e+05, -1.457000e+05,  2.633000e+05,  3.900000e+03,
         2.490000e+04,  1.136000e+05, -1.424000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.000000e+02, -3.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.023000e+05,
        -1.290000e+05,  5.383000e+05, -4.700000e+03,  2.840000e+04,
        -3.475000e+05,  2.000000e+02,  2.191000e+05, -3.200000e+05,
        -4.913000e+05, -1.117000e+05, -5.503000e+05,  3.758700e+06,
         3.220500e+06, -1.582000e+05, -3.404000e+05,  3.005000e+05,
         1.796000e+05,  5.000000e+02,  7.870000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -3.475000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-3.173000e+05,  3.843000e+05, -1.985000e+05, -5.694000e+05,
        -4.422000e+05, -1.284700e+06, -6.500000e+05, -3.159000e+05,
         3.844000e+05, -3.156000e+05,  3.849000e+05, -2.977000e+05,
         5.230000e+04,  4.054400e+06,  0.000000e+00, -2.977000e+05,
        -4.274000e+05, -2.973000e+05,  6.100000e+03, -1.191600e+06,
         0.000000e+00,  3.153800e+06,  4.344100e+06,  3.332800e+06,
         2.703500e+06, -6.909000e+05,  7.560000e+05, -8.994000e+05,
        -1.291500e+06,  6.105300e+06,  1.755400e+06,  6.832600e+06,
         1.404780e+07,  3.773700e+06,  3.782900e+06,  3.776900e+06,
         3.774000e+06,  4.927900e+06,  3.783300e+06,  3.434140e+07,
         3.662930e+07,  3.458020e+07,  3.759900e+06,  4.191200e+06,
         3.819600e+06, -1.013500e+06, -1.281200e+06,  4.902200e+06,
         4.902600e+06,  3.172600e+06,  1.463700e+06,  2.913500e+06,
         3.328000e+06,  7.756500e+06,  8.172300e+06, -4.777000e+05,
         3.426800e+06, -8.703000e+05, -1.000800e+06, -1.280500e+06,
         6.654600e+06,  6.655000e+06,  7.442200e+06,  6.774000e+06,
        -6.810000e+05, -5.816000e+05, -3.784000e+05, -1.004400e+06,
        -4.857000e+05, -7.112000e+05, -2.164000e+05,  2.400000e+04,
        -3.254000e+05, -5.977000e+05, -5.977000e+05, -5.976000e+05,
        -5.977000e+05,  1.015000e+05,  1.015000e+05,  3.749600e+06,
        -7.281000e+05, -3.779000e+05, -1.800000e+03,  0.000000e+00,
        -1.734700e+06, -2.027400e+06,  3.602400e+06,  1.385200e+06,
        -2.130000e+05, -2.130000e+05, -4.308000e+05, -4.307000e+05,
        -4.308000e+05, -2.633900e+06, -8.861000e+05,  6.054900e+06,
         2.524100e+06, -1.179500e+06, -1.216000e+05, -3.499000e+05,
        -3.537000e+06, -2.372100e+06,  7.500000e+04, -2.372100e+06,
         7.270000e+04,  6.318000e+06,  1.555630e+07,  1.990390e+07,
         1.699290e+07,  3.485100e+06,  3.902500e+06,  2.424900e+06,
         4.065900e+06, -3.002000e+05,  9.350000e+04,  3.779600e+06,
         7.388600e+06, -4.080000e+04,  1.028100e+06,  1.383000e+05,
         4.324000e+06, -3.336000e+05, -1.176500e+06,  3.113700e+06,
         7.461700e+06, -1.234300e+06,  5.192700e+06,  3.412100e+06,
         7.253000e+06,  8.084600e+06,  2.889100e+06, -1.176400e+06,
         1.173000e+05,  3.187300e+06,  2.931200e+06, -3.234000e+05,
        -1.303000e+05, -1.216200e+06,  3.435700e+06,  2.872800e+06,
         1.142800e+06, -6.067000e+05, -6.067000e+05,  4.358000e+05,
         2.988800e+06,  9.097000e+05, -1.040790e+07, -2.783000e+05,
        -2.785000e+05,  9.100000e+03,  9.100000e+03,  3.325100e+06,
         9.400000e+03, -3.482000e+06,  9.100000e+03, -2.829000e+05,
        -2.829000e+05, -2.829000e+05, -2.828000e+05, -2.790000e+05,
         2.570000e+05,  2.568000e+05,  2.569000e+05,  4.039000e+06,
        -3.134000e+05,  0.000000e+00,  1.608000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.541800e+06,  5.718000e+05,  2.904000e+05,
         9.835900e+06,  2.760700e+06,  2.762200e+06,  1.914200e+06,
         1.914600e+06,  4.500000e+03, -1.326000e+05, -4.250000e+04,
        -1.530000e+04,  3.331000e+05,  2.432000e+05,  1.930000e+04,
         4.054400e+06, -2.979000e+05,  5.758000e+05,  4.000000e+02,
         0.000000e+00, -3.300000e+03, -6.300000e+03, -5.700000e+04,
         3.293000e+05,  6.510000e+04,  6.510000e+04,  6.510000e+04,
         0.000000e+00,  0.000000e+00,  4.026500e+06,  4.434200e+06,
         9.304000e+05,  1.872000e+05, -7.230000e+04,  3.045000e+05,
        -2.470000e+04, -1.540000e+04,  2.013700e+06,  2.875000e+05,
        -1.394000e+05, -1.394000e+05, -1.420000e+04,  3.477000e+05,
         1.840000e+04, -1.535000e+05,  2.083000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  3.000000e+02,  9.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.530000e+04,
        -1.326000e+05,  5.319000e+05,  4.000000e+02,  5.758000e+05,
        -2.829000e+05,  3.000000e+02, -3.173000e+05,  3.843000e+05,
        -4.307000e+05, -5.977000e+05, -7.281000e+05,  3.773800e+06,
         3.325100e+06,  9.100000e+03, -2.785000e+05,  2.569000e+05,
         2.904000e+05, -4.250000e+04,  6.510000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -2.829000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-2.818000e+05, -2.802000e+05,  1.715300e+06, -5.543000e+05,
        -4.175000e+05, -1.150500e+06, -5.868000e+05, -2.933000e+05,
        -2.802000e+05, -2.957000e+05, -2.798000e+05, -2.890000e+05,
        -2.791000e+05,  4.092300e+06,  0.000000e+00, -2.890000e+05,
        -4.265000e+05, -2.905000e+05, -3.240000e+04, -1.150800e+06,
         0.000000e+00,  3.245400e+06,  3.187700e+06,  1.472530e+07,
         2.724800e+06, -1.269000e+06, -8.505000e+05, -8.450000e+05,
        -1.287600e+06,  6.090600e+06,  1.719200e+06,  6.071900e+06,
         1.424430e+07,  3.789000e+06,  3.794100e+06,  3.786800e+06,
         3.794000e+06,  4.966000e+06,  3.794400e+06,  3.538320e+07,
         3.458020e+07,  6.783380e+07,  3.808700e+06,  3.784300e+06,
         1.016870e+07, -9.736000e+05, -1.245900e+06,  4.904300e+06,
         4.904400e+06,  2.888700e+06,  8.855000e+05,  6.725100e+06,
         3.326600e+06,  7.795400e+06,  7.773400e+06, -2.304800e+06,
         3.481600e+06, -8.446000e+05, -9.843000e+05, -1.253700e+06,
         6.696400e+06,  6.696700e+06,  6.675200e+06,  1.941640e+07,
        -6.318000e+05, -5.407000e+05, -3.545000e+05, -1.012900e+06,
        -5.211000e+05, -7.258000e+05, -2.284000e+05,  9.200000e+03,
        -3.647000e+05, -5.638000e+05, -5.638000e+05, -5.637000e+05,
        -5.638000e+05, -5.813000e+05, -5.813000e+05,  3.803900e+06,
        -7.162000e+05, -7.192000e+05,  4.800000e+03,  0.000000e+00,
        -2.017800e+06, -2.038800e+06,  3.634600e+06,  1.342000e+06,
         6.431000e+05,  6.432000e+05, -4.293000e+05, -4.292000e+05,
        -4.292000e+05, -2.574100e+06, -2.611200e+06,  6.145600e+06,
         2.605800e+06, -1.129100e+06, -1.148600e+06, -2.415000e+05,
        -5.232300e+06, -2.268300e+06, -2.329800e+06, -2.268400e+06,
        -2.335400e+06,  6.448700e+06,  1.578210e+07,  2.014800e+07,
         1.574550e+07,  3.514400e+06,  3.492100e+06, -3.438400e+06,
         4.080400e+06, -2.961000e+05, -3.168000e+05,  3.802300e+06,
         7.418300e+06,  4.580000e+04,  1.750000e+04,  1.912590e+07,
         4.421800e+06, -2.886000e+05, -1.127200e+06,  3.260300e+06,
         7.628100e+06, -1.107500e+06,  3.149900e+06,  3.506050e+07,
         7.330000e+06,  7.285800e+06,  2.850200e+06, -1.139300e+06,
        -1.212500e+06,  3.235400e+06,  2.886800e+06, -2.237000e+05,
        -1.172800e+06, -1.172200e+06,  3.433300e+06,  2.871200e+06,
         8.556000e+05, -5.498000e+05, -5.500000e+05, -5.702000e+05,
         1.134700e+06,  1.245100e+06, -9.600600e+06, -2.888000e+05,
        -2.890000e+05, -1.020000e+04, -1.020000e+04,  3.317700e+06,
        -9.800000e+03, -3.513500e+06, -1.020000e+04, -3.012000e+05,
        -3.012000e+05, -3.012000e+05, -3.009000e+05, -2.857000e+05,
         2.604000e+05,  2.602000e+05,  2.603000e+05,  4.067000e+06,
        -3.134000e+05,  0.000000e+00,  1.685000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.562200e+06,  5.704000e+05,  2.799000e+05,
         9.819600e+06,  2.718800e+06,  2.722400e+06,  1.819600e+06,
         1.819900e+06,  1.230000e+04, -1.159000e+05, -6.360000e+04,
        -2.550000e+04, -5.100000e+03,  6.700000e+03,  4.271000e+05,
         4.092300e+06, -2.883000e+05,  2.320000e+04,  0.000000e+00,
         0.000000e+00,  2.000000e+02,  3.064400e+06, -6.050000e+04,
        -6.320000e+04,  6.870000e+04,  6.880000e+04,  6.880000e+04,
         0.000000e+00,  0.000000e+00,  4.088400e+06,  4.090600e+06,
         2.570000e+04,  8.000000e+03, -8.600000e+04, -5.850000e+04,
         1.300000e+03, -2.320000e+04,  2.030700e+06,  1.170000e+04,
        -1.343000e+05, -1.343000e+05, -4.600000e+03, -4.800000e+03,
         4.482000e+05, -1.409000e+05, -1.394000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  3.000000e+02, -7.400000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.550000e+04,
        -1.159000e+05,  5.368000e+05,  0.000000e+00,  2.320000e+04,
        -3.012000e+05,  3.000000e+02, -2.818000e+05, -2.802000e+05,
        -4.292000e+05, -5.638000e+05, -7.162000e+05,  3.793700e+06,
         3.317700e+06, -1.020000e+04, -2.890000e+05,  2.603000e+05,
         2.799000e+05, -6.360000e+04,  6.880000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -3.012000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.013000e+05, -3.690000e+04, -1.670000e+04, -8.100000e+04,
         1.000000e+04,  4.584000e+05,  2.558000e+05,  9.400000e+04,
        -3.690000e+04,  9.260000e+04, -3.680000e+04,  3.030000e+04,
        -3.320000e+04,  4.505000e+05,  0.000000e+00,  3.030000e+04,
        -6.000000e+04,  2.970000e+04, -3.900000e+03,  1.211000e+05,
         0.000000e+00,  5.441000e+05,  3.314000e+05,  3.661000e+05,
         2.610000e+05, -1.788000e+05, -1.124000e+05,  9.160000e+04,
        -1.830000e+05,  7.227000e+05,  3.025000e+05,  5.827000e+05,
         1.468500e+06,  4.100000e+05,  4.108000e+05,  4.100000e+05,
         4.105000e+05,  5.430000e+05,  4.111000e+05,  4.045900e+06,
         3.759900e+06,  3.808700e+06,  5.118000e+05,  4.127000e+05,
         4.525000e+05, -7.130000e+04, -1.832000e+05,  5.072000e+05,
         5.072000e+05,  2.855000e+05,  6.500000e+04,  2.962000e+05,
         3.469000e+05,  8.668000e+05,  7.803000e+05, -3.283000e+05,
         3.643000e+05, -5.050000e+04, -1.417000e+05, -1.834000e+05,
         8.428000e+05,  8.432000e+05,  7.008000e+05,  7.242000e+05,
         3.632000e+05,  9.200000e+03,  1.095000e+05,  4.577000e+05,
        -6.650000e+04, -9.950000e+04, -2.980000e+04,  7.600000e+03,
        -4.340000e+04,  6.190000e+04,  6.190000e+04,  6.190000e+04,
         6.190000e+04, -7.720000e+04, -7.720000e+04,  4.819000e+05,
        -2.960000e+04, -9.890000e+04, -1.400000e+03,  0.000000e+00,
        -2.237000e+05, -2.272000e+05,  3.871000e+05,  1.309000e+05,
        -2.540000e+04, -2.540000e+04, -6.060000e+04, -6.060000e+04,
        -6.060000e+04, -6.700000e+03, -3.536000e+05,  8.300000e+05,
         5.245000e+05,  4.950000e+04, -1.570000e+05,  1.669000e+05,
        -6.062000e+05,  1.760000e+05, -3.109000e+05,  1.760000e+05,
        -3.103000e+05,  1.016600e+06,  2.005300e+06,  2.425100e+06,
         1.725900e+06,  4.426000e+05,  3.548000e+05, -4.538000e+05,
         4.118000e+05, -8.200000e+03, -7.920000e+04,  4.099000e+05,
         7.972000e+05,  1.753000e+05, -3.370000e+04, -2.600000e+03,
         5.953000e+05,  1.706000e+05,  5.370000e+04,  7.063000e+05,
         1.120800e+06,  2.917000e+05,  2.738000e+05,  4.097000e+05,
         9.256000e+05,  7.526000e+05,  2.855000e+05,  5.230000e+04,
        -2.452000e+05,  4.726000e+05,  2.896000e+05,  1.728000e+05,
        -1.559000e+05,  4.050000e+04,  3.645000e+05,  2.833000e+05,
         6.160000e+04,  1.353000e+05,  1.353000e+05, -7.480000e+04,
         6.430000e+04,  4.968000e+05,  2.044700e+06, -4.090000e+04,
        -4.090000e+04, -3.890000e+04, -3.890000e+04,  3.453000e+05,
        -3.850000e+04, -4.482000e+05, -3.890000e+04, -4.040000e+04,
        -4.040000e+04, -4.040000e+04, -4.030000e+04, -3.330000e+04,
         3.420000e+04,  3.420000e+04,  3.420000e+04,  5.019000e+05,
         8.180000e+04,  0.000000e+00,  1.850000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.054000e+05,  4.080000e+04,  9.000000e+02,
         1.015300e+06,  2.656000e+05,  2.666000e+05,  1.461000e+05,
         1.465000e+05, -2.000000e+02, -1.760000e+04, -3.000000e+03,
         5.140000e+04, -6.300000e+03,  1.100000e+03,  8.000000e+02,
         4.505000e+05,  3.040000e+04,  3.400000e+03, -1.200000e+03,
         0.000000e+00,  0.000000e+00,  7.500000e+03,  6.170000e+04,
        -2.300000e+03,  9.000000e+03,  9.000000e+03,  9.000000e+03,
         0.000000e+00,  0.000000e+00,  5.208000e+05,  4.511000e+05,
         4.200000e+03,  2.370000e+04,  1.131000e+05, -2.200000e+03,
         6.930000e+04,  5.320000e+04,  2.238000e+05,  1.900000e+03,
        -2.080000e+04, -2.080000e+04,  6.580000e+04,  4.000000e+02,
         3.200000e+03,  4.430000e+04, -2.050000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  3.000000e+02, -2.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  5.140000e+04,
        -1.760000e+04,  5.910000e+04, -1.200000e+03,  3.400000e+03,
        -4.040000e+04,  3.000000e+02,  1.013000e+05, -3.690000e+04,
        -6.060000e+04,  6.190000e+04, -2.960000e+04,  4.104000e+05,
         3.453000e+05, -3.890000e+04, -4.090000e+04,  3.420000e+04,
         9.000000e+02, -3.000000e+03,  9.000000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -4.040000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-3.330000e+04,  1.386000e+05, -1.780000e+04, -6.450000e+04,
        -4.880000e+04, -1.361000e+05, -6.950000e+04, -3.290000e+04,
         1.386000e+05, -3.280000e+04,  1.387000e+05, -2.910000e+04,
         5.660000e+04,  4.393000e+05,  0.000000e+00, -2.910000e+04,
        -4.490000e+04, -2.900000e+04,  6.500000e+03, -1.163000e+05,
         0.000000e+00,  3.515000e+05,  6.477000e+05,  3.759000e+05,
         2.984000e+05,  1.120000e+04,  3.182000e+05, -8.760000e+04,
        -1.363000e+05,  6.975000e+05,  2.294000e+05,  8.764000e+05,
         1.546700e+06,  4.143000e+05,  4.146000e+05,  4.147000e+05,
         4.145000e+05,  5.367000e+05,  4.150000e+05,  3.751700e+06,
         4.191200e+06,  3.784300e+06,  4.127000e+05,  5.728000e+05,
         4.209000e+05, -1.136000e+05, -1.485000e+05,  5.433000e+05,
         5.434000e+05,  3.940000e+05,  2.484000e+05,  3.244000e+05,
         3.697000e+05,  8.614000e+05,  9.940000e+05,  2.472000e+05,
         3.683000e+05, -9.390000e+04, -1.101000e+05, -1.483000e+05,
         7.447000e+05,  7.450000e+05,  9.384000e+05,  7.610000e+05,
        -7.540000e+04, -5.460000e+04, -3.890000e+04, -1.093000e+05,
        -5.790000e+04, -7.010000e+04, -1.920000e+04, -8.000000e+03,
        -3.880000e+04, -5.830000e+04, -5.830000e+04, -5.820000e+04,
        -5.830000e+04,  1.137000e+05,  1.137000e+05,  4.097000e+05,
        -7.420000e+04,  1.170000e+04, -9.000000e+02,  0.000000e+00,
        -1.501000e+05, -2.204000e+05,  3.922000e+05,  1.625000e+05,
        -1.890000e+04, -1.890000e+04, -4.550000e+04, -4.550000e+04,
        -4.550000e+04, -2.603000e+05,  1.693000e+05,  6.759000e+05,
         2.804000e+05, -1.136000e+05,  1.447000e+05, -4.040000e+04,
        -1.345000e+05, -2.284000e+05,  3.733000e+05, -2.284000e+05,
         3.732000e+05,  7.074000e+05,  1.688300e+06,  2.156300e+06,
         2.041600e+06,  3.863000e+05,  5.218000e+05,  1.130500e+06,
         4.420000e+05, -2.680000e+04,  7.180000e+04,  4.141000e+05,
         8.090000e+05, -1.010000e+04,  2.532000e+05,  1.440000e+04,
         4.587000e+05, -3.770000e+04, -1.120000e+05,  3.458000e+05,
         8.134000e+05, -1.218000e+05,  1.008900e+06,  3.866000e+05,
         7.975000e+05,  1.062800e+06,  3.401000e+05, -1.118000e+05,
         3.684000e+05,  3.568000e+05,  3.401000e+05, -3.750000e+04,
         1.459000e+05, -1.243000e+05,  3.883000e+05,  3.220000e+05,
         1.726000e+05, -6.090000e+04, -6.090000e+04,  1.962000e+05,
         6.106000e+05, -5.240000e+04, -1.036700e+06, -2.550000e+04,
        -2.560000e+04,  2.200000e+03,  2.200000e+03,  3.698000e+05,
         2.600000e+03, -3.851000e+05,  2.200000e+03, -2.500000e+04,
        -2.500000e+04, -2.500000e+04, -2.500000e+04, -2.520000e+04,
         2.250000e+04,  2.250000e+04,  2.250000e+04,  4.361000e+05,
        -3.230000e+04,  0.000000e+00,  1.410000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.350000e+05,  5.220000e+04,  2.720000e+04,
         1.090300e+06,  3.203000e+05,  3.208000e+05,  2.466000e+05,
         2.469000e+05, -2.000000e+02, -1.820000e+04, -1.380000e+04,
        -3.200000e+03,  8.220000e+04,  5.980000e+04,  1.800000e+03,
         4.393000e+05, -2.910000e+04,  1.404000e+05,  1.000000e+02,
         0.000000e+00, -8.000000e+02, -9.400000e+03, -1.730000e+04,
         7.900000e+04,  5.800000e+03,  5.800000e+03,  5.800000e+03,
         0.000000e+00,  0.000000e+00,  4.343000e+05,  5.339000e+05,
         2.288000e+05,  4.610000e+04, -2.050000e+04,  7.310000e+04,
        -4.700000e+03, -2.900000e+03,  2.206000e+05,  7.030000e+04,
        -1.900000e+04, -1.900000e+04, -3.500000e+03,  8.650000e+04,
         1.700000e+03, -2.250000e+04,  6.750000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  4.000000e+02,  1.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -3.200000e+03,
        -1.820000e+04,  5.760000e+04,  1.000000e+02,  1.404000e+05,
        -2.500000e+04,  4.000000e+02, -3.330000e+04,  1.386000e+05,
        -4.550000e+04, -5.830000e+04, -7.420000e+04,  4.145000e+05,
         3.698000e+05,  2.200000e+03, -2.560000e+04,  2.250000e+04,
         2.720000e+04, -1.380000e+04,  5.800000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -2.500000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-2.390000e+04, -2.690000e+04,  4.611000e+05, -6.090000e+04,
        -4.240000e+04, -1.003000e+05, -5.240000e+04, -2.680000e+04,
        -2.690000e+04, -2.730000e+04, -2.690000e+04, -2.620000e+04,
        -2.550000e+04,  4.477000e+05,  0.000000e+00, -2.620000e+04,
        -4.470000e+04, -2.640000e+04, -3.000000e+03, -1.044000e+05,
         0.000000e+00,  3.722000e+05,  3.616000e+05,  3.221900e+06,
         3.044000e+05, -1.335000e+05, -8.150000e+04, -7.610000e+04,
        -1.353000e+05,  6.998000e+05,  2.255000e+05,  6.942000e+05,
         1.597700e+06,  4.188000e+05,  4.196000e+05,  4.190000e+05,
         4.192000e+05,  5.453000e+05,  4.200000e+05,  3.835800e+06,
         3.819600e+06,  1.016870e+07,  4.525000e+05,  4.209000e+05,
         2.584300e+06, -1.035000e+05, -1.400000e+05,  5.456000e+05,
         5.456000e+05,  3.246000e+05,  1.049000e+05,  1.277100e+06,
         3.712000e+05,  8.768000e+05,  8.577000e+05, -2.473000e+05,
         3.808000e+05, -8.720000e+04, -1.060000e+05, -1.420000e+05,
         7.600000e+05,  7.604000e+05,  7.521000e+05,  3.926500e+06,
        -6.120000e+04, -4.580000e+04, -3.300000e+04, -1.130000e+05,
        -6.680000e+04, -7.310000e+04, -2.160000e+04, -1.190000e+04,
        -4.780000e+04, -5.110000e+04, -5.110000e+04, -5.110000e+04,
        -5.110000e+04, -5.570000e+04, -5.570000e+04,  4.233000e+05,
        -7.100000e+04, -7.290000e+04, -1.000000e+02,  0.000000e+00,
        -2.217000e+05, -2.239000e+05,  3.997000e+05,  1.548000e+05,
         1.956000e+05,  1.957000e+05, -4.510000e+04, -4.510000e+04,
        -4.510000e+04, -2.472000e+05, -2.577000e+05,  6.984000e+05,
         3.040000e+05, -1.053000e+05, -1.106000e+05, -2.140000e+04,
        -5.576000e+05, -2.075000e+05, -2.235000e+05, -2.075000e+05,
        -2.234000e+05,  7.414000e+05,  1.747000e+06,  2.221000e+06,
         1.736400e+06,  3.951000e+05,  3.747000e+05, -3.280000e+05,
         4.461000e+05, -2.760000e+04, -3.120000e+04,  4.200000e+05,
         8.188000e+05,  8.500000e+03,  1.000000e+03,  4.758200e+06,
         4.821000e+05, -2.280000e+04, -1.035000e+05,  3.978000e+05,
         8.666000e+05, -7.110000e+04,  3.023000e+05,  8.313900e+06,
         8.190000e+05,  7.808000e+05,  3.285000e+05, -1.052000e+05,
        -2.002000e+05,  3.688000e+05,  3.333000e+05, -1.810000e+04,
        -1.120000e+05, -1.100000e+05,  3.843000e+05,  3.230000e+05,
         1.020000e+05, -4.650000e+04, -4.650000e+04, -5.400000e+04,
         1.526000e+05,  2.481000e+05, -8.382000e+05, -2.810000e+04,
        -2.810000e+04, -1.900000e+03, -1.900000e+03,  3.697000e+05,
        -1.500000e+03, -3.946000e+05, -1.900000e+03, -2.880000e+04,
        -2.880000e+04, -2.880000e+04, -2.880000e+04, -2.560000e+04,
         2.420000e+04,  2.420000e+04,  2.420000e+04,  4.421000e+05,
        -3.160000e+04,  0.000000e+00,  1.480000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.451000e+05,  5.400000e+04,  2.600000e+04,
         1.091100e+06,  3.131000e+05,  3.142000e+05,  2.286000e+05,
         2.289000e+05,  1.000000e+03, -1.430000e+04, -1.900000e+04,
        -5.600000e+03, -2.500000e+03,  6.000000e+02,  1.038000e+05,
         4.477000e+05, -2.610000e+04,  2.100000e+03, -1.000000e+02,
         0.000000e+00,  0.000000e+00,  7.569000e+05, -1.810000e+04,
        -1.920000e+04,  6.500000e+03,  6.500000e+03,  6.500000e+03,
         0.000000e+00,  0.000000e+00,  4.505000e+05,  4.478000e+05,
         2.300000e+03,  1.200000e+03, -2.370000e+04, -1.770000e+04,
         2.800000e+03, -4.600000e+03,  2.222000e+05,  1.200000e+03,
        -1.790000e+04, -1.790000e+04, -1.100000e+03, -1.800000e+03,
         1.091000e+05, -1.930000e+04, -1.970000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  4.000000e+02, -2.000000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -5.600000e+03,
        -1.430000e+04,  5.870000e+04, -1.000000e+02,  2.100000e+03,
        -2.880000e+04,  4.000000e+02, -2.390000e+04, -2.690000e+04,
        -4.510000e+04, -5.110000e+04, -7.100000e+04,  4.192000e+05,
         3.697000e+05, -1.900000e+03, -2.810000e+04,  2.420000e+04,
         2.600000e+04, -1.900000e+04,  6.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -2.880000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 8.930000e+04,  7.500000e+03,  2.330000e+04,  1.067700e+06,
         5.944000e+05,  3.846000e+05,  2.060000e+05,  8.580000e+04,
         7.500000e+03,  8.520000e+04,  7.400000e+03,  5.380000e+04,
         1.550000e+04, -1.253000e+05,  0.000000e+00,  5.380000e+04,
         5.242000e+05,  5.360000e+04,  1.700000e+03,  2.141000e+05,
         0.000000e+00,  3.490000e+04, -9.050000e+04, -6.160000e+04,
         1.432100e+06,  1.575500e+06,  2.270000e+04,  1.592000e+05,
         1.596700e+06, -6.260000e+04,  1.166000e+05, -1.432000e+05,
         9.217900e+06, -1.055000e+05, -1.057000e+05, -1.056000e+05,
        -1.056000e+05, -1.468000e+05, -1.057000e+05, -8.450000e+05,
        -1.013500e+06, -9.736000e+05, -7.130000e+04, -1.136000e+05,
        -1.035000e+05,  1.690300e+06,  2.675300e+06,  8.595000e+05,
         8.595000e+05,  9.234000e+05,  9.925000e+05,  9.342000e+05,
         4.080000e+05,  1.824700e+06,  1.782700e+06,  2.102000e+06,
         8.925000e+05,  1.128800e+06,  1.601600e+06,  2.627500e+06,
        -8.440000e+04, -8.440000e+04, -1.670000e+05, -1.487000e+05,
         2.612000e+05,  7.970000e+04,  1.012000e+05,  3.491000e+05,
         4.840000e+05,  5.219000e+05,  1.590000e+04, -3.110000e+04,
        -7.100000e+03,  1.071000e+05,  1.071000e+05,  1.071000e+05,
         1.071000e+05,  2.740000e+04,  2.740000e+04, -7.230000e+04,
         5.676000e+05,  5.281000e+05, -1.360000e+04,  0.000000e+00,
         4.430000e+04,  4.860000e+04,  3.935000e+05,  2.139000e+05,
         1.890000e+04,  1.890000e+04,  5.326000e+05,  5.324000e+05,
         5.325000e+05,  1.315000e+06,  1.117300e+06,  9.545000e+05,
         1.065100e+06,  1.523000e+05,  3.330000e+04,  7.960000e+04,
         1.435000e+05,  3.940000e+05,  1.151000e+05,  3.940000e+05,
         1.159000e+05,  3.610000e+04, -3.261000e+05, -5.053000e+05,
        -4.868000e+05, -5.240000e+04, -9.450000e+04,  1.136000e+05,
        -1.439000e+05,  3.510000e+04, -6.600000e+03, -1.194000e+05,
         2.820000e+05,  8.200000e+04, -3.780000e+04, -1.450000e+04,
        -9.710000e+04,  1.133000e+05,  1.784000e+05,  1.051000e+05,
        -7.450000e+04,  2.847000e+05, -1.053000e+05, -5.570000e+04,
        -1.247000e+05, -2.089000e+05, -4.490000e+04,  1.796000e+05,
         5.270000e+04,  8.000000e+02, -4.580000e+04,  1.059000e+05,
         6.110000e+04,  1.807000e+05, -8.430000e+04,  9.286000e+05,
         9.924000e+05,  1.430000e+05,  1.430000e+05,  2.110000e+04,
        -9.900000e+03,  2.005000e+05,  2.323400e+06,  6.100000e+03,
         6.100000e+03, -1.820000e+04, -1.820000e+04,  4.050000e+05,
        -1.820000e+04,  4.930000e+04, -1.820000e+04,  2.000000e+04,
         2.000000e+04,  2.000000e+04,  1.990000e+04,  2.210000e+04,
        -3.230000e+04, -3.230000e+04, -3.230000e+04, -9.870000e+04,
         8.040000e+04,  0.000000e+00, -2.070000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.936000e+05, -5.570000e+04, -3.690000e+04,
         1.721200e+06,  4.458000e+05,  4.469000e+05,  5.067000e+05,
         5.067000e+05, -1.390000e+04,  4.811000e+05, -2.700000e+04,
         2.670000e+04, -9.300000e+03, -6.200000e+03, -4.000000e+02,
        -1.253000e+05,  5.370000e+04, -1.540000e+04, -6.000000e+02,
         0.000000e+00, -9.000000e+02, -2.060000e+04,  4.200000e+03,
        -3.500000e+04, -4.800000e+03, -4.800000e+03, -4.800000e+03,
         0.000000e+00,  0.000000e+00, -9.100000e+04, -1.337000e+05,
        -2.370000e+04,  5.600000e+03,  3.090000e+04, -3.240000e+04,
         3.350000e+04,  2.740000e+04, -6.240000e+04, -7.700000e+03,
         5.060000e+05,  5.058000e+05,  2.670000e+04, -1.320000e+04,
        -2.900000e+03,  5.250000e+05,  4.916000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -5.000000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.670000e+04,
         4.811000e+05, -1.640000e+04, -6.000000e+02, -1.540000e+04,
         2.000000e+04,  0.000000e+00,  8.930000e+04,  7.500000e+03,
         5.324000e+05,  1.071000e+05,  5.676000e+05, -1.056000e+05,
         4.050000e+05, -1.820000e+04,  6.100000e+03, -3.230000e+04,
        -3.690000e+04, -2.700000e+04, -4.800000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.000000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-9.900000e+04, -2.490000e+04, -1.520000e+04,  1.804600e+06,
         8.482000e+05, -4.259000e+05, -2.278000e+05, -9.460000e+04,
        -2.490000e+04, -9.360000e+04, -2.490000e+04, -5.750000e+04,
        -2.400000e+04, -1.257000e+05,  0.000000e+00, -5.750000e+04,
         8.591000e+05, -5.710000e+04, -2.700000e+03, -2.313000e+05,
         0.000000e+00, -2.994000e+05, -1.956000e+05, -1.699000e+05,
         2.422500e+06,  2.584400e+06, -7.910000e+04, -1.735000e+05,
         2.610400e+06, -4.215000e+05, -3.543000e+05, -3.478000e+05,
         1.537480e+07, -1.414000e+05, -1.417000e+05, -1.413000e+05,
        -1.416000e+05, -1.651000e+05, -1.416000e+05, -1.418600e+06,
        -1.281200e+06, -1.245900e+06, -1.832000e+05, -1.485000e+05,
        -1.400000e+05,  2.675300e+06,  4.557300e+06,  1.479000e+06,
         1.479100e+06,  1.547600e+06,  1.624500e+06,  1.558400e+06,
         6.999000e+05,  2.992400e+06,  3.027000e+06,  3.369900e+06,
         1.591200e+06,  1.716700e+06,  2.677000e+06,  4.485200e+06,
        -4.130000e+05, -4.130000e+05, -3.435000e+05, -3.267000e+05,
        -2.878000e+05, -8.620000e+04, -1.108000e+05, -3.785000e+05,
         8.030000e+05,  7.999000e+05, -1.230000e+04, -3.410000e+04,
        -5.290000e+04, -1.161000e+05, -1.161000e+05, -1.161000e+05,
        -1.161000e+05, -4.050000e+04, -4.050000e+04, -1.832000e+05,
         7.846000e+05,  8.235000e+05, -1.350000e+04,  0.000000e+00,
         4.670000e+04,  4.960000e+04,  7.232000e+05,  3.197000e+05,
        -1.360000e+04, -1.360000e+04,  8.701000e+05,  8.699000e+05,
         8.701000e+05,  1.379200e+06,  1.570800e+06,  1.241600e+06,
         1.341600e+06, -2.166000e+05, -1.026000e+05, -1.841000e+05,
         7.900000e+03, -4.218000e+05, -1.571000e+05, -4.218000e+05,
        -1.571000e+05, -5.556000e+05, -6.995000e+05, -7.666000e+05,
        -5.508000e+05, -1.995000e+05, -1.649000e+05, -2.944000e+05,
        -1.030000e+05, -3.480000e+04, -1.000000e+02, -1.547000e+05,
         5.732000e+05, -1.048000e+05,  8.100000e+03,  2.480000e+04,
        -1.730000e+05, -1.517000e+05, -1.911000e+05, -3.815000e+05,
        -4.491000e+05, -3.139000e+05, -2.084000e+05, -1.656000e+05,
        -3.835000e+05, -3.143000e+05, -1.856000e+05, -1.897000e+05,
        -8.580000e+04, -2.578000e+05, -1.881000e+05, -1.563000e+05,
        -7.620000e+04, -1.722000e+05, -1.535000e+05,  1.551300e+06,
         1.619900e+06, -1.573000e+05, -1.573000e+05, -4.500000e+04,
        -2.142000e+05, -3.873000e+05, -2.541900e+06, -2.870000e+04,
        -2.880000e+04,  2.320000e+04,  2.320000e+04,  6.953000e+05,
         2.330000e+04,  2.037000e+05,  2.320000e+04, -1.560000e+04,
        -1.560000e+04, -1.560000e+04, -1.560000e+04, -2.050000e+04,
        -4.000000e+02, -4.000000e+02, -4.000000e+02, -1.545000e+05,
        -8.640000e+04,  0.000000e+00,  4.100000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.200000e+03,  5.600000e+04,  3.960000e+04,
         2.979100e+06,  6.657000e+05,  6.675000e+05,  6.209000e+05,
         6.210000e+05, -1.310000e+04,  8.371000e+05, -3.730000e+04,
        -2.880000e+04,  9.000000e+02, -6.000000e+03,  3.600000e+03,
        -1.257000e+05, -5.760000e+04, -1.510000e+04,  7.000000e+02,
         0.000000e+00, -1.500000e+03, -2.930000e+04, -7.580000e+04,
        -4.470000e+04,  3.700000e+03,  3.700000e+03,  3.700000e+03,
         0.000000e+00,  0.000000e+00, -1.666000e+05, -1.334000e+05,
        -2.290000e+04, -1.940000e+04, -1.045000e+05, -4.140000e+04,
        -4.050000e+04, -2.970000e+04, -6.190000e+04, -7.500000e+03,
         8.928000e+05,  8.925000e+05, -4.260000e+04, -1.060000e+04,
        -6.000000e+02,  8.363000e+05,  8.801000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02, -3.000000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.880000e+04,
         8.371000e+05, -1.650000e+04,  7.000000e+02, -1.510000e+04,
        -1.560000e+04,  1.000000e+02, -9.900000e+04, -2.490000e+04,
         8.699000e+05, -1.161000e+05,  7.846000e+05, -1.416000e+05,
         6.953000e+05,  2.320000e+04, -2.880000e+04, -4.000000e+02,
         3.960000e+04, -3.730000e+04,  3.700000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.560000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-7.090000e+04, -1.290000e+04,  4.800000e+03,  5.966000e+05,
         2.623000e+05, -3.155000e+05, -1.737000e+05, -6.630000e+04,
        -1.290000e+04, -6.540000e+04, -1.260000e+04, -2.810000e+04,
        -2.400000e+03,  5.348000e+05,  0.000000e+00, -2.810000e+04,
         3.088000e+05, -2.790000e+04, -2.000000e+02, -1.111000e+05,
         0.000000e+00,  4.528000e+05,  5.637000e+05,  5.680000e+05,
         1.574100e+06,  9.188000e+05, -1.520000e+04, -8.070000e+04,
         9.399000e+05,  1.100000e+06,  5.362000e+05,  1.160400e+06,
         9.360300e+06,  5.475000e+05,  5.485000e+05,  5.478000e+05,
         5.471000e+05,  6.748000e+05,  5.486000e+05,  4.750800e+06,
         4.902200e+06,  4.904300e+06,  5.072000e+05,  5.433000e+05,
         5.456000e+05,  8.595000e+05,  1.479000e+06,  1.565100e+06,
         1.564600e+06,  1.242100e+06,  9.192000e+05,  1.238800e+06,
         9.240000e+05,  2.773400e+06,  2.809900e+06,  1.197600e+06,
         1.199300e+06,  5.749000e+05,  9.104000e+05,  1.479200e+06,
         1.051900e+06,  1.052000e+06,  1.123300e+06,  1.128700e+06,
        -2.378000e+05, -2.350000e+04, -7.700000e+04, -3.020000e+05,
         3.431000e+05,  3.213000e+05,  1.000000e+04, -1.620000e+04,
        -9.000000e+02, -5.550000e+04, -5.550000e+04, -5.550000e+04,
        -5.550000e+04, -3.000000e+02, -3.000000e+02,  5.088000e+05,
         2.918000e+05,  3.199000e+05, -1.470000e+04,  0.000000e+00,
        -3.102000e+05, -2.819000e+05,  8.811000e+05,  5.165000e+05,
         7.700000e+03,  7.700000e+03,  3.131000e+05,  3.131000e+05,
         3.130000e+05,  5.157000e+05,  6.520000e+05,  1.683800e+06,
         1.061800e+06, -9.920000e+04, -1.930000e+04, -1.489000e+05,
        -5.880000e+05, -1.809000e+05,  1.250000e+04, -1.809000e+05,
         1.180000e+04,  9.432000e+05,  2.006800e+06,  2.570900e+06,
         2.124300e+06,  5.211000e+05,  5.576000e+05, -5.830000e+04,
         5.590000e+05, -4.700000e+03,  3.240000e+04,  5.324000e+05,
         1.460400e+06, -1.015000e+05, -1.180000e+04,  1.370000e+04,
         4.625000e+05, -1.326000e+05, -6.780000e+04,  3.688000e+05,
         9.337000e+05, -1.961000e+05,  5.512000e+05,  5.607000e+05,
         1.029700e+06,  1.102700e+06,  5.779000e+05, -6.960000e+04,
         3.870000e+04,  4.937000e+05,  5.860000e+05, -1.232000e+05,
         1.230000e+04, -9.850000e+04,  5.497000e+05,  1.263300e+06,
         9.409000e+05, -1.002000e+05, -1.002000e+05, -1.280000e+04,
         4.551000e+05,  2.727000e+05, -1.549900e+06, -3.200000e+03,
        -3.200000e+03,  2.250000e+04,  2.250000e+04,  9.317000e+05,
         2.260000e+04, -5.161000e+05,  2.250000e+04,  1.260000e+04,
         1.260000e+04,  1.260000e+04,  1.260000e+04,  9.700000e+03,
        -1.940000e+04, -1.940000e+04, -1.940000e+04,  5.039000e+05,
        -5.890000e+04,  0.000000e+00, -1.420000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.163000e+05, -6.000000e+03,  8.200000e+03,
         3.078200e+06,  9.546000e+05,  9.520000e+05,  9.900000e+05,
         9.901000e+05, -1.560000e+04,  2.701000e+05, -1.350000e+04,
        -3.090000e+04, -8.500000e+03, -8.100000e+03,  1.200000e+03,
         5.348000e+05, -2.800000e+04, -2.490000e+04,  7.000000e+02,
         0.000000e+00,  1.000000e+02, -1.250000e+04, -5.580000e+04,
        -1.690000e+04, -3.000000e+03, -3.000000e+03, -3.000000e+03,
         0.000000e+00,  0.000000e+00,  4.957000e+05,  5.318000e+05,
        -3.100000e+04, -1.940000e+04, -8.670000e+04, -1.560000e+04,
        -3.860000e+04, -3.180000e+04,  2.644000e+05, -1.240000e+04,
         2.843000e+05,  2.843000e+05, -4.580000e+04, -8.800000e+03,
        -2.200000e+03,  2.401000e+05,  2.756000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02, -2.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -3.090000e+04,
         2.701000e+05,  7.020000e+04,  7.000000e+02, -2.490000e+04,
         1.260000e+04,  1.000000e+02, -7.090000e+04, -1.290000e+04,
         3.131000e+05, -5.550000e+04,  2.918000e+05,  5.471000e+05,
         9.317000e+05,  2.250000e+04, -3.200000e+03, -1.940000e+04,
         8.200000e+03, -1.350000e+04, -3.000000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.260000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-7.090000e+04, -1.290000e+04,  4.800000e+03,  5.966000e+05,
         2.623000e+05, -3.155000e+05, -1.737000e+05, -6.630000e+04,
        -1.290000e+04, -6.540000e+04, -1.270000e+04, -2.810000e+04,
        -2.400000e+03,  5.348000e+05,  0.000000e+00, -2.810000e+04,
         3.088000e+05, -2.790000e+04, -2.000000e+02, -1.111000e+05,
         0.000000e+00,  4.528000e+05,  5.639000e+05,  5.680000e+05,
         1.573900e+06,  9.192000e+05, -1.530000e+04, -8.070000e+04,
         9.399000e+05,  1.100100e+06,  5.362000e+05,  1.160500e+06,
         9.359000e+06,  5.475000e+05,  5.485000e+05,  5.478000e+05,
         5.471000e+05,  6.748000e+05,  5.486000e+05,  4.750800e+06,
         4.902600e+06,  4.904400e+06,  5.072000e+05,  5.434000e+05,
         5.456000e+05,  8.595000e+05,  1.479100e+06,  1.564600e+06,
         1.570600e+06,  1.242200e+06,  9.194000e+05,  1.238600e+06,
         9.238000e+05,  2.780300e+06,  2.816800e+06,  1.174800e+06,
         1.198900e+06,  5.749000e+05,  9.104000e+05,  1.479300e+06,
         1.052000e+06,  1.052100e+06,  1.123400e+06,  1.128700e+06,
        -2.378000e+05, -2.350000e+04, -7.700000e+04, -3.020000e+05,
         3.431000e+05,  3.213000e+05,  1.000000e+04, -1.620000e+04,
        -9.000000e+02, -5.550000e+04, -5.550000e+04, -5.550000e+04,
        -5.550000e+04, -3.000000e+02, -3.000000e+02,  5.088000e+05,
         2.918000e+05,  3.198000e+05, -1.470000e+04,  0.000000e+00,
        -3.123000e+05, -2.819000e+05,  8.810000e+05,  5.168000e+05,
         7.700000e+03,  7.700000e+03,  3.131000e+05,  3.131000e+05,
         3.131000e+05,  5.157000e+05,  6.519000e+05,  1.683800e+06,
         1.061900e+06, -9.920000e+04, -1.940000e+04, -1.488000e+05,
        -5.920000e+05, -1.809000e+05,  1.240000e+04, -1.809000e+05,
         1.160000e+04,  9.432000e+05,  2.006800e+06,  2.570900e+06,
         2.124300e+06,  5.212000e+05,  5.577000e+05, -5.860000e+04,
         5.590000e+05, -4.800000e+03,  3.240000e+04,  5.324000e+05,
         1.460200e+06, -1.014000e+05, -1.180000e+04,  1.370000e+04,
         4.626000e+05, -1.326000e+05, -6.780000e+04,  3.688000e+05,
         9.337000e+05, -1.961000e+05,  5.515000e+05,  5.607000e+05,
         1.029700e+06,  1.102800e+06,  5.779000e+05, -6.960000e+04,
         3.890000e+04,  4.937000e+05,  5.860000e+05, -1.233000e+05,
         1.220000e+04, -9.880000e+04,  5.497000e+05,  1.263000e+06,
         9.346000e+05, -1.002000e+05, -1.002000e+05, -1.290000e+04,
         4.552000e+05,  2.725000e+05, -1.549900e+06, -3.200000e+03,
        -3.200000e+03,  2.250000e+04,  2.250000e+04,  9.319000e+05,
         2.260000e+04, -5.161000e+05,  2.250000e+04,  1.260000e+04,
         1.260000e+04,  1.260000e+04,  1.260000e+04,  9.700000e+03,
        -1.930000e+04, -1.930000e+04, -1.930000e+04,  5.039000e+05,
        -5.890000e+04,  0.000000e+00, -1.420000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.161000e+05, -6.000000e+03,  8.200000e+03,
         3.078600e+06,  9.546000e+05,  9.519000e+05,  9.899000e+05,
         9.900000e+05, -1.570000e+04,  2.701000e+05, -1.350000e+04,
        -3.090000e+04, -8.600000e+03, -8.100000e+03,  1.200000e+03,
         5.348000e+05, -2.800000e+04, -2.500000e+04,  7.000000e+02,
         0.000000e+00,  1.000000e+02, -1.250000e+04, -5.580000e+04,
        -1.680000e+04, -3.000000e+03, -3.000000e+03, -3.000000e+03,
         0.000000e+00,  0.000000e+00,  4.957000e+05,  5.318000e+05,
        -3.100000e+04, -1.940000e+04, -8.670000e+04, -1.560000e+04,
        -3.860000e+04, -3.180000e+04,  2.644000e+05, -1.240000e+04,
         2.843000e+05,  2.843000e+05, -4.580000e+04, -8.800000e+03,
        -2.200000e+03,  2.401000e+05,  2.757000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02, -2.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -3.090000e+04,
         2.701000e+05,  7.020000e+04,  7.000000e+02, -2.500000e+04,
         1.260000e+04,  1.000000e+02, -7.090000e+04, -1.290000e+04,
         3.131000e+05, -5.550000e+04,  2.918000e+05,  5.471000e+05,
         9.319000e+05,  2.250000e+04, -3.200000e+03, -1.930000e+04,
         8.200000e+03, -1.350000e+04, -3.000000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.260000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-4.780000e+04,  1.706000e+05,  2.820000e+04,  6.309000e+05,
         2.909000e+05, -2.267000e+05, -1.312000e+05, -4.250000e+04,
         1.706000e+05, -4.150000e+04,  1.702000e+05,  6.000000e+02,
         1.056000e+05,  2.845000e+05,  0.000000e+00,  6.000000e+02,
         3.422000e+05,  9.000000e+02,  1.230000e+04,  3.100000e+03,
         0.000000e+00,  2.873000e+05,  6.153000e+05,  4.046000e+05,
         1.398500e+06,  1.216100e+06,  4.881000e+05,  3.800000e+03,
         1.043900e+06,  8.331000e+05,  5.482000e+05,  1.050700e+06,
         8.427200e+06,  3.319000e+05,  3.326000e+05,  3.324000e+05,
         3.315000e+05,  3.793000e+05,  3.327000e+05,  2.732300e+06,
         3.172600e+06,  2.888700e+06,  2.855000e+05,  3.940000e+05,
         3.246000e+05,  9.234000e+05,  1.547600e+06,  1.242100e+06,
         1.242200e+06,  1.247300e+06,  1.076600e+06,  1.067200e+06,
         7.171000e+05,  2.274100e+06,  2.383000e+06,  2.408400e+06,
         9.712000e+05,  6.370000e+05,  9.794000e+05,  1.546400e+06,
         7.125000e+05,  7.126000e+05,  9.317000e+05,  7.907000e+05,
        -2.033000e+05,  3.720000e+04, -4.830000e+04, -2.445000e+05,
         3.465000e+05,  3.896000e+05,  3.630000e+04, -3.610000e+04,
         2.220000e+04,  1.100000e+03,  1.100000e+03,  1.100000e+03,
         1.100000e+03,  2.179000e+05,  2.179000e+05,  2.865000e+05,
         3.515000e+05,  4.602000e+05, -1.580000e+04,  0.000000e+00,
        -5.370000e+04, -1.578000e+05,  6.557000e+05,  4.303000e+05,
         3.340000e+04,  3.340000e+04,  3.478000e+05,  3.477000e+05,
         3.477000e+05,  7.538000e+05,  1.294600e+06,  1.348800e+06,
         9.053000e+05,  1.780000e+04,  3.415000e+05, -1.383000e+05,
         2.696000e+05,  5.170000e+04,  8.103000e+05,  5.170000e+04,
         8.100000e+05,  6.196000e+05,  1.049800e+06,  1.335000e+06,
         1.484400e+06,  3.335000e+05,  4.424000e+05,  1.792500e+06,
         3.115000e+05,  2.660000e+04,  1.361000e+05,  3.159000e+05,
         1.003000e+06, -1.157000e+05,  2.112000e+05,  1.600000e+03,
         1.693000e+05, -1.140000e+05,  5.070000e+04,  1.923000e+05,
         4.780000e+05, -9.340000e+04,  7.368000e+05,  3.879000e+05,
         6.197000e+05,  8.375000e+05,  4.679000e+05,  4.950000e+04,
         3.751000e+05,  3.342000e+05,  4.745000e+05, -1.087000e+05,
         3.742000e+05,  4.530000e+04,  3.714000e+05,  1.084700e+06,
         1.089800e+06, -4.970000e+04, -4.970000e+04,  2.798000e+05,
         8.458000e+05,  3.013000e+05, -6.568000e+05,  3.100000e+04,
         3.090000e+04,  2.570000e+04,  2.570000e+04,  7.240000e+05,
         2.580000e+04, -3.285000e+05,  2.570000e+04,  4.730000e+04,
         4.730000e+04,  4.730000e+04,  4.720000e+04,  4.330000e+04,
        -5.610000e+04, -5.610000e+04, -5.610000e+04,  2.498000e+05,
        -3.410000e+04,  0.000000e+00, -3.430000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.365000e+05, -7.070000e+04, -2.260000e+04,
         2.454500e+06,  8.165000e+05,  8.142000e+05,  9.563000e+05,
         9.564000e+05, -1.620000e+04,  2.689000e+05, -2.510000e+04,
        -3.480000e+04,  6.650000e+04,  5.960000e+04, -9.000000e+02,
         2.845000e+05,  6.000000e+02,  1.654000e+05,  8.000000e+02,
         0.000000e+00,  3.300000e+03, -2.730000e+04, -7.220000e+04,
         3.660000e+04, -1.090000e+04, -1.090000e+04, -1.090000e+04,
         0.000000e+00,  0.000000e+00,  2.391000e+05,  3.477000e+05,
         2.279000e+05,  3.830000e+04, -1.069000e+05,  3.380000e+04,
        -4.490000e+04, -3.570000e+04,  1.399000e+05,  8.260000e+04,
         2.832000e+05,  2.832000e+05, -5.070000e+04,  5.890000e+04,
        -4.400000e+03,  2.338000e+05,  3.423000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02, -2.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -3.480000e+04,
         2.689000e+05,  3.730000e+04,  8.000000e+02,  1.654000e+05,
         4.730000e+04,  1.000000e+02, -4.780000e+04,  1.706000e+05,
         3.477000e+05,  1.100000e+03,  3.515000e+05,  3.316000e+05,
         7.240000e+05,  2.570000e+04,  3.090000e+04, -5.610000e+04,
        -2.260000e+04, -2.510000e+04, -1.090000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.730000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-2.480000e+04,  3.528000e+05,  5.160000e+04,  6.686000e+05,
         3.212000e+05, -1.388000e+05, -8.930000e+04, -1.900000e+04,
         3.527000e+05, -1.790000e+04,  3.518000e+05,  2.910000e+04,
         2.130000e+05,  3.580000e+04,  0.000000e+00,  2.910000e+04,
         3.772000e+05,  2.940000e+04,  2.470000e+04,  1.168000e+05,
         0.000000e+00,  1.227000e+05,  6.752000e+05,  2.426000e+05,
         1.196900e+06,  1.543900e+06,  9.904000e+05,  8.790000e+04,
         1.154300e+06,  5.687000e+05,  5.612000e+05,  9.439000e+05,
         7.355200e+06,  1.177000e+05,  1.180000e+05,  1.184000e+05,
         1.175000e+05,  8.570000e+04,  1.181000e+05,  7.257000e+05,
         1.463700e+06,  8.855000e+05,  6.500000e+04,  2.484000e+05,
         1.049000e+05,  9.925000e+05,  1.624500e+06,  9.192000e+05,
         9.194000e+05,  1.076600e+06,  1.378900e+06,  8.789000e+05,
         5.102000e+05,  1.760000e+06,  1.943800e+06,  2.730100e+06,
         7.186000e+05,  7.024000e+05,  1.053900e+06,  1.621500e+06,
         3.755000e+05,  3.757000e+05,  7.463000e+05,  4.554000e+05,
        -1.694000e+05,  9.770000e+04, -1.980000e+04, -1.879000e+05,
         3.463000e+05,  4.599000e+05,  6.260000e+04, -5.630000e+04,
         4.500000e+04,  5.750000e+04,  5.750000e+04,  5.750000e+04,
         5.750000e+04,  4.347000e+05,  4.347000e+05,  6.540000e+04,
         4.126000e+05,  6.013000e+05, -1.620000e+04,  0.000000e+00,
         1.404000e+05, -3.380000e+04,  4.226000e+05,  3.458000e+05,
         5.920000e+04,  5.920000e+04,  3.845000e+05,  3.845000e+05,
         3.844000e+05,  9.937000e+05,  1.936800e+06,  1.015400e+06,
         7.486000e+05,  1.357000e+05,  7.003000e+05, -1.243000e+05,
         1.016600e+06,  2.833000e+05,  1.603400e+06,  2.833000e+05,
         1.603600e+06,  2.980000e+05,  9.760000e+04,  1.054000e+05,
         8.492000e+05,  1.470000e+05,  3.307000e+05,  3.636400e+06,
         6.530000e+04,  5.800000e+04,  2.422000e+05,  1.012000e+05,
         5.463000e+05, -1.301000e+05,  4.334000e+05, -1.030000e+04,
        -1.228000e+05, -9.560000e+04,  1.688000e+05,  1.660000e+04,
         2.450000e+04,  8.700000e+03,  9.353000e+05,  2.163000e+05,
         2.120000e+05,  5.795000e+05,  3.594000e+05,  1.682000e+05,
         7.185000e+05,  1.756000e+05,  3.642000e+05, -9.460000e+04,
         7.342000e+05,  1.736000e+05,  1.946000e+05,  8.957000e+05,
         1.053000e+06,  4.000000e+02,  5.000000e+02,  5.704000e+05,
         1.241400e+06,  3.227000e+05,  2.306000e+05,  6.490000e+04,
         6.500000e+04,  2.890000e+04,  2.890000e+04,  5.123000e+05,
         2.900000e+04, -1.421000e+05,  2.890000e+04,  8.200000e+04,
         8.200000e+04,  8.200000e+04,  8.190000e+04,  7.690000e+04,
        -9.310000e+04, -9.310000e+04, -9.310000e+04, -2.900000e+03,
        -9.700000e+03,  0.000000e+00, -5.400000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -5.587000e+05, -1.354000e+05, -5.320000e+04,
         1.819700e+06,  6.757000e+05,  6.751000e+05,  9.212000e+05,
         9.213000e+05, -1.680000e+04,  2.690000e+05, -3.690000e+04,
        -3.870000e+04,  1.409000e+05,  1.271000e+05, -3.000000e+03,
         3.580000e+04,  2.910000e+04,  3.503000e+05,  9.000000e+02,
         0.000000e+00,  9.900000e+03, -4.230000e+04, -8.890000e+04,
         9.210000e+04, -1.880000e+04, -1.880000e+04, -1.880000e+04,
         0.000000e+00,  0.000000e+00, -1.630000e+04,  1.673000e+05,
         4.862000e+05,  9.610000e+04, -1.276000e+05,  8.510000e+04,
        -5.140000e+04, -3.970000e+04,  1.620000e+04,  1.748000e+05,
         2.832000e+05,  2.832000e+05, -5.580000e+04,  1.310000e+05,
        -6.600000e+03,  2.286000e+05,  4.144000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02, -2.400000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -3.870000e+04,
         2.690000e+05,  4.700000e+03,  9.000000e+02,  3.503000e+05,
         8.200000e+04,  1.000000e+02, -2.480000e+04,  3.528000e+05,
         3.845000e+05,  5.750000e+04,  4.126000e+05,  1.175000e+05,
         5.123000e+05,  2.890000e+04,  6.500000e+04, -9.310000e+04,
        -5.320000e+04, -3.690000e+04, -1.880000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         8.200000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-3.930000e+04,  1.860000e+04,  5.061000e+05,  6.353000e+05,
         2.972000e+05, -1.945000e+05, -1.160000e+05, -3.700000e+04,
         1.860000e+04, -3.670000e+04,  1.860000e+04,  2.700000e+03,
         3.000000e+04,  2.924000e+05,  0.000000e+00,  2.700000e+03,
         3.421000e+05,  2.500000e+03,  3.500000e+03,  1.290000e+04,
         0.000000e+00,  3.110000e+05,  3.914000e+05,  3.253700e+06,
         1.416000e+06,  1.022300e+06,  6.950000e+04,  1.800000e+04,
         1.044800e+06,  8.263000e+05,  5.348000e+05,  8.787000e+05,
         8.544300e+06,  3.343000e+05,  3.348000e+05,  3.349000e+05,
         3.344000e+05,  3.866000e+05,  3.349000e+05,  2.801600e+06,
         2.913500e+06,  6.725100e+06,  2.962000e+05,  3.244000e+05,
         1.277100e+06,  9.342000e+05,  1.558400e+06,  1.238800e+06,
         1.238600e+06,  1.067200e+06,  8.789000e+05,  6.734900e+06,
         7.142000e+05,  2.285300e+06,  2.312900e+06,  1.456000e+06,
         1.000600e+06,  6.434000e+05,  9.841000e+05,  1.554900e+06,
         7.214000e+05,  7.216000e+05,  7.763000e+05,  2.683200e+06,
        -1.911000e+05,  4.690000e+04, -4.240000e+04, -2.452000e+05,
         3.305000e+05,  3.850000e+05,  3.260000e+04, -4.340000e+04,
         7.800000e+03,  9.400000e+03,  9.400000e+03,  9.400000e+03,
         9.400000e+03,  6.060000e+04,  6.060000e+04,  3.005000e+05,
         3.536000e+05,  3.811000e+05, -1.360000e+04,  0.000000e+00,
        -1.763000e+05, -1.594000e+05,  6.668000e+05,  4.084000e+05,
         2.469000e+05,  2.469000e+05,  3.481000e+05,  3.481000e+05,
         3.480000e+05,  7.659000e+05,  8.951000e+05,  1.367800e+06,
         9.209000e+05,  3.050000e+04,  1.056000e+05, -1.088000e+05,
        -2.137000e+05,  7.600000e+04,  2.552000e+05,  7.600000e+04,
         2.540000e+05,  6.521000e+05,  1.106600e+06,  1.396900e+06,
         1.210600e+06,  3.401000e+05,  3.678000e+05,  2.990000e+05,
         3.141000e+05,  2.670000e+04,  5.400000e+04,  3.210000e+05,
         1.007100e+06, -9.270000e+04, -1.330000e+04,  2.850000e+06,
         1.950000e+05, -1.035000e+05,  6.280000e+04,  2.260000e+05,
         5.171000e+05, -6.510000e+04,  3.640000e+05,  5.130500e+06,
         6.383000e+05,  6.935000e+05,  4.544000e+05,  5.780000e+04,
         1.425000e+05,  3.454000e+05,  4.607000e+05, -8.160000e+04,
         1.328000e+05,  3.120000e+04,  3.687000e+05,  1.087200e+06,
         9.158000e+05, -3.630000e+04, -3.630000e+04,  4.920000e+04,
         4.512000e+05,  3.132000e+05, -4.649000e+05,  2.820000e+04,
         2.830000e+04,  2.060000e+04,  2.060000e+04,  7.168000e+05,
         2.070000e+04, -3.356000e+05,  2.060000e+04,  4.190000e+04,
         4.190000e+04,  4.190000e+04,  4.190000e+04,  4.160000e+04,
        -5.560000e+04, -5.560000e+04, -5.560000e+04,  2.554000e+05,
        -3.380000e+04,  0.000000e+00, -3.200000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.337000e+05, -7.090000e+04, -2.520000e+04,
         2.435100e+06,  8.000000e+05,  7.992000e+05,  9.252000e+05,
         9.253000e+05, -1.350000e+04,  2.736000e+05, -3.410000e+04,
        -3.710000e+04, -1.060000e+04, -8.600000e+03,  1.011000e+05,
         2.924000e+05,  3.000000e+03, -2.350000e+04,  7.000000e+02,
         0.000000e+00,  0.000000e+00,  7.378000e+05, -7.650000e+04,
        -4.330000e+04, -9.800000e+03, -9.800000e+03, -9.800000e+03,
         4.395600e+06, -5.500000e+03,  2.548000e+05,  2.837000e+05,
        -3.310000e+04, -2.000000e+04, -1.135000e+05, -4.000000e+04,
        -3.680000e+04, -3.740000e+04,  1.439000e+05, -1.160000e+04,
         2.850000e+05,  2.850000e+05, -4.810000e+04, -1.420000e+04,
         1.031000e+05,  2.376000e+05,  2.709000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02, -4.600000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -3.710000e+04,
         2.736000e+05,  3.840000e+04,  7.000000e+02, -2.350000e+04,
         4.190000e+04,  1.000000e+02, -3.930000e+04,  1.860000e+04,
         3.481000e+05,  9.400000e+03,  3.536000e+05,  3.344000e+05,
         7.168000e+05,  2.060000e+04,  2.830000e+04, -5.560000e+04,
        -2.520000e+04, -3.410000e+04, -9.800000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.190000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-3.830000e+04,  1.300000e+03,  9.800000e+03,  2.847000e+05,
         1.230000e+05, -1.741000e+05, -9.750000e+04, -3.520000e+04,
         1.300000e+03, -3.460000e+04,  1.400000e+03, -9.100000e+03,
         8.400000e+03,  3.549000e+05,  0.000000e+00, -9.100000e+03,
         1.537000e+05, -8.900000e+03,  1.000000e+03, -3.610000e+04,
         0.000000e+00,  3.279000e+05,  4.000000e+05,  4.010000e+05,
         8.703000e+05,  4.522000e+05,  1.850000e+04, -2.640000e+04,
         4.672000e+05,  8.015000e+05,  4.369000e+05,  8.429000e+05,
         5.110300e+06,  3.740000e+05,  3.749000e+05,  3.741000e+05,
         3.736000e+05,  4.531000e+05,  3.756000e+05,  3.229200e+06,
         3.328000e+06,  3.326600e+06,  3.469000e+05,  3.697000e+05,
         3.712000e+05,  4.080000e+05,  6.999000e+05,  9.240000e+05,
         9.238000e+05,  7.171000e+05,  5.102000e+05,  7.142000e+05,
         6.084000e+05,  1.619800e+06,  1.643200e+06,  6.098000e+05,
         6.714000e+05,  2.784000e+05,  4.407000e+05,  7.001000e+05,
         7.479000e+05,  7.487000e+05,  7.950000e+05,  7.966000e+05,
        -1.396000e+05,  4.100000e+03, -3.970000e+04, -1.750000e+05,
         1.716000e+05,  1.724000e+05,  1.440000e+04, -1.010000e+04,
         1.330000e+04, -1.840000e+04, -1.840000e+04, -1.840000e+04,
        -1.840000e+04,  2.020000e+04,  2.020000e+04,  3.465000e+05,
         1.495000e+05,  1.690000e+05, -9.600000e+03,  0.000000e+00,
        -2.032000e+05, -1.869000e+05,  5.266000e+05,  3.209000e+05,
         1.270000e+04,  1.270000e+04,  1.556000e+05,  1.556000e+05,
         1.556000e+05,  2.924000e+05,  3.880000e+05,  1.042000e+06,
         6.098000e+05, -2.690000e+04,  2.970000e+04, -9.170000e+04,
        -3.464000e+05, -4.450000e+04,  9.080000e+04, -4.450000e+04,
         9.060000e+04,  6.828000e+05,  1.347000e+06,  1.711800e+06,
         1.428000e+06,  3.673000e+05,  3.906000e+05,  8.410000e+04,
         3.720000e+05,  6.700000e+03,  3.080000e+04,  3.650000e+05,
         9.181000e+05, -6.960000e+04, -8.200000e+03,  3.500000e+03,
         2.957000e+05, -7.780000e+04, -6.900000e+03,  2.733000e+05,
         6.385000e+05, -9.180000e+04,  3.903000e+05,  3.952000e+05,
         7.157000e+05,  7.624000e+05,  4.251000e+05, -7.600000e+03,
         6.100000e+04,  3.574000e+05,  4.320000e+05, -7.450000e+04,
         5.010000e+04, -1.920000e+04,  3.859000e+05,  7.297000e+05,
         5.230000e+05, -4.730000e+04, -4.730000e+04,  1.300000e+04,
         3.698000e+05,  2.529000e+05, -6.979000e+05,  8.700000e+03,
         8.700000e+03,  1.540000e+04,  1.540000e+04,  5.650000e+05,
         1.620000e+04, -3.629000e+05,  1.540000e+04,  1.890000e+04,
         1.890000e+04,  1.890000e+04,  1.890000e+04,  1.680000e+04,
        -2.350000e+04, -2.350000e+04, -2.350000e+04,  3.339000e+05,
        -3.010000e+04,  0.000000e+00, -1.530000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.411000e+05, -2.360000e+04, -4.100000e+03,
         1.824100e+06,  6.179000e+05,  6.344000e+05,  6.928000e+05,
         6.935000e+05, -9.400000e+03,  1.229000e+05, -5.600000e+03,
        -2.100000e+04, -5.800000e+03, -5.800000e+03, -1.000000e+02,
         3.549000e+05, -9.100000e+03, -1.660000e+04,  5.000000e+02,
         0.000000e+00,  1.000000e+02, -7.600000e+03, -3.360000e+04,
        -9.700000e+03, -4.300000e+03, -4.300000e+03, -4.300000e+03,
         0.000000e+00,  0.000000e+00,  3.275000e+05,  3.510000e+05,
        -2.210000e+04, -1.350000e+04, -5.460000e+04, -8.900000e+03,
        -2.710000e+04, -2.080000e+04,  1.752000e+05, -7.900000e+03,
         1.297000e+05,  1.297000e+05, -2.970000e+04, -6.600000e+03,
        -1.900000e+03,  1.008000e+05,  1.231000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  8.000000e+02, -1.100000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.100000e+04,
         1.229000e+05,  4.660000e+04,  5.000000e+02, -1.660000e+04,
         1.890000e+04,  8.000000e+02, -3.830000e+04,  1.300000e+03,
         1.556000e+05, -1.840000e+04,  1.495000e+05,  3.737000e+05,
         5.650000e+05,  1.540000e+04,  8.700000e+03, -2.350000e+04,
        -4.100000e+03, -5.600000e+03, -4.300000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.890000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.550000e+04, -4.700000e+03,  3.340000e+04,  1.210900e+06,
         6.118000e+05,  5.220000e+04,  2.110000e+04,  1.780000e+04,
        -4.700000e+03,  1.810000e+04, -4.400000e+03,  3.100000e+04,
         1.940000e+04,  8.292000e+05,  0.000000e+00,  3.100000e+04,
         6.353000e+05,  3.080000e+04,  2.200000e+03,  1.262000e+05,
         0.000000e+00,  9.292000e+05,  9.273000e+05,  9.593000e+05,
         2.947300e+06,  1.894000e+06,  2.350000e+04,  1.009000e+05,
         1.934900e+06,  1.948100e+06,  1.148200e+06,  1.928200e+06,
         1.778240e+07,  8.725000e+05,  8.740000e+05,  8.731000e+05,
         8.722000e+05,  1.058200e+06,  8.753000e+05,  7.755400e+06,
         7.756500e+06,  7.795400e+06,  8.668000e+05,  8.614000e+05,
         8.768000e+05,  1.824700e+06,  2.992400e+06,  2.773400e+06,
         2.780300e+06,  2.274100e+06,  1.760000e+06,  2.285300e+06,
         1.619800e+06,  5.345300e+06,  5.342100e+06,  2.811500e+06,
         2.180600e+06,  1.254400e+06,  1.857400e+06,  2.991200e+06,
         1.855600e+06,  1.856900e+06,  1.849200e+06,  1.875600e+06,
         9.000000e+02,  7.710000e+04,  2.410000e+04,  2.360000e+04,
         6.776000e+05,  6.796000e+05,  3.470000e+04, -4.050000e+04,
         1.130000e+04,  6.460000e+04,  6.460000e+04,  6.460000e+04,
         6.460000e+04,  3.850000e+04,  3.850000e+04,  8.657000e+05,
         6.867000e+05,  6.748000e+05, -3.070000e+04,  0.000000e+00,
        -4.939000e+05, -4.455000e+05,  1.535000e+06,  9.089000e+05,
         3.380000e+04,  3.380000e+04,  6.451000e+05,  6.449000e+05,
         6.449000e+05,  1.519500e+06,  1.452000e+06,  3.182900e+06,
         2.209900e+06,  8.160000e+04,  3.770000e+04, -7.430000e+04,
        -8.574000e+05,  2.720000e+05,  1.806000e+05,  2.720000e+05,
         1.794000e+05,  1.867500e+06,  3.368400e+06,  4.168600e+06,
         3.324700e+06,  9.096000e+05,  9.061000e+05,  1.188000e+05,
         8.397000e+05,  4.130000e+04,  4.110000e+04,  8.424000e+05,
         2.450200e+06, -2.940000e+04, -5.880000e+04,  7.000000e+02,
         7.694000e+05, -3.810000e+04,  1.474000e+05,  9.234000e+05,
         1.720400e+06,  1.264000e+05,  9.071000e+05,  9.735000e+05,
         1.776000e+06,  1.769500e+06,  9.908000e+05,  1.431000e+05,
         1.269000e+05,  9.410000e+05,  1.004500e+06, -1.880000e+04,
         1.023000e+05,  8.340000e+04,  9.006000e+05,  2.315300e+06,
         1.809200e+06,  4.760000e+04,  4.760000e+04,  1.710000e+04,
         8.273000e+05,  8.437000e+05,  8.937000e+05,  1.090000e+04,
         1.090000e+04,  6.500000e+03,  6.500000e+03,  1.629200e+06,
         7.800000e+03, -9.042000e+05,  6.500000e+03,  4.320000e+04,
         4.320000e+04,  4.320000e+04,  4.320000e+04,  4.350000e+04,
        -6.240000e+04, -6.230000e+04, -6.230000e+04,  8.184000e+05,
         2.060000e+04,  0.000000e+00, -4.300000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.742000e+05, -8.680000e+04, -4.020000e+04,
         5.452400e+06,  1.714400e+06,  1.712700e+06,  1.845000e+06,
         1.846300e+06, -3.090000e+04,  5.402000e+05, -3.190000e+04,
        -1.080000e+04, -2.320000e+04, -1.630000e+04, -7.000000e+02,
         8.292000e+05,  3.120000e+04, -4.780000e+04,  2.000000e+02,
         0.000000e+00,  2.000000e+02, -2.610000e+04, -5.260000e+04,
        -4.290000e+04, -1.040000e+04, -1.040000e+04, -1.040000e+04,
         0.000000e+00,  0.000000e+00,  8.206000e+05,  8.187000e+05,
        -6.250000e+04, -1.690000e+04, -6.340000e+04, -3.960000e+04,
        -9.000000e+03, -9.900000e+03,  4.100000e+05, -2.320000e+04,
         5.665000e+05,  5.664000e+05, -2.670000e+04, -2.050000e+04,
        -5.000000e+03,  5.418000e+05,  5.462000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.300000e+03, -5.300000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.080000e+04,
         5.402000e+05,  1.088000e+05,  2.000000e+02, -4.780000e+04,
         4.320000e+04,  1.300000e+03,  1.550000e+04, -4.700000e+03,
         6.449000e+05,  6.460000e+04,  6.867000e+05,  8.722000e+05,
         1.629200e+06,  6.500000e+03,  1.090000e+04, -6.230000e+04,
        -4.020000e+04, -3.190000e+04, -1.040000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.320000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-1.187000e+05,  1.711000e+05,  3.250000e+04,  1.227300e+06,
         5.532000e+05, -5.405000e+05, -3.033000e+05, -1.089000e+05,
         1.711000e+05, -1.070000e+05,  1.714000e+05, -2.820000e+04,
         1.095000e+05,  8.179000e+05,  0.000000e+00, -2.820000e+04,
         6.505000e+05, -2.760000e+04,  1.280000e+04, -1.108000e+05,
         0.000000e+00,  7.349000e+05,  1.244700e+06,  9.672000e+05,
         2.984800e+06,  2.083900e+06,  4.550000e+05, -7.970000e+04,
         1.981700e+06,  1.924800e+06,  1.077300e+06,  2.224900e+06,
         1.785970e+07,  8.771000e+05,  8.784000e+05,  8.781000e+05,
         8.764000e+05,  1.051900e+06,  8.797000e+05,  7.463700e+06,
         8.172300e+06,  7.773400e+06,  7.803000e+05,  9.940000e+05,
         8.577000e+05,  1.782700e+06,  3.027000e+06,  2.809900e+06,
         2.816800e+06,  2.383000e+06,  1.943800e+06,  2.312900e+06,
         1.643200e+06,  5.342100e+06,  6.323600e+06,  4.154700e+06,
         2.184300e+06,  1.211200e+06,  1.889000e+06,  3.026100e+06,
         1.759000e+06,  1.760300e+06,  2.088400e+06,  1.913800e+06,
        -4.363000e+05,  1.250000e+04, -1.242000e+05, -5.441000e+05,
         6.863000e+05,  7.093000e+05,  4.550000e+04, -5.620000e+04,
         1.630000e+04, -5.620000e+04, -5.620000e+04, -5.620000e+04,
        -5.620000e+04,  2.301000e+05,  2.301000e+05,  7.930000e+05,
         6.422000e+05,  7.858000e+05, -3.060000e+04,  0.000000e+00,
        -4.207000e+05, -4.392000e+05,  1.540000e+06,  9.412000e+05,
         4.060000e+04,  4.060000e+04,  6.602000e+05,  6.601000e+05,
         6.600000e+05,  1.264900e+06,  1.977100e+06,  3.027900e+06,
         1.967500e+06, -8.360000e+04,  3.398000e+05, -2.850000e+05,
        -3.855000e+05, -1.349000e+05,  8.672000e+05, -1.349000e+05,
         8.657000e+05,  1.558100e+06,  3.051600e+06,  3.900400e+06,
         3.642900e+06,  8.536000e+05,  1.237800e+06,  1.707000e+06,
         8.701000e+05,  2.220000e+04,  1.923000e+05,  8.466000e+05,
         2.462600e+06, -2.163000e+05,  2.283000e+05,  1.600000e+04,
         6.320000e+05, -2.442000e+05, -2.050000e+04,  5.710000e+05,
         1.419100e+06, -2.771000e+05,  2.594100e+06,  9.581000e+05,
         1.648100e+06,  2.457300e+06,  1.044800e+06, -2.220000e+04,
         6.189000e+05,  8.247000e+05,  1.056600e+06, -2.321000e+05,
         4.055000e+05, -7.940000e+04,  9.229000e+05,  2.354300e+06,
         1.920600e+06, -1.483000e+05, -1.483000e+05,  2.888000e+05,
         1.376200e+06, -6.469000e+05, -2.186900e+06,  2.610000e+04,
         2.620000e+04,  4.800000e+04,  4.800000e+04,  1.654100e+06,
         4.930000e+04, -8.414000e+05,  4.800000e+04,  5.900000e+04,
         5.900000e+04,  5.900000e+04,  5.900000e+04,  5.190000e+04,
        -7.350000e+04, -7.340000e+04, -7.340000e+04,  7.527000e+05,
        -9.330000e+04,  0.000000e+00, -4.780000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -4.408000e+05, -7.420000e+04, -1.310000e+04,
         5.528500e+06,  1.770400e+06,  1.768200e+06,  1.948000e+06,
         1.949300e+06, -3.140000e+04,  5.395000e+05, -4.270000e+04,
        -6.530000e+04,  6.530000e+04,  4.230000e+04,  4.000000e+02,
         8.179000e+05, -2.810000e+04,  8.910000e+04,  1.500000e+03,
         0.000000e+00, -7.000000e+02, -4.380000e+04, -1.315000e+05,
         3.850000e+04, -1.370000e+04, -1.370000e+04, -1.370000e+04,
         0.000000e+00,  0.000000e+00,  7.342000e+05,  9.012000e+05,
         1.619000e+05,  5.500000e+03, -1.968000e+05,  3.560000e+04,
        -8.290000e+04, -6.590000e+04,  4.056000e+05,  4.510000e+04,
         5.682000e+05,  5.681000e+05, -9.610000e+04,  6.560000e+04,
        -6.600000e+03,  4.751000e+05,  6.340000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.300000e+03, -5.000000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -6.530000e+04,
         5.395000e+05,  1.073000e+05,  1.500000e+03,  8.910000e+04,
         5.900000e+04,  1.300000e+03, -1.187000e+05,  1.711000e+05,
         6.601000e+05, -5.620000e+04,  6.422000e+05,  8.765000e+05,
         1.654100e+06,  4.800000e+04,  2.620000e+04, -7.340000e+04,
        -1.310000e+04, -4.270000e+04, -1.370000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         5.900000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-2.700000e+03,  1.088700e+06,  1.494000e+05,  1.398800e+06,
         6.964000e+05, -9.640000e+04, -9.100000e+04,  9.700000e+03,
         1.088600e+06,  1.210000e+04,  1.085800e+06,  1.151000e+05,
         6.498000e+05, -4.332000e+05,  0.000000e+00,  1.151000e+05,
         8.171000e+05,  1.161000e+05,  7.520000e+04,  4.606000e+05,
         0.000000e+00, -9.270000e+04,  1.501900e+06,  1.503000e+05,
         2.107700e+06,  3.568500e+06,  2.971600e+06,  3.430000e+05,
         2.501800e+06,  5.901000e+05,  1.137000e+06,  1.675900e+06,
         1.320040e+07, -2.008000e+05, -2.009000e+05, -1.988000e+05,
        -2.012000e+05, -4.255000e+05, -1.996000e+05, -2.628900e+06,
        -4.777000e+05, -2.304800e+06, -3.283000e+05,  2.472000e+05,
        -2.473000e+05,  2.102000e+06,  3.369900e+06,  1.197600e+06,
         1.174800e+06,  2.408400e+06,  2.730100e+06,  1.456000e+06,
         6.098000e+05,  2.811500e+06,  4.154700e+06,  6.618260e+07,
         1.045700e+06,  1.521600e+06,  2.233800e+06,  3.362000e+06,
         6.160000e+04,  6.300000e+04,  1.130200e+06,  2.237000e+05,
        -2.637000e+05,  3.159000e+05,  1.930000e+04, -2.564000e+05,
         7.033000e+05,  1.051100e+06,  1.771000e+05, -1.560000e+05,
         1.318000e+05,  2.272000e+05,  2.272000e+05,  2.272000e+05,
         2.272000e+05,  1.321100e+06,  1.321100e+06, -3.185000e+05,
         9.411000e+05,  1.487600e+06, -3.600000e+04,  0.000000e+00,
         8.722000e+05,  1.813000e+05,  4.134000e+05,  5.088000e+05,
         1.692000e+05,  1.692000e+05,  8.334000e+05,  8.333000e+05,
         8.332000e+05,  2.455200e+06,  5.190700e+06,  1.352900e+06,
         1.184900e+06,  5.014000e+05,  2.144200e+06, -2.328000e+05,
         3.922400e+06,  1.028100e+06,  4.856700e+06,  1.028100e+06,
         4.857700e+06, -6.030000e+04, -1.733400e+06, -2.278900e+06,
         4.435000e+05, -8.470000e+04,  6.613000e+05,  1.096240e+07,
        -3.676000e+05,  1.791000e+05,  7.105000e+05, -2.359000e+05,
         1.763000e+05, -2.876000e+05,  1.343200e+06, -4.450000e+04,
        -8.344000e+05, -1.509000e+05,  5.722000e+05, -3.114000e+05,
        -8.596000e+05,  2.367000e+05,  3.520100e+06,  9.370000e+04,
        -4.017000e+05,  1.130900e+06,  4.949000e+05,  5.734000e+05,
         2.299800e+06,  2.690000e+04,  4.988000e+05, -1.594000e+05,
         2.215500e+06,  6.411000e+05,  3.150000e+04,  1.462700e+06,
         2.696200e+06,  1.042000e+05,  1.043000e+05,  1.752000e+06,
         3.328800e+06, -5.027000e+05,  2.278500e+06,  1.971000e+05,
         1.967000e+05,  6.380000e+04,  6.380000e+04,  6.148000e+05,
         6.520000e+04,  9.640000e+04,  6.380000e+04,  2.324000e+05,
         2.324000e+05,  2.324000e+05,  2.322000e+05,  2.203000e+05,
        -2.572000e+05, -2.571000e+05, -2.571000e+05, -5.178000e+05,
         3.030000e+04,  0.000000e+00, -1.487000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.543200e+06, -3.979000e+05, -1.670000e+05,
         2.408100e+06,  1.079900e+06,  1.079800e+06,  1.779800e+06,
         1.781100e+06, -3.430000e+04,  5.337000e+05, -1.006000e+05,
        -8.460000e+04,  4.404000e+05,  3.808000e+05, -1.020000e+04,
        -4.332000e+05,  1.150000e+05,  1.040800e+06,  2.000000e+03,
         0.000000e+00,  1.510000e+04, -1.175000e+05, -2.134000e+05,
         3.055000e+05, -5.320000e+04, -5.330000e+04, -5.330000e+04,
         0.000000e+00,  0.000000e+00, -5.487000e+05, -1.930000e+04,
         1.456500e+06,  2.941000e+05, -2.979000e+05,  2.825000e+05,
        -1.141000e+05, -8.550000e+04, -2.167000e+05,  5.201000e+05,
         5.625000e+05,  5.624000e+05, -1.208000e+05,  4.040000e+05,
        -1.750000e+04,  4.436000e+05,  9.668000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.400000e+03, -4.800000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -8.460000e+04,
         5.337000e+05, -5.680000e+04,  2.000000e+03,  1.040800e+06,
         2.324000e+05,  1.400000e+03, -2.700000e+03,  1.088700e+06,
         8.333000e+05,  2.272000e+05,  9.411000e+05, -2.012000e+05,
         6.148000e+05,  6.380000e+04,  1.967000e+05, -2.571000e+05,
        -1.670000e+05, -1.006000e+05, -5.330000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.324000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-8.530000e+04, -7.140000e+04, -5.220000e+04,  6.229000e+05,
         2.682000e+05, -3.445000e+05, -1.740000e+05, -8.490000e+04,
        -7.140000e+04, -8.480000e+04, -7.130000e+04, -8.160000e+04,
        -7.480000e+04,  4.464000e+05,  0.000000e+00, -8.160000e+04,
         2.737000e+05, -8.170000e+04, -8.600000e+03, -3.249000e+05,
         0.000000e+00,  2.043000e+05,  2.140000e+05,  2.538000e+05,
         1.374000e+06,  8.433000e+05, -2.214000e+05, -2.409000e+05,
         8.377000e+05,  3.352000e+05, -1.913000e+05,  3.452000e+05,
         8.335000e+06,  3.668000e+05,  3.668000e+05,  3.666000e+05,
         3.675000e+05,  5.186000e+05,  3.668000e+05,  3.415500e+06,
         3.426800e+06,  3.481600e+06,  3.643000e+05,  3.683000e+05,
         3.808000e+05,  8.925000e+05,  1.591200e+06,  1.199300e+06,
         1.198900e+06,  9.712000e+05,  7.186000e+05,  1.000600e+06,
         6.714000e+05,  2.180600e+06,  2.184300e+06,  1.045700e+06,
         1.637400e+06,  5.460000e+05,  9.029000e+05,  1.589400e+06,
         4.920000e+05,  4.920000e+05,  5.003000e+05,  5.251000e+05,
        -1.809000e+05, -1.579000e+05, -1.014000e+05, -2.644000e+05,
         2.752000e+05,  1.930000e+05, -5.950000e+04,  4.900000e+03,
        -9.380000e+04, -1.612000e+05, -1.612000e+05, -1.612000e+05,
        -1.612000e+05, -1.505000e+05, -1.505000e+05,  3.655000e+05,
         2.004000e+05,  2.066000e+05, -2.000000e+03,  0.000000e+00,
        -2.249000e+05, -2.250000e+05,  7.617000e+05,  2.423000e+05,
        -5.820000e+04, -5.820000e+04,  2.793000e+05,  2.792000e+05,
         2.792000e+05,  8.180000e+04,  1.084000e+05,  1.150400e+06,
         8.439000e+05, -3.235000e+05, -3.077000e+05, -8.990000e+04,
        -7.583000e+05, -6.421000e+05, -6.047000e+05, -6.421000e+05,
        -6.058000e+05,  4.084000e+05,  1.615900e+06,  2.142300e+06,
         1.636200e+06,  2.866000e+05,  2.903000e+05, -8.935000e+05,
         4.478000e+05, -7.880000e+04, -7.540000e+04,  3.654000e+05,
         1.117100e+06, -4.700000e+03,  1.180000e+04,  4.480000e+04,
         5.220000e+05, -9.450000e+04, -3.177000e+05,  1.967000e+05,
         7.242000e+05, -3.309000e+05,  2.152000e+05,  2.793000e+05,
         6.523000e+05,  6.596000e+05,  1.278000e+05, -3.195000e+05,
        -3.073000e+05,  2.066000e+05,  1.293000e+05, -8.360000e+04,
        -3.049000e+05, -3.334000e+05,  2.844000e+05,  9.819000e+05,
         7.542000e+05, -1.638000e+05, -1.639000e+05, -1.466000e+05,
        -1.650000e+05, -1.835000e+05, -2.809400e+06, -8.040000e+04,
        -8.050000e+04,  1.100000e+03,  1.100000e+03,  6.693000e+05,
         1.100000e+03, -2.857000e+05,  1.100000e+03, -7.910000e+04,
        -7.910000e+04, -7.910000e+04, -7.910000e+04, -7.850000e+04,
         7.220000e+04,  7.210000e+04,  7.210000e+04,  4.431000e+05,
        -8.470000e+04,  0.000000e+00,  4.440000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  4.330000e+05,  1.556000e+05,  7.830000e+04,
         2.351200e+06,  5.118000e+05,  5.126000e+05,  2.752000e+05,
         2.752000e+05, -1.400000e+03,  3.263000e+05, -1.470000e+04,
        -3.300000e+03,  3.600000e+03,  1.700000e+03,  6.500000e+03,
         4.464000e+05, -8.150000e+04,  3.700000e+03,  1.000000e+02,
         0.000000e+00,  1.000000e+02,  5.000000e+02, -2.140000e+04,
        -1.270000e+04,  1.790000e+04,  1.790000e+04,  1.790000e+04,
         0.000000e+00,  0.000000e+00,  4.429000e+05,  4.479000e+05,
         6.400000e+03, -2.000000e+02, -2.470000e+04, -1.180000e+04,
        -3.000000e+03, -3.400000e+03,  2.223000e+05,  1.900000e+03,
         3.429000e+05,  3.429000e+05, -1.040000e+04, -9.000000e+02,
         3.600000e+03,  3.319000e+05,  3.419000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.400000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -3.300000e+03,
         3.263000e+05,  5.860000e+04,  1.000000e+02,  3.700000e+03,
        -7.910000e+04,  0.000000e+00, -8.530000e+04, -7.140000e+04,
         2.792000e+05, -1.612000e+05,  2.004000e+05,  3.675000e+05,
         6.693000e+05,  1.100000e+03, -8.050000e+04,  7.210000e+04,
         7.830000e+04, -1.470000e+04,  1.790000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -7.910000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.172000e+05,  3.170000e+04,  4.230000e+04,  6.957000e+05,
         4.242000e+05,  4.950000e+05,  2.605000e+05,  1.139000e+05,
         3.170000e+04,  1.132000e+05,  3.160000e+04,  8.270000e+04,
         4.250000e+04, -1.332000e+05,  0.000000e+00,  8.270000e+04,
         3.697000e+05,  8.250000e+04,  4.900000e+03,  3.309000e+05,
         0.000000e+00,  1.141000e+05, -1.470000e+04,  3.900000e+03,
         9.632000e+05,  1.097200e+06,  1.004000e+05,  2.466000e+05,
         1.119200e+06,  1.250000e+05,  3.415000e+05,  4.020000e+04,
         6.250400e+06, -8.420000e+04, -8.430000e+04, -8.440000e+04,
        -8.410000e+04, -1.420000e+05, -8.430000e+04, -6.978000e+05,
        -8.703000e+05, -8.446000e+05, -5.050000e+04, -9.390000e+04,
        -8.720000e+04,  1.128800e+06,  1.716700e+06,  5.749000e+05,
         5.749000e+05,  6.370000e+05,  7.024000e+05,  6.434000e+05,
         2.784000e+05,  1.254400e+06,  1.211200e+06,  1.521600e+06,
         5.460000e+05,  8.041000e+05,  1.069900e+06,  1.702400e+06,
         4.500000e+04,  4.500000e+04, -4.020000e+04, -2.840000e+04,
         3.131000e+05,  1.391000e+05,  1.346000e+05,  4.272000e+05,
         3.401000e+05,  4.120000e+05,  3.850000e+04, -2.940000e+04,
         3.010000e+04,  1.653000e+05,  1.653000e+05,  1.653000e+05,
         1.653000e+05,  8.080000e+04,  8.080000e+04, -5.140000e+04,
         4.568000e+05,  4.142000e+05, -1.310000e+04,  0.000000e+00,
         4.580000e+04,  5.330000e+04,  2.321000e+05,  1.833000e+05,
         4.030000e+04,  4.030000e+04,  3.733000e+05,  3.732000e+05,
         3.733000e+05,  1.209500e+06,  9.985000e+05,  7.685000e+05,
         8.285000e+05,  2.699000e+05,  1.436000e+05,  1.101000e+05,
         2.589000e+05,  6.267000e+05,  3.309000e+05,  6.267000e+05,
         3.316000e+05,  1.945000e+05, -3.024000e+05, -5.189000e+05,
        -4.718000e+05, -2.000000e+03, -4.520000e+04,  4.269000e+05,
        -1.519000e+05,  6.390000e+04,  2.100000e+04, -9.750000e+04,
         1.449000e+05,  8.300000e+04, -4.480000e+04, -2.710000e+04,
        -1.329000e+05,  1.395000e+05,  2.959000e+05,  1.822000e+05,
        -3.450000e+04,  3.989000e+05, -3.350000e+04, -1.300000e+03,
        -5.310000e+04, -1.393000e+05,  6.230000e+04,  2.961000e+05,
         1.661000e+05,  8.040000e+04,  6.280000e+04,  1.356000e+05,
         1.701000e+05,  2.863000e+05, -3.560000e+04,  6.446000e+05,
         7.067000e+05,  1.989000e+05,  1.989000e+05,  7.200000e+04,
         1.639000e+05,  3.796000e+05,  3.292600e+06,  3.580000e+04,
         3.580000e+04, -1.840000e+04, -1.840000e+04,  2.769000e+05,
        -1.850000e+04, -1.600000e+03, -1.840000e+04,  4.910000e+04,
         4.910000e+04,  4.910000e+04,  4.900000e+04,  5.180000e+04,
        -6.170000e+04, -6.160000e+04, -6.160000e+04, -1.079000e+05,
         1.080000e+05,  0.000000e+00, -3.760000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.699000e+05, -1.153000e+05, -6.690000e+04,
         1.145000e+06,  3.754000e+05,  3.759000e+05,  5.229000e+05,
         5.229000e+05, -1.330000e+04,  3.005000e+05, -1.890000e+04,
         2.530000e+04, -1.220000e+04, -7.300000e+03, -3.100000e+03,
        -1.332000e+05,  8.270000e+04, -1.830000e+04, -6.000000e+02,
         0.000000e+00, -6.000000e+02, -1.780000e+04,  9.800000e+03,
        -2.820000e+04, -1.160000e+04, -1.160000e+04, -1.160000e+04,
         0.000000e+00,  0.000000e+00, -1.001000e+05, -1.428000e+05,
        -2.800000e+04,  4.800000e+03,  3.510000e+04, -2.600000e+04,
         3.260000e+04,  2.600000e+04, -6.690000e+04, -9.200000e+03,
         3.141000e+05,  3.140000e+05,  2.600000e+04, -1.270000e+04,
        -4.000000e+03,  3.384000e+05,  3.010000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02, -3.100000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.530000e+04,
         3.005000e+05, -1.750000e+04, -6.000000e+02, -1.830000e+04,
         4.910000e+04, -1.000000e+02,  1.172000e+05,  3.170000e+04,
         3.732000e+05,  1.653000e+05,  4.568000e+05, -8.420000e+04,
         2.769000e+05, -1.840000e+04,  3.580000e+04, -6.160000e+04,
        -6.690000e+04, -1.890000e+04, -1.160000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.910000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-4.280000e+04,  2.390000e+04,  2.660000e+04,  1.092700e+06,
         5.149000e+05, -2.025000e+05, -1.170000e+05, -3.830000e+04,
         2.390000e+04, -3.740000e+04,  2.380000e+04, -1.000000e+02,
         2.970000e+04, -1.415000e+05,  0.000000e+00, -1.000000e+02,
         5.505000e+05,  2.000000e+02,  3.500000e+03, -5.000000e+02,
         0.000000e+00, -1.421000e+05, -4.720000e+04, -3.510000e+04,
         1.493800e+06,  1.648100e+06,  7.580000e+04,  0.000000e+00,
         1.675700e+06, -4.860000e+04,  9.230000e+04,  1.720000e+04,
         9.461700e+06, -9.920000e+04, -9.940000e+04, -9.920000e+04,
        -9.930000e+04, -1.558000e+05, -9.940000e+04, -1.126900e+06,
        -1.000800e+06, -9.843000e+05, -1.417000e+05, -1.101000e+05,
        -1.060000e+05,  1.601600e+06,  2.677000e+06,  9.104000e+05,
         9.104000e+05,  9.794000e+05,  1.053900e+06,  9.841000e+05,
         4.407000e+05,  1.857400e+06,  1.889000e+06,  2.233800e+06,
         9.029000e+05,  1.069900e+06,  1.700400e+06,  2.648300e+06,
        -1.560000e+05, -1.560000e+05, -9.250000e+04, -8.470000e+04,
        -1.804000e+05,  3.080000e+04, -4.350000e+04, -2.170000e+05,
         5.137000e+05,  5.691000e+05,  3.230000e+04, -3.110000e+04,
         2.120000e+04, -6.000000e+02, -6.000000e+02, -6.000000e+02,
        -6.000000e+02,  6.620000e+04,  6.620000e+04, -1.414000e+05,
         5.468000e+05,  5.808000e+05, -1.290000e+04,  0.000000e+00,
         5.050000e+04,  5.810000e+04,  4.033000e+05,  2.534000e+05,
         3.050000e+04,  3.050000e+04,  5.585000e+05,  5.583000e+05,
         5.584000e+05,  1.134600e+06,  1.303300e+06,  8.471000e+05,
         8.482000e+05,  1.540000e+04,  1.158000e+05, -1.244000e+05,
         2.376000e+05,  3.990000e+04,  2.739000e+05,  3.990000e+04,
         2.741000e+05, -2.413000e+05, -6.498000e+05, -7.906000e+05,
        -5.175000e+05, -9.970000e+04, -6.810000e+04,  3.321000e+05,
        -1.186000e+05,  2.280000e+04,  5.450000e+04, -1.122000e+05,
         2.986000e+05, -1.040000e+05, -5.100000e+03,  3.000000e+03,
        -2.455000e+05, -9.810000e+04,  4.120000e+04, -2.269000e+05,
        -3.678000e+05, -8.600000e+04, -6.890000e+04, -4.860000e+04,
        -2.417000e+05, -1.785000e+05,  2.750000e+04,  4.120000e+04,
         1.359000e+05, -1.001000e+05,  2.760000e+04, -9.860000e+04,
         1.416000e+05,  4.590000e+04, -5.680000e+04,  9.870000e+05,
         1.056000e+06, -4.540000e+04, -4.540000e+04,  5.710000e+04,
         1.303000e+05, -2.770000e+04, -6.058000e+05,  2.930000e+04,
         2.940000e+04,  2.310000e+04,  2.310000e+04,  4.378000e+05,
         2.310000e+04,  1.033000e+05,  2.310000e+04,  4.230000e+04,
         4.230000e+04,  4.230000e+04,  4.230000e+04,  3.790000e+04,
        -5.580000e+04, -5.570000e+04, -5.570000e+04, -1.720000e+05,
        -3.060000e+04,  0.000000e+00, -2.950000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.346000e+05, -6.130000e+04, -1.910000e+04,
         1.815100e+06,  5.233000e+05,  5.243000e+05,  6.512000e+05,
         6.512000e+05, -1.290000e+04,  4.749000e+05, -2.110000e+04,
        -3.050000e+04, -4.200000e+03, -8.200000e+03,  0.000000e+00,
        -1.415000e+05, -1.000000e+02, -2.040000e+04,  7.000000e+02,
         0.000000e+00, -9.000000e+02, -2.240000e+04, -6.250000e+04,
        -3.170000e+04, -9.700000e+03, -9.700000e+03, -9.700000e+03,
         0.000000e+00,  0.000000e+00, -1.835000e+05, -1.523000e+05,
        -3.130000e+04, -2.090000e+04, -9.300000e+04, -2.930000e+04,
        -4.140000e+04, -3.140000e+04, -7.080000e+04, -1.020000e+04,
         5.015000e+05,  5.014000e+05, -4.700000e+04, -1.510000e+04,
        -5.000000e+03,  4.505000e+05,  4.858000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -4.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -3.050000e+04,
         4.749000e+05, -1.860000e+04,  7.000000e+02, -2.040000e+04,
         4.230000e+04,  0.000000e+00, -4.280000e+04,  2.390000e+04,
         5.583000e+05, -6.000000e+02,  5.468000e+05, -9.930000e+04,
         4.378000e+05,  2.310000e+04,  2.940000e+04, -5.570000e+04,
        -1.910000e+04, -2.110000e+04, -9.700000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.230000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-9.910000e+04, -2.490000e+04, -1.890000e+04,  1.778300e+06,
         8.368000e+05, -4.265000e+05, -2.284000e+05, -9.450000e+04,
        -2.490000e+04, -9.360000e+04, -2.490000e+04, -5.710000e+04,
        -2.350000e+04, -1.261000e+05,  0.000000e+00, -5.710000e+04,
         8.577000e+05, -5.670000e+04, -2.600000e+03, -2.292000e+05,
         0.000000e+00, -2.987000e+05, -1.941000e+05, -1.746000e+05,
         2.419600e+06,  2.577600e+06, -7.840000e+04, -1.723000e+05,
         2.603600e+06, -4.195000e+05, -3.514000e+05, -3.460000e+05,
         1.537060e+07, -1.413000e+05, -1.416000e+05, -1.413000e+05,
        -1.415000e+05, -1.654000e+05, -1.415000e+05, -1.419200e+06,
        -1.280500e+06, -1.253700e+06, -1.834000e+05, -1.483000e+05,
        -1.420000e+05,  2.627500e+06,  4.485200e+06,  1.479200e+06,
         1.479300e+06,  1.546400e+06,  1.621500e+06,  1.554900e+06,
         7.001000e+05,  2.991200e+06,  3.026100e+06,  3.362000e+06,
         1.589400e+06,  1.702400e+06,  2.648300e+06,  4.504100e+06,
        -4.119000e+05, -4.118000e+05, -3.419000e+05, -3.291000e+05,
        -2.896000e+05, -8.480000e+04, -1.109000e+05, -3.815000e+05,
         8.039000e+05,  8.121000e+05, -1.190000e+04, -3.400000e+04,
        -5.240000e+04, -1.153000e+05, -1.153000e+05, -1.153000e+05,
        -1.153000e+05, -4.000000e+04, -4.000000e+04, -1.834000e+05,
         7.915000e+05,  8.298000e+05, -1.330000e+04,  0.000000e+00,
         4.650000e+04,  5.010000e+04,  7.220000e+05,  3.221000e+05,
        -1.490000e+04, -1.490000e+04,  8.678000e+05,  8.676000e+05,
         8.678000e+05,  1.394500e+06,  1.584500e+06,  1.251200e+06,
         1.350100e+06, -2.145000e+05, -1.008000e+05, -1.836000e+05,
         9.500000e+03, -4.185000e+05, -1.551000e+05, -4.185000e+05,
        -1.551000e+05, -5.541000e+05, -7.016000e+05, -7.697000e+05,
        -5.534000e+05, -1.991000e+05, -1.641000e+05, -2.921000e+05,
        -1.036000e+05, -3.460000e+04,  3.000000e+02, -1.543000e+05,
         5.732000e+05, -1.044000e+05,  7.600000e+03,  1.970000e+04,
        -1.734000e+05, -1.521000e+05, -1.891000e+05, -3.815000e+05,
        -4.500000e+05, -3.130000e+05, -2.067000e+05, -1.747000e+05,
        -3.830000e+05, -3.131000e+05, -1.843000e+05, -1.880000e+05,
        -8.290000e+04, -2.568000e+05, -1.868000e+05, -1.554000e+05,
        -7.510000e+04, -1.740000e+05, -1.531000e+05,  1.550500e+06,
         1.617700e+06, -1.569000e+05, -1.569000e+05, -4.470000e+04,
        -2.118000e+05, -3.866000e+05, -2.534900e+06, -2.790000e+04,
        -2.800000e+04,  2.310000e+04,  2.320000e+04,  6.961000e+05,
         2.320000e+04,  2.031000e+05,  2.320000e+04, -1.510000e+04,
        -1.510000e+04, -1.510000e+04, -1.520000e+04, -1.980000e+04,
        -2.000000e+03, -2.000000e+03, -2.000000e+03, -1.555000e+05,
        -8.660000e+04,  0.000000e+00,  3.800000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.190000e+04,  5.470000e+04,  3.890000e+04,
         2.987400e+06,  6.672000e+05,  6.687000e+05,  6.235000e+05,
         6.235000e+05, -1.270000e+04,  8.366000e+05, -3.730000e+04,
        -2.940000e+04,  4.000000e+02, -6.100000e+03,  1.800000e+03,
        -1.261000e+05, -5.720000e+04, -1.550000e+04,  7.000000e+02,
         0.000000e+00, -1.500000e+03, -3.080000e+04, -7.670000e+04,
        -4.450000e+04,  3.600000e+03,  3.600000e+03,  3.600000e+03,
         0.000000e+00,  0.000000e+00, -1.676000e+05, -1.336000e+05,
        -2.320000e+04, -1.950000e+04, -1.061000e+05, -4.110000e+04,
        -4.090000e+04, -3.030000e+04, -6.210000e+04, -7.700000e+03,
         8.988000e+05,  8.985000e+05, -3.840000e+04, -5.400000e+03,
         1.600000e+03,  8.473000e+05,  8.914000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02,  2.200000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.940000e+04,
         8.366000e+05, -1.650000e+04,  7.000000e+02, -1.550000e+04,
        -1.510000e+04,  1.000000e+02, -9.910000e+04, -2.490000e+04,
         8.676000e+05, -1.153000e+05,  7.915000e+05, -1.415000e+05,
         6.961000e+05,  2.320000e+04, -2.800000e+04, -2.000000e+03,
         3.890000e+04, -3.730000e+04,  3.600000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.510000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 2.595000e+05,  7.740000e+04,  9.300000e+04, -1.422000e+05,
         5.840000e+04,  1.091300e+06,  5.724000e+05,  2.533000e+05,
         7.740000e+04,  2.520000e+05,  7.720000e+04,  1.898000e+05,
         1.034000e+05,  6.483000e+05,  0.000000e+00,  1.898000e+05,
        -1.150000e+04,  1.891000e+05,  1.180000e+04,  7.602000e+05,
         0.000000e+00,  1.228200e+06,  9.443000e+05,  9.797000e+05,
         5.926000e+05, -7.870000e+04,  2.562000e+05,  5.764000e+05,
        -4.220000e+04,  2.283900e+06,  1.817800e+06,  2.074900e+06,
         3.240400e+06,  7.686000e+05,  7.689000e+05,  7.718000e+05,
         7.818000e+05,  8.759000e+05,  7.685000e+05,  7.027700e+06,
         6.654600e+06,  6.696400e+06,  8.428000e+05,  7.447000e+05,
         7.600000e+05, -8.440000e+04, -4.130000e+05,  1.051900e+06,
         1.052000e+06,  7.125000e+05,  3.755000e+05,  7.214000e+05,
         7.479000e+05,  1.855600e+06,  1.759000e+06,  6.160000e+04,
         4.920000e+05,  4.500000e+04, -1.560000e+05, -4.119000e+05,
         2.120600e+06,  2.120200e+06,  1.863200e+06,  1.954900e+06,
         6.798000e+05,  3.295000e+05,  3.011000e+05,  9.467000e+05,
        -1.890000e+04,  1.099000e+05,  9.210000e+04, -2.870000e+04,
         1.190000e+05,  3.837000e+05,  3.837000e+05,  3.837000e+05,
         3.837000e+05,  1.973000e+05,  1.973000e+05,  8.468000e+05,
         1.748000e+05,  8.300000e+04, -2.160000e+04,  0.000000e+00,
        -3.634000e+05, -3.463000e+05,  6.294000e+05,  4.913000e+05,
         9.410000e+04,  9.410000e+04, -1.370000e+04, -1.360000e+04,
        -1.360000e+04,  1.045200e+06,  5.816000e+05,  1.959900e+06,
         1.111800e+06,  6.524000e+05,  3.724000e+05,  2.712000e+05,
        -3.107000e+05,  1.462800e+06,  8.104000e+05,  1.462800e+06,
         8.102000e+05,  2.473100e+06,  3.153600e+06,  3.617700e+06,
         2.750100e+06,  9.603000e+05,  8.636000e+05,  1.070000e+06,
         6.105000e+05,  1.542000e+05,  5.990000e+04,  7.466000e+05,
         1.396400e+06,  1.820000e+05, -1.039000e+05, -6.660000e+04,
         6.384000e+05,  3.008000e+05,  6.994000e+05,  1.377200e+06,
         1.832300e+06,  9.222000e+05,  8.942000e+05,  9.630000e+05,
         1.800700e+06,  1.607500e+06,  1.113900e+06,  6.955000e+05,
         4.010000e+05,  1.152500e+06,  1.130000e+06,  3.142000e+05,
         4.156000e+05,  6.793000e+05,  8.688000e+05,  7.295000e+05,
         3.900000e+05,  4.468000e+05,  4.468000e+05,  1.753000e+05,
         1.137300e+06,  1.620300e+06,  7.449200e+06,  9.820000e+04,
         9.830000e+04, -4.030000e+04, -4.040000e+04,  7.471000e+05,
        -4.070000e+04, -9.695000e+05, -4.040000e+04,  1.199000e+05,
         1.199000e+05,  1.199000e+05,  1.199000e+05,  1.261000e+05,
        -1.417000e+05, -1.416000e+05, -1.416000e+05,  7.008000e+05,
         2.428000e+05,  0.000000e+00, -8.560000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -8.500000e+05, -2.845000e+05, -1.625000e+05,
         2.113700e+06,  9.867000e+05,  9.865000e+05,  1.345600e+06,
         1.345200e+06, -2.190000e+04, -1.201000e+05, -9.000000e+02,
         5.250000e+04, -2.860000e+04, -1.520000e+04, -1.030000e+04,
         6.483000e+05,  1.902000e+05, -3.690000e+04, -1.300000e+03,
         0.000000e+00,  2.000000e+02, -9.000000e+03,  6.480000e+04,
        -2.300000e+04, -2.770000e+04, -2.770000e+04, -2.770000e+04,
         0.000000e+00,  0.000000e+00,  7.201000e+05,  6.281000e+05,
        -5.800000e+04,  1.070000e+04,  1.172000e+05, -2.120000e+04,
         7.050000e+04,  5.340000e+04,  3.183000e+05, -1.860000e+04,
        -1.278000e+05, -1.278000e+05,  6.810000e+04, -1.980000e+04,
        -6.500000e+03, -6.130000e+04, -1.479000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -4.000000e+02,  1.100000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  5.250000e+04,
        -1.201000e+05,  8.500000e+04, -1.300000e+03, -3.690000e+04,
         1.199000e+05, -4.000000e+02,  2.595000e+05,  7.740000e+04,
        -1.360000e+04,  3.837000e+05,  1.748000e+05,  7.805000e+05,
         7.471000e+05, -4.040000e+04,  9.830000e+04, -1.416000e+05,
        -1.625000e+05, -9.000000e+02, -2.770000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.199000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 2.594000e+05,  7.740000e+04,  9.300000e+04, -1.421000e+05,
         5.830000e+04,  1.091300e+06,  5.726000e+05,  2.532000e+05,
         7.740000e+04,  2.519000e+05,  7.710000e+04,  1.898000e+05,
         1.034000e+05,  6.482000e+05,  0.000000e+00,  1.898000e+05,
        -1.150000e+04,  1.890000e+05,  1.180000e+04,  7.599000e+05,
         0.000000e+00,  1.228000e+06,  9.441000e+05,  9.796000e+05,
         5.925000e+05, -7.880000e+04,  2.561000e+05,  5.761000e+05,
        -4.230000e+04,  2.283300e+06,  1.817200e+06,  2.074400e+06,
         3.242000e+06,  7.686000e+05,  7.688000e+05,  7.718000e+05,
         7.818000e+05,  8.759000e+05,  7.689000e+05,  7.027900e+06,
         6.655000e+06,  6.696700e+06,  8.432000e+05,  7.450000e+05,
         7.604000e+05, -8.440000e+04, -4.130000e+05,  1.052000e+06,
         1.052100e+06,  7.126000e+05,  3.757000e+05,  7.216000e+05,
         7.487000e+05,  1.856900e+06,  1.760300e+06,  6.300000e+04,
         4.920000e+05,  4.500000e+04, -1.560000e+05, -4.118000e+05,
         2.120200e+06,  2.255200e+06,  1.862900e+06,  1.954600e+06,
         6.809000e+05,  3.298000e+05,  3.015000e+05,  9.472000e+05,
        -1.890000e+04,  1.098000e+05,  9.210000e+04, -2.860000e+04,
         1.190000e+05,  3.836000e+05,  3.836000e+05,  3.835000e+05,
         3.836000e+05,  1.972000e+05,  1.972000e+05,  8.467000e+05,
         1.747000e+05,  8.300000e+04, -2.160000e+04,  0.000000e+00,
        -3.634000e+05, -3.464000e+05,  6.294000e+05,  4.912000e+05,
         9.410000e+04,  9.410000e+04, -1.370000e+04, -1.370000e+04,
        -1.360000e+04,  1.045200e+06,  5.817000e+05,  1.960000e+06,
         1.112000e+06,  6.525000e+05,  3.725000e+05,  2.714000e+05,
        -3.105000e+05,  1.462600e+06,  8.104000e+05,  1.462600e+06,
         8.102000e+05,  2.473000e+06,  3.153300e+06,  3.617500e+06,
         2.750000e+06,  9.611000e+05,  8.643000e+05,  1.071600e+06,
         6.109000e+05,  1.545000e+05,  6.020000e+04,  7.470000e+05,
         1.396700e+06,  1.823000e+05, -1.035000e+05, -6.620000e+04,
         6.388000e+05,  3.011000e+05,  6.996000e+05,  1.378700e+06,
         1.833800e+06,  9.236000e+05,  8.958000e+05,  9.646000e+05,
         1.802300e+06,  1.609100e+06,  1.114100e+06,  6.957000e+05,
         4.012000e+05,  1.152700e+06,  1.130200e+06,  3.145000e+05,
         4.158000e+05,  6.795000e+05,  8.696000e+05,  7.298000e+05,
         3.903000e+05,  4.475000e+05,  4.475000e+05,  1.761000e+05,
         1.139600e+06,  1.622500e+06,  7.459700e+06,  9.810000e+04,
         9.820000e+04, -4.040000e+04, -4.040000e+04,  7.471000e+05,
        -4.040000e+04, -9.695000e+05, -4.040000e+04,  1.199000e+05,
         1.199000e+05,  1.199000e+05,  1.198000e+05,  1.260000e+05,
        -1.417000e+05, -1.416000e+05, -1.416000e+05,  7.008000e+05,
         2.427000e+05,  0.000000e+00, -8.560000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -8.498000e+05, -2.844000e+05, -1.625000e+05,
         2.113500e+06,  9.874000e+05,  9.881000e+05,  1.347800e+06,
         1.347900e+06, -2.150000e+04, -1.201000e+05, -9.000000e+02,
         5.240000e+04, -2.860000e+04, -1.520000e+04, -1.030000e+04,
         6.482000e+05,  1.901000e+05, -3.690000e+04, -1.300000e+03,
         0.000000e+00,  2.000000e+02, -9.000000e+03,  6.480000e+04,
        -2.300000e+04, -2.770000e+04, -2.770000e+04, -2.770000e+04,
         0.000000e+00,  0.000000e+00,  7.200000e+05,  6.280000e+05,
        -5.800000e+04,  1.070000e+04,  1.172000e+05, -2.120000e+04,
         7.050000e+04,  5.380000e+04,  3.185000e+05, -1.840000e+04,
        -1.278000e+05, -1.278000e+05,  6.810000e+04, -1.980000e+04,
        -6.500000e+03, -6.130000e+04, -1.478000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02,  1.100000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  5.240000e+04,
        -1.201000e+05,  8.500000e+04, -1.300000e+03, -3.690000e+04,
         1.199000e+05,  1.000000e+02,  2.594000e+05,  7.740000e+04,
        -1.370000e+04,  3.836000e+05,  1.747000e+05,  7.805000e+05,
         7.471000e+05, -4.040000e+04,  9.820000e+04, -1.416000e+05,
        -1.625000e+05, -9.000000e+02, -2.770000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.199000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-6.700000e+03,  4.360000e+05,  9.230000e+04, -1.092000e+05,
        -5.750000e+04, -8.480000e+04, -7.160000e+04,  1.700000e+03,
         4.359000e+05,  3.400000e+03,  4.355000e+05,  7.280000e+04,
         2.874000e+05,  6.276000e+05,  0.000000e+00,  7.280000e+04,
         1.890000e+04,  7.350000e+04,  3.330000e+04,  2.897000e+05,
         0.000000e+00,  8.420000e+05,  1.565500e+06,  9.961000e+05,
         6.666000e+05,  3.024000e+05,  1.126900e+06,  2.134000e+05,
         5.160000e+04,  2.213700e+06,  1.654400e+06,  2.700100e+06,
         3.388600e+06,  7.797000e+05,  7.808000e+05,  7.866000e+05,
         7.805000e+05,  8.610000e+05,  7.805000e+05,  6.469800e+06,
         7.442200e+06,  6.675200e+06,  7.008000e+05,  9.384000e+05,
         7.521000e+05, -1.670000e+05, -3.435000e+05,  1.123300e+06,
         1.123400e+06,  9.317000e+05,  7.463000e+05,  7.763000e+05,
         7.950000e+05,  1.849200e+06,  2.088400e+06,  1.130200e+06,
         5.003000e+05, -4.020000e+04, -9.250000e+04, -3.419000e+05,
         1.863200e+06,  1.862900e+06,  2.434300e+06,  1.965900e+06,
        -1.891000e+05,  1.997000e+05,  5.600000e+03, -1.886000e+05,
        -3.000000e+03,  1.702000e+05,  1.146000e+05, -5.900000e+04,
         1.313000e+05,  1.417000e+05,  1.417000e+05,  1.417000e+05,
         1.417000e+05,  5.884000e+05,  5.885000e+05,  7.006000e+05,
         8.620000e+04,  3.085000e+05, -2.220000e+04,  0.000000e+00,
        -2.159000e+05, -3.357000e+05,  6.404000e+05,  5.535000e+05,
         1.086000e+05,  1.086000e+05,  1.670000e+04,  1.680000e+04,
         1.680000e+04,  5.359000e+05,  1.651800e+06,  1.649900e+06,
         6.320000e+05,  3.184000e+05,  9.874000e+05, -1.569000e+05,
         6.297000e+05,  6.466000e+05,  2.210300e+06,  6.466000e+05,
         2.211700e+06,  1.771900e+06,  2.502700e+06,  3.062200e+06,
         3.450100e+06,  8.507000e+05,  1.089700e+06,  4.293300e+06,
         6.730000e+05,  1.153000e+05,  3.567000e+05,  7.566000e+05,
         1.423100e+06, -2.002000e+05,  4.988000e+05, -4.620000e+04,
         3.574000e+05, -1.041000e+05,  3.606000e+05,  6.841000e+05,
         1.240700e+06,  1.276000e+05,  1.880200e+06,  9.409000e+05,
         1.548900e+06,  2.027400e+06,  1.221900e+06,  3.629000e+05,
         1.075900e+06,  9.211000e+05,  1.241200e+06, -1.182000e+05,
         1.034800e+06,  3.770000e+05,  9.116000e+05,  8.072000e+05,
         6.156000e+05,  5.770000e+04,  5.780000e+04,  7.296000e+05,
         2.247000e+06,  1.050900e+06,  1.319300e+06,  1.286000e+05,
         1.287000e+05,  4.440000e+04,  4.440000e+04,  7.959000e+05,
         4.410000e+04, -8.443000e+05,  4.440000e+04,  1.525000e+05,
         1.525000e+05,  1.525000e+05,  1.523000e+05,  1.438000e+05,
        -1.628000e+05, -1.627000e+05, -1.627000e+05,  5.712000e+05,
         1.620000e+04,  0.000000e+00, -9.630000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -9.768000e+05, -2.558000e+05, -1.056000e+05,
         2.263100e+06,  1.100100e+06,  1.099400e+06,  1.556200e+06,
         1.555900e+06, -2.400000e+04, -1.218000e+05, -2.120000e+04,
        -5.640000e+04,  1.512000e+05,  1.027000e+05, -8.300000e+03,
         6.276000e+05,  7.270000e+04,  2.422000e+05,  1.400000e+03,
         0.000000e+00, -1.700000e+03, -4.480000e+04, -9.110000e+04,
         1.344000e+05, -3.450000e+04, -3.460000e+04, -3.460000e+04,
         0.000000e+00,  0.000000e+00,  5.498000e+05,  7.891000e+05,
         3.928000e+05,  5.540000e+04, -1.474000e+05,  1.243000e+05,
        -7.720000e+04, -5.820000e+04,  3.074000e+05,  1.207000e+05,
        -1.246000e+05, -1.246000e+05, -6.990000e+04,  1.494000e+05,
        -9.700000e+03, -1.940000e+05,  2.490000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.000000e+02,  1.600000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -5.640000e+04,
        -1.218000e+05,  8.230000e+04,  1.400000e+03,  2.422000e+05,
         1.525000e+05, -3.000000e+02, -6.700000e+03,  4.360000e+05,
         1.680000e+04,  1.417000e+05,  8.620000e+04,  7.804000e+05,
         7.959000e+05,  4.440000e+04,  1.287000e+05, -1.627000e+05,
        -1.056000e+05, -2.120000e+04, -3.460000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.525000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 9.000000e+03,  9.730000e+04,  1.048500e+06, -1.020000e+05,
        -4.630000e+04, -2.610000e+04, -4.420000e+04,  1.170000e+04,
         9.730000e+04,  1.220000e+04,  9.700000e+04,  7.700000e+04,
         1.189000e+05,  6.427000e+05,  0.000000e+00,  7.700000e+04,
         1.920000e+04,  7.680000e+04,  1.380000e+04,  3.092000e+05,
         0.000000e+00,  8.846000e+05,  1.004700e+06,  6.691100e+06,
         6.795000e+05,  1.180000e+04,  3.181000e+05,  2.408000e+05,
         5.330000e+04,  2.238000e+06,  1.663700e+06,  2.297900e+06,
         3.498800e+06,  7.862000e+05,  7.865000e+05,  7.898000e+05,
         7.994000e+05,  8.805000e+05,  7.862000e+05,  6.607500e+06,
         6.774000e+06,  1.941640e+07,  7.242000e+05,  7.610000e+05,
         3.926500e+06, -1.487000e+05, -3.267000e+05,  1.128700e+06,
         1.128700e+06,  7.907000e+05,  4.554000e+05,  2.683200e+06,
         7.966000e+05,  1.875600e+06,  1.913800e+06,  2.237000e+05,
         5.251000e+05, -2.840000e+04, -8.470000e+04, -3.291000e+05,
         1.954900e+06,  1.954600e+06,  1.965900e+06,  1.188450e+07,
        -1.690000e+05,  2.194000e+05,  1.610000e+04, -1.946000e+05,
        -1.950000e+04,  1.626000e+05,  1.084000e+05, -6.760000e+04,
         1.102000e+05,  1.577000e+05,  1.577000e+05,  1.577000e+05,
         1.577000e+05,  2.404000e+05,  2.404000e+05,  7.294000e+05,
         9.180000e+04,  1.350000e+05, -1.900000e+04,  0.000000e+00,
        -3.594000e+05, -3.398000e+05,  6.546000e+05,  5.390000e+05,
         5.363000e+05,  5.363000e+05,  1.740000e+04,  1.740000e+04,
         1.740000e+04,  5.642000e+05,  7.734000e+05,  1.696600e+06,
         6.707000e+05,  3.428000e+05,  4.652000e+05, -1.052000e+05,
        -2.136000e+05,  6.958000e+05,  9.851000e+05,  6.958000e+05,
         9.841000e+05,  1.922600e+06,  2.636900e+06,  3.209500e+06,
         2.771200e+06,  8.654000e+05,  9.034000e+05,  1.321700e+06,
         6.791000e+05,  1.156000e+05,  1.560000e+05,  7.668000e+05,
         1.439500e+06, -1.517000e+05, -3.460000e+04,  9.455100e+06,
         4.120000e+05, -8.580000e+04,  3.850000e+05,  7.602000e+05,
         1.323900e+06,  1.965000e+05,  9.513000e+05,  1.677140e+07,
         1.587600e+06,  1.664000e+06,  1.200000e+06,  3.807000e+05,
         4.909000e+05,  9.448000e+05,  1.217300e+06, -6.760000e+04,
         5.034000e+05,  3.784000e+05,  9.085000e+05,  8.089000e+05,
         4.709000e+05,  8.320000e+04,  8.320000e+04,  2.169000e+05,
         1.314000e+06,  1.123000e+06,  1.683500e+06,  1.238000e+05,
         1.240000e+05,  3.360000e+04,  3.370000e+04,  7.958000e+05,
         3.340000e+04, -8.622000e+05,  3.370000e+04,  1.431000e+05,
         1.431000e+05,  1.431000e+05,  1.430000e+05,  1.415000e+05,
        -1.618000e+05, -1.617000e+05, -1.617000e+05,  5.813000e+05,
         1.610000e+04,  0.000000e+00, -9.310000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -9.705000e+05, -2.582000e+05, -1.123000e+05,
         2.265300e+06,  1.081800e+06,  1.081800e+06,  1.510400e+06,
         1.510100e+06, -1.930000e+04, -1.135000e+05, -3.290000e+04,
        -6.150000e+04, -2.100000e+04, -1.610000e+04,  1.957000e+05,
         6.427000e+05,  7.730000e+04, -3.950000e+04,  1.100000e+03,
         0.000000e+00,  2.000000e+02,  1.489700e+06, -9.480000e+04,
        -5.670000e+04, -3.260000e+04, -3.270000e+04, -3.270000e+04,
         0.000000e+00,  0.000000e+00,  5.793000e+05,  6.214000e+05,
        -6.180000e+04, -3.420000e+04, -1.562000e+05, -5.240000e+04,
        -6.240000e+04, -6.220000e+04,  3.151000e+05, -1.980000e+04,
        -1.221000e+05, -1.221000e+05, -6.580000e+04, -2.420000e+04,
         2.052000e+05, -1.885000e+05, -1.464000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.000000e+02, -2.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -6.150000e+04,
        -1.135000e+05,  8.430000e+04,  1.100000e+03, -3.950000e+04,
         1.431000e+05, -3.000000e+02,  9.000000e+03,  9.730000e+04,
         1.740000e+04,  1.577000e+05,  9.180000e+04,  7.980000e+05,
         7.958000e+05,  3.370000e+04,  1.240000e+05, -1.617000e+05,
        -1.123000e+05, -3.290000e+04, -3.270000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.431000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 8.745000e+05, -7.400000e+03,  2.400000e+04, -1.164000e+05,
         3.778000e+05,  3.939500e+06,  2.192400e+06,  8.540000e+05,
        -7.400000e+03,  8.499000e+05, -7.400000e+03,  4.285000e+05,
         3.200000e+03, -6.680000e+04,  0.000000e+00,  4.285000e+05,
        -6.250000e+04,  4.275000e+05,  1.000000e+02,  1.711500e+06,
         0.000000e+00,  1.210100e+06, -9.690000e+04, -6.300000e+04,
        -2.559000e+05, -1.889000e+05, -2.660000e+04,  1.268100e+06,
        -1.991000e+05,  4.199000e+05,  9.168000e+05, -4.514000e+05,
        -6.681000e+05, -7.840000e+04, -7.840000e+04, -7.900000e+04,
        -7.890000e+04, -8.950000e+04, -7.740000e+04,  1.065800e+06,
        -6.810000e+05, -6.318000e+05,  3.632000e+05, -7.540000e+04,
        -6.120000e+04,  2.612000e+05, -2.878000e+05, -2.378000e+05,
        -2.378000e+05, -2.033000e+05, -1.694000e+05, -1.911000e+05,
        -1.396000e+05,  9.000000e+02, -4.363000e+05, -2.637000e+05,
        -1.809000e+05,  3.131000e+05, -1.804000e+05, -2.896000e+05,
         6.798000e+05,  6.809000e+05, -1.891000e+05, -1.690000e+05,
         3.117600e+06,  4.521000e+05,  1.055600e+06,  4.053100e+06,
        -1.006000e+05, -7.170000e+04, -5.500000e+03, -3.210000e+04,
        -4.950000e+04,  8.537000e+05,  8.537000e+05,  8.536000e+05,
         8.537000e+05, -1.880000e+04, -1.880000e+04,  3.560000e+05,
         3.661000e+05, -7.300000e+04, -1.710000e+04,  0.000000e+00,
         1.670000e+04,  1.230000e+04, -1.298000e+05, -8.280000e+04,
         5.100000e+03,  5.100000e+03, -6.380000e+04, -6.380000e+04,
        -6.380000e+04,  1.999000e+06, -1.846000e+05,  1.001500e+06,
         1.541900e+06,  1.231000e+06, -7.490000e+04,  1.251200e+06,
        -7.300000e+03,  2.973400e+06, -8.030000e+04,  2.973500e+06,
        -7.620000e+04,  1.982300e+06,  1.458100e+06,  9.614000e+05,
        -2.854000e+05,  3.492000e+05, -8.820000e+04, -1.023000e+05,
        -3.047000e+05,  1.880000e+05, -2.476000e+05, -9.520000e+04,
        -2.076000e+05,  1.075100e+06, -2.316000e+05, -1.981000e+05,
         5.824000e+05,  1.314400e+06,  1.260800e+06,  2.103100e+06,
         1.604800e+06,  2.601500e+06, -8.320000e+04, -1.880000e+04,
         7.098000e+05, -1.647000e+05, -1.102000e+05,  1.265300e+06,
        -5.040000e+04,  7.730000e+05, -1.120000e+05,  1.281400e+06,
        -3.860000e+04,  1.244400e+06, -8.580000e+04, -2.035000e+05,
        -1.690000e+05,  1.285800e+06,  1.285900e+06, -1.470000e+04,
        -2.285000e+05,  1.957800e+06,  2.082210e+07, -2.950000e+04,
        -2.960000e+04, -2.384000e+05, -2.386000e+05, -1.417000e+05,
        -2.375000e+05, -3.872000e+05, -2.386000e+05, -1.140000e+04,
        -1.140000e+04, -1.140000e+04, -1.140000e+04,  4.900000e+03,
         1.500000e+03,  1.500000e+03,  1.500000e+03,  3.250000e+05,
         8.199000e+05,  0.000000e+00, -1.280000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  9.000000e+03, -2.054000e+05, -2.219000e+05,
        -4.797000e+05, -1.625000e+05, -1.604000e+05, -1.926000e+05,
        -1.916000e+05, -1.710000e+04, -4.550000e+04, -3.800000e+04,
         3.919000e+05, -1.820000e+04,  9.000000e+02, -3.900000e+03,
        -6.680000e+04,  4.282000e+05,  2.200000e+03, -7.600000e+03,
         0.000000e+00,  0.000000e+00, -2.030000e+04,  3.826000e+05,
        -3.630000e+04,  1.700000e+03,  1.800000e+03,  1.800000e+03,
         0.000000e+00,  0.000000e+00,  3.716000e+05, -6.570000e+04,
         3.500000e+03,  1.435000e+05,  7.743000e+05, -3.360000e+04,
         4.303000e+05,  4.417000e+05, -3.230000e+04,  1.600000e+03,
        -5.450000e+04, -5.460000e+04,  4.267000e+05, -1.000000e+03,
         2.200000e+03,  3.693000e+05, -5.600000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+03, -1.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  3.919000e+05,
        -4.550000e+04, -8.800000e+03, -7.600000e+03,  2.200000e+03,
        -1.140000e+04,  1.000000e+03,  8.745000e+05, -7.400000e+03,
        -6.380000e+04,  8.537000e+05,  3.661000e+05, -7.880000e+04,
        -1.417000e+05, -2.386000e+05, -2.960000e+04,  1.500000e+03,
        -2.219000e+05, -3.800000e+04,  1.800000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.140000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 2.033000e+05,  7.740000e+04,  9.300000e+04, -1.390000e+04,
         9.420000e+04,  8.284000e+05,  4.217000e+05,  1.960000e+05,
         7.740000e+04,  1.945000e+05,  7.720000e+04,  1.654000e+05,
         1.069000e+05, -1.452000e+05,  0.000000e+00,  1.654000e+05,
         4.430000e+04,  1.584000e+05,  1.190000e+04,  6.416000e+05,
         0.000000e+00,  3.246000e+05,  1.278000e+05,  1.594000e+05,
        -9.500000e+03,  1.113000e+05,  2.461000e+05,  4.709000e+05,
         1.334000e+05,  5.071000e+05,  8.094000e+05,  3.751000e+05,
         6.150000e+04, -4.230000e+04, -4.210000e+04, -4.240000e+04,
        -4.120000e+04, -1.296000e+05, -4.180000e+04, -3.205000e+05,
        -5.816000e+05, -5.407000e+05,  9.200000e+03, -5.460000e+04,
        -4.580000e+04,  7.970000e+04, -8.620000e+04, -2.350000e+04,
        -2.350000e+04,  3.720000e+04,  9.770000e+04,  4.690000e+04,
         4.100000e+03,  7.710000e+04,  1.250000e+04,  3.159000e+05,
        -1.579000e+05,  1.391000e+05,  3.080000e+04, -8.480000e+04,
         3.295000e+05,  3.298000e+05,  1.997000e+05,  2.194000e+05,
         4.521000e+05,  8.206000e+06,  1.438000e+05,  1.469060e+07,
         4.210000e+04,  1.505000e+05,  8.030000e+04, -2.550000e+04,
         1.000000e+05,  3.134000e+05,  3.134000e+05,  3.134000e+05,
         3.157000e+05,  1.804000e+05,  1.804000e+05,  1.090000e+04,
         1.995000e+05,  1.351000e+05, -1.080000e+04,  0.000000e+00,
         5.010000e+04,  6.190000e+04, -9.990000e+04,  1.053000e+05,
         8.640000e+04,  8.640000e+04,  4.480000e+04,  4.470000e+04,
         4.480000e+04,  9.736000e+05,  6.440000e+05,  3.732000e+05,
         3.404000e+05,  5.525000e+05,  3.523000e+05,  2.330000e+05,
         4.759000e+05,  1.200500e+06,  7.348000e+05,  1.200500e+06,
         7.345000e+05,  5.936000e+05, -1.723000e+05, -4.753000e+05,
        -4.371000e+05,  1.152000e+05,  5.060000e+04,  1.016200e+06,
        -1.738000e+05,  1.279000e+05,  6.230000e+04, -5.270000e+04,
        -1.414000e+05,  1.309000e+05, -6.660000e+04, -3.420000e+04,
        -1.707000e+05,  2.323000e+05,  5.806000e+05,  4.220000e+05,
         1.212000e+05,  7.229000e+05,  9.900000e+04,  1.468000e+05,
         1.274000e+05, -1.800000e+03,  2.637000e+05,  5.741000e+05,
         3.827000e+05,  2.721000e+05,  2.667000e+05,  2.546000e+05,
         3.738000e+05,  5.376000e+05,  5.800000e+04,  4.880000e+04,
         1.094000e+05,  3.626000e+05,  3.625000e+05,  1.682000e+05,
         4.857000e+05,  8.087000e+05,  5.975200e+06,  9.200000e+04,
         9.220000e+04, -2.900000e+04, -2.910000e+04,  3.600000e+03,
        -2.880000e+04, -1.190000e+05, -2.910000e+04,  1.029000e+05,
         1.029000e+05,  1.029000e+05,  1.030000e+05,  1.214000e+05,
        -1.148000e+05, -1.147000e+05, -1.148000e+05, -1.321000e+05,
         1.770000e+05,  0.000000e+00, -7.670000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -6.889000e+05, -2.431000e+05, -1.361000e+05,
        -4.700000e+04,  2.100000e+05,  2.105000e+05,  5.198000e+05,
         5.201000e+05, -1.040000e+04, -5.140000e+04, -2.900000e+03,
         1.350000e+04, -3.090000e+04, -9.100000e+03, -1.100000e+04,
        -1.452000e+05,  1.644000e+05, -2.280000e+04, -9.000000e+02,
         0.000000e+00,  1.000000e+02, -3.300000e+03,  3.830000e+04,
        -1.460000e+04, -2.410000e+04, -2.410000e+04, -2.410000e+04,
         0.000000e+00,  0.000000e+00, -9.640000e+04, -1.572000e+05,
        -3.490000e+04,  9.100000e+03,  5.180000e+04, -1.350000e+04,
         4.900000e+04,  1.510000e+04, -7.370000e+04, -1.120000e+04,
        -5.770000e+04, -5.770000e+04,  4.270000e+04, -1.190000e+04,
        -4.900000e+03, -1.640000e+04, -6.980000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  3.000000e+02,  5.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.350000e+04,
        -5.140000e+04, -1.900000e+04, -9.000000e+02, -2.280000e+04,
         1.029000e+05,  3.000000e+02,  2.033000e+05,  7.740000e+04,
         4.470000e+04,  3.134000e+05,  1.995000e+05, -4.130000e+04,
         3.600000e+03, -2.910000e+04,  9.220000e+04, -1.148000e+05,
        -1.361000e+05, -2.900000e+03, -2.410000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.029000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 3.190000e+05,  2.150000e+04,  3.340000e+04, -3.840000e+04,
         1.398000e+05,  1.411600e+06,  7.740000e+05,  3.103000e+05,
         2.150000e+04,  3.086000e+05,  2.150000e+04,  1.728000e+05,
         3.070000e+04, -6.410000e+04,  0.000000e+00,  1.728000e+05,
        -4.300000e+03,  1.722000e+05,  3.400000e+03,  6.918000e+05,
         0.000000e+00,  4.556000e+05,  1.070000e+04,  2.820000e+04,
        -7.800000e+04, -2.140000e+04,  6.750000e+04,  5.176000e+05,
        -1.760000e+04,  2.789000e+05,  5.176000e+05, -1.790000e+04,
        -1.770000e+05, -3.600000e+04, -3.600000e+04, -3.620000e+04,
        -3.580000e+04, -6.600000e+04, -3.560000e+04,  2.154000e+05,
        -3.784000e+05, -3.545000e+05,  1.095000e+05, -3.890000e+04,
        -3.300000e+04,  1.012000e+05, -1.108000e+05, -7.700000e+04,
        -7.700000e+04, -4.830000e+04, -1.980000e+04, -4.240000e+04,
        -3.970000e+04,  2.410000e+04, -1.242000e+05,  1.930000e+04,
        -1.014000e+05,  1.346000e+05, -4.350000e+04, -1.109000e+05,
         3.011000e+05,  3.015000e+05,  5.600000e+03,  1.610000e+04,
         1.055600e+06,  1.438000e+05,  2.791500e+06,  1.251800e+06,
        -1.680000e+04,  2.510000e+04,  2.280000e+04, -1.760000e+04,
         1.590000e+04,  3.472000e+05,  3.472000e+05,  3.472000e+05,
         3.480000e+05,  4.970000e+04,  4.970000e+04,  1.082000e+05,
         1.685000e+05,  1.980000e+04, -8.300000e+03,  0.000000e+00,
         2.030000e+04,  2.260000e+04, -6.870000e+04,  8.000000e+03,
         2.700000e+04,  2.700000e+04, -5.000000e+03, -5.000000e+03,
        -5.000000e+03,  8.859000e+05,  1.426000e+05,  4.092000e+05,
         5.564000e+05,  5.315000e+05,  8.590000e+04,  4.394000e+05,
         1.437000e+05,  1.242700e+06,  2.014000e+05,  1.242700e+06,
         2.024000e+05,  7.653000e+05,  3.762000e+05,  1.374000e+05,
        -2.179000e+05,  1.380000e+05, -1.030000e+04,  2.810000e+05,
        -1.428000e+05,  9.450000e+04, -5.370000e+04, -4.410000e+04,
        -1.043000e+05,  3.564000e+05, -8.850000e+04, -7.100000e+04,
         1.190000e+05,  4.563000e+05,  5.493000e+05,  7.475000e+05,
         5.089000e+05,  9.860000e+05,  5.700000e+03,  3.510000e+04,
         2.479000e+05, -4.880000e+04,  4.830000e+04,  5.482000e+05,
         1.030000e+05,  3.109000e+05,  4.870000e+04,  4.552000e+05,
         1.030000e+05,  5.321000e+05, -7.500000e+03, -4.480000e+04,
        -1.610000e+04,  4.884000e+05,  4.884000e+05,  4.720000e+04,
         8.160000e+04,  8.233000e+05,  7.947900e+06,  1.950000e+04,
         1.960000e+04, -7.900000e+04, -7.910000e+04, -4.050000e+04,
        -7.870000e+04, -1.503000e+05, -7.910000e+04,  2.810000e+04,
         2.810000e+04,  2.810000e+04,  2.820000e+04,  3.570000e+04,
        -3.530000e+04, -3.520000e+04, -3.520000e+04,  5.870000e+04,
         2.956000e+05,  0.000000e+00, -2.560000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.115000e+05, -1.355000e+05, -1.073000e+05,
        -1.552000e+05,  1.660000e+04,  1.740000e+04,  1.026000e+05,
         1.030000e+05, -8.200000e+03, -2.940000e+04, -1.230000e+04,
         1.228000e+05, -1.250000e+04, -2.500000e+03, -4.100000e+03,
        -6.410000e+04,  1.728000e+05, -6.300000e+03, -2.500000e+03,
         0.000000e+00,  0.000000e+00, -7.700000e+03,  1.247000e+05,
        -1.530000e+04, -6.900000e+03, -6.800000e+03, -6.800000e+03,
         0.000000e+00,  0.000000e+00,  7.970000e+04, -6.740000e+04,
        -9.600000e+03,  4.490000e+04,  2.474000e+05, -1.410000e+04,
         1.415000e+05,  1.355000e+05, -3.210000e+04, -3.000000e+03,
        -3.370000e+04, -3.370000e+04,  1.391000e+05, -3.900000e+03,
        -1.000000e+03,  1.042000e+05, -3.780000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  4.000000e+02, -3.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.228000e+05,
        -2.940000e+04, -8.400000e+03, -2.500000e+03, -6.300000e+03,
         2.810000e+04,  4.000000e+02,  3.190000e+05,  2.150000e+04,
        -5.000000e+03,  3.472000e+05,  1.685000e+05, -3.580000e+04,
        -4.050000e+04, -7.910000e+04,  1.960000e+04, -3.520000e+04,
        -1.073000e+05, -1.230000e+04, -6.800000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.810000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.143800e+06,  9.200000e+03, -1.300000e+03, -1.481000e+05,
         4.971000e+05,  5.162900e+06,  2.875300e+06,  1.104600e+06,
         9.200000e+03,  1.096400e+06,  9.300000e+03,  4.805000e+05,
        -4.790000e+04, -1.204000e+05,  0.000000e+00,  4.805000e+05,
        -5.490000e+04,  5.263000e+05, -3.600000e+03,  2.111000e+06,
         0.000000e+00,  1.616700e+06, -8.870000e+04, -9.530000e+04,
        -3.205000e+05, -2.083000e+05,  2.640000e+04,  1.729300e+06,
        -2.162000e+05,  6.598000e+05,  1.360900e+06, -4.782000e+05,
        -8.157000e+05, -1.098000e+05, -1.099000e+05, -1.101000e+05,
        -1.092000e+05, -1.449000e+05, -1.095000e+05,  1.269700e+06,
        -1.004400e+06, -1.012900e+06,  4.577000e+05, -1.093000e+05,
        -1.130000e+05,  3.491000e+05, -3.785000e+05, -3.020000e+05,
        -3.020000e+05, -2.445000e+05, -1.879000e+05, -2.452000e+05,
        -1.750000e+05,  2.360000e+04, -5.441000e+05, -2.564000e+05,
        -2.644000e+05,  4.272000e+05, -2.170000e+05, -3.815000e+05,
         9.467000e+05,  9.472000e+05, -1.886000e+05, -1.946000e+05,
         4.053100e+06,  1.469060e+07,  1.251800e+06,  4.762560e+07,
        -1.192000e+05, -4.990000e+04,  8.200000e+03, -5.610000e+04,
        -4.310000e+04,  1.159100e+06,  1.159100e+06,  1.159000e+06,
         1.163000e+06,  1.970000e+04,  1.980000e+04,  4.580000e+05,
         5.056000e+05, -6.240000e+04, -2.460000e+04,  0.000000e+00,
         3.400000e+04,  3.080000e+04, -1.870000e+05, -7.630000e+04,
         4.200000e+03,  4.200000e+03, -6.880000e+04, -6.880000e+04,
        -6.880000e+04,  2.760600e+06, -8.400000e+04,  1.366200e+06,
         1.996300e+06,  1.698200e+06, -7.400000e+03,  1.640200e+06,
         1.095000e+05,  4.065300e+06,  7.790000e+04,  4.065300e+06,
         8.040000e+04,  2.663500e+06,  1.805200e+06,  1.103800e+06,
        -4.716000e+05,  4.697000e+05, -9.790000e+04,  1.131000e+05,
        -4.288000e+05,  2.702000e+05, -2.980000e+05, -1.336000e+05,
        -2.959000e+05,  1.392700e+06, -3.105000e+05, -3.193000e+05,
         6.938000e+05,  1.679800e+06,  1.754300e+06,  2.749100e+06,
         2.049700e+06,  3.448400e+06, -8.920000e+04, -1.042000e+05,
         9.288000e+05, -2.065000e+05, -7.640000e+04,  1.747400e+06,
         4.640000e+04,  1.048100e+06, -7.770000e+04,  1.691400e+06,
         4.080000e+04,  1.741100e+06, -9.660000e+04, -2.423000e+05,
        -1.847000e+05,  1.690600e+06,  1.690900e+06,  2.010000e+04,
        -1.747000e+05,  2.663600e+06,  2.760000e+07, -1.350000e+04,
        -1.350000e+04, -3.088000e+05, -3.090000e+05, -1.755000e+05,
        -3.085000e+05, -5.184000e+05, -3.090000e+05,  1.060000e+04,
         1.060000e+04,  1.060000e+04,  1.040000e+04, -3.930000e+04,
        -4.020000e+04, -4.010000e+04, -4.010000e+04,  4.702000e+05,
         1.086800e+06,  0.000000e+00,  8.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.409000e+05, -3.356000e+05, -3.224000e+05,
        -6.089000e+05, -1.535000e+05, -1.526000e+05, -1.198000e+05,
        -1.193000e+05, -2.360000e+04, -7.700000e+04, -5.370000e+04,
         5.859000e+05,  2.920000e+04, -1.000000e+03,  2.200000e+03,
        -1.204000e+05,  4.913000e+05, -3.100000e+03, -9.900000e+03,
         0.000000e+00,  1.000000e+02, -4.520000e+04,  5.032000e+05,
        -5.360000e+04, -2.500000e+03, -2.500000e+03, -2.500000e+03,
         0.000000e+00,  0.000000e+00,  4.447000e+05, -1.206000e+05,
        -3.600000e+03,  1.820000e+05,  1.088800e+06, -4.950000e+04,
         5.555000e+05,  5.876000e+05, -5.950000e+04, -1.300000e+03,
        -8.220000e+04, -8.230000e+04,  5.644000e+05, -2.400000e+03,
        -1.900000e+03,  4.773000e+05, -8.530000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  5.000000e+02, -1.800000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  5.859000e+05,
        -7.700000e+04, -1.580000e+04, -9.900000e+03, -3.100000e+03,
         1.060000e+04,  5.000000e+02,  1.143800e+06,  9.200000e+03,
        -6.880000e+04,  1.159100e+06,  5.056000e+05, -1.093000e+05,
        -1.755000e+05, -3.090000e+05, -1.350000e+04, -4.010000e+04,
        -3.224000e+05, -5.370000e+04, -2.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.060000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-1.760000e+04, -5.700000e+03,  1.290000e+04,  3.287000e+05,
         1.553000e+05, -9.200000e+04, -5.690000e+04, -1.510000e+04,
        -5.700000e+03, -1.460000e+04, -5.700000e+03,  1.020000e+04,
         1.420000e+04, -7.680000e+04,  0.000000e+00,  1.020000e+04,
         1.834000e+05,  1.030000e+04,  1.700000e+03,  4.120000e+04,
         0.000000e+00, -4.510000e+04, -1.930000e+04, -4.600000e+04,
         5.188000e+05,  5.153000e+05,  1.250000e+04,  3.210000e+04,
         5.542000e+05,  7.130000e+04,  1.572000e+05,  8.420000e+04,
         3.226700e+06, -3.940000e+04, -3.970000e+04, -3.870000e+04,
        -3.960000e+04, -7.740000e+04, -3.970000e+04, -5.199000e+05,
        -4.857000e+05, -5.211000e+05, -6.650000e+04, -5.790000e+04,
        -6.680000e+04,  4.840000e+05,  8.030000e+05,  3.431000e+05,
         3.431000e+05,  3.465000e+05,  3.463000e+05,  3.305000e+05,
         1.716000e+05,  6.776000e+05,  6.863000e+05,  7.033000e+05,
         2.752000e+05,  3.401000e+05,  5.137000e+05,  8.039000e+05,
        -1.890000e+04, -1.890000e+04, -3.000000e+03, -1.950000e+04,
        -1.006000e+05,  4.210000e+04, -1.680000e+04, -1.192000e+05,
         7.904000e+05,  2.192000e+05,  2.880000e+04,  4.762000e+05,
         5.226000e+05,  2.040000e+04,  2.040000e+04,  2.040000e+04,
         2.040000e+04,  3.190000e+04,  3.190000e+04, -6.510000e+04,
         1.970000e+05,  2.028000e+05, -7.600000e+03,  0.000000e+00,
         5.300000e+03,  3.080000e+04,  1.218000e+05,  1.461000e+05,
         2.230000e+04,  2.230000e+04,  1.846000e+05,  1.846000e+05,
         1.846000e+05,  4.631000e+05,  4.909000e+05,  3.092000e+05,
         2.781000e+05,  5.300000e+04,  6.800000e+04, -6.430000e+04,
         1.040000e+05,  1.089000e+05,  1.492000e+05,  1.089000e+05,
         1.492000e+05, -6.300000e+04, -3.355000e+05, -4.211000e+05,
        -3.106000e+05, -2.950000e+04, -2.080000e+04,  8.010000e+04,
        -6.110000e+04,  2.650000e+04,  3.550000e+04, -4.790000e+04,
         9.550000e+04, -6.820000e+04, -4.870000e+04, -6.920000e+04,
        -1.556000e+05, -5.440000e+04,  6.850000e+04, -9.970000e+04,
        -1.853000e+05, -1.410000e+04, -5.650000e+04, -1.013000e+05,
        -9.660000e+04, -7.930000e+04,  7.280000e+04,  6.820000e+04,
         9.420000e+04, -1.930000e+04,  7.370000e+04, -5.340000e+04,
         8.540000e+04,  5.810000e+04, -2.500000e+03,  3.673000e+05,
         3.707000e+05, -9.000000e+03, -9.000000e+03,  1.020000e+04,
         9.390000e+04,  5.070000e+04, -4.390000e+04,  2.890000e+04,
         2.890000e+04,  1.510000e+04,  1.510000e+04,  1.786000e+05,
         1.510000e+04,  3.240000e+04,  1.510000e+04,  3.760000e+04,
         3.760000e+04,  3.760000e+04,  3.760000e+04,  3.530000e+04,
        -3.840000e+04, -3.840000e+04, -3.840000e+04, -9.800000e+04,
        -1.090000e+04,  0.000000e+00, -2.490000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.304000e+05, -6.060000e+04, -2.270000e+04,
         6.802000e+05,  2.516000e+05,  2.491000e+05,  3.619000e+05,
         3.619000e+05, -8.700000e+03,  1.366000e+05,  4.850000e+05,
        -2.120000e+04, -1.900000e+04, -1.510000e+04, -3.800000e+03,
        -7.680000e+04,  1.030000e+04, -3.890000e+04,  4.000000e+02,
         0.000000e+00,  1.000000e+02,  3.699000e+05,  4.535000e+05,
         4.655000e+05, -8.700000e+03, -8.700000e+03, -8.700000e+03,
         0.000000e+00,  0.000000e+00, -1.021000e+05, -9.510000e+04,
        -5.790000e+04, -2.060000e+04,  4.321000e+05,  4.304000e+05,
        -2.530000e+04, -2.170000e+04, -3.880000e+04, -1.940000e+04,
         1.451000e+05,  1.451000e+05, -2.910000e+04, -2.000000e+04,
        -5.500000e+03,  1.156000e+05,  1.251000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.200000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.120000e+04,
         1.366000e+05, -1.010000e+04,  4.000000e+02, -3.890000e+04,
         3.760000e+04,  0.000000e+00, -1.760000e+04, -5.700000e+03,
         1.846000e+05,  2.040000e+04,  1.970000e+05, -3.960000e+04,
         1.786000e+05,  1.510000e+04,  2.890000e+04, -3.840000e+04,
        -2.270000e+04,  4.850000e+05, -8.700000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         3.760000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.520000e+04,  7.500000e+04,  6.640000e+04,  3.294000e+05,
         1.801000e+05,  2.700000e+04, -3.500000e+03,  8.100000e+03,
         7.500000e+04,  8.900000e+03,  7.480000e+04,  4.840000e+04,
         8.070000e+04, -1.585000e+05,  0.000000e+00,  4.840000e+04,
         7.942000e+05,  4.870000e+04,  9.400000e+03,  1.695000e+05,
         0.000000e+00,  1.790000e+04,  1.085000e+05,  9.710000e+04,
         5.290000e+05,  6.712000e+05,  2.381000e+05,  1.771000e+05,
         7.007000e+05,  3.399000e+05,  5.573000e+05,  4.003000e+05,
         3.312000e+06, -5.560000e+04, -5.560000e+04, -5.550000e+04,
        -5.570000e+04, -1.467000e+05, -5.560000e+04, -8.313000e+05,
        -7.112000e+05, -7.258000e+05, -9.950000e+04, -7.010000e+04,
        -7.310000e+04,  5.219000e+05,  7.999000e+05,  3.213000e+05,
         3.213000e+05,  3.896000e+05,  4.599000e+05,  3.850000e+05,
         1.724000e+05,  6.796000e+05,  7.093000e+05,  1.051100e+06,
         1.930000e+05,  4.120000e+05,  5.691000e+05,  8.121000e+05,
         1.099000e+05,  1.098000e+05,  1.702000e+05,  1.626000e+05,
        -7.170000e+04,  1.505000e+05,  2.510000e+04, -4.990000e+04,
         2.192000e+05,  2.810800e+06,  7.860000e+04, -2.900000e+04,
         9.850000e+04,  1.176000e+05,  1.176000e+05,  1.176000e+05,
         1.176000e+05,  1.780000e+05,  1.781000e+05, -9.960000e+04,
         2.977000e+05,  3.274000e+05, -1.340000e+04,  0.000000e+00,
         5.290000e+04,  6.620000e+04,  7.050000e+04,  1.870000e+05,
         7.510000e+04,  7.510000e+04,  2.334000e+05,  2.333000e+05,
         2.410000e+05,  8.739000e+05,  1.024900e+06,  4.321000e+05,
         3.331000e+05,  2.518000e+05,  3.419000e+05, -6.900000e+04,
         4.759000e+05,  5.140000e+05,  7.256000e+05,  5.140000e+05,
         7.262000e+05,  8.000000e+04, -6.033000e+05, -8.205000e+05,
        -4.825000e+05,  2.900000e+03,  3.260000e+04,  9.886000e+05,
        -1.349000e+05,  8.250000e+04,  1.127000e+05, -6.960000e+04,
         1.370000e+04, -1.074000e+05, -1.840000e+04, -2.830000e+04,
        -3.249000e+05, -4.190000e+04,  2.787000e+05, -6.980000e+04,
        -2.871000e+05,  1.475000e+05,  7.910000e+04,  6.210000e+04,
        -9.730000e+04, -3.770000e+04,  2.508000e+05,  2.787000e+05,
         3.670000e+05,  6.150000e+04,  2.536000e+05, -4.460000e+04,
         3.701000e+05,  2.801000e+05,  4.440000e+04,  4.019000e+05,
         4.703000e+05,  7.010000e+04,  7.010000e+04,  1.639000e+05,
         4.923000e+05,  3.434000e+05,  1.386100e+06,  8.890000e+04,
         8.900000e+04,  2.380000e+04,  2.380000e+04,  1.717000e+05,
         2.380000e+04,  3.000000e+02,  2.380000e+04,  1.031000e+05,
         1.031000e+05,  1.031000e+05,  1.030000e+05,  8.880000e+04,
        -1.126000e+05, -1.125000e+05, -1.125000e+05, -1.916000e+05,
         1.610000e+04,  0.000000e+00, -5.930000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -6.753000e+05, -1.814000e+05, -7.880000e+04,
         6.341000e+05,  3.780000e+05,  3.781000e+05,  6.872000e+05,
         6.871000e+05, -1.410000e+04,  1.398000e+05, -4.600000e+03,
        -3.310000e+04, -4.300000e+03, -1.050000e+04, -5.600000e+03,
        -1.585000e+05,  4.920000e+04, -2.620000e+04,  8.000000e+02,
         0.000000e+00, -3.000000e+02, -1.800000e+04, -4.730000e+04,
        -1.840000e+04, -2.360000e+04, -2.370000e+04, -2.370000e+04,
         0.000000e+00,  0.000000e+00, -2.021000e+05, -1.726000e+05,
        -4.020000e+04, -2.270000e+04, -8.040000e+04, -1.700000e+04,
        -4.290000e+04, -3.380000e+04, -8.050000e+04, -1.310000e+04,
         1.188000e+05,  1.189000e+05, -4.450000e+04, -1.450000e+04,
        -7.200000e+03,  7.700000e+04,  1.047000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02, -8.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -3.310000e+04,
         1.398000e+05, -2.080000e+04,  8.000000e+02, -2.620000e+04,
         1.031000e+05, -1.000000e+02,  1.520000e+04,  7.500000e+04,
         2.333000e+05,  1.176000e+05,  2.977000e+05, -5.560000e+04,
         1.717000e+05,  2.380000e+04,  8.900000e+04, -1.125000e+05,
        -7.880000e+04, -4.600000e+03, -2.370000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.031000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.730000e+04,  3.840000e+04,  3.300000e+04,  4.900000e+03,
         1.110000e+04,  5.570000e+04,  2.120000e+04,  1.860000e+04,
         3.830000e+04,  1.880000e+04,  3.830000e+04,  3.390000e+04,
         4.340000e+04, -6.360000e+04,  0.000000e+00,  3.390000e+04,
         2.780000e+04,  3.400000e+04,  5.000000e+03,  1.353000e+05,
         0.000000e+00,  3.690000e+04,  7.070000e+04,  6.130000e+04,
         1.830000e+04,  7.090000e+04,  1.216000e+05,  1.006000e+05,
         8.240000e+04,  2.032000e+05,  3.004000e+05,  2.255000e+05,
         8.410000e+04, -1.290000e+04, -1.290000e+04, -1.280000e+04,
        -1.310000e+04, -5.430000e+04, -1.290000e+04, -2.610000e+05,
        -2.164000e+05, -2.284000e+05, -2.980000e+04, -1.920000e+04,
        -2.160000e+04,  1.590000e+04, -1.230000e+04,  1.000000e+04,
         1.000000e+04,  3.630000e+04,  6.260000e+04,  3.260000e+04,
         1.440000e+04,  3.470000e+04,  4.550000e+04,  1.771000e+05,
        -5.950000e+04,  3.850000e+04,  3.230000e+04, -1.190000e+04,
         9.210000e+04,  9.210000e+04,  1.146000e+05,  1.084000e+05,
        -5.500000e+03,  8.030000e+04,  2.280000e+04,  8.200000e+03,
         2.880000e+04,  7.860000e+04,  2.538100e+06,  2.488800e+06,
         5.230000e+04,  6.700000e+04,  6.700000e+04,  6.700000e+04,
         6.700000e+04,  8.920000e+04,  8.920000e+04, -3.000000e+04,
         6.120000e+04,  7.200000e+04, -5.200000e+03,  0.000000e+00,
         2.070000e+04,  2.670000e+04, -3.630000e+04,  5.800000e+04,
         3.720000e+04,  3.720000e+04,  2.740000e+04,  2.740000e+04,
         2.740000e+04,  2.733000e+05,  3.285000e+05,  7.870000e+04,
         2.400000e+04,  1.403000e+05,  1.730000e+05, -1.580000e+04,
         2.265000e+05,  2.848000e+05,  3.624000e+05,  2.848000e+05,
         3.629000e+05,  9.090000e+04, -2.202000e+05, -3.172000e+05,
        -1.757000e+05,  2.040000e+04,  3.130000e+04,  5.018000e+05,
        -5.440000e+04,  4.280000e+04,  5.410000e+04, -1.850000e+04,
        -4.920000e+04, -4.240000e+04, -9.300000e+03, -1.800000e+04,
        -1.395000e+05, -3.700000e+03,  1.502000e+05,  3.800000e+03,
        -9.340000e+04,  1.010000e+05,  5.820000e+04,  4.450000e+04,
        -1.000000e+04,  1.180000e+04,  1.380000e+05,  1.507000e+05,
         1.825000e+05,  5.370000e+04,  1.396000e+05, -7.500000e+03,
         1.845000e+05,  1.467000e+05,  3.610000e+04,  4.180000e+04,
         6.810000e+04,  4.920000e+04,  4.920000e+04,  8.280000e+04,
         2.563000e+05,  2.019000e+05,  9.114000e+05,  4.500000e+04,
         4.510000e+04,  9.400000e+03,  9.400000e+03,  1.450000e+04,
         9.400000e+03, -1.910000e+04,  9.400000e+03,  5.080000e+04,
         5.090000e+04,  5.090000e+04,  5.080000e+04,  4.930000e+04,
        -5.220000e+04, -5.210000e+04, -5.210000e+04, -7.670000e+04,
         2.080000e+04,  0.000000e+00, -3.160000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.130000e+05, -9.100000e+04, -4.080000e+04,
         2.140000e+04,  1.161000e+05,  1.160000e+05,  2.684000e+05,
         2.683000e+05, -5.800000e+03, -2.150000e+04,  1.500000e+03,
        -1.300000e+04, -4.700000e+03, -4.500000e+03, -3.200000e+03,
        -6.360000e+04,  3.390000e+04, -1.100000e+04,  3.000000e+02,
         0.000000e+00,  0.000000e+00, -6.200000e+03, -1.680000e+04,
        -4.500000e+03,  2.412500e+06,  2.414500e+06,  2.414500e+06,
         0.000000e+00,  0.000000e+00, -8.010000e+04, -6.970000e+04,
        -1.700000e+04, -8.900000e+03, -2.980000e+04, -4.200000e+03,
        -1.630000e+04, -1.330000e+04, -3.250000e+04, -5.500000e+03,
        -2.200000e+04, -2.200000e+04, -1.830000e+04, -5.700000e+03,
        -3.200000e+03, -4.010000e+04, -2.770000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  4.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.300000e+04,
        -2.150000e+04, -8.300000e+03,  3.000000e+02, -1.100000e+04,
         5.090000e+04,  0.000000e+00,  1.730000e+04,  3.840000e+04,
         2.740000e+04,  6.700000e+04,  6.120000e+04, -1.310000e+04,
         1.450000e+04,  9.400000e+03,  4.510000e+04, -5.210000e+04,
        -4.080000e+04,  1.500000e+03,  2.414500e+06,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         5.080000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-1.310000e+04, -3.910000e+04, -1.940000e+04, -1.630000e+04,
        -1.470000e+04, -5.450000e+04, -2.830000e+04, -1.420000e+04,
        -3.910000e+04, -1.450000e+04, -3.910000e+04, -1.390000e+04,
        -2.600000e+04,  2.150000e+04,  0.000000e+00, -1.390000e+04,
        -1.480000e+04, -1.400000e+04, -3.000000e+03, -5.550000e+04,
         0.000000e+00, -2.000000e+04, -6.740000e+04, -7.840000e+04,
        -2.590000e+04, -6.650000e+04, -1.027000e+05, -4.140000e+04,
        -4.440000e+04, -5.840000e+04, -9.340000e+04, -8.590000e+04,
        -1.613000e+05,  6.900000e+03,  6.900000e+03,  7.000000e+03,
         7.000000e+03,  1.960000e+04,  6.900000e+03,  8.700000e+04,
         2.400000e+04,  9.200000e+03,  7.600000e+03, -8.000000e+03,
        -1.190000e+04, -3.110000e+04, -3.410000e+04, -1.620000e+04,
        -1.620000e+04, -3.610000e+04, -5.630000e+04, -4.340000e+04,
        -1.010000e+04, -4.050000e+04, -5.620000e+04, -1.560000e+05,
         4.900000e+03, -2.940000e+04, -3.110000e+04, -3.400000e+04,
        -2.870000e+04, -2.860000e+04, -5.900000e+04, -6.760000e+04,
        -3.210000e+04, -2.550000e+04, -1.760000e+04, -5.610000e+04,
         4.762000e+05, -2.900000e+04,  2.488800e+06,  3.043100e+06,
         4.837000e+05, -2.750000e+04, -2.750000e+04, -2.750000e+04,
        -2.750000e+04, -5.380000e+04, -5.380000e+04,  7.500000e+03,
        -2.780000e+04, -4.080000e+04,  2.000000e+03,  0.000000e+00,
        -1.860000e+04, -8.700000e+03,  5.700000e+03, -2.170000e+04,
        -1.520000e+04, -1.520000e+04, -1.480000e+04, -1.480000e+04,
        -1.480000e+04, -1.114000e+05, -1.770000e+05, -4.330000e+04,
        -3.430000e+04, -5.180000e+04, -9.090000e+04, -6.600000e+03,
        -1.372000e+05, -1.108000e+05, -2.027000e+05, -1.108000e+05,
        -2.028000e+05, -4.060000e+04,  5.880000e+04,  9.380000e+04,
         4.600000e+03, -6.800000e+03, -2.250000e+04, -3.900000e+05,
         2.100000e+04, -1.430000e+04, -3.010000e+04,  9.000000e+03,
         1.130000e+04,  2.400000e+03, -3.830000e+04, -5.600000e+04,
         3.770000e+04, -1.060000e+04, -5.560000e+04, -1.860000e+04,
         1.650000e+04, -5.370000e+04, -9.710000e+04, -1.159000e+05,
         1.000000e+03, -3.040000e+04, -3.670000e+04, -5.580000e+04,
        -1.026000e+05, -2.050000e+04, -3.710000e+04, -9.600000e+03,
        -9.530000e+04, -6.590000e+04, -7.300000e+03, -2.560000e+04,
        -4.560000e+04, -2.580000e+04, -2.580000e+04, -6.590000e+04,
        -1.472000e+05, -6.870000e+04, -4.589000e+05, -1.240000e+04,
        -1.250000e+04, -5.000000e+02, -5.000000e+02, -1.070000e+04,
        -5.000000e+02,  6.700000e+03, -5.000000e+02, -1.470000e+04,
        -1.460000e+04, -1.460000e+04, -1.470000e+04, -1.360000e+04,
         1.490000e+04,  1.490000e+04,  1.490000e+04,  1.930000e+04,
        -1.610000e+04,  0.000000e+00,  9.000000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  8.970000e+04,  2.850000e+04,  1.400000e+04,
        -3.350000e+04, -3.980000e+04, -3.960000e+04, -8.350000e+04,
        -8.350000e+04,  2.200000e+03, -9.000000e+02,  4.984000e+05,
        -2.200000e+03, -1.350000e+04, -9.000000e+03, -1.700000e+03,
         2.150000e+04, -1.390000e+04, -2.070000e+04,  0.000000e+00,
         0.000000e+00,  1.000000e+02,  3.880000e+05,  4.902000e+05,
         4.825000e+05,  2.427300e+06,  2.429400e+06,  2.429400e+06,
         0.000000e+00,  0.000000e+00,  2.180000e+04,  6.600000e+03,
        -3.450000e+04, -7.000000e+03,  4.879000e+05,  4.462000e+05,
         4.000000e+02, -2.000000e+03,  1.090000e+04, -1.030000e+04,
        -1.400000e+03, -1.400000e+03, -3.900000e+03, -1.370000e+04,
        -1.400000e+03, -5.200000e+03, -1.510000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.200000e+03,
        -9.000000e+02,  2.800000e+03,  0.000000e+00, -2.070000e+04,
        -1.460000e+04,  0.000000e+00, -1.310000e+04, -3.910000e+04,
        -1.480000e+04, -2.750000e+04, -2.780000e+04,  7.000000e+03,
        -1.070000e+04, -5.000000e+02, -1.250000e+04,  1.490000e+04,
         1.400000e+04,  4.984000e+05,  2.429400e+06,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.470000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 9.800000e+03,  2.410000e+04,  3.260000e+04, -8.100000e+03,
         9.000000e+02,  1.620000e+04, -3.400000e+03,  1.230000e+04,
         2.410000e+04,  1.280000e+04,  2.390000e+04,  3.920000e+04,
         4.430000e+04, -8.250000e+04,  0.000000e+00,  3.920000e+04,
         2.970000e+04,  3.940000e+04,  5.200000e+03,  1.563000e+05,
         0.000000e+00,  3.310000e+04,  4.970000e+04,  1.980000e+04,
         1.800000e+03,  4.720000e+04,  9.760000e+04,  1.158000e+05,
         8.830000e+04,  2.737000e+05,  3.948000e+05,  2.885000e+05,
        -4.810000e+04, -1.360000e+04, -1.360000e+04, -1.340000e+04,
        -1.390000e+04, -6.880000e+04, -1.360000e+04, -3.470000e+05,
        -3.254000e+05, -3.647000e+05, -4.340000e+04, -3.880000e+04,
        -4.780000e+04, -7.100000e+03, -5.290000e+04, -9.000000e+02,
        -9.000000e+02,  2.220000e+04,  4.500000e+04,  7.800000e+03,
         1.330000e+04,  1.130000e+04,  1.630000e+04,  1.318000e+05,
        -9.380000e+04,  3.010000e+04,  2.120000e+04, -5.240000e+04,
         1.190000e+05,  1.190000e+05,  1.313000e+05,  1.102000e+05,
        -4.950000e+04,  1.000000e+05,  1.590000e+04, -4.310000e+04,
         5.226000e+05,  9.850000e+04,  5.230000e+04,  4.837000e+05,
         6.022000e+05,  7.710000e+04,  7.710000e+04,  7.710000e+04,
         7.710000e+04,  9.300000e+04,  9.300000e+04, -4.380000e+04,
         6.720000e+04,  7.480000e+04, -6.600000e+03,  0.000000e+00,
         1.510000e+04,  3.480000e+04, -5.440000e+04,  7.340000e+04,
         4.490000e+04,  4.490000e+04,  2.930000e+04,  2.930000e+04,
         2.930000e+04,  3.184000e+05,  3.580000e+05,  7.470000e+04,
        -9.500000e+03,  1.705000e+05,  1.938000e+05, -4.090000e+04,
         2.352000e+05,  3.381000e+05,  3.940000e+05,  3.381000e+05,
         3.946000e+05,  9.650000e+04, -3.109000e+05, -4.317000e+05,
        -2.806000e+05,  2.470000e+04,  2.960000e+04,  4.365000e+05,
        -6.620000e+04,  5.490000e+04,  6.040000e+04, -2.080000e+04,
        -6.930000e+04, -7.450000e+04, -5.190000e+04, -8.780000e+04,
        -1.956000e+05, -2.470000e+04,  1.829000e+05, -2.540000e+04,
        -1.466000e+05,  9.580000e+04, -4.000000e+02, -4.750000e+04,
        -1.970000e+04, -9.600000e+03,  1.911000e+05,  1.838000e+05,
         1.975000e+05,  6.290000e+04,  1.935000e+05, -3.060000e+04,
         2.085000e+05,  1.941000e+05,  5.290000e+04,  4.170000e+04,
         6.480000e+04,  4.600000e+04,  4.600000e+04,  7.050000e+04,
         2.761000e+05,  2.511000e+05,  9.079000e+05,  6.160000e+04,
         6.160000e+04,  1.650000e+04,  1.650000e+04,  1.270000e+04,
         1.650000e+04, -2.230000e+04,  1.650000e+04,  6.900000e+04,
         6.900000e+04,  6.900000e+04,  6.890000e+04,  6.610000e+04,
        -7.040000e+04, -7.040000e+04, -7.040000e+04, -1.049000e+05,
         1.670000e+04,  0.000000e+00, -4.220000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -4.225000e+05, -1.195000e+05, -5.150000e+04,
         1.400000e+03,  1.508000e+05,  1.510000e+05,  3.578000e+05,
         3.578000e+05, -7.400000e+03, -3.610000e+04,  5.005000e+05,
        -2.240000e+04, -1.940000e+04, -1.630000e+04, -6.500000e+03,
        -8.250000e+04,  3.910000e+04, -3.880000e+04,  5.000000e+02,
         0.000000e+00,  2.000000e+02,  3.766000e+05,  4.688000e+05,
         4.748000e+05, -1.570000e+04, -1.570000e+04, -1.570000e+04,
         0.000000e+00,  0.000000e+00, -1.117000e+05, -1.073000e+05,
        -6.240000e+04, -2.250000e+04,  4.463000e+05,  4.391000e+05,
        -2.890000e+04, -2.290000e+04, -4.220000e+04, -1.940000e+04,
        -3.680000e+04, -3.680000e+04, -2.720000e+04, -2.240000e+04,
        -6.800000e+03, -6.380000e+04, -5.920000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  6.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.240000e+04,
        -3.610000e+04, -1.080000e+04,  5.000000e+02, -3.880000e+04,
         6.900000e+04, -1.000000e+02,  9.800000e+03,  2.410000e+04,
         2.930000e+04,  7.710000e+04,  6.720000e+04, -1.390000e+04,
         1.270000e+04,  1.650000e+04,  6.160000e+04, -7.040000e+04,
        -5.150000e+04,  5.005000e+05, -1.570000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         6.900000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 3.037000e+05,  6.470000e+04,  7.710000e+04, -2.910000e+04,
         1.367000e+05,  1.296500e+06,  6.891000e+05,  2.931000e+05,
         6.470000e+04,  2.909000e+05,  6.450000e+04,  1.947000e+05,
         8.320000e+04, -1.335000e+05,  0.000000e+00,  1.947000e+05,
         2.970000e+04,  1.936000e+05,  9.400000e+03,  7.807000e+05,
         0.000000e+00,  4.596000e+05,  9.450000e+04,  1.206000e+05,
        -4.610000e+04,  6.650000e+04,  2.053000e+05,  5.930000e+05,
         8.370000e+04,  4.955000e+05,  8.274000e+05,  2.513000e+05,
        -4.880000e+04, -4.770000e+04, -4.760000e+04, -4.790000e+04,
        -4.680000e+04, -1.236000e+05, -4.780000e+04, -1.117000e+05,
        -5.977000e+05, -5.638000e+05,  6.190000e+04, -5.830000e+04,
        -5.110000e+04,  1.071000e+05, -1.161000e+05, -5.550000e+04,
        -5.550000e+04,  1.100000e+03,  5.750000e+04,  9.400000e+03,
        -1.840000e+04,  6.460000e+04, -5.620000e+04,  2.272000e+05,
        -1.612000e+05,  1.653000e+05, -6.000000e+02, -1.153000e+05,
         3.837000e+05,  3.836000e+05,  1.417000e+05,  1.577000e+05,
         8.537000e+05,  3.134000e+05,  3.472000e+05,  1.159100e+06,
         2.040000e+04,  1.176000e+05,  6.700000e+04, -2.750000e+04,
         7.710000e+04,  3.958000e+05,  3.958000e+05,  3.957000e+05,
         3.958000e+05,  1.506000e+05,  1.505000e+05,  6.370000e+04,
         2.243000e+05,  1.036000e+05, -1.170000e+04,  0.000000e+00,
         4.520000e+04,  5.450000e+04, -1.043000e+05,  7.740000e+04,
         7.180000e+04,  7.180000e+04,  2.850000e+04,  2.850000e+04,
         2.850000e+04,  1.128800e+06,  5.186000e+05,  4.692000e+05,
         5.181000e+05,  6.560000e+05,  2.881000e+05,  3.867000e+05,
         4.035000e+05,  1.470700e+06,  6.124000e+05,  1.470700e+06,
         6.125000e+05,  8.050000e+05,  7.420000e+04, -2.582000e+05,
        -4.148000e+05,  1.498000e+05,  2.900000e+04,  8.460000e+05,
        -1.942000e+05,  1.369000e+05,  1.520000e+04, -5.950000e+04,
        -1.518000e+05,  2.734000e+05, -9.220000e+04, -6.560000e+04,
        -5.770000e+04,  3.915000e+05,  6.855000e+05,  6.732000e+05,
         3.426000e+05,  1.003700e+06,  6.900000e+04,  1.082000e+05,
         2.138000e+05, -2.790000e+04,  2.072000e+05,  6.795000e+05,
         3.192000e+05,  3.481000e+05,  2.095000e+05,  4.104000e+05,
         3.114000e+05,  6.484000e+05,  3.530000e+04,  1.070000e+04,
         6.740000e+04,  4.990000e+05,  4.990000e+05,  1.397000e+05,
         3.753000e+05,  9.795000e+05,  8.190200e+06,  7.400000e+04,
         7.410000e+04, -6.060000e+04, -6.070000e+04, -1.800000e+04,
        -6.080000e+04, -1.595000e+05, -6.070000e+04,  8.580000e+04,
         8.580000e+04,  8.580000e+04,  8.580000e+04,  9.610000e+04,
        -9.890000e+04, -9.880000e+04, -9.880000e+04, -5.370000e+04,
         2.749000e+05,  0.000000e+00, -6.260000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -5.931000e+05, -2.394000e+05, -1.501000e+05,
        -1.111000e+05,  1.533000e+05,  1.529000e+05,  4.100000e+05,
         4.098000e+05, -1.180000e+04, -5.130000e+04, -8.700000e+03,
         7.970000e+04, -2.280000e+04, -7.600000e+03, -8.900000e+03,
        -1.335000e+05,  1.950000e+05, -1.910000e+04, -1.900000e+03,
         0.000000e+00,  1.000000e+02, -7.800000e+03,  9.140000e+04,
        -1.830000e+04, -2.020000e+04, -2.010000e+04, -2.010000e+04,
         0.000000e+00,  0.000000e+00, -2.600000e+04, -1.434000e+05,
        -2.910000e+04,  2.920000e+04,  1.710000e+05, -1.690000e+04,
         1.065000e+05,  8.160000e+04, -6.780000e+04, -9.600000e+03,
        -5.720000e+04, -5.720000e+04,  1.022000e+05, -1.010000e+04,
        -4.200000e+03,  4.330000e+04, -6.760000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.000000e+02,  2.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  7.970000e+04,
        -5.130000e+04, -1.750000e+04, -1.900000e+03, -1.910000e+04,
         8.580000e+04, -2.000000e+02,  3.037000e+05,  6.470000e+04,
         2.850000e+04,  3.958000e+05,  2.243000e+05, -4.690000e+04,
        -1.800000e+04, -6.070000e+04,  7.410000e+04, -9.880000e+04,
        -1.501000e+05, -8.700000e+03, -2.010000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         8.580000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 3.037000e+05,  6.470000e+04,  7.710000e+04, -2.910000e+04,
         1.367000e+05,  1.296500e+06,  6.891000e+05,  2.931000e+05,
         6.470000e+04,  2.909000e+05,  6.450000e+04,  1.947000e+05,
         8.320000e+04, -1.335000e+05,  0.000000e+00,  1.947000e+05,
         2.970000e+04,  1.936000e+05,  9.400000e+03,  7.807000e+05,
         0.000000e+00,  4.596000e+05,  9.450000e+04,  1.206000e+05,
        -4.610000e+04,  6.650000e+04,  2.053000e+05,  5.930000e+05,
         8.370000e+04,  4.955000e+05,  8.274000e+05,  2.513000e+05,
        -4.880000e+04, -4.770000e+04, -4.760000e+04, -4.790000e+04,
        -4.680000e+04, -1.236000e+05, -4.780000e+04, -1.117000e+05,
        -5.977000e+05, -5.638000e+05,  6.190000e+04, -5.830000e+04,
        -5.110000e+04,  1.071000e+05, -1.161000e+05, -5.550000e+04,
        -5.550000e+04,  1.100000e+03,  5.750000e+04,  9.400000e+03,
        -1.840000e+04,  6.460000e+04, -5.620000e+04,  2.272000e+05,
        -1.612000e+05,  1.653000e+05, -6.000000e+02, -1.153000e+05,
         3.837000e+05,  3.836000e+05,  1.417000e+05,  1.577000e+05,
         8.537000e+05,  3.134000e+05,  3.472000e+05,  1.159100e+06,
         2.040000e+04,  1.176000e+05,  6.700000e+04, -2.750000e+04,
         7.710000e+04,  3.958000e+05,  3.972000e+05,  3.957000e+05,
         3.958000e+05,  1.506000e+05,  1.505000e+05,  6.370000e+04,
         2.243000e+05,  1.036000e+05, -1.170000e+04,  0.000000e+00,
         4.520000e+04,  5.450000e+04, -1.043000e+05,  7.740000e+04,
         7.180000e+04,  7.180000e+04,  2.850000e+04,  2.850000e+04,
         2.850000e+04,  1.128800e+06,  5.186000e+05,  4.692000e+05,
         5.181000e+05,  6.560000e+05,  2.881000e+05,  3.867000e+05,
         4.035000e+05,  1.470700e+06,  6.124000e+05,  1.470700e+06,
         6.125000e+05,  8.050000e+05,  7.420000e+04, -2.582000e+05,
        -4.148000e+05,  1.498000e+05,  2.900000e+04,  8.460000e+05,
        -1.942000e+05,  1.369000e+05,  1.520000e+04, -5.950000e+04,
        -1.518000e+05,  2.734000e+05, -9.220000e+04, -6.560000e+04,
        -5.770000e+04,  3.915000e+05,  6.855000e+05,  6.732000e+05,
         3.426000e+05,  1.003700e+06,  6.900000e+04,  1.082000e+05,
         2.138000e+05, -2.790000e+04,  2.072000e+05,  6.795000e+05,
         3.192000e+05,  3.481000e+05,  2.095000e+05,  4.104000e+05,
         3.114000e+05,  6.484000e+05,  3.530000e+04,  1.070000e+04,
         6.740000e+04,  4.990000e+05,  4.990000e+05,  1.397000e+05,
         3.753000e+05,  9.795000e+05,  8.190200e+06,  7.400000e+04,
         7.410000e+04, -6.060000e+04, -6.070000e+04, -1.800000e+04,
        -6.080000e+04, -1.595000e+05, -6.070000e+04,  8.580000e+04,
         8.580000e+04,  8.580000e+04,  8.580000e+04,  9.610000e+04,
        -9.890000e+04, -9.880000e+04, -9.880000e+04, -5.370000e+04,
         2.749000e+05,  0.000000e+00, -6.260000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -5.931000e+05, -2.394000e+05, -1.501000e+05,
        -1.111000e+05,  1.533000e+05,  1.529000e+05,  4.100000e+05,
         4.098000e+05, -1.180000e+04, -5.130000e+04, -8.700000e+03,
         7.970000e+04, -2.280000e+04, -7.600000e+03, -8.900000e+03,
        -1.335000e+05,  1.950000e+05, -1.910000e+04, -1.900000e+03,
         0.000000e+00,  1.000000e+02, -7.800000e+03,  9.140000e+04,
        -1.830000e+04, -2.020000e+04, -2.010000e+04, -2.010000e+04,
         0.000000e+00,  0.000000e+00, -2.600000e+04, -1.434000e+05,
        -2.910000e+04,  2.920000e+04,  1.710000e+05, -1.690000e+04,
         1.065000e+05,  8.160000e+04, -6.780000e+04, -9.600000e+03,
        -5.720000e+04, -5.720000e+04,  1.022000e+05, -1.010000e+04,
        -4.200000e+03,  4.330000e+04, -6.760000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.000000e+02,  2.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  7.970000e+04,
        -5.130000e+04, -1.750000e+04, -1.900000e+03, -1.910000e+04,
         8.580000e+04, -2.000000e+02,  3.037000e+05,  6.470000e+04,
         2.850000e+04,  3.958000e+05,  2.243000e+05, -4.690000e+04,
        -1.800000e+04, -6.070000e+04,  7.410000e+04, -9.880000e+04,
        -1.501000e+05, -8.700000e+03, -2.010000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         8.580000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 3.037000e+05,  6.470000e+04,  7.710000e+04, -2.910000e+04,
         1.367000e+05,  1.296400e+06,  6.891000e+05,  2.931000e+05,
         6.470000e+04,  2.909000e+05,  6.450000e+04,  1.947000e+05,
         8.320000e+04, -1.335000e+05,  0.000000e+00,  1.947000e+05,
         2.970000e+04,  1.936000e+05,  9.400000e+03,  7.806000e+05,
         0.000000e+00,  4.595000e+05,  9.450000e+04,  1.205000e+05,
        -4.610000e+04,  6.650000e+04,  2.053000e+05,  5.930000e+05,
         8.370000e+04,  4.955000e+05,  8.273000e+05,  2.513000e+05,
        -4.880000e+04, -4.770000e+04, -4.760000e+04, -4.790000e+04,
        -4.680000e+04, -1.236000e+05, -4.780000e+04, -1.117000e+05,
        -5.976000e+05, -5.637000e+05,  6.190000e+04, -5.820000e+04,
        -5.110000e+04,  1.071000e+05, -1.161000e+05, -5.550000e+04,
        -5.550000e+04,  1.100000e+03,  5.750000e+04,  9.400000e+03,
        -1.840000e+04,  6.460000e+04, -5.620000e+04,  2.272000e+05,
        -1.612000e+05,  1.653000e+05, -6.000000e+02, -1.153000e+05,
         3.837000e+05,  3.835000e+05,  1.417000e+05,  1.577000e+05,
         8.536000e+05,  3.134000e+05,  3.472000e+05,  1.159000e+06,
         2.040000e+04,  1.176000e+05,  6.700000e+04, -2.750000e+04,
         7.710000e+04,  3.957000e+05,  3.957000e+05,  3.965000e+05,
         3.957000e+05,  1.505000e+05,  1.505000e+05,  6.370000e+04,
         2.243000e+05,  1.036000e+05, -1.170000e+04,  0.000000e+00,
         4.520000e+04,  5.450000e+04, -1.043000e+05,  7.740000e+04,
         7.180000e+04,  7.180000e+04,  2.850000e+04,  2.850000e+04,
         2.850000e+04,  1.128700e+06,  5.186000e+05,  4.691000e+05,
         5.180000e+05,  6.560000e+05,  2.880000e+05,  3.867000e+05,
         4.034000e+05,  1.470600e+06,  6.123000e+05,  1.470600e+06,
         6.125000e+05,  8.049000e+05,  7.430000e+04, -2.582000e+05,
        -4.148000e+05,  1.498000e+05,  2.900000e+04,  8.459000e+05,
        -1.942000e+05,  1.369000e+05,  1.520000e+04, -5.950000e+04,
        -1.517000e+05,  2.733000e+05, -9.210000e+04, -6.560000e+04,
        -5.770000e+04,  3.915000e+05,  6.855000e+05,  6.731000e+05,
         3.426000e+05,  1.003600e+06,  6.900000e+04,  1.082000e+05,
         2.138000e+05, -2.790000e+04,  2.072000e+05,  6.795000e+05,
         3.191000e+05,  3.481000e+05,  2.094000e+05,  4.104000e+05,
         3.114000e+05,  6.483000e+05,  3.530000e+04,  1.070000e+04,
         6.740000e+04,  4.990000e+05,  4.990000e+05,  1.397000e+05,
         3.753000e+05,  9.794000e+05,  8.192200e+06,  7.400000e+04,
         7.410000e+04, -6.060000e+04, -6.070000e+04, -1.800000e+04,
        -6.080000e+04, -1.595000e+05, -6.070000e+04,  8.580000e+04,
         8.580000e+04,  8.580000e+04,  8.580000e+04,  9.610000e+04,
        -9.880000e+04, -9.880000e+04, -9.880000e+04, -5.370000e+04,
         2.748000e+05,  0.000000e+00, -6.250000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -5.930000e+05, -2.393000e+05, -1.501000e+05,
        -1.111000e+05,  1.533000e+05,  1.529000e+05,  4.099000e+05,
         4.098000e+05, -1.180000e+04, -5.130000e+04, -8.700000e+03,
         7.970000e+04, -2.280000e+04, -7.600000e+03, -8.900000e+03,
        -1.335000e+05,  1.950000e+05, -1.910000e+04, -1.900000e+03,
         0.000000e+00,  1.000000e+02, -7.800000e+03,  9.140000e+04,
        -1.830000e+04, -2.010000e+04, -2.010000e+04, -2.010000e+04,
         0.000000e+00,  0.000000e+00, -2.600000e+04, -1.434000e+05,
        -2.910000e+04,  2.920000e+04,  1.710000e+05, -1.690000e+04,
         1.065000e+05,  8.160000e+04, -6.780000e+04, -9.600000e+03,
        -5.720000e+04, -5.720000e+04,  1.022000e+05, -1.010000e+04,
        -4.200000e+03,  4.330000e+04, -6.760000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.000000e+02,  2.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  7.970000e+04,
        -5.130000e+04, -1.750000e+04, -1.900000e+03, -1.910000e+04,
         8.580000e+04, -2.000000e+02,  3.037000e+05,  6.470000e+04,
         2.850000e+04,  3.957000e+05,  2.243000e+05, -4.690000e+04,
        -1.800000e+04, -6.070000e+04,  7.410000e+04, -9.880000e+04,
        -1.501000e+05, -8.700000e+03, -2.010000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         8.580000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 3.037000e+05,  6.470000e+04,  7.710000e+04, -2.910000e+04,
         1.367000e+05,  1.296500e+06,  6.891000e+05,  2.932000e+05,
         6.470000e+04,  2.911000e+05,  6.450000e+04,  1.948000e+05,
         8.330000e+04, -1.335000e+05,  0.000000e+00,  1.948000e+05,
         2.960000e+04,  1.938000e+05,  9.500000e+03,  7.823000e+05,
         0.000000e+00,  4.596000e+05,  9.450000e+04,  1.205000e+05,
        -4.610000e+04,  6.650000e+04,  2.053000e+05,  5.930000e+05,
         8.370000e+04,  4.955000e+05,  8.274000e+05,  2.513000e+05,
        -4.880000e+04, -4.770000e+04, -4.760000e+04, -4.790000e+04,
        -4.680000e+04, -1.236000e+05, -4.780000e+04, -1.118000e+05,
        -5.977000e+05, -5.638000e+05,  6.190000e+04, -5.830000e+04,
        -5.110000e+04,  1.071000e+05, -1.161000e+05, -5.550000e+04,
        -5.550000e+04,  1.100000e+03,  5.750000e+04,  9.400000e+03,
        -1.840000e+04,  6.460000e+04, -5.620000e+04,  2.272000e+05,
        -1.612000e+05,  1.653000e+05, -6.000000e+02, -1.153000e+05,
         3.837000e+05,  3.836000e+05,  1.417000e+05,  1.577000e+05,
         8.537000e+05,  3.157000e+05,  3.480000e+05,  1.163000e+06,
         2.040000e+04,  1.176000e+05,  6.700000e+04, -2.750000e+04,
         7.710000e+04,  3.958000e+05,  3.958000e+05,  3.957000e+05,
         3.980000e+05,  1.506000e+05,  1.505000e+05,  6.370000e+04,
         2.243000e+05,  1.036000e+05, -1.170000e+04,  0.000000e+00,
         4.520000e+04,  5.450000e+04, -1.043000e+05,  7.740000e+04,
         7.180000e+04,  7.180000e+04,  2.850000e+04,  2.850000e+04,
         2.850000e+04,  1.128800e+06,  5.187000e+05,  4.692000e+05,
         5.181000e+05,  6.560000e+05,  2.881000e+05,  3.867000e+05,
         4.035000e+05,  1.470600e+06,  6.124000e+05,  1.470600e+06,
         6.125000e+05,  8.050000e+05,  7.420000e+04, -2.582000e+05,
        -4.148000e+05,  1.498000e+05,  2.900000e+04,  8.460000e+05,
        -1.942000e+05,  1.369000e+05,  1.520000e+04, -5.950000e+04,
        -1.518000e+05,  2.734000e+05, -9.220000e+04, -6.560000e+04,
        -5.770000e+04,  3.915000e+05,  6.855000e+05,  6.732000e+05,
         3.426000e+05,  1.003700e+06,  6.900000e+04,  1.082000e+05,
         2.138000e+05, -2.790000e+04,  2.072000e+05,  6.795000e+05,
         3.191000e+05,  3.481000e+05,  2.095000e+05,  4.104000e+05,
         3.114000e+05,  6.484000e+05,  3.530000e+04,  1.070000e+04,
         6.740000e+04,  4.990000e+05,  4.990000e+05,  1.397000e+05,
         3.754000e+05,  9.795000e+05,  8.190300e+06,  7.400000e+04,
         7.410000e+04, -6.060000e+04, -6.070000e+04, -1.800000e+04,
        -6.080000e+04, -1.595000e+05, -6.070000e+04,  8.580000e+04,
         8.580000e+04,  8.580000e+04,  8.580000e+04,  9.620000e+04,
        -9.880000e+04, -9.880000e+04, -9.880000e+04, -5.370000e+04,
         2.750000e+05,  0.000000e+00, -6.260000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -5.930000e+05, -2.394000e+05, -1.501000e+05,
        -1.111000e+05,  1.533000e+05,  1.529000e+05,  4.100000e+05,
         4.098000e+05, -1.180000e+04, -5.130000e+04, -8.700000e+03,
         7.970000e+04, -2.280000e+04, -7.600000e+03, -8.900000e+03,
        -1.335000e+05,  1.951000e+05, -1.910000e+04, -1.900000e+03,
         0.000000e+00,  1.000000e+02, -7.800000e+03,  9.140000e+04,
        -1.830000e+04, -2.020000e+04, -2.010000e+04, -2.010000e+04,
         0.000000e+00,  0.000000e+00, -2.600000e+04, -1.434000e+05,
        -2.910000e+04,  2.920000e+04,  1.710000e+05, -1.690000e+04,
         1.065000e+05,  8.160000e+04, -6.780000e+04, -9.600000e+03,
        -5.720000e+04, -5.720000e+04,  1.022000e+05, -1.010000e+04,
        -4.200000e+03,  4.330000e+04, -6.760000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.000000e+02,  2.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  7.970000e+04,
        -5.130000e+04, -1.750000e+04, -1.900000e+03, -1.910000e+04,
         8.580000e+04, -2.000000e+02,  3.037000e+05,  6.470000e+04,
         2.850000e+04,  3.958000e+05,  2.243000e+05, -4.690000e+04,
        -1.800000e+04, -6.070000e+04,  7.410000e+04, -9.880000e+04,
        -1.501000e+05, -8.700000e+03, -2.010000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         8.580000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 3.560000e+04,  4.440000e+05,  7.530000e+04,  6.200000e+03,
         2.100000e+04,  1.126000e+05,  4.140000e+04,  3.990000e+04,
         4.440000e+05,  4.080000e+04,  4.429000e+05,  7.650000e+04,
         2.768000e+05, -1.534000e+05,  0.000000e+00,  7.650000e+04,
         6.050000e+04,  7.690000e+04,  3.200000e+04,  3.051000e+05,
         0.000000e+00,  7.230000e+04,  6.497000e+05,  1.369000e+05,
         2.250000e+04,  4.545000e+05,  1.091700e+06,  2.259000e+05,
         1.806000e+05,  4.570000e+05,  6.858000e+05,  8.626000e+05,
         6.700000e+04, -3.570000e+04, -3.560000e+04, -3.500000e+04,
        -3.610000e+04, -1.331000e+05, -3.580000e+04, -6.674000e+05,
         1.015000e+05, -5.813000e+05, -7.720000e+04,  1.137000e+05,
        -5.570000e+04,  2.740000e+04, -4.050000e+04, -3.000000e+02,
        -3.000000e+02,  2.179000e+05,  4.347000e+05,  6.060000e+04,
         2.020000e+04,  3.850000e+04,  2.301000e+05,  1.321100e+06,
        -1.505000e+05,  8.080000e+04,  6.620000e+04, -4.000000e+04,
         1.973000e+05,  1.972000e+05,  5.884000e+05,  2.404000e+05,
        -1.880000e+04,  1.804000e+05,  4.970000e+04,  1.970000e+04,
         3.190000e+04,  1.780000e+05,  8.920000e+04, -5.380000e+04,
         9.300000e+04,  1.506000e+05,  1.506000e+05,  1.505000e+05,
         1.506000e+05,  6.194000e+05,  5.629000e+05, -7.800000e+04,
         1.339000e+05,  3.390000e+05, -1.180000e+04,  0.000000e+00,
         2.038000e+05,  6.510000e+04, -9.480000e+04,  1.231000e+05,
         8.570000e+04,  8.570000e+04,  6.000000e+04,  6.000000e+04,
         6.000000e+04,  6.104000e+05,  1.638900e+06,  1.501000e+05,
         2.770000e+04,  3.186000e+05,  9.346000e+05, -4.340000e+04,
         1.329800e+06,  6.436000e+05,  2.086900e+06,  6.436000e+05,
         2.087400e+06,  1.869000e+05, -5.438000e+05, -7.721000e+05,
         2.718000e+05,  3.910000e+04,  2.306000e+05,  4.192800e+06,
        -1.306000e+05,  9.820000e+04,  2.907000e+05, -4.850000e+04,
        -1.335000e+05, -1.044000e+05,  5.066000e+05, -3.990000e+04,
        -3.332000e+05, -1.430000e+04,  3.407000e+05, -8.900000e+03,
        -2.379000e+05,  2.201000e+05,  9.490000e+05,  9.870000e+04,
        -3.980000e+04,  3.433000e+05,  3.147000e+05,  3.423000e+05,
         9.149000e+05,  1.139000e+05,  3.186000e+05, -2.480000e+04,
         9.612000e+05,  4.051000e+05,  7.830000e+04,  7.960000e+04,
         2.978000e+05,  1.066000e+05,  1.066000e+05,  7.256000e+05,
         1.445600e+06,  4.878000e+05,  2.004300e+06,  1.047000e+05,
         1.049000e+05,  2.320000e+04,  2.320000e+04,  1.890000e+04,
         2.310000e+04, -3.590000e+04,  2.320000e+04,  1.180000e+05,
         1.180000e+05,  1.180000e+05,  1.179000e+05,  1.132000e+05,
        -1.208000e+05, -1.208000e+05, -1.208000e+05, -1.824000e+05,
         4.730000e+04,  0.000000e+00, -7.250000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -7.249000e+05, -2.093000e+05, -9.300000e+04,
         3.600000e+03,  2.551000e+05,  2.555000e+05,  6.092000e+05,
         6.091000e+05, -1.320000e+04, -5.230000e+04, -2.490000e+04,
        -2.900000e+04,  1.677000e+05,  1.120000e+05, -6.800000e+03,
        -1.534000e+05,  7.640000e+04,  2.781000e+05,  7.000000e+02,
         0.000000e+00, -2.200000e+03, -3.930000e+04, -6.110000e+04,
         1.224000e+05, -2.680000e+04, -2.690000e+04, -2.690000e+04,
         0.000000e+00,  0.000000e+00, -1.940000e+05, -3.200000e+03,
         4.283000e+05,  7.240000e+04, -9.000000e+04,  1.132000e+05,
        -4.030000e+04, -2.980000e+04, -7.830000e+04,  1.387000e+05,
        -5.320000e+04, -5.320000e+04, -3.630000e+04,  1.490000e+05,
        -7.400000e+03, -8.930000e+04,  9.600000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  8.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.900000e+04,
        -5.230000e+04, -2.010000e+04,  7.000000e+02,  2.781000e+05,
         1.180000e+05, -1.000000e+02,  3.560000e+04,  4.440000e+05,
         6.000000e+04,  1.506000e+05,  1.339000e+05, -3.600000e+04,
         1.890000e+04,  2.320000e+04,  1.049000e+05, -1.208000e+05,
        -9.300000e+04, -2.490000e+04, -2.690000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.180000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 3.560000e+04,  4.440000e+05,  7.530000e+04,  6.200000e+03,
         2.100000e+04,  1.126000e+05,  4.140000e+04,  3.990000e+04,
         4.439000e+05,  4.070000e+04,  4.428000e+05,  7.640000e+04,
         2.766000e+05, -1.534000e+05,  0.000000e+00,  7.640000e+04,
         6.050000e+04,  7.680000e+04,  3.200000e+04,  3.048000e+05,
         0.000000e+00,  7.230000e+04,  6.497000e+05,  1.369000e+05,
         2.250000e+04,  4.545000e+05,  1.091600e+06,  2.259000e+05,
         1.806000e+05,  4.570000e+05,  6.858000e+05,  8.626000e+05,
         6.700000e+04, -3.570000e+04, -3.560000e+04, -3.500000e+04,
        -3.610000e+04, -1.331000e+05, -3.580000e+04, -6.674000e+05,
         1.015000e+05, -5.813000e+05, -7.720000e+04,  1.137000e+05,
        -5.570000e+04,  2.740000e+04, -4.050000e+04, -3.000000e+02,
        -3.000000e+02,  2.179000e+05,  4.347000e+05,  6.060000e+04,
         2.020000e+04,  3.850000e+04,  2.301000e+05,  1.321100e+06,
        -1.505000e+05,  8.080000e+04,  6.620000e+04, -4.000000e+04,
         1.973000e+05,  1.972000e+05,  5.885000e+05,  2.404000e+05,
        -1.880000e+04,  1.804000e+05,  4.970000e+04,  1.980000e+04,
         3.190000e+04,  1.781000e+05,  8.920000e+04, -5.380000e+04,
         9.300000e+04,  1.505000e+05,  1.505000e+05,  1.505000e+05,
         1.505000e+05,  5.629000e+05,  5.629000e+05, -7.800000e+04,
         1.339000e+05,  3.390000e+05, -1.180000e+04,  0.000000e+00,
         2.038000e+05,  6.510000e+04, -9.480000e+04,  1.231000e+05,
         8.570000e+04,  8.570000e+04,  6.000000e+04,  6.000000e+04,
         6.000000e+04,  6.104000e+05,  1.638900e+06,  1.501000e+05,
         2.760000e+04,  3.185000e+05,  9.346000e+05, -4.350000e+04,
         1.329800e+06,  6.436000e+05,  2.086900e+06,  6.436000e+05,
         2.087400e+06,  1.868000e+05, -5.438000e+05, -7.722000e+05,
         2.718000e+05,  3.910000e+04,  2.306000e+05,  4.192900e+06,
        -1.306000e+05,  9.820000e+04,  2.907000e+05, -4.850000e+04,
        -1.335000e+05, -1.045000e+05,  5.066000e+05, -3.990000e+04,
        -3.332000e+05, -1.430000e+04,  3.407000e+05, -8.900000e+03,
        -2.380000e+05,  2.201000e+05,  9.490000e+05,  9.870000e+04,
        -3.980000e+04,  3.433000e+05,  3.147000e+05,  3.423000e+05,
         9.149000e+05,  1.138000e+05,  3.186000e+05, -2.480000e+04,
         9.612000e+05,  4.051000e+05,  7.830000e+04,  7.960000e+04,
         2.978000e+05,  1.065000e+05,  1.066000e+05,  7.256000e+05,
         1.445600e+06,  4.877000e+05,  2.003900e+06,  1.047000e+05,
         1.048000e+05,  2.320000e+04,  2.320000e+04,  1.890000e+04,
         2.310000e+04, -3.590000e+04,  2.320000e+04,  1.180000e+05,
         1.180000e+05,  1.180000e+05,  1.179000e+05,  1.130000e+05,
        -1.209000e+05, -1.208000e+05, -1.208000e+05, -1.824000e+05,
         4.730000e+04,  0.000000e+00, -7.240000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -7.250000e+05, -2.093000e+05, -9.300000e+04,
         3.700000e+03,  2.552000e+05,  2.555000e+05,  6.093000e+05,
         6.092000e+05, -1.320000e+04, -5.230000e+04, -2.490000e+04,
        -2.900000e+04,  1.677000e+05,  1.120000e+05, -6.800000e+03,
        -1.534000e+05,  7.630000e+04,  2.781000e+05,  7.000000e+02,
         0.000000e+00, -2.200000e+03, -3.930000e+04, -6.110000e+04,
         1.224000e+05, -2.680000e+04, -2.690000e+04, -2.690000e+04,
         0.000000e+00,  0.000000e+00, -1.940000e+05, -3.200000e+03,
         4.283000e+05,  7.240000e+04, -9.000000e+04,  1.132000e+05,
        -4.030000e+04, -2.980000e+04, -7.830000e+04,  1.387000e+05,
        -5.320000e+04, -5.320000e+04, -3.630000e+04,  1.490000e+05,
        -7.400000e+03, -8.930000e+04,  9.600000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  8.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.900000e+04,
        -5.230000e+04, -2.010000e+04,  7.000000e+02,  2.781000e+05,
         1.180000e+05, -1.000000e+02,  3.560000e+04,  4.440000e+05,
         6.000000e+04,  1.505000e+05,  1.339000e+05, -3.600000e+04,
         1.890000e+04,  2.320000e+04,  1.048000e+05, -1.208000e+05,
        -9.300000e+04, -2.490000e+04, -2.690000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.180000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 9.920000e+04, -3.740000e+04, -1.730000e+04, -8.090000e+04,
         9.000000e+03,  4.491000e+05,  2.507000e+05,  9.260000e+04,
        -3.740000e+04,  9.130000e+04, -3.730000e+04,  2.980000e+04,
        -3.350000e+04,  4.500000e+05,  0.000000e+00,  2.980000e+04,
        -6.000000e+04,  2.890000e+04, -4.000000e+03,  1.201000e+05,
         0.000000e+00,  5.512000e+05,  3.316000e+05,  3.752000e+05,
         2.632000e+05, -1.778000e+05, -1.130000e+05,  9.770000e+04,
        -1.824000e+05,  7.253000e+05,  3.022000e+05,  5.822000e+05,
         1.478600e+06,  4.090000e+05,  4.093000e+05,  4.102000e+05,
         4.085000e+05,  5.417000e+05,  4.092000e+05,  4.038600e+06,
         3.749600e+06,  3.803900e+06,  4.819000e+05,  4.097000e+05,
         4.233000e+05, -7.230000e+04, -1.832000e+05,  5.088000e+05,
         5.088000e+05,  2.865000e+05,  6.540000e+04,  3.005000e+05,
         3.465000e+05,  8.657000e+05,  7.930000e+05, -3.185000e+05,
         3.655000e+05, -5.140000e+04, -1.414000e+05, -1.834000e+05,
         8.468000e+05,  8.467000e+05,  7.006000e+05,  7.294000e+05,
         3.560000e+05,  1.090000e+04,  1.082000e+05,  4.580000e+05,
        -6.510000e+04, -9.960000e+04, -3.000000e+04,  7.500000e+03,
        -4.380000e+04,  6.370000e+04,  6.370000e+04,  6.370000e+04,
         6.370000e+04, -7.800000e+04, -7.800000e+04,  4.917000e+05,
        -3.030000e+04, -9.950000e+04, -2.000000e+02,  0.000000e+00,
        -2.222000e+05, -2.261000e+05,  3.875000e+05,  1.318000e+05,
        -2.580000e+04, -2.580000e+04, -6.040000e+04, -6.040000e+04,
        -6.040000e+04, -4.800000e+03, -3.569000e+05,  8.384000e+05,
         5.198000e+05,  5.570000e+04, -1.556000e+05,  1.739000e+05,
        -6.032000e+05,  1.830000e+05, -3.130000e+05,  1.830000e+05,
        -3.139000e+05,  1.024800e+06,  2.021900e+06,  2.447700e+06,
         1.736600e+06,  4.413000e+05,  3.686000e+05, -4.598000e+05,
         4.104000e+05, -6.400000e+03, -7.900000e+04,  4.099000e+05,
         7.964000e+05,  1.774000e+05, -3.480000e+04,  1.400000e+03,
         5.944000e+05,  1.625000e+05,  5.990000e+04,  6.899000e+05,
         1.111600e+06,  2.682000e+05,  3.265000e+05,  3.965000e+05,
         9.232000e+05,  7.779000e+05,  2.832000e+05,  5.600000e+04,
        -1.608000e+05,  4.737000e+05,  2.877000e+05,  1.791000e+05,
        -1.578000e+05,  3.480000e+04,  3.624000e+05,  2.843000e+05,
         6.200000e+04,  1.323000e+05,  1.322000e+05, -7.660000e+04,
         6.000000e+04,  4.234000e+05,  2.013500e+06, -3.950000e+04,
        -3.960000e+04, -3.930000e+04, -3.940000e+04,  3.462000e+05,
        -3.950000e+04, -4.474000e+05, -3.940000e+04, -4.070000e+04,
        -4.070000e+04, -4.070000e+04, -4.060000e+04, -3.360000e+04,
         3.100000e+04,  3.100000e+04,  3.100000e+04,  5.012000e+05,
         8.150000e+04,  0.000000e+00,  1.940000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.862000e+05,  3.620000e+04, -1.700000e+03,
         1.017800e+06,  2.648000e+05,  2.648000e+05,  1.426000e+05,
         1.425000e+05,  1.000000e+03, -1.770000e+04, -3.200000e+03,
         5.110000e+04, -6.300000e+03,  1.200000e+03,  8.000000e+02,
         4.500000e+05,  3.010000e+04,  3.200000e+03, -1.300000e+03,
         0.000000e+00,  0.000000e+00,  1.000000e+04,  6.080000e+04,
        -2.200000e+03,  9.000000e+03,  9.100000e+03,  9.100000e+03,
         0.000000e+00,  0.000000e+00,  5.250000e+05,  4.516000e+05,
         4.600000e+03,  2.350000e+04,  1.119000e+05, -2.100000e+03,
         7.310000e+04,  5.220000e+04,  2.233000e+05,  1.600000e+03,
        -2.090000e+04, -2.090000e+04,  6.510000e+04,  9.000000e+02,
         3.200000e+03,  4.290000e+04, -2.030000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02, -2.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  5.110000e+04,
        -1.770000e+04,  5.900000e+04, -1.300000e+03,  3.200000e+03,
        -4.070000e+04, -1.000000e+02,  9.920000e+04, -3.740000e+04,
        -6.040000e+04,  6.370000e+04, -3.030000e+04,  4.086000e+05,
         3.462000e+05, -3.940000e+04, -3.960000e+04,  3.100000e+04,
        -1.700000e+03, -3.200000e+03,  9.100000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -4.070000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.459000e+05,  5.580000e+04,  6.170000e+04,  3.324000e+05,
         2.386000e+05,  6.081000e+05,  3.164000e+05,  1.425000e+05,
         5.580000e+04,  1.417000e+05,  5.570000e+04,  1.120000e+05,
         6.960000e+04, -1.413000e+05,  0.000000e+00,  1.120000e+05,
         2.171000e+05,  1.117000e+05,  8.000000e+03,  4.492000e+05,
         0.000000e+00,  1.943000e+05,  6.120000e+04,  6.990000e+04,
         4.956000e+05,  6.187000e+05,  1.780000e+05,  3.353000e+05,
         6.414000e+05,  3.125000e+05,  5.669000e+05,  2.227000e+05,
         3.297300e+06, -6.310000e+04, -6.310000e+04, -6.330000e+04,
        -6.280000e+04, -1.374000e+05, -6.320000e+04, -5.503000e+05,
        -7.281000e+05, -7.162000e+05, -2.960000e+04, -7.420000e+04,
        -7.100000e+04,  5.676000e+05,  7.846000e+05,  2.918000e+05,
         2.918000e+05,  3.515000e+05,  4.126000e+05,  3.536000e+05,
         1.495000e+05,  6.867000e+05,  6.422000e+05,  9.411000e+05,
         2.004000e+05,  4.568000e+05,  5.468000e+05,  7.915000e+05,
         1.748000e+05,  1.747000e+05,  8.620000e+04,  9.180000e+04,
         3.661000e+05,  1.995000e+05,  1.685000e+05,  5.056000e+05,
         1.970000e+05,  2.977000e+05,  6.120000e+04, -2.780000e+04,
         6.720000e+04,  2.243000e+05,  2.243000e+05,  2.243000e+05,
         2.243000e+05,  1.339000e+05,  1.339000e+05, -3.030000e+04,
         3.497000e+05,  3.033000e+05, -1.250000e+04,  0.000000e+00,
         4.730000e+04,  5.810000e+04,  7.090000e+04,  1.537000e+05,
         6.170000e+04,  6.170000e+04,  2.140000e+05,  2.140000e+05,
         2.140000e+05,  1.112600e+06,  8.855000e+05,  5.885000e+05,
         5.982000e+05,  3.888000e+05,  2.540000e+05,  1.420000e+05,
         3.742000e+05,  8.623000e+05,  5.460000e+05,  8.623000e+05,
         5.467000e+05,  3.544000e+05, -2.781000e+05, -5.326000e+05,
        -4.581000e+05,  4.860000e+04,  4.100000e+03,  7.391000e+05,
        -1.604000e+05,  9.280000e+04,  4.830000e+04, -7.570000e+04,
         8.400000e+03,  8.540000e+04, -5.220000e+04, -3.900000e+04,
        -1.679000e+05,  1.668000e+05,  4.147000e+05,  2.610000e+05,
         6.700000e+03,  5.153000e+05,  3.840000e+04,  5.360000e+04,
         1.920000e+04, -6.990000e+04,  1.692000e+05,  4.137000e+05,
         2.798000e+05,  1.607000e+05,  1.710000e+05,  1.670000e+05,
         2.789000e+05,  3.914000e+05,  1.290000e+04,  3.617000e+05,
         4.215000e+05,  2.561000e+05,  2.561000e+05,  1.226000e+05,
         3.373000e+05,  5.598000e+05,  4.279800e+06,  6.560000e+04,
         6.570000e+04, -1.890000e+04, -1.900000e+04,  1.498000e+05,
        -1.900000e+04, -5.290000e+04, -1.900000e+04,  7.810000e+04,
         7.810000e+04,  7.810000e+04,  7.810000e+04,  8.170000e+04,
        -9.150000e+04, -9.140000e+04, -9.140000e+04, -1.174000e+05,
         1.359000e+05,  0.000000e+00, -5.460000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -5.489000e+05, -1.753000e+05, -9.710000e+04,
         5.725000e+05,  3.058000e+05,  3.056000e+05,  5.397000e+05,
         5.396000e+05, -1.250000e+04,  1.197000e+05, -1.090000e+04,
         2.390000e+04, -1.540000e+04, -8.400000e+03, -5.900000e+03,
        -1.413000e+05,  1.120000e+05, -2.140000e+04, -6.000000e+02,
         0.000000e+00, -2.000000e+02, -1.490000e+04,  1.520000e+04,
        -2.120000e+04, -1.840000e+04, -1.840000e+04, -1.840000e+04,
         0.000000e+00,  0.000000e+00, -1.091000e+05, -1.520000e+05,
        -3.230000e+04,  4.100000e+03,  3.910000e+04, -1.960000e+04,
         3.200000e+04,  2.460000e+04, -7.150000e+04, -1.070000e+04,
         1.232000e+05,  1.233000e+05,  2.530000e+04, -1.220000e+04,
        -5.000000e+03,  1.533000e+05,  1.116000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02, -1.200000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.390000e+04,
         1.197000e+05, -1.850000e+04, -6.000000e+02, -2.140000e+04,
         7.810000e+04, -1.000000e+02,  1.459000e+05,  5.580000e+04,
         2.140000e+05,  2.243000e+05,  3.497000e+05, -6.280000e+04,
         1.498000e+05, -1.900000e+04,  6.570000e+04, -9.140000e+04,
        -9.710000e+04, -1.090000e+04, -1.840000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         7.810000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.100000e+04,  2.451000e+05,  6.050000e+04,  3.505000e+05,
         1.805000e+05,  1.240000e+04, -9.500000e+03,  1.530000e+04,
         2.450000e+05,  1.610000e+04,  2.444000e+05,  5.270000e+04,
         1.662000e+05, -1.509000e+05,  0.000000e+00,  5.270000e+04,
         2.322000e+05,  5.300000e+04,  1.930000e+04,  2.115000e+05,
         0.000000e+00,  4.100000e+03,  3.383000e+05,  8.210000e+04,
         5.307000e+05,  8.133000e+05,  6.201000e+05,  1.556000e+05,
         6.903000e+05,  2.932000e+05,  4.964000e+05,  5.255000e+05,
         3.358600e+06, -5.720000e+04, -5.710000e+04, -5.690000e+04,
        -5.710000e+04, -1.418000e+05, -5.720000e+04, -8.232000e+05,
        -3.779000e+05, -7.192000e+05, -9.890000e+04,  1.170000e+04,
        -7.290000e+04,  5.281000e+05,  8.235000e+05,  3.199000e+05,
         3.198000e+05,  4.602000e+05,  6.013000e+05,  3.811000e+05,
         1.690000e+05,  6.748000e+05,  7.858000e+05,  1.487600e+06,
         2.066000e+05,  4.142000e+05,  5.808000e+05,  8.298000e+05,
         8.300000e+04,  8.300000e+04,  3.085000e+05,  1.350000e+05,
        -7.300000e+04,  1.351000e+05,  1.980000e+04, -6.240000e+04,
         2.028000e+05,  3.274000e+05,  7.200000e+04, -4.080000e+04,
         7.480000e+04,  1.036000e+05,  1.036000e+05,  1.036000e+05,
         1.036000e+05,  3.390000e+05,  3.390000e+05, -9.950000e+04,
         3.033000e+05,  8.004000e+05, -1.180000e+04,  0.000000e+00,
         1.274000e+05,  6.410000e+04,  7.620000e+04,  1.763000e+05,
         6.840000e+04,  6.840000e+04,  2.299000e+05,  2.299000e+05,
         2.299000e+05,  8.543000e+05,  2.202800e+06,  4.315000e+05,
         3.485000e+05,  2.248000e+05,  5.778000e+05, -6.750000e+04,
         8.377000e+05,  4.557000e+05,  1.279600e+06,  4.557000e+05,
         1.280100e+06,  5.060000e+04, -5.842000e+05, -7.872000e+05,
        -1.177000e+05, -5.700000e+03,  1.052000e+05,  2.406500e+06,
        -1.288000e+05,  7.390000e+04,  1.852000e+05, -6.920000e+04,
         1.790000e+04, -1.006000e+05,  2.466000e+05, -2.260000e+04,
        -3.035000e+05, -4.090000e+04,  2.480000e+05, -7.850000e+04,
        -2.819000e+05,  1.248000e+05,  4.762000e+05,  5.150000e+04,
        -1.051000e+05,  1.168000e+05,  2.216000e+05,  2.484000e+05,
         5.801000e+05,  4.590000e+04,  2.243000e+05, -4.510000e+04,
         6.020000e+05,  2.674000e+05,  3.390000e+04,  3.964000e+05,
         5.368000e+05,  5.920000e+04,  5.930000e+04,  4.145000e+05,
         8.699000e+05,  3.151000e+05,  1.188100e+06,  8.160000e+04,
         8.170000e+04,  2.230000e+04,  2.230000e+04,  1.683000e+05,
         2.230000e+04,  8.100000e+03,  2.230000e+04,  9.380000e+04,
         9.380000e+04,  9.380000e+04,  9.370000e+04,  9.010000e+04,
        -1.042000e+05, -1.041000e+05, -1.042000e+05, -1.816000e+05,
         2.190000e+04,  0.000000e+00, -5.910000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -6.252000e+05, -1.637000e+05, -7.070000e+04,
         6.302000e+05,  3.560000e+05,  3.562000e+05,  6.374000e+05,
         6.373000e+05, -1.210000e+04,  1.193000e+05, -1.900000e+04,
        -3.070000e+04,  7.960000e+04,  5.140000e+04, -4.800000e+03,
        -1.509000e+05,  5.260000e+04,  1.273000e+05,  7.000000e+02,
         0.000000e+00, -1.300000e+03, -2.930000e+04, -6.120000e+04,
         4.920000e+04, -2.160000e+04, -2.170000e+04, -2.170000e+04,
         0.000000e+00,  0.000000e+00, -1.929000e+05, -8.140000e+04,
         1.965000e+05,  2.570000e+04, -9.180000e+04,  4.550000e+04,
        -4.120000e+04, -3.150000e+04, -7.650000e+04,  6.350000e+04,
         1.252000e+05,  1.253000e+05, -4.410000e+04,  6.740000e+04,
        -6.600000e+03,  8.630000e+04,  1.934000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02, -9.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -3.070000e+04,
         1.193000e+05, -1.980000e+04,  7.000000e+02,  1.273000e+05,
         9.380000e+04, -1.000000e+02,  1.100000e+04,  2.451000e+05,
         2.299000e+05,  1.036000e+05,  3.033000e+05, -5.710000e+04,
         1.683000e+05,  2.230000e+04,  8.170000e+04, -1.042000e+05,
        -7.070000e+04, -1.900000e+04, -2.170000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         9.380000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-7.300000e+03, -4.900000e+03, -4.500000e+03, -6.600000e+03,
        -6.900000e+03, -2.990000e+04, -1.540000e+04, -6.500000e+03,
        -4.900000e+03, -6.300000e+03, -4.900000e+03, -3.700000e+03,
        -3.100000e+03,  5.300000e+03,  0.000000e+00, -3.700000e+03,
        -7.300000e+03, -3.400000e+03, -3.000000e+02, -1.650000e+04,
         0.000000e+00, -1.200000e+04, -1.310000e+04, -8.100000e+03,
        -1.630000e+04, -1.730000e+04, -1.600000e+04, -1.680000e+04,
        -1.900000e+04, -3.580000e+04, -4.730000e+04, -3.610000e+04,
        -9.750000e+04, -1.500000e+03, -1.700000e+03, -1.600000e+03,
        -1.300000e+03,  3.300000e+03, -1.700000e+03, -4.000000e+02,
        -1.800000e+03,  4.800000e+03, -1.400000e+03, -9.000000e+02,
        -1.000000e+02, -1.360000e+04, -1.350000e+04, -1.470000e+04,
        -1.470000e+04, -1.580000e+04, -1.620000e+04, -1.360000e+04,
        -9.600000e+03, -3.070000e+04, -3.060000e+04, -3.600000e+04,
        -2.000000e+03, -1.310000e+04, -1.290000e+04, -1.330000e+04,
        -2.160000e+04, -2.160000e+04, -2.220000e+04, -1.900000e+04,
        -1.710000e+04, -1.080000e+04, -8.300000e+03, -2.460000e+04,
        -7.600000e+03, -1.340000e+04, -5.200000e+03,  2.000000e+03,
        -6.600000e+03, -1.170000e+04, -1.170000e+04, -1.170000e+04,
        -1.170000e+04, -1.180000e+04, -1.180000e+04, -2.000000e+02,
        -1.250000e+04, -1.180000e+04,  2.429200e+06,  0.000000e+00,
         2.409800e+06,  2.426700e+06, -1.900000e+03, -1.300000e+04,
        -5.000000e+03, -5.000000e+03, -6.300000e+03, -6.300000e+03,
        -6.300000e+03, -4.890000e+04, -4.820000e+04, -2.630000e+04,
         2.288100e+06,  4.832700e+06,  4.792900e+06,  7.340100e+06,
         4.794500e+06, -4.750000e+04, -4.770000e+04, -4.750000e+04,
        -4.820000e+04, -2.530000e+04,  9.900000e+03,  2.120000e+04,
         9.500000e+03, -7.500000e+03, -7.400000e+03, -6.610000e+04,
         4.800000e+03, -6.100000e+03, -6.400000e+03,  2.411900e+06,
        -4.400000e+03,  2.300000e+03,  2.300000e+03,  6.200000e+03,
         1.320000e+04,  2.397600e+06, -2.210000e+04, -1.360000e+04,
        -1.600000e+03, -2.550000e+04, -1.300000e+04, -7.100000e+03,
        -8.100000e+03, -7.900000e+03, -2.190000e+04, -2.390000e+04,
        -2.230000e+04, -1.310000e+04, -2.230000e+04,  2.405500e+06,
        -2.460000e+04, -2.840000e+04, -8.200000e+03, -1.660000e+04,
        -1.770000e+04, -1.340000e+04, -1.340000e+04, -1.090000e+04,
        -3.690000e+04, -3.750000e+04, -2.247000e+05,  2.398900e+06,
         2.401900e+06, -5.000000e+02, -5.000000e+02, -1.000000e+04,
        -5.000000e+02,  7.500000e+03, -5.000000e+02, -6.900000e+03,
        -6.900000e+03, -6.900000e+03, -6.800000e+03, -4.000000e+02,
         2.310600e+06,  2.309000e+06,  2.309300e+06,  4.500000e+03,
        -4.800000e+03,  0.000000e+00,  1.409300e+06,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.386110e+07,  1.050000e+04,  5.000000e+03,
        -3.000000e+04, -2.360000e+04, -2.360000e+04, -4.430000e+04,
        -4.430000e+04,  2.405900e+06,  0.000000e+00,  3.000000e+02,
        -7.000000e+02, -1.400000e+03,  7.000000e+02,  4.000000e+02,
         5.300000e+03, -3.900000e+03,  1.800000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.200000e+03, -2.000000e+02,
         1.000000e+03,  1.600000e+03,  1.600000e+03,  1.600000e+03,
         0.000000e+00,  0.000000e+00,  5.400000e+03,  6.100000e+03,
         2.600000e+03,  4.000000e+02, -9.000000e+02,  9.000000e+02,
         3.000000e+02, -8.000000e+02,  2.800000e+03,  9.000000e+02,
        -1.000000e+02, -1.000000e+02, -5.000000e+02,  8.000000e+02,
         4.000000e+02, -7.000000e+02,  6.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.000000e+02, -7.000000e+02,
         0.000000e+00,  7.000000e+02,  0.000000e+00,  1.800000e+03,
        -6.900000e+03,  0.000000e+00, -7.300000e+03, -4.900000e+03,
        -6.300000e+03, -1.170000e+04, -1.250000e+04, -1.300000e+03,
        -1.000000e+04, -5.000000e+02,  2.401900e+06,  2.309400e+06,
         5.000000e+03,  3.000000e+02,  1.600000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -6.900000e+03,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.747230e+07,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.550000e+04,  1.766000e+05,  1.840000e+04,  2.420000e+04,
         1.980000e+04,  5.740000e+04,  2.630000e+04,  1.700000e+04,
         1.766000e+05,  1.740000e+04,  1.760000e+05,  2.480000e+04,
         1.038000e+05, -2.457000e+05,  0.000000e+00,  2.480000e+04,
         2.480000e+04,  2.510000e+04,  1.200000e+04,  9.720000e+04,
         0.000000e+00, -1.771000e+05,  4.030000e+04, -1.711000e+05,
        -1.789000e+05,  2.652000e+05,  4.848000e+05,  6.910000e+04,
         7.880000e+04, -3.067000e+05, -3.910000e+04, -1.517000e+05,
        -9.575000e+05, -2.187000e+05, -2.186000e+05, -2.180000e+05,
        -2.183000e+05, -2.935000e+05, -2.186000e+05, -2.025700e+06,
        -1.734700e+06, -2.017800e+06, -2.237000e+05, -1.501000e+05,
        -2.217000e+05,  4.430000e+04,  4.670000e+04, -3.102000e+05,
        -3.123000e+05, -5.370000e+04,  1.404000e+05, -1.763000e+05,
        -2.032000e+05, -4.939000e+05, -4.207000e+05,  8.722000e+05,
        -2.249000e+05,  4.580000e+04,  5.050000e+04,  4.650000e+04,
        -3.634000e+05, -3.634000e+05, -2.159000e+05, -3.594000e+05,
         1.670000e+04,  5.010000e+04,  2.030000e+04,  3.400000e+04,
         5.300000e+03,  5.290000e+04,  2.070000e+04, -1.860000e+04,
         1.510000e+04,  4.520000e+04,  4.520000e+04,  4.520000e+04,
         4.520000e+04,  2.038000e+05,  2.038000e+05, -2.222000e+05,
         4.730000e+04,  1.274000e+05,  2.409800e+06,  0.000000e+00,
         5.285400e+06,  2.532700e+06, -2.234000e+05, -8.280000e+04,
         2.020000e+04,  2.020000e+04,  2.630000e+04,  2.620000e+04,
         2.620000e+04,  1.897000e+05,  5.876000e+05, -3.510000e+05,
         2.117600e+06,  4.916300e+06,  5.181500e+06,  7.203600e+06,
         1.088640e+07,  1.857000e+05,  7.406000e+05,  1.857000e+05,
         7.403000e+05, -3.495000e+05, -9.462000e+05, -1.213800e+06,
        -6.339000e+05, -1.960000e+05, -1.228000e+05,  1.769900e+06,
        -2.434000e+05,  2.520000e+04,  9.770000e+04,  2.192800e+06,
        -4.490000e+05, -1.080000e+04,  2.238000e+05, -4.900000e+03,
        -2.795000e+05,  2.430200e+06,  9.750000e+04, -1.897000e+05,
        -4.568000e+05,  7.740000e+04,  1.759000e+05, -1.797000e+05,
        -4.191000e+05, -2.729000e+05, -1.353000e+05,  9.540000e+04,
         3.163000e+05, -1.731000e+05, -1.368000e+05,  2.438300e+06,
         3.328000e+05,  1.119000e+05, -1.886000e+05, -1.793000e+05,
         7.930000e+04,  3.660000e+04,  3.660000e+04,  2.784000e+05,
         3.508000e+05, -1.480000e+04,  6.636000e+05,  2.458200e+06,
         2.451500e+06,  2.400000e+03,  2.400000e+03, -2.041000e+05,
         2.400000e+03,  1.963000e+05,  2.400000e+03,  2.720000e+04,
         2.720000e+04,  2.720000e+04,  2.720000e+04,  3.290000e+04,
         2.250100e+06,  2.248500e+06,  2.248800e+06, -2.503000e+05,
         1.990000e+04,  0.000000e+00,  1.378700e+06,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.349820e+07, -5.470000e+04, -2.620000e+04,
        -6.141000e+05, -1.495000e+05, -1.492000e+05, -6.780000e+04,
        -6.790000e+04,  2.420600e+06, -1.900000e+03, -1.210000e+04,
        -4.500000e+03,  7.280000e+04,  6.830000e+04, -1.700000e+03,
        -2.457000e+05,  2.460000e+04,  1.923000e+05,  1.000000e+02,
         0.000000e+00,  2.100000e+03, -1.260000e+04, -1.740000e+04,
         5.500000e+04, -6.200000e+03, -6.200000e+03, -6.200000e+03,
         0.000000e+00,  0.000000e+00, -2.505000e+05, -1.772000e+05,
         2.614000e+05,  5.840000e+04, -2.190000e+04,  5.080000e+04,
        -4.700000e+03, -4.700000e+03, -1.221000e+05,  9.600000e+04,
        -2.000000e+03, -2.000000e+03, -5.500000e+03,  6.810000e+04,
        -1.700000e+03, -7.700000e+03,  6.610000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.000000e+02, -4.500000e+03,
        -1.900000e+03, -3.220000e+04,  1.000000e+02,  1.923000e+05,
         2.720000e+04,  0.000000e+00,  1.550000e+04,  1.766000e+05,
         2.620000e+04,  4.520000e+04,  4.730000e+04, -2.183000e+05,
        -2.041000e+05,  2.400000e+03,  2.451500e+06,  2.248900e+06,
        -2.620000e+04, -1.210000e+04, -6.200000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.720000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.700000e+04,  2.990000e+04,  2.320000e+04,  2.680000e+04,
         2.190000e+04,  6.090000e+04,  2.680000e+04,  1.880000e+04,
         2.990000e+04,  1.920000e+04,  2.990000e+04,  2.950000e+04,
         3.450000e+04, -2.538000e+05,  0.000000e+00,  2.950000e+04,
         3.030000e+04,  2.990000e+04,  4.000000e+03,  1.163000e+05,
         0.000000e+00, -1.716000e+05, -1.545000e+05, -1.618000e+05,
        -1.582000e+05,  8.900000e+04,  9.240000e+04,  1.715000e+05,
         1.802000e+05, -2.722000e+05,  8.400000e+03, -2.616000e+05,
        -8.439000e+05, -2.183000e+05, -2.185000e+05, -2.183000e+05,
        -2.182000e+05, -2.994000e+05, -2.186000e+05, -2.051800e+06,
        -2.027400e+06, -2.038800e+06, -2.272000e+05, -2.204000e+05,
        -2.239000e+05,  4.860000e+04,  4.960000e+04, -2.819000e+05,
        -2.819000e+05, -1.578000e+05, -3.380000e+04, -1.594000e+05,
        -1.869000e+05, -4.455000e+05, -4.392000e+05,  1.813000e+05,
        -2.250000e+05,  5.330000e+04,  5.810000e+04,  5.010000e+04,
        -3.463000e+05, -3.464000e+05, -3.357000e+05, -3.398000e+05,
         1.230000e+04,  6.190000e+04,  2.260000e+04,  3.080000e+04,
         3.080000e+04,  6.620000e+04,  2.670000e+04, -8.700000e+03,
         3.480000e+04,  5.450000e+04,  5.450000e+04,  5.450000e+04,
         5.450000e+04,  6.510000e+04,  6.510000e+04, -2.261000e+05,
         5.810000e+04,  6.410000e+04,  2.426700e+06,  0.000000e+00,
         2.532700e+06,  3.006900e+06, -2.218000e+05, -5.840000e+04,
         2.580000e+04,  2.580000e+04,  3.130000e+04,  3.130000e+04,
         3.130000e+04,  2.335000e+05,  2.608000e+05, -3.268000e+05,
         2.154200e+06,  4.968600e+06,  4.944200e+06,  7.348800e+06,
         5.199200e+06,  2.261000e+05,  2.630000e+05,  2.261000e+05,
         2.628000e+05, -3.345000e+05, -9.780000e+05, -1.258900e+06,
        -9.569000e+05, -1.913000e+05, -1.849000e+05,  3.767000e+05,
        -2.492000e+05,  3.180000e+04,  3.750000e+04,  2.192000e+06,
        -4.405000e+05, -1.940000e+04, -3.200000e+03, -9.700000e+03,
        -3.004000e+05,  2.410100e+06,  1.193000e+05, -1.910000e+05,
        -4.714000e+05,  8.950000e+04, -1.595000e+05, -1.747000e+05,
        -4.177000e+05, -4.051000e+05, -1.117000e+05,  1.173000e+05,
         1.376000e+05, -1.638000e+05, -1.131000e+05,  2.417700e+06,
         1.326000e+05,  1.134000e+05, -1.809000e+05, -1.550000e+05,
        -3.090000e+04,  4.240000e+04,  4.240000e+04,  6.240000e+04,
         2.830000e+04, -3.200000e+03,  7.776000e+05,  2.437900e+06,
         2.440900e+06,  4.300000e+03,  4.300000e+03, -1.869000e+05,
         4.300000e+03,  1.920000e+05,  4.300000e+03,  3.510000e+04,
         3.510000e+04,  3.510000e+04,  3.510000e+04,  4.070000e+04,
         2.269200e+06,  2.267600e+06,  2.267900e+06, -2.608000e+05,
         2.220000e+04,  0.000000e+00,  1.384000e+06,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.361280e+07, -6.860000e+04, -3.220000e+04,
        -5.646000e+05, -1.167000e+05, -1.168000e+05, -1.150000e+04,
        -1.150000e+04,  2.402900e+06, -4.000000e+03, -3.000000e+02,
        -6.900000e+03, -3.900000e+03, -1.800000e+03, -2.200000e+03,
        -2.538000e+05,  2.930000e+04, -4.800000e+03,  8.640000e+04,
         0.000000e+00,  0.000000e+00, -3.900000e+03, -8.700000e+03,
        -2.400000e+03, -8.000000e+03, -8.000000e+03, -8.000000e+03,
         0.000000e+00,  0.000000e+00, -2.628000e+05, -2.557000e+05,
        -7.000000e+03, -4.300000e+03, -1.570000e+04, -2.200000e+03,
         8.270000e+04, -7.200000e+03, -1.262000e+05, -2.400000e+03,
        -4.000000e+03, -4.000000e+03, -8.400000e+03, -2.000000e+03,
        -2.200000e+03, -1.250000e+04, -6.000000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.000000e+02, -6.900000e+03,
        -4.000000e+03, -3.330000e+04,  8.640000e+04, -4.800000e+03,
         3.510000e+04,  0.000000e+00,  1.700000e+04,  2.990000e+04,
         3.130000e+04,  5.450000e+04,  5.810000e+04, -2.182000e+05,
        -1.869000e+05,  4.300000e+03,  2.440900e+06,  2.268000e+06,
        -3.220000e+04, -3.000000e+02, -8.000000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         3.510000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-5.800000e+04, -4.660000e+04, -3.260000e+04,  2.813000e+05,
         1.114000e+05, -2.367000e+05, -1.206000e+05, -5.750000e+04,
        -4.660000e+04, -5.750000e+04, -4.650000e+04, -5.270000e+04,
        -4.730000e+04,  4.404000e+05,  0.000000e+00, -5.270000e+04,
         1.185000e+05, -5.280000e+04, -5.500000e+03, -2.101000e+05,
         0.000000e+00,  2.833000e+05,  2.982000e+05,  3.211000e+05,
         8.396000e+05,  3.656000e+05, -1.402000e+05, -1.562000e+05,
         3.648000e+05,  5.359000e+05,  4.400000e+04,  5.459000e+05,
         4.964900e+06,  3.918000e+05,  3.920000e+05,  3.915000e+05,
         3.924000e+05,  5.265000e+05,  3.919000e+05,  3.584100e+06,
         3.602400e+06,  3.634600e+06,  3.871000e+05,  3.922000e+05,
         3.997000e+05,  3.935000e+05,  7.232000e+05,  8.811000e+05,
         8.810000e+05,  6.557000e+05,  4.226000e+05,  6.668000e+05,
         5.266000e+05,  1.535000e+06,  1.540000e+06,  4.134000e+05,
         7.617000e+05,  2.321000e+05,  4.033000e+05,  7.220000e+05,
         6.294000e+05,  6.294000e+05,  6.404000e+05,  6.546000e+05,
        -1.298000e+05, -9.990000e+04, -6.870000e+04, -1.870000e+05,
         1.218000e+05,  7.050000e+04, -3.630000e+04,  5.700000e+03,
        -5.440000e+04, -1.043000e+05, -1.043000e+05, -1.043000e+05,
        -1.043000e+05, -9.480000e+04, -9.480000e+04,  3.875000e+05,
         7.090000e+04,  7.620000e+04, -1.900000e+03,  0.000000e+00,
        -2.234000e+05, -2.218000e+05,  5.855000e+05,  2.059000e+05,
        -3.580000e+04, -3.580000e+04,  1.216000e+05,  1.216000e+05,
         1.216000e+05, -6.180000e+04, -3.800000e+04,  9.305000e+05,
         5.728000e+05, -2.076000e+05, -1.934000e+05, -6.610000e+04,
        -6.368000e+05, -4.126000e+05, -3.791000e+05, -4.126000e+05,
        -3.799000e+05,  5.689000e+05,  1.643800e+06,  2.135500e+06,
         1.663600e+06,  3.399000e+05,  3.449000e+05, -5.672000e+05,
         4.428000e+05, -4.960000e+04, -4.470000e+04,  3.904000e+05,
         9.669000e+05, -1.030000e+04,  4.700000e+03,  2.750000e+04,
         4.821000e+05, -6.730000e+04, -2.028000e+05,  2.722000e+05,
         7.647000e+05, -2.204000e+05,  2.973000e+05,  3.353000e+05,
         7.280000e+05,  7.381000e+05,  2.441000e+05, -2.038000e+05,
        -1.886000e+05,  2.882000e+05,  2.471000e+05, -6.080000e+04,
        -1.904000e+05, -2.139000e+05,  3.385000e+05,  6.594000e+05,
         4.340000e+05, -1.091000e+05, -1.091000e+05, -9.400000e+04,
         2.200000e+04, -3.100000e+03, -1.859100e+06, -4.960000e+04,
        -4.970000e+04,  2.300000e+03,  2.300000e+03,  5.276000e+05,
         2.300000e+03, -3.392000e+05,  2.300000e+03, -4.820000e+04,
        -4.820000e+04, -4.820000e+04, -4.820000e+04, -4.810000e+04,
         4.330000e+04,  4.320000e+04,  4.320000e+04,  4.361000e+05,
        -5.700000e+04,  0.000000e+00,  2.680000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.596000e+05,  9.650000e+04,  4.940000e+04,
         1.741800e+06,  4.309000e+05,  4.305000e+05,  2.859000e+05,
         2.858000e+05, -1.600000e+03,  1.520000e+05, -6.200000e+03,
        -4.400000e+03,  1.000000e+03,  3.000000e+02,  3.900000e+03,
         4.404000e+05, -5.270000e+04,  3.000000e+02,  1.000000e+02,
         0.000000e+00,  0.000000e+00,  2.000000e+03, -1.310000e+04,
        -5.200000e+03,  1.090000e+04,  1.090000e+04,  1.090000e+04,
         0.000000e+00,  0.000000e+00,  4.345000e+05,  4.409000e+05,
         1.100000e+03, -1.500000e+03, -1.740000e+04, -4.800000e+03,
        -5.300000e+03, -4.500000e+03,  2.187000e+05,  1.000000e+02,
         1.592000e+05,  1.592000e+05, -8.600000e+03, -8.000000e+02,
         2.400000e+03,  1.510000e+05,  1.585000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.600000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -4.400000e+03,
         1.520000e+05,  5.780000e+04,  1.000000e+02,  3.000000e+02,
        -4.820000e+04,  0.000000e+00, -5.800000e+04, -4.660000e+04,
         1.216000e+05, -1.043000e+05,  7.090000e+04,  3.923000e+05,
         5.276000e+05,  2.300000e+03, -4.970000e+04,  4.320000e+04,
         4.940000e+04, -6.200000e+03,  1.090000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -4.820000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 8.000000e+02,  4.650000e+04,  4.730000e+04,  1.429000e+05,
         7.190000e+04, -2.480000e+04, -2.640000e+04,  5.100000e+03,
         4.650000e+04,  5.900000e+03,  4.660000e+04,  3.930000e+04,
         5.890000e+04,  9.060000e+04,  0.000000e+00,  3.930000e+04,
         1.111000e+05,  3.960000e+04,  6.900000e+03,  1.571000e+05,
         0.000000e+00,  2.087000e+05,  3.080000e+05,  2.802000e+05,
         4.726000e+05,  3.070000e+05,  1.667000e+05,  1.181000e+05,
         3.313000e+05,  6.655000e+05,  6.116000e+05,  7.164000e+05,
         2.731500e+06,  1.679000e+05,  1.690000e+05,  1.685000e+05,
         1.667000e+05,  1.515000e+05,  1.689000e+05,  1.246500e+06,
         1.385200e+06,  1.342000e+06,  1.309000e+05,  1.625000e+05,
         1.548000e+05,  2.139000e+05,  3.197000e+05,  5.165000e+05,
         5.168000e+05,  4.303000e+05,  3.458000e+05,  4.084000e+05,
         3.209000e+05,  9.089000e+05,  9.412000e+05,  5.088000e+05,
         2.423000e+05,  1.833000e+05,  2.534000e+05,  3.221000e+05,
         4.913000e+05,  4.912000e+05,  5.535000e+05,  5.390000e+05,
        -8.280000e+04,  1.053000e+05,  8.000000e+03, -7.630000e+04,
         1.461000e+05,  1.870000e+05,  5.800000e+04, -2.170000e+04,
         7.340000e+04,  7.740000e+04,  7.740000e+04,  7.740000e+04,
         7.740000e+04,  1.231000e+05,  1.231000e+05,  1.318000e+05,
         1.537000e+05,  1.763000e+05, -1.300000e+04,  0.000000e+00,
        -8.280000e+04, -5.840000e+04,  2.059000e+05,  2.778500e+06,
         5.500000e+04,  5.500000e+04,  1.103000e+05,  1.102000e+05,
         1.102000e+05,  5.013000e+05,  6.137000e+05,  6.387000e+05,
         3.507000e+05,  1.661000e+05,  2.319000e+05, -7.230000e+04,
         1.170000e+05,  3.471000e+05,  5.071000e+05,  3.471000e+05,
         5.073000e+05,  4.539000e+05,  3.746000e+05,  4.289000e+05,
         4.732000e+05,  2.074000e+05,  2.396000e+05,  6.753000e+05,
         1.131000e+05,  5.930000e+04,  9.250000e+04,  1.538000e+05,
         4.147000e+05, -9.480000e+04, -2.000000e+04, -2.320000e+04,
        -4.090000e+04, -5.180000e+04,  1.926000e+05,  1.330000e+05,
         1.871000e+05,  7.880000e+04,  2.944000e+05,  2.522000e+05,
         3.382000e+05,  4.028000e+05,  3.925000e+05,  1.923000e+05,
         2.872000e+05,  2.461000e+05,  3.984000e+05, -5.210000e+04,
         2.611000e+05,  1.777000e+05,  2.379000e+05,  4.415000e+05,
         3.550000e+05,  3.600000e+04,  3.600000e+04,  1.078000e+05,
         5.271000e+05,  3.657000e+05,  7.809000e+05,  6.190000e+04,
         6.200000e+04,  2.100000e+04,  2.100000e+04,  3.348000e+05,
         2.090000e+04, -2.035000e+05,  2.100000e+04,  7.660000e+04,
         7.660000e+04,  7.660000e+04,  7.660000e+04,  7.330000e+04,
        -7.670000e+04, -7.660000e+04, -7.660000e+04,  6.360000e+04,
         1.220000e+04,  0.000000e+00, -5.010000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -4.598000e+05, -1.323000e+05, -5.560000e+04,
         1.037600e+06,  4.834000e+05,  4.783000e+05,  7.079000e+05,
         7.078000e+05, -1.470000e+04,  3.150000e+04, -3.200000e+03,
        -2.710000e+04, -1.070000e+04, -9.100000e+03, -4.000000e+03,
         9.060000e+04,  3.930000e+04, -2.680000e+04,  6.000000e+02,
         0.000000e+00,  0.000000e+00, -1.400000e+04, -3.830000e+04,
        -8.000000e+03, -1.750000e+04, -1.750000e+04, -1.750000e+04,
         0.000000e+00,  0.000000e+00,  5.630000e+04,  8.670000e+04,
        -3.470000e+04, -1.860000e+04, -6.530000e+04, -7.400000e+03,
        -3.450000e+04, -2.790000e+04,  4.340000e+04, -1.340000e+04,
         3.460000e+04,  3.460000e+04, -3.590000e+04, -8.100000e+03,
        -5.300000e+03, -4.000000e+02,  2.660000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02, -1.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.710000e+04,
         3.150000e+04,  1.190000e+04,  6.000000e+02, -2.680000e+04,
         7.660000e+04, -1.000000e+02,  8.000000e+02,  4.650000e+04,
         1.102000e+05,  7.740000e+04,  1.537000e+05,  1.668000e+05,
         3.348000e+05,  2.100000e+04,  6.200000e+04, -7.660000e+04,
        -5.560000e+04, -3.200000e+03, -1.750000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         7.660000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 2.430000e+04,  3.710000e+04,  4.803000e+05,  4.600000e+03,
         1.440000e+04,  8.250000e+04,  3.400000e+04,  2.310000e+04,
         3.710000e+04,  2.290000e+04,  3.700000e+04,  3.610000e+04,
         4.340000e+04, -6.170000e+04,  0.000000e+00,  3.610000e+04,
         2.640000e+04,  3.610000e+04,  5.000000e+03,  1.443000e+05,
         0.000000e+00,  4.600000e+04,  6.750000e+04,  7.092000e+05,
         1.580000e+04,  6.720000e+04,  1.172000e+05,  1.076000e+05,
         7.790000e+04,  1.985000e+05,  2.962000e+05,  2.126000e+05,
         7.710000e+04, -1.310000e+04, -1.300000e+04, -1.300000e+04,
        -1.320000e+04, -5.280000e+04, -1.310000e+04, -2.411000e+05,
        -2.130000e+05,  6.431000e+05, -2.540000e+04, -1.890000e+04,
         1.956000e+05,  1.890000e+04, -1.360000e+04,  7.700000e+03,
         7.700000e+03,  3.340000e+04,  5.920000e+04,  2.469000e+05,
         1.270000e+04,  3.380000e+04,  4.060000e+04,  1.692000e+05,
        -5.820000e+04,  4.030000e+04,  3.050000e+04, -1.490000e+04,
         9.410000e+04,  9.410000e+04,  1.086000e+05,  5.363000e+05,
         5.100000e+03,  8.640000e+04,  2.700000e+04,  4.200000e+03,
         2.230000e+04,  7.510000e+04,  3.720000e+04, -1.520000e+04,
         4.490000e+04,  7.180000e+04,  7.180000e+04,  7.180000e+04,
         7.180000e+04,  8.570000e+04,  8.570000e+04, -2.580000e+04,
         6.170000e+04,  6.840000e+04, -5.000000e+03,  0.000000e+00,
         2.020000e+04,  2.580000e+04, -3.580000e+04,  5.500000e+04,
         4.842000e+05,  4.841000e+05,  2.590000e+04,  2.590000e+04,
         2.590000e+04,  2.795000e+05,  3.140000e+05,  8.390000e+04,
         3.640000e+04,  1.456000e+05,  1.660000e+05, -3.800000e+03,
         2.183000e+05,  2.995000e+05,  3.482000e+05,  2.995000e+05,
         3.486000e+05,  1.044000e+05, -1.992000e+05, -2.968000e+05,
        -1.712000e+05,  2.270000e+04,  2.940000e+04,  4.834000e+05,
        -5.480000e+04,  4.270000e+04,  4.990000e+04, -1.860000e+04,
        -4.900000e+04, -3.120000e+04, -1.040000e+04,  6.320000e+05,
        -1.288000e+05,  8.100000e+03,  1.552000e+05,  2.190000e+04,
        -7.590000e+04,  1.197000e+05,  5.590000e+04,  1.127200e+06,
        -3.400000e+03,  1.030000e+04,  1.314000e+05,  1.558000e+05,
         1.753000e+05,  5.840000e+04,  1.329000e+05,  4.200000e+03,
         1.772000e+05,  1.569000e+05,  3.390000e+04,  3.860000e+04,
         6.430000e+04,  6.000000e+04,  6.000000e+04,  7.980000e+04,
         2.447000e+05,  2.106000e+05,  1.058100e+06,  4.300000e+04,
         4.300000e+04,  6.900000e+03,  6.900000e+03,  1.280000e+04,
         6.900000e+03, -2.170000e+04,  6.900000e+03,  4.870000e+04,
         4.870000e+04,  4.870000e+04,  4.860000e+04,  4.930000e+04,
        -4.990000e+04, -4.980000e+04, -4.980000e+04, -7.650000e+04,
         2.120000e+04,  0.000000e+00, -3.150000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.991000e+05, -8.910000e+04, -4.110000e+04,
         1.560000e+04,  1.100000e+05,  1.100000e+05,  2.559000e+05,
         2.558000e+05, -5.600000e+03, -2.000000e+04, -3.700000e+03,
        -1.490000e+04, -6.800000e+03, -4.100000e+03,  9.920000e+04,
        -6.170000e+04,  3.610000e+04, -1.030000e+04,  2.000000e+02,
         0.000000e+00,  0.000000e+00,  1.658000e+05, -1.570000e+04,
        -9.300000e+03, -1.120000e+04, -1.120000e+04, -1.120000e+04,
         0.000000e+00,  0.000000e+00, -7.380000e+04, -6.730000e+04,
        -1.590000e+04, -7.200000e+03, -3.060000e+04, -8.600000e+03,
        -1.210000e+04, -1.460000e+04, -3.150000e+04, -5.100000e+03,
        -2.270000e+04, -2.270000e+04, -1.360000e+04, -6.900000e+03,
         8.570000e+04, -3.620000e+04, -2.950000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.400000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.490000e+04,
        -2.000000e+04, -8.100000e+03,  2.000000e+02, -1.030000e+04,
         4.870000e+04,  0.000000e+00,  2.430000e+04,  3.710000e+04,
         2.590000e+04,  7.180000e+04,  6.170000e+04, -1.320000e+04,
         1.280000e+04,  6.900000e+03,  4.300000e+04, -4.980000e+04,
        -4.110000e+04, -3.700000e+03, -1.120000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.870000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 2.430000e+04,  3.710000e+04,  4.804000e+05,  4.600000e+03,
         1.440000e+04,  8.250000e+04,  3.400000e+04,  2.310000e+04,
         3.710000e+04,  2.290000e+04,  3.700000e+04,  3.610000e+04,
         4.340000e+04, -6.170000e+04,  0.000000e+00,  3.610000e+04,
         2.640000e+04,  3.610000e+04,  5.000000e+03,  1.443000e+05,
         0.000000e+00,  4.600000e+04,  6.750000e+04,  7.092000e+05,
         1.580000e+04,  6.720000e+04,  1.172000e+05,  1.076000e+05,
         7.790000e+04,  1.985000e+05,  2.963000e+05,  2.126000e+05,
         7.710000e+04, -1.310000e+04, -1.300000e+04, -1.300000e+04,
        -1.320000e+04, -5.280000e+04, -1.310000e+04, -2.411000e+05,
        -2.130000e+05,  6.432000e+05, -2.540000e+04, -1.890000e+04,
         1.957000e+05,  1.890000e+04, -1.360000e+04,  7.700000e+03,
         7.700000e+03,  3.340000e+04,  5.920000e+04,  2.469000e+05,
         1.270000e+04,  3.380000e+04,  4.060000e+04,  1.692000e+05,
        -5.820000e+04,  4.030000e+04,  3.050000e+04, -1.490000e+04,
         9.410000e+04,  9.410000e+04,  1.086000e+05,  5.363000e+05,
         5.100000e+03,  8.640000e+04,  2.700000e+04,  4.200000e+03,
         2.230000e+04,  7.510000e+04,  3.720000e+04, -1.520000e+04,
         4.490000e+04,  7.180000e+04,  7.180000e+04,  7.180000e+04,
         7.180000e+04,  8.570000e+04,  8.570000e+04, -2.580000e+04,
         6.170000e+04,  6.840000e+04, -5.000000e+03,  0.000000e+00,
         2.020000e+04,  2.580000e+04, -3.580000e+04,  5.500000e+04,
         4.841000e+05,  4.841000e+05,  2.590000e+04,  2.590000e+04,
         2.590000e+04,  2.795000e+05,  3.140000e+05,  8.390000e+04,
         3.640000e+04,  1.456000e+05,  1.660000e+05, -3.800000e+03,
         2.183000e+05,  2.995000e+05,  3.482000e+05,  2.995000e+05,
         3.486000e+05,  1.044000e+05, -1.992000e+05, -2.968000e+05,
        -1.712000e+05,  2.270000e+04,  2.940000e+04,  4.834000e+05,
        -5.480000e+04,  4.270000e+04,  4.990000e+04, -1.860000e+04,
        -4.900000e+04, -3.120000e+04, -1.040000e+04,  6.320000e+05,
        -1.288000e+05,  8.100000e+03,  1.552000e+05,  2.190000e+04,
        -7.590000e+04,  1.197000e+05,  5.590000e+04,  1.127300e+06,
        -3.400000e+03,  1.030000e+04,  1.314000e+05,  1.558000e+05,
         1.753000e+05,  5.840000e+04,  1.329000e+05,  4.200000e+03,
         1.772000e+05,  1.569000e+05,  3.390000e+04,  3.860000e+04,
         6.430000e+04,  6.000000e+04,  6.000000e+04,  7.980000e+04,
         2.447000e+05,  2.106000e+05,  1.058100e+06,  4.300000e+04,
         4.300000e+04,  6.900000e+03,  6.900000e+03,  1.280000e+04,
         6.900000e+03, -2.170000e+04,  6.900000e+03,  4.870000e+04,
         4.870000e+04,  4.870000e+04,  4.860000e+04,  4.930000e+04,
        -4.990000e+04, -4.980000e+04, -4.980000e+04, -7.650000e+04,
         2.120000e+04,  0.000000e+00, -3.150000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.991000e+05, -8.910000e+04, -4.110000e+04,
         1.560000e+04,  1.100000e+05,  1.100000e+05,  2.559000e+05,
         2.558000e+05, -5.600000e+03, -2.000000e+04, -3.700000e+03,
        -1.490000e+04, -6.800000e+03, -4.100000e+03,  9.920000e+04,
        -6.170000e+04,  3.610000e+04, -1.030000e+04,  2.000000e+02,
         0.000000e+00,  0.000000e+00,  1.658000e+05, -1.570000e+04,
        -9.300000e+03, -1.120000e+04, -1.120000e+04, -1.120000e+04,
         0.000000e+00,  0.000000e+00, -7.380000e+04, -6.730000e+04,
        -1.590000e+04, -7.200000e+03, -3.060000e+04, -8.600000e+03,
        -1.210000e+04, -1.460000e+04, -3.150000e+04, -5.100000e+03,
        -2.270000e+04, -2.270000e+04, -1.360000e+04, -6.900000e+03,
         8.570000e+04, -3.620000e+04, -2.950000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.400000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.490000e+04,
        -2.000000e+04, -8.100000e+03,  2.000000e+02, -1.030000e+04,
         4.870000e+04,  0.000000e+00,  2.430000e+04,  3.710000e+04,
         2.590000e+04,  7.180000e+04,  6.170000e+04, -1.320000e+04,
         1.280000e+04,  6.900000e+03,  4.300000e+04, -4.980000e+04,
        -4.110000e+04, -3.700000e+03, -1.120000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.870000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-7.500000e+03,  2.420000e+04,  2.280000e+04,  3.566000e+05,
         1.741000e+05, -4.600000e+04, -3.110000e+04, -5.200000e+03,
         2.420000e+04, -4.700000e+03,  2.420000e+04,  1.430000e+04,
         2.840000e+04, -7.480000e+04,  0.000000e+00,  1.430000e+04,
         1.969000e+05,  1.450000e+04,  3.300000e+03,  5.760000e+04,
         0.000000e+00, -3.190000e+04,  1.360000e+04,  1.470000e+04,
         5.149000e+05,  5.902000e+05,  7.690000e+04,  4.330000e+04,
         6.045000e+05,  6.930000e+04,  1.583000e+05,  1.004000e+05,
         3.253300e+06, -3.910000e+04, -3.910000e+04, -3.910000e+04,
        -3.910000e+04, -7.570000e+04, -3.920000e+04, -4.914000e+05,
        -4.308000e+05, -4.293000e+05, -6.060000e+04, -4.550000e+04,
        -4.510000e+04,  5.326000e+05,  8.701000e+05,  3.131000e+05,
         3.131000e+05,  3.478000e+05,  3.845000e+05,  3.481000e+05,
         1.556000e+05,  6.451000e+05,  6.602000e+05,  8.334000e+05,
         2.793000e+05,  3.733000e+05,  5.585000e+05,  8.678000e+05,
        -1.370000e+04, -1.370000e+04,  1.670000e+04,  1.740000e+04,
        -6.380000e+04,  4.480000e+04, -5.000000e+03, -6.880000e+04,
         1.846000e+05,  2.334000e+05,  2.740000e+04, -1.480000e+04,
         2.930000e+04,  2.850000e+04,  2.850000e+04,  2.850000e+04,
         2.850000e+04,  6.000000e+04,  6.000000e+04, -6.040000e+04,
         2.140000e+05,  2.299000e+05, -6.300000e+03,  0.000000e+00,
         2.630000e+04,  3.130000e+04,  1.216000e+05,  1.103000e+05,
         2.590000e+04,  2.590000e+04,  2.014000e+05,  2.014000e+05,
         2.014000e+05,  5.064000e+05,  5.856000e+05,  3.249000e+05,
         3.005000e+05,  6.580000e+04,  1.129000e+05, -4.750000e+04,
         1.767000e+05,  1.355000e+05,  2.455000e+05,  1.355000e+05,
         2.456000e+05, -4.230000e+04, -3.133000e+05, -4.022000e+05,
        -2.508000e+05, -2.490000e+04, -9.800000e+03,  3.237000e+05,
        -6.330000e+04,  2.590000e+04,  4.100000e+04, -4.550000e+04,
         8.060000e+04, -5.210000e+04, -5.900000e+03, -5.500000e+03,
        -1.413000e+05, -3.590000e+04,  7.880000e+04, -7.520000e+04,
        -1.641000e+05,  1.370000e+04,  5.000000e+02,  2.500000e+03,
        -8.560000e+04, -5.530000e+04,  6.740000e+04,  7.840000e+04,
         1.238000e+05, -1.070000e+04,  6.810000e+04, -3.520000e+04,
         1.257000e+05,  7.760000e+04, -4.100000e+03,  3.526000e+05,
         3.873000e+05,  5.100000e+03,  5.200000e+03,  5.420000e+04,
         1.519000e+05,  7.610000e+04,  1.793000e+05,  2.930000e+04,
         2.930000e+04,  1.160000e+04,  1.160000e+04,  1.546000e+05,
         1.150000e+04,  2.650000e+04,  1.160000e+04,  3.570000e+04,
         3.570000e+04,  3.570000e+04,  3.570000e+04,  3.370000e+04,
        -4.190000e+04, -4.180000e+04, -4.180000e+04, -9.060000e+04,
        -1.400000e+03,  0.000000e+00, -2.320000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.511000e+05, -6.010000e+04, -2.430000e+04,
         6.181000e+05,  2.264000e+05,  2.267000e+05,  3.339000e+05,
         3.338000e+05, -6.400000e+03,  1.468000e+05, -6.500000e+03,
        -1.580000e+04, -3.400000e+03, -4.700000e+03, -1.300000e+03,
        -7.480000e+04,  1.430000e+04, -1.160000e+04,  4.000000e+02,
         0.000000e+00, -3.000000e+02, -9.900000e+03, -2.810000e+04,
        -1.260000e+04, -8.200000e+03, -8.200000e+03, -8.200000e+03,
         0.000000e+00,  0.000000e+00, -9.620000e+04, -8.110000e+04,
        -1.780000e+04, -1.090000e+04, -4.380000e+04, -1.160000e+04,
        -2.100000e+04, -1.620000e+04, -3.770000e+04, -5.800000e+03,
         1.543000e+05,  1.542000e+05, -2.340000e+04, -7.400000e+03,
        -3.000000e+03,  1.313000e+05,  1.469000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.300000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.580000e+04,
         1.468000e+05, -9.800000e+03,  4.000000e+02, -1.160000e+04,
         3.570000e+04,  0.000000e+00, -7.500000e+03,  2.420000e+04,
         2.014000e+05,  2.850000e+04,  2.140000e+05, -3.910000e+04,
         1.546000e+05,  1.160000e+04,  2.930000e+04, -4.180000e+04,
        -2.430000e+04, -6.500000e+03, -8.200000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         3.570000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-7.500000e+03,  2.420000e+04,  2.280000e+04,  3.565000e+05,
         1.741000e+05, -4.600000e+04, -3.110000e+04, -5.200000e+03,
         2.420000e+04, -4.700000e+03,  2.420000e+04,  1.430000e+04,
         2.840000e+04, -7.480000e+04,  0.000000e+00,  1.430000e+04,
         1.969000e+05,  1.450000e+04,  3.300000e+03,  5.750000e+04,
         0.000000e+00, -3.190000e+04,  1.370000e+04,  1.470000e+04,
         5.148000e+05,  5.903000e+05,  7.680000e+04,  4.330000e+04,
         6.058000e+05,  6.930000e+04,  1.583000e+05,  1.004000e+05,
         3.252500e+06, -3.910000e+04, -3.910000e+04, -3.910000e+04,
        -3.910000e+04, -7.560000e+04, -3.910000e+04, -4.913000e+05,
        -4.307000e+05, -4.292000e+05, -6.060000e+04, -4.550000e+04,
        -4.510000e+04,  5.324000e+05,  8.699000e+05,  3.131000e+05,
         3.131000e+05,  3.477000e+05,  3.845000e+05,  3.481000e+05,
         1.556000e+05,  6.449000e+05,  6.601000e+05,  8.333000e+05,
         2.792000e+05,  3.732000e+05,  5.583000e+05,  8.676000e+05,
        -1.360000e+04, -1.370000e+04,  1.680000e+04,  1.740000e+04,
        -6.380000e+04,  4.470000e+04, -5.000000e+03, -6.880000e+04,
         1.846000e+05,  2.333000e+05,  2.740000e+04, -1.480000e+04,
         2.930000e+04,  2.850000e+04,  2.850000e+04,  2.850000e+04,
         2.850000e+04,  6.000000e+04,  6.000000e+04, -6.040000e+04,
         2.140000e+05,  2.299000e+05, -6.300000e+03,  0.000000e+00,
         2.620000e+04,  3.130000e+04,  1.216000e+05,  1.102000e+05,
         2.590000e+04,  2.590000e+04,  2.014000e+05,  2.018000e+05,
         2.013000e+05,  5.062000e+05,  5.854000e+05,  3.249000e+05,
         3.004000e+05,  6.580000e+04,  1.128000e+05, -4.750000e+04,
         1.768000e+05,  1.355000e+05,  2.455000e+05,  1.355000e+05,
         2.456000e+05, -4.230000e+04, -3.132000e+05, -4.021000e+05,
        -2.508000e+05, -2.490000e+04, -9.800000e+03,  3.236000e+05,
        -6.330000e+04,  2.590000e+04,  4.100000e+04, -4.550000e+04,
         8.060000e+04, -5.210000e+04, -5.900000e+03, -5.500000e+03,
        -1.413000e+05, -3.590000e+04,  7.880000e+04, -7.520000e+04,
        -1.641000e+05,  1.370000e+04,  6.000000e+02,  2.500000e+03,
        -8.560000e+04, -5.530000e+04,  6.730000e+04,  7.840000e+04,
         1.238000e+05, -1.070000e+04,  6.810000e+04, -3.520000e+04,
         1.257000e+05,  7.750000e+04, -4.100000e+03,  3.525000e+05,
         3.872000e+05,  5.100000e+03,  5.200000e+03,  5.420000e+04,
         1.519000e+05,  7.610000e+04,  1.793000e+05,  2.930000e+04,
         2.930000e+04,  1.160000e+04,  1.160000e+04,  1.545000e+05,
         1.150000e+04,  2.650000e+04,  1.160000e+04,  3.570000e+04,
         3.570000e+04,  3.570000e+04,  3.570000e+04,  3.370000e+04,
        -4.180000e+04, -4.180000e+04, -4.180000e+04, -9.050000e+04,
        -1.400000e+03,  0.000000e+00, -2.320000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.510000e+05, -6.010000e+04, -2.430000e+04,
         6.179000e+05,  2.263000e+05,  2.267000e+05,  3.338000e+05,
         3.338000e+05, -6.400000e+03,  1.468000e+05, -6.500000e+03,
        -1.570000e+04, -3.400000e+03, -4.700000e+03, -1.300000e+03,
        -7.480000e+04,  1.430000e+04, -1.160000e+04,  4.000000e+02,
         0.000000e+00, -3.000000e+02, -9.900000e+03, -2.810000e+04,
        -1.260000e+04, -8.200000e+03, -8.200000e+03, -8.200000e+03,
         0.000000e+00,  0.000000e+00, -9.620000e+04, -8.100000e+04,
        -1.780000e+04, -1.090000e+04, -4.380000e+04, -1.160000e+04,
        -2.100000e+04, -1.620000e+04, -3.770000e+04, -5.800000e+03,
         1.542000e+05,  1.542000e+05, -2.340000e+04, -7.400000e+03,
        -3.000000e+03,  1.313000e+05,  1.469000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.300000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.570000e+04,
         1.468000e+05, -9.800000e+03,  4.000000e+02, -1.160000e+04,
         3.570000e+04,  0.000000e+00, -7.500000e+03,  2.420000e+04,
         2.018000e+05,  2.850000e+04,  2.140000e+05, -3.910000e+04,
         1.545000e+05,  1.160000e+04,  2.930000e+04, -4.180000e+04,
        -2.430000e+04, -6.500000e+03, -8.200000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         3.570000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-7.500000e+03,  2.430000e+04,  2.280000e+04,  3.566000e+05,
         1.741000e+05, -4.600000e+04, -3.110000e+04, -5.200000e+03,
         2.430000e+04, -4.700000e+03,  2.420000e+04,  1.430000e+04,
         2.840000e+04, -7.480000e+04,  0.000000e+00,  1.430000e+04,
         1.987000e+05,  1.440000e+04,  3.300000e+03,  5.740000e+04,
         0.000000e+00, -3.190000e+04,  1.370000e+04,  1.470000e+04,
         5.147000e+05,  5.900000e+05,  7.690000e+04,  4.340000e+04,
         6.043000e+05,  6.940000e+04,  1.584000e+05,  1.005000e+05,
         3.252300e+06, -3.910000e+04, -3.910000e+04, -3.910000e+04,
        -3.910000e+04, -7.570000e+04, -3.910000e+04, -4.914000e+05,
        -4.308000e+05, -4.292000e+05, -6.060000e+04, -4.550000e+04,
        -4.510000e+04,  5.325000e+05,  8.701000e+05,  3.130000e+05,
         3.131000e+05,  3.477000e+05,  3.844000e+05,  3.480000e+05,
         1.556000e+05,  6.449000e+05,  6.600000e+05,  8.332000e+05,
         2.792000e+05,  3.733000e+05,  5.584000e+05,  8.678000e+05,
        -1.360000e+04, -1.360000e+04,  1.680000e+04,  1.740000e+04,
        -6.380000e+04,  4.480000e+04, -5.000000e+03, -6.880000e+04,
         1.846000e+05,  2.410000e+05,  2.740000e+04, -1.480000e+04,
         2.930000e+04,  2.850000e+04,  2.850000e+04,  2.850000e+04,
         2.850000e+04,  6.000000e+04,  6.000000e+04, -6.040000e+04,
         2.140000e+05,  2.299000e+05, -6.300000e+03,  0.000000e+00,
         2.620000e+04,  3.130000e+04,  1.216000e+05,  1.102000e+05,
         2.590000e+04,  2.590000e+04,  2.014000e+05,  2.013000e+05,
         2.067000e+05,  5.063000e+05,  5.855000e+05,  3.249000e+05,
         3.004000e+05,  6.580000e+04,  1.129000e+05, -4.750000e+04,
         1.767000e+05,  1.355000e+05,  2.456000e+05,  1.355000e+05,
         2.457000e+05, -4.220000e+04, -3.133000e+05, -4.022000e+05,
        -2.508000e+05, -2.490000e+04, -9.800000e+03,  3.238000e+05,
        -6.330000e+04,  2.590000e+04,  4.110000e+04, -4.550000e+04,
         8.060000e+04, -5.210000e+04, -5.900000e+03, -5.500000e+03,
        -1.413000e+05, -3.590000e+04,  7.880000e+04, -7.520000e+04,
        -1.641000e+05,  1.380000e+04,  6.000000e+02,  2.500000e+03,
        -8.560000e+04, -5.530000e+04,  6.740000e+04,  7.850000e+04,
         1.238000e+05, -1.070000e+04,  6.810000e+04, -3.520000e+04,
         1.257000e+05,  7.770000e+04, -4.100000e+03,  3.525000e+05,
         3.872000e+05,  5.200000e+03,  5.200000e+03,  5.420000e+04,
         1.519000e+05,  7.620000e+04,  1.796000e+05,  2.930000e+04,
         2.930000e+04,  1.160000e+04,  1.160000e+04,  1.545000e+05,
         1.150000e+04,  2.650000e+04,  1.160000e+04,  3.570000e+04,
         3.570000e+04,  3.570000e+04,  3.570000e+04,  3.370000e+04,
        -4.190000e+04, -4.180000e+04, -4.180000e+04, -9.060000e+04,
        -1.400000e+03,  0.000000e+00, -2.320000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.511000e+05, -6.010000e+04, -2.430000e+04,
         6.180000e+05,  2.263000e+05,  2.267000e+05,  3.339000e+05,
         3.339000e+05, -6.400000e+03,  1.469000e+05, -6.500000e+03,
        -1.580000e+04, -3.400000e+03, -4.700000e+03, -1.300000e+03,
        -7.480000e+04,  1.430000e+04, -1.160000e+04,  4.000000e+02,
         0.000000e+00, -3.000000e+02, -9.900000e+03, -2.810000e+04,
        -1.260000e+04, -8.200000e+03, -8.200000e+03, -8.200000e+03,
         0.000000e+00,  0.000000e+00, -9.620000e+04, -8.110000e+04,
        -1.780000e+04, -1.090000e+04, -4.380000e+04, -1.160000e+04,
        -2.100000e+04, -1.620000e+04, -3.770000e+04, -5.800000e+03,
         1.543000e+05,  1.542000e+05, -2.340000e+04, -7.400000e+03,
        -3.000000e+03,  1.313000e+05,  1.469000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.300000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.580000e+04,
         1.469000e+05, -9.800000e+03,  4.000000e+02, -1.160000e+04,
         3.570000e+04,  0.000000e+00, -7.500000e+03,  2.430000e+04,
         2.013000e+05,  2.850000e+04,  2.140000e+05, -3.910000e+04,
         1.545000e+05,  1.160000e+04,  2.930000e+04, -4.180000e+04,
        -2.430000e+04, -6.500000e+03, -8.200000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         3.570000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 7.662000e+05,  2.588000e+05,  2.811000e+05,  6.275000e+05,
         6.950000e+05,  3.219500e+06,  1.687200e+06,  7.461000e+05,
         2.587000e+05,  7.419000e+05,  2.581000e+05,  5.591000e+05,
         3.206000e+05, -5.663000e+05,  0.000000e+00,  5.591000e+05,
         5.144000e+05,  5.571000e+05,  3.670000e+04,  2.241700e+06,
         0.000000e+00,  1.124600e+06,  3.577000e+05,  4.030000e+05,
         9.474000e+05,  1.428900e+06,  8.234000e+05,  1.690800e+06,
         1.515200e+06,  1.634000e+06,  2.767200e+06,  1.118500e+06,
         6.634000e+06, -2.147000e+05, -2.143000e+05, -2.153000e+05,
        -2.125000e+05, -5.311000e+05, -2.144000e+05, -1.612000e+06,
        -2.633900e+06, -2.574100e+06, -6.700000e+03, -2.603000e+05,
        -2.472000e+05,  1.315000e+06,  1.379200e+06,  5.157000e+05,
         5.157000e+05,  7.538000e+05,  9.937000e+05,  7.659000e+05,
         2.924000e+05,  1.519500e+06,  1.264900e+06,  2.455200e+06,
         8.180000e+04,  1.209500e+06,  1.134600e+06,  1.394500e+06,
         1.045200e+06,  1.045200e+06,  5.359000e+05,  5.642000e+05,
         1.999000e+06,  9.736000e+05,  8.859000e+05,  2.760600e+06,
         4.631000e+05,  8.739000e+05,  2.733000e+05, -1.114000e+05,
         3.184000e+05,  1.128800e+06,  1.128800e+06,  1.128700e+06,
         1.128800e+06,  6.104000e+05,  6.104000e+05, -4.800000e+03,
         1.112600e+06,  8.543000e+05, -4.890000e+04,  0.000000e+00,
         1.897000e+05,  2.335000e+05, -6.180000e+04,  5.013000e+05,
         2.795000e+05,  2.795000e+05,  5.064000e+05,  5.062000e+05,
         5.063000e+05,  4.292200e+06,  2.975800e+06,  1.999100e+06,
         1.994700e+06,  1.949500e+06,  1.168400e+06,  8.470000e+05,
         1.652000e+06,  4.304200e+06,  2.489800e+06,  4.304200e+06,
         2.487800e+06,  2.034200e+06, -7.386000e+05, -1.872700e+06,
        -1.771500e+06,  3.504000e+05,  9.590000e+04,  3.406400e+06,
        -6.828000e+05,  4.475000e+05,  1.912000e+05, -2.639000e+05,
        -2.737000e+05,  5.245000e+05, -2.544000e+05, -1.971000e+05,
        -6.059000e+05,  9.077000e+05,  2.055600e+06,  1.532200e+06,
         4.014000e+05,  2.663100e+06,  2.596000e+05,  3.296000e+05,
         3.491000e+05, -1.599000e+05,  8.306000e+05,  2.047500e+06,
         1.286500e+06,  9.162000e+05,  8.398000e+05,  9.434000e+05,
         1.267100e+06,  1.955600e+06,  1.269000e+05,  7.961000e+05,
         1.034200e+06,  1.321300e+06,  1.321300e+06,  5.639000e+05,
         1.577000e+06,  2.849600e+06,  2.199340e+07,  3.018000e+05,
         3.022000e+05, -1.163000e+05, -1.164000e+05,  2.930000e+05,
        -1.164000e+05, -3.700000e+05, -1.164000e+05,  3.516000e+05,
         3.516000e+05,  3.516000e+05,  3.516000e+05,  3.717000e+05,
        -4.009000e+05, -4.007000e+05, -4.007000e+05, -4.158000e+05,
         7.103000e+05,  0.000000e+00, -2.440000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.405200e+06, -8.316000e+05, -4.741000e+05,
         1.010800e+06,  9.959000e+05,  9.956000e+05,  2.050200e+06,
         2.050200e+06, -4.930000e+04,  1.341000e+05, -3.320000e+04,
         1.504000e+05, -7.050000e+04, -3.410000e+04, -2.910000e+04,
        -5.663000e+05,  5.595000e+05, -8.590000e+04, -3.600000e+03,
         0.000000e+00, -3.000000e+02, -4.920000e+04,  1.481000e+05,
        -7.590000e+04, -8.220000e+04, -8.210000e+04, -8.210000e+04,
         0.000000e+00,  0.000000e+00, -3.642000e+05, -6.102000e+05,
        -1.305000e+05,  3.980000e+04,  2.984000e+05, -7.010000e+04,
         2.008000e+05,  1.546000e+05, -2.870000e+05, -4.290000e+04,
         1.319000e+05,  1.320000e+05,  1.829000e+05, -4.670000e+04,
        -2.060000e+04,  3.216000e+05,  8.610000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02, -1.700000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.504000e+05,
         1.341000e+05, -7.430000e+04, -3.600000e+03, -8.590000e+04,
         3.516000e+05, -1.000000e+02,  7.662000e+05,  2.588000e+05,
         5.062000e+05,  1.128800e+06,  1.112600e+06, -2.127000e+05,
         2.930000e+05, -1.164000e+05,  3.022000e+05, -4.007000e+05,
        -4.741000e+05, -3.320000e+04, -8.210000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         3.516000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 9.530000e+04,  1.206900e+06,  2.765000e+05,  7.170000e+05,
         4.058000e+05,  2.570000e+05,  6.620000e+04,  1.128000e+05,
         1.206700e+06,  1.162000e+05,  1.203500e+06,  2.634000e+05,
         8.041000e+05, -6.158000e+05,  0.000000e+00,  2.634000e+05,
         5.913000e+05,  2.650000e+05,  9.310000e+04,  1.053400e+06,
         0.000000e+00,  1.615000e+05,  1.744900e+06,  4.492000e+05,
         1.118000e+06,  2.400800e+06,  3.038400e+06,  7.786000e+05,
         1.759100e+06,  1.539100e+06,  2.415200e+06,  2.643400e+06,
         6.917900e+06, -1.846000e+05, -1.845000e+05, -1.830000e+05,
        -1.855000e+05, -5.546000e+05, -1.844000e+05, -2.994800e+06,
        -8.861000e+05, -2.611200e+06, -3.536000e+05,  1.693000e+05,
        -2.577000e+05,  1.117300e+06,  1.570800e+06,  6.520000e+05,
         6.519000e+05,  1.294600e+06,  1.936800e+06,  8.951000e+05,
         3.880000e+05,  1.452000e+06,  1.977100e+06,  5.190700e+06,
         1.084000e+05,  9.985000e+05,  1.303300e+06,  1.584500e+06,
         5.816000e+05,  5.817000e+05,  1.651800e+06,  7.734000e+05,
        -1.846000e+05,  6.440000e+05,  1.426000e+05, -8.400000e+04,
         4.909000e+05,  1.024900e+06,  3.285000e+05, -1.770000e+05,
         3.580000e+05,  5.186000e+05,  5.186000e+05,  5.186000e+05,
         5.187000e+05,  1.638900e+06,  1.638900e+06, -3.569000e+05,
         8.855000e+05,  2.202800e+06, -4.820000e+04,  0.000000e+00,
         5.876000e+05,  2.608000e+05, -3.800000e+04,  6.137000e+05,
         3.140000e+05,  3.140000e+05,  5.856000e+05,  5.854000e+05,
         5.855000e+05,  2.975800e+06,  7.378100e+06,  1.186500e+06,
         7.629000e+05,  1.108700e+06,  2.786700e+06, -2.252000e+05,
         3.969800e+06,  2.243400e+06,  6.164200e+06,  2.243400e+06,
         6.167800e+06,  4.955000e+05, -2.279300e+06, -3.154300e+06,
        -6.050000e+04,  7.400000e+04,  5.988000e+05,  1.176120e+07,
        -5.238000e+05,  3.514000e+05,  8.790000e+05, -2.351000e+05,
        -2.291000e+05, -4.173000e+05,  1.242100e+06, -1.295000e+05,
        -1.292900e+06, -1.118000e+05,  1.201400e+06, -1.705000e+05,
        -1.047500e+06,  7.064000e+05,  2.454900e+06,  3.090000e+05,
        -2.838000e+05,  7.663000e+05,  1.098500e+06,  1.205400e+06,
         2.774000e+06,  3.314000e+05,  1.111700e+06, -1.414000e+05,
         2.889900e+06,  1.345600e+06,  2.341000e+05,  9.671000e+05,
         1.609900e+06,  3.394000e+05,  3.396000e+05,  2.026600e+06,
         4.249800e+06,  1.624300e+06,  6.531600e+06,  3.797000e+05,
         3.802000e+05,  9.250000e+04,  9.260000e+04,  3.838000e+05,
         9.270000e+04, -6.170000e+04,  9.260000e+04,  4.318000e+05,
         4.317000e+05,  4.317000e+05,  4.313000e+05,  4.141000e+05,
        -4.585000e+05, -4.581000e+05, -4.582000e+05, -7.374000e+05,
         1.414000e+05,  0.000000e+00, -2.681000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.750300e+06, -7.608000e+05, -3.340000e+05,
         1.293800e+06,  1.248800e+06,  1.250400e+06,  2.545900e+06,
         2.545900e+06, -5.130000e+04,  1.320000e+05, -7.370000e+04,
        -1.214000e+05,  4.054000e+05,  2.648000e+05, -2.390000e+04,
        -6.158000e+05,  2.630000e+05,  6.572000e+05,  2.900000e+03,
         0.000000e+00, -5.900000e+03, -1.264000e+05, -2.331000e+05,
         2.759000e+05, -9.880000e+04, -9.890000e+04, -9.890000e+04,
         0.000000e+00,  0.000000e+00, -7.837000e+05, -2.595000e+05,
         1.013000e+06,  1.476000e+05, -3.545000e+05,  2.551000e+05,
        -1.658000e+05, -1.243000e+05, -3.131000e+05,  3.280000e+05,
         1.420000e+05,  1.421000e+05, -1.636000e+05,  3.511000e+05,
        -2.880000e+04, -1.070000e+04,  4.949000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02, -3.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.214000e+05,
         1.320000e+05, -8.080000e+04,  2.900000e+03,  6.572000e+05,
         4.317000e+05,  1.000000e+02,  9.530000e+04,  1.206900e+06,
         5.854000e+05,  5.186000e+05,  8.855000e+05, -1.854000e+05,
         3.838000e+05,  9.260000e+04,  3.802000e+05, -4.582000e+05,
        -3.340000e+05, -7.370000e+04, -9.890000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.318000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 3.566000e+05,  5.170000e+04,  9.200000e+04,  5.216000e+05,
         4.379000e+05,  1.522000e+06,  8.088000e+05,  3.449000e+05,
         5.170000e+04,  3.424000e+05,  5.160000e+04,  2.293000e+05,
         8.590000e+04,  5.982000e+05,  0.000000e+00,  2.293000e+05,
         3.285000e+05,  2.277000e+05,  9.700000e+03,  9.224000e+05,
         0.000000e+00,  1.305900e+06,  8.379000e+05,  9.108000e+05,
         1.596300e+06,  9.300000e+05,  1.840000e+05,  7.088000e+05,
         9.722000e+05,  2.084000e+06,  1.717400e+06,  1.767800e+06,
         9.824200e+06,  6.965000e+05,  6.979000e+05,  6.971000e+05,
         6.957000e+05,  7.966000e+05,  6.980000e+05,  6.672300e+06,
         6.054900e+06,  6.145600e+06,  8.300000e+05,  6.759000e+05,
         6.984000e+05,  9.545000e+05,  1.241600e+06,  1.683800e+06,
         1.683800e+06,  1.348800e+06,  1.015400e+06,  1.367800e+06,
         1.042000e+06,  3.182900e+06,  3.027900e+06,  1.352900e+06,
         1.150400e+06,  7.685000e+05,  8.471000e+05,  1.251200e+06,
         1.959900e+06,  1.960000e+06,  1.649900e+06,  1.696600e+06,
         1.001500e+06,  3.732000e+05,  4.092000e+05,  1.366200e+06,
         3.092000e+05,  4.321000e+05,  7.870000e+04, -4.330000e+04,
         7.470000e+04,  4.692000e+05,  4.692000e+05,  4.691000e+05,
         4.692000e+05,  1.501000e+05,  1.501000e+05,  8.384000e+05,
         5.885000e+05,  4.315000e+05, -2.630000e+04,  0.000000e+00,
        -3.510000e+05, -3.268000e+05,  9.305000e+05,  6.387000e+05,
         8.390000e+04,  8.390000e+04,  3.249000e+05,  3.249000e+05,
         3.249000e+05,  1.999100e+06,  1.186500e+06,  2.881000e+06,
         1.988800e+06,  7.552000e+05,  2.747000e+05,  4.283000e+05,
        -3.697000e+05,  1.744900e+06,  6.282000e+05,  1.744900e+06,
         6.238000e+05,  2.467100e+06,  3.139300e+06,  3.507200e+06,
         2.505100e+06,  9.339000e+05,  7.790000e+05,  7.764000e+05,
         5.243000e+05,  1.606000e+05,  4.400000e+03,  6.723000e+05,
         1.641300e+06,  3.348000e+05, -1.424000e+05, -6.020000e+04,
         6.985000e+05,  4.401000e+05,  8.164000e+05,  1.560000e+06,
         1.932100e+06,  1.187800e+06,  7.850000e+05,  9.016000e+05,
         1.769500e+06,  1.459500e+06,  9.795000e+05,  8.077000e+05,
         3.452000e+05,  1.170800e+06,  9.926000e+05,  4.881000e+05,
         3.236000e+05,  7.240000e+05,  7.785000e+05,  1.371100e+06,
         1.036100e+06,  5.880000e+05,  5.879000e+05,  1.269000e+05,
         9.466000e+05,  1.721500e+06,  9.665400e+06,  7.380000e+04,
         7.390000e+04, -7.420000e+04, -7.430000e+04,  1.046200e+06,
        -7.420000e+04, -9.450000e+05, -7.430000e+04,  9.840000e+04,
         9.840000e+04,  9.840000e+04,  9.850000e+04,  1.126000e+05,
        -1.387000e+05, -1.386000e+05, -1.387000e+05,  6.916000e+05,
         3.236000e+05,  0.000000e+00, -8.060000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -8.323000e+05, -2.869000e+05, -1.807000e+05,
         3.341200e+06,  1.241700e+06,  1.240300e+06,  1.535500e+06,
         1.535600e+06, -2.440000e+04,  1.997000e+05, -2.370000e+04,
         9.320000e+04, -3.910000e+04, -1.680000e+04, -9.600000e+03,
         5.982000e+05,  2.299000e+05, -4.370000e+04, -2.400000e+03,
         0.000000e+00, -2.000000e+02, -1.440000e+04,  8.690000e+04,
        -4.210000e+04, -2.370000e+04, -2.360000e+04, -2.360000e+04,
         0.000000e+00,  0.000000e+00,  7.356000e+05,  5.800000e+05,
        -6.410000e+04,  2.850000e+04,  1.801000e+05, -3.900000e+04,
         1.346000e+05,  9.560000e+04,  2.941000e+05, -2.180000e+04,
         2.034000e+05,  2.034000e+05,  1.102000e+05, -2.330000e+04,
        -5.800000e+03,  3.182000e+05,  1.806000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02, -2.400000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  9.320000e+04,
         1.997000e+05,  7.850000e+04, -2.400000e+03, -4.370000e+04,
         9.840000e+04,  1.000000e+02,  3.566000e+05,  5.170000e+04,
         3.249000e+05,  4.692000e+05,  5.885000e+05,  6.958000e+05,
         1.046200e+06, -7.430000e+04,  7.390000e+04, -1.387000e+05,
        -1.807000e+05, -2.370000e+04, -2.360000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         9.840000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 5.020000e+05,  3.300000e+03,  5.950000e+04,  5.471000e+05,
         5.229000e+05,  2.185900e+06,  1.182100e+06,  4.772000e+05,
         3.300000e+03,  4.723000e+05,  3.300000e+03,  2.637000e+05,
         3.340000e+04,  2.629000e+05,  0.000000e+00,  2.637000e+05,
         3.037000e+05,  2.626000e+05,  3.500000e+03,  1.051200e+06,
         0.000000e+00,  1.037900e+06,  3.168000e+05,  3.762000e+05,
         1.193200e+06,  8.789000e+05,  2.320000e+04,  7.697000e+05,
         8.972000e+05,  1.034000e+06,  1.032400e+06,  5.470000e+05,
         7.836600e+06,  2.872000e+05,  2.875000e+05,  2.867000e+05,
         2.860000e+05,  3.403000e+05,  2.877000e+05,  3.488100e+06,
         2.524100e+06,  2.605800e+06,  5.245000e+05,  2.804000e+05,
         3.040000e+05,  1.065100e+06,  1.341600e+06,  1.061800e+06,
         1.061900e+06,  9.053000e+05,  7.486000e+05,  9.209000e+05,
         6.098000e+05,  2.209900e+06,  1.967500e+06,  1.184900e+06,
         8.439000e+05,  8.285000e+05,  8.482000e+05,  1.350100e+06,
         1.111800e+06,  1.112000e+06,  6.320000e+05,  6.707000e+05,
         1.541900e+06,  3.404000e+05,  5.564000e+05,  1.996300e+06,
         2.781000e+05,  3.331000e+05,  2.400000e+04, -3.430000e+04,
        -9.500000e+03,  5.181000e+05,  5.181000e+05,  5.180000e+05,
         5.181000e+05,  2.770000e+04,  2.760000e+04,  5.198000e+05,
         5.982000e+05,  3.485000e+05,  2.288100e+06,  0.000000e+00,
         2.117600e+06,  2.154200e+06,  5.728000e+05,  3.507000e+05,
         3.640000e+04,  3.640000e+04,  3.005000e+05,  3.004000e+05,
         3.004000e+05,  1.994700e+06,  7.629000e+05,  1.988800e+06,
         4.570000e+06,  5.371700e+06,  4.585800e+06,  7.666000e+06,
         4.308200e+06,  1.834900e+06,  1.184000e+05,  1.834900e+06,
         1.212000e+05,  1.838600e+06,  2.040400e+06,  2.042900e+06,
         1.064100e+06,  5.460000e+05,  3.033000e+05,  1.075000e+05,
         1.349000e+05,  1.302000e+05, -1.103000e+05,  2.553900e+06,
         8.735000e+05,  5.780000e+05, -1.579000e+05, -8.370000e+04,
         5.825000e+05,  3.013200e+06,  7.933000e+05,  1.519300e+06,
         1.520400e+06,  1.518300e+06,  3.071000e+05,  4.165000e+05,
         1.067600e+06,  5.827000e+05,  3.559000e+05,  7.981000e+05,
         6.570000e+04,  8.034000e+05,  3.602000e+05,  2.985000e+06,
         6.600000e+04,  7.364000e+05,  3.056000e+05,  9.167000e+05,
         7.602000e+05,  7.674000e+05,  7.673000e+05,  1.740000e+04,
         2.497000e+05,  1.462000e+06,  1.222500e+07,  2.281600e+06,
         2.284300e+06, -1.282000e+05, -1.282000e+05,  6.157000e+05,
        -1.281000e+05, -5.684000e+05, -1.282000e+05,  2.430000e+04,
         2.430000e+04,  2.430000e+04,  2.440000e+04,  5.260000e+04,
         2.558200e+06,  2.556400e+06,  2.556800e+06,  4.352000e+05,
         4.353000e+05,  0.000000e+00,  1.296700e+06,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.534650e+07, -1.676000e+05, -1.479000e+05,
         2.098500e+06,  6.626000e+05,  6.607000e+05,  7.341000e+05,
         7.342000e+05,  2.257600e+06,  2.489000e+05, -3.390000e+04,
         1.725000e+05, -3.940000e+04, -7.800000e+03, -7.300000e+03,
         2.629000e+05,  2.632000e+05, -2.180000e+04, -4.100000e+03,
         0.000000e+00, -3.000000e+02, -1.640000e+04,  1.764000e+05,
        -4.010000e+04, -7.200000e+03, -7.000000e+03, -7.000000e+03,
         0.000000e+00,  0.000000e+00,  5.001000e+05,  2.562000e+05,
        -3.000000e+04,  7.080000e+04,  3.487000e+05, -3.710000e+04,
         2.322000e+05,  1.781000e+05,  1.296000e+05, -1.080000e+04,
         2.522000e+05,  2.522000e+05,  2.107000e+05, -1.280000e+04,
        -3.000000e+02,  4.689000e+05,  2.401000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02, -3.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.000000e+02,  1.725000e+05,
         2.489000e+05,  3.450000e+04, -4.100000e+03, -2.180000e+04,
         2.430000e+04,  1.000000e+02,  5.020000e+05,  3.300000e+03,
         3.004000e+05,  5.181000e+05,  5.982000e+05,  2.862000e+05,
         6.157000e+05, -1.282000e+05,  2.284300e+06,  2.556900e+06,
        -1.479000e+05, -3.390000e+04, -7.000000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.430000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 4.594000e+05,  1.372000e+05,  1.485000e+05, -5.030000e+04,
         2.037000e+05,  1.941000e+06,  1.022400e+06,  4.478000e+05,
         1.372000e+05,  4.455000e+05,  1.368000e+05,  3.273000e+05,
         1.749000e+05, -2.726000e+05,  0.000000e+00,  3.273000e+05,
         6.590000e+04,  3.265000e+05,  2.000000e+04,  1.308800e+06,
         0.000000e+00,  7.117000e+05,  2.083000e+05,  2.472000e+05,
        -7.790000e+04,  1.572000e+05,  4.350000e+05,  9.859000e+05,
         1.948000e+05,  9.366000e+05,  1.537000e+06,  6.002000e+05,
        -1.614000e+05, -9.120000e+04, -9.140000e+04, -9.160000e+04,
        -8.950000e+04, -2.493000e+05, -9.130000e+04, -5.097000e+05,
        -1.179500e+06, -1.129100e+06,  4.950000e+04, -1.136000e+05,
        -1.053000e+05,  1.523000e+05, -2.166000e+05, -9.920000e+04,
        -9.920000e+04,  1.780000e+04,  1.357000e+05,  3.050000e+04,
        -2.690000e+04,  8.160000e+04, -8.360000e+04,  5.014000e+05,
        -3.235000e+05,  2.699000e+05,  1.540000e+04, -2.145000e+05,
         6.524000e+05,  6.525000e+05,  3.184000e+05,  3.428000e+05,
         1.231000e+06,  5.525000e+05,  5.315000e+05,  1.698200e+06,
         5.300000e+04,  2.518000e+05,  1.403000e+05, -5.180000e+04,
         1.705000e+05,  6.560000e+05,  6.560000e+05,  6.560000e+05,
         6.560000e+05,  3.186000e+05,  3.185000e+05,  5.570000e+04,
         3.888000e+05,  2.248000e+05,  4.832700e+06,  0.000000e+00,
         4.916300e+06,  4.968600e+06, -2.076000e+05,  1.661000e+05,
         1.456000e+05,  1.456000e+05,  6.580000e+04,  6.580000e+04,
         6.580000e+04,  1.949500e+06,  1.108700e+06,  7.552000e+05,
         5.371700e+06,  1.089860e+07,  1.025120e+07,  1.541370e+07,
         1.049460e+07,  2.485800e+06,  1.304500e+06,  2.485700e+06,
         1.296300e+06,  1.275000e+06, -1.605000e+05, -7.619000e+05,
        -8.340000e+05,  2.392000e+05,  7.420000e+04,  1.793700e+06,
        -3.518000e+05,  2.498000e+05,  8.160000e+04,  4.713200e+06,
        -2.999000e+05,  3.576000e+05, -1.451000e+05, -1.069000e+05,
        -2.437000e+05,  5.371500e+06,  1.180800e+06,  9.832000e+05,
         3.858000e+05,  1.580500e+06,  1.571000e+05,  2.090000e+05,
         2.970000e+05, -3.340000e+04,  4.477000e+05,  1.175000e+06,
         6.857000e+05,  5.711000e+05,  4.525000e+05,  5.427100e+06,
         6.592000e+05,  1.114400e+06,  8.480000e+04,  3.800000e+04,
         1.550000e+05,  7.819000e+05,  7.819000e+05,  2.966000e+05,
         8.271000e+05,  1.653200e+06,  1.297990e+07,  4.971100e+06,
         4.977400e+06, -7.930000e+04, -7.940000e+04, -2.770000e+04,
        -7.930000e+04, -2.488000e+05, -7.940000e+04,  1.813000e+05,
         1.813000e+05,  1.813000e+05,  1.815000e+05,  2.074000e+05,
         4.400100e+06,  4.396900e+06,  4.397600e+06, -1.716000e+05,
         4.284000e+05,  0.000000e+00,  2.682900e+06,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.639580e+07, -4.594000e+05, -2.695000e+05,
        -1.977000e+05,  3.353000e+05,  3.357000e+05,  8.798000e+05,
         8.798000e+05,  4.790300e+06, -1.050000e+05, -1.080000e+04,
         1.010000e+05, -4.240000e+04, -1.590000e+04, -1.650000e+04,
        -2.726000e+05,  3.274000e+05, -3.950000e+04, -2.400000e+03,
         0.000000e+00,  1.000000e+02, -1.490000e+04,  1.171000e+05,
        -3.140000e+04, -4.220000e+04, -4.220000e+04, -4.220000e+04,
         0.000000e+00,  0.000000e+00, -1.343000e+05, -2.937000e+05,
        -6.070000e+04,  3.240000e+04,  2.180000e+05, -2.900000e+04,
         1.376000e+05,  1.035000e+05, -1.383000e+05, -1.970000e+04,
        -1.147000e+05, -1.147000e+05,  1.311000e+05, -2.060000e+04,
        -9.700000e+03,  1.360000e+04, -1.358000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02,  7.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.000000e+02,  1.010000e+05,
        -1.050000e+05, -3.580000e+04, -2.400000e+03, -3.950000e+04,
         1.813000e+05,  1.000000e+02,  4.594000e+05,  1.372000e+05,
         6.580000e+04,  6.560000e+05,  3.888000e+05, -8.960000e+04,
        -2.770000e+04, -7.940000e+04,  4.977400e+06,  4.397800e+06,
        -2.695000e+05, -1.080000e+04, -4.220000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.813000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 5.780000e+04,  7.058000e+05,  1.454000e+05,  2.900000e+03,
         3.050000e+04,  1.682000e+05,  5.250000e+04,  6.850000e+04,
         7.057000e+05,  7.080000e+04,  7.038000e+05,  1.499000e+05,
         4.645000e+05, -3.015000e+05,  0.000000e+00,  1.499000e+05,
         1.123000e+05,  1.513000e+05,  5.390000e+04,  5.951000e+05,
         0.000000e+00,  1.318000e+05,  1.039800e+06,  2.711000e+05,
         2.270000e+04,  7.393000e+05,  1.762500e+06,  4.351000e+05,
         3.400000e+05,  8.769000e+05,  1.321400e+06,  1.513400e+06,
         3.300000e+03, -7.300000e+04, -7.240000e+04, -7.150000e+04,
        -7.330000e+04, -2.628000e+05, -7.220000e+04, -1.334300e+06,
        -1.216000e+05, -1.148600e+06, -1.570000e+05,  1.447000e+05,
        -1.106000e+05,  3.330000e+04, -1.026000e+05, -1.930000e+04,
        -1.940000e+04,  3.415000e+05,  7.003000e+05,  1.056000e+05,
         2.970000e+04,  3.770000e+04,  3.398000e+05,  2.144200e+06,
        -3.077000e+05,  1.436000e+05,  1.158000e+05, -1.008000e+05,
         3.724000e+05,  3.725000e+05,  9.874000e+05,  4.652000e+05,
        -7.490000e+04,  3.523000e+05,  8.590000e+04, -7.400000e+03,
         6.800000e+04,  3.419000e+05,  1.730000e+05, -9.090000e+04,
         1.938000e+05,  2.881000e+05,  2.881000e+05,  2.880000e+05,
         2.881000e+05,  9.346000e+05,  9.346000e+05, -1.556000e+05,
         2.540000e+05,  5.778000e+05,  4.792900e+06,  0.000000e+00,
         5.181500e+06,  4.944200e+06, -1.934000e+05,  2.319000e+05,
         1.660000e+05,  1.660000e+05,  1.129000e+05,  1.128000e+05,
         1.129000e+05,  1.168400e+06,  2.786700e+06,  2.747000e+05,
         4.585800e+06,  1.025120e+07,  2.391360e+07,  1.420120e+07,
         1.193550e+07,  1.236200e+06,  3.499200e+06,  1.236200e+06,
         3.500200e+06,  3.468000e+05, -1.081200e+06, -1.525100e+06,
         1.982000e+05,  7.170000e+04,  3.738000e+05,  6.800600e+06,
        -2.556000e+05,  1.898000e+05,  4.925000e+05,  4.763200e+06,
        -2.725000e+05, -2.076000e+05,  7.533000e+05, -6.840000e+04,
        -6.531000e+05,  4.818900e+06,  6.625000e+05, -3.870000e+04,
        -4.821000e+05,  4.047000e+05,  1.471900e+06,  1.934000e+05,
        -8.550000e+04,  5.188000e+05,  6.069000e+05,  6.602000e+05,
         1.565200e+06,  2.152000e+05,  6.148000e+05,  4.822200e+06,
         1.631000e+06,  7.484000e+05,  1.487000e+05,  1.388000e+05,
         4.997000e+05,  1.926000e+05,  1.927000e+05,  1.173400e+06,
         2.428000e+06,  9.175000e+05,  3.688100e+06,  5.068700e+06,
         5.077400e+06,  4.600000e+04,  4.610000e+04,  2.570000e+04,
         4.620000e+04, -6.420000e+04,  4.610000e+04,  2.288000e+05,
         2.288000e+05,  2.288000e+05,  2.287000e+05,  2.322000e+05,
         4.307400e+06,  4.304300e+06,  4.304900e+06, -3.632000e+05,
         8.750000e+04,  0.000000e+00,  2.645400e+06,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.583950e+07, -4.131000e+05, -1.835000e+05,
        -3.090000e+04,  4.849000e+05,  4.865000e+05,  1.173300e+06,
         1.173500e+06,  4.840600e+06, -1.059000e+05, -3.510000e+04,
        -6.150000e+04,  2.433000e+05,  1.635000e+05, -1.340000e+04,
        -3.015000e+05,  1.494000e+05,  4.066000e+05,  1.500000e+03,
         0.000000e+00, -3.200000e+03, -6.210000e+04, -1.111000e+05,
         1.796000e+05, -5.200000e+04, -5.210000e+04, -5.210000e+04,
         0.000000e+00,  0.000000e+00, -3.842000e+05, -8.230000e+04,
         6.255000e+05,  9.740000e+04, -1.725000e+05,  1.661000e+05,
        -8.170000e+04, -6.300000e+04, -1.536000e+05,  2.030000e+05,
        -1.082000e+05, -1.082000e+05, -7.630000e+04,  2.179000e+05,
        -1.450000e+04, -1.843000e+05,  1.099000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.000000e+02,  1.600000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.000000e+02, -6.150000e+04,
        -1.059000e+05, -3.960000e+04,  1.500000e+03,  4.066000e+05,
         2.288000e+05,  2.000000e+02,  5.780000e+04,  7.058000e+05,
         1.128000e+05,  2.881000e+05,  2.540000e+05, -7.330000e+04,
         2.570000e+04,  4.610000e+04,  5.077400e+06,  4.305100e+06,
        -1.835000e+05, -3.510000e+04, -5.210000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.288000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 3.933000e+05, -1.840000e+04,  1.780000e+04, -7.670000e+04,
         1.574000e+05,  1.727100e+06,  9.406000e+05,  3.747000e+05,
        -1.850000e+04,  3.711000e+05, -1.850000e+04,  1.942000e+05,
         2.500000e+03, -1.840000e+04,  0.000000e+00,  1.942000e+05,
        -4.960000e+04,  1.932000e+05,  0.000000e+00,  7.749000e+05,
         0.000000e+00,  5.610000e+05, -8.350000e+04, -3.700000e+03,
        -1.614000e+05, -1.369000e+05, -5.860000e+04,  5.807000e+05,
        -1.462000e+05,  1.034000e+05,  3.159000e+05, -3.261000e+05,
        -5.517000e+05, -4.280000e+04, -4.490000e+04, -4.440000e+04,
        -4.050000e+04, -3.420000e+04, -4.470000e+04,  5.114000e+05,
        -3.499000e+05, -2.415000e+05,  1.669000e+05, -4.040000e+04,
        -2.140000e+04,  7.960000e+04, -1.841000e+05, -1.489000e+05,
        -1.488000e+05, -1.383000e+05, -1.243000e+05, -1.088000e+05,
        -9.170000e+04, -7.430000e+04, -2.850000e+05, -2.328000e+05,
        -8.990000e+04,  1.101000e+05, -1.244000e+05, -1.836000e+05,
         2.712000e+05,  2.714000e+05, -1.569000e+05, -1.052000e+05,
         1.251200e+06,  2.330000e+05,  4.394000e+05,  1.640200e+06,
        -6.430000e+04, -6.900000e+04, -1.580000e+04, -6.600000e+03,
        -4.090000e+04,  3.867000e+05,  3.867000e+05,  3.867000e+05,
         3.867000e+05, -4.340000e+04, -4.350000e+04,  1.739000e+05,
         1.420000e+05, -6.750000e+04,  7.340100e+06,  0.000000e+00,
         7.203600e+06,  7.348800e+06, -6.610000e+04, -7.230000e+04,
        -3.800000e+03, -3.800000e+03, -4.750000e+04, -4.750000e+04,
        -4.750000e+04,  8.470000e+05, -2.252000e+05,  4.283000e+05,
         7.666000e+06,  1.541370e+07,  1.420120e+07,  6.217630e+07,
         1.431740e+07,  1.338700e+06, -1.670000e+05,  1.338600e+06,
        -1.770000e+05,  9.034000e+05,  7.201000e+05,  5.061000e+05,
        -1.394000e+05,  1.518000e+05, -5.850000e+04, -2.432000e+05,
        -1.362000e+05,  7.790000e+04, -1.371000e+05,  7.146900e+06,
        -1.112000e+05,  5.335000e+05, -1.082000e+05, -3.120000e+04,
         3.198000e+05,  7.720500e+06,  5.738000e+05,  9.714000e+05,
         7.622000e+05,  1.180600e+06, -8.190000e+04,  3.030000e+04,
         3.286000e+05, -9.270000e+04, -1.167000e+05,  5.668000e+05,
        -5.510000e+04,  3.497000e+05, -1.196000e+05,  7.787600e+06,
        -9.010000e+04,  4.839000e+05, -6.610000e+04, -1.390000e+05,
        -1.286000e+05,  5.892000e+05,  5.891000e+05, -3.980000e+04,
        -2.178000e+05,  8.355000e+05,  9.363300e+06,  7.115000e+06,
         7.120600e+06, -1.183000e+05, -1.184000e+05, -9.220000e+04,
        -1.182000e+05, -1.672000e+05, -1.184000e+05, -2.500000e+04,
        -2.500000e+04, -2.500000e+04, -2.460000e+04,  1.500000e+04,
         7.006800e+06,  7.001800e+06,  7.002800e+06,  1.315000e+05,
         3.440000e+05,  0.000000e+00,  4.248800e+06,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  4.203330e+07, -8.940000e+04, -1.041000e+05,
        -3.061000e+05, -1.419000e+05, -1.414000e+05, -2.162000e+05,
        -2.160000e+05,  7.140400e+06, -2.090000e+04, -1.590000e+04,
         1.499000e+05, -2.790000e+04,  2.300000e+03, -4.300000e+03,
        -1.840000e+04,  1.941000e+05,  5.300000e+03, -3.600000e+03,
         0.000000e+00,  0.000000e+00,  1.160000e+04,  1.741000e+05,
        -1.220000e+04,  4.700000e+03,  4.900000e+03,  4.900000e+03,
         0.000000e+00,  0.000000e+00,  1.876000e+05, -1.540000e+04,
         8.700000e+03,  6.930000e+04,  3.240000e+05, -1.130000e+04,
         2.049000e+05,  1.540000e+05, -8.400000e+03,  2.700000e+03,
        -2.940000e+04, -2.940000e+04,  1.930000e+05,  1.700000e+03,
         3.600000e+03,  1.603000e+05, -2.820000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.000000e+02, -7.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.000000e+02,  1.499000e+05,
        -2.090000e+04, -2.400000e+03, -3.600000e+03,  5.300000e+03,
        -2.500000e+04,  2.000000e+02,  3.933000e+05, -1.840000e+04,
        -4.750000e+04,  3.867000e+05,  1.420000e+05, -4.080000e+04,
        -9.220000e+04, -1.184000e+05,  7.120600e+06,  7.003100e+06,
        -1.041000e+05, -1.590000e+04,  4.900000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -2.500000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.039000e+05,  1.030400e+06,  1.928000e+05,  6.080000e+04,
         8.240000e+04,  3.443000e+05,  1.365000e+05,  1.161000e+05,
         1.030300e+06,  1.186000e+05,  1.028300e+06,  2.079000e+05,
         6.606000e+05, -8.090000e+05,  0.000000e+00,  2.079000e+05,
         1.758000e+05,  2.094000e+05,  7.650000e+04,  8.268000e+05,
         0.000000e+00, -2.005000e+05,  1.216000e+06, -5.490000e+04,
        -2.933000e+05,  1.327800e+06,  2.782600e+06,  6.091000e+05,
         5.319000e+05,  3.410000e+05,  1.348700e+06,  1.271900e+06,
        -1.673700e+06, -5.105000e+05, -5.106000e+05, -5.073000e+05,
        -5.106000e+05, -8.620000e+05, -5.104000e+05, -5.426400e+06,
        -3.537000e+06, -5.232300e+06, -6.062000e+05, -1.345000e+05,
        -5.576000e+05,  1.435000e+05,  7.900000e+03, -5.880000e+05,
        -5.920000e+05,  2.696000e+05,  1.016600e+06, -2.137000e+05,
        -3.464000e+05, -8.574000e+05, -3.855000e+05,  3.922400e+06,
        -7.583000e+05,  2.589000e+05,  2.376000e+05,  9.500000e+03,
        -3.107000e+05, -3.105000e+05,  6.297000e+05, -2.136000e+05,
        -7.300000e+03,  4.759000e+05,  1.437000e+05,  1.095000e+05,
         1.040000e+05,  4.759000e+05,  2.265000e+05, -1.372000e+05,
         2.352000e+05,  4.035000e+05,  4.035000e+05,  4.034000e+05,
         4.035000e+05,  1.329800e+06,  1.329800e+06, -6.032000e+05,
         3.742000e+05,  8.377000e+05,  4.794500e+06,  0.000000e+00,
         1.088640e+07,  5.199200e+06, -6.368000e+05,  1.170000e+05,
         2.183000e+05,  2.183000e+05,  1.767000e+05,  1.768000e+05,
         1.767000e+05,  1.652000e+06,  3.969800e+06, -3.697000e+05,
         4.308200e+06,  1.049460e+07,  1.193550e+07,  1.431740e+07,
         2.526100e+07,  1.710100e+06,  4.952400e+06,  1.710100e+06,
         4.954000e+06, -3.029000e+05, -3.010800e+06, -4.017600e+06,
        -1.152000e+06, -3.089000e+05,  1.630000e+05,  1.039690e+07,
        -7.561000e+05,  2.562000e+05,  7.289000e+05,  4.285300e+06,
        -1.156300e+06, -2.390000e+05,  1.153400e+06, -9.340000e+04,
        -1.251100e+06,  4.826600e+06,  9.050000e+05, -3.937000e+05,
        -1.401200e+06,  6.138000e+05,  1.965800e+06, -1.511000e+05,
        -9.172000e+05,  2.660000e+04,  3.848000e+05,  9.031000e+05,
         2.318200e+06, -1.080000e+05,  3.898000e+05,  4.825300e+06,
         2.294400e+06,  7.759000e+05, -2.125000e+05, -1.727000e+05,
         6.889000e+05,  2.939000e+05,  2.941000e+05,  1.695600e+06,
         3.219200e+06,  8.597000e+05,  5.488700e+06,  5.133200e+06,
         5.120000e+06,  5.300000e+04,  5.300000e+04, -3.466000e+05,
         5.320000e+04,  3.173000e+05,  5.300000e+04,  2.994000e+05,
         2.994000e+05,  2.994000e+05,  2.993000e+05,  3.006000e+05,
         4.250400e+06,  4.247400e+06,  4.248000e+06, -8.785000e+05,
         1.377000e+05,  0.000000e+00,  2.606600e+06,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.549790e+07, -5.458000e+05, -2.464000e+05,
        -1.153500e+06,  2.526000e+05,  2.529000e+05,  1.151600e+06,
         1.151800e+06,  4.813400e+06, -1.121000e+05, -6.430000e+04,
        -6.940000e+04,  3.723000e+05,  3.087000e+05, -1.760000e+04,
        -8.090000e+05,  2.074000e+05,  7.521000e+05,  1.600000e+03,
         0.000000e+00,  2.300000e+03, -9.610000e+04, -1.503000e+05,
         3.050000e+05, -6.810000e+04, -6.830000e+04, -6.830000e+04,
         0.000000e+00,  0.000000e+00, -9.011000e+05, -4.328000e+05,
         1.180900e+06,  2.318000e+05, -2.196000e+05,  2.820000e+05,
        -9.170000e+04, -7.120000e+04, -4.061000e+05,  3.754000e+05,
        -1.141000e+05, -1.141000e+05, -8.670000e+04,  4.195000e+05,
        -1.890000e+04, -2.004000e+05,  3.052000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.000000e+02,  1.700000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.000000e+02, -6.940000e+04,
        -1.121000e+05, -1.061000e+05,  1.600000e+03,  7.521000e+05,
         2.994000e+05,  2.000000e+02,  1.039000e+05,  1.030400e+06,
         1.768000e+05,  4.035000e+05,  3.742000e+05, -5.105000e+05,
        -3.466000e+05,  5.300000e+04,  5.120000e+06,  4.248200e+06,
        -2.464000e+05, -6.430000e+04, -6.830000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.994000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.081600e+06,  2.767000e+05,  3.117000e+05, -9.540000e+04,
         4.911000e+05,  4.595100e+06,  2.432000e+06,  1.047000e+06,
         2.766000e+05,  1.040000e+06,  2.759000e+05,  7.241000e+05,
         3.477000e+05, -5.505000e+05,  0.000000e+00,  7.241000e+05,
         1.399000e+05,  7.206000e+05,  3.960000e+04,  2.903300e+06,
         0.000000e+00,  1.653900e+06,  4.238000e+05,  5.035000e+05,
        -1.376000e+05,  3.248000e+05,  8.780000e+05,  2.204700e+06,
         4.001000e+05,  1.999600e+06,  3.286900e+06,  1.176000e+06,
        -6.550000e+04, -1.836000e+05, -1.833000e+05, -1.843000e+05,
        -1.806000e+05, -5.033000e+05, -1.835000e+05, -7.344000e+05,
        -2.372100e+06, -2.268300e+06,  1.760000e+05, -2.284000e+05,
        -2.075000e+05,  3.940000e+05, -4.218000e+05, -1.809000e+05,
        -1.809000e+05,  5.170000e+04,  2.833000e+05,  7.600000e+04,
        -4.450000e+04,  2.720000e+05, -1.349000e+05,  1.028100e+06,
        -6.421000e+05,  6.267000e+05,  3.990000e+04, -4.185000e+05,
         1.462800e+06,  1.462600e+06,  6.466000e+05,  6.958000e+05,
         2.973400e+06,  1.200500e+06,  1.242700e+06,  4.065300e+06,
         1.089000e+05,  5.140000e+05,  2.848000e+05, -1.108000e+05,
         3.381000e+05,  1.470700e+06,  1.470700e+06,  1.470600e+06,
         1.470600e+06,  6.436000e+05,  6.436000e+05,  1.830000e+05,
         8.623000e+05,  4.557000e+05, -4.750000e+04,  0.000000e+00,
         1.857000e+05,  2.261000e+05, -4.126000e+05,  3.471000e+05,
         2.995000e+05,  2.995000e+05,  1.355000e+05,  1.355000e+05,
         1.355000e+05,  4.304200e+06,  2.243400e+06,  1.744900e+06,
         1.834900e+06,  2.485800e+06,  1.236200e+06,  1.338700e+06,
         1.710100e+06,  5.539900e+06,  2.645200e+06,  5.539800e+06,
         2.619200e+06,  2.938000e+06, -3.290000e+04, -1.321900e+06,
        -1.682300e+06,  5.534000e+05,  1.468000e+05,  3.619900e+06,
        -7.498000e+05,  5.358000e+05,  1.253000e+05, -2.315000e+05,
        -5.948000e+05,  8.989000e+05, -3.338000e+05, -2.516000e+05,
        -3.864000e+05,  1.357700e+06,  2.594800e+06,  2.356200e+06,
         1.073600e+06,  3.638800e+06,  3.218000e+05,  4.388000e+05,
         7.399000e+05, -7.380000e+04,  9.065000e+05,  2.580900e+06,
         1.367900e+06,  1.292600e+06,  9.166000e+05,  1.432400e+06,
         1.332000e+06,  2.468900e+06,  1.718000e+05,  9.260000e+04,
         3.252000e+05,  1.807100e+06,  1.807000e+06,  5.981000e+05,
         1.652700e+06,  3.687200e+06,  2.981040e+07,  3.185000e+05,
         3.190000e+05, -1.993000e+05, -1.994000e+05, -4.370000e+04,
        -1.996000e+05, -5.826000e+05, -1.994000e+05,  3.669000e+05,
         3.669000e+05,  3.669000e+05,  3.670000e+05,  4.004000e+05,
        -4.154000e+05, -4.151000e+05, -4.152000e+05, -2.882000e+05,
         9.878000e+05,  0.000000e+00, -2.598000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.492200e+06, -9.584000e+05, -5.792000e+05,
        -3.599000e+05,  6.895000e+05,  6.890000e+05,  1.789200e+06,
         1.789000e+06, -4.800000e+04, -2.078000e+05, -2.880000e+04,
         2.619000e+05, -8.510000e+04, -3.240000e+04, -3.530000e+04,
        -5.505000e+05,  7.252000e+05, -8.120000e+04, -6.200000e+03,
         0.000000e+00,  3.000000e+02, -3.520000e+04,  3.003000e+05,
        -7.000000e+04, -8.570000e+04, -8.560000e+04, -8.560000e+04,
         0.000000e+00,  0.000000e+00, -1.974000e+05, -5.930000e+05,
        -1.240000e+05,  8.990000e+04,  5.621000e+05, -6.470000e+04,
         3.500000e+05,  2.686000e+05, -2.796000e+05, -4.060000e+04,
        -2.288000e+05, -2.288000e+05,  3.365000e+05, -4.240000e+04,
        -1.900000e+04,  1.017000e+05, -2.722000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.000000e+02,  1.100000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.619000e+05,
        -2.078000e+05, -7.220000e+04, -6.200000e+03, -8.120000e+04,
         3.669000e+05, -2.000000e+02,  1.081600e+06,  2.767000e+05,
         1.355000e+05,  1.470700e+06,  8.623000e+05, -1.808000e+05,
        -4.370000e+04, -1.994000e+05,  3.190000e+05, -4.152000e+05,
        -5.792000e+05, -2.880000e+04, -8.560000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         3.669000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.432000e+05,  1.604200e+06,  3.057000e+05,  2.840000e+04,
         8.600000e+04,  4.514000e+05,  1.649000e+05,  1.608000e+05,
         1.604000e+06,  1.644000e+05,  1.599700e+06,  3.102000e+05,
         1.024600e+06, -6.202000e+05,  0.000000e+00,  3.102000e+05,
         2.478000e+05,  3.118000e+05,  1.186000e+05,  1.237900e+06,
         0.000000e+00,  2.986000e+05,  2.367000e+06,  5.607000e+05,
         1.024000e+05,  1.683000e+06,  3.979900e+06,  9.196000e+05,
         7.393000e+05,  1.864900e+06,  2.791200e+06,  3.315700e+06,
         3.397000e+05, -1.415000e+05, -1.414000e+05, -1.391000e+05,
        -1.431000e+05, -5.366000e+05, -1.414000e+05, -2.679200e+06,
         7.500000e+04, -2.329800e+06, -3.109000e+05,  3.733000e+05,
        -2.235000e+05,  1.151000e+05, -1.571000e+05,  1.250000e+04,
         1.240000e+04,  8.103000e+05,  1.603400e+06,  2.552000e+05,
         9.080000e+04,  1.806000e+05,  8.672000e+05,  4.856700e+06,
        -6.047000e+05,  3.309000e+05,  2.739000e+05, -1.551000e+05,
         8.104000e+05,  8.104000e+05,  2.210300e+06,  9.851000e+05,
        -8.030000e+04,  7.348000e+05,  2.014000e+05,  7.790000e+04,
         1.492000e+05,  7.256000e+05,  3.624000e+05, -2.027000e+05,
         3.940000e+05,  6.124000e+05,  6.124000e+05,  6.123000e+05,
         6.124000e+05,  2.086900e+06,  2.086900e+06, -3.130000e+05,
         5.460000e+05,  1.279600e+06, -4.770000e+04,  0.000000e+00,
         7.406000e+05,  2.630000e+05, -3.791000e+05,  5.071000e+05,
         3.482000e+05,  3.482000e+05,  2.455000e+05,  2.455000e+05,
         2.456000e+05,  2.489800e+06,  6.164200e+06,  6.282000e+05,
         1.184000e+05,  1.304500e+06,  3.499200e+06, -1.670000e+05,
         4.952400e+06,  2.645200e+06,  7.082730e+07,  2.645100e+06,
         7.781400e+06,  7.745000e+05, -2.196100e+06, -3.120800e+06,
         7.207000e+05,  1.659000e+05,  8.522000e+05,  1.533410e+07,
        -5.270000e+05,  4.003000e+05,  1.089500e+06, -1.930000e+05,
        -5.311000e+05, -4.235000e+05,  1.762000e+06, -1.614000e+05,
        -1.350900e+06, -6.240000e+04,  1.387800e+06, -3.110000e+04,
        -9.585000e+05,  8.962000e+05,  3.401500e+06,  4.056000e+05,
        -1.477000e+05,  1.225300e+06,  1.282800e+06,  1.400500e+06,
         3.453000e+06,  4.726000e+05,  1.298500e+06, -9.100000e+04,
         3.606300e+06,  1.617600e+06,  3.223000e+05,  3.337000e+05,
         1.131600e+06,  4.333000e+05,  4.335000e+05,  2.648800e+06,
         5.398800e+06,  1.966100e+06,  8.158100e+06,  4.261000e+05,
         4.265000e+05,  9.390000e+04,  9.400000e+04,  8.530000e+04,
         9.400000e+04, -1.498000e+05,  9.400000e+04,  4.795000e+05,
         4.795000e+05,  4.795000e+05,  4.791000e+05,  4.597000e+05,
        -4.924000e+05, -4.921000e+05, -4.921000e+05, -7.386000e+05,
         1.912000e+05,  0.000000e+00, -2.943000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.953900e+06, -8.531000e+05, -3.795000e+05,
         4.170000e+04,  1.046100e+06,  1.048100e+06,  2.486700e+06,
         2.486700e+06, -5.280000e+04, -2.111000e+05, -8.560000e+04,
        -1.183000e+05,  5.814000e+05,  3.860000e+05, -2.790000e+04,
        -6.202000e+05,  3.098000e+05,  9.590000e+05,  2.900000e+03,
         0.000000e+00, -7.500000e+03, -1.455000e+05, -2.333000e+05,
         4.225000e+05, -1.090000e+05, -1.092000e+05, -1.092000e+05,
         0.000000e+00,  0.000000e+00, -7.854000e+05, -1.023000e+05,
         1.476700e+06,  2.410000e+05, -3.515000e+05,  3.907000e+05,
        -1.640000e+05, -1.214000e+05, -3.162000e+05,  4.785000e+05,
        -2.147000e+05, -2.147000e+05, -1.484000e+05,  5.145000e+05,
        -3.040000e+04, -3.623000e+05,  3.003000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  3.100000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.183000e+05,
        -2.111000e+05, -8.140000e+04,  2.900000e+03,  9.590000e+05,
         4.795000e+05,  0.000000e+00,  1.432000e+05,  1.604200e+06,
         2.455000e+05,  6.124000e+05,  5.460000e+05, -1.428000e+05,
         8.530000e+04,  9.400000e+04,  4.265000e+05, -4.922000e+05,
        -3.795000e+05, -8.560000e+04, -1.092000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.795000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.081700e+06,  2.767000e+05,  3.117000e+05, -9.540000e+04,
         4.911000e+05,  4.595100e+06,  2.432000e+06,  1.047100e+06,
         2.766000e+05,  1.040000e+06,  2.759000e+05,  7.241000e+05,
         3.477000e+05, -5.505000e+05,  0.000000e+00,  7.241000e+05,
         1.399000e+05,  7.206000e+05,  3.960000e+04,  2.903400e+06,
         0.000000e+00,  1.653900e+06,  4.238000e+05,  5.035000e+05,
        -1.376000e+05,  3.248000e+05,  8.780000e+05,  2.204700e+06,
         4.001000e+05,  1.999600e+06,  3.286900e+06,  1.176100e+06,
        -6.560000e+04, -1.836000e+05, -1.833000e+05, -1.843000e+05,
        -1.806000e+05, -5.033000e+05, -1.835000e+05, -7.344000e+05,
        -2.372100e+06, -2.268400e+06,  1.760000e+05, -2.284000e+05,
        -2.075000e+05,  3.940000e+05, -4.218000e+05, -1.809000e+05,
        -1.809000e+05,  5.170000e+04,  2.833000e+05,  7.600000e+04,
        -4.450000e+04,  2.720000e+05, -1.349000e+05,  1.028100e+06,
        -6.421000e+05,  6.267000e+05,  3.990000e+04, -4.185000e+05,
         1.462800e+06,  1.462600e+06,  6.466000e+05,  6.958000e+05,
         2.973500e+06,  1.200500e+06,  1.242700e+06,  4.065300e+06,
         1.089000e+05,  5.140000e+05,  2.848000e+05, -1.108000e+05,
         3.381000e+05,  1.470700e+06,  1.470700e+06,  1.470600e+06,
         1.470600e+06,  6.436000e+05,  6.436000e+05,  1.830000e+05,
         8.623000e+05,  4.557000e+05, -4.750000e+04,  0.000000e+00,
         1.857000e+05,  2.261000e+05, -4.126000e+05,  3.471000e+05,
         2.995000e+05,  2.995000e+05,  1.355000e+05,  1.355000e+05,
         1.355000e+05,  4.304200e+06,  2.243400e+06,  1.744900e+06,
         1.834900e+06,  2.485700e+06,  1.236200e+06,  1.338600e+06,
         1.710100e+06,  5.539800e+06,  2.645100e+06,  5.542500e+06,
         2.619200e+06,  2.938000e+06, -3.290000e+04, -1.321900e+06,
        -1.682300e+06,  5.534000e+05,  1.468000e+05,  3.619900e+06,
        -7.498000e+05,  5.358000e+05,  1.253000e+05, -2.315000e+05,
        -5.948000e+05,  8.989000e+05, -3.338000e+05, -2.516000e+05,
        -3.864000e+05,  1.357800e+06,  2.594800e+06,  2.356200e+06,
         1.073600e+06,  3.638800e+06,  3.218000e+05,  4.388000e+05,
         7.399000e+05, -7.390000e+04,  9.065000e+05,  2.580900e+06,
         1.367900e+06,  1.292600e+06,  9.166000e+05,  1.432400e+06,
         1.332000e+06,  2.469000e+06,  1.718000e+05,  9.260000e+04,
         3.252000e+05,  1.807100e+06,  1.807000e+06,  5.981000e+05,
         1.652700e+06,  3.687200e+06,  2.981040e+07,  3.185000e+05,
         3.190000e+05, -1.993000e+05, -1.994000e+05, -4.370000e+04,
        -1.996000e+05, -5.826000e+05, -1.994000e+05,  3.669000e+05,
         3.669000e+05,  3.669000e+05,  3.670000e+05,  4.004000e+05,
        -4.154000e+05, -4.151000e+05, -4.152000e+05, -2.882000e+05,
         9.878000e+05,  0.000000e+00, -2.598000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.492200e+06, -9.584000e+05, -5.792000e+05,
        -3.599000e+05,  6.895000e+05,  6.890000e+05,  1.789200e+06,
         1.789100e+06, -4.800000e+04, -2.078000e+05, -2.880000e+04,
         2.619000e+05, -8.510000e+04, -3.240000e+04, -3.530000e+04,
        -5.505000e+05,  7.252000e+05, -8.120000e+04, -6.200000e+03,
         0.000000e+00,  3.000000e+02, -3.520000e+04,  3.003000e+05,
        -7.000000e+04, -8.570000e+04, -8.560000e+04, -8.560000e+04,
         0.000000e+00,  0.000000e+00, -1.974000e+05, -5.930000e+05,
        -1.240000e+05,  8.990000e+04,  5.621000e+05, -6.470000e+04,
         3.500000e+05,  2.686000e+05, -2.796000e+05, -4.060000e+04,
        -2.288000e+05, -2.288000e+05,  3.365000e+05, -4.240000e+04,
        -1.900000e+04,  1.017000e+05, -2.722000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.000000e+02,  1.100000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.619000e+05,
        -2.078000e+05, -7.220000e+04, -6.200000e+03, -8.120000e+04,
         3.669000e+05, -2.000000e+02,  1.081700e+06,  2.767000e+05,
         1.355000e+05,  1.470700e+06,  8.623000e+05, -1.808000e+05,
        -4.370000e+04, -1.994000e+05,  3.190000e+05, -4.152000e+05,
        -5.792000e+05, -2.880000e+04, -8.560000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         3.669000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.445000e+05,  1.604800e+06,  3.061000e+05,  2.840000e+04,
         8.670000e+04,  4.572000e+05,  1.680000e+05,  1.620000e+05,
         1.604500e+06,  1.655000e+05,  1.600300e+06,  3.108000e+05,
         1.025100e+06, -6.208000e+05,  0.000000e+00,  3.108000e+05,
         2.480000e+05,  3.126000e+05,  1.187000e+05,  1.240100e+06,
         0.000000e+00,  2.978000e+05,  2.367600e+06,  5.587000e+05,
         1.016000e+05,  1.683200e+06,  3.981300e+06,  9.191000e+05,
         7.396000e+05,  1.866700e+06,  2.794000e+06,  3.318200e+06,
         3.347000e+05, -1.416000e+05, -1.415000e+05, -1.391000e+05,
        -1.434000e+05, -5.372000e+05, -1.415000e+05, -2.683200e+06,
         7.270000e+04, -2.335400e+06, -3.103000e+05,  3.732000e+05,
        -2.234000e+05,  1.159000e+05, -1.571000e+05,  1.180000e+04,
         1.160000e+04,  8.100000e+05,  1.603600e+06,  2.540000e+05,
         9.060000e+04,  1.794000e+05,  8.657000e+05,  4.857700e+06,
        -6.058000e+05,  3.316000e+05,  2.741000e+05, -1.551000e+05,
         8.102000e+05,  8.102000e+05,  2.211700e+06,  9.841000e+05,
        -7.620000e+04,  7.345000e+05,  2.024000e+05,  8.040000e+04,
         1.492000e+05,  7.262000e+05,  3.629000e+05, -2.028000e+05,
         3.946000e+05,  6.125000e+05,  6.125000e+05,  6.125000e+05,
         6.125000e+05,  2.087400e+06,  2.087400e+06, -3.139000e+05,
         5.467000e+05,  1.280100e+06, -4.820000e+04,  0.000000e+00,
         7.403000e+05,  2.628000e+05, -3.799000e+05,  5.073000e+05,
         3.486000e+05,  3.486000e+05,  2.456000e+05,  2.456000e+05,
         2.457000e+05,  2.487800e+06,  6.167800e+06,  6.238000e+05,
         1.212000e+05,  1.296300e+06,  3.500200e+06, -1.770000e+05,
         4.954000e+06,  2.619200e+06,  7.781400e+06,  2.619200e+06,
         7.913400e+06,  7.679000e+05, -2.198600e+06, -3.124200e+06,
         7.195000e+05,  1.635000e+05,  8.495000e+05,  1.533740e+07,
        -5.274000e+05,  3.999000e+05,  1.090100e+06, -1.937000e+05,
        -5.321000e+05, -4.250000e+05,  1.762200e+06, -1.641000e+05,
        -1.352400e+06, -5.870000e+04,  1.386800e+06, -3.130000e+04,
        -9.596000e+05,  8.969000e+05,  3.400500e+06,  4.034000e+05,
        -1.532000e+05,  1.219500e+06,  1.284600e+06,  1.393200e+06,
         3.443600e+06,  4.673000e+05,  1.300300e+06, -1.009000e+05,
         3.625400e+06,  1.638200e+06,  3.229000e+05,  3.335000e+05,
         1.131800e+06,  4.340000e+05,  4.342000e+05,  2.688900e+06,
         5.424700e+06,  1.992900e+06,  8.163200e+06,  4.260000e+05,
         4.265000e+05,  9.420000e+04,  9.430000e+04,  8.500000e+04,
         9.430000e+04, -1.496000e+05,  9.430000e+04,  4.801000e+05,
         4.801000e+05,  4.801000e+05,  4.796000e+05,  4.600000e+05,
        -4.917000e+05, -4.914000e+05, -4.915000e+05, -7.390000e+05,
         1.921000e+05,  0.000000e+00, -2.948000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.949900e+06, -8.520000e+05, -3.787000e+05,
         4.060000e+04,  1.047100e+06,  1.049100e+06,  2.489600e+06,
         2.489600e+06, -5.350000e+04, -2.112000e+05, -8.550000e+04,
        -1.180000e+05,  5.815000e+05,  3.860000e+05, -2.790000e+04,
        -6.208000e+05,  3.104000e+05,  9.589000e+05,  2.900000e+03,
         0.000000e+00, -7.500000e+03, -1.464000e+05, -2.329000e+05,
         4.223000e+05, -1.091000e+05, -1.093000e+05, -1.093000e+05,
         0.000000e+00,  0.000000e+00, -7.859000e+05, -1.031000e+05,
         1.476500e+06,  2.411000e+05, -3.508000e+05,  3.905000e+05,
        -1.639000e+05, -1.210000e+05, -3.166000e+05,  4.785000e+05,
        -2.148000e+05, -2.148000e+05, -1.480000e+05,  5.144000e+05,
        -3.040000e+04, -3.619000e+05,  3.001000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  3.100000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.180000e+05,
        -2.112000e+05, -8.140000e+04,  2.900000e+03,  9.589000e+05,
         4.801000e+05,  0.000000e+00,  1.445000e+05,  1.604800e+06,
         2.456000e+05,  6.125000e+05,  5.467000e+05, -1.432000e+05,
         8.500000e+04,  9.430000e+04,  4.265000e+05, -4.915000e+05,
        -3.787000e+05, -8.550000e+04, -1.093000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.801000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 6.739000e+05,  7.280000e+04,  1.233000e+05, -1.988000e+05,
         2.363000e+05,  2.906000e+06,  1.558300e+06,  6.470000e+05,
         7.280000e+04,  6.415000e+05,  7.260000e+04,  3.943000e+05,
         1.143000e+05,  6.151000e+05,  0.000000e+00,  3.943000e+05,
        -3.920000e+04,  3.915000e+05,  1.280000e+04,  1.582100e+06,
         0.000000e+00,  1.827400e+06,  8.981000e+05,  1.001800e+06,
         4.774000e+05, -1.634000e+05,  2.421000e+05,  1.207600e+06,
        -1.317000e+05,  2.499600e+06,  2.275700e+06,  1.855000e+06,
         2.970900e+06,  7.298000e+05,  7.296000e+05,  7.334000e+05,
         7.478000e+05,  8.337000e+05,  7.295000e+05,  7.549500e+06,
         6.318000e+06,  6.448700e+06,  1.016600e+06,  7.074000e+05,
         7.414000e+05,  3.610000e+04, -5.556000e+05,  9.432000e+05,
         9.432000e+05,  6.196000e+05,  2.980000e+05,  6.521000e+05,
         6.828000e+05,  1.867500e+06,  1.558100e+06, -6.030000e+04,
         4.084000e+05,  1.945000e+05, -2.413000e+05, -5.541000e+05,
         2.473100e+06,  2.473000e+06,  1.771900e+06,  1.922600e+06,
         1.982300e+06,  5.936000e+05,  7.653000e+05,  2.663500e+06,
        -6.300000e+04,  8.000000e+04,  9.090000e+04, -4.060000e+04,
         9.650000e+04,  8.050000e+05,  8.050000e+05,  8.049000e+05,
         8.050000e+05,  1.869000e+05,  1.868000e+05,  1.024800e+06,
         3.544000e+05,  5.060000e+04, -2.530000e+04,  0.000000e+00,
        -3.495000e+05, -3.345000e+05,  5.689000e+05,  4.539000e+05,
         1.044000e+05,  1.044000e+05, -4.230000e+04, -4.230000e+04,
        -4.220000e+04,  2.034200e+06,  4.955000e+05,  2.467100e+06,
         1.838600e+06,  1.275000e+06,  3.468000e+05,  9.034000e+05,
        -3.029000e+05,  2.938000e+06,  7.745000e+05,  2.938000e+06,
         7.679000e+05,  7.621000e+06,  3.862300e+06,  4.082800e+06,
         2.590100e+06,  1.133100e+06,  8.236000e+05,  1.011700e+06,
         4.610000e+05,  2.490000e+05, -6.030000e+04,  7.054000e+05,
         1.297800e+06,  7.126000e+05, -2.188000e+05, -1.130000e+05,
         9.250000e+05,  9.045000e+05,  1.338500e+06,  2.394100e+06,
         2.606600e+06,  2.181600e+06,  8.468000e+05,  1.018100e+06,
         2.152100e+06,  1.533200e+06,  1.058200e+06,  1.325400e+06,
         3.978000e+05,  1.537200e+06,  1.073700e+06,  9.597000e+05,
         3.942000e+05,  1.243200e+06,  8.256000e+05,  6.366000e+05,
         3.129000e+05,  1.074000e+06,  1.073900e+06,  1.662000e+05,
         1.022700e+06,  2.570000e+06,  1.745250e+07,  9.010000e+04,
         9.030000e+04, -1.580000e+05, -1.581000e+05,  6.819000e+05,
        -1.582000e+05, -1.160000e+06, -1.581000e+05,  1.140000e+05,
         1.140000e+05,  1.140000e+05,  1.142000e+05,  1.409000e+05,
        -1.526000e+05, -1.525000e+05, -1.525000e+05,  8.206000e+05,
         6.010000e+05,  0.000000e+00, -9.640000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -9.156000e+05, -4.048000e+05, -2.816000e+05,
         1.889700e+06,  9.101000e+05,  9.104000e+05,  1.252300e+06,
         1.252200e+06, -2.380000e+04, -1.403000e+05, -1.750000e+04,
         2.051000e+05, -5.200000e+04, -1.470000e+04, -1.570000e+04,
         6.151000e+05,  3.953000e+05, -3.640000e+04, -4.900000e+03,
         0.000000e+00,  2.000000e+02, -2.900000e+03,  2.398000e+05,
        -3.820000e+04, -2.730000e+04, -2.720000e+04, -2.720000e+04,
         0.000000e+00,  0.000000e+00,  8.951000e+05,  5.966000e+05,
        -5.640000e+04,  7.890000e+04,  4.448000e+05, -3.530000e+04,
         2.766000e+05,  2.103000e+05,  3.022000e+05, -1.820000e+04,
        -1.560000e+05, -1.561000e+05,  2.627000e+05, -2.030000e+04,
        -4.100000e+03,  1.021000e+05, -1.771000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  4.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.051000e+05,
        -1.403000e+05,  8.070000e+04, -4.900000e+03, -3.640000e+04,
         1.140000e+05, -1.000000e+02,  6.739000e+05,  7.280000e+04,
        -4.230000e+04,  8.050000e+05,  3.544000e+05,  7.460000e+05,
         6.819000e+05, -1.581000e+05,  9.030000e+04, -1.525000e+05,
        -2.816000e+05, -1.750000e+04, -2.720000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.140000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 3.594000e+05, -2.489000e+05, -1.531000e+05, -3.361000e+05,
         1.080000e+04,  1.682600e+06,  9.639000e+05,  3.271000e+05,
        -2.489000e+05,  3.205000e+05, -2.484000e+05,  3.210000e+04,
        -2.470000e+05,  1.965600e+06,  0.000000e+00,  3.210000e+04,
        -3.122000e+05,  2.910000e+04, -2.900000e+04,  1.301000e+05,
         0.000000e+00,  2.089900e+06,  1.140600e+06,  1.314800e+06,
         1.002700e+06, -8.971000e+05, -7.687000e+05,  1.165000e+05,
        -9.456000e+05,  2.370900e+06,  4.295000e+05,  1.742400e+06,
         5.685900e+06,  1.669500e+06,  1.670300e+06,  1.673200e+06,
         1.663800e+06,  2.306300e+06,  1.670000e+06,  1.681560e+07,
         1.555630e+07,  1.578210e+07,  2.005300e+06,  1.688300e+06,
         1.747000e+06, -3.261000e+05, -6.995000e+05,  2.006800e+06,
         2.006800e+06,  1.049800e+06,  9.760000e+04,  1.106600e+06,
         1.347000e+06,  3.368400e+06,  3.051600e+06, -1.733400e+06,
         1.615900e+06, -3.024000e+05, -6.498000e+05, -7.016000e+05,
         3.153600e+06,  3.153300e+06,  2.502700e+06,  2.636900e+06,
         1.458100e+06, -1.723000e+05,  3.762000e+05,  1.805200e+06,
        -3.355000e+05, -6.033000e+05, -2.202000e+05,  5.880000e+04,
        -3.109000e+05,  7.420000e+04,  7.420000e+04,  7.430000e+04,
         7.420000e+04, -5.438000e+05, -5.438000e+05,  2.021900e+06,
        -2.781000e+05, -5.842000e+05,  9.900000e+03,  0.000000e+00,
        -9.462000e+05, -9.780000e+05,  1.643800e+06,  3.746000e+05,
        -1.992000e+05, -1.992000e+05, -3.133000e+05, -3.132000e+05,
        -3.133000e+05, -7.386000e+05, -2.279300e+06,  3.139300e+06,
         2.040400e+06, -1.605000e+05, -1.081200e+06,  7.201000e+05,
        -3.010800e+06, -3.290000e+04, -2.196100e+06, -3.290000e+04,
        -2.198600e+06,  3.862300e+06,  8.715800e+06,  1.065180e+07,
         7.465500e+06,  1.708000e+06,  1.391300e+06, -3.143500e+06,
         1.783500e+06, -1.414000e+05, -4.566000e+05,  1.683600e+06,
         3.312000e+06,  8.154000e+05, -1.134000e+05,  4.040000e+04,
         2.740600e+06,  6.866000e+05, -1.741000e+05,  2.751200e+06,
         4.692800e+06,  8.096000e+05,  1.167500e+06,  1.459400e+06,
         3.711000e+06,  3.077500e+06,  7.740000e+05, -1.807000e+05,
        -1.131700e+06,  1.746300e+06,  7.868000e+05,  7.190000e+05,
        -1.111000e+06, -2.546000e+05,  1.355700e+06,  1.026600e+06,
         6.970000e+04,  4.094000e+05,  4.091000e+05, -5.213000e+05,
        -4.275000e+05,  1.156200e+06,  5.751700e+06, -2.798000e+05,
        -2.801000e+05, -1.808000e+05, -1.809000e+05,  1.345600e+06,
        -1.812000e+05, -1.737500e+06, -1.809000e+05, -2.949000e+05,
        -2.949000e+05, -2.949000e+05, -2.947000e+05, -2.630000e+05,
         2.692000e+05,  2.690000e+05,  2.690000e+05,  2.204800e+06,
         2.725000e+05,  0.000000e+00,  1.583000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.614800e+06,  3.979000e+05,  1.084000e+05,
         4.011200e+06,  7.558000e+05,  7.560000e+05, -1.294000e+05,
        -1.297000e+05,  1.450000e+04, -1.430000e+04, -1.590000e+04,
         2.390000e+05, -1.350000e+04,  1.630000e+04,  1.130000e+04,
         1.965600e+06,  3.300000e+04,  4.190000e+04, -6.000000e+03,
         0.000000e+00,  1.000000e+02,  4.940000e+04,  2.827000e+05,
         2.900000e+03,  6.620000e+04,  6.640000e+04,  6.640000e+04,
         0.000000e+00,  0.000000e+00,  2.314400e+06,  1.986900e+06,
         6.250000e+04,  1.184000e+05,  5.215000e+05,  2.700000e+03,
         3.387000e+05,  2.449000e+05,  9.778000e+05,  2.080000e+04,
        -2.570000e+04, -2.580000e+04,  3.029000e+05,  1.740000e+04,
         2.140000e+04,  2.731000e+05, -9.000000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.000000e+02, -1.600000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.390000e+05,
        -1.430000e+04,  2.579000e+05, -6.000000e+03,  4.190000e+04,
        -2.949000e+05, -3.000000e+02,  3.594000e+05, -2.489000e+05,
        -3.132000e+05,  7.420000e+04, -2.781000e+05,  1.664400e+06,
         1.345600e+06, -1.809000e+05, -2.801000e+05,  2.690000e+05,
         1.084000e+05, -1.590000e+04,  6.640000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -2.949000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.553000e+05, -3.509000e+05, -2.474000e+05, -3.879000e+05,
        -1.167000e+05,  8.367000e+05,  5.263000e+05,  1.268000e+05,
        -3.508000e+05,  1.211000e+05, -3.502000e+05, -1.327000e+05,
        -3.636000e+05,  2.549000e+06,  0.000000e+00, -1.327000e+05,
        -4.019000e+05, -1.354000e+05, -4.240000e+04, -5.304000e+05,
         0.000000e+00,  2.179900e+06,  1.377800e+06,  1.567500e+06,
         1.311700e+06, -1.141500e+06, -1.086800e+06, -3.798000e+05,
        -1.211900e+06,  2.601200e+06, -9.460000e+04,  2.074000e+06,
         7.211000e+06,  2.126300e+06,  2.127200e+06,  2.131400e+06,
         2.119500e+06,  2.971300e+06,  2.127000e+06,  2.096450e+07,
         1.990390e+07,  2.014800e+07,  2.425100e+06,  2.156300e+06,
         2.221000e+06, -5.053000e+05, -7.666000e+05,  2.570900e+06,
         2.570900e+06,  1.335000e+06,  1.054000e+05,  1.396900e+06,
         1.711800e+06,  4.168600e+06,  3.900400e+06, -2.278900e+06,
         2.142300e+06, -5.189000e+05, -7.906000e+05, -7.697000e+05,
         3.617700e+06,  3.617500e+06,  3.062200e+06,  3.209500e+06,
         9.614000e+05, -4.753000e+05,  1.374000e+05,  1.103800e+06,
        -4.211000e+05, -8.205000e+05, -3.172000e+05,  9.380000e+04,
        -4.317000e+05, -2.582000e+05, -2.582000e+05, -2.582000e+05,
        -2.582000e+05, -7.721000e+05, -7.722000e+05,  2.447700e+06,
        -5.326000e+05, -7.872000e+05,  2.120000e+04,  0.000000e+00,
        -1.213800e+06, -1.258900e+06,  2.135500e+06,  4.289000e+05,
        -2.968000e+05, -2.968000e+05, -4.022000e+05, -4.021000e+05,
        -4.022000e+05, -1.872700e+06, -3.154300e+06,  3.507200e+06,
         2.042900e+06, -7.619000e+05, -1.525100e+06,  5.061000e+05,
        -4.017600e+06, -1.321900e+06, -3.120800e+06, -1.321900e+06,
        -3.124200e+06,  4.082800e+06,  1.065180e+07,  1.337900e+07,
         9.605800e+06,  1.999300e+06,  1.731100e+06, -4.448100e+06,
         2.388300e+06, -2.849000e+05, -5.506000e+05,  2.152800e+06,
         4.259900e+06,  7.191000e+05, -5.600000e+04,  1.067000e+05,
         3.392700e+06,  4.590000e+05, -8.010000e+05,  2.766900e+06,
         5.460600e+06,  7.320000e+04,  1.425900e+06,  1.746200e+06,
         4.420000e+06,  3.883600e+06,  8.503000e+05, -8.049000e+05,
        -1.611400e+06,  1.871400e+06,  8.654000e+05,  4.865000e+05,
        -1.579800e+06, -8.673000e+05,  1.683000e+06,  1.300000e+06,
         6.420000e+04,  4.300000e+04,  4.270000e+04, -7.374000e+05,
        -7.425000e+05,  5.985000e+05, -4.221000e+05, -3.935000e+05,
        -3.940000e+05, -1.594000e+05, -1.595000e+05,  1.709600e+06,
        -1.598000e+05, -2.025300e+06, -1.595000e+05, -4.213000e+05,
        -4.213000e+05, -4.213000e+05, -4.210000e+05, -3.926000e+05,
         3.996000e+05,  3.993000e+05,  3.994000e+05,  2.759700e+06,
         7.920000e+04,  0.000000e+00,  2.401000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.397300e+06,  6.743000e+05,  2.573000e+05,
         5.139600e+06,  8.674000e+05,  8.679000e+05, -3.966000e+05,
        -3.968000e+05,  2.700000e+04,  1.930000e+04, -1.040000e+04,
         2.105000e+05,  3.000000e+03,  2.510000e+04,  2.100000e+04,
         2.549000e+06, -1.318000e+05,  6.430000e+04, -5.400000e+03,
         0.000000e+00,  0.000000e+00,  6.660000e+04,  2.523000e+05,
         1.890000e+04,  9.540000e+04,  9.560000e+04,  9.560000e+04,
         0.000000e+00,  0.000000e+00,  2.865100e+06,  2.581800e+06,
         9.610000e+04,  1.128000e+05,  4.626000e+05,  1.750000e+04,
         3.050000e+05,  2.156000e+05,  1.268900e+06,  3.200000e+04,
         1.050000e+04,  1.050000e+04,  2.659000e+05,  2.830000e+04,
         2.880000e+04,  2.730000e+05,  3.830000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.000000e+02, -1.900000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.105000e+05,
         1.930000e+04,  3.344000e+05, -5.400000e+03,  6.430000e+04,
        -4.213000e+05, -2.000000e+02,  1.553000e+05, -3.509000e+05,
        -4.021000e+05, -2.582000e+05, -5.326000e+05,  2.120200e+06,
         1.709600e+06, -1.595000e+05, -3.940000e+05,  3.994000e+05,
         2.573000e+05, -1.040000e+04,  9.560000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -4.213000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-1.760000e+05,  5.007000e+05, -1.562000e+05, -2.664000e+05,
        -2.207000e+05, -6.819000e+05, -3.299000e+05, -1.787000e+05,
         5.006000e+05, -1.791000e+05,  4.994000e+05, -2.039000e+05,
         1.357000e+05,  1.925500e+06,  0.000000e+00, -2.039000e+05,
        -2.507000e+05, -2.039000e+05,  1.570000e+04, -8.193000e+05,
         0.000000e+00,  1.315900e+06,  2.279600e+06,  1.347500e+06,
         1.142300e+06, -1.240000e+05,  9.971000e+05, -6.161000e+05,
        -7.531000e+05,  2.280200e+06,  1.369000e+05,  2.971100e+06,
         5.931500e+06,  1.693100e+06,  1.694200e+06,  1.699800e+06,
         1.680000e+06,  2.284900e+06,  1.694100e+06,  1.570330e+07,
         1.699290e+07,  1.574550e+07,  1.725900e+06,  2.041600e+06,
         1.736400e+06, -4.868000e+05, -5.508000e+05,  2.124300e+06,
         2.124300e+06,  1.484400e+06,  8.492000e+05,  1.210600e+06,
         1.428000e+06,  3.324700e+06,  3.642900e+06,  4.435000e+05,
         1.636200e+06, -4.718000e+05, -5.175000e+05, -5.534000e+05,
         2.750100e+06,  2.750000e+06,  3.450100e+06,  2.771200e+06,
        -2.854000e+05, -4.371000e+05, -2.179000e+05, -4.716000e+05,
        -3.106000e+05, -4.825000e+05, -1.757000e+05,  4.600000e+03,
        -2.806000e+05, -4.148000e+05, -4.148000e+05, -4.148000e+05,
        -4.148000e+05,  2.718000e+05,  2.718000e+05,  1.736600e+06,
        -4.581000e+05, -1.177000e+05,  9.500000e+03,  0.000000e+00,
        -6.339000e+05, -9.569000e+05,  1.663600e+06,  4.732000e+05,
        -1.712000e+05, -1.712000e+05, -2.508000e+05, -2.508000e+05,
        -2.508000e+05, -1.771500e+06, -6.050000e+04,  2.505100e+06,
         1.064100e+06, -8.340000e+05,  1.982000e+05, -1.394000e+05,
        -1.152000e+06, -1.682300e+06,  7.207000e+05, -1.682300e+06,
         7.195000e+05,  2.590100e+06,  7.465500e+06,  9.605800e+06,
         3.158390e+07,  1.487100e+06,  1.805000e+06,  3.496800e+06,
         1.910300e+06, -2.189000e+05,  1.036000e+05,  1.705200e+06,
         3.352100e+06,  5.790000e+04,  1.085900e+06,  8.950000e+04,
         2.187100e+06, -1.246000e+05, -8.612000e+05,  1.382200e+06,
         3.526800e+06, -7.623000e+05,  2.973200e+06,  1.435000e+06,
         3.204500e+06,  3.840900e+06,  9.892000e+05, -8.532000e+05,
         9.400000e+04,  1.279000e+06,  1.006000e+06, -1.503000e+05,
         1.754000e+05, -7.666000e+05,  1.441700e+06,  1.168300e+06,
         5.284000e+05, -3.742000e+05, -3.742000e+05,  6.368000e+05,
         1.730100e+06,  1.391000e+05, -6.596600e+06, -2.185000e+05,
        -2.187000e+05, -1.280000e+04, -1.280000e+04,  1.424500e+06,
        -1.300000e+04, -1.489500e+06, -1.280000e+04, -2.304000e+05,
        -2.304000e+05, -2.304000e+05, -2.305000e+05, -2.287000e+05,
         2.256000e+05,  2.254000e+05,  2.254000e+05,  1.947100e+06,
        -1.823000e+05,  0.000000e+00,  1.382000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.353200e+06,  4.575000e+05,  2.224000e+05,
         4.255700e+06,  9.646000e+05,  9.656000e+05,  2.741000e+05,
         2.739000e+05,  1.150000e+04, -1.650000e+04, -5.010000e+04,
         2.160000e+04,  3.628000e+05,  2.547000e+05,  1.550000e+04,
         1.925500e+06, -2.038000e+05,  6.284000e+05, -8.000000e+02,
         0.000000e+00, -4.200000e+03, -1.550000e+04, -2.380000e+04,
         2.916000e+05,  5.280000e+04,  5.290000e+04,  5.290000e+04,
         0.000000e+00,  0.000000e+00,  1.977400e+06,  2.276300e+06,
         9.743000e+05,  2.054000e+05, -2.100000e+03,  2.696000e+05,
         4.460000e+04,  2.200000e+04,  9.566000e+05,  3.135000e+05,
        -1.810000e+04, -1.810000e+04,  2.600000e+04,  3.400000e+05,
         1.490000e+04,  7.900000e+03,  3.221000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.000000e+02, -4.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.160000e+04,
        -1.650000e+04,  2.526000e+05, -8.000000e+02,  6.284000e+05,
        -2.304000e+05, -2.000000e+02, -1.760000e+05,  5.007000e+05,
        -2.508000e+05, -4.148000e+05, -4.581000e+05,  1.681400e+06,
         1.424500e+06, -1.280000e+04, -2.187000e+05,  2.254000e+05,
         2.224000e+05, -5.010000e+04,  5.290000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -2.304000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.204000e+05,  1.310000e+04,  2.550000e+04, -7.470000e+04,
         2.270000e+04,  5.176000e+05,  2.768000e+05,  1.158000e+05,
         1.310000e+04,  1.149000e+05,  1.300000e+04,  7.350000e+04,
         2.330000e+04,  3.675000e+05,  0.000000e+00,  7.350000e+04,
        -2.400000e+04,  7.300000e+04,  2.600000e+03,  2.948000e+05,
         0.000000e+00,  5.913000e+05,  4.242000e+05,  4.488000e+05,
         2.852000e+05, -8.660000e+04,  4.620000e+04,  2.241000e+05,
        -7.560000e+04,  9.865000e+05,  6.948000e+05,  8.762000e+05,
         1.578600e+06,  3.938000e+05,  3.951000e+05,  3.934000e+05,
         3.942000e+05,  4.727000e+05,  3.959000e+05,  3.704400e+06,
         3.485100e+06,  3.514400e+06,  4.426000e+05,  3.863000e+05,
         3.951000e+05, -5.240000e+04, -1.995000e+05,  5.211000e+05,
         5.212000e+05,  3.335000e+05,  1.470000e+05,  3.401000e+05,
         3.673000e+05,  9.096000e+05,  8.536000e+05, -8.470000e+04,
         2.866000e+05, -2.000000e+03, -9.970000e+04, -1.991000e+05,
         9.603000e+05,  9.611000e+05,  8.507000e+05,  8.654000e+05,
         3.492000e+05,  1.152000e+05,  1.380000e+05,  4.697000e+05,
        -2.950000e+04,  2.900000e+03,  2.040000e+04, -6.800000e+03,
         2.470000e+04,  1.498000e+05,  1.498000e+05,  1.498000e+05,
         1.498000e+05,  3.910000e+04,  3.910000e+04,  4.413000e+05,
         4.860000e+04, -5.700000e+03, -7.500000e+03,  0.000000e+00,
        -1.960000e+05, -1.913000e+05,  3.399000e+05,  2.074000e+05,
         2.270000e+04,  2.270000e+04, -2.490000e+04, -2.490000e+04,
        -2.490000e+04,  3.504000e+05,  7.400000e+04,  9.339000e+05,
         5.460000e+05,  2.392000e+05,  7.170000e+04,  1.518000e+05,
        -3.089000e+05,  5.534000e+05,  1.659000e+05,  5.534000e+05,
         1.635000e+05,  1.133100e+06,  1.708000e+06,  1.999300e+06,
         1.487100e+06,  5.636000e+05,  5.075000e+05,  2.025000e+05,
         3.418000e+05,  4.750000e+04, -8.800000e+03,  3.880000e+05,
         7.349000e+05,  1.199000e+05, -4.550000e+04, -2.250000e+04,
         4.141000e+05,  1.565000e+05,  2.548000e+05,  6.881000e+05,
         9.800000e+05,  3.961000e+05,  4.078000e+05,  4.506000e+05,
         1.101200e+06,  9.892000e+05,  4.663000e+05,  2.541000e+05,
         8.520000e+04,  5.475000e+05,  4.727000e+05,  1.694000e+05,
         8.530000e+04,  2.402000e+05,  4.128000e+05,  3.387000e+05,
         1.510000e+05,  1.964000e+05,  1.964000e+05,  3.410000e+04,
         4.019000e+05,  6.821000e+05,  3.205100e+06,  1.910000e+04,
         1.920000e+04, -2.660000e+04, -2.660000e+04,  3.649000e+05,
        -2.590000e+04, -4.744000e+05, -2.660000e+04,  2.600000e+04,
         2.600000e+04,  2.600000e+04,  2.600000e+04,  3.110000e+04,
        -3.640000e+04, -3.630000e+04, -3.630000e+04,  4.019000e+05,
         1.080000e+05,  0.000000e+00, -2.240000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.181000e+05, -8.240000e+04, -5.450000e+04,
         1.045200e+06,  4.186000e+05,  4.204000e+05,  4.997000e+05,
         5.004000e+05, -6.100000e+03, -4.580000e+04, -1.300000e+03,
         3.430000e+04, -1.200000e+04, -4.800000e+03, -3.200000e+03,
         3.675000e+05,  7.360000e+04, -1.100000e+04, -8.000000e+02,
         0.000000e+00,  1.000000e+02,  0.000000e+00,  4.230000e+04,
        -8.200000e+03, -6.100000e+03, -6.100000e+03, -6.100000e+03,
         0.000000e+00,  0.000000e+00,  4.128000e+05,  3.604000e+05,
        -1.820000e+04,  1.150000e+04,  7.660000e+04, -7.600000e+03,
         4.520000e+04,  3.590000e+04,  1.818000e+05, -5.100000e+03,
        -4.960000e+04, -4.960000e+04,  4.480000e+04, -6.900000e+03,
        -1.000000e+03, -5.600000e+03, -5.660000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  7.000000e+02,  3.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  3.430000e+04,
        -4.580000e+04,  4.820000e+04, -8.000000e+02, -1.100000e+04,
         2.600000e+04,  7.000000e+02,  1.204000e+05,  1.310000e+04,
        -2.490000e+04,  1.498000e+05,  4.860000e+04,  3.941000e+05,
         3.649000e+05, -2.660000e+04,  1.920000e+04, -3.630000e+04,
        -5.450000e+04, -1.300000e+03, -6.100000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.600000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-1.380000e+04,  1.889000e+05,  2.460000e+04, -5.830000e+04,
        -3.590000e+04, -7.530000e+04, -4.770000e+04, -1.090000e+04,
         1.889000e+05, -1.030000e+04,  1.888000e+05,  1.430000e+04,
         1.134000e+05,  3.563000e+05,  0.000000e+00,  1.430000e+04,
        -8.900000e+03,  1.460000e+04,  1.310000e+04,  5.780000e+04,
         0.000000e+00,  3.972000e+05,  7.414000e+05,  4.569000e+05,
         3.226000e+05,  1.033000e+05,  4.777000e+05,  4.360000e+04,
        -2.880000e+04,  9.631000e+05,  6.236000e+05,  1.172500e+06,
         1.655900e+06,  3.984000e+05,  3.995000e+05,  3.983000e+05,
         3.985000e+05,  4.665000e+05,  4.003000e+05,  3.412400e+06,
         3.902500e+06,  3.492100e+06,  3.548000e+05,  5.218000e+05,
         3.747000e+05, -9.450000e+04, -1.649000e+05,  5.576000e+05,
         5.577000e+05,  4.424000e+05,  3.307000e+05,  3.678000e+05,
         3.906000e+05,  9.061000e+05,  1.237800e+06,  6.613000e+05,
         2.903000e+05, -4.520000e+04, -6.810000e+04, -1.641000e+05,
         8.636000e+05,  8.643000e+05,  1.089700e+06,  9.034000e+05,
        -8.820000e+04,  5.060000e+04, -1.030000e+04, -9.790000e+04,
        -2.080000e+04,  3.260000e+04,  3.130000e+04, -2.250000e+04,
         2.960000e+04,  2.900000e+04,  2.900000e+04,  2.900000e+04,
         2.900000e+04,  2.306000e+05,  2.306000e+05,  3.686000e+05,
         4.100000e+03,  1.052000e+05, -7.400000e+03,  0.000000e+00,
        -1.228000e+05, -1.849000e+05,  3.449000e+05,  2.396000e+05,
         2.940000e+04,  2.940000e+04, -9.800000e+03, -9.800000e+03,
        -9.800000e+03,  9.590000e+04,  5.988000e+05,  7.790000e+05,
         3.033000e+05,  7.420000e+04,  3.738000e+05, -5.850000e+04,
         1.630000e+05,  1.468000e+05,  8.522000e+05,  1.468000e+05,
         8.495000e+05,  8.236000e+05,  1.391300e+06,  1.731100e+06,
         1.805000e+06,  5.075000e+05,  8.975000e+05,  1.790200e+06,
         3.722000e+05,  2.850000e+04,  1.424000e+05,  3.921000e+05,
         7.472000e+05, -6.680000e+04,  2.416000e+05, -7.000000e+03,
         2.767000e+05, -4.980000e+04,  8.720000e+04,  3.348000e+05,
         6.781000e+05, -8.400000e+03,  1.993100e+06,  4.344000e+05,
         9.733000e+05,  1.636600e+06,  5.204000e+05,  8.890000e+04,
         5.901000e+05,  4.312000e+05,  5.247000e+05, -4.350000e+04,
         3.883000e+05,  7.720000e+04,  4.354000e+05,  3.777000e+05,
         2.624000e+05,  4.000000e+02,  5.000000e+02,  3.057000e+05,
         9.505000e+05, -7.078000e+05,  1.244000e+05,  3.440000e+04,
         3.440000e+04,  1.480000e+04,  1.480000e+04,  3.897000e+05,
         1.560000e+04, -4.116000e+05,  1.480000e+04,  4.170000e+04,
         4.170000e+04,  4.170000e+04,  4.170000e+04,  3.950000e+04,
        -4.750000e+04, -4.750000e+04, -4.750000e+04,  3.361000e+05,
        -5.900000e+03,  0.000000e+00, -2.720000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.851000e+05, -6.990000e+04, -2.760000e+04,
         1.121200e+06,  4.744000e+05,  4.757000e+05,  6.024000e+05,
         6.031000e+05, -6.500000e+03, -4.650000e+04, -1.210000e+04,
        -2.020000e+04,  7.650000e+04,  5.390000e+04, -2.200000e+03,
         3.563000e+05,  1.430000e+04,  1.259000e+05,  5.000000e+02,
         0.000000e+00, -8.000000e+02, -1.760000e+04, -3.660000e+04,
         7.310000e+04, -9.400000e+03, -9.400000e+03, -9.400000e+03,
         0.000000e+00,  0.000000e+00,  3.264000e+05,  4.429000e+05,
         2.063000e+05,  3.390000e+04, -5.680000e+04,  6.760000e+04,
        -2.880000e+04, -2.000000e+04,  1.775000e+05,  6.320000e+04,
        -4.790000e+04, -4.790000e+04, -2.450000e+04,  7.920000e+04,
        -2.600000e+03, -7.240000e+04,  3.130000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  8.000000e+02,  6.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.020000e+04,
        -4.650000e+04,  4.670000e+04,  5.000000e+02,  1.259000e+05,
         4.170000e+04,  8.000000e+02, -1.380000e+04,  1.889000e+05,
        -9.800000e+03,  2.900000e+04,  4.100000e+03,  3.984000e+05,
         3.897000e+05,  1.480000e+04,  3.440000e+04, -4.750000e+04,
        -2.760000e+04, -1.210000e+04, -9.400000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.170000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.990000e+05,  3.524100e+06,  4.259000e+05,  8.400000e+03,
         1.041000e+05,  6.305000e+05,  2.323000e+05,  2.232000e+05,
         3.523600e+06,  2.282000e+05,  3.514600e+06,  4.293000e+05,
         2.068000e+06, -8.842000e+05,  0.000000e+00,  4.293000e+05,
         3.272000e+05,  4.317000e+05,  2.393000e+05,  1.712700e+06,
         0.000000e+00,  3.850000e+05,  5.163600e+06,  7.626000e+05,
         6.600000e+04,  3.745100e+06,  8.916100e+06,  1.269400e+06,
         9.749000e+05,  2.532500e+06,  3.839500e+06,  5.840000e+06,
         1.750000e+04, -2.215000e+05, -2.218000e+05, -2.157000e+05,
        -2.237000e+05, -7.748000e+05, -2.202000e+05, -3.941900e+06,
         2.424900e+06, -3.438400e+06, -4.538000e+05,  1.130500e+06,
        -3.280000e+05,  1.136000e+05, -2.944000e+05, -5.830000e+04,
        -5.860000e+04,  1.792500e+06,  3.636400e+06,  2.990000e+05,
         8.410000e+04,  1.188000e+05,  1.707000e+06,  1.096240e+07,
        -8.935000e+05,  4.269000e+05,  3.321000e+05, -2.921000e+05,
         1.070000e+06,  1.071600e+06,  4.293300e+06,  1.321700e+06,
        -1.023000e+05,  1.016200e+06,  2.810000e+05,  1.131000e+05,
         8.010000e+04,  9.886000e+05,  5.018000e+05, -3.900000e+05,
         4.365000e+05,  8.460000e+05,  8.460000e+05,  8.459000e+05,
         8.460000e+05,  4.192800e+06,  4.192900e+06, -4.598000e+05,
         7.391000e+05,  2.406500e+06, -6.610000e+04,  0.000000e+00,
         1.769900e+06,  3.767000e+05, -5.672000e+05,  6.753000e+05,
         4.834000e+05,  4.834000e+05,  3.237000e+05,  3.236000e+05,
         3.238000e+05,  3.406400e+06,  1.176120e+07,  7.764000e+05,
         1.075000e+05,  1.793700e+06,  6.800600e+06, -2.432000e+05,
         1.039690e+07,  3.619900e+06,  1.533410e+07,  3.619900e+06,
         1.533740e+07,  1.011700e+06, -3.143500e+06, -4.448100e+06,
         3.496800e+06,  2.025000e+05,  1.790200e+06,  3.602120e+07,
        -7.530000e+05,  5.551000e+05,  2.148500e+06, -2.916000e+05,
        -8.048000e+05, -5.881000e+05,  4.389500e+06, -2.105000e+05,
        -1.896300e+06, -7.980000e+04,  1.917400e+06, -6.470000e+04,
        -1.373500e+06,  1.244100e+06,  7.876100e+06,  5.646000e+05,
        -2.593000e+05,  2.917100e+06,  1.753400e+06,  1.926600e+06,
         6.679600e+06,  6.204000e+05,  1.775700e+06, -1.397000e+05,
         6.949800e+06,  2.194200e+06,  4.247000e+05,  4.028000e+05,
         2.253900e+06,  6.018000e+05,  6.021000e+05,  5.625300e+06,
         1.068900e+07,  2.748200e+06,  1.131500e+07,  5.897000e+05,
         5.904000e+05,  1.304000e+05,  1.305000e+05,  7.210000e+04,
         1.321000e+05, -1.806000e+05,  1.305000e+05,  6.642000e+05,
         6.642000e+05,  6.642000e+05,  6.634000e+05,  6.358000e+05,
        -6.798000e+05, -6.793000e+05, -6.794000e+05, -1.047400e+06,
         2.652000e+05,  0.000000e+00, -4.071000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -4.077800e+06, -1.177900e+06, -5.235000e+05,
        -9.530000e+04,  1.406400e+06,  1.412700e+06,  3.408400e+06,
         3.410000e+06, -7.190000e+04, -3.065000e+05, -2.277000e+05,
        -1.631000e+05,  1.455200e+06,  1.095200e+06, -3.790000e+04,
        -8.842000e+05,  4.287000e+05,  2.789900e+06,  4.000000e+03,
         0.000000e+00,  3.880000e+04, -2.953000e+05, -4.304000e+05,
         1.102500e+06, -1.509000e+05, -1.512000e+05, -1.512000e+05,
         0.000000e+00,  0.000000e+00, -1.112700e+06,  4.710000e+05,
         4.189500e+06,  8.161000e+05, -5.933000e+05,  1.019500e+06,
        -2.271000e+05, -1.657000e+05, -4.498000e+05,  1.393000e+06,
        -3.124000e+05, -3.123000e+05, -2.048000e+05,  1.380500e+06,
        -4.160000e+04, -5.159000e+05,  1.068700e+06,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.600000e+03,  4.100000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.631000e+05,
        -3.065000e+05, -1.160000e+05,  4.000000e+03,  2.789900e+06,
         6.642000e+05,  1.600000e+03,  1.990000e+05,  3.524100e+06,
         3.236000e+05,  8.460000e+05,  7.391000e+05, -2.234000e+05,
         7.210000e+04,  1.305000e+05,  5.904000e+05, -6.794000e+05,
        -5.235000e+05, -2.277000e+05, -1.512000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         6.642000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-1.227000e+05, -5.980000e+04, -5.330000e+04, -5.530000e+04,
        -8.870000e+04, -5.103000e+05, -2.650000e+05, -1.203000e+05,
        -5.980000e+04, -1.198000e+05, -5.970000e+04, -9.660000e+04,
        -6.690000e+04,  5.088000e+05,  0.000000e+00, -9.660000e+04,
        -6.350000e+04, -9.640000e+04, -7.700000e+03, -3.866000e+05,
         0.000000e+00,  2.165000e+05,  3.087000e+05,  3.193000e+05,
         3.112000e+05, -1.798000e+05, -1.850000e+05, -2.918000e+05,
        -1.894000e+05,  7.669700e+06,  7.063500e+06,  7.733000e+06,
         1.573300e+06,  4.385000e+05,  4.381000e+05,  4.384000e+05,
         4.407000e+05,  6.035000e+05,  4.385000e+05,  3.943200e+06,
         4.065900e+06,  4.080400e+06,  4.118000e+05,  4.420000e+05,
         4.461000e+05, -1.439000e+05, -1.030000e+05,  5.590000e+05,
         5.590000e+05,  3.115000e+05,  6.530000e+04,  3.141000e+05,
         3.720000e+05,  8.397000e+05,  8.701000e+05, -3.676000e+05,
         4.478000e+05, -1.519000e+05, -1.186000e+05, -1.036000e+05,
         6.105000e+05,  6.109000e+05,  6.730000e+05,  6.791000e+05,
        -3.047000e+05, -1.738000e+05, -1.428000e+05, -4.288000e+05,
        -6.110000e+04, -1.349000e+05, -5.440000e+04,  2.100000e+04,
        -6.620000e+04, -1.942000e+05, -1.942000e+05, -1.942000e+05,
        -1.942000e+05, -1.306000e+05, -1.306000e+05,  4.104000e+05,
        -1.604000e+05, -1.288000e+05,  4.800000e+03,  0.000000e+00,
        -2.434000e+05, -2.492000e+05,  4.428000e+05,  1.131000e+05,
        -5.480000e+04, -5.480000e+04, -6.330000e+04, -6.330000e+04,
        -6.330000e+04, -6.828000e+05, -5.238000e+05,  5.243000e+05,
         1.349000e+05, -3.518000e+05, -2.556000e+05, -1.362000e+05,
        -7.561000e+05, -7.498000e+05, -5.270000e+05, -7.498000e+05,
        -5.274000e+05,  4.610000e+05,  1.783500e+06,  2.388300e+06,
         1.910300e+06,  3.418000e+05,  3.722000e+05, -7.530000e+05,
         7.729200e+06,  7.119100e+06,  7.152900e+06,  4.438000e+05,
         8.803000e+05,  7.104900e+06,  7.217100e+06,  7.207800e+06,
         7.717500e+06, -1.417000e+05, -3.626000e+05,  1.655000e+05,
         7.703000e+05, -4.392000e+05,  3.176000e+05,  3.370000e+05,
         7.543000e+05,  8.152000e+05,  2.232000e+05, -3.614000e+05,
        -2.709000e+05,  2.445000e+05,  2.264000e+05, -1.438000e+05,
        -2.662000e+05, -3.530000e+05,  3.629000e+05,  3.059000e+05,
         5.840000e+04, -2.170000e+05, -2.170000e+05, -1.244000e+05,
         3.548200e+06,  3.396200e+06, -3.645600e+06, -6.530000e+04,
        -6.540000e+04,  7.196500e+06,  7.201200e+06,  3.706000e+05,
         7.201600e+06,  1.403510e+07,  7.201200e+06, -7.080000e+04,
        -7.080000e+04, -7.080000e+04, -7.080000e+04, -7.290000e+04,
         7.170000e+04,  7.170000e+04,  7.170000e+04,  4.893000e+05,
        -1.162000e+05,  0.000000e+00,  4.500000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  4.302000e+05,  7.342400e+06,  7.271800e+06,
         1.119200e+06,  2.300000e+05,  2.310000e+05,  1.940000e+04,
         1.980000e+04,  5.700000e+03,  6.600000e+03,  4.600000e+03,
        -1.950000e+04,  8.200000e+03,  3.900000e+03,  5.500000e+03,
         5.088000e+05, -9.670000e+04,  1.030000e+04,  5.000000e+02,
         0.000000e+00,  0.000000e+00,  9.700000e+03, -1.930000e+04,
         8.500000e+03,  1.630000e+04,  1.630000e+04,  1.630000e+04,
         0.000000e+00,  0.000000e+00,  4.810000e+05,  5.129000e+05,
         1.480000e+04, -5.400000e+03, -3.880000e+04,  7.800000e+03,
        -2.700000e+04, -1.970000e+04,  2.534000e+05,  5.300000e+03,
         7.500000e+03,  7.500000e+03, -2.440000e+04,  4.500000e+03,
         4.200000e+03, -1.660000e+04,  1.210000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  4.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.950000e+04,
         6.600000e+03,  6.680000e+04,  5.000000e+02,  1.030000e+04,
        -7.080000e+04,  4.000000e+02, -1.227000e+05, -5.980000e+04,
        -6.330000e+04, -1.942000e+05, -1.604000e+05,  4.407000e+05,
         3.706000e+05,  7.201200e+06, -6.540000e+04,  7.170000e+04,
         7.271800e+06,  4.600000e+03,  1.630000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -7.080000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 7.960000e+04,  4.220000e+04,  4.050000e+04, -3.100000e+03,
         3.820000e+04,  3.281000e+05,  1.688000e+05,  7.870000e+04,
         4.220000e+04,  7.850000e+04,  4.210000e+04,  6.780000e+04,
         4.980000e+04, -7.600000e+04,  0.000000e+00,  6.780000e+04,
         2.620000e+04,  6.770000e+04,  5.700000e+03,  2.717000e+05,
         0.000000e+00,  1.313000e+05,  7.240000e+04,  7.340000e+04,
         3.100000e+03,  6.550000e+04,  1.362000e+05,  2.058000e+05,
         7.740000e+04,  7.444700e+06,  7.586700e+06,  7.406000e+06,
         4.900000e+04, -2.020000e+04, -2.170000e+04, -1.960000e+04,
        -1.810000e+04, -6.480000e+04, -2.140000e+04, -2.188000e+05,
        -3.002000e+05, -2.961000e+05, -8.200000e+03, -2.680000e+04,
        -2.760000e+04,  3.510000e+04, -3.480000e+04, -4.700000e+03,
        -4.800000e+03,  2.660000e+04,  5.800000e+04,  2.670000e+04,
         6.700000e+03,  4.130000e+04,  2.220000e+04,  1.791000e+05,
        -7.880000e+04,  6.390000e+04,  2.280000e+04, -3.460000e+04,
         1.542000e+05,  1.545000e+05,  1.153000e+05,  1.156000e+05,
         1.880000e+05,  1.279000e+05,  9.450000e+04,  2.702000e+05,
         2.650000e+04,  8.250000e+04,  4.280000e+04, -1.430000e+04,
         5.490000e+04,  1.369000e+05,  1.369000e+05,  1.369000e+05,
         1.369000e+05,  9.820000e+04,  9.820000e+04, -6.400000e+03,
         9.280000e+04,  7.390000e+04, -6.100000e+03,  0.000000e+00,
         2.520000e+04,  3.180000e+04, -4.960000e+04,  5.930000e+04,
         4.270000e+04,  4.270000e+04,  2.590000e+04,  2.590000e+04,
         2.590000e+04,  4.475000e+05,  3.514000e+05,  1.606000e+05,
         1.302000e+05,  2.498000e+05,  1.898000e+05,  7.790000e+04,
         2.562000e+05,  5.358000e+05,  4.003000e+05,  5.358000e+05,
         3.999000e+05,  2.490000e+05, -1.414000e+05, -2.849000e+05,
        -2.189000e+05,  4.750000e+04,  2.850000e+04,  5.551000e+05,
         7.119100e+06,  7.366200e+06,  7.265200e+06, -2.710000e+04,
        -7.070000e+04,  7.204200e+06,  7.158700e+06,  7.146300e+06,
         6.972300e+06,  8.300000e+04,  2.629000e+05,  1.549000e+05,
         1.100000e+04,  2.987000e+05,  5.950000e+04,  5.830000e+04,
         3.900000e+04,  8.000000e+02,  1.465000e+05,  2.621000e+05,
         2.063000e+05,  1.156000e+05,  1.477000e+05,  8.730000e+04,
         2.035000e+05,  2.566000e+05,  3.460000e+04,  3.320000e+04,
         6.450000e+04,  1.467000e+05,  1.468000e+05,  9.190000e+04,
         3.864600e+06,  3.960000e+06,  2.490600e+06,  4.910000e+04,
         4.910000e+04,  7.174500e+06,  7.179200e+06,  6.400000e+03,
         7.179500e+06,  1.432300e+07,  7.179200e+06,  5.600000e+04,
         5.600000e+04,  5.600000e+04,  5.710000e+04,  5.680000e+04,
        -6.000000e+04, -6.000000e+04, -6.000000e+04, -6.690000e+04,
         7.710000e+04,  0.000000e+00, -3.650000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.600000e+05,  7.064100e+06,  7.121700e+06,
        -9.400000e+03,  1.189000e+05,  1.194000e+05,  2.879000e+05,
         2.882000e+05, -6.500000e+03, -2.710000e+04, -1.100000e+03,
         9.100000e+03, -8.100000e+03, -4.800000e+03, -4.200000e+03,
        -7.600000e+04,  6.800000e+04, -1.230000e+04, -2.000000e+02,
         0.000000e+00,  0.000000e+00, -5.900000e+03,  1.030000e+04,
        -7.700000e+03, -1.290000e+04, -1.290000e+04, -1.290000e+04,
         0.000000e+00,  0.000000e+00, -6.340000e+04, -8.240000e+04,
        -1.840000e+04,  1.000000e+02,  1.930000e+04, -7.100000e+03,
         1.230000e+04,  9.600000e+03, -3.860000e+04, -6.000000e+03,
        -2.870000e+04, -2.870000e+04,  1.190000e+04, -5.800000e+03,
        -3.300000e+03, -1.730000e+04, -3.460000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  3.000000e+02,  3.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  9.100000e+03,
        -2.710000e+04, -1.000000e+04, -2.000000e+02, -1.230000e+04,
         5.600000e+04,  3.000000e+02,  7.960000e+04,  4.220000e+04,
         2.590000e+04,  1.369000e+05,  9.280000e+04, -1.810000e+04,
         6.400000e+03,  7.179200e+06,  4.910000e+04, -6.000000e+04,
         7.121700e+06, -1.100000e+03, -1.290000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         5.600000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-5.410000e+04,  2.184000e+05,  3.990000e+04,  1.340000e+04,
        -2.010000e+04, -2.626000e+05, -1.544000e+05, -4.760000e+04,
         2.184000e+05, -4.630000e+04,  2.182000e+05,  9.100000e+03,
         1.402000e+05, -8.750000e+04,  0.000000e+00,  9.100000e+03,
         4.140000e+04,  9.600000e+03,  1.630000e+04,  3.530000e+04,
         0.000000e+00, -6.410000e+04,  3.910000e+05,  8.000000e+04,
         4.070000e+04,  2.554000e+05,  5.697000e+05,  2.360000e+04,
         1.242000e+05,  7.425100e+06,  7.518500e+06,  7.707400e+06,
         1.256000e+05, -1.530000e+04, -1.700000e+04, -1.420000e+04,
        -1.340000e+04, -7.080000e+04, -1.670000e+04, -5.089000e+05,
         9.350000e+04, -3.168000e+05, -7.920000e+04,  7.180000e+04,
        -3.120000e+04, -6.600000e+03, -1.000000e+02,  3.240000e+04,
         3.240000e+04,  1.361000e+05,  2.422000e+05,  5.400000e+04,
         3.080000e+04,  4.110000e+04,  1.923000e+05,  7.105000e+05,
        -7.540000e+04,  2.100000e+04,  5.450000e+04,  3.000000e+02,
         5.990000e+04,  6.020000e+04,  3.567000e+05,  1.560000e+05,
        -2.476000e+05,  6.230000e+04, -5.370000e+04, -2.980000e+05,
         3.550000e+04,  1.127000e+05,  5.410000e+04, -3.010000e+04,
         6.040000e+04,  1.520000e+04,  1.520000e+04,  1.520000e+04,
         1.520000e+04,  2.907000e+05,  2.907000e+05, -7.900000e+04,
         4.830000e+04,  1.852000e+05, -6.400000e+03,  0.000000e+00,
         9.770000e+04,  3.750000e+04, -4.470000e+04,  9.250000e+04,
         4.990000e+04,  4.990000e+04,  4.100000e+04,  4.100000e+04,
         4.110000e+04,  1.912000e+05,  8.790000e+05,  4.400000e+03,
        -1.103000e+05,  8.160000e+04,  4.925000e+05, -1.371000e+05,
         7.289000e+05,  1.253000e+05,  1.089500e+06,  1.253000e+05,
         1.090100e+06, -6.030000e+04, -4.566000e+05, -5.506000e+05,
         1.036000e+05, -8.800000e+03,  1.424000e+05,  2.148500e+06,
         7.152900e+06,  7.265200e+06,  7.495200e+06, -2.330000e+04,
        -5.810000e+04,  7.011600e+06,  7.446700e+06,  7.155700e+06,
         6.904400e+06, -1.206000e+05,  9.240000e+04, -1.871000e+05,
        -2.821000e+05, -9.210000e+04,  5.694000e+05,  5.310000e+04,
        -9.000000e+04,  2.126000e+05,  1.998000e+05,  9.470000e+04,
         5.476000e+05, -2.200000e+03,  2.019000e+05, -1.304000e+05,
         5.087000e+05,  9.600000e+04,  5.520000e+04,  7.290000e+04,
         1.765000e+05, -4.890000e+04, -4.880000e+04,  3.644000e+05,
         4.417100e+06,  3.660700e+06, -5.905000e+05,  6.420000e+04,
         6.420000e+04,  7.217200e+06,  7.221900e+06,  3.190000e+04,
         7.222200e+06,  1.438710e+07,  7.221900e+06,  7.230000e+04,
         7.230000e+04,  7.230000e+04,  7.370000e+04,  6.570000e+04,
        -7.040000e+04, -7.030000e+04, -7.030000e+04, -1.328000e+05,
        -3.640000e+04,  0.000000e+00, -4.180000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -4.221000e+05,  7.078500e+06,  7.150200e+06,
         6.830000e+04,  1.766000e+05,  1.766000e+05,  3.942000e+05,
         3.945000e+05, -7.700000e+03, -2.800000e+04, -1.190000e+04,
        -4.530000e+04,  8.050000e+04,  5.380000e+04, -3.100000e+03,
        -8.750000e+04,  8.900000e+03,  1.245000e+05,  1.100000e+03,
         0.000000e+00, -8.000000e+02, -2.430000e+04, -6.860000e+04,
         7.360000e+04, -1.630000e+04, -1.630000e+04, -1.630000e+04,
         0.000000e+00,  0.000000e+00, -1.492000e+05, -3.000000e+02,
         2.058000e+05,  2.250000e+04, -1.138000e+05,  6.810000e+04,
        -6.120000e+04, -4.620000e+04, -4.460000e+04,  6.230000e+04,
        -2.710000e+04, -2.710000e+04, -5.740000e+04,  8.020000e+04,
        -4.900000e+03, -8.390000e+04,  5.320000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  3.000000e+02,  6.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -4.530000e+04,
        -2.800000e+04, -1.150000e+04,  1.100000e+03,  1.245000e+05,
         7.230000e+04,  3.000000e+02, -5.410000e+04,  2.184000e+05,
         4.100000e+04,  1.520000e+04,  4.830000e+04, -1.340000e+04,
         3.190000e+04,  7.221900e+06,  6.420000e+04, -7.030000e+04,
         7.150200e+06, -1.190000e+04, -1.630000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         7.230000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-3.850000e+04, -2.440000e+04, -1.780000e+04, -6.660000e+04,
        -5.240000e+04, -1.601000e+05, -8.310000e+04, -3.700000e+04,
        -2.440000e+04, -3.670000e+04, -2.430000e+04, -2.770000e+04,
        -2.180000e+04,  4.404000e+05,  0.000000e+00, -2.770000e+04,
        -4.610000e+04, -2.730000e+04, -2.500000e+03, -1.125000e+05,
         0.000000e+00,  3.505000e+05,  3.628000e+05,  3.808000e+05,
         2.908000e+05, -1.370000e+05, -7.320000e+04, -8.870000e+04,
        -1.364000e+05,  7.019000e+05,  2.324000e+05,  7.126000e+05,
         1.499600e+06,  4.168000e+05,  4.169000e+05,  4.158000e+05,
         4.167000e+05,  5.387000e+05,  4.172000e+05,  3.761900e+06,
         3.779600e+06,  3.802300e+06,  4.099000e+05,  4.141000e+05,
         4.200000e+05, -1.194000e+05, -1.547000e+05,  5.324000e+05,
         5.324000e+05,  3.159000e+05,  1.012000e+05,  3.210000e+05,
         3.650000e+05,  8.424000e+05,  8.466000e+05, -2.359000e+05,
         3.654000e+05, -9.750000e+04, -1.122000e+05, -1.543000e+05,
         7.466000e+05,  7.470000e+05,  7.566000e+05,  7.668000e+05,
        -9.520000e+04, -5.270000e+04, -4.410000e+04, -1.336000e+05,
        -4.790000e+04, -6.960000e+04, -1.850000e+04,  9.000000e+03,
        -2.080000e+04, -5.950000e+04, -5.950000e+04, -5.950000e+04,
        -5.950000e+04, -4.850000e+04, -4.850000e+04,  4.099000e+05,
        -7.570000e+04, -6.920000e+04,  2.411900e+06,  0.000000e+00,
         2.192800e+06,  2.192000e+06,  3.904000e+05,  1.538000e+05,
        -1.860000e+04, -1.860000e+04, -4.550000e+04, -4.550000e+04,
        -4.550000e+04, -2.639000e+05, -2.351000e+05,  6.723000e+05,
         2.553900e+06,  4.713200e+06,  4.763200e+06,  7.146900e+06,
         4.285300e+06, -2.315000e+05, -1.930000e+05, -2.315000e+05,
        -1.937000e+05,  7.054000e+05,  1.683600e+06,  2.152800e+06,
         1.705200e+06,  3.880000e+05,  3.921000e+05, -2.916000e+05,
         4.438000e+05, -2.710000e+04, -2.330000e+04,  2.871800e+06,
         8.052000e+05, -1.360000e+04,  2.500000e+03,  1.670000e+04,
         4.572000e+05,  2.379800e+06, -1.100000e+05,  3.353000e+05,
         8.057000e+05, -1.351000e+05,  3.562000e+05,  3.858000e+05,
         8.001000e+05,  8.085000e+05,  3.398000e+05, -1.122000e+05,
        -9.950000e+04,  3.583000e+05,  3.441000e+05,  2.390300e+06,
        -9.660000e+04, -1.136000e+05,  3.863000e+05,  3.151000e+05,
         9.860000e+04, -6.750000e+04, -6.750000e+04, -4.790000e+04,
         1.724000e+05,  1.515000e+05, -1.129800e+06,  2.401900e+06,
         2.405700e+06,  3.000000e+03,  3.000000e+03,  3.627000e+05,
         3.300000e+03, -3.868000e+05,  3.000000e+03, -2.420000e+04,
        -2.420000e+04, -2.420000e+04, -2.410000e+04, -1.790000e+04,
         2.299400e+06,  2.297800e+06,  2.298100e+06,  4.342000e+05,
        -3.420000e+04,  0.000000e+00,  1.409400e+06,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.379420e+07,  4.780000e+04,  2.540000e+04,
         1.067400e+06,  3.156000e+05,  3.168000e+05,  2.449000e+05,
         2.453000e+05,  2.426400e+06, -1.990000e+04,  3.400000e+03,
        -6.100000e+03, -1.900000e+03, -2.000000e+02,  1.700000e+03,
         4.404000e+05, -2.790000e+04,  4.000000e+02,  1.000000e+02,
         0.000000e+00,  0.000000e+00,  6.400000e+03, -3.400000e+03,
         1.900000e+03,  5.600000e+03,  5.600000e+03,  5.600000e+03,
         0.000000e+00,  0.000000e+00,  4.320000e+05,  4.386000e+05,
        -9.000000e+02, -2.600000e+03, -9.500000e+03,  1.700000e+03,
        -7.600000e+03, -6.000000e+03,  2.186000e+05,  4.000000e+02,
        -2.100000e+04, -2.100000e+04, -6.600000e+03, -1.000000e+03,
         1.600000e+03, -2.770000e+04, -2.190000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  3.000000e+02,  2.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.000000e+02, -6.100000e+03,
        -1.990000e+04,  5.780000e+04,  1.000000e+02,  4.000000e+02,
        -2.420000e+04,  3.000000e+02, -3.850000e+04, -2.440000e+04,
        -4.550000e+04, -5.950000e+04, -7.570000e+04,  4.167000e+05,
         3.627000e+05,  3.000000e+03,  2.405700e+06,  2.298200e+06,
         2.540000e+04,  3.400000e+03,  5.600000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -2.420000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-8.910000e+04, -6.860000e+04, -4.560000e+04,  2.178000e+05,
         6.420000e+04, -3.660000e+05, -1.879000e+05, -8.780000e+04,
        -6.860000e+04, -8.760000e+04, -6.830000e+04, -7.620000e+04,
        -6.670000e+04,  8.730000e+05,  0.000000e+00, -7.620000e+04,
         7.870000e+04, -7.610000e+04, -7.700000e+03, -3.039000e+05,
         0.000000e+00,  6.447000e+05,  6.838000e+05,  7.093000e+05,
         1.155800e+06,  2.397000e+05, -1.983000e+05, -2.271000e+05,
         2.420000e+05,  1.273800e+06,  3.255000e+05,  1.294700e+06,
         6.610100e+06,  8.082000e+05,  8.099000e+05,  8.078000e+05,
         8.082000e+05,  1.058900e+06,  8.102000e+05,  7.332200e+06,
         7.388600e+06,  7.418300e+06,  7.972000e+05,  8.090000e+05,
         8.188000e+05,  2.820000e+05,  5.732000e+05,  1.460400e+06,
         1.460200e+06,  1.003000e+06,  5.463000e+05,  1.007100e+06,
         9.181000e+05,  2.450200e+06,  2.462600e+06,  1.763000e+05,
         1.117100e+06,  1.449000e+05,  2.986000e+05,  5.732000e+05,
         1.396400e+06,  1.396700e+06,  1.423100e+06,  1.439500e+06,
        -2.076000e+05, -1.414000e+05, -1.043000e+05, -2.959000e+05,
         9.550000e+04,  1.370000e+04, -4.920000e+04,  1.130000e+04,
        -6.930000e+04, -1.518000e+05, -1.518000e+05, -1.517000e+05,
        -1.518000e+05, -1.335000e+05, -1.335000e+05,  7.964000e+05,
         8.400000e+03,  1.790000e+04, -4.400000e+03,  0.000000e+00,
        -4.490000e+05, -4.405000e+05,  9.669000e+05,  4.147000e+05,
        -4.900000e+04, -4.900000e+04,  8.060000e+04,  8.060000e+04,
         8.060000e+04, -2.737000e+05, -2.291000e+05,  1.641300e+06,
         8.735000e+05, -2.999000e+05, -2.725000e+05, -1.112000e+05,
        -1.156300e+06, -5.948000e+05, -5.311000e+05, -5.948000e+05,
        -5.321000e+05,  1.297800e+06,  3.312000e+06,  4.259900e+06,
         3.352100e+06,  7.349000e+05,  7.472000e+05, -8.048000e+05,
         8.803000e+05, -7.070000e+04, -5.810000e+04,  8.052000e+05,
         1.808400e+06, -2.790000e+04,  2.600000e+03,  3.670000e+04,
         9.230000e+05, -1.080000e+05, -2.900000e+05,  6.200000e+05,
         1.569000e+06, -3.290000e+05,  6.818000e+05,  7.277000e+05,
         1.534800e+06,  1.559500e+06,  6.055000e+05, -2.911000e+05,
        -2.557000e+05,  6.593000e+05,  6.142000e+05, -1.000000e+05,
        -2.650000e+05, -3.066000e+05,  7.316000e+05,  1.007700e+06,
         5.505000e+05, -1.627000e+05, -1.627000e+05, -1.347000e+05,
         2.377000e+05,  1.759000e+05, -2.756700e+06, -6.870000e+04,
        -6.870000e+04,  6.200000e+03,  6.200000e+03,  9.211000e+05,
         6.500000e+03, -7.326000e+05,  6.200000e+03, -6.500000e+04,
        -6.500000e+04, -6.500000e+04, -6.490000e+04, -6.470000e+04,
         5.880000e+04,  5.870000e+04,  5.870000e+04,  8.632000e+05,
        -8.590000e+04,  0.000000e+00,  3.490000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  3.526000e+05,  1.334000e+05,  6.980000e+04,
         2.900000e+06,  7.906000e+05,  7.900000e+05,  5.958000e+05,
         5.961000e+05, -3.500000e+03,  1.309000e+05, -4.400000e+03,
        -9.800000e+03, -1.200000e+03, -9.000000e+02,  5.100000e+03,
         8.730000e+05, -7.610000e+04, -3.700000e+03,  2.000000e+02,
         0.000000e+00,  0.000000e+00,  4.800000e+03, -1.770000e+04,
        -2.600000e+03,  1.480000e+04,  1.480000e+04,  1.480000e+04,
         0.000000e+00,  0.000000e+00,  8.599000e+05,  8.747000e+05,
        -3.300000e+03, -4.400000e+03, -2.750000e+04, -2.400000e+03,
        -1.240000e+04, -9.700000e+03,  4.333000e+05, -1.700000e+03,
         1.373000e+05,  1.373000e+05, -1.500000e+04, -1.100000e+03,
         3.500000e+03,  1.230000e+05,  1.362000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  3.000000e+02, -1.300000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -9.800000e+03,
         1.309000e+05,  1.145000e+05,  2.000000e+02, -3.700000e+03,
        -6.500000e+04,  3.000000e+02, -8.910000e+04, -6.860000e+04,
         8.060000e+04, -1.518000e+05,  8.400000e+03,  8.082000e+05,
         9.211000e+05,  6.200000e+03, -6.870000e+04,  5.870000e+04,
         6.980000e+04, -4.400000e+03,  1.480000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -6.500000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 3.229000e+05, -4.480000e+04, -9.800000e+03, -5.180000e+04,
         1.347000e+05,  1.433700e+06,  7.881000e+05,  3.037000e+05,
        -4.480000e+04,  2.998000e+05, -4.480000e+04,  1.318000e+05,
        -3.730000e+04,  4.180000e+04,  0.000000e+00,  1.318000e+05,
        -5.130000e+04,  1.299000e+05, -4.600000e+03,  5.301000e+05,
         0.000000e+00,  4.511000e+05, -1.153000e+05, -4.930000e+04,
        -1.146000e+05, -1.434000e+05, -1.428000e+05,  4.085000e+05,
        -1.596000e+05,  7.125700e+06,  7.226200e+06,  6.746400e+06,
        -3.052000e+05, -1.750000e+04, -1.770000e+04, -1.830000e+04,
        -1.460000e+04,  2.400000e+04, -1.740000e+04,  7.130000e+05,
        -4.080000e+04,  4.580000e+04,  1.753000e+05, -1.010000e+04,
         8.500000e+03,  8.200000e+04, -1.048000e+05, -1.015000e+05,
        -1.014000e+05, -1.157000e+05, -1.301000e+05, -9.270000e+04,
        -6.960000e+04, -2.940000e+04, -2.163000e+05, -2.876000e+05,
        -4.700000e+03,  8.300000e+04, -1.040000e+05, -1.044000e+05,
         1.820000e+05,  1.823000e+05, -2.002000e+05, -1.517000e+05,
         1.075100e+06,  1.309000e+05,  3.564000e+05,  1.392700e+06,
        -6.820000e+04, -1.074000e+05, -4.240000e+04,  2.400000e+03,
        -7.450000e+04,  2.734000e+05,  2.734000e+05,  2.733000e+05,
         2.734000e+05, -1.044000e+05, -1.045000e+05,  1.774000e+05,
         8.540000e+04, -1.006000e+05,  2.300000e+03,  0.000000e+00,
        -1.080000e+04, -1.940000e+04, -1.030000e+04, -9.480000e+04,
        -3.120000e+04, -3.120000e+04, -5.210000e+04, -5.210000e+04,
        -5.210000e+04,  5.245000e+05, -4.173000e+05,  3.348000e+05,
         5.780000e+05,  3.576000e+05, -2.076000e+05,  5.335000e+05,
        -2.390000e+05,  8.989000e+05, -4.235000e+05,  8.989000e+05,
        -4.250000e+05,  7.126000e+05,  8.154000e+05,  7.191000e+05,
         5.790000e+04,  1.199000e+05, -6.680000e+04, -5.881000e+05,
         7.104900e+06,  7.204200e+06,  7.011600e+06, -1.360000e+04,
        -2.790000e+04,  7.738400e+06,  7.084500e+06,  7.238000e+06,
         7.636300e+06,  5.034000e+05,  3.609000e+05,  8.307000e+05,
         7.362000e+05,  9.253000e+05, -1.037000e+05, -3.300000e+03,
         2.995000e+05, -7.430000e+04, -1.940000e+05,  3.528000e+05,
        -2.032000e+05,  2.574000e+05, -1.966000e+05,  5.359000e+05,
        -2.160000e+05,  2.962000e+05, -7.410000e+04, -1.220000e+05,
        -1.362000e+05,  4.636000e+05,  4.635000e+05, -9.650000e+04,
         3.213300e+06,  4.147800e+06,  7.244200e+06, -5.540000e+04,
        -5.540000e+04,  7.056000e+06,  7.060700e+06, -7.010000e+04,
         7.061000e+06,  1.419840e+07,  7.060700e+06, -5.960000e+04,
        -5.960000e+04, -5.960000e+04, -5.940000e+04, -4.040000e+04,
         4.770000e+04,  4.770000e+04,  4.770000e+04,  1.803000e+05,
         2.709000e+05,  0.000000e+00,  2.480000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.862000e+05,  7.174900e+06,  7.117700e+06,
        -2.102000e+05, -1.888000e+05, -1.882000e+05, -3.665000e+05,
        -3.662000e+05,  4.500000e+03,  6.400000e+03, -1.480000e+04,
         1.383000e+05, -1.470000e+04,  5.100000e+03, -1.200000e+03,
         4.180000e+04,  1.322000e+05,  1.250000e+04, -3.300000e+03,
         0.000000e+00,  0.000000e+00,  1.170000e+04,  1.586000e+05,
        -7.500000e+03,  1.270000e+04,  1.290000e+04,  1.290000e+04,
         0.000000e+00,  0.000000e+00,  2.299000e+05,  4.890000e+04,
         1.950000e+04,  6.570000e+04,  2.968000e+05, -6.900000e+03,
         1.864000e+05,  1.423000e+05,  2.210000e+04,  6.400000e+03,
         0.000000e+00,  0.000000e+00,  1.759000e+05,  5.100000e+03,
         5.400000e+03,  1.740000e+05,  4.800000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  3.000000e+02, -9.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.383000e+05,
         6.400000e+03,  5.500000e+03, -3.300000e+03,  1.250000e+04,
        -5.960000e+04,  3.000000e+02,  3.229000e+05, -4.480000e+04,
        -5.210000e+04,  2.734000e+05,  8.540000e+04, -1.480000e+04,
        -7.010000e+04,  7.060700e+06, -5.540000e+04,  4.770000e+04,
         7.117700e+06, -1.480000e+04,  1.290000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -5.960000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-7.860000e+04,  5.181000e+05, -1.240000e+04,  7.000000e+02,
        -3.880000e+04, -3.392000e+05, -1.819000e+05, -7.530000e+04,
         5.181000e+05, -7.470000e+04,  5.168000e+05, -4.510000e+04,
         2.500000e+05,  1.140000e+04,  0.000000e+00, -4.510000e+04,
        -6.200000e+03, -4.480000e+04,  2.890000e+04, -1.811000e+05,
         0.000000e+00, -1.271000e+05,  7.349000e+05, -2.310000e+04,
        -8.600000e+03,  4.349000e+05,  1.181600e+06, -1.382000e+05,
        -1.700000e+04,  7.078300e+06,  7.019900e+06,  7.678300e+06,
        -1.186000e+05, -1.000000e+02, -1.000000e+02,  2.000000e+02,
        -4.000000e+02,  8.300000e+03,  3.000000e+02, -1.211000e+05,
         1.028100e+06,  1.750000e+04, -3.370000e+04,  2.532000e+05,
         1.000000e+03, -3.780000e+04,  8.100000e+03, -1.180000e+04,
        -1.180000e+04,  2.112000e+05,  4.334000e+05, -1.330000e+04,
        -8.200000e+03, -5.880000e+04,  2.283000e+05,  1.343200e+06,
         1.180000e+04, -4.480000e+04, -5.100000e+03,  7.600000e+03,
        -1.039000e+05, -1.035000e+05,  4.988000e+05, -3.460000e+04,
        -2.316000e+05, -6.660000e+04, -8.850000e+04, -3.105000e+05,
        -4.870000e+04, -1.840000e+04, -9.300000e+03, -3.830000e+04,
        -5.190000e+04, -9.220000e+04, -9.220000e+04, -9.210000e+04,
        -9.220000e+04,  5.066000e+05,  5.066000e+05, -3.480000e+04,
        -5.220000e+04,  2.466000e+05,  2.300000e+03,  0.000000e+00,
         2.238000e+05, -3.200000e+03,  4.700000e+03, -2.000000e+04,
        -1.040000e+04, -1.040000e+04, -5.900000e+03, -5.900000e+03,
        -5.900000e+03, -2.544000e+05,  1.242100e+06, -1.424000e+05,
        -1.579000e+05, -1.451000e+05,  7.533000e+05, -1.082000e+05,
         1.153400e+06, -3.338000e+05,  1.762000e+06, -3.338000e+05,
         1.762200e+06, -2.188000e+05, -1.134000e+05, -5.600000e+04,
         1.085900e+06, -4.550000e+04,  2.416000e+05,  4.389500e+06,
         7.217100e+06,  7.158700e+06,  7.446700e+06,  2.500000e+03,
         2.600000e+03,  7.084500e+06,  8.174900e+06,  7.188400e+06,
         7.143400e+06, -1.066000e+05, -1.514000e+05, -1.918000e+05,
        -1.348000e+05, -2.488000e+05,  1.243700e+06, -1.850000e+04,
        -7.940000e+04,  4.948000e+05, -3.370000e+04, -1.496000e+05,
         7.112000e+05, -9.210000e+04, -3.390000e+04, -1.131000e+05,
         7.489000e+05, -8.450000e+04, -1.030000e+04, -1.470000e+04,
         2.083000e+05, -1.238000e+05, -1.238000e+05,  7.722000e+05,
         4.923100e+06,  3.487600e+06, -2.006400e+06, -9.300000e+03,
        -9.300000e+03,  7.201000e+06,  7.205800e+06, -1.020000e+04,
         7.206100e+06,  1.442320e+07,  7.205800e+06, -1.150000e+04,
        -1.150000e+04, -1.150000e+04, -1.150000e+04, -1.480000e+04,
         1.460000e+04,  1.460000e+04,  1.460000e+04, -1.300000e+04,
        -6.970000e+04,  0.000000e+00,  9.900000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  8.780000e+04,  7.229700e+06,  7.217800e+06,
        -2.420000e+04, -3.200000e+04, -3.070000e+04, -6.430000e+04,
        -6.400000e+04,  2.500000e+03,  5.000000e+03, -4.050000e+04,
        -2.440000e+04,  2.680000e+05,  1.839000e+05,  2.000000e+03,
         1.140000e+04, -4.520000e+04,  4.532000e+05,  6.000000e+02,
         0.000000e+00, -3.200000e+03, -3.600000e+04, -7.070000e+04,
         2.083000e+05,  2.800000e+03,  2.800000e+03,  2.800000e+03,
         0.000000e+00,  0.000000e+00, -2.210000e+04,  2.644000e+05,
         7.036000e+05,  1.309000e+05, -9.500000e+04,  1.926000e+05,
        -3.320000e+04, -2.460000e+04,  6.100000e+03,  2.263000e+05,
         6.300000e+03,  6.300000e+03, -3.120000e+04,  2.466000e+05,
         6.000000e+02, -2.460000e+04,  2.530000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  4.000000e+02, -1.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.440000e+04,
         5.000000e+03,  1.500000e+03,  6.000000e+02,  4.532000e+05,
        -1.150000e+04,  4.000000e+02, -7.860000e+04,  5.181000e+05,
        -5.900000e+03, -9.220000e+04, -5.220000e+04, -4.000000e+02,
        -1.020000e+04,  7.205800e+06, -9.300000e+03,  1.460000e+04,
         7.217800e+06, -4.050000e+04,  2.800000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.150000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-5.290000e+04, -1.500000e+04,  1.423400e+06,  8.500000e+03,
        -2.230000e+04, -2.424000e+05, -1.367000e+05, -5.870000e+04,
        -1.500000e+04, -6.000000e+04, -1.500000e+04, -3.750000e+04,
        -1.400000e+04,  3.350000e+04,  0.000000e+00, -3.750000e+04,
        -5.300000e+03, -3.850000e+04, -1.700000e+03, -1.464000e+05,
         0.000000e+00, -6.440000e+04, -2.470000e+04,  8.517800e+06,
         1.580000e+04, -7.600000e+03, -5.000000e+04, -9.480000e+04,
        -1.630000e+04,  7.056900e+06,  6.995100e+06,  7.081000e+06,
         8.240000e+04,  8.900000e+03,  8.700000e+03,  8.600000e+03,
         1.170000e+04,  3.090000e+04,  9.100000e+03,  8.270000e+04,
         1.383000e+05,  1.912590e+07, -2.600000e+03,  1.440000e+04,
         4.758200e+06, -1.450000e+04,  2.480000e+04,  1.370000e+04,
         1.370000e+04,  1.600000e+03, -1.030000e+04,  2.850000e+06,
         3.500000e+03,  7.000000e+02,  1.600000e+04, -4.450000e+04,
         4.480000e+04, -2.710000e+04,  3.000000e+03,  1.970000e+04,
        -6.660000e+04, -6.620000e+04, -4.620000e+04,  9.455100e+06,
        -1.981000e+05, -3.420000e+04, -7.100000e+04, -3.193000e+05,
        -6.920000e+04, -2.830000e+04, -1.800000e+04, -5.600000e+04,
        -8.780000e+04, -6.560000e+04, -6.560000e+04, -6.560000e+04,
        -6.560000e+04, -3.990000e+04, -3.990000e+04,  1.400000e+03,
        -3.900000e+04, -2.260000e+04,  6.200000e+03,  0.000000e+00,
        -4.900000e+03, -9.700000e+03,  2.750000e+04, -2.320000e+04,
         6.320000e+05,  6.320000e+05, -5.500000e+03, -5.500000e+03,
        -5.500000e+03, -1.971000e+05, -1.295000e+05, -6.020000e+04,
        -8.370000e+04, -1.069000e+05, -6.840000e+04, -3.120000e+04,
        -9.340000e+04, -2.516000e+05, -1.614000e+05, -2.516000e+05,
        -1.641000e+05, -1.130000e+05,  4.040000e+04,  1.067000e+05,
         8.950000e+04, -2.250000e+04, -7.000000e+03, -2.105000e+05,
         7.207800e+06,  7.146300e+06,  7.155700e+06,  1.670000e+04,
         3.670000e+04,  7.238000e+06,  7.188400e+06,  2.152050e+07,
         7.296700e+06, -7.660000e+04, -1.109000e+05, -9.480000e+04,
        -2.640000e+04, -1.632000e+05, -1.820000e+04,  2.370930e+07,
        -2.020000e+04,  1.040000e+04, -6.480000e+04, -1.194000e+05,
        -6.840000e+04, -5.420000e+04, -6.560000e+04, -3.680000e+04,
        -8.430000e+04, -1.552000e+05, -1.460000e+04, -2.800000e+03,
        -1.490000e+04, -8.180000e+04, -8.180000e+04, -3.420000e+04,
         3.478400e+06,  3.401800e+06, -1.404400e+06, -1.690000e+04,
        -1.690000e+04,  7.167000e+06,  7.171700e+06,  2.900000e+03,
         7.172100e+06,  1.435930e+07,  7.171700e+06, -2.490000e+04,
        -2.490000e+04, -2.490000e+04, -2.470000e+04, -1.720000e+04,
         1.750000e+04,  1.750000e+04,  1.750000e+04,  1.100000e+03,
        -6.920000e+04,  0.000000e+00,  1.360000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.053000e+05,  7.214400e+06,  7.193000e+06,
         1.720000e+04, -4.610000e+04, -4.540000e+04, -1.192000e+05,
        -1.189000e+05,  8.300000e+03,  1.630000e+04, -6.290000e+04,
        -3.250000e+04, -3.300000e+03,  3.600000e+03,  3.078000e+05,
         3.350000e+04, -3.700000e+04,  8.600000e+03,  2.000000e+02,
         0.000000e+00, -1.000000e+02,  2.259800e+06, -8.090000e+04,
        -5.800000e+04,  5.400000e+03,  5.400000e+03,  5.400000e+03,
         0.000000e+00,  0.000000e+00,  1.880000e+04,  3.890000e+04,
         1.380000e+04, -1.700000e+03, -1.134000e+05, -5.370000e+04,
        -1.290000e+04, -3.100000e+04,  1.730000e+04,  4.500000e+03,
         8.500000e+03,  8.500000e+03, -2.500000e+04, -1.400000e+03,
         3.230000e+05, -1.680000e+04,  7.100000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  4.000000e+02, -6.300000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -3.250000e+04,
         1.630000e+04,  4.400000e+03,  2.000000e+02,  8.600000e+03,
        -2.490000e+04,  4.000000e+02, -5.290000e+04, -1.500000e+04,
        -5.500000e+03, -6.560000e+04, -3.900000e+04,  1.140000e+04,
         2.900000e+03,  7.171700e+06, -1.690000e+04,  1.750000e+04,
         7.193000e+06, -6.290000e+04,  5.400000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -2.490000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.205000e+05, -1.469000e+05, -1.036000e+05, -1.040000e+05,
         7.800000e+03,  5.952000e+05,  3.542000e+05,  1.047000e+05,
        -1.469000e+05,  1.015000e+05, -1.465000e+05, -3.270000e+04,
        -1.540000e+05,  6.267000e+05,  0.000000e+00, -3.270000e+04,
        -1.410000e+05, -3.410000e+04, -1.800000e+04, -1.282000e+05,
         0.000000e+00,  5.366000e+05,  1.210000e+05,  1.970000e+05,
         1.937000e+05, -3.888000e+05, -4.638000e+05, -8.890000e+04,
        -4.264000e+05,  7.351200e+06,  6.703100e+06,  7.073900e+06,
         1.219900e+06,  4.412000e+05,  4.419000e+05,  4.398000e+05,
         4.444000e+05,  6.926000e+05,  4.423000e+05,  4.874600e+06,
         4.324000e+06,  4.421800e+06,  5.953000e+05,  4.587000e+05,
         4.821000e+05, -9.710000e+04, -1.730000e+05,  4.625000e+05,
         4.626000e+05,  1.693000e+05, -1.228000e+05,  1.950000e+05,
         2.957000e+05,  7.694000e+05,  6.320000e+05, -8.344000e+05,
         5.220000e+05, -1.329000e+05, -2.455000e+05, -1.734000e+05,
         6.384000e+05,  6.388000e+05,  3.574000e+05,  4.120000e+05,
         5.824000e+05, -1.707000e+05,  1.190000e+05,  6.938000e+05,
        -1.556000e+05, -3.249000e+05, -1.395000e+05,  3.770000e+04,
        -1.956000e+05, -5.770000e+04, -5.770000e+04, -5.770000e+04,
        -5.770000e+04, -3.332000e+05, -3.332000e+05,  5.944000e+05,
        -1.679000e+05, -3.035000e+05,  1.320000e+04,  0.000000e+00,
        -2.795000e+05, -3.004000e+05,  4.821000e+05, -4.090000e+04,
        -1.288000e+05, -1.288000e+05, -1.413000e+05, -1.413000e+05,
        -1.413000e+05, -6.059000e+05, -1.292900e+06,  6.985000e+05,
         5.825000e+05, -2.437000e+05, -6.531000e+05,  3.198000e+05,
        -1.251100e+06, -3.864000e+05, -1.350900e+06, -3.864000e+05,
        -1.352400e+06,  9.250000e+05,  2.740600e+06,  3.392700e+06,
         2.187100e+06,  4.141000e+05,  2.767000e+05, -1.896300e+06,
         7.717500e+06,  6.972300e+06,  6.904400e+06,  4.572000e+05,
         9.230000e+05,  7.636300e+06,  7.143400e+06,  7.296700e+06,
         8.469100e+06,  2.785000e+05, -2.644000e+05,  8.415000e+05,
         1.495600e+06,  1.875000e+05,  1.544000e+05,  2.755000e+05,
         1.014600e+06,  7.397000e+05, -1.174000e+05, -2.705000e+05,
        -6.801000e+05,  3.861000e+05, -1.181000e+05,  3.051000e+05,
        -6.859000e+05, -3.136000e+05,  2.542000e+05,  1.510000e+05,
        -1.423000e+05,  9.980000e+04,  9.970000e+04, -3.128000e+05,
         2.897100e+06,  3.584300e+06,  1.108200e+06, -1.698000e+05,
        -1.700000e+05,  7.078700e+06,  7.083300e+06,  2.941000e+05,
         7.083700e+06,  1.391190e+07,  7.083300e+06, -1.864000e+05,
        -1.864000e+05, -1.864000e+05, -1.872000e+05, -1.701000e+05,
         1.794000e+05,  1.793000e+05,  1.793000e+05,  7.366000e+05,
         7.750000e+04,  0.000000e+00,  1.063000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.076400e+06,  7.453300e+06,  7.268300e+06,
         9.187000e+05, -7.770000e+04, -7.660000e+04, -6.351000e+05,
        -6.347000e+05,  1.670000e+04,  4.010000e+04, -9.200000e+03,
         1.098000e+05,  1.500000e+03,  1.380000e+04,  8.500000e+03,
         6.267000e+05, -3.240000e+04,  3.510000e+04, -2.600000e+03,
         0.000000e+00, -1.000000e+02,  2.750000e+04,  1.290000e+05,
         8.600000e+03,  4.200000e+04,  4.210000e+04,  4.210000e+04,
         0.000000e+00,  0.000000e+00,  7.745000e+05,  6.443000e+05,
         5.280000e+04,  6.020000e+04,  2.387000e+05,  8.000000e+03,
         1.472000e+05,  1.131000e+05,  3.140000e+05,  1.770000e+04,
         3.620000e+04,  3.620000e+04,  1.396000e+05,  1.550000e+04,
         1.290000e+04,  1.747000e+05,  5.150000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  4.000000e+02, -1.300000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.098000e+05,
         4.010000e+04,  8.220000e+04, -2.600000e+03,  3.510000e+04,
        -1.864000e+05,  4.000000e+02,  1.205000e+05, -1.469000e+05,
        -1.413000e+05, -5.770000e+04, -1.679000e+05,  4.441000e+05,
         2.941000e+05,  7.083300e+06, -1.700000e+05,  1.793000e+05,
         7.268300e+06, -9.200000e+03,  4.210000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.864000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 4.155000e+05, -5.300000e+03,  2.850000e+04, -6.210000e+04,
         1.758000e+05,  1.821900e+06,  9.911000e+05,  3.929000e+05,
        -5.300000e+03,  3.885000e+05, -5.400000e+03,  2.026000e+05,
         9.300000e+03, -2.970000e+04,  0.000000e+00,  2.026000e+05,
        -3.490000e+04,  2.020000e+05,  8.000000e+02,  8.033000e+05,
         0.000000e+00,  5.544000e+05, -5.590000e+04, -2.560000e+04,
        -1.427000e+05, -1.055000e+05, -2.050000e+04,  5.776000e+05,
        -1.112000e+05,  1.724000e+05,  4.007000e+05, -2.331000e+05,
        -4.413000e+05, -3.890000e+04, -3.870000e+04, -3.930000e+04,
        -4.010000e+04, -4.220000e+04, -3.840000e+04,  4.847000e+05,
        -3.336000e+05, -2.886000e+05,  1.706000e+05, -3.770000e+04,
        -2.280000e+04,  1.133000e+05, -1.517000e+05, -1.326000e+05,
        -1.326000e+05, -1.140000e+05, -9.560000e+04, -1.035000e+05,
        -7.780000e+04, -3.810000e+04, -2.442000e+05, -1.509000e+05,
        -9.450000e+04,  1.395000e+05, -9.810000e+04, -1.521000e+05,
         3.008000e+05,  3.011000e+05, -1.041000e+05, -8.580000e+04,
         1.314400e+06,  2.323000e+05,  4.563000e+05,  1.679800e+06,
        -5.440000e+04, -4.190000e+04, -3.700000e+03, -1.060000e+04,
        -2.470000e+04,  3.915000e+05,  3.915000e+05,  3.915000e+05,
         3.915000e+05, -1.430000e+04, -1.430000e+04,  1.625000e+05,
         1.668000e+05, -4.090000e+04,  2.397600e+06,  0.000000e+00,
         2.430200e+06,  2.410100e+06, -6.730000e+04, -5.180000e+04,
         8.100000e+03,  8.100000e+03, -3.590000e+04, -3.590000e+04,
        -3.590000e+04,  9.077000e+05, -1.118000e+05,  4.401000e+05,
         3.013200e+06,  5.371500e+06,  4.818900e+06,  7.720500e+06,
         4.826600e+06,  1.357700e+06, -6.240000e+04,  1.357800e+06,
        -5.870000e+04,  9.045000e+05,  6.866000e+05,  4.590000e+05,
        -1.246000e+05,  1.565000e+05, -4.980000e+04, -7.980000e+04,
        -1.417000e+05,  8.300000e+04, -1.206000e+05,  2.379800e+06,
        -1.080000e+05,  5.034000e+05, -1.066000e+05, -7.660000e+04,
         2.785000e+05,  3.273100e+06,  5.635000e+05,  9.860000e+05,
         7.550000e+05,  1.217000e+06, -4.440000e+04,  1.930000e+04,
         3.219000e+05, -9.030000e+04, -6.440000e+04,  5.737000e+05,
        -5.100000e+04,  3.498000e+05, -6.550000e+04,  3.024900e+06,
        -3.010000e+04,  5.645000e+05, -4.610000e+04, -1.153000e+05,
        -9.660000e+04,  6.197000e+05,  6.195000e+05, -1.190000e+04,
        -1.293000e+05,  9.011000e+05,  9.765500e+06,  2.411400e+06,
         2.415500e+06, -1.116000e+05, -1.117000e+05, -7.940000e+04,
        -1.114000e+05, -1.758000e+05, -1.117000e+05, -8.900000e+03,
        -8.900000e+03, -8.900000e+03, -8.900000e+03,  1.530000e+04,
         2.286000e+06,  2.284400e+06,  2.284700e+06,  1.248000e+05,
         3.559000e+05,  0.000000e+00,  1.381800e+06,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.371380e+07, -7.700000e+04, -9.420000e+04,
        -2.652000e+05, -9.640000e+04, -9.550000e+04, -1.217000e+05,
        -1.215000e+05,  2.420700e+06, -2.000000e+04, -1.580000e+04,
         1.547000e+05, -2.300000e+04,  8.000000e+02, -5.100000e+03,
        -2.970000e+04,  2.018000e+05,  2.500000e+03, -3.600000e+03,
         0.000000e+00,  0.000000e+00, -4.200000e+03,  1.784000e+05,
        -1.530000e+04,  1.100000e+03,  1.200000e+03,  1.200000e+03,
         0.000000e+00,  0.000000e+00,  1.791000e+05, -2.970000e+04,
         3.000000e+03,  6.890000e+04,  3.330000e+05, -1.420000e+04,
         2.040000e+05,  1.600000e+05, -1.440000e+04,  1.400000e+03,
        -2.700000e+04, -2.700000e+04,  1.973000e+05, -9.000000e+02,
         2.600000e+03,  1.700000e+05, -2.800000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  3.000000e+02, -7.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.000000e+02,  1.547000e+05,
        -2.000000e+04, -3.900000e+03, -3.600000e+03,  2.500000e+03,
        -8.900000e+03,  3.000000e+02,  4.155000e+05, -5.300000e+03,
        -3.590000e+04,  3.915000e+05,  1.668000e+05, -3.990000e+04,
        -7.940000e+04, -1.117000e+05,  2.415500e+06,  2.284800e+06,
        -9.420000e+04, -1.580000e+04,  1.200000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -8.900000e+03,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 4.729000e+05,  1.463000e+05,  1.571000e+05, -3.750000e+04,
         2.168000e+05,  1.996100e+06,  1.050400e+06,  4.603000e+05,
         1.462000e+05,  4.577000e+05,  1.459000e+05,  3.349000e+05,
         1.811000e+05, -2.830000e+05,  0.000000e+00,  3.349000e+05,
         8.060000e+04,  3.331000e+05,  2.070000e+04,  1.345100e+06,
         0.000000e+00,  7.454000e+05,  2.339000e+05,  2.737000e+05,
        -4.270000e+04,  1.930000e+05,  4.650000e+05,  1.030800e+06,
         2.338000e+05,  1.009400e+06,  1.635000e+06,  6.664000e+05,
         5.160000e+04, -8.860000e+04, -8.830000e+04, -8.870000e+04,
        -8.640000e+04, -2.556000e+05, -8.820000e+04, -4.983000e+05,
        -1.176500e+06, -1.127200e+06,  5.370000e+04, -1.120000e+05,
        -1.035000e+05,  1.784000e+05, -1.911000e+05, -6.780000e+04,
        -6.780000e+04,  5.070000e+04,  1.688000e+05,  6.280000e+04,
        -6.900000e+03,  1.474000e+05, -2.050000e+04,  5.722000e+05,
        -3.177000e+05,  2.959000e+05,  4.120000e+04, -1.891000e+05,
         6.994000e+05,  6.996000e+05,  3.606000e+05,  3.850000e+05,
         1.260800e+06,  5.806000e+05,  5.493000e+05,  1.754300e+06,
         6.850000e+04,  2.787000e+05,  1.502000e+05, -5.560000e+04,
         1.829000e+05,  6.855000e+05,  6.855000e+05,  6.855000e+05,
         6.855000e+05,  3.407000e+05,  3.407000e+05,  5.990000e+04,
         4.147000e+05,  2.480000e+05, -2.210000e+04,  0.000000e+00,
         9.750000e+04,  1.193000e+05, -2.028000e+05,  1.926000e+05,
         1.552000e+05,  1.552000e+05,  7.880000e+04,  7.880000e+04,
         7.880000e+04,  2.055600e+06,  1.201400e+06,  8.164000e+05,
         7.933000e+05,  1.180800e+06,  6.625000e+05,  5.738000e+05,
         9.050000e+05,  2.594800e+06,  1.387800e+06,  2.594800e+06,
         1.386800e+06,  1.338500e+06, -1.741000e+05, -8.010000e+05,
        -8.612000e+05,  2.548000e+05,  8.720000e+04,  1.917400e+06,
        -3.626000e+05,  2.629000e+05,  9.240000e+04, -1.100000e+05,
        -2.900000e+05,  3.609000e+05, -1.514000e+05, -1.109000e+05,
        -2.644000e+05,  5.635000e+05,  1.543300e+06,  1.014900e+06,
         3.931000e+05,  1.636600e+06,  1.757000e+05,  2.287000e+05,
         3.152000e+05, -2.050000e+04,  4.890000e+05,  1.225000e+06,
         7.280000e+05,  5.988000e+05,  4.947000e+05,  6.204000e+05,
         7.054000e+05,  1.166100e+06,  1.000000e+05,  7.250000e+04,
         1.911000e+05,  8.079000e+05,  8.079000e+05,  3.169000e+05,
         8.966000e+05,  1.735700e+06,  1.344120e+07,  1.726000e+05,
         1.729000e+05, -8.000000e+04, -8.010000e+04, -6.800000e+03,
        -7.990000e+04, -2.662000e+05, -8.010000e+04,  1.944000e+05,
         1.944000e+05,  1.944000e+05,  1.944000e+05,  2.082000e+05,
        -2.231000e+05, -2.229000e+05, -2.229000e+05, -1.808000e+05,
         4.382000e+05,  0.000000e+00, -1.336000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.338200e+06, -4.894000e+05, -2.850000e+05,
        -1.355000e+05,  3.820000e+05,  3.822000e+05,  9.656000e+05,
         9.657000e+05, -2.130000e+04, -1.053000e+05, -1.150000e+04,
         1.020000e+05, -4.010000e+04, -1.720000e+04, -1.740000e+04,
        -2.830000e+05,  3.357000e+05, -4.310000e+04, -2.400000e+03,
         0.000000e+00,  1.000000e+02, -1.610000e+04,  1.168000e+05,
        -3.320000e+04, -4.520000e+04, -4.510000e+04, -4.510000e+04,
         0.000000e+00,  0.000000e+00, -1.451000e+05, -3.052000e+05,
        -6.570000e+04,  3.150000e+04,  2.188000e+05, -3.070000e+04,
         1.377000e+05,  1.045000e+05, -1.437000e+05, -2.150000e+04,
        -1.149000e+05, -1.149000e+05,  1.315000e+05, -2.200000e+04,
        -1.050000e+04,  1.330000e+04, -1.375000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02,  7.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.020000e+05,
        -1.053000e+05, -3.710000e+04, -2.400000e+03, -4.310000e+04,
         1.944000e+05,  1.000000e+02,  4.729000e+05,  1.463000e+05,
         7.880000e+04,  6.855000e+05,  4.147000e+05, -8.660000e+04,
        -6.800000e+03, -8.010000e+04,  1.729000e+05, -2.230000e+05,
        -2.850000e+05, -1.150000e+04, -4.510000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.944000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 6.695000e+05, -7.400000e+03,  5.290000e+04, -1.515000e+05,
         2.576000e+05,  2.931000e+06,  1.592300e+06,  6.354000e+05,
        -7.400000e+03,  6.286000e+05, -7.500000e+03,  3.323000e+05,
         1.990000e+04,  3.486000e+05,  0.000000e+00,  3.323000e+05,
        -7.280000e+04,  3.295000e+05,  1.800000e+03,  1.330500e+06,
         0.000000e+00,  1.361900e+06,  3.344000e+05,  4.364000e+05,
         1.197000e+05, -2.310000e+05, -1.930000e+04,  1.006200e+06,
        -2.314000e+05,  1.185000e+06,  1.169200e+06,  4.994000e+05,
         1.153900e+06,  3.463000e+05,  3.466000e+05,  3.472000e+05,
         3.485000e+05,  4.355000e+05,  3.481000e+05,  4.494300e+06,
         3.113700e+06,  3.260300e+06,  7.063000e+05,  3.458000e+05,
         3.978000e+05,  1.051000e+05, -3.815000e+05,  3.688000e+05,
         3.688000e+05,  1.923000e+05,  1.660000e+04,  2.260000e+05,
         2.733000e+05,  9.234000e+05,  5.710000e+05, -3.114000e+05,
         1.967000e+05,  1.822000e+05, -2.269000e+05, -3.815000e+05,
         1.377200e+06,  1.378700e+06,  6.841000e+05,  7.602000e+05,
         2.103100e+06,  4.220000e+05,  7.475000e+05,  2.749100e+06,
        -9.970000e+04, -6.980000e+04,  3.800000e+03, -1.860000e+04,
        -2.540000e+04,  6.732000e+05,  6.732000e+05,  6.731000e+05,
         6.732000e+05, -8.900000e+03, -8.900000e+03,  6.899000e+05,
         2.610000e+05, -7.850000e+04, -1.360000e+04,  0.000000e+00,
        -1.897000e+05, -1.910000e+05,  2.722000e+05,  1.330000e+05,
         2.190000e+04,  2.190000e+04, -7.520000e+04, -7.520000e+04,
        -7.520000e+04,  1.532200e+06, -1.705000e+05,  1.560000e+06,
         1.519300e+06,  9.832000e+05, -3.870000e+04,  9.714000e+05,
        -3.937000e+05,  2.356200e+06, -3.110000e+04,  2.356200e+06,
        -3.130000e+04,  2.394100e+06,  2.751200e+06,  2.766900e+06,
         1.382200e+06,  6.881000e+05,  3.348000e+05, -6.470000e+04,
         1.655000e+05,  1.549000e+05, -1.871000e+05,  3.353000e+05,
         6.200000e+05,  8.307000e+05, -1.918000e+05, -9.480000e+04,
         8.415000e+05,  9.860000e+05,  1.014900e+06,  2.129300e+06,
         2.121500e+06,  2.137200e+06,  3.673000e+05,  5.868000e+05,
         1.377600e+06,  6.728000e+05,  3.394000e+05,  1.010200e+06,
        -7.110000e+04,  1.021600e+06,  3.439000e+05,  1.002100e+06,
        -1.350000e+04,  9.386000e+05,  3.419000e+05,  1.957000e+05,
         1.920000e+04,  1.014200e+06,  1.014000e+06, -9.000000e+03,
         1.532000e+05,  1.915200e+06,  1.613880e+07, -1.410000e+04,
        -1.410000e+04, -1.842000e+05, -1.843000e+05,  2.701000e+05,
        -1.829000e+05, -7.139000e+05, -1.843000e+05, -1.500000e+03,
        -1.500000e+03, -1.500000e+03, -1.300000e+03,  2.980000e+04,
        -2.030000e+04, -2.030000e+04, -2.030000e+04,  5.937000e+05,
         5.781000e+05,  0.000000e+00, -2.510000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.218000e+05, -1.873000e+05, -1.858000e+05,
         7.332000e+05,  2.701000e+05,  2.731000e+05,  2.715000e+05,
         2.730000e+05, -1.120000e+04, -6.360000e+04, -2.390000e+04,
         2.449000e+05, -4.010000e+04, -2.400000e+03, -9.100000e+03,
         3.486000e+05,  3.328000e+05, -5.800000e+03, -5.900000e+03,
         0.000000e+00,  1.000000e+02,  5.600000e+03,  2.830000e+05,
        -2.710000e+04, -1.100000e+03, -1.000000e+03, -1.000000e+03,
         0.000000e+00,  0.000000e+00,  6.864000e+05,  3.455000e+05,
        -9.100000e+03,  1.064000e+05,  5.278000e+05, -2.500000e+04,
         3.316000e+05,  2.532000e+05,  1.731000e+05, -2.200000e+03,
        -7.710000e+04, -7.710000e+04,  3.121000e+05, -5.300000e+03,
         3.300000e+03,  2.313000e+05, -8.300000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.500000e+03, -7.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.449000e+05,
        -6.360000e+04,  4.570000e+04, -5.900000e+03, -5.800000e+03,
        -1.500000e+03,  1.500000e+03,  6.695000e+05, -7.400000e+03,
        -7.520000e+04,  6.732000e+05,  2.610000e+05,  3.484000e+05,
         2.701000e+05, -1.843000e+05, -1.410000e+04, -2.030000e+04,
        -1.858000e+05, -2.390000e+04, -1.000000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.500000e+03,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 4.649000e+05, -1.098000e+05, -4.140000e+04, -2.034000e+05,
         1.297000e+05,  2.083300e+06,  1.153600e+06,  4.350000e+05,
        -1.098000e+05,  4.289000e+05, -1.096000e+05,  1.673000e+05,
        -9.700000e+04,  9.329000e+05,  0.000000e+00,  1.673000e+05,
        -1.625000e+05,  1.647000e+05, -1.170000e+04,  6.704000e+05,
         0.000000e+00,  1.452200e+06,  5.707000e+05,  6.897000e+05,
         4.296000e+05, -4.754000e+05, -3.384000e+05,  5.135000e+05,
        -4.975000e+05,  1.409200e+06,  6.427000e+05,  8.250000e+05,
         2.685700e+06,  8.034000e+05,  8.038000e+05,  8.046000e+05,
         8.038000e+05,  1.101400e+06,  8.053000e+05,  8.644800e+06,
         7.461700e+06,  7.628100e+06,  1.120800e+06,  8.134000e+05,
         8.666000e+05, -7.450000e+04, -4.491000e+05,  9.337000e+05,
         9.337000e+05,  4.780000e+05,  2.450000e+04,  5.171000e+05,
         6.385000e+05,  1.720400e+06,  1.419100e+06, -8.596000e+05,
         7.242000e+05, -3.450000e+04, -3.678000e+05, -4.500000e+05,
         1.832300e+06,  1.833800e+06,  1.240700e+06,  1.323900e+06,
         1.604800e+06,  1.212000e+05,  5.089000e+05,  2.049700e+06,
        -1.853000e+05, -2.871000e+05, -9.340000e+04,  1.650000e+04,
        -1.466000e+05,  3.426000e+05,  3.426000e+05,  3.426000e+05,
         3.426000e+05, -2.379000e+05, -2.380000e+05,  1.111600e+06,
         6.700000e+03, -2.819000e+05, -1.600000e+03,  0.000000e+00,
        -4.568000e+05, -4.714000e+05,  7.647000e+05,  1.871000e+05,
        -7.590000e+04, -7.590000e+04, -1.641000e+05, -1.641000e+05,
        -1.641000e+05,  4.014000e+05, -1.047500e+06,  1.932100e+06,
         1.520400e+06,  3.858000e+05, -4.821000e+05,  7.622000e+05,
        -1.401200e+06,  1.073600e+06, -9.585000e+05,  1.073600e+06,
        -9.596000e+05,  2.606600e+06,  4.692800e+06,  5.460600e+06,
         3.526800e+06,  9.800000e+05,  6.781000e+05, -1.373500e+06,
         7.703000e+05,  1.100000e+04, -2.821000e+05,  8.057000e+05,
         1.569000e+06,  7.362000e+05, -1.348000e+05, -2.640000e+04,
         1.495600e+06,  7.550000e+05,  3.931000e+05,  2.121500e+06,
         3.469200e+06,  7.737000e+05,  6.149000e+05,  8.506000e+05,
         2.088300e+06,  1.485600e+06,  4.151000e+05,  3.887000e+05,
        -5.334000e+05,  1.148900e+06,  4.211000e+05,  7.742000e+05,
        -4.837000e+05,  3.246000e+05,  6.692000e+05,  4.696000e+05,
         1.390000e+04,  6.477000e+05,  6.476000e+05, -2.257000e+05,
        -1.640000e+05,  1.342500e+06,  9.973100e+06, -1.273000e+05,
        -1.274000e+05, -1.632000e+05, -1.633000e+05,  6.345000e+05,
        -1.618000e+05, -1.002400e+06, -1.633000e+05, -1.282000e+05,
        -1.282000e+05, -1.282000e+05, -1.280000e+05, -1.001000e+05,
         1.086000e+05,  1.085000e+05,  1.085000e+05,  1.149200e+06,
         3.844000e+05,  0.000000e+00,  5.710000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  6.513000e+05,  8.640000e+04, -3.850000e+04,
         1.862700e+06,  3.814000e+05,  3.848000e+05,  3.100000e+03,
         4.700000e+03,  2.300000e+03, -3.000000e+04, -1.830000e+04,
         2.162000e+05, -2.380000e+04,  6.400000e+03,  7.000000e+02,
         9.329000e+05,  1.679000e+05,  1.650000e+04, -5.300000e+03,
         0.000000e+00,  1.000000e+02,  2.330000e+04,  2.525000e+05,
        -1.090000e+04,  2.810000e+04,  2.830000e+04,  2.830000e+04,
         0.000000e+00,  0.000000e+00,  1.237700e+06,  9.406000e+05,
         2.440000e+04,  1.007000e+05,  4.685000e+05, -1.010000e+04,
         2.980000e+05,  2.236000e+05,  4.645000e+05,  9.000000e+03,
        -4.090000e+04, -4.100000e+04,  2.750000e+05,  5.600000e+03,
         1.080000e+04,  2.307000e+05, -3.590000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.500000e+03, -1.100000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.162000e+05,
        -3.000000e+04,  1.224000e+05, -5.300000e+03,  1.650000e+04,
        -1.282000e+05,  1.500000e+03,  4.649000e+05, -1.098000e+05,
        -1.641000e+05,  3.426000e+05,  6.700000e+03,  8.039000e+05,
         6.345000e+05, -1.633000e+05, -1.274000e+05,  1.085000e+05,
        -3.850000e+04, -1.830000e+04,  2.830000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.282000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 8.740000e+05,  9.490000e+04,  1.473000e+05, -9.960000e+04,
         3.854000e+05,  3.778600e+06,  2.030900e+06,  8.359000e+05,
         9.490000e+04,  8.283000e+05,  9.450000e+04,  4.973000e+05,
         1.367000e+05, -2.356000e+05,  0.000000e+00,  4.973000e+05,
         1.690000e+04,  4.943000e+05,  1.520000e+04,  1.990600e+06,
         0.000000e+00,  1.271600e+06,  9.810000e+04,  1.831000e+05,
        -1.902000e+05,  1.330000e+04,  2.999000e+05,  1.498800e+06,
         3.470000e+04,  9.608000e+05,  1.695800e+06,  1.737000e+05,
        -3.779000e+05, -1.108000e+05, -1.105000e+05, -1.101000e+05,
        -1.068000e+05, -2.304000e+05, -1.092000e+05,  3.438000e+05,
        -1.234300e+06, -1.107500e+06,  2.917000e+05, -1.218000e+05,
        -7.110000e+04,  2.847000e+05, -3.139000e+05, -1.961000e+05,
        -1.961000e+05, -9.340000e+04,  8.700000e+03, -6.510000e+04,
        -9.180000e+04,  1.264000e+05, -2.771000e+05,  2.367000e+05,
        -3.309000e+05,  3.989000e+05, -8.600000e+04, -3.130000e+05,
         9.222000e+05,  9.236000e+05,  1.276000e+05,  1.965000e+05,
         2.601500e+06,  7.229000e+05,  9.860000e+05,  3.448400e+06,
        -1.410000e+04,  1.475000e+05,  1.010000e+05, -5.370000e+04,
         9.580000e+04,  1.003700e+06,  1.003700e+06,  1.003600e+06,
         1.003700e+06,  2.201000e+05,  2.201000e+05,  2.682000e+05,
         5.153000e+05,  1.248000e+05, -2.550000e+04,  0.000000e+00,
         7.740000e+04,  8.950000e+04, -2.204000e+05,  7.880000e+04,
         1.197000e+05,  1.197000e+05,  1.370000e+04,  1.370000e+04,
         1.380000e+04,  2.663100e+06,  7.064000e+05,  1.187800e+06,
         1.518300e+06,  1.580500e+06,  4.047000e+05,  1.180600e+06,
         6.138000e+05,  3.638800e+06,  8.962000e+05,  3.638800e+06,
         8.969000e+05,  2.181600e+06,  8.096000e+05,  7.320000e+04,
        -7.623000e+05,  3.961000e+05, -8.400000e+03,  1.244100e+06,
        -4.392000e+05,  2.987000e+05, -9.210000e+04, -1.351000e+05,
        -3.290000e+05,  9.253000e+05, -2.488000e+05, -1.632000e+05,
         1.875000e+05,  1.217000e+06,  1.636600e+06,  2.137200e+06,
         7.737000e+05,  4.599600e+06,  1.198000e+05,  3.231000e+05,
         6.670000e+05, -1.399000e+05,  2.636000e+05,  1.631700e+06,
         3.912000e+05,  8.942000e+05,  2.668000e+05,  1.230000e+06,
         4.567000e+05,  1.552700e+06,  1.450000e+04, -7.830000e+04,
         2.450000e+04,  1.380600e+06,  1.380500e+06,  2.077000e+05,
         4.703000e+05,  2.487800e+06,  2.230460e+07,  9.910000e+04,
         9.920000e+04, -2.052000e+05, -2.053000e+05, -9.430000e+04,
        -2.039000e+05, -4.254000e+05, -2.053000e+05,  1.252000e+05,
         1.252000e+05,  1.252000e+05,  1.253000e+05,  1.596000e+05,
        -1.492000e+05, -1.491000e+05, -1.491000e+05,  3.820000e+04,
         7.718000e+05,  0.000000e+00, -1.074000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -8.949000e+05, -4.609000e+05, -3.331000e+05,
        -3.963000e+05,  1.588000e+05,  1.615000e+05,  5.399000e+05,
         5.413000e+05, -2.460000e+04, -9.720000e+04, -2.940000e+04,
         2.737000e+05, -5.650000e+04, -1.110000e+04, -1.890000e+04,
        -2.356000e+05,  4.978000e+05, -2.820000e+04, -6.500000e+03,
         0.000000e+00,  1.000000e+02, -1.210000e+04,  3.136000e+05,
        -4.320000e+04, -3.040000e+04, -3.020000e+04, -3.020000e+04,
         0.000000e+00,  0.000000e+00,  1.351000e+05, -2.496000e+05,
        -4.260000e+04,  1.120000e+05,  5.871000e+05, -4.000000e+04,
         3.652000e+05,  2.828000e+05, -1.184000e+05, -1.340000e+04,
        -1.132000e+05, -1.133000e+05,  3.492000e+05, -1.610000e+04,
        -4.100000e+03,  2.319000e+05, -1.300000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.400000e+03, -4.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.737000e+05,
        -9.720000e+04, -3.090000e+04, -6.500000e+03, -2.820000e+04,
         1.252000e+05,  1.400000e+03,  8.740000e+05,  9.490000e+04,
         1.370000e+04,  1.003700e+06,  5.153000e+05, -1.071000e+05,
        -9.430000e+04, -2.053000e+05,  9.920000e+04, -1.491000e+05,
        -3.331000e+05, -2.940000e+04, -3.020000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.252000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-1.500000e+03,  8.715000e+05,  4.860000e+04, -6.930000e+04,
        -3.520000e+04, -3.270000e+04, -2.960000e+04,  2.200000e+03,
         8.715000e+05,  3.000000e+03,  8.714000e+05,  3.680000e+04,
         4.703000e+05,  2.925000e+05,  0.000000e+00,  3.680000e+04,
         3.100000e+03,  3.740000e+04,  5.440000e+04,  1.456000e+05,
         0.000000e+00,  3.903000e+05,  1.921000e+06,  4.759000e+05,
         3.069000e+05,  7.184000e+05,  2.138500e+06,  1.028000e+05,
         2.500000e+03,  1.068700e+06,  8.146000e+05,  1.982500e+06,
         1.540000e+06,  3.694000e+05,  3.689000e+05,  3.719000e+05,
         3.700000e+05,  4.043000e+05,  3.705000e+05,  3.035800e+06,
         5.192700e+06,  3.149900e+06,  2.738000e+05,  1.008900e+06,
         3.023000e+05, -1.053000e+05, -2.084000e+05,  5.512000e+05,
         5.515000e+05,  7.368000e+05,  9.353000e+05,  3.640000e+05,
         3.903000e+05,  9.071000e+05,  2.594100e+06,  3.520100e+06,
         2.152000e+05, -3.350000e+04, -6.890000e+04, -2.067000e+05,
         8.942000e+05,  8.958000e+05,  1.880200e+06,  9.513000e+05,
        -8.320000e+04,  9.900000e+04,  5.700000e+03, -8.920000e+04,
        -5.650000e+04,  7.910000e+04,  5.820000e+04, -9.710000e+04,
        -4.000000e+02,  6.900000e+04,  6.900000e+04,  6.900000e+04,
         6.900000e+04,  9.490000e+05,  9.490000e+05,  3.265000e+05,
         3.840000e+04,  4.762000e+05, -1.300000e+04,  0.000000e+00,
         1.759000e+05, -1.595000e+05,  2.973000e+05,  2.944000e+05,
         5.590000e+04,  5.590000e+04,  5.000000e+02,  6.000000e+02,
         6.000000e+02,  2.596000e+05,  2.454900e+06,  7.850000e+05,
         3.071000e+05,  1.571000e+05,  1.471900e+06, -8.190000e+04,
         1.965800e+06,  3.218000e+05,  3.401500e+06,  3.218000e+05,
         3.400500e+06,  8.468000e+05,  1.167500e+06,  1.425900e+06,
         2.973200e+06,  4.078000e+05,  1.993100e+06,  7.876100e+06,
         3.176000e+05,  5.950000e+04,  5.694000e+05,  3.562000e+05,
         6.818000e+05, -1.037000e+05,  1.243700e+06, -1.820000e+04,
         1.544000e+05, -4.440000e+04,  1.757000e+05,  3.673000e+05,
         6.149000e+05,  1.198000e+05,  8.802200e+06,  5.100000e+05,
         7.382000e+05,  4.112200e+06,  6.095000e+05,  1.833000e+05,
         2.388600e+06,  4.400000e+05,  6.046000e+05, -6.440000e+04,
         1.502500e+06,  1.244000e+05,  4.538000e+05,  3.910000e+05,
         5.762000e+05,  3.460000e+04,  3.460000e+04,  1.349200e+06,
         2.897300e+06, -5.537600e+06,  7.361000e+05,  6.210000e+04,
         6.220000e+04,  2.300000e+04,  2.300000e+04,  3.944000e+05,
         2.460000e+04, -4.002000e+05,  2.300000e+04,  7.750000e+04,
         7.750000e+04,  7.750000e+04,  7.740000e+04,  7.200000e+04,
        -7.580000e+04, -7.580000e+04, -7.580000e+04,  2.648000e+05,
         8.600000e+03,  0.000000e+00, -4.930000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -4.549000e+05, -1.242000e+05, -5.050000e+04,
         1.113800e+06,  5.502000e+05,  5.507000e+05,  7.863000e+05,
         7.879000e+05, -1.360000e+04, -6.720000e+04, -7.780000e+04,
        -2.750000e+04,  4.024000e+05,  2.910000e+05, -3.800000e+03,
         2.925000e+05,  3.630000e+04,  6.788000e+05,  7.000000e+02,
         0.000000e+00, -4.300000e+03, -8.270000e+04, -1.116000e+05,
         3.797000e+05, -1.750000e+04, -1.750000e+04, -1.750000e+04,
         0.000000e+00,  0.000000e+00,  2.547000e+05,  7.578000e+05,
         1.113000e+06,  2.185000e+05, -1.391000e+05,  3.511000e+05,
        -3.820000e+04, -2.650000e+04,  1.510000e+05,  3.395000e+05,
        -6.870000e+04, -6.870000e+04, -3.450000e+04,  4.249000e+05,
        -4.600000e+03, -1.022000e+05,  3.562000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.600000e+03,  7.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.750000e+04,
        -6.720000e+04,  3.840000e+04,  7.000000e+02,  6.788000e+05,
         7.750000e+04,  1.600000e+03, -1.500000e+03,  8.715000e+05,
         6.000000e+02,  6.900000e+04,  3.840000e+04,  3.700000e+05,
         3.944000e+05,  2.300000e+04,  6.220000e+04, -7.580000e+04,
        -5.050000e+04, -7.780000e+04, -1.750000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         7.750000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 4.330000e+04,  4.220000e+04,  2.441500e+06, -5.100000e+04,
        -4.200000e+03,  1.375000e+05,  5.100000e+04,  3.140000e+04,
         4.220000e+04,  2.900000e+04,  4.210000e+04,  5.020000e+04,
         5.870000e+04,  3.347000e+05,  0.000000e+00,  5.020000e+04,
         3.900000e+03,  4.880000e+04,  6.600000e+03,  2.029000e+05,
         0.000000e+00,  5.027000e+05,  4.854000e+05,  1.471500e+07,
         3.370000e+05, -4.800000e+03,  1.353000e+05,  1.673000e+05,
         7.500000e+03,  1.070400e+06,  7.841000e+05,  1.056900e+06,
         1.799900e+06,  3.903000e+05,  3.907000e+05,  3.920000e+05,
         3.923000e+05,  4.469000e+05,  3.923000e+05,  3.443700e+06,
         3.412100e+06,  3.506050e+07,  4.097000e+05,  3.866000e+05,
         8.313900e+06, -5.570000e+04, -1.656000e+05,  5.607000e+05,
         5.607000e+05,  3.879000e+05,  2.163000e+05,  5.130500e+06,
         3.952000e+05,  9.735000e+05,  9.581000e+05,  9.370000e+04,
         2.793000e+05, -1.300000e+03, -4.860000e+04, -1.747000e+05,
         9.630000e+05,  9.646000e+05,  9.409000e+05,  1.677140e+07,
        -1.880000e+04,  1.468000e+05,  3.510000e+04, -1.042000e+05,
        -1.013000e+05,  6.210000e+04,  4.450000e+04, -1.159000e+05,
        -4.750000e+04,  1.082000e+05,  1.082000e+05,  1.082000e+05,
         1.082000e+05,  9.870000e+04,  9.870000e+04,  3.965000e+05,
         5.360000e+04,  5.150000e+04, -7.100000e+03,  0.000000e+00,
        -1.797000e+05, -1.747000e+05,  3.353000e+05,  2.522000e+05,
         1.127200e+06,  1.127300e+06,  2.500000e+03,  2.500000e+03,
         2.500000e+03,  3.296000e+05,  3.090000e+05,  9.016000e+05,
         4.165000e+05,  2.090000e+05,  1.934000e+05,  3.030000e+04,
        -1.511000e+05,  4.388000e+05,  4.056000e+05,  4.388000e+05,
         4.034000e+05,  1.018100e+06,  1.459400e+06,  1.746200e+06,
         1.435000e+06,  4.506000e+05,  4.344000e+05,  5.646000e+05,
         3.370000e+05,  5.830000e+04,  5.310000e+04,  3.858000e+05,
         7.277000e+05, -3.300000e+03, -1.850000e+04,  2.370930e+07,
         2.755000e+05,  1.930000e+04,  2.287000e+05,  5.868000e+05,
         8.506000e+05,  3.231000e+05,  5.100000e+05,  6.405400e+07,
         8.448000e+05,  8.141000e+05,  5.547000e+05,  2.231000e+05,
         1.536000e+05,  5.023000e+05,  5.623000e+05,  4.760000e+04,
         2.060000e+05,  1.863000e+05,  4.410000e+05,  3.942000e+05,
         2.213000e+05,  1.052000e+05,  1.051000e+05,  9.480000e+04,
         5.950000e+05,  6.718000e+05,  1.724500e+06,  5.000000e+04,
         5.010000e+04,  7.000000e+02,  7.000000e+02,  3.917000e+05,
         2.300000e+03, -4.457000e+05,  7.000000e+02,  5.640000e+04,
         5.640000e+04,  5.640000e+04,  5.650000e+04,  6.830000e+04,
        -7.060000e+04, -7.050000e+04, -7.050000e+04,  2.950000e+05,
         1.130000e+04,  0.000000e+00, -4.380000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -4.233000e+05, -1.215000e+05, -6.050000e+04,
         1.112200e+06,  5.078000e+05,  5.111000e+05,  6.836000e+05,
         6.852000e+05, -4.700000e+03, -4.720000e+04, -1.039000e+05,
        -3.980000e+04, -2.110000e+04, -4.900000e+03,  5.059000e+05,
         3.347000e+05,  5.080000e+04, -1.230000e+04,  0.000000e+00,
         0.000000e+00,  1.000000e+02,  3.752400e+06, -1.161000e+05,
        -1.113000e+05, -1.340000e+04, -1.330000e+04, -1.330000e+04,
         0.000000e+00,  0.000000e+00,  3.346000e+05,  3.289000e+05,
        -1.860000e+04, -5.800000e+03, -1.559000e+05, -1.029000e+05,
        -6.000000e+02, -3.560000e+04,  1.651000e+05, -5.300000e+03,
        -6.290000e+04, -6.290000e+04, -2.270000e+04, -1.610000e+04,
         5.325000e+05, -8.680000e+04, -7.920000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.600000e+03, -9.700000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -3.980000e+04,
        -4.720000e+04,  4.390000e+04,  0.000000e+00, -1.230000e+04,
         5.640000e+04,  1.600000e+03,  4.330000e+04,  4.220000e+04,
         2.500000e+03,  1.082000e+05,  5.360000e+04,  3.922000e+05,
         3.917000e+05,  7.000000e+02,  5.010000e+04, -7.050000e+04,
        -6.050000e+04, -1.039000e+05, -1.330000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         5.640000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 2.208000e+05, -2.450000e+04,  8.400000e+03, -1.560000e+05,
         3.200000e+04,  9.720000e+05,  5.305000e+05,  2.091000e+05,
        -2.450000e+04,  2.067000e+05, -2.460000e+04,  1.035000e+05,
        -1.020000e+04,  8.189000e+05,  0.000000e+00,  1.035000e+05,
        -8.420000e+04,  1.024000e+05, -1.400000e+03,  4.160000e+05,
         0.000000e+00,  1.137600e+06,  7.545000e+05,  8.179000e+05,
         5.473000e+05, -2.655000e+05, -6.860000e+04,  3.193000e+05,
        -2.587000e+05,  1.705400e+06,  9.952000e+05,  1.452400e+06,
         3.058500e+06,  8.044000e+05,  8.069000e+05,  8.033000e+05,
         8.054000e+05,  1.016800e+06,  8.084000e+05,  7.756200e+06,
         7.253000e+06,  7.330000e+06,  9.256000e+05,  7.975000e+05,
         8.190000e+05, -1.247000e+05, -3.835000e+05,  1.029700e+06,
         1.029700e+06,  6.197000e+05,  2.120000e+05,  6.383000e+05,
         7.157000e+05,  1.776000e+06,  1.648100e+06, -4.017000e+05,
         6.523000e+05, -5.310000e+04, -2.417000e+05, -3.830000e+05,
         1.800700e+06,  1.802300e+06,  1.548900e+06,  1.587600e+06,
         7.098000e+05,  1.274000e+05,  2.479000e+05,  9.288000e+05,
        -9.660000e+04, -9.730000e+04, -1.000000e+04,  1.000000e+03,
        -1.970000e+04,  2.138000e+05,  2.138000e+05,  2.138000e+05,
         2.138000e+05, -3.980000e+04, -3.980000e+04,  9.232000e+05,
         1.920000e+04, -1.051000e+05, -8.100000e+03,  0.000000e+00,
        -4.191000e+05, -4.177000e+05,  7.280000e+05,  3.382000e+05,
        -3.400000e+03, -3.400000e+03, -8.560000e+04, -8.560000e+04,
        -8.560000e+04,  3.491000e+05, -2.838000e+05,  1.769500e+06,
         1.067600e+06,  2.970000e+05, -8.550000e+04,  3.286000e+05,
        -9.172000e+05,  7.399000e+05, -1.477000e+05,  7.399000e+05,
        -1.532000e+05,  2.152100e+06,  3.711000e+06,  4.420000e+06,
         3.204500e+06,  1.101200e+06,  9.733000e+05, -2.593000e+05,
         7.543000e+05,  3.900000e+04, -9.000000e+04,  8.001000e+05,
         1.534800e+06,  2.995000e+05, -7.940000e+04, -2.020000e+04,
         1.014600e+06,  3.219000e+05,  3.152000e+05,  1.377600e+06,
         2.088300e+06,  6.670000e+05,  7.382000e+05,  8.448000e+05,
         2.457900e+06,  2.202100e+06,  7.498000e+05,  3.131000e+05,
        -7.100000e+04,  1.026400e+06,  7.604000e+05,  3.531000e+05,
        -7.360000e+04,  2.771000e+05,  7.775000e+05,  6.228000e+05,
         2.128000e+05,  3.323000e+05,  3.323000e+05, -4.140000e+04,
         4.640000e+05,  1.103400e+06,  5.271000e+06, -2.130000e+04,
        -2.130000e+04, -6.640000e+04, -6.640000e+04,  7.108000e+05,
        -6.490000e+04, -9.246000e+05, -6.640000e+04, -1.530000e+04,
        -1.530000e+04, -1.530000e+04, -1.520000e+04, -2.300000e+03,
        -3.900000e+03, -3.900000e+03, -3.900000e+03,  9.042000e+05,
         1.891000e+05,  0.000000e+00, -3.400000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.370000e+04, -4.530000e+04, -5.600000e+04,
         2.062200e+06,  6.838000e+05,  6.875000e+05,  6.445000e+05,
         6.460000e+05, -4.500000e+03, -6.330000e+04, -4.300000e+03,
         8.520000e+04, -1.870000e+04, -3.600000e+03, -2.500000e+03,
         8.189000e+05,  1.037000e+05, -7.500000e+03, -2.000000e+03,
         0.000000e+00,  1.000000e+02,  8.800000e+03,  1.038000e+05,
        -1.030000e+04,  3.000000e+03,  3.100000e+03,  3.100000e+03,
         0.000000e+00,  0.000000e+00,  9.323000e+05,  8.126000e+05,
        -1.390000e+04,  3.510000e+04,  1.889000e+05, -9.500000e+03,
         1.132000e+05,  8.890000e+04,  4.063000e+05, -3.000000e+03,
        -7.040000e+04, -7.040000e+04,  1.104000e+05, -6.500000e+03,
         2.300000e+03,  3.810000e+04, -7.720000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.500000e+03,  1.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  8.520000e+04,
        -6.330000e+04,  1.074000e+05, -2.000000e+03, -7.500000e+03,
        -1.530000e+04,  1.500000e+03,  2.208000e+05, -2.450000e+04,
        -8.560000e+04,  2.138000e+05,  1.920000e+04,  8.052000e+05,
         7.108000e+05, -6.640000e+04, -2.130000e+04, -3.900000e+03,
        -5.600000e+04, -4.300000e+03,  3.100000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.530000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-4.760000e+04,  3.270000e+05,  6.600000e+03, -1.231000e+05,
        -8.510000e+04, -2.134000e+05, -1.182000e+05, -4.420000e+04,
         3.270000e+05, -4.350000e+04,  3.270000e+05, -1.480000e+04,
         1.699000e+05,  7.965000e+05,  0.000000e+00, -1.480000e+04,
        -5.380000e+04, -1.450000e+04,  1.970000e+04, -5.800000e+04,
         0.000000e+00,  7.489000e+05,  1.389100e+06,  8.337000e+05,
         6.222000e+05,  1.143000e+05,  7.946000e+05, -4.200000e+04,
        -1.652000e+05,  1.658900e+06,  8.534000e+05,  2.045600e+06,
         3.212900e+06,  8.136000e+05,  8.158000e+05,  8.132000e+05,
         8.140000e+05,  1.004400e+06,  8.174000e+05,  7.172800e+06,
         8.084600e+06,  7.285800e+06,  7.526000e+05,  1.062800e+06,
         7.808000e+05, -2.089000e+05, -3.143000e+05,  1.102700e+06,
         1.102800e+06,  8.375000e+05,  5.795000e+05,  6.935000e+05,
         7.624000e+05,  1.769500e+06,  2.457300e+06,  1.130900e+06,
         6.596000e+05, -1.393000e+05, -1.785000e+05, -3.131000e+05,
         1.607500e+06,  1.609100e+06,  2.027400e+06,  1.664000e+06,
        -1.647000e+05, -1.800000e+03, -4.880000e+04, -2.065000e+05,
        -7.930000e+04, -3.770000e+04,  1.180000e+04, -3.040000e+04,
        -9.600000e+03, -2.790000e+04, -2.790000e+04, -2.790000e+04,
        -2.790000e+04,  3.433000e+05,  3.433000e+05,  7.779000e+05,
        -6.990000e+04,  1.168000e+05, -7.900000e+03,  0.000000e+00,
        -2.729000e+05, -4.051000e+05,  7.381000e+05,  4.028000e+05,
         1.030000e+04,  1.030000e+04, -5.530000e+04, -5.530000e+04,
        -5.530000e+04, -1.599000e+05,  7.663000e+05,  1.459500e+06,
         5.827000e+05, -3.340000e+04,  5.188000e+05, -9.270000e+04,
         2.660000e+04, -7.380000e+04,  1.225300e+06, -7.390000e+04,
         1.219500e+06,  1.533200e+06,  3.077500e+06,  3.883600e+06,
         3.840900e+06,  9.892000e+05,  1.636600e+06,  2.917100e+06,
         8.152000e+05,  8.000000e+02,  2.126000e+05,  8.085000e+05,
         1.559500e+06, -7.430000e+04,  4.948000e+05,  1.040000e+04,
         7.397000e+05, -9.030000e+04, -2.050000e+04,  6.728000e+05,
         1.485600e+06, -1.399000e+05,  4.112200e+06,  8.141000e+05,
         2.202100e+06,  3.831100e+06,  8.578000e+05, -1.760000e+04,
         9.129000e+05,  7.937000e+05,  8.647000e+05, -7.350000e+04,
         5.328000e+05, -4.860000e+04,  8.223000e+05,  7.010000e+05,
         4.357000e+05, -5.950000e+04, -5.950000e+04,  5.018000e+05,
         1.561600e+06, -1.877700e+06, -8.901000e+05,  9.200000e+03,
         9.200000e+03,  1.650000e+04,  1.650000e+04,  7.606000e+05,
         1.810000e+04, -7.992000e+05,  1.650000e+04,  1.630000e+04,
         1.630000e+04,  1.630000e+04,  1.630000e+04,  1.460000e+04,
        -2.620000e+04, -2.610000e+04, -2.610000e+04,  7.727000e+05,
        -3.860000e+04,  0.000000e+00, -1.310000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.569000e+05, -2.010000e+04, -1.800000e+03,
         2.214500e+06,  7.958000e+05,  7.985000e+05,  8.505000e+05,
         8.520000e+05, -5.500000e+03, -6.470000e+04, -2.590000e+04,
        -2.380000e+04,  1.583000e+05,  1.137000e+05, -3.000000e+02,
         7.965000e+05, -1.490000e+04,  2.664000e+05,  6.000000e+02,
         0.000000e+00, -1.700000e+03, -2.650000e+04, -5.410000e+04,
         1.524000e+05, -3.500000e+03, -3.600000e+03, -3.600000e+03,
         0.000000e+00,  0.000000e+00,  7.596000e+05,  9.775000e+05,
         4.349000e+05,  8.000000e+04, -7.780000e+04,  1.409000e+05,
        -3.470000e+04, -2.300000e+04,  3.975000e+05,  1.337000e+05,
        -6.710000e+04, -6.710000e+04, -2.820000e+04,  1.656000e+05,
        -9.000000e+02, -9.530000e+04,  9.840000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.600000e+03,  7.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.380000e+04,
        -6.470000e+04,  1.045000e+05,  6.000000e+02,  2.664000e+05,
         1.630000e+04,  1.600000e+03, -4.760000e+04,  3.270000e+05,
        -5.530000e+04, -2.790000e+04, -6.990000e+04,  8.139000e+05,
         7.606000e+05,  1.650000e+04,  9.200000e+03, -2.610000e+04,
        -1.800000e+03, -2.590000e+04, -3.600000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.630000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 2.910000e+04,  1.318000e+05,  1.134000e+05, -3.980000e+04,
        -5.100000e+03,  6.070000e+04,  2.400000e+03,  3.700000e+04,
         1.318000e+05,  3.860000e+04,  1.315000e+05,  1.055000e+05,
         1.505000e+05,  1.805000e+05,  0.000000e+00,  1.055000e+05,
         6.890000e+04,  1.062000e+05,  1.750000e+04,  4.206000e+05,
         0.000000e+00,  4.903000e+05,  6.502000e+05,  6.195000e+05,
         3.718000e+05,  1.559000e+05,  4.225000e+05,  3.106000e+05,
         2.034000e+05,  1.523500e+06,  1.447600e+06,  1.631100e+06,
         1.868800e+06,  3.634000e+05,  3.629000e+05,  3.625000e+05,
         3.623000e+05,  3.165000e+05,  3.631000e+05,  2.677900e+06,
         2.889100e+06,  2.850200e+06,  2.855000e+05,  3.401000e+05,
         3.285000e+05, -4.490000e+04, -1.856000e+05,  5.779000e+05,
         5.779000e+05,  4.679000e+05,  3.594000e+05,  4.544000e+05,
         4.251000e+05,  9.908000e+05,  1.044800e+06,  4.949000e+05,
         1.278000e+05,  6.230000e+04,  2.750000e+04, -1.843000e+05,
         1.113900e+06,  1.114100e+06,  1.221900e+06,  1.200000e+06,
        -1.102000e+05,  2.637000e+05,  4.830000e+04, -7.640000e+04,
         7.280000e+04,  2.508000e+05,  1.380000e+05, -3.670000e+04,
         1.911000e+05,  2.072000e+05,  2.072000e+05,  2.072000e+05,
         2.072000e+05,  3.147000e+05,  3.147000e+05,  2.832000e+05,
         1.692000e+05,  2.216000e+05, -2.190000e+04,  0.000000e+00,
        -1.353000e+05, -1.117000e+05,  2.441000e+05,  3.925000e+05,
         1.314000e+05,  1.314000e+05,  6.740000e+04,  6.730000e+04,
         6.740000e+04,  8.306000e+05,  1.098500e+06,  9.795000e+05,
         3.559000e+05,  4.477000e+05,  6.069000e+05, -1.167000e+05,
         3.848000e+05,  9.065000e+05,  1.282800e+06,  9.065000e+05,
         1.284600e+06,  1.058200e+06,  7.740000e+05,  8.503000e+05,
         9.892000e+05,  4.663000e+05,  5.204000e+05,  1.753400e+06,
         2.232000e+05,  1.465000e+05,  1.998000e+05,  3.398000e+05,
         6.055000e+05, -1.940000e+05, -3.370000e+04, -6.480000e+04,
        -1.174000e+05, -6.440000e+04,  4.890000e+05,  3.394000e+05,
         4.151000e+05,  2.636000e+05,  6.095000e+05,  5.547000e+05,
         7.498000e+05,  8.578000e+05,  9.288000e+05,  4.917000e+05,
         6.555000e+05,  5.688000e+05,  9.117000e+05, -8.120000e+04,
         6.552000e+05,  5.211000e+05,  5.592000e+05,  4.898000e+05,
         3.798000e+05,  1.265000e+05,  1.266000e+05,  2.895000e+05,
         1.217400e+06,  9.473000e+05,  2.491300e+06,  1.586000e+05,
         1.588000e+05,  4.300000e+04,  4.300000e+04,  4.244000e+05,
         4.320000e+04, -4.596000e+05,  4.300000e+04,  1.829000e+05,
         1.829000e+05,  1.829000e+05,  1.828000e+05,  1.741000e+05,
        -1.906000e+05, -1.905000e+05, -1.905000e+05,  1.258000e+05,
         5.050000e+04,  0.000000e+00, -1.137000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.143600e+06, -3.173000e+05, -1.371000e+05,
         1.167300e+06,  7.907000e+05,  7.913000e+05,  1.340400e+06,
         1.340600e+06, -2.390000e+04, -1.040000e+05,  8.200000e+03,
        -5.460000e+04, -1.610000e+04, -1.830000e+04, -1.060000e+04,
         1.805000e+05,  1.052000e+05, -4.460000e+04,  1.400000e+03,
         0.000000e+00,  1.000000e+02, -2.240000e+04, -5.980000e+04,
        -1.740000e+04, -4.150000e+04, -4.160000e+04, -4.160000e+04,
         0.000000e+00,  0.000000e+00,  1.034000e+05,  1.539000e+05,
        -7.010000e+04, -3.920000e+04, -1.144000e+05, -1.610000e+04,
        -7.610000e+04, -5.580000e+04,  9.700000e+04, -2.220000e+04,
        -1.059000e+05, -1.059000e+05, -6.770000e+04, -2.300000e+04,
        -1.170000e+04, -1.732000e+05, -1.288000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.000000e+02,  1.600000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -5.460000e+04,
        -1.040000e+05,  2.370000e+04,  1.400000e+03, -4.460000e+04,
         1.829000e+05,  2.000000e+02,  2.910000e+04,  1.318000e+05,
         6.730000e+04,  2.072000e+05,  1.692000e+05,  3.624000e+05,
         4.244000e+05,  4.300000e+04,  1.588000e+05, -1.905000e+05,
        -1.371000e+05,  8.200000e+03, -4.160000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.829000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 4.740000e+05,  1.471000e+05,  1.575000e+05, -3.720000e+04,
         2.176000e+05,  2.001100e+06,  1.053200e+06,  4.607000e+05,
         1.471000e+05,  4.580000e+05,  1.467000e+05,  3.347000e+05,
         1.812000e+05, -2.834000e+05,  0.000000e+00,  3.347000e+05,
         8.050000e+04,  3.333000e+05,  2.070000e+04,  1.342000e+06,
         0.000000e+00,  7.356000e+05,  2.347000e+05,  2.633000e+05,
        -4.510000e+04,  1.919000e+05,  4.671000e+05,  1.019400e+06,
         2.328000e+05,  1.008500e+06,  1.631900e+06,  6.727000e+05,
         3.380000e+04, -8.820000e+04, -8.810000e+04, -8.850000e+04,
        -8.690000e+04, -2.560000e+05, -8.790000e+04, -5.097000e+05,
        -1.176400e+06, -1.139300e+06,  5.230000e+04, -1.118000e+05,
        -1.052000e+05,  1.796000e+05, -1.897000e+05, -6.960000e+04,
        -6.960000e+04,  4.950000e+04,  1.682000e+05,  5.780000e+04,
        -7.600000e+03,  1.431000e+05, -2.220000e+04,  5.734000e+05,
        -3.195000e+05,  2.961000e+05,  4.120000e+04, -1.880000e+05,
         6.955000e+05,  6.957000e+05,  3.629000e+05,  3.807000e+05,
         1.265300e+06,  5.741000e+05,  5.482000e+05,  1.747400e+06,
         6.820000e+04,  2.787000e+05,  1.507000e+05, -5.580000e+04,
         1.838000e+05,  6.795000e+05,  6.795000e+05,  6.795000e+05,
         6.795000e+05,  3.423000e+05,  3.423000e+05,  5.600000e+04,
         4.137000e+05,  2.484000e+05, -2.390000e+04,  0.000000e+00,
         9.540000e+04,  1.173000e+05, -2.038000e+05,  1.923000e+05,
         1.558000e+05,  1.558000e+05,  7.840000e+04,  7.840000e+04,
         7.850000e+04,  2.047500e+06,  1.205400e+06,  8.077000e+05,
         7.981000e+05,  1.175000e+06,  6.602000e+05,  5.668000e+05,
         9.031000e+05,  2.580900e+06,  1.400500e+06,  2.580900e+06,
         1.393200e+06,  1.325400e+06, -1.807000e+05, -8.049000e+05,
        -8.532000e+05,  2.541000e+05,  8.890000e+04,  1.926600e+06,
        -3.614000e+05,  2.621000e+05,  9.470000e+04, -1.122000e+05,
        -2.911000e+05,  3.528000e+05, -1.496000e+05, -1.194000e+05,
        -2.705000e+05,  5.737000e+05,  1.225000e+06,  1.010200e+06,
         3.887000e+05,  1.631700e+06,  1.833000e+05,  2.231000e+05,
         3.131000e+05, -1.760000e+04,  4.917000e+05,  1.222800e+06,
         7.305000e+05,  5.971000e+05,  4.973000e+05,  6.132000e+05,
         7.087000e+05,  1.171400e+06,  1.011000e+05,  7.130000e+04,
         1.904000e+05,  8.089000e+05,  8.089000e+05,  3.185000e+05,
         9.013000e+05,  1.728200e+06,  1.343010e+07,  1.707000e+05,
         1.709000e+05, -7.820000e+04, -7.830000e+04, -7.700000e+03,
        -7.810000e+04, -2.638000e+05, -7.830000e+04,  1.951000e+05,
         1.951000e+05,  1.951000e+05,  1.953000e+05,  2.081000e+05,
        -2.181000e+05, -2.180000e+05, -2.180000e+05, -1.807000e+05,
         4.380000e+05,  0.000000e+00, -1.346000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.308500e+06, -4.804000e+05, -2.795000e+05,
        -1.374000e+05,  3.828000e+05,  3.830000e+05,  9.687000e+05,
         9.689000e+05, -2.410000e+04, -1.051000e+05, -1.140000e+04,
         1.025000e+05, -3.960000e+04, -1.720000e+04, -1.740000e+04,
        -2.834000e+05,  3.352000e+05, -4.310000e+04, -2.400000e+03,
         0.000000e+00,  1.000000e+02, -1.930000e+04,  1.175000e+05,
        -3.340000e+04, -4.530000e+04, -4.530000e+04, -4.530000e+04,
         0.000000e+00,  0.000000e+00, -1.453000e+05, -3.060000e+05,
        -6.590000e+04,  3.150000e+04,  2.199000e+05, -3.090000e+04,
         1.369000e+05,  1.052000e+05, -1.439000e+05, -2.140000e+04,
        -1.144000e+05, -1.144000e+05,  1.320000e+05, -2.220000e+04,
        -1.060000e+04,  1.500000e+04, -1.370000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02,  7.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.025000e+05,
        -1.051000e+05, -3.720000e+04, -2.400000e+03, -4.310000e+04,
         1.951000e+05,  1.000000e+02,  4.740000e+05,  1.471000e+05,
         7.840000e+04,  6.795000e+05,  4.137000e+05, -8.700000e+04,
        -7.700000e+03, -7.830000e+04,  1.709000e+05, -2.180000e+05,
        -2.795000e+05, -1.140000e+04, -4.530000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.951000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 7.020000e+04,  6.736000e+05,  1.542000e+05,  1.210000e+04,
         4.130000e+04,  2.176000e+05,  7.720000e+04,  7.990000e+04,
         6.735000e+05,  8.180000e+04,  6.732000e+05,  1.567000e+05,
         4.507000e+05, -3.169000e+05,  0.000000e+00,  1.567000e+05,
         1.258000e+05,  1.571000e+05,  5.220000e+04,  6.298000e+05,
         0.000000e+00,  1.579000e+05,  1.183700e+06,  2.927000e+05,
         6.720000e+04,  7.618000e+05,  1.759000e+06,  4.817000e+05,
         3.729000e+05,  9.328000e+05,  1.412700e+06,  1.553700e+06,
         2.685000e+05, -7.540000e+04, -7.650000e+04, -7.450000e+04,
        -7.480000e+04, -2.750000e+05, -7.630000e+04, -1.392200e+06,
         1.173000e+05, -1.212500e+06, -2.452000e+05,  3.684000e+05,
        -2.002000e+05,  5.270000e+04, -8.580000e+04,  3.870000e+04,
         3.890000e+04,  3.751000e+05,  7.185000e+05,  1.425000e+05,
         6.100000e+04,  1.269000e+05,  6.189000e+05,  2.299800e+06,
        -3.073000e+05,  1.661000e+05,  1.359000e+05, -8.290000e+04,
         4.010000e+05,  4.012000e+05,  1.075900e+06,  4.909000e+05,
        -5.040000e+04,  3.827000e+05,  1.030000e+05,  4.640000e+04,
         9.420000e+04,  3.670000e+05,  1.825000e+05, -1.026000e+05,
         1.975000e+05,  3.192000e+05,  3.192000e+05,  3.191000e+05,
         3.191000e+05,  9.149000e+05,  9.149000e+05, -1.608000e+05,
         2.798000e+05,  5.801000e+05, -2.230000e+04,  0.000000e+00,
         3.163000e+05,  1.376000e+05, -1.886000e+05,  2.872000e+05,
         1.753000e+05,  1.753000e+05,  1.238000e+05,  1.238000e+05,
         1.238000e+05,  1.286500e+06,  2.774000e+06,  3.452000e+05,
         6.570000e+04,  6.857000e+05,  1.565200e+06, -5.510000e+04,
         2.318200e+06,  1.367900e+06,  3.453000e+06,  1.367900e+06,
         3.443600e+06,  3.978000e+05, -1.131700e+06, -1.611400e+06,
         9.400000e+04,  8.520000e+04,  5.901000e+05,  6.679600e+06,
        -2.709000e+05,  2.063000e+05,  5.476000e+05, -9.950000e+04,
        -2.557000e+05, -2.032000e+05,  7.112000e+05, -6.840000e+04,
        -6.801000e+05, -5.100000e+04,  7.280000e+05, -7.110000e+04,
        -5.334000e+05,  3.912000e+05,  2.388600e+06,  1.536000e+05,
        -7.100000e+04,  9.129000e+05,  6.555000e+05,  7.305000e+05,
         1.634380e+07,  2.497000e+05,  6.488000e+05, -1.770000e+04,
         1.613800e+06,  6.770000e+05,  1.726000e+05,  1.873000e+05,
         5.235000e+05,  2.201000e+05,  2.202000e+05,  1.131500e+06,
         2.540300e+06,  8.070000e+04,  4.185900e+06,  2.167000e+05,
         2.170000e+05,  4.510000e+04,  4.510000e+04,  6.570000e+04,
         4.530000e+04, -7.460000e+04,  4.510000e+04,  2.413000e+05,
         2.413000e+05,  2.413000e+05,  2.413000e+05,  2.326000e+05,
        -2.533000e+05, -2.531000e+05, -2.532000e+05, -3.781000e+05,
         9.570000e+04,  0.000000e+00, -1.479000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.519700e+06, -4.463000e+05, -2.007000e+05,
         8.740000e+04,  5.471000e+05,  5.457000e+05,  1.270000e+06,
         1.270300e+06, -2.400000e+04, -1.069000e+05, -4.380000e+04,
        -6.130000e+04,  2.258000e+05,  1.589000e+05, -1.410000e+04,
        -3.169000e+05,  1.569000e+05,  3.680000e+05,  1.500000e+03,
         0.000000e+00, -2.500000e+03, -6.990000e+04, -1.196000e+05,
         2.107000e+05, -5.490000e+04, -5.500000e+04, -5.500000e+04,
         0.000000e+00,  0.000000e+00, -4.049000e+05, -5.770000e+04,
         6.080000e+05,  9.890000e+04, -1.808000e+05,  1.948000e+05,
        -8.500000e+04, -6.310000e+04, -1.536000e+05,  1.837000e+05,
        -1.092000e+05, -1.092000e+05, -7.610000e+04,  2.362000e+05,
        -1.530000e+04, -1.855000e+05,  1.269000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.000000e+02,  1.600000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -6.130000e+04,
        -1.069000e+05, -4.160000e+04,  1.500000e+03,  3.680000e+05,
         2.413000e+05,  2.000000e+02,  7.020000e+04,  6.736000e+05,
         1.238000e+05,  3.192000e+05,  2.798000e+05, -7.490000e+04,
         6.570000e+04,  4.510000e+04,  2.170000e+05, -2.532000e+05,
        -2.007000e+05, -4.380000e+04, -5.500000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.413000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 2.718000e+05,  4.520000e+04,  6.380000e+04, -8.930000e+04,
         9.080000e+04,  1.163200e+06,  6.197000e+05,  2.620000e+05,
         4.520000e+04,  2.600000e+05,  4.510000e+04,  1.706000e+05,
         6.480000e+04,  3.011000e+05,  0.000000e+00,  1.706000e+05,
        -9.200000e+03,  1.696000e+05,  7.300000e+03,  6.846000e+05,
         0.000000e+00,  8.221000e+05,  4.713000e+05,  5.106000e+05,
         2.627000e+05, -5.330000e+04,  1.480000e+05,  5.217000e+05,
        -3.380000e+04,  1.233900e+06,  1.108000e+06,  1.000500e+06,
         1.555700e+06,  3.701000e+05,  3.715000e+05,  3.695000e+05,
         3.711000e+05,  4.114000e+05,  3.717000e+05,  3.650700e+06,
         3.187300e+06,  3.235400e+06,  4.726000e+05,  3.568000e+05,
         3.688000e+05,  8.000000e+02, -2.578000e+05,  4.937000e+05,
         4.937000e+05,  3.342000e+05,  1.756000e+05,  3.454000e+05,
         3.574000e+05,  9.410000e+05,  8.247000e+05,  2.690000e+04,
         2.066000e+05,  8.040000e+04, -1.001000e+05, -2.568000e+05,
         1.152500e+06,  1.152700e+06,  9.211000e+05,  9.448000e+05,
         7.730000e+05,  2.721000e+05,  3.109000e+05,  1.048100e+06,
        -1.930000e+04,  6.150000e+04,  5.370000e+04, -2.050000e+04,
         6.290000e+04,  3.481000e+05,  3.481000e+05,  3.481000e+05,
         3.481000e+05,  1.139000e+05,  1.138000e+05,  4.737000e+05,
         1.607000e+05,  4.590000e+04, -1.310000e+04,  0.000000e+00,
        -1.731000e+05, -1.638000e+05,  2.882000e+05,  2.461000e+05,
         5.840000e+04,  5.840000e+04, -1.070000e+04, -1.070000e+04,
        -1.070000e+04,  9.162000e+05,  3.314000e+05,  1.170800e+06,
         8.034000e+05,  5.711000e+05,  2.152000e+05,  3.497000e+05,
        -1.080000e+05,  1.292600e+06,  4.726000e+05,  1.292600e+06,
         4.673000e+05,  1.537200e+06,  1.746300e+06,  1.871400e+06,
         1.279000e+06,  5.475000e+05,  4.312000e+05,  6.204000e+05,
         2.445000e+05,  1.156000e+05, -2.200000e+03,  3.583000e+05,
         6.593000e+05,  2.574000e+05, -9.210000e+04, -5.420000e+04,
         3.861000e+05,  3.498000e+05,  5.988000e+05,  1.021600e+06,
         1.148900e+06,  8.942000e+05,  4.400000e+05,  5.023000e+05,
         1.026400e+06,  7.937000e+05,  5.688000e+05,  5.971000e+05,
         2.497000e+05,  8.672000e+05,  5.764000e+05,  3.791000e+05,
         2.396000e+05,  5.624000e+05,  4.295000e+05,  3.439000e+05,
         1.843000e+05,  4.449000e+05,  4.449000e+05,  1.026000e+05,
         5.855000e+05,  1.167100e+06,  7.288800e+06,  5.630000e+04,
         5.640000e+04, -5.710000e+04, -5.710000e+04,  3.562000e+05,
        -5.690000e+04, -5.542000e+05, -5.710000e+04,  6.860000e+04,
         6.860000e+04,  6.860000e+04,  6.850000e+04,  7.900000e+04,
        -8.640000e+04, -8.630000e+04, -8.630000e+04,  3.752000e+05,
         2.451000e+05,  0.000000e+00, -5.340000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -5.180000e+05, -2.030000e+05, -1.302000e+05,
         9.904000e+05,  4.941000e+05,  4.948000e+05,  7.010000e+05,
         7.012000e+05, -1.200000e+04, -7.150000e+04, -5.700000e+03,
         7.400000e+04, -2.350000e+04, -8.500000e+03, -7.700000e+03,
         3.011000e+05,  1.709000e+05, -2.050000e+04, -1.700000e+03,
         0.000000e+00,  1.000000e+02, -3.400000e+03,  8.780000e+04,
        -1.730000e+04, -1.620000e+04, -1.610000e+04, -1.610000e+04,
         0.000000e+00,  0.000000e+00,  3.999000e+05,  2.891000e+05,
        -3.260000e+04,  2.600000e+04,  1.618000e+05, -1.600000e+04,
         9.840000e+04,  7.610000e+04,  1.478000e+05, -1.010000e+04,
        -7.820000e+04, -7.820000e+04,  9.570000e+04, -1.190000e+04,
        -3.100000e+03,  1.570000e+04, -9.040000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.000000e+02,  4.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  7.400000e+04,
        -7.150000e+04,  3.950000e+04, -1.700000e+03, -2.050000e+04,
         6.860000e+04,  2.000000e+02,  2.718000e+05,  4.520000e+04,
        -1.070000e+04,  3.481000e+05,  1.607000e+05,  3.710000e+05,
         3.562000e+05, -5.710000e+04,  5.640000e+04, -8.630000e+04,
        -1.302000e+05, -5.700000e+03, -1.610000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         6.860000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 2.920000e+04,  1.335000e+05,  1.146000e+05, -4.040000e+04,
        -5.400000e+03,  6.030000e+04,  1.900000e+03,  3.730000e+04,
         1.335000e+05,  3.890000e+04,  1.332000e+05,  1.068000e+05,
         1.525000e+05,  1.824000e+05,  0.000000e+00,  1.068000e+05,
         6.960000e+04,  1.076000e+05,  1.770000e+04,  4.257000e+05,
         0.000000e+00,  4.970000e+05,  6.594000e+05,  6.280000e+05,
         3.769000e+05,  1.577000e+05,  4.279000e+05,  3.145000e+05,
         2.055000e+05,  1.545400e+06,  1.467200e+06,  1.655100e+06,
         1.894800e+06,  3.672000e+05,  3.681000e+05,  3.697000e+05,
         3.666000e+05,  3.202000e+05,  3.683000e+05,  2.712100e+06,
         2.931200e+06,  2.886800e+06,  2.896000e+05,  3.401000e+05,
         3.333000e+05, -4.580000e+04, -1.881000e+05,  5.860000e+05,
         5.860000e+05,  4.745000e+05,  3.642000e+05,  4.607000e+05,
         4.320000e+05,  1.004500e+06,  1.056600e+06,  4.988000e+05,
         1.293000e+05,  6.280000e+04,  2.760000e+04, -1.868000e+05,
         1.130000e+06,  1.130200e+06,  1.241200e+06,  1.217300e+06,
        -1.120000e+05,  2.667000e+05,  4.870000e+04, -7.770000e+04,
         7.370000e+04,  2.536000e+05,  1.396000e+05, -3.710000e+04,
         1.935000e+05,  2.095000e+05,  2.095000e+05,  2.094000e+05,
         2.095000e+05,  3.186000e+05,  3.186000e+05,  2.877000e+05,
         1.710000e+05,  2.243000e+05, -2.230000e+04,  0.000000e+00,
        -1.368000e+05, -1.131000e+05,  2.471000e+05,  3.984000e+05,
         1.329000e+05,  1.329000e+05,  6.810000e+04,  6.810000e+04,
         6.810000e+04,  8.398000e+05,  1.111700e+06,  9.926000e+05,
         3.602000e+05,  4.525000e+05,  6.148000e+05, -1.196000e+05,
         3.898000e+05,  9.166000e+05,  1.298500e+06,  9.166000e+05,
         1.300300e+06,  1.073700e+06,  7.868000e+05,  8.654000e+05,
         1.006000e+06,  4.727000e+05,  5.247000e+05,  1.775700e+06,
         2.264000e+05,  1.477000e+05,  2.019000e+05,  3.441000e+05,
         6.142000e+05, -1.966000e+05, -3.390000e+04, -6.560000e+04,
        -1.181000e+05, -6.550000e+04,  4.947000e+05,  3.439000e+05,
         4.211000e+05,  2.668000e+05,  6.046000e+05,  5.623000e+05,
         7.604000e+05,  8.647000e+05,  9.117000e+05,  4.973000e+05,
         6.488000e+05,  5.764000e+05,  9.780000e+05, -8.210000e+04,
         6.631000e+05,  5.267000e+05,  5.389000e+05,  4.964000e+05,
         3.848000e+05,  1.276000e+05,  1.277000e+05,  2.932000e+05,
         1.233000e+06,  9.724000e+05,  2.515000e+06,  1.607000e+05,
         1.609000e+05,  4.360000e+04,  4.360000e+04,  4.304000e+05,
         4.380000e+04, -4.658000e+05,  4.360000e+04,  1.851000e+05,
         1.850000e+05,  1.850000e+05,  1.849000e+05,  1.764000e+05,
        -1.931000e+05, -1.930000e+05, -1.930000e+05,  1.271000e+05,
         5.130000e+04,  0.000000e+00, -1.152000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.158600e+06, -3.210000e+05, -1.386000e+05,
         1.184100e+06,  8.013000e+05,  8.021000e+05,  1.357600e+06,
         1.357800e+06, -2.390000e+04, -1.052000e+05,  8.400000e+03,
        -5.520000e+04, -1.630000e+04, -1.840000e+04, -1.070000e+04,
         1.824000e+05,  1.066000e+05, -4.490000e+04,  1.400000e+03,
         0.000000e+00,  1.000000e+02, -2.300000e+04, -6.050000e+04,
        -1.800000e+04, -4.200000e+04, -4.210000e+04, -4.210000e+04,
         0.000000e+00,  0.000000e+00,  1.055000e+05,  1.570000e+05,
        -7.060000e+04, -3.960000e+04, -1.157000e+05, -1.660000e+04,
        -7.630000e+04, -5.640000e+04,  8.670000e+04, -2.230000e+04,
        -1.072000e+05, -1.072000e+05, -6.860000e+04, -2.310000e+04,
        -1.190000e+04, -1.753000e+05, -1.302000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.000000e+02,  1.600000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -5.520000e+04,
        -1.052000e+05,  2.390000e+04,  1.400000e+03, -4.490000e+04,
         1.851000e+05,  2.000000e+02,  2.920000e+04,  1.335000e+05,
         6.810000e+04,  2.095000e+05,  1.710000e+05,  3.667000e+05,
         4.304000e+05,  4.360000e+04,  1.609000e+05, -1.930000e+05,
        -1.386000e+05,  8.400000e+03, -4.210000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.851000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 4.060000e+05, -1.060000e+04,  2.500000e+04, -6.340000e+04,
         1.704000e+05,  1.779400e+06,  9.676000e+05,  3.862000e+05,
        -1.060000e+04,  3.822000e+05, -1.070000e+04,  2.001000e+05,
         7.000000e+03, -2.560000e+04,  0.000000e+00,  2.001000e+05,
        -3.520000e+04,  1.983000e+05,  5.000000e+02,  8.035000e+05,
         0.000000e+00,  5.898000e+05, -6.130000e+04,  1.710000e+04,
        -1.312000e+05, -1.025000e+05, -3.370000e+04,  6.166000e+05,
        -1.092000e+05,  1.676000e+05,  3.986000e+05, -2.667000e+05,
        -3.610000e+05, -3.960000e+04, -3.920000e+04, -3.990000e+04,
        -3.700000e+04, -3.790000e+04, -3.890000e+04,  5.399000e+05,
        -3.234000e+05, -2.237000e+05,  1.728000e+05, -3.750000e+04,
        -1.810000e+04,  1.059000e+05, -1.563000e+05, -1.232000e+05,
        -1.233000e+05, -1.087000e+05, -9.460000e+04, -8.160000e+04,
        -7.450000e+04, -1.880000e+04, -2.321000e+05, -1.594000e+05,
        -8.360000e+04,  1.356000e+05, -9.860000e+04, -1.554000e+05,
         3.142000e+05,  3.145000e+05, -1.182000e+05, -6.760000e+04,
         1.281400e+06,  2.546000e+05,  4.552000e+05,  1.691400e+06,
        -5.340000e+04, -4.460000e+04, -7.500000e+03, -9.600000e+03,
        -3.060000e+04,  4.104000e+05,  4.104000e+05,  4.104000e+05,
         4.104000e+05, -2.480000e+04, -2.480000e+04,  1.791000e+05,
         1.670000e+05, -4.510000e+04,  2.405500e+06,  0.000000e+00,
         2.438300e+06,  2.417700e+06, -6.080000e+04, -5.210000e+04,
         4.200000e+03,  4.200000e+03, -3.520000e+04, -3.520000e+04,
        -3.520000e+04,  9.434000e+05, -1.414000e+05,  4.881000e+05,
         2.985000e+06,  5.427100e+06,  4.822200e+06,  7.787600e+06,
         4.825300e+06,  1.432400e+06, -9.100000e+04,  1.432400e+06,
        -1.009000e+05,  9.597000e+05,  7.190000e+05,  4.865000e+05,
        -1.503000e+05,  1.694000e+05, -4.350000e+04, -1.397000e+05,
        -1.438000e+05,  8.730000e+04, -1.304000e+05,  2.390300e+06,
        -1.000000e+05,  5.359000e+05, -1.131000e+05, -3.680000e+04,
         3.051000e+05,  3.024900e+06,  6.204000e+05,  1.002100e+06,
         7.742000e+05,  1.230000e+06, -6.440000e+04,  4.760000e+04,
         3.531000e+05, -7.350000e+04, -8.120000e+04,  6.132000e+05,
        -1.770000e+04,  3.791000e+05, -8.210000e+04,  3.502100e+06,
        -5.130000e+04,  5.301000e+05, -5.220000e+04, -1.101000e+05,
        -9.550000e+04,  6.132000e+05,  6.132000e+05, -2.250000e+04,
        -1.592000e+05,  9.073000e+05,  9.779300e+06,  2.418200e+06,
         2.422500e+06, -1.188000e+05, -1.189000e+05, -7.530000e+04,
        -1.186000e+05, -1.847000e+05, -1.189000e+05, -1.420000e+04,
        -1.420000e+04, -1.420000e+04, -1.390000e+04,  1.380000e+04,
         2.266900e+06,  2.265300e+06,  2.265600e+06,  1.261000e+05,
         3.525000e+05,  0.000000e+00,  1.387300e+06,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.359900e+07, -1.118000e+05, -1.155000e+05,
        -2.539000e+05, -1.032000e+05, -1.025000e+05, -1.447000e+05,
        -1.445000e+05,  2.432900e+06, -1.980000e+04, -1.630000e+04,
         1.516000e+05, -2.510000e+04,  1.100000e+03, -4.900000e+03,
        -2.560000e+04,  2.006000e+05,  2.500000e+03, -3.700000e+03,
         0.000000e+00,  0.000000e+00,  9.900000e+03,  1.746000e+05,
        -1.390000e+04,  2.300000e+03,  2.400000e+03,  2.400000e+03,
         0.000000e+00,  0.000000e+00,  1.819000e+05, -2.340000e+04,
         4.300000e+03,  6.870000e+04,  3.261000e+05, -1.290000e+04,
         2.063000e+05,  1.556000e+05, -1.220000e+04,  1.400000e+03,
        -2.810000e+04, -2.820000e+04,  1.940000e+05,  2.000000e+02,
         2.900000e+03,  1.627000e+05, -2.850000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  3.000000e+02, -7.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.000000e+02,  1.516000e+05,
        -1.980000e+04, -3.400000e+03, -3.700000e+03,  2.500000e+03,
        -1.420000e+04,  3.000000e+02,  4.060000e+05, -1.060000e+04,
        -3.520000e+04,  4.104000e+05,  1.670000e+05, -3.720000e+04,
        -7.530000e+04, -1.189000e+05,  2.422500e+06,  2.265700e+06,
        -1.155000e+05, -1.630000e+04,  2.400000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.420000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 7.340000e+04,  7.168000e+05,  1.555000e+05,  1.590000e+04,
         4.480000e+04,  2.321000e+05,  8.530000e+04,  8.220000e+04,
         7.167000e+05,  8.410000e+04,  7.148000e+05,  1.580000e+05,
         4.718000e+05, -3.140000e+05,  0.000000e+00,  1.580000e+05,
         1.269000e+05,  1.589000e+05,  5.460000e+04,  6.305000e+05,
         0.000000e+00,  1.532000e+05,  1.068200e+06,  2.849000e+05,
         5.670000e+04,  7.741000e+05,  1.798200e+06,  4.674000e+05,
         3.784000e+05,  9.527000e+05,  1.422400e+06,  1.592700e+06,
         2.007000e+05, -7.030000e+04, -7.020000e+04, -6.910000e+04,
        -7.120000e+04, -2.710000e+05, -7.000000e+04, -1.348400e+06,
        -1.303000e+05, -1.172800e+06, -1.559000e+05,  1.459000e+05,
        -1.120000e+05,  6.110000e+04, -7.620000e+04,  1.230000e+04,
         1.220000e+04,  3.742000e+05,  7.342000e+05,  1.328000e+05,
         5.010000e+04,  1.023000e+05,  4.055000e+05,  2.215500e+06,
        -3.049000e+05,  1.701000e+05,  1.416000e+05, -7.510000e+04,
         4.156000e+05,  4.158000e+05,  1.034800e+06,  5.034000e+05,
        -3.860000e+04,  3.738000e+05,  1.030000e+05,  4.080000e+04,
         8.540000e+04,  3.701000e+05,  1.845000e+05, -9.530000e+04,
         2.085000e+05,  3.114000e+05,  3.114000e+05,  3.114000e+05,
         3.114000e+05,  9.612000e+05,  9.612000e+05, -1.578000e+05,
         2.789000e+05,  6.020000e+05, -2.460000e+04,  0.000000e+00,
         3.328000e+05,  1.326000e+05, -1.904000e+05,  2.611000e+05,
         1.772000e+05,  1.772000e+05,  1.257000e+05,  1.257000e+05,
         1.257000e+05,  1.267100e+06,  2.889900e+06,  3.236000e+05,
         6.600000e+04,  6.592000e+05,  1.631000e+06, -9.010000e+04,
         2.294400e+06,  1.332000e+06,  3.606300e+06,  1.332000e+06,
         3.625400e+06,  3.942000e+05, -1.111000e+06, -1.579800e+06,
         1.754000e+05,  8.530000e+04,  3.883000e+05,  6.949800e+06,
        -2.662000e+05,  2.035000e+05,  5.087000e+05, -9.660000e+04,
        -2.650000e+05, -2.160000e+05,  7.489000e+05, -8.430000e+04,
        -6.859000e+05, -3.010000e+04,  7.054000e+05, -1.350000e+04,
        -4.837000e+05,  4.567000e+05,  1.502500e+06,  2.060000e+05,
        -7.360000e+04,  5.328000e+05,  6.552000e+05,  7.087000e+05,
         1.613800e+06,  2.396000e+05,  6.631000e+05, -5.130000e+04,
         1.956500e+06,  1.081500e+06,  1.663000e+05,  1.743000e+05,
         5.363000e+05,  2.210000e+05,  2.211000e+05,  1.313800e+06,
         2.513200e+06,  9.972000e+05,  4.155400e+06,  2.165000e+05,
         2.168000e+05,  4.790000e+04,  4.790000e+04,  4.720000e+04,
         4.820000e+04, -7.780000e+04,  4.790000e+04,  2.442000e+05,
         2.442000e+05,  2.442000e+05,  2.439000e+05,  2.340000e+05,
        -2.500000e+05, -2.498000e+05, -2.499000e+05, -3.741000e+05,
         9.760000e+04,  0.000000e+00, -1.500000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.499900e+06, -4.334000e+05, -1.927000e+05,
         3.330000e+04,  5.368000e+05,  5.381000e+05,  1.271000e+06,
         1.271300e+06, -2.710000e+04, -1.067000e+05, -3.570000e+04,
        -6.010000e+04,  2.462000e+05,  1.621000e+05, -1.420000e+04,
        -3.140000e+05,  1.578000e+05,  4.027000e+05,  1.500000e+03,
         0.000000e+00, -3.200000e+03, -6.770000e+04, -1.108000e+05,
         1.775000e+05, -5.550000e+04, -5.560000e+04, -5.560000e+04,
         0.000000e+00,  0.000000e+00, -3.979000e+05, -9.670000e+04,
         6.200000e+05,  9.630000e+04, -1.708000e+05,  1.641000e+05,
        -8.330000e+04, -6.140000e+04, -1.600000e+05,  2.010000e+05,
        -1.085000e+05, -1.084000e+05, -7.530000e+04,  2.163000e+05,
        -1.550000e+04, -1.833000e+05,  1.081000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.000000e+02,  1.600000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -6.010000e+04,
        -1.067000e+05, -4.120000e+04,  1.500000e+03,  4.027000e+05,
         2.442000e+05,  2.000000e+02,  7.340000e+04,  7.168000e+05,
         1.257000e+05,  3.114000e+05,  2.789000e+05, -7.110000e+04,
         4.720000e+04,  4.790000e+04,  2.168000e+05, -2.499000e+05,
        -1.927000e+05, -3.570000e+04, -5.560000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.442000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 4.549000e+05,  2.015000e+05,  1.513000e+05, -3.170000e+04,
         2.110000e+05,  1.930800e+06,  1.021000e+06,  4.473000e+05,
         2.014000e+05,  4.459000e+05,  2.000000e+05,  3.266000e+05,
         2.049000e+05, -2.864000e+05,  0.000000e+00,  3.266000e+05,
         7.840000e+04,  3.265000e+05,  2.360000e+04,  1.303300e+06,
         0.000000e+00,  6.831000e+05,  2.018000e+05,  2.317000e+05,
        -6.920000e+04,  1.710000e+05,  4.989000e+05,  9.664000e+05,
         2.304000e+05,  1.022100e+06,  1.635600e+06,  7.600000e+05,
        -1.683000e+05, -8.340000e+04, -8.300000e+04, -8.400000e+04,
        -8.460000e+04, -2.570000e+05, -8.290000e+04, -5.703000e+05,
        -1.216200e+06, -1.172200e+06,  4.050000e+04, -1.243000e+05,
        -1.100000e+05,  1.807000e+05, -1.722000e+05, -9.850000e+04,
        -9.880000e+04,  4.530000e+04,  1.736000e+05,  3.120000e+04,
        -1.920000e+04,  8.340000e+04, -7.940000e+04,  6.411000e+05,
        -3.334000e+05,  2.863000e+05,  4.590000e+04, -1.740000e+05,
         6.793000e+05,  6.795000e+05,  3.770000e+05,  3.784000e+05,
         1.244400e+06,  5.376000e+05,  5.321000e+05,  1.741100e+06,
         5.810000e+04,  2.801000e+05,  1.467000e+05, -6.590000e+04,
         1.941000e+05,  6.484000e+05,  6.484000e+05,  6.483000e+05,
         6.484000e+05,  4.051000e+05,  4.051000e+05,  3.480000e+04,
         3.914000e+05,  2.674000e+05, -2.840000e+04,  0.000000e+00,
         1.119000e+05,  1.134000e+05, -2.139000e+05,  1.777000e+05,
         1.569000e+05,  1.569000e+05,  7.760000e+04,  7.750000e+04,
         7.770000e+04,  1.955600e+06,  1.345600e+06,  7.240000e+05,
         7.364000e+05,  1.114400e+06,  7.484000e+05,  4.839000e+05,
         7.759000e+05,  2.468900e+06,  1.617600e+06,  2.469000e+06,
         1.638200e+06,  1.243200e+06, -2.546000e+05, -8.673000e+05,
        -7.666000e+05,  2.402000e+05,  7.720000e+04,  2.194200e+06,
        -3.530000e+05,  2.566000e+05,  9.600000e+04, -1.136000e+05,
        -3.066000e+05,  2.962000e+05, -8.450000e+04, -1.552000e+05,
        -3.136000e+05,  5.645000e+05,  1.166100e+06,  9.386000e+05,
         3.246000e+05,  1.552700e+06,  1.244000e+05,  1.863000e+05,
         2.771000e+05, -4.860000e+04,  5.211000e+05,  1.171400e+06,
         6.770000e+05,  5.624000e+05,  5.267000e+05,  5.301000e+05,
         1.081500e+06,  9.673400e+07,  1.140000e+05,  5.500000e+04,
         1.991000e+05,  7.733000e+05,  7.733000e+05,  5.203000e+05,
         9.762000e+05,  1.790400e+06,  1.286930e+07,  1.720000e+05,
         1.721000e+05, -6.570000e+04, -6.570000e+04, -2.420000e+04,
        -6.560000e+04, -2.516000e+05, -6.570000e+04,  2.034000e+05,
         2.034000e+05,  2.034000e+05,  2.032000e+05,  2.071000e+05,
        -2.121000e+05, -2.119000e+05, -2.120000e+05, -1.772000e+05,
         4.353000e+05,  0.000000e+00, -1.366000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.272200e+06, -4.614000e+05, -2.634000e+05,
        -1.823000e+05,  3.844000e+05,  3.863000e+05,  9.967000e+05,
         9.969000e+05, -3.100000e+04, -1.050000e+05, -9.300000e+03,
         1.093000e+05, -7.600000e+03, -2.360000e+04, -1.580000e+04,
        -2.864000e+05,  3.263000e+05, -3.000000e+03, -2.100000e+03,
         0.000000e+00, -1.200000e+03, -3.150000e+04,  1.523000e+05,
        -4.880000e+04, -4.410000e+04, -4.450000e+04, -4.450000e+04,
         0.000000e+00,  0.000000e+00, -1.631000e+05, -3.265000e+05,
        -9.020000e+04,  1.180000e+04,  2.615000e+05, -4.510000e+04,
         1.205000e+05,  1.112000e+05, -1.456000e+05, -1.400000e+03,
        -1.103000e+05, -1.103000e+05,  1.658000e+05, -6.327000e+05,
        -1.180000e+04,  5.210000e+04, -7.399000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02,  9.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.093000e+05,
        -1.050000e+05, -3.760000e+04, -2.100000e+03, -3.000000e+03,
         2.034000e+05,  1.000000e+02,  4.549000e+05,  2.015000e+05,
         7.750000e+04,  6.484000e+05,  3.914000e+05, -8.450000e+04,
        -2.420000e+04, -6.570000e+04,  1.721000e+05, -2.120000e+05,
        -2.634000e+05, -9.300000e+03, -4.450000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.034000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-1.110000e+04,  3.010000e+04,  2.820000e+04, -5.260000e+04,
        -3.170000e+04, -6.540000e+04, -4.320000e+04, -8.200000e+03,
         3.010000e+04, -7.600000e+03,  3.000000e+04,  1.830000e+04,
         3.660000e+04,  3.461000e+05,  0.000000e+00,  1.830000e+04,
        -3.300000e+03,  1.860000e+04,  4.300000e+03,  7.280000e+04,
         0.000000e+00,  3.978000e+05,  4.597000e+05,  4.573000e+05,
         3.238000e+05, -2.860000e+04,  9.990000e+04,  5.240000e+04,
        -1.170000e+04,  9.823000e+05,  6.551000e+05,  1.025200e+06,
         1.663700e+06,  3.945000e+05,  3.939000e+05,  3.934000e+05,
         3.939000e+05,  4.566000e+05,  3.946000e+05,  3.354000e+06,
         3.435700e+06,  3.433300e+06,  3.645000e+05,  3.883000e+05,
         3.843000e+05, -8.430000e+04, -1.535000e+05,  5.497000e+05,
         5.497000e+05,  3.714000e+05,  1.946000e+05,  3.687000e+05,
         3.859000e+05,  9.006000e+05,  9.229000e+05,  3.150000e+04,
         2.844000e+05, -3.560000e+04, -5.680000e+04, -1.531000e+05,
         8.688000e+05,  8.696000e+05,  9.116000e+05,  9.085000e+05,
        -8.580000e+04,  5.800000e+04, -7.500000e+03, -9.660000e+04,
        -2.500000e+03,  4.440000e+04,  3.610000e+04, -7.300000e+03,
         5.290000e+04,  3.530000e+04,  3.530000e+04,  3.530000e+04,
         3.530000e+04,  7.830000e+04,  7.830000e+04,  3.624000e+05,
         1.290000e+04,  3.390000e+04, -8.200000e+03,  0.000000e+00,
        -1.886000e+05, -1.809000e+05,  3.385000e+05,  2.379000e+05,
         3.390000e+04,  3.390000e+04, -4.100000e+03, -4.100000e+03,
        -4.100000e+03,  1.269000e+05,  2.341000e+05,  7.785000e+05,
         3.056000e+05,  8.480000e+04,  1.487000e+05, -6.610000e+04,
        -2.125000e+05,  1.718000e+05,  3.223000e+05,  1.718000e+05,
         3.229000e+05,  8.256000e+05,  1.355700e+06,  1.683000e+06,
         1.441700e+06,  4.128000e+05,  4.354000e+05,  4.247000e+05,
         3.629000e+05,  3.460000e+04,  5.520000e+04,  3.863000e+05,
         7.316000e+05, -7.410000e+04, -1.030000e+04, -1.460000e+04,
         2.542000e+05, -4.610000e+04,  1.000000e+05,  3.419000e+05,
         6.692000e+05,  1.450000e+04,  4.538000e+05,  4.410000e+05,
         7.775000e+05,  8.223000e+05,  5.592000e+05,  1.011000e+05,
         1.726000e+05,  4.295000e+05,  5.389000e+05, -5.220000e+04,
         1.663000e+05,  1.140000e+05,  5.655000e+05,  3.789000e+05,
         2.006000e+05,  6.300000e+03,  6.300000e+03,  7.070000e+04,
         5.373000e+05,  4.254000e+05,  2.232000e+05,  3.930000e+04,
         3.940000e+04,  1.640000e+04,  1.640000e+04,  3.842000e+05,
         1.720000e+04, -4.092000e+05,  1.640000e+04,  4.820000e+04,
         4.820000e+04,  4.820000e+04,  4.820000e+04,  4.480000e+04,
        -5.280000e+04, -5.280000e+04, -5.280000e+04,  3.248000e+05,
        -3.100000e+03,  0.000000e+00, -3.070000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.168000e+05, -7.790000e+04, -3.070000e+04,
         1.104600e+06,  4.821000e+05,  4.837000e+05,  6.297000e+05,
         6.304000e+05, -8.000000e+03, -4.700000e+04,  4.700000e+03,
        -2.130000e+04, -5.500000e+03, -6.500000e+03, -2.600000e+03,
         3.461000e+05,  1.820000e+04, -1.540000e+04,  5.000000e+02,
         0.000000e+00,  1.000000e+02, -4.800000e+03, -2.150000e+04,
        -5.100000e+03, -1.090000e+04, -1.090000e+04, -1.090000e+04,
         0.000000e+00,  0.000000e+00,  3.151000e+05,  3.356000e+05,
        -2.500000e+04, -1.470000e+04, -4.280000e+04, -4.800000e+03,
        -3.030000e+04, -2.110000e+04,  1.820000e+05, -7.300000e+03,
        -4.820000e+04, -4.820000e+04, -2.600000e+04, -8.600000e+03,
        -3.100000e+03, -7.400000e+04, -5.670000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  7.000000e+02,  7.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.130000e+04,
        -4.700000e+04,  4.540000e+04,  5.000000e+02, -1.540000e+04,
         4.820000e+04,  7.000000e+02, -1.110000e+04,  3.010000e+04,
        -4.100000e+03,  3.530000e+04,  1.290000e+04,  3.940000e+05,
         3.842000e+05,  1.640000e+04,  3.940000e+04, -5.280000e+04,
        -3.070000e+04,  4.700000e+03, -1.090000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.820000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-4.550000e+04,  2.500000e+04,  3.250000e+04,  6.337000e+05,
         2.935000e+05, -2.191000e+05, -1.282000e+05, -4.000000e+04,
         2.500000e+04, -3.890000e+04,  2.510000e+04,  5.400000e+03,
         3.650000e+04,  2.774000e+05,  0.000000e+00,  5.400000e+03,
         3.473000e+05,  5.700000e+03,  4.300000e+03,  2.230000e+04,
         0.000000e+00,  2.946000e+05,  4.133000e+05,  4.137000e+05,
         1.423600e+06,  1.031400e+06,  9.520000e+04,  1.840000e+04,
         1.058500e+06,  8.658000e+05,  5.927000e+05,  9.375000e+05,
         8.567600e+06,  3.320000e+05,  3.326000e+05,  3.322000e+05,
         3.315000e+05,  3.739000e+05,  3.329000e+05,  2.712400e+06,
         2.872800e+06,  2.871200e+06,  2.833000e+05,  3.220000e+05,
         3.230000e+05,  9.286000e+05,  1.551300e+06,  1.263300e+06,
         1.263000e+06,  1.084700e+06,  8.957000e+05,  1.087200e+06,
         7.297000e+05,  2.315300e+06,  2.354300e+06,  1.462700e+06,
         9.819000e+05,  6.446000e+05,  9.870000e+05,  1.550500e+06,
         7.295000e+05,  7.298000e+05,  8.072000e+05,  8.089000e+05,
        -2.035000e+05,  4.880000e+04, -4.480000e+04, -2.423000e+05,
         3.673000e+05,  4.019000e+05,  4.180000e+04, -2.560000e+04,
         4.170000e+04,  1.070000e+04,  1.070000e+04,  1.070000e+04,
         1.070000e+04,  7.960000e+04,  7.960000e+04,  2.843000e+05,
         3.617000e+05,  3.964000e+05, -1.660000e+04,  0.000000e+00,
        -1.793000e+05, -1.550000e+05,  6.594000e+05,  4.415000e+05,
         3.860000e+04,  3.860000e+04,  3.526000e+05,  3.525000e+05,
         3.525000e+05,  7.961000e+05,  9.671000e+05,  1.371100e+06,
         9.167000e+05,  3.800000e+04,  1.388000e+05, -1.390000e+05,
        -1.727000e+05,  9.260000e+04,  3.337000e+05,  9.260000e+04,
         3.335000e+05,  6.366000e+05,  1.026600e+06,  1.300000e+06,
         1.168300e+06,  3.387000e+05,  3.777000e+05,  4.028000e+05,
         3.059000e+05,  3.320000e+04,  7.290000e+04,  3.151000e+05,
         1.007700e+06, -1.220000e+05, -1.470000e+04, -2.800000e+03,
         1.510000e+05, -1.153000e+05,  7.250000e+04,  1.957000e+05,
         4.696000e+05, -7.830000e+04,  3.910000e+05,  3.942000e+05,
         6.228000e+05,  7.010000e+05,  4.898000e+05,  7.130000e+04,
         1.873000e+05,  3.439000e+05,  4.964000e+05, -1.101000e+05,
         1.743000e+05,  5.500000e+04,  3.789000e+05,  1.121500e+06,
         9.432000e+05, -4.250000e+04, -4.250000e+04,  6.550000e+04,
         5.179000e+05,  3.225000e+05, -5.223000e+05,  3.680000e+04,
         3.680000e+04,  2.700000e+04,  2.710000e+04,  7.339000e+05,
         2.740000e+04, -3.330000e+05,  2.710000e+04,  5.450000e+04,
         5.450000e+04,  5.450000e+04,  5.450000e+04,  5.030000e+04,
        -6.290000e+04, -6.280000e+04, -6.280000e+04,  2.408000e+05,
        -3.110000e+04,  0.000000e+00, -3.880000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.771000e+05, -8.390000e+04, -2.840000e+04,
         2.482500e+06,  8.421000e+05,  8.410000e+05,  1.005300e+06,
         1.005700e+06, -1.740000e+04,  2.670000e+05, -1.280000e+04,
        -3.660000e+04, -9.400000e+03, -1.040000e+04, -1.400000e+03,
         2.774000e+05,  5.400000e+03, -2.880000e+04,  8.000000e+02,
         0.000000e+00,  1.000000e+02, -1.780000e+04, -6.220000e+04,
        -2.220000e+04, -1.260000e+04, -1.260000e+04, -1.260000e+04,
         0.000000e+00,  0.000000e+00,  2.299000e+05,  2.681000e+05,
        -3.970000e+04, -2.420000e+04, -9.880000e+04, -2.050000e+04,
        -4.700000e+04, -3.730000e+04,  1.363000e+05, -1.420000e+04,
         2.814000e+05,  2.814000e+05, -5.300000e+04, -1.320000e+04,
        -4.900000e+03,  2.299000e+05,  2.684000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  3.000000e+02, -2.400000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -3.660000e+04,
         2.670000e+05,  3.640000e+04,  8.000000e+02, -2.880000e+04,
         5.450000e+04,  3.000000e+02, -4.550000e+04,  2.500000e+04,
         3.525000e+05,  1.070000e+04,  3.617000e+05,  3.316000e+05,
         7.339000e+05,  2.710000e+04,  3.680000e+04, -6.280000e+04,
        -2.840000e+04, -1.280000e+04, -1.260000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         5.450000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-2.230000e+04,  2.086000e+05,  5.590000e+04,  6.680000e+05,
         3.222000e+05, -1.303000e+05, -8.580000e+04, -1.620000e+04,
         2.085000e+05, -1.510000e+04,  2.080000e+05,  3.400000e+04,
         1.446000e+05,  2.710000e+04,  0.000000e+00,  3.400000e+04,
         3.806000e+05,  3.440000e+04,  1.680000e+04,  1.366000e+05,
         0.000000e+00,  1.291000e+05,  4.647000e+05,  2.504000e+05,
         1.248200e+06,  1.328400e+06,  5.985000e+05,  1.029000e+05,
         1.162500e+06,  5.989000e+05,  6.047000e+05,  8.277000e+05,
         7.635700e+06,  1.164000e+05,  1.167000e+05,  1.168000e+05,
         1.160000e+05,  7.840000e+04,  1.171000e+05,  6.939000e+05,
         1.142800e+06,  8.556000e+05,  6.160000e+04,  1.726000e+05,
         1.020000e+05,  9.924000e+05,  1.619900e+06,  9.409000e+05,
         9.346000e+05,  1.089800e+06,  1.053000e+06,  9.158000e+05,
         5.230000e+05,  1.809200e+06,  1.920600e+06,  2.696200e+06,
         7.542000e+05,  7.067000e+05,  1.056000e+06,  1.617700e+06,
         3.900000e+05,  3.903000e+05,  6.156000e+05,  4.709000e+05,
        -1.690000e+05,  1.094000e+05, -1.610000e+04, -1.847000e+05,
         3.707000e+05,  4.703000e+05,  6.810000e+04, -4.560000e+04,
         6.480000e+04,  6.740000e+04,  6.740000e+04,  6.740000e+04,
         6.740000e+04,  2.978000e+05,  2.978000e+05,  6.200000e+04,
         4.215000e+05,  5.368000e+05, -1.770000e+04,  0.000000e+00,
         7.930000e+04, -3.090000e+04,  4.340000e+05,  3.550000e+05,
         6.430000e+04,  6.430000e+04,  3.873000e+05,  3.872000e+05,
         3.872000e+05,  1.034200e+06,  1.609900e+06,  1.036100e+06,
         7.602000e+05,  1.550000e+05,  4.997000e+05, -1.286000e+05,
         6.889000e+05,  3.252000e+05,  1.131600e+06,  3.252000e+05,
         1.131800e+06,  3.129000e+05,  6.970000e+04,  6.420000e+04,
         5.284000e+05,  1.510000e+05,  2.624000e+05,  2.253900e+06,
         5.840000e+04,  6.450000e+04,  1.765000e+05,  9.860000e+04,
         5.505000e+05, -1.362000e+05,  2.083000e+05, -1.490000e+04,
        -1.423000e+05, -9.660000e+04,  1.911000e+05,  1.920000e+04,
         1.390000e+04,  2.450000e+04,  5.762000e+05,  2.213000e+05,
         2.128000e+05,  4.357000e+05,  3.798000e+05,  1.904000e+05,
         5.235000e+05,  1.843000e+05,  3.848000e+05, -9.550000e+04,
         5.363000e+05,  1.991000e+05,  2.006000e+05,  9.432000e+05,
         1.673600e+06,  8.000000e+03,  8.100000e+03,  3.582000e+05,
         9.084000e+05,  3.514000e+05,  3.708000e+05,  7.100000e+04,
         7.090000e+04,  3.020000e+04,  3.020000e+04,  5.261000e+05,
         3.060000e+04, -1.454000e+05,  3.020000e+04,  8.920000e+04,
         8.920000e+04,  8.920000e+04,  8.910000e+04,  8.400000e+04,
        -9.960000e+04, -9.950000e+04, -9.960000e+04, -1.330000e+04,
        -6.400000e+03,  0.000000e+00, -5.900000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -5.976000e+05, -1.487000e+05, -5.920000e+04,
         1.858400e+06,  7.040000e+05,  7.033000e+05,  9.717000e+05,
         9.720000e+05, -1.790000e+04,  2.659000e+05, -2.440000e+04,
        -4.040000e+04,  6.560000e+04,  5.730000e+04, -3.500000e+03,
         2.710000e+04,  3.400000e+04,  1.615000e+05,  9.000000e+02,
         0.000000e+00,  3.200000e+03, -3.260000e+04, -7.860000e+04,
         3.120000e+04, -2.050000e+04, -2.050000e+04, -2.050000e+04,
         0.000000e+00,  0.000000e+00, -2.670000e+04,  8.400000e+04,
         2.192000e+05,  3.350000e+04, -1.190000e+05,  2.890000e+04,
        -5.320000e+04, -4.120000e+04,  1.190000e+04,  8.080000e+04,
         2.803000e+05,  2.803000e+05, -5.790000e+04,  5.450000e+04,
        -7.100000e+03,  2.236000e+05,  3.349000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  3.000000e+02, -2.400000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -4.040000e+04,
         2.659000e+05,  3.600000e+03,  9.000000e+02,  1.615000e+05,
         8.920000e+04,  3.000000e+02, -2.230000e+04,  2.086000e+05,
         3.872000e+05,  6.740000e+04,  4.215000e+05,  1.160000e+05,
         5.261000e+05,  3.020000e+04,  7.090000e+04, -9.960000e+04,
        -5.920000e+04, -2.440000e+04, -2.050000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         8.920000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 4.404000e+05,  4.610000e+04,  7.630000e+04, -5.050000e+04,
         1.940000e+05,  1.895600e+06,  1.014900e+06,  4.183000e+05,
         4.600000e+04,  4.139000e+05,  4.590000e+04,  2.485000e+05,
         6.810000e+04, -1.146000e+05,  0.000000e+00,  2.485000e+05,
         7.000000e+03,  2.470000e+05,  7.600000e+03,  9.934000e+05,
         0.000000e+00,  6.317000e+05,  4.520000e+04,  8.640000e+04,
        -9.810000e+04,  1.900000e+03,  1.448000e+05,  7.433000e+05,
         1.220000e+04,  4.661000e+05,  8.323000e+05,  7.470000e+04,
        -2.031000e+05, -5.430000e+04, -5.420000e+04, -5.470000e+04,
        -5.400000e+04, -1.129000e+05, -5.350000e+04,  1.773000e+05,
        -6.067000e+05, -5.498000e+05,  1.353000e+05, -6.090000e+04,
        -4.650000e+04,  1.430000e+05, -1.573000e+05, -1.002000e+05,
        -1.002000e+05, -4.970000e+04,  4.000000e+02, -3.630000e+04,
        -4.730000e+04,  4.760000e+04, -1.483000e+05,  1.042000e+05,
        -1.638000e+05,  1.989000e+05, -4.540000e+04, -1.569000e+05,
         4.468000e+05,  4.475000e+05,  5.770000e+04,  8.320000e+04,
         1.285800e+06,  3.626000e+05,  4.884000e+05,  1.690600e+06,
        -9.000000e+03,  7.010000e+04,  4.920000e+04, -2.580000e+04,
         4.600000e+04,  4.990000e+05,  4.990000e+05,  4.990000e+05,
         4.990000e+05,  1.066000e+05,  1.065000e+05,  1.323000e+05,
         2.561000e+05,  5.920000e+04, -1.340000e+04,  0.000000e+00,
         3.660000e+04,  4.240000e+04, -1.091000e+05,  3.600000e+04,
         6.000000e+04,  6.000000e+04,  5.100000e+03,  5.100000e+03,
         5.200000e+03,  1.321300e+06,  3.394000e+05,  5.880000e+05,
         7.674000e+05,  7.819000e+05,  1.926000e+05,  5.892000e+05,
         2.939000e+05,  1.807100e+06,  4.333000e+05,  1.807100e+06,
         4.340000e+05,  1.074000e+06,  4.094000e+05,  4.300000e+04,
        -3.742000e+05,  1.964000e+05,  4.000000e+02,  6.018000e+05,
        -2.170000e+05,  1.467000e+05, -4.890000e+04, -6.750000e+04,
        -1.627000e+05,  4.636000e+05, -1.238000e+05, -8.180000e+04,
         9.980000e+04,  6.197000e+05,  8.079000e+05,  1.014200e+06,
         6.477000e+05,  1.380600e+06,  3.460000e+04,  1.052000e+05,
         3.323000e+05, -5.950000e+04,  1.265000e+05,  8.089000e+05,
         2.201000e+05,  4.449000e+05,  1.276000e+05,  6.132000e+05,
         2.210000e+05,  7.733000e+05,  6.300000e+03, -4.250000e+04,
         8.000000e+03,  8.489000e+05,  8.476000e+05,  1.007000e+05,
         2.240000e+05,  1.203600e+06,  1.118950e+07,  4.620000e+04,
         4.630000e+04, -1.028000e+05, -1.029000e+05, -4.870000e+04,
        -1.022000e+05, -2.120000e+05, -1.029000e+05,  6.050000e+04,
         6.050000e+04,  6.050000e+04,  6.050000e+04,  7.960000e+04,
        -6.920000e+04, -6.920000e+04, -6.920000e+04,  1.800000e+04,
         3.811000e+05,  0.000000e+00, -5.400000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -4.152000e+05, -2.219000e+05, -1.624000e+05,
        -2.018000e+05,  7.360000e+04,  7.500000e+04,  2.578000e+05,
         2.585000e+05, -1.350000e+04, -4.720000e+04, -1.450000e+04,
         1.327000e+05, -3.050000e+04, -5.400000e+03, -1.000000e+04,
        -1.146000e+05,  2.485000e+05, -1.340000e+04, -3.300000e+03,
         0.000000e+00,  0.000000e+00, -6.200000e+03,  1.583000e+05,
        -2.130000e+04, -1.480000e+04, -1.470000e+04, -1.470000e+04,
         0.000000e+00,  0.000000e+00,  7.200000e+04, -1.221000e+05,
        -2.070000e+04,  5.700000e+04,  2.909000e+05, -1.970000e+04,
         1.837000e+05,  1.339000e+05, -5.760000e+04, -6.400000e+03,
        -5.560000e+04, -5.560000e+04,  1.760000e+05, -8.200000e+03,
        -1.600000e+03,  1.186000e+05, -6.410000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  7.000000e+02, -2.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.327000e+05,
        -4.720000e+04, -1.500000e+04, -3.300000e+03, -1.340000e+04,
         6.050000e+04,  7.000000e+02,  4.404000e+05,  4.610000e+04,
         5.100000e+03,  4.990000e+05,  2.561000e+05, -5.400000e+04,
        -4.870000e+04, -1.029000e+05,  4.630000e+04, -6.920000e+04,
        -1.624000e+05, -1.450000e+04, -1.470000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         6.050000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 4.404000e+05,  4.610000e+04,  7.630000e+04, -5.040000e+04,
         1.940000e+05,  1.895400e+06,  1.014800e+06,  4.183000e+05,
         4.610000e+04,  4.139000e+05,  4.590000e+04,  2.484000e+05,
         6.810000e+04, -1.147000e+05,  0.000000e+00,  2.484000e+05,
         7.100000e+03,  2.469000e+05,  7.600000e+03,  9.933000e+05,
         0.000000e+00,  6.317000e+05,  4.530000e+04,  8.630000e+04,
        -9.810000e+04,  1.900000e+03,  1.449000e+05,  7.433000e+05,
         1.220000e+04,  4.662000e+05,  8.324000e+05,  7.490000e+04,
        -2.030000e+05, -5.430000e+04, -5.420000e+04, -5.470000e+04,
        -5.400000e+04, -1.130000e+05, -5.350000e+04,  1.771000e+05,
        -6.067000e+05, -5.500000e+05,  1.353000e+05, -6.090000e+04,
        -4.650000e+04,  1.430000e+05, -1.573000e+05, -1.002000e+05,
        -1.002000e+05, -4.970000e+04,  5.000000e+02, -3.630000e+04,
        -4.730000e+04,  4.760000e+04, -1.483000e+05,  1.043000e+05,
        -1.639000e+05,  1.989000e+05, -4.540000e+04, -1.569000e+05,
         4.468000e+05,  4.475000e+05,  5.780000e+04,  8.320000e+04,
         1.285900e+06,  3.625000e+05,  4.884000e+05,  1.690900e+06,
        -9.000000e+03,  7.010000e+04,  4.920000e+04, -2.580000e+04,
         4.600000e+04,  4.990000e+05,  4.990000e+05,  4.990000e+05,
         4.990000e+05,  1.066000e+05,  1.066000e+05,  1.322000e+05,
         2.561000e+05,  5.930000e+04, -1.340000e+04,  0.000000e+00,
         3.660000e+04,  4.240000e+04, -1.091000e+05,  3.600000e+04,
         6.000000e+04,  6.000000e+04,  5.200000e+03,  5.200000e+03,
         5.200000e+03,  1.321300e+06,  3.396000e+05,  5.879000e+05,
         7.673000e+05,  7.819000e+05,  1.927000e+05,  5.891000e+05,
         2.941000e+05,  1.807000e+06,  4.335000e+05,  1.807000e+06,
         4.342000e+05,  1.073900e+06,  4.091000e+05,  4.270000e+04,
        -3.742000e+05,  1.964000e+05,  5.000000e+02,  6.021000e+05,
        -2.170000e+05,  1.468000e+05, -4.880000e+04, -6.750000e+04,
        -1.627000e+05,  4.635000e+05, -1.238000e+05, -8.180000e+04,
         9.970000e+04,  6.195000e+05,  8.079000e+05,  1.014000e+06,
         6.476000e+05,  1.380500e+06,  3.460000e+04,  1.051000e+05,
         3.323000e+05, -5.950000e+04,  1.266000e+05,  8.089000e+05,
         2.202000e+05,  4.449000e+05,  1.277000e+05,  6.132000e+05,
         2.211000e+05,  7.733000e+05,  6.300000e+03, -4.250000e+04,
         8.100000e+03,  8.476000e+05,  1.032600e+06,  1.007000e+05,
         2.241000e+05,  1.203500e+06,  1.119910e+07,  4.630000e+04,
         4.630000e+04, -1.028000e+05, -1.028000e+05, -4.870000e+04,
        -1.022000e+05, -2.120000e+05, -1.028000e+05,  6.050000e+04,
         6.050000e+04,  6.050000e+04,  6.060000e+04,  7.960000e+04,
        -6.930000e+04, -6.920000e+04, -6.920000e+04,  1.800000e+04,
         3.812000e+05,  0.000000e+00, -5.400000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -4.155000e+05, -2.219000e+05, -1.624000e+05,
        -2.017000e+05,  7.370000e+04,  7.510000e+04,  2.579000e+05,
         2.586000e+05, -1.350000e+04, -4.720000e+04, -1.450000e+04,
         1.327000e+05, -3.050000e+04, -5.400000e+03, -1.000000e+04,
        -1.147000e+05,  2.485000e+05, -1.340000e+04, -3.300000e+03,
         0.000000e+00,  0.000000e+00, -6.200000e+03,  1.583000e+05,
        -2.130000e+04, -1.480000e+04, -1.470000e+04, -1.470000e+04,
         0.000000e+00,  0.000000e+00,  7.190000e+04, -1.221000e+05,
        -2.070000e+04,  5.700000e+04,  2.909000e+05, -1.970000e+04,
         1.837000e+05,  1.340000e+05, -5.760000e+04, -6.400000e+03,
        -5.560000e+04, -5.560000e+04,  1.759000e+05, -8.200000e+03,
        -1.700000e+03,  1.186000e+05, -6.410000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  7.000000e+02, -2.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.327000e+05,
        -4.720000e+04, -1.500000e+04, -3.300000e+03, -1.340000e+04,
         6.050000e+04,  7.000000e+02,  4.404000e+05,  4.610000e+04,
         5.200000e+03,  4.990000e+05,  2.561000e+05, -5.400000e+04,
        -4.870000e+04, -1.028000e+05,  4.630000e+04, -6.920000e+04,
        -1.624000e+05, -1.450000e+04, -1.470000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         6.050000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 3.310000e+04,  6.152000e+05,  7.040000e+04,  2.800000e+03,
         1.800000e+04,  1.056000e+05,  3.940000e+04,  3.700000e+04,
         6.151000e+05,  3.790000e+04,  6.134000e+05,  7.090000e+04,
         3.580000e+05, -1.463000e+05,  0.000000e+00,  7.090000e+04,
         5.470000e+04,  7.140000e+04,  4.140000e+04,  2.830000e+05,
         0.000000e+00,  6.290000e+04,  8.803000e+05,  1.252000e+05,
         1.060000e+04,  5.894000e+05,  1.476100e+06,  2.094000e+05,
         1.632000e+05,  4.168000e+05,  6.332000e+05,  9.926000e+05,
         4.900000e+03, -3.700000e+04, -3.700000e+04, -3.610000e+04,
        -3.730000e+04, -1.284000e+05, -3.620000e+04, -6.532000e+05,
         4.358000e+05, -5.702000e+05, -7.480000e+04,  1.962000e+05,
        -5.400000e+04,  2.110000e+04, -4.500000e+04, -1.280000e+04,
        -1.290000e+04,  2.798000e+05,  5.704000e+05,  4.920000e+04,
         1.300000e+04,  1.710000e+04,  2.888000e+05,  1.752000e+06,
        -1.466000e+05,  7.200000e+04,  5.710000e+04, -4.470000e+04,
         1.753000e+05,  1.761000e+05,  7.296000e+05,  2.169000e+05,
        -1.470000e+04,  1.682000e+05,  4.720000e+04,  2.010000e+04,
         1.020000e+04,  1.639000e+05,  8.280000e+04, -6.590000e+04,
         7.050000e+04,  1.397000e+05,  1.397000e+05,  1.397000e+05,
         1.397000e+05,  7.256000e+05,  7.256000e+05, -7.660000e+04,
         1.226000e+05,  4.145000e+05, -1.090000e+04,  0.000000e+00,
         2.784000e+05,  6.240000e+04, -9.400000e+04,  1.078000e+05,
         7.980000e+04,  7.980000e+04,  5.420000e+04,  5.420000e+04,
         5.420000e+04,  5.639000e+05,  2.026600e+06,  1.269000e+05,
         1.740000e+04,  2.966000e+05,  1.173400e+06, -3.980000e+04,
         1.695600e+06,  5.981000e+05,  2.648800e+06,  5.981000e+05,
         2.688900e+06,  1.662000e+05, -5.213000e+05, -7.374000e+05,
         6.368000e+05,  3.410000e+04,  3.057000e+05,  5.625300e+06,
        -1.244000e+05,  9.190000e+04,  3.644000e+05, -4.790000e+04,
        -1.347000e+05, -9.650000e+04,  7.722000e+05, -3.420000e+04,
        -3.128000e+05, -1.190000e+04,  3.169000e+05, -9.000000e+03,
        -2.257000e+05,  2.077000e+05,  1.349200e+06,  9.480000e+04,
        -4.140000e+04,  5.018000e+05,  2.895000e+05,  3.185000e+05,
         1.131500e+06,  1.026000e+05,  2.932000e+05, -2.250000e+04,
         1.313800e+06,  5.203000e+05,  7.070000e+04,  6.550000e+04,
         3.582000e+05,  1.007000e+05,  1.007000e+05,  2.536300e+06,
         1.840100e+06,  4.819000e+05,  1.887800e+06,  9.740000e+04,
         9.750000e+04,  2.140000e+04,  2.140000e+04,  9.200000e+03,
         2.220000e+04, -2.970000e+04,  2.140000e+04,  1.096000e+05,
         1.096000e+05,  1.096000e+05,  1.095000e+05,  1.050000e+05,
        -1.125000e+05, -1.124000e+05, -1.124000e+05, -1.733000e+05,
         4.390000e+04,  0.000000e+00, -6.720000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -6.746000e+05, -1.943000e+05, -8.640000e+04,
        -2.310000e+04,  2.308000e+05,  2.331000e+05,  5.636000e+05,
         5.644000e+05, -1.130000e+04, -5.000000e+04, -3.920000e+04,
        -2.690000e+04,  2.568000e+05,  1.738000e+05, -6.300000e+03,
        -1.463000e+05,  7.080000e+04,  4.318000e+05,  7.000000e+02,
         0.000000e+00, -3.300000e+03, -5.020000e+04, -7.250000e+04,
         1.898000e+05, -2.490000e+04, -2.500000e+04, -2.500000e+04,
         0.000000e+00,  0.000000e+00, -1.843000e+05,  8.690000e+04,
         6.649000e+05,  1.207000e+05, -9.940000e+04,  1.755000e+05,
        -3.770000e+04, -2.680000e+04, -7.420000e+04,  2.158000e+05,
        -5.100000e+04, -5.090000e+04, -3.370000e+04,  2.307000e+05,
        -6.900000e+03, -8.460000e+04,  1.800000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  8.000000e+02,  7.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.690000e+04,
        -5.000000e+04, -1.920000e+04,  7.000000e+02,  4.318000e+05,
         1.096000e+05,  8.000000e+02,  3.310000e+04,  6.152000e+05,
         5.420000e+04,  1.397000e+05,  1.226000e+05, -3.730000e+04,
         9.200000e+03,  2.140000e+04,  9.750000e+04, -1.124000e+05,
        -8.640000e+04, -3.920000e+04, -2.500000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.096000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 4.420000e+04,  1.105400e+06,  2.118000e+05, -2.160000e+04,
         1.170000e+04,  7.180000e+04, -1.670000e+04,  5.960000e+04,
         1.105300e+06,  6.280000e+04,  1.103500e+06,  1.913000e+05,
         7.089000e+05, -1.296000e+05,  0.000000e+00,  1.913000e+05,
         1.545000e+05,  1.928000e+05,  8.210000e+04,  7.628000e+05,
         0.000000e+00,  4.348000e+05,  2.090500e+06,  6.999000e+05,
         3.251000e+05,  1.121700e+06,  2.797700e+06,  5.644000e+05,
         4.581000e+05,  5.493000e+06,  5.808500e+06,  6.575900e+06,
         1.529800e+06,  2.097000e+05,  2.104000e+05,  2.118000e+05,
         2.081000e+05,  6.900000e+03,  2.127000e+05,  7.812000e+05,
         2.988800e+06,  1.134700e+06,  6.430000e+04,  6.106000e+05,
         1.526000e+05, -9.900000e+03, -2.142000e+05,  4.551000e+05,
         4.552000e+05,  8.458000e+05,  1.241400e+06,  4.512000e+05,
         3.698000e+05,  8.273000e+05,  1.376200e+06,  3.328800e+06,
        -1.650000e+05,  1.639000e+05,  1.303000e+05, -2.118000e+05,
         1.137300e+06,  1.139600e+06,  2.247000e+06,  1.314000e+06,
        -2.285000e+05,  4.857000e+05,  8.160000e+04, -1.747000e+05,
         9.390000e+04,  4.923000e+05,  2.563000e+05, -1.472000e+05,
         2.761000e+05,  3.753000e+05,  3.753000e+05,  3.753000e+05,
         3.754000e+05,  1.445600e+06,  1.445600e+06,  6.000000e+04,
         3.373000e+05,  8.699000e+05, -3.690000e+04,  0.000000e+00,
         3.508000e+05,  2.830000e+04,  2.200000e+04,  5.271000e+05,
         2.447000e+05,  2.447000e+05,  1.519000e+05,  1.519000e+05,
         1.519000e+05,  1.577000e+06,  4.249800e+06,  9.466000e+05,
         2.497000e+05,  8.271000e+05,  2.428000e+06, -2.178000e+05,
         3.219200e+06,  1.652700e+06,  5.398800e+06,  1.652700e+06,
         5.424700e+06,  1.022700e+06, -4.275000e+05, -7.425000e+05,
         1.730100e+06,  4.019000e+05,  9.505000e+05,  1.068900e+07,
         3.548200e+06,  3.864600e+06,  4.417100e+06,  1.724000e+05,
         2.377000e+05,  3.213300e+06,  4.923100e+06,  3.478400e+06,
         2.897100e+06, -1.293000e+05,  8.966000e+05,  1.532000e+05,
        -1.640000e+05,  4.703000e+05,  2.897300e+06,  5.950000e+05,
         4.640000e+05,  1.561600e+06,  1.217400e+06,  9.013000e+05,
         2.540300e+06,  5.855000e+05,  1.233000e+06, -1.592000e+05,
         2.513200e+06,  9.762000e+05,  5.373000e+05,  5.179000e+05,
         9.084000e+05,  2.240000e+05,  2.241000e+05,  1.840100e+06,
         7.309540e+07,  7.035130e+07,  4.455000e+06,  2.985000e+05,
         2.988000e+05,  3.673400e+06,  3.675900e+06,  3.661000e+05,
         3.678200e+06,  6.801900e+06,  3.675900e+06,  3.398000e+05,
         3.398000e+05,  3.398000e+05,  3.395000e+05,  3.231000e+05,
        -3.482000e+05, -3.480000e+05, -3.480000e+05, -2.342000e+05,
         8.630000e+04,  0.000000e+00, -2.088000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.089100e+06,  3.005400e+06,  3.340700e+06,
         9.271000e+05,  1.050200e+06,  1.054500e+06,  2.078700e+06,
         2.081100e+06, -3.850000e+04, -1.686000e+05, -6.370000e+04,
        -1.045000e+05,  4.002000e+05,  2.714000e+05, -1.900000e+04,
        -1.296000e+05,  1.910000e+05,  6.528000e+05,  2.500000e+03,
         0.000000e+00, -4.700000e+03, -1.083000e+05, -1.941000e+05,
         3.299000e+05, -7.710000e+04, -7.730000e+04, -7.730000e+04,
         0.000000e+00,  0.000000e+00, -2.737000e+05,  2.708000e+05,
         1.038100e+06,  1.639000e+05, -2.985000e+05,  3.051000e+05,
        -1.432000e+05, -1.049000e+05, -6.970000e+04,  3.269000e+05,
        -1.710000e+05, -1.710000e+05, -1.311000e+05,  3.812000e+05,
        -2.170000e+04, -3.011000e+05,  2.105000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.400000e+03,  2.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.045000e+05,
        -1.686000e+05, -1.700000e+04,  2.500000e+03,  6.528000e+05,
         3.398000e+05,  2.400000e+03,  4.420000e+04,  1.105400e+06,
         1.519000e+05,  3.753000e+05,  3.373000e+05,  2.083000e+05,
         3.661000e+05,  3.675900e+06,  2.988000e+05, -3.481000e+05,
         3.340700e+06, -6.370000e+04, -7.730000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         3.398000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 7.152000e+05,  2.264000e+05,  2.162000e+05, -1.037000e+05,
         3.045000e+05,  3.035400e+06,  1.605300e+06,  6.929000e+05,
         2.263000e+05,  6.884000e+05,  2.245000e+05,  4.869000e+05,
         2.585000e+05, -7.350000e+04,  0.000000e+00,  4.869000e+05,
         7.860000e+04,  4.849000e+05,  2.950000e+04,  1.947700e+06,
         0.000000e+00,  1.406400e+06,  5.039000e+05,  6.604000e+05,
         1.379000e+05,  1.723000e+05,  6.399000e+05,  1.467800e+06,
         2.242000e+05,  5.609300e+06,  6.163200e+06,  5.092800e+06,
         1.143700e+06,  1.865000e+05,  1.881000e+05,  1.871000e+05,
         1.867000e+05,  3.810000e+04,  1.903000e+05,  2.239700e+06,
         9.097000e+05,  1.245100e+06,  4.968000e+05, -5.240000e+04,
         2.481000e+05,  2.005000e+05, -3.873000e+05,  2.727000e+05,
         2.725000e+05,  3.013000e+05,  3.227000e+05,  3.132000e+05,
         2.529000e+05,  8.437000e+05, -6.469000e+05, -5.027000e+05,
        -1.835000e+05,  3.796000e+05, -2.770000e+04, -3.866000e+05,
         1.620300e+06,  1.622500e+06,  1.050900e+06,  1.123000e+06,
         1.957800e+06,  8.087000e+05,  8.233000e+05,  2.663600e+06,
         5.070000e+04,  3.434000e+05,  2.019000e+05, -6.870000e+04,
         2.511000e+05,  9.795000e+05,  9.795000e+05,  9.794000e+05,
         9.795000e+05,  4.878000e+05,  4.877000e+05,  4.234000e+05,
         5.598000e+05,  3.151000e+05, -3.750000e+04,  0.000000e+00,
        -1.480000e+04, -3.200000e+03, -3.100000e+03,  3.657000e+05,
         2.106000e+05,  2.106000e+05,  7.610000e+04,  7.610000e+04,
         7.620000e+04,  2.849600e+06,  1.624300e+06,  1.721500e+06,
         1.462000e+06,  1.653200e+06,  9.175000e+05,  8.355000e+05,
         8.597000e+05,  3.687200e+06,  1.966100e+06,  3.687200e+06,
         1.992900e+06,  2.570000e+06,  1.156200e+06,  5.985000e+05,
         1.391000e+05,  6.821000e+05, -7.078000e+05,  2.748200e+06,
         3.396200e+06,  3.960000e+06,  3.660700e+06,  1.515000e+05,
         1.759000e+05,  4.147800e+06,  3.487600e+06,  3.401800e+06,
         3.584300e+06,  9.011000e+05,  1.735700e+06,  1.915200e+06,
         1.342500e+06,  2.487800e+06, -5.537600e+06,  6.718000e+05,
         1.103400e+06, -1.877700e+06,  9.473000e+05,  1.728200e+06,
         8.070000e+04,  1.167100e+06,  9.724000e+05,  9.073000e+05,
         9.972000e+05,  1.790400e+06,  4.254000e+05,  3.225000e+05,
         3.514000e+05,  1.203600e+06,  1.203500e+06,  4.819000e+05,
         7.035130e+07,  5.966855e+08,  1.985780e+07,  2.223000e+05,
         2.226000e+05,  3.466200e+06,  3.468500e+06,  2.418000e+05,
         3.470700e+06,  6.488100e+06,  3.468500e+06,  2.609000e+05,
         2.609000e+05,  2.609000e+05,  2.608000e+05,  2.809000e+05,
        -2.927000e+05, -2.925000e+05, -2.926000e+05,  9.460000e+04,
         6.558000e+05,  0.000000e+00, -1.846000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.756000e+06,  2.942300e+06,  3.205400e+06,
         5.465000e+05,  7.701000e+05,  7.769000e+05,  1.563900e+06,
         1.566100e+06, -3.600000e+04, -1.650000e+05, -9.800000e+03,
         1.679000e+05, -4.230000e+04, -2.190000e+04, -2.430000e+04,
        -7.350000e+04,  4.875000e+05, -3.180000e+04, -4.000000e+03,
         0.000000e+00, -4.000000e+02, -2.000000e+04,  2.005000e+05,
        -7.680000e+04, -6.070000e+04, -6.070000e+04, -6.070000e+04,
         0.000000e+00,  0.000000e+00,  1.580000e+05, -1.415000e+05,
        -8.400000e+04,  5.180000e+04,  3.683000e+05, -7.110000e+04,
         2.266000e+05,  1.748000e+05, -4.760000e+04, -1.480000e+04,
        -1.794000e+05, -1.794000e+05,  2.154000e+05, -4.900000e+04,
        -1.370000e+04,  3.240000e+04, -2.288000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.200000e+03,  1.100000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.679000e+05,
        -1.650000e+05, -9.600000e+03, -4.000000e+03, -3.180000e+04,
         2.609000e+05,  2.200000e+03,  7.152000e+05,  2.264000e+05,
         7.610000e+04,  9.795000e+05,  5.598000e+05,  1.867000e+05,
         2.418000e+05,  3.468500e+06,  2.226000e+05, -2.926000e+05,
         3.205400e+06, -9.800000e+03, -6.070000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.609000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 7.045000e+06,  8.648000e+05,  1.268100e+06, -7.839000e+05,
         3.116300e+06,  3.040930e+07,  1.632140e+07,  6.740900e+06,
         8.647000e+05,  6.680100e+06,  8.618000e+05,  4.068200e+06,
         1.209300e+06, -2.047300e+06,  0.000000e+00,  4.068200e+06,
         2.069000e+05,  4.046300e+06,  1.354000e+05,  1.627650e+07,
         0.000000e+00,  1.020920e+07,  9.707000e+05,  1.560600e+06,
        -1.485600e+06,  2.834000e+05,  2.727500e+06,  1.221700e+07,
         4.869000e+05,  8.138600e+06,  1.430740e+07,  1.970200e+06,
        -2.891300e+06, -9.093000e+05, -9.086000e+05, -9.158000e+05,
        -9.019000e+05, -1.986300e+06, -8.981000e+05,  1.930900e+06,
        -1.040790e+07, -9.600600e+06,  2.044700e+06, -1.036700e+06,
        -8.382000e+05,  2.323400e+06, -2.541900e+06, -1.549900e+06,
        -1.549900e+06, -6.568000e+05,  2.306000e+05, -4.649000e+05,
        -6.979000e+05,  8.937000e+05, -2.186900e+06,  2.278500e+06,
        -2.809400e+06,  3.292600e+06, -6.058000e+05, -2.534900e+06,
         7.449200e+06,  7.459700e+06,  1.319300e+06,  1.683500e+06,
         2.082210e+07,  5.975200e+06,  7.947900e+06,  2.760000e+07,
        -4.390000e+04,  1.386100e+06,  9.114000e+05, -4.589000e+05,
         9.079000e+05,  8.190200e+06,  8.190200e+06,  8.192200e+06,
         8.190300e+06,  2.004300e+06,  2.003900e+06,  2.013500e+06,
         4.279800e+06,  1.188100e+06, -2.247000e+05,  0.000000e+00,
         6.636000e+05,  7.776000e+05, -1.859100e+06,  7.809000e+05,
         1.058100e+06,  1.058100e+06,  1.793000e+05,  1.793000e+05,
         1.796000e+05,  2.199340e+07,  6.531600e+06,  9.665400e+06,
         1.222500e+07,  1.297990e+07,  3.688100e+06,  9.363300e+06,
         5.488700e+06,  2.981040e+07,  8.158100e+06,  2.981040e+07,
         8.163200e+06,  1.745250e+07,  5.751700e+06, -4.221000e+05,
        -6.596600e+06,  3.205100e+06,  1.244000e+05,  1.131500e+07,
        -3.645600e+06,  2.490600e+06, -5.905000e+05, -1.129800e+06,
        -2.756700e+06,  7.244200e+06, -2.006400e+06, -1.404400e+06,
         1.108200e+06,  9.765500e+06,  1.344120e+07,  1.613880e+07,
         9.973100e+06,  2.230460e+07,  7.361000e+05,  1.724500e+06,
         5.271000e+06, -8.901000e+05,  2.491300e+06,  1.343010e+07,
         4.185900e+06,  7.288800e+06,  2.515000e+06,  9.779300e+06,
         4.155400e+06,  1.286930e+07,  2.232000e+05, -5.223000e+05,
         3.708000e+05,  1.118950e+07,  1.119910e+07,  1.887800e+06,
         4.455000e+06,  1.985780e+07,  2.036534e+08,  9.043000e+05,
         9.054000e+05, -1.606300e+06, -1.607400e+06, -7.188000e+05,
        -1.596800e+06, -3.446000e+06, -1.607400e+06,  1.139100e+06,
         1.139100e+06,  1.139100e+06,  1.139900e+06,  1.406700e+06,
        -1.312500e+06, -1.311600e+06, -1.311800e+06,  1.110000e+05,
         6.228700e+06,  0.000000e+00, -9.463000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -7.873800e+06, -3.894900e+06, -2.751200e+06,
        -3.118900e+06,  1.580300e+06,  1.601300e+06,  5.039500e+06,
         5.050100e+06, -2.226000e+05, -8.340000e+05, -2.312000e+05,
         2.157800e+06, -4.616000e+05, -1.015000e+05, -1.592000e+05,
        -2.047300e+06,  4.069900e+06, -2.530000e+05, -5.090000e+04,
         0.000000e+00,  8.000000e+02, -1.317000e+05,  2.477200e+06,
        -3.592000e+05, -2.741000e+05, -2.728000e+05, -2.728000e+05,
         0.000000e+00,  0.000000e+00,  8.594000e+05, -2.183800e+06,
        -3.881000e+05,  8.726000e+05,  4.633500e+06, -3.322000e+05,
         2.863900e+06,  2.230000e+06, -1.030000e+06, -1.210000e+05,
        -9.624000e+05, -9.626000e+05,  2.758200e+06, -1.464000e+05,
        -4.140000e+04,  1.766100e+06, -1.113900e+06,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.050000e+04, -2.400000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.157800e+06,
        -8.340000e+05, -2.686000e+05, -5.090000e+04, -2.530000e+05,
         1.139100e+06,  1.050000e+04,  7.045000e+06,  8.648000e+05,
         1.793000e+05,  8.190200e+06,  4.279800e+06, -9.024000e+05,
        -7.188000e+05, -1.607400e+06,  9.054000e+05, -1.311800e+06,
        -2.751200e+06, -2.312000e+05, -2.728000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.139100e+06,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.230000e+04,  4.520000e+04,  3.750000e+04,  0.000000e+00,
         6.200000e+03,  3.130000e+04,  6.700000e+03,  1.570000e+04,
         4.520000e+04,  1.640000e+04,  4.510000e+04,  3.940000e+04,
         5.320000e+04, -7.750000e+04,  0.000000e+00,  3.940000e+04,
         2.880000e+04,  3.990000e+04,  6.200000e+03,  1.557000e+05,
         0.000000e+00,  3.430000e+04,  7.960000e+04,  7.280000e+04,
         6.000000e+03,  7.480000e+04,  1.430000e+05,  1.126000e+05,
         8.820000e+04,  2.295000e+05,  3.433000e+05,  2.601000e+05,
        -1.000000e+02, -1.800000e+04, -1.770000e+04, -1.780000e+04,
        -1.800000e+04, -6.710000e+04, -1.780000e+04, -3.401000e+05,
        -2.783000e+05, -2.888000e+05, -4.090000e+04, -2.550000e+04,
        -2.810000e+04,  6.100000e+03, -2.870000e+04, -3.200000e+03,
        -3.200000e+03,  3.100000e+04,  6.490000e+04,  2.820000e+04,
         8.700000e+03,  1.090000e+04,  2.610000e+04,  1.971000e+05,
        -8.040000e+04,  3.580000e+04,  2.930000e+04, -2.790000e+04,
         9.820000e+04,  9.810000e+04,  1.286000e+05,  1.238000e+05,
        -2.950000e+04,  9.200000e+04,  1.950000e+04, -1.350000e+04,
         2.890000e+04,  8.890000e+04,  4.500000e+04, -1.240000e+04,
         6.160000e+04,  7.400000e+04,  7.400000e+04,  7.400000e+04,
         7.400000e+04,  1.047000e+05,  1.047000e+05, -3.950000e+04,
         6.560000e+04,  8.160000e+04,  2.398900e+06,  0.000000e+00,
         2.458200e+06,  2.437900e+06, -4.960000e+04,  6.190000e+04,
         4.300000e+04,  4.300000e+04,  2.930000e+04,  2.930000e+04,
         2.930000e+04,  3.018000e+05,  3.797000e+05,  7.380000e+04,
         2.281600e+06,  4.971100e+06,  5.068700e+06,  7.115000e+06,
         5.133200e+06,  3.185000e+05,  4.261000e+05,  3.185000e+05,
         4.260000e+05,  9.010000e+04, -2.798000e+05, -3.935000e+05,
        -2.185000e+05,  1.910000e+04,  3.440000e+04,  5.897000e+05,
        -6.530000e+04,  4.910000e+04,  6.420000e+04,  2.401900e+06,
        -6.870000e+04, -5.540000e+04, -9.300000e+03, -1.690000e+04,
        -1.698000e+05,  2.411400e+06,  1.726000e+05, -1.410000e+04,
        -1.273000e+05,  9.910000e+04,  6.210000e+04,  5.000000e+04,
        -2.130000e+04,  9.200000e+03,  1.586000e+05,  1.707000e+05,
         2.167000e+05,  5.630000e+04,  1.607000e+05,  2.418200e+06,
         2.165000e+05,  1.720000e+05,  3.930000e+04,  3.680000e+04,
         7.100000e+04,  4.620000e+04,  4.630000e+04,  9.740000e+04,
         2.985000e+05,  2.223000e+05,  9.043000e+05,  2.492100e+06,
         2.485600e+06,  1.230000e+04,  1.230000e+04,  8.200000e+03,
         1.220000e+04, -1.720000e+04,  1.230000e+04,  5.950000e+04,
         5.950000e+04,  5.950000e+04,  5.950000e+04,  6.350000e+04,
         2.207500e+06,  2.205900e+06,  2.206200e+06, -9.480000e+04,
         2.170000e+04,  0.000000e+00,  1.354600e+06,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.324260e+07, -1.092000e+05, -4.850000e+04,
        -4.000000e+03,  1.272000e+05,  1.273000e+05,  3.056000e+05,
         3.056000e+05,  2.422000e+06, -2.790000e+04,  2.000000e+03,
        -1.730000e+04, -6.800000e+03, -5.100000e+03, -3.500000e+03,
        -7.750000e+04,  3.920000e+04, -1.260000e+04,  4.000000e+02,
         0.000000e+00,  0.000000e+00, -5.900000e+03, -1.930000e+04,
        -5.100000e+03, -1.350000e+04, -1.360000e+04, -1.360000e+04,
         0.000000e+00,  0.000000e+00, -9.990000e+04, -8.450000e+04,
        -1.970000e+04, -1.170000e+04, -3.650000e+04, -4.700000e+03,
        -2.200000e+04, -1.790000e+04, -3.950000e+04, -6.300000e+03,
        -2.860000e+04, -2.860000e+04, -2.130000e+04, -6.400000e+03,
        -3.800000e+03, -4.980000e+04, -3.500000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  5.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.000000e+02, -1.730000e+04,
        -2.790000e+04, -1.020000e+04,  4.000000e+02, -1.260000e+04,
         5.950000e+04, -1.000000e+02,  1.230000e+04,  4.520000e+04,
         2.930000e+04,  7.400000e+04,  6.560000e+04, -1.800000e+04,
         8.200000e+03,  1.230000e+04,  2.485600e+06,  2.206300e+06,
        -4.850000e+04,  2.000000e+03, -1.360000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         5.950000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.230000e+04,  4.530000e+04,  3.750000e+04,  0.000000e+00,
         6.200000e+03,  3.130000e+04,  6.700000e+03,  1.570000e+04,
         4.530000e+04,  1.640000e+04,  4.510000e+04,  3.950000e+04,
         5.320000e+04, -7.760000e+04,  0.000000e+00,  3.950000e+04,
         2.880000e+04,  3.990000e+04,  6.200000e+03,  1.559000e+05,
         0.000000e+00,  3.430000e+04,  7.970000e+04,  7.290000e+04,
         6.000000e+03,  7.490000e+04,  1.431000e+05,  1.127000e+05,
         8.830000e+04,  2.298000e+05,  3.438000e+05,  2.604000e+05,
         0.000000e+00, -1.810000e+04, -1.770000e+04, -1.780000e+04,
        -1.800000e+04, -6.720000e+04, -1.780000e+04, -3.404000e+05,
        -2.785000e+05, -2.890000e+05, -4.090000e+04, -2.560000e+04,
        -2.810000e+04,  6.100000e+03, -2.880000e+04, -3.200000e+03,
        -3.200000e+03,  3.090000e+04,  6.500000e+04,  2.830000e+04,
         8.700000e+03,  1.090000e+04,  2.620000e+04,  1.967000e+05,
        -8.050000e+04,  3.580000e+04,  2.940000e+04, -2.800000e+04,
         9.830000e+04,  9.820000e+04,  1.287000e+05,  1.240000e+05,
        -2.960000e+04,  9.220000e+04,  1.960000e+04, -1.350000e+04,
         2.890000e+04,  8.900000e+04,  4.510000e+04, -1.250000e+04,
         6.160000e+04,  7.410000e+04,  7.410000e+04,  7.410000e+04,
         7.410000e+04,  1.049000e+05,  1.048000e+05, -3.960000e+04,
         6.570000e+04,  8.170000e+04,  2.401900e+06,  0.000000e+00,
         2.451500e+06,  2.440900e+06, -4.970000e+04,  6.200000e+04,
         4.300000e+04,  4.300000e+04,  2.930000e+04,  2.930000e+04,
         2.930000e+04,  3.022000e+05,  3.802000e+05,  7.390000e+04,
         2.284300e+06,  4.977400e+06,  5.077400e+06,  7.120600e+06,
         5.120000e+06,  3.190000e+05,  4.265000e+05,  3.190000e+05,
         4.265000e+05,  9.030000e+04, -2.801000e+05, -3.940000e+05,
        -2.187000e+05,  1.920000e+04,  3.440000e+04,  5.904000e+05,
        -6.540000e+04,  4.910000e+04,  6.420000e+04,  2.405700e+06,
        -6.870000e+04, -5.540000e+04, -9.300000e+03, -1.690000e+04,
        -1.700000e+05,  2.415500e+06,  1.729000e+05, -1.410000e+04,
        -1.274000e+05,  9.920000e+04,  6.220000e+04,  5.010000e+04,
        -2.130000e+04,  9.200000e+03,  1.588000e+05,  1.709000e+05,
         2.170000e+05,  5.640000e+04,  1.609000e+05,  2.422500e+06,
         2.168000e+05,  1.721000e+05,  3.940000e+04,  3.680000e+04,
         7.090000e+04,  4.630000e+04,  4.630000e+04,  9.750000e+04,
         2.988000e+05,  2.226000e+05,  9.054000e+05,  2.485600e+06,
         2.489900e+06,  1.230000e+04,  1.230000e+04,  8.200000e+03,
         1.220000e+04, -1.730000e+04,  1.230000e+04,  5.960000e+04,
         5.960000e+04,  5.960000e+04,  5.960000e+04,  6.360000e+04,
         2.209900e+06,  2.208300e+06,  2.208700e+06, -9.500000e+04,
         2.180000e+04,  0.000000e+00,  1.356300e+06,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.325710e+07, -1.094000e+05, -4.860000e+04,
        -4.000000e+03,  1.274000e+05,  1.275000e+05,  3.060000e+05,
         3.059000e+05,  2.426200e+06, -2.800000e+04,  2.000000e+03,
        -1.730000e+04, -6.800000e+03, -5.100000e+03, -3.500000e+03,
        -7.760000e+04,  3.920000e+04, -1.260000e+04,  4.000000e+02,
         0.000000e+00,  0.000000e+00, -5.900000e+03, -1.930000e+04,
        -5.100000e+03, -1.360000e+04, -1.360000e+04, -1.360000e+04,
         0.000000e+00,  0.000000e+00, -1.000000e+05, -8.460000e+04,
        -1.970000e+04, -1.170000e+04, -3.660000e+04, -4.700000e+03,
        -2.200000e+04, -1.790000e+04, -3.960000e+04, -6.300000e+03,
        -2.860000e+04, -2.860000e+04, -2.130000e+04, -6.400000e+03,
        -3.800000e+03, -4.990000e+04, -3.500000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  5.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.000000e+02, -1.730000e+04,
        -2.800000e+04, -1.020000e+04,  4.000000e+02, -1.260000e+04,
         5.960000e+04, -1.000000e+02,  1.230000e+04,  4.530000e+04,
         2.930000e+04,  7.410000e+04,  6.570000e+04, -1.800000e+04,
         8.200000e+03,  1.230000e+04,  2.489900e+06,  2.208700e+06,
        -4.860000e+04,  2.000000e+03, -1.360000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         5.960000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-7.160000e+04,  9.900000e+03,  2.200000e+03,  1.150000e+04,
        -2.990000e+04, -3.179000e+05, -1.747000e+05, -6.730000e+04,
         9.900000e+03, -6.650000e+04,  9.900000e+03, -2.920000e+04,
         8.300000e+03, -9.300000e+03,  0.000000e+00, -2.920000e+04,
         1.140000e+04, -2.880000e+04,  1.000000e+03, -1.175000e+05,
         0.000000e+00, -1.000000e+05,  2.560000e+04,  1.090000e+04,
         2.540000e+04,  3.180000e+04,  3.170000e+04, -9.060000e+04,
         3.540000e+04,  7.191900e+06,  7.169600e+06,  7.276000e+06,
         6.770000e+04,  3.900000e+03,  3.900000e+03,  4.100000e+03,
         3.200000e+03, -5.300000e+03,  3.900000e+03, -1.581000e+05,
         9.100000e+03, -1.020000e+04, -3.890000e+04,  2.200000e+03,
        -1.900000e+03, -1.820000e+04,  2.320000e+04,  2.250000e+04,
         2.250000e+04,  2.570000e+04,  2.890000e+04,  2.060000e+04,
         1.540000e+04,  6.500000e+03,  4.800000e+04,  6.380000e+04,
         1.100000e+03, -1.840000e+04,  2.310000e+04,  2.310000e+04,
        -4.030000e+04, -4.040000e+04,  4.440000e+04,  3.360000e+04,
        -2.384000e+05, -2.900000e+04, -7.900000e+04, -3.088000e+05,
         1.510000e+04,  2.380000e+04,  9.400000e+03, -5.000000e+02,
         1.650000e+04, -6.060000e+04, -6.060000e+04, -6.060000e+04,
        -6.060000e+04,  2.320000e+04,  2.320000e+04, -3.930000e+04,
        -1.890000e+04,  2.230000e+04, -5.000000e+02,  0.000000e+00,
         2.400000e+03,  4.300000e+03,  2.300000e+03,  2.100000e+04,
         6.900000e+03,  6.900000e+03,  1.160000e+04,  1.160000e+04,
         1.160000e+04, -1.163000e+05,  9.250000e+04, -7.420000e+04,
        -1.282000e+05, -7.930000e+04,  4.600000e+04, -1.183000e+05,
         5.300000e+04, -1.993000e+05,  9.390000e+04, -1.993000e+05,
         9.420000e+04, -1.580000e+05, -1.808000e+05, -1.594000e+05,
        -1.280000e+04, -2.660000e+04,  1.480000e+04,  1.304000e+05,
         7.196500e+06,  7.174500e+06,  7.217200e+06,  3.000000e+03,
         6.200000e+03,  7.056000e+06,  7.201000e+06,  7.167000e+06,
         7.078700e+06, -1.116000e+05, -8.000000e+04, -1.842000e+05,
        -1.632000e+05, -2.052000e+05,  2.300000e+04,  7.000000e+02,
        -6.640000e+04,  1.650000e+04,  4.300000e+04, -7.820000e+04,
         4.510000e+04, -5.710000e+04,  4.360000e+04, -1.188000e+05,
         4.790000e+04, -6.570000e+04,  1.640000e+04,  2.700000e+04,
         3.020000e+04, -1.028000e+05, -1.028000e+05,  2.140000e+04,
         3.673400e+06,  3.466200e+06, -1.606300e+06,  1.230000e+04,
         1.230000e+04,  7.212600e+06,  7.206300e+06,  1.550000e+04,
         7.206200e+06,  1.439550e+07,  7.206300e+06,  1.320000e+04,
         1.320000e+04,  1.320000e+04,  1.320000e+04,  9.000000e+03,
        -1.060000e+04, -1.060000e+04, -1.060000e+04, -4.000000e+04,
        -6.010000e+04,  0.000000e+00, -5.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -6.350000e+04,  7.181000e+06,  7.193700e+06,
         4.660000e+04,  4.190000e+04,  4.170000e+04,  8.130000e+04,
         8.120000e+04, -1.000000e+03, -1.400000e+03,  3.300000e+03,
        -3.070000e+04,  3.300000e+03, -1.100000e+03,  3.000000e+02,
        -9.300000e+03, -2.930000e+04, -2.800000e+03,  7.000000e+02,
         0.000000e+00,  0.000000e+00, -2.600000e+03, -3.520000e+04,
         1.700000e+03, -2.800000e+03, -2.900000e+03, -2.900000e+03,
         0.000000e+00,  0.000000e+00, -5.100000e+04, -1.080000e+04,
        -4.300000e+03, -1.460000e+04, -6.580000e+04,  1.500000e+03,
        -4.130000e+04, -3.160000e+04, -4.900000e+03, -1.400000e+03,
         0.000000e+00,  0.000000e+00, -3.900000e+04, -1.100000e+03,
        -1.200000e+03, -3.860000e+04, -1.100000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  2.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -3.070000e+04,
        -1.400000e+03, -1.200000e+03,  7.000000e+02, -2.800000e+03,
         1.320000e+04, -1.000000e+02, -7.160000e+04,  9.900000e+03,
         1.160000e+04, -6.060000e+04, -1.890000e+04,  3.300000e+03,
         1.550000e+04,  7.206300e+06,  1.230000e+04, -1.060000e+04,
         7.193700e+06,  3.300000e+03, -2.900000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.320000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-7.160000e+04,  1.000000e+04,  2.200000e+03,  1.150000e+04,
        -2.990000e+04, -3.181000e+05, -1.749000e+05, -6.740000e+04,
         1.000000e+04, -6.650000e+04,  9.900000e+03, -2.920000e+04,
         8.300000e+03, -9.300000e+03,  0.000000e+00, -2.920000e+04,
         1.140000e+04, -2.880000e+04,  1.000000e+03, -1.176000e+05,
         0.000000e+00, -1.001000e+05,  2.560000e+04,  1.090000e+04,
         2.540000e+04,  3.180000e+04,  3.170000e+04, -9.060000e+04,
         3.540000e+04,  7.196600e+06,  7.174300e+06,  7.280800e+06,
         6.770000e+04,  3.900000e+03,  3.900000e+03,  4.100000e+03,
         3.200000e+03, -5.300000e+03,  3.900000e+03, -1.582000e+05,
         9.100000e+03, -1.020000e+04, -3.890000e+04,  2.200000e+03,
        -1.900000e+03, -1.820000e+04,  2.320000e+04,  2.250000e+04,
         2.250000e+04,  2.570000e+04,  2.890000e+04,  2.060000e+04,
         1.540000e+04,  6.500000e+03,  4.800000e+04,  6.380000e+04,
         1.100000e+03, -1.840000e+04,  2.310000e+04,  2.320000e+04,
        -4.040000e+04, -4.040000e+04,  4.440000e+04,  3.370000e+04,
        -2.386000e+05, -2.910000e+04, -7.910000e+04, -3.090000e+05,
         1.510000e+04,  2.380000e+04,  9.400000e+03, -5.000000e+02,
         1.650000e+04, -6.070000e+04, -6.070000e+04, -6.070000e+04,
        -6.070000e+04,  2.320000e+04,  2.320000e+04, -3.940000e+04,
        -1.900000e+04,  2.230000e+04, -5.000000e+02,  0.000000e+00,
         2.400000e+03,  4.300000e+03,  2.300000e+03,  2.100000e+04,
         6.900000e+03,  6.900000e+03,  1.160000e+04,  1.160000e+04,
         1.160000e+04, -1.164000e+05,  9.260000e+04, -7.430000e+04,
        -1.282000e+05, -7.940000e+04,  4.610000e+04, -1.184000e+05,
         5.300000e+04, -1.994000e+05,  9.400000e+04, -1.994000e+05,
         9.430000e+04, -1.581000e+05, -1.809000e+05, -1.595000e+05,
        -1.280000e+04, -2.660000e+04,  1.480000e+04,  1.305000e+05,
         7.201200e+06,  7.179200e+06,  7.221900e+06,  3.000000e+03,
         6.200000e+03,  7.060700e+06,  7.205800e+06,  7.171700e+06,
         7.083300e+06, -1.117000e+05, -8.010000e+04, -1.843000e+05,
        -1.633000e+05, -2.053000e+05,  2.300000e+04,  7.000000e+02,
        -6.640000e+04,  1.650000e+04,  4.300000e+04, -7.830000e+04,
         4.510000e+04, -5.710000e+04,  4.360000e+04, -1.189000e+05,
         4.790000e+04, -6.570000e+04,  1.640000e+04,  2.710000e+04,
         3.020000e+04, -1.029000e+05, -1.028000e+05,  2.140000e+04,
         3.675900e+06,  3.468500e+06, -1.607400e+06,  1.230000e+04,
         1.230000e+04,  7.206300e+06,  7.211000e+06,  1.560000e+04,
         7.211000e+06,  1.440500e+07,  7.211000e+06,  1.320000e+04,
         1.320000e+04,  1.320000e+04,  1.320000e+04,  9.000000e+03,
        -1.060000e+04, -1.060000e+04, -1.060000e+04, -4.000000e+04,
        -6.010000e+04,  0.000000e+00, -5.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -6.350000e+04,  7.185700e+06,  7.198400e+06,
         4.660000e+04,  4.190000e+04,  4.180000e+04,  8.130000e+04,
         8.130000e+04, -1.000000e+03, -1.400000e+03,  3.300000e+03,
        -3.070000e+04,  3.300000e+03, -1.100000e+03,  3.000000e+02,
        -9.300000e+03, -2.930000e+04, -2.800000e+03,  7.000000e+02,
         0.000000e+00,  0.000000e+00, -2.600000e+03, -3.520000e+04,
         1.700000e+03, -2.800000e+03, -2.900000e+03, -2.900000e+03,
         0.000000e+00,  0.000000e+00, -5.100000e+04, -1.080000e+04,
        -4.300000e+03, -1.460000e+04, -6.590000e+04,  1.500000e+03,
        -4.140000e+04, -3.160000e+04, -4.900000e+03, -1.400000e+03,
         0.000000e+00,  0.000000e+00, -3.900000e+04, -1.100000e+03,
        -1.200000e+03, -3.860000e+04, -1.100000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  2.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -3.070000e+04,
        -1.400000e+03, -1.200000e+03,  7.000000e+02, -2.800000e+03,
         1.320000e+04, -1.000000e+02, -7.160000e+04,  1.000000e+04,
         1.160000e+04, -6.070000e+04, -1.900000e+04,  3.300000e+03,
         1.560000e+04,  7.211000e+06,  1.230000e+04, -1.060000e+04,
         7.198400e+06,  3.300000e+03, -2.900000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.320000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-3.820000e+04, -1.000000e+02,  9.800000e+03,  2.829000e+05,
         1.222000e+05, -1.743000e+05, -9.800000e+04, -3.500000e+04,
        -1.000000e+02, -3.440000e+04,  1.000000e+02, -9.000000e+03,
         7.800000e+03,  3.540000e+05,  0.000000e+00, -9.000000e+03,
         1.531000e+05, -8.800000e+03,  9.000000e+02, -3.530000e+04,
         0.000000e+00,  3.280000e+05,  4.041000e+05,  4.009000e+05,
         8.748000e+05,  4.484000e+05,  1.760000e+04, -2.540000e+04,
         4.641000e+05,  8.009000e+05,  4.371000e+05,  8.416000e+05,
         5.130900e+06,  3.732000e+05,  3.740000e+05,  3.734000e+05,
         3.727000e+05,  4.520000e+05,  3.739000e+05,  3.220500e+06,
         3.325100e+06,  3.317700e+06,  3.453000e+05,  3.698000e+05,
         3.697000e+05,  4.050000e+05,  6.953000e+05,  9.317000e+05,
         9.319000e+05,  7.240000e+05,  5.123000e+05,  7.168000e+05,
         5.650000e+05,  1.629200e+06,  1.654100e+06,  6.148000e+05,
         6.693000e+05,  2.769000e+05,  4.378000e+05,  6.961000e+05,
         7.471000e+05,  7.471000e+05,  7.959000e+05,  7.958000e+05,
        -1.417000e+05,  3.600000e+03, -4.050000e+04, -1.755000e+05,
         1.786000e+05,  1.717000e+05,  1.450000e+04, -1.070000e+04,
         1.270000e+04, -1.800000e+04, -1.800000e+04, -1.800000e+04,
        -1.800000e+04,  1.890000e+04,  1.890000e+04,  3.462000e+05,
         1.498000e+05,  1.683000e+05, -1.000000e+04,  0.000000e+00,
        -2.041000e+05, -1.869000e+05,  5.276000e+05,  3.348000e+05,
         1.280000e+04,  1.280000e+04,  1.546000e+05,  1.545000e+05,
         1.545000e+05,  2.930000e+05,  3.838000e+05,  1.046200e+06,
         6.157000e+05, -2.770000e+04,  2.570000e+04, -9.220000e+04,
        -3.466000e+05, -4.370000e+04,  8.530000e+04, -4.370000e+04,
         8.500000e+04,  6.819000e+05,  1.345600e+06,  1.709600e+06,
         1.424500e+06,  3.649000e+05,  3.897000e+05,  7.210000e+04,
         3.706000e+05,  6.400000e+03,  3.190000e+04,  3.627000e+05,
         9.211000e+05, -7.010000e+04, -1.020000e+04,  2.900000e+03,
         2.941000e+05, -7.940000e+04, -6.800000e+03,  2.701000e+05,
         6.345000e+05, -9.430000e+04,  3.944000e+05,  3.917000e+05,
         7.108000e+05,  7.606000e+05,  4.244000e+05, -7.700000e+03,
         6.570000e+04,  3.562000e+05,  4.304000e+05, -7.530000e+04,
         4.720000e+04, -2.420000e+04,  3.842000e+05,  7.339000e+05,
         5.261000e+05, -4.870000e+04, -4.870000e+04,  9.200000e+03,
         3.661000e+05,  2.418000e+05, -7.188000e+05,  8.200000e+03,
         8.200000e+03,  1.550000e+04,  1.560000e+04,  5.749000e+05,
         1.550000e+04, -3.618000e+05,  1.560000e+04,  1.890000e+04,
         1.890000e+04,  1.890000e+04,  1.890000e+04,  1.680000e+04,
        -2.230000e+04, -2.220000e+04, -2.220000e+04,  3.331000e+05,
        -2.990000e+04,  0.000000e+00, -1.550000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.335000e+05, -2.390000e+04, -4.200000e+03,
         1.853000e+06,  6.095000e+05,  6.059000e+05,  6.625000e+05,
         6.624000e+05, -1.080000e+04,  1.223000e+05, -6.200000e+03,
        -2.090000e+04, -6.500000e+03, -5.900000e+03, -1.000000e+02,
         3.540000e+05, -8.900000e+03, -1.770000e+04,  5.000000e+02,
         0.000000e+00,  0.000000e+00, -8.000000e+03, -3.420000e+04,
        -8.900000e+03, -4.400000e+03, -4.400000e+03, -4.400000e+03,
         0.000000e+00,  0.000000e+00,  3.272000e+05,  3.518000e+05,
        -2.240000e+04, -1.340000e+04, -5.520000e+04, -8.200000e+03,
        -2.650000e+04, -2.170000e+04,  1.748000e+05, -8.900000e+03,
         1.292000e+05,  1.292000e+05, -2.970000e+04, -5.900000e+03,
        -1.900000e+03,  1.004000e+05,  1.234000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02, -1.100000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.090000e+04,
         1.223000e+05,  4.640000e+04,  5.000000e+02, -1.770000e+04,
         1.890000e+04, -1.000000e+02, -3.820000e+04, -1.000000e+02,
         1.545000e+05, -1.800000e+04,  1.498000e+05,  3.727000e+05,
         5.749000e+05,  1.560000e+04,  8.200000e+03, -2.220000e+04,
        -4.200000e+03, -6.200000e+03, -4.400000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.890000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-7.170000e+04,  9.900000e+03,  2.100000e+03,  1.150000e+04,
        -2.990000e+04, -3.181000e+05, -1.747000e+05, -6.750000e+04,
         9.900000e+03, -6.660000e+04,  9.900000e+03, -2.930000e+04,
         8.200000e+03, -9.300000e+03,  0.000000e+00, -2.930000e+04,
         1.140000e+04, -2.890000e+04,  1.000000e+03, -1.179000e+05,
         0.000000e+00, -1.003000e+05,  2.540000e+04,  1.080000e+04,
         2.540000e+04,  3.180000e+04,  3.150000e+04, -9.090000e+04,
         3.540000e+04,  7.196100e+06,  7.173700e+06,  7.280300e+06,
         6.930000e+04,  3.800000e+03,  3.900000e+03,  4.000000e+03,
         3.200000e+03, -5.400000e+03,  4.200000e+03, -1.580000e+05,
         9.400000e+03, -9.800000e+03, -3.850000e+04,  2.600000e+03,
        -1.500000e+03, -1.820000e+04,  2.330000e+04,  2.260000e+04,
         2.260000e+04,  2.580000e+04,  2.900000e+04,  2.070000e+04,
         1.620000e+04,  7.800000e+03,  4.930000e+04,  6.520000e+04,
         1.100000e+03, -1.850000e+04,  2.310000e+04,  2.320000e+04,
        -4.070000e+04, -4.040000e+04,  4.410000e+04,  3.340000e+04,
        -2.375000e+05, -2.880000e+04, -7.870000e+04, -3.085000e+05,
         1.510000e+04,  2.380000e+04,  9.400000e+03, -5.000000e+02,
         1.650000e+04, -6.080000e+04, -6.080000e+04, -6.080000e+04,
        -6.080000e+04,  2.310000e+04,  2.310000e+04, -3.950000e+04,
        -1.900000e+04,  2.230000e+04, -5.000000e+02,  0.000000e+00,
         2.400000e+03,  4.300000e+03,  2.300000e+03,  2.090000e+04,
         6.900000e+03,  6.900000e+03,  1.150000e+04,  1.150000e+04,
         1.150000e+04, -1.164000e+05,  9.270000e+04, -7.420000e+04,
        -1.281000e+05, -7.930000e+04,  4.620000e+04, -1.182000e+05,
         5.320000e+04, -1.996000e+05,  9.400000e+04, -1.996000e+05,
         9.430000e+04, -1.582000e+05, -1.812000e+05, -1.598000e+05,
        -1.300000e+04, -2.590000e+04,  1.560000e+04,  1.321000e+05,
         7.201600e+06,  7.179500e+06,  7.222200e+06,  3.300000e+03,
         6.500000e+03,  7.061000e+06,  7.206100e+06,  7.172100e+06,
         7.083700e+06, -1.114000e+05, -7.990000e+04, -1.829000e+05,
        -1.618000e+05, -2.039000e+05,  2.460000e+04,  2.300000e+03,
        -6.490000e+04,  1.810000e+04,  4.320000e+04, -7.810000e+04,
         4.530000e+04, -5.690000e+04,  4.380000e+04, -1.186000e+05,
         4.820000e+04, -6.560000e+04,  1.720000e+04,  2.740000e+04,
         3.060000e+04, -1.022000e+05, -1.022000e+05,  2.220000e+04,
         3.678200e+06,  3.470700e+06, -1.596800e+06,  1.220000e+04,
         1.220000e+04,  7.206200e+06,  7.211000e+06,  1.550000e+04,
         7.281700e+06,  1.440500e+07,  7.211000e+06,  1.320000e+04,
         1.320000e+04,  1.320000e+04,  1.310000e+04,  8.900000e+03,
        -1.060000e+04, -1.060000e+04, -1.060000e+04, -4.000000e+04,
        -6.020000e+04,  0.000000e+00, -5.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -6.340000e+04,  7.185700e+06,  7.198400e+06,
         4.640000e+04,  4.260000e+04,  4.330000e+04,  8.360000e+04,
         8.400000e+04, -6.000000e+02, -1.400000e+03,  3.300000e+03,
        -3.070000e+04,  3.300000e+03, -1.100000e+03,  3.000000e+02,
        -9.300000e+03, -2.940000e+04, -2.800000e+03,  7.000000e+02,
         0.000000e+00,  0.000000e+00, -2.600000e+03, -3.520000e+04,
         1.700000e+03, -2.800000e+03, -2.800000e+03, -2.800000e+03,
         0.000000e+00,  0.000000e+00, -5.110000e+04, -1.090000e+04,
        -4.300000e+03, -1.460000e+04, -6.590000e+04,  1.500000e+03,
        -4.140000e+04, -3.120000e+04, -4.700000e+03, -1.200000e+03,
         0.000000e+00,  0.000000e+00, -3.900000e+04, -1.100000e+03,
        -1.200000e+03, -3.860000e+04, -1.000000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  4.000000e+02,  2.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -3.070000e+04,
        -1.400000e+03, -1.200000e+03,  7.000000e+02, -2.800000e+03,
         1.320000e+04,  4.000000e+02, -7.170000e+04,  9.900000e+03,
         1.150000e+04, -6.080000e+04, -1.900000e+04,  3.200000e+03,
         1.550000e+04,  7.211000e+06,  1.220000e+04, -1.060000e+04,
         7.198400e+06,  3.300000e+03, -2.800000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.320000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-1.326000e+05, -1.180000e+04, -2.530000e+04,  7.660000e+04,
        -2.780000e+04, -5.708000e+05, -3.057000e+05, -1.273000e+05,
        -1.180000e+04, -1.262000e+05, -1.170000e+04, -7.880000e+04,
        -2.240000e+04, -3.690000e+05,  0.000000e+00, -7.880000e+04,
         2.560000e+04, -7.840000e+04, -2.500000e+03, -3.156000e+05,
         0.000000e+00, -6.072000e+05, -4.201000e+05, -4.462000e+05,
        -2.803000e+05,  9.110000e+04, -4.400000e+04, -2.383000e+05,
         8.050000e+04,  1.338560e+07,  1.367150e+07,  1.350970e+07,
        -1.561800e+06, -3.934000e+05, -3.946000e+05, -3.927000e+05,
        -3.942000e+05, -4.738000e+05, -3.946000e+05, -3.728000e+06,
        -3.482000e+06, -3.513500e+06, -4.482000e+05, -3.851000e+05,
        -3.946000e+05,  4.930000e+04,  2.037000e+05, -5.161000e+05,
        -5.161000e+05, -3.285000e+05, -1.421000e+05, -3.356000e+05,
        -3.629000e+05, -9.042000e+05, -8.414000e+05,  9.640000e+04,
        -2.857000e+05, -1.600000e+03,  1.033000e+05,  2.031000e+05,
        -9.695000e+05, -9.695000e+05, -8.443000e+05, -8.622000e+05,
        -3.872000e+05, -1.190000e+05, -1.503000e+05, -5.184000e+05,
         3.240000e+04,  3.000000e+02, -1.910000e+04,  6.700000e+03,
        -2.230000e+04, -1.595000e+05, -1.595000e+05, -1.595000e+05,
        -1.595000e+05, -3.590000e+04, -3.590000e+04, -4.474000e+05,
        -5.290000e+04,  8.100000e+03,  7.500000e+03,  0.000000e+00,
         1.963000e+05,  1.920000e+05, -3.392000e+05, -2.035000e+05,
        -2.170000e+04, -2.170000e+04,  2.650000e+04,  2.650000e+04,
         2.650000e+04, -3.700000e+05, -6.170000e+04, -9.450000e+05,
        -5.684000e+05, -2.488000e+05, -6.420000e+04, -1.672000e+05,
         3.173000e+05, -5.826000e+05, -1.498000e+05, -5.826000e+05,
        -1.496000e+05, -1.160000e+06, -1.737500e+06, -2.025300e+06,
        -1.489500e+06, -4.744000e+05, -4.116000e+05, -1.806000e+05,
         1.403510e+07,  1.432300e+07,  1.438710e+07, -3.868000e+05,
        -7.326000e+05,  1.419840e+07,  1.442320e+07,  1.435930e+07,
         1.391190e+07, -1.758000e+05, -2.662000e+05, -7.139000e+05,
        -1.002400e+06, -4.254000e+05, -4.002000e+05, -4.457000e+05,
        -9.246000e+05, -7.992000e+05, -4.596000e+05, -2.638000e+05,
        -7.460000e+04, -5.542000e+05, -4.658000e+05, -1.847000e+05,
        -7.780000e+04, -2.516000e+05, -4.092000e+05, -3.330000e+05,
        -1.454000e+05, -2.120000e+05, -2.120000e+05, -2.970000e+04,
         6.801900e+06,  6.488100e+06, -3.446000e+06, -1.720000e+04,
        -1.730000e+04,  1.439550e+07,  1.440500e+07, -3.618000e+05,
         1.440500e+07,  3.840350e+07,  1.899170e+07, -2.410000e+04,
        -2.410000e+04, -2.410000e+04, -2.550000e+04, -3.040000e+04,
         3.440000e+04,  3.430000e+04,  3.430000e+04, -4.083000e+05,
        -1.183000e+05,  0.000000e+00,  2.200000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.062000e+05,  1.445440e+07,  1.442970e+07,
        -1.035700e+06, -4.103000e+05, -4.107000e+05, -4.829000e+05,
        -4.829000e+05,  6.800000e+03,  4.570000e+04,  1.800000e+03,
        -3.940000e+04,  1.270000e+04,  4.600000e+03,  3.300000e+03,
        -3.690000e+05, -7.890000e+04,  1.050000e+04,  9.000000e+02,
         0.000000e+00,  0.000000e+00, -1.000000e+02, -4.810000e+04,
         8.600000e+03,  5.700000e+03,  5.700000e+03,  5.700000e+03,
         0.000000e+00,  0.000000e+00, -4.209000e+05, -3.618000e+05,
         1.760000e+04, -1.380000e+04, -8.740000e+04,  7.900000e+03,
        -5.180000e+04, -4.040000e+04, -1.821000e+05,  5.300000e+03,
         4.980000e+04,  4.980000e+04, -5.110000e+04,  6.800000e+03,
         8.000000e+02, -7.000000e+02,  5.670000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -3.940000e+04,
         4.570000e+04, -4.840000e+04,  9.000000e+02,  1.050000e+04,
        -2.410000e+04,  0.000000e+00, -1.326000e+05, -1.180000e+04,
         2.650000e+04, -1.595000e+05, -5.290000e+04, -3.941000e+05,
        -3.618000e+05,  1.440500e+07, -1.730000e+04,  3.430000e+04,
         1.442970e+07,  1.800000e+03,  5.700000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -2.410000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-7.160000e+04,  1.000000e+04,  2.200000e+03,  1.150000e+04,
        -2.990000e+04, -3.181000e+05, -1.749000e+05, -6.740000e+04,
         1.000000e+04, -6.650000e+04,  9.900000e+03, -2.920000e+04,
         8.300000e+03, -9.300000e+03,  0.000000e+00, -2.920000e+04,
         1.140000e+04, -2.880000e+04,  1.000000e+03, -1.176000e+05,
         0.000000e+00, -1.001000e+05,  2.560000e+04,  1.090000e+04,
         2.540000e+04,  3.180000e+04,  3.170000e+04, -9.060000e+04,
         3.540000e+04,  7.196600e+06,  7.174300e+06,  7.280800e+06,
         6.770000e+04,  3.900000e+03,  3.900000e+03,  4.100000e+03,
         3.200000e+03, -5.300000e+03,  3.900000e+03, -1.582000e+05,
         9.100000e+03, -1.020000e+04, -3.890000e+04,  2.200000e+03,
        -1.900000e+03, -1.820000e+04,  2.320000e+04,  2.250000e+04,
         2.250000e+04,  2.570000e+04,  2.890000e+04,  2.060000e+04,
         1.540000e+04,  6.500000e+03,  4.800000e+04,  6.380000e+04,
         1.100000e+03, -1.840000e+04,  2.310000e+04,  2.320000e+04,
        -4.040000e+04, -4.040000e+04,  4.440000e+04,  3.370000e+04,
        -2.386000e+05, -2.910000e+04, -7.910000e+04, -3.090000e+05,
         1.510000e+04,  2.380000e+04,  9.400000e+03, -5.000000e+02,
         1.650000e+04, -6.070000e+04, -6.070000e+04, -6.070000e+04,
        -6.070000e+04,  2.320000e+04,  2.320000e+04, -3.940000e+04,
        -1.900000e+04,  2.230000e+04, -5.000000e+02,  0.000000e+00,
         2.400000e+03,  4.300000e+03,  2.300000e+03,  2.100000e+04,
         6.900000e+03,  6.900000e+03,  1.160000e+04,  1.160000e+04,
         1.160000e+04, -1.164000e+05,  9.260000e+04, -7.430000e+04,
        -1.282000e+05, -7.940000e+04,  4.610000e+04, -1.184000e+05,
         5.300000e+04, -1.994000e+05,  9.400000e+04, -1.994000e+05,
         9.430000e+04, -1.581000e+05, -1.809000e+05, -1.595000e+05,
        -1.280000e+04, -2.660000e+04,  1.480000e+04,  1.305000e+05,
         7.201200e+06,  7.179200e+06,  7.221900e+06,  3.000000e+03,
         6.200000e+03,  7.060700e+06,  7.205800e+06,  7.171700e+06,
         7.083300e+06, -1.117000e+05, -8.010000e+04, -1.843000e+05,
        -1.633000e+05, -2.053000e+05,  2.300000e+04,  7.000000e+02,
        -6.640000e+04,  1.650000e+04,  4.300000e+04, -7.830000e+04,
         4.510000e+04, -5.710000e+04,  4.360000e+04, -1.189000e+05,
         4.790000e+04, -6.570000e+04,  1.640000e+04,  2.710000e+04,
         3.020000e+04, -1.029000e+05, -1.028000e+05,  2.140000e+04,
         3.675900e+06,  3.468500e+06, -1.607400e+06,  1.230000e+04,
         1.230000e+04,  7.206300e+06,  7.211000e+06,  1.560000e+04,
         7.211000e+06,  1.899170e+07,  2.557660e+07,  1.320000e+04,
         1.320000e+04,  1.320000e+04,  1.320000e+04,  9.000000e+03,
        -1.060000e+04, -1.060000e+04, -1.060000e+04, -4.000000e+04,
        -6.010000e+04,  0.000000e+00, -5.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -6.350000e+04,  7.185700e+06,  7.198400e+06,
         4.660000e+04,  4.190000e+04,  4.180000e+04,  8.130000e+04,
         8.130000e+04, -1.000000e+03, -1.400000e+03,  3.300000e+03,
        -3.070000e+04,  3.300000e+03, -1.100000e+03,  3.000000e+02,
        -9.300000e+03, -2.930000e+04, -2.800000e+03,  7.000000e+02,
         0.000000e+00,  0.000000e+00, -2.600000e+03, -3.520000e+04,
         1.700000e+03, -2.800000e+03, -2.900000e+03, -2.900000e+03,
         0.000000e+00,  0.000000e+00, -5.100000e+04, -1.080000e+04,
        -4.300000e+03, -1.460000e+04, -6.590000e+04,  1.500000e+03,
        -4.140000e+04, -3.160000e+04, -4.900000e+03, -1.400000e+03,
         0.000000e+00,  0.000000e+00, -3.900000e+04, -1.100000e+03,
        -1.200000e+03, -3.860000e+04, -1.100000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  2.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -3.070000e+04,
        -1.400000e+03, -1.200000e+03,  7.000000e+02, -2.800000e+03,
         1.320000e+04, -1.000000e+02, -7.160000e+04,  1.000000e+04,
         1.160000e+04, -6.070000e+04, -1.900000e+04,  3.300000e+03,
         1.560000e+04,  7.211000e+06,  1.230000e+04, -1.060000e+04,
         7.198400e+06,  3.300000e+03, -2.900000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.320000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 2.010000e+04,  5.080000e+04,  4.250000e+04,  6.600000e+03,
         1.340000e+04,  6.320000e+04,  2.310000e+04,  2.250000e+04,
         5.070000e+04,  2.310000e+04,  5.060000e+04,  4.350000e+04,
         5.690000e+04, -8.380000e+04,  0.000000e+00,  4.350000e+04,
         3.610000e+04,  4.370000e+04,  6.600000e+03,  1.736000e+05,
         0.000000e+00,  4.500000e+04,  9.390000e+04,  7.980000e+04,
         2.300000e+04,  9.230000e+04,  1.610000e+05,  1.289000e+05,
         1.076000e+05,  2.677000e+05,  3.943000e+05,  3.000000e+05,
         9.870000e+04, -1.670000e+04, -1.670000e+04, -1.660000e+04,
        -1.700000e+04, -7.130000e+04, -1.670000e+04, -3.475000e+05,
        -2.829000e+05, -3.012000e+05, -4.040000e+04, -2.500000e+04,
        -2.880000e+04,  2.000000e+04, -1.560000e+04,  1.260000e+04,
         1.260000e+04,  4.730000e+04,  8.200000e+04,  4.190000e+04,
         1.890000e+04,  4.320000e+04,  5.900000e+04,  2.324000e+05,
        -7.910000e+04,  4.910000e+04,  4.230000e+04, -1.510000e+04,
         1.199000e+05,  1.199000e+05,  1.525000e+05,  1.431000e+05,
        -1.140000e+04,  1.029000e+05,  2.810000e+04,  1.060000e+04,
         3.760000e+04,  1.031000e+05,  5.080000e+04, -1.470000e+04,
         6.900000e+04,  8.580000e+04,  8.580000e+04,  8.580000e+04,
         8.580000e+04,  1.180000e+05,  1.180000e+05, -4.070000e+04,
         7.810000e+04,  9.380000e+04, -6.900000e+03,  0.000000e+00,
         2.720000e+04,  3.510000e+04, -4.820000e+04,  7.660000e+04,
         4.870000e+04,  4.870000e+04,  3.570000e+04,  3.570000e+04,
         3.570000e+04,  3.516000e+05,  4.318000e+05,  9.840000e+04,
         2.430000e+04,  1.813000e+05,  2.288000e+05, -2.500000e+04,
         2.994000e+05,  3.669000e+05,  4.795000e+05,  3.669000e+05,
         4.801000e+05,  1.140000e+05, -2.949000e+05, -4.213000e+05,
        -2.304000e+05,  2.600000e+04,  4.170000e+04,  6.642000e+05,
        -7.080000e+04,  5.600000e+04,  7.230000e+04, -2.420000e+04,
        -6.500000e+04, -5.960000e+04, -1.150000e+04, -2.490000e+04,
        -1.864000e+05, -8.900000e+03,  1.944000e+05, -1.500000e+03,
        -1.282000e+05,  1.252000e+05,  7.750000e+04,  5.640000e+04,
        -1.530000e+04,  1.630000e+04,  1.829000e+05,  1.951000e+05,
         2.413000e+05,  6.860000e+04,  1.851000e+05, -1.420000e+04,
         2.442000e+05,  2.034000e+05,  4.820000e+04,  5.450000e+04,
         8.920000e+04,  6.050000e+04,  6.050000e+04,  1.096000e+05,
         3.398000e+05,  2.609000e+05,  1.139100e+06,  5.950000e+04,
         5.960000e+04,  1.320000e+04,  1.320000e+04,  1.890000e+04,
         1.320000e+04, -2.410000e+04,  1.320000e+04,  6.720000e+04,
         6.720000e+04,  6.720000e+04,  6.720000e+04,  6.450000e+04,
        -6.880000e+04, -6.870000e+04, -6.870000e+04, -1.004000e+05,
         2.680000e+04,  0.000000e+00, -4.140000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -4.126000e+05, -1.195000e+05, -5.310000e+04,
         2.810000e+04,  1.533000e+05,  1.533000e+05,  3.549000e+05,
         3.548000e+05, -7.700000e+03, -2.830000e+04,  1.700000e+03,
        -1.660000e+04, -5.300000e+03, -5.900000e+03, -4.000000e+03,
        -8.380000e+04,  4.340000e+04, -1.460000e+04,  4.000000e+02,
         0.000000e+00,  0.000000e+00, -8.800000e+03, -1.910000e+04,
        -6.100000e+03, -1.530000e+04, -1.530000e+04, -1.530000e+04,
         0.000000e+00,  0.000000e+00, -1.068000e+05, -9.180000e+04,
        -2.250000e+04, -1.220000e+04, -3.570000e+04, -5.700000e+03,
        -2.280000e+04, -1.710000e+04, -4.280000e+04, -7.300000e+03,
        -2.870000e+04, -2.870000e+04, -2.080000e+04, -7.200000e+03,
        -4.300000e+03, -4.940000e+04, -3.590000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  5.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.660000e+04,
        -2.830000e+04, -1.100000e+04,  4.000000e+02, -1.460000e+04,
         6.720000e+04, -1.000000e+02,  2.010000e+04,  5.080000e+04,
         3.570000e+04,  8.580000e+04,  7.810000e+04, -1.690000e+04,
         1.890000e+04,  1.320000e+04,  5.960000e+04, -6.870000e+04,
        -5.310000e+04,  1.700000e+03, -1.530000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         6.720000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 2.010000e+04,  5.080000e+04,  4.250000e+04,  6.600000e+03,
         1.340000e+04,  6.330000e+04,  2.310000e+04,  2.250000e+04,
         5.070000e+04,  2.310000e+04,  5.060000e+04,  4.350000e+04,
         5.690000e+04, -8.380000e+04,  0.000000e+00,  4.350000e+04,
         3.610000e+04,  4.370000e+04,  6.600000e+03,  1.736000e+05,
         0.000000e+00,  4.500000e+04,  9.390000e+04,  7.980000e+04,
         2.300000e+04,  9.230000e+04,  1.610000e+05,  1.289000e+05,
         1.076000e+05,  2.676000e+05,  3.943000e+05,  2.999000e+05,
         9.870000e+04, -1.670000e+04, -1.670000e+04, -1.660000e+04,
        -1.700000e+04, -7.130000e+04, -1.670000e+04, -3.475000e+05,
        -2.829000e+05, -3.012000e+05, -4.040000e+04, -2.500000e+04,
        -2.880000e+04,  2.000000e+04, -1.560000e+04,  1.260000e+04,
         1.260000e+04,  4.730000e+04,  8.200000e+04,  4.190000e+04,
         1.890000e+04,  4.320000e+04,  5.900000e+04,  2.324000e+05,
        -7.910000e+04,  4.910000e+04,  4.230000e+04, -1.510000e+04,
         1.199000e+05,  1.199000e+05,  1.525000e+05,  1.431000e+05,
        -1.140000e+04,  1.029000e+05,  2.810000e+04,  1.060000e+04,
         3.760000e+04,  1.031000e+05,  5.090000e+04, -1.460000e+04,
         6.900000e+04,  8.580000e+04,  8.580000e+04,  8.580000e+04,
         8.580000e+04,  1.180000e+05,  1.180000e+05, -4.070000e+04,
         7.810000e+04,  9.380000e+04, -6.900000e+03,  0.000000e+00,
         2.720000e+04,  3.510000e+04, -4.820000e+04,  7.660000e+04,
         4.870000e+04,  4.870000e+04,  3.570000e+04,  3.570000e+04,
         3.570000e+04,  3.516000e+05,  4.317000e+05,  9.840000e+04,
         2.430000e+04,  1.813000e+05,  2.288000e+05, -2.500000e+04,
         2.994000e+05,  3.669000e+05,  4.795000e+05,  3.669000e+05,
         4.801000e+05,  1.140000e+05, -2.949000e+05, -4.213000e+05,
        -2.304000e+05,  2.600000e+04,  4.170000e+04,  6.642000e+05,
        -7.080000e+04,  5.600000e+04,  7.230000e+04, -2.420000e+04,
        -6.500000e+04, -5.960000e+04, -1.150000e+04, -2.490000e+04,
        -1.864000e+05, -8.900000e+03,  1.944000e+05, -1.500000e+03,
        -1.282000e+05,  1.252000e+05,  7.750000e+04,  5.640000e+04,
        -1.530000e+04,  1.630000e+04,  1.829000e+05,  1.951000e+05,
         2.413000e+05,  6.860000e+04,  1.850000e+05, -1.420000e+04,
         2.442000e+05,  2.034000e+05,  4.820000e+04,  5.450000e+04,
         8.920000e+04,  6.050000e+04,  6.050000e+04,  1.096000e+05,
         3.398000e+05,  2.609000e+05,  1.139100e+06,  5.950000e+04,
         5.960000e+04,  1.320000e+04,  1.320000e+04,  1.890000e+04,
         1.320000e+04, -2.410000e+04,  1.320000e+04,  6.720000e+04,
         6.740000e+04,  6.740000e+04,  6.720000e+04,  6.450000e+04,
        -6.880000e+04, -6.870000e+04, -6.870000e+04, -1.004000e+05,
         2.680000e+04,  0.000000e+00, -4.140000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -4.126000e+05, -1.195000e+05, -5.310000e+04,
         2.810000e+04,  1.533000e+05,  1.533000e+05,  3.549000e+05,
         3.548000e+05, -7.700000e+03, -2.830000e+04,  1.700000e+03,
        -1.660000e+04, -5.300000e+03, -5.900000e+03, -4.000000e+03,
        -8.380000e+04,  4.340000e+04, -1.460000e+04,  4.000000e+02,
         0.000000e+00,  0.000000e+00, -8.800000e+03, -1.910000e+04,
        -6.100000e+03, -1.530000e+04, -1.530000e+04, -1.530000e+04,
         0.000000e+00,  0.000000e+00, -1.068000e+05, -9.180000e+04,
        -2.250000e+04, -1.220000e+04, -3.570000e+04, -5.700000e+03,
        -2.280000e+04, -1.710000e+04, -4.280000e+04, -7.300000e+03,
        -2.870000e+04, -2.870000e+04, -2.080000e+04, -7.200000e+03,
        -4.300000e+03, -4.940000e+04, -3.590000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  5.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.660000e+04,
        -2.830000e+04, -1.100000e+04,  4.000000e+02, -1.460000e+04,
         6.730000e+04, -1.000000e+02,  2.010000e+04,  5.080000e+04,
         3.570000e+04,  8.580000e+04,  7.810000e+04, -1.690000e+04,
         1.890000e+04,  1.320000e+04,  5.960000e+04, -6.870000e+04,
        -5.310000e+04,  1.700000e+03, -1.530000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         6.720000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 2.010000e+04,  5.080000e+04,  4.250000e+04,  6.600000e+03,
         1.340000e+04,  6.330000e+04,  2.310000e+04,  2.250000e+04,
         5.070000e+04,  2.310000e+04,  5.060000e+04,  4.350000e+04,
         5.690000e+04, -8.380000e+04,  0.000000e+00,  4.350000e+04,
         3.610000e+04,  4.370000e+04,  6.600000e+03,  1.736000e+05,
         0.000000e+00,  4.500000e+04,  9.390000e+04,  7.980000e+04,
         2.300000e+04,  9.230000e+04,  1.610000e+05,  1.289000e+05,
         1.076000e+05,  2.676000e+05,  3.943000e+05,  2.999000e+05,
         9.870000e+04, -1.670000e+04, -1.670000e+04, -1.660000e+04,
        -1.700000e+04, -7.130000e+04, -1.670000e+04, -3.475000e+05,
        -2.829000e+05, -3.012000e+05, -4.040000e+04, -2.500000e+04,
        -2.880000e+04,  2.000000e+04, -1.560000e+04,  1.260000e+04,
         1.260000e+04,  4.730000e+04,  8.200000e+04,  4.190000e+04,
         1.890000e+04,  4.320000e+04,  5.900000e+04,  2.324000e+05,
        -7.910000e+04,  4.910000e+04,  4.230000e+04, -1.510000e+04,
         1.199000e+05,  1.199000e+05,  1.525000e+05,  1.431000e+05,
        -1.140000e+04,  1.029000e+05,  2.810000e+04,  1.060000e+04,
         3.760000e+04,  1.031000e+05,  5.090000e+04, -1.460000e+04,
         6.900000e+04,  8.580000e+04,  8.580000e+04,  8.580000e+04,
         8.580000e+04,  1.180000e+05,  1.180000e+05, -4.070000e+04,
         7.810000e+04,  9.380000e+04, -6.900000e+03,  0.000000e+00,
         2.720000e+04,  3.510000e+04, -4.820000e+04,  7.660000e+04,
         4.870000e+04,  4.870000e+04,  3.570000e+04,  3.570000e+04,
         3.570000e+04,  3.516000e+05,  4.317000e+05,  9.840000e+04,
         2.430000e+04,  1.813000e+05,  2.288000e+05, -2.500000e+04,
         2.994000e+05,  3.669000e+05,  4.795000e+05,  3.669000e+05,
         4.801000e+05,  1.140000e+05, -2.949000e+05, -4.213000e+05,
        -2.304000e+05,  2.600000e+04,  4.170000e+04,  6.642000e+05,
        -7.080000e+04,  5.600000e+04,  7.230000e+04, -2.420000e+04,
        -6.500000e+04, -5.960000e+04, -1.150000e+04, -2.490000e+04,
        -1.864000e+05, -8.900000e+03,  1.944000e+05, -1.500000e+03,
        -1.282000e+05,  1.252000e+05,  7.750000e+04,  5.640000e+04,
        -1.530000e+04,  1.630000e+04,  1.829000e+05,  1.951000e+05,
         2.413000e+05,  6.860000e+04,  1.850000e+05, -1.420000e+04,
         2.442000e+05,  2.034000e+05,  4.820000e+04,  5.450000e+04,
         8.920000e+04,  6.050000e+04,  6.050000e+04,  1.096000e+05,
         3.398000e+05,  2.609000e+05,  1.139100e+06,  5.950000e+04,
         5.960000e+04,  1.320000e+04,  1.320000e+04,  1.890000e+04,
         1.320000e+04, -2.410000e+04,  1.320000e+04,  6.720000e+04,
         6.740000e+04,  6.740000e+04,  6.720000e+04,  6.450000e+04,
        -6.880000e+04, -6.870000e+04, -6.870000e+04, -1.004000e+05,
         2.680000e+04,  0.000000e+00, -4.140000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -4.126000e+05, -1.195000e+05, -5.310000e+04,
         2.810000e+04,  1.533000e+05,  1.533000e+05,  3.549000e+05,
         3.548000e+05, -7.700000e+03, -2.830000e+04,  1.700000e+03,
        -1.660000e+04, -5.300000e+03, -5.900000e+03, -4.000000e+03,
        -8.380000e+04,  4.340000e+04, -1.460000e+04,  4.000000e+02,
         0.000000e+00,  0.000000e+00, -8.800000e+03, -1.910000e+04,
        -6.100000e+03, -1.530000e+04, -1.530000e+04, -1.530000e+04,
         0.000000e+00,  0.000000e+00, -1.068000e+05, -9.180000e+04,
        -2.250000e+04, -1.220000e+04, -3.570000e+04, -5.700000e+03,
        -2.280000e+04, -1.710000e+04, -4.280000e+04, -7.300000e+03,
        -2.870000e+04, -2.870000e+04, -2.080000e+04, -7.200000e+03,
        -4.300000e+03, -4.940000e+04, -3.590000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  5.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.660000e+04,
        -2.830000e+04, -1.100000e+04,  4.000000e+02, -1.460000e+04,
         6.730000e+04, -1.000000e+02,  2.010000e+04,  5.080000e+04,
         3.570000e+04,  8.580000e+04,  7.810000e+04, -1.690000e+04,
         1.890000e+04,  1.320000e+04,  5.960000e+04, -6.870000e+04,
        -5.310000e+04,  1.700000e+03, -1.530000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         6.720000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 2.010000e+04,  5.070000e+04,  4.250000e+04,  6.500000e+03,
         1.340000e+04,  6.330000e+04,  2.310000e+04,  2.260000e+04,
         5.070000e+04,  2.320000e+04,  5.050000e+04,  4.380000e+04,
         5.700000e+04, -8.380000e+04,  0.000000e+00,  4.380000e+04,
         3.600000e+04,  4.410000e+04,  6.600000e+03,  1.745000e+05,
         0.000000e+00,  4.510000e+04,  9.380000e+04,  7.980000e+04,
         2.300000e+04,  9.220000e+04,  1.631000e+05,  1.290000e+05,
         1.075000e+05,  2.675000e+05,  3.941000e+05,  2.996000e+05,
         9.880000e+04, -1.670000e+04, -1.670000e+04, -1.660000e+04,
        -1.700000e+04, -7.130000e+04, -1.670000e+04, -3.472000e+05,
        -2.828000e+05, -3.009000e+05, -4.030000e+04, -2.500000e+04,
        -2.880000e+04,  1.990000e+04, -1.560000e+04,  1.260000e+04,
         1.260000e+04,  4.720000e+04,  8.190000e+04,  4.190000e+04,
         1.890000e+04,  4.320000e+04,  5.900000e+04,  2.322000e+05,
        -7.910000e+04,  4.900000e+04,  4.230000e+04, -1.520000e+04,
         1.199000e+05,  1.198000e+05,  1.523000e+05,  1.430000e+05,
        -1.140000e+04,  1.030000e+05,  2.820000e+04,  1.040000e+04,
         3.760000e+04,  1.030000e+05,  5.080000e+04, -1.470000e+04,
         6.890000e+04,  8.580000e+04,  8.580000e+04,  8.580000e+04,
         8.580000e+04,  1.179000e+05,  1.179000e+05, -4.060000e+04,
         7.810000e+04,  9.370000e+04, -6.800000e+03,  0.000000e+00,
         2.720000e+04,  3.510000e+04, -4.820000e+04,  7.660000e+04,
         4.860000e+04,  4.860000e+04,  3.570000e+04,  3.570000e+04,
         3.570000e+04,  3.516000e+05,  4.313000e+05,  9.850000e+04,
         2.440000e+04,  1.815000e+05,  2.287000e+05, -2.460000e+04,
         2.993000e+05,  3.670000e+05,  4.791000e+05,  3.670000e+05,
         4.796000e+05,  1.142000e+05, -2.947000e+05, -4.210000e+05,
        -2.305000e+05,  2.600000e+04,  4.170000e+04,  6.634000e+05,
        -7.080000e+04,  5.710000e+04,  7.370000e+04, -2.410000e+04,
        -6.490000e+04, -5.940000e+04, -1.150000e+04, -2.470000e+04,
        -1.872000e+05, -8.900000e+03,  1.944000e+05, -1.300000e+03,
        -1.280000e+05,  1.253000e+05,  7.740000e+04,  5.650000e+04,
        -1.520000e+04,  1.630000e+04,  1.828000e+05,  1.953000e+05,
         2.413000e+05,  6.850000e+04,  1.849000e+05, -1.390000e+04,
         2.439000e+05,  2.032000e+05,  4.820000e+04,  5.450000e+04,
         8.910000e+04,  6.050000e+04,  6.060000e+04,  1.095000e+05,
         3.395000e+05,  2.608000e+05,  1.139900e+06,  5.950000e+04,
         5.960000e+04,  1.320000e+04,  1.320000e+04,  1.890000e+04,
         1.310000e+04, -2.550000e+04,  1.320000e+04,  6.720000e+04,
         6.720000e+04,  6.720000e+04,  6.860000e+04,  6.500000e+04,
        -6.870000e+04, -6.870000e+04, -6.870000e+04, -1.004000e+05,
         2.700000e+04,  0.000000e+00, -4.170000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -4.124000e+05, -1.205000e+05, -5.360000e+04,
         2.810000e+04,  1.532000e+05,  1.531000e+05,  3.546000e+05,
         3.545000e+05, -7.600000e+03, -2.830000e+04,  1.700000e+03,
        -1.660000e+04, -5.600000e+03, -5.900000e+03, -4.000000e+03,
        -8.380000e+04,  4.370000e+04, -1.460000e+04,  4.000000e+02,
         0.000000e+00,  0.000000e+00, -8.700000e+03, -1.910000e+04,
        -6.100000e+03, -1.530000e+04, -1.530000e+04, -1.530000e+04,
         0.000000e+00,  0.000000e+00, -1.067000e+05, -9.180000e+04,
        -2.250000e+04, -1.220000e+04, -3.570000e+04, -5.700000e+03,
        -2.280000e+04, -1.710000e+04, -4.280000e+04, -7.300000e+03,
        -2.870000e+04, -2.870000e+04, -2.080000e+04, -7.200000e+03,
        -4.300000e+03, -4.930000e+04, -3.590000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  5.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.660000e+04,
        -2.830000e+04, -1.100000e+04,  4.000000e+02, -1.460000e+04,
         6.720000e+04, -1.000000e+02,  2.010000e+04,  5.070000e+04,
         3.570000e+04,  8.580000e+04,  7.810000e+04, -1.700000e+04,
         1.890000e+04,  1.320000e+04,  5.960000e+04, -6.870000e+04,
        -5.360000e+04,  1.700000e+03, -1.530000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         6.720000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 3.200000e+04,  4.860000e+04,  4.690000e+04,  4.200000e+03,
         1.800000e+04,  1.082000e+05,  4.420000e+04,  4.560000e+04,
         4.850000e+04,  4.940000e+04,  4.810000e+04,  1.083000e+05,
         1.050000e+05, -8.190000e+04,  0.000000e+00,  1.083000e+05,
         1.500000e+04,  1.165000e+05,  1.280000e+04,  3.822000e+05,
         0.000000e+00,  6.260000e+04,  8.910000e+04,  8.570000e+04,
         1.950000e+04,  8.670000e+04,  1.549000e+05,  1.445000e+05,
         1.013000e+05,  2.641000e+05,  3.938000e+05,  2.813000e+05,
         9.400000e+04, -1.720000e+04, -1.670000e+04, -1.710000e+04,
        -1.750000e+04, -7.020000e+04, -1.680000e+04, -3.166000e+05,
        -2.790000e+05, -2.857000e+05, -3.330000e+04, -2.520000e+04,
        -2.560000e+04,  2.210000e+04, -2.050000e+04,  9.700000e+03,
         9.700000e+03,  4.330000e+04,  7.690000e+04,  4.160000e+04,
         1.680000e+04,  4.350000e+04,  5.190000e+04,  2.203000e+05,
        -7.850000e+04,  5.180000e+04,  3.790000e+04, -1.980000e+04,
         1.261000e+05,  1.260000e+05,  1.438000e+05,  1.415000e+05,
         4.900000e+03,  1.214000e+05,  3.570000e+04, -3.930000e+04,
         3.530000e+04,  8.880000e+04,  4.930000e+04, -1.360000e+04,
         6.610000e+04,  9.610000e+04,  9.610000e+04,  9.610000e+04,
         9.620000e+04,  1.132000e+05,  1.130000e+05, -3.360000e+04,
         8.170000e+04,  9.010000e+04, -4.000000e+02,  0.000000e+00,
         3.290000e+04,  4.070000e+04, -4.810000e+04,  7.330000e+04,
         4.930000e+04,  4.930000e+04,  3.370000e+04,  3.370000e+04,
         3.370000e+04,  3.717000e+05,  4.141000e+05,  1.126000e+05,
         5.260000e+04,  2.074000e+05,  2.322000e+05,  1.500000e+04,
         3.006000e+05,  4.004000e+05,  4.597000e+05,  4.004000e+05,
         4.600000e+05,  1.409000e+05, -2.630000e+05, -3.926000e+05,
        -2.287000e+05,  3.110000e+04,  3.950000e+04,  6.358000e+05,
        -7.290000e+04,  5.680000e+04,  6.570000e+04, -1.790000e+04,
        -6.470000e+04, -4.040000e+04, -1.480000e+04, -1.720000e+04,
        -1.701000e+05,  1.530000e+04,  2.082000e+05,  2.980000e+04,
        -1.001000e+05,  1.596000e+05,  7.200000e+04,  6.830000e+04,
        -2.300000e+03,  1.460000e+04,  1.741000e+05,  2.081000e+05,
         2.326000e+05,  7.900000e+04,  1.764000e+05,  1.380000e+04,
         2.340000e+05,  2.071000e+05,  4.480000e+04,  5.030000e+04,
         8.400000e+04,  7.960000e+04,  7.960000e+04,  1.050000e+05,
         3.231000e+05,  2.809000e+05,  1.406700e+06,  6.350000e+04,
         6.360000e+04,  9.000000e+03,  9.000000e+03,  1.680000e+04,
         8.900000e+03, -3.040000e+04,  9.000000e+03,  6.450000e+04,
         6.450000e+04,  6.450000e+04,  6.500000e+04,  1.853000e+05,
        -6.110000e+04, -6.110000e+04, -6.110000e+04, -1.041000e+05,
         7.790000e+04,  0.000000e+00, -1.077000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.667000e+05, -1.200000e+05, -5.550000e+04,
         2.170000e+04,  1.457000e+05,  1.456000e+05,  3.389000e+05,
         3.388000e+05, -9.000000e+02, -2.750000e+04,  1.600000e+03,
        -2.010000e+04, -5.000000e+04, -5.700000e+03, -4.900000e+03,
        -8.190000e+04,  1.022000e+05, -1.410000e+04,  3.000000e+02,
         0.000000e+00,  0.000000e+00, -5.600000e+03, -1.460000e+04,
        -5.800000e+03, -1.480000e+04, -1.480000e+04, -1.480000e+04,
         0.000000e+00,  0.000000e+00, -9.780000e+04, -8.930000e+04,
        -2.170000e+04, -9.700000e+03, -3.470000e+04, -5.400000e+03,
        -1.570000e+04, -1.970000e+04, -4.180000e+04, -7.000000e+03,
        -2.880000e+04, -2.880000e+04, -1.610000e+04, -7.100000e+03,
        -3.700000e+03, -4.480000e+04, -3.590000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  4.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.010000e+04,
        -2.750000e+04, -1.070000e+04,  3.000000e+02, -1.410000e+04,
         6.450000e+04, -1.000000e+02,  3.200000e+04,  4.860000e+04,
         3.370000e+04,  9.610000e+04,  8.170000e+04, -1.750000e+04,
         1.680000e+04,  9.000000e+03,  6.360000e+04, -6.110000e+04,
        -5.550000e+04,  1.600000e+03, -1.480000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         6.450000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-2.410000e+04, -5.210000e+04, -4.370000e+04, -1.390000e+04,
        -1.900000e+04, -7.990000e+04, -3.170000e+04, -2.650000e+04,
        -5.210000e+04, -2.690000e+04, -5.190000e+04, -4.450000e+04,
        -5.670000e+04,  8.220000e+04,  0.000000e+00, -4.450000e+04,
        -4.360000e+04, -4.400000e+04, -6.500000e+03, -1.824000e+05,
         0.000000e+00, -6.740000e+04, -9.840000e+04, -9.760000e+04,
        -3.470000e+04, -1.100000e+05, -1.645000e+05, -1.513000e+05,
        -1.259000e+05, -2.899000e+05, -4.203000e+05, -3.116000e+05,
        -1.881000e+05,  1.350000e+04,  1.320000e+04,  1.310000e+04,
         1.320000e+04,  6.830000e+04,  1.320000e+04,  3.006000e+05,
         2.570000e+05,  2.604000e+05,  3.420000e+04,  2.250000e+04,
         2.420000e+04, -3.230000e+04, -4.000000e+02, -1.940000e+04,
        -1.930000e+04, -5.610000e+04, -9.310000e+04, -5.560000e+04,
        -2.350000e+04, -6.240000e+04, -7.350000e+04, -2.572000e+05,
         7.220000e+04, -6.170000e+04, -5.580000e+04, -2.000000e+03,
        -1.417000e+05, -1.417000e+05, -1.628000e+05, -1.618000e+05,
         1.500000e+03, -1.148000e+05, -3.530000e+04, -4.020000e+04,
        -3.840000e+04, -1.126000e+05, -5.220000e+04,  1.490000e+04,
        -7.040000e+04, -9.890000e+04, -9.890000e+04, -9.880000e+04,
        -9.880000e+04, -1.208000e+05, -1.209000e+05,  3.100000e+04,
        -9.150000e+04, -1.042000e+05,  2.310600e+06,  0.000000e+00,
         2.250100e+06,  2.269200e+06,  4.330000e+04, -7.670000e+04,
        -4.990000e+04, -4.990000e+04, -4.190000e+04, -4.180000e+04,
        -4.190000e+04, -4.009000e+05, -4.585000e+05, -1.387000e+05,
         2.558200e+06,  4.400100e+06,  4.307400e+06,  7.006800e+06,
         4.250400e+06, -4.154000e+05, -4.924000e+05, -4.154000e+05,
        -4.917000e+05, -1.526000e+05,  2.692000e+05,  3.996000e+05,
         2.256000e+05, -3.640000e+04, -4.750000e+04, -6.798000e+05,
         7.170000e+04, -6.000000e+04, -7.040000e+04,  2.299400e+06,
         5.880000e+04,  4.770000e+04,  1.460000e+04,  1.750000e+04,
         1.794000e+05,  2.286000e+06, -2.231000e+05, -2.030000e+04,
         1.086000e+05, -1.492000e+05, -7.580000e+04, -7.060000e+04,
        -3.900000e+03, -2.620000e+04, -1.906000e+05, -2.181000e+05,
        -2.533000e+05, -8.640000e+04, -1.931000e+05,  2.266900e+06,
        -2.500000e+05, -2.121000e+05, -5.280000e+04, -6.290000e+04,
        -9.960000e+04, -6.920000e+04, -6.930000e+04, -1.125000e+05,
        -3.482000e+05, -2.927000e+05, -1.312500e+06,  2.207500e+06,
         2.209900e+06, -1.060000e+04, -1.060000e+04, -2.230000e+04,
        -1.060000e+04,  3.440000e+04, -1.060000e+04, -6.880000e+04,
        -6.880000e+04, -6.880000e+04, -6.870000e+04, -6.110000e+04,
         2.703000e+06,  2.701000e+06,  2.701400e+06,  9.770000e+04,
        -2.980000e+04,  0.000000e+00,  1.375700e+06,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.621490e+07,  1.337000e+05,  6.160000e+04,
        -4.020000e+04, -1.602000e+05, -1.606000e+05, -3.669000e+05,
        -3.669000e+05,  2.276300e+06,  2.590000e+04, -1.700000e+03,
         1.570000e+04,  4.000000e+03,  6.100000e+03,  4.100000e+03,
         8.220000e+04, -4.510000e+04,  1.480000e+04, -3.000000e+02,
         0.000000e+00,  0.000000e+00,  5.800000e+03,  1.880000e+04,
         6.800000e+03,  1.570000e+04,  1.570000e+04,  1.570000e+04,
         0.000000e+00,  0.000000e+00,  1.025000e+05,  9.060000e+04,
         2.320000e+04,  1.200000e+04,  3.440000e+04,  6.300000e+03,
         1.970000e+04,  1.640000e+04,  4.200000e+04,  7.400000e+03,
         2.670000e+04,  2.670000e+04,  2.040000e+04,  7.700000e+03,
         4.400000e+03,  4.690000e+04,  3.440000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -4.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.000000e+02,  1.570000e+04,
         2.590000e+04,  1.080000e+04, -3.000000e+02,  1.480000e+04,
        -6.880000e+04,  0.000000e+00, -2.410000e+04, -5.210000e+04,
        -4.180000e+04, -9.890000e+04, -9.150000e+04,  1.330000e+04,
        -2.230000e+04, -1.060000e+04,  2.209900e+06,  2.701500e+06,
         6.160000e+04, -1.700000e+03,  1.570000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -6.880000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-2.400000e+04, -5.200000e+04, -4.360000e+04, -1.390000e+04,
        -1.900000e+04, -7.980000e+04, -3.170000e+04, -2.650000e+04,
        -5.200000e+04, -2.680000e+04, -5.190000e+04, -4.450000e+04,
        -5.660000e+04,  8.220000e+04,  0.000000e+00, -4.450000e+04,
        -4.350000e+04, -4.400000e+04, -6.500000e+03, -1.823000e+05,
         0.000000e+00, -6.740000e+04, -9.830000e+04, -9.750000e+04,
        -3.460000e+04, -1.099000e+05, -1.643000e+05, -1.512000e+05,
        -1.258000e+05, -2.896000e+05, -4.200000e+05, -3.114000e+05,
        -1.880000e+05,  1.350000e+04,  1.320000e+04,  1.310000e+04,
         1.320000e+04,  6.830000e+04,  1.320000e+04,  3.004000e+05,
         2.568000e+05,  2.602000e+05,  3.420000e+04,  2.250000e+04,
         2.420000e+04, -3.230000e+04, -4.000000e+02, -1.940000e+04,
        -1.930000e+04, -5.610000e+04, -9.310000e+04, -5.560000e+04,
        -2.350000e+04, -6.230000e+04, -7.340000e+04, -2.571000e+05,
         7.210000e+04, -6.160000e+04, -5.570000e+04, -2.000000e+03,
        -1.416000e+05, -1.416000e+05, -1.627000e+05, -1.617000e+05,
         1.500000e+03, -1.147000e+05, -3.520000e+04, -4.010000e+04,
        -3.840000e+04, -1.125000e+05, -5.210000e+04,  1.490000e+04,
        -7.040000e+04, -9.880000e+04, -9.880000e+04, -9.880000e+04,
        -9.880000e+04, -1.208000e+05, -1.208000e+05,  3.100000e+04,
        -9.140000e+04, -1.041000e+05,  2.309000e+06,  0.000000e+00,
         2.248500e+06,  2.267600e+06,  4.320000e+04, -7.660000e+04,
        -4.980000e+04, -4.980000e+04, -4.180000e+04, -4.180000e+04,
        -4.180000e+04, -4.007000e+05, -4.581000e+05, -1.386000e+05,
         2.556400e+06,  4.396900e+06,  4.304300e+06,  7.001800e+06,
         4.247400e+06, -4.151000e+05, -4.921000e+05, -4.151000e+05,
        -4.914000e+05, -1.525000e+05,  2.690000e+05,  3.993000e+05,
         2.254000e+05, -3.630000e+04, -4.750000e+04, -6.793000e+05,
         7.170000e+04, -6.000000e+04, -7.030000e+04,  2.297800e+06,
         5.870000e+04,  4.770000e+04,  1.460000e+04,  1.750000e+04,
         1.793000e+05,  2.284400e+06, -2.229000e+05, -2.030000e+04,
         1.085000e+05, -1.491000e+05, -7.580000e+04, -7.050000e+04,
        -3.900000e+03, -2.610000e+04, -1.905000e+05, -2.180000e+05,
        -2.531000e+05, -8.630000e+04, -1.930000e+05,  2.265300e+06,
        -2.498000e+05, -2.119000e+05, -5.280000e+04, -6.280000e+04,
        -9.950000e+04, -6.920000e+04, -6.920000e+04, -1.124000e+05,
        -3.480000e+05, -2.925000e+05, -1.311600e+06,  2.205900e+06,
         2.208300e+06, -1.060000e+04, -1.060000e+04, -2.220000e+04,
        -1.060000e+04,  3.430000e+04, -1.060000e+04, -6.870000e+04,
        -6.870000e+04, -6.870000e+04, -6.870000e+04, -6.110000e+04,
         2.701000e+06,  2.711700e+06,  2.709500e+06,  9.760000e+04,
        -2.980000e+04,  0.000000e+00,  1.374700e+06,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.622220e+07,  1.336000e+05,  6.160000e+04,
        -4.010000e+04, -1.601000e+05, -1.605000e+05, -3.666000e+05,
        -3.666000e+05,  2.274600e+06,  2.590000e+04, -1.700000e+03,
         1.560000e+04,  4.000000e+03,  6.100000e+03,  4.100000e+03,
         8.220000e+04, -4.500000e+04,  1.480000e+04, -3.000000e+02,
         0.000000e+00,  0.000000e+00,  5.800000e+03,  1.880000e+04,
         6.800000e+03,  1.570000e+04,  1.570000e+04,  1.570000e+04,
         0.000000e+00,  0.000000e+00,  1.024000e+05,  9.060000e+04,
         2.320000e+04,  1.200000e+04,  3.440000e+04,  6.300000e+03,
         1.970000e+04,  1.640000e+04,  4.200000e+04,  7.400000e+03,
         2.670000e+04,  2.670000e+04,  2.040000e+04,  7.700000e+03,
         4.400000e+03,  4.690000e+04,  3.440000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -4.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -5.000000e+02,  1.560000e+04,
         2.590000e+04,  1.080000e+04, -3.000000e+02,  1.480000e+04,
        -6.870000e+04,  0.000000e+00, -2.400000e+04, -5.200000e+04,
        -4.180000e+04, -9.880000e+04, -9.140000e+04,  1.320000e+04,
        -2.220000e+04, -1.060000e+04,  2.208300e+06,  2.708900e+06,
         6.160000e+04, -1.700000e+03,  1.570000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -6.870000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-2.400000e+04, -5.200000e+04, -4.370000e+04, -1.390000e+04,
        -1.900000e+04, -7.980000e+04, -3.170000e+04, -2.650000e+04,
        -5.200000e+04, -2.690000e+04, -5.190000e+04, -4.450000e+04,
        -5.660000e+04,  8.220000e+04,  0.000000e+00, -4.450000e+04,
        -4.350000e+04, -4.400000e+04, -6.500000e+03, -1.823000e+05,
         0.000000e+00, -6.740000e+04, -9.840000e+04, -9.750000e+04,
        -3.460000e+04, -1.100000e+05, -1.644000e+05, -1.512000e+05,
        -1.258000e+05, -2.897000e+05, -4.201000e+05, -3.114000e+05,
        -1.880000e+05,  1.350000e+04,  1.320000e+04,  1.310000e+04,
         1.320000e+04,  6.830000e+04,  1.320000e+04,  3.004000e+05,
         2.569000e+05,  2.603000e+05,  3.420000e+04,  2.250000e+04,
         2.420000e+04, -3.230000e+04, -4.000000e+02, -1.940000e+04,
        -1.930000e+04, -5.610000e+04, -9.310000e+04, -5.560000e+04,
        -2.350000e+04, -6.230000e+04, -7.340000e+04, -2.571000e+05,
         7.210000e+04, -6.160000e+04, -5.570000e+04, -2.000000e+03,
        -1.416000e+05, -1.416000e+05, -1.627000e+05, -1.617000e+05,
         1.500000e+03, -1.148000e+05, -3.520000e+04, -4.010000e+04,
        -3.840000e+04, -1.125000e+05, -5.210000e+04,  1.490000e+04,
        -7.040000e+04, -9.880000e+04, -9.880000e+04, -9.880000e+04,
        -9.880000e+04, -1.208000e+05, -1.208000e+05,  3.100000e+04,
        -9.140000e+04, -1.042000e+05,  2.309300e+06,  0.000000e+00,
         2.248800e+06,  2.267900e+06,  4.320000e+04, -7.660000e+04,
        -4.980000e+04, -4.980000e+04, -4.180000e+04, -4.180000e+04,
        -4.180000e+04, -4.007000e+05, -4.582000e+05, -1.387000e+05,
         2.556800e+06,  4.397600e+06,  4.304900e+06,  7.002800e+06,
         4.248000e+06, -4.152000e+05, -4.921000e+05, -4.152000e+05,
        -4.915000e+05, -1.525000e+05,  2.690000e+05,  3.994000e+05,
         2.254000e+05, -3.630000e+04, -4.750000e+04, -6.794000e+05,
         7.170000e+04, -6.000000e+04, -7.030000e+04,  2.298100e+06,
         5.870000e+04,  4.770000e+04,  1.460000e+04,  1.750000e+04,
         1.793000e+05,  2.284700e+06, -2.229000e+05, -2.030000e+04,
         1.085000e+05, -1.491000e+05, -7.580000e+04, -7.050000e+04,
        -3.900000e+03, -2.610000e+04, -1.905000e+05, -2.180000e+05,
        -2.532000e+05, -8.630000e+04, -1.930000e+05,  2.265600e+06,
        -2.499000e+05, -2.120000e+05, -5.280000e+04, -6.280000e+04,
        -9.960000e+04, -6.920000e+04, -6.920000e+04, -1.124000e+05,
        -3.480000e+05, -2.926000e+05, -1.311800e+06,  2.206200e+06,
         2.208700e+06, -1.060000e+04, -1.060000e+04, -2.220000e+04,
        -1.060000e+04,  3.430000e+04, -1.060000e+04, -6.870000e+04,
        -6.870000e+04, -6.870000e+04, -6.870000e+04, -6.110000e+04,
         2.701400e+06,  2.709500e+06,  2.709900e+06,  9.760000e+04,
        -2.980000e+04,  0.000000e+00,  1.374900e+06,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.622460e+07,  1.336000e+05,  6.160000e+04,
        -4.010000e+04, -1.601000e+05, -1.605000e+05, -3.667000e+05,
        -3.667000e+05,  2.275000e+06,  2.590000e+04, -1.700000e+03,
         1.560000e+04,  4.000000e+03,  6.100000e+03,  4.100000e+03,
         8.220000e+04, -4.500000e+04,  1.480000e+04, -3.000000e+02,
         0.000000e+00,  0.000000e+00,  5.800000e+03,  1.880000e+04,
         6.800000e+03,  1.570000e+04,  1.570000e+04,  1.570000e+04,
         0.000000e+00,  0.000000e+00,  1.024000e+05,  9.060000e+04,
         2.320000e+04,  1.200000e+04,  3.440000e+04,  6.300000e+03,
         1.970000e+04,  1.640000e+04,  4.200000e+04,  7.400000e+03,
         2.670000e+04,  2.670000e+04,  2.040000e+04,  7.700000e+03,
         4.400000e+03,  4.690000e+04,  3.440000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -4.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -5.000000e+02,  1.560000e+04,
         2.590000e+04,  1.080000e+04, -3.000000e+02,  1.480000e+04,
        -6.870000e+04,  0.000000e+00, -2.400000e+04, -5.200000e+04,
        -4.180000e+04, -9.880000e+04, -9.140000e+04,  1.320000e+04,
        -2.220000e+04, -1.060000e+04,  2.208700e+06,  2.709300e+06,
         6.160000e+04, -1.700000e+03,  1.570000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -6.870000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 4.640000e+04, -8.200000e+04, -7.250000e+04, -8.130000e+04,
        -1.730000e+04,  2.631000e+05,  1.703000e+05,  4.590000e+04,
        -8.200000e+04,  4.570000e+04, -8.180000e+04, -3.320000e+04,
        -9.590000e+04,  5.300000e+05,  0.000000e+00, -3.320000e+04,
        -9.090000e+04, -2.930000e+04, -1.090000e+04, -8.480000e+04,
         0.000000e+00,  4.477000e+05,  2.504000e+05,  2.685000e+05,
         2.489000e+05, -2.551000e+05, -2.560000e+05, -8.280000e+04,
        -2.729000e+05,  4.607000e+05, -9.450000e+04,  3.317000e+05,
         1.390300e+06,  4.288000e+05,  4.288000e+05,  4.284000e+05,
         4.296000e+05,  6.123000e+05,  4.287000e+05,  4.306000e+06,
         4.039000e+06,  4.067000e+06,  5.019000e+05,  4.361000e+05,
         4.421000e+05, -9.870000e+04, -1.545000e+05,  5.039000e+05,
         5.039000e+05,  2.498000e+05, -2.900000e+03,  2.554000e+05,
         3.339000e+05,  8.184000e+05,  7.527000e+05, -5.178000e+05,
         4.431000e+05, -1.079000e+05, -1.720000e+05, -1.555000e+05,
         7.008000e+05,  7.008000e+05,  5.712000e+05,  5.813000e+05,
         3.250000e+05, -1.321000e+05,  5.870000e+04,  4.702000e+05,
        -9.800000e+04, -1.916000e+05, -7.670000e+04,  1.930000e+04,
        -1.049000e+05, -5.370000e+04, -5.370000e+04, -5.370000e+04,
        -5.370000e+04, -1.824000e+05, -1.824000e+05,  5.012000e+05,
        -1.174000e+05, -1.816000e+05,  4.500000e+03,  0.000000e+00,
        -2.503000e+05, -2.608000e+05,  4.361000e+05,  6.360000e+04,
        -7.650000e+04, -7.650000e+04, -9.060000e+04, -9.050000e+04,
        -9.060000e+04, -4.158000e+05, -7.374000e+05,  6.916000e+05,
         4.352000e+05, -1.716000e+05, -3.632000e+05,  1.315000e+05,
        -8.785000e+05, -2.882000e+05, -7.386000e+05, -2.882000e+05,
        -7.390000e+05,  8.206000e+05,  2.204800e+06,  2.759700e+06,
         1.947100e+06,  4.019000e+05,  3.361000e+05, -1.047400e+06,
         4.893000e+05, -6.690000e+04, -1.328000e+05,  4.342000e+05,
         8.632000e+05,  1.803000e+05, -1.300000e+04,  1.100000e+03,
         7.366000e+05,  1.248000e+05, -1.808000e+05,  5.937000e+05,
         1.149200e+06,  3.820000e+04,  2.648000e+05,  2.950000e+05,
         9.042000e+05,  7.727000e+05,  1.258000e+05, -1.807000e+05,
        -3.781000e+05,  3.752000e+05,  1.271000e+05,  1.261000e+05,
        -3.741000e+05, -1.772000e+05,  3.248000e+05,  2.408000e+05,
        -1.330000e+04,  1.800000e+04,  1.800000e+04, -1.733000e+05,
        -2.342000e+05,  9.460000e+04,  1.110000e+05, -9.480000e+04,
        -9.500000e+04, -4.000000e+04, -4.000000e+04,  3.331000e+05,
        -4.000000e+04, -4.083000e+05, -4.000000e+04, -1.004000e+05,
        -1.004000e+05, -1.004000e+05, -1.004000e+05, -1.041000e+05,
         9.770000e+04,  9.760000e+04,  9.760000e+04,  1.213000e+06,
         5.622000e+05,  0.000000e+00,  6.300000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  5.860000e+05,  1.605000e+05,  6.020000e+04,
         1.007500e+06,  1.324000e+05,  1.327000e+05, -1.687000e+05,
        -1.688000e+05,  5.400000e+03,  8.000000e+03, -4.500000e+03,
         7.820000e+04,  1.230000e+04,  6.400000e+03,  7.500000e+03,
         5.300000e+05, -6.810000e+04,  1.670000e+04, -1.200000e+03,
         0.000000e+00,  0.000000e+00,  7.400000e+03,  6.780000e+04,
         3.100000e+03,  2.310000e+04,  2.310000e+04,  2.310000e+04,
         0.000000e+00,  0.000000e+00,  6.009000e+05,  5.369000e+05,
         2.460000e+04,  2.870000e+04,  1.460000e+05,  2.900000e+03,
         7.020000e+04,  7.750000e+04,  2.640000e+05,  8.300000e+03,
         8.200000e+03,  8.200000e+03,  7.300000e+04,  7.300000e+03,
         5.900000e+03,  8.080000e+04,  1.550000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -5.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  7.820000e+04,
         8.000000e+03,  6.950000e+04, -1.200000e+03,  1.670000e+04,
        -1.004000e+05,  0.000000e+00,  4.640000e+04, -8.200000e+04,
        -9.050000e+04, -5.370000e+04, -1.174000e+05,  4.296000e+05,
         3.331000e+05, -4.000000e+04, -9.500000e+04,  9.760000e+04,
         6.020000e+04, -4.500000e+03,  2.310000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.004000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 2.489000e+05,  2.050000e+04,  2.130000e+04, -2.920000e+04,
         1.096000e+05,  1.102800e+06,  6.051000e+05,  3.010000e+05,
         2.040000e+04,  3.115000e+05,  2.030000e+04,  2.448000e+05,
         8.220000e+04, -5.610000e+04,  0.000000e+00,  2.448000e+05,
        -2.010000e+04,  1.974000e+05,  7.600000e+03,  8.745000e+05,
         0.000000e+00,  3.567000e+05,  1.570000e+04,  1.660000e+04,
        -5.890000e+04, -1.020000e+04,  6.460000e+04,  4.101000e+05,
        -6.200000e+03,  2.367000e+05,  4.298000e+05,  9.400000e+03,
        -1.338000e+05, -2.920000e+04, -2.900000e+04, -2.910000e+04,
        -2.950000e+04, -5.680000e+04, -2.910000e+04,  1.401000e+05,
        -3.134000e+05, -3.134000e+05,  8.180000e+04, -3.230000e+04,
        -3.160000e+04,  8.040000e+04, -8.640000e+04, -5.890000e+04,
        -5.890000e+04, -3.410000e+04, -9.700000e+03, -3.380000e+04,
        -3.010000e+04,  2.060000e+04, -9.330000e+04,  3.030000e+04,
        -8.470000e+04,  1.080000e+05, -3.060000e+04, -8.660000e+04,
         2.428000e+05,  2.427000e+05,  1.620000e+04,  1.610000e+04,
         8.199000e+05,  1.770000e+05,  2.956000e+05,  1.086800e+06,
        -1.090000e+04,  1.610000e+04,  2.080000e+04, -1.610000e+04,
         1.670000e+04,  2.749000e+05,  2.749000e+05,  2.748000e+05,
         2.750000e+05,  4.730000e+04,  4.730000e+04,  8.150000e+04,
         1.359000e+05,  2.190000e+04, -4.800000e+03,  0.000000e+00,
         1.990000e+04,  2.220000e+04, -5.700000e+04,  1.220000e+04,
         2.120000e+04,  2.120000e+04, -1.400000e+03, -1.400000e+03,
        -1.400000e+03,  7.103000e+05,  1.414000e+05,  3.236000e+05,
         4.353000e+05,  4.284000e+05,  8.750000e+04,  3.440000e+05,
         1.377000e+05,  9.878000e+05,  1.912000e+05,  9.878000e+05,
         1.921000e+05,  6.010000e+05,  2.725000e+05,  7.920000e+04,
        -1.823000e+05,  1.080000e+05, -5.900000e+03,  2.652000e+05,
        -1.162000e+05,  7.710000e+04, -3.640000e+04, -3.420000e+04,
        -8.590000e+04,  2.709000e+05, -6.970000e+04, -6.920000e+04,
         7.750000e+04,  3.559000e+05,  4.382000e+05,  5.781000e+05,
         3.844000e+05,  7.718000e+05,  8.600000e+03,  1.130000e+04,
         1.891000e+05, -3.860000e+04,  5.050000e+04,  4.380000e+05,
         9.570000e+04,  2.451000e+05,  5.130000e+04,  3.525000e+05,
         9.760000e+04,  4.353000e+05, -3.100000e+03, -3.110000e+04,
        -6.400000e+03,  3.811000e+05,  3.812000e+05,  4.390000e+04,
         8.630000e+04,  6.558000e+05,  6.228700e+06,  2.170000e+04,
         2.180000e+04, -6.010000e+04, -6.010000e+04, -2.990000e+04,
        -6.020000e+04, -1.183000e+05, -6.010000e+04,  2.680000e+04,
         2.680000e+04,  2.680000e+04,  2.700000e+04,  7.790000e+04,
        -2.980000e+04, -2.980000e+04, -2.980000e+04,  5.622000e+05,
         1.755900e+06,  0.000000e+00, -4.790000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.786000e+05, -1.130000e+05, -8.660000e+04,
        -1.175000e+05,  2.350000e+04,  2.330000e+04,  1.035000e+05,
         1.034000e+05, -5.100000e+03, -2.600000e+04, -1.010000e+04,
         1.074000e+05, -3.020000e+04, -2.400000e+03, -2.100000e+03,
        -5.610000e+04,  5.984000e+05, -6.000000e+03, -1.900000e+03,
         0.000000e+00,  0.000000e+00, -1.030000e+04,  9.750000e+04,
        -1.300000e+04, -6.300000e+03, -6.200000e+03, -6.200000e+03,
         0.000000e+00,  0.000000e+00,  5.490000e+04, -5.890000e+04,
        -9.100000e+03,  3.400000e+04,  2.048000e+05, -1.200000e+04,
         1.089000e+05,  1.073000e+05, -2.830000e+04, -3.000000e+03,
        -2.800000e+04, -2.800000e+04,  1.093000e+05, -3.300000e+03,
        -1.600000e+03,  8.050000e+04, -3.140000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02, -2.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.074000e+05,
        -2.600000e+04, -7.400000e+03, -1.900000e+03, -6.000000e+03,
         2.680000e+04, -1.000000e+02,  2.489000e+05,  2.050000e+04,
        -1.400000e+03,  2.749000e+05,  1.359000e+05, -2.940000e+04,
        -2.990000e+04, -6.010000e+04,  2.180000e+04, -2.980000e+04,
        -8.660000e+04, -1.010000e+04, -6.200000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.680000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.098890e+08,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-2.280000e+04, -3.100000e+04, -2.980000e+04, -6.200000e+03,
        -1.450000e+04, -8.010000e+04, -3.460000e+04, -3.020000e+04,
        -3.100000e+04, -3.230000e+04, -3.080000e+04, -6.500000e+04,
        -6.270000e+04,  5.060000e+04,  0.000000e+00, -6.500000e+04,
        -1.290000e+04, -6.950000e+04, -7.600000e+03, -2.312000e+05,
         0.000000e+00, -4.320000e+04, -5.930000e+04, -5.440000e+04,
        -2.080000e+04, -6.030000e+04, -9.910000e+04, -9.350000e+04,
        -6.980000e+04, -1.740000e+05, -2.558000e+05, -1.841000e+05,
        -1.111000e+05,  9.100000e+03,  8.700000e+03,  9.000000e+03,
         9.400000e+03,  4.260000e+04,  8.700000e+03,  1.834000e+05,
         1.608000e+05,  1.685000e+05,  1.850000e+04,  1.410000e+04,
         1.480000e+04, -2.070000e+04,  4.100000e+03, -1.420000e+04,
        -1.420000e+04, -3.430000e+04, -5.400000e+04, -3.200000e+04,
        -1.530000e+04, -4.300000e+04, -4.780000e+04, -1.487000e+05,
         4.440000e+04, -3.760000e+04, -2.950000e+04,  3.800000e+03,
        -8.560000e+04, -8.560000e+04, -9.630000e+04, -9.310000e+04,
        -1.280000e+04, -7.670000e+04, -2.560000e+04,  8.500000e+03,
        -2.490000e+04, -5.930000e+04, -3.160000e+04,  9.000000e+03,
        -4.220000e+04, -6.260000e+04, -6.260000e+04, -6.250000e+04,
        -6.260000e+04, -7.250000e+04, -7.240000e+04,  1.940000e+04,
        -5.460000e+04, -5.910000e+04,  1.409300e+06,  0.000000e+00,
         1.378700e+06,  1.384000e+06,  2.680000e+04, -5.010000e+04,
        -3.150000e+04, -3.150000e+04, -2.320000e+04, -2.320000e+04,
        -2.320000e+04, -2.440000e+05, -2.681000e+05, -8.060000e+04,
         1.296700e+06,  2.682900e+06,  2.645400e+06,  4.248800e+06,
         2.606600e+06, -2.598000e+05, -2.943000e+05, -2.598000e+05,
        -2.948000e+05, -9.640000e+04,  1.583000e+05,  2.401000e+05,
         1.382000e+05, -2.240000e+04, -2.720000e+04, -4.071000e+05,
         4.500000e+04, -3.650000e+04, -4.180000e+04,  1.409400e+06,
         3.490000e+04,  2.480000e+04,  9.900000e+03,  1.360000e+04,
         1.063000e+05,  1.381800e+06, -1.336000e+05, -2.510000e+04,
         5.710000e+04, -1.074000e+05, -4.930000e+04, -4.380000e+04,
        -3.400000e+03, -1.310000e+04, -1.137000e+05, -1.346000e+05,
        -1.479000e+05, -5.340000e+04, -1.152000e+05,  1.387300e+06,
        -1.500000e+05, -1.366000e+05, -3.070000e+04, -3.880000e+04,
        -5.900000e+04, -5.400000e+04, -5.400000e+04, -6.720000e+04,
        -2.088000e+05, -1.846000e+05, -9.463000e+05,  1.354600e+06,
         1.356300e+06, -5.500000e+03, -5.500000e+03, -1.550000e+04,
        -5.500000e+03,  2.200000e+04, -5.500000e+03, -4.140000e+04,
        -4.140000e+04, -4.140000e+04, -4.170000e+04, -1.077000e+05,
         1.375700e+06,  1.374700e+06,  1.374900e+06,  6.300000e+04,
        -4.790000e+04,  0.000000e+00,  1.241720e+07,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  8.252700e+06,  7.570000e+04,  3.510000e+04,
        -3.000000e+04, -9.820000e+04, -9.810000e+04, -2.222000e+05,
        -2.222000e+05,  1.396000e+06,  1.600000e+04, -8.000000e+02,
         1.120000e+04,  2.820000e+04,  3.700000e+03,  3.100000e+03,
         5.060000e+04, -6.160000e+04,  9.200000e+03, -2.000000e+02,
         0.000000e+00,  0.000000e+00,  4.500000e+03,  8.400000e+03,
         4.000000e+03,  9.500000e+03,  9.500000e+03,  9.500000e+03,
         0.000000e+00,  0.000000e+00,  5.990000e+04,  5.530000e+04,
         1.410000e+04,  5.900000e+03,  1.960000e+04,  3.700000e+03,
         9.300000e+03,  1.100000e+04,  2.580000e+04,  4.600000e+03,
         1.660000e+04,  1.660000e+04,  9.100000e+03,  4.600000e+03,
         2.400000e+03,  2.560000e+04,  2.120000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.120000e+04,
         1.600000e+04,  6.600000e+03, -2.000000e+02,  9.200000e+03,
        -4.140000e+04,  0.000000e+00, -2.280000e+04, -3.100000e+04,
        -2.320000e+04, -6.260000e+04, -5.460000e+04,  9.400000e+03,
        -1.550000e+04, -5.500000e+03,  1.356300e+06,  1.375000e+06,
         3.510000e+04, -8.000000e+02,  9.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -4.140000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.098890e+08,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.747230e+07,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.747230e+07,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.747230e+07,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.098890e+08,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.747230e+07,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-1.443000e+05, -3.123000e+05, -2.620000e+05, -8.340000e+04,
        -1.140000e+05, -4.792000e+05, -1.904000e+05, -1.589000e+05,
        -3.123000e+05, -1.612000e+05, -3.116000e+05, -2.670000e+05,
        -3.400000e+05,  4.932000e+05,  0.000000e+00, -2.670000e+05,
        -2.613000e+05, -2.642000e+05, -3.920000e+04, -1.094300e+06,
         0.000000e+00, -4.046000e+05, -5.904000e+05, -5.854000e+05,
        -2.079000e+05, -6.600000e+05, -9.865000e+05, -9.076000e+05,
        -7.552000e+05, -1.738800e+06, -2.521500e+06, -1.869100e+06,
        -1.128600e+06,  8.120000e+04,  7.920000e+04,  7.890000e+04,
         7.940000e+04,  4.098000e+05,  7.930000e+04,  1.803400e+06,
         1.541800e+06,  1.562200e+06,  2.054000e+05,  1.350000e+05,
         1.451000e+05, -1.936000e+05, -2.200000e+03, -1.163000e+05,
        -1.161000e+05, -3.365000e+05, -5.587000e+05, -3.337000e+05,
        -1.411000e+05, -3.742000e+05, -4.408000e+05, -1.543200e+06,
         4.330000e+05, -3.699000e+05, -3.346000e+05, -1.190000e+04,
        -8.500000e+05, -8.498000e+05, -9.768000e+05, -9.705000e+05,
         9.000000e+03, -6.889000e+05, -2.115000e+05, -2.409000e+05,
        -2.304000e+05, -6.753000e+05, -3.130000e+05,  8.970000e+04,
        -4.225000e+05, -5.931000e+05, -5.931000e+05, -5.930000e+05,
        -5.930000e+05, -7.249000e+05, -7.250000e+05,  1.862000e+05,
        -5.489000e+05, -6.252000e+05,  1.386110e+07,  0.000000e+00,
         1.349820e+07,  1.361280e+07,  2.596000e+05, -4.598000e+05,
        -2.991000e+05, -2.991000e+05, -2.511000e+05, -2.510000e+05,
        -2.511000e+05, -2.405200e+06, -2.750300e+06, -8.323000e+05,
         1.534650e+07,  2.639580e+07,  2.583950e+07,  4.203330e+07,
         2.549790e+07, -2.492200e+06, -2.953900e+06, -2.492200e+06,
        -2.949900e+06, -9.156000e+05,  1.614800e+06,  2.397300e+06,
         1.353200e+06, -2.181000e+05, -2.851000e+05, -4.077800e+06,
         4.302000e+05, -3.600000e+05, -4.221000e+05,  1.379420e+07,
         3.526000e+05,  2.862000e+05,  8.780000e+04,  1.053000e+05,
         1.076400e+06,  1.371380e+07, -1.338200e+06, -1.218000e+05,
         6.513000e+05, -8.949000e+05, -4.549000e+05, -4.233000e+05,
        -2.370000e+04, -1.569000e+05, -1.143600e+06, -1.308500e+06,
        -1.519700e+06, -5.180000e+05, -1.158600e+06,  1.359900e+07,
        -1.499900e+06, -1.272200e+06, -3.168000e+05, -3.771000e+05,
        -5.976000e+05, -4.152000e+05, -4.155000e+05, -6.746000e+05,
        -2.089100e+06, -1.756000e+06, -7.873800e+06,  1.324260e+07,
         1.325710e+07, -6.350000e+04, -6.350000e+04, -1.335000e+05,
        -6.340000e+04,  2.062000e+05, -6.350000e+04, -4.126000e+05,
        -4.126000e+05, -4.126000e+05, -4.124000e+05, -3.667000e+05,
         1.621490e+07,  1.622220e+07,  1.622460e+07,  5.860000e+05,
        -1.786000e+05,  0.000000e+00,  8.252700e+06,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  9.772000e+07,  8.018000e+05,  3.695000e+05,
        -2.409000e+05, -9.610000e+05, -9.635000e+05, -2.201100e+06,
        -2.200900e+06,  1.365520e+07,  1.555000e+05, -1.000000e+04,
         9.390000e+04,  2.390000e+04,  3.640000e+04,  2.480000e+04,
         4.932000e+05, -2.703000e+05,  8.870000e+04, -2.100000e+03,
         0.000000e+00, -1.000000e+02,  3.460000e+04,  1.127000e+05,
         4.100000e+04,  9.410000e+04,  9.430000e+04,  9.430000e+04,
         0.000000e+00,  0.000000e+00,  6.146000e+05,  5.437000e+05,
         1.393000e+05,  7.210000e+04,  2.065000e+05,  3.790000e+04,
         1.180000e+05,  9.820000e+04,  2.522000e+05,  4.430000e+04,
         1.604000e+05,  1.603000e+05,  1.223000e+05,  4.650000e+04,
         2.660000e+04,  2.816000e+05,  2.066000e+05,  0.000000e+00,
         8.790000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02, -2.700000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  9.090000e+04,  9.390000e+04,
         1.555000e+05,  6.470000e+04, -2.100000e+03,  8.870000e+04,
        -4.126000e+05,  1.000000e+02, -1.443000e+05, -3.123000e+05,
        -2.510000e+05, -5.931000e+05, -5.489000e+05,  7.950000e+04,
        -1.335000e+05, -6.350000e+04,  1.325710e+07,  1.622390e+07,
         3.695000e+05, -1.000000e+04,  9.430000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -4.126000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-1.089000e+05, -8.980000e+04, -8.180000e+04, -1.200000e+03,
        -5.490000e+04, -4.317000e+05, -2.138000e+05, -1.106000e+05,
        -8.980000e+04, -1.109000e+05, -8.950000e+04, -1.158000e+05,
        -1.049000e+05,  1.571000e+05,  0.000000e+00, -1.158000e+05,
        -6.060000e+04, -1.155000e+05, -1.210000e+04, -4.665000e+05,
         0.000000e+00, -2.030000e+05, -1.605000e+05, -1.635000e+05,
        -2.460000e+04, -1.538000e+05, -2.874000e+05, -3.627000e+05,
        -1.804000e+05,  6.661800e+06,  6.385200e+06,  6.691400e+06,
        -1.574000e+05,  3.750000e+04,  3.740000e+04,  3.750000e+04,
         3.630000e+04,  1.361000e+05,  3.750000e+04,  5.178000e+05,
         5.718000e+05,  5.704000e+05,  4.080000e+04,  5.220000e+04,
         5.400000e+04, -5.570000e+04,  5.600000e+04, -6.000000e+03,
        -6.000000e+03, -7.070000e+04, -1.354000e+05, -7.090000e+04,
        -2.360000e+04, -8.680000e+04, -7.420000e+04, -3.979000e+05,
         1.556000e+05, -1.153000e+05, -6.130000e+04,  5.470000e+04,
        -2.845000e+05, -2.844000e+05, -2.558000e+05, -2.582000e+05,
        -2.054000e+05, -2.431000e+05, -1.355000e+05, -3.356000e+05,
        -6.060000e+04, -1.814000e+05, -9.100000e+04,  2.850000e+04,
        -1.195000e+05, -2.394000e+05, -2.394000e+05, -2.393000e+05,
        -2.394000e+05, -2.093000e+05, -2.093000e+05,  3.620000e+04,
        -1.753000e+05, -1.637000e+05,  1.050000e+04,  0.000000e+00,
        -5.470000e+04, -6.860000e+04,  9.650000e+04, -1.323000e+05,
        -8.910000e+04, -8.910000e+04, -6.010000e+04, -6.010000e+04,
        -6.010000e+04, -8.316000e+05, -7.608000e+05, -2.869000e+05,
        -1.676000e+05, -4.594000e+05, -4.131000e+05, -8.940000e+04,
        -5.458000e+05, -9.584000e+05, -8.531000e+05, -9.584000e+05,
        -8.520000e+05, -4.048000e+05,  3.979000e+05,  6.743000e+05,
         4.575000e+05, -8.240000e+04, -6.990000e+04, -1.177900e+06,
         7.342400e+06,  7.064100e+06,  7.078500e+06,  4.780000e+04,
         1.334000e+05,  7.174900e+06,  7.229700e+06,  7.214400e+06,
         7.453300e+06, -7.700000e+04, -4.894000e+05, -1.873000e+05,
         8.640000e+04, -4.609000e+05, -1.242000e+05, -1.215000e+05,
        -4.530000e+04, -2.010000e+04, -3.173000e+05, -4.804000e+05,
        -4.463000e+05, -2.030000e+05, -3.210000e+05, -1.118000e+05,
        -4.334000e+05, -4.614000e+05, -7.790000e+04, -8.390000e+04,
        -1.487000e+05, -2.219000e+05, -2.219000e+05, -1.943000e+05,
         3.005400e+06,  2.942300e+06, -3.894900e+06, -1.092000e+05,
        -1.094000e+05,  7.181000e+06,  7.185700e+06, -2.390000e+04,
         7.185700e+06,  1.445440e+07,  7.185700e+06, -1.195000e+05,
        -1.195000e+05, -1.195000e+05, -1.205000e+05, -1.200000e+05,
         1.337000e+05,  1.336000e+05,  1.336000e+05,  1.605000e+05,
        -1.130000e+05,  0.000000e+00,  7.570000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  8.018000e+05,  7.786000e+06,  7.479400e+06,
        -1.360000e+04, -2.627000e+05, -2.626000e+05, -6.210000e+05,
        -6.209000e+05,  1.020000e+04,  5.520000e+04,  0.000000e+00,
         3.500000e+03,  1.480000e+04,  1.050000e+04,  8.200000e+03,
         1.571000e+05, -1.163000e+05,  2.640000e+04, -1.000000e+02,
         0.000000e+00, -1.000000e+02,  1.010000e+04,  4.200000e+03,
         1.350000e+04,  2.740000e+04,  2.740000e+04,  2.740000e+04,
         0.000000e+00,  0.000000e+00,  1.616000e+05,  1.707000e+05,
         4.020000e+04,  9.900000e+03,  7.700000e+03,  1.240000e+04,
         3.400000e+03,  4.000000e+03,  8.010000e+04,  1.320000e+04,
         5.790000e+04,  5.790000e+04,  3.600000e+03,  1.290000e+04,
         7.300000e+03,  6.260000e+04,  7.090000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -7.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  3.500000e+03,
         5.520000e+04,  2.060000e+04, -1.000000e+02,  2.640000e+04,
        -1.195000e+05,  0.000000e+00, -1.089000e+05, -8.980000e+04,
        -6.010000e+04, -2.394000e+05, -1.753000e+05,  3.640000e+04,
        -2.390000e+04,  7.185700e+06, -1.094000e+05,  1.336000e+05,
         7.479400e+06,  0.000000e+00,  2.740000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.195000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-9.030000e+04, -3.990000e+04, -3.980000e+04,  5.200000e+03,
        -4.240000e+04, -3.748000e+05, -1.943000e+05, -8.900000e+04,
        -3.990000e+04, -8.870000e+04, -3.980000e+04, -7.250000e+04,
        -4.830000e+04,  7.390000e+04,  0.000000e+00, -7.250000e+04,
        -2.460000e+04, -7.210000e+04, -5.500000e+03, -2.921000e+05,
         0.000000e+00, -1.517000e+05, -6.750000e+04, -7.640000e+04,
         4.000000e+02, -6.100000e+04, -1.278000e+05, -2.268000e+05,
        -7.250000e+04,  6.929200e+06,  6.779800e+06,  6.986200e+06,
        -4.510000e+04,  2.070000e+04,  2.070000e+04,  2.080000e+04,
         1.980000e+04,  6.540000e+04,  2.070000e+04,  1.796000e+05,
         2.904000e+05,  2.799000e+05,  9.000000e+02,  2.720000e+04,
         2.600000e+04, -3.690000e+04,  3.960000e+04,  8.200000e+03,
         8.200000e+03, -2.260000e+04, -5.320000e+04, -2.520000e+04,
        -4.100000e+03, -4.020000e+04, -1.310000e+04, -1.670000e+05,
         7.830000e+04, -6.690000e+04, -1.910000e+04,  3.890000e+04,
        -1.625000e+05, -1.625000e+05, -1.056000e+05, -1.123000e+05,
        -2.219000e+05, -1.361000e+05, -1.073000e+05, -3.224000e+05,
        -2.270000e+04, -7.880000e+04, -4.080000e+04,  1.400000e+04,
        -5.150000e+04, -1.501000e+05, -1.501000e+05, -1.501000e+05,
        -1.501000e+05, -9.300000e+04, -9.300000e+04, -1.700000e+03,
        -9.710000e+04, -7.070000e+04,  5.000000e+03,  0.000000e+00,
        -2.620000e+04, -3.220000e+04,  4.940000e+04, -5.560000e+04,
        -4.110000e+04, -4.110000e+04, -2.430000e+04, -2.430000e+04,
        -2.430000e+04, -4.741000e+05, -3.340000e+05, -1.807000e+05,
        -1.479000e+05, -2.695000e+05, -1.835000e+05, -1.041000e+05,
        -2.464000e+05, -5.792000e+05, -3.795000e+05, -5.792000e+05,
        -3.787000e+05, -2.816000e+05,  1.084000e+05,  2.573000e+05,
         2.224000e+05, -5.450000e+04, -2.760000e+04, -5.235000e+05,
         7.271800e+06,  7.121700e+06,  7.150200e+06,  2.540000e+04,
         6.980000e+04,  7.117700e+06,  7.217800e+06,  7.193000e+06,
         7.268300e+06, -9.420000e+04, -2.850000e+05, -1.858000e+05,
        -3.850000e+04, -3.331000e+05, -5.050000e+04, -6.050000e+04,
        -5.600000e+04, -1.800000e+03, -1.371000e+05, -2.795000e+05,
        -2.007000e+05, -1.302000e+05, -1.386000e+05, -1.155000e+05,
        -1.927000e+05, -2.634000e+05, -3.070000e+04, -2.840000e+04,
        -5.920000e+04, -1.624000e+05, -1.624000e+05, -8.640000e+04,
         3.340700e+06,  3.205400e+06, -2.751200e+06, -4.850000e+04,
        -4.860000e+04,  7.193700e+06,  7.198400e+06, -4.200000e+03,
         7.198400e+06,  1.442970e+07,  7.198400e+06, -5.310000e+04,
        -5.310000e+04, -5.310000e+04, -5.360000e+04, -5.550000e+04,
         6.160000e+04,  6.160000e+04,  6.160000e+04,  6.020000e+04,
        -8.660000e+04,  0.000000e+00,  3.510000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  3.695000e+05,  7.479400e+06,  7.340500e+06,
         1.650000e+04, -1.104000e+05, -1.104000e+05, -2.698000e+05,
        -2.698000e+05,  4.600000e+03,  2.690000e+04,  1.600000e+03,
        -1.360000e+04,  9.000000e+03,  4.700000e+03,  4.200000e+03,
         7.390000e+04, -7.280000e+04,  1.180000e+04,  3.000000e+02,
         0.000000e+00,  0.000000e+00,  3.700000e+03, -1.550000e+04,
         7.600000e+03,  1.230000e+04,  1.230000e+04,  1.230000e+04,
         0.000000e+00,  0.000000e+00,  5.530000e+04,  7.990000e+04,
         1.790000e+04, -2.300000e+03, -2.910000e+04,  7.000000e+03,
        -1.900000e+04, -1.380000e+04,  3.760000e+04,  5.900000e+03,
         2.890000e+04,  2.890000e+04, -1.770000e+04,  5.900000e+03,
         3.100000e+03,  1.200000e+04,  3.490000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.360000e+04,
         2.690000e+04,  9.700000e+03,  3.000000e+02,  1.180000e+04,
        -5.310000e+04,  0.000000e+00, -9.030000e+04, -3.990000e+04,
        -2.430000e+04, -1.501000e+05, -9.710000e+04,  1.990000e+04,
        -4.200000e+03,  7.198400e+06, -4.860000e+04,  6.160000e+04,
         7.340500e+06,  1.600000e+03,  1.230000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -5.310000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-1.425000e+05, -2.450000e+04,  6.700000e+03,  1.195600e+06,
         5.259000e+05, -6.346000e+05, -3.496000e+05, -1.330000e+05,
        -2.450000e+04, -1.312000e+05, -2.390000e+04, -5.530000e+04,
        -3.200000e+03,  1.069800e+06,  0.000000e+00, -5.530000e+04,
         6.135000e+05, -5.480000e+04, -3.000000e+02, -2.202000e+05,
         0.000000e+00,  9.058000e+05,  1.138500e+06,  1.133200e+06,
         3.086300e+06,  1.809200e+06, -2.410000e+04, -1.622000e+05,
         1.855300e+06,  2.217400e+06,  1.089500e+06,  2.343200e+06,
         1.834310e+07,  1.098500e+06,  1.100900e+06,  1.099200e+06,
         1.097100e+06,  1.351200e+06,  1.100600e+06,  9.516400e+06,
         9.835900e+06,  9.819600e+06,  1.015300e+06,  1.090300e+06,
         1.091100e+06,  1.721200e+06,  2.979100e+06,  3.078200e+06,
         3.078600e+06,  2.454500e+06,  1.819700e+06,  2.435100e+06,
         1.824100e+06,  5.452400e+06,  5.528500e+06,  2.408100e+06,
         2.351200e+06,  1.145000e+06,  1.815100e+06,  2.987400e+06,
         2.113700e+06,  2.113500e+06,  2.263100e+06,  2.265300e+06,
        -4.797000e+05, -4.700000e+04, -1.552000e+05, -6.089000e+05,
         6.802000e+05,  6.341000e+05,  2.140000e+04, -3.350000e+04,
         1.400000e+03, -1.111000e+05, -1.111000e+05, -1.111000e+05,
        -1.111000e+05,  3.600000e+03,  3.700000e+03,  1.017800e+06,
         5.725000e+05,  6.302000e+05, -3.000000e+04,  0.000000e+00,
        -6.141000e+05, -5.646000e+05,  1.741800e+06,  1.037600e+06,
         1.560000e+04,  1.560000e+04,  6.181000e+05,  6.179000e+05,
         6.180000e+05,  1.010800e+06,  1.293800e+06,  3.341200e+06,
         2.098500e+06, -1.977000e+05, -3.090000e+04, -3.061000e+05,
        -1.153500e+06, -3.599000e+05,  4.170000e+04, -3.599000e+05,
         4.060000e+04,  1.889700e+06,  4.011200e+06,  5.139600e+06,
         4.255700e+06,  1.045200e+06,  1.121200e+06, -9.530000e+04,
         1.119200e+06, -9.400000e+03,  6.830000e+04,  1.067400e+06,
         2.900000e+06, -2.102000e+05, -2.420000e+04,  1.720000e+04,
         9.187000e+05, -2.652000e+05, -1.355000e+05,  7.332000e+05,
         1.862700e+06, -3.963000e+05,  1.113800e+06,  1.112200e+06,
         2.062200e+06,  2.214500e+06,  1.167300e+06, -1.374000e+05,
         8.740000e+04,  9.904000e+05,  1.184100e+06, -2.539000e+05,
         3.330000e+04, -1.823000e+05,  1.104600e+06,  2.482500e+06,
         1.858400e+06, -2.018000e+05, -2.017000e+05, -2.310000e+04,
         9.271000e+05,  5.465000e+05, -3.118900e+06, -4.000000e+03,
        -4.000000e+03,  4.660000e+04,  4.660000e+04,  1.853000e+06,
         4.640000e+04, -1.035700e+06,  4.660000e+04,  2.810000e+04,
         2.810000e+04,  2.810000e+04,  2.810000e+04,  2.170000e+04,
        -4.020000e+04, -4.010000e+04, -4.010000e+04,  1.007500e+06,
        -1.175000e+05,  0.000000e+00, -3.000000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.409000e+05, -1.360000e+04,  1.650000e+04,
         6.219100e+06,  1.899600e+06,  1.889000e+06,  1.972900e+06,
         1.972600e+06, -3.220000e+04,  5.478000e+05, -2.670000e+04,
        -6.230000e+04, -1.720000e+04, -1.650000e+04,  6.000000e+02,
         1.069800e+06, -5.530000e+04, -5.060000e+04,  1.400000e+03,
         0.000000e+00, -2.000000e+02, -2.820000e+04, -1.098000e+05,
        -3.300000e+04, -6.400000e+03, -6.400000e+03, -6.400000e+03,
         0.000000e+00,  0.000000e+00,  9.897000e+05,  1.064600e+06,
        -6.310000e+04, -3.940000e+04, -1.720000e+05, -3.050000e+04,
        -7.940000e+04, -6.440000e+04,  5.287000e+05, -2.530000e+04,
         5.863000e+05,  5.862000e+05, -8.480000e+04, -1.290000e+04,
        -2.500000e+03,  4.998000e+05,  5.730000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.000000e+02,  1.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -6.230000e+04,
         5.478000e+05,  1.403000e+05,  1.400000e+03, -5.060000e+04,
         2.810000e+04, -2.000000e+02, -1.425000e+05, -2.450000e+04,
         6.179000e+05, -1.111000e+05,  5.725000e+05,  1.097200e+06,
         1.853000e+06,  4.660000e+04, -4.000000e+03, -4.010000e+04,
         1.650000e+04, -2.670000e+04, -6.400000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.810000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.800000e+03,  1.018000e+05,  9.480000e+04,  2.966000e+05,
         1.491000e+05, -4.780000e+04, -5.140000e+04,  9.900000e+03,
         1.018000e+05,  1.150000e+04,  1.017000e+05,  7.790000e+04,
         1.216000e+05,  1.866000e+05,  0.000000e+00,  7.790000e+04,
         2.255000e+05,  7.850000e+04,  1.420000e+04,  3.111000e+05,
         0.000000e+00,  4.176000e+05,  5.903000e+05,  5.603000e+05,
         9.193000e+05,  6.342000e+05,  3.397000e+05,  2.317000e+05,
         6.802000e+05,  1.335700e+06,  1.224700e+06,  1.441200e+06,
         5.323800e+06,  3.399000e+05,  3.408000e+05,  3.404000e+05,
         3.389000e+05,  3.096000e+05,  3.415000e+05,  2.528600e+06,
         2.760700e+06,  2.718800e+06,  2.656000e+05,  3.203000e+05,
         3.131000e+05,  4.458000e+05,  6.657000e+05,  9.546000e+05,
         9.546000e+05,  8.165000e+05,  6.757000e+05,  8.000000e+05,
         6.179000e+05,  1.714400e+06,  1.770400e+06,  1.079900e+06,
         5.118000e+05,  3.754000e+05,  5.233000e+05,  6.672000e+05,
         9.867000e+05,  9.874000e+05,  1.100100e+06,  1.081800e+06,
        -1.625000e+05,  2.100000e+05,  1.660000e+04, -1.535000e+05,
         2.516000e+05,  3.780000e+05,  1.161000e+05, -3.980000e+04,
         1.508000e+05,  1.533000e+05,  1.533000e+05,  1.533000e+05,
         1.533000e+05,  2.551000e+05,  2.552000e+05,  2.648000e+05,
         3.058000e+05,  3.560000e+05, -2.360000e+04,  0.000000e+00,
        -1.495000e+05, -1.167000e+05,  4.309000e+05,  4.834000e+05,
         1.100000e+05,  1.100000e+05,  2.264000e+05,  2.263000e+05,
         2.263000e+05,  9.959000e+05,  1.248800e+06,  1.241700e+06,
         6.626000e+05,  3.353000e+05,  4.849000e+05, -1.419000e+05,
         2.526000e+05,  6.895000e+05,  1.046100e+06,  6.895000e+05,
         1.047100e+06,  9.101000e+05,  7.558000e+05,  8.674000e+05,
         9.646000e+05,  4.186000e+05,  4.744000e+05,  1.406400e+06,
         2.300000e+05,  1.189000e+05,  1.766000e+05,  3.156000e+05,
         7.906000e+05, -1.888000e+05, -3.200000e+04, -4.610000e+04,
        -7.770000e+04, -9.640000e+04,  3.820000e+05,  2.701000e+05,
         3.814000e+05,  1.588000e+05,  5.502000e+05,  5.078000e+05,
         6.838000e+05,  7.958000e+05,  7.907000e+05,  3.828000e+05,
         5.471000e+05,  4.941000e+05,  8.013000e+05, -1.032000e+05,
         5.368000e+05,  3.844000e+05,  4.821000e+05,  8.421000e+05,
         7.040000e+05,  7.360000e+04,  7.370000e+04,  2.308000e+05,
         1.050200e+06,  7.701000e+05,  1.580300e+06,  1.272000e+05,
         1.274000e+05,  4.190000e+04,  4.190000e+04,  6.095000e+05,
         4.260000e+04, -4.103000e+05,  4.190000e+04,  1.533000e+05,
         1.533000e+05,  1.533000e+05,  1.532000e+05,  1.457000e+05,
        -1.602000e+05, -1.601000e+05, -1.601000e+05,  1.324000e+05,
         2.350000e+04,  0.000000e+00, -9.820000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -9.610000e+05, -2.627000e+05, -1.104000e+05,
         1.899600e+06,  1.132000e+06,  9.885000e+05,  1.449800e+06,
         1.450500e+06, -2.520000e+04,  6.590000e+04, -2.500000e+03,
        -5.420000e+04, -1.690000e+04, -1.760000e+04, -8.100000e+03,
         1.866000e+05,  7.780000e+04, -4.640000e+04,  1.300000e+03,
         0.000000e+00,  1.000000e+02, -2.540000e+04, -7.230000e+04,
        -2.140000e+04, -3.490000e+04, -3.500000e+04, -3.500000e+04,
         0.000000e+00,  0.000000e+00,  1.137000e+05,  1.679000e+05,
        -6.720000e+04, -3.790000e+04, -1.264000e+05, -1.980000e+04,
        -7.240000e+04, -5.500000e+04,  8.950000e+04, -2.280000e+04,
         7.190000e+04,  7.190000e+04, -7.130000e+04, -2.050000e+04,
        -1.060000e+04,  1.800000e+03,  5.160000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  7.000000e+02, -2.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -5.420000e+04,
         6.590000e+04,  2.450000e+04,  1.300000e+03, -4.640000e+04,
         1.533000e+05,  7.000000e+02,  1.800000e+03,  1.018000e+05,
         2.263000e+05,  1.533000e+05,  3.058000e+05,  3.390000e+05,
         6.095000e+05,  4.190000e+04,  1.274000e+05, -1.601000e+05,
        -1.104000e+05, -2.500000e+03, -3.500000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.533000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.600000e+03,  1.023000e+05,  9.470000e+04,  2.973000e+05,
         1.493000e+05, -4.770000e+04, -5.100000e+04,  9.700000e+03,
         1.023000e+05,  1.130000e+04,  1.021000e+05,  7.770000e+04,
         1.218000e+05,  1.869000e+05,  0.000000e+00,  7.770000e+04,
         2.257000e+05,  7.840000e+04,  1.420000e+04,  3.105000e+05,
         0.000000e+00,  4.173000e+05,  5.887000e+05,  5.601000e+05,
         9.176000e+05,  6.355000e+05,  3.398000e+05,  2.311000e+05,
         6.812000e+05,  1.335200e+06,  1.223900e+06,  1.441100e+06,
         5.318500e+06,  3.401000e+05,  3.411000e+05,  3.405000e+05,
         3.392000e+05,  3.099000e+05,  3.426000e+05,  2.532000e+06,
         2.762200e+06,  2.722400e+06,  2.666000e+05,  3.208000e+05,
         3.142000e+05,  4.469000e+05,  6.675000e+05,  9.520000e+05,
         9.519000e+05,  8.142000e+05,  6.751000e+05,  7.992000e+05,
         6.344000e+05,  1.712700e+06,  1.768200e+06,  1.079800e+06,
         5.126000e+05,  3.759000e+05,  5.243000e+05,  6.687000e+05,
         9.865000e+05,  9.881000e+05,  1.099400e+06,  1.081800e+06,
        -1.604000e+05,  2.105000e+05,  1.740000e+04, -1.526000e+05,
         2.491000e+05,  3.781000e+05,  1.160000e+05, -3.960000e+04,
         1.510000e+05,  1.529000e+05,  1.529000e+05,  1.529000e+05,
         1.529000e+05,  2.555000e+05,  2.555000e+05,  2.648000e+05,
         3.056000e+05,  3.562000e+05, -2.360000e+04,  0.000000e+00,
        -1.492000e+05, -1.168000e+05,  4.305000e+05,  4.783000e+05,
         1.100000e+05,  1.100000e+05,  2.267000e+05,  2.267000e+05,
         2.267000e+05,  9.956000e+05,  1.250400e+06,  1.240300e+06,
         6.607000e+05,  3.357000e+05,  4.865000e+05, -1.414000e+05,
         2.529000e+05,  6.890000e+05,  1.048100e+06,  6.890000e+05,
         1.049100e+06,  9.104000e+05,  7.560000e+05,  8.679000e+05,
         9.656000e+05,  4.204000e+05,  4.757000e+05,  1.412700e+06,
         2.310000e+05,  1.194000e+05,  1.766000e+05,  3.168000e+05,
         7.900000e+05, -1.882000e+05, -3.070000e+04, -4.540000e+04,
        -7.660000e+04, -9.550000e+04,  3.822000e+05,  2.731000e+05,
         3.848000e+05,  1.615000e+05,  5.507000e+05,  5.111000e+05,
         6.875000e+05,  7.985000e+05,  7.913000e+05,  3.830000e+05,
         5.457000e+05,  4.948000e+05,  8.021000e+05, -1.025000e+05,
         5.381000e+05,  3.863000e+05,  4.837000e+05,  8.410000e+05,
         7.033000e+05,  7.500000e+04,  7.510000e+04,  2.331000e+05,
         1.054500e+06,  7.769000e+05,  1.601300e+06,  1.273000e+05,
         1.275000e+05,  4.170000e+04,  4.180000e+04,  6.059000e+05,
         4.330000e+04, -4.107000e+05,  4.180000e+04,  1.533000e+05,
         1.533000e+05,  1.533000e+05,  1.531000e+05,  1.456000e+05,
        -1.606000e+05, -1.605000e+05, -1.605000e+05,  1.327000e+05,
         2.330000e+04,  0.000000e+00, -9.810000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -9.635000e+05, -2.626000e+05, -1.104000e+05,
         1.889000e+06,  9.885000e+05,  1.145700e+06,  1.608600e+06,
         1.610200e+06, -2.420000e+04,  6.610000e+04, -2.300000e+03,
        -5.430000e+04, -1.660000e+04, -1.750000e+04, -8.100000e+03,
         1.869000e+05,  7.760000e+04, -4.600000e+04,  1.300000e+03,
         0.000000e+00,  1.000000e+02, -2.530000e+04, -7.210000e+04,
        -2.160000e+04, -3.490000e+04, -3.490000e+04, -3.490000e+04,
         0.000000e+00,  0.000000e+00,  1.137000e+05,  1.676000e+05,
        -6.710000e+04, -3.790000e+04, -1.263000e+05, -2.000000e+04,
        -7.270000e+04, -5.420000e+04,  8.990000e+04, -2.220000e+04,
         7.220000e+04,  7.220000e+04, -7.140000e+04, -2.080000e+04,
        -1.060000e+04,  2.000000e+03,  5.150000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.600000e+03, -2.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -5.430000e+04,
         6.610000e+04,  2.450000e+04,  1.300000e+03, -4.600000e+04,
         1.533000e+05,  1.600000e+03,  1.600000e+03,  1.023000e+05,
         2.267000e+05,  1.529000e+05,  3.056000e+05,  3.393000e+05,
         6.059000e+05,  4.180000e+04,  1.275000e+05, -1.605000e+05,
        -1.104000e+05, -2.300000e+03, -3.490000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.533000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 6.170000e+04,  2.544000e+05,  2.222000e+05,  3.170000e+05,
         1.893000e+05,  1.420000e+05,  1.860000e+04,  7.710000e+04,
         2.544000e+05,  8.030000e+04,  2.539000e+05,  2.081000e+05,
         2.923000e+05, -6.460000e+04,  0.000000e+00,  2.081000e+05,
         3.340000e+05,  2.094000e+05,  3.400000e+04,  8.306000e+05,
         0.000000e+00,  5.518000e+05,  8.700000e+05,  7.991000e+05,
         9.865000e+05,  9.124000e+05,  8.224000e+05,  6.173000e+05,
         1.003900e+06,  2.137100e+06,  2.405500e+06,  2.340000e+06,
         5.617700e+06,  2.899000e+05,  2.910000e+05,  2.906000e+05,
         2.881000e+05,  9.580000e+04,  2.932000e+05,  1.489900e+06,
         1.914200e+06,  1.819600e+06,  1.461000e+05,  2.466000e+05,
         2.286000e+05,  5.067000e+05,  6.209000e+05,  9.900000e+05,
         9.899000e+05,  9.563000e+05,  9.212000e+05,  9.252000e+05,
         6.928000e+05,  1.845000e+06,  1.948000e+06,  1.779800e+06,
         2.752000e+05,  5.229000e+05,  6.512000e+05,  6.235000e+05,
         1.345600e+06,  1.347800e+06,  1.556200e+06,  1.510400e+06,
        -1.926000e+05,  5.198000e+05,  1.026000e+05, -1.198000e+05,
         3.619000e+05,  6.872000e+05,  2.684000e+05, -8.350000e+04,
         3.578000e+05,  4.100000e+05,  4.100000e+05,  4.099000e+05,
         4.100000e+05,  6.092000e+05,  6.093000e+05,  1.426000e+05,
         5.397000e+05,  6.374000e+05, -4.430000e+04,  0.000000e+00,
        -6.780000e+04, -1.150000e+04,  2.859000e+05,  7.079000e+05,
         2.559000e+05,  2.559000e+05,  3.339000e+05,  3.338000e+05,
         3.339000e+05,  2.050200e+06,  2.545900e+06,  1.535500e+06,
         7.341000e+05,  8.798000e+05,  1.173300e+06, -2.162000e+05,
         1.151600e+06,  1.789200e+06,  2.486700e+06,  1.789200e+06,
         2.489600e+06,  1.252300e+06, -1.294000e+05, -3.966000e+05,
         2.741000e+05,  4.997000e+05,  6.024000e+05,  3.408400e+06,
         1.940000e+04,  2.879000e+05,  3.942000e+05,  2.449000e+05,
         5.958000e+05, -3.665000e+05, -6.430000e+04, -1.192000e+05,
        -6.351000e+05, -1.217000e+05,  9.656000e+05,  2.715000e+05,
         3.100000e+03,  5.399000e+05,  7.863000e+05,  6.836000e+05,
         6.445000e+05,  8.505000e+05,  1.340400e+06,  9.687000e+05,
         1.270000e+06,  7.010000e+05,  1.357600e+06, -1.447000e+05,
         1.271000e+06,  9.967000e+05,  6.297000e+05,  1.005300e+06,
         9.717000e+05,  2.578000e+05,  2.579000e+05,  5.636000e+05,
         2.078700e+06,  1.563900e+06,  5.039500e+06,  3.056000e+05,
         3.060000e+05,  8.130000e+04,  8.130000e+04,  6.625000e+05,
         8.360000e+04, -4.829000e+05,  8.130000e+04,  3.549000e+05,
         3.549000e+05,  3.549000e+05,  3.546000e+05,  3.389000e+05,
        -3.669000e+05, -3.666000e+05, -3.667000e+05, -1.687000e+05,
         1.035000e+05,  0.000000e+00, -2.222000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.201100e+06, -6.210000e+05, -2.698000e+05,
         1.972900e+06,  1.449800e+06,  1.608600e+06,  2.935300e+06,
         2.680000e+06, -4.640000e+04, -1.880000e+04,  2.900000e+03,
        -1.041000e+05, -3.260000e+04, -3.520000e+04, -2.000000e+04,
        -6.460000e+04,  2.078000e+05, -8.970000e+04,  2.500000e+03,
         0.000000e+00,  2.000000e+02, -5.160000e+04, -1.295000e+05,
        -4.000000e+04, -8.070000e+04, -8.090000e+04, -8.090000e+04,
         0.000000e+00,  0.000000e+00, -2.067000e+05, -1.078000e+05,
        -1.345000e+05, -7.460000e+04, -2.335000e+05, -3.700000e+04,
        -1.412000e+05, -1.046000e+05, -3.810000e+04, -4.360000e+04,
        -1.390000e+04, -1.390000e+04, -1.338000e+05, -4.240000e+04,
        -2.350000e+04, -1.461000e+05, -5.610000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.300000e+03,  1.200000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.041000e+05,
        -1.880000e+04, -8.500000e+03,  2.500000e+03, -8.970000e+04,
         3.549000e+05,  2.300000e+03,  6.170000e+04,  2.544000e+05,
         3.338000e+05,  4.100000e+05,  5.397000e+05,  2.883000e+05,
         6.625000e+05,  8.130000e+04,  3.060000e+05, -3.667000e+05,
        -2.698000e+05,  2.900000e+03, -8.090000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         3.549000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 6.160000e+04,  2.544000e+05,  2.221000e+05,  3.170000e+05,
         1.892000e+05,  1.420000e+05,  1.880000e+04,  7.700000e+04,
         2.543000e+05,  8.020000e+04,  2.539000e+05,  2.080000e+05,
         2.922000e+05, -6.460000e+04,  0.000000e+00,  2.080000e+05,
         3.340000e+05,  2.093000e+05,  3.400000e+04,  8.302000e+05,
         0.000000e+00,  5.515000e+05,  8.699000e+05,  7.989000e+05,
         9.864000e+05,  9.123000e+05,  8.223000e+05,  6.170000e+05,
         1.003800e+06,  2.136600e+06,  2.404900e+06,  2.339500e+06,
         5.619300e+06,  2.899000e+05,  2.909000e+05,  2.906000e+05,
         2.880000e+05,  9.580000e+04,  2.936000e+05,  1.490100e+06,
         1.914600e+06,  1.819900e+06,  1.465000e+05,  2.469000e+05,
         2.289000e+05,  5.067000e+05,  6.210000e+05,  9.901000e+05,
         9.900000e+05,  9.564000e+05,  9.213000e+05,  9.253000e+05,
         6.935000e+05,  1.846300e+06,  1.949300e+06,  1.781100e+06,
         2.752000e+05,  5.229000e+05,  6.512000e+05,  6.235000e+05,
         1.345200e+06,  1.347900e+06,  1.555900e+06,  1.510100e+06,
        -1.916000e+05,  5.201000e+05,  1.030000e+05, -1.193000e+05,
         3.619000e+05,  6.871000e+05,  2.683000e+05, -8.350000e+04,
         3.578000e+05,  4.098000e+05,  4.098000e+05,  4.098000e+05,
         4.098000e+05,  6.091000e+05,  6.092000e+05,  1.425000e+05,
         5.396000e+05,  6.373000e+05, -4.430000e+04,  0.000000e+00,
        -6.790000e+04, -1.150000e+04,  2.858000e+05,  7.078000e+05,
         2.558000e+05,  2.558000e+05,  3.338000e+05,  3.338000e+05,
         3.339000e+05,  2.050200e+06,  2.545900e+06,  1.535600e+06,
         7.342000e+05,  8.798000e+05,  1.173500e+06, -2.160000e+05,
         1.151800e+06,  1.789000e+06,  2.486700e+06,  1.789100e+06,
         2.489600e+06,  1.252200e+06, -1.297000e+05, -3.968000e+05,
         2.739000e+05,  5.004000e+05,  6.031000e+05,  3.410000e+06,
         1.980000e+04,  2.882000e+05,  3.945000e+05,  2.453000e+05,
         5.961000e+05, -3.662000e+05, -6.400000e+04, -1.189000e+05,
        -6.347000e+05, -1.215000e+05,  9.657000e+05,  2.730000e+05,
         4.700000e+03,  5.413000e+05,  7.879000e+05,  6.852000e+05,
         6.460000e+05,  8.520000e+05,  1.340600e+06,  9.689000e+05,
         1.270300e+06,  7.012000e+05,  1.357800e+06, -1.445000e+05,
         1.271300e+06,  9.969000e+05,  6.304000e+05,  1.005700e+06,
         9.720000e+05,  2.585000e+05,  2.586000e+05,  5.644000e+05,
         2.081100e+06,  1.566100e+06,  5.050100e+06,  3.056000e+05,
         3.059000e+05,  8.120000e+04,  8.130000e+04,  6.624000e+05,
         8.400000e+04, -4.829000e+05,  8.130000e+04,  3.548000e+05,
         3.548000e+05,  3.548000e+05,  3.545000e+05,  3.388000e+05,
        -3.669000e+05, -3.666000e+05, -3.667000e+05, -1.688000e+05,
         1.034000e+05,  0.000000e+00, -2.222000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.200900e+06, -6.209000e+05, -2.698000e+05,
         1.972600e+06,  1.450500e+06,  1.610200e+06,  2.680000e+06,
         4.529100e+06, -4.600000e+04, -1.880000e+04,  3.000000e+03,
        -1.041000e+05, -3.260000e+04, -3.520000e+04, -2.000000e+04,
        -6.460000e+04,  2.077000e+05, -8.970000e+04,  2.500000e+03,
         0.000000e+00,  2.000000e+02, -5.160000e+04, -1.295000e+05,
        -4.000000e+04, -8.070000e+04, -8.080000e+04, -8.080000e+04,
         0.000000e+00,  0.000000e+00, -2.068000e+05, -1.078000e+05,
        -1.345000e+05, -7.460000e+04, -2.335000e+05, -3.700000e+04,
        -1.413000e+05, -1.042000e+05, -3.790000e+04, -4.340000e+04,
        -1.390000e+04, -1.390000e+04, -1.338000e+05, -4.240000e+04,
        -2.350000e+04, -1.461000e+05, -5.600000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.700000e+03,  1.200000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.041000e+05,
        -1.880000e+04, -8.500000e+03,  2.500000e+03, -8.970000e+04,
         3.548000e+05,  2.700000e+03,  6.160000e+04,  2.544000e+05,
         3.338000e+05,  4.098000e+05,  5.396000e+05,  2.882000e+05,
         6.624000e+05,  8.130000e+04,  3.059000e+05, -3.667000e+05,
        -2.698000e+05,  3.000000e+03, -8.080000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         3.548000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-7.900000e+03, -5.500000e+03, -5.000000e+03, -6.500000e+03,
        -7.200000e+03, -3.190000e+04, -1.620000e+04, -6.900000e+03,
        -5.500000e+03, -6.700000e+03, -5.500000e+03, -4.100000e+03,
        -3.700000e+03,  6.200000e+03,  0.000000e+00, -4.100000e+03,
        -7.300000e+03, -3.900000e+03, -4.000000e+02, -1.800000e+04,
         0.000000e+00, -1.090000e+04, -1.440000e+04, -7.100000e+03,
        -1.700000e+04, -1.740000e+04, -1.790000e+04, -1.640000e+04,
        -1.930000e+04, -3.830000e+04, -5.100000e+04, -3.990000e+04,
        -9.700000e+04, -1.500000e+03, -1.200000e+03, -1.300000e+03,
        -1.100000e+03,  4.100000e+03, -8.000000e+02,  7.100000e+03,
         4.500000e+03,  1.230000e+04, -2.000000e+02, -2.000000e+02,
         1.000000e+03, -1.390000e+04, -1.310000e+04, -1.560000e+04,
        -1.570000e+04, -1.620000e+04, -1.680000e+04, -1.350000e+04,
        -9.400000e+03, -3.090000e+04, -3.140000e+04, -3.430000e+04,
        -1.400000e+03, -1.330000e+04, -1.290000e+04, -1.270000e+04,
        -2.190000e+04, -2.150000e+04, -2.400000e+04, -1.930000e+04,
        -1.710000e+04, -1.040000e+04, -8.200000e+03, -2.360000e+04,
        -8.700000e+03, -1.410000e+04, -5.800000e+03,  2.200000e+03,
        -7.400000e+03, -1.180000e+04, -1.180000e+04, -1.180000e+04,
        -1.180000e+04, -1.320000e+04, -1.320000e+04,  1.000000e+03,
        -1.250000e+04, -1.210000e+04,  2.405900e+06,  0.000000e+00,
         2.420600e+06,  2.402900e+06, -1.600000e+03, -1.470000e+04,
        -5.600000e+03, -5.600000e+03, -6.400000e+03, -6.400000e+03,
        -6.400000e+03, -4.930000e+04, -5.130000e+04, -2.440000e+04,
         2.257600e+06,  4.790300e+06,  4.840600e+06,  7.140400e+06,
         4.813400e+06, -4.800000e+04, -5.280000e+04, -4.800000e+04,
        -5.350000e+04, -2.380000e+04,  1.450000e+04,  2.700000e+04,
         1.150000e+04, -6.100000e+03, -6.500000e+03, -7.190000e+04,
         5.700000e+03, -6.500000e+03, -7.700000e+03,  2.426400e+06,
        -3.500000e+03,  4.500000e+03,  2.500000e+03,  8.300000e+03,
         1.670000e+04,  2.420700e+06, -2.130000e+04, -1.120000e+04,
         2.300000e+03, -2.460000e+04, -1.360000e+04, -4.700000e+03,
        -4.500000e+03, -5.500000e+03, -2.390000e+04, -2.410000e+04,
        -2.400000e+04, -1.200000e+04, -2.390000e+04,  2.432900e+06,
        -2.710000e+04, -3.100000e+04, -8.000000e+03, -1.740000e+04,
        -1.790000e+04, -1.350000e+04, -1.350000e+04, -1.130000e+04,
        -3.850000e+04, -3.600000e+04, -2.226000e+05,  2.422000e+06,
         2.426200e+06, -1.000000e+03, -1.000000e+03, -1.080000e+04,
        -6.000000e+02,  6.800000e+03, -1.000000e+03, -7.700000e+03,
        -7.700000e+03, -7.700000e+03, -7.600000e+03, -9.000000e+02,
         2.276300e+06,  2.274600e+06,  2.275000e+06,  5.400000e+03,
        -5.100000e+03,  0.000000e+00,  1.396000e+06,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.365520e+07,  1.020000e+04,  4.600000e+03,
        -3.220000e+04, -2.520000e+04, -2.420000e+04, -4.640000e+04,
        -4.600000e+04,  2.468600e+06,  4.000000e+02,  3.000000e+02,
        -7.000000e+02, -1.400000e+03,  7.000000e+02,  4.000000e+02,
         6.200000e+03, -4.300000e+03,  2.000000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.800000e+03, -2.000000e+02,
         1.100000e+03,  1.700000e+03,  1.700000e+03,  1.700000e+03,
         0.000000e+00,  0.000000e+00,  6.700000e+03,  7.100000e+03,
         2.800000e+03,  5.000000e+02, -9.000000e+02,  1.000000e+03,
         8.000000e+02, -4.000000e+02,  3.400000e+03,  1.200000e+03,
         1.000000e+02,  1.000000e+02, -5.000000e+02,  8.000000e+02,
         5.000000e+02, -5.000000e+02,  9.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  4.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.000000e+02, -7.000000e+02,
         4.000000e+02,  8.000000e+02,  0.000000e+00,  2.000000e+03,
        -7.700000e+03,  4.000000e+02, -7.900000e+03, -5.500000e+03,
        -6.400000e+03, -1.180000e+04, -1.250000e+04, -1.200000e+03,
        -1.080000e+04, -1.000000e+03,  2.426200e+06,  2.275100e+06,
         4.600000e+03,  3.000000e+02,  1.700000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -7.700000e+03,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-2.300000e+04, -2.390000e+04, -1.660000e+04,  3.278000e+05,
         1.531000e+05, -9.190000e+04, -4.590000e+04, -2.430000e+04,
        -2.390000e+04, -2.450000e+04, -2.390000e+04, -2.590000e+04,
        -2.540000e+04,  8.100000e+03,  0.000000e+00, -2.590000e+04,
         1.548000e+05, -2.600000e+04, -3.000000e+03, -1.040000e+05,
         0.000000e+00, -6.900000e+04, -7.160000e+04, -5.910000e+04,
         4.400000e+05,  4.413000e+05, -7.560000e+04, -7.720000e+04,
         4.402000e+05, -1.783000e+05, -2.120000e+05, -1.794000e+05,
         2.817900e+06, -2.020000e+04, -2.030000e+04, -2.030000e+04,
        -2.010000e+04, -4.000000e+03, -2.020000e+04, -1.290000e+05,
        -1.326000e+05, -1.159000e+05, -1.760000e+04, -1.820000e+04,
        -1.430000e+04,  4.811000e+05,  8.371000e+05,  2.701000e+05,
         2.701000e+05,  2.689000e+05,  2.690000e+05,  2.736000e+05,
         1.229000e+05,  5.402000e+05,  5.395000e+05,  5.337000e+05,
         3.263000e+05,  3.005000e+05,  4.749000e+05,  8.366000e+05,
        -1.201000e+05, -1.201000e+05, -1.218000e+05, -1.135000e+05,
        -4.550000e+04, -5.140000e+04, -2.940000e+04, -7.700000e+04,
         1.366000e+05,  1.398000e+05, -2.150000e+04, -9.000000e+02,
        -3.610000e+04, -5.130000e+04, -5.130000e+04, -5.130000e+04,
        -5.130000e+04, -5.230000e+04, -5.230000e+04, -1.770000e+04,
         1.197000e+05,  1.193000e+05,  0.000000e+00,  0.000000e+00,
        -1.900000e+03, -4.000000e+03,  1.520000e+05,  3.150000e+04,
        -2.000000e+04, -2.000000e+04,  1.468000e+05,  1.468000e+05,
         1.469000e+05,  1.341000e+05,  1.320000e+05,  1.997000e+05,
         2.489000e+05, -1.050000e+05, -1.059000e+05, -2.090000e+04,
        -1.121000e+05, -2.078000e+05, -2.111000e+05, -2.078000e+05,
        -2.112000e+05, -1.403000e+05, -1.430000e+04,  1.930000e+04,
        -1.650000e+04, -4.580000e+04, -4.650000e+04, -3.065000e+05,
         6.600000e+03, -2.710000e+04, -2.800000e+04, -1.990000e+04,
         1.309000e+05,  6.400000e+03,  5.000000e+03,  1.630000e+04,
         4.010000e+04, -2.000000e+04, -1.053000e+05, -6.360000e+04,
        -3.000000e+04, -9.720000e+04, -6.720000e+04, -4.720000e+04,
        -6.330000e+04, -6.470000e+04, -1.040000e+05, -1.051000e+05,
        -1.069000e+05, -7.150000e+04, -1.052000e+05, -1.980000e+04,
        -1.067000e+05, -1.050000e+05, -4.700000e+04,  2.670000e+05,
         2.659000e+05, -4.720000e+04, -4.720000e+04, -5.000000e+04,
        -1.686000e+05, -1.650000e+05, -8.340000e+05, -2.790000e+04,
        -2.800000e+04, -1.400000e+03, -1.400000e+03,  1.223000e+05,
        -1.400000e+03,  4.570000e+04, -1.400000e+03, -2.830000e+04,
        -2.830000e+04, -2.830000e+04, -2.830000e+04, -2.750000e+04,
         2.590000e+04,  2.590000e+04,  2.590000e+04,  8.000000e+03,
        -2.600000e+04,  0.000000e+00,  1.600000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.555000e+05,  5.520000e+04,  2.690000e+04,
         5.478000e+05,  6.590000e+04,  6.610000e+04, -1.880000e+04,
        -1.880000e+04,  4.000000e+02,  2.260000e+05, -7.800000e+03,
        -1.000000e+02,  1.200000e+03,  1.100000e+03,  2.300000e+03,
         8.100000e+03, -2.590000e+04,  2.600000e+03,  0.000000e+00,
         0.000000e+00, -3.000000e+02, -1.500000e+03, -5.600000e+03,
        -6.000000e+03,  6.500000e+03,  6.500000e+03,  6.500000e+03,
         0.000000e+00,  0.000000e+00,  1.050000e+04,  9.900000e+03,
         4.300000e+03,  1.500000e+03, -5.700000e+03, -5.500000e+03,
         2.400000e+03,  1.000000e+02,  4.600000e+03,  1.300000e+03,
         1.808000e+05,  1.807000e+05,  4.000000e+02, -2.000000e+02,
         1.200000e+03,  1.783000e+05,  1.802000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.800000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.000000e+02,
         2.260000e+05,  1.100000e+03,  0.000000e+00,  2.600000e+03,
        -2.830000e+04,  0.000000e+00, -2.300000e+04, -2.390000e+04,
         1.468000e+05, -5.130000e+04,  1.197000e+05, -2.020000e+04,
         1.223000e+05, -1.400000e+03, -2.800000e+04,  2.590000e+04,
         2.690000e+04, -7.800000e+03,  6.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -2.830000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-1.030000e+04, -2.670000e+04, -9.900000e+03, -1.460000e+04,
        -1.240000e+04, -4.700000e+04, -2.640000e+04, -1.020000e+04,
        -2.670000e+04, -1.020000e+04, -2.670000e+04, -4.300000e+03,
        -1.260000e+04,  1.300000e+03,  0.000000e+00, -4.300000e+03,
        -6.400000e+03, -4.300000e+03, -1.400000e+03, -1.730000e+04,
         0.000000e+00, -1.190000e+04, -4.420000e+04, -5.990000e+04,
        -2.120000e+04, -4.510000e+04, -6.340000e+04, -1.310000e+04,
        -1.930000e+04,  6.000000e+03,  5.000000e+02, -1.150000e+04,
        -1.468000e+05,  3.100000e+03,  3.100000e+03,  3.200000e+03,
         3.100000e+03,  2.500000e+03,  3.100000e+03,  5.000000e+02,
        -4.250000e+04, -6.360000e+04, -3.000000e+03, -1.380000e+04,
        -1.900000e+04, -2.700000e+04, -3.730000e+04, -1.350000e+04,
        -1.350000e+04, -2.510000e+04, -3.690000e+04, -3.410000e+04,
        -5.600000e+03, -3.190000e+04, -4.270000e+04, -1.006000e+05,
        -1.470000e+04, -1.890000e+04, -2.110000e+04, -3.730000e+04,
        -9.000000e+02, -9.000000e+02, -2.120000e+04, -3.290000e+04,
        -3.800000e+04, -2.900000e+03, -1.230000e+04, -5.370000e+04,
         4.850000e+05, -4.600000e+03,  1.500000e+03,  4.984000e+05,
         5.005000e+05, -8.700000e+03, -8.700000e+03, -8.700000e+03,
        -8.700000e+03, -2.490000e+04, -2.490000e+04, -3.200000e+03,
        -1.090000e+04, -1.900000e+04,  3.000000e+02,  0.000000e+00,
        -1.210000e+04, -3.000000e+02, -6.200000e+03, -3.200000e+03,
        -3.700000e+03, -3.700000e+03, -6.500000e+03, -6.500000e+03,
        -6.500000e+03, -3.320000e+04, -7.370000e+04, -2.370000e+04,
        -3.390000e+04, -1.080000e+04, -3.510000e+04, -1.590000e+04,
        -6.430000e+04, -2.880000e+04, -8.560000e+04, -2.880000e+04,
        -8.550000e+04, -1.750000e+04, -1.590000e+04, -1.040000e+04,
        -5.010000e+04, -1.300000e+03, -1.210000e+04, -2.277000e+05,
         4.600000e+03, -1.100000e+03, -1.190000e+04,  3.400000e+03,
        -4.400000e+03, -1.480000e+04, -4.050000e+04, -6.290000e+04,
        -9.200000e+03, -1.580000e+04, -1.150000e+04, -2.390000e+04,
        -1.830000e+04, -2.940000e+04, -7.780000e+04, -1.039000e+05,
        -4.300000e+03, -2.590000e+04,  8.200000e+03, -1.140000e+04,
        -4.380000e+04, -5.700000e+03,  8.400000e+03, -1.630000e+04,
        -3.570000e+04, -9.300000e+03,  4.700000e+03, -1.280000e+04,
        -2.440000e+04, -1.450000e+04, -1.450000e+04, -3.920000e+04,
        -6.370000e+04, -9.800000e+03, -2.312000e+05,  2.000000e+03,
         2.000000e+03,  3.300000e+03,  3.300000e+03, -6.200000e+03,
         3.300000e+03,  1.800000e+03,  3.300000e+03,  1.700000e+03,
         1.700000e+03,  1.700000e+03,  1.700000e+03,  1.600000e+03,
        -1.700000e+03, -1.700000e+03, -1.700000e+03, -4.500000e+03,
        -1.010000e+04,  0.000000e+00, -8.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+04,  0.000000e+00,  1.600000e+03,
        -2.670000e+04, -2.500000e+03, -2.300000e+03,  2.900000e+03,
         3.000000e+03,  3.000000e+02, -7.800000e+03,  4.987000e+05,
        -5.800000e+03, -1.410000e+04, -1.040000e+04, -2.500000e+03,
         1.300000e+03, -4.300000e+03, -2.420000e+04,  1.000000e+02,
         0.000000e+00,  2.000000e+02,  3.854000e+05,  4.879000e+05,
         4.809000e+05, -4.000000e+02, -4.000000e+02, -4.000000e+02,
         0.000000e+00,  0.000000e+00, -4.900000e+03, -1.550000e+04,
        -3.990000e+04, -1.030000e+04,  4.820000e+05,  4.447000e+05,
        -6.100000e+03, -5.800000e+03,  6.000000e+02, -1.210000e+04,
        -8.100000e+03, -8.100000e+03, -6.400000e+03, -1.520000e+04,
        -2.500000e+03, -1.440000e+04, -2.330000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -5.800000e+03,
        -7.800000e+03,  2.000000e+02,  1.000000e+02, -2.420000e+04,
         1.700000e+03,  0.000000e+00, -1.030000e+04, -2.670000e+04,
        -6.500000e+03, -8.700000e+03, -1.090000e+04,  3.100000e+03,
        -6.200000e+03,  3.300000e+03,  2.000000e+03, -1.700000e+03,
         1.600000e+03,  4.987000e+05, -4.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.700000e+03,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 9.720000e+04, -1.240000e+04, -1.710000e+04, -1.470000e+04,
         4.130000e+04,  4.548000e+05,  2.604000e+05,  1.010000e+05,
        -1.240000e+04,  1.017000e+05, -1.230000e+04,  4.050000e+04,
        -1.720000e+04,  1.120000e+04,  0.000000e+00,  4.050000e+04,
        -1.610000e+04,  4.080000e+04, -1.900000e+03,  1.615000e+05,
         0.000000e+00,  1.307000e+05, -3.240000e+04, -4.010000e+04,
        -3.550000e+04, -4.350000e+04, -3.950000e+04,  1.183000e+05,
        -4.820000e+04, -1.150000e+04,  1.710000e+04, -1.202000e+05,
        -1.058000e+05, -5.400000e+03, -5.400000e+03, -5.400000e+03,
        -5.500000e+03,  5.600000e+03, -5.400000e+03,  2.023000e+05,
        -1.530000e+04, -2.550000e+04,  5.140000e+04, -3.200000e+03,
        -5.600000e+03,  2.670000e+04, -2.880000e+04, -3.090000e+04,
        -3.090000e+04, -3.480000e+04, -3.870000e+04, -3.710000e+04,
        -2.100000e+04, -1.080000e+04, -6.530000e+04, -8.460000e+04,
        -3.300000e+03,  2.530000e+04, -3.050000e+04, -2.940000e+04,
         5.250000e+04,  5.240000e+04, -5.640000e+04, -6.150000e+04,
         3.919000e+05,  1.350000e+04,  1.228000e+05,  5.859000e+05,
        -2.120000e+04, -3.310000e+04, -1.300000e+04, -2.200000e+03,
        -2.240000e+04,  7.970000e+04,  7.970000e+04,  7.970000e+04,
         7.970000e+04, -2.900000e+04, -2.900000e+04,  5.110000e+04,
         2.390000e+04, -3.070000e+04, -7.000000e+02,  0.000000e+00,
        -4.500000e+03, -6.900000e+03, -4.400000e+03, -2.710000e+04,
        -1.490000e+04, -1.490000e+04, -1.580000e+04, -1.570000e+04,
        -1.580000e+04,  1.504000e+05, -1.214000e+05,  9.320000e+04,
         1.725000e+05,  1.010000e+05, -6.150000e+04,  1.499000e+05,
        -6.940000e+04,  2.619000e+05, -1.183000e+05,  2.619000e+05,
        -1.180000e+05,  2.051000e+05,  2.390000e+05,  2.105000e+05,
         2.160000e+04,  3.430000e+04, -2.020000e+04, -1.631000e+05,
        -1.950000e+04,  9.100000e+03, -4.530000e+04, -6.100000e+03,
        -9.800000e+03,  1.383000e+05, -2.440000e+04, -3.250000e+04,
         1.098000e+05,  1.547000e+05,  1.020000e+05,  2.449000e+05,
         2.162000e+05,  2.737000e+05, -2.750000e+04, -3.980000e+04,
         8.520000e+04, -2.380000e+04, -5.460000e+04,  1.025000e+05,
        -6.130000e+04,  7.400000e+04, -5.520000e+04,  1.516000e+05,
        -6.010000e+04,  1.093000e+05, -2.130000e+04, -3.660000e+04,
        -4.040000e+04,  1.327000e+05,  1.327000e+05, -2.690000e+04,
        -1.045000e+05,  1.679000e+05,  2.157800e+06, -1.730000e+04,
        -1.730000e+04, -3.070000e+04, -3.070000e+04, -2.090000e+04,
        -3.070000e+04, -3.940000e+04, -3.070000e+04, -1.660000e+04,
        -1.660000e+04, -1.660000e+04, -1.660000e+04, -2.010000e+04,
         1.570000e+04,  1.560000e+04,  1.560000e+04,  7.820000e+04,
         1.074000e+05,  0.000000e+00,  1.120000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  9.390000e+04,  3.500000e+03, -1.360000e+04,
        -6.230000e+04, -5.420000e+04, -5.430000e+04, -1.041000e+05,
        -1.041000e+05, -7.000000e+02, -1.000000e+02, -5.800000e+03,
         6.700000e+04,  6.300000e+03,  1.500000e+03,  2.300000e+03,
         1.120000e+04,  4.040000e+04,  3.600000e+03, -1.000000e+03,
         0.000000e+00,  0.000000e+00, -5.100000e+03,  5.190000e+04,
        -3.800000e+03,  3.900000e+03,  3.900000e+03,  3.900000e+03,
         0.000000e+00,  0.000000e+00,  6.830000e+04,  1.330000e+04,
         5.600000e+03,  1.950000e+04,  1.188000e+05, -3.500000e+03,
         5.590000e+04,  6.600000e+04,  5.900000e+03,  1.800000e+03,
         5.000000e+02,  5.000000e+02,  5.830000e+04,  1.800000e+03,
         6.000000e+02,  5.850000e+04,  2.300000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  6.700000e+04,
        -1.000000e+02,  1.500000e+03, -1.000000e+03,  3.600000e+03,
        -1.660000e+04,  0.000000e+00,  9.720000e+04, -1.240000e+04,
        -1.570000e+04,  7.970000e+04,  2.390000e+04, -5.500000e+03,
        -2.090000e+04, -3.070000e+04, -1.730000e+04,  1.560000e+04,
        -1.360000e+04, -5.800000e+03,  3.900000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.660000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-1.680000e+04,  1.730000e+05, -1.040000e+04, -8.000000e+02,
        -8.700000e+03, -6.190000e+04, -2.830000e+04, -4.160000e+04,
         1.759000e+05, -4.730000e+04,  2.270000e+05, -4.160000e+04,
         3.379000e+05,  5.000000e+03,  0.000000e+00, -4.160000e+04,
         6.200000e+03, -4.800000e+04,  2.470000e+04, -1.440000e+05,
         0.000000e+00, -2.920000e+04,  2.364000e+05, -1.780000e+04,
        -7.100000e+03,  1.410000e+05,  4.362000e+05, -3.420000e+04,
        -1.010000e+04, -3.590000e+04, -5.220000e+04,  1.512000e+05,
        -5.550000e+04, -5.000000e+02, -6.000000e+02, -2.000000e+02,
        -5.000000e+02,  3.500000e+03, -6.000000e+02, -2.030000e+04,
         3.331000e+05, -5.100000e+03, -6.300000e+03,  8.220000e+04,
        -2.500000e+03, -9.300000e+03,  9.000000e+02, -8.500000e+03,
        -8.600000e+03,  6.650000e+04,  1.409000e+05, -1.060000e+04,
        -5.800000e+03, -2.320000e+04,  6.530000e+04,  4.404000e+05,
         3.600000e+03, -1.220000e+04, -4.200000e+03,  4.000000e+02,
        -2.860000e+04, -2.860000e+04,  1.512000e+05, -2.100000e+04,
        -1.820000e+04, -3.090000e+04, -1.250000e+04,  2.920000e+04,
        -1.900000e+04, -4.300000e+03, -4.700000e+03, -1.350000e+04,
        -1.940000e+04, -2.280000e+04, -2.280000e+04, -2.280000e+04,
        -2.280000e+04,  1.677000e+05,  1.677000e+05, -6.300000e+03,
        -1.540000e+04,  7.960000e+04, -1.400000e+03,  0.000000e+00,
         7.280000e+04, -3.900000e+03,  1.000000e+03, -1.070000e+04,
        -6.800000e+03, -6.800000e+03, -3.400000e+03, -3.400000e+03,
        -3.400000e+03, -7.050000e+04,  4.054000e+05, -3.910000e+04,
        -3.940000e+04, -4.240000e+04,  2.433000e+05, -2.790000e+04,
         3.723000e+05, -8.510000e+04,  5.814000e+05, -8.510000e+04,
         5.815000e+05, -5.200000e+04, -1.350000e+04,  3.000000e+03,
         3.628000e+05, -1.200000e+04,  7.650000e+04,  1.455200e+06,
         8.200000e+03, -8.100000e+03,  8.050000e+04, -1.900000e+03,
        -1.200000e+03, -1.470000e+04,  2.680000e+05, -3.300000e+03,
         1.500000e+03, -2.300000e+04, -4.010000e+04, -4.010000e+04,
        -2.380000e+04, -5.650000e+04,  4.024000e+05, -2.110000e+04,
        -1.870000e+04,  1.583000e+05, -1.610000e+04, -3.960000e+04,
         2.258000e+05, -2.350000e+04, -1.630000e+04, -2.510000e+04,
         2.462000e+05, -7.600000e+03, -5.500000e+03, -9.400000e+03,
         6.560000e+04, -3.050000e+04, -3.050000e+04,  2.568000e+05,
         4.002000e+05, -4.230000e+04, -4.616000e+05, -6.800000e+03,
        -6.800000e+03,  3.300000e+03,  3.300000e+03, -6.500000e+03,
         3.300000e+03,  1.270000e+04,  3.300000e+03, -5.300000e+03,
        -5.300000e+03, -5.300000e+03, -5.600000e+03, -5.000000e+04,
         4.000000e+03,  4.000000e+03,  4.000000e+03,  1.230000e+04,
        -3.020000e+04,  0.000000e+00,  2.820000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.390000e+04,  1.480000e+04,  9.000000e+03,
        -1.720000e+04, -1.690000e+04, -1.660000e+04, -3.260000e+04,
        -3.260000e+04, -1.400000e+03,  1.200000e+03, -1.410000e+04,
         6.300000e+03,  4.735000e+05,  6.150000e+04,  1.700000e+03,
         5.000000e+03, -3.860000e+04,  1.525000e+05,  1.000000e+02,
         0.000000e+00, -1.100000e+03, -1.430000e+04, -1.680000e+04,
         6.710000e+04,  1.400000e+03,  1.400000e+03,  1.400000e+03,
         0.000000e+00,  0.000000e+00, -5.000000e+02,  8.750000e+04,
         2.351000e+05,  4.530000e+04, -1.050000e+04,  6.200000e+04,
        -5.500000e+03,  5.300000e+03,  2.500000e+03,  7.610000e+04,
         2.300000e+03,  2.300000e+03, -3.000000e+03,  8.150000e+04,
        -1.000000e+02, -7.000000e+02,  8.390000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  6.300000e+03,
         1.200000e+03,  7.000000e+02,  1.000000e+02,  1.525000e+05,
        -5.300000e+03,  0.000000e+00, -1.680000e+04,  1.730000e+05,
        -3.400000e+03, -2.280000e+04, -1.540000e+04, -5.000000e+02,
        -6.500000e+03,  3.300000e+03, -6.800000e+03,  4.000000e+03,
         9.000000e+03, -1.410000e+04,  1.400000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -5.300000e+03,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-1.800000e+03,  1.178000e+05, -3.500000e+03, -3.500000e+03,
        -2.700000e+03, -5.800000e+03, -2.100000e+03, -2.000000e+03,
         1.178000e+05, -2.100000e+03,  1.175000e+05, -3.900000e+03,
         5.600000e+04,  5.000000e+03,  0.000000e+00, -3.900000e+03,
        -4.700000e+03, -3.900000e+03,  6.500000e+03, -1.540000e+04,
         0.000000e+00, -6.400000e+03,  1.694000e+05, -7.900000e+03,
        -9.000000e+03,  1.259000e+05,  3.076000e+05, -1.140000e+04,
        -1.400000e+04, -2.790000e+04, -3.670000e+04,  9.110000e+04,
        -5.120000e+04, -9.000000e+02, -1.000000e+03, -7.000000e+02,
        -9.000000e+02,  3.300000e+03, -1.000000e+03,  8.700000e+03,
         2.432000e+05,  6.700000e+03,  1.100000e+03,  5.980000e+04,
         6.000000e+02, -6.200000e+03, -6.000000e+03, -8.100000e+03,
        -8.100000e+03,  5.960000e+04,  1.271000e+05, -8.600000e+03,
        -5.800000e+03, -1.630000e+04,  4.230000e+04,  3.808000e+05,
         1.700000e+03, -7.300000e+03, -8.200000e+03, -6.100000e+03,
        -1.520000e+04, -1.520000e+04,  1.027000e+05, -1.610000e+04,
         9.000000e+02, -9.100000e+03, -2.500000e+03, -1.000000e+03,
        -1.510000e+04, -1.050000e+04, -4.500000e+03, -9.000000e+03,
        -1.630000e+04, -7.600000e+03, -7.600000e+03, -7.600000e+03,
        -7.600000e+03,  1.120000e+05,  1.120000e+05,  1.200000e+03,
        -8.400000e+03,  5.140000e+04,  7.000000e+02,  0.000000e+00,
         6.830000e+04, -1.800000e+03,  3.000000e+02, -9.100000e+03,
        -4.100000e+03, -4.100000e+03, -4.700000e+03, -4.700000e+03,
        -4.700000e+03, -3.410000e+04,  2.648000e+05, -1.680000e+04,
        -7.800000e+03, -1.590000e+04,  1.635000e+05,  2.300000e+03,
         3.087000e+05, -3.240000e+04,  3.860000e+05, -3.240000e+04,
         3.860000e+05, -1.470000e+04,  1.630000e+04,  2.510000e+04,
         2.547000e+05, -4.800000e+03,  5.390000e+04,  1.095200e+06,
         3.900000e+03, -4.800000e+03,  5.380000e+04, -2.000000e+02,
        -9.000000e+02,  5.100000e+03,  1.839000e+05,  3.600000e+03,
         1.380000e+04,  8.000000e+02, -1.720000e+04, -2.400000e+03,
         6.400000e+03, -1.110000e+04,  2.910000e+05, -4.900000e+03,
        -3.600000e+03,  1.137000e+05, -1.830000e+04, -1.720000e+04,
         1.589000e+05, -8.500000e+03, -1.840000e+04,  1.100000e+03,
         1.621000e+05, -2.360000e+04, -6.500000e+03, -1.040000e+04,
         5.730000e+04, -5.400000e+03, -5.400000e+03,  1.738000e+05,
         2.714000e+05, -2.190000e+04, -1.015000e+05, -5.100000e+03,
        -5.100000e+03, -1.100000e+03, -1.100000e+03, -5.900000e+03,
        -1.100000e+03,  4.600000e+03, -1.100000e+03, -5.900000e+03,
        -5.900000e+03, -5.900000e+03, -5.900000e+03, -5.700000e+03,
         6.100000e+03,  6.100000e+03,  6.100000e+03,  6.400000e+03,
        -2.400000e+03,  0.000000e+00,  3.700000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  3.640000e+04,  1.050000e+04,  4.700000e+03,
        -1.650000e+04, -1.760000e+04, -1.750000e+04, -3.520000e+04,
        -3.520000e+04,  7.000000e+02,  1.100000e+03, -1.040000e+04,
         1.500000e+03,  6.150000e+04,  7.030000e+04,  4.000000e+02,
         5.000000e+03, -3.800000e+03,  1.401000e+05,  0.000000e+00,
         0.000000e+00,  6.000000e+02, -8.000000e+03, -8.500000e+03,
         4.930000e+04,  1.300000e+03,  1.300000e+03,  1.300000e+03,
         0.000000e+00,  0.000000e+00,  7.000000e+03,  6.570000e+04,
         2.053000e+05,  4.700000e+04, -7.000000e+03,  4.560000e+04,
         2.000000e+03,  1.500000e+03,  2.600000e+03,  6.990000e+04,
         1.100000e+03,  1.100000e+03,  1.800000e+03,  6.370000e+04,
         4.000000e+02,  2.900000e+03,  6.480000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.500000e+03,
         1.100000e+03,  7.000000e+02,  0.000000e+00,  1.401000e+05,
        -5.900000e+03,  0.000000e+00, -1.800000e+03,  1.178000e+05,
        -4.700000e+03, -7.600000e+03, -8.400000e+03, -9.000000e+02,
        -5.900000e+03, -1.100000e+03, -5.100000e+03,  6.100000e+03,
         4.700000e+03, -1.040000e+04,  1.300000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -5.900000e+03,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-5.000000e+03, -2.800000e+03,  2.078000e+05,  1.400000e+03,
        -1.800000e+03, -1.790000e+04, -7.900000e+03, -3.900000e+03,
        -2.800000e+03, -3.700000e+03, -2.800000e+03, -4.400000e+03,
        -4.200000e+03,  5.200000e+03,  0.000000e+00, -4.400000e+03,
        -1.400000e+03, -4.300000e+03, -5.000000e+02, -1.760000e+04,
         0.000000e+00, -8.100000e+03, -5.000000e+03,  3.009000e+05,
         1.200000e+03, -2.900000e+03, -9.100000e+03, -1.340000e+04,
        -4.000000e+03, -1.810000e+04, -2.780000e+04, -1.600000e+04,
         6.400000e+03,  1.200000e+03,  1.200000e+03,  1.200000e+03,
         1.200000e+03,  4.500000e+03,  1.200000e+03,  1.510000e+04,
         1.930000e+04,  4.271000e+05,  8.000000e+02,  1.800000e+03,
         1.038000e+05, -4.000000e+02,  3.600000e+03,  1.200000e+03,
         1.200000e+03, -9.000000e+02, -3.000000e+03,  1.011000e+05,
        -1.000000e+02, -7.000000e+02,  4.000000e+02, -1.020000e+04,
         6.500000e+03, -3.100000e+03,  0.000000e+00,  1.800000e+03,
        -1.030000e+04, -1.030000e+04, -8.300000e+03,  1.957000e+05,
        -3.900000e+03, -1.100000e+04, -4.100000e+03,  2.200000e+03,
        -3.800000e+03, -5.600000e+03, -3.200000e+03, -1.700000e+03,
        -6.500000e+03, -8.900000e+03, -8.900000e+03, -8.900000e+03,
        -8.900000e+03, -6.800000e+03, -6.800000e+03,  8.000000e+02,
        -5.900000e+03, -4.800000e+03,  4.000000e+02,  0.000000e+00,
        -1.700000e+03, -2.200000e+03,  3.900000e+03, -4.000000e+03,
         9.920000e+04,  9.920000e+04, -1.300000e+03, -1.300000e+03,
        -1.300000e+03, -2.910000e+04, -2.390000e+04, -9.600000e+03,
        -7.300000e+03, -1.650000e+04, -1.340000e+04, -4.300000e+03,
        -1.760000e+04, -3.530000e+04, -2.790000e+04, -3.530000e+04,
        -2.790000e+04, -1.570000e+04,  1.130000e+04,  2.100000e+04,
         1.550000e+04, -3.200000e+03, -2.200000e+03, -3.790000e+04,
         5.500000e+03, -4.200000e+03, -3.100000e+03,  1.700000e+03,
         5.100000e+03, -1.200000e+03,  2.000000e+03,  3.078000e+05,
         8.500000e+03, -5.100000e+03, -1.740000e+04, -9.100000e+03,
         7.000000e+02, -1.890000e+04, -3.800000e+03,  5.059000e+05,
        -2.500000e+03, -3.000000e+02, -1.060000e+04, -1.740000e+04,
        -1.410000e+04, -7.700000e+03, -1.070000e+04, -4.900000e+03,
        -1.420000e+04, -1.580000e+04, -2.600000e+03, -1.400000e+03,
        -3.500000e+03, -1.000000e+04, -1.000000e+04, -6.300000e+03,
        -1.900000e+04, -2.430000e+04, -1.592000e+05, -3.500000e+03,
        -3.500000e+03,  3.000000e+02,  3.000000e+02, -1.000000e+02,
         3.000000e+02,  3.300000e+03,  3.000000e+02, -4.000000e+03,
        -4.000000e+03, -4.000000e+03, -4.000000e+03, -4.900000e+03,
         4.100000e+03,  4.100000e+03,  4.100000e+03,  7.500000e+03,
        -2.100000e+03,  0.000000e+00,  3.100000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.480000e+04,  8.200000e+03,  4.200000e+03,
         6.000000e+02, -8.100000e+03, -8.100000e+03, -2.000000e+04,
        -2.000000e+04,  4.000000e+02,  2.300000e+03, -2.500000e+03,
         2.300000e+03,  1.700000e+03,  4.000000e+02,  1.570000e+05,
         5.200000e+03, -4.400000e+03,  1.000000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  8.100000e+04, -2.300000e+03,
        -1.900000e+03,  1.000000e+03,  1.000000e+03,  1.000000e+03,
         0.000000e+00,  0.000000e+00,  4.800000e+03,  5.800000e+03,
         1.600000e+03,  2.000000e+02,  0.000000e+00, -1.800000e+03,
        -4.000000e+02,  2.100000e+03,  2.700000e+03,  5.000000e+02,
         9.000000e+02,  9.000000e+02, -1.700000e+03, -1.200000e+03,
         9.250000e+04, -8.000000e+02, -3.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.800000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.300000e+03,
         2.300000e+03,  7.000000e+02,  0.000000e+00,  1.000000e+03,
        -4.000000e+03,  0.000000e+00, -5.000000e+03, -2.800000e+03,
        -1.300000e+03, -8.900000e+03, -5.900000e+03,  1.200000e+03,
        -1.000000e+02,  3.000000e+02, -3.500000e+03,  4.100000e+03,
         4.200000e+03, -2.500000e+03,  1.000000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -4.000000e+03,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-5.080000e+04, -6.960000e+04, -5.530000e+04, -6.660000e+04,
        -5.860000e+04, -1.916000e+05, -9.010000e+04, -5.270000e+04,
        -6.960000e+04, -5.310000e+04, -6.950000e+04, -6.730000e+04,
        -7.520000e+04,  5.187000e+05,  0.000000e+00, -6.730000e+04,
        -7.480000e+04, -6.750000e+04, -8.700000e+03, -2.689000e+05,
         0.000000e+00,  3.168000e+05,  2.828000e+05,  3.084000e+05,
         2.844000e+05, -2.117000e+05, -2.164000e+05, -2.013000e+05,
        -2.247000e+05,  4.721000e+05, -1.116000e+05,  4.520000e+05,
         1.495700e+06,  4.342000e+05,  4.342000e+05,  4.337000e+05,
         4.352000e+05,  6.066000e+05,  4.342000e+05,  4.103500e+06,
         4.054400e+06,  4.092300e+06,  4.505000e+05,  4.393000e+05,
         4.477000e+05, -1.253000e+05, -1.257000e+05,  5.348000e+05,
         5.348000e+05,  2.845000e+05,  3.580000e+04,  2.924000e+05,
         3.549000e+05,  8.292000e+05,  8.179000e+05, -4.332000e+05,
         4.464000e+05, -1.332000e+05, -1.415000e+05, -1.261000e+05,
         6.483000e+05,  6.482000e+05,  6.276000e+05,  6.427000e+05,
        -6.680000e+04, -1.452000e+05, -6.410000e+04, -1.204000e+05,
        -7.680000e+04, -1.585000e+05, -6.360000e+04,  2.150000e+04,
        -8.250000e+04, -1.335000e+05, -1.335000e+05, -1.335000e+05,
        -1.335000e+05, -1.534000e+05, -1.534000e+05,  4.500000e+05,
        -1.413000e+05, -1.509000e+05,  5.300000e+03,  0.000000e+00,
        -2.457000e+05, -2.538000e+05,  4.404000e+05,  9.060000e+04,
        -6.170000e+04, -6.170000e+04, -7.480000e+04, -7.480000e+04,
        -7.480000e+04, -5.663000e+05, -6.158000e+05,  5.982000e+05,
         2.629000e+05, -2.726000e+05, -3.015000e+05, -1.840000e+04,
        -8.090000e+05, -5.505000e+05, -6.202000e+05, -5.505000e+05,
        -6.208000e+05,  6.151000e+05,  1.965600e+06,  2.549000e+06,
         1.925500e+06,  3.675000e+05,  3.563000e+05, -8.842000e+05,
         5.088000e+05, -7.600000e+04, -8.750000e+04,  4.404000e+05,
         8.730000e+05,  4.180000e+04,  1.140000e+04,  3.350000e+04,
         6.267000e+05, -2.970000e+04, -2.830000e+05,  3.486000e+05,
         9.329000e+05, -2.356000e+05,  2.925000e+05,  3.347000e+05,
         8.189000e+05,  7.965000e+05,  1.805000e+05, -2.834000e+05,
        -3.169000e+05,  3.011000e+05,  1.824000e+05, -2.560000e+04,
        -3.140000e+05, -2.864000e+05,  3.461000e+05,  2.774000e+05,
         2.710000e+04, -1.146000e+05, -1.147000e+05, -1.463000e+05,
        -1.296000e+05, -7.350000e+04, -2.047300e+06, -7.750000e+04,
        -7.760000e+04, -9.300000e+03, -9.300000e+03,  3.540000e+05,
        -9.300000e+03, -3.690000e+05, -9.300000e+03, -8.380000e+04,
        -8.380000e+04, -8.380000e+04, -8.380000e+04, -8.190000e+04,
         8.220000e+04,  8.220000e+04,  8.220000e+04,  5.300000e+05,
        -5.610000e+04,  0.000000e+00,  5.060000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  4.932000e+05,  1.571000e+05,  7.390000e+04,
         1.069800e+06,  1.866000e+05,  1.869000e+05, -6.460000e+04,
        -6.460000e+04,  6.200000e+03,  8.100000e+03,  1.300000e+03,
         1.120000e+04,  5.000000e+03,  5.000000e+03,  5.200000e+03,
         5.187000e+05, -6.730000e+04,  1.310000e+04, -3.000000e+02,
         0.000000e+00,  0.000000e+00,  1.240000e+04,  1.600000e+04,
         6.800000e+03,  1.910000e+04,  1.920000e+04,  1.920000e+04,
         0.000000e+00,  0.000000e+00,  5.325000e+05,  5.236000e+05,
         1.900000e+04,  9.200000e+03,  2.720000e+04,  6.300000e+03,
         1.430000e+04,  1.150000e+04,  2.581000e+05,  6.500000e+03,
         7.700000e+03,  7.700000e+03,  1.470000e+04,  5.500000e+03,
         5.400000e+03,  2.230000e+04,  1.320000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.120000e+04,
         8.100000e+03,  6.800000e+04, -3.000000e+02,  1.310000e+04,
        -8.380000e+04,  0.000000e+00, -5.080000e+04, -6.960000e+04,
        -7.480000e+04, -1.335000e+05, -1.413000e+05,  4.351000e+05,
         3.540000e+05, -9.300000e+03, -7.760000e+04,  8.220000e+04,
         7.390000e+04,  1.300000e+03,  1.920000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -8.380000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.517000e+05,  3.280000e+04,  3.840000e+04, -1.440000e+04,
         6.840000e+04,  6.481000e+05,  3.448000e+05,  2.048000e+05,
         3.280000e+04,  2.158000e+05,  3.260000e+04,  2.173000e+05,
         1.067000e+05, -6.730000e+04,  0.000000e+00,  2.173000e+05,
        -3.900000e+03,  1.618000e+05,  1.010000e+04,  6.667000e+05,
         0.000000e+00,  2.255000e+05,  4.810000e+04,  5.620000e+04,
        -2.350000e+04,  3.330000e+04,  1.043000e+05,  2.913000e+05,
         4.200000e+04,  2.481000e+05,  4.127000e+05,  1.298000e+05,
        -2.870000e+04, -2.380000e+04, -2.350000e+04, -2.370000e+04,
        -2.390000e+04, -6.240000e+04, -2.360000e+04, -6.260000e+04,
        -2.979000e+05, -2.883000e+05,  3.040000e+04, -2.910000e+04,
        -2.610000e+04,  5.370000e+04, -5.760000e+04, -2.800000e+04,
        -2.800000e+04,  6.000000e+02,  2.910000e+04,  3.000000e+03,
        -9.100000e+03,  3.120000e+04, -2.810000e+04,  1.150000e+05,
        -8.150000e+04,  8.270000e+04, -1.000000e+02, -5.720000e+04,
         1.902000e+05,  1.901000e+05,  7.270000e+04,  7.730000e+04,
         4.282000e+05,  1.644000e+05,  1.728000e+05,  4.913000e+05,
         1.030000e+04,  4.920000e+04,  3.390000e+04, -1.390000e+04,
         3.910000e+04,  1.950000e+05,  1.950000e+05,  1.950000e+05,
         1.951000e+05,  7.640000e+04,  7.630000e+04,  3.010000e+04,
         1.120000e+05,  5.260000e+04, -3.900000e+03,  0.000000e+00,
         2.460000e+04,  2.930000e+04, -5.270000e+04,  3.930000e+04,
         3.610000e+04,  3.610000e+04,  1.430000e+04,  1.430000e+04,
         1.430000e+04,  5.595000e+05,  2.630000e+05,  2.299000e+05,
         2.632000e+05,  3.274000e+05,  1.494000e+05,  1.941000e+05,
         2.074000e+05,  7.252000e+05,  3.098000e+05,  7.252000e+05,
         3.104000e+05,  3.953000e+05,  3.300000e+04, -1.318000e+05,
        -2.038000e+05,  7.360000e+04,  1.430000e+04,  4.287000e+05,
        -9.670000e+04,  6.800000e+04,  8.900000e+03, -2.790000e+04,
        -7.610000e+04,  1.322000e+05, -4.520000e+04, -3.700000e+04,
        -3.240000e+04,  2.018000e+05,  3.357000e+05,  3.328000e+05,
         1.679000e+05,  4.978000e+05,  3.630000e+04,  5.080000e+04,
         1.037000e+05, -1.490000e+04,  1.052000e+05,  3.352000e+05,
         1.569000e+05,  1.709000e+05,  1.066000e+05,  2.006000e+05,
         1.578000e+05,  3.263000e+05,  1.820000e+04,  5.400000e+03,
         3.400000e+04,  2.485000e+05,  2.485000e+05,  7.080000e+04,
         1.910000e+05,  4.875000e+05,  4.069900e+06,  3.920000e+04,
         3.920000e+04, -2.930000e+04, -2.930000e+04, -8.900000e+03,
        -2.940000e+04, -7.890000e+04, -2.930000e+04,  4.340000e+04,
         4.340000e+04,  4.340000e+04,  4.370000e+04,  1.022000e+05,
        -4.510000e+04, -4.500000e+04, -4.500000e+04, -6.810000e+04,
         5.984000e+05,  0.000000e+00, -6.160000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.703000e+05, -1.163000e+05, -7.280000e+04,
        -5.530000e+04,  7.780000e+04,  7.760000e+04,  2.078000e+05,
         2.077000e+05, -4.300000e+03, -2.590000e+04, -4.300000e+03,
         4.040000e+04, -3.860000e+04, -3.800000e+03, -4.400000e+03,
        -6.730000e+04,  6.427000e+05, -9.600000e+03, -9.000000e+02,
         0.000000e+00,  0.000000e+00, -5.300000e+03,  4.560000e+04,
        -9.300000e+03, -1.020000e+04, -1.020000e+04, -1.020000e+04,
         0.000000e+00,  0.000000e+00, -1.350000e+04, -7.230000e+04,
        -1.470000e+04,  1.440000e+04,  8.600000e+04, -8.600000e+03,
         5.290000e+04,  4.140000e+04, -3.420000e+04, -4.800000e+03,
        -2.850000e+04, -2.850000e+04,  5.100000e+04, -5.100000e+03,
        -2.200000e+03,  2.200000e+04, -3.370000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  1.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.040000e+04,
        -2.590000e+04, -8.800000e+03, -9.000000e+02, -9.600000e+03,
         4.340000e+04, -1.000000e+02,  1.517000e+05,  3.280000e+04,
         1.430000e+04,  1.950000e+05,  1.120000e+05, -2.390000e+04,
        -8.900000e+03, -2.930000e+04,  3.920000e+04, -4.500000e+04,
        -7.280000e+04, -4.300000e+03, -1.020000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.340000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-4.500000e+03,  2.927000e+05, -8.600000e+03, -8.800000e+03,
        -6.700000e+03, -1.430000e+04, -5.300000e+03, -5.000000e+03,
         2.926000e+05, -5.200000e+03,  2.917000e+05, -9.600000e+03,
         1.389000e+05,  1.310000e+04,  0.000000e+00, -9.600000e+03,
        -1.170000e+04, -9.600000e+03,  1.600000e+04, -3.830000e+04,
         0.000000e+00, -1.580000e+04,  3.947000e+05, -1.970000e+04,
        -2.530000e+04,  3.387000e+05,  7.868000e+05, -2.890000e+04,
        -3.490000e+04, -6.830000e+04, -9.070000e+04,  2.231000e+05,
        -1.442000e+05, -1.500000e+03, -1.500000e+03, -1.100000e+03,
        -1.300000e+03,  9.100000e+03, -1.500000e+03,  2.840000e+04,
         5.758000e+05,  2.320000e+04,  3.400000e+03,  1.404000e+05,
         2.100000e+03, -1.540000e+04, -1.510000e+04, -2.490000e+04,
        -2.500000e+04,  1.654000e+05,  3.503000e+05, -2.350000e+04,
        -1.660000e+04, -4.780000e+04,  8.910000e+04,  1.040800e+06,
         3.700000e+03, -1.830000e+04, -2.040000e+04, -1.550000e+04,
        -3.690000e+04, -3.690000e+04,  2.422000e+05, -3.950000e+04,
         2.200000e+03, -2.280000e+04, -6.300000e+03, -3.100000e+03,
        -3.890000e+04, -2.620000e+04, -1.100000e+04, -2.070000e+04,
        -3.880000e+04, -1.910000e+04, -1.910000e+04, -1.910000e+04,
        -1.910000e+04,  2.781000e+05,  2.781000e+05,  3.200000e+03,
        -2.140000e+04,  1.273000e+05,  1.800000e+03,  0.000000e+00,
         1.923000e+05, -4.800000e+03,  3.000000e+02, -2.680000e+04,
        -1.030000e+04, -1.030000e+04, -1.160000e+04, -1.160000e+04,
        -1.160000e+04, -8.590000e+04,  6.572000e+05, -4.370000e+04,
        -2.180000e+04, -3.950000e+04,  4.066000e+05,  5.300000e+03,
         7.521000e+05, -8.120000e+04,  9.590000e+05, -8.120000e+04,
         9.589000e+05, -3.640000e+04,  4.190000e+04,  6.430000e+04,
         6.284000e+05, -1.100000e+04,  1.259000e+05,  2.789900e+06,
         1.030000e+04, -1.230000e+04,  1.245000e+05,  4.000000e+02,
        -3.700000e+03,  1.250000e+04,  4.532000e+05,  8.600000e+03,
         3.510000e+04,  2.500000e+03, -4.310000e+04, -5.800000e+03,
         1.650000e+04, -2.820000e+04,  6.788000e+05, -1.230000e+04,
        -7.500000e+03,  2.664000e+05, -4.460000e+04, -4.310000e+04,
         3.680000e+05, -2.050000e+04, -4.490000e+04,  2.500000e+03,
         4.027000e+05, -3.000000e+03, -1.540000e+04, -2.880000e+04,
         1.615000e+05, -1.340000e+04, -1.340000e+04,  4.318000e+05,
         6.528000e+05, -3.180000e+04, -2.530000e+05, -1.260000e+04,
        -1.260000e+04, -2.800000e+03, -2.800000e+03, -1.770000e+04,
        -2.800000e+03,  1.050000e+04, -2.800000e+03, -1.460000e+04,
        -1.460000e+04, -1.460000e+04, -1.460000e+04, -1.410000e+04,
         1.480000e+04,  1.480000e+04,  1.480000e+04,  1.670000e+04,
        -6.000000e+03,  0.000000e+00,  9.200000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  8.870000e+04,  2.640000e+04,  1.180000e+04,
        -5.060000e+04, -4.640000e+04, -4.600000e+04, -8.970000e+04,
        -8.970000e+04,  2.000000e+03,  2.600000e+03, -2.420000e+04,
         3.600000e+03,  1.525000e+05,  1.401000e+05,  1.000000e+03,
         1.310000e+04, -9.600000e+03,  3.940000e+05, -1.000000e+02,
         0.000000e+00,  3.000000e+03, -1.850000e+04, -1.950000e+04,
         1.153000e+05,  3.300000e+03,  3.300000e+03,  3.300000e+03,
         0.000000e+00,  0.000000e+00,  1.760000e+04,  1.552000e+05,
         5.359000e+05,  1.251000e+05, -1.590000e+04,  1.066000e+05,
         4.500000e+03,  3.700000e+03,  6.800000e+03,  1.966000e+05,
         2.400000e+03,  2.400000e+03,  4.500000e+03,  1.397000e+05,
         1.000000e+03,  6.800000e+03,  1.422000e+05,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  3.600000e+03,
         2.600000e+03,  1.700000e+03, -1.000000e+02,  3.940000e+05,
        -1.460000e+04,  0.000000e+00, -4.500000e+03,  2.927000e+05,
        -1.160000e+04, -1.910000e+04, -2.140000e+04, -1.400000e+03,
        -1.770000e+04, -2.800000e+03, -1.260000e+04,  1.480000e+04,
         1.180000e+04, -2.420000e+04,  3.300000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.460000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-2.300000e+03,  3.000000e+02,  1.000000e+02,  4.000000e+02,
        -1.000000e+03, -1.020000e+04, -5.600000e+03, -2.200000e+03,
         3.000000e+02, -2.100000e+03,  3.000000e+02, -9.000000e+02,
         3.000000e+02, -3.000000e+02,  0.000000e+00, -9.000000e+02,
         4.000000e+02, -9.000000e+02,  0.000000e+00, -3.700000e+03,
         0.000000e+00, -3.200000e+03,  8.000000e+02,  4.000000e+02,
         8.000000e+02,  1.000000e+03,  1.000000e+03,  1.698000e+05,
         1.739000e+05,  3.000000e+02, -3.000000e+02,  2.900000e+03,
         2.200000e+03,  1.000000e+02,  1.000000e+02,  1.000000e+02,
         2.000000e+02, -1.000000e+02,  1.000000e+02, -4.700000e+03,
         4.000000e+02,  0.000000e+00, -1.200000e+03,  1.000000e+02,
        -1.000000e+02, -6.000000e+02,  7.000000e+02,  7.000000e+02,
         7.000000e+02,  8.000000e+02,  9.000000e+02,  7.000000e+02,
         5.000000e+02,  2.000000e+02,  1.500000e+03,  2.000000e+03,
         1.000000e+02, -6.000000e+02,  7.000000e+02,  7.000000e+02,
        -1.300000e+03, -1.300000e+03,  1.400000e+03,  1.100000e+03,
        -7.600000e+03, -9.000000e+02, -2.500000e+03, -9.900000e+03,
         4.000000e+02,  8.000000e+02,  3.000000e+02,  0.000000e+00,
         5.000000e+02, -1.900000e+03, -1.900000e+03, -1.900000e+03,
        -1.900000e+03,  7.000000e+02,  7.000000e+02, -1.300000e+03,
        -6.000000e+02,  7.000000e+02,  0.000000e+00,  0.000000e+00,
         1.000000e+02,  8.640000e+04,  1.000000e+02,  6.000000e+02,
         2.000000e+02,  2.000000e+02,  4.000000e+02,  4.000000e+02,
         4.000000e+02, -3.600000e+03,  2.900000e+03, -2.400000e+03,
        -4.100000e+03, -2.400000e+03,  1.500000e+03, -3.600000e+03,
         1.600000e+03, -6.200000e+03,  2.900000e+03, -6.200000e+03,
         2.900000e+03, -4.900000e+03, -6.000000e+03, -5.400000e+03,
        -8.000000e+02, -8.000000e+02,  5.000000e+02,  4.000000e+03,
         5.000000e+02, -2.000000e+02,  1.100000e+03,  1.000000e+02,
         2.000000e+02, -3.300000e+03,  6.000000e+02,  2.000000e+02,
        -2.600000e+03, -3.600000e+03, -2.400000e+03, -5.900000e+03,
        -5.300000e+03, -6.500000e+03,  7.000000e+02,  0.000000e+00,
        -2.000000e+03,  6.000000e+02,  1.400000e+03, -2.400000e+03,
         1.500000e+03, -1.700000e+03,  1.400000e+03, -3.700000e+03,
         1.500000e+03, -2.100000e+03,  5.000000e+02,  8.000000e+02,
         9.000000e+02, -3.300000e+03, -3.300000e+03,  7.000000e+02,
         2.500000e+03, -4.000000e+03, -5.090000e+04,  4.000000e+02,
         4.000000e+02,  7.000000e+02,  7.000000e+02,  5.000000e+02,
         7.000000e+02,  9.000000e+02,  7.000000e+02,  4.000000e+02,
         4.000000e+02,  4.000000e+02,  4.000000e+02,  3.000000e+02,
        -3.000000e+02, -3.000000e+02, -3.000000e+02, -1.200000e+03,
        -1.900000e+03,  0.000000e+00, -2.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.100000e+03, -1.000000e+02,  3.000000e+02,
         1.400000e+03,  1.300000e+03,  1.300000e+03,  2.500000e+03,
         2.500000e+03,  0.000000e+00,  0.000000e+00,  1.000000e+02,
        -1.000000e+03,  1.000000e+02,  0.000000e+00,  0.000000e+00,
        -3.000000e+02, -9.000000e+02, -1.000000e+02,  1.728000e+05,
         0.000000e+00,  0.000000e+00, -1.000000e+02, -1.100000e+03,
         1.000000e+02, -1.000000e+02, -1.000000e+02, -1.000000e+02,
         0.000000e+00,  0.000000e+00, -1.800000e+03, -3.000000e+02,
        -1.000000e+02, -5.000000e+02, -2.100000e+03,  0.000000e+00,
         1.711000e+05, -1.000000e+03, -1.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.200000e+03,  0.000000e+00,
         0.000000e+00, -1.200000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.000000e+03,
         0.000000e+00,  0.000000e+00,  1.728000e+05, -1.000000e+02,
         4.000000e+02,  0.000000e+00, -2.300000e+03,  3.000000e+02,
         4.000000e+02, -1.900000e+03, -6.000000e+02,  2.000000e+02,
         5.000000e+02,  7.000000e+02,  4.000000e+02, -3.000000e+02,
         3.000000e+02,  1.000000e+02, -1.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.000000e+02,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.098900e+06,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 0.000000e+00, -2.200000e+03,  0.000000e+00, -6.000000e+02,
        -3.000000e+02,  1.000000e+02,  0.000000e+00,  0.000000e+00,
        -2.200000e+03,  0.000000e+00, -2.200000e+03,  0.000000e+00,
        -1.100000e+03,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -3.000000e+02,  0.000000e+00, -1.000000e+02,  1.000000e+02,
         0.000000e+00,  1.000000e+02, -2.500000e+03,  1.000000e+02,
         0.000000e+00,  1.680000e+04,  3.000000e+02,  1.000000e+02,
        -8.000000e+02,  3.000000e+02,  3.000000e+02, -1.800000e+03,
        -9.000000e+02,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.000000e+02,
        -3.300000e+03,  2.000000e+02,  0.000000e+00, -8.000000e+02,
         0.000000e+00, -9.000000e+02, -1.500000e+03,  1.000000e+02,
         1.000000e+02,  3.300000e+03,  9.900000e+03,  0.000000e+00,
         1.000000e+02,  2.000000e+02, -7.000000e+02,  1.510000e+04,
         1.000000e+02, -6.000000e+02, -9.000000e+02, -1.500000e+03,
         2.000000e+02,  2.000000e+02, -1.700000e+03,  2.000000e+02,
         0.000000e+00,  1.000000e+02,  0.000000e+00,  1.000000e+02,
         1.000000e+02, -3.000000e+02,  0.000000e+00,  1.000000e+02,
         2.000000e+02,  1.000000e+02,  1.000000e+02,  1.000000e+02,
         1.000000e+02, -2.200000e+03, -2.200000e+03,  0.000000e+00,
        -2.000000e+02, -1.300000e+03,  0.000000e+00,  0.000000e+00,
         2.100000e+03,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.000000e+02, -3.000000e+02,
        -3.000000e+02, -3.000000e+02, -5.900000e+03, -2.000000e+02,
        -3.000000e+02,  1.000000e+02, -3.200000e+03,  0.000000e+00,
         2.300000e+03,  3.000000e+02, -7.500000e+03,  3.000000e+02,
        -7.500000e+03,  2.000000e+02,  1.000000e+02,  0.000000e+00,
        -4.200000e+03,  1.000000e+02, -8.000000e+02,  3.880000e+04,
         0.000000e+00,  0.000000e+00, -8.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.200000e+03, -1.000000e+02,
        -1.000000e+02,  0.000000e+00,  1.000000e+02,  1.000000e+02,
         1.000000e+02,  1.000000e+02, -4.300000e+03,  1.000000e+02,
         1.000000e+02, -1.700000e+03,  1.000000e+02,  1.000000e+02,
        -2.500000e+03,  1.000000e+02,  1.000000e+02,  0.000000e+00,
        -3.200000e+03, -1.200000e+03,  1.000000e+02,  1.000000e+02,
         3.200000e+03,  0.000000e+00,  0.000000e+00, -3.300000e+03,
        -4.700000e+03, -4.000000e+02,  8.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02, -1.000000e+02,  0.000000e+00,
        -2.000000e+02,  1.000000e+02,  1.000000e+02,  2.000000e+02,
         2.000000e+02,  0.000000e+00, -3.000000e+02,  2.000000e+02,
         0.000000e+00, -1.100000e+03,  6.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  3.000000e+03,  0.000000e+00,
         0.000000e+00,  1.212000e+05,  1.000000e+02,  1.000000e+02,
        -7.000000e+02,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -9.000000e+02,
         2.400000e+03,  1.100000e+03,  1.000000e+02, -7.000000e+02,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.500000e+03,
        -3.000000e+02, -3.000000e+02,  0.000000e+00, -7.000000e+02,
         0.000000e+00, -3.000000e+02, -1.000000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -3.000000e+02,  0.000000e+00,  0.000000e+00,  3.000000e+03,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.200000e+03,
        -3.000000e+02,  1.000000e+02, -2.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-3.300000e+03, -3.050000e+04,  3.756000e+05, -1.250000e+04,
        -8.000000e+03, -1.800000e+04, -1.130000e+04, -5.900000e+03,
        -3.050000e+04, -6.400000e+03, -3.050000e+04, -5.500000e+03,
        -1.720000e+04,  1.240000e+04,  0.000000e+00, -5.500000e+03,
        -9.900000e+03, -6.000000e+03, -2.000000e+03, -2.100000e+04,
         0.000000e+00,  3.300000e+03, -5.250000e+04,  2.251400e+06,
        -1.890000e+04, -4.920000e+04, -7.830000e+04, -1.020000e+04,
        -2.980000e+04, -2.930000e+04, -4.760000e+04, -6.220000e+04,
        -1.125000e+05,  3.700000e+03,  3.600000e+03,  3.000000e+03,
         3.900000e+03,  1.130000e+04,  3.600000e+03,  6.700000e+04,
        -6.300000e+03,  3.064400e+06,  7.500000e+03, -9.400000e+03,
         7.569000e+05, -2.060000e+04, -2.930000e+04, -1.250000e+04,
        -1.250000e+04, -2.730000e+04, -4.230000e+04,  7.378000e+05,
        -7.600000e+03, -2.610000e+04, -4.380000e+04, -1.175000e+05,
         5.000000e+02, -1.780000e+04, -2.240000e+04, -3.080000e+04,
        -9.000000e+03, -9.000000e+03, -4.480000e+04,  1.489700e+06,
        -2.030000e+04, -3.300000e+03, -7.700000e+03, -4.520000e+04,
         3.699000e+05, -1.800000e+04, -6.200000e+03,  3.880000e+05,
         3.766000e+05, -7.800000e+03, -7.800000e+03, -7.800000e+03,
        -7.800000e+03, -3.930000e+04, -3.930000e+04,  1.000000e+04,
        -1.490000e+04, -2.930000e+04,  2.200000e+03,  0.000000e+00,
        -1.260000e+04, -3.900000e+03,  2.000000e+03, -1.400000e+04,
         1.658000e+05,  1.658000e+05, -9.900000e+03, -9.900000e+03,
        -9.900000e+03, -4.920000e+04, -1.264000e+05, -1.440000e+04,
        -1.640000e+04, -1.490000e+04, -6.210000e+04,  1.160000e+04,
        -9.610000e+04, -3.520000e+04, -1.455000e+05, -3.520000e+04,
        -1.464000e+05, -2.900000e+03,  4.940000e+04,  6.660000e+04,
        -1.550000e+04,  0.000000e+00, -1.760000e+04, -2.953000e+05,
         9.700000e+03, -5.900000e+03, -2.430000e+04,  6.400000e+03,
         4.800000e+03,  1.170000e+04, -3.600000e+04,  2.259800e+06,
         2.750000e+04, -4.200000e+03, -1.610000e+04,  5.600000e+03,
         2.330000e+04, -1.210000e+04, -8.270000e+04,  3.752400e+06,
         8.800000e+03, -2.650000e+04, -2.240000e+04, -1.930000e+04,
        -6.990000e+04, -3.400000e+03, -2.300000e+04,  9.900000e+03,
        -6.770000e+04, -3.150000e+04, -4.800000e+03, -1.780000e+04,
        -3.260000e+04, -6.200000e+03, -6.200000e+03, -5.020000e+04,
        -1.083000e+05, -2.000000e+04, -1.317000e+05, -5.900000e+03,
        -5.900000e+03, -2.600000e+03, -2.600000e+03, -8.000000e+03,
        -2.600000e+03, -1.000000e+02, -2.600000e+03, -8.800000e+03,
        -8.800000e+03, -8.800000e+03, -8.700000e+03, -5.600000e+03,
         5.800000e+03,  5.800000e+03,  5.800000e+03,  7.400000e+03,
        -1.030000e+04,  0.000000e+00,  4.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  3.460000e+04,  1.010000e+04,  3.700000e+03,
        -2.820000e+04, -2.540000e+04, -2.530000e+04, -5.160000e+04,
        -5.160000e+04,  2.800000e+03, -1.500000e+03,  3.854000e+05,
        -5.100000e+03, -1.430000e+04, -8.000000e+03,  8.100000e+04,
         1.240000e+04, -5.300000e+03, -1.850000e+04, -1.000000e+02,
         0.000000e+00,  1.000000e+02,  4.265500e+06,  3.822000e+05,
         3.763000e+05,  1.900000e+03,  1.900000e+03,  1.900000e+03,
         0.000000e+00,  0.000000e+00,  1.580000e+04, -5.000000e+02,
        -3.050000e+04, -5.400000e+03,  3.770000e+05,  3.479000e+05,
         3.700000e+03, -4.600000e+03,  6.300000e+03, -9.200000e+03,
        -4.200000e+03, -4.200000e+03, -1.300000e+03, -1.340000e+04,
         8.550000e+04, -5.900000e+03, -1.760000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.600000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -5.100000e+03,
        -1.500000e+03,  1.600000e+03, -1.000000e+02, -1.850000e+04,
        -8.800000e+03,  0.000000e+00, -3.300000e+03, -3.050000e+04,
        -9.900000e+03, -7.800000e+03, -1.490000e+04,  3.900000e+03,
        -8.000000e+03, -2.600000e+03, -5.900000e+03,  5.800000e+03,
         3.700000e+03,  3.854000e+05,  1.900000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -8.800000e+03,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 1.116000e+05, -4.200000e+04, -1.590000e+04, -3.440000e+04,
         3.840000e+04,  4.993000e+05,  2.761000e+05,  1.063000e+05,
        -4.200000e+04,  1.052000e+05, -4.200000e+04,  4.570000e+04,
        -2.710000e+04,  1.600000e+04,  0.000000e+00,  4.570000e+04,
        -2.800000e+04,  4.540000e+04, -3.200000e+03,  1.822000e+05,
         0.000000e+00,  1.523000e+05, -8.420000e+04, -8.720000e+04,
        -7.110000e+04, -1.049000e+05, -1.124000e+05,  1.352000e+05,
        -8.530000e+04, -8.200000e+03,  2.220000e+04, -1.618000e+05,
        -3.175000e+05, -3.200000e+03, -3.200000e+03, -3.200000e+03,
        -3.100000e+03,  1.040000e+04, -3.200000e+03,  2.588000e+05,
        -5.700000e+04, -6.050000e+04,  6.170000e+04, -1.730000e+04,
        -1.810000e+04,  4.200000e+03, -7.580000e+04, -5.580000e+04,
        -5.580000e+04, -7.220000e+04, -8.890000e+04, -7.650000e+04,
        -3.360000e+04, -5.260000e+04, -1.315000e+05, -2.134000e+05,
        -2.140000e+04,  9.800000e+03, -6.250000e+04, -7.670000e+04,
         6.480000e+04,  6.480000e+04, -9.110000e+04, -9.480000e+04,
         3.826000e+05,  3.830000e+04,  1.247000e+05,  5.032000e+05,
         4.535000e+05, -4.730000e+04, -1.680000e+04,  4.902000e+05,
         4.688000e+05,  9.140000e+04,  9.140000e+04,  9.140000e+04,
         9.140000e+04, -6.110000e+04, -6.110000e+04,  6.080000e+04,
         1.520000e+04, -6.120000e+04, -2.000000e+02,  0.000000e+00,
        -1.740000e+04, -8.700000e+03, -1.310000e+04, -3.830000e+04,
        -1.570000e+04, -1.570000e+04, -2.810000e+04, -2.810000e+04,
        -2.810000e+04,  1.481000e+05, -2.331000e+05,  8.690000e+04,
         1.764000e+05,  1.171000e+05, -1.111000e+05,  1.741000e+05,
        -1.503000e+05,  3.003000e+05, -2.333000e+05,  3.003000e+05,
        -2.329000e+05,  2.398000e+05,  2.827000e+05,  2.523000e+05,
        -2.380000e+04,  4.230000e+04, -3.660000e+04, -4.304000e+05,
        -1.930000e+04,  1.030000e+04, -6.860000e+04, -3.400000e+03,
        -1.770000e+04,  1.586000e+05, -7.070000e+04, -8.090000e+04,
         1.290000e+05,  1.784000e+05,  1.168000e+05,  2.830000e+05,
         2.525000e+05,  3.136000e+05, -1.116000e+05, -1.161000e+05,
         1.038000e+05, -5.410000e+04, -5.980000e+04,  1.175000e+05,
        -1.196000e+05,  8.780000e+04, -6.050000e+04,  1.746000e+05,
        -1.108000e+05,  1.523000e+05, -2.150000e+04, -6.220000e+04,
        -7.860000e+04,  1.583000e+05,  1.583000e+05, -7.250000e+04,
        -1.941000e+05,  2.005000e+05,  2.477200e+06, -1.930000e+04,
        -1.930000e+04, -3.520000e+04, -3.520000e+04, -3.420000e+04,
        -3.520000e+04, -4.810000e+04, -3.520000e+04, -1.910000e+04,
        -1.910000e+04, -1.910000e+04, -1.910000e+04, -1.460000e+04,
         1.880000e+04,  1.880000e+04,  1.880000e+04,  6.780000e+04,
         9.750000e+04,  0.000000e+00,  8.400000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.127000e+05,  4.200000e+03, -1.550000e+04,
        -1.098000e+05, -7.230000e+04, -7.210000e+04, -1.295000e+05,
        -1.295000e+05, -2.000000e+02, -5.600000e+03,  4.879000e+05,
         5.190000e+04, -1.680000e+04, -8.500000e+03, -2.300000e+03,
         1.600000e+04,  4.560000e+04, -1.950000e+04, -1.100000e+03,
         0.000000e+00,  1.000000e+02,  3.822000e+05,  6.439000e+05,
         4.728000e+05,  5.100000e+03,  5.000000e+03,  5.000000e+03,
         0.000000e+00,  0.000000e+00,  8.030000e+04,  1.700000e+03,
        -3.250000e+04,  1.430000e+04,  6.955000e+05,  4.372000e+05,
         6.320000e+04,  5.290000e+04,  8.300000e+03, -9.700000e+03,
        -7.200000e+03, -7.200000e+03,  7.530000e+04, -1.240000e+04,
        -8.000000e+02,  6.740000e+04, -1.960000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  5.190000e+04,
        -5.600000e+03,  2.100000e+03, -1.100000e+03, -1.950000e+04,
        -1.910000e+04,  0.000000e+00,  1.116000e+05, -4.200000e+04,
        -2.810000e+04,  9.140000e+04,  1.520000e+04, -3.100000e+03,
        -3.420000e+04, -3.520000e+04, -1.930000e+04,  1.880000e+04,
        -1.550000e+04,  4.879000e+05,  5.000000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.910000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-1.260000e+04,  1.285000e+05, -1.460000e+04, -1.910000e+04,
        -1.580000e+04, -5.400000e+04, -2.890000e+04, -1.270000e+04,
         1.285000e+05, -1.280000e+04,  1.286000e+05, -9.300000e+03,
         6.140000e+04,  6.800000e+03,  0.000000e+00, -9.300000e+03,
        -1.230000e+04, -9.300000e+03,  7.100000e+03, -3.700000e+04,
         0.000000e+00, -2.050000e+04,  2.235000e+05, -7.110000e+04,
        -2.940000e+04,  8.380000e+04,  3.051000e+05, -2.720000e+04,
        -3.760000e+04, -3.410000e+04, -5.010000e+04,  1.120000e+05,
        -1.921000e+05,  8.000000e+02,  9.000000e+02,  1.000000e+02,
         7.000000e+02,  5.500000e+03,  9.000000e+02,  4.200000e+03,
         3.293000e+05, -6.320000e+04, -2.300000e+03,  7.900000e+04,
        -1.920000e+04, -3.500000e+04, -4.470000e+04, -1.690000e+04,
        -1.680000e+04,  3.660000e+04,  9.210000e+04, -4.330000e+04,
        -9.700000e+03, -4.290000e+04,  3.850000e+04,  3.055000e+05,
        -1.270000e+04, -2.820000e+04, -3.170000e+04, -4.450000e+04,
        -2.300000e+04, -2.300000e+04,  1.344000e+05, -5.670000e+04,
        -3.630000e+04, -1.460000e+04, -1.530000e+04, -5.360000e+04,
         4.655000e+05, -1.840000e+04, -4.500000e+03,  4.825000e+05,
         4.748000e+05, -1.830000e+04, -1.830000e+04, -1.830000e+04,
        -1.830000e+04,  1.224000e+05,  1.224000e+05, -2.200000e+03,
        -2.120000e+04,  4.920000e+04,  1.000000e+03,  0.000000e+00,
         5.500000e+04, -2.400000e+03, -5.200000e+03, -8.000000e+03,
        -9.300000e+03, -9.300000e+03, -1.260000e+04, -1.260000e+04,
        -1.260000e+04, -7.590000e+04,  2.759000e+05, -4.210000e+04,
        -4.010000e+04, -3.140000e+04,  1.796000e+05, -1.220000e+04,
         3.050000e+05, -7.000000e+04,  4.225000e+05, -7.000000e+04,
         4.223000e+05, -3.820000e+04,  2.900000e+03,  1.890000e+04,
         2.916000e+05, -8.200000e+03,  7.310000e+04,  1.102500e+06,
         8.500000e+03, -7.700000e+03,  7.360000e+04,  1.900000e+03,
        -2.600000e+03, -7.500000e+03,  2.083000e+05, -5.800000e+04,
         8.600000e+03, -1.530000e+04, -3.320000e+04, -2.710000e+04,
        -1.090000e+04, -4.320000e+04,  3.797000e+05, -1.113000e+05,
        -1.030000e+04,  1.524000e+05, -1.740000e+04, -3.340000e+04,
         2.107000e+05, -1.730000e+04, -1.800000e+04, -1.390000e+04,
         1.775000e+05, -4.880000e+04, -5.100000e+03, -2.220000e+04,
         3.120000e+04, -2.130000e+04, -2.130000e+04,  1.898000e+05,
         3.299000e+05, -7.680000e+04, -3.592000e+05, -5.100000e+03,
        -5.100000e+03,  1.700000e+03,  1.700000e+03, -8.900000e+03,
         1.700000e+03,  8.600000e+03,  1.700000e+03, -6.100000e+03,
        -6.100000e+03, -6.100000e+03, -6.100000e+03, -5.800000e+03,
         6.800000e+03,  6.800000e+03,  6.800000e+03,  3.100000e+03,
        -1.300000e+04,  0.000000e+00,  4.000000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  4.100000e+04,  1.350000e+04,  7.600000e+03,
        -3.300000e+04, -2.140000e+04, -2.160000e+04, -4.000000e+04,
        -4.000000e+04,  1.100000e+03, -6.000000e+03,  4.809000e+05,
        -3.800000e+03,  6.710000e+04,  4.930000e+04, -1.900000e+03,
         6.800000e+03, -9.300000e+03,  1.153000e+05,  1.000000e+02,
         0.000000e+00, -7.000000e+02,  3.763000e+05,  4.728000e+05,
         5.626000e+05,  1.400000e+03,  1.400000e+03,  1.400000e+03,
         0.000000e+00,  0.000000e+00,  3.800000e+03,  8.480000e+04,
         1.885000e+05,  3.810000e+04,  4.689000e+05,  5.203000e+05,
        -3.000000e+03, -3.700000e+03,  3.500000e+03,  5.750000e+04,
        -6.400000e+03, -6.400000e+03, -3.900000e+03,  7.150000e+04,
        -2.000000e+03, -1.020000e+04,  6.520000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -3.800000e+03,
        -6.000000e+03,  9.000000e+02,  1.000000e+02,  1.153000e+05,
        -6.100000e+03,  0.000000e+00, -1.260000e+04,  1.285000e+05,
        -1.260000e+04, -1.830000e+04, -2.120000e+04,  7.000000e+02,
        -8.900000e+03,  1.700000e+03, -5.100000e+03,  6.800000e+03,
         7.600000e+03,  4.809000e+05,  1.400000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -6.100000e+03,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-5.200000e+03, -1.150000e+04, -9.900000e+03, -1.500000e+03,
        -3.300000e+03, -1.680000e+04, -6.400000e+03, -5.600000e+03,
        -1.150000e+04, -5.700000e+03, -1.150000e+04, -1.020000e+04,
        -1.300000e+04,  1.910000e+04,  0.000000e+00, -1.020000e+04,
        -8.300000e+03, -1.020000e+04, -1.500000e+03, -4.070000e+04,
         0.000000e+00, -1.110000e+04, -2.130000e+04, -1.840000e+04,
        -5.500000e+03, -2.130000e+04, -3.660000e+04, -3.030000e+04,
        -2.480000e+04, -6.110000e+04, -9.030000e+04, -6.780000e+04,
        -2.530000e+04,  3.900000e+03,  3.900000e+03,  3.900000e+03,
         3.900000e+03,  1.630000e+04,  3.900000e+03,  7.850000e+04,
         6.510000e+04,  6.870000e+04,  9.000000e+03,  5.800000e+03,
         6.500000e+03, -4.800000e+03,  3.700000e+03, -3.000000e+03,
        -3.000000e+03, -1.090000e+04, -1.880000e+04, -9.800000e+03,
        -4.300000e+03, -1.040000e+04, -1.370000e+04, -5.320000e+04,
         1.790000e+04, -1.160000e+04, -9.700000e+03,  3.600000e+03,
        -2.770000e+04, -2.770000e+04, -3.450000e+04, -3.260000e+04,
         1.700000e+03, -2.410000e+04, -6.900000e+03, -2.500000e+03,
        -8.700000e+03, -2.360000e+04,  2.412500e+06,  2.427300e+06,
        -1.570000e+04, -2.020000e+04, -2.020000e+04, -2.010000e+04,
        -2.020000e+04, -2.680000e+04, -2.680000e+04,  9.000000e+03,
        -1.840000e+04, -2.160000e+04,  1.600000e+03,  0.000000e+00,
        -6.200000e+03, -8.000000e+03,  1.090000e+04, -1.750000e+04,
        -1.120000e+04, -1.120000e+04, -8.200000e+03, -8.200000e+03,
        -8.200000e+03, -8.220000e+04, -9.880000e+04, -2.370000e+04,
        -7.200000e+03, -4.220000e+04, -5.200000e+04,  4.700000e+03,
        -6.810000e+04, -8.570000e+04, -1.090000e+05, -8.570000e+04,
        -1.091000e+05, -2.730000e+04,  6.620000e+04,  9.540000e+04,
         5.280000e+04, -6.100000e+03, -9.400000e+03, -1.509000e+05,
         1.630000e+04, -1.290000e+04, -1.630000e+04,  5.600000e+03,
         1.480000e+04,  1.270000e+04,  2.800000e+03,  5.400000e+03,
         4.200000e+04,  1.100000e+03, -4.520000e+04, -1.100000e+03,
         2.810000e+04, -3.040000e+04, -1.750000e+04, -1.340000e+04,
         3.000000e+03, -3.500000e+03, -4.150000e+04, -4.530000e+04,
        -5.490000e+04, -1.620000e+04, -4.200000e+04,  2.300000e+03,
        -5.550000e+04, -4.410000e+04, -1.090000e+04, -1.260000e+04,
        -2.050000e+04, -1.480000e+04, -1.480000e+04, -2.490000e+04,
        -7.710000e+04, -6.070000e+04, -2.741000e+05, -1.350000e+04,
        -1.360000e+04, -2.800000e+03, -2.800000e+03, -4.400000e+03,
        -2.800000e+03,  5.700000e+03, -2.800000e+03, -1.530000e+04,
        -1.530000e+04, -1.530000e+04, -1.530000e+04, -1.480000e+04,
         1.570000e+04,  1.570000e+04,  1.570000e+04,  2.310000e+04,
        -6.300000e+03,  0.000000e+00,  9.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  9.410000e+04,  2.740000e+04,  1.230000e+04,
        -6.400000e+03, -3.490000e+04, -3.490000e+04, -8.070000e+04,
        -8.070000e+04,  1.700000e+03,  6.500000e+03, -4.000000e+02,
         3.900000e+03,  1.400000e+03,  1.300000e+03,  1.000000e+03,
         1.910000e+04, -1.020000e+04,  3.300000e+03, -1.000000e+02,
         0.000000e+00,  0.000000e+00,  1.900000e+03,  5.100000e+03,
         1.400000e+03,  2.450300e+06,  2.449700e+06,  2.449700e+06,
         0.000000e+00,  0.000000e+00,  2.410000e+04,  2.100000e+04,
         5.100000e+03,  2.700000e+03,  9.000000e+03,  1.300000e+03,
         4.900000e+03,  4.000000e+03,  9.800000e+03,  1.700000e+03,
         6.600000e+03,  6.600000e+03,  5.500000e+03,  1.700000e+03,
         1.000000e+03,  1.210000e+04,  8.300000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  3.900000e+03,
         6.500000e+03,  2.500000e+03, -1.000000e+02,  3.300000e+03,
        -1.530000e+04,  0.000000e+00, -5.200000e+03, -1.150000e+04,
        -8.200000e+03, -2.020000e+04, -1.840000e+04,  3.900000e+03,
        -4.400000e+03, -2.800000e+03, -1.360000e+04,  1.570000e+04,
         1.230000e+04, -4.000000e+02,  2.449700e+06,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.530000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-5.100000e+03, -1.160000e+04, -9.900000e+03, -1.500000e+03,
        -3.300000e+03, -1.650000e+04, -6.300000e+03, -5.500000e+03,
        -1.160000e+04, -5.600000e+03, -1.150000e+04, -1.020000e+04,
        -1.310000e+04,  1.920000e+04,  0.000000e+00, -1.020000e+04,
        -8.300000e+03, -1.020000e+04, -1.500000e+03, -4.060000e+04,
         0.000000e+00, -1.100000e+04, -2.130000e+04, -1.840000e+04,
        -5.500000e+03, -2.130000e+04, -3.660000e+04, -3.020000e+04,
        -2.480000e+04, -6.120000e+04, -9.040000e+04, -6.800000e+04,
        -2.500000e+04,  3.900000e+03,  3.900000e+03,  3.900000e+03,
         3.900000e+03,  1.630000e+04,  3.900000e+03,  7.870000e+04,
         6.510000e+04,  6.880000e+04,  9.000000e+03,  5.800000e+03,
         6.500000e+03, -4.800000e+03,  3.700000e+03, -3.000000e+03,
        -3.000000e+03, -1.090000e+04, -1.880000e+04, -9.800000e+03,
        -4.300000e+03, -1.040000e+04, -1.370000e+04, -5.330000e+04,
         1.790000e+04, -1.160000e+04, -9.700000e+03,  3.600000e+03,
        -2.770000e+04, -2.770000e+04, -3.460000e+04, -3.270000e+04,
         1.800000e+03, -2.410000e+04, -6.800000e+03, -2.500000e+03,
        -8.700000e+03, -2.370000e+04,  2.414500e+06,  2.429400e+06,
        -1.570000e+04, -2.010000e+04, -2.010000e+04, -2.010000e+04,
        -2.010000e+04, -2.690000e+04, -2.690000e+04,  9.100000e+03,
        -1.840000e+04, -2.170000e+04,  1.600000e+03,  0.000000e+00,
        -6.200000e+03, -8.000000e+03,  1.090000e+04, -1.750000e+04,
        -1.120000e+04, -1.120000e+04, -8.200000e+03, -8.200000e+03,
        -8.200000e+03, -8.210000e+04, -9.890000e+04, -2.360000e+04,
        -7.000000e+03, -4.220000e+04, -5.210000e+04,  4.900000e+03,
        -6.830000e+04, -8.560000e+04, -1.092000e+05, -8.560000e+04,
        -1.093000e+05, -2.720000e+04,  6.640000e+04,  9.560000e+04,
         5.290000e+04, -6.100000e+03, -9.400000e+03, -1.512000e+05,
         1.630000e+04, -1.290000e+04, -1.630000e+04,  5.600000e+03,
         1.480000e+04,  1.290000e+04,  2.800000e+03,  5.400000e+03,
         4.210000e+04,  1.200000e+03, -4.510000e+04, -1.000000e+03,
         2.830000e+04, -3.020000e+04, -1.750000e+04, -1.330000e+04,
         3.100000e+03, -3.600000e+03, -4.160000e+04, -4.530000e+04,
        -5.500000e+04, -1.610000e+04, -4.210000e+04,  2.400000e+03,
        -5.560000e+04, -4.450000e+04, -1.090000e+04, -1.260000e+04,
        -2.050000e+04, -1.470000e+04, -1.470000e+04, -2.500000e+04,
        -7.730000e+04, -6.070000e+04, -2.728000e+05, -1.360000e+04,
        -1.360000e+04, -2.900000e+03, -2.900000e+03, -4.400000e+03,
        -2.800000e+03,  5.700000e+03, -2.900000e+03, -1.530000e+04,
        -1.530000e+04, -1.530000e+04, -1.530000e+04, -1.480000e+04,
         1.570000e+04,  1.570000e+04,  1.570000e+04,  2.310000e+04,
        -6.200000e+03,  0.000000e+00,  9.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  9.430000e+04,  2.740000e+04,  1.230000e+04,
        -6.400000e+03, -3.500000e+04, -3.490000e+04, -8.090000e+04,
        -8.080000e+04,  1.700000e+03,  6.500000e+03, -4.000000e+02,
         3.900000e+03,  1.400000e+03,  1.300000e+03,  1.000000e+03,
         1.920000e+04, -1.020000e+04,  3.300000e+03, -1.000000e+02,
         0.000000e+00,  0.000000e+00,  1.900000e+03,  5.000000e+03,
         1.400000e+03,  2.449700e+06,  2.454400e+06,  2.454400e+06,
         0.000000e+00,  0.000000e+00,  2.420000e+04,  2.100000e+04,
         5.100000e+03,  2.700000e+03,  8.900000e+03,  1.300000e+03,
         5.000000e+03,  4.000000e+03,  9.800000e+03,  1.700000e+03,
         6.600000e+03,  6.600000e+03,  5.400000e+03,  1.700000e+03,
         1.000000e+03,  1.200000e+04,  8.300000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  3.900000e+03,
         6.500000e+03,  2.500000e+03, -1.000000e+02,  3.300000e+03,
        -1.530000e+04,  0.000000e+00, -5.100000e+03, -1.160000e+04,
        -8.200000e+03, -2.010000e+04, -1.840000e+04,  3.900000e+03,
        -4.400000e+03, -2.900000e+03, -1.360000e+04,  1.570000e+04,
         1.230000e+04, -4.000000e+02,  2.454400e+06,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.530000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-5.100000e+03, -1.160000e+04, -9.900000e+03, -1.500000e+03,
        -3.300000e+03, -1.650000e+04, -6.300000e+03, -5.500000e+03,
        -1.160000e+04, -5.600000e+03, -1.150000e+04, -1.020000e+04,
        -1.310000e+04,  1.920000e+04,  0.000000e+00, -1.020000e+04,
        -8.300000e+03, -1.020000e+04, -1.500000e+03, -4.060000e+04,
         0.000000e+00, -1.100000e+04, -2.130000e+04, -1.840000e+04,
        -5.500000e+03, -2.130000e+04, -3.660000e+04, -3.020000e+04,
        -2.480000e+04, -6.120000e+04, -9.040000e+04, -6.800000e+04,
        -2.500000e+04,  3.900000e+03,  3.900000e+03,  3.900000e+03,
         3.900000e+03,  1.630000e+04,  3.900000e+03,  7.870000e+04,
         6.510000e+04,  6.880000e+04,  9.000000e+03,  5.800000e+03,
         6.500000e+03, -4.800000e+03,  3.700000e+03, -3.000000e+03,
        -3.000000e+03, -1.090000e+04, -1.880000e+04, -9.800000e+03,
        -4.300000e+03, -1.040000e+04, -1.370000e+04, -5.330000e+04,
         1.790000e+04, -1.160000e+04, -9.700000e+03,  3.600000e+03,
        -2.770000e+04, -2.770000e+04, -3.460000e+04, -3.270000e+04,
         1.800000e+03, -2.410000e+04, -6.800000e+03, -2.500000e+03,
        -8.700000e+03, -2.370000e+04,  2.414500e+06,  2.429400e+06,
        -1.570000e+04, -2.010000e+04, -2.010000e+04, -2.010000e+04,
        -2.010000e+04, -2.690000e+04, -2.690000e+04,  9.100000e+03,
        -1.840000e+04, -2.170000e+04,  1.600000e+03,  0.000000e+00,
        -6.200000e+03, -8.000000e+03,  1.090000e+04, -1.750000e+04,
        -1.120000e+04, -1.120000e+04, -8.200000e+03, -8.200000e+03,
        -8.200000e+03, -8.210000e+04, -9.890000e+04, -2.360000e+04,
        -7.000000e+03, -4.220000e+04, -5.210000e+04,  4.900000e+03,
        -6.830000e+04, -8.560000e+04, -1.092000e+05, -8.560000e+04,
        -1.093000e+05, -2.720000e+04,  6.640000e+04,  9.560000e+04,
         5.290000e+04, -6.100000e+03, -9.400000e+03, -1.512000e+05,
         1.630000e+04, -1.290000e+04, -1.630000e+04,  5.600000e+03,
         1.480000e+04,  1.290000e+04,  2.800000e+03,  5.400000e+03,
         4.210000e+04,  1.200000e+03, -4.510000e+04, -1.000000e+03,
         2.830000e+04, -3.020000e+04, -1.750000e+04, -1.330000e+04,
         3.100000e+03, -3.600000e+03, -4.160000e+04, -4.530000e+04,
        -5.500000e+04, -1.610000e+04, -4.210000e+04,  2.400000e+03,
        -5.560000e+04, -4.450000e+04, -1.090000e+04, -1.260000e+04,
        -2.050000e+04, -1.470000e+04, -1.470000e+04, -2.500000e+04,
        -7.730000e+04, -6.070000e+04, -2.728000e+05, -1.360000e+04,
        -1.360000e+04, -2.900000e+03, -2.900000e+03, -4.400000e+03,
        -2.800000e+03,  5.700000e+03, -2.900000e+03, -1.530000e+04,
        -1.530000e+04, -1.530000e+04, -1.530000e+04, -1.480000e+04,
         1.570000e+04,  1.570000e+04,  1.570000e+04,  2.310000e+04,
        -6.200000e+03,  0.000000e+00,  9.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  9.430000e+04,  2.740000e+04,  1.230000e+04,
        -6.400000e+03, -3.500000e+04, -3.490000e+04, -8.090000e+04,
        -8.080000e+04,  1.700000e+03,  6.500000e+03, -4.000000e+02,
         3.900000e+03,  1.400000e+03,  1.300000e+03,  1.000000e+03,
         1.920000e+04, -1.020000e+04,  3.300000e+03, -1.000000e+02,
         0.000000e+00,  0.000000e+00,  1.900000e+03,  5.000000e+03,
         1.400000e+03,  2.449700e+06,  2.454400e+06,  2.456400e+06,
         0.000000e+00,  0.000000e+00,  2.420000e+04,  2.100000e+04,
         5.100000e+03,  2.700000e+03,  8.900000e+03,  1.300000e+03,
         5.000000e+03,  4.000000e+03,  9.800000e+03,  1.700000e+03,
         6.600000e+03,  6.600000e+03,  5.400000e+03,  1.700000e+03,
         1.000000e+03,  1.200000e+04,  8.300000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  3.900000e+03,
         6.500000e+03,  2.500000e+03, -1.000000e+02,  3.300000e+03,
        -1.530000e+04,  0.000000e+00, -5.100000e+03, -1.160000e+04,
        -8.200000e+03, -2.010000e+04, -1.840000e+04,  3.900000e+03,
        -4.400000e+03, -2.900000e+03, -1.360000e+04,  1.570000e+04,
         1.230000e+04, -4.000000e+02,  2.456400e+06,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.530000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.395600e+06,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.395600e+06,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -5.500000e+03,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.100000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [ 8.000000e+04, -8.720000e+04, -5.940000e+04, -8.710000e+04,
        -3.800000e+03,  3.902000e+05,  2.302000e+05,  7.060000e+04,
        -8.720000e+04,  6.880000e+04, -8.700000e+04, -1.370000e+04,
        -9.000000e+04,  5.325000e+05,  0.000000e+00, -1.370000e+04,
        -9.620000e+04, -1.440000e+04, -1.050000e+04, -5.480000e+04,
         0.000000e+00,  4.973000e+05,  2.389000e+05,  2.862000e+05,
         2.392000e+05, -2.707000e+05, -2.714000e+05, -3.700000e+04,
        -2.904000e+05,  4.558000e+05, -9.280000e+04,  2.871000e+05,
         1.369500e+06,  4.253000e+05,  4.256000e+05,  4.261000e+05,
         4.231000e+05,  6.110000e+05,  4.255000e+05,  4.369800e+06,
         4.026500e+06,  4.088400e+06,  5.208000e+05,  4.343000e+05,
         4.505000e+05, -9.100000e+04, -1.666000e+05,  4.957000e+05,
         4.957000e+05,  2.391000e+05, -1.630000e+04,  2.548000e+05,
         3.275000e+05,  8.206000e+05,  7.342000e+05, -5.487000e+05,
         4.429000e+05, -1.001000e+05, -1.835000e+05, -1.676000e+05,
         7.201000e+05,  7.200000e+05,  5.498000e+05,  5.793000e+05,
         3.716000e+05, -9.640000e+04,  7.970000e+04,  4.447000e+05,
        -1.021000e+05, -2.021000e+05, -8.010000e+04,  2.180000e+04,
        -1.117000e+05, -2.600000e+04, -2.600000e+04, -2.600000e+04,
        -2.600000e+04, -1.940000e+05, -1.940000e+05,  5.250000e+05,
        -1.091000e+05, -1.929000e+05,  5.400000e+03,  0.000000e+00,
        -2.505000e+05, -2.628000e+05,  4.345000e+05,  5.630000e+04,
        -7.380000e+04, -7.380000e+04, -9.620000e+04, -9.620000e+04,
        -9.620000e+04, -3.642000e+05, -7.837000e+05,  7.356000e+05,
         5.001000e+05, -1.343000e+05, -3.842000e+05,  1.876000e+05,
        -9.011000e+05, -1.974000e+05, -7.854000e+05, -1.974000e+05,
        -7.859000e+05,  8.951000e+05,  2.314400e+06,  2.865100e+06,
         1.977400e+06,  4.128000e+05,  3.264000e+05, -1.112700e+06,
         4.810000e+05, -6.340000e+04, -1.492000e+05,  4.320000e+05,
         8.599000e+05,  2.299000e+05, -2.210000e+04,  1.880000e+04,
         7.745000e+05,  1.791000e+05, -1.451000e+05,  6.864000e+05,
         1.237700e+06,  1.351000e+05,  2.547000e+05,  3.346000e+05,
         9.323000e+05,  7.596000e+05,  1.034000e+05, -1.453000e+05,
        -4.049000e+05,  3.999000e+05,  1.055000e+05,  1.819000e+05,
        -3.979000e+05, -1.631000e+05,  3.151000e+05,  2.299000e+05,
        -2.670000e+04,  7.200000e+04,  7.190000e+04, -1.843000e+05,
        -2.737000e+05,  1.580000e+05,  8.594000e+05, -9.990000e+04,
        -1.000000e+05, -5.100000e+04, -5.100000e+04,  3.272000e+05,
        -5.110000e+04, -4.209000e+05, -5.100000e+04, -1.068000e+05,
        -1.068000e+05, -1.068000e+05, -1.067000e+05, -9.780000e+04,
         1.025000e+05,  1.024000e+05,  1.024000e+05,  6.009000e+05,
         5.490000e+04,  0.000000e+00,  5.990000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  6.146000e+05,  1.616000e+05,  5.530000e+04,
         9.897000e+05,  1.137000e+05,  1.137000e+05, -2.067000e+05,
        -2.068000e+05,  6.700000e+03,  1.050000e+04, -4.900000e+03,
         6.830000e+04, -5.000000e+02,  7.000000e+03,  4.800000e+03,
         5.325000e+05, -1.350000e+04,  1.760000e+04, -1.800000e+03,
         0.000000e+00,  0.000000e+00,  1.580000e+04,  8.030000e+04,
         3.800000e+03,  2.410000e+04,  2.420000e+04,  2.420000e+04,
         0.000000e+00,  0.000000e+00,  6.353000e+05,  5.418000e+05,
         2.660000e+04,  3.560000e+04,  1.485000e+05,  3.500000e+03,
         9.880000e+04,  7.010000e+04,  2.654000e+05,  8.800000e+03,
         8.000000e+03,  8.000000e+03,  8.620000e+04,  7.900000e+03,
         7.400000e+03,  9.320000e+04,  1.570000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -6.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  6.830000e+04,
         1.050000e+04,  6.990000e+04, -1.800000e+03,  1.760000e+04,
        -1.068000e+05,  0.000000e+00,  8.000000e+04, -8.720000e+04,
        -9.620000e+04, -2.600000e+04, -1.091000e+05,  4.233000e+05,
         3.272000e+05, -5.100000e+04, -1.000000e+05,  1.024000e+05,
         5.530000e+04, -4.900000e+03,  2.420000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.068000e+05,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00],
       [-5.340000e+04,  8.860000e+04, -6.010000e+04, -7.120000e+04,
        -6.220000e+04, -2.000000e+05, -9.320000e+04, -5.540000e+04,
         8.860000e+04, -5.580000e+04,  8.850000e+04, -7.230000e+04,
         2.000000e+02,  5.236000e+05,  0.000000e+00, -7.230000e+04,
        -8.080000e+04, -7.250000e+04,  0.000000e+00, -2.889000e+05,
         0.000000e+00,  3.084000e+05,  5.548000e+05,  2.984000e+05,
         2.763000e+05, -8.050000e+04,  1.553000e+05, -2.153000e+05,
        -2.434000e+05,  4.346000e+05, -1.607000e+05,  5.814000e+05,
         1.450700e+06,  4.315000e+05,  4.319000e+05,  4.329000e+05,
         4.322000e+05,  6.088000e+05,  4.319000e+05,  4.103800e+06,
  