# This file is part of BurnMan - a thermoelastic and thermodynamic toolkit
# for the Earth and Planetary Sciences
# Copyright (C) 2012 - 2021 by the BurnMan team, released under the GNU
# GPL v2 or later.


"""
HP_2011_ds62
^^^^^^^^^^^^

Endmember minerals from Holland and Powell 2011 and references therein.
Update to dataset version 6.2.
The values in this document are all in S.I. units,
unlike those in the original tc-ds62.txt.
File autogenerated using HPdata_to_burnman.py.
"""


from ..classes.mineral import Mineral

"""
ENDMEMBERS
"""


class fo (Mineral):
    def __init__(self):
        self.params = {'name': 'fo',
                       'formula': {'Mg': 2.0, 'O': 4.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -2172590.0,
                       'S_0': 95.1,
                       'V_0': 4.366e-05,
                       'Cp': [233.3, 0.001494, -603800.0, -1869.7],
                       'a_0': 2.85e-05,
                       'K_0': 128500e6,
                       'Kprime_0': 3.84,
                       'Kdprime_0': -3e-11,
                       'n': 7.0,
                       'molar_mass': 0.1406931}
        Mineral.__init__(self)


class fa (Mineral):
    def __init__(self):
        self.params = {'name': 'fa',
                       'formula': {'Fe': 2.0, 'O': 4.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1477720.0,
                       'S_0': 151.0,
                       'V_0': 4.631e-05,
                       'Cp': [201.1, 0.01733, -1960600.0, -900.9],
                       'a_0': 2.82e-05,
                       'K_0': 125600e6,
                       'Kprime_0': 4.68,
                       'Kdprime_0': -3.7e-11,
                       'n': 7.0,
                       'molar_mass': 0.2037731}
        Mineral.__init__(self)


class teph (Mineral):
    def __init__(self):
        self.params = {'name': 'teph',
                       'formula': {'Mn': 2.0, 'O': 4.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1733970.0,
                       'S_0': 155.9,
                       'V_0': 4.899e-05,
                       'Cp': [219.6, 0.0, -1292700.0, -1308.3],
                       'a_0': 2.86e-05,
                       'K_0': 125600e6,
                       'Kprime_0': 4.68,
                       'Kdprime_0': -3.7e-11,
                       'n': 7.0,
                       'molar_mass': 0.2019591}
        Mineral.__init__(self)


class lrn (Mineral):
    def __init__(self):
        self.params = {'name': 'lrn',
                       'formula': {'Ca': 2.0, 'O': 4.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -2306920.0,
                       'S_0': 127.6,
                       'V_0': 5.16e-05,
                       'Cp': [247.5, -0.003206, 0.0, -2051.9],
                       'a_0': 2.9e-05,
                       'K_0': 98500e6,
                       'Kprime_0': 4.07,
                       'Kdprime_0': -4.1e-11,
                       'n': 7.0,
                       'molar_mass': 0.1722391}
        self.property_modifiers = [['landau_hp', {'P_0': 100000.0,
                                                  'T_0': 298.15,
                                                  'Tc_0': 1710.0,
                                                  'S_D': 10.03,
                                                  'V_D': 5e-07}]]
        Mineral.__init__(self)


class mont (Mineral):
    def __init__(self):
        self.params = {'name': 'mont',
                       'formula': {'Ca': 1.0, 'Mg': 1.0, 'O': 4.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -2251260.0,
                       'S_0': 109.5,
                       'V_0': 5.148e-05,
                       'Cp': [250.7, -0.010433, -797200.0, -1996.1],
                       'a_0': 2.87e-05,
                       'K_0': 113400e6,
                       'Kprime_0': 3.87,
                       'Kdprime_0': -3.4e-11,
                       'n': 7.0,
                       'molar_mass': 0.1564661}
        Mineral.__init__(self)


class chum (Mineral):
    def __init__(self):
        self.params = {'name': 'chum',
                       'formula': {'H': 2.0, 'Mg': 9.0, 'O': 18.0, 'Si': 4.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -9613540.0,
                       'S_0': 440.5,
                       'V_0': 0.00019801,
                       'Cp': [1071.0, -0.016533, -7899600.0, -7373.9],
                       'a_0': 3.2e-05,
                       'K_0': 119900e6,
                       'Kprime_0': 4.58,
                       'Kdprime_0': -3.8e-11,
                       'n': 33.0,
                       'molar_mass': 0.62109208}
        Mineral.__init__(self)


class chdr (Mineral):
    def __init__(self):
        self.params = {'name': 'chdr',
                       'formula': {'H': 2.0, 'Mg': 5.0, 'O': 10.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -5254890.0,
                       'S_0': 260.0,
                       'V_0': 0.00011084,
                       'Cp': [625.0, -0.001088, -2259900.0, -4910.7],
                       'a_0': 1.82e-05,
                       'K_0': 116100e6,
                       'Kprime_0': 4.8,
                       'Kdprime_0': -4.1e-11,
                       'n': 19.0,
                       'molar_mass': 0.33970588}
        Mineral.__init__(self)


class mwd (Mineral):
    def __init__(self):
        self.params = {'name': 'mwd',
                       'formula': {'Mg': 2.0, 'O': 4.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -2138520.0,
                       'S_0': 93.9,
                       'V_0': 4.051e-05,
                       'Cp': [208.7, 0.003942, -1709500.0, -1302.8],
                       'a_0': 2.37e-05,
                       'K_0': 172600e6,
                       'Kprime_0': 3.84,
                       'Kdprime_0': -2.2e-11,
                       'n': 7.0,
                       'molar_mass': 0.1406931}
        Mineral.__init__(self)


class fwd (Mineral):
    def __init__(self):
        self.params = {'name': 'fwd',
                       'formula': {'Fe': 2.0, 'O': 4.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1467900.0,
                       'S_0': 146.0,
                       'V_0': 4.321e-05,
                       'Cp': [201.1, 0.01733, -1960600.0, -900.9],
                       'a_0': 2.73e-05,
                       'K_0': 169000e6,
                       'Kprime_0': 4.35,
                       'Kdprime_0': -2.6e-11,
                       'n': 7.0,
                       'molar_mass': 0.2037731}
        Mineral.__init__(self)


class mrw (Mineral):
    def __init__(self):
        self.params = {'name': 'mrw',
                       'formula': {'Mg': 2.0, 'O': 4.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -2127680.0,
                       'S_0': 90.0,
                       'V_0': 3.949e-05,
                       'Cp': [213.3, 0.00269, -1410400.0, -1495.9],
                       'a_0': 2.01e-05,
                       'K_0': 178100e6,
                       'Kprime_0': 4.35,
                       'Kdprime_0': -2.4e-11,
                       'n': 7.0,
                       'molar_mass': 0.1406931}
        Mineral.__init__(self)


class frw (Mineral):
    def __init__(self):
        self.params = {'name': 'frw',
                       'formula': {'Fe': 2.0, 'O': 4.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1471760.0,
                       'S_0': 140.0,
                       'V_0': 4.203e-05,
                       'Cp': [166.8, 0.04261, -1705400.0, -541.4],
                       'a_0': 2.22e-05,
                       'K_0': 197700e6,
                       'Kprime_0': 4.92,
                       'Kdprime_0': -2.5e-11,
                       'n': 7.0,
                       'molar_mass': 0.2037731}
        Mineral.__init__(self)


class mpv (Mineral):
    def __init__(self):
        self.params = {'name': 'mpv',
                       'formula': {'Mg': 1.0, 'O': 3.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1443030.0,
                       'S_0': 62.6,
                       'V_0': 2.445e-05,
                       'Cp': [149.3, 0.002918, -2983000.0, -799.1],
                       'a_0': 1.87e-05,
                       'K_0': 251000e6,
                       'Kprime_0': 4.14,
                       'Kdprime_0': -1.6e-11,
                       'n': 5.0,
                       'molar_mass': 0.1003887}
        Mineral.__init__(self)


class fpv (Mineral):
    def __init__(self):
        self.params = {'name': 'fpv',
                       'formula': {'Fe': 1.0, 'O': 3.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1084640.0,
                       'S_0': 91.0,
                       'V_0': 2.548e-05,
                       'Cp': [133.2, 0.01083, -3661400.0, -314.7],
                       'a_0': 1.87e-05,
                       'K_0': 281000e6,
                       'Kprime_0': 4.14,
                       'Kdprime_0': -1.6e-11,
                       'n': 5.0,
                       'molar_mass': 0.1319287}
        Mineral.__init__(self)


class apv (Mineral):
    def __init__(self):
        self.params = {'name': 'apv',
                       'formula': {'Al': 2.0, 'O': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1646630.0,
                       'S_0': 51.8,
                       'V_0': 2.54e-05,
                       'Cp': [139.5, 0.00589, -2460600.0, -589.2],
                       'a_0': 1.8e-05,
                       'K_0': 203000e6,
                       'Kprime_0': 4.0,
                       'Kdprime_0': -2e-11,
                       'n': 5.0,
                       'molar_mass': 0.1019612}
        Mineral.__init__(self)


class cpv (Mineral):
    def __init__(self):
        self.params = {'name': 'cpv',
                       'formula': {'Ca': 1.0, 'O': 3.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1541730.0,
                       'S_0': 73.5,
                       'V_0': 2.745e-05,
                       'Cp': [159.3, 0.0, -967300.0, -1075.4],
                       'a_0': 1.87e-05,
                       'K_0': 236000e6,
                       'Kprime_0': 3.9,
                       'Kdprime_0': -1.6e-11,
                       'n': 5.0,
                       'molar_mass': 0.1161617}
        Mineral.__init__(self)


class mak (Mineral):
    def __init__(self):
        self.params = {'name': 'mak',
                       'formula': {'Mg': 1.0, 'O': 3.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1490870.0,
                       'S_0': 59.3,
                       'V_0': 2.635e-05,
                       'Cp': [147.8, 0.002015, -2395000.0, -801.8],
                       'a_0': 2.12e-05,
                       'K_0': 211000e6,
                       'Kprime_0': 4.55,
                       'Kdprime_0': -2.2e-11,
                       'n': 5.0,
                       'molar_mass': 0.1003887}
        Mineral.__init__(self)


class fak (Mineral):
    def __init__(self):
        self.params = {'name': 'fak',
                       'formula': {'Fe': 1.0, 'O': 3.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1142140.0,
                       'S_0': 91.5,
                       'V_0': 2.76e-05,
                       'Cp': [100.3, 0.013328, -4364900.0, 419.8],
                       'a_0': 2.12e-05,
                       'K_0': 218000e6,
                       'Kprime_0': 4.55,
                       'Kdprime_0': -2.2e-11,
                       'n': 5.0,
                       'molar_mass': 0.1319287}
        Mineral.__init__(self)


class maj (Mineral):
    def __init__(self):
        self.params = {'name': 'maj',
                       'formula': {'Mg': 4.0, 'O': 12.0, 'Si': 4.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -6050400.0,
                       'S_0': 255.2,
                       'V_0': 0.00011457,
                       'Cp': [713.6, -0.000997, -1158200.0, -6622.3],
                       'a_0': 1.83e-05,
                       'K_0': 160000e6,
                       'Kprime_0': 4.56,
                       'Kdprime_0': -2.8e-11,
                       'n': 20.0,
                       'molar_mass': 0.4015548}
        Mineral.__init__(self)


class py (Mineral):
    def __init__(self):
        self.params = {'name': 'py',
                       'formula': {'Al': 2.0, 'Mg': 3.0, 'O': 12.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -6281960.0,
                       'S_0': 269.5,
                       'V_0': 0.00011313,
                       'Cp': [633.5, 0.0, -5196100.0, -4315.2],
                       'a_0': 2.37e-05,
                       'K_0': 174300e6,
                       'Kprime_0': 4.05,
                       'Kdprime_0': -2.3e-11,
                       'n': 20.0,
                       'molar_mass': 0.4031273}
        Mineral.__init__(self)


class alm (Mineral):
    def __init__(self):
        self.params = {'name': 'alm',
                       'formula': {'Al': 2.0, 'Fe': 3.0, 'O': 12.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -5260700.0,
                       'S_0': 342.0,
                       'V_0': 0.00011525,
                       'Cp': [677.3, 0.0, -3772700.0, -5044.0],
                       'a_0': 2.12e-05,
                       'K_0': 190000e6,
                       'Kprime_0': 2.98,
                       'Kdprime_0': -1.6e-11,
                       'n': 20.0,
                       'molar_mass': 0.4977473}
        Mineral.__init__(self)


class spss (Mineral):
    def __init__(self):
        self.params = {'name': 'spss',
                       'formula': {'Al': 2.0, 'Mn': 3.0, 'O': 12.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -5693490.0,
                       'S_0': 335.3,
                       'V_0': 0.00011792,
                       'Cp': [646.9, 0.0, -4525800.0, -4452.8],
                       'a_0': 2.27e-05,
                       'K_0': 174000e6,
                       'Kprime_0': 6.68,
                       'Kdprime_0': -3.8e-11,
                       'n': 20.0,
                       'molar_mass': 0.4950263}
        Mineral.__init__(self)


class gr (Mineral):
    def __init__(self):
        self.params = {'name': 'gr',
                       'formula': {'Al': 2.0, 'Ca': 3.0, 'O': 12.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -6643010.0,
                       'S_0': 255.0,
                       'V_0': 0.00012535,
                       'Cp': [626.0, 0.0, -5779200.0, -4002.9],
                       'a_0': 2.2e-05,
                       'K_0': 172000e6,
                       'Kprime_0': 5.53,
                       'Kdprime_0': -3.2e-11,
                       'n': 20.0,
                       'molar_mass': 0.4504463}
        Mineral.__init__(self)


class andr (Mineral):
    def __init__(self):
        self.params = {'name': 'andr',
                       'formula': {'Ca': 3.0, 'Fe': 2.0, 'O': 12.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -5769100.0,
                       'S_0': 316.4,
                       'V_0': 0.00013204,
                       'Cp': [638.6, 0.0, -4955100.0, -3989.2],
                       'a_0': 2.86e-05,
                       'K_0': 158800e6,
                       'Kprime_0': 5.68,
                       'Kdprime_0': -3.6e-11,
                       'n': 20.0,
                       'molar_mass': 0.5081733}
        Mineral.__init__(self)


class knor (Mineral):
    def __init__(self):
        self.params = {'name': 'knor',
                       'formula': {'Cr': 2.0, 'Mg': 3.0, 'O': 12.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -5687710.0,
                       'S_0': 317.0,
                       'V_0': 0.00011738,
                       'Cp': [613.0, 0.003606, -4178000.0, -3729.4],
                       'a_0': 2.37e-05,
                       'K_0': 174300e6,
                       'Kprime_0': 4.05,
                       'Kdprime_0': -2.3e-11,
                       'n': 20.0,
                       'molar_mass': 0.4531565}
        Mineral.__init__(self)


class osma (Mineral):
    def __init__(self):
        self.params = {'name': 'osma',
                       'formula': {'Al': 5.0, 'K': 1.0, 'Mg': 2.0, 'O': 30.0, 'Si': 10.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -14896310.0,
                       'S_0': 755.0,
                       'V_0': 0.00037893,
                       'Cp': [1540.7, -0.011359, -10339000.0, -11699.0],
                       'a_0': 4.7e-06,
                       'K_0': 129000e6,
                       'Kprime_0': 4.1,
                       'Kdprime_0': -3.1e-11,
                       'n': 48.0,
                       'molar_mass': 0.9834528}
        Mineral.__init__(self)


class osmm (Mineral):
    def __init__(self):
        self.params = {'name': 'osmm',
                       'formula': {'Al': 3.0, 'K': 1.0, 'Mg': 3.0, 'O': 30.0, 'Si': 11.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -14786740.0,
                       'S_0': 740.0,
                       'V_0': 0.0003844,
                       'Cp': [1525.5, -0.010267, -10538000.0, -11337.0],
                       'a_0': 4.7e-06,
                       'K_0': 129000e6,
                       'Kprime_0': 4.1,
                       'Kdprime_0': -3.1e-11,
                       'n': 48.0,
                       'molar_mass': 0.9818803}
        Mineral.__init__(self)


class osfa (Mineral):
    def __init__(self):
        self.params = {'name': 'osfa',
                       'formula': {'Al': 5.0, 'Fe': 2.0, 'K': 1.0, 'O': 30.0, 'Si': 10.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -14215490.0,
                       'S_0': 780.0,
                       'V_0': 0.0003845,
                       'Cp': [1558.6, -0.011359, -9476500.0, -11845.0],
                       'a_0': 4.9e-06,
                       'K_0': 129000e6,
                       'Kprime_0': 4.1,
                       'Kdprime_0': -3.1e-11,
                       'n': 48.0,
                       'molar_mass': 1.0465328}
        Mineral.__init__(self)


class vsv (Mineral):
    def __init__(self):
        self.params = {'name': 'vsv',
                       'formula': {'Al': 11.0, 'Ca': 19.0, 'H': 9.0, 'Mg': 2.0, 'O': 78.0, 'Si': 18.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -42345820.0,
                       'S_0': 1890.0,
                       'V_0': 0.000852,
                       'Cp': [4488.0, -0.057952, -22269300.0, -33478.0],
                       'a_0': 2.75e-05,
                       'K_0': 125500e6,
                       'Kprime_0': 4.8,
                       'Kdprime_0': -3.8e-11,
                       'n': 137.0,
                       'molar_mass': 2.86945216}
        Mineral.__init__(self)


class andalusite (Mineral):
    def __init__(self):
        self.params = {'name': 'and',
                       'formula': {'Al': 2.0, 'O': 5.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -2588670.0,
                       'S_0': 92.7,
                       'V_0': 5.153e-05,
                       'Cp': [277.3, -0.006588, -1914100.0, -2265.6],
                       'a_0': 1.81e-05,
                       'K_0': 144200e6,
                       'Kprime_0': 6.89,
                       'Kdprime_0': -4.8e-11,
                       'n': 8.0,
                       'molar_mass': 0.1620455}
        Mineral.__init__(self)


class ky (Mineral):
    def __init__(self):
        self.params = {'name': 'ky',
                       'formula': {'Al': 2.0, 'O': 5.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -2592970.0,
                       'S_0': 83.5,
                       'V_0': 4.414e-05,
                       'Cp': [279.4, -0.007124, -2055600.0, -2289.4],
                       'a_0': 1.92e-05,
                       'K_0': 160100e6,
                       'Kprime_0': 4.05,
                       'Kdprime_0': -2.5e-11,
                       'n': 8.0,
                       'molar_mass': 0.1620455}
        Mineral.__init__(self)


class sill (Mineral):
    def __init__(self):
        self.params = {'name': 'sill',
                       'formula': {'Al': 2.0, 'O': 5.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -2585790.0,
                       'S_0': 95.4,
                       'V_0': 4.986e-05,
                       'Cp': [280.2, -0.0069, -1375700.0, -2399.4],
                       'a_0': 1.12e-05,
                       'K_0': 164000e6,
                       'Kprime_0': 5.06,
                       'Kdprime_0': -3.1e-11,
                       'n': 8.0,
                       'molar_mass': 0.1620455}
        self.property_modifiers = [['bragg_williams', {'deltaH': 4750.0,
                                                       'deltaV': 1e-07,
                                                       'Wh': 4750.0,
                                                       'Wv': 1e-07,
                                                       'n': 1.0,
                                                       'factor': 0.25}]]
        Mineral.__init__(self)


class smul (Mineral):
    def __init__(self):
        self.params = {'name': 'smul',
                       'formula': {'Al': 2.0, 'O': 5.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -2569210.0,
                       'S_0': 101.5,
                       'V_0': 4.987e-05,
                       'Cp': [280.2, -0.0069, -1375700.0, -2399.4],
                       'a_0': 1.36e-05,
                       'K_0': 174000e6,
                       'Kprime_0': 4.0,
                       'Kdprime_0': -2.3e-11,
                       'n': 8.0,
                       'molar_mass': 0.1620455}
        Mineral.__init__(self)


class amul (Mineral):
    def __init__(self):
        self.params = {'name': 'amul',
                       'formula': {'Al': 2.5, 'O': 4.75, 'Si': 0.5},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -2485530.0,
                       'S_0': 113.0,
                       'V_0': 5.083e-05,
                       'Cp': [244.8, 0.000968, -2533300.0, -1641.6],
                       'a_0': 1.36e-05,
                       'K_0': 174000e6,
                       'Kprime_0': 4.0,
                       'Kdprime_0': -2.3e-11,
                       'n': 7.75,
                       'molar_mass': 0.15749365}
        Mineral.__init__(self)


class tpz (Mineral):
    def __init__(self):
        self.params = {'name': 'tpz',
                       'formula': {'Al': 2.0, 'H': 2.0, 'O': 6.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -2900710.0,
                       'S_0': 100.5,
                       'V_0': 5.339e-05,
                       'Cp': [387.7, -0.00712, -857200.0, -3744.2],
                       'a_0': 1.57e-05,
                       'K_0': 131500e6,
                       'Kprime_0': 4.06,
                       'Kdprime_0': -3.1e-11,
                       'n': 11.0,
                       'molar_mass': 0.18006078}
        Mineral.__init__(self)


class mst (Mineral):
    def __init__(self):
        self.params = {'name': 'mst',
                       'formula': {'Al': 18.0, 'H': 4.0, 'Mg': 4.0, 'O': 48.0, 'Si': 7.5},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -25123740.0,
                       'S_0': 910.0,
                       'V_0': 0.0004426,
                       'Cp': [2820.5, -0.059366, -13774000.0, -24126.0],
                       'a_0': 1.81e-05,
                       'K_0': 168400e6,
                       'Kprime_0': 4.05,
                       'Kdprime_0': -2.4e-11,
                       'n': 81.5,
                       'molar_mass': 1.56553121}
        Mineral.__init__(self)


class fst (Mineral):
    def __init__(self):
        self.params = {'name': 'fst',
                       'formula': {'Al': 18.0, 'Fe': 4.0, 'H': 4.0, 'O': 48.0, 'Si': 7.5},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -23754630.0,
                       'S_0': 1010.0,
                       'V_0': 0.0004488,
                       'Cp': [2880.0, -0.056595, -10642000.0, -25373.0],
                       'a_0': 1.83e-05,
                       'K_0': 180000e6,
                       'Kprime_0': 4.76,
                       'Kdprime_0': -2.6e-11,
                       'n': 81.5,
                       'molar_mass': 1.69169121}
        Mineral.__init__(self)


class mnst (Mineral):
    def __init__(self):
        self.params = {'name': 'mnst',
                       'formula': {'Al': 18.0, 'H': 4.0, 'Mn': 4.0, 'O': 48.0, 'Si': 7.5},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -24245850.0,
                       'S_0': 1034.0,
                       'V_0': 0.0004546,
                       'Cp': [2873.3, -0.089064, -12688000.0, -24749.0],
                       'a_0': 2.09e-05,
                       'K_0': 180000e6,
                       'Kprime_0': 4.76,
                       'Kdprime_0': -2.6e-11,
                       'n': 81.5,
                       'molar_mass': 1.68806321}
        Mineral.__init__(self)


class mctd (Mineral):
    def __init__(self):
        self.params = {'name': 'mctd',
                       'formula': {'Al': 2.0, 'H': 2.0, 'Mg': 1.0, 'O': 7.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -3549250.0,
                       'S_0': 146.0,
                       'V_0': 6.875e-05,
                       'Cp': [417.4, -0.003771, -2920600.0, -3417.8],
                       'a_0': 2.63e-05,
                       'K_0': 145600e6,
                       'Kprime_0': 4.06,
                       'Kdprime_0': -2.8e-11,
                       'n': 13.0,
                       'molar_mass': 0.22036518}
        Mineral.__init__(self)


class fctd (Mineral):
    def __init__(self):
        self.params = {'name': 'fctd',
                       'formula': {'Al': 2.0, 'Fe': 1.0, 'H': 2.0, 'O': 7.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -3208290.0,
                       'S_0': 167.0,
                       'V_0': 6.98e-05,
                       'Cp': [416.1, -0.003477, -2835900.0, -3360.3],
                       'a_0': 2.8e-05,
                       'K_0': 145600e6,
                       'Kprime_0': 4.06,
                       'Kdprime_0': -2.8e-11,
                       'n': 13.0,
                       'molar_mass': 0.25190518}
        Mineral.__init__(self)


class mnctd (Mineral):
    def __init__(self):
        self.params = {'name': 'mnctd',
                       'formula': {'Al': 2.0, 'H': 2.0, 'Mn': 1.0, 'O': 7.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -3336150.0,
                       'S_0': 166.0,
                       'V_0': 7.175e-05,
                       'Cp': [464.4, -0.012654, -1147200.0, -4341.0],
                       'a_0': 2.6e-05,
                       'K_0': 145600e6,
                       'Kprime_0': 4.06,
                       'Kdprime_0': -2.8e-11,
                       'n': 13.0,
                       'molar_mass': 0.25099818}
        Mineral.__init__(self)


class merw (Mineral):
    def __init__(self):
        self.params = {'name': 'merw',
                       'formula': {'Ca': 3.0, 'Mg': 1.0, 'O': 8.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -4545700.0,
                       'S_0': 253.1,
                       'V_0': 9.847e-05,
                       'Cp': [417.5, 0.008117, -2923000.0, -2320.3],
                       'a_0': 3.19e-05,
                       'K_0': 120000e6,
                       'Kprime_0': 4.07,
                       'Kdprime_0': -3.4e-11,
                       'n': 14.0,
                       'molar_mass': 0.3287052}
        Mineral.__init__(self)


class spu (Mineral):
    def __init__(self):
        self.params = {'name': 'spu',
                       'formula': {'C': 1.0, 'Ca': 5.0, 'O': 11.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -5846720.0,
                       'S_0': 332.0,
                       'V_0': 0.00014697,
                       'Cp': [614.1, -0.003508, -2493100.0, -4168.0],
                       'a_0': 3.4e-05,
                       'K_0': 95000e6,
                       'Kprime_0': 4.09,
                       'Kdprime_0': -4.3e-11,
                       'n': 19.0,
                       'molar_mass': 0.4445651}
        Mineral.__init__(self)


class zo (Mineral):
    def __init__(self):
        self.params = {'name': 'zo',
                       'formula': {'Al': 3.0, 'Ca': 2.0, 'H': 1.0, 'O': 13.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -6896290.0,
                       'S_0': 298.0,
                       'V_0': 0.00013575,
                       'Cp': [662.0, 0.010416, -6006400.0, -4260.7],
                       'a_0': 3.12e-05,
                       'K_0': 104400e6,
                       'Kprime_0': 4.0,
                       'Kdprime_0': -3.8e-11,
                       'n': 22.0,
                       'molar_mass': 0.45435714}
        Mineral.__init__(self)


class cz (Mineral):
    def __init__(self):
        self.params = {'name': 'cz',
                       'formula': {'Al': 3.0, 'Ca': 2.0, 'H': 1.0, 'O': 13.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -6895540.0,
                       'S_0': 301.0,
                       'V_0': 0.0001363,
                       'Cp': [630.9, 0.013693, -6645800.0, -3731.1],
                       'a_0': 2.33e-05,
                       'K_0': 119700e6,
                       'Kprime_0': 4.07,
                       'Kdprime_0': -3.4e-11,
                       'n': 22.0,
                       'molar_mass': 0.45435714}
        Mineral.__init__(self)


class ep (Mineral):
    def __init__(self):
        self.params = {'name': 'ep',
                       'formula': {'Al': 2.0, 'Ca': 2.0, 'Fe': 1.0, 'H': 1.0, 'O': 13.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -6473830.0,
                       'S_0': 315.0,
                       'V_0': 0.0001392,
                       'Cp': [613.3, 0.02207, -7160000.0, -2987.7],
                       'a_0': 2.34e-05,
                       'K_0': 134000e6,
                       'Kprime_0': 4.0,
                       'Kdprime_0': -3e-11,
                       'n': 22.0,
                       'molar_mass': 0.48322064}
        Mineral.__init__(self)


class fep (Mineral):
    def __init__(self):
        self.params = {'name': 'fep',
                       'formula': {'Al': 1.0, 'Ca': 2.0, 'Fe': 2.0, 'H': 1.0, 'O': 13.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -6028590.0,
                       'S_0': 329.0,
                       'V_0': 0.0001421,
                       'Cp': [584.7, 0.030447, -7674200.0, -2244.3],
                       'a_0': 2.31e-05,
                       'K_0': 151300e6,
                       'Kprime_0': 4.0,
                       'Kdprime_0': -2.6e-11,
                       'n': 22.0,
                       'molar_mass': 0.51208414}
        Mineral.__init__(self)


class pmt (Mineral):
    def __init__(self):
        self.params = {'name': 'pmt',
                       'formula': {'Al': 2.0, 'Ca': 2.0, 'H': 1.0, 'Mn': 1.0, 'O': 13.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -6543030.0,
                       'S_0': 340.0,
                       'V_0': 0.0001382,
                       'Cp': [569.8, 0.02779, -5442900.0, -2812.6],
                       'a_0': 2.38e-05,
                       'K_0': 119700e6,
                       'Kprime_0': 4.07,
                       'Kdprime_0': -3.4e-11,
                       'n': 22.0,
                       'molar_mass': 0.48231364}
        Mineral.__init__(self)


class law (Mineral):
    def __init__(self):
        self.params = {'name': 'law',
                       'formula': {'Al': 2.0, 'Ca': 1.0, 'H': 4.0, 'O': 10.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -4868630.0,
                       'S_0': 229.0,
                       'V_0': 0.00010132,
                       'Cp': [687.8, 0.001566, 375900.0, -7179.2],
                       'a_0': 2.65e-05,
                       'K_0': 122900e6,
                       'Kprime_0': 5.45,
                       'Kdprime_0': -4.4e-11,
                       'n': 19.0,
                       'molar_mass': 0.31423776}
        Mineral.__init__(self)


class mpm (Mineral):
    def __init__(self):
        self.params = {'name': 'mpm',
                       'formula': {'Al': 5.0, 'Ca': 4.0, 'H': 7.0, 'Mg': 1.0, 'O': 28.0, 'Si': 6.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -14386910.0,
                       'S_0': 629.0,
                       'V_0': 0.0002955,
                       'Cp': [1720.8, -0.024928, -5998700.0, -14620.3],
                       'a_0': 2.48e-05,
                       'K_0': 161500e6,
                       'Kprime_0': 4.05,
                       'Kdprime_0': -2.5e-11,
                       'n': 51.0,
                       'molar_mass': 0.94307628}
        Mineral.__init__(self)


class fpm (Mineral):
    def __init__(self):
        self.params = {'name': 'fpm',
                       'formula': {'Al': 5.0, 'Ca': 4.0, 'Fe': 1.0, 'H': 7.0, 'O': 28.0, 'Si': 6.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -14034040.0,
                       'S_0': 657.0,
                       'V_0': 0.0002968,
                       'Cp': [1737.2, -0.024582, -5161100.0, -14963.0],
                       'a_0': 2.49e-05,
                       'K_0': 161500e6,
                       'Kprime_0': 4.05,
                       'Kdprime_0': -2.5e-11,
                       'n': 51.0,
                       'molar_mass': 0.97461628}
        Mineral.__init__(self)


class jgd (Mineral):
    def __init__(self):
        self.params = {'name': 'jgd',
                       'formula': {'Ca': 4.0, 'Fe': 6.0, 'H': 7.0, 'O': 28.0, 'Si': 6.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -11808960.0,
                       'S_0': 830.0,
                       'V_0': 0.0003108,
                       'Cp': [1795.4, -0.037986, -4455700.0, -14888.0],
                       'a_0': 2.49e-05,
                       'K_0': 161500e6,
                       'Kprime_0': 4.05,
                       'Kdprime_0': -2.5e-11,
                       'n': 51.0,
                       'molar_mass': 1.11893378}
        Mineral.__init__(self)


class geh (Mineral):
    def __init__(self):
        self.params = {'name': 'geh',
                       'formula': {'Al': 2.0, 'Ca': 2.0, 'O': 7.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -3992240.0,
                       'S_0': 198.5,
                       'V_0': 9.024e-05,
                       'Cp': [405.7, -0.007099, -1188300.0, -3174.4],
                       'a_0': 2.23e-05,
                       'K_0': 108000e6,
                       'Kprime_0': 4.08,
                       'Kdprime_0': -3.8e-11,
                       'n': 12.0,
                       'molar_mass': 0.2742003}
        self.property_modifiers = [['bragg_williams', {'deltaH': 7510.0,
                                                       'deltaV': 9e-07,
                                                       'Wh': 7500.0,
                                                       'Wv': 9e-07,
                                                       'n': 1.0,
                                                       'factor': 0.8}]]
        Mineral.__init__(self)


class ak (Mineral):
    def __init__(self):
        self.params = {'name': 'ak',
                       'formula': {'Ca': 2.0, 'Mg': 1.0, 'O': 7.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -3865620.0,
                       'S_0': 212.5,
                       'V_0': 9.254e-05,
                       'Cp': [385.4, 0.003209, -247500.0, -2889.9],
                       'a_0': 2.57e-05,
                       'K_0': 142000e6,
                       'Kprime_0': 4.06,
                       'Kdprime_0': -2.9e-11,
                       'n': 12.0,
                       'molar_mass': 0.2726278}
        Mineral.__init__(self)


class rnk (Mineral):
    def __init__(self):
        self.params = {'name': 'rnk',
                       'formula': {'Ca': 3.0, 'O': 7.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -3943820.0,
                       'S_0': 210.0,
                       'V_0': 9.651e-05,
                       'Cp': [372.3, -0.002893, -2462400.0, -2181.3],
                       'a_0': 3.28e-05,
                       'K_0': 95000e6,
                       'Kprime_0': 4.09,
                       'Kdprime_0': -4.3e-11,
                       'n': 12.0,
                       'molar_mass': 0.2884008}
        Mineral.__init__(self)


class ty (Mineral):
    def __init__(self):
        self.params = {'name': 'ty',
                       'formula': {'C': 2.0, 'Ca': 5.0, 'O': 13.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -6368040.0,
                       'S_0': 390.0,
                       'V_0': 0.00017039,
                       'Cp': [741.7, -0.005345, -1434600.0, -5878.5],
                       'a_0': 3.42e-05,
                       'K_0': 95000e6,
                       'Kprime_0': 4.09,
                       'Kdprime_0': -4.3e-11,
                       'n': 22.0,
                       'molar_mass': 0.4885746}
        Mineral.__init__(self)


class crd (Mineral):
    def __init__(self):
        self.params = {'name': 'crd',
                       'formula': {'Al': 4.0, 'Mg': 2.0, 'O': 18.0, 'Si': 5.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -9163430.0,
                       'S_0': 404.1,
                       'V_0': 0.00023322,
                       'Cp': [906.1, 0.0, -7902000.0, -6293.4],
                       'a_0': 6.8e-06,
                       'K_0': 129000e6,
                       'Kprime_0': 4.1,
                       'Kdprime_0': -3.1e-11,
                       'n': 29.0,
                       'molar_mass': 0.5849527}
        self.property_modifiers = [['bragg_williams', {'deltaH': 36710.0,
                                                       'deltaV': 1e-06,
                                                       'Wh': 36700.0,
                                                       'Wv': 1e-06,
                                                       'n': 2.0,
                                                       'factor': 1.5}]]
        Mineral.__init__(self)


class hcrd (Mineral):
    def __init__(self):
        self.params = {'name': 'hcrd',
                       'formula': {'Al': 4.0, 'H': 2.0, 'Mg': 2.0, 'O': 19.0, 'Si': 5.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -9448520.0,
                       'S_0': 483.0,
                       'V_0': 0.00023322,
                       'Cp': [955.3, 0.0, -8352600.0, -6301.2],
                       'a_0': 6.7e-06,
                       'K_0': 129000e6,
                       'Kprime_0': 4.1,
                       'Kdprime_0': -3.1e-11,
                       'n': 32.0,
                       'molar_mass': 0.60296798}
        self.property_modifiers = [['bragg_williams', {'deltaH': 36710.0,
                                                       'deltaV': 1e-06,
                                                       'Wh': 36700.0,
                                                       'Wv': 1e-06,
                                                       'n': 2.0,
                                                       'factor': 1.5}]]
        Mineral.__init__(self)


class fcrd (Mineral):
    def __init__(self):
        self.params = {'name': 'fcrd',
                       'formula': {'Al': 4.0, 'Fe': 2.0, 'O': 18.0, 'Si': 5.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -8444070.0,
                       'S_0': 461.0,
                       'V_0': 0.0002371,
                       'Cp': [924.0, 0.0, -7039400.0, -6439.6],
                       'a_0': 6.7e-06,
                       'K_0': 129000e6,
                       'Kprime_0': 4.1,
                       'Kdprime_0': -3.1e-11,
                       'n': 29.0,
                       'molar_mass': 0.6480327}
        self.property_modifiers = [['bragg_williams', {'deltaH': 36710.0,
                                                       'deltaV': 1e-06,
                                                       'Wh': 36700.0,
                                                       'Wv': 1e-06,
                                                       'n': 2.0,
                                                       'factor': 1.5}]]
        Mineral.__init__(self)


class mncrd (Mineral):
    def __init__(self):
        self.params = {'name': 'mncrd',
                       'formula': {'Al': 4.0, 'Mn': 2.0, 'O': 18.0, 'Si': 5.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -8693590.0,
                       'S_0': 473.0,
                       'V_0': 0.00024027,
                       'Cp': [886.5, 0.0, -8840000.0, -5590.4],
                       'a_0': 6.9e-06,
                       'K_0': 129000e6,
                       'Kprime_0': 4.1,
                       'Kdprime_0': -3.1e-11,
                       'n': 29.0,
                       'molar_mass': 0.6462187}
        self.property_modifiers = [['bragg_williams', {'deltaH': 36710.0,
                                                       'deltaV': 1e-06,
                                                       'Wh': 36700.0,
                                                       'Wv': 1e-06,
                                                       'n': 2.0,
                                                       'factor': 1.5}]]
        Mineral.__init__(self)


class phA (Mineral):
    def __init__(self):
        self.params = {'name': 'phA',
                       'formula': {'H': 6.0, 'Mg': 7.0, 'O': 14.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -7129620.0,
                       'S_0': 350.5,
                       'V_0': 0.00015422,
                       'Cp': [962.0, -0.011521, -4517800.0, -7724.7],
                       'a_0': 3.55e-05,
                       'K_0': 145000e6,
                       'Kprime_0': 4.06,
                       'Kdprime_0': -2.8e-11,
                       'n': 29.0,
                       'molar_mass': 0.45634524}
        Mineral.__init__(self)


class sph (Mineral):
    def __init__(self):
        self.params = {'name': 'sph',
                       'formula': {'Ca': 1.0, 'O': 5.0, 'Si': 1.0, 'Ti': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -2601660.0,
                       'S_0': 124.0,
                       'V_0': 5.565e-05,
                       'Cp': [227.9, 0.002924, -3539500.0, -894.3],
                       'a_0': 1.58e-05,
                       'K_0': 101700e6,
                       'Kprime_0': 9.85,
                       'Kdprime_0': -9.7e-11,
                       'n': 8.0,
                       'molar_mass': 0.1960275}
        self.property_modifiers = [['landau_hp', {'P_0': 100000.0,
                                                  'T_0': 298.15,
                                                  'Tc_0': 485.0,
                                                  'S_D': 0.4,
                                                  'V_D': 5e-08}]]
        Mineral.__init__(self)


class cstn (Mineral):
    def __init__(self):
        self.params = {'name': 'cstn',
                       'formula': {'Ca': 1.0, 'O': 5.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -2496350.0,
                       'S_0': 99.5,
                       'V_0': 4.818e-05,
                       'Cp': [205.6, 0.006034, -5517700.0, -352.6],
                       'a_0': 1.58e-05,
                       'K_0': 178200e6,
                       'Kprime_0': 4.0,
                       'Kdprime_0': -2.2e-11,
                       'n': 8.0,
                       'molar_mass': 0.176246}
        Mineral.__init__(self)


class zrc (Mineral):
    def __init__(self):
        self.params = {'name': 'zrc',
                       'formula': {'O': 4.0, 'Si': 1.0, 'Zr': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -2035070.0,
                       'S_0': 83.03,
                       'V_0': 3.926e-05,
                       'Cp': [232.0, -0.014405, 0.0, -2238.2],
                       'a_0': 1.25e-05,
                       'K_0': 230100e6,
                       'Kprime_0': 4.04,
                       'Kdprime_0': -1.8e-11,
                       'n': 6.0,
                       'molar_mass': 0.1833071}
        Mineral.__init__(self)


class en (Mineral):
    def __init__(self):
        self.params = {'name': 'en',
                       'formula': {'Mg': 2.0, 'O': 6.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -3090220.0,
                       'S_0': 132.5,
                       'V_0': 6.262e-05,
                       'Cp': [356.2, -0.00299, -596900.0, -3185.3],
                       'a_0': 2.27e-05,
                       'K_0': 105900e6,
                       'Kprime_0': 8.65,
                       'Kdprime_0': -8.2e-11,
                       'n': 10.0,
                       'molar_mass': 0.2007774}
        Mineral.__init__(self)


class pren (Mineral):
    def __init__(self):
        self.params = {'name': 'pren',
                       'formula': {'Mg': 2.0, 'O': 6.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -3084560.0,
                       'S_0': 137.0,
                       'V_0': 6.476e-05,
                       'Cp': [356.2, -0.00299, -596900.0, -3185.3],
                       'a_0': 2.3e-05,
                       'K_0': 105900e6,
                       'Kprime_0': 8.65,
                       'Kdprime_0': -8.2e-11,
                       'n': 10.0,
                       'molar_mass': 0.2007774}
        Mineral.__init__(self)


class cen (Mineral):
    def __init__(self):
        self.params = {'name': 'cen',
                       'formula': {'Mg': 2.0, 'O': 6.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -3091110.0,
                       'S_0': 132.0,
                       'V_0': 6.264e-05,
                       'Cp': [306.0, -0.003793, -3041700.0, -1852.1],
                       'a_0': 2.11e-05,
                       'K_0': 105900e6,
                       'Kprime_0': 8.65,
                       'Kdprime_0': -8.2e-11,
                       'n': 10.0,
                       'molar_mass': 0.2007774}
        Mineral.__init__(self)


class hen (Mineral):
    def __init__(self):
        self.params = {'name': 'hen',
                       'formula': {'Mg': 2.0, 'O': 6.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -3082730.0,
                       'S_0': 131.7,
                       'V_0': 6.099e-05,
                       'Cp': [356.2, -0.00299, -596900.0, -3185.3],
                       'a_0': 2.26e-05,
                       'K_0': 150000e6,
                       'Kprime_0': 5.5,
                       'Kdprime_0': -3.6e-11,
                       'n': 10.0,
                       'molar_mass': 0.2007774}
        Mineral.__init__(self)


class fs (Mineral):
    def __init__(self):
        self.params = {'name': 'fs',
                       'formula': {'Fe': 2.0, 'O': 6.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -2388710.0,
                       'S_0': 189.9,
                       'V_0': 6.592e-05,
                       'Cp': [398.7, -0.006579, 1290100.0, -4058.0],
                       'a_0': 3.26e-05,
                       'K_0': 101000e6,
                       'Kprime_0': 4.08,
                       'Kdprime_0': -4e-11,
                       'n': 10.0,
                       'molar_mass': 0.2638574}
        Mineral.__init__(self)


class mgts (Mineral):
    def __init__(self):
        self.params = {'name': 'mgts',
                       'formula': {'Al': 2.0, 'Mg': 1.0, 'O': 6.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -3196670.0,
                       'S_0': 131.0,
                       'V_0': 6.05e-05,
                       'Cp': [371.4, -0.004082, -398400.0, -3547.1],
                       'a_0': 2.17e-05,
                       'K_0': 102800e6,
                       'Kprime_0': 8.55,
                       'Kdprime_0': -8.3e-11,
                       'n': 10.0,
                       'molar_mass': 0.2023499}
        Mineral.__init__(self)


class di (Mineral):
    def __init__(self):
        self.params = {'name': 'di',
                       'formula': {'Ca': 1.0, 'Mg': 1.0, 'O': 6.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -3201850.0,
                       'S_0': 142.9,
                       'V_0': 6.619e-05,
                       'Cp': [314.5, 4.1e-05, -2745900.0, -2020.1],
                       'a_0': 2.73e-05,
                       'K_0': 119200e6,
                       'Kprime_0': 5.19,
                       'Kdprime_0': -4.4e-11,
                       'n': 10.0,
                       'molar_mass': 0.2165504}
        Mineral.__init__(self)


class hed (Mineral):
    def __init__(self):
        self.params = {'name': 'hed',
                       'formula': {'Ca': 1.0, 'Fe': 1.0, 'O': 6.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -2842060.0,
                       'S_0': 175.0,
                       'V_0': 6.795e-05,
                       'Cp': [340.2, 0.000812, -1047800.0, -2646.7],
                       'a_0': 2.38e-05,
                       'K_0': 119200e6,
                       'Kprime_0': 3.97,
                       'Kdprime_0': -3.3e-11,
                       'n': 10.0,
                       'molar_mass': 0.2480904}
        Mineral.__init__(self)


class jd (Mineral):
    def __init__(self):
        self.params = {'name': 'jd',
                       'formula': {'Al': 1.0, 'Na': 1.0, 'O': 6.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -3025270.0,
                       'S_0': 133.5,
                       'V_0': 6.04e-05,
                       'Cp': [319.4, 0.003616, -1173900.0, -2469.5],
                       'a_0': 2.1e-05,
                       'K_0': 128100e6,
                       'Kprime_0': 3.81,
                       'Kdprime_0': -3e-11,
                       'n': 10.0,
                       'molar_mass': 0.2021387}
        Mineral.__init__(self)


class acm (Mineral):
    def __init__(self):
        self.params = {'name': 'acm',
                       'formula': {'Fe': 1.0, 'Na': 1.0, 'O': 6.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -2583430.0,
                       'S_0': 170.6,
                       'V_0': 6.459e-05,
                       'Cp': [307.1, 0.016758, -1685500.0, -2125.8],
                       'a_0': 2.11e-05,
                       'K_0': 106000e6,
                       'Kprime_0': 4.08,
                       'Kdprime_0': -3.8e-11,
                       'n': 10.0,
                       'molar_mass': 0.2310022}
        Mineral.__init__(self)


class kos (Mineral):
    def __init__(self):
        self.params = {'name': 'kos',
                       'formula': {'Cr': 1.0, 'Na': 1.0, 'O': 6.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -2746840.0,
                       'S_0': 149.65,
                       'V_0': 6.309e-05,
                       'Cp': [309.2, 0.005419, -664600.0, -2176.6],
                       'a_0': 1.94e-05,
                       'K_0': 130800e6,
                       'Kprime_0': 3.0,
                       'Kdprime_0': -2.3e-11,
                       'n': 10.0,
                       'molar_mass': 0.2271533}
        Mineral.__init__(self)


class cats (Mineral):
    def __init__(self):
        self.params = {'name': 'cats',
                       'formula': {'Al': 2.0, 'Ca': 1.0, 'O': 6.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -3310110.0,
                       'S_0': 135.0,
                       'V_0': 6.356e-05,
                       'Cp': [347.6, -0.006974, -1781600.0, -2757.5],
                       'a_0': 2.08e-05,
                       'K_0': 119200e6,
                       'Kprime_0': 5.19,
                       'Kdprime_0': -4.4e-11,
                       'n': 10.0,
                       'molar_mass': 0.2181229}
        self.property_modifiers = [['bragg_williams', {'deltaH': 3800.0,
                                                       'deltaV': 1e-07,
                                                       'Wh': 3800.0,
                                                       'Wv': 1e-07,
                                                       'n': 1.0,
                                                       'factor': 0.25}]]
        Mineral.__init__(self)


class caes (Mineral):
    def __init__(self):
        self.params = {'name': 'caes',
                       'formula': {'Al': 1.0, 'Ca': 0.5, 'O': 6.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -3002020.0,
                       'S_0': 127.0,
                       'V_0': 6.05e-05,
                       'Cp': [362.0, -0.016944, -175900.0, -3565.7],
                       'a_0': 2.31e-05,
                       'K_0': 119200e6,
                       'Kprime_0': 5.19,
                       'Kdprime_0': -4.4e-11,
                       'n': 9.5,
                       'molar_mass': 0.1991879}
        Mineral.__init__(self)


class rhod (Mineral):
    def __init__(self):
        self.params = {'name': 'rhod',
                       'formula': {'Mn': 1.0, 'O': 3.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1322380.0,
                       'S_0': 100.5,
                       'V_0': 3.494e-05,
                       'Cp': [138.4, 0.004088, -1936000.0, -538.9],
                       'a_0': 2.81e-05,
                       'K_0': 84000e6,
                       'Kprime_0': 4.0,
                       'Kdprime_0': -4.8e-11,
                       'n': 5.0,
                       'molar_mass': 0.1310217}
        Mineral.__init__(self)


class pxmn (Mineral):
    def __init__(self):
        self.params = {'name': 'pxmn',
                       'formula': {'Mn': 1.0, 'O': 3.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1323160.0,
                       'S_0': 99.3,
                       'V_0': 3.472e-05,
                       'Cp': [138.4, 0.004088, -1936000.0, -538.9],
                       'a_0': 2.8e-05,
                       'K_0': 84000e6,
                       'Kprime_0': 4.0,
                       'Kdprime_0': -4.8e-11,
                       'n': 5.0,
                       'molar_mass': 0.1310217}
        Mineral.__init__(self)


class wo (Mineral):
    def __init__(self):
        self.params = {'name': 'wo',
                       'formula': {'Ca': 1.0, 'O': 3.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1633770.0,
                       'S_0': 82.5,
                       'V_0': 3.993e-05,
                       'Cp': [159.3, 0.0, -967300.0, -1075.4],
                       'a_0': 2.54e-05,
                       'K_0': 79500e6,
                       'Kprime_0': 4.1,
                       'Kdprime_0': -5.2e-11,
                       'n': 5.0,
                       'molar_mass': 0.1161617}
        Mineral.__init__(self)


class pswo (Mineral):
    def __init__(self):
        self.params = {'name': 'pswo',
                       'formula': {'Ca': 1.0, 'O': 3.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1627960.0,
                       'S_0': 87.8,
                       'V_0': 4.008e-05,
                       'Cp': [157.8, 0.0, -967300.0, -1075.4],
                       'a_0': 2.85e-05,
                       'K_0': 110000e6,
                       'Kprime_0': 4.08,
                       'Kdprime_0': -3.7e-11,
                       'n': 5.0,
                       'molar_mass': 0.1161617}
        Mineral.__init__(self)


class wal (Mineral):
    def __init__(self):
        self.params = {'name': 'wal',
                       'formula': {'Ca': 1.0, 'O': 3.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1625900.0,
                       'S_0': 83.5,
                       'V_0': 3.7633e-05,
                       'Cp': [159.3, 0.0, -967300.0, -1075.4],
                       'a_0': 2.54e-05,
                       'K_0': 79500e6,
                       'Kprime_0': 4.1,
                       'Kdprime_0': -5.2e-11,
                       'n': 5.0,
                       'molar_mass': 0.1161617}
        Mineral.__init__(self)


class tr (Mineral):
    def __init__(self):
        self.params = {'name': 'tr',
                       'formula': {'Ca': 2.0, 'H': 2.0, 'Mg': 5.0, 'O': 24.0, 'Si': 8.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -12304870.0,
                       'S_0': 553.0,
                       'V_0': 0.0002727,
                       'Cp': [1260.2, 0.00383, -11455000.0, -8237.6],
                       'a_0': 2.61e-05,
                       'K_0': 76200e6,
                       'Kprime_0': 4.1,
                       'Kdprime_0': -5.4e-11,
                       'n': 41.0,
                       'molar_mass': 0.81236648}
        Mineral.__init__(self)


class fact (Mineral):
    def __init__(self):
        self.params = {'name': 'fact',
                       'formula': {'Ca': 2.0, 'Fe': 5.0, 'H': 2.0, 'O': 24.0, 'Si': 8.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -10504120.0,
                       'S_0': 710.0,
                       'V_0': 0.0002842,
                       'Cp': [1290.0, 0.029992, -8447500.0, -8947.0],
                       'a_0': 2.88e-05,
                       'K_0': 76000e6,
                       'Kprime_0': 4.1,
                       'Kdprime_0': -5.4e-11,
                       'n': 41.0,
                       'molar_mass': 0.97006648}
        Mineral.__init__(self)


class ts (Mineral):
    def __init__(self):
        self.params = {'name': 'ts',
                       'formula': {'Al': 4.0, 'Ca': 2.0, 'H': 2.0, 'Mg': 3.0, 'O': 24.0, 'Si': 6.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -12555270.0,
                       'S_0': 533.0,
                       'V_0': 0.000268,
                       'Cp': [1244.8, 0.024348, -11965000.0, -8112.1],
                       'a_0': 2.66e-05,
                       'K_0': 76000e6,
                       'Kprime_0': 4.1,
                       'Kdprime_0': -5.4e-11,
                       'n': 41.0,
                       'molar_mass': 0.81551148}
        Mineral.__init__(self)


class parg (Mineral):
    def __init__(self):
        self.params = {'name': 'parg',
                       'formula': {'Al': 3.0, 'Ca': 2.0, 'H': 2.0, 'Mg': 4.0, 'Na': 1.0, 'O': 24.0, 'Si': 6.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -12664730.0,
                       'S_0': 635.0,
                       'V_0': 0.0002719,
                       'Cp': [1280.2, 0.022997, -12359500.0, -8065.8],
                       'a_0': 2.8e-05,
                       'K_0': 91200e6,
                       'Kprime_0': 4.09,
                       'Kdprime_0': -4.5e-11,
                       'n': 42.0,
                       'molar_mass': 0.83582478}
        Mineral.__init__(self)


class gl (Mineral):
    def __init__(self):
        self.params = {'name': 'gl',
                       'formula': {'Al': 2.0, 'H': 2.0, 'Mg': 3.0, 'Na': 2.0, 'O': 24.0, 'Si': 8.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -11960240.0,
                       'S_0': 530.0,
                       'V_0': 0.0002598,
                       'Cp': [1717.5, -0.12107, 7075000.0, -19272.0],
                       'a_0': 1.49e-05,
                       'K_0': 88300e6,
                       'Kprime_0': 4.09,
                       'Kdprime_0': -4.6e-11,
                       'n': 41.0,
                       'molar_mass': 0.78354308}
        Mineral.__init__(self)


class fgl (Mineral):
    def __init__(self):
        self.params = {'name': 'fgl',
                       'formula': {'Al': 2.0, 'Fe': 3.0, 'H': 2.0, 'Na': 2.0, 'O': 24.0, 'Si': 8.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -10880210.0,
                       'S_0': 624.0,
                       'V_0': 0.0002659,
                       'Cp': [1762.9, -0.118992, 9423700.0, -20207.1],
                       'a_0': 1.83e-05,
                       'K_0': 89000e6,
                       'Kprime_0': 4.09,
                       'Kdprime_0': -4.6e-11,
                       'n': 41.0,
                       'molar_mass': 0.87816308}
        Mineral.__init__(self)


class rieb (Mineral):
    def __init__(self):
        self.params = {'name': 'rieb',
                       'formula': {'Fe': 5.0, 'H': 2.0, 'Na': 2.0, 'O': 24.0, 'Si': 8.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -10024780.0,
                       'S_0': 695.0,
                       'V_0': 0.0002749,
                       'Cp': [1787.3, -0.124882, 9627100.0, -20275.5],
                       'a_0': 1.81e-05,
                       'K_0': 89000e6,
                       'Kprime_0': 4.09,
                       'Kdprime_0': -4.6e-11,
                       'n': 41.0,
                       'molar_mass': 0.93589008}
        Mineral.__init__(self)


class anth (Mineral):
    def __init__(self):
        self.params = {'name': 'anth',
                       'formula': {'H': 2.0, 'Mg': 7.0, 'O': 24.0, 'Si': 8.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -12066840.0,
                       'S_0': 537.0,
                       'V_0': 0.0002654,
                       'Cp': [1277.3, 0.025825, -9704600.0, -9074.7],
                       'a_0': 2.52e-05,
                       'K_0': 70000e6,
                       'Kprime_0': 4.11,
                       'Kdprime_0': -5.9e-11,
                       'n': 41.0,
                       'molar_mass': 0.78082048}
        Mineral.__init__(self)


class fanth (Mineral):
    def __init__(self):
        self.params = {'name': 'fanth',
                       'formula': {'Fe': 7.0, 'H': 2.0, 'O': 24.0, 'Si': 8.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -9624520.0,
                       'S_0': 725.0,
                       'V_0': 0.0002787,
                       'Cp': [1383.1, 0.030669, -4224700.0, -11257.6],
                       'a_0': 2.74e-05,
                       'K_0': 70000e6,
                       'Kprime_0': 4.11,
                       'Kdprime_0': -5.9e-11,
                       'n': 41.0,
                       'molar_mass': 1.00160048}
        Mineral.__init__(self)


class cumm (Mineral):
    def __init__(self):
        self.params = {'name': 'cumm',
                       'formula': {'H': 2.0, 'Mg': 7.0, 'O': 24.0, 'Si': 8.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -12064690.0,
                       'S_0': 538.0,
                       'V_0': 0.0002633,
                       'Cp': [1277.3, 0.025825, -9704600.0, -9074.7],
                       'a_0': 2.52e-05,
                       'K_0': 70000e6,
                       'Kprime_0': 4.11,
                       'Kdprime_0': -5.9e-11,
                       'n': 41.0,
                       'molar_mass': 0.78082048}
        Mineral.__init__(self)


class grun (Mineral):
    def __init__(self):
        self.params = {'name': 'grun',
                       'formula': {'Fe': 7.0, 'H': 2.0, 'O': 24.0, 'Si': 8.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -9607150.0,
                       'S_0': 735.0,
                       'V_0': 0.0002784,
                       'Cp': [1383.1, 0.030669, -4224700.0, -11257.6],
                       'a_0': 2.74e-05,
                       'K_0': 64800e6,
                       'Kprime_0': 4.12,
                       'Kdprime_0': -6.4e-11,
                       'n': 41.0,
                       'molar_mass': 1.00160048}
        Mineral.__init__(self)


class ged (Mineral):
    def __init__(self):
        self.params = {'name': 'ged',
                       'formula': {'Al': 4.0, 'H': 2.0, 'Mg': 5.0, 'O': 24.0, 'Si': 6.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -12329140.0,
                       'S_0': 517.0,
                       'V_0': 0.00025548,
                       'Cp': [1307.7, 0.023642, -9307400.0, -9799.0],
                       'a_0': 2.41e-05,
                       'K_0': 77000e6,
                       'Kprime_0': 4.1,
                       'Kdprime_0': -5.3e-11,
                       'n': 41.0,
                       'molar_mass': 0.78396548}
        Mineral.__init__(self)


class spr4 (Mineral):
    def __init__(self):
        self.params = {'name': 'spr4',
                       'formula': {'Al': 8.0, 'Mg': 4.0, 'O': 20.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -11022020.0,
                       'S_0': 425.5,
                       'V_0': 0.000199,
                       'Cp': [1133.1, -0.007596, -8816600.0, -8180.6],
                       'a_0': 2.05e-05,
                       'K_0': 250000e6,
                       'Kprime_0': 4.04,
                       'Kdprime_0': -1.6e-11,
                       'n': 34.0,
                       'molar_mass': 0.689231}
        Mineral.__init__(self)


class spr5 (Mineral):
    def __init__(self):
        self.params = {'name': 'spr5',
                       'formula': {'Al': 10.0, 'Mg': 3.0, 'O': 20.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -11135570.0,
                       'S_0': 419.5,
                       'V_0': 0.0001975,
                       'Cp': [1103.4, 0.001015, -10957000.0, -7409.2],
                       'a_0': 2.06e-05,
                       'K_0': 250000e6,
                       'Kprime_0': 4.04,
                       'Kdprime_0': -1.6e-11,
                       'n': 34.0,
                       'molar_mass': 0.6908035}
        Mineral.__init__(self)


class fspr (Mineral):
    def __init__(self):
        self.params = {'name': 'fspr',
                       'formula': {'Al': 8.0, 'Fe': 4.0, 'O': 20.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -9659530.0,
                       'S_0': 485.0,
                       'V_0': 0.00019923,
                       'Cp': [1132.9, -0.007348, -10420200.0, -7036.6],
                       'a_0': 1.96e-05,
                       'K_0': 250000e6,
                       'Kprime_0': 4.04,
                       'Kdprime_0': -1.7e-11,
                       'n': 34.0,
                       'molar_mass': 0.815391}
        Mineral.__init__(self)


class mcar (Mineral):
    def __init__(self):
        self.params = {'name': 'mcar',
                       'formula': {'Al': 2.0, 'H': 4.0, 'Mg': 1.0, 'O': 10.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -4771050.0,
                       'S_0': 221.5,
                       'V_0': 0.0001059,
                       'Cp': [683.0, -0.014054, 291000.0, -6976.4],
                       'a_0': 2.43e-05,
                       'K_0': 52500e6,
                       'Kprime_0': 4.14,
                       'Kdprime_0': -7.9e-11,
                       'n': 19.0,
                       'molar_mass': 0.29846476}
        Mineral.__init__(self)


class fcar (Mineral):
    def __init__(self):
        self.params = {'name': 'fcar',
                       'formula': {'Al': 2.0, 'Fe': 1.0, 'H': 4.0, 'O': 10.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -4411440.0,
                       'S_0': 251.1,
                       'V_0': 0.00010695,
                       'Cp': [686.6, -0.012415, 186000.0, -6884.0],
                       'a_0': 2.21e-05,
                       'K_0': 52500e6,
                       'Kprime_0': 4.14,
                       'Kdprime_0': -7.9e-11,
                       'n': 19.0,
                       'molar_mass': 0.33000476}
        Mineral.__init__(self)


class deer (Mineral):
    def __init__(self):
        self.params = {'name': 'deer',
                       'formula': {'Fe': 18.0, 'H': 10.0, 'O': 50.0, 'Si': 12.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -18341400.0,
                       'S_0': 1650.0,
                       'V_0': 0.0005574,
                       'Cp': [3164.4, -0.027883, -5039100.0, -26721.0],
                       'a_0': 2.75e-05,
                       'K_0': 63000e6,
                       'Kprime_0': 4.12,
                       'Kdprime_0': -6.5e-11,
                       'n': 90.0,
                       'molar_mass': 2.1522854}
        Mineral.__init__(self)


class mu (Mineral):
    def __init__(self):
        self.params = {'name': 'mu',
                       'formula': {'Al': 3.0, 'H': 2.0, 'K': 1.0, 'O': 12.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -5976510.0,
                       'S_0': 292.0,
                       'V_0': 0.00014083,
                       'Cp': [756.4, -0.01984, -2170000.0, -6979.2],
                       'a_0': 3.07e-05,
                       'K_0': 49000e6,
                       'Kprime_0': 4.15,
                       'Kdprime_0': -8.5e-11,
                       'n': 21.0,
                       'molar_mass': 0.39830798}
        Mineral.__init__(self)


class cel (Mineral):
    def __init__(self):
        self.params = {'name': 'cel',
                       'formula': {'Al': 1.0, 'H': 2.0, 'K': 1.0, 'Mg': 1.0, 'O': 12.0, 'Si': 4.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -5834840.0,
                       'S_0': 290.0,
                       'V_0': 0.00013957,
                       'Cp': [741.2, -0.018748, -2368800.0, -6616.9],
                       'a_0': 3.07e-05,
                       'K_0': 70000e6,
                       'Kprime_0': 4.11,
                       'Kdprime_0': -5.9e-11,
                       'n': 21.0,
                       'molar_mass': 0.39673548}
        Mineral.__init__(self)


class fcel (Mineral):
    def __init__(self):
        self.params = {'name': 'fcel',
                       'formula': {'Al': 1.0, 'Fe': 1.0, 'H': 2.0, 'K': 1.0, 'O': 12.0, 'Si': 4.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -5468490.0,
                       'S_0': 330.0,
                       'V_0': 0.0001407,
                       'Cp': [756.3, -0.019147, -1586100.0, -6928.7],
                       'a_0': 3.18e-05,
                       'K_0': 70000e6,
                       'Kprime_0': 4.11,
                       'Kdprime_0': -5.9e-11,
                       'n': 21.0,
                       'molar_mass': 0.42827548}
        Mineral.__init__(self)


class pa (Mineral):
    def __init__(self):
        self.params = {'name': 'pa',
                       'formula': {'Al': 3.0, 'H': 2.0, 'Na': 1.0, 'O': 12.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -5942840.0,
                       'S_0': 277.0,
                       'V_0': 0.00013211,
                       'Cp': [803.0, -0.03158, 217000.0, -8151.0],
                       'a_0': 3.7e-05,
                       'K_0': 51500e6,
                       'Kprime_0': 6.51,
                       'Kdprime_0': -1.26e-10,
                       'n': 21.0,
                       'molar_mass': 0.38219948}
        Mineral.__init__(self)


class ma (Mineral):
    def __init__(self):
        self.params = {'name': 'ma',
                       'formula': {'Al': 4.0, 'Ca': 1.0, 'H': 2.0, 'O': 12.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -6242070.0,
                       'S_0': 265.0,
                       'V_0': 0.00012964,
                       'Cp': [744.4, -0.0168, -2074400.0, -6783.2],
                       'a_0': 2.33e-05,
                       'K_0': 100000e6,
                       'Kprime_0': 4.08,
                       'Kdprime_0': -4.1e-11,
                       'n': 21.0,
                       'molar_mass': 0.39818368}
        Mineral.__init__(self)


class phl (Mineral):
    def __init__(self):
        self.params = {'name': 'phl',
                       'formula': {'Al': 1.0, 'H': 2.0, 'K': 1.0, 'Mg': 3.0, 'O': 12.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -6214880.0,
                       'S_0': 326.0,
                       'V_0': 0.00014964,
                       'Cp': [770.3, -0.036939, -2328900.0, -6531.6],
                       'a_0': 3.8e-05,
                       'K_0': 51300e6,
                       'Kprime_0': 7.33,
                       'Kdprime_0': -1.43e-10,
                       'n': 22.0,
                       'molar_mass': 0.41725998}
        Mineral.__init__(self)


class ann (Mineral):
    def __init__(self):
        self.params = {'name': 'ann',
                       'formula': {'Al': 1.0, 'Fe': 3.0, 'H': 2.0, 'K': 1.0, 'O': 12.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -5143720.0,
                       'S_0': 420.0,
                       'V_0': 0.00015432,
                       'Cp': [815.7, -0.034861, 19800.0, -7466.7],
                       'a_0': 3.8e-05,
                       'K_0': 51300e6,
                       'Kprime_0': 7.33,
                       'Kdprime_0': -1.43e-10,
                       'n': 22.0,
                       'molar_mass': 0.51187998}
        Mineral.__init__(self)


class mnbi (Mineral):
    def __init__(self):
        self.params = {'name': 'mnbi',
                       'formula': {'Al': 1.0, 'H': 2.0, 'K': 1.0, 'Mn': 3.0, 'O': 12.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -5477520.0,
                       'S_0': 433.0,
                       'V_0': 0.00015264,
                       'Cp': [809.9, -0.059213, -1514400.0, -6998.7],
                       'a_0': 3.8e-05,
                       'K_0': 53000e6,
                       'Kprime_0': 7.33,
                       'Kdprime_0': -1.43e-10,
                       'n': 22.0,
                       'molar_mass': 0.50915898}
        Mineral.__init__(self)


class east (Mineral):
    def __init__(self):
        self.params = {'name': 'east',
                       'formula': {'Al': 3.0, 'H': 2.0, 'K': 1.0, 'Mg': 2.0, 'O': 12.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -6330380.0,
                       'S_0': 318.0,
                       'V_0': 0.00014738,
                       'Cp': [785.5, -0.038031, -2130300.0, -6893.7],
                       'a_0': 3.8e-05,
                       'K_0': 53000e6,
                       'Kprime_0': 7.33,
                       'Kdprime_0': -1.43e-10,
                       'n': 22.0,
                       'molar_mass': 0.41883248}
        Mineral.__init__(self)


class naph (Mineral):
    def __init__(self):
        self.params = {'name': 'naph',
                       'formula': {'Al': 1.0, 'H': 2.0, 'Mg': 3.0, 'Na': 1.0, 'O': 12.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -6172010.0,
                       'S_0': 318.0,
                       'V_0': 0.0001445,
                       'Cp': [773.5, -0.040229, -2597900.0, -6512.6],
                       'a_0': 3.28e-05,
                       'K_0': 51300e6,
                       'Kprime_0': 7.33,
                       'Kdprime_0': -1.43e-10,
                       'n': 22.0,
                       'molar_mass': 0.40115148}
        Mineral.__init__(self)


class clin (Mineral):
    def __init__(self):
        self.params = {'name': 'clin',
                       'formula': {'Al': 2.0, 'H': 8.0, 'Mg': 5.0, 'O': 18.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -8909160.0,
                       'S_0': 437.0,
                       'V_0': 0.0002114,
                       'Cp': [1170.8, -0.001508, -3825800.0, -10315.0],
                       'a_0': 2.04e-05,
                       'K_0': 87000e6,
                       'Kprime_0': 4.09,
                       'Kdprime_0': -4.7e-11,
                       'n': 36.0,
                       'molar_mass': 0.55579722}
        Mineral.__init__(self)


class ames (Mineral):
    def __init__(self):
        self.params = {'name': 'ames',
                       'formula': {'Al': 4.0, 'H': 8.0, 'Mg': 4.0, 'O': 18.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -9040460.0,
                       'S_0': 412.0,
                       'V_0': 0.0002071,
                       'Cp': [1186.0, -0.002599, -3627200.0, -10677.0],
                       'a_0': 2e-05,
                       'K_0': 87000e6,
                       'Kprime_0': 4.09,
                       'Kdprime_0': -4.7e-11,
                       'n': 36.0,
                       'molar_mass': 0.55736972}
        Mineral.__init__(self)


class afchl (Mineral):
    def __init__(self):
        self.params = {'name': 'afchl',
                       'formula': {'H': 8.0, 'Mg': 6.0, 'O': 18.0, 'Si': 4.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -8727860.0,
                       'S_0': 439.0,
                       'V_0': 0.0002157,
                       'Cp': [1155.0, -0.000417, -4024400.0, -9952.9],
                       'a_0': 2.04e-05,
                       'K_0': 87000e6,
                       'Kprime_0': 4.09,
                       'Kdprime_0': -4.7e-11,
                       'n': 36.0,
                       'molar_mass': 0.55422472}
        Mineral.__init__(self)


class daph (Mineral):
    def __init__(self):
        self.params = {'name': 'daph',
                       'formula': {'Al': 2.0, 'Fe': 5.0, 'H': 8.0, 'O': 18.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -7116910.0,
                       'S_0': 584.0,
                       'V_0': 0.0002162,
                       'Cp': [1192.0, -0.00594, -4826400.0, -9768.3],
                       'a_0': 2.27e-05,
                       'K_0': 87000e6,
                       'Kprime_0': 4.09,
                       'Kdprime_0': -4.7e-11,
                       'n': 36.0,
                       'molar_mass': 0.71349722}
        Mineral.__init__(self)


class mnchl (Mineral):
    def __init__(self):
        self.params = {'name': 'mnchl',
                       'formula': {'Al': 2.0, 'H': 8.0, 'Mn': 5.0, 'O': 18.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -7702320.0,
                       'S_0': 595.0,
                       'V_0': 0.0002259,
                       'Cp': [1136.5, -0.005243, -5548100.0, -8911.5],
                       'a_0': 2.23e-05,
                       'K_0': 87000e6,
                       'Kprime_0': 4.09,
                       'Kdprime_0': -4.7e-11,
                       'n': 36.0,
                       'molar_mass': 0.70896222}
        Mineral.__init__(self)


class sud (Mineral):
    def __init__(self):
        self.params = {'name': 'sud',
                       'formula': {'Al': 4.0, 'H': 8.0, 'Mg': 2.0, 'O': 18.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -8626540.0,
                       'S_0': 395.0,
                       'V_0': 0.000203,
                       'Cp': [1436.1, -0.048749, -2748500.0, -13764.0],
                       'a_0': 1.99e-05,
                       'K_0': 87000e6,
                       'Kprime_0': 4.09,
                       'Kdprime_0': -4.7e-11,
                       'n': 35.0,
                       'molar_mass': 0.53684522}
        Mineral.__init__(self)


class fsud (Mineral):
    def __init__(self):
        self.params = {'name': 'fsud',
                       'formula': {'Al': 4.0, 'Fe': 2.0, 'H': 8.0, 'O': 18.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -7899850.0,
                       'S_0': 456.0,
                       'V_0': 0.000204,
                       'Cp': [1466.3, -0.047365, -1182800.0, -14388.0],
                       'a_0': 2.08e-05,
                       'K_0': 87000e6,
                       'Kprime_0': 4.09,
                       'Kdprime_0': -4.7e-11,
                       'n': 35.0,
                       'molar_mass': 0.59992522}
        Mineral.__init__(self)


class prl (Mineral):
    def __init__(self):
        self.params = {'name': 'prl',
                       'formula': {'Al': 2.0, 'H': 2.0, 'O': 12.0, 'Si': 4.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -5640610.0,
                       'S_0': 239.0,
                       'V_0': 0.00012804,
                       'Cp': [784.5, -0.042948, 1251000.0, -8495.9],
                       'a_0': 4.5e-05,
                       'K_0': 37000e6,
                       'Kprime_0': 10.0,
                       'Kdprime_0': -2.71e-10,
                       'n': 20.0,
                       'molar_mass': 0.36031368}
        Mineral.__init__(self)


class ta (Mineral):
    def __init__(self):
        self.params = {'name': 'ta',
                       'formula': {'H': 2.0, 'Mg': 3.0, 'O': 12.0, 'Si': 4.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -5897170.0,
                       'S_0': 259.0,
                       'V_0': 0.00013665,
                       'Cp': [622.2, 0.0, -6385500.0, -3916.3],
                       'a_0': 1.8e-05,
                       'K_0': 43000e6,
                       'Kprime_0': 6.17,
                       'Kdprime_0': -1.44e-10,
                       'n': 21.0,
                       'molar_mass': 0.37926568}
        Mineral.__init__(self)


class fta (Mineral):
    def __init__(self):
        self.params = {'name': 'fta',
                       'formula': {'Fe': 3.0, 'H': 2.0, 'O': 12.0, 'Si': 4.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -4798540.0,
                       'S_0': 352.0,
                       'V_0': 0.00014225,
                       'Cp': [579.7, 0.039494, -6459300.0, -3088.1],
                       'a_0': 1.8e-05,
                       'K_0': 43000e6,
                       'Kprime_0': 6.17,
                       'Kdprime_0': -1.44e-10,
                       'n': 21.0,
                       'molar_mass': 0.47388568}
        Mineral.__init__(self)


class tats (Mineral):
    def __init__(self):
        self.params = {'name': 'tats',
                       'formula': {'Al': 2.0, 'H': 2.0, 'Mg': 2.0, 'O': 12.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -6001290.0,
                       'S_0': 259.0,
                       'V_0': 0.0001351,
                       'Cp': [549.5, 0.036324, -8606600.0, -2515.3],
                       'a_0': 1.8e-05,
                       'K_0': 43000e6,
                       'Kprime_0': 6.17,
                       'Kdprime_0': -1.44e-10,
                       'n': 21.0,
                       'molar_mass': 0.38083818}
        Mineral.__init__(self)


class tap (Mineral):
    def __init__(self):
        self.params = {'name': 'tap',
                       'formula': {'Al': 2.0, 'H': 2.0, 'O': 12.0, 'Si': 4.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -5649780.0,
                       'S_0': 235.0,
                       'V_0': 0.0001345,
                       'Cp': [784.5, -0.042948, 1251000.0, -8495.9],
                       'a_0': 4.5e-05,
                       'K_0': 37000e6,
                       'Kprime_0': 10.0,
                       'Kdprime_0': -2.71e-10,
                       'n': 20.0,
                       'molar_mass': 0.36031368}
        Mineral.__init__(self)


class minn (Mineral):
    def __init__(self):
        self.params = {'name': 'minn',
                       'formula': {'Fe': 3.0, 'H': 2.0, 'O': 12.0, 'Si': 4.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -4819310.0,
                       'S_0': 355.0,
                       'V_0': 0.00014851,
                       'Cp': [579.7, 0.039494, -6459300.0, -3088.1],
                       'a_0': 1.8e-05,
                       'K_0': 43000e6,
                       'Kprime_0': 6.17,
                       'Kdprime_0': -1.44e-10,
                       'n': 21.0,
                       'molar_mass': 0.47388568}
        Mineral.__init__(self)


class minm (Mineral):
    def __init__(self):
        self.params = {'name': 'minm',
                       'formula': {'H': 2.0, 'Mg': 3.0, 'O': 12.0, 'Si': 4.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -5866000.0,
                       'S_0': 263.9,
                       'V_0': 0.00014291,
                       'Cp': [622.2, 0.0, -6385500.0, -3916.3],
                       'a_0': 1.8e-05,
                       'K_0': 43000e6,
                       'Kprime_0': 6.17,
                       'Kdprime_0': -1.44e-10,
                       'n': 21.0,
                       'molar_mass': 0.37926568}
        Mineral.__init__(self)


class kao (Mineral):
    def __init__(self):
        self.params = {'name': 'kao',
                       'formula': {'Al': 2.0, 'H': 4.0, 'O': 9.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -4122000.0,
                       'S_0': 203.7,
                       'V_0': 9.934e-05,
                       'Cp': [436.7, -0.034295, -4055900.0, -2699.1],
                       'a_0': 2.51e-05,
                       'K_0': 64500e6,
                       'Kprime_0': 4.12,
                       'Kdprime_0': -6.4e-11,
                       'n': 17.0,
                       'molar_mass': 0.25816036}
        Mineral.__init__(self)


class pre (Mineral):
    def __init__(self):
        self.params = {'name': 'pre',
                       'formula': {'Al': 2.0, 'Ca': 2.0, 'H': 2.0, 'O': 12.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -6202170.0,
                       'S_0': 292.8,
                       'V_0': 0.00014026,
                       'Cp': [724.9, -0.013865, -2059000.0, -6323.9],
                       'a_0': 1.58e-05,
                       'K_0': 109300e6,
                       'Kprime_0': 4.01,
                       'Kdprime_0': -3.7e-11,
                       'n': 21.0,
                       'molar_mass': 0.41238418}
        Mineral.__init__(self)


class fpre (Mineral):
    def __init__(self):
        self.params = {'name': 'fpre',
                       'formula': {'Al': 1.0, 'Ca': 2.0, 'Fe': 1.0, 'H': 2.0, 'O': 12.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -5766640.0,
                       'S_0': 320.0,
                       'V_0': 0.000148,
                       'Cp': [737.1, -0.01681, -1957300.0, -6358.1],
                       'a_0': 1.58e-05,
                       'K_0': 109300e6,
                       'Kprime_0': 4.01,
                       'Kdprime_0': -3.7e-11,
                       'n': 21.0,
                       'molar_mass': 0.44124768}
        Mineral.__init__(self)


class chr (Mineral):
    def __init__(self):
        self.params = {'name': 'chr',
                       'formula': {'H': 4.0, 'Mg': 3.0, 'O': 9.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -4361000.0,
                       'S_0': 221.3,
                       'V_0': 0.00010746,
                       'Cp': [624.7, -0.02077, -1721800.0, -5619.4],
                       'a_0': 2.2e-05,
                       'K_0': 62800e6,
                       'Kprime_0': 4.0,
                       'Kdprime_0': -6.4e-11,
                       'n': 18.0,
                       'molar_mass': 0.27711236}
        Mineral.__init__(self)


class liz (Mineral):
    def __init__(self):
        self.params = {'name': 'liz',
                       'formula': {'H': 4.0, 'Mg': 3.0, 'O': 9.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -4369190.0,
                       'S_0': 212.0,
                       'V_0': 0.00010645,
                       'Cp': [614.7, -0.02077, -1721800.0, -5619.4],
                       'a_0': 2.2e-05,
                       'K_0': 71000e6,
                       'Kprime_0': 3.2,
                       'Kdprime_0': -4.5e-11,
                       'n': 18.0,
                       'molar_mass': 0.27711236}
        Mineral.__init__(self)


class glt (Mineral):
    def __init__(self):
        self.params = {'name': 'glt',
                       'formula': {'Fe': 3.0, 'H': 4.0, 'O': 9.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -3297620.0,
                       'S_0': 310.0,
                       'V_0': 0.0001198,
                       'Cp': [576.4, 0.002984, -3757000.0, -4166.2],
                       'a_0': 2.28e-05,
                       'K_0': 63000e6,
                       'Kprime_0': 4.0,
                       'Kdprime_0': -6.3e-11,
                       'n': 18.0,
                       'molar_mass': 0.37173236}
        Mineral.__init__(self)


class fstp (Mineral):
    def __init__(self):
        self.params = {'name': 'fstp',
                       'formula': {'Al': 2.0, 'Fe': 5.0, 'H': 12.5, 'K': 0.5, 'O': 30.5, 'Si': 8.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -12551070.0,
                       'S_0': 930.2,
                       'V_0': 0.00037239,
                       'Cp': [1944.3, -0.012289, -4840200.0, -16635.0],
                       'a_0': 3.68e-05,
                       'K_0': 51300e6,
                       'Kprime_0': 7.33,
                       'Kdprime_0': -1.43e-10,
                       'n': 58.5,
                       'molar_mass': 1.0780021}
        Mineral.__init__(self)


class mstp (Mineral):
    def __init__(self):
        self.params = {'name': 'mstp',
                       'formula': {'Al': 2.0, 'H': 12.5, 'K': 0.5, 'Mg': 5.0, 'O': 30.5, 'Si': 8.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -14288380.0,
                       'S_0': 847.4,
                       'V_0': 0.00036577,
                       'Cp': [1862.2, -0.014018, -8983100.0, -14923.0],
                       'a_0': 3.71e-05,
                       'K_0': 51300e6,
                       'Kprime_0': 7.33,
                       'Kdprime_0': -1.43e-10,
                       'n': 58.5,
                       'molar_mass': 0.9203021}
        Mineral.__init__(self)


class atg (Mineral):
    def __init__(self):
        self.params = {'name': 'atg',
                       'formula': {'H': 62.0, 'Mg': 48.0, 'O': 147.0, 'Si': 34.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -71404690.0,
                       'S_0': 3620.0,
                       'V_0': 0.0017548,
                       'Cp': [9621.0, -0.091183, -35941600.0, -83034.2],
                       'a_0': 2.8e-05,
                       'K_0': 63100e6,
                       'Kprime_0': 5.92,
                       'Kdprime_0': -9.4e-11,
                       'n': 291.0,
                       'molar_mass': 4.53595108}
        Mineral.__init__(self)


class ab (Mineral):
    def __init__(self):
        self.params = {'name': 'ab',
                       'formula': {'Al': 1.0, 'Na': 1.0, 'O': 8.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -3935480.0,
                       'S_0': 207.4,
                       'V_0': 0.00010067,
                       'Cp': [452.0, -0.013364, -1275900.0, -3953.6],
                       'a_0': 2.36e-05,
                       'K_0': 54100e6,
                       'Kprime_0': 5.91,
                       'Kdprime_0': -1.09e-10,
                       'n': 13.0,
                       'molar_mass': 0.262223}
        self.property_modifiers = [['bragg_williams', {'deltaH': 14000.0,
                                                       'deltaV': 4.2e-07,
                                                       'Wh': 13000.0,
                                                       'Wv': 4.2e-07,
                                                       'n': 3.0,
                                                       'factor': 0.9}]]
        Mineral.__init__(self)


class abh (Mineral):
    def __init__(self):
        self.params = {'name': 'abh',
                       'formula': {'Al': 1.0, 'Na': 1.0, 'O': 8.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -3921480.0,
                       'S_0': 224.3,
                       'V_0': 0.00010105,
                       'Cp': [452.0, -0.013364, -1275900.0, -3953.6],
                       'a_0': 2.41e-05,
                       'K_0': 54100e6,
                       'Kprime_0': 5.91,
                       'Kdprime_0': -1.09e-10,
                       'n': 13.0,
                       'molar_mass': 0.262223}
        Mineral.__init__(self)


class mic (Mineral):
    def __init__(self):
        self.params = {'name': 'mic',
                       'formula': {'Al': 1.0, 'K': 1.0, 'O': 8.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -3975350.0,
                       'S_0': 214.3,
                       'V_0': 0.00010871,
                       'Cp': [448.8, -0.010075, -1007300.0, -3973.1],
                       'a_0': 1.66e-05,
                       'K_0': 58300e6,
                       'Kprime_0': 4.02,
                       'Kdprime_0': -6.9e-11,
                       'n': 13.0,
                       'molar_mass': 0.2783315}
        Mineral.__init__(self)


class san (Mineral):
    def __init__(self):
        self.params = {'name': 'san',
                       'formula': {'Al': 1.0, 'K': 1.0, 'O': 8.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -3966700.0,
                       'S_0': 214.3,
                       'V_0': 0.00010871,
                       'Cp': [448.8, -0.010075, -1007300.0, -3973.1],
                       'a_0': 1.66e-05,
                       'K_0': 58300e6,
                       'Kprime_0': 4.02,
                       'Kdprime_0': -6.9e-11,
                       'n': 13.0,
                       'molar_mass': 0.2783315}
        self.property_modifiers = [['bragg_williams', {'deltaH': 8650.0,
                                                       'deltaV': 2.4e-07,
                                                       'Wh': 8500.0,
                                                       'Wv': 2.4e-07,
                                                       'n': 3.0,
                                                       'factor': 0.8}]]
        Mineral.__init__(self)


class an (Mineral):
    def __init__(self):
        self.params = {'name': 'an',
                       'formula': {'Al': 2.0, 'Ca': 1.0, 'O': 8.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -4232690.0,
                       'S_0': 200.5,
                       'V_0': 0.00010079,
                       'Cp': [370.5, 0.01001, -4339100.0, -1960.6],
                       'a_0': 1.41e-05,
                       'K_0': 86000e6,
                       'Kprime_0': 4.09,
                       'Kdprime_0': -4.8e-11,
                       'n': 13.0,
                       'molar_mass': 0.2782072}
        self.property_modifiers = [['bragg_williams', {'deltaH': 42010.0,
                                                       'deltaV': 1e-06,
                                                       'Wh': 42000.0,
                                                       'Wv': 1e-06,
                                                       'n': 1.0,
                                                       'factor': 2.0}]]
        Mineral.__init__(self)


class kcm (Mineral):
    def __init__(self):
        self.params = {'name': 'kcm',
                       'formula': {'Al': 1.0, 'H': 2.0, 'K': 1.0, 'O': 9.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -4232640.0,
                       'S_0': 281.5,
                       'V_0': 0.00011438,
                       'Cp': [536.5, -0.01009, -980400.0, -4735.0],
                       'a_0': 3.21e-05,
                       'K_0': 42500e6,
                       'Kprime_0': 2.0,
                       'Kdprime_0': -4.7e-11,
                       'n': 16.0,
                       'molar_mass': 0.29634678}
        Mineral.__init__(self)


class wa (Mineral):
    def __init__(self):
        self.params = {'name': 'wa',
                       'formula': {'K': 2.0, 'O': 9.0, 'Si': 4.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -4271890.0,
                       'S_0': 254.0,
                       'V_0': 0.00010844,
                       'Cp': [499.1, 0.0, 0.0, -4350.1],
                       'a_0': 2.66e-05,
                       'K_0': 90000e6,
                       'Kprime_0': 4.0,
                       'Kdprime_0': -4.4e-11,
                       'n': 15.0,
                       'molar_mass': 0.3345332}
        Mineral.__init__(self)


class hol (Mineral):
    def __init__(self):
        self.params = {'name': 'hol',
                       'formula': {'Al': 1.0, 'K': 1.0, 'O': 8.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -3791960.0,
                       'S_0': 166.2,
                       'V_0': 7.128e-05,
                       'Cp': [417.6, -0.003617, -4748100.0, -2819.9],
                       'a_0': 2.8e-05,
                       'K_0': 180000e6,
                       'Kprime_0': 4.0,
                       'Kdprime_0': -2.2e-11,
                       'n': 13.0,
                       'molar_mass': 0.2783315}
        Mineral.__init__(self)


class q (Mineral):
    def __init__(self):
        self.params = {'name': 'q',
                       'formula': {'O': 2.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -910720.0,
                       'S_0': 41.43,
                       'V_0': 2.269e-05,
                       'Cp': [92.9, -0.000642, -714900.0, -716.1],
                       'a_0': 0.0,
                       'K_0': 73000e6,
                       'Kprime_0': 6.0,
                       'Kdprime_0': -8.2e-11,
                       'n': 3.0,
                       'molar_mass': 0.0600843}
        self.property_modifiers = [['landau_hp', {'P_0': 100000.0,
                                                  'T_0': 298.15,
                                                  'Tc_0': 847.0,
                                                  'S_D': 4.95,
                                                  'V_D': 1.188e-06}]]
        Mineral.__init__(self)


class trd (Mineral):
    def __init__(self):
        self.params = {'name': 'trd',
                       'formula': {'O': 2.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -907110.0,
                       'S_0': 44.1,
                       'V_0': 2.8e-05,
                       'Cp': [74.9, 0.0031, -1174000.0, -236.7],
                       'a_0': 0.0,
                       'K_0': 15000e6,
                       'Kprime_0': 4.36,
                       'Kdprime_0': -2.91e-10,
                       'n': 3.0,
                       'molar_mass': 0.0600843}
        Mineral.__init__(self)


class crst (Mineral):
    def __init__(self):
        self.params = {'name': 'crst',
                       'formula': {'O': 2.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -904270.0,
                       'S_0': 50.86,
                       'V_0': 2.745e-05,
                       'Cp': [72.7, 0.001304, -4129000.0, 0.0],
                       'a_0': 0.0,
                       'K_0': 16000e6,
                       'Kprime_0': 4.35,
                       'Kdprime_0': -2.72e-10,
                       'n': 3.0,
                       'molar_mass': 0.0600843}
        Mineral.__init__(self)


class coe (Mineral):
    def __init__(self):
        self.params = {'name': 'coe',
                       'formula': {'O': 2.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -907000.0,
                       'S_0': 39.6,
                       'V_0': 2.064e-05,
                       'Cp': [107.8, -0.003279, -190300.0, -1041.6],
                       'a_0': 1.23e-05,
                       'K_0': 97900e6,
                       'Kprime_0': 4.19,
                       'Kdprime_0': -4.3e-11,
                       'n': 3.0,
                       'molar_mass': 0.0600843}
        Mineral.__init__(self)


class stv (Mineral):
    def __init__(self):
        self.params = {'name': 'stv',
                       'formula': {'O': 2.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -876390.0,
                       'S_0': 24.0,
                       'V_0': 1.401e-05,
                       'Cp': [68.1, 0.00601, -1978200.0, -82.1],
                       'a_0': 1.58e-05,
                       'K_0': 309000e6,
                       'Kprime_0': 4.6,
                       'Kdprime_0': -1.5e-11,
                       'n': 3.0,
                       'molar_mass': 0.0600843}
        Mineral.__init__(self)


class ne (Mineral):
    def __init__(self):
        self.params = {'name': 'ne',
                       'formula': {'Al': 1.0, 'Na': 1.0, 'O': 4.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -2094560.0,
                       'S_0': 124.4,
                       'V_0': 5.419e-05,
                       'Cp': [272.7, -0.012398, 0.0, -2763.1],
                       'a_0': 4.63e-05,
                       'K_0': 46500e6,
                       'Kprime_0': 4.16,
                       'Kdprime_0': -8.9e-11,
                       'n': 7.0,
                       'molar_mass': 0.1420544}
        self.property_modifiers = [['landau_hp', {'P_0': 100000.0,
                                                  'T_0': 298.15,
                                                  'Tc_0': 467.0,
                                                  'S_D': 10.0,
                                                  'V_D': 8e-07}]]
        Mineral.__init__(self)


class cg (Mineral):
    def __init__(self):
        self.params = {'name': 'cg',
                       'formula': {'Al': 1.0, 'Na': 1.0, 'O': 4.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -2091719.9999999998,
                       'S_0': 118.7,
                       'V_0': 5.603e-05,
                       'Cp': [116.1, 0.086021, -1992700.0, 0.0],
                       'a_0': 4.5e-05,
                       'K_0': 46500e6,
                       'Kprime_0': 4.16,
                       'Kdprime_0': -8.9e-11,
                       'n': 7.0,
                       'molar_mass': 0.1420544}
        Mineral.__init__(self)


class cgh (Mineral):
    def __init__(self):
        self.params = {'name': 'cgh',
                       'formula': {'Al': 1.0, 'Na': 1.0, 'O': 4.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -2078010.0000000002,
                       'S_0': 135.0,
                       'V_0': 5.67e-05,
                       'Cp': [229.2, 0.011876, 0.0, -1970.7],
                       'a_0': 4.67e-05,
                       'K_0': 46500e6,
                       'Kprime_0': 4.16,
                       'Kdprime_0': -8.9e-11,
                       'n': 7.0,
                       'molar_mass': 0.1420544}
        Mineral.__init__(self)


class sdl (Mineral):
    def __init__(self):
        self.params = {'name': 'sdl',
                       'formula': {'Al': 6.0, 'Cl': 2.0, 'Na': 8.0, 'O': 24.0, 'Si': 6.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -13405530.0,
                       'S_0': 910.0,
                       'V_0': 0.0004213,
                       'Cp': [1532.7, 0.047747, -2972800.0, -12427.0],
                       'a_0': 4.63e-05,
                       'K_0': 46500e6,
                       'Kprime_0': 4.16,
                       'Kdprime_0': -8.9e-11,
                       'n': 46.0,
                       'molar_mass': 0.969212}
        Mineral.__init__(self)


class kls (Mineral):
    def __init__(self):
        self.params = {'name': 'kls',
                       'formula': {'Al': 1.0, 'K': 1.0, 'O': 4.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -2122960.0,
                       'S_0': 136.0,
                       'V_0': 6.052e-05,
                       'Cp': [242.0, -0.004482, -895800.0, -1935.8],
                       'a_0': 3.16e-05,
                       'K_0': 51400e6,
                       'Kprime_0': 2.0,
                       'Kdprime_0': -3.9e-11,
                       'n': 7.0,
                       'molar_mass': 0.1581629}
        Mineral.__init__(self)


class lc (Mineral):
    def __init__(self):
        self.params = {'name': 'lc',
                       'formula': {'Al': 1.0, 'K': 1.0, 'O': 6.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -3029270.0,
                       'S_0': 198.5,
                       'V_0': 8.826e-05,
                       'Cp': [369.8, -0.016332, 684700.0, -3683.1],
                       'a_0': 1.85e-05,
                       'K_0': 45000e6,
                       'Kprime_0': 5.7,
                       'Kdprime_0': -1.27e-10,
                       'n': 10.0,
                       'molar_mass': 0.2182472}
        self.property_modifiers = [['bragg_williams', {'deltaH': 11610.0,
                                                       'deltaV': 4e-06,
                                                       'Wh': 11600.0,
                                                       'Wv': 4e-06,
                                                       'n': 2.0,
                                                       'factor': 0.7}]]
        Mineral.__init__(self)


class me (Mineral):
    def __init__(self):
        self.params = {'name': 'me',
                       'formula': {'Al': 6.0, 'C': 1.0, 'Ca': 4.0, 'O': 27.0, 'Si': 6.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -13841820.0,
                       'S_0': 752.0,
                       'V_0': 0.00033985,
                       'Cp': [1359.0, 0.036442, -8594700.0, -9598.2],
                       'a_0': 1.81e-05,
                       'K_0': 87000e6,
                       'Kprime_0': 4.09,
                       'Kdprime_0': -4.7e-11,
                       'n': 44.0,
                       'molar_mass': 0.9347085}
        Mineral.__init__(self)


class wrk (Mineral):
    def __init__(self):
        self.params = {'name': 'wrk',
                       'formula': {'Al': 2.0, 'Ca': 1.0, 'H': 4.0, 'O': 14.0, 'Si': 4.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -6662450.0,
                       'S_0': 380.0,
                       'V_0': 0.0001904,
                       'Cp': [838.3, -0.02146, -2272000.0, -7292.3],
                       'a_0': 1.49e-05,
                       'K_0': 86000e6,
                       'Kprime_0': 4.09,
                       'Kdprime_0': -4.8e-11,
                       'n': 25.0,
                       'molar_mass': 0.43440636}
        Mineral.__init__(self)


class lmt (Mineral):
    def __init__(self):
        self.params = {'name': 'lmt',
                       'formula': {'Al': 2.0, 'Ca': 1.0, 'H': 8.0, 'O': 16.0, 'Si': 4.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -7262700.0,
                       'S_0': 465.0,
                       'V_0': 0.0002037,
                       'Cp': [1013.4, -0.021413, -2235800.0, -8806.7],
                       'a_0': 1.37e-05,
                       'K_0': 86000e6,
                       'Kprime_0': 4.09,
                       'Kdprime_0': -4.8e-11,
                       'n': 31.0,
                       'molar_mass': 0.47043692}
        Mineral.__init__(self)


class heu (Mineral):
    def __init__(self):
        self.params = {'name': 'heu',
                       'formula': {'Al': 2.0, 'Ca': 1.0, 'H': 12.0, 'O': 24.0, 'Si': 7.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -10545220.0,
                       'S_0': 783.0,
                       'V_0': 0.000317,
                       'Cp': [1504.8, -0.033224, -2959300.0, -13297.2],
                       'a_0': 1.57e-05,
                       'K_0': 27400e6,
                       'Kprime_0': 4.0,
                       'Kdprime_0': -1.46e-10,
                       'n': 46.0,
                       'molar_mass': 0.68672038}
        Mineral.__init__(self)


class stlb (Mineral):
    def __init__(self):
        self.params = {'name': 'stlb',
                       'formula': {'Al': 2.0, 'Ca': 1.0, 'H': 14.0, 'O': 25.0, 'Si': 7.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -10896760.0,
                       'S_0': 710.0,
                       'V_0': 0.0003287,
                       'Cp': [1588.4, -0.032043, -3071600.0, -13966.9],
                       'a_0': 1.51e-05,
                       'K_0': 86000e6,
                       'Kprime_0': 4.09,
                       'Kdprime_0': -4.8e-11,
                       'n': 49.0,
                       'molar_mass': 0.70473566}
        Mineral.__init__(self)


class anl (Mineral):
    def __init__(self):
        self.params = {'name': 'anl',
                       'formula': {'Al': 1.0, 'H': 2.0, 'Na': 1.0, 'O': 7.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -3307220.0,
                       'S_0': 232.0,
                       'V_0': 9.74e-05,
                       'Cp': [643.5, -0.016067, 9302300.0, -9179.6],
                       'a_0': 2.76e-05,
                       'K_0': 40000e6,
                       'Kprime_0': 4.18,
                       'Kdprime_0': -1.04e-10,
                       'n': 13.0,
                       'molar_mass': 0.22015398}
        Mineral.__init__(self)


class lime (Mineral):
    def __init__(self):
        self.params = {'name': 'lime',
                       'formula': {'Ca': 1.0, 'O': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -634530.0,
                       'S_0': 38.1,
                       'V_0': 1.676e-05,
                       'Cp': [52.4, 0.003673, -750700.0, -51.0],
                       'a_0': 3.41e-05,
                       'K_0': 113000e6,
                       'Kprime_0': 3.87,
                       'Kdprime_0': -3.4e-11,
                       'n': 2.0,
                       'molar_mass': 0.0560774}
        Mineral.__init__(self)


class ru (Mineral):
    def __init__(self):
        self.params = {'name': 'ru',
                       'formula': {'O': 2.0, 'Ti': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -944360.0,
                       'S_0': 50.5,
                       'V_0': 1.882e-05,
                       'Cp': [90.4, 0.0029, 0.0, -623.8],
                       'a_0': 2.24e-05,
                       'K_0': 222000e6,
                       'Kprime_0': 4.24,
                       'Kdprime_0': -1.9e-11,
                       'n': 3.0,
                       'molar_mass': 0.0798658}
        Mineral.__init__(self)


class per (Mineral):
    def __init__(self):
        self.params = {'name': 'per',
                       'formula': {'Mg': 1.0, 'O': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -601530.0,
                       'S_0': 26.5,
                       'V_0': 1.125e-05,
                       'Cp': [60.5, 0.000362, -535800.0, -299.2],
                       'a_0': 3.11e-05,
                       'K_0': 161600e6,
                       'Kprime_0': 3.95,
                       'Kdprime_0': -2.4e-11,
                       'n': 2.0,
                       'molar_mass': 0.0403044}
        Mineral.__init__(self)


class fper (Mineral):
    def __init__(self):
        self.params = {'name': 'fper',
                       'formula': {'Fe': 1.0, 'O': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -259870.0,
                       'S_0': 58.6,
                       'V_0': 1.206e-05,
                       'Cp': [44.4, 0.00828, -1214200.0, 185.2],
                       'a_0': 3.22e-05,
                       'K_0': 152000e6,
                       'Kprime_0': 4.9,
                       'Kdprime_0': -3.2e-11,
                       'n': 2.0,
                       'molar_mass': 0.0718444}
        Mineral.__init__(self)


class mang (Mineral):
    def __init__(self):
        self.params = {'name': 'mang',
                       'formula': {'Mn': 1.0, 'O': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -385550.0,
                       'S_0': 59.7,
                       'V_0': 1.322e-05,
                       'Cp': [59.8, 0.0036, -31400.0, -282.6],
                       'a_0': 3.69e-05,
                       'K_0': 164500e6,
                       'Kprime_0': 4.46,
                       'Kdprime_0': -2.7e-11,
                       'n': 2.0,
                       'molar_mass': 0.0709374}
        Mineral.__init__(self)


class cor (Mineral):
    def __init__(self):
        self.params = {'name': 'cor',
                       'formula': {'Al': 2.0, 'O': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1675270.0,
                       'S_0': 50.9,
                       'V_0': 2.558e-05,
                       'Cp': [139.5, 0.00589, -2460600.0, -589.2],
                       'a_0': 1.8e-05,
                       'K_0': 254000e6,
                       'Kprime_0': 4.34,
                       'Kdprime_0': -1.7e-11,
                       'n': 5.0,
                       'molar_mass': 0.1019612}
        Mineral.__init__(self)


class mcor (Mineral):
    def __init__(self):
        self.params = {'name': 'mcor',
                       'formula': {'Mg': 1.0, 'O': 3.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1474440.0,
                       'S_0': 59.3,
                       'V_0': 2.635e-05,
                       'Cp': [147.8, 0.002015, -2395000.0, -801.8],
                       'a_0': 2.12e-05,
                       'K_0': 211000e6,
                       'Kprime_0': 4.55,
                       'Kdprime_0': -2.2e-11,
                       'n': 5.0,
                       'molar_mass': 0.1003887}
        Mineral.__init__(self)


class hem (Mineral):
    def __init__(self):
        self.params = {'name': 'hem',
                       'formula': {'Fe': 2.0, 'O': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -825610.0,
                       'S_0': 87.4,
                       'V_0': 3.027e-05,
                       'Cp': [163.9, 0.0, -2257200.0, -657.6],
                       'a_0': 2.79e-05,
                       'K_0': 223000e6,
                       'Kprime_0': 4.04,
                       'Kdprime_0': -1.8e-11,
                       'n': 5.0,
                       'molar_mass': 0.1596882}
        self.property_modifiers = [['landau_hp', {'P_0': 100000.0,
                                                  'T_0': 298.15,
                                                  'Tc_0': 955.0,
                                                  'S_D': 15.6,
                                                  'V_D': 0.0}]]
        Mineral.__init__(self)


class esk (Mineral):
    def __init__(self):
        self.params = {'name': 'esk',
                       'formula': {'Cr': 2.0, 'O': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1137320.0,
                       'S_0': 83.0,
                       'V_0': 2.909e-05,
                       'Cp': [119.0, 0.009496, -1442000.0, -3.4],
                       'a_0': 1.59e-05,
                       'K_0': 238000e6,
                       'Kprime_0': 4.0,
                       'Kdprime_0': -1.7e-11,
                       'n': 5.0,
                       'molar_mass': 0.1519904}
        Mineral.__init__(self)


class bix (Mineral):
    def __init__(self):
        self.params = {'name': 'bix',
                       'formula': {'Mn': 2.0, 'O': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -959000.0,
                       'S_0': 113.7,
                       'V_0': 3.137e-05,
                       'Cp': [145.1, 0.023534, 721600.0, -1008.4],
                       'a_0': 2.91e-05,
                       'K_0': 223000e6,
                       'Kprime_0': 4.04,
                       'Kdprime_0': -1.8e-11,
                       'n': 5.0,
                       'molar_mass': 0.1578742}
        Mineral.__init__(self)


class NiO (Mineral):
    def __init__(self):
        self.params = {'name': 'NiO',
                       'formula': {'Ni': 1.0, 'O': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -239470.0,
                       'S_0': 38.0,
                       'V_0': 1.097e-05,
                       'Cp': [47.7, 0.007824, -392500.0, 0.0],
                       'a_0': 3.3e-05,
                       'K_0': 200000e6,
                       'Kprime_0': 3.94,
                       'Kdprime_0': -2e-11,
                       'n': 2.0,
                       'molar_mass': 0.0746928}
        self.property_modifiers = [['landau_hp', {'P_0': 100000.0,
                                                  'T_0': 298.15,
                                                  'Tc_0': 520.0,
                                                  'S_D': 5.7,
                                                  'V_D': 0.0}]]
        Mineral.__init__(self)


class pnt (Mineral):
    def __init__(self):
        self.params = {'name': 'pnt',
                       'formula': {'Mn': 1.0, 'O': 3.0, 'Ti': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1361950.0,
                       'S_0': 105.5,
                       'V_0': 3.288e-05,
                       'Cp': [143.5, 0.003373, -1940700.0, -407.6],
                       'a_0': 2.4e-05,
                       'K_0': 170000e6,
                       'Kprime_0': 8.3,
                       'Kdprime_0': -4.9e-11,
                       'n': 5.0,
                       'molar_mass': 0.1508032}
        Mineral.__init__(self)


class geik (Mineral):
    def __init__(self):
        self.params = {'name': 'geik',
                       'formula': {'Mg': 1.0, 'O': 3.0, 'Ti': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1568960.0,
                       'S_0': 73.6,
                       'V_0': 3.086e-05,
                       'Cp': [151.0, 0.0, -1890400.0, -652.2],
                       'a_0': 2.15e-05,
                       'K_0': 170000e6,
                       'Kprime_0': 8.3,
                       'Kdprime_0': -4.9e-11,
                       'n': 5.0,
                       'molar_mass': 0.1201702}
        Mineral.__init__(self)


class ilm (Mineral):
    def __init__(self):
        self.params = {'name': 'ilm',
                       'formula': {'Fe': 1.0, 'O': 3.0, 'Ti': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1230450.0,
                       'S_0': 109.5,
                       'V_0': 3.169e-05,
                       'Cp': [138.9, 0.005081, -1288800.0, -463.7],
                       'a_0': 2.4e-05,
                       'K_0': 170000e6,
                       'Kprime_0': 8.3,
                       'Kdprime_0': -4.9e-11,
                       'n': 5.0,
                       'molar_mass': 0.1517102}
        self.property_modifiers = [['landau_hp', {'P_0': 100000.0,
                                                  'T_0': 298.15,
                                                  'Tc_0': 1900.0,
                                                  'S_D': 12.0,
                                                  'V_D': 2e-07}]]
        Mineral.__init__(self)


class bdy (Mineral):
    def __init__(self):
        self.params = {'name': 'bdy',
                       'formula': {'O': 2.0, 'Zr': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1100340.0,
                       'S_0': 50.4,
                       'V_0': 2.115e-05,
                       'Cp': [103.5, -0.004547, -416200.0, -713.6],
                       'a_0': 2e-05,
                       'K_0': 95300e6,
                       'Kprime_0': 3.88,
                       'Kdprime_0': -4.1e-11,
                       'n': 3.0,
                       'molar_mass': 0.1232228}
        Mineral.__init__(self)


class ten (Mineral):
    def __init__(self):
        self.params = {'name': 'ten',
                       'formula': {'Cu': 1.0, 'O': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -156100.0,
                       'S_0': 42.6,
                       'V_0': 1.222e-05,
                       'Cp': [31.0, 0.01374, -1258000.0, 369.3],
                       'a_0': 3.57e-05,
                       'K_0': 200000e6,
                       'Kprime_0': 3.94,
                       'Kdprime_0': -2e-11,
                       'n': 2.0,
                       'molar_mass': 0.0795454}
        Mineral.__init__(self)


class cup (Mineral):
    def __init__(self):
        self.params = {'name': 'cup',
                       'formula': {'Cu': 2.0, 'O': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -170600.0,
                       'S_0': 92.4,
                       'V_0': 2.344e-05,
                       'Cp': [110.3, 0.0, 0.0, -674.8],
                       'a_0': 3.33e-05,
                       'K_0': 131000e6,
                       'Kprime_0': 5.7,
                       'Kdprime_0': -4.3e-11,
                       'n': 3.0,
                       'molar_mass': 0.1430914}
        Mineral.__init__(self)


class sp (Mineral):
    def __init__(self):
        self.params = {'name': 'sp',
                       'formula': {'Al': 2.0, 'Mg': 1.0, 'O': 4.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -2301190.0,
                       'S_0': 82.0,
                       'V_0': 3.978e-05,
                       'Cp': [222.9, 0.006127, -1686000.0, -1551.0],
                       'a_0': 1.93e-05,
                       'K_0': 192200e6,
                       'Kprime_0': 4.04,
                       'Kdprime_0': -2.1e-11,
                       'n': 7.0,
                       'molar_mass': 0.1422656}
        self.property_modifiers = [['bragg_williams', {'deltaH': 8000.0,
                                                       'deltaV': 0.0,
                                                       'Wh': 1200.0,
                                                       'Wv': 0.0,
                                                       'n': 2.0,
                                                       'factor': 0.5}]]
        Mineral.__init__(self)


class herc (Mineral):
    def __init__(self):
        self.params = {'name': 'herc',
                       'formula': {'Al': 2.0, 'Fe': 1.0, 'O': 4.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1953030.0,
                       'S_0': 113.9,
                       'V_0': 4.075e-05,
                       'Cp': [216.7, 0.005868, -2430200.0, -1178.3],
                       'a_0': 2.06e-05,
                       'K_0': 192200e6,
                       'Kprime_0': 4.04,
                       'Kdprime_0': -2.1e-11,
                       'n': 7.0,
                       'molar_mass': 0.1738056}
        self.property_modifiers = [['bragg_williams', {'deltaH': 18300.0,
                                                       'deltaV': 0.0,
                                                       'Wh': 13600.0,
                                                       'Wv': 0.0,
                                                       'n': 2.0,
                                                       'factor': 1.0}]]
        Mineral.__init__(self)


class mt (Mineral):
    def __init__(self):
        self.params = {'name': 'mt',
                       'formula': {'Fe': 3.0, 'O': 4.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1114500.0,
                       'S_0': 146.9,
                       'V_0': 4.452e-05,
                       'Cp': [262.5, -0.007205, -1926200.0, -1655.7],
                       'a_0': 3.71e-05,
                       'K_0': 185700e6,
                       'Kprime_0': 4.05,
                       'Kdprime_0': -2.2e-11,
                       'n': 7.0,
                       'molar_mass': 0.2315326}
        self.property_modifiers = [['landau_hp', {'P_0': 100000.0,
                                                  'T_0': 298.15,
                                                  'Tc_0': 848.0,
                                                  'S_D': 35.0,
                                                  'V_D': 0.0}]]
        Mineral.__init__(self)


class mft (Mineral):
    def __init__(self):
        self.params = {'name': 'mft',
                       'formula': {'Fe': 2.0, 'Mg': 1.0, 'O': 4.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1442290.0,
                       'S_0': 121.0,
                       'V_0': 4.457e-05,
                       'Cp': [270.5, -0.007505, -999200.0, -2022.4],
                       'a_0': 3.63e-05,
                       'K_0': 185700e6,
                       'Kprime_0': 4.05,
                       'Kdprime_0': -2.2e-11,
                       'n': 7.0,
                       'molar_mass': 0.1999926}
        self.property_modifiers = [['landau_hp', {'P_0': 100000.0,
                                                  'T_0': 298.15,
                                                  'Tc_0': 665.0,
                                                  'S_D': 17.0,
                                                  'V_D': 0.0}]]
        Mineral.__init__(self)


class usp (Mineral):
    def __init__(self):
        self.params = {'name': 'usp',
                       'formula': {'Fe': 2.0, 'O': 4.0, 'Ti': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1491120.0,
                       'S_0': 180.0,
                       'V_0': 4.682e-05,
                       'Cp': [-102.6, 0.14252, -9144500.0, 5270.7],
                       'a_0': 3.86e-05,
                       'K_0': 185700e6,
                       'Kprime_0': 4.05,
                       'Kdprime_0': -2.2e-11,
                       'n': 7.0,
                       'molar_mass': 0.2235546}
        Mineral.__init__(self)


class picr (Mineral):
    def __init__(self):
        self.params = {'name': 'picr',
                       'formula': {'Cr': 2.0, 'Mg': 1.0, 'O': 4.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1762600.0,
                       'S_0': 118.3,
                       'V_0': 4.356e-05,
                       'Cp': [196.1, 0.005398, -3126000.0, -616.9],
                       'a_0': 1.8e-05,
                       'K_0': 192200e6,
                       'Kprime_0': 4.04,
                       'Kdprime_0': -2.1e-11,
                       'n': 7.0,
                       'molar_mass': 0.1922948}
        self.property_modifiers = [['bragg_williams', {'deltaH': 8000.0,
                                                       'deltaV': 0.0,
                                                       'Wh': 1200.0,
                                                       'Wv': 0.0,
                                                       'n': 2.0,
                                                       'factor': 0.5}]]
        Mineral.__init__(self)


class br (Mineral):
    def __init__(self):
        self.params = {'name': 'br',
                       'formula': {'H': 2.0, 'Mg': 1.0, 'O': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -925560.0,
                       'S_0': 63.2,
                       'V_0': 2.463e-05,
                       'Cp': [158.4, -0.004076, -1052300.0, -1171.3],
                       'a_0': 6.2e-05,
                       'K_0': 41500e6,
                       'Kprime_0': 6.45,
                       'Kdprime_0': -1.55e-10,
                       'n': 5.0,
                       'molar_mass': 0.05831968}
        Mineral.__init__(self)


class dsp (Mineral):
    def __init__(self):
        self.params = {'name': 'dsp',
                       'formula': {'Al': 1.0, 'H': 1.0, 'O': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -999840.0,
                       'S_0': 34.5,
                       'V_0': 1.786e-05,
                       'Cp': [145.1, 0.008709, 584400.0, -1741.1],
                       'a_0': 3.57e-05,
                       'K_0': 228000e6,
                       'Kprime_0': 4.04,
                       'Kdprime_0': -1.8e-11,
                       'n': 4.0,
                       'molar_mass': 0.05998824}
        Mineral.__init__(self)


class gth (Mineral):
    def __init__(self):
        self.params = {'name': 'gth',
                       'formula': {'Fe': 1.0, 'H': 1.0, 'O': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -561770.0,
                       'S_0': 60.3,
                       'V_0': 2.082e-05,
                       'Cp': [139.3, 0.000147, -212700.0, -1077.8],
                       'a_0': 4.35e-05,
                       'K_0': 250000e6,
                       'Kprime_0': 4.03,
                       'Kdprime_0': -1.6e-11,
                       'n': 4.0,
                       'molar_mass': 0.08885174}
        Mineral.__init__(self)


class cc (Mineral):
    def __init__(self):
        self.params = {'name': 'cc',
                       'formula': {'C': 1.0, 'Ca': 1.0, 'O': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1207760.0,
                       'S_0': 92.5,
                       'V_0': 3.689e-05,
                       'Cp': [140.9, 0.005029, -950700.0, -858.4],
                       'a_0': 2.52e-05,
                       'K_0': 73300e6,
                       'Kprime_0': 4.06,
                       'Kdprime_0': -5.5e-11,
                       'n': 5.0,
                       'molar_mass': 0.1000869}
        self.property_modifiers = [['landau_hp', {'P_0': 100000.0,
                                                  'T_0': 298.15,
                                                  'Tc_0': 1240.0,
                                                  'S_D': 10.0,
                                                  'V_D': 4e-07}]]
        Mineral.__init__(self)


class arag (Mineral):
    def __init__(self):
        self.params = {'name': 'arag',
                       'formula': {'C': 1.0, 'Ca': 1.0, 'O': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1207650.0,
                       'S_0': 89.8,
                       'V_0': 3.415e-05,
                       'Cp': [167.1, 0.010695, 162000.0, -1564.9],
                       'a_0': 6.14e-05,
                       'K_0': 61400e6,
                       'Kprime_0': 5.87,
                       'Kdprime_0': -9.6e-11,
                       'n': 5.0,
                       'molar_mass': 0.1000869}
        Mineral.__init__(self)


class mag (Mineral):
    def __init__(self):
        self.params = {'name': 'mag',
                       'formula': {'C': 1.0, 'Mg': 1.0, 'O': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1110920.0,
                       'S_0': 65.5,
                       'V_0': 2.803e-05,
                       'Cp': [186.4, -0.003772, 0.0, -1886.2],
                       'a_0': 3.38e-05,
                       'K_0': 102800e6,
                       'Kprime_0': 5.41,
                       'Kdprime_0': -5.3e-11,
                       'n': 5.0,
                       'molar_mass': 0.0843139}
        Mineral.__init__(self)


class sid (Mineral):
    def __init__(self):
        self.params = {'name': 'sid',
                       'formula': {'C': 1.0, 'Fe': 1.0, 'O': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -762220.0,
                       'S_0': 93.3,
                       'V_0': 2.943e-05,
                       'Cp': [168.4, 0.0, 0.0, -1483.6],
                       'a_0': 4.39e-05,
                       'K_0': 120000e6,
                       'Kprime_0': 4.07,
                       'Kdprime_0': -3.4e-11,
                       'n': 5.0,
                       'molar_mass': 0.1158539}
        Mineral.__init__(self)


class rhc (Mineral):
    def __init__(self):
        self.params = {'name': 'rhc',
                       'formula': {'C': 1.0, 'Mn': 1.0, 'O': 3.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -892280.0,
                       'S_0': 98.0,
                       'V_0': 3.107e-05,
                       'Cp': [169.5, 0.0, 0.0, -1534.3],
                       'a_0': 2.44e-05,
                       'K_0': 95300e6,
                       'Kprime_0': 3.88,
                       'Kdprime_0': -4.1e-11,
                       'n': 5.0,
                       'molar_mass': 0.1149469}
        Mineral.__init__(self)


class dol (Mineral):
    def __init__(self):
        self.params = {'name': 'dol',
                       'formula': {'C': 2.0, 'Ca': 1.0, 'Mg': 1.0, 'O': 6.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -2326220.0,
                       'S_0': 156.1,
                       'V_0': 6.429e-05,
                       'Cp': [358.9, -0.004905, 0.0, -3456.2],
                       'a_0': 3.28e-05,
                       'K_0': 94300e6,
                       'Kprime_0': 3.74,
                       'Kdprime_0': -4e-11,
                       'n': 10.0,
                       'molar_mass': 0.1844008}
        self.property_modifiers = [['bragg_williams', {'deltaH': 11910.0,
                                                       'deltaV': 1.6e-07,
                                                       'Wh': 11900.0,
                                                       'Wv': 1.6e-07,
                                                       'n': 1.0,
                                                       'factor': 1.0}]]
        Mineral.__init__(self)


class ank (Mineral):
    def __init__(self):
        self.params = {'name': 'ank',
                       'formula': {'C': 2.0, 'Ca': 1.0, 'Fe': 1.0, 'O': 6.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1971410.0,
                       'S_0': 188.46,
                       'V_0': 6.606e-05,
                       'Cp': [341.0, -0.001161, 0.0, -3054.8],
                       'a_0': 3.46e-05,
                       'K_0': 91400e6,
                       'Kprime_0': 3.88,
                       'Kdprime_0': -4.3e-11,
                       'n': 10.0,
                       'molar_mass': 0.2159408}
        self.property_modifiers = [['bragg_williams', {'deltaH': 11910.0,
                                                       'deltaV': 1.6e-07,
                                                       'Wh': 11900.0,
                                                       'Wv': 1.6e-07,
                                                       'n': 1.0,
                                                       'factor': 1.0}]]
        Mineral.__init__(self)


class syv (Mineral):
    def __init__(self):
        self.params = {'name': 'syv',
                       'formula': {'Cl': 1.0, 'K': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -436500.0,
                       'S_0': 82.6,
                       'V_0': 3.752e-05,
                       'Cp': [46.2, 0.01797, 0.0, 0.0],
                       'a_0': 0.0001109,
                       'K_0': 17000e6,
                       'Kprime_0': 5.0,
                       'Kdprime_0': -2.94e-10,
                       'n': 2.0,
                       'molar_mass': 0.0745513}
        Mineral.__init__(self)


class hlt (Mineral):
    def __init__(self):
        self.params = {'name': 'hlt',
                       'formula': {'Cl': 1.0, 'Na': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -411300.0,
                       'S_0': 72.1,
                       'V_0': 2.702e-05,
                       'Cp': [45.2, 0.01797, 0.0, 0.0],
                       'a_0': 0.0001147,
                       'K_0': 23800e6,
                       'Kprime_0': 5.0,
                       'Kdprime_0': -2.1e-10,
                       'n': 2.0,
                       'molar_mass': 0.0584428}
        Mineral.__init__(self)


class pyr (Mineral):
    def __init__(self):
        self.params = {'name': 'pyr',
                       'formula': {'Fe': 1.0, 'S': 2.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -171640.0,
                       'S_0': 52.9,
                       'V_0': 2.394e-05,
                       'Cp': [37.3, 0.026715, -1817000.0, 649.3],
                       'a_0': 3.1e-05,
                       'K_0': 139500e6,
                       'Kprime_0': 4.09,
                       'Kdprime_0': -2.9e-11,
                       'n': 3.0,
                       'molar_mass': 0.119975}
        Mineral.__init__(self)


class trot (Mineral):
    def __init__(self):
        self.params = {'name': 'trot',
                       'formula': {'Fe': 1.0, 'S': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -99030.0,
                       'S_0': 65.5,
                       'V_0': 1.819e-05,
                       'Cp': [50.2, 0.011052, -940000.0, 0.0],
                       'a_0': 5.68e-05,
                       'K_0': 65800e6,
                       'Kprime_0': 4.17,
                       'Kdprime_0': -6.3e-11,
                       'n': 2.0,
                       'molar_mass': 0.08791}
        self.property_modifiers = [['landau_hp', {'P_0': 100000.0,
                                                  'T_0': 298.15,
                                                  'Tc_0': 598.0,
                                                  'S_D': 12.0,
                                                  'V_D': 4.1e-07}]]
        Mineral.__init__(self)


class tro (Mineral):
    def __init__(self):
        self.params = {'name': 'tro',
                       'formula': {'Fe': 1.0, 'S': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -97760.0,
                       'S_0': 70.8,
                       'V_0': 1.819e-05,
                       'Cp': [50.2, 0.011052, -940000.0, 0.0],
                       'a_0': 5.73e-05,
                       'K_0': 65800e6,
                       'Kprime_0': 4.17,
                       'Kdprime_0': -6.3e-11,
                       'n': 2.0,
                       'molar_mass': 0.08791}
        self.property_modifiers = [['landau_hp', {'P_0': 100000.0,
                                                  'T_0': 298.15,
                                                  'Tc_0': 598.0,
                                                  'S_D': 12.0,
                                                  'V_D': 4.1e-07}]]
        Mineral.__init__(self)


class lot (Mineral):
    def __init__(self):
        self.params = {'name': 'lot',
                       'formula': {'Fe': 1.0, 'S': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -102160.0,
                       'S_0': 60.0,
                       'V_0': 1.818e-05,
                       'Cp': [50.2, 0.011052, -940000.0, 0.0],
                       'a_0': 4.93e-05,
                       'K_0': 65800e6,
                       'Kprime_0': 4.17,
                       'Kdprime_0': -6.3e-11,
                       'n': 2.0,
                       'molar_mass': 0.08791}
        self.property_modifiers = [['landau_hp', {'P_0': 100000.0,
                                                  'T_0': 298.15,
                                                  'Tc_0': 420.0,
                                                  'S_D': 10.0,
                                                  'V_D': 0.0}]]
        Mineral.__init__(self)


class trov (Mineral):
    def __init__(self):
        self.params = {'name': 'trov',
                       'formula': {'Fe': 0.875, 'S': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -96020.0,
                       'S_0': 57.5,
                       'V_0': 1.738e-05,
                       'Cp': [51.1, 0.008307, -669700.0, 0.0],
                       'a_0': 5.94e-05,
                       'K_0': 65800e6,
                       'Kprime_0': 4.17,
                       'Kdprime_0': -6.3e-11,
                       'n': 1.875,
                       'molar_mass': 0.080929375}
        self.property_modifiers = [['landau_hp', {'P_0': 100000.0,
                                                  'T_0': 298.15,
                                                  'Tc_0': 595.0,
                                                  'S_D': 10.0,
                                                  'V_D': 1.6e-07}]]
        Mineral.__init__(self)


class any (Mineral):
    def __init__(self):
        self.params = {'name': 'any',
                       'formula': {'Ca': 1.0, 'O': 4.0, 'S': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -1434400.0,
                       'S_0': 106.9,
                       'V_0': 4.594e-05,
                       'Cp': [128.7, 0.048545, -1223000.0, -560.5],
                       'a_0': 4.18e-05,
                       'K_0': 54379999999.99999,
                       'Kprime_0': 4.19,
                       'Kdprime_0': -7.7e-11,
                       'n': 6.0,
                       'molar_mass': 0.1361406}
        Mineral.__init__(self)


class iron (Mineral):
    def __init__(self):
        self.params = {'name': 'iron',
                       'formula': {'Fe': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -0.0,
                       'S_0': 27.09,
                       'V_0': 7.09e-06,
                       'Cp': [46.2, 0.005159, 723100.0, -556.2],
                       'a_0': 3.56e-05,
                       'K_0': 164000e6,
                       'Kprime_0': 5.16,
                       'Kdprime_0': -3.1e-11,
                       'n': 1.0,
                       'molar_mass': 0.055845}
        self.property_modifiers = [['landau_hp', {'P_0': 100000.0,
                                                  'T_0': 298.15,
                                                  'Tc_0': 1042.0,
                                                  'S_D': 8.3,
                                                  'V_D': 0.0}]]
        Mineral.__init__(self)


class Ni (Mineral):
    def __init__(self):
        self.params = {'name': 'Ni',
                       'formula': {'Ni': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': 0.0,
                       'S_0': 29.87,
                       'V_0': 6.59e-06,
                       'Cp': [49.8, 0.0, 585900.0, -533.9],
                       'a_0': 4.28e-05,
                       'K_0': 190500e6,
                       'Kprime_0': 4.25,
                       'Kdprime_0': -2.2e-11,
                       'n': 1.0,
                       'molar_mass': 0.0586934}
        self.property_modifiers = [['landau_hp', {'P_0': 100000.0,
                                                  'T_0': 298.15,
                                                  'Tc_0': 631.0,
                                                  'S_D': 3.0,
                                                  'V_D': 0.0}]]
        Mineral.__init__(self)


class Cu (Mineral):
    def __init__(self):
        self.params = {'name': 'Cu',
                       'formula': {'Cu': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': -0.0,
                       'S_0': 33.14,
                       'V_0': 7.11e-06,
                       'Cp': [12.4, 0.00922, -379900.0, 233.5],
                       'a_0': 3.58e-05,
                       'K_0': 162500e6,
                       'Kprime_0': 4.24,
                       'Kdprime_0': -2.6e-11,
                       'n': 1.0,
                       'molar_mass': 0.063546}
        Mineral.__init__(self)


class gph (Mineral):
    def __init__(self):
        self.params = {'name': 'gph',
                       'formula': {'C': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': 0.0,
                       'S_0': 5.76,
                       'V_0': 5.3e-06,
                       'Cp': [34.3, 0.0, -240700.0, -403.8],
                       'a_0': 1.65e-05,
                       'K_0': 31200e6,
                       'Kprime_0': 3.9,
                       'Kdprime_0': -1.25e-10,
                       'n': 1.0,
                       'molar_mass': 0.0120107}
        Mineral.__init__(self)


class diam (Mineral):
    def __init__(self):
        self.params = {'name': 'diam',
                       'formula': {'C': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': 1890.0,
                       'S_0': 2.36,
                       'V_0': 3.42e-06,
                       'Cp': [40.0, 0.0, -28500.0, -580.5],
                       'a_0': 4e-06,
                       'K_0': 446500e6,
                       'Kprime_0': 1.61,
                       'Kdprime_0': -3.6e-12,
                       'n': 1.0,
                       'molar_mass': 0.0120107}
        Mineral.__init__(self)


class S (Mineral):
    def __init__(self):
        self.params = {'name': 'S',
                       'formula': {'S': 1.0},
                       'equation_of_state': 'hp_tmt',
                       'H_0': 0.0,
                       'S_0': 32.05,
                       'V_0': 1.551e-05,
                       'Cp': [56.6, -0.004557, 638000.0, -681.8],
                       'a_0': 6.4e-05,
                       'K_0': 14500e6,
                       'Kprime_0': 7.0,
                       'Kdprime_0': -4.8e-10,
                       'n': 1.0,
                       'molar_mass': 0.032065}
        Mineral.__init__(self)


class syvL (Mineral):
    def __init__(self):
        self.params = {'name': 'syvL',
                       'formula': {'Cl': 1.0, 'K': 1.0},
                       'equation_of_state': 'hp_tmtL',
                       'H_0': -417410.0,
                       'S_0': 94.5,
                       'V_0': 3.822e-05,
                       'Cp': [66.9, 0.0, 0.0, 0.0],
                       'a_0': 0.000301,
                       'K_0': 5600e6,
                       'Kprime_0': 4.65,
                       'Kdprime_0': -8.3e-10,
                       'dKdT_0': -2e6,
                       'n': 2.0,
                       'molar_mass': 0.0745513}
        Mineral.__init__(self)


class hltL (Mineral):
    def __init__(self):
        self.params = {'name': 'hltL',
                       'formula': {'Cl': 1.0, 'Na': 1.0},
                       'equation_of_state': 'hp_tmtL',
                       'H_0': -392990.0,
                       'S_0': 80.1,
                       'V_0': 2.938e-05,
                       'Cp': [72.0, -0.003223, 0.0, 0.0],
                       'a_0': 0.000295,
                       'K_0': 6400e6,
                       'Kprime_0': 4.61,
                       'Kdprime_0': -7.2e-10,
                       'dKdT_0': -1500000.0,
                       'n': 2.0,
                       'molar_mass': 0.0584428}
        Mineral.__init__(self)


class perL (Mineral):
    def __init__(self):
        self.params = {'name': 'perL',
                       'formula': {'Mg': 1.0, 'O': 1.0},
                       'equation_of_state': 'hp_tmtL',
                       'H_0': -654120.0,
                       'S_0': -64.3,
                       'V_0': 8.39e-06,
                       'Cp': [99.0, 0.0, 0.0, 0.0],
                       'a_0': 0.000226,
                       'K_0': 36200e6,
                       'Kprime_0': 10.06,
                       'Kdprime_0': -2.78e-10,
                       'dKdT_0': -4100000.0,
                       'n': 2.0,
                       'molar_mass': 0.0403044}
        Mineral.__init__(self)


class limL (Mineral):
    def __init__(self):
        self.params = {'name': 'limL',
                       'formula': {'Ca': 1.0, 'O': 1.0},
                       'equation_of_state': 'hp_tmtL',
                       'H_0': -692280.0,
                       'S_0': -47.5,
                       'V_0': 1.303e-05,
                       'Cp': [99.0, 0.0, 0.0, 0.0],
                       'a_0': 0.000175,
                       'K_0': 36200e6,
                       'Kprime_0': 10.06,
                       'Kdprime_0': -2.78e-10,
                       'dKdT_0': -4100000.0,
                       'n': 2.0,
                       'molar_mass': 0.0560774}
        Mineral.__init__(self)


class corL (Mineral):
    def __init__(self):
        self.params = {'name': 'corL',
                       'formula': {'Al': 2.0, 'O': 3.0},
                       'equation_of_state': 'hp_tmtL',
                       'H_0': -1632160.0,
                       'S_0': 14.9,
                       'V_0': 3.369e-05,
                       'Cp': [157.6, 0.0, 0.0, 0.0],
                       'a_0': 7.03e-05,
                       'K_0': 15000e6,
                       'Kprime_0': 6.0,
                       'Kdprime_0': 4e-10,
                       'dKdT_0': -3500000.0000000005,
                       'n': 5.0,
                       'molar_mass': 0.1019612}
        Mineral.__init__(self)


class qL (Mineral):
    def __init__(self):
        self.params = {'name': 'qL',
                       'formula': {'O': 2.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmtL',
                       'H_0': -921070.0,
                       'S_0': 16.3,
                       'V_0': 2.73e-05,
                       'Cp': [82.5, 0.0, 0.0, 0.0],
                       'a_0': 0.0,
                       'K_0': 22000e6,
                       'Kprime_0': 9.46,
                       'Kdprime_0': -4.3e-10,
                       'dKdT_0': -3500000.0000000005,
                       'n': 3.0,
                       'molar_mass': 0.0600843}
        Mineral.__init__(self)


class h2oL (Mineral):
    def __init__(self):
        self.params = {'name': 'h2oL',
                       'formula': {'H': 2.0, 'O': 1.0},
                       'equation_of_state': 'hp_tmtL',
                       'H_0': -295010.0,
                       'S_0': 45.5,
                       'V_0': 1.39e-05,
                       'Cp': [80.0, 0.0, 0.0, 0.0],
                       'a_0': 0.000521,
                       'K_0': 5060e6,
                       'Kprime_0': 4.0,
                       'Kdprime_0': -7.9e-10,
                       'dKdT_0': -370000.0,
                       'n': 3.0,
                       'molar_mass': 0.01801528}
        Mineral.__init__(self)


class foL (Mineral):
    def __init__(self):
        self.params = {'name': 'foL',
                       'formula': {'Mg': 2.0, 'O': 4.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmtL',
                       'H_0': -2237350.0,
                       'S_0': -62.0,
                       'V_0': 4.312e-05,
                       'Cp': [269.4, 0.0, 0.0, 0.0],
                       'a_0': 9.2e-05,
                       'K_0': 36200e6,
                       'Kprime_0': 10.06,
                       'Kdprime_0': -2.78e-10,
                       'dKdT_0': -4400000.0,
                       'n': 7.0,
                       'molar_mass': 0.1406931}
        Mineral.__init__(self)


class faL (Mineral):
    def __init__(self):
        self.params = {'name': 'faL',
                       'formula': {'Fe': 2.0, 'O': 4.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmtL',
                       'H_0': -1463020.0,
                       'S_0': 96.0,
                       'V_0': 4.677e-05,
                       'Cp': [243.7, 0.0, 0.0, 0.0],
                       'a_0': 0.0001071,
                       'K_0': 29000e6,
                       'Kprime_0': 10.42,
                       'Kdprime_0': -3.59e-10,
                       'dKdT_0': -5500000.0,
                       'n': 7.0,
                       'molar_mass': 0.2037731}
        Mineral.__init__(self)


class woL (Mineral):
    def __init__(self):
        self.params = {'name': 'woL',
                       'formula': {'Ca': 1.0, 'O': 3.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmtL',
                       'H_0': -1642220.0,
                       'S_0': 22.5,
                       'V_0': 3.965e-05,
                       'Cp': [167.4, 0.0, 0.0, 0.0],
                       'a_0': 6.69e-05,
                       'K_0': 30500e6,
                       'Kprime_0': 9.38,
                       'Kdprime_0': -3.08e-10,
                       'dKdT_0': -2e6,
                       'n': 5.0,
                       'molar_mass': 0.1161617}
        Mineral.__init__(self)


class enL (Mineral):
    def __init__(self):
        self.params = {'name': 'enL',
                       'formula': {'Mg': 2.0, 'O': 6.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmtL',
                       'H_0': -3096570.0,
                       'S_0': -4.0,
                       'V_0': 6.984e-05,
                       'Cp': [353.6, 0.0, 0.0, 0.0],
                       'a_0': 6.81e-05,
                       'K_0': 21800e6,
                       'Kprime_0': 7.2,
                       'Kdprime_0': -3.3e-10,
                       'dKdT_0': -2400000.0,
                       'n': 10.0,
                       'molar_mass': 0.2007774}
        Mineral.__init__(self)


class diL (Mineral):
    def __init__(self):
        self.params = {'name': 'diL',
                       'formula': {'Ca': 1.0, 'Mg': 1.0, 'O': 6.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmtL',
                       'H_0': -3193870.0,
                       'S_0': 42.1,
                       'V_0': 7.288e-05,
                       'Cp': [334.0, 0.0, 0.0, 0.0],
                       'a_0': 8.51e-05,
                       'K_0': 24900e6,
                       'Kprime_0': 8.04,
                       'Kdprime_0': -3.23e-10,
                       'dKdT_0': -3730000.0,
                       'n': 10.0,
                       'molar_mass': 0.2165504}
        Mineral.__init__(self)


class silL (Mineral):
    def __init__(self):
        self.params = {'name': 'silL',
                       'formula': {'Al': 2.0, 'O': 5.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmtL',
                       'H_0': -2593430.0,
                       'S_0': 10.0,
                       'V_0': 6.051e-05,
                       'Cp': [253.0, 0.0, 0.0, 0.0],
                       'a_0': 4.08e-05,
                       'K_0': 22000e6,
                       'Kprime_0': 6.36,
                       'Kdprime_0': -2.89e-10,
                       'dKdT_0': -2900000.0,
                       'n': 8.0,
                       'molar_mass': 0.1620455}
        Mineral.__init__(self)


class anL (Mineral):
    def __init__(self):
        self.params = {'name': 'anL',
                       'formula': {'Al': 2.0, 'Ca': 1.0, 'O': 8.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmtL',
                       'H_0': -4277970.0,
                       'S_0': 29.0,
                       'V_0': 0.00010014,
                       'Cp': [430.0, 0.0, 0.0, 0.0],
                       'a_0': 5.14e-05,
                       'K_0': 21000e6,
                       'Kprime_0': 6.38,
                       'Kdprime_0': -3.04e-10,
                       'dKdT_0': -5500000.0,
                       'n': 13.0,
                       'molar_mass': 0.2782072}
        Mineral.__init__(self)


class kspL (Mineral):
    def __init__(self):
        self.params = {'name': 'kspL',
                       'formula': {'Al': 1.0, 'K': 1.0, 'O': 8.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmtL',
                       'H_0': -3985190.0,
                       'S_0': 129.2,
                       'V_0': 0.00011431,
                       'Cp': [368.0, 0.0, 0.0, 0.0],
                       'a_0': 4.93e-05,
                       'K_0': 17300e6,
                       'Kprime_0': 6.84,
                       'Kdprime_0': -3.93e-10,
                       'dKdT_0': -899999.9999999999,
                       'n': 13.0,
                       'molar_mass': 0.2783315}
        Mineral.__init__(self)


class abL (Mineral):
    def __init__(self):
        self.params = {'name': 'abL',
                       'formula': {'Al': 1.0, 'Na': 1.0, 'O': 8.0, 'Si': 3.0},
                       'equation_of_state': 'hp_tmtL',
                       'H_0': -3926520.0,
                       'S_0': 149.9,
                       'V_0': 0.00010858,
                       'Cp': [358.0, 0.0, 0.0, 0.0],
                       'a_0': 3.37e-05,
                       'K_0': 17600e6,
                       'Kprime_0': 14.35,
                       'Kdprime_0': -8.15e-10,
                       'dKdT_0': -2600000.0,
                       'n': 13.0,
                       'molar_mass': 0.262223}
        Mineral.__init__(self)


class neL (Mineral):
    def __init__(self):
        self.params = {'name': 'neL',
                       'formula': {'Al': 1.0, 'Na': 1.0, 'O': 4.0, 'Si': 1.0},
                       'equation_of_state': 'hp_tmtL',
                       'H_0': -2116730.0,
                       'S_0': 52.9,
                       'V_0': 5.2e-05,
                       'Cp': [216.5, 0.0, 0.0, 0.0],
                       'a_0': 0.000137,
                       'K_0': 25000e6,
                       'Kprime_0': 7.37,
                       'Kdprime_0': -2.95e-10,
                       'dKdT_0': -800000.0,
                       'n': 7.0,
                       'molar_mass': 0.1420544}
        Mineral.__init__(self)


class lcL (Mineral):
    def __init__(self):
        self.params = {'name': 'lcL',
                       'formula': {'Al': 1.0, 'K': 1.0, 'O': 6.0, 'Si': 2.0},
                       'equation_of_state': 'hp_tmtL',
                       'H_0': -3068410.0,
                       'S_0': 102.0,
                       'V_0': 8.59e-05,
                       'Cp': [287.0, 0.0, 0.0, 0.0],
                       'a_0': 6.7e-05,
                       'K_0': 17500e6,
                       'Kprime_0': 7.0,
                       'Kdprime_0': -3.94e-10,
                       'dKdT_0': -0.0,
                       'n': 10.0,
                       'molar_mass': 0.2182472}
        Mineral.__init__(self)


def cov():
    """
    A function which loads and returns the variance-covariance matrix of the
    zero-point energies of all the endmembers in the dataset.

    Returns
    -------
    cov : dictionary
        Dictionary keys are:
        - endmember_names: a list of endmember names, and
        - covariance_matrix: a 2D variance-covariance array for the
          endmember zero-point energies of formation
    """

    from .HP_2011_ds62_cov import cov
    return cov
