# This file is part of BurnMan - a thermoelastic and thermodynamic toolkit
# for the Earth and Planetary Sciences
# Copyright (C) 2012 - 2021 by the BurnMan team, released under the GNU
# GPL v2 or later.


"""
HP_2011 (ds-62) zero-point energy covariance matrix
Derived from Holland and Powell 2011 and references therein
Update to dataset version 6.2
The values in this document are all in S.I. units,
unlike those in the original tc-ds62.txt
File autogenerated using HPdata_to_burnman.py
"""

from numpy import array

cov = {'covariance_matrix': array([[ 2.862000e+05,  1.300000e+04,  3.520000e+04, -3.620000e+04,
         1.244000e+05,  1.243300e+06,  6.711000e+05,  2.796000e+05,
         1.300000e+04,  2.766000e+05,  1.300000e+04,  1.627000e+05,
         1.220000e+04, -4.740000e+04, -9.200000e+03,  1.564000e+05,
         2.000000e+03,  6.507000e+05,  4.026000e+05, -2.600000e+03,
         2.530000e+04, -7.440000e+04, -3.190000e+04,  3.162000e+05,
         2.188000e+05,  4.184000e+05, -5.130000e+04, -1.809000e+05,
        -3.010000e+04, -3.010000e+04, -3.040000e+04, -2.990000e+04,
        -5.060000e+04, -3.020000e+04,  2.345000e+05, -3.076000e+05,
        -2.685000e+05,  1.033000e+05, -3.260000e+04, -2.250000e+04,
         8.790000e+04, -1.000000e+05, -7.210000e+04, -7.210000e+04,
        -5.040000e+04, -2.900000e+04, -4.120000e+04, -3.940000e+04,
         1.300000e+04, -1.226000e+05, -1.450000e+04, -8.270000e+04,
         1.150000e+05, -4.540000e+04, -1.000000e+05,  2.554000e+05,
         2.553000e+05, -1.330000e+04,  3.900000e+03,  8.704000e+05,
        -8.500000e+03,  8.700000e+03,  1.550000e+04,  3.012000e+05,
         3.012000e+05,  3.012000e+05,  3.012000e+05,  3.050000e+04,
         1.011000e+05,  1.429000e+05,  6.800000e+03, -8.900000e+03,
         1.230000e+04, -5.110000e+04, -5.640000e+04, -2.400000e+03,
         2.290000e+04,  2.290000e+04, -9.200000e+03, -9.200000e+03,
        -9.200000e+03,  7.539000e+05,  7.660000e+04,  3.532000e+05,
         4.998000e+05,  4.497000e+05,  4.420000e+04,  8.690000e+04,
         1.070100e+06,  1.227000e+05,  1.070100e+06,  1.240000e+05,
         6.678000e+05,  3.717000e+05,  1.720000e+05, -1.688000e+05,
         1.198000e+05, -1.570000e+04,  1.687000e+05, -1.201000e+05,
         7.760000e+04, -5.750000e+04, -3.950000e+04, -8.680000e+04,
         3.262000e+05, -7.920000e+04, -5.110000e+04,  1.285000e+05,
         4.147000e+05,  6.713000e+05,  4.711000e+05,  8.715000e+05,
        -6.300000e+03,  4.250000e+04,  2.222000e+05, -4.880000e+04,
         2.200000e+04,  4.676000e+05,  6.000000e+04,  2.699000e+05,
         2.180000e+04,  6.310000e+04,  4.475000e+05, -1.290000e+04,
        -4.820000e+04, -2.660000e+04,  4.398000e+05,  4.397000e+05,
         2.810000e+04,  2.930000e+04,  7.069000e+05,  7.017400e+06,
         8.000000e+03,  8.000000e+03, -7.230000e+04, -7.240000e+04,
        -3.920000e+04, -7.250000e+04, -1.320000e+05, -7.240000e+04,
         1.740000e+04,  1.740000e+04,  1.740000e+04,  1.740000e+04,
         2.090000e+04, -2.330000e+04, -2.330000e+04, -2.330000e+04,
        -1.396000e+05, -1.046000e+05, -8.850000e+04, -1.449000e+05,
        -4.500000e+03, -4.700000e+03,  4.740000e+04,  4.730000e+04,
        -9.500000e+03, -2.180000e+04,  6.000000e+02,  9.550000e+04,
        -2.300000e+03, -5.200000e+03, -4.740000e+04,  1.627000e+05,
        -4.300000e+03, -1.356000e+05,  0.000000e+00,  0.000000e+00,
         6.200000e+03,  1.259000e+05, -1.700000e+03, -4.600000e+03,
         0.000000e+00,  0.000000e+00,  8.430000e+04, -5.010000e+04,
        -6.800000e+03,  4.190000e+04, -1.600000e+03,  0.000000e+00,
         9.860000e+04, -2.390000e+04, -2.200000e+03, -2.720000e+04,
        -2.720000e+04,  1.249000e+05, -3.200000e+03,  3.000000e+02,
         9.670000e+04, -3.060000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02, -3.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  9.550000e+04, -2.180000e+04,
        -6.200000e+03,  1.740000e+04, -1.000000e+02,  2.862000e+05,
         1.300000e+04, -9.200000e+03,  3.012000e+05,  1.429000e+05,
        -2.990000e+04, -3.920000e+04, -7.240000e+04,  8.000000e+03,
        -2.330000e+04, -8.850000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.740000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.300000e+04,  4.066000e+05,  3.180000e+04, -1.400000e+03,
         5.900000e+03,  3.920000e+04,  1.310000e+04,  1.390000e+04,
         4.066000e+05,  1.430000e+04,  4.063000e+05,  2.960000e+04,
         8.930000e+04, -6.830000e+04,  2.320000e+04,  3.060000e+04,
         2.070000e+04,  1.182000e+05,  2.320000e+04,  5.350000e+05,
         5.460000e+04,  9.000000e+02,  3.689000e+05,  1.091000e+05,
         1.844000e+05,  2.835000e+05,  5.663000e+05, -2.640000e+04,
        -1.850000e+04, -1.850000e+04, -1.800000e+04, -1.900000e+04,
        -6.070000e+04, -1.860000e+04, -3.185000e+05,  3.636000e+05,
        -2.766000e+05, -3.720000e+04,  1.326000e+05, -2.670000e+04,
         4.500000e+03, -2.710000e+04, -6.400000e+03, -6.500000e+03,
         1.810000e+05,  3.662000e+05,  1.880000e+04,  4.600000e+03,
         2.300000e+03,  1.725000e+05,  1.110000e+06, -7.150000e+04,
         2.900000e+04,  2.180000e+04, -2.690000e+04,  7.340000e+04,
         7.340000e+04,  4.267000e+05,  9.440000e+04, -1.320000e+04,
         2.800000e+03,  7.090000e+04,  3.770000e+04,  6.110000e+04,
         6.110000e+04,  6.110000e+04,  6.110000e+04,  4.564000e+05,
        -3.760000e+04,  5.350000e+04,  2.507000e+05, -7.900000e+03,
         1.798000e+05,  3.510000e+04, -4.520000e+04,  5.230000e+04,
         3.620000e+04,  3.620000e+04,  2.320000e+04,  2.310000e+04,
         2.320000e+04,  2.480000e+05,  1.236000e+06,  5.030000e+04,
        -4.000000e+02,  1.249000e+05,  7.173000e+05,  1.028200e+06,
         2.631000e+05,  1.646800e+06,  2.631000e+05,  1.647400e+06,
         6.440000e+04, -2.478000e+05, -3.464000e+05,  5.247000e+05,
         1.180000e+04,  1.819000e+05,  3.623600e+06, -5.790000e+04,
         4.100000e+04,  2.116000e+05, -2.700000e+04, -6.380000e+04,
        -4.730000e+04,  5.343000e+05, -1.590000e+04, -1.462000e+05,
        -1.130000e+04, -1.270000e+04, -1.116000e+05,  8.610000e+04,
         8.380000e+05,  3.960000e+04, -2.640000e+04,  3.139000e+05,
         1.297000e+05,  1.408000e+05,  6.501000e+05,  4.200000e+04,
         1.316000e+05,  7.346000e+05,  2.204000e+05,  2.970000e+04,
         2.770000e+04,  2.152000e+05,  4.180000e+04,  4.180000e+04,
         6.347000e+05,  1.103100e+06,  2.524000e+05,  7.947000e+05,
         4.120000e+04,  4.130000e+04,  1.050000e+04,  1.050000e+04,
         4.700000e+03,  1.040000e+04, -1.040000e+04,  1.050000e+04,
         4.990000e+04,  4.990000e+04,  4.990000e+04,  4.990000e+04,
         4.950000e+04, -5.300000e+04, -5.290000e+04, -5.290000e+04,
        -3.178000e+05, -8.720000e+04, -3.830000e+04, -1.020000e+04,
         1.044000e+05,  1.043000e+05,  2.540000e+05,  2.539000e+05,
        -8.700000e+03, -2.380000e+04, -2.100000e+04, -1.260000e+04,
         1.047000e+05, -2.800000e+03, -6.830000e+04,  2.960000e+04,
         3.090000e+05,  1.750000e+04,  0.000000e+00, -2.200000e+03,
        -2.620000e+04, -3.770000e+04,  1.278000e+05, -1.130000e+04,
         0.000000e+00,  0.000000e+00, -8.600000e+04,  8.290000e+04,
         4.653000e+05,  8.670000e+04,  1.235000e+05,  0.000000e+00,
        -1.300000e+04, -3.480000e+04,  1.542000e+05, -2.430000e+04,
        -2.430000e+04, -1.640000e+04,  1.550000e+05, -3.100000e+03,
        -4.060000e+04,  1.309000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  3.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.260000e+04, -2.380000e+04,
        -9.000000e+03,  4.990000e+04,  0.000000e+00,  1.300000e+04,
         4.066000e+05,  2.310000e+04,  6.110000e+04,  5.350000e+04,
        -1.890000e+04,  4.700000e+03,  1.050000e+04,  4.130000e+04,
        -5.290000e+04, -3.830000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.990000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 3.520000e+04,  3.180000e+04,  9.841000e+05,  3.600000e+03,
         1.920000e+04,  1.245000e+05,  5.420000e+04,  3.270000e+04,
         3.180000e+04,  3.160000e+04,  3.180000e+04,  4.210000e+04,
         1.670000e+04, -5.330000e+04,  2.190000e+04,  3.970000e+04,
         3.600000e+03,  1.684000e+05,  5.890000e+04,  5.670000e+04,
         1.436800e+06,  1.200000e+04,  5.750000e+04,  1.152000e+05,
         1.743000e+05,  2.657000e+05,  1.723000e+05,  7.390000e+04,
        -1.250000e+04, -1.250000e+04, -1.250000e+04, -1.250000e+04,
        -4.620000e+04, -1.250000e+04, -1.871000e+05, -1.909000e+05,
         1.650000e+06, -1.570000e+04, -1.690000e+04,  4.436000e+05,
         2.270000e+04, -1.490000e+04,  4.300000e+03,  4.300000e+03,
         2.700000e+04,  4.980000e+04,  4.869000e+05,  9.200000e+03,
         3.210000e+04,  3.110000e+04,  1.447000e+05, -5.040000e+04,
         4.120000e+04,  2.550000e+04, -1.840000e+04,  9.030000e+04,
         9.030000e+04,  8.910000e+04,  1.008900e+06,  2.270000e+04,
         9.700000e+03,  6.210000e+04,  3.190000e+04,  7.520000e+04,
         7.520000e+04,  7.520000e+04,  7.520000e+04,  7.270000e+04,
        -1.630000e+04,  5.990000e+04,  5.840000e+04, -7.000000e+03,
         1.520000e+04,  2.140000e+04, -3.150000e+04,  4.540000e+04,
         4.623000e+05,  4.623000e+05,  2.190000e+04,  2.190000e+04,
         2.190000e+04,  2.731000e+05,  2.667000e+05,  8.980000e+04,
         5.650000e+04,  1.391000e+05,  1.349000e+05,  1.813000e+05,
         3.036000e+05,  2.950000e+05,  3.036000e+05,  2.954000e+05,
         1.198000e+05, -1.463000e+05, -2.377000e+05, -1.506000e+05,
         2.490000e+04,  2.380000e+04,  4.122000e+05, -5.160000e+04,
         3.920000e+04,  3.850000e+04, -1.990000e+04, -4.420000e+04,
        -8.200000e+03, -1.180000e+04,  1.369600e+06, -9.910000e+04,
         2.610000e+04,  5.330000e+04, -3.830000e+04,  1.448000e+05,
         4.810000e+04,  2.349700e+06,  8.900000e+03,  6.800000e+03,
         1.091000e+05,  1.531000e+05,  1.494000e+05,  6.230000e+04,
         1.102000e+05,  1.500000e+05,  1.458000e+05,  2.700000e+04,
         3.110000e+04,  5.380000e+04,  7.530000e+04,  7.530000e+04,
         6.810000e+04,  2.047000e+05,  2.098000e+05,  1.244000e+06,
         3.340000e+04,  3.340000e+04,  1.800000e+03,  1.800000e+03,
         9.200000e+03,  1.800000e+03, -2.480000e+04,  1.800000e+03,
         4.090000e+04,  4.090000e+04,  4.090000e+04,  4.090000e+04,
         4.220000e+04, -4.460000e+04, -4.460000e+04, -4.460000e+04,
        -2.675000e+05, -7.900000e+04, -3.860000e+04,  5.800000e+03,
         9.110000e+04,  9.100000e+04,  2.138000e+05,  2.137000e+05,
        -7.600000e+03, -1.580000e+04, -1.220000e+04, -1.750000e+04,
        -3.100000e+03,  1.997000e+05, -5.330000e+04,  4.210000e+04,
        -8.100000e+03,  2.400000e+03,  0.000000e+00,  0.000000e+00,
         3.595000e+05, -1.790000e+04, -1.650000e+04, -9.600000e+03,
         0.000000e+00,  0.000000e+00, -5.690000e+04, -5.760000e+04,
        -1.240000e+04, -3.500000e+03, -1.590000e+04,  0.000000e+00,
        -1.610000e+04, -2.720000e+04, -4.100000e+03, -2.190000e+04,
        -2.190000e+04, -9.500000e+03, -8.200000e+03,  2.105000e+05,
        -3.150000e+04, -3.010000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.900000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.750000e+04, -1.580000e+04,
        -7.000000e+03,  4.090000e+04,  0.000000e+00,  3.520000e+04,
         3.180000e+04,  2.190000e+04,  7.520000e+04,  5.990000e+04,
        -1.250000e+04,  9.200000e+03,  1.800000e+03,  3.340000e+04,
        -4.460000e+04, -3.860000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.090000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-3.620000e+04, -1.400000e+03,  3.600000e+03,  7.191000e+05,
         3.267000e+05, -1.599000e+05, -8.750000e+04, -3.510000e+04,
        -1.400000e+03, -3.450000e+04, -1.400000e+03, -1.670000e+04,
         0.000000e+00, -6.440000e+04,  3.437000e+05, -1.560000e+04,
         1.000000e+02, -6.680000e+04, -1.089000e+05, -5.540000e+04,
        -4.730000e+04,  9.416000e+05,  1.017600e+06, -2.360000e+04,
        -1.128000e+05, -6.360000e+04, -7.760000e+04,  5.968800e+06,
        -5.770000e+04, -5.780000e+04, -5.760000e+04, -5.780000e+04,
        -7.720000e+04, -5.780000e+04, -6.160000e+05, -5.448000e+05,
        -5.339000e+05, -7.910000e+04, -6.130000e+04, -5.860000e+04,
         1.027500e+06,  1.738200e+06,  5.739000e+05,  5.739000e+05,
         6.068000e+05,  6.432000e+05,  6.120000e+05,  2.740000e+05,
         1.164400e+06,  1.182200e+06,  1.347000e+06,  5.996000e+05,
         6.691000e+05,  1.052900e+06,  1.712500e+06, -1.378000e+05,
        -1.378000e+05, -1.026000e+05, -9.670000e+04, -1.182000e+05,
         3.124000e+05,  3.119000e+05,  5.000000e+03, -2.990000e+04,
        -2.990000e+04, -2.990000e+04, -2.990000e+04,  5.300000e+03,
        -7.900000e+04,  3.192000e+05,  3.372000e+05, -6.900000e+03,
         2.240000e+04,  3.580000e+04,  2.707000e+05,  1.373000e+05,
         4.600000e+03,  4.600000e+03,  3.437000e+05,  3.436000e+05,
         3.437000e+05,  6.002000e+05,  6.892000e+05,  4.994000e+05,
         5.214000e+05, -5.190000e+04,  1.200000e+03,  5.920000e+04,
        -9.790000e+04,  2.540000e+04, -9.790000e+04,  2.540000e+04,
        -1.947000e+05, -3.288000e+05, -3.779000e+05, -2.583000e+05,
        -7.270000e+04, -5.490000e+04,  2.400000e+03, -5.280000e+04,
        -3.100000e+03,  1.480000e+04, -6.460000e+04,  2.092000e+05,
        -5.310000e+04, -3.000000e+02,  8.500000e+03, -1.029000e+05,
        -6.380000e+04, -1.513000e+05, -2.006000e+05, -1.021000e+05,
        -6.220000e+04, -4.860000e+04, -1.522000e+05, -1.165000e+05,
        -3.690000e+04, -3.810000e+04,  1.530000e+04, -8.770000e+04,
        -3.740000e+04,  1.480000e+04, -3.530000e+04, -5.010000e+04,
         6.102000e+05,  6.432000e+05, -5.190000e+04, -5.190000e+04,
         1.300000e+03, -1.800000e+04, -1.072000e+05, -8.039000e+05,
        -1.000000e+02, -1.000000e+02,  1.180000e+04,  1.180000e+04,
         2.720000e+05,  1.180000e+04,  7.470000e+04,  1.180000e+04,
         6.700000e+03,  6.700000e+03,  6.700000e+03,  6.700000e+03,
         6.000000e+03, -1.440000e+04, -1.440000e+04, -1.440000e+04,
        -8.650000e+04, -1.200000e+03,  5.300000e+03,  1.149900e+06,
         2.862000e+05,  2.869000e+05,  3.072000e+05,  3.072000e+05,
        -6.800000e+03,  3.142000e+05, -1.790000e+04, -1.470000e+04,
        -2.200000e+03,  1.400000e+03, -6.440000e+04, -1.670000e+04,
        -9.900000e+03,  2.120000e+04,  0.000000e+00, -6.000000e+02,
        -1.530000e+04, -3.870000e+04, -2.160000e+04, -1.500000e+03,
         0.000000e+00,  0.000000e+00, -8.530000e+04, -6.810000e+04,
        -1.410000e+04, -1.020000e+04, -2.080000e+04,  0.000000e+00,
        -1.520000e+04, -3.200000e+04, -4.900000e+03,  3.337000e+05,
         3.336000e+05, -2.390000e+04, -7.200000e+03, -1.900000e+03,
         3.056000e+05,  3.259000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.100000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.470000e+04,  3.142000e+05,
        -8.500000e+03,  6.700000e+03,  0.000000e+00, -3.620000e+04,
        -1.400000e+03,  3.436000e+05, -2.990000e+04,  3.192000e+05,
        -5.780000e+04,  2.720000e+05,  1.180000e+04, -1.000000e+02,
        -1.440000e+04,  5.300000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  6.700000e+03,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.244000e+05,  5.900000e+03,  1.920000e+04,  3.267000e+05,
         2.396000e+05,  5.393000e+05,  2.905000e+05,  1.217000e+05,
         5.900000e+03,  1.205000e+05,  5.900000e+03,  7.260000e+04,
         6.000000e+03, -5.590000e+04,  1.668000e+05,  7.010000e+04,
         1.100000e+03,  2.904000e+05,  1.460000e+05, -2.880000e+04,
        -1.110000e+04,  4.325000e+05,  4.915000e+05,  1.457000e+05,
         5.300000e+04,  1.770000e+05, -6.380000e+04,  2.886800e+06,
        -4.380000e+04, -4.390000e+04, -4.390000e+04, -4.380000e+04,
        -6.380000e+04, -4.390000e+04, -1.911000e+05, -4.252000e+05,
        -4.006000e+05,  1.190000e+04, -4.680000e+04, -4.050000e+04,
         5.728000e+05,  8.144000e+05,  2.504000e+05,  2.504000e+05,
         2.776000e+05,  3.064000e+05,  2.846000e+05,  1.171000e+05,
         5.872000e+05,  5.287000e+05,  6.646000e+05,  2.578000e+05,
         4.090000e+05,  4.939000e+05,  8.033000e+05,  5.850000e+04,
         5.850000e+04, -5.760000e+04, -4.620000e+04,  3.749000e+05,
         1.517000e+05,  1.737000e+05,  1.020000e+04,  1.351000e+05,
         1.351000e+05,  1.351000e+05,  1.351000e+05,  1.800000e+04,
         1.090000e+04,  2.306000e+05,  1.718000e+05, -7.900000e+03,
         1.730000e+04, -7.500000e+03,  1.069000e+05,  6.740000e+04,
         1.370000e+04,  1.370000e+04,  1.668000e+05,  1.668000e+05,
         1.668000e+05,  6.752000e+05,  3.828000e+05,  4.251000e+05,
         5.090000e+05,  1.981000e+05,  2.290000e+04,  7.320000e+04,
         4.841000e+05,  7.440000e+04,  4.842000e+05,  7.510000e+04,
         2.353000e+05,  2.060000e+04, -1.035000e+05, -2.131000e+05,
         2.340000e+04, -3.510000e+04,  8.620000e+04, -8.620000e+04,
         3.710000e+04, -2.110000e+04, -5.190000e+04,  6.110000e+04,
         1.357000e+05, -3.950000e+04, -2.150000e+04,  1.230000e+04,
         1.745000e+05,  2.585000e+05,  1.342000e+05,  3.829000e+05,
        -3.400000e+04, -3.400000e+03,  3.460000e+04, -8.240000e+04,
        -7.200000e+03,  2.139000e+05,  3.780000e+04,  9.060000e+04,
        -7.500000e+03,  3.910000e+04,  2.056000e+05, -3.140000e+04,
         2.804000e+05,  3.076000e+05,  1.930000e+05,  1.930000e+05,
         1.480000e+04,  6.100000e+03,  2.986000e+05,  3.092400e+06,
         4.000000e+03,  4.000000e+03, -3.010000e+04, -3.010000e+04,
         1.162000e+05, -3.020000e+04, -2.850000e+04, -3.010000e+04,
         1.210000e+04,  1.210000e+04,  1.210000e+04,  1.210000e+04,
         1.350000e+04, -1.890000e+04, -1.890000e+04, -1.890000e+04,
        -1.132000e+05, -5.280000e+04, -4.140000e+04,  5.018000e+05,
         1.407000e+05,  1.410000e+05,  1.773000e+05,  1.773000e+05,
        -8.100000e+03,  1.470000e+05, -8.600000e+03,  4.050000e+04,
        -2.200000e+03, -1.900000e+03, -5.590000e+04,  7.260000e+04,
        -7.100000e+03, -5.690000e+04,  0.000000e+00, -3.000000e+02,
        -4.600000e+03,  4.340000e+04, -1.160000e+04, -3.100000e+03,
         0.000000e+00,  0.000000e+00, -7.000000e+02, -5.900000e+04,
        -1.040000e+04,  1.580000e+04, -1.120000e+04,  0.000000e+00,
         4.170000e+04, -2.790000e+04, -3.600000e+03,  1.531000e+05,
         1.531000e+05,  5.030000e+04, -5.200000e+03, -9.000000e+02,
         2.007000e+05,  1.475000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.700000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  4.050000e+04,  1.470000e+05,
        -7.300000e+03,  1.210000e+04,  0.000000e+00,  1.244000e+05,
         5.900000e+03,  1.668000e+05,  1.351000e+05,  2.306000e+05,
        -4.380000e+04,  1.162000e+05, -3.010000e+04,  4.000000e+03,
        -1.890000e+04, -4.140000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.210000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.243300e+06,  3.920000e+04,  1.245000e+05, -1.599000e+05,
         5.393000e+05,  5.452900e+06,  2.963800e+06,  1.218100e+06,
         3.920000e+04,  1.206700e+06,  3.920000e+04,  6.892000e+05,
         4.160000e+04, -1.783000e+05, -5.280000e+04,  6.653000e+05,
         6.600000e+03,  2.757000e+06,  1.742400e+06, -4.440000e+04,
         6.100000e+04, -3.343000e+05, -1.726000e+05,  1.326700e+06,
         8.627000e+05,  1.689800e+06, -3.279000e+05, -8.323000e+05,
        -1.259000e+05, -1.260000e+05, -1.273000e+05, -1.255000e+05,
        -1.967000e+05, -1.261000e+05,  1.143500e+06, -1.246800e+06,
        -1.098400e+06,  4.655000e+05, -1.337000e+05, -9.490000e+04,
         3.782000e+05, -4.297000e+05, -3.197000e+05, -3.197000e+05,
        -2.374000e+05, -1.560000e+05, -2.025000e+05, -1.782000e+05,
         4.160000e+04, -5.561000e+05, -1.445000e+05, -3.345000e+05,
         4.855000e+05, -2.129000e+05, -4.302000e+05,  1.074200e+06,
         1.074200e+06, -1.113000e+05, -4.670000e+04,  3.917500e+06,
        -4.900000e+04,  1.400000e+03,  4.860000e+04,  1.285000e+06,
         1.285000e+06,  1.285000e+06,  1.285000e+06,  9.200000e+04,
         4.562000e+05,  5.957000e+05, -4.400000e+03, -3.550000e+04,
         4.530000e+04, -2.390000e+05, -2.302000e+05, -3.730000e+04,
         7.710000e+04,  7.710000e+04, -5.280000e+04, -5.280000e+04,
        -5.280000e+04,  3.167100e+06,  1.821000e+05,  1.506600e+06,
         2.175700e+06,  1.902400e+06,  1.156000e+05,  2.778000e+05,
         4.544700e+06,  3.691000e+05,  4.544700e+06,  3.749000e+05,
         2.878700e+06,  1.729400e+06,  9.018000e+05, -6.534000e+05,
         5.146000e+05, -8.320000e+04,  5.069000e+05, -4.996000e+05,
         3.198000e+05, -2.759000e+05, -1.630000e+05, -3.569000e+05,
         1.445000e+06, -3.416000e+05, -2.364000e+05,  6.254000e+05,
         1.817700e+06,  2.935000e+06,  2.105400e+06,  3.764600e+06,
        -5.320000e+04,  1.327000e+05,  9.763000e+05, -2.190000e+05,
         3.270000e+04,  1.973700e+06,  1.760000e+05,  1.154500e+06,
         3.140000e+04,  1.909000e+05,  1.900700e+06, -7.260000e+04,
        -2.299000e+05, -1.476000e+05,  1.891000e+06,  1.891000e+06,
         8.510000e+04,  1.190000e+04,  3.000100e+06,  3.026740e+07,
         1.530000e+04,  1.520000e+04, -3.204000e+05, -3.206000e+05,
        -1.783000e+05, -3.206000e+05, -5.680000e+05, -3.206000e+05,
         5.290000e+04,  5.290000e+04,  5.290000e+04,  5.280000e+04,
         6.580000e+04, -7.590000e+04, -7.580000e+04, -7.580000e+04,
        -4.551000e+05, -4.141000e+05, -3.673000e+05, -6.433000e+05,
        -7.260000e+04, -7.260000e+04,  8.600000e+04,  8.600000e+04,
        -3.750000e+04, -8.710000e+04,  3.200000e+03,  4.478000e+05,
        -7.800000e+03, -1.860000e+04, -1.783000e+05,  6.892000e+05,
        -1.400000e+04, -6.008000e+05,  0.000000e+00,  1.000000e+02,
         2.500000e+04,  5.633000e+05, -4.300000e+03, -1.460000e+04,
         0.000000e+00,  0.000000e+00,  4.069000e+05, -1.871000e+05,
        -2.210000e+04,  1.873000e+05, -4.200000e+03,  0.000000e+00,
         4.742000e+05, -8.930000e+04, -7.000000e+03, -1.084000e+05,
        -1.084000e+05,  5.585000e+05, -1.140000e+04,  1.600000e+03,
         4.457000e+05, -1.206000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.600000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  4.478000e+05, -8.710000e+04,
        -2.340000e+04,  5.290000e+04,  0.000000e+00,  1.243300e+06,
         3.920000e+04, -5.280000e+04,  1.285000e+06,  5.957000e+05,
        -1.255000e+05, -1.783000e+05, -3.206000e+05,  1.520000e+04,
        -7.580000e+04, -3.673000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  5.290000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 6.711000e+05,  1.310000e+04,  5.420000e+04, -8.750000e+04,
         2.905000e+05,  2.963800e+06,  1.969900e+06,  6.590000e+05,
         1.310000e+04,  6.537000e+05,  1.310000e+04,  3.640000e+05,
         1.720000e+04, -8.340000e+04, -3.450000e+04,  3.526000e+05,
         2.600000e+03,  1.455800e+06,  9.373000e+05, -3.930000e+04,
         1.040000e+04, -1.854000e+05, -1.089000e+05,  6.944000e+05,
         4.251000e+05,  8.530000e+05, -2.255000e+05, -4.705000e+05,
        -6.570000e+04, -6.580000e+04, -6.640000e+04, -6.560000e+04,
        -9.550000e+04, -6.560000e+04,  6.746000e+05, -6.316000e+05,
        -5.613000e+05,  2.591000e+05, -6.850000e+04, -4.990000e+04,
         2.025000e+05, -2.297000e+05, -1.757000e+05, -1.757000e+05,
        -1.366000e+05, -9.800000e+04, -1.201000e+05, -9.950000e+04,
         1.560000e+04, -3.110000e+05, -1.156000e+05, -1.690000e+05,
         2.555000e+05, -1.221000e+05, -2.303000e+05,  5.634000e+05,
         5.636000e+05, -8.480000e+04, -5.450000e+04,  2.178500e+06,
        -3.210000e+04, -1.600000e+04,  1.770000e+04,  6.827000e+05,
         6.827000e+05,  6.827000e+05,  6.827000e+05,  3.100000e+04,
         2.540000e+05,  3.098000e+05, -1.800000e+04, -1.770000e+04,
         2.070000e+04, -1.368000e+05, -1.174000e+05, -3.250000e+04,
         3.130000e+04,  3.130000e+04, -3.450000e+04, -3.450000e+04,
        -3.450000e+04,  1.659400e+06,  2.870000e+04,  8.004000e+05,
         1.176200e+06,  1.003200e+06,  2.720000e+04,  1.039000e+05,
         2.404600e+06,  1.236000e+05,  2.404700e+06,  1.267000e+05,
         1.543300e+06,  9.862000e+05,  5.581000e+05, -3.158000e+05,
         2.750000e+05, -5.180000e+04,  1.692000e+05, -2.595000e+05,
         1.646000e+05, -1.610000e+05, -8.400000e+04, -1.833000e+05,
         7.928000e+05, -1.833000e+05, -1.341000e+05,  3.686000e+05,
         9.885000e+05,  1.592700e+06,  1.163400e+06,  2.021900e+06,
        -4.070000e+04,  4.790000e+04,  5.320000e+05, -1.213000e+05,
        -1.130000e+04,  1.038600e+06,  5.600000e+04,  6.147000e+05,
        -1.230000e+04,  6.470000e+04,  1.005600e+06, -4.670000e+04,
        -1.335000e+05, -9.440000e+04,  1.011600e+06,  1.011600e+06,
         2.890000e+04, -4.680000e+04,  1.586500e+06,  1.623490e+07,
        -8.000000e+02, -8.000000e+02, -1.758000e+05, -1.759000e+05,
        -9.990000e+04, -1.757000e+05, -3.039000e+05, -1.759000e+05,
         1.800000e+04,  1.800000e+04,  1.800000e+04,  1.790000e+04,
         2.410000e+04, -2.930000e+04, -2.930000e+04, -2.930000e+04,
        -1.757000e+05, -2.049000e+05, -1.904000e+05, -3.537000e+05,
        -6.360000e+04, -6.320000e+04, -8.900000e+03, -8.700000e+03,
        -1.850000e+04, -4.350000e+04,  1.900000e+03,  2.566000e+05,
        -3.200000e+03, -8.300000e+03, -8.340000e+04,  3.640000e+05,
        -5.400000e+03, -3.297000e+05,  0.000000e+00,  0.000000e+00,
         1.260000e+04,  3.116000e+05, -1.000000e+03, -5.300000e+03,
         0.000000e+00,  0.000000e+00,  2.383000e+05, -8.700000e+04,
        -8.500000e+03,  1.035000e+05, -9.000000e+02,  0.000000e+00,
         2.770000e+05, -4.160000e+04, -2.600000e+03, -5.390000e+04,
        -5.400000e+04,  3.087000e+05, -5.000000e+03,  1.200000e+03,
         2.524000e+05, -5.930000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.000000e+02, -9.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.566000e+05, -4.350000e+04,
        -1.100000e+04,  1.800000e+04,  2.000000e+02,  6.711000e+05,
         1.310000e+04, -3.450000e+04,  6.827000e+05,  3.098000e+05,
        -6.560000e+04, -9.990000e+04, -1.759000e+05, -8.000000e+02,
        -2.930000e+04, -1.904000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.800000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 2.796000e+05,  1.390000e+04,  3.270000e+04, -3.510000e+04,
         1.217000e+05,  1.218100e+06,  6.590000e+05,  5.084000e+05,
         1.390000e+04,  4.927000e+05,  1.390000e+04,  3.145000e+05,
         2.950000e+04, -4.840000e+04, -8.100000e+03,  2.902000e+05,
         3.800000e+03,  1.258100e+06,  3.945000e+05, -2.000000e+02,
         2.360000e+04, -7.200000e+04, -2.890000e+04,  3.128000e+05,
         2.202000e+05,  4.179000e+05, -4.290000e+04, -1.742000e+05,
        -2.980000e+04, -2.980000e+04, -3.010000e+04, -2.970000e+04,
        -5.120000e+04, -2.990000e+04,  2.208000e+05, -3.069000e+05,
        -2.738000e+05,  9.980000e+04, -3.240000e+04, -2.380000e+04,
         8.630000e+04, -9.770000e+04, -6.990000e+04, -6.990000e+04,
        -4.810000e+04, -2.640000e+04, -4.020000e+04, -3.790000e+04,
         1.380000e+04, -1.181000e+05, -8.700000e+03, -8.260000e+04,
         1.134000e+05, -4.320000e+04, -9.770000e+04,  2.525000e+05,
         2.524000e+05, -9.300000e+03,  5.300000e+03,  8.606000e+05,
        -7.300000e+03,  1.080000e+04,  1.610000e+04,  2.962000e+05,
         2.962000e+05,  2.962000e+05,  2.963000e+05,  3.250000e+04,
         9.800000e+04,  1.411000e+05,  8.600000e+03, -8.900000e+03,
         1.270000e+04, -4.880000e+04, -5.620000e+04, -4.000000e+02,
         2.240000e+04,  2.240000e+04, -8.100000e+03, -8.100000e+03,
        -8.100000e+03,  7.441000e+05,  8.460000e+04,  3.475000e+05,
         4.875000e+05,  4.436000e+05,  4.860000e+04,  9.210000e+04,
         1.054000e+06,  1.310000e+05,  1.054000e+06,  1.322000e+05,
         6.556000e+05,  3.565000e+05,  1.586000e+05, -1.700000e+05,
         1.177000e+05, -1.430000e+04,  1.801000e+05, -1.189000e+05,
         7.720000e+04, -5.440000e+04, -3.910000e+04, -8.630000e+04,
         3.171000e+05, -7.760000e+04, -5.380000e+04,  1.210000e+05,
         4.036000e+05,  6.552000e+05,  4.570000e+05,  8.535000e+05,
        -4.500000e+03,  3.700000e+04,  2.167000e+05, -4.720000e+04,
         2.570000e+04,  4.614000e+05,  6.470000e+04,  2.653000e+05,
         2.570000e+04,  6.730000e+04,  4.439000e+05, -1.150000e+04,
        -4.570000e+04, -2.380000e+04,  4.293000e+05,  4.293000e+05,
         2.990000e+04,  3.660000e+04,  6.964000e+05,  6.874000e+06,
         9.300000e+03,  9.300000e+03, -7.030000e+04, -7.040000e+04,
        -3.780000e+04, -7.050000e+04, -1.295000e+05, -7.040000e+04,
         1.860000e+04,  1.860000e+04,  1.860000e+04,  1.860000e+04,
         2.640000e+04, -2.480000e+04, -2.470000e+04, -2.470000e+04,
        -1.485000e+05, -1.055000e+05, -8.790000e+04, -1.405000e+05,
        -7.000000e+02, -9.000000e+02,  5.470000e+04,  5.460000e+04,
        -9.400000e+03, -2.230000e+04,  6.000000e+02,  9.730000e+04,
        -3.700000e+03, -4.700000e+03, -4.840000e+04,  3.145000e+05,
        -4.600000e+03, -1.315000e+05,  0.000000e+00,  0.000000e+00,
         5.000000e+03,  1.232000e+05, -1.800000e+03, -4.800000e+03,
         0.000000e+00,  0.000000e+00,  7.990000e+04, -5.100000e+04,
        -7.200000e+03,  4.060000e+04, -1.700000e+03,  0.000000e+00,
         9.990000e+04, -2.440000e+04, -2.300000e+03, -2.720000e+04,
        -2.720000e+04,  1.223000e+05, -3.200000e+03,  0.000000e+00,
         9.410000e+04, -3.060000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02, -3.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  9.730000e+04, -2.230000e+04,
        -6.300000e+03,  1.860000e+04, -1.000000e+02,  2.796000e+05,
         1.390000e+04, -8.100000e+03,  2.962000e+05,  1.411000e+05,
        -2.970000e+04, -3.780000e+04, -7.040000e+04,  9.300000e+03,
        -2.470000e+04, -8.790000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.860000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.300000e+04,  4.066000e+05,  3.180000e+04, -1.400000e+03,
         5.900000e+03,  3.920000e+04,  1.310000e+04,  1.390000e+04,
         8.210000e+05,  1.430000e+04,  4.120000e+05,  2.960000e+04,
         9.040000e+04, -6.830000e+04,  2.320000e+04,  3.060000e+04,
         2.090000e+04,  1.182000e+05,  2.320000e+04,  5.349000e+05,
         5.460000e+04,  9.000000e+02,  3.688000e+05,  1.091000e+05,
         1.844000e+05,  2.835000e+05,  5.663000e+05, -2.640000e+04,
        -1.850000e+04, -1.850000e+04, -1.800000e+04, -1.900000e+04,
        -6.070000e+04, -1.860000e+04, -3.185000e+05,  3.636000e+05,
        -2.766000e+05, -3.720000e+04,  1.326000e+05, -2.670000e+04,
         4.500000e+03, -2.710000e+04, -6.400000e+03, -6.500000e+03,
         1.810000e+05,  3.662000e+05,  1.880000e+04,  4.600000e+03,
         2.300000e+03,  1.725000e+05,  1.109900e+06, -7.150000e+04,
         2.900000e+04,  2.180000e+04, -2.690000e+04,  7.340000e+04,
         7.340000e+04,  4.267000e+05,  9.440000e+04, -1.320000e+04,
         2.800000e+03,  7.090000e+04,  3.770000e+04,  6.110000e+04,
         6.110000e+04,  6.110000e+04,  6.110000e+04,  4.564000e+05,
        -3.760000e+04,  5.350000e+04,  2.507000e+05, -7.900000e+03,
         1.798000e+05,  3.510000e+04, -4.520000e+04,  5.230000e+04,
         3.620000e+04,  3.620000e+04,  2.320000e+04,  2.310000e+04,
         2.320000e+04,  2.480000e+05,  1.235900e+06,  5.030000e+04,
        -4.000000e+02,  1.249000e+05,  7.173000e+05,  1.028200e+06,
         2.631000e+05,  1.646700e+06,  2.631000e+05,  1.647400e+06,
         6.440000e+04, -2.478000e+05, -3.464000e+05,  5.246000e+05,
         1.180000e+04,  1.819000e+05,  3.623400e+06, -5.790000e+04,
         4.100000e+04,  2.116000e+05, -2.700000e+04, -6.380000e+04,
        -4.730000e+04,  5.343000e+05, -1.590000e+04, -1.462000e+05,
        -1.130000e+04, -1.270000e+04, -1.115000e+05,  8.610000e+04,
         8.379000e+05,  3.960000e+04, -2.640000e+04,  3.139000e+05,
         1.297000e+05,  1.408000e+05,  6.501000e+05,  4.200000e+04,
         1.316000e+05,  7.346000e+05,  2.204000e+05,  2.970000e+04,
         2.770000e+04,  2.152000e+05,  4.180000e+04,  4.180000e+04,
         6.347000e+05,  1.103100e+06,  2.524000e+05,  7.947000e+05,
         4.120000e+04,  4.130000e+04,  1.050000e+04,  1.050000e+04,
         4.700000e+03,  1.040000e+04, -1.040000e+04,  1.050000e+04,
         4.990000e+04,  4.990000e+04,  4.990000e+04,  4.990000e+04,
         4.950000e+04, -5.300000e+04, -5.290000e+04, -5.290000e+04,
        -3.178000e+05, -8.720000e+04, -3.830000e+04, -1.020000e+04,
         1.044000e+05,  1.043000e+05,  2.540000e+05,  2.539000e+05,
        -8.700000e+03, -2.380000e+04, -2.100000e+04, -1.260000e+04,
         1.064000e+05, -2.800000e+03, -6.830000e+04,  2.960000e+04,
         3.090000e+05,  1.750000e+04,  0.000000e+00, -2.200000e+03,
        -2.620000e+04, -3.770000e+04,  1.278000e+05, -1.130000e+04,
         0.000000e+00,  0.000000e+00, -8.600000e+04,  8.290000e+04,
         4.653000e+05,  8.670000e+04,  1.234000e+05,  0.000000e+00,
        -1.300000e+04, -3.480000e+04,  1.542000e+05, -2.430000e+04,
        -2.430000e+04, -1.640000e+04,  1.550000e+05, -3.100000e+03,
        -4.060000e+04,  1.308000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  3.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.260000e+04, -2.380000e+04,
        -9.000000e+03,  4.990000e+04,  0.000000e+00,  1.300000e+04,
         4.066000e+05,  2.310000e+04,  6.110000e+04,  5.350000e+04,
        -1.890000e+04,  4.700000e+03,  1.050000e+04,  4.130000e+04,
        -5.290000e+04, -3.830000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.990000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 2.766000e+05,  1.430000e+04,  3.160000e+04, -3.450000e+04,
         1.205000e+05,  1.206700e+06,  6.537000e+05,  4.927000e+05,
         1.430000e+04,  5.431000e+05,  1.430000e+04,  3.326000e+05,
         2.690000e+04, -4.880000e+04, -7.600000e+03,  2.974000e+05,
         3.700000e+03,  1.330500e+06,  3.905000e+05,  1.000000e+03,
         2.250000e+04, -7.100000e+04, -2.750000e+04,  3.109000e+05,
         2.209000e+05,  4.177000e+05, -3.880000e+04, -1.716000e+05,
        -2.970000e+04, -2.970000e+04, -2.990000e+04, -2.960000e+04,
        -5.150000e+04, -2.980000e+04,  2.140000e+05, -3.066000e+05,
        -2.767000e+05,  9.820000e+04, -3.230000e+04, -2.450000e+04,
         8.570000e+04, -9.660000e+04, -6.900000e+04, -6.900000e+04,
        -4.700000e+04, -2.510000e+04, -3.990000e+04, -3.730000e+04,
         1.410000e+04, -1.161000e+05, -5.800000e+03, -8.260000e+04,
         1.127000e+05, -4.220000e+04, -9.670000e+04,  2.511000e+05,
         2.510000e+05, -7.300000e+03,  5.800000e+03,  8.563000e+05,
        -6.800000e+03,  1.170000e+04,  1.640000e+04,  2.938000e+05,
         2.938000e+05,  2.937000e+05,  2.938000e+05,  3.350000e+04,
         9.650000e+04,  1.403000e+05,  9.500000e+03, -8.900000e+03,
         1.280000e+04, -4.780000e+04, -5.620000e+04,  5.000000e+02,
         2.220000e+04,  2.220000e+04, -7.600000e+03, -7.600000e+03,
        -7.600000e+03,  7.394000e+05,  8.850000e+04,  3.445000e+05,
         4.820000e+05,  4.405000e+05,  5.070000e+04,  9.460000e+04,
         1.046000e+06,  1.353000e+05,  1.046000e+06,  1.365000e+05,
         6.495000e+05,  3.493000e+05,  1.523000e+05, -1.704000e+05,
         1.166000e+05, -1.370000e+04,  1.861000e+05, -1.184000e+05,
         7.700000e+04, -5.290000e+04, -3.900000e+04, -8.610000e+04,
         3.127000e+05, -7.680000e+04, -5.530000e+04,  1.173000e+05,
         3.988000e+05,  6.477000e+05,  4.503000e+05,  8.451000e+05,
        -3.400000e+03,  3.430000e+04,  2.140000e+05, -4.640000e+04,
         2.760000e+04,  4.583000e+05,  6.670000e+04,  2.630000e+05,
         2.760000e+04,  6.940000e+04,  4.425000e+05, -1.090000e+04,
        -4.460000e+04, -2.250000e+04,  4.245000e+05,  4.245000e+05,
         3.090000e+04,  4.030000e+04,  6.915000e+05,  6.807900e+06,
         9.800000e+03,  9.800000e+03, -6.930000e+04, -6.940000e+04,
        -3.710000e+04, -6.950000e+04, -1.283000e+05, -6.940000e+04,
         1.920000e+04,  1.920000e+04,  1.920000e+04,  1.920000e+04,
         3.260000e+04, -2.530000e+04, -2.530000e+04, -2.530000e+04,
        -1.518000e+05, -1.056000e+05, -8.750000e+04, -1.385000e+05,
         1.100000e+03,  9.000000e+02,  5.830000e+04,  5.820000e+04,
        -9.400000e+03, -2.250000e+04,  6.000000e+02,  9.810000e+04,
        -5.400000e+03, -4.400000e+03, -4.880000e+04,  3.326000e+05,
        -4.700000e+03, -1.297000e+05,  0.000000e+00,  0.000000e+00,
         4.300000e+03,  1.220000e+05, -1.800000e+03, -4.900000e+03,
         0.000000e+00,  0.000000e+00,  7.790000e+04, -5.150000e+04,
        -7.300000e+03,  4.000000e+04, -1.800000e+03,  0.000000e+00,
         1.005000e+05, -2.460000e+04, -2.400000e+03, -2.720000e+04,
        -2.720000e+04,  1.211000e+05, -3.300000e+03, -2.000000e+02,
         9.290000e+04, -3.060000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02, -3.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  9.810000e+04, -2.250000e+04,
        -6.400000e+03,  1.920000e+04, -1.000000e+02,  2.766000e+05,
         1.430000e+04, -7.600000e+03,  2.938000e+05,  1.403000e+05,
        -2.960000e+04, -3.710000e+04, -6.940000e+04,  9.800000e+03,
        -2.530000e+04, -8.750000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.920000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.300000e+04,  4.063000e+05,  3.180000e+04, -1.400000e+03,
         5.900000e+03,  3.920000e+04,  1.310000e+04,  1.390000e+04,
         4.120000e+05,  1.430000e+04,  5.124000e+05,  2.950000e+04,
         1.102000e+05, -6.830000e+04,  2.320000e+04,  3.060000e+04,
         2.550000e+04,  1.181000e+05,  2.320000e+04,  5.346000e+05,
         5.460000e+04,  9.000000e+02,  3.686000e+05,  1.091000e+05,
         1.844000e+05,  2.834000e+05,  5.661000e+05, -2.640000e+04,
        -1.850000e+04, -1.850000e+04, -1.800000e+04, -1.900000e+04,
        -6.070000e+04, -1.860000e+04, -3.184000e+05,  3.632000e+05,
        -2.765000e+05, -3.720000e+04,  1.325000e+05, -2.670000e+04,
         4.500000e+03, -2.710000e+04, -6.400000e+03, -6.400000e+03,
         1.809000e+05,  3.660000e+05,  1.880000e+04,  4.600000e+03,
         2.400000e+03,  1.724000e+05,  1.109300e+06, -7.150000e+04,
         2.900000e+04,  2.180000e+04, -2.690000e+04,  7.340000e+04,
         7.340000e+04,  4.265000e+05,  9.440000e+04, -1.320000e+04,
         2.800000e+03,  7.090000e+04,  3.770000e+04,  6.110000e+04,
         6.110000e+04,  6.110000e+04,  6.110000e+04,  4.562000e+05,
        -3.760000e+04,  5.350000e+04,  2.505000e+05, -7.900000e+03,
         1.797000e+05,  3.510000e+04, -4.520000e+04,  5.230000e+04,
         3.620000e+04,  3.620000e+04,  2.320000e+04,  2.310000e+04,
         2.320000e+04,  2.480000e+05,  1.235300e+06,  5.030000e+04,
        -4.000000e+02,  1.249000e+05,  7.169000e+05,  1.027600e+06,
         2.631000e+05,  1.645800e+06,  2.631000e+05,  1.646500e+06,
         6.440000e+04, -2.478000e+05, -3.464000e+05,  5.242000e+05,
         1.180000e+04,  1.818000e+05,  3.621300e+06, -5.790000e+04,
         4.100000e+04,  2.115000e+05, -2.700000e+04, -6.380000e+04,
        -4.730000e+04,  5.340000e+05, -1.590000e+04, -1.462000e+05,
        -1.130000e+04, -1.270000e+04, -1.115000e+05,  8.610000e+04,
         8.374000e+05,  3.960000e+04, -2.640000e+04,  3.137000e+05,
         1.297000e+05,  1.407000e+05,  6.497000e+05,  4.200000e+04,
         1.316000e+05,  7.342000e+05,  2.204000e+05,  2.970000e+04,
         2.770000e+04,  2.151000e+05,  4.180000e+04,  4.180000e+04,
         6.343000e+05,  1.102500e+06,  2.524000e+05,  7.946000e+05,
         4.120000e+04,  4.130000e+04,  1.050000e+04,  1.050000e+04,
         4.700000e+03,  1.040000e+04, -1.040000e+04,  1.050000e+04,
         4.990000e+04,  4.990000e+04,  4.990000e+04,  4.990000e+04,
         4.960000e+04, -5.300000e+04, -5.290000e+04, -5.290000e+04,
        -3.178000e+05, -8.720000e+04, -3.830000e+04, -1.010000e+04,
         1.044000e+05,  1.043000e+05,  2.540000e+05,  2.539000e+05,
        -8.700000e+03, -2.380000e+04, -2.100000e+04, -1.260000e+04,
         1.358000e+05, -2.800000e+03, -6.830000e+04,  2.950000e+04,
         3.088000e+05,  1.750000e+04,  0.000000e+00, -2.200000e+03,
        -2.620000e+04, -3.760000e+04,  1.277000e+05, -1.130000e+04,
         0.000000e+00,  0.000000e+00, -8.600000e+04,  8.280000e+04,
         4.650000e+05,  8.670000e+04,  1.234000e+05,  0.000000e+00,
        -1.300000e+04, -3.480000e+04,  1.541000e+05, -2.430000e+04,
        -2.430000e+04, -1.640000e+04,  1.549000e+05, -3.100000e+03,
        -4.060000e+04,  1.307000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  3.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.260000e+04, -2.380000e+04,
        -9.000000e+03,  4.990000e+04,  0.000000e+00,  1.300000e+04,
         4.063000e+05,  2.310000e+04,  6.110000e+04,  5.350000e+04,
        -1.890000e+04,  4.700000e+03,  1.050000e+04,  4.130000e+04,
        -5.290000e+04, -3.830000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.990000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.627000e+05,  2.960000e+04,  4.210000e+04, -1.670000e+04,
         7.260000e+04,  6.892000e+05,  3.640000e+05,  3.145000e+05,
         2.960000e+04,  3.326000e+05,  2.950000e+04,  4.218000e+05,
         1.063000e+05, -6.270000e+04,  1.100000e+04,  3.104000e+05,
         1.280000e+04,  1.687200e+06,  2.375000e+05,  4.090000e+04,
         5.660000e+04, -2.930000e+04,  2.440000e+04,  2.385000e+05,
         2.363000e+05,  4.000000e+05,  1.049000e+05, -4.900000e+04,
        -2.360000e+04, -2.340000e+04, -2.370000e+04, -2.360000e+04,
        -5.880000e+04, -2.350000e+04, -2.630000e+04, -2.885000e+05,
        -2.675000e+05,  3.780000e+04, -2.840000e+04, -2.250000e+04,
         5.570000e+04, -6.120000e+04, -3.270000e+04, -3.270000e+04,
        -5.700000e+03,  2.110000e+04, -7.000000e+02, -1.250000e+04,
         2.700000e+04, -3.880000e+04,  9.610000e+04, -7.930000e+04,
         8.360000e+04, -5.700000e+03, -6.090000e+04,  1.909000e+05,
         1.908000e+05,  6.060000e+04,  7.020000e+04,  4.424000e+05,
         1.100000e+04,  4.980000e+04,  3.110000e+04,  2.006000e+05,
         2.006000e+05,  2.006000e+05,  2.007000e+05,  6.860000e+04,
         3.670000e+04,  1.120000e+05,  4.560000e+04, -9.400000e+03,
         1.720000e+04, -8.300000e+03, -5.150000e+04,  3.290000e+04,
         3.570000e+04,  3.570000e+04,  1.100000e+04,  1.100000e+04,
         1.100000e+04,  5.633000e+05,  2.333000e+05,  2.352000e+05,
         2.780000e+05,  3.202000e+05,  1.223000e+05,  1.768000e+05,
         7.403000e+05,  2.785000e+05,  7.403000e+05,  2.793000e+05,
         4.105000e+05,  6.920000e+04, -9.470000e+04, -1.940000e+05,
         7.650000e+04,  1.060000e+04,  3.856000e+05, -9.610000e+04,
         6.670000e+04,  1.200000e+03, -3.330000e+04, -7.510000e+04,
         1.499000e+05, -4.760000e+04, -3.110000e+04, -1.290000e+04,
         2.163000e+05,  3.607000e+05,  1.967000e+05,  5.248000e+05,
         3.130000e+04,  5.920000e+04,  1.138000e+05, -1.790000e+04,
         9.260000e+04,  3.390000e+05,  1.406000e+05,  1.765000e+05,
         9.350000e+04,  1.420000e+05,  3.253000e+05,  1.420000e+04,
        -1.400000e+03,  2.560000e+04,  2.651000e+05,  2.651000e+05,
         6.370000e+04,  1.666000e+05,  4.960000e+05,  4.281700e+06,
         2.920000e+04,  2.920000e+04, -3.320000e+04, -3.330000e+04,
        -1.240000e+04, -3.330000e+04, -8.240000e+04, -3.330000e+04,
         3.910000e+04,  3.910000e+04,  3.910000e+04,  3.930000e+04,
         8.740000e+04, -4.520000e+04, -4.510000e+04, -4.510000e+04,
        -2.709000e+05, -1.103000e+05, -7.180000e+04, -6.480000e+04,
         6.560000e+04,  6.550000e+04,  1.826000e+05,  1.825000e+05,
        -9.900000e+03, -2.370000e+04,  0.000000e+00,  3.650000e+04,
        -1.700000e+04, -5.300000e+03, -6.270000e+04,  4.218000e+05,
        -8.600000e+03, -6.240000e+04,  0.000000e+00,  0.000000e+00,
         6.000000e+02,  5.620000e+04, -4.500000e+03, -9.400000e+03,
         0.000000e+00,  0.000000e+00, -2.200000e+03, -6.730000e+04,
        -1.330000e+04,  1.720000e+04, -4.300000e+03,  0.000000e+00,
         3.860000e+04, -3.180000e+04, -4.300000e+03, -2.750000e+04,
        -2.750000e+04,  5.620000e+04, -4.900000e+03, -1.500000e+03,
         2.810000e+04, -3.250000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  3.650000e+04, -2.370000e+04,
        -8.200000e+03,  3.910000e+04, -1.000000e+02,  1.627000e+05,
         2.960000e+04,  1.100000e+04,  2.006000e+05,  1.120000e+05,
        -2.360000e+04, -1.240000e+04, -3.330000e+04,  2.920000e+04,
        -4.510000e+04, -7.180000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  3.910000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.220000e+04,  8.930000e+04,  1.670000e+04,  0.000000e+00,
         6.000000e+03,  4.160000e+04,  1.720000e+04,  2.950000e+04,
         9.040000e+04,  2.690000e+04,  1.102000e+05,  1.063000e+05,
         5.865480e+07, -2.870000e+04,  1.050000e+04,  6.970000e+04,
         5.258200e+06,  4.250000e+05,  2.120000e+04,  1.218000e+05,
         2.870000e+04,  2.700000e+03,  8.800000e+04,  5.440000e+04,
         8.630000e+04,  1.317000e+05,  1.613000e+05,  9.400000e+03,
        -7.100000e+03, -7.100000e+03, -7.000000e+03, -7.200000e+03,
        -2.510000e+04, -7.100000e+03, -1.158000e+05,  1.840000e+04,
        -1.059000e+05, -1.190000e+04,  2.140000e+04, -9.400000e+03,
         5.900000e+03, -1.050000e+04, -5.000000e+02, -6.000000e+02,
         4.280000e+04,  8.580000e+04,  1.130000e+04,  3.300000e+03,
         8.400000e+03,  4.170000e+04,  2.587000e+05, -2.920000e+04,
         1.650000e+04,  1.040000e+04, -1.030000e+04,  4.030000e+04,
         4.030000e+04,  1.098000e+05,  4.530000e+04,  3.000000e+03,
         6.200000e+03,  3.140000e+04,  1.650000e+04,  3.330000e+04,
         3.330000e+04,  3.330000e+04,  3.330000e+04,  1.108000e+05,
        -1.210000e+04,  2.710000e+04,  6.580000e+04, -3.500000e+03,
         3.980000e+04,  1.320000e+04, -1.820000e+04,  2.330000e+04,
         1.690000e+04,  1.690000e+04,  1.050000e+04,  1.050000e+04,
         1.050000e+04,  1.256000e+05,  3.192000e+05,  3.480000e+04,
         1.450000e+04,  6.420000e+04,  1.802000e+05,  2.546000e+05,
         1.379000e+05,  4.091000e+05,  1.379000e+05,  4.093000e+05,
         4.660000e+04, -9.090000e+04, -1.362000e+05,  6.060000e+04,
         9.500000e+03,  4.280000e+04,  8.323000e+05, -2.600000e+04,
         1.930000e+04,  5.280000e+04, -1.080000e+04, -2.530000e+04,
        -1.200000e+04,  1.020000e+05, -4.500000e+03, -5.730000e+04,
         4.400000e+03,  1.190000e+04, -3.340000e+04,  5.730000e+04,
         1.788000e+05,  2.440000e+04, -2.600000e+03,  6.420000e+04,
         5.690000e+04,  7.130000e+04,  1.710000e+05,  2.610000e+04,
         5.760000e+04,  1.877000e+05,  8.470000e+04,  1.370000e+04,
         1.380000e+04,  5.720000e+04,  2.910000e+04,  2.910000e+04,
         1.446000e+05,  2.761000e+05,  1.093000e+05,  5.036000e+05,
         1.780000e+04,  1.780000e+04,  2.700000e+03,  2.700000e+03,
         3.400000e+03,  2.600000e+03, -9.200000e+03,  2.700000e+03,
         2.160000e+04,  2.160000e+04,  2.160000e+04,  2.160000e+04,
         3.800000e+04, -2.330000e+04, -2.330000e+04, -2.330000e+04,
        -1.401000e+05, -4.000000e+04, -1.870000e+04, -2.000000e+02,
         4.640000e+04,  4.640000e+04,  1.110000e+05,  1.110000e+05,
        -3.800000e+03, -9.600000e+03, -4.300000e+03, -7.500000e+03,
         2.120000e+04, -1.800000e+03, -2.870000e+04,  1.063000e+05,
         5.860000e+04,  4.500000e+03,  0.000000e+00, -4.000000e+02,
        -5.800000e+03, -9.400000e+03,  2.380000e+04, -5.000000e+03,
         0.000000e+00,  0.000000e+00, -3.330000e+04, -1.000000e+02,
         8.820000e+04,  1.600000e+04,  2.300000e+04,  0.000000e+00,
        -7.200000e+03, -1.460000e+04,  2.920000e+04, -1.030000e+04,
        -1.030000e+04, -5.000000e+03,  2.940000e+04, -1.200000e+03,
        -1.530000e+04,  1.910000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -7.500000e+03, -9.600000e+03,
        -3.800000e+03,  2.160000e+04,  0.000000e+00,  1.220000e+04,
         8.930000e+04,  1.050000e+04,  3.330000e+04,  2.710000e+04,
        -7.200000e+03,  3.400000e+03,  2.700000e+03,  1.780000e+04,
        -2.330000e+04, -1.870000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.160000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-4.740000e+04, -6.830000e+04, -5.330000e+04, -6.440000e+04,
        -5.590000e+04, -1.783000e+05, -8.340000e+04, -4.840000e+04,
        -6.830000e+04, -4.880000e+04, -6.830000e+04, -6.270000e+04,
        -2.870000e+04,  1.070700e+06, -7.250000e+04, -6.370000e+04,
        -6.700000e+03, -2.509000e+05,  3.067000e+05,  2.678000e+05,
         2.961000e+05,  2.727000e+05, -2.060000e+05, -2.073000e+05,
         4.515000e+05, -1.099000e+05,  4.287000e+05,  1.436300e+06,
         4.176000e+05,  4.176000e+05,  4.171000e+05,  4.189000e+05,
         5.842000e+05,  4.176000e+05,  3.953300e+06,  3.897200e+06,
         3.939100e+06,  4.343000e+05,  4.217000e+05,  4.307000e+05,
        -1.205000e+05, -1.216000e+05,  5.137000e+05,  5.137000e+05,
         2.723000e+05,  3.220000e+04,  2.805000e+05,  3.409000e+05,
         7.968000e+05,  7.841000e+05, -4.232000e+05,  4.298000e+05,
        -1.281000e+05, -1.370000e+05, -1.219000e+05,  6.232000e+05,
         6.232000e+05,  5.995000e+05,  6.161000e+05, -6.030000e+04,
        -7.250000e+04, -1.530000e+05, -6.170000e+04, -1.274000e+05,
        -1.274000e+05, -1.273000e+05, -1.274000e+05, -1.498000e+05,
         4.336000e+05, -1.359000e+05, -1.466000e+05,  9.800000e+03,
        -2.323000e+05, -2.467000e+05,  4.239000e+05,  8.610000e+04,
        -5.970000e+04, -5.970000e+04, -7.250000e+04, -7.250000e+04,
        -7.250000e+04, -5.437000e+05, -5.995000e+05,  5.759000e+05,
         2.593000e+05, -2.520000e+05, -2.847000e+05, -7.756000e+05,
        -5.265000e+05, -6.050000e+05, -5.265000e+05, -6.058000e+05,
         5.903000e+05,  1.894800e+06,  2.455700e+06,  1.849400e+06,
         3.541000e+05,  3.413000e+05, -8.668000e+05,  4.896000e+05,
        -7.340000e+04, -8.650000e+04,  4.284000e+05,  8.400000e+05,
         4.350000e+04,  9.200000e+03,  3.290000e+04,  6.065000e+05,
        -2.200000e+04,  3.389000e+05,  9.005000e+05, -2.226000e+05,
         2.752000e+05,  3.212000e+05,  7.896000e+05,  7.641000e+05,
         1.711000e+05, -2.717000e+05, -3.094000e+05,  2.908000e+05,
         1.727000e+05, -3.062000e+05, -2.748000e+05,  3.321000e+05,
         2.657000e+05,  2.420000e+04, -1.082000e+05, -1.082000e+05,
        -1.433000e+05, -1.327000e+05, -6.890000e+04, -1.939700e+06,
        -7.060000e+04, -7.070000e+04, -9.700000e+03, -9.700000e+03,
         3.400000e+05, -9.700000e+03, -3.555000e+05, -9.700000e+03,
        -8.150000e+04, -8.150000e+04, -8.150000e+04, -8.140000e+04,
        -8.110000e+04,  8.400000e+04,  8.390000e+04,  8.390000e+04,
         5.038000e+05,  1.515000e+05,  7.090000e+04,  1.027600e+06,
         1.773000e+05,  1.776000e+05, -6.680000e+04, -6.680000e+04,
         1.070000e+04,  8.000000e+03,  3.300000e+03,  1.110000e+04,
         3.800000e+03,  5.000000e+03,  4.998000e+05, -6.270000e+04,
         1.200000e+04, -1.620000e+04,  0.000000e+00,  0.000000e+00,
         1.390000e+04,  1.860000e+04,  7.700000e+03,  1.860000e+04,
         0.000000e+00,  0.000000e+00,  5.130000e+05,  5.035000e+05,
         1.690000e+04,  8.800000e+03,  7.500000e+03,  0.000000e+00,
         1.140000e+04,  2.487000e+05,  6.000000e+03,  7.600000e+03,
         7.600000e+03,  1.510000e+04,  4.600000e+03,  5.200000e+03,
         2.250000e+04,  1.220000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.110000e+04,  8.000000e+03,
         6.560000e+04, -8.150000e+04,  0.000000e+00, -4.740000e+04,
        -6.830000e+04, -7.250000e+04, -1.274000e+05, -1.359000e+05,
         4.188000e+05,  3.400000e+05, -9.700000e+03, -7.070000e+04,
         8.390000e+04,  7.090000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -8.150000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-9.200000e+03,  2.320000e+04,  2.190000e+04,  3.437000e+05,
         1.668000e+05, -5.280000e+04, -3.450000e+04, -8.100000e+03,
         2.320000e+04, -7.600000e+03,  2.320000e+04,  1.100000e+04,
         1.050000e+04, -7.250000e+04,  2.886400e+06,  1.210000e+04,
         2.500000e+03,  4.410000e+04, -3.330000e+04,  1.620000e+04,
         1.490000e+04,  4.964000e+05,  5.695000e+05,  6.120000e+04,
         6.760000e+04,  1.530000e+05,  9.980000e+04,  3.134100e+06,
        -3.760000e+04, -3.760000e+04, -3.750000e+04, -3.760000e+04,
        -7.310000e+04, -3.760000e+04, -4.782000e+05, -4.122000e+05,
        -4.140000e+05, -5.950000e+04, -4.310000e+04, -4.350000e+04,
         5.123000e+05,  8.382000e+05,  3.016000e+05,  3.016000e+05,
         3.352000e+05,  3.708000e+05,  3.359000e+05,  1.500000e+05,
         6.207000e+05,  6.371000e+05,  8.050000e+05,  2.689000e+05,
         3.590000e+05,  5.385000e+05,  8.360000e+05, -1.390000e+04,
        -1.390000e+04,  1.870000e+04,  1.820000e+04, -6.720000e+04,
         1.747000e+05,  2.431800e+06,  2.670000e+04,  2.600000e+04,
         2.600000e+04,  2.600000e+04,  2.600000e+04,  5.810000e+04,
        -5.930000e+04,  2.058000e+05,  2.220000e+05, -8.200000e+03,
         2.320000e+04,  3.900000e+04,  1.170000e+05,  1.063000e+05,
         2.520000e+04,  2.520000e+04,  1.944000e+05,  1.944000e+05,
         2.024000e+05,  4.852000e+05,  5.659000e+05,  3.109000e+05,
         2.835000e+05,  5.750000e+04,  1.055000e+05,  1.691000e+05,
         1.258000e+05,  2.380000e+05,  1.258000e+05,  2.381000e+05,
        -4.400000e+04, -3.071000e+05, -3.924000e+05, -2.428000e+05,
        -2.470000e+04, -8.200000e+03,  3.136000e+05, -6.070000e+04,
         2.490000e+04,  4.130000e+04, -4.580000e+04,  7.730000e+04,
        -5.310000e+04, -5.600000e+03, -5.000000e+03, -1.387000e+05,
        -3.980000e+04, -7.750000e+04, -1.627000e+05,  7.800000e+03,
         4.900000e+03,  2.800000e+03, -8.420000e+04, -5.130000e+04,
         6.640000e+04,  7.380000e+04,  1.232000e+05, -1.170000e+04,
         6.710000e+04,  1.220000e+05,  7.130000e+04, -3.400000e+03,
         3.401000e+05,  3.737000e+05,  2.100000e+03,  2.100000e+03,
         5.220000e+04,  1.502000e+05,  6.790000e+04,  1.304000e+05,
         2.660000e+04,  2.670000e+04,  1.180000e+04,  1.180000e+04,
         1.489000e+05,  1.180000e+04,  2.630000e+04,  1.180000e+04,
         3.490000e+04,  3.490000e+04,  3.490000e+04,  3.490000e+04,
         3.430000e+04, -4.280000e+04, -4.280000e+04, -4.280000e+04,
        -2.571000e+05, -5.820000e+04, -2.320000e+04,  5.950000e+05,
         2.190000e+05,  2.194000e+05,  3.241000e+05,  3.240000e+05,
        -8.200000e+03,  1.405000e+05, -9.400000e+03, -1.570000e+04,
        -3.300000e+03, -1.200000e+03, -7.250000e+04,  1.100000e+04,
        -1.170000e+04,  2.220000e+04,  0.000000e+00, -3.000000e+02,
        -1.230000e+04, -3.190000e+04, -1.470000e+04, -8.000000e+03,
         0.000000e+00,  0.000000e+00, -9.430000e+04, -7.780000e+04,
        -1.740000e+04, -1.080000e+04, -1.420000e+04,  0.000000e+00,
        -1.620000e+04, -3.650000e+04, -5.900000e+03,  1.483000e+05,
         1.483000e+05, -2.370000e+04, -6.800000e+03, -2.900000e+03,
         1.251000e+05,  1.416000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.300000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.570000e+04,  1.405000e+05,
        -9.500000e+03,  3.490000e+04,  0.000000e+00, -9.200000e+03,
         2.320000e+04,  1.944000e+05,  2.600000e+04,  2.058000e+05,
        -3.760000e+04,  1.489000e+05,  1.180000e+04,  2.670000e+04,
        -4.280000e+04, -2.320000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  3.490000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.564000e+05,  3.060000e+04,  3.970000e+04, -1.560000e+04,
         7.010000e+04,  6.653000e+05,  3.526000e+05,  2.902000e+05,
         3.060000e+04,  2.974000e+05,  3.060000e+04,  3.104000e+05,
         6.970000e+04, -6.370000e+04,  1.210000e+04,  3.360000e+05,
         1.000000e+04,  1.241600e+06,  2.288000e+05,  4.350000e+04,
         5.400000e+04, -2.710000e+04,  2.730000e+04,  2.344000e+05,
         2.378000e+05,  3.998000e+05,  1.139000e+05, -4.390000e+04,
        -2.330000e+04, -2.310000e+04, -2.340000e+04, -2.340000e+04,
        -5.950000e+04, -2.310000e+04, -4.090000e+04, -2.877000e+05,
        -2.741000e+05,  3.430000e+04, -2.820000e+04, -2.390000e+04,
         5.430000e+04, -5.890000e+04, -3.080000e+04, -3.080000e+04,
        -3.400000e+03,  2.390000e+04, -1.000000e+02, -1.120000e+04,
         2.760000e+04, -3.460000e+04,  1.024000e+05, -7.940000e+04,
         8.210000e+04, -3.500000e+03, -5.870000e+04,  1.878000e+05,
         1.877000e+05,  6.490000e+04,  7.120000e+04,  4.334000e+05,
         1.210000e+04,  5.180000e+04,  3.180000e+04,  1.954000e+05,
         1.954000e+05,  1.954000e+05,  1.954000e+05,  7.100000e+04,
         3.320000e+04,  1.102000e+05,  4.760000e+04, -9.500000e+03,
         1.750000e+04, -6.200000e+03, -5.150000e+04,  3.490000e+04,
         3.530000e+04,  3.530000e+04,  1.210000e+04,  1.210000e+04,
         1.210000e+04,  5.532000e+05,  2.421000e+05,  2.289000e+05,
         2.665000e+05,  3.134000e+05,  1.268000e+05,  1.822000e+05,
         7.233000e+05,  2.879000e+05,  7.233000e+05,  2.888000e+05,
         3.973000e+05,  5.340000e+04, -1.086000e+05, -1.947000e+05,
         7.420000e+04,  1.200000e+04,  3.992000e+05, -9.490000e+04,
         6.620000e+04,  4.400000e+03, -3.320000e+04, -7.460000e+04,
         1.404000e+05, -4.570000e+04, -3.450000e+04, -2.080000e+04,
         2.064000e+05,  3.447000e+05,  1.824000e+05,  5.069000e+05,
         3.380000e+04,  5.330000e+04,  1.080000e+05, -1.630000e+04,
         9.660000e+04,  3.324000e+05,  1.449000e+05,  1.716000e+05,
         9.760000e+04,  1.468000e+05,  3.226000e+05,  1.570000e+04,
         1.000000e+03,  2.840000e+04,  2.550000e+05,  2.550000e+05,
         6.600000e+04,  1.748000e+05,  4.856000e+05,  4.141700e+06,
         3.040000e+04,  3.040000e+04, -3.110000e+04, -3.110000e+04,
        -1.110000e+04, -3.120000e+04, -7.990000e+04, -3.110000e+04,
         4.040000e+04,  4.040000e+04,  4.040000e+04,  4.060000e+04,
         1.026000e+05, -4.630000e+04, -4.620000e+04, -4.620000e+04,
        -2.776000e+05, -1.106000e+05, -7.080000e+04, -6.070000e+04,
         6.950000e+04,  6.940000e+04,  1.903000e+05,  1.903000e+05,
        -1.000000e+04, -2.420000e+04,  0.000000e+00,  3.820000e+04,
        -2.110000e+04, -4.800000e+03, -6.370000e+04,  3.104000e+05,
        -8.800000e+03, -5.870000e+04,  0.000000e+00,  0.000000e+00,
        -9.000000e+02,  5.360000e+04, -4.600000e+03, -9.600000e+03,
         0.000000e+00,  0.000000e+00, -6.600000e+03, -6.840000e+04,
        -1.350000e+04,  1.590000e+04, -4.400000e+03,  0.000000e+00,
         3.980000e+04, -3.230000e+04, -4.400000e+03, -2.750000e+04,
        -2.750000e+04,  5.370000e+04, -4.900000e+03, -1.800000e+03,
         2.570000e+04, -3.250000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02,  1.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  3.820000e+04, -2.420000e+04,
        -8.400000e+03,  4.040000e+04, -1.000000e+02,  1.564000e+05,
         3.060000e+04,  1.210000e+04,  1.954000e+05,  1.102000e+05,
        -2.340000e+04, -1.110000e+04, -3.110000e+04,  3.040000e+04,
        -4.620000e+04, -7.080000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.040000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 2.000000e+03,  2.070000e+04,  3.600000e+03,  1.000000e+02,
         1.100000e+03,  6.600000e+03,  2.600000e+03,  3.800000e+03,
         2.090000e+04,  3.700000e+03,  2.550000e+04,  1.280000e+04,
         5.258200e+06, -6.700000e+03,  2.500000e+03,  1.000000e+04,
         9.077810e+07,  5.110000e+04,  3.800000e+03,  2.840000e+04,
         6.300000e+03,  9.000000e+02,  2.060000e+04,  1.200000e+04,
         2.010000e+04,  3.030000e+04,  3.820000e+04,  2.800000e+03,
        -1.600000e+03, -1.600000e+03, -1.600000e+03, -1.600000e+03,
        -5.900000e+03, -1.600000e+03, -2.850000e+04,  4.300000e+03,
        -2.520000e+04, -3.200000e+03,  5.000000e+03, -2.300000e+03,
         1.200000e+03, -2.100000e+03,  1.000000e+02,  1.000000e+02,
         1.010000e+04,  2.010000e+04,  2.700000e+03,  9.000000e+02,
         2.000000e+03,  1.010000e+04,  6.030000e+04, -6.700000e+03,
         3.600000e+03,  2.700000e+03, -2.100000e+03,  8.900000e+03,
         8.900000e+03,  2.580000e+04,  1.060000e+04, -4.000000e+02,
         1.600000e+03,  7.500000e+03,  3.900000e+03,  7.000000e+03,
         7.000000e+03,  7.000000e+03,  7.000000e+03,  2.580000e+04,
        -3.200000e+03,  6.000000e+03,  1.540000e+04, -8.000000e+02,
         9.200000e+03,  3.300000e+03, -4.200000e+03,  5.600000e+03,
         3.800000e+03,  3.800000e+03,  2.500000e+03,  2.500000e+03,
         2.500000e+03,  2.770000e+04,  7.460000e+04,  7.200000e+03,
         1.900000e+03,  1.390000e+04,  4.210000e+04,  5.930000e+04,
         2.970000e+04,  9.540000e+04,  2.970000e+04,  9.540000e+04,
         9.100000e+03, -2.290000e+04, -3.310000e+04,  1.390000e+04,
         1.900000e+03,  1.000000e+04,  1.933000e+05, -5.900000e+03,
         4.400000e+03,  1.260000e+04, -2.500000e+03, -5.800000e+03,
        -3.900000e+03,  2.370000e+04, -1.500000e+03, -1.420000e+04,
        -2.000000e+02,  8.000000e+02, -9.400000e+03,  1.100000e+04,
         4.150000e+04,  4.900000e+03, -1.300000e+03,  1.500000e+04,
         1.360000e+04,  1.560000e+04,  3.990000e+04,  5.400000e+03,
         1.380000e+04,  4.380000e+04,  1.920000e+04,  3.300000e+03,
         3.500000e+03,  1.350000e+04,  5.500000e+03,  5.500000e+03,
         3.360000e+04,  6.460000e+04,  2.390000e+04,  9.880000e+04,
         4.200000e+03,  4.200000e+03,  9.000000e+02,  9.000000e+02,
         9.000000e+02,  9.000000e+02, -1.800000e+03,  9.000000e+02,
         5.100000e+03,  5.100000e+03,  5.100000e+03,  5.100000e+03,
         1.060000e+04, -5.500000e+03, -5.500000e+03, -5.500000e+03,
        -3.310000e+04, -9.200000e+03, -4.200000e+03,  5.000000e+02,
         1.120000e+04,  1.120000e+04,  2.650000e+04,  2.650000e+04,
        -9.000000e+02, -2.300000e+03, -1.000000e+03, -1.500000e+03,
         4.400000e+03, -3.000000e+02, -6.700000e+03,  1.280000e+04,
         1.350000e+04,  1.500000e+03,  0.000000e+00, -1.000000e+02,
        -1.500000e+03, -2.500000e+03,  5.500000e+03, -1.200000e+03,
         0.000000e+00,  0.000000e+00, -8.200000e+03, -1.000000e+02,
         2.030000e+04,  3.500000e+03,  5.300000e+03,  0.000000e+00,
        -1.500000e+03, -3.400000e+03,  6.700000e+03, -2.400000e+03,
        -2.400000e+03, -1.500000e+03,  6.800000e+03, -3.000000e+02,
        -3.800000e+03,  4.400000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.500000e+03, -2.300000e+03,
        -9.000000e+02,  5.100000e+03,  0.000000e+00,  2.000000e+03,
         2.070000e+04,  2.500000e+03,  7.000000e+03,  6.000000e+03,
        -1.600000e+03,  9.000000e+02,  9.000000e+02,  4.200000e+03,
        -5.500000e+03, -4.200000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  5.100000e+03,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 6.507000e+05,  1.182000e+05,  1.684000e+05, -6.680000e+04,
         2.904000e+05,  2.757000e+06,  1.455800e+06,  1.258100e+06,
         1.182000e+05,  1.330500e+06,  1.181000e+05,  1.687200e+06,
         4.250000e+05, -2.509000e+05,  4.410000e+04,  1.241600e+06,
         5.110000e+04,  8.197310e+07,  9.501000e+05,  1.637000e+05,
         2.263000e+05, -1.170000e+05,  9.740000e+04,  9.541000e+05,
         9.454000e+05,  1.600000e+06,  4.197000e+05, -1.961000e+05,
        -9.430000e+04, -9.360000e+04, -9.490000e+04, -9.430000e+04,
        -2.354000e+05, -9.400000e+04, -1.051000e+05, -1.154000e+06,
        -1.070100e+06,  1.511000e+05, -1.135000e+05, -9.020000e+04,
         2.226000e+05, -2.450000e+05, -1.308000e+05, -1.308000e+05,
        -2.290000e+04,  8.460000e+04, -2.700000e+03, -5.020000e+04,
         1.081000e+05, -1.554000e+05,  3.846000e+05, -3.172000e+05,
         3.343000e+05, -2.280000e+04, -2.435000e+05,  7.634000e+05,
         7.631000e+05,  2.425000e+05,  2.809000e+05,  1.769700e+06,
         4.390000e+04,  1.992000e+05,  1.246000e+05,  8.024000e+05,
         8.024000e+05,  8.024000e+05,  8.027000e+05,  2.746000e+05,
         1.466000e+05,  4.480000e+05,  1.826000e+05, -3.750000e+04,
         6.900000e+04, -3.310000e+04, -2.061000e+05,  1.315000e+05,
         1.428000e+05,  1.428000e+05,  4.410000e+04,  4.410000e+04,
         4.410000e+04,  2.253300e+06,  9.331000e+05,  9.410000e+05,
         1.112000e+06,  1.280700e+06,  4.892000e+05,  7.071000e+05,
         2.961300e+06,  1.113900e+06,  2.961300e+06,  1.117100e+06,
         1.641800e+06,  2.766000e+05, -3.786000e+05, -7.761000e+05,
         3.059000e+05,  4.220000e+04,  1.542200e+06, -3.842000e+05,
         2.667000e+05,  4.600000e+03, -1.334000e+05, -3.003000e+05,
         5.994000e+05, -1.902000e+05, -1.243000e+05, -5.160000e+04,
         8.652000e+05,  1.442900e+06,  7.866000e+05,  2.099100e+06,
         1.254000e+05,  2.366000e+05,  4.553000e+05, -7.170000e+04,
         3.703000e+05,  1.356000e+06,  5.623000e+05,  7.059000e+05,
         3.739000e+05,  5.680000e+05,  1.301200e+06,  5.700000e+04,
        -5.600000e+03,  1.024000e+05,  1.060500e+06,  1.060400e+06,
         2.549000e+05,  6.665000e+05,  1.984100e+06,  1.712690e+07,
         1.169000e+05,  1.170000e+05, -1.329000e+05, -1.330000e+05,
        -4.970000e+04, -1.333000e+05, -3.296000e+05, -1.330000e+05,
         1.564000e+05,  1.564000e+05,  1.564000e+05,  1.572000e+05,
         3.496000e+05, -1.806000e+05, -1.805000e+05, -1.805000e+05,
        -1.083600e+06, -4.413000e+05, -2.871000e+05, -2.594000e+05,
         2.624000e+05,  2.619000e+05,  7.303000e+05,  7.300000e+05,
        -3.960000e+04, -9.470000e+04, -1.000000e+02,  1.460000e+05,
        -6.790000e+04, -2.130000e+04, -2.509000e+05,  1.687200e+06,
        -3.450000e+04, -2.495000e+05,  0.000000e+00,  1.000000e+02,
         2.400000e+03,  2.246000e+05, -1.790000e+04, -3.750000e+04,
         0.000000e+00,  0.000000e+00, -8.800000e+03, -2.692000e+05,
        -5.320000e+04,  6.880000e+04, -1.730000e+04,  0.000000e+00,
         1.542000e+05, -1.273000e+05, -1.740000e+04, -1.101000e+05,
        -1.101000e+05,  2.249000e+05, -1.950000e+04, -5.900000e+03,
         1.124000e+05, -1.300000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -3.000000e+02,  2.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.460000e+05, -9.470000e+04,
        -3.290000e+04,  1.564000e+05, -3.000000e+02,  6.507000e+05,
         1.182000e+05,  4.410000e+04,  8.024000e+05,  4.480000e+05,
        -9.440000e+04, -4.970000e+04, -1.330000e+05,  1.170000e+05,
        -1.805000e+05, -2.871000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.564000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 4.026000e+05,  2.320000e+04,  5.890000e+04, -1.089000e+05,
         1.460000e+05,  1.742400e+06,  9.373000e+05,  3.945000e+05,
         2.320000e+04,  3.905000e+05,  2.320000e+04,  2.375000e+05,
         2.120000e+04,  3.067000e+05, -3.330000e+04,  2.288000e+05,
         3.800000e+03,  9.501000e+05,  9.970000e+05,  4.040000e+05,
         4.795000e+05,  2.019000e+05, -1.154000e+05,  5.073000e+05,
         1.171800e+06,  1.086300e+06,  7.813000e+05,  1.352000e+06,
         3.470000e+05,  3.473000e+05,  3.477000e+05,  3.483000e+05,
         4.041000e+05,  3.471000e+05,  3.815500e+06,  3.030900e+06,
         3.125400e+06,  5.309000e+05,  3.375000e+05,  3.584000e+05,
         3.630000e+04, -2.945000e+05,  4.297000e+05,  4.297000e+05,
         2.696000e+05,  1.105000e+05,  2.943000e+05,  3.116000e+05,
         8.900000e+05,  6.947000e+05, -1.057000e+05,  1.955000e+05,
         1.129000e+05, -1.424000e+05, -2.937000e+05,  1.189400e+06,
         1.189100e+06,  8.004000e+05,  8.444000e+05,  1.203600e+06,
        -3.250000e+04,  9.100000e+03,  3.390000e+04,  4.550000e+05,
         4.550000e+05,  4.549000e+05,  4.550000e+05,  6.390000e+04,
         5.375000e+05,  1.907000e+05, -1.200000e+03, -1.520000e+04,
        -1.749000e+05, -2.587000e+05,  2.716000e+05,  1.957000e+05,
         4.360000e+04,  4.360000e+04, -3.330000e+04, -3.330000e+04,
        -3.330000e+04,  1.106400e+06,  1.337000e+05,  1.269600e+06,
         1.019600e+06,  6.941000e+05,  1.088000e+05, -2.126000e+05,
         1.633600e+06,  2.648000e+05,  1.633600e+06,  2.640000e+05,
         1.788800e+06,  2.045100e+06,  2.126400e+06,  1.263800e+06,
         5.745000e+05,  3.794000e+05,  3.353000e+05,  2.052000e+05,
         1.276000e+05, -6.910000e+04,  3.330000e+05,  6.182000e+05,
         4.560000e+05, -1.277000e+05, -6.150000e+04,  5.340000e+05,
         5.521000e+05,  1.346700e+06,  1.428000e+06,  1.265400e+06,
         3.700000e+05,  4.841000e+05,  1.108300e+06,  7.176000e+05,
         4.632000e+05,  7.245000e+05,  1.440000e+05,  8.031000e+05,
         4.695000e+05,  1.362000e+05,  6.696000e+05,  3.795000e+05,
         2.768000e+05,  1.167000e+05,  6.298000e+05,  6.298000e+05,
         5.460000e+04,  3.997000e+05,  1.376300e+06,  1.015420e+07,
         2.690000e+04,  2.700000e+04, -1.011000e+05, -1.012000e+05,
         3.115000e+05, -1.014000e+05, -5.904000e+05, -1.012000e+05,
         4.070000e+04,  4.070000e+04,  4.070000e+04,  4.070000e+04,
         4.580000e+04, -6.650000e+04, -6.650000e+04, -6.650000e+04,
        -3.991000e+05, -1.958000e+05, -1.486000e+05,  8.592000e+05,
         3.926000e+05,  3.923000e+05,  5.138000e+05,  5.136000e+05,
        -1.400000e+04, -6.580000e+04,  2.600000e+03,  1.284000e+05,
        -6.700000e+03, -8.300000e+03,  3.067000e+05,  2.375000e+05,
        -1.560000e+04, -1.751000e+05,  0.000000e+00,  1.000000e+02,
         1.590000e+04,  1.714000e+05, -5.600000e+03, -1.020000e+04,
         0.000000e+00,  0.000000e+00,  4.870000e+05,  2.985000e+05,
        -2.410000e+04,  5.350000e+04, -5.400000e+03,  0.000000e+00,
         1.319000e+05,  1.507000e+05, -7.900000e+03, -7.550000e+04,
        -7.550000e+04,  1.687000e+05, -9.000000e+03, -6.000000e+02,
         9.030000e+04, -8.500000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -3.000000e+02,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.284000e+05, -6.580000e+04,
         4.030000e+04,  4.070000e+04, -3.000000e+02,  4.026000e+05,
         2.320000e+04, -3.330000e+04,  4.550000e+05,  1.907000e+05,
         3.482000e+05,  3.115000e+05, -1.012000e+05,  2.700000e+04,
        -6.650000e+04, -1.486000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.070000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-2.600000e+03,  5.350000e+05,  5.670000e+04, -5.540000e+04,
        -2.880000e+04, -4.440000e+04, -3.930000e+04, -2.000000e+02,
         5.349000e+05,  1.000000e+03,  5.346000e+05,  4.090000e+04,
         1.218000e+05,  2.678000e+05,  1.620000e+04,  4.350000e+04,
         2.840000e+04,  1.637000e+05,  4.040000e+05,  1.459000e+06,
         4.992000e+05,  3.113000e+05,  4.736000e+05,  1.814000e+05,
         1.121900e+06,  8.967000e+05,  1.702300e+06,  1.558300e+06,
         3.609000e+05,  3.616000e+05,  3.629000e+05,  3.610000e+05,
         3.814000e+05,  3.614000e+05,  2.918700e+06,  4.328900e+06,
         3.045700e+06,  3.138000e+05,  6.635000e+05,  3.455000e+05,
        -8.420000e+04, -1.819000e+05,  5.219000e+05,  5.221000e+05,
         5.863000e+05,  6.617000e+05,  3.739000e+05,  3.746000e+05,
         8.636000e+05,  1.214100e+06,  1.535500e+06,  2.055000e+05,
        -1.230000e+04, -3.930000e+04, -1.813000e+05,  9.094000e+05,
         9.092000e+05,  1.578700e+06,  9.729000e+05, -1.085000e+05,
        -2.540000e+04,  1.039000e+05,  6.990000e+04,  8.940000e+04,
         8.940000e+04,  8.940000e+04,  8.940000e+04,  6.282000e+05,
         3.143000e+05,  5.930000e+04,  3.284000e+05, -1.750000e+04,
         4.180000e+04, -1.283000e+05,  2.821000e+05,  2.786000e+05,
         6.660000e+04,  6.660000e+04,  1.620000e+04,  1.630000e+04,
         1.620000e+04,  3.452000e+05,  1.692100e+06,  7.920000e+05,
         2.786000e+05,  1.915000e+05,  9.991000e+05,  1.275600e+06,
         4.054000e+05,  2.291300e+06,  4.054000e+05,  2.291800e+06,
         8.622000e+05,  1.071700e+06,  1.296500e+06,  2.205800e+06,
         4.058000e+05,  7.563000e+05,  5.076000e+06,  2.944000e+05,
         7.090000e+04,  4.228000e+05,  3.430000e+05,  6.425000e+05,
        -1.195000e+05,  7.224000e+05, -2.420000e+04,  1.039000e+05,
        -6.690000e+04,  3.082000e+05,  5.318000e+05,  8.460000e+04,
         2.061000e+06,  4.669000e+05,  7.184000e+05,  1.419600e+06,
         6.326000e+05,  2.265000e+05,  1.275600e+06,  4.504000e+05,
         6.423000e+05,  1.035400e+06,  1.109000e+05,  4.436000e+05,
         3.891000e+05,  4.534000e+05,  3.770000e+04,  3.770000e+04,
         8.488000e+05,  2.126800e+06,  3.740000e+05,  8.543000e+05,
         7.500000e+04,  7.510000e+04,  2.650000e+04,  2.650000e+04,
         3.738000e+05,  2.630000e+04, -4.017000e+05,  2.650000e+04,
         9.320000e+04,  9.320000e+04,  9.320000e+04,  9.320000e+04,
         9.230000e+04, -1.049000e+05, -1.048000e+05, -1.048000e+05,
        -6.290000e+05, -1.585000e+05, -6.600000e+04,  1.050500e+06,
         5.603000e+05,  5.603000e+05,  8.397000e+05,  8.395000e+05,
        -1.830000e+04, -6.920000e+04, -4.040000e+04, -3.290000e+04,
         1.298000e+05, -4.800000e+03,  2.678000e+05,  4.090000e+04,
         3.831000e+05,  4.730000e+04,  0.000000e+00, -1.800000e+03,
        -5.000000e+04, -8.320000e+04,  2.582000e+05, -2.100000e+04,
         0.000000e+00,  0.000000e+00,  2.216000e+05,  5.722000e+05,
         6.561000e+05,  1.251000e+05,  2.495000e+05,  0.000000e+00,
        -3.420000e+04,  1.305000e+05,  1.911000e+05, -7.100000e+04,
        -7.100000e+04, -4.200000e+04,  2.662000e+05, -5.900000e+03,
        -1.128000e+05,  1.950000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -2.000000e+02,  9.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.290000e+04, -6.920000e+04,
         3.510000e+04,  9.320000e+04, -2.000000e+02, -2.600000e+03,
         5.350000e+05,  1.630000e+04,  8.940000e+04,  5.930000e+04,
         3.610000e+05,  3.738000e+05,  2.650000e+04,  7.510000e+04,
        -1.048000e+05, -6.600000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  9.320000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 2.530000e+04,  5.460000e+04,  1.436800e+06, -4.730000e+04,
        -1.110000e+04,  6.100000e+04,  1.040000e+04,  2.360000e+04,
         5.460000e+04,  2.250000e+04,  5.460000e+04,  5.660000e+04,
         2.870000e+04,  2.961000e+05,  1.490000e+04,  5.400000e+04,
         6.300000e+03,  2.263000e+05,  4.795000e+05,  4.992000e+05,
         8.738100e+06,  3.347000e+05,  2.520000e+04,  2.066000e+05,
         1.109000e+06,  8.632000e+05,  1.125500e+06,  1.751200e+06,
         3.730000e+05,  3.734000e+05,  3.743000e+05,  3.741000e+05,
         4.091000e+05,  3.733000e+05,  3.171800e+06,  3.205900e+06,
         1.418320e+07,  3.510000e+05,  3.620000e+05,  3.103800e+06,
        -5.900000e+04, -1.623000e+05,  5.462000e+05,  5.463000e+05,
         3.895000e+05,  2.341000e+05,  3.135700e+06,  3.857000e+05,
         9.224000e+05,  9.315000e+05,  1.477000e+05,  2.442000e+05,
         4.200000e+03, -3.250000e+04, -1.668000e+05,  9.423000e+05,
         9.421000e+05,  9.599000e+05,  6.448000e+06, -6.970000e+04,
        -5.540000e+04,  9.190000e+04,  5.950000e+04,  1.160000e+05,
         1.160000e+05,  1.160000e+05,  1.160000e+05,  1.319000e+05,
         3.595000e+05,  6.790000e+04,  8.000000e+04, -1.270000e+04,
        -1.692000e+05, -1.489000e+05,  3.088000e+05,  2.695000e+05,
         6.827000e+05,  6.827000e+05,  1.490000e+04,  1.480000e+04,
         1.490000e+04,  3.897000e+05,  4.349000e+05,  8.754000e+05,
         3.545000e+05,  2.288000e+05,  2.524000e+05, -5.930000e+04,
         4.850000e+05,  5.408000e+05,  4.850000e+05,  5.387000e+05,
         9.648000e+05,  1.258800e+06,  1.500900e+06,  1.291400e+06,
         4.317000e+05,  4.409000e+05,  7.343000e+05,  3.069000e+05,
         7.070000e+04,  7.820000e+04,  3.615000e+05,  6.817000e+05,
        -4.880000e+04, -2.280000e+04,  8.209800e+06,  1.876000e+05,
        -3.210000e+04,  4.159000e+05,  6.583000e+05,  1.735000e+05,
         4.612000e+05,  1.418020e+07,  7.861000e+05,  8.042000e+05,
         5.974000e+05,  2.540000e+05,  2.870000e+05,  4.912000e+05,
         6.059000e+05,  2.749000e+05,  2.194000e+05,  4.403000e+05,
         3.986000e+05,  2.418000e+05,  8.220000e+04,  8.220000e+04,
         1.202000e+05,  6.764000e+05,  6.311000e+05,  1.484100e+06,
         6.590000e+04,  6.600000e+04,  1.080000e+04,  1.080000e+04,
         3.855000e+05,  1.070000e+04, -4.291000e+05,  1.080000e+04,
         7.730000e+04,  7.730000e+04,  7.730000e+04,  7.730000e+04,
         7.910000e+04, -9.950000e+04, -9.950000e+04, -9.950000e+04,
        -5.971000e+05, -1.587000e+05, -7.410000e+04,  1.089600e+06,
         5.399000e+05,  5.398000e+05,  7.713000e+05,  7.711000e+05,
        -1.140000e+04, -5.650000e+04, -6.900000e+04, -4.100000e+04,
        -7.200000e+03,  2.891000e+05,  2.961000e+05,  5.660000e+04,
        -1.960000e+04,  3.270000e+04,  0.000000e+00,  1.000000e+02,
         2.162000e+06, -9.740000e+04, -7.930000e+04, -1.790000e+04,
         0.000000e+00,  0.000000e+00,  2.724000e+05,  2.868000e+05,
        -2.960000e+04, -1.430000e+04, -7.660000e+04,  0.000000e+00,
        -4.030000e+04,  1.448000e+05, -9.900000e+03, -6.700000e+04,
        -6.700000e+04, -3.360000e+04, -1.510000e+04,  3.044000e+05,
        -1.019000e+05, -8.230000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -2.000000e+02, -5.100000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -4.100000e+04, -5.650000e+04,
         3.890000e+04,  7.730000e+04, -2.000000e+02,  2.530000e+04,
         5.460000e+04,  1.480000e+04,  1.160000e+05,  6.790000e+04,
         3.740000e+05,  3.855000e+05,  1.080000e+04,  6.600000e+04,
        -9.950000e+04, -7.410000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  7.730000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-7.440000e+04,  9.000000e+02,  1.200000e+04,  9.416000e+05,
         4.325000e+05, -3.343000e+05, -1.854000e+05, -7.200000e+04,
         9.000000e+02, -7.100000e+04,  9.000000e+02, -2.930000e+04,
         2.700000e+03,  2.727000e+05,  4.964000e+05, -2.710000e+04,
         9.000000e+02, -1.170000e+05,  2.019000e+05,  3.113000e+05,
         3.347000e+05,  1.879300e+06,  1.465900e+06, -2.190000e+04,
         6.390000e+05,  3.409000e+05,  7.114000e+05,  1.146780e+07,
         2.959000e+05,  2.964000e+05,  2.960000e+05,  2.955000e+05,
         3.524000e+05,  2.963000e+05,  2.441500e+06,  2.590200e+06,
         2.618500e+06,  2.483000e+05,  2.848000e+05,  2.926000e+05,
         1.376700e+06,  2.332100e+06,  1.517600e+06,  1.517400e+06,
         1.348500e+06,  1.154300e+06,  1.364400e+06,  8.391000e+05,
         2.838600e+06,  2.875100e+06,  2.030500e+06,  1.321800e+06,
         9.258000e+05,  1.439000e+06,  2.329400e+06,  5.670000e+05,
         5.669000e+05,  6.402000e+05,  6.555000e+05, -2.593000e+05,
         4.937000e+05,  5.476000e+05,  1.830000e+04, -4.820000e+04,
        -4.820000e+04, -4.820000e+04, -4.820000e+04,  2.390000e+04,
         2.505000e+05,  4.763000e+05,  5.130000e+05, -1.770000e+04,
        -1.737000e+05, -1.310000e+05,  8.081000e+05,  4.577000e+05,
         1.550000e+04,  1.550000e+04,  4.964000e+05,  4.963000e+05,
         4.964000e+05,  9.056000e+05,  1.084800e+06,  1.532500e+06,
         1.139600e+06, -8.370000e+04,  2.200000e+04, -2.866000e+05,
        -1.449000e+05,  1.073000e+05, -1.449000e+05,  1.065000e+05,
         4.478000e+05,  9.525000e+05,  1.250900e+06,  1.097100e+06,
         2.724000e+05,  3.089000e+05,  7.330000e+04,  3.002000e+05,
         2.600000e+03,  3.930000e+04,  2.778000e+05,  1.112900e+06,
        -1.172000e+05, -6.900000e+03,  1.560000e+04,  1.805000e+05,
        -1.465000e+05,  1.032000e+05,  4.027000e+05, -1.963000e+05,
         2.856000e+05,  3.245000e+05,  5.218000e+05,  5.948000e+05,
         3.601000e+05, -4.830000e+04,  6.120000e+04,  2.488000e+05,
         3.649000e+05,  5.870000e+04, -6.620000e+04,  3.123000e+05,
         1.372500e+06,  1.203600e+06, -1.012000e+05, -1.011000e+05,
         1.270000e+04,  3.135000e+05,  1.311000e+05, -1.531400e+06,
         4.600000e+03,  4.600000e+03,  2.600000e+04,  2.600000e+04,
         8.438000e+05,  2.590000e+04, -2.673000e+05,  2.600000e+04,
         2.300000e+04,  2.300000e+04,  2.300000e+04,  2.300000e+04,
         2.210000e+04, -3.570000e+04, -3.570000e+04, -3.570000e+04,
        -2.144000e+05, -2.370000e+04,  1.100000e+03,  2.975600e+06,
         8.882000e+05,  8.864000e+05,  9.552000e+05,  9.552000e+05,
        -1.840000e+04,  4.214000e+05, -2.770000e+04, -3.530000e+04,
        -6.200000e+03,  1.300000e+03,  2.727000e+05, -2.930000e+04,
        -2.410000e+04,  5.040000e+04,  0.000000e+00, -1.000000e+02,
        -2.430000e+04, -7.960000e+04, -3.770000e+04, -5.500000e+03,
         0.000000e+00,  0.000000e+00,  2.267000e+05,  2.627000e+05,
        -3.440000e+04, -2.330000e+04, -3.640000e+04,  0.000000e+00,
        -3.650000e+04,  1.345000e+05, -1.200000e+04,  4.446000e+05,
         4.445000e+05, -5.590000e+04, -1.420000e+04, -3.600000e+03,
         3.905000e+05,  4.305000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02, -4.000000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.530000e+04,  4.214000e+05,
         3.580000e+04,  2.300000e+04, -1.000000e+02, -7.440000e+04,
         9.000000e+02,  4.963000e+05, -4.820000e+04,  4.763000e+05,
         2.955000e+05,  8.438000e+05,  2.600000e+04,  4.600000e+03,
        -3.570000e+04,  1.100000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.300000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-3.190000e+04,  3.689000e+05,  5.750000e+04,  1.017600e+06,
         4.915000e+05, -1.726000e+05, -1.089000e+05, -2.890000e+04,
         3.688000e+05, -2.750000e+04,  3.686000e+05,  2.440000e+04,
         8.800000e+04, -2.060000e+05,  5.695000e+05,  2.730000e+04,
         2.060000e+04,  9.740000e+04, -1.154000e+05,  4.736000e+05,
         2.520000e+04,  1.465900e+06,  2.150000e+06,  1.520000e+05,
         1.365000e+05,  3.721000e+05,  5.343000e+05,  9.264300e+06,
        -1.153000e+05, -1.155000e+05, -1.146000e+05, -1.151000e+05,
        -2.120000e+05, -1.155000e+05, -1.417000e+06, -6.316000e+05,
        -1.229600e+06, -1.763000e+05,  2.020000e+04, -1.294000e+05,
         1.514300e+06,  2.487600e+06,  8.848000e+05,  8.851000e+05,
         1.182300e+06,  1.509300e+06,  9.856000e+05,  4.359000e+05,
         1.821600e+06,  2.018000e+06,  3.504300e+06,  8.101000e+05,
         1.054700e+06,  1.588300e+06,  2.480900e+06, -7.800000e+04,
        -7.800000e+04,  3.158000e+05,  1.570000e+04, -2.001000e+05,
         4.925000e+05,  6.910000e+05,  6.970000e+04,  6.000000e+04,
         6.000000e+04,  6.000000e+04,  6.000000e+04,  4.597000e+05,
        -1.753000e+05,  5.949000e+05,  7.953000e+05, -2.220000e+04,
         2.610000e+05,  1.111000e+05,  3.509000e+05,  2.971000e+05,
         6.570000e+04,  6.570000e+04,  5.695000e+05,  5.696000e+05,
         5.695000e+05,  1.370200e+06,  2.371100e+06,  8.892000e+05,
         8.289000e+05,  1.364000e+05,  7.360000e+05,  1.327000e+06,
         3.008000e+05,  1.699700e+06,  3.008000e+05,  1.699900e+06,
        -1.667000e+05, -8.839000e+05, -1.119400e+06, -8.710000e+04,
        -8.560000e+04,  1.109000e+05,  3.798900e+06, -1.733000e+05,
         6.330000e+04,  2.597000e+05, -1.376000e+05,  2.290000e+05,
        -1.476000e+05,  4.483000e+05, -7.100000e+03, -3.842000e+05,
        -1.171000e+05, -2.384000e+05, -4.738000e+05, -3.000000e+03,
         7.436000e+05, -4.200000e+03, -2.620000e+05,  1.308000e+05,
         1.557000e+05,  1.808000e+05,  7.702000e+05, -5.550000e+04,
         1.580000e+05,  7.804000e+05,  1.595000e+05, -2.590000e+04,
         9.948000e+05,  1.292000e+06, -6.600000e+03, -6.500000e+03,
         5.986000e+05,  1.139000e+06,  1.570000e+05,  1.501000e+05,
         6.860000e+04,  6.860000e+04,  3.270000e+04,  3.280000e+04,
         4.320000e+05,  3.270000e+04,  9.010000e+04,  3.280000e+04,
         9.090000e+04,  9.090000e+04,  9.090000e+04,  9.080000e+04,
         8.930000e+04, -1.132000e+05, -1.131000e+05, -1.132000e+05,
        -6.792000e+05, -1.500000e+05, -5.860000e+04,  1.741500e+06,
         6.149000e+05,  6.163000e+05,  8.888000e+05,  8.887000e+05,
        -2.220000e+04,  4.219000e+05, -4.760000e+04, -4.370000e+04,
         8.200000e+04, -2.700000e+03, -2.060000e+05,  2.440000e+04,
         3.459000e+05,  6.190000e+04,  0.000000e+00,  1.620000e+04,
        -5.160000e+04, -1.106000e+05,  8.580000e+04, -2.100000e+04,
         0.000000e+00,  0.000000e+00, -2.666000e+05, -7.020000e+04,
         4.931000e+05,  9.450000e+04,  8.290000e+04,  0.000000e+00,
        -4.510000e+04, -1.037000e+05,  1.726000e+05,  4.451000e+05,
         4.450000e+05, -6.690000e+04,  1.400000e+05, -7.900000e+03,
         3.796000e+05,  5.852000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -4.000000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -4.370000e+04,  4.219000e+05,
        -2.700000e+04,  9.090000e+04,  0.000000e+00, -3.190000e+04,
         3.689000e+05,  5.696000e+05,  6.000000e+04,  5.949000e+05,
        -1.151000e+05,  4.320000e+05,  3.280000e+04,  6.860000e+04,
        -1.132000e+05, -5.860000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  9.090000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 3.162000e+05,  1.091000e+05,  1.152000e+05, -2.360000e+04,
         1.457000e+05,  1.326700e+06,  6.944000e+05,  3.128000e+05,
         1.091000e+05,  3.109000e+05,  1.091000e+05,  2.385000e+05,
         5.440000e+04, -2.073000e+05,  6.120000e+04,  2.344000e+05,
         1.200000e+04,  9.541000e+05,  5.073000e+05,  1.814000e+05,
         2.066000e+05, -2.190000e+04,  1.520000e+05,  1.336560e+07,
         7.345000e+05,  1.180900e+06,  5.138000e+05,  6.240000e+04,
        -6.230000e+04, -6.220000e+04, -6.270000e+04, -6.000000e+04,
        -1.857000e+05, -6.240000e+04, -4.087000e+05, -8.409000e+05,
        -8.096000e+05,  2.490000e+04, -7.910000e+04, -7.530000e+04,
         1.215000e+05, -1.315000e+05, -4.180000e+04, -4.180000e+04,
         4.540000e+04,  1.324000e+05,  5.420000e+04, -4.000000e+02,
         1.073000e+05,  1.200000e+03,  4.371000e+05, -2.289000e+05,
         2.073000e+05,  3.760000e+04, -1.298000e+05,  4.939000e+05,
         4.937000e+05,  2.777000e+05,  2.934000e+05,  8.194000e+05,
         6.000000e+04,  2.071000e+05,  1.118000e+05,  4.769000e+05,
         4.769000e+05,  4.769000e+05,  4.769000e+05,  2.541000e+05,
         2.980000e+04,  2.940000e+05,  1.875000e+05, -2.460000e+04,
         6.330000e+04,  4.792500e+06, -1.454000e+05,  1.455000e+05,
         1.149000e+05,  1.149000e+05,  6.120000e+04,  6.120000e+04,
         6.120000e+04,  1.451400e+06,  9.009000e+05,  5.667000e+05,
         5.163000e+05,  8.133000e+05,  4.784000e+05,  6.582000e+05,
         1.815200e+06,  1.035400e+06,  1.815200e+06,  1.034100e+06,
         9.138000e+05, -1.905000e+05, -6.384000e+05, -6.333000e+05,
         1.760000e+05,  7.020000e+04,  1.431400e+06, -2.575000e+05,
         1.880000e+05,  7.930000e+04, -8.640000e+04, -2.075000e+05,
         2.266000e+05, -1.032000e+05, -7.410000e+04, -2.187000e+05,
         3.541000e+05,  6.682000e+05,  2.244000e+05,  1.112100e+06,
         1.380000e+05,  1.671000e+05,  2.070000e+05, -5.100000e+03,
         3.680000e+05,  8.624000e+05,  5.504000e+05,  4.160000e+05,
         3.719000e+05,  5.258000e+05,  8.152000e+05,  7.760000e+04,
         6.130000e+04,  1.485000e+05,  5.478000e+05,  5.478000e+05,
         2.358000e+05,  6.769000e+05,  1.207100e+06,  9.156400e+06,
         1.210000e+05,  1.212000e+05, -5.020000e+04, -5.030000e+04,
         1.000000e+02, -5.050000e+04, -1.833000e+05, -5.030000e+04,
         1.449000e+05,  1.449000e+05,  1.449000e+05,  1.450000e+05,
         1.477000e+05, -1.757000e+05, -1.756000e+05, -1.756000e+05,
        -1.054200e+06, -3.580000e+05, -2.043000e+05, -8.330000e+04,
         2.895000e+05,  2.890000e+05,  7.234000e+05,  7.232000e+05,
        -2.390000e+04, -7.640000e+04, -1.200000e+03,  6.080000e+04,
        -1.130000e+04, -1.270000e+04, -2.073000e+05,  2.385000e+05,
        -3.190000e+04,  1.265020e+07,  0.000000e+00,  1.000000e+02,
        -6.400000e+03,  7.900000e+04, -1.620000e+04, -3.360000e+04,
         0.000000e+00,  0.000000e+00, -1.255000e+05, -2.228000e+05,
        -4.790000e+04,  1.790000e+04, -1.570000e+04,  9.508600e+06,
         6.200000e+04, -1.055000e+05, -1.600000e+04, -8.350000e+04,
        -8.350000e+04,  8.090000e+04, -1.560000e+04, -8.000000e+03,
        -5.100000e+03, -9.950000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -2.000000e+02,  6.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  6.080000e+04, -7.640000e+04,
        -2.720000e+04,  1.449000e+05, -2.000000e+02,  3.162000e+05,
         1.091000e+05,  6.120000e+04,  4.769000e+05,  2.940000e+05,
        -6.010000e+04,  1.000000e+02, -5.030000e+04,  1.212000e+05,
        -1.756000e+05, -2.043000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.449000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 2.188000e+05,  1.844000e+05,  1.743000e+05, -1.128000e+05,
         5.300000e+04,  8.627000e+05,  4.251000e+05,  2.202000e+05,
         1.844000e+05,  2.209000e+05,  1.844000e+05,  2.363000e+05,
         8.630000e+04,  4.515000e+05,  6.760000e+04,  2.378000e+05,
         2.010000e+04,  9.454000e+05,  1.171800e+06,  1.121900e+06,
         1.109000e+06,  6.390000e+05,  1.365000e+05,  7.345000e+05,
         1.061600e+07,  1.011920e+07,  1.057400e+07,  3.371000e+06,
         7.105000e+05,  7.112000e+05,  7.160000e+05,  7.161000e+05,
         6.966000e+05,  7.107000e+05,  5.929900e+06,  5.870200e+06,
         5.846300e+06,  6.930000e+05,  6.721000e+05,  6.721000e+05,
        -6.000000e+04, -4.048000e+05,  1.057300e+06,  1.057400e+06,
         8.024000e+05,  5.500000e+05,  7.954000e+05,  7.709000e+05,
         1.872600e+06,  1.853600e+06,  5.790000e+05,  3.203000e+05,
         1.207000e+05, -4.530000e+04, -4.030000e+05,  2.197700e+06,
         2.197200e+06,  2.136500e+06,  2.155900e+06,  3.998000e+05,
         6.600000e+04,  3.157000e+05,  1.966000e+05,  4.766000e+05,
         4.766000e+05,  4.766000e+05,  4.766000e+05,  4.437000e+05,
         6.958000e+05,  3.014000e+05,  2.847000e+05, -5.030000e+04,
        -3.092000e+05, -2.680000e+05,  5.138000e+05,  6.413000e+05,
         1.921000e+05,  1.921000e+05,  6.760000e+04,  6.760000e+04,
         6.760000e+04,  1.575000e+06,  1.493700e+06,  2.003600e+06,
         9.764000e+05,  8.710000e+05,  8.196000e+05,  3.107000e+05,
         1.925200e+06,  1.809800e+06,  1.925200e+06,  1.811600e+06,
         2.452600e+06,  2.270100e+06,  2.489600e+06,  2.192000e+06,
         9.482000e+05,  9.289000e+05,  2.464500e+06,  7.372400e+06,
         7.158700e+06,  7.143300e+06,  6.585000e+05,  1.222400e+06,
         6.846700e+06,  6.807400e+06,  6.784000e+06,  7.060900e+06,
         1.478000e+05,  1.135400e+06,  1.348700e+06,  9.220000e+05,
         1.040300e+06,  1.030800e+06,  1.637100e+06,  1.599000e+06,
         1.469900e+06,  9.717000e+05,  9.090000e+05,  1.186100e+06,
         1.493100e+06,  9.243000e+05,  9.838000e+05,  9.457000e+05,
         8.337000e+05,  5.788000e+05,  4.469000e+05,  4.469000e+05,
         4.052000e+05,  5.297300e+06,  5.392300e+06,  7.811500e+06,
         2.067000e+05,  2.070000e+05,  6.915500e+06,  6.920000e+06,
         7.701000e+05,  6.919500e+06,  1.286970e+07,  6.920000e+06,
         2.593000e+05,  2.593000e+05,  2.593000e+05,  2.591000e+05,
         2.584000e+05, -2.952000e+05, -2.950000e+05, -2.951000e+05,
        -1.771200e+06,  6.402400e+06,  6.661200e+06,  2.131500e+06,
         1.288200e+06,  1.287800e+06,  2.064500e+06,  2.064000e+06,
        -5.270000e+04, -1.714000e+05,  2.500000e+03, -1.150000e+04,
        -2.170000e+04, -1.740000e+04,  4.515000e+05,  2.363000e+05,
        -6.530000e+04,  1.950000e+04,  0.000000e+00,  3.000000e+02,
        -3.150000e+04, -1.270000e+04, -3.450000e+04, -5.910000e+04,
         0.000000e+00,  0.000000e+00,  4.356000e+05,  4.173000e+05,
        -1.011000e+05, -2.710000e+04, -3.330000e+04,  0.000000e+00,
        -1.240000e+04,  2.180000e+05, -3.290000e+04, -1.788000e+05,
        -1.788000e+05, -1.300000e+04, -3.290000e+04, -1.580000e+04,
        -1.926000e+05, -2.117000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -5.000000e+02,  2.100000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.150000e+04, -1.714000e+05,
         5.930000e+04,  2.593000e+05, -5.000000e+02,  2.188000e+05,
         1.844000e+05,  6.760000e+04,  4.766000e+05,  3.014000e+05,
         7.157000e+05,  7.701000e+05,  6.920000e+06,  2.070000e+05,
        -2.951000e+05,  6.661200e+06,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.593000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 4.184000e+05,  2.835000e+05,  2.657000e+05, -6.360000e+04,
         1.770000e+05,  1.689800e+06,  8.530000e+05,  4.179000e+05,
         2.835000e+05,  4.177000e+05,  2.834000e+05,  4.000000e+05,
         1.317000e+05, -1.099000e+05,  1.530000e+05,  3.998000e+05,
         3.030000e+04,  1.600000e+06,  1.086300e+06,  8.967000e+05,
         8.632000e+05,  3.409000e+05,  3.721000e+05,  1.180900e+06,
         1.011920e+07,  1.141840e+07,  9.978500e+06,  1.901000e+06,
         2.710000e+05,  2.715000e+05,  2.749000e+05,  2.767000e+05,
         5.570000e+04,  2.709000e+05,  1.941200e+06,  1.689900e+06,
         1.643800e+06,  2.903000e+05,  2.228000e+05,  2.160000e+05,
         1.130000e+05, -3.418000e+05,  5.140000e+05,  5.140000e+05,
         5.279000e+05,  5.430000e+05,  5.147000e+05,  4.195000e+05,
         1.102900e+06,  1.037300e+06,  1.107200e+06, -1.868000e+05,
         3.301000e+05,  8.930000e+04, -3.390000e+05,  1.752400e+06,
         1.751800e+06,  1.599900e+06,  1.603700e+06,  8.857000e+05,
         1.501000e+05,  5.225000e+05,  2.900000e+05,  7.997000e+05,
         7.997000e+05,  7.996000e+05,  7.997000e+05,  6.645000e+05,
         2.899000e+05,  5.476000e+05,  4.804000e+05, -6.850000e+04,
        -5.860000e+04, -2.260000e+04,  4.040000e+04,  5.888000e+05,
         2.863000e+05,  2.864000e+05,  1.530000e+05,  1.530000e+05,
         1.530000e+05,  2.673900e+06,  2.338000e+06,  1.654800e+06,
         9.732000e+05,  1.439800e+06,  1.233700e+06,  1.268700e+06,
         3.176600e+06,  2.703500e+06,  3.176600e+06,  2.706100e+06,
         2.232300e+06,  4.066000e+05, -1.023000e+05,  1.288000e+05,
         6.694000e+05,  6.036000e+05,  3.729700e+06,  6.788400e+06,
         7.296300e+06,  7.233200e+06,  1.996000e+05,  3.098000e+05,
         6.947900e+06,  6.751800e+06,  6.724800e+06,  6.440200e+06,
         3.644000e+05,  1.128000e+06,  6.168000e+05,  1.639300e+06,
         8.001000e+05,  7.563000e+05,  9.577000e+05,  8.265000e+05,
         1.397000e+06,  1.577200e+06,  1.374700e+06,  1.068700e+06,
         1.417200e+06,  1.377200e+06,  1.577000e+06,  6.310000e+05,
         5.701000e+05,  5.841000e+05,  8.044000e+05,  8.044000e+05,
         6.145000e+05,  5.603400e+06,  5.931400e+06,  1.382820e+07,
         3.089000e+05,  3.093000e+05,  6.893000e+06,  6.897600e+06,
         4.195000e+05,  6.897000e+06,  1.314280e+07,  6.897600e+06,
         3.810000e+05,  3.810000e+05,  3.810000e+05,  3.808000e+05,
         3.811000e+05, -4.279000e+05, -4.276000e+05, -4.277000e+05,
        -2.566900e+06,  6.135000e+06,  6.516300e+06,  1.044400e+06,
         1.180700e+06,  1.180000e+06,  2.321900e+06,  2.321300e+06,
        -7.220000e+04, -2.039000e+05, -8.000000e+02,  1.640000e+04,
        -2.870000e+04, -2.690000e+04, -1.099000e+05,  4.000000e+05,
        -8.600000e+04, -1.860000e+04,  0.000000e+00,  3.000000e+02,
        -4.700000e+04,  2.070000e+04, -4.680000e+04, -8.720000e+04,
         0.000000e+00,  0.000000e+00, -9.180000e+04, -1.543000e+05,
        -1.318000e+05, -2.080000e+04, -4.520000e+04,  0.000000e+00,
         1.630000e+04, -6.210000e+04, -4.320000e+04, -2.141000e+05,
        -2.141000e+05,  2.400000e+04, -4.260000e+04, -2.290000e+04,
        -1.915000e+05, -2.569000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -6.000000e+02,  2.500000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.640000e+04, -2.039000e+05,
        -1.440000e+04,  3.810000e+05, -6.000000e+02,  4.184000e+05,
         2.835000e+05,  1.530000e+05,  7.997000e+05,  5.476000e+05,
         2.763000e+05,  4.195000e+05,  6.897600e+06,  3.093000e+05,
        -4.277000e+05,  6.516300e+06,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  3.810000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-5.130000e+04,  5.663000e+05,  1.723000e+05, -7.760000e+04,
        -6.380000e+04, -3.279000e+05, -2.255000e+05, -4.290000e+04,
         5.663000e+05, -3.880000e+04,  5.661000e+05,  1.049000e+05,
         1.613000e+05,  4.287000e+05,  9.980000e+04,  1.139000e+05,
         3.820000e+04,  4.197000e+05,  7.813000e+05,  1.702300e+06,
         1.125500e+06,  7.114000e+05,  5.343000e+05,  5.138000e+05,
         1.057400e+07,  9.978500e+06,  1.179600e+07,  3.504100e+06,
         7.217000e+05,  7.227000e+05,  7.291000e+05,  7.219000e+05,
         6.827000e+05,  7.222000e+05,  5.355700e+06,  6.590800e+06,
         5.814600e+06,  5.506000e+05,  8.507000e+05,  6.653000e+05,
        -1.410000e+05, -3.305000e+05,  1.120500e+06,  1.120500e+06,
         1.028200e+06,  9.384000e+05,  8.492000e+05,  8.140000e+05,
         1.856300e+06,  2.159500e+06,  1.697700e+06,  3.281000e+05,
         3.610000e+04,  2.220000e+04, -3.289000e+05,  1.990500e+06,
         1.990000e+06,  2.629100e+06,  2.219900e+06, -4.738000e+05,
         7.560000e+04,  3.771000e+05,  2.202000e+05,  2.312000e+05,
         2.312000e+05,  2.312000e+05,  2.312000e+05,  8.606000e+05,
         5.508000e+05,  2.121000e+05,  5.236000e+05, -5.180000e+04,
        -1.496000e+05, -1.839000e+05,  5.227000e+05,  6.967000e+05,
         2.068000e+05,  2.068000e+05,  9.980000e+04,  9.980000e+04,
         9.980000e+04,  1.060700e+06,  2.630300e+06,  1.687800e+06,
         4.850000e+05,  5.322000e+05,  1.472200e+06,  1.264700e+06,
         1.099400e+06,  3.302100e+06,  1.099400e+06,  3.304700e+06,
         1.779900e+06,  1.630400e+06,  1.950400e+06,  2.893100e+06,
         8.367000e+05,  1.139500e+06,  5.864900e+06,  7.434500e+06,
         7.121000e+06,  7.429300e+06,  6.671000e+05,  1.242600e+06,
         6.461000e+06,  7.418100e+06,  6.805200e+06,  6.774900e+06,
        -2.630000e+05,  4.431000e+05,  7.573000e+05,  1.288000e+05,
         1.958900e+06,  1.016700e+06,  1.379700e+06,  1.986100e+06,
         1.583200e+06,  6.361000e+05,  1.536500e+06,  9.508000e+05,
         1.609300e+06,  1.583400e+06,  7.292000e+05,  9.901000e+05,
         9.086000e+05,  8.162000e+05,  5.160000e+04,  5.160000e+04,
         9.959000e+05,  6.401800e+06,  4.886000e+06,  1.597000e+06,
         2.379000e+05,  2.381000e+05,  7.001000e+06,  7.005600e+06,
         8.130000e+05,  7.005100e+06,  1.299510e+07,  7.005600e+06,
         2.936000e+05,  2.936000e+05,  2.936000e+05,  2.934000e+05,
         2.886000e+05, -3.195000e+05, -3.193000e+05, -3.194000e+05,
        -1.916900e+06,  6.430100e+06,  6.718000e+06,  2.263400e+06,
         1.400000e+06,  1.399700e+06,  2.279700e+06,  2.279300e+06,
        -5.580000e+04, -1.736000e+05, -2.070000e+04, -1.188000e+05,
         8.140000e+04, -1.510000e+04,  4.287000e+05,  1.049000e+05,
         2.363000e+05,  1.669000e+05,  0.000000e+00, -1.700000e+03,
        -6.990000e+04, -1.767000e+05,  1.060000e+05, -6.620000e+04,
         0.000000e+00,  0.000000e+00,  2.642000e+05,  5.616000e+05,
         3.663000e+05,  1.850000e+04,  1.024000e+05,  0.000000e+00,
        -1.229000e+05,  2.060000e+05,  1.177000e+05, -1.756000e+05,
        -1.756000e+05, -1.533000e+05,  1.315000e+05, -1.930000e+04,
        -3.277000e+05, -4.380000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -5.000000e+02,  2.700000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.188000e+05, -1.736000e+05,
         5.630000e+04,  2.936000e+05, -5.000000e+02, -5.130000e+04,
         5.663000e+05,  9.980000e+04,  2.312000e+05,  2.121000e+05,
         7.220000e+05,  8.130000e+05,  7.005600e+06,  2.381000e+05,
        -3.194000e+05,  6.718000e+06,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.936000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-1.809000e+05, -2.640000e+04,  7.390000e+04,  5.968800e+06,
         2.886800e+06, -8.323000e+05, -4.705000e+05, -1.742000e+05,
        -2.640000e+04, -1.716000e+05, -2.640000e+04, -4.900000e+04,
         9.400000e+03,  1.436300e+06,  3.134100e+06, -4.390000e+04,
         2.800000e+03, -1.961000e+05,  1.352000e+06,  1.558300e+06,
         1.751200e+06,  1.146780e+07,  9.264300e+06,  6.240000e+04,
         3.371000e+06,  1.901000e+06,  3.504100e+06,  7.097210e+07,
         1.534700e+06,  1.537500e+06,  1.534600e+06,  1.534900e+06,
         1.845300e+06,  1.539000e+06,  1.316480e+07,  1.345530e+07,
         1.369720e+07,  1.403100e+06,  1.474700e+06,  1.536200e+06,
         8.863900e+06,  1.479510e+07,  9.020100e+06,  9.018900e+06,
         8.119900e+06,  7.085700e+06,  8.229700e+06,  4.924500e+06,
         1.712430e+07,  1.719460e+07,  1.269960e+07,  8.019200e+06,
         6.011000e+06,  9.109700e+06,  1.479150e+07,  3.105300e+06,
         3.106800e+06,  3.244800e+06,  3.371500e+06, -6.900000e+05,
         3.079300e+06,  3.433500e+06,  8.340000e+04, -5.930000e+04,
        -5.930000e+04, -5.930000e+04, -5.930000e+04,  7.080000e+04,
         1.412400e+06,  3.172500e+06,  3.240900e+06, -1.039000e+05,
        -9.312000e+05, -7.560000e+05,  4.778800e+06,  2.640800e+06,
         7.520000e+04,  7.520000e+04,  3.134100e+06,  3.133300e+06,
         3.134100e+06,  6.367200e+06,  6.686700e+06,  9.443800e+06,
         7.511200e+06, -1.914000e+05, -5.400000e+03, -1.647600e+06,
        -1.038000e+05,  3.516000e+05, -1.038000e+05,  3.466000e+05,
         2.812000e+06,  5.426600e+06,  6.896600e+06,  5.690900e+06,
         1.512200e+06,  1.582700e+06,  3.100000e+04,  1.516100e+06,
         4.570000e+04,  1.151000e+05,  1.432100e+06,  6.365200e+06,
        -3.154000e+05, -1.121000e+05,  8.390000e+04,  1.155900e+06,
        -4.603000e+05,  1.068800e+06,  2.546000e+06, -4.084000e+05,
         1.420600e+06,  1.734300e+06,  2.927200e+06,  3.068000e+06,
         1.804100e+06,  1.660000e+04,  2.314000e+05,  1.484200e+06,
         1.827900e+06,  2.049000e+05, -1.543000e+05,  1.602200e+06,
         8.254700e+06,  7.355700e+06, -2.179000e+05, -2.179000e+05,
         1.200000e+04,  1.457300e+06,  1.105400e+06, -3.122100e+06,
        -8.000000e+03, -7.900000e+03,  6.990000e+04,  7.000000e+04,
         4.946400e+06,  7.150000e+04, -1.494800e+06,  7.000000e+04,
         9.720000e+04,  9.720000e+04,  9.720000e+04,  9.730000e+04,
         9.650000e+04, -1.924000e+05, -1.922000e+05, -1.923000e+05,
        -1.154100e+06, -1.521000e+05, -4.130000e+04,  1.767610e+07,
         5.135800e+06,  5.129900e+06,  5.424600e+06,  5.426100e+06,
        -1.034000e+05,  2.699300e+06, -1.742000e+05, -1.067000e+05,
        -3.600000e+04,  6.500000e+03,  1.436300e+06, -4.900000e+04,
        -1.383000e+05,  1.513000e+05,  0.000000e+00, -1.100000e+03,
        -1.343000e+05, -3.529000e+05, -2.300000e+05, -2.510000e+04,
         0.000000e+00,  0.000000e+00,  1.304200e+06,  1.380100e+06,
        -1.969000e+05, -8.850000e+04, -2.222000e+05,  0.000000e+00,
        -1.085000e+05,  7.096000e+05, -6.830000e+04,  2.839300e+06,
         2.839100e+06, -2.051000e+05, -8.530000e+04, -1.790000e+04,
         2.653100e+06,  2.756100e+06,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.500000e+03, -2.640000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.067000e+05,  2.699300e+06,
         1.885000e+05,  9.720000e+04,  1.500000e+03, -1.809000e+05,
        -2.640000e+04,  3.133300e+06, -5.930000e+04,  3.172500e+06,
         1.534900e+06,  4.946400e+06,  7.000000e+04, -7.900000e+03,
        -1.923000e+05, -4.130000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  9.720000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-3.010000e+04, -1.850000e+04, -1.250000e+04, -5.770000e+04,
        -4.380000e+04, -1.259000e+05, -6.570000e+04, -2.980000e+04,
        -1.850000e+04, -2.970000e+04, -1.850000e+04, -2.360000e+04,
        -7.100000e+03,  4.176000e+05, -3.760000e+04, -2.330000e+04,
        -1.600000e+03, -9.430000e+04,  3.470000e+05,  3.609000e+05,
         3.730000e+05,  2.959000e+05, -1.153000e+05, -6.230000e+04,
         7.105000e+05,  2.710000e+05,  7.217000e+05,  1.534700e+06,
         4.035000e+05,  4.019000e+05,  4.009000e+05,  4.019000e+05,
         5.142000e+05,  4.018000e+05,  3.609700e+06,  3.627500e+06,
         3.644300e+06,  3.940000e+05,  3.980000e+05,  4.027000e+05,
        -1.016000e+05, -1.358000e+05,  5.266000e+05,  5.266000e+05,
         3.191000e+05,  1.129000e+05,  3.216000e+05,  3.597000e+05,
         8.389000e+05,  8.431000e+05, -1.945000e+05,  3.529000e+05,
        -8.120000e+04, -9.540000e+04, -1.358000e+05,  7.386000e+05,
         7.385000e+05,  7.488000e+05,  7.559000e+05, -7.680000e+04,
        -3.820000e+04, -5.500000e+04, -1.250000e+04, -4.620000e+04,
        -4.620000e+04, -4.620000e+04, -4.620000e+04, -3.460000e+04,
         3.930000e+05, -6.090000e+04, -5.510000e+04, -6.000000e+02,
        -2.096000e+05, -2.047000e+05,  3.769000e+05,  1.615000e+05,
        -1.260000e+04, -1.260000e+04, -3.760000e+04, -3.760000e+04,
        -3.760000e+04, -2.073000e+05, -1.784000e+05,  6.690000e+05,
         2.758000e+05, -8.640000e+04, -6.910000e+04, -4.908000e+05,
        -1.778000e+05, -1.373000e+05, -1.778000e+05, -1.374000e+05,
         6.972000e+05,  1.603900e+06,  2.043100e+06,  1.626500e+06,
         3.786000e+05,  3.829000e+05, -2.165000e+05,  4.218000e+05,
        -1.960000e+04, -1.510000e+04,  4.017000e+05,  7.774000e+05,
        -1.710000e+04, -5.000000e+02,  8.900000e+03,  4.243000e+05,
        -3.760000e+04,  3.317000e+05,  7.711000e+05, -1.078000e+05,
         3.530000e+05,  3.750000e+05,  7.733000e+05,  7.819000e+05,
         3.493000e+05, -8.530000e+04, -7.330000e+04,  3.557000e+05,
         3.526000e+05, -6.820000e+04, -8.050000e+04,  3.793000e+05,
         3.193000e+05,  1.117000e+05, -5.290000e+04, -5.290000e+04,
        -3.600000e+04,  2.000000e+05,  1.787000e+05, -8.852000e+05,
        -1.650000e+04, -1.660000e+04,  3.800000e+03,  3.800000e+03,
         3.589000e+05,  3.700000e+03, -3.782000e+05,  3.800000e+03,
        -1.610000e+04, -1.610000e+04, -1.610000e+04, -1.610000e+04,
        -1.610000e+04,  1.380000e+04,  1.380000e+04,  1.380000e+04,
         8.260000e+04,  3.600000e+04,  1.990000e+04,  1.056600e+06,
         3.268000e+05,  3.270000e+05,  2.785000e+05,  2.785000e+05,
        -5.000000e+02, -1.930000e+04,  2.600000e+03, -5.300000e+03,
        -7.000000e+02,  1.200000e+03,  4.176000e+05, -2.360000e+04,
        -1.700000e+03,  7.000000e+03,  0.000000e+00,  0.000000e+00,
         3.300000e+03, -3.700000e+03,  0.000000e+00,  3.700000e+03,
         0.000000e+00,  0.000000e+00,  4.084000e+05,  4.147000e+05,
        -4.000000e+03, -3.200000e+03,  0.000000e+00,  0.000000e+00,
        -5.500000e+03,  2.072000e+05, -9.000000e+02, -2.020000e+04,
        -2.020000e+04, -6.100000e+03, -2.000000e+03,  1.000000e+03,
        -2.630000e+04, -2.220000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02,  2.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -5.300000e+03, -1.930000e+04,
         5.480000e+04, -1.610000e+04, -1.000000e+02, -3.010000e+04,
        -1.850000e+04, -3.760000e+04, -4.620000e+04, -6.090000e+04,
         4.019000e+05,  3.589000e+05,  3.800000e+03, -1.660000e+04,
         1.380000e+04,  1.990000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.610000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-3.010000e+04, -1.850000e+04, -1.250000e+04, -5.780000e+04,
        -4.390000e+04, -1.260000e+05, -6.580000e+04, -2.980000e+04,
        -1.850000e+04, -2.970000e+04, -1.850000e+04, -2.340000e+04,
        -7.100000e+03,  4.176000e+05, -3.760000e+04, -2.310000e+04,
        -1.600000e+03, -9.360000e+04,  3.473000e+05,  3.616000e+05,
         3.734000e+05,  2.964000e+05, -1.155000e+05, -6.220000e+04,
         7.112000e+05,  2.715000e+05,  7.227000e+05,  1.537500e+06,
         4.019000e+05,  4.031000e+05,  4.014000e+05,  4.018000e+05,
         5.141000e+05,  4.030000e+05,  3.614200e+06,  3.636100e+06,
         3.649000e+06,  3.947000e+05,  3.983000e+05,  4.034000e+05,
        -1.018000e+05, -1.361000e+05,  5.276000e+05,  5.276000e+05,
         3.198000e+05,  1.132000e+05,  3.220000e+05,  3.605000e+05,
         8.404000e+05,  8.445000e+05, -1.945000e+05,  3.529000e+05,
        -8.130000e+04, -9.550000e+04, -1.360000e+05,  7.388000e+05,
         7.387000e+05,  7.499000e+05,  7.562000e+05, -7.690000e+04,
        -3.850000e+04, -5.500000e+04, -1.240000e+04, -4.620000e+04,
        -4.620000e+04, -4.620000e+04, -4.620000e+04, -3.460000e+04,
         3.932000e+05, -6.080000e+04, -5.500000e+04, -8.000000e+02,
        -2.096000e+05, -2.051000e+05,  3.770000e+05,  1.625000e+05,
        -1.260000e+04, -1.260000e+04, -3.760000e+04, -3.760000e+04,
        -3.760000e+04, -2.071000e+05, -1.781000e+05,  6.703000e+05,
         2.760000e+05, -8.690000e+04, -6.830000e+04, -4.909000e+05,
        -1.776000e+05, -1.371000e+05, -1.776000e+05, -1.372000e+05,
         6.939000e+05,  1.604700e+06,  2.044200e+06,  1.627700e+06,
         3.798000e+05,  3.838000e+05, -2.166000e+05,  4.214000e+05,
        -2.100000e+04, -1.670000e+04,  4.018000e+05,  7.790000e+05,
        -1.740000e+04, -5.000000e+02,  8.700000e+03,  4.249000e+05,
        -3.740000e+04,  3.319000e+05,  7.715000e+05, -1.077000e+05,
         3.524000e+05,  3.754000e+05,  7.757000e+05,  7.839000e+05,
         3.489000e+05, -8.530000e+04, -7.450000e+04,  3.569000e+05,
         3.532000e+05, -6.800000e+04, -8.010000e+04,  3.788000e+05,
         3.199000e+05,  1.121000e+05, -5.290000e+04, -5.290000e+04,
        -3.600000e+04,  2.008000e+05,  1.803000e+05, -8.855000e+05,
        -1.620000e+04, -1.620000e+04,  3.900000e+03,  3.900000e+03,
         3.597000e+05,  3.800000e+03, -3.793000e+05,  3.900000e+03,
        -1.610000e+04, -1.610000e+04, -1.610000e+04, -1.610000e+04,
        -1.560000e+04,  1.340000e+04,  1.340000e+04,  1.340000e+04,
         8.020000e+04,  3.590000e+04,  1.990000e+04,  1.058900e+06,
         3.277000e+05,  3.280000e+05,  2.796000e+05,  2.796000e+05,
        -3.000000e+02, -1.940000e+04,  2.600000e+03, -5.300000e+03,
        -9.000000e+02,  1.200000e+03,  4.176000e+05, -2.340000e+04,
        -1.700000e+03,  7.000000e+03,  0.000000e+00,  0.000000e+00,
         3.300000e+03, -3.800000e+03,  1.000000e+02,  3.700000e+03,
         0.000000e+00,  0.000000e+00,  4.086000e+05,  4.150000e+05,
        -4.200000e+03, -3.200000e+03,  1.000000e+02,  0.000000e+00,
        -5.500000e+03,  2.069000e+05, -9.000000e+02, -2.020000e+04,
        -2.020000e+04, -6.100000e+03, -2.100000e+03,  1.000000e+03,
        -2.630000e+04, -2.230000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02,  2.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -5.300000e+03, -1.940000e+04,
         5.480000e+04, -1.610000e+04, -1.000000e+02, -3.010000e+04,
        -1.850000e+04, -3.760000e+04, -4.620000e+04, -6.080000e+04,
         4.018000e+05,  3.597000e+05,  3.900000e+03, -1.620000e+04,
         1.340000e+04,  1.990000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.610000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-3.040000e+04, -1.800000e+04, -1.250000e+04, -5.760000e+04,
        -4.390000e+04, -1.273000e+05, -6.640000e+04, -3.010000e+04,
        -1.800000e+04, -2.990000e+04, -1.800000e+04, -2.370000e+04,
        -7.000000e+03,  4.171000e+05, -3.750000e+04, -2.340000e+04,
        -1.600000e+03, -9.490000e+04,  3.477000e+05,  3.629000e+05,
         3.743000e+05,  2.960000e+05, -1.146000e+05, -6.270000e+04,
         7.160000e+05,  2.749000e+05,  7.291000e+05,  1.534600e+06,
         4.009000e+05,  4.014000e+05,  4.049000e+05,  4.015000e+05,
         5.136000e+05,  4.013000e+05,  3.605800e+06,  3.630800e+06,
         3.641200e+06,  3.940000e+05,  3.985000e+05,  4.028000e+05,
        -1.016000e+05, -1.356000e+05,  5.267000e+05,  5.267000e+05,
         3.195000e+05,  1.135000e+05,  3.221000e+05,  3.597000e+05,
         8.393000e+05,  8.441000e+05, -1.922000e+05,  3.526000e+05,
        -8.130000e+04, -9.520000e+04, -1.356000e+05,  7.418000e+05,
         7.417000e+05,  7.559000e+05,  7.595000e+05, -7.740000e+04,
        -3.760000e+04, -5.500000e+04, -1.240000e+04, -4.660000e+04,
        -4.660000e+04, -4.660000e+04, -4.660000e+04, -3.400000e+04,
         3.942000e+05, -6.120000e+04, -5.490000e+04, -7.000000e+02,
        -2.090000e+05, -2.054000e+05,  3.765000e+05,  1.620000e+05,
        -1.260000e+04, -1.260000e+04, -3.750000e+04, -3.750000e+04,
        -3.750000e+04, -2.083000e+05, -1.768000e+05,  6.695000e+05,
         2.753000e+05, -8.720000e+04, -6.760000e+04, -4.872000e+05,
        -1.789000e+05, -1.349000e+05, -1.789000e+05, -1.349000e+05,
         7.060000e+05,  1.608000e+06,  2.048900e+06,  1.633900e+06,
         3.780000e+05,  3.828000e+05, -2.107000e+05,  4.218000e+05,
        -1.890000e+04, -1.380000e+04,  4.007000e+05,  7.768000e+05,
        -1.820000e+04, -2.000000e+02,  8.300000e+03,  4.225000e+05,
        -3.780000e+04,  3.325000e+05,  7.725000e+05, -1.074000e+05,
         3.565000e+05,  3.768000e+05,  7.719000e+05,  7.815000e+05,
         3.486000e+05, -8.580000e+04, -7.210000e+04,  3.548000e+05,
         3.569000e+05, -6.700000e+04, -8.130000e+04,  3.783000e+05,
         3.195000e+05,  1.122000e+05, -5.350000e+04, -5.350000e+04,
        -3.520000e+04,  2.026000e+05,  1.787000e+05, -8.936000e+05,
        -1.620000e+04, -1.620000e+04,  4.000000e+03,  4.000000e+03,
         3.590000e+05,  4.000000e+03, -3.774000e+05,  4.000000e+03,
        -1.590000e+04, -1.590000e+04, -1.590000e+04, -1.600000e+04,
        -1.600000e+04,  1.340000e+04,  1.340000e+04,  1.340000e+04,
         8.020000e+04,  3.610000e+04,  2.010000e+04,  1.056900e+06,
         3.273000e+05,  3.274000e+05,  2.794000e+05,  2.794000e+05,
        -4.000000e+02, -1.940000e+04,  2.700000e+03, -5.200000e+03,
        -6.000000e+02,  1.200000e+03,  4.171000e+05, -2.370000e+04,
        -1.400000e+03,  7.200000e+03,  0.000000e+00,  0.000000e+00,
         2.500000e+03, -3.800000e+03, -6.000000e+02,  3.700000e+03,
         0.000000e+00,  0.000000e+00,  4.094000e+05,  4.161000e+05,
        -3.200000e+03, -3.000000e+03, -6.000000e+02,  0.000000e+00,
        -5.500000e+03,  2.066000e+05, -7.000000e+02, -2.020000e+04,
        -2.020000e+04, -6.300000e+03, -1.500000e+03,  1.000000e+03,
        -2.640000e+04, -2.160000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02,  2.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -5.200000e+03, -1.940000e+04,
         5.470000e+04, -1.590000e+04, -1.000000e+02, -3.040000e+04,
        -1.800000e+04, -3.750000e+04, -4.660000e+04, -6.120000e+04,
         4.015000e+05,  3.590000e+05,  4.000000e+03, -1.620000e+04,
         1.340000e+04,  2.010000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.590000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-2.990000e+04, -1.900000e+04, -1.250000e+04, -5.780000e+04,
        -4.380000e+04, -1.255000e+05, -6.560000e+04, -2.970000e+04,
        -1.900000e+04, -2.960000e+04, -1.900000e+04, -2.360000e+04,
        -7.200000e+03,  4.189000e+05, -3.760000e+04, -2.340000e+04,
        -1.600000e+03, -9.430000e+04,  3.483000e+05,  3.610000e+05,
         3.741000e+05,  2.955000e+05, -1.151000e+05, -6.000000e+04,
         7.161000e+05,  2.767000e+05,  7.219000e+05,  1.534900e+06,
         4.019000e+05,  4.018000e+05,  4.015000e+05,  4.204000e+05,
         5.330000e+05,  4.017000e+05,  3.616600e+06,  3.629600e+06,
         3.651000e+06,  3.945000e+05,  3.985000e+05,  4.031000e+05,
        -1.018000e+05, -1.362000e+05,  5.259000e+05,  5.259000e+05,
         3.184000e+05,  1.124000e+05,  3.216000e+05,  3.592000e+05,
         8.382000e+05,  8.423000e+05, -1.952000e+05,  3.537000e+05,
        -8.100000e+04, -9.550000e+04, -1.360000e+05,  7.514000e+05,
         7.514000e+05,  7.496000e+05,  7.686000e+05, -7.730000e+04,
        -3.870000e+04, -5.490000e+04, -1.270000e+04, -4.490000e+04,
        -4.490000e+04, -4.490000e+04, -4.490000e+04, -3.550000e+04,
         3.923000e+05, -6.040000e+04, -5.520000e+04, -3.000000e+02,
        -2.093000e+05, -2.030000e+05,  3.775000e+05,  1.598000e+05,
        -1.280000e+04, -1.280000e+04, -3.760000e+04, -3.760000e+04,
        -3.760000e+04, -2.043000e+05, -1.802000e+05,  6.681000e+05,
         2.746000e+05, -8.400000e+04, -6.980000e+04, -4.910000e+05,
        -1.734000e+05, -1.404000e+05, -1.734000e+05, -1.408000e+05,
         7.309000e+05,  1.596400e+06,  2.034000e+06,  1.610400e+06,
         3.793000e+05,  3.834000e+05, -2.211000e+05,  4.238000e+05,
        -1.770000e+04, -1.360000e+04,  4.019000e+05,  7.775000e+05,
        -1.350000e+04, -1.100000e+03,  1.230000e+04,  4.283000e+05,
        -3.900000e+04,  3.339000e+05,  7.708000e+05, -1.029000e+05,
         3.545000e+05,  3.769000e+05,  7.750000e+05,  7.832000e+05,
         3.480000e+05, -8.340000e+04, -7.140000e+04,  3.572000e+05,
         3.519000e+05, -6.980000e+04, -8.260000e+04,  3.788000e+05,
         3.186000e+05,  1.111000e+05, -5.230000e+04, -5.230000e+04,
        -3.690000e+04,  1.981000e+05,  1.775000e+05, -8.730000e+05,
        -1.650000e+04, -1.650000e+04,  3.000000e+03,  3.000000e+03,
         3.582000e+05,  2.900000e+03, -3.793000e+05,  3.000000e+03,
        -1.650000e+04, -1.650000e+04, -1.650000e+04, -1.650000e+04,
        -1.680000e+04,  1.340000e+04,  1.340000e+04,  1.340000e+04,
         8.050000e+04,  3.440000e+04,  1.870000e+04,  1.054600e+06,
         3.254000e+05,  3.257000e+05,  2.760000e+05,  2.759000e+05,
        -1.000000e+02, -1.920000e+04,  2.600000e+03, -5.500000e+03,
        -6.000000e+02,  1.200000e+03,  4.189000e+05, -2.360000e+04,
        -1.700000e+03,  7.500000e+03,  0.000000e+00,  0.000000e+00,
         3.600000e+03, -3.700000e+03,  1.000000e+02,  3.800000e+03,
         0.000000e+00,  0.000000e+00,  4.055000e+05,  4.158000e+05,
        -3.900000e+03, -3.000000e+03,  1.000000e+02,  0.000000e+00,
        -5.800000e+03,  2.074000e+05, -9.000000e+02, -2.020000e+04,
        -2.020000e+04, -6.000000e+03, -1.800000e+03,  1.100000e+03,
        -2.630000e+04, -2.200000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02,  2.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -5.500000e+03, -1.920000e+04,
         5.500000e+04, -1.650000e+04, -1.000000e+02, -2.990000e+04,
        -1.900000e+04, -3.760000e+04, -4.490000e+04, -6.040000e+04,
         4.200000e+05,  3.582000e+05,  3.000000e+03, -1.650000e+04,
         1.340000e+04,  1.870000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.650000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-5.060000e+04, -6.070000e+04, -4.620000e+04, -7.720000e+04,
        -6.380000e+04, -1.967000e+05, -9.550000e+04, -5.120000e+04,
        -6.070000e+04, -5.150000e+04, -6.070000e+04, -5.880000e+04,
        -2.510000e+04,  5.842000e+05, -7.310000e+04, -5.950000e+04,
        -5.900000e+03, -2.354000e+05,  4.041000e+05,  3.814000e+05,
         4.091000e+05,  3.524000e+05, -2.120000e+05, -1.857000e+05,
         6.966000e+05,  5.570000e+04,  6.827000e+05,  1.845300e+06,
         5.142000e+05,  5.141000e+05,  5.136000e+05,  5.330000e+05,
         7.323000e+05,  5.140000e+05,  4.772400e+06,  4.737400e+06,
         4.779000e+06,  5.229000e+05,  5.155000e+05,  5.246000e+05,
        -1.413000e+05, -1.593000e+05,  6.484000e+05,  6.484000e+05,
         3.636000e+05,  8.050000e+04,  3.713000e+05,  4.353000e+05,
         1.017000e+06,  1.009500e+06, -4.148000e+05,  4.992000e+05,
        -1.366000e+05, -1.505000e+05, -1.594000e+05,  8.426000e+05,
         8.425000e+05,  8.246000e+05,  8.459000e+05, -8.390000e+04,
        -7.360000e+04, -1.422000e+05, -5.260000e+04, -1.181000e+05,
        -1.181000e+05, -1.181000e+05, -1.181000e+05, -1.300000e+05,
         5.215000e+05, -1.322000e+05, -1.376000e+05,  7.200000e+03,
        -2.789000e+05, -2.868000e+05,  5.066000e+05,  1.447000e+05,
        -5.120000e+04, -5.120000e+04, -7.310000e+04, -7.310000e+04,
        -7.310000e+04, -5.103000e+05, -5.395000e+05,  7.661000e+05,
         3.319000e+05, -2.312000e+05, -2.483000e+05, -8.271000e+05,
        -4.821000e+05, -5.236000e+05, -4.821000e+05, -5.244000e+05,
         8.068000e+05,  2.220300e+06,  2.860300e+06,  2.193900e+06,
         4.551000e+05,  4.476000e+05, -7.601000e+05,  5.803000e+05,
        -6.280000e+04, -7.040000e+04,  5.221000e+05,  1.018700e+06,
         2.570000e+04,  6.300000e+03,  3.070000e+04,  6.690000e+05,
        -3.590000e+04,  4.211000e+05,  1.061000e+06, -2.187000e+05,
         3.836000e+05,  4.294000e+05,  9.794000e+05,  9.644000e+05,
         3.024000e+05, -2.457000e+05, -2.680000e+05,  3.965000e+05,
         3.056000e+05, -2.644000e+05, -2.473000e+05,  4.385000e+05,
         3.587000e+05,  7.390000e+04, -1.074000e+05, -1.075000e+05,
        -1.258000e+05, -2.000000e+02,  3.720000e+04, -1.893100e+06,
        -6.120000e+04, -6.130000e+04, -5.700000e+03, -5.700000e+03,
         4.342000e+05, -5.800000e+03, -4.562000e+05, -5.700000e+03,
        -6.930000e+04, -6.930000e+04, -6.930000e+04, -6.930000e+04,
        -6.920000e+04,  6.970000e+04,  6.970000e+04,  6.970000e+04,
         4.182000e+05,  1.310000e+05,  6.260000e+04,  1.298400e+06,
         2.959000e+05,  2.963000e+05,  8.830000e+04,  8.820000e+04,
         8.000000e+03, -3.600000e+03,  3.700000e+03,  5.600000e+03,
         2.500000e+03,  4.300000e+03,  5.842000e+05, -5.880000e+04,
         8.100000e+03, -8.500000e+03,  0.000000e+00,  0.000000e+00,
         1.220000e+04,  1.210000e+04,  5.800000e+03,  1.580000e+04,
         0.000000e+00,  0.000000e+00,  5.878000e+05,  5.855000e+05,
         1.080000e+04,  5.100000e+03,  5.600000e+03,  0.000000e+00,
         5.700000e+03,  2.902000e+05,  4.000000e+03, -4.400000e+03,
        -4.400000e+03,  8.300000e+03,  2.600000e+03,  4.500000e+03,
         3.700000e+03, -1.900000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  5.600000e+03, -3.600000e+03,
         7.670000e+04, -6.930000e+04,  0.000000e+00, -5.060000e+04,
        -6.070000e+04, -7.310000e+04, -1.181000e+05, -1.322000e+05,
         5.342000e+05,  4.342000e+05, -5.700000e+03, -6.130000e+04,
         6.970000e+04,  6.260000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -6.930000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-3.020000e+04, -1.860000e+04, -1.250000e+04, -5.780000e+04,
        -4.390000e+04, -1.261000e+05, -6.560000e+04, -2.990000e+04,
        -1.860000e+04, -2.980000e+04, -1.860000e+04, -2.350000e+04,
        -7.100000e+03,  4.176000e+05, -3.760000e+04, -2.310000e+04,
        -1.600000e+03, -9.400000e+04,  3.471000e+05,  3.614000e+05,
         3.733000e+05,  2.963000e+05, -1.155000e+05, -6.240000e+04,
         7.107000e+05,  2.709000e+05,  7.222000e+05,  1.539000e+06,
         4.018000e+05,  4.030000e+05,  4.013000e+05,  4.017000e+05,
         5.140000e+05,  8.196000e+05,  3.614400e+06,  3.636400e+06,
         3.649300e+06,  3.951000e+05,  3.987000e+05,  4.038000e+05,
        -1.018000e+05, -1.360000e+05,  5.277000e+05,  5.277000e+05,
         3.199000e+05,  1.133000e+05,  3.222000e+05,  3.613000e+05,
         8.416000e+05,  8.457000e+05, -1.932000e+05,  3.529000e+05,
        -8.130000e+04, -9.550000e+04, -1.359000e+05,  7.384000e+05,
         7.388000e+05,  7.497000e+05,  7.559000e+05, -7.590000e+04,
        -3.850000e+04, -5.510000e+04, -1.250000e+04, -4.630000e+04,
        -4.630000e+04, -4.630000e+04, -4.630000e+04, -3.470000e+04,
         3.931000e+05, -6.090000e+04, -5.510000e+04, -9.000000e+02,
        -2.096000e+05, -2.052000e+05,  3.770000e+05,  1.624000e+05,
        -1.260000e+04, -1.260000e+04, -3.760000e+04, -3.760000e+04,
        -3.760000e+04, -2.071000e+05, -1.780000e+05,  6.704000e+05,
         2.762000e+05, -8.680000e+04, -6.820000e+04, -4.907000e+05,
        -1.778000e+05, -1.371000e+05, -1.778000e+05, -1.372000e+05,
         6.939000e+05,  1.604400e+06,  2.044000e+06,  1.627500e+06,
         3.805000e+05,  3.846000e+05, -2.151000e+05,  4.218000e+05,
        -2.070000e+04, -1.640000e+04,  4.021000e+05,  7.793000e+05,
        -1.710000e+04, -1.000000e+02,  9.100000e+03,  4.252000e+05,
        -3.720000e+04,  3.333000e+05,  7.730000e+05, -1.064000e+05,
         3.540000e+05,  3.769000e+05,  7.771000e+05,  7.854000e+05,
         3.490000e+05, -8.510000e+04, -7.430000e+04,  3.571000e+05,
         3.534000e+05, -6.780000e+04, -7.990000e+04,  3.795000e+05,
         3.202000e+05,  1.124000e+05, -5.230000e+04, -5.230000e+04,
        -3.520000e+04,  2.030000e+05,  1.824000e+05, -8.754000e+05,
        -1.630000e+04, -1.630000e+04,  3.800000e+03,  3.800000e+03,
         3.596000e+05,  4.100000e+03, -3.793000e+05,  3.800000e+03,
        -1.610000e+04, -1.610000e+04, -1.610000e+04, -1.610000e+04,
        -1.570000e+04,  1.340000e+04,  1.340000e+04,  1.340000e+04,
         8.030000e+04,  3.600000e+04,  1.990000e+04,  1.058700e+06,
         3.284000e+05,  3.295000e+05,  2.818000e+05,  2.822000e+05,
         1.000000e+02, -1.940000e+04,  2.600000e+03, -5.300000e+03,
        -9.000000e+02,  1.200000e+03,  4.176000e+05, -2.350000e+04,
        -1.700000e+03,  7.100000e+03,  0.000000e+00,  0.000000e+00,
         3.300000e+03, -3.800000e+03,  1.000000e+02,  3.700000e+03,
         0.000000e+00,  0.000000e+00,  4.086000e+05,  4.149000e+05,
        -4.200000e+03, -3.200000e+03,  1.000000e+02,  0.000000e+00,
        -5.100000e+03,  2.071000e+05, -7.000000e+02, -2.020000e+04,
        -2.020000e+04, -6.200000e+03, -2.100000e+03,  1.000000e+03,
        -2.630000e+04, -2.230000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.000000e+02,  2.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -5.300000e+03, -1.940000e+04,
         5.480000e+04, -1.610000e+04,  4.000000e+02, -3.020000e+04,
        -1.860000e+04, -3.760000e+04, -4.630000e+04, -6.090000e+04,
         4.017000e+05,  3.596000e+05,  3.800000e+03, -1.630000e+04,
         1.340000e+04,  1.990000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.610000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 2.345000e+05, -3.185000e+05, -1.871000e+05, -6.160000e+05,
        -1.911000e+05,  1.143500e+06,  6.746000e+05,  2.208000e+05,
        -3.185000e+05,  2.140000e+05, -3.184000e+05, -2.630000e+04,
        -1.158000e+05,  3.953300e+06, -4.782000e+05, -4.090000e+04,
        -2.850000e+04, -1.051000e+05,  3.815500e+06,  2.918700e+06,
         3.171800e+06,  2.441500e+06, -1.417000e+06, -4.087000e+05,
         5.929900e+06,  1.941200e+06,  5.355700e+06,  1.316480e+07,
         3.609700e+06,  3.614200e+06,  3.605800e+06,  3.616600e+06,
         4.772400e+06,  3.614400e+06,  3.494470e+07,  3.300850e+07,
         3.408640e+07,  3.905000e+06,  3.602500e+06,  3.690400e+06,
        -8.094000e+05, -1.375400e+06,  4.559000e+06,  4.559100e+06,
         2.612600e+06,  6.776000e+05,  2.685000e+06,  3.098600e+06,
         7.450800e+06,  7.149900e+06, -2.582300e+06,  3.286000e+06,
        -6.673000e+05, -1.094900e+06, -1.375500e+06,  6.766200e+06,
         6.766400e+06,  6.188800e+06,  6.337000e+06,  1.089400e+06,
        -4.806000e+05, -8.185000e+05, -2.555000e+05, -8.710000e+04,
        -8.710000e+04, -8.710000e+04, -8.710000e+04, -6.598000e+05,
         3.895900e+06, -5.247000e+05, -8.052000e+05,  1.690000e+04,
        -1.935600e+06, -2.090800e+06,  3.447600e+06,  1.187700e+06,
        -2.348000e+05, -2.348000e+05, -4.782000e+05, -4.781000e+05,
        -4.782000e+05, -1.516700e+06, -2.941300e+06,  6.434300e+06,
         3.408700e+06, -4.313000e+05, -1.280900e+06, -5.235100e+06,
        -6.414000e+05, -2.645900e+06, -6.414000e+05, -2.650500e+06,
         7.267900e+06,  1.623070e+07,  2.021280e+07,  1.508320e+07,
         3.572100e+06,  3.271000e+06, -3.917200e+06,  3.789600e+06,
        -2.101000e+05, -5.109000e+05,  3.635400e+06,  7.051100e+06,
         7.279000e+05, -1.325000e+05,  8.420000e+04,  4.727200e+06,
         5.181000e+05,  4.382600e+06,  8.364700e+06,  4.005000e+05,
         2.878000e+06,  3.309800e+06,  7.485600e+06,  6.883700e+06,
         2.553700e+06, -4.658000e+05, -1.373300e+06,  3.531300e+06,
         2.582300e+06, -1.330900e+06, -5.293000e+05,  3.218300e+06,
         2.595600e+06,  6.491000e+05,  2.060000e+05,  2.059000e+05,
        -6.479000e+05,  6.875000e+05,  2.192100e+06,  2.386700e+06,
        -3.161000e+05, -3.163000e+05, -1.614000e+05, -1.615000e+05,
         3.090200e+06, -1.613000e+05, -3.596100e+06, -1.615000e+05,
        -3.414000e+05, -3.414000e+05, -3.414000e+05, -3.412000e+05,
        -3.316000e+05,  3.098000e+05,  3.096000e+05,  3.096000e+05,
         1.858400e+06,  4.988000e+05,  1.685000e+05,  9.131600e+06,
         2.410400e+06,  2.413700e+06,  1.390000e+06,  1.390200e+06,
         2.500000e+04, -1.220000e+05,  2.640000e+04,  1.991000e+05,
         3.900000e+03,  1.370000e+04,  3.953300e+06, -2.630000e+04,
         2.320000e+04, -2.781000e+05,  0.000000e+00,  1.000000e+02,
         8.860000e+04,  2.934000e+05,  2.490000e+04,  7.680000e+04,
         0.000000e+00,  0.000000e+00,  4.215400e+06,  3.947900e+06,
         2.370000e+04,  9.690000e+04,  2.410000e+04,  0.000000e+00,
         2.053000e+05,  1.962600e+06,  1.170000e+04, -1.397000e+05,
        -1.398000e+05,  2.666000e+05, -6.000000e+02,  2.460000e+04,
         1.227000e+05, -1.409000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.000000e+02, -3.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.991000e+05, -1.220000e+05,
         5.189000e+05, -3.414000e+05,  2.000000e+02,  2.345000e+05,
        -3.185000e+05, -4.781000e+05, -8.710000e+04, -5.247000e+05,
         3.616200e+06,  3.090200e+06, -1.615000e+05, -3.163000e+05,
         3.096000e+05,  1.685000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -3.414000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-3.076000e+05,  3.636000e+05, -1.909000e+05, -5.448000e+05,
        -4.252000e+05, -1.246800e+06, -6.316000e+05, -3.069000e+05,
         3.636000e+05, -3.066000e+05,  3.632000e+05, -2.885000e+05,
         1.840000e+04,  3.897200e+06, -4.122000e+05, -2.877000e+05,
         4.300000e+03, -1.154000e+06,  3.030900e+06,  4.328900e+06,
         3.205900e+06,  2.590200e+06, -6.316000e+05, -8.409000e+05,
         5.870200e+06,  1.689900e+06,  6.590800e+06,  1.345530e+07,
         3.627500e+06,  3.636100e+06,  3.630800e+06,  3.629600e+06,
         4.737400e+06,  3.636400e+06,  3.300850e+07,  3.550670e+07,
         3.324180e+07,  3.612800e+06,  4.088900e+06,  3.671100e+06,
        -9.714000e+05, -1.226000e+06,  4.685600e+06,  4.685800e+06,
         3.037900e+06,  1.414100e+06,  2.795600e+06,  3.185200e+06,
         7.418900e+06,  7.875800e+06, -3.640000e+05,  3.297500e+06,
        -8.354000e+05, -9.577000e+05, -1.226100e+06,  6.398400e+06,
         6.398700e+06,  7.235000e+06,  6.515000e+06, -6.644000e+05,
        -4.712000e+05, -6.919000e+05, -2.078000e+05, -5.743000e+05,
        -5.743000e+05, -5.742000e+05, -5.743000e+05,  9.200000e+04,
         3.602100e+06, -7.006000e+05, -3.660000e+05,  1.370000e+04,
        -1.645400e+06, -1.918000e+06,  3.459900e+06,  1.304500e+06,
        -2.047000e+05, -2.047000e+05, -4.122000e+05, -4.120000e+05,
        -4.122000e+05, -2.532500e+06, -8.654000e+05,  5.803800e+06,
         2.417800e+06, -1.101400e+06, -9.150000e+04, -3.249100e+06,
        -2.278600e+06,  5.350000e+04, -2.278600e+06,  5.070000e+04,
         6.038900e+06,  1.494100e+07,  1.911760e+07,  1.634730e+07,
         3.349900e+06,  3.809000e+06,  2.400700e+06,  3.908100e+06,
        -2.882000e+05,  1.414000e+05,  3.649600e+06,  7.087100e+06,
        -3.940000e+04,  1.001000e+06,  1.356000e+05,  4.155800e+06,
        -3.119000e+05,  2.986500e+06,  7.162300e+06, -1.189300e+06,
         5.271500e+06,  3.278100e+06,  6.971600e+06,  7.885500e+06,
         2.778200e+06, -1.129600e+06,  2.989000e+05,  3.064200e+06,
         2.816400e+06, -1.334000e+05, -1.278500e+06,  3.303100e+06,
         2.747600e+06,  1.099600e+06, -5.862000e+05, -5.862000e+05,
         4.103000e+05,  2.991500e+06,  7.065000e+05, -1.004390e+07,
        -2.505000e+05, -2.507000e+05,  8.700000e+03,  8.700000e+03,
         3.176200e+06,  9.100000e+03, -3.347100e+06,  8.700000e+03,
        -2.717000e+05, -2.717000e+05, -2.717000e+05, -2.716000e+05,
        -2.669000e+05,  2.562000e+05,  2.560000e+05,  2.561000e+05,
         1.536900e+06,  5.463000e+05,  2.774000e+05,  9.395600e+06,
         2.636200e+06,  2.639800e+06,  1.825400e+06,  1.825700e+06,
         2.110000e+04, -1.267000e+05, -3.100000e+04, -1.610000e+04,
         1.849000e+05,  1.850000e+04,  3.897200e+06, -2.885000e+05,
         5.549000e+05,  2.050000e+04,  0.000000e+00, -2.400000e+03,
         1.800000e+03, -4.680000e+04,  3.765000e+05,  6.250000e+04,
         0.000000e+00,  0.000000e+00,  3.863500e+06,  4.314700e+06,
         9.310000e+05,  1.923000e+05,  3.638000e+05,  0.000000e+00,
        -1.630000e+04,  1.935700e+06,  2.771000e+05, -1.339000e+05,
        -1.339000e+05, -1.500000e+04,  3.667000e+05,  1.760000e+04,
        -1.491000e+05,  2.325000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         3.000000e+02,  8.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.610000e+04, -1.267000e+05,
         5.115000e+05, -2.717000e+05,  3.000000e+02, -3.076000e+05,
         3.636000e+05, -4.120000e+05, -5.743000e+05, -7.006000e+05,
         3.629400e+06,  3.176200e+06,  8.700000e+03, -2.507000e+05,
         2.561000e+05,  2.774000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.717000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-2.685000e+05, -2.766000e+05,  1.650000e+06, -5.339000e+05,
        -4.006000e+05, -1.098400e+06, -5.613000e+05, -2.738000e+05,
        -2.766000e+05, -2.767000e+05, -2.765000e+05, -2.675000e+05,
        -1.059000e+05,  3.939100e+06, -4.140000e+05, -2.741000e+05,
        -2.520000e+04, -1.070100e+06,  3.125400e+06,  3.045700e+06,
         1.418320e+07,  2.618500e+06, -1.229600e+06, -8.096000e+05,
         5.846300e+06,  1.643800e+06,  5.814600e+06,  1.369720e+07,
         3.644300e+06,  3.649000e+06,  3.641200e+06,  3.651000e+06,
         4.779000e+06,  3.649300e+06,  3.408640e+07,  3.324180e+07,
         6.547140e+07,  3.665000e+06,  3.635200e+06,  9.826200e+06,
        -9.364000e+05, -1.199100e+06,  4.714500e+06,  4.714500e+06,
         2.772500e+06,  8.424000e+05,  6.473600e+06,  3.197500e+06,
         7.494000e+06,  7.465600e+06, -2.244400e+06,  3.351000e+06,
        -8.123000e+05, -9.484000e+05, -1.206200e+06,  6.436700e+06,
         6.437000e+06,  6.401500e+06,  1.875910e+07, -6.084000e+05,
        -5.111000e+05, -7.081000e+05, -2.214000e+05, -5.391000e+05,
        -5.391000e+05, -5.390000e+05, -5.391000e+05, -5.691000e+05,
         3.658500e+06, -6.885000e+05, -6.969000e+05,  2.030000e+04,
        -1.927900e+06, -1.944400e+06,  3.497100e+06,  1.286100e+06,
         6.173000e+05,  6.173000e+05, -4.140000e+05, -4.139000e+05,
        -4.140000e+05, -2.472200e+06, -2.539700e+06,  5.908700e+06,
         2.522000e+06, -1.051700e+06, -1.089400e+06, -5.030700e+06,
        -2.172800e+06, -2.277900e+06, -2.172800e+06, -2.284100e+06,
         6.169200e+06,  1.518240e+07,  1.937870e+07,  1.512010e+07,
         3.381700e+06,  3.353100e+06, -3.385300e+06,  3.925100e+06,
        -2.860000e+05, -3.145000e+05,  3.673500e+06,  7.135800e+06,
         5.480000e+04,  7.300000e+03,  1.853840e+07,  4.265400e+06,
        -2.609000e+05,  3.141600e+06,  7.338500e+06, -1.055300e+06,
         2.999600e+06,  3.394770e+07,  7.055900e+06,  6.999100e+06,
         2.732700e+06, -1.093000e+06, -1.182500e+06,  3.115400e+06,
         2.764100e+06, -1.146000e+06, -1.129600e+06,  3.299400e+06,
         2.757900e+06,  8.159000e+05, -5.242000e+05, -5.243000e+05,
        -5.604000e+05,  1.056400e+06,  1.198400e+06, -9.173400e+06,
        -2.641000e+05, -2.643000e+05, -1.210000e+04, -1.220000e+04,
         3.188800e+06, -1.180000e+04, -3.380900e+06, -1.220000e+04,
        -2.926000e+05, -2.926000e+05, -2.926000e+05, -2.924000e+05,
        -2.873000e+05,  2.658000e+05,  2.656000e+05,  2.656000e+05,
         1.594300e+06,  5.482000e+05,  2.678000e+05,  9.438800e+06,
         2.606900e+06,  2.610400e+06,  1.733300e+06,  1.733700e+06,
         2.840000e+04, -1.097000e+05, -6.910000e+04, -2.690000e+04,
         3.200000e+03,  4.103000e+05,  3.939100e+06, -2.675000e+05,
         1.790000e+04, -1.000000e+03,  0.000000e+00,  1.000000e+02,
         2.950000e+06, -6.500000e+04, -7.330000e+04,  6.660000e+04,
         0.000000e+00,  0.000000e+00,  3.929300e+06,  3.932300e+06,
         1.630000e+04,  6.600000e+03, -7.080000e+04,  0.000000e+00,
        -2.430000e+04,  1.954700e+06,  9.100000e+03, -1.284000e+05,
        -1.284000e+05, -3.100000e+03, -8.600000e+03,  4.313000e+05,
        -1.336000e+05, -1.373000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         3.000000e+02, -7.200000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -2.690000e+04, -1.097000e+05,
         5.170000e+05, -2.926000e+05,  3.000000e+02, -2.685000e+05,
        -2.766000e+05, -4.139000e+05, -5.391000e+05, -6.885000e+05,
         3.650600e+06,  3.188800e+06, -1.220000e+04, -2.643000e+05,
         2.656000e+05,  2.678000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.926000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.033000e+05, -3.720000e+04, -1.570000e+04, -7.910000e+04,
         1.190000e+04,  4.655000e+05,  2.591000e+05,  9.980000e+04,
        -3.720000e+04,  9.820000e+04, -3.720000e+04,  3.780000e+04,
        -1.190000e+04,  4.343000e+05, -5.950000e+04,  3.430000e+04,
        -3.200000e+03,  1.511000e+05,  5.309000e+05,  3.138000e+05,
         3.510000e+05,  2.483000e+05, -1.763000e+05,  2.490000e+04,
         6.930000e+05,  2.903000e+05,  5.506000e+05,  1.403100e+06,
         3.940000e+05,  3.947000e+05,  3.940000e+05,  3.945000e+05,
         5.229000e+05,  3.951000e+05,  3.905000e+06,  3.612800e+06,
         3.665000e+06,  4.957000e+05,  3.961000e+05,  4.357000e+05,
        -6.760000e+04, -1.787000e+05,  4.856000e+05,  4.856000e+05,
         2.716000e+05,  5.870000e+04,  2.827000e+05,  3.321000e+05,
         8.323000e+05,  7.447000e+05, -3.254000e+05,  3.501000e+05,
        -4.760000e+04, -1.387000e+05, -1.788000e+05,  8.131000e+05,
         8.134000e+05,  6.683000e+05,  6.931000e+05,  3.653000e+05,
        -5.920000e+04, -9.940000e+04, -2.940000e+04,  6.410000e+04,
         6.410000e+04,  6.410000e+04,  6.410000e+04, -7.730000e+04,
         4.666000e+05, -2.730000e+04, -9.770000e+04,  3.000000e+02,
        -2.142000e+05, -2.522000e+05,  3.721000e+05,  1.239000e+05,
        -2.490000e+04, -2.490000e+04, -5.950000e+04, -5.950000e+04,
        -5.950000e+04,  1.400000e+03, -3.512000e+05,  8.031000e+05,
         5.161000e+05,  5.660000e+04, -1.533000e+05, -5.878000e+05,
         1.840000e+05, -3.109000e+05,  1.840000e+05, -3.103000e+05,
         9.892000e+05,  1.943600e+06,  2.345900e+06,  1.659300e+06,
         4.277000e+05,  3.388000e+05, -4.570000e+05,  3.951000e+05,
        -7.600000e+03, -8.010000e+04,  3.957000e+05,  7.662000e+05,
         1.774000e+05, -3.520000e+04, -2.600000e+03,  5.800000e+05,
         1.751000e+05,  6.947000e+05,  1.090400e+06,  2.989000e+05,
         2.566000e+05,  3.947000e+05,  8.954000e+05,  7.202000e+05,
         2.704000e+05,  5.580000e+04, -2.430000e+05,  4.588000e+05,
         2.740000e+05, -1.557000e+05,  4.430000e+04,  3.490000e+05,
         2.697000e+05,  5.570000e+04,  1.387000e+05,  1.387000e+05,
        -7.520000e+04,  5.090000e+04,  4.890000e+05,  2.093200e+06,
        -3.880000e+04, -3.890000e+04, -3.930000e+04, -3.940000e+04,
         3.306000e+05, -3.900000e+04, -4.334000e+05, -3.940000e+04,
        -4.010000e+04, -4.010000e+04, -4.010000e+04, -4.010000e+04,
        -3.790000e+04,  3.570000e+04,  3.570000e+04,  3.570000e+04,
         2.143000e+05,  3.980000e+04,  2.000000e+02,  9.720000e+05,
         2.513000e+05,  2.523000e+05,  1.326000e+05,  1.329000e+05,
         1.500000e+03, -1.660000e+04,  3.200000e+03,  5.060000e+04,
         2.000000e+02,  5.000000e+02,  4.343000e+05,  3.780000e+04,
         2.800000e+03, -7.120000e+04,  0.000000e+00,  0.000000e+00,
         1.260000e+04,  6.980000e+04,  3.200000e+03,  8.900000e+03,
         0.000000e+00,  0.000000e+00,  5.051000e+05,  4.342000e+05,
         3.000000e+03,  2.370000e+04,  3.100000e+03,  0.000000e+00,
         5.250000e+04,  2.158000e+05,  1.600000e+03, -2.000000e+04,
        -2.000000e+04,  6.650000e+04, -2.000000e+02,  3.200000e+03,
         4.580000e+04, -2.030000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         3.000000e+02, -2.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  5.060000e+04, -1.660000e+04,
         5.700000e+04, -4.010000e+04,  3.000000e+02,  1.033000e+05,
        -3.720000e+04, -5.950000e+04,  6.410000e+04, -2.730000e+04,
         3.945000e+05,  3.306000e+05, -3.940000e+04, -3.890000e+04,
         3.570000e+04,  2.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -4.010000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-3.260000e+04,  1.326000e+05, -1.690000e+04, -6.130000e+04,
        -4.680000e+04, -1.337000e+05, -6.850000e+04, -3.240000e+04,
         1.326000e+05, -3.230000e+04,  1.325000e+05, -2.840000e+04,
         2.140000e+04,  4.217000e+05, -4.310000e+04, -2.820000e+04,
         5.000000e+03, -1.135000e+05,  3.375000e+05,  6.635000e+05,
         3.620000e+05,  2.848000e+05,  2.020000e+04, -7.910000e+04,
         6.721000e+05,  2.228000e+05,  8.507000e+05,  1.474700e+06,
         3.980000e+05,  3.983000e+05,  3.985000e+05,  3.985000e+05,
         5.155000e+05,  3.987000e+05,  3.602500e+06,  4.088900e+06,
         3.635200e+06,  3.961000e+05,  5.679000e+05,  4.043000e+05,
        -1.083000e+05, -1.413000e+05,  5.155000e+05,  5.155000e+05,
         3.763000e+05,  2.416000e+05,  3.107000e+05,  3.520000e+05,
         8.188000e+05,  9.627000e+05,  2.665000e+05,  3.545000e+05,
        -8.970000e+04, -1.044000e+05, -1.413000e+05,  7.166000e+05,
         7.170000e+05,  9.244000e+05,  7.329000e+05, -7.500000e+04,
        -5.690000e+04, -6.790000e+04, -1.810000e+04, -5.590000e+04,
        -5.590000e+04, -5.590000e+04, -5.590000e+04,  1.090000e+05,
         3.931000e+05, -7.120000e+04,  1.130000e+04,  6.000000e+02,
        -1.407000e+05, -2.072000e+05,  3.759000e+05,  1.498000e+05,
        -1.790000e+04, -1.790000e+04, -4.310000e+04, -4.300000e+04,
        -4.310000e+04, -2.494000e+05,  1.629000e+05,  6.459000e+05,
         2.654000e+05, -1.055000e+05,  1.425000e+05, -9.230000e+04,
        -2.185000e+05,  3.586000e+05, -2.185000e+05,  3.584000e+05,
         6.794000e+05,  1.618500e+06,  2.067400e+06,  1.966900e+06,
         3.712000e+05,  5.181000e+05,  1.113500e+06,  4.244000e+05,
        -2.550000e+04,  8.300000e+04,  3.995000e+05,  7.734000e+05,
        -1.050000e+04,  2.476000e+05,  1.400000e+04,  4.394000e+05,
        -3.620000e+04,  3.307000e+05,  7.789000e+05, -1.175000e+05,
         1.050500e+06,  3.716000e+05,  7.659000e+05,  1.053900e+06,
         3.278000e+05, -1.068000e+05,  4.086000e+05,  3.430000e+05,
         3.282000e+05,  1.403000e+05, -1.467000e+05,  3.732000e+05,
         3.063000e+05,  1.670000e+05, -5.920000e+04, -5.920000e+04,
         1.878000e+05,  6.209000e+05, -9.890000e+04, -1.004500e+06,
        -2.240000e+04, -2.250000e+04,  2.300000e+03,  2.300000e+03,
         3.505000e+05,  2.700000e+03, -3.701000e+05,  2.300000e+03,
        -2.360000e+04, -2.360000e+04, -2.360000e+04, -2.360000e+04,
        -2.350000e+04,  2.150000e+04,  2.150000e+04,  2.150000e+04,
         1.291000e+05,  4.910000e+04,  2.570000e+04,  1.033100e+06,
         3.043000e+05,  3.053000e+05,  2.353000e+05,  2.356000e+05,
         1.400000e+03, -1.750000e+04, -1.130000e+04, -3.500000e+03,
         4.580000e+04,  1.700000e+03,  4.217000e+05, -2.840000e+04,
         1.358000e+05,  4.700000e+03,  0.000000e+00, -6.000000e+02,
        -7.500000e+03, -1.520000e+04,  9.120000e+04,  5.400000e+03,
         0.000000e+00,  0.000000e+00,  4.157000e+05,  5.263000e+05,
         2.302000e+05,  4.770000e+04,  8.810000e+04,  0.000000e+00,
        -3.200000e+03,  2.116000e+05,  6.800000e+04, -1.840000e+04,
        -1.840000e+04, -3.900000e+03,  9.180000e+04,  1.600000e+03,
        -2.220000e+04,  7.340000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.000000e+02,  1.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.500000e+03, -1.750000e+04,
         5.530000e+04, -2.360000e+04,  4.000000e+02, -3.260000e+04,
         1.326000e+05, -4.300000e+04, -5.590000e+04, -7.120000e+04,
         3.985000e+05,  3.505000e+05,  2.300000e+03, -2.250000e+04,
         2.150000e+04,  2.570000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.360000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-2.250000e+04, -2.670000e+04,  4.436000e+05, -5.860000e+04,
        -4.050000e+04, -9.490000e+04, -4.990000e+04, -2.380000e+04,
        -2.670000e+04, -2.450000e+04, -2.670000e+04, -2.250000e+04,
        -9.400000e+03,  4.307000e+05, -4.350000e+04, -2.390000e+04,
        -2.300000e+03, -9.020000e+04,  3.584000e+05,  3.455000e+05,
         3.103800e+06,  2.926000e+05, -1.294000e+05, -7.530000e+04,
         6.721000e+05,  2.160000e+05,  6.653000e+05,  1.536200e+06,
         4.027000e+05,  4.034000e+05,  4.028000e+05,  4.031000e+05,
         5.246000e+05,  4.038000e+05,  3.690400e+06,  3.671100e+06,
         9.826200e+06,  4.357000e+05,  4.043000e+05,  2.497000e+06,
        -9.930000e+04, -1.346000e+05,  5.244000e+05,  5.245000e+05,
         3.115000e+05,  9.990000e+04,  1.229800e+06,  3.568000e+05,
         8.431000e+05,  8.237000e+05, -2.409000e+05,  3.664000e+05,
        -8.380000e+04, -1.021000e+05, -1.365000e+05,  7.307000e+05,
         7.311000e+05,  7.215000e+05,  3.798600e+06, -5.920000e+04,
        -6.680000e+04, -7.180000e+04, -2.090000e+04, -4.890000e+04,
        -4.890000e+04, -4.890000e+04, -4.890000e+04, -5.460000e+04,
         4.072000e+05, -6.830000e+04, -7.070000e+04,  1.200000e+03,
        -2.123000e+05, -2.156000e+05,  3.845000e+05,  1.485000e+05,
         1.881000e+05,  1.881000e+05, -4.350000e+04, -4.350000e+04,
        -4.350000e+04, -2.374000e+05, -2.508000e+05,  6.717000e+05,
         2.944000e+05, -9.850000e+04, -1.054000e+05, -5.367000e+05,
        -1.989000e+05, -2.189000e+05, -1.989000e+05, -2.187000e+05,
         7.145000e+05,  1.681500e+06,  2.137400e+06,  1.668500e+06,
         3.800000e+05,  3.593000e+05, -3.240000e+05,  4.290000e+05,
        -2.660000e+04, -3.100000e+04,  4.052000e+05,  7.874000e+05,
         9.100000e+03, -3.000000e+02,  4.611000e+06,  4.646000e+05,
        -1.970000e+04,  3.844000e+05,  8.339000e+05, -6.510000e+04,
         2.870000e+05,  8.054200e+06,  7.880000e+05,  7.491000e+05,
         3.152000e+05, -1.010000e+05, -1.953000e+05,  3.548000e+05,
         3.195000e+05, -1.095000e+05, -1.058000e+05,  3.693000e+05,
         3.103000e+05,  9.740000e+04, -4.380000e+04, -4.390000e+04,
        -5.330000e+04,  1.432000e+05,  2.405000e+05, -7.969000e+05,
        -2.590000e+04, -2.590000e+04, -2.000000e+03, -2.000000e+03,
         3.553000e+05, -1.700000e+03, -3.796000e+05, -2.000000e+03,
        -2.790000e+04, -2.790000e+04, -2.790000e+04, -2.790000e+04,
        -2.680000e+04,  2.470000e+04,  2.470000e+04,  2.470000e+04,
         1.483000e+05,  5.210000e+04,  2.510000e+04,  1.048800e+06,
         3.004000e+05,  3.015000e+05,  2.184000e+05,  2.188000e+05,
         2.400000e+03, -1.350000e+04, -2.070000e+04, -5.900000e+03,
         0.000000e+00,  9.970000e+04,  4.307000e+05, -2.250000e+04,
         1.500000e+03, -1.900000e+03,  0.000000e+00,  0.000000e+00,
         7.280000e+05, -1.980000e+04, -2.140000e+04,  6.300000e+03,
         0.000000e+00,  0.000000e+00,  4.335000e+05,  4.303000e+05,
         1.200000e+03,  1.100000e+03, -2.070000e+04,  0.000000e+00,
        -4.900000e+03,  2.138000e+05,  9.000000e+02, -1.710000e+04,
        -1.710000e+04, -9.000000e+02, -2.200000e+03,  1.049000e+05,
        -1.830000e+04, -1.940000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.000000e+02, -1.900000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -5.900000e+03, -1.350000e+04,
         5.650000e+04, -2.790000e+04,  4.000000e+02, -2.250000e+04,
        -2.670000e+04, -4.350000e+04, -4.890000e+04, -6.830000e+04,
         4.031000e+05,  3.553000e+05, -2.000000e+03, -2.590000e+04,
         2.470000e+04,  2.510000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.790000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 8.790000e+04,  4.500000e+03,  2.270000e+04,  1.027500e+06,
         5.728000e+05,  3.782000e+05,  2.025000e+05,  8.630000e+04,
         4.500000e+03,  8.570000e+04,  4.500000e+03,  5.570000e+04,
         5.900000e+03, -1.205000e+05,  5.123000e+05,  5.430000e+04,
         1.200000e+03,  2.226000e+05,  3.630000e+04, -8.420000e+04,
        -5.900000e+04,  1.376700e+06,  1.514300e+06,  1.215000e+05,
        -6.000000e+04,  1.130000e+05, -1.410000e+05,  8.863900e+06,
        -1.016000e+05, -1.018000e+05, -1.016000e+05, -1.018000e+05,
        -1.413000e+05, -1.018000e+05, -8.094000e+05, -9.714000e+05,
        -9.364000e+05, -6.760000e+04, -1.083000e+05, -9.930000e+04,
         1.627200e+06,  2.573800e+06,  8.247000e+05,  8.247000e+05,
         8.858000e+05,  9.521000e+05,  8.981000e+05,  3.913000e+05,
         1.753400e+06,  1.712900e+06,  2.018200e+06,  8.587000e+05,
         1.086700e+06,  1.540900e+06,  2.527500e+06, -7.980000e+04,
        -7.990000e+04, -1.603000e+05, -1.433000e+05,  2.564000e+05,
         4.641000e+05,  5.093000e+05,  1.520000e+04,  1.047000e+05,
         1.047000e+05,  1.047000e+05,  1.047000e+05,  2.340000e+04,
        -6.840000e+04,  5.465000e+05,  5.062000e+05, -1.490000e+04,
         3.990000e+04,  2.810000e+04,  3.783000e+05,  2.037000e+05,
         1.820000e+04,  1.820000e+04,  5.123000e+05,  5.121000e+05,
         5.123000e+05,  1.268100e+06,  1.066600e+06,  9.196000e+05,
         1.025700e+06,  1.452000e+05,  2.380000e+04,  1.329000e+05,
         3.845000e+05,  1.002000e+05,  3.845000e+05,  1.009000e+05,
         3.940000e+04, -3.090000e+05, -4.819000e+05, -4.711000e+05,
        -4.970000e+04, -9.020000e+04,  8.900000e+04, -1.389000e+05,
         3.400000e+04, -6.000000e+03, -1.168000e+05,  2.702000e+05,
         8.150000e+04, -3.970000e+04, -1.370000e+04, -9.150000e+04,
         1.104000e+05,  1.062000e+05, -6.720000e+04,  2.796000e+05,
        -9.620000e+04, -5.250000e+04, -1.184000e+05, -1.994000e+05,
        -4.410000e+04,  1.750000e+05,  5.280000e+04,  2.200000e+03,
        -4.480000e+04,  5.410000e+04,  1.713000e+05, -8.150000e+04,
         8.919000e+05,  9.530000e+05,  1.405000e+05,  1.405000e+05,
         1.610000e+04, -1.160000e+04,  1.908000e+05,  2.279300e+06,
         3.800000e+03,  3.800000e+03, -1.810000e+04, -1.810000e+04,
         3.880000e+05, -1.810000e+04,  4.670000e+04, -1.810000e+04,
         1.900000e+04,  1.900000e+04,  1.900000e+04,  1.890000e+04,
         1.950000e+04, -3.270000e+04, -3.270000e+04, -3.270000e+04,
        -1.962000e+05, -5.360000e+04, -3.580000e+04,  1.651100e+06,
         4.270000e+05,  4.281000e+05,  4.849000e+05,  4.849000e+05,
        -1.520000e+04,  4.615000e+05, -2.650000e+04,  2.600000e+04,
        -4.400000e+03, -4.000000e+02, -1.205000e+05,  5.570000e+04,
        -1.710000e+04, -3.550000e+04,  0.000000e+00, -9.000000e+02,
        -2.010000e+04,  4.900000e+03, -3.320000e+04, -4.600000e+03,
         0.000000e+00,  0.000000e+00, -8.610000e+04, -1.274000e+05,
        -2.460000e+04,  5.500000e+03, -3.210000e+04,  0.000000e+00,
         2.670000e+04, -6.000000e+04, -8.500000e+03,  4.867000e+05,
         4.865000e+05,  2.660000e+04, -1.240000e+04, -2.800000e+03,
         5.059000e+05,  4.731000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -4.800000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.600000e+04,  4.615000e+05,
        -1.580000e+04,  1.900000e+04,  0.000000e+00,  8.790000e+04,
         4.500000e+03,  5.121000e+05,  1.047000e+05,  5.465000e+05,
        -1.018000e+05,  3.880000e+05, -1.810000e+04,  3.800000e+03,
        -3.270000e+04, -3.580000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.900000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-1.000000e+05, -2.710000e+04, -1.490000e+04,  1.738200e+06,
         8.144000e+05, -4.297000e+05, -2.297000e+05, -9.770000e+04,
        -2.710000e+04, -9.660000e+04, -2.710000e+04, -6.120000e+04,
        -1.050000e+04, -1.216000e+05,  8.382000e+05, -5.890000e+04,
        -2.100000e+03, -2.450000e+05, -2.945000e+05, -1.819000e+05,
        -1.623000e+05,  2.332100e+06,  2.487600e+06, -1.315000e+05,
        -4.048000e+05, -3.418000e+05, -3.305000e+05,  1.479510e+07,
        -1.358000e+05, -1.361000e+05, -1.356000e+05, -1.362000e+05,
        -1.593000e+05, -1.360000e+05, -1.375400e+06, -1.226000e+06,
        -1.199100e+06, -1.787000e+05, -1.413000e+05, -1.346000e+05,
         2.573800e+06,  4.387800e+06,  1.422400e+06,  1.422400e+06,
         1.488000e+06,  1.561800e+06,  1.500600e+06,  6.732000e+05,
         2.877000e+06,  2.914500e+06,  3.242400e+06,  1.531600e+06,
         1.650900e+06,  2.578400e+06,  4.317800e+06, -3.997000e+05,
        -3.996000e+05, -3.258000e+05, -3.116000e+05, -2.899000e+05,
         7.639000e+05,  7.764000e+05, -1.130000e+04, -1.157000e+05,
        -1.157000e+05, -1.157000e+05, -1.157000e+05, -4.130000e+04,
        -1.785000e+05,  7.534000e+05,  7.917000e+05, -1.260000e+04,
         4.420000e+04,  6.890000e+04,  6.959000e+05,  3.066000e+05,
        -1.280000e+04, -1.280000e+04,  8.382000e+05,  8.380000e+05,
         8.382000e+05,  1.318700e+06,  1.507300e+06,  1.189000e+06,
         1.281600e+06, -2.130000e+05, -1.005000e+05,  1.060000e+04,
        -4.193000e+05, -1.586000e+05, -4.193000e+05, -1.585000e+05,
        -5.413000e+05, -6.835000e+05, -7.462000e+05, -5.348000e+05,
        -1.938000e+05, -1.563000e+05, -3.022000e+05, -9.820000e+04,
        -3.390000e+04,  3.700000e+03, -1.482000e+05,  5.507000e+05,
        -1.077000e+05,  4.700000e+03,  2.450000e+04, -1.720000e+05,
        -1.527000e+05, -3.786000e+05, -4.418000e+05, -3.153000e+05,
        -1.913000e+05, -1.583000e+05, -3.734000e+05, -2.985000e+05,
        -1.759000e+05, -1.879000e+05, -7.560000e+04, -2.519000e+05,
        -1.780000e+05, -7.600000e+04, -1.767000e+05, -1.467000e+05,
         1.493300e+06,  1.558900e+06, -1.583000e+05, -1.583000e+05,
        -4.760000e+04, -2.019000e+05, -3.892000e+05, -2.551600e+06,
        -2.640000e+04, -2.640000e+04,  2.390000e+04,  2.390000e+04,
         6.683000e+05,  2.400000e+04,  1.981000e+05,  2.390000e+04,
        -1.420000e+04, -1.420000e+04, -1.420000e+04, -1.420000e+04,
        -1.570000e+04, -1.000000e+03, -1.000000e+03, -1.000000e+03,
        -5.800000e+03,  5.400000e+04,  3.890000e+04,  2.864300e+06,
         6.417000e+05,  6.435000e+05,  6.012000e+05,  6.013000e+05,
        -1.220000e+04,  8.030000e+05, -4.430000e+04, -2.870000e+04,
        -3.400000e+03,  3.700000e+03, -1.216000e+05, -6.120000e+04,
        -1.820000e+04,  4.210000e+04,  0.000000e+00, -1.400000e+03,
        -3.540000e+04, -8.490000e+04, -5.020000e+04,  3.400000e+03,
         0.000000e+00,  0.000000e+00, -1.630000e+05, -1.275000e+05,
        -2.530000e+04, -1.990000e+04, -4.850000e+04,  0.000000e+00,
        -2.970000e+04, -5.980000e+04, -9.100000e+03,  8.589000e+05,
         8.586000e+05, -4.350000e+04, -1.000000e+04, -7.000000e+02,
         8.020000e+05,  8.469000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.000000e+02, -2.900000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -2.870000e+04,  8.030000e+05,
        -1.600000e+04, -1.420000e+04,  1.000000e+02, -1.000000e+05,
        -2.710000e+04,  8.380000e+05, -1.157000e+05,  7.534000e+05,
        -1.362000e+05,  6.683000e+05,  2.390000e+04, -2.640000e+04,
        -1.000000e+03,  3.890000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.420000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-7.210000e+04, -6.400000e+03,  4.300000e+03,  5.739000e+05,
         2.504000e+05, -3.197000e+05, -1.757000e+05, -6.990000e+04,
        -6.400000e+03, -6.900000e+04, -6.400000e+03, -3.270000e+04,
        -5.000000e+02,  5.137000e+05,  3.016000e+05, -3.080000e+04,
         1.000000e+02, -1.308000e+05,  4.297000e+05,  5.219000e+05,
         5.462000e+05,  1.517600e+06,  8.848000e+05, -4.180000e+04,
         1.057300e+06,  5.140000e+05,  1.120500e+06,  9.020100e+06,
         5.266000e+05,  5.276000e+05,  5.267000e+05,  5.259000e+05,
         6.484000e+05,  5.277000e+05,  4.559000e+06,  4.685600e+06,
         4.714500e+06,  4.856000e+05,  5.155000e+05,  5.244000e+05,
         8.247000e+05,  1.422400e+06,  1.512900e+06,  1.512400e+06,
         1.201600e+06,  8.899000e+05,  1.193900e+06,  8.928000e+05,
         2.676400e+06,  2.706700e+06,  1.152800e+06,  1.152600e+06,
         5.517000e+05,  8.761000e+05,  1.422900e+06,  1.008500e+06,
         1.008600e+06,  1.071600e+06,  1.086200e+06, -2.394000e+05,
         3.291000e+05,  3.309000e+05,  1.000000e+04, -5.690000e+04,
        -5.690000e+04, -5.690000e+04, -5.690000e+04,  6.300000e+03,
         4.871000e+05,  2.801000e+05,  3.121000e+05, -1.570000e+04,
        -2.986000e+05, -2.528000e+05,  8.483000e+05,  5.043000e+05,
         7.600000e+03,  7.600000e+03,  3.016000e+05,  3.015000e+05,
         3.016000e+05,  4.905000e+05,  6.464000e+05,  1.618900e+06,
         1.017300e+06, -1.031000e+05, -1.160000e+04, -5.760000e+05,
        -1.857000e+05,  3.560000e+04, -1.857000e+05,  3.480000e+04,
         8.940000e+05,  1.920400e+06,  2.464200e+06,  2.046800e+06,
         4.995000e+05,  5.298000e+05, -2.110000e+04,  5.385000e+05,
        -5.000000e+03,  2.600000e+04,  5.104000e+05,  1.408400e+06,
        -1.037000e+05, -5.900000e+03,  1.290000e+04,  4.401000e+05,
        -1.349000e+05,  3.446000e+05,  8.895000e+05, -2.003000e+05,
         4.960000e+05,  5.389000e+05,  9.864000e+05,  1.046900e+06,
         5.576000e+05, -7.160000e+04,  1.810000e+04,  4.714000e+05,
         5.650000e+05,  2.230000e+04, -8.000000e+04,  5.293000e+05,
         1.219900e+06,  9.091000e+05, -1.022000e+05, -1.022000e+05,
        -3.100000e+03,  4.312000e+05,  2.798000e+05, -1.578400e+06,
        -4.200000e+03, -4.200000e+03,  2.300000e+04,  2.300000e+04,
         9.017000e+05,  2.310000e+04, -4.943000e+05,  2.300000e+04,
         1.270000e+04,  1.270000e+04,  1.270000e+04,  1.270000e+04,
         1.220000e+04, -1.960000e+04, -1.960000e+04, -1.960000e+04,
        -1.176000e+05, -5.400000e+03,  8.800000e+03,  2.977000e+06,
         9.244000e+05,  9.214000e+05,  9.597000e+05,  9.598000e+05,
        -1.680000e+04,  2.585000e+05, -1.800000e+04, -3.060000e+04,
        -5.400000e+03,  1.300000e+03,  5.137000e+05, -3.270000e+04,
        -1.950000e+04,  4.360000e+04,  0.000000e+00, -1.000000e+02,
        -1.600000e+04, -6.180000e+04, -2.790000e+04, -3.000000e+03,
         0.000000e+00,  0.000000e+00,  4.743000e+05,  5.038000e+05,
        -2.940000e+04, -2.010000e+04, -2.690000e+04,  0.000000e+00,
        -3.150000e+04,  2.540000e+05, -9.700000e+03,  2.733000e+05,
         2.733000e+05, -4.620000e+04, -1.210000e+04, -2.200000e+03,
         2.288000e+05,  2.614000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.000000e+02, -2.400000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.060000e+04,  2.585000e+05,
         6.740000e+04,  1.270000e+04,  1.000000e+02, -7.210000e+04,
        -6.400000e+03,  3.015000e+05, -5.690000e+04,  2.801000e+05,
         5.260000e+05,  9.017000e+05,  2.300000e+04, -4.200000e+03,
        -1.960000e+04,  8.800000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.270000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-7.210000e+04, -6.500000e+03,  4.300000e+03,  5.739000e+05,
         2.504000e+05, -3.197000e+05, -1.757000e+05, -6.990000e+04,
        -6.500000e+03, -6.900000e+04, -6.400000e+03, -3.270000e+04,
        -6.000000e+02,  5.137000e+05,  3.016000e+05, -3.080000e+04,
         1.000000e+02, -1.308000e+05,  4.297000e+05,  5.221000e+05,
         5.463000e+05,  1.517400e+06,  8.851000e+05, -4.180000e+04,
         1.057400e+06,  5.140000e+05,  1.120500e+06,  9.018900e+06,
         5.266000e+05,  5.276000e+05,  5.267000e+05,  5.259000e+05,
         6.484000e+05,  5.277000e+05,  4.559100e+06,  4.685800e+06,
         4.714500e+06,  4.856000e+05,  5.155000e+05,  5.245000e+05,
         8.247000e+05,  1.422400e+06,  1.512400e+06,  1.518200e+06,
         1.201700e+06,  8.901000e+05,  1.193700e+06,  8.926000e+05,
         2.683100e+06,  2.713400e+06,  1.130900e+06,  1.152300e+06,
         5.517000e+05,  8.761000e+05,  1.422900e+06,  1.008500e+06,
         1.008600e+06,  1.071700e+06,  1.086200e+06, -2.394000e+05,
         3.292000e+05,  3.309000e+05,  1.000000e+04, -5.690000e+04,
        -5.690000e+04, -5.690000e+04, -5.690000e+04,  6.300000e+03,
         4.871000e+05,  2.801000e+05,  3.120000e+05, -1.570000e+04,
        -3.006000e+05, -2.528000e+05,  8.482000e+05,  5.046000e+05,
         7.600000e+03,  7.600000e+03,  3.016000e+05,  3.015000e+05,
         3.016000e+05,  4.905000e+05,  6.463000e+05,  1.618900e+06,
         1.017400e+06, -1.031000e+05, -1.170000e+04, -5.798000e+05,
        -1.856000e+05,  3.550000e+04, -1.857000e+05,  3.470000e+04,
         8.940000e+05,  1.920400e+06,  2.464200e+06,  2.046800e+06,
         4.996000e+05,  5.298000e+05, -2.120000e+04,  5.385000e+05,
        -5.000000e+03,  2.600000e+04,  5.104000e+05,  1.408200e+06,
        -1.037000e+05, -5.900000e+03,  1.290000e+04,  4.401000e+05,
        -1.349000e+05,  3.446000e+05,  8.895000e+05, -2.003000e+05,
         4.962000e+05,  5.389000e+05,  9.864000e+05,  1.047000e+06,
         5.576000e+05, -7.160000e+04,  1.820000e+04,  4.714000e+05,
         5.650000e+05,  2.220000e+04, -8.020000e+04,  5.293000e+05,
         1.219600e+06,  9.031000e+05, -1.022000e+05, -1.022000e+05,
        -3.100000e+03,  4.312000e+05,  2.796000e+05, -1.578400e+06,
        -4.300000e+03, -4.200000e+03,  2.300000e+04,  2.300000e+04,
         9.019000e+05,  2.310000e+04, -4.943000e+05,  2.300000e+04,
         1.270000e+04,  1.270000e+04,  1.270000e+04,  1.270000e+04,
         1.220000e+04, -1.960000e+04, -1.950000e+04, -1.950000e+04,
        -1.173000e+05, -5.400000e+03,  8.800000e+03,  2.977400e+06,
         9.245000e+05,  9.213000e+05,  9.596000e+05,  9.597000e+05,
        -1.680000e+04,  2.585000e+05, -1.800000e+04, -3.060000e+04,
        -5.500000e+03,  1.300000e+03,  5.137000e+05, -3.270000e+04,
        -1.960000e+04,  4.360000e+04,  0.000000e+00,  0.000000e+00,
        -1.600000e+04, -6.180000e+04, -2.790000e+04, -3.000000e+03,
         0.000000e+00,  0.000000e+00,  4.743000e+05,  5.039000e+05,
        -2.940000e+04, -2.010000e+04, -2.690000e+04,  0.000000e+00,
        -3.150000e+04,  2.540000e+05, -9.700000e+03,  2.733000e+05,
         2.733000e+05, -4.620000e+04, -1.210000e+04, -2.200000e+03,
         2.288000e+05,  2.614000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.000000e+02, -2.400000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.060000e+04,  2.585000e+05,
         6.740000e+04,  1.270000e+04,  1.000000e+02, -7.210000e+04,
        -6.500000e+03,  3.015000e+05, -5.690000e+04,  2.801000e+05,
         5.260000e+05,  9.019000e+05,  2.300000e+04, -4.200000e+03,
        -1.950000e+04,  8.800000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.270000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-5.040000e+04,  1.810000e+05,  2.700000e+04,  6.068000e+05,
         2.776000e+05, -2.374000e+05, -1.366000e+05, -4.810000e+04,
         1.810000e+05, -4.700000e+04,  1.809000e+05, -5.700000e+03,
         4.280000e+04,  2.723000e+05,  3.352000e+05, -3.400000e+03,
         1.010000e+04, -2.290000e+04,  2.696000e+05,  5.863000e+05,
         3.895000e+05,  1.348500e+06,  1.182300e+06,  4.540000e+04,
         8.024000e+05,  5.279000e+05,  1.028200e+06,  8.119900e+06,
         3.191000e+05,  3.198000e+05,  3.195000e+05,  3.184000e+05,
         3.636000e+05,  3.199000e+05,  2.612600e+06,  3.037900e+06,
         2.772500e+06,  2.716000e+05,  3.763000e+05,  3.115000e+05,
         8.858000e+05,  1.488000e+06,  1.201600e+06,  1.201700e+06,
         1.212100e+06,  1.052900e+06,  1.028900e+06,  6.936000e+05,
         2.195100e+06,  2.300200e+06,  2.351900e+06,  9.325000e+05,
         6.113000e+05,  9.427000e+05,  1.487100e+06,  6.822000e+05,
         6.824000e+05,  8.984000e+05,  7.622000e+05, -2.087000e+05,
         3.339000e+05,  3.986000e+05,  3.580000e+04, -2.500000e+03,
        -2.500000e+03, -2.500000e+03, -2.500000e+03,  2.277000e+05,
         2.726000e+05,  3.377000e+05,  4.529000e+05, -1.860000e+04,
        -4.770000e+04, -1.318000e+05,  6.309000e+05,  4.215000e+05,
         3.270000e+04,  3.270000e+04,  3.352000e+05,  3.351000e+05,
         3.352000e+05,  7.200000e+05,  1.294300e+06,  1.295800e+06,
         8.631000e+05,  6.100000e+03,  3.497000e+05,  2.747000e+05,
         3.820000e+04,  8.440000e+05,  3.820000e+04,  8.438000e+05,
         5.830000e+05,  9.960000e+05,  1.270900e+06,  1.450300e+06,
         3.188000e+05,  4.239000e+05,  1.861400e+06,  3.000000e+05,
         2.550000e+04,  1.312000e+05,  3.002000e+05,  9.674000e+05,
        -1.189000e+05,  2.242000e+05,  1.000000e+03,  1.557000e+05,
        -1.201000e+05,  1.728000e+05,  4.484000e+05, -1.029000e+05,
         6.983000e+05,  3.726000e+05,  5.910000e+05,  8.012000e+05,
         4.534000e+05,  4.340000e+04,  3.575000e+05,  3.176000e+05,
         4.596000e+05,  3.884000e+05,  5.990000e+04,  3.582000e+05,
         1.048100e+06,  1.058500e+06, -5.440000e+04, -5.440000e+04,
         2.951000e+05,  8.348000e+05,  3.093000e+05, -7.301000e+05,
         2.740000e+04,  2.740000e+04,  2.640000e+04,  2.640000e+04,
         7.016000e+05,  2.650000e+04, -3.137000e+05,  2.640000e+04,
         4.670000e+04,  4.670000e+04,  4.670000e+04,  4.670000e+04,
         4.590000e+04, -5.730000e+04, -5.730000e+04, -5.730000e+04,
        -3.440000e+05, -6.850000e+04, -2.110000e+04,  2.375800e+06,
         7.925000e+05,  7.898000e+05,  9.300000e+05,  9.302000e+05,
        -1.920000e+04,  2.570000e+05, -2.760000e+04, -3.470000e+04,
         3.960000e+04, -8.000000e+02,  2.723000e+05, -5.700000e+03,
         1.747000e+05,  4.920000e+04,  0.000000e+00,  3.100000e+03,
        -2.940000e+04, -7.680000e+04,  2.940000e+04, -1.080000e+04,
         0.000000e+00,  0.000000e+00,  2.263000e+05,  3.304000e+05,
         2.357000e+05,  3.880000e+04,  2.840000e+04,  0.000000e+00,
        -3.570000e+04,  1.339000e+05,  8.720000e+04,  2.719000e+05,
         2.719000e+05, -5.160000e+04,  5.790000e+04, -4.400000e+03,
         2.218000e+05,  3.300000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.000000e+02, -2.400000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.470000e+04,  2.570000e+05,
         3.570000e+04,  4.670000e+04,  1.000000e+02, -5.040000e+04,
         1.810000e+05,  3.351000e+05, -2.500000e+03,  3.377000e+05,
         3.185000e+05,  7.016000e+05,  2.640000e+04,  2.740000e+04,
        -5.730000e+04, -2.110000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.670000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-2.900000e+04,  3.662000e+05,  4.980000e+04,  6.432000e+05,
         3.064000e+05, -1.560000e+05, -9.800000e+04, -2.640000e+04,
         3.662000e+05, -2.510000e+04,  3.660000e+05,  2.110000e+04,
         8.580000e+04,  3.220000e+04,  3.708000e+05,  2.390000e+04,
         2.010000e+04,  8.460000e+04,  1.105000e+05,  6.617000e+05,
         2.341000e+05,  1.154300e+06,  1.509300e+06,  1.324000e+05,
         5.500000e+05,  5.430000e+05,  9.384000e+05,  7.085700e+06,
         1.129000e+05,  1.132000e+05,  1.135000e+05,  1.124000e+05,
         8.050000e+04,  1.133000e+05,  6.776000e+05,  1.414100e+06,
         8.424000e+05,  5.870000e+04,  2.416000e+05,  9.990000e+04,
         9.521000e+05,  1.561800e+06,  8.899000e+05,  8.901000e+05,
         1.052900e+06,  1.354400e+06,  8.476000e+05,  4.941000e+05,
         1.698900e+06,  1.882200e+06,  2.696200e+06,  6.889000e+05,
         6.741000e+05,  1.014700e+06,  1.559000e+06,  3.585000e+05,
         3.586000e+05,  7.324000e+05,  4.409000e+05, -1.787000e+05,
         3.349000e+05,  4.691000e+05,  6.150000e+04,  5.170000e+04,
         5.170000e+04,  5.170000e+04,  5.170000e+04,  4.468000e+05,
         5.920000e+04,  3.965000e+05,  5.941000e+05, -2.080000e+04,
         1.429000e+05, -1.040000e+04,  4.061000e+05,  3.397000e+05,
         5.780000e+04,  5.780000e+04,  3.708000e+05,  3.707000e+05,
         3.708000e+05,  9.515000e+05,  1.939200e+06,  9.740000e+05,
         7.083000e+05,  1.164000e+05,  7.078000e+05,  1.020000e+06,
         2.614000e+05,  1.644500e+06,  2.614000e+05,  1.644700e+06,
         2.745000e+05,  7.570000e+04,  8.310000e+04,  8.568000e+05,
         1.392000e+05,  3.225000e+05,  3.731000e+06,  6.270000e+04,
         5.600000e+04,  2.398000e+05,  9.170000e+04,  5.268000e+05,
        -1.342000e+05,  4.526000e+05, -1.060000e+04, -1.275000e+05,
        -1.055000e+05,  1.700000e+03,  9.300000e+03, -6.000000e+03,
         9.182000e+05,  2.077000e+05,  1.978000e+05,  5.644000e+05,
         3.507000e+05,  1.580000e+05,  7.069000e+05,  1.648000e+05,
         3.555000e+05,  7.511000e+05,  1.820000e+05,  1.885000e+05,
         8.662000e+05,  1.029000e+06, -6.900000e+03, -6.900000e+03,
         5.899000e+05,  1.244500e+06,  3.280000e+05,  1.133000e+05,
         5.890000e+04,  5.900000e+04,  2.980000e+04,  2.980000e+04,
         4.972000e+05,  2.990000e+04, -1.342000e+05,  2.980000e+04,
         8.060000e+04,  8.060000e+04,  8.060000e+04,  8.060000e+04,
         7.950000e+04, -9.540000e+04, -9.530000e+04, -9.530000e+04,
        -5.721000e+05, -1.315000e+05, -5.090000e+04,  1.762700e+06,
         6.576000e+05,  6.567000e+05,  8.988000e+05,  8.990000e+05,
        -2.150000e+04,  2.567000e+05, -3.740000e+04, -3.880000e+04,
         8.410000e+04, -2.800000e+03,  3.220000e+04,  2.110000e+04,
         3.628000e+05,  5.490000e+04,  0.000000e+00,  9.500000e+03,
        -4.290000e+04, -9.210000e+04,  8.960000e+04, -1.850000e+04,
         0.000000e+00,  0.000000e+00, -2.080000e+04,  1.616000e+05,
         5.000000e+05,  9.760000e+04,  8.660000e+04,  0.000000e+00,
        -3.990000e+04,  1.440000e+04,  1.811000e+05,  2.716000e+05,
         2.716000e+05, -5.700000e+04,  1.327000e+05, -6.500000e+03,
         2.158000e+05,  4.044000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.000000e+02, -2.300000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.880000e+04,  2.567000e+05,
         4.200000e+03,  8.060000e+04,  1.000000e+02, -2.900000e+04,
         3.662000e+05,  3.707000e+05,  5.170000e+04,  3.965000e+05,
         1.125000e+05,  4.972000e+05,  2.980000e+04,  5.900000e+04,
        -9.530000e+04, -5.090000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  8.060000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-4.120000e+04,  1.880000e+04,  4.869000e+05,  6.120000e+05,
         2.846000e+05, -2.025000e+05, -1.201000e+05, -4.020000e+04,
         1.880000e+04, -3.990000e+04,  1.880000e+04, -7.000000e+02,
         1.130000e+04,  2.805000e+05,  3.359000e+05, -1.000000e+02,
         2.700000e+03, -2.700000e+03,  2.943000e+05,  3.739000e+05,
         3.135700e+06,  1.364400e+06,  9.856000e+05,  5.420000e+04,
         7.954000e+05,  5.147000e+05,  8.492000e+05,  8.229700e+06,
         3.216000e+05,  3.220000e+05,  3.221000e+05,  3.216000e+05,
         3.713000e+05,  3.222000e+05,  2.685000e+06,  2.795600e+06,
         6.473600e+06,  2.827000e+05,  3.107000e+05,  1.229800e+06,
         8.981000e+05,  1.500600e+06,  1.193900e+06,  1.193700e+06,
         1.028900e+06,  8.476000e+05,  6.479600e+06,  6.884000e+05,
         2.200500e+06,  2.227900e+06,  1.403600e+06,  9.626000e+05,
         6.186000e+05,  9.485000e+05,  1.497400e+06,  6.919000e+05,
         6.920000e+05,  7.466000e+05,  2.586200e+06, -1.956000e+05,
         3.106000e+05,  3.957000e+05,  3.200000e+04,  6.500000e+03,
         6.500000e+03,  6.500000e+03,  6.500000e+03,  5.980000e+04,
         2.868000e+05,  3.401000e+05,  3.687000e+05, -1.600000e+04,
        -1.722000e+05, -1.370000e+05,  6.416000e+05,  3.949000e+05,
         2.379000e+05,  2.379000e+05,  3.359000e+05,  3.358000e+05,
         3.359000e+05,  7.336000e+05,  8.682000e+05,  1.313500e+06,
         8.780000e+05,  2.050000e+04,  9.890000e+04, -2.108000e+05,
         6.500000e+04,  2.518000e+05,  6.500000e+04,  2.506000e+05,
         6.201000e+05,  1.054500e+06,  1.334100e+06,  1.161800e+06,
         3.258000e+05,  3.533000e+05,  2.944000e+05,  3.026000e+05,
         2.550000e+04,  5.240000e+04,  3.058000e+05,  9.694000e+05,
        -9.430000e+04, -1.200000e+04,  2.747100e+06,  1.831000e+05,
        -1.082000e+05,  2.081000e+05,  4.886000e+05, -7.240000e+04,
         3.449000e+05,  4.943800e+06,  6.106000e+05,  6.654000e+05,
         4.393000e+05,  5.250000e+04,  1.366000e+05,  3.297000e+05,
         4.453000e+05,  1.309000e+05,  2.910000e+04,  3.553000e+05,
         1.048000e+06,  8.832000e+05, -3.970000e+04, -3.970000e+04,
         4.890000e+04,  4.356000e+05,  2.988000e+05, -5.212000e+05,
         2.500000e+04,  2.500000e+04,  2.090000e+04,  2.090000e+04,
         6.910000e+05,  2.100000e+04, -3.213000e+05,  2.090000e+04,
         4.110000e+04,  4.110000e+04,  4.110000e+04,  4.110000e+04,
         4.110000e+04, -5.700000e+04, -5.700000e+04, -5.700000e+04,
        -3.419000e+05, -6.870000e+04, -2.400000e+04,  2.346800e+06,
         7.724000e+05,  7.716000e+05,  8.950000e+05,  8.951000e+05,
        -1.590000e+04,  2.621000e+05, -4.140000e+04, -3.720000e+04,
        -6.500000e+03,  9.720000e+04,  2.805000e+05, -7.000000e+02,
        -2.260000e+04,  4.450000e+04,  0.000000e+00,  0.000000e+00,
         7.045000e+05, -8.550000e+04, -5.160000e+04, -9.600000e+03,
         4.226000e+06, -5.300000e+03,  2.419000e+05,  2.707000e+05,
        -3.280000e+04, -2.030000e+04, -4.980000e+04,  0.000000e+00,
        -3.760000e+04,  1.380000e+05, -1.120000e+04,  2.741000e+05,
         2.741000e+05, -4.850000e+04, -1.450000e+04,  9.910000e+04,
         2.264000e+05,  2.596000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.000000e+02, -4.400000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.720000e+04,  2.621000e+05,
         3.680000e+04,  4.110000e+04,  1.000000e+02, -4.120000e+04,
         1.880000e+04,  3.358000e+05,  6.500000e+03,  3.401000e+05,
         3.216000e+05,  6.910000e+05,  2.090000e+04,  2.500000e+04,
        -5.700000e+04, -2.400000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.110000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-3.940000e+04,  4.600000e+03,  9.200000e+03,  2.740000e+05,
         1.171000e+05, -1.782000e+05, -9.950000e+04, -3.790000e+04,
         4.600000e+03, -3.730000e+04,  4.600000e+03, -1.250000e+04,
         3.300000e+03,  3.409000e+05,  1.500000e+05, -1.120000e+04,
         9.000000e+02, -5.020000e+04,  3.116000e+05,  3.746000e+05,
         3.857000e+05,  8.391000e+05,  4.359000e+05, -4.000000e+02,
         7.709000e+05,  4.195000e+05,  8.140000e+05,  4.924500e+06,
         3.597000e+05,  3.605000e+05,  3.597000e+05,  3.592000e+05,
         4.353000e+05,  3.613000e+05,  3.098600e+06,  3.185200e+06,
         3.197500e+06,  3.321000e+05,  3.520000e+05,  3.568000e+05,
         3.913000e+05,  6.732000e+05,  8.928000e+05,  8.926000e+05,
         6.936000e+05,  4.941000e+05,  6.884000e+05,  5.874000e+05,
         1.562700e+06,  1.583000e+06,  5.879000e+05,  6.453000e+05,
         2.670000e+05,  4.243000e+05,  6.736000e+05,  7.174000e+05,
         7.181000e+05,  7.606000e+05,  7.668000e+05, -1.413000e+05,
         1.642000e+05,  1.760000e+05,  1.420000e+04, -1.990000e+04,
        -1.990000e+04, -1.990000e+04, -1.990000e+04,  2.330000e+04,
         3.317000e+05,  1.435000e+05,  1.651000e+05, -1.080000e+04,
        -1.961000e+05, -1.674000e+05,  5.069000e+05,  3.128000e+05,
         1.240000e+04,  1.240000e+04,  1.500000e+05,  1.500000e+05,
         1.500000e+05,  2.778000e+05,  3.846000e+05,  1.001300e+06,
         5.828000e+05, -3.170000e+04,  3.140000e+04, -3.391000e+05,
        -5.000000e+04,  1.011000e+05, -5.000000e+04,  1.009000e+05,
         6.472000e+05,  1.288700e+06,  1.640200e+06,  1.375000e+06,
         3.522000e+05,  3.725000e+05,  1.015000e+05,  3.582000e+05,
         6.300000e+03,  2.730000e+04,  3.494000e+05,  8.849000e+05,
        -7.100000e+04, -4.800000e+03,  3.200000e+03,  2.811000e+05,
        -8.030000e+04,  2.562000e+05,  6.082000e+05, -9.580000e+04,
         3.580000e+05,  3.798000e+05,  6.857000e+05,  7.264000e+05,
         4.103000e+05, -1.010000e+04,  4.940000e+04,  3.416000e+05,
         4.165000e+05,  5.430000e+04, -1.090000e+04,  3.716000e+05,
         7.046000e+05,  5.056000e+05, -4.930000e+04, -4.930000e+04,
         1.780000e+04,  3.534000e+05,  2.517000e+05, -7.281000e+05,
         7.200000e+03,  7.200000e+03,  1.570000e+04,  1.580000e+04,
         5.464000e+05,  1.650000e+04, -3.477000e+05,  1.580000e+04,
         1.870000e+04,  1.870000e+04,  1.870000e+04,  1.870000e+04,
         1.830000e+04, -2.400000e+04, -2.390000e+04, -2.390000e+04,
        -1.437000e+05, -2.260000e+04, -3.400000e+03,  1.763200e+06,
         5.980000e+05,  6.136000e+05,  6.712000e+05,  6.719000e+05,
        -1.070000e+04,  1.175000e+05, -8.600000e+03, -2.080000e+04,
        -4.000000e+03,  0.000000e+00,  3.409000e+05, -1.250000e+04,
        -1.360000e+04,  2.940000e+04,  0.000000e+00,  0.000000e+00,
        -9.900000e+03, -3.750000e+04, -1.590000e+04, -4.300000e+03,
         0.000000e+00,  0.000000e+00,  3.132000e+05,  3.335000e+05,
        -2.100000e+04, -1.390000e+04, -1.540000e+04,  0.000000e+00,
        -2.070000e+04,  1.682000e+05, -6.400000e+03,  1.246000e+05,
         1.246000e+05, -3.000000e+04, -8.200000e+03, -1.900000e+03,
         9.550000e+04,  1.165000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         8.000000e+02, -1.000000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -2.080000e+04,  1.175000e+05,
         4.470000e+04,  1.870000e+04,  8.000000e+02, -3.940000e+04,
         4.600000e+03,  1.500000e+05, -1.990000e+04,  1.435000e+05,
         3.592000e+05,  5.464000e+05,  1.580000e+04,  7.200000e+03,
        -2.390000e+04, -3.400000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.870000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.300000e+04,  2.300000e+03,  3.210000e+04,  1.164400e+06,
         5.872000e+05,  4.160000e+04,  1.560000e+04,  1.380000e+04,
         2.300000e+03,  1.410000e+04,  2.400000e+03,  2.700000e+04,
         8.400000e+03,  7.968000e+05,  6.207000e+05,  2.760000e+04,
         2.000000e+03,  1.081000e+05,  8.900000e+05,  8.636000e+05,
         9.224000e+05,  2.838600e+06,  1.821600e+06,  1.073000e+05,
         1.872600e+06,  1.102900e+06,  1.856300e+06,  1.712430e+07,
         8.389000e+05,  8.404000e+05,  8.393000e+05,  8.382000e+05,
         1.017000e+06,  8.416000e+05,  7.450800e+06,  7.418900e+06,
         7.494000e+06,  8.323000e+05,  8.188000e+05,  8.431000e+05,
         1.753400e+06,  2.877000e+06,  2.676400e+06,  2.683100e+06,
         2.195100e+06,  1.698900e+06,  2.200500e+06,  1.562700e+06,
         5.152700e+06,  5.141200e+06,  2.701600e+06,  2.096000e+06,
         1.205800e+06,  1.786400e+06,  2.876100e+06,  1.781900e+06,
         1.783200e+06,  1.764800e+06,  1.803500e+06, -5.200000e+03,
         6.516000e+05,  6.976000e+05,  3.380000e+04,  6.010000e+04,
         6.010000e+04,  6.010000e+04,  6.010000e+04,  4.430000e+04,
         8.310000e+05,  6.609000e+05,  6.540000e+05, -3.370000e+04,
        -4.778000e+05, -4.276000e+05,  1.477200e+06,  8.832000e+05,
         3.260000e+04,  3.260000e+04,  6.207000e+05,  6.205000e+05,
         6.207000e+05,  1.459700e+06,  1.417500e+06,  3.063700e+06,
         2.124100e+06,  6.730000e+04,  3.850000e+04, -8.458000e+05,
         2.547000e+05,  1.993000e+05,  2.547000e+05,  1.982000e+05,
         1.788200e+06,  3.233800e+06,  4.004100e+06,  3.201500e+06,
         8.736000e+05,  8.619000e+05,  1.504000e+05,  8.080000e+05,
         3.950000e+04,  3.110000e+04,  8.056000e+05,  2.361000e+06,
        -3.220000e+04, -5.110000e+04,  2.000000e+02,  7.367000e+05,
        -4.370000e+04,  8.829000e+05,  1.649300e+06,  1.164000e+05,
         8.254000e+05,  9.369000e+05,  1.705300e+06,  1.682300e+06,
         9.536000e+05,  1.348000e+05,  9.410000e+04,  9.027000e+05,
         9.664000e+05,  1.096000e+05,  1.025000e+05,  8.662000e+05,
         2.232200e+06,  1.744300e+06,  4.280000e+04,  4.280000e+04,
         2.700000e+04,  7.827000e+05,  8.402000e+05,  8.119000e+05,
         6.300000e+03,  6.400000e+03,  7.100000e+03,  7.100000e+03,
         1.573600e+06,  8.400000e+03, -8.680000e+05,  7.100000e+03,
         4.190000e+04,  4.190000e+04,  4.190000e+04,  4.190000e+04,
         4.240000e+04, -6.290000e+04, -6.290000e+04, -6.290000e+04,
        -3.773000e+05, -8.290000e+04, -3.790000e+04,  5.263400e+06,
         1.655600e+06,  1.653300e+06,  1.781600e+06,  1.782900e+06,
        -3.420000e+04,  5.173000e+05, -3.570000e+04, -1.110000e+04,
        -1.170000e+04, -6.000000e+02,  7.968000e+05,  2.700000e+04,
        -4.070000e+04,  1.710000e+04,  0.000000e+00,  0.000000e+00,
        -2.890000e+04, -5.770000e+04, -5.530000e+04, -1.020000e+04,
         0.000000e+00,  0.000000e+00,  7.879000e+05,  7.773000e+05,
        -6.040000e+04, -1.780000e+04, -5.340000e+04,  0.000000e+00,
        -1.030000e+04,  3.940000e+05, -1.970000e+04,  5.445000e+05,
         5.445000e+05, -2.710000e+04, -2.470000e+04, -4.800000e+03,
         5.197000e+05,  5.200000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.200000e+03, -5.100000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.110000e+04,  5.173000e+05,
         1.046000e+05,  4.190000e+04,  1.200000e+03,  1.300000e+04,
         2.300000e+03,  6.205000e+05,  6.010000e+04,  6.609000e+05,
         8.383000e+05,  1.573600e+06,  7.100000e+03,  6.400000e+03,
        -6.290000e+04, -3.790000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.190000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-1.226000e+05,  1.725000e+05,  3.110000e+04,  1.182200e+06,
         5.287000e+05, -5.561000e+05, -3.110000e+05, -1.181000e+05,
         1.725000e+05, -1.161000e+05,  1.724000e+05, -3.880000e+04,
         4.170000e+04,  7.841000e+05,  6.371000e+05, -3.460000e+04,
         1.010000e+04, -1.554000e+05,  6.947000e+05,  1.214100e+06,
         9.315000e+05,  2.875100e+06,  2.018000e+06,  1.200000e+03,
         1.853600e+06,  1.037300e+06,  2.159500e+06,  1.719460e+07,
         8.431000e+05,  8.445000e+05,  8.441000e+05,  8.423000e+05,
         1.009500e+06,  8.457000e+05,  7.149900e+06,  7.875800e+06,
         7.465600e+06,  7.447000e+05,  9.627000e+05,  8.237000e+05,
         1.712900e+06,  2.914500e+06,  2.706700e+06,  2.713400e+06,
         2.300200e+06,  1.882200e+06,  2.227900e+06,  1.583000e+06,
         5.141200e+06,  6.098900e+06,  4.033300e+06,  2.099900e+06,
         1.163800e+06,  1.820700e+06,  2.913600e+06,  1.686900e+06,
         1.688100e+06,  2.022400e+06,  1.844700e+06, -4.442000e+05,
         6.539000e+05,  7.292000e+05,  4.540000e+04, -6.070000e+04,
        -6.070000e+04, -6.070000e+04, -6.070000e+04,  2.314000e+05,
         7.571000e+05,  6.170000e+05,  7.634000e+05, -3.380000e+04,
        -4.049000e+05, -3.833000e+05,  1.480900e+06,  9.099000e+05,
         3.990000e+04,  3.990000e+04,  6.371000e+05,  6.370000e+05,
         6.371000e+05,  1.207500e+06,  1.934000e+06,  2.905600e+06,
         1.875000e+06, -9.720000e+04,  3.347000e+05, -3.501000e+05,
        -1.509000e+05,  8.714000e+05, -1.509000e+05,  8.701000e+05,
         1.478800e+06,  2.909000e+06,  3.726400e+06,  3.511900e+06,
         8.173000e+05,  1.200500e+06,  1.725100e+06,  8.375000e+05,
         2.110000e+04,  1.946000e+05,  8.092000e+05,  2.368600e+06,
        -2.218000e+05,  2.319000e+05,  1.500000e+04,  5.949000e+05,
        -2.528000e+05,  5.268000e+05,  1.343400e+06, -2.899000e+05,
         2.542100e+06,  9.214000e+05,  1.575600e+06,  2.381700e+06,
         1.010600e+06, -2.930000e+04,  6.247000e+05,  7.861000e+05,
         1.022100e+06,  4.073000e+05, -8.640000e+04,  8.891000e+05,
         2.269100e+06,  1.855900e+06, -1.549000e+05, -1.549000e+05,
         2.907000e+05,  1.355200e+06, -6.601000e+05, -2.286700e+06,
         2.260000e+04,  2.260000e+04,  4.920000e+04,  4.920000e+04,
         1.593900e+06,  5.050000e+04, -8.049000e+05,  4.920000e+04,
         5.890000e+04,  5.890000e+04,  5.890000e+04,  5.890000e+04,
         5.730000e+04, -7.650000e+04, -7.640000e+04, -7.640000e+04,
        -4.587000e+05, -7.220000e+04, -1.150000e+04,  5.325700e+06,
         1.709900e+06,  1.707700e+06,  1.886900e+06,  1.888200e+06,
        -3.490000e+04,  5.163000e+05, -5.010000e+04, -6.500000e+04,
         3.380000e+04,  6.000000e+02,  7.841000e+05, -3.880000e+04,
         9.230000e+04,  9.220000e+04,  0.000000e+00, -6.000000e+02,
        -4.980000e+04, -1.427000e+05,  3.270000e+04, -1.360000e+04,
         0.000000e+00,  0.000000e+00,  6.990000e+05,  8.690000e+05,
         1.665000e+05,  6.100000e+03,  3.160000e+04,  0.000000e+00,
        -6.580000e+04,  3.887000e+05,  4.670000e+04,  5.461000e+05,
         5.460000e+05, -9.740000e+04,  6.720000e+04, -6.500000e+03,
         4.518000e+05,  6.135000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.300000e+03, -4.800000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -6.500000e+04,  5.163000e+05,
         1.029000e+05,  5.890000e+04,  1.300000e+03, -1.226000e+05,
         1.725000e+05,  6.370000e+05, -6.070000e+04,  6.170000e+05,
         8.424000e+05,  1.593900e+06,  4.920000e+04,  2.260000e+04,
        -7.640000e+04, -1.150000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  5.890000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-1.450000e+04,  1.110000e+06,  1.447000e+05,  1.347000e+06,
         6.646000e+05, -1.445000e+05, -1.156000e+05, -8.700000e+03,
         1.109900e+06, -5.800000e+03,  1.109300e+06,  9.610000e+04,
         2.587000e+05, -4.232000e+05,  8.050000e+05,  1.024000e+05,
         6.030000e+04,  3.846000e+05, -1.057000e+05,  1.535500e+06,
         1.477000e+05,  2.030500e+06,  3.504300e+06,  4.371000e+05,
         5.790000e+05,  1.107200e+06,  1.697700e+06,  1.269960e+07,
        -1.945000e+05, -1.945000e+05, -1.922000e+05, -1.952000e+05,
        -4.148000e+05, -1.932000e+05, -2.582300e+06, -3.640000e+05,
        -2.244400e+06, -3.254000e+05,  2.665000e+05, -2.409000e+05,
         2.018200e+06,  3.242400e+06,  1.152800e+06,  1.130900e+06,
         2.351900e+06,  2.696200e+06,  1.403600e+06,  5.879000e+05,
         2.701600e+06,  4.033300e+06,  6.384390e+07,  1.001000e+06,
         1.461600e+06,  2.153500e+06,  3.234600e+06,  5.570000e+04,
         5.700000e+04,  1.155900e+06,  2.246000e+05, -2.905000e+05,
         6.776000e+05,  1.068100e+06,  1.740000e+05,  2.113000e+05,
         2.113000e+05,  2.113000e+05,  2.113000e+05,  1.338600e+06,
        -3.154000e+05,  9.048000e+05,  1.467900e+06, -4.850000e+04,
         8.596000e+05,  2.220000e+05,  3.944000e+05,  4.943000e+05,
         1.655000e+05,  1.655000e+05,  8.050000e+05,  8.049000e+05,
         8.050000e+05,  2.354800e+06,  5.173800e+06,  1.290000e+06,
         1.103200e+06,  4.487000e+05,  2.141900e+06,  3.922300e+06,
         9.686000e+05,  4.914200e+06,  9.686000e+05,  4.915300e+06,
        -7.630000e+04, -1.713300e+06, -2.239900e+06,  5.296000e+05,
        -8.630000e+04,  6.708000e+05,  1.113810e+07, -3.554000e+05,
         1.736000e+05,  7.207000e+05, -2.419000e+05,  1.644000e+05,
        -2.979000e+05,  1.382500e+06, -4.440000e+04, -8.269000e+05,
        -1.784000e+05, -3.322000e+05, -8.617000e+05,  1.974000e+05,
         3.552600e+06,  9.020000e+04, -4.014000e+05,  1.152600e+06,
         4.899000e+05,  5.457000e+05,  2.321200e+06,  1.730000e+04,
         4.951000e+05,  2.238000e+06,  6.139000e+05,  3.390000e+04,
         1.411600e+06,  2.632500e+06,  8.400000e+04,  8.400000e+04,
         1.781900e+06,  3.373200e+06, -5.116000e+05,  1.954800e+06,
         1.810000e+05,  1.806000e+05,  6.610000e+04,  6.610000e+04,
         5.924000e+05,  6.740000e+04,  9.820000e+04,  6.610000e+04,
         2.287000e+05,  2.287000e+05,  2.287000e+05,  2.286000e+05,
         2.258000e+05, -2.654000e+05, -2.652000e+05, -2.652000e+05,
        -1.591900e+06, -3.877000e+05, -1.608000e+05,  2.317400e+06,
         1.050200e+06,  1.050300e+06,  1.739000e+06,  1.740300e+06,
        -4.670000e+04,  5.089000e+05, -9.810000e+04, -8.530000e+04,
         2.592000e+05, -9.600000e+03, -4.232000e+05,  9.610000e+04,
         1.063500e+06,  1.201000e+05,  0.000000e+00,  1.470000e+04,
        -1.164000e+05, -2.176000e+05,  3.190000e+05, -5.230000e+04,
         0.000000e+00,  0.000000e+00, -5.410000e+05,  1.900000e+03,
         1.492400e+06,  3.004000e+05,  3.082000e+05,  0.000000e+00,
        -8.660000e+04, -2.118000e+05,  5.313000e+05,  5.390000e+05,
         5.389000e+05, -1.241000e+05,  4.173000e+05, -1.730000e+04,
         4.169000e+05,  9.566000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.300000e+03, -4.600000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -8.530000e+04,  5.089000e+05,
        -5.550000e+04,  2.287000e+05,  1.300000e+03, -1.450000e+04,
         1.110000e+06,  8.049000e+05,  2.113000e+05,  9.048000e+05,
        -1.951000e+05,  5.924000e+05,  6.610000e+04,  1.806000e+05,
        -2.652000e+05, -1.608000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.287000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-8.270000e+04, -7.150000e+04, -5.040000e+04,  5.996000e+05,
         2.578000e+05, -3.345000e+05, -1.690000e+05, -8.260000e+04,
        -7.150000e+04, -8.260000e+04, -7.150000e+04, -7.930000e+04,
        -2.920000e+04,  4.298000e+05,  2.689000e+05, -7.940000e+04,
        -6.700000e+03, -3.172000e+05,  1.955000e+05,  2.055000e+05,
         2.442000e+05,  1.321800e+06,  8.101000e+05, -2.289000e+05,
         3.203000e+05, -1.868000e+05,  3.281000e+05,  8.019200e+06,
         3.529000e+05,  3.529000e+05,  3.526000e+05,  3.537000e+05,
         4.992000e+05,  3.529000e+05,  3.286000e+06,  3.297500e+06,
         3.351000e+06,  3.501000e+05,  3.545000e+05,  3.664000e+05,
         8.587000e+05,  1.531600e+06,  1.152600e+06,  1.152300e+06,
         9.325000e+05,  6.889000e+05,  9.626000e+05,  6.453000e+05,
         2.096000e+06,  2.099900e+06,  1.001000e+06,  1.575700e+06,
         5.252000e+05,  8.691000e+05,  1.529800e+06,  4.719000e+05,
         4.719000e+05,  4.797000e+05,  5.044000e+05, -1.763000e+05,
         2.620000e+05,  2.071000e+05, -5.740000e+04, -1.558000e+05,
        -1.558000e+05, -1.558000e+05, -1.558000e+05, -1.480000e+05,
         3.512000e+05,  1.926000e+05,  1.974000e+05,  2.200000e+03,
        -2.133000e+05, -2.106000e+05,  7.330000e+05,  2.314000e+05,
        -5.630000e+04, -5.630000e+04,  2.689000e+05,  2.688000e+05,
         2.689000e+05,  7.690000e+04,  9.630000e+04,  1.105100e+06,
         8.139000e+05, -3.043000e+05, -2.928000e+05, -7.259000e+05,
        -6.206000e+05, -5.934000e+05, -6.206000e+05, -5.946000e+05,
         3.890000e+05,  1.553500e+06,  2.060300e+06,  1.569100e+06,
         2.753000e+05,  2.792000e+05, -8.837000e+05,  4.312000e+05,
        -7.610000e+04, -7.270000e+04,  3.557000e+05,  1.074400e+06,
        -4.600000e+03,  8.300000e+03,  4.410000e+04,  5.029000e+05,
        -8.810000e+04,  1.874000e+05,  6.953000e+05, -3.205000e+05,
         2.068000e+05,  2.686000e+05,  6.271000e+05,  6.349000e+05,
         1.218000e+05, -3.087000e+05, -2.958000e+05,  1.980000e+05,
         1.231000e+05, -2.986000e+05, -3.258000e+05,  2.732000e+05,
         9.439000e+05,  7.241000e+05, -1.587000e+05, -1.587000e+05,
        -1.455000e+05, -1.638000e+05, -1.832000e+05, -2.720700e+06,
        -7.360000e+04, -7.360000e+04,  1.000000e+03,  1.000000e+03,
         6.429000e+05,  1.000000e+03, -2.743000e+05,  1.000000e+03,
        -7.650000e+04, -7.650000e+04, -7.650000e+04, -7.650000e+04,
        -7.650000e+04,  7.330000e+04,  7.320000e+04,  7.320000e+04,
         4.396000e+05,  1.501000e+05,  7.550000e+04,  2.259100e+06,
         4.907000e+05,  4.915000e+05,  2.620000e+05,  2.620000e+05,
         2.800000e+03,  3.131000e+05, -1.620000e+04, -3.400000e+03,
         1.500000e+03,  6.300000e+03,  4.298000e+05, -7.930000e+04,
         1.200000e+03,  4.800000e+03,  0.000000e+00,  1.000000e+02,
        -1.000000e+03, -2.320000e+04, -1.420000e+04,  1.730000e+04,
         0.000000e+00,  0.000000e+00,  4.255000e+05,  4.313000e+05,
         3.500000e+03, -7.000000e+02, -1.370000e+04,  0.000000e+00,
        -3.600000e+03,  2.140000e+05,  6.000000e+02,  3.300000e+05,
         3.300000e+05, -1.030000e+04, -1.200000e+03,  3.500000e+03,
         3.192000e+05,  3.287000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.200000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.400000e+03,  3.131000e+05,
         5.640000e+04, -7.650000e+04,  0.000000e+00, -8.270000e+04,
        -7.150000e+04,  2.688000e+05, -1.558000e+05,  1.926000e+05,
         3.537000e+05,  6.429000e+05,  1.000000e+03, -7.360000e+04,
         7.320000e+04,  7.550000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -7.650000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.150000e+05,  2.900000e+04,  4.120000e+04,  6.691000e+05,
         4.090000e+05,  4.855000e+05,  2.555000e+05,  1.134000e+05,
         2.900000e+04,  1.127000e+05,  2.900000e+04,  8.360000e+04,
         1.650000e+04, -1.281000e+05,  3.590000e+05,  8.210000e+04,
         3.600000e+03,  3.343000e+05,  1.129000e+05, -1.230000e+04,
         4.200000e+03,  9.258000e+05,  1.054700e+06,  2.073000e+05,
         1.207000e+05,  3.301000e+05,  3.610000e+04,  6.011000e+06,
        -8.120000e+04, -8.130000e+04, -8.130000e+04, -8.100000e+04,
        -1.366000e+05, -8.130000e+04, -6.673000e+05, -8.354000e+05,
        -8.123000e+05, -4.760000e+04, -8.970000e+04, -8.380000e+04,
         1.086700e+06,  1.650900e+06,  5.517000e+05,  5.517000e+05,
         6.113000e+05,  6.741000e+05,  6.186000e+05,  2.670000e+05,
         1.205800e+06,  1.163800e+06,  1.461600e+06,  5.252000e+05,
         7.744000e+05,  1.028900e+06,  1.637000e+06,  4.490000e+04,
         4.490000e+04, -3.860000e+04, -2.750000e+04,  3.068000e+05,
         3.266000e+05,  4.080000e+05,  3.700000e+04,  1.611000e+05,
         1.611000e+05,  1.611000e+05,  1.611000e+05,  7.600000e+04,
        -4.840000e+04,  4.403000e+05,  3.974000e+05, -1.590000e+04,
         4.030000e+04,  3.170000e+04,  2.230000e+05,  1.751000e+05,
         3.880000e+04,  3.880000e+04,  3.590000e+05,  3.590000e+05,
         3.590000e+05,  1.168300e+06,  9.559000e+05,  7.415000e+05,
         7.975000e+05,  2.560000e+05,  1.289000e+05,  2.418000e+05,
         6.102000e+05,  3.123000e+05,  6.102000e+05,  3.130000e+05,
         1.915000e+05, -2.866000e+05, -4.960000e+05, -4.561000e+05,
        -1.000000e+03, -4.300000e+04,  3.997000e+05, -1.468000e+05,
         6.190000e+04,  2.000000e+04, -9.730000e+04,  1.386000e+05,
         8.310000e+04, -4.520000e+04, -2.560000e+04, -1.257000e+05,
         1.343000e+05,  1.809000e+05, -2.870000e+04,  3.905000e+05,
        -2.900000e+04, -3.000000e+02, -4.900000e+04, -1.330000e+05,
         5.920000e+04,  2.879000e+05,  1.614000e+05,  7.930000e+04,
         5.960000e+04,  1.610000e+05,  2.751000e+05, -3.460000e+04,
         6.192000e+05,  6.787000e+05,  1.949000e+05,  1.949000e+05,
         6.690000e+04,  1.563000e+05,  3.662000e+05,  3.220300e+06,
         3.090000e+04,  3.100000e+04, -1.840000e+04, -1.840000e+04,
         2.654000e+05, -1.850000e+04, -2.600000e+03, -1.840000e+04,
         4.700000e+04,  4.700000e+04,  4.700000e+04,  4.700000e+04,
         4.770000e+04, -6.250000e+04, -6.240000e+04, -6.240000e+04,
        -3.748000e+05, -1.114000e+05, -6.490000e+04,  1.098300e+06,
         3.598000e+05,  3.603000e+05,  5.012000e+05,  5.012000e+05,
        -1.610000e+04,  2.882000e+05, -1.810000e+04,  2.460000e+04,
        -5.500000e+03, -3.100000e+03, -1.281000e+05,  8.360000e+04,
        -1.880000e+04, -3.450000e+04,  0.000000e+00, -5.000000e+02,
        -1.680000e+04,  1.100000e+04, -2.620000e+04, -1.110000e+04,
         0.000000e+00,  0.000000e+00, -9.520000e+04, -1.366000e+05,
        -2.770000e+04,  4.900000e+03, -2.540000e+04,  0.000000e+00,
         2.540000e+04, -6.430000e+04, -9.400000e+03,  3.019000e+05,
         3.019000e+05,  2.600000e+04, -1.200000e+04, -3.800000e+03,
         3.264000e+05,  2.896000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02, -3.000000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.460000e+04,  2.882000e+05,
        -1.680000e+04,  4.700000e+04, -1.000000e+02,  1.150000e+05,
         2.900000e+04,  3.590000e+05,  1.611000e+05,  4.403000e+05,
        -8.100000e+04,  2.654000e+05, -1.840000e+04,  3.100000e+04,
        -6.240000e+04, -6.490000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.700000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-4.540000e+04,  2.180000e+04,  2.550000e+04,  1.052900e+06,
         4.939000e+05, -2.129000e+05, -1.221000e+05, -4.320000e+04,
         2.180000e+04, -4.220000e+04,  2.180000e+04, -5.700000e+03,
         1.040000e+04, -1.370000e+05,  5.385000e+05, -3.500000e+03,
         2.700000e+03, -2.280000e+04, -1.424000e+05, -3.930000e+04,
        -3.250000e+04,  1.439000e+06,  1.588300e+06,  3.760000e+04,
        -4.530000e+04,  8.930000e+04,  2.220000e+04,  9.109700e+06,
        -9.540000e+04, -9.550000e+04, -9.520000e+04, -9.550000e+04,
        -1.505000e+05, -9.550000e+04, -1.094900e+06, -9.577000e+05,
        -9.484000e+05, -1.387000e+05, -1.044000e+05, -1.021000e+05,
         1.540900e+06,  2.578400e+06,  8.761000e+05,  8.761000e+05,
         9.427000e+05,  1.014700e+06,  9.485000e+05,  4.243000e+05,
         1.786400e+06,  1.820700e+06,  2.153500e+06,  8.691000e+05,
         1.028900e+06,  1.638600e+06,  2.550400e+06, -1.519000e+05,
        -1.519000e+05, -8.400000e+04, -7.860000e+04, -1.855000e+05,
         4.874000e+05,  5.626000e+05,  3.170000e+04, -3.900000e+03,
        -3.900000e+03, -3.900000e+03, -3.900000e+03,  6.340000e+04,
        -1.384000e+05,  5.254000e+05,  5.596000e+05, -1.510000e+04,
         4.570000e+04,  7.480000e+04,  3.880000e+05,  2.437000e+05,
         2.970000e+04,  2.970000e+04,  5.385000e+05,  5.383000e+05,
         5.385000e+05,  1.086100e+06,  1.255900e+06,  8.108000e+05,
         8.055000e+05,  5.500000e+03,  1.067000e+05,  2.284000e+05,
         2.780000e+04,  2.634000e+05,  2.780000e+04,  2.636000e+05,
        -2.389000e+05, -6.362000e+05, -7.707000e+05, -5.014000e+05,
        -9.750000e+04, -6.310000e+04,  3.160000e+05, -1.136000e+05,
         2.170000e+04,  5.610000e+04, -1.105000e+05,  2.868000e+05,
        -1.063000e+05, -5.900000e+03,  3.500000e+03, -2.417000e+05,
        -1.037000e+05, -2.290000e+05, -3.636000e+05, -9.440000e+04,
        -5.740000e+04, -4.590000e+04, -2.366000e+05, -1.679000e+05,
         2.940000e+04,  3.560000e+04,  1.385000e+05, -9.950000e+04,
         2.970000e+04,  1.368000e+05,  3.590000e+04, -5.360000e+04,
         9.511000e+05,  1.017600e+06, -4.980000e+04, -4.980000e+04,
         5.350000e+04,  1.322000e+05, -3.940000e+04, -6.744000e+05,
         2.660000e+04,  2.660000e+04,  2.360000e+04,  2.360000e+04,
         4.212000e+05,  2.360000e+04,  1.011000e+05,  2.360000e+04,
         4.170000e+04,  4.170000e+04,  4.170000e+04,  4.160000e+04,
         4.030000e+04, -5.730000e+04, -5.720000e+04, -5.720000e+04,
        -3.436000e+05, -5.940000e+04, -1.790000e+04,  1.746200e+06,
         5.055000e+05,  5.066000e+05,  6.316000e+05,  6.316000e+05,
        -1.500000e+04,  4.551000e+05, -2.730000e+04, -3.030000e+04,
        -5.500000e+03,  2.000000e+02, -1.370000e+05, -5.700000e+03,
        -2.170000e+04,  4.340000e+04,  0.000000e+00, -9.000000e+02,
        -2.760000e+04, -7.060000e+04, -3.630000e+04, -9.500000e+03,
         0.000000e+00,  0.000000e+00, -1.797000e+05, -1.460000e+05,
        -3.150000e+04, -2.100000e+04, -3.500000e+04,  0.000000e+00,
        -3.130000e+04, -6.860000e+04, -1.080000e+04,  4.824000e+05,
         4.823000e+05, -4.760000e+04, -1.400000e+04, -4.900000e+03,
         4.310000e+05,  4.678000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -4.400000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.030000e+04,  4.551000e+05,
        -1.800000e+04,  4.170000e+04,  0.000000e+00, -4.540000e+04,
         2.180000e+04,  5.383000e+05, -3.900000e+03,  5.254000e+05,
        -9.550000e+04,  4.212000e+05,  2.360000e+04,  2.660000e+04,
        -5.720000e+04, -1.790000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.170000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-1.000000e+05, -2.690000e+04, -1.840000e+04,  1.712500e+06,
         8.033000e+05, -4.302000e+05, -2.303000e+05, -9.770000e+04,
        -2.690000e+04, -9.670000e+04, -2.690000e+04, -6.090000e+04,
        -1.030000e+04, -1.219000e+05,  8.360000e+05, -5.870000e+04,
        -2.100000e+03, -2.435000e+05, -2.937000e+05, -1.813000e+05,
        -1.668000e+05,  2.329400e+06,  2.480900e+06, -1.298000e+05,
        -4.030000e+05, -3.390000e+05, -3.289000e+05,  1.479150e+07,
        -1.358000e+05, -1.360000e+05, -1.356000e+05, -1.360000e+05,
        -1.594000e+05, -1.359000e+05, -1.375500e+06, -1.226100e+06,
        -1.206200e+06, -1.788000e+05, -1.413000e+05, -1.365000e+05,
         2.527500e+06,  4.317800e+06,  1.422900e+06,  1.422900e+06,
         1.487100e+06,  1.559000e+06,  1.497400e+06,  6.736000e+05,
         2.876100e+06,  2.913600e+06,  3.234600e+06,  1.529800e+06,
         1.637000e+06,  2.550400e+06,  4.335400e+06, -3.986000e+05,
        -3.985000e+05, -3.248000e+05, -3.139000e+05, -2.916000e+05,
         7.648000e+05,  7.954000e+05, -1.090000e+04, -1.149000e+05,
        -1.149000e+05, -1.149000e+05, -1.149000e+05, -4.070000e+04,
        -1.787000e+05,  7.601000e+05,  7.979000e+05, -1.240000e+04,
         4.410000e+04,  6.960000e+04,  6.948000e+05,  3.091000e+05,
        -1.400000e+04, -1.400000e+04,  8.360000e+05,  8.357000e+05,
         8.360000e+05,  1.333700e+06,  1.521100e+06,  1.198500e+06,
         1.290000e+06, -2.109000e+05, -9.850000e+04,  1.170000e+04,
        -4.158000e+05, -1.560000e+05, -4.158000e+05, -1.560000e+05,
        -5.401000e+05, -6.856000e+05, -7.495000e+05, -5.374000e+05,
        -1.933000e+05, -1.558000e+05, -2.989000e+05, -9.870000e+04,
        -3.370000e+04,  3.800000e+03, -1.478000e+05,  5.509000e+05,
        -1.071000e+05,  4.400000e+03,  1.990000e+04, -1.721000e+05,
        -1.532000e+05, -3.786000e+05, -4.428000e+05, -3.143000e+05,
        -1.910000e+05, -1.670000e+05, -3.727000e+05, -2.977000e+05,
        -1.748000e+05, -1.861000e+05, -7.350000e+04, -2.509000e+05,
        -1.769000e+05, -7.470000e+04, -1.778000e+05, -1.463000e+05,
         1.492700e+06,  1.556900e+06, -1.579000e+05, -1.579000e+05,
        -4.710000e+04, -2.001000e+05, -3.877000e+05, -2.543300e+06,
        -2.570000e+04, -2.570000e+04,  2.370000e+04,  2.380000e+04,
         6.693000e+05,  2.380000e+04,  1.973000e+05,  2.380000e+04,
        -1.380000e+04, -1.380000e+04, -1.380000e+04, -1.380000e+04,
        -1.520000e+04, -2.600000e+03, -2.600000e+03, -2.600000e+03,
        -1.530000e+04,  5.260000e+04,  3.820000e+04,  2.872800e+06,
         6.432000e+05,  6.449000e+05,  6.037000e+05,  6.037000e+05,
        -1.180000e+04,  8.027000e+05, -4.430000e+04, -2.930000e+04,
        -3.400000e+03,  1.900000e+03, -1.219000e+05, -6.090000e+04,
        -1.830000e+04,  4.250000e+04,  0.000000e+00, -1.400000e+03,
        -3.680000e+04, -8.590000e+04, -5.020000e+04,  3.300000e+03,
         0.000000e+00,  0.000000e+00, -1.640000e+05, -1.279000e+05,
        -2.550000e+04, -2.000000e+04, -4.850000e+04,  0.000000e+00,
        -3.030000e+04, -6.000000e+04, -9.100000e+03,  8.646000e+05,
         8.643000e+05, -3.950000e+04, -5.100000e+03,  1.500000e+03,
         8.126000e+05,  8.576000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.000000e+02,  2.100000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -2.930000e+04,  8.027000e+05,
        -1.600000e+04, -1.380000e+04,  1.000000e+02, -1.000000e+05,
        -2.690000e+04,  8.357000e+05, -1.149000e+05,  7.601000e+05,
        -1.360000e+05,  6.693000e+05,  2.380000e+04, -2.570000e+04,
        -2.600000e+03,  3.820000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.380000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 2.554000e+05,  7.340000e+04,  9.030000e+04, -1.378000e+05,
         5.850000e+04,  1.074200e+06,  5.634000e+05,  2.525000e+05,
         7.340000e+04,  2.511000e+05,  7.340000e+04,  1.909000e+05,
         4.030000e+04,  6.232000e+05, -1.390000e+04,  1.878000e+05,
         8.900000e+03,  7.634000e+05,  1.189400e+06,  9.094000e+05,
         9.423000e+05,  5.670000e+05, -7.800000e+04,  4.939000e+05,
         2.197700e+06,  1.752400e+06,  1.990500e+06,  3.105300e+06,
         7.386000e+05,  7.388000e+05,  7.418000e+05,  7.514000e+05,
         8.426000e+05,  7.384000e+05,  6.766200e+06,  6.398400e+06,
         6.436700e+06,  8.131000e+05,  7.166000e+05,  7.307000e+05,
        -7.980000e+04, -3.997000e+05,  1.008500e+06,  1.008500e+06,
         6.822000e+05,  3.585000e+05,  6.919000e+05,  7.174000e+05,
         1.781900e+06,  1.686900e+06,  5.570000e+04,  4.719000e+05,
         4.490000e+04, -1.519000e+05, -3.986000e+05,  2.042800e+06,
         2.042500e+06,  1.790800e+06,  1.878100e+06,  6.695000e+05,
        -1.460000e+04,  9.620000e+04,  8.840000e+04,  3.746000e+05,
         3.746000e+05,  3.746000e+05,  3.746000e+05,  1.883000e+05,
         8.168000e+05,  1.700000e+05,  7.830000e+04, -2.840000e+04,
        -3.571000e+05, -3.760000e+05,  6.042000e+05,  4.705000e+05,
         9.070000e+04,  9.070000e+04, -1.390000e+04, -1.390000e+04,
        -1.390000e+04,  1.017200e+06,  5.537000e+05,  1.890400e+06,
         1.071200e+06,  6.202000e+05,  3.404000e+05, -3.141000e+05,
         1.426100e+06,  7.740000e+05,  1.426100e+06,  7.737000e+05,
         2.488100e+06,  3.043500e+06,  3.486300e+06,  2.642500e+06,
         9.257000e+05,  8.305000e+05,  1.020700e+06,  5.851000e+05,
         1.493000e+05,  5.630000e+04,  7.098000e+05,  1.340800e+06,
         1.832000e+05, -1.022000e+05, -6.390000e+04,  6.191000e+05,
         2.905000e+05,  1.338700e+06,  1.772500e+06,  9.050000e+05,
         8.633000e+05,  9.269000e+05,  1.736500e+06,  1.546400e+06,
         1.069300e+06,  6.770000e+05,  3.876000e+05,  1.113400e+06,
         1.086000e+06,  3.971000e+05,  6.581000e+05,  8.345000e+05,
         6.989000e+05,  3.726000e+05,  4.387000e+05,  4.387000e+05,
         1.669000e+05,  1.091400e+06,  1.566800e+06,  7.302100e+06,
         8.650000e+04,  8.660000e+04, -4.060000e+04, -4.060000e+04,
         7.165000e+05, -4.100000e+04, -9.350000e+05, -4.060000e+04,
         1.149000e+05,  1.149000e+05,  1.149000e+05,  1.149000e+05,
         1.170000e+05, -1.434000e+05, -1.433000e+05, -1.433000e+05,
        -8.603000e+05, -2.747000e+05, -1.577000e+05,  2.026300e+06,
         9.461000e+05,  9.460000e+05,  1.290100e+06,  1.289700e+06,
        -2.860000e+04, -1.152000e+05,  4.000000e+03,  5.150000e+04,
        -1.280000e+04, -1.020000e+04,  6.232000e+05,  1.909000e+05,
        -3.610000e+04, -6.810000e+04,  0.000000e+00,  2.000000e+02,
        -4.400000e+03,  7.140000e+04, -1.640000e+04, -2.660000e+04,
         0.000000e+00,  0.000000e+00,  6.953000e+05,  6.048000e+05,
        -5.580000e+04,  1.140000e+04, -1.590000e+04,  0.000000e+00,
         5.260000e+04,  3.060000e+05, -1.820000e+04, -1.232000e+05,
        -1.232000e+05,  6.840000e+04, -1.870000e+04, -6.100000e+03,
        -5.650000e+04, -1.421000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -3.000000e+02,  1.000000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  5.150000e+04, -1.152000e+05,
         8.180000e+04,  1.149000e+05, -3.000000e+02,  2.554000e+05,
         7.340000e+04, -1.390000e+04,  3.746000e+05,  1.700000e+05,
         7.505000e+05,  7.165000e+05, -4.060000e+04,  8.660000e+04,
        -1.433000e+05, -1.577000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.149000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 2.553000e+05,  7.340000e+04,  9.030000e+04, -1.378000e+05,
         5.850000e+04,  1.074200e+06,  5.636000e+05,  2.524000e+05,
         7.340000e+04,  2.510000e+05,  7.340000e+04,  1.908000e+05,
         4.030000e+04,  6.232000e+05, -1.390000e+04,  1.877000e+05,
         8.900000e+03,  7.631000e+05,  1.189100e+06,  9.092000e+05,
         9.421000e+05,  5.669000e+05, -7.800000e+04,  4.937000e+05,
         2.197200e+06,  1.751800e+06,  1.990000e+06,  3.106800e+06,
         7.385000e+05,  7.387000e+05,  7.417000e+05,  7.514000e+05,
         8.425000e+05,  7.388000e+05,  6.766400e+06,  6.398700e+06,
         6.437000e+06,  8.134000e+05,  7.170000e+05,  7.311000e+05,
        -7.990000e+04, -3.996000e+05,  1.008600e+06,  1.008600e+06,
         6.824000e+05,  3.586000e+05,  6.920000e+05,  7.181000e+05,
         1.783200e+06,  1.688100e+06,  5.700000e+04,  4.719000e+05,
         4.490000e+04, -1.519000e+05, -3.985000e+05,  2.042500e+06,
         2.172200e+06,  1.790500e+06,  1.877800e+06,  6.705000e+05,
        -1.460000e+04,  9.610000e+04,  8.830000e+04,  3.745000e+05,
         3.745000e+05,  3.745000e+05,  3.745000e+05,  1.882000e+05,
         8.167000e+05,  1.699000e+05,  7.830000e+04, -2.840000e+04,
        -3.571000e+05, -3.760000e+05,  6.041000e+05,  4.704000e+05,
         9.070000e+04,  9.070000e+04, -1.390000e+04, -1.390000e+04,
        -1.390000e+04,  1.017100e+06,  5.538000e+05,  1.890500e+06,
         1.071300e+06,  6.203000e+05,  3.406000e+05, -3.139000e+05,
         1.425900e+06,  7.740000e+05,  1.425900e+06,  7.738000e+05,
         2.488000e+06,  3.043300e+06,  3.486100e+06,  2.642300e+06,
         9.264000e+05,  8.312000e+05,  1.022200e+06,  5.854000e+05,
         1.496000e+05,  5.660000e+04,  7.101000e+05,  1.341100e+06,
         1.835000e+05, -1.018000e+05, -6.350000e+04,  6.194000e+05,
         2.908000e+05,  1.340100e+06,  1.773900e+06,  9.063000e+05,
         8.648000e+05,  9.284000e+05,  1.738000e+06,  1.547900e+06,
         1.069500e+06,  6.771000e+05,  3.878000e+05,  1.113600e+06,
         1.086200e+06,  3.973000e+05,  6.583000e+05,  8.352000e+05,
         6.992000e+05,  3.730000e+05,  4.393000e+05,  4.393000e+05,
         1.676000e+05,  1.093700e+06,  1.569000e+06,  7.312200e+06,
         8.640000e+04,  8.650000e+04, -4.070000e+04, -4.070000e+04,
         7.164000e+05, -4.060000e+04, -9.350000e+05, -4.070000e+04,
         1.149000e+05,  1.149000e+05,  1.149000e+05,  1.148000e+05,
         1.169000e+05, -1.434000e+05, -1.433000e+05, -1.433000e+05,
        -8.602000e+05, -2.747000e+05, -1.577000e+05,  2.026100e+06,
         9.468000e+05,  9.475000e+05,  1.292300e+06,  1.292300e+06,
        -2.820000e+04, -1.151000e+05,  4.000000e+03,  5.150000e+04,
        -1.280000e+04, -1.010000e+04,  6.232000e+05,  1.908000e+05,
        -3.610000e+04, -6.810000e+04,  0.000000e+00,  2.000000e+02,
        -4.400000e+03,  7.130000e+04, -1.640000e+04, -2.660000e+04,
         0.000000e+00,  0.000000e+00,  6.952000e+05,  6.048000e+05,
        -5.580000e+04,  1.130000e+04, -1.590000e+04,  0.000000e+00,
         5.300000e+04,  3.062000e+05, -1.800000e+04, -1.232000e+05,
        -1.232000e+05,  6.830000e+04, -1.870000e+04, -6.100000e+03,
        -5.650000e+04, -1.421000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.000000e+02,  1.000000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  5.150000e+04, -1.151000e+05,
         8.180000e+04,  1.149000e+05,  1.000000e+02,  2.553000e+05,
         7.340000e+04, -1.390000e+04,  3.745000e+05,  1.699000e+05,
         7.505000e+05,  7.164000e+05, -4.070000e+04,  8.650000e+04,
        -1.433000e+05, -1.577000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.149000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-1.330000e+04,  4.267000e+05,  8.910000e+04, -1.026000e+05,
        -5.760000e+04, -1.113000e+05, -8.480000e+04, -9.300000e+03,
         4.267000e+05, -7.300000e+03,  4.265000e+05,  6.060000e+04,
         1.098000e+05,  5.995000e+05,  1.870000e+04,  6.490000e+04,
         2.580000e+04,  2.425000e+05,  8.004000e+05,  1.578700e+06,
         9.599000e+05,  6.402000e+05,  3.158000e+05,  2.777000e+05,
         2.136500e+06,  1.599900e+06,  2.629100e+06,  3.244800e+06,
         7.488000e+05,  7.499000e+05,  7.559000e+05,  7.496000e+05,
         8.246000e+05,  7.497000e+05,  6.188800e+06,  7.235000e+06,
         6.401500e+06,  6.683000e+05,  9.244000e+05,  7.215000e+05,
        -1.603000e+05, -3.258000e+05,  1.071600e+06,  1.071700e+06,
         8.984000e+05,  7.324000e+05,  7.466000e+05,  7.606000e+05,
         1.764800e+06,  2.022400e+06,  1.155900e+06,  4.797000e+05,
        -3.860000e+04, -8.400000e+04, -3.248000e+05,  1.790800e+06,
         1.790500e+06,  2.386800e+06,  1.897200e+06, -2.023000e+05,
        -8.600000e+03,  1.587000e+05,  1.123000e+05,  1.322000e+05,
         1.322000e+05,  1.322000e+05,  1.322000e+05,  5.765000e+05,
         6.684000e+05,  8.250000e+04,  3.035000e+05, -2.990000e+04,
        -2.085000e+05, -2.902000e+05,  6.128000e+05,  5.260000e+05,
         1.060000e+05,  1.060000e+05,  1.870000e+04,  1.870000e+04,
         1.870000e+04,  5.112000e+05,  1.621100e+06,  1.575700e+06,
         5.807000e+05,  2.860000e+05,  9.515000e+05,  6.667000e+05,
         6.107000e+05,  2.165700e+06,  6.107000e+05,  2.167100e+06,
         1.702800e+06,  2.379400e+06,  2.915900e+06,  3.333600e+06,
         8.151000e+05,  1.072600e+06,  4.252400e+06,  6.458000e+05,
         1.118000e+05,  3.716000e+05,  7.181000e+05,  1.360100e+06,
        -2.050000e+05,  4.974000e+05, -4.540000e+04,  3.290000e+05,
        -1.200000e+05,  6.390000e+05,  1.172500e+06,  1.055000e+05,
         1.927100e+06,  9.050000e+05,  1.480500e+06,  1.995700e+06,
         1.183300e+06,  3.460000e+05,  1.114500e+06,  8.807000e+05,
         1.204600e+06,  1.014100e+06,  3.212000e+05,  8.787000e+05,
         7.743000e+05,  6.010000e+05,  4.600000e+04,  4.600000e+04,
         7.144000e+05,  2.240600e+06,  9.525000e+05,  1.132500e+06,
         1.183000e+05,  1.184000e+05,  4.550000e+04,  4.550000e+04,
         7.592000e+05,  4.520000e+04, -8.086000e+05,  4.550000e+04,
         1.497000e+05,  1.497000e+05,  1.497000e+05,  1.496000e+05,
         1.477000e+05, -1.688000e+05, -1.686000e+05, -1.687000e+05,
        -1.012400e+06, -2.491000e+05, -1.018000e+05,  2.157400e+06,
         1.058700e+06,  1.058800e+06,  1.507500e+06,  1.507200e+06,
        -3.150000e+04, -1.175000e+05, -2.300000e+04, -5.610000e+04,
         8.180000e+04, -7.900000e+03,  5.995000e+05,  6.060000e+04,
         2.404000e+05,  7.940000e+04,  0.000000e+00, -1.300000e+03,
        -4.660000e+04, -9.610000e+04,  1.488000e+05, -3.380000e+04,
         0.000000e+00,  0.000000e+00,  5.206000e+05,  7.781000e+05,
         4.021000e+05,  5.880000e+04,  1.438000e+05,  0.000000e+00,
        -5.820000e+04,  2.935000e+05,  1.198000e+05, -1.204000e+05,
        -1.204000e+05, -7.150000e+04,  1.594000e+05, -9.600000e+03,
        -1.915000e+05,  3.910000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -3.000000e+02,  1.600000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -5.610000e+04, -1.175000e+05,
         7.870000e+04,  1.497000e+05, -3.000000e+02, -1.330000e+04,
         4.267000e+05,  1.870000e+04,  1.322000e+05,  8.250000e+04,
         7.496000e+05,  7.592000e+05,  4.550000e+04,  1.184000e+05,
        -1.687000e+05, -1.018000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.497000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 3.900000e+03,  9.440000e+04,  1.008900e+06, -9.670000e+04,
        -4.620000e+04, -4.670000e+04, -5.450000e+04,  5.300000e+03,
         9.440000e+04,  5.800000e+03,  9.440000e+04,  7.020000e+04,
         4.530000e+04,  6.161000e+05,  1.820000e+04,  7.120000e+04,
         1.060000e+04,  2.809000e+05,  8.444000e+05,  9.729000e+05,
         6.448000e+06,  6.555000e+05,  1.570000e+04,  2.934000e+05,
         2.155900e+06,  1.603700e+06,  2.219900e+06,  3.371500e+06,
         7.559000e+05,  7.562000e+05,  7.595000e+05,  7.686000e+05,
         8.459000e+05,  7.559000e+05,  6.337000e+06,  6.515000e+06,
         1.875910e+07,  6.931000e+05,  7.329000e+05,  3.798600e+06,
        -1.433000e+05, -3.116000e+05,  1.086200e+06,  1.086200e+06,
         7.622000e+05,  4.409000e+05,  2.586200e+06,  7.668000e+05,
         1.803500e+06,  1.844700e+06,  2.246000e+05,  5.044000e+05,
        -2.750000e+04, -7.860000e+04, -3.139000e+05,  1.878100e+06,
         1.877800e+06,  1.897200e+06,  1.147830e+07, -1.794000e+05,
        -2.980000e+04,  1.514000e+05,  1.054000e+05,  1.487000e+05,
         1.487000e+05,  1.486000e+05,  1.486000e+05,  2.337000e+05,
         6.981000e+05,  8.810000e+04,  1.325000e+05, -2.670000e+04,
        -3.532000e+05, -3.028000e+05,  6.290000e+05,  5.197000e+05,
         5.167000e+05,  5.168000e+05,  1.820000e+04,  1.820000e+04,
         1.820000e+04,  5.394000e+05,  7.545000e+05,  1.627600e+06,
         6.279000e+05,  3.100000e+05,  4.362000e+05, -2.119000e+05,
         6.604000e+05,  9.580000e+05,  6.604000e+05,  9.569000e+05,
         1.938700e+06,  2.519400e+06,  3.069300e+06,  2.660900e+06,
         8.305000e+05,  8.716000e+05,  1.286700e+06,  6.528000e+05,
         1.113000e+05,  1.545000e+05,  7.289000e+05,  1.383100e+06,
        -1.534000e+05, -3.230000e+04,  9.163200e+06,  3.882000e+05,
        -9.900000e+04,  7.182000e+05,  1.259400e+06,  1.771000e+05,
         9.241000e+05,  1.624580e+07,  1.521700e+06,  1.604100e+06,
         1.158800e+06,  3.634000e+05,  4.830000e+05,  9.055000e+05,
         1.177000e+06,  4.896000e+05,  3.580000e+05,  8.751000e+05,
         7.800000e+05,  4.560000e+05,  7.360000e+04,  7.360000e+04,
         2.106000e+05,  1.275900e+06,  1.070000e+06,  1.522100e+06,
         1.125000e+05,  1.126000e+05,  3.400000e+04,  3.400000e+04,
         7.658000e+05,  3.370000e+04, -8.274000e+05,  3.400000e+04,
         1.393000e+05,  1.393000e+05,  1.393000e+05,  1.393000e+05,
         1.391000e+05, -1.654000e+05, -1.653000e+05, -1.653000e+05,
        -9.923000e+05, -2.501000e+05, -1.081000e+05,  2.179900e+06,
         1.044400e+06,  1.044400e+06,  1.461700e+06,  1.461500e+06,
        -2.690000e+04, -1.090000e+05, -4.370000e+04, -6.150000e+04,
        -1.310000e+04,  1.881000e+05,  6.161000e+05,  7.020000e+04,
        -3.870000e+04,  7.040000e+04,  0.000000e+00,  2.000000e+02,
         1.426300e+06, -1.078000e+05, -6.550000e+04, -3.170000e+04,
         0.000000e+00,  0.000000e+00,  5.522000e+05,  5.969000e+05,
        -5.950000e+04, -3.380000e+04, -6.330000e+04,  0.000000e+00,
        -6.220000e+04,  3.020000e+05, -1.950000e+04, -1.176000e+05,
        -1.176000e+05, -6.650000e+04, -2.270000e+04,  1.972000e+05,
        -1.846000e+05, -1.403000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -3.000000e+02, -2.400000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -6.150000e+04, -1.090000e+05,
         8.090000e+04,  1.393000e+05, -3.000000e+02,  3.900000e+03,
         9.440000e+04,  1.820000e+04,  1.487000e+05,  8.810000e+04,
         7.677000e+05,  7.658000e+05,  3.400000e+04,  1.126000e+05,
        -1.653000e+05, -1.081000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.393000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 8.704000e+05, -1.320000e+04,  2.270000e+04, -1.182000e+05,
         3.749000e+05,  3.917500e+06,  2.178500e+06,  8.606000e+05,
        -1.320000e+04,  8.563000e+05, -1.320000e+04,  4.424000e+05,
         3.000000e+03, -6.030000e+04, -6.720000e+04,  4.334000e+05,
        -4.000000e+02,  1.769700e+06,  1.203600e+06, -1.085000e+05,
        -6.970000e+04, -2.593000e+05, -2.001000e+05,  8.194000e+05,
         3.998000e+05,  8.857000e+05, -4.738000e+05, -6.900000e+05,
        -7.680000e+04, -7.690000e+04, -7.740000e+04, -7.730000e+04,
        -8.390000e+04, -7.590000e+04,  1.089400e+06, -6.644000e+05,
        -6.084000e+05,  3.653000e+05, -7.500000e+04, -5.920000e+04,
         2.564000e+05, -2.899000e+05, -2.394000e+05, -2.394000e+05,
        -2.087000e+05, -1.787000e+05, -1.956000e+05, -1.413000e+05,
        -5.200000e+03, -4.442000e+05, -2.905000e+05, -1.763000e+05,
         3.068000e+05, -1.855000e+05, -2.916000e+05,  6.695000e+05,
         6.705000e+05, -2.023000e+05, -1.794000e+05,  3.091000e+06,
        -6.280000e+04, -8.330000e+04, -8.900000e+03,  8.449000e+05,
         8.449000e+05,  8.449000e+05,  8.449000e+05, -2.950000e+04,
         3.583000e+05,  3.583000e+05, -8.170000e+04, -1.740000e+04,
         1.270000e+04, -2.068000e+05, -1.266000e+05, -8.830000e+04,
         2.300000e+03,  2.300000e+03, -6.720000e+04, -6.720000e+04,
        -6.720000e+04,  1.965300e+06, -2.229000e+05,  9.901000e+05,
         1.533200e+06,  1.212400e+06, -9.640000e+04, -3.750000e+04,
         2.937900e+06, -1.226000e+05,  2.937900e+06, -1.184000e+05,
         1.962100e+06,  1.476100e+06,  9.903000e+05, -2.716000e+05,
         3.463000e+05, -9.280000e+04, -1.705000e+05, -2.985000e+05,
         1.834000e+05, -2.539000e+05, -9.400000e+04, -2.028000e+05,
         1.076100e+06, -2.337000e+05, -1.972000e+05,  5.941000e+05,
         1.310200e+06,  2.097500e+06,  1.610000e+06,  2.585100e+06,
        -9.740000e+04, -2.470000e+04,  7.089000e+05, -1.691000e+05,
        -1.228000e+05,  1.247300e+06, -7.350000e+04,  7.658000e+05,
        -1.251000e+05, -5.940000e+04,  1.227800e+06, -8.890000e+04,
        -2.084000e+05, -1.777000e+05,  1.278900e+06,  1.279000e+06,
        -2.600000e+04, -2.596000e+05,  1.935300e+06,  2.067660e+07,
        -3.470000e+04, -3.470000e+04, -2.386000e+05, -2.388000e+05,
        -1.433000e+05, -2.378000e+05, -3.844000e+05, -2.388000e+05,
        -1.620000e+04, -1.620000e+04, -1.620000e+04, -1.630000e+04,
        -1.150000e+04,  5.700000e+03,  5.700000e+03,  5.700000e+03,
         3.420000e+04, -1.961000e+05, -2.173000e+05, -4.828000e+05,
        -1.738000e+05, -1.718000e+05, -2.185000e+05, -2.175000e+05,
        -1.740000e+04, -4.340000e+04,  3.300000e+03,  3.873000e+05,
        -5.000000e+02, -4.300000e+03, -6.030000e+04,  4.424000e+05,
         1.300000e+03, -4.480000e+05,  0.000000e+00,  0.000000e+00,
         1.350000e+04,  4.319000e+05,  3.700000e+03,  2.700000e+03,
         0.000000e+00,  0.000000e+00,  3.789000e+05, -6.040000e+04,
         1.600000e+03,  1.432000e+05,  3.600000e+03,  0.000000e+00,
         4.359000e+05, -2.910000e+04,  1.100000e+03, -5.300000e+04,
        -5.300000e+04,  4.271000e+05, -2.000000e+03,  2.500000e+03,
         3.712000e+05, -5.540000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.000000e+03, -1.500000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  3.873000e+05, -4.340000e+04,
        -7.900000e+03, -1.620000e+04,  1.000000e+03,  8.704000e+05,
        -1.320000e+04, -6.720000e+04,  8.449000e+05,  3.583000e+05,
        -7.720000e+04, -1.433000e+05, -2.388000e+05, -3.470000e+04,
         5.700000e+03, -2.173000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.620000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-8.500000e+03,  2.800000e+03,  9.700000e+03,  3.124000e+05,
         1.517000e+05, -4.900000e+04, -3.210000e+04, -7.300000e+03,
         2.800000e+03, -6.800000e+03,  2.800000e+03,  1.100000e+04,
         6.200000e+03, -7.250000e+04,  1.747000e+05,  1.210000e+04,
         1.600000e+03,  4.390000e+04, -3.250000e+04, -2.540000e+04,
        -5.540000e+04,  4.937000e+05,  4.925000e+05,  6.000000e+04,
         6.600000e+04,  1.501000e+05,  7.560000e+04,  3.079300e+06,
        -3.820000e+04, -3.850000e+04, -3.760000e+04, -3.870000e+04,
        -7.360000e+04, -3.850000e+04, -4.806000e+05, -4.712000e+05,
        -5.111000e+05, -5.920000e+04, -5.690000e+04, -6.680000e+04,
         4.641000e+05,  7.639000e+05,  3.291000e+05,  3.292000e+05,
         3.339000e+05,  3.349000e+05,  3.106000e+05,  1.642000e+05,
         6.516000e+05,  6.539000e+05,  6.776000e+05,  2.620000e+05,
         3.266000e+05,  4.874000e+05,  7.648000e+05, -1.460000e+04,
        -1.460000e+04, -8.600000e+03, -2.980000e+04, -6.280000e+04,
         8.102000e+05,  2.116000e+05,  2.610000e+04,  2.580000e+04,
         2.580000e+04,  2.580000e+04,  2.580000e+04,  3.720000e+04,
        -5.780000e+04,  1.900000e+05,  1.956000e+05, -9.600000e+03,
         5.400000e+03,  3.590000e+04,  1.163000e+05,  1.414000e+05,
         1.940000e+04,  1.940000e+04,  1.747000e+05,  1.746000e+05,
         1.747000e+05,  4.540000e+05,  4.812000e+05,  3.048000e+05,
         2.809000e+05,  5.370000e+04,  6.840000e+04,  9.590000e+04,
         1.245000e+05,  1.643000e+05,  1.245000e+05,  1.644000e+05,
        -4.130000e+04, -2.992000e+05, -3.828000e+05, -2.787000e+05,
        -2.560000e+04, -2.330000e+04,  1.306000e+05, -5.990000e+04,
         2.590000e+04,  2.870000e+04, -4.880000e+04,  9.260000e+04,
        -5.380000e+04, -3.670000e+04, -7.670000e+04, -1.394000e+05,
        -4.050000e+04, -7.440000e+04, -1.578000e+05,  9.100000e+03,
        -6.280000e+04, -1.124000e+05, -8.560000e+04, -8.100000e+04,
         6.430000e+04,  7.290000e+04,  7.970000e+04, -1.280000e+04,
         6.550000e+04,  9.010000e+04,  7.810000e+04, -4.500000e+03,
         3.497000e+05,  3.544000e+05,  2.700000e+03,  2.700000e+03,
         2.130000e+04,  8.890000e+04,  7.730000e+04,  1.389000e+05,
         2.350000e+04,  2.350000e+04,  1.190000e+04,  1.190000e+04,
         1.718000e+05,  1.190000e+04,  2.800000e+04,  1.190000e+04,
         3.440000e+04,  3.440000e+04,  3.440000e+04,  3.440000e+04,
         3.360000e+04, -3.650000e+04, -3.650000e+04, -3.650000e+04,
        -2.189000e+05, -5.670000e+04, -2.240000e+04,  6.535000e+05,
         2.381000e+05,  2.354000e+05,  3.385000e+05,  3.385000e+05,
        -1.080000e+04,  1.302000e+05,  5.175000e+05, -1.470000e+04,
        -9.000000e+03, -3.700000e+03, -7.250000e+04,  1.100000e+04,
        -2.890000e+04,  2.130000e+04,  0.000000e+00, -1.000000e+02,
         3.957000e+05,  4.965000e+05,  4.981000e+05, -7.900000e+03,
         0.000000e+00,  0.000000e+00, -9.090000e+04, -9.100000e+04,
        -4.640000e+04, -1.680000e+04,  4.813000e+05,  0.000000e+00,
        -1.520000e+04, -3.660000e+04, -1.450000e+04,  1.387000e+05,
         1.387000e+05, -2.220000e+04, -1.820000e+04, -5.500000e+03,
         1.162000e+05,  1.205000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.100000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.470000e+04,  1.302000e+05,
        -9.500000e+03,  3.440000e+04,  0.000000e+00, -8.500000e+03,
         2.800000e+03,  1.746000e+05,  2.580000e+04,  1.900000e+05,
        -3.870000e+04,  1.718000e+05,  1.190000e+04,  2.350000e+04,
        -3.650000e+04, -2.240000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  3.440000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 8.700000e+03,  7.090000e+04,  6.210000e+04,  3.119000e+05,
         1.737000e+05,  1.400000e+03, -1.600000e+04,  1.080000e+04,
         7.090000e+04,  1.170000e+04,  7.090000e+04,  4.980000e+04,
         3.140000e+04, -1.530000e+05,  2.431800e+06,  5.180000e+04,
         7.500000e+03,  1.992000e+05,  9.100000e+03,  1.039000e+05,
         9.190000e+04,  5.476000e+05,  6.910000e+05,  2.071000e+05,
         3.157000e+05,  5.225000e+05,  3.771000e+05,  3.433500e+06,
        -5.500000e+04, -5.500000e+04, -5.500000e+04, -5.490000e+04,
        -1.422000e+05, -5.510000e+04, -8.185000e+05, -6.919000e+05,
        -7.081000e+05, -9.940000e+04, -6.790000e+04, -7.180000e+04,
         5.093000e+05,  7.764000e+05,  3.309000e+05,  3.309000e+05,
         3.986000e+05,  4.691000e+05,  3.957000e+05,  1.760000e+05,
         6.976000e+05,  7.292000e+05,  1.068100e+06,  2.071000e+05,
         4.080000e+05,  5.626000e+05,  7.954000e+05,  9.620000e+04,
         9.610000e+04,  1.587000e+05,  1.514000e+05, -8.330000e+04,
         2.116000e+05,  6.983600e+06,  7.520000e+04,  1.079000e+05,
         1.079000e+05,  1.079000e+05,  1.079000e+05,  1.689000e+05,
        -9.880000e+04,  2.980000e+05,  3.286000e+05, -1.760000e+04,
         4.730000e+04,  8.110000e+04,  8.030000e+04,  1.816000e+05,
         7.090000e+04,  7.090000e+04,  2.395000e+05,  2.395000e+05,
         2.635000e+05,  8.553000e+05,  1.008400e+06,  4.334000e+05,
         3.291000e+05,  2.243000e+05,  3.154000e+05,  4.481000e+05,
         4.753000e+05,  6.887000e+05,  4.753000e+05,  6.889000e+05,
         6.260000e+04, -5.926000e+05, -7.994000e+05, -4.700000e+05,
        -1.300000e+03,  3.030000e+04,  9.382000e+05, -1.293000e+05,
         7.770000e+04,  1.092000e+05, -7.290000e+04,  2.280000e+04,
        -1.062000e+05, -1.650000e+04, -2.340000e+04, -3.133000e+05,
        -5.580000e+04, -8.100000e+04, -2.876000e+05,  1.255000e+05,
         7.690000e+04,  5.700000e+04, -1.005000e+05, -3.740000e+04,
         2.361000e+05,  2.596000e+05,  3.542000e+05,  5.270000e+04,
         2.388000e+05,  3.512000e+05,  2.492000e+05,  3.990000e+04,
         4.101000e+05,  4.779000e+05,  5.810000e+04,  5.810000e+04,
         1.552000e+05,  4.687000e+05,  3.108000e+05,  1.195000e+06,
         8.000000e+04,  8.010000e+04,  2.360000e+04,  2.360000e+04,
         1.746000e+05,  2.350000e+04,  4.200000e+03,  2.360000e+04,
         9.800000e+04,  9.800000e+04,  9.800000e+04,  9.790000e+04,
         9.680000e+04, -1.141000e+05, -1.141000e+05, -1.141000e+05,
        -6.847000e+05, -1.735000e+05, -7.500000e+04,  6.352000e+05,
         3.709000e+05,  3.713000e+05,  6.650000e+05,  6.649000e+05,
        -1.790000e+04,  1.073000e+05, -1.030000e+04, -3.230000e+04,
        -7.600000e+03, -5.100000e+03, -1.530000e+05,  4.980000e+04,
        -2.530000e+04,  4.530000e+04,  0.000000e+00, -3.000000e+02,
        -2.150000e+04, -5.690000e+04, -2.250000e+04, -2.260000e+04,
         0.000000e+00,  0.000000e+00, -1.975000e+05, -1.653000e+05,
        -3.800000e+04, -2.230000e+04, -2.170000e+04,  0.000000e+00,
        -3.330000e+04, -7.760000e+04, -1.270000e+04,  1.112000e+05,
         1.113000e+05, -4.730000e+04, -1.330000e+04, -6.900000e+03,
         6.970000e+04,  9.880000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02, -7.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.230000e+04,  1.073000e+05,
        -2.010000e+04,  9.800000e+04, -1.000000e+02,  8.700000e+03,
         7.090000e+04,  2.395000e+05,  1.079000e+05,  2.980000e+05,
        -5.490000e+04,  1.746000e+05,  2.360000e+04,  8.010000e+04,
        -1.141000e+05, -7.500000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  9.800000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.550000e+04,  3.770000e+04,  3.190000e+04,  5.000000e+03,
         1.020000e+04,  4.860000e+04,  1.770000e+04,  1.610000e+04,
         3.770000e+04,  1.640000e+04,  3.770000e+04,  3.110000e+04,
         1.650000e+04, -6.170000e+04,  2.670000e+04,  3.180000e+04,
         3.900000e+03,  1.246000e+05,  3.390000e+04,  6.990000e+04,
         5.950000e+04,  1.830000e+04,  6.970000e+04,  1.118000e+05,
         1.966000e+05,  2.900000e+05,  2.202000e+05,  8.340000e+04,
        -1.250000e+04, -1.240000e+04, -1.240000e+04, -1.270000e+04,
        -5.260000e+04, -1.250000e+04, -2.555000e+05, -2.078000e+05,
        -2.214000e+05, -2.940000e+04, -1.810000e+04, -2.090000e+04,
         1.520000e+04, -1.130000e+04,  1.000000e+04,  1.000000e+04,
         3.580000e+04,  6.150000e+04,  3.200000e+04,  1.420000e+04,
         3.380000e+04,  4.540000e+04,  1.740000e+05, -5.740000e+04,
         3.700000e+04,  3.170000e+04, -1.090000e+04,  8.840000e+04,
         8.830000e+04,  1.123000e+05,  1.054000e+05, -8.900000e+03,
         2.610000e+04,  7.520000e+04,  2.445000e+06,  6.360000e+04,
         6.360000e+04,  6.360000e+04,  6.360000e+04,  8.700000e+04,
        -2.960000e+04,  5.890000e+04,  7.030000e+04, -7.900000e+03,
         1.740000e+04,  3.120000e+04, -3.510000e+04,  5.640000e+04,
         3.600000e+04,  3.600000e+04,  2.670000e+04,  2.670000e+04,
         2.670000e+04,  2.622000e+05,  3.204000e+05,  7.500000e+04,
         1.850000e+04,  1.284000e+05,  1.629000e+05,  2.157000e+05,
         2.716000e+05,  3.534000e+05,  2.716000e+05,  3.539000e+05,
         8.530000e+04, -2.157000e+05, -3.089000e+05, -1.687000e+05,
         1.920000e+04,  3.080000e+04,  4.914000e+05, -5.230000e+04,
         4.120000e+04,  5.330000e+04, -2.080000e+04, -4.750000e+04,
        -4.290000e+04, -7.900000e+03, -1.730000e+04, -1.365000e+05,
        -8.200000e+03,  6.000000e+02, -9.280000e+04,  9.410000e+04,
         5.870000e+04,  4.330000e+04, -1.100000e+04,  1.230000e+04,
         1.341000e+05,  1.442000e+05,  1.781000e+05,  5.080000e+04,
         1.357000e+05,  1.799000e+05,  1.397000e+05,  3.520000e+04,
         4.090000e+04,  6.660000e+04,  4.570000e+04,  4.570000e+04,
         8.110000e+04,  2.507000e+05,  1.926000e+05,  8.528000e+05,
         4.090000e+04,  4.090000e+04,  9.500000e+03,  9.500000e+03,
         1.430000e+04,  9.500000e+03, -1.790000e+04,  9.500000e+03,
         4.940000e+04,  4.950000e+04,  4.950000e+04,  4.930000e+04,
         4.890000e+04, -5.330000e+04, -5.320000e+04, -5.320000e+04,
        -3.196000e+05, -8.790000e+04, -3.920000e+04,  2.150000e+04,
         1.129000e+05,  1.129000e+05,  2.609000e+05,  2.608000e+05,
        -8.500000e+03, -2.080000e+04, -5.000000e+02, -1.300000e+04,
        -3.300000e+03, -3.000000e+03, -6.170000e+04,  3.110000e+04,
        -1.030000e+04,  1.640000e+04,  0.000000e+00,  0.000000e+00,
        -7.600000e+03, -1.950000e+04, -5.900000e+03,  2.318000e+06,
         0.000000e+00,  0.000000e+00, -7.800000e+04, -6.720000e+04,
        -1.580000e+04, -8.700000e+03, -5.700000e+03,  0.000000e+00,
        -1.320000e+04, -3.150000e+04, -5.200000e+03, -2.130000e+04,
        -2.130000e+04, -1.860000e+04, -5.200000e+03, -3.100000e+03,
        -3.970000e+04, -2.640000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  4.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.300000e+04, -2.080000e+04,
        -8.100000e+03,  4.940000e+04,  0.000000e+00,  1.550000e+04,
         3.770000e+04,  2.670000e+04,  6.360000e+04,  5.890000e+04,
        -1.270000e+04,  1.430000e+04,  9.500000e+03,  4.090000e+04,
        -5.320000e+04, -3.920000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.940000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 3.012000e+05,  6.110000e+04,  7.520000e+04, -2.990000e+04,
         1.351000e+05,  1.285000e+06,  6.827000e+05,  2.962000e+05,
         6.110000e+04,  2.938000e+05,  6.110000e+04,  2.006000e+05,
         3.330000e+04, -1.274000e+05,  2.600000e+04,  1.954000e+05,
         7.000000e+03,  8.024000e+05,  4.550000e+05,  8.940000e+04,
         1.160000e+05, -4.820000e+04,  6.000000e+04,  4.769000e+05,
         4.766000e+05,  7.997000e+05,  2.312000e+05, -5.930000e+04,
        -4.620000e+04, -4.620000e+04, -4.660000e+04, -4.490000e+04,
        -1.181000e+05, -4.630000e+04, -8.710000e+04, -5.743000e+05,
        -5.391000e+05,  6.410000e+04, -5.590000e+04, -4.890000e+04,
         1.047000e+05, -1.157000e+05, -5.690000e+04, -5.690000e+04,
        -2.500000e+03,  5.170000e+04,  6.500000e+03, -1.990000e+04,
         6.010000e+04, -6.070000e+04,  2.113000e+05, -1.558000e+05,
         1.611000e+05, -3.900000e+03, -1.149000e+05,  3.746000e+05,
         3.745000e+05,  1.322000e+05,  1.487000e+05,  8.449000e+05,
         2.580000e+04,  1.079000e+05,  6.360000e+04,  3.891000e+05,
         3.891000e+05,  3.890000e+05,  3.890000e+05,  1.423000e+05,
         6.550000e+04,  2.185000e+05,  9.720000e+04, -1.680000e+04,
         3.780000e+04, -6.500000e+03, -1.009000e+05,  7.160000e+04,
         6.890000e+04,  6.890000e+04,  2.600000e+04,  2.600000e+04,
         2.600000e+04,  1.102600e+06,  4.888000e+05,  4.599000e+05,
         5.081000e+05,  6.315000e+05,  2.613000e+05,  3.725000e+05,
         1.442700e+06,  5.790000e+05,  1.442700e+06,  5.791000e+05,
         7.908000e+05,  9.060000e+04, -2.332000e+05, -4.010000e+05,
         1.479000e+05,  2.720000e+04,  8.001000e+05, -1.888000e+05,
         1.328000e+05,  1.090000e+04, -6.300000e+04, -1.472000e+05,
         2.764000e+05, -9.120000e+04, -6.260000e+04, -4.510000e+04,
         3.844000e+05,  6.698000e+05,  3.477000e+05,  9.918000e+05,
         6.590000e+04,  1.048000e+05,  2.146000e+05, -2.700000e+04,
         1.950000e+05,  6.650000e+05,  3.052000e+05,  3.430000e+05,
         1.969000e+05,  2.945000e+05,  6.314000e+05,  3.230000e+04,
         6.600000e+03,  6.090000e+04,  4.938000e+05,  4.938000e+05,
         1.319000e+05,  3.531000e+05,  9.570000e+05,  8.086900e+06,
         6.450000e+04,  6.460000e+04, -6.130000e+04, -6.130000e+04,
        -1.960000e+04, -6.150000e+04, -1.577000e+05, -6.130000e+04,
         8.120000e+04,  8.120000e+04,  8.120000e+04,  8.120000e+04,
         8.430000e+04, -9.950000e+04, -9.940000e+04, -9.940000e+04,
        -5.969000e+05, -2.313000e+05, -1.464000e+05, -1.141000e+05,
         1.425000e+05,  1.422000e+05,  3.854000e+05,  3.853000e+05,
        -1.670000e+04, -4.910000e+04, -3.000000e+02,  7.820000e+04,
        -6.800000e+03, -8.900000e+03, -1.274000e+05,  2.006000e+05,
        -1.810000e+04, -1.066000e+05,  0.000000e+00,  1.000000e+02,
        -1.000000e+02,  1.025000e+05, -9.000000e+03, -1.910000e+04,
         0.000000e+00,  0.000000e+00, -2.060000e+04, -1.364000e+05,
        -2.740000e+04,  2.990000e+04, -8.700000e+03,  0.000000e+00,
         8.030000e+04, -6.470000e+04, -9.100000e+03, -5.540000e+04,
        -5.540000e+04,  1.029000e+05, -9.400000e+03, -3.900000e+03,
         4.580000e+04, -6.500000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -2.000000e+02,  1.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  7.820000e+04, -4.910000e+04,
        -1.670000e+04,  8.120000e+04, -2.000000e+02,  3.012000e+05,
         6.110000e+04,  2.600000e+04,  3.891000e+05,  2.185000e+05,
        -4.500000e+04, -1.960000e+04, -6.130000e+04,  6.460000e+04,
        -9.950000e+04, -1.464000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  8.120000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 3.012000e+05,  6.110000e+04,  7.520000e+04, -2.990000e+04,
         1.351000e+05,  1.285000e+06,  6.827000e+05,  2.962000e+05,
         6.110000e+04,  2.938000e+05,  6.110000e+04,  2.006000e+05,
         3.330000e+04, -1.274000e+05,  2.600000e+04,  1.954000e+05,
         7.000000e+03,  8.024000e+05,  4.550000e+05,  8.940000e+04,
         1.160000e+05, -4.820000e+04,  6.000000e+04,  4.769000e+05,
         4.766000e+05,  7.997000e+05,  2.312000e+05, -5.930000e+04,
        -4.620000e+04, -4.620000e+04, -4.660000e+04, -4.490000e+04,
        -1.181000e+05, -4.630000e+04, -8.710000e+04, -5.743000e+05,
        -5.391000e+05,  6.410000e+04, -5.590000e+04, -4.890000e+04,
         1.047000e+05, -1.157000e+05, -5.690000e+04, -5.690000e+04,
        -2.500000e+03,  5.170000e+04,  6.500000e+03, -1.990000e+04,
         6.010000e+04, -6.070000e+04,  2.113000e+05, -1.558000e+05,
         1.611000e+05, -3.900000e+03, -1.149000e+05,  3.746000e+05,
         3.745000e+05,  1.322000e+05,  1.487000e+05,  8.449000e+05,
         2.580000e+04,  1.079000e+05,  6.360000e+04,  3.891000e+05,
         3.905000e+05,  3.890000e+05,  3.890000e+05,  1.423000e+05,
         6.550000e+04,  2.185000e+05,  9.720000e+04, -1.680000e+04,
         3.780000e+04, -6.500000e+03, -1.009000e+05,  7.160000e+04,
         6.890000e+04,  6.890000e+04,  2.600000e+04,  2.600000e+04,
         2.600000e+04,  1.102600e+06,  4.888000e+05,  4.599000e+05,
         5.081000e+05,  6.315000e+05,  2.613000e+05,  3.725000e+05,
         1.442700e+06,  5.790000e+05,  1.442700e+06,  5.791000e+05,
         7.908000e+05,  9.060000e+04, -2.332000e+05, -4.010000e+05,
         1.479000e+05,  2.720000e+04,  8.001000e+05, -1.888000e+05,
         1.328000e+05,  1.090000e+04, -6.300000e+04, -1.472000e+05,
         2.764000e+05, -9.120000e+04, -6.260000e+04, -4.510000e+04,
         3.844000e+05,  6.698000e+05,  3.477000e+05,  9.918000e+05,
         6.590000e+04,  1.048000e+05,  2.146000e+05, -2.700000e+04,
         1.950000e+05,  6.650000e+05,  3.052000e+05,  3.430000e+05,
         1.969000e+05,  2.945000e+05,  6.314000e+05,  3.230000e+04,
         6.600000e+03,  6.090000e+04,  4.938000e+05,  4.938000e+05,
         1.319000e+05,  3.531000e+05,  9.570000e+05,  8.086900e+06,
         6.450000e+04,  6.460000e+04, -6.130000e+04, -6.130000e+04,
        -1.960000e+04, -6.150000e+04, -1.577000e+05, -6.130000e+04,
         8.120000e+04,  8.120000e+04,  8.120000e+04,  8.120000e+04,
         8.430000e+04, -9.950000e+04, -9.940000e+04, -9.940000e+04,
        -5.969000e+05, -2.313000e+05, -1.464000e+05, -1.141000e+05,
         1.425000e+05,  1.422000e+05,  3.854000e+05,  3.853000e+05,
        -1.670000e+04, -4.910000e+04, -3.000000e+02,  7.820000e+04,
        -6.800000e+03, -8.900000e+03, -1.274000e+05,  2.006000e+05,
        -1.810000e+04, -1.066000e+05,  0.000000e+00,  1.000000e+02,
        -1.000000e+02,  1.025000e+05, -9.000000e+03, -1.910000e+04,
         0.000000e+00,  0.000000e+00, -2.060000e+04, -1.364000e+05,
        -2.740000e+04,  2.990000e+04, -8.700000e+03,  0.000000e+00,
         8.030000e+04, -6.470000e+04, -9.100000e+03, -5.540000e+04,
        -5.540000e+04,  1.029000e+05, -9.400000e+03, -3.900000e+03,
         4.580000e+04, -6.500000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -2.000000e+02,  1.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  7.820000e+04, -4.910000e+04,
        -1.670000e+04,  8.120000e+04, -2.000000e+02,  3.012000e+05,
         6.110000e+04,  2.600000e+04,  3.891000e+05,  2.185000e+05,
        -4.500000e+04, -1.960000e+04, -6.130000e+04,  6.460000e+04,
        -9.950000e+04, -1.464000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  8.120000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 3.012000e+05,  6.110000e+04,  7.520000e+04, -2.990000e+04,
         1.351000e+05,  1.285000e+06,  6.827000e+05,  2.962000e+05,
         6.110000e+04,  2.937000e+05,  6.110000e+04,  2.006000e+05,
         3.330000e+04, -1.273000e+05,  2.600000e+04,  1.954000e+05,
         7.000000e+03,  8.024000e+05,  4.549000e+05,  8.940000e+04,
         1.160000e+05, -4.820000e+04,  6.000000e+04,  4.769000e+05,
         4.766000e+05,  7.996000e+05,  2.312000e+05, -5.930000e+04,
        -4.620000e+04, -4.620000e+04, -4.660000e+04, -4.490000e+04,
        -1.181000e+05, -4.630000e+04, -8.710000e+04, -5.742000e+05,
        -5.390000e+05,  6.410000e+04, -5.590000e+04, -4.890000e+04,
         1.047000e+05, -1.157000e+05, -5.690000e+04, -5.690000e+04,
        -2.500000e+03,  5.170000e+04,  6.500000e+03, -1.990000e+04,
         6.010000e+04, -6.070000e+04,  2.113000e+05, -1.558000e+05,
         1.611000e+05, -3.900000e+03, -1.149000e+05,  3.746000e+05,
         3.745000e+05,  1.322000e+05,  1.486000e+05,  8.449000e+05,
         2.580000e+04,  1.079000e+05,  6.360000e+04,  3.890000e+05,
         3.890000e+05,  3.898000e+05,  3.890000e+05,  1.423000e+05,
         6.550000e+04,  2.185000e+05,  9.710000e+04, -1.680000e+04,
         3.780000e+04, -6.500000e+03, -1.009000e+05,  7.160000e+04,
         6.890000e+04,  6.890000e+04,  2.600000e+04,  2.600000e+04,
         2.600000e+04,  1.102600e+06,  4.887000e+05,  4.599000e+05,
         5.080000e+05,  6.315000e+05,  2.613000e+05,  3.725000e+05,
         1.442600e+06,  5.790000e+05,  1.442600e+06,  5.790000e+05,
         7.908000e+05,  9.060000e+04, -2.332000e+05, -4.010000e+05,
         1.479000e+05,  2.720000e+04,  8.000000e+05, -1.887000e+05,
         1.328000e+05,  1.090000e+04, -6.300000e+04, -1.472000e+05,
         2.764000e+05, -9.120000e+04, -6.260000e+04, -4.510000e+04,
         3.844000e+05,  6.697000e+05,  3.477000e+05,  9.917000e+05,
         6.590000e+04,  1.048000e+05,  2.146000e+05, -2.700000e+04,
         1.950000e+05,  6.650000e+05,  3.051000e+05,  3.430000e+05,
         1.968000e+05,  2.944000e+05,  6.313000e+05,  3.230000e+04,
         6.500000e+03,  6.090000e+04,  4.938000e+05,  4.938000e+05,
         1.319000e+05,  3.530000e+05,  9.569000e+05,  8.088800e+06,
         6.450000e+04,  6.460000e+04, -6.130000e+04, -6.130000e+04,
        -1.960000e+04, -6.150000e+04, -1.577000e+05, -6.130000e+04,
         8.120000e+04,  8.120000e+04,  8.120000e+04,  8.120000e+04,
         8.430000e+04, -9.950000e+04, -9.940000e+04, -9.940000e+04,
        -5.968000e+05, -2.313000e+05, -1.464000e+05, -1.141000e+05,
         1.425000e+05,  1.421000e+05,  3.854000e+05,  3.852000e+05,
        -1.670000e+04, -4.910000e+04, -3.000000e+02,  7.810000e+04,
        -6.800000e+03, -8.900000e+03, -1.273000e+05,  2.006000e+05,
        -1.810000e+04, -1.067000e+05,  0.000000e+00,  1.000000e+02,
        -1.000000e+02,  1.025000e+05, -9.000000e+03, -1.910000e+04,
         0.000000e+00,  0.000000e+00, -2.060000e+04, -1.364000e+05,
        -2.740000e+04,  2.990000e+04, -8.700000e+03,  0.000000e+00,
         8.030000e+04, -6.470000e+04, -9.100000e+03, -5.540000e+04,
        -5.540000e+04,  1.029000e+05, -9.400000e+03, -3.900000e+03,
         4.580000e+04, -6.500000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -2.000000e+02,  1.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  7.810000e+04, -4.910000e+04,
        -1.670000e+04,  8.120000e+04, -2.000000e+02,  3.012000e+05,
         6.110000e+04,  2.600000e+04,  3.890000e+05,  2.185000e+05,
        -4.500000e+04, -1.960000e+04, -6.130000e+04,  6.460000e+04,
        -9.940000e+04, -1.464000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  8.120000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 3.012000e+05,  6.110000e+04,  7.520000e+04, -2.990000e+04,
         1.351000e+05,  1.285000e+06,  6.827000e+05,  2.963000e+05,
         6.110000e+04,  2.938000e+05,  6.110000e+04,  2.007000e+05,
         3.330000e+04, -1.274000e+05,  2.600000e+04,  1.954000e+05,
         7.000000e+03,  8.027000e+05,  4.550000e+05,  8.940000e+04,
         1.160000e+05, -4.820000e+04,  6.000000e+04,  4.769000e+05,
         4.766000e+05,  7.997000e+05,  2.312000e+05, -5.930000e+04,
        -4.620000e+04, -4.620000e+04, -4.660000e+04, -4.490000e+04,
        -1.181000e+05, -4.630000e+04, -8.710000e+04, -5.743000e+05,
        -5.391000e+05,  6.410000e+04, -5.590000e+04, -4.890000e+04,
         1.047000e+05, -1.157000e+05, -5.690000e+04, -5.690000e+04,
        -2.500000e+03,  5.170000e+04,  6.500000e+03, -1.990000e+04,
         6.010000e+04, -6.070000e+04,  2.113000e+05, -1.558000e+05,
         1.611000e+05, -3.900000e+03, -1.149000e+05,  3.746000e+05,
         3.745000e+05,  1.322000e+05,  1.486000e+05,  8.449000e+05,
         2.580000e+04,  1.079000e+05,  6.360000e+04,  3.890000e+05,
         3.890000e+05,  3.890000e+05,  3.912000e+05,  1.423000e+05,
         6.550000e+04,  2.185000e+05,  9.720000e+04, -1.680000e+04,
         3.780000e+04, -6.500000e+03, -1.009000e+05,  7.160000e+04,
         6.890000e+04,  6.890000e+04,  2.600000e+04,  2.600000e+04,
         2.600000e+04,  1.102600e+06,  4.888000e+05,  4.599000e+05,
         5.081000e+05,  6.315000e+05,  2.613000e+05,  3.725000e+05,
         1.442700e+06,  5.790000e+05,  1.442700e+06,  5.791000e+05,
         7.908000e+05,  9.060000e+04, -2.332000e+05, -4.010000e+05,
         1.479000e+05,  2.720000e+04,  8.001000e+05, -1.888000e+05,
         1.328000e+05,  1.090000e+04, -6.300000e+04, -1.472000e+05,
         2.764000e+05, -9.120000e+04, -6.260000e+04, -4.510000e+04,
         3.844000e+05,  6.698000e+05,  3.477000e+05,  9.918000e+05,
         6.590000e+04,  1.048000e+05,  2.146000e+05, -2.700000e+04,
         1.950000e+05,  6.650000e+05,  3.052000e+05,  3.430000e+05,
         1.969000e+05,  2.945000e+05,  6.314000e+05,  3.230000e+04,
         6.600000e+03,  6.090000e+04,  4.938000e+05,  4.938000e+05,
         1.319000e+05,  3.531000e+05,  9.570000e+05,  8.086900e+06,
         6.450000e+04,  6.460000e+04, -6.130000e+04, -6.130000e+04,
        -1.960000e+04, -6.150000e+04, -1.577000e+05, -6.130000e+04,
         8.120000e+04,  8.120000e+04,  8.120000e+04,  8.120000e+04,
         8.430000e+04, -9.950000e+04, -9.940000e+04, -9.940000e+04,
        -5.969000e+05, -2.313000e+05, -1.464000e+05, -1.141000e+05,
         1.425000e+05,  1.422000e+05,  3.854000e+05,  3.853000e+05,
        -1.670000e+04, -4.910000e+04, -3.000000e+02,  7.820000e+04,
        -6.800000e+03, -8.900000e+03, -1.274000e+05,  2.007000e+05,
        -1.810000e+04, -1.067000e+05,  0.000000e+00,  1.000000e+02,
        -1.000000e+02,  1.025000e+05, -9.000000e+03, -1.910000e+04,
         0.000000e+00,  0.000000e+00, -2.060000e+04, -1.364000e+05,
        -2.740000e+04,  2.990000e+04, -8.700000e+03,  0.000000e+00,
         8.030000e+04, -6.470000e+04, -9.100000e+03, -5.540000e+04,
        -5.540000e+04,  1.029000e+05, -9.400000e+03, -3.900000e+03,
         4.580000e+04, -6.500000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -2.000000e+02,  1.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  7.820000e+04, -4.910000e+04,
        -1.670000e+04,  8.120000e+04, -2.000000e+02,  3.012000e+05,
         6.110000e+04,  2.600000e+04,  3.890000e+05,  2.185000e+05,
        -4.500000e+04, -1.960000e+04, -6.130000e+04,  6.460000e+04,
        -9.940000e+04, -1.464000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  8.120000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 3.050000e+04,  4.564000e+05,  7.270000e+04,  5.300000e+03,
         1.800000e+04,  9.200000e+04,  3.100000e+04,  3.250000e+04,
         4.564000e+05,  3.350000e+04,  4.562000e+05,  6.860000e+04,
         1.108000e+05, -1.498000e+05,  5.810000e+04,  7.100000e+04,
         2.580000e+04,  2.746000e+05,  6.390000e+04,  6.282000e+05,
         1.319000e+05,  2.390000e+04,  4.597000e+05,  2.541000e+05,
         4.437000e+05,  6.645000e+05,  8.606000e+05,  7.080000e+04,
        -3.460000e+04, -3.460000e+04, -3.400000e+04, -3.550000e+04,
        -1.300000e+05, -3.470000e+04, -6.598000e+05,  9.200000e+04,
        -5.691000e+05, -7.730000e+04,  1.090000e+05, -5.460000e+04,
         2.340000e+04, -4.130000e+04,  6.300000e+03,  6.300000e+03,
         2.277000e+05,  4.468000e+05,  5.980000e+04,  2.330000e+04,
         4.430000e+04,  2.314000e+05,  1.338600e+06, -1.480000e+05,
         7.600000e+04,  6.340000e+04, -4.070000e+04,  1.883000e+05,
         1.882000e+05,  5.765000e+05,  2.337000e+05, -2.950000e+04,
         3.720000e+04,  1.689000e+05,  8.700000e+04,  1.423000e+05,
         1.423000e+05,  1.423000e+05,  1.423000e+05,  5.727000e+05,
        -7.790000e+04,  1.285000e+05,  3.424000e+05, -1.830000e+04,
         2.027000e+05,  7.690000e+04, -9.190000e+04,  1.270000e+05,
         8.340000e+04,  8.340000e+04,  5.810000e+04,  5.800000e+04,
         5.810000e+04,  5.845000e+05,  1.657700e+06,  1.435000e+05,
         1.610000e+04,  2.905000e+05,  9.332000e+05,  1.314000e+06,
         6.120000e+05,  2.118300e+06,  6.120000e+05,  2.118900e+06,
         1.708000e+05, -5.376000e+05, -7.577000e+05,  3.048000e+05,
         3.600000e+04,  2.231000e+05,  4.279500e+06, -1.261000e+05,
         9.490000e+04,  2.832000e+05, -5.420000e+04, -1.266000e+05,
        -1.081000e+05,  5.247000e+05, -4.010000e+04, -3.292000e+05,
        -2.660000e+04, -1.910000e+04, -2.397000e+05,  2.014000e+05,
         9.165000e+05,  9.430000e+04, -4.330000e+04,  3.310000e+05,
         3.079000e+05,  3.272000e+05,  8.862000e+05,  1.066000e+05,
         3.119000e+05,  9.732000e+05,  4.153000e+05,  7.670000e+04,
         8.120000e+04,  3.026000e+05,  9.720000e+04,  9.730000e+04,
         7.429000e+05,  1.436800e+06,  5.011000e+05,  1.851300e+06,
         9.540000e+04,  9.550000e+04,  2.400000e+04,  2.400000e+04,
         2.340000e+04,  2.390000e+04, -3.270000e+04,  2.400000e+04,
         1.153000e+05,  1.153000e+05,  1.153000e+05,  1.153000e+05,
         1.141000e+05, -1.233000e+05, -1.232000e+05, -1.232000e+05,
        -7.396000e+05, -2.027000e+05, -8.930000e+04,  1.820000e+04,
         2.539000e+05,  2.537000e+05,  5.996000e+05,  5.995000e+05,
        -1.990000e+04, -5.120000e+04, -2.170000e+04, -2.900000e+04,
         1.003000e+05, -6.500000e+03, -1.498000e+05,  6.860000e+04,
         2.953000e+05,  4.070000e+04,  0.000000e+00, -2.200000e+03,
        -3.690000e+04, -5.990000e+04,  1.200000e+05, -2.620000e+04,
         0.000000e+00,  0.000000e+00, -1.904000e+05, -5.700000e+03,
         4.444000e+05,  7.470000e+04,  1.159000e+05,  0.000000e+00,
        -2.990000e+04, -7.640000e+04,  1.473000e+05, -5.210000e+04,
        -5.200000e+04, -3.750000e+04,  1.485000e+05, -7.300000e+03,
        -8.930000e+04,  9.660000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02,  7.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -2.900000e+04, -5.120000e+04,
        -1.970000e+04,  1.153000e+05, -1.000000e+02,  3.050000e+04,
         4.564000e+05,  5.800000e+04,  1.423000e+05,  1.285000e+05,
        -3.540000e+04,  2.340000e+04,  2.400000e+04,  9.550000e+04,
        -1.232000e+05, -8.930000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.153000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.011000e+05, -3.760000e+04, -1.630000e+04, -7.900000e+04,
         1.090000e+04,  4.562000e+05,  2.540000e+05,  9.800000e+04,
        -3.760000e+04,  9.650000e+04, -3.760000e+04,  3.670000e+04,
        -1.210000e+04,  4.336000e+05, -5.930000e+04,  3.320000e+04,
        -3.200000e+03,  1.466000e+05,  5.375000e+05,  3.143000e+05,
         3.595000e+05,  2.505000e+05, -1.753000e+05,  2.980000e+04,
         6.958000e+05,  2.899000e+05,  5.508000e+05,  1.412400e+06,
         3.930000e+05,  3.932000e+05,  3.942000e+05,  3.923000e+05,
         5.215000e+05,  3.931000e+05,  3.895900e+06,  3.602100e+06,
         3.658500e+06,  4.666000e+05,  3.931000e+05,  4.072000e+05,
        -6.840000e+04, -1.785000e+05,  4.871000e+05,  4.871000e+05,
         2.726000e+05,  5.920000e+04,  2.868000e+05,  3.317000e+05,
         8.310000e+05,  7.571000e+05, -3.154000e+05,  3.512000e+05,
        -4.840000e+04, -1.384000e+05, -1.787000e+05,  8.168000e+05,
         8.167000e+05,  6.684000e+05,  6.981000e+05,  3.583000e+05,
        -5.780000e+04, -9.880000e+04, -2.960000e+04,  6.550000e+04,
         6.550000e+04,  6.550000e+04,  6.550000e+04, -7.790000e+04,
         4.760000e+05, -2.810000e+04, -9.840000e+04,  1.500000e+03,
        -2.126000e+05, -2.533000e+05,  3.724000e+05,  1.248000e+05,
        -2.530000e+04, -2.530000e+04, -5.930000e+04, -5.930000e+04,
        -5.930000e+04,  2.400000e+03, -3.541000e+05,  8.112000e+05,
         5.116000e+05,  6.210000e+04, -1.516000e+05, -5.843000e+05,
         1.896000e+05, -3.124000e+05,  1.896000e+05, -3.132000e+05,
         1.003300e+06,  1.961000e+06,  2.369800e+06,  1.672000e+06,
         4.261000e+05,  3.523000e+05, -4.619000e+05,  3.937000e+05,
        -5.900000e+03, -7.970000e+04,  3.956000e+05,  7.652000e+05,
         1.789000e+05, -3.620000e+04,  8.000000e+02,  5.786000e+05,
         1.676000e+05,  6.779000e+05,  1.082500e+06,  2.733000e+05,
         3.083000e+05,  3.812000e+05,  8.926000e+05,  7.447000e+05,
         2.684000e+05,  5.890000e+04, -1.617000e+05,  4.594000e+05,
         2.731000e+05, -1.573000e+05,  3.890000e+04,  3.470000e+05,
         2.708000e+05,  5.630000e+04,  1.355000e+05,  1.355000e+05,
        -7.680000e+04,  4.740000e+04,  4.170000e+05,  2.059000e+06,
        -3.740000e+04, -3.740000e+04, -3.970000e+04, -3.970000e+04,
         3.315000e+05, -3.980000e+04, -4.323000e+05, -3.970000e+04,
        -4.030000e+04, -4.030000e+04, -4.030000e+04, -4.030000e+04,
        -3.830000e+04,  3.270000e+04,  3.270000e+04,  3.270000e+04,
         1.963000e+05,  3.570000e+04, -2.000000e+03,  9.743000e+05,
         2.508000e+05,  2.507000e+05,  1.296000e+05,  1.295000e+05,
         2.800000e+03, -1.670000e+04,  3.000000e+03,  5.040000e+04,
         2.000000e+02,  6.000000e+02,  4.336000e+05,  3.670000e+04,
         2.600000e+03, -6.840000e+04,  0.000000e+00,  0.000000e+00,
         1.480000e+04,  6.890000e+04,  3.200000e+03,  8.900000e+03,
         0.000000e+00,  0.000000e+00,  5.096000e+05,  4.344000e+05,
         3.300000e+03,  2.350000e+04,  3.100000e+03,  0.000000e+00,
         5.170000e+04,  2.152000e+05,  1.200000e+03, -2.010000e+04,
        -2.010000e+04,  6.570000e+04,  3.000000e+02,  3.200000e+03,
         4.440000e+04, -2.000000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02, -2.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  5.040000e+04, -1.670000e+04,
         5.690000e+04, -4.030000e+04, -1.000000e+02,  1.011000e+05,
        -3.760000e+04, -5.930000e+04,  6.550000e+04, -2.810000e+04,
         3.923000e+05,  3.315000e+05, -3.970000e+04, -3.740000e+04,
         3.270000e+04, -2.000000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -4.030000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.429000e+05,  5.350000e+04,  5.990000e+04,  3.192000e+05,
         2.306000e+05,  5.957000e+05,  3.098000e+05,  1.411000e+05,
         5.350000e+04,  1.403000e+05,  5.350000e+04,  1.120000e+05,
         2.710000e+04, -1.359000e+05,  2.058000e+05,  1.102000e+05,
         6.000000e+03,  4.480000e+05,  1.907000e+05,  5.930000e+04,
         6.790000e+04,  4.763000e+05,  5.949000e+05,  2.940000e+05,
         3.014000e+05,  5.476000e+05,  2.121000e+05,  3.172500e+06,
        -6.090000e+04, -6.080000e+04, -6.120000e+04, -6.040000e+04,
        -1.322000e+05, -6.090000e+04, -5.247000e+05, -7.006000e+05,
        -6.885000e+05, -2.730000e+04, -7.120000e+04, -6.830000e+04,
         5.465000e+05,  7.534000e+05,  2.801000e+05,  2.801000e+05,
         3.377000e+05,  3.965000e+05,  3.401000e+05,  1.435000e+05,
         6.609000e+05,  6.170000e+05,  9.048000e+05,  1.926000e+05,
         4.403000e+05,  5.254000e+05,  7.601000e+05,  1.700000e+05,
         1.699000e+05,  8.250000e+04,  8.810000e+04,  3.583000e+05,
         1.900000e+05,  2.980000e+05,  5.890000e+04,  2.185000e+05,
         2.185000e+05,  2.185000e+05,  2.185000e+05,  1.285000e+05,
        -2.810000e+04,  3.377000e+05,  2.916000e+05, -1.690000e+04,
         4.070000e+04,  3.530000e+04,  6.810000e+04,  1.474000e+05,
         5.960000e+04,  5.960000e+04,  2.058000e+05,  2.057000e+05,
         2.058000e+05,  1.076900e+06,  8.509000e+05,  5.693000e+05,
         5.754000e+05,  3.683000e+05,  2.341000e+05,  3.504000e+05,
         8.389000e+05,  5.239000e+05,  8.389000e+05,  5.246000e+05,
         3.452000e+05, -2.635000e+05, -5.100000e+05, -4.424000e+05,
         4.800000e+04,  4.100000e+03,  7.096000e+05, -1.552000e+05,
         8.980000e+04,  4.570000e+04, -7.780000e+04,  7.700000e+03,
         8.600000e+04, -5.100000e+04, -3.680000e+04, -1.590000e+05,
         1.591000e+05,  2.573000e+05,  1.080000e+04,  5.038000e+05,
         3.790000e+04,  5.260000e+04,  2.100000e+04, -6.680000e+04,
         1.621000e+05,  4.020000e+05,  2.702000e+05,  1.571000e+05,
         1.636000e+05,  2.676000e+05,  3.787000e+05,  1.200000e+04,
         3.475000e+05,  4.050000e+05,  2.505000e+05,  2.505000e+05,
         1.176000e+05,  3.236000e+05,  5.430000e+05,  4.179900e+06,
         5.810000e+04,  5.820000e+04, -1.910000e+04, -1.910000e+04,
         1.437000e+05, -1.920000e+04, -5.230000e+04, -1.910000e+04,
         7.500000e+04,  7.500000e+04,  7.500000e+04,  7.490000e+04,
         7.590000e+04, -9.270000e+04, -9.260000e+04, -9.260000e+04,
        -5.561000e+05, -1.695000e+05, -9.430000e+04,  5.492000e+05,
         2.934000e+05,  2.932000e+05,  5.179000e+05,  5.178000e+05,
        -1.680000e+04,  1.146000e+05, -9.700000e+03,  2.320000e+04,
        -6.600000e+03, -5.800000e+03, -1.359000e+05,  1.120000e+05,
        -2.050000e+04, -3.370000e+04,  0.000000e+00, -2.000000e+02,
        -1.330000e+04,  1.690000e+04, -1.930000e+04, -1.770000e+04,
         0.000000e+00,  0.000000e+00, -1.043000e+05, -1.459000e+05,
        -3.080000e+04,  4.500000e+03, -1.870000e+04,  0.000000e+00,
         2.400000e+04, -6.870000e+04, -1.030000e+04,  1.182000e+05,
         1.183000e+05,  2.540000e+04, -1.160000e+04, -4.800000e+03,
         1.483000e+05,  1.073000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02, -1.200000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.320000e+04,  1.146000e+05,
        -1.780000e+04,  7.500000e+04, -1.000000e+02,  1.429000e+05,
         5.350000e+04,  2.057000e+05,  2.185000e+05,  3.377000e+05,
        -6.040000e+04,  1.437000e+05, -1.910000e+04,  5.820000e+04,
        -9.260000e+04, -9.430000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  7.500000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 6.800000e+03,  2.507000e+05,  5.840000e+04,  3.372000e+05,
         1.718000e+05, -4.400000e+03, -1.800000e+04,  8.600000e+03,
         2.507000e+05,  9.500000e+03,  2.505000e+05,  4.560000e+04,
         6.580000e+04, -1.466000e+05,  2.220000e+05,  4.760000e+04,
         1.540000e+04,  1.826000e+05, -1.200000e+03,  3.284000e+05,
         8.000000e+04,  5.130000e+05,  7.953000e+05,  1.875000e+05,
         2.847000e+05,  4.804000e+05,  5.236000e+05,  3.240900e+06,
        -5.510000e+04, -5.500000e+04, -5.490000e+04, -5.520000e+04,
        -1.376000e+05, -5.510000e+04, -8.052000e+05, -3.660000e+05,
        -6.969000e+05, -9.770000e+04,  1.130000e+04, -7.070000e+04,
         5.062000e+05,  7.917000e+05,  3.121000e+05,  3.120000e+05,
         4.529000e+05,  5.941000e+05,  3.687000e+05,  1.651000e+05,
         6.540000e+05,  7.634000e+05,  1.467900e+06,  1.974000e+05,
         3.974000e+05,  5.596000e+05,  7.979000e+05,  7.830000e+04,
         7.830000e+04,  3.035000e+05,  1.325000e+05, -8.170000e+04,
         1.956000e+05,  3.286000e+05,  7.030000e+04,  9.720000e+04,
         9.720000e+04,  9.710000e+04,  9.720000e+04,  3.424000e+05,
        -9.840000e+04,  2.916000e+05,  7.790000e+05, -1.690000e+04,
         1.240000e+05,  7.780000e+04,  7.320000e+04,  1.746000e+05,
         6.650000e+04,  6.650000e+04,  2.220000e+05,  2.219000e+05,
         2.220000e+05,  8.192000e+05,  2.162800e+06,  4.135000e+05,
         3.250000e+05,  2.027000e+05,  5.705000e+05,  8.213000e+05,
         4.309000e+05,  1.289300e+06,  4.309000e+05,  1.289800e+06,
         4.030000e+04, -5.750000e+05, -7.705000e+05, -9.320000e+04,
        -6.800000e+03,  1.026000e+05,  2.442200e+06, -1.240000e+05,
         7.130000e+04,  1.810000e+05, -7.230000e+04,  1.850000e+04,
        -1.031000e+05,  2.563000e+05, -2.180000e+04, -2.985000e+05,
        -5.110000e+04, -8.570000e+04, -2.815000e+05,  1.100000e+05,
         4.613000e+05,  4.970000e+04, -1.052000e+05,  1.137000e+05,
         2.171000e+05,  2.365000e+05,  5.636000e+05,  4.160000e+04,
         2.198000e+05,  6.050000e+05,  2.679000e+05,  3.380000e+04,
         3.849000e+05,  5.258000e+05,  5.170000e+04,  5.170000e+04,
         4.218000e+05,  8.628000e+05,  3.157000e+05,  1.065500e+06,
         7.430000e+04,  7.440000e+04,  2.290000e+04,  2.290000e+04,
         1.652000e+05,  2.280000e+04,  9.200000e+03,  2.290000e+04,
         9.160000e+04,  9.160000e+04,  9.160000e+04,  9.150000e+04,
         9.060000e+04, -1.063000e+05, -1.062000e+05, -1.062000e+05,
        -6.377000e+05, -1.587000e+05, -6.790000e+04,  6.155000e+05,
         3.482000e+05,  3.481000e+05,  6.227000e+05,  6.227000e+05,
        -1.720000e+04,  1.136000e+05, -2.040000e+04, -3.070000e+04,
         4.690000e+04, -4.600000e+03, -1.466000e+05,  4.560000e+04,
         1.361000e+05,  4.180000e+04,  0.000000e+00, -1.400000e+03,
        -3.040000e+04, -6.450000e+04,  4.530000e+04, -2.110000e+04,
         0.000000e+00,  0.000000e+00, -1.894000e+05, -7.980000e+04,
         2.052000e+05,  2.690000e+04,  4.380000e+04,  0.000000e+00,
        -3.160000e+04, -7.440000e+04,  6.790000e+04,  1.199000e+05,
         1.199000e+05, -4.490000e+04,  6.750000e+04, -6.500000e+03,
         8.010000e+04,  1.881000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02, -9.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.070000e+04,  1.136000e+05,
        -1.920000e+04,  9.160000e+04, -1.000000e+02,  6.800000e+03,
         2.507000e+05,  2.219000e+05,  9.720000e+04,  2.916000e+05,
        -5.520000e+04,  1.652000e+05,  2.290000e+04,  7.440000e+04,
        -1.062000e+05, -6.790000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  9.160000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-8.900000e+03, -7.900000e+03, -7.000000e+03, -6.900000e+03,
        -7.900000e+03, -3.550000e+04, -1.770000e+04, -8.900000e+03,
        -7.900000e+03, -8.900000e+03, -7.900000e+03, -9.400000e+03,
        -3.500000e+03,  9.800000e+03, -8.200000e+03, -9.500000e+03,
        -8.000000e+02, -3.750000e+04, -1.520000e+04, -1.750000e+04,
        -1.270000e+04, -1.770000e+04, -2.220000e+04, -2.460000e+04,
        -5.030000e+04, -6.850000e+04, -5.180000e+04, -1.039000e+05,
        -6.000000e+02, -8.000000e+02, -7.000000e+02, -3.000000e+02,
         7.200000e+03, -9.000000e+02,  1.690000e+04,  1.370000e+04,
         2.030000e+04,  3.000000e+02,  6.000000e+02,  1.200000e+03,
        -1.490000e+04, -1.260000e+04, -1.570000e+04, -1.570000e+04,
        -1.860000e+04, -2.080000e+04, -1.600000e+04, -1.080000e+04,
        -3.370000e+04, -3.380000e+04, -4.850000e+04,  2.200000e+03,
        -1.590000e+04, -1.510000e+04, -1.240000e+04, -2.840000e+04,
        -2.840000e+04, -2.990000e+04, -2.670000e+04, -1.740000e+04,
        -9.600000e+03, -1.760000e+04, -7.900000e+03, -1.680000e+04,
        -1.680000e+04, -1.680000e+04, -1.680000e+04, -1.830000e+04,
         1.500000e+03, -1.690000e+04, -1.690000e+04,  2.463500e+06,
         2.440200e+06,  2.458300e+06,  6.000000e+02, -1.740000e+04,
        -7.700000e+03, -7.700000e+03, -8.200000e+03, -8.200000e+03,
        -8.200000e+03, -6.870000e+04, -7.160000e+04, -3.270000e+04,
         2.317900e+06,  4.890000e+06,  4.842800e+06,  4.842700e+06,
        -6.860000e+04, -7.390000e+04, -6.860000e+04, -7.440000e+04,
        -3.210000e+04,  2.370000e+04,  4.190000e+04,  2.070000e+04,
        -9.100000e+03, -9.300000e+03, -1.028000e+05,  8.700000e+03,
        -9.100000e+03, -9.900000e+03,  2.444900e+06, -1.200000e+03,
         4.800000e+03,  2.700000e+03,  7.300000e+03,  2.260000e+04,
         2.428300e+06, -1.520000e+04,  3.600000e+03, -3.390000e+04,
        -1.600000e+04, -1.090000e+04, -7.900000e+03, -8.200000e+03,
        -3.140000e+04, -3.490000e+04, -3.400000e+04, -1.720000e+04,
        -3.190000e+04, -3.780000e+04, -4.030000e+04, -1.060000e+04,
        -1.960000e+04, -2.250000e+04, -1.760000e+04, -1.760000e+04,
        -1.710000e+04, -5.450000e+04, -5.370000e+04, -2.981000e+05,
         2.427000e+06,  2.429900e+06, -1.100000e+03, -1.100000e+03,
        -1.120000e+04, -1.100000e+03,  9.100000e+03, -1.100000e+03,
        -1.040000e+04, -1.040000e+04, -1.040000e+04, -1.040000e+04,
        -1.040000e+04,  2.347000e+06,  2.345300e+06,  2.345600e+06,
         1.407920e+07,  1.680000e+04,  7.900000e+03, -3.210000e+04,
        -3.190000e+04, -3.180000e+04, -6.300000e+04, -6.300000e+04,
         2.437400e+06,  1.500000e+03,  3.000000e+02,  3.000000e+02,
         7.000000e+02,  7.000000e+02,  9.800000e+03, -9.400000e+03,
         2.200000e+03,  5.000000e+02,  0.000000e+00,  0.000000e+00,
         2.600000e+03,  7.000000e+02,  1.600000e+03,  2.400000e+03,
         0.000000e+00,  0.000000e+00,  1.040000e+04,  1.110000e+04,
         3.600000e+03,  1.000000e+03,  1.600000e+03,  0.000000e+00,
         2.000000e+02,  5.000000e+03,  1.100000e+03,  1.400000e+03,
         1.400000e+03,  4.000000e+02,  1.200000e+03,  7.000000e+02,
         1.700000e+03,  2.600000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02,  3.000000e+02,  1.500000e+03,
         1.300000e+03, -1.040000e+04,  0.000000e+00, -8.900000e+03,
        -7.900000e+03, -8.200000e+03, -1.680000e+04, -1.690000e+04,
        -3.000000e+02, -1.120000e+04, -1.100000e+03,  2.429900e+06,
         2.345700e+06,  7.900000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.040000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.230000e+04,  1.798000e+05,  1.520000e+04,  2.240000e+04,
         1.730000e+04,  4.530000e+04,  2.070000e+04,  1.270000e+04,
         1.798000e+05,  1.280000e+04,  1.797000e+05,  1.720000e+04,
         3.980000e+04, -2.323000e+05,  2.320000e+04,  1.750000e+04,
         9.200000e+03,  6.900000e+04, -1.749000e+05,  4.180000e+04,
        -1.692000e+05, -1.737000e+05,  2.610000e+05,  6.330000e+04,
        -3.092000e+05, -5.860000e+04, -1.496000e+05, -9.312000e+05,
        -2.096000e+05, -2.096000e+05, -2.090000e+05, -2.093000e+05,
        -2.789000e+05, -2.096000e+05, -1.935600e+06, -1.645400e+06,
        -1.927900e+06, -2.142000e+05, -1.407000e+05, -2.123000e+05,
         3.990000e+04,  4.420000e+04, -2.986000e+05, -3.006000e+05,
        -4.770000e+04,  1.429000e+05, -1.722000e+05, -1.961000e+05,
        -4.778000e+05, -4.049000e+05,  8.596000e+05, -2.133000e+05,
         4.030000e+04,  4.570000e+04,  4.410000e+04, -3.571000e+05,
        -3.571000e+05, -2.085000e+05, -3.532000e+05,  1.270000e+04,
         5.400000e+03,  4.730000e+04,  1.740000e+04,  3.780000e+04,
         3.780000e+04,  3.780000e+04,  3.780000e+04,  2.027000e+05,
        -2.126000e+05,  4.070000e+04,  1.240000e+05,  2.440200e+06,
         5.209700e+06,  2.558500e+06, -2.128000e+05, -8.250000e+04,
         1.690000e+04,  1.690000e+04,  2.320000e+04,  2.320000e+04,
         2.320000e+04,  1.612000e+05,  5.749000e+05, -3.448000e+05,
         2.148100e+06,  4.961800e+06,  5.236300e+06,  1.072310e+07,
         1.555000e+05,  7.325000e+05,  1.555000e+05,  7.322000e+05,
        -3.440000e+05, -8.991000e+05, -1.149700e+06, -5.764000e+05,
        -1.906000e+05, -1.176000e+05,  1.777100e+06, -2.304000e+05,
         2.120000e+04,  9.350000e+04,  2.232600e+06, -4.286000e+05,
        -9.400000e+03,  2.334000e+05, -3.700000e+03, -2.610000e+05,
         2.457700e+06, -1.866000e+05, -4.366000e+05,  6.340000e+04,
         1.782000e+05, -1.770000e+05, -4.041000e+05, -2.582000e+05,
        -1.390000e+05,  8.010000e+04,  3.005000e+05, -1.715000e+05,
        -1.404000e+05,  3.269000e+05,  1.023000e+05, -1.837000e+05,
        -1.752000e+05,  7.770000e+04,  2.960000e+04,  2.960000e+04,
         2.811000e+05,  3.432000e+05, -2.150000e+04,  5.444000e+05,
         2.483800e+06,  2.477600e+06,  2.100000e+03,  2.100000e+03,
        -1.968000e+05,  2.100000e+03,  1.909000e+05,  2.100000e+03,
         2.290000e+04,  2.290000e+04,  2.290000e+04,  2.290000e+04,
         2.290000e+04,  2.283100e+06,  2.281500e+06,  2.281800e+06,
         1.369610e+07, -4.660000e+04, -2.230000e+04, -5.911000e+05,
        -1.509000e+05, -1.507000e+05, -8.210000e+04, -8.210000e+04,
         2.450900e+06, -8.000000e+02, -9.800000e+03, -3.700000e+03,
         4.600000e+04, -1.300000e+03, -2.323000e+05,  1.720000e+04,
         1.986000e+05,  6.600000e+03,  0.000000e+00,  2.000000e+03,
        -1.040000e+04, -1.480000e+04,  5.750000e+04, -5.200000e+03,
         0.000000e+00,  0.000000e+00, -2.367000e+05, -1.637000e+05,
         2.693000e+05,  5.990000e+04,  5.560000e+04,  0.000000e+00,
        -3.900000e+03, -1.154000e+05,  9.910000e+04, -8.000000e+02,
        -8.000000e+02, -5.000000e+03,  6.990000e+04, -1.400000e+03,
        -6.000000e+03,  6.910000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02, -3.700000e+03, -8.000000e+02,
        -3.050000e+04,  2.290000e+04,  0.000000e+00,  1.230000e+04,
         1.798000e+05,  2.320000e+04,  3.780000e+04,  4.070000e+04,
        -2.093000e+05, -1.968000e+05,  2.100000e+03,  2.477600e+06,
         2.281900e+06, -2.230000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.290000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-5.110000e+04,  3.510000e+04,  2.140000e+04,  3.580000e+04,
        -7.500000e+03, -2.390000e+05, -1.368000e+05, -4.880000e+04,
         3.510000e+04, -4.780000e+04,  3.510000e+04, -8.300000e+03,
         1.320000e+04, -2.467000e+05,  3.900000e+04, -6.200000e+03,
         3.300000e+03, -3.310000e+04, -2.587000e+05, -1.283000e+05,
        -1.489000e+05, -1.310000e+05,  1.111000e+05,  4.792500e+06,
        -2.680000e+05, -2.260000e+04, -1.839000e+05, -7.560000e+05,
        -2.047000e+05, -2.051000e+05, -2.054000e+05, -2.030000e+05,
        -2.868000e+05, -2.052000e+05, -2.090800e+06, -1.918000e+06,
        -1.944400e+06, -2.522000e+05, -2.072000e+05, -2.156000e+05,
         2.810000e+04,  6.890000e+04, -2.528000e+05, -2.528000e+05,
        -1.318000e+05, -1.040000e+04, -1.370000e+05, -1.674000e+05,
        -4.276000e+05, -3.833000e+05,  2.220000e+05, -2.106000e+05,
         3.170000e+04,  7.480000e+04,  6.960000e+04, -3.760000e+05,
        -3.760000e+05, -2.902000e+05, -3.028000e+05, -2.068000e+05,
         3.590000e+04,  8.110000e+04,  3.120000e+04, -6.500000e+03,
        -6.500000e+03, -6.500000e+03, -6.500000e+03,  7.690000e+04,
        -2.533000e+05,  3.530000e+04,  7.780000e+04,  2.458300e+06,
         2.558500e+06,  5.378400e+06, -2.081000e+05, -4.350000e+04,
         2.810000e+04,  2.810000e+04,  3.900000e+04,  3.900000e+04,
         3.900000e+04,  1.034000e+05,  3.128000e+05, -3.898000e+05,
         2.067900e+06,  4.947000e+06,  5.026000e+06,  5.276600e+06,
         1.950000e+04,  3.114000e+05,  1.950000e+04,  3.109000e+05,
        -4.708000e+05, -1.101000e+06, -1.347800e+06, -9.331000e+05,
        -2.084000e+05, -1.640000e+05,  4.456000e+05, -2.220000e+05,
         2.130000e+04,  6.450000e+04,  2.235000e+06, -4.142000e+05,
        -1.106000e+05,  1.500000e+04, -7.000000e+02, -3.538000e+05,
         2.332600e+06, -3.549000e+05, -6.017000e+05, -1.081000e+05,
        -1.333000e+05, -1.718000e+05, -4.586000e+05, -3.699000e+05,
        -7.840000e+04,  3.270000e+04,  1.676000e+05, -2.112000e+05,
        -8.010000e+04,  1.571000e+05,  3.390000e+04, -1.610000e+05,
        -1.285000e+05, -7.400000e+03, -5.740000e+04, -5.740000e+04,
         7.360000e+04,  8.460000e+04, -1.370000e+05, -7.859000e+05,
         2.473200e+06,  2.476200e+06,  2.450000e+04,  2.450000e+04,
        -1.677000e+05,  2.450000e+04,  2.124000e+05,  2.450000e+04,
         4.180000e+04,  4.180000e+04,  4.180000e+04,  4.180000e+04,
         4.060000e+04,  2.294100e+06,  2.292400e+06,  2.292800e+06,
         1.376190e+07, -6.220000e+04, -1.890000e+04, -5.057000e+05,
        -8.410000e+04, -8.400000e+04,  4.130000e+04,  4.130000e+04,
         2.431600e+06, -3.700000e+03, -1.600000e+03, -3.350000e+04,
        -1.600000e+03, -1.600000e+03, -2.467000e+05, -8.300000e+03,
        -5.900000e+03,  4.802200e+06,  0.000000e+00,  0.000000e+00,
        -8.600000e+03, -4.500000e+04, -3.700000e+03, -9.400000e+03,
         0.000000e+00,  0.000000e+00, -2.993000e+05, -2.491000e+05,
        -8.400000e+03, -1.660000e+04, -3.600000e+03,  4.754300e+06,
        -3.460000e+04, -1.228000e+05, -3.000000e+03, -2.600000e+03,
        -2.600000e+03, -4.310000e+04, -2.000000e+03, -3.000000e+03,
        -4.530000e+04, -4.500000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  3.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02, -3.350000e+04, -3.700000e+03,
        -3.240000e+04,  4.180000e+04,  0.000000e+00, -5.110000e+04,
         3.510000e+04,  3.900000e+04, -6.500000e+03,  3.530000e+04,
        -2.032000e+05, -1.677000e+05,  2.450000e+04,  2.476200e+06,
         2.292800e+06, -1.890000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.180000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-5.640000e+04, -4.520000e+04, -3.150000e+04,  2.707000e+05,
         1.069000e+05, -2.302000e+05, -1.174000e+05, -5.620000e+04,
        -4.520000e+04, -5.620000e+04, -4.520000e+04, -5.150000e+04,
        -1.820000e+04,  4.239000e+05,  1.170000e+05, -5.150000e+04,
        -4.200000e+03, -2.061000e+05,  2.716000e+05,  2.821000e+05,
         3.088000e+05,  8.081000e+05,  3.509000e+05, -1.454000e+05,
         5.138000e+05,  4.040000e+04,  5.227000e+05,  4.778800e+06,
         3.769000e+05,  3.770000e+05,  3.765000e+05,  3.775000e+05,
         5.066000e+05,  3.770000e+05,  3.447600e+06,  3.459900e+06,
         3.497100e+06,  3.721000e+05,  3.759000e+05,  3.845000e+05,
         3.783000e+05,  6.959000e+05,  8.483000e+05,  8.482000e+05,
         6.309000e+05,  4.061000e+05,  6.416000e+05,  5.069000e+05,
         1.477200e+06,  1.480900e+06,  3.944000e+05,  7.330000e+05,
         2.230000e+05,  3.880000e+05,  6.948000e+05,  6.042000e+05,
         6.041000e+05,  6.128000e+05,  6.290000e+05, -1.266000e+05,
         1.163000e+05,  8.030000e+04, -3.510000e+04, -1.009000e+05,
        -1.009000e+05, -1.009000e+05, -1.009000e+05, -9.190000e+04,
         3.724000e+05,  6.810000e+04,  7.320000e+04,  6.000000e+02,
        -2.128000e+05, -2.081000e+05,  5.635000e+05,  1.984000e+05,
        -3.460000e+04, -3.460000e+04,  1.170000e+05,  1.170000e+05,
         1.170000e+05, -6.070000e+04, -3.810000e+04,  8.944000e+05,
         5.526000e+05, -1.958000e+05, -1.824000e+05, -6.124000e+05,
        -3.991000e+05, -3.674000e+05, -3.991000e+05, -3.681000e+05,
         5.425000e+05,  1.579900e+06,  2.053100e+06,  1.597800e+06,
         3.267000e+05,  3.304000e+05, -5.531000e+05,  4.262000e+05,
        -4.800000e+04, -4.450000e+04,  3.780000e+05,  9.307000e+05,
        -1.010000e+04,  3.800000e+03,  2.710000e+04,  4.642000e+05,
        -6.350000e+04,  2.602000e+05,  7.342000e+05, -2.137000e+05,
         2.785000e+05,  3.222000e+05,  7.000000e+05,  7.073000e+05,
         2.340000e+05, -1.971000e+05, -1.858000e+05,  2.767000e+05,
         2.367000e+05, -1.844000e+05, -2.051000e+05,  3.253000e+05,
         6.345000e+05,  4.172000e+05, -1.058000e+05, -1.058000e+05,
        -9.120000e+04,  1.610000e+04, -2.200000e+03, -1.802800e+06,
        -4.550000e+04, -4.560000e+04,  2.200000e+03,  2.200000e+03,
         5.079000e+05,  2.200000e+03, -3.259000e+05,  2.200000e+03,
        -4.660000e+04, -4.660000e+04, -4.660000e+04, -4.660000e+04,
        -4.670000e+04,  4.410000e+04,  4.410000e+04,  4.410000e+04,
         2.645000e+05,  9.310000e+04,  4.760000e+04,  1.676900e+06,
         4.143000e+05,  4.139000e+05,  2.740000e+05,  2.739000e+05,
         1.000000e+03,  1.458000e+05, -7.100000e+03, -4.400000e+03,
         4.000000e+02,  3.800000e+03,  4.239000e+05, -5.150000e+04,
         0.000000e+00,  6.000000e+03,  0.000000e+00,  0.000000e+00,
         1.200000e+03, -1.410000e+04, -7.400000e+03,  1.050000e+04,
         0.000000e+00,  0.000000e+00,  4.174000e+05,  4.230000e+05,
        -2.000000e+02, -1.900000e+03, -7.200000e+03,  0.000000e+00,
        -4.600000e+03,  2.105000e+05,  0.000000e+00,  1.532000e+05,
         1.532000e+05, -8.600000e+03, -1.700000e+03,  2.300000e+03,
         1.451000e+05,  1.516000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.500000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -4.400000e+03,  1.458000e+05,
         5.560000e+04, -4.660000e+04,  0.000000e+00, -5.640000e+04,
        -4.520000e+04,  1.170000e+05, -1.009000e+05,  6.810000e+04,
         3.775000e+05,  5.079000e+05,  2.200000e+03, -4.560000e+04,
         4.410000e+04,  4.760000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -4.660000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-2.400000e+03,  5.230000e+04,  4.540000e+04,  1.373000e+05,
         6.740000e+04, -3.730000e+04, -3.250000e+04, -4.000000e+02,
         5.230000e+04,  5.000000e+02,  5.230000e+04,  3.290000e+04,
         2.330000e+04,  8.610000e+04,  1.063000e+05,  3.490000e+04,
         5.600000e+03,  1.315000e+05,  1.957000e+05,  2.786000e+05,
         2.695000e+05,  4.577000e+05,  2.971000e+05,  1.455000e+05,
         6.413000e+05,  5.888000e+05,  6.967000e+05,  2.640800e+06,
         1.615000e+05,  1.625000e+05,  1.620000e+05,  1.598000e+05,
         1.447000e+05,  1.624000e+05,  1.187700e+06,  1.304500e+06,
         1.286100e+06,  1.239000e+05,  1.498000e+05,  1.485000e+05,
         2.037000e+05,  3.066000e+05,  5.043000e+05,  5.046000e+05,
         4.215000e+05,  3.397000e+05,  3.949000e+05,  3.128000e+05,
         8.832000e+05,  9.099000e+05,  4.943000e+05,  2.314000e+05,
         1.751000e+05,  2.437000e+05,  3.091000e+05,  4.705000e+05,
         4.704000e+05,  5.260000e+05,  5.197000e+05, -8.830000e+04,
         1.414000e+05,  1.816000e+05,  5.640000e+04,  7.160000e+04,
         7.160000e+04,  7.160000e+04,  7.160000e+04,  1.270000e+05,
         1.248000e+05,  1.474000e+05,  1.746000e+05, -1.740000e+04,
        -8.250000e+04, -4.350000e+04,  1.984000e+05,  2.679600e+06,
         5.320000e+04,  5.320000e+04,  1.063000e+05,  1.062000e+05,
         1.063000e+05,  4.779000e+05,  6.142000e+05,  6.146000e+05,
         3.314000e+05,  1.466000e+05,  2.265000e+05,  1.004000e+05,
         3.247000e+05,  5.186000e+05,  3.247000e+05,  5.189000e+05,
         4.274000e+05,  3.515000e+05,  4.046000e+05,  4.623000e+05,
         1.980000e+05,  2.247000e+05,  7.007000e+05,  1.091000e+05,
         5.700000e+04,  8.470000e+04,  1.428000e+05,  4.023000e+05,
        -9.730000e+04, -1.190000e+04, -2.350000e+04, -4.500000e+04,
        -5.930000e+04,  1.194000e+05,  1.727000e+05,  6.610000e+04,
         2.528000e+05,  2.424000e+05,  3.215000e+05,  3.748000e+05,
         3.802000e+05,  1.815000e+05,  2.594000e+05,  2.338000e+05,
         3.859000e+05,  2.650000e+05,  1.880000e+05,  2.296000e+05,
         4.295000e+05,  3.464000e+05,  2.980000e+04,  2.980000e+04,
         1.156000e+05,  5.057000e+05,  3.722000e+05,  6.793000e+05,
         5.530000e+04,  5.540000e+04,  2.160000e+04,  2.160000e+04,
         3.277000e+05,  2.150000e+04, -1.940000e+05,  2.160000e+04,
         7.460000e+04,  7.460000e+04,  7.460000e+04,  7.460000e+04,
         7.420000e+04, -7.790000e+04, -7.780000e+04, -7.780000e+04,
        -4.671000e+05, -1.271000e+05, -5.280000e+04,  1.014600e+06,
         4.721000e+05,  4.666000e+05,  6.904000e+05,  6.903000e+05,
        -1.930000e+04,  2.970000e+04, -6.500000e+03, -2.660000e+04,
        -6.400000e+03, -3.800000e+03,  8.610000e+04,  3.290000e+04,
        -2.000000e+04,  3.820000e+04,  0.000000e+00, -1.000000e+02,
        -1.640000e+04, -4.280000e+04, -1.720000e+04, -1.700000e+04,
         0.000000e+00,  0.000000e+00,  5.230000e+04,  7.600000e+04,
        -3.110000e+04, -1.890000e+04, -1.660000e+04,  0.000000e+00,
        -2.760000e+04,  4.120000e+04, -1.000000e+04,  3.300000e+04,
         3.300000e+04, -3.640000e+04, -1.070000e+04, -5.200000e+03,
        -2.400000e+03,  2.240000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -2.660000e+04,  2.970000e+04,
         1.130000e+04,  7.460000e+04, -1.000000e+02, -2.400000e+03,
         5.230000e+04,  1.062000e+05,  7.160000e+04,  1.474000e+05,
         1.599000e+05,  3.277000e+05,  2.160000e+04,  5.540000e+04,
        -7.780000e+04, -5.280000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  7.460000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 2.290000e+04,  3.620000e+04,  4.623000e+05,  4.600000e+03,
         1.370000e+04,  7.710000e+04,  3.130000e+04,  2.240000e+04,
         3.620000e+04,  2.220000e+04,  3.620000e+04,  3.570000e+04,
         1.690000e+04, -5.970000e+04,  2.520000e+04,  3.530000e+04,
         3.800000e+03,  1.428000e+05,  4.360000e+04,  6.660000e+04,
         6.827000e+05,  1.550000e+04,  6.570000e+04,  1.149000e+05,
         1.921000e+05,  2.863000e+05,  2.068000e+05,  7.520000e+04,
        -1.260000e+04, -1.260000e+04, -1.260000e+04, -1.280000e+04,
        -5.120000e+04, -1.260000e+04, -2.348000e+05, -2.047000e+05,
         6.173000e+05, -2.490000e+04, -1.790000e+04,  1.881000e+05,
         1.820000e+04, -1.280000e+04,  7.600000e+03,  7.600000e+03,
         3.270000e+04,  5.780000e+04,  2.379000e+05,  1.240000e+04,
         3.260000e+04,  3.990000e+04,  1.655000e+05, -5.630000e+04,
         3.880000e+04,  2.970000e+04, -1.400000e+04,  9.070000e+04,
         9.070000e+04,  1.060000e+05,  5.167000e+05,  2.300000e+03,
         1.940000e+04,  7.090000e+04,  3.600000e+04,  6.890000e+04,
         6.890000e+04,  6.890000e+04,  6.890000e+04,  8.340000e+04,
        -2.530000e+04,  5.960000e+04,  6.650000e+04, -7.700000e+03,
         1.690000e+04,  2.810000e+04, -3.460000e+04,  5.320000e+04,
         4.659000e+05,  4.658000e+05,  2.520000e+04,  2.520000e+04,
         2.520000e+04,  2.692000e+05,  3.052000e+05,  8.050000e+04,
         3.150000e+04,  1.345000e+05,  1.556000e+05,  2.071000e+05,
         2.879000e+05,  3.386000e+05,  2.879000e+05,  3.391000e+05,
         9.940000e+04, -1.940000e+05, -2.881000e+05, -1.647000e+05,
         2.160000e+04,  2.890000e+04,  4.718000e+05, -5.290000e+04,
         4.120000e+04,  4.890000e+04, -2.080000e+04, -4.740000e+04,
        -3.110000e+04, -9.400000e+03,  6.079000e+05, -1.253000e+05,
         4.200000e+03,  1.980000e+04, -7.450000e+04,  1.141000e+05,
         5.620000e+04,  1.084900e+06, -3.900000e+03,  1.070000e+04,
         1.274000e+05,  1.499000e+05,  1.709000e+05,  5.590000e+04,
         1.289000e+05,  1.722000e+05,  1.506000e+05,  3.290000e+04,
         3.750000e+04,  6.260000e+04,  5.730000e+04,  5.730000e+04,
         7.780000e+04,  2.386000e+05,  2.022000e+05,  1.010200e+06,
         3.880000e+04,  3.890000e+04,  6.900000e+03,  6.900000e+03,
         1.240000e+04,  6.900000e+03, -2.070000e+04,  6.900000e+03,
         4.720000e+04,  4.720000e+04,  4.720000e+04,  4.710000e+04,
         4.730000e+04, -5.090000e+04, -5.090000e+04, -5.090000e+04,
        -3.056000e+05, -8.610000e+04, -3.960000e+04,  1.530000e+04,
         1.067000e+05,  1.066000e+05,  2.481000e+05,  2.480000e+05,
        -8.300000e+03, -1.920000e+04, -5.800000e+03, -1.490000e+04,
        -3.300000e+03,  9.540000e+04, -5.970000e+04,  3.570000e+04,
        -9.700000e+03,  1.150000e+04,  0.000000e+00,  0.000000e+00,
         1.577000e+05, -1.810000e+04, -1.090000e+04, -1.080000e+04,
         0.000000e+00,  0.000000e+00, -7.160000e+04, -6.480000e+04,
        -1.480000e+04, -6.900000e+03, -1.050000e+04,  0.000000e+00,
        -1.460000e+04, -3.050000e+04, -4.800000e+03, -2.190000e+04,
        -2.190000e+04, -1.360000e+04, -6.300000e+03,  8.240000e+04,
        -3.540000e+04, -2.820000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.300000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.490000e+04, -1.920000e+04,
        -7.800000e+03,  4.720000e+04,  0.000000e+00,  2.290000e+04,
         3.620000e+04,  2.520000e+04,  6.890000e+04,  5.960000e+04,
        -1.280000e+04,  1.240000e+04,  6.900000e+03,  3.890000e+04,
        -5.090000e+04, -3.960000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.720000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 2.290000e+04,  3.620000e+04,  4.623000e+05,  4.600000e+03,
         1.370000e+04,  7.710000e+04,  3.130000e+04,  2.240000e+04,
         3.620000e+04,  2.220000e+04,  3.620000e+04,  3.570000e+04,
         1.690000e+04, -5.970000e+04,  2.520000e+04,  3.530000e+04,
         3.800000e+03,  1.428000e+05,  4.360000e+04,  6.660000e+04,
         6.827000e+05,  1.550000e+04,  6.570000e+04,  1.149000e+05,
         1.921000e+05,  2.864000e+05,  2.068000e+05,  7.520000e+04,
        -1.260000e+04, -1.260000e+04, -1.260000e+04, -1.280000e+04,
        -5.120000e+04, -1.260000e+04, -2.348000e+05, -2.047000e+05,
         6.173000e+05, -2.490000e+04, -1.790000e+04,  1.881000e+05,
         1.820000e+04, -1.280000e+04,  7.600000e+03,  7.600000e+03,
         3.270000e+04,  5.780000e+04,  2.379000e+05,  1.240000e+04,
         3.260000e+04,  3.990000e+04,  1.655000e+05, -5.630000e+04,
         3.880000e+04,  2.970000e+04, -1.400000e+04,  9.070000e+04,
         9.070000e+04,  1.060000e+05,  5.168000e+05,  2.300000e+03,
         1.940000e+04,  7.090000e+04,  3.600000e+04,  6.890000e+04,
         6.890000e+04,  6.890000e+04,  6.890000e+04,  8.340000e+04,
        -2.530000e+04,  5.960000e+04,  6.650000e+04, -7.700000e+03,
         1.690000e+04,  2.810000e+04, -3.460000e+04,  5.320000e+04,
         4.658000e+05,  4.658000e+05,  2.520000e+04,  2.520000e+04,
         2.520000e+04,  2.692000e+05,  3.052000e+05,  8.050000e+04,
         3.160000e+04,  1.345000e+05,  1.556000e+05,  2.071000e+05,
         2.879000e+05,  3.386000e+05,  2.879000e+05,  3.391000e+05,
         9.940000e+04, -1.940000e+05, -2.881000e+05, -1.647000e+05,
         2.160000e+04,  2.890000e+04,  4.718000e+05, -5.290000e+04,
         4.120000e+04,  4.890000e+04, -2.080000e+04, -4.740000e+04,
        -3.110000e+04, -9.400000e+03,  6.080000e+05, -1.253000e+05,
         4.200000e+03,  1.980000e+04, -7.450000e+04,  1.141000e+05,
         5.620000e+04,  1.085000e+06, -3.900000e+03,  1.070000e+04,
         1.274000e+05,  1.499000e+05,  1.709000e+05,  5.590000e+04,
         1.289000e+05,  1.722000e+05,  1.506000e+05,  3.290000e+04,
         3.750000e+04,  6.260000e+04,  5.730000e+04,  5.730000e+04,
         7.790000e+04,  2.386000e+05,  2.022000e+05,  1.010200e+06,
         3.880000e+04,  3.890000e+04,  6.900000e+03,  6.900000e+03,
         1.240000e+04,  6.900000e+03, -2.070000e+04,  6.900000e+03,
         4.720000e+04,  4.720000e+04,  4.720000e+04,  4.710000e+04,
         4.730000e+04, -5.090000e+04, -5.090000e+04, -5.090000e+04,
        -3.056000e+05, -8.610000e+04, -3.960000e+04,  1.530000e+04,
         1.067000e+05,  1.066000e+05,  2.481000e+05,  2.480000e+05,
        -8.300000e+03, -1.920000e+04, -5.800000e+03, -1.490000e+04,
        -3.300000e+03,  9.540000e+04, -5.970000e+04,  3.570000e+04,
        -9.700000e+03,  1.150000e+04,  0.000000e+00,  0.000000e+00,
         1.577000e+05, -1.810000e+04, -1.090000e+04, -1.080000e+04,
         0.000000e+00,  0.000000e+00, -7.160000e+04, -6.480000e+04,
        -1.480000e+04, -6.900000e+03, -1.050000e+04,  0.000000e+00,
        -1.460000e+04, -3.050000e+04, -4.800000e+03, -2.190000e+04,
        -2.190000e+04, -1.360000e+04, -6.300000e+03,  8.240000e+04,
        -3.540000e+04, -2.820000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.300000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.490000e+04, -1.920000e+04,
        -7.800000e+03,  4.720000e+04,  0.000000e+00,  2.290000e+04,
         3.620000e+04,  2.520000e+04,  6.890000e+04,  5.960000e+04,
        -1.280000e+04,  1.240000e+04,  6.900000e+03,  3.890000e+04,
        -5.090000e+04, -3.960000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.720000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-9.200000e+03,  2.320000e+04,  2.190000e+04,  3.437000e+05,
         1.668000e+05, -5.280000e+04, -3.450000e+04, -8.100000e+03,
         2.320000e+04, -7.600000e+03,  2.320000e+04,  1.100000e+04,
         1.050000e+04, -7.250000e+04,  1.944000e+05,  1.210000e+04,
         2.500000e+03,  4.410000e+04, -3.330000e+04,  1.620000e+04,
         1.490000e+04,  4.964000e+05,  5.695000e+05,  6.120000e+04,
         6.760000e+04,  1.530000e+05,  9.980000e+04,  3.134100e+06,
        -3.760000e+04, -3.760000e+04, -3.750000e+04, -3.760000e+04,
        -7.310000e+04, -3.760000e+04, -4.782000e+05, -4.122000e+05,
        -4.140000e+05, -5.950000e+04, -4.310000e+04, -4.350000e+04,
         5.123000e+05,  8.382000e+05,  3.016000e+05,  3.016000e+05,
         3.352000e+05,  3.708000e+05,  3.359000e+05,  1.500000e+05,
         6.207000e+05,  6.371000e+05,  8.050000e+05,  2.689000e+05,
         3.590000e+05,  5.385000e+05,  8.360000e+05, -1.390000e+04,
        -1.390000e+04,  1.870000e+04,  1.820000e+04, -6.720000e+04,
         1.747000e+05,  2.395000e+05,  2.670000e+04,  2.600000e+04,
         2.600000e+04,  2.600000e+04,  2.600000e+04,  5.810000e+04,
        -5.930000e+04,  2.058000e+05,  2.220000e+05, -8.200000e+03,
         2.320000e+04,  3.900000e+04,  1.170000e+05,  1.063000e+05,
         2.520000e+04,  2.520000e+04,  1.944000e+05,  1.944000e+05,
         1.944000e+05,  4.852000e+05,  5.659000e+05,  3.109000e+05,
         2.835000e+05,  5.750000e+04,  1.055000e+05,  1.691000e+05,
         1.258000e+05,  2.380000e+05,  1.258000e+05,  2.381000e+05,
        -4.400000e+04, -3.071000e+05, -3.924000e+05, -2.428000e+05,
        -2.470000e+04, -8.200000e+03,  3.136000e+05, -6.070000e+04,
         2.490000e+04,  4.130000e+04, -4.580000e+04,  7.730000e+04,
        -5.310000e+04, -5.600000e+03, -5.000000e+03, -1.387000e+05,
        -3.980000e+04, -7.750000e+04, -1.627000e+05,  7.800000e+03,
         4.900000e+03,  2.800000e+03, -8.420000e+04, -5.130000e+04,
         6.640000e+04,  7.380000e+04,  1.232000e+05, -1.170000e+04,
         6.710000e+04,  1.220000e+05,  7.130000e+04, -3.400000e+03,
         3.401000e+05,  3.737000e+05,  2.100000e+03,  2.100000e+03,
         5.220000e+04,  1.502000e+05,  6.790000e+04,  1.304000e+05,
         2.660000e+04,  2.670000e+04,  1.180000e+04,  1.180000e+04,
         1.489000e+05,  1.180000e+04,  2.630000e+04,  1.180000e+04,
         3.490000e+04,  3.490000e+04,  3.490000e+04,  3.490000e+04,
         3.430000e+04, -4.280000e+04, -4.280000e+04, -4.280000e+04,
        -2.571000e+05, -5.820000e+04, -2.320000e+04,  5.950000e+05,
         2.190000e+05,  2.194000e+05,  3.241000e+05,  3.240000e+05,
        -8.200000e+03,  1.405000e+05, -9.400000e+03, -1.570000e+04,
        -3.300000e+03, -1.200000e+03, -7.250000e+04,  1.100000e+04,
        -1.170000e+04,  2.220000e+04,  0.000000e+00, -3.000000e+02,
        -1.230000e+04, -3.190000e+04, -1.470000e+04, -8.000000e+03,
         0.000000e+00,  0.000000e+00, -9.430000e+04, -7.780000e+04,
        -1.740000e+04, -1.080000e+04, -1.420000e+04,  0.000000e+00,
        -1.620000e+04, -3.650000e+04, -5.900000e+03,  1.483000e+05,
         1.483000e+05, -2.370000e+04, -6.800000e+03, -2.900000e+03,
         1.251000e+05,  1.416000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.300000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.570000e+04,  1.405000e+05,
        -9.500000e+03,  3.490000e+04,  0.000000e+00, -9.200000e+03,
         2.320000e+04,  1.944000e+05,  2.600000e+04,  2.058000e+05,
        -3.760000e+04,  1.489000e+05,  1.180000e+04,  2.670000e+04,
        -4.280000e+04, -2.320000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  3.490000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-9.200000e+03,  2.310000e+04,  2.190000e+04,  3.436000e+05,
         1.668000e+05, -5.280000e+04, -3.450000e+04, -8.100000e+03,
         2.310000e+04, -7.600000e+03,  2.310000e+04,  1.100000e+04,
         1.050000e+04, -7.250000e+04,  1.944000e+05,  1.210000e+04,
         2.500000e+03,  4.410000e+04, -3.330000e+04,  1.630000e+04,
         1.480000e+04,  4.963000e+05,  5.696000e+05,  6.120000e+04,
         6.760000e+04,  1.530000e+05,  9.980000e+04,  3.133300e+06,
        -3.760000e+04, -3.760000e+04, -3.750000e+04, -3.760000e+04,
        -7.310000e+04, -3.760000e+04, -4.781000e+05, -4.120000e+05,
        -4.139000e+05, -5.950000e+04, -4.300000e+04, -4.350000e+04,
         5.121000e+05,  8.380000e+05,  3.015000e+05,  3.015000e+05,
         3.351000e+05,  3.707000e+05,  3.358000e+05,  1.500000e+05,
         6.205000e+05,  6.370000e+05,  8.049000e+05,  2.688000e+05,
         3.590000e+05,  5.383000e+05,  8.357000e+05, -1.390000e+04,
        -1.390000e+04,  1.870000e+04,  1.820000e+04, -6.720000e+04,
         1.746000e+05,  2.395000e+05,  2.670000e+04,  2.600000e+04,
         2.600000e+04,  2.600000e+04,  2.600000e+04,  5.800000e+04,
        -5.930000e+04,  2.057000e+05,  2.219000e+05, -8.200000e+03,
         2.320000e+04,  3.900000e+04,  1.170000e+05,  1.062000e+05,
         2.520000e+04,  2.520000e+04,  1.944000e+05,  1.948000e+05,
         1.944000e+05,  4.851000e+05,  5.657000e+05,  3.108000e+05,
         2.834000e+05,  5.740000e+04,  1.055000e+05,  1.691000e+05,
         1.258000e+05,  2.379000e+05,  1.258000e+05,  2.380000e+05,
        -4.400000e+04, -3.070000e+05, -3.923000e+05, -2.427000e+05,
        -2.470000e+04, -8.200000e+03,  3.134000e+05, -6.070000e+04,
         2.490000e+04,  4.140000e+04, -4.580000e+04,  7.730000e+04,
        -5.310000e+04, -5.600000e+03, -5.000000e+03, -1.387000e+05,
        -3.980000e+04, -7.740000e+04, -1.627000e+05,  7.800000e+03,
         5.000000e+03,  2.800000e+03, -8.420000e+04, -5.120000e+04,
         6.640000e+04,  7.380000e+04,  1.232000e+05, -1.170000e+04,
         6.710000e+04,  1.219000e+05,  7.110000e+04, -3.400000e+03,
         3.400000e+05,  3.736000e+05,  2.100000e+03,  2.100000e+03,
         5.210000e+04,  1.502000e+05,  6.780000e+04,  1.304000e+05,
         2.660000e+04,  2.670000e+04,  1.180000e+04,  1.180000e+04,
         1.488000e+05,  1.180000e+04,  2.630000e+04,  1.180000e+04,
         3.490000e+04,  3.490000e+04,  3.490000e+04,  3.490000e+04,
         3.430000e+04, -4.280000e+04, -4.280000e+04, -4.280000e+04,
        -2.570000e+05, -5.820000e+04, -2.320000e+04,  5.949000e+05,
         2.190000e+05,  2.193000e+05,  3.240000e+05,  3.240000e+05,
        -8.200000e+03,  1.405000e+05, -9.400000e+03, -1.570000e+04,
        -3.300000e+03, -1.200000e+03, -7.250000e+04,  1.100000e+04,
        -1.180000e+04,  2.220000e+04,  0.000000e+00, -3.000000e+02,
        -1.230000e+04, -3.190000e+04, -1.460000e+04, -8.000000e+03,
         0.000000e+00,  0.000000e+00, -9.430000e+04, -7.780000e+04,
        -1.740000e+04, -1.080000e+04, -1.420000e+04,  0.000000e+00,
        -1.620000e+04, -3.650000e+04, -5.900000e+03,  1.483000e+05,
         1.483000e+05, -2.370000e+04, -6.800000e+03, -2.900000e+03,
         1.251000e+05,  1.416000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.300000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.570000e+04,  1.405000e+05,
        -9.500000e+03,  3.490000e+04,  0.000000e+00, -9.200000e+03,
         2.310000e+04,  1.948000e+05,  2.600000e+04,  2.057000e+05,
        -3.760000e+04,  1.488000e+05,  1.180000e+04,  2.670000e+04,
        -4.280000e+04, -2.320000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  3.490000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-9.200000e+03,  2.320000e+04,  2.190000e+04,  3.437000e+05,
         1.668000e+05, -5.280000e+04, -3.450000e+04, -8.100000e+03,
         2.320000e+04, -7.600000e+03,  2.320000e+04,  1.100000e+04,
         1.050000e+04, -7.250000e+04,  2.024000e+05,  1.210000e+04,
         2.500000e+03,  4.410000e+04, -3.330000e+04,  1.620000e+04,
         1.490000e+04,  4.964000e+05,  5.695000e+05,  6.120000e+04,
         6.760000e+04,  1.530000e+05,  9.980000e+04,  3.134100e+06,
        -3.760000e+04, -3.760000e+04, -3.750000e+04, -3.760000e+04,
        -7.310000e+04, -3.760000e+04, -4.782000e+05, -4.122000e+05,
        -4.140000e+05, -5.950000e+04, -4.310000e+04, -4.350000e+04,
         5.123000e+05,  8.382000e+05,  3.016000e+05,  3.016000e+05,
         3.352000e+05,  3.708000e+05,  3.359000e+05,  1.500000e+05,
         6.207000e+05,  6.371000e+05,  8.050000e+05,  2.689000e+05,
         3.590000e+05,  5.385000e+05,  8.360000e+05, -1.390000e+04,
        -1.390000e+04,  1.870000e+04,  1.820000e+04, -6.720000e+04,
         1.747000e+05,  2.635000e+05,  2.670000e+04,  2.600000e+04,
         2.600000e+04,  2.600000e+04,  2.600000e+04,  5.810000e+04,
        -5.930000e+04,  2.058000e+05,  2.220000e+05, -8.200000e+03,
         2.320000e+04,  3.900000e+04,  1.170000e+05,  1.063000e+05,
         2.520000e+04,  2.520000e+04,  1.944000e+05,  1.944000e+05,
         2.024000e+05,  4.852000e+05,  5.659000e+05,  3.109000e+05,
         2.835000e+05,  5.750000e+04,  1.055000e+05,  1.691000e+05,
         1.258000e+05,  2.380000e+05,  1.258000e+05,  2.381000e+05,
        -4.400000e+04, -3.071000e+05, -3.924000e+05, -2.428000e+05,
        -2.470000e+04, -8.200000e+03,  3.136000e+05, -6.070000e+04,
         2.490000e+04,  4.130000e+04, -4.580000e+04,  7.730000e+04,
        -5.310000e+04, -5.600000e+03, -5.000000e+03, -1.387000e+05,
        -3.980000e+04, -7.750000e+04, -1.627000e+05,  7.800000e+03,
         4.900000e+03,  2.800000e+03, -8.420000e+04, -5.130000e+04,
         6.640000e+04,  7.380000e+04,  1.232000e+05, -1.170000e+04,
         6.710000e+04,  1.220000e+05,  7.130000e+04, -3.400000e+03,
         3.401000e+05,  3.737000e+05,  2.100000e+03,  2.100000e+03,
         5.220000e+04,  1.502000e+05,  6.790000e+04,  1.304000e+05,
         2.660000e+04,  2.670000e+04,  1.180000e+04,  1.180000e+04,
         1.489000e+05,  1.180000e+04,  2.630000e+04,  1.180000e+04,
         3.490000e+04,  3.490000e+04,  3.490000e+04,  3.490000e+04,
         3.430000e+04, -4.280000e+04, -4.280000e+04, -4.280000e+04,
        -2.571000e+05, -5.820000e+04, -2.320000e+04,  5.950000e+05,
         2.190000e+05,  2.194000e+05,  3.241000e+05,  3.240000e+05,
        -8.200000e+03,  1.405000e+05, -9.400000e+03, -1.570000e+04,
        -3.300000e+03, -1.200000e+03, -7.250000e+04,  1.100000e+04,
        -1.170000e+04,  2.220000e+04,  0.000000e+00, -3.000000e+02,
        -1.230000e+04, -3.190000e+04, -1.470000e+04, -8.000000e+03,
         0.000000e+00,  0.000000e+00, -9.430000e+04, -7.780000e+04,
        -1.740000e+04, -1.080000e+04, -1.420000e+04,  0.000000e+00,
        -1.620000e+04, -3.650000e+04, -5.900000e+03,  1.483000e+05,
         1.483000e+05, -2.370000e+04, -6.800000e+03, -2.900000e+03,
         1.251000e+05,  1.416000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.300000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.570000e+04,  1.405000e+05,
        -9.500000e+03,  3.490000e+04,  0.000000e+00, -9.200000e+03,
         2.320000e+04,  1.944000e+05,  2.600000e+04,  2.058000e+05,
        -3.760000e+04,  1.489000e+05,  1.180000e+04,  2.670000e+04,
        -4.280000e+04, -2.320000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  3.490000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 7.539000e+05,  2.480000e+05,  2.731000e+05,  6.002000e+05,
         6.752000e+05,  3.167100e+06,  1.659400e+06,  7.441000e+05,
         2.480000e+05,  7.394000e+05,  2.480000e+05,  5.633000e+05,
         1.256000e+05, -5.437000e+05,  4.852000e+05,  5.532000e+05,
         2.770000e+04,  2.253300e+06,  1.106400e+06,  3.452000e+05,
         3.897000e+05,  9.056000e+05,  1.370200e+06,  1.451400e+06,
         1.575000e+06,  2.673900e+06,  1.060700e+06,  6.367200e+06,
        -2.073000e+05, -2.071000e+05, -2.083000e+05, -2.043000e+05,
        -5.103000e+05, -2.071000e+05, -1.516700e+06, -2.532500e+06,
        -2.472200e+06,  1.400000e+03, -2.494000e+05, -2.374000e+05,
         1.268100e+06,  1.318700e+06,  4.905000e+05,  4.905000e+05,
         7.200000e+05,  9.515000e+05,  7.336000e+05,  2.778000e+05,
         1.459700e+06,  1.207500e+06,  2.354800e+06,  7.690000e+04,
         1.168300e+06,  1.086100e+06,  1.333700e+06,  1.017200e+06,
         1.017100e+06,  5.112000e+05,  5.394000e+05,  1.965300e+06,
         4.540000e+05,  8.553000e+05,  2.622000e+05,  1.102600e+06,
         1.102600e+06,  1.102600e+06,  1.102600e+06,  5.845000e+05,
         2.400000e+03,  1.076900e+06,  8.192000e+05, -6.870000e+04,
         1.612000e+05,  1.034000e+05, -6.070000e+04,  4.779000e+05,
         2.692000e+05,  2.692000e+05,  4.852000e+05,  4.851000e+05,
         4.852000e+05,  4.166000e+06,  2.851600e+06,  1.940800e+06,
         1.926400e+06,  1.856000e+06,  1.075600e+06,  1.543900e+06,
         4.197900e+06,  2.384500e+06,  4.197900e+06,  2.382300e+06,
         1.986300e+06, -6.800000e+05, -1.780500e+06, -1.711000e+06,
         3.445000e+05,  9.250000e+04,  3.265800e+06, -6.614000e+05,
         4.332000e+05,  1.786000e+05, -2.760000e+05, -2.660000e+05,
         5.294000e+05, -2.485000e+05, -1.872000e+05, -5.655000e+05,
         8.755000e+05,  1.514700e+06,  4.171000e+05,  2.612300e+06,
         2.540000e+05,  3.203000e+05,  3.525000e+05, -1.517000e+05,
         7.933000e+05,  1.993500e+06,  1.240800e+06,  8.975000e+05,
         8.012000e+05,  1.213200e+06,  1.896000e+06,  1.197000e+05,
         7.603000e+05,  9.897000e+05,  1.297200e+06,  1.297200e+06,
         5.401000e+05,  1.509200e+06,  2.769800e+06,  2.155740e+07,
         2.673000e+05,  2.677000e+05, -1.174000e+05, -1.175000e+05,
         2.782000e+05, -1.175000e+05, -3.643000e+05, -1.175000e+05,
         3.365000e+05,  3.365000e+05,  3.365000e+05,  3.365000e+05,
         3.424000e+05, -4.058000e+05, -4.055000e+05, -4.056000e+05,
        -2.434500e+06, -8.039000e+05, -4.608000e+05,  9.601000e+05,
         9.510000e+05,  9.508000e+05,  1.960300e+06,  1.960200e+06,
        -6.880000e+04,  1.282000e+05, -2.060000e+04,  1.468000e+05,
        -2.770000e+04, -2.870000e+04, -5.437000e+05,  5.633000e+05,
        -8.190000e+04, -2.026000e+05,  0.000000e+00, -3.000000e+02,
        -3.640000e+04,  1.650000e+05, -5.980000e+04, -7.880000e+04,
         0.000000e+00,  0.000000e+00, -3.443000e+05, -5.843000e+05,
        -1.234000e+05,  4.180000e+04, -5.780000e+04,  0.000000e+00,
         1.515000e+05, -2.756000e+05, -4.090000e+04,  1.257000e+05,
         1.258000e+05,  1.839000e+05, -4.370000e+04, -1.950000e+04,
         3.161000e+05,  8.280000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02, -1.700000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.468000e+05,  1.282000e+05,
        -7.140000e+04,  3.365000e+05, -1.000000e+02,  7.539000e+05,
         2.480000e+05,  4.851000e+05,  1.102600e+06,  1.076900e+06,
        -2.045000e+05,  2.782000e+05, -1.175000e+05,  2.677000e+05,
        -4.056000e+05, -4.608000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  3.365000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 7.660000e+04,  1.236000e+06,  2.667000e+05,  6.892000e+05,
         3.828000e+05,  1.821000e+05,  2.870000e+04,  8.460000e+04,
         1.235900e+06,  8.850000e+04,  1.235300e+06,  2.333000e+05,
         3.192000e+05, -5.995000e+05,  5.659000e+05,  2.421000e+05,
         7.460000e+04,  9.331000e+05,  1.337000e+05,  1.692100e+06,
         4.349000e+05,  1.084800e+06,  2.371100e+06,  9.009000e+05,
         1.493700e+06,  2.338000e+06,  2.630300e+06,  6.686700e+06,
        -1.784000e+05, -1.781000e+05, -1.768000e+05, -1.802000e+05,
        -5.395000e+05, -1.780000e+05, -2.941300e+06, -8.654000e+05,
        -2.539700e+06, -3.512000e+05,  1.629000e+05, -2.508000e+05,
         1.066600e+06,  1.507300e+06,  6.464000e+05,  6.463000e+05,
         1.294300e+06,  1.939200e+06,  8.682000e+05,  3.846000e+05,
         1.417500e+06,  1.934000e+06,  5.173800e+06,  9.630000e+04,
         9.559000e+05,  1.255900e+06,  1.521100e+06,  5.537000e+05,
         5.538000e+05,  1.621100e+06,  7.545000e+05, -2.229000e+05,
         4.812000e+05,  1.008400e+06,  3.204000e+05,  4.888000e+05,
         4.888000e+05,  4.887000e+05,  4.888000e+05,  1.657700e+06,
        -3.541000e+05,  8.509000e+05,  2.162800e+06, -7.160000e+04,
         5.749000e+05,  3.128000e+05, -3.810000e+04,  6.142000e+05,
         3.052000e+05,  3.052000e+05,  5.659000e+05,  5.657000e+05,
         5.659000e+05,  2.851600e+06,  7.313200e+06,  1.135400e+06,
         6.909000e+05,  1.006700e+06,  2.757000e+06,  3.899500e+06,
         2.128500e+06,  6.219900e+06,  2.128500e+06,  6.223500e+06,
         4.432000e+05, -2.246600e+06, -3.089100e+06,  4.730000e+04,
         6.540000e+04,  5.816000e+05,  1.195030e+07, -5.048000e+05,
         3.392000e+05,  8.585000e+05, -2.526000e+05, -2.155000e+05,
        -4.289000e+05,  1.290400e+06, -1.277000e+05, -1.273300e+06,
        -1.570000e+05, -2.051000e+05, -1.049100e+06,  6.389000e+05,
         2.377300e+06,  2.969000e+05, -2.908000e+05,  7.422000e+05,
         1.074400e+06,  1.150200e+06,  2.692700e+06,  3.077000e+05,
         1.087900e+06,  2.908000e+06,  1.353000e+06,  2.303000e+05,
         9.455000e+05,  1.593400e+06,  3.054000e+05,  3.054000e+05,
         2.065000e+06,  4.215500e+06,  1.633100e+06,  5.974500e+06,
         3.457000e+05,  3.461000e+05,  9.510000e+04,  9.520000e+04,
         3.841000e+05,  9.530000e+04, -5.290000e+04,  9.520000e+04,
         4.216000e+05,  4.216000e+05,  4.216000e+05,  4.213000e+05,
         4.169000e+05, -4.678000e+05, -4.675000e+05, -4.675000e+05,
        -2.806300e+06, -7.368000e+05, -3.207000e+05,  1.286300e+06,
         1.227500e+06,  1.227800e+06,  2.492700e+06,  2.492700e+06,
        -7.520000e+04,  1.231000e+05, -7.410000e+04, -1.213000e+05,
         2.401000e+05, -2.270000e+04, -5.995000e+05,  2.333000e+05,
         7.016000e+05,  1.677000e+05,  0.000000e+00, -6.000000e+03,
        -1.267000e+05, -2.411000e+05,  2.627000e+05, -9.630000e+04,
         0.000000e+00,  0.000000e+00, -7.686000e+05, -2.569000e+05,
         1.056100e+06,  1.539000e+05,  2.538000e+05,  0.000000e+00,
        -1.245000e+05, -3.048000e+05,  3.502000e+05,  1.340000e+05,
         1.341000e+05, -1.672000e+05,  3.511000e+05, -2.820000e+04,
        -2.240000e+04,  4.870000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.000000e+02, -2.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.213000e+05,  1.231000e+05,
        -7.870000e+04,  4.216000e+05,  1.000000e+02,  7.660000e+04,
         1.236000e+06,  5.657000e+05,  4.888000e+05,  8.509000e+05,
        -1.800000e+05,  3.841000e+05,  9.520000e+04,  3.461000e+05,
        -4.676000e+05, -3.207000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.216000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 3.532000e+05,  5.030000e+04,  8.980000e+04,  4.994000e+05,
         4.251000e+05,  1.506600e+06,  8.004000e+05,  3.475000e+05,
         5.030000e+04,  3.445000e+05,  5.030000e+04,  2.352000e+05,
         3.480000e+04,  5.759000e+05,  3.109000e+05,  2.289000e+05,
         7.200000e+03,  9.410000e+05,  1.269600e+06,  7.920000e+05,
         8.754000e+05,  1.532500e+06,  8.892000e+05,  5.667000e+05,
         2.003600e+06,  1.654800e+06,  1.687800e+06,  9.443800e+06,
         6.690000e+05,  6.703000e+05,  6.695000e+05,  6.681000e+05,
         7.661000e+05,  6.704000e+05,  6.434300e+06,  5.803800e+06,
         5.908700e+06,  8.031000e+05,  6.459000e+05,  6.717000e+05,
         9.196000e+05,  1.189000e+06,  1.618900e+06,  1.618900e+06,
         1.295800e+06,  9.740000e+05,  1.313500e+06,  1.001300e+06,
         3.063700e+06,  2.905600e+06,  1.290000e+06,  1.105100e+06,
         7.415000e+05,  8.108000e+05,  1.198500e+06,  1.890400e+06,
         1.890500e+06,  1.575700e+06,  1.627600e+06,  9.901000e+05,
         3.048000e+05,  4.334000e+05,  7.500000e+04,  4.599000e+05,
         4.599000e+05,  4.599000e+05,  4.599000e+05,  1.435000e+05,
         8.112000e+05,  5.693000e+05,  4.135000e+05, -3.270000e+04,
        -3.448000e+05, -3.898000e+05,  8.944000e+05,  6.146000e+05,
         8.050000e+04,  8.050000e+04,  3.109000e+05,  3.108000e+05,
         3.109000e+05,  1.940800e+06,  1.135400e+06,  2.783700e+06,
         1.925800e+06,  7.231000e+05,  2.471000e+05, -3.818000e+05,
         1.707200e+06,  5.997000e+05,  1.707100e+06,  5.955000e+05,
         2.389100e+06,  3.042700e+06,  3.393100e+06,  2.410600e+06,
         9.017000e+05,  7.437000e+05,  7.384000e+05,  5.016000e+05,
         1.556000e+05, -3.800000e+03,  6.384000e+05,  1.578400e+06,
         3.363000e+05, -1.388000e+05, -5.790000e+04,  6.823000e+05,
         4.322000e+05,  1.525300e+06,  1.880300e+06,  1.170200e+06,
         7.348000e+05,  8.682000e+05,  1.710200e+06,  1.394000e+06,
         9.368000e+05,  7.884000e+05,  3.167000e+05,  1.133800e+06,
         9.491000e+05,  3.085000e+05,  7.144000e+05,  7.464000e+05,
         1.316500e+06,  9.934000e+05,  5.808000e+05,  5.808000e+05,
         1.222000e+05,  8.942000e+05,  1.684700e+06,  9.525500e+06,
         6.230000e+04,  6.250000e+04, -7.460000e+04, -7.460000e+04,
         1.006000e+06, -7.460000e+04, -9.128000e+05, -7.460000e+04,
         9.320000e+04,  9.320000e+04,  9.320000e+04,  9.320000e+04,
         9.760000e+04, -1.388000e+05, -1.387000e+05, -1.388000e+05,
        -8.329000e+05, -2.761000e+05, -1.755000e+05,  3.212500e+06,
         1.190900e+06,  1.189300e+06,  1.469000e+06,  1.469000e+06,
        -3.060000e+04,  1.913000e+05, -1.520000e+04,  9.130000e+04,
        -1.390000e+04, -9.600000e+03,  5.759000e+05,  2.352000e+05,
        -4.050000e+04, -1.232000e+05,  0.000000e+00, -3.000000e+02,
        -6.800000e+03,  9.810000e+04, -3.610000e+04, -2.260000e+04,
         0.000000e+00,  0.000000e+00,  7.140000e+05,  5.549000e+05,
        -6.210000e+04,  2.880000e+04, -3.490000e+04,  0.000000e+00,
         9.400000e+04,  2.831000e+05, -2.020000e+04,  1.951000e+05,
         1.951000e+05,  1.110000e+05, -2.430000e+04, -5.400000e+03,
         3.106000e+05,  1.713000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.000000e+02, -2.300000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  9.130000e+04,  1.913000e+05,
         7.560000e+04,  9.320000e+04,  1.000000e+02,  3.532000e+05,
         5.030000e+04,  3.108000e+05,  4.599000e+05,  5.693000e+05,
         6.681000e+05,  1.006000e+06, -7.460000e+04,  6.250000e+04,
        -1.388000e+05, -1.755000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  9.320000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 4.998000e+05, -4.000000e+02,  5.650000e+04,  5.214000e+05,
         5.090000e+05,  2.175700e+06,  1.176200e+06,  4.875000e+05,
        -4.000000e+02,  4.820000e+05, -4.000000e+02,  2.780000e+05,
         1.450000e+04,  2.593000e+05,  2.835000e+05,  2.665000e+05,
         1.900000e+03,  1.112000e+06,  1.019600e+06,  2.786000e+05,
         3.545000e+05,  1.139600e+06,  8.289000e+05,  5.163000e+05,
         9.764000e+05,  9.732000e+05,  4.850000e+05,  7.511200e+06,
         2.758000e+05,  2.760000e+05,  2.753000e+05,  2.746000e+05,
         3.319000e+05,  2.762000e+05,  3.408700e+06,  2.417800e+06,
         2.522000e+06,  5.161000e+05,  2.654000e+05,  2.944000e+05,
         1.025700e+06,  1.281600e+06,  1.017300e+06,  1.017400e+06,
         8.631000e+05,  7.083000e+05,  8.780000e+05,  5.828000e+05,
         2.124100e+06,  1.875000e+06,  1.103200e+06,  8.139000e+05,
         7.975000e+05,  8.055000e+05,  1.290000e+06,  1.071200e+06,
         1.071300e+06,  5.807000e+05,  6.279000e+05,  1.533200e+06,
         2.809000e+05,  3.291000e+05,  1.850000e+04,  5.081000e+05,
         5.081000e+05,  5.080000e+05,  5.081000e+05,  1.610000e+04,
         5.116000e+05,  5.754000e+05,  3.250000e+05,  2.317900e+06,
         2.148100e+06,  2.067900e+06,  5.526000e+05,  3.314000e+05,
         3.150000e+04,  3.160000e+04,  2.835000e+05,  2.834000e+05,
         2.835000e+05,  1.926400e+06,  6.909000e+05,  1.925800e+06,
         4.539700e+06,  5.408200e+06,  4.613700e+06,  4.332300e+06,
         1.792100e+06,  7.030000e+04,  1.792100e+06,  7.320000e+04,
         1.792000e+06,  2.022300e+06,  2.026500e+06,  1.039100e+06,
         5.295000e+05,  2.803000e+05,  3.870000e+04,  1.298000e+05,
         1.238000e+05, -1.233000e+05,  2.569700e+06,  8.430000e+05,
         5.847000e+05, -1.557000e+05, -8.030000e+04,  5.906000e+05,
         3.040500e+06,  1.507100e+06,  1.510000e+06,  1.504200e+06,
         2.619000e+05,  3.987000e+05,  1.042400e+06,  5.443000e+05,
         3.216000e+05,  7.753000e+05,  2.330000e+04,  7.819000e+05,
         3.251000e+05,  4.090000e+04,  7.240000e+05,  2.870000e+05,
         8.728000e+05,  7.184000e+05,  7.617000e+05,  7.616000e+05,
         7.900000e+03,  1.917000e+05,  1.437000e+06,  1.209410e+07,
         2.300400e+06,  2.303000e+06, -1.297000e+05, -1.297000e+05,
         5.893000e+05, -1.296000e+05, -5.521000e+05, -1.297000e+05,
         1.660000e+04,  1.660000e+04,  1.660000e+04,  1.650000e+04,
         2.290000e+04,  2.579700e+06,  2.577900e+06,  2.578200e+06,
         1.547550e+07, -1.535000e+05, -1.415000e+05,  2.010600e+06,
         6.205000e+05,  6.184000e+05,  6.683000e+05,  6.685000e+05,
         2.284100e+06,  2.402000e+05, -1.560000e+04,  1.703000e+05,
        -6.800000e+03, -7.400000e+03,  2.593000e+05,  2.780000e+05,
        -1.830000e+04, -2.458000e+05,  0.000000e+00, -4.000000e+02,
        -1.000000e+02,  2.010000e+05, -2.540000e+04, -5.600000e+03,
         0.000000e+00,  0.000000e+00,  5.001000e+05,  2.490000e+05,
        -2.840000e+04,  7.160000e+04, -2.450000e+04,  0.000000e+00,
         1.765000e+05,  1.280000e+05, -9.100000e+03,  2.435000e+05,
         2.435000e+05,  2.133000e+05, -1.440000e+04,  3.000000e+02,
         4.625000e+05,  2.297000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.000000e+02, -3.400000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02,  1.703000e+05,  2.402000e+05,
         3.400000e+04,  1.660000e+04,  1.000000e+02,  4.998000e+05,
        -4.000000e+02,  2.834000e+05,  5.081000e+05,  5.754000e+05,
         2.747000e+05,  5.893000e+05, -1.297000e+05,  2.303000e+06,
         2.578300e+06, -1.415000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.660000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 4.497000e+05,  1.249000e+05,  1.391000e+05, -5.190000e+04,
         1.981000e+05,  1.902400e+06,  1.003200e+06,  4.436000e+05,
         1.249000e+05,  4.405000e+05,  1.249000e+05,  3.202000e+05,
         6.420000e+04, -2.520000e+05,  5.750000e+04,  3.134000e+05,
         1.390000e+04,  1.280700e+06,  6.941000e+05,  1.915000e+05,
         2.288000e+05, -8.370000e+04,  1.364000e+05,  8.133000e+05,
         8.710000e+05,  1.439800e+06,  5.322000e+05, -1.914000e+05,
        -8.640000e+04, -8.690000e+04, -8.720000e+04, -8.400000e+04,
        -2.312000e+05, -8.680000e+04, -4.313000e+05, -1.101400e+06,
        -1.051700e+06,  5.660000e+04, -1.055000e+05, -9.850000e+04,
         1.452000e+05, -2.130000e+05, -1.031000e+05, -1.031000e+05,
         6.100000e+03,  1.164000e+05,  2.050000e+04, -3.170000e+04,
         6.730000e+04, -9.720000e+04,  4.487000e+05, -3.043000e+05,
         2.560000e+05,  5.500000e+03, -2.109000e+05,  6.202000e+05,
         6.203000e+05,  2.860000e+05,  3.100000e+05,  1.212400e+06,
         5.370000e+04,  2.243000e+05,  1.284000e+05,  6.315000e+05,
         6.315000e+05,  6.315000e+05,  6.315000e+05,  2.905000e+05,
         6.210000e+04,  3.683000e+05,  2.027000e+05,  4.890000e+06,
         4.961800e+06,  4.947000e+06, -1.958000e+05,  1.466000e+05,
         1.345000e+05,  1.345000e+05,  5.750000e+04,  5.740000e+04,
         5.750000e+04,  1.856000e+06,  1.006700e+06,  7.231000e+05,
         5.408200e+06,  1.113090e+07,  1.029820e+07,  1.053090e+07,
         2.384100e+06,  1.190500e+06,  2.384100e+06,  1.182200e+06,
         1.231900e+06, -1.033000e+05, -6.735000e+05, -7.824000e+05,
         2.314000e+05,  6.710000e+04,  1.638000e+06, -3.331000e+05,
         2.356000e+05,  6.750000e+04,  4.771500e+06, -2.843000e+05,
         3.661000e+05, -1.410000e+05, -9.920000e+04, -2.023000e+05,
         5.415900e+06,  9.697000e+05,  4.034000e+05,  1.535900e+06,
         1.472000e+05,  1.941000e+05,  2.972000e+05, -3.180000e+04,
         4.056000e+05,  1.122500e+06,  6.362000e+05,  5.511000e+05,
         4.095000e+05,  6.013000e+05,  1.056000e+06,  7.430000e+04,
         2.460000e+04,  1.338000e+05,  7.608000e+05,  7.608000e+05,
         2.703000e+05,  7.516000e+05,  1.574100e+06,  1.259640e+07,
         5.007800e+06,  5.014000e+06, -8.120000e+04, -8.120000e+04,
        -3.280000e+04, -8.120000e+04, -2.413000e+05, -8.120000e+04,
         1.655000e+05,  1.655000e+05,  1.655000e+05,  1.657000e+05,
         1.696000e+05,  4.470000e+06,  4.466700e+06,  4.467400e+06,
         2.681490e+07, -4.307000e+05, -2.562000e+05, -2.063000e+05,
         2.987000e+05,  2.992000e+05,  7.959000e+05,  7.960000e+05,
         4.842700e+06, -9.780000e+04, -6.000000e+02,  1.009000e+05,
        -1.310000e+04, -1.580000e+04, -2.520000e+05,  3.202000e+05,
        -3.630000e+04, -1.339000e+05,  0.000000e+00,  1.000000e+02,
        -4.400000e+03,  1.324000e+05, -1.780000e+04, -3.860000e+04,
         0.000000e+00,  0.000000e+00, -1.142000e+05, -2.699000e+05,
        -5.460000e+04,  3.480000e+04, -1.720000e+04,  0.000000e+00,
         1.038000e+05, -1.279000e+05, -1.810000e+04, -1.079000e+05,
        -1.079000e+05,  1.336000e+05, -1.800000e+04, -8.600000e+03,
         2.280000e+04, -1.264000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.000000e+02,  6.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.000000e+02,  1.009000e+05, -9.780000e+04,
        -3.310000e+04,  1.655000e+05,  1.000000e+02,  4.497000e+05,
         1.249000e+05,  5.740000e+04,  6.315000e+05,  3.683000e+05,
        -8.410000e+04, -3.280000e+04, -8.120000e+04,  5.014000e+06,
         4.467600e+06, -2.562000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.655000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 4.420000e+04,  7.173000e+05,  1.349000e+05,  1.200000e+03,
         2.290000e+04,  1.156000e+05,  2.720000e+04,  4.860000e+04,
         7.173000e+05,  5.070000e+04,  7.169000e+05,  1.223000e+05,
         1.802000e+05, -2.847000e+05,  1.055000e+05,  1.268000e+05,
         4.210000e+04,  4.892000e+05,  1.088000e+05,  9.991000e+05,
         2.524000e+05,  2.200000e+04,  7.360000e+05,  4.784000e+05,
         8.196000e+05,  1.233700e+06,  1.472200e+06, -5.400000e+03,
        -6.910000e+04, -6.830000e+04, -6.760000e+04, -6.980000e+04,
        -2.483000e+05, -6.820000e+04, -1.280900e+06, -9.150000e+04,
        -1.089400e+06, -1.533000e+05,  1.425000e+05, -1.054000e+05,
         2.380000e+04, -1.005000e+05, -1.160000e+04, -1.170000e+04,
         3.497000e+05,  7.078000e+05,  9.890000e+04,  3.140000e+04,
         3.850000e+04,  3.347000e+05,  2.141900e+06, -2.928000e+05,
         1.289000e+05,  1.067000e+05, -9.850000e+04,  3.404000e+05,
         3.406000e+05,  9.515000e+05,  4.362000e+05, -9.640000e+04,
         6.840000e+04,  3.154000e+05,  1.629000e+05,  2.613000e+05,
         2.613000e+05,  2.613000e+05,  2.613000e+05,  9.332000e+05,
        -1.516000e+05,  2.341000e+05,  5.705000e+05,  4.842800e+06,
         5.236300e+06,  5.026000e+06, -1.824000e+05,  2.265000e+05,
         1.556000e+05,  1.556000e+05,  1.055000e+05,  1.055000e+05,
         1.055000e+05,  1.075600e+06,  2.757000e+06,  2.471000e+05,
         4.613700e+06,  1.029820e+07,  2.351660e+07,  1.199430e+07,
         1.129700e+06,  3.481400e+06,  1.129700e+06,  3.482400e+06,
         3.004000e+05, -1.038500e+06, -1.451600e+06,  2.790000e+05,
         6.230000e+04,  3.585000e+05,  6.841800e+06, -2.384000e+05,
         1.768000e+05,  4.736000e+05,  4.818400e+06, -2.536000e+05,
        -2.089000e+05,  7.826000e+05, -6.530000e+04, -6.241000e+05,
         4.856900e+06, -6.190000e+04, -4.741000e+05,  3.502000e+05,
         1.419100e+06,  1.774000e+05, -9.130000e+04,  5.011000e+05,
         5.726000e+05,  6.071000e+05,  1.494500e+06,  1.925000e+05,
         5.804000e+05,  1.616000e+06,  7.298000e+05,  1.402000e+05,
         1.338000e+05,  4.953000e+05,  1.654000e+05,  1.654000e+05,
         1.184200e+06,  2.372600e+06,  8.916000e+05,  3.230900e+06,
         5.107400e+06,  5.116200e+06,  4.630000e+04,  4.640000e+04,
         2.950000e+04,  4.650000e+04, -5.480000e+04,  4.640000e+04,
         2.160000e+05,  2.160000e+05,  2.160000e+05,  2.159000e+05,
         2.139000e+05,  4.367700e+06,  4.364600e+06,  4.365200e+06,
         2.620140e+07, -3.867000e+05, -1.702000e+05, -1.400000e+04,
         4.622000e+05,  4.631000e+05,  1.111300e+06,  1.111500e+06,
         4.892200e+06, -1.005000e+05, -3.260000e+04, -5.930000e+04,
         1.476000e+05, -1.220000e+04, -2.847000e+05,  1.223000e+05,
         4.340000e+05,  8.650000e+04,  0.000000e+00, -3.300000e+03,
        -5.920000e+04, -1.107000e+05,  1.758000e+05, -4.900000e+04,
         0.000000e+00,  0.000000e+00, -3.664000e+05, -7.240000e+04,
         6.532000e+05,  1.023000e+05,  1.699000e+05,  0.000000e+00,
        -6.110000e+04, -1.450000e+05,  2.166000e+05, -1.025000e+05,
        -1.025000e+05, -7.660000e+04,  2.188000e+05, -1.380000e+04,
        -1.788000e+05,  1.165000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.000000e+02,  1.500000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.000000e+02, -5.930000e+04, -1.005000e+05,
        -3.740000e+04,  2.160000e+05,  2.000000e+02,  4.420000e+04,
         7.173000e+05,  1.055000e+05,  2.613000e+05,  2.341000e+05,
        -6.970000e+04,  2.950000e+04,  4.640000e+04,  5.116200e+06,
         4.365400e+06, -1.702000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.160000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 8.690000e+04,  1.028200e+06,  1.813000e+05,  5.920000e+04,
         7.320000e+04,  2.778000e+05,  1.039000e+05,  9.210000e+04,
         1.028200e+06,  9.460000e+04,  1.027600e+06,  1.768000e+05,
         2.546000e+05, -7.756000e+05,  1.691000e+05,  1.822000e+05,
         5.930000e+04,  7.071000e+05, -2.126000e+05,  1.275600e+06,
        -5.930000e+04, -2.866000e+05,  1.327000e+06,  6.582000e+05,
         3.107000e+05,  1.268700e+06,  1.264700e+06, -1.647600e+06,
        -4.908000e+05, -4.909000e+05, -4.872000e+05, -4.910000e+05,
        -8.271000e+05, -4.907000e+05, -5.235100e+06, -3.249100e+06,
        -5.030700e+06, -5.878000e+05, -9.230000e+04, -5.367000e+05,
         1.329000e+05,  1.060000e+04, -5.760000e+05, -5.798000e+05,
         2.747000e+05,  1.020000e+06, -2.108000e+05, -3.391000e+05,
        -8.458000e+05, -3.501000e+05,  3.922300e+06, -7.259000e+05,
         2.418000e+05,  2.284000e+05,  1.170000e+04, -3.141000e+05,
        -3.139000e+05,  6.667000e+05, -2.119000e+05, -3.750000e+04,
         9.590000e+04,  4.481000e+05,  2.157000e+05,  3.725000e+05,
         3.725000e+05,  3.725000e+05,  3.725000e+05,  1.314000e+06,
        -5.843000e+05,  3.504000e+05,  8.213000e+05,  4.842700e+06,
         1.072310e+07,  5.276600e+06, -6.124000e+05,  1.004000e+05,
         2.071000e+05,  2.071000e+05,  1.691000e+05,  1.691000e+05,
         1.691000e+05,  1.543900e+06,  3.899500e+06, -3.818000e+05,
         4.332300e+06,  1.053090e+07,  1.199430e+07,  2.488810e+07,
         1.588200e+06,  4.883300e+06,  1.588200e+06,  4.884900e+06,
        -3.125000e+05, -2.907500e+06, -3.864500e+06, -1.007600e+06,
        -3.046000e+05,  1.911000e+05,  1.037490e+07, -7.219000e+05,
         2.418000e+05,  7.385000e+05,  4.353900e+06, -1.115900e+06,
        -2.430000e+05,  1.178400e+06, -8.970000e+04, -1.206600e+06,
         4.856500e+06, -4.085000e+05, -1.366100e+06,  5.491000e+05,
         2.070200e+06, -1.530000e+05, -8.950000e+05,  9.650000e+04,
         3.635000e+05,  8.431000e+05,  2.329600e+06, -1.193000e+05,
         3.700000e+05,  2.256900e+06,  6.900000e+05, -2.064000e+05,
        -1.735000e+05,  6.810000e+05,  2.612000e+05,  2.613000e+05,
         1.685600e+06,  3.225300e+06,  7.465000e+05,  4.943300e+06,
         5.166800e+06,  5.154400e+06,  5.390000e+04,  5.390000e+04,
        -3.413000e+05,  5.410000e+04,  3.131000e+05,  5.390000e+04,
         2.857000e+05,  2.857000e+05,  2.857000e+05,  2.856000e+05,
         2.828000e+05,  4.308100e+06,  4.305000e+06,  4.305700e+06,
         2.584410e+07, -5.172000e+05, -2.317000e+05, -1.132000e+06,
         2.311000e+05,  2.321000e+05,  1.089700e+06,  1.089900e+06,
         4.861400e+06, -1.066000e+05, -5.980000e+04, -6.770000e+04,
         2.185000e+05, -1.630000e+04, -7.756000e+05,  1.768000e+05,
         7.682000e+05,  9.940000e+04,  0.000000e+00,  2.600000e+03,
        -9.220000e+04, -1.494000e+05,  3.313000e+05, -6.490000e+04,
         0.000000e+00,  0.000000e+00, -8.678000e+05, -3.768000e+05,
         1.212800e+06,  2.397000e+05,  3.201000e+05,  0.000000e+00,
        -6.990000e+04, -3.893000e+05,  3.834000e+05, -1.085000e+05,
        -1.084000e+05, -8.800000e+04,  4.343000e+05, -1.820000e+04,
        -1.961000e+05,  3.256000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.000000e+02,  1.600000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.000000e+02, -6.770000e+04, -1.066000e+05,
        -1.018000e+05,  2.857000e+05,  2.000000e+02,  8.690000e+04,
         1.028200e+06,  1.691000e+05,  3.725000e+05,  3.504000e+05,
        -4.909000e+05, -3.413000e+05,  5.390000e+04,  5.154400e+06,
         4.305800e+06, -2.317000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.857000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.070100e+06,  2.631000e+05,  3.036000e+05, -9.790000e+04,
         4.841000e+05,  4.544700e+06,  2.404600e+06,  1.054000e+06,
         2.631000e+05,  1.046000e+06,  2.631000e+05,  7.403000e+05,
         1.379000e+05, -5.265000e+05,  1.258000e+05,  7.233000e+05,
         2.970000e+04,  2.961300e+06,  1.633600e+06,  4.054000e+05,
         4.850000e+05, -1.449000e+05,  3.008000e+05,  1.815200e+06,
         1.925200e+06,  3.176600e+06,  1.099400e+06, -1.038000e+05,
        -1.778000e+05, -1.776000e+05, -1.789000e+05, -1.734000e+05,
        -4.821000e+05, -1.778000e+05, -6.414000e+05, -2.278600e+06,
        -2.172800e+06,  1.840000e+05, -2.185000e+05, -1.989000e+05,
         3.845000e+05, -4.193000e+05, -1.857000e+05, -1.856000e+05,
         3.820000e+04,  2.614000e+05,  6.500000e+04, -5.000000e+04,
         2.547000e+05, -1.509000e+05,  9.686000e+05, -6.206000e+05,
         6.102000e+05,  2.780000e+04, -4.158000e+05,  1.426100e+06,
         1.425900e+06,  6.107000e+05,  6.604000e+05,  2.937900e+06,
         1.245000e+05,  4.753000e+05,  2.716000e+05,  1.442700e+06,
         1.442700e+06,  1.442600e+06,  1.442700e+06,  6.120000e+05,
         1.896000e+05,  8.389000e+05,  4.309000e+05, -6.860000e+04,
         1.555000e+05,  1.950000e+04, -3.991000e+05,  3.247000e+05,
         2.879000e+05,  2.879000e+05,  1.258000e+05,  1.258000e+05,
         1.258000e+05,  4.197900e+06,  2.128500e+06,  1.707200e+06,
         1.792100e+06,  2.384100e+06,  1.129700e+06,  1.588200e+06,
         5.423600e+06,  2.516300e+06,  5.423400e+06,  2.490800e+06,
         2.876800e+06,  2.930000e+04, -1.224700e+06, -1.625400e+06,
         5.450000e+05,  1.398000e+05,  3.446200e+06, -7.280000e+05,
         5.194000e+05,  1.094000e+05, -2.464000e+05, -5.766000e+05,
         9.084000e+05, -3.286000e+05, -2.402000e+05, -3.388000e+05,
         1.326600e+06,  2.339100e+06,  1.091200e+06,  3.587100e+06,
         3.115000e+05,  4.249000e+05,  7.412000e+05, -6.990000e+04,
         8.590000e+05,  2.521300e+06,  1.313800e+06,  1.270500e+06,
         8.676000e+05,  1.266700e+06,  2.400600e+06,  1.604000e+05,
         7.700000e+04,  3.008000e+05,  1.783700e+06,  1.783700e+06,
         5.687000e+05,  1.567900e+06,  3.595600e+06,  2.936650e+07,
         2.800000e+05,  2.804000e+05, -2.014000e+05, -2.016000e+05,
        -4.960000e+04, -2.017000e+05, -5.745000e+05, -2.016000e+05,
         3.489000e+05,  3.489000e+05,  3.489000e+05,  3.490000e+05,
         3.590000e+05, -4.192000e+05, -4.189000e+05, -4.190000e+05,
        -2.514800e+06, -9.262000e+05, -5.641000e+05, -3.702000e+05,
         6.478000e+05,  6.474000e+05,  1.693700e+06,  1.693600e+06,
        -6.860000e+04, -1.990000e+05, -1.800000e+03,  2.568000e+05,
        -2.810000e+04, -3.500000e+04, -5.265000e+05,  7.403000e+05,
        -7.710000e+04, -3.488000e+05,  0.000000e+00,  3.000000e+02,
        -1.010000e+04,  3.359000e+05, -3.900000e+04, -8.170000e+04,
         0.000000e+00,  0.000000e+00, -1.762000e+05, -5.652000e+05,
        -1.165000e+05,  9.270000e+04, -3.770000e+04,  0.000000e+00,
         2.642000e+05, -2.674000e+05, -3.860000e+04, -2.214000e+05,
        -2.214000e+05,  3.386000e+05, -3.930000e+04, -1.770000e+04,
         1.111000e+05, -2.617000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -2.000000e+02,  1.000000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.568000e+05, -1.990000e+05,
        -6.910000e+04,  3.489000e+05, -2.000000e+02,  1.070100e+06,
         2.631000e+05,  1.258000e+05,  1.442700e+06,  8.389000e+05,
        -1.737000e+05, -4.960000e+04, -2.016000e+05,  2.804000e+05,
        -4.190000e+05, -5.641000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  3.489000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.227000e+05,  1.646800e+06,  2.950000e+05,  2.540000e+04,
         7.440000e+04,  3.691000e+05,  1.236000e+05,  1.310000e+05,
         1.646700e+06,  1.353000e+05,  1.645800e+06,  2.785000e+05,
         4.091000e+05, -6.050000e+05,  2.380000e+05,  2.879000e+05,
         9.540000e+04,  1.113900e+06,  2.648000e+05,  2.291300e+06,
         5.408000e+05,  1.073000e+05,  1.699700e+06,  1.035400e+06,
         1.809800e+06,  2.703500e+06,  3.302100e+06,  3.516000e+05,
        -1.373000e+05, -1.371000e+05, -1.349000e+05, -1.404000e+05,
        -5.236000e+05, -1.371000e+05, -2.645900e+06,  5.350000e+04,
        -2.277900e+06, -3.109000e+05,  3.586000e+05, -2.189000e+05,
         1.002000e+05, -1.586000e+05,  3.560000e+04,  3.550000e+04,
         8.440000e+05,  1.644500e+06,  2.518000e+05,  1.011000e+05,
         1.993000e+05,  8.714000e+05,  4.914200e+06, -5.934000e+05,
         3.123000e+05,  2.634000e+05, -1.560000e+05,  7.740000e+05,
         7.740000e+05,  2.165700e+06,  9.580000e+05, -1.226000e+05,
         1.643000e+05,  6.887000e+05,  3.534000e+05,  5.790000e+05,
         5.790000e+05,  5.790000e+05,  5.790000e+05,  2.118300e+06,
        -3.124000e+05,  5.239000e+05,  1.289300e+06, -7.390000e+04,
         7.325000e+05,  3.114000e+05, -3.674000e+05,  5.186000e+05,
         3.386000e+05,  3.386000e+05,  2.380000e+05,  2.379000e+05,
         2.380000e+05,  2.384500e+06,  6.219900e+06,  5.997000e+05,
         7.030000e+04,  1.190500e+06,  3.481400e+06,  4.883300e+06,
         2.516300e+06,  6.849440e+07,  2.516200e+06,  7.880100e+06,
         7.066000e+05, -2.169600e+06, -3.060600e+06,  8.450000e+05,
         1.535000e+05,  8.253000e+05,  1.562410e+07, -5.085000e+05,
         3.869000e+05,  1.062300e+06, -2.155000e+05, -5.047000e+05,
        -4.374000e+05,  1.826900e+06, -1.614000e+05, -1.332900e+06,
        -1.119000e+05, -7.190000e+04, -9.647000e+05,  8.209000e+05,
         3.288800e+06,  3.880000e+05, -1.615000e+05,  1.182800e+06,
         1.254000e+06,  1.338800e+06,  3.347300e+06,  4.432000e+05,
         1.270400e+06,  3.642400e+06,  1.644100e+06,  3.157000e+05,
         3.382000e+05,  1.146800e+06,  3.958000e+05,  3.959000e+05,
         2.707000e+06,  5.360800e+06,  2.000100e+06,  7.541800e+06,
         3.881000e+05,  3.885000e+05,  9.700000e+04,  9.700000e+04,
         1.008000e+05,  9.710000e+04, -1.371000e+05,  9.700000e+04,
         4.684000e+05,  4.684000e+05,  4.684000e+05,  4.682000e+05,
         4.635000e+05, -5.025000e+05, -5.021000e+05, -5.022000e+05,
        -3.014300e+06, -8.261000e+05, -3.644000e+05,  9.260000e+04,
         1.037800e+06,  1.037900e+06,  2.443300e+06,  2.443300e+06,
        -7.970000e+04, -2.063000e+05, -7.670000e+04, -1.183000e+05,
         3.469000e+05, -2.660000e+04, -6.050000e+05,  2.785000e+05,
         1.020000e+06,  1.668000e+05,  0.000000e+00, -7.700000e+03,
        -1.388000e+05, -2.325000e+05,  4.123000e+05, -1.063000e+05,
         0.000000e+00,  0.000000e+00, -7.705000e+05, -1.076000e+05,
         1.534800e+06,  2.496000e+05,  3.984000e+05,  0.000000e+00,
        -1.218000e+05, -3.086000e+05,  5.090000e+05, -2.098000e+05,
        -2.098000e+05, -1.528000e+05,  5.133000e+05, -2.990000e+04,
        -3.616000e+05,  3.042000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  3.100000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.183000e+05, -2.063000e+05,
        -7.940000e+04,  4.684000e+05,  0.000000e+00,  1.227000e+05,
         1.646800e+06,  2.379000e+05,  5.790000e+05,  5.239000e+05,
        -1.401000e+05,  1.008000e+05,  9.700000e+04,  3.885000e+05,
        -5.022000e+05, -3.644000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.684000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.070100e+06,  2.631000e+05,  3.036000e+05, -9.790000e+04,
         4.842000e+05,  4.544700e+06,  2.404700e+06,  1.054000e+06,
         2.631000e+05,  1.046000e+06,  2.631000e+05,  7.403000e+05,
         1.379000e+05, -5.265000e+05,  1.258000e+05,  7.233000e+05,
         2.970000e+04,  2.961300e+06,  1.633600e+06,  4.054000e+05,
         4.850000e+05, -1.449000e+05,  3.008000e+05,  1.815200e+06,
         1.925200e+06,  3.176600e+06,  1.099400e+06, -1.038000e+05,
        -1.778000e+05, -1.776000e+05, -1.789000e+05, -1.734000e+05,
        -4.821000e+05, -1.778000e+05, -6.414000e+05, -2.278600e+06,
        -2.172800e+06,  1.840000e+05, -2.185000e+05, -1.989000e+05,
         3.845000e+05, -4.193000e+05, -1.857000e+05, -1.857000e+05,
         3.820000e+04,  2.614000e+05,  6.500000e+04, -5.000000e+04,
         2.547000e+05, -1.509000e+05,  9.686000e+05, -6.206000e+05,
         6.102000e+05,  2.780000e+04, -4.158000e+05,  1.426100e+06,
         1.425900e+06,  6.107000e+05,  6.604000e+05,  2.937900e+06,
         1.245000e+05,  4.753000e+05,  2.716000e+05,  1.442700e+06,
         1.442700e+06,  1.442600e+06,  1.442700e+06,  6.120000e+05,
         1.896000e+05,  8.389000e+05,  4.309000e+05, -6.860000e+04,
         1.555000e+05,  1.950000e+04, -3.991000e+05,  3.247000e+05,
         2.879000e+05,  2.879000e+05,  1.258000e+05,  1.258000e+05,
         1.258000e+05,  4.197900e+06,  2.128500e+06,  1.707100e+06,
         1.792100e+06,  2.384100e+06,  1.129700e+06,  1.588200e+06,
         5.423400e+06,  2.516200e+06,  5.426000e+06,  2.490800e+06,
         2.876700e+06,  2.930000e+04, -1.224700e+06, -1.625400e+06,
         5.450000e+05,  1.398000e+05,  3.446200e+06, -7.280000e+05,
         5.194000e+05,  1.094000e+05, -2.464000e+05, -5.766000e+05,
         9.084000e+05, -3.286000e+05, -2.402000e+05, -3.388000e+05,
         1.326600e+06,  2.339100e+06,  1.091200e+06,  3.587100e+06,
         3.115000e+05,  4.249000e+05,  7.412000e+05, -6.990000e+04,
         8.590000e+05,  2.521200e+06,  1.313700e+06,  1.270500e+06,
         8.676000e+05,  1.266700e+06,  2.400600e+06,  1.604000e+05,
         7.700000e+04,  3.008000e+05,  1.783700e+06,  1.783700e+06,
         5.688000e+05,  1.568000e+06,  3.595600e+06,  2.936650e+07,
         2.800000e+05,  2.804000e+05, -2.014000e+05, -2.016000e+05,
        -4.960000e+04, -2.017000e+05, -5.745000e+05, -2.016000e+05,
         3.489000e+05,  3.489000e+05,  3.489000e+05,  3.490000e+05,
         3.590000e+05, -4.192000e+05, -4.189000e+05, -4.190000e+05,
        -2.514800e+06, -9.262000e+05, -5.641000e+05, -3.702000e+05,
         6.478000e+05,  6.474000e+05,  1.693800e+06,  1.693600e+06,
        -6.860000e+04, -1.990000e+05, -1.800000e+03,  2.568000e+05,
        -2.810000e+04, -3.500000e+04, -5.265000e+05,  7.403000e+05,
        -7.710000e+04, -3.488000e+05,  0.000000e+00,  3.000000e+02,
        -1.010000e+04,  3.359000e+05, -3.900000e+04, -8.170000e+04,
         0.000000e+00,  0.000000e+00, -1.762000e+05, -5.652000e+05,
        -1.165000e+05,  9.270000e+04, -3.770000e+04,  0.000000e+00,
         2.642000e+05, -2.674000e+05, -3.860000e+04, -2.214000e+05,
        -2.214000e+05,  3.386000e+05, -3.930000e+04, -1.770000e+04,
         1.111000e+05, -2.617000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -2.000000e+02,  1.000000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.568000e+05, -1.990000e+05,
        -6.910000e+04,  3.489000e+05, -2.000000e+02,  1.070100e+06,
         2.631000e+05,  1.258000e+05,  1.442700e+06,  8.389000e+05,
        -1.737000e+05, -4.960000e+04, -2.016000e+05,  2.804000e+05,
        -4.190000e+05, -5.641000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  3.489000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.240000e+05,  1.647400e+06,  2.954000e+05,  2.540000e+04,
         7.510000e+04,  3.749000e+05,  1.267000e+05,  1.322000e+05,
         1.647400e+06,  1.365000e+05,  1.646500e+06,  2.793000e+05,
         4.093000e+05, -6.058000e+05,  2.381000e+05,  2.888000e+05,
         9.540000e+04,  1.117100e+06,  2.640000e+05,  2.291800e+06,
         5.387000e+05,  1.065000e+05,  1.699900e+06,  1.034100e+06,
         1.811600e+06,  2.706100e+06,  3.304700e+06,  3.466000e+05,
        -1.374000e+05, -1.372000e+05, -1.349000e+05, -1.408000e+05,
        -5.244000e+05, -1.372000e+05, -2.650500e+06,  5.070000e+04,
        -2.284100e+06, -3.103000e+05,  3.584000e+05, -2.187000e+05,
         1.009000e+05, -1.585000e+05,  3.480000e+04,  3.470000e+04,
         8.438000e+05,  1.644700e+06,  2.506000e+05,  1.009000e+05,
         1.982000e+05,  8.701000e+05,  4.915300e+06, -5.946000e+05,
         3.130000e+05,  2.636000e+05, -1.560000e+05,  7.737000e+05,
         7.738000e+05,  2.167100e+06,  9.569000e+05, -1.184000e+05,
         1.644000e+05,  6.889000e+05,  3.539000e+05,  5.791000e+05,
         5.791000e+05,  5.790000e+05,  5.791000e+05,  2.118900e+06,
        -3.132000e+05,  5.246000e+05,  1.289800e+06, -7.440000e+04,
         7.322000e+05,  3.109000e+05, -3.681000e+05,  5.189000e+05,
         3.391000e+05,  3.391000e+05,  2.381000e+05,  2.380000e+05,
         2.381000e+05,  2.382300e+06,  6.223500e+06,  5.955000e+05,
         7.320000e+04,  1.182200e+06,  3.482400e+06,  4.884900e+06,
         2.490800e+06,  7.880100e+06,  2.490800e+06,  8.007600e+06,
         7.041000e+05, -2.171900e+06, -3.063600e+06,  8.444000e+05,
         1.510000e+05,  8.226000e+05,  1.562800e+07, -5.090000e+05,
         3.865000e+05,  1.062900e+06, -2.164000e+05, -5.057000e+05,
        -4.390000e+05,  1.827200e+06, -1.643000e+05, -1.334700e+06,
        -1.082000e+05, -7.190000e+04, -9.655000e+05,  8.218000e+05,
         3.287700e+06,  3.860000e+05, -1.670000e+05,  1.176800e+06,
         1.255800e+06,  1.331600e+06,  3.337800e+06,  4.378000e+05,
         1.272200e+06,  3.661100e+06,  1.664300e+06,  3.162000e+05,
         3.380000e+05,  1.147000e+06,  3.965000e+05,  3.965000e+05,
         2.745700e+06,  5.386000e+06,  2.026400e+06,  7.546000e+06,
         3.879000e+05,  3.883000e+05,  9.730000e+04,  9.740000e+04,
         1.005000e+05,  9.740000e+04, -1.368000e+05,  9.740000e+04,
         4.691000e+05,  4.691000e+05,  4.691000e+05,  4.688000e+05,
         4.641000e+05, -5.018000e+05, -5.014000e+05, -5.015000e+05,
        -3.010200e+06, -8.248000e+05, -3.635000e+05,  9.170000e+04,
         1.038900e+06,  1.039000e+06,  2.446300e+06,  2.446300e+06,
        -8.050000e+04, -2.065000e+05, -7.660000e+04, -1.179000e+05,
         3.469000e+05, -2.670000e+04, -6.058000e+05,  2.793000e+05,
         1.020000e+06,  1.655000e+05,  0.000000e+00, -7.700000e+03,
        -1.396000e+05, -2.321000e+05,  4.121000e+05, -1.064000e+05,
         0.000000e+00,  0.000000e+00, -7.706000e+05, -1.085000e+05,
         1.534600e+06,  2.496000e+05,  3.982000e+05,  0.000000e+00,
        -1.213000e+05, -3.089000e+05,  5.090000e+05, -2.099000e+05,
        -2.099000e+05, -1.524000e+05,  5.132000e+05, -2.990000e+04,
        -3.612000e+05,  3.040000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  3.100000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.179000e+05, -2.065000e+05,
        -7.950000e+04,  4.691000e+05,  0.000000e+00,  1.240000e+05,
         1.647400e+06,  2.380000e+05,  5.791000e+05,  5.246000e+05,
        -1.405000e+05,  1.005000e+05,  9.740000e+04,  3.883000e+05,
        -5.015000e+05, -3.635000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.691000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 6.678000e+05,  6.440000e+04,  1.198000e+05, -1.947000e+05,
         2.353000e+05,  2.878700e+06,  1.543300e+06,  6.556000e+05,
         6.440000e+04,  6.495000e+05,  6.440000e+04,  4.105000e+05,
         4.660000e+04,  5.903000e+05, -4.400000e+04,  3.973000e+05,
         9.100000e+03,  1.641800e+06,  1.788800e+06,  8.622000e+05,
         9.648000e+05,  4.478000e+05, -1.667000e+05,  9.138000e+05,
         2.452600e+06,  2.232300e+06,  1.779900e+06,  2.812000e+06,
         6.972000e+05,  6.939000e+05,  7.060000e+05,  7.309000e+05,
         8.068000e+05,  6.939000e+05,  7.267900e+06,  6.038900e+06,
         6.169200e+06,  9.892000e+05,  6.794000e+05,  7.145000e+05,
         3.940000e+04, -5.413000e+05,  8.940000e+05,  8.940000e+05,
         5.830000e+05,  2.745000e+05,  6.201000e+05,  6.472000e+05,
         1.788200e+06,  1.478800e+06, -7.630000e+04,  3.890000e+05,
         1.915000e+05, -2.389000e+05, -5.401000e+05,  2.488100e+06,
         2.488000e+06,  1.702800e+06,  1.938700e+06,  1.962100e+06,
        -4.130000e+04,  6.260000e+04,  8.530000e+04,  7.908000e+05,
         7.908000e+05,  7.908000e+05,  7.908000e+05,  1.708000e+05,
         1.003300e+06,  3.452000e+05,  4.030000e+04, -3.210000e+04,
        -3.440000e+05, -4.708000e+05,  5.425000e+05,  4.274000e+05,
         9.940000e+04,  9.940000e+04, -4.400000e+04, -4.400000e+04,
        -4.400000e+04,  1.986300e+06,  4.432000e+05,  2.389100e+06,
         1.792000e+06,  1.231900e+06,  3.004000e+05, -3.125000e+05,
         2.876800e+06,  7.066000e+05,  2.876700e+06,  7.041000e+05,
         3.319040e+07,  3.809000e+06,  4.022600e+06,  2.497400e+06,
         1.090700e+06,  7.813000e+05,  9.227000e+05,  4.372000e+05,
         2.476000e+05, -5.920000e+04,  6.645000e+05,  1.235300e+06,
         7.233000e+05, -2.200000e+05, -1.007000e+05,  9.138000e+05,
         8.924000e+05,  2.374800e+06,  2.566500e+06,  2.183100e+06,
         8.279000e+05,  1.001400e+06,  2.075000e+06,  1.456300e+06,
         1.003500e+06,  1.296100e+06,  3.667000e+05,  1.487000e+06,
         1.024500e+06,  3.626000e+05,  1.204600e+06,  7.863000e+05,
         6.005000e+05,  2.895000e+05,  1.062000e+06,  1.062000e+06,
         1.497000e+05,  9.623000e+05,  2.509200e+06,  1.722400e+07,
         7.520000e+04,  7.530000e+04, -1.604000e+05, -1.605000e+05,
         6.466000e+05, -1.605000e+05, -1.121300e+06, -1.605000e+05,
         1.064000e+05,  1.064000e+05,  1.064000e+05,  1.064000e+05,
         1.130000e+05, -1.526000e+05, -1.525000e+05, -1.525000e+05,
        -9.152000e+05, -3.906000e+05, -2.757000e+05,  1.789600e+06,
         8.596000e+05,  8.597000e+05,  1.178800e+06,  1.178800e+06,
        -3.110000e+04, -1.340000e+05,  4.700000e+03,  2.019000e+05,
        -1.420000e+04, -1.570000e+04,  5.903000e+05,  4.105000e+05,
        -3.720000e+04, -2.724000e+05,  0.000000e+00,  3.000000e+02,
         1.640000e+04,  2.676000e+05, -1.390000e+04, -2.570000e+04,
         0.000000e+00,  0.000000e+00,  8.774000e+05,  5.773000e+05,
        -5.390000e+04,  8.000000e+04, -1.340000e+04,  0.000000e+00,
         2.076000e+05,  2.900000e+05, -1.860000e+04, -1.503000e+05,
        -1.503000e+05,  2.633000e+05, -1.740000e+04, -3.600000e+03,
         1.084000e+05, -1.684000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02,  3.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.019000e+05, -1.340000e+05,
         7.750000e+04,  1.064000e+05, -1.000000e+02,  6.678000e+05,
         6.440000e+04, -4.400000e+04,  7.908000e+05,  3.452000e+05,
         7.286000e+05,  6.466000e+05, -1.605000e+05,  7.530000e+04,
        -1.525000e+05, -2.757000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.064000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 3.717000e+05, -2.478000e+05, -1.463000e+05, -3.288000e+05,
         2.060000e+04,  1.729400e+06,  9.862000e+05,  3.565000e+05,
        -2.478000e+05,  3.493000e+05, -2.478000e+05,  6.920000e+04,
        -9.090000e+04,  1.894800e+06, -3.071000e+05,  5.340000e+04,
        -2.290000e+04,  2.766000e+05,  2.045100e+06,  1.071700e+06,
         1.258800e+06,  9.525000e+05, -8.839000e+05, -1.905000e+05,
         2.270100e+06,  4.066000e+05,  1.630400e+06,  5.426600e+06,
         1.603900e+06,  1.604700e+06,  1.608000e+06,  1.596400e+06,
         2.220300e+06,  1.604400e+06,  1.623070e+07,  1.494100e+07,
         1.518240e+07,  1.943600e+06,  1.618500e+06,  1.681500e+06,
        -3.090000e+05, -6.835000e+05,  1.920400e+06,  1.920400e+06,
         9.960000e+05,  7.570000e+04,  1.054500e+06,  1.288700e+06,
         3.233800e+06,  2.909000e+06, -1.713300e+06,  1.553500e+06,
        -2.866000e+05, -6.362000e+05, -6.856000e+05,  3.043500e+06,
         3.043300e+06,  2.379400e+06,  2.519400e+06,  1.476100e+06,
        -2.992000e+05, -5.926000e+05, -2.157000e+05,  9.060000e+04,
         9.060000e+04,  9.060000e+04,  9.060000e+04, -5.376000e+05,
         1.961000e+06, -2.635000e+05, -5.750000e+05,  2.370000e+04,
        -8.991000e+05, -1.101000e+06,  1.579900e+06,  3.515000e+05,
        -1.940000e+05, -1.940000e+05, -3.071000e+05, -3.070000e+05,
        -3.071000e+05, -6.800000e+05, -2.246600e+06,  3.042700e+06,
         2.022300e+06, -1.033000e+05, -1.038500e+06, -2.907500e+06,
         2.930000e+04, -2.169600e+06,  2.930000e+04, -2.171900e+06,
         3.809000e+06,  8.468100e+06,  1.032870e+07,  7.196000e+06,
         1.650600e+06,  1.325800e+06, -3.123300e+06,  1.710900e+06,
        -1.349000e+05, -4.581000e+05,  1.632100e+06,  3.183000e+06,
         8.232000e+05, -1.223000e+05,  3.700000e+04,  2.669300e+06,
         7.182000e+05,  2.714100e+06,  4.578600e+06,  8.496000e+05,
         1.090100e+06,  1.403700e+06,  3.591100e+06,  2.941500e+06,
         7.242000e+05, -1.513000e+05, -1.126500e+06,  1.696900e+06,
         7.380000e+05, -1.096600e+06, -2.201000e+05,  1.296100e+06,
         9.750000e+05,  5.060000e+04,  4.315000e+05,  4.315000e+05,
        -5.172000e+05, -4.645000e+05,  1.159500e+06,  6.088600e+06,
        -2.606000e+05, -2.608000e+05, -1.825000e+05, -1.827000e+05,
         1.287600e+06, -1.829000e+05, -1.680300e+06, -1.827000e+05,
        -2.898000e+05, -2.898000e+05, -2.898000e+05, -2.897000e+05,
        -2.808000e+05,  2.783000e+05,  2.781000e+05,  2.782000e+05,
         1.669700e+06,  3.873000e+05,  1.022000e+05,  3.838300e+06,
         7.079000e+05,  7.079000e+05, -1.621000e+05, -1.624000e+05,
         2.860000e+04, -1.240000e+04,  1.360000e+04,  2.359000e+05,
         9.700000e+03,  1.010000e+04,  1.894800e+06,  6.920000e+04,
         3.790000e+04, -3.264000e+05,  0.000000e+00,  0.000000e+00,
         7.310000e+04,  3.211000e+05,  2.780000e+04,  6.490000e+04,
         0.000000e+00,  0.000000e+00,  2.249400e+06,  1.911200e+06,
         5.460000e+04,  1.177000e+05,  2.690000e+04,  0.000000e+00,
         2.425000e+05,  9.427000e+05,  1.880000e+04, -2.450000e+04,
        -2.450000e+04,  3.059000e+05,  1.380000e+04,  2.110000e+04,
         2.774000e+05, -1.140000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -3.000000e+02, -1.600000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.359000e+05, -1.240000e+04,
         2.487000e+05, -2.898000e+05, -3.000000e+02,  3.717000e+05,
        -2.478000e+05, -3.070000e+05,  9.060000e+04, -2.635000e+05,
         1.597000e+06,  1.287600e+06, -1.827000e+05, -2.608000e+05,
         2.782000e+05,  1.022000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.898000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.720000e+05, -3.464000e+05, -2.377000e+05, -3.779000e+05,
        -1.035000e+05,  9.018000e+05,  5.581000e+05,  1.586000e+05,
        -3.464000e+05,  1.523000e+05, -3.464000e+05, -9.470000e+04,
        -1.362000e+05,  2.455700e+06, -3.924000e+05, -1.086000e+05,
        -3.310000e+04, -3.786000e+05,  2.126400e+06,  1.296500e+06,
         1.500900e+06,  1.250900e+06, -1.119400e+06, -6.384000e+05,
         2.489600e+06, -1.023000e+05,  1.950400e+06,  6.896600e+06,
         2.043100e+06,  2.044200e+06,  2.048900e+06,  2.034000e+06,
         2.860300e+06,  2.044000e+06,  2.021280e+07,  1.911760e+07,
         1.937870e+07,  2.345900e+06,  2.067400e+06,  2.137400e+06,
        -4.819000e+05, -7.462000e+05,  2.464200e+06,  2.464200e+06,
         1.270900e+06,  8.310000e+04,  1.334100e+06,  1.640200e+06,
         4.004100e+06,  3.726400e+06, -2.239900e+06,  2.060300e+06,
        -4.960000e+05, -7.707000e+05, -7.495000e+05,  3.486300e+06,
         3.486100e+06,  2.915900e+06,  3.069300e+06,  9.903000e+05,
        -3.828000e+05, -7.994000e+05, -3.089000e+05, -2.332000e+05,
        -2.332000e+05, -2.332000e+05, -2.332000e+05, -7.577000e+05,
         2.369800e+06, -5.100000e+05, -7.705000e+05,  4.190000e+04,
        -1.149700e+06, -1.347800e+06,  2.053100e+06,  4.046000e+05,
        -2.881000e+05, -2.881000e+05, -3.924000e+05, -3.923000e+05,
        -3.924000e+05, -1.780500e+06, -3.089100e+06,  3.393100e+06,
         2.026500e+06, -6.735000e+05, -1.451600e+06, -3.864500e+06,
        -1.224700e+06, -3.060600e+06, -1.224700e+06, -3.063600e+06,
         4.022600e+06,  1.032870e+07,  1.294760e+07,  9.259700e+06,
         1.928700e+06,  1.651000e+06, -4.384500e+06,  2.293500e+06,
        -2.738000e+05, -5.485000e+05,  2.090500e+06,  4.095300e+06,
         7.254000e+05, -6.720000e+04,  9.990000e+04,  3.293000e+06,
         5.025000e+05,  2.721500e+06,  5.312500e+06,  1.305000e+05,
         1.333300e+06,  1.679000e+06,  4.268800e+06,  3.713500e+06,
         7.979000e+05, -7.578000e+05, -1.593200e+06,  1.813000e+06,
         8.145000e+05, -1.548100e+06, -8.119000e+05,  1.610900e+06,
         1.239100e+06,  4.580000e+04,  7.360000e+04,  7.360000e+04,
        -7.257000e+05, -7.698000e+05,  6.184000e+05,  6.370000e+04,
        -3.627000e+05, -3.630000e+05, -1.608000e+05, -1.610000e+05,
         1.638500e+06, -1.611000e+05, -1.954900e+06, -1.610000e+05,
        -4.113000e+05, -4.113000e+05, -4.113000e+05, -4.111000e+05,
        -4.033000e+05,  4.110000e+05,  4.107000e+05,  4.107000e+05,
         2.465400e+06,  6.549000e+05,  2.469000e+05,  4.926300e+06,
         8.161000e+05,  8.165000e+05, -4.178000e+05, -4.180000e+05,
         4.780000e+04,  2.000000e+04,  1.690000e+04,  2.081000e+05,
         1.670000e+04,  1.960000e+04,  2.455700e+06, -9.470000e+04,
         5.860000e+04, -2.886000e+05,  0.000000e+00,  0.000000e+00,
         8.760000e+04,  2.877000e+05,  3.990000e+04,  9.290000e+04,
         0.000000e+00,  0.000000e+00,  2.779300e+06,  2.482000e+06,
         8.530000e+04,  1.113000e+05,  3.860000e+04,  0.000000e+00,
         2.140000e+05,  1.222500e+06,  2.910000e+04,  1.080000e+04,
         1.070000e+04,  2.689000e+05,  2.340000e+04,  2.820000e+04,
         2.762000e+05,  3.360000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -2.000000e+02, -1.900000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.081000e+05,  2.000000e+04,
         3.223000e+05, -4.113000e+05, -2.000000e+02,  1.720000e+05,
        -3.464000e+05, -3.923000e+05, -2.332000e+05, -5.100000e+05,
         2.034800e+06,  1.638500e+06, -1.610000e+05, -3.630000e+05,
         4.108000e+05,  2.469000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -4.113000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-1.688000e+05,  5.247000e+05, -1.506000e+05, -2.583000e+05,
        -2.131000e+05, -6.534000e+05, -3.158000e+05, -1.700000e+05,
         5.246000e+05, -1.704000e+05,  5.242000e+05, -1.940000e+05,
         6.060000e+04,  1.849400e+06, -2.428000e+05, -1.947000e+05,
         1.390000e+04, -7.761000e+05,  1.263800e+06,  2.205800e+06,
         1.291400e+06,  1.097100e+06, -8.710000e+04, -6.333000e+05,
         2.192000e+06,  1.288000e+05,  2.893100e+06,  5.690900e+06,
         1.626500e+06,  1.627700e+06,  1.633900e+06,  1.610400e+06,
         2.193900e+06,  1.627500e+06,  1.508320e+07,  1.634730e+07,
         1.512010e+07,  1.659300e+06,  1.966900e+06,  1.668500e+06,
        -4.711000e+05, -5.348000e+05,  2.046800e+06,  2.046800e+06,
         1.450300e+06,  8.568000e+05,  1.161800e+06,  1.375000e+06,
         3.201500e+06,  3.511900e+06,  5.296000e+05,  1.569100e+06,
        -4.561000e+05, -5.014000e+05, -5.374000e+05,  2.642500e+06,
         2.642300e+06,  3.333600e+06,  2.660900e+06, -2.716000e+05,
        -2.787000e+05, -4.700000e+05, -1.687000e+05, -4.010000e+05,
        -4.010000e+05, -4.010000e+05, -4.010000e+05,  3.048000e+05,
         1.672000e+06, -4.424000e+05, -9.320000e+04,  2.070000e+04,
        -5.764000e+05, -9.331000e+05,  1.597800e+06,  4.623000e+05,
        -1.647000e+05, -1.647000e+05, -2.428000e+05, -2.427000e+05,
        -2.428000e+05, -1.711000e+06,  4.730000e+04,  2.410600e+06,
         1.039100e+06, -7.824000e+05,  2.790000e+05, -1.007600e+06,
        -1.625400e+06,  8.450000e+05, -1.625400e+06,  8.444000e+05,
         2.497400e+06,  7.196000e+06,  9.259700e+06,  3.046370e+07,
         1.427400e+06,  1.737500e+06,  3.728300e+06,  1.835400e+06,
        -2.105000e+05,  1.051000e+05,  1.649400e+06,  3.223600e+06,
         5.260000e+04,  1.102400e+06,  8.020000e+04,  2.098600e+06,
        -1.036000e+05,  1.331700e+06,  3.398300e+06, -7.350000e+05,
         2.883700e+06,  1.377700e+06,  3.076100e+06,  3.696900e+06,
         9.504000e+05, -8.241000e+05,  9.860000e+04,  1.225800e+06,
         9.697000e+05,  2.342000e+05, -7.046000e+05,  1.384800e+06,
         1.124700e+06,  5.282000e+05, -3.598000e+05, -3.599000e+05,
         6.772000e+05,  1.731200e+06,  1.792000e+05, -6.354100e+06,
        -1.984000e+05, -1.986000e+05, -1.170000e+04, -1.170000e+04,
         1.373400e+06, -1.180000e+04, -1.429700e+06, -1.170000e+04,
        -2.212000e+05, -2.212000e+05, -2.212000e+05, -2.213000e+05,
        -2.207000e+05,  2.301000e+05,  2.299000e+05,  2.300000e+05,
         1.380300e+06,  4.432000e+05,  2.159000e+05,  4.102300e+06,
         9.312000e+05,  9.316000e+05,  2.676000e+05,  2.674000e+05,
         2.240000e+04, -1.660000e+04, -3.160000e+04,  2.130000e+04,
         2.185000e+05,  1.480000e+04,  1.849400e+06, -1.940000e+05,
         6.487000e+05, -3.170000e+04,  0.000000e+00, -4.100000e+03,
        -2.800000e+03, -5.900000e+03,  3.014000e+05,  5.070000e+04,
         0.000000e+00,  0.000000e+00,  1.907700e+06,  2.191100e+06,
         9.922000e+05,  2.085000e+05,  2.912000e+05,  0.000000e+00,
         2.180000e+04,  9.188000e+05,  3.236000e+05, -1.810000e+04,
        -1.810000e+04,  2.530000e+04,  3.383000e+05,  1.420000e+04,
         7.300000e+03,  3.204000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -2.000000e+02, -4.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.130000e+04, -1.660000e+04,
         2.427000e+05, -2.212000e+05, -2.000000e+02, -1.688000e+05,
         5.247000e+05, -2.427000e+05, -4.010000e+05, -4.424000e+05,
         1.611700e+06,  1.373400e+06, -1.170000e+04, -1.986000e+05,
         2.300000e+05,  2.159000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.212000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.198000e+05,  1.180000e+04,  2.490000e+04, -7.270000e+04,
         2.340000e+04,  5.146000e+05,  2.750000e+05,  1.177000e+05,
         1.180000e+04,  1.166000e+05,  1.180000e+04,  7.650000e+04,
         9.500000e+03,  3.541000e+05, -2.470000e+04,  7.420000e+04,
         1.900000e+03,  3.059000e+05,  5.745000e+05,  4.058000e+05,
         4.317000e+05,  2.724000e+05, -8.560000e+04,  1.760000e+05,
         9.482000e+05,  6.694000e+05,  8.367000e+05,  1.512200e+06,
         3.786000e+05,  3.798000e+05,  3.780000e+05,  3.793000e+05,
         4.551000e+05,  3.805000e+05,  3.572100e+06,  3.349900e+06,
         3.381700e+06,  4.277000e+05,  3.712000e+05,  3.800000e+05,
        -4.970000e+04, -1.938000e+05,  4.995000e+05,  4.996000e+05,
         3.188000e+05,  1.392000e+05,  3.258000e+05,  3.522000e+05,
         8.736000e+05,  8.173000e+05, -8.630000e+04,  2.753000e+05,
        -1.000000e+03, -9.750000e+04, -1.933000e+05,  9.257000e+05,
         9.264000e+05,  8.151000e+05,  8.305000e+05,  3.463000e+05,
        -2.560000e+04, -1.300000e+03,  1.920000e+04,  1.479000e+05,
         1.479000e+05,  1.479000e+05,  1.479000e+05,  3.600000e+04,
         4.261000e+05,  4.800000e+04, -6.800000e+03, -9.100000e+03,
        -1.906000e+05, -2.084000e+05,  3.267000e+05,  1.980000e+05,
         2.160000e+04,  2.160000e+04, -2.470000e+04, -2.470000e+04,
        -2.470000e+04,  3.445000e+05,  6.540000e+04,  9.017000e+05,
         5.295000e+05,  2.314000e+05,  6.230000e+04, -3.046000e+05,
         5.450000e+05,  1.535000e+05,  5.450000e+05,  1.510000e+05,
         1.090700e+06,  1.650600e+06,  1.928700e+06,  1.427400e+06,
         5.434000e+05,  4.870000e+05,  1.846000e+05,  3.278000e+05,
         4.610000e+04, -1.080000e+04,  3.711000e+05,  7.062000e+05,
         1.217000e+05, -4.540000e+04, -2.110000e+04,  4.033000e+05,
         1.542000e+05,  6.715000e+05,  9.500000e+05,  3.929000e+05,
         3.896000e+05,  4.334000e+05,  1.062500e+06,  9.498000e+05,
         4.462000e+05,  2.496000e+05,  8.020000e+04,  5.303000e+05,
         4.516000e+05,  7.900000e+04,  2.347000e+05,  3.962000e+05,
         3.239000e+05,  1.432000e+05,  1.950000e+05,  1.950000e+05,
         3.120000e+04,  3.810000e+05,  6.628000e+05,  3.175500e+06,
         1.590000e+04,  1.590000e+04, -2.700000e+04, -2.700000e+04,
         3.498000e+05, -2.630000e+04, -4.581000e+05, -2.700000e+04,
         2.430000e+04,  2.430000e+04,  2.430000e+04,  2.430000e+04,
         2.630000e+04, -3.650000e+04, -3.650000e+04, -3.650000e+04,
        -2.190000e+05, -7.990000e+04, -5.350000e+04,  1.001700e+06,
         4.000000e+05,  4.018000e+05,  4.759000e+05,  4.766000e+05,
        -7.600000e+03, -4.380000e+04,  2.400000e+03,  3.370000e+04,
        -4.300000e+03, -3.200000e+03,  3.541000e+05,  7.650000e+04,
        -1.080000e+04, -4.590000e+04,  0.000000e+00,  1.000000e+02,
         3.400000e+03,  4.730000e+04, -4.400000e+03, -5.800000e+03,
         0.000000e+00,  0.000000e+00,  3.985000e+05,  3.470000e+05,
        -1.780000e+04,  1.170000e+04, -4.200000e+03,  0.000000e+00,
         3.530000e+04,  1.751000e+05, -5.000000e+03, -4.780000e+04,
        -4.780000e+04,  4.510000e+04, -6.800000e+03, -9.000000e+02,
        -3.500000e+03, -5.470000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         7.000000e+02,  3.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  3.370000e+04, -4.380000e+04,
         4.650000e+04,  2.430000e+04,  7.000000e+02,  1.198000e+05,
         1.180000e+04, -2.470000e+04,  1.479000e+05,  4.800000e+04,
         3.792000e+05,  3.498000e+05, -2.700000e+04,  1.590000e+04,
        -3.650000e+04, -5.350000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.430000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-1.570000e+04,  1.819000e+05,  2.380000e+04, -5.490000e+04,
        -3.510000e+04, -8.320000e+04, -5.180000e+04, -1.430000e+04,
         1.819000e+05, -1.370000e+04,  1.818000e+05,  1.060000e+04,
         4.280000e+04,  3.413000e+05, -8.200000e+03,  1.200000e+04,
         1.000000e+04,  4.220000e+04,  3.794000e+05,  7.563000e+05,
         4.409000e+05,  3.089000e+05,  1.109000e+05,  7.020000e+04,
         9.289000e+05,  6.036000e+05,  1.139500e+06,  1.582700e+06,
         3.829000e+05,  3.838000e+05,  3.828000e+05,  3.834000e+05,
         4.476000e+05,  3.846000e+05,  3.271000e+06,  3.809000e+06,
         3.353100e+06,  3.388000e+05,  5.181000e+05,  3.593000e+05,
        -9.020000e+04, -1.563000e+05,  5.298000e+05,  5.298000e+05,
         4.239000e+05,  3.225000e+05,  3.533000e+05,  3.725000e+05,
         8.619000e+05,  1.200500e+06,  6.708000e+05,  2.792000e+05,
        -4.300000e+04, -6.310000e+04, -1.558000e+05,  8.305000e+05,
         8.312000e+05,  1.072600e+06,  8.716000e+05, -9.280000e+04,
        -2.330000e+04,  3.030000e+04,  3.080000e+04,  2.720000e+04,
         2.720000e+04,  2.720000e+04,  2.720000e+04,  2.231000e+05,
         3.523000e+05,  4.100000e+03,  1.026000e+05, -9.300000e+03,
        -1.176000e+05, -1.640000e+05,  3.304000e+05,  2.247000e+05,
         2.890000e+04,  2.890000e+04, -8.200000e+03, -8.200000e+03,
        -8.200000e+03,  9.250000e+04,  5.816000e+05,  7.437000e+05,
         2.803000e+05,  6.710000e+04,  3.585000e+05,  1.911000e+05,
         1.398000e+05,  8.253000e+05,  1.398000e+05,  8.226000e+05,
         7.813000e+05,  1.325800e+06,  1.651000e+06,  1.737500e+06,
         4.870000e+05,  8.816000e+05,  1.758900e+06,  3.573000e+05,
         2.780000e+04,  1.527000e+05,  3.748000e+05,  7.137000e+05,
        -6.770000e+04,  2.377000e+05, -6.200000e+03,  2.616000e+05,
        -5.510000e+04,  3.145000e+05,  6.436000e+05, -1.450000e+04,
         2.007600e+06,  4.172000e+05,  9.328000e+05,  1.610100e+06,
         5.032000e+05,  8.570000e+04,  6.237000e+05,  4.137000e+05,
         5.071000e+05,  3.765000e+05,  4.560000e+04,  4.193000e+05,
         3.608000e+05,  2.548000e+05, -2.700000e+03, -2.700000e+03,
         2.948000e+05,  9.532000e+05, -7.399000e+05,  7.700000e+04,
         3.220000e+04,  3.220000e+04,  1.500000e+04,  1.500000e+04,
         3.700000e+05,  1.580000e+04, -3.950000e+05,  1.500000e+04,
         4.120000e+04,  4.120000e+04,  4.120000e+04,  4.120000e+04,
         4.110000e+04, -5.010000e+04, -5.010000e+04, -5.010000e+04,
        -3.008000e+05, -6.940000e+04, -2.720000e+04,  1.063900e+06,
         4.541000e+05,  4.560000e+05,  5.810000e+05,  5.817000e+05,
        -8.300000e+03, -4.480000e+04, -1.200000e+04, -2.030000e+04,
         4.130000e+04, -2.100000e+03,  3.413000e+05,  1.060000e+04,
         1.222000e+05,  2.930000e+04,  0.000000e+00, -6.000000e+02,
        -1.740000e+04, -3.770000e+04,  8.360000e+04, -9.300000e+03,
         0.000000e+00,  0.000000e+00,  3.095000e+05,  4.387000e+05,
         2.092000e+05,  3.560000e+04,  8.080000e+04,  0.000000e+00,
        -2.030000e+04,  1.699000e+05,  6.130000e+04, -4.630000e+04,
        -4.620000e+04, -2.520000e+04,  8.510000e+04, -2.600000e+03,
        -7.140000e+04,  3.880000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         7.000000e+02,  6.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -2.030000e+04, -4.480000e+04,
         4.480000e+04,  4.120000e+04,  7.000000e+02, -1.570000e+04,
         1.819000e+05, -8.200000e+03,  2.720000e+04,  4.100000e+03,
         3.833000e+05,  3.700000e+05,  1.500000e+04,  3.220000e+04,
        -5.010000e+04, -2.720000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.120000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.687000e+05,  3.623600e+06,  4.122000e+05,  2.400000e+03,
         8.620000e+04,  5.069000e+05,  1.692000e+05,  1.801000e+05,
         3.623400e+06,  1.861000e+05,  3.621300e+06,  3.856000e+05,
         8.323000e+05, -8.668000e+05,  3.136000e+05,  3.992000e+05,
         1.933000e+05,  1.542200e+06,  3.353000e+05,  5.076000e+06,
         7.343000e+05,  7.330000e+04,  3.798900e+06,  1.431400e+06,
         2.464500e+06,  3.729700e+06,  5.864900e+06,  3.100000e+04,
        -2.165000e+05, -2.166000e+05, -2.107000e+05, -2.211000e+05,
        -7.601000e+05, -2.151000e+05, -3.917200e+06,  2.400700e+06,
        -3.385300e+06, -4.570000e+05,  1.113500e+06, -3.240000e+05,
         8.900000e+04, -3.022000e+05, -2.110000e+04, -2.120000e+04,
         1.861400e+06,  3.731000e+06,  2.944000e+05,  1.015000e+05,
         1.504000e+05,  1.725100e+06,  1.113810e+07, -8.837000e+05,
         3.997000e+05,  3.160000e+05, -2.989000e+05,  1.020700e+06,
         1.022200e+06,  4.252400e+06,  1.286700e+06, -1.705000e+05,
         1.306000e+05,  9.382000e+05,  4.914000e+05,  8.001000e+05,
         8.001000e+05,  8.000000e+05,  8.001000e+05,  4.279500e+06,
        -4.619000e+05,  7.096000e+05,  2.442200e+06, -1.028000e+05,
         1.777100e+06,  4.456000e+05, -5.531000e+05,  7.007000e+05,
         4.718000e+05,  4.718000e+05,  3.136000e+05,  3.134000e+05,
         3.136000e+05,  3.265800e+06,  1.195030e+07,  7.384000e+05,
         3.870000e+04,  1.638000e+06,  6.841800e+06,  1.037490e+07,
         3.446200e+06,  1.562410e+07,  3.446200e+06,  1.562800e+07,
         9.227000e+05, -3.123300e+06, -4.384500e+06,  3.728300e+06,
         1.846000e+05,  1.758900e+06,  3.666840e+07, -7.296000e+05,
         5.382000e+05,  2.119300e+06, -3.245000e+05, -7.683000e+05,
        -6.137000e+05,  4.531400e+06, -2.148000e+05, -1.881600e+06,
        -1.528000e+05, -1.281000e+05, -1.392300e+06,  1.136200e+06,
         7.745800e+06,  5.368000e+05, -2.824000e+05,  2.867200e+06,
         1.720700e+06,  1.844500e+06,  6.556000e+06,  5.792000e+05,
         1.745200e+06,  7.067300e+06,  2.263900e+06,  4.172000e+05,
         4.130000e+05,  2.295600e+06,  5.481000e+05,  5.482000e+05,
         5.767800e+06,  1.071020e+07,  2.836300e+06,  1.043700e+07,
         5.390000e+05,  5.396000e+05,  1.361000e+05,  1.362000e+05,
         9.840000e+04,  1.377000e+05, -1.621000e+05,  1.362000e+05,
         6.516000e+05,  6.515000e+05,  6.515000e+05,  6.511000e+05,
         6.451000e+05, -6.956000e+05, -6.951000e+05, -6.952000e+05,
        -4.172800e+06, -1.143900e+06, -5.037000e+05, -1.240000e+04,
         1.404600e+06,  1.407600e+06,  3.365300e+06,  3.366900e+06,
        -1.101000e+05, -3.018000e+05, -1.899000e+05, -1.648000e+05,
         8.732000e+05, -3.650000e+04, -8.668000e+05,  3.856000e+05,
         2.911600e+06,  2.313000e+05,  0.000000e+00,  3.670000e+04,
        -2.670000e+05, -4.072000e+05,  1.117900e+06, -1.478000e+05,
         0.000000e+00,  0.000000e+00, -1.096800e+06,  4.639000e+05,
         4.315900e+06,  8.360000e+05,  1.080200e+06,  0.000000e+00,
        -1.681000e+05, -4.410000e+05,  1.453700e+06, -3.075000e+05,
        -3.075000e+05, -2.133000e+05,  1.387900e+06, -4.120000e+04,
        -5.192000e+05,  1.081300e+06,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.500000e+03,  4.000000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.648000e+05, -3.018000e+05,
        -1.138000e+05,  6.515000e+05,  1.500000e+03,  1.687000e+05,
         3.623600e+06,  3.134000e+05,  8.001000e+05,  7.096000e+05,
        -2.207000e+05,  9.840000e+04,  1.362000e+05,  5.396000e+05,
        -6.952000e+05, -5.037000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  6.516000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-1.201000e+05, -5.790000e+04, -5.160000e+04, -5.280000e+04,
        -8.620000e+04, -4.996000e+05, -2.595000e+05, -1.189000e+05,
        -5.790000e+04, -1.184000e+05, -5.790000e+04, -9.610000e+04,
        -2.600000e+04,  4.896000e+05, -6.070000e+04, -9.490000e+04,
        -5.900000e+03, -3.842000e+05,  2.052000e+05,  2.944000e+05,
         3.069000e+05,  3.002000e+05, -1.733000e+05, -2.575000e+05,
         7.372400e+06,  6.788400e+06,  7.434500e+06,  1.516100e+06,
         4.218000e+05,  4.214000e+05,  4.218000e+05,  4.238000e+05,
         5.803000e+05,  4.218000e+05,  3.789600e+06,  3.908100e+06,
         3.925100e+06,  3.951000e+05,  4.244000e+05,  4.290000e+05,
        -1.389000e+05, -9.820000e+04,  5.385000e+05,  5.385000e+05,
         3.000000e+05,  6.270000e+04,  3.026000e+05,  3.582000e+05,
         8.080000e+05,  8.375000e+05, -3.554000e+05,  4.312000e+05,
        -1.468000e+05, -1.136000e+05, -9.870000e+04,  5.851000e+05,
         5.854000e+05,  6.458000e+05,  6.528000e+05, -2.985000e+05,
        -5.990000e+04, -1.293000e+05, -5.230000e+04, -1.888000e+05,
        -1.888000e+05, -1.887000e+05, -1.888000e+05, -1.261000e+05,
         3.937000e+05, -1.552000e+05, -1.240000e+05,  8.700000e+03,
        -2.304000e+05, -2.220000e+05,  4.262000e+05,  1.091000e+05,
        -5.290000e+04, -5.290000e+04, -6.070000e+04, -6.070000e+04,
        -6.070000e+04, -6.614000e+05, -5.048000e+05,  5.016000e+05,
         1.298000e+05, -3.331000e+05, -2.384000e+05, -7.219000e+05,
        -7.280000e+05, -5.085000e+05, -7.280000e+05, -5.090000e+05,
         4.372000e+05,  1.710900e+06,  2.293500e+06,  1.835400e+06,
         3.278000e+05,  3.573000e+05, -7.296000e+05,  7.431800e+06,
         6.843900e+06,  6.876600e+06,  4.310000e+05,  8.473000e+05,
         6.828900e+06,  6.938500e+06,  6.930500e+06,  7.419200e+06,
        -1.356000e+05,  1.540000e+05,  7.365000e+05, -4.285000e+05,
         3.014000e+05,  3.233000e+05,  7.238000e+05,  7.827000e+05,
         2.146000e+05, -3.505000e+05, -2.627000e+05,  2.333000e+05,
         2.177000e+05, -2.568000e+05, -3.413000e+05,  3.491000e+05,
         2.949000e+05,  5.630000e+04, -2.119000e+05, -2.119000e+05,
        -1.203000e+05,  3.408900e+06,  3.261500e+06, -3.555500e+06,
        -5.880000e+04, -5.890000e+04,  6.919400e+06,  6.924000e+06,
         3.569000e+05,  6.924300e+06,  1.349460e+07,  6.924000e+06,
        -6.810000e+04, -6.810000e+04, -6.810000e+04, -6.810000e+04,
        -6.880000e+04,  7.280000e+04,  7.280000e+04,  7.280000e+04,
         4.369000e+05,  7.059700e+06,  6.991800e+06,  1.078200e+06,
         2.216000e+05,  2.225000e+05,  1.880000e+04,  1.920000e+04,
         9.600000e+03,  6.400000e+03,  2.900000e+03, -1.910000e+04,
         3.200000e+03,  5.400000e+03,  4.896000e+05, -9.610000e+04,
         9.500000e+03,  2.570000e+04,  0.000000e+00,  0.000000e+00,
         8.100000e+03, -2.140000e+04,  5.800000e+03,  1.570000e+04,
         0.000000e+00,  0.000000e+00,  4.613000e+05,  4.927000e+05,
         1.320000e+04, -5.800000e+03,  5.600000e+03,  0.000000e+00,
        -1.930000e+04,  2.437000e+05,  4.900000e+03,  7.400000e+03,
         7.400000e+03, -2.440000e+04,  3.700000e+03,  4.000000e+03,
        -1.670000e+04,  1.120000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         3.000000e+02,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.910000e+04,  6.400000e+03,
         6.430000e+04, -6.810000e+04,  3.000000e+02, -1.201000e+05,
        -5.790000e+04, -6.070000e+04, -1.888000e+05, -1.552000e+05,
         4.238000e+05,  3.569000e+05,  6.924000e+06, -5.890000e+04,
         7.280000e+04,  6.991800e+06,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -6.810000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 7.760000e+04,  4.100000e+04,  3.920000e+04, -3.100000e+03,
         3.710000e+04,  3.198000e+05,  1.646000e+05,  7.720000e+04,
         4.100000e+04,  7.700000e+04,  4.100000e+04,  6.670000e+04,
         1.930000e+04, -7.340000e+04,  2.490000e+04,  6.620000e+04,
         4.400000e+03,  2.667000e+05,  1.276000e+05,  7.090000e+04,
         7.070000e+04,  2.600000e+03,  6.330000e+04,  1.880000e+05,
         7.158700e+06,  7.296300e+06,  7.121000e+06,  4.570000e+04,
        -1.960000e+04, -2.100000e+04, -1.890000e+04, -1.770000e+04,
        -6.280000e+04, -2.070000e+04, -2.101000e+05, -2.882000e+05,
        -2.860000e+05, -7.600000e+03, -2.550000e+04, -2.660000e+04,
         3.400000e+04, -3.390000e+04, -5.000000e+03, -5.000000e+03,
         2.550000e+04,  5.600000e+04,  2.550000e+04,  6.300000e+03,
         3.950000e+04,  2.110000e+04,  1.736000e+05, -7.610000e+04,
         6.190000e+04,  2.170000e+04, -3.370000e+04,  1.493000e+05,
         1.496000e+05,  1.118000e+05,  1.113000e+05,  1.834000e+05,
         2.590000e+04,  7.770000e+04,  4.120000e+04,  1.328000e+05,
         1.328000e+05,  1.328000e+05,  1.328000e+05,  9.490000e+04,
        -5.900000e+03,  8.980000e+04,  7.130000e+04, -9.100000e+03,
         2.120000e+04,  2.130000e+04, -4.800000e+04,  5.700000e+04,
         4.120000e+04,  4.120000e+04,  2.490000e+04,  2.490000e+04,
         2.490000e+04,  4.332000e+05,  3.392000e+05,  1.556000e+05,
         1.238000e+05,  2.356000e+05,  1.768000e+05,  2.418000e+05,
         5.194000e+05,  3.869000e+05,  5.194000e+05,  3.865000e+05,
         2.476000e+05, -1.349000e+05, -2.738000e+05, -2.105000e+05,
         4.610000e+04,  2.780000e+04,  5.382000e+05,  6.843900e+06,
         7.082400e+06,  6.985300e+06, -2.950000e+04, -6.850000e+04,
         6.927600e+06,  6.882800e+06,  6.870700e+06,  6.703700e+06,
         7.800000e+04,  1.513000e+05,  1.210000e+04,  2.904000e+05,
         5.960000e+04,  5.640000e+04,  3.820000e+04,  1.600000e+03,
         1.412000e+05,  2.539000e+05,  2.003000e+05,  1.122000e+05,
         1.432000e+05,  1.967000e+05,  2.481000e+05,  3.330000e+04,
         3.170000e+04,  6.220000e+04,  1.428000e+05,  1.428000e+05,
         8.900000e+04,  3.717500e+06,  3.809200e+06,  2.421500e+06,
         4.400000e+04,  4.400000e+04,  6.897500e+06,  6.902000e+06,
         6.000000e+03,  6.902300e+06,  1.377000e+07,  6.902000e+06,
         5.400000e+04,  5.400000e+04,  5.400000e+04,  5.510000e+04,
         5.420000e+04, -6.090000e+04, -6.090000e+04, -6.090000e+04,
        -3.655000e+05,  6.791200e+06,  6.846600e+06, -9.900000e+03,
         1.144000e+05,  1.149000e+05,  2.774000e+05,  2.776000e+05,
        -9.600000e+03, -2.610000e+04, -5.000000e+02,  8.900000e+03,
        -3.900000e+03, -4.100000e+03, -7.340000e+04,  6.670000e+04,
        -1.160000e+04, -1.120000e+04,  0.000000e+00,  1.000000e+02,
        -5.300000e+03,  1.100000e+04, -6.500000e+03, -1.240000e+04,
         0.000000e+00,  0.000000e+00, -6.080000e+04, -7.910000e+04,
        -1.720000e+04,  4.000000e+02, -6.200000e+03,  0.000000e+00,
         9.400000e+03, -3.730000e+04, -5.600000e+03, -2.770000e+04,
        -2.770000e+04,  1.180000e+04, -5.300000e+03, -3.200000e+03,
        -1.640000e+04, -3.310000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         3.000000e+02,  3.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  8.900000e+03, -2.610000e+04,
        -9.600000e+03,  5.400000e+04,  3.000000e+02,  7.760000e+04,
         4.100000e+04,  2.490000e+04,  1.328000e+05,  8.980000e+04,
        -1.780000e+04,  6.000000e+03,  6.902000e+06,  4.400000e+04,
        -6.090000e+04,  6.846600e+06,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  5.400000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-5.750000e+04,  2.116000e+05,  3.850000e+04,  1.480000e+04,
        -2.110000e+04, -2.759000e+05, -1.610000e+05, -5.440000e+04,
         2.116000e+05, -5.290000e+04,  2.115000e+05,  1.200000e+03,
         5.280000e+04, -8.650000e+04,  4.130000e+04,  4.400000e+03,
         1.260000e+04,  4.600000e+03, -6.910000e+04,  4.228000e+05,
         7.820000e+04,  3.930000e+04,  2.597000e+05,  7.930000e+04,
         7.143300e+06,  7.233200e+06,  7.429300e+06,  1.151000e+05,
        -1.510000e+04, -1.670000e+04, -1.380000e+04, -1.360000e+04,
        -7.040000e+04, -1.640000e+04, -5.109000e+05,  1.414000e+05,
        -3.145000e+05, -8.010000e+04,  8.300000e+04, -3.100000e+04,
        -6.000000e+03,  3.700000e+03,  2.600000e+04,  2.600000e+04,
         1.312000e+05,  2.398000e+05,  5.240000e+04,  2.730000e+04,
         3.110000e+04,  1.946000e+05,  7.207000e+05, -7.270000e+04,
         2.000000e+04,  5.610000e+04,  3.800000e+03,  5.630000e+04,
         5.660000e+04,  3.716000e+05,  1.545000e+05, -2.539000e+05,
         2.870000e+04,  1.092000e+05,  5.330000e+04,  1.090000e+04,
         1.090000e+04,  1.090000e+04,  1.090000e+04,  2.832000e+05,
        -7.970000e+04,  4.570000e+04,  1.810000e+05, -9.900000e+03,
         9.350000e+04,  6.450000e+04, -4.450000e+04,  8.470000e+04,
         4.890000e+04,  4.890000e+04,  4.130000e+04,  4.140000e+04,
         4.130000e+04,  1.786000e+05,  8.585000e+05, -3.800000e+03,
        -1.233000e+05,  6.750000e+04,  4.736000e+05,  7.385000e+05,
         1.094000e+05,  1.062300e+06,  1.094000e+05,  1.062900e+06,
        -5.920000e+04, -4.581000e+05, -5.485000e+05,  1.051000e+05,
        -1.080000e+04,  1.527000e+05,  2.119300e+06,  6.876600e+06,
         6.985300e+06,  7.224600e+06, -2.650000e+04, -6.080000e+04,
         6.732100e+06,  7.166900e+06,  6.879400e+06,  6.628200e+06,
        -1.284000e+05, -1.944000e+05, -2.859000e+05, -1.029000e+05,
         6.230000e+05,  5.120000e+04, -9.310000e+04,  2.339000e+05,
         1.977000e+05,  8.740000e+04,  5.767000e+05, -6.300000e+03,
         2.011000e+05,  4.966000e+05,  6.180000e+04,  5.460000e+04,
         6.930000e+04,  1.745000e+05, -5.470000e+04, -5.470000e+04,
         3.538000e+05,  4.294000e+06,  3.476500e+06, -6.808000e+05,
         6.000000e+04,  6.010000e+04,  6.940900e+06,  6.945400e+06,
         2.680000e+04,  6.945700e+06,  1.383470e+07,  6.945400e+06,
         7.160000e+04,  7.160000e+04,  7.160000e+04,  7.290000e+04,
         6.980000e+04, -7.370000e+04, -7.360000e+04, -7.360000e+04,
        -4.421000e+05,  6.803800e+06,  6.874700e+06,  5.410000e+04,
         1.705000e+05,  1.711000e+05,  3.864000e+05,  3.867000e+05,
        -1.110000e+04, -2.730000e+04, -1.490000e+04, -4.490000e+04,
         4.160000e+04, -2.900000e+03, -8.650000e+04,  1.200000e+03,
         1.213000e+05,  6.290000e+04,  0.000000e+00, -6.000000e+02,
        -2.710000e+04, -7.390000e+04,  8.140000e+04, -1.600000e+04,
         0.000000e+00,  0.000000e+00, -1.488000e+05,  1.200000e+04,
         2.096000e+05,  2.430000e+04,  7.870000e+04,  0.000000e+00,
        -4.600000e+04, -4.410000e+04,  6.070000e+04, -2.620000e+04,
        -2.620000e+04, -5.840000e+04,  8.650000e+04, -4.900000e+03,
        -8.410000e+04,  6.030000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         3.000000e+02,  6.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -4.490000e+04, -2.730000e+04,
        -1.140000e+04,  7.160000e+04,  3.000000e+02, -5.750000e+04,
         2.116000e+05,  4.140000e+04,  1.090000e+04,  4.570000e+04,
        -1.350000e+04,  2.680000e+04,  6.945400e+06,  6.010000e+04,
        -7.370000e+04,  6.874700e+06,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  7.160000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-3.950000e+04, -2.700000e+04, -1.990000e+04, -6.460000e+04,
        -5.190000e+04, -1.630000e+05, -8.400000e+04, -3.910000e+04,
        -2.700000e+04, -3.900000e+04, -2.700000e+04, -3.330000e+04,
        -1.080000e+04,  4.284000e+05, -4.580000e+04, -3.320000e+04,
        -2.500000e+03, -1.334000e+05,  3.330000e+05,  3.430000e+05,
         3.615000e+05,  2.778000e+05, -1.376000e+05, -8.640000e+04,
         6.585000e+05,  1.996000e+05,  6.671000e+05,  1.432100e+06,
         4.017000e+05,  4.018000e+05,  4.007000e+05,  4.019000e+05,
         5.221000e+05,  4.021000e+05,  3.635400e+06,  3.649600e+06,
         3.673500e+06,  3.957000e+05,  3.995000e+05,  4.052000e+05,
        -1.168000e+05, -1.482000e+05,  5.104000e+05,  5.104000e+05,
         3.002000e+05,  9.170000e+04,  3.058000e+05,  3.494000e+05,
         8.056000e+05,  8.092000e+05, -2.419000e+05,  3.557000e+05,
        -9.730000e+04, -1.105000e+05, -1.478000e+05,  7.098000e+05,
         7.101000e+05,  7.181000e+05,  7.289000e+05, -9.400000e+04,
        -4.880000e+04, -7.290000e+04, -2.080000e+04, -6.300000e+04,
        -6.300000e+04, -6.300000e+04, -6.300000e+04, -5.420000e+04,
         3.956000e+05, -7.780000e+04, -7.230000e+04,  2.444900e+06,
         2.232600e+06,  2.235000e+06,  3.780000e+05,  1.428000e+05,
        -2.080000e+04, -2.080000e+04, -4.580000e+04, -4.580000e+04,
        -4.580000e+04, -2.760000e+05, -2.526000e+05,  6.384000e+05,
         2.569700e+06,  4.771500e+06,  4.818400e+06,  4.353900e+06,
        -2.464000e+05, -2.155000e+05, -2.464000e+05, -2.164000e+05,
         6.645000e+05,  1.632100e+06,  2.090500e+06,  1.649400e+06,
         3.711000e+05,  3.748000e+05, -3.245000e+05,  4.310000e+05,
        -2.950000e+04, -2.650000e+04,  2.888900e+06,  7.775000e+05,
        -1.050000e+04,  2.400000e+03,  1.800000e+04,  4.499000e+05,
         2.412400e+06,  3.191000e+05,  7.786000e+05, -1.405000e+05,
         3.372000e+05,  3.667000e+05,  7.694000e+05,  7.766000e+05,
         3.161000e+05, -1.202000e+05, -1.087000e+05,  3.399000e+05,
         3.196000e+05, -1.081000e+05, -1.231000e+05,  3.686000e+05,
         2.992000e+05,  8.900000e+04, -7.040000e+04, -7.040000e+04,
        -5.350000e+04,  1.450000e+05,  1.269000e+05, -1.179000e+06,
         2.432200e+06,  2.436100e+06,  2.300000e+03,  2.300000e+03,
         3.471000e+05,  2.700000e+03, -3.700000e+05,  2.300000e+03,
        -2.720000e+04, -2.720000e+04, -2.720000e+04, -2.710000e+04,
        -2.690000e+04,  2.333200e+06,  2.331600e+06,  2.331900e+06,
         1.399690e+07,  5.250000e+04,  2.740000e+04,  1.023000e+06,
         2.940000e+05,  2.952000e+05,  2.144000e+05,  2.148000e+05,
         2.459700e+06, -1.760000e+04,  2.900000e+03, -5.000000e+03,
         0.000000e+00,  1.900000e+03,  4.284000e+05, -3.330000e+04,
         6.000000e+02,  8.000000e+03,  0.000000e+00,  0.000000e+00,
         6.500000e+03, -3.000000e+03,  1.800000e+03,  6.200000e+03,
         0.000000e+00,  0.000000e+00,  4.200000e+05,  4.269000e+05,
        -4.000000e+02, -2.100000e+03,  1.700000e+03,  0.000000e+00,
        -4.900000e+03,  2.127000e+05,  5.000000e+02, -1.860000e+04,
        -1.860000e+04, -5.700000e+03, -7.000000e+02,  1.700000e+03,
        -2.440000e+04, -1.930000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         3.000000e+02,  2.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02, -5.000000e+03, -1.760000e+04,
         5.620000e+04, -2.720000e+04,  3.000000e+02, -3.950000e+04,
        -2.700000e+04, -4.580000e+04, -6.300000e+04, -7.780000e+04,
         4.018000e+05,  3.471000e+05,  2.300000e+03,  2.436100e+06,
         2.332000e+06,  2.740000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.720000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-8.680000e+04, -6.380000e+04, -4.420000e+04,  2.092000e+05,
         6.110000e+04, -3.569000e+05, -1.833000e+05, -8.630000e+04,
        -6.380000e+04, -8.610000e+04, -6.380000e+04, -7.510000e+04,
        -2.530000e+04,  8.400000e+05,  7.730000e+04, -7.460000e+04,
        -5.800000e+03, -3.003000e+05,  6.182000e+05,  6.425000e+05,
         6.817000e+05,  1.112900e+06,  2.290000e+05, -2.075000e+05,
         1.222400e+06,  3.098000e+05,  1.242600e+06,  6.365200e+06,
         7.774000e+05,  7.790000e+05,  7.768000e+05,  7.775000e+05,
         1.018700e+06,  7.793000e+05,  7.051100e+06,  7.087100e+06,
         7.135800e+06,  7.662000e+05,  7.734000e+05,  7.874000e+05,
         2.702000e+05,  5.507000e+05,  1.408400e+06,  1.408200e+06,
         9.674000e+05,  5.268000e+05,  9.694000e+05,  8.849000e+05,
         2.361000e+06,  2.368600e+06,  1.644000e+05,  1.074400e+06,
         1.386000e+05,  2.868000e+05,  5.509000e+05,  1.340800e+06,
         1.341100e+06,  1.360100e+06,  1.383100e+06, -2.028000e+05,
         9.260000e+04,  2.280000e+04, -4.750000e+04, -1.472000e+05,
        -1.472000e+05, -1.472000e+05, -1.472000e+05, -1.266000e+05,
         7.652000e+05,  7.700000e+03,  1.850000e+04, -1.200000e+03,
        -4.286000e+05, -4.142000e+05,  9.307000e+05,  4.023000e+05,
        -4.740000e+04, -4.740000e+04,  7.730000e+04,  7.730000e+04,
         7.730000e+04, -2.660000e+05, -2.155000e+05,  1.578400e+06,
         8.430000e+05, -2.843000e+05, -2.536000e+05, -1.115900e+06,
        -5.766000e+05, -5.047000e+05, -5.766000e+05, -5.057000e+05,
         1.235300e+06,  3.183000e+06,  4.095300e+06,  3.223600e+06,
         7.062000e+05,  7.137000e+05, -7.683000e+05,  8.473000e+05,
        -6.850000e+04, -6.080000e+04,  7.775000e+05,  1.741600e+06,
        -2.770000e+04,  4.000000e+03,  3.580000e+04,  8.880000e+05,
        -1.028000e+05,  5.932000e+05,  1.506500e+06, -3.201000e+05,
         6.309000e+05,  6.990000e+05,  1.475300e+06,  1.490400e+06,
         5.813000e+05, -2.820000e+05, -2.607000e+05,  6.329000e+05,
         5.887000e+05, -2.525000e+05, -2.860000e+05,  7.033000e+05,
         9.711000e+05,  5.302000e+05, -1.583000e+05, -1.583000e+05,
        -1.265000e+05,  2.181000e+05,  1.804000e+05, -2.680200e+06,
        -6.330000e+04, -6.340000e+04,  6.100000e+03,  6.200000e+03,
         8.886000e+05,  6.500000e+03, -7.039000e+05,  6.200000e+03,
        -6.280000e+04, -6.280000e+04, -6.280000e+04, -6.280000e+04,
        -6.220000e+04,  6.010000e+04,  6.000000e+04,  6.000000e+04,
         3.604000e+05,  1.289000e+05,  6.750000e+04,  2.797300e+06,
         7.622000e+05,  7.613000e+05,  5.734000e+05,  5.737000e+05,
        -2.000000e+02,  1.255000e+05, -5.300000e+03, -9.600000e+03,
        -5.000000e+02,  5.000000e+03,  8.400000e+05, -7.510000e+04,
        -1.600000e+03,  1.320000e+04,  0.000000e+00,  0.000000e+00,
         4.000000e+03, -1.900000e+04, -8.200000e+03,  1.430000e+04,
         0.000000e+00,  0.000000e+00,  8.261000e+05,  8.369000e+05,
        -4.200000e+03, -5.100000e+03, -7.900000e+03,  0.000000e+00,
        -9.600000e+03,  4.170000e+05, -6.000000e+02,  1.321000e+05,
         1.321000e+05, -1.490000e+04, -3.800000e+03,  3.300000e+03,
         1.179000e+05,  1.284000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         3.000000e+02, -1.300000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -9.600000e+03,  1.255000e+05,
         1.102000e+05, -6.280000e+04,  3.000000e+02, -8.680000e+04,
        -6.380000e+04,  7.730000e+04, -1.472000e+05,  7.700000e+03,
         7.774000e+05,  8.886000e+05,  6.200000e+03, -6.340000e+04,
         6.000000e+04,  6.750000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -6.280000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 3.262000e+05, -4.730000e+04, -8.200000e+03, -5.310000e+04,
         1.357000e+05,  1.445000e+06,  7.928000e+05,  3.171000e+05,
        -4.730000e+04,  3.127000e+05, -4.730000e+04,  1.499000e+05,
        -1.200000e+04,  4.350000e+04, -5.310000e+04,  1.404000e+05,
        -3.900000e+03,  5.994000e+05,  4.560000e+05, -1.195000e+05,
        -4.880000e+04, -1.172000e+05, -1.476000e+05,  2.266000e+05,
         6.846700e+06,  6.947900e+06,  6.461000e+06, -3.154000e+05,
        -1.710000e+04, -1.740000e+04, -1.820000e+04, -1.350000e+04,
         2.570000e+04, -1.710000e+04,  7.279000e+05, -3.940000e+04,
         5.480000e+04,  1.774000e+05, -1.050000e+04,  9.100000e+03,
         8.150000e+04, -1.077000e+05, -1.037000e+05, -1.037000e+05,
        -1.189000e+05, -1.342000e+05, -9.430000e+04, -7.100000e+04,
        -3.220000e+04, -2.218000e+05, -2.979000e+05, -4.600000e+03,
         8.310000e+04, -1.063000e+05, -1.071000e+05,  1.832000e+05,
         1.835000e+05, -2.050000e+05, -1.534000e+05,  1.076100e+06,
        -5.380000e+04, -1.062000e+05, -4.290000e+04,  2.764000e+05,
         2.764000e+05,  2.764000e+05,  2.764000e+05, -1.081000e+05,
         1.789000e+05,  8.600000e+04, -1.031000e+05,  4.800000e+03,
        -9.400000e+03, -1.106000e+05, -1.010000e+04, -9.730000e+04,
        -3.110000e+04, -3.110000e+04, -5.310000e+04, -5.310000e+04,
        -5.310000e+04,  5.294000e+05, -4.289000e+05,  3.363000e+05,
         5.847000e+05,  3.661000e+05, -2.089000e+05, -2.430000e+05,
         9.084000e+05, -4.374000e+05,  9.084000e+05, -4.390000e+05,
         7.233000e+05,  8.232000e+05,  7.254000e+05,  5.260000e+04,
         1.217000e+05, -6.770000e+04, -6.137000e+05,  6.828900e+06,
         6.927600e+06,  6.732100e+06, -1.050000e+04, -2.770000e+04,
         7.464400e+06,  6.804800e+06,  6.959500e+06,  7.363000e+06,
         5.103000e+05,  8.385000e+05,  7.422000e+05,  9.348000e+05,
        -1.097000e+05, -2.900000e+03,  3.043000e+05, -7.500000e+04,
        -1.971000e+05,  3.564000e+05, -2.073000e+05,  2.609000e+05,
        -2.004000e+05, -2.228000e+05,  2.967000e+05, -7.480000e+04,
        -1.246000e+05, -1.398000e+05,  4.693000e+05,  4.693000e+05,
        -1.008000e+05,  3.064300e+06,  4.012500e+06,  7.318500e+06,
        -5.390000e+04, -5.390000e+04,  6.778500e+06,  6.783000e+06,
        -7.160000e+04,  6.783200e+06,  1.364400e+07,  6.783000e+06,
        -6.080000e+04, -6.080000e+04, -6.080000e+04, -6.070000e+04,
        -5.520000e+04,  5.060000e+04,  5.060000e+04,  5.060000e+04,
         3.036000e+05,  6.898300e+06,  6.840600e+06, -2.148000e+05,
        -1.927000e+05, -1.921000e+05, -3.741000e+05, -3.738000e+05,
         7.200000e+03,  6.800000e+03,  1.400000e+03,  1.359000e+05,
         2.300000e+03, -1.700000e+03,  4.350000e+04,  1.499000e+05,
         1.140000e+04, -1.880000e+05,  0.000000e+00,  0.000000e+00,
         2.570000e+04,  1.799000e+05,  8.100000e+03,  1.290000e+04,
         0.000000e+00,  0.000000e+00,  2.307000e+05,  4.970000e+04,
         1.770000e+04,  6.600000e+04,  7.800000e+03,  0.000000e+00,
         1.403000e+05,  2.290000e+04,  5.800000e+03, -1.000000e+02,
        -1.000000e+02,  1.776000e+05,  4.400000e+03,  5.600000e+03,
         1.755000e+05,  3.900000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         3.000000e+02, -9.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.359000e+05,  6.800000e+03,
         5.700000e+03, -6.080000e+04,  3.000000e+02,  3.262000e+05,
        -4.730000e+04, -5.310000e+04,  2.764000e+05,  8.600000e+04,
        -1.370000e+04, -7.160000e+04,  6.783000e+06, -5.390000e+04,
         5.060000e+04,  6.840600e+06,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -6.080000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-7.920000e+04,  5.343000e+05, -1.180000e+04, -3.000000e+02,
        -3.950000e+04, -3.416000e+05, -1.833000e+05, -7.760000e+04,
         5.343000e+05, -7.680000e+04,  5.340000e+05, -4.760000e+04,
         1.020000e+05,  9.200000e+03, -5.600000e+03, -4.570000e+04,
         2.370000e+04, -1.902000e+05, -1.277000e+05,  7.224000e+05,
        -2.280000e+04, -6.900000e+03,  4.483000e+05, -1.032000e+05,
         6.807400e+06,  6.751800e+06,  7.418100e+06, -1.121000e+05,
        -5.000000e+02, -5.000000e+02, -2.000000e+02, -1.100000e+03,
         6.300000e+03, -1.000000e+02, -1.325000e+05,  1.001000e+06,
         7.300000e+03, -3.520000e+04,  2.476000e+05, -3.000000e+02,
        -3.970000e+04,  4.700000e+03, -5.900000e+03, -5.900000e+03,
         2.242000e+05,  4.526000e+05, -1.200000e+04, -4.800000e+03,
        -5.110000e+04,  2.319000e+05,  1.382500e+06,  8.300000e+03,
        -4.520000e+04, -5.900000e+03,  4.400000e+03, -1.022000e+05,
        -1.018000e+05,  4.974000e+05, -3.230000e+04, -2.337000e+05,
        -3.670000e+04, -1.650000e+04, -7.900000e+03, -9.120000e+04,
        -9.120000e+04, -9.120000e+04, -9.120000e+04,  5.247000e+05,
        -3.620000e+04, -5.100000e+04,  2.563000e+05,  2.700000e+03,
         2.334000e+05,  1.500000e+04,  3.800000e+03, -1.190000e+04,
        -9.400000e+03, -9.400000e+03, -5.600000e+03, -5.600000e+03,
        -5.600000e+03, -2.485000e+05,  1.290400e+06, -1.388000e+05,
        -1.557000e+05, -1.410000e+05,  7.826000e+05,  1.178400e+06,
        -3.286000e+05,  1.826900e+06, -3.286000e+05,  1.827200e+06,
        -2.200000e+05, -1.223000e+05, -6.720000e+04,  1.102400e+06,
        -4.540000e+04,  2.377000e+05,  4.531400e+06,  6.938500e+06,
         6.882800e+06,  7.166900e+06,  2.400000e+03,  4.000000e+03,
         6.804800e+06,  7.908100e+06,  6.909600e+06,  6.860900e+06,
        -1.076000e+05, -1.944000e+05, -1.396000e+05, -2.492000e+05,
         1.220900e+06, -1.960000e+04, -8.110000e+04,  4.850000e+05,
        -2.860000e+04, -1.464000e+05,  7.021000e+05, -9.150000e+04,
        -2.870000e+04,  7.778000e+05, -5.900000e+04, -9.000000e+03,
        -1.060000e+04,  2.195000e+05, -1.240000e+05, -1.240000e+05,
         7.974000e+05,  4.797100e+06,  3.381800e+06, -2.003600e+06,
        -7.200000e+03, -7.200000e+03,  6.924800e+06,  6.929300e+06,
        -5.400000e+03,  6.929700e+06,  1.386870e+07,  6.929300e+06,
        -9.600000e+03, -9.600000e+03, -9.600000e+03, -9.600000e+03,
        -1.020000e+04,  1.430000e+04,  1.430000e+04,  1.430000e+04,
         8.580000e+04,  6.950000e+06,  6.939700e+06, -1.110000e+04,
        -2.400000e+04, -2.330000e+04, -5.140000e+04, -5.100000e+04,
         2.800000e+03,  3.800000e+03, -3.230000e+04, -2.460000e+04,
         1.597000e+05,  1.900000e+03,  9.200000e+03, -4.760000e+04,
         4.717000e+05,  3.360000e+04,  0.000000e+00, -3.200000e+03,
        -3.020000e+04, -6.460000e+04,  2.112000e+05,  2.400000e+03,
         0.000000e+00,  0.000000e+00, -2.470000e+04,  2.566000e+05,
         7.216000e+05,  1.340000e+05,  2.041000e+05,  0.000000e+00,
        -2.500000e+04,  4.900000e+03,  2.356000e+05,  5.100000e+03,
         5.100000e+03, -3.230000e+04,  2.466000e+05,  4.000000e+02,
        -2.690000e+04,  2.519000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.000000e+02,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -2.460000e+04,  3.800000e+03,
         1.200000e+03, -9.600000e+03,  4.000000e+02, -7.920000e+04,
         5.343000e+05, -5.600000e+03, -9.120000e+04, -5.100000e+04,
        -1.100000e+03, -5.400000e+03,  6.929300e+06, -7.200000e+03,
         1.430000e+04,  6.939700e+06,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -9.600000e+03,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-5.110000e+04, -1.590000e+04,  1.369600e+06,  8.500000e+03,
        -2.150000e+04, -2.364000e+05, -1.341000e+05, -5.380000e+04,
        -1.590000e+04, -5.530000e+04, -1.590000e+04, -3.110000e+04,
        -4.500000e+03,  3.290000e+04, -5.000000e+03, -3.450000e+04,
        -1.500000e+03, -1.243000e+05, -6.150000e+04, -2.420000e+04,
         8.209800e+06,  1.560000e+04, -7.100000e+03, -7.410000e+04,
         6.784000e+06,  6.724800e+06,  6.805200e+06,  8.390000e+04,
         8.900000e+03,  8.700000e+03,  8.300000e+03,  1.230000e+04,
         3.070000e+04,  9.100000e+03,  8.420000e+04,  1.356000e+05,
         1.853840e+07, -2.600000e+03,  1.400000e+04,  4.611000e+06,
        -1.370000e+04,  2.450000e+04,  1.290000e+04,  1.290000e+04,
         1.000000e+03, -1.060000e+04,  2.747100e+06,  3.200000e+03,
         2.000000e+02,  1.500000e+04, -4.440000e+04,  4.410000e+04,
        -2.560000e+04,  3.500000e+03,  1.990000e+04, -6.390000e+04,
        -6.350000e+04, -4.540000e+04,  9.163200e+06, -1.972000e+05,
        -7.670000e+04, -2.340000e+04, -1.730000e+04, -6.260000e+04,
        -6.260000e+04, -6.260000e+04, -6.260000e+04, -4.010000e+04,
         8.000000e+02, -3.680000e+04, -2.180000e+04,  7.300000e+03,
        -3.700000e+03, -7.000000e+02,  2.710000e+04, -2.350000e+04,
         6.079000e+05,  6.080000e+05, -5.000000e+03, -5.000000e+03,
        -5.000000e+03, -1.872000e+05, -1.277000e+05, -5.790000e+04,
        -8.030000e+04, -9.920000e+04, -6.530000e+04, -8.970000e+04,
        -2.402000e+05, -1.614000e+05, -2.402000e+05, -1.643000e+05,
        -1.007000e+05,  3.700000e+04,  9.990000e+04,  8.020000e+04,
        -2.110000e+04, -6.200000e+03, -2.148000e+05,  6.930500e+06,
         6.870700e+06,  6.879400e+06,  1.800000e+04,  3.580000e+04,
         6.959500e+06,  6.909600e+06,  2.080020e+07,  7.016700e+06,
        -7.390000e+04, -9.220000e+04, -2.750000e+04, -1.570000e+05,
        -1.850000e+04,  2.297560e+07, -1.800000e+04,  1.160000e+04,
        -6.290000e+04, -1.141000e+05, -6.430000e+04, -5.110000e+04,
        -6.400000e+04, -8.410000e+04, -1.535000e+05, -1.390000e+04,
        -2.900000e+03, -1.480000e+04, -7.830000e+04, -7.840000e+04,
        -3.520000e+04,  3.341000e+06,  3.267200e+06, -1.351500e+06,
        -1.490000e+04, -1.490000e+04,  6.890400e+06,  6.895000e+06,
         2.400000e+03,  6.895400e+06,  1.380540e+07,  6.895000e+06,
        -2.420000e+04, -2.420000e+04, -2.420000e+04, -2.410000e+04,
        -2.200000e+04,  1.760000e+04,  1.760000e+04,  1.760000e+04,
         1.055000e+05,  6.935300e+06,  6.915100e+06,  1.560000e+04,
        -4.530000e+04, -4.460000e+04, -1.166000e+05, -1.162000e+05,
         9.700000e+03,  1.600000e+04, -7.020000e+04, -3.360000e+04,
         1.800000e+03,  2.957000e+05,  3.290000e+04, -3.110000e+04,
         7.400000e+03,  1.980000e+04,  0.000000e+00,  0.000000e+00,
         2.171800e+06, -8.890000e+04, -6.560000e+04,  5.200000e+03,
         0.000000e+00,  0.000000e+00,  1.610000e+04,  3.800000e+04,
         1.210000e+04, -1.800000e+03, -6.330000e+04,  0.000000e+00,
        -3.190000e+04,  1.700000e+04,  3.900000e+03,  8.400000e+03,
         8.300000e+03, -2.470000e+04, -1.600000e+03,  3.106000e+05,
        -1.680000e+04,  6.700000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.000000e+02, -6.100000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.360000e+04,  1.600000e+04,
         4.300000e+03, -2.420000e+04,  4.000000e+02, -5.110000e+04,
        -1.590000e+04, -5.000000e+03, -6.260000e+04, -3.680000e+04,
         1.210000e+04,  2.400000e+03,  6.895000e+06, -1.490000e+04,
         1.760000e+04,  6.915100e+06,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.420000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.285000e+05, -1.462000e+05, -9.910000e+04, -1.029000e+05,
         1.230000e+04,  6.254000e+05,  3.686000e+05,  1.210000e+05,
        -1.462000e+05,  1.173000e+05, -1.462000e+05, -1.290000e+04,
        -5.730000e+04,  6.065000e+05, -1.387000e+05, -2.080000e+04,
        -1.420000e+04, -5.160000e+04,  5.340000e+05,  1.039000e+05,
         1.876000e+05,  1.805000e+05, -3.842000e+05, -2.187000e+05,
         7.060900e+06,  6.440200e+06,  6.774900e+06,  1.155900e+06,
         4.243000e+05,  4.249000e+05,  4.225000e+05,  4.283000e+05,
         6.690000e+05,  4.252000e+05,  4.727200e+06,  4.155800e+06,
         4.265400e+06,  5.800000e+05,  4.394000e+05,  4.646000e+05,
        -9.150000e+04, -1.720000e+05,  4.401000e+05,  4.401000e+05,
         1.557000e+05, -1.275000e+05,  1.831000e+05,  2.811000e+05,
         7.367000e+05,  5.949000e+05, -8.269000e+05,  5.029000e+05,
        -1.257000e+05, -2.417000e+05, -1.721000e+05,  6.191000e+05,
         6.194000e+05,  3.290000e+05,  3.882000e+05,  5.941000e+05,
        -1.394000e+05, -3.133000e+05, -1.365000e+05, -4.510000e+04,
        -4.510000e+04, -4.510000e+04, -4.510000e+04, -3.292000e+05,
         5.786000e+05, -1.590000e+05, -2.985000e+05,  2.260000e+04,
        -2.610000e+05, -3.538000e+05,  4.642000e+05, -4.500000e+04,
        -1.253000e+05, -1.253000e+05, -1.387000e+05, -1.387000e+05,
        -1.387000e+05, -5.655000e+05, -1.273300e+06,  6.823000e+05,
         5.906000e+05, -2.023000e+05, -6.241000e+05, -1.206600e+06,
        -3.388000e+05, -1.332900e+06, -3.388000e+05, -1.334700e+06,
         9.138000e+05,  2.669300e+06,  3.293000e+06,  2.098600e+06,
         4.033000e+05,  2.616000e+05, -1.881600e+06,  7.419200e+06,
         6.703700e+06,  6.628200e+06,  4.499000e+05,  8.880000e+05,
         7.363000e+06,  6.860900e+06,  7.016700e+06,  8.161800e+06,
         2.966000e+05,  8.414000e+05,  1.466800e+06,  2.160000e+05,
         1.321000e+05,  2.642000e+05,  9.896000e+05,  7.059000e+05,
        -1.238000e+05, -2.479000e+05, -6.699000e+05,  3.818000e+05,
        -1.259000e+05, -6.764000e+05, -2.929000e+05,  2.410000e+05,
         1.388000e+05, -1.456000e+05,  1.146000e+05,  1.146000e+05,
        -3.101000e+05,  2.755900e+06,  3.465100e+06,  1.341700e+06,
        -1.567000e+05, -1.568000e+05,  6.801000e+06,  6.805500e+06,
         2.795000e+05,  6.805800e+06,  1.336980e+07,  6.805500e+06,
        -1.829000e+05, -1.829000e+05, -1.829000e+05, -1.838000e+05,
        -1.782000e+05,  1.844000e+05,  1.842000e+05,  1.843000e+05,
         1.106000e+06,  7.167000e+06,  6.986200e+06,  8.735000e+05,
        -8.540000e+04, -8.440000e+04, -6.326000e+05, -6.322000e+05,
         2.630000e+04,  3.930000e+04,  4.900000e+03,  1.080000e+05,
         9.400000e+03,  7.800000e+03,  6.065000e+05, -1.290000e+04,
         3.240000e+04, -1.510000e+05,  0.000000e+00, -1.000000e+02,
         3.910000e+04,  1.474000e+05,  2.040000e+04,  4.100000e+04,
         0.000000e+00,  0.000000e+00,  7.530000e+05,  6.216000e+05,
         4.810000e+04,  5.990000e+04,  1.970000e+04,  0.000000e+00,
         1.116000e+05,  3.039000e+05,  1.640000e+04,  3.500000e+04,
         3.500000e+04,  1.413000e+05,  1.350000e+04,  1.280000e+04,
         1.751000e+05,  4.830000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         3.000000e+02, -1.300000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.080000e+05,  3.930000e+04,
         7.960000e+04, -1.829000e+05,  3.000000e+02,  1.285000e+05,
        -1.462000e+05, -1.387000e+05, -4.510000e+04, -1.590000e+05,
         4.280000e+05,  2.795000e+05,  6.805500e+06, -1.568000e+05,
         1.843000e+05,  6.986200e+06,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.829000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 4.147000e+05, -1.130000e+04,  2.610000e+04, -6.380000e+04,
         1.745000e+05,  1.817700e+06,  9.885000e+05,  4.036000e+05,
        -1.130000e+04,  3.988000e+05, -1.130000e+04,  2.163000e+05,
         4.400000e+03, -2.200000e+04, -3.980000e+04,  2.064000e+05,
        -2.000000e+02,  8.652000e+05,  5.521000e+05, -6.690000e+04,
        -3.210000e+04, -1.465000e+05, -1.171000e+05,  3.541000e+05,
         1.478000e+05,  3.644000e+05, -2.630000e+05, -4.603000e+05,
        -3.760000e+04, -3.740000e+04, -3.780000e+04, -3.900000e+04,
        -3.590000e+04, -3.720000e+04,  5.181000e+05, -3.119000e+05,
        -2.609000e+05,  1.751000e+05, -3.620000e+04, -1.970000e+04,
         1.104000e+05, -1.527000e+05, -1.349000e+05, -1.349000e+05,
        -1.201000e+05, -1.055000e+05, -1.082000e+05, -8.030000e+04,
        -4.370000e+04, -2.528000e+05, -1.784000e+05, -8.810000e+04,
         1.343000e+05, -1.037000e+05, -1.532000e+05,  2.905000e+05,
         2.908000e+05, -1.200000e+05, -9.900000e+04,  1.310200e+06,
        -4.050000e+04, -5.580000e+04, -8.200000e+03,  3.844000e+05,
         3.844000e+05,  3.844000e+05,  3.844000e+05, -2.660000e+04,
         1.676000e+05,  1.591000e+05, -5.110000e+04,  2.428300e+06,
         2.457700e+06,  2.332600e+06, -6.350000e+04, -5.930000e+04,
         4.200000e+03,  4.200000e+03, -3.980000e+04, -3.980000e+04,
        -3.980000e+04,  8.755000e+05, -1.570000e+05,  4.322000e+05,
         3.040500e+06,  5.415900e+06,  4.856900e+06,  4.856500e+06,
         1.326600e+06, -1.119000e+05,  1.326600e+06, -1.082000e+05,
         8.924000e+05,  7.182000e+05,  5.025000e+05, -1.036000e+05,
         1.542000e+05, -5.510000e+04, -1.528000e+05, -1.356000e+05,
         7.800000e+04, -1.284000e+05,  2.412400e+06, -1.028000e+05,
         5.103000e+05, -1.076000e+05, -7.390000e+04,  2.966000e+05,
         3.499500e+06,  9.901000e+05,  7.711000e+05,  1.209200e+06,
        -5.540000e+04,  1.630000e+04,  3.238000e+05, -9.440000e+04,
        -8.200000e+04,  5.567000e+05, -7.710000e+04,  3.440000e+05,
        -8.340000e+04, -5.490000e+04,  5.466000e+05, -5.090000e+04,
        -1.215000e+05, -1.067000e+05,  6.164000e+05,  6.164000e+05,
        -2.410000e+04, -1.650000e+05,  8.805000e+05,  9.682200e+06,
         2.436400e+06,  2.440600e+06, -1.132000e+05, -1.132000e+05,
        -8.180000e+04, -1.130000e+05, -1.737000e+05, -1.132000e+05,
        -1.530000e+04, -1.530000e+04, -1.530000e+04, -1.540000e+04,
        -1.010000e+04,  2.320600e+06,  2.318900e+06,  2.319300e+06,
         1.392110e+07, -6.590000e+04, -8.940000e+04, -2.701000e+05,
        -1.116000e+05, -1.107000e+05, -1.560000e+05, -1.558000e+05,
         2.452100e+06, -1.720000e+04,  2.000000e+03,  1.533000e+05,
        -3.000000e+02, -5.200000e+03, -2.200000e+04,  2.163000e+05,
         2.900000e+03, -2.225000e+05,  0.000000e+00,  0.000000e+00,
         1.140000e+04,  2.024000e+05,  2.500000e+03,  2.500000e+03,
         0.000000e+00,  0.000000e+00,  1.913000e+05, -2.180000e+04,
         3.600000e+03,  6.990000e+04,  2.400000e+03,  0.000000e+00,
         1.590000e+05, -1.050000e+04,  1.600000e+03, -2.470000e+04,
        -2.470000e+04,  1.997000e+05, -8.000000e+02,  3.000000e+03,
         1.746000e+05, -2.560000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         3.000000e+02, -7.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02,  1.533000e+05, -1.720000e+04,
        -2.900000e+03, -1.530000e+04,  3.000000e+02,  4.147000e+05,
        -1.130000e+04, -3.980000e+04,  3.844000e+05,  1.591000e+05,
        -3.880000e+04, -8.180000e+04, -1.132000e+05,  2.440600e+06,
         2.319400e+06, -8.940000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.530000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 6.713000e+05, -1.270000e+04,  5.330000e+04, -1.513000e+05,
         2.585000e+05,  2.935000e+06,  1.592700e+06,  6.552000e+05,
        -1.270000e+04,  6.477000e+05, -1.270000e+04,  3.607000e+05,
         1.190000e+04,  3.389000e+05, -7.750000e+04,  3.447000e+05,
         8.000000e+02,  1.442900e+06,  1.346700e+06,  3.082000e+05,
         4.159000e+05,  1.032000e+05, -2.384000e+05,  6.682000e+05,
         1.135400e+06,  1.128000e+06,  4.431000e+05,  1.068800e+06,
         3.317000e+05,  3.319000e+05,  3.325000e+05,  3.339000e+05,
         4.211000e+05,  3.333000e+05,  4.382600e+06,  2.986500e+06,
         3.141600e+06,  6.947000e+05,  3.307000e+05,  3.844000e+05,
         1.062000e+05, -3.786000e+05,  3.446000e+05,  3.446000e+05,
         1.728000e+05,  1.700000e+03,  2.081000e+05,  2.562000e+05,
         8.829000e+05,  5.268000e+05, -3.322000e+05,  1.874000e+05,
         1.809000e+05, -2.290000e+05, -3.786000e+05,  1.338700e+06,
         1.340100e+06,  6.390000e+05,  7.182000e+05,  2.097500e+06,
        -7.440000e+04, -8.100000e+04,  6.000000e+02,  6.698000e+05,
         6.698000e+05,  6.697000e+05,  6.698000e+05, -1.910000e+04,
         6.779000e+05,  2.573000e+05, -8.570000e+04, -1.520000e+04,
        -1.866000e+05, -3.549000e+05,  2.602000e+05,  1.194000e+05,
         1.980000e+04,  1.980000e+04, -7.750000e+04, -7.740000e+04,
        -7.750000e+04,  1.514700e+06, -2.051000e+05,  1.525300e+06,
         1.507100e+06,  9.697000e+05, -6.190000e+04, -4.085000e+05,
         2.339100e+06, -7.190000e+04,  2.339100e+06, -7.190000e+04,
         2.374800e+06,  2.714100e+06,  2.721500e+06,  1.331700e+06,
         6.715000e+05,  3.145000e+05, -1.281000e+05,  1.540000e+05,
         1.513000e+05, -1.944000e+05,  3.191000e+05,  5.932000e+05,
         8.385000e+05, -1.944000e+05, -9.220000e+04,  8.414000e+05,
         9.901000e+05,  2.119800e+06,  2.098300e+06,  2.141300e+06,
         3.393000e+05,  5.685000e+05,  1.349300e+06,  6.371000e+05,
         3.104000e+05,  9.999000e+05, -9.190000e+04,  1.003300e+06,
         3.148000e+05, -3.370000e+04,  9.279000e+05,  3.227000e+05,
         1.764000e+05,  4.600000e+03,  1.016100e+06,  1.016100e+06,
        -1.950000e+04,  1.108000e+05,  1.891400e+06,  1.612800e+07,
        -2.050000e+04, -2.050000e+04, -1.859000e+05, -1.861000e+05,
         2.531000e+05, -1.847000e+05, -6.977000e+05, -1.861000e+05,
        -6.400000e+03, -6.400000e+03, -6.400000e+03, -6.300000e+03,
         2.500000e+03, -1.680000e+04, -1.680000e+04, -1.680000e+04,
        -1.009000e+05, -1.788000e+05, -1.825000e+05,  6.846000e+05,
         2.432000e+05,  2.461000e+05,  2.297000e+05,  2.311000e+05,
        -1.270000e+04, -6.010000e+04,  4.100000e+03,  2.409000e+05,
        -4.500000e+03, -9.700000e+03,  3.389000e+05,  3.607000e+05,
        -6.300000e+03, -3.364000e+05,  0.000000e+00,  1.000000e+02,
         2.930000e+04,  3.196000e+05,  2.000000e+02, -2.000000e+02,
         0.000000e+00,  0.000000e+00,  6.794000e+05,  3.351000e+05,
        -1.000000e+04,  1.072000e+05,  2.000000e+02,  0.000000e+00,
         2.499000e+05,  1.683000e+05, -2.400000e+03, -7.460000e+04,
        -7.460000e+04,  3.147000e+05, -5.800000e+03,  3.800000e+03,
         2.364000e+05, -8.100000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.400000e+03, -8.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.409000e+05, -6.010000e+04,
         4.450000e+04, -6.400000e+03,  1.400000e+03,  6.713000e+05,
        -1.270000e+04, -7.740000e+04,  6.698000e+05,  2.573000e+05,
         3.339000e+05,  2.531000e+05, -1.861000e+05, -2.050000e+04,
        -1.680000e+04, -1.825000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -6.400000e+03,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 4.711000e+05, -1.116000e+05, -3.830000e+04, -2.006000e+05,
         1.342000e+05,  2.105400e+06,  1.163400e+06,  4.570000e+05,
        -1.115000e+05,  4.503000e+05, -1.115000e+05,  1.967000e+05,
        -3.340000e+04,  9.005000e+05, -1.627000e+05,  1.824000e+05,
        -9.400000e+03,  7.866000e+05,  1.428000e+06,  5.318000e+05,
         6.583000e+05,  4.027000e+05, -4.738000e+05,  2.244000e+05,
         1.348700e+06,  6.168000e+05,  7.573000e+05,  2.546000e+06,
         7.711000e+05,  7.715000e+05,  7.725000e+05,  7.708000e+05,
         1.061000e+06,  7.730000e+05,  8.364700e+06,  7.162300e+06,
         7.338500e+06,  1.090400e+06,  7.789000e+05,  8.339000e+05,
        -6.720000e+04, -4.418000e+05,  8.895000e+05,  8.895000e+05,
         4.484000e+05,  9.300000e+03,  4.886000e+05,  6.082000e+05,
         1.649300e+06,  1.343400e+06, -8.617000e+05,  6.953000e+05,
        -2.870000e+04, -3.636000e+05, -4.428000e+05,  1.772500e+06,
         1.773900e+06,  1.172500e+06,  1.259400e+06,  1.610000e+06,
        -1.578000e+05, -2.876000e+05, -9.280000e+04,  3.477000e+05,
         3.477000e+05,  3.477000e+05,  3.477000e+05, -2.397000e+05,
         1.082500e+06,  1.080000e+04, -2.815000e+05,  3.600000e+03,
        -4.366000e+05, -6.017000e+05,  7.342000e+05,  1.727000e+05,
        -7.450000e+04, -7.450000e+04, -1.627000e+05, -1.627000e+05,
        -1.627000e+05,  4.171000e+05, -1.049100e+06,  1.880300e+06,
         1.510000e+06,  4.034000e+05, -4.741000e+05, -1.366100e+06,
         1.091200e+06, -9.647000e+05,  1.091200e+06, -9.655000e+05,
         2.566500e+06,  4.578600e+06,  5.312500e+06,  3.398300e+06,
         9.500000e+05,  6.436000e+05, -1.392300e+06,  7.365000e+05,
         1.210000e+04, -2.859000e+05,  7.786000e+05,  1.506500e+06,
         7.422000e+05, -1.396000e+05, -2.750000e+04,  1.466800e+06,
         7.711000e+05,  2.098300e+06,  3.344700e+06,  8.518000e+05,
         5.690000e+05,  8.155000e+05,  2.028200e+06,  1.416500e+06,
         3.834000e+05,  3.960000e+05, -5.384000e+05,  1.121500e+06,
         3.895000e+05, -4.862000e+05,  3.352000e+05,  6.375000e+05,
         4.411000e+05,  1.000000e+02,  6.580000e+05,  6.580000e+05,
        -2.285000e+05, -1.968000e+05,  1.332500e+06,  1.010930e+07,
        -1.219000e+05, -1.221000e+05, -1.646000e+05, -1.647000e+05,
         6.046000e+05, -1.632000e+05, -9.729000e+05, -1.647000e+05,
        -1.281000e+05, -1.281000e+05, -1.281000e+05, -1.281000e+05,
        -1.203000e+05,  1.142000e+05,  1.141000e+05,  1.142000e+05,
         6.852000e+05,  8.620000e+04, -3.930000e+04,  1.774300e+06,
         3.515000e+05,  3.546000e+05, -2.690000e+04, -2.540000e+04,
         7.500000e+03, -2.780000e+04,  7.300000e+03,  2.130000e+05,
         2.600000e+03, -1.000000e+02,  9.005000e+05,  1.967000e+05,
         1.460000e+04, -2.972000e+05,  0.000000e+00,  0.000000e+00,
         4.420000e+04,  2.860000e+05,  1.240000e+04,  2.790000e+04,
         0.000000e+00,  0.000000e+00,  1.210500e+06,  9.057000e+05,
         2.060000e+04,  1.007000e+05,  1.200000e+04,  0.000000e+00,
         2.211000e+05,  4.485000e+05,  8.000000e+03, -3.940000e+04,
        -3.950000e+04,  2.775000e+05,  3.700000e+03,  1.090000e+04,
         2.347000e+05, -3.630000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.500000e+03, -1.100000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.130000e+05, -2.780000e+04,
         1.182000e+05, -1.281000e+05,  1.500000e+03,  4.711000e+05,
        -1.116000e+05, -1.627000e+05,  3.477000e+05,  1.080000e+04,
         7.710000e+05,  6.046000e+05, -1.647000e+05, -1.221000e+05,
         1.142000e+05, -3.930000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.281000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 8.715000e+05,  8.610000e+04,  1.448000e+05, -1.021000e+05,
         3.829000e+05,  3.764600e+06,  2.021900e+06,  8.535000e+05,
         8.610000e+04,  8.451000e+05,  8.610000e+04,  5.248000e+05,
         5.730000e+04, -2.226000e+05,  7.800000e+03,  5.069000e+05,
         1.100000e+04,  2.099100e+06,  1.265400e+06,  8.460000e+04,
         1.735000e+05, -1.963000e+05, -3.000000e+03,  1.112100e+06,
         9.220000e+05,  1.639300e+06,  1.288000e+05, -4.084000e+05,
        -1.078000e+05, -1.077000e+05, -1.074000e+05, -1.029000e+05,
        -2.187000e+05, -1.064000e+05,  4.005000e+05, -1.189300e+06,
        -1.055300e+06,  2.989000e+05, -1.175000e+05, -6.510000e+04,
         2.796000e+05, -3.153000e+05, -2.003000e+05, -2.003000e+05,
        -1.029000e+05, -6.000000e+03, -7.240000e+04, -9.580000e+04,
         1.164000e+05, -2.899000e+05,  1.974000e+05, -3.205000e+05,
         3.905000e+05, -9.440000e+04, -3.143000e+05,  9.050000e+05,
         9.063000e+05,  1.055000e+05,  1.771000e+05,  2.585100e+06,
         9.100000e+03,  1.255000e+05,  9.410000e+04,  9.918000e+05,
         9.918000e+05,  9.917000e+05,  9.918000e+05,  2.014000e+05,
         2.733000e+05,  5.038000e+05,  1.100000e+05, -3.390000e+04,
         6.340000e+04, -1.081000e+05, -2.137000e+05,  6.610000e+04,
         1.141000e+05,  1.141000e+05,  7.800000e+03,  7.800000e+03,
         7.800000e+03,  2.612300e+06,  6.389000e+05,  1.170200e+06,
         1.504200e+06,  1.535900e+06,  3.502000e+05,  5.491000e+05,
         3.587100e+06,  8.209000e+05,  3.587100e+06,  8.218000e+05,
         2.183100e+06,  8.496000e+05,  1.305000e+05, -7.350000e+05,
         3.929000e+05, -1.450000e+04,  1.136200e+06, -4.285000e+05,
         2.904000e+05, -1.029000e+05, -1.405000e+05, -3.201000e+05,
         9.348000e+05, -2.492000e+05, -1.570000e+05,  2.160000e+05,
         1.209200e+06,  2.141300e+06,  8.518000e+05,  4.487400e+06,
         1.095000e+05,  3.216000e+05,  6.705000e+05, -1.423000e+05,
         2.373000e+05,  1.603800e+06,  3.545000e+05,  8.850000e+05,
         2.400000e+05,  4.189000e+05,  1.520500e+06,  8.000000e+03,
        -8.840000e+04,  9.100000e+03,  1.374200e+06,  1.374200e+06,
         1.895000e+05,  4.185000e+05,  2.450300e+06,  2.214670e+07,
         8.100000e+04,  8.110000e+04, -2.073000e+05, -2.074000e+05,
        -9.840000e+04, -2.061000e+05, -4.225000e+05, -2.074000e+05,
         1.154000e+05,  1.154000e+05,  1.154000e+05,  1.154000e+05,
         1.253000e+05, -1.479000e+05, -1.478000e+05, -1.478000e+05,
        -8.870000e+05, -4.437000e+05, -3.256000e+05, -4.050000e+05,
         1.349000e+05,  1.376000e+05,  4.863000e+05,  4.876000e+05,
        -3.290000e+04, -9.250000e+04,  8.000000e+02,  2.689000e+05,
        -1.150000e+04, -1.920000e+04, -2.226000e+05,  5.248000e+05,
        -2.710000e+04, -3.756000e+05,  0.000000e+00,  1.000000e+02,
         1.440000e+04,  3.532000e+05, -1.190000e+04, -2.830000e+04,
         0.000000e+00,  0.000000e+00,  1.483000e+05, -2.356000e+05,
        -4.060000e+04,  1.137000e+05, -1.150000e+04,  0.000000e+00,
         2.788000e+05, -1.118000e+05, -1.290000e+04, -1.097000e+05,
        -1.097000e+05,  3.519000e+05, -1.530000e+04, -3.300000e+03,
         2.381000e+05, -1.257000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.300000e+03, -5.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.689000e+05, -9.250000e+04,
        -2.920000e+04,  1.154000e+05,  1.300000e+03,  8.715000e+05,
         8.610000e+04,  7.800000e+03,  9.918000e+05,  5.038000e+05,
        -1.032000e+05, -9.840000e+04, -2.074000e+05,  8.110000e+04,
        -1.478000e+05, -3.256000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.154000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-6.300000e+03,  8.380000e+05,  4.810000e+04, -6.220000e+04,
        -3.400000e+04, -5.320000e+04, -4.070000e+04, -4.500000e+03,
         8.379000e+05, -3.400000e+03,  8.374000e+05,  3.130000e+04,
         1.788000e+05,  2.752000e+05,  4.900000e+03,  3.380000e+04,
         4.150000e+04,  1.254000e+05,  3.700000e+05,  2.061000e+06,
         4.612000e+05,  2.856000e+05,  7.436000e+05,  1.380000e+05,
         1.040300e+06,  8.001000e+05,  1.958900e+06,  1.420600e+06,
         3.530000e+05,  3.524000e+05,  3.565000e+05,  3.545000e+05,
         3.836000e+05,  3.540000e+05,  2.878000e+06,  5.271500e+06,
         2.999600e+06,  2.566000e+05,  1.050500e+06,  2.870000e+05,
        -9.620000e+04, -1.913000e+05,  4.960000e+05,  4.962000e+05,
         6.983000e+05,  9.182000e+05,  3.449000e+05,  3.580000e+05,
         8.254000e+05,  2.542100e+06,  3.552600e+06,  2.068000e+05,
        -2.900000e+04, -5.740000e+04, -1.910000e+05,  8.633000e+05,
         8.648000e+05,  1.927100e+06,  9.241000e+05, -9.740000e+04,
        -6.280000e+04,  7.690000e+04,  5.870000e+04,  6.590000e+04,
         6.590000e+04,  6.590000e+04,  6.590000e+04,  9.165000e+05,
         3.083000e+05,  3.790000e+04,  4.613000e+05, -1.600000e+04,
         1.782000e+05, -1.333000e+05,  2.785000e+05,  2.528000e+05,
         5.620000e+04,  5.620000e+04,  4.900000e+03,  5.000000e+03,
         4.900000e+03,  2.540000e+05,  2.377300e+06,  7.348000e+05,
         2.619000e+05,  1.472000e+05,  1.419100e+06,  2.070200e+06,
         3.115000e+05,  3.288800e+06,  3.115000e+05,  3.287700e+06,
         8.279000e+05,  1.090100e+06,  1.333300e+06,  2.883700e+06,
         3.896000e+05,  2.007600e+06,  7.745800e+06,  3.014000e+05,
         5.960000e+04,  6.230000e+05,  3.372000e+05,  6.309000e+05,
        -1.097000e+05,  1.220900e+06, -1.850000e+04,  1.321000e+05,
        -5.540000e+04,  3.393000e+05,  5.690000e+05,  1.095000e+05,
         8.922500e+06,  4.912000e+05,  7.008000e+05,  4.134100e+06,
         5.952000e+05,  1.794000e+05,  2.561100e+06,  4.202000e+05,
         5.932000e+05,  1.454700e+06, -1.650000e+04,  4.376000e+05,
         3.609000e+05,  5.630000e+05,  2.770000e+04,  2.770000e+04,
         1.299300e+06,  2.973200e+06, -5.610000e+06,  6.347000e+05,
         6.070000e+04,  6.070000e+04,  2.430000e+04,  2.430000e+04,
         3.543000e+05,  2.590000e+04, -3.821000e+05,  2.430000e+04,
         7.850000e+04,  7.850000e+04,  7.850000e+04,  7.840000e+04,
         7.700000e+04, -8.470000e+04, -8.460000e+04, -8.460000e+04,
        -5.080000e+05, -1.254000e+05, -5.050000e+04,  9.960000e+05,
         5.145000e+05,  5.178000e+05,  7.563000e+05,  7.578000e+05,
        -1.620000e+04, -6.510000e+04, -6.780000e+04, -2.880000e+04,
         2.231000e+05, -3.700000e+03,  2.752000e+05,  3.130000e+04,
         6.586000e+05,  3.920000e+04,  0.000000e+00, -3.000000e+03,
        -7.540000e+04, -1.053000e+05,  4.402000e+05, -1.770000e+04,
         0.000000e+00,  0.000000e+00,  2.345000e+05,  7.938000e+05,
         1.124800e+06,  2.269000e+05,  4.254000e+05,  0.000000e+00,
        -2.810000e+04,  1.418000e+05,  3.294000e+05, -6.680000e+04,
        -6.680000e+04, -3.680000e+04,  4.536000e+05, -4.800000e+03,
        -1.029000e+05,  3.865000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.500000e+03,  7.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -2.880000e+04, -6.510000e+04,
         3.610000e+04,  7.850000e+04,  1.500000e+03, -6.300000e+03,
         8.380000e+05,  5.000000e+03,  6.590000e+04,  3.790000e+04,
         3.544000e+05,  3.543000e+05,  2.430000e+04,  6.070000e+04,
        -8.460000e+04, -5.050000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  7.850000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 4.250000e+04,  3.960000e+04,  2.349700e+06, -4.860000e+04,
        -3.400000e+03,  1.327000e+05,  4.790000e+04,  3.700000e+04,
         3.960000e+04,  3.430000e+04,  3.960000e+04,  5.920000e+04,
         2.440000e+04,  3.212000e+05,  2.800000e+03,  5.330000e+04,
         4.900000e+03,  2.366000e+05,  4.841000e+05,  4.669000e+05,
         1.418020e+07,  3.245000e+05, -4.200000e+03,  1.671000e+05,
         1.030800e+06,  7.563000e+05,  1.016700e+06,  1.734300e+06,
         3.750000e+05,  3.754000e+05,  3.768000e+05,  3.769000e+05,
         4.294000e+05,  3.769000e+05,  3.309800e+06,  3.278100e+06,
         3.394770e+07,  3.947000e+05,  3.716000e+05,  8.054200e+06,
        -5.250000e+04, -1.583000e+05,  5.389000e+05,  5.389000e+05,
         3.726000e+05,  2.077000e+05,  4.943800e+06,  3.798000e+05,
         9.369000e+05,  9.214000e+05,  9.020000e+04,  2.686000e+05,
        -3.000000e+02, -4.590000e+04, -1.670000e+05,  9.269000e+05,
         9.284000e+05,  9.050000e+05,  1.624580e+07, -2.470000e+04,
        -1.124000e+05,  5.700000e+04,  4.330000e+04,  1.048000e+05,
         1.048000e+05,  1.048000e+05,  1.048000e+05,  9.430000e+04,
         3.812000e+05,  5.260000e+04,  4.970000e+04, -1.090000e+04,
        -1.770000e+05, -1.718000e+05,  3.222000e+05,  2.424000e+05,
         1.084900e+06,  1.085000e+06,  2.800000e+03,  2.800000e+03,
         2.800000e+03,  3.203000e+05,  2.969000e+05,  8.682000e+05,
         3.987000e+05,  1.941000e+05,  1.774000e+05, -1.530000e+05,
         4.249000e+05,  3.880000e+05,  4.249000e+05,  3.860000e+05,
         1.001400e+06,  1.403700e+06,  1.679000e+06,  1.377700e+06,
         4.334000e+05,  4.172000e+05,  5.368000e+05,  3.233000e+05,
         5.640000e+04,  5.120000e+04,  3.667000e+05,  6.990000e+05,
        -2.900000e+03, -1.960000e+04,  2.297560e+07,  2.642000e+05,
         1.630000e+04,  5.685000e+05,  8.155000e+05,  3.216000e+05,
         4.912000e+05,  6.188860e+07,  8.123000e+05,  7.814000e+05,
         5.341000e+05,  2.159000e+05,  1.465000e+05,  4.834000e+05,
         5.421000e+05,  1.975000e+05,  1.776000e+05,  4.241000e+05,
         3.793000e+05,  2.131000e+05,  1.034000e+05,  1.033000e+05,
         8.990000e+04,  5.720000e+05,  6.493000e+05,  1.677900e+06,
         4.450000e+04,  4.460000e+04,  6.000000e+02,  6.000000e+02,
         3.764000e+05,  2.200000e+03, -4.287000e+05,  6.000000e+02,
         5.460000e+04,  5.460000e+04,  5.460000e+04,  5.460000e+04,
         5.790000e+04, -7.180000e+04, -7.180000e+04, -7.180000e+04,
        -4.310000e+05, -1.170000e+05, -5.830000e+04,  1.068700e+06,
         4.888000e+05,  4.920000e+05,  6.589000e+05,  6.604000e+05,
        -8.500000e+03, -4.480000e+04, -1.153000e+05, -4.150000e+04,
        -5.400000e+03,  4.860000e+05,  3.212000e+05,  5.920000e+04,
        -1.290000e+04,  9.900000e+03,  0.000000e+00,  1.000000e+02,
         3.606200e+06, -1.284000e+05, -1.225000e+05, -1.300000e+04,
         0.000000e+00,  0.000000e+00,  3.217000e+05,  3.155000e+05,
        -1.920000e+04, -5.800000e+03, -1.184000e+05,  0.000000e+00,
        -3.710000e+04,  1.585000e+05, -5.700000e+03, -6.040000e+04,
        -6.040000e+04, -2.250000e+04, -1.580000e+04,  5.121000e+05,
        -8.400000e+04, -7.650000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.500000e+03, -9.300000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -4.150000e+04, -4.480000e+04,
         4.220000e+04,  5.460000e+04,  1.500000e+03,  4.250000e+04,
         3.960000e+04,  2.800000e+03,  1.048000e+05,  5.260000e+04,
         3.768000e+05,  3.764000e+05,  6.000000e+02,  4.460000e+04,
        -7.180000e+04, -5.830000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  5.460000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 2.222000e+05, -2.640000e+04,  8.900000e+03, -1.522000e+05,
         3.460000e+04,  9.763000e+05,  5.320000e+05,  2.167000e+05,
        -2.640000e+04,  2.140000e+05, -2.640000e+04,  1.138000e+05,
        -2.600000e+03,  7.896000e+05, -8.420000e+04,  1.080000e+05,
        -1.300000e+03,  4.553000e+05,  1.108300e+06,  7.184000e+05,
         7.861000e+05,  5.218000e+05, -2.620000e+05,  2.070000e+05,
         1.637100e+06,  9.577000e+05,  1.379700e+06,  2.927200e+06,
         7.733000e+05,  7.757000e+05,  7.719000e+05,  7.750000e+05,
         9.794000e+05,  7.771000e+05,  7.485600e+06,  6.971600e+06,
         7.055900e+06,  8.954000e+05,  7.659000e+05,  7.880000e+05,
        -1.184000e+05, -3.734000e+05,  9.864000e+05,  9.864000e+05,
         5.910000e+05,  1.978000e+05,  6.106000e+05,  6.857000e+05,
         1.705300e+06,  1.575600e+06, -4.014000e+05,  6.271000e+05,
        -4.900000e+04, -2.366000e+05, -3.727000e+05,  1.736500e+06,
         1.738000e+06,  1.480500e+06,  1.521700e+06,  7.089000e+05,
        -8.560000e+04, -1.005000e+05, -1.100000e+04,  2.146000e+05,
         2.146000e+05,  2.146000e+05,  2.146000e+05, -4.330000e+04,
         8.926000e+05,  2.100000e+04, -1.052000e+05, -7.900000e+03,
        -4.041000e+05, -4.586000e+05,  7.000000e+05,  3.215000e+05,
        -3.900000e+03, -3.900000e+03, -8.420000e+04, -8.420000e+04,
        -8.420000e+04,  3.525000e+05, -2.908000e+05,  1.710200e+06,
         1.042400e+06,  2.972000e+05, -9.130000e+04, -8.950000e+05,
         7.412000e+05, -1.615000e+05,  7.412000e+05, -1.670000e+05,
         2.075000e+06,  3.591100e+06,  4.268800e+06,  3.076100e+06,
         1.062500e+06,  9.328000e+05, -2.824000e+05,  7.238000e+05,
         3.820000e+04, -9.310000e+04,  7.694000e+05,  1.475300e+06,
         3.043000e+05, -8.110000e+04, -1.800000e+04,  9.896000e+05,
         3.238000e+05,  1.349300e+06,  2.028200e+06,  6.705000e+05,
         7.008000e+05,  8.123000e+05,  2.372800e+06,  2.113400e+06,
         7.143000e+05,  3.128000e+05, -7.570000e+04,  9.959000e+05,
         7.228000e+05, -8.040000e+04,  2.748000e+05,  7.454000e+05,
         5.943000e+05,  1.989000e+05,  3.345000e+05,  3.345000e+05,
        -4.510000e+04,  4.288000e+05,  1.077300e+06,  5.294500e+06,
        -2.240000e+04, -2.230000e+04, -6.750000e+04, -6.750000e+04,
         6.810000e+05, -6.610000e+04, -8.939000e+05, -6.750000e+04,
        -1.690000e+04, -1.690000e+04, -1.690000e+04, -1.680000e+04,
        -1.210000e+04, -2.700000e+03, -2.700000e+03, -2.700000e+03,
        -1.620000e+04, -4.430000e+04, -5.600000e+04,  1.975100e+06,
         6.506000e+05,  6.541000e+05,  6.062000e+05,  6.077000e+05,
        -4.000000e+03, -6.030000e+04,  5.500000e+03,  8.370000e+04,
        -4.200000e+03, -2.700000e+03,  7.896000e+05,  1.138000e+05,
        -7.900000e+03, -1.149000e+05,  0.000000e+00,  1.000000e+02,
         1.750000e+04,  1.169000e+05, -9.000000e+02,  3.300000e+03,
         0.000000e+00,  0.000000e+00,  9.013000e+05,  7.826000e+05,
        -1.470000e+04,  3.540000e+04, -9.000000e+02,  0.000000e+00,
         8.760000e+04,  3.918000e+05, -3.200000e+03, -6.790000e+04,
        -6.790000e+04,  1.114000e+05, -7.000000e+03,  2.400000e+03,
         4.160000e+04, -7.520000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.400000e+03,  1.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  8.370000e+04, -6.030000e+04,
         1.036000e+05, -1.690000e+04,  1.400000e+03,  2.222000e+05,
        -2.640000e+04, -8.420000e+04,  2.146000e+05,  2.100000e+04,
         7.749000e+05,  6.810000e+05, -6.750000e+04, -2.230000e+04,
        -2.700000e+03, -5.600000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.690000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-4.880000e+04,  3.139000e+05,  6.800000e+03, -1.165000e+05,
        -8.240000e+04, -2.190000e+05, -1.213000e+05, -4.720000e+04,
         3.139000e+05, -4.640000e+04,  3.137000e+05, -1.790000e+04,
         6.420000e+04,  7.641000e+05, -5.130000e+04, -1.630000e+04,
         1.500000e+04, -7.170000e+04,  7.176000e+05,  1.419600e+06,
         8.042000e+05,  5.948000e+05,  1.308000e+05, -5.100000e+03,
         1.599000e+06,  8.265000e+05,  1.986100e+06,  3.068000e+06,
         7.819000e+05,  7.839000e+05,  7.815000e+05,  7.832000e+05,
         9.644000e+05,  7.854000e+05,  6.883700e+06,  7.885500e+06,
         6.999100e+06,  7.202000e+05,  1.053900e+06,  7.491000e+05,
        -1.994000e+05, -2.985000e+05,  1.046900e+06,  1.047000e+06,
         8.012000e+05,  5.644000e+05,  6.654000e+05,  7.264000e+05,
         1.682300e+06,  2.381700e+06,  1.152600e+06,  6.349000e+05,
        -1.330000e+05, -1.679000e+05, -2.977000e+05,  1.546400e+06,
         1.547900e+06,  1.995700e+06,  1.604100e+06, -1.691000e+05,
        -8.100000e+04, -3.740000e+04,  1.230000e+04, -2.700000e+04,
        -2.700000e+04, -2.700000e+04, -2.700000e+04,  3.310000e+05,
         7.447000e+05, -6.680000e+04,  1.137000e+05, -8.200000e+03,
        -2.582000e+05, -3.699000e+05,  7.073000e+05,  3.748000e+05,
         1.070000e+04,  1.070000e+04, -5.130000e+04, -5.120000e+04,
        -5.130000e+04, -1.517000e+05,  7.422000e+05,  1.394000e+06,
         5.443000e+05, -3.180000e+04,  5.011000e+05,  9.650000e+04,
        -6.990000e+04,  1.182800e+06, -6.990000e+04,  1.176800e+06,
         1.456300e+06,  2.941500e+06,  3.713500e+06,  3.696900e+06,
         9.498000e+05,  1.610100e+06,  2.867200e+06,  7.827000e+05,
         1.600000e+03,  2.339000e+05,  7.766000e+05,  1.490400e+06,
        -7.500000e+04,  4.850000e+05,  1.160000e+04,  7.059000e+05,
        -9.440000e+04,  6.371000e+05,  1.416500e+06, -1.423000e+05,
         4.134100e+06,  7.814000e+05,  2.113400e+06,  3.755700e+06,
         8.282000e+05, -1.540000e+04,  9.855000e+05,  7.627000e+05,
         8.342000e+05,  5.149000e+05, -1.030000e+05,  7.913000e+05,
         6.681000e+05,  4.223000e+05, -6.090000e+04, -6.090000e+04,
         4.824000e+05,  1.573700e+06, -1.923300e+06, -9.028000e+05,
         1.010000e+04,  1.010000e+04,  1.660000e+04,  1.660000e+04,
         7.214000e+05,  1.810000e+04, -7.677000e+05,  1.660000e+04,
         1.700000e+04,  1.700000e+04,  1.700000e+04,  1.710000e+04,
         1.770000e+04, -2.990000e+04, -2.980000e+04, -2.980000e+04,
        -1.791000e+05, -2.300000e+04, -3.200000e+03,  2.099700e+06,
         7.591000e+05,  7.628000e+05,  8.169000e+05,  8.184000e+05,
        -5.400000e+03, -6.230000e+04, -2.320000e+04, -2.420000e+04,
         8.680000e+04, -3.000000e+02,  7.641000e+05, -1.790000e+04,
         2.580000e+05,  3.540000e+04,  0.000000e+00, -1.200000e+03,
        -2.440000e+04, -5.310000e+04,  1.751000e+05, -3.700000e+03,
         0.000000e+00,  0.000000e+00,  7.233000e+05,  9.661000e+05,
         4.392000e+05,  8.330000e+04,  1.692000e+05,  0.000000e+00,
        -2.360000e+04,  3.812000e+05,  1.295000e+05, -6.480000e+04,
        -6.480000e+04, -2.920000e+04,  1.768000e+05, -1.000000e+03,
        -9.410000e+04,  1.118000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.500000e+03,  7.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -2.420000e+04, -6.230000e+04,
         1.003000e+05,  1.700000e+04,  1.500000e+03, -4.880000e+04,
         3.139000e+05, -5.120000e+04, -2.700000e+04, -6.680000e+04,
         7.831000e+05,  7.214000e+05,  1.660000e+04,  1.010000e+04,
        -2.980000e+04, -3.200000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.700000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 2.200000e+04,  1.297000e+05,  1.091000e+05, -3.690000e+04,
        -7.200000e+03,  3.270000e+04, -1.130000e+04,  2.570000e+04,
         1.297000e+05,  2.760000e+04,  1.297000e+05,  9.260000e+04,
         5.690000e+04,  1.711000e+05,  6.640000e+04,  9.660000e+04,
         1.360000e+04,  3.703000e+05,  4.632000e+05,  6.326000e+05,
         5.974000e+05,  3.601000e+05,  1.557000e+05,  3.680000e+05,
         1.469900e+06,  1.397000e+06,  1.583200e+06,  1.804100e+06,
         3.493000e+05,  3.489000e+05,  3.486000e+05,  3.480000e+05,
         3.024000e+05,  3.490000e+05,  2.553700e+06,  2.778200e+06,
         2.732700e+06,  2.704000e+05,  3.278000e+05,  3.152000e+05,
        -4.410000e+04, -1.759000e+05,  5.576000e+05,  5.576000e+05,
         4.534000e+05,  3.507000e+05,  4.393000e+05,  4.103000e+05,
         9.536000e+05,  1.010600e+06,  4.899000e+05,  1.218000e+05,
         5.920000e+04,  2.940000e+04, -1.748000e+05,  1.069300e+06,
         1.069500e+06,  1.183300e+06,  1.158800e+06, -1.228000e+05,
         6.430000e+04,  2.361000e+05,  1.341000e+05,  1.950000e+05,
         1.950000e+05,  1.950000e+05,  1.950000e+05,  3.079000e+05,
         2.684000e+05,  1.621000e+05,  2.171000e+05, -3.140000e+04,
        -1.390000e+05, -7.840000e+04,  2.340000e+05,  3.802000e+05,
         1.274000e+05,  1.274000e+05,  6.640000e+04,  6.640000e+04,
         6.640000e+04,  7.933000e+05,  1.074400e+06,  9.368000e+05,
         3.216000e+05,  4.056000e+05,  5.726000e+05,  3.635000e+05,
         8.590000e+05,  1.254000e+06,  8.590000e+05,  1.255800e+06,
         1.003500e+06,  7.242000e+05,  7.979000e+05,  9.504000e+05,
         4.462000e+05,  5.032000e+05,  1.720700e+06,  2.146000e+05,
         1.412000e+05,  1.977000e+05,  3.161000e+05,  5.813000e+05,
        -1.971000e+05, -2.860000e+04, -6.290000e+04, -1.238000e+05,
        -8.200000e+04,  3.104000e+05,  3.834000e+05,  2.373000e+05,
         5.952000e+05,  5.341000e+05,  7.143000e+05,  8.282000e+05,
         8.996000e+05,  4.686000e+05,  6.407000e+05,  5.426000e+05,
         8.832000e+05,  6.401000e+05,  4.979000e+05,  5.398000e+05,
         4.741000e+05,  3.700000e+05,  1.130000e+05,  1.130000e+05,
         2.840000e+05,  1.188100e+06,  9.032000e+05,  2.270200e+06,
         1.442000e+05,  1.444000e+05,  4.370000e+04,  4.370000e+04,
         4.095000e+05,  4.390000e+04, -4.395000e+05,  4.370000e+04,
         1.781000e+05,  1.781000e+05,  1.781000e+05,  1.781000e+05,
         1.755000e+05, -1.949000e+05, -1.948000e+05, -1.948000e+05,
        -1.169300e+06, -3.068000e+05, -1.315000e+05,  1.126400e+06,
         7.663000e+05,  7.668000e+05,  1.301600e+06,  1.301800e+06,
        -3.350000e+04, -1.002000e+05,  5.000000e+02, -5.380000e+04,
        -1.340000e+04, -1.000000e+04,  1.711000e+05,  9.260000e+04,
        -4.220000e+04,  7.550000e+04,  0.000000e+00,  1.000000e+02,
        -2.830000e+04, -6.980000e+04, -2.320000e+04, -4.030000e+04,
         0.000000e+00,  0.000000e+00,  9.390000e+04,  1.466000e+05,
        -6.590000e+04, -3.870000e+04, -2.240000e+04,  0.000000e+00,
        -5.520000e+04,  9.210000e+04, -2.100000e+04, -1.021000e+05,
        -1.021000e+05, -6.870000e+04, -2.130000e+04, -1.150000e+04,
        -1.703000e+05, -1.233000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.000000e+02,  1.600000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -5.380000e+04, -1.002000e+05,
         2.250000e+04,  1.781000e+05,  2.000000e+02,  2.200000e+04,
         1.297000e+05,  6.640000e+04,  1.950000e+05,  1.621000e+05,
         3.481000e+05,  4.095000e+05,  4.370000e+04,  1.444000e+05,
        -1.948000e+05, -1.315000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.781000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 4.676000e+05,  1.408000e+05,  1.531000e+05, -3.810000e+04,
         2.139000e+05,  1.973700e+06,  1.038600e+06,  4.614000e+05,
         1.408000e+05,  4.583000e+05,  1.407000e+05,  3.390000e+05,
         7.130000e+04, -2.717000e+05,  7.380000e+04,  3.324000e+05,
         1.560000e+04,  1.356000e+06,  7.245000e+05,  2.265000e+05,
         2.540000e+05, -4.830000e+04,  1.808000e+05,  8.624000e+05,
         9.717000e+05,  1.577200e+06,  6.361000e+05,  1.660000e+04,
        -8.530000e+04, -8.530000e+04, -8.580000e+04, -8.340000e+04,
        -2.457000e+05, -8.510000e+04, -4.658000e+05, -1.129600e+06,
        -1.093000e+06,  5.580000e+04, -1.068000e+05, -1.010000e+05,
         1.750000e+05, -1.879000e+05, -7.160000e+04, -7.160000e+04,
         4.340000e+04,  1.580000e+05,  5.250000e+04, -1.010000e+04,
         1.348000e+05, -2.930000e+04,  5.457000e+05, -3.087000e+05,
         2.879000e+05,  3.560000e+04, -1.861000e+05,  6.770000e+05,
         6.771000e+05,  3.460000e+05,  3.634000e+05,  1.247300e+06,
         7.290000e+04,  2.596000e+05,  1.442000e+05,  6.650000e+05,
         6.650000e+05,  6.650000e+05,  6.650000e+05,  3.272000e+05,
         5.890000e+04,  4.020000e+05,  2.365000e+05, -3.490000e+04,
         8.010000e+04,  3.270000e+04, -1.971000e+05,  1.815000e+05,
         1.499000e+05,  1.499000e+05,  7.380000e+04,  7.380000e+04,
         7.380000e+04,  1.993500e+06,  1.150200e+06,  7.884000e+05,
         7.753000e+05,  1.122500e+06,  6.071000e+05,  8.431000e+05,
         2.521300e+06,  1.338800e+06,  2.521200e+06,  1.331600e+06,
         1.296100e+06, -1.513000e+05, -7.578000e+05, -8.241000e+05,
         2.496000e+05,  8.570000e+04,  1.844500e+06, -3.505000e+05,
         2.539000e+05,  8.740000e+04, -1.202000e+05, -2.820000e+05,
         3.564000e+05, -1.464000e+05, -1.141000e+05, -2.479000e+05,
         5.567000e+05,  9.999000e+05,  3.960000e+05,  1.603800e+06,
         1.794000e+05,  2.159000e+05,  3.128000e+05, -1.540000e+04,
         4.686000e+05,  1.192200e+06,  7.044000e+05,  5.853000e+05,
         4.735000e+05,  6.772000e+05,  1.137000e+06,  9.560000e+04,
         6.390000e+04,  1.789000e+05,  7.960000e+05,  7.960000e+05,
         3.046000e+05,  8.610000e+05,  1.681500e+06,  1.319340e+07,
         1.511000e+05,  1.513000e+05, -7.900000e+04, -7.910000e+04,
        -1.040000e+04, -7.890000e+04, -2.594000e+05, -7.910000e+04,
         1.864000e+05,  1.864000e+05,  1.864000e+05,  1.865000e+05,
         1.904000e+05, -2.206000e+05, -2.204000e+05, -2.205000e+05,
        -1.323400e+06, -4.644000e+05, -2.718000e+05, -1.419000e+05,
         3.626000e+05,  3.629000e+05,  9.223000e+05,  9.225000e+05,
        -3.490000e+04, -1.008000e+05, -1.200000e+03,  1.004000e+05,
        -1.460000e+04, -1.710000e+04, -2.717000e+05,  3.390000e+05,
        -4.080000e+04, -1.351000e+05,  0.000000e+00,  1.000000e+02,
        -9.600000e+03,  1.309000e+05, -2.100000e+04, -4.340000e+04,
         0.000000e+00,  0.000000e+00, -1.351000e+05, -2.922000e+05,
        -6.170000e+04,  3.280000e+04, -2.030000e+04,  0.000000e+00,
         1.034000e+05, -1.380000e+05, -2.030000e+04, -1.107000e+05,
        -1.107000e+05,  1.327000e+05, -2.050000e+04, -1.000000e+04,
         1.940000e+04, -1.316000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.000000e+02,  7.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.004000e+05, -1.008000e+05,
        -3.570000e+04,  1.864000e+05,  1.000000e+02,  4.676000e+05,
         1.408000e+05,  7.380000e+04,  6.650000e+05,  4.020000e+05,
        -8.350000e+04, -1.040000e+04, -7.910000e+04,  1.513000e+05,
        -2.205000e+05, -2.718000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.864000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 6.000000e+04,  6.501000e+05,  1.494000e+05,  1.530000e+04,
         3.780000e+04,  1.760000e+05,  5.600000e+04,  6.470000e+04,
         6.501000e+05,  6.670000e+04,  6.497000e+05,  1.406000e+05,
         1.710000e+05, -3.094000e+05,  1.232000e+05,  1.449000e+05,
         3.990000e+04,  5.623000e+05,  1.440000e+05,  1.275600e+06,
         2.870000e+05,  6.120000e+04,  7.702000e+05,  5.504000e+05,
         9.090000e+05,  1.374700e+06,  1.536500e+06,  2.314000e+05,
        -7.330000e+04, -7.450000e+04, -7.210000e+04, -7.140000e+04,
        -2.680000e+05, -7.430000e+04, -1.373300e+06,  2.989000e+05,
        -1.182500e+06, -2.430000e+05,  4.086000e+05, -1.953000e+05,
         5.280000e+04, -7.560000e+04,  1.810000e+04,  1.820000e+04,
         3.575000e+05,  7.069000e+05,  1.366000e+05,  4.940000e+04,
         9.410000e+04,  6.247000e+05,  2.321200e+06, -2.958000e+05,
         1.614000e+05,  1.385000e+05, -7.350000e+04,  3.876000e+05,
         3.878000e+05,  1.114500e+06,  4.830000e+05, -7.350000e+04,
         7.970000e+04,  3.542000e+05,  1.781000e+05,  3.052000e+05,
         3.052000e+05,  3.051000e+05,  3.052000e+05,  8.862000e+05,
        -1.617000e+05,  2.702000e+05,  5.636000e+05, -3.400000e+04,
         3.005000e+05,  1.676000e+05, -1.858000e+05,  2.594000e+05,
         1.709000e+05,  1.709000e+05,  1.232000e+05,  1.232000e+05,
         1.232000e+05,  1.240800e+06,  2.692700e+06,  3.167000e+05,
         2.330000e+04,  6.362000e+05,  1.494500e+06,  2.329600e+06,
         1.313800e+06,  3.347300e+06,  1.313700e+06,  3.337800e+06,
         3.667000e+05, -1.126500e+06, -1.593200e+06,  9.860000e+04,
         8.020000e+04,  6.237000e+05,  6.556000e+06, -2.627000e+05,
         2.003000e+05,  5.767000e+05, -1.087000e+05, -2.607000e+05,
        -2.073000e+05,  7.021000e+05, -6.430000e+04, -6.699000e+05,
        -7.710000e+04, -9.190000e+04, -5.384000e+05,  3.545000e+05,
         2.561100e+06,  1.465000e+05, -7.570000e+04,  9.855000e+05,
         6.407000e+05,  7.044000e+05,  1.590080e+07,  2.378000e+05,
         6.360000e+05,  1.565400e+06,  5.641000e+05,  1.683000e+05,
         1.735000e+05,  5.128000e+05,  2.022000e+05,  2.023000e+05,
         1.093600e+06,  2.570800e+06, -8.220000e+04,  3.900500e+06,
         2.003000e+05,  2.006000e+05,  4.600000e+04,  4.600000e+04,
         4.910000e+04,  4.620000e+04, -6.960000e+04,  4.600000e+04,
         2.360000e+05,  2.360000e+05,  2.360000e+05,  2.361000e+05,
         2.337000e+05, -2.632000e+05, -2.630000e+05, -2.631000e+05,
        -1.578900e+06, -4.365000e+05, -1.954000e+05,  4.140000e+04,
         5.215000e+05,  5.219000e+05,  1.230400e+06,  1.230600e+06,
        -3.510000e+04, -1.035000e+05, -4.440000e+04, -6.190000e+04,
         1.221000e+05, -1.360000e+04, -3.094000e+05,  1.406000e+05,
         3.583000e+05,  9.260000e+04,  0.000000e+00, -1.700000e+03,
        -7.010000e+04, -1.243000e+05,  2.430000e+05, -5.360000e+04,
         0.000000e+00,  0.000000e+00, -4.033000e+05, -1.570000e+04,
         6.197000e+05,  1.048000e+05,  2.348000e+05,  0.000000e+00,
        -6.390000e+04, -1.505000e+05,  1.789000e+05, -1.059000e+05,
        -1.059000e+05, -7.830000e+04,  2.555000e+05, -1.500000e+04,
        -1.845000e+05,  1.493000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.000000e+02,  1.600000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -6.190000e+04, -1.035000e+05,
        -4.060000e+04,  2.360000e+05,  2.000000e+02,  6.000000e+04,
         6.501000e+05,  1.232000e+05,  3.052000e+05,  2.702000e+05,
        -7.160000e+04,  4.910000e+04,  4.600000e+04,  2.006000e+05,
        -2.631000e+05, -1.954000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.360000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 2.699000e+05,  4.200000e+04,  6.230000e+04, -8.770000e+04,
         9.060000e+04,  1.154500e+06,  6.147000e+05,  2.653000e+05,
         4.200000e+04,  2.630000e+05,  4.200000e+04,  1.765000e+05,
         2.610000e+04,  2.908000e+05, -1.170000e+04,  1.716000e+05,
         5.400000e+03,  7.059000e+05,  8.031000e+05,  4.504000e+05,
         4.912000e+05,  2.488000e+05, -5.550000e+04,  4.160000e+05,
         1.186100e+06,  1.068700e+06,  9.508000e+05,  1.484200e+06,
         3.557000e+05,  3.569000e+05,  3.548000e+05,  3.572000e+05,
         3.965000e+05,  3.571000e+05,  3.531300e+06,  3.064200e+06,
         3.115400e+06,  4.588000e+05,  3.430000e+05,  3.548000e+05,
         2.200000e+03, -2.519000e+05,  4.714000e+05,  4.714000e+05,
         3.176000e+05,  1.648000e+05,  3.297000e+05,  3.416000e+05,
         9.027000e+05,  7.861000e+05,  1.730000e+04,  1.980000e+05,
         7.930000e+04, -9.950000e+04, -2.509000e+05,  1.113400e+06,
         1.113600e+06,  8.807000e+05,  9.055000e+05,  7.658000e+05,
        -1.280000e+04,  5.270000e+04,  5.080000e+04,  3.430000e+05,
         3.430000e+05,  3.430000e+05,  3.430000e+05,  1.066000e+05,
         4.594000e+05,  1.571000e+05,  4.160000e+04, -1.720000e+04,
        -1.715000e+05, -2.112000e+05,  2.767000e+05,  2.338000e+05,
         5.590000e+04,  5.590000e+04, -1.170000e+04, -1.170000e+04,
        -1.170000e+04,  8.975000e+05,  3.077000e+05,  1.133800e+06,
         7.819000e+05,  5.511000e+05,  1.925000e+05, -1.193000e+05,
         1.270500e+06,  4.432000e+05,  1.270500e+06,  4.378000e+05,
         1.487000e+06,  1.696900e+06,  1.813000e+06,  1.225800e+06,
         5.303000e+05,  4.137000e+05,  5.792000e+05,  2.333000e+05,
         1.122000e+05, -6.300000e+03,  3.399000e+05,  6.329000e+05,
         2.609000e+05, -9.150000e+04, -5.110000e+04,  3.818000e+05,
         3.440000e+05,  1.003300e+06,  1.121500e+06,  8.850000e+05,
         4.202000e+05,  4.834000e+05,  9.959000e+05,  7.627000e+05,
         5.426000e+05,  5.853000e+05,  2.378000e+05,  8.422000e+05,
         5.488000e+05,  2.246000e+05,  5.482000e+05,  4.114000e+05,
         3.270000e+05,  1.732000e+05,  4.410000e+05,  4.410000e+05,
         9.570000e+04,  5.535000e+05,  1.136500e+06,  7.209100e+06,
         4.840000e+04,  4.850000e+04, -5.780000e+04, -5.790000e+04,
         3.403000e+05, -5.770000e+04, -5.371000e+05, -5.790000e+04,
         6.460000e+04,  6.460000e+04,  6.460000e+04,  6.450000e+04,
         6.810000e+04, -8.680000e+04, -8.680000e+04, -8.680000e+04,
        -5.208000e+05, -1.965000e+05, -1.273000e+05,  9.454000e+05,
         4.701000e+05,  4.708000e+05,  6.649000e+05,  6.651000e+05,
        -1.590000e+04, -6.830000e+04,  2.300000e+03,  7.250000e+04,
        -7.700000e+03, -7.700000e+03,  2.908000e+05,  1.765000e+05,
        -1.980000e+04, -9.840000e+04,  0.000000e+00,  1.000000e+02,
         3.900000e+03,  9.830000e+04, -8.800000e+03, -1.530000e+04,
         0.000000e+00,  0.000000e+00,  3.881000e+05,  2.793000e+05,
        -3.140000e+04,  2.660000e+04, -8.500000e+03,  0.000000e+00,
         7.480000e+04,  1.428000e+05, -9.800000e+03, -7.550000e+04,
        -7.550000e+04,  9.640000e+04, -1.140000e+04, -2.800000e+03,
         1.910000e+04, -8.720000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.000000e+02,  4.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  7.250000e+04, -6.830000e+04,
         3.820000e+04,  6.460000e+04,  2.000000e+02,  2.699000e+05,
         4.200000e+04, -1.170000e+04,  3.430000e+05,  1.571000e+05,
         3.570000e+05,  3.403000e+05, -5.790000e+04,  4.850000e+04,
        -8.680000e+04, -1.273000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  6.460000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 2.180000e+04,  1.316000e+05,  1.102000e+05, -3.740000e+04,
        -7.500000e+03,  3.140000e+04, -1.230000e+04,  2.570000e+04,
         1.316000e+05,  2.760000e+04,  1.316000e+05,  9.350000e+04,
         5.760000e+04,  1.727000e+05,  6.710000e+04,  9.760000e+04,
         1.380000e+04,  3.739000e+05,  4.695000e+05,  6.423000e+05,
         6.059000e+05,  3.649000e+05,  1.580000e+05,  3.719000e+05,
         1.493100e+06,  1.417200e+06,  1.609300e+06,  1.827900e+06,
         3.526000e+05,  3.532000e+05,  3.569000e+05,  3.519000e+05,
         3.056000e+05,  3.534000e+05,  2.582300e+06,  2.816400e+06,
         2.764100e+06,  2.740000e+05,  3.282000e+05,  3.195000e+05,
        -4.480000e+04, -1.780000e+05,  5.650000e+05,  5.650000e+05,
         4.596000e+05,  3.555000e+05,  4.453000e+05,  4.165000e+05,
         9.664000e+05,  1.022100e+06,  4.951000e+05,  1.231000e+05,
         5.960000e+04,  2.970000e+04, -1.769000e+05,  1.086000e+06,
         1.086200e+06,  1.204600e+06,  1.177000e+06, -1.251000e+05,
         6.550000e+04,  2.388000e+05,  1.357000e+05,  1.969000e+05,
         1.969000e+05,  1.968000e+05,  1.969000e+05,  3.119000e+05,
         2.731000e+05,  1.636000e+05,  2.198000e+05, -3.190000e+04,
        -1.404000e+05, -8.010000e+04,  2.367000e+05,  3.859000e+05,
         1.289000e+05,  1.289000e+05,  6.710000e+04,  6.710000e+04,
         6.710000e+04,  8.012000e+05,  1.087900e+06,  9.491000e+05,
         3.251000e+05,  4.095000e+05,  5.804000e+05,  3.700000e+05,
         8.676000e+05,  1.270400e+06,  8.676000e+05,  1.272200e+06,
         1.024500e+06,  7.380000e+05,  8.145000e+05,  9.697000e+05,
         4.516000e+05,  5.071000e+05,  1.745200e+06,  2.177000e+05,
         1.432000e+05,  2.011000e+05,  3.196000e+05,  5.887000e+05,
        -2.004000e+05, -2.870000e+04, -6.400000e+04, -1.259000e+05,
        -8.340000e+04,  3.148000e+05,  3.895000e+05,  2.400000e+05,
         5.932000e+05,  5.421000e+05,  7.228000e+05,  8.342000e+05,
         8.832000e+05,  4.735000e+05,  6.360000e+05,  5.488000e+05,
         9.834000e+05,  6.484000e+05,  5.027000e+05,  5.200000e+05,
         4.803000e+05,  3.749000e+05,  1.136000e+05,  1.137000e+05,
         2.880000e+05,  1.204400e+06,  9.259000e+05,  2.286500e+06,
         1.461000e+05,  1.463000e+05,  4.440000e+04,  4.450000e+04,
         4.150000e+05,  4.470000e+04, -4.445000e+05,  4.450000e+04,
         1.803000e+05,  1.803000e+05,  1.803000e+05,  1.802000e+05,
         1.778000e+05, -1.975000e+05, -1.974000e+05, -1.974000e+05,
        -1.184900e+06, -3.102000e+05, -1.328000e+05,  1.141800e+06,
         7.764000e+05,  7.772000e+05,  1.318500e+06,  1.318600e+06,
        -3.370000e+04, -1.014000e+05,  6.000000e+02, -5.440000e+04,
        -1.360000e+04, -1.010000e+04,  1.727000e+05,  9.350000e+04,
        -4.240000e+04,  7.660000e+04,  0.000000e+00,  1.000000e+02,
        -2.930000e+04, -7.060000e+04, -2.400000e+04, -4.080000e+04,
         0.000000e+00,  0.000000e+00,  9.640000e+04,  1.501000e+05,
        -6.590000e+04, -3.900000e+04, -2.320000e+04,  0.000000e+00,
        -5.580000e+04,  8.200000e+04, -2.110000e+04, -1.033000e+05,
        -1.033000e+05, -6.970000e+04, -2.110000e+04, -1.160000e+04,
        -1.725000e+05, -1.244000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.000000e+02,  1.600000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -5.440000e+04, -1.014000e+05,
         2.270000e+04,  1.803000e+05,  2.000000e+02,  2.180000e+04,
         1.316000e+05,  6.710000e+04,  1.969000e+05,  1.636000e+05,
         3.520000e+05,  4.150000e+05,  4.450000e+04,  1.463000e+05,
        -1.974000e+05, -1.328000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.803000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 6.310000e+04,  7.346000e+05,  1.500000e+05,  1.480000e+04,
         3.910000e+04,  1.909000e+05,  6.470000e+04,  6.730000e+04,
         7.346000e+05,  6.940000e+04,  7.342000e+05,  1.420000e+05,
         1.877000e+05, -3.062000e+05,  1.220000e+05,  1.468000e+05,
         4.380000e+04,  5.680000e+05,  1.362000e+05,  1.035400e+06,
         2.749000e+05,  5.870000e+04,  7.804000e+05,  5.258000e+05,
         9.243000e+05,  1.377200e+06,  1.583400e+06,  2.049000e+05,
        -6.820000e+04, -6.800000e+04, -6.700000e+04, -6.980000e+04,
        -2.644000e+05, -6.780000e+04, -1.330900e+06, -1.334000e+05,
        -1.146000e+06, -1.557000e+05,  1.403000e+05, -1.095000e+05,
         5.410000e+04, -7.600000e+04,  2.230000e+04,  2.220000e+04,
         3.884000e+05,  7.511000e+05,  1.309000e+05,  5.430000e+04,
         1.096000e+05,  4.073000e+05,  2.238000e+06, -2.986000e+05,
         1.610000e+05,  1.368000e+05, -7.470000e+04,  3.971000e+05,
         3.973000e+05,  1.014100e+06,  4.896000e+05, -5.940000e+04,
         9.010000e+04,  3.512000e+05,  1.799000e+05,  2.945000e+05,
         2.945000e+05,  2.944000e+05,  2.945000e+05,  9.732000e+05,
        -1.573000e+05,  2.676000e+05,  6.050000e+05, -3.780000e+04,
         3.269000e+05,  1.571000e+05, -1.844000e+05,  2.650000e+05,
         1.722000e+05,  1.722000e+05,  1.220000e+05,  1.219000e+05,
         1.220000e+05,  1.213200e+06,  2.908000e+06,  3.085000e+05,
         4.090000e+04,  6.013000e+05,  1.616000e+06,  2.256900e+06,
         1.266700e+06,  3.642400e+06,  1.266700e+06,  3.661100e+06,
         3.626000e+05, -1.096600e+06, -1.548100e+06,  2.342000e+05,
         7.900000e+04,  3.765000e+05,  7.067300e+06, -2.568000e+05,
         1.967000e+05,  4.966000e+05, -1.081000e+05, -2.525000e+05,
        -2.228000e+05,  7.778000e+05, -8.410000e+04, -6.764000e+05,
        -5.490000e+04, -3.370000e+04, -4.862000e+05,  4.189000e+05,
         1.454700e+06,  1.975000e+05, -8.040000e+04,  5.149000e+05,
         6.401000e+05,  6.772000e+05,  1.565400e+06,  2.246000e+05,
         6.484000e+05,  1.958400e+06,  1.077600e+06,  1.628000e+05,
         1.756000e+05,  5.418000e+05,  2.020000e+05,  2.020000e+05,
         1.333100e+06,  2.493000e+06,  1.004700e+06,  3.843500e+06,
         1.971000e+05,  1.974000e+05,  4.940000e+04,  4.940000e+04,
         5.370000e+04,  4.960000e+04, -7.140000e+04,  4.940000e+04,
         2.384000e+05,  2.384000e+05,  2.384000e+05,  2.382000e+05,
         2.358000e+05, -2.552000e+05, -2.550000e+05, -2.551000e+05,
        -1.531000e+06, -4.194000e+05, -1.849000e+05,  5.540000e+04,
         5.310000e+05,  5.315000e+05,  1.247200e+06,  1.247400e+06,
        -4.070000e+04, -1.041000e+05, -3.320000e+04, -5.990000e+04,
         1.462000e+05, -1.360000e+04, -3.062000e+05,  1.420000e+05,
         4.293000e+05,  8.420000e+04,  0.000000e+00, -3.300000e+03,
        -6.590000e+04, -1.122000e+05,  1.721000e+05, -5.410000e+04,
         0.000000e+00,  0.000000e+00, -3.899000e+05, -9.720000e+04,
         6.458000e+05,  1.001000e+05,  1.663000e+05,  0.000000e+00,
        -6.140000e+04, -1.561000e+05,  2.144000e+05, -1.058000e+05,
        -1.058000e+05, -7.740000e+04,  2.162000e+05, -1.520000e+04,
        -1.826000e+05,  1.107000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.000000e+02,  1.600000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -5.990000e+04, -1.041000e+05,
        -4.020000e+04,  2.384000e+05,  2.000000e+02,  6.310000e+04,
         7.346000e+05,  1.219000e+05,  2.945000e+05,  2.676000e+05,
        -6.970000e+04,  5.370000e+04,  4.940000e+04,  1.974000e+05,
        -2.551000e+05, -1.849000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.384000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 4.475000e+05,  2.204000e+05,  1.458000e+05, -3.530000e+04,
         2.056000e+05,  1.900700e+06,  1.005600e+06,  4.439000e+05,
         2.204000e+05,  4.425000e+05,  2.204000e+05,  3.253000e+05,
         8.470000e+04, -2.748000e+05,  7.130000e+04,  3.226000e+05,
         1.920000e+04,  1.301200e+06,  6.696000e+05,  1.109000e+05,
         2.194000e+05, -6.620000e+04,  1.595000e+05,  8.152000e+05,
         9.838000e+05,  1.577000e+06,  7.292000e+05, -1.543000e+05,
        -8.050000e+04, -8.010000e+04, -8.130000e+04, -8.260000e+04,
        -2.473000e+05, -7.990000e+04, -5.293000e+05, -1.278500e+06,
        -1.129600e+06,  4.430000e+04, -1.467000e+05, -1.058000e+05,
         1.713000e+05, -1.767000e+05, -8.000000e+04, -8.020000e+04,
         5.990000e+04,  1.820000e+05,  2.910000e+04, -1.090000e+04,
         1.025000e+05, -8.640000e+04,  6.139000e+05, -3.258000e+05,
         2.751000e+05,  3.590000e+04, -1.778000e+05,  6.581000e+05,
         6.583000e+05,  3.212000e+05,  3.580000e+05,  1.227800e+06,
         7.810000e+04,  2.492000e+05,  1.397000e+05,  6.314000e+05,
         6.314000e+05,  6.313000e+05,  6.314000e+05,  4.153000e+05,
         3.890000e+04,  3.787000e+05,  2.679000e+05, -4.030000e+04,
         1.023000e+05,  3.390000e+04, -2.051000e+05,  1.880000e+05,
         1.506000e+05,  1.506000e+05,  7.130000e+04,  7.110000e+04,
         7.130000e+04,  1.896000e+06,  1.353000e+06,  7.144000e+05,
         7.240000e+05,  1.056000e+06,  7.298000e+05,  6.900000e+05,
         2.400600e+06,  1.644100e+06,  2.400600e+06,  1.664300e+06,
         1.204600e+06, -2.201000e+05, -8.119000e+05, -7.046000e+05,
         2.347000e+05,  4.560000e+04,  2.263900e+06, -3.413000e+05,
         2.481000e+05,  6.180000e+04, -1.231000e+05, -2.860000e+05,
         2.967000e+05, -5.900000e+04, -1.535000e+05, -2.929000e+05,
         5.466000e+05,  9.279000e+05,  3.352000e+05,  1.520500e+06,
        -1.650000e+04,  1.776000e+05,  2.748000e+05, -1.030000e+05,
         4.979000e+05,  1.137000e+06,  5.641000e+05,  5.482000e+05,
         5.027000e+05,  1.077600e+06,  9.309390e+07,  1.084000e+05,
         5.840000e+04,  1.985000e+05,  7.582000e+05,  7.583000e+05,
         5.398000e+05,  9.007000e+05,  1.845100e+06,  1.259770e+07,
         1.507000e+05,  1.509000e+05, -6.580000e+04, -6.580000e+04,
        -1.140000e+04, -6.570000e+04, -2.460000e+05, -6.580000e+04,
         1.946000e+05,  1.946000e+05,  1.946000e+05,  1.945000e+05,
         1.959000e+05, -2.120000e+05, -2.118000e+05, -2.118000e+05,
        -1.271500e+06, -4.430000e+05, -2.543000e+05, -1.414000e+05,
         3.781000e+05,  3.785000e+05,  9.626000e+05,  9.627000e+05,
        -4.350000e+04, -1.013000e+05,  5.300000e+03,  1.085000e+05,
         7.200000e+03, -1.540000e+04, -2.748000e+05,  3.253000e+05,
         2.110000e+04, -1.319000e+05,  0.000000e+00, -1.700000e+03,
        -1.880000e+04,  1.694000e+05, -5.930000e+04, -4.200000e+04,
         0.000000e+00,  0.000000e+00, -1.484000e+05, -3.412000e+05,
        -7.670000e+04,  1.190000e+04, -5.730000e+04,  0.000000e+00,
         1.105000e+05, -1.397000e+05,  1.060000e+04, -1.071000e+05,
        -1.071000e+05,  1.649000e+05, -6.204000e+05, -1.120000e+04,
         5.450000e+04, -7.244000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.000000e+02,  8.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.085000e+05, -1.013000e+05,
        -3.610000e+04,  1.946000e+05,  1.000000e+02,  4.475000e+05,
         2.204000e+05,  7.110000e+04,  6.314000e+05,  3.787000e+05,
        -8.240000e+04, -1.140000e+04, -6.580000e+04,  1.509000e+05,
        -2.118000e+05, -2.543000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.946000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-1.290000e+04,  2.970000e+04,  2.700000e+04, -5.010000e+04,
        -3.140000e+04, -7.260000e+04, -4.670000e+04, -1.150000e+04,
         2.970000e+04, -1.090000e+04,  2.970000e+04,  1.420000e+04,
         1.370000e+04,  3.321000e+05, -3.400000e+03,  1.570000e+04,
         3.300000e+03,  5.700000e+04,  3.795000e+05,  4.436000e+05,
         4.403000e+05,  3.123000e+05, -2.590000e+04,  7.760000e+04,
         9.457000e+05,  6.310000e+05,  9.901000e+05,  1.602200e+06,
         3.793000e+05,  3.788000e+05,  3.783000e+05,  3.788000e+05,
         4.385000e+05,  3.795000e+05,  3.218300e+06,  3.303100e+06,
         3.299400e+06,  3.490000e+05,  3.732000e+05,  3.693000e+05,
        -8.150000e+04, -1.467000e+05,  5.293000e+05,  5.293000e+05,
         3.582000e+05,  1.885000e+05,  3.553000e+05,  3.716000e+05,
         8.662000e+05,  8.891000e+05,  3.390000e+04,  2.732000e+05,
        -3.460000e+04, -5.360000e+04, -1.463000e+05,  8.345000e+05,
         8.352000e+05,  8.787000e+05,  8.751000e+05, -8.890000e+04,
        -4.500000e+03,  3.990000e+04,  3.520000e+04,  3.230000e+04,
         3.230000e+04,  3.230000e+04,  3.230000e+04,  7.670000e+04,
         3.470000e+05,  1.200000e+04,  3.380000e+04, -1.060000e+04,
        -1.837000e+05, -1.610000e+05,  3.253000e+05,  2.296000e+05,
         3.290000e+04,  3.290000e+04, -3.400000e+03, -3.400000e+03,
        -3.400000e+03,  1.197000e+05,  2.303000e+05,  7.464000e+05,
         2.870000e+05,  7.430000e+04,  1.402000e+05, -2.064000e+05,
         1.604000e+05,  3.157000e+05,  1.604000e+05,  3.162000e+05,
         7.863000e+05,  1.296100e+06,  1.610900e+06,  1.384800e+06,
         3.962000e+05,  4.193000e+05,  4.172000e+05,  3.491000e+05,
         3.330000e+04,  5.460000e+04,  3.686000e+05,  7.033000e+05,
        -7.480000e+04, -9.000000e+03, -1.390000e+04,  2.410000e+05,
        -5.090000e+04,  3.227000e+05,  6.375000e+05,  8.000000e+03,
         4.376000e+05,  4.241000e+05,  7.454000e+05,  7.913000e+05,
         5.398000e+05,  9.560000e+04,  1.683000e+05,  4.114000e+05,
         5.200000e+05,  1.628000e+05,  1.084000e+05,  5.445000e+05,
         3.654000e+05,  1.943000e+05,  2.700000e+03,  2.700000e+03,
         6.950000e+04,  5.212000e+05,  4.064000e+05,  1.671000e+05,
         3.570000e+04,  3.570000e+04,  1.660000e+04,  1.660000e+04,
         3.700000e+05,  1.730000e+04, -3.926000e+05,  1.660000e+04,
         4.700000e+04,  4.700000e+04,  4.700000e+04,  4.700000e+04,
         4.600000e+04, -5.400000e+04, -5.400000e+04, -5.400000e+04,
        -3.242000e+05, -7.550000e+04, -2.940000e+04,  1.063600e+06,
         4.654000e+05,  4.669000e+05,  6.094000e+05,  6.101000e+05,
        -1.050000e+04, -4.520000e+04,  1.900000e+03, -2.100000e+04,
        -4.800000e+03, -2.500000e+03,  3.321000e+05,  1.420000e+04,
        -1.480000e+04,  2.910000e+04,  0.000000e+00,  1.000000e+02,
        -7.000000e+03, -2.510000e+04, -7.500000e+03, -1.060000e+04,
         0.000000e+00,  0.000000e+00,  3.008000e+05,  3.220000e+05,
        -2.400000e+04, -1.460000e+04, -7.300000e+03,  0.000000e+00,
        -2.090000e+04,  1.747000e+05, -7.000000e+03, -4.640000e+04,
        -4.640000e+04, -2.630000e+04, -8.200000e+03, -3.000000e+03,
        -7.250000e+04, -5.450000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         7.000000e+02,  6.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -2.100000e+04, -4.520000e+04,
         4.360000e+04,  4.700000e+04,  7.000000e+02, -1.290000e+04,
         2.970000e+04, -3.400000e+03,  3.230000e+04,  1.200000e+04,
         3.788000e+05,  3.700000e+05,  1.660000e+04,  3.570000e+04,
        -5.400000e+04, -2.940000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.700000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-4.820000e+04,  2.770000e+04,  3.110000e+04,  6.102000e+05,
         2.804000e+05, -2.299000e+05, -1.335000e+05, -4.570000e+04,
         2.770000e+04, -4.460000e+04,  2.770000e+04, -1.400000e+03,
         1.380000e+04,  2.657000e+05,  3.401000e+05,  1.000000e+03,
         3.500000e+03, -5.600000e+03,  2.768000e+05,  3.891000e+05,
         3.986000e+05,  1.372500e+06,  9.948000e+05,  6.130000e+04,
         8.337000e+05,  5.701000e+05,  9.086000e+05,  8.254700e+06,
         3.193000e+05,  3.199000e+05,  3.195000e+05,  3.186000e+05,
         3.587000e+05,  3.202000e+05,  2.595600e+06,  2.747600e+06,
         2.757900e+06,  2.697000e+05,  3.063000e+05,  3.103000e+05,
         8.919000e+05,  1.493300e+06,  1.219900e+06,  1.219600e+06,
         1.048100e+06,  8.662000e+05,  1.048000e+06,  7.046000e+05,
         2.232200e+06,  2.269100e+06,  1.411600e+06,  9.439000e+05,
         6.192000e+05,  9.511000e+05,  1.492700e+06,  6.989000e+05,
         6.992000e+05,  7.743000e+05,  7.800000e+05, -2.084000e+05,
         3.497000e+05,  4.101000e+05,  4.090000e+04,  6.600000e+03,
         6.600000e+03,  6.500000e+03,  6.600000e+03,  8.120000e+04,
         2.708000e+05,  3.475000e+05,  3.849000e+05, -1.960000e+04,
        -1.752000e+05, -1.285000e+05,  6.345000e+05,  4.295000e+05,
         3.750000e+04,  3.750000e+04,  3.401000e+05,  3.400000e+05,
         3.401000e+05,  7.603000e+05,  9.455000e+05,  1.316500e+06,
         8.728000e+05,  2.460000e+04,  1.338000e+05, -1.735000e+05,
         7.700000e+04,  3.382000e+05,  7.700000e+04,  3.380000e+05,
         6.005000e+05,  9.750000e+05,  1.239100e+06,  1.124700e+06,
         3.239000e+05,  3.608000e+05,  4.130000e+05,  2.949000e+05,
         3.170000e+04,  6.930000e+04,  2.992000e+05,  9.711000e+05,
        -1.246000e+05, -1.060000e+04, -2.900000e+03,  1.388000e+05,
        -1.215000e+05,  1.764000e+05,  4.411000e+05, -8.840000e+04,
         3.609000e+05,  3.793000e+05,  5.943000e+05,  6.681000e+05,
         4.741000e+05,  6.390000e+04,  1.735000e+05,  3.270000e+05,
         4.803000e+05,  1.756000e+05,  5.840000e+04,  3.654000e+05,
         1.082500e+06,  9.110000e+05, -4.750000e+04, -4.750000e+04,
         6.890000e+04,  4.996000e+05,  3.150000e+05, -6.019000e+05,
         3.260000e+04,  3.260000e+04,  2.760000e+04,  2.770000e+04,
         7.094000e+05,  2.800000e+04, -3.181000e+05,  2.770000e+04,
         5.350000e+04,  5.350000e+04,  5.350000e+04,  5.350000e+04,
         5.240000e+04, -6.430000e+04, -6.430000e+04, -6.430000e+04,
        -3.857000e+05, -8.090000e+04, -2.660000e+04,  2.397900e+06,
         8.152000e+05,  8.139000e+05,  9.751000e+05,  9.754000e+05,
        -2.050000e+04,  2.556000e+05, -1.870000e+04, -3.620000e+04,
        -7.300000e+03, -1.200000e+03,  2.657000e+05, -1.400000e+03,
        -2.560000e+04,  5.150000e+04,  0.000000e+00,  0.000000e+00,
        -2.250000e+04, -6.990000e+04, -3.090000e+04, -1.230000e+04,
         0.000000e+00,  0.000000e+00,  2.178000e+05,  2.534000e+05,
        -3.810000e+04, -2.460000e+04, -2.990000e+04,  0.000000e+00,
        -3.710000e+04,  1.306000e+05, -1.260000e+04,  2.705000e+05,
         2.705000e+05, -5.350000e+04, -1.450000e+04, -4.800000e+03,
         2.185000e+05,  2.562000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         3.000000e+02, -2.300000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.620000e+04,  2.556000e+05,
         3.490000e+04,  5.350000e+04,  3.000000e+02, -4.820000e+04,
         2.770000e+04,  3.400000e+05,  6.600000e+03,  3.475000e+05,
         3.187000e+05,  7.094000e+05,  2.770000e+04,  3.260000e+04,
        -6.430000e+04, -2.660000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  5.350000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-2.660000e+04,  2.152000e+05,  5.380000e+04,  6.432000e+05,
         3.076000e+05, -1.476000e+05, -9.440000e+04, -2.380000e+04,
         2.152000e+05, -2.250000e+04,  2.151000e+05,  2.560000e+04,
         5.720000e+04,  2.420000e+04,  3.737000e+05,  2.840000e+04,
         1.350000e+04,  1.024000e+05,  1.167000e+05,  4.534000e+05,
         2.418000e+05,  1.203600e+06,  1.292000e+06,  1.485000e+05,
         5.788000e+05,  5.841000e+05,  8.162000e+05,  7.355700e+06,
         1.117000e+05,  1.121000e+05,  1.122000e+05,  1.111000e+05,
         7.390000e+04,  1.124000e+05,  6.491000e+05,  1.099600e+06,
         8.159000e+05,  5.570000e+04,  1.670000e+05,  9.740000e+04,
         9.530000e+05,  1.558900e+06,  9.091000e+05,  9.031000e+05,
         1.058500e+06,  1.029000e+06,  8.832000e+05,  5.056000e+05,
         1.744300e+06,  1.855900e+06,  2.632500e+06,  7.241000e+05,
         6.787000e+05,  1.017600e+06,  1.556900e+06,  3.726000e+05,
         3.730000e+05,  6.010000e+05,  4.560000e+05, -1.777000e+05,
         3.544000e+05,  4.779000e+05,  6.660000e+04,  6.090000e+04,
         6.090000e+04,  6.090000e+04,  6.090000e+04,  3.026000e+05,
         5.630000e+04,  4.050000e+05,  5.258000e+05, -2.250000e+04,
         7.770000e+04, -7.400000e+03,  4.172000e+05,  3.464000e+05,
         6.260000e+04,  6.260000e+04,  3.737000e+05,  3.736000e+05,
         3.737000e+05,  9.897000e+05,  1.593400e+06,  9.934000e+05,
         7.184000e+05,  1.338000e+05,  4.953000e+05,  6.810000e+05,
         3.008000e+05,  1.146800e+06,  3.008000e+05,  1.147000e+06,
         2.895000e+05,  5.060000e+04,  4.580000e+04,  5.282000e+05,
         1.432000e+05,  2.548000e+05,  2.295600e+06,  5.630000e+04,
         6.220000e+04,  1.745000e+05,  8.900000e+04,  5.302000e+05,
        -1.398000e+05,  2.195000e+05, -1.480000e+04, -1.456000e+05,
        -1.067000e+05,  4.600000e+03,  1.000000e+02,  9.100000e+03,
         5.630000e+05,  2.131000e+05,  1.989000e+05,  4.223000e+05,
         3.700000e+05,  1.789000e+05,  5.128000e+05,  1.732000e+05,
         3.749000e+05,  5.418000e+05,  1.985000e+05,  1.943000e+05,
         9.110000e+05,  1.619500e+06,  3.000000e+02,  3.000000e+02,
         3.672000e+05,  9.032000e+05,  3.448000e+05,  2.464000e+05,
         6.430000e+04,  6.420000e+04,  3.100000e+04,  3.100000e+04,
         5.091000e+05,  3.140000e+04, -1.374000e+05,  3.100000e+04,
         8.750000e+04,  8.750000e+04,  8.750000e+04,  8.740000e+04,
         8.610000e+04, -1.021000e+05, -1.020000e+05, -1.020000e+05,
        -6.124000e+05, -1.440000e+05, -5.650000e+04,  1.796200e+06,
         6.833000e+05,  6.825000e+05,  9.455000e+05,  9.458000e+05,
        -2.290000e+04,  2.541000e+05, -2.830000e+04, -4.030000e+04,
         3.780000e+04, -3.300000e+03,  2.420000e+04,  2.560000e+04,
         1.686000e+05,  5.710000e+04,  0.000000e+00,  3.000000e+03,
        -3.580000e+04, -8.490000e+04,  2.630000e+04, -2.000000e+04,
         0.000000e+00,  0.000000e+00, -3.020000e+04,  8.000000e+04,
         2.271000e+05,  3.430000e+04,  2.540000e+04,  0.000000e+00,
        -4.120000e+04,  1.050000e+04,  8.430000e+04,  2.691000e+05,
         2.691000e+05, -5.890000e+04,  5.550000e+04, -7.000000e+03,
         2.115000e+05,  3.249000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         3.000000e+02, -2.200000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -4.030000e+04,  2.541000e+05,
         3.200000e+03,  8.750000e+04,  3.000000e+02, -2.660000e+04,
         2.152000e+05,  3.736000e+05,  6.090000e+04,  4.050000e+05,
         1.112000e+05,  5.091000e+05,  3.100000e+04,  6.420000e+04,
        -1.020000e+05, -5.650000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  8.750000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 4.398000e+05,  4.180000e+04,  7.530000e+04, -5.190000e+04,
         1.930000e+05,  1.891000e+06,  1.011600e+06,  4.293000e+05,
         4.180000e+04,  4.245000e+05,  4.180000e+04,  2.651000e+05,
         2.910000e+04, -1.082000e+05,  2.100000e+03,  2.550000e+05,
         5.500000e+03,  1.060500e+06,  6.298000e+05,  3.770000e+04,
         8.220000e+04, -1.012000e+05, -6.600000e+03,  5.478000e+05,
         4.469000e+05,  8.044000e+05,  5.160000e+04, -2.179000e+05,
        -5.290000e+04, -5.290000e+04, -5.350000e+04, -5.230000e+04,
        -1.074000e+05, -5.230000e+04,  2.060000e+05, -5.862000e+05,
        -5.242000e+05,  1.387000e+05, -5.920000e+04, -4.380000e+04,
         1.405000e+05, -1.583000e+05, -1.022000e+05, -1.022000e+05,
        -5.440000e+04, -6.900000e+03, -3.970000e+04, -4.930000e+04,
         4.280000e+04, -1.549000e+05,  8.400000e+04, -1.587000e+05,
         1.949000e+05, -4.980000e+04, -1.579000e+05,  4.387000e+05,
         4.393000e+05,  4.600000e+04,  7.360000e+04,  1.278900e+06,
         2.700000e+03,  5.810000e+04,  4.570000e+04,  4.938000e+05,
         4.938000e+05,  4.938000e+05,  4.938000e+05,  9.720000e+04,
         1.355000e+05,  2.505000e+05,  5.170000e+04, -1.760000e+04,
         2.960000e+04, -5.740000e+04, -1.058000e+05,  2.980000e+04,
         5.730000e+04,  5.730000e+04,  2.100000e+03,  2.100000e+03,
         2.100000e+03,  1.297200e+06,  3.054000e+05,  5.808000e+05,
         7.617000e+05,  7.608000e+05,  1.654000e+05,  2.612000e+05,
         1.783700e+06,  3.958000e+05,  1.783700e+06,  3.965000e+05,
         1.062000e+06,  4.315000e+05,  7.360000e+04, -3.598000e+05,
         1.950000e+05, -2.700000e+03,  5.481000e+05, -2.119000e+05,
         1.428000e+05, -5.470000e+04, -7.040000e+04, -1.583000e+05,
         4.693000e+05, -1.240000e+05, -7.830000e+04,  1.146000e+05,
         6.164000e+05,  1.016100e+06,  6.580000e+05,  1.374200e+06,
         2.770000e+04,  1.034000e+05,  3.345000e+05, -6.090000e+04,
         1.130000e+05,  7.960000e+05,  2.022000e+05,  4.410000e+05,
         1.136000e+05,  2.020000e+05,  7.582000e+05,  2.700000e+03,
        -4.750000e+04,  3.000000e+02,  8.415000e+05,  8.412000e+05,
         9.170000e+04,  1.972000e+05,  1.185700e+06,  1.111860e+07,
         3.710000e+04,  3.720000e+04, -1.041000e+05, -1.041000e+05,
        -5.070000e+04, -1.035000e+05, -2.108000e+05, -1.041000e+05,
         5.550000e+04,  5.550000e+04,  5.550000e+04,  5.550000e+04,
         6.100000e+04, -6.870000e+04, -6.860000e+04, -6.860000e+04,
        -4.120000e+05, -2.136000e+05, -1.588000e+05, -2.059000e+05,
         6.160000e+04,  6.300000e+04,  2.307000e+05,  2.314000e+05,
        -1.760000e+04, -4.480000e+04,  5.000000e+02,  1.301000e+05,
        -5.600000e+03, -1.020000e+04, -1.082000e+05,  2.651000e+05,
        -1.270000e+04, -1.929000e+05,  0.000000e+00,  0.000000e+00,
         7.200000e+03,  1.784000e+05, -6.000000e+03, -1.370000e+04,
         0.000000e+00,  0.000000e+00,  7.960000e+04, -1.153000e+05,
        -1.960000e+04,  5.790000e+04, -5.800000e+03,  0.000000e+00,
         1.319000e+05, -5.430000e+04, -6.000000e+03, -5.390000e+04,
        -5.390000e+04,  1.776000e+05, -7.800000e+03, -1.200000e+03,
         1.219000e+05, -6.210000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         7.000000e+02, -3.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.301000e+05, -4.480000e+04,
        -1.420000e+04,  5.550000e+04,  7.000000e+02,  4.398000e+05,
         4.180000e+04,  2.100000e+03,  4.938000e+05,  2.505000e+05,
        -5.240000e+04, -5.070000e+04, -1.041000e+05,  3.720000e+04,
        -6.860000e+04, -1.588000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  5.550000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 4.397000e+05,  4.180000e+04,  7.530000e+04, -5.190000e+04,
         1.930000e+05,  1.891000e+06,  1.011600e+06,  4.293000e+05,
         4.180000e+04,  4.245000e+05,  4.180000e+04,  2.651000e+05,
         2.910000e+04, -1.082000e+05,  2.100000e+03,  2.550000e+05,
         5.500000e+03,  1.060400e+06,  6.298000e+05,  3.770000e+04,
         8.220000e+04, -1.011000e+05, -6.500000e+03,  5.478000e+05,
         4.469000e+05,  8.044000e+05,  5.160000e+04, -2.179000e+05,
        -5.290000e+04, -5.290000e+04, -5.350000e+04, -5.230000e+04,
        -1.075000e+05, -5.230000e+04,  2.059000e+05, -5.862000e+05,
        -5.243000e+05,  1.387000e+05, -5.920000e+04, -4.390000e+04,
         1.405000e+05, -1.583000e+05, -1.022000e+05, -1.022000e+05,
        -5.440000e+04, -6.900000e+03, -3.970000e+04, -4.930000e+04,
         4.280000e+04, -1.549000e+05,  8.400000e+04, -1.587000e+05,
         1.949000e+05, -4.980000e+04, -1.579000e+05,  4.387000e+05,
         4.393000e+05,  4.600000e+04,  7.360000e+04,  1.279000e+06,
         2.700000e+03,  5.810000e+04,  4.570000e+04,  4.938000e+05,
         4.938000e+05,  4.938000e+05,  4.938000e+05,  9.730000e+04,
         1.355000e+05,  2.505000e+05,  5.170000e+04, -1.760000e+04,
         2.960000e+04, -5.740000e+04, -1.058000e+05,  2.980000e+04,
         5.730000e+04,  5.730000e+04,  2.100000e+03,  2.100000e+03,
         2.100000e+03,  1.297200e+06,  3.054000e+05,  5.808000e+05,
         7.616000e+05,  7.608000e+05,  1.654000e+05,  2.613000e+05,
         1.783700e+06,  3.959000e+05,  1.783700e+06,  3.965000e+05,
         1.062000e+06,  4.315000e+05,  7.360000e+04, -3.599000e+05,
         1.950000e+05, -2.700000e+03,  5.482000e+05, -2.119000e+05,
         1.428000e+05, -5.470000e+04, -7.040000e+04, -1.583000e+05,
         4.693000e+05, -1.240000e+05, -7.840000e+04,  1.146000e+05,
         6.164000e+05,  1.016100e+06,  6.580000e+05,  1.374200e+06,
         2.770000e+04,  1.033000e+05,  3.345000e+05, -6.090000e+04,
         1.130000e+05,  7.960000e+05,  2.023000e+05,  4.410000e+05,
         1.137000e+05,  2.020000e+05,  7.583000e+05,  2.700000e+03,
        -4.750000e+04,  3.000000e+02,  8.412000e+05,  1.021100e+06,
         9.170000e+04,  1.973000e+05,  1.185700e+06,  1.112090e+07,
         3.710000e+04,  3.720000e+04, -1.041000e+05, -1.041000e+05,
        -5.070000e+04, -1.035000e+05, -2.108000e+05, -1.041000e+05,
         5.550000e+04,  5.550000e+04,  5.550000e+04,  5.550000e+04,
         6.100000e+04, -6.870000e+04, -6.860000e+04, -6.860000e+04,
        -4.120000e+05, -2.136000e+05, -1.588000e+05, -2.058000e+05,
         6.160000e+04,  6.300000e+04,  2.307000e+05,  2.314000e+05,
        -1.760000e+04, -4.480000e+04,  5.000000e+02,  1.301000e+05,
        -5.600000e+03, -1.020000e+04, -1.082000e+05,  2.651000e+05,
        -1.270000e+04, -1.929000e+05,  0.000000e+00,  0.000000e+00,
         7.200000e+03,  1.784000e+05, -6.000000e+03, -1.370000e+04,
         0.000000e+00,  0.000000e+00,  7.960000e+04, -1.153000e+05,
        -1.960000e+04,  5.790000e+04, -5.800000e+03,  0.000000e+00,
         1.319000e+05, -5.430000e+04, -6.000000e+03, -5.390000e+04,
        -5.390000e+04,  1.776000e+05, -7.800000e+03, -1.200000e+03,
         1.219000e+05, -6.210000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         7.000000e+02, -3.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.301000e+05, -4.480000e+04,
        -1.420000e+04,  5.550000e+04,  7.000000e+02,  4.397000e+05,
         4.180000e+04,  2.100000e+03,  4.938000e+05,  2.505000e+05,
        -5.240000e+04, -5.070000e+04, -1.041000e+05,  3.720000e+04,
        -6.870000e+04, -1.588000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  5.550000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 2.810000e+04,  6.347000e+05,  6.810000e+04,  1.300000e+03,
         1.480000e+04,  8.510000e+04,  2.890000e+04,  2.990000e+04,
         6.347000e+05,  3.090000e+04,  6.343000e+05,  6.370000e+04,
         1.446000e+05, -1.433000e+05,  5.220000e+04,  6.600000e+04,
         3.360000e+04,  2.549000e+05,  5.460000e+04,  8.488000e+05,
         1.202000e+05,  1.270000e+04,  5.986000e+05,  2.358000e+05,
         4.052000e+05,  6.145000e+05,  9.959000e+05,  1.200000e+04,
        -3.600000e+04, -3.600000e+04, -3.520000e+04, -3.690000e+04,
        -1.258000e+05, -3.520000e+04, -6.479000e+05,  4.103000e+05,
        -5.604000e+05, -7.520000e+04,  1.878000e+05, -5.330000e+04,
         1.610000e+04, -4.760000e+04, -3.100000e+03, -3.100000e+03,
         2.951000e+05,  5.899000e+05,  4.890000e+04,  1.780000e+04,
         2.700000e+04,  2.907000e+05,  1.781900e+06, -1.455000e+05,
         6.690000e+04,  5.350000e+04, -4.710000e+04,  1.669000e+05,
         1.676000e+05,  7.144000e+05,  2.106000e+05, -2.600000e+04,
         2.130000e+04,  1.552000e+05,  8.110000e+04,  1.319000e+05,
         1.319000e+05,  1.319000e+05,  1.319000e+05,  7.429000e+05,
        -7.680000e+04,  1.176000e+05,  4.218000e+05, -1.710000e+04,
         2.811000e+05,  7.360000e+04, -9.120000e+04,  1.156000e+05,
         7.780000e+04,  7.790000e+04,  5.220000e+04,  5.210000e+04,
         5.220000e+04,  5.401000e+05,  2.065000e+06,  1.222000e+05,
         7.900000e+03,  2.703000e+05,  1.184200e+06,  1.685600e+06,
         5.687000e+05,  2.707000e+06,  5.688000e+05,  2.745700e+06,
         1.497000e+05, -5.172000e+05, -7.257000e+05,  6.772000e+05,
         3.120000e+04,  2.948000e+05,  5.767800e+06, -1.203000e+05,
         8.900000e+04,  3.538000e+05, -5.350000e+04, -1.265000e+05,
        -1.008000e+05,  7.974000e+05, -3.520000e+04, -3.101000e+05,
        -2.410000e+04, -1.950000e+04, -2.285000e+05,  1.895000e+05,
         1.299300e+06,  8.990000e+04, -4.510000e+04,  4.824000e+05,
         2.840000e+05,  3.046000e+05,  1.093600e+06,  9.570000e+04,
         2.880000e+05,  1.333100e+06,  5.398000e+05,  6.950000e+04,
         6.890000e+04,  3.672000e+05,  9.170000e+04,  9.170000e+04,
         2.504300e+06,  1.833000e+06,  5.142000e+05,  1.740500e+06,
         8.870000e+04,  8.880000e+04,  2.230000e+04,  2.240000e+04,
         1.630000e+04,  2.310000e+04, -2.670000e+04,  2.240000e+04,
         1.075000e+05,  1.075000e+05,  1.075000e+05,  1.074000e+05,
         1.065000e+05, -1.146000e+05, -1.145000e+05, -1.145000e+05,
        -6.874000e+05, -1.885000e+05, -8.300000e+04, -1.500000e+03,
         2.327000e+05,  2.342000e+05,  5.581000e+05,  5.589000e+05,
        -1.780000e+04, -4.940000e+04, -3.190000e+04, -2.720000e+04,
         1.549000e+05, -6.000000e+03, -1.433000e+05,  6.370000e+04,
         4.567000e+05,  3.790000e+04,  0.000000e+00, -3.300000e+03,
        -4.460000e+04, -6.770000e+04,  1.878000e+05, -2.440000e+04,
         0.000000e+00,  0.000000e+00, -1.813000e+05,  8.010000e+04,
         6.876000e+05,  1.241000e+05,  1.814000e+05,  0.000000e+00,
        -2.720000e+04, -7.260000e+04,  2.282000e+05, -5.030000e+04,
        -5.030000e+04, -3.520000e+04,  2.293000e+05, -6.800000e+03,
        -8.520000e+04,  1.792000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         7.000000e+02,  7.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -2.720000e+04, -4.940000e+04,
        -1.880000e+04,  1.075000e+05,  7.000000e+02,  2.810000e+04,
         6.347000e+05,  5.210000e+04,  1.319000e+05,  1.176000e+05,
        -3.680000e+04,  1.630000e+04,  2.240000e+04,  8.880000e+04,
        -1.145000e+05, -8.300000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.075000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 2.930000e+04,  1.103100e+06,  2.047000e+05, -1.800000e+04,
         6.100000e+03,  1.190000e+04, -4.680000e+04,  3.660000e+04,
         1.103100e+06,  4.030000e+04,  1.102500e+06,  1.666000e+05,
         2.761000e+05, -1.327000e+05,  1.502000e+05,  1.748000e+05,
         6.460000e+04,  6.665000e+05,  3.997000e+05,  2.126800e+06,
         6.764000e+05,  3.135000e+05,  1.139000e+06,  6.769000e+05,
         5.297300e+06,  5.603400e+06,  6.401800e+06,  1.457300e+06,
         2.000000e+05,  2.008000e+05,  2.026000e+05,  1.981000e+05,
        -2.000000e+02,  2.030000e+05,  6.875000e+05,  2.991500e+06,
         1.056400e+06,  5.090000e+04,  6.209000e+05,  1.432000e+05,
        -1.160000e+04, -2.019000e+05,  4.312000e+05,  4.312000e+05,
         8.348000e+05,  1.244500e+06,  4.356000e+05,  3.534000e+05,
         7.827000e+05,  1.355200e+06,  3.373200e+06, -1.638000e+05,
         1.563000e+05,  1.322000e+05, -2.001000e+05,  1.091400e+06,
         1.093700e+06,  2.240600e+06,  1.275900e+06, -2.596000e+05,
         8.890000e+04,  4.687000e+05,  2.507000e+05,  3.531000e+05,
         3.531000e+05,  3.530000e+05,  3.531000e+05,  1.436800e+06,
         4.740000e+04,  3.236000e+05,  8.628000e+05, -5.450000e+04,
         3.432000e+05,  8.460000e+04,  1.610000e+04,  5.057000e+05,
         2.386000e+05,  2.386000e+05,  1.502000e+05,  1.502000e+05,
         1.502000e+05,  1.509200e+06,  4.215500e+06,  8.942000e+05,
         1.917000e+05,  7.516000e+05,  2.372600e+06,  3.225300e+06,
         1.567900e+06,  5.360800e+06,  1.568000e+06,  5.386000e+06,
         9.623000e+05, -4.645000e+05, -7.698000e+05,  1.731200e+06,
         3.810000e+05,  9.532000e+05,  1.071020e+07,  3.408900e+06,
         3.717500e+06,  4.294000e+06,  1.450000e+05,  2.181000e+05,
         3.064300e+06,  4.797100e+06,  3.341000e+06,  2.755900e+06,
        -1.650000e+05,  1.108000e+05, -1.968000e+05,  4.185000e+05,
         2.973200e+06,  5.720000e+05,  4.288000e+05,  1.573700e+06,
         1.188100e+06,  8.610000e+05,  2.570800e+06,  5.535000e+05,
         1.204400e+06,  2.493000e+06,  9.007000e+05,  5.212000e+05,
         4.996000e+05,  9.032000e+05,  1.972000e+05,  1.973000e+05,
         1.833000e+06,  7.322390e+07,  7.036150e+07,  4.023500e+06,
         2.742000e+05,  2.745000e+05,  3.537300e+06,  3.539700e+06,
         3.479000e+05,  3.541900e+06,  6.545600e+06,  3.539700e+06,
         3.332000e+05,  3.332000e+05,  3.332000e+05,  3.330000e+05,
         3.290000e+05, -3.593000e+05, -3.591000e+05, -3.591000e+05,
        -2.155700e+06,  2.883300e+06,  3.211600e+06,  8.774000e+05,
         1.019100e+06,  1.024000e+06,  2.028100e+06,  2.030400e+06,
        -5.620000e+04, -1.639000e+05, -6.210000e+04, -1.044000e+05,
         2.269000e+05, -1.810000e+04, -1.327000e+05,  1.666000e+05,
         6.667000e+05,  1.473000e+05,  0.000000e+00, -4.200000e+03,
        -1.075000e+05, -1.992000e+05,  3.509000e+05, -7.540000e+04,
         0.000000e+00,  0.000000e+00, -2.783000e+05,  2.879000e+05,
         1.068000e+06,  1.715000e+05,  3.390000e+05,  0.000000e+00,
        -1.053000e+05, -7.110000e+04,  3.338000e+05, -1.662000e+05,
        -1.662000e+05, -1.347000e+05,  3.961000e+05, -2.140000e+04,
        -2.999000e+05,  2.301000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.300000e+03,  2.400000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.044000e+05, -1.639000e+05,
        -1.740000e+04,  3.332000e+05,  2.300000e+03,  2.930000e+04,
         1.103100e+06,  1.502000e+05,  3.531000e+05,  3.236000e+05,
         1.982000e+05,  3.479000e+05,  3.539700e+06,  2.745000e+05,
        -3.592000e+05,  3.211600e+06,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  3.332000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 7.069000e+05,  2.524000e+05,  2.098000e+05, -1.072000e+05,
         2.986000e+05,  3.000100e+06,  1.586500e+06,  6.964000e+05,
         2.524000e+05,  6.915000e+05,  2.524000e+05,  4.960000e+05,
         1.093000e+05, -6.890000e+04,  6.790000e+04,  4.856000e+05,
         2.390000e+04,  1.984100e+06,  1.376300e+06,  3.740000e+05,
         6.311000e+05,  1.311000e+05,  1.570000e+05,  1.207100e+06,
         5.392300e+06,  5.931400e+06,  4.886000e+06,  1.105400e+06,
         1.787000e+05,  1.803000e+05,  1.787000e+05,  1.775000e+05,
         3.720000e+04,  1.824000e+05,  2.192100e+06,  7.065000e+05,
         1.198400e+06,  4.890000e+05, -9.890000e+04,  2.405000e+05,
         1.908000e+05, -3.892000e+05,  2.798000e+05,  2.796000e+05,
         3.093000e+05,  3.280000e+05,  2.988000e+05,  2.517000e+05,
         8.402000e+05, -6.601000e+05, -5.116000e+05, -1.832000e+05,
         3.662000e+05, -3.940000e+04, -3.877000e+05,  1.566800e+06,
         1.569000e+06,  9.525000e+05,  1.070000e+06,  1.935300e+06,
         7.730000e+04,  3.108000e+05,  1.926000e+05,  9.570000e+05,
         9.570000e+05,  9.569000e+05,  9.570000e+05,  5.011000e+05,
         4.170000e+05,  5.430000e+05,  3.157000e+05, -5.370000e+04,
        -2.150000e+04, -1.370000e+05, -2.200000e+03,  3.722000e+05,
         2.022000e+05,  2.022000e+05,  6.790000e+04,  6.780000e+04,
         6.790000e+04,  2.769800e+06,  1.633100e+06,  1.684700e+06,
         1.437000e+06,  1.574100e+06,  8.916000e+05,  7.465000e+05,
         3.595600e+06,  2.000100e+06,  3.595600e+06,  2.026400e+06,
         2.509200e+06,  1.159500e+06,  6.184000e+05,  1.792000e+05,
         6.628000e+05, -7.399000e+05,  2.836300e+06,  3.261500e+06,
         3.809200e+06,  3.476500e+06,  1.269000e+05,  1.804000e+05,
         4.012500e+06,  3.381800e+06,  3.267200e+06,  3.465100e+06,
         8.805000e+05,  1.891400e+06,  1.332500e+06,  2.450300e+06,
        -5.610000e+06,  6.493000e+05,  1.077300e+06, -1.923300e+06,
         9.032000e+05,  1.681500e+06, -8.220000e+04,  1.136500e+06,
         9.259000e+05,  1.004700e+06,  1.845100e+06,  4.064000e+05,
         3.150000e+05,  3.448000e+05,  1.185700e+06,  1.185700e+06,
         5.142000e+05,  7.036150e+07,  5.767337e+08,  1.951670e+07,
         1.930000e+05,  1.933000e+05,  3.327100e+06,  3.329300e+06,
         2.467000e+05,  3.331400e+06,  6.230100e+06,  3.329300e+06,
         2.483000e+05,  2.483000e+05,  2.483000e+05,  2.482000e+05,
         2.545000e+05, -2.915000e+05, -2.913000e+05, -2.913000e+05,
        -1.748500e+06,  2.830000e+06,  3.079600e+06,  5.660000e+05,
         7.478000e+05,  7.524000e+05,  1.501600e+06,  1.503700e+06,
        -5.280000e+04, -1.589000e+05,  9.900000e+03,  1.654000e+05,
        -6.000000e+02, -2.400000e+04, -6.890000e+04,  4.960000e+05,
         1.900000e+03, -2.284000e+05,  0.000000e+00, -1.100000e+03,
        -2.700000e+03,  2.257000e+05, -8.910000e+04, -5.790000e+04,
         0.000000e+00,  0.000000e+00,  1.666000e+05, -1.708000e+05,
        -6.680000e+04,  5.180000e+04, -8.610000e+04,  0.000000e+00,
         1.727000e+05, -4.460000e+04,  2.000000e+03, -1.740000e+05,
        -1.740000e+05,  2.168000e+05, -6.330000e+04, -1.290000e+04,
         3.940000e+04, -2.374000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.100000e+03,  1.000000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.654000e+05, -1.589000e+05,
        -9.000000e+03,  2.483000e+05,  2.100000e+03,  7.069000e+05,
         2.524000e+05,  6.780000e+04,  9.570000e+05,  5.430000e+05,
         1.777000e+05,  2.467000e+05,  3.329300e+06,  1.933000e+05,
        -2.913000e+05,  3.079600e+06,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.483000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 7.017400e+06,  7.947000e+05,  1.244000e+06, -8.039000e+05,
         3.092400e+06,  3.026740e+07,  1.623490e+07,  6.874000e+06,
         7.947000e+05,  6.807900e+06,  7.946000e+05,  4.281700e+06,
         5.036000e+05, -1.939700e+06,  1.304000e+05,  4.141700e+06,
         9.880000e+04,  1.712690e+07,  1.015420e+07,  8.543000e+05,
         1.484100e+06, -1.531400e+06,  1.501000e+05,  9.156400e+06,
         7.811500e+06,  1.382820e+07,  1.597000e+06, -3.122100e+06,
        -8.852000e+05, -8.855000e+05, -8.936000e+05, -8.730000e+05,
        -1.893100e+06, -8.754000e+05,  2.386700e+06, -1.004390e+07,
        -9.173400e+06,  2.093200e+06, -1.004500e+06, -7.969000e+05,
         2.279300e+06, -2.551600e+06, -1.578400e+06, -1.578400e+06,
        -7.301000e+05,  1.133000e+05, -5.212000e+05, -7.281000e+05,
         8.119000e+05, -2.286700e+06,  1.954800e+06, -2.720700e+06,
         3.220300e+06, -6.744000e+05, -2.543300e+06,  7.302100e+06,
         7.312200e+06,  1.132500e+06,  1.522100e+06,  2.067660e+07,
         1.389000e+05,  1.195000e+06,  8.528000e+05,  8.086900e+06,
         8.086900e+06,  8.088800e+06,  8.086900e+06,  1.851300e+06,
         2.059000e+06,  4.179900e+06,  1.065500e+06, -2.981000e+05,
         5.444000e+05, -7.859000e+05, -1.802800e+06,  6.793000e+05,
         1.010200e+06,  1.010200e+06,  1.304000e+05,  1.304000e+05,
         1.304000e+05,  2.155740e+07,  5.974500e+06,  9.525500e+06,
         1.209410e+07,  1.259640e+07,  3.230900e+06,  4.943300e+06,
         2.936650e+07,  7.541800e+06,  2.936650e+07,  7.546000e+06,
         1.722400e+07,  6.088600e+06,  6.370000e+04, -6.354100e+06,
         3.175500e+06,  7.700000e+04,  1.043700e+07, -3.555500e+06,
         2.421500e+06, -6.808000e+05, -1.179000e+06, -2.680200e+06,
         7.318500e+06, -2.003600e+06, -1.351500e+06,  1.341700e+06,
         9.682200e+06,  1.612800e+07,  1.010930e+07,  2.214670e+07,
         6.347000e+05,  1.677900e+06,  5.294500e+06, -9.028000e+05,
         2.270200e+06,  1.319340e+07,  3.900500e+06,  7.209100e+06,
         2.286500e+06,  3.843500e+06,  1.259770e+07,  1.671000e+05,
        -6.019000e+05,  2.464000e+05,  1.111860e+07,  1.112090e+07,
         1.740500e+06,  4.023500e+06,  1.951670e+07,  2.013769e+08,
         7.493000e+05,  7.502000e+05, -1.622800e+06, -1.623900e+06,
        -7.490000e+05, -1.613800e+06, -3.418700e+06, -1.623900e+06,
         1.056500e+06,  1.056600e+06,  1.056600e+06,  1.056500e+06,
         1.134400e+06, -1.308400e+06, -1.307400e+06, -1.307600e+06,
        -7.848800e+06, -3.753400e+06, -2.688800e+06, -3.179100e+06,
         1.384500e+06,  1.404900e+06,  4.594600e+06,  4.604700e+06,
        -2.956000e+05, -7.943000e+05,  6.400000e+03,  2.119700e+06,
        -9.970000e+04, -1.615000e+05, -1.939700e+06,  4.281700e+06,
        -2.412000e+05, -2.974000e+06,  0.000000e+00,  9.000000e+02,
         7.820000e+04,  2.787700e+06, -1.135000e+05, -2.565000e+05,
         0.000000e+00,  0.000000e+00,  9.757000e+05, -2.068000e+06,
        -3.684000e+05,  8.858000e+05, -1.096000e+05,  0.000000e+00,
         2.198400e+06, -9.756000e+05, -1.153000e+05, -9.322000e+05,
        -9.324000e+05,  2.778300e+06, -1.397000e+05, -3.510000e+04,
         1.815600e+06, -1.077200e+06,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.010000e+04, -3.000000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.119700e+06, -7.943000e+05,
        -2.546000e+05,  1.056600e+06,  1.010000e+04,  7.017400e+06,
         7.947000e+05,  1.304000e+05,  8.086900e+06,  4.179900e+06,
        -8.738000e+05, -7.490000e+05, -1.623900e+06,  7.502000e+05,
        -1.307700e+06, -2.688800e+06,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.056500e+06,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 8.000000e+03,  4.120000e+04,  3.340000e+04, -1.000000e+02,
         4.000000e+03,  1.530000e+04, -8.000000e+02,  9.300000e+03,
         4.120000e+04,  9.800000e+03,  4.120000e+04,  2.920000e+04,
         1.780000e+04, -7.060000e+04,  2.660000e+04,  3.040000e+04,
         4.200000e+03,  1.169000e+05,  2.690000e+04,  7.500000e+04,
         6.590000e+04,  4.600000e+03,  6.860000e+04,  1.210000e+05,
         2.067000e+05,  3.089000e+05,  2.379000e+05, -8.000000e+03,
        -1.650000e+04, -1.620000e+04, -1.620000e+04, -1.650000e+04,
        -6.120000e+04, -1.630000e+04, -3.161000e+05, -2.505000e+05,
        -2.641000e+05, -3.880000e+04, -2.240000e+04, -2.590000e+04,
         3.800000e+03, -2.640000e+04, -4.200000e+03, -4.300000e+03,
         2.740000e+04,  5.890000e+04,  2.500000e+04,  7.200000e+03,
         6.300000e+03,  2.260000e+04,  1.810000e+05, -7.360000e+04,
         3.090000e+04,  2.660000e+04, -2.570000e+04,  8.650000e+04,
         8.640000e+04,  1.183000e+05,  1.125000e+05, -3.470000e+04,
         2.350000e+04,  8.000000e+04,  4.090000e+04,  6.450000e+04,
         6.450000e+04,  6.450000e+04,  6.450000e+04,  9.540000e+04,
        -3.740000e+04,  5.810000e+04,  7.430000e+04,  2.427000e+06,
         2.483800e+06,  2.473200e+06, -4.550000e+04,  5.530000e+04,
         3.880000e+04,  3.880000e+04,  2.660000e+04,  2.660000e+04,
         2.660000e+04,  2.673000e+05,  3.457000e+05,  6.230000e+04,
         2.300400e+06,  5.007800e+06,  5.107400e+06,  5.166800e+06,
         2.800000e+05,  3.881000e+05,  2.800000e+05,  3.879000e+05,
         7.520000e+04, -2.606000e+05, -3.627000e+05, -1.984000e+05,
         1.590000e+04,  3.220000e+04,  5.390000e+05, -5.880000e+04,
         4.400000e+04,  6.000000e+04,  2.432200e+06, -6.330000e+04,
        -5.390000e+04, -7.200000e+03, -1.490000e+04, -1.567000e+05,
         2.436400e+06, -2.050000e+04, -1.219000e+05,  8.100000e+04,
         6.070000e+04,  4.450000e+04, -2.240000e+04,  1.010000e+04,
         1.442000e+05,  1.511000e+05,  2.003000e+05,  4.840000e+04,
         1.461000e+05,  1.971000e+05,  1.507000e+05,  3.570000e+04,
         3.260000e+04,  6.430000e+04,  3.710000e+04,  3.710000e+04,
         8.870000e+04,  2.742000e+05,  1.930000e+05,  7.493000e+05,
         2.515300e+06,  2.509300e+06,  1.190000e+04,  1.200000e+04,
         6.500000e+03,  1.190000e+04, -1.400000e+04,  1.200000e+04,
         5.420000e+04,  5.420000e+04,  5.420000e+04,  5.410000e+04,
         5.360000e+04,  2.238800e+06,  2.237200e+06,  2.237500e+06,
         1.343010e+07, -9.900000e+04, -4.350000e+04, -6.400000e+03,
         1.149000e+05,  1.151000e+05,  2.774000e+05,  2.773000e+05,
         2.451000e+06, -2.550000e+04, -4.000000e+02, -1.600000e+04,
        -3.600000e+03, -3.100000e+03, -7.060000e+04,  2.920000e+04,
        -1.130000e+04,  2.430000e+04,  0.000000e+00,  0.000000e+00,
        -7.300000e+03, -2.150000e+04, -6.000000e+03, -1.230000e+04,
         0.000000e+00,  0.000000e+00, -9.250000e+04, -7.620000e+04,
        -1.720000e+04, -1.090000e+04, -5.800000e+03,  0.000000e+00,
        -1.670000e+04, -3.600000e+04, -5.700000e+03, -2.610000e+04,
        -2.610000e+04, -2.070000e+04, -5.200000e+03, -3.500000e+03,
        -4.670000e+04, -3.130000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02,  4.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02, -1.600000e+04, -2.550000e+04,
        -9.300000e+03,  5.420000e+04, -1.000000e+02,  8.000000e+03,
         4.120000e+04,  2.660000e+04,  6.450000e+04,  5.810000e+04,
        -1.650000e+04,  6.500000e+03,  1.200000e+04,  2.509300e+06,
         2.237600e+06, -4.350000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  5.420000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 8.000000e+03,  4.130000e+04,  3.340000e+04, -1.000000e+02,
         4.000000e+03,  1.520000e+04, -8.000000e+02,  9.300000e+03,
         4.130000e+04,  9.800000e+03,  4.130000e+04,  2.920000e+04,
         1.780000e+04, -7.070000e+04,  2.670000e+04,  3.040000e+04,
         4.200000e+03,  1.170000e+05,  2.700000e+04,  7.510000e+04,
         6.600000e+04,  4.600000e+03,  6.860000e+04,  1.212000e+05,
         2.070000e+05,  3.093000e+05,  2.381000e+05, -7.900000e+03,
        -1.660000e+04, -1.620000e+04, -1.620000e+04, -1.650000e+04,
        -6.130000e+04, -1.630000e+04, -3.163000e+05, -2.507000e+05,
        -2.643000e+05, -3.890000e+04, -2.250000e+04, -2.590000e+04,
         3.800000e+03, -2.640000e+04, -4.200000e+03, -4.200000e+03,
         2.740000e+04,  5.900000e+04,  2.500000e+04,  7.200000e+03,
         6.400000e+03,  2.260000e+04,  1.806000e+05, -7.360000e+04,
         3.100000e+04,  2.660000e+04, -2.570000e+04,  8.660000e+04,
         8.650000e+04,  1.184000e+05,  1.126000e+05, -3.470000e+04,
         2.350000e+04,  8.010000e+04,  4.090000e+04,  6.460000e+04,
         6.460000e+04,  6.460000e+04,  6.460000e+04,  9.550000e+04,
        -3.740000e+04,  5.820000e+04,  7.440000e+04,  2.429900e+06,
         2.477600e+06,  2.476200e+06, -4.560000e+04,  5.540000e+04,
         3.890000e+04,  3.890000e+04,  2.670000e+04,  2.670000e+04,
         2.670000e+04,  2.677000e+05,  3.461000e+05,  6.250000e+04,
         2.303000e+06,  5.014000e+06,  5.116200e+06,  5.154400e+06,
         2.804000e+05,  3.885000e+05,  2.804000e+05,  3.883000e+05,
         7.530000e+04, -2.608000e+05, -3.630000e+05, -1.986000e+05,
         1.590000e+04,  3.220000e+04,  5.396000e+05, -5.890000e+04,
         4.400000e+04,  6.010000e+04,  2.436100e+06, -6.340000e+04,
        -5.390000e+04, -7.200000e+03, -1.490000e+04, -1.568000e+05,
         2.440600e+06, -2.050000e+04, -1.221000e+05,  8.110000e+04,
         6.070000e+04,  4.460000e+04, -2.230000e+04,  1.010000e+04,
         1.444000e+05,  1.513000e+05,  2.006000e+05,  4.850000e+04,
         1.463000e+05,  1.974000e+05,  1.509000e+05,  3.570000e+04,
         3.260000e+04,  6.420000e+04,  3.720000e+04,  3.720000e+04,
         8.880000e+04,  2.745000e+05,  1.933000e+05,  7.502000e+05,
         2.509300e+06,  2.513600e+06,  1.200000e+04,  1.200000e+04,
         6.600000e+03,  1.190000e+04, -1.410000e+04,  1.200000e+04,
         5.420000e+04,  5.420000e+04,  5.420000e+04,  5.420000e+04,
         5.370000e+04,  2.241100e+06,  2.239500e+06,  2.239900e+06,
         1.344440e+07, -9.910000e+04, -4.360000e+04, -6.400000e+03,
         1.151000e+05,  1.152000e+05,  2.777000e+05,  2.776000e+05,
         2.455200e+06, -2.550000e+04, -4.000000e+02, -1.610000e+04,
        -3.700000e+03, -3.100000e+03, -7.070000e+04,  2.920000e+04,
        -1.130000e+04,  2.430000e+04,  0.000000e+00,  0.000000e+00,
        -7.300000e+03, -2.150000e+04, -6.000000e+03, -1.230000e+04,
         0.000000e+00,  0.000000e+00, -9.260000e+04, -7.620000e+04,
        -1.720000e+04, -1.090000e+04, -5.800000e+03,  0.000000e+00,
        -1.680000e+04, -3.610000e+04, -5.700000e+03, -2.610000e+04,
        -2.610000e+04, -2.070000e+04, -5.200000e+03, -3.500000e+03,
        -4.680000e+04, -3.130000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02,  4.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02, -1.610000e+04, -2.550000e+04,
        -9.300000e+03,  5.420000e+04, -1.000000e+02,  8.000000e+03,
         4.130000e+04,  2.670000e+04,  6.460000e+04,  5.820000e+04,
        -1.650000e+04,  6.600000e+03,  1.200000e+04,  2.513600e+06,
         2.240000e+06, -4.360000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  5.420000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-7.230000e+04,  1.050000e+04,  1.800000e+03,  1.180000e+04,
        -3.010000e+04, -3.204000e+05, -1.758000e+05, -7.030000e+04,
         1.050000e+04, -6.930000e+04,  1.050000e+04, -3.320000e+04,
         2.700000e+03, -9.700000e+03,  1.180000e+04, -3.110000e+04,
         9.000000e+02, -1.329000e+05, -1.011000e+05,  2.650000e+04,
         1.080000e+04,  2.600000e+04,  3.270000e+04, -5.020000e+04,
         6.915500e+06,  6.893000e+06,  7.001000e+06,  6.990000e+04,
         3.800000e+03,  3.900000e+03,  4.000000e+03,  3.000000e+03,
        -5.700000e+03,  3.800000e+03, -1.614000e+05,  8.700000e+03,
        -1.210000e+04, -3.930000e+04,  2.300000e+03, -2.000000e+03,
        -1.810000e+04,  2.390000e+04,  2.300000e+04,  2.300000e+04,
         2.640000e+04,  2.980000e+04,  2.090000e+04,  1.570000e+04,
         7.100000e+03,  4.920000e+04,  6.610000e+04,  1.000000e+03,
        -1.840000e+04,  2.360000e+04,  2.370000e+04, -4.060000e+04,
        -4.070000e+04,  4.550000e+04,  3.400000e+04, -2.386000e+05,
         1.190000e+04,  2.360000e+04,  9.500000e+03, -6.130000e+04,
        -6.130000e+04, -6.130000e+04, -6.130000e+04,  2.400000e+04,
        -3.970000e+04, -1.910000e+04,  2.290000e+04, -1.100000e+03,
         2.100000e+03,  2.450000e+04,  2.200000e+03,  2.160000e+04,
         6.900000e+03,  6.900000e+03,  1.180000e+04,  1.180000e+04,
         1.180000e+04, -1.174000e+05,  9.510000e+04, -7.460000e+04,
        -1.297000e+05, -8.120000e+04,  4.630000e+04,  5.390000e+04,
        -2.014000e+05,  9.700000e+04, -2.014000e+05,  9.730000e+04,
        -1.604000e+05, -1.825000e+05, -1.608000e+05, -1.170000e+04,
        -2.700000e+04,  1.500000e+04,  1.361000e+05,  6.919400e+06,
         6.897500e+06,  6.940900e+06,  2.300000e+03,  6.100000e+03,
         6.778500e+06,  6.924800e+06,  6.890400e+06,  6.801000e+06,
        -1.132000e+05, -1.859000e+05, -1.646000e+05, -2.073000e+05,
         2.430000e+04,  6.000000e+02, -6.750000e+04,  1.660000e+04,
         4.370000e+04, -7.900000e+04,  4.600000e+04, -5.780000e+04,
         4.440000e+04,  4.940000e+04, -6.580000e+04,  1.660000e+04,
         2.760000e+04,  3.100000e+04, -1.041000e+05, -1.041000e+05,
         2.230000e+04,  3.537300e+06,  3.327100e+06, -1.622800e+06,
         1.190000e+04,  1.200000e+04,  6.935600e+06,  6.929600e+06,
         1.590000e+04,  6.929500e+06,  1.384190e+07,  6.929600e+06,
         1.350000e+04,  1.350000e+04,  1.350000e+04,  1.350000e+04,
         1.220000e+04, -1.120000e+04, -1.120000e+04, -1.120000e+04,
        -6.730000e+04,  6.904000e+06,  6.916800e+06,  4.760000e+04,
         4.270000e+04,  4.260000e+04,  8.290000e+04,  8.290000e+04,
        -1.600000e+03, -1.500000e+03, -3.000000e+02, -3.010000e+04,
        -5.000000e+02,  4.000000e+02, -9.700000e+03, -3.320000e+04,
        -2.500000e+03,  4.170000e+04,  0.000000e+00,  0.000000e+00,
        -5.700000e+03, -3.990000e+04, -1.800000e+03, -2.900000e+03,
         0.000000e+00,  0.000000e+00, -5.120000e+04, -1.100000e+04,
        -3.900000e+03, -1.460000e+04, -1.700000e+03,  0.000000e+00,
        -3.110000e+04, -5.100000e+03, -1.300000e+03,  0.000000e+00,
         0.000000e+00, -3.940000e+04, -1.000000e+03, -1.200000e+03,
        -3.890000e+04, -9.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02,  2.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.010000e+04, -1.500000e+03,
        -1.300000e+03,  1.350000e+04, -1.000000e+02, -7.230000e+04,
         1.050000e+04,  1.180000e+04, -6.130000e+04, -1.910000e+04,
         3.000000e+03,  1.590000e+04,  6.929600e+06,  1.200000e+04,
        -1.120000e+04,  6.916800e+06,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.350000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-7.240000e+04,  1.050000e+04,  1.800000e+03,  1.180000e+04,
        -3.010000e+04, -3.206000e+05, -1.759000e+05, -7.040000e+04,
         1.050000e+04, -6.940000e+04,  1.050000e+04, -3.330000e+04,
         2.700000e+03, -9.700000e+03,  1.180000e+04, -3.110000e+04,
         9.000000e+02, -1.330000e+05, -1.012000e+05,  2.650000e+04,
         1.080000e+04,  2.600000e+04,  3.280000e+04, -5.030000e+04,
         6.920000e+06,  6.897600e+06,  7.005600e+06,  7.000000e+04,
         3.800000e+03,  3.900000e+03,  4.000000e+03,  3.000000e+03,
        -5.700000e+03,  3.800000e+03, -1.615000e+05,  8.700000e+03,
        -1.220000e+04, -3.940000e+04,  2.300000e+03, -2.000000e+03,
        -1.810000e+04,  2.390000e+04,  2.300000e+04,  2.300000e+04,
         2.640000e+04,  2.980000e+04,  2.090000e+04,  1.580000e+04,
         7.100000e+03,  4.920000e+04,  6.610000e+04,  1.000000e+03,
        -1.840000e+04,  2.360000e+04,  2.380000e+04, -4.060000e+04,
        -4.070000e+04,  4.550000e+04,  3.400000e+04, -2.388000e+05,
         1.190000e+04,  2.360000e+04,  9.500000e+03, -6.130000e+04,
        -6.130000e+04, -6.130000e+04, -6.130000e+04,  2.400000e+04,
        -3.970000e+04, -1.910000e+04,  2.290000e+04, -1.100000e+03,
         2.100000e+03,  2.450000e+04,  2.200000e+03,  2.160000e+04,
         6.900000e+03,  6.900000e+03,  1.180000e+04,  1.180000e+04,
         1.180000e+04, -1.175000e+05,  9.520000e+04, -7.460000e+04,
        -1.297000e+05, -8.120000e+04,  4.640000e+04,  5.390000e+04,
        -2.016000e+05,  9.700000e+04, -2.016000e+05,  9.740000e+04,
        -1.605000e+05, -1.827000e+05, -1.610000e+05, -1.170000e+04,
        -2.700000e+04,  1.500000e+04,  1.362000e+05,  6.924000e+06,
         6.902000e+06,  6.945400e+06,  2.300000e+03,  6.200000e+03,
         6.783000e+06,  6.929300e+06,  6.895000e+06,  6.805500e+06,
        -1.132000e+05, -1.861000e+05, -1.647000e+05, -2.074000e+05,
         2.430000e+04,  6.000000e+02, -6.750000e+04,  1.660000e+04,
         4.370000e+04, -7.910000e+04,  4.600000e+04, -5.790000e+04,
         4.450000e+04,  4.940000e+04, -6.580000e+04,  1.660000e+04,
         2.770000e+04,  3.100000e+04, -1.041000e+05, -1.041000e+05,
         2.240000e+04,  3.539700e+06,  3.329300e+06, -1.623900e+06,
         1.200000e+04,  1.200000e+04,  6.929600e+06,  6.934200e+06,
         1.590000e+04,  6.934100e+06,  1.385100e+07,  6.934200e+06,
         1.350000e+04,  1.350000e+04,  1.350000e+04,  1.350000e+04,
         1.220000e+04, -1.120000e+04, -1.120000e+04, -1.120000e+04,
        -6.740000e+04,  6.908600e+06,  6.921400e+06,  4.770000e+04,
         4.280000e+04,  4.260000e+04,  8.300000e+04,  8.290000e+04,
        -1.600000e+03, -1.500000e+03, -3.000000e+02, -3.020000e+04,
        -5.000000e+02,  4.000000e+02, -9.700000e+03, -3.330000e+04,
        -2.500000e+03,  4.170000e+04,  0.000000e+00,  0.000000e+00,
        -5.700000e+03, -3.990000e+04, -1.800000e+03, -2.900000e+03,
         0.000000e+00,  0.000000e+00, -5.120000e+04, -1.100000e+04,
        -3.900000e+03, -1.460000e+04, -1.700000e+03,  0.000000e+00,
        -3.110000e+04, -5.100000e+03, -1.300000e+03,  0.000000e+00,
         0.000000e+00, -3.940000e+04, -1.000000e+03, -1.200000e+03,
        -3.890000e+04, -9.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02,  2.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.020000e+04, -1.500000e+03,
        -1.300000e+03,  1.350000e+04, -1.000000e+02, -7.240000e+04,
         1.050000e+04,  1.180000e+04, -6.130000e+04, -1.910000e+04,
         3.000000e+03,  1.590000e+04,  6.934200e+06,  1.200000e+04,
        -1.120000e+04,  6.921400e+06,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.350000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-3.920000e+04,  4.700000e+03,  9.200000e+03,  2.720000e+05,
         1.162000e+05, -1.783000e+05, -9.990000e+04, -3.780000e+04,
         4.700000e+03, -3.710000e+04,  4.700000e+03, -1.240000e+04,
         3.400000e+03,  3.400000e+05,  1.489000e+05, -1.110000e+04,
         9.000000e+02, -4.970000e+04,  3.115000e+05,  3.738000e+05,
         3.855000e+05,  8.438000e+05,  4.320000e+05,  1.000000e+02,
         7.701000e+05,  4.195000e+05,  8.130000e+05,  4.946400e+06,
         3.589000e+05,  3.597000e+05,  3.590000e+05,  3.582000e+05,
         4.342000e+05,  3.596000e+05,  3.090200e+06,  3.176200e+06,
         3.188800e+06,  3.306000e+05,  3.505000e+05,  3.553000e+05,
         3.880000e+05,  6.683000e+05,  9.017000e+05,  9.019000e+05,
         7.016000e+05,  4.972000e+05,  6.910000e+05,  5.464000e+05,
         1.573600e+06,  1.593900e+06,  5.924000e+05,  6.429000e+05,
         2.654000e+05,  4.212000e+05,  6.693000e+05,  7.165000e+05,
         7.164000e+05,  7.592000e+05,  7.658000e+05, -1.433000e+05,
         1.718000e+05,  1.746000e+05,  1.430000e+04, -1.960000e+04,
        -1.960000e+04, -1.960000e+04, -1.960000e+04,  2.340000e+04,
         3.315000e+05,  1.437000e+05,  1.652000e+05, -1.120000e+04,
        -1.968000e+05, -1.677000e+05,  5.079000e+05,  3.277000e+05,
         1.240000e+04,  1.240000e+04,  1.489000e+05,  1.488000e+05,
         1.489000e+05,  2.782000e+05,  3.841000e+05,  1.006000e+06,
         5.893000e+05, -3.280000e+04,  2.950000e+04, -3.413000e+05,
        -4.960000e+04,  1.008000e+05, -4.960000e+04,  1.005000e+05,
         6.466000e+05,  1.287600e+06,  1.638500e+06,  1.373400e+06,
         3.498000e+05,  3.700000e+05,  9.840000e+04,  3.569000e+05,
         6.000000e+03,  2.680000e+04,  3.471000e+05,  8.886000e+05,
        -7.160000e+04, -5.400000e+03,  2.400000e+03,  2.795000e+05,
        -8.180000e+04,  2.531000e+05,  6.046000e+05, -9.840000e+04,
         3.543000e+05,  3.764000e+05,  6.810000e+05,  7.214000e+05,
         4.095000e+05, -1.040000e+04,  4.910000e+04,  3.403000e+05,
         4.150000e+05,  5.370000e+04, -1.140000e+04,  3.700000e+05,
         7.094000e+05,  5.091000e+05, -5.070000e+04, -5.070000e+04,
         1.630000e+04,  3.479000e+05,  2.467000e+05, -7.490000e+05,
         6.500000e+03,  6.600000e+03,  1.590000e+04,  1.590000e+04,
         5.571000e+05,  1.580000e+04, -3.466000e+05,  1.590000e+04,
         1.870000e+04,  1.870000e+04,  1.870000e+04,  1.870000e+04,
         1.830000e+04, -2.250000e+04, -2.250000e+04, -2.250000e+04,
        -1.351000e+05, -2.270000e+04, -3.400000e+03,  1.794300e+06,
         5.909000e+05,  5.870000e+05,  6.429000e+05,  6.428000e+05,
        -1.220000e+04,  1.170000e+05, -9.000000e+03, -2.070000e+04,
        -4.000000e+03,  0.000000e+00,  3.400000e+05, -1.240000e+04,
        -1.340000e+04,  2.940000e+04,  0.000000e+00, -1.000000e+02,
        -1.010000e+04, -3.800000e+04, -1.640000e+04, -4.300000e+03,
         0.000000e+00,  0.000000e+00,  3.131000e+05,  3.327000e+05,
        -2.080000e+04, -1.380000e+04, -1.580000e+04,  0.000000e+00,
        -2.140000e+04,  1.678000e+05, -6.700000e+03,  1.241000e+05,
         1.241000e+05, -3.000000e+04, -8.300000e+03, -1.900000e+03,
         9.510000e+04,  1.160000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02, -1.000000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -2.070000e+04,  1.170000e+05,
         4.460000e+04,  1.870000e+04, -1.000000e+02, -3.920000e+04,
         4.700000e+03,  1.488000e+05, -1.960000e+04,  1.437000e+05,
         3.583000e+05,  5.571000e+05,  1.590000e+04,  6.600000e+03,
        -2.250000e+04, -3.400000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.870000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-7.250000e+04,  1.040000e+04,  1.800000e+03,  1.180000e+04,
        -3.020000e+04, -3.206000e+05, -1.757000e+05, -7.050000e+04,
         1.040000e+04, -6.950000e+04,  1.040000e+04, -3.330000e+04,
         2.600000e+03, -9.700000e+03,  1.180000e+04, -3.120000e+04,
         9.000000e+02, -1.333000e+05, -1.014000e+05,  2.630000e+04,
         1.070000e+04,  2.590000e+04,  3.270000e+04, -5.050000e+04,
         6.919500e+06,  6.897000e+06,  7.005100e+06,  7.150000e+04,
         3.700000e+03,  3.800000e+03,  4.000000e+03,  2.900000e+03,
        -5.800000e+03,  4.100000e+03, -1.613000e+05,  9.100000e+03,
        -1.180000e+04, -3.900000e+04,  2.700000e+03, -1.700000e+03,
        -1.810000e+04,  2.400000e+04,  2.310000e+04,  2.310000e+04,
         2.650000e+04,  2.990000e+04,  2.100000e+04,  1.650000e+04,
         8.400000e+03,  5.050000e+04,  6.740000e+04,  1.000000e+03,
        -1.850000e+04,  2.360000e+04,  2.380000e+04, -4.100000e+04,
        -4.060000e+04,  4.520000e+04,  3.370000e+04, -2.378000e+05,
         1.190000e+04,  2.350000e+04,  9.500000e+03, -6.150000e+04,
        -6.150000e+04, -6.150000e+04, -6.150000e+04,  2.390000e+04,
        -3.980000e+04, -1.920000e+04,  2.280000e+04, -1.100000e+03,
         2.100000e+03,  2.450000e+04,  2.200000e+03,  2.150000e+04,
         6.900000e+03,  6.900000e+03,  1.180000e+04,  1.180000e+04,
         1.180000e+04, -1.175000e+05,  9.530000e+04, -7.460000e+04,
        -1.296000e+05, -8.120000e+04,  4.650000e+04,  5.410000e+04,
        -2.017000e+05,  9.710000e+04, -2.017000e+05,  9.740000e+04,
        -1.605000e+05, -1.829000e+05, -1.611000e+05, -1.180000e+04,
        -2.630000e+04,  1.580000e+04,  1.377000e+05,  6.924300e+06,
         6.902300e+06,  6.945700e+06,  2.700000e+03,  6.500000e+03,
         6.783200e+06,  6.929700e+06,  6.895400e+06,  6.805800e+06,
        -1.130000e+05, -1.847000e+05, -1.632000e+05, -2.061000e+05,
         2.590000e+04,  2.200000e+03, -6.610000e+04,  1.810000e+04,
         4.390000e+04, -7.890000e+04,  4.620000e+04, -5.770000e+04,
         4.470000e+04,  4.960000e+04, -6.570000e+04,  1.730000e+04,
         2.800000e+04,  3.140000e+04, -1.035000e+05, -1.035000e+05,
         2.310000e+04,  3.541900e+06,  3.331400e+06, -1.613800e+06,
         1.190000e+04,  1.190000e+04,  6.929500e+06,  6.934100e+06,
         1.580000e+04,  7.002100e+06,  1.385100e+07,  6.934100e+06,
         1.340000e+04,  1.340000e+04,  1.340000e+04,  1.340000e+04,
         1.220000e+04, -1.120000e+04, -1.120000e+04, -1.120000e+04,
        -6.720000e+04,  6.908600e+06,  6.921400e+06,  4.750000e+04,
         4.340000e+04,  4.410000e+04,  8.520000e+04,  8.550000e+04,
        -1.200000e+03, -1.500000e+03, -3.000000e+02, -3.020000e+04,
        -5.000000e+02,  4.000000e+02, -9.700000e+03, -3.330000e+04,
        -2.500000e+03,  4.170000e+04,  0.000000e+00,  0.000000e+00,
        -5.700000e+03, -3.990000e+04, -1.800000e+03, -2.800000e+03,
         0.000000e+00,  0.000000e+00, -5.120000e+04, -1.100000e+04,
        -3.900000e+03, -1.470000e+04, -1.700000e+03,  0.000000e+00,
        -3.070000e+04, -4.900000e+03, -1.100000e+03,  1.000000e+02,
         1.000000e+02, -3.940000e+04, -1.000000e+03, -1.200000e+03,
        -3.890000e+04, -8.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.000000e+02,  2.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.020000e+04, -1.500000e+03,
        -1.300000e+03,  1.340000e+04,  4.000000e+02, -7.250000e+04,
         1.040000e+04,  1.180000e+04, -6.150000e+04, -1.920000e+04,
         3.000000e+03,  1.580000e+04,  6.934100e+06,  1.190000e+04,
        -1.120000e+04,  6.921400e+06,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.340000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-1.320000e+05, -1.040000e+04, -2.480000e+04,  7.470000e+04,
        -2.850000e+04, -5.680000e+05, -3.039000e+05, -1.295000e+05,
        -1.040000e+04, -1.283000e+05, -1.040000e+04, -8.240000e+04,
        -9.200000e+03, -3.555000e+05,  2.630000e+04, -7.990000e+04,
        -1.800000e+03, -3.296000e+05, -5.904000e+05, -4.017000e+05,
        -4.291000e+05, -2.673000e+05,  9.010000e+04, -1.833000e+05,
         1.286970e+07,  1.314280e+07,  1.299510e+07, -1.494800e+06,
        -3.782000e+05, -3.793000e+05, -3.774000e+05, -3.793000e+05,
        -4.562000e+05, -3.793000e+05, -3.596100e+06, -3.347100e+06,
        -3.380900e+06, -4.334000e+05, -3.701000e+05, -3.796000e+05,
         4.670000e+04,  1.981000e+05, -4.943000e+05, -4.943000e+05,
        -3.137000e+05, -1.342000e+05, -3.213000e+05, -3.477000e+05,
        -8.680000e+05, -8.049000e+05,  9.820000e+04, -2.743000e+05,
        -2.600000e+03,  1.011000e+05,  1.973000e+05, -9.350000e+05,
        -9.350000e+05, -8.086000e+05, -8.274000e+05, -3.844000e+05,
         2.800000e+04,  4.200000e+03, -1.790000e+04, -1.577000e+05,
        -1.577000e+05, -1.577000e+05, -1.577000e+05, -3.270000e+04,
        -4.323000e+05, -5.230000e+04,  9.200000e+03,  9.100000e+03,
         1.909000e+05,  2.124000e+05, -3.259000e+05, -1.940000e+05,
        -2.070000e+04, -2.070000e+04,  2.630000e+04,  2.630000e+04,
         2.630000e+04, -3.643000e+05, -5.290000e+04, -9.128000e+05,
        -5.521000e+05, -2.413000e+05, -5.480000e+04,  3.131000e+05,
        -5.745000e+05, -1.371000e+05, -5.745000e+05, -1.368000e+05,
        -1.121300e+06, -1.680300e+06, -1.954900e+06, -1.429700e+06,
        -4.581000e+05, -3.950000e+05, -1.621000e+05,  1.349460e+07,
         1.377000e+07,  1.383470e+07, -3.700000e+05, -7.039000e+05,
         1.364400e+07,  1.386870e+07,  1.380540e+07,  1.336980e+07,
        -1.737000e+05, -6.977000e+05, -9.729000e+05, -4.225000e+05,
        -3.821000e+05, -4.287000e+05, -8.939000e+05, -7.677000e+05,
        -4.395000e+05, -2.594000e+05, -6.960000e+04, -5.371000e+05,
        -4.445000e+05, -7.140000e+04, -2.460000e+05, -3.926000e+05,
        -3.181000e+05, -1.374000e+05, -2.108000e+05, -2.108000e+05,
        -2.670000e+04,  6.545600e+06,  6.230100e+06, -3.418700e+06,
        -1.400000e+04, -1.410000e+04,  1.384190e+07,  1.385100e+07,
        -3.466000e+05,  1.385100e+07,  3.692460e+07,  1.826080e+07,
        -2.230000e+04, -2.230000e+04, -2.230000e+04, -2.370000e+04,
        -2.520000e+04,  3.450000e+04,  3.440000e+04,  3.450000e+04,
         2.068000e+05,  1.389750e+07,  1.387430e+07, -9.919000e+05,
        -3.916000e+05, -3.920000e+05, -4.590000e+05, -4.590000e+05,
         8.300000e+03,  4.370000e+04, -2.500000e+03, -3.860000e+04,
         4.400000e+03,  3.300000e+03, -3.555000e+05, -8.240000e+04,
         1.030000e+04,  5.320000e+04,  0.000000e+00,  0.000000e+00,
        -4.000000e+03, -5.380000e+04,  4.100000e+03,  5.400000e+03,
         0.000000e+00,  0.000000e+00, -4.067000e+05, -3.484000e+05,
         1.720000e+04, -1.410000e+04,  4.000000e+03,  0.000000e+00,
        -3.980000e+04, -1.755000e+05,  5.200000e+03,  4.800000e+04,
         4.800000e+04, -5.150000e+04,  6.700000e+03,  7.000000e+02,
        -2.800000e+03,  5.480000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.860000e+04,  4.370000e+04,
        -4.670000e+04, -2.230000e+04,  0.000000e+00, -1.320000e+05,
        -1.040000e+04,  2.630000e+04, -1.577000e+05, -5.230000e+04,
        -3.792000e+05, -3.466000e+05,  1.385100e+07, -1.410000e+04,
         3.450000e+04,  1.387430e+07,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.230000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-7.240000e+04,  1.050000e+04,  1.800000e+03,  1.180000e+04,
        -3.010000e+04, -3.206000e+05, -1.759000e+05, -7.040000e+04,
         1.050000e+04, -6.940000e+04,  1.050000e+04, -3.330000e+04,
         2.700000e+03, -9.700000e+03,  1.180000e+04, -3.110000e+04,
         9.000000e+02, -1.330000e+05, -1.012000e+05,  2.650000e+04,
         1.080000e+04,  2.600000e+04,  3.280000e+04, -5.030000e+04,
         6.920000e+06,  6.897600e+06,  7.005600e+06,  7.000000e+04,
         3.800000e+03,  3.900000e+03,  4.000000e+03,  3.000000e+03,
        -5.700000e+03,  3.800000e+03, -1.615000e+05,  8.700000e+03,
        -1.220000e+04, -3.940000e+04,  2.300000e+03, -2.000000e+03,
        -1.810000e+04,  2.390000e+04,  2.300000e+04,  2.300000e+04,
         2.640000e+04,  2.980000e+04,  2.090000e+04,  1.580000e+04,
         7.100000e+03,  4.920000e+04,  6.610000e+04,  1.000000e+03,
        -1.840000e+04,  2.360000e+04,  2.380000e+04, -4.060000e+04,
        -4.070000e+04,  4.550000e+04,  3.400000e+04, -2.388000e+05,
         1.190000e+04,  2.360000e+04,  9.500000e+03, -6.130000e+04,
        -6.130000e+04, -6.130000e+04, -6.130000e+04,  2.400000e+04,
        -3.970000e+04, -1.910000e+04,  2.290000e+04, -1.100000e+03,
         2.100000e+03,  2.450000e+04,  2.200000e+03,  2.160000e+04,
         6.900000e+03,  6.900000e+03,  1.180000e+04,  1.180000e+04,
         1.180000e+04, -1.175000e+05,  9.520000e+04, -7.460000e+04,
        -1.297000e+05, -8.120000e+04,  4.640000e+04,  5.390000e+04,
        -2.016000e+05,  9.700000e+04, -2.016000e+05,  9.740000e+04,
        -1.605000e+05, -1.827000e+05, -1.610000e+05, -1.170000e+04,
        -2.700000e+04,  1.500000e+04,  1.362000e+05,  6.924000e+06,
         6.902000e+06,  6.945400e+06,  2.300000e+03,  6.200000e+03,
         6.783000e+06,  6.929300e+06,  6.895000e+06,  6.805500e+06,
        -1.132000e+05, -1.861000e+05, -1.647000e+05, -2.074000e+05,
         2.430000e+04,  6.000000e+02, -6.750000e+04,  1.660000e+04,
         4.370000e+04, -7.910000e+04,  4.600000e+04, -5.790000e+04,
         4.450000e+04,  4.940000e+04, -6.580000e+04,  1.660000e+04,
         2.770000e+04,  3.100000e+04, -1.041000e+05, -1.041000e+05,
         2.240000e+04,  3.539700e+06,  3.329300e+06, -1.623900e+06,
         1.200000e+04,  1.200000e+04,  6.929600e+06,  6.934200e+06,
         1.590000e+04,  6.934100e+06,  1.826080e+07,  2.459140e+07,
         1.350000e+04,  1.350000e+04,  1.350000e+04,  1.350000e+04,
         1.220000e+04, -1.120000e+04, -1.120000e+04, -1.120000e+04,
        -6.740000e+04,  6.908600e+06,  6.921400e+06,  4.770000e+04,
         4.280000e+04,  4.260000e+04,  8.300000e+04,  8.290000e+04,
        -1.600000e+03, -1.500000e+03, -3.000000e+02, -3.020000e+04,
        -5.000000e+02,  4.000000e+02, -9.700000e+03, -3.330000e+04,
        -2.500000e+03,  4.170000e+04,  0.000000e+00,  0.000000e+00,
        -5.700000e+03, -3.990000e+04, -1.800000e+03, -2.900000e+03,
         0.000000e+00,  0.000000e+00, -5.120000e+04, -1.100000e+04,
        -3.900000e+03, -1.460000e+04, -1.700000e+03,  0.000000e+00,
        -3.110000e+04, -5.100000e+03, -1.300000e+03,  0.000000e+00,
         0.000000e+00, -3.940000e+04, -1.000000e+03, -1.200000e+03,
        -3.890000e+04, -9.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02,  2.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.020000e+04, -1.500000e+03,
        -1.300000e+03,  1.350000e+04, -1.000000e+02, -7.240000e+04,
         1.050000e+04,  1.180000e+04, -6.130000e+04, -1.910000e+04,
         3.000000e+03,  1.590000e+04,  6.934200e+06,  1.200000e+04,
        -1.120000e+04,  6.921400e+06,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.350000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.740000e+04,  4.990000e+04,  4.090000e+04,  6.700000e+03,
         1.210000e+04,  5.290000e+04,  1.800000e+04,  1.860000e+04,
         4.990000e+04,  1.920000e+04,  4.990000e+04,  3.910000e+04,
         2.160000e+04, -8.150000e+04,  3.490000e+04,  4.040000e+04,
         5.100000e+03,  1.564000e+05,  4.070000e+04,  9.320000e+04,
         7.730000e+04,  2.300000e+04,  9.090000e+04,  1.449000e+05,
         2.593000e+05,  3.810000e+05,  2.936000e+05,  9.720000e+04,
        -1.610000e+04, -1.610000e+04, -1.590000e+04, -1.650000e+04,
        -6.930000e+04, -1.610000e+04, -3.414000e+05, -2.717000e+05,
        -2.926000e+05, -4.010000e+04, -2.360000e+04, -2.790000e+04,
         1.900000e+04, -1.420000e+04,  1.270000e+04,  1.270000e+04,
         4.670000e+04,  8.060000e+04,  4.110000e+04,  1.870000e+04,
         4.190000e+04,  5.890000e+04,  2.287000e+05, -7.650000e+04,
         4.700000e+04,  4.170000e+04, -1.380000e+04,  1.149000e+05,
         1.149000e+05,  1.497000e+05,  1.393000e+05, -1.620000e+04,
         3.440000e+04,  9.800000e+04,  4.940000e+04,  8.120000e+04,
         8.120000e+04,  8.120000e+04,  8.120000e+04,  1.153000e+05,
        -4.030000e+04,  7.500000e+04,  9.160000e+04, -1.040000e+04,
         2.290000e+04,  4.180000e+04, -4.660000e+04,  7.460000e+04,
         4.720000e+04,  4.720000e+04,  3.490000e+04,  3.490000e+04,
         3.490000e+04,  3.365000e+05,  4.216000e+05,  9.320000e+04,
         1.660000e+04,  1.655000e+05,  2.160000e+05,  2.857000e+05,
         3.489000e+05,  4.684000e+05,  3.489000e+05,  4.691000e+05,
         1.064000e+05, -2.898000e+05, -4.113000e+05, -2.212000e+05,
         2.430000e+04,  4.120000e+04,  6.516000e+05, -6.810000e+04,
         5.400000e+04,  7.160000e+04, -2.720000e+04, -6.280000e+04,
        -6.080000e+04, -9.600000e+03, -2.420000e+04, -1.829000e+05,
        -1.530000e+04, -6.400000e+03, -1.281000e+05,  1.154000e+05,
         7.850000e+04,  5.460000e+04, -1.690000e+04,  1.700000e+04,
         1.781000e+05,  1.864000e+05,  2.360000e+05,  6.460000e+04,
         1.803000e+05,  2.384000e+05,  1.946000e+05,  4.700000e+04,
         5.350000e+04,  8.750000e+04,  5.550000e+04,  5.550000e+04,
         1.075000e+05,  3.332000e+05,  2.483000e+05,  1.056500e+06,
         5.420000e+04,  5.420000e+04,  1.350000e+04,  1.350000e+04,
         1.870000e+04,  1.340000e+04, -2.230000e+04,  1.350000e+04,
         6.540000e+04,  6.540000e+04,  6.540000e+04,  6.540000e+04,
         6.460000e+04, -7.030000e+04, -7.030000e+04, -7.030000e+04,
        -4.217000e+05, -1.154000e+05, -5.100000e+04,  2.830000e+04,
         1.495000e+05,  1.494000e+05,  3.456000e+05,  3.456000e+05,
        -1.120000e+04, -2.740000e+04, -7.000000e+02, -1.640000e+04,
        -4.300000e+03, -3.800000e+03, -8.150000e+04,  3.910000e+04,
        -1.370000e+04,  2.320000e+04,  0.000000e+00,  0.000000e+00,
        -1.060000e+04, -2.230000e+04, -7.800000e+03, -1.480000e+04,
         0.000000e+00,  0.000000e+00, -1.043000e+05, -8.860000e+04,
        -2.090000e+04, -1.200000e+04, -7.500000e+03,  0.000000e+00,
        -1.690000e+04, -4.160000e+04, -6.800000e+03, -2.770000e+04,
        -2.770000e+04, -2.110000e+04, -6.500000e+03, -4.200000e+03,
        -4.870000e+04, -3.420000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02,  5.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.640000e+04, -2.740000e+04,
        -1.070000e+04,  6.540000e+04, -1.000000e+02,  1.740000e+04,
         4.990000e+04,  3.490000e+04,  8.120000e+04,  7.500000e+04,
        -1.650000e+04,  1.870000e+04,  1.350000e+04,  5.420000e+04,
        -7.030000e+04, -5.100000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  6.540000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.740000e+04,  4.990000e+04,  4.090000e+04,  6.700000e+03,
         1.210000e+04,  5.290000e+04,  1.800000e+04,  1.860000e+04,
         4.990000e+04,  1.920000e+04,  4.990000e+04,  3.910000e+04,
         2.160000e+04, -8.150000e+04,  3.490000e+04,  4.040000e+04,
         5.100000e+03,  1.564000e+05,  4.070000e+04,  9.320000e+04,
         7.730000e+04,  2.300000e+04,  9.090000e+04,  1.449000e+05,
         2.593000e+05,  3.810000e+05,  2.936000e+05,  9.720000e+04,
        -1.610000e+04, -1.610000e+04, -1.590000e+04, -1.650000e+04,
        -6.930000e+04, -1.610000e+04, -3.414000e+05, -2.717000e+05,
        -2.926000e+05, -4.010000e+04, -2.360000e+04, -2.790000e+04,
         1.900000e+04, -1.420000e+04,  1.270000e+04,  1.270000e+04,
         4.670000e+04,  8.060000e+04,  4.110000e+04,  1.870000e+04,
         4.190000e+04,  5.890000e+04,  2.287000e+05, -7.650000e+04,
         4.700000e+04,  4.170000e+04, -1.380000e+04,  1.149000e+05,
         1.149000e+05,  1.497000e+05,  1.393000e+05, -1.620000e+04,
         3.440000e+04,  9.800000e+04,  4.950000e+04,  8.120000e+04,
         8.120000e+04,  8.120000e+04,  8.120000e+04,  1.153000e+05,
        -4.030000e+04,  7.500000e+04,  9.160000e+04, -1.040000e+04,
         2.290000e+04,  4.180000e+04, -4.660000e+04,  7.460000e+04,
         4.720000e+04,  4.720000e+04,  3.490000e+04,  3.490000e+04,
         3.490000e+04,  3.365000e+05,  4.216000e+05,  9.320000e+04,
         1.660000e+04,  1.655000e+05,  2.160000e+05,  2.857000e+05,
         3.489000e+05,  4.684000e+05,  3.489000e+05,  4.691000e+05,
         1.064000e+05, -2.898000e+05, -4.113000e+05, -2.212000e+05,
         2.430000e+04,  4.120000e+04,  6.515000e+05, -6.810000e+04,
         5.400000e+04,  7.160000e+04, -2.720000e+04, -6.280000e+04,
        -6.080000e+04, -9.600000e+03, -2.420000e+04, -1.829000e+05,
        -1.530000e+04, -6.400000e+03, -1.281000e+05,  1.154000e+05,
         7.850000e+04,  5.460000e+04, -1.690000e+04,  1.700000e+04,
         1.781000e+05,  1.864000e+05,  2.360000e+05,  6.460000e+04,
         1.803000e+05,  2.384000e+05,  1.946000e+05,  4.700000e+04,
         5.350000e+04,  8.750000e+04,  5.550000e+04,  5.550000e+04,
         1.075000e+05,  3.332000e+05,  2.483000e+05,  1.056600e+06,
         5.420000e+04,  5.420000e+04,  1.350000e+04,  1.350000e+04,
         1.870000e+04,  1.340000e+04, -2.230000e+04,  1.350000e+04,
         6.540000e+04,  6.560000e+04,  6.560000e+04,  6.540000e+04,
         6.460000e+04, -7.030000e+04, -7.020000e+04, -7.030000e+04,
        -4.217000e+05, -1.154000e+05, -5.100000e+04,  2.830000e+04,
         1.495000e+05,  1.494000e+05,  3.456000e+05,  3.455000e+05,
        -1.120000e+04, -2.740000e+04, -7.000000e+02, -1.640000e+04,
        -4.300000e+03, -3.800000e+03, -8.150000e+04,  3.910000e+04,
        -1.370000e+04,  2.310000e+04,  0.000000e+00,  0.000000e+00,
        -1.060000e+04, -2.230000e+04, -7.800000e+03, -1.490000e+04,
         0.000000e+00,  0.000000e+00, -1.043000e+05, -8.860000e+04,
        -2.090000e+04, -1.200000e+04, -7.500000e+03,  0.000000e+00,
        -1.690000e+04, -4.160000e+04, -6.800000e+03, -2.770000e+04,
        -2.770000e+04, -2.110000e+04, -6.500000e+03, -4.200000e+03,
        -4.870000e+04, -3.420000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02,  5.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.640000e+04, -2.740000e+04,
        -1.070000e+04,  6.550000e+04, -1.000000e+02,  1.740000e+04,
         4.990000e+04,  3.490000e+04,  8.120000e+04,  7.500000e+04,
        -1.650000e+04,  1.870000e+04,  1.350000e+04,  5.420000e+04,
        -7.030000e+04, -5.100000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  6.540000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.740000e+04,  4.990000e+04,  4.090000e+04,  6.700000e+03,
         1.210000e+04,  5.290000e+04,  1.800000e+04,  1.860000e+04,
         4.990000e+04,  1.920000e+04,  4.990000e+04,  3.910000e+04,
         2.160000e+04, -8.150000e+04,  3.490000e+04,  4.040000e+04,
         5.100000e+03,  1.564000e+05,  4.070000e+04,  9.320000e+04,
         7.730000e+04,  2.300000e+04,  9.090000e+04,  1.449000e+05,
         2.593000e+05,  3.810000e+05,  2.936000e+05,  9.720000e+04,
        -1.610000e+04, -1.610000e+04, -1.590000e+04, -1.650000e+04,
        -6.930000e+04, -1.610000e+04, -3.414000e+05, -2.717000e+05,
        -2.926000e+05, -4.010000e+04, -2.360000e+04, -2.790000e+04,
         1.900000e+04, -1.420000e+04,  1.270000e+04,  1.270000e+04,
         4.670000e+04,  8.060000e+04,  4.110000e+04,  1.870000e+04,
         4.190000e+04,  5.890000e+04,  2.287000e+05, -7.650000e+04,
         4.700000e+04,  4.170000e+04, -1.380000e+04,  1.149000e+05,
         1.149000e+05,  1.497000e+05,  1.393000e+05, -1.620000e+04,
         3.440000e+04,  9.800000e+04,  4.950000e+04,  8.120000e+04,
         8.120000e+04,  8.120000e+04,  8.120000e+04,  1.153000e+05,
        -4.030000e+04,  7.500000e+04,  9.160000e+04, -1.040000e+04,
         2.290000e+04,  4.180000e+04, -4.660000e+04,  7.460000e+04,
         4.720000e+04,  4.720000e+04,  3.490000e+04,  3.490000e+04,
         3.490000e+04,  3.365000e+05,  4.216000e+05,  9.320000e+04,
         1.660000e+04,  1.655000e+05,  2.160000e+05,  2.857000e+05,
         3.489000e+05,  4.684000e+05,  3.489000e+05,  4.691000e+05,
         1.064000e+05, -2.898000e+05, -4.113000e+05, -2.212000e+05,
         2.430000e+04,  4.120000e+04,  6.515000e+05, -6.810000e+04,
         5.400000e+04,  7.160000e+04, -2.720000e+04, -6.280000e+04,
        -6.080000e+04, -9.600000e+03, -2.420000e+04, -1.829000e+05,
        -1.530000e+04, -6.400000e+03, -1.281000e+05,  1.154000e+05,
         7.850000e+04,  5.460000e+04, -1.690000e+04,  1.700000e+04,
         1.781000e+05,  1.864000e+05,  2.360000e+05,  6.460000e+04,
         1.803000e+05,  2.384000e+05,  1.946000e+05,  4.700000e+04,
         5.350000e+04,  8.750000e+04,  5.550000e+04,  5.550000e+04,
         1.075000e+05,  3.332000e+05,  2.483000e+05,  1.056600e+06,
         5.420000e+04,  5.420000e+04,  1.350000e+04,  1.350000e+04,
         1.870000e+04,  1.340000e+04, -2.230000e+04,  1.350000e+04,
         6.540000e+04,  6.560000e+04,  6.560000e+04,  6.540000e+04,
         6.460000e+04, -7.030000e+04, -7.020000e+04, -7.030000e+04,
        -4.217000e+05, -1.154000e+05, -5.100000e+04,  2.830000e+04,
         1.495000e+05,  1.494000e+05,  3.456000e+05,  3.455000e+05,
        -1.120000e+04, -2.740000e+04, -7.000000e+02, -1.640000e+04,
        -4.300000e+03, -3.800000e+03, -8.150000e+04,  3.910000e+04,
        -1.370000e+04,  2.310000e+04,  0.000000e+00,  0.000000e+00,
        -1.060000e+04, -2.230000e+04, -7.800000e+03, -1.490000e+04,
         0.000000e+00,  0.000000e+00, -1.043000e+05, -8.860000e+04,
        -2.090000e+04, -1.200000e+04, -7.500000e+03,  0.000000e+00,
        -1.690000e+04, -4.160000e+04, -6.800000e+03, -2.770000e+04,
        -2.770000e+04, -2.110000e+04, -6.500000e+03, -4.200000e+03,
        -4.870000e+04, -3.420000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02,  5.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.640000e+04, -2.740000e+04,
        -1.070000e+04,  6.550000e+04, -1.000000e+02,  1.740000e+04,
         4.990000e+04,  3.490000e+04,  8.120000e+04,  7.500000e+04,
        -1.650000e+04,  1.870000e+04,  1.350000e+04,  5.420000e+04,
        -7.030000e+04, -5.100000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  6.540000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.740000e+04,  4.990000e+04,  4.090000e+04,  6.700000e+03,
         1.210000e+04,  5.280000e+04,  1.790000e+04,  1.860000e+04,
         4.990000e+04,  1.920000e+04,  4.990000e+04,  3.930000e+04,
         2.160000e+04, -8.140000e+04,  3.490000e+04,  4.060000e+04,
         5.100000e+03,  1.572000e+05,  4.070000e+04,  9.320000e+04,
         7.730000e+04,  2.300000e+04,  9.080000e+04,  1.450000e+05,
         2.591000e+05,  3.808000e+05,  2.934000e+05,  9.730000e+04,
        -1.610000e+04, -1.610000e+04, -1.600000e+04, -1.650000e+04,
        -6.930000e+04, -1.610000e+04, -3.412000e+05, -2.716000e+05,
        -2.924000e+05, -4.010000e+04, -2.360000e+04, -2.790000e+04,
         1.890000e+04, -1.420000e+04,  1.270000e+04,  1.270000e+04,
         4.670000e+04,  8.060000e+04,  4.110000e+04,  1.870000e+04,
         4.190000e+04,  5.890000e+04,  2.286000e+05, -7.650000e+04,
         4.700000e+04,  4.160000e+04, -1.380000e+04,  1.149000e+05,
         1.148000e+05,  1.496000e+05,  1.393000e+05, -1.630000e+04,
         3.440000e+04,  9.790000e+04,  4.930000e+04,  8.120000e+04,
         8.120000e+04,  8.120000e+04,  8.120000e+04,  1.153000e+05,
        -4.030000e+04,  7.490000e+04,  9.150000e+04, -1.040000e+04,
         2.290000e+04,  4.180000e+04, -4.660000e+04,  7.460000e+04,
         4.710000e+04,  4.710000e+04,  3.490000e+04,  3.490000e+04,
         3.490000e+04,  3.365000e+05,  4.213000e+05,  9.320000e+04,
         1.650000e+04,  1.657000e+05,  2.159000e+05,  2.856000e+05,
         3.490000e+05,  4.682000e+05,  3.490000e+05,  4.688000e+05,
         1.064000e+05, -2.897000e+05, -4.111000e+05, -2.213000e+05,
         2.430000e+04,  4.120000e+04,  6.511000e+05, -6.810000e+04,
         5.510000e+04,  7.290000e+04, -2.710000e+04, -6.280000e+04,
        -6.070000e+04, -9.600000e+03, -2.410000e+04, -1.838000e+05,
        -1.540000e+04, -6.300000e+03, -1.281000e+05,  1.154000e+05,
         7.840000e+04,  5.460000e+04, -1.680000e+04,  1.710000e+04,
         1.781000e+05,  1.865000e+05,  2.361000e+05,  6.450000e+04,
         1.802000e+05,  2.382000e+05,  1.945000e+05,  4.700000e+04,
         5.350000e+04,  8.740000e+04,  5.550000e+04,  5.550000e+04,
         1.074000e+05,  3.330000e+05,  2.482000e+05,  1.056500e+06,
         5.410000e+04,  5.420000e+04,  1.350000e+04,  1.350000e+04,
         1.870000e+04,  1.340000e+04, -2.370000e+04,  1.350000e+04,
         6.540000e+04,  6.540000e+04,  6.540000e+04,  6.670000e+04,
         6.530000e+04, -7.030000e+04, -7.030000e+04, -7.030000e+04,
        -4.217000e+05, -1.164000e+05, -5.140000e+04,  2.830000e+04,
         1.494000e+05,  1.493000e+05,  3.454000e+05,  3.453000e+05,
        -1.120000e+04, -2.730000e+04, -7.000000e+02, -1.640000e+04,
        -4.500000e+03, -3.800000e+03, -8.140000e+04,  3.930000e+04,
        -1.370000e+04,  2.320000e+04,  0.000000e+00,  0.000000e+00,
        -1.060000e+04, -2.230000e+04, -7.800000e+03, -1.480000e+04,
         0.000000e+00,  0.000000e+00, -1.043000e+05, -8.860000e+04,
        -2.090000e+04, -1.200000e+04, -7.500000e+03,  0.000000e+00,
        -1.690000e+04, -4.160000e+04, -6.800000e+03, -2.770000e+04,
        -2.770000e+04, -2.110000e+04, -6.500000e+03, -4.200000e+03,
        -4.870000e+04, -3.420000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02,  5.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.640000e+04, -2.730000e+04,
        -1.070000e+04,  6.540000e+04, -1.000000e+02,  1.740000e+04,
         4.990000e+04,  3.490000e+04,  8.120000e+04,  7.490000e+04,
        -1.650000e+04,  1.870000e+04,  1.350000e+04,  5.420000e+04,
        -7.030000e+04, -5.140000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  6.540000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 2.090000e+04,  4.950000e+04,  4.220000e+04,  6.000000e+03,
         1.350000e+04,  6.580000e+04,  2.410000e+04,  2.640000e+04,
         4.950000e+04,  3.260000e+04,  4.960000e+04,  8.740000e+04,
         3.800000e+04, -8.110000e+04,  3.430000e+04,  1.026000e+05,
         1.060000e+04,  3.496000e+05,  4.580000e+04,  9.230000e+04,
         7.910000e+04,  2.210000e+04,  8.930000e+04,  1.477000e+05,
         2.584000e+05,  3.811000e+05,  2.886000e+05,  9.650000e+04,
        -1.610000e+04, -1.560000e+04, -1.600000e+04, -1.680000e+04,
        -6.920000e+04, -1.570000e+04, -3.316000e+05, -2.669000e+05,
        -2.873000e+05, -3.790000e+04, -2.350000e+04, -2.680000e+04,
         1.950000e+04, -1.570000e+04,  1.220000e+04,  1.220000e+04,
         4.590000e+04,  7.950000e+04,  4.110000e+04,  1.830000e+04,
         4.240000e+04,  5.730000e+04,  2.258000e+05, -7.650000e+04,
         4.770000e+04,  4.030000e+04, -1.520000e+04,  1.170000e+05,
         1.169000e+05,  1.477000e+05,  1.391000e+05, -1.150000e+04,
         3.360000e+04,  9.680000e+04,  4.890000e+04,  8.430000e+04,
         8.430000e+04,  8.430000e+04,  8.430000e+04,  1.141000e+05,
        -3.830000e+04,  7.590000e+04,  9.060000e+04, -1.040000e+04,
         2.290000e+04,  4.060000e+04, -4.670000e+04,  7.420000e+04,
         4.730000e+04,  4.730000e+04,  3.430000e+04,  3.430000e+04,
         3.430000e+04,  3.424000e+05,  4.169000e+05,  9.760000e+04,
         2.290000e+04,  1.696000e+05,  2.139000e+05,  2.828000e+05,
         3.590000e+05,  4.635000e+05,  3.590000e+05,  4.641000e+05,
         1.130000e+05, -2.808000e+05, -4.033000e+05, -2.207000e+05,
         2.630000e+04,  4.110000e+04,  6.451000e+05, -6.880000e+04,
         5.420000e+04,  6.980000e+04, -2.690000e+04, -6.220000e+04,
        -5.520000e+04, -1.020000e+04, -2.200000e+04, -1.782000e+05,
        -1.010000e+04,  2.500000e+03, -1.203000e+05,  1.253000e+05,
         7.700000e+04,  5.790000e+04, -1.210000e+04,  1.770000e+04,
         1.755000e+05,  1.904000e+05,  2.337000e+05,  6.810000e+04,
         1.778000e+05,  2.358000e+05,  1.959000e+05,  4.600000e+04,
         5.240000e+04,  8.610000e+04,  6.100000e+04,  6.100000e+04,
         1.065000e+05,  3.290000e+05,  2.545000e+05,  1.134400e+06,
         5.360000e+04,  5.370000e+04,  1.220000e+04,  1.220000e+04,
         1.830000e+04,  1.220000e+04, -2.520000e+04,  1.220000e+04,
         6.460000e+04,  6.460000e+04,  6.460000e+04,  6.530000e+04,
         2.097000e+05, -6.990000e+04, -6.990000e+04, -6.990000e+04,
        -4.194000e+05, -1.161000e+05, -5.190000e+04,  2.730000e+04,
         1.475000e+05,  1.474000e+05,  3.412000e+05,  3.412000e+05,
        -1.090000e+04, -2.710000e+04, -7.000000e+02, -1.740000e+04,
        -4.700000e+04, -4.100000e+03, -8.110000e+04,  8.740000e+04,
        -1.330000e+04,  2.130000e+04,  0.000000e+00,  0.000000e+00,
        -9.700000e+03, -2.090000e+04, -7.600000e+03, -1.470000e+04,
         0.000000e+00,  0.000000e+00, -1.019000e+05, -8.780000e+04,
        -2.040000e+04, -1.120000e+04, -7.300000e+03,  0.000000e+00,
        -1.770000e+04, -4.140000e+04, -6.700000e+03, -2.780000e+04,
        -2.780000e+04, -1.980000e+04, -6.500000e+03, -4.100000e+03,
        -4.740000e+04, -3.420000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02,  4.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.740000e+04, -2.710000e+04,
        -1.060000e+04,  6.460000e+04, -1.000000e+02,  2.090000e+04,
         4.950000e+04,  3.430000e+04,  8.430000e+04,  7.590000e+04,
        -1.680000e+04,  1.830000e+04,  1.220000e+04,  5.370000e+04,
        -6.990000e+04, -5.190000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  6.460000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-2.330000e+04, -5.300000e+04, -4.460000e+04, -1.440000e+04,
        -1.890000e+04, -7.590000e+04, -2.930000e+04, -2.480000e+04,
        -5.300000e+04, -2.530000e+04, -5.300000e+04, -4.520000e+04,
        -2.330000e+04,  8.400000e+04, -4.280000e+04, -4.630000e+04,
        -5.500000e+03, -1.806000e+05, -6.650000e+04, -1.049000e+05,
        -9.950000e+04, -3.570000e+04, -1.132000e+05, -1.757000e+05,
        -2.952000e+05, -4.279000e+05, -3.195000e+05, -1.924000e+05,
         1.380000e+04,  1.340000e+04,  1.340000e+04,  1.340000e+04,
         6.970000e+04,  1.340000e+04,  3.098000e+05,  2.562000e+05,
         2.658000e+05,  3.570000e+04,  2.150000e+04,  2.470000e+04,
        -3.270000e+04, -1.000000e+03, -1.960000e+04, -1.960000e+04,
        -5.730000e+04, -9.540000e+04, -5.700000e+04, -2.400000e+04,
        -6.290000e+04, -7.650000e+04, -2.654000e+05,  7.330000e+04,
        -6.250000e+04, -5.730000e+04, -2.600000e+03, -1.434000e+05,
        -1.434000e+05, -1.688000e+05, -1.654000e+05,  5.700000e+03,
        -3.650000e+04, -1.141000e+05, -5.330000e+04, -9.950000e+04,
        -9.950000e+04, -9.950000e+04, -9.950000e+04, -1.233000e+05,
         3.270000e+04, -9.270000e+04, -1.063000e+05,  2.347000e+06,
         2.283100e+06,  2.294100e+06,  4.410000e+04, -7.790000e+04,
        -5.090000e+04, -5.090000e+04, -4.280000e+04, -4.280000e+04,
        -4.280000e+04, -4.058000e+05, -4.678000e+05, -1.388000e+05,
         2.579700e+06,  4.470000e+06,  4.367700e+06,  4.308100e+06,
        -4.192000e+05, -5.025000e+05, -4.192000e+05, -5.018000e+05,
        -1.526000e+05,  2.783000e+05,  4.110000e+05,  2.301000e+05,
        -3.650000e+04, -5.010000e+04, -6.956000e+05,  7.280000e+04,
        -6.090000e+04, -7.370000e+04,  2.333200e+06,  6.010000e+04,
         5.060000e+04,  1.430000e+04,  1.760000e+04,  1.844000e+05,
         2.320600e+06, -1.680000e+04,  1.142000e+05, -1.479000e+05,
        -8.470000e+04, -7.180000e+04, -2.700000e+03, -2.990000e+04,
        -1.949000e+05, -2.206000e+05, -2.632000e+05, -8.680000e+04,
        -1.975000e+05, -2.552000e+05, -2.120000e+05, -5.400000e+04,
        -6.430000e+04, -1.021000e+05, -6.870000e+04, -6.870000e+04,
        -1.146000e+05, -3.593000e+05, -2.915000e+05, -1.308400e+06,
         2.238800e+06,  2.241100e+06, -1.120000e+04, -1.120000e+04,
        -2.250000e+04, -1.120000e+04,  3.450000e+04, -1.120000e+04,
        -7.030000e+04, -7.030000e+04, -7.030000e+04, -7.030000e+04,
        -6.990000e+04,  2.722800e+06,  2.720900e+06,  2.721300e+06,
         1.633410e+07,  1.360000e+05,  6.240000e+04, -4.050000e+04,
        -1.636000e+05, -1.640000e+05, -3.749000e+05, -3.749000e+05,
         2.309100e+06,  2.640000e+04,  9.000000e+02,  1.650000e+04,
         5.000000e+03,  4.200000e+03,  8.400000e+04, -4.520000e+04,
         1.530000e+04, -2.650000e+04,  0.000000e+00,  0.000000e+00,
         8.100000e+03,  2.280000e+04,  8.200000e+03,  1.600000e+04,
         0.000000e+00,  0.000000e+00,  1.058000e+05,  9.120000e+04,
         2.300000e+04,  1.220000e+04,  7.900000e+03,  0.000000e+00,
         1.720000e+04,  4.290000e+04,  7.600000e+03,  2.720000e+04,
         2.720000e+04,  2.150000e+04,  7.100000e+03,  4.500000e+03,
         4.850000e+04,  3.430000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -5.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02,  1.650000e+04,  2.640000e+04,
         1.100000e+04, -7.030000e+04,  0.000000e+00, -2.330000e+04,
        -5.300000e+04, -4.280000e+04, -9.950000e+04, -9.270000e+04,
         1.340000e+04, -2.250000e+04, -1.120000e+04,  2.241100e+06,
         2.721400e+06,  6.240000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -7.030000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-2.330000e+04, -5.290000e+04, -4.460000e+04, -1.440000e+04,
        -1.890000e+04, -7.580000e+04, -2.930000e+04, -2.470000e+04,
        -5.290000e+04, -2.530000e+04, -5.290000e+04, -4.510000e+04,
        -2.330000e+04,  8.390000e+04, -4.280000e+04, -4.620000e+04,
        -5.500000e+03, -1.805000e+05, -6.650000e+04, -1.048000e+05,
        -9.950000e+04, -3.570000e+04, -1.131000e+05, -1.756000e+05,
        -2.950000e+05, -4.276000e+05, -3.193000e+05, -1.922000e+05,
         1.380000e+04,  1.340000e+04,  1.340000e+04,  1.340000e+04,
         6.970000e+04,  1.340000e+04,  3.096000e+05,  2.560000e+05,
         2.656000e+05,  3.570000e+04,  2.150000e+04,  2.470000e+04,
        -3.270000e+04, -1.000000e+03, -1.960000e+04, -1.950000e+04,
        -5.730000e+04, -9.530000e+04, -5.700000e+04, -2.390000e+04,
        -6.290000e+04, -7.640000e+04, -2.652000e+05,  7.320000e+04,
        -6.240000e+04, -5.720000e+04, -2.600000e+03, -1.433000e+05,
        -1.433000e+05, -1.686000e+05, -1.653000e+05,  5.700000e+03,
        -3.650000e+04, -1.141000e+05, -5.320000e+04, -9.940000e+04,
        -9.940000e+04, -9.940000e+04, -9.940000e+04, -1.232000e+05,
         3.270000e+04, -9.260000e+04, -1.062000e+05,  2.345300e+06,
         2.281500e+06,  2.292400e+06,  4.410000e+04, -7.780000e+04,
        -5.090000e+04, -5.090000e+04, -4.280000e+04, -4.280000e+04,
        -4.280000e+04, -4.055000e+05, -4.675000e+05, -1.387000e+05,
         2.577900e+06,  4.466700e+06,  4.364600e+06,  4.305000e+06,
        -4.189000e+05, -5.021000e+05, -4.189000e+05, -5.014000e+05,
        -1.525000e+05,  2.781000e+05,  4.107000e+05,  2.299000e+05,
        -3.650000e+04, -5.010000e+04, -6.951000e+05,  7.280000e+04,
        -6.090000e+04, -7.360000e+04,  2.331600e+06,  6.000000e+04,
         5.060000e+04,  1.430000e+04,  1.760000e+04,  1.842000e+05,
         2.318900e+06, -1.680000e+04,  1.141000e+05, -1.478000e+05,
        -8.460000e+04, -7.180000e+04, -2.700000e+03, -2.980000e+04,
        -1.948000e+05, -2.204000e+05, -2.630000e+05, -8.680000e+04,
        -1.974000e+05, -2.550000e+05, -2.118000e+05, -5.400000e+04,
        -6.430000e+04, -1.020000e+05, -6.860000e+04, -6.860000e+04,
        -1.145000e+05, -3.591000e+05, -2.913000e+05, -1.307400e+06,
         2.237200e+06,  2.239500e+06, -1.120000e+04, -1.120000e+04,
        -2.250000e+04, -1.120000e+04,  3.440000e+04, -1.120000e+04,
        -7.030000e+04, -7.020000e+04, -7.020000e+04, -7.030000e+04,
        -6.990000e+04,  2.720900e+06,  2.731100e+06,  2.729000e+06,
         1.634060e+07,  1.359000e+05,  6.240000e+04, -4.050000e+04,
        -1.634000e+05, -1.639000e+05, -3.746000e+05, -3.746000e+05,
         2.307400e+06,  2.640000e+04,  9.000000e+02,  1.650000e+04,
         5.000000e+03,  4.200000e+03,  8.390000e+04, -4.510000e+04,
         1.530000e+04, -2.650000e+04,  0.000000e+00,  0.000000e+00,
         8.100000e+03,  2.280000e+04,  8.200000e+03,  1.600000e+04,
         0.000000e+00,  0.000000e+00,  1.057000e+05,  9.120000e+04,
         2.300000e+04,  1.220000e+04,  7.900000e+03,  0.000000e+00,
         1.720000e+04,  4.290000e+04,  7.600000e+03,  2.720000e+04,
         2.720000e+04,  2.150000e+04,  7.100000e+03,  4.500000e+03,
         4.850000e+04,  3.420000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -5.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -5.000000e+02,  1.650000e+04,  2.640000e+04,
         1.100000e+04, -7.030000e+04,  0.000000e+00, -2.330000e+04,
        -5.290000e+04, -4.280000e+04, -9.940000e+04, -9.260000e+04,
         1.340000e+04, -2.250000e+04, -1.120000e+04,  2.239500e+06,
         2.728400e+06,  6.240000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -7.030000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-2.330000e+04, -5.290000e+04, -4.460000e+04, -1.440000e+04,
        -1.890000e+04, -7.580000e+04, -2.930000e+04, -2.470000e+04,
        -5.290000e+04, -2.530000e+04, -5.290000e+04, -4.510000e+04,
        -2.330000e+04,  8.390000e+04, -4.280000e+04, -4.620000e+04,
        -5.500000e+03, -1.805000e+05, -6.650000e+04, -1.048000e+05,
        -9.950000e+04, -3.570000e+04, -1.132000e+05, -1.756000e+05,
        -2.951000e+05, -4.277000e+05, -3.194000e+05, -1.923000e+05,
         1.380000e+04,  1.340000e+04,  1.340000e+04,  1.340000e+04,
         6.970000e+04,  1.340000e+04,  3.096000e+05,  2.561000e+05,
         2.656000e+05,  3.570000e+04,  2.150000e+04,  2.470000e+04,
        -3.270000e+04, -1.000000e+03, -1.960000e+04, -1.950000e+04,
        -5.730000e+04, -9.530000e+04, -5.700000e+04, -2.390000e+04,
        -6.290000e+04, -7.640000e+04, -2.652000e+05,  7.320000e+04,
        -6.240000e+04, -5.720000e+04, -2.600000e+03, -1.433000e+05,
        -1.433000e+05, -1.687000e+05, -1.653000e+05,  5.700000e+03,
        -3.650000e+04, -1.141000e+05, -5.320000e+04, -9.940000e+04,
        -9.940000e+04, -9.940000e+04, -9.940000e+04, -1.232000e+05,
         3.270000e+04, -9.260000e+04, -1.062000e+05,  2.345600e+06,
         2.281800e+06,  2.292800e+06,  4.410000e+04, -7.780000e+04,
        -5.090000e+04, -5.090000e+04, -4.280000e+04, -4.280000e+04,
        -4.280000e+04, -4.056000e+05, -4.675000e+05, -1.388000e+05,
         2.578200e+06,  4.467400e+06,  4.365200e+06,  4.305700e+06,
        -4.190000e+05, -5.022000e+05, -4.190000e+05, -5.015000e+05,
        -1.525000e+05,  2.782000e+05,  4.107000e+05,  2.300000e+05,
        -3.650000e+04, -5.010000e+04, -6.952000e+05,  7.280000e+04,
        -6.090000e+04, -7.360000e+04,  2.331900e+06,  6.000000e+04,
         5.060000e+04,  1.430000e+04,  1.760000e+04,  1.843000e+05,
         2.319300e+06, -1.680000e+04,  1.142000e+05, -1.478000e+05,
        -8.460000e+04, -7.180000e+04, -2.700000e+03, -2.980000e+04,
        -1.948000e+05, -2.205000e+05, -2.631000e+05, -8.680000e+04,
        -1.974000e+05, -2.551000e+05, -2.118000e+05, -5.400000e+04,
        -6.430000e+04, -1.020000e+05, -6.860000e+04, -6.860000e+04,
        -1.145000e+05, -3.591000e+05, -2.913000e+05, -1.307600e+06,
         2.237500e+06,  2.239900e+06, -1.120000e+04, -1.120000e+04,
        -2.250000e+04, -1.120000e+04,  3.450000e+04, -1.120000e+04,
        -7.030000e+04, -7.030000e+04, -7.030000e+04, -7.030000e+04,
        -6.990000e+04,  2.721300e+06,  2.729000e+06,  2.729400e+06,
         1.634300e+07,  1.359000e+05,  6.240000e+04, -4.050000e+04,
        -1.635000e+05, -1.640000e+05, -3.747000e+05, -3.747000e+05,
         2.307800e+06,  2.640000e+04,  9.000000e+02,  1.650000e+04,
         5.000000e+03,  4.200000e+03,  8.390000e+04, -4.510000e+04,
         1.530000e+04, -2.650000e+04,  0.000000e+00,  0.000000e+00,
         8.100000e+03,  2.280000e+04,  8.200000e+03,  1.600000e+04,
         0.000000e+00,  0.000000e+00,  1.057000e+05,  9.120000e+04,
         2.300000e+04,  1.220000e+04,  7.900000e+03,  0.000000e+00,
         1.720000e+04,  4.290000e+04,  7.600000e+03,  2.720000e+04,
         2.720000e+04,  2.150000e+04,  7.100000e+03,  4.500000e+03,
         4.850000e+04,  3.420000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -5.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -5.000000e+02,  1.650000e+04,  2.640000e+04,
         1.100000e+04, -7.030000e+04,  0.000000e+00, -2.330000e+04,
        -5.290000e+04, -4.280000e+04, -9.940000e+04, -9.260000e+04,
         1.340000e+04, -2.250000e+04, -1.120000e+04,  2.239900e+06,
         2.728800e+06,  6.240000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -7.030000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-1.396000e+05, -3.178000e+05, -2.675000e+05, -8.650000e+04,
        -1.132000e+05, -4.551000e+05, -1.757000e+05, -1.485000e+05,
        -3.178000e+05, -1.518000e+05, -3.178000e+05, -2.709000e+05,
        -1.401000e+05,  5.038000e+05, -2.571000e+05, -2.776000e+05,
        -3.310000e+04, -1.083600e+06, -3.991000e+05, -6.290000e+05,
        -5.971000e+05, -2.144000e+05, -6.792000e+05, -1.054200e+06,
        -1.771200e+06, -2.566900e+06, -1.916900e+06, -1.154100e+06,
         8.260000e+04,  8.020000e+04,  8.020000e+04,  8.050000e+04,
         4.182000e+05,  8.030000e+04,  1.858400e+06,  1.536900e+06,
         1.594300e+06,  2.143000e+05,  1.291000e+05,  1.483000e+05,
        -1.962000e+05, -5.800000e+03, -1.176000e+05, -1.173000e+05,
        -3.440000e+05, -5.721000e+05, -3.419000e+05, -1.437000e+05,
        -3.773000e+05, -4.587000e+05, -1.591900e+06,  4.396000e+05,
        -3.748000e+05, -3.436000e+05, -1.530000e+04, -8.603000e+05,
        -8.602000e+05, -1.012400e+06, -9.923000e+05,  3.420000e+04,
        -2.189000e+05, -6.847000e+05, -3.196000e+05, -5.969000e+05,
        -5.969000e+05, -5.968000e+05, -5.969000e+05, -7.396000e+05,
         1.963000e+05, -5.561000e+05, -6.377000e+05,  1.407920e+07,
         1.369610e+07,  1.376190e+07,  2.645000e+05, -4.671000e+05,
        -3.056000e+05, -3.056000e+05, -2.571000e+05, -2.570000e+05,
        -2.571000e+05, -2.434500e+06, -2.806300e+06, -8.329000e+05,
         1.547550e+07,  2.681490e+07,  2.620140e+07,  2.584410e+07,
        -2.514800e+06, -3.014300e+06, -2.514800e+06, -3.010200e+06,
        -9.152000e+05,  1.669700e+06,  2.465400e+06,  1.380300e+06,
        -2.190000e+05, -3.008000e+05, -4.172800e+06,  4.369000e+05,
        -3.655000e+05, -4.421000e+05,  1.399690e+07,  3.604000e+05,
         3.036000e+05,  8.580000e+04,  1.055000e+05,  1.106000e+06,
         1.392110e+07, -1.009000e+05,  6.852000e+05, -8.870000e+05,
        -5.080000e+05, -4.310000e+05, -1.620000e+04, -1.791000e+05,
        -1.169300e+06, -1.323400e+06, -1.578900e+06, -5.208000e+05,
        -1.184900e+06, -1.531000e+06, -1.271500e+06, -3.242000e+05,
        -3.857000e+05, -6.124000e+05, -4.120000e+05, -4.120000e+05,
        -6.874000e+05, -2.155700e+06, -1.748500e+06, -7.848800e+06,
         1.343010e+07,  1.344440e+07, -6.730000e+04, -6.740000e+04,
        -1.351000e+05, -6.720000e+04,  2.068000e+05, -6.740000e+04,
        -4.217000e+05, -4.217000e+05, -4.217000e+05, -4.217000e+05,
        -4.194000e+05,  1.633410e+07,  1.634060e+07,  1.634300e+07,
         9.841800e+07,  8.157000e+05,  3.746000e+05, -2.429000e+05,
        -9.812000e+05, -9.841000e+05, -2.249100e+06, -2.248900e+06,
         1.385190e+07,  1.583000e+05,  5.200000e+03,  9.890000e+04,
         2.980000e+04,  2.520000e+04,  5.038000e+05, -2.709000e+05,
         9.170000e+04, -1.588000e+05,  0.000000e+00, -2.000000e+02,
         4.850000e+04,  1.369000e+05,  4.920000e+04,  9.610000e+04,
         0.000000e+00,  0.000000e+00,  6.346000e+05,  5.474000e+05,
         1.379000e+05,  7.330000e+04,  4.760000e+04,  0.000000e+00,
         1.034000e+05,  2.576000e+05,  4.580000e+04,  1.633000e+05,
         1.632000e+05,  1.289000e+05,  4.240000e+04,  2.710000e+04,
         2.911000e+05,  2.055000e+05,  0.000000e+00,  8.450000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.000000e+02, -2.700000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  8.740000e+04,  9.890000e+04,  1.583000e+05,
         6.610000e+04, -4.217000e+05,  1.000000e+02, -1.396000e+05,
        -3.178000e+05, -2.570000e+05, -5.969000e+05, -5.561000e+05,
         8.060000e+04, -1.351000e+05, -6.740000e+04,  1.344440e+07,
         1.634240e+07,  3.746000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -4.217000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-1.046000e+05, -8.720000e+04, -7.900000e+04, -1.200000e+03,
        -5.280000e+04, -4.141000e+05, -2.049000e+05, -1.055000e+05,
        -8.720000e+04, -1.056000e+05, -8.720000e+04, -1.103000e+05,
        -4.000000e+04,  1.515000e+05, -5.820000e+04, -1.106000e+05,
        -9.200000e+03, -4.413000e+05, -1.958000e+05, -1.585000e+05,
        -1.587000e+05, -2.370000e+04, -1.500000e+05, -3.580000e+05,
         6.402400e+06,  6.135000e+06,  6.430100e+06, -1.521000e+05,
         3.600000e+04,  3.590000e+04,  3.610000e+04,  3.440000e+04,
         1.310000e+05,  3.600000e+04,  4.988000e+05,  5.463000e+05,
         5.482000e+05,  3.980000e+04,  4.910000e+04,  5.210000e+04,
        -5.360000e+04,  5.400000e+04, -5.400000e+03, -5.400000e+03,
        -6.850000e+04, -1.315000e+05, -6.870000e+04, -2.260000e+04,
        -8.290000e+04, -7.220000e+04, -3.877000e+05,  1.501000e+05,
        -1.114000e+05, -5.940000e+04,  5.260000e+04, -2.747000e+05,
        -2.747000e+05, -2.491000e+05, -2.501000e+05, -1.961000e+05,
        -5.670000e+04, -1.735000e+05, -8.790000e+04, -2.313000e+05,
        -2.313000e+05, -2.313000e+05, -2.313000e+05, -2.027000e+05,
         3.570000e+04, -1.695000e+05, -1.587000e+05,  1.680000e+04,
        -4.660000e+04, -6.220000e+04,  9.310000e+04, -1.271000e+05,
        -8.610000e+04, -8.610000e+04, -5.820000e+04, -5.820000e+04,
        -5.820000e+04, -8.039000e+05, -7.368000e+05, -2.761000e+05,
        -1.535000e+05, -4.307000e+05, -3.867000e+05, -5.172000e+05,
        -9.262000e+05, -8.261000e+05, -9.262000e+05, -8.248000e+05,
        -3.906000e+05,  3.873000e+05,  6.549000e+05,  4.432000e+05,
        -7.990000e+04, -6.940000e+04, -1.143900e+06,  7.059700e+06,
         6.791200e+06,  6.803800e+06,  5.250000e+04,  1.289000e+05,
         6.898300e+06,  6.950000e+06,  6.935300e+06,  7.167000e+06,
        -6.590000e+04, -1.788000e+05,  8.620000e+04, -4.437000e+05,
        -1.254000e+05, -1.170000e+05, -4.430000e+04, -2.300000e+04,
        -3.068000e+05, -4.644000e+05, -4.365000e+05, -1.965000e+05,
        -3.102000e+05, -4.194000e+05, -4.430000e+05, -7.550000e+04,
        -8.090000e+04, -1.440000e+05, -2.136000e+05, -2.136000e+05,
        -1.885000e+05,  2.883300e+06,  2.830000e+06, -3.753400e+06,
        -9.900000e+04, -9.910000e+04,  6.904000e+06,  6.908600e+06,
        -2.270000e+04,  6.908600e+06,  1.389750e+07,  6.908600e+06,
        -1.154000e+05, -1.154000e+05, -1.154000e+05, -1.164000e+05,
        -1.161000e+05,  1.360000e+05,  1.359000e+05,  1.359000e+05,
         8.157000e+05,  7.487600e+06,  7.191900e+06, -1.210000e+04,
        -2.535000e+05, -2.534000e+05, -5.996000e+05, -5.996000e+05,
         1.640000e+04,  5.320000e+04,  1.300000e+03,  3.700000e+03,
         8.500000e+03,  7.900000e+03,  1.515000e+05, -1.103000e+05,
         2.500000e+04, -1.110000e+04,  0.000000e+00, -1.000000e+02,
         1.070000e+04,  5.900000e+03,  1.320000e+04,  2.640000e+04,
         0.000000e+00,  0.000000e+00,  1.581000e+05,  1.636000e+05,
         3.750000e+04,  9.300000e+03,  1.280000e+04,  0.000000e+00,
         4.200000e+03,  7.720000e+04,  1.250000e+04,  5.590000e+04,
         5.590000e+04,  3.800000e+03,  1.170000e+04,  7.100000e+03,
         6.090000e+04,  6.780000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -7.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  3.700000e+03,  5.320000e+04,
         1.990000e+04, -1.154000e+05,  0.000000e+00, -1.046000e+05,
        -8.720000e+04, -5.820000e+04, -2.313000e+05, -1.695000e+05,
         3.460000e+04, -2.270000e+04,  6.908600e+06, -9.910000e+04,
         1.359000e+05,  7.191900e+06,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.154000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-8.850000e+04, -3.830000e+04, -3.860000e+04,  5.300000e+03,
        -4.140000e+04, -3.673000e+05, -1.904000e+05, -8.790000e+04,
        -3.830000e+04, -8.750000e+04, -3.830000e+04, -7.180000e+04,
        -1.870000e+04,  7.090000e+04, -2.320000e+04, -7.080000e+04,
        -4.200000e+03, -2.871000e+05, -1.486000e+05, -6.600000e+04,
        -7.410000e+04,  1.100000e+03, -5.860000e+04, -2.043000e+05,
         6.661200e+06,  6.516300e+06,  6.718000e+06, -4.130000e+04,
         1.990000e+04,  1.990000e+04,  2.010000e+04,  1.870000e+04,
         6.260000e+04,  1.990000e+04,  1.685000e+05,  2.774000e+05,
         2.678000e+05,  2.000000e+02,  2.570000e+04,  2.510000e+04,
        -3.580000e+04,  3.890000e+04,  8.800000e+03,  8.800000e+03,
        -2.110000e+04, -5.090000e+04, -2.400000e+04, -3.400000e+03,
        -3.790000e+04, -1.150000e+04, -1.608000e+05,  7.550000e+04,
        -6.490000e+04, -1.790000e+04,  3.820000e+04, -1.577000e+05,
        -1.577000e+05, -1.018000e+05, -1.081000e+05, -2.173000e+05,
        -2.240000e+04, -7.500000e+04, -3.920000e+04, -1.464000e+05,
        -1.464000e+05, -1.464000e+05, -1.464000e+05, -8.930000e+04,
        -2.000000e+03, -9.430000e+04, -6.790000e+04,  7.900000e+03,
        -2.230000e+04, -1.890000e+04,  4.760000e+04, -5.280000e+04,
        -3.960000e+04, -3.960000e+04, -2.320000e+04, -2.320000e+04,
        -2.320000e+04, -4.608000e+05, -3.207000e+05, -1.755000e+05,
        -1.415000e+05, -2.562000e+05, -1.702000e+05, -2.317000e+05,
        -5.641000e+05, -3.644000e+05, -5.641000e+05, -3.635000e+05,
        -2.757000e+05,  1.022000e+05,  2.469000e+05,  2.159000e+05,
        -5.350000e+04, -2.720000e+04, -5.037000e+05,  6.991800e+06,
         6.846600e+06,  6.874700e+06,  2.740000e+04,  6.750000e+04,
         6.840600e+06,  6.939700e+06,  6.915100e+06,  6.986200e+06,
        -8.940000e+04, -1.825000e+05, -3.930000e+04, -3.256000e+05,
        -5.050000e+04, -5.830000e+04, -5.600000e+04, -3.200000e+03,
        -1.315000e+05, -2.718000e+05, -1.954000e+05, -1.273000e+05,
        -1.328000e+05, -1.849000e+05, -2.543000e+05, -2.940000e+04,
        -2.660000e+04, -5.650000e+04, -1.588000e+05, -1.588000e+05,
        -8.300000e+04,  3.211600e+06,  3.079600e+06, -2.688800e+06,
        -4.350000e+04, -4.360000e+04,  6.916800e+06,  6.921400e+06,
        -3.400000e+03,  6.921400e+06,  1.387430e+07,  6.921400e+06,
        -5.100000e+04, -5.100000e+04, -5.100000e+04, -5.140000e+04,
        -5.190000e+04,  6.240000e+04,  6.240000e+04,  6.240000e+04,
         3.746000e+05,  7.191900e+06,  7.058200e+06,  1.770000e+04,
        -1.053000e+05, -1.054000e+05, -2.582000e+05, -2.583000e+05,
         7.300000e+03,  2.580000e+04,  5.000000e+02, -1.320000e+04,
         4.000000e+03,  4.100000e+03,  7.090000e+04, -7.180000e+04,
         1.120000e+04,  1.530000e+04,  0.000000e+00,  0.000000e+00,
         2.400000e+03, -1.700000e+04,  5.700000e+03,  1.180000e+04,
         0.000000e+00,  0.000000e+00,  5.340000e+04,  7.630000e+04,
         1.680000e+04, -2.700000e+03,  5.500000e+03,  0.000000e+00,
        -1.340000e+04,  3.610000e+04,  5.600000e+03,  2.800000e+04,
         2.800000e+04, -1.780000e+04,  5.300000e+03,  2.900000e+03,
         1.100000e+04,  3.340000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.320000e+04,  2.580000e+04,
         9.300000e+03, -5.100000e+04,  0.000000e+00, -8.850000e+04,
        -3.830000e+04, -2.320000e+04, -1.464000e+05, -9.430000e+04,
         1.880000e+04, -3.400000e+03,  6.921400e+06, -4.360000e+04,
         6.240000e+04,  7.058200e+06,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -5.100000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-1.449000e+05, -1.020000e+04,  5.800000e+03,  1.149900e+06,
         5.018000e+05, -6.433000e+05, -3.537000e+05, -1.405000e+05,
        -1.020000e+04, -1.385000e+05, -1.010000e+04, -6.480000e+04,
        -2.000000e+02,  1.027600e+06,  5.950000e+05, -6.070000e+04,
         5.000000e+02, -2.594000e+05,  8.592000e+05,  1.050500e+06,
         1.089600e+06,  2.975600e+06,  1.741500e+06, -8.330000e+04,
         2.131500e+06,  1.044400e+06,  2.263400e+06,  1.767610e+07,
         1.056600e+06,  1.058900e+06,  1.056900e+06,  1.054600e+06,
         1.298400e+06,  1.058700e+06,  9.131600e+06,  9.395600e+06,
         9.438800e+06,  9.720000e+05,  1.033100e+06,  1.048800e+06,
         1.651100e+06,  2.864300e+06,  2.977000e+06,  2.977400e+06,
         2.375800e+06,  1.762700e+06,  2.346800e+06,  1.763200e+06,
         5.263400e+06,  5.325700e+06,  2.317400e+06,  2.259100e+06,
         1.098300e+06,  1.746200e+06,  2.872800e+06,  2.026300e+06,
         2.026100e+06,  2.157400e+06,  2.179900e+06, -4.828000e+05,
         6.535000e+05,  6.352000e+05,  2.150000e+04, -1.141000e+05,
        -1.141000e+05, -1.141000e+05, -1.141000e+05,  1.820000e+04,
         9.743000e+05,  5.492000e+05,  6.155000e+05, -3.210000e+04,
        -5.911000e+05, -5.057000e+05,  1.676900e+06,  1.014600e+06,
         1.530000e+04,  1.530000e+04,  5.950000e+05,  5.949000e+05,
         5.950000e+05,  9.601000e+05,  1.286300e+06,  3.212500e+06,
         2.010600e+06, -2.063000e+05, -1.400000e+04, -1.132000e+06,
        -3.702000e+05,  9.260000e+04, -3.702000e+05,  9.170000e+04,
         1.789600e+06,  3.838300e+06,  4.926300e+06,  4.102300e+06,
         1.001700e+06,  1.063900e+06, -1.240000e+04,  1.078200e+06,
        -9.900000e+03,  5.410000e+04,  1.023000e+06,  2.797300e+06,
        -2.148000e+05, -1.110000e+04,  1.560000e+04,  8.735000e+05,
        -2.701000e+05,  6.846000e+05,  1.774300e+06, -4.050000e+05,
         9.960000e+05,  1.068700e+06,  1.975100e+06,  2.099700e+06,
         1.126400e+06, -1.419000e+05,  4.140000e+04,  9.454000e+05,
         1.141800e+06,  5.540000e+04, -1.414000e+05,  1.063600e+06,
         2.397900e+06,  1.796200e+06, -2.059000e+05, -2.058000e+05,
        -1.500000e+03,  8.774000e+05,  5.660000e+05, -3.179100e+06,
        -6.400000e+03, -6.400000e+03,  4.760000e+04,  4.770000e+04,
         1.794300e+06,  4.750000e+04, -9.919000e+05,  4.770000e+04,
         2.830000e+04,  2.830000e+04,  2.830000e+04,  2.830000e+04,
         2.730000e+04, -4.050000e+04, -4.050000e+04, -4.050000e+04,
        -2.429000e+05, -1.210000e+04,  1.770000e+04,  6.017200e+06,
         1.840600e+06,  1.829300e+06,  1.913800e+06,  1.913600e+06,
        -3.480000e+04,  5.248000e+05, -3.550000e+04, -6.160000e+04,
        -1.100000e+04,  8.000000e+02,  1.027600e+06, -6.480000e+04,
        -3.850000e+04,  8.780000e+04,  0.000000e+00, -5.000000e+02,
        -3.490000e+04, -1.216000e+05, -5.610000e+04, -6.500000e+03,
         0.000000e+00,  0.000000e+00,  9.472000e+05,  1.007200e+06,
        -5.950000e+04, -4.100000e+04, -5.420000e+04,  0.000000e+00,
        -6.390000e+04,  5.078000e+05, -1.930000e+04,  5.635000e+05,
         5.634000e+05, -8.590000e+04, -2.040000e+04, -2.500000e+03,
         4.763000e+05,  5.429000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -2.000000e+02,  1.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -6.160000e+04,  5.248000e+05,
         1.349000e+05,  2.830000e+04, -2.000000e+02, -1.449000e+05,
        -1.020000e+04,  5.949000e+05, -1.141000e+05,  5.492000e+05,
         1.054700e+06,  1.794300e+06,  4.770000e+04, -6.400000e+03,
        -4.050000e+04,  1.770000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.830000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-4.500000e+03,  1.044000e+05,  9.110000e+04,  2.862000e+05,
         1.407000e+05, -7.260000e+04, -6.360000e+04, -7.000000e+02,
         1.044000e+05,  1.100000e+03,  1.044000e+05,  6.560000e+04,
         4.640000e+04,  1.773000e+05,  2.190000e+05,  6.950000e+04,
         1.120000e+04,  2.624000e+05,  3.926000e+05,  5.603000e+05,
         5.399000e+05,  8.882000e+05,  6.149000e+05,  2.895000e+05,
         1.288200e+06,  1.180700e+06,  1.400000e+06,  5.135800e+06,
         3.268000e+05,  3.277000e+05,  3.273000e+05,  3.254000e+05,
         2.959000e+05,  3.284000e+05,  2.410400e+06,  2.636200e+06,
         2.606900e+06,  2.513000e+05,  3.043000e+05,  3.004000e+05,
         4.270000e+05,  6.417000e+05,  9.244000e+05,  9.245000e+05,
         7.925000e+05,  6.576000e+05,  7.724000e+05,  5.980000e+05,
         1.655600e+06,  1.709900e+06,  1.050200e+06,  4.907000e+05,
         3.598000e+05,  5.055000e+05,  6.432000e+05,  9.461000e+05,
         9.468000e+05,  1.058700e+06,  1.044400e+06, -1.738000e+05,
         2.381000e+05,  3.709000e+05,  1.129000e+05,  1.425000e+05,
         1.425000e+05,  1.425000e+05,  1.425000e+05,  2.539000e+05,
         2.508000e+05,  2.934000e+05,  3.482000e+05, -3.190000e+04,
        -1.509000e+05, -8.410000e+04,  4.143000e+05,  4.721000e+05,
         1.067000e+05,  1.067000e+05,  2.190000e+05,  2.190000e+05,
         2.190000e+05,  9.510000e+05,  1.227500e+06,  1.190900e+06,
         6.205000e+05,  2.987000e+05,  4.622000e+05,  2.311000e+05,
         6.478000e+05,  1.037800e+06,  6.478000e+05,  1.038900e+06,
         8.596000e+05,  7.079000e+05,  8.161000e+05,  9.312000e+05,
         4.000000e+05,  4.541000e+05,  1.404600e+06,  2.216000e+05,
         1.144000e+05,  1.705000e+05,  2.940000e+05,  7.622000e+05,
        -1.927000e+05, -2.400000e+04, -4.530000e+04, -8.540000e+04,
        -1.116000e+05,  2.432000e+05,  3.515000e+05,  1.349000e+05,
         5.145000e+05,  4.888000e+05,  6.506000e+05,  7.591000e+05,
         7.663000e+05,  3.626000e+05,  5.215000e+05,  4.701000e+05,
         7.764000e+05,  5.310000e+05,  3.781000e+05,  4.654000e+05,
         8.152000e+05,  6.833000e+05,  6.160000e+04,  6.160000e+04,
         2.327000e+05,  1.019100e+06,  7.478000e+05,  1.384500e+06,
         1.149000e+05,  1.151000e+05,  4.270000e+04,  4.280000e+04,
         5.909000e+05,  4.340000e+04, -3.916000e+05,  4.280000e+04,
         1.495000e+05,  1.495000e+05,  1.495000e+05,  1.494000e+05,
         1.475000e+05, -1.636000e+05, -1.634000e+05, -1.635000e+05,
        -9.812000e+05, -2.535000e+05, -1.053000e+05,  1.840600e+06,
         1.097100e+06,  9.587000e+05,  1.408400e+06,  1.409100e+06,
        -3.360000e+04,  6.250000e+04, -1.020000e+04, -5.350000e+04,
        -1.260000e+04, -7.600000e+03,  1.773000e+05,  6.560000e+04,
        -4.080000e+04,  7.580000e+04,  0.000000e+00,  0.000000e+00,
        -3.130000e+04, -8.240000e+04, -3.180000e+04, -3.400000e+04,
         0.000000e+00,  0.000000e+00,  1.044000e+05,  1.556000e+05,
        -6.270000e+04, -3.780000e+04, -3.080000e+04,  0.000000e+00,
        -5.450000e+04,  8.500000e+04, -2.000000e+04,  6.890000e+04,
         6.890000e+04, -7.230000e+04, -2.140000e+04, -1.030000e+04,
        -2.200000e+03,  4.770000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         7.000000e+02, -1.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -5.350000e+04,  6.250000e+04,
         2.330000e+04,  1.495000e+05,  7.000000e+02, -4.500000e+03,
         1.044000e+05,  2.190000e+05,  1.425000e+05,  2.934000e+05,
         3.255000e+05,  5.909000e+05,  4.280000e+04,  1.151000e+05,
        -1.635000e+05, -1.053000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.495000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-4.700000e+03,  1.043000e+05,  9.100000e+04,  2.869000e+05,
         1.410000e+05, -7.260000e+04, -6.320000e+04, -9.000000e+02,
         1.043000e+05,  9.000000e+02,  1.043000e+05,  6.550000e+04,
         4.640000e+04,  1.776000e+05,  2.194000e+05,  6.940000e+04,
         1.120000e+04,  2.619000e+05,  3.923000e+05,  5.603000e+05,
         5.398000e+05,  8.864000e+05,  6.163000e+05,  2.890000e+05,
         1.287800e+06,  1.180000e+06,  1.399700e+06,  5.129900e+06,
         3.270000e+05,  3.280000e+05,  3.274000e+05,  3.257000e+05,
         2.963000e+05,  3.295000e+05,  2.413700e+06,  2.639800e+06,
         2.610400e+06,  2.523000e+05,  3.053000e+05,  3.015000e+05,
         4.281000e+05,  6.435000e+05,  9.214000e+05,  9.213000e+05,
         7.898000e+05,  6.567000e+05,  7.716000e+05,  6.136000e+05,
         1.653300e+06,  1.707700e+06,  1.050300e+06,  4.915000e+05,
         3.603000e+05,  5.066000e+05,  6.449000e+05,  9.460000e+05,
         9.475000e+05,  1.058800e+06,  1.044400e+06, -1.718000e+05,
         2.354000e+05,  3.713000e+05,  1.129000e+05,  1.422000e+05,
         1.422000e+05,  1.421000e+05,  1.422000e+05,  2.537000e+05,
         2.507000e+05,  2.932000e+05,  3.481000e+05, -3.180000e+04,
        -1.507000e+05, -8.400000e+04,  4.139000e+05,  4.666000e+05,
         1.066000e+05,  1.066000e+05,  2.194000e+05,  2.193000e+05,
         2.194000e+05,  9.508000e+05,  1.227800e+06,  1.189300e+06,
         6.184000e+05,  2.992000e+05,  4.631000e+05,  2.321000e+05,
         6.474000e+05,  1.037900e+06,  6.474000e+05,  1.039000e+06,
         8.597000e+05,  7.079000e+05,  8.165000e+05,  9.316000e+05,
         4.018000e+05,  4.560000e+05,  1.407600e+06,  2.225000e+05,
         1.149000e+05,  1.711000e+05,  2.952000e+05,  7.613000e+05,
        -1.921000e+05, -2.330000e+04, -4.460000e+04, -8.440000e+04,
        -1.107000e+05,  2.461000e+05,  3.546000e+05,  1.376000e+05,
         5.178000e+05,  4.920000e+05,  6.541000e+05,  7.628000e+05,
         7.668000e+05,  3.629000e+05,  5.219000e+05,  4.708000e+05,
         7.772000e+05,  5.315000e+05,  3.785000e+05,  4.669000e+05,
         8.139000e+05,  6.825000e+05,  6.300000e+04,  6.300000e+04,
         2.342000e+05,  1.024000e+06,  7.524000e+05,  1.404900e+06,
         1.151000e+05,  1.152000e+05,  4.260000e+04,  4.260000e+04,
         5.870000e+05,  4.410000e+04, -3.920000e+05,  4.260000e+04,
         1.494000e+05,  1.494000e+05,  1.494000e+05,  1.493000e+05,
         1.474000e+05, -1.640000e+05, -1.639000e+05, -1.640000e+05,
        -9.841000e+05, -2.534000e+05, -1.054000e+05,  1.829300e+06,
         9.587000e+05,  1.109600e+06,  1.560800e+06,  1.562300e+06,
        -3.260000e+04,  6.270000e+04, -1.010000e+04, -5.350000e+04,
        -1.260000e+04, -7.600000e+03,  1.776000e+05,  6.550000e+04,
        -4.080000e+04,  7.580000e+04,  0.000000e+00,  0.000000e+00,
        -3.120000e+04, -8.230000e+04, -3.170000e+04, -3.390000e+04,
         0.000000e+00,  0.000000e+00,  1.044000e+05,  1.559000e+05,
        -6.270000e+04, -3.790000e+04, -3.060000e+04,  0.000000e+00,
        -5.370000e+04,  8.540000e+04, -1.960000e+04,  6.910000e+04,
         6.910000e+04, -7.240000e+04, -2.130000e+04, -1.030000e+04,
        -2.000000e+03,  4.800000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.500000e+03, -1.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -5.350000e+04,  6.270000e+04,
         2.330000e+04,  1.494000e+05,  1.500000e+03, -4.700000e+03,
         1.043000e+05,  2.193000e+05,  1.422000e+05,  2.932000e+05,
         3.258000e+05,  5.870000e+05,  4.260000e+04,  1.152000e+05,
        -1.640000e+05, -1.054000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.494000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 4.740000e+04,  2.540000e+05,  2.138000e+05,  3.072000e+05,
         1.773000e+05,  8.600000e+04, -8.900000e+03,  5.470000e+04,
         2.540000e+05,  5.830000e+04,  2.540000e+05,  1.826000e+05,
         1.110000e+05, -6.680000e+04,  3.241000e+05,  1.903000e+05,
         2.650000e+04,  7.303000e+05,  5.138000e+05,  8.397000e+05,
         7.713000e+05,  9.552000e+05,  8.888000e+05,  7.234000e+05,
         2.064500e+06,  2.321900e+06,  2.279700e+06,  5.424600e+06,
         2.785000e+05,  2.796000e+05,  2.794000e+05,  2.760000e+05,
         8.830000e+04,  2.818000e+05,  1.390000e+06,  1.825400e+06,
         1.733300e+06,  1.326000e+05,  2.353000e+05,  2.184000e+05,
         4.849000e+05,  6.012000e+05,  9.597000e+05,  9.596000e+05,
         9.300000e+05,  8.988000e+05,  8.950000e+05,  6.712000e+05,
         1.781600e+06,  1.886900e+06,  1.739000e+06,  2.620000e+05,
         5.012000e+05,  6.316000e+05,  6.037000e+05,  1.290100e+06,
         1.292300e+06,  1.507500e+06,  1.461700e+06, -2.185000e+05,
         3.385000e+05,  6.650000e+05,  2.609000e+05,  3.854000e+05,
         3.854000e+05,  3.854000e+05,  3.854000e+05,  5.996000e+05,
         1.296000e+05,  5.179000e+05,  6.227000e+05, -6.300000e+04,
        -8.210000e+04,  4.130000e+04,  2.740000e+05,  6.904000e+05,
         2.481000e+05,  2.481000e+05,  3.241000e+05,  3.240000e+05,
         3.241000e+05,  1.960300e+06,  2.492700e+06,  1.469000e+06,
         6.683000e+05,  7.959000e+05,  1.111300e+06,  1.089700e+06,
         1.693700e+06,  2.443300e+06,  1.693800e+06,  2.446300e+06,
         1.178800e+06, -1.621000e+05, -4.178000e+05,  2.676000e+05,
         4.759000e+05,  5.810000e+05,  3.365300e+06,  1.880000e+04,
         2.774000e+05,  3.864000e+05,  2.144000e+05,  5.734000e+05,
        -3.741000e+05, -5.140000e+04, -1.166000e+05, -6.326000e+05,
        -1.560000e+05,  2.297000e+05, -2.690000e+04,  4.863000e+05,
         7.563000e+05,  6.589000e+05,  6.062000e+05,  8.169000e+05,
         1.301600e+06,  9.223000e+05,  1.230400e+06,  6.649000e+05,
         1.318500e+06,  1.247200e+06,  9.626000e+05,  6.094000e+05,
         9.751000e+05,  9.455000e+05,  2.307000e+05,  2.307000e+05,
         5.581000e+05,  2.028100e+06,  1.501600e+06,  4.594600e+06,
         2.774000e+05,  2.777000e+05,  8.290000e+04,  8.300000e+04,
         6.429000e+05,  8.520000e+04, -4.590000e+05,  8.300000e+04,
         3.456000e+05,  3.456000e+05,  3.456000e+05,  3.454000e+05,
         3.412000e+05, -3.749000e+05, -3.746000e+05, -3.747000e+05,
        -2.249100e+06, -5.996000e+05, -2.582000e+05,  1.913800e+06,
         1.408400e+06,  1.560800e+06,  2.849600e+06,  2.604200e+06,
        -6.560000e+04, -1.930000e+04, -1.210000e+04, -1.027000e+05,
        -2.560000e+04, -1.890000e+04, -6.680000e+04,  1.826000e+05,
        -8.180000e+04,  1.453000e+05,  0.000000e+00,  2.000000e+02,
        -6.310000e+04, -1.492000e+05, -5.510000e+04, -7.840000e+04,
         0.000000e+00,  0.000000e+00, -2.086000e+05, -1.101000e+05,
        -1.254000e+05, -7.390000e+04, -5.320000e+04,  0.000000e+00,
        -1.037000e+05, -3.910000e+04, -3.970000e+04, -1.400000e+04,
        -1.400000e+04, -1.358000e+05, -4.100000e+04, -2.300000e+04,
        -1.481000e+05, -5.470000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.200000e+03,  1.200000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.027000e+05, -1.930000e+04,
        -8.800000e+03,  3.456000e+05,  2.200000e+03,  4.740000e+04,
         2.540000e+05,  3.240000e+05,  3.854000e+05,  5.179000e+05,
         2.762000e+05,  6.429000e+05,  8.300000e+04,  2.777000e+05,
        -3.747000e+05, -2.582000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  3.456000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 4.730000e+04,  2.539000e+05,  2.137000e+05,  3.072000e+05,
         1.773000e+05,  8.600000e+04, -8.700000e+03,  5.460000e+04,
         2.539000e+05,  5.820000e+04,  2.539000e+05,  1.825000e+05,
         1.110000e+05, -6.680000e+04,  3.240000e+05,  1.903000e+05,
         2.650000e+04,  7.300000e+05,  5.136000e+05,  8.395000e+05,
         7.711000e+05,  9.552000e+05,  8.887000e+05,  7.232000e+05,
         2.064000e+06,  2.321300e+06,  2.279300e+06,  5.426100e+06,
         2.785000e+05,  2.796000e+05,  2.794000e+05,  2.759000e+05,
         8.820000e+04,  2.822000e+05,  1.390200e+06,  1.825700e+06,
         1.733700e+06,  1.329000e+05,  2.356000e+05,  2.188000e+05,
         4.849000e+05,  6.013000e+05,  9.598000e+05,  9.597000e+05,
         9.302000e+05,  8.990000e+05,  8.951000e+05,  6.719000e+05,
         1.782900e+06,  1.888200e+06,  1.740300e+06,  2.620000e+05,
         5.012000e+05,  6.316000e+05,  6.037000e+05,  1.289700e+06,
         1.292300e+06,  1.507200e+06,  1.461500e+06, -2.175000e+05,
         3.385000e+05,  6.649000e+05,  2.608000e+05,  3.853000e+05,
         3.853000e+05,  3.852000e+05,  3.853000e+05,  5.995000e+05,
         1.295000e+05,  5.178000e+05,  6.227000e+05, -6.300000e+04,
        -8.210000e+04,  4.130000e+04,  2.739000e+05,  6.903000e+05,
         2.480000e+05,  2.480000e+05,  3.240000e+05,  3.240000e+05,
         3.240000e+05,  1.960200e+06,  2.492700e+06,  1.469000e+06,
         6.685000e+05,  7.960000e+05,  1.111500e+06,  1.089900e+06,
         1.693600e+06,  2.443300e+06,  1.693600e+06,  2.446300e+06,
         1.178800e+06, -1.624000e+05, -4.180000e+05,  2.674000e+05,
         4.766000e+05,  5.817000e+05,  3.366900e+06,  1.920000e+04,
         2.776000e+05,  3.867000e+05,  2.148000e+05,  5.737000e+05,
        -3.738000e+05, -5.100000e+04, -1.162000e+05, -6.322000e+05,
        -1.558000e+05,  2.311000e+05, -2.540000e+04,  4.876000e+05,
         7.578000e+05,  6.604000e+05,  6.077000e+05,  8.184000e+05,
         1.301800e+06,  9.225000e+05,  1.230600e+06,  6.651000e+05,
         1.318600e+06,  1.247400e+06,  9.627000e+05,  6.101000e+05,
         9.754000e+05,  9.458000e+05,  2.314000e+05,  2.314000e+05,
         5.589000e+05,  2.030400e+06,  1.503700e+06,  4.604700e+06,
         2.773000e+05,  2.776000e+05,  8.290000e+04,  8.290000e+04,
         6.428000e+05,  8.550000e+04, -4.590000e+05,  8.290000e+04,
         3.456000e+05,  3.455000e+05,  3.455000e+05,  3.453000e+05,
         3.412000e+05, -3.749000e+05, -3.746000e+05, -3.747000e+05,
        -2.248900e+06, -5.996000e+05, -2.583000e+05,  1.913600e+06,
         1.409100e+06,  1.562300e+06,  2.604200e+06,  4.382000e+06,
        -6.520000e+04, -1.920000e+04, -1.210000e+04, -1.027000e+05,
        -2.560000e+04, -1.890000e+04, -6.680000e+04,  1.825000e+05,
        -8.180000e+04,  1.453000e+05,  0.000000e+00,  2.000000e+02,
        -6.310000e+04, -1.492000e+05, -5.510000e+04, -7.840000e+04,
         0.000000e+00,  0.000000e+00, -2.087000e+05, -1.101000e+05,
        -1.254000e+05, -7.390000e+04, -5.320000e+04,  0.000000e+00,
        -1.032000e+05, -3.890000e+04, -3.950000e+04, -1.400000e+04,
        -1.400000e+04, -1.359000e+05, -4.100000e+04, -2.300000e+04,
        -1.481000e+05, -5.470000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.600000e+03,  1.200000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.027000e+05, -1.920000e+04,
        -8.800000e+03,  3.455000e+05,  2.600000e+03,  4.730000e+04,
         2.539000e+05,  3.240000e+05,  3.853000e+05,  5.178000e+05,
         2.761000e+05,  6.428000e+05,  8.290000e+04,  2.776000e+05,
        -3.747000e+05, -2.583000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  3.456000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-9.500000e+03, -8.700000e+03, -7.600000e+03, -6.800000e+03,
        -8.100000e+03, -3.750000e+04, -1.850000e+04, -9.400000e+03,
        -8.700000e+03, -9.400000e+03, -8.700000e+03, -9.900000e+03,
        -3.800000e+03,  1.070000e+04, -8.200000e+03, -1.000000e+04,
        -9.000000e+02, -3.960000e+04, -1.400000e+04, -1.830000e+04,
        -1.140000e+04, -1.840000e+04, -2.220000e+04, -2.390000e+04,
        -5.270000e+04, -7.220000e+04, -5.580000e+04, -1.034000e+05,
        -5.000000e+02, -3.000000e+02, -4.000000e+02, -1.000000e+02,
         8.000000e+03,  1.000000e+02,  2.500000e+04,  2.110000e+04,
         2.840000e+04,  1.500000e+03,  1.400000e+03,  2.400000e+03,
        -1.520000e+04, -1.220000e+04, -1.680000e+04, -1.680000e+04,
        -1.920000e+04, -2.150000e+04, -1.590000e+04, -1.070000e+04,
        -3.420000e+04, -3.490000e+04, -4.670000e+04,  2.800000e+03,
        -1.610000e+04, -1.500000e+04, -1.180000e+04, -2.860000e+04,
        -2.820000e+04, -3.150000e+04, -2.690000e+04, -1.740000e+04,
        -1.080000e+04, -1.790000e+04, -8.500000e+03, -1.670000e+04,
        -1.670000e+04, -1.670000e+04, -1.670000e+04, -1.990000e+04,
         2.800000e+03, -1.680000e+04, -1.720000e+04,  2.437400e+06,
         2.450900e+06,  2.431600e+06,  1.000000e+03, -1.930000e+04,
        -8.300000e+03, -8.300000e+03, -8.200000e+03, -8.200000e+03,
        -8.200000e+03, -6.880000e+04, -7.520000e+04, -3.060000e+04,
         2.284100e+06,  4.842700e+06,  4.892200e+06,  4.861400e+06,
        -6.860000e+04, -7.970000e+04, -6.860000e+04, -8.050000e+04,
        -3.110000e+04,  2.860000e+04,  4.780000e+04,  2.240000e+04,
        -7.600000e+03, -8.300000e+03, -1.101000e+05,  9.600000e+03,
        -9.600000e+03, -1.110000e+04,  2.459700e+06, -2.000000e+02,
         7.200000e+03,  2.800000e+03,  9.700000e+03,  2.630000e+04,
         2.452100e+06, -1.270000e+04,  7.500000e+03, -3.290000e+04,
        -1.620000e+04, -8.500000e+03, -4.000000e+03, -5.400000e+03,
        -3.350000e+04, -3.490000e+04, -3.510000e+04, -1.590000e+04,
        -3.370000e+04, -4.070000e+04, -4.350000e+04, -1.050000e+04,
        -2.050000e+04, -2.290000e+04, -1.760000e+04, -1.760000e+04,
        -1.780000e+04, -5.620000e+04, -5.280000e+04, -2.956000e+05,
         2.451000e+06,  2.455200e+06, -1.600000e+03, -1.600000e+03,
        -1.220000e+04, -1.200000e+03,  8.300000e+03, -1.600000e+03,
        -1.120000e+04, -1.120000e+04, -1.120000e+04, -1.120000e+04,
        -1.090000e+04,  2.309100e+06,  2.307400e+06,  2.307800e+06,
         1.385190e+07,  1.640000e+04,  7.300000e+03, -3.480000e+04,
        -3.360000e+04, -3.260000e+04, -6.560000e+04, -6.520000e+04,
         2.499600e+06,  1.800000e+03,  3.000000e+02,  3.000000e+02,
         7.000000e+02,  7.000000e+02,  1.070000e+04, -9.900000e+03,
         2.300000e+03,  1.200000e+03,  0.000000e+00,  0.000000e+00,
         3.300000e+03,  7.000000e+02,  1.800000e+03,  2.500000e+03,
         0.000000e+00,  0.000000e+00,  1.170000e+04,  1.230000e+04,
         3.700000e+03,  1.100000e+03,  1.800000e+03,  0.000000e+00,
         6.000000e+02,  5.700000e+03,  1.300000e+03,  1.700000e+03,
         1.600000e+03,  4.000000e+02,  1.300000e+03,  7.000000e+02,
         1.900000e+03,  2.900000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.000000e+02,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02,  3.000000e+02,  1.800000e+03,
         1.400000e+03, -1.120000e+04,  4.000000e+02, -9.500000e+03,
        -8.700000e+03, -8.200000e+03, -1.670000e+04, -1.680000e+04,
        -1.000000e+02, -1.220000e+04, -1.600000e+03,  2.455200e+06,
         2.307800e+06,  7.300000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.120000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-2.180000e+04, -2.380000e+04, -1.580000e+04,  3.142000e+05,
         1.470000e+05, -8.710000e+04, -4.350000e+04, -2.230000e+04,
        -2.380000e+04, -2.250000e+04, -2.380000e+04, -2.370000e+04,
        -9.600000e+03,  8.000000e+03,  1.405000e+05, -2.420000e+04,
        -2.300000e+03, -9.470000e+04, -6.580000e+04, -6.920000e+04,
        -5.650000e+04,  4.214000e+05,  4.219000e+05, -7.640000e+04,
        -1.714000e+05, -2.039000e+05, -1.736000e+05,  2.699300e+06,
        -1.930000e+04, -1.940000e+04, -1.940000e+04, -1.920000e+04,
        -3.600000e+03, -1.940000e+04, -1.220000e+05, -1.267000e+05,
        -1.097000e+05, -1.660000e+04, -1.750000e+04, -1.350000e+04,
         4.615000e+05,  8.030000e+05,  2.585000e+05,  2.585000e+05,
         2.570000e+05,  2.567000e+05,  2.621000e+05,  1.175000e+05,
         5.173000e+05,  5.163000e+05,  5.089000e+05,  3.131000e+05,
         2.882000e+05,  4.551000e+05,  8.027000e+05, -1.152000e+05,
        -1.151000e+05, -1.175000e+05, -1.090000e+05, -4.340000e+04,
         1.302000e+05,  1.073000e+05, -2.080000e+04, -4.910000e+04,
        -4.910000e+04, -4.910000e+04, -4.910000e+04, -5.120000e+04,
        -1.670000e+04,  1.146000e+05,  1.136000e+05,  1.500000e+03,
        -8.000000e+02, -3.700000e+03,  1.458000e+05,  2.970000e+04,
        -1.920000e+04, -1.920000e+04,  1.405000e+05,  1.405000e+05,
         1.405000e+05,  1.282000e+05,  1.231000e+05,  1.913000e+05,
         2.402000e+05, -9.780000e+04, -1.005000e+05, -1.066000e+05,
        -1.990000e+05, -2.063000e+05, -1.990000e+05, -2.065000e+05,
        -1.340000e+05, -1.240000e+04,  2.000000e+04, -1.660000e+04,
        -4.380000e+04, -4.480000e+04, -3.018000e+05,  6.400000e+03,
        -2.610000e+04, -2.730000e+04, -1.760000e+04,  1.255000e+05,
         6.800000e+03,  3.800000e+03,  1.600000e+04,  3.930000e+04,
        -1.720000e+04, -6.010000e+04, -2.780000e+04, -9.250000e+04,
        -6.510000e+04, -4.480000e+04, -6.030000e+04, -6.230000e+04,
        -1.002000e+05, -1.008000e+05, -1.035000e+05, -6.830000e+04,
        -1.014000e+05, -1.041000e+05, -1.013000e+05, -4.520000e+04,
         2.556000e+05,  2.541000e+05, -4.480000e+04, -4.480000e+04,
        -4.940000e+04, -1.639000e+05, -1.589000e+05, -7.943000e+05,
        -2.550000e+04, -2.550000e+04, -1.500000e+03, -1.500000e+03,
         1.170000e+05, -1.500000e+03,  4.370000e+04, -1.500000e+03,
        -2.740000e+04, -2.740000e+04, -2.740000e+04, -2.730000e+04,
        -2.710000e+04,  2.640000e+04,  2.640000e+04,  2.640000e+04,
         1.583000e+05,  5.320000e+04,  2.580000e+04,  5.248000e+05,
         6.250000e+04,  6.270000e+04, -1.930000e+04, -1.920000e+04,
         1.800000e+03,  2.191000e+05, -8.100000e+03, -3.000000e+02,
         1.000000e+03,  2.200000e+03,  8.000000e+03, -2.370000e+04,
         1.800000e+03, -2.800000e+03,  0.000000e+00, -3.000000e+02,
        -1.800000e+03, -5.800000e+03, -6.500000e+03,  6.200000e+03,
         0.000000e+00,  0.000000e+00,  1.040000e+04,  9.600000e+03,
         3.300000e+03,  1.400000e+03, -6.200000e+03,  0.000000e+00,
         0.000000e+00,  4.500000e+03,  9.000000e+02,  1.738000e+05,
         1.737000e+05,  6.000000e+02, -3.000000e+02,  1.200000e+03,
         1.714000e+05,  1.730000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.700000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.000000e+02,  2.191000e+05,
         1.100000e+03, -2.740000e+04,  0.000000e+00, -2.180000e+04,
        -2.380000e+04,  1.405000e+05, -4.910000e+04,  1.146000e+05,
        -1.930000e+04,  1.170000e+05, -1.500000e+03, -2.550000e+04,
         2.640000e+04,  2.580000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.740000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 6.000000e+02, -2.100000e+04, -1.220000e+04, -1.790000e+04,
        -8.600000e+03,  3.200000e+03,  1.900000e+03,  6.000000e+02,
        -2.100000e+04,  6.000000e+02, -2.100000e+04,  0.000000e+00,
        -4.300000e+03,  3.300000e+03, -9.400000e+03,  0.000000e+00,
        -1.000000e+03, -1.000000e+02,  2.600000e+03, -4.040000e+04,
        -6.900000e+04, -2.770000e+04, -4.760000e+04, -1.200000e+03,
         2.500000e+03, -8.000000e+02, -2.070000e+04, -1.742000e+05,
         2.600000e+03,  2.600000e+03,  2.700000e+03,  2.600000e+03,
         3.700000e+03,  2.600000e+03,  2.640000e+04, -3.100000e+04,
        -6.910000e+04,  3.200000e+03, -1.130000e+04, -2.070000e+04,
        -2.650000e+04, -4.430000e+04, -1.800000e+04, -1.800000e+04,
        -2.760000e+04, -3.740000e+04, -4.140000e+04, -8.600000e+03,
        -3.570000e+04, -5.010000e+04, -9.810000e+04, -1.620000e+04,
        -1.810000e+04, -2.730000e+04, -4.430000e+04,  4.000000e+03,
         4.000000e+03, -2.300000e+04, -4.370000e+04,  3.300000e+03,
         5.175000e+05, -1.030000e+04, -5.000000e+02, -3.000000e+02,
        -3.000000e+02, -3.000000e+02, -3.000000e+02, -2.170000e+04,
         3.000000e+03, -9.700000e+03, -2.040000e+04,  3.000000e+02,
        -9.800000e+03, -1.600000e+03, -7.100000e+03, -6.500000e+03,
        -5.800000e+03, -5.800000e+03, -9.400000e+03, -9.400000e+03,
        -9.400000e+03, -2.060000e+04, -7.410000e+04, -1.520000e+04,
        -1.560000e+04, -6.000000e+02, -3.260000e+04, -5.980000e+04,
        -1.800000e+03, -7.670000e+04, -1.800000e+03, -7.660000e+04,
         4.700000e+03,  1.360000e+04,  1.690000e+04, -3.160000e+04,
         2.400000e+03, -1.200000e+04, -1.899000e+05,  2.900000e+03,
        -5.000000e+02, -1.490000e+04,  2.900000e+03, -5.300000e+03,
         1.400000e+03, -3.230000e+04, -7.020000e+04,  4.900000e+03,
         2.000000e+03,  4.100000e+03,  7.300000e+03,  8.000000e+02,
        -6.780000e+04, -1.153000e+05,  5.500000e+03, -2.320000e+04,
         5.000000e+02, -1.200000e+03, -4.440000e+04,  2.300000e+03,
         6.000000e+02, -3.320000e+04,  5.300000e+03,  1.900000e+03,
        -1.870000e+04, -2.830000e+04,  5.000000e+02,  5.000000e+02,
        -3.190000e+04, -6.210000e+04,  9.900000e+03,  6.400000e+03,
        -4.000000e+02, -4.000000e+02, -3.000000e+02, -3.000000e+02,
        -9.000000e+03, -3.000000e+02, -2.500000e+03, -3.000000e+02,
        -7.000000e+02, -7.000000e+02, -7.000000e+02, -7.000000e+02,
        -7.000000e+02,  9.000000e+02,  9.000000e+02,  9.000000e+02,
         5.200000e+03,  1.300000e+03,  5.000000e+02, -3.550000e+04,
        -1.020000e+04, -1.010000e+04, -1.210000e+04, -1.210000e+04,
         3.000000e+02, -8.100000e+03,  5.340000e+05,  7.000000e+02,
        -6.000000e+03, -2.500000e+03,  3.300000e+03,  0.000000e+00,
        -1.750000e+04, -8.000000e+02,  0.000000e+00,  1.000000e+02,
         4.133000e+05,  5.347000e+05,  5.194000e+05,  2.000000e+02,
         0.000000e+00,  0.000000e+00,  3.800000e+03, -1.060000e+04,
        -3.000000e+04, -6.200000e+03,  5.019000e+05,  0.000000e+00,
         7.000000e+02,  1.600000e+03, -8.800000e+03, -8.500000e+03,
        -8.500000e+03,  9.000000e+02, -1.200000e+04, -2.500000e+03,
        -7.600000e+03, -2.050000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  7.000000e+02, -8.100000e+03,
         4.000000e+02, -7.000000e+02,  0.000000e+00,  6.000000e+02,
        -2.100000e+04, -9.400000e+03, -3.000000e+02, -9.700000e+03,
         2.600000e+03, -9.000000e+03, -3.000000e+02, -4.000000e+02,
         9.000000e+02,  5.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -7.000000e+02,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 9.550000e+04, -1.260000e+04, -1.750000e+04, -1.470000e+04,
         4.050000e+04,  4.478000e+05,  2.566000e+05,  9.730000e+04,
        -1.260000e+04,  9.810000e+04, -1.260000e+04,  3.650000e+04,
        -7.500000e+03,  1.110000e+04, -1.570000e+04,  3.820000e+04,
        -1.500000e+03,  1.460000e+05,  1.284000e+05, -3.290000e+04,
        -4.100000e+04, -3.530000e+04, -4.370000e+04,  6.080000e+04,
        -1.150000e+04,  1.640000e+04, -1.188000e+05, -1.067000e+05,
        -5.300000e+03, -5.300000e+03, -5.200000e+03, -5.500000e+03,
         5.600000e+03, -5.300000e+03,  1.991000e+05, -1.610000e+04,
        -2.690000e+04,  5.060000e+04, -3.500000e+03, -5.900000e+03,
         2.600000e+04, -2.870000e+04, -3.060000e+04, -3.060000e+04,
        -3.470000e+04, -3.880000e+04, -3.720000e+04, -2.080000e+04,
        -1.110000e+04, -6.500000e+04, -8.530000e+04, -3.400000e+03,
         2.460000e+04, -3.030000e+04, -2.930000e+04,  5.150000e+04,
         5.150000e+04, -5.610000e+04, -6.150000e+04,  3.873000e+05,
        -1.470000e+04, -3.230000e+04, -1.300000e+04,  7.820000e+04,
         7.820000e+04,  7.810000e+04,  7.820000e+04, -2.900000e+04,
         5.040000e+04,  2.320000e+04, -3.070000e+04,  3.000000e+02,
        -3.700000e+03, -3.350000e+04, -4.400000e+03, -2.660000e+04,
        -1.490000e+04, -1.490000e+04, -1.570000e+04, -1.570000e+04,
        -1.570000e+04,  1.468000e+05, -1.213000e+05,  9.130000e+04,
         1.703000e+05,  1.009000e+05, -5.930000e+04, -6.770000e+04,
         2.568000e+05, -1.183000e+05,  2.568000e+05, -1.179000e+05,
         2.019000e+05,  2.359000e+05,  2.081000e+05,  2.130000e+04,
         3.370000e+04, -2.030000e+04, -1.648000e+05, -1.910000e+04,
         8.900000e+03, -4.490000e+04, -5.000000e+03, -9.600000e+03,
         1.359000e+05, -2.460000e+04, -3.360000e+04,  1.080000e+05,
         1.533000e+05,  2.409000e+05,  2.130000e+05,  2.689000e+05,
        -2.880000e+04, -4.150000e+04,  8.370000e+04, -2.420000e+04,
        -5.380000e+04,  1.004000e+05, -6.190000e+04,  7.250000e+04,
        -5.440000e+04, -5.990000e+04,  1.085000e+05, -2.100000e+04,
        -3.620000e+04, -4.030000e+04,  1.301000e+05,  1.301000e+05,
        -2.720000e+04, -1.044000e+05,  1.654000e+05,  2.119700e+06,
        -1.600000e+04, -1.610000e+04, -3.010000e+04, -3.020000e+04,
        -2.070000e+04, -3.020000e+04, -3.860000e+04, -3.020000e+04,
        -1.640000e+04, -1.640000e+04, -1.640000e+04, -1.640000e+04,
        -1.740000e+04,  1.650000e+04,  1.650000e+04,  1.650000e+04,
         9.890000e+04,  3.700000e+03, -1.320000e+04, -6.160000e+04,
        -5.350000e+04, -5.350000e+04, -1.027000e+05, -1.027000e+05,
         3.000000e+02, -3.000000e+02,  7.000000e+02,  6.660000e+04,
         1.400000e+03,  2.300000e+03,  1.110000e+04,  3.650000e+04,
         3.200000e+03, -5.650000e+04,  0.000000e+00,  0.000000e+00,
        -3.000000e+02,  5.860000e+04,  2.300000e+03,  3.900000e+03,
         0.000000e+00,  0.000000e+00,  6.760000e+04,  1.280000e+04,
         4.900000e+03,  1.900000e+04,  2.200000e+03,  0.000000e+00,
         6.560000e+04,  5.800000e+03,  1.600000e+03,  5.000000e+02,
         5.000000e+02,  5.760000e+04,  1.500000e+03,  5.000000e+02,
         5.780000e+04,  1.900000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  6.660000e+04, -3.000000e+02,
         1.500000e+03, -1.640000e+04,  0.000000e+00,  9.550000e+04,
        -1.260000e+04, -1.570000e+04,  7.820000e+04,  2.320000e+04,
        -5.500000e+03, -2.070000e+04, -3.020000e+04, -1.610000e+04,
         1.650000e+04, -1.320000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.640000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-2.300000e+03,  1.047000e+05, -3.100000e+03, -2.200000e+03,
        -2.200000e+03, -7.800000e+03, -3.200000e+03, -3.700000e+03,
         1.064000e+05, -5.400000e+03,  1.358000e+05, -1.700000e+04,
         2.120000e+04,  3.800000e+03, -3.300000e+03, -2.110000e+04,
         4.400000e+03, -6.790000e+04, -6.700000e+03,  1.298000e+05,
        -7.200000e+03, -6.200000e+03,  8.200000e+04, -1.130000e+04,
        -2.170000e+04, -2.870000e+04,  8.140000e+04, -3.600000e+04,
        -7.000000e+02, -9.000000e+02, -6.000000e+02, -6.000000e+02,
         2.500000e+03, -9.000000e+02,  3.900000e+03,  1.849000e+05,
         3.200000e+03,  2.000000e+02,  4.580000e+04,  0.000000e+00,
        -4.400000e+03, -3.400000e+03, -5.400000e+03, -5.500000e+03,
         3.960000e+04,  8.410000e+04, -6.500000e+03, -4.000000e+03,
        -1.170000e+04,  3.380000e+04,  2.592000e+05,  1.500000e+03,
        -5.500000e+03, -5.500000e+03, -3.400000e+03, -1.280000e+04,
        -1.280000e+04,  8.180000e+04, -1.310000e+04, -5.000000e+02,
        -9.000000e+03, -7.600000e+03, -3.300000e+03, -6.800000e+03,
        -6.800000e+03, -6.800000e+03, -6.800000e+03,  1.003000e+05,
         2.000000e+02, -6.600000e+03,  4.690000e+04,  7.000000e+02,
         4.600000e+04, -1.600000e+03,  4.000000e+02, -6.400000e+03,
        -3.300000e+03, -3.300000e+03, -3.300000e+03, -3.300000e+03,
        -3.300000e+03, -2.770000e+04,  2.401000e+05, -1.390000e+04,
        -6.800000e+03, -1.310000e+04,  1.476000e+05,  2.185000e+05,
        -2.810000e+04,  3.469000e+05, -2.810000e+04,  3.469000e+05,
        -1.420000e+04,  9.700000e+03,  1.670000e+04,  2.185000e+05,
        -4.300000e+03,  4.130000e+04,  8.732000e+05,  3.200000e+03,
        -3.900000e+03,  4.160000e+04,  0.000000e+00, -5.000000e+02,
         2.300000e+03,  1.597000e+05,  1.800000e+03,  9.400000e+03,
        -3.000000e+02, -4.500000e+03,  2.600000e+03, -1.150000e+04,
         2.231000e+05, -5.400000e+03, -4.200000e+03,  8.680000e+04,
        -1.340000e+04, -1.460000e+04,  1.221000e+05, -7.700000e+03,
        -1.360000e+04,  1.462000e+05,  7.200000e+03, -4.800000e+03,
        -7.300000e+03,  3.780000e+04, -5.600000e+03, -5.600000e+03,
         1.549000e+05,  2.269000e+05, -6.000000e+02, -9.970000e+04,
        -3.600000e+03, -3.700000e+03, -5.000000e+02, -5.000000e+02,
        -4.000000e+03, -5.000000e+02,  4.400000e+03, -5.000000e+02,
        -4.300000e+03, -4.300000e+03, -4.300000e+03, -4.500000e+03,
        -4.700000e+04,  5.000000e+03,  5.000000e+03,  5.000000e+03,
         2.980000e+04,  8.500000e+03,  4.000000e+03, -1.100000e+04,
        -1.260000e+04, -1.260000e+04, -2.560000e+04, -2.560000e+04,
         7.000000e+02,  1.000000e+03, -6.000000e+03,  1.400000e+03,
         1.096780e+07,  4.000000e+02,  3.800000e+03, -1.700000e+04,
         9.450000e+04, -1.100000e+03,  0.000000e+00, -7.000000e+02,
        -4.800000e+03, -4.900000e+03,  3.970000e+04,  1.000000e+03,
         0.000000e+00,  0.000000e+00,  4.600000e+03,  5.010000e+04,
         1.424000e+05,  2.870000e+04,  3.830000e+04,  0.000000e+00,
         1.400000e+03,  1.900000e+03,  4.720000e+04,  1.000000e+03,
         1.000000e+03,  1.000000e+03,  4.740000e+04,  3.000000e+02,
         2.000000e+03,  4.840000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.400000e+03,  1.000000e+03,
         5.000000e+02, -4.300000e+03,  0.000000e+00, -2.300000e+03,
         1.047000e+05, -3.300000e+03, -6.800000e+03, -6.600000e+03,
        -6.000000e+02, -4.000000e+03, -5.000000e+02, -3.700000e+03,
         5.000000e+03,  4.000000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -4.300000e+03,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-5.200000e+03, -2.800000e+03,  1.997000e+05,  1.400000e+03,
        -1.900000e+03, -1.860000e+04, -8.300000e+03, -4.700000e+03,
        -2.800000e+03, -4.400000e+03, -2.800000e+03, -5.300000e+03,
        -1.800000e+03,  5.000000e+03, -1.200000e+03, -4.800000e+03,
        -3.000000e+02, -2.130000e+04, -8.300000e+03, -4.800000e+03,
         2.891000e+05,  1.300000e+03, -2.700000e+03, -1.270000e+04,
        -1.740000e+04, -2.690000e+04, -1.510000e+04,  6.500000e+03,
         1.200000e+03,  1.200000e+03,  1.200000e+03,  1.200000e+03,
         4.300000e+03,  1.200000e+03,  1.370000e+04,  1.850000e+04,
         4.103000e+05,  5.000000e+02,  1.700000e+03,  9.970000e+04,
        -4.000000e+02,  3.700000e+03,  1.300000e+03,  1.300000e+03,
        -8.000000e+02, -2.800000e+03,  9.720000e+04,  0.000000e+00,
        -6.000000e+02,  6.000000e+02, -9.600000e+03,  6.300000e+03,
        -3.100000e+03,  2.000000e+02,  1.900000e+03, -1.020000e+04,
        -1.010000e+04, -7.900000e+03,  1.881000e+05, -4.300000e+03,
        -3.700000e+03, -5.100000e+03, -3.000000e+03, -8.900000e+03,
        -8.900000e+03, -8.900000e+03, -8.900000e+03, -6.500000e+03,
         6.000000e+02, -5.800000e+03, -4.600000e+03,  7.000000e+02,
        -1.300000e+03, -1.600000e+03,  3.800000e+03, -3.800000e+03,
         9.540000e+04,  9.540000e+04, -1.200000e+03, -1.200000e+03,
        -1.200000e+03, -2.870000e+04, -2.270000e+04, -9.600000e+03,
        -7.400000e+03, -1.580000e+04, -1.220000e+04, -1.630000e+04,
        -3.500000e+04, -2.660000e+04, -3.500000e+04, -2.670000e+04,
        -1.570000e+04,  1.010000e+04,  1.960000e+04,  1.480000e+04,
        -3.200000e+03, -2.100000e+03, -3.650000e+04,  5.400000e+03,
        -4.100000e+03, -2.900000e+03,  1.900000e+03,  5.000000e+03,
        -1.700000e+03,  1.900000e+03,  2.957000e+05,  7.800000e+03,
        -5.200000e+03, -9.700000e+03, -1.000000e+02, -1.920000e+04,
        -3.700000e+03,  4.860000e+05, -2.700000e+03, -3.000000e+02,
        -1.000000e+04, -1.710000e+04, -1.360000e+04, -7.700000e+03,
        -1.010000e+04, -1.360000e+04, -1.540000e+04, -2.500000e+03,
        -1.200000e+03, -3.300000e+03, -1.020000e+04, -1.020000e+04,
        -6.000000e+03, -1.810000e+04, -2.400000e+04, -1.615000e+05,
        -3.100000e+03, -3.100000e+03,  4.000000e+02,  4.000000e+02,
         0.000000e+00,  4.000000e+02,  3.300000e+03,  4.000000e+02,
        -3.800000e+03, -3.800000e+03, -3.800000e+03, -3.800000e+03,
        -4.100000e+03,  4.200000e+03,  4.200000e+03,  4.200000e+03,
         2.520000e+04,  7.900000e+03,  4.100000e+03,  8.000000e+02,
        -7.600000e+03, -7.600000e+03, -1.890000e+04, -1.890000e+04,
         7.000000e+02,  2.200000e+03, -2.500000e+03,  2.300000e+03,
         4.000000e+02,  1.510000e+05,  5.000000e+03, -5.300000e+03,
         9.000000e+02,  7.000000e+02,  0.000000e+00,  0.000000e+00,
         7.780000e+04, -2.500000e+03, -2.000000e+03,  9.000000e+02,
         0.000000e+00,  0.000000e+00,  4.400000e+03,  5.500000e+03,
         1.400000e+03,  1.000000e+02, -2.000000e+03,  0.000000e+00,
         2.100000e+03,  2.500000e+03,  5.000000e+02,  8.000000e+02,
         8.000000e+02, -1.800000e+03, -1.200000e+03,  8.890000e+04,
        -9.000000e+02, -3.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.700000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.300000e+03,  2.200000e+03,
         7.000000e+02, -3.800000e+03,  0.000000e+00, -5.200000e+03,
        -2.800000e+03, -1.200000e+03, -8.900000e+03, -5.800000e+03,
         1.200000e+03,  0.000000e+00,  4.000000e+02, -3.100000e+03,
         4.200000e+03,  4.100000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -3.800000e+03,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-4.740000e+04, -6.830000e+04, -5.330000e+04, -6.440000e+04,
        -5.590000e+04, -1.783000e+05, -8.340000e+04, -4.840000e+04,
        -6.830000e+04, -4.880000e+04, -6.830000e+04, -6.270000e+04,
        -2.870000e+04,  4.998000e+05, -7.250000e+04, -6.370000e+04,
        -6.700000e+03, -2.509000e+05,  3.067000e+05,  2.678000e+05,
         2.961000e+05,  2.727000e+05, -2.060000e+05, -2.073000e+05,
         4.515000e+05, -1.099000e+05,  4.287000e+05,  1.436300e+06,
         4.176000e+05,  4.176000e+05,  4.171000e+05,  4.189000e+05,
         5.842000e+05,  4.176000e+05,  3.953300e+06,  3.897200e+06,
         3.939100e+06,  4.343000e+05,  4.217000e+05,  4.307000e+05,
        -1.205000e+05, -1.216000e+05,  5.137000e+05,  5.137000e+05,
         2.723000e+05,  3.220000e+04,  2.805000e+05,  3.409000e+05,
         7.968000e+05,  7.841000e+05, -4.232000e+05,  4.298000e+05,
        -1.281000e+05, -1.370000e+05, -1.219000e+05,  6.232000e+05,
         6.232000e+05,  5.995000e+05,  6.161000e+05, -6.030000e+04,
        -7.250000e+04, -1.530000e+05, -6.170000e+04, -1.274000e+05,
        -1.274000e+05, -1.273000e+05, -1.274000e+05, -1.498000e+05,
         4.336000e+05, -1.359000e+05, -1.466000e+05,  9.800000e+03,
        -2.323000e+05, -2.467000e+05,  4.239000e+05,  8.610000e+04,
        -5.970000e+04, -5.970000e+04, -7.250000e+04, -7.250000e+04,
        -7.250000e+04, -5.437000e+05, -5.995000e+05,  5.759000e+05,
         2.593000e+05, -2.520000e+05, -2.847000e+05, -7.756000e+05,
        -5.265000e+05, -6.050000e+05, -5.265000e+05, -6.058000e+05,
         5.903000e+05,  1.894800e+06,  2.455700e+06,  1.849400e+06,
         3.541000e+05,  3.413000e+05, -8.668000e+05,  4.896000e+05,
        -7.340000e+04, -8.650000e+04,  4.284000e+05,  8.400000e+05,
         4.350000e+04,  9.200000e+03,  3.290000e+04,  6.065000e+05,
        -2.200000e+04,  3.389000e+05,  9.005000e+05, -2.226000e+05,
         2.752000e+05,  3.212000e+05,  7.896000e+05,  7.641000e+05,
         1.711000e+05, -2.717000e+05, -3.094000e+05,  2.908000e+05,
         1.727000e+05, -3.062000e+05, -2.748000e+05,  3.321000e+05,
         2.657000e+05,  2.420000e+04, -1.082000e+05, -1.082000e+05,
        -1.433000e+05, -1.327000e+05, -6.890000e+04, -1.939700e+06,
        -7.060000e+04, -7.070000e+04, -9.700000e+03, -9.700000e+03,
         3.400000e+05, -9.700000e+03, -3.555000e+05, -9.700000e+03,
        -8.150000e+04, -8.150000e+04, -8.150000e+04, -8.140000e+04,
        -8.110000e+04,  8.400000e+04,  8.390000e+04,  8.390000e+04,
         5.038000e+05,  1.515000e+05,  7.090000e+04,  1.027600e+06,
         1.773000e+05,  1.776000e+05, -6.680000e+04, -6.680000e+04,
         1.070000e+04,  8.000000e+03,  3.300000e+03,  1.110000e+04,
         3.800000e+03,  5.000000e+03,  4.998000e+05, -6.270000e+04,
         1.200000e+04, -1.620000e+04,  0.000000e+00,  0.000000e+00,
         1.390000e+04,  1.860000e+04,  7.700000e+03,  1.860000e+04,
         0.000000e+00,  0.000000e+00,  5.130000e+05,  5.035000e+05,
         1.690000e+04,  8.800000e+03,  7.500000e+03,  0.000000e+00,
         1.140000e+04,  2.487000e+05,  6.000000e+03,  7.600000e+03,
         7.600000e+03,  1.510000e+04,  4.600000e+03,  5.200000e+03,
         2.250000e+04,  1.220000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.110000e+04,  8.000000e+03,
         6.560000e+04, -8.150000e+04,  0.000000e+00, -4.740000e+04,
        -6.830000e+04, -7.250000e+04, -1.274000e+05, -1.359000e+05,
         4.188000e+05,  3.400000e+05, -9.700000e+03, -7.070000e+04,
         8.390000e+04,  7.090000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -8.150000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.627000e+05,  2.960000e+04,  4.210000e+04, -1.670000e+04,
         7.260000e+04,  6.892000e+05,  3.640000e+05,  3.145000e+05,
         2.960000e+04,  3.326000e+05,  2.950000e+04,  4.218000e+05,
         1.063000e+05, -6.270000e+04,  1.100000e+04,  3.104000e+05,
         1.280000e+04,  1.687200e+06,  2.375000e+05,  4.090000e+04,
         5.660000e+04, -2.930000e+04,  2.440000e+04,  2.385000e+05,
         2.363000e+05,  4.000000e+05,  1.049000e+05, -4.900000e+04,
        -2.360000e+04, -2.340000e+04, -2.370000e+04, -2.360000e+04,
        -5.880000e+04, -2.350000e+04, -2.630000e+04, -2.885000e+05,
        -2.675000e+05,  3.780000e+04, -2.840000e+04, -2.250000e+04,
         5.570000e+04, -6.120000e+04, -3.270000e+04, -3.270000e+04,
        -5.700000e+03,  2.110000e+04, -7.000000e+02, -1.250000e+04,
         2.700000e+04, -3.880000e+04,  9.610000e+04, -7.930000e+04,
         8.360000e+04, -5.700000e+03, -6.090000e+04,  1.909000e+05,
         1.908000e+05,  6.060000e+04,  7.020000e+04,  4.424000e+05,
         1.100000e+04,  4.980000e+04,  3.110000e+04,  2.006000e+05,
         2.006000e+05,  2.006000e+05,  2.007000e+05,  6.860000e+04,
         3.670000e+04,  1.120000e+05,  4.560000e+04, -9.400000e+03,
         1.720000e+04, -8.300000e+03, -5.150000e+04,  3.290000e+04,
         3.570000e+04,  3.570000e+04,  1.100000e+04,  1.100000e+04,
         1.100000e+04,  5.633000e+05,  2.333000e+05,  2.352000e+05,
         2.780000e+05,  3.202000e+05,  1.223000e+05,  1.768000e+05,
         7.403000e+05,  2.785000e+05,  7.403000e+05,  2.793000e+05,
         4.105000e+05,  6.920000e+04, -9.470000e+04, -1.940000e+05,
         7.650000e+04,  1.060000e+04,  3.856000e+05, -9.610000e+04,
         6.670000e+04,  1.200000e+03, -3.330000e+04, -7.510000e+04,
         1.499000e+05, -4.760000e+04, -3.110000e+04, -1.290000e+04,
         2.163000e+05,  3.607000e+05,  1.967000e+05,  5.248000e+05,
         3.130000e+04,  5.920000e+04,  1.138000e+05, -1.790000e+04,
         9.260000e+04,  3.390000e+05,  1.406000e+05,  1.765000e+05,
         9.350000e+04,  1.420000e+05,  3.253000e+05,  1.420000e+04,
        -1.400000e+03,  2.560000e+04,  2.651000e+05,  2.651000e+05,
         6.370000e+04,  1.666000e+05,  4.960000e+05,  4.281700e+06,
         2.920000e+04,  2.920000e+04, -3.320000e+04, -3.330000e+04,
        -1.240000e+04, -3.330000e+04, -8.240000e+04, -3.330000e+04,
         3.910000e+04,  3.910000e+04,  3.910000e+04,  3.930000e+04,
         8.740000e+04, -4.520000e+04, -4.510000e+04, -4.510000e+04,
        -2.709000e+05, -1.103000e+05, -7.180000e+04, -6.480000e+04,
         6.560000e+04,  6.550000e+04,  1.826000e+05,  1.825000e+05,
        -9.900000e+03, -2.370000e+04,  0.000000e+00,  3.650000e+04,
        -1.700000e+04, -5.300000e+03, -6.270000e+04,  7.332800e+06,
        -8.600000e+03, -6.240000e+04,  0.000000e+00,  0.000000e+00,
         6.000000e+02,  5.620000e+04, -4.500000e+03, -9.400000e+03,
         0.000000e+00,  0.000000e+00, -2.200000e+03, -6.730000e+04,
        -1.330000e+04,  1.720000e+04, -4.300000e+03,  0.000000e+00,
         3.860000e+04, -3.180000e+04, -4.300000e+03, -2.750000e+04,
        -2.750000e+04,  5.620000e+04, -4.900000e+03, -1.500000e+03,
         2.810000e+04, -3.250000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  3.650000e+04, -2.370000e+04,
        -8.200000e+03,  3.910000e+04, -1.000000e+02,  1.627000e+05,
         2.960000e+04,  1.100000e+04,  2.006000e+05,  1.120000e+05,
        -2.360000e+04, -1.240000e+04, -3.330000e+04,  2.920000e+04,
        -4.510000e+04, -7.180000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  3.910000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-4.300000e+03,  3.090000e+05, -8.100000e+03, -9.900000e+03,
        -7.100000e+03, -1.400000e+04, -5.400000e+03, -4.600000e+03,
         3.090000e+05, -4.700000e+03,  3.088000e+05, -8.600000e+03,
         5.860000e+04,  1.200000e+04, -1.170000e+04, -8.800000e+03,
         1.350000e+04, -3.450000e+04, -1.560000e+04,  3.831000e+05,
        -1.960000e+04, -2.410000e+04,  3.459000e+05, -3.190000e+04,
        -6.530000e+04, -8.600000e+04,  2.363000e+05, -1.383000e+05,
        -1.700000e+03, -1.700000e+03, -1.400000e+03, -1.700000e+03,
         8.100000e+03, -1.700000e+03,  2.320000e+04,  5.549000e+05,
         1.790000e+04,  2.800000e+03,  1.358000e+05,  1.500000e+03,
        -1.710000e+04, -1.820000e+04, -1.950000e+04, -1.960000e+04,
         1.747000e+05,  3.628000e+05, -2.260000e+04, -1.360000e+04,
        -4.070000e+04,  9.230000e+04,  1.063500e+06,  1.200000e+03,
        -1.880000e+04, -2.170000e+04, -1.830000e+04, -3.610000e+04,
        -3.610000e+04,  2.404000e+05, -3.870000e+04,  1.300000e+03,
        -2.890000e+04, -2.530000e+04, -1.030000e+04, -1.810000e+04,
        -1.810000e+04, -1.810000e+04, -1.810000e+04,  2.953000e+05,
         2.600000e+03, -2.050000e+04,  1.361000e+05,  2.200000e+03,
         1.986000e+05, -5.900000e+03,  0.000000e+00, -2.000000e+04,
        -9.700000e+03, -9.700000e+03, -1.170000e+04, -1.180000e+04,
        -1.170000e+04, -8.190000e+04,  7.016000e+05, -4.050000e+04,
        -1.830000e+04, -3.630000e+04,  4.340000e+05,  7.682000e+05,
        -7.710000e+04,  1.020000e+06, -7.710000e+04,  1.020000e+06,
        -3.720000e+04,  3.790000e+04,  5.860000e+04,  6.487000e+05,
        -1.080000e+04,  1.222000e+05,  2.911600e+06,  9.500000e+03,
        -1.160000e+04,  1.213000e+05,  6.000000e+02, -1.600000e+03,
         1.140000e+04,  4.717000e+05,  7.400000e+03,  3.240000e+04,
         2.900000e+03, -6.300000e+03,  1.460000e+04, -2.710000e+04,
         6.586000e+05, -1.290000e+04, -7.900000e+03,  2.580000e+05,
        -4.220000e+04, -4.080000e+04,  3.583000e+05, -1.980000e+04,
        -4.240000e+04,  4.293000e+05,  2.110000e+04, -1.480000e+04,
        -2.560000e+04,  1.686000e+05, -1.270000e+04, -1.270000e+04,
         4.567000e+05,  6.667000e+05,  1.900000e+03, -2.412000e+05,
        -1.130000e+04, -1.130000e+04, -2.500000e+03, -2.500000e+03,
        -1.340000e+04, -2.500000e+03,  1.030000e+04, -2.500000e+03,
        -1.370000e+04, -1.370000e+04, -1.370000e+04, -1.370000e+04,
        -1.330000e+04,  1.530000e+04,  1.530000e+04,  1.530000e+04,
         9.170000e+04,  2.500000e+04,  1.120000e+04, -3.850000e+04,
        -4.080000e+04, -4.080000e+04, -8.180000e+04, -8.180000e+04,
         2.300000e+03,  1.800000e+03, -1.750000e+04,  3.200000e+03,
         9.450000e+04,  9.000000e+02,  1.200000e+04, -8.600000e+03,
         4.067000e+05, -4.700000e+03,  0.000000e+00,  2.800000e+03,
        -1.340000e+04, -1.340000e+04,  1.177000e+05,  3.100000e+03,
         0.000000e+00,  0.000000e+00,  1.630000e+04,  1.494000e+05,
         5.486000e+05,  1.266000e+05,  1.137000e+05,  0.000000e+00,
         3.300000e+03,  6.200000e+03,  2.030000e+05,  1.700000e+03,
         1.700000e+03,  4.000000e+03,  1.401000e+05,  1.000000e+03,
         5.700000e+03,  1.419000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  3.200000e+03,  1.800000e+03,
         1.600000e+03, -1.370000e+04,  0.000000e+00, -4.300000e+03,
         3.090000e+05, -1.180000e+04, -1.810000e+04, -2.050000e+04,
        -1.700000e+03, -1.340000e+04, -2.500000e+03, -1.130000e+04,
         1.530000e+04,  1.120000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.370000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-1.356000e+05,  1.750000e+04,  2.400000e+03,  2.120000e+04,
        -5.690000e+04, -6.008000e+05, -3.297000e+05, -1.315000e+05,
         1.750000e+04, -1.297000e+05,  1.750000e+04, -6.240000e+04,
         4.500000e+03, -1.620000e+04,  2.220000e+04, -5.870000e+04,
         1.500000e+03, -2.495000e+05, -1.751000e+05,  4.730000e+04,
         3.270000e+04,  5.040000e+04,  6.190000e+04,  1.265020e+07,
         1.950000e+04, -1.860000e+04,  1.669000e+05,  1.513000e+05,
         7.000000e+03,  7.000000e+03,  7.200000e+03,  7.500000e+03,
        -8.500000e+03,  7.100000e+03, -2.781000e+05,  2.050000e+04,
        -1.000000e+03, -7.120000e+04,  4.700000e+03, -1.900000e+03,
        -3.550000e+04,  4.210000e+04,  4.360000e+04,  4.360000e+04,
         4.920000e+04,  5.490000e+04,  4.450000e+04,  2.940000e+04,
         1.710000e+04,  9.220000e+04,  1.201000e+05,  4.800000e+03,
        -3.450000e+04,  4.340000e+04,  4.250000e+04, -6.810000e+04,
        -6.810000e+04,  7.940000e+04,  7.040000e+04, -4.480000e+05,
         2.130000e+04,  4.530000e+04,  1.640000e+04, -1.066000e+05,
        -1.066000e+05, -1.067000e+05, -1.067000e+05,  4.070000e+04,
        -6.840000e+04, -3.370000e+04,  4.180000e+04,  5.000000e+02,
         6.600000e+03,  4.802200e+06,  6.000000e+03,  3.820000e+04,
         1.150000e+04,  1.150000e+04,  2.220000e+04,  2.220000e+04,
         2.220000e+04, -2.026000e+05,  1.677000e+05, -1.232000e+05,
        -2.458000e+05, -1.339000e+05,  8.650000e+04,  9.940000e+04,
        -3.488000e+05,  1.668000e+05, -3.488000e+05,  1.655000e+05,
        -2.724000e+05, -3.264000e+05, -2.886000e+05, -3.170000e+04,
        -4.590000e+04,  2.930000e+04,  2.313000e+05,  2.570000e+04,
        -1.120000e+04,  6.290000e+04,  8.000000e+03,  1.320000e+04,
        -1.880000e+05,  3.360000e+04,  1.980000e+04, -1.510000e+05,
        -2.225000e+05, -3.364000e+05, -2.972000e+05, -3.756000e+05,
         3.920000e+04,  9.900000e+03, -1.149000e+05,  3.540000e+04,
         7.550000e+04, -1.351000e+05,  9.260000e+04, -9.840000e+04,
         7.660000e+04,  8.420000e+04, -1.319000e+05,  2.910000e+04,
         5.150000e+04,  5.710000e+04, -1.929000e+05, -1.929000e+05,
         3.790000e+04,  1.473000e+05, -2.284000e+05, -2.974000e+06,
         2.430000e+04,  2.430000e+04,  4.170000e+04,  4.170000e+04,
         2.940000e+04,  4.170000e+04,  5.320000e+04,  4.170000e+04,
         2.320000e+04,  2.310000e+04,  2.310000e+04,  2.320000e+04,
         2.130000e+04, -2.650000e+04, -2.650000e+04, -2.650000e+04,
        -1.588000e+05, -1.110000e+04,  1.530000e+04,  8.780000e+04,
         7.580000e+04,  7.580000e+04,  1.453000e+05,  1.453000e+05,
         1.200000e+03, -2.800000e+03, -8.000000e+02, -5.650000e+04,
        -1.100000e+03,  7.000000e+02, -1.620000e+04, -6.240000e+04,
        -4.700000e+03,  1.647030e+07,  0.000000e+00,  0.000000e+00,
        -6.200000e+03, -7.470000e+04, -2.800000e+03, -4.900000e+03,
         0.000000e+00,  0.000000e+00, -9.460000e+04, -1.810000e+04,
        -6.900000e+03, -2.700000e+04, -2.700000e+03,  9.508600e+06,
        -5.850000e+04, -8.500000e+03, -2.400000e+03, -5.000000e+02,
        -5.000000e+02, -7.350000e+04, -1.500000e+03, -2.200000e+03,
        -7.380000e+04, -1.900000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  4.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -5.650000e+04, -2.800000e+03,
        -2.100000e+03,  2.310000e+04,  0.000000e+00, -1.356000e+05,
         1.750000e+04,  2.220000e+04, -1.066000e+05, -3.370000e+04,
         7.400000e+03,  2.940000e+04,  4.170000e+04,  2.430000e+04,
        -2.650000e+04,  1.530000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  2.320000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.056500e+06,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 0.000000e+00, -2.200000e+03,  0.000000e+00, -6.000000e+02,
        -3.000000e+02,  1.000000e+02,  0.000000e+00,  0.000000e+00,
        -2.200000e+03,  0.000000e+00, -2.200000e+03,  0.000000e+00,
        -4.000000e+02,  0.000000e+00, -3.000000e+02,  0.000000e+00,
        -1.000000e+02,  1.000000e+02,  1.000000e+02, -1.800000e+03,
         1.000000e+02, -1.000000e+02,  1.620000e+04,  1.000000e+02,
         3.000000e+02,  3.000000e+02, -1.700000e+03, -1.100000e+03,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.000000e+02, -2.400000e+03,
         1.000000e+02,  0.000000e+00, -6.000000e+02,  0.000000e+00,
        -9.000000e+02, -1.400000e+03, -1.000000e+02,  0.000000e+00,
         3.100000e+03,  9.500000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -6.000000e+02,  1.470000e+04,  1.000000e+02,
        -5.000000e+02, -9.000000e+02, -1.400000e+03,  2.000000e+02,
         2.000000e+02, -1.300000e+03,  2.000000e+02,  0.000000e+00,
        -1.000000e+02, -3.000000e+02,  0.000000e+00,  1.000000e+02,
         1.000000e+02,  1.000000e+02,  1.000000e+02, -2.200000e+03,
         0.000000e+00, -2.000000e+02, -1.400000e+03,  0.000000e+00,
         2.000000e+03,  0.000000e+00,  0.000000e+00, -1.000000e+02,
         0.000000e+00,  0.000000e+00, -3.000000e+02, -3.000000e+02,
        -3.000000e+02, -3.000000e+02, -6.000000e+03, -3.000000e+02,
        -4.000000e+02,  1.000000e+02, -3.300000e+03,  2.600000e+03,
         3.000000e+02, -7.700000e+03,  3.000000e+02, -7.700000e+03,
         3.000000e+02,  0.000000e+00,  0.000000e+00, -4.100000e+03,
         1.000000e+02, -6.000000e+02,  3.670000e+04,  0.000000e+00,
         1.000000e+02, -6.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.200000e+03,  0.000000e+00, -1.000000e+02,
         0.000000e+00,  1.000000e+02,  0.000000e+00,  1.000000e+02,
        -3.000000e+03,  1.000000e+02,  1.000000e+02, -1.200000e+03,
         1.000000e+02,  1.000000e+02, -1.700000e+03,  1.000000e+02,
         1.000000e+02, -3.300000e+03, -1.700000e+03,  1.000000e+02,
         0.000000e+00,  3.000000e+03,  0.000000e+00,  0.000000e+00,
        -3.300000e+03, -4.200000e+03, -1.100000e+03,  9.000000e+02,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -2.000000e+02, -1.000000e+02,  0.000000e+00, -5.000000e+02,
         0.000000e+00,  0.000000e+00,  2.000000e+02,  2.000000e+02,
         0.000000e+00, -3.000000e+02,  1.000000e+02,  0.000000e+00,
        -7.000000e+02,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.800000e+03,  0.000000e+00,  0.000000e+00,  1.165000e+05,
         1.000000e+02,  1.000000e+02, -5.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -6.000000e+02,
         2.300000e+03,  1.100000e+03, -5.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.400000e+03, -3.000000e+02,
        -3.000000e+02,  0.000000e+00, -5.000000e+02,  0.000000e+00,
        -3.000000e+02, -8.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -3.000000e+02,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -2.200000e+03, -3.000000e+02,  1.000000e+02, -2.000000e+02,
         0.000000e+00, -1.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 6.200000e+03, -2.620000e+04,  3.595000e+05, -1.530000e+04,
        -4.600000e+03,  2.500000e+04,  1.260000e+04,  5.000000e+03,
        -2.620000e+04,  4.300000e+03, -2.620000e+04,  6.000000e+02,
        -5.800000e+03,  1.390000e+04, -1.230000e+04, -9.000000e+02,
        -1.500000e+03,  2.400000e+03,  1.590000e+04, -5.000000e+04,
         2.162000e+06, -2.430000e+04, -5.160000e+04, -6.400000e+03,
        -3.150000e+04, -4.700000e+04, -6.990000e+04, -1.343000e+05,
         3.300000e+03,  3.300000e+03,  2.500000e+03,  3.600000e+03,
         1.220000e+04,  3.300000e+03,  8.860000e+04,  1.800000e+03,
         2.950000e+06,  1.260000e+04, -7.500000e+03,  7.280000e+05,
        -2.010000e+04, -3.540000e+04, -1.600000e+04, -1.600000e+04,
        -2.940000e+04, -4.290000e+04,  7.045000e+05, -9.900000e+03,
        -2.890000e+04, -4.980000e+04, -1.164000e+05, -1.000000e+03,
        -1.680000e+04, -2.760000e+04, -3.680000e+04, -4.400000e+03,
        -4.400000e+03, -4.660000e+04,  1.426300e+06,  1.350000e+04,
         3.957000e+05, -2.150000e+04, -7.600000e+03, -1.000000e+02,
        -1.000000e+02, -1.000000e+02, -1.000000e+02, -3.690000e+04,
         1.480000e+04, -1.330000e+04, -3.040000e+04,  2.600000e+03,
        -1.040000e+04, -8.600000e+03,  1.200000e+03, -1.640000e+04,
         1.577000e+05,  1.577000e+05, -1.230000e+04, -1.230000e+04,
        -1.230000e+04, -3.640000e+04, -1.267000e+05, -6.800000e+03,
        -1.000000e+02, -4.400000e+03, -5.920000e+04, -9.220000e+04,
        -1.010000e+04, -1.388000e+05, -1.010000e+04, -1.396000e+05,
         1.640000e+04,  7.310000e+04,  8.760000e+04, -2.800000e+03,
         3.400000e+03, -1.740000e+04, -2.670000e+05,  8.100000e+03,
        -5.300000e+03, -2.710000e+04,  6.500000e+03,  4.000000e+03,
         2.570000e+04, -3.020000e+04,  2.171800e+06,  3.910000e+04,
         1.140000e+04,  2.930000e+04,  4.420000e+04,  1.440000e+04,
        -7.540000e+04,  3.606200e+06,  1.750000e+04, -2.440000e+04,
        -2.830000e+04, -9.600000e+03, -7.010000e+04,  3.900000e+03,
        -2.930000e+04, -6.590000e+04, -1.880000e+04, -7.000000e+03,
        -2.250000e+04, -3.580000e+04,  7.200000e+03,  7.200000e+03,
        -4.460000e+04, -1.075000e+05, -2.700000e+03,  7.820000e+04,
        -7.300000e+03, -7.300000e+03, -5.700000e+03, -5.700000e+03,
        -1.010000e+04, -5.700000e+03, -4.000000e+03, -5.700000e+03,
        -1.060000e+04, -1.060000e+04, -1.060000e+04, -1.060000e+04,
        -9.700000e+03,  8.100000e+03,  8.100000e+03,  8.100000e+03,
         4.850000e+04,  1.070000e+04,  2.400000e+03, -3.490000e+04,
        -3.130000e+04, -3.120000e+04, -6.310000e+04, -6.310000e+04,
         3.300000e+03, -1.800000e+03,  4.133000e+05, -3.000000e+02,
        -4.800000e+03,  7.780000e+04,  1.390000e+04,  6.000000e+02,
        -1.340000e+04, -6.200000e+03,  0.000000e+00,  1.000000e+02,
         4.128300e+06,  4.196000e+05,  4.065000e+05,  2.300000e+03,
         0.000000e+00,  0.000000e+00,  2.230000e+04,  3.000000e+03,
        -2.300000e+04, -2.200000e+03,  3.928000e+05,  0.000000e+00,
         3.000000e+02,  7.100000e+03, -6.700000e+03, -4.600000e+03,
        -4.600000e+03,  4.700000e+03, -1.100000e+04,  8.220000e+04,
        -3.000000e+02, -1.560000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.600000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.000000e+02, -1.800000e+03,
         1.800000e+03, -1.060000e+04,  0.000000e+00,  6.200000e+03,
        -2.620000e+04, -1.230000e+04, -1.000000e+02, -1.330000e+04,
         3.600000e+03, -1.010000e+04, -5.700000e+03, -7.300000e+03,
         8.100000e+03,  2.400000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.060000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.259000e+05, -3.770000e+04, -1.790000e+04, -3.870000e+04,
         4.340000e+04,  5.633000e+05,  3.116000e+05,  1.232000e+05,
        -3.770000e+04,  1.220000e+05, -3.760000e+04,  5.620000e+04,
        -9.400000e+03,  1.860000e+04, -3.190000e+04,  5.360000e+04,
        -2.500000e+03,  2.246000e+05,  1.714000e+05, -8.320000e+04,
        -9.740000e+04, -7.960000e+04, -1.106000e+05,  7.900000e+04,
        -1.270000e+04,  2.070000e+04, -1.767000e+05, -3.529000e+05,
        -3.700000e+03, -3.800000e+03, -3.800000e+03, -3.700000e+03,
         1.210000e+04, -3.800000e+03,  2.934000e+05, -4.680000e+04,
        -6.500000e+04,  6.980000e+04, -1.520000e+04, -1.980000e+04,
         4.900000e+03, -8.490000e+04, -6.180000e+04, -6.180000e+04,
        -7.680000e+04, -9.210000e+04, -8.550000e+04, -3.750000e+04,
        -5.770000e+04, -1.427000e+05, -2.176000e+05, -2.320000e+04,
         1.100000e+04, -7.060000e+04, -8.590000e+04,  7.140000e+04,
         7.130000e+04, -9.610000e+04, -1.078000e+05,  4.319000e+05,
         4.965000e+05, -5.690000e+04, -1.950000e+04,  1.025000e+05,
         1.025000e+05,  1.025000e+05,  1.025000e+05, -5.990000e+04,
         6.890000e+04,  1.690000e+04, -6.450000e+04,  7.000000e+02,
        -1.480000e+04, -4.500000e+04, -1.410000e+04, -4.280000e+04,
        -1.810000e+04, -1.810000e+04, -3.190000e+04, -3.190000e+04,
        -3.190000e+04,  1.650000e+05, -2.411000e+05,  9.810000e+04,
         2.010000e+05,  1.324000e+05, -1.107000e+05, -1.494000e+05,
         3.359000e+05, -2.325000e+05,  3.359000e+05, -2.321000e+05,
         2.676000e+05,  3.211000e+05,  2.877000e+05, -5.900000e+03,
         4.730000e+04, -3.770000e+04, -4.072000e+05, -2.140000e+04,
         1.100000e+04, -7.390000e+04, -3.000000e+03, -1.900000e+04,
         1.799000e+05, -6.460000e+04, -8.890000e+04,  1.474000e+05,
         2.024000e+05,  3.196000e+05,  2.860000e+05,  3.532000e+05,
        -1.053000e+05, -1.284000e+05,  1.169000e+05, -5.310000e+04,
        -6.980000e+04,  1.309000e+05, -1.243000e+05,  9.830000e+04,
        -7.060000e+04, -1.122000e+05,  1.694000e+05, -2.510000e+04,
        -6.990000e+04, -8.490000e+04,  1.784000e+05,  1.784000e+05,
        -6.770000e+04, -1.992000e+05,  2.257000e+05,  2.787700e+06,
        -2.150000e+04, -2.150000e+04, -3.990000e+04, -3.990000e+04,
        -3.800000e+04, -3.990000e+04, -5.380000e+04, -3.990000e+04,
        -2.230000e+04, -2.230000e+04, -2.230000e+04, -2.230000e+04,
        -2.090000e+04,  2.280000e+04,  2.280000e+04,  2.280000e+04,
         1.369000e+05,  5.900000e+03, -1.700000e+04, -1.216000e+05,
        -8.240000e+04, -8.230000e+04, -1.492000e+05, -1.492000e+05,
         7.000000e+02, -5.800000e+03,  5.347000e+05,  5.860000e+04,
        -4.900000e+03, -2.500000e+03,  1.860000e+04,  5.620000e+04,
        -1.340000e+04, -7.470000e+04,  0.000000e+00,  1.000000e+02,
         4.196000e+05,  7.041000e+05,  5.224000e+05,  5.900000e+03,
         0.000000e+00,  0.000000e+00,  9.150000e+04,  6.900000e+03,
        -2.360000e+04,  1.880000e+04,  5.048000e+05,  0.000000e+00,
         5.980000e+04,  9.600000e+03, -6.700000e+03, -7.700000e+03,
        -7.700000e+03,  8.430000e+04, -9.600000e+03, -8.000000e+02,
         7.580000e+04, -1.730000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  5.860000e+04, -5.800000e+03,
         2.400000e+03, -2.230000e+04,  0.000000e+00,  1.259000e+05,
        -3.770000e+04, -3.190000e+04,  1.025000e+05,  1.690000e+04,
        -3.700000e+03, -3.800000e+04, -3.990000e+04, -2.150000e+04,
         2.280000e+04, -1.700000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.230000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-1.700000e+03,  1.278000e+05, -1.650000e+04, -2.160000e+04,
        -1.160000e+04, -4.300000e+03, -1.000000e+03, -1.800000e+03,
         1.278000e+05, -1.800000e+03,  1.277000e+05, -4.500000e+03,
         2.380000e+04,  7.700000e+03, -1.470000e+04, -4.600000e+03,
         5.500000e+03, -1.790000e+04, -5.600000e+03,  2.582000e+05,
        -7.930000e+04, -3.770000e+04,  8.580000e+04, -1.620000e+04,
        -3.450000e+04, -4.680000e+04,  1.060000e+05, -2.300000e+05,
         0.000000e+00,  1.000000e+02, -6.000000e+02,  1.000000e+02,
         5.800000e+03,  1.000000e+02,  2.490000e+04,  3.765000e+05,
        -7.330000e+04,  3.200000e+03,  9.120000e+04, -2.140000e+04,
        -3.320000e+04, -5.020000e+04, -2.790000e+04, -2.790000e+04,
         2.940000e+04,  8.960000e+04, -5.160000e+04, -1.590000e+04,
        -5.530000e+04,  3.270000e+04,  3.190000e+05, -1.420000e+04,
        -2.620000e+04, -3.630000e+04, -5.020000e+04, -1.640000e+04,
        -1.640000e+04,  1.488000e+05, -6.550000e+04,  3.700000e+03,
         4.981000e+05, -2.250000e+04, -5.900000e+03, -9.000000e+03,
        -9.000000e+03, -9.000000e+03, -9.000000e+03,  1.200000e+05,
         3.200000e+03, -1.930000e+04,  4.530000e+04,  1.600000e+03,
         5.750000e+04, -3.700000e+03, -7.400000e+03, -1.720000e+04,
        -1.090000e+04, -1.090000e+04, -1.470000e+04, -1.460000e+04,
        -1.470000e+04, -5.980000e+04,  2.627000e+05, -3.610000e+04,
        -2.540000e+04, -1.780000e+04,  1.758000e+05,  3.313000e+05,
        -3.900000e+04,  4.123000e+05, -3.900000e+04,  4.121000e+05,
        -1.390000e+04,  2.780000e+04,  3.990000e+04,  3.014000e+05,
        -4.400000e+03,  8.360000e+04,  1.117900e+06,  5.800000e+03,
        -6.500000e+03,  8.140000e+04,  1.800000e+03, -8.200000e+03,
         8.100000e+03,  2.112000e+05, -6.560000e+04,  2.040000e+04,
         2.500000e+03,  2.000000e+02,  1.240000e+04, -1.190000e+04,
         4.402000e+05, -1.225000e+05, -9.000000e+02,  1.751000e+05,
        -2.320000e+04, -2.100000e+04,  2.430000e+05, -8.800000e+03,
        -2.400000e+04,  1.721000e+05, -5.930000e+04, -7.500000e+03,
        -3.090000e+04,  2.630000e+04, -6.000000e+03, -6.000000e+03,
         1.878000e+05,  3.509000e+05, -8.910000e+04, -1.135000e+05,
        -6.000000e+03, -6.000000e+03, -1.800000e+03, -1.800000e+03,
        -1.640000e+04, -1.800000e+03,  4.100000e+03, -1.800000e+03,
        -7.800000e+03, -7.800000e+03, -7.800000e+03, -7.800000e+03,
        -7.600000e+03,  8.200000e+03,  8.200000e+03,  8.200000e+03,
         4.920000e+04,  1.320000e+04,  5.700000e+03, -5.610000e+04,
        -3.180000e+04, -3.170000e+04, -5.510000e+04, -5.510000e+04,
         1.800000e+03, -6.500000e+03,  5.194000e+05,  2.300000e+03,
         3.970000e+04, -2.000000e+03,  7.700000e+03, -4.500000e+03,
         1.177000e+05, -2.800000e+03,  0.000000e+00, -5.000000e+02,
         4.065000e+05,  5.224000e+05,  6.140000e+05,  1.800000e+03,
         0.000000e+00,  0.000000e+00,  1.060000e+04,  9.890000e+04,
         2.001000e+05,  4.370000e+04,  5.933000e+05,  0.000000e+00,
         2.300000e+03,  4.000000e+03,  5.870000e+04, -7.000000e+03,
        -7.000000e+03,  3.000000e+03,  8.020000e+04, -2.100000e+03,
        -3.900000e+03,  7.320000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.300000e+03, -6.500000e+03,
         1.000000e+03, -7.800000e+03,  0.000000e+00, -1.700000e+03,
         1.278000e+05, -1.460000e+04, -9.000000e+03, -1.930000e+04,
         1.000000e+02, -1.640000e+04, -1.800000e+03, -6.000000e+03,
         8.200000e+03,  5.700000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -7.800000e+03,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-4.600000e+03, -1.130000e+04, -9.600000e+03, -1.500000e+03,
        -3.100000e+03, -1.460000e+04, -5.300000e+03, -4.800000e+03,
        -1.130000e+04, -4.900000e+03, -1.130000e+04, -9.400000e+03,
        -5.000000e+03,  1.860000e+04, -8.000000e+03, -9.600000e+03,
        -1.200000e+03, -3.750000e+04, -1.020000e+04, -2.100000e+04,
        -1.790000e+04, -5.500000e+03, -2.100000e+04, -3.360000e+04,
        -5.910000e+04, -8.720000e+04, -6.620000e+04, -2.510000e+04,
         3.700000e+03,  3.700000e+03,  3.700000e+03,  3.800000e+03,
         1.580000e+04,  3.700000e+03,  7.680000e+04,  6.250000e+04,
         6.660000e+04,  8.900000e+03,  5.400000e+03,  6.300000e+03,
        -4.600000e+03,  3.400000e+03, -3.000000e+03, -3.000000e+03,
        -1.080000e+04, -1.850000e+04, -9.600000e+03, -4.300000e+03,
        -1.020000e+04, -1.360000e+04, -5.230000e+04,  1.730000e+04,
        -1.110000e+04, -9.500000e+03,  3.300000e+03, -2.660000e+04,
        -2.660000e+04, -3.380000e+04, -3.170000e+04,  2.700000e+03,
        -7.900000e+03, -2.260000e+04,  2.318000e+06, -1.910000e+04,
        -1.910000e+04, -1.910000e+04, -1.910000e+04, -2.620000e+04,
         8.900000e+03, -1.770000e+04, -2.110000e+04,  2.400000e+03,
        -5.200000e+03, -9.400000e+03,  1.050000e+04, -1.700000e+04,
        -1.080000e+04, -1.080000e+04, -8.000000e+03, -8.000000e+03,
        -8.000000e+03, -7.880000e+04, -9.630000e+04, -2.260000e+04,
        -5.600000e+03, -3.860000e+04, -4.900000e+04, -6.490000e+04,
        -8.170000e+04, -1.063000e+05, -8.170000e+04, -1.064000e+05,
        -2.570000e+04,  6.490000e+04,  9.290000e+04,  5.070000e+04,
        -5.800000e+03, -9.300000e+03, -1.478000e+05,  1.570000e+04,
        -1.240000e+04, -1.600000e+04,  6.200000e+03,  1.430000e+04,
         1.290000e+04,  2.400000e+03,  5.200000e+03,  4.100000e+04,
         2.500000e+03, -2.000000e+02,  2.790000e+04, -2.830000e+04,
        -1.770000e+04, -1.300000e+04,  3.300000e+03, -3.700000e+03,
        -4.030000e+04, -4.340000e+04, -5.360000e+04, -1.530000e+04,
        -4.080000e+04, -5.410000e+04, -4.200000e+04, -1.060000e+04,
        -1.230000e+04, -2.000000e+04, -1.370000e+04, -1.370000e+04,
        -2.440000e+04, -7.540000e+04, -5.790000e+04, -2.565000e+05,
        -1.230000e+04, -1.230000e+04, -2.900000e+03, -2.900000e+03,
        -4.300000e+03, -2.800000e+03,  5.400000e+03, -2.900000e+03,
        -1.480000e+04, -1.490000e+04, -1.490000e+04, -1.480000e+04,
        -1.470000e+04,  1.600000e+04,  1.600000e+04,  1.600000e+04,
         9.610000e+04,  2.640000e+04,  1.180000e+04, -6.500000e+03,
        -3.400000e+04, -3.390000e+04, -7.840000e+04, -7.840000e+04,
         2.500000e+03,  6.200000e+03,  2.000000e+02,  3.900000e+03,
         1.000000e+03,  9.000000e+02,  1.860000e+04, -9.400000e+03,
         3.100000e+03, -4.900000e+03,  0.000000e+00,  0.000000e+00,
         2.300000e+03,  5.900000e+03,  1.800000e+03,  2.356200e+06,
         0.000000e+00,  0.000000e+00,  2.350000e+04,  2.020000e+04,
         4.800000e+03,  2.600000e+03,  1.700000e+03,  0.000000e+00,
         4.000000e+03,  9.500000e+03,  1.600000e+03,  6.400000e+03,
         6.400000e+03,  5.600000e+03,  1.600000e+03,  9.000000e+02,
         1.190000e+04,  7.900000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  3.900000e+03,  6.200000e+03,
         2.400000e+03, -1.490000e+04,  0.000000e+00, -4.600000e+03,
        -1.130000e+04, -8.000000e+03, -1.910000e+04, -1.770000e+04,
         3.800000e+03, -4.300000e+03, -2.900000e+03, -1.230000e+04,
         1.600000e+04,  1.180000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.480000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  4.226000e+06,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.226000e+06,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -5.300000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.060000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 8.430000e+04, -8.600000e+04, -5.690000e+04, -8.530000e+04,
        -7.000000e+02,  4.069000e+05,  2.383000e+05,  7.990000e+04,
        -8.600000e+04,  7.790000e+04, -8.600000e+04, -2.200000e+03,
        -3.330000e+04,  5.130000e+05, -9.430000e+04, -6.600000e+03,
        -8.200000e+03, -8.800000e+03,  4.870000e+05,  2.216000e+05,
         2.724000e+05,  2.267000e+05, -2.666000e+05, -1.255000e+05,
         4.356000e+05, -9.180000e+04,  2.642000e+05,  1.304200e+06,
         4.084000e+05,  4.086000e+05,  4.094000e+05,  4.055000e+05,
         5.878000e+05,  4.086000e+05,  4.215400e+06,  3.863500e+06,
         3.929300e+06,  5.051000e+05,  4.157000e+05,  4.335000e+05,
        -8.610000e+04, -1.630000e+05,  4.743000e+05,  4.743000e+05,
         2.263000e+05, -2.080000e+04,  2.419000e+05,  3.132000e+05,
         7.879000e+05,  6.990000e+05, -5.410000e+05,  4.255000e+05,
        -9.520000e+04, -1.797000e+05, -1.640000e+05,  6.953000e+05,
         6.952000e+05,  5.206000e+05,  5.522000e+05,  3.789000e+05,
        -9.090000e+04, -1.975000e+05, -7.800000e+04, -2.060000e+04,
        -2.060000e+04, -2.060000e+04, -2.060000e+04, -1.904000e+05,
         5.096000e+05, -1.043000e+05, -1.894000e+05,  1.040000e+04,
        -2.367000e+05, -2.993000e+05,  4.174000e+05,  5.230000e+04,
        -7.160000e+04, -7.160000e+04, -9.430000e+04, -9.430000e+04,
        -9.430000e+04, -3.443000e+05, -7.686000e+05,  7.140000e+05,
         5.001000e+05, -1.142000e+05, -3.664000e+05, -8.678000e+05,
        -1.762000e+05, -7.705000e+05, -1.762000e+05, -7.706000e+05,
         8.774000e+05,  2.249400e+06,  2.779300e+06,  1.907700e+06,
         3.985000e+05,  3.095000e+05, -1.096800e+06,  4.613000e+05,
        -6.080000e+04, -1.488000e+05,  4.200000e+05,  8.261000e+05,
         2.307000e+05, -2.470000e+04,  1.610000e+04,  7.530000e+05,
         1.913000e+05,  6.794000e+05,  1.210500e+06,  1.483000e+05,
         2.345000e+05,  3.217000e+05,  9.013000e+05,  7.233000e+05,
         9.390000e+04, -1.351000e+05, -4.033000e+05,  3.881000e+05,
         9.640000e+04, -3.899000e+05, -1.484000e+05,  3.008000e+05,
         2.178000e+05, -3.020000e+04,  7.960000e+04,  7.960000e+04,
        -1.813000e+05, -2.783000e+05,  1.666000e+05,  9.757000e+05,
        -9.250000e+04, -9.260000e+04, -5.120000e+04, -5.120000e+04,
         3.131000e+05, -5.120000e+04, -4.067000e+05, -5.120000e+04,
        -1.043000e+05, -1.043000e+05, -1.043000e+05, -1.043000e+05,
        -1.019000e+05,  1.058000e+05,  1.057000e+05,  1.057000e+05,
         6.346000e+05,  1.581000e+05,  5.340000e+04,  9.472000e+05,
         1.044000e+05,  1.044000e+05, -2.086000e+05, -2.087000e+05,
         1.170000e+04,  1.040000e+04,  3.800000e+03,  6.760000e+04,
         4.600000e+03,  4.400000e+03,  5.130000e+05, -2.200000e+03,
         1.630000e+04, -9.460000e+04,  0.000000e+00,  0.000000e+00,
         2.230000e+04,  9.150000e+04,  1.060000e+04,  2.350000e+04,
         0.000000e+00,  0.000000e+00,  6.195000e+05,  5.204000e+05,
         2.390000e+04,  3.520000e+04,  1.020000e+04,  0.000000e+00,
         6.960000e+04,  2.557000e+05,  8.100000e+03,  7.800000e+03,
         7.800000e+03,  8.710000e+04,  6.600000e+03,  7.300000e+03,
         9.400000e+04,  1.420000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -6.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  6.760000e+04,  1.040000e+04,
         6.730000e+04, -1.043000e+05,  0.000000e+00,  8.430000e+04,
        -8.600000e+04, -9.430000e+04, -2.060000e+04, -1.043000e+05,
         4.057000e+05,  3.131000e+05, -5.120000e+04, -9.260000e+04,
         1.057000e+05,  5.340000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.043000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-5.010000e+04,  8.290000e+04, -5.760000e+04, -6.810000e+04,
        -5.900000e+04, -1.871000e+05, -8.700000e+04, -5.100000e+04,
         8.290000e+04, -5.150000e+04,  8.280000e+04, -6.730000e+04,
        -1.000000e+02,  5.035000e+05, -7.780000e+04, -6.840000e+04,
        -1.000000e+02, -2.692000e+05,  2.985000e+05,  5.722000e+05,
         2.868000e+05,  2.627000e+05, -7.020000e+04, -2.228000e+05,
         4.173000e+05, -1.543000e+05,  5.616000e+05,  1.380100e+06,
         4.147000e+05,  4.150000e+05,  4.161000e+05,  4.158000e+05,
         5.855000e+05,  4.149000e+05,  3.947900e+06,  4.314700e+06,
         3.932300e+06,  4.342000e+05,  5.263000e+05,  4.303000e+05,
        -1.274000e+05, -1.275000e+05,  5.038000e+05,  5.039000e+05,
         3.304000e+05,  1.616000e+05,  2.707000e+05,  3.335000e+05,
         7.773000e+05,  8.690000e+05,  1.900000e+03,  4.313000e+05,
        -1.366000e+05, -1.460000e+05, -1.279000e+05,  6.048000e+05,
         6.048000e+05,  7.781000e+05,  5.969000e+05, -6.040000e+04,
        -9.100000e+04, -1.653000e+05, -6.720000e+04, -1.364000e+05,
        -1.364000e+05, -1.364000e+05, -1.364000e+05, -5.700000e+03,
         4.344000e+05, -1.459000e+05, -7.980000e+04,  1.110000e+04,
        -1.637000e+05, -2.491000e+05,  4.230000e+05,  7.600000e+04,
        -6.480000e+04, -6.480000e+04, -7.780000e+04, -7.780000e+04,
        -7.780000e+04, -5.843000e+05, -2.569000e+05,  5.549000e+05,
         2.490000e+05, -2.699000e+05, -7.240000e+04, -3.768000e+05,
        -5.652000e+05, -1.076000e+05, -5.652000e+05, -1.085000e+05,
         5.773000e+05,  1.911200e+06,  2.482000e+06,  2.191100e+06,
         3.470000e+05,  4.387000e+05,  4.639000e+05,  4.927000e+05,
        -7.910000e+04,  1.200000e+04,  4.269000e+05,  8.369000e+05,
         4.970000e+04,  2.566000e+05,  3.800000e+04,  6.216000e+05,
        -2.180000e+04,  3.351000e+05,  9.057000e+05, -2.356000e+05,
         7.938000e+05,  3.155000e+05,  7.826000e+05,  9.661000e+05,
         1.466000e+05, -2.922000e+05, -1.570000e+04,  2.793000e+05,
         1.501000e+05, -9.720000e+04, -3.412000e+05,  3.220000e+05,
         2.534000e+05,  8.000000e+04, -1.153000e+05, -1.153000e+05,
         8.010000e+04,  2.879000e+05, -1.708000e+05, -2.068000e+06,
        -7.620000e+04, -7.620000e+04, -1.100000e+04, -1.100000e+04,
         3.327000e+05, -1.100000e+04, -3.484000e+05, -1.100000e+04,
        -8.860000e+04, -8.860000e+04, -8.860000e+04, -8.860000e+04,
        -8.780000e+04,  9.120000e+04,  9.120000e+04,  9.120000e+04,
         5.474000e+05,  1.636000e+05,  7.630000e+04,  1.007200e+06,
         1.556000e+05,  1.559000e+05, -1.101000e+05, -1.101000e+05,
         1.230000e+04,  9.600000e+03, -1.060000e+04,  1.280000e+04,
         5.010000e+04,  5.500000e+03,  5.035000e+05, -6.730000e+04,
         1.494000e+05, -1.810000e+04,  0.000000e+00, -6.000000e+02,
         3.000000e+03,  6.900000e+03,  9.890000e+04,  2.020000e+04,
         0.000000e+00,  0.000000e+00,  5.204000e+05,  6.348000e+05,
         2.511000e+05,  5.960000e+04,  9.550000e+04,  0.000000e+00,
         1.310000e+04,  2.508000e+05,  7.460000e+04,  9.100000e+03,
         9.100000e+03,  1.710000e+04,  9.850000e+04,  5.800000e+03,
         2.610000e+04,  1.075000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.280000e+04,  9.600000e+03,
         6.610000e+04, -8.860000e+04,  0.000000e+00, -5.010000e+04,
         8.290000e+04, -7.780000e+04, -1.364000e+05, -1.459000e+05,
         4.158000e+05,  3.327000e+05, -1.100000e+04, -7.620000e+04,
         9.120000e+04,  7.630000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -8.860000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-6.800000e+03,  4.653000e+05, -1.240000e+04, -1.410000e+04,
        -1.040000e+04, -2.210000e+04, -8.500000e+03, -7.200000e+03,
         4.653000e+05, -7.300000e+03,  4.650000e+05, -1.330000e+04,
         8.820000e+04,  1.690000e+04, -1.740000e+04, -1.350000e+04,
         2.030000e+04, -5.320000e+04, -2.410000e+04,  6.561000e+05,
        -2.960000e+04, -3.440000e+04,  4.931000e+05, -4.790000e+04,
        -1.011000e+05, -1.318000e+05,  3.663000e+05, -1.969000e+05,
        -4.000000e+03, -4.200000e+03, -3.200000e+03, -3.900000e+03,
         1.080000e+04, -4.200000e+03,  2.370000e+04,  9.310000e+05,
         1.630000e+04,  3.000000e+03,  2.302000e+05,  1.200000e+03,
        -2.460000e+04, -2.530000e+04, -2.940000e+04, -2.940000e+04,
         2.357000e+05,  5.000000e+05, -3.280000e+04, -2.100000e+04,
        -6.040000e+04,  1.665000e+05,  1.492400e+06,  3.500000e+03,
        -2.770000e+04, -3.150000e+04, -2.550000e+04, -5.580000e+04,
        -5.580000e+04,  4.021000e+05, -5.950000e+04,  1.600000e+03,
        -4.640000e+04, -3.800000e+04, -1.580000e+04, -2.740000e+04,
        -2.740000e+04, -2.740000e+04, -2.740000e+04,  4.444000e+05,
         3.300000e+03, -3.080000e+04,  2.052000e+05,  3.600000e+03,
         2.693000e+05, -8.400000e+03, -2.000000e+02, -3.110000e+04,
        -1.480000e+04, -1.480000e+04, -1.740000e+04, -1.740000e+04,
        -1.740000e+04, -1.234000e+05,  1.056100e+06, -6.210000e+04,
        -2.840000e+04, -5.460000e+04,  6.532000e+05,  1.212800e+06,
        -1.165000e+05,  1.534800e+06, -1.165000e+05,  1.534600e+06,
        -5.390000e+04,  5.460000e+04,  8.530000e+04,  9.922000e+05,
        -1.780000e+04,  2.092000e+05,  4.315900e+06,  1.320000e+04,
        -1.720000e+04,  2.096000e+05, -4.000000e+02, -4.200000e+03,
         1.770000e+04,  7.216000e+05,  1.210000e+04,  4.810000e+04,
         3.600000e+03, -1.000000e+04,  2.060000e+04, -4.060000e+04,
         1.124800e+06, -1.920000e+04, -1.470000e+04,  4.392000e+05,
        -6.590000e+04, -6.170000e+04,  6.197000e+05, -3.140000e+04,
        -6.590000e+04,  6.458000e+05, -7.670000e+04, -2.400000e+04,
        -3.810000e+04,  2.271000e+05, -1.960000e+04, -1.960000e+04,
         6.876000e+05,  1.068000e+06, -6.680000e+04, -3.684000e+05,
        -1.720000e+04, -1.720000e+04, -3.900000e+03, -3.900000e+03,
        -2.080000e+04, -3.900000e+03,  1.720000e+04, -3.900000e+03,
        -2.090000e+04, -2.090000e+04, -2.090000e+04, -2.090000e+04,
        -2.040000e+04,  2.300000e+04,  2.300000e+04,  2.300000e+04,
         1.379000e+05,  3.750000e+04,  1.680000e+04, -5.950000e+04,
        -6.270000e+04, -6.270000e+04, -1.254000e+05, -1.254000e+05,
         3.700000e+03,  3.300000e+03, -3.000000e+04,  4.900000e+03,
         1.424000e+05,  1.400000e+03,  1.690000e+04, -1.330000e+04,
         5.486000e+05, -6.900000e+03,  0.000000e+00,  2.300000e+03,
        -2.300000e+04, -2.360000e+04,  2.001000e+05,  4.800000e+03,
         0.000000e+00,  0.000000e+00,  2.390000e+04,  2.511000e+05,
         8.012000e+05,  1.825000e+05,  1.934000e+05,  0.000000e+00,
         5.000000e+03,  8.800000e+03,  2.738000e+05,  3.000000e+03,
         3.000000e+03,  6.200000e+03,  2.471000e+05,  1.500000e+03,
         9.200000e+03,  2.501000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  4.900000e+03,  3.300000e+03,
         2.200000e+03, -2.090000e+04,  0.000000e+00, -6.800000e+03,
         4.653000e+05, -1.740000e+04, -2.740000e+04, -3.080000e+04,
        -3.900000e+03, -2.080000e+04, -3.900000e+03, -1.720000e+04,
         2.300000e+04,  1.680000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.090000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 4.190000e+04,  8.670000e+04, -3.500000e+03, -1.020000e+04,
         1.580000e+04,  1.873000e+05,  1.035000e+05,  4.060000e+04,
         8.670000e+04,  4.000000e+04,  8.670000e+04,  1.720000e+04,
         1.600000e+04,  8.800000e+03, -1.080000e+04,  1.590000e+04,
         3.500000e+03,  6.880000e+04,  5.350000e+04,  1.251000e+05,
        -1.430000e+04, -2.330000e+04,  9.450000e+04,  1.790000e+04,
        -2.710000e+04, -2.080000e+04,  1.850000e+04, -8.850000e+04,
        -3.200000e+03, -3.200000e+03, -3.000000e+03, -3.000000e+03,
         5.100000e+03, -3.200000e+03,  9.690000e+04,  1.923000e+05,
         6.600000e+03,  2.370000e+04,  4.770000e+04,  1.100000e+03,
         5.500000e+03, -1.990000e+04, -2.010000e+04, -2.010000e+04,
         3.880000e+04,  9.760000e+04, -2.030000e+04, -1.390000e+04,
        -1.780000e+04,  6.100000e+03,  3.004000e+05, -7.000000e+02,
         4.900000e+03, -2.100000e+04, -2.000000e+04,  1.140000e+04,
         1.130000e+04,  5.880000e+04, -3.380000e+04,  1.432000e+05,
        -1.680000e+04, -2.230000e+04, -8.700000e+03,  2.990000e+04,
         2.990000e+04,  2.990000e+04,  2.990000e+04,  7.470000e+04,
         2.350000e+04,  4.500000e+03,  2.690000e+04,  1.000000e+03,
         5.990000e+04, -1.660000e+04, -1.900000e+03, -1.890000e+04,
        -6.900000e+03, -6.900000e+03, -1.080000e+04, -1.080000e+04,
        -1.080000e+04,  4.180000e+04,  1.539000e+05,  2.880000e+04,
         7.160000e+04,  3.480000e+04,  1.023000e+05,  2.397000e+05,
         9.270000e+04,  2.496000e+05,  9.270000e+04,  2.496000e+05,
         8.000000e+04,  1.177000e+05,  1.113000e+05,  2.085000e+05,
         1.170000e+04,  3.560000e+04,  8.360000e+05, -5.800000e+03,
         4.000000e+02,  2.430000e+04, -2.100000e+03, -5.100000e+03,
         6.600000e+04,  1.340000e+05, -1.800000e+03,  5.990000e+04,
         6.990000e+04,  1.072000e+05,  1.007000e+05,  1.137000e+05,
         2.269000e+05, -5.800000e+03,  3.540000e+04,  8.330000e+04,
        -3.870000e+04,  3.280000e+04,  1.048000e+05,  2.660000e+04,
        -3.900000e+04,  1.001000e+05,  1.190000e+04, -1.460000e+04,
        -2.460000e+04,  3.430000e+04,  5.790000e+04,  5.790000e+04,
         1.241000e+05,  1.715000e+05,  5.180000e+04,  8.858000e+05,
        -1.090000e+04, -1.090000e+04, -1.460000e+04, -1.460000e+04,
        -1.380000e+04, -1.470000e+04, -1.410000e+04, -1.460000e+04,
        -1.200000e+04, -1.200000e+04, -1.200000e+04, -1.200000e+04,
        -1.120000e+04,  1.220000e+04,  1.220000e+04,  1.220000e+04,
         7.330000e+04,  9.300000e+03, -2.700000e+03, -4.100000e+04,
        -3.780000e+04, -3.790000e+04, -7.390000e+04, -7.390000e+04,
         1.100000e+03,  1.400000e+03, -6.200000e+03,  1.900000e+04,
         2.870000e+04,  1.000000e+02,  8.800000e+03,  1.720000e+04,
         1.266000e+05, -2.700000e+04,  0.000000e+00,  1.100000e+03,
        -2.200000e+03,  1.880000e+04,  4.370000e+04,  2.600000e+03,
         0.000000e+00,  0.000000e+00,  3.520000e+04,  5.960000e+04,
         1.825000e+05,  6.489500e+06,  4.230000e+04,  0.000000e+00,
         1.960000e+04,  4.600000e+03,  6.320000e+04,  5.000000e+02,
         5.000000e+02,  2.480000e+04,  5.420000e+04,  1.000000e+03,
         2.510000e+04,  5.470000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -2.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.900000e+04,  1.400000e+03,
         1.200000e+03, -1.200000e+04,  0.000000e+00,  4.190000e+04,
         8.670000e+04, -1.080000e+04,  2.990000e+04,  4.500000e+03,
        -3.000000e+03, -1.380000e+04, -1.460000e+04, -1.090000e+04,
         1.220000e+04, -2.700000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.200000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-1.600000e+03,  1.235000e+05, -1.590000e+04, -2.080000e+04,
        -1.120000e+04, -4.200000e+03, -9.000000e+02, -1.700000e+03,
         1.234000e+05, -1.800000e+03,  1.234000e+05, -4.300000e+03,
         2.300000e+04,  7.500000e+03, -1.420000e+04, -4.400000e+03,
         5.300000e+03, -1.730000e+04, -5.400000e+03,  2.495000e+05,
        -7.660000e+04, -3.640000e+04,  8.290000e+04, -1.570000e+04,
        -3.330000e+04, -4.520000e+04,  1.024000e+05, -2.222000e+05,
         0.000000e+00,  1.000000e+02, -6.000000e+02,  1.000000e+02,
         5.600000e+03,  1.000000e+02,  2.410000e+04,  3.638000e+05,
        -7.080000e+04,  3.100000e+03,  8.810000e+04, -2.070000e+04,
        -3.210000e+04, -4.850000e+04, -2.690000e+04, -2.690000e+04,
         2.840000e+04,  8.660000e+04, -4.980000e+04, -1.540000e+04,
        -5.340000e+04,  3.160000e+04,  3.082000e+05, -1.370000e+04,
        -2.540000e+04, -3.500000e+04, -4.850000e+04, -1.590000e+04,
        -1.590000e+04,  1.438000e+05, -6.330000e+04,  3.600000e+03,
         4.813000e+05, -2.170000e+04, -5.700000e+03, -8.700000e+03,
        -8.700000e+03, -8.700000e+03, -8.700000e+03,  1.159000e+05,
         3.100000e+03, -1.870000e+04,  4.380000e+04,  1.600000e+03,
         5.560000e+04, -3.600000e+03, -7.200000e+03, -1.660000e+04,
        -1.050000e+04, -1.050000e+04, -1.420000e+04, -1.420000e+04,
        -1.420000e+04, -5.780000e+04,  2.538000e+05, -3.490000e+04,
        -2.450000e+04, -1.720000e+04,  1.699000e+05,  3.201000e+05,
        -3.770000e+04,  3.984000e+05, -3.770000e+04,  3.982000e+05,
        -1.340000e+04,  2.690000e+04,  3.860000e+04,  2.912000e+05,
        -4.200000e+03,  8.080000e+04,  1.080200e+06,  5.600000e+03,
        -6.200000e+03,  7.870000e+04,  1.700000e+03, -7.900000e+03,
         7.800000e+03,  2.041000e+05, -6.330000e+04,  1.970000e+04,
         2.400000e+03,  2.000000e+02,  1.200000e+04, -1.150000e+04,
         4.254000e+05, -1.184000e+05, -9.000000e+02,  1.692000e+05,
        -2.240000e+04, -2.030000e+04,  2.348000e+05, -8.500000e+03,
        -2.320000e+04,  1.663000e+05, -5.730000e+04, -7.300000e+03,
        -2.990000e+04,  2.540000e+04, -5.800000e+03, -5.800000e+03,
         1.814000e+05,  3.390000e+05, -8.610000e+04, -1.096000e+05,
        -5.800000e+03, -5.800000e+03, -1.700000e+03, -1.700000e+03,
        -1.580000e+04, -1.700000e+03,  4.000000e+03, -1.700000e+03,
        -7.500000e+03, -7.500000e+03, -7.500000e+03, -7.500000e+03,
        -7.300000e+03,  7.900000e+03,  7.900000e+03,  7.900000e+03,
         4.760000e+04,  1.280000e+04,  5.500000e+03, -5.420000e+04,
        -3.080000e+04, -3.060000e+04, -5.320000e+04, -5.320000e+04,
         1.800000e+03, -6.200000e+03,  5.019000e+05,  2.200000e+03,
         3.830000e+04, -2.000000e+03,  7.500000e+03, -4.300000e+03,
         1.137000e+05, -2.700000e+03,  0.000000e+00, -5.000000e+02,
         3.928000e+05,  5.048000e+05,  5.933000e+05,  1.700000e+03,
         0.000000e+00,  0.000000e+00,  1.020000e+04,  9.550000e+04,
         1.934000e+05,  4.230000e+04,  8.942000e+05,  0.000000e+00,
         2.300000e+03,  3.900000e+03,  5.670000e+04, -6.700000e+03,
        -6.700000e+03,  2.900000e+03,  7.750000e+04, -2.000000e+03,
        -3.800000e+03,  7.070000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.200000e+03, -6.200000e+03,
         1.000000e+03, -7.500000e+03,  0.000000e+00, -1.600000e+03,
         1.235000e+05, -1.420000e+04, -8.700000e+03, -1.870000e+04,
         1.000000e+02, -1.580000e+04, -1.700000e+03, -5.800000e+03,
         7.900000e+03,  5.500000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -7.500000e+03,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  9.508600e+06,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  4.754300e+06,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  9.508600e+06,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  9.508600e+06,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 9.860000e+04, -1.300000e+04, -1.610000e+04, -1.520000e+04,
         4.170000e+04,  4.742000e+05,  2.770000e+05,  9.990000e+04,
        -1.300000e+04,  1.005000e+05, -1.300000e+04,  3.860000e+04,
        -7.200000e+03,  1.140000e+04, -1.620000e+04,  3.980000e+04,
        -1.500000e+03,  1.542000e+05,  1.319000e+05, -3.420000e+04,
        -4.030000e+04, -3.650000e+04, -4.510000e+04,  6.200000e+04,
        -1.240000e+04,  1.630000e+04, -1.229000e+05, -1.085000e+05,
        -5.500000e+03, -5.500000e+03, -5.500000e+03, -5.800000e+03,
         5.700000e+03, -5.100000e+03,  2.053000e+05, -1.630000e+04,
        -2.430000e+04,  5.250000e+04, -3.200000e+03, -4.900000e+03,
         2.670000e+04, -2.970000e+04, -3.150000e+04, -3.150000e+04,
        -3.570000e+04, -3.990000e+04, -3.760000e+04, -2.070000e+04,
        -1.030000e+04, -6.580000e+04, -8.660000e+04, -3.600000e+03,
         2.540000e+04, -3.130000e+04, -3.030000e+04,  5.260000e+04,
         5.300000e+04, -5.820000e+04, -6.220000e+04,  4.359000e+05,
        -1.520000e+04, -3.330000e+04, -1.320000e+04,  8.030000e+04,
         8.030000e+04,  8.030000e+04,  8.030000e+04, -2.990000e+04,
         5.170000e+04,  2.400000e+04, -3.160000e+04,  2.000000e+02,
        -3.900000e+03, -3.460000e+04, -4.600000e+03, -2.760000e+04,
        -1.460000e+04, -1.460000e+04, -1.620000e+04, -1.620000e+04,
        -1.620000e+04,  1.515000e+05, -1.245000e+05,  9.400000e+04,
         1.765000e+05,  1.038000e+05, -6.110000e+04, -6.990000e+04,
         2.642000e+05, -1.218000e+05,  2.642000e+05, -1.213000e+05,
         2.076000e+05,  2.425000e+05,  2.140000e+05,  2.180000e+04,
         3.530000e+04, -2.030000e+04, -1.681000e+05, -1.930000e+04,
         9.400000e+03, -4.600000e+04, -4.900000e+03, -9.600000e+03,
         1.403000e+05, -2.500000e+04, -3.190000e+04,  1.116000e+05,
         1.590000e+05,  2.499000e+05,  2.211000e+05,  2.788000e+05,
        -2.810000e+04, -3.710000e+04,  8.760000e+04, -2.360000e+04,
        -5.520000e+04,  1.034000e+05, -6.390000e+04,  7.480000e+04,
        -5.580000e+04, -6.140000e+04,  1.105000e+05, -2.090000e+04,
        -3.710000e+04, -4.120000e+04,  1.319000e+05,  1.319000e+05,
        -2.720000e+04, -1.053000e+05,  1.727000e+05,  2.198400e+06,
        -1.670000e+04, -1.680000e+04, -3.110000e+04, -3.110000e+04,
        -2.140000e+04, -3.070000e+04, -3.980000e+04, -3.110000e+04,
        -1.690000e+04, -1.690000e+04, -1.690000e+04, -1.690000e+04,
        -1.770000e+04,  1.720000e+04,  1.720000e+04,  1.720000e+04,
         1.034000e+05,  4.200000e+03, -1.340000e+04, -6.390000e+04,
        -5.450000e+04, -5.370000e+04, -1.037000e+05, -1.032000e+05,
         6.000000e+02,  0.000000e+00,  7.000000e+02,  6.560000e+04,
         1.400000e+03,  2.100000e+03,  1.140000e+04,  3.860000e+04,
         3.300000e+03, -5.850000e+04,  0.000000e+00,  0.000000e+00,
         3.000000e+02,  5.980000e+04,  2.300000e+03,  4.000000e+03,
         0.000000e+00,  0.000000e+00,  6.960000e+04,  1.310000e+04,
         5.000000e+03,  1.960000e+04,  2.300000e+03,  0.000000e+00,
         8.000000e+04,  6.200000e+03,  1.800000e+03,  5.000000e+02,
         5.000000e+02,  5.880000e+04,  1.500000e+03,  6.000000e+02,
         5.900000e+04,  1.900000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.000000e+02, -3.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  6.560000e+04,  0.000000e+00,
         1.500000e+03, -1.690000e+04,  4.000000e+02,  9.860000e+04,
        -1.300000e+04, -1.620000e+04,  8.030000e+04,  2.400000e+04,
        -5.700000e+03, -2.140000e+04, -3.110000e+04, -1.680000e+04,
         1.720000e+04, -1.340000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.690000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-2.390000e+04, -3.480000e+04, -2.720000e+04, -3.200000e+04,
        -2.790000e+04, -8.930000e+04, -4.160000e+04, -2.440000e+04,
        -3.480000e+04, -2.460000e+04, -3.480000e+04, -3.180000e+04,
        -1.460000e+04,  2.487000e+05, -3.650000e+04, -3.230000e+04,
        -3.400000e+03, -1.273000e+05,  1.507000e+05,  1.305000e+05,
         1.448000e+05,  1.345000e+05, -1.037000e+05, -1.055000e+05,
         2.180000e+05, -6.210000e+04,  2.060000e+05,  7.096000e+05,
         2.072000e+05,  2.069000e+05,  2.066000e+05,  2.074000e+05,
         2.902000e+05,  2.071000e+05,  1.962600e+06,  1.935700e+06,
         1.954700e+06,  2.158000e+05,  2.116000e+05,  2.138000e+05,
        -6.000000e+04, -5.980000e+04,  2.540000e+05,  2.540000e+05,
         1.339000e+05,  1.440000e+04,  1.380000e+05,  1.682000e+05,
         3.940000e+05,  3.887000e+05, -2.118000e+05,  2.140000e+05,
        -6.430000e+04, -6.860000e+04, -6.000000e+04,  3.060000e+05,
         3.062000e+05,  2.935000e+05,  3.020000e+05, -2.910000e+04,
        -3.660000e+04, -7.760000e+04, -3.150000e+04, -6.470000e+04,
        -6.470000e+04, -6.470000e+04, -6.470000e+04, -7.640000e+04,
         2.152000e+05, -6.870000e+04, -7.440000e+04,  5.000000e+03,
        -1.154000e+05, -1.228000e+05,  2.105000e+05,  4.120000e+04,
        -3.050000e+04, -3.050000e+04, -3.650000e+04, -3.650000e+04,
        -3.650000e+04, -2.756000e+05, -3.048000e+05,  2.831000e+05,
         1.280000e+05, -1.279000e+05, -1.450000e+05, -3.893000e+05,
        -2.674000e+05, -3.086000e+05, -2.674000e+05, -3.089000e+05,
         2.900000e+05,  9.427000e+05,  1.222500e+06,  9.188000e+05,
         1.751000e+05,  1.699000e+05, -4.410000e+05,  2.437000e+05,
        -3.730000e+04, -4.410000e+04,  2.127000e+05,  4.170000e+05,
         2.290000e+04,  4.900000e+03,  1.700000e+04,  3.039000e+05,
        -1.050000e+04,  1.683000e+05,  4.485000e+05, -1.118000e+05,
         1.418000e+05,  1.585000e+05,  3.918000e+05,  3.812000e+05,
         9.210000e+04, -1.380000e+05, -1.505000e+05,  1.428000e+05,
         8.200000e+04, -1.561000e+05, -1.397000e+05,  1.747000e+05,
         1.306000e+05,  1.050000e+04, -5.430000e+04, -5.430000e+04,
        -7.260000e+04, -7.110000e+04, -4.460000e+04, -9.756000e+05,
        -3.600000e+04, -3.610000e+04, -5.100000e+03, -5.100000e+03,
         1.678000e+05, -4.900000e+03, -1.755000e+05, -5.100000e+03,
        -4.160000e+04, -4.160000e+04, -4.160000e+04, -4.160000e+04,
        -4.140000e+04,  4.290000e+04,  4.290000e+04,  4.290000e+04,
         2.576000e+05,  7.720000e+04,  3.610000e+04,  5.078000e+05,
         8.500000e+04,  8.540000e+04, -3.910000e+04, -3.890000e+04,
         5.700000e+03,  4.500000e+03,  1.600000e+03,  5.800000e+03,
         1.900000e+03,  2.500000e+03,  2.487000e+05, -3.180000e+04,
         6.200000e+03, -8.500000e+03,  0.000000e+00,  0.000000e+00,
         7.100000e+03,  9.600000e+03,  4.000000e+03,  9.500000e+03,
         0.000000e+00,  0.000000e+00,  2.557000e+05,  2.508000e+05,
         8.800000e+03,  4.600000e+03,  3.900000e+03,  0.000000e+00,
         6.200000e+03,  1.298000e+05,  3.200000e+03,  4.300000e+03,
         4.300000e+03,  7.800000e+03,  2.400000e+03,  2.700000e+03,
         1.210000e+04,  6.700000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.000000e+02, -1.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  5.800000e+03,  4.500000e+03,
         3.260000e+04, -4.160000e+04,  2.000000e+02, -2.390000e+04,
        -3.480000e+04, -3.650000e+04, -6.470000e+04, -6.870000e+04,
         2.074000e+05,  1.678000e+05, -5.100000e+03, -3.610000e+04,
         4.290000e+04,  3.610000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -4.160000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-2.200000e+03,  1.542000e+05, -4.100000e+03, -4.900000e+03,
        -3.600000e+03, -7.000000e+03, -2.600000e+03, -2.300000e+03,
         1.542000e+05, -2.400000e+03,  1.541000e+05, -4.300000e+03,
         2.920000e+04,  6.000000e+03, -5.900000e+03, -4.400000e+03,
         6.700000e+03, -1.740000e+04, -7.900000e+03,  1.911000e+05,
        -9.900000e+03, -1.200000e+04,  1.726000e+05, -1.600000e+04,
        -3.290000e+04, -4.320000e+04,  1.177000e+05, -6.830000e+04,
        -9.000000e+02, -9.000000e+02, -7.000000e+02, -9.000000e+02,
         4.000000e+03, -7.000000e+02,  1.170000e+04,  2.771000e+05,
         9.100000e+03,  1.600000e+03,  6.800000e+04,  9.000000e+02,
        -8.500000e+03, -9.100000e+03, -9.700000e+03, -9.700000e+03,
         8.720000e+04,  1.811000e+05, -1.120000e+04, -6.400000e+03,
        -1.970000e+04,  4.670000e+04,  5.313000e+05,  6.000000e+02,
        -9.400000e+03, -1.080000e+04, -9.100000e+03, -1.820000e+04,
        -1.800000e+04,  1.198000e+05, -1.950000e+04,  1.100000e+03,
        -1.450000e+04, -1.270000e+04, -5.200000e+03, -9.100000e+03,
        -9.100000e+03, -9.100000e+03, -9.100000e+03,  1.473000e+05,
         1.200000e+03, -1.030000e+04,  6.790000e+04,  1.100000e+03,
         9.910000e+04, -3.000000e+03,  0.000000e+00, -1.000000e+04,
        -4.800000e+03, -4.800000e+03, -5.900000e+03, -5.900000e+03,
        -5.900000e+03, -4.090000e+04,  3.502000e+05, -2.020000e+04,
        -9.100000e+03, -1.810000e+04,  2.166000e+05,  3.834000e+05,
        -3.860000e+04,  5.090000e+05, -3.860000e+04,  5.090000e+05,
        -1.860000e+04,  1.880000e+04,  2.910000e+04,  3.236000e+05,
        -5.000000e+03,  6.130000e+04,  1.453700e+06,  4.900000e+03,
        -5.600000e+03,  6.070000e+04,  5.000000e+02, -6.000000e+02,
         5.800000e+03,  2.356000e+05,  3.900000e+03,  1.640000e+04,
         1.600000e+03, -2.400000e+03,  8.000000e+03, -1.290000e+04,
         3.294000e+05, -5.700000e+03, -3.200000e+03,  1.295000e+05,
        -2.100000e+04, -2.030000e+04,  1.789000e+05, -9.800000e+03,
        -2.110000e+04,  2.144000e+05,  1.060000e+04, -7.000000e+03,
        -1.260000e+04,  8.430000e+04, -6.000000e+03, -6.000000e+03,
         2.282000e+05,  3.338000e+05,  2.000000e+03, -1.153000e+05,
        -5.700000e+03, -5.700000e+03, -1.300000e+03, -1.300000e+03,
        -6.700000e+03, -1.100000e+03,  5.200000e+03, -1.300000e+03,
        -6.800000e+03, -6.800000e+03, -6.800000e+03, -6.800000e+03,
        -6.700000e+03,  7.600000e+03,  7.600000e+03,  7.600000e+03,
         4.580000e+04,  1.250000e+04,  5.600000e+03, -1.930000e+04,
        -2.000000e+04, -1.960000e+04, -3.970000e+04, -3.950000e+04,
         1.300000e+03,  9.000000e+02, -8.800000e+03,  1.600000e+03,
         4.720000e+04,  5.000000e+02,  6.000000e+03, -4.300000e+03,
         2.030000e+05, -2.400000e+03,  0.000000e+00,  1.400000e+03,
        -6.700000e+03, -6.700000e+03,  5.870000e+04,  1.600000e+03,
         0.000000e+00,  0.000000e+00,  8.100000e+03,  7.460000e+04,
         2.738000e+05,  6.320000e+04,  5.670000e+04,  0.000000e+00,
         1.800000e+03,  3.200000e+03,  1.106000e+05,  9.000000e+02,
         9.000000e+02,  2.000000e+03,  6.990000e+04,  5.000000e+02,
         2.800000e+03,  7.080000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         2.000000e+02, -1.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.600000e+03,  9.000000e+02,
         8.000000e+02, -6.800000e+03,  2.000000e+02, -2.200000e+03,
         1.542000e+05, -5.900000e+03, -9.100000e+03, -1.030000e+04,
        -9.000000e+02, -6.700000e+03, -1.300000e+03, -5.700000e+03,
         7.600000e+03,  5.600000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -6.800000e+03,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-2.720000e+04, -2.430000e+04, -2.190000e+04,  3.337000e+05,
         1.531000e+05, -1.084000e+05, -5.390000e+04, -2.720000e+04,
        -2.430000e+04, -2.720000e+04, -2.430000e+04, -2.750000e+04,
        -1.030000e+04,  7.600000e+03,  1.483000e+05, -2.750000e+04,
        -2.400000e+03, -1.101000e+05, -7.550000e+04, -7.100000e+04,
        -6.700000e+04,  4.446000e+05,  4.451000e+05, -8.350000e+04,
        -1.788000e+05, -2.141000e+05, -1.756000e+05,  2.839300e+06,
        -2.020000e+04, -2.020000e+04, -2.020000e+04, -2.020000e+04,
        -4.400000e+03, -2.020000e+04, -1.397000e+05, -1.339000e+05,
        -1.284000e+05, -2.000000e+04, -1.840000e+04, -1.710000e+04,
         4.867000e+05,  8.589000e+05,  2.733000e+05,  2.733000e+05,
         2.719000e+05,  2.716000e+05,  2.741000e+05,  1.246000e+05,
         5.445000e+05,  5.461000e+05,  5.390000e+05,  3.300000e+05,
         3.019000e+05,  4.824000e+05,  8.646000e+05, -1.232000e+05,
        -1.232000e+05, -1.204000e+05, -1.176000e+05, -5.300000e+04,
         1.387000e+05,  1.112000e+05, -2.130000e+04, -5.540000e+04,
        -5.540000e+04, -5.540000e+04, -5.540000e+04, -5.210000e+04,
        -2.010000e+04,  1.182000e+05,  1.199000e+05,  1.400000e+03,
        -8.000000e+02, -2.600000e+03,  1.532000e+05,  3.300000e+04,
        -2.190000e+04, -2.190000e+04,  1.483000e+05,  1.483000e+05,
         1.483000e+05,  1.257000e+05,  1.340000e+05,  1.951000e+05,
         2.435000e+05, -1.079000e+05, -1.025000e+05, -1.085000e+05,
        -2.214000e+05, -2.098000e+05, -2.214000e+05, -2.099000e+05,
        -1.503000e+05, -2.450000e+04,  1.080000e+04, -1.810000e+04,
        -4.780000e+04, -4.630000e+04, -3.075000e+05,  7.400000e+03,
        -2.770000e+04, -2.620000e+04, -1.860000e+04,  1.321000e+05,
        -1.000000e+02,  5.100000e+03,  8.400000e+03,  3.500000e+04,
        -2.470000e+04, -7.460000e+04, -3.940000e+04, -1.097000e+05,
        -6.680000e+04, -6.040000e+04, -6.790000e+04, -6.480000e+04,
        -1.021000e+05, -1.107000e+05, -1.059000e+05, -7.550000e+04,
        -1.033000e+05, -1.058000e+05, -1.071000e+05, -4.640000e+04,
         2.705000e+05,  2.691000e+05, -5.390000e+04, -5.390000e+04,
        -5.030000e+04, -1.662000e+05, -1.740000e+05, -9.322000e+05,
        -2.610000e+04, -2.610000e+04,  0.000000e+00,  0.000000e+00,
         1.241000e+05,  1.000000e+02,  4.800000e+04,  0.000000e+00,
        -2.770000e+04, -2.770000e+04, -2.770000e+04, -2.770000e+04,
        -2.780000e+04,  2.720000e+04,  2.720000e+04,  2.720000e+04,
         1.633000e+05,  5.590000e+04,  2.800000e+04,  5.635000e+05,
         6.890000e+04,  6.910000e+04, -1.400000e+04, -1.400000e+04,
         1.700000e+03,  1.738000e+05, -8.500000e+03,  5.000000e+02,
         1.000000e+03,  8.000000e+02,  7.600000e+03, -2.750000e+04,
         1.700000e+03, -5.000000e+02,  0.000000e+00, -3.000000e+02,
        -4.600000e+03, -7.700000e+03, -7.000000e+03,  6.400000e+03,
         0.000000e+00,  0.000000e+00,  7.800000e+03,  9.100000e+03,
         3.000000e+03,  5.000000e+02, -6.700000e+03,  0.000000e+00,
         5.000000e+02,  4.300000e+03,  9.000000e+02,  1.912000e+05,
         1.911000e+05,  4.000000e+03,  4.500000e+03,  3.200000e+03,
         1.909000e+05,  1.950000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  3.200000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  5.000000e+02,  1.738000e+05,
         1.000000e+03, -2.770000e+04,  0.000000e+00, -2.720000e+04,
        -2.430000e+04,  1.483000e+05, -5.540000e+04,  1.182000e+05,
        -2.020000e+04,  1.241000e+05,  0.000000e+00, -2.610000e+04,
         2.720000e+04,  2.800000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.770000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-2.720000e+04, -2.430000e+04, -2.190000e+04,  3.336000e+05,
         1.531000e+05, -1.084000e+05, -5.400000e+04, -2.720000e+04,
        -2.430000e+04, -2.720000e+04, -2.430000e+04, -2.750000e+04,
        -1.030000e+04,  7.600000e+03,  1.483000e+05, -2.750000e+04,
        -2.400000e+03, -1.101000e+05, -7.550000e+04, -7.100000e+04,
        -6.700000e+04,  4.445000e+05,  4.450000e+05, -8.350000e+04,
        -1.788000e+05, -2.141000e+05, -1.756000e+05,  2.839100e+06,
        -2.020000e+04, -2.020000e+04, -2.020000e+04, -2.020000e+04,
        -4.400000e+03, -2.020000e+04, -1.398000e+05, -1.339000e+05,
        -1.284000e+05, -2.000000e+04, -1.840000e+04, -1.710000e+04,
         4.865000e+05,  8.586000e+05,  2.733000e+05,  2.733000e+05,
         2.719000e+05,  2.716000e+05,  2.741000e+05,  1.246000e+05,
         5.445000e+05,  5.460000e+05,  5.389000e+05,  3.300000e+05,
         3.019000e+05,  4.823000e+05,  8.643000e+05, -1.232000e+05,
        -1.232000e+05, -1.204000e+05, -1.176000e+05, -5.300000e+04,
         1.387000e+05,  1.113000e+05, -2.130000e+04, -5.540000e+04,
        -5.540000e+04, -5.540000e+04, -5.540000e+04, -5.200000e+04,
        -2.010000e+04,  1.183000e+05,  1.199000e+05,  1.400000e+03,
        -8.000000e+02, -2.600000e+03,  1.532000e+05,  3.300000e+04,
        -2.190000e+04, -2.190000e+04,  1.483000e+05,  1.483000e+05,
         1.483000e+05,  1.258000e+05,  1.341000e+05,  1.951000e+05,
         2.435000e+05, -1.079000e+05, -1.025000e+05, -1.084000e+05,
        -2.214000e+05, -2.098000e+05, -2.214000e+05, -2.099000e+05,
        -1.503000e+05, -2.450000e+04,  1.070000e+04, -1.810000e+04,
        -4.780000e+04, -4.620000e+04, -3.075000e+05,  7.400000e+03,
        -2.770000e+04, -2.620000e+04, -1.860000e+04,  1.321000e+05,
        -1.000000e+02,  5.100000e+03,  8.300000e+03,  3.500000e+04,
        -2.470000e+04, -7.460000e+04, -3.950000e+04, -1.097000e+05,
        -6.680000e+04, -6.040000e+04, -6.790000e+04, -6.480000e+04,
        -1.021000e+05, -1.107000e+05, -1.059000e+05, -7.550000e+04,
        -1.033000e+05, -1.058000e+05, -1.071000e+05, -4.640000e+04,
         2.705000e+05,  2.691000e+05, -5.390000e+04, -5.390000e+04,
        -5.030000e+04, -1.662000e+05, -1.740000e+05, -9.324000e+05,
        -2.610000e+04, -2.610000e+04,  0.000000e+00,  0.000000e+00,
         1.241000e+05,  1.000000e+02,  4.800000e+04,  0.000000e+00,
        -2.770000e+04, -2.770000e+04, -2.770000e+04, -2.770000e+04,
        -2.780000e+04,  2.720000e+04,  2.720000e+04,  2.720000e+04,
         1.632000e+05,  5.590000e+04,  2.800000e+04,  5.634000e+05,
         6.890000e+04,  6.910000e+04, -1.400000e+04, -1.400000e+04,
         1.600000e+03,  1.737000e+05, -8.500000e+03,  5.000000e+02,
         1.000000e+03,  8.000000e+02,  7.600000e+03, -2.750000e+04,
         1.700000e+03, -5.000000e+02,  0.000000e+00, -3.000000e+02,
        -4.600000e+03, -7.700000e+03, -7.000000e+03,  6.400000e+03,
         0.000000e+00,  0.000000e+00,  7.800000e+03,  9.100000e+03,
         3.000000e+03,  5.000000e+02, -6.700000e+03,  0.000000e+00,
         5.000000e+02,  4.300000e+03,  9.000000e+02,  1.911000e+05,
         1.913000e+05,  4.000000e+03,  4.500000e+03,  3.200000e+03,
         1.911000e+05,  1.952000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  3.200000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  5.000000e+02,  1.737000e+05,
         1.000000e+03, -2.770000e+04,  0.000000e+00, -2.720000e+04,
        -2.430000e+04,  1.483000e+05, -5.540000e+04,  1.183000e+05,
        -2.020000e+04,  1.241000e+05,  0.000000e+00, -2.610000e+04,
         2.720000e+04,  2.800000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.770000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.249000e+05, -1.640000e+04, -9.500000e+03, -2.390000e+04,
         5.030000e+04,  5.585000e+05,  3.087000e+05,  1.223000e+05,
        -1.640000e+04,  1.211000e+05, -1.640000e+04,  5.620000e+04,
        -5.000000e+03,  1.510000e+04, -2.370000e+04,  5.370000e+04,
        -1.500000e+03,  2.249000e+05,  1.687000e+05, -4.200000e+04,
        -3.360000e+04, -5.590000e+04, -6.690000e+04,  8.090000e+04,
        -1.300000e+04,  2.400000e+04, -1.533000e+05, -2.051000e+05,
        -6.100000e+03, -6.100000e+03, -6.300000e+03, -6.000000e+03,
         8.300000e+03, -6.200000e+03,  2.666000e+05, -1.500000e+04,
        -3.100000e+03,  6.650000e+04, -3.900000e+03, -9.000000e+02,
         2.660000e+04, -4.350000e+04, -4.620000e+04, -4.620000e+04,
        -5.160000e+04, -5.700000e+04, -4.850000e+04, -3.000000e+04,
        -2.710000e+04, -9.740000e+04, -1.241000e+05, -1.030000e+04,
         2.600000e+04, -4.760000e+04, -3.950000e+04,  6.840000e+04,
         6.830000e+04, -7.150000e+04, -6.650000e+04,  4.271000e+05,
        -2.220000e+04, -4.730000e+04, -1.860000e+04,  1.029000e+05,
         1.029000e+05,  1.029000e+05,  1.029000e+05, -3.750000e+04,
         6.570000e+04,  2.540000e+04, -4.490000e+04,  4.000000e+02,
        -5.000000e+03, -4.310000e+04, -8.600000e+03, -3.640000e+04,
        -1.360000e+04, -1.360000e+04, -2.370000e+04, -2.370000e+04,
        -2.370000e+04,  1.839000e+05, -1.672000e+05,  1.110000e+05,
         2.133000e+05,  1.336000e+05, -7.660000e+04, -8.800000e+04,
         3.386000e+05, -1.528000e+05,  3.386000e+05, -1.524000e+05,
         2.633000e+05,  3.059000e+05,  2.689000e+05,  2.530000e+04,
         4.510000e+04, -2.520000e+04, -2.133000e+05, -2.440000e+04,
         1.180000e+04, -5.840000e+04, -5.700000e+03, -1.490000e+04,
         1.776000e+05, -3.230000e+04, -2.470000e+04,  1.413000e+05,
         1.997000e+05,  3.147000e+05,  2.775000e+05,  3.519000e+05,
        -3.680000e+04, -2.250000e+04,  1.114000e+05, -2.920000e+04,
        -6.870000e+04,  1.327000e+05, -7.830000e+04,  9.640000e+04,
        -6.970000e+04, -7.740000e+04,  1.649000e+05, -2.630000e+04,
        -5.350000e+04, -5.890000e+04,  1.776000e+05,  1.776000e+05,
        -3.520000e+04, -1.347000e+05,  2.168000e+05,  2.778300e+06,
        -2.070000e+04, -2.070000e+04, -3.940000e+04, -3.940000e+04,
        -3.000000e+04, -3.940000e+04, -5.150000e+04, -3.940000e+04,
        -2.110000e+04, -2.110000e+04, -2.110000e+04, -2.110000e+04,
        -1.980000e+04,  2.150000e+04,  2.150000e+04,  2.150000e+04,
         1.289000e+05,  3.800000e+03, -1.780000e+04, -8.590000e+04,
        -7.230000e+04, -7.240000e+04, -1.358000e+05, -1.359000e+05,
         4.000000e+02,  6.000000e+02,  9.000000e+02,  5.760000e+04,
         1.000000e+03, -1.800000e+03,  1.510000e+04,  5.620000e+04,
         4.000000e+03, -7.350000e+04,  0.000000e+00,  0.000000e+00,
         4.700000e+03,  8.430000e+04,  3.000000e+03,  5.600000e+03,
         0.000000e+00,  0.000000e+00,  8.710000e+04,  1.710000e+04,
         6.200000e+03,  2.480000e+04,  2.900000e+03,  0.000000e+00,
         5.880000e+04,  7.800000e+03,  2.000000e+03,  4.000000e+03,
         4.000000e+03,  8.810000e+04,  7.300000e+03,  3.900000e+03,
         9.120000e+04,  1.130000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  4.700000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  5.760000e+04,  6.000000e+02,
         2.000000e+03, -2.110000e+04,  0.000000e+00,  1.249000e+05,
        -1.640000e+04, -2.370000e+04,  1.029000e+05,  2.540000e+04,
        -6.000000e+03, -3.000000e+04, -3.940000e+04, -2.070000e+04,
         2.150000e+04, -1.780000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.110000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-3.200000e+03,  1.550000e+05, -8.200000e+03, -7.200000e+03,
        -5.200000e+03, -1.140000e+04, -5.000000e+03, -3.200000e+03,
         1.550000e+05, -3.300000e+03,  1.549000e+05, -4.900000e+03,
         2.940000e+04,  4.600000e+03, -6.800000e+03, -4.900000e+03,
         6.800000e+03, -1.950000e+04, -9.000000e+03,  2.662000e+05,
        -1.510000e+04, -1.420000e+04,  1.400000e+05, -1.560000e+04,
        -3.290000e+04, -4.260000e+04,  1.315000e+05, -8.530000e+04,
        -2.000000e+03, -2.100000e+03, -1.500000e+03, -1.800000e+03,
         2.600000e+03, -2.100000e+03, -6.000000e+02,  3.667000e+05,
        -8.600000e+03, -2.000000e+02,  9.180000e+04, -2.200000e+03,
        -1.240000e+04, -1.000000e+04, -1.210000e+04, -1.210000e+04,
         5.790000e+04,  1.327000e+05, -1.450000e+04, -8.200000e+03,
        -2.470000e+04,  6.720000e+04,  4.173000e+05, -1.200000e+03,
        -1.200000e+04, -1.400000e+04, -5.100000e+03, -1.870000e+04,
        -1.870000e+04,  1.594000e+05, -2.270000e+04, -2.000000e+03,
        -1.820000e+04, -1.330000e+04, -5.200000e+03, -9.400000e+03,
        -9.400000e+03, -9.400000e+03, -9.400000e+03,  1.485000e+05,
         3.000000e+02, -1.160000e+04,  6.750000e+04,  1.200000e+03,
         6.990000e+04, -2.000000e+03, -1.700000e+03, -1.070000e+04,
        -6.300000e+03, -6.300000e+03, -6.800000e+03, -6.800000e+03,
        -6.800000e+03, -4.370000e+04,  3.511000e+05, -2.430000e+04,
        -1.440000e+04, -1.800000e+04,  2.188000e+05,  4.343000e+05,
        -3.930000e+04,  5.133000e+05, -3.930000e+04,  5.132000e+05,
        -1.740000e+04,  1.380000e+04,  2.340000e+04,  3.383000e+05,
        -6.800000e+03,  8.510000e+04,  1.387900e+06,  3.700000e+03,
        -5.300000e+03,  8.650000e+04, -7.000000e+02, -3.800000e+03,
         4.400000e+03,  2.466000e+05, -1.600000e+03,  1.350000e+04,
        -8.000000e+02, -5.800000e+03,  3.700000e+03, -1.530000e+04,
         4.536000e+05, -1.580000e+04, -7.000000e+03,  1.768000e+05,
        -2.130000e+04, -2.050000e+04,  2.555000e+05, -1.140000e+04,
        -2.110000e+04,  2.162000e+05, -6.204000e+05, -8.200000e+03,
        -1.450000e+04,  5.550000e+04, -7.800000e+03, -7.800000e+03,
         2.293000e+05,  3.961000e+05, -6.330000e+04, -1.397000e+05,
        -5.200000e+03, -5.200000e+03, -1.000000e+03, -1.000000e+03,
        -8.300000e+03, -1.000000e+03,  6.700000e+03, -1.000000e+03,
        -6.500000e+03, -6.500000e+03, -6.500000e+03, -6.500000e+03,
        -6.500000e+03,  7.100000e+03,  7.100000e+03,  7.100000e+03,
         4.240000e+04,  1.170000e+04,  5.300000e+03, -2.040000e+04,
        -2.140000e+04, -2.130000e+04, -4.100000e+04, -4.100000e+04,
         1.300000e+03, -3.000000e+02, -1.200000e+04,  1.500000e+03,
         4.740000e+04, -1.200000e+03,  4.600000e+03, -4.900000e+03,
         1.401000e+05, -1.500000e+03,  0.000000e+00, -5.000000e+02,
        -1.100000e+04, -9.600000e+03,  8.020000e+04,  1.600000e+03,
         0.000000e+00,  0.000000e+00,  6.600000e+03,  9.850000e+04,
         2.471000e+05,  5.420000e+04,  7.750000e+04,  0.000000e+00,
         1.500000e+03,  2.400000e+03,  6.990000e+04,  4.500000e+03,
         4.500000e+03,  7.300000e+03,  2.862000e+05,  2.600000e+03,
         1.220000e+04,  2.896000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  4.900000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.500000e+03, -3.000000e+02,
         6.000000e+02, -6.500000e+03,  0.000000e+00, -3.200000e+03,
         1.550000e+05, -6.800000e+03, -9.400000e+03, -1.160000e+04,
        -1.800000e+03, -8.300000e+03, -1.000000e+03, -5.200000e+03,
         7.100000e+03,  5.300000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -6.500000e+03,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 3.000000e+02, -3.100000e+03,  2.105000e+05, -1.900000e+03,
        -9.000000e+02,  1.600000e+03,  1.200000e+03,  0.000000e+00,
        -3.100000e+03, -2.000000e+02, -3.100000e+03, -1.500000e+03,
        -1.200000e+03,  5.200000e+03, -2.900000e+03, -1.800000e+03,
        -3.000000e+02, -5.900000e+03, -6.000000e+02, -5.900000e+03,
         3.044000e+05, -3.600000e+03, -7.900000e+03, -8.000000e+03,
        -1.580000e+04, -2.290000e+04, -1.930000e+04, -1.790000e+04,
         1.000000e+03,  1.000000e+03,  1.000000e+03,  1.100000e+03,
         4.500000e+03,  1.000000e+03,  2.460000e+04,  1.760000e+04,
         4.313000e+05,  3.200000e+03,  1.600000e+03,  1.049000e+05,
        -2.800000e+03, -7.000000e+02, -2.200000e+03, -2.200000e+03,
        -4.400000e+03, -6.500000e+03,  9.910000e+04, -1.900000e+03,
        -4.800000e+03, -6.500000e+03, -1.730000e+04,  3.500000e+03,
        -3.800000e+03, -4.900000e+03,  1.500000e+03, -6.100000e+03,
        -6.100000e+03, -9.600000e+03,  1.972000e+05,  2.500000e+03,
        -5.500000e+03, -6.900000e+03, -3.100000e+03, -3.900000e+03,
        -3.900000e+03, -3.900000e+03, -3.900000e+03, -7.300000e+03,
         3.200000e+03, -4.800000e+03, -6.500000e+03,  7.000000e+02,
        -1.400000e+03, -3.000000e+03,  2.300000e+03, -5.200000e+03,
         8.240000e+04,  8.240000e+04, -2.900000e+03, -2.900000e+03,
        -2.900000e+03, -1.950000e+04, -2.820000e+04, -5.400000e+03,
         3.000000e+02, -8.600000e+03, -1.380000e+04, -1.820000e+04,
        -1.770000e+04, -2.990000e+04, -1.770000e+04, -2.990000e+04,
        -3.600000e+03,  2.110000e+04,  2.820000e+04,  1.420000e+04,
        -9.000000e+02, -2.600000e+03, -4.120000e+04,  4.000000e+03,
        -3.200000e+03, -4.900000e+03,  1.700000e+03,  3.300000e+03,
         5.600000e+03,  4.000000e+02,  3.106000e+05,  1.280000e+04,
         3.000000e+03,  3.800000e+03,  1.090000e+04, -3.300000e+03,
        -4.800000e+03,  5.121000e+05,  2.400000e+03, -1.000000e+03,
        -1.150000e+04, -1.000000e+04, -1.500000e+04, -2.800000e+03,
        -1.160000e+04, -1.520000e+04, -1.120000e+04, -3.000000e+03,
        -4.800000e+03, -7.000000e+03, -1.200000e+03, -1.200000e+03,
        -6.800000e+03, -2.140000e+04, -1.290000e+04, -3.510000e+04,
        -3.500000e+03, -3.500000e+03, -1.200000e+03, -1.200000e+03,
        -1.900000e+03, -1.200000e+03,  7.000000e+02, -1.200000e+03,
        -4.200000e+03, -4.200000e+03, -4.200000e+03, -4.200000e+03,
        -4.100000e+03,  4.500000e+03,  4.500000e+03,  4.500000e+03,
         2.710000e+04,  7.100000e+03,  2.900000e+03, -2.500000e+03,
        -1.030000e+04, -1.030000e+04, -2.300000e+04, -2.300000e+04,
         7.000000e+02,  1.200000e+03, -2.500000e+03,  5.000000e+02,
         3.000000e+02,  8.890000e+04,  5.200000e+03, -1.500000e+03,
         1.000000e+03, -2.200000e+03,  0.000000e+00,  0.000000e+00,
         8.220000e+04, -8.000000e+02, -2.100000e+03,  9.000000e+02,
         0.000000e+00,  0.000000e+00,  7.300000e+03,  5.800000e+03,
         1.500000e+03,  1.000000e+03, -2.000000e+03,  0.000000e+00,
         6.000000e+02,  2.700000e+03,  5.000000e+02,  3.200000e+03,
         3.200000e+03,  3.900000e+03,  2.600000e+03,  1.520000e+05,
         7.100000e+03,  5.800000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  2.100000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  5.000000e+02,  1.200000e+03,
         7.000000e+02, -4.200000e+03,  0.000000e+00,  3.000000e+02,
        -3.100000e+03, -2.900000e+03, -3.900000e+03, -4.800000e+03,
         1.100000e+03, -1.900000e+03, -1.200000e+03, -3.500000e+03,
         4.500000e+03,  2.900000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -4.200000e+03,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 9.670000e+04, -4.060000e+04, -3.150000e+04,  3.056000e+05,
         2.007000e+05,  4.457000e+05,  2.524000e+05,  9.410000e+04,
        -4.060000e+04,  9.290000e+04, -4.060000e+04,  2.810000e+04,
        -1.530000e+04,  2.250000e+04,  1.251000e+05,  2.570000e+04,
        -3.800000e+03,  1.124000e+05,  9.030000e+04, -1.128000e+05,
        -1.019000e+05,  3.905000e+05,  3.796000e+05, -5.100000e+03,
        -1.926000e+05, -1.915000e+05, -3.277000e+05,  2.653100e+06,
        -2.630000e+04, -2.630000e+04, -2.640000e+04, -2.630000e+04,
         3.700000e+03, -2.630000e+04,  1.227000e+05, -1.491000e+05,
        -1.336000e+05,  4.580000e+04, -2.220000e+04, -1.830000e+04,
         5.059000e+05,  8.020000e+05,  2.288000e+05,  2.288000e+05,
         2.218000e+05,  2.158000e+05,  2.264000e+05,  9.550000e+04,
         5.197000e+05,  4.518000e+05,  4.169000e+05,  3.192000e+05,
         3.264000e+05,  4.310000e+05,  8.126000e+05, -5.650000e+04,
        -5.650000e+04, -1.915000e+05, -1.846000e+05,  3.712000e+05,
         1.162000e+05,  6.970000e+04, -3.970000e+04,  4.580000e+04,
         4.580000e+04,  4.580000e+04,  4.580000e+04, -8.930000e+04,
         4.440000e+04,  1.483000e+05,  8.010000e+04,  1.700000e+03,
        -6.000000e+03, -4.530000e+04,  1.451000e+05, -2.400000e+03,
        -3.540000e+04, -3.540000e+04,  1.251000e+05,  1.251000e+05,
         1.251000e+05,  3.161000e+05, -2.240000e+04,  3.106000e+05,
         4.625000e+05,  2.280000e+04, -1.788000e+05, -1.961000e+05,
         1.111000e+05, -3.616000e+05,  1.111000e+05, -3.612000e+05,
         1.084000e+05,  2.774000e+05,  2.762000e+05,  7.300000e+03,
        -3.500000e+03, -7.140000e+04, -5.192000e+05, -1.670000e+04,
        -1.640000e+04, -8.410000e+04, -2.440000e+04,  1.179000e+05,
         1.755000e+05, -2.690000e+04, -1.680000e+04,  1.751000e+05,
         1.746000e+05,  2.364000e+05,  2.347000e+05,  2.381000e+05,
        -1.029000e+05, -8.400000e+04,  4.160000e+04, -9.410000e+04,
        -1.703000e+05,  1.940000e+04, -1.845000e+05,  1.910000e+04,
        -1.725000e+05, -1.826000e+05,  5.450000e+04, -7.250000e+04,
         2.185000e+05,  2.115000e+05,  1.219000e+05,  1.219000e+05,
        -8.520000e+04, -2.999000e+05,  3.940000e+04,  1.815600e+06,
        -4.670000e+04, -4.680000e+04, -3.890000e+04, -3.890000e+04,
         9.510000e+04, -3.890000e+04, -2.800000e+03, -3.890000e+04,
        -4.870000e+04, -4.870000e+04, -4.870000e+04, -4.870000e+04,
        -4.740000e+04,  4.850000e+04,  4.850000e+04,  4.850000e+04,
         2.911000e+05,  6.090000e+04,  1.100000e+04,  4.763000e+05,
        -2.200000e+03, -2.000000e+03, -1.481000e+05, -1.481000e+05,
         1.900000e+03,  1.714000e+05, -7.600000e+03,  5.780000e+04,
         2.000000e+03, -9.000000e+02,  2.250000e+04,  2.810000e+04,
         5.700000e+03, -7.380000e+04,  0.000000e+00, -3.000000e+02,
        -3.000000e+02,  7.580000e+04, -3.900000e+03,  1.190000e+04,
         0.000000e+00,  0.000000e+00,  9.400000e+04,  2.610000e+04,
         9.200000e+03,  2.510000e+04, -3.800000e+03,  0.000000e+00,
         5.900000e+04,  1.210000e+04,  2.800000e+03,  1.909000e+05,
         1.911000e+05,  9.120000e+04,  1.220000e+04,  7.100000e+03,
         2.978000e+05,  2.054000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  7.900000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  5.780000e+04,  1.714000e+05,
         3.000000e+03, -4.870000e+04,  0.000000e+00,  9.670000e+04,
        -4.060000e+04,  1.251000e+05,  4.580000e+04,  1.483000e+05,
        -2.630000e+04,  9.510000e+04, -3.890000e+04, -4.680000e+04,
         4.850000e+04,  1.100000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -4.870000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-3.060000e+04,  1.309000e+05, -3.010000e+04,  3.259000e+05,
         1.475000e+05, -1.206000e+05, -5.930000e+04, -3.060000e+04,
         1.308000e+05, -3.060000e+04,  1.307000e+05, -3.250000e+04,
         1.910000e+04,  1.220000e+04,  1.416000e+05, -3.250000e+04,
         4.400000e+03, -1.300000e+05, -8.500000e+04,  1.950000e+05,
        -8.230000e+04,  4.305000e+05,  5.852000e+05, -9.950000e+04,
        -2.117000e+05, -2.569000e+05, -4.380000e+04,  2.756100e+06,
        -2.220000e+04, -2.230000e+04, -2.160000e+04, -2.200000e+04,
        -1.900000e+03, -2.230000e+04, -1.409000e+05,  2.325000e+05,
        -1.373000e+05, -2.030000e+04,  7.340000e+04, -1.940000e+04,
         4.731000e+05,  8.469000e+05,  2.614000e+05,  2.614000e+05,
         3.300000e+05,  4.044000e+05,  2.596000e+05,  1.165000e+05,
         5.200000e+05,  6.135000e+05,  9.566000e+05,  3.287000e+05,
         2.896000e+05,  4.678000e+05,  8.576000e+05, -1.421000e+05,
        -1.421000e+05,  3.910000e+04, -1.403000e+05, -5.540000e+04,
         1.205000e+05,  9.880000e+04, -2.640000e+04, -6.500000e+04,
        -6.500000e+04, -6.500000e+04, -6.500000e+04,  9.660000e+04,
        -2.000000e+04,  1.073000e+05,  1.881000e+05,  2.600000e+03,
         6.910000e+04, -4.500000e+03,  1.516000e+05,  2.240000e+04,
        -2.820000e+04, -2.820000e+04,  1.416000e+05,  1.416000e+05,
         1.416000e+05,  8.280000e+04,  4.870000e+05,  1.713000e+05,
         2.297000e+05, -1.264000e+05,  1.165000e+05,  3.256000e+05,
        -2.617000e+05,  3.042000e+05, -2.617000e+05,  3.040000e+05,
        -1.684000e+05, -1.140000e+04,  3.360000e+04,  3.204000e+05,
        -5.470000e+04,  3.880000e+04,  1.081300e+06,  1.120000e+04,
        -3.310000e+04,  6.030000e+04, -1.930000e+04,  1.284000e+05,
         3.900000e+03,  2.519000e+05,  6.700000e+03,  4.830000e+04,
        -2.560000e+04, -8.100000e+04, -3.630000e+04, -1.257000e+05,
         3.865000e+05, -7.650000e+04, -7.520000e+04,  1.118000e+05,
        -1.233000e+05, -1.316000e+05,  1.493000e+05, -8.720000e+04,
        -1.244000e+05,  1.107000e+05, -7.244000e+05, -5.450000e+04,
         2.562000e+05,  3.249000e+05, -6.210000e+04, -6.210000e+04,
         1.792000e+05,  2.301000e+05, -2.374000e+05, -1.077200e+06,
        -3.130000e+04, -3.130000e+04, -9.000000e+02, -9.000000e+02,
         1.160000e+05, -8.000000e+02,  5.480000e+04, -9.000000e+02,
        -3.420000e+04, -3.420000e+04, -3.420000e+04, -3.420000e+04,
        -3.420000e+04,  3.430000e+04,  3.420000e+04,  3.420000e+04,
         2.055000e+05,  6.780000e+04,  3.340000e+04,  5.429000e+05,
         4.770000e+04,  4.800000e+04, -5.470000e+04, -5.470000e+04,
         2.900000e+03,  1.730000e+05, -2.050000e+04,  1.900000e+03,
         4.840000e+04, -3.000000e+02,  1.220000e+04, -3.250000e+04,
         1.419000e+05, -1.900000e+03,  0.000000e+00, -8.000000e+02,
        -1.560000e+04, -1.730000e+04,  7.320000e+04,  7.900000e+03,
         0.000000e+00,  0.000000e+00,  1.420000e+04,  1.075000e+05,
         2.501000e+05,  5.470000e+04,  7.070000e+04,  0.000000e+00,
         1.900000e+03,  6.700000e+03,  7.080000e+04,  1.950000e+05,
         1.952000e+05,  1.130000e+04,  2.896000e+05,  5.800000e+03,
         2.054000e+05,  5.186000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  8.100000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.900000e+03,  1.730000e+05,
         1.600000e+03, -3.420000e+04,  0.000000e+00, -3.060000e+04,
         1.309000e+05,  1.416000e+05, -6.500000e+04,  1.073000e+05,
        -2.200000e+04,  1.160000e+05, -9.000000e+02, -3.130000e+04,
         3.420000e+04,  3.340000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -3.420000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  4.230000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.230000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         8.450000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.230000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  4.230000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.457200e+06,  1.451000e+06,  1.000000e+02,  1.000000e+02,
         1.269700e+06,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.800000e+03,  1.000000e+02,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.451000e+06,  1.584300e+06, -4.200000e+03, -4.200000e+03,
         1.383600e+06,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -4.450000e+04, -4.200000e+03,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.000000e+02, -4.200000e+03,  2.015000e+05,  2.014000e+05,
        -2.100000e+03,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  8.700000e+03,  1.696000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.000000e+02, -4.200000e+03,  2.014000e+05,  2.036000e+05,
        -2.100000e+03,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  8.700000e+03,  1.695000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.269700e+06,  1.383600e+06, -2.100000e+03, -2.100000e+03,
         1.209300e+06,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.340000e+04, -2.100000e+03,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.081870e+07,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.500000e+03,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-1.000000e+02,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.000000e+02, -1.000000e+02,
         0.000000e+00, -1.000000e+02,  0.000000e+00, -1.000000e+02,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.000000e+02,
         0.000000e+00, -3.000000e+02, -3.000000e+02, -2.000000e+02,
        -2.000000e+02, -1.000000e+02,  0.000000e+00, -2.000000e+02,
        -5.000000e+02, -6.000000e+02, -5.000000e+02,  1.500000e+03,
        -1.000000e+02, -1.000000e+02, -1.000000e+02, -1.000000e+02,
         0.000000e+00,  4.000000e+02,  2.000000e+02,  3.000000e+02,
         3.000000e+02,  3.000000e+02,  4.000000e+02,  4.000000e+02,
         0.000000e+00,  1.000000e+02,  1.000000e+02,  1.000000e+02,
         1.000000e+02,  1.000000e+02,  1.000000e+02,  8.000000e+02,
         1.200000e+03,  1.300000e+03,  1.300000e+03,  0.000000e+00,
        -1.000000e+02,  0.000000e+00,  1.000000e+02, -3.000000e+02,
         1.000000e+02, -3.000000e+02, -3.000000e+02,  1.000000e+03,
         0.000000e+00, -1.000000e+02,  0.000000e+00, -2.000000e+02,
        -2.000000e+02, -2.000000e+02, -2.000000e+02, -1.000000e+02,
        -1.000000e+02, -1.000000e+02, -1.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.000000e+02,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  1.000000e+02,  1.000000e+02,
         1.000000e+02,  1.000000e+02,  2.000000e+02,  2.000000e+02,
        -2.000000e+02,  0.000000e+00, -2.000000e+02,  0.000000e+00,
        -1.000000e+02, -3.000000e+02, -2.000000e+02, -2.000000e+02,
         7.000000e+02,  7.000000e+02,  1.500000e+03,  3.000000e+02,
         3.000000e+02,  3.000000e+02,  3.000000e+02,  3.000000e+02,
         3.000000e+02,  4.000000e+02,  4.000000e+02,  3.000000e+02,
         3.000000e+02,  1.400000e+03,  1.500000e+03,  1.300000e+03,
         1.500000e+03,  1.500000e+03,  1.400000e+03,  1.500000e+03,
         2.000000e+02,  1.000000e+02,  2.000000e+02,  2.000000e+02,
         2.000000e+02,  2.000000e+02,  1.000000e+02,  7.000000e+02,
         3.000000e+02,  3.000000e+02,  7.000000e+02,  7.000000e+02,
         7.000000e+02,  2.300000e+03,  2.100000e+03,  1.010000e+04,
        -1.000000e+02, -1.000000e+02, -1.000000e+02, -1.000000e+02,
        -1.000000e+02,  4.000000e+02,  0.000000e+00, -1.000000e+02,
        -1.000000e+02, -1.000000e+02, -1.000000e+02, -1.000000e+02,
        -1.000000e+02,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.000000e+02,  0.000000e+00,  0.000000e+00, -2.000000e+02,
         7.000000e+02,  1.500000e+03,  2.200000e+03,  2.600000e+03,
         4.000000e+02,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.000000e+02,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.000000e+02,  2.000000e+02,  2.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.000000e+02,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  4.000000e+02, -1.000000e+02,
         0.000000e+00,  0.000000e+00, -2.000000e+02, -1.000000e+02,
        -1.000000e+02, -1.000000e+02, -1.000000e+02, -1.000000e+02,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.000000e+02,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-3.000000e+02,  3.000000e+02, -3.900000e+03, -3.100000e+03,
        -1.700000e+03, -1.600000e+03, -9.000000e+02, -3.000000e+02,
         3.000000e+02, -3.000000e+02,  3.000000e+02,  0.000000e+00,
         1.000000e+02, -2.000000e+02, -1.300000e+03,  1.000000e+02,
         0.000000e+00,  2.000000e+02,  0.000000e+00,  9.000000e+02,
        -5.100000e+03, -4.000000e+03, -4.000000e+03,  6.000000e+02,
         2.100000e+03,  2.500000e+03,  2.700000e+03, -2.640000e+04,
         2.000000e+02,  2.000000e+02,  2.000000e+02,  2.000000e+02,
        -1.000000e+02,  2.000000e+02, -3.000000e+02,  8.000000e+02,
        -7.200000e+03, -2.000000e+02,  1.000000e+02, -1.900000e+03,
        -4.800000e+03, -2.900000e+03, -2.400000e+03, -2.400000e+03,
        -2.400000e+03, -2.300000e+03, -4.400000e+03, -1.000000e+03,
        -5.100000e+03, -4.800000e+03, -4.600000e+03, -3.200000e+03,
        -3.000000e+03, -4.400000e+03,  2.100000e+03,  1.000000e+03,
         1.000000e+03,  1.600000e+03, -2.400000e+03, -1.500000e+03,
        -1.100000e+03, -7.000000e+02,  4.000000e+02,  1.000000e+02,
         1.000000e+02,  1.000000e+02,  1.000000e+02,  7.000000e+02,
        -2.000000e+02, -1.200000e+03, -9.000000e+02,  0.000000e+00,
         0.000000e+00,  3.000000e+02, -1.500000e+03,  0.000000e+00,
        -1.300000e+03, -1.300000e+03, -1.300000e+03, -1.300000e+03,
        -1.300000e+03, -1.700000e+03, -2.000000e+02, -2.300000e+03,
        -3.400000e+03,  6.000000e+02,  1.500000e+03,  1.600000e+03,
         1.000000e+03,  3.100000e+03,  1.000000e+03,  3.100000e+03,
         3.000000e+02, -1.600000e+03, -1.900000e+03, -4.000000e+02,
         3.000000e+02,  6.000000e+02,  4.000000e+03,  0.000000e+00,
         3.000000e+02,  6.000000e+02,  2.000000e+02, -1.300000e+03,
        -9.000000e+02,  0.000000e+00, -6.100000e+03, -1.300000e+03,
        -7.000000e+02, -8.000000e+02, -1.100000e+03, -5.000000e+02,
         7.000000e+02, -9.300000e+03,  1.000000e+02,  7.000000e+02,
         1.600000e+03,  7.000000e+02,  1.600000e+03,  4.000000e+02,
         1.600000e+03,  1.600000e+03,  8.000000e+02,  6.000000e+02,
        -2.300000e+03, -2.200000e+03, -3.000000e+02, -3.000000e+02,
         7.000000e+02,  2.400000e+03,  1.000000e+03, -3.000000e+03,
         4.000000e+02,  4.000000e+02,  2.000000e+02,  2.000000e+02,
        -1.000000e+03,  2.000000e+02, -2.000000e+02,  2.000000e+02,
         5.000000e+02,  5.000000e+02,  5.000000e+02,  5.000000e+02,
         4.000000e+02, -5.000000e+02, -5.000000e+02, -5.000000e+02,
        -2.700000e+03, -7.000000e+02, -3.000000e+02,  1.000000e+02,
        -1.000000e+02, -1.000000e+02,  1.200000e+03,  1.200000e+03,
         0.000000e+00, -1.700000e+03,  1.000000e+02, -3.000000e+02,
         0.000000e+00, -1.700000e+03, -2.000000e+02,  0.000000e+00,
        -1.000000e+02,  4.000000e+02,  0.000000e+00,  0.000000e+00,
        -1.600000e+03, -3.000000e+02,  1.000000e+02, -1.000000e+02,
         0.000000e+00,  0.000000e+00, -6.000000e+02, -3.000000e+02,
        -2.000000e+02, -2.000000e+02,  0.000000e+00,  0.000000e+00,
        -3.000000e+02, -1.000000e+02, -1.000000e+02,  3.200000e+03,
         3.200000e+03,  4.700000e+03,  4.900000e+03,  2.100000e+03,
         7.900000e+03,  8.100000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  5.100000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.000000e+02, -1.700000e+03,
         0.000000e+00,  5.000000e+02,  0.000000e+00, -3.000000e+02,
         3.000000e+02, -1.300000e+03,  1.000000e+02, -1.200000e+03,
         2.000000e+02, -1.000000e+03,  2.000000e+02,  4.000000e+02,
        -5.000000e+02, -3.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  5.000000e+02,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  3.050000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.221000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.800000e+03, -4.450000e+04,  8.700000e+03,  8.700000e+03,
        -3.340000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  9.310000e+04,  8.700000e+03,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.000000e+02, -4.200000e+03,  1.696000e+05,  1.695000e+05,
        -2.100000e+03,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  8.700000e+03,  1.708000e+05,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  4.230000e+04,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.590000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.000000e+02,
         1.000000e+02,  1.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.000000e+02,  2.000000e+02,  2.000000e+02,  2.000000e+02,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.000000e+02,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.000000e+02,  1.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02, -5.000000e+02, -5.000000e+02,
         8.740000e+04,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.000000e+02,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.230000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  4.770000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.000000e+02,
        -5.000000e+02,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 9.550000e+04, -1.260000e+04, -1.750000e+04, -1.470000e+04,
         4.050000e+04,  4.478000e+05,  2.566000e+05,  9.730000e+04,
        -1.260000e+04,  9.810000e+04, -1.260000e+04,  3.650000e+04,
        -7.500000e+03,  1.110000e+04, -1.570000e+04,  3.820000e+04,
        -1.500000e+03,  1.460000e+05,  1.284000e+05, -3.290000e+04,
        -4.100000e+04, -3.530000e+04, -4.370000e+04,  6.080000e+04,
        -1.150000e+04,  1.640000e+04, -1.188000e+05, -1.067000e+05,
        -5.300000e+03, -5.300000e+03, -5.200000e+03, -5.500000e+03,
         5.600000e+03, -5.300000e+03,  1.991000e+05, -1.610000e+04,
        -2.690000e+04,  5.060000e+04, -3.500000e+03, -5.900000e+03,
         2.600000e+04, -2.870000e+04, -3.060000e+04, -3.060000e+04,
        -3.470000e+04, -3.880000e+04, -3.720000e+04, -2.080000e+04,
        -1.110000e+04, -6.500000e+04, -8.530000e+04, -3.400000e+03,
         2.460000e+04, -3.030000e+04, -2.930000e+04,  5.150000e+04,
         5.150000e+04, -5.610000e+04, -6.150000e+04,  3.873000e+05,
        -1.470000e+04, -3.230000e+04, -1.300000e+04,  7.820000e+04,
         7.820000e+04,  7.810000e+04,  7.820000e+04, -2.900000e+04,
         5.040000e+04,  2.320000e+04, -3.070000e+04,  3.000000e+02,
        -3.700000e+03, -3.350000e+04, -4.400000e+03, -2.660000e+04,
        -1.490000e+04, -1.490000e+04, -1.570000e+04, -1.570000e+04,
        -1.570000e+04,  1.468000e+05, -1.213000e+05,  9.130000e+04,
         1.703000e+05,  1.009000e+05, -5.930000e+04, -6.770000e+04,
         2.568000e+05, -1.183000e+05,  2.568000e+05, -1.179000e+05,
         2.019000e+05,  2.359000e+05,  2.081000e+05,  2.130000e+04,
         3.370000e+04, -2.030000e+04, -1.648000e+05, -1.910000e+04,
         8.900000e+03, -4.490000e+04, -5.000000e+03, -9.600000e+03,
         1.359000e+05, -2.460000e+04, -3.360000e+04,  1.080000e+05,
         1.533000e+05,  2.409000e+05,  2.130000e+05,  2.689000e+05,
        -2.880000e+04, -4.150000e+04,  8.370000e+04, -2.420000e+04,
        -5.380000e+04,  1.004000e+05, -6.190000e+04,  7.250000e+04,
        -5.440000e+04, -5.990000e+04,  1.085000e+05, -2.100000e+04,
        -3.620000e+04, -4.030000e+04,  1.301000e+05,  1.301000e+05,
        -2.720000e+04, -1.044000e+05,  1.654000e+05,  2.119700e+06,
        -1.600000e+04, -1.610000e+04, -3.010000e+04, -3.020000e+04,
        -2.070000e+04, -3.020000e+04, -3.860000e+04, -3.020000e+04,
        -1.640000e+04, -1.640000e+04, -1.640000e+04, -1.640000e+04,
        -1.740000e+04,  1.650000e+04,  1.650000e+04,  1.650000e+04,
         9.890000e+04,  3.700000e+03, -1.320000e+04, -6.160000e+04,
        -5.350000e+04, -5.350000e+04, -1.027000e+05, -1.027000e+05,
         3.000000e+02, -3.000000e+02,  7.000000e+02,  6.660000e+04,
         1.400000e+03,  2.300000e+03,  1.110000e+04,  3.650000e+04,
         3.200000e+03, -5.650000e+04,  0.000000e+00,  0.000000e+00,
        -3.000000e+02,  5.860000e+04,  2.300000e+03,  3.900000e+03,
         0.000000e+00,  0.000000e+00,  6.760000e+04,  1.280000e+04,
         4.900000e+03,  1.900000e+04,  2.200000e+03,  0.000000e+00,
         6.560000e+04,  5.800000e+03,  1.600000e+03,  5.000000e+02,
         5.000000e+02,  5.760000e+04,  1.500000e+03,  5.000000e+02,
         5.780000e+04,  1.900000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -3.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.131000e+05, -3.000000e+02,
         1.500000e+03, -1.640000e+04,  0.000000e+00,  9.550000e+04,
        -1.260000e+04, -1.570000e+04,  7.820000e+04,  2.320000e+04,
        -5.500000e+03, -2.070000e+04, -3.020000e+04, -1.610000e+04,
         1.650000e+04, -1.320000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.640000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-2.180000e+04, -2.380000e+04, -1.580000e+04,  3.142000e+05,
         1.470000e+05, -8.710000e+04, -4.350000e+04, -2.230000e+04,
        -2.380000e+04, -2.250000e+04, -2.380000e+04, -2.370000e+04,
        -9.600000e+03,  8.000000e+03,  1.405000e+05, -2.420000e+04,
        -2.300000e+03, -9.470000e+04, -6.580000e+04, -6.920000e+04,
        -5.650000e+04,  4.214000e+05,  4.219000e+05, -7.640000e+04,
        -1.714000e+05, -2.039000e+05, -1.736000e+05,  2.699300e+06,
        -1.930000e+04, -1.940000e+04, -1.940000e+04, -1.920000e+04,
        -3.600000e+03, -1.940000e+04, -1.220000e+05, -1.267000e+05,
        -1.097000e+05, -1.660000e+04, -1.750000e+04, -1.350000e+04,
         4.615000e+05,  8.030000e+05,  2.585000e+05,  2.585000e+05,
         2.570000e+05,  2.567000e+05,  2.621000e+05,  1.175000e+05,
         5.173000e+05,  5.163000e+05,  5.089000e+05,  3.131000e+05,
         2.882000e+05,  4.551000e+05,  8.027000e+05, -1.152000e+05,
        -1.151000e+05, -1.175000e+05, -1.090000e+05, -4.340000e+04,
         1.302000e+05,  1.073000e+05, -2.080000e+04, -4.910000e+04,
        -4.910000e+04, -4.910000e+04, -4.910000e+04, -5.120000e+04,
        -1.670000e+04,  1.146000e+05,  1.136000e+05,  1.500000e+03,
        -8.000000e+02, -3.700000e+03,  1.458000e+05,  2.970000e+04,
        -1.920000e+04, -1.920000e+04,  1.405000e+05,  1.405000e+05,
         1.405000e+05,  1.282000e+05,  1.231000e+05,  1.913000e+05,
         2.402000e+05, -9.780000e+04, -1.005000e+05, -1.066000e+05,
        -1.990000e+05, -2.063000e+05, -1.990000e+05, -2.065000e+05,
        -1.340000e+05, -1.240000e+04,  2.000000e+04, -1.660000e+04,
        -4.380000e+04, -4.480000e+04, -3.018000e+05,  6.400000e+03,
        -2.610000e+04, -2.730000e+04, -1.760000e+04,  1.255000e+05,
         6.800000e+03,  3.800000e+03,  1.600000e+04,  3.930000e+04,
        -1.720000e+04, -6.010000e+04, -2.780000e+04, -9.250000e+04,
        -6.510000e+04, -4.480000e+04, -6.030000e+04, -6.230000e+04,
        -1.002000e+05, -1.008000e+05, -1.035000e+05, -6.830000e+04,
        -1.014000e+05, -1.041000e+05, -1.013000e+05, -4.520000e+04,
         2.556000e+05,  2.541000e+05, -4.480000e+04, -4.480000e+04,
        -4.940000e+04, -1.639000e+05, -1.589000e+05, -7.943000e+05,
        -2.550000e+04, -2.550000e+04, -1.500000e+03, -1.500000e+03,
         1.170000e+05, -1.500000e+03,  4.370000e+04, -1.500000e+03,
        -2.740000e+04, -2.740000e+04, -2.740000e+04, -2.730000e+04,
        -2.710000e+04,  2.640000e+04,  2.640000e+04,  2.640000e+04,
         1.583000e+05,  5.320000e+04,  2.580000e+04,  5.248000e+05,
         6.250000e+04,  6.270000e+04, -1.930000e+04, -1.920000e+04,
         1.800000e+03,  2.191000e+05, -8.100000e+03, -3.000000e+02,
         1.000000e+03,  2.200000e+03,  8.000000e+03, -2.370000e+04,
         1.800000e+03, -2.800000e+03,  0.000000e+00, -3.000000e+02,
        -1.800000e+03, -5.800000e+03, -6.500000e+03,  6.200000e+03,
         0.000000e+00,  0.000000e+00,  1.040000e+04,  9.600000e+03,
         3.300000e+03,  1.400000e+03, -6.200000e+03,  0.000000e+00,
         0.000000e+00,  4.500000e+03,  9.000000e+02,  1.738000e+05,
         1.737000e+05,  6.000000e+02, -3.000000e+02,  1.200000e+03,
         1.714000e+05,  1.730000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.700000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.000000e+02,  2.436000e+05,
         1.100000e+03, -2.740000e+04,  0.000000e+00, -2.180000e+04,
        -2.380000e+04,  1.405000e+05, -4.910000e+04,  1.146000e+05,
        -1.930000e+04,  1.170000e+05, -1.500000e+03, -2.550000e+04,
         2.640000e+04,  2.580000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -2.740000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-6.200000e+03, -9.000000e+03, -7.000000e+03, -8.500000e+03,
        -7.300000e+03, -2.340000e+04, -1.100000e+04, -6.300000e+03,
        -9.000000e+03, -6.400000e+03, -9.000000e+03, -8.200000e+03,
        -3.800000e+03,  6.560000e+04, -9.500000e+03, -8.400000e+03,
        -9.000000e+02, -3.290000e+04,  4.030000e+04,  3.510000e+04,
         3.890000e+04,  3.580000e+04, -2.700000e+04, -2.720000e+04,
         5.930000e+04, -1.440000e+04,  5.630000e+04,  1.885000e+05,
         5.480000e+04,  5.480000e+04,  5.470000e+04,  5.500000e+04,
         7.670000e+04,  5.480000e+04,  5.189000e+05,  5.115000e+05,
         5.170000e+05,  5.700000e+04,  5.530000e+04,  5.650000e+04,
        -1.580000e+04, -1.600000e+04,  6.740000e+04,  6.740000e+04,
         3.570000e+04,  4.200000e+03,  3.680000e+04,  4.470000e+04,
         1.046000e+05,  1.029000e+05, -5.550000e+04,  5.640000e+04,
        -1.680000e+04, -1.800000e+04, -1.600000e+04,  8.180000e+04,
         8.180000e+04,  7.870000e+04,  8.090000e+04, -7.900000e+03,
        -9.500000e+03, -2.010000e+04, -8.100000e+03, -1.670000e+04,
        -1.670000e+04, -1.670000e+04, -1.670000e+04, -1.970000e+04,
         5.690000e+04, -1.780000e+04, -1.920000e+04,  1.300000e+03,
        -3.050000e+04, -3.240000e+04,  5.560000e+04,  1.130000e+04,
        -7.800000e+03, -7.800000e+03, -9.500000e+03, -9.500000e+03,
        -9.500000e+03, -7.140000e+04, -7.870000e+04,  7.560000e+04,
         3.400000e+04, -3.310000e+04, -3.740000e+04, -1.018000e+05,
        -6.910000e+04, -7.940000e+04, -6.910000e+04, -7.950000e+04,
         7.750000e+04,  2.487000e+05,  3.223000e+05,  2.427000e+05,
         4.650000e+04,  4.480000e+04, -1.138000e+05,  6.430000e+04,
        -9.600000e+03, -1.140000e+04,  5.620000e+04,  1.102000e+05,
         5.700000e+03,  1.200000e+03,  4.300000e+03,  7.960000e+04,
        -2.900000e+03,  4.450000e+04,  1.182000e+05, -2.920000e+04,
         3.610000e+04,  4.220000e+04,  1.036000e+05,  1.003000e+05,
         2.250000e+04, -3.570000e+04, -4.060000e+04,  3.820000e+04,
         2.270000e+04, -4.020000e+04, -3.610000e+04,  4.360000e+04,
         3.490000e+04,  3.200000e+03, -1.420000e+04, -1.420000e+04,
        -1.880000e+04, -1.740000e+04, -9.000000e+03, -2.546000e+05,
        -9.300000e+03, -9.300000e+03, -1.300000e+03, -1.300000e+03,
         4.460000e+04, -1.300000e+03, -4.670000e+04, -1.300000e+03,
        -1.070000e+04, -1.070000e+04, -1.070000e+04, -1.070000e+04,
        -1.060000e+04,  1.100000e+04,  1.100000e+04,  1.100000e+04,
         6.610000e+04,  1.990000e+04,  9.300000e+03,  1.349000e+05,
         2.330000e+04,  2.330000e+04, -8.800000e+03, -8.800000e+03,
         1.400000e+03,  1.100000e+03,  4.000000e+02,  1.500000e+03,
         5.000000e+02,  7.000000e+02,  6.560000e+04, -8.200000e+03,
         1.600000e+03, -2.100000e+03,  0.000000e+00,  0.000000e+00,
         1.800000e+03,  2.400000e+03,  1.000000e+03,  2.400000e+03,
         0.000000e+00,  0.000000e+00,  6.730000e+04,  6.610000e+04,
         2.200000e+03,  1.200000e+03,  1.000000e+03,  0.000000e+00,
         1.500000e+03,  3.260000e+04,  8.000000e+02,  1.000000e+03,
         1.000000e+03,  2.000000e+03,  6.000000e+02,  7.000000e+02,
         3.000000e+03,  1.600000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  1.500000e+03,  1.100000e+03,
         9.265000e+05, -1.070000e+04,  0.000000e+00, -6.200000e+03,
        -9.000000e+03, -9.500000e+03, -1.670000e+04, -1.780000e+04,
         5.500000e+04,  4.460000e+04, -1.300000e+03, -9.300000e+03,
         1.100000e+04,  9.300000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.070000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.740000e+04,  4.990000e+04,  4.090000e+04,  6.700000e+03,
         1.210000e+04,  5.290000e+04,  1.800000e+04,  1.860000e+04,
         4.990000e+04,  1.920000e+04,  4.990000e+04,  3.910000e+04,
         2.160000e+04, -8.150000e+04,  3.490000e+04,  4.040000e+04,
         5.100000e+03,  1.564000e+05,  4.070000e+04,  9.320000e+04,
         7.730000e+04,  2.300000e+04,  9.090000e+04,  1.449000e+05,
         2.593000e+05,  3.810000e+05,  2.936000e+05,  9.720000e+04,
        -1.610000e+04, -1.610000e+04, -1.590000e+04, -1.650000e+04,
        -6.930000e+04, -1.610000e+04, -3.414000e+05, -2.717000e+05,
        -2.926000e+05, -4.010000e+04, -2.360000e+04, -2.790000e+04,
         1.900000e+04, -1.420000e+04,  1.270000e+04,  1.270000e+04,
         4.670000e+04,  8.060000e+04,  4.110000e+04,  1.870000e+04,
         4.190000e+04,  5.890000e+04,  2.287000e+05, -7.650000e+04,
         4.700000e+04,  4.170000e+04, -1.380000e+04,  1.149000e+05,
         1.149000e+05,  1.497000e+05,  1.393000e+05, -1.620000e+04,
         3.440000e+04,  9.800000e+04,  4.940000e+04,  8.120000e+04,
         8.120000e+04,  8.120000e+04,  8.120000e+04,  1.153000e+05,
        -4.030000e+04,  7.500000e+04,  9.160000e+04, -1.040000e+04,
         2.290000e+04,  4.180000e+04, -4.660000e+04,  7.460000e+04,
         4.720000e+04,  4.720000e+04,  3.490000e+04,  3.490000e+04,
         3.490000e+04,  3.365000e+05,  4.216000e+05,  9.320000e+04,
         1.660000e+04,  1.655000e+05,  2.160000e+05,  2.857000e+05,
         3.489000e+05,  4.684000e+05,  3.489000e+05,  4.691000e+05,
         1.064000e+05, -2.898000e+05, -4.113000e+05, -2.212000e+05,
         2.430000e+04,  4.120000e+04,  6.515000e+05, -6.810000e+04,
         5.400000e+04,  7.160000e+04, -2.720000e+04, -6.280000e+04,
        -6.080000e+04, -9.600000e+03, -2.420000e+04, -1.829000e+05,
        -1.530000e+04, -6.400000e+03, -1.281000e+05,  1.154000e+05,
         7.850000e+04,  5.460000e+04, -1.690000e+04,  1.700000e+04,
         1.781000e+05,  1.864000e+05,  2.360000e+05,  6.460000e+04,
         1.803000e+05,  2.384000e+05,  1.946000e+05,  4.700000e+04,
         5.350000e+04,  8.750000e+04,  5.550000e+04,  5.550000e+04,
         1.075000e+05,  3.332000e+05,  2.483000e+05,  1.056600e+06,
         5.420000e+04,  5.420000e+04,  1.350000e+04,  1.350000e+04,
         1.870000e+04,  1.340000e+04, -2.230000e+04,  1.350000e+04,
         6.540000e+04,  6.550000e+04,  6.550000e+04,  6.540000e+04,
         6.460000e+04, -7.030000e+04, -7.030000e+04, -7.030000e+04,
        -4.217000e+05, -1.154000e+05, -5.100000e+04,  2.830000e+04,
         1.495000e+05,  1.494000e+05,  3.456000e+05,  3.455000e+05,
        -1.120000e+04, -2.740000e+04, -7.000000e+02, -1.640000e+04,
        -4.300000e+03, -3.800000e+03, -8.150000e+04,  3.910000e+04,
        -1.370000e+04,  2.310000e+04,  0.000000e+00,  0.000000e+00,
        -1.060000e+04, -2.230000e+04, -7.800000e+03, -1.490000e+04,
         0.000000e+00,  0.000000e+00, -1.043000e+05, -8.860000e+04,
        -2.090000e+04, -1.200000e+04, -7.500000e+03,  0.000000e+00,
        -1.690000e+04, -4.160000e+04, -6.800000e+03, -2.770000e+04,
        -2.770000e+04, -2.110000e+04, -6.500000e+03, -4.200000e+03,
        -4.870000e+04, -3.420000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02,  5.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.640000e+04, -2.740000e+04,
        -1.070000e+04,  6.620000e+04, -1.000000e+02,  1.740000e+04,
         4.990000e+04,  3.490000e+04,  8.120000e+04,  7.500000e+04,
        -1.640000e+04,  1.870000e+04,  1.350000e+04,  5.420000e+04,
        -7.030000e+04, -5.100000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  6.540000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-1.000000e+02,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.000000e+02, -1.000000e+02,
         0.000000e+00, -1.000000e+02,  0.000000e+00, -1.000000e+02,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.000000e+02,
         0.000000e+00, -3.000000e+02, -3.000000e+02, -2.000000e+02,
        -2.000000e+02, -1.000000e+02,  0.000000e+00, -2.000000e+02,
        -5.000000e+02, -6.000000e+02, -5.000000e+02,  1.500000e+03,
        -1.000000e+02, -1.000000e+02, -1.000000e+02, -1.000000e+02,
         0.000000e+00,  4.000000e+02,  2.000000e+02,  3.000000e+02,
         3.000000e+02,  3.000000e+02,  4.000000e+02,  4.000000e+02,
         0.000000e+00,  1.000000e+02,  1.000000e+02,  1.000000e+02,
         1.000000e+02,  1.000000e+02,  1.000000e+02,  8.000000e+02,
         1.200000e+03,  1.300000e+03,  1.300000e+03,  0.000000e+00,
        -1.000000e+02,  0.000000e+00,  1.000000e+02, -3.000000e+02,
         1.000000e+02, -3.000000e+02, -3.000000e+02,  1.000000e+03,
         0.000000e+00, -1.000000e+02,  0.000000e+00, -2.000000e+02,
        -2.000000e+02, -2.000000e+02, -2.000000e+02, -1.000000e+02,
        -1.000000e+02, -1.000000e+02, -1.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.000000e+02,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  1.000000e+02,  1.000000e+02,
         1.000000e+02,  1.000000e+02,  2.000000e+02,  2.000000e+02,
        -2.000000e+02,  0.000000e+00, -2.000000e+02,  0.000000e+00,
        -1.000000e+02, -3.000000e+02, -2.000000e+02, -2.000000e+02,
         7.000000e+02,  7.000000e+02,  1.500000e+03,  3.000000e+02,
         3.000000e+02,  3.000000e+02,  3.000000e+02,  3.000000e+02,
         3.000000e+02,  4.000000e+02,  4.000000e+02,  3.000000e+02,
         3.000000e+02,  1.400000e+03,  1.500000e+03,  1.300000e+03,
         1.500000e+03,  1.500000e+03,  1.400000e+03,  1.500000e+03,
         2.000000e+02,  1.000000e+02,  2.000000e+02,  2.000000e+02,
         2.000000e+02,  2.000000e+02,  1.000000e+02,  7.000000e+02,
         3.000000e+02,  3.000000e+02,  7.000000e+02,  7.000000e+02,
         7.000000e+02,  2.300000e+03,  2.100000e+03,  1.010000e+04,
        -1.000000e+02, -1.000000e+02, -1.000000e+02, -1.000000e+02,
        -1.000000e+02,  4.000000e+02,  0.000000e+00, -1.000000e+02,
        -1.000000e+02, -1.000000e+02, -1.000000e+02, -1.000000e+02,
        -1.000000e+02,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         1.000000e+02,  0.000000e+00,  0.000000e+00, -2.000000e+02,
         7.000000e+02,  1.500000e+03,  2.200000e+03,  2.600000e+03,
         4.000000e+02,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.000000e+02,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.000000e+02,  2.000000e+02,  2.000000e+02,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         4.000000e+02,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.000000e+02,  6.000000e+02, -1.000000e+02,
         0.000000e+00,  0.000000e+00, -2.000000e+02, -1.000000e+02,
        -1.000000e+02, -1.000000e+02, -1.000000e+02, -1.000000e+02,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.000000e+02,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 2.862000e+05,  1.300000e+04,  3.520000e+04, -3.620000e+04,
         1.244000e+05,  1.243300e+06,  6.711000e+05,  2.796000e+05,
         1.300000e+04,  2.766000e+05,  1.300000e+04,  1.627000e+05,
         1.220000e+04, -4.740000e+04, -9.200000e+03,  1.564000e+05,
         2.000000e+03,  6.507000e+05,  4.026000e+05, -2.600000e+03,
         2.530000e+04, -7.440000e+04, -3.190000e+04,  3.162000e+05,
         2.188000e+05,  4.184000e+05, -5.130000e+04, -1.809000e+05,
        -3.010000e+04, -3.010000e+04, -3.040000e+04, -2.990000e+04,
        -5.060000e+04, -3.020000e+04,  2.345000e+05, -3.076000e+05,
        -2.685000e+05,  1.033000e+05, -3.260000e+04, -2.250000e+04,
         8.790000e+04, -1.000000e+05, -7.210000e+04, -7.210000e+04,
        -5.040000e+04, -2.900000e+04, -4.120000e+04, -3.940000e+04,
         1.300000e+04, -1.226000e+05, -1.450000e+04, -8.270000e+04,
         1.150000e+05, -4.540000e+04, -1.000000e+05,  2.554000e+05,
         2.553000e+05, -1.330000e+04,  3.900000e+03,  8.704000e+05,
        -8.500000e+03,  8.700000e+03,  1.550000e+04,  3.012000e+05,
         3.012000e+05,  3.012000e+05,  3.012000e+05,  3.050000e+04,
         1.011000e+05,  1.429000e+05,  6.800000e+03, -8.900000e+03,
         1.230000e+04, -5.110000e+04, -5.640000e+04, -2.400000e+03,
         2.290000e+04,  2.290000e+04, -9.200000e+03, -9.200000e+03,
        -9.200000e+03,  7.539000e+05,  7.660000e+04,  3.532000e+05,
         4.998000e+05,  4.497000e+05,  4.420000e+04,  8.690000e+04,
         1.070100e+06,  1.227000e+05,  1.070100e+06,  1.240000e+05,
         6.678000e+05,  3.717000e+05,  1.720000e+05, -1.688000e+05,
         1.198000e+05, -1.570000e+04,  1.687000e+05, -1.201000e+05,
         7.760000e+04, -5.750000e+04, -3.950000e+04, -8.680000e+04,
         3.262000e+05, -7.920000e+04, -5.110000e+04,  1.285000e+05,
         4.147000e+05,  6.713000e+05,  4.711000e+05,  8.715000e+05,
        -6.300000e+03,  4.250000e+04,  2.222000e+05, -4.880000e+04,
         2.200000e+04,  4.676000e+05,  6.000000e+04,  2.699000e+05,
         2.180000e+04,  6.310000e+04,  4.475000e+05, -1.290000e+04,
        -4.820000e+04, -2.660000e+04,  4.398000e+05,  4.397000e+05,
         2.810000e+04,  2.930000e+04,  7.069000e+05,  7.017400e+06,
         8.000000e+03,  8.000000e+03, -7.230000e+04, -7.240000e+04,
        -3.920000e+04, -7.250000e+04, -1.320000e+05, -7.240000e+04,
         1.740000e+04,  1.740000e+04,  1.740000e+04,  1.740000e+04,
         2.090000e+04, -2.330000e+04, -2.330000e+04, -2.330000e+04,
        -1.396000e+05, -1.046000e+05, -8.850000e+04, -1.449000e+05,
        -4.500000e+03, -4.700000e+03,  4.740000e+04,  4.730000e+04,
        -9.500000e+03, -2.180000e+04,  6.000000e+02,  9.550000e+04,
        -2.300000e+03, -5.200000e+03, -4.740000e+04,  1.627000e+05,
        -4.300000e+03, -1.356000e+05,  0.000000e+00,  0.000000e+00,
         6.200000e+03,  1.259000e+05, -1.700000e+03, -4.600000e+03,
         0.000000e+00,  0.000000e+00,  8.430000e+04, -5.010000e+04,
        -6.800000e+03,  4.190000e+04, -1.600000e+03,  0.000000e+00,
         9.860000e+04, -2.390000e+04, -2.200000e+03, -2.720000e+04,
        -2.720000e+04,  1.249000e+05, -3.200000e+03,  3.000000e+02,
         9.670000e+04, -3.060000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02, -3.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  9.550000e+04, -2.180000e+04,
        -6.200000e+03,  1.740000e+04, -1.000000e+02,  3.169000e+05,
         1.300000e+04, -9.200000e+03,  3.012000e+05,  1.429000e+05,
        -2.990000e+04, -3.920000e+04, -7.240000e+04,  8.000000e+03,
        -2.330000e+04, -8.850000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.740000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.300000e+04,  4.066000e+05,  3.180000e+04, -1.400000e+03,
         5.900000e+03,  3.920000e+04,  1.310000e+04,  1.390000e+04,
         4.066000e+05,  1.430000e+04,  4.063000e+05,  2.960000e+04,
         8.930000e+04, -6.830000e+04,  2.320000e+04,  3.060000e+04,
         2.070000e+04,  1.182000e+05,  2.320000e+04,  5.350000e+05,
         5.460000e+04,  9.000000e+02,  3.689000e+05,  1.091000e+05,
         1.844000e+05,  2.835000e+05,  5.663000e+05, -2.640000e+04,
        -1.850000e+04, -1.850000e+04, -1.800000e+04, -1.900000e+04,
        -6.070000e+04, -1.860000e+04, -3.185000e+05,  3.636000e+05,
        -2.766000e+05, -3.720000e+04,  1.326000e+05, -2.670000e+04,
         4.500000e+03, -2.710000e+04, -6.400000e+03, -6.500000e+03,
         1.810000e+05,  3.662000e+05,  1.880000e+04,  4.600000e+03,
         2.300000e+03,  1.725000e+05,  1.110000e+06, -7.150000e+04,
         2.900000e+04,  2.180000e+04, -2.690000e+04,  7.340000e+04,
         7.340000e+04,  4.267000e+05,  9.440000e+04, -1.320000e+04,
         2.800000e+03,  7.090000e+04,  3.770000e+04,  6.110000e+04,
         6.110000e+04,  6.110000e+04,  6.110000e+04,  4.564000e+05,
        -3.760000e+04,  5.350000e+04,  2.507000e+05, -7.900000e+03,
         1.798000e+05,  3.510000e+04, -4.520000e+04,  5.230000e+04,
         3.620000e+04,  3.620000e+04,  2.320000e+04,  2.310000e+04,
         2.320000e+04,  2.480000e+05,  1.236000e+06,  5.030000e+04,
        -4.000000e+02,  1.249000e+05,  7.173000e+05,  1.028200e+06,
         2.631000e+05,  1.646800e+06,  2.631000e+05,  1.647400e+06,
         6.440000e+04, -2.478000e+05, -3.464000e+05,  5.247000e+05,
         1.180000e+04,  1.819000e+05,  3.623600e+06, -5.790000e+04,
         4.100000e+04,  2.116000e+05, -2.700000e+04, -6.380000e+04,
        -4.730000e+04,  5.343000e+05, -1.590000e+04, -1.462000e+05,
        -1.130000e+04, -1.270000e+04, -1.116000e+05,  8.610000e+04,
         8.380000e+05,  3.960000e+04, -2.640000e+04,  3.139000e+05,
         1.297000e+05,  1.408000e+05,  6.501000e+05,  4.200000e+04,
         1.316000e+05,  7.346000e+05,  2.204000e+05,  2.970000e+04,
         2.770000e+04,  2.152000e+05,  4.180000e+04,  4.180000e+04,
         6.347000e+05,  1.103100e+06,  2.524000e+05,  7.947000e+05,
         4.120000e+04,  4.130000e+04,  1.050000e+04,  1.050000e+04,
         4.700000e+03,  1.040000e+04, -1.040000e+04,  1.050000e+04,
         4.990000e+04,  4.990000e+04,  4.990000e+04,  4.990000e+04,
         4.950000e+04, -5.300000e+04, -5.290000e+04, -5.290000e+04,
        -3.178000e+05, -8.720000e+04, -3.830000e+04, -1.020000e+04,
         1.044000e+05,  1.043000e+05,  2.540000e+05,  2.539000e+05,
        -8.700000e+03, -2.380000e+04, -2.100000e+04, -1.260000e+04,
         1.047000e+05, -2.800000e+03, -6.830000e+04,  2.960000e+04,
         3.090000e+05,  1.750000e+04,  0.000000e+00, -2.200000e+03,
        -2.620000e+04, -3.770000e+04,  1.278000e+05, -1.130000e+04,
         0.000000e+00,  0.000000e+00, -8.600000e+04,  8.290000e+04,
         4.653000e+05,  8.670000e+04,  1.235000e+05,  0.000000e+00,
        -1.300000e+04, -3.480000e+04,  1.542000e+05, -2.430000e+04,
        -2.430000e+04, -1.640000e+04,  1.550000e+05, -3.100000e+03,
        -4.060000e+04,  1.309000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  3.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.260000e+04, -2.380000e+04,
        -9.000000e+03,  4.990000e+04,  0.000000e+00,  1.300000e+04,
         4.462000e+05,  2.310000e+04,  6.110000e+04,  5.350000e+04,
        -1.890000e+04,  4.700000e+03,  1.050000e+04,  4.130000e+04,
        -5.290000e+04, -3.830000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  4.990000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-9.200000e+03,  2.310000e+04,  2.190000e+04,  3.436000e+05,
         1.668000e+05, -5.280000e+04, -3.450000e+04, -8.100000e+03,
         2.310000e+04, -7.600000e+03,  2.310000e+04,  1.100000e+04,
         1.050000e+04, -7.250000e+04,  1.944000e+05,  1.210000e+04,
         2.500000e+03,  4.410000e+04, -3.330000e+04,  1.630000e+04,
         1.480000e+04,  4.963000e+05,  5.696000e+05,  6.120000e+04,
         6.760000e+04,  1.530000e+05,  9.980000e+04,  3.133300e+06,
        -3.760000e+04, -3.760000e+04, -3.750000e+04, -3.760000e+04,
        -7.310000e+04, -3.760000e+04, -4.781000e+05, -4.120000e+05,
        -4.139000e+05, -5.950000e+04, -4.300000e+04, -4.350000e+04,
         5.121000e+05,  8.380000e+05,  3.015000e+05,  3.015000e+05,
         3.351000e+05,  3.707000e+05,  3.358000e+05,  1.500000e+05,
         6.205000e+05,  6.370000e+05,  8.049000e+05,  2.688000e+05,
         3.590000e+05,  5.383000e+05,  8.357000e+05, -1.390000e+04,
        -1.390000e+04,  1.870000e+04,  1.820000e+04, -6.720000e+04,
         1.746000e+05,  2.395000e+05,  2.670000e+04,  2.600000e+04,
         2.600000e+04,  2.600000e+04,  2.600000e+04,  5.800000e+04,
        -5.930000e+04,  2.057000e+05,  2.219000e+05, -8.200000e+03,
         2.320000e+04,  3.900000e+04,  1.170000e+05,  1.062000e+05,
         2.520000e+04,  2.520000e+04,  1.944000e+05,  1.948000e+05,
         1.944000e+05,  4.851000e+05,  5.657000e+05,  3.108000e+05,
         2.834000e+05,  5.740000e+04,  1.055000e+05,  1.691000e+05,
         1.258000e+05,  2.379000e+05,  1.258000e+05,  2.380000e+05,
        -4.400000e+04, -3.070000e+05, -3.923000e+05, -2.427000e+05,
        -2.470000e+04, -8.200000e+03,  3.134000e+05, -6.070000e+04,
         2.490000e+04,  4.140000e+04, -4.580000e+04,  7.730000e+04,
        -5.310000e+04, -5.600000e+03, -5.000000e+03, -1.387000e+05,
        -3.980000e+04, -7.740000e+04, -1.627000e+05,  7.800000e+03,
         5.000000e+03,  2.800000e+03, -8.420000e+04, -5.120000e+04,
         6.640000e+04,  7.380000e+04,  1.232000e+05, -1.170000e+04,
         6.710000e+04,  1.219000e+05,  7.110000e+04, -3.400000e+03,
         3.400000e+05,  3.736000e+05,  2.100000e+03,  2.100000e+03,
         5.210000e+04,  1.502000e+05,  6.780000e+04,  1.304000e+05,
         2.660000e+04,  2.670000e+04,  1.180000e+04,  1.180000e+04,
         1.488000e+05,  1.180000e+04,  2.630000e+04,  1.180000e+04,
         3.490000e+04,  3.490000e+04,  3.490000e+04,  3.490000e+04,
         3.430000e+04, -4.280000e+04, -4.280000e+04, -4.280000e+04,
        -2.570000e+05, -5.820000e+04, -2.320000e+04,  5.949000e+05,
         2.190000e+05,  2.193000e+05,  3.240000e+05,  3.240000e+05,
        -8.200000e+03,  1.405000e+05, -9.400000e+03, -1.570000e+04,
        -3.300000e+03, -1.200000e+03, -7.250000e+04,  1.100000e+04,
        -1.180000e+04,  2.220000e+04,  0.000000e+00, -3.000000e+02,
        -1.230000e+04, -3.190000e+04, -1.460000e+04, -8.000000e+03,
         0.000000e+00,  0.000000e+00, -9.430000e+04, -7.780000e+04,
        -1.740000e+04, -1.080000e+04, -1.420000e+04,  0.000000e+00,
        -1.620000e+04, -3.650000e+04, -5.900000e+03,  1.483000e+05,
         1.483000e+05, -2.370000e+04, -6.800000e+03, -2.900000e+03,
         1.251000e+05,  1.416000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -1.300000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -1.570000e+04,  1.405000e+05,
        -9.500000e+03,  3.490000e+04,  0.000000e+00, -9.200000e+03,
         2.310000e+04,  2.296000e+05,  2.600000e+04,  2.057000e+05,
        -3.760000e+04,  1.488000e+05,  1.180000e+04,  2.670000e+04,
        -4.280000e+04, -2.320000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  3.490000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 3.012000e+05,  6.110000e+04,  7.520000e+04, -2.990000e+04,
         1.351000e+05,  1.285000e+06,  6.827000e+05,  2.962000e+05,
         6.110000e+04,  2.938000e+05,  6.110000e+04,  2.006000e+05,
         3.330000e+04, -1.274000e+05,  2.600000e+04,  1.954000e+05,
         7.000000e+03,  8.024000e+05,  4.550000e+05,  8.940000e+04,
         1.160000e+05, -4.820000e+04,  6.000000e+04,  4.769000e+05,
         4.766000e+05,  7.997000e+05,  2.312000e+05, -5.930000e+04,
        -4.620000e+04, -4.620000e+04, -4.660000e+04, -4.490000e+04,
        -1.181000e+05, -4.630000e+04, -8.710000e+04, -5.743000e+05,
        -5.391000e+05,  6.410000e+04, -5.590000e+04, -4.890000e+04,
         1.047000e+05, -1.157000e+05, -5.690000e+04, -5.690000e+04,
        -2.500000e+03,  5.170000e+04,  6.500000e+03, -1.990000e+04,
         6.010000e+04, -6.070000e+04,  2.113000e+05, -1.558000e+05,
         1.611000e+05, -3.900000e+03, -1.149000e+05,  3.746000e+05,
         3.745000e+05,  1.322000e+05,  1.487000e+05,  8.449000e+05,
         2.580000e+04,  1.079000e+05,  6.360000e+04,  3.891000e+05,
         3.891000e+05,  3.890000e+05,  3.890000e+05,  1.423000e+05,
         6.550000e+04,  2.185000e+05,  9.720000e+04, -1.680000e+04,
         3.780000e+04, -6.500000e+03, -1.009000e+05,  7.160000e+04,
         6.890000e+04,  6.890000e+04,  2.600000e+04,  2.600000e+04,
         2.600000e+04,  1.102600e+06,  4.888000e+05,  4.599000e+05,
         5.081000e+05,  6.315000e+05,  2.613000e+05,  3.725000e+05,
         1.442700e+06,  5.790000e+05,  1.442700e+06,  5.791000e+05,
         7.908000e+05,  9.060000e+04, -2.332000e+05, -4.010000e+05,
         1.479000e+05,  2.720000e+04,  8.001000e+05, -1.888000e+05,
         1.328000e+05,  1.090000e+04, -6.300000e+04, -1.472000e+05,
         2.764000e+05, -9.120000e+04, -6.260000e+04, -4.510000e+04,
         3.844000e+05,  6.698000e+05,  3.477000e+05,  9.918000e+05,
         6.590000e+04,  1.048000e+05,  2.146000e+05, -2.700000e+04,
         1.950000e+05,  6.650000e+05,  3.052000e+05,  3.430000e+05,
         1.969000e+05,  2.945000e+05,  6.314000e+05,  3.230000e+04,
         6.600000e+03,  6.090000e+04,  4.938000e+05,  4.938000e+05,
         1.319000e+05,  3.531000e+05,  9.570000e+05,  8.086900e+06,
         6.450000e+04,  6.460000e+04, -6.130000e+04, -6.130000e+04,
        -1.960000e+04, -6.150000e+04, -1.577000e+05, -6.130000e+04,
         8.120000e+04,  8.120000e+04,  8.120000e+04,  8.120000e+04,
         8.430000e+04, -9.950000e+04, -9.940000e+04, -9.940000e+04,
        -5.969000e+05, -2.313000e+05, -1.464000e+05, -1.141000e+05,
         1.425000e+05,  1.422000e+05,  3.854000e+05,  3.853000e+05,
        -1.670000e+04, -4.910000e+04, -3.000000e+02,  7.820000e+04,
        -6.800000e+03, -8.900000e+03, -1.274000e+05,  2.006000e+05,
        -1.810000e+04, -1.066000e+05,  0.000000e+00,  1.000000e+02,
        -1.000000e+02,  1.025000e+05, -9.000000e+03, -1.910000e+04,
         0.000000e+00,  0.000000e+00, -2.060000e+04, -1.364000e+05,
        -2.740000e+04,  2.990000e+04, -8.700000e+03,  0.000000e+00,
         8.030000e+04, -6.470000e+04, -9.100000e+03, -5.540000e+04,
        -5.540000e+04,  1.029000e+05, -9.400000e+03, -3.900000e+03,
         4.580000e+04, -6.500000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -2.000000e+02,  1.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  7.820000e+04, -4.910000e+04,
        -1.670000e+04,  8.120000e+04, -2.000000e+02,  3.012000e+05,
         6.110000e+04,  2.600000e+04,  5.692000e+05,  2.185000e+05,
        -4.500000e+04, -1.960000e+04, -6.130000e+04,  6.460000e+04,
        -9.950000e+04, -1.464000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  8.120000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 1.429000e+05,  5.350000e+04,  5.990000e+04,  3.192000e+05,
         2.306000e+05,  5.957000e+05,  3.098000e+05,  1.411000e+05,
         5.350000e+04,  1.403000e+05,  5.350000e+04,  1.120000e+05,
         2.710000e+04, -1.359000e+05,  2.058000e+05,  1.102000e+05,
         6.000000e+03,  4.480000e+05,  1.907000e+05,  5.930000e+04,
         6.790000e+04,  4.763000e+05,  5.949000e+05,  2.940000e+05,
         3.014000e+05,  5.476000e+05,  2.121000e+05,  3.172500e+06,
        -6.090000e+04, -6.080000e+04, -6.120000e+04, -6.040000e+04,
        -1.322000e+05, -6.090000e+04, -5.247000e+05, -7.006000e+05,
        -6.885000e+05, -2.730000e+04, -7.120000e+04, -6.830000e+04,
         5.465000e+05,  7.534000e+05,  2.801000e+05,  2.801000e+05,
         3.377000e+05,  3.965000e+05,  3.401000e+05,  1.435000e+05,
         6.609000e+05,  6.170000e+05,  9.048000e+05,  1.926000e+05,
         4.403000e+05,  5.254000e+05,  7.601000e+05,  1.700000e+05,
         1.699000e+05,  8.250000e+04,  8.810000e+04,  3.583000e+05,
         1.900000e+05,  2.980000e+05,  5.890000e+04,  2.185000e+05,
         2.185000e+05,  2.185000e+05,  2.185000e+05,  1.285000e+05,
        -2.810000e+04,  3.377000e+05,  2.916000e+05, -1.690000e+04,
         4.070000e+04,  3.530000e+04,  6.810000e+04,  1.474000e+05,
         5.960000e+04,  5.960000e+04,  2.058000e+05,  2.057000e+05,
         2.058000e+05,  1.076900e+06,  8.509000e+05,  5.693000e+05,
         5.754000e+05,  3.683000e+05,  2.341000e+05,  3.504000e+05,
         8.389000e+05,  5.239000e+05,  8.389000e+05,  5.246000e+05,
         3.452000e+05, -2.635000e+05, -5.100000e+05, -4.424000e+05,
         4.800000e+04,  4.100000e+03,  7.096000e+05, -1.552000e+05,
         8.980000e+04,  4.570000e+04, -7.780000e+04,  7.700000e+03,
         8.600000e+04, -5.100000e+04, -3.680000e+04, -1.590000e+05,
         1.591000e+05,  2.573000e+05,  1.080000e+04,  5.038000e+05,
         3.790000e+04,  5.260000e+04,  2.100000e+04, -6.680000e+04,
         1.621000e+05,  4.020000e+05,  2.702000e+05,  1.571000e+05,
         1.636000e+05,  2.676000e+05,  3.787000e+05,  1.200000e+04,
         3.475000e+05,  4.050000e+05,  2.505000e+05,  2.505000e+05,
         1.176000e+05,  3.236000e+05,  5.430000e+05,  4.179900e+06,
         5.810000e+04,  5.820000e+04, -1.910000e+04, -1.910000e+04,
         1.437000e+05, -1.920000e+04, -5.230000e+04, -1.910000e+04,
         7.500000e+04,  7.500000e+04,  7.500000e+04,  7.490000e+04,
         7.590000e+04, -9.270000e+04, -9.260000e+04, -9.260000e+04,
        -5.561000e+05, -1.695000e+05, -9.430000e+04,  5.492000e+05,
         2.934000e+05,  2.932000e+05,  5.179000e+05,  5.178000e+05,
        -1.680000e+04,  1.146000e+05, -9.700000e+03,  2.320000e+04,
        -6.600000e+03, -5.800000e+03, -1.359000e+05,  1.120000e+05,
        -2.050000e+04, -3.370000e+04,  0.000000e+00, -2.000000e+02,
        -1.330000e+04,  1.690000e+04, -1.930000e+04, -1.770000e+04,
         0.000000e+00,  0.000000e+00, -1.043000e+05, -1.459000e+05,
        -3.080000e+04,  4.500000e+03, -1.870000e+04,  0.000000e+00,
         2.400000e+04, -6.870000e+04, -1.030000e+04,  1.182000e+05,
         1.183000e+05,  2.540000e+04, -1.160000e+04, -4.800000e+03,
         1.483000e+05,  1.073000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02, -1.200000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  2.320000e+04,  1.146000e+05,
        -1.780000e+04,  7.500000e+04, -1.000000e+02,  1.429000e+05,
         5.350000e+04,  2.057000e+05,  2.185000e+05,  4.388000e+05,
        -6.040000e+04,  1.437000e+05, -1.910000e+04,  5.820000e+04,
        -9.260000e+04, -9.430000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  7.500000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-2.990000e+04, -1.890000e+04, -1.250000e+04, -5.780000e+04,
        -4.380000e+04, -1.255000e+05, -6.560000e+04, -2.970000e+04,
        -1.890000e+04, -2.960000e+04, -1.890000e+04, -2.360000e+04,
        -7.200000e+03,  4.188000e+05, -3.760000e+04, -2.340000e+04,
        -1.600000e+03, -9.440000e+04,  3.482000e+05,  3.610000e+05,
         3.740000e+05,  2.955000e+05, -1.151000e+05, -6.010000e+04,
         7.157000e+05,  2.763000e+05,  7.220000e+05,  1.534900e+06,
         4.019000e+05,  4.018000e+05,  4.015000e+05,  4.200000e+05,
         5.342000e+05,  4.017000e+05,  3.616200e+06,  3.629400e+06,
         3.650600e+06,  3.945000e+05,  3.985000e+05,  4.031000e+05,
        -1.018000e+05, -1.362000e+05,  5.260000e+05,  5.260000e+05,
         3.185000e+05,  1.125000e+05,  3.216000e+05,  3.592000e+05,
         8.383000e+05,  8.424000e+05, -1.951000e+05,  3.537000e+05,
        -8.100000e+04, -9.550000e+04, -1.360000e+05,  7.505000e+05,
         7.505000e+05,  7.496000e+05,  7.677000e+05, -7.720000e+04,
        -3.870000e+04, -5.490000e+04, -1.270000e+04, -4.500000e+04,
        -4.500000e+04, -4.500000e+04, -4.500000e+04, -3.540000e+04,
         3.923000e+05, -6.040000e+04, -5.520000e+04, -3.000000e+02,
        -2.093000e+05, -2.032000e+05,  3.775000e+05,  1.599000e+05,
        -1.280000e+04, -1.280000e+04, -3.760000e+04, -3.760000e+04,
        -3.760000e+04, -2.045000e+05, -1.800000e+05,  6.681000e+05,
         2.747000e+05, -8.410000e+04, -6.970000e+04, -4.909000e+05,
        -1.737000e+05, -1.401000e+05, -1.737000e+05, -1.405000e+05,
         7.286000e+05,  1.597000e+06,  2.034800e+06,  1.611700e+06,
         3.792000e+05,  3.833000e+05, -2.207000e+05,  4.238000e+05,
        -1.780000e+04, -1.350000e+04,  4.018000e+05,  7.774000e+05,
        -1.370000e+04, -1.100000e+03,  1.210000e+04,  4.280000e+05,
        -3.880000e+04,  3.339000e+05,  7.710000e+05, -1.032000e+05,
         3.544000e+05,  3.768000e+05,  7.749000e+05,  7.831000e+05,
         3.481000e+05, -8.350000e+04, -7.160000e+04,  3.570000e+05,
         3.520000e+05, -6.970000e+04, -8.240000e+04,  3.788000e+05,
         3.187000e+05,  1.112000e+05, -5.240000e+04, -5.240000e+04,
        -3.680000e+04,  1.982000e+05,  1.777000e+05, -8.738000e+05,
        -1.650000e+04, -1.650000e+04,  3.000000e+03,  3.000000e+03,
         3.583000e+05,  3.000000e+03, -3.792000e+05,  3.000000e+03,
        -1.650000e+04, -1.650000e+04, -1.650000e+04, -1.650000e+04,
        -1.680000e+04,  1.340000e+04,  1.340000e+04,  1.340000e+04,
         8.060000e+04,  3.460000e+04,  1.880000e+04,  1.054700e+06,
         3.255000e+05,  3.258000e+05,  2.762000e+05,  2.761000e+05,
        -1.000000e+02, -1.930000e+04,  2.600000e+03, -5.500000e+03,
        -6.000000e+02,  1.200000e+03,  4.188000e+05, -2.360000e+04,
        -1.700000e+03,  7.400000e+03,  0.000000e+00,  0.000000e+00,
         3.600000e+03, -3.700000e+03,  1.000000e+02,  3.800000e+03,
         0.000000e+00,  0.000000e+00,  4.057000e+05,  4.158000e+05,
        -3.900000e+03, -3.000000e+03,  1.000000e+02,  0.000000e+00,
        -5.700000e+03,  2.074000e+05, -9.000000e+02, -2.020000e+04,
        -2.020000e+04, -6.000000e+03, -1.800000e+03,  1.100000e+03,
        -2.630000e+04, -2.200000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02,  2.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -5.500000e+03, -1.930000e+04,
         5.500000e+04, -1.640000e+04, -1.000000e+02, -2.990000e+04,
        -1.890000e+04, -3.760000e+04, -4.500000e+04, -6.040000e+04,
         2.981800e+06,  3.583000e+05,  3.000000e+03, -1.650000e+04,
         1.340000e+04,  1.880000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -1.650000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-3.920000e+04,  4.700000e+03,  9.200000e+03,  2.720000e+05,
         1.162000e+05, -1.783000e+05, -9.990000e+04, -3.780000e+04,
         4.700000e+03, -3.710000e+04,  4.700000e+03, -1.240000e+04,
         3.400000e+03,  3.400000e+05,  1.489000e+05, -1.110000e+04,
         9.000000e+02, -4.970000e+04,  3.115000e+05,  3.738000e+05,
         3.855000e+05,  8.438000e+05,  4.320000e+05,  1.000000e+02,
         7.701000e+05,  4.195000e+05,  8.130000e+05,  4.946400e+06,
         3.589000e+05,  3.597000e+05,  3.590000e+05,  3.582000e+05,
         4.342000e+05,  3.596000e+05,  3.090200e+06,  3.176200e+06,
         3.188800e+06,  3.306000e+05,  3.505000e+05,  3.553000e+05,
         3.880000e+05,  6.683000e+05,  9.017000e+05,  9.019000e+05,
         7.016000e+05,  4.972000e+05,  6.910000e+05,  5.464000e+05,
         1.573600e+06,  1.593900e+06,  5.924000e+05,  6.429000e+05,
         2.654000e+05,  4.212000e+05,  6.693000e+05,  7.165000e+05,
         7.164000e+05,  7.592000e+05,  7.658000e+05, -1.433000e+05,
         1.718000e+05,  1.746000e+05,  1.430000e+04, -1.960000e+04,
        -1.960000e+04, -1.960000e+04, -1.960000e+04,  2.340000e+04,
         3.315000e+05,  1.437000e+05,  1.652000e+05, -1.120000e+04,
        -1.968000e+05, -1.677000e+05,  5.079000e+05,  3.277000e+05,
         1.240000e+04,  1.240000e+04,  1.489000e+05,  1.488000e+05,
         1.489000e+05,  2.782000e+05,  3.841000e+05,  1.006000e+06,
         5.893000e+05, -3.280000e+04,  2.950000e+04, -3.413000e+05,
        -4.960000e+04,  1.008000e+05, -4.960000e+04,  1.005000e+05,
         6.466000e+05,  1.287600e+06,  1.638500e+06,  1.373400e+06,
         3.498000e+05,  3.700000e+05,  9.840000e+04,  3.569000e+05,
         6.000000e+03,  2.680000e+04,  3.471000e+05,  8.886000e+05,
        -7.160000e+04, -5.400000e+03,  2.400000e+03,  2.795000e+05,
        -8.180000e+04,  2.531000e+05,  6.046000e+05, -9.840000e+04,
         3.543000e+05,  3.764000e+05,  6.810000e+05,  7.214000e+05,
         4.095000e+05, -1.040000e+04,  4.910000e+04,  3.403000e+05,
         4.150000e+05,  5.370000e+04, -1.140000e+04,  3.700000e+05,
         7.094000e+05,  5.091000e+05, -5.070000e+04, -5.070000e+04,
         1.630000e+04,  3.479000e+05,  2.467000e+05, -7.490000e+05,
         6.500000e+03,  6.600000e+03,  1.590000e+04,  1.590000e+04,
         5.571000e+05,  1.580000e+04, -3.466000e+05,  1.590000e+04,
         1.870000e+04,  1.870000e+04,  1.870000e+04,  1.870000e+04,
         1.830000e+04, -2.250000e+04, -2.250000e+04, -2.250000e+04,
        -1.351000e+05, -2.270000e+04, -3.400000e+03,  1.794300e+06,
         5.909000e+05,  5.870000e+05,  6.429000e+05,  6.428000e+05,
        -1.220000e+04,  1.170000e+05, -9.000000e+03, -2.070000e+04,
        -4.000000e+03,  0.000000e+00,  3.400000e+05, -1.240000e+04,
        -1.340000e+04,  2.940000e+04,  0.000000e+00, -1.000000e+02,
        -1.010000e+04, -3.800000e+04, -1.640000e+04, -4.300000e+03,
         0.000000e+00,  0.000000e+00,  3.131000e+05,  3.327000e+05,
        -2.080000e+04, -1.380000e+04, -1.580000e+04,  0.000000e+00,
        -2.140000e+04,  1.678000e+05, -6.700000e+03,  1.241000e+05,
         1.241000e+05, -3.000000e+04, -8.300000e+03, -1.900000e+03,
         9.510000e+04,  1.160000e+05,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02, -1.000000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -2.070000e+04,  1.170000e+05,
         4.460000e+04,  1.870000e+04, -1.000000e+02, -3.920000e+04,
         4.700000e+03,  1.488000e+05, -1.960000e+04,  1.437000e+05,
         3.583000e+05,  6.243000e+05,  1.590000e+04,  6.600000e+03,
        -2.250000e+04, -3.400000e+03,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.870000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-7.240000e+04,  1.050000e+04,  1.800000e+03,  1.180000e+04,
        -3.010000e+04, -3.206000e+05, -1.759000e+05, -7.040000e+04,
         1.050000e+04, -6.940000e+04,  1.050000e+04, -3.330000e+04,
         2.700000e+03, -9.700000e+03,  1.180000e+04, -3.110000e+04,
         9.000000e+02, -1.330000e+05, -1.012000e+05,  2.650000e+04,
         1.080000e+04,  2.600000e+04,  3.280000e+04, -5.030000e+04,
         6.920000e+06,  6.897600e+06,  7.005600e+06,  7.000000e+04,
         3.800000e+03,  3.900000e+03,  4.000000e+03,  3.000000e+03,
        -5.700000e+03,  3.800000e+03, -1.615000e+05,  8.700000e+03,
        -1.220000e+04, -3.940000e+04,  2.300000e+03, -2.000000e+03,
        -1.810000e+04,  2.390000e+04,  2.300000e+04,  2.300000e+04,
         2.640000e+04,  2.980000e+04,  2.090000e+04,  1.580000e+04,
         7.100000e+03,  4.920000e+04,  6.610000e+04,  1.000000e+03,
        -1.840000e+04,  2.360000e+04,  2.380000e+04, -4.060000e+04,
        -4.070000e+04,  4.550000e+04,  3.400000e+04, -2.388000e+05,
         1.190000e+04,  2.360000e+04,  9.500000e+03, -6.130000e+04,
        -6.130000e+04, -6.130000e+04, -6.130000e+04,  2.400000e+04,
        -3.970000e+04, -1.910000e+04,  2.290000e+04, -1.100000e+03,
         2.100000e+03,  2.450000e+04,  2.200000e+03,  2.160000e+04,
         6.900000e+03,  6.900000e+03,  1.180000e+04,  1.180000e+04,
         1.180000e+04, -1.175000e+05,  9.520000e+04, -7.460000e+04,
        -1.297000e+05, -8.120000e+04,  4.640000e+04,  5.390000e+04,
        -2.016000e+05,  9.700000e+04, -2.016000e+05,  9.740000e+04,
        -1.605000e+05, -1.827000e+05, -1.610000e+05, -1.170000e+04,
        -2.700000e+04,  1.500000e+04,  1.362000e+05,  6.924000e+06,
         6.902000e+06,  6.945400e+06,  2.300000e+03,  6.200000e+03,
         6.783000e+06,  6.929300e+06,  6.895000e+06,  6.805500e+06,
        -1.132000e+05, -1.861000e+05, -1.647000e+05, -2.074000e+05,
         2.430000e+04,  6.000000e+02, -6.750000e+04,  1.660000e+04,
         4.370000e+04, -7.910000e+04,  4.600000e+04, -5.790000e+04,
         4.450000e+04,  4.940000e+04, -6.580000e+04,  1.660000e+04,
         2.770000e+04,  3.100000e+04, -1.041000e+05, -1.041000e+05,
         2.240000e+04,  3.539700e+06,  3.329300e+06, -1.623900e+06,
         1.200000e+04,  1.200000e+04,  6.929600e+06,  6.934200e+06,
         1.590000e+04,  6.934100e+06,  1.385100e+07,  6.934200e+06,
         1.350000e+04,  1.350000e+04,  1.350000e+04,  1.350000e+04,
         1.220000e+04, -1.120000e+04, -1.120000e+04, -1.120000e+04,
        -6.740000e+04,  6.908600e+06,  6.921400e+06,  4.770000e+04,
         4.280000e+04,  4.260000e+04,  8.300000e+04,  8.290000e+04,
        -1.600000e+03, -1.500000e+03, -3.000000e+02, -3.020000e+04,
        -5.000000e+02,  4.000000e+02, -9.700000e+03, -3.330000e+04,
        -2.500000e+03,  4.170000e+04,  0.000000e+00,  0.000000e+00,
        -5.700000e+03, -3.990000e+04, -1.800000e+03, -2.900000e+03,
         0.000000e+00,  0.000000e+00, -5.120000e+04, -1.100000e+04,
        -3.900000e+03, -1.460000e+04, -1.700000e+03,  0.000000e+00,
        -3.110000e+04, -5.100000e+03, -1.300000e+03,  0.000000e+00,
         0.000000e+00, -3.940000e+04, -1.000000e+03, -1.200000e+03,
        -3.890000e+04, -9.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02,  2.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00, -3.020000e+04, -1.500000e+03,
        -1.300000e+03,  1.350000e+04, -1.000000e+02, -7.240000e+04,
         1.050000e+04,  1.180000e+04, -6.130000e+04, -1.910000e+04,
         3.000000e+03,  1.590000e+04,  6.949200e+06,  1.200000e+04,
        -1.120000e+04,  6.921400e+06,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  1.350000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [ 8.000000e+03,  4.130000e+04,  3.340000e+04, -1.000000e+02,
         4.000000e+03,  1.520000e+04, -8.000000e+02,  9.300000e+03,
         4.130000e+04,  9.800000e+03,  4.130000e+04,  2.920000e+04,
         1.780000e+04, -7.070000e+04,  2.670000e+04,  3.040000e+04,
         4.200000e+03,  1.170000e+05,  2.700000e+04,  7.510000e+04,
         6.600000e+04,  4.600000e+03,  6.860000e+04,  1.212000e+05,
         2.070000e+05,  3.093000e+05,  2.381000e+05, -7.900000e+03,
        -1.660000e+04, -1.620000e+04, -1.620000e+04, -1.650000e+04,
        -6.130000e+04, -1.630000e+04, -3.163000e+05, -2.507000e+05,
        -2.643000e+05, -3.890000e+04, -2.250000e+04, -2.590000e+04,
         3.800000e+03, -2.640000e+04, -4.200000e+03, -4.200000e+03,
         2.740000e+04,  5.900000e+04,  2.500000e+04,  7.200000e+03,
         6.400000e+03,  2.260000e+04,  1.806000e+05, -7.360000e+04,
         3.100000e+04,  2.660000e+04, -2.570000e+04,  8.660000e+04,
         8.650000e+04,  1.184000e+05,  1.126000e+05, -3.470000e+04,
         2.350000e+04,  8.010000e+04,  4.090000e+04,  6.460000e+04,
         6.460000e+04,  6.460000e+04,  6.460000e+04,  9.550000e+04,
        -3.740000e+04,  5.820000e+04,  7.440000e+04,  2.429900e+06,
         2.477600e+06,  2.476200e+06, -4.560000e+04,  5.540000e+04,
         3.890000e+04,  3.890000e+04,  2.670000e+04,  2.670000e+04,
         2.670000e+04,  2.677000e+05,  3.461000e+05,  6.250000e+04,
         2.303000e+06,  5.014000e+06,  5.116200e+06,  5.154400e+06,
         2.804000e+05,  3.885000e+05,  2.804000e+05,  3.883000e+05,
         7.530000e+04, -2.608000e+05, -3.630000e+05, -1.986000e+05,
         1.590000e+04,  3.220000e+04,  5.396000e+05, -5.890000e+04,
         4.400000e+04,  6.010000e+04,  2.436100e+06, -6.340000e+04,
        -5.390000e+04, -7.200000e+03, -1.490000e+04, -1.568000e+05,
         2.440600e+06, -2.050000e+04, -1.221000e+05,  8.110000e+04,
         6.070000e+04,  4.460000e+04, -2.230000e+04,  1.010000e+04,
         1.444000e+05,  1.513000e+05,  2.006000e+05,  4.850000e+04,
         1.463000e+05,  1.974000e+05,  1.509000e+05,  3.570000e+04,
         3.260000e+04,  6.420000e+04,  3.720000e+04,  3.720000e+04,
         8.880000e+04,  2.745000e+05,  1.933000e+05,  7.502000e+05,
         2.509300e+06,  2.513600e+06,  1.200000e+04,  1.200000e+04,
         6.600000e+03,  1.190000e+04, -1.410000e+04,  1.200000e+04,
         5.420000e+04,  5.420000e+04,  5.420000e+04,  5.420000e+04,
         5.370000e+04,  2.241100e+06,  2.239500e+06,  2.239900e+06,
         1.344440e+07, -9.910000e+04, -4.360000e+04, -6.400000e+03,
         1.151000e+05,  1.152000e+05,  2.777000e+05,  2.776000e+05,
         2.455200e+06, -2.550000e+04, -4.000000e+02, -1.610000e+04,
        -3.700000e+03, -3.100000e+03, -7.070000e+04,  2.920000e+04,
        -1.130000e+04,  2.430000e+04,  0.000000e+00,  0.000000e+00,
        -7.300000e+03, -2.150000e+04, -6.000000e+03, -1.230000e+04,
         0.000000e+00,  0.000000e+00, -9.260000e+04, -7.620000e+04,
        -1.720000e+04, -1.090000e+04, -5.800000e+03,  0.000000e+00,
        -1.680000e+04, -3.610000e+04, -5.700000e+03, -2.610000e+04,
        -2.610000e+04, -2.070000e+04, -5.200000e+03, -3.500000e+03,
        -4.680000e+04, -3.130000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
        -1.000000e+02,  4.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  1.000000e+02, -1.610000e+04, -2.550000e+04,
        -9.300000e+03,  5.420000e+04, -1.000000e+02,  8.000000e+03,
         4.130000e+04,  2.670000e+04,  6.460000e+04,  5.820000e+04,
        -1.650000e+04,  6.600000e+03,  1.200000e+04,  2.530200e+06,
         2.240000e+06, -4.360000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  5.420000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-2.330000e+04, -5.290000e+04, -4.460000e+04, -1.440000e+04,
        -1.890000e+04, -7.580000e+04, -2.930000e+04, -2.470000e+04,
        -5.290000e+04, -2.530000e+04, -5.290000e+04, -4.510000e+04,
        -2.330000e+04,  8.390000e+04, -4.280000e+04, -4.620000e+04,
        -5.500000e+03, -1.805000e+05, -6.650000e+04, -1.048000e+05,
        -9.950000e+04, -3.570000e+04, -1.132000e+05, -1.756000e+05,
        -2.951000e+05, -4.277000e+05, -3.194000e+05, -1.923000e+05,
         1.380000e+04,  1.340000e+04,  1.340000e+04,  1.340000e+04,
         6.970000e+04,  1.340000e+04,  3.096000e+05,  2.561000e+05,
         2.656000e+05,  3.570000e+04,  2.150000e+04,  2.470000e+04,
        -3.270000e+04, -1.000000e+03, -1.960000e+04, -1.950000e+04,
        -5.730000e+04, -9.530000e+04, -5.700000e+04, -2.390000e+04,
        -6.290000e+04, -7.640000e+04, -2.652000e+05,  7.320000e+04,
        -6.240000e+04, -5.720000e+04, -2.600000e+03, -1.433000e+05,
        -1.433000e+05, -1.687000e+05, -1.653000e+05,  5.700000e+03,
        -3.650000e+04, -1.141000e+05, -5.320000e+04, -9.950000e+04,
        -9.950000e+04, -9.940000e+04, -9.940000e+04, -1.232000e+05,
         3.270000e+04, -9.260000e+04, -1.062000e+05,  2.345700e+06,
         2.281900e+06,  2.292800e+06,  4.410000e+04, -7.780000e+04,
        -5.090000e+04, -5.090000e+04, -4.280000e+04, -4.280000e+04,
        -4.280000e+04, -4.056000e+05, -4.676000e+05, -1.388000e+05,
         2.578300e+06,  4.467600e+06,  4.365400e+06,  4.305800e+06,
        -4.190000e+05, -5.022000e+05, -4.190000e+05, -5.015000e+05,
        -1.525000e+05,  2.782000e+05,  4.108000e+05,  2.300000e+05,
        -3.650000e+04, -5.010000e+04, -6.952000e+05,  7.280000e+04,
        -6.090000e+04, -7.370000e+04,  2.332000e+06,  6.000000e+04,
         5.060000e+04,  1.430000e+04,  1.760000e+04,  1.843000e+05,
         2.319400e+06, -1.680000e+04,  1.142000e+05, -1.478000e+05,
        -8.460000e+04, -7.180000e+04, -2.700000e+03, -2.980000e+04,
        -1.948000e+05, -2.205000e+05, -2.631000e+05, -8.680000e+04,
        -1.974000e+05, -2.551000e+05, -2.118000e+05, -5.400000e+04,
        -6.430000e+04, -1.020000e+05, -6.860000e+04, -6.870000e+04,
        -1.145000e+05, -3.592000e+05, -2.913000e+05, -1.307700e+06,
         2.237600e+06,  2.240000e+06, -1.120000e+04, -1.120000e+04,
        -2.250000e+04, -1.120000e+04,  3.450000e+04, -1.120000e+04,
        -7.030000e+04, -7.030000e+04, -7.030000e+04, -7.030000e+04,
        -6.990000e+04,  2.721400e+06,  2.728400e+06,  2.728800e+06,
         1.634240e+07,  1.359000e+05,  6.240000e+04, -4.050000e+04,
        -1.635000e+05, -1.640000e+05, -3.747000e+05, -3.747000e+05,
         2.307800e+06,  2.640000e+04,  9.000000e+02,  1.650000e+04,
         5.000000e+03,  4.200000e+03,  8.390000e+04, -4.510000e+04,
         1.530000e+04, -2.650000e+04,  0.000000e+00,  0.000000e+00,
         8.100000e+03,  2.280000e+04,  8.200000e+03,  1.600000e+04,
         0.000000e+00,  0.000000e+00,  1.057000e+05,  9.120000e+04,
         2.300000e+04,  1.220000e+04,  7.900000e+03,  0.000000e+00,
         1.720000e+04,  4.290000e+04,  7.600000e+03,  2.720000e+04,
         2.720000e+04,  2.150000e+04,  7.100000e+03,  4.500000e+03,
         4.850000e+04,  3.420000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -5.000000e+02,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00, -5.000000e+02,  1.650000e+04,  2.640000e+04,
         1.100000e+04, -7.030000e+04,  0.000000e+00, -2.330000e+04,
        -5.290000e+04, -4.280000e+04, -9.950000e+04, -9.260000e+04,
         1.340000e+04, -2.250000e+04, -1.120000e+04,  2.240000e+06,
         2.739000e+06,  6.240000e+04,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00,
         0.000000e+00,  0.000000e+00,  0.000000e+00, -7.030000e+04,
         0.000000e+00,  0.000000e+00,  0.000000e+00,  0.000000e+00],
       [-8.850000e+04, -3.830000e+04, -3.860000e+04,  5.300000e+03,
        -4.140000e+04, -3.673000e+05, -1.904000e+05, -8.790000e+04,
        -3.830000e+04, -8.750000e+04, -3.830000e+04, -7.180000e+04,
        -1.870000e+04,  7.090000e+04, -2.320000e+04, -7.080000e+04,
        -4.200000e+03, -2.871000e+05, -1.486000e+05, -6.600000e+04,
        -7.410000e+04,  1.100000e+03, -5.860000e+04, -2.043000e+05,
         6.661200e+06,  6.516300e+06,  6.718000e+06, -4.130000e+04,
         1.990000e+04,  1.990000e+04,  2.010000e+04,  1.870000e+04,
         6.260000e+04,  1.990000e+04,  1.685000e+05,  2.774000e+05,
         2.678000e+05,  2.000000e+02,  2.570000e+04,  2.510000e+04,
        -3.580000e+04,  3.890000e+04,  8.800000e+03,  8.800000e+03,
        -2.110000e+04, -5.090000e+04, -2.400000e+04, -3.400000e+03,
        -3.790000e+04, -1.150000e+04, -1.608000e+05,  7.550000e+04,
        -6.490000e+04, -1.790000e+04,  3.820000e+04, -1.577000e+05,
        -1.577000e+05, -1.018000e+05, -1.081000e+05, -2.173000e+05,
        -2.240000e+04, -7.500000e+04, -3.920000e+04, -1.464000e+05,
        -1.464000e+05, -1.464000e+05, -1.464000e+05, -8.930000e+04,
        -2.000000e+03, -9.430000e+04, -6.790000e+04,  7.900000e+03,
        -2.230000e+04, -1.890000e+04,  4.760000e+04, -5.280000e+04,
        -3.960000e+04, -3.960000e+04, -2.320000e+04, -2.320000e+04,
        -2.320000e+04, -4.608000e+05, -3.207000e+05, -1.755000e+05,
        -1.415000e+05, -2.562000e+05, -1.702000e+05, -2.317000e+05,
        -5.641000e+05, -3.644000e+05, -5.641000e+05, -3.635000e+05,
        -2.757000e+05,  1.022000e+05,  2.469000e+05,  2.159000e+05,
        -5.350000e+04, -2.720000e+04, -5.037000e+05,  6.991800e+06,
         6.846600e+06,  6.874700e+06,  2.740000e+04,  6.750000e+04,
         6.840600e+06,  6.939700e+06,  6.915100e+06,  6.986200e+06,
        -8.940000e+04, -1.825000e+05, -3.930000e+04, -3.256000e+05,
        -5.050000e+04, -5.830000e+04, -5.600000e+04, -3.200000e+03,
        -1.315000e+05, -2.718000e+05, -1.954000e+05, -1.273000e+05,
        -1.328000e+05, -1.849000e+05, -2.543000e+05, -2.940000e+04,
        -2.660000e+04, -5.650000e+04, -1.588000e+05, -1.588000e+05,
        -8.300000e+04,  3.211600e+06,  3.079600e+06, -2.688800e+06,
        -4.350000e+04, -4.360000e+04,  6.916800e+06,  6.921400e+06,
        -3.400000e+03,  6.921400e+06,  1.387430e+07,  6.921400e+06,
        -5.100000e+04, -5.100000e+04, -5.100000e+04, -5.140000e+04,
        -5.190000e+04,  6.240000e+04,  6.240000e+04,  6.240000e+04,
         3.746000e+05,  7.191900e+06,  7.058200e+06,  1.770000e+04,
        -1.053000e+05, -1.0540