import * as lambda from '@aws-cdk/aws-lambda';
import { IntegrationConfig, IntegrationOptions } from '../integration';
import { Method } from '../method';
import { AwsIntegration } from './aws';
export interface LambdaIntegrationOptions extends IntegrationOptions {
    /**
     * Use proxy integration or normal (request/response mapping) integration.
     * @default true
     */
    readonly proxy?: boolean;
    /**
     * Allow invoking method from AWS Console UI (for testing purposes).
     *
     * This will add another permission to the AWS Lambda resource policy which
     * will allow the `test-invoke-stage` stage to invoke this handler. If this
     * is set to `false`, the function will only be usable from the deployment
     * endpoint.
     *
     * @default true
     */
    readonly allowTestInvoke?: boolean;
}
/**
 * Integrates an AWS Lambda function to an API Gateway method.
 *
 * @example
 *
 *    const handler = new lambda.Function(this, 'MyFunction', ...);
 *    api.addMethod('GET', new LambdaIntegration(handler));
 *
 */
export declare class LambdaIntegration extends AwsIntegration {
    private readonly handler;
    private readonly enableTest;
    constructor(handler: lambda.IFunction, options?: LambdaIntegrationOptions);
    bind(method: Method): IntegrationConfig;
}
