"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/// !cdk-integ pragma:ignore-assets
const path = require("path");
const lambda = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const lib_1 = require("../../lib");
const authorizers_1 = require("../../lib/authorizers");
const identity_source_1 = require("../../lib/authorizers/identity-source");
// Against the RestApi endpoint from the stack output, run
// `curl -s -o /dev/null -w "%{http_code}" <url>` should return 401
// `curl -s -o /dev/null -w "%{http_code}" -H 'Authorization: deny' <url>?allow=yes` should return 403
// `curl -s -o /dev/null -w "%{http_code}" -H 'Authorization: allow' <url>?allow=yes` should return 200
const app = new core_1.App();
const stack = new core_1.Stack(app, 'RequestAuthorizerInteg');
const authorizerFn = new lambda.Function(stack, 'MyAuthorizerFunction', {
    runtime: lambda.Runtime.NODEJS_10_X,
    handler: 'index.handler',
    code: lambda.AssetCode.fromAsset(path.join(__dirname, 'integ.request-authorizer.handler')),
});
const restapi = new lib_1.RestApi(stack, 'MyRestApi');
const authorizer = new authorizers_1.RequestAuthorizer(stack, 'MyAuthorizer', {
    handler: authorizerFn,
    identitySources: [identity_source_1.IdentitySource.header('Authorization'), identity_source_1.IdentitySource.queryString('allow')],
});
restapi.root.addMethod('ANY', new lib_1.MockIntegration({
    integrationResponses: [
        { statusCode: '200' },
    ],
    passthroughBehavior: lib_1.PassthroughBehavior.NEVER,
    requestTemplates: {
        'application/json': '{ "statusCode": 200 }',
    },
}), {
    methodResponses: [
        { statusCode: '200' },
    ],
    authorizer,
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcucmVxdWVzdC1hdXRob3JpemVyLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiaW50ZWcucmVxdWVzdC1hdXRob3JpemVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsbUNBQW1DO0FBQ25DLDZCQUE2QjtBQUM3Qiw4Q0FBOEM7QUFDOUMsd0NBQTJDO0FBQzNDLG1DQUEwRTtBQUMxRSx1REFBMEQ7QUFDMUQsMkVBQXVFO0FBRXZFLDBEQUEwRDtBQUMxRCxtRUFBbUU7QUFDbkUsc0dBQXNHO0FBQ3RHLHVHQUF1RztBQUV2RyxNQUFNLEdBQUcsR0FBRyxJQUFJLFVBQUcsRUFBRSxDQUFDO0FBQ3RCLE1BQU0sS0FBSyxHQUFHLElBQUksWUFBSyxDQUFDLEdBQUcsRUFBRSx3QkFBd0IsQ0FBQyxDQUFDO0FBRXZELE1BQU0sWUFBWSxHQUFHLElBQUksTUFBTSxDQUFDLFFBQVEsQ0FBQyxLQUFLLEVBQUUsc0JBQXNCLEVBQUU7SUFDdEUsT0FBTyxFQUFFLE1BQU0sQ0FBQyxPQUFPLENBQUMsV0FBVztJQUNuQyxPQUFPLEVBQUUsZUFBZTtJQUN4QixJQUFJLEVBQUUsTUFBTSxDQUFDLFNBQVMsQ0FBQyxTQUFTLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsa0NBQWtDLENBQUMsQ0FBQztDQUMzRixDQUFDLENBQUM7QUFFSCxNQUFNLE9BQU8sR0FBRyxJQUFJLGFBQU8sQ0FBQyxLQUFLLEVBQUUsV0FBVyxDQUFDLENBQUM7QUFFaEQsTUFBTSxVQUFVLEdBQUcsSUFBSSwrQkFBaUIsQ0FBQyxLQUFLLEVBQUUsY0FBYyxFQUFFO0lBQzlELE9BQU8sRUFBRSxZQUFZO0lBQ3JCLGVBQWUsRUFBRSxDQUFDLGdDQUFjLENBQUMsTUFBTSxDQUFDLGVBQWUsQ0FBQyxFQUFFLGdDQUFjLENBQUMsV0FBVyxDQUFDLE9BQU8sQ0FBQyxDQUFDO0NBQy9GLENBQUMsQ0FBQztBQUVILE9BQU8sQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLEtBQUssRUFBRSxJQUFJLHFCQUFlLENBQUM7SUFDaEQsb0JBQW9CLEVBQUU7UUFDcEIsRUFBRSxVQUFVLEVBQUUsS0FBSyxFQUFFO0tBQ3RCO0lBQ0QsbUJBQW1CLEVBQUUseUJBQW1CLENBQUMsS0FBSztJQUM5QyxnQkFBZ0IsRUFBRTtRQUNoQixrQkFBa0IsRUFBRSx1QkFBdUI7S0FDNUM7Q0FDRixDQUFDLEVBQUU7SUFDRixlQUFlLEVBQUU7UUFDZixFQUFFLFVBQVUsRUFBRSxLQUFLLEVBQUU7S0FDdEI7SUFDRCxVQUFVO0NBQ1gsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLy8vICFjZGstaW50ZWcgcHJhZ21hOmlnbm9yZS1hc3NldHNcbmltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5pbXBvcnQgKiBhcyBsYW1iZGEgZnJvbSAnQGF3cy1jZGsvYXdzLWxhbWJkYSc7XG5pbXBvcnQgeyBBcHAsIFN0YWNrIH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5pbXBvcnQgeyBNb2NrSW50ZWdyYXRpb24sIFBhc3N0aHJvdWdoQmVoYXZpb3IsIFJlc3RBcGkgfSBmcm9tICcuLi8uLi9saWInO1xuaW1wb3J0IHsgUmVxdWVzdEF1dGhvcml6ZXIgfSBmcm9tICcuLi8uLi9saWIvYXV0aG9yaXplcnMnO1xuaW1wb3J0IHsgSWRlbnRpdHlTb3VyY2UgfSBmcm9tICcuLi8uLi9saWIvYXV0aG9yaXplcnMvaWRlbnRpdHktc291cmNlJztcblxuLy8gQWdhaW5zdCB0aGUgUmVzdEFwaSBlbmRwb2ludCBmcm9tIHRoZSBzdGFjayBvdXRwdXQsIHJ1blxuLy8gYGN1cmwgLXMgLW8gL2Rldi9udWxsIC13IFwiJXtodHRwX2NvZGV9XCIgPHVybD5gIHNob3VsZCByZXR1cm4gNDAxXG4vLyBgY3VybCAtcyAtbyAvZGV2L251bGwgLXcgXCIle2h0dHBfY29kZX1cIiAtSCAnQXV0aG9yaXphdGlvbjogZGVueScgPHVybD4/YWxsb3c9eWVzYCBzaG91bGQgcmV0dXJuIDQwM1xuLy8gYGN1cmwgLXMgLW8gL2Rldi9udWxsIC13IFwiJXtodHRwX2NvZGV9XCIgLUggJ0F1dGhvcml6YXRpb246IGFsbG93JyA8dXJsPj9hbGxvdz15ZXNgIHNob3VsZCByZXR1cm4gMjAwXG5cbmNvbnN0IGFwcCA9IG5ldyBBcHAoKTtcbmNvbnN0IHN0YWNrID0gbmV3IFN0YWNrKGFwcCwgJ1JlcXVlc3RBdXRob3JpemVySW50ZWcnKTtcblxuY29uc3QgYXV0aG9yaXplckZuID0gbmV3IGxhbWJkYS5GdW5jdGlvbihzdGFjaywgJ015QXV0aG9yaXplckZ1bmN0aW9uJywge1xuICBydW50aW1lOiBsYW1iZGEuUnVudGltZS5OT0RFSlNfMTBfWCxcbiAgaGFuZGxlcjogJ2luZGV4LmhhbmRsZXInLFxuICBjb2RlOiBsYW1iZGEuQXNzZXRDb2RlLmZyb21Bc3NldChwYXRoLmpvaW4oX19kaXJuYW1lLCAnaW50ZWcucmVxdWVzdC1hdXRob3JpemVyLmhhbmRsZXInKSksXG59KTtcblxuY29uc3QgcmVzdGFwaSA9IG5ldyBSZXN0QXBpKHN0YWNrLCAnTXlSZXN0QXBpJyk7XG5cbmNvbnN0IGF1dGhvcml6ZXIgPSBuZXcgUmVxdWVzdEF1dGhvcml6ZXIoc3RhY2ssICdNeUF1dGhvcml6ZXInLCB7XG4gIGhhbmRsZXI6IGF1dGhvcml6ZXJGbixcbiAgaWRlbnRpdHlTb3VyY2VzOiBbSWRlbnRpdHlTb3VyY2UuaGVhZGVyKCdBdXRob3JpemF0aW9uJyksIElkZW50aXR5U291cmNlLnF1ZXJ5U3RyaW5nKCdhbGxvdycpXSxcbn0pO1xuXG5yZXN0YXBpLnJvb3QuYWRkTWV0aG9kKCdBTlknLCBuZXcgTW9ja0ludGVncmF0aW9uKHtcbiAgaW50ZWdyYXRpb25SZXNwb25zZXM6IFtcbiAgICB7IHN0YXR1c0NvZGU6ICcyMDAnIH0sXG4gIF0sXG4gIHBhc3N0aHJvdWdoQmVoYXZpb3I6IFBhc3N0aHJvdWdoQmVoYXZpb3IuTkVWRVIsXG4gIHJlcXVlc3RUZW1wbGF0ZXM6IHtcbiAgICAnYXBwbGljYXRpb24vanNvbic6ICd7IFwic3RhdHVzQ29kZVwiOiAyMDAgfScsXG4gIH0sXG59KSwge1xuICBtZXRob2RSZXNwb25zZXM6IFtcbiAgICB7IHN0YXR1c0NvZGU6ICcyMDAnIH0sXG4gIF0sXG4gIGF1dGhvcml6ZXIsXG59KTtcbiJdfQ==