# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from ._inputs import *

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 ca_file: Optional[pulumi.Input[str]] = None,
                 ca_pem: Optional[pulumi.Input[str]] = None,
                 cert_file: Optional[pulumi.Input[str]] = None,
                 cert_pem: Optional[pulumi.Input[str]] = None,
                 consul_token: Optional[pulumi.Input[str]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['ProviderHeaderArgs']]]] = None,
                 http_auth: Optional[pulumi.Input[str]] = None,
                 key_file: Optional[pulumi.Input[str]] = None,
                 key_pem: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secret_id: Optional[pulumi.Input[str]] = None,
                 vault_token: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[str] address: URL of the root of the target Nomad agent.
        :param pulumi.Input[str] ca_file: A path to a PEM-encoded certificate authority used to verify the remote agent's certificate.
        :param pulumi.Input[str] ca_pem: PEM-encoded certificate authority used to verify the remote agent's certificate.
        :param pulumi.Input[str] cert_file: A path to a PEM-encoded certificate provided to the remote agent; requires use of key_file or key_pem.
        :param pulumi.Input[str] cert_pem: PEM-encoded certificate provided to the remote agent; requires use of key_file or key_pem.
        :param pulumi.Input[str] consul_token: Consul token to validate Consul Connect Service Identity policies specified in the job file.
        :param pulumi.Input[Sequence[pulumi.Input['ProviderHeaderArgs']]] headers: The headers to send with each Nomad request.
        :param pulumi.Input[str] http_auth: HTTP basic auth configuration.
        :param pulumi.Input[str] key_file: A path to a PEM-encoded private key, required if cert_file or cert_pem is specified.
        :param pulumi.Input[str] key_pem: PEM-encoded private key, required if cert_file or cert_pem is specified.
        :param pulumi.Input[str] region: Region of the target Nomad agent.
        :param pulumi.Input[str] secret_id: ACL token secret for API requests.
        :param pulumi.Input[str] vault_token: Vault token if policies are specified in the job file.
        """
        pulumi.set(__self__, "address", address)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if ca_pem is not None:
            pulumi.set(__self__, "ca_pem", ca_pem)
        if cert_file is not None:
            pulumi.set(__self__, "cert_file", cert_file)
        if cert_pem is not None:
            pulumi.set(__self__, "cert_pem", cert_pem)
        if consul_token is not None:
            pulumi.set(__self__, "consul_token", consul_token)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if http_auth is not None:
            pulumi.set(__self__, "http_auth", http_auth)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if key_pem is not None:
            pulumi.set(__self__, "key_pem", key_pem)
        if region is not None:
            pulumi.set(__self__, "region", region)
        if secret_id is not None:
            pulumi.set(__self__, "secret_id", secret_id)
        if vault_token is not None:
            pulumi.set(__self__, "vault_token", vault_token)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        """
        URL of the root of the target Nomad agent.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[pulumi.Input[str]]:
        """
        A path to a PEM-encoded certificate authority used to verify the remote agent's certificate.
        """
        return pulumi.get(self, "ca_file")

    @ca_file.setter
    def ca_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_file", value)

    @property
    @pulumi.getter(name="caPem")
    def ca_pem(self) -> Optional[pulumi.Input[str]]:
        """
        PEM-encoded certificate authority used to verify the remote agent's certificate.
        """
        return pulumi.get(self, "ca_pem")

    @ca_pem.setter
    def ca_pem(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_pem", value)

    @property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> Optional[pulumi.Input[str]]:
        """
        A path to a PEM-encoded certificate provided to the remote agent; requires use of key_file or key_pem.
        """
        return pulumi.get(self, "cert_file")

    @cert_file.setter
    def cert_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert_file", value)

    @property
    @pulumi.getter(name="certPem")
    def cert_pem(self) -> Optional[pulumi.Input[str]]:
        """
        PEM-encoded certificate provided to the remote agent; requires use of key_file or key_pem.
        """
        return pulumi.get(self, "cert_pem")

    @cert_pem.setter
    def cert_pem(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert_pem", value)

    @property
    @pulumi.getter(name="consulToken")
    def consul_token(self) -> Optional[pulumi.Input[str]]:
        """
        Consul token to validate Consul Connect Service Identity policies specified in the job file.
        """
        return pulumi.get(self, "consul_token")

    @consul_token.setter
    def consul_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consul_token", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProviderHeaderArgs']]]]:
        """
        The headers to send with each Nomad request.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProviderHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="httpAuth")
    def http_auth(self) -> Optional[pulumi.Input[str]]:
        """
        HTTP basic auth configuration.
        """
        return pulumi.get(self, "http_auth")

    @http_auth.setter
    def http_auth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_auth", value)

    @property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[pulumi.Input[str]]:
        """
        A path to a PEM-encoded private key, required if cert_file or cert_pem is specified.
        """
        return pulumi.get(self, "key_file")

    @key_file.setter
    def key_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_file", value)

    @property
    @pulumi.getter(name="keyPem")
    def key_pem(self) -> Optional[pulumi.Input[str]]:
        """
        PEM-encoded private key, required if cert_file or cert_pem is specified.
        """
        return pulumi.get(self, "key_pem")

    @key_pem.setter
    def key_pem(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pem", value)

    @property
    @pulumi.getter
    def region(self) -> Optional[pulumi.Input[str]]:
        """
        Region of the target Nomad agent.
        """
        return pulumi.get(self, "region")

    @region.setter
    def region(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region", value)

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[pulumi.Input[str]]:
        """
        ACL token secret for API requests.
        """
        return pulumi.get(self, "secret_id")

    @secret_id.setter
    def secret_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_id", value)

    @property
    @pulumi.getter(name="vaultToken")
    def vault_token(self) -> Optional[pulumi.Input[str]]:
        """
        Vault token if policies are specified in the job file.
        """
        return pulumi.get(self, "vault_token")

    @vault_token.setter
    def vault_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vault_token", value)


class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[str]] = None,
                 ca_file: Optional[pulumi.Input[str]] = None,
                 ca_pem: Optional[pulumi.Input[str]] = None,
                 cert_file: Optional[pulumi.Input[str]] = None,
                 cert_pem: Optional[pulumi.Input[str]] = None,
                 consul_token: Optional[pulumi.Input[str]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProviderHeaderArgs']]]]] = None,
                 http_auth: Optional[pulumi.Input[str]] = None,
                 key_file: Optional[pulumi.Input[str]] = None,
                 key_pem: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secret_id: Optional[pulumi.Input[str]] = None,
                 vault_token: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The provider type for the nomad package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address: URL of the root of the target Nomad agent.
        :param pulumi.Input[str] ca_file: A path to a PEM-encoded certificate authority used to verify the remote agent's certificate.
        :param pulumi.Input[str] ca_pem: PEM-encoded certificate authority used to verify the remote agent's certificate.
        :param pulumi.Input[str] cert_file: A path to a PEM-encoded certificate provided to the remote agent; requires use of key_file or key_pem.
        :param pulumi.Input[str] cert_pem: PEM-encoded certificate provided to the remote agent; requires use of key_file or key_pem.
        :param pulumi.Input[str] consul_token: Consul token to validate Consul Connect Service Identity policies specified in the job file.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProviderHeaderArgs']]]] headers: The headers to send with each Nomad request.
        :param pulumi.Input[str] http_auth: HTTP basic auth configuration.
        :param pulumi.Input[str] key_file: A path to a PEM-encoded private key, required if cert_file or cert_pem is specified.
        :param pulumi.Input[str] key_pem: PEM-encoded private key, required if cert_file or cert_pem is specified.
        :param pulumi.Input[str] region: Region of the target Nomad agent.
        :param pulumi.Input[str] secret_id: ACL token secret for API requests.
        :param pulumi.Input[str] vault_token: Vault token if policies are specified in the job file.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ProviderArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the nomad package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[str]] = None,
                 ca_file: Optional[pulumi.Input[str]] = None,
                 ca_pem: Optional[pulumi.Input[str]] = None,
                 cert_file: Optional[pulumi.Input[str]] = None,
                 cert_pem: Optional[pulumi.Input[str]] = None,
                 consul_token: Optional[pulumi.Input[str]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProviderHeaderArgs']]]]] = None,
                 http_auth: Optional[pulumi.Input[str]] = None,
                 key_file: Optional[pulumi.Input[str]] = None,
                 key_pem: Optional[pulumi.Input[str]] = None,
                 region: Optional[pulumi.Input[str]] = None,
                 secret_id: Optional[pulumi.Input[str]] = None,
                 vault_token: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            if address is None and not opts.urn:
                raise TypeError("Missing required property 'address'")
            __props__.__dict__["address"] = address
            __props__.__dict__["ca_file"] = ca_file
            __props__.__dict__["ca_pem"] = ca_pem
            __props__.__dict__["cert_file"] = cert_file
            __props__.__dict__["cert_pem"] = cert_pem
            __props__.__dict__["consul_token"] = consul_token
            __props__.__dict__["headers"] = pulumi.Output.from_input(headers).apply(pulumi.runtime.to_json) if headers is not None else None
            __props__.__dict__["http_auth"] = http_auth
            __props__.__dict__["key_file"] = key_file
            __props__.__dict__["key_pem"] = key_pem
            __props__.__dict__["region"] = region
            __props__.__dict__["secret_id"] = secret_id
            __props__.__dict__["vault_token"] = vault_token
        super(Provider, __self__).__init__(
            'nomad',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Output[str]:
        """
        URL of the root of the target Nomad agent.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> pulumi.Output[Optional[str]]:
        """
        A path to a PEM-encoded certificate authority used to verify the remote agent's certificate.
        """
        return pulumi.get(self, "ca_file")

    @property
    @pulumi.getter(name="caPem")
    def ca_pem(self) -> pulumi.Output[Optional[str]]:
        """
        PEM-encoded certificate authority used to verify the remote agent's certificate.
        """
        return pulumi.get(self, "ca_pem")

    @property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> pulumi.Output[Optional[str]]:
        """
        A path to a PEM-encoded certificate provided to the remote agent; requires use of key_file or key_pem.
        """
        return pulumi.get(self, "cert_file")

    @property
    @pulumi.getter(name="certPem")
    def cert_pem(self) -> pulumi.Output[Optional[str]]:
        """
        PEM-encoded certificate provided to the remote agent; requires use of key_file or key_pem.
        """
        return pulumi.get(self, "cert_pem")

    @property
    @pulumi.getter(name="consulToken")
    def consul_token(self) -> pulumi.Output[Optional[str]]:
        """
        Consul token to validate Consul Connect Service Identity policies specified in the job file.
        """
        return pulumi.get(self, "consul_token")

    @property
    @pulumi.getter(name="httpAuth")
    def http_auth(self) -> pulumi.Output[Optional[str]]:
        """
        HTTP basic auth configuration.
        """
        return pulumi.get(self, "http_auth")

    @property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> pulumi.Output[Optional[str]]:
        """
        A path to a PEM-encoded private key, required if cert_file or cert_pem is specified.
        """
        return pulumi.get(self, "key_file")

    @property
    @pulumi.getter(name="keyPem")
    def key_pem(self) -> pulumi.Output[Optional[str]]:
        """
        PEM-encoded private key, required if cert_file or cert_pem is specified.
        """
        return pulumi.get(self, "key_pem")

    @property
    @pulumi.getter
    def region(self) -> pulumi.Output[Optional[str]]:
        """
        Region of the target Nomad agent.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> pulumi.Output[Optional[str]]:
        """
        ACL token secret for API requests.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter(name="vaultToken")
    def vault_token(self) -> pulumi.Output[Optional[str]]:
        """
        Vault token if policies are specified in the job file.
        """
        return pulumi.get(self, "vault_token")

