# mcp-chenzhi

辰知MCP工具 (Chenzhi MCP Tool)

这是一个基于 [MCP](https://github.com/agi-merge/mcp) 框架的工具服务器，提供了查询天气和计算加法的功能。

## 功能

- **查询天气**: 通过 `query_weather` 工具，输入城市名称获取实时天气信息。
- **计算加法**: 通过 `add` 工具，计算两个整数的和。

## 安装

1.  克隆本项目到本地:
    ```bash
    git clone https://github.com/chris666-sys/mcp-chenzhi.git
    cd mcp-chenzhi
    ```

2.  安装依赖:
    建议在虚拟环境中使用 pip 安装项目依赖。
    ```bash
    pip install .
    ```
    或者
    ```bash
    pip install -r requirements.txt 
    ```
    (如果项目提供了 `requirements.txt` 文件)

## 使用

### 方式一：通过 uvx 运行（推荐）⭐

**uvx** 是最简单的使用方式，无需手动管理虚拟环境：

```bash
# 直接运行（uvx 会自动下载和管理依赖）
uvx mcp-chenzhi
```

**安装 uv 工具：**
```bash
# macOS/Linux
curl -LsSf https://astral.sh/uv/install.sh | sh

# 或使用 pip
pip install uv

# 或使用 Homebrew (macOS)
brew install uv
```

### 方式二：传统安装运行

```bash
# 安装
pip install mcp-chenzhi

# 运行
mcp-chenzhi
```

## MCP 客户端配置

### Claude Desktop 配置

编辑配置文件 `~/Library/Application Support/Claude/claude_desktop_config.json`：

```json
{
    "mcpServers": {
        "mcp-chenzhi": {
            "command": "uvx",
            "args": ["mcp-chenzhi"]
        }
    }
}
```

### Cline/Continue 配置

在项目的 `.vscode/settings.json` 或 MCP 配置文件中添加：

```json
{
    "mcpServers": {
        "weather-server": {
            "command": "uvx",
            "args": ["mcp-chenzhi"],
            "env": {}
        }
    }
}
```

配置完成后，重启客户端，MCP Agent 就可以连接到此服务器并使用注册的工具。
