# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': '.'}

packages = \
['qq',
 'qq.plugins',
 'qq.plugins.celery',
 'qq.plugins.jsonhack',
 'qq.plugins.jsonhack.tests',
 'qq.plugins.pyramid',
 'qq.plugins.pyramid.tests',
 'qq.plugins.sqlalchemy',
 'qq.plugins.sqlalchemy.tests',
 'qq.plugins.tests',
 'qq.plugins.tornado',
 'qq.tests']

package_data = \
{'': ['*']}

install_requires = \
['marshmallow_dataclass>=8.0.0,<9.0.0', 'python-dateutil>=2.8.2,<3.0.0']

extras_require = \
{'alembic': ['alembic>=1.0.9,<2.0.0'],
 'celery': ['celery>=5.0.0,<6.0.0'],
 'developer': ['alembic>=1.0.9,<2.0.0',
               'sqlalchemy>=1.3.3,<2.0.0',
               'pyramid>=1.10.4,<2.0.0',
               'redis>=3.2.1,<4.0.0',
               'celery>=5.0.0,<6.0.0'],
 'pyramid': ['pyramid>=1.10.4,<2.0.0'],
 'redis': ['redis>=3.2.1,<4.0.0'],
 'sqlalchemy': ['sqlalchemy>=1.3.3,<2.0.0']}

setup_kwargs = {
    'name': 'quackquack',
    'version': '1.0.5',
    'description': 'Quack Quack: A simple application framework',
    'long_description': 'About\n=====\n\n`Documentation <https://qqpy.org/>`_\n\n\nOverview\n--------\n\nThis project aims to resolve problem of configuring an application, which needs to\nhave initialization step (for example: for gathering settings or establishing\nconnections) and use Python style code (context managers and decorators) to get\nthose data.\n\nFor example, normally you would need to use two separate mechanism for settings\nin celery application and web application, because you should not use web\napplication startup process in the celery app. This package provide a solution\nfor this problem, by giving one simple and independent of other frameworks\nmechanism to implement everywhere.\n\nQuick Using Example\n-------------------\n\nTo use Quack Quack you need to create the application class (inherited from\n``qq.Application``\\ ) in which you need to add plugins. After configuring, you need to "start"\nthe application. After that you can use the configurator as context manager.\n\n.. code-block:: python\n\n    from qq import Application, Context, InjectApplication, SimpleInjector\n    from qq.plugins import SettingsPlugin\n    from qq.plugins.types import Settings\n\n    class MyApplication(Application):\n        def create_plugins(self):\n            self.plugins["settings"] = SettingsPlugin(\'settings\')\n\n    application = MyApplication()\n    application.start(\'application\')\n\n    with Context(application) as ctx:\n        print(ctx["settings"])\n\n    @InjectApplication(application)\n    def samplefun(settings: Settings = SimpleInjector("settings")):\n        print(settings)\n\n\n\n``context.settings`` in above example is variable made by the SettingsPlugin.\nIf you would like to know more, please go to the `Tutorial <https://qqpy.org/docs/tutorial.html>`_\n\nInstallation\n------------\n\n.. code-block:: bash\n\n   pip install quackquack\n',
    'author': 'Dominik Dlugajczyk',
    'author_email': 'msocek@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/socek/quackquack',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
