# Generated by Django 3.1.13 on 2021-11-15 13:10

import django.core.serializers.json
from django.db import migrations, models
import django.db.models.deletion
import nautobot.core.fields
import taggit.managers
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ("extras", "0015_scheduled_job"),
    ]

    operations = [
        migrations.CreateModel(
            name="Secret",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("name", models.CharField(max_length=100, unique=True)),
                (
                    "slug",
                    nautobot.core.fields.AutoSlugField(blank=True, max_length=100, populate_from="name", unique=True),
                ),
                ("description", models.CharField(blank=True, max_length=200)),
                ("provider", models.CharField(max_length=100)),
                ("parameters", models.JSONField(default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder)),
                ("tags", taggit.managers.TaggableManager(through="extras.TaggedItem", to="extras.Tag")),
            ],
            options={
                "ordering": ["name"],
            },
        ),
        migrations.CreateModel(
            name="SecretsGroup",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("created", models.DateField(auto_now_add=True, null=True)),
                ("last_updated", models.DateTimeField(auto_now=True, null=True)),
                (
                    "_custom_field_data",
                    models.JSONField(blank=True, default=dict, encoder=django.core.serializers.json.DjangoJSONEncoder),
                ),
                ("name", models.CharField(max_length=100, unique=True)),
                (
                    "slug",
                    nautobot.core.fields.AutoSlugField(blank=True, max_length=100, populate_from="name", unique=True),
                ),
                ("description", models.CharField(blank=True, max_length=200)),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="SecretsGroupAssociation",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True
                    ),
                ),
                ("access_type", models.CharField(max_length=32)),
                ("secret_type", models.CharField(max_length=32)),
                ("group", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="extras.secretsgroup")),
                ("secret", models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="extras.secret")),
            ],
            options={
                "ordering": ("group", "access_type", "secret_type"),
                "unique_together": {("group", "access_type", "secret_type")},
            },
        ),
        migrations.AddField(
            model_name="secretsgroup",
            name="secrets",
            field=models.ManyToManyField(
                blank=True, related_name="groups", through="extras.SecretsGroupAssociation", to="extras.Secret"
            ),
        ),
        migrations.AddField(
            model_name="gitrepository",
            name="secrets_group",
            field=models.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="extras.secretsgroup",
            ),
        ),
    ]
