import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BillingBudgetConfig extends cdktf.TerraformMetaArguments {
    /**
     * ID of the billing account to set a budget on.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#billing_account BillingBudget#billing_account}
     *
     * @stability stable
     */
    readonly billingAccount: string;
    /**
     * User data for display name in UI. Must be <= 60 chars.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#display_name BillingBudget#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * all_updates_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#all_updates_rule BillingBudget#all_updates_rule}
     *
     * @stability stable
     */
    readonly allUpdatesRule?: BillingBudgetAllUpdatesRule;
    /**
     * amount block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#amount BillingBudget#amount}
     *
     * @stability stable
     */
    readonly amount: BillingBudgetAmount;
    /**
     * budget_filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#budget_filter BillingBudget#budget_filter}
     *
     * @stability stable
     */
    readonly budgetFilter?: BillingBudgetBudgetFilter;
    /**
     * threshold_rules block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#threshold_rules BillingBudget#threshold_rules}
     *
     * @stability stable
     */
    readonly thresholdRules: BillingBudgetThresholdRules[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#timeouts BillingBudget#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BillingBudgetTimeouts;
}
/**
 * @stability stable
 */
export interface BillingBudgetAllUpdatesRule {
    /**
     * Boolean.
     *
     * When set to true, disables default notifications sent
     * when a threshold is exceeded. Default recipients are
     * those with Billing Account Administrators and Billing
     * Account Users IAM roles for the target account.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#disable_default_iam_recipients BillingBudget#disable_default_iam_recipients}
     *
     * @stability stable
     */
    readonly disableDefaultIamRecipients?: boolean | cdktf.IResolvable;
    /**
     * The full resource name of a monitoring notification channel in the form projects/{project_id}/notificationChannels/{channel_id}. A maximum of 5 channels are allowed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#monitoring_notification_channels BillingBudget#monitoring_notification_channels}
     *
     * @stability stable
     */
    readonly monitoringNotificationChannels?: string[];
    /**
     * The name of the Cloud Pub/Sub topic where budget related messages will be published, in the form projects/{project_id}/topics/{topic_id}.
     *
     * Updates are sent
     * at regular intervals to the topic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#pubsub_topic BillingBudget#pubsub_topic}
     *
     * @stability stable
     */
    readonly pubsubTopic?: string;
    /**
     * The schema version of the notification. Only "1.0" is accepted. It represents the JSON schema as defined in https://cloud.google.com/billing/docs/how-to/budgets#notification_format.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#schema_version BillingBudget#schema_version}
     *
     * @stability stable
     */
    readonly schemaVersion?: string;
}
/**
 * @stability stable
 */
export declare class BillingBudgetAllUpdatesRuleOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _disableDefaultIamRecipients?;
    /**
     * @stability stable
     */
    get disableDefaultIamRecipients(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set disableDefaultIamRecipients(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetDisableDefaultIamRecipients(): void;
    /**
     * @stability stable
     */
    get disableDefaultIamRecipientsInput(): boolean | cdktf.IResolvable | undefined;
    private _monitoringNotificationChannels?;
    /**
     * @stability stable
     */
    get monitoringNotificationChannels(): string[] | undefined;
    /**
     * @stability stable
     */
    set monitoringNotificationChannels(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetMonitoringNotificationChannels(): void;
    /**
     * @stability stable
     */
    get monitoringNotificationChannelsInput(): string[] | undefined;
    private _pubsubTopic?;
    /**
     * @stability stable
     */
    get pubsubTopic(): string | undefined;
    /**
     * @stability stable
     */
    set pubsubTopic(value: string | undefined);
    /**
     * @stability stable
     */
    resetPubsubTopic(): void;
    /**
     * @stability stable
     */
    get pubsubTopicInput(): string | undefined;
    private _schemaVersion?;
    /**
     * @stability stable
     */
    get schemaVersion(): string | undefined;
    /**
     * @stability stable
     */
    set schemaVersion(value: string | undefined);
    /**
     * @stability stable
     */
    resetSchemaVersion(): void;
    /**
     * @stability stable
     */
    get schemaVersionInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BillingBudgetAmountSpecifiedAmount {
    /**
     * The 3-letter currency code defined in ISO 4217.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#currency_code BillingBudget#currency_code}
     *
     * @stability stable
     */
    readonly currencyCode?: string;
    /**
     * Number of nano (10^-9) units of the amount.
     *
     * The value must be between -999,999,999 and +999,999,999
     * inclusive. If units is positive, nanos must be positive or
     * zero. If units is zero, nanos can be positive, zero, or
     * negative. If units is negative, nanos must be negative or
     * zero. For example $-1.75 is represented as units=-1 and
     * nanos=-750,000,000.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#nanos BillingBudget#nanos}
     *
     * @stability stable
     */
    readonly nanos?: number;
    /**
     * The whole units of the amount. For example if currencyCode is "USD", then 1 unit is one US dollar.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#units BillingBudget#units}
     *
     * @stability stable
     */
    readonly units?: string;
}
/**
 * @stability stable
 */
export declare class BillingBudgetAmountSpecifiedAmountOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _currencyCode?;
    /**
     * @stability stable
     */
    get currencyCode(): string | undefined;
    /**
     * @stability stable
     */
    set currencyCode(value: string | undefined);
    /**
     * @stability stable
     */
    resetCurrencyCode(): void;
    /**
     * @stability stable
     */
    get currencyCodeInput(): string | undefined;
    private _nanos?;
    /**
     * @stability stable
     */
    get nanos(): number | undefined;
    /**
     * @stability stable
     */
    set nanos(value: number | undefined);
    /**
     * @stability stable
     */
    resetNanos(): void;
    /**
     * @stability stable
     */
    get nanosInput(): number | undefined;
    private _units?;
    /**
     * @stability stable
     */
    get units(): string | undefined;
    /**
     * @stability stable
     */
    set units(value: string | undefined);
    /**
     * @stability stable
     */
    resetUnits(): void;
    /**
     * @stability stable
     */
    get unitsInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BillingBudgetAmount {
    /**
     * Configures a budget amount that is automatically set to 100% of last period's spend.
     *
     * Boolean. Set value to true to use. Do not set to false, instead
     * use the 'specified_amount' block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#last_period_amount BillingBudget#last_period_amount}
     *
     * @stability stable
     */
    readonly lastPeriodAmount?: boolean | cdktf.IResolvable;
    /**
     * specified_amount block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#specified_amount BillingBudget#specified_amount}
     *
     * @stability stable
     */
    readonly specifiedAmount?: BillingBudgetAmountSpecifiedAmount;
}
/**
 * @stability stable
 */
export declare class BillingBudgetAmountOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _lastPeriodAmount?;
    /**
     * @stability stable
     */
    get lastPeriodAmount(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set lastPeriodAmount(value: boolean | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetLastPeriodAmount(): void;
    /**
     * @stability stable
     */
    get lastPeriodAmountInput(): boolean | cdktf.IResolvable | undefined;
    private _specifiedAmount?;
    private __specifiedAmountOutput;
    /**
     * @stability stable
     */
    get specifiedAmount(): BillingBudgetAmountSpecifiedAmountOutputReference;
    /**
     * @stability stable
     */
    putSpecifiedAmount(value: BillingBudgetAmountSpecifiedAmount | undefined): void;
    /**
     * @stability stable
     */
    resetSpecifiedAmount(): void;
    /**
     * @stability stable
     */
    get specifiedAmountInput(): BillingBudgetAmountSpecifiedAmount | undefined;
}
/**
 * @stability stable
 */
export interface BillingBudgetBudgetFilter {
    /**
     * A set of subaccounts of the form billingAccounts/{account_id}, specifying that usage from only this set of subaccounts should be included in the budget.
     *
     * If a subaccount is set to the name of
     * the parent account, usage from the parent account will be included.
     * If the field is omitted, the report will include usage from the parent
     * account and all subaccounts, if they exist.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#credit_types BillingBudget#credit_types}
     *
     * @stability stable
     */
    readonly creditTypes?: string[];
    /**
     * Specifies how credits should be treated when determining spend for threshold calculations. Default value: "INCLUDE_ALL_CREDITS" Possible values: ["INCLUDE_ALL_CREDITS", "EXCLUDE_ALL_CREDITS", "INCLUDE_SPECIFIED_CREDITS"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#credit_types_treatment BillingBudget#credit_types_treatment}
     *
     * @stability stable
     */
    readonly creditTypesTreatment?: string;
    /**
     * A single label and value pair specifying that usage from only this set of labeled resources should be included in the budget.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#labels BillingBudget#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * A set of projects of the form projects/{project_number}, specifying that usage from only this set of projects should be included in the budget.
     *
     * If omitted, the report will include
     * all usage for the billing account, regardless of which project
     * the usage occurred on.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#projects BillingBudget#projects}
     *
     * @stability stable
     */
    readonly projects?: string[];
    /**
     * A set of services of the form services/{service_id}, specifying that usage from only this set of services should be included in the budget.
     *
     * If omitted, the report will include
     * usage for all the services. The service names are available
     * through the Catalog API:
     * https://cloud.google.com/billing/v1/how-tos/catalog-api.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#services BillingBudget#services}
     *
     * @stability stable
     */
    readonly services?: string[];
    /**
     * A set of subaccounts of the form billingAccounts/{account_id}, specifying that usage from only this set of subaccounts should be included in the budget.
     *
     * If a subaccount is set to the name of
     * the parent account, usage from the parent account will be included.
     * If the field is omitted, the report will include usage from the parent
     * account and all subaccounts, if they exist.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#subaccounts BillingBudget#subaccounts}
     *
     * @stability stable
     */
    readonly subaccounts?: string[];
}
/**
 * @stability stable
 */
export declare class BillingBudgetBudgetFilterOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _creditTypes?;
    /**
     * @stability stable
     */
    get creditTypes(): string[] | undefined;
    /**
     * @stability stable
     */
    set creditTypes(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetCreditTypes(): void;
    /**
     * @stability stable
     */
    get creditTypesInput(): string[] | undefined;
    private _creditTypesTreatment?;
    /**
     * @stability stable
     */
    get creditTypesTreatment(): string | undefined;
    /**
     * @stability stable
     */
    set creditTypesTreatment(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreditTypesTreatment(): void;
    /**
     * @stability stable
     */
    get creditTypesTreatmentInput(): string | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable | undefined);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _projects?;
    /**
     * @stability stable
     */
    get projects(): string[] | undefined;
    /**
     * @stability stable
     */
    set projects(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetProjects(): void;
    /**
     * @stability stable
     */
    get projectsInput(): string[] | undefined;
    private _services?;
    /**
     * @stability stable
     */
    get services(): string[] | undefined;
    /**
     * @stability stable
     */
    set services(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetServices(): void;
    /**
     * @stability stable
     */
    get servicesInput(): string[] | undefined;
    private _subaccounts?;
    /**
     * @stability stable
     */
    get subaccounts(): string[] | undefined;
    /**
     * @stability stable
     */
    set subaccounts(value: string[] | undefined);
    /**
     * @stability stable
     */
    resetSubaccounts(): void;
    /**
     * @stability stable
     */
    get subaccountsInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface BillingBudgetThresholdRules {
    /**
     * The type of basis used to determine if spend has passed the threshold. Default value: "CURRENT_SPEND" Possible values: ["CURRENT_SPEND", "FORECASTED_SPEND"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#spend_basis BillingBudget#spend_basis}
     *
     * @stability stable
     */
    readonly spendBasis?: string;
    /**
     * Send an alert when this threshold is exceeded.
     *
     * This is a
     * 1.0-based percentage, so 0.5 = 50%. Must be >= 0.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#threshold_percent BillingBudget#threshold_percent}
     *
     * @stability stable
     */
    readonly thresholdPercent: number;
}
/**
 * @stability stable
 */
export interface BillingBudgetTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#create BillingBudget#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#delete BillingBudget#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html#update BillingBudget#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class BillingBudgetTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html google_billing_budget}.
 *
 * @stability stable
 */
export declare class BillingBudget extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/billing_budget.html google_billing_budget} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BillingBudgetConfig);
    private _billingAccount?;
    /**
     * @stability stable
     */
    get billingAccount(): string;
    /**
     * @stability stable
     */
    set billingAccount(value: string);
    /**
     * @stability stable
     */
    get billingAccountInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string | undefined;
    /**
     * @stability stable
     */
    set displayName(value: string | undefined);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _allUpdatesRule?;
    private __allUpdatesRuleOutput;
    /**
     * @stability stable
     */
    get allUpdatesRule(): BillingBudgetAllUpdatesRuleOutputReference;
    /**
     * @stability stable
     */
    putAllUpdatesRule(value: BillingBudgetAllUpdatesRule | undefined): void;
    /**
     * @stability stable
     */
    resetAllUpdatesRule(): void;
    /**
     * @stability stable
     */
    get allUpdatesRuleInput(): BillingBudgetAllUpdatesRule | undefined;
    private _amount?;
    private __amountOutput;
    /**
     * @stability stable
     */
    get amount(): BillingBudgetAmountOutputReference;
    /**
     * @stability stable
     */
    putAmount(value: BillingBudgetAmount): void;
    /**
     * @stability stable
     */
    get amountInput(): BillingBudgetAmount | undefined;
    private _budgetFilter?;
    private __budgetFilterOutput;
    /**
     * @stability stable
     */
    get budgetFilter(): BillingBudgetBudgetFilterOutputReference;
    /**
     * @stability stable
     */
    putBudgetFilter(value: BillingBudgetBudgetFilter | undefined): void;
    /**
     * @stability stable
     */
    resetBudgetFilter(): void;
    /**
     * @stability stable
     */
    get budgetFilterInput(): BillingBudgetBudgetFilter | undefined;
    private _thresholdRules?;
    /**
     * @stability stable
     */
    get thresholdRules(): BillingBudgetThresholdRules[];
    /**
     * @stability stable
     */
    set thresholdRules(value: BillingBudgetThresholdRules[]);
    /**
     * @stability stable
     */
    get thresholdRulesInput(): BillingBudgetThresholdRules[] | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): BillingBudgetTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: BillingBudgetTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BillingBudgetTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
