import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface MonitoringCustomServiceConfig extends cdktf.TerraformMetaArguments {
    /**
     * Name used for UI elements listing this Service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service.html#display_name MonitoringCustomService#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service.html#project MonitoringCustomService#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * An optional service ID to use. If not given, the server will generate a service ID.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service.html#service_id MonitoringCustomService#service_id}
     *
     * @stability stable
     */
    readonly serviceId?: string;
    /**
     * telemetry block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service.html#telemetry MonitoringCustomService#telemetry}
     *
     * @stability stable
     */
    readonly telemetry?: MonitoringCustomServiceTelemetry;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service.html#timeouts MonitoringCustomService#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: MonitoringCustomServiceTimeouts;
}
/**
 * @stability stable
 */
export interface MonitoringCustomServiceTelemetry {
    /**
     * The full name of the resource that defines this service. Formatted as described in https://cloud.google.com/apis/design/resource_names.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service.html#resource_name MonitoringCustomService#resource_name}
     *
     * @stability stable
     */
    readonly resourceName?: string;
}
/**
 * @stability stable
 */
export declare class MonitoringCustomServiceTelemetryOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _resourceName?;
    /**
     * @stability stable
     */
    get resourceName(): string | undefined;
    /**
     * @stability stable
     */
    set resourceName(value: string | undefined);
    /**
     * @stability stable
     */
    resetResourceName(): void;
    /**
     * @stability stable
     */
    get resourceNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface MonitoringCustomServiceTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service.html#create MonitoringCustomService#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service.html#delete MonitoringCustomService#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service.html#update MonitoringCustomService#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
/**
 * @stability stable
 */
export declare class MonitoringCustomServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string | undefined;
    /**
     * @stability stable
     */
    set create(value: string | undefined);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string | undefined;
    /**
     * @stability stable
     */
    set delete(value: string | undefined);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string | undefined;
    /**
     * @stability stable
     */
    set update(value: string | undefined);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service.html google_monitoring_custom_service}.
 *
 * @stability stable
 */
export declare class MonitoringCustomService extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/monitoring_custom_service.html google_monitoring_custom_service} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config?: MonitoringCustomServiceConfig);
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string | undefined;
    /**
     * @stability stable
     */
    set displayName(value: string | undefined);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string | undefined;
    /**
     * @stability stable
     */
    set project(value: string | undefined);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _serviceId?;
    /**
     * @stability stable
     */
    get serviceId(): string | undefined;
    /**
     * @stability stable
     */
    set serviceId(value: string | undefined);
    /**
     * @stability stable
     */
    resetServiceId(): void;
    /**
     * @stability stable
     */
    get serviceIdInput(): string | undefined;
    private _telemetry?;
    private __telemetryOutput;
    /**
     * @stability stable
     */
    get telemetry(): MonitoringCustomServiceTelemetryOutputReference;
    /**
     * @stability stable
     */
    putTelemetry(value: MonitoringCustomServiceTelemetry | undefined): void;
    /**
     * @stability stable
     */
    resetTelemetry(): void;
    /**
     * @stability stable
     */
    get telemetryInput(): MonitoringCustomServiceTelemetry | undefined;
    private _timeouts?;
    private __timeoutsOutput;
    /**
     * @stability stable
     */
    get timeouts(): MonitoringCustomServiceTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: MonitoringCustomServiceTimeouts | undefined): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): MonitoringCustomServiceTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
