"""Pre-calculated tables."""
from .dptables import CHOOSE, DP, SUITS
from .hashtable import FLUSH
from .hashtable5 import NO_FLUSH_5
from .hashtable6 import NO_FLUSH_6
from .hashtable7 import NO_FLUSH_7
from .hashtable_omaha import FLUSH_OMAHA, NO_FLUSH_OMAHA

__all__ = [
    "BINARIES_BY_ID",
    "CHOOSE",
    "DP",
    "SUITBIT_BY_ID",
    "SUITS",
    "FLUSH",
    "NO_FLUSH_5",
    "NO_FLUSH_6",
    "NO_FLUSH_7",
    "FLUSH_OMAHA",
    "NO_FLUSH_OMAHA",
]

# fmt: off
BINARIES_BY_ID = [
    0x1, 0x1, 0x1, 0x1,
    0x2, 0x2, 0x2, 0x2,
    0x4, 0x4, 0x4, 0x4,
    0x8, 0x8, 0x8, 0x8,
    0x10, 0x10, 0x10, 0x10,
    0x20, 0x20, 0x20, 0x20,
    0x40, 0x40, 0x40, 0x40,
    0x80, 0x80, 0x80, 0x80,
    0x100, 0x100, 0x100, 0x100,
    0x200, 0x200, 0x200, 0x200,
    0x400, 0x400, 0x400, 0x400,
    0x800, 0x800, 0x800, 0x800,
    0x1000, 0x1000, 0x1000, 0x1000,
]

SUITBIT_BY_ID = [0x1, 0x8, 0x40, 0x200] * 13
# fmt: on
