# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class UserDefinedMessageSubscriptionList(ListResource):

    def __init__(self, version, account_sid, call_sid):
        """
        Initialize the UserDefinedMessageSubscriptionList

        :param Version version: Version that contains the resource
        :param account_sid: Account SID.
        :param call_sid: Call SID.

        :returns: twilio.rest.api.v2010.account.call.user_defined_message_subscription.UserDefinedMessageSubscriptionList
        :rtype: twilio.rest.api.v2010.account.call.user_defined_message_subscription.UserDefinedMessageSubscriptionList
        """
        super(UserDefinedMessageSubscriptionList, self).__init__(version)

        # Path Solution
        self._solution = {'account_sid': account_sid, 'call_sid': call_sid, }
        self._uri = '/Accounts/{account_sid}/Calls/{call_sid}/UserDefinedMessageSubscriptions.json'.format(**self._solution)

    def create(self, callback, method, idempotency_key=values.unset):
        """
        Create the UserDefinedMessageSubscriptionInstance

        :param unicode callback: The URL we should call to send user defined messages.
        :param unicode method: HTTP method used with the callback.
        :param unicode idempotency_key: A unique string value to identify API call. This should be a unique string value per API call and can be a randomly generated.

        :returns: The created UserDefinedMessageSubscriptionInstance
        :rtype: twilio.rest.api.v2010.account.call.user_defined_message_subscription.UserDefinedMessageSubscriptionInstance
        """
        data = values.of({'Callback': callback, 'Method': method, 'IdempotencyKey': idempotency_key, })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return UserDefinedMessageSubscriptionInstance(
            self._version,
            payload,
            account_sid=self._solution['account_sid'],
            call_sid=self._solution['call_sid'],
        )

    def get(self, sid):
        """
        Constructs a UserDefinedMessageSubscriptionContext

        :param sid: User Defined Message Subscription SID.

        :returns: twilio.rest.api.v2010.account.call.user_defined_message_subscription.UserDefinedMessageSubscriptionContext
        :rtype: twilio.rest.api.v2010.account.call.user_defined_message_subscription.UserDefinedMessageSubscriptionContext
        """
        return UserDefinedMessageSubscriptionContext(
            self._version,
            account_sid=self._solution['account_sid'],
            call_sid=self._solution['call_sid'],
            sid=sid,
        )

    def __call__(self, sid):
        """
        Constructs a UserDefinedMessageSubscriptionContext

        :param sid: User Defined Message Subscription SID.

        :returns: twilio.rest.api.v2010.account.call.user_defined_message_subscription.UserDefinedMessageSubscriptionContext
        :rtype: twilio.rest.api.v2010.account.call.user_defined_message_subscription.UserDefinedMessageSubscriptionContext
        """
        return UserDefinedMessageSubscriptionContext(
            self._version,
            account_sid=self._solution['account_sid'],
            call_sid=self._solution['call_sid'],
            sid=sid,
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Api.V2010.UserDefinedMessageSubscriptionList>'


class UserDefinedMessageSubscriptionPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the UserDefinedMessageSubscriptionPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param account_sid: Account SID.
        :param call_sid: Call SID.

        :returns: twilio.rest.api.v2010.account.call.user_defined_message_subscription.UserDefinedMessageSubscriptionPage
        :rtype: twilio.rest.api.v2010.account.call.user_defined_message_subscription.UserDefinedMessageSubscriptionPage
        """
        super(UserDefinedMessageSubscriptionPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of UserDefinedMessageSubscriptionInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.api.v2010.account.call.user_defined_message_subscription.UserDefinedMessageSubscriptionInstance
        :rtype: twilio.rest.api.v2010.account.call.user_defined_message_subscription.UserDefinedMessageSubscriptionInstance
        """
        return UserDefinedMessageSubscriptionInstance(
            self._version,
            payload,
            account_sid=self._solution['account_sid'],
            call_sid=self._solution['call_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Api.V2010.UserDefinedMessageSubscriptionPage>'


class UserDefinedMessageSubscriptionContext(InstanceContext):

    def __init__(self, version, account_sid, call_sid, sid):
        """
        Initialize the UserDefinedMessageSubscriptionContext

        :param Version version: Version that contains the resource
        :param account_sid: Account SID.
        :param call_sid: Call SID.
        :param sid: User Defined Message Subscription SID.

        :returns: twilio.rest.api.v2010.account.call.user_defined_message_subscription.UserDefinedMessageSubscriptionContext
        :rtype: twilio.rest.api.v2010.account.call.user_defined_message_subscription.UserDefinedMessageSubscriptionContext
        """
        super(UserDefinedMessageSubscriptionContext, self).__init__(version)

        # Path Solution
        self._solution = {'account_sid': account_sid, 'call_sid': call_sid, 'sid': sid, }
        self._uri = '/Accounts/{account_sid}/Calls/{call_sid}/UserDefinedMessageSubscriptions/{sid}.json'.format(**self._solution)

    def delete(self):
        """
        Deletes the UserDefinedMessageSubscriptionInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._version.delete(method='DELETE', uri=self._uri, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Api.V2010.UserDefinedMessageSubscriptionContext {}>'.format(context)


class UserDefinedMessageSubscriptionInstance(InstanceResource):

    def __init__(self, version, payload, account_sid, call_sid, sid=None):
        """
        Initialize the UserDefinedMessageSubscriptionInstance

        :returns: twilio.rest.api.v2010.account.call.user_defined_message_subscription.UserDefinedMessageSubscriptionInstance
        :rtype: twilio.rest.api.v2010.account.call.user_defined_message_subscription.UserDefinedMessageSubscriptionInstance
        """
        super(UserDefinedMessageSubscriptionInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'account_sid': payload.get('account_sid'),
            'call_sid': payload.get('call_sid'),
            'sid': payload.get('sid'),
            'date_created': deserialize.rfc2822_datetime(payload.get('date_created')),
            'uri': payload.get('uri'),
        }

        # Context
        self._context = None
        self._solution = {
            'account_sid': account_sid,
            'call_sid': call_sid,
            'sid': sid or self._properties['sid'],
        }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: UserDefinedMessageSubscriptionContext for this UserDefinedMessageSubscriptionInstance
        :rtype: twilio.rest.api.v2010.account.call.user_defined_message_subscription.UserDefinedMessageSubscriptionContext
        """
        if self._context is None:
            self._context = UserDefinedMessageSubscriptionContext(
                self._version,
                account_sid=self._solution['account_sid'],
                call_sid=self._solution['call_sid'],
                sid=self._solution['sid'],
            )
        return self._context

    @property
    def account_sid(self):
        """
        :returns: Account SID.
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def call_sid(self):
        """
        :returns: Call SID.
        :rtype: unicode
        """
        return self._properties['call_sid']

    @property
    def sid(self):
        """
        :returns: User Defined Message Subscription SID.
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def date_created(self):
        """
        :returns: The date this User Defined Message Subscription was created.
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def uri(self):
        """
        :returns: The URI of the User Defined Message Subscription Resource, relative to `https://api.twilio.com`.
        :rtype: unicode
        """
        return self._properties['uri']

    def delete(self):
        """
        Deletes the UserDefinedMessageSubscriptionInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._proxy.delete()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Api.V2010.UserDefinedMessageSubscriptionInstance {}>'.format(context)
