# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.version import Version
from twilio.rest.chat.v3.channel import ChannelList


class V3(Version):

    def __init__(self, domain):
        """
        Initialize the V3 version of Chat

        :returns: V3 version of Chat
        :rtype: twilio.rest.chat.v3.V3.V3
        """
        super(V3, self).__init__(domain)
        self.version = 'v3'
        self._channels = None

    @property
    def channels(self):
        """
        :rtype: twilio.rest.chat.v3.channel.ChannelList
        """
        if self._channels is None:
            self._channels = ChannelList(self)
        return self._channels

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Chat.V3>'
