# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class ApprovalFetchList(ListResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, sid):
        """
        Initialize the ApprovalFetchList

        :param Version version: Version that contains the resource
        :param sid: The unique string that identifies the Content resource

        :returns: twilio.rest.content.v1.content.approval_fetch.ApprovalFetchList
        :rtype: twilio.rest.content.v1.content.approval_fetch.ApprovalFetchList
        """
        super(ApprovalFetchList, self).__init__(version)

        # Path Solution
        self._solution = {'sid': sid, }

    def get(self):
        """
        Constructs a ApprovalFetchContext

        :returns: twilio.rest.content.v1.content.approval_fetch.ApprovalFetchContext
        :rtype: twilio.rest.content.v1.content.approval_fetch.ApprovalFetchContext
        """
        return ApprovalFetchContext(self._version, sid=self._solution['sid'], )

    def __call__(self):
        """
        Constructs a ApprovalFetchContext

        :returns: twilio.rest.content.v1.content.approval_fetch.ApprovalFetchContext
        :rtype: twilio.rest.content.v1.content.approval_fetch.ApprovalFetchContext
        """
        return ApprovalFetchContext(self._version, sid=self._solution['sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Content.V1.ApprovalFetchList>'


class ApprovalFetchPage(Page):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, response, solution):
        """
        Initialize the ApprovalFetchPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param sid: The unique string that identifies the Content resource

        :returns: twilio.rest.content.v1.content.approval_fetch.ApprovalFetchPage
        :rtype: twilio.rest.content.v1.content.approval_fetch.ApprovalFetchPage
        """
        super(ApprovalFetchPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of ApprovalFetchInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.content.v1.content.approval_fetch.ApprovalFetchInstance
        :rtype: twilio.rest.content.v1.content.approval_fetch.ApprovalFetchInstance
        """
        return ApprovalFetchInstance(self._version, payload, sid=self._solution['sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Content.V1.ApprovalFetchPage>'


class ApprovalFetchContext(InstanceContext):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, sid):
        """
        Initialize the ApprovalFetchContext

        :param Version version: Version that contains the resource
        :param sid: The unique string that identifies the Content resource

        :returns: twilio.rest.content.v1.content.approval_fetch.ApprovalFetchContext
        :rtype: twilio.rest.content.v1.content.approval_fetch.ApprovalFetchContext
        """
        super(ApprovalFetchContext, self).__init__(version)

        # Path Solution
        self._solution = {'sid': sid, }
        self._uri = '/Content/{sid}/ApprovalRequests'.format(**self._solution)

    def fetch(self):
        """
        Fetch the ApprovalFetchInstance

        :returns: The fetched ApprovalFetchInstance
        :rtype: twilio.rest.content.v1.content.approval_fetch.ApprovalFetchInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return ApprovalFetchInstance(self._version, payload, sid=self._solution['sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Content.V1.ApprovalFetchContext {}>'.format(context)


class ApprovalFetchInstance(InstanceResource):
    """ PLEASE NOTE that this class contains preview products that are subject
    to change. Use them with caution. If you currently do not have developer
    preview access, please contact help@twilio.com. """

    def __init__(self, version, payload, sid):
        """
        Initialize the ApprovalFetchInstance

        :returns: twilio.rest.content.v1.content.approval_fetch.ApprovalFetchInstance
        :rtype: twilio.rest.content.v1.content.approval_fetch.ApprovalFetchInstance
        """
        super(ApprovalFetchInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'sid': payload.get('sid'),
            'account_sid': payload.get('account_sid'),
            'whatsapp': payload.get('whatsapp'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {'sid': sid, }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: ApprovalFetchContext for this ApprovalFetchInstance
        :rtype: twilio.rest.content.v1.content.approval_fetch.ApprovalFetchContext
        """
        if self._context is None:
            self._context = ApprovalFetchContext(self._version, sid=self._solution['sid'], )
        return self._context

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the Content resource
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def account_sid(self):
        """
        :returns: The SID of the Account that created the Content resource
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def whatsapp(self):
        """
        :returns: Contains the whatsapp approval information for the Content resource
        :rtype: dict
        """
        return self._properties['whatsapp']

    @property
    def url(self):
        """
        :returns: The URL of the resource, relative to `https://content.twilio.com`
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self):
        """
        Fetch the ApprovalFetchInstance

        :returns: The fetched ApprovalFetchInstance
        :rtype: twilio.rest.content.v1.content.approval_fetch.ApprovalFetchInstance
        """
        return self._proxy.fetch()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Content.V1.ApprovalFetchInstance {}>'.format(context)
