# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class AssessmentsList(ListResource):

    def __init__(self, version):
        """
        Initialize the AssessmentsList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.flex_api.v1.assessments.AssessmentsList
        :rtype: twilio.rest.flex_api.v1.assessments.AssessmentsList
        """
        super(AssessmentsList, self).__init__(version)

        # Path Solution
        self._solution = {}

    def get(self):
        """
        Constructs a AssessmentsContext

        :returns: twilio.rest.flex_api.v1.assessments.AssessmentsContext
        :rtype: twilio.rest.flex_api.v1.assessments.AssessmentsContext
        """
        return AssessmentsContext(self._version, )

    def __call__(self):
        """
        Constructs a AssessmentsContext

        :returns: twilio.rest.flex_api.v1.assessments.AssessmentsContext
        :rtype: twilio.rest.flex_api.v1.assessments.AssessmentsContext
        """
        return AssessmentsContext(self._version, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FlexApi.V1.AssessmentsList>'


class AssessmentsPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the AssessmentsPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.flex_api.v1.assessments.AssessmentsPage
        :rtype: twilio.rest.flex_api.v1.assessments.AssessmentsPage
        """
        super(AssessmentsPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of AssessmentsInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.flex_api.v1.assessments.AssessmentsInstance
        :rtype: twilio.rest.flex_api.v1.assessments.AssessmentsInstance
        """
        return AssessmentsInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FlexApi.V1.AssessmentsPage>'


class AssessmentsContext(InstanceContext):

    def __init__(self, version):
        """
        Initialize the AssessmentsContext

        :param Version version: Version that contains the resource

        :returns: twilio.rest.flex_api.v1.assessments.AssessmentsContext
        :rtype: twilio.rest.flex_api.v1.assessments.AssessmentsContext
        """
        super(AssessmentsContext, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/Accounts/Assessments'.format(**self._solution)

    def create(self):
        """
        Create the AssessmentsInstance

        :returns: The created AssessmentsInstance
        :rtype: twilio.rest.flex_api.v1.assessments.AssessmentsInstance
        """
        payload = self._version.create(method='POST', uri=self._uri, )

        return AssessmentsInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.FlexApi.V1.AssessmentsContext {}>'.format(context)


class AssessmentsInstance(InstanceResource):

    def __init__(self, version, payload):
        """
        Initialize the AssessmentsInstance

        :returns: twilio.rest.flex_api.v1.assessments.AssessmentsInstance
        :rtype: twilio.rest.flex_api.v1.assessments.AssessmentsInstance
        """
        super(AssessmentsInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {'url': payload.get('url'), }

        # Context
        self._context = None
        self._solution = {}

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: AssessmentsContext for this AssessmentsInstance
        :rtype: twilio.rest.flex_api.v1.assessments.AssessmentsContext
        """
        if self._context is None:
            self._context = AssessmentsContext(self._version, )
        return self._context

    @property
    def url(self):
        """
        :returns: The URL of this resource.
        :rtype: unicode
        """
        return self._properties['url']

    def create(self):
        """
        Create the AssessmentsInstance

        :returns: The created AssessmentsInstance
        :rtype: twilio.rest.flex_api.v1.assessments.AssessmentsInstance
        """
        return self._proxy.create()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.FlexApi.V1.AssessmentsInstance {}>'.format(context)
