# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import serialize
from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class InteractionChannelInviteList(ListResource):

    def __init__(self, version, interaction_sid, channel_sid):
        """
        Initialize the InteractionChannelInviteList

        :param Version version: Version that contains the resource
        :param interaction_sid: The Interaction SID for this Channel
        :param channel_sid: The Channel SID for this Invite

        :returns: twilio.rest.flex_api.v1.interaction.interaction_channel.interaction_channel_invite.InteractionChannelInviteList
        :rtype: twilio.rest.flex_api.v1.interaction.interaction_channel.interaction_channel_invite.InteractionChannelInviteList
        """
        super(InteractionChannelInviteList, self).__init__(version)

        # Path Solution
        self._solution = {'interaction_sid': interaction_sid, 'channel_sid': channel_sid, }
        self._uri = '/Interactions/{interaction_sid}/Channels/{channel_sid}/Invites'.format(**self._solution)

    def create(self, routing):
        """
        Create the InteractionChannelInviteInstance

        :param dict routing: The Interaction's routing logic

        :returns: The created InteractionChannelInviteInstance
        :rtype: twilio.rest.flex_api.v1.interaction.interaction_channel.interaction_channel_invite.InteractionChannelInviteInstance
        """
        data = values.of({'Routing': serialize.object(routing), })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return InteractionChannelInviteInstance(
            self._version,
            payload,
            interaction_sid=self._solution['interaction_sid'],
            channel_sid=self._solution['channel_sid'],
        )

    def stream(self, limit=None, page_size=None):
        """
        Streams InteractionChannelInviteInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.flex_api.v1.interaction.interaction_channel.interaction_channel_invite.InteractionChannelInviteInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'])

    def list(self, limit=None, page_size=None):
        """
        Lists InteractionChannelInviteInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.flex_api.v1.interaction.interaction_channel.interaction_channel_invite.InteractionChannelInviteInstance]
        """
        return list(self.stream(limit=limit, page_size=page_size, ))

    def page(self, page_token=values.unset, page_number=values.unset,
             page_size=values.unset):
        """
        Retrieve a single page of InteractionChannelInviteInstance records from the API.
        Request is executed immediately

        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of InteractionChannelInviteInstance
        :rtype: twilio.rest.flex_api.v1.interaction.interaction_channel.interaction_channel_invite.InteractionChannelInvitePage
        """
        data = values.of({'PageToken': page_token, 'Page': page_number, 'PageSize': page_size, })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return InteractionChannelInvitePage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of InteractionChannelInviteInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of InteractionChannelInviteInstance
        :rtype: twilio.rest.flex_api.v1.interaction.interaction_channel.interaction_channel_invite.InteractionChannelInvitePage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return InteractionChannelInvitePage(self._version, response, self._solution)

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FlexApi.V1.InteractionChannelInviteList>'


class InteractionChannelInvitePage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the InteractionChannelInvitePage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param interaction_sid: The Interaction SID for this Channel
        :param channel_sid: The Channel SID for this Invite

        :returns: twilio.rest.flex_api.v1.interaction.interaction_channel.interaction_channel_invite.InteractionChannelInvitePage
        :rtype: twilio.rest.flex_api.v1.interaction.interaction_channel.interaction_channel_invite.InteractionChannelInvitePage
        """
        super(InteractionChannelInvitePage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of InteractionChannelInviteInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.flex_api.v1.interaction.interaction_channel.interaction_channel_invite.InteractionChannelInviteInstance
        :rtype: twilio.rest.flex_api.v1.interaction.interaction_channel.interaction_channel_invite.InteractionChannelInviteInstance
        """
        return InteractionChannelInviteInstance(
            self._version,
            payload,
            interaction_sid=self._solution['interaction_sid'],
            channel_sid=self._solution['channel_sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FlexApi.V1.InteractionChannelInvitePage>'


class InteractionChannelInviteInstance(InstanceResource):

    class Action(object):
        ACCEPT = "accept"
        DECLINE = "decline"

    class Type(object):
        TASKROUTER = "taskrouter"

    def __init__(self, version, payload, interaction_sid, channel_sid):
        """
        Initialize the InteractionChannelInviteInstance

        :returns: twilio.rest.flex_api.v1.interaction.interaction_channel.interaction_channel_invite.InteractionChannelInviteInstance
        :rtype: twilio.rest.flex_api.v1.interaction.interaction_channel.interaction_channel_invite.InteractionChannelInviteInstance
        """
        super(InteractionChannelInviteInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'sid': payload.get('sid'),
            'interaction_sid': payload.get('interaction_sid'),
            'channel_sid': payload.get('channel_sid'),
            'routing': payload.get('routing'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {'interaction_sid': interaction_sid, 'channel_sid': channel_sid, }

    @property
    def sid(self):
        """
        :returns: The unique string that identifies the resource
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def interaction_sid(self):
        """
        :returns: The Interaction SID for this Channel
        :rtype: unicode
        """
        return self._properties['interaction_sid']

    @property
    def channel_sid(self):
        """
        :returns: The Channel SID for this Invite
        :rtype: unicode
        """
        return self._properties['channel_sid']

    @property
    def routing(self):
        """
        :returns: A JSON object representing the routing rules for the Interaction Channel
        :rtype: dict
        """
        return self._properties['routing']

    @property
    def url(self):
        """
        :returns: The url
        :rtype: unicode
        """
        return self._properties['url']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FlexApi.V1.InteractionChannelInviteInstance>'
