# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class UserRolesList(ListResource):

    def __init__(self, version):
        """
        Initialize the UserRolesList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.flex_api.v1.user_roles.UserRolesList
        :rtype: twilio.rest.flex_api.v1.user_roles.UserRolesList
        """
        super(UserRolesList, self).__init__(version)

        # Path Solution
        self._solution = {}

    def get(self):
        """
        Constructs a UserRolesContext

        :returns: twilio.rest.flex_api.v1.user_roles.UserRolesContext
        :rtype: twilio.rest.flex_api.v1.user_roles.UserRolesContext
        """
        return UserRolesContext(self._version, )

    def __call__(self):
        """
        Constructs a UserRolesContext

        :returns: twilio.rest.flex_api.v1.user_roles.UserRolesContext
        :rtype: twilio.rest.flex_api.v1.user_roles.UserRolesContext
        """
        return UserRolesContext(self._version, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FlexApi.V1.UserRolesList>'


class UserRolesPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the UserRolesPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.flex_api.v1.user_roles.UserRolesPage
        :rtype: twilio.rest.flex_api.v1.user_roles.UserRolesPage
        """
        super(UserRolesPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of UserRolesInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.flex_api.v1.user_roles.UserRolesInstance
        :rtype: twilio.rest.flex_api.v1.user_roles.UserRolesInstance
        """
        return UserRolesInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.FlexApi.V1.UserRolesPage>'


class UserRolesContext(InstanceContext):

    def __init__(self, version):
        """
        Initialize the UserRolesContext

        :param Version version: Version that contains the resource

        :returns: twilio.rest.flex_api.v1.user_roles.UserRolesContext
        :rtype: twilio.rest.flex_api.v1.user_roles.UserRolesContext
        """
        super(UserRolesContext, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/Accounts/UserRoles'.format(**self._solution)

    def fetch(self, token=values.unset):
        """
        Fetch the UserRolesInstance

        :param unicode token: The Token HTTP request header

        :returns: The fetched UserRolesInstance
        :rtype: twilio.rest.flex_api.v1.user_roles.UserRolesInstance
        """
        headers = values.of({'Token': token, })

        payload = self._version.fetch(method='GET', uri=self._uri, headers=headers, )

        return UserRolesInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.FlexApi.V1.UserRolesContext {}>'.format(context)


class UserRolesInstance(InstanceResource):

    def __init__(self, version, payload):
        """
        Initialize the UserRolesInstance

        :returns: twilio.rest.flex_api.v1.user_roles.UserRolesInstance
        :rtype: twilio.rest.flex_api.v1.user_roles.UserRolesInstance
        """
        super(UserRolesInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {'roles': payload.get('roles'), 'url': payload.get('url'), }

        # Context
        self._context = None
        self._solution = {}

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: UserRolesContext for this UserRolesInstance
        :rtype: twilio.rest.flex_api.v1.user_roles.UserRolesContext
        """
        if self._context is None:
            self._context = UserRolesContext(self._version, )
        return self._context

    @property
    def roles(self):
        """
        :returns: Flex Insights roles for the user
        :rtype: list[unicode]
        """
        return self._properties['roles']

    @property
    def url(self):
        """
        :returns: The url
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self, token=values.unset):
        """
        Fetch the UserRolesInstance

        :param unicode token: The Token HTTP request header

        :returns: The fetched UserRolesInstance
        :rtype: twilio.rest.flex_api.v1.user_roles.UserRolesInstance
        """
        return self._proxy.fetch(token=token, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.FlexApi.V1.UserRolesInstance {}>'.format(context)
