# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.version import Version
from twilio.rest.microvisor.v1.app import AppList
from twilio.rest.microvisor.v1.device import DeviceList


class V1(Version):

    def __init__(self, domain):
        """
        Initialize the V1 version of Microvisor

        :returns: V1 version of Microvisor
        :rtype: twilio.rest.microvisor.v1.V1.V1
        """
        super(V1, self).__init__(domain)
        self.version = 'v1'
        self._apps = None
        self._devices = None

    @property
    def apps(self):
        """
        :rtype: twilio.rest.microvisor.v1.app.AppList
        """
        if self._apps is None:
            self._apps = AppList(self)
        return self._apps

    @property
    def devices(self):
        """
        :rtype: twilio.rest.microvisor.v1.device.DeviceList
        """
        if self._devices is None:
            self._devices = DeviceList(self)
        return self._devices

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Microvisor.V1>'
