# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import values
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class TokenList(ListResource):

    def __init__(self, version):
        """
        Initialize the TokenList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.oauth.v1.token.TokenList
        :rtype: twilio.rest.oauth.v1.token.TokenList
        """
        super(TokenList, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/token'.format(**self._solution)

    def create(self, grant_type, client_sid, client_secret=values.unset,
               code=values.unset, code_verifier=values.unset,
               device_code=values.unset, refresh_token=values.unset,
               device_id=values.unset):
        """
        Create the TokenInstance

        :param unicode grant_type: A way of representing resource owner's to obtain access token
        :param unicode client_sid: A string that uniquely identifies this oauth app
        :param unicode client_secret: The credential for confidential OAuth App
        :param unicode code: Jwt token
        :param unicode code_verifier: The cryptographically generated code
        :param unicode device_code: Jwt token
        :param unicode refresh_token: Jwt token
        :param unicode device_id: An Id of device

        :returns: The created TokenInstance
        :rtype: twilio.rest.oauth.v1.token.TokenInstance
        """
        data = values.of({
            'GrantType': grant_type,
            'ClientSid': client_sid,
            'ClientSecret': client_secret,
            'Code': code,
            'CodeVerifier': code_verifier,
            'DeviceCode': device_code,
            'RefreshToken': refresh_token,
            'DeviceId': device_id,
        })

        payload = self._version.create(method='POST', uri=self._uri, data=data, )

        return TokenInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Oauth.V1.TokenList>'


class TokenPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the TokenPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.oauth.v1.token.TokenPage
        :rtype: twilio.rest.oauth.v1.token.TokenPage
        """
        super(TokenPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of TokenInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.oauth.v1.token.TokenInstance
        :rtype: twilio.rest.oauth.v1.token.TokenInstance
        """
        return TokenInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Oauth.V1.TokenPage>'


class TokenInstance(InstanceResource):

    def __init__(self, version, payload):
        """
        Initialize the TokenInstance

        :returns: twilio.rest.oauth.v1.token.TokenInstance
        :rtype: twilio.rest.oauth.v1.token.TokenInstance
        """
        super(TokenInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'access_token': payload.get('access_token'),
            'refresh_token': payload.get('refresh_token'),
            'id_token': payload.get('id_token'),
            'refresh_token_expires_at': deserialize.iso8601_datetime(payload.get('refresh_token_expires_at')),
            'access_token_expires_at': deserialize.iso8601_datetime(payload.get('access_token_expires_at')),
        }

        # Context
        self._context = None
        self._solution = {}

    @property
    def access_token(self):
        """
        :returns: Token which carries the necessary information to access a Twilio resource directly
        :rtype: unicode
        """
        return self._properties['access_token']

    @property
    def refresh_token(self):
        """
        :returns: Token which carries the information necessary to get a new access token
        :rtype: unicode
        """
        return self._properties['refresh_token']

    @property
    def id_token(self):
        """
        :returns: The id_token
        :rtype: unicode
        """
        return self._properties['id_token']

    @property
    def refresh_token_expires_at(self):
        """
        :returns: The RFC 2822 date and time in GMT when the refresh token expires
        :rtype: datetime
        """
        return self._properties['refresh_token_expires_at']

    @property
    def access_token_expires_at(self):
        """
        :returns: The RFC 2822 date and time in GMT when the access token expires
        :rtype: datetime
        """
        return self._properties['access_token_expires_at']

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Oauth.V1.TokenInstance>'
