# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class UserInfoList(ListResource):

    def __init__(self, version):
        """
        Initialize the UserInfoList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.oauth.v1.user_info.UserInfoList
        :rtype: twilio.rest.oauth.v1.user_info.UserInfoList
        """
        super(UserInfoList, self).__init__(version)

        # Path Solution
        self._solution = {}

    def get(self):
        """
        Constructs a UserInfoContext

        :returns: twilio.rest.oauth.v1.user_info.UserInfoContext
        :rtype: twilio.rest.oauth.v1.user_info.UserInfoContext
        """
        return UserInfoContext(self._version, )

    def __call__(self):
        """
        Constructs a UserInfoContext

        :returns: twilio.rest.oauth.v1.user_info.UserInfoContext
        :rtype: twilio.rest.oauth.v1.user_info.UserInfoContext
        """
        return UserInfoContext(self._version, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Oauth.V1.UserInfoList>'


class UserInfoPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the UserInfoPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.oauth.v1.user_info.UserInfoPage
        :rtype: twilio.rest.oauth.v1.user_info.UserInfoPage
        """
        super(UserInfoPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of UserInfoInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.oauth.v1.user_info.UserInfoInstance
        :rtype: twilio.rest.oauth.v1.user_info.UserInfoInstance
        """
        return UserInfoInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Oauth.V1.UserInfoPage>'


class UserInfoContext(InstanceContext):

    def __init__(self, version):
        """
        Initialize the UserInfoContext

        :param Version version: Version that contains the resource

        :returns: twilio.rest.oauth.v1.user_info.UserInfoContext
        :rtype: twilio.rest.oauth.v1.user_info.UserInfoContext
        """
        super(UserInfoContext, self).__init__(version)

        # Path Solution
        self._solution = {}
        self._uri = '/userinfo'.format(**self._solution)

    def fetch(self):
        """
        Fetch the UserInfoInstance

        :returns: The fetched UserInfoInstance
        :rtype: twilio.rest.oauth.v1.user_info.UserInfoInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return UserInfoInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Oauth.V1.UserInfoContext {}>'.format(context)


class UserInfoInstance(InstanceResource):

    def __init__(self, version, payload):
        """
        Initialize the UserInfoInstance

        :returns: twilio.rest.oauth.v1.user_info.UserInfoInstance
        :rtype: twilio.rest.oauth.v1.user_info.UserInfoInstance
        """
        super(UserInfoInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'user_sid': payload.get('user_sid'),
            'first_name': payload.get('first_name'),
            'last_name': payload.get('last_name'),
            'friendly_name': payload.get('friendly_name'),
            'email': payload.get('email'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {}

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: UserInfoContext for this UserInfoInstance
        :rtype: twilio.rest.oauth.v1.user_info.UserInfoContext
        """
        if self._context is None:
            self._context = UserInfoContext(self._version, )
        return self._context

    @property
    def user_sid(self):
        """
        :returns: The user sid
        :rtype: unicode
        """
        return self._properties['user_sid']

    @property
    def first_name(self):
        """
        :returns: The first name of the end-user
        :rtype: unicode
        """
        return self._properties['first_name']

    @property
    def last_name(self):
        """
        :returns: The last name of the end-user
        :rtype: unicode
        """
        return self._properties['last_name']

    @property
    def friendly_name(self):
        """
        :returns: The friendly name of the end-user
        :rtype: unicode
        """
        return self._properties['friendly_name']

    @property
    def email(self):
        """
        :returns: The end-user's preferred email address
        :rtype: unicode
        """
        return self._properties['email']

    @property
    def url(self):
        """
        :returns: The url
        :rtype: unicode
        """
        return self._properties['url']

    def fetch(self):
        """
        Fetch the UserInfoInstance

        :returns: The fetched UserInfoInstance
        :rtype: twilio.rest.oauth.v1.user_info.UserInfoInstance
        """
        return self._proxy.fetch()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Oauth.V1.UserInfoInstance {}>'.format(context)
