# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base.version import Version
from twilio.rest.routes.v2.phone_number import PhoneNumberList
from twilio.rest.routes.v2.sip_domain import SipDomainList
from twilio.rest.routes.v2.trunk import TrunkList


class V2(Version):

    def __init__(self, domain):
        """
        Initialize the V2 version of Routes

        :returns: V2 version of Routes
        :rtype: twilio.rest.routes.v2.V2.V2
        """
        super(V2, self).__init__(domain)
        self.version = 'v2'
        self._phone_numbers = None
        self._sip_domains = None
        self._trunks = None

    @property
    def phone_numbers(self):
        """
        :rtype: twilio.rest.routes.v2.phone_number.PhoneNumberList
        """
        if self._phone_numbers is None:
            self._phone_numbers = PhoneNumberList(self)
        return self._phone_numbers

    @property
    def sip_domains(self):
        """
        :rtype: twilio.rest.routes.v2.sip_domain.SipDomainList
        """
        if self._sip_domains is None:
            self._sip_domains = SipDomainList(self)
        return self._sip_domains

    @property
    def trunks(self):
        """
        :rtype: twilio.rest.routes.v2.trunk.TrunkList
        """
        if self._trunks is None:
            self._trunks = TrunkList(self)
        return self._trunks

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Routes.V2>'
