# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2018-04-17 12:26


import aparnik.contrib.users.models
import aparnik.utils.fields
from django.conf import settings
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0008_alter_user_username_max_length'),
        ('province', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('sys_id', models.AutoField(primary_key=True, serialize=False, verbose_name='System ID')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, verbose_name='UUID')),
                ('username', aparnik.utils.fields.PhoneField(max_length=11, unique=True, validators=[django.core.validators.RegexValidator(code=b'nomatch', message='phone is not valid, please insert with code', regex=b'^0(?!0)\\d{2}([0-9]{8})$')], verbose_name='Mobile')),
                ('email', models.EmailField(blank=True, max_length=254, null=True, verbose_name='Email')),
                ('first_name', models.CharField(blank=True, max_length=12, null=True, verbose_name='Name')),
                ('last_name', models.CharField(blank=True, max_length=30, null=True, verbose_name='Family')),
                ('sex', models.CharField(choices=[('M', '\\u0645\\u0631\\u062f'), ('F', '\\u0632\\u0646')], default='M', max_length=1, verbose_name='Sex')),
                ('avatar', models.ImageField(blank=True, null=True, upload_to='file', verbose_name='Avatar')),
                ('birthdate', models.DateTimeField(blank=True, null=True, verbose_name='Birthdate')),
                ('is_staff', models.BooleanField(default=False, verbose_name='Is Staff')),
                ('is_active', models.BooleanField(default=True, verbose_name='Is Active')),
                ('token', models.CharField(blank=True, max_length=4, null=True, verbose_name='Token')),
                ('token_time', models.DateTimeField(blank=True, null=True, verbose_name='Token Time')),
                ('limit_device_login', models.PositiveIntegerField(default=0, help_text='If the number is set to 0, then the value in the settings will apply', verbose_name='Limit device login')),
                ('invitation_code', models.CharField(blank=True, editable=False, max_length=36, null=True, verbose_name='Invitation Code')),
                ('current_city', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='province.City', verbose_name='Current City')),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions')),
            ],
            options={
                'verbose_name': 'User',
                'verbose_name_plural': 'Users',
            },
        ),
        migrations.CreateModel(
            name='DeviceLogin',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('version_number', models.FloatField(verbose_name='Version Number')),
                ('device_id', models.CharField(max_length=255, verbose_name='Device Id')),
                ('os_version', models.CharField(max_length=255, verbose_name='OS Version')),
                ('device_model', models.CharField(max_length=255, verbose_name='Device Model')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('update_at', models.DateTimeField(auto_now=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='aparnik_users.User', verbose_name='User')),
            ],
        ),
    ]
