#!/usr/bin/env python3

# This source code is licensed under the license found in the
# LICENSE file in the root directory of this source tree.

from setuptools import setup, find_packages
import os

root_dir = os.path.dirname(__file__)

REQUIRES = [
"asttokens==2.2.0",
"autopep8==2.0.0",
"backcall==0.2.0",
"bleach==5.0.1",
"build==0.9.0",
"certifi==2022.9.24",
"cffi==1.15.1",
"charset-normalizer==2.1.1",
"commonmark==0.9.1",
"contourpy==1.0.6",
"cryptography==38.0.4",
"cycler==0.11.0",
"debugpy==1.6.4",
"decorator==5.1.1",
"docutils==0.19",
"entrypoints==0.4",
"executing==1.2.0",
"fonttools==4.38.0",
"idna==3.4",
"importlib-metadata==5.1.0",
"ipykernel==6.17.1",
"ipython==8.7.0",
"jaraco.classes==3.2.3",
"jedi==0.18.2",
"jeepney==0.8.0",
"joblib==1.2.0",
"jupyter_client==7.4.7",
"jupyter_core==5.1.0",
"keyring==23.11.0",
"kiwisolver==1.4.4",
"matplotlib==3.6.2",
"matplotlib-inline==0.1.6",
"more-itertools==9.0.0",
"nest-asyncio==1.5.6",
"numpy==1.23.5",
"packaging==21.3",
"pandas==1.5.2",
"parso==0.8.3",
"pep517==0.13.0",
"pexpect==4.8.0",
"pickleshare==0.7.5",
"Pillow==9.3.0",
"pkg_resources==0.0.0",
"pkginfo==1.9.2",
"platformdirs==2.5.4",
"prompt-toolkit==3.0.33",
"psutil==5.9.4",
"ptyprocess==0.7.0",
"pure-eval==0.2.2",
"pycodestyle==2.10.0",
"pycparser==2.21",
"Pygments==2.13.0",
"pyparsing==3.0.9",
"python-dateutil==2.8.2",
"pytz==2022.6",
"pyzmq==24.0.1",
"readme-renderer==37.3",
"requests==2.28.1",
"requests-toolbelt==0.10.1",
"rfc3986==2.0.0",
"rich==12.6.0",
"scikit-learn==1.1.3",
"scipy==1.9.3",
"seaborn==0.12.1",
"SecretStorage==3.3.3",
"six==1.16.0",
"stack-data==0.6.2",
"threadpoolctl==3.1.0",
"tomli==2.0.1",
"tornado==6.2",
"traitlets==5.6.0",
"twine==4.0.2",
"typing_extensions==4.4.0",
"urllib3==1.26.13",
"wcwidth==0.2.5",
"webencodings==0.5.1",
"wget==3.2",
"zipp==3.11.0",
]

with open(os.path.join(root_dir, "README.md"), "r") as fh:
    long_description = fh.read()

setup(
    name="unblind",
    version="0.0.1",
    python_requires=">=3.8",
    description="Unblind is a Python package to create data visualizations from data of the Plataforma Digital Nacional, Sistema Nacional Anticorrupción",
    long_description=long_description,
    long_description_content_type="text/markdown",
    install_requires=REQUIRES,
    package_dir={'': './unblind'},
)
